(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define(["require", "exports", "vscode-languageserver-types", "./services/jsonCompletion", "./services/jsonHover", "./services/jsonValidation", "./services/jsonDocumentSymbols", "./parser/jsonParser", "./services/configuration", "./services/jsonSchemaService", "./services/jsonFormatter"], factory);
    }
})(function (require, exports) {
    /*---------------------------------------------------------------------------------------------
     *  Copyright (c) Microsoft Corporation. All rights reserved.
     *  Licensed under the MIT License. See License.txt in the project root for license information.
     *--------------------------------------------------------------------------------------------*/
    'use strict';
    var vscode_languageserver_types_1 = require("vscode-languageserver-types");
    exports.TextDocument = vscode_languageserver_types_1.TextDocument;
    exports.Position = vscode_languageserver_types_1.Position;
    exports.CompletionItem = vscode_languageserver_types_1.CompletionItem;
    exports.CompletionList = vscode_languageserver_types_1.CompletionList;
    exports.Range = vscode_languageserver_types_1.Range;
    exports.SymbolInformation = vscode_languageserver_types_1.SymbolInformation;
    exports.Diagnostic = vscode_languageserver_types_1.Diagnostic;
    exports.TextEdit = vscode_languageserver_types_1.TextEdit;
    exports.FormattingOptions = vscode_languageserver_types_1.FormattingOptions;
    exports.MarkedString = vscode_languageserver_types_1.MarkedString;
    var jsonCompletion_1 = require("./services/jsonCompletion");
    var jsonHover_1 = require("./services/jsonHover");
    var jsonValidation_1 = require("./services/jsonValidation");
    var jsonDocumentSymbols_1 = require("./services/jsonDocumentSymbols");
    var jsonParser_1 = require("./parser/jsonParser");
    var configuration_1 = require("./services/configuration");
    var jsonSchemaService_1 = require("./services/jsonSchemaService");
    var jsonFormatter_1 = require("./services/jsonFormatter");
    function getLanguageService(params) {
        var promise = params.promiseConstructor || Promise;
        var jsonSchemaService = new jsonSchemaService_1.JSONSchemaService(params.schemaRequestService, params.workspaceContext, promise);
        jsonSchemaService.setSchemaContributions(configuration_1.schemaContributions);
        var jsonCompletion = new jsonCompletion_1.JSONCompletion(jsonSchemaService, params.contributions, promise);
        var jsonHover = new jsonHover_1.JSONHover(jsonSchemaService, params.contributions, promise);
        var jsonDocumentSymbols = new jsonDocumentSymbols_1.JSONDocumentSymbols(jsonSchemaService);
        var jsonValidation = new jsonValidation_1.JSONValidation(jsonSchemaService, promise);
        var disallowComments = false;
        return {
            configure: function (settings) {
                jsonSchemaService.clearExternalSchemas();
                if (settings.schemas) {
                    settings.schemas.forEach(function (settings) {
                        jsonSchemaService.registerExternalSchema(settings.uri, settings.fileMatch, settings.schema);
                    });
                }
                ;
                jsonValidation.configure(settings);
                disallowComments = settings && !settings.allowComments;
            },
            resetSchema: function (uri) { return jsonSchemaService.onResourceChange(uri); },
            doValidation: jsonValidation.doValidation.bind(jsonValidation),
            parseJSONDocument: function (document) { return jsonParser_1.parse(document.getText(), { disallowComments: disallowComments }); },
            doResolve: jsonCompletion.doResolve.bind(jsonCompletion),
            doComplete: jsonCompletion.doComplete.bind(jsonCompletion),
            findDocumentSymbols: jsonDocumentSymbols.findDocumentSymbols.bind(jsonDocumentSymbols),
            findColorSymbols: jsonDocumentSymbols.findColorSymbols.bind(jsonDocumentSymbols),
            doHover: jsonHover.doHover.bind(jsonHover),
            format: jsonFormatter_1.format
        };
    }
    exports.getLanguageService = getLanguageService;
});
//# sourceMappingURL=jsonLanguageService.js.map