/*---------------------------------------------------------
 * Copyright (C) Microsoft Corporation. All rights reserved.
 *--------------------------------------------------------*/
"use strict";
const utils_1 = require("./utils");
function attributePathNotExist(attribute, path) {
    return {
        id: 2007,
        format: utils_1.localize('attribute.path.not.exist', "Attribute '{0}' does not exist ('{1}').", attribute, '{path}'),
        variables: { path }
    };
}
exports.attributePathNotExist = attributePathNotExist;
/**
 * Error stating that a relative path should be absolute
 */
function attributePathRelative(attribute, path) {
    return withInfoLink(2008, utils_1.localize('attribute.path.not.absolute', "Attribute '{0}' is not absolute ('{1}'); consider adding '{2}' as a prefix to make it absolute.", attribute, '{path}', '${workspaceRoot}/'), { path }, 20003);
}
exports.attributePathRelative = attributePathRelative;
/**
 * Get error with 'More Information' link.
 */
function withInfoLink(id, format, variables, infoId) {
    return {
        id,
        format,
        variables,
        showUser: true,
        url: 'http://go.microsoft.com/fwlink/?linkID=534832#_' + infoId.toString(),
        urlLabel: utils_1.localize('more.information', "More Information")
    };
}
exports.withInfoLink = withInfoLink;
function setValueNotSupported() {
    return {
        id: 2004,
        format: utils_1.localize('setVariable.error', "Setting value not supported")
    };
}
exports.setValueNotSupported = setValueNotSupported;
function errorFromEvaluate(errMsg) {
    return {
        id: 2025,
        format: errMsg
    };
}
exports.errorFromEvaluate = errorFromEvaluate;
function sourceRequestIllegalHandle() {
    return {
        id: 2027,
        format: 'sourceRequest error: illegal handle',
        sendTelemetry: true
    };
}
exports.sourceRequestIllegalHandle = sourceRequestIllegalHandle;
function pathFormat() {
    return {
        id: 2018,
        format: 'debug adapter only supports native paths',
        sendTelemetry: true
    };
}
exports.pathFormat = pathFormat;
function runtimeConnectionTimeout(timeoutMs, errMsg) {
    return {
        id: 2010,
        format: utils_1.localize('VSND2010', "Cannot connect to runtime process, timeout after {0} ms - (reason: {1}).", '{_timeout}', '{_error}'),
        variables: { _error: errMsg, _timeout: timeoutMs + '' }
    };
}
exports.runtimeConnectionTimeout = runtimeConnectionTimeout;
function completionsStackFrameNotValid() {
    return {
        id: 2020,
        format: 'stack frame not valid',
        sendTelemetry: true
    };
}
exports.completionsStackFrameNotValid = completionsStackFrameNotValid;

//# sourceMappingURL=errors.js.map
