/*---------------------------------------------------------
 * Copyright (C) Microsoft Corporation. All rights reserved.
 *--------------------------------------------------------*/
"use strict";
const vscode_debugadapter_1 = require("vscode-debugadapter");
let sendEvent;
function reportEvent(name, data) {
    // https://github.com/Microsoft/vscode-debugadapter-node/pull/77
    const event = new vscode_debugadapter_1.OutputEvent(name, 'telemetry');
    event.body.data = data;
    if (sendEvent)
        sendEvent(event);
}
exports.reportEvent = reportEvent;
function setupEventHandler(_sendEvent) {
    sendEvent = _sendEvent;
}
exports.setupEventHandler = setupEventHandler;

//# sourceMappingURL=telemetry.js.map
