/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var Logger = require('./logger');
var logger = Logger.logger;
var debugSession_1 = require('./debugSession');
var LoggingDebugSession = (function (_super) {
    __extends(LoggingDebugSession, _super);
    function LoggingDebugSession(_logFilePath, obsolete_debuggerLinesAndColumnsStartAt1, obsolete_isServer) {
        _super.call(this, obsolete_debuggerLinesAndColumnsStartAt1, obsolete_isServer);
        this._logFilePath = _logFilePath;
    }
    LoggingDebugSession.prototype.start = function (inStream, outStream) {
        var _this = this;
        _super.prototype.start.call(this, inStream, outStream);
        logger.init(function (e) { return _this.sendEvent(e); }, this._logFilePath, this._isServer);
    };
    /**
     * Overload sendEvent to log
     */
    LoggingDebugSession.prototype.sendEvent = function (event) {
        if (!(event instanceof Logger.LogOutputEvent)) {
            // Don't create an infinite loop...
            logger.verbose("To client: " + JSON.stringify(event));
        }
        _super.prototype.sendEvent.call(this, event);
    };
    /**
     * Overload sendRequest to log
     */
    LoggingDebugSession.prototype.sendRequest = function (command, args, timeout, cb) {
        logger.verbose("To client: " + JSON.stringify(command) + "(" + JSON.stringify(args) + "), timeout: " + timeout);
        _super.prototype.sendRequest.call(this, command, args, timeout, cb);
    };
    /**
     * Overload sendResponse to log
     */
    LoggingDebugSession.prototype.sendResponse = function (response) {
        logger.verbose("To client: " + JSON.stringify(response));
        _super.prototype.sendResponse.call(this, response);
    };
    LoggingDebugSession.prototype.dispatchRequest = function (request) {
        logger.verbose("From client: " + request.command + "(" + JSON.stringify(request.arguments) + ")");
        _super.prototype.dispatchRequest.call(this, request);
    };
    return LoggingDebugSession;
}(debugSession_1.DebugSession));
exports.LoggingDebugSession = LoggingDebugSession;
//# sourceMappingURL=data:application/json;base64,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