/*---------------------------------------------------------
 * Copyright (C) Microsoft Corporation. All rights reserved.
 *--------------------------------------------------------*/
"use strict";
const vscode_debugadapter_1 = require("vscode-debugadapter");
const nls = require("vscode-nls");
const localize = nls.config(process.env.VSCODE_NLS_CONFIG)(__filename);
class StoppedEvent2 extends vscode_debugadapter_1.StoppedEvent {
    constructor(reason, threadId, exception_text) {
        super(reason, threadId, exception_text);
        switch (reason) {
            case 'step':
                this.body.description = localize(0, null);
                break;
            case 'breakpoint':
                this.body.description = localize(1, null);
                break;
            case 'exception':
                this.body.description = localize(2, null);
                break;
            case 'pause':
                this.body.description = localize(3, null);
                break;
            case 'entry':
                this.body.description = localize(4, null);
                break;
            case 'debugger_statement':
                this.body.description = localize(5, null);
                break;
            case 'frame_entry':
                this.body.description = localize(6, null);
                break;
            case 'promise_rejection':
                this.body.description = localize(7, null);
                this.body.reason = 'exception';
                break;
            default:
                this.body.description = 'Unknown pause reason';
                break;
        }
    }
}
exports.StoppedEvent2 = StoppedEvent2;

//# sourceMappingURL=stoppedEvent.js.map
