/*---------------------------------------------------------
 * Copyright (C) Microsoft Corporation. All rights reserved.
 *--------------------------------------------------------*/
"use strict";
const nls = require("vscode-nls");
const localize = nls.config(process.env.VSCODE_NLS_CONFIG)(__filename);
exports.evalNotAvailableMsg = localize(0, null);
exports.runtimeNotConnectedMsg = localize(1, null);
exports.noRestartFrame = localize(2, null);
function attributePathNotExist(attribute, path) {
    return {
        id: 2007,
        format: localize(3, null, attribute, '{path}'),
        variables: { path }
    };
}
exports.attributePathNotExist = attributePathNotExist;
/**
 * Error stating that a relative path should be absolute
 */
function attributePathRelative(attribute, path) {
    return withInfoLink(2008, localize(4, null, attribute, '{path}', '${workspaceRoot}/'), { path }, 20003);
}
exports.attributePathRelative = attributePathRelative;
/**
 * Get error with 'More Information' link.
 */
function withInfoLink(id, format, variables, infoId) {
    return {
        id,
        format,
        variables,
        showUser: true,
        url: 'http://go.microsoft.com/fwlink/?linkID=534832#_' + infoId.toString(),
        urlLabel: localize(5, null)
    };
}
exports.withInfoLink = withInfoLink;
function setValueNotSupported() {
    return {
        id: 2004,
        format: localize(6, null)
    };
}
exports.setValueNotSupported = setValueNotSupported;
function errorFromEvaluate(errMsg) {
    return {
        id: 2025,
        format: errMsg
    };
}
exports.errorFromEvaluate = errorFromEvaluate;
function sourceRequestIllegalHandle() {
    return {
        id: 2027,
        format: 'sourceRequest error: illegal handle',
        sendTelemetry: true
    };
}
exports.sourceRequestIllegalHandle = sourceRequestIllegalHandle;
function sourceRequestCouldNotRetrieveContent() {
    return {
        id: 2026,
        format: localize(7, null)
    };
}
exports.sourceRequestCouldNotRetrieveContent = sourceRequestCouldNotRetrieveContent;
function pathFormat() {
    return {
        id: 2018,
        format: 'debug adapter only supports native paths',
        sendTelemetry: true
    };
}
exports.pathFormat = pathFormat;
function runtimeConnectionTimeout(timeoutMs, errMsg) {
    return {
        id: 2010,
        format: localize(8, null, '{_timeout}', '{_error}'),
        variables: { _error: errMsg, _timeout: timeoutMs + '' }
    };
}
exports.runtimeConnectionTimeout = runtimeConnectionTimeout;
function stackFrameNotValid() {
    return {
        id: 2020,
        format: 'stack frame not valid',
        sendTelemetry: true
    };
}
exports.stackFrameNotValid = stackFrameNotValid;
function noCallStackAvailable() {
    return {
        id: 2023,
        format: localize(9, null)
    };
}
exports.noCallStackAvailable = noCallStackAvailable;
function invalidThread(threadId) {
    return {
        id: 2030,
        format: 'Invalid thread {_thread}',
        variables: { _thread: threadId + '' },
        sendTelemetry: true
    };
}
exports.invalidThread = invalidThread;
function exceptionInfoRequestError() {
    return {
        id: 2031,
        format: 'exceptionInfoRequest error',
        sendTelemetry: true
    };
}
exports.exceptionInfoRequestError = exceptionInfoRequestError;
function noStoredException() {
    return {
        id: 2032,
        format: 'exceptionInfoRequest error: no stored exception',
        sendTelemetry: true
    };
}
exports.noStoredException = noStoredException;

//# sourceMappingURL=errors.js.map
