/*---------------------------------------------------------
 * Copyright (C) Microsoft Corporation. All rights reserved.
 *--------------------------------------------------------*/
"use strict";
const vscode_debugadapter_1 = require("vscode-debugadapter");
class TelemetryReporter {
    reportEvent(name, data) {
        if (this._sendEvent) {
            const event = new vscode_debugadapter_1.OutputEvent(name, 'telemetry', data);
            this._sendEvent(event);
        }
    }
    setupEventHandler(_sendEvent) {
        this._sendEvent = _sendEvent;
    }
}
exports.TelemetryReporter = TelemetryReporter;
class NullTelemetryReporter {
    reportEvent(name, data) {
        // no-op
    }
    setupEventHandler(_sendEvent) {
        // no-op
    }
}
exports.NullTelemetryReporter = NullTelemetryReporter;
exports.telemetry = new TelemetryReporter();

//# sourceMappingURL=telemetry.js.map
