export declare const STAND_ALONE_URL: string;
export declare const VERSION_CONFIG_URL: string;
export declare const DEFAULT_NAME: string;
export declare const DEFAULT_APP_NAME: string;
export declare const DEFAULT_PACKAGE_NAME: string;
export declare const DEFAULT_TYPE: number;
export declare const NATIVE_JSON_FILE_NAME: string;
export declare const PLATFORM_ANDROID_ALL: string;
export declare const PLATFORM_IOS: string;
export declare const PLATFORM_ANDROID_ECLIPSE: string;
export declare const PLATFORM_ANDROID_STUDIO: string;
export declare const H5_PROJECT_CONFIG_FILE: string;
export declare class AppCommand {
    constructor();
    excuteRefreshRes(folder: string, url: string, appPath: string): boolean;
    excuteRemoveRes(appPath: string): boolean;
    excuteCreateApp(folder: string, sdk: string, platform: string, type: number, url: string, name: string, app_name: string, package_name: string, outputPath: string): boolean;
    private processUrl(config, type, url, appPath);
    private processPackageName(config, package_name, appPath);
    private processDcc(config, folder, url, appPath);
    private processDisplayName(config, platform, app_name, appPath);
    private processName(config, name, appPath);
    static getAppPath(dir: string, platform: string): string;
    static getNativeJSONPath(dir: string): string;
    static getNativePath(dir: string): string;
    static isH5Folder(folder: string): boolean;
    static getH5BinFolder(folder: string): string;
    static getResFolder(folder: string): string;
    static getAppDataPath(): string;
    static getSDKRootPath(): string;
    static getSDKPath(version: string): string;
    static isSDKExists(version: string): boolean;
    private read(path);
}
export declare function getServerJSONConfig(url?: string): Promise<any>;
export declare function download(url: string, file: string, callBack: () => void): Promise<boolean>;
export declare function unzip(unzipurl: string, filepath: string, callbackHandler: any): Promise<void>;
