/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
module.exports = (function() {
    if (process.platform === 'win32') {
        return require('./build/Release/vsda_win32');
    }

    if (process.platform === 'darwin') {
        return require('./build/Release/vsda_darwin');
    }

    if (process.platform === 'linux') {
        if (process.arch === 'x64') {
            return require('./build/Release/vsda_linux64');
        }

        return require('./build/Release/vsda_linux32');
    }
})();