var window = window || global;
var document = document || (window.document = {});
/***********************************/
/*http://www.layabox.com 2017/01/16*/
/***********************************/
var Laya=window.Laya=(function(window,document){
	var Laya={
		__internals:[],
		__packages:{},
		__classmap:{'Object':Object,'Function':Function,'Array':Array,'String':String},
		__sysClass:{'object':'Object','array':'Array','string':'String','dictionary':'Dictionary'},
		__propun:{writable: true,enumerable: false,configurable: true},
		__presubstr:String.prototype.substr,
		__substr:function(ofs,sz){return arguments.length==1?Laya.__presubstr.call(this,ofs):Laya.__presubstr.call(this,ofs,sz>0?sz:(this.length+sz));},
		__init:function(_classs){_classs.forEach(function(o){o.__init$ && o.__init$();});},
		__isClass:function(o){return o && (o.__isclass || o==Object || o==String || o==Array);},
		__newvec:function(sz,value){
			var d=[];
			d.length=sz;
			for(var i=0;i<sz;i++) d[i]=value;
			return d;
		},
		__extend:function(d,b){
			for (var p in b){
				if (!b.hasOwnProperty(p)) continue;
				var gs=Object.getOwnPropertyDescriptor(b, p);
				var g = gs.get, s = gs.set; 
				if ( g || s ) {
					if ( g && s)
						Object.defineProperty(d,p,gs);
					else{
						g && Object.defineProperty(d, p, g);
						s && Object.defineProperty(d, p, s);
					}
				}
				else d[p] = b[p];
			}
			function __() { Laya.un(this,'constructor',d); }__.prototype=b.prototype;d.prototype=new __();Laya.un(d.prototype,'__imps',Laya.__copy({},b.prototype.__imps));
		},
		__copy:function(dec,src){
			if(!src) return null;
			dec=dec||{};
			for(var i in src) dec[i]=src[i];
			return dec;
		},
		__package:function(name,o){
			if(Laya.__packages[name]) return;
			Laya.__packages[name]=true;
			var p=window,strs=name.split('.');
			if(strs.length>1){
				for(var i=0,sz=strs.length-1;i<sz;i++){
					var c=p[strs[i]];
					p=c?c:(p[strs[i]]={});
				}
			}
			p[strs[strs.length-1]] || (p[strs[strs.length-1]]=o||{});
		},
		__hasOwnProperty:function(name,o){
			o=o ||this;
		    function classHas(name,o){
				if(Object.hasOwnProperty.call(o.prototype,name)) return true;
				var s=o.prototype.__super;
				return s==null?null:classHas(name,s);
			}
			return (Object.hasOwnProperty.call(o,name)) || classHas(name,o.__class);
		},
		__typeof:function(o,value){
			if(!o || !value) return false;
			if(value===String) return (typeof o==='string');
			if(value===Number) return (typeof o==='number');
			if(value.__interface__) value=value.__interface__;
			else if(typeof value!='string')  return (o instanceof value);
			return (o.__imps && o.__imps[value]) || (o.__class==value);
		},
		__as:function(value,type){
			return (this.__typeof(value,type))?value:null;
		},		
		interface:function(name,_super){
			Laya.__package(name,{});
			var ins=Laya.__internals;
			var a=ins[name]=ins[name] || {self:name};
			if(_super)
			{
				var supers=_super.split(',');
				a.extend=[];
				for(var i=0;i<supers.length;i++){
					var nm=supers[i];
					ins[nm]=ins[nm] || {self:nm};
					a.extend.push(ins[nm]);
				}
			}
			var o=window,words=name.split('.');
			for(var i=0;i<words.length-1;i++) o=o[words[i]];
			o[words[words.length-1]]={__interface__:name};
		},
		class:function(o,fullName,_super,miniName){
			_super && Laya.__extend(o,_super);
			if(fullName){
				Laya.__package(fullName,o);
				Laya.__classmap[fullName]=o;
				if(fullName.indexOf('.')>0){
					if(fullName.indexOf('laya.')==0){
						var paths=fullName.split('.');
						miniName=miniName || paths[paths.length-1];
						if(Laya[miniName]) console.log("Warning!,this class["+miniName+"] already exist:",Laya[miniName]);
						Laya[miniName]=o;
					}
				}
				else {
					if(fullName=="Main")
						window.Main=o;
					else{
						if(Laya[fullName]){
							console.log("Error!,this class["+fullName+"] already exist:",Laya[fullName]);
						}
						Laya[fullName]=o;
					}
				}
			}
			var un=Laya.un,p=o.prototype;
			un(p,'hasOwnProperty',Laya.__hasOwnProperty);
			un(p,'__class',o);
			un(p,'__super',_super);
			un(p,'__className',fullName);
			un(o,'__super',_super);
			un(o,'__className',fullName);
			un(o,'__isclass',true);
			un(o,'super',function(o){this.__super.call(o);});
		},
		imps:function(dec,src){
			if(!src) return null;
			var d=dec.__imps|| Laya.un(dec,'__imps',{});
			function __(name){
				var c,exs;
				if(! (c=Laya.__internals[name]) ) return;
				d[name]=true;
				if(!(exs=c.extend)) return;
				for(var i=0;i<exs.length;i++){
					__(exs[i].self);
				}
			}
			for(var i in src) __(i);
		},
		getset:function(isStatic,o,name,getfn,setfn){
			if(!isStatic){
				getfn && Laya.un(o,'_$get_'+name,getfn);
				setfn && Laya.un(o,'_$set_'+name,setfn);
			}
			else{
				getfn && (o['_$GET_'+name]=getfn);
				setfn && (o['_$SET_'+name]=setfn);
			}
			if(getfn && setfn) 
				Object.defineProperty(o,name,{get:getfn,set:setfn,enumerable:false});
			else{
				getfn && Object.defineProperty(o,name,{get:getfn,enumerable:false});
				setfn && Object.defineProperty(o,name,{set:setfn,enumerable:false});
			}
		},
		static:function(_class,def){
				for(var i=0,sz=def.length;i<sz;i+=2){
					if(def[i]=='length') 
						_class.length=def[i+1].call(_class);
					else{
						function tmp(){
							var name=def[i];
							var getfn=def[i+1];
							Object.defineProperty(_class,name,{
								get:function(){delete this[name];return this[name]=getfn.call(this);},
								set:function(v){delete this[name];this[name]=v;},enumerable: true,configurable: true});
						}
						tmp();
					}
				}
		},		
		un:function(obj,name,value){
			value || (value=obj[name]);
			Laya.__propun.value=value;
			Object.defineProperty(obj, name, Laya.__propun);
			return value;
		},
		uns:function(obj,names){
			names.forEach(function(o){Laya.un(obj,o)});
		}
	};

	window.console=window.console || ({log:function(){}});
	window.trace=window.console.log;
	Error.prototype.throwError=function(){throw arguments;};
	String.prototype.substr=Laya.__substr;
	Object.defineProperty(Array.prototype,'fixed',{enumerable: false});

	return Laya;
})(window,document);

(function(window,document,Laya){
	var __un=Laya.un,__uns=Laya.uns,__static=Laya.static,__class=Laya.class,__getset=Laya.getset,__newvec=Laya.__newvec;
	Laya.interface('laya.ui.IItem');
	Laya.interface('laya.ui.IRender');
	Laya.interface('laya.ui.ISelect');
	Laya.interface('laya.ui.IComponent');
	Laya.interface('laya.runtime.IMarket');
	Laya.interface('laya.filters.IFilter');
	Laya.interface('laya.display.ILayout');
	Laya.interface('laya.resource.IDispose');
	Laya.interface('laya.resource.IDestroy');
	Laya.interface('laya.runtime.IConchNode');
	Laya.interface('laya.webgl.shapes.IShape');
	Laya.interface('laya.webgl.submit.ISubmit');
	Laya.interface('laya.filters.IFilterAction');
	Laya.interface('laya.webgl.text.ICharSegment');
	Laya.interface('laya.runtime.ICPlatformClass');
	Laya.interface('laya.webgl.canvas.save.ISaveData');
	Laya.interface('laya.webgl.resource.IMergeAtlasBitmap');
	Laya.interface('laya.ui.IBox','laya.ui.IComponent');
	Laya.interface('laya.filters.IFilterActionGL','laya.filters.IFilterAction');
	/**
	*@private
	*/
	//class laya.utils.RunDriver
	var RunDriver=(function(){
		function RunDriver(){};
		__class(RunDriver,'laya.utils.RunDriver');
		RunDriver.FILTER_ACTIONS=[];
		RunDriver.pixelRatio=-1;
		RunDriver._charSizeTestDiv=null
		RunDriver.now=function(){
			return Date.now();
		}

		RunDriver.getWindow=function(){
			return window;
		}

		RunDriver.getPixelRatio=function(){
			if (RunDriver.pixelRatio < 0){
				var ctx=Browser.context;
				var backingStore=ctx.backingStorePixelRatio || ctx.webkitBackingStorePixelRatio || ctx.mozBackingStorePixelRatio || ctx.msBackingStorePixelRatio || ctx.oBackingStorePixelRatio || ctx.backingStorePixelRatio || 1;
				RunDriver.pixelRatio=(Browser.window.devicePixelRatio || 1)/ backingStore;
				if (RunDriver.pixelRatio < 1)RunDriver.pixelRatio=1;
			}
			return RunDriver.pixelRatio;
		}

		RunDriver.getIncludeStr=function(name){
			return null;
		}

		RunDriver.createShaderCondition=function(conditionScript){
			var fn="(function() {return "+conditionScript+";})";
			return Browser.window.eval(fn);
		}

		RunDriver.fontMap=[];
		RunDriver.measureText=function(txt,font){
			var isChinese=RunDriver.hanzi.test(txt);
			if (isChinese && RunDriver.fontMap[font]){
				return RunDriver.fontMap[font];
			};
			var ctx=Browser.context;
			ctx.font=font;
			var r=ctx.measureText(txt);
			if (isChinese)RunDriver.fontMap[font]=r;
			return r;
		}

		RunDriver.getWebGLContext=function(canvas){
		};

		RunDriver.beginFlush=function(){
		};

		RunDriver.endFinish=function(){
		};

		RunDriver.addToAtlas=null
		RunDriver.flashFlushImage=function(atlasWebGLCanvas){
		};

		RunDriver.drawToCanvas=function(sprite,_renderType,canvasWidth,canvasHeight,offsetX,offsetY){
			var canvas=HTMLCanvas.create("2D");
			var context=new RenderContext(canvasWidth,canvasHeight,canvas);
			RenderSprite.renders[_renderType]._fun(sprite,context,offsetX,offsetY);
			return canvas;
		}

		RunDriver.createParticleTemplate2D=null
		RunDriver.createGLTextur=null;
		RunDriver.createWebGLContext2D=null;
		RunDriver.changeWebGLSize=function(w,h){
		};

		RunDriver.createRenderSprite=function(type,next){
			return new RenderSprite(type,next);
		}

		RunDriver.createFilterAction=function(type){
			return new ColorFilterAction();
		}

		RunDriver.createGraphics=function(){
			return new Graphics();
		}

		RunDriver.clear=function(value){
			Render._context.ctx.clear();
		}

		RunDriver.clearAtlas=function(value){
		};

		RunDriver.addTextureToAtlas=function(value){
		};

		RunDriver.getTexturePixels=function(value,x,y,width,height){
			return null;
		}

		RunDriver.skinAniSprite=function(){
			return null;
		}

		__static(RunDriver,
		['hanzi',function(){return this.hanzi=new RegExp("^[\u4E00-\u9FA5]$");}
		]);
		return RunDriver;
	})()


	/**
	*<code>Laya</code> 是全局对象的引用入口集。
	*Laya类引用了一些常用的全局对象，比如Laya.stage：舞台，Laya.timer：时间管理器，Laya.loader：加载管理器，使用时注意大小写。
	*/
	//class Laya
	var ___Laya=(function(){
		//function Laya(){};
		/**
		*表示是否捕获全局错误并弹出提示。默认为false。
		*适用于移动设备等不方便调试的时候，设置为true后，如有未知错误，可以弹窗抛出详细错误堆栈。
		*/
		__getset(1,Laya,'alertGlobalError',null,function(value){
			var erralert=0;
			if (value){
				Browser.window.onerror=function (msg,url,line,column,detail){
					if (erralert++< 5 && detail)
						alert("出错啦，请把此信息截图给研发商\n"+msg+"\n"+detail.stack);
				}
				}else {
				Browser.window.onerror=null;
			}
		});

		Laya.init=function(width,height,__plugins){
			var plugins=[];for(var i=2,sz=arguments.length;i<sz;i++)plugins.push(arguments[i]);
			if (Laya._isinit)return;
			ArrayBuffer.prototype.slice || (ArrayBuffer.prototype.slice=Laya._arrayBufferSlice);
			Laya._isinit=true;
			Browser.__init__();
			Context.__init__();
			Graphics.__init__();
			Laya.timer=new Timer();
			Laya.loader=new LoaderManager();
			for (var i=0,n=plugins.length;i < n;i++){
				if (plugins[i].enable)plugins[i].enable();
			}
			Font.__init__();
			Style.__init__();
			ResourceManager.__init__();
			CacheManger.beginCheck();
			Laya._currentStage=Laya.stage=new Stage();
			Laya.stage.conchModel && Laya.stage.conchModel.setRootNode();
			var location=Browser.window.location;
			var pathName=location.pathname;
			pathName=pathName.charAt(2)==':' ? pathName.substring(1):pathName;
			URL.rootPath=URL.basePath=URL.getPath(location.protocol=="file:" ? pathName :location.protocol+"//"+location.host+location.pathname);
			Laya.render=new Render(0,0);
			Laya.stage.size(width,height);
			RenderSprite.__init__();
			KeyBoardManager.__init__();
			MouseManager.instance.__init__(Laya.stage,Render.canvas);
			Input.__init__();
			SoundManager.autoStopMusic=true;
			LocalStorage.__init__();
			return Render.canvas;
		}

		Laya._arrayBufferSlice=function(start,end){
			var arr=this;
			var arrU8List=new Uint8Array(arr,start,end-start);
			var newU8List=new Uint8Array(arrU8List.length);
			newU8List.set(arrU8List);
			return newU8List.buffer;
		}

		Laya.stage=null;
		Laya.timer=null;
		Laya.loader=null;
		Laya.version="1.7.8beta";
		Laya.render=null
		Laya._currentStage=null
		Laya._isinit=false;
		__static(Laya,
		['conchMarket',function(){return this.conchMarket=window.conch?conchMarket:null;},'PlatformClass',function(){return this.PlatformClass=window.PlatformClass;}
		]);
		return Laya;
	})()


	/**
	*<code>EventDispatcher</code> 类是可调度事件的所有类的基类。
	*/
	//class laya.events.EventDispatcher
	var EventDispatcher=(function(){
		var EventHandler;
		function EventDispatcher(){
			this._events=null;
		}

		__class(EventDispatcher,'laya.events.EventDispatcher');
		var __proto=EventDispatcher.prototype;
		/**
		*检查 EventDispatcher 对象是否为特定事件类型注册了任何侦听器。
		*@param type 事件的类型。
		*@return 如果指定类型的侦听器已注册，则值为 true；否则，值为 false。
		*/
		__proto.hasListener=function(type){
			var listener=this._events && this._events[type];
			return !!listener;
		}

		/**
		*派发事件。
		*@param type 事件类型。
		*@param data （可选）回调数据。<b>注意：</b>如果是需要传递多个参数 p1,p2,p3,...可以使用数组结构如：[p1,p2,p3,...] ；如果需要回调单个参数 p ，且 p 是一个数组，则需要使用结构如：[p]，其他的单个参数 p ，可以直接传入参数 p。
		*@return 此事件类型是否有侦听者，如果有侦听者则值为 true，否则值为 false。
		*/
		__proto.event=function(type,data){
			if (!this._events || !this._events[type])return false;
			var listeners=this._events[type];
			if (listeners.run){
				if (listeners.once)delete this._events[type];
				data !=null ? listeners.runWith(data):listeners.run();
				}else {
				for (var i=0,n=listeners.length;i < n;i++){
					var listener=listeners[i];
					if (listener){
						(data !=null)? listener.runWith(data):listener.run();
					}
					if (!listener || listener.once){
						listeners.splice(i,1);
						i--;
						n--;
					}
				}
				if (listeners.length===0 && this._events)delete this._events[type];
			}
			return true;
		}

		/**
		*使用 EventDispatcher 对象注册指定类型的事件侦听器对象，以使侦听器能够接收事件通知。
		*@param type 事件的类型。
		*@param caller 事件侦听函数的执行域。
		*@param listener 事件侦听函数。
		*@param args （可选）事件侦听函数的回调参数。
		*@return 此 EventDispatcher 对象。
		*/
		__proto.on=function(type,caller,listener,args){
			return this._createListener(type,caller,listener,args,false);
		}

		/**
		*使用 EventDispatcher 对象注册指定类型的事件侦听器对象，以使侦听器能够接收事件通知，此侦听事件响应一次后自动移除。
		*@param type 事件的类型。
		*@param caller 事件侦听函数的执行域。
		*@param listener 事件侦听函数。
		*@param args （可选）事件侦听函数的回调参数。
		*@return 此 EventDispatcher 对象。
		*/
		__proto.once=function(type,caller,listener,args){
			return this._createListener(type,caller,listener,args,true);
		}

		/**@private */
		__proto._createListener=function(type,caller,listener,args,once,offBefore){
			(offBefore===void 0)&& (offBefore=true);
			offBefore && this.off(type,caller,listener,once);
			var handler=EventHandler.create(caller || this,listener,args,once);
			this._events || (this._events={});
			var events=this._events;
			if (!events[type])events[type]=handler;
			else {
				if (!events[type].run)events[type].push(handler);
				else events[type]=[events[type],handler];
			}
			return this;
		}

		/**
		*从 EventDispatcher 对象中删除侦听器。
		*@param type 事件的类型。
		*@param caller 事件侦听函数的执行域。
		*@param listener 事件侦听函数。
		*@param onceOnly （可选）如果值为 true ,则只移除通过 once 方法添加的侦听器。
		*@return 此 EventDispatcher 对象。
		*/
		__proto.off=function(type,caller,listener,onceOnly){
			(onceOnly===void 0)&& (onceOnly=false);
			if (!this._events || !this._events[type])return this;
			var listeners=this._events[type];
			if (listener !=null){
				if (listeners.run){
					if ((!caller || listeners.caller===caller)&& listeners.method===listener && (!onceOnly || listeners.once)){
						delete this._events[type];
						listeners.recover();
					}
					}else {
					var count=0;
					for (var i=0,n=listeners.length;i < n;i++){
						var item=listeners[i];
						if (item && (!caller || item.caller===caller)&& item.method===listener && (!onceOnly || item.once)){
							count++;
							listeners[i]=null;
							item.recover();
						}
					}
					if (count===n)delete this._events[type];
				}
			}
			return this;
		}

		/**
		*从 EventDispatcher 对象中删除指定事件类型的所有侦听器。
		*@param type （可选）事件类型，如果值为 null，则移除本对象所有类型的侦听器。
		*@return 此 EventDispatcher 对象。
		*/
		__proto.offAll=function(type){
			var events=this._events;
			if (!events)return this;
			if (type){
				this._recoverHandlers(events[type]);
				delete events[type];
				}else {
				for (var name in events){
					this._recoverHandlers(events[name]);
				}
				this._events=null;
			}
			return this;
		}

		__proto._recoverHandlers=function(arr){
			if (!arr)return;
			if (arr.run){
				arr.recover();
				}else {
				for (var i=arr.length-1;i >-1;i--){
					if (arr[i]){
						arr[i].recover();
						arr[i]=null;
					}
				}
			}
		}

		/**
		*检测指定事件类型是否是鼠标事件。
		*@param type 事件的类型。
		*@return 如果是鼠标事件，则值为 true;否则，值为 false。
		*/
		__proto.isMouseEvent=function(type){
			return EventDispatcher.MOUSE_EVENTS[type];
		}

		EventDispatcher.MOUSE_EVENTS={"rightmousedown":true,"rightmouseup":true,"rightclick":true,"mousedown":true,"mouseup":true,"mousemove":true,"mouseover":true,"mouseout":true,"click":true,"doubleclick":true};
		EventDispatcher.__init$=function(){
			Object.defineProperty(laya.events.EventDispatcher.prototype,"_events",{enumerable:false,writable:true});
			/**@private */
			//class EventHandler extends laya.utils.Handler
			EventHandler=(function(_super){
				function EventHandler(caller,method,args,once){
					EventHandler.__super.call(this,caller,method,args,once);
				}
				__class(EventHandler,'',_super);
				var __proto=EventHandler.prototype;
				__proto.recover=function(){
					if (this._id > 0){
						this._id=0;
						EventHandler._pool.push(this.clear());
					}
				}
				EventHandler.create=function(caller,method,args,once){
					(once===void 0)&& (once=true);
					if (EventHandler._pool.length)return EventHandler._pool.pop().setTo(caller,method,args,once);
					return new EventHandler(caller,method,args,once);
				}
				EventHandler._pool=[];
				return EventHandler;
			})(Handler)
		}

		return EventDispatcher;
	})()


	/**
	*<p><code>Handler</code> 是事件处理器类。</p>
	*<p>推荐使用 Handler.create()方法从对象池创建，减少对象创建消耗。创建的 Handler 对象不再使用后，可以使用 Handler.recover()将其回收到对象池，回收后不要再使用此对象，否则会导致不可预料的错误。</p>
	*<p><b>注意：</b>由于鼠标事件也用本对象池，不正确的回收及调用，可能会影响鼠标事件的执行。</p>
	*/
	//class laya.utils.Handler
	var Handler=(function(){
		function Handler(caller,method,args,once){
			//this.caller=null;
			//this.method=null;
			//this.args=null;
			this.once=false;
			this._id=0;
			(once===void 0)&& (once=false);
			this.setTo(caller,method,args,once);
		}

		__class(Handler,'laya.utils.Handler');
		var __proto=Handler.prototype;
		/**
		*设置此对象的指定属性值。
		*@param caller 执行域(this)。
		*@param method 回调方法。
		*@param args 携带的参数。
		*@param once 是否只执行一次，如果为true，执行后执行recover()进行回收。
		*@return 返回 handler 本身。
		*/
		__proto.setTo=function(caller,method,args,once){
			this._id=Handler._gid++;
			this.caller=caller;
			this.method=method;
			this.args=args;
			this.once=once;
			return this;
		}

		/**
		*执行处理器。
		*/
		__proto.run=function(){
			if (this.method==null)return null;
			var id=this._id;
			var result=this.method.apply(this.caller,this.args);
			this._id===id && this.once && this.recover();
			return result;
		}

		/**
		*执行处理器，携带额外数据。
		*@param data 附加的回调数据，可以是单数据或者Array(作为多参)。
		*/
		__proto.runWith=function(data){
			if (this.method==null)return null;
			var id=this._id;
			if (data==null)
				var result=this.method.apply(this.caller,this.args);
			else if (!this.args && !data.unshift)result=this.method.call(this.caller,data);
			else if (this.args)result=this.method.apply(this.caller,this.args.concat(data));
			else result=this.method.apply(this.caller,data);
			this._id===id && this.once && this.recover();
			return result;
		}

		/**
		*清理对象引用。
		*/
		__proto.clear=function(){
			this.caller=null;
			this.method=null;
			this.args=null;
			return this;
		}

		/**
		*清理并回收到 Handler 对象池内。
		*/
		__proto.recover=function(){
			if (this._id > 0){
				this._id=0;
				Handler._pool.push(this.clear());
			}
		}

		Handler.create=function(caller,method,args,once){
			(once===void 0)&& (once=true);
			if (Handler._pool.length)return Handler._pool.pop().setTo(caller,method,args,once);
			return new Handler(caller,method,args,once);
		}

		Handler._pool=[];
		Handler._gid=1;
		return Handler;
	})()


	/**
	*<code>Event</code> 是事件类型的集合。一般当发生事件时，<code>Event</code> 对象将作为参数传递给事件侦听器。
	*/
	//class laya.events.Event
	var Event=(function(){
		function Event(){
			//this.type=null;
			//this.nativeEvent=null;
			//this.target=null;
			//this.currentTarget=null;
			//this._stoped=false;
			//this.touchId=0;
			//this.keyCode=0;
			//this.delta=0;
		}

		__class(Event,'laya.events.Event');
		var __proto=Event.prototype;
		/**
		*设置事件数据。
		*@param type 事件类型。
		*@param currentTarget 事件目标触发对象。
		*@param target 事件当前冒泡对象。
		*@return 返回当前 Event 对象。
		*/
		__proto.setTo=function(type,currentTarget,target){
			this.type=type;
			this.currentTarget=currentTarget;
			this.target=target;
			return this;
		}

		/**
		*阻止对事件流中当前节点的后续节点中的所有事件侦听器进行处理。此方法不会影响当前节点 (currentTarget)中的任何事件侦听器。
		*/
		__proto.stopPropagation=function(){
			this._stoped=true;
		}

		/**鼠标在 Stage 上的 Y 轴坐标*/
		__getset(0,__proto,'stageY',function(){
			return Laya.stage.mouseY;
		});

		/**
		*包含按下或释放的键的字符代码值。字符代码值为英文键盘值。
		*/
		__getset(0,__proto,'charCode',function(){
			return this.nativeEvent.charCode;
		});

		/**
		*触摸点列表。
		*/
		__getset(0,__proto,'touches',function(){
			var arr=this.nativeEvent.touches;
			if (arr){
				var stage=Laya.stage;
				for (var i=0,n=arr.length;i < n;i++){
					var e=arr[i];
					var point=Point.TEMP;
					point.setTo(e.clientX,e.clientY);
					stage._canvasTransform.invertTransformPoint(point);
					stage.transform.invertTransformPoint(point);
					e.stageX=point.x;
					e.stageY=point.y;
				}
			}
			return arr;
		});

		/**
		*表示键在键盘上的位置。这对于区分在键盘上多次出现的键非常有用。<br>
		*例如，您可以根据此属性的值来区分左 Shift 键和右 Shift 键：左 Shift 键的值为 KeyLocation.LEFT，右 Shift 键的值为 KeyLocation.RIGHT。另一个示例是区分标准键盘 (KeyLocation.STANDARD)与数字键盘 (KeyLocation.NUM_PAD)上按下的数字键。
		*/
		__getset(0,__proto,'keyLocation',function(){
			return this.nativeEvent.keyLocation;
		});

		/**
		*表示 Ctrl 键是处于活动状态 (true)还是非活动状态 (false)。
		*/
		__getset(0,__proto,'ctrlKey',function(){
			return this.nativeEvent.ctrlKey;
		});

		/**
		*表示 Alt 键是处于活动状态 (true)还是非活动状态 (false)。
		*/
		__getset(0,__proto,'altKey',function(){
			return this.nativeEvent.altKey;
		});

		/**
		*表示 Shift 键是处于活动状态 (true)还是非活动状态 (false)。
		*/
		__getset(0,__proto,'shiftKey',function(){
			return this.nativeEvent.shiftKey;
		});

		/**鼠标在 Stage 上的 X 轴坐标*/
		__getset(0,__proto,'stageX',function(){
			return Laya.stage.mouseX;
		});

		Event.EMPTY=new Event();
		Event.MOUSE_DOWN="mousedown";
		Event.MOUSE_UP="mouseup";
		Event.CLICK="click";
		Event.RIGHT_MOUSE_DOWN="rightmousedown";
		Event.RIGHT_MOUSE_UP="rightmouseup";
		Event.RIGHT_CLICK="rightclick";
		Event.MOUSE_MOVE="mousemove";
		Event.MOUSE_OVER="mouseover";
		Event.MOUSE_OUT="mouseout";
		Event.MOUSE_WHEEL="mousewheel";
		Event.ROLL_OVER="mouseover";
		Event.ROLL_OUT="mouseout";
		Event.DOUBLE_CLICK="doubleclick";
		Event.CHANGE="change";
		Event.CHANGED="changed";
		Event.RESIZE="resize";
		Event.ADDED="added";
		Event.REMOVED="removed";
		Event.DISPLAY="display";
		Event.UNDISPLAY="undisplay";
		Event.ERROR="error";
		Event.COMPLETE="complete";
		Event.LOADED="loaded";
		Event.PROGRESS="progress";
		Event.INPUT="input";
		Event.RENDER="render";
		Event.OPEN="open";
		Event.MESSAGE="message";
		Event.CLOSE="close";
		Event.KEY_DOWN="keydown";
		Event.KEY_PRESS="keypress";
		Event.KEY_UP="keyup";
		Event.FRAME="enterframe";
		Event.DRAG_START="dragstart";
		Event.DRAG_MOVE="dragmove";
		Event.DRAG_END="dragend";
		Event.ENTER="enter";
		Event.SELECT="select";
		Event.BLUR="blur";
		Event.FOCUS="focus";
		Event.VISIBILITY_CHANGE="visibilitychange";
		Event.FOCUS_CHANGE="focuschange";
		Event.PLAYED="played";
		Event.PAUSED="paused";
		Event.STOPPED="stopped";
		Event.START="start";
		Event.END="end";
		Event.ENABLE_CHANGED="enablechanged";
		Event.ACTIVE_IN_HIERARCHY_CHANGED="activeinhierarchychanged";
		Event.COMPONENT_ADDED="componentadded";
		Event.COMPONENT_REMOVED="componentremoved";
		Event.LAYER_CHANGED="layerchanged";
		Event.HIERARCHY_LOADED="hierarchyloaded";
		Event.RECOVERING="recovering";
		Event.RECOVERED="recovered";
		Event.RELEASED="released";
		Event.LINK="link";
		Event.LABEL="label";
		Event.FULL_SCREEN_CHANGE="fullscreenchange";
		Event.DEVICE_LOST="devicelost";
		Event.MESH_CHANGED="meshchanged";
		Event.MATERIAL_CHANGED="materialchanged";
		Event.RENDERQUEUE_CHANGED="renderqueuechanged";
		Event.WORLDMATRIX_NEEDCHANGE="worldmatrixneedchanged";
		Event.ANIMATION_CHANGED="animationchanged";
		return Event;
	})()


	/**
	*Config 用于配置一些全局参数。如需更改，请在初始化引擎之前设置。
	*/
	//class Config
	var Config=(function(){
		function Config(){};
		__class(Config,'Config');
		Config.WebGLTextCacheCount=500;
		Config.atlasEnable=false;
		Config.showCanvasMark=false;
		Config.animationInterval=50;
		Config.isAntialias=false;
		Config.isAlpha=false;
		Config.premultipliedAlpha=true;
		Config.isStencil=true;
		Config.preserveDrawingBuffer=false;
		return Config;
	})()


	/**
	*<code>BitmapFont</code> 是位图字体类，用于定义位图字体信息。
	*/
	//class laya.display.BitmapFont
	var BitmapFont=(function(){
		function BitmapFont(){
			this._texture=null;
			this._fontCharDic={};
			this._fontWidthMap={};
			this._complete=null;
			this._path=null;
			this._maxWidth=0;
			this._spaceWidth=10;
			this._padding=null;
			this.fontSize=12;
			this.autoScaleSize=false;
			this.letterSpacing=0;
		}

		__class(BitmapFont,'laya.display.BitmapFont');
		var __proto=BitmapFont.prototype;
		/**
		*通过指定位图字体文件路径，加载位图字体文件，加载完成后会自动解析。
		*@param path 位图字体文件的路径。
		*@param complete 加载并解析完成的回调。
		*/
		__proto.loadFont=function(path,complete){
			this._path=path;
			this._complete=complete;
			Laya.loader.load([{url:this._path,type:"xml"},{url:this._path.replace(".fnt",".png"),type:"image"}],Handler.create(this,this.onLoaded));
		}

		/**
		*@private
		*/
		__proto.onLoaded=function(){
			this.parseFont(Loader.getRes(this._path),Loader.getRes(this._path.replace(".fnt",".png")));
			this._complete && this._complete.run();
		}

		/**
		*解析字体文件。
		*@param xml 字体文件XML。
		*@param texture 字体的纹理。
		*/
		__proto.parseFont=function(xml,texture){
			if (xml==null || texture==null)return;
			this._texture=texture;
			var tX=0;
			var tScale=1;
			var tInfo=xml.getElementsByTagName("info");
			this.fontSize=parseInt(tInfo[0].attributes["size"].nodeValue);
			var tPadding=tInfo[0].attributes["padding"].nodeValue;
			var tPaddingArray=tPadding.split(",");
			this._padding=[parseInt(tPaddingArray[0]),parseInt(tPaddingArray[1]),parseInt(tPaddingArray[2]),parseInt(tPaddingArray[3])];
			var chars=xml.getElementsByTagName("char");
			var i=0;
			for (i=0;i < chars.length;i++){
				var tAttribute=chars[i].attributes;
				var tId=parseInt(tAttribute["id"].nodeValue);
				var xOffset=parseInt(tAttribute["xoffset"].nodeValue)/ tScale;
				var yOffset=parseInt(tAttribute["yoffset"].nodeValue)/ tScale;
				var xAdvance=parseInt(tAttribute["xadvance"].nodeValue)/ tScale;
				var region=new Rectangle();
				region.x=parseInt(tAttribute["x"].nodeValue);
				region.y=parseInt(tAttribute["y"].nodeValue);
				region.width=parseInt(tAttribute["width"].nodeValue);
				region.height=parseInt(tAttribute["height"].nodeValue);
				var tTexture=Texture.create(texture,region.x,region.y,region.width,region.height,xOffset,yOffset);
				this._maxWidth=Math.max(this._maxWidth,xAdvance+this.letterSpacing);
				this._fontCharDic[tId]=tTexture;
				this._fontWidthMap[tId]=xAdvance;
			}
		}

		/**
		*获取指定字符的字体纹理对象。
		*@param char 字符。
		*@return 指定的字体纹理对象。
		*/
		__proto.getCharTexture=function(char){
			return this._fontCharDic[char.charCodeAt(0)];
		}

		/**
		*销毁位图字体，调用Text.unregisterBitmapFont 时，默认会销毁。
		*/
		__proto.destroy=function(){
			if (this._texture){
				for (var p in this._fontCharDic){
					var tTexture=this._fontCharDic[p];
					if (tTexture)tTexture.destroy();
				}
				this._texture.destroy();
				this._fontCharDic=null;
				this._fontWidthMap=null;
				this._texture=null;
			}
		}

		/**
		*设置空格的宽（如果字体库有空格，这里就可以不用设置了）。
		*@param spaceWidth 宽度，单位为像素。
		*/
		__proto.setSpaceWidth=function(spaceWidth){
			this._spaceWidth=spaceWidth;
		}

		/**
		*获取指定字符的宽度。
		*@param char 字符。
		*@return 宽度。
		*/
		__proto.getCharWidth=function(char){
			var code=char.charCodeAt(0);
			if (this._fontWidthMap[code])return this._fontWidthMap[code]+this.letterSpacing;
			if (char==" ")return this._spaceWidth+this.letterSpacing;
			return 0;
		}

		/**
		*获取指定文本内容的宽度。
		*@param text 文本内容。
		*@return 宽度。
		*/
		__proto.getTextWidth=function(text){
			var tWidth=0;
			for (var i=0,n=text.length;i < n;i++){
				tWidth+=this.getCharWidth(text.charAt(i));
			}
			return tWidth;
		}

		/**
		*获取最大字符宽度。
		*/
		__proto.getMaxWidth=function(){
			return this._maxWidth;
		}

		/**
		*获取最大字符高度。
		*/
		__proto.getMaxHeight=function(){
			return this.fontSize;
		}

		/**
		*@private
		*将指定的文本绘制到指定的显示对象上。
		*/
		__proto.drawText=function(text,sprite,drawX,drawY,align,width){
			var tWidth=this.getTextWidth(text);
			var tTexture;
			var dx=0;
			align==="center" && (dx=(width-tWidth)/ 2);
			align==="right" && (dx=(width-tWidth));
			var tX=0;
			for (var i=0,n=text.length;i < n;i++){
				tTexture=this.getCharTexture(text.charAt(i));
				if (tTexture){
					sprite.graphics.drawTexture(tTexture,drawX+tX+dx,drawY);
					tX+=this.getCharWidth(text.charAt(i));
				}
			}
		}

		return BitmapFont;
	})()


	/**
	*@private
	*<code>Style</code> 类是元素样式定义类。
	*/
	//class laya.display.css.Style
	var Style=(function(){
		function Style(){
			this.alpha=1;
			this.visible=true;
			this.scrollRect=null;
			this.blendMode=null;
			this._type=0;
			this._tf=Style._TF_EMPTY;
		}

		__class(Style,'laya.display.css.Style');
		var __proto=Style.prototype;
		__proto.getTransform=function(){
			return this._tf;
		}

		__proto.setTransform=function(value){
			this._tf=value==='none' || !value ? Style._TF_EMPTY :value;
		}

		__proto.setTranslateX=function(value){
			this._tf===Style._TF_EMPTY && (this._tf=new TransformInfo());
			this._tf.translateX=value;
		}

		__proto.setTranslateY=function(value){
			this._tf===Style._TF_EMPTY && (this._tf=new TransformInfo());
			this._tf.translateY=value;
		}

		__proto.setScaleX=function(value){
			this._tf===Style._TF_EMPTY && (this._tf=new TransformInfo());
			this._tf.scaleX=value;
		}

		__proto.setScale=function(x,y){
			this._tf===Style._TF_EMPTY && (this._tf=new TransformInfo());
			this._tf.scaleX=x;
			this._tf.scaleY=y;
		}

		__proto.setScaleY=function(value){
			this._tf===Style._TF_EMPTY && (this._tf=new TransformInfo());
			this._tf.scaleY=value;
		}

		__proto.setRotate=function(value){
			this._tf===Style._TF_EMPTY && (this._tf=new TransformInfo());
			this._tf.rotate=value;
		}

		__proto.setSkewX=function(value){
			this._tf===Style._TF_EMPTY && (this._tf=new TransformInfo());
			this._tf.skewX=value;
		}

		__proto.setSkewY=function(value){
			this._tf===Style._TF_EMPTY && (this._tf=new TransformInfo());
			this._tf.skewY=value;
		}

		/**销毁此对象。*/
		__proto.destroy=function(){
			this.scrollRect=null;
		}

		/**@private */
		__proto.render=function(sprite,context,x,y){}
		/**@private */
		__proto.getCSSStyle=function(){
			return CSSStyle.EMPTY;
		}

		/**@private */
		__proto._enableLayout=function(){
			return false;
		}

		/**X 轴缩放值。*/
		__getset(0,__proto,'scaleX',function(){
			return this._tf.scaleX;
			},function(value){
			this.setScaleX(value);
		});

		/**元素应用的 2D 或 3D 转换的值。该属性允许我们对元素进行旋转、缩放、移动或倾斜。*/
		__getset(0,__proto,'transform',function(){
			return this.getTransform();
			},function(value){
			this.setTransform(value);
		});

		/**定义转换，只是用 X 轴的值。*/
		__getset(0,__proto,'translateX',function(){
			return this._tf.translateX;
			},function(value){
			this.setTranslateX(value);
		});

		/**定义转换，只是用 Y 轴的值。*/
		__getset(0,__proto,'translateY',function(){
			return this._tf.translateY;
			},function(value){
			this.setTranslateY(value);
		});

		/**Y 轴缩放值。*/
		__getset(0,__proto,'scaleY',function(){
			return this._tf.scaleY;
			},function(value){
			this.setScaleY(value);
		});

		/**表示元素是否显示为块级元素。*/
		__getset(0,__proto,'block',function(){
			return (this._type & 0x1)!=0;
		});

		/**定义沿着 Y 轴的 2D 倾斜转换。*/
		__getset(0,__proto,'skewY',function(){
			return this._tf.skewY;
			},function(value){
			this.setSkewY(value);
		});

		/**定义旋转角度。*/
		__getset(0,__proto,'rotate',function(){
			return this._tf.rotate;
			},function(value){
			this.setRotate(value);
		});

		/**定义沿着 X 轴的 2D 倾斜转换。*/
		__getset(0,__proto,'skewX',function(){
			return this._tf.skewX;
			},function(value){
			this.setSkewX(value);
		});

		/**表示元素的左内边距。*/
		__getset(0,__proto,'paddingLeft',function(){
			return 0;
		});

		/**表示元素的上内边距。*/
		__getset(0,__proto,'paddingTop',function(){
			return 0;
		});

		/**是否为绝对定位。*/
		__getset(0,__proto,'absolute',function(){
			return true;
		});

		Style.__init__=function(){
			Style._TF_EMPTY=new TransformInfo();
			Style.EMPTY=new Style();
		}

		Style.EMPTY=null
		Style._TF_EMPTY=null
		return Style;
	})()


	/**
	*@private
	*<code>Font</code> 类是字体显示定义类。
	*/
	//class laya.display.css.Font
	var Font=(function(){
		function Font(src){
			this._type=0;
			this._weight=0;
			this._decoration=null;
			this._text=null;
			this.indent=0;
			this._color=Color.create(Font.defaultColor);
			this.family=Font.defaultFamily;
			this.stroke=Font._STROKE;
			this.size=Font.defaultSize;
			src && src!==Font.EMPTY && src.copyTo(this);
		}

		__class(Font,'laya.display.css.Font');
		var __proto=Font.prototype;
		/**
		*字体样式字符串。
		*/
		__proto.set=function(value){
			this._text=null;
			var strs=value.split(' ');
			for (var i=0,n=strs.length;i < n;i++){
				var str=strs[i];
				switch (str){
					case 'italic':
						this.italic=true;
						continue ;
					case 'bold':
						this.bold=true;
						continue ;
					}
				if (str.indexOf('px')> 0){
					this.size=parseInt(str);
					this.family=strs[i+1];
					i++;
					continue ;
				}
			}
		}

		/**
		*返回字体样式字符串。
		*@return 字体样式字符串。
		*/
		__proto.toString=function(){
			this._text=""
			this.italic && (this._text+="italic ");
			this.bold && (this._text+="bold ");
			return this._text+=this.size+"px "+this.family;
		}

		/**
		*将当前的属性值复制到传入的 <code>Font</code> 对象。
		*@param dec 一个 Font 对象。
		*/
		__proto.copyTo=function(dec){
			dec._type=this._type;
			dec._text=this._text;
			dec._weight=this._weight;
			dec._color=this._color;
			dec.family=this.family;
			dec.stroke=this.stroke !=Font._STROKE ? this.stroke.slice():Font._STROKE;
			dec.indent=this.indent;
			dec.size=this.size;
		}

		/**
		*表示是否为密码格式。
		*/
		__getset(0,__proto,'password',function(){
			return (this._type & 0x400)!==0;
			},function(value){
			value ? (this._type |=0x400):(this._type &=~0x400);
		});

		/**
		*表示颜色字符串。
		*/
		__getset(0,__proto,'color',function(){
			return this._color.strColor;
			},function(value){
			this._color=Color.create(value);
		});

		/**
		*表示是否为斜体。
		*/
		__getset(0,__proto,'italic',function(){
			return (this._type & 0x200)!==0;
			},function(value){
			value ? (this._type |=0x200):(this._type &=~0x200);
		});

		/**
		*表示是否为粗体。
		*/
		__getset(0,__proto,'bold',function(){
			return (this._type & 0x800)!==0;
			},function(value){
			value ? (this._type |=0x800):(this._type &=~0x800);
		});

		/**
		*文本的粗细。
		*/
		__getset(0,__proto,'weight',function(){
			return ""+this._weight;
			},function(value){
			var weight=0;
			switch (value){
				case 'normal':
					break ;
				case 'bold':
					this.bold=true;
					weight=700;
					break ;
				case 'bolder':
					weight=800;
					break ;
				case 'lighter':
					weight=100;
					break ;
				default :
					weight=parseInt(value);
				}
			this._weight=weight;
			this._text=null;
		});

		/**
		*规定添加到文本的修饰。
		*/
		__getset(0,__proto,'decoration',function(){
			return this._decoration ? this._decoration.value :"none";
			},function(value){
			var strs=value.split(' ');
			this._decoration || (this._decoration={});
			switch (strs[0]){
				case '_':
					this._decoration.type='underline'
					break ;
				case '-':
					this._decoration.type='line-through'
					break ;
				case 'overline':
					this._decoration.type='overline'
					break ;
				default :
					this._decoration.type=strs[0];
				}
			strs[1] && (this._decoration.color=Color.create(strs));
			this._decoration.value=value;
		});

		Font.__init__=function(){
			Font.EMPTY=new Font(null);
		}

		Font.EMPTY=null
		Font.defaultColor="#000000";
		Font.defaultSize=12;
		Font.defaultFamily="Arial";
		Font.defaultFont="12px Arial";
		Font._STROKE=[0,"#000000"];
		Font._ITALIC=0x200;
		Font._PASSWORD=0x400;
		Font._BOLD=0x800;
		return Font;
	})()


	/**
	*@private
	*/
	//class laya.display.css.TransformInfo
	var TransformInfo=(function(){
		function TransformInfo(){
			this.translateX=0;
			this.translateY=0;
			this.scaleX=1;
			this.scaleY=1;
			this.rotate=0;
			this.skewX=0;
			this.skewY=0;
		}

		__class(TransformInfo,'laya.display.css.TransformInfo');
		return TransformInfo;
	})()


	/**
	*<code>Graphics</code> 类用于创建绘图显示对象。Graphics可以同时绘制多个位图或者矢量图，还可以结合save，restore，transform，scale，rotate，translate，alpha等指令对绘图效果进行变化。
	*Graphics以命令流方式存储，可以通过cmds属性访问所有命令流。Graphics是比Sprite更轻量级的对象，合理使用能提高应用性能(比如把大量的节点绘图改为一个节点的Graphics命令集合，能减少大量节点创建消耗)。
	*@see laya.display.Sprite#graphics
	*/
	//class laya.display.Graphics
	var Graphics=(function(){
		function Graphics(){
			//this._sp=null;
			this._one=null;
			this._cmds=null;
			//this._vectorgraphArray=null;
			//this._graphicBounds=null;
			this._render=this._renderEmpty;
			if (Render.isConchNode){
				this._nativeObj=new _conchGraphics();;
				this.id=this._nativeObj.conchID;;
			}
		}

		__class(Graphics,'laya.display.Graphics');
		var __proto=Graphics.prototype;
		/**
		*<p>销毁此对象。</p>
		*/
		__proto.destroy=function(){
			this.clear();
			if (this._graphicBounds)this._graphicBounds.destroy();
			this._graphicBounds=null;
			this._vectorgraphArray=null;
			this._sp && (this._sp._renderType=0);
			this._sp=null;
		}

		/**
		*<p>清空绘制命令。</p>
		*@param recoverCmds 是否回收绘图指令
		*/
		__proto.clear=function(recoverCmds){
			(recoverCmds===void 0)&& (recoverCmds=false);
			if (recoverCmds){
				var tCmd=this._one;
				if (this._cmds){
					var i=0,len=this._cmds.length;
					for (i=0;i < len;i++){
						tCmd=this._cmds[i];
						if (tCmd && (tCmd.callee===Render._context._drawTexture || tCmd.callee===Render._context._drawTextureWithTransform)){
							tCmd[0]=null;
							Graphics._cache.push(tCmd);
						}
					}
					this._cmds.length=0;
					}else if (tCmd){
					if (tCmd && (tCmd.callee===Render._context._drawTexture || tCmd.callee===Render._context._drawTextureWithTransform)){
						tCmd[0]=null;
						Graphics._cache.push(tCmd);
					}
				}
				}else {
				this._cmds=null;
			}
			this._one=null;
			this._render=this._renderEmpty;
			this._sp && (this._sp._renderType &=~0x01 & ~0x200);
			this._repaint();
			if (this._vectorgraphArray){
				for (i=0,len=this._vectorgraphArray.length;i < len;i++){
					VectorGraphManager.getInstance().deleteShape(this._vectorgraphArray[i]);
				}
				this._vectorgraphArray.length=0;
			}
		}

		/**@private */
		__proto._clearBoundsCache=function(){
			if (this._graphicBounds)this._graphicBounds.reset();
		}

		/**@private */
		__proto._initGraphicBounds=function(){
			if (!this._graphicBounds){
				this._graphicBounds=new GraphicsBounds();
				this._graphicBounds._graphics=this;
			}
		}

		/**
		*@private
		*重绘此对象。
		*/
		__proto._repaint=function(){
			this._clearBoundsCache();
			this._sp && this._sp.repaint();
		}

		/**@private */
		__proto._isOnlyOne=function(){
			return !this._cmds || this._cmds.length===0;
		}

		/**
		*获取位置及宽高信息矩阵(比较耗CPU，频繁使用会造成卡顿，尽量少用)。
		*@param realSize （可选）使用图片的真实大小，默认为false
		*@return 位置与宽高组成的 一个 Rectangle 对象。
		*/
		__proto.getBounds=function(realSize){
			(realSize===void 0)&& (realSize=false);
			this._initGraphicBounds();
			return this._graphicBounds.getBounds(realSize);
		}

		/**
		*@private
		*@param realSize （可选）使用图片的真实大小，默认为false
		*获取端点列表。
		*/
		__proto.getBoundPoints=function(realSize){
			(realSize===void 0)&& (realSize=false);
			this._initGraphicBounds();
			return this._graphicBounds.getBoundPoints(realSize);
		}

		__proto._addCmd=function(a){
			this._cmds=this._cmds || [];
			a.callee=a.shift();
			this._cmds.push(a);
		}

		/**
		*绘制纹理。
		*@param tex 纹理。
		*@param x （可选）X轴偏移量。
		*@param y （可选）Y轴偏移量。
		*@param width （可选）宽度。
		*@param height （可选）高度。
		*@param m （可选）矩阵信息。
		*@param alpha （可选）透明度。
		*/
		__proto.drawTexture=function(tex,x,y,width,height,m,alpha){
			(x===void 0)&& (x=0);
			(y===void 0)&& (y=0);
			(width===void 0)&& (width=0);
			(height===void 0)&& (height=0);
			(alpha===void 0)&& (alpha=1);
			if (!tex || alpha < 0.01)return null;
			if (!width)width=tex.sourceWidth;
			if (!height)height=tex.sourceHeight;
			var wRate=width / tex.sourceWidth;
			var hRate=height / tex.sourceHeight;
			width=tex.width *wRate;
			height=tex.height *hRate;
			if (tex.loaded && (width <=0 || height <=0))return null;
			x+=tex.offsetX *wRate;
			y+=tex.offsetY *hRate;
			this._sp && (this._sp._renderType |=0x200);
			if (Graphics._cache.length){
				var args=Graphics._cache.pop();
				args[0]=tex;
				args[1]=x;
				args[2]=y;
				args[3]=width;
				args[4]=height;
				args[5]=m;
				args[6]=alpha;
				}else {
				args=[tex,x,y,width,height,m,alpha];
			}
			args.callee=(m || alpha !=1)? Render._context._drawTextureWithTransform :Render._context._drawTexture;
			if (this._one==null && !m && alpha==1){
				this._one=args;
				this._render=this._renderOneImg;
				}else {
				this._saveToCmd(args.callee,args);
			}
			if (!tex.loaded){
				tex.once("loaded",this,this._textureLoaded,[tex,args]);
			}
			this._repaint();
			return args;
		}

		/**
		*@private 清理贴图并替换为最新的
		*@param tex
		*/
		__proto.cleanByTexture=function(tex,x,y,width,height){
			(width===void 0)&& (width=0);
			(height===void 0)&& (height=0);
			if (!tex)return this.clear();
			if (this._one && this._render===this._renderOneImg){
				if (!width)width=tex.sourceWidth;
				if (!height)height=tex.sourceHeight;
				var wRate=width / tex.sourceWidth;
				var hRate=height / tex.sourceHeight;
				width=tex.width *wRate;
				height=tex.height *hRate;
				x+=tex.offsetX *wRate;
				y+=tex.offsetY *hRate;
				this._one[0]=tex;
				this._one[1]=x;
				this._one[2]=y;
				this._one[3]=width;
				this._one[4]=height;
				}else {
				this.clear();
				tex && this.drawTexture(tex,x,y,width,height);
			}
		}

		/**
		*批量绘制同样纹理。
		*@param tex 纹理。
		*@param pos 绘制次数和坐标。
		*/
		__proto.drawTextures=function(tex,pos){
			if (!tex)return;
			this._saveToCmd(Render._context._drawTextures,[tex,pos]);
		}

		/**
		*用texture填充。
		*@param tex 纹理。
		*@param x X轴偏移量。
		*@param y Y轴偏移量。
		*@param width （可选）宽度。
		*@param height （可选）高度。
		*@param type （可选）填充类型 repeat|repeat-x|repeat-y|no-repeat
		*@param offset （可选）贴图纹理偏移
		*
		*/
		__proto.fillTexture=function(tex,x,y,width,height,type,offset){
			(width===void 0)&& (width=0);
			(height===void 0)&& (height=0);
			(type===void 0)&& (type="repeat");
			if (!tex)return;
			var args=[tex,x,y,width,height,type,offset || Point.EMPTY,{}];
			if (!tex.loaded){
				tex.once("loaded",this,this._textureLoaded,[tex,args]);
			}
			this._saveToCmd(Render._context._fillTexture,args);
		}

		__proto._textureLoaded=function(tex,param){
			param[3]=param[3] || tex.width;
			param[4]=param[4] || tex.height;
			this._repaint();
		}

		/**
		*@private
		*保存到命令流。
		*/
		__proto._saveToCmd=function(fun,args){
			this._sp && (this._sp._renderType |=0x200);
			if (this._one==null){
				this._one=args;
				this._render=this._renderOne;
				}else {
				this._sp && (this._sp._renderType &=~0x01);
				this._render=this._renderAll;
				(this._cmds || (this._cmds=[])).length===0 && this._cmds.push(this._one);
				this._cmds.push(args);
			}
			args.callee=fun;
			this._repaint();
			return args;
		}

		/**
		*设置剪裁区域，超出剪裁区域的坐标不显示。
		*@param x X 轴偏移量。
		*@param y Y 轴偏移量。
		*@param width 宽度。
		*@param height 高度。
		*/
		__proto.clipRect=function(x,y,width,height){
			this._saveToCmd(Render._context._clipRect,[x,y,width,height]);
		}

		/**
		*在画布上绘制文本。
		*@param text 在画布上输出的文本。
		*@param x 开始绘制文本的 x 坐标位置（相对于画布）。
		*@param y 开始绘制文本的 y 坐标位置（相对于画布）。
		*@param font 定义字号和字体，比如"20px Arial"。
		*@param color 定义文本颜色，比如"#ff0000"。
		*@param textAlign 文本对齐方式，可选值："left"，"center"，"right"。
		*/
		__proto.fillText=function(text,x,y,font,color,textAlign){
			this._saveToCmd(Render._context._fillText,[text,x,y,font || Font.defaultFont,color,textAlign]);
		}

		/**
		*在画布上绘制“被填充且镶边的”文本。
		*@param text 在画布上输出的文本。
		*@param x 开始绘制文本的 x 坐标位置（相对于画布）。
		*@param y 开始绘制文本的 y 坐标位置（相对于画布）。
		*@param font 定义字体和字号，比如"20px Arial"。
		*@param fillColor 定义文本颜色，比如"#ff0000"。
		*@param borderColor 定义镶边文本颜色。
		*@param lineWidth 镶边线条宽度。
		*@param textAlign 文本对齐方式，可选值："left"，"center"，"right"。
		*/
		__proto.fillBorderText=function(text,x,y,font,fillColor,borderColor,lineWidth,textAlign){
			this._saveToCmd(Render._context._fillBorderText,[text,x,y,font || Font.defaultFont,fillColor,borderColor,lineWidth,textAlign]);
		}

		/**
		*在画布上绘制文本（没有填色）。文本的默认颜色是黑色。
		*@param text 在画布上输出的文本。
		*@param x 开始绘制文本的 x 坐标位置（相对于画布）。
		*@param y 开始绘制文本的 y 坐标位置（相对于画布）。
		*@param font 定义字体和字号，比如"20px Arial"。
		*@param color 定义文本颜色，比如"#ff0000"。
		*@param lineWidth 线条宽度。
		*@param textAlign 文本对齐方式，可选值："left"，"center"，"right"。
		*/
		__proto.strokeText=function(text,x,y,font,color,lineWidth,textAlign){
			this._saveToCmd(Render._context._strokeText,[text,x,y,font || Font.defaultFont,color,lineWidth,textAlign]);
		}

		/**
		*设置透明度。
		*@param value 透明度。
		*/
		__proto.alpha=function(value){
			this._saveToCmd(Render._context._alpha,[value]);
		}

		/**
		*设置当前透明度。
		*@param value 透明度。
		*/
		__proto.setAlpha=function(value){
			this._saveToCmd(Render._context._setAlpha,[value]);
		}

		/**
		*替换绘图的当前转换矩阵。
		*@param mat 矩阵。
		*@param pivotX （可选）水平方向轴心点坐标。
		*@param pivotY （可选）垂直方向轴心点坐标。
		*/
		__proto.transform=function(matrix,pivotX,pivotY){
			(pivotX===void 0)&& (pivotX=0);
			(pivotY===void 0)&& (pivotY=0);
			this._saveToCmd(Render._context._transform,[matrix,pivotX,pivotY]);
		}

		/**
		*旋转当前绘图。(推荐使用transform，性能更高)
		*@param angle 旋转角度，以弧度计。
		*@param pivotX （可选）水平方向轴心点坐标。
		*@param pivotY （可选）垂直方向轴心点坐标。
		*/
		__proto.rotate=function(angle,pivotX,pivotY){
			(pivotX===void 0)&& (pivotX=0);
			(pivotY===void 0)&& (pivotY=0);
			this._saveToCmd(Render._context._rotate,[angle,pivotX,pivotY]);
		}

		/**
		*缩放当前绘图至更大或更小。(推荐使用transform，性能更高)
		*@param scaleX 水平方向缩放值。
		*@param scaleY 垂直方向缩放值。
		*@param pivotX （可选）水平方向轴心点坐标。
		*@param pivotY （可选）垂直方向轴心点坐标。
		*/
		__proto.scale=function(scaleX,scaleY,pivotX,pivotY){
			(pivotX===void 0)&& (pivotX=0);
			(pivotY===void 0)&& (pivotY=0);
			this._saveToCmd(Render._context._scale,[scaleX,scaleY,pivotX,pivotY]);
		}

		/**
		*重新映射画布上的 (0,0)位置。
		*@param x 添加到水平坐标（x）上的值。
		*@param y 添加到垂直坐标（y）上的值。
		*/
		__proto.translate=function(x,y){
			this._saveToCmd(Render._context._translate,[x,y]);
		}

		/**
		*保存当前环境的状态。
		*/
		__proto.save=function(){
			this._saveToCmd(Render._context._save,[]);
		}

		/**
		*返回之前保存过的路径状态和属性。
		*/
		__proto.restore=function(){
			this._saveToCmd(Render._context._restore,[]);
		}

		/**
		*@private
		*替换文本内容。
		*@param text 文本内容。
		*@return 替换成功则值为true，否则值为flase。
		*/
		__proto.replaceText=function(text){
			this._repaint();
			var cmds=this._cmds;
			if (!cmds){
				if (this._one && this._isTextCmd(this._one.callee)){
					if (this._one[0].toUpperCase)this._one[0]=text;
					else this._one[0].setText(text);
					return true;
				}
				}else {
				for (var i=cmds.length-1;i >-1;i--){
					if (this._isTextCmd(cmds[i].callee)){
						if (cmds[i][0].toUpperCase)cmds[i][0]=text;
						else cmds[i][0].setText(text);
						return true;
					}
				}
			}
			return false;
		}

		/**@private */
		__proto._isTextCmd=function(fun){
			return fun===Render._context._fillText || fun===Render._context._fillBorderText || fun===Render._context._strokeText;
		}

		/**
		*@private
		*替换文本颜色。
		*@param color 颜色。
		*/
		__proto.replaceTextColor=function(color){
			this._repaint();
			var cmds=this._cmds;
			if (!cmds){
				if (this._one && this._isTextCmd(this._one.callee)){
					this._one[4]=color;
					if (!this._one[0].toUpperCase)this._one[0].changed=true;
				}
				}else {
				for (var i=cmds.length-1;i >-1;i--){
					if (this._isTextCmd(cmds[i].callee)){
						cmds[i][4]=color;
						if (!cmds[i][0].toUpperCase)cmds[i][0].changed=true;
					}
				}
			}
		}

		/**
		*加载并显示一个图片。
		*@param url 图片地址。
		*@param x （可选）显示图片的x位置。
		*@param y （可选）显示图片的y位置。
		*@param width （可选）显示图片的宽度，设置为0表示使用图片默认宽度。
		*@param height （可选）显示图片的高度，设置为0表示使用图片默认高度。
		*@param complete （可选）加载完成回调。
		*/
		__proto.loadImage=function(url,x,y,width,height,complete){
			var _$this=this;
			(x===void 0)&& (x=0);
			(y===void 0)&& (y=0);
			(width===void 0)&& (width=0);
			(height===void 0)&& (height=0);
			var tex=Loader.getRes(url);
			if (tex)onloaded(tex);
			else Laya.loader.load(url,Handler.create(null,onloaded),null,"image");
			function onloaded (tex){
				if (tex){
					_$this.drawTexture(tex,x,y,width,height);
					if (complete !=null)complete.call(_$this._sp,tex);
				}
			}
		}

		/**
		*@private
		*/
		__proto._renderEmpty=function(sprite,context,x,y){}
		/**
		*@private
		*/
		__proto._renderAll=function(sprite,context,x,y){
			var cmds=this._cmds,cmd;
			for (var i=0,n=cmds.length;i < n;i++){
				(cmd=cmds[i]).callee.call(context,x,y,cmd);
			}
		}

		/**
		*@private
		*/
		__proto._renderOne=function(sprite,context,x,y){
			this._one.callee.call(context,x,y,this._one);
		}

		/**
		*@private
		*/
		__proto._renderOneImg=function(sprite,context,x,y){
			this._one.callee.call(context,x,y,this._one);
			if (sprite._renderType!==2305){
				sprite._renderType |=0x01;
			}
		}

		/**
		*绘制一条线。
		*@param fromX X轴开始位置。
		*@param fromY Y轴开始位置。
		*@param toX X轴结束位置。
		*@param toY Y轴结束位置。
		*@param lineColor 颜色。
		*@param lineWidth （可选）线条宽度。
		*/
		__proto.drawLine=function(fromX,fromY,toX,toY,lineColor,lineWidth){
			(lineWidth===void 0)&& (lineWidth=1);
			var tId=0;
			if (Render.isWebGL){
				tId=VectorGraphManager.getInstance().getId();
				if (this._vectorgraphArray==null)this._vectorgraphArray=[];
				this._vectorgraphArray.push(tId);
			};
			var offset=lineWidth % 2===0 ? 0 :0.5;
			var arr=[fromX+offset,fromY+offset,toX+offset,toY+offset,lineColor,lineWidth,tId];
			this._saveToCmd(Render._context._drawLine,arr);
		}

		/**
		*绘制一系列线段。
		*@param x 开始绘制的X轴位置。
		*@param y 开始绘制的Y轴位置。
		*@param points 线段的点集合。格式:[x1,y1,x2,y2,x3,y3...]。
		*@param lineColor 线段颜色，或者填充绘图的渐变对象。
		*@param lineWidth （可选）线段宽度。
		*/
		__proto.drawLines=function(x,y,points,lineColor,lineWidth){
			(lineWidth===void 0)&& (lineWidth=1);
			var tId=0;
			if (!points || points.length < 4)return;
			if (Render.isWebGL){
				tId=VectorGraphManager.getInstance().getId();
				if (this._vectorgraphArray==null)this._vectorgraphArray=[];
				this._vectorgraphArray.push(tId);
			};
			var offset=lineWidth % 2===0 ? 0 :0.5;
			var arr=[x+offset,y+offset,points,lineColor,lineWidth,tId];
			this._saveToCmd(Render._context._drawLines,arr);
		}

		/**
		*绘制一系列曲线。
		*@param x 开始绘制的 X 轴位置。
		*@param y 开始绘制的 Y 轴位置。
		*@param points 线段的点集合，格式[startx,starty,ctrx,ctry,startx,starty...]。
		*@param lineColor 线段颜色，或者填充绘图的渐变对象。
		*@param lineWidth （可选）线段宽度。
		*/
		__proto.drawCurves=function(x,y,points,lineColor,lineWidth){
			(lineWidth===void 0)&& (lineWidth=1);
			var arr=[x,y,points,lineColor,lineWidth];
			this._saveToCmd(Render._context._drawCurves,arr);
		}

		/**
		*绘制矩形。
		*@param x 开始绘制的 X 轴位置。
		*@param y 开始绘制的 Y 轴位置。
		*@param width 矩形宽度。
		*@param height 矩形高度。
		*@param fillColor 填充颜色，或者填充绘图的渐变对象。
		*@param lineColor （可选）边框颜色，或者填充绘图的渐变对象。
		*@param lineWidth （可选）边框宽度。
		*/
		__proto.drawRect=function(x,y,width,height,fillColor,lineColor,lineWidth){
			(lineWidth===void 0)&& (lineWidth=1);
			var offset=lineColor ? lineWidth / 2 :0;
			var lineOffset=lineColor ? lineWidth :0;
			var arr=[x+offset,y+offset,width-lineOffset,height-lineOffset,fillColor,lineColor,lineWidth];
			this._saveToCmd(Render._context._drawRect,arr);
		}

		/**
		*绘制圆形。
		*@param x 圆点X 轴位置。
		*@param y 圆点Y 轴位置。
		*@param radius 半径。
		*@param fillColor 填充颜色，或者填充绘图的渐变对象。
		*@param lineColor （可选）边框颜色，或者填充绘图的渐变对象。
		*@param lineWidth （可选）边框宽度。
		*/
		__proto.drawCircle=function(x,y,radius,fillColor,lineColor,lineWidth){
			(lineWidth===void 0)&& (lineWidth=1);
			var offset=lineColor ? lineWidth / 2 :0;
			var tId=0;
			if (Render.isWebGL){
				tId=VectorGraphManager.getInstance().getId();
				if (this._vectorgraphArray==null)this._vectorgraphArray=[];
				this._vectorgraphArray.push(tId);
			};
			var arr=[x,y,radius-offset,fillColor,lineColor,lineWidth,tId];
			this._saveToCmd(Render._context._drawCircle,arr);
		}

		/**
		*绘制扇形。
		*@param x 开始绘制的 X 轴位置。
		*@param y 开始绘制的 Y 轴位置。
		*@param radius 扇形半径。
		*@param startAngle 开始角度。
		*@param endAngle 结束角度。
		*@param fillColor 填充颜色，或者填充绘图的渐变对象。
		*@param lineColor （可选）边框颜色，或者填充绘图的渐变对象。
		*@param lineWidth （可选）边框宽度。
		*/
		__proto.drawPie=function(x,y,radius,startAngle,endAngle,fillColor,lineColor,lineWidth){
			(lineWidth===void 0)&& (lineWidth=1);
			var offset=lineColor ? lineWidth / 2 :0;
			var lineOffset=lineColor ? lineWidth :0;
			var tId=0;
			if (Render.isWebGL){
				tId=VectorGraphManager.getInstance().getId();
				if (this._vectorgraphArray==null)this._vectorgraphArray=[];
				this._vectorgraphArray.push(tId);
			};
			var arr=[x+offset,y+offset,radius-lineOffset,startAngle,endAngle,fillColor,lineColor,lineWidth,tId];
			arr[3]=Utils$1.toRadian(startAngle);
			arr[4]=Utils$1.toRadian(endAngle);
			this._saveToCmd(Render._context._drawPie,arr);
		}

		/**
		*绘制多边形。
		*@param x 开始绘制的 X 轴位置。
		*@param y 开始绘制的 Y 轴位置。
		*@param points 多边形的点集合。
		*@param fillColor 填充颜色，或者填充绘图的渐变对象。
		*@param lineColor （可选）边框颜色，或者填充绘图的渐变对象。
		*@param lineWidth （可选）边框宽度。
		*/
		__proto.drawPoly=function(x,y,points,fillColor,lineColor,lineWidth){
			(lineWidth===void 0)&& (lineWidth=1);
			var tId=0;
			if (Render.isWebGL){
				tId=VectorGraphManager.getInstance().getId();
				if (this._vectorgraphArray==null)this._vectorgraphArray=[];
				this._vectorgraphArray.push(tId);
				var tIsConvexPolygon=false;
				if (points.length > 6){
					tIsConvexPolygon=false;
					}else {
					tIsConvexPolygon=true;
				}
			};
			var offset=lineColor ? (lineWidth % 2===0 ? 0 :0.5):0;
			var arr=[x+offset,y+offset,points,fillColor,lineColor,lineWidth,tId,tIsConvexPolygon];
			this._saveToCmd(Render._context._drawPoly,arr);
		}

		/**
		*绘制路径。
		*@param x 开始绘制的 X 轴位置。
		*@param y 开始绘制的 Y 轴位置。
		*@param paths 路径集合，路径支持以下格式：[["moveTo",x,y],["lineTo",x,y],["arcTo",x1,y1,x2,y2,r],["closePath"]]。
		*@param brush （可选）刷子定义，支持以下设置{fillStyle:"#FF0000"}。
		*@param pen （可选）画笔定义，支持以下设置{strokeStyle,lineWidth,lineJoin:"bevel|round|miter",lineCap:"butt|round|square",miterLimit}。
		*/
		__proto.drawPath=function(x,y,paths,brush,pen){
			var arr=[x,y,paths,brush,pen];
			this._saveToCmd(Render._context._drawPath,arr);
		}

		/**
		*@private
		*命令流。存储了所有绘制命令。
		*/
		__getset(0,__proto,'cmds',function(){
			return this._cmds;
			},function(value){
			this._sp && (this._sp._renderType |=0x200);
			this._cmds=value;
			this._render=this._renderAll;
			this._repaint();
		});

		Graphics.__init__=function(){
			if (Render.isConchNode){
				var from=laya.display.Graphics.prototype;
				var to=ConchGraphics.prototype;
				var list=["clear","destroy","alpha","rotate","transform","scale","translate","save","restore","clipRect","blendMode","fillText","fillBorderText","_fands","drawRect","drawCircle","drawPie","drawPoly","drawPath","drawImageM","drawLine","drawLines","_drawPs","drawCurves","replaceText","replaceTextColor","_fillImage","fillTexture","setSkinMesh","drawParticle","drawImageS"];
				for (var i=0,len=list.length;i <=len;i++){
					var temp=list[i];
					from[temp]=to[temp];
				}
				from._saveToCmd=null;
				if (to.drawImageS){
					from.drawTextures=function (tex,pos){
						if (!tex)return;
						if (!(tex.loaded && tex.bitmap && tex.source)){
							return;
						};
						var uv=tex.uv,w=tex.bitmap.width,h=tex.bitmap.height;
						this.drawImageS(tex.bitmap.source,uv[0] *w,uv[1] *h,(uv[2]-uv[0])*w,(uv[5]-uv[3])*h,tex.offsetX,tex.offsetY,tex.width,tex.height,pos);
					}
				}
				from.drawTexture=function (tex,x,y,width,height,m,alpha){
					(x===void 0)&& (x=0);
					(y===void 0)&& (y=0);
					(width===void 0)&& (width=0);
					(height===void 0)&& (height=0);
					(alpha===void 0)&& (alpha=1);
					if (!tex)return;
					if (!tex.loaded){
						tex.once("loaded",this,function(){
							this.drawTexture(tex,x,y,width,height,m);
						});
						return;
					}
					if (!(tex.loaded && tex.bitmap && tex.source)){
						return;
					}
					if (!width)width=tex.sourceWidth;
					if (!height)height=tex.sourceHeight;
					width=width-tex.sourceWidth+tex.width;
					height=height-tex.sourceHeight+tex.height;
					if (width <=0 || height <=0)return;
					x+=tex.offsetX;
					y+=tex.offsetY;
					var uv=tex.uv,w=tex.bitmap.width,h=tex.bitmap.height;
					this.drawImageM(tex.bitmap.source,uv[0] *w,uv[1] *h,(uv[2]-uv[0])*w,(uv[5]-uv[3])*h,x,y,width,height,m,alpha);
					this._repaint();
				}
				from.fillTexture=function (tex,x,y,width,height,type,offset){
					(width===void 0)&& (width=0);
					(height===void 0)&& (height=0);
					(type===void 0)&& (type="repeat");
					if (!tex)return;
					if (tex.loaded){
						var ctxi=Render._context.ctx;
						var w=tex.bitmap.width,h=tex.bitmap.height,uv=tex.uv;
						var pat;
						if (tex.uv !=Texture.DEF_UV){
							pat=ctxi.createPattern(tex.bitmap.source,type,uv[0] *w,uv[1] *h,(uv[2]-uv[0])*w,(uv[5]-uv[3])*h);
							}else {
							pat=ctxi.createPattern(tex.bitmap.source,type);
						};
						var sX=0,sY=0;
						if (offset){
							x+=offset.x % tex.width;
							y+=offset.y % tex.height;
							sX-=offset.x % tex.width;
							sY-=offset.y % tex.height;
						}
						this._fillImage(pat,x,y,sX,sY,width,height);
					}
				}
			}
		}

		Graphics._cache=[];
		return Graphics;
	})()


	/**
	*@private
	*Graphic bounds数据类
	*/
	//class laya.display.GraphicsBounds
	var GraphicsBounds=(function(){
		function GraphicsBounds(){
			//this._temp=null;
			//this._bounds=null;
			//this._rstBoundPoints=null;
			this._cacheBoundsType=false;
			//this._graphics=null;
		}

		__class(GraphicsBounds,'laya.display.GraphicsBounds');
		var __proto=GraphicsBounds.prototype;
		/**
		*销毁
		*/
		__proto.destroy=function(){
			this._graphics=null;
			this._temp=null;
			this._rstBoundPoints=null;
			this._bounds=null;
		}

		/**
		*重置数据
		*/
		__proto.reset=function(){
			this._temp && (this._temp.length=0);
		}

		/**
		*获取位置及宽高信息矩阵(比较耗CPU，频繁使用会造成卡顿，尽量少用)。
		*@param realSize （可选）使用图片的真实大小，默认为false
		*@return 位置与宽高组成的 一个 Rectangle 对象。
		*/
		__proto.getBounds=function(realSize){
			(realSize===void 0)&& (realSize=false);
			if (!this._bounds || !this._temp || this._temp.length < 1 || realSize !=this._cacheBoundsType){
				this._bounds=Rectangle._getWrapRec(this.getBoundPoints(realSize),this._bounds)
			}
			this._cacheBoundsType=realSize;
			return this._bounds;
		}

		/**
		*@private
		*@param realSize （可选）使用图片的真实大小，默认为false
		*获取端点列表。
		*/
		__proto.getBoundPoints=function(realSize){
			(realSize===void 0)&& (realSize=false);
			if (!this._temp || this._temp.length < 1 || realSize !=this._cacheBoundsType)
				this._temp=this._getCmdPoints(realSize);
			this._cacheBoundsType=realSize;
			return this._rstBoundPoints=Utils$1.copyArray(this._rstBoundPoints,this._temp);
		}

		__proto._getCmdPoints=function(realSize){
			(realSize===void 0)&& (realSize=false);
			var context=Render._context;
			var cmds=this._graphics.cmds;
			var rst;
			rst=this._temp || (this._temp=[]);
			rst.length=0;
			if (!cmds && this._graphics._one !=null){
				GraphicsBounds._tempCmds.length=0;
				GraphicsBounds._tempCmds.push(this._graphics._one);
				cmds=GraphicsBounds._tempCmds;
			}
			if (!cmds)
				return rst;
			var matrixs;
			matrixs=GraphicsBounds._tempMatrixArrays;
			matrixs.length=0;
			var tMatrix=GraphicsBounds._initMatrix;
			tMatrix.identity();
			var tempMatrix=GraphicsBounds._tempMatrix;
			var cmd;
			var tex;
			for (var i=0,n=cmds.length;i < n;i++){
				cmd=cmds[i];
				switch (cmd.callee){
					case context._save:
					case 7:
						matrixs.push(tMatrix);
						tMatrix=tMatrix.clone();
						break ;
					case context._restore:
					case 8:
						tMatrix=matrixs.pop();
						break ;
					case context._scale:
					case 5:
						tempMatrix.identity();
						tempMatrix.translate(-cmd[2],-cmd[3]);
						tempMatrix.scale(cmd[0],cmd[1]);
						tempMatrix.translate(cmd[2],cmd[3]);
						this._switchMatrix(tMatrix,tempMatrix);
						break ;
					case context._rotate:
					case 3:
						tempMatrix.identity();
						tempMatrix.translate(-cmd[1],-cmd[2]);
						tempMatrix.rotate(cmd[0]);
						tempMatrix.translate(cmd[1],cmd[2]);
						this._switchMatrix(tMatrix,tempMatrix);
						break ;
					case context._translate:
					case 6:
						tempMatrix.identity();
						tempMatrix.translate(cmd[0],cmd[1]);
						this._switchMatrix(tMatrix,tempMatrix);
						break ;
					case context._transform:
					case 4:
						tempMatrix.identity();
						tempMatrix.translate(-cmd[1],-cmd[2]);
						tempMatrix.concat(cmd[0]);
						tempMatrix.translate(cmd[1],cmd[2]);
						this._switchMatrix(tMatrix,tempMatrix);
						break ;
					case 16:
					case 24:
						GraphicsBounds._addPointArrToRst(rst,Rectangle._getBoundPointS(cmd[0],cmd[1],cmd[2],cmd[3]),tMatrix);
						break ;
					case 17:
						tMatrix.copyTo(tempMatrix);
						tempMatrix.concat(cmd[4]);
						GraphicsBounds._addPointArrToRst(rst,Rectangle._getBoundPointS(cmd[0],cmd[1],cmd[2],cmd[3]),tempMatrix);
						break ;
					case context._drawTexture:
						tex=cmd[0];
						if (realSize){
							if (cmd[3] && cmd[4]){
								GraphicsBounds._addPointArrToRst(rst,Rectangle._getBoundPointS(cmd[1],cmd[2],cmd[3],cmd[4]),tMatrix);
								}else {
								tex=cmd[0];
								GraphicsBounds._addPointArrToRst(rst,Rectangle._getBoundPointS(cmd[1],cmd[2],tex.width,tex.height),tMatrix);
							}
							}else {
							var wRate=(cmd[3] || tex.sourceWidth)/ tex.width;
							var hRate=(cmd[4] || tex.sourceHeight)/ tex.height;
							var oWidth=wRate *tex.sourceWidth;
							var oHeight=hRate *tex.sourceHeight;
							var offX=tex.offsetX > 0 ? tex.offsetX :0;
							var offY=tex.offsetY > 0 ? tex.offsetY :0;
							offX *=wRate;
							offY *=hRate;
							GraphicsBounds._addPointArrToRst(rst,Rectangle._getBoundPointS(cmd[1]-offX,cmd[2]-offY,oWidth,oHeight),tMatrix);
						}
						break ;
					case context._fillTexture:
						if (cmd[3] && cmd[4]){
							GraphicsBounds._addPointArrToRst(rst,Rectangle._getBoundPointS(cmd[1],cmd[2],cmd[3],cmd[4]),tMatrix);
							}else {
							tex=cmd[0];
							GraphicsBounds._addPointArrToRst(rst,Rectangle._getBoundPointS(cmd[1],cmd[2],tex.width,tex.height),tMatrix);
						}
						break ;
					case context._drawTextureWithTransform:;
						var drawMatrix;
						if (cmd[5]){
							tMatrix.copyTo(tempMatrix);
							tempMatrix.concat(cmd[5]);
							drawMatrix=tempMatrix;
							}else {
							drawMatrix=tMatrix;
						}
						if (realSize){
							if (cmd[3] && cmd[4]){
								GraphicsBounds._addPointArrToRst(rst,Rectangle._getBoundPointS(cmd[1],cmd[2],cmd[3],cmd[4]),drawMatrix);
								}else {
								tex=cmd[0];
								GraphicsBounds._addPointArrToRst(rst,Rectangle._getBoundPointS(cmd[1],cmd[2],tex.width,tex.height),drawMatrix);
							}
							}else {
							tex=cmd[0];
							wRate=(cmd[3] || tex.sourceWidth)/ tex.width;
							hRate=(cmd[4] || tex.sourceHeight)/ tex.height;
							oWidth=wRate *tex.sourceWidth;
							oHeight=hRate *tex.sourceHeight;
							offX=tex.offsetX > 0 ? tex.offsetX :0;
							offY=tex.offsetY > 0 ? tex.offsetY :0;
							offX *=wRate;
							offY *=hRate;
							GraphicsBounds._addPointArrToRst(rst,Rectangle._getBoundPointS(cmd[1]-offX,cmd[2]-offY,oWidth,oHeight),drawMatrix);
						}
						break ;
					case context._drawRect:
					case 13:
						GraphicsBounds._addPointArrToRst(rst,Rectangle._getBoundPointS(cmd[0],cmd[1],cmd[2],cmd[3]),tMatrix);
						break ;
					case context._drawCircle:
					case context._fillCircle:
					case 14:
						GraphicsBounds._addPointArrToRst(rst,Rectangle._getBoundPointS(cmd[0]-cmd[2],cmd[1]-cmd[2],cmd[2]+cmd[2],cmd[2]+cmd[2]),tMatrix);
						break ;
					case context._drawLine:
					case 20:
						GraphicsBounds._tempPoints.length=0;
						var lineWidth=NaN;
						lineWidth=cmd[5] *0.5;
						if (cmd[0]==cmd[2]){
							GraphicsBounds._tempPoints.push(cmd[0]+lineWidth,cmd[1],cmd[2]+lineWidth,cmd[3],cmd[0]-lineWidth,cmd[1],cmd[2]-lineWidth,cmd[3]);
							}else if (cmd[1]==cmd[3]){
							GraphicsBounds._tempPoints.push(cmd[0],cmd[1]+lineWidth,cmd[2],cmd[3]+lineWidth,cmd[0],cmd[1]-lineWidth,cmd[2],cmd[3]-lineWidth);
							}else {
							GraphicsBounds._tempPoints.push(cmd[0],cmd[1],cmd[2],cmd[3]);
						}
						GraphicsBounds._addPointArrToRst(rst,GraphicsBounds._tempPoints,tMatrix);
						break ;
					case context._drawCurves:
					case 22:
						GraphicsBounds._addPointArrToRst(rst,Bezier.I.getBezierPoints(cmd[2]),tMatrix,cmd[0],cmd[1]);
						break ;
					case context._drawPoly:
					case context._drawLines:
					case 18:
						GraphicsBounds._addPointArrToRst(rst,cmd[2],tMatrix,cmd[0],cmd[1]);
						break ;
					case context._drawPath:
					case 19:
						GraphicsBounds._addPointArrToRst(rst,this._getPathPoints(cmd[2]),tMatrix,cmd[0],cmd[1]);
						break ;
					case context._drawPie:
					case 15:
						GraphicsBounds._addPointArrToRst(rst,this._getPiePoints(cmd[0],cmd[1],cmd[2],cmd[3],cmd[4]),tMatrix);
						break ;
					}
			}
			if (rst.length > 200){
				rst=Utils$1.copyArray(rst,Rectangle._getWrapRec(rst)._getBoundPoints());
			}else if (rst.length > 8)
			rst=GrahamScan.scanPList(rst);
			return rst;
		}

		__proto._switchMatrix=function(tMatix,tempMatrix){
			tempMatrix.concat(tMatix);
			tempMatrix.copyTo(tMatix);
		}

		__proto._getPiePoints=function(x,y,radius,startAngle,endAngle){
			var rst=GraphicsBounds._tempPoints;
			GraphicsBounds._tempPoints.length=0;
			rst.push(x,y);
			var dP=Math.PI / 10;
			var i=NaN;
			for (i=startAngle;i < endAngle;i+=dP){
				rst.push(x+radius *Math.cos(i),y+radius *Math.sin(i));
			}
			if (endAngle !=i){
				rst.push(x+radius *Math.cos(endAngle),y+radius *Math.sin(endAngle));
			}
			return rst;
		}

		__proto._getPathPoints=function(paths){
			var i=0,len=0;
			var rst=GraphicsBounds._tempPoints;
			rst.length=0;
			len=paths.length;
			var tCMD;
			for (i=0;i < len;i++){
				tCMD=paths[i];
				if (tCMD.length > 1){
					rst.push(tCMD[1],tCMD[2]);
					if (tCMD.length > 3){
						rst.push(tCMD[3],tCMD[4]);
					}
				}
			}
			return rst;
		}

		GraphicsBounds._addPointArrToRst=function(rst,points,matrix,dx,dy){
			(dx===void 0)&& (dx=0);
			(dy===void 0)&& (dy=0);
			var i=0,len=0;
			len=points.length;
			for (i=0;i < len;i+=2){
				GraphicsBounds._addPointToRst(rst,points[i]+dx,points[i+1]+dy,matrix);
			}
		}

		GraphicsBounds._addPointToRst=function(rst,x,y,matrix){
			var _tempPoint=Point.TEMP;
			_tempPoint.setTo(x ? x :0,y ? y :0);
			matrix.transformPoint(_tempPoint);
			rst.push(_tempPoint.x,_tempPoint.y);
		}

		GraphicsBounds._tempPoints=[];
		GraphicsBounds._tempMatrixArrays=[];
		GraphicsBounds._tempCmds=[];
		__static(GraphicsBounds,
		['_tempMatrix',function(){return this._tempMatrix=new Matrix();},'_initMatrix',function(){return this._initMatrix=new Matrix();}
		]);
		return GraphicsBounds;
	})()


	/**
	*<code>Keyboard</code> 类的属性是一些常数，这些常数表示控制游戏时最常用的键。
	*/
	//class laya.events.Keyboard
	var Keyboard$1=(function(){
		function Keyboard(){};
		__class(Keyboard,'laya.events.Keyboard',null,'Keyboard$1');
		Keyboard.NUMBER_0=48;
		Keyboard.NUMBER_1=49;
		Keyboard.NUMBER_2=50;
		Keyboard.NUMBER_3=51;
		Keyboard.NUMBER_4=52;
		Keyboard.NUMBER_5=53;
		Keyboard.NUMBER_6=54;
		Keyboard.NUMBER_7=55;
		Keyboard.NUMBER_8=56;
		Keyboard.NUMBER_9=57;
		Keyboard.A=65;
		Keyboard.B=66;
		Keyboard.C=67;
		Keyboard.D=68;
		Keyboard.E=69;
		Keyboard.F=70;
		Keyboard.G=71;
		Keyboard.H=72;
		Keyboard.I=73;
		Keyboard.J=74;
		Keyboard.K=75;
		Keyboard.L=76;
		Keyboard.M=77;
		Keyboard.N=78;
		Keyboard.O=79;
		Keyboard.P=80;
		Keyboard.Q=81;
		Keyboard.R=82;
		Keyboard.S=83;
		Keyboard.T=84;
		Keyboard.U=85;
		Keyboard.V=86;
		Keyboard.W=87;
		Keyboard.X=88;
		Keyboard.Y=89;
		Keyboard.Z=90;
		Keyboard.F1=112;
		Keyboard.F2=113;
		Keyboard.F3=114;
		Keyboard.F4=115;
		Keyboard.F5=116;
		Keyboard.F6=117;
		Keyboard.F7=118;
		Keyboard.F8=119;
		Keyboard.F9=120;
		Keyboard.F10=121;
		Keyboard.F11=122;
		Keyboard.F12=123;
		Keyboard.F13=124;
		Keyboard.F14=125;
		Keyboard.F15=126;
		Keyboard.NUMPAD=21;
		Keyboard.NUMPAD_0=96;
		Keyboard.NUMPAD_1=97;
		Keyboard.NUMPAD_2=98;
		Keyboard.NUMPAD_3=99;
		Keyboard.NUMPAD_4=100;
		Keyboard.NUMPAD_5=101;
		Keyboard.NUMPAD_6=102;
		Keyboard.NUMPAD_7=103;
		Keyboard.NUMPAD_8=104;
		Keyboard.NUMPAD_9=105;
		Keyboard.NUMPAD_ADD=107;
		Keyboard.NUMPAD_DECIMAL=110;
		Keyboard.NUMPAD_DIVIDE=111;
		Keyboard.NUMPAD_ENTER=108;
		Keyboard.NUMPAD_MULTIPLY=106;
		Keyboard.NUMPAD_SUBTRACT=109;
		Keyboard.SEMICOLON=186;
		Keyboard.EQUAL=187;
		Keyboard.COMMA=188;
		Keyboard.MINUS=189;
		Keyboard.PERIOD=190;
		Keyboard.SLASH=191;
		Keyboard.BACKQUOTE=192;
		Keyboard.LEFTBRACKET=219;
		Keyboard.BACKSLASH=220;
		Keyboard.RIGHTBRACKET=221;
		Keyboard.QUOTE=222;
		Keyboard.ALTERNATE=18;
		Keyboard.BACKSPACE=8;
		Keyboard.CAPS_LOCK=20;
		Keyboard.COMMAND=15;
		Keyboard.CONTROL=17;
		Keyboard.DELETE=46;
		Keyboard.ENTER=13;
		Keyboard.ESCAPE=27;
		Keyboard.PAGE_UP=33;
		Keyboard.PAGE_DOWN=34;
		Keyboard.END=35;
		Keyboard.HOME=36;
		Keyboard.LEFT=37;
		Keyboard.UP=38;
		Keyboard.RIGHT=39;
		Keyboard.DOWN=40;
		Keyboard.SHIFT=16;
		Keyboard.SPACE=32;
		Keyboard.TAB=9;
		Keyboard.INSERT=45;
		return Keyboard;
	})()


	/**
	*<p><code>KeyBoardManager</code> 是键盘事件管理类。该类从浏览器中接收键盘事件，并派发该事件。</p>
	*<p>派发事件时若 Stage.focus 为空则只从 Stage 上派发该事件，否则将从 Stage.focus 对象开始一直冒泡派发该事件。所以在 Laya.stage 上监听键盘事件一定能够收到，如果在其他地方监听，则必须处在Stage.focus的冒泡链上才能收到该事件。</p>
	*<p>用户可以通过代码 Laya.stage.focus=someNode 的方式来设置focus对象。</p>
	*<p>用户可统一的根据事件对象中 e.keyCode 来判断按键类型，该属性兼容了不同浏览器的实现。</p>
	*/
	//class laya.events.KeyBoardManager
	var KeyBoardManager=(function(){
		function KeyBoardManager(){};
		__class(KeyBoardManager,'laya.events.KeyBoardManager');
		KeyBoardManager.__init__=function(){
			KeyBoardManager._addEvent("keydown");
			KeyBoardManager._addEvent("keypress");
			KeyBoardManager._addEvent("keyup");
		}

		KeyBoardManager._addEvent=function(type){
			Browser.document.addEventListener(type,function(e){
				laya.events.KeyBoardManager._dispatch(e,type);
			},true);
		}

		KeyBoardManager._dispatch=function(e,type){
			if (!KeyBoardManager.enabled)return;
			KeyBoardManager._event._stoped=false;
			KeyBoardManager._event.nativeEvent=e;
			KeyBoardManager._event.keyCode=e.keyCode || e.which || e.charCode;
			if (type==="keydown")KeyBoardManager._pressKeys[KeyBoardManager._event.keyCode]=true;
			else if (type==="keyup")KeyBoardManager._pressKeys[KeyBoardManager._event.keyCode]=null;
			var target=(Laya.stage.focus && (Laya.stage.focus.event !=null)&& Laya.stage.focus.displayedInStage)? Laya.stage.focus :Laya.stage;
			var ct=target;
			while (ct){
				ct.event(type,KeyBoardManager._event.setTo(type,ct,target));
				ct=ct.parent;
			}
		}

		KeyBoardManager.hasKeyDown=function(key){
			return KeyBoardManager._pressKeys[key];
		}

		KeyBoardManager._pressKeys={};
		KeyBoardManager.enabled=true;
		__static(KeyBoardManager,
		['_event',function(){return this._event=new Event();}
		]);
		return KeyBoardManager;
	})()


	/**
	*<p><code>MouseManager</code> 是鼠标、触摸交互管理器。</p>
	*<p>鼠标事件流包括捕获阶段、目标阶段、冒泡阶段。<br/>
	*捕获阶段：此阶段引擎会从stage开始递归检测stage及其子对象，直到找到命中的目标对象或者未命中任何对象；<br/>
	*目标阶段：找到命中的目标对象；<br/>
	*冒泡阶段：事件离开目标对象，按节点层级向上逐层通知，直到到达舞台的过程。</p>
	*/
	//class laya.events.MouseManager
	var MouseManager=(function(){
		function MouseManager(){
			this.mouseX=0;
			this.mouseY=0;
			this.disableMouseEvent=false;
			this.mouseDownTime=0;
			this.mouseMoveAccuracy=2;
			this._stage=null;
			this._target=null;
			this._lastMoveTimer=0;
			this._isLeftMouse=false;
			this._eventList=[];
			this._touchIDs={};
			this._id=1;
			this._tTouchID=0;
			this._event=new Event();
			this._matrix=new Matrix();
			this._point=new Point();
			this._rect=new Rectangle();
			this._prePoint=new Point();
			this._curTouchID=NaN;
		}

		__class(MouseManager,'laya.events.MouseManager');
		var __proto=MouseManager.prototype;
		/**
		*@private
		*初始化。
		*/
		__proto.__init__=function(stage,canvas){
			this._stage=stage;
			var _this=this;
			var list=this._eventList;
			canvas.oncontextmenu=function (e){
				if (MouseManager.enabled)return false;
			}
			canvas.addEventListener('mousedown',function(e){
				if (MouseManager.enabled){
					if(!Browser.onIE)e.preventDefault();
					list.push(e);
					_this.mouseDownTime=Browser.now();
				}
			});
			canvas.addEventListener('mouseup',function(e){
				if (MouseManager.enabled){
					e.preventDefault();
					list.push(e);
					_this.mouseDownTime=-Browser.now();
				}
			},true);
			canvas.addEventListener('mousemove',function(e){
				if (MouseManager.enabled){
					e.preventDefault();
					var now=Browser.now();
					if (now-_this._lastMoveTimer < 10)return;
					_this._lastMoveTimer=now;
					list.push(e);
				}
			},true);
			canvas.addEventListener("mouseout",function(e){
				if (MouseManager.enabled)list.push(e);
			})
			canvas.addEventListener("mouseover",function(e){
				if (MouseManager.enabled)list.push(e);
			})
			canvas.addEventListener("touchstart",function(e){
				if (MouseManager.enabled){
					list.push(e);
					if (!Input.isInputting)e.preventDefault();
					_this.mouseDownTime=Browser.now();
				}
			});
			canvas.addEventListener("touchend",function(e){
				if (MouseManager.enabled){
					if (!Input.isInputting)e.preventDefault();
					list.push(e);
					_this.mouseDownTime=-Browser.now();
				}
			},true);
			canvas.addEventListener("touchmove",function(e){
				if (MouseManager.enabled){
					e.preventDefault();
					list.push(e);
				}
			},true);
			canvas.addEventListener("touchcancel",function(e){
				if (MouseManager.enabled){
					e.preventDefault();
					list.push(e);
				}
			},true);
			canvas.addEventListener('mousewheel',function(e){
				if (MouseManager.enabled)list.push(e);
			});
			canvas.addEventListener('DOMMouseScroll',function(e){
				if (MouseManager.enabled)list.push(e);
			});
		}

		__proto.initEvent=function(e,nativeEvent){
			var _this=this;
			_this._event._stoped=false;
			_this._event.nativeEvent=nativeEvent || e;
			_this._target=null;
			this._point.setTo(e.pageX || e.clientX,e.pageY || e.clientY);
			this._stage._canvasTransform.invertTransformPoint(this._point);
			_this.mouseX=this._point.x;
			_this.mouseY=this._point.y;
			_this._event.touchId=e.identifier || 0;
			this._tTouchID=_this._event.touchId;
			var evt;
			evt=TouchManager.I._event;
			evt._stoped=false;
			evt.nativeEvent=_this._event.nativeEvent;
			evt.touchId=_this._event.touchId;
		}

		__proto.checkMouseWheel=function(e){
			this._event.delta=e.wheelDelta ? e.wheelDelta *0.025 :-e.detail;
			var _lastOvers=TouchManager.I.getLastOvers();
			for (var i=0,n=_lastOvers.length;i < n;i++){
				var ele=_lastOvers[i];
				ele.event("mousewheel",this._event.setTo("mousewheel",ele,this._target));
			}
		}

		// _stage.event(Event.MOUSE_WHEEL,_event.setTo(Event.MOUSE_WHEEL,_stage,_target));
		__proto.onMouseMove=function(ele){
			TouchManager.I.onMouseMove(ele,this._tTouchID);
		}

		__proto.onMouseDown=function(ele){
			if (Input.isInputting && Laya.stage.focus && Laya.stage.focus["focus"] && !Laya.stage.focus.contains(this._target)){
				var pre_input=Laya.stage.focus['_tf'] || Laya.stage.focus;
				var new_input=ele['_tf'] || ele;
				if ((new_input instanceof laya.display.Input )&& new_input.multiline==pre_input.multiline)
					pre_input['_focusOut']();
				else
				pre_input.focus=false;
			}
			TouchManager.I.onMouseDown(ele,this._tTouchID,this._isLeftMouse);
		}

		__proto.onMouseUp=function(ele){
			TouchManager.I.onMouseUp(ele,this._tTouchID,this._isLeftMouse);
		}

		__proto.check=function(sp,mouseX,mouseY,callBack){
			this._point.setTo(mouseX,mouseY);
			sp.fromParentPoint(this._point);
			mouseX=this._point.x;
			mouseY=this._point.y;
			var scrollRect=sp.scrollRect;
			if (scrollRect){
				this._rect.setTo(scrollRect.x,scrollRect.y,scrollRect.width,scrollRect.height);
				if (!this._rect.contains(mouseX,mouseY))return false;
			}
			if (!this.disableMouseEvent){
				if (sp.hitTestPrior && !sp.mouseThrough && !this.hitTest(sp,mouseX,mouseY)){
					return false;
				}
				for (var i=sp._childs.length-1;i >-1;i--){
					var child=sp._childs[i];
					if (!child.destroyed && child.mouseEnabled && child.visible){
						if (this.check(child,mouseX,mouseY,callBack))return true;
					}
				}
			};
			var isHit=(sp.hitTestPrior && !sp.mouseThrough && !this.disableMouseEvent)? true :this.hitTest(sp,mouseX,mouseY);
			if (isHit){
				this._target=sp;
				callBack.call(this,sp);
				}else if (callBack===this.onMouseUp && sp===this._stage){
				this._target=this._stage;
				callBack.call(this,this._target);
			}
			return isHit;
		}

		__proto.hitTest=function(sp,mouseX,mouseY){
			var isHit=false;
			if (sp.scrollRect){
				mouseX-=sp.scrollRect.x;
				mouseY-=sp.scrollRect.y;
			}
			if ((sp.hitArea instanceof laya.utils.HitArea )){
				return sp.hitArea.isHit(mouseX,mouseY);
			}
			if (sp.width > 0 && sp.height > 0 || sp.mouseThrough || sp.hitArea){
				if (!sp.mouseThrough){
					var hitRect=this._rect;
					if (sp.hitArea)hitRect=sp.hitArea;
					else hitRect.setTo(0,0,sp.width,sp.height);
					isHit=hitRect.contains(mouseX,mouseY);
					}else {
					isHit=sp.getGraphicBounds().contains(mouseX,mouseY);
				}
			}
			return isHit;
		}

		/**
		*执行事件处理。
		*/
		__proto.runEvent=function(){
			var len=this._eventList.length;
			if (!len)return;
			var _this=this;
			var i=0;
			while (i < len){
				var evt=this._eventList[i];
				if (evt.type!=='mousemove')this._prePoint.x=this._prePoint.y=-1000000;
				switch (evt.type){
					case 'mousedown':
						this._touchIDs[0]=this._id++;
						if (!MouseManager._isTouchRespond){
							_this._isLeftMouse=evt.button===0;
							_this.initEvent(evt);
							_this.check(_this._stage,_this.mouseX,_this.mouseY,_this.onMouseDown);
						}else
						MouseManager._isTouchRespond=false;
						break ;
					case 'mouseup':
						_this._isLeftMouse=evt.button===0;
						_this.initEvent(evt);
						_this.check(_this._stage,_this.mouseX,_this.mouseY,_this.onMouseUp);
						break ;
					case 'mousemove':
						if ((Math.abs(this._prePoint.x-evt.clientX)+Math.abs(this._prePoint.y-evt.clientY))>=this.mouseMoveAccuracy){
							this._prePoint.x=evt.clientX;
							this._prePoint.y=evt.clientY;
							_this.initEvent(evt);
							_this.check(_this._stage,_this.mouseX,_this.mouseY,_this.onMouseMove);
						}
						break ;
					case "touchstart":
						MouseManager._isTouchRespond=true;
						_this._isLeftMouse=true;
						var touches=evt.changedTouches;
						for (var j=0,n=touches.length;j < n;j++){
							var touch=touches[j];
							if (MouseManager.multiTouchEnabled || isNaN(this._curTouchID)){
								this._curTouchID=touch.identifier;
								if (this._id % 200===0)this._touchIDs={};
								this._touchIDs[touch.identifier]=this._id++;
								_this.initEvent(touch,evt);
								_this.check(_this._stage,_this.mouseX,_this.mouseY,_this.onMouseDown);
							}
						}
						break ;
					case "touchend":
					case "touchcancel":
						MouseManager._isTouchRespond=true;
						_this._isLeftMouse=true;
						var touchends=evt.changedTouches;
						for (j=0,n=touchends.length;j < n;j++){
							touch=touchends[j];
							if (MouseManager.multiTouchEnabled || touch.identifier==this._curTouchID){
								this._curTouchID=NaN;
								_this.initEvent(touch,evt);
								var isChecked=false;
								isChecked=_this.check(_this._stage,_this.mouseX,_this.mouseY,_this.onMouseUp);
								if (!isChecked){
									_this.onMouseUp(null);
								}
							}
						}
						break ;
					case "touchmove":;
						var touchemoves=evt.changedTouches;
						for (j=0,n=touchemoves.length;j < n;j++){
							touch=touchemoves[j];
							if (MouseManager.multiTouchEnabled || touch.identifier==this._curTouchID){
								_this.initEvent(touch,evt);
								_this.check(_this._stage,_this.mouseX,_this.mouseY,_this.onMouseMove);
							}
						}
						break ;
					case "wheel":
					case "mousewheel":
					case "DOMMouseScroll":
						_this.checkMouseWheel(evt);
						break ;
					case "mouseout":
						_this._stage.event("mouseout",_this._event.setTo("mouseout",_this._stage,_this._stage));
						break ;
					case "mouseover":
						_this._stage.event("mouseover",_this._event.setTo("mouseover",_this._stage,_this._stage));
						break ;
					}
				i++;
			}
			this._eventList.length=0;
		}

		MouseManager.enabled=true;
		MouseManager.multiTouchEnabled=true;
		MouseManager._isTouchRespond=false;
		__static(MouseManager,
		['instance',function(){return this.instance=new MouseManager();}
		]);
		return MouseManager;
	})()


	/**
	*@private
	*Touch事件管理类，处理多点触控下的鼠标事件
	*/
	//class laya.events.TouchManager
	var TouchManager=(function(){
		function TouchManager(){
			this.preOvers=[];
			this.preDowns=[];
			this.preRightDowns=[];
			this.enable=true;
			this._lastClickTime=0;
			this._event=new Event();
		}

		__class(TouchManager,'laya.events.TouchManager');
		var __proto=TouchManager.prototype;
		/**
		*从touch表里查找对应touchID的数据
		*@param touchID touch ID
		*@param arr touch表
		*@return
		*
		*/
		__proto.getTouchFromArr=function(touchID,arr){
			var i=0,len=0;
			len=arr.length;
			var tTouchO;
			for (i=0;i < len;i++){
				tTouchO=arr[i];
				if (tTouchO.id==touchID){
					return tTouchO;
				}
			}
			return null;
		}

		/**
		*从touch表里移除一个元素
		*@param touchID touch ID
		*@param arr touch表
		*
		*/
		__proto.removeTouchFromArr=function(touchID,arr){
			var i=0;
			for (i=arr.length-1;i >=0;i--){
				if (arr[i].id==touchID){
					arr.splice(i,1);
				}
			}
		}

		/**
		*创建一个touch数据
		*@param ele 当前的根节点
		*@param touchID touchID
		*@return
		*
		*/
		__proto.createTouchO=function(ele,touchID){
			var rst;
			rst=Pool.getItem("TouchData")|| {};
			rst.id=touchID;
			rst.tar=ele;
			return rst;
		}

		/**
		*处理touchStart
		*@param ele 根节点
		*@param touchID touchID
		*@param isLeft （可选）是否为左键
		*/
		__proto.onMouseDown=function(ele,touchID,isLeft){
			(isLeft===void 0)&& (isLeft=false);
			if (!this.enable)
				return;
			var preO;
			var tO;
			var arrs;
			preO=this.getTouchFromArr(touchID,this.preOvers);
			arrs=this.getEles(ele,null,TouchManager._tEleArr);
			if (!preO){
				tO=this.createTouchO(ele,touchID);
				this.preOvers.push(tO);
				}else {
				preO.tar=ele;
			}
			if (Browser.onMobile)
				this.sendEvents(arrs,"mouseover",touchID);
			var preDowns;
			preDowns=isLeft ? this.preDowns :this.preRightDowns;
			preO=this.getTouchFromArr(touchID,preDowns);
			if (!preO){
				tO=this.createTouchO(ele,touchID);
				preDowns.push(tO);
				}else {
				preO.tar=ele;
			}
			this.sendEvents(arrs,isLeft ? "mousedown" :"rightmousedown",touchID);
		}

		/**
		*派发事件。
		*@param eles 对象列表。
		*@param type 事件类型。
		*@param touchID （可选）touchID，默认为0。
		*/
		__proto.sendEvents=function(eles,type,touchID){
			(touchID===void 0)&& (touchID=0);
			var i=0,len=0;
			len=eles.length;
			this._event._stoped=false;
			var _target;
			_target=eles[0];
			var tE;
			for (i=0;i < len;i++){
				tE=eles[i];
				if (tE.destroyed)return;
				tE.event(type,this._event.setTo(type,tE,_target));
				if (this._event._stoped)
					break ;
			}
		}

		/**
		*获取对象列表。
		*@param start 起始节点。
		*@param end 结束节点。
		*@param rst 返回值。如果此值不为空，则将其赋值为计算结果，从而避免创建新数组；如果此值为空，则创建新数组返回。
		*@return Array 返回节点列表。
		*/
		__proto.getEles=function(start,end,rst){
			if (!rst){
				rst=[];
				}else {
				rst.length=0;
			}
			while (start && start !=end){
				rst.push(start);
				start=start.parent;
			}
			return rst;
		}

		/**
		*touchMove时处理out事件和over时间。
		*@param eleNew 新的根节点。
		*@param elePre 旧的根节点。
		*@param touchID （可选）touchID，默认为0。
		*/
		__proto.checkMouseOutAndOverOfMove=function(eleNew,elePre,touchID){
			(touchID===void 0)&& (touchID=0);
			if (elePre==eleNew)
				return;
			var tar;
			var arrs;
			var i=0,len=0;
			if (elePre.contains(eleNew)){
				arrs=this.getEles(eleNew,elePre,TouchManager._tEleArr);
				this.sendEvents(arrs,"mouseover",touchID);
				}else if (eleNew.contains(elePre)){
				arrs=this.getEles(elePre,eleNew,TouchManager._tEleArr);
				this.sendEvents(arrs,"mouseout",touchID);
				}else {
				arrs=TouchManager._tEleArr;
				arrs.length=0;
				var oldArr;
				oldArr=this.getEles(elePre,null,TouchManager._oldArr);
				var newArr;
				newArr=this.getEles(eleNew,null,TouchManager._newArr);
				len=oldArr.length;
				var tIndex=0;
				for (i=0;i < len;i++){
					tar=oldArr[i];
					tIndex=newArr.indexOf(tar);
					if (tIndex >=0){
						newArr.splice(tIndex,newArr.length-tIndex);
						break ;
						}else {
						arrs.push(tar);
					}
				}
				if (arrs.length > 0){
					this.sendEvents(arrs,"mouseout",touchID);
				}
				if (newArr.length > 0){
					this.sendEvents(newArr,"mouseover",touchID);
				}
			}
		}

		/**
		*处理TouchMove事件
		*@param ele 根节点
		*@param touchID touchID
		*
		*/
		__proto.onMouseMove=function(ele,touchID){
			if (!this.enable)
				return;
			var preO;
			preO=this.getTouchFromArr(touchID,this.preOvers);
			var arrs;
			var tO;
			if (!preO){
				arrs=this.getEles(ele,null,TouchManager._tEleArr);
				this.sendEvents(arrs,"mouseover",touchID);
				this.preOvers.push(this.createTouchO(ele,touchID));
				}else {
				this.checkMouseOutAndOverOfMove(ele,preO.tar);
				preO.tar=ele;
				arrs=this.getEles(ele,null,TouchManager._tEleArr);
			}
			this.sendEvents(arrs,"mousemove",touchID);
		}

		__proto.getLastOvers=function(){
			TouchManager._tEleArr.length=0;
			if (this.preOvers.length > 0 && this.preOvers[0].tar){
				return this.getEles(this.preOvers[0].tar,null,TouchManager._tEleArr);
			}
			TouchManager._tEleArr.push(Laya.stage);
			return TouchManager._tEleArr;
		}

		/**
		*处理TouchEnd事件
		*@param ele 根节点
		*@param touchID touchID
		*@param isLeft 是否为左键
		*/
		__proto.onMouseUp=function(ele,touchID,isLeft){
			(isLeft===void 0)&& (isLeft=false);
			if (!this.enable)
				return;
			var preO;
			var tO;
			var arrs;
			var oldArr;
			var i=0,len=0;
			var tar;
			var sendArr;
			var onMobile=Browser.onMobile;
			arrs=this.getEles(ele,null,TouchManager._tEleArr);
			this.sendEvents(arrs,isLeft ? "mouseup" :"rightmouseup",touchID);
			var preDowns;
			preDowns=isLeft ? this.preDowns :this.preRightDowns;
			preO=this.getTouchFromArr(touchID,preDowns);
			if (!preO){
				}else {
				var isDouble=false;
				var now=Browser.now();
				isDouble=now-this._lastClickTime < 300;
				this._lastClickTime=now;
				if (ele==preO.tar){
					sendArr=arrs;
					}else {
					oldArr=this.getEles(preO.tar,null,TouchManager._oldArr);
					sendArr=TouchManager._newArr;
					sendArr.length=0;
					len=oldArr.length;
					for (i=0;i < len;i++){
						tar=oldArr[i];
						if (arrs.indexOf(tar)>=0){
							sendArr.push(tar);
						}
					}
				}
				if (sendArr.length > 0){
					this.sendEvents(sendArr,isLeft ? "click" :"rightclick",touchID);
				}
				if (isLeft && isDouble){
					this.sendEvents(sendArr,"doubleclick",touchID);
				}
				this.removeTouchFromArr(touchID,preDowns);
				preO.tar=null;
				Pool.recover("TouchData",preO);
			}
			preO=this.getTouchFromArr(touchID,this.preOvers);
			if (!preO){
				}else {
				if (onMobile){
					sendArr=this.getEles(preO.tar,null,sendArr);
					if (sendArr && sendArr.length > 0){
						this.sendEvents(sendArr,"mouseout",touchID);
					}
					this.removeTouchFromArr(touchID,this.preOvers);
					preO.tar=null;
					Pool.recover("TouchData",preO);
				}
			}
		}

		TouchManager._oldArr=[];
		TouchManager._newArr=[];
		TouchManager._tEleArr=[];
		__static(TouchManager,
		['I',function(){return this.I=new TouchManager();}
		]);
		return TouchManager;
	})()


	/**
	*<code>Filter</code> 是滤镜基类。
	*/
	//class laya.filters.Filter
	var Filter=(function(){
		function Filter(){
			this._action=null;
		}

		__class(Filter,'laya.filters.Filter');
		var __proto=Filter.prototype;
		Laya.imps(__proto,{"laya.filters.IFilter":true})
		/**@private */
		__proto.callNative=function(sp){}
		/**@private 滤镜类型。*/
		__getset(0,__proto,'type',function(){return-1});
		/**@private 滤镜动作。*/
		__getset(0,__proto,'action',function(){return this._action });
		Filter.BLUR=0x10;
		Filter.COLOR=0x20;
		Filter.GLOW=0x08;
		Filter._filterStart=null
		Filter._filterEnd=null
		Filter._EndTarget=null
		Filter._recycleScope=null
		Filter._filter=null
		Filter._useSrc=null
		Filter._endSrc=null
		Filter._useOut=null
		Filter._endOut=null
		return Filter;
	})()


	/**
	*@private
	*<code>ColorFilterAction</code> 是一个颜色滤镜应用类。
	*/
	//class laya.filters.ColorFilterAction
	var ColorFilterAction=(function(){
		function ColorFilterAction(){
			this.data=null;
		}

		__class(ColorFilterAction,'laya.filters.ColorFilterAction');
		var __proto=ColorFilterAction.prototype;
		Laya.imps(__proto,{"laya.filters.IFilterAction":true})
		/**
		*给指定的对象应用颜色滤镜。
		*@param srcCanvas 需要应用画布对象。
		*@return 应用了滤镜后的画布对象。
		*/
		__proto.apply=function(srcCanvas){
			var ctx=srcCanvas.ctx.ctx;
			var canvas=srcCanvas.ctx.ctx.canvas;
			if (canvas.width==0 || canvas.height==0)return canvas;
			var imgdata=ctx.getImageData(0,0,canvas.width,canvas.height);
			var data=imgdata.data;
			var nData;
			for (var i=0,n=data.length;i < n;i+=4){
				nData=this.getColor(data[i],data[i+1],data[i+2],data[i+3]);
				if (data[i+3]==0)continue ;
				data[i]=nData[0];
				data[i+1]=nData[1];
				data[i+2]=nData[2];
				data[i+3]=nData[3];
			}
			ctx.putImageData(imgdata,0,0);
			return srcCanvas;
		}

		__proto.getColor=function(red,green,blue,alpha){
			var rst=[];
			if (this.data._mat && this.data._alpha){
				var mat=this.data._mat;
				var tempAlpha=this.data._alpha;
				rst[0]=mat[0] *red+mat[1] *green+mat[2] *blue+mat[3] *alpha+tempAlpha[0];
				rst[1]=mat[4] *red+mat[5] *green+mat[6] *blue+mat[7] *alpha+tempAlpha[1];
				rst[2]=mat[8] *red+mat[9] *green+mat[10] *blue+mat[11] *alpha+tempAlpha[2];
				rst[3]=mat[12] *red+mat[13] *green+mat[14] *blue+mat[15] *alpha+tempAlpha[3];
			}
			return rst;
		}

		return ColorFilterAction;
	})()


	/**
	*@private
	*/
	//class laya.maths.Arith
	var Arith=(function(){
		function Arith(){};
		__class(Arith,'laya.maths.Arith');
		Arith.formatR=function(r){
			if (r > Math.PI)r-=Math.PI *2;
			if (r <-Math.PI)r+=Math.PI *2;
			return r;
		}

		Arith.isPOT=function(w,h){
			return (w > 0 && (w & (w-1))===0 && h > 0 && (h & (h-1))===0);
		}

		Arith.setMatToArray=function(mat,array){
			mat.a,mat.b,0,0,mat.c,mat.d,0,0,0,0,1,0,mat.tx+20,mat.ty+20,0,1
			array[0]=mat.a;
			array[1]=mat.b;
			array[4]=mat.c;
			array[5]=mat.d;
			array[12]=mat.tx;
			array[13]=mat.ty;
		}

		return Arith;
	})()


	/**
	*@private
	*计算贝塞尔曲线的工具类。
	*/
	//class laya.maths.Bezier
	var Bezier=(function(){
		function Bezier(){
			this._controlPoints=[new Point(),new Point(),new Point()];
			this._calFun=this.getPoint2;
		}

		__class(Bezier,'laya.maths.Bezier');
		var __proto=Bezier.prototype;
		/**@private */
		__proto._switchPoint=function(x,y){
			var tPoint=this._controlPoints.shift();
			tPoint.setTo(x,y);
			this._controlPoints.push(tPoint);
		}

		/**
		*计算二次贝塞尔点。
		*@param t
		*@param rst
		*
		*/
		__proto.getPoint2=function(t,rst){
			var p1=this._controlPoints[0];
			var p2=this._controlPoints[1];
			var p3=this._controlPoints[2];
			var lineX=Math.pow((1-t),2)*p1.x+2 *t *(1-t)*p2.x+Math.pow(t,2)*p3.x;
			var lineY=Math.pow((1-t),2)*p1.y+2 *t *(1-t)*p2.y+Math.pow(t,2)*p3.y;
			rst.push(lineX,lineY);
		}

		/**
		*计算三次贝塞尔点
		*@param t
		*@param rst
		*
		*/
		__proto.getPoint3=function(t,rst){
			var p1=this._controlPoints[0];
			var p2=this._controlPoints[1];
			var p3=this._controlPoints[2];
			var p4=this._controlPoints[3];
			var lineX=Math.pow((1-t),3)*p1.x+3 *p2.x *t *(1-t)*(1-t)+3 *p3.x *t *t *(1-t)+p4.x *Math.pow(t,3);
			var lineY=Math.pow((1-t),3)*p1.y+3 *p2.y *t *(1-t)*(1-t)+3 *p3.y *t *t *(1-t)+p4.y *Math.pow(t,3);
			rst.push(lineX,lineY);
		}

		/**
		*计算贝塞尔点序列
		*@param count
		*@param rst
		*
		*/
		__proto.insertPoints=function(count,rst){
			var i=NaN;
			count=count > 0 ? count :5;
			var dLen=NaN;
			dLen=1 / count;
			for (i=0;i <=1;i+=dLen){
				this._calFun(i,rst);
			}
		}

		/**
		*获取贝塞尔曲线上的点。
		*@param pList 控制点[x0,y0,x1,y1...]
		*@param inSertCount 每次曲线的插值数量
		*@return
		*
		*/
		__proto.getBezierPoints=function(pList,inSertCount,count){
			(inSertCount===void 0)&& (inSertCount=5);
			(count===void 0)&& (count=2);
			var i=0,len=0;
			len=pList.length;
			if (len < (count+1)*2)return [];
			var rst;
			rst=[];
			switch (count){
				case 2:
					this._calFun=this.getPoint2;
					break ;
				case 3:
					this._calFun=this.getPoint3;
					break ;
				default :
					return [];
				}
			while (this._controlPoints.length <=count){
				this._controlPoints.push(new Point());
			}
			for (i=0;i < count *2;i+=2){
				this._switchPoint(pList[i],pList[i+1]);
			}
			for (i=count *2;i < len;i+=2){
				this._switchPoint(pList[i],pList[i+1]);
				if ((i / 2)% count==0)
					this.insertPoints(inSertCount,rst);
			}
			return rst;
		}

		__static(Bezier,
		['I',function(){return this.I=new Bezier();}
		]);
		return Bezier;
	})()


	/**
	*@private
	*凸包算法。
	*/
	//class laya.maths.GrahamScan
	var GrahamScan=(function(){
		function GrahamScan(){};
		__class(GrahamScan,'laya.maths.GrahamScan');
		GrahamScan.multiply=function(p1,p2,p0){
			return ((p1.x-p0.x)*(p2.y-p0.y)-(p2.x-p0.x)*(p1.y-p0.y));
		}

		GrahamScan.dis=function(p1,p2){
			return (p1.x-p2.x)*(p1.x-p2.x)+(p1.y-p2.y)*(p1.y-p2.y);
		}

		GrahamScan._getPoints=function(count,tempUse,rst){
			(tempUse===void 0)&& (tempUse=false);
			if (!GrahamScan._mPointList)GrahamScan._mPointList=[];
			while (GrahamScan._mPointList.length < count)GrahamScan._mPointList.push(new Point());
			if (!rst)rst=[];
			rst.length=0;
			if (tempUse){
				GrahamScan.getFrom(rst,GrahamScan._mPointList,count);
				}else {
				GrahamScan.getFromR(rst,GrahamScan._mPointList,count);
			}
			return rst;
		}

		GrahamScan.getFrom=function(rst,src,count){
			var i=0;
			for (i=0;i < count;i++){
				rst.push(src[i]);
			}
			return rst;
		}

		GrahamScan.getFromR=function(rst,src,count){
			var i=0;
			for (i=0;i < count;i++){
				rst.push(src.pop());
			}
			return rst;
		}

		GrahamScan.pListToPointList=function(pList,tempUse){
			(tempUse===void 0)&& (tempUse=false);
			var i=0,len=pList.length / 2,rst=GrahamScan._getPoints(len,tempUse,GrahamScan._tempPointList);
			for (i=0;i < len;i++){
				rst[i].setTo(pList[i+i],pList[i+i+1]);
			}
			return rst;
		}

		GrahamScan.pointListToPlist=function(pointList){
			var i=0,len=pointList.length,rst=GrahamScan._temPList,tPoint;
			rst.length=0;
			for (i=0;i < len;i++){
				tPoint=pointList[i];
				rst.push(tPoint.x,tPoint.y);
			}
			return rst;
		}

		GrahamScan.scanPList=function(pList){
			return Utils$1.copyArray(pList,GrahamScan.pointListToPlist(GrahamScan.scan(GrahamScan.pListToPointList(pList,true))));
		}

		GrahamScan.scan=function(PointSet){
			var i=0,j=0,k=0,top=2,tmp,n=PointSet.length,ch;
			var _tmpDic={};
			var key;
			ch=GrahamScan._temArr;
			ch.length=0;
			n=PointSet.length;
			for (i=n-1;i >=0;i--){
				tmp=PointSet[i];
				key=tmp.x+"_"+tmp.y;
				if (!_tmpDic.hasOwnProperty(key)){
					_tmpDic[key]=true;
					ch.push(tmp);
				}
			}
			n=ch.length;
			Utils$1.copyArray(PointSet,ch);
			for (i=1;i < n;i++)
			if ((PointSet[i].y < PointSet[k].y)|| ((PointSet[i].y==PointSet[k].y)&& (PointSet[i].x < PointSet[k].x)))
				k=i;
			tmp=PointSet[0];
			PointSet[0]=PointSet[k];
			PointSet[k]=tmp;
			for (i=1;i < n-1;i++){
				k=i;
				for (j=i+1;j < n;j++)
				if ((GrahamScan.multiply(PointSet[j],PointSet[k],PointSet[0])> 0)|| ((GrahamScan.multiply(PointSet[j],PointSet[k],PointSet[0])==0)&& (GrahamScan.dis(PointSet[0],PointSet[j])< GrahamScan.dis(PointSet[0],PointSet[k]))))
					k=j;
				tmp=PointSet[i];
				PointSet[i]=PointSet[k];
				PointSet[k]=tmp;
			}
			ch=GrahamScan._temArr;
			ch.length=0;
			if (PointSet.length < 3){
				return Utils$1.copyArray(ch,PointSet);
			}
			ch.push(PointSet[0],PointSet[1],PointSet[2]);
			for (i=3;i < n;i++){
				while (ch.length >=2 && GrahamScan.multiply(PointSet[i],ch[ch.length-1],ch[ch.length-2])>=0)ch.pop();
				PointSet[i] && ch.push(PointSet[i]);
			}
			return ch;
		}

		GrahamScan._mPointList=null
		GrahamScan._tempPointList=[];
		GrahamScan._temPList=[];
		GrahamScan._temArr=[];
		return GrahamScan;
	})()


	/**
	*@private
	*<code>MathUtil</code> 是一个数据处理工具类。
	*/
	//class laya.maths.MathUtil
	var MathUtil=(function(){
		function MathUtil(){};
		__class(MathUtil,'laya.maths.MathUtil');
		MathUtil.subtractVector3=function(l,r,o){
			o[0]=l[0]-r[0];
			o[1]=l[1]-r[1];
			o[2]=l[2]-r[2];
		}

		MathUtil.lerp=function(left,right,amount){
			return left *(1-amount)+right *amount;
		}

		MathUtil.scaleVector3=function(f,b,e){
			e[0]=f[0] *b;
			e[1]=f[1] *b;
			e[2]=f[2] *b;
		}

		MathUtil.lerpVector3=function(l,r,t,o){
			var ax=l[0],ay=l[1],az=l[2];
			o[0]=ax+t *(r[0]-ax);
			o[1]=ay+t *(r[1]-ay);
			o[2]=az+t *(r[2]-az);
		}

		MathUtil.lerpVector4=function(l,r,t,o){
			var ax=l[0],ay=l[1],az=l[2],aw=l[3];
			o[0]=ax+t *(r[0]-ax);
			o[1]=ay+t *(r[1]-ay);
			o[2]=az+t *(r[2]-az);
			o[3]=aw+t *(r[3]-aw);
		}

		MathUtil.slerpQuaternionArray=function(a,Offset1,b,Offset2,t,out,Offset3){
			var ax=a[Offset1+0],ay=a[Offset1+1],az=a[Offset1+2],aw=a[Offset1+3],bx=b[Offset2+0],by=b[Offset2+1],bz=b[Offset2+2],bw=b[Offset2+3];
			var omega,cosom,sinom,scale0,scale1;
			cosom=ax *bx+ay *by+az *bz+aw *bw;
			if (cosom < 0.0){
				cosom=-cosom;
				bx=-bx;
				by=-by;
				bz=-bz;
				bw=-bw;
			}
			if ((1.0-cosom)> 0.000001){
				omega=Math.acos(cosom);
				sinom=Math.sin(omega);
				scale0=Math.sin((1.0-t)*omega)/ sinom;
				scale1=Math.sin(t *omega)/ sinom;
				}else {
				scale0=1.0-t;
				scale1=t;
			}
			out[Offset3+0]=scale0 *ax+scale1 *bx;
			out[Offset3+1]=scale0 *ay+scale1 *by;
			out[Offset3+2]=scale0 *az+scale1 *bz;
			out[Offset3+3]=scale0 *aw+scale1 *bw;
			return out;
		}

		MathUtil.getRotation=function(x0,y0,x1,y1){
			return Math.atan2(y1-y0,x1-x0)/ Math.PI *180;
		}

		MathUtil.sortBigFirst=function(a,b){
			if (a==b)
				return 0;
			return b > a ? 1 :-1;
		}

		MathUtil.sortSmallFirst=function(a,b){
			if (a==b)
				return 0;
			return b > a ?-1 :1;
		}

		MathUtil.sortNumBigFirst=function(a,b){
			return parseFloat(b)-parseFloat(a);
		}

		MathUtil.sortNumSmallFirst=function(a,b){
			return parseFloat(a)-parseFloat(b);
		}

		MathUtil.sortByKey=function(key,bigFirst,forceNum){
			(bigFirst===void 0)&& (bigFirst=false);
			(forceNum===void 0)&& (forceNum=true);
			var _sortFun;
			if (bigFirst){
				_sortFun=forceNum ? MathUtil.sortNumBigFirst :MathUtil.sortBigFirst;
				}else {
				_sortFun=forceNum ? MathUtil.sortNumSmallFirst :MathUtil.sortSmallFirst;
			}
			return function (a,b){
				return _sortFun(a[key],b[key]);
			}
		}

		return MathUtil;
	})()


	/**
	*<p> <code>Matrix</code> 类表示一个转换矩阵，它确定如何将点从一个坐标空间映射到另一个坐标空间。</p>
	*<p>您可以对一个显示对象执行不同的图形转换，方法是设置 Matrix 对象的属性，将该 Matrix 对象应用于 Transform 对象的 matrix 属性，然后应用该 Transform 对象作为显示对象的 transform 属性。这些转换函数包括平移（x 和 y 重新定位）、旋转、缩放和倾斜。</p>
	*/
	//class laya.maths.Matrix
	var Matrix=(function(){
		function Matrix(a,b,c,d,tx,ty){
			//this.a=NaN;
			//this.b=NaN;
			//this.c=NaN;
			//this.d=NaN;
			//this.tx=NaN;
			//this.ty=NaN;
			this.inPool=false;
			this.bTransform=false;
			(a===void 0)&& (a=1);
			(b===void 0)&& (b=0);
			(c===void 0)&& (c=0);
			(d===void 0)&& (d=1);
			(tx===void 0)&& (tx=0);
			(ty===void 0)&& (ty=0);
			this.a=a;
			this.b=b;
			this.c=c;
			this.d=d;
			this.tx=tx;
			this.ty=ty;
			this._checkTransform();
		}

		__class(Matrix,'laya.maths.Matrix');
		var __proto=Matrix.prototype;
		/**
		*将本矩阵设置为单位矩阵。
		*@return 返回当前矩形。
		*/
		__proto.identity=function(){
			this.a=this.d=1;
			this.b=this.tx=this.ty=this.c=0;
			this.bTransform=false;
			return this;
		}

		/**@private*/
		__proto._checkTransform=function(){
			return this.bTransform=(this.a!==1 || this.b!==0 || this.c!==0 || this.d!==1);
		}

		/**
		*设置沿 x 、y 轴平移每个点的距离。
		*@param x 沿 x 轴平移每个点的距离。
		*@param y 沿 y 轴平移每个点的距离。
		*@return 返回对象本身
		*/
		__proto.setTranslate=function(x,y){
			this.tx=x;
			this.ty=y;
			return this;
		}

		/**
		*沿 x 和 y 轴平移矩阵，平移的变化量由 x 和 y 参数指定。
		*@param x 沿 x 轴向右移动的量（以像素为单位）。
		*@param y 沿 y 轴向下移动的量（以像素为单位）。
		*@return 返回此矩形对象。
		*/
		__proto.translate=function(x,y){
			this.tx+=x;
			this.ty+=y;
			return this;
		}

		/**
		*对矩阵应用缩放转换。
		*@param x 用于沿 x 轴缩放对象的乘数。
		*@param y 用于沿 y 轴缩放对象的乘数。
		*/
		__proto.scale=function(x,y){
			this.a *=x;
			this.d *=y;
			this.c *=x;
			this.b *=y;
			this.tx *=x;
			this.ty *=y;
			this.bTransform=true;
		}

		/**
		*对 Matrix 对象应用旋转转换。
		*@param angle 以弧度为单位的旋转角度。
		*/
		__proto.rotate=function(angle){
			var cos=Math.cos(angle);
			var sin=Math.sin(angle);
			var a1=this.a;
			var c1=this.c;
			var tx1=this.tx;
			this.a=a1 *cos-this.b *sin;
			this.b=a1 *sin+this.b *cos;
			this.c=c1 *cos-this.d *sin;
			this.d=c1 *sin+this.d *cos;
			this.tx=tx1 *cos-this.ty *sin;
			this.ty=tx1 *sin+this.ty *cos;
			this.bTransform=true;
		}

		/**
		*对 Matrix 对象应用倾斜转换。
		*@param x 沿着 X 轴的 2D 倾斜弧度。
		*@param y 沿着 Y 轴的 2D 倾斜弧度。
		*@return 当前 Matrix 对象。
		*/
		__proto.skew=function(x,y){
			var tanX=Math.tan(x);
			var tanY=Math.tan(y);
			var a1=this.a;
			var b1=this.b;
			this.a+=tanY *this.c;
			this.b+=tanY *this.d;
			this.c+=tanX *a1;
			this.d+=tanX *b1;
			return this;
		}

		/**
		*对指定的点应用当前矩阵的逆转化并返回此点。
		*@param out 待转化的点 Point 对象。
		*@return 返回out
		*/
		__proto.invertTransformPoint=function(out){
			var a1=this.a;
			var b1=this.b;
			var c1=this.c;
			var d1=this.d;
			var tx1=this.tx;
			var n=a1 *d1-b1 *c1;
			var a2=d1 / n;
			var b2=-b1 / n;
			var c2=-c1 / n;
			var d2=a1 / n;
			var tx2=(c1 *this.ty-d1 *tx1)/ n;
			var ty2=-(a1 *this.ty-b1 *tx1)/ n;
			return out.setTo(a2 *out.x+c2 *out.y+tx2,b2 *out.x+d2 *out.y+ty2);
		}

		/**
		*将 Matrix 对象表示的几何转换应用于指定点。
		*@param out 用来设定输出结果的点。
		*@return 返回out
		*/
		__proto.transformPoint=function(out){
			return out.setTo(this.a *out.x+this.c *out.y+this.tx,this.b *out.x+this.d *out.y+this.ty);
		}

		/**
		*将 Matrix 对象表示的几何转换应用于指定点，忽略tx、ty。
		*@param out 用来设定输出结果的点。
		*@return 返回out
		*/
		__proto.transformPointN=function(out){
			return out.setTo(this.a *out.x+this.c *out.y ,this.b *out.x+this.d *out.y);
		}

		/**
		*@private
		*将 Matrix 对象表示的几何转换应用于指定点。
		*@param data 点集合。
		*@param out 存储应用转化的点的列表。
		*@return 返回out数组
		*/
		__proto.transformPointArray=function(data,out){
			var len=data.length;
			for (var i=0;i < len;i+=2){
				var x=data[i],y=data[i+1];
				out[i]=this.a *x+this.c *y+this.tx;
				out[i+1]=this.b *x+this.d *y+this.ty;
			}
			return out;
		}

		/**
		*@private
		*将 Matrix 对象表示的几何缩放转换应用于指定点。
		*@param data 点集合。
		*@param out 存储应用转化的点的列表。
		*@return 返回out数组
		*/
		__proto.transformPointArrayScale=function(data,out){
			var len=data.length;
			for (var i=0;i < len;i+=2){
				var x=data[i],y=data[i+1];
				out[i]=this.a *x+this.c *y;
				out[i+1]=this.b *x+this.d *y;
			}
			return out;
		}

		/**
		*获取 X 轴缩放值。
		*@return X 轴缩放值。
		*/
		__proto.getScaleX=function(){
			return this.b===0 ? this.a :Math.sqrt(this.a *this.a+this.b *this.b);
		}

		/**
		*获取 Y 轴缩放值。
		*@return Y 轴缩放值。
		*/
		__proto.getScaleY=function(){
			return this.c===0 ? this.d :Math.sqrt(this.c *this.c+this.d *this.d);
		}

		/**
		*执行原始矩阵的逆转换。
		*@return 当前矩阵对象。
		*/
		__proto.invert=function(){
			var a1=this.a;
			var b1=this.b;
			var c1=this.c;
			var d1=this.d;
			var tx1=this.tx;
			var n=a1 *d1-b1 *c1;
			this.a=d1 / n;
			this.b=-b1 / n;
			this.c=-c1 / n;
			this.d=a1 / n;
			this.tx=(c1 *this.ty-d1 *tx1)/ n;
			this.ty=-(a1 *this.ty-b1 *tx1)/ n;
			return this;
		}

		/**
		*将 Matrix 的成员设置为指定值。
		*@param a 缩放或旋转图像时影响像素沿 x 轴定位的值。
		*@param b 旋转或倾斜图像时影响像素沿 y 轴定位的值。
		*@param c 旋转或倾斜图像时影响像素沿 x 轴定位的值。
		*@param d 缩放或旋转图像时影响像素沿 y 轴定位的值。
		*@param tx 沿 x 轴平移每个点的距离。
		*@param ty 沿 y 轴平移每个点的距离。
		*@return 当前矩阵对象。
		*/
		__proto.setTo=function(a,b,c,d,tx,ty){
			this.a=a,this.b=b,this.c=c,this.d=d,this.tx=tx,this.ty=ty;
			return this;
		}

		/**
		*将指定矩阵与当前矩阵连接，从而将这两个矩阵的几何效果有效地结合在一起。
		*@param matrix 要连接到源矩阵的矩阵。
		*@return 当前矩阵。
		*/
		__proto.concat=function(matrix){
			var a=this.a;
			var c=this.c;
			var tx=this.tx;
			this.a=a *matrix.a+this.b *matrix.c;
			this.b=a *matrix.b+this.b *matrix.d;
			this.c=c *matrix.a+this.d *matrix.c;
			this.d=c *matrix.b+this.d *matrix.d;
			this.tx=tx *matrix.a+this.ty *matrix.c+matrix.tx;
			this.ty=tx *matrix.b+this.ty *matrix.d+matrix.ty;
			return this;
		}

		/**
		*@private
		*对矩阵应用缩放转换。反向相乘
		*@param x 用于沿 x 轴缩放对象的乘数。
		*@param y 用于沿 y 轴缩放对象的乘数。
		*/
		__proto.scaleEx=function(x,y){
			var ba=this.a,bb=this.b,bc=this.c,bd=this.d;
			if (bb!==0 || bc!==0){
				this.a=x *ba;
				this.b=x *bb;
				this.c=y *bc;
				this.d=y *bd;
				}else {
				this.a=x *ba;
				this.b=0 *bd;
				this.c=0 *ba;
				this.d=y *bd;
			}
			this.bTransform=true;
		}

		/**
		*@private
		*对 Matrix 对象应用旋转转换。反向相乘
		*@param angle 以弧度为单位的旋转角度。
		*/
		__proto.rotateEx=function(angle){
			var cos=Math.cos(angle);
			var sin=Math.sin(angle);
			var ba=this.a,bb=this.b,bc=this.c,bd=this.d;
			if (bb!==0 || bc!==0){
				this.a=cos *ba+sin *bc;
				this.b=cos *bb+sin *bd;
				this.c=-sin *ba+cos *bc;
				this.d=-sin *bb+cos *bd;
				}else {
				this.a=cos *ba;
				this.b=sin *bd;
				this.c=-sin *ba;
				this.d=cos *bd;
			}
			this.bTransform=true;
		}

		/**
		*返回此 Matrix 对象的副本。
		*@return 与原始实例具有完全相同的属性的新 Matrix 实例。
		*/
		__proto.clone=function(){
			var dec=Matrix.create();
			dec.a=this.a;
			dec.b=this.b;
			dec.c=this.c;
			dec.d=this.d;
			dec.tx=this.tx;
			dec.ty=this.ty;
			dec.bTransform=this.bTransform;
			return dec;
		}

		/**
		*将当前 Matrix 对象中的所有矩阵数据复制到指定的 Matrix 对象中。
		*@param dec 要复制当前矩阵数据的 Matrix 对象。
		*@return 已复制当前矩阵数据的 Matrix 对象。
		*/
		__proto.copyTo=function(dec){
			dec.a=this.a;
			dec.b=this.b;
			dec.c=this.c;
			dec.d=this.d;
			dec.tx=this.tx;
			dec.ty=this.ty;
			dec.bTransform=this.bTransform;
			return dec;
		}

		/**
		*返回列出该 Matrix 对象属性的文本值。
		*@return 一个字符串，它包含 Matrix 对象的属性值：a、b、c、d、tx 和 ty。
		*/
		__proto.toString=function(){
			return this.a+","+this.b+","+this.c+","+this.d+","+this.tx+","+this.ty;
		}

		/**
		*销毁此对象。
		*/
		__proto.destroy=function(){
			if (this.inPool)return;
			var cache=Matrix._cache;
			this.inPool=true;
			cache._length || (cache._length=0);
			cache[cache._length++]=this;
			this.a=this.d=1;
			this.b=this.c=this.tx=this.ty=0;
			this.bTransform=false;
		}

		Matrix.mul=function(m1,m2,out){
			var aa=m1.a,ab=m1.b,ac=m1.c,ad=m1.d,atx=m1.tx,aty=m1.ty;
			var ba=m2.a,bb=m2.b,bc=m2.c,bd=m2.d,btx=m2.tx,bty=m2.ty;
			if (bb!==0 || bc!==0){
				out.a=aa *ba+ab *bc;
				out.b=aa *bb+ab *bd;
				out.c=ac *ba+ad *bc;
				out.d=ac *bb+ad *bd;
				out.tx=ba *atx+bc *aty+btx;
				out.ty=bb *atx+bd *aty+bty;
				}else {
				out.a=aa *ba;
				out.b=ab *bd;
				out.c=ac *ba;
				out.d=ad *bd;
				out.tx=ba *atx+btx;
				out.ty=bd *aty+bty;
			}
			return out;
		}

		Matrix.mul16=function(m1,m2,out){
			var aa=m1.a,ab=m1.b,ac=m1.c,ad=m1.d,atx=m1.tx,aty=m1.ty;
			var ba=m2.a,bb=m2.b,bc=m2.c,bd=m2.d,btx=m2.tx,bty=m2.ty;
			if (bb!==0 || bc!==0){
				out[0]=aa *ba+ab *bc;
				out[1]=aa *bb+ab *bd;
				out[4]=ac *ba+ad *bc;
				out[5]=ac *bb+ad *bd;
				out[12]=ba *atx+bc *aty+btx;
				out[13]=bb *atx+bd *aty+bty;
				}else {
				out[0]=aa *ba;
				out[1]=ab *bd;
				out[4]=ac *ba;
				out[5]=ad *bd;
				out[12]=ba *atx+btx;
				out[13]=bd *aty+bty;
			}
			return out;
		}

		Matrix.mulPre=function(m1,ba,bb,bc,bd,btx,bty,out){
			var aa=m1.a,ab=m1.b,ac=m1.c,ad=m1.d,atx=m1.tx,aty=m1.ty;
			if (bb!==0 || bc!==0){
				out.a=aa *ba+ab *bc;
				out.b=aa *bb+ab *bd;
				out.c=ac *ba+ad *bc;
				out.d=ac *bb+ad *bd;
				out.tx=ba *atx+bc *aty+btx;
				out.ty=bb *atx+bd *aty+bty;
				}else {
				out.a=aa *ba;
				out.b=ab *bd;
				out.c=ac *ba;
				out.d=ad *bd;
				out.tx=ba *atx+btx;
				out.ty=bd *aty+bty;
			}
			return out;
		}

		Matrix.mulPos=function(m1,aa,ab,ac,ad,atx,aty,out){
			var ba=m1.a,bb=m1.b,bc=m1.c,bd=m1.d,btx=m1.tx,bty=m1.ty;
			if (bb!==0 || bc!==0){
				out.a=aa *ba+ab *bc;
				out.b=aa *bb+ab *bd;
				out.c=ac *ba+ad *bc;
				out.d=ac *bb+ad *bd;
				out.tx=ba *atx+bc *aty+btx;
				out.ty=bb *atx+bd *aty+bty;
				}else {
				out.a=aa *ba;
				out.b=ab *bd;
				out.c=ac *ba;
				out.d=ad *bd;
				out.tx=ba *atx+btx;
				out.ty=bd *aty+bty;
			}
			return out;
		}

		Matrix.preMul=function(parent,self,out){
			var pa=parent.a,pb=parent.b,pc=parent.c,pd=parent.d;
			var na=self.a,nb=self.b,nc=self.c,nd=self.d,ntx=self.tx,nty=self.ty;
			out.a=na *pa;
			out.b=out.c=0;
			out.d=nd *pd;
			out.tx=ntx *pa+parent.tx;
			out.ty=nty *pd+parent.ty;
			if (nb!==0 || nc!==0 || pb!==0 || pc!==0){
				out.a+=nb *pc;
				out.d+=nc *pb;
				out.b+=na *pb+nb *pd;
				out.c+=nc *pa+nd *pc;
				out.tx+=nty *pc;
				out.ty+=ntx *pb;
			}
			return out;
		}

		Matrix.preMulXY=function(parent,x,y,out){
			var pa=parent.a,pb=parent.b,pc=parent.c,pd=parent.d;
			out.a=pa;
			out.b=pb;
			out.c=pc;
			out.d=pd;
			out.tx=x *pa+parent.tx+y *pc;
			out.ty=y *pd+parent.ty+x *pb;
			return out;
		}

		Matrix.create=function(){
			var cache=Matrix._cache;
			var mat=!cache._length ? (new Matrix()):cache[--cache._length];
			mat.inPool=false;
			return mat;
		}

		Matrix.EMPTY=new Matrix();
		Matrix.TEMP=new Matrix();
		Matrix._cache=[];
		return Matrix;
	})()


	/**
	*<code>Point</code> 对象表示二维坐标系统中的某个位置，其中 x 表示水平轴，y 表示垂直轴。
	*/
	//class laya.maths.Point
	var Point=(function(){
		function Point(x,y){
			//this.x=NaN;
			//this.y=NaN;
			(x===void 0)&& (x=0);
			(y===void 0)&& (y=0);
			this.x=x;
			this.y=y;
		}

		__class(Point,'laya.maths.Point');
		var __proto=Point.prototype;
		/**
		*将 <code>Point</code> 的成员设置为指定值。
		*@param x 水平坐标。
		*@param y 垂直坐标。
		*@return 当前 Point 对象。
		*/
		__proto.setTo=function(x,y){
			this.x=x;
			this.y=y;
			return this;
		}

		/**
		*计算当前点和目标点(x，y)的距离。
		*@param x 水平坐标。
		*@param y 垂直坐标。
		*@return 返回当前点和目标点之间的距离。
		*/
		__proto.distance=function(x,y){
			return Math.sqrt((this.x-x)*(this.x-x)+(this.y-y)*(this.y-y));
		}

		/**返回包含 x 和 y 坐标的值的字符串。*/
		__proto.toString=function(){
			return this.x+","+this.y;
		}

		/**
		*标准化向量。
		*/
		__proto.normalize=function(){
			var d=Math.sqrt(this.x *this.x+this.y *this.y);
			if (d > 0){
				var id=1.0 / d;
				this.x *=id;
				this.y *=id;
			}
		}

		Point.TEMP=new Point();
		Point.EMPTY=new Point();
		return Point;
	})()


	/**
	*<p><code>Rectangle</code> 对象是按其位置（由它左上角的点 (x,y)确定）以及宽度和高度定义的区域。</p>
	*<p>Rectangle 类的 x、y、width 和 height 属性相互独立；更改一个属性的值不会影响其他属性。</p>
	*/
	//class laya.maths.Rectangle
	var Rectangle=(function(){
		function Rectangle(x,y,width,height){
			//this.x=NaN;
			//this.y=NaN;
			//this.width=NaN;
			//this.height=NaN;
			(x===void 0)&& (x=0);
			(y===void 0)&& (y=0);
			(width===void 0)&& (width=0);
			(height===void 0)&& (height=0);
			this.x=x;
			this.y=y;
			this.width=width;
			this.height=height;
		}

		__class(Rectangle,'laya.maths.Rectangle');
		var __proto=Rectangle.prototype;
		/**
		*将 Rectangle 的属性设置为指定值。
		*@param x x 矩形左上角的 X 轴坐标。
		*@param y x 矩形左上角的 Y 轴坐标。
		*@param width 矩形的宽度。
		*@param height 矩形的高。
		*@return 返回属性值修改后的矩形对象本身。
		*/
		__proto.setTo=function(x,y,width,height){
			this.x=x;
			this.y=y;
			this.width=width;
			this.height=height;
			return this;
		}

		/**
		*复制 source 对象的属性值到此矩形对象中。
		*@param sourceRect 源 Rectangle 对象。
		*@return 返回属性值修改后的矩形对象本身。
		*/
		__proto.copyFrom=function(source){
			this.x=source.x;
			this.y=source.y;
			this.width=source.width;
			this.height=source.height;
			return this;
		}

		/**
		*确定由此 Rectangle 对象定义的矩形区域内是否包含指定的点。
		*@param x 点的 X 轴坐标值（水平位置）。
		*@param y 点的 Y 轴坐标值（垂直位置）。
		*@return 如果 Rectangle 对象包含指定的点，则值为 true；否则为 false。
		*/
		__proto.contains=function(x,y){
			if (this.width <=0 || this.height <=0)return false;
			if (x >=this.x && x < this.right){
				if (y >=this.y && y < this.bottom){
					return true;
				}
			}
			return false;
		}

		/**
		*确定在 rect 参数中指定的对象是否与此 Rectangle 对象相交。此方法检查指定的 Rectangle 对象的 x、y、width 和 height 属性，以查看它是否与此 Rectangle 对象相交。
		*@param rect Rectangle 对象。
		*@return 如果传入的矩形对象与此对象相交，则返回 true 值，否则返回 false。
		*/
		__proto.intersects=function(rect){
			return !(rect.x > (this.x+this.width)|| (rect.x+rect.width)< this.x || rect.y > (this.y+this.height)|| (rect.y+rect.height)< this.y);
		}

		/**
		*如果在 rect 参数中指定的 Rectangle 对象与此 Rectangle 对象相交，则返回交集区域作为 Rectangle 对象。如果矩形不相交，则此方法返回null。
		*@param rect 待比较的矩形区域。
		*@param out （可选）待输出的矩形区域。如果为空则创建一个新的。建议：尽量复用对象，减少对象创建消耗。
		*@return 返回相交的矩形区域对象。
		*/
		__proto.intersection=function(rect,out){
			if (!this.intersects(rect))return null;
			out || (out=new Rectangle());
			out.x=Math.max(this.x,rect.x);
			out.y=Math.max(this.y,rect.y);
			out.width=Math.min(this.right,rect.right)-out.x;
			out.height=Math.min(this.bottom,rect.bottom)-out.y;
			return out;
		}

		/**
		*<p>矩形联合，通过填充两个矩形之间的水平和垂直空间，将这两个矩形组合在一起以创建一个新的 Rectangle 对象。</p>
		*<p>注意：union()方法忽略高度或宽度值为 0 的矩形，如：var rect2:Rectangle=new Rectangle(300,300,50,0);</p>
		*@param 要添加到此 Rectangle 对象的 Rectangle 对象。
		*@param out 用于存储输出结果的矩形对象。如果为空，则创建一个新的。建议：尽量复用对象，减少对象创建消耗。Rectangle.TEMP对象用于对象复用。
		*@return 充当两个矩形的联合的新 Rectangle 对象。
		*/
		__proto.union=function(source,out){
			out || (out=new Rectangle());
			this.clone(out);
			if (source.width <=0 || source.height <=0)return out;
			out.addPoint(source.x,source.y);
			out.addPoint(source.right,source.bottom);
			return this;
		}

		/**
		*返回一个 Rectangle 对象，其 x、y、width 和 height 属性的值与当前 Rectangle 对象的对应值相同。
		*@param out （可选）用于存储结果的矩形对象。如果为空，则创建一个新的。建议：尽量复用对象，减少对象创建消耗。。Rectangle.TEMP对象用于对象复用。
		*@return Rectangle 对象，其 x、y、width 和 height 属性的值与当前 Rectangle 对象的对应值相同。
		*/
		__proto.clone=function(out){
			out || (out=new Rectangle());
			out.x=this.x;
			out.y=this.y;
			out.width=this.width;
			out.height=this.height;
			return out;
		}

		/**
		*当前 Rectangle 对象的水平位置 x 和垂直位置 y 以及高度 width 和宽度 height 以逗号连接成的字符串。
		*/
		__proto.toString=function(){
			return this.x+","+this.y+","+this.width+","+this.height;
		}

		/**
		*检测传入的 Rectangle 对象的属性是否与当前 Rectangle 对象的属性 x、y、width、height 属性值都相等。
		*@param rect 待比较的 Rectangle 对象。
		*@return 如果判断的属性都相等，则返回 true ,否则返回 false。
		*/
		__proto.equals=function(rect){
			if (!rect || rect.x!==this.x || rect.y!==this.y || rect.width!==this.width || rect.height!==this.height)return false;
			return true;
		}

		/**
		*<p>为当前矩形对象加一个点，以使当前矩形扩展为包含当前矩形和此点的最小矩形。</p>
		*<p>此方法会修改本对象。</p>
		*@param x 点的 X 坐标。
		*@param y 点的 Y 坐标。
		*@return 返回此 Rectangle 对象。
		*/
		__proto.addPoint=function(x,y){
			this.x > x && (this.width+=this.x-x,this.x=x);
			this.y > y && (this.height+=this.y-y,this.y=y);
			if (this.width < x-this.x)this.width=x-this.x;
			if (this.height < y-this.y)this.height=y-this.y;
			return this;
		}

		/**
		*@private
		*返回代表当前矩形的顶点数据。
		*@return 顶点数据。
		*/
		__proto._getBoundPoints=function(){
			var rst=Rectangle._temB;
			rst.length=0;
			if (this.width==0 || this.height==0)return rst;
			rst.push(this.x,this.y,this.x+this.width,this.y,this.x,this.y+this.height,this.x+this.width,this.y+this.height);
			return rst;
		}

		/**
		*确定此 Rectangle 对象是否为空。
		*@return 如果 Rectangle 对象的宽度或高度小于等于 0，则返回 true 值，否则返回 false。
		*/
		__proto.isEmpty=function(){
			if (this.width <=0 || this.height <=0)return true;
			return false;
		}

		/**此矩形右侧的 X 轴坐标。 x 和 width 属性的和。*/
		__getset(0,__proto,'right',function(){
			return this.x+this.width;
		});

		/**此矩形底端的 Y 轴坐标。y 和 height 属性的和。*/
		__getset(0,__proto,'bottom',function(){
			return this.y+this.height;
		});

		Rectangle._getBoundPointS=function(x,y,width,height){
			var rst=Rectangle._temA;
			rst.length=0;
			if (width==0 || height==0)return rst;
			rst.push(x,y,x+width,y,x,y+height,x+width,y+height);
			return rst;
		}

		Rectangle._getWrapRec=function(pointList,rst){
			if (!pointList || pointList.length < 1)return rst ? rst.setTo(0,0,0,0):Rectangle.TEMP.setTo(0,0,0,0);
			rst=rst ? rst :new Rectangle();
			var i,len=pointList.length,minX,maxX,minY,maxY,tPoint=Point.TEMP;
			minX=minY=99999;
			maxX=maxY=-minX;
			for (i=0;i < len;i+=2){
				tPoint.x=pointList[i];
				tPoint.y=pointList[i+1];
				minX=minX < tPoint.x ? minX :tPoint.x;
				minY=minY < tPoint.y ? minY :tPoint.y;
				maxX=maxX > tPoint.x ? maxX :tPoint.x;
				maxY=maxY > tPoint.y ? maxY :tPoint.y;
			}
			return rst.setTo(minX,minY,maxX-minX,maxY-minY);
		}

		Rectangle.EMPTY=new Rectangle();
		Rectangle.TEMP=new Rectangle();
		Rectangle._temB=[];
		Rectangle._temA=[];
		return Rectangle;
	})()


	/**
	*<code>SoundManager</code> 是一个声音管理类。提供了对背景音乐、音效的播放控制方法。
	*/
	//class laya.media.SoundManager
	var SoundManager=(function(){
		function SoundManager(){};
		__class(SoundManager,'laya.media.SoundManager');
		/**
		*失去焦点后是否自动停止背景音乐。
		*@param v Boolean 失去焦点后是否自动停止背景音乐。
		*
		*/
		/**
		*失去焦点后是否自动停止背景音乐。
		*/
		__getset(1,SoundManager,'autoStopMusic',function(){
			return SoundManager._autoStopMusic;
			},function(v){
			Laya.stage.off("blur",null,SoundManager._stageOnBlur);
			Laya.stage.off("focus",null,SoundManager._stageOnFocus);
			Laya.stage.off("visibilitychange",null,SoundManager._visibilityChange);
			SoundManager._autoStopMusic=v;
			if (v){
				Laya.stage.on("blur",null,SoundManager._stageOnBlur);
				Laya.stage.on("focus",null,SoundManager._stageOnFocus);
				Laya.stage.on("visibilitychange",null,SoundManager._visibilityChange);
			}
		});

		/**
		*背景音乐和所有音效是否静音。
		*/
		__getset(1,SoundManager,'muted',function(){
			return SoundManager._muted;
			},function(value){
			if (value){
				SoundManager.stopAllSound();
			}
			SoundManager.musicMuted=value;
			SoundManager._muted=value;
		});

		/**
		*背景音乐（不包括音效）是否静音。
		*/
		__getset(1,SoundManager,'musicMuted',function(){
			return SoundManager._musicMuted;
			},function(value){
			if (value){
				if (SoundManager._tMusic)
					SoundManager.stopSound(SoundManager._tMusic);
				SoundManager._musicMuted=value;
				}else {
				SoundManager._musicMuted=value;
				if (SoundManager._tMusic){
					SoundManager.playMusic(SoundManager._tMusic);
				}
			}
		});

		/**
		*所有音效（不包括背景音乐）是否静音。
		*/
		__getset(1,SoundManager,'soundMuted',function(){
			return SoundManager._soundMuted;
			},function(value){
			SoundManager._soundMuted=value;
		});

		SoundManager.addChannel=function(channel){
			if (SoundManager._channels.indexOf(channel)>=0)return;
			SoundManager._channels.push(channel);
		}

		SoundManager.removeChannel=function(channel){
			var i=0;
			for (i=SoundManager._channels.length-1;i >=0;i--){
				if (SoundManager._channels[i]==channel){
					SoundManager._channels.splice(i,1);
				}
			}
		}

		SoundManager.disposeSoundIfNotUsed=function(url){
			var i=0;
			for (i=SoundManager._channels.length-1;i >=0;i--){
				if (SoundManager._channels[i].url==url){
					return;
				}
			}
			SoundManager.destroySound(url);
		}

		SoundManager._visibilityChange=function(){
			if (Laya.stage.isVisibility){
				SoundManager._stageOnFocus();
				}else {
				SoundManager._stageOnBlur();
			}
		}

		SoundManager._stageOnBlur=function(){
			SoundManager._isActive=false;
			if (SoundManager._musicChannel){
				if (!SoundManager._musicChannel.isStopped){
					SoundManager._blurPaused=true;
					SoundManager._musicLoops=SoundManager._musicChannel.loops;
					SoundManager._musicCompleteHandler=SoundManager._musicChannel.completeHandler;
					SoundManager._musicPosition=SoundManager._musicChannel.position;
					SoundManager._musicChannel.stop();
					Laya.stage.once("mousedown",null,SoundManager._stageOnFocus);
				}
			}
			SoundManager.stopAllSound();
		}

		SoundManager._stageOnFocus=function(){
			SoundManager._isActive=true;
			Laya.stage.off("mousedown",null,SoundManager._stageOnFocus);
			if (SoundManager._blurPaused){
				if (SoundManager._tMusic){
					SoundManager.playMusic(SoundManager._tMusic,SoundManager._musicLoops,SoundManager._musicCompleteHandler,SoundManager._musicPosition);
				}
				SoundManager._blurPaused=false;
			}
		}

		SoundManager.playSound=function(url,loops,complete,soundClass,startTime){
			(loops===void 0)&& (loops=1);
			(startTime===void 0)&& (startTime=0);
			if (!SoundManager._isActive || !url)return null;
			if (SoundManager._muted)return null;
			url=URL.formatURL(url);
			if (url==SoundManager._tMusic){
				if (SoundManager._musicMuted)return null;
				}else {
				if (Render.isConchApp){
					var ext=Utils$1.getFileExtension(url);
					if (ext !="wav" && ext !="ogg"){
						alert("The sound only supports wav or ogg format,for optimal performance reason,please refer to the official website document.");
						return null;
					}
				}
				if (SoundManager._soundMuted)return null;
			};
			var tSound=Laya.loader.getRes(url);
			if (!soundClass)soundClass=SoundManager._soundClass;
			if (!tSound){
				tSound=new soundClass();
				tSound.load(url);
				Loader.cacheRes(url,tSound);
			};
			var channel;
			channel=tSound.play(startTime,loops);
			if (!channel)return null;
			channel.url=url;
			channel.volume=(url==SoundManager._tMusic)? SoundManager.musicVolume :SoundManager.soundVolume;
			channel.completeHandler=complete;
			return channel;
		}

		SoundManager.destroySound=function(url){
			var tSound=Laya.loader.getRes(url);
			if (tSound){
				Loader.clearRes(url);
				tSound.dispose();
			}
		}

		SoundManager.playMusic=function(url,loops,complete,startTime){
			(loops===void 0)&& (loops=0);
			(startTime===void 0)&& (startTime=0);
			url=URL.formatURL(url);
			SoundManager._tMusic=url;
			if (SoundManager._musicChannel)SoundManager._musicChannel.stop();
			return SoundManager._musicChannel=SoundManager.playSound(url,loops,complete,SoundManager.useAudioMusic?AudioSound:null,startTime);
		}

		SoundManager.stopSound=function(url){
			url=URL.formatURL(url);
			var i=0;
			var channel;
			for (i=SoundManager._channels.length-1;i >=0;i--){
				channel=SoundManager._channels[i];
				if (channel.url==url){
					channel.stop();
				}
			}
		}

		SoundManager.stopAll=function(){
			SoundManager._tMusic=null;
			var i=0;
			var channel;
			for (i=SoundManager._channels.length-1;i >=0;i--){
				channel=SoundManager._channels[i];
				channel.stop();
			}
		}

		SoundManager.stopAllSound=function(){
			var i=0;
			var channel;
			for (i=SoundManager._channels.length-1;i >=0;i--){
				channel=SoundManager._channels[i];
				if (channel.url !=SoundManager._tMusic){
					channel.stop();
				}
			}
		}

		SoundManager.stopMusic=function(){
			if (SoundManager._musicChannel)SoundManager._musicChannel.stop();
			SoundManager._tMusic=null;
		}

		SoundManager.setSoundVolume=function(volume,url){
			if (url){
				url=URL.formatURL(url);
				SoundManager._setVolume(url,volume);
				}else {
				SoundManager.soundVolume=volume;
				var i=0;
				var channel;
				for (i=SoundManager._channels.length-1;i >=0;i--){
					channel=SoundManager._channels[i];
					if (channel.url !=SoundManager._tMusic){
						channel.volume=volume;
					}
				}
			}
		}

		SoundManager.setMusicVolume=function(volume){
			SoundManager.musicVolume=volume;
			SoundManager._setVolume(SoundManager._tMusic,volume);
		}

		SoundManager._setVolume=function(url,volume){
			url=URL.formatURL(url);
			var i=0;
			var channel;
			for (i=SoundManager._channels.length-1;i >=0;i--){
				channel=SoundManager._channels[i];
				if (channel.url==url){
					channel.volume=volume;
				}
			}
		}

		SoundManager.musicVolume=1;
		SoundManager.soundVolume=1;
		SoundManager.playbackRate=1;
		SoundManager.useAudioMusic=true;
		SoundManager._muted=false;
		SoundManager._soundMuted=false;
		SoundManager._musicMuted=false;
		SoundManager._tMusic=null;
		SoundManager._musicChannel=null;
		SoundManager._channels=[];
		SoundManager._autoStopMusic=false;
		SoundManager._blurPaused=false;
		SoundManager._isActive=true;
		SoundManager._musicLoops=0;
		SoundManager._musicPosition=0;
		SoundManager._musicCompleteHandler=null;
		SoundManager._soundClass=null
		SoundManager.autoReleaseSound=true;
		return SoundManager;
	})()


	/**
	*<p> <code>LocalStorage</code> 类用于没有时间限制的数据存储。</p>
	*/
	//class laya.net.LocalStorage
	var LocalStorage=(function(){
		var Storage;
		function LocalStorage(){};
		__class(LocalStorage,'laya.net.LocalStorage');
		LocalStorage.__init__=function(){
			if (!LocalStorage._baseClass){
				LocalStorage._baseClass=Storage;
				Storage.init();
			}
			LocalStorage.items=LocalStorage._baseClass.items;
			LocalStorage.support=LocalStorage._baseClass.support;
		}

		LocalStorage.setItem=function(key,value){
			LocalStorage._baseClass.setItem(key,value);
		}

		LocalStorage.getItem=function(key){
			return LocalStorage._baseClass.getItem(key);
		}

		LocalStorage.setJSON=function(key,value){
			LocalStorage._baseClass.setJSON(key,value);
		}

		LocalStorage.getJSON=function(key){
			return LocalStorage._baseClass.getJSON(key);
		}

		LocalStorage.removeItem=function(key){
			LocalStorage._baseClass.removeItem(key);
		}

		LocalStorage.clear=function(){
			LocalStorage._baseClass.clear();
		}

		LocalStorage._baseClass=null
		LocalStorage.items=null
		LocalStorage.support=false;
		LocalStorage.__init$=function(){
			//class Storage
			Storage=(function(){
				function Storage(){};
				__class(Storage,'');
				Storage.init=function(){
					try{Storage.items=window.localStorage;Storage.setItem('laya','1');Storage.removeItem('laya');Storage.support=true;}catch(e){}if(!Storage.support)console.log('LocalStorage is not supprot or browser is private mode.');
				}
				Storage.setItem=function(key,value){
					try {
						Storage.support && Storage.items.setItem(key,value);
						}catch (e){
						console.warn("set localStorage failed",e);
					}
				}
				Storage.getItem=function(key){
					return Storage.support ? Storage.items.getItem(key):null;
				}
				Storage.setJSON=function(key,value){
					try {
						Storage.support && Storage.items.setItem(key,JSON.stringify(value));
						}catch (e){
						console.warn("set localStorage failed",e);
					}
				}
				Storage.getJSON=function(key){
					return JSON.parse(Storage.support ? Storage.items.getItem(key):null);
				}
				Storage.removeItem=function(key){
					Storage.support && Storage.items.removeItem(key);
				}
				Storage.clear=function(){
					Storage.support && Storage.items.clear();
				}
				Storage.items=null
				Storage.support=false;
				return Storage;
			})()
		}

		return LocalStorage;
	})()


	/**
	*<p> <code>URL</code> 类用于定义地址信息。</p>
	*/
	//class laya.net.URL
	var URL=(function(){
		function URL(url){
			this._url=null;
			this._path=null;
			this._url=URL.formatURL(url);
			this._path=URL.getPath(url);
		}

		__class(URL,'laya.net.URL');
		var __proto=URL.prototype;
		/**地址的路径。*/
		__getset(0,__proto,'path',function(){
			return this._path;
		});

		/**格式化后的地址。*/
		__getset(0,__proto,'url',function(){
			return this._url;
		});

		URL.formatURL=function(url,base){
			if (!url)return "null path";
			if (url.indexOf(":")> 0)return url;
			if (URL.customFormat !=null)url=URL.customFormat(url,base);
			var char1=url.charAt(0);
			if (char1==="."){
				return URL.formatRelativePath((base || URL.basePath)+url);
				}else if (char1==='~'){
				return URL.rootPath+url.substring(1);
				}else if (char1==="d"){
				if (url.indexOf("data:image")===0)return url;
				}else if (char1==="/"){
				return url;
			}
			return (base || URL.basePath)+url;
		}

		URL.formatRelativePath=function(value){
			var parts=value.split("/");
			for (var i=0,len=parts.length;i < len;i++){
				if (parts[i]=='..'){
					parts.splice(i-1,2);
					i-=2;
				}
			}
			return parts.join('/');
		}

		URL.isAbsolute=function(url){
			return url.indexOf(":")> 0 || url.charAt(0)=='/';
		}

		URL.getPath=function(url){
			var ofs=url.lastIndexOf('/');
			return ofs > 0 ? url.substr(0,ofs+1):"";
		}

		URL.getFileName=function(url){
			var ofs=url.lastIndexOf('/');
			return ofs > 0 ? url.substr(ofs+1):url;
		}

		URL.version={};
		URL.basePath="";
		URL.rootPath="";
		URL.customFormat=function(url){
			var newUrl=URL.version[url];
			if (!Render.isConchApp && newUrl)url+="?v="+newUrl;
			return url;
		}

		return URL;
	})()


	/**
	*@private
	*<code>Render</code> 是渲染管理类。它是一个单例，可以使用 Laya.render 访问。
	*/
	//class laya.renders.Render
	var Render=(function(){
		function Render(width,height){
			this._timeId=0;
			var style=Render._mainCanvas.source.style;
			style.position='absolute';
			style.top=style.left="0px";
			style.background="#000000";
			Render._mainCanvas.source.id="layaCanvas";
			var isWebGl=laya.renders.Render.isWebGL;
			Render._mainCanvas.source.width=width;
			Render._mainCanvas.source.height=height;
			isWebGl && Render.WebGL.init(Render._mainCanvas,width,height);
			Browser.container.appendChild(Render._mainCanvas.source);
			Render._context=new RenderContext(width,height,isWebGl ? null :Render._mainCanvas);
			Render._context.ctx.setIsMainContext();
			Browser.window.requestAnimationFrame(loop);
			function loop (){
				Laya.stage._loop();
				Browser.window.requestAnimationFrame(loop);
			}
			Laya.stage.on("visibilitychange",this,this._onVisibilitychange);
		}

		__class(Render,'laya.renders.Render');
		var __proto=Render.prototype;
		/**@private */
		__proto._onVisibilitychange=function(){
			if (!Laya.stage.isVisibility){
				this._timeId=Browser.window.setInterval(this._enterFrame,1000);
				}else if (this._timeId !=0){
				Browser.window.clearInterval(this._timeId);
			}
		}

		/**@private */
		__proto._enterFrame=function(e){
			Laya.stage._loop();
		}

		/**目前使用的渲染器。*/
		__getset(1,Render,'context',function(){
			return Render._context;
		});

		/**渲染使用的原生画布引用。 */
		__getset(1,Render,'canvas',function(){
			return Render._mainCanvas.source;
		});

		Render._context=null
		Render._mainCanvas=null
		Render.WebGL=null
		Render.isConchNode=false;
		Render.isConchApp=false;
		Render.isConchWebGL=false;
		Render.isWebGL=false;
		Render.is3DMode=false;
		Render.optimizeTextureMemory=function(url,texture){
			return true;
		}

		Render.__init$=function(){
			window.ConchRenderType=window.ConchRenderType||1;
			window.ConchRenderType|=(!window.conch?0:0x04);;{
				Render.isConchNode=(window.ConchRenderType & 5)==5;
				Render.isConchApp=(window.ConchRenderType & 0x04)==0x04;
				Render.isConchWebGL=window.ConchRenderType==6;
			};;
		}

		return Render;
	})()


	/**
	*@private
	*渲染环境
	*/
	//class laya.renders.RenderContext
	var RenderContext=(function(){
		function RenderContext(width,height,canvas){
			this.x=0;
			this.y=0;
			//this.canvas=null;
			//this.ctx=null;
			this._drawTexture=function(x,y,args){
				if (args[0].loaded)this.ctx.drawTexture(args[0],args[1],args[2],args[3],args[4],x,y);
			}
			this._fillTexture=function(x,y,args){
				if (args[0].loaded)this.ctx.fillTexture(args[0],args[1]+x,args[2]+y,args[3],args[4],args[5],args[6],args[7]);
			}
			this._drawTextureWithTransform=function(x,y,args){
				if (args[0].loaded)this.ctx.drawTextureWithTransform(args[0],args[1],args[2],args[3],args[4],args[5],x,y,args[6]);
			}
			this._fillQuadrangle=function(x,y,args){
				this.ctx.fillQuadrangle(args[0],args[1],args[2],args[3],args[4]);
			}
			this._drawRect=function(x,y,args){
				var ctx=this.ctx;
				if (args[4] !=null){
					ctx.fillStyle=args[4];
					ctx.fillRect(x+args[0],y+args[1],args[2],args[3],null);
				}
				if (args[5] !=null){
					ctx.strokeStyle=args[5];
					ctx.lineWidth=args[6];
					ctx.strokeRect(x+args[0],y+args[1],args[2],args[3],args[6]);
				}
			}
			this._drawPie=function(x,y,args){
				var ctx=this.ctx;
				Render.isWebGL && ctx.setPathId(args[8]);
				ctx.beginPath();
				if (Render.isWebGL){
					ctx.movePath(args[0]+x,args[1]+y);
					ctx.moveTo(0,0);
					}else {
					ctx.moveTo(x+args[0],y+args[1]);
				}
				ctx.arc(x+args[0],y+args[1],args[2],args[3],args[4]);
				ctx.closePath();
				this._fillAndStroke(args[5],args[6],args[7],true);
			}
			this._clipRect=function(x,y,args){
				this.ctx.clipRect(x+args[0],y+args[1],args[2],args[3]);
			}
			this._fillRect=function(x,y,args){
				this.ctx.fillRect(x+args[0],y+args[1],args[2],args[3],args[4]);
			}
			this._drawCircle=function(x,y,args){
				var ctx=this.ctx;
				Render.isWebGL && ctx.setPathId(args[6]);
				Stat.drawCall++;
				ctx.beginPath();
				Render.isWebGL && ctx.movePath(args[0]+x,args[1]+y);
				ctx.arc(args[0]+x,args[1]+y,args[2],0,RenderContext.PI2);
				ctx.closePath();
				this._fillAndStroke(args[3],args[4],args[5],true);
			}
			this._fillCircle=function(x,y,args){
				Stat.drawCall++;
				var ctx=this.ctx;
				ctx.beginPath();
				ctx.fillStyle=args[3];
				ctx.arc(args[0]+x,args[1]+y,args[2],0,RenderContext.PI2);
				ctx.fill();
			}
			this._setShader=function(x,y,args){
				this.ctx.setShader(args[0]);
			}
			this._drawLine=function(x,y,args){
				var ctx=this.ctx;
				Render.isWebGL && ctx.setPathId(args[6]);
				ctx.beginPath();
				ctx.strokeStyle=args[4];
				ctx.lineWidth=args[5];
				if (Render.isWebGL){
					ctx.movePath(x,y);
					ctx.moveTo(args[0],args[1]);
					ctx.lineTo(args[2],args[3]);
					}else {
					ctx.moveTo(x+args[0],y+args[1]);
					ctx.lineTo(x+args[2],y+args[3]);
				}
				ctx.stroke();
			}
			this._drawLines=function(x,y,args){
				var ctx=this.ctx;
				Render.isWebGL && ctx.setPathId(args[5]);
				ctx.beginPath();
				x+=args[0],y+=args[1];
				Render.isWebGL && ctx.movePath(x,y);
				ctx.strokeStyle=args[3];
				ctx.lineWidth=args[4];
				var points=args[2];
				var i=2,n=points.length;
				if (Render.isWebGL){
					ctx.moveTo(points[0],points[1]);
					while (i < n){
						ctx.lineTo(points[i++],points[i++]);
					}
					}else {
					ctx.moveTo(x+points[0],y+points[1]);
					while (i < n){
						ctx.lineTo(x+points[i++],y+points[i++]);
					}
				}
				ctx.stroke();
			}
			this._drawLinesWebGL=function(x,y,args){
				this.ctx.drawLines(x+this.x+args[0],y+this.y+args[1],args[2],args[3],args[4]);
			}
			this._drawCurves=function(x,y,args){
				this.ctx.drawCurves(x,y,args);
			}
			this._draw=function(x,y,args){
				args[0].call(null,this,x,y);
			}
			this._transformByMatrix=function(x,y,args){
				this.ctx.transformByMatrix(args[0]);
			}
			this._setTransform=function(x,y,args){
				this.ctx.setTransform(args[0],args[1],args[2],args[3],args[4],args[5]);
			}
			this._setTransformByMatrix=function(x,y,args){
				this.ctx.setTransformByMatrix(args[0]);
			}
			this._save=function(x,y,args){
				this.ctx.save();
			}
			this._restore=function(x,y,args){
				this.ctx.restore();
			}
			this._translate=function(x,y,args){
				this.ctx.translate(args[0],args[1]);
			}
			this._transform=function(x,y,args){
				this.ctx.translate(args[1]+x,args[2]+y);
				var mat=args[0];
				this.ctx.transform(mat.a,mat.b,mat.c,mat.d,mat.tx,mat.ty);
				this.ctx.translate(-x-args[1],-y-args[2]);
			}
			this._rotate=function(x,y,args){
				this.ctx.translate(args[1]+x,args[2]+y);
				this.ctx.rotate(args[0]);
				this.ctx.translate(-x-args[1],-y-args[2]);
			}
			this._scale=function(x,y,args){
				this.ctx.translate(args[2]+x,args[3]+y);
				this.ctx.scale(args[0],args[1]);
				this.ctx.translate(-x-args[2],-y-args[3]);
			}
			this._alpha=function(x,y,args){
				this.ctx.globalAlpha *=args[0];
			}
			this._setAlpha=function(x,y,args){
				this.ctx.globalAlpha=args[0];
			}
			this._fillText=function(x,y,args){
				this.ctx.fillText(args[0],args[1]+x,args[2]+y,args[3],args[4],args[5]);
			}
			this._strokeText=function(x,y,args){
				this.ctx.strokeText(args[0],args[1]+x,args[2]+y,args[3],args[4],args[5],args[6]);
			}
			this._fillBorderText=function(x,y,args){
				this.ctx.fillBorderText(args[0],args[1]+x,args[2]+y,args[3],args[4],args[5],args[6],args[7]);
			}
			this._blendMode=function(x,y,args){
				this.ctx.globalCompositeOperation=args[0];
			}
			this._beginClip=function(x,y,args){
				this.ctx.beginClip && this.ctx.beginClip(x+args[0],y+args[1],args[2],args[3]);
			}
			this._setIBVB=function(x,y,args){
				this.ctx.setIBVB(args[0]+x,args[1]+y,args[2],args[3],args[4],args[5],args[6],args[7]);
			}
			this._fillTrangles=function(x,y,args){
				this.ctx.fillTrangles(args[0],args[1]+x,args[2]+y,args[3],args[4]);
			}
			this._drawPath=function(x,y,args){
				var ctx=this.ctx;
				Render.isWebGL && ctx.setPathId(-1);
				ctx.beginPath();
				x+=args[0],y+=args[1];
				var paths=args[2];
				for (var i=0,n=paths.length;i < n;i++){
					var path=paths[i];
					switch (path[0]){
						case "moveTo":
							ctx.moveTo(x+path[1],y+path[2]);
							break ;
						case "lineTo":
							ctx.lineTo(x+path[1],y+path[2]);
							break ;
						case "arcTo":
							ctx.arcTo(x+path[1],y+path[2],x+path[3],y+path[4],path[5]);
							break ;
						case "closePath":
							ctx.closePath();
							break ;
						}
				};
				var brush=args[3];
				if (brush !=null){
					ctx.fillStyle=brush.fillStyle;
					ctx.fill();
				};
				var pen=args[4];
				if (pen !=null){
					ctx.strokeStyle=pen.strokeStyle;
					ctx.lineWidth=pen.lineWidth || 1;
					ctx.lineJoin=pen.lineJoin;
					ctx.lineCap=pen.lineCap;
					ctx.miterLimit=pen.miterLimit;
					ctx.stroke();
				}
			}
			this.drawPoly=function(x,y,args){
				this.ctx.drawPoly(x+this.x+args[0],y+this.y+args[1],args[2],args[3],args[4],args[5],args[6]);
			}
			this._drawPoly=function(x,y,args){
				var ctx=this.ctx;
				var points=args[2];
				var i=2,n=points.length;
				if (Render.isWebGL){
					ctx.setPathId(args[6]);
					ctx.beginPath();
					x+=args[0],y+=args[1];
					ctx.movePath(x,y);
					ctx.moveTo(points[0],points[1]);
					while (i < n){
						ctx.lineTo(points[i++],points[i++]);
					}
					}else {
					ctx.beginPath();
					x+=args[0],y+=args[1];
					ctx.moveTo(x+points[0],y+points[1]);
					while (i < n){
						ctx.lineTo(x+points[i++],y+points[i++]);
					}
				}
				ctx.closePath();
				this._fillAndStroke(args[3],args[4],args[5],args[7]);
			}
			this._drawSkin=function(x,y,args){
				var tSprite=args[0];
				if (tSprite){
					var ctx=this.ctx;
					tSprite.render(ctx,x,y);
				}
			}
			this._drawParticle=function(x,y,args){
				this.ctx.drawParticle(x+this.x,y+this.y,args[0]);
			}
			if (canvas){
				this.ctx=canvas.getContext('2d');
				}else {
				canvas=HTMLCanvas.create("3D");
				this.ctx=RunDriver.createWebGLContext2D(canvas);
				canvas._setContext(this.ctx);
			}
			canvas.size(width,height);
			this.canvas=canvas;
		}

		__class(RenderContext,'laya.renders.RenderContext');
		var __proto=RenderContext.prototype;
		/**销毁当前渲染环境*/
		__proto.destroy=function(){
			if (this.canvas){
				this.canvas.destroy();
				this.canvas=null;
			}
			if (this.ctx){
				this.ctx.destroy();
				this.ctx=null;
			}
		}

		__proto.drawTexture=function(tex,x,y,width,height){
			if (tex.loaded)this.ctx.drawTexture(tex,x,y,width,height,this.x,this.y);
		}

		__proto._drawTextures=function(x,y,args){
			if (args[0].loaded)this.ctx.drawTextures(args[0],args[1],x+this.x,y+this.y);
		}

		__proto.drawTextureWithTransform=function(tex,x,y,width,height,m,alpha){
			if (tex.loaded)this.ctx.drawTextureWithTransform(tex,x,y,width,height,m,this.x,this.y,alpha);
		}

		__proto.fillQuadrangle=function(tex,x,y,point4,m){
			this.ctx.fillQuadrangle(tex,x,y,point4,m);
		}

		__proto.drawCanvas=function(canvas,x,y,width,height){
			this.ctx.drawCanvas(canvas,x+this.x,y+this.y,width,height);
		}

		__proto.drawRect=function(x,y,width,height,color,lineWidth){
			(lineWidth===void 0)&& (lineWidth=1);
			var ctx=this.ctx;
			ctx.strokeStyle=color;
			ctx.lineWidth=lineWidth;
			ctx.strokeRect(x+this.x,y+this.y,width,height,lineWidth);
		}

		__proto._fillAndStroke=function(fillColor,strokeColor,lineWidth,isConvexPolygon){
			(isConvexPolygon===void 0)&& (isConvexPolygon=false);
			var ctx=this.ctx;
			if (fillColor !=null){
				ctx.fillStyle=fillColor;
				if (Render.isWebGL){
					ctx.fill(isConvexPolygon);
					}else {
					ctx.fill();
				}
			}
			if (strokeColor !=null && lineWidth > 0){
				ctx.strokeStyle=strokeColor;
				ctx.lineWidth=lineWidth;
				ctx.stroke();
			}
		}

		//ctx.translate(-x-args[0],-y-args[1]);
		__proto.clipRect=function(x,y,width,height){
			this.ctx.clipRect(x+this.x,y+this.y,width,height);
		}

		__proto.fillRect=function(x,y,width,height,fillStyle){
			this.ctx.fillRect(x+this.x,y+this.y,width,height,fillStyle);
		}

		__proto.drawCircle=function(x,y,radius,color,lineWidth){
			(lineWidth===void 0)&& (lineWidth=1);
			Stat.drawCall++;
			var ctx=this.ctx;
			ctx.beginPath();
			ctx.strokeStyle=color;
			ctx.lineWidth=lineWidth;
			ctx.arc(x+this.x,y+this.y,radius,0,RenderContext.PI2);
			ctx.stroke();
		}

		__proto.fillCircle=function(x,y,radius,color){
			Stat.drawCall++;
			var ctx=this.ctx;
			ctx.beginPath();
			ctx.fillStyle=color;
			ctx.arc(x+this.x,y+this.y,radius,0,RenderContext.PI2);
			ctx.fill();
		}

		__proto.setShader=function(shader){
			this.ctx.setShader(shader);
		}

		__proto.drawLine=function(fromX,fromY,toX,toY,color,lineWidth){
			(lineWidth===void 0)&& (lineWidth=1);
			var ctx=this.ctx;
			ctx.beginPath();
			ctx.strokeStyle=color;
			ctx.lineWidth=lineWidth;
			ctx.moveTo(this.x+fromX,this.y+fromY);
			ctx.lineTo(this.x+toX,this.y+toY);
			ctx.stroke();
		}

		__proto.clear=function(){
			this.ctx.clear();
		}

		__proto.transformByMatrix=function(value){
			this.ctx.transformByMatrix(value);
		}

		__proto.setTransform=function(a,b,c,d,tx,ty){
			this.ctx.setTransform(a,b,c,d,tx,ty);
		}

		__proto.setTransformByMatrix=function(value){
			this.ctx.setTransformByMatrix(value);
		}

		__proto.save=function(){
			this.ctx.save();
		}

		__proto.restore=function(){
			this.ctx.restore();
		}

		__proto.translate=function(x,y){
			this.ctx.translate(x,y);
		}

		__proto.transform=function(a,b,c,d,tx,ty){
			this.ctx.transform(a,b,c,d,tx,ty);
		}

		__proto.rotate=function(angle){
			this.ctx.rotate(angle);
		}

		__proto.scale=function(scaleX,scaleY){
			this.ctx.scale(scaleX,scaleY);
		}

		__proto.alpha=function(value){
			this.ctx.globalAlpha *=value;
		}

		__proto.setAlpha=function(value){
			this.ctx.globalAlpha=value;
		}

		__proto.fillWords=function(words,x,y,font,color){
			this.ctx.fillWords(words,x,y,font,color);
		}

		/***@private */
		__proto.fillBorderWords=function(words,x,y,font,fillColor,borderColor,lineWidth){
			this.ctx.fillBorderWords(words,x,y,font,fillColor,borderColor,lineWidth);
		}

		__proto.fillText=function(text,x,y,font,color,textAlign){
			this.ctx.fillText(text,x+this.x,y+this.y,font,color,textAlign);
		}

		__proto.strokeText=function(text,x,y,font,color,lineWidth,textAlign){
			this.ctx.strokeText(text,x+this.x,y+this.y,font,color,lineWidth,textAlign);
		}

		__proto.blendMode=function(type){
			this.ctx.globalCompositeOperation=type;
		}

		__proto.flush=function(){
			this.ctx.flush && this.ctx.flush();
		}

		__proto.addRenderObject=function(o){
			this.ctx.addRenderObject(o);
		}

		__proto.beginClip=function(x,y,w,h){
			this.ctx.beginClip && this.ctx.beginClip(x,y,w,h);
		}

		__proto.endClip=function(){
			this.ctx.endClip && this.ctx.endClip();
		}

		__proto.fillTrangles=function(x,y,args){
			this.ctx.fillTrangles(args[0],args[1],args[2],args[3],args.length > 4 ? args[4] :null);
		}

		RenderContext.PI2=2 *Math.PI;
		return RenderContext;
	})()


	/**
	*@private
	*精灵渲染器
	*/
	//class laya.renders.RenderSprite
	var RenderSprite=(function(){
		function RenderSprite(type,next){
			//this._next=null;
			//this._fun=null;
			this._next=next || RenderSprite.NORENDER;
			switch (type){
				case 0:
					this._fun=this._no;
					return;
				case 0x01:
					this._fun=this._image;
					return;
				case 0x02:
					this._fun=this._alpha;
					return;
				case 0x04:
					this._fun=this._transform;
					return;
				case 0x08:
					this._fun=this._blend;
					return;
				case 0x10:
					this._fun=this._canvas;
					return;
				case 0x40:
					this._fun=this._mask;
					return;
				case 0x80:
					this._fun=this._clip;
					return;
				case 0x100:
					this._fun=this._style;
					return;
				case 0x200:
					this._fun=this._graphics;
					return;
				case 0x800:
					this._fun=this._childs;
					return;
				case 0x400:
					this._fun=this._custom;
					return;
				case 0x01 | 0x200:
					this._fun=this._image2;
					return;
				case 0x01 | 0x04 | 0x200:
					this._fun=this._image2;
					return;
				case 0x20:
					this._fun=Filter._filter;
					return;
				case 0x11111:
					this._fun=RenderSprite._initRenderFun;
					return;
				}
			this.onCreate(type);
		}

		__class(RenderSprite,'laya.renders.RenderSprite');
		var __proto=RenderSprite.prototype;
		__proto.onCreate=function(type){}
		__proto._style=function(sprite,context,x,y){
			sprite._style.render(sprite,context,x,y);
			var next=this._next;
			next._fun.call(next,sprite,context,x,y);
		}

		__proto._no=function(sprite,context,x,y){}
		__proto._custom=function(sprite,context,x,y){
			sprite.customRender(context,x,y);
			var tf=sprite._style._tf;
			this._next._fun.call(this._next,sprite,context,x-tf.translateX,y-tf.translateY);
		}

		__proto._clip=function(sprite,context,x,y){
			var next=this._next;
			if (next==RenderSprite.NORENDER)return;
			var r=sprite._style.scrollRect;
			context.ctx.save();
			context.ctx.clipRect(x,y,r.width,r.height);
			next._fun.call(next,sprite,context,x-r.x,y-r.y);
			context.ctx.restore();
		}

		__proto._blend=function(sprite,context,x,y){
			var style=sprite._style;
			if (style.blendMode){
				context.ctx.globalCompositeOperation=style.blendMode;
			};
			var next=this._next;
			next._fun.call(next,sprite,context,x,y);
			context.ctx.globalCompositeOperation="source-over";
		}

		__proto._mask=function(sprite,context,x,y){
			var next=this._next;
			next._fun.call(next,sprite,context,x,y);
			var mask=sprite.mask;
			if (mask){
				context.ctx.globalCompositeOperation="destination-in";
				if (mask.numChildren > 0 || !mask.graphics._isOnlyOne()){
					mask.cacheAsBitmap=true;
				}
				mask.render(context,x-sprite.pivotX,y-sprite.pivotY);
			}
			context.ctx.globalCompositeOperation="source-over";
		}

		__proto._graphics=function(sprite,context,x,y){
			var tf=sprite._style._tf;
			sprite._graphics && sprite._graphics._render(sprite,context,x-tf.translateX,y-tf.translateY);
			var next=this._next;
			next._fun.call(next,sprite,context,x,y);
		}

		__proto._image=function(sprite,context,x,y){
			var style=sprite._style;
			context.ctx.drawTexture2(x,y,style._tf.translateX,style._tf.translateY,sprite.transform,style.alpha,style.blendMode,sprite._graphics._one);
		}

		__proto._image2=function(sprite,context,x,y){
			var tf=sprite._style._tf;
			context.ctx.drawTexture2(x,y,tf.translateX,tf.translateY,sprite.transform,1,null,sprite._graphics._one);
		}

		__proto._alpha=function(sprite,context,x,y){
			var style=sprite._style;
			var alpha;
			if ((alpha=style.alpha)> 0.01 || sprite._needRepaint()){
				var temp=context.ctx.globalAlpha;
				context.ctx.globalAlpha *=alpha;
				var next=this._next;
				next._fun.call(next,sprite,context,x,y);
				context.ctx.globalAlpha=temp;
			}
		}

		__proto._transform=function(sprite,context,x,y){
			var transform=sprite.transform,_next=this._next;
			if (transform && _next !=RenderSprite.NORENDER){
				context.save();
				context.transform(transform.a,transform.b,transform.c,transform.d,transform.tx+x,transform.ty+y);
				_next._fun.call(_next,sprite,context,0,0);
				context.restore();
			}else
			_next._fun.call(_next,sprite,context,x,y);
		}

		__proto._childs_max=function(sprite,context,x,y){
			var style=sprite._style;
			var tf=style._tf;
			x=x-tf.translateX+style.paddingLeft;
			y=y-tf.translateY+style.paddingTop;
			if (style._calculation){
				var words=sprite._getWords();
				if (words){
					var tStyle=style;
					if (tStyle){
						if (tStyle.stroke){
							context.fillBorderWords(words,x,y,tStyle.font,tStyle.color,tStyle.strokeColor,tStyle.stroke);
							}else{
							context.fillWords(words,x,y,tStyle.font,tStyle.color);
						}
					}
				}
			};
			var childs=sprite._childs,n=childs.length,ele;
			if (sprite.viewport || (sprite.optimizeScrollRect && sprite._style.scrollRect)){
				var rect=sprite.viewport || sprite._style.scrollRect;
				var left=rect.x;
				var top=rect.y;
				var right=rect.right;
				var bottom=rect.bottom;
				var _x=NaN,_y=NaN;
				for (i=0;i < n;++i){
					if ((ele=childs [i]).visible && ((_x=ele._x)< right && (_x+ele.width)> left && (_y=ele._y)< bottom && (_y+ele.height)> top)){
						ele.render(context,x,y);
					}
				}
				}else {
				for (var i=0;i < n;++i)
				(ele=(childs [i]))._style.visible && ele.render(context,x,y);
			}
		}

		__proto._childs=function(sprite,context,x,y){
			if (sprite._childRenderMax){
				this._childs_max(sprite,context,x,y);
				return;
			};
			var childs=sprite._childs,n=childs.length,ele;
			for (var i=0;i < n;++i)
			(ele=(childs [i]))._style.visible && ele.render(context,x,y);
		}

		__proto._canvas=function(sprite,context,x,y){
			var _cacheCanvas=sprite._$P.cacheCanvas;
			if (!_cacheCanvas){
				this._next._fun.call(this._next,sprite,context,x,y);
				return;
			}
			_cacheCanvas.type==='bitmap' ? (Stat.canvasBitmap++):(Stat.canvasNormal++);
			var tx=_cacheCanvas.ctx;
			if (sprite._needRepaint()|| !tx){
				this._canvas_repaint(sprite,context,x,y);
			}
			else{
				var tRec=_cacheCanvas._cacheRec;
				context.drawCanvas(tx.canvas,x+tRec.x,y+tRec.y,tRec.width,tRec.height);
			}
		}

		__proto._canvas_repaint=function(sprite,context,x,y){
			var _cacheCanvas=sprite._$P.cacheCanvas;
			var _next=this._next;
			if (!_cacheCanvas){
				_next._fun.call(_next,sprite,tx,x,y);
				return;
			};
			var tx=_cacheCanvas.ctx;
			var _repaint=sprite._needRepaint()|| (!tx);
			var canvas;
			var left;
			var top;
			var tRec;
			var tCacheType=_cacheCanvas.type;
			tCacheType==='bitmap' ? (Stat.canvasBitmap++):(Stat.canvasNormal++);
			if (_repaint){
				if (!_cacheCanvas._cacheRec)
					_cacheCanvas._cacheRec=new Rectangle();
				var w,h;
				if (!Render.isWebGL || tCacheType==="bitmap"){
					tRec=sprite.getSelfBounds();
					tRec.x=tRec.x-sprite.pivotX;
					tRec.y=tRec.y-sprite.pivotY;
					tRec.x=tRec.x-16;
					tRec.y=tRec.y-16;
					tRec.width=tRec.width+32;
					tRec.height=tRec.height+32;
					tRec.x=Math.floor(tRec.x+x)-x;
					tRec.y=Math.floor(tRec.y+y)-y;
					tRec.width=Math.floor(tRec.width);
					tRec.height=Math.floor(tRec.height);
					_cacheCanvas._cacheRec.copyFrom(tRec);
					}else{
					_cacheCanvas._cacheRec.setTo(-sprite.pivotX,-sprite.pivotY,1,1);
				}
				tRec=_cacheCanvas._cacheRec;
				var scaleX=Render.isWebGL ? 1 :Browser.pixelRatio *Laya.stage.clientScaleX;
				var scaleY=Render.isWebGL ? 1 :Browser.pixelRatio *Laya.stage.clientScaleY;
				if (!Render.isWebGL){
					var chainScaleX=1;
					var chainScaleY=1;
					var tar;
					tar=sprite;
					while (tar && tar !=Laya.stage){
						chainScaleX *=tar.scaleX;
						chainScaleY *=tar.scaleY;
						tar=tar.parent;
					}
					if (Render.isWebGL){
						if (chainScaleX < 1)scaleX *=chainScaleX;
						if (chainScaleY < 1)scaleY *=chainScaleY;
						}else {
						if (chainScaleX > 1)scaleX *=chainScaleX;
						if (chainScaleY > 1)scaleY *=chainScaleY;
					}
				}
				if (sprite.scrollRect){
					var scrollRect=sprite.scrollRect;
					tRec.x-=scrollRect.x;
					tRec.y-=scrollRect.y;
				}
				w=tRec.width *scaleX;
				h=tRec.height *scaleY;
				left=tRec.x;
				top=tRec.y;
				if (Render.isWebGL && tCacheType==='bitmap' && (w > 2048 || h > 2048)){
					console.warn("cache bitmap size larger than 2048,cache ignored");
					if (_cacheCanvas.ctx){
						Pool.recover("RenderContext",_cacheCanvas.ctx);
						_cacheCanvas.ctx.canvas.size(0,0);
						_cacheCanvas.ctx=null;
					}
					_next._fun.call(_next,sprite,context,x,y);
					return;
				}
				if (!tx){
					tx=_cacheCanvas.ctx=Pool.getItem("RenderContext")|| new RenderContext(w,h,HTMLCanvas.create("AUTO"));
				}
				tx.ctx.sprite=sprite;
				canvas=tx.canvas;
				canvas.clear();
				(canvas.width !=w || canvas.height !=h)&& canvas.size(w,h);
				if (tCacheType==='bitmap')canvas.context.asBitmap=true;
				else if(tCacheType==='normal')canvas.context.asBitmap=false;
				var t;
				if (scaleX !=1 || scaleY !=1){
					var ctx=(tx).ctx;
					ctx.save();
					ctx.scale(scaleX,scaleY);
					if (!Render.isConchWebGL && Render.isConchApp){
						t=sprite._$P.cf;
						t && ctx.setFilterMatrix && ctx.setFilterMatrix(t._mat,t._alpha);
					}
					_next._fun.call(_next,sprite,tx,-left,-top);
					ctx.restore();
					if (!Render.isConchApp || Render.isConchWebGL)sprite._applyFilters();
					}else {
					ctx=(tx).ctx;
					if (!Render.isConchWebGL && Render.isConchApp){
						t=sprite._$P.cf;
						t && ctx.setFilterMatrix && ctx.setFilterMatrix(t._mat,t._alpha);
					}
					_next._fun.call(_next,sprite,tx,-left,-top);
					if (!Render.isConchApp || Render.isConchWebGL)sprite._applyFilters();
				}
				if (sprite._$P.staticCache)_cacheCanvas.reCache=false;
				Stat.canvasReCache++;
				}else {
				tRec=_cacheCanvas._cacheRec;
				left=tRec.x;
				top=tRec.y;
				canvas=tx.canvas;
			}
			context.drawCanvas(canvas,x+left,y+top,tRec.width,tRec.height);
		}

		RenderSprite.__init__=function(){
			var i=0,len=0;
			var initRender;
			initRender=RunDriver.createRenderSprite(0x11111,null);
			len=RenderSprite.renders.length=0x800 *2;
			for (i=0;i < len;i++)
			RenderSprite.renders[i]=initRender;
			RenderSprite.renders[0]=RunDriver.createRenderSprite(0,null);
			function _initSame (value,o){
				var n=0;
				for (var i=0;i < value.length;i++){
					n |=value[i];
					RenderSprite.renders[n]=o;
				}
			}
			_initSame([0x01,0x200,0x04,0x02],new RenderSprite(0x01,null));
			RenderSprite.renders[0x01 | 0x200]=RunDriver.createRenderSprite(0x01 | 0x200,null);
			RenderSprite.renders[0x01 | 0x04 | 0x200]=new RenderSprite(0x01 | 0x04 | 0x200,null);
		}

		RenderSprite._initRenderFun=function(sprite,context,x,y){
			var type=sprite._renderType;
			var r=RenderSprite.renders[type]=RenderSprite._getTypeRender(type);
			r._fun(sprite,context,x,y);
		}

		RenderSprite._getTypeRender=function(type){
			var rst=null;
			var tType=0x800;
			while (tType > 1){
				if (tType & type)
					rst=RunDriver.createRenderSprite(tType,rst);
				tType=tType >> 1;
			}
			return rst;
		}

		RenderSprite.IMAGE=0x01;
		RenderSprite.ALPHA=0x02;
		RenderSprite.TRANSFORM=0x04;
		RenderSprite.BLEND=0x08;
		RenderSprite.CANVAS=0x10;
		RenderSprite.FILTERS=0x20;
		RenderSprite.MASK=0x40;
		RenderSprite.CLIP=0x80;
		RenderSprite.STYLE=0x100;
		RenderSprite.GRAPHICS=0x200;
		RenderSprite.CUSTOM=0x400;
		RenderSprite.CHILDS=0x800;
		RenderSprite.INIT=0x11111;
		RenderSprite.renders=[];
		RenderSprite.NORENDER=new RenderSprite(0,null);
		return RenderSprite;
	})()


	/**
	*@private
	*Context扩展类
	*/
	//class laya.resource.Context
	var Context=(function(){
		function Context(){
			//this._canvas=null;
			this._repaint=false;
		}

		__class(Context,'laya.resource.Context');
		var __proto=Context.prototype;
		__proto.replaceReset=function(){
			var i=0,len=0;
			len=Context.replaceKeys.length;
			var key;
			for (i=0;i < len;i++){
				key=Context.replaceKeys[i];
				this[Context.newKeys[i]]=this[key];
			}
		}

		__proto.replaceResotre=function(){
			this.__restore();
			this.__reset();
		}

		__proto.setIsMainContext=function(){}
		__proto.drawTextures=function(tex,pos,tx,ty){
			Stat.drawCall+=pos.length / 2;
			var w=tex.width;
			var h=tex.height;
			for (var i=0,sz=pos.length;i < sz;i+=2){
				this.drawTexture(tex,pos[i],pos[i+1],w,h,tx,ty);
			}
		}

		/***@private */
		__proto.drawCanvas=function(canvas,x,y,width,height){
			Stat.drawCall++;
			this.drawImage(canvas.source,x,y,width,height);
		}

		/***@private */
		__proto.fillRect=function(x,y,width,height,style){
			Stat.drawCall++;
			style && (this.fillStyle=style);
			this.__fillRect(x,y,width,height);
		}

		/***@private */
		__proto.fillText=function(text,x,y,font,color,textAlign){
			Stat.drawCall++;
			if (arguments.length > 3 && font !=null){
				this.font=font;
				this.fillStyle=color;
				this.textAlign=textAlign;
				this.textBaseline="top";
			}
			this.__fillText(text,x,y);
		}

		/***@private */
		__proto.fillBorderText=function(text,x,y,font,fillColor,borderColor,lineWidth,textAlign){
			Stat.drawCall++;
			this.font=font;
			this.fillStyle=fillColor;
			this.textBaseline="top";
			this.strokeStyle=borderColor;
			this.lineWidth=lineWidth;
			this.textAlign=textAlign;
			this.__strokeText(text,x,y);
			this.__fillText(text,x,y);
		}

		/***@private */
		__proto.strokeText=function(text,x,y,font,color,lineWidth,textAlign){
			Stat.drawCall++;
			if (arguments.length > 3 && font !=null){
				this.font=font;
				this.strokeStyle=color;
				this.lineWidth=lineWidth;
				this.textAlign=textAlign;
				this.textBaseline="top";
			}
			this.__strokeText(text,x,y);
		}

		/***@private */
		__proto.transformByMatrix=function(value){
			this.transform(value.a,value.b,value.c,value.d,value.tx,value.ty);
		}

		/***@private */
		__proto.setTransformByMatrix=function(value){
			this.setTransform(value.a,value.b,value.c,value.d,value.tx,value.ty);
		}

		/***@private */
		__proto.clipRect=function(x,y,width,height){
			Stat.drawCall++;
			this.beginPath();
			this.rect(x,y,width,height);
			this.clip();
		}

		/***@private */
		__proto.drawTexture=function(tex,x,y,width,height,tx,ty){
			Stat.drawCall++;
			var uv=tex.uv,w=tex.bitmap.width,h=tex.bitmap.height;
			this.drawImage(tex.source,uv[0] *w,uv[1] *h,(uv[2]-uv[0])*w,(uv[5]-uv[3])*h,x+tx,y+ty,width,height);
		}

		/***@private */
		__proto.drawTextureWithTransform=function(tex,x,y,width,height,m,tx,ty,alpha){
			Stat.drawCall++;
			var uv=tex.uv,w=tex.bitmap.width,h=tex.bitmap.height;
			this.save();
			alpha !=1 && (this.globalAlpha *=alpha);
			if (m){
				this.transform(m.a,m.b,m.c,m.d,m.tx+tx,m.ty+ty);
				this.drawImage(tex.source,uv[0] *w,uv[1] *h,(uv[2]-uv[0])*w,(uv[5]-uv[3])*h,x ,y,width,height);
				}else {
				this.drawImage(tex.source,uv[0] *w,uv[1] *h,(uv[2]-uv[0])*w,(uv[5]-uv[3])*h,x+tx ,y+ty,width,height);
			}
			this.restore();
		}

		/***@private */
		__proto.drawTexture2=function(x,y,pivotX,pivotY,m,alpha,blendMode,args2){
			'use strict';
			var tex=args2[0];
			if (!(tex.loaded && tex.bitmap && tex.source)){
				return;
			}
			Stat.drawCall++;
			var alphaChanged=alpha!==1;
			if (alphaChanged){
				var temp=this.globalAlpha;
				this.globalAlpha *=alpha;
			};
			var uv=tex.uv,w=tex.bitmap.width,h=tex.bitmap.height;
			if (m){
				this.save();
				this.transform(m.a,m.b,m.c,m.d,m.tx+x,m.ty+y);
				this.drawImage(tex.source,uv[0] *w,uv[1] *h,(uv[2]-uv[0])*w,(uv[5]-uv[3])*h,args2[1]-pivotX ,args2[2]-pivotY,args2[3],args2[4]);
				this.restore();
				}else {
				this.drawImage(tex.source,uv[0] *w,uv[1] *h,(uv[2]-uv[0])*w,(uv[5]-uv[3])*h,args2[1]-pivotX+x ,args2[2]-pivotY+y,args2[3],args2[4]);
			}
			if (alphaChanged)this.globalAlpha=temp;
		}

		__proto.fillTexture=function(texture,x,y,width,height,type,offset,other){
			if (!other.pat){
				if (texture.uv !=Texture.DEF_UV){
					var canvas=new HTMLCanvas("2D");
					canvas.getContext('2d');
					canvas.size(texture.width,texture.height);
					canvas.context.drawTexture(texture,0,0,texture.width,texture.height,0,0);
					texture=new Texture(canvas);
				}
				other.pat=this.createPattern(texture.bitmap.source,type);
			};
			var oX=x,oY=y;
			var sX=0,sY=0;
			if (offset){
				oX+=offset.x % texture.width;
				oY+=offset.y % texture.height;
				sX-=offset.x % texture.width;
				sY-=offset.y % texture.height;
			}
			this.translate(oX,oY);
			this.fillRect(sX,sY,width,height,other.pat);
			this.translate(-oX,-oY);
		}

		/***@private */
		__proto.flush=function(){
			return 0;
		}

		/***@private */
		__proto.fillWords=function(words,x,y,font,color){
			font && (this.font=font);
			color && (this.fillStyle=color);
			var _this=this;
			this.textBaseline="top";
			this.textAlign='left';
			for (var i=0,n=words.length;i < n;i++){
				var a=words[i];
				this.__fillText(a.char,a.x+x,a.y+y);
			}
		}

		/***@private */
		__proto.fillBorderWords=function(words,x,y,font,color,borderColor,lineWidth){
			font && (this.font=font);
			color && (this.fillStyle=color);
			this.textBaseline="top";
			this.lineWidth=lineWidth;
			this.textAlign='left';
			this.strokeStyle=borderColor;
			for (var i=0,n=words.length;i < n;i++){
				var a=words[i];
				this.__strokeText(a.char,a.x+x,a.y+y);
				this.__fillText(a.char,a.x+x,a.y+y);
			}
		}

		/***@private */
		__proto.destroy=function(){
			this.canvas.width=this.canvas.height=0;
		}

		/***@private */
		__proto.clear=function(){
			this.clearRect(0,0,this._canvas.width,this._canvas.height);
			this._repaint=false;
		}

		__proto.drawCurves=function(x,y,args){
			this.beginPath();
			this.strokeStyle=args[3];
			this.lineWidth=args[4];
			var points=args[2];
			x+=args[0],y+=args[1];
			this.moveTo(x+points[0],y+points[1]);
			var i=2,n=points.length;
			while (i < n){
				this.quadraticCurveTo(x+points[i++],y+points[i++],x+points[i++],y+points[i++]);
			}
			this.stroke();
		}

		Context.__init__=function(to){
			var from=laya.resource.Context.prototype;
			to=to || CanvasRenderingContext2D.prototype;
			to.__fillText=to.fillText;
			to.__fillRect=to.fillRect;
			to.__strokeText=to.strokeText;
			var funs=['drawTextures','fillWords','fillBorderWords','setIsMainContext','fillRect','strokeText','fillTexture','fillText','transformByMatrix','setTransformByMatrix','clipRect','drawTexture','drawTexture2','drawTextureWithTransform','flush','clear','destroy','drawCanvas','fillBorderText','drawCurves'];
			funs.forEach(function(i){
				to[i]=from[i];
			});
			var canvasO=HTMLCanvasElement.prototype;
			if (!Context.replaceCanvasGetSet(canvasO,"width"))return;
			if (!Context.replaceCanvasGetSet(canvasO,"height"))return;
			var i=0,len=0;
			len=Context.replaceKeys.length;
			for (i=0;i < len;i++){
				if(!Context.replaceGetSet(to,Context.replaceKeys[i]))return;
			}
			to.__reset=from.replaceReset;
			to.__restore=to.restore;
			to.restore=from.replaceResotre;
		}

		Context.replaceCanvasGetSet=function(tar,key){
			var oldO=Object.getOwnPropertyDescriptor(tar,key);
			if (!oldO||!oldO.configurable)return false;
			var newO={};
			var tkey;
			for (tkey in oldO){
				if (tkey !="set"){
					newO[tkey]=oldO[tkey];
				}
			};
			var preFun=oldO["set"];
			newO["set"]=function (v){
				var _self=this;
				preFun.call(_self,v);
				var _ct=_self.getContext("2d");
				if (_ct && "__reset" in _ct){
					_ct.__reset();
				}
			}
			Object.defineProperty(tar,key,newO);
			return true;
		}

		Context.replaceGetSet=function(tar,key){
			var oldO=Object.getOwnPropertyDescriptor(tar,key);
			if (!oldO||!oldO.configurable)return false;
			var newO={};
			var tkey;
			for (tkey in oldO){
				if (tkey !="set"){
					newO[tkey]=oldO[tkey];
				}
			};
			var preFun=oldO["set"];
			var dataKey="___"+key+"__";
			Context.newKeys.push(dataKey);
			newO["set"]=function (v){
				var _self=this;
				if (v !=_self[dataKey]){
					_self[dataKey]=v;
					preFun.call(_self,v);
				}
			}
			Object.defineProperty(tar,key,newO);
			return true;
		}

		Context._default=new Context();
		Context.newKeys=[];
		__static(Context,
		['replaceKeys',function(){return this.replaceKeys=["font","fillStyle","textBaseline"];}
		]);
		return Context;
	})()


	/**
	*@private
	*<code>ResourceManager</code> 是资源管理类。它用于资源的载入、获取、销毁。
	*/
	//class laya.resource.ResourceManager
	var ResourceManager=(function(){
		function ResourceManager(){
			this._id=0;
			this._name=null;
			this._resources=null;
			this._memorySize=0;
			this._garbageCollectionRate=NaN;
			this._isOverflow=false;
			this.autoRelease=false;
			this.autoReleaseMaxSize=0;
			this._id=++ResourceManager._uniqueIDCounter;
			this._name="Content Manager";
			ResourceManager._isResourceManagersSorted=false;
			this._memorySize=0;
			this._isOverflow=false;
			this.autoRelease=false;
			this.autoReleaseMaxSize=1024 *1024 *512;
			this._garbageCollectionRate=0.2;
			ResourceManager._resourceManagers.push(this);
			this._resources=[];
		}

		__class(ResourceManager,'laya.resource.ResourceManager');
		var __proto=ResourceManager.prototype;
		Laya.imps(__proto,{"laya.resource.IDispose":true})
		/**
		*获取指定索引的资源 Resource 对象。
		*@param 索引。
		*@return 资源 Resource 对象。
		*/
		__proto.getResourceByIndex=function(index){
			return this._resources[index];
		}

		/**
		*获取此管理器所管理的资源个数。
		*@return 资源个数。
		*/
		__proto.getResourcesLength=function(){
			return this._resources.length;
		}

		/**
		*添加指定资源。
		*@param resource 需要添加的资源 Resource 对象。
		*@return 是否添加成功。
		*/
		__proto.addResource=function(resource){
			if (resource.resourceManager)
				resource.resourceManager.removeResource(resource);
			var index=this._resources.indexOf(resource);
			if (index===-1){
				resource._resourceManager=this;
				this._resources.push(resource);
				this.addSize(resource.memorySize);
				return true;
			}
			return false;
		}

		/**
		*移除指定资源。
		*@param resource 需要移除的资源 Resource 对象
		*@return 是否移除成功。
		*/
		__proto.removeResource=function(resource){
			var index=this._resources.indexOf(resource);
			if (index!==-1){
				this._resources.splice(index,1);
				resource._resourceManager=null;
				this._memorySize-=resource.memorySize;
				return true;
			}
			return false;
		}

		/**
		*卸载此资源管理器载入的资源。
		*/
		__proto.unload=function(){
			var tempResources=this._resources.slice(0,this._resources.length);
			for (var i=0;i < tempResources.length;i++){
				var resource=tempResources[i];
				resource.dispose();
			}
			tempResources.length=0;
		}

		/**
		*设置唯一名字。
		*@param newName 名字，如果名字重复则自动加上“-copy”。
		*/
		__proto.setUniqueName=function(newName){
			var isUnique=true;
			for (var i=0;i < ResourceManager._resourceManagers.length;i++){
				if (ResourceManager._resourceManagers[i]._name!==newName || ResourceManager._resourceManagers[i]===this)
					continue ;
				isUnique=false;
				return;
			}
			if (isUnique){
				if (this.name !=newName){
					this.name=newName;
					ResourceManager._isResourceManagersSorted=false;
				}
				}else{
				this.setUniqueName(newName.concat("-copy"));
			}
		}

		/**释放资源。*/
		__proto.dispose=function(){
			if (this===ResourceManager._systemResourceManager)
				throw new Error("systemResourceManager不能被释放！");
			ResourceManager._resourceManagers.splice(ResourceManager._resourceManagers.indexOf(this),1);
			ResourceManager._isResourceManagersSorted=false;
			var tempResources=this._resources.slice(0,this._resources.length);
			for (var i=0;i < tempResources.length;i++){
				var resource=tempResources[i];
				resource.resourceManager.removeResource(resource);
				resource.dispose();
			}
			tempResources.length=0;
		}

		/**
		*增加内存。
		*@param add 需要增加的内存大小。
		*/
		__proto.addSize=function(add){
			if (add){
				if (this.autoRelease && add > 0)
					((this._memorySize+add)> this.autoReleaseMaxSize)&& (this.garbageCollection((1-this._garbageCollectionRate)*this.autoReleaseMaxSize));
				this._memorySize+=add;
			}
		}

		/**
		*垃圾回收。
		*@param reserveSize 保留尺寸。
		*/
		__proto.garbageCollection=function(reserveSize){
			var all=this._resources;
			all=all.slice();
			all.sort(function(a,b){
				if (!a || !b)
					throw new Error("a或b不能为空！");
				if (a.released && b.released)
					return 0;
				else if (a.released)
				return 1;
				else if (b.released)
				return-1;
				return a.lastUseFrameCount-b.lastUseFrameCount;
			});
			var currentFrameCount=Stat.loopCount;
			for (var i=0,n=all.length;i < n;i++){
				var resou=all[i];
				if (currentFrameCount-resou.lastUseFrameCount > 1){
					resou.releaseResource();
					}else {
					if (this._memorySize >=reserveSize)
						this._isOverflow=true;
					return;
				}
				if (this._memorySize < reserveSize){
					this._isOverflow=false;
					return;
				}
			}
		}

		/**
		*唯一标识 ID 。
		*/
		__getset(0,__proto,'id',function(){
			return this._id;
		});

		/**
		*名字。
		*/
		__getset(0,__proto,'name',function(){
			return this._name;
			},function(value){
			if ((value || value!=="")&& this._name!==value){
				this._name=value;
				ResourceManager._isResourceManagersSorted=false;
			}
		});

		/**
		*此管理器所管理资源的累计内存，以字节为单位。
		*/
		__getset(0,__proto,'memorySize',function(){
			return this._memorySize;
		});

		/**
		*系统资源管理器。
		*/
		__getset(1,ResourceManager,'systemResourceManager',function(){
			(ResourceManager._systemResourceManager===null)&& (ResourceManager._systemResourceManager=new ResourceManager(),ResourceManager._systemResourceManager._name="System Resource Manager");
			return ResourceManager._systemResourceManager;
		});

		/**
		*排序后的资源管理器列表。
		*/
		__getset(1,ResourceManager,'sortedResourceManagersByName',function(){
			if (!ResourceManager._isResourceManagersSorted){
				ResourceManager._isResourceManagersSorted=true;
				ResourceManager._resourceManagers.sort(ResourceManager.compareResourceManagersByName);
			}
			return ResourceManager._resourceManagers;
		});

		ResourceManager.__init__=function(){
			ResourceManager.currentResourceManager=ResourceManager.systemResourceManager;
		}

		ResourceManager.getLoadedResourceManagerByIndex=function(index){
			return ResourceManager._resourceManagers[index];
		}

		ResourceManager.getLoadedResourceManagersCount=function(){
			return ResourceManager._resourceManagers.length;
		}

		ResourceManager.recreateContentManagers=function(force){
			(force===void 0)&& (force=false);
			var temp=ResourceManager.currentResourceManager;
			for (var i=0;i < ResourceManager._resourceManagers.length;i++){
				ResourceManager.currentResourceManager=ResourceManager._resourceManagers[i];
				for (var j=0;j < ResourceManager.currentResourceManager._resources.length;j++){
					ResourceManager.currentResourceManager._resources[j].releaseResource(force);
					ResourceManager.currentResourceManager._resources[j].activeResource(force);
				}
			}
			ResourceManager.currentResourceManager=temp;
		}

		ResourceManager.releaseContentManagers=function(force){
			(force===void 0)&& (force=false);
			var temp=ResourceManager.currentResourceManager;
			for (var i=0;i < ResourceManager._resourceManagers.length;i++){
				ResourceManager.currentResourceManager=ResourceManager._resourceManagers[i];
				for (var j=0;j < ResourceManager.currentResourceManager._resources.length;j++){
					var resource=ResourceManager.currentResourceManager._resources[j];
					(!resource.released)&& (resource.releaseResource(force));
				}
			}
			ResourceManager.currentResourceManager=temp;
		}

		ResourceManager.compareResourceManagersByName=function(left,right){
			if (left==right)
				return 0;
			var x=left._name;
			var y=right._name;
			if (x==null){
				if (y==null)
					return 0;
				else
				return-1;
				}else {
				if (y==null)
					return 1;
				else {
					var retval=x.localeCompare(y);
					if (retval !=0)
						return retval;
					else {
						right.setUniqueName(y);
						y=right._name;
						return x.localeCompare(y);
					}
				}
			}
		}

		ResourceManager._uniqueIDCounter=0;
		ResourceManager._systemResourceManager=null
		ResourceManager._isResourceManagersSorted=false;
		ResourceManager._resourceManagers=[];
		ResourceManager.currentResourceManager=null
		return ResourceManager;
	})()


	/**
	*@private
	*/
	//class laya.system.System
	var System=(function(){
		function System(){};
		__class(System,'laya.system.System');
		System.changeDefinition=function(name,classObj){
			Laya[name]=classObj;
			var str=name+"=classObj";
			eval(str);
		}

		System.__init__=function(){
			if (Render.isConchApp){
				conch.disableConchResManager();
				conch.disableConchAutoRestoreLostedDevice();
			}
		}

		return System;
	})()


	SoundManager;
	/**
	*<code>Browser</code> 是浏览器代理类。封装浏览器及原生 js 提供的一些功能。
	*/
	//class laya.utils.Browser
	var Browser=(function(){
		function Browser(){};
		__class(Browser,'laya.utils.Browser');
		/**设备像素比。*/
		__getset(1,Browser,'pixelRatio',function(){
			Browser.__init__();
			if (Browser.userAgent.indexOf("Mozilla/6.0(Linux; Android 6.0; HUAWEI NXT-AL10 Build/HUAWEINXT-AL10)")>-1)return 2;
			return RunDriver.getPixelRatio();
		});

		/**浏览器窗口物理高度。考虑了设备像素比。*/
		__getset(1,Browser,'height',function(){
			Browser.__init__();
			return ((Laya.stage && Laya.stage.canvasRotation)? Browser.clientWidth :Browser.clientHeight)*Browser.pixelRatio;
		});

		/**
		*浏览器窗口可视宽度。
		*通过分析浏览器信息获得。浏览器多个属性值优先级为：window.innerWidth(包含滚动条宽度)> document.body.clientWidth(不包含滚动条宽度)，如果前者为0或为空，则选择后者。
		*/
		__getset(1,Browser,'clientWidth',function(){
			Browser.__init__();
			return Browser.window.innerWidth || Browser.document.body.clientWidth;
		});

		/**浏览器原生 window 对象的引用。*/
		__getset(1,Browser,'window',function(){
			Browser.__init__();
			return Browser._window;
		});

		/**
		*浏览器窗口可视高度。
		*通过分析浏览器信息获得。浏览器多个属性值优先级为：window.innerHeight(包含滚动条高度)> document.body.clientHeight(不包含滚动条高度)> document.documentElement.clientHeight(不包含滚动条高度)，如果前者为0或为空，则选择后者。
		*/
		__getset(1,Browser,'clientHeight',function(){
			Browser.__init__();
			return Browser.window.innerHeight || Browser.document.body.clientHeight || Browser.document.documentElement.clientHeight;
		});

		/**浏览器窗口物理宽度。考虑了设备像素比。*/
		__getset(1,Browser,'width',function(){
			Browser.__init__();
			return ((Laya.stage && Laya.stage.canvasRotation)? Browser.clientHeight :Browser.clientWidth)*Browser.pixelRatio;
		});

		/**画布容器，用来盛放画布的容器。方便对画布进行控制*/
		__getset(1,Browser,'container',function(){
			Browser.__init__();
			if (!Browser._container){
				Browser._container=Browser.createElement("div");
				Browser._container.id="layaContainer";
				Browser.document.body.appendChild(Browser._container);
			}
			return Browser._container;
			},function(value){
			Browser._container=value;
		});

		/**浏览器原生 document 对象的引用。*/
		__getset(1,Browser,'document',function(){
			Browser.__init__();
			return Browser._document;
		});

		Browser.__init__=function(){
			SoundManager;
			if (Browser._window)return;
			Browser._window=RunDriver.getWindow();
			Browser._document=Browser.window.document;
			Browser._window.addEventListener('message',function(e){
				laya.utils.Browser._onMessage(e);
			},false);
			Browser.document.__createElement=Browser.document.createElement;
			window.requestAnimationFrame=window.requestAnimationFrame || window.webkitRequestAnimationFrame || window.mozRequestAnimationFrame || window.oRequestAnimationFrame || window.msRequestAnimationFrame || function (c){return window.setTimeout(c,1000 / 60);};;
			var $BS=window.document.body.style;$BS.margin=0;$BS.overflow='hidden';;
			var metas=window.document.getElementsByTagName('meta');;
			var i=0,flag=false,content='width=device-width,initial-scale=1.0,minimum-scale=1.0,maximum-scale=1.0,user-scalable=no';;
			while(i<metas.length){var meta=metas[i];if(meta.name=='viewport'){meta.content=content;flag=true;break;}i++;};
			if(!flag){meta=document.createElement('meta');meta.name='viewport',meta.content=content;document.getElementsByTagName('head')[0].appendChild(meta);};
			Browser.userAgent=/*[SAFE]*/ Browser.window.navigator.userAgent;
			Browser.u=/*[SAFE]*/ Browser.userAgent;
			Browser.onIOS=/*[SAFE]*/ !!Browser.u.match(/\(i[^;]+;(U;)? CPU.+Mac OS X/);
			Browser.onMobile=/*[SAFE]*/ Browser.u.indexOf("Mobile")>-1;
			Browser.onIPhone=/*[SAFE]*/ Browser.u.indexOf("iPhone")>-1;
			Browser.onIPad=/*[SAFE]*/ Browser.u.indexOf("iPad")>-1;
			Browser.onAndriod=/*[SAFE]*/ Browser.u.indexOf('Android')>-1 || Browser.u.indexOf('Adr')>-1;
			Browser.onWP=/*[SAFE]*/ Browser.u.indexOf("Windows Phone")>-1;
			Browser.onQQBrowser=/*[SAFE]*/ Browser.u.indexOf("QQBrowser")>-1;
			Browser.onMQQBrowser=/*[SAFE]*/ Browser.u.indexOf("MQQBrowser")>-1;
			Browser.onIE=/*[SAFE]*/ !!Browser.window.ActiveXObject || "ActiveXObject" in Browser.window;
			Browser.onWeiXin=/*[SAFE]*/ Browser.u.indexOf('MicroMessenger')>-1;
			Browser.onPC=/*[SAFE]*/ !Browser.onMobile;
			Browser.onSafari=/*[SAFE]*/ !!Browser.u.match(/Version\/\d+\.\d\x20Mobile\/\S+\x20Safari/);
			Browser.httpProtocol=/*[SAFE]*/ Browser.window.location.protocol=="http:";
			Browser.webAudioEnabled=/*[SAFE]*/ Browser.window["AudioContext"] || Browser.window["webkitAudioContext"] || Browser.window["mozAudioContext"] ? true :false;
			Browser.soundType=/*[SAFE]*/ Browser.webAudioEnabled ? "WEBAUDIOSOUND" :"AUDIOSOUND";
			Sound=Browser.webAudioEnabled?WebAudioSound:AudioSound;;
			if (Browser.webAudioEnabled)WebAudioSound.initWebAudio();;
			Browser.enableTouch=(('ontouchstart' in window)|| window.DocumentTouch && document instanceof DocumentTouch);
			window.focus();
			SoundManager._soundClass=Sound;;
			Render._mainCanvas=Render._mainCanvas || HTMLCanvas.create('2D');
			if (Browser.canvas)return;
			Browser.canvas=HTMLCanvas.create('2D');
			Browser.context=Browser.canvas.getContext('2d');
		}

		Browser._onMessage=function(e){
			if (!e.data)return;
			if (e.data.name=="size"){
				Browser.window.innerWidth=e.data.width;
				Browser.window.innerHeight=e.data.height;
				Browser.window.__innerHeight=e.data.clientHeight;
				if (!Browser.document.createEvent){
					console.warn("no document.createEvent");
					return;
				};
				var evt=Browser.document.createEvent("HTMLEvents");
				evt.initEvent("resize",false,false);
				Browser.window.dispatchEvent(evt);
				return;
			}
		}

		Browser.createElement=function(type){
			Browser.__init__();
			return Browser.document.__createElement(type);
		}

		Browser.getElementById=function(type){
			Browser.__init__();
			return Browser.document.getElementById(type);
		}

		Browser.removeElement=function(ele){
			if (ele && ele.parentNode)ele.parentNode.removeChild(ele);
		}

		Browser.now=function(){
			return RunDriver.now();
		}

		Browser._window=null
		Browser._document=null
		Browser._container=null
		Browser.userAgent=null
		Browser.u=null
		Browser.onIOS=false;
		Browser.onMobile=false;
		Browser.onIPhone=false;
		Browser.onIPad=false;
		Browser.onAndriod=false;
		Browser.onAndroid=false;
		Browser.onWP=false;
		Browser.onQQBrowser=false;
		Browser.onMQQBrowser=false;
		Browser.onSafari=false;
		Browser.onIE=false;
		Browser.onWeiXin=false;
		Browser.onPC=false;
		Browser.httpProtocol=false;
		Browser.webAudioEnabled=false;
		Browser.soundType=null
		Browser.enableTouch=false;
		Browser.canvas=null
		Browser.context=null
		Browser.__init$=function(){
			AudioSound;
			WebAudioSound;
		}

		return Browser;
	})()


	/**
	*<p> <code>Byte</code> 类提供用于优化读取、写入以及处理二进制数据的方法和属性。</p>
	*<p><b>注意：</b> <code>Byte</code> 类适用于需要在字节层访问数据的高级开发人员。</p>
	*/
	//class laya.utils.Byte
	var Byte=(function(){
		function Byte(data){
			this._xd_=true;
			this._allocated_=8;
			//this._d_=null;
			//this._u8d_=null;
			this._pos_=0;
			this._length=0;
			if (data){
				this._u8d_=new Uint8Array(data);
				this._d_=new DataView(this._u8d_.buffer);
				this._length=this._d_.byteLength;
				}else {
				this.___resizeBuffer(this._allocated_);
			}
		}

		__class(Byte,'laya.utils.Byte');
		var __proto=Byte.prototype;
		/**@private */
		__proto.___resizeBuffer=function(len){
			try {
				var newByteView=new Uint8Array(len);
				if (this._u8d_ !=null){
					if (this._u8d_.length <=len)newByteView.set(this._u8d_);
					else newByteView.set(this._u8d_.subarray(0,len));
				}
				this._u8d_=newByteView;
				this._d_=new DataView(newByteView.buffer);
				}catch (err){
				throw "___resizeBuffer err:"+len;
			}
		}

		/**
		*<p>常用于解析固定格式的字节流。</p>
		*<p>先从字节流的当前字节偏移位置处读取一个 <code>Uint16</code> 值，然后以此值为长度，读取此长度的字符串。</p>
		*@return 读取的字符串。
		*/
		__proto.getString=function(){
			return this.rUTF(this.getUint16());
		}

		/**
		*<p>从字节流中 <code>start</code> 参数指定的位置开始，读取 <code>len</code> 参数指定的字节数的数据，用于创建一个 <code>Float32Array</code> 对象并返回此对象。</p>
		*<p><b>注意：</b>返回的 Float32Array 对象，在 JavaScript 环境下，是原生的 HTML5 Float32Array 对象，对此对象的读取操作都是基于运行此程序的当前主机字节序，此顺序可能与实际数据的字节序不同，如果使用此对象进行读取，需要用户知晓实际数据的字节序和当前主机字节序，如果相同，可正常读取，否则需要用户对实际数据(Float32Array.buffer)包装一层 DataView ，使用 DataView 对象可按照指定的字节序进行读取。</p>
		*@param start 开始位置。
		*@param len 需要读取的字节长度。如果要读取的长度超过可读取范围，则只返回可读范围内的值。
		*@return 读取的 Float32Array 对象。
		*/
		__proto.getFloat32Array=function(start,len){
			var end=start+len;
			end=(end > this._length)? this._length :end;
			var v=new Float32Array(this._d_.buffer.slice(start,end));
			this._pos_=end;
			return v;
		}

		/**
		*从字节流中 <code>start</code> 参数指定的位置开始，读取 <code>len</code> 参数指定的字节数的数据，用于创建一个 <code>Uint8Array</code> 对象并返回此对象。
		*@param start 开始位置。
		*@param len 需要读取的字节长度。如果要读取的长度超过可读取范围，则只返回可读范围内的值。
		*@return 读取的 Uint8Array 对象。
		*/
		__proto.getUint8Array=function(start,len){
			var end=start+len;
			end=(end > this._length)? this._length :end;
			var v=new Uint8Array(this._d_.buffer.slice(start,end));
			this._pos_=end;
			return v;
		}

		/**
		*<p>从字节流中 <code>start</code> 参数指定的位置开始，读取 <code>len</code> 参数指定的字节数的数据，用于创建一个 <code>Int16Array</code> 对象并返回此对象。</p>
		*<p><b>注意：</b>返回的 Int16Array 对象，在 JavaScript 环境下，是原生的 HTML5 Int16Array 对象，对此对象的读取操作都是基于运行此程序的当前主机字节序，此顺序可能与实际数据的字节序不同，如果使用此对象进行读取，需要用户知晓实际数据的字节序和当前主机字节序，如果相同，可正常读取，否则需要用户对实际数据(Int16Array.buffer)包装一层 DataView ，使用 DataView 对象可按照指定的字节序进行读取。</p>
		*@param start 开始读取的字节偏移量位置。
		*@param len 需要读取的字节长度。如果要读取的长度超过可读取范围，则只返回可读范围内的值。
		*@return 读取的 Int16Array 对象。
		*/
		__proto.getInt16Array=function(start,len){
			var end=start+len;
			end=(end > this._length)? this._length :end;
			var v=new Int16Array(this._d_.buffer.slice(start,end));
			this._pos_=end;
			return v;
		}

		/**
		*从字节流的当前字节偏移位置处读取一个 IEEE 754 单精度（32 位）浮点数。
		*@return 单精度（32 位）浮点数。
		*/
		__proto.getFloat32=function(){
			if (this._pos_+4 > this._length)throw "getFloat32 error - Out of bounds";
			var v=this._d_.getFloat32(this._pos_,this._xd_);
			this._pos_+=4;
			return v;
		}

		/**
		*从字节流的当前字节偏移量位置处读取一个 IEEE 754 双精度（64 位）浮点数。
		*@return 双精度（64 位）浮点数。
		*/
		__proto.getFloat64=function(){
			if (this._pos_+8 > this._length)throw "getFloat64 error - Out of bounds";
			var v=this._d_.getFloat64(this._pos_,this._xd_);
			this._pos_+=8;
			return v;
		}

		/**
		*在字节流的当前字节偏移量位置处写入一个 IEEE 754 单精度（32 位）浮点数。
		*@param value 单精度（32 位）浮点数。
		*/
		__proto.writeFloat32=function(value){
			this.ensureWrite(this._pos_+4);
			this._d_.setFloat32(this._pos_,value,this._xd_);
			this._pos_+=4;
		}

		/**
		*在字节流的当前字节偏移量位置处写入一个 IEEE 754 双精度（64 位）浮点数。
		*@param value 双精度（64 位）浮点数。
		*/
		__proto.writeFloat64=function(value){
			this.ensureWrite(this._pos_+8);
			this._d_.setFloat64(this._pos_,value,this._xd_);
			this._pos_+=8;
		}

		/**
		*从字节流的当前字节偏移量位置处读取一个 Int32 值。
		*@return Int32 值。
		*/
		__proto.getInt32=function(){
			if (this._pos_+4 > this._length)throw "getInt32 error - Out of bounds";
			var float=this._d_.getInt32(this._pos_,this._xd_);
			this._pos_+=4;
			return float;
		}

		/**
		*从字节流的当前字节偏移量位置处读取一个 Uint32 值。
		*@return Uint32 值。
		*/
		__proto.getUint32=function(){
			if (this._pos_+4 > this._length)throw "getUint32 error - Out of bounds";
			var v=this._d_.getUint32(this._pos_,this._xd_);
			this._pos_+=4;
			return v;
		}

		/**
		*在字节流的当前字节偏移量位置处写入指定的 Int32 值。
		*@param value 需要写入的 Int32 值。
		*/
		__proto.writeInt32=function(value){
			this.ensureWrite(this._pos_+4);
			this._d_.setInt32(this._pos_,value,this._xd_);
			this._pos_+=4;
		}

		/**
		*在字节流的当前字节偏移量位置处写入 Uint32 值。
		*@param value 需要写入的 Uint32 值。
		*/
		__proto.writeUint32=function(value){
			this.ensureWrite(this._pos_+4);
			this._d_.setUint32(this._pos_,value,this._xd_);
			this._pos_+=4;
		}

		/**
		*从字节流的当前字节偏移量位置处读取一个 Int16 值。
		*@return Int16 值。
		*/
		__proto.getInt16=function(){
			if (this._pos_+2 > this._length)throw "getInt16 error - Out of bounds";
			var us=this._d_.getInt16(this._pos_,this._xd_);
			this._pos_+=2;
			return us;
		}

		/**
		*从字节流的当前字节偏移量位置处读取一个 Uint16 值。
		*@return Uint16 值。
		*/
		__proto.getUint16=function(){
			if (this._pos_+2 > this._length)throw "getUint16 error - Out of bounds";
			var us=this._d_.getUint16(this._pos_,this._xd_);
			this._pos_+=2;
			return us;
		}

		/**
		*在字节流的当前字节偏移量位置处写入指定的 Uint16 值。
		*@param value 需要写入的Uint16 值。
		*/
		__proto.writeUint16=function(value){
			this.ensureWrite(this._pos_+2);
			this._d_.setUint16(this._pos_,value,this._xd_);
			this._pos_+=2;
		}

		/**
		*在字节流的当前字节偏移量位置处写入指定的 Int16 值。
		*@param value 需要写入的 Int16 值。
		*/
		__proto.writeInt16=function(value){
			this.ensureWrite(this._pos_+2);
			this._d_.setInt16(this._pos_,value,this._xd_);
			this._pos_+=2;
		}

		/**
		*从字节流的当前字节偏移量位置处读取一个 Uint8 值。
		*@return Uint8 值。
		*/
		__proto.getUint8=function(){
			if (this._pos_+1 > this._length)throw "getUint8 error - Out of bounds";
			return this._d_.getUint8(this._pos_++);
		}

		/**
		*在字节流的当前字节偏移量位置处写入指定的 Uint8 值。
		*@param value 需要写入的 Uint8 值。
		*/
		__proto.writeUint8=function(value){
			this.ensureWrite(this._pos_+1);
			this._d_.setUint8(this._pos_,value);
			this._pos_++;
		}

		/**
		*@private
		*从字节流的指定字节偏移量位置处读取一个 Uint8 值。
		*@param pos 字节读取位置。
		*@return Uint8 值。
		*/
		__proto._getUInt8=function(pos){
			return this._d_.getUint8(pos);
		}

		/**
		*@private
		*从字节流的指定字节偏移量位置处读取一个 Uint16 值。
		*@param pos 字节读取位置。
		*@return Uint16 值。
		*/
		__proto._getUint16=function(pos){
			return this._d_.getUint16(pos,this._xd_);
		}

		/**
		*@private
		*使用 getFloat32()读取6个值，用于创建并返回一个 Matrix 对象。
		*@return Matrix 对象。
		*/
		__proto._getMatrix=function(){
			var rst=new Matrix(this.getFloat32(),this.getFloat32(),this.getFloat32(),this.getFloat32(),this.getFloat32(),this.getFloat32());
			return rst;
		}

		/**
		*@private
		*读取指定长度的 UTF 型字符串。
		*@param len 需要读取的长度。
		*@return 读取的字符串。
		*/
		__proto.rUTF=function(len){
			var v="",max=this._pos_+len,c=0,c2=0,c3=0,f=String.fromCharCode;
			var u=this._u8d_,i=0;
			while (this._pos_ < max){
				c=u[this._pos_++];
				if (c < 0x80){
					if (c !=0){
						v+=f(c);
					}
					}else if (c < 0xE0){
					v+=f(((c & 0x3F)<< 6)| (u[this._pos_++] & 0x7F));
					}else if (c < 0xF0){
					c2=u[this._pos_++];
					v+=f(((c & 0x1F)<< 12)| ((c2 & 0x7F)<< 6)| (u[this._pos_++] & 0x7F));
					}else {
					c2=u[this._pos_++];
					c3=u[this._pos_++];
					v+=f(((c & 0x0F)<< 18)| ((c2 & 0x7F)<< 12)| ((c3 << 6)& 0x7F)| (u[this._pos_++] & 0x7F));
				}
				i++;
			}
			return v;
		}

		/**
		*@private
		*读取 <code>len</code> 参数指定的长度的字符串。
		*@param len 要读取的字符串的长度。
		*@return 指定长度的字符串。
		*/
		__proto.getCustomString=function(len){
			var v="",ulen=0,c=0,c2=0,f=String.fromCharCode;
			var u=this._u8d_,i=0;
			while (len > 0){
				c=u[this._pos_];
				if (c < 0x80){
					v+=f(c);
					this._pos_++;
					len--;
					}else {
					ulen=c-0x80;
					this._pos_++;
					len-=ulen;
					while (ulen > 0){
						c=u[this._pos_++];
						c2=u[this._pos_++];
						v+=f((c2 << 8)| c);
						ulen--;
					}
				}
			}
			return v;
		}

		/**
		*清除字节数组的内容，并将 length 和 pos 属性重置为 0。调用此方法将释放 Byte 实例占用的内存。
		*/
		__proto.clear=function(){
			this._pos_=0;
			this.length=0;
		}

		/**
		*@private
		*获取此对象的 ArrayBuffer 引用。
		*@return
		*/
		__proto.__getBuffer=function(){
			return this._d_.buffer;
		}

		/**
		*<p>将 UTF-8 字符串写入字节流。类似于 writeUTF()方法，但 writeUTFBytes()不使用 16 位长度的字为字符串添加前缀。</p>
		*<p>对应的读取方法为： getUTFBytes 。</p>
		*@param value 要写入的字符串。
		*/
		__proto.writeUTFBytes=function(value){
			value=value+"";
			for (var i=0,sz=value.length;i < sz;i++){
				var c=value.charCodeAt(i);
				if (c <=0x7F){
					this.writeByte(c);
					}else if (c <=0x7FF){
					this.ensureWrite(this._pos_+2);
					this._u8d_.set([0xC0 | (c >> 6),0x80 | (c & 0x3F)],this._pos_);
					this._pos_+=2;
					}else if (c <=0xFFFF){
					this.ensureWrite(this._pos_+3);
					this._u8d_.set([0xE0 | (c >> 12),0x80 | ((c >> 6)& 0x3F),0x80 | (c & 0x3F)],this._pos_);
					this._pos_+=3;
					}else {
					this.ensureWrite(this._pos_+4);
					this._u8d_.set([0xF0 | (c >> 18),0x80 | ((c >> 12)& 0x3F),0x80 | ((c >> 6)& 0x3F),0x80 | (c & 0x3F)],this._pos_);
					this._pos_+=4;
				}
			}
		}

		/**
		*<p>将 UTF-8 字符串写入字节流。先写入以字节表示的 UTF-8 字符串长度（作为 16 位整数），然后写入表示字符串字符的字节。</p>
		*<p>对应的读取方法为： getUTFString 。</p>
		*@param value 要写入的字符串值。
		*/
		__proto.writeUTFString=function(value){
			var tPos=this.pos;
			this.writeUint16(1);
			this.writeUTFBytes(value);
			var dPos=this.pos-tPos-2;
			if (dPos >=65536){
				throw "writeUTFString byte len more than 65536";
			}
			this._d_.setUint16(tPos,dPos,this._xd_);
		}

		/**
		*@private
		*读取 UTF-8 字符串。
		*@return 读取的字符串。
		*/
		__proto.readUTFString=function(){
			return this.readUTFBytes(this.getUint16());
		}

		/**
		*<p>从字节流中读取一个 UTF-8 字符串。假定字符串的前缀是一个无符号的短整型（以此字节表示要读取的长度）。</p>
		*<p>对应的写入方法为： writeUTFString 。</p>
		*@return 读取的字符串。
		*/
		__proto.getUTFString=function(){
			return this.readUTFString();
		}

		/**
		*@private
		*读字符串，必须是 writeUTFBytes 方法写入的字符串。
		*@param len 要读的buffer长度，默认将读取缓冲区全部数据。
		*@return 读取的字符串。
		*/
		__proto.readUTFBytes=function(len){
			(len===void 0)&& (len=-1);
			if (len==0)return "";
			var lastBytes=this.bytesAvailable;
			if (len > lastBytes)throw "readUTFBytes error - Out of bounds";
			len=len > 0 ? len :lastBytes;
			return this.rUTF(len);
		}

		/**
		*<p>从字节流中读取一个由 length 参数指定的长度的 UTF-8 字节序列，并返回一个字符串。</p>
		*<p>一般读取的是由 writeUTFBytes 方法写入的字符串。</p>
		*@param len 要读的buffer长度，默认将读取缓冲区全部数据。
		*@return 读取的字符串。
		*/
		__proto.getUTFBytes=function(len){
			(len===void 0)&& (len=-1);
			return this.readUTFBytes(len);
		}

		/**
		*<p>在字节流中写入一个字节。</p>
		*<p>使用参数的低 8 位。忽略高 24 位。</p>
		*@param value
		*/
		__proto.writeByte=function(value){
			this.ensureWrite(this._pos_+1);
			this._d_.setInt8(this._pos_,value);
			this._pos_+=1;
		}

		/**
		*@private
		*从字节流中读取带符号的字节。
		*/
		__proto.readByte=function(){
			if (this._pos_+1 > this._length)throw "readByte error - Out of bounds";
			return this._d_.getInt8(this._pos_++);
		}

		/**
		*<p>从字节流中读取带符号的字节。</p>
		*<p>返回值的范围是从-128 到 127。</p>
		*@return 介于-128 和 127 之间的整数。
		*/
		__proto.getByte=function(){
			return this.readByte();
		}

		/**
		*<p>保证该字节流的可用长度不小于 <code>lengthToEnsure</code> 参数指定的值。</p>
		*@param lengthToEnsure 指定的长度。
		*/
		__proto.ensureWrite=function(lengthToEnsure){
			if (this._length < lengthToEnsure)this._length=lengthToEnsure;
			if (this._allocated_ < lengthToEnsure)this.length=lengthToEnsure;
		}

		/**
		*<p>将指定 arraybuffer 对象中的以 offset 为起始偏移量， length 为长度的字节序列写入字节流。</p>
		*<p>如果省略 length 参数，则使用默认长度 0，该方法将从 offset 开始写入整个缓冲区；如果还省略了 offset 参数，则写入整个缓冲区。</p>
		*<p>如果 offset 或 length 小于0，本函数将抛出异常。</p>
		*@param arraybuffer 需要写入的 Arraybuffer 对象。
		*@param offset Arraybuffer 对象的索引的偏移量（以字节为单位）
		*@param length 从 Arraybuffer 对象写入到 Byte 对象的长度（以字节为单位）
		*/
		__proto.writeArrayBuffer=function(arraybuffer,offset,length){
			(offset===void 0)&& (offset=0);
			(length===void 0)&& (length=0);
			if (offset < 0 || length < 0)throw "writeArrayBuffer error - Out of bounds";
			if (length==0)length=arraybuffer.byteLength-offset;
			this.ensureWrite(this._pos_+length);
			var uint8array=new Uint8Array(arraybuffer);
			this._u8d_.set(uint8array.subarray(offset,offset+length),this._pos_);
			this._pos_+=length;
		}

		/**
		*获取此对象的 ArrayBuffer 数据，数据只包含有效数据部分。
		*/
		__getset(0,__proto,'buffer',function(){
			var rstBuffer=this._d_.buffer;
			if (rstBuffer.byteLength==this.length)return rstBuffer;
			return rstBuffer.slice(0,this.length);
		});

		/**
		*<p> <code>Byte</code> 实例的字节序。取值为：<code>BIG_ENDIAN</code> 或 <code>BIG_ENDIAN</code> 。</p>
		*<p>主机字节序，是 CPU 存放数据的两种不同顺序，包括小端字节序和大端字节序。通过 <code>getSystemEndian</code> 可以获取当前系统的字节序。</p>
		*<p> <code>BIG_ENDIAN</code> ：大端字节序，地址低位存储值的高位，地址高位存储值的低位。有时也称之为网络字节序。<br/>
		*<code>LITTLE_ENDIAN</code> ：小端字节序，地址低位存储值的低位，地址高位存储值的高位。</p>
		*/
		__getset(0,__proto,'endian',function(){
			return this._xd_ ? "littleEndian" :"bigEndian";
			},function(endianStr){
			this._xd_=(endianStr=="littleEndian");
		});

		/**
		*<p> <code>Byte</code> 对象的长度（以字节为单位）。</p>
		*<p>如果将长度设置为大于当前长度的值，则用零填充字节数组的右侧；如果将长度设置为小于当前长度的值，将会截断该字节数组。</p>
		*<p>如果要设置的长度大于当前已分配的内存空间的字节长度，则重新分配内存空间，大小为以下两者较大者：要设置的长度、当前已分配的长度的2倍，并将原有数据拷贝到新的内存空间中；如果要设置的长度小于当前已分配的内存空间的字节长度，也会重新分配内存空间，大小为要设置的长度，并将原有数据从头截断为要设置的长度存入新的内存空间中。</p>
		*/
		__getset(0,__proto,'length',function(){
			return this._length;
			},function(value){
			if (this._allocated_ < value)
				this.___resizeBuffer(this._allocated_=Math.floor(Math.max(value,this._allocated_ *2)));
			else if (this._allocated_ > value)
			this.___resizeBuffer(this._allocated_=value);
			this._length=value;
		});

		/**
		*移动或返回 Byte 对象的读写指针的当前位置（以字节为单位）。下一次调用读取方法时将在此位置开始读取，或者下一次调用写入方法时将在此位置开始写入。
		*/
		__getset(0,__proto,'pos',function(){
			return this._pos_;
			},function(value){
			this._pos_=value;
		});

		/**
		*可从字节流的当前位置到末尾读取的数据的字节数。
		*/
		__getset(0,__proto,'bytesAvailable',function(){
			return this._length-this._pos_;
		});

		Byte.getSystemEndian=function(){
			if (!Byte._sysEndian){
				var buffer=new ArrayBuffer(2);
				new DataView(buffer).setInt16(0,256,true);
				Byte._sysEndian=(new Int16Array(buffer))[0]===256 ? "littleEndian" :"bigEndian";
			}
			return Byte._sysEndian;
		}

		Byte.BIG_ENDIAN="bigEndian";
		Byte.LITTLE_ENDIAN="littleEndian";
		Byte._sysEndian=null;
		return Byte;
	})()


	/**
	*@private
	*对象缓存统一管理类
	*/
	//class laya.utils.CacheManger
	var CacheManger=(function(){
		function CacheManger(){}
		__class(CacheManger,'laya.utils.CacheManger');
		CacheManger.regCacheByFunction=function(disposeFunction,getCacheListFunction){
			CacheManger.unRegCacheByFunction(disposeFunction,getCacheListFunction);
			var cache;
			cache={tryDispose:disposeFunction,getCacheList:getCacheListFunction};
			CacheManger._cacheList.push(cache);
		}

		CacheManger.unRegCacheByFunction=function(disposeFunction,getCacheListFunction){
			var i=0,len=0;
			len=CacheManger._cacheList.length;
			for (i=0;i < len;i++){
				if (CacheManger._cacheList[i].tryDispose==disposeFunction && CacheManger._cacheList[i].getCacheList==getCacheListFunction){
					CacheManger._cacheList.splice(i,1);
					return;
				}
			}
		}

		CacheManger.forceDispose=function(){
			var i=0,len=CacheManger._cacheList.length;
			for (i=0;i < len;i++){
				CacheManger._cacheList[i].tryDispose(true);
			}
		}

		CacheManger.beginCheck=function(waitTime){
			(waitTime===void 0)&& (waitTime=15000);
			Laya.timer.loop(waitTime,null,CacheManger._checkLoop);
		}

		CacheManger.stopCheck=function(){
			Laya.timer.clear(null,CacheManger._checkLoop);
		}

		CacheManger._checkLoop=function(){
			var cacheList=CacheManger._cacheList;
			if (cacheList.length < 1)return;
			var tTime=Browser.now();
			var count=0;
			var len=0;
			len=count=cacheList.length;
			while (count > 0){
				CacheManger._index++;
				CacheManger._index=CacheManger._index % len;
				cacheList[CacheManger._index].tryDispose(false);
				if (Browser.now()-tTime > CacheManger.loopTimeLimit)break ;
				count--;
			}
		}

		CacheManger.loopTimeLimit=2;
		CacheManger._cacheList=[];
		CacheManger._index=0;
		return CacheManger;
	})()


	/**
	*<code>ClassUtils</code> 是一个类工具类。
	*/
	//class laya.utils.ClassUtils
	var ClassUtils=(function(){
		function ClassUtils(){};
		__class(ClassUtils,'laya.utils.ClassUtils');
		ClassUtils.regClass=function(className,classDef){
			ClassUtils._classMap[className]=classDef;
		}

		ClassUtils.getRegClass=function(className){
			return ClassUtils._classMap[className];
		}

		ClassUtils.getInstance=function(className){
			var compClass=ClassUtils.getClass(className);
			if (compClass)
				return new compClass();
			else
			console.warn("[error] Undefined class:",className);
			return null;
		}

		ClassUtils.createByJson=function(json,node,root,customHandler,instanceHandler){
			if ((typeof json=='string'))
				json=JSON.parse(json);
			var props=json.props;
			if (!node){
				node=instanceHandler ? instanceHandler.runWith(json):ClassUtils.getInstance(props.runtime || json.type);
				if (!node)
					return null;
			};
			var child=json.child;
			if (child){
				for (var i=0,n=child.length;i < n;i++){
					var data=child[i];
					if ((data.props.name==="render" || data.props.renderType==="render")&& node["_$set_itemRender"])
						node.itemRender=data;
					else {
						if (data.type=="Graphic"){
							ClassUtils.addGraphicsToSprite(data,node);
							}else if (ClassUtils.isDrawType(data.type)){
							ClassUtils.addGraphicToSprite(data,node,true);
							}else {
							var tChild=ClassUtils.createByJson(data,null,root,customHandler,instanceHandler)
							if (data.type=="Script"){
								if (tChild.hasOwnProperty("owner")){
									tChild["owner"]=node;
									}else if (tChild.hasOwnProperty("target")){
									tChild["target"]=node;
								}
								}else if (data.props.renderType=="mask"){
								node.mask=tChild;
								}else {
								node.addChild(tChild);
							}
						}
					}
				}
			}
			if (props){
				for (var prop in props){
					var value=props[prop];
					if (prop==="var" && root){
						root[value]=node;
						}else if ((value instanceof Array)&& (typeof (node[prop])=='function')){
						node[prop].apply(node,value);
						}else {
						node[prop]=value;
					}
				}
			}
			if (customHandler && json.customProps){
				customHandler.runWith([node,json]);
			}
			if (node["created"])
				node.created();
			return node;
		}

		ClassUtils.addGraphicsToSprite=function(graphicO,sprite){
			var graphics;
			graphics=graphicO.child;
			if (!graphics || graphics.length < 1)
				return;
			var g;
			g=ClassUtils._getGraphicsFromSprite(graphicO,sprite);
			var ox=0;
			var oy=0;
			if (graphicO.props){
				ox=ClassUtils._getObjVar(graphicO.props,"x",0);
				oy=ClassUtils._getObjVar(graphicO.props,"y",0);
			}
			if (ox !=0 && oy !=0){
				g.translate(ox,oy);
			};
			var i=0,len=0;
			len=graphics.length;
			for (i=0;i < len;i++){
				ClassUtils._addGraphicToGraphics(graphics[i],g);
			}
			if (ox !=0 && oy !=0){
				g.translate(-ox,-oy);
			}
		}

		ClassUtils.addGraphicToSprite=function(graphicO,sprite,isChild){
			(isChild===void 0)&& (isChild=false);
			var g;
			g=isChild ? ClassUtils._getGraphicsFromSprite(graphicO,sprite):sprite.graphics;
			ClassUtils._addGraphicToGraphics(graphicO,g);
		}

		ClassUtils._getGraphicsFromSprite=function(dataO,sprite){
			var g;
			if (!dataO || !dataO.props)
				return sprite.graphics;
			var propsName;
			propsName=dataO.props.renderType;
			switch (propsName){
				case "hit":
				case "unHit":;
					var hitArea;
					if (!sprite.hitArea){
						sprite.hitArea=new HitArea();
					}
					hitArea=sprite.hitArea;
					if (!hitArea[propsName]){
						hitArea[propsName]=new Graphics();
					}
					g=hitArea[propsName];
					break ;
				default :
				}
			if (!g)
				g=sprite.graphics;
			return g;
		}

		ClassUtils._getTransformData=function(propsO){
			var m;
			if (propsO.hasOwnProperty("pivotX")|| propsO.hasOwnProperty("pivotY")){
				m=m || new Matrix();
				m.translate(-ClassUtils._getObjVar(propsO,"pivotX",0),-ClassUtils._getObjVar(propsO,"pivotY",0));
			};
			var sx=ClassUtils._getObjVar(propsO,"scaleX",1),sy=ClassUtils._getObjVar(propsO,"scaleY",1);
			var rotate=ClassUtils._getObjVar(propsO,"rotation",0);
			var skewX=ClassUtils._getObjVar(propsO,"skewX",0);
			var skewY=ClassUtils._getObjVar(propsO,"skewY",0);
			if (sx !=1 || sy !=1 || rotate !=0){
				m=m || new Matrix();
				m.scale(sx,sy);
				m.rotate(rotate *0.0174532922222222);
			}
			return m;
		}

		ClassUtils._addGraphicToGraphics=function(graphicO,graphic){
			var propsO;
			propsO=graphicO.props;
			if (!propsO)
				return;
			var drawConfig;
			drawConfig=ClassUtils.DrawTypeDic[graphicO.type];
			if (!drawConfig)
				return;
			var g;
			g=graphic;
			var m;
			var params=ClassUtils._getParams(propsO,drawConfig[1],drawConfig[2],drawConfig[3]);
			m=ClassUtils._tM;
			if (m || ClassUtils._alpha !=1){
				g.save();
				if (m)
					g.transform(m);
				if (ClassUtils._alpha !=1)
					g.alpha(ClassUtils._alpha);
			}
			g[drawConfig[0]].apply(g,params);
			if (m || ClassUtils._alpha !=1){
				g.restore();
			}
		}

		ClassUtils._adptLineData=function(params){
			params[2]=parseFloat(params[0])+parseFloat(params[2]);
			params[3]=parseFloat(params[1])+parseFloat(params[3]);
			return params;
		}

		ClassUtils._adptTextureData=function(params){
			params[0]=Loader.getRes(params[0]);
			return params;
		}

		ClassUtils._adptLinesData=function(params){
			params[2]=ClassUtils._getPointListByStr(params[2]);
			return params;
		}

		ClassUtils.isDrawType=function(type){
			if (type=="Image")
				return false;
			return ClassUtils.DrawTypeDic.hasOwnProperty(type);
		}

		ClassUtils._getParams=function(obj,params,xPos,adptFun){
			(xPos===void 0)&& (xPos=0);
			var rst;
			rst=ClassUtils._temParam;
			rst.length=params.length;
			var i=0,len=0;
			len=params.length;
			for (i=0;i < len;i++){
				rst[i]=ClassUtils._getObjVar(obj,params[i][0],params[i][1]);
			}
			ClassUtils._alpha=ClassUtils._getObjVar(obj,"alpha",1);
			var m;
			m=ClassUtils._getTransformData(obj);
			if (m){
				if (!xPos)xPos=0;
				m.translate(rst[xPos],rst[xPos+1]);
				rst[xPos]=rst[xPos+1]=0;
				ClassUtils._tM=m;
				}else {
				ClassUtils._tM=null;
			}
			if (adptFun && ClassUtils[adptFun]){
				rst=ClassUtils[adptFun](rst);
			}
			return rst;
		}

		ClassUtils._getPointListByStr=function(str){
			var pointArr;
			pointArr=str.split(",");
			var i=0,len=0;
			len=pointArr.length;
			for (i=0;i < len;i++){
				pointArr[i]=parseFloat(pointArr[i]);
			}
			return pointArr;
		}

		ClassUtils._getObjVar=function(obj,key,noValue){
			if (obj.hasOwnProperty(key)){
				return obj[key];
			}
			return noValue;
		}

		ClassUtils._temParam=[];
		ClassUtils._classMap={'Sprite':'laya.display.Sprite','Text':'laya.display.Text','Animation':'laya.display.Animation','Skeleton':'laya.ani.bone.Skeleton','Particle2D':'laya.particle.Particle2D','div':'laya.html.dom.HTMLDivElement','p':'laya.html.dom.HTMLElement','img':'laya.html.dom.HTMLImageElement','span':'laya.html.dom.HTMLElement','br':'laya.html.dom.HTMLBrElement','style':'laya.html.dom.HTMLStyleElement','font':'laya.html.dom.HTMLElement','a':'laya.html.dom.HTMLElement','#text':'laya.html.dom.HTMLElement'};
		ClassUtils.getClass=function(className){
			var classObject=ClassUtils._classMap[className] || className;
			if ((typeof classObject=='string'))
				return Laya["__classmap"][classObject];
			return classObject;
		}

		ClassUtils._tM=null
		ClassUtils._alpha=NaN
		__static(ClassUtils,
		['DrawTypeDic',function(){return this.DrawTypeDic={"Rect":["drawRect",[["x",0],["y",0],["width",0],["height",0],["fillColor",null],["lineColor",null],["lineWidth",1]]],"Circle":["drawCircle",[["x",0],["y",0],["radius",0],["fillColor",null],["lineColor",null],["lineWidth",1]]],"Pie":["drawPie",[["x",0],["y",0],["radius",0],["startAngle",0],["endAngle",0],["fillColor",null],["lineColor",null],["lineWidth",1]]],"Image":["drawTexture",[["x",0],["y",0],["width",0],["height",0]]],"Texture":["drawTexture",[["skin",null],["x",0],["y",0],["width",0],["height",0]],1,"_adptTextureData"],"FillTexture":["fillTexture",[["skin",null],["x",0],["y",0],["width",0],["height",0],["repeat",null]],1,"_adptTextureData"],"FillText":["fillText",[["text",""],["x",0],["y",0],["font",null],["color",null],["textAlign",null]],1],"Line":["drawLine",[["x",0],["y",0],["toX",0],["toY",0],["lineColor",null],["lineWidth",0]],0,"_adptLineData"],"Lines":["drawLines",[["x",0],["y",0],["points",""],["lineColor",null],["lineWidth",0]],0,"_adptLinesData"],"Curves":["drawCurves",[["x",0],["y",0],["points",""],["lineColor",null],["lineWidth",0]],0,"_adptLinesData"],"Poly":["drawPoly",[["x",0],["y",0],["points",""],["fillColor",null],["lineColor",null],["lineWidth",1]],0,"_adptLinesData"]};}
		]);
		return ClassUtils;
	})()


	/**
	*@private
	*<code>Color</code> 是一个颜色值处理类。
	*/
	//class laya.utils.Color
	var Color=(function(){
		function Color(str){
			this._color=[];
			//this.strColor=null;
			//this.numColor=0;
			//this._drawStyle=null;
			if ((typeof str=='string')){
				this.strColor=str;
				if (str===null)str="#000000";
				str.charAt(0)=='#' && (str=str.substr(1));
				var len=str.length;
				if (len==3 || len==4){
					var temp="";
					for (var i=0;i < len;i++){
						temp+=(str[i]+str[i]);
					}
					str=temp;
				};
				var color=this.numColor=parseInt(str,16);
				var flag=(str.length==8);
				if (flag){
					this._color=[parseInt(str.substr(0,2),16)/ 255,((0x00FF0000 & color)>> 16)/ 255,((0x0000FF00 & color)>> 8)/ 255,(0x000000FF & color)/ 255];
					return;
				}
				}else {
				color=this.numColor=str;
				this.strColor=Utils$1.toHexColor(color);
			}
			this._color=[((0xFF0000 & color)>> 16)/ 255,((0xFF00 & color)>> 8)/ 255,(0xFF & color)/ 255,1];
			(this._color).__id=++Color._COLODID;
		}

		__class(Color,'laya.utils.Color');
		Color._initDefault=function(){
			Color._DEFAULT={};
			for (var i in Color._COLOR_MAP)Color._SAVE[i]=Color._DEFAULT[i]=new Color(Color._COLOR_MAP[i]);
			return Color._DEFAULT;
		}

		Color._initSaveMap=function(){
			Color._SAVE_SIZE=0;
			Color._SAVE={};
			for (var i in Color._DEFAULT)Color._SAVE[i]=Color._DEFAULT[i];
		}

		Color.create=function(str){
			var color=Color._SAVE[str+""];
			if (color !=null)return color;
			(Color._SAVE_SIZE < 1000)|| Color._initSaveMap();
			return Color._SAVE[str+""]=new Color(str);
		}

		Color._SAVE={};
		Color._SAVE_SIZE=0;
		Color._COLOR_MAP={"white":'#FFFFFF',"red":'#FF0000',"green":'#00FF00',"blue":'#0000FF',"black":'#000000',"yellow":'#FFFF00','gray':'#AAAAAA'};
		Color._DEFAULT=Color._initDefault();
		Color._COLODID=1;
		return Color;
	})()


	/**
	*<code>Dictionary</code> 是一个字典型的数据存取类。
	*/
	//class laya.utils.Dictionary
	var Dictionary=(function(){
		function Dictionary(){
			this._values=[];
			this._keys=[];
		}

		__class(Dictionary,'laya.utils.Dictionary');
		var __proto=Dictionary.prototype;
		/**
		*给指定的键名设置值。
		*@param key 键名。
		*@param value 值。
		*/
		__proto.set=function(key,value){
			var index=this.indexOf(key);
			if (index >=0){
				this._values[index]=value;
				return;
			}
			this._keys.push(key);
			this._values.push(value);
		}

		/**
		*获取指定对象的键名索引。
		*@param key 键名对象。
		*@return 键名索引。
		*/
		__proto.indexOf=function(key){
			var index=this._keys.indexOf(key);
			if (index >=0)return index;
			key=((typeof key=='string'))? Number(key):(((typeof key=='number'))? key.toString():key);
			return this._keys.indexOf(key);
		}

		/**
		*返回指定键名的值。
		*@param key 键名对象。
		*@return 指定键名的值。
		*/
		__proto.get=function(key){
			var index=this.indexOf(key);
			return index < 0 ? null :this._values[index];
		}

		/**
		*移除指定键名的值。
		*@param key 键名对象。
		*@return 是否成功移除。
		*/
		__proto.remove=function(key){
			var index=this.indexOf(key);
			if (index >=0){
				this._keys.splice(index,1);
				this._values.splice(index,1);
				return true;
			}
			return false;
		}

		/**
		*清除此对象的键名列表和键值列表。
		*/
		__proto.clear=function(){
			this._values.length=0;
			this._keys.length=0;
		}

		/**
		*获取所有的子元素列表。
		*/
		__getset(0,__proto,'values',function(){
			return this._values;
		});

		/**
		*获取所有的子元素键名列表。
		*/
		__getset(0,__proto,'keys',function(){
			return this._keys;
		});

		return Dictionary;
	})()


	/**
	*@private
	*<code>Dragging</code> 类是触摸滑动控件。
	*/
	//class laya.utils.Dragging
	var Dragging=(function(){
		function Dragging(){
			//this.target=null;
			this.ratio=0.92;
			this.maxOffset=60;
			//this.area=null;
			//this.hasInertia=false;
			//this.elasticDistance=NaN;
			//this.elasticBackTime=NaN;
			//this.data=null;
			this._dragging=false;
			this._clickOnly=true;
			//this._elasticRateX=NaN;
			//this._elasticRateY=NaN;
			//this._lastX=NaN;
			//this._lastY=NaN;
			//this._offsetX=NaN;
			//this._offsetY=NaN;
			//this._offsets=null;
			//this._disableMouseEvent=false;
			//this._tween=null;
			//this._parent=null;
		}

		__class(Dragging,'laya.utils.Dragging');
		var __proto=Dragging.prototype;
		/**
		*开始拖拽。
		*@param target 待拖拽的 <code>Sprite</code> 对象。
		*@param area 滑动范围。
		*@param hasInertia 拖动是否有惯性。
		*@param elasticDistance 橡皮筋最大值。
		*@param elasticBackTime 橡皮筋回弹时间，单位为毫秒。
		*@param data 事件携带数据。
		*@param disableMouseEvent 鼠标事件是否有效。
		*@param ratio 惯性阻尼系数
		*/
		__proto.start=function(target,area,hasInertia,elasticDistance,elasticBackTime,data,disableMouseEvent,ratio){
			(ratio===void 0)&& (ratio=0.92);
			this.clearTimer();
			this.target=target;
			this.area=area;
			this.hasInertia=hasInertia;
			this.elasticDistance=area ? elasticDistance :0;
			this.elasticBackTime=elasticBackTime;
			this.data=data;
			this._disableMouseEvent=disableMouseEvent;
			this.ratio=ratio;
			if (target.globalScaleX !=1 || target.globalScaleY !=1){
				this._parent=target.parent;
				}else {
				this._parent=Laya.stage;
			}
			this._clickOnly=true;
			this._dragging=true;
			this._elasticRateX=this._elasticRateY=1;
			this._lastX=this._parent.mouseX;
			this._lastY=this._parent.mouseY;
			Laya.stage.on("mouseup",this,this.onStageMouseUp);
			Laya.stage.on("mouseout",this,this.onStageMouseUp);
			Laya.timer.frameLoop(1,this,this.loop);
		}

		/**
		*清除计时器。
		*/
		__proto.clearTimer=function(){
			Laya.timer.clear(this,this.loop);
			Laya.timer.clear(this,this.tweenMove);
			if (this._tween){
				this._tween.recover();
				this._tween=null;
			}
		}

		/**
		*停止拖拽。
		*/
		__proto.stop=function(){
			if (this._dragging){
				MouseManager.instance.disableMouseEvent=false;
				Laya.stage.off("mouseup",this,this.onStageMouseUp);
				Laya.stage.off("mouseout",this,this.onStageMouseUp);
				this._dragging=false;
				this.target && this.area && this.backToArea();
				this.clear();
			}
		}

		/**
		*拖拽的循环处理函数。
		*/
		__proto.loop=function(){
			var point=this._parent.getMousePoint();
			var mouseX=point.x;
			var mouseY=point.y;
			var offsetX=mouseX-this._lastX;
			var offsetY=mouseY-this._lastY;
			if (this._clickOnly){
				if (Math.abs(offsetX *Laya.stage._canvasTransform.getScaleX())> 1 || Math.abs(offsetY *Laya.stage._canvasTransform.getScaleY())> 1){
					this._clickOnly=false;
					this._offsets || (this._offsets=[]);
					this._offsets.length=0;
					this.target.event("dragstart",this.data);
					MouseManager.instance.disableMouseEvent=this._disableMouseEvent;
					this.target._set$P("$_MOUSEDOWN",false);
				}else return;
				}else {
				this._offsets.push(offsetX,offsetY);
			}
			if (offsetX===0 && offsetY===0)return;
			this._lastX=mouseX;
			this._lastY=mouseY;
			this.target.x+=offsetX *this._elasticRateX;
			this.target.y+=offsetY *this._elasticRateY;
			this.area && this.checkArea();
			this.target.event("dragmove",this.data);
		}

		/**
		*拖拽区域检测。
		*/
		__proto.checkArea=function(){
			if (this.elasticDistance <=0){
				this.backToArea();
				}else {
				if (this.target.x < this.area.x){
					var offsetX=this.area.x-this.target.x;
					}else if (this.target.x > this.area.x+this.area.width){
					offsetX=this.target.x-this.area.x-this.area.width;
					}else {
					offsetX=0;
				}
				this._elasticRateX=Math.max(0,1-(offsetX / this.elasticDistance));
				if (this.target.y < this.area.y){
					var offsetY=this.area.y-this.target.y;
					}else if (this.target.y > this.area.y+this.area.height){
					offsetY=this.target.y-this.area.y-this.area.height;
					}else {
					offsetY=0;
				}
				this._elasticRateY=Math.max(0,1-(offsetY / this.elasticDistance));
			}
		}

		/**
		*移动至设定的拖拽区域。
		*/
		__proto.backToArea=function(){
			this.target.x=Math.min(Math.max(this.target.x,this.area.x),this.area.x+this.area.width);
			this.target.y=Math.min(Math.max(this.target.y,this.area.y),this.area.y+this.area.height);
		}

		/**
		*舞台的抬起事件侦听函数。
		*@param e Event 对象。
		*/
		__proto.onStageMouseUp=function(e){
			MouseManager.instance.disableMouseEvent=false;
			Laya.stage.off("mouseup",this,this.onStageMouseUp);
			Laya.stage.off("mouseout",this,this.onStageMouseUp);
			Laya.timer.clear(this,this.loop);
			if (this._clickOnly || !this.target)return;
			if (this.hasInertia){
				if (this._offsets.length < 1){
					this._offsets.push(this._parent.mouseX-this._lastX,this._parent.mouseY-this._lastY);
				}
				this._offsetX=this._offsetY=0;
				var len=this._offsets.length;
				var n=Math.min(len,6);
				var m=this._offsets.length-n;
				for (var i=len-1;i > m;i--){
					this._offsetY+=this._offsets[i--];
					this._offsetX+=this._offsets[i];
				}
				this._offsetX=this._offsetX / n *2;
				this._offsetY=this._offsetY / n *2;
				if (Math.abs(this._offsetX)> this.maxOffset)this._offsetX=this._offsetX > 0 ? this.maxOffset :-this.maxOffset;
				if (Math.abs(this._offsetY)> this.maxOffset)this._offsetY=this._offsetY > 0 ? this.maxOffset :-this.maxOffset;
				Laya.timer.frameLoop(1,this,this.tweenMove);
				}else if (this.elasticDistance > 0){
				this.checkElastic();
				}else {
				this.clear();
			}
		}

		/**
		*橡皮筋效果检测。
		*/
		__proto.checkElastic=function(){
			var tx=NaN;
			var ty=NaN;
			if (this.target.x < this.area.x)tx=this.area.x;
			else if (this.target.x > this.area.x+this.area.width)tx=this.area.x+this.area.width;
			if (this.target.y < this.area.y)ty=this.area.y;
			else if (this.target.y > this.area.y+this.area.height)ty=this.area.y+this.area.height;
			if (!isNaN(tx)|| !isNaN(ty)){
				var obj={};
				if (!isNaN(tx))obj.x=tx;
				if (!isNaN(ty))obj.y=ty;
				this._tween=Tween.to(this.target,obj,this.elasticBackTime,Ease.sineOut,Handler.create(this,this.clear),0,false,false);
				}else {
				this.clear();
			}
		}

		/**
		*移动。
		*/
		__proto.tweenMove=function(){
			this._offsetX *=this.ratio *this._elasticRateX;
			this._offsetY *=this.ratio *this._elasticRateY;
			this.target.x+=this._offsetX;
			this.target.y+=this._offsetY;
			this.area && this.checkArea();
			this.target.event("dragmove",this.data);
			if ((Math.abs(this._offsetX)< 1 && Math.abs(this._offsetY)< 1)|| this._elasticRateX < 0.5 || this._elasticRateY < 0.5){
				Laya.timer.clear(this,this.tweenMove);
				if (this.elasticDistance > 0)this.checkElastic();
				else this.clear();
			}
		}

		/**
		*结束拖拽。
		*/
		__proto.clear=function(){
			if (this.target){
				this.clearTimer();
				var sp=this.target;
				this.target=null;
				this._parent=null;
				sp.event("dragend",this.data);
			}
		}

		return Dragging;
	})()


	/**
	*<code>Ease</code> 类定义了缓动函数，以便实现 <code>Tween</code> 动画的缓动效果。
	*/
	//class laya.utils.Ease
	var Ease=(function(){
		function Ease(){};
		__class(Ease,'laya.utils.Ease');
		Ease.linearNone=function(t,b,c,d){
			return c *t / d+b;
		}

		Ease.linearIn=function(t,b,c,d){
			return c *t / d+b;
		}

		Ease.linearInOut=function(t,b,c,d){
			return c *t / d+b;
		}

		Ease.linearOut=function(t,b,c,d){
			return c *t / d+b;
		}

		Ease.bounceIn=function(t,b,c,d){
			return c-Ease.bounceOut(d-t,0,c,d)+b;
		}

		Ease.bounceInOut=function(t,b,c,d){
			if (t < d *0.5)return Ease.bounceIn(t *2,0,c,d)*.5+b;
			else return Ease.bounceOut(t *2-d,0,c,d)*.5+c *.5+b;
		}

		Ease.bounceOut=function(t,b,c,d){
			if ((t /=d)< (1 / 2.75))return c *(7.5625 *t *t)+b;
			else if (t < (2 / 2.75))return c *(7.5625 *(t-=(1.5 / 2.75))*t+.75)+b;
			else if (t < (2.5 / 2.75))return c *(7.5625 *(t-=(2.25 / 2.75))*t+.9375)+b;
			else return c *(7.5625 *(t-=(2.625 / 2.75))*t+.984375)+b;
		}

		Ease.backIn=function(t,b,c,d,s){
			(s===void 0)&& (s=1.70158);
			return c *(t /=d)*t *((s+1)*t-s)+b;
		}

		Ease.backInOut=function(t,b,c,d,s){
			(s===void 0)&& (s=1.70158);
			if ((t /=d *0.5)< 1)return c *0.5 *(t *t *(((s *=(1.525))+1)*t-s))+b;
			return c / 2 *((t-=2)*t *(((s *=(1.525))+1)*t+s)+2)+b;
		}

		Ease.backOut=function(t,b,c,d,s){
			(s===void 0)&& (s=1.70158);
			return c *((t=t / d-1)*t *((s+1)*t+s)+1)+b;
		}

		Ease.elasticIn=function(t,b,c,d,a,p){
			(a===void 0)&& (a=0);
			(p===void 0)&& (p=0);
			var s;
			if (t==0)return b;
			if ((t /=d)==1)return b+c;
			if (!p)p=d *.3;
			if (!a || (c > 0 && a < c)|| (c < 0 && a <-c)){
				a=c;
				s=p / 4;
			}else s=p / Ease.PI2 *Math.asin(c / a);
			return-(a *Math.pow(2,10 *(t-=1))*Math.sin((t *d-s)*Ease.PI2 / p))+b;
		}

		Ease.elasticInOut=function(t,b,c,d,a,p){
			(a===void 0)&& (a=0);
			(p===void 0)&& (p=0);
			var s;
			if (t==0)return b;
			if ((t /=d *0.5)==2)return b+c;
			if (!p)p=d *(.3 *1.5);
			if (!a || (c > 0 && a < c)|| (c < 0 && a <-c)){
				a=c;
				s=p / 4;
			}else s=p / Ease.PI2 *Math.asin(c / a);
			if (t < 1)return-.5 *(a *Math.pow(2,10 *(t-=1))*Math.sin((t *d-s)*Ease.PI2 / p))+b;
			return a *Math.pow(2,-10 *(t-=1))*Math.sin((t *d-s)*Ease.PI2 / p)*.5+c+b;
		}

		Ease.elasticOut=function(t,b,c,d,a,p){
			(a===void 0)&& (a=0);
			(p===void 0)&& (p=0);
			var s;
			if (t==0)return b;
			if ((t /=d)==1)return b+c;
			if (!p)p=d *.3;
			if (!a || (c > 0 && a < c)|| (c < 0 && a <-c)){
				a=c;
				s=p / 4;
			}else s=p / Ease.PI2 *Math.asin(c / a);
			return (a *Math.pow(2,-10 *t)*Math.sin((t *d-s)*Ease.PI2 / p)+c+b);
		}

		Ease.strongIn=function(t,b,c,d){
			return c *(t /=d)*t *t *t *t+b;
		}

		Ease.strongInOut=function(t,b,c,d){
			if ((t /=d *0.5)< 1)return c *0.5 *t *t *t *t *t+b;
			return c *0.5 *((t-=2)*t *t *t *t+2)+b;
		}

		Ease.strongOut=function(t,b,c,d){
			return c *((t=t / d-1)*t *t *t *t+1)+b;
		}

		Ease.sineInOut=function(t,b,c,d){
			return-c *0.5 *(Math.cos(Math.PI *t / d)-1)+b;
		}

		Ease.sineIn=function(t,b,c,d){
			return-c *Math.cos(t / d *Ease.HALF_PI)+c+b;
		}

		Ease.sineOut=function(t,b,c,d){
			return c *Math.sin(t / d *Ease.HALF_PI)+b;
		}

		Ease.quintIn=function(t,b,c,d){
			return c *(t /=d)*t *t *t *t+b;
		}

		Ease.quintInOut=function(t,b,c,d){
			if ((t /=d *0.5)< 1)return c *0.5 *t *t *t *t *t+b;
			return c *0.5 *((t-=2)*t *t *t *t+2)+b;
		}

		Ease.quintOut=function(t,b,c,d){
			return c *((t=t / d-1)*t *t *t *t+1)+b;
		}

		Ease.quartIn=function(t,b,c,d){
			return c *(t /=d)*t *t *t+b;
		}

		Ease.quartInOut=function(t,b,c,d){
			if ((t /=d *0.5)< 1)return c *0.5 *t *t *t *t+b;
			return-c *0.5 *((t-=2)*t *t *t-2)+b;
		}

		Ease.quartOut=function(t,b,c,d){
			return-c *((t=t / d-1)*t *t *t-1)+b;
		}

		Ease.cubicIn=function(t,b,c,d){
			return c *(t /=d)*t *t+b;
		}

		Ease.cubicInOut=function(t,b,c,d){
			if ((t /=d *0.5)< 1)return c *0.5 *t *t *t+b;
			return c *0.5 *((t-=2)*t *t+2)+b;
		}

		Ease.cubicOut=function(t,b,c,d){
			return c *((t=t / d-1)*t *t+1)+b;
		}

		Ease.quadIn=function(t,b,c,d){
			return c *(t /=d)*t+b;
		}

		Ease.quadInOut=function(t,b,c,d){
			if ((t /=d *0.5)< 1)return c *0.5 *t *t+b;
			return-c *0.5 *((--t)*(t-2)-1)+b;
		}

		Ease.quadOut=function(t,b,c,d){
			return-c *(t /=d)*(t-2)+b;
		}

		Ease.expoIn=function(t,b,c,d){
			return (t==0)? b :c *Math.pow(2,10 *(t / d-1))+b-c *0.001;
		}

		Ease.expoInOut=function(t,b,c,d){
			if (t==0)return b;
			if (t==d)return b+c;
			if ((t /=d *0.5)< 1)return c *0.5 *Math.pow(2,10 *(t-1))+b;
			return c *0.5 *(-Math.pow(2,-10 *--t)+2)+b;
		}

		Ease.expoOut=function(t,b,c,d){
			return (t==d)? b+c :c *(-Math.pow(2,-10 *t / d)+1)+b;
		}

		Ease.circIn=function(t,b,c,d){
			return-c *(Math.sqrt(1-(t /=d)*t)-1)+b;
		}

		Ease.circInOut=function(t,b,c,d){
			if ((t /=d *0.5)< 1)return-c *0.5 *(Math.sqrt(1-t *t)-1)+b;
			return c *0.5 *(Math.sqrt(1-(t-=2)*t)+1)+b;
		}

		Ease.circOut=function(t,b,c,d){
			return c *Math.sqrt(1-(t=t / d-1)*t)+b;
		}

		Ease.HALF_PI=Math.PI *0.5;
		Ease.PI2=Math.PI *2;
		return Ease;
	})()


	/**
	*鼠标点击区域，可以设置绘制一系列矢量图作为点击区域和非点击区域（目前只支持圆形，矩形，多边形）
	*/
	//class laya.utils.HitArea
	var HitArea=(function(){
		function HitArea(){
			this._hit=null;
			this._unHit=null;
		}

		__class(HitArea,'laya.utils.HitArea');
		var __proto=HitArea.prototype;
		/**
		*是否包含某个点
		*@param x x坐标
		*@param y y坐标
		*@return 是否点击到
		*/
		__proto.isHit=function(x,y){
			if (!HitArea.isHitGraphic(x,y,this.hit))return false;
			return !HitArea.isHitGraphic(x,y,this.unHit);
		}

		/**
		*检测对象是否包含指定的点。
		*@param x 点的 X 轴坐标值（水平位置）。
		*@param y 点的 Y 轴坐标值（垂直位置）。
		*@return 如果包含指定的点，则值为 true；否则为 false。
		*/
		__proto.contains=function(x,y){
			return this.isHit(x,y);
		}

		/**
		*可点击区域，可以设置绘制一系列矢量图作为点击区域（目前只支持圆形，矩形，多边形）
		*/
		__getset(0,__proto,'hit',function(){
			if (!this._hit)this._hit=new Graphics();
			return this._hit;
			},function(value){
			this._hit=value;
		});

		/**
		*不可点击区域，可以设置绘制一系列矢量图作为非点击区域（目前只支持圆形，矩形，多边形）
		*/
		__getset(0,__proto,'unHit',function(){
			if (!this._unHit)this._unHit=new Graphics();
			return this._unHit;
			},function(value){
			this._unHit=value;
		});

		HitArea.isHitGraphic=function(x,y,graphic){
			if (!graphic)return false;
			var cmds;
			cmds=graphic.cmds;
			if (!cmds && graphic._one){
				cmds=HitArea._cmds;
				cmds.length=1;
				cmds[0]=graphic._one;
			}
			if (!cmds)return false;
			var i=0,len=0;
			len=cmds.length;
			var cmd;
			for (i=0;i < len;i++){
				cmd=cmds[i];
				if (!cmd)continue ;
				var context=Render._context;
				switch (cmd.callee){
					case context._translate:
					case 6:
						x-=cmd[0];
						y-=cmd[1];
					default :
					}
				if (HitArea.isHitCmd(x,y,cmd))return true;
			}
			return false;
		}

		HitArea.isHitCmd=function(x,y,cmd){
			if (!cmd)return false;
			var context=Render._context;
			var rst=false;
			switch (cmd["callee"]){
				case context._drawRect:
				case 13:
					HitArea._rec.setTo(cmd[0],cmd[1],cmd[2],cmd[3]);
					rst=HitArea._rec.contains(x,y);
					break ;
				case context._drawCircle:
				case context._fillCircle:
				case 14:;
					var d=NaN;
					x-=cmd[0];
					y-=cmd[1];
					d=x *x+y *y;
					rst=d < cmd[2] *cmd[2];
					break ;
				case context._drawPoly:
				case 18:
					x-=cmd[0];
					y-=cmd[1];
					rst=HitArea.ptInPolygon(x,y,cmd[2]);
					break ;
				default :
					break ;
				}
			return rst;
		}

		HitArea.ptInPolygon=function(x,y,areaPoints){
			var p;
			p=HitArea._ptPoint;
			p.setTo(x,y);
			var nCross=0;
			var p1x=NaN,p1y=NaN,p2x=NaN,p2y=NaN;
			var len=0;
			len=areaPoints.length;
			for (var i=0;i < len;i+=2){
				p1x=areaPoints[i];
				p1y=areaPoints[i+1];
				p2x=areaPoints[(i+2)% len];
				p2y=areaPoints[(i+3)% len];
				if (p1y==p2y)
					continue ;
				if (p.y < Math.min(p1y,p2y))
					continue ;
				if (p.y >=Math.max(p1y,p2y))
					continue ;
				var tx=(p.y-p1y)*(p2x-p1x)/ (p2y-p1y)+p1x;
				if (tx > p.x){
					nCross++;
				}
			}
			return (nCross % 2==1);
		}

		HitArea._cmds=[];
		__static(HitArea,
		['_rec',function(){return this._rec=new Rectangle();},'_ptPoint',function(){return this._ptPoint=new Point();}
		]);
		return HitArea;
	})()


	/**
	*@private
	*<code>HTMLChar</code> 是一个 HTML 字符类。
	*/
	//class laya.utils.HTMLChar
	var HTMLChar=(function(){
		function HTMLChar(char,w,h,style){
			//this._sprite=null;
			//this._x=NaN;
			//this._y=NaN;
			//this._w=NaN;
			//this._h=NaN;
			//this.isWord=false;
			//this.char=null;
			//this.charNum=NaN;
			//this.style=null;
			this.char=char;
			this.charNum=char.charCodeAt(0);
			this._x=this._y=0;
			this.width=w;
			this.height=h;
			this.style=style;
			this.isWord=!HTMLChar._isWordRegExp.test(char);
		}

		__class(HTMLChar,'laya.utils.HTMLChar');
		var __proto=HTMLChar.prototype;
		Laya.imps(__proto,{"laya.display.ILayout":true})
		/**
		*设置与此对象绑定的显示对象 <code>Sprite</code> 。
		*@param sprite 显示对象 <code>Sprite</code> 。
		*/
		__proto.setSprite=function(sprite){
			this._sprite=sprite;
		}

		/**
		*获取与此对象绑定的显示对象 <code>Sprite</code>。
		*@return
		*/
		__proto.getSprite=function(){
			return this._sprite;
		}

		/**@private */
		__proto._isChar=function(){
			return true;
		}

		/**@private */
		__proto._getCSSStyle=function(){
			return this.style;
		}

		/**
		*宽度。
		*/
		__getset(0,__proto,'width',function(){
			return this._w;
			},function(value){
			this._w=value;
		});

		/**
		*此对象存储的 X 轴坐标值。
		*当设置此值时，如果此对象有绑定的 Sprite 对象，则改变 Sprite 对象的属性 x 的值。
		*/
		__getset(0,__proto,'x',function(){
			return this._x;
			},function(value){
			if (this._sprite){
				this._sprite.x=value;
			}
			this._x=value;
		});

		/**
		*此对象存储的 Y 轴坐标值。
		*当设置此值时，如果此对象有绑定的 Sprite 对象，则改变 Sprite 对象的属性 y 的值。
		*/
		__getset(0,__proto,'y',function(){
			return this._y;
			},function(value){
			if (this._sprite){
				this._sprite.y=value;
			}
			this._y=value;
		});

		/**
		*高度。
		*/
		__getset(0,__proto,'height',function(){
			return this._h;
			},function(value){
			this._h=value;
		});

		HTMLChar._isWordRegExp=new RegExp("[\\w\.]","");
		return HTMLChar;
	})()


	/**
	*<p> <code>Pool</code> 是对象池类，用于对象的存贮、重复使用。</p>
	*<p>合理使用对象池，可以有效减少对象创建的开销，避免频繁的垃圾回收，从而优化游戏流畅度。</p>
	*/
	//class laya.utils.Pool
	var Pool=(function(){
		function Pool(){};
		__class(Pool,'laya.utils.Pool');
		Pool.getPoolBySign=function(sign){
			return Pool._poolDic[sign] || (Pool._poolDic[sign]=[]);
		}

		Pool.clearBySign=function(sign){
			if (Pool._poolDic[sign])Pool._poolDic[sign].length=0;
		}

		Pool.recover=function(sign,item){
			if (item["__InPool"])return;
			item["__InPool"]=true;
			Pool.getPoolBySign(sign).push(item);
		}

		Pool.getItemByClass=function(sign,cls){
			var pool=Pool.getPoolBySign(sign);
			var rst=pool.length ? pool.pop():new cls();
			rst["__InPool"]=false;
			return rst;
		}

		Pool.getItemByCreateFun=function(sign,createFun){
			var pool=Pool.getPoolBySign(sign);
			var rst=pool.length ? pool.pop():createFun();
			rst["__InPool"]=false;
			return rst;
		}

		Pool.getItem=function(sign){
			var pool=Pool.getPoolBySign(sign);
			var rst=pool.length ? pool.pop():null;
			if (rst){
				rst["__InPool"]=false;
			}
			return rst;
		}

		Pool._poolDic={};
		Pool.InPoolSign="__InPool";
		return Pool;
	})()


	/**
	*<p> <code>Stat</code> 是一个性能统计面板，可以实时更新相关的性能参数。</p>
	*<p>参与统计的性能参数如下（所有参数都是每大约1秒进行更新）：<br/>
	*FPS(Canvas)/FPS(WebGL)：Canvas 模式或者 WebGL 模式下的帧频，也就是每秒显示的帧数，值越高、越稳定，感觉越流畅；<br/>
	*Sprite：统计所有渲染节点（包括容器）数量，它的大小会影响引擎进行节点遍历、数据组织和渲染的效率。其值越小，游戏运行效率越高；<br/>
	*DrawCall：此值是决定性能的重要指标，其值越小，游戏运行效率越高。Canvas模式下表示每大约1秒的图像绘制次数；WebGL模式下表示每大约1秒的渲染提交批次，每次准备数据并通知GPU渲染绘制的过程称为1次DrawCall，在每次DrawCall中除了在通知GPU的渲染上比较耗时之外，切换材质与shader也是非常耗时的操作；<br/>
	*CurMem：Canvas模式下，表示内存占用大小，值越小越好，过高会导致游戏闪退；WebGL模式下，表示内存与显存的占用，值越小越好；<br/>
	*Shader：是 WebGL 模式独有的性能指标，表示每大约1秒 Shader 提交次数，值越小越好；<br/>
	*Canvas：由三个数值组成，只有设置 CacheAs 后才会有值，默认为0/0/0。从左到右数值的意义分别为：每帧重绘的画布数量 / 缓存类型为"normal"类型的画布数量 / 缓存类型为"bitmap"类型的画布数量。</p>
	*/
	//class laya.utils.Stat
	var Stat=(function(){
		function Stat(){};
		__class(Stat,'laya.utils.Stat');
		/**
		*点击性能统计显示区域的处理函数。
		*/
		__getset(1,Stat,'onclick',null,function(fn){
			Stat._canvas.source.onclick=fn;
			Stat._canvas.source.style.pointerEvents='';
		});

		Stat.show=function(x,y){
			(x===void 0)&& (x=0);
			(y===void 0)&& (y=0);
			if (Render.isConchApp){
				conch.showFPS&&conch.showFPS(x,y);
				return;
			};
			var pixel=Browser.pixelRatio;
			Stat._width=pixel *130;
			Stat._vx=pixel *75;
			Stat._view[0]={title:"FPS(Canvas)",value:"_fpsStr",color:"yellow",units:"int"};
			Stat._view[1]={title:"Sprite",value:"spriteCount",color:"white",units:"int"};
			Stat._view[2]={title:"DrawCall",value:"drawCall",color:"white",units:"int"};
			Stat._view[3]={title:"CurMem",value:"currentMemorySize",color:"yellow",units:"M"};
			if (Render.isWebGL){
				Stat._view[4]={title:"Shader",value:"shaderCall",color:"white",units:"int"};
				if (!Render.is3DMode){
					Stat._view[0].title="FPS(WebGL)";
					Stat._view[5]={title:"Canvas",value:"_canvasStr",color:"white",units:"int"};
					}else {
					Stat._view[0].title="FPS(3D)";
					Stat._view[5]={title:"TriFaces",value:"trianglesFaces",color:"white",units:"int"};
					Stat._view[6]={title:"treeNodeColl",value:"treeNodeCollision",color:"white",units:"int"};
					Stat._view[7]={title:"treeSpriteColl",value:"treeSpriteCollision",color:"white",units:"int"};
				}
				}else {
				Stat._view[4]={title:"Canvas",value:"_canvasStr",color:"white",units:"int"};
			}
			Stat._fontSize=12 *pixel;
			for (var i=0;i < Stat._view.length;i++){
				Stat._view[i].x=4;
				Stat._view[i].y=i *Stat._fontSize+2 *pixel;
			}
			Stat._height=pixel *(Stat._view.length *12+3 *pixel)+4;
			if (!Stat._canvas){
				Stat._canvas=new HTMLCanvas('2D');
				Stat._canvas.size(Stat._width,Stat._height);
				Stat._ctx=Stat._canvas.getContext('2d');
				Stat._ctx.textBaseline="top";
				Stat._ctx.font=Stat._fontSize+"px Sans-serif";
				Stat._canvas.source.style.cssText="pointer-events:none;background:rgba(150,150,150,0.8);z-index:100000;position: absolute;left:"+x+"px;top:"+y+"px;width:"+(Stat._width / pixel)+"px;height:"+(Stat._height / pixel)+"px;";
			}
			Stat._first=true;
			Stat.loop();
			Stat._first=false;
			Browser.container.appendChild(Stat._canvas.source);
			Stat.enable();
		}

		Stat.enable=function(){
			Laya.timer.frameLoop(1,Stat,Stat.loop);
		}

		Stat.hide=function(){
			if (Stat._canvas){
				Browser.removeElement(Stat._canvas.source);
				Laya.timer.clear(Stat,Stat.loop);
			}
		}

		Stat.clear=function(){
			Stat.trianglesFaces=Stat.drawCall=Stat.shaderCall=Stat.spriteCount=Stat.treeNodeCollision=Stat.treeSpriteCollision=Stat.canvasNormal=Stat.canvasBitmap=Stat.canvasReCache=0;
		}

		Stat.loop=function(){
			Stat._count++;
			var timer=Browser.now();
			if (timer-Stat._timer < 1000)return;
			var count=Stat._count;
			Stat.FPS=Math.round((count *1000)/ (timer-Stat._timer));
			if (Stat._canvas){
				Stat.trianglesFaces=Math.round(Stat.trianglesFaces / count);
				Stat.drawCall=Math.round(Stat.drawCall / count)-2;
				Stat.shaderCall=Math.round(Stat.shaderCall / count);
				Stat.spriteCount=Math.round(Stat.spriteCount / count)-1;
				Stat.canvasNormal=Math.round(Stat.canvasNormal / count);
				Stat.canvasBitmap=Math.round(Stat.canvasBitmap / count);
				Stat.canvasReCache=Math.ceil(Stat.canvasReCache / count);
				Stat.treeNodeCollision=Math.round(Stat.treeNodeCollision / count);
				Stat.treeSpriteCollision=Math.round(Stat.treeSpriteCollision / count);
				var delay=Stat.FPS > 0 ? Math.floor(1000 / Stat.FPS).toString():" ";
				Stat._fpsStr=Stat.FPS+(Stat.renderSlow ? " slow" :"")+" "+delay;
				Stat._canvasStr=Stat.canvasReCache+"/"+Stat.canvasNormal+"/"+Stat.canvasBitmap;
				Stat.currentMemorySize=ResourceManager.systemResourceManager.memorySize;
				var ctx=Stat._ctx;
				ctx.clearRect(Stat._first ? 0 :Stat._vx,0,Stat._width,Stat._height);
				for (var i=0;i < Stat._view.length;i++){
					var one=Stat._view[i];
					if (Stat._first){
						ctx.fillStyle="white";
						ctx.fillText(one.title,one.x,one.y,null,null,null);
					}
					ctx.fillStyle=one.color;
					var value=Stat[one.value];
					(one.units=="M")&& (value=Math.floor(value / (1024 *1024)*100)/ 100+" M");
					ctx.fillText(value+"",one.x+Stat._vx,one.y,null,null,null);
				}
				Stat.clear();
			}
			Stat._count=0;
			Stat._timer=timer;
		}

		Stat.FPS=0;
		Stat.loopCount=0;
		Stat.shaderCall=0;
		Stat.drawCall=0;
		Stat.trianglesFaces=0;
		Stat.spriteCount=0;
		Stat.treeNodeCollision=0;
		Stat.treeSpriteCollision=0;
		Stat.canvasNormal=0;
		Stat.canvasBitmap=0;
		Stat.canvasReCache=0;
		Stat.renderSlow=false;
		Stat.currentMemorySize=0;
		Stat._fpsStr=null
		Stat._canvasStr=null
		Stat._canvas=null
		Stat._ctx=null
		Stat._timer=0;
		Stat._count=0;
		Stat._width=0;
		Stat._height=100;
		Stat._view=[];
		Stat._fontSize=12;
		Stat._first=false;
		Stat._vx=NaN
		return Stat;
	})()


	/**
	*@private
	*<code>StringKey</code> 类用于存取字符串对应的数字。
	*/
	//class laya.utils.StringKey
	var StringKey=(function(){
		function StringKey(){
			this._strsToID={};
			this._idToStrs=[];
			this._length=0;
		}

		__class(StringKey,'laya.utils.StringKey');
		var __proto=StringKey.prototype;
		/**
		*添加一个字符。
		*@param str 字符，将作为key 存储相应生成的数字。
		*@return 此字符对应的数字。
		*/
		__proto.add=function(str){
			var index=this._strsToID[str];
			if (index !=null)return index;
			this._idToStrs[this._length]=str;
			return this._strsToID[str]=this._length++;
		}

		/**
		*获取指定字符对应的ID。
		*@param str 字符。
		*@return 此字符对应的ID。
		*/
		__proto.getID=function(str){
			var index=this._strsToID[str];
			return index==null ?-1 :index;
		}

		/**
		*根据指定ID获取对应字符。
		*@param id ID。
		*@return 此id对应的字符。
		*/
		__proto.getName=function(id){
			var str=this._idToStrs[id];
			return str==null ? undefined :str;
		}

		return StringKey;
	})()


	/**
	*<code>Timer</code> 是时钟管理类。它是一个单例，不要手动实例化此类，应该通过 Laya.timer 访问。
	*/
	//class laya.utils.Timer
	var Timer=(function(){
		var TimerHandler;
		function Timer(){
			this._delta=0;
			this.scale=1;
			this.currFrame=0;
			this._mid=1;
			this._map=[];
			this._laters=[];
			this._handlers=[];
			this._temp=[];
			this._count=0;
			this.currTimer=Browser.now();
			this._lastTimer=Browser.now();
			Laya.timer && Laya.timer.frameLoop(1,this,this._update);
		}

		__class(Timer,'laya.utils.Timer');
		var __proto=Timer.prototype;
		/**
		*@private
		*帧循环处理函数。
		*/
		__proto._update=function(){
			if (this.scale <=0){
				this._lastTimer=Browser.now();
				return;
			};
			var frame=this.currFrame=this.currFrame+this.scale;
			var now=Browser.now();
			this._delta=(now-this._lastTimer)*this.scale;
			var timer=this.currTimer=this.currTimer+this._delta;
			this._lastTimer=now;
			var handlers=this._handlers;
			this._count=0;
			for (i=0,n=handlers.length;i < n;i++){
				handler=handlers[i];
				if (handler.method!==null){
					var t=handler.userFrame ? frame :timer;
					if (t >=handler.exeTime){
						if (handler.repeat){
							if (!handler.jumpFrame){
								handler.exeTime+=handler.delay;
								handler.run(false);
								if (t > handler.exeTime){
									handler.exeTime+=Math.ceil((t-handler.exeTime)/ handler.delay)*handler.delay;
								}
								}else {
								while (t >=handler.exeTime){
									handler.exeTime+=handler.delay;
									handler.run(false);
								}
							}
							}else {
							handler.run(true);
						}
					}
					}else {
					this._count++;
				}
			}
			if (this._count > 30 || frame % 200===0)this._clearHandlers();
			var laters=this._laters;
			for (var i=0,n=laters.length-1;i <=n;i++){
				var handler=laters[i];
				if (handler.method!==null){
					this._map[handler.key]=null;
					handler.run(false);
				}
				this._recoverHandler(handler);
				i===n && (n=laters.length-1);
			}
			laters.length=0;
		}

		/**@private */
		__proto._clearHandlers=function(){
			var handlers=this._handlers;
			for (var i=0,n=handlers.length;i < n;i++){
				var handler=handlers[i];
				if (handler.method!==null)this._temp.push(handler);
				else this._recoverHandler(handler);
			}
			this._handlers=this._temp;
			this._temp=handlers;
			this._temp.length=0;
		}

		/**@private */
		__proto._recoverHandler=function(handler){
			if(this._map[handler.key]==handler)this._map[handler.key]=null;
			handler.clear();
			Timer._pool.push(handler);
		}

		/**@private */
		__proto._create=function(useFrame,repeat,delay,caller,method,args,coverBefore){
			if (!delay){
				method.apply(caller,args);
				return null;
			}
			if (coverBefore){
				var handler=this._getHandler(caller,method);
				if (handler){
					handler.repeat=repeat;
					handler.userFrame=useFrame;
					handler.delay=delay;
					handler.caller=caller;
					handler.method=method;
					handler.args=args;
					handler.exeTime=delay+(useFrame ? this.currFrame :this.currTimer+Browser.now()-this._lastTimer);
					return handler;
				}
			}
			handler=Timer._pool.length > 0 ? Timer._pool.pop():new TimerHandler();
			handler.repeat=repeat;
			handler.userFrame=useFrame;
			handler.delay=delay;
			handler.caller=caller;
			handler.method=method;
			handler.args=args;
			handler.exeTime=delay+(useFrame ? this.currFrame :this.currTimer+Browser.now()-this._lastTimer);
			this._indexHandler(handler);
			this._handlers.push(handler);
			return handler;
		}

		/**@private */
		__proto._indexHandler=function(handler){
			var caller=handler.caller;
			var method=handler.method;
			var cid=caller ? caller.$_GID || (caller.$_GID=Utils$1.getGID()):0;
			var mid=method.$_TID || (method.$_TID=(this._mid++)*100000);
			handler.key=cid+mid;
			this._map[handler.key]=handler;
		}

		/**
		*定时执行一次。
		*@param delay 延迟时间(单位为毫秒)。
		*@param caller 执行域(this)。
		*@param method 定时器回调函数。
		*@param args 回调参数。
		*@param coverBefore 是否覆盖之前的延迟执行，默认为 true 。
		*/
		__proto.once=function(delay,caller,method,args,coverBefore){
			(coverBefore===void 0)&& (coverBefore=true);
			this._create(false,false,delay,caller,method,args,coverBefore);
		}

		/**
		*定时重复执行。
		*@param delay 间隔时间(单位毫秒)。
		*@param caller 执行域(this)。
		*@param method 定时器回调函数。
		*@param args 回调参数。
		*@param coverBefore 是否覆盖之前的延迟执行，默认为 true 。
		*@param jumpFrame 时钟是否跳帧。基于时间的循环回调，单位时间间隔内，如能执行多次回调，出于性能考虑，引擎默认只执行一次，设置jumpFrame=true后，则回调会连续执行多次
		*/
		__proto.loop=function(delay,caller,method,args,coverBefore,jumpFrame){
			(coverBefore===void 0)&& (coverBefore=true);
			(jumpFrame===void 0)&& (jumpFrame=false);
			var handler=this._create(false,true,delay,caller,method,args,coverBefore);
			if (handler)handler.jumpFrame=jumpFrame;
		}

		/**
		*定时执行一次(基于帧率)。
		*@param delay 延迟几帧(单位为帧)。
		*@param caller 执行域(this)。
		*@param method 定时器回调函数。
		*@param args 回调参数。
		*@param coverBefore 是否覆盖之前的延迟执行，默认为 true 。
		*/
		__proto.frameOnce=function(delay,caller,method,args,coverBefore){
			(coverBefore===void 0)&& (coverBefore=true);
			this._create(true,false,delay,caller,method,args,coverBefore);
		}

		/**
		*定时重复执行(基于帧率)。
		*@param delay 间隔几帧(单位为帧)。
		*@param caller 执行域(this)。
		*@param method 定时器回调函数。
		*@param args 回调参数。
		*@param coverBefore 是否覆盖之前的延迟执行，默认为 true 。
		*/
		__proto.frameLoop=function(delay,caller,method,args,coverBefore){
			(coverBefore===void 0)&& (coverBefore=true);
			this._create(true,true,delay,caller,method,args,coverBefore);
		}

		/**返回统计信息。*/
		__proto.toString=function(){
			return "callLater:"+this._laters.length+" handlers:"+this._handlers.length+" pool:"+Timer._pool.length;
		}

		/**
		*清理定时器。
		*@param caller 执行域(this)。
		*@param method 定时器回调函数。
		*/
		__proto.clear=function(caller,method){
			var handler=this._getHandler(caller,method);
			if (handler){
				this._map[handler.key]=null;handler.key=0;
				handler.clear();
			}
		}

		/**
		*清理对象身上的所有定时器。
		*@param caller 执行域(this)。
		*/
		__proto.clearAll=function(caller){
			if (!caller)return;
			for (var i=0,n=this._handlers.length;i < n;i++){
				var handler=this._handlers[i];
				if (handler.caller===caller){
					this._map[handler.key]=null;handler.key=0;
					handler.clear();
				}
			}
		}

		/**@private */
		__proto._getHandler=function(caller,method){
			var cid=caller ? caller.$_GID || (caller.$_GID=Utils$1.getGID()):0;
			var mid=method.$_TID || (method.$_TID=(this._mid++)*100000);
			return this._map[cid+mid];
		}

		/**
		*延迟执行。
		*@param caller 执行域(this)。
		*@param method 定时器回调函数。
		*@param args 回调参数。
		*/
		__proto.callLater=function(caller,method,args){
			if (this._getHandler(caller,method)==null){
				if (Timer._pool.length)
					var handler=Timer._pool.pop();
				else handler=new TimerHandler();
				handler.caller=caller;
				handler.method=method;
				handler.args=args;
				this._indexHandler(handler);
				this._laters.push(handler);
			}
		}

		/**
		*立即执行 callLater 。
		*@param caller 执行域(this)。
		*@param method 定时器回调函数。
		*/
		__proto.runCallLater=function(caller,method){
			var handler=this._getHandler(caller,method);
			if (handler && handler.method !=null){
				this._map[handler.key]=null;
				handler.run(true);
			}
		}

		/**
		*立即提前执行定时器，执行之后从队列中删除
		*@param caller 执行域(this)。
		*@param method 定时器回调函数。
		*/
		__proto.runTimer=function(caller,method){
			this.runCallLater(caller,method);
		}

		/**
		*两帧之间的时间间隔,单位毫秒。
		*/
		__getset(0,__proto,'delta',function(){
			return this._delta;
		});

		Timer._pool=[];
		Timer.__init$=function(){
			/**@private */
			//class TimerHandler
			TimerHandler=(function(){
				function TimerHandler(){
					this.key=0;
					this.repeat=false;
					this.delay=0;
					this.userFrame=false;
					this.exeTime=0;
					this.caller=null;
					this.method=null;
					this.args=null;
					this.jumpFrame=false;
				}
				__class(TimerHandler,'');
				var __proto=TimerHandler.prototype;
				__proto.clear=function(){
					this.caller=null;
					this.method=null;
					this.args=null;
				}
				__proto.run=function(withClear){
					var caller=this.caller;
					if (caller && caller.destroyed)return this.clear();
					var method=this.method;
					var args=this.args;
					withClear && this.clear();
					if (method==null)return;
					args ? method.apply(caller,args):method.call(caller);
				}
				return TimerHandler;
			})()
		}

		return Timer;
	})()


	/**
	*<code>Tween</code> 是一个缓动类。使用此类能够实现对目标对象属性的渐变。
	*/
	//class laya.utils.Tween
	var Tween=(function(){
		function Tween(){
			//this._complete=null;
			//this._target=null;
			//this._ease=null;
			//this._props=null;
			//this._duration=0;
			//this._delay=0;
			//this._startTimer=0;
			//this._usedTimer=0;
			//this._usedPool=false;
			this.gid=0;
			//this.update=null;
		}

		__class(Tween,'laya.utils.Tween');
		var __proto=Tween.prototype;
		/**
		*缓动对象的props属性到目标值。
		*@param target 目标对象(即将更改属性值的对象)。
		*@param props 变化的属性列表，比如{x:100,y:20,ease:Ease.backOut,complete:Handler.create(this,onComplete),update:new Handler(this,onComplete)}。
		*@param duration 花费的时间，单位毫秒。
		*@param ease 缓动类型，默认为匀速运动。
		*@param complete 结束回调函数。
		*@param delay 延迟执行时间。
		*@param coverBefore 是否覆盖之前的缓动。
		*@return 返回Tween对象。
		*/
		__proto.to=function(target,props,duration,ease,complete,delay,coverBefore){
			(delay===void 0)&& (delay=0);
			(coverBefore===void 0)&& (coverBefore=false);
			return this._create(target,props,duration,ease,complete,delay,coverBefore,true,false,true);
		}

		/**
		*从props属性，缓动到当前状态。
		*@param target 目标对象(即将更改属性值的对象)。
		*@param props 变化的属性列表，比如{x:100,y:20,ease:Ease.backOut,complete:Handler.create(this,onComplete),update:new Handler(this,onComplete)}。
		*@param duration 花费的时间，单位毫秒。
		*@param ease 缓动类型，默认为匀速运动。
		*@param complete 结束回调函数。
		*@param delay 延迟执行时间。
		*@param coverBefore 是否覆盖之前的缓动。
		*@return 返回Tween对象。
		*/
		__proto.from=function(target,props,duration,ease,complete,delay,coverBefore){
			(delay===void 0)&& (delay=0);
			(coverBefore===void 0)&& (coverBefore=false);
			return this._create(target,props,duration,ease,complete,delay,coverBefore,false,false,true);
		}

		/**@private */
		__proto._create=function(target,props,duration,ease,complete,delay,coverBefore,isTo,usePool,runNow){
			if (!target)throw new Error("Tween:target is null");
			this._target=target;
			this._duration=duration;
			this._ease=ease || props.ease || Tween.easeNone;
			this._complete=complete || props.complete;
			this._delay=delay;
			this._props=[];
			this._usedTimer=0;
			this._startTimer=Browser.now();
			this._usedPool=usePool;
			this.update=props.update;
			var gid=(target.$_GID || (target.$_GID=Utils$1.getGID()));
			if (!Tween.tweenMap[gid]){
				Tween.tweenMap[gid]=[this];
				}else {
				if (coverBefore)Tween.clearTween(target);
				Tween.tweenMap[gid].push(this);
			}
			if (runNow){
				if (delay <=0)this.firstStart(target,props,isTo);
				else Laya.timer.once(delay,this,this.firstStart,[target,props,isTo]);
				}else {
				this._initProps(target,props,isTo);
			}
			return this;
		}

		__proto.firstStart=function(target,props,isTo){
			if (target.destroyed){
				this.clear();
				return;
			}
			this._initProps(target,props,isTo);
			this._beginLoop();
		}

		__proto._initProps=function(target,props,isTo){
			for (var p in props){
				if ((typeof (target[p])=='number')){
					var start=isTo ? target[p] :props[p];
					var end=isTo ? props[p] :target[p];
					this._props.push([p,start,end-start]);
					if (!isTo)target[p]=start;
				}
			}
		}

		__proto._beginLoop=function(){
			Laya.timer.frameLoop(1,this,this._doEase);
		}

		/**执行缓动**/
		__proto._doEase=function(){
			this._updateEase(Browser.now());
		}

		/**@private */
		__proto._updateEase=function(time){
			var target=this._target;
			if (!target)return;
			if (target.destroyed)return Tween.clearTween(target);
			var usedTimer=this._usedTimer=time-this._startTimer-this._delay;
			if (usedTimer < 0)return;
			if (usedTimer >=this._duration)return this.complete();
			var ratio=usedTimer > 0 ? this._ease(usedTimer,0,1,this._duration):0;
			var props=this._props;
			for (var i=0,n=props.length;i < n;i++){
				var prop=props[i];
				target[prop[0]]=prop[1]+(ratio *prop[2]);
			}
			if (this.update)this.update.run();
		}

		/**
		*立即结束缓动并到终点。
		*/
		__proto.complete=function(){
			if (!this._target)return;
			Laya.timer.runTimer(this,this.firstStart);
			var target=this._target;
			var props=this._props;
			var handler=this._complete;
			for (var i=0,n=props.length;i < n;i++){
				var prop=props[i];
				target[prop[0]]=prop[1]+prop[2];
			}
			if (this.update)this.update.run();
			this.clear();
			handler && handler.run();
		}

		/**
		*暂停缓动，可以通过resume或restart重新开始。
		*/
		__proto.pause=function(){
			Laya.timer.clear(this,this._beginLoop);
			Laya.timer.clear(this,this._doEase);
		}

		/**
		*设置开始时间。
		*@param startTime 开始时间。
		*/
		__proto.setStartTime=function(startTime){
			this._startTimer=startTime;
		}

		/**
		*停止并清理当前缓动。
		*/
		__proto.clear=function(){
			if (this._target){
				this._remove();
				this._clear();
			}
		}

		/**
		*@private
		*/
		__proto._clear=function(){
			this.pause();
			Laya.timer.clear(this,this.firstStart);
			this._complete=null;
			this._target=null;
			this._ease=null;
			this._props=null;
			if (this._usedPool){
				this.update=null;
				Pool.recover("tween",this);
			}
		}

		/**回收到对象池。*/
		__proto.recover=function(){
			this._usedPool=true;
			this._clear();
		}

		__proto._remove=function(){
			var tweens=Tween.tweenMap[this._target.$_GID];
			if (tweens){
				for (var i=0,n=tweens.length;i < n;i++){
					if (tweens[i]===this){
						tweens.splice(i,1);
						break ;
					}
				}
			}
		}

		/**
		*重新开始暂停的缓动。
		*/
		__proto.restart=function(){
			this.pause();
			this._usedTimer=0;
			this._startTimer=Browser.now();
			var props=this._props;
			for (var i=0,n=props.length;i < n;i++){
				var prop=props[i];
				this._target[prop[0]]=prop[1];
			}
			Laya.timer.once(this._delay,this,this._beginLoop);
		}

		/**
		*恢复暂停的缓动。
		*/
		__proto.resume=function(){
			if (this._usedTimer >=this._duration)return;
			this._startTimer=Browser.now()-this._usedTimer-this._delay;
			this._beginLoop();
		}

		/**设置当前执行比例**/
		__getset(0,__proto,'progress',null,function(v){
			var uTime=v *this._duration;
			this._startTimer=Browser.now()-this._delay-uTime;
		});

		Tween.to=function(target,props,duration,ease,complete,delay,coverBefore,autoRecover){
			(delay===void 0)&& (delay=0);
			(coverBefore===void 0)&& (coverBefore=false);
			(autoRecover===void 0)&& (autoRecover=true);
			return Pool.getItemByClass("tween",Tween)._create(target,props,duration,ease,complete,delay,coverBefore,true,autoRecover,true);
		}

		Tween.from=function(target,props,duration,ease,complete,delay,coverBefore,autoRecover){
			(delay===void 0)&& (delay=0);
			(coverBefore===void 0)&& (coverBefore=false);
			(autoRecover===void 0)&& (autoRecover=true);
			return Pool.getItemByClass("tween",Tween)._create(target,props,duration,ease,complete,delay,coverBefore,false,autoRecover,true);
		}

		Tween.clearAll=function(target){
			if (!target || !target.$_GID)return;
			var tweens=Tween.tweenMap[target.$_GID];
			if (tweens){
				for (var i=0,n=tweens.length;i < n;i++){
					tweens[i]._clear();
				}
				tweens.length=0;
			}
		}

		Tween.clear=function(tween){
			tween.clear();
		}

		Tween.clearTween=function(target){
			Tween.clearAll(target);
		}

		Tween.easeNone=function(t,b,c,d){
			return c *t / d+b;
		}

		Tween.tweenMap={};
		return Tween;
	})()


	/**
	*<code>Utils</code> 是工具类。
	*/
	//class laya.utils.Utils
	var Utils$1=(function(){
		function Utils(){};
		__class(Utils,'laya.utils.Utils',null,'Utils$1');
		Utils.toRadian=function(angle){
			return angle *Utils._pi2;
		}

		Utils.toAngle=function(radian){
			return radian *Utils._pi;
		}

		Utils.toHexColor=function(color){
			if (color < 0 || isNaN(color))return null;
			var str=color.toString(16);
			while (str.length < 6)str="0"+str;
			return "#"+str;
		}

		Utils.getGID=function(){
			return Utils._gid++;
		}

		Utils.concatArray=function(source,array){
			if (!array)return source;
			if (!source)return array;
			var i=0,len=array.length;
			for (i=0;i < len;i++){
				source.push(array[i]);
			}
			return source;
		}

		Utils.clearArray=function(array){
			if (!array)return array;
			array.length=0;
			return array;
		}

		Utils.copyArray=function(source,array){
			source || (source=[]);
			if (!array)return source;
			source.length=array.length;
			var i=0,len=array.length;
			for (i=0;i < len;i++){
				source[i]=array[i];
			}
			return source;
		}

		Utils.getGlobalRecByPoints=function(sprite,x0,y0,x1,y1){
			var newLTPoint;
			newLTPoint=new Point(x0,y0);
			newLTPoint=sprite.localToGlobal(newLTPoint);
			var newRBPoint;
			newRBPoint=new Point(x1,y1);
			newRBPoint=sprite.localToGlobal(newRBPoint);
			return Rectangle._getWrapRec([newLTPoint.x,newLTPoint.y,newRBPoint.x,newRBPoint.y]);
		}

		Utils.getGlobalPosAndScale=function(sprite){
			return Utils.getGlobalRecByPoints(sprite,0,0,1,1);
		}

		Utils.bind=function(fun,scope){
			var rst=fun;
			rst=fun.bind(scope);;
			return rst;
		}

		Utils.measureText=function(txt,font){
			return RunDriver.measureText(txt,font);
		}

		Utils.updateOrder=function(array){
			if (!array || array.length < 2)return false;
			var i=1,j=0,len=array.length,key=NaN,c;
			while (i < len){
				j=i;
				c=array[j];
				key=array[j]._zOrder;
				while (--j >-1){
					if (array[j]._zOrder > key)array[j+1]=array[j];
					else break ;
				}
				array[j+1]=c;
				i++;
			};
			var model=c.parent.conchModel;
			if (model){
				if (model.updateZOrder !=null){
					model.updateZOrder();
					}else {
					for (i=0;i < len;i++){
						model.removeChild(array[i].conchModel);
					}
					for (i=0;i < len;i++){
						model.addChildAt(array[i].conchModel,i);
					}
				}
			}
			return true;
		}

		Utils.transPointList=function(points,x,y){
			var i=0,len=points.length;
			for (i=0;i < len;i+=2){
				points[i]+=x;
				points[i+1]+=y;
			}
		}

		Utils.parseInt=function(str,radix){
			(radix===void 0)&& (radix=0);
			var result=Browser.window.parseInt(str,radix);
			if (isNaN(result))return 0;
			return result;
		}

		Utils.getFileExtension=function(path){
			Utils._extReg.lastIndex=path.lastIndexOf(".");
			var result=Utils._extReg.exec(path);
			if (result && result.length > 1){
				return result[1].toLowerCase();
			}
			return null;
		}

		Utils.getTransformRelativeToWindow=function(coordinateSpace,x,y){
			var stage=Laya.stage;
			var globalTransform=laya.utils.Utils.getGlobalPosAndScale(coordinateSpace);
			var canvasMatrix=stage._canvasTransform.clone();
			var canvasLeft=canvasMatrix.tx;
			var canvasTop=canvasMatrix.ty;
			canvasMatrix.rotate(-Math.PI / 180 *Laya.stage.canvasDegree);
			canvasMatrix.scale(Laya.stage.clientScaleX,Laya.stage.clientScaleY);
			var perpendicular=(Laya.stage.canvasDegree % 180 !=0);
			var tx=NaN,ty=NaN;
			if (perpendicular){
				tx=y+globalTransform.y;
				ty=x+globalTransform.x;
				tx *=canvasMatrix.d;
				ty *=canvasMatrix.a;
				if (Laya.stage.canvasDegree==90){
					tx=canvasLeft-tx;
					ty+=canvasTop;
				}
				else {
					tx+=canvasLeft;
					ty=canvasTop-ty;
				}
			}
			else {
				tx=x+globalTransform.x;
				ty=y+globalTransform.y;
				tx *=canvasMatrix.a;
				ty *=canvasMatrix.d;
				tx+=canvasLeft;
				ty+=canvasTop;
			}
			ty+=Laya.stage['_safariOffsetY'];
			var domScaleX=NaN,domScaleY=NaN;
			if (perpendicular){
				domScaleX=canvasMatrix.d *globalTransform.height;
				domScaleY=canvasMatrix.a *globalTransform.width;
				}else {
				domScaleX=canvasMatrix.a *globalTransform.width;
				domScaleY=canvasMatrix.d *globalTransform.height;
			}
			return {x:tx,y:ty,scaleX:domScaleX,scaleY:domScaleY};
		}

		Utils.fitDOMElementInArea=function(dom,coordinateSpace,x,y,width,height){
			if (!dom._fitLayaAirInitialized){
				dom._fitLayaAirInitialized=true;
				dom.style.transformOrigin=dom.style.webKittransformOrigin="left top";
				dom.style.position="absolute"
			};
			var transform=Utils.getTransformRelativeToWindow(coordinateSpace,x,y);
			dom.style.transform=dom.style.webkitTransform="scale("+transform.scaleX+","+transform.scaleY+") rotate("+(Laya.stage.canvasDegree)+"deg)";
			dom.style.width=width+'px';
			dom.style.height=height+'px';
			dom.style.left=transform.x+'px';
			dom.style.top=transform.y+'px';
		}

		Utils._gid=1;
		Utils._pi=180 / Math.PI;
		Utils._pi2=Math.PI / 180;
		Utils._extReg=/\.(\w+)\??/g;
		Utils.parseXMLFromString=function(value){
			var rst;
			value=value.replace(/>\s+</g,'><');
			rst=(new DOMParser()).parseFromString(value,'text/xml');
			if (rst.firstChild.textContent.indexOf("This page contains the following errors")>-1){
				throw new Error(rst.firstChild.firstChild.textContent);
			}
			return rst;
		}

		return Utils;
	})()


	/**
	*@private
	*/
	//class laya.utils.VectorGraphManager
	var VectorGraphManager=(function(){
		function VectorGraphManager(){
			this.useDic={};
			this.shapeDic={};
			this.shapeLineDic={};
			this._id=0;
			this._checkKey=false;
			this._freeIdArray=[];
			if (Render.isWebGL){
				CacheManger.regCacheByFunction(Utils$1.bind(this.startDispose,this),Utils$1.bind(this.getCacheList,this));
			}
		}

		__class(VectorGraphManager,'laya.utils.VectorGraphManager');
		var __proto=VectorGraphManager.prototype;
		/**
		*得到个空闲的ID
		*@return
		*/
		__proto.getId=function(){
			return this._id++;
		}

		/**
		*添加一个图形到列表中
		*@param id
		*@param shape
		*/
		__proto.addShape=function(id,shape){
			this.shapeDic[id]=shape;
			if (!this.useDic[id]){
				this.useDic[id]=true;
			}
		}

		/**
		*添加一个线图形到列表中
		*@param id
		*@param Line
		*/
		__proto.addLine=function(id,Line){
			this.shapeLineDic[id]=Line;
			if (!this.shapeLineDic[id]){
				this.shapeLineDic[id]=true;
			}
		}

		/**
		*检测一个对象是否在使用中
		*@param id
		*/
		__proto.getShape=function(id){
			if (this._checkKey){
				if (this.useDic[id] !=null){
					this.useDic[id]=true;
				}
			}
		}

		/**
		*删除一个图形对象
		*@param id
		*/
		__proto.deleteShape=function(id){
			if (this.shapeDic[id]){
				this.shapeDic[id]=null;
				delete this.shapeDic[id];
			}
			if (this.shapeLineDic[id]){
				this.shapeLineDic[id]=null;
				delete this.shapeLineDic[id];
			}
			if (this.useDic[id] !=null){
				delete this.useDic[id];
			}
		}

		/**
		*得到缓存列表
		*@return
		*/
		__proto.getCacheList=function(){
			var str;
			var list=[];
			for (str in this.shapeDic){
				list.push(this.shapeDic[str]);
			}
			for (str in this.shapeLineDic){
				list.push(this.shapeLineDic[str]);
			}
			return list;
		}

		/**
		*开始清理状态，准备销毁
		*/
		__proto.startDispose=function(key){
			var str;
			for (str in this.useDic){
				this.useDic[str]=false;
			}
			this._checkKey=true;
		}

		/**
		*确认销毁
		*/
		__proto.endDispose=function(){
			if (this._checkKey){
				var str;
				for (str in this.useDic){
					if (!this.useDic[str]){
						this.deleteShape(str);
					}
				}
				this._checkKey=false;
			}
		}

		VectorGraphManager.getInstance=function(){
			return VectorGraphManager.instance=VectorGraphManager.instance|| new VectorGraphManager();
		}

		VectorGraphManager.instance=null
		return VectorGraphManager;
	})()


	/**
	*@private
	*/
	//class laya.utils.WordText
	var WordText=(function(){
		function WordText(){
			this.id=NaN;
			this.save=[];
			this.toUpperCase=null;
			this.changed=false;
			this._text=null;
		}

		__class(WordText,'laya.utils.WordText');
		var __proto=WordText.prototype;
		__proto.setText=function(txt){
			this.changed=true;
			this._text=txt;
		}

		__proto.toString=function(){
			return this._text;
		}

		__proto.charCodeAt=function(i){
			return this._text ? this._text.charCodeAt(i):NaN;
		}

		__proto.charAt=function(i){
			return this._text ? this._text.charAt(i):null;
		}

		__getset(0,__proto,'length',function(){
			return this._text ? this._text.length :0;
		});

		return WordText;
	})()


	/**
	*<code>EmitterBase</code> 类是粒子发射器类
	*/
	//class laya.particle.emitter.EmitterBase
	var EmitterBase=(function(){
		function EmitterBase(){
			this._frameTime=0;
			this._emissionRate=60;
			this._emissionTime=0;
			this.minEmissionTime=1 / 60;
			this._particleTemplate=null;
		}

		__class(EmitterBase,'laya.particle.emitter.EmitterBase');
		var __proto=EmitterBase.prototype;
		/**
		*开始发射粒子
		*@param duration 发射持续的时间(秒)
		*/
		__proto.start=function(duration){
			(duration===void 0)&& (duration=Number.MAX_VALUE);
			if (this._emissionRate !=0)
				this._emissionTime=duration;
		}

		/**
		*停止发射粒子
		*@param clearParticles 是否清理当前的粒子
		*/
		__proto.stop=function(){
			this._emissionTime=0;
		}

		/**
		*清理当前的活跃粒子
		*@param clearTexture 是否清理贴图数据,若清除贴图数据将无法再播放
		*/
		__proto.clear=function(){
			this._emissionTime=0;
		}

		/**
		*发射一个粒子
		*
		*/
		__proto.emit=function(){}
		/**
		*时钟前进
		*@param passedTime 前进时间
		*
		*/
		__proto.advanceTime=function(passedTime){
			(passedTime===void 0)&& (passedTime=1);
			this._emissionTime-=passedTime;
			if (this._emissionTime < 0)return;
			this._frameTime+=passedTime;
			if (this._frameTime < this.minEmissionTime)return;
			while (this._frameTime > this.minEmissionTime){
				this._frameTime-=this.minEmissionTime;
				this.emit();
			}
		}

		/**
		*设置粒子粒子模板
		*@param particleTemplate 粒子模板
		*
		*/
		__getset(0,__proto,'particleTemplate',null,function(particleTemplate){
			this._particleTemplate=particleTemplate;
		});

		/**
		*设置粒子发射速率
		*@param emissionRate 粒子发射速率 (个/秒)
		*/
		/**
		*获取粒子发射速率
		*@return 发射速率 粒子发射速率 (个/秒)
		*/
		__getset(0,__proto,'emissionRate',function(){
			return this._emissionRate;
			},function(_emissionRate){
			if (_emissionRate <=0)return;
			this._emissionRate=_emissionRate;
			(_emissionRate > 0)&& (this.minEmissionTime=1 / _emissionRate);
		});

		return EmitterBase;
	})()


	/**
	*
	*<code>ParticleTemplateBase</code> 类是粒子模板基类
	*
	*/
	//class laya.particle.ParticleTemplateBase
	var ParticleTemplateBase=(function(){
		function ParticleTemplateBase(){
			this.settings=null;
			this.texture=null;
		}

		__class(ParticleTemplateBase,'laya.particle.ParticleTemplateBase');
		var __proto=ParticleTemplateBase.prototype;
		/**
		*添加一个粒子
		*@param position 粒子位置
		*@param velocity 粒子速度
		*
		*/
		__proto.addParticleArray=function(position,velocity){}
		return ParticleTemplateBase;
	})()


	/**
	*@private
	*@author ...
	*/
	//class laya.ani.AnimationContent
	var AnimationContent=(function(){
		function AnimationContent(){
			this.nodes=null;
			this.name=null;
			this.playTime=NaN;
			this.bone3DMap=null;
			this.totalKeyframeDatasLength=0;
		}

		__class(AnimationContent,'laya.ani.AnimationContent');
		return AnimationContent;
	})()


	/**
	*@private
	*@author ...
	*/
	//class laya.ani.AnimationNodeContent
	var AnimationNodeContent=(function(){
		function AnimationNodeContent(){
			this.name=null;
			this.parentIndex=0;
			this.parent=null;
			this.keyframeWidth=0;
			this.lerpType=0;
			this.interpolationMethod=null;
			this.childs=null;
			this.keyFrame=null;
			this.playTime=NaN;
			this.extenData=null;
			this.dataOffset=0;
		}

		__class(AnimationNodeContent,'laya.ani.AnimationNodeContent');
		return AnimationNodeContent;
	})()


	/**
	*@private
	*/
	//class laya.ani.AnimationParser01
	var AnimationParser01$1=(function(){
		function AnimationParser01(){};
		__class(AnimationParser01,'laya.ani.AnimationParser01',null,'AnimationParser01$1');
		AnimationParser01.parse=function(templet,reader){
			var data=reader.__getBuffer();
			var i=0,j=0,k=0,n=0,l=0,m=0,o=0;
			var aniClassName=reader.readUTFString();
			templet._aniClassName=aniClassName;
			var strList=reader.readUTFString().split("\n");
			var aniCount=reader.getUint8();
			var publicDataPos=reader.getUint32();
			var publicExtDataPos=reader.getUint32();
			var publicData;
			if (publicDataPos > 0)
				publicData=data.slice(publicDataPos,publicExtDataPos);
			var publicRead=new Byte(publicData);
			if (publicExtDataPos > 0)
				templet._publicExtData=data.slice(publicExtDataPos,data.byteLength);
			templet._useParent=!!reader.getUint8();
			templet._anis.length=aniCount;
			for (i=0;i < aniCount;i++){
				var ani=templet._anis[i]=new AnimationContent();
				{};
				ani.nodes=new Array;
				var name=ani.name=strList[reader.getUint16()];
				templet._aniMap[name]=i;
				ani.bone3DMap={};
				ani.playTime=reader.getFloat32();
				var boneCount=ani.nodes.length=reader.getUint8();
				ani.totalKeyframeDatasLength=0;
				for (j=0;j < boneCount;j++){
					var node=ani.nodes[j]=new AnimationNodeContent();
					{};
					node.childs=[];
					var nameIndex=reader.getInt16();
					if (nameIndex >=0){
						node.name=strList[nameIndex];
						ani.bone3DMap[node.name]=j;
					}
					node.keyFrame=new Array;
					node.parentIndex=reader.getInt16();
					node.parentIndex==-1 ? node.parent=null :node.parent=ani.nodes[node.parentIndex]
					node.lerpType=reader.getUint8();
					var keyframeParamsOffset=reader.getUint32();
					publicRead.pos=keyframeParamsOffset;
					var keyframeDataCount=node.keyframeWidth=publicRead.getUint16();
					ani.totalKeyframeDatasLength+=keyframeDataCount;
					if (node.lerpType===0 || node.lerpType===1){
						node.interpolationMethod=[];
						node.interpolationMethod.length=keyframeDataCount;
						for (k=0;k < keyframeDataCount;k++)
						node.interpolationMethod[k]=AnimationTemplet.interpolation[publicRead.getUint8()];
					}
					if (node.parent !=null)
						node.parent.childs.push(node);
					var privateDataLen=reader.getUint16();
					if (privateDataLen > 0){
						node.extenData=data.slice(reader.pos,reader.pos+privateDataLen);
						reader.pos+=privateDataLen;
					};
					var keyframeCount=reader.getUint16();
					node.keyFrame.length=keyframeCount;
					var startTime=0;
					var keyFrame;
					for (k=0,n=keyframeCount;k < n;k++){
						keyFrame=node.keyFrame[k]=new KeyFramesContent();
						{};
						keyFrame.duration=reader.getFloat32();
						keyFrame.startTime=startTime;
						if (node.lerpType===2){
							keyFrame.interpolationData=[];
							var interDataLength=reader.getUint8();
							var lerpType=0;
							lerpType=reader.getFloat32();
							switch (lerpType){
								case 254:
									keyFrame.interpolationData.length=keyframeDataCount;
									for (o=0;o < keyframeDataCount;o++)
									keyFrame.interpolationData[o]=0;
									break ;
								case 255:
									keyFrame.interpolationData.length=keyframeDataCount;
									for (o=0;o < keyframeDataCount;o++)
									keyFrame.interpolationData[o]=5;
									break ;
								default :
									keyFrame.interpolationData.push(lerpType);
									for (m=1;m < interDataLength;m++){
										keyFrame.interpolationData.push(reader.getFloat32());
									}
								}
						}
						keyFrame.data=new Float32Array(keyframeDataCount);
						keyFrame.dData=new Float32Array(keyframeDataCount);
						keyFrame.nextData=new Float32Array(keyframeDataCount);
						for (l=0;l < keyframeDataCount;l++){
							keyFrame.data[l]=reader.getFloat32();
							if (keyFrame.data[l] >-0.00000001 && keyFrame.data[l] < 0.00000001)keyFrame.data[l]=0;
						}
						startTime+=keyFrame.duration;
					}
					keyFrame.startTime=ani.playTime;
					node.playTime=ani.playTime;
					templet._calculateKeyFrame(node,keyframeCount,keyframeDataCount);
				}
			}
		}

		return AnimationParser01;
	})()


	/**
	*@private
	*/
	//class laya.ani.AnimationParser02
	var AnimationParser02=(function(){
		function AnimationParser02(){};
		__class(AnimationParser02,'laya.ani.AnimationParser02');
		AnimationParser02.READ_DATA=function(){
			AnimationParser02._DATA.offset=AnimationParser02._reader.getUint32();
			AnimationParser02._DATA.size=AnimationParser02._reader.getUint32();
		}

		AnimationParser02.READ_BLOCK=function(){
			var count=AnimationParser02._BLOCK.count=AnimationParser02._reader.getUint16();
			var blockStarts=AnimationParser02._BLOCK.blockStarts=[];
			var blockLengths=AnimationParser02._BLOCK.blockLengths=[];
			for (var i=0;i < count;i++){
				blockStarts.push(AnimationParser02._reader.getUint32());
				blockLengths.push(AnimationParser02._reader.getUint32());
			}
		}

		AnimationParser02.READ_STRINGS=function(){
			var offset=AnimationParser02._reader.getUint32();
			var count=AnimationParser02._reader.getUint16();
			var prePos=AnimationParser02._reader.pos;
			AnimationParser02._reader.pos=offset+AnimationParser02._DATA.offset;
			for (var i=0;i < count;i++)
			AnimationParser02._strings[i]=AnimationParser02._reader.readUTFString();
			AnimationParser02._reader.pos=prePos;
		}

		AnimationParser02.parse=function(templet,reader){
			AnimationParser02._templet=templet;
			AnimationParser02._reader=reader;
			var arrayBuffer=reader.__getBuffer();
			AnimationParser02.READ_DATA();
			AnimationParser02.READ_BLOCK();
			AnimationParser02.READ_STRINGS();
			for (var i=0,n=AnimationParser02._BLOCK.count;i < n;i++){
				var index=reader.getUint16();
				var blockName=AnimationParser02._strings[index];
				var fn=AnimationParser02["READ_"+blockName];
				if (fn==null)
					throw new Error("model file err,no this function:"+index+" "+blockName);
				else
				fn.call();
			}
		}

		AnimationParser02.READ_ANIMATIONS=function(){
			var reader=AnimationParser02._reader;
			var arrayBuffer=reader.__getBuffer();
			var i=0,j=0,k=0,n=0,l=0;
			var keyframeWidth=reader.getUint16();
			var interpolationMethod=[];
			interpolationMethod.length=keyframeWidth;
			for (i=0;i < keyframeWidth;i++)
			interpolationMethod[i]=AnimationTemplet.interpolation[reader.getByte()];
			var aniCount=reader.getUint8();
			AnimationParser02._templet._anis.length=aniCount;
			for (i=0;i < aniCount;i++){
				var ani=AnimationParser02._templet._anis[i]=
				{};
				ani.nodes=new Array;
				var aniName=ani.name=AnimationParser02._strings[reader.getUint16()];
				AnimationParser02._templet._aniMap[aniName]=i;
				ani.bone3DMap={};
				ani.playTime=reader.getFloat32();
				var boneCount=ani.nodes.length=reader.getInt16();
				ani.totalKeyframeDatasLength=0;
				for (j=0;j < boneCount;j++){
					var node=ani.nodes[j]=
					{};
					node.keyframeWidth=keyframeWidth;
					node.childs=[];
					var nameIndex=reader.getUint16();
					if (nameIndex >=0){
						node.name=AnimationParser02._strings[nameIndex];
						ani.bone3DMap[node.name]=j;
					}
					node.keyFrame=new Array;
					node.parentIndex=reader.getInt16();
					node.parentIndex==-1 ? node.parent=null :node.parent=ani.nodes[node.parentIndex]
					ani.totalKeyframeDatasLength+=keyframeWidth;
					node.interpolationMethod=interpolationMethod;
					if (node.parent !=null)
						node.parent.childs.push(node);
					var keyframeCount=reader.getUint16();
					node.keyFrame.length=keyframeCount;
					var keyFrame=null,lastKeyFrame=null;
					for (k=0,n=keyframeCount;k < n;k++){
						keyFrame=node.keyFrame[k]=
						{};
						keyFrame.startTime=reader.getFloat32();
						(lastKeyFrame)&& (lastKeyFrame.duration=keyFrame.startTime-lastKeyFrame.startTime);
						keyFrame.dData=new Float32Array(keyframeWidth);
						keyFrame.nextData=new Float32Array(keyframeWidth);
						var offset=AnimationParser02._DATA.offset;
						var keyframeDataOffset=reader.getUint32();
						var keyframeDataLength=keyframeWidth *4;
						var keyframeArrayBuffer=arrayBuffer.slice(offset+keyframeDataOffset,offset+keyframeDataOffset+keyframeDataLength);
						keyFrame.data=new Float32Array(keyframeArrayBuffer);
						lastKeyFrame=keyFrame;
					}
					keyFrame.duration=0;
					node.playTime=ani.playTime;
					AnimationParser02._templet._calculateKeyFrame(node,keyframeCount,keyframeWidth);
				}
			}
		}

		AnimationParser02._templet=null
		AnimationParser02._reader=null
		AnimationParser02._strings=[];
		__static(AnimationParser02,
		['_BLOCK',function(){return this._BLOCK={count:0};},'_DATA',function(){return this._DATA={offset:0,size:0};}
		]);
		return AnimationParser02;
	})()


	/**
	*@private
	*/
	//class laya.ani.AnimationState
	var AnimationState=(function(){
		function AnimationState(){}
		__class(AnimationState,'laya.ani.AnimationState');
		AnimationState.stopped=0;
		AnimationState.paused=1;
		AnimationState.playing=2;
		return AnimationState;
	})()


	/**
	*@private
	*/
	//class laya.ani.bone.Bone
	var Bone=(function(){
		function Bone(){
			this.name=null;
			this.root=null;
			this.parentBone=null;
			this.length=10;
			this.transform=null;
			this.inheritScale=true;
			this.inheritRotation=true;
			this.rotation=NaN;
			this.resultRotation=NaN;
			this.d=-1;
			this._tempMatrix=null;
			this._sprite=null;
			this.resultTransform=new Transform();
			this.resultMatrix=new Matrix();
			this._children=[];
		}

		__class(Bone,'laya.ani.bone.Bone');
		var __proto=Bone.prototype;
		__proto.setTempMatrix=function(matrix){
			this._tempMatrix=matrix;
			var i=0,n=0;
			var tBone;
			for (i=0,n=this._children.length;i < n;i++){
				tBone=this._children[i];
				tBone.setTempMatrix(this._tempMatrix);
			}
		}

		__proto.update=function(pMatrix){
			this.rotation=this.transform.skX;
			var tResultMatrix;
			if (pMatrix){
				tResultMatrix=this.resultTransform.getMatrix();
				Matrix.mul(tResultMatrix,pMatrix,this.resultMatrix);
				this.resultRotation=this.rotation;
			}
			else {
				this.resultRotation=this.rotation+this.parentBone.resultRotation;
				if (this.parentBone){
					if (this.inheritRotation && this.inheritScale){
						tResultMatrix=this.resultTransform.getMatrix();
						Matrix.mul(tResultMatrix,this.parentBone.resultMatrix,this.resultMatrix);
					}
					else {
						var temp=0;
						var parent=this.parentBone;
						var tAngle=NaN;
						var cos=NaN;
						var sin=NaN;
						var tParentMatrix=this.parentBone.resultMatrix;
						tResultMatrix=this.resultTransform.getMatrix();
						var worldX=tParentMatrix.a *tResultMatrix.tx+tParentMatrix.c *tResultMatrix.ty+tParentMatrix.tx;
						var worldY=tParentMatrix.b *tResultMatrix.tx+tParentMatrix.d *tResultMatrix.ty+tParentMatrix.ty;
						var tTestMatrix=new Matrix();
						if (this.inheritRotation){
							tAngle=Math.atan2(parent.resultMatrix.b,parent.resultMatrix.a);
							cos=Math.cos(tAngle),sin=Math.sin(tAngle);
							tTestMatrix.setTo(cos,sin,-sin,cos,0,0);
							Matrix.mul(this._tempMatrix,tTestMatrix,Matrix.TEMP);
							Matrix.TEMP.copyTo(tTestMatrix);
							tResultMatrix=this.resultTransform.getMatrix();
							Matrix.mul(tResultMatrix,tTestMatrix,this.resultMatrix);
							if (this.resultTransform.scX *this.resultTransform.scY < 0){
								this.resultMatrix.rotate(Math.PI*0.5);
							}
							this.resultMatrix.tx=worldX;
							this.resultMatrix.ty=worldY;
						}
						else if (this.inheritScale){
							tResultMatrix=this.resultTransform.getMatrix();
							Matrix.TEMP.identity();
							Matrix.TEMP.d=this.d;
							Matrix.mul(tResultMatrix,Matrix.TEMP,this.resultMatrix);
							this.resultMatrix.tx=worldX;
							this.resultMatrix.ty=worldY;
						}
						else {
							tResultMatrix=this.resultTransform.getMatrix();
							Matrix.TEMP.identity();
							Matrix.TEMP.d=this.d;
							Matrix.mul(tResultMatrix,Matrix.TEMP,this.resultMatrix);
							this.resultMatrix.tx=worldX;
							this.resultMatrix.ty=worldY;
						}
					}
				}
				else {
					tResultMatrix=this.resultTransform.getMatrix();
					tResultMatrix.copyTo(this.resultMatrix);
				}
			};
			var i=0,n=0;
			var tBone;
			for (i=0,n=this._children.length;i < n;i++){
				tBone=this._children[i];
				tBone.update();
			}
		}

		__proto.updateChild=function(){
			var i=0,n=0;
			var tBone;
			for (i=0,n=this._children.length;i < n;i++){
				tBone=this._children[i];
				tBone.update();
			}
		}

		__proto.setRotation=function(rd){
			if (this._sprite){
				this._sprite.rotation=rd *180 / Math.PI;
			}
		}

		__proto.updateDraw=function(x,y){
			if (!Bone.ShowBones || Bone.ShowBones[this.name]){
				if (this._sprite){
					this._sprite.x=x+this.resultMatrix.tx;
					this._sprite.y=y+this.resultMatrix.ty;
				}
				else {
					this._sprite=new Sprite();
					this._sprite.graphics.drawCircle(0,0,5,"#ff0000");
					this._sprite.graphics.drawLine(0,0,this.length,0,"#00ff00");
					this._sprite.graphics.fillText(this.name,0,0,"20px Arial","#00ff00","center");
					Laya.stage.addChild(this._sprite);
					this._sprite.x=x+this.resultMatrix.tx;
					this._sprite.y=y+this.resultMatrix.ty;
				}
			};
			var i=0,n=0;
			var tBone;
			for (i=0,n=this._children.length;i < n;i++){
				tBone=this._children[i];
				tBone.updateDraw(x,y);
			}
		}

		__proto.addChild=function(bone){
			this._children.push(bone);
			bone.parentBone=this;
		}

		__proto.findBone=function(boneName){
			if (this.name==boneName){
				return this;
			}
			else {
				var i=0,n=0;
				var tBone;
				var tResult;
				for (i=0,n=this._children.length;i < n;i++){
					tBone=this._children[i];
					tResult=tBone.findBone(boneName);
					if (tResult){
						return tResult;
					}
				}
			}
			return null;
		}

		__proto.localToWorld=function(local){
			var localX=local[0];
			var localY=local[1];
			local[0]=localX *this.resultMatrix.a+localY *this.resultMatrix.c+this.resultMatrix.tx;
			local[1]=localX *this.resultMatrix.b+localY *this.resultMatrix.d+this.resultMatrix.ty;
		}

		Bone.ShowBones={};
		return Bone;
	})()


	/**
	*@private
	*/
	//class laya.ani.bone.BoneSlot
	var BoneSlot=(function(){
		function BoneSlot(){
			this.name=null;
			this.parent=null;
			this.attachmentName=null;
			this.srcDisplayIndex=-1;
			this.type="src";
			this.templet=null;
			this.currSlotData=null;
			this.currTexture=null;
			this.currDisplayData=null;
			this.displayIndex=-1;
			this._diyTexture=null;
			this._parentMatrix=null;
			this._resultMatrix=null;
			this._replaceDic={};
			this._curDiyUV=null;
			this._curDiyVS=null;
			this._skinSprite=null;
			this.deformData=null;
			this.appendSkeleton=null;
			this.appendMatrix=null;
			this._mVerticleArr=null;
		}

		__class(BoneSlot,'laya.ani.bone.BoneSlot');
		var __proto=BoneSlot.prototype;
		/**
		*设置要显示的插槽数据
		*@param slotData
		*@param disIndex
		*@param freshIndex 是否重置纹理
		*/
		__proto.showSlotData=function(slotData,freshIndex){
			(freshIndex===void 0)&& (freshIndex=true);
			this.currSlotData=slotData;
			if(freshIndex)
				this.displayIndex=this.srcDisplayIndex;
			this.currDisplayData=null;
			this.currTexture=null;
		}

		/**
		*通过名字显示指定对象
		*@param name
		*/
		__proto.showDisplayByName=function(name){
			if (this.currSlotData){
				this.showDisplayByIndex(this.currSlotData.getDisplayByName(name));
			}
		}

		/**
		*替换贴图名
		*@param tarName 要替换的贴图名
		*@param newName 替换后的贴图名
		*/
		__proto.replaceDisplayByName=function(tarName,newName){
			if (!this.currSlotData)return;
			var preIndex=0;
			preIndex=this.currSlotData.getDisplayByName(tarName);
			var newIndex=0;
			newIndex=this.currSlotData.getDisplayByName(newName);
			this.replaceDisplayByIndex(preIndex,newIndex);
		}

		/**
		*替换贴图索引
		*@param tarIndex 要替换的索引
		*@param newIndex 替换后的索引
		*/
		__proto.replaceDisplayByIndex=function(tarIndex,newIndex){
			if (!this.currSlotData)return;
			this._replaceDic[tarIndex]=newIndex;
			if (this.displayIndex==tarIndex){
				this.showDisplayByIndex(tarIndex);
			}
		}

		/**
		*指定显示对象
		*@param index
		*/
		__proto.showDisplayByIndex=function(index){
			if (this._replaceDic[index])index=this._replaceDic[index];
			if (this.currSlotData && index >-1 && index < this.currSlotData.displayArr.length){
				this.displayIndex=index;
				this.currDisplayData=this.currSlotData.displayArr[index];
				if (this.currDisplayData){
					var tName=this.currDisplayData.name;
					this.currTexture=this.templet.getTexture(tName);
					if (this.currTexture && Render.isWebGL && this.currDisplayData.type==0 && this.currDisplayData.uvs){
						this.currTexture=this.currDisplayData.createTexture(this.currTexture);
					}
				}
				}else {
				this.displayIndex=-1;
				this.currDisplayData=null;
				this.currTexture=null;
			}
		}

		/**
		*替换皮肤
		*@param _texture
		*/
		__proto.replaceSkin=function(_texture){
			this._diyTexture=_texture;
			if (this._curDiyUV)this._curDiyUV.length=0;
			if (this.currDisplayData&&this._diyTexture==this.currDisplayData.texture){
				this._diyTexture=null;
			}
		}

		/**
		*保存父矩阵的索引
		*@param parentMatrix
		*/
		__proto.setParentMatrix=function(parentMatrix){
			this._parentMatrix=parentMatrix;
		}

		__proto.drawAppend=function(graphics){
			if (!this.appendSkeleton)return;
			graphics.save();
			graphics.transform(this._parentMatrix);
			if (this.appendSkeleton){
				graphics.translate(this.appendSkeleton.x,this.appendSkeleton.y);
				if(this.appendSkeleton.transform)
					graphics.transform(this.appendSkeleton.transform);
				this.appendSkeleton.drawToGraphic(graphics);
			}
			graphics.restore();
		}

		/**
		*把纹理画到Graphics上
		*@param graphics
		*@param noUseSave
		*/
		__proto.draw=function(graphics,boneMatrixArray,noUseSave,alpha){
			(noUseSave===void 0)&& (noUseSave=false);
			(alpha===void 0)&& (alpha=1);
			if(this.appendSkeleton){
				this.drawAppend(graphics);
				return;
			}
			if ((this._diyTexture==null && this.currTexture==null)|| this.currDisplayData==null){
				if (!(this.currDisplayData && this.currDisplayData.type==3)){
					return;
				}
			};
			var tTexture=this.currTexture;
			if (this._diyTexture)tTexture=this._diyTexture;
			var tSkinSprite;
			switch (this.currDisplayData.type){
				case 0:
					if (graphics){
						var tCurrentMatrix=this.getDisplayMatrix();
						if (this._parentMatrix){
							var tRotateKey=false;
							if (tCurrentMatrix){
								Matrix.mul(tCurrentMatrix,this._parentMatrix,Matrix.TEMP);
								var tResultMatrix;
								if (noUseSave){
									if (this._resultMatrix==null)this._resultMatrix=new Matrix();
									tResultMatrix=this._resultMatrix;
									}else {
									tResultMatrix=new Matrix();
								}
								if ((!Render.isWebGL && this.currDisplayData.uvs)|| (Render.isWebGL && this._diyTexture && this.currDisplayData.uvs)){
									var tTestMatrix=BoneSlot._tempMatrix;
									tTestMatrix.identity();
									if (this.currDisplayData.uvs[1] > this.currDisplayData.uvs[5]){
										tTestMatrix.d=-1;
									}
									if (this.currDisplayData.uvs[0] > this.currDisplayData.uvs[4]
										&& this.currDisplayData.uvs[1] > this.currDisplayData.uvs[5]){
										tRotateKey=true;
										tTestMatrix.rotate(-Math.PI/2);
									}
									Matrix.mul(tTestMatrix,Matrix.TEMP,tResultMatrix);
									}else {
									Matrix.TEMP.copyTo(tResultMatrix);
								}
								if (tRotateKey){
									graphics.drawTexture(tTexture,-this.currDisplayData.height / 2,-this.currDisplayData.width / 2,this.currDisplayData.height,this.currDisplayData.width,tResultMatrix);
									}else {
									graphics.drawTexture(tTexture,-this.currDisplayData.width / 2,-this.currDisplayData.height / 2,this.currDisplayData.width,this.currDisplayData.height,tResultMatrix);
								}
							}
						}
					}
					break ;
				case 1:
					if (noUseSave){
						if (this._skinSprite==null){
							this._skinSprite=BoneSlot.createSkinMesh();
						}
						tSkinSprite=this._skinSprite;
						}else {
						tSkinSprite=BoneSlot.createSkinMesh();
					}
					if (tSkinSprite==null){
						return;
					};
					var tIBArray;
					var tRed=1;
					var tGreed=1;
					var tBlue=1;
					var tAlpha=1;
					if (this.currDisplayData.bones==null){
						var tVertices=this.currDisplayData.weights;
						if (this.deformData){
							tVertices=this.deformData;
						};
						var tUVs;
						if (this._diyTexture){
							if (!this._curDiyUV){
								this._curDiyUV=[];
							}
							if (this._curDiyUV.length==0){
								this._curDiyUV=UVTools.getRelativeUV(this.currTexture.uv,this.currDisplayData.uvs,this._curDiyUV);
								this._curDiyUV=UVTools.getAbsoluteUV(this._diyTexture.uv,this._curDiyUV,this._curDiyUV);
							}
							tUVs=this._curDiyUV;
							}else{
							tUVs=this.currDisplayData.uvs;
						}
						this._mVerticleArr=tVertices;
						var tTriangleNum=this.currDisplayData.triangles.length / 3;
						tIBArray=this.currDisplayData.triangles;
						tSkinSprite.init2(tTexture,null ,tIBArray,this._mVerticleArr,tUVs);
						var tCurrentMatrix2=this.getDisplayMatrix();
						if (this._parentMatrix){
							if (tCurrentMatrix2){
								Matrix.mul(tCurrentMatrix2,this._parentMatrix,Matrix.TEMP);
								var tResultMatrix2;
								if (noUseSave){
									if (this._resultMatrix==null)this._resultMatrix=new Matrix();
									tResultMatrix2=this._resultMatrix;
									}else {
									tResultMatrix2=new Matrix();
								}
								Matrix.TEMP.copyTo(tResultMatrix2);
								tSkinSprite.transform=tResultMatrix2;
							}
						}
						}else {
						this.skinMesh(boneMatrixArray,tSkinSprite,alpha);
					}
					graphics.drawSkin(tSkinSprite);
					break ;
				case 2:
					if (noUseSave){
						if (this._skinSprite==null){
							this._skinSprite=BoneSlot.createSkinMesh();
						}
						tSkinSprite=this._skinSprite;
						}else {
						tSkinSprite=BoneSlot.createSkinMesh();
					}
					if (tSkinSprite==null){
						return;
					}
					this.skinMesh(boneMatrixArray,tSkinSprite,alpha);
					graphics.drawSkin(tSkinSprite);
					break ;
				case 3:
					break ;
				}
		}

		/**
		*显示蒙皮动画
		*@param boneMatrixArray 当前帧的骨骼矩阵
		*/
		__proto.skinMesh=function(boneMatrixArray,skinSprite,alpha){
			var tTexture=this.currTexture;
			var tBones=this.currDisplayData.bones;
			var tUvs;
			if (this._diyTexture){
				tTexture=this._diyTexture;
				if (!this._curDiyUV){
					this._curDiyUV=[];
				}
				if (this._curDiyUV.length==0){
					this._curDiyUV=UVTools.getRelativeUV(this.currTexture.uv,this.currDisplayData.uvs,this._curDiyUV);
					this._curDiyUV=UVTools.getAbsoluteUV(this._diyTexture.uv,this._curDiyUV,this._curDiyUV);
				}
				tUvs=this._curDiyUV;
				}else{
				tUvs=this.currDisplayData.uvs;
			};
			var tWeights=this.currDisplayData.weights;
			var tTriangles=this.currDisplayData.triangles;
			var tIBArray;
			var tRx=0;
			var tRy=0;
			var nn=0;
			var tMatrix;
			var tX=NaN;
			var tY=NaN;
			var tB=0;
			var tWeight=0;
			var tVertices=[];
			var i=0,j=0,n=0;
			var tRed=1;
			var tGreed=1;
			var tBlue=1;
			var tAlpha=alpha;
			if (this.deformData && this.deformData.length > 0){
				var f=0;
				for (i=0,n=tBones.length;i < n;){
					nn=tBones[i++]+i;
					tRx=0,tRy=0;
					for (;i < nn;i++){
						tMatrix=boneMatrixArray[tBones[i]]
						tX=tWeights[tB]+this.deformData[f++];
						tY=tWeights[tB+1]+this.deformData[f++];
						tWeight=tWeights[tB+2];
						tRx+=(tX *tMatrix.a+tY *tMatrix.c+tMatrix.tx)*tWeight;
						tRy+=(tX *tMatrix.b+tY *tMatrix.d+tMatrix.ty)*tWeight;
						tB+=3;
					}
					tVertices.push(tRx,tRy);
				}
				}else {
				for (i=0,n=tBones.length;i < n;){
					nn=tBones[i++]+i;
					tRx=0,tRy=0;
					for (;i < nn;i++){
						tMatrix=boneMatrixArray[tBones[i]]
						tX=tWeights[tB];
						tY=tWeights[tB+1];
						tWeight=tWeights[tB+2];
						tRx+=(tX *tMatrix.a+tY *tMatrix.c+tMatrix.tx)*tWeight;
						tRy+=(tX *tMatrix.b+tY *tMatrix.d+tMatrix.ty)*tWeight;
						tB+=3;
					}
					tVertices.push(tRx,tRy);
				}
			}
			this._mVerticleArr=tVertices;
			tIBArray=tTriangles;
			skinSprite.init2(tTexture,null,tIBArray,this._mVerticleArr,tUvs);
		}

		/**
		*画骨骼的起始点，方便调试
		*@param graphics
		*/
		__proto.drawBonePoint=function(graphics){
			if (graphics && this._parentMatrix){
				graphics.drawCircle(this._parentMatrix.tx,this._parentMatrix.ty,5,"#ff0000");
			}
		}

		/**
		*得到显示对象的矩阵
		*@return
		*/
		__proto.getDisplayMatrix=function(){
			if (this.currDisplayData){
				return this.currDisplayData.transform.getMatrix();
			}
			return null;
		}

		/**
		*得到插糟的矩阵
		*@return
		*/
		__proto.getMatrix=function(){
			return this._resultMatrix;
		}

		/**
		*用原始数据拷贝出一个
		*@return
		*/
		__proto.copy=function(){
			var tBoneSlot=new BoneSlot();
			tBoneSlot.type="copy";
			tBoneSlot.name=this.name;
			tBoneSlot.attachmentName=this.attachmentName;
			tBoneSlot.srcDisplayIndex=this.srcDisplayIndex;
			tBoneSlot.parent=this.parent;
			tBoneSlot.displayIndex=this.displayIndex;
			tBoneSlot.templet=this.templet;
			tBoneSlot.currSlotData=this.currSlotData;
			tBoneSlot.currTexture=this.currTexture;
			tBoneSlot.currDisplayData=this.currDisplayData;
			return tBoneSlot;
		}

		BoneSlot.createSkinMesh=function(){
			if (Render.isWebGL || Render.isConchApp){
				return RunDriver.skinAniSprite();
				}else{
				if (!Render.isWebGL){
					if (Skeleton.useSimpleMeshInCanvas){
						return new SimpleSkinMeshCanvas();
						}else{
						return new SkinMeshCanvas();
					}
				}
			}
			return null;
		}

		__static(BoneSlot,
		['_tempMatrix',function(){return this._tempMatrix=new Matrix();}
		]);
		return BoneSlot;
	})()


	/**
	*@private
	*canvas mesh渲染器
	*/
	//class laya.ani.bone.canvasmesh.CanvasMeshRender
	var CanvasMeshRender=(function(){
		function CanvasMeshRender(){
			this.mesh=null;
			this.transform=null;
			this.context=null;
			this.mode=0;
		}

		__class(CanvasMeshRender,'laya.ani.bone.canvasmesh.CanvasMeshRender');
		var __proto=CanvasMeshRender.prototype;
		/**
		*将mesh数据渲染到context上面
		*@param context
		*
		*/
		__proto.renderToContext=function(context){
			this.context=context.ctx||context;
			if (this.mesh){
				if (this.mode==0){
					this._renderWithIndexes(this.mesh);
					}else{
					this._renderNoIndexes(this.mesh);
				}
			}
		}

		/**
		*无顶点索引的模式
		*@param mesh
		*
		*/
		__proto._renderNoIndexes=function(mesh){
			var i=0,len=mesh.vertices.length / 2;
			var index=0;
			for (i=0;i < len-2;i++){
				index=i *2;
				this._renderDrawTriangle(mesh,index,(index+2),(index+4));
			}
		}

		/**
		*使用顶点索引模式绘制
		*@param mesh
		*
		*/
		__proto._renderWithIndexes=function(mesh){
			var indexes=mesh.indexes;
			var i=0,len=indexes.length;
			for (i=0;i < len;i+=3){
				var index0=indexes[i] *2;
				var index1=indexes[i+1] *2;
				var index2=indexes[i+2] *2;
				this._renderDrawTriangle(mesh,index0,index1,index2);
			}
		}

		/**
		*绘制三角形
		*@param mesh mesh
		*@param index0 顶点0
		*@param index1 顶点1
		*@param index2 顶点2
		*
		*/
		__proto._renderDrawTriangle=function(mesh,index0,index1,index2){
			var context=this.context;
			var uvs=mesh.uvs;
			var vertices=mesh.vertices;
			var texture=mesh.texture;
			var source=texture.bitmap;
			var textureSource=source.source;
			var textureWidth=texture.width;
			var textureHeight=texture.height;
			var sourceWidth=source.width;
			var sourceHeight=source.height;
			var u0=NaN;
			var u1=NaN;
			var u2=NaN;
			var v0=NaN;
			var v1=NaN;
			var v2=NaN;
			if (mesh.useUvTransform){
				var ut=mesh.uvTransform;
				u0=((uvs[index0] *ut.a)+(uvs[index0+1] *ut.c)+ut.tx)*sourceWidth;
				u1=((uvs[index1] *ut.a)+(uvs[index1+1] *ut.c)+ut.tx)*sourceWidth;
				u2=((uvs[index2] *ut.a)+(uvs[index2+1] *ut.c)+ut.tx)*sourceWidth;
				v0=((uvs[index0] *ut.b)+(uvs[index0+1] *ut.d)+ut.ty)*sourceHeight;
				v1=((uvs[index1] *ut.b)+(uvs[index1+1] *ut.d)+ut.ty)*sourceHeight;
				v2=((uvs[index2] *ut.b)+(uvs[index2+1] *ut.d)+ut.ty)*sourceHeight;
			}
			else {
				u0=uvs[index0] *sourceWidth;
				u1=uvs[index1] *sourceWidth;
				u2=uvs[index2] *sourceWidth;
				v0=uvs[index0+1] *sourceHeight;
				v1=uvs[index1+1] *sourceHeight;
				v2=uvs[index2+1] *sourceHeight;
			};
			var x0=vertices[index0];
			var x1=vertices[index1];
			var x2=vertices[index2];
			var y0=vertices[index0+1];
			var y1=vertices[index1+1];
			var y2=vertices[index2+1];
			if (mesh.canvasPadding > 0){
				var paddingX=mesh.canvasPadding;
				var paddingY=mesh.canvasPadding;
				var centerX=(x0+x1+x2)/ 3;
				var centerY=(y0+y1+y2)/ 3;
				var normX=x0-centerX;
				var normY=y0-centerY;
				var dist=Math.sqrt((normX *normX)+(normY *normY));
				x0=centerX+((normX / dist)*(dist+paddingX));
				y0=centerY+((normY / dist)*(dist+paddingY));
				normX=x1-centerX;
				normY=y1-centerY;
				dist=Math.sqrt((normX *normX)+(normY *normY));
				x1=centerX+((normX / dist)*(dist+paddingX));
				y1=centerY+((normY / dist)*(dist+paddingY));
				normX=x2-centerX;
				normY=y2-centerY;
				dist=Math.sqrt((normX *normX)+(normY *normY));
				x2=centerX+((normX / dist)*(dist+paddingX));
				y2=centerY+((normY / dist)*(dist+paddingY));
			}
			context.save();
			if (this.transform){
				var mt=this.transform;
				context.transform(mt.a,mt.b,mt.c,mt.d,mt.tx,mt.ty);
			}
			context.beginPath();
			context.moveTo(x0,y0);
			context.lineTo(x1,y1);
			context.lineTo(x2,y2);
			context.closePath();
			context.clip();
			var delta=(u0 *v1)+(v0 *u2)+(u1 *v2)-(v1 *u2)-(v0 *u1)-(u0 *v2);
			var dDelta=1 / delta;
			var deltaA=(x0 *v1)+(v0 *x2)+(x1 *v2)-(v1 *x2)-(v0 *x1)-(x0 *v2);
			var deltaB=(u0 *x1)+(x0 *u2)+(u1 *x2)-(x1 *u2)-(x0 *u1)-(u0 *x2);
			var deltaC=(u0 *v1 *x2)+(v0 *x1 *u2)+(x0 *u1 *v2)-(x0 *v1 *u2)-(v0 *u1 *x2)-(u0 *x1 *v2);
			var deltaD=(y0 *v1)+(v0 *y2)+(y1 *v2)-(v1 *y2)-(v0 *y1)-(y0 *v2);
			var deltaE=(u0 *y1)+(y0 *u2)+(u1 *y2)-(y1 *u2)-(y0 *u1)-(u0 *y2);
			var deltaF=(u0 *v1 *y2)+(v0 *y1 *u2)+(y0 *u1 *v2)-(y0 *v1 *u2)-(v0 *u1 *y2)-(u0 *y1 *v2);
			context.transform(deltaA *dDelta,deltaD *dDelta,deltaB *dDelta,deltaE*dDelta,deltaC *dDelta,deltaF *dDelta);
			context.drawImage(textureSource,texture.uv[0]*sourceWidth,texture.uv[1]*sourceHeight,textureWidth,textureHeight,texture.uv[0]*sourceWidth,texture.uv[1]*sourceHeight,textureWidth,textureHeight);
			context.restore();
		}

		return CanvasMeshRender;
	})()


	/**
	*@private
	*/
	//class laya.ani.bone.canvasmesh.MeshData
	var MeshData=(function(){
		function MeshData(){
			this.texture=null;
			this.uvs=[0,0,1,0,1,1,0,1];
			this.vertices=[0,0,100,0,100,100,0,100];
			this.indexes=[0,1,3,3,1,2];
			this.uvTransform=null;
			this.useUvTransform=false;
			this.canvasPadding=1;
		}

		__class(MeshData,'laya.ani.bone.canvasmesh.MeshData');
		var __proto=MeshData.prototype;
		/**
		*计算mesh的Bounds
		*@return
		*
		*/
		__proto.getBounds=function(){
			return Rectangle._getWrapRec(this.vertices);
		}

		return MeshData;
	})()


	/**
	*@private
	*/
	//class laya.ani.bone.DeformAniData
	var DeformAniData=(function(){
		function DeformAniData(){
			this.skinName=null;
			this.deformSlotDataList=[];
		}

		__class(DeformAniData,'laya.ani.bone.DeformAniData');
		return DeformAniData;
	})()


	/**
	*@private
	*/
	//class laya.ani.bone.DeformSlotData
	var DeformSlotData=(function(){
		function DeformSlotData(){
			this.deformSlotDisplayList=[];
		}

		__class(DeformSlotData,'laya.ani.bone.DeformSlotData');
		return DeformSlotData;
	})()


	/**
	*@private
	*/
	//class laya.ani.bone.DeformSlotDisplayData
	var DeformSlotDisplayData=(function(){
		function DeformSlotDisplayData(){
			this.boneSlot=null;
			this.slotIndex=-1;
			this.attachment=null;
			this.deformData=null;
			this.frameIndex=0;
			this.timeList=[];
			this.vectices=[];
			this.tweenKeyList=[];
		}

		__class(DeformSlotDisplayData,'laya.ani.bone.DeformSlotDisplayData');
		var __proto=DeformSlotDisplayData.prototype;
		__proto.binarySearch1=function(values,target){
			var low=0;
			var high=values.length-2;
			if (high==0)
				return 1;
			var current=high >>> 1;
			while (true){
				if (values[Math.floor(current+1)] <=target)
					low=current+1;
				else
				high=current;
				if (low==high)
					return low+1;
				current=(low+high)>>> 1;
			}
			return 0;
		}

		// Can't happen.
		__proto.apply=function(time,boneSlot,alpha){
			(alpha===void 0)&& (alpha=1);
			time+=0.05;
			if (this.timeList.length <=0){
				return;
			};
			var i=0;
			var n=0;
			var tTime=this.timeList[0];
			if (time < tTime){
				return;
			};
			var tVertexCount=this.vectices[0].length;
			var tVertices=[];
			var tFrameIndex=this.binarySearch1(this.timeList,time);
			this.frameIndex=tFrameIndex;
			if (time >=this.timeList[this.timeList.length-1]){
				var lastVertices=this.vectices[this.vectices.length-1];
				if (alpha < 1){
					for (i=0;i < tVertexCount;i++){
						tVertices[i]+=(lastVertices[i]-tVertices[i])*alpha;
					}
					}else {
					for (i=0;i < tVertexCount;i++){
						tVertices[i]=lastVertices[i];
					}
				}
				this.deformData=tVertices;
				return;
			};
			var tTweenKey=this.tweenKeyList[this.frameIndex];
			var tPrevVertices=this.vectices[this.frameIndex-1];
			var tNextVertices=this.vectices[this.frameIndex];
			var tPreFrameTime=this.timeList[this.frameIndex-1];
			var tFrameTime=this.timeList[this.frameIndex];
			if (this.tweenKeyList[tFrameIndex-1]){
				alpha=(time-tPreFrameTime)/ (tFrameTime-tPreFrameTime);
				}else {
				alpha=0;
			};
			var tPrev=NaN;
			for (i=0;i < tVertexCount;i++){
				tPrev=tPrevVertices[i];
				tVertices[i]=tPrev+(tNextVertices[i]-tPrev)*alpha;
			}
			this.deformData=tVertices;
		}

		return DeformSlotDisplayData;
	})()


	/**
	*@private
	*/
	//class laya.ani.bone.DrawOrderData
	var DrawOrderData=(function(){
		function DrawOrderData(){
			this.time=NaN;
			this.drawOrder=[];
		}

		__class(DrawOrderData,'laya.ani.bone.DrawOrderData');
		return DrawOrderData;
	})()


	/**
	*@private
	*/
	//class laya.ani.bone.EventData
	var EventData=(function(){
		function EventData(){
			this.name=null;
			this.intValue=0;
			this.floatValue=NaN;
			this.stringValue=null;
			this.time=NaN;
		}

		__class(EventData,'laya.ani.bone.EventData');
		return EventData;
	})()


	/**
	*@private
	*/
	//class laya.ani.bone.IkConstraint
	var IkConstraint=(function(){
		function IkConstraint(data,bones){
			this._targetBone=null;
			this._bones=null;
			this._data=null;
			this.name=null;
			this.mix=NaN;
			this.bendDirection=NaN;
			this.isSpine=true;
			this._sp=null;
			this.isDebug=false;
			this._data=data;
			this._targetBone=bones[data.targetBoneIndex];
			this.isSpine=data.isSpine;
			if (this._bones==null)this._bones=[];
			this._bones.length=0;
			for (var i=0,n=data.boneIndexs.length;i < n;i++){
				this._bones.push(bones[data.boneIndexs[i]]);
			}
			this.name=data.name;
			this.mix=data.mix;
			this.bendDirection=data.bendDirection;
		}

		__class(IkConstraint,'laya.ani.bone.IkConstraint');
		var __proto=IkConstraint.prototype;
		__proto.apply=function(){
			switch (this._bones.length){
				case 1:
					this._applyIk1(this._bones[0],this._targetBone.resultMatrix.tx,this._targetBone.resultMatrix.ty,this.mix);
					break ;
				case 2:
					if (this.isSpine){
						this._applyIk2(this._bones[0],this._bones[1],this._targetBone.resultMatrix.tx,this._targetBone.resultMatrix.ty,this.bendDirection,this.mix);
						}else{
						this._applyIk3(this._bones[0],this._bones[1],this._targetBone.resultMatrix.tx,this._targetBone.resultMatrix.ty,this.bendDirection,this.mix);
					}
					break ;
				}
		}

		__proto._applyIk1=function(bone,targetX,targetY,alpha){
			var pp=bone.parentBone;
			var id=1 / (pp.resultMatrix.a *pp.resultMatrix.d-pp.resultMatrix.b *pp.resultMatrix.c);
			var x=targetX-pp.resultMatrix.tx;
			var y=targetY-pp.resultMatrix.ty;
			var tx=(x *pp.resultMatrix.d-y *pp.resultMatrix.c)*id-bone.transform.x;
			var ty=(y *pp.resultMatrix.a-x *pp.resultMatrix.b)*id-bone.transform.y;
			var rotationIK=Math.atan2(ty,tx)*IkConstraint.radDeg-0-bone.transform.skX;
			if (bone.transform.scX < 0)rotationIK+=180;
			if (rotationIK > 180)
				rotationIK-=360;
			else if (rotationIK <-180)rotationIK+=360;
			bone.transform.skX=bone.transform.skY=bone.transform.skX+rotationIK *alpha;
			bone.update();
		}

		__proto.updatePos=function(x,y){
			if (this._sp){
				this._sp.pos(x,y);
			}
		}

		__proto._applyIk2=function(parent,child,targetX,targetY,bendDir,alpha){
			if (alpha==0){
				return;
			};
			var px=parent.resultTransform.x,py=parent.resultTransform.y;
			var psx=parent.transform.scX,psy=parent.transform.scY;
			var csx=child.transform.scX;
			var os1=0,os2=0,s2=0;
			if (psx < 0){
				psx=-psx;
				os1=180;
				s2=-1;
				}else {
				os1=0;
				s2=1;
			}
			if (psy < 0){
				psy=-psy;
				s2=-s2;
			}
			if (csx < 0){
				csx=-csx;
				os2=180;
				}else {
				os2=0
			};
			var cx=child.resultTransform.x,cy=NaN,cwx=NaN,cwy=NaN;
			var a=parent.resultMatrix.a,b=parent.resultMatrix.c;
			var c=parent.resultMatrix.b,d=parent.resultMatrix.d;
			var u=Math.abs(psx-psy)<=0.0001;
			if (!u){
				cy=0;
				cwx=a *cx+parent.resultMatrix.tx;
				cwy=c *cx+parent.resultMatrix.ty;
				}else {
				cy=child.resultTransform.y;
				cwx=a *cx+b *cy+parent.resultMatrix.tx;
				cwy=c *cx+d *cy+parent.resultMatrix.ty;
			}
			if (this.isDebug){
				if (!this._sp){
					this._sp=new Sprite();
					Laya.stage.addChild(this._sp);
				}
				this._sp.graphics.clear();
				this._sp.graphics.drawCircle(targetX,targetY,15,"#ffff00");
				this._sp.graphics.drawCircle(cwx,cwy,15,"#ff00ff");
			}
			parent.setRotation(Math.atan2(cwy-parent.resultMatrix.ty,cwx-parent.resultMatrix.tx));
			var pp=parent.parentBone;
			a=pp.resultMatrix.a;
			b=pp.resultMatrix.c;
			c=pp.resultMatrix.b;
			d=pp.resultMatrix.d;
			var id=1 / (a *d-b *c);
			var x=targetX-pp.resultMatrix.tx,y=targetY-pp.resultMatrix.ty;
			var tx=(x *d-y *b)*id-px;
			var ty=(y *a-x *c)*id-py;
			x=cwx-pp.resultMatrix.tx;
			y=cwy-pp.resultMatrix.ty;
			var dx=(x *d-y *b)*id-px;
			var dy=(y *a-x *c)*id-py;
			var l1=Math.sqrt(dx *dx+dy *dy);
			var l2=child.length *csx;
			var a1=NaN,a2=NaN;
			if (u){
				l2 *=psx;
				var cos=(tx *tx+ty *ty-l1 *l1-l2 *l2)/ (2 *l1 *l2);
				if (cos <-1)
					cos=-1;
				else if (cos > 1)cos=1;
				a2=Math.acos(cos)*bendDir;
				a=l1+l2 *cos;
				b=l2 *Math.sin(a2);
				a1=Math.atan2(ty *a-tx *b,tx *a+ty *b);
				}else {
				a=psx *l2;
				b=psy *l2;
				var aa=a *a,bb=b *b,dd=tx *tx+ty *ty,ta=Math.atan2(ty,tx);
				c=bb *l1 *l1+aa *dd-aa *bb;
				var c1=-2 *bb *l1,c2=bb-aa;
				d=c1 *c1-4 *c2 *c;
				if (d > 0){
					var q=Math.sqrt(d);
					if (c1 < 0)q=-q;
					q=-(c1+q)/ 2;
					var r0=q / c2,r1=c / q;
					var r=Math.abs(r0)< Math.abs(r1)? r0 :r1;
					if (r *r <=dd){
						y=Math.sqrt(dd-r *r)*bendDir;
						a1=ta-Math.atan2(y,r);
						a2=Math.atan2(y / psy,(r-l1)/ psx);
					}
				};
				var minAngle=0,minDist=Number.MAX_VALUE,minX=0,minY=0;
				var maxAngle=0,maxDist=0,maxX=0,maxY=0;
				x=l1+a;
				d=x *x;
				if (d > maxDist){
					maxAngle=0;
					maxDist=d;
					maxX=x;
				}
				x=l1-a;
				d=x *x;
				if (d < minDist){
					minAngle=Math.PI;
					minDist=d;
					minX=x;
				};
				var angle=Math.acos(-a *l1 / (aa-bb));
				x=a *Math.cos(angle)+l1;
				y=b *Math.sin(angle);
				d=x *x+y *y;
				if (d < minDist){
					minAngle=angle;
					minDist=d;
					minX=x;
					minY=y;
				}
				if (d > maxDist){
					maxAngle=angle;
					maxDist=d;
					maxX=x;
					maxY=y;
				}
				if (dd <=(minDist+maxDist)/ 2){
					a1=ta-Math.atan2(minY *bendDir,minX);
					a2=minAngle *bendDir;
					}else {
					a1=ta-Math.atan2(maxY *bendDir,maxX);
					a2=maxAngle *bendDir;
				}
			};
			var os=Math.atan2(cy,cx)*s2;
			var rotation=parent.resultTransform.skX;
			a1=(a1-os)*IkConstraint.radDeg+os1-rotation;
			if (a1 > 180)
				a1-=360;
			else if (a1 <-180)a1+=360;
			parent.resultTransform.x=px;
			parent.resultTransform.y=py;
			parent.resultTransform.skX=parent.resultTransform.skY=rotation+a1 *alpha;
			rotation=child.resultTransform.skX;
			rotation=rotation % 360;
			a2=((a2+os)*IkConstraint.radDeg-0)*s2+os2-rotation;
			if (a2 > 180)
				a2-=360;
			else if (a2 <-180)a2+=360;
			child.resultTransform.x=cx;
			child.resultTransform.y=cy;
			child.resultTransform.skX=child.resultTransform.skY=child.resultTransform.skY+a2 *alpha;
			parent.update();
		}

		__proto._applyIk3=function(parent,child,targetX,targetY,bendDir,alpha){
			if (alpha==0){
				return;
			};
			var cwx=NaN,cwy=NaN;
			var x=child.resultMatrix.a *child.length;
			var y=child.resultMatrix.b *child.length;
			var lLL=x *x+y *y;
			var lL=Math.sqrt(lLL);
			var parentX=parent.resultMatrix.tx;
			var parentY=parent.resultMatrix.ty;
			var childX=child.resultMatrix.tx;
			var childY=child.resultMatrix.ty;
			var dX=childX-parentX;
			var dY=childY-parentY;
			var lPP=dX *dX+dY *dY;
			var lP=Math.sqrt(lPP);
			dX=targetX-parent.resultMatrix.tx;
			dY=targetY-parent.resultMatrix.ty;
			var lTT=dX *dX+dY *dY;
			var lT=Math.sqrt(lTT);
			var ikRadianA=0;
			if (lL+lP <=lT || lT+lL <=lP || lT+lP <=lL){
				var rate=NaN;
				if (lL+lP <=lT){
					rate=1;
					}else{
					rate=-1;
				}
				childX=parentX+rate*(targetX-parentX)*lP / lT;
				childY=parentY+rate*(targetY-parentY)*lP / lT;
			}
			else{
				var h=(lPP-lLL+lTT)/ (2 *lTT);
				var r=Math.sqrt(lPP-h *h *lTT)/ lT;
				var hX=parentX+(dX *h);
				var hY=parentY+(dY *h);
				var rX=-dY *r;
				var rY=dX *r;
				if (bendDir>0){
					childX=hX-rX;
					childY=hY-rY;
				}
				else{
					childX=hX+rX;
					childY=hY+rY;
				}
			}
			cwx=childX;
			cwy=childY;
			if (this.isDebug){
				if (!this._sp){
					this._sp=new Sprite();
					Laya.stage.addChild(this._sp);
				}
				this._sp.graphics.clear();
				this._sp.graphics.drawCircle(parentX,parentY,15,"#ff00ff");
				this._sp.graphics.drawCircle(targetX,targetY,15,"#ffff00");
				this._sp.graphics.drawCircle(cwx,cwy,15,"#ff00ff");
			};
			var pRotation=NaN;
			pRotation=Math.atan2(cwy-parent.resultMatrix.ty,cwx-parent.resultMatrix.tx);
			parent.setRotation(pRotation);
			var pTarMatrix;
			pTarMatrix=IkConstraint._tempMatrix;
			pTarMatrix.identity();
			pTarMatrix.rotate(pRotation);
			pTarMatrix.scale(parent.resultMatrix.getScaleX(),parent.resultMatrix.getScaleY());
			pTarMatrix.translate(parent.resultMatrix.tx,parent.resultMatrix.ty);
			pTarMatrix.copyTo(parent.resultMatrix);
			parent.updateChild();
			var childRotation=NaN;
			childRotation=Math.atan2(targetY-cwy,targetX-cwx);
			child.setRotation(childRotation);
			var childTarMatrix;
			childTarMatrix=IkConstraint._tempMatrix;
			childTarMatrix.identity();
			childTarMatrix.rotate(childRotation);
			childTarMatrix.scale(child.resultMatrix.getScaleX(),child.resultMatrix.getScaleY());
			childTarMatrix.translate(cwx,cwy);
			pTarMatrix.copyTo(child.resultMatrix);
			child.updateChild();
		}

		__static(IkConstraint,
		['radDeg',function(){return this.radDeg=180 / Math.PI;},'degRad',function(){return this.degRad=Math.PI / 180;},'_tempMatrix',function(){return this._tempMatrix=new Matrix();}
		]);
		return IkConstraint;
	})()


	/**
	*@private
	*/
	//class laya.ani.bone.IkConstraintData
	var IkConstraintData=(function(){
		function IkConstraintData(){
			this.name=null;
			this.targetBoneName=null;
			this.bendDirection=1;
			this.mix=1;
			this.isSpine=true;
			this.targetBoneIndex=-1;
			this.boneNames=[];
			this.boneIndexs=[];
		}

		__class(IkConstraintData,'laya.ani.bone.IkConstraintData');
		return IkConstraintData;
	})()


	/**
	*@private
	*Mesh数据处理工具
	*@version 1.0
	*
	*@created 2017-4-28 下午2:46:23
	*/
	//class laya.ani.bone.MeshTools
	var MeshTools=(function(){
		function MeshTools(){};
		__class(MeshTools,'laya.ani.bone.MeshTools');
		MeshTools.findEdge=function(verticles,offI,min){
			(offI===void 0)&& (offI=0);
			(min===void 0)&& (min=true);
			var i=0,len=0;
			var tIndex=0;
			len=verticles.length;
			tIndex=-1;
			for (i=0;i < len;i+=2){
				if (tIndex < 0 || (min==(verticles[tIndex+offI] < verticles[i+offI]))){
					tIndex=i;
				}
			}
			return tIndex;
		}

		MeshTools.findBestTriangle=function(verticles){
			var topI=0;
			topI=MeshTools.findEdge(verticles,1,true);
			var bottomI=0;
			bottomI=MeshTools.findEdge(verticles,1,false);
			var leftI=0;
			leftI=MeshTools.findEdge(verticles,0,true);
			var rightI=0;
			rightI=MeshTools.findEdge(verticles,0,false);
			var rst;
			rst=MeshTools._bestTriangle;
			rst.length=0;
			rst.push(leftI,rightI);
			if (rst.indexOf(topI)< 0)rst.push(topI);
			if (rst.indexOf(bottomI)< 0)rst.push(bottomI);
			return rst;
		}

		MeshTools.solveMesh=function(mesh,rst){
			rst=rst||[];
			rst.length=0;
			var mUv;
			mUv=mesh.uvs;
			var mVer;
			mVer=mesh.vertices;
			var uvAbs;
			var indexs;
			indexs=MeshTools.findBestTriangle(mUv);
			var index0=0;
			var index1=0;
			var index2=0;
			index0=indexs[0];
			index1=indexs[1];
			index2=indexs[2];
			MeshTools._absArr.length=0;
			uvAbs=MeshTools.solvePoints(mesh.texture.uv,mUv[index0],mUv[index0+1],mUv[index1]-mUv[index0],mUv[index1+1]-mUv[index0+1],mUv[index2]-mUv[index0],mUv[index2+1]-mUv[index0+1],MeshTools._absArr);
			var newVerticles;
			newVerticles=MeshTools.transPoints(uvAbs,mVer[index0],mVer[index0+1],mVer[index1]-mVer[index0],mVer[index1+1]-mVer[index0+1],mVer[index2]-mVer[index0],mVer[index2+1]-mVer[index0+1],rst);
			return newVerticles;
		}

		MeshTools.solvePoints=function(pointList,oX,oY,v1x,v1y,v2x,v2y,rst){
			rst=rst||[];
			var i=0,len=0;
			len=pointList.length;
			var tRst;
			for (i=0;i < len;i+=2){
				tRst=MeshTools.solve2(pointList[i],pointList[i+1],oX,oY,v1x,v1y,v2x,v2y);
				rst.push(tRst[0],tRst[1]);
			}
			return rst;
		}

		MeshTools.transPoints=function(abs,oX,oY,v1x,v1y,v2x,v2y,rst){
			rst=rst|| [];
			var i=0,len=0;
			len=abs.length;
			var tRst;
			for (i=0;i < len;i+=2){
				tRst=MeshTools.transPoint(abs[i],abs[i+1],oX,oY,v1x,v1y,v2x,v2y,rst);
			}
			return rst;
		}

		MeshTools.transPoint=function(a,b,oX,oY,v1x,v1y,v2x,v2y,rst){
			rst=rst|| [];
			var nX=NaN;
			var nY=NaN;
			nX=oX+v1x *a+v2x *b;
			nY=oY+v1y *a+v2y *b;
			rst.push(nX,nY)
			return rst;
		}

		MeshTools.solve2=function(rx,ry,oX,oY,v1x,v1y,v2x,v2y,rv,rst){
			(rv===void 0)&& (rv=false);
			rst=rst||[];
			var a=NaN,b=NaN;
			if (v1x==0){
				return MeshTools.solve2(rx,ry,oX,oY,v2x,v2y,v1x,v1y,true,rst);
			};
			var dX=NaN;
			var dY=NaN;
			dX=rx-oX;
			dY=ry-oY;
			b=(dY-dX *v1y / v1x)/ (v2y-v2x *v1y / v1x);
			a=(dX-b *v2x)/ v1x;
			if(rv){
				rst.push(b,a);
				}else{
				rst.push(a,b);
			}
			return rst;
		}

		MeshTools.solve=function(pointC,point0,v1,v2){
			return MeshTools.solve2(pointC.x,pointC.y,point0.x,point0.y,v1.x,v1.y,v2.x,v2.y);
		}

		MeshTools._bestTriangle=[];
		MeshTools._absArr=[];
		return MeshTools;
	})()


	/**
	*@private
	*路径作用器
	*1，生成根据骨骼计算控制点
	*2，根据控制点生成路径，并计算路径上的节点
	*3，根据节点，重新调整骨骼位置
	*/
	//class laya.ani.bone.PathConstraint
	var PathConstraint=(function(){
		function PathConstraint(data,bones){
			this.target=null;
			this.data=null;
			this.bones=null;
			this.position=NaN;
			this.spacing=NaN;
			this.rotateMix=NaN;
			this.translateMix=NaN;
			this._debugKey=false;
			this._spaces=null;
			this._segments=[];
			this._curves=[];
			this.data=data;
			this.position=data.position;
			this.spacing=data.spacing;
			this.rotateMix=data.rotateMix;
			this.translateMix=data.translateMix;
			this.bones=[];
			var tBoneIds=this.data.bones;
			for (var i=0,n=tBoneIds.length;i < n;i++){
				this.bones.push(bones[tBoneIds[i]]);
			}
		}

		__class(PathConstraint,'laya.ani.bone.PathConstraint');
		var __proto=PathConstraint.prototype;
		/**
		*计算骨骼在路径上的节点
		*@param boneSlot
		*@param boneMatrixArray
		*@param graphics
		*/
		__proto.apply=function(boneList,graphics){
			if (!this.target)
				return;
			var tTranslateMix=this.translateMix;
			var tRotateMix=this.translateMix;
			var tTranslate=tTranslateMix > 0;
			var tRotate=tRotateMix > 0;
			var tSpacingMode=this.data.spacingMode;
			var tLengthSpacing=tSpacingMode=="length";
			var tRotateMode=this.data.rotateMode;
			var tTangents=tRotateMode=="tangent";
			var tScale=tRotateMode=="chainScale";
			var lengths=[];
			var boneCount=this.bones.length;
			var spacesCount=tTangents ? boneCount :boneCount+1;
			var spaces=[];
			this._spaces=spaces;
			spaces[0]=this.position;
			var spacing=this.spacing;
			if (tScale || tLengthSpacing){
				for (var i=0,n=spacesCount-1;i < n;){
					var bone=this.bones[i];
					var length=bone.length;
					var x=length *bone.resultMatrix.a;
					var y=length *bone.resultMatrix.b;
					length=Math.sqrt(x *x+y *y);
					if (tScale)
						lengths[i]=length;
					spaces[++i]=tLengthSpacing ? Math.max(0,length+spacing):spacing;
				}
			}
			else {
				for (i=1;i < spacesCount;i++){
					spaces[i]=spacing;
				}
			};
			var positions=this.computeWorldPositions(this.target,boneList,graphics,spacesCount,tTangents,this.data.positionMode=="percent",tSpacingMode=="percent");
			if (this._debugKey){
				for (i=0;i < positions.length;i++){
					graphics.drawCircle(positions[i++],positions[i++],5,"#00ff00");
				};
				var tLinePos=[];
				for (i=0;i < positions.length;i++){
					tLinePos.push(positions[i++],positions[i++]);
				}
				graphics.drawLines(0,0,tLinePos,"#ff0000");
			};
			var skeletonX=NaN;
			var skeletonY=NaN;
			var boneX=positions[0];
			var boneY=positions[1];
			var offsetRotation=this.data.offsetRotation;
			var tip=tRotateMode=="chain" && offsetRotation==0;
			var p=NaN;
			for (i=0,p=3;i < boneCount;i++,p+=3){
				bone=this.bones[i];
				bone.resultMatrix.tx+=(boneX-bone.resultMatrix.tx)*tTranslateMix;
				bone.resultMatrix.ty+=(boneY-bone.resultMatrix.ty)*tTranslateMix;
				x=positions[p];
				y=positions[p+1];
				var dx=x-boneX,dy=y-boneY;
				if (tScale){
					length=lengths[i];
					if (length !=0){
						var s=(Math.sqrt(dx *dx+dy *dy)/ length-1)*tRotateMix+1;
						bone.resultMatrix.a *=s;
						bone.resultMatrix.c *=s;
					}
				}
				boneX=x;
				boneY=y;
				if (tRotate){
					var a=bone.resultMatrix.a;
					var b=bone.resultMatrix.c;
					var c=bone.resultMatrix.b;
					var d=bone.resultMatrix.d;
					var r=NaN;
					var cos=NaN;
					var sin=NaN;
					if (tTangents){
						r=positions[p-1];
					}
					else if (spaces[i+1]==0){
						r=positions[p+2];
					}
					else {
						r=Math.atan2(dy,dx);
					}
					r-=Math.atan2(c,a)-offsetRotation / 180 *Math.PI;
					if (tip){
						cos=Math.cos(r);
						sin=Math.sin(r);
						length=bone.length;
						boneX+=(length *(cos *a-sin *c)-dx)*tRotateMix;
						boneY+=(length *(sin *a+cos *c)-dy)*tRotateMix;
					}
					if (r > Math.PI){
						r-=(Math.PI *2);
					}
					else if (r <-Math.PI){
						r+=(Math.PI *2);
					}
					r *=tRotateMix;
					cos=Math.cos(r);
					sin=Math.sin(r);
					bone.resultMatrix.a=cos *a-sin *c;
					bone.resultMatrix.c=cos *b-sin *d;
					bone.resultMatrix.b=sin *a+cos *c;
					bone.resultMatrix.d=sin *b+cos *d;
				}
			}
		}

		/**
		*计算顶点的世界坐标
		*@param boneSlot
		*@param boneList
		*@param start
		*@param count
		*@param worldVertices
		*@param offset
		*/
		__proto.computeWorldVertices2=function(boneSlot,boneList,start,count,worldVertices,offset){
			var tBones=boneSlot.currDisplayData.bones;
			var tWeights=boneSlot.currDisplayData.weights;
			var tTriangles=boneSlot.currDisplayData.triangles;
			var tMatrix;
			var i=0;
			var v=0;
			var skip=0;
			var n=0;
			var w=0;
			var b=0;
			var wx=0;
			var wy=0;
			var vx=0;
			var vy=0;
			var bone;
			var len=0;
			if (tBones==null){
				if (!tTriangles)tTriangles=tWeights;
				if (boneSlot.deformData)
					tTriangles=boneSlot.deformData;
				var parentName;
				parentName=boneSlot.parent;
				if (boneList){
					len=boneList.length;
					for (i=0;i < len;i++){
						if (boneList[i].name==parentName){
							bone=boneList[i];
							break ;
						}
					}
				};
				var tBoneMt;
				if (bone){
					tBoneMt=bone.resultMatrix;
				}
				if (!tBoneMt)tBoneMt=PathConstraint._tempMt;
				var x=tBoneMt.tx;
				var y=tBoneMt.ty;
				var a=tBoneMt.a,bb=tBoneMt.b,c=tBoneMt.c,d=tBoneMt.d;
				if(bone)d*=bone.d;
				for (v=start,w=offset;w < count;v+=2,w+=2){
					vx=tTriangles[v],vy=tTriangles[v+1];
					worldVertices[w]=vx *a+vy *bb+x;
					worldVertices[w+1]=-(vx *c+vy *d+y);
				}
				return;
			}
			for (i=0;i < start;i+=2){
				n=tBones[v];
				v+=n+1;
				skip+=n;
			};
			var skeletonBones=boneList;
			for (w=offset,b=skip *3;w < count;w+=2){
				wx=0,wy=0;
				n=tBones[v++];
				n+=v;
				for (;v < n;v++,b+=3){
					tMatrix=skeletonBones[tBones[v]].resultMatrix;
					vx=tWeights[b];
					vy=tWeights[b+1];
					var weight=tWeights[b+2];
					wx+=(vx *tMatrix.a+vy *tMatrix.c+tMatrix.tx)*weight;
					wy+=(vx *tMatrix.b+vy *tMatrix.d+tMatrix.ty)*weight;
				}
				worldVertices[w]=wx;
				worldVertices[w+1]=wy;
			}
		}

		/**
		*计算路径上的节点
		*@param boneSlot
		*@param boneList
		*@param graphics
		*@param spacesCount
		*@param tangents
		*@param percentPosition
		*@param percentSpacing
		*@return
		*/
		__proto.computeWorldPositions=function(boneSlot,boneList,graphics,spacesCount,tangents,percentPosition,percentSpacing){
			var tBones=boneSlot.currDisplayData.bones;
			var tWeights=boneSlot.currDisplayData.weights;
			var tTriangles=boneSlot.currDisplayData.triangles;
			var tRx=0;
			var tRy=0;
			var nn=0;
			var tMatrix;
			var tX=NaN;
			var tY=NaN;
			var tB=0;
			var tWeight=0;
			var tVertices=[];
			var i=0,j=0,n=0;
			var verticesLength=boneSlot.currDisplayData.verLen;
			var target=boneSlot;
			var position=this.position;
			var spaces=this._spaces;
			var world=[];
			var out=[];
			var closed=false;
			var curveCount=verticesLength / 6;
			var prevCurve=-1;
			var pathLength=NaN;
			var o=0,curve=0;
			var p=NaN;
			var space=NaN;
			var prev=NaN;
			var length=NaN;
			if (!true){
				var lengths=boneSlot.currDisplayData.lengths;
				curveCount-=closed ? 1 :2;
				pathLength=lengths[curveCount];
				if (percentPosition)
					position *=pathLength;
				if (percentSpacing){
					for (i=0;i < spacesCount;i++)
					spaces[i] *=pathLength;
				}
				world.length=8;
				for (i=0,o=0,curve=0;i < spacesCount;i++,o+=3){
					space=spaces[i];
					position+=space;
					p=position;
					if (closed){
						p %=pathLength;
						if (p < 0)
							p+=pathLength;
						curve=0;
					}
					else if (p < 0){
						if (prevCurve !=PathConstraint.BEFORE){
							prevCurve=PathConstraint.BEFORE;
							this.computeWorldVertices2(target,boneList,2,4,world,0);
						}
						this.addBeforePosition(p,world,0,out,o);
						continue ;
					}
					else if (p > pathLength){
						if (prevCurve !=PathConstraint.AFTER){
							prevCurve=PathConstraint.AFTER;
							this.computeWorldVertices2(target,boneList,verticesLength-6,4,world,0);
						}
						this.addAfterPosition(p-pathLength,world,0,out,o);
						continue ;
					}
					for (;;curve++){
						length=lengths[curve];
						if (p > length)
							continue ;
						if (curve==0)
							p /=length;
						else {
							prev=lengths[curve-1];
							p=(p-prev)/ (length-prev);
						}
						break ;
					}
					if (curve !=prevCurve){
						prevCurve=curve;
						if (closed && curve==curveCount){
							this.computeWorldVertices2(target,boneList,verticesLength-4,4,world,0);
							this.computeWorldVertices2(target,boneList,0,4,world,4);
						}
						else
						this.computeWorldVertices2(target,boneList,curve *6+2,8,world,0);
					}
					this.addCurvePosition(p,world[0],world[1],world[2],world[3],world[4],world[5],world[6],world[7],out,o,tangents || (i > 0 && space==0));
				}
				return out;
			}
			if (closed){
				verticesLength+=2;
				world[verticesLength-2]=world[0];
				world[verticesLength-1]=world[1];
			}
			else {
				curveCount--;
				verticesLength-=4;
				this.computeWorldVertices2(boneSlot,boneList,2,verticesLength,tVertices,0);
				if (this._debugKey){
					for (i=0;i < tVertices.length;){
						graphics.drawCircle(tVertices[i++],tVertices[i++],10,"#ff0000");
					}
				}
				world=tVertices;
			}
			this._curves.length=curveCount;
			var curves=this._curves;
			pathLength=0;
			var x1=world[0],y1=world[1],cx1=0,cy1=0,cx2=0,cy2=0,x2=0,y2=0;
			var tmpx=NaN,tmpy=NaN,dddfx=NaN,dddfy=NaN,ddfx=NaN,ddfy=NaN,dfx=NaN,dfy=NaN;
			var w=0;
			for (i=0,w=2;i < curveCount;i++,w+=6){
				cx1=world[w];
				cy1=world[w+1];
				cx2=world[w+2];
				cy2=world[w+3];
				x2=world[w+4];
				y2=world[w+5];
				tmpx=(x1-cx1 *2+cx2)*0.1875;
				tmpy=(y1-cy1 *2+cy2)*0.1875;
				dddfx=((cx1-cx2)*3-x1+x2)*0.09375;
				dddfy=((cy1-cy2)*3-y1+y2)*0.09375;
				ddfx=tmpx *2+dddfx;
				ddfy=tmpy *2+dddfy;
				dfx=(cx1-x1)*0.75+tmpx+dddfx *0.16666667;
				dfy=(cy1-y1)*0.75+tmpy+dddfy *0.16666667;
				pathLength+=Math.sqrt(dfx *dfx+dfy *dfy);
				dfx+=ddfx;
				dfy+=ddfy;
				ddfx+=dddfx;
				ddfy+=dddfy;
				pathLength+=Math.sqrt(dfx *dfx+dfy *dfy);
				dfx+=ddfx;
				dfy+=ddfy;
				pathLength+=Math.sqrt(dfx *dfx+dfy *dfy);
				dfx+=ddfx+dddfx;
				dfy+=ddfy+dddfy;
				pathLength+=Math.sqrt(dfx *dfx+dfy *dfy);
				curves[i]=pathLength;
				x1=x2;
				y1=y2;
			}
			if (percentPosition)
				position *=pathLength;
			if (percentSpacing){
				for (i=0;i < spacesCount;i++)
				spaces[i] *=pathLength;
			};
			var segments=this._segments;
			var curveLength=0;
			var segment=0;
			for (i=0,o=0,curve=0,segment=0;i < spacesCount;i++,o+=3){
				space=spaces[i];
				position+=space;
				p=position;
				if (closed){
					p %=pathLength;
					if (p < 0)
						p+=pathLength;
					curve=0;
				}
				else if (p < 0){
					this.addBeforePosition(p,world,0,out,o);
					continue ;
				}
				else if (p > pathLength){
					this.addAfterPosition(p-pathLength,world,verticesLength-4,out,o);
					continue ;
				}
				for (;;curve++){
					length=curves[curve];
					if (p > length)
						continue ;
					if (curve==0)
						p /=length;
					else {
						prev=curves[curve-1];
						p=(p-prev)/ (length-prev);
					}
					break ;
				}
				if (curve !=prevCurve){
					prevCurve=curve;
					var ii=curve *6;
					x1=world[ii];
					y1=world[ii+1];
					cx1=world[ii+2];
					cy1=world[ii+3];
					cx2=world[ii+4];
					cy2=world[ii+5];
					x2=world[ii+6];
					y2=world[ii+7];
					tmpx=(x1-cx1 *2+cx2)*0.03;
					tmpy=(y1-cy1 *2+cy2)*0.03;
					dddfx=((cx1-cx2)*3-x1+x2)*0.006;
					dddfy=((cy1-cy2)*3-y1+y2)*0.006;
					ddfx=tmpx *2+dddfx;
					ddfy=tmpy *2+dddfy;
					dfx=(cx1-x1)*0.3+tmpx+dddfx *0.16666667;
					dfy=(cy1-y1)*0.3+tmpy+dddfy *0.16666667;
					curveLength=Math.sqrt(dfx *dfx+dfy *dfy);
					segments[0]=curveLength;
					for (ii=1;ii < 8;ii++){
						dfx+=ddfx;
						dfy+=ddfy;
						ddfx+=dddfx;
						ddfy+=dddfy;
						curveLength+=Math.sqrt(dfx *dfx+dfy *dfy);
						segments[ii]=curveLength;
					}
					dfx+=ddfx;
					dfy+=ddfy;
					curveLength+=Math.sqrt(dfx *dfx+dfy *dfy);
					segments[8]=curveLength;
					dfx+=ddfx+dddfx;
					dfy+=ddfy+dddfy;
					curveLength+=Math.sqrt(dfx *dfx+dfy *dfy);
					segments[9]=curveLength;
					segment=0;
				}
				p *=curveLength;
				for (;;segment++){
					length=segments[segment];
					if (p > length)
						continue ;
					if (segment==0)
						p /=length;
					else {
						prev=segments[segment-1];
						p=segment+(p-prev)/ (length-prev);
					}
					break ;
				}
				this.addCurvePosition(p *0.1,x1,y1,cx1,cy1,cx2,cy2,x2,y2,out,o,tangents || (i > 0 && space==0));
			}
			return out;
		}

		__proto.addBeforePosition=function(p,temp,i,out,o){
			var x1=temp[i],y1=temp[i+1],dx=temp[i+2]-x1,dy=temp[i+3]-y1,r=Math.atan2(dy,dx);
			out[o]=x1+p *Math.cos(r);
			out[o+1]=y1+p *Math.sin(r);
			out[o+2]=r;
		}

		__proto.addAfterPosition=function(p,temp,i,out,o){
			var x1=temp[i+2],y1=temp[i+3],dx=x1-temp[i],dy=y1-temp[i+1],r=Math.atan2(dy,dx);
			out[o]=x1+p *Math.cos(r);
			out[o+1]=y1+p *Math.sin(r);
			out[o+2]=r;
		}

		__proto.addCurvePosition=function(p,x1,y1,cx1,cy1,cx2,cy2,x2,y2,out,o,tangents){
			if (p==0)
				p=0.0001;
			var tt=p *p,ttt=tt *p,u=1-p,uu=u *u,uuu=uu *u;
			var ut=u *p,ut3=ut *3,uut3=u *ut3,utt3=ut3 *p;
			var x=x1 *uuu+cx1 *uut3+cx2 *utt3+x2 *ttt,y=y1 *uuu+cy1 *uut3+cy2 *utt3+y2 *ttt;
			out[o]=x;
			out[o+1]=y;
			if (tangents){
				out[o+2]=Math.atan2(y-(y1 *uu+cy1 *ut *2+cy2 *tt),x-(x1 *uu+cx1 *ut *2+cx2 *tt));
			}
			else {
				out[o+2]=0;
			}
		}

		PathConstraint.NONE=-1;
		PathConstraint.BEFORE=-2;
		PathConstraint.AFTER=-3;
		__static(PathConstraint,
		['_tempMt',function(){return this._tempMt=new Matrix();}
		]);
		return PathConstraint;
	})()


	/**
	*@private
	*/
	//class laya.ani.bone.PathConstraintData
	var PathConstraintData=(function(){
		function PathConstraintData(){
			this.name=null;
			this.target=null;
			this.positionMode=null;
			this.spacingMode=null;
			this.rotateMode=null;
			this.offsetRotation=NaN;
			this.position=NaN;
			this.spacing=NaN;
			this.rotateMix=NaN;
			this.translateMix=NaN;
			this.bones=[];
		}

		__class(PathConstraintData,'laya.ani.bone.PathConstraintData');
		return PathConstraintData;
	})()


	/**
	*@private
	*/
	//class laya.ani.bone.SkinData
	var SkinData=(function(){
		function SkinData(){
			this.name=null;
			this.slotArr=[];
		}

		__class(SkinData,'laya.ani.bone.SkinData');
		return SkinData;
	})()


	/**
	*@private
	*/
	//class laya.ani.bone.SkinSlotDisplayData
	var SkinSlotDisplayData=(function(){
		function SkinSlotDisplayData(){
			this.name=null;
			this.attachmentName=null;
			this.type=0;
			this.transform=null;
			this.width=NaN;
			this.height=NaN;
			this.texture=null;
			this.bones=null;
			this.uvs=null;
			this.weights=null;
			this.triangles=null;
			this.vertices=null;
			this.lengths=null;
			this.verLen=0;
		}

		__class(SkinSlotDisplayData,'laya.ani.bone.SkinSlotDisplayData');
		var __proto=SkinSlotDisplayData.prototype;
		__proto.createTexture=function(currTexture){
			if (this.texture)return this.texture;
			this.texture=new Texture(currTexture.bitmap,this.uvs);
			if (this.uvs[0] > this.uvs[4]
				&& this.uvs[1] > this.uvs[5]){
				this.texture.width=currTexture.height;
				this.texture.height=currTexture.width;
				this.texture.offsetX=-currTexture.offsetX;
				this.texture.offsetY=-currTexture.offsetY;
				this.texture.sourceWidth=currTexture.sourceHeight;
				this.texture.sourceHeight=currTexture.sourceWidth;
				}else {
				this.texture.width=currTexture.width;
				this.texture.height=currTexture.height;
				this.texture.offsetX=-currTexture.offsetX;
				this.texture.offsetY=-currTexture.offsetY;
				this.texture.sourceWidth=currTexture.sourceWidth;
				this.texture.sourceHeight=currTexture.sourceHeight;
			}
			return this.texture;
		}

		__proto.destory=function(){
			if (this.texture)this.texture.destroy();
		}

		return SkinSlotDisplayData;
	})()


	/**
	*@private
	*/
	//class laya.ani.bone.SlotData
	var SlotData=(function(){
		function SlotData(){
			this.name=null;
			this.displayArr=[];
		}

		__class(SlotData,'laya.ani.bone.SlotData');
		var __proto=SlotData.prototype;
		__proto.getDisplayByName=function(name){
			var tDisplay;
			for (var i=0,n=this.displayArr.length;i < n;i++){
				tDisplay=this.displayArr[i];
				if (tDisplay.attachmentName==name){
					return i;
				}
			}
			return-1;
		}

		return SlotData;
	})()


	/**
	*@private
	*/
	//class laya.ani.bone.TfConstraint
	var TfConstraint=(function(){
		function TfConstraint(data,bones){
			this._data=null;
			this._bones=null;
			this.target=null;
			this.rotateMix=NaN;
			this.translateMix=NaN;
			this.scaleMix=NaN;
			this.shearMix=NaN;
			this._temp=__newvec(2,0);
			this._data=data;
			if (this._bones==null){
				this._bones=[];
			}
			this.target=bones[data.targetIndex];
			var j=0,n=0;
			for (j=0,n=data.boneIndexs.length;j < n;j++){
				this._bones.push(bones[data.boneIndexs[j]]);
			}
			this.rotateMix=data.rotateMix;
			this.translateMix=data.translateMix;
			this.scaleMix=data.scaleMix;
			this.shearMix=data.shearMix;
		}

		__class(TfConstraint,'laya.ani.bone.TfConstraint');
		var __proto=TfConstraint.prototype;
		__proto.apply=function(){
			var tTfBone;
			var ta=this.target.resultMatrix.a,tb=this.target.resultMatrix.b,tc=this.target.resultMatrix.c,td=this.target.resultMatrix.d;
			for (var j=0,n=this._bones.length;j < n;j++){
				tTfBone=this._bones[j];
				if (this.rotateMix > 0){
					var a=tTfBone.resultMatrix.a,b=tTfBone.resultMatrix.b,c=tTfBone.resultMatrix.c,d=tTfBone.resultMatrix.d;
					var r=Math.atan2(tc,ta)-Math.atan2(c,a)+this._data.offsetRotation *Math.PI / 180;
					if (r > Math.PI)
						r-=Math.PI *2;
					else if (r <-Math.PI)r+=Math.PI *2;
					r *=this.rotateMix;
					var cos=Math.cos(r),sin=Math.sin(r);
					tTfBone.resultMatrix.a=cos *a-sin *c;
					tTfBone.resultMatrix.b=cos *b-sin *d;
					tTfBone.resultMatrix.c=sin *a+cos *c;
					tTfBone.resultMatrix.d=sin *b+cos *d;
				}
				if (this.translateMix){
					this._temp[0]=this._data.offsetX;
					this._temp[1]=this._data.offsetY;
					this.target.localToWorld(this._temp);
					tTfBone.resultMatrix.tx+=(this._temp[0]-tTfBone.resultMatrix.tx)*this.translateMix;
					tTfBone.resultMatrix.ty+=(this._temp[1]-tTfBone.resultMatrix.ty)*this.translateMix;
					tTfBone.updateChild();
				}
				if (this.scaleMix > 0){
					var bs=Math.sqrt(tTfBone.resultMatrix.a *tTfBone.resultMatrix.a+tTfBone.resultMatrix.c *tTfBone.resultMatrix.c);
					var ts=Math.sqrt(ta *ta+tc *tc);
					var s=bs > 0.00001 ? (bs+(ts-bs+this._data.offsetScaleX)*this.scaleMix)/ bs :0;
					tTfBone.resultMatrix.a *=s;
					tTfBone.resultMatrix.c *=s;
					bs=Math.sqrt(tTfBone.resultMatrix.b *tTfBone.resultMatrix.b+tTfBone.resultMatrix.d *tTfBone.resultMatrix.d);
					ts=Math.sqrt(tb *tb+td *td);
					s=bs > 0.00001 ? (bs+(ts-bs+this._data.offsetScaleY)*this.scaleMix)/ bs :0;
					tTfBone.resultMatrix.b *=s;
					tTfBone.resultMatrix.d *=s;
				}
				if (this.shearMix > 0){
					b=tTfBone.resultMatrix.b,d=tTfBone.resultMatrix.d;
					var by=Math.atan2(d,b);
					r=Math.atan2(td,tb)-Math.atan2(tc,ta)-(by-Math.atan2(tTfBone.resultMatrix.c,tTfBone.resultMatrix.a));
					if (r > Math.PI)
						r-=Math.PI *2;
					else if (r <-Math.PI)r+=Math.PI *2;
					r=by+(r+this._data.offsetShearY *Math.PI / 180)*this.shearMix;
					s=Math.sqrt(b *b+d *d);
					tTfBone.resultMatrix.b=Math.cos(r)*s;
					tTfBone.resultMatrix.d=Math.sin(r)*s;
				}
			}
		}

		return TfConstraint;
	})()


	/**
	*@private
	*/
	//class laya.ani.bone.TfConstraintData
	var TfConstraintData=(function(){
		function TfConstraintData(){
			this.name=null;
			this.targetIndex=0;
			this.rotateMix=NaN;
			this.translateMix=NaN;
			this.scaleMix=NaN;
			this.shearMix=NaN;
			this.offsetRotation=NaN;
			this.offsetX=NaN;
			this.offsetY=NaN;
			this.offsetScaleX=NaN;
			this.offsetScaleY=NaN;
			this.offsetShearY=NaN;
			this.boneIndexs=[];
		}

		__class(TfConstraintData,'laya.ani.bone.TfConstraintData');
		return TfConstraintData;
	})()


	/**
	*@private
	*/
	//class laya.ani.bone.Transform
	var Transform=(function(){
		function Transform(){
			this.skX=0;
			this.skY=0;
			this.scX=1;
			this.scY=1;
			this.x=0;
			this.y=0;
			this.skewX=0;
			this.skewY=0;
			this.mMatrix=null;
		}

		__class(Transform,'laya.ani.bone.Transform');
		var __proto=Transform.prototype;
		__proto.initData=function(data){
			if (data.x !=undefined){
				this.x=data.x;
			}
			if (data.y !=undefined){
				this.y=data.y;
			}
			if (data.skX !=undefined){
				this.skX=data.skX;
			}
			if (data.skY !=undefined){
				this.skY=data.skY;
			}
			if (data.scX !=undefined){
				this.scX=data.scX;
			}
			if (data.scY !=undefined){
				this.scY=data.scY;
			}
		}

		__proto.getMatrix=function(){
			var tMatrix;
			if (this.mMatrix){
				tMatrix=this.mMatrix;
				}else {
				tMatrix=this.mMatrix=new Matrix();
			}
			tMatrix.identity();
			tMatrix.scale(this.scX,this.scY);
			if (this.skewX || this.skewY){
				this.skew(tMatrix,this.skewX *Math.PI / 180,this.skewY *Math.PI / 180);
			}
			tMatrix.rotate(this.skX *Math.PI / 180);
			tMatrix.translate(this.x,this.y);
			return tMatrix;
		}

		__proto.skew=function(m,x,y){
			var sinX=Math.sin(y);
			var cosX=Math.cos(y);
			var sinY=Math.sin(x);
			var cosY=Math.cos(x);
			m.setTo(m.a *cosY-m.b *sinX,
			m.a *sinY+m.b *cosX,
			m.c *cosY-m.d *sinX,
			m.c *sinY+m.d *cosX,
			m.tx *cosY-m.ty *sinX,
			m.tx *sinY+m.ty *cosX);
			return m;
		}

		return Transform;
	})()


	/**
	*用于UV转换的工具类
	*@private
	*/
	//class laya.ani.bone.UVTools
	var UVTools=(function(){
		function UVTools(){}
		__class(UVTools,'laya.ani.bone.UVTools');
		UVTools.getRelativeUV=function(bigUV,smallUV,rst){
			var startX=bigUV[0];
			var width=bigUV[2]-bigUV[0];
			var startY=bigUV[1];
			var height=bigUV[5]-bigUV[1];
			if(!rst)rst=[];
			rst.length=smallUV.length;
			var i=0,len=0;
			len=rst.length;
			var dWidth=1 / width;
			var dHeight=1 / height;
			for (i=0;i < len;i+=2){
				rst[i]=(smallUV[i]-startX)*dWidth;
				rst[i+1]=(smallUV[i+1]-startY)*dHeight;
			}
			return rst;
		}

		UVTools.getAbsoluteUV=function(bigUV,smallUV,rst){
			if (bigUV[0]==0 && bigUV[1]==0 && bigUV[4]==1 && bigUV[5]==1){
				if (rst){
					Utils$1.copyArray(rst,smallUV);
					return rst;
					}else{
					return smallUV;
				}
			};
			var startX=bigUV[0];
			var width=bigUV[2]-bigUV[0];
			var startY=bigUV[1];
			var height=bigUV[5]-bigUV[1];
			if(!rst)rst=[];
			rst.length=smallUV.length;
			var i=0,len=0;
			len=rst.length;
			for (i=0;i < len;i+=2){
				rst[i]=smallUV[i]*width+startX;
				rst[i+1]=smallUV[i+1]*height+startY;
			}
			return rst;
		}

		return UVTools;
	})()


	/**
	*@private
	*@author ...
	*/
	//class laya.ani.KeyFramesContent
	var KeyFramesContent=(function(){
		function KeyFramesContent(){
			this.startTime=NaN;
			this.duration=NaN;
			this.interpolationData=null;
			this.data=null;
			this.dData=null;
			this.nextData=null;
		}

		__class(KeyFramesContent,'laya.ani.KeyFramesContent');
		return KeyFramesContent;
	})()


	/**
	*@private
	*...
	*@author ww
	*/
	//class laya.ani.math.BezierLerp
	var BezierLerp=(function(){
		function BezierLerp(){}
		__class(BezierLerp,'laya.ani.math.BezierLerp');
		BezierLerp.getBezierRate=function(t,px0,py0,px1,py1){
			var key=BezierLerp._getBezierParamKey(px0,py0,px1,py1);
			var vKey=key *100+t;
			if (BezierLerp._bezierResultCache[vKey])return BezierLerp._bezierResultCache[vKey];
			var points=BezierLerp._getBezierPoints(px0,py0,px1,py1,key);
			var i=0,len=0;
			len=points.length;
			for (i=0;i < len;i+=2){
				if (t <=points[i]){
					BezierLerp._bezierResultCache[vKey]=points[i+1];
					return points[i+1];
				}
			}
			BezierLerp._bezierResultCache[vKey]=1;
			return 1;
		}

		BezierLerp._getBezierParamKey=function(px0,py0,px1,py1){
			return (((px0 *100+py0)*100+px1)*100+py1)*100;
		}

		BezierLerp._getBezierPoints=function(px0,py0,px1,py1,key){
			if (BezierLerp._bezierPointsCache[key])return BezierLerp._bezierPointsCache[key];
			var controlPoints;
			controlPoints=[0,0,px0,py0,px1,py1,1,1];
			var bz;
			bz=new Bezier();
			var points;
			points=bz.getBezierPoints(controlPoints,100,3);
			BezierLerp._bezierPointsCache[key]=points;
			return points;
		}

		BezierLerp._bezierResultCache={};
		BezierLerp._bezierPointsCache={};
		return BezierLerp;
	})()


	/**
	*<code>LayoutStyle</code> 是一个布局样式类。
	*/
	//class laya.ui.LayoutStyle
	var LayoutStyle=(function(){
		function LayoutStyle(){
			this.enable=false;
			this.top=NaN;
			this.bottom=NaN;
			this.left=NaN;
			this.right=NaN;
			this.centerX=NaN;
			this.centerY=NaN;
			this.anchorX=NaN;
			this.anchorY=NaN;
		}

		__class(LayoutStyle,'laya.ui.LayoutStyle');
		__static(LayoutStyle,
		['EMPTY',function(){return this.EMPTY=new LayoutStyle();}
		]);
		return LayoutStyle;
	})()


	/**
	*<code>Styles</code> 定义了组件常用的样式属性。
	*/
	//class laya.ui.Styles
	var Styles=(function(){
		function Styles(){};
		__class(Styles,'laya.ui.Styles');
		Styles.labelColor="#000000";
		Styles.buttonStateNum=3;
		Styles.scrollBarMinNum=15;
		Styles.scrollBarDelayTime=500;
		__static(Styles,
		['defaultSizeGrid',function(){return this.defaultSizeGrid=[4,4,4,4,0];},'labelPadding',function(){return this.labelPadding=[2,2,2,2];},'inputLabelPadding',function(){return this.inputLabelPadding=[1,1,1,3];},'buttonLabelColors',function(){return this.buttonLabelColors=["#32556b","#32cc6b","#ff0000","#C0C0C0"];},'comboBoxItemColors',function(){return this.comboBoxItemColors=["#5e95b6","#ffffff","#000000","#8fa4b1","#ffffff"];}
		]);
		return Styles;
	})()


	/**
	*<code>UIUtils</code> 是文本工具集。
	*/
	//class laya.ui.UIUtils
	var UIUtils=(function(){
		function UIUtils(){};
		__class(UIUtils,'laya.ui.UIUtils');
		UIUtils.fillArray=function(arr,str,type){
			var temp=arr.concat();
			if (str){
				var a=str.split(",");
				for (var i=0,n=Math.min(temp.length,a.length);i < n;i++){
					var value=a[i];
					temp[i]=(value=="true" ? true :(value=="false" ? false :value));
					if (type !=null)temp[i]=type(value);
				}
			}
			return temp;
		}

		UIUtils.toColor=function(color){
			return Utils$1.toHexColor(color);
		}

		UIUtils.gray=function(traget,isGray){
			(isGray===void 0)&& (isGray=true);
			if (isGray){
				UIUtils.addFilter(traget,UIUtils.grayFilter);
				}else {
				UIUtils.clearFilter(traget,ColorFilter);
			}
		}

		UIUtils.addFilter=function(target,filter){
			var filters=target.filters || [];
			filters.push(filter);
			target.filters=filters;
		}

		UIUtils.clearFilter=function(target,filterType){
			var filters=target.filters;
			if (filters !=null && filters.length > 0){
				for (var i=filters.length-1;i >-1;i--){
					var filter=filters[i];
					if (Laya.__typeof(filter,filterType))filters.splice(i,1);
				}
				target.filters=filters;
			}
		}

		UIUtils._getReplaceStr=function(word){
			return UIUtils.escapeSequence[word];
		}

		UIUtils.adptString=function(str){
			return str.replace(/\\(\w)/g,UIUtils._getReplaceStr);
		}

		__static(UIUtils,
		['grayFilter',function(){return this.grayFilter=new ColorFilter([0.3086,0.6094,0.082,0,0,0.3086,0.6094,0.082,0,0,0.3086,0.6094,0.082,0,0,0,0,0,1,0]);},'escapeSequence',function(){return this.escapeSequence={"\\n":"\n","\\t":"\t"};}
		]);
		return UIUtils;
	})()


	/**全局配置*/
	//class UIConfig
	var UIConfig=(function(){
		function UIConfig(){};
		__class(UIConfig,'UIConfig');
		UIConfig.touchScrollEnable=true;
		UIConfig.mouseWheelEnable=true;
		UIConfig.showButtons=true;
		UIConfig.popupBgColor="#000000";
		UIConfig.popupBgAlpha=0.5;
		UIConfig.closeDialogOnSide=true;
		return UIConfig;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-11-16 下午1:26:53
	*/
	//class ide.event.Notices
	var Notices=(function(){
		function Notices(){}
		__class(Notices,'ide.event.Notices');
		Notices.RENDER_INITED="RenderInited";
		return Notices;
	})()


	/**
	*...
	*@author WW
	*/
	//class viewRender.ViewRenderBase
	var ViewRenderBase=(function(){
		function ViewRenderBase(){
			this.initFuns();
		}

		__class(ViewRenderBase,'viewRender.ViewRenderBase');
		var __proto=ViewRenderBase.prototype;
		__proto.initFuns=function(){
			Browser.window.renderBinds={};
			Browser.window.renderBinds.setData=Utils$1.bind(this.setData,this);
			Browser.window.renderBinds.updateData=Utils$1.bind(this.updateData,this);
			Browser.window.renderBinds.clearRender=Utils$1.bind(this.clearRender,this);
			Browser.window.renderBinds.sizeRender=Utils$1.bind(this.sizeRender,this);
			Browser.window.renderBinds.posRender=Utils$1.bind(this.posRender,this);
			Browser.window.renderBinds.getRenderData=Utils$1.bind(this.getRenderData,this);
			Browser.window.renderBinds.getStage=Utils$1.bind(this.getStage,this);
			Browser.window.renderBinds.setNotice=Utils$1.bind(this.setNotice,this);
		}

		__proto.getRenderData=function(){
			return null;
		}

		__proto.setData=function(data){}
		__proto.updateData=function(data){}
		__proto.clearRender=function(){}
		__proto.sizeRender=function(width,height){}
		__proto.posRender=function(x,y){}
		__proto.getStage=function(){
			return Laya.stage;
		}

		__proto.setNotice=function(notice){
			Notice.I=notice;
			Notice.notify("RenderInited");
		}

		return ViewRenderBase;
	})()


	//class laya.filters.webgl.FilterActionGL
	var FilterActionGL=(function(){
		function FilterActionGL(){}
		__class(FilterActionGL,'laya.filters.webgl.FilterActionGL');
		var __proto=FilterActionGL.prototype;
		Laya.imps(__proto,{"laya.filters.IFilterActionGL":true})
		__proto.setValue=function(shader){}
		__proto.setValueMix=function(shader){}
		__proto.apply3d=function(scope,sprite,context,x,y){return null;}
		__proto.apply=function(srcCanvas){return null;}
		__getset(0,__proto,'typeMix',function(){
			return 0;
		});

		return FilterActionGL;
	})()


	//class laya.webgl.atlas.AtlasGrid
	var AtlasGrid=(function(){
		var TexRowInfo,TexMergeTexSize;
		function AtlasGrid(width,height,atlasID){
			this._atlasID=0;
			this._width=0;
			this._height=0;
			this._texCount=0;
			this._rowInfo=null;
			this._cells=null;
			this._failSize=new TexMergeTexSize();
			(width===void 0)&& (width=0);
			(height===void 0)&& (height=0);
			(atlasID===void 0)&& (atlasID=0);
			this._cells=null;
			this._rowInfo=null;
			this._init(width,height);
			this._atlasID=atlasID;
		}

		__class(AtlasGrid,'laya.webgl.atlas.AtlasGrid');
		var __proto=AtlasGrid.prototype;
		//------------------------------------------------------------------------------
		__proto.getAltasID=function(){
			return this._atlasID;
		}

		//------------------------------------------------------------------------------
		__proto.setAltasID=function(atlasID){
			if (atlasID >=0){
				this._atlasID=atlasID;
			}
		}

		//------------------------------------------------------------------
		__proto.addTex=function(type,width,height){
			var result=this._get(width,height);
			if (result.ret==false){
				return result;
			}
			this._fill(result.x,result.y,width,height,type);
			this._texCount++;
			return result;
		}

		//------------------------------------------------------------------------------
		__proto._release=function(){
			if (this._cells !=null){
				this._cells.length=0;
				this._cells=null;
			}
			if (this._rowInfo){
				this._rowInfo.length=0;
				this._rowInfo=null;
			}
		}

		//------------------------------------------------------------------------------
		__proto._init=function(width,height){
			this._width=width;
			this._height=height;
			this._release();
			if (this._width==0)return false;
			this._cells=new Uint8Array(this._width *this._height*3);
			this._rowInfo=__newvec(this._height);
			for (var i=0;i < this._height;i++){
				this._rowInfo[i]=new TexRowInfo();
			}
			this._clear();
			return true;
		}

		//------------------------------------------------------------------
		__proto._get=function(width,height){
			var pFillInfo=new MergeFillInfo();
			if (width >=this._failSize.width && height >=this._failSize.height){
				return pFillInfo;
			};
			var rx=-1;
			var ry=-1;
			var nWidth=this._width;
			var nHeight=this._height;
			var pCellBox=this._cells;
			for (var y=0;y < nHeight;y++){
				if (this._rowInfo[y].spaceCount < width)continue ;
				for (var x=0;x < nWidth;){
					var tm=(y *nWidth+x)*3;
					if (pCellBox[tm] !=0 || pCellBox[tm+1] < width || pCellBox[tm+2] < height){
						x+=pCellBox[tm+1];
						continue ;
					}
					rx=x;
					ry=y;
					for (var xx=0;xx < width;xx++){
						if (pCellBox[3*xx+tm+2] < height){
							rx=-1;
							break ;
						}
					}
					if (rx < 0){
						x+=pCellBox[tm+1];
						continue ;
					}
					pFillInfo.ret=true;
					pFillInfo.x=rx;
					pFillInfo.y=ry;
					return pFillInfo;
				}
			}
			return pFillInfo;
		}

		//------------------------------------------------------------------
		__proto._fill=function(x,y,w,h,type){
			var nWidth=this._width;
			var nHeghit=this._height;
			this._check((x+w)<=nWidth && (y+h)<=nHeghit);
			for (var yy=y;yy < (h+y);++yy){
				this._check(this._rowInfo[yy].spaceCount >=w);
				this._rowInfo[yy].spaceCount-=w;
				for (var xx=0;xx < w;xx++){
					var tm=(x+yy *nWidth+xx)*3;
					this._check(this._cells[tm]==0);
					this._cells[tm]=type;
					this._cells[tm+1]=w;
					this._cells[tm+2]=h;
				}
			}
			if (x > 0){
				for (yy=0;yy < h;++yy){
					var s=0;
					for (xx=x-1;xx >=0;--xx,++s){
						if (this._cells[((y+yy)*nWidth+xx)*3] !=0)break ;
					}
					for (xx=s;xx > 0;--xx){
						this._cells[((y+yy)*nWidth+x-xx)*3+1]=xx;
						this._check(xx > 0);
					}
				}
			}
			if (y > 0){
				for (xx=x;xx < (x+w);++xx){
					s=0;
					for (yy=y-1;yy >=0;--yy,s++){
						if (this._cells[(xx+yy *nWidth)*3] !=0)break ;
					}
					for (yy=s;yy > 0;--yy){
						this._cells[(xx+(y-yy)*nWidth)*3+2]=yy;
						this._check(yy > 0);
					}
				}
			}
		}

		__proto._check=function(ret){
			if (ret==false){
				console.log("xtexMerger 错误啦");
			}
		}

		//------------------------------------------------------------------
		__proto._clear=function(){
			this._texCount=0;
			for (var y=0;y < this._height;y++){
				this._rowInfo[y].spaceCount=this._width;
			}
			for (var i=0;i < this._height;i++){
				for (var j=0;j < this._width;j++){
					var tm=(i *this._width+j)*3;
					this._cells[tm]=0;
					this._cells[tm+1]=this._width-j;
					this._cells[tm+2]=this._width-i;
				}
			}
			this._failSize.width=this._width+1;
			this._failSize.height=this._height+1;
		}

		AtlasGrid.__init$=function(){
			//------------------------------------------------------------------------------
			//class TexRowInfo
			TexRowInfo=(function(){
				function TexRowInfo(){
					this.spaceCount=0;
				}
				__class(TexRowInfo,'');
				return TexRowInfo;
			})()
			//------------------------------------------------------------------------------
			//class TexMergeTexSize
			TexMergeTexSize=(function(){
				function TexMergeTexSize(){
					this.width=0;
					this.height=0;
				}
				__class(TexMergeTexSize,'');
				return TexMergeTexSize;
			})()
		}

		return AtlasGrid;
	})()


	//class laya.webgl.atlas.AtlasResourceManager
	var AtlasResourceManager=(function(){
		function AtlasResourceManager(width,height,gridSize,maxTexNum){
			this._currentAtlasCount=0;
			this._maxAtlaserCount=0;
			this._width=0;
			this._height=0;
			this._gridSize=0;
			this._gridNumX=0;
			this._gridNumY=0;
			this._init=false;
			this._curAtlasIndex=0;
			this._setAtlasParam=false;
			this._atlaserArray=null;
			this._needGC=false;
			this._setAtlasParam=true;
			this._width=width;
			this._height=height;
			this._gridSize=gridSize;
			this._maxAtlaserCount=maxTexNum;
			this._gridNumX=width / gridSize;
			this._gridNumY=height / gridSize;
			this._curAtlasIndex=0;
			this._atlaserArray=[];
		}

		__class(AtlasResourceManager,'laya.webgl.atlas.AtlasResourceManager');
		var __proto=AtlasResourceManager.prototype;
		__proto.setAtlasParam=function(width,height,gridSize,maxTexNum){
			if (this._setAtlasParam==true){
				AtlasResourceManager._sid_=0;
				this._width=width;
				this._height=height;
				this._gridSize=gridSize;
				this._maxAtlaserCount=maxTexNum;
				this._gridNumX=width / gridSize;
				this._gridNumY=height / gridSize;
				this._curAtlasIndex=0;
				this.freeAll();
				return true;
				}else {
				console.log("设置大图合集参数错误，只能在开始页面设置各种参数");
				throw-1;
				return false;
			}
			return false;
		}

		//添加 图片到大图集
		__proto.pushData=function(texture){
			var tex=texture;
			this._setAtlasParam=false;
			var bFound=false;
			var nImageGridX=(Math.ceil((texture.bitmap.width+2)/ this._gridSize));
			var nImageGridY=(Math.ceil((texture.bitmap.height+2)/ this._gridSize));
			var bSuccess=false;
			for (var k=0;k < 2;k++){
				var maxAtlaserCount=this._maxAtlaserCount;
				for (var i=0;i < maxAtlaserCount;i++){
					var altasIndex=(this._curAtlasIndex+i)% maxAtlaserCount;
					(this._atlaserArray.length-1>=altasIndex)|| (this._atlaserArray.push(new Atlaser(this._gridNumX,this._gridNumY,this._width,this._height,AtlasResourceManager._sid_++)));
					var atlas=this._atlaserArray[altasIndex];
					var bitmap=texture.bitmap;
					var webGLImageIndex=atlas.inAtlasWebGLImagesKey.indexOf(bitmap);
					var offsetX=0,offsetY=0;
					if (webGLImageIndex==-1){
						var fillInfo=atlas.addTex(1,nImageGridX,nImageGridY);
						if (fillInfo.ret){
							offsetX=fillInfo.x *this._gridSize+1;
							offsetY=fillInfo.y *this._gridSize+1;
							bitmap.lock=true;
							atlas.addToAtlasTexture((bitmap),offsetX,offsetY);
							atlas.addToAtlas(texture,offsetX,offsetY);
							bSuccess=true;
							this._curAtlasIndex=altasIndex;
							break ;
						}
						}else {
						var offset=atlas.InAtlasWebGLImagesOffsetValue[webGLImageIndex];
						offsetX=offset[0];
						offsetY=offset[1];
						atlas.addToAtlas(texture,offsetX,offsetY);
						bSuccess=true;
						this._curAtlasIndex=altasIndex;
						break ;
					}
				}
				if (bSuccess)
					break ;
				this._atlaserArray.push(new Atlaser(this._gridNumX,this._gridNumY,this._width,this._height,AtlasResourceManager._sid_++));
				this._needGC=true;
				this.garbageCollection();
				this._curAtlasIndex=this._atlaserArray.length-1;
			}
			if (!bSuccess){
				console.log(">>>AtlasManager pushData error");
			}
			return bSuccess;
		}

		__proto.addToAtlas=function(tex){
			laya.webgl.atlas.AtlasResourceManager.instance.pushData(tex);
		}

		/**
		*回收大图合集,不建议手动调用
		*@return
		*/
		__proto.garbageCollection=function(){
			if (this._needGC===true){
				var n=this._atlaserArray.length-this._maxAtlaserCount;
				for (var i=0;i < n;i++)
				this._atlaserArray[i].dispose();
				this._atlaserArray.splice(0,n);
				this._needGC=false;
			}
			return true;
		}

		__proto.freeAll=function(){
			for (var i=0,n=this._atlaserArray.length;i < n;i++){
				this._atlaserArray[i].dispose();
			}
			this._atlaserArray.length=0;
			this._curAtlasIndex=0;
		}

		__proto.getAtlaserCount=function(){
			return this._atlaserArray.length;
		}

		__proto.getAtlaserByIndex=function(index){
			return this._atlaserArray[index];
		}

		__getset(1,AtlasResourceManager,'instance',function(){
			if (!AtlasResourceManager._Instance){
				AtlasResourceManager._Instance=new AtlasResourceManager(laya.webgl.atlas.AtlasResourceManager.atlasTextureWidth,laya.webgl.atlas.AtlasResourceManager.atlasTextureHeight,16,laya.webgl.atlas.AtlasResourceManager.maxTextureCount);
			}
			return AtlasResourceManager._Instance;
		});

		__getset(1,AtlasResourceManager,'enabled',function(){
			return AtlasResourceManager._enabled;
		});

		__getset(1,AtlasResourceManager,'atlasLimitWidth',function(){
			return AtlasResourceManager._atlasLimitWidth;
			},function(value){
			AtlasResourceManager._atlasLimitWidth=value;
		});

		__getset(1,AtlasResourceManager,'atlasLimitHeight',function(){
			return AtlasResourceManager._atlasLimitHeight;
			},function(value){
			AtlasResourceManager._atlasLimitHeight=value;
		});

		AtlasResourceManager._enable=function(){
			AtlasResourceManager._enabled=true;
			Config.atlasEnable=true;
		}

		AtlasResourceManager._disable=function(){
			AtlasResourceManager._enabled=false;
			Config.atlasEnable=false;
		}

		AtlasResourceManager.__init__=function(){
			AtlasResourceManager.atlasTextureWidth=2048;
			AtlasResourceManager.atlasTextureHeight=2048;
			AtlasResourceManager.maxTextureCount=6;
			AtlasResourceManager.atlasLimitWidth=512;
			AtlasResourceManager.atlasLimitHeight=512;
		}

		AtlasResourceManager._enabled=false;
		AtlasResourceManager._atlasLimitWidth=0;
		AtlasResourceManager._atlasLimitHeight=0;
		AtlasResourceManager.gridSize=16;
		AtlasResourceManager.atlasTextureWidth=0;
		AtlasResourceManager.atlasTextureHeight=0;
		AtlasResourceManager.maxTextureCount=0;
		AtlasResourceManager._atlasRestore=0;
		AtlasResourceManager.BOARDER_TYPE_NO=0;
		AtlasResourceManager.BOARDER_TYPE_RIGHT=1;
		AtlasResourceManager.BOARDER_TYPE_LEFT=2;
		AtlasResourceManager.BOARDER_TYPE_BOTTOM=4;
		AtlasResourceManager.BOARDER_TYPE_TOP=8;
		AtlasResourceManager.BOARDER_TYPE_ALL=15;
		AtlasResourceManager._sid_=0;
		AtlasResourceManager._Instance=null;
		return AtlasResourceManager;
	})()


	//class laya.webgl.atlas.MergeFillInfo
	var MergeFillInfo=(function(){
		function MergeFillInfo(){
			this.x=0;
			this.y=0;
			this.ret=false;
			this.ret=false;
			this.x=0;
			this.y=0;
		}

		__class(MergeFillInfo,'laya.webgl.atlas.MergeFillInfo');
		return MergeFillInfo;
	})()


	;
	//class laya.webgl.canvas.BlendMode
	var BlendMode=(function(){
		function BlendMode(){};
		__class(BlendMode,'laya.webgl.canvas.BlendMode');
		BlendMode._init_=function(gl){
			BlendMode.fns=[BlendMode.BlendNormal,BlendMode.BlendAdd,BlendMode.BlendMultiply,BlendMode.BlendScreen,BlendMode.BlendOverlay,BlendMode.BlendLight,BlendMode.BlendMask,BlendMode.BlendDestinationOut];
			BlendMode.targetFns=[BlendMode.BlendNormalTarget,BlendMode.BlendAddTarget,BlendMode.BlendMultiplyTarget,BlendMode.BlendScreenTarget,BlendMode.BlendOverlayTarget,BlendMode.BlendLightTarget,BlendMode.BlendMask,BlendMode.BlendDestinationOut];
		}

		BlendMode.BlendNormal=function(gl){
			gl.blendFuncSeparate(0x0302,0x0303,1,1);
		}

		BlendMode.BlendAdd=function(gl){
			gl.blendFunc(0x0302,0x0304);
		}

		BlendMode.BlendMultiply=function(gl){
			gl.blendFunc(0x0306,0x0303);
		}

		BlendMode.BlendScreen=function(gl){
			gl.blendFunc(0x0302,1);
		}

		BlendMode.BlendOverlay=function(gl){
			gl.blendFunc(1,0x0301);
		}

		BlendMode.BlendLight=function(gl){
			gl.blendFunc(0x0302,1);
		}

		BlendMode.BlendNormalTarget=function(gl){
			gl.blendFuncSeparate(0x0302,0x0303,1,0x0303);
		}

		BlendMode.BlendAddTarget=function(gl){
			gl.blendFunc(0x0302,0x0304);
		}

		BlendMode.BlendMultiplyTarget=function(gl){
			gl.blendFunc(0x0306,0x0303);
		}

		BlendMode.BlendScreenTarget=function(gl){
			gl.blendFunc(0x0302,1);
		}

		BlendMode.BlendOverlayTarget=function(gl){
			gl.blendFunc(1,0x0301);
		}

		BlendMode.BlendLightTarget=function(gl){
			gl.blendFunc(0x0302,1);
		}

		BlendMode.BlendMask=function(gl){
			gl.blendFunc(0,0x0302);
		}

		BlendMode.BlendDestinationOut=function(gl){
			gl.blendFunc(0,0);
		}

		BlendMode.activeBlendFunction=null;
		BlendMode.NAMES=["normal","add","multiply","screen","overlay","light","mask","destination-out"];
		BlendMode.TOINT={"normal":0,"add":1,"multiply":2,"screen":3 ,"lighter":1,"overlay":4,"light":5,"mask":6,"destination-out":7};
		BlendMode.NORMAL="normal";
		BlendMode.ADD="add";
		BlendMode.MULTIPLY="multiply";
		BlendMode.SCREEN="screen";
		BlendMode.LIGHT="light";
		BlendMode.OVERLAY="overlay";
		BlendMode.DESTINATIONOUT="destination-out";
		BlendMode.fns=[];
		BlendMode.targetFns=[];
		return BlendMode;
	})()


	//class laya.webgl.canvas.DrawStyle
	var DrawStyle=(function(){
		function DrawStyle(value){
			this._color=Color.create("black");
			this.setValue(value);
		}

		__class(DrawStyle,'laya.webgl.canvas.DrawStyle');
		var __proto=DrawStyle.prototype;
		__proto.setValue=function(value){
			if (value){
				if ((typeof value=='string')){
					this._color=Color.create(value);
					return;
				}
				if ((value instanceof laya.utils.Color )){
					this._color=value;
					return;
				}
			}
		}

		__proto.reset=function(){
			this._color=Color.create("black");
		}

		__proto.equal=function(value){
			if ((typeof value=='string'))return this._color.strColor===value;
			if ((value instanceof laya.utils.Color ))return this._color.numColor===(value).numColor;
			return false;
		}

		__proto.toColorStr=function(){
			return this._color.strColor;
		}

		DrawStyle.create=function(value){
			if (value){
				var color;
				if ((typeof value=='string'))color=Color.create(value);
				else if ((value instanceof laya.utils.Color ))color=value;
				if (color){
					return color._drawStyle || (color._drawStyle=new DrawStyle(value));
				}
			}
			return null;
		}

		__static(DrawStyle,
		['DEFAULT',function(){return this.DEFAULT=new DrawStyle("#000000");}
		]);
		return DrawStyle;
	})()


	//class laya.webgl.canvas.Path
	var Path=(function(){
		function Path(){
			this._x=0;
			this._y=0;
			//this._rect=null;
			//this.ib=null;
			//this.vb=null;
			this.dirty=false;
			//this.geomatrys=null;
			//this._curGeomatry=null;
			this.offset=0;
			this.count=0;
			this.geoStart=0;
			this.tempArray=[];
			this.closePath=false;
			this.geomatrys=[];
			var gl=WebGL.mainContext;
			this.ib=IndexBuffer2D.create(0x88E8);
			this.vb=VertexBuffer2D.create(5);
		}

		__class(Path,'laya.webgl.canvas.Path');
		var __proto=Path.prototype;
		__proto.addPoint=function(pointX,pointY){
			this.tempArray.push(pointX,pointY);
		}

		__proto.getEndPointX=function(){
			return this.tempArray[this.tempArray.length-2];
		}

		__proto.getEndPointY=function(){
			return this.tempArray[this.tempArray.length-1];
		}

		__proto.polygon=function(x,y,points,color,borderWidth,borderColor){
			var geo;
			this.geomatrys.push(this._curGeomatry=geo=new Polygon(x,y,points,color,borderWidth,borderColor));
			if (!color)geo.fill=false;
			if (borderColor==undefined)geo.borderWidth=0;
			return geo;
		}

		__proto.setGeomtry=function(shape){
			this.geomatrys.push(this._curGeomatry=shape);
		}

		__proto.drawLine=function(x,y,points,width,color){
			var geo;
			if (this.closePath){
				this.geomatrys.push(this._curGeomatry=geo=new LoopLine(x,y,points,width,color));
				}else {
				this.geomatrys.push(this._curGeomatry=geo=new Line(x,y,points,width,color));
			}
			geo.fill=false;
			return geo;
		}

		__proto.update=function(){
			var si=this.ib.byteLength;
			var len=this.geomatrys.length;
			this.offset=si;
			for (var i=this.geoStart;i < len;i++){
				this.geomatrys[i].getData(this.ib,this.vb,this.vb.byteLength / 20);
			}
			this.geoStart=len;
			this.count=(this.ib.byteLength-si)/ CONST3D2D.BYTES_PIDX;
		}

		__proto.reset=function(){
			this.vb.clear();
			this.ib.clear();
			this.offset=this.count=this.geoStart=0;
			this.geomatrys.length=0;
		}

		__proto.recover=function(){
			this._curGeomatry=null;
			this.vb.destory();
			this.vb=null;
			this.ib.destory();
			this.ib=null;
		}

		return Path;
	})()


	//class laya.webgl.canvas.save.SaveBase
	var SaveBase=(function(){
		function SaveBase(){
			//this._valueName=null;
			//this._value=null;
			//this._dataObj=null;
			//this._newSubmit=false;
		}

		__class(SaveBase,'laya.webgl.canvas.save.SaveBase');
		var __proto=SaveBase.prototype;
		Laya.imps(__proto,{"laya.webgl.canvas.save.ISaveData":true})
		__proto.isSaveMark=function(){return false;}
		__proto.restore=function(context){
			this._dataObj[this._valueName]=this._value;
			SaveBase._cache[SaveBase._cache._length++]=this;
			this._newSubmit && (context._curSubmit=Submit.RENDERBASE,context._renderKey=0);
		}

		SaveBase._createArray=function(){
			var value=[];
			value._length=0;
			return value;
		}

		SaveBase._init=function(){
			var namemap=SaveBase._namemap={};
			namemap[0x1]="ALPHA";
			namemap[0x2]="fillStyle";
			namemap[0x8]="font";
			namemap[0x100]="lineWidth";
			namemap[0x200]="strokeStyle";
			namemap[0x2000]="_mergeID";
			namemap[0x400]=namemap[0x800]=namemap[0x1000]=[];
			namemap[0x4000]="textBaseline";
			namemap[0x8000]="textAlign";
			namemap[0x10000]="_nBlendType";
			namemap[0x80000]="shader";
			namemap[0x100000]="filters";
			return namemap;
		}

		SaveBase.save=function(context,type,dataObj,newSubmit){
			if ((context._saveMark._saveuse & type)!==type){
				context._saveMark._saveuse |=type;
				var cache=SaveBase._cache;
				var o=cache._length > 0 ? cache[--cache._length] :(new SaveBase());
				o._value=dataObj[o._valueName=SaveBase._namemap[type]];
				o._dataObj=dataObj;
				o._newSubmit=newSubmit;
				var _save=context._save;
				_save[_save._length++]=o;
			}
		}

		SaveBase._cache=laya.webgl.canvas.save.SaveBase._createArray();
		SaveBase._namemap=SaveBase._init();
		return SaveBase;
	})()


	//class laya.webgl.canvas.save.SaveClipRect
	var SaveClipRect=(function(){
		function SaveClipRect(){
			//this._clipSaveRect=null;
			//this._submitScissor=null;
			this._clipRect=new Rectangle();
		}

		__class(SaveClipRect,'laya.webgl.canvas.save.SaveClipRect');
		var __proto=SaveClipRect.prototype;
		Laya.imps(__proto,{"laya.webgl.canvas.save.ISaveData":true})
		__proto.isSaveMark=function(){return false;}
		__proto.restore=function(context){
			context._clipRect=this._clipSaveRect;
			SaveClipRect._cache[SaveClipRect._cache._length++]=this;
			this._submitScissor.submitLength=context._submits._length-this._submitScissor.submitIndex;
			context._curSubmit=Submit.RENDERBASE;
			context._renderKey=0;
		}

		SaveClipRect.save=function(context,submitScissor){
			if ((context._saveMark._saveuse & 0x20000)==0x20000)return;
			context._saveMark._saveuse |=0x20000;
			var cache=SaveClipRect._cache;
			var o=cache._length > 0 ? cache[--cache._length] :(new SaveClipRect());
			o._clipSaveRect=context._clipRect;
			context._clipRect=o._clipRect.copyFrom(context._clipRect);
			o._submitScissor=submitScissor;
			var _save=context._save;
			_save[_save._length++]=o;
		}

		SaveClipRect._cache=SaveBase._createArray();
		return SaveClipRect;
	})()


	//class laya.webgl.canvas.save.SaveMark
	var SaveMark=(function(){
		function SaveMark(){
			this._saveuse=0;
			//this._preSaveMark=null;
			;
		}

		__class(SaveMark,'laya.webgl.canvas.save.SaveMark');
		var __proto=SaveMark.prototype;
		Laya.imps(__proto,{"laya.webgl.canvas.save.ISaveData":true})
		__proto.isSaveMark=function(){
			return true;
		}

		__proto.restore=function(context){
			context._saveMark=this._preSaveMark;
			SaveMark._no[SaveMark._no._length++]=this;
		}

		SaveMark.Create=function(context){
			var no=SaveMark._no;
			var o=no._length > 0 ? no[--no._length] :(new SaveMark());
			o._saveuse=0;
			o._preSaveMark=context._saveMark;
			context._saveMark=o;
			return o;
		}

		SaveMark._no=SaveBase._createArray();
		return SaveMark;
	})()


	//class laya.webgl.canvas.save.SaveTransform
	var SaveTransform=(function(){
		function SaveTransform(){
			//this._savematrix=null;
			this._matrix=new Matrix();
		}

		__class(SaveTransform,'laya.webgl.canvas.save.SaveTransform');
		var __proto=SaveTransform.prototype;
		Laya.imps(__proto,{"laya.webgl.canvas.save.ISaveData":true})
		__proto.isSaveMark=function(){return false;}
		__proto.restore=function(context){
			context._curMat=this._savematrix;
			SaveTransform._no[SaveTransform._no._length++]=this;
		}

		SaveTransform.save=function(context){
			var _saveMark=context._saveMark;
			if ((_saveMark._saveuse & 0x800)===0x800)return;
			_saveMark._saveuse |=0x800;
			var no=SaveTransform._no;
			var o=no._length > 0 ? no[--no._length] :(new SaveTransform());
			o._savematrix=context._curMat;
			context._curMat=context._curMat.copyTo(o._matrix);
			var _save=context._save;
			_save[_save._length++]=o;
		}

		SaveTransform._no=SaveBase._createArray();
		return SaveTransform;
	})()


	//class laya.webgl.canvas.save.SaveTranslate
	var SaveTranslate=(function(){
		function SaveTranslate(){
			//this._x=NaN;
			//this._y=NaN;
		}

		__class(SaveTranslate,'laya.webgl.canvas.save.SaveTranslate');
		var __proto=SaveTranslate.prototype;
		Laya.imps(__proto,{"laya.webgl.canvas.save.ISaveData":true})
		__proto.isSaveMark=function(){return false;}
		__proto.restore=function(context){
			var mat=context._curMat;
			context._x=this._x;
			context._y=this._y;
			SaveTranslate._no[SaveTranslate._no._length++]=this;
		}

		SaveTranslate.save=function(context){
			var no=SaveTranslate._no;
			var o=no._length > 0 ? no[--no._length] :(new SaveTranslate());
			o._x=context._x;
			o._y=context._y;
			var _save=context._save;
			_save[_save._length++]=o;
		}

		SaveTranslate._no=SaveBase._createArray();
		return SaveTranslate;
	})()


	//class laya.webgl.resource.RenderTargetMAX
	var RenderTargetMAX=(function(){
		function RenderTargetMAX(){
			this.target=null;
			this.repaint=false;
			this._width=NaN;
			this._height=NaN;
			this._sp=null;
			this._clipRect=new Rectangle();
		}

		__class(RenderTargetMAX,'laya.webgl.resource.RenderTargetMAX');
		var __proto=RenderTargetMAX.prototype;
		__proto.setSP=function(sp){
			this._sp=sp;
		}

		__proto.size=function(w,h){
			var _$this=this;
			if (this._width===w && this._height===h){
				this.target.size(w,h);
				return;
			}
			this.repaint=true;
			this._width=w;
			this._height=h;
			if (!this.target)
				this.target=RenderTarget2D.create(w,h);
			else
			this.target.size(w,h);
			if (!this.target.hasListener("recovered")){
				this.target.on("recovered",this,function(e){
					Laya.timer.callLater(_$this._sp,_$this._sp.repaint);
				});
			}
		}

		__proto._flushToTarget=function(context,target){
			if (target._destroy)return;
			var worldScissorTest=RenderState2D.worldScissorTest;
			var preworldClipRect=RenderState2D.worldClipRect;
			RenderState2D.worldClipRect=this._clipRect;
			this._clipRect.x=this._clipRect.y=0;
			this._clipRect.width=this._width;
			this._clipRect.height=this._height;
			RenderState2D.worldScissorTest=false;
			WebGL.mainContext.disable(0x0C11);
			var preAlpha=RenderState2D.worldAlpha;
			var preMatrix4=RenderState2D.worldMatrix4;
			var preMatrix=RenderState2D.worldMatrix;
			var preFilters=RenderState2D.worldFilters;
			var preShaderDefines=RenderState2D.worldShaderDefines;
			RenderState2D.worldMatrix=Matrix.EMPTY;
			RenderState2D.restoreTempArray();
			RenderState2D.worldMatrix4=RenderState2D.TEMPMAT4_ARRAY;
			RenderState2D.worldAlpha=1;
			RenderState2D.worldFilters=null;
			RenderState2D.worldShaderDefines=null;
			BaseShader.activeShader=null;
			target.start();
			Config.showCanvasMark ? target.clear(0,1,0,0.3):target.clear(0,0,0,0);
			context.flush();
			target.end();
			BaseShader.activeShader=null;
			RenderState2D.worldAlpha=preAlpha;
			RenderState2D.worldMatrix4=preMatrix4;
			RenderState2D.worldMatrix=preMatrix;
			RenderState2D.worldFilters=preFilters;
			RenderState2D.worldShaderDefines=preShaderDefines;
			RenderState2D.worldScissorTest=worldScissorTest
			if (worldScissorTest){
				var y=RenderState2D.height-preworldClipRect.y-preworldClipRect.height;
				WebGL.mainContext.scissor(preworldClipRect.x,y,preworldClipRect.width,preworldClipRect.height);
				WebGL.mainContext.enable(0x0C11);
			}
			RenderState2D.worldClipRect=preworldClipRect;
		}

		__proto.flush=function(context){
			if (this.repaint){
				this._flushToTarget(context,this.target);
				this.repaint=false;
			}
		}

		__proto.drawTo=function(context,x,y,width,height){
			context.drawTexture(this.target.getTexture(),x,y,width,height,0,0);
		}

		__proto.destroy=function(){
			if (this.target){
				this.target.destroy();
				this.target=null;
				this._sp=null;
			}
		}

		return RenderTargetMAX;
	})()


	//class laya.webgl.shader.d2.Shader2D
	var Shader2D=(function(){
		function Shader2D(){
			this.ALPHA=1;
			//this.glTexture=null;
			//this.shader=null;
			//this.filters=null;
			this.shaderType=0;
			//this.colorAdd=null;
			//this.strokeStyle=null;
			//this.fillStyle=null;
			this.defines=new ShaderDefines2D();
		}

		__class(Shader2D,'laya.webgl.shader.d2.Shader2D');
		Shader2D.__init__=function(){
			Shader.addInclude("parts/ColorFilter_ps_uniform.glsl","uniform vec4 colorAlpha;\nuniform mat4 colorMat;");
			Shader.addInclude("parts/ColorFilter_ps_logic.glsl","gl_FragColor = gl_FragColor * colorMat + colorAlpha/255.0;");
			Shader.addInclude("parts/GlowFilter_ps_uniform.glsl","uniform vec4 u_color;\nuniform float u_strength;\nuniform float u_blurX;\nuniform float u_blurY;\nuniform float u_offsetX;\nuniform float u_offsetY;\nuniform float u_textW;\nuniform float u_textH;");
			Shader.addInclude("parts/GlowFilter_ps_logic.glsl","const float c_IterationTime = 10.0;\nfloat floatIterationTotalTime = c_IterationTime * c_IterationTime;\nvec4 vec4Color = vec4(0.0,0.0,0.0,0.0);\nvec2 vec2FilterDir = vec2(-(u_offsetX)/u_textW,-(u_offsetY)/u_textH);\nvec2 vec2FilterOff = vec2(u_blurX/u_textW/c_IterationTime * 2.0,u_blurY/u_textH/c_IterationTime * 2.0);\nfloat maxNum = u_blurX * u_blurY;\nvec2 vec2Off = vec2(0.0,0.0);\nfloat floatOff = c_IterationTime/2.0;\nfor(float i = 0.0;i<=c_IterationTime; ++i){\n	for(float j = 0.0;j<=c_IterationTime; ++j){\n		vec2Off = vec2(vec2FilterOff.x * (i - floatOff),vec2FilterOff.y * (j - floatOff));\n		vec4Color += texture2D(texture, v_texcoord + vec2FilterDir + vec2Off)/floatIterationTotalTime;\n	}\n}\ngl_FragColor = vec4(u_color.rgb,vec4Color.a * u_strength);");
			Shader.addInclude("parts/BlurFilter_ps_logic.glsl","gl_FragColor =   blur();\ngl_FragColor.w*=alpha;");
			Shader.addInclude("parts/BlurFilter_ps_uniform.glsl","uniform float strength;\nuniform vec2 blurInfo;\n\n#define PI 3.141593\n\nfloat sigma=strength/3.0;//3σ以外影响很小。即当σ=1的时候，半径为3\nfloat sig2 = sigma*sigma;\nfloat _2sig2 = 2.0*sig2;\n//return 1.0/(2*PI*sig2)*exp(-(x*x+y*y)/_2sig2)\nfloat gauss1 = 1.0/(2.0*PI*sig2);\n\nfloat getGaussian(float x, float y){\n    return gauss1*exp(-(x*x+y*y)/_2sig2);\n}\n\nvec4 blur(){\n    const float blurw = 9.0;\n    vec4 vec4Color = vec4(0.0,0.0,0.0,0.0);\n    vec2 halfsz=vec2(blurw,blurw)/2.0/blurInfo;    \n    vec2 startpos=v_texcoord-halfsz;\n    vec2 ctexcoord = startpos;\n    vec2 step = 1.0/blurInfo;  //每个像素      \n    \n    for(float y = 0.0;y<=blurw; ++y){\n        ctexcoord.x=startpos.x;\n        for(float x = 0.0;x<=blurw; ++x){\n            //TODO 纹理坐标的固定偏移应该在vs中处理\n            vec4Color += texture2D(texture, ctexcoord)*getGaussian(x-blurw/2.0,y-blurw/2.0);\n            ctexcoord.x+=step.x;\n        }\n        ctexcoord.y+=step.y;\n    }\n    return vec4Color;\n}");
			Shader.addInclude("parts/ColorAdd_ps_uniform.glsl","uniform vec4 colorAdd;\n");
			Shader.addInclude("parts/ColorAdd_ps_logic.glsl","gl_FragColor = vec4(colorAdd.rgb,colorAdd.a*gl_FragColor.a);");
			var vs,ps;
			vs="attribute vec4 position;\nattribute vec2 texcoord;\nuniform vec2 size;\n\n#ifdef WORLDMAT\nuniform mat4 mmat;\n#endif\nvarying vec2 v_texcoord;\nvoid main() {\n  #ifdef WORLDMAT\n  vec4 pos=mmat*position;\n  gl_Position =vec4((pos.x/size.x-0.5)*2.0,(0.5-pos.y/size.y)*2.0,pos.z,1.0);\n  #else\n  gl_Position =vec4((position.x/size.x-0.5)*2.0,(0.5-position.y/size.y)*2.0,position.z,1.0);\n  #endif\n  \n  v_texcoord = texcoord;\n}";
			ps="precision mediump float;\n//precision highp float;\nvarying vec2 v_texcoord;\nuniform sampler2D texture;\nuniform float alpha;\n#include?BLUR_FILTER  \"parts/BlurFilter_ps_uniform.glsl\";\n#include?COLOR_FILTER \"parts/ColorFilter_ps_uniform.glsl\";\n#include?GLOW_FILTER \"parts/GlowFilter_ps_uniform.glsl\";\n#include?COLOR_ADD \"parts/ColorAdd_ps_uniform.glsl\";\n\nvoid main() {\n   vec4 color= texture2D(texture, v_texcoord);\n   color.a*=alpha;\n   gl_FragColor=color;\n   #include?COLOR_ADD \"parts/ColorAdd_ps_logic.glsl\";   \n   #include?BLUR_FILTER  \"parts/BlurFilter_ps_logic.glsl\";\n   #include?COLOR_FILTER \"parts/ColorFilter_ps_logic.glsl\";\n   #include?GLOW_FILTER \"parts/GlowFilter_ps_logic.glsl\";\n}";
			Shader.preCompile2D(0,0x01,vs,ps,null);
			vs="attribute vec4 position;\nuniform vec2 size;\nuniform mat4 mmat;\nvoid main() {\n  vec4 pos=mmat*position;\n  gl_Position =vec4((pos.x/size.x-0.5)*2.0,(0.5-pos.y/size.y)*2.0,pos.z,1.0);\n}";
			ps="precision mediump float;\nuniform vec4 color;\nuniform float alpha;\n#include?COLOR_FILTER \"parts/ColorFilter_ps_uniform.glsl\";\nvoid main() {\n	vec4 a = vec4(color.r, color.g, color.b, color.a);\n	a.w = alpha;\n	gl_FragColor = a;\n	#include?COLOR_FILTER \"parts/ColorFilter_ps_logic.glsl\";\n}";
			Shader.preCompile2D(0,0x02,vs,ps,null);
			vs="attribute vec4 position;\nattribute vec3 a_color;\nuniform mat4 mmat;\nuniform mat4 u_mmat2;\nuniform vec2 u_pos;\nuniform vec2 size;\nvarying vec3 color;\nvoid main(){\n  vec4 tPos = vec4(position.x + u_pos.x,position.y + u_pos.y,position.z,position.w);\n  vec4 pos=mmat*u_mmat2*tPos;\n  gl_Position =vec4((pos.x/size.x-0.5)*2.0,(0.5-pos.y/size.y)*2.0,pos.z,1.0);\n  color=a_color;\n}";
			ps="precision mediump float;\n//precision mediump float;\nvarying vec3 color;\nuniform float alpha;\nvoid main(){\n	//vec4 a=vec4(color.r, color.g, color.b, 1);\n	//a.a*=alpha;\n    gl_FragColor=vec4(color.r, color.g, color.b, alpha);\n}";
			Shader.preCompile2D(0,0x04,vs,ps,null);
			vs="attribute vec4 position;\nattribute vec2 texcoord;\nuniform vec2 size;\n\n#ifdef WORLDMAT\nuniform mat4 mmat;\n#endif\nvarying vec2 v_texcoord;\nvoid main() {\n  #ifdef WORLDMAT\n  vec4 pos=mmat*position;\n  gl_Position =vec4((pos.x/size.x-0.5)*2.0,(0.5-pos.y/size.y)*2.0,pos.z,1.0);\n  #else\n  gl_Position =vec4((position.x/size.x-0.5)*2.0,(0.5-position.y/size.y)*2.0,position.z,1.0);\n  #endif\n  \n  v_texcoord = texcoord;\n}";
			ps="#ifdef FSHIGHPRECISION\nprecision highp float;\n#else\nprecision mediump float;\n#endif\n//precision highp float;\nvarying vec2 v_texcoord;\nuniform sampler2D texture;\nuniform float alpha;\nuniform vec4 u_TexRange;\nuniform vec2 u_offset;\n#include?BLUR_FILTER  \"parts/BlurFilter_ps_uniform.glsl\";\n#include?COLOR_FILTER \"parts/ColorFilter_ps_uniform.glsl\";\n#include?GLOW_FILTER \"parts/GlowFilter_ps_uniform.glsl\";\n#include?COLOR_ADD \"parts/ColorAdd_ps_uniform.glsl\";\n\nvoid main() {\n   vec2 newTexCoord;\n   newTexCoord.x = mod(u_offset.x + v_texcoord.x,u_TexRange.y) + u_TexRange.x;\n   newTexCoord.y = mod(u_offset.y + v_texcoord.y,u_TexRange.w) + u_TexRange.z;\n   vec4 color= texture2D(texture, newTexCoord);\n   color.a*=alpha;\n   gl_FragColor=color;\n   #include?COLOR_ADD \"parts/ColorAdd_ps_logic.glsl\";   \n   #include?BLUR_FILTER  \"parts/BlurFilter_ps_logic.glsl\";\n   #include?COLOR_FILTER \"parts/ColorFilter_ps_logic.glsl\";\n   #include?GLOW_FILTER \"parts/GlowFilter_ps_logic.glsl\";\n}";
			Shader.preCompile2D(0,0x100,vs,ps,null);
			vs="attribute vec2 position;\nattribute vec2 texcoord;\nattribute vec4 color;\nuniform vec2 size;\nuniform float offsetX;\nuniform float offsetY;\nuniform mat4 mmat;\nuniform mat4 u_mmat2;\nvarying vec2 v_texcoord;\nvarying vec4 v_color;\nvoid main() {\n  vec4 pos=mmat*u_mmat2*vec4(offsetX+position.x,offsetY+position.y,0,1 );\n  gl_Position = vec4((pos.x/size.x-0.5)*2.0,(0.5-pos.y/size.y)*2.0,pos.z,1.0);\n  v_color = color;\n  v_texcoord = texcoord;  \n}";
			ps="precision mediump float;\nvarying vec2 v_texcoord;\nvarying vec4 v_color;\nuniform sampler2D texture;\nuniform float alpha;\nvoid main() {\n	vec4 t_color = texture2D(texture, v_texcoord);\n	gl_FragColor = t_color.rgba * v_color;\n	gl_FragColor.a = gl_FragColor.a * alpha;\n}";
			Shader.preCompile2D(0,0x200,vs,ps,null);
		}

		return Shader2D;
	})()


	//class laya.webgl.shader.ShaderDefines
	var ShaderDefines=(function(){
		function ShaderDefines(name2int,int2name,int2nameMap){
			this._value=0;
			//this._name2int=null;
			//this._int2name=null;
			//this._int2nameMap=null;
			this._name2int=name2int;
			this._int2name=int2name;
			this._int2nameMap=int2nameMap;
		}

		__class(ShaderDefines,'laya.webgl.shader.ShaderDefines');
		var __proto=ShaderDefines.prototype;
		__proto.add=function(value){
			if ((typeof value=='string'))value=this._name2int[value];
			this._value |=value;
			return this._value;
		}

		__proto.addInt=function(value){
			this._value |=value;
			return this._value;
		}

		__proto.remove=function(value){
			if ((typeof value=='string'))value=this._name2int[value];
			this._value &=(~value);
			return this._value;
		}

		__proto.isDefine=function(def){
			return (this._value & def)===def;
		}

		__proto.getValue=function(){
			return this._value;
		}

		__proto.setValue=function(value){
			this._value=value;
		}

		__proto.toNameDic=function(){
			var r=this._int2nameMap[this._value];
			return r ? r :ShaderDefines._toText(this._value,this._int2name,this._int2nameMap);
		}

		ShaderDefines._reg=function(name,value,_name2int,_int2name){
			_name2int[name]=value;
			_int2name[value]=name;
		}

		ShaderDefines._toText=function(value,_int2name,_int2nameMap){
			var r=_int2nameMap[value];
			if (r)return r;
			var o={};
			var d=1;
			for (var i=0;i < 32;i++){
				d=1 << i;
				if (d > value)break ;
				if (value & d){
					var name=_int2name[d];
					name && (o[name]="");
				}
			}
			_int2nameMap[value]=o;
			return o;
		}

		ShaderDefines._toInt=function(names,_name2int){
			var words=names.split('.');
			var num=0;
			for (var i=0,n=words.length;i < n;i++){
				var value=_name2int[words[i]];
				if (!value)throw new Error("Defines to int err:"+names+"/"+words[i]);
				num |=value;
			}
			return num;
		}

		return ShaderDefines;
	})()


	/**
	*这里销毁的问题，后面待确认
	*/
	//class laya.webgl.shader.d2.skinAnishader.SkinMesh
	var SkinMesh=(function(){
		function SkinMesh(){
			this.mVBBuffer=null;
			this.mIBBuffer=null;
			this.mVBData=null;
			this.mIBData=null;
			this.mEleNum=0;
			this.mTexture=null;
			this.transform=null;
			this._vs=null;
			this._ps=null;
			this._indexStart=-1;
			this._verticles=null;
			this._uvs=null;
			this._tempMatrix=new Matrix();
		}

		__class(SkinMesh,'laya.webgl.shader.d2.skinAnishader.SkinMesh');
		var __proto=SkinMesh.prototype;
		__proto.init=function(texture,vs,ps){
			if (vs){
				this._vs=vs;
				}else {
				this._vs=[];
				var tWidth=texture.width;
				var tHeight=texture.height;
				var tRed=1;
				var tGreed=1;
				var tBlue=1;
				var tAlpha=1;
				this._vs.push(0,0,0,0,tRed,tGreed,tBlue,tAlpha);
				this._vs.push(tWidth,0,1,0,tRed,tGreed,tBlue,tAlpha);
				this._vs.push(tWidth,tHeight,1,1,tRed,tGreed,tBlue,tAlpha);
				this._vs.push(0,tHeight,0,1,tRed,tGreed,tBlue,tAlpha);
			}
			if (ps){
				this._ps=ps;
				}else {
				if (!SkinMesh._defaultPS){
					SkinMesh._defaultPS=[];
					SkinMesh._defaultPS.push(0,1,3,3,1,2);
				}
				this._ps=SkinMesh._defaultPS;
			}
			this.mVBData=new Float32Array(this._vs);
			this.mIBData=new Uint16Array(this._ps.length);
			this.mIBData["start"]=-1;
			this.mEleNum=this._ps.length;
			this.mTexture=texture;
		}

		__proto.init2=function(texture,vs,ps,verticles,uvs){
			if (this.transform)this.transform=null;
			if (ps){
				this._ps=ps;
				}else {
				this._ps=[];
				this._ps.push(0,1,3,3,1,2);
			}
			this._verticles=verticles;
			this._uvs=uvs;
			this.mEleNum=this._ps.length;
			this.mTexture=texture;
			if (Render.isConchNode || Render.isConchApp){
				this._initMyData();
				this.mVBData=new Float32Array(this._vs);
			}
		}

		__proto._initMyData=function(){
			var vsI=0;
			var vI=0;
			var vLen=this._verticles.length;
			var tempVLen=vLen *4;
			this._vs=SkinMesh._tempVS;
			var insertNew=false;
			if (Render.isConchNode || Render.isConchApp){
				this._vs.length=tempVLen;
				insertNew=true;
				}else{
				if (this._vs.length < tempVLen){
					this._vs.length=tempVLen;
					insertNew=true;
				}
			}
			SkinMesh._tVSLen=tempVLen;
			if (insertNew){
				while (vsI < tempVLen){
					this._vs[vsI]=this._verticles[vI];
					this._vs[vsI+1]=this._verticles[vI+1];
					this._vs[vsI+2]=this._uvs[vI];
					this._vs[vsI+3]=this._uvs[vI+1];
					this._vs[vsI+4]=1;
					this._vs[vsI+5]=1;
					this._vs[vsI+6]=1;
					this._vs[vsI+7]=1;
					vsI+=8;
					vI+=2;
				}
				}else{
				while (vsI < tempVLen){
					this._vs[vsI]=this._verticles[vI];
					this._vs[vsI+1]=this._verticles[vI+1];
					this._vs[vsI+2]=this._uvs[vI];
					this._vs[vsI+3]=this._uvs[vI+1];
					vsI+=8;
					vI+=2;
				}
			}
		}

		__proto.getData2=function(vb,ib,start){
			this.mVBBuffer=vb;
			this.mIBBuffer=ib;
			this._initMyData();
			vb.appendEx2(this._vs,Float32Array,SkinMesh._tVSLen,4);
			this._indexStart=ib.byteLength;
			var tIB;
			tIB=SkinMesh._tempIB;
			if (tIB.length < this._ps.length){
				tIB.length=this._ps.length;
			}
			for (var i=0,n=this._ps.length;i < n;i++){
				tIB[i]=this._ps[i]+start;
			}
			ib.appendEx2(tIB,Uint16Array,this._ps.length,2);
		}

		__proto.getData=function(vb,ib,start){
			this.mVBBuffer=vb;
			this.mIBBuffer=ib;
			vb.append(this.mVBData);
			this._indexStart=ib.byteLength;
			if (this.mIBData["start"] !=start){
				for (var i=0,n=this._ps.length;i < n;i++){
					this.mIBData[i]=this._ps[i]+start;
				}
				this.mIBData["start"]=start;
			}
			ib.append(this.mIBData);
		}

		__proto.render=function(context,x,y){
			if (Render.isWebGL && this.mTexture){
				context._renderKey=0;
				context._shader2D.glTexture=null;
				SkinMeshBuffer.getInstance().addSkinMesh(this);
				var tempSubmit=Submit.createShape(context,this.mIBBuffer,this.mVBBuffer,this.mEleNum,this._indexStart,Value2D.create(0x200,0));
				this.transform || (this.transform=Matrix.EMPTY);
				this.transform.translate(x,y);
				Matrix.mul(this.transform,context._curMat,this._tempMatrix);
				this.transform.translate(-x,-y);
				var tShaderValue=tempSubmit.shaderValue;
				var tArray=tShaderValue.u_mmat2||RenderState2D.getMatrArray();
				RenderState2D.mat2MatArray(this._tempMatrix,tArray);
				tShaderValue.textureHost=this.mTexture;
				tShaderValue.offsetX=0;
				tShaderValue.offsetY=0;
				tShaderValue.u_mmat2=tArray;
				tShaderValue.ALPHA=context._shader2D.ALPHA;
				context._submits[context._submits._length++]=tempSubmit;
			}
			else if (Render.isConchApp&&this.mTexture){
				this.transform || (this.transform=Matrix.EMPTY);
				context.setSkinMesh&&context.setSkinMesh(x,y,this._ps,this.mVBData,this.mEleNum,0,this.mTexture,this.transform);
			}
		}

		SkinMesh._tempVS=[];
		SkinMesh._tempIB=[];
		SkinMesh._defaultPS=null
		SkinMesh._tVSLen=0;
		return SkinMesh;
	})()


	//class laya.webgl.shader.d2.skinAnishader.SkinMeshBuffer
	var SkinMeshBuffer=(function(){
		function SkinMeshBuffer(){
			this.ib=null;
			this.vb=null;
			var gl=WebGL.mainContext;
			this.ib=IndexBuffer2D.create(0x88E8);
			this.vb=VertexBuffer2D.create(8);
		}

		__class(SkinMeshBuffer,'laya.webgl.shader.d2.skinAnishader.SkinMeshBuffer');
		var __proto=SkinMeshBuffer.prototype;
		__proto.addSkinMesh=function(skinMesh){
			skinMesh.getData2(this.vb,this.ib,this.vb.byteLength / 32);
		}

		__proto.reset=function(){
			this.vb.clear();
			this.ib.clear();
		}

		SkinMeshBuffer.getInstance=function(){
			return SkinMeshBuffer.instance=SkinMeshBuffer.instance|| new SkinMeshBuffer();
		}

		SkinMeshBuffer.instance=null
		return SkinMeshBuffer;
	})()


	//class laya.webgl.shader.ShaderValue
	var ShaderValue=(function(){
		function ShaderValue(){}
		__class(ShaderValue,'laya.webgl.shader.ShaderValue');
		return ShaderValue;
	})()


	//此类可以减少代码
	//class laya.webgl.shapes.BasePoly
	var BasePoly=(function(){
		function BasePoly(x,y,width,height,edges,color,borderWidth,borderColor,round){
			//this.x=NaN;
			//this.y=NaN;
			//this.r=NaN;
			//this.width=NaN;
			//this.height=NaN;
			//this.edges=NaN;
			this.r0=0
			//this.color=0;
			//this.borderColor=NaN;
			//this.borderWidth=NaN;
			//this.round=0;
			this.fill=true;
			//this.mUint16Array=null;
			//this.mFloat32Array=null;
			this.r1=Math.PI / 2;
			(round===void 0)&& (round=0);
			this.x=x;
			this.y=y;
			this.width=width;
			this.height=height;
			this.edges=edges;
			this.color=color;
			this.borderWidth=borderWidth;
			this.borderColor=borderColor;
		}

		__class(BasePoly,'laya.webgl.shapes.BasePoly');
		var __proto=BasePoly.prototype;
		Laya.imps(__proto,{"laya.webgl.shapes.IShape":true})
		__proto.getData=function(ib,vb,start){}
		__proto.rebuild=function(points){}
		__proto.setMatrix=function(mat){}
		__proto.needUpdate=function(mat){
			return true;
		}

		__proto.sector=function(outVert,outIndex,start){
			var x=this.x,y=this.y,edges=this.edges,seg=(this.r1-this.r0)/ edges;
			var w=this.width,h=this.height,color=this.color;
			var r=((color >> 16)& 0x0000ff)/ 255,g=((color >> 8)& 0xff)/ 255,b=(color & 0x0000ff)/ 255;
			outVert.push(x,y,r,g,b);
			for (var i=0;i < edges+1;i++){
				outVert.push(x+Math.sin(seg *i+this.r0)*w,y+Math.cos(seg *i+this.r0)*h);
				outVert.push(r,g,b);
			}
			for (i=0;i < edges;i++){
				outIndex.push(start,start+i+1,start+i+2);
			}
		}

		//用于画线
		__proto.createLine2=function(p,indices,lineWidth,len,outVertex,indexCount){
			var points=p.concat();
			var result=outVertex;
			var color=this.borderColor;
			var r=((color >> 16)& 0x0000ff)/ 255,g=((color >> 8)& 0xff)/ 255,b=(color & 0x0000ff)/ 255;
			var length=points.length / 2;
			var iStart=len,w=lineWidth / 2;
			var px,py,p1x,p1y,p2x,p2y,p3x,p3y;
			var perpx,perpy,perp2x,perp2y,perp3x,perp3y;
			var a1,b1,c1,a2,b2,c2;
			var denom,pdist,dist;
			p1x=points[0];
			p1y=points[1];
			p2x=points[2];
			p2y=points[3];
			perpx=-(p1y-p2y);
			perpy=p1x-p2x;
			dist=Math.sqrt(perpx *perpx+perpy *perpy);
			perpx=perpx / dist *w;
			perpy=perpy / dist *w;
			result.push(p1x-perpx+this.x,p1y-perpy+this.y,r,g,b,p1x+perpx+this.x,p1y+perpy+this.y,r,g,b);
			for (var i=1;i < length-1;i++){
				p1x=points[(i-1)*2];
				p1y=points[(i-1)*2+1];
				p2x=points[(i)*2];
				p2y=points[(i)*2+1];
				p3x=points[(i+1)*2];
				p3y=points[(i+1)*2+1];
				perpx=-(p1y-p2y);
				perpy=p1x-p2x;
				dist=Math.sqrt(perpx *perpx+perpy *perpy);
				perpx=perpx / dist *w;
				perpy=perpy / dist *w;
				perp2x=-(p2y-p3y);
				perp2y=p2x-p3x;
				dist=Math.sqrt(perp2x *perp2x+perp2y *perp2y);
				perp2x=perp2x / dist *w;
				perp2y=perp2y / dist *w;
				a1=(-perpy+p1y)-(-perpy+p2y);
				b1=(-perpx+p2x)-(-perpx+p1x);
				c1=(-perpx+p1x)*(-perpy+p2y)-(-perpx+p2x)*(-perpy+p1y);
				a2=(-perp2y+p3y)-(-perp2y+p2y);
				b2=(-perp2x+p2x)-(-perp2x+p3x);
				c2=(-perp2x+p3x)*(-perp2y+p2y)-(-perp2x+p2x)*(-perp2y+p3y);
				denom=a1 *b2-a2 *b1;
				if (Math.abs(denom)< 0.1){
					denom+=10.1;
					result.push(p2x-perpx+this.x,p2y-perpy+this.y,r,g,b,p2x+perpx+this.x,p2y+perpy+this.y,r,g,b);
					continue ;
				}
				px=(b1 *c2-b2 *c1)/ denom;
				py=(a2 *c1-a1 *c2)/ denom;
				pdist=(px-p2x)*(px-p2x)+(py-p2y)+(py-p2y);
				result.push(px+this.x,py+this.y,r,g,b,p2x-(px-p2x)+this.x,p2y-(py-p2y)+this.y,r,g,b);
			}
			p1x=points[points.length-4];
			p1y=points[points.length-3];
			p2x=points[points.length-2];
			p2y=points[points.length-1];
			perpx=-(p1y-p2y);
			perpy=p1x-p2x;
			dist=Math.sqrt(perpx *perpx+perpy *perpy);
			perpx=perpx / dist *w;
			perpy=perpy / dist *w;
			result.push(p2x-perpx+this.x,p2y-perpy+this.y,r,g,b,p2x+perpx+this.x,p2y+perpy+this.y,r,g,b);
			var groupLen=indexCount;
			for (i=1;i < groupLen;i++){
				indices.push(iStart+(i-1)*2,iStart+(i-1)*2+1,iStart+i *2+1,iStart+i *2+1,iStart+i *2,iStart+(i-1)*2);
			}
			return result;
		}

		// /*,outVertex:Array,outIndex:Array*/
		__proto.createLine=function(p,indices,lineWidth,len){
			var points=p.concat();
			var result=p;
			var color=this.borderColor;
			var r=((color >> 16)& 0x0000ff)/ 255,g=((color >> 8)& 0xff)/ 255,b=(color & 0x0000ff)/ 255;
			points.splice(0,5);
			var length=points.length / 5;
			var iStart=len,w=lineWidth / 2;
			var px,py,p1x,p1y,p2x,p2y,p3x,p3y;
			var perpx,perpy,perp2x,perp2y,perp3x,perp3y;
			var a1,b1,c1,a2,b2,c2;
			var denom,pdist,dist;
			p1x=points[0];
			p1y=points[1];
			p2x=points[5];
			p2y=points[6];
			perpx=-(p1y-p2y);
			perpy=p1x-p2x;
			dist=Math.sqrt(perpx *perpx+perpy *perpy);
			perpx=perpx / dist *w;
			perpy=perpy / dist *w;
			result.push(p1x-perpx,p1y-perpy,r,g,b,p1x+perpx,p1y+perpy,r,g,b);
			for (var i=1;i < length-1;i++){
				p1x=points[(i-1)*5];
				p1y=points[(i-1)*5+1];
				p2x=points[(i)*5];
				p2y=points[(i)*5+1];
				p3x=points[(i+1)*5];
				p3y=points[(i+1)*5+1];
				perpx=-(p1y-p2y);
				perpy=p1x-p2x;
				dist=Math.sqrt(perpx *perpx+perpy *perpy);
				perpx=perpx / dist *w;
				perpy=perpy / dist *w;
				perp2x=-(p2y-p3y);
				perp2y=p2x-p3x;
				dist=Math.sqrt(perp2x *perp2x+perp2y *perp2y);
				perp2x=perp2x / dist *w;
				perp2y=perp2y / dist *w;
				a1=(-perpy+p1y)-(-perpy+p2y);
				b1=(-perpx+p2x)-(-perpx+p1x);
				c1=(-perpx+p1x)*(-perpy+p2y)-(-perpx+p2x)*(-perpy+p1y);
				a2=(-perp2y+p3y)-(-perp2y+p2y);
				b2=(-perp2x+p2x)-(-perp2x+p3x);
				c2=(-perp2x+p3x)*(-perp2y+p2y)-(-perp2x+p2x)*(-perp2y+p3y);
				denom=a1 *b2-a2 *b1;
				if (Math.abs(denom)< 0.1){
					denom+=10.1;
					result.push(p2x-perpx,p2y-perpy,r,g,b,p2x+perpx,p2y+perpy,r,g,b);
					continue ;
				}
				px=(b1 *c2-b2 *c1)/ denom;
				py=(a2 *c1-a1 *c2)/ denom;
				pdist=(px-p2x)*(px-p2x)+(py-p2y)+(py-p2y);
				result.push(px,py,r,g,b,p2x-(px-p2x),p2y-(py-p2y),r,g,b);
			}
			p1x=points[points.length-10];
			p1y=points[points.length-9];
			p2x=points[points.length-5];
			p2y=points[points.length-4];
			perpx=-(p1y-p2y);
			perpy=p1x-p2x;
			dist=Math.sqrt(perpx *perpx+perpy *perpy);
			perpx=perpx / dist *w;
			perpy=perpy / dist *w;
			result.push(p2x-perpx,p2y-perpy,r,g,b,p2x+perpx,p2y+perpy,r,g,b);
			var groupLen=this.edges+1;
			for (i=1;i < groupLen;i++){
				indices.push(iStart+(i-1)*2,iStart+(i-1)*2+1,iStart+i *2+1,iStart+i *2+1,iStart+i *2,iStart+(i-1)*2);
			}
			return result;
		}

		//闭合路径
		__proto.createLoopLine=function(p,indices,lineWidth,len,outVertex,outIndex){
			var points=p.concat();
			var result=outVertex ? outVertex :p;
			var color=this.borderColor;
			var r=((color >> 16)& 0x0000ff)/ 255,g=((color >> 8)& 0xff)/ 255,b=(color & 0x0000ff)/ 255;
			points.splice(0,5);
			var firstPoint=[points[0],points[1]];
			var lastPoint=[points[points.length-5],points[points.length-4]];
			var midPointX=lastPoint[0]+(firstPoint[0]-lastPoint[0])*0.5;
			var midPointY=lastPoint[1]+(firstPoint[1]-lastPoint[1])*0.5;
			points.unshift(midPointX,midPointY,0,0,0);
			points.push(midPointX,midPointY,0,0,0);
			var length=points.length / 5;
			var iStart=len,w=lineWidth / 2;
			var px,py,p1x,p1y,p2x,p2y,p3x,p3y;
			var perpx,perpy,perp2x,perp2y,perp3x,perp3y;
			var a1,b1,c1,a2,b2,c2;
			var denom,pdist,dist;
			p1x=points[0];
			p1y=points[1];
			p2x=points[5];
			p2y=points[6];
			perpx=-(p1y-p2y);
			perpy=p1x-p2x;
			dist=Math.sqrt(perpx *perpx+perpy *perpy);
			perpx=perpx / dist *w;
			perpy=perpy / dist *w;
			result.push(p1x-perpx,p1y-perpy,r,g,b,p1x+perpx,p1y+perpy,r,g,b);
			for (var i=1;i < length-1;i++){
				p1x=points[(i-1)*5];
				p1y=points[(i-1)*5+1];
				p2x=points[(i)*5];
				p2y=points[(i)*5+1];
				p3x=points[(i+1)*5];
				p3y=points[(i+1)*5+1];
				perpx=-(p1y-p2y);
				perpy=p1x-p2x;
				dist=Math.sqrt(perpx *perpx+perpy *perpy);
				perpx=perpx / dist *w;
				perpy=perpy / dist *w;
				perp2x=-(p2y-p3y);
				perp2y=p2x-p3x;
				dist=Math.sqrt(perp2x *perp2x+perp2y *perp2y);
				perp2x=perp2x / dist *w;
				perp2y=perp2y / dist *w;
				a1=(-perpy+p1y)-(-perpy+p2y);
				b1=(-perpx+p2x)-(-perpx+p1x);
				c1=(-perpx+p1x)*(-perpy+p2y)-(-perpx+p2x)*(-perpy+p1y);
				a2=(-perp2y+p3y)-(-perp2y+p2y);
				b2=(-perp2x+p2x)-(-perp2x+p3x);
				c2=(-perp2x+p3x)*(-perp2y+p2y)-(-perp2x+p2x)*(-perp2y+p3y);
				denom=a1 *b2-a2 *b1;
				if (Math.abs(denom)< 0.1){
					denom+=10.1;
					result.push(p2x-perpx,p2y-perpy,r,g,b,p2x+perpx,p2y+perpy,r,g,b);
					continue ;
				}
				px=(b1 *c2-b2 *c1)/ denom;
				py=(a2 *c1-a1 *c2)/ denom;
				pdist=(px-p2x)*(px-p2x)+(py-p2y)+(py-p2y);
				result.push(px,py,r,g,b,p2x-(px-p2x),p2y-(py-p2y),r,g,b);
			}
			if (outIndex){
				indices=outIndex;
			};
			var groupLen=this.edges+1;
			for (i=1;i < groupLen;i++){
				indices.push(iStart+(i-1)*2,iStart+(i-1)*2+1,iStart+i *2+1,iStart+i *2+1,iStart+i *2,iStart+(i-1)*2);
			}
			indices.push(iStart+(i-1)*2,iStart+(i-1)*2+1,iStart+1,iStart+1,iStart,iStart+(i-1)*2);
			return result;
		}

		return BasePoly;
	})()


	//class laya.webgl.submit.Submit
	var Submit=(function(){
		function Submit(renderType){
			//this._selfVb=null;
			//this._ib=null;
			//this._blendFn=null;
			//this._renderType=0;
			//this._vb=null;
			//this._startIdx=0;
			//this._numEle=0;
			//this.shaderValue=null;
			(renderType===void 0)&& (renderType=10000);
			this._renderType=renderType;
		}

		__class(Submit,'laya.webgl.submit.Submit');
		var __proto=Submit.prototype;
		Laya.imps(__proto,{"laya.webgl.submit.ISubmit":true})
		__proto.releaseRender=function(){
			var cache=Submit._cache;
			cache[cache._length++]=this;
			this.shaderValue.release();
			this._vb=null;
		}

		__proto.getRenderType=function(){
			return this._renderType;
		}

		__proto.renderSubmit=function(){
			if (this._numEle===0)return 1;
			var _tex=this.shaderValue.textureHost;
			if (_tex){
				var source=_tex.source;
				if (!_tex.bitmap || !source)
					return 1;
				this.shaderValue.texture=source;
			}
			this._vb.bind_upload(this._ib);
			var gl=WebGL.mainContext;
			this.shaderValue.upload();
			if (BlendMode.activeBlendFunction!==this._blendFn){
				gl.enable(0x0BE2);
				this._blendFn(gl);
				BlendMode.activeBlendFunction=this._blendFn;
			}
			Stat.drawCall++;
			Stat.trianglesFaces+=this._numEle / 3;
			gl.drawElements(0x0004,this._numEle,0x1403,this._startIdx);
			return 1;
		}

		Submit.__init__=function(){
			var s=Submit.RENDERBASE=new Submit(-1);
			s.shaderValue=new Value2D(0,0);
			s.shaderValue.ALPHA=-1234;
		}

		Submit.create=function(context,ib,vb,pos,sv){
			var o=Submit._cache._length ? Submit._cache[--Submit._cache._length] :new Submit();
			if (vb==null){
				vb=o._selfVb || (o._selfVb=VertexBuffer2D.create(-1));
				vb.clear();
				pos=0;
			}
			o._ib=ib;
			o._vb=vb;
			o._startIdx=pos *CONST3D2D.BYTES_PIDX;
			o._numEle=0;
			var blendType=context._nBlendType;
			o._blendFn=context._targets ? BlendMode.targetFns[blendType] :BlendMode.fns[blendType];
			o.shaderValue=sv;
			o.shaderValue.setValue(context._shader2D);
			var filters=context._shader2D.filters;
			filters && o.shaderValue.setFilters(filters);
			return o;
		}

		Submit.createShape=function(ctx,ib,vb,numEle,offset,sv){
			var o=(!Submit._cache._length)? (new Submit()):Submit._cache[--Submit._cache._length];
			o._ib=ib;
			o._vb=vb;
			o._numEle=numEle;
			o._startIdx=offset;
			o.shaderValue=sv;
			o.shaderValue.setValue(ctx._shader2D);
			var blendType=ctx._nBlendType;
			o._blendFn=ctx._targets ? BlendMode.targetFns[blendType] :BlendMode.fns[blendType];
			return o;
		}

		Submit.TYPE_2D=10000;
		Submit.TYPE_CANVAS=10003;
		Submit.TYPE_CMDSETRT=10004;
		Submit.TYPE_CUSTOM=10005;
		Submit.TYPE_BLURRT=10006;
		Submit.TYPE_CMDDESTORYPRERT=10007;
		Submit.TYPE_DISABLESTENCIL=10008;
		Submit.TYPE_OTHERIBVB=10009;
		Submit.TYPE_PRIMITIVE=10010;
		Submit.TYPE_RT=10011;
		Submit.TYPE_BLUR_RT=10012;
		Submit.TYPE_TARGET=10013;
		Submit.TYPE_CHANGE_VALUE=10014;
		Submit.TYPE_SHAPE=10015;
		Submit.TYPE_TEXTURE=10016;
		Submit.TYPE_FILLTEXTURE=10017;
		Submit.RENDERBASE=null
		Submit._cache=(Submit._cache=[],Submit._cache._length=0,Submit._cache);
		return Submit;
	})()


	//class laya.webgl.submit.SubmitCMD
	var SubmitCMD=(function(){
		function SubmitCMD(){
			this.fun=null;
			this.args=null;
		}

		__class(SubmitCMD,'laya.webgl.submit.SubmitCMD');
		var __proto=SubmitCMD.prototype;
		Laya.imps(__proto,{"laya.webgl.submit.ISubmit":true})
		__proto.renderSubmit=function(){
			this.fun.apply(null,this.args);
			return 1;
		}

		__proto.getRenderType=function(){
			return 0;
		}

		__proto.releaseRender=function(){
			var cache=SubmitCMD._cache;
			cache[cache._length++]=this;
		}

		SubmitCMD.create=function(args,fun){
			var o=SubmitCMD._cache._length?SubmitCMD._cache[--SubmitCMD._cache._length]:new SubmitCMD();
			o.fun=fun;
			o.args=args;
			return o;
		}

		SubmitCMD._cache=(SubmitCMD._cache=[],SubmitCMD._cache._length=0,SubmitCMD._cache);
		return SubmitCMD;
	})()


	//class laya.webgl.submit.SubmitCMDScope
	var SubmitCMDScope=(function(){
		function SubmitCMDScope(){
			this.variables={};
		}

		__class(SubmitCMDScope,'laya.webgl.submit.SubmitCMDScope');
		var __proto=SubmitCMDScope.prototype;
		__proto.getValue=function(name){
			return this.variables[name];
		}

		__proto.addValue=function(name,value){
			return this.variables[name]=value;
		}

		__proto.setValue=function(name,value){
			if(this.variables.hasOwnProperty(name)){
				return this.variables[name]=value;
			}
			return null;
		}

		__proto.clear=function(){
			for(var key in this.variables){
				delete this.variables[key];
			}
		}

		__proto.recycle=function(){
			this.clear();
			SubmitCMDScope.POOL.push(this);
		}

		SubmitCMDScope.create=function(){
			var scope=SubmitCMDScope.POOL.pop();
			scope||(scope=new SubmitCMDScope());
			return scope;
		}

		SubmitCMDScope.POOL=[];
		return SubmitCMDScope;
	})()


	//class laya.webgl.submit.SubmitOtherIBVB
	var SubmitOtherIBVB=(function(){
		function SubmitOtherIBVB(){
			this.offset=0;
			//this._vb=null;
			//this._ib=null;
			//this._blendFn=null;
			//this._mat=null;
			//this._shader=null;
			//this._shaderValue=null;
			//this._numEle=0;
			this.startIndex=0;
			;
			this._mat=Matrix.create();
		}

		__class(SubmitOtherIBVB,'laya.webgl.submit.SubmitOtherIBVB');
		var __proto=SubmitOtherIBVB.prototype;
		Laya.imps(__proto,{"laya.webgl.submit.ISubmit":true})
		__proto.releaseRender=function(){
			var cache=SubmitOtherIBVB._cache;
			cache[cache._length++]=this;
		}

		__proto.getRenderType=function(){
			return 10009;
		}

		__proto.renderSubmit=function(){
			var _tex=this._shaderValue.textureHost;
			if (_tex){
				var source=_tex.source;
				if (!_tex.bitmap || !source)
					return 1;
				this._shaderValue.texture=source;
			}
			this._vb.bind_upload(this._ib);
			var w=RenderState2D.worldMatrix4;
			var wmat=Matrix.TEMP;
			Matrix.mulPre(this._mat,w[0],w[1],w[4],w[5],w[12],w[13],wmat);
			var tmp=RenderState2D.worldMatrix4=SubmitOtherIBVB.tempMatrix4;
			tmp[0]=wmat.a;
			tmp[1]=wmat.b;
			tmp[4]=wmat.c;
			tmp[5]=wmat.d;
			tmp[12]=wmat.tx;
			tmp[13]=wmat.ty;
			this._shader._offset=this.offset;
			this._shaderValue.refresh();
			this._shader.upload(this._shaderValue);
			this._shader._offset=0;
			var gl=WebGL.mainContext;
			if (BlendMode.activeBlendFunction!==this._blendFn){
				gl.enable(0x0BE2);
				this._blendFn(gl);
				BlendMode.activeBlendFunction=this._blendFn;
			}
			Stat.drawCall++;
			Stat.trianglesFaces+=this._numEle / 3;
			gl.drawElements(0x0004,this._numEle,0x1403,this.startIndex);
			RenderState2D.worldMatrix4=w;
			BaseShader.activeShader=null;
			return 1;
		}

		SubmitOtherIBVB.create=function(context,vb,ib,numElement,shader,shaderValue,startIndex,offset,type){
			(type===void 0)&& (type=0);
			var o=(!SubmitOtherIBVB._cache._length)? (new SubmitOtherIBVB()):SubmitOtherIBVB._cache[--SubmitOtherIBVB._cache._length];
			o._ib=ib;
			o._vb=vb;
			o._numEle=numElement;
			o._shader=shader;
			o._shaderValue=shaderValue;
			var blendType=context._nBlendType;
			o._blendFn=context._targets ? BlendMode.targetFns[blendType] :BlendMode.fns[blendType];
			switch(type){
				case 0:
					o.offset=0;
					o.startIndex=offset / (CONST3D2D.BYTES_PE *vb.vertexStride)*1.5;
					o.startIndex *=CONST3D2D.BYTES_PIDX;
					break ;
				case 1:
					o.startIndex=startIndex;
					o.offset=offset;
					break ;
				}
			return o;
		}

		SubmitOtherIBVB._cache=(SubmitOtherIBVB._cache=[],SubmitOtherIBVB._cache._length=0,SubmitOtherIBVB._cache);
		SubmitOtherIBVB.tempMatrix4=[1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1,];
		return SubmitOtherIBVB;
	})()


	//class laya.webgl.submit.SubmitScissor
	var SubmitScissor=(function(){
		function SubmitScissor(){
			this.submitIndex=0;
			this.submitLength=0;
			this.context=null;
			this.clipRect=new Rectangle();
			this.screenRect=new Rectangle();
		}

		__class(SubmitScissor,'laya.webgl.submit.SubmitScissor');
		var __proto=SubmitScissor.prototype;
		Laya.imps(__proto,{"laya.webgl.submit.ISubmit":true})
		__proto._scissor=function(x,y,w,h){
			var m=RenderState2D.worldMatrix4;
			var a=m[0],d=m[5],tx=m[12],ty=m[13];
			x=x *a+tx;
			y=y *d+ty;
			w *=a;
			h *=d;
			if (w < 1 || h < 1){
				return false;
			};
			var r=x+w;
			var b=y+h;
			x < 0 && (x=0,w=r-x);
			y < 0 && (y=0,h=b-y);
			var screen=RenderState2D.worldClipRect;
			x=Math.max(x,screen.x);
			y=Math.max(y,screen.y);
			w=Math.min(r,screen.right)-x;
			h=Math.min(b,screen.bottom)-y;
			if (w < 1 || h < 1){
				return false;
			};
			var worldScissorTest=RenderState2D.worldScissorTest;
			this.screenRect.copyFrom(screen);
			screen.x=x;
			screen.y=y;
			screen.width=w;
			screen.height=h;
			RenderState2D.worldScissorTest=true;
			y=RenderState2D.height-y-h;
			WebGL.mainContext.scissor(x,y,w,h);
			WebGL.mainContext.enable(0x0C11);
			this.context.submitElement(this.submitIndex,this.submitIndex+this.submitLength);
			if (worldScissorTest){
				y=RenderState2D.height-this.screenRect.y-this.screenRect.height;
				WebGL.mainContext.scissor(this.screenRect.x,y,this.screenRect.width,this.screenRect.height);
				WebGL.mainContext.enable(0x0C11);
			}
			else{
				WebGL.mainContext.disable(0x0C11);
				RenderState2D.worldScissorTest=false;
			}
			screen.copyFrom(this.screenRect);
			return true;
		}

		__proto._scissorWithTagart=function(x,y,w,h){
			if (w < 1 || h < 1){
				return false;
			};
			var r=x+w;
			var b=y+h;
			x < 0 && (x=0,w=r-x);
			y < 0 && (y=0,h=b-y);
			var screen=RenderState2D.worldClipRect;
			x=Math.max(x,screen.x);
			y=Math.max(y,screen.y);
			w=Math.min(r,screen.right)-x;
			h=Math.min(b,screen.bottom)-y;
			if (w < 1 || h < 1){
				return false;
			};
			var worldScissorTest=RenderState2D.worldScissorTest;
			this.screenRect.copyFrom(screen);
			RenderState2D.worldScissorTest=true;
			screen.x=x;
			screen.y=y;
			screen.width=w;
			screen.height=h;
			y=RenderState2D.height-y-h;
			WebGL.mainContext.scissor(x,y,w,h);
			WebGL.mainContext.enable(0x0C11);
			this.context.submitElement(this.submitIndex,this.submitIndex+this.submitLength);
			if (worldScissorTest){
				y=RenderState2D.height-this.screenRect.y-this.screenRect.height;
				WebGL.mainContext.scissor(this.screenRect.x,y,this.screenRect.width,this.screenRect.height);
				WebGL.mainContext.enable(0x0C11);
			}
			else{
				WebGL.mainContext.disable(0x0C11);
				RenderState2D.worldScissorTest=false;
			}
			screen.copyFrom(this.screenRect);
			return true;
		}

		__proto.renderSubmit=function(){
			this.submitLength=Math.min(this.context._submits._length-1,this.submitLength);
			if (this.submitLength < 1 || this.clipRect.width < 1 || this.clipRect.height < 1)
				return this.submitLength+1;
			if (this.context._targets)
				this._scissorWithTagart(this.clipRect.x,this.clipRect.y,this.clipRect.width,this.clipRect.height);
			else this._scissor(this.clipRect.x,this.clipRect.y,this.clipRect.width,this.clipRect.height);
			return this.submitLength+1;
		}

		__proto.getRenderType=function(){
			return 0;
		}

		__proto.releaseRender=function(){
			var cache=SubmitScissor._cache;
			cache[cache._length++]=this;
			this.context=null;
		}

		SubmitScissor.create=function(context){
			var o=SubmitScissor._cache._length?SubmitScissor._cache[--SubmitScissor._cache._length]:new SubmitScissor();
			o.context=context;
			return o;
		}

		SubmitScissor._cache=(SubmitScissor._cache=[],SubmitScissor._cache._length=0,SubmitScissor._cache);
		return SubmitScissor;
	})()


	//class laya.webgl.submit.SubmitStencil
	var SubmitStencil=(function(){
		function SubmitStencil(){
			this.step=0;
			this.blendMode=null;
			this.level=0;
		}

		__class(SubmitStencil,'laya.webgl.submit.SubmitStencil');
		var __proto=SubmitStencil.prototype;
		Laya.imps(__proto,{"laya.webgl.submit.ISubmit":true})
		__proto.renderSubmit=function(){
			switch(this.step){
				case 1:
					this.do1();
					break ;
				case 2:
					this.do2();
					break ;
				case 3:
					this.do3();
					break ;
				case 4:
					this.do4();
					break ;
				case 5:
					this.do5();
					break ;
				case 6:
					this.do6();
					break ;
				}
			return 1;
		}

		__proto.getRenderType=function(){
			return 0;
		}

		__proto.releaseRender=function(){
			var cache=SubmitStencil._cache;
			cache[cache._length++]=this;
		}

		__proto.do1=function(){
			var gl=WebGL.mainContext;
			gl.enable(0x0B90);
			gl.clear(0x00000400);
			gl.colorMask(false,false,false,false);
			gl.stencilFunc(0x0202,this.level,0xFF);
			gl.stencilOp(0x1E00,0x1E00,0x1E02);
		}

		//gl.stencilOp(WebGLContext.KEEP,WebGLContext.KEEP,WebGLContext.INVERT);//测试通过给模版缓冲 写入值 一开始是0 现在是 0xFF (模版缓冲中不知道是多少位的数据)
		__proto.do2=function(){
			var gl=WebGL.mainContext;
			gl.stencilFunc(0x0202,this.level+1,0xFF);
			gl.colorMask(true,true,true,true);
			gl.stencilOp(0x1E00,0x1E00,0x1E00);
		}

		__proto.do3=function(){
			var gl=WebGL.mainContext;
			gl.colorMask(true,true,true,true);
			gl.stencilOp(0x1E00,0x1E00,0x1E00);
			gl.clear(0x00000400);
			gl.disable(0x0B90);
		}

		__proto.do4=function(){
			var gl=WebGL.mainContext;
			gl.enable(0x0B90);
			gl.clear(0x00000400);
			gl.colorMask(false,false,false,false);
			gl.stencilFunc(0x0207,this.level,0xFF);
			gl.stencilOp(0x1E00,0x1E00,0x150A);
		}

		__proto.do5=function(){
			var gl=WebGL.mainContext;
			gl.stencilFunc(0x0202,0xff,0xFF);
			gl.colorMask(true,true,true,true);
			gl.stencilOp(0x1E00,0x1E00,0x1E00);
		}

		__proto.do6=function(){
			var gl=WebGL.mainContext;
			BlendMode.targetFns[BlendMode.TOINT[this.blendMode]](gl);
		}

		SubmitStencil.create=function(step){
			var o=SubmitStencil._cache._length?SubmitStencil._cache[--SubmitStencil._cache._length]:new SubmitStencil();
			o.step=step;
			return o;
		}

		SubmitStencil._cache=(SubmitStencil._cache=[],SubmitStencil._cache._length=0,SubmitStencil._cache);
		return SubmitStencil;
	})()


	//class laya.webgl.submit.SubmitTarget
	var SubmitTarget=(function(){
		function SubmitTarget(){
			this._renderType=0;
			this._vb=null;
			this._ib=null;
			this._startIdx=0;
			this._numEle=0;
			this.shaderValue=null;
			this.blendType=0;
			this.proName=null;
			this.scope=null;
		}

		__class(SubmitTarget,'laya.webgl.submit.SubmitTarget');
		var __proto=SubmitTarget.prototype;
		Laya.imps(__proto,{"laya.webgl.submit.ISubmit":true})
		__proto.renderSubmit=function(){
			this._vb.bind_upload(this._ib);
			var target=this.scope.getValue(this.proName);
			if (target){
				this.shaderValue.texture=target.source;
				if (this.shaderValue["strength"] && !this.shaderValue["blurInfo"]){
					this.shaderValue["blurInfo"]=[target.width,target.height];
				}
				this.shaderValue.upload();
				this.blend();
				Stat.drawCall++;
				Stat.trianglesFaces+=this._numEle/3;
				WebGL.mainContext.drawElements(0x0004,this._numEle,0x1403,this._startIdx);
			}
			return 1;
		}

		__proto.blend=function(){
			if (BlendMode.activeBlendFunction!==BlendMode.fns[this.blendType]){
				var gl=WebGL.mainContext;
				gl.enable(0x0BE2);
				BlendMode.fns[this.blendType](gl);
				BlendMode.activeBlendFunction=BlendMode.fns[this.blendType];
			}
		}

		__proto.getRenderType=function(){
			return 0;
		}

		__proto.releaseRender=function(){
			var cache=SubmitTarget._cache;
			cache[cache._length++]=this;
		}

		SubmitTarget.create=function(context,ib,vb,pos,sv,proName){
			var o=SubmitTarget._cache._length?SubmitTarget._cache[--SubmitTarget._cache._length]:new SubmitTarget();
			o._ib=ib;
			o._vb=vb;
			o.proName=proName;
			o._startIdx=pos *CONST3D2D.BYTES_PIDX;
			o._numEle=0;
			o.blendType=context._nBlendType;
			o.shaderValue=sv;
			o.shaderValue.setValue(context._shader2D);
			return o;
		}

		SubmitTarget._cache=(SubmitTarget._cache=[],SubmitTarget._cache._length=0,SubmitTarget._cache);
		return SubmitTarget;
	})()


	/**
	*...特殊的字符，如泰文，必须重新实现这个类
	*/
	//class laya.webgl.text.CharSegment
	var CharSegment=(function(){
		function CharSegment(){
			this._sourceStr=null;
		}

		__class(CharSegment,'laya.webgl.text.CharSegment');
		var __proto=CharSegment.prototype;
		Laya.imps(__proto,{"laya.webgl.text.ICharSegment":true})
		__proto.textToSpit=function(str){
			this._sourceStr=str;
		}

		__proto.getChar=function(i){
			return this._sourceStr.charAt(i);
		}

		__proto.getCharCode=function(i){
			return this._sourceStr.charCodeAt(i);
		}

		__proto.length=function(){
			return this._sourceStr.length;
		}

		return CharSegment;
	})()


	//class laya.webgl.text.DrawText
	var DrawText=(function(){
		var CharValue;
		function DrawText(){};
		__class(DrawText,'laya.webgl.text.DrawText');
		DrawText.__init__=function(){
			DrawText._charsTemp=new Array;
			DrawText._drawValue=new CharValue();
			DrawText._charSeg=new CharSegment();
		}

		DrawText.customCharSeg=function(charseg){
			DrawText._charSeg=charseg;
		}

		DrawText.getChar=function(char,id,drawValue){
			var result=WebGLCharImage.createOneChar(char,drawValue);
			if(id)
				DrawText._charsCache[id]=result;
			return result;
		}

		DrawText._drawSlow=function(save,ctx,txt,words,curMat,font,textAlign,fillColor,borderColor,lineWidth,x,y,sx,sy){
			var drawValue=DrawText._drawValue.value(font,fillColor,borderColor,lineWidth,sx,sy);
			var i=0,n=0;
			var chars=DrawText._charsTemp;
			var width=0,oneChar,htmlWord,id=NaN;
			if (words){
				chars.length=words.length;
				for (i=0,n=words.length;i < n;i++){
					htmlWord=words[i];
					id=htmlWord.charNum+drawValue.txtID;
					chars[i]=oneChar=DrawText._charsCache[id] || DrawText.getChar(htmlWord.char,id,drawValue);
					oneChar.active();
				}
				}else {
				var text=((txt instanceof laya.utils.WordText ))? txt.toString():txt;
				if (Text.CharacterCache){
					DrawText._charSeg.textToSpit(text);
					var len=/*if err,please use iflash.method.xmlLength()*/DrawText._charSeg.length();
					chars.length=len;
					for (i=0,n=len;i < n;i++){
						id=DrawText._charSeg.getCharCode(i)+drawValue.txtID;
						chars[i]=oneChar=DrawText._charsCache[id] || DrawText.getChar(DrawText._charSeg.getChar(i),id,drawValue);
						oneChar.active();
						width+=oneChar.cw;
					}
				}
				else {
					oneChar=DrawText.getChar(text,null,drawValue);
					oneChar.active();
					width+=oneChar.cw;
					chars[0]=oneChar;
				}
			};
			var dx=0;
			if (textAlign!==null && textAlign!=="left")
				dx=-(textAlign=="center" ? (width / 2):width);
			var uv,bdSz=NaN,texture,value,saveLength=0;
			if (words){
				for (i=0,n=chars.length;i < n;i++){
					oneChar=chars[i];
					if (!oneChar.isSpace){
						htmlWord=words[i];
						bdSz=oneChar.borderSize;
						texture=oneChar.texture;
						ctx._drawText(texture,x+dx+htmlWord.x *sx-bdSz,y+htmlWord.y *sy-bdSz,texture.width,texture.height,curMat,0,0,0,0);
					}
				}
				}else {
				for (i=0,n=chars.length;i < n;i++){
					oneChar=chars[i];
					if (!oneChar.isSpace){
						bdSz=oneChar.borderSize;
						texture=oneChar.texture;
						ctx._drawText(texture,x+dx-bdSz,y-bdSz,texture.width,texture.height,curMat,0,0,0,0);
						save && (value=save[saveLength++],value || (value=save[saveLength-1]=[]),value[0]=texture,value[1]=dx-bdSz,value[2]=-bdSz);
					}
					dx+=oneChar.cw;
				}
				save && (save.length=saveLength);
			}
		}

		DrawText._drawFast=function(save,ctx,curMat,x,y){
			var texture,value;
			for (var i=0,n=save.length;i < n;i++){
				value=save[i];
				texture=value[0];
				texture.active();
				ctx._drawText(texture,x+value[1],y+value[2],texture.width,texture.height,curMat,0,0,0,0);
			}
		}

		DrawText.drawText=function(ctx,txt,words,curMat,font,textAlign,fillColor,borderColor,lineWidth,x,y){
			if ((txt && txt.length===0)|| (words && words.length===0))
				return;
			var sx=curMat.a,sy=curMat.d;
			(curMat.b!==0 || curMat.c!==0)&& (sx=sy=1);
			var scale=sx!==1 || sy!==1;
			if (scale && Laya.stage.transform){
				var t=Laya.stage.transform;
				scale=t.a===sx && t.d===sy;
			}else scale=false;
			if (scale){
				curMat=curMat.copyTo(WebGLContext2D._tmpMatrix);
				curMat.scale(1 / sx,1 / sy);
				curMat._checkTransform();
				x *=sx;
				y *=sy;
			}else sx=sy=1;
			if (words){
				DrawText._drawSlow(null,ctx,txt,words,curMat,font,textAlign,fillColor,borderColor,lineWidth,x,y,sx,sy);
				}else {
				if (txt.toUpperCase===null){
					var idNum=sx+sy *100000;
					var myCache=txt;
					if (!myCache.changed && myCache.id===idNum){
						DrawText._drawFast(myCache.save,ctx,curMat,x,y);
						}else {
						myCache.id=idNum;
						myCache.changed=false;
						DrawText._drawSlow(myCache.save,ctx,txt,words,curMat,font,textAlign,fillColor,borderColor,lineWidth,x,y,sx,sy);
					}
					return;
				};
				var id=txt+font.toString()+fillColor+borderColor+lineWidth+sx+sy+textAlign;
				var cache=DrawText._textsCache[id];
				if (Text.CharacterCache){
					if (cache){
						DrawText._drawFast(cache,ctx,curMat,x,y);
						}else {
						DrawText._textsCache.__length || (DrawText._textsCache.__length=0);
						if (DrawText._textsCache.__length > Config.WebGLTextCacheCount){
							DrawText._textsCache={};
							DrawText._textsCache.__length=0;
							DrawText._curPoolIndex=0;
						}
						DrawText._textCachesPool[DrawText._curPoolIndex] ? (cache=DrawText._textsCache[id]=DrawText._textCachesPool[DrawText._curPoolIndex],cache.length=0):(DrawText._textCachesPool[DrawText._curPoolIndex]=cache=DrawText._textsCache[id]=[]);
						DrawText._textsCache.__length++
						DrawText._curPoolIndex++;
						DrawText._drawSlow(cache,ctx,txt,words,curMat,font,textAlign,fillColor,borderColor,lineWidth,x,y,sx,sy);
					}
				}
				else{
					DrawText._drawSlow(cache,ctx,txt,words,curMat,font,textAlign,fillColor,borderColor,lineWidth,x,y,sx,sy);
				}
			}
		}

		DrawText._charsTemp=null
		DrawText._textCachesPool=[];
		DrawText._curPoolIndex=0;
		DrawText._charsCache={};
		DrawText._textsCache={};
		DrawText._drawValue=null
		DrawText.d=[];
		DrawText._charSeg=null;
		DrawText.__init$=function(){
			//class CharValue
			CharValue=(function(){
				function CharValue(){
					//this.txtID=NaN;
					//this.font=null;
					//this.fillColor=null;
					//this.borderColor=null;
					//this.lineWidth=0;
					//this.scaleX=NaN;
					//this.scaleY=NaN;
				}
				__class(CharValue,'');
				var __proto=CharValue.prototype;
				__proto.value=function(font,fillColor,borderColor,lineWidth,scaleX,scaleY){
					this.font=font;
					this.fillColor=fillColor;
					this.borderColor=borderColor;
					this.lineWidth=lineWidth;
					this.scaleX=scaleX;
					this.scaleY=scaleY;
					var key=font.toString()+scaleX+scaleY+lineWidth+fillColor+borderColor;
					this.txtID=CharValue._keymap[key];
					if (!this.txtID){
						this.txtID=(++CharValue._keymapCount)*0.0000001;
						CharValue._keymap[key]=this.txtID;
					}
					return this;
				}
				CharValue.clear=function(){
					CharValue._keymap={};
					CharValue._keymapCount=1;
				}
				CharValue._keymap={};
				CharValue._keymapCount=1;
				return CharValue;
			})()
		}

		return DrawText;
	})()


	//class laya.webgl.text.FontInContext
	var FontInContext=(function(){
		function FontInContext(font){
			//this._text=null;
			//this._words=null;
			this._index=0;
			this._size=14;
			this._italic=-2;
			FontInContext._cache2=FontInContext._cache2|| [];
			this.setFont(font || "14px Arial");
		}

		__class(FontInContext,'laya.webgl.text.FontInContext');
		var __proto=FontInContext.prototype;
		__proto.setFont=function(value){
			var arr=FontInContext._cache2[value];
			if (!arr){
				this._words=value.split(' ');
				for (var i=0,n=this._words.length;i < n;i++){
					if (this._words[i].indexOf('px')> 0){
						this._index=i;
						break ;
					}
				}
				this._size=parseInt(this._words[this._index]);
				FontInContext._cache2[value]=[this._words,this._size];
				}else {
				this._words=arr[0];
				this._size=arr[1];
			}
			this._text=null;
			this._italic=-2;
		}

		__proto.getItalic=function(){
			this._italic===-2 && (this._italic=this.hasType("italic"));
			return this._italic;
		}

		__proto.hasType=function(name){
			for (var i=0,n=this._words.length;i < n;i++)
			if (this._words[i]===name)return i;
			return-1;
		}

		__proto.removeType=function(name){
			for (var i=0,n=this._words.length;i < n;i++)
			if (this._words[i]===name){
				this._words.splice(i,1);
				if (this._index > i)this._index--;
				break ;
			}
			this._text=null;
			this._italic=-2;
		}

		__proto.copyTo=function(dec){
			dec._text=this._text;
			dec._size=this._size;
			dec._index=this._index;
			dec._words=this._words.slice();
			dec._italic=-2;
			return dec;
		}

		__proto.toString=function(){
			return this._text ? this._text :(this._text=this._words.join(' '));
		}

		__getset(0,__proto,'size',function(){
			return this._size;
			},function(value){
			this._size=value;
			this._words[this._index]=value+"px";
			this._text=null;
		});

		FontInContext.create=function(font){
			var r=FontInContext._cache[font];
			if (r)return r;
			r=FontInContext._cache[font]=new FontInContext(font);
			return r;
		}

		FontInContext.EMPTY=new FontInContext();
		FontInContext._cache={};
		FontInContext._cache2=null
		return FontInContext;
	})()


	//class laya.webgl.utils.CONST3D2D
	var CONST3D2D=(function(){
		function CONST3D2D(){};
		__class(CONST3D2D,'laya.webgl.utils.CONST3D2D');
		CONST3D2D.defaultMatrix4=[1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1];
		CONST3D2D.defaultMinusYMatrix4=[1,0,0,0,0,-1,0,0,0,0,1,0,0,0,0,1];
		CONST3D2D.uniformMatrix3=[1,0,0,0,0,1,0,0,0,0,1,0];
		CONST3D2D._TMPARRAY=[];
		CONST3D2D._OFFSETX=0;
		CONST3D2D._OFFSETY=0;
		__static(CONST3D2D,
		['BYTES_PE',function(){return this.BYTES_PE=Float32Array.BYTES_PER_ELEMENT;},'BYTES_PIDX',function(){return this.BYTES_PIDX=Uint16Array.BYTES_PER_ELEMENT;}
		]);
		return CONST3D2D;
	})()


	//class laya.webgl.utils.GlUtils
	var GlUtils=(function(){
		function GlUtils(){};
		__class(GlUtils,'laya.webgl.utils.GlUtils');
		GlUtils.make2DProjection=function(width,height,depth){
			return [2.0 / width,0,0,0,0,-2.0 / height,0,0,0,0,2.0 / depth,0,-1,1,0,1,];
		}

		GlUtils.fillIBQuadrangle=function(buffer,count){
			if (count > 65535 / 4){
				throw Error("IBQuadrangle count:"+count+" must<:"+Math.floor(65535 / 4));
				return false;
			}
			count=Math.floor(count);
			buffer._resizeBuffer((count+1)*6 *2,false);
			buffer.byteLength=buffer.bufferLength;
			var bufferData=buffer.getUint16Array();
			var idx=0;
			for (var i=0;i < count;i++){
				bufferData[idx++]=i *4;
				bufferData[idx++]=i *4+2;
				bufferData[idx++]=i *4+1;
				bufferData[idx++]=i *4;
				bufferData[idx++]=i *4+3;
				bufferData[idx++]=i *4+2;
			}
			buffer.setNeedUpload();
			return true;
		}

		GlUtils.expandIBQuadrangle=function(buffer,count){
			buffer.bufferLength >=(count *6 *2)|| GlUtils.fillIBQuadrangle(buffer,count);
		}

		GlUtils.mathCeilPowerOfTwo=function(value){
			value--;
			value |=value >> 1;
			value |=value >> 2;
			value |=value >> 4;
			value |=value >> 8;
			value |=value >> 16;
			value++;
			return value;
		}

		GlUtils.fillQuadrangleImgVb=function(vb,x,y,point4,uv,m,_x,_y){
			'use strict';
			var vpos=(vb._byteLength >> 2)+16;
			vb.byteLength=(vpos << 2);
			var vbdata=vb.getFloat32Array();
			vpos-=16;
			vbdata[vpos+2]=uv[0];
			vbdata[vpos+3]=uv[1];
			vbdata[vpos+6]=uv[2];
			vbdata[vpos+7]=uv[3];
			vbdata[vpos+10]=uv[4];
			vbdata[vpos+11]=uv[5];
			vbdata[vpos+14]=uv[6];
			vbdata[vpos+15]=uv[7];
			var a=m.a,b=m.b,c=m.c,d=m.d;
			if (a!==1 || b!==0 || c!==0 || d!==1){
				m.bTransform=true;
				var tx=m.tx+_x,ty=m.ty+_y;
				vbdata[vpos]=(point4[0]+x)*a+(point4[1]+y)*c+tx;
				vbdata[vpos+1]=(point4[0]+x)*b+(point4[1]+y)*d+ty;
				vbdata[vpos+4]=(point4[2]+x)*a+(point4[3]+y)*c+tx;
				vbdata[vpos+5]=(point4[2]+x)*b+(point4[3]+y)*d+ty;
				vbdata[vpos+8]=(point4[4]+x)*a+(point4[5]+y)*c+tx;
				vbdata[vpos+9]=(point4[4]+x)*b+(point4[5]+y)*d+ty;
				vbdata[vpos+12]=(point4[6]+x)*a+(point4[7]+y)*c+tx;
				vbdata[vpos+13]=(point4[6]+x)*b+(point4[7]+y)*d+ty;
				}else {
				m.bTransform=false;
				x+=m.tx+_x;
				y+=m.ty+_y;
				vbdata[vpos]=x+point4[0];
				vbdata[vpos+1]=y+point4[1];
				vbdata[vpos+4]=x+point4[2];
				vbdata[vpos+5]=y+point4[3];
				vbdata[vpos+8]=x+point4[4];
				vbdata[vpos+9]=y+point4[5];
				vbdata[vpos+12]=x+point4[6];
				vbdata[vpos+13]=y+point4[7];
			}
			vb._upload=true;
			return true;
		}

		GlUtils.fillTranglesVB=function(vb,x,y,points,m,_x,_y){
			'use strict';
			var vpos=(vb._byteLength >> 2)+points.length;
			vb.byteLength=(vpos << 2);
			var vbdata=vb.getFloat32Array();
			vpos-=points.length;
			var len=points.length;
			var a=m.a,b=m.b,c=m.c,d=m.d;
			for (var i=0;i < len;i+=4){
				vbdata[vpos+i+2]=points[i+2];
				vbdata[vpos+i+3]=points[i+3];
				if (a!==1 || b!==0 || c!==0 || d!==1){
					m.bTransform=true;
					var tx=m.tx+_x,ty=m.ty+_y;
					vbdata[vpos+i]=(points[i]+x)*a+(points[i+1]+y)*c+tx;
					vbdata[vpos+i+1]=(points[i]+x)*b+(points[i+1]+y)*d+ty;
					}else {
					m.bTransform=false;
					x+=m.tx+_x;
					y+=m.ty+_y;
					vbdata[vpos+i]=x+points[i];
					vbdata[vpos+i+1]=y+points[i+1];
				}
			}
			vb._upload=true;
			return true;
		}

		GlUtils.copyPreImgVb=function(vb,dx,dy){
			var vpos=(vb._byteLength >> 2);
			vb.byteLength=((vpos+16)<< 2);
			var vbdata=vb.getFloat32Array();
			for (var i=0,ci=vpos-16;i < 4;i++){
				vbdata[vpos]=vbdata[ci]+dx;++vpos;++ci;
				vbdata[vpos]=vbdata[ci]+dy;++vpos;++ci;
				vbdata[vpos]=vbdata[ci];++vpos;++ci;
				vbdata[vpos]=vbdata[ci];++vpos;++ci;
			}
			vb._upload=true;
		}

		GlUtils.fillRectImgVb=function(vb,clip,x,y,width,height,uv,m,_x,_y,dx,dy,round){
			(round===void 0)&& (round=false);
			'use strict';
			var mType=1;
			var toBx,toBy,toEx,toEy;
			var cBx,cBy,cEx,cEy;
			var w0,h0,tx,ty;
			var finalX,finalY,offsetX,offsetY;
			var a=m.a,b=m.b,c=m.c,d=m.d;
			var useClip=clip.width < 99999999;
			if (a!==1 || b!==0 || c!==0 || d!==1){
				m.bTransform=true;
				if (b===0 && c===0){
					mType=23;
					w0=width+x,h0=height+y;
					tx=m.tx+_x,ty=m.ty+_y;
					toBx=a *x+tx;
					toEx=a *w0+tx;
					toBy=d *y+ty;
					toEy=d *h0+ty;
				}
				}else {
				mType=23;
				m.bTransform=false;
				toBx=x+m.tx+_x;
				toEx=toBx+width;
				toBy=y+m.ty+_y;
				toEy=toBy+height;
			}
			if (useClip){
				cBx=clip.x,cBy=clip.y,cEx=clip.width+cBx,cEy=clip.height+cBy;
			}
			if (mType!==1 && (Math.min(toBx,toEx)>=cEx || Math.min(toBy ,toEy)>=cEy || Math.max(toEx,toBx)<=cBx || Math.max(toEy,toBy)<=cBy))
				return false;
			var vpos=(vb._byteLength >> 2);
			vb.byteLength=((vpos+16)<< 2);
			var vbdata=vb.getFloat32Array();
			vbdata[vpos+2]=uv[0];
			vbdata[vpos+3]=uv[1];
			vbdata[vpos+6]=uv[2];
			vbdata[vpos+7]=uv[3];
			vbdata[vpos+10]=uv[4];
			vbdata[vpos+11]=uv[5];
			vbdata[vpos+14]=uv[6];
			vbdata[vpos+15]=uv[7];
			switch (mType){
				case 1:
					tx=m.tx+_x,ty=m.ty+_y;
					w0=width+x,h0=height+y;
					var w1=x,h1=y;
					var aw1=a *w1,ch1=c *h1,dh1=d *h1,bw1=b *w1;
					var aw0=a *w0,ch0=c *h0,dh0=d *h0,bw0=b *w0;
					if (round){
						finalX=aw1+ch1+tx;
						offsetX=Math.round(finalX)-finalX;
						finalY=dh1+bw1+ty;
						offsetY=Math.round(finalY)-finalY;
						vbdata[vpos]=finalX+offsetX;
						vbdata[vpos+1]=finalY+offsetY;
						vbdata[vpos+4]=aw0+ch1+tx+offsetX;
						vbdata[vpos+5]=dh1+bw0+ty+offsetY;
						vbdata[vpos+8]=aw0+ch0+tx+offsetX;
						vbdata[vpos+9]=dh0+bw0+ty+offsetY;
						vbdata[vpos+12]=aw1+ch0+tx+offsetX;
						vbdata[vpos+13]=dh0+bw1+ty+offsetY;
						}else {
						vbdata[vpos]=aw1+ch1+tx;
						vbdata[vpos+1]=dh1+bw1+ty;
						vbdata[vpos+4]=aw0+ch1+tx;
						vbdata[vpos+5]=dh1+bw0+ty;
						vbdata[vpos+8]=aw0+ch0+tx;
						vbdata[vpos+9]=dh0+bw0+ty;
						vbdata[vpos+12]=aw1+ch0+tx;
						vbdata[vpos+13]=dh0+bw1+ty;
					}
					break ;
				case 23:
					if (round){
						finalX=toBx+dx;
						offsetX=Math.round(finalX)-finalX;
						finalY=toBy;
						offsetY=Math.round(finalY)-finalY;
						vbdata[vpos]=finalX+offsetX;
						vbdata[vpos+1]=finalY+offsetY;
						vbdata[vpos+4]=toEx+dx+offsetX;
						vbdata[vpos+5]=toBy+offsetY;
						vbdata[vpos+8]=toEx+offsetX;
						vbdata[vpos+9]=toEy+offsetY;
						vbdata[vpos+12]=toBx+offsetX;
						vbdata[vpos+13]=toEy+offsetY;
						}else {
						vbdata[vpos]=toBx+dx;
						vbdata[vpos+1]=toBy;
						vbdata[vpos+4]=toEx+dx;
						vbdata[vpos+5]=toBy;
						vbdata[vpos+8]=toEx;
						vbdata[vpos+9]=toEy;
						vbdata[vpos+12]=toBx;
						vbdata[vpos+13]=toEy;
					}
					break ;
				}
			vb._upload=true;
			return true;
		}

		GlUtils.fillLineVb=function(vb,clip,fx,fy,tx,ty,width,mat){
			'use strict';
			var linew=width *.5;
			var data=GlUtils._fillLineArray;
			var perpx=-(fy-ty),perpy=fx-tx;
			var dist=Math.sqrt(perpx *perpx+perpy *perpy);
			perpx /=dist,perpy /=dist,perpx *=linew,perpy *=linew;
			data[0]=fx-perpx,data[1]=fy-perpy,data[4]=fx+perpx,data[5]=fy+perpy,data[8]=tx+perpx,data[9]=ty+perpy,data[12]=tx-perpx,data[13]=ty-perpy;
			mat && mat.transformPointArray(data,data);
			var vpos=(vb._byteLength >> 2)+16;
			vb.byteLength=(vpos << 2);
			vb.insertData(data,vpos-16);
			return true;
		}

		GlUtils._fillLineArray=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
		return GlUtils;
	})()


	//class laya.webgl.utils.MatirxArray
	var MatirxArray=(function(){
		function MatirxArray(){};
		__class(MatirxArray,'laya.webgl.utils.MatirxArray');
		MatirxArray.ArrayMul=function(a,b,o){
			if (!a){
				MatirxArray.copyArray(b,o);
				return;
			}
			if (!b){
				MatirxArray.copyArray(a,o);
				return;
			};
			var ai0=NaN,ai1=NaN,ai2=NaN,ai3=NaN;
			for (var i=0;i < 4;i++){
				ai0=a[i];
				ai1=a[i+4];
				ai2=a[i+8];
				ai3=a[i+12];
				o[i]=ai0 *b[0]+ai1 *b[1]+ai2 *b[2]+ai3 *b[3];
				o[i+4]=ai0 *b[4]+ai1 *b[5]+ai2 *b[6]+ai3 *b[7];
				o[i+8]=ai0 *b[8]+ai1 *b[9]+ai2 *b[10]+ai3 *b[11];
				o[i+12]=ai0 *b[12]+ai1 *b[13]+ai2 *b[14]+ai3 *b[15];
			}
		}

		MatirxArray.copyArray=function(f,t){
			if (!f)return;
			if (!t)return;
			for (var i=0;i < f.length;i++){
				t[i]=f[i];
			}
		}

		return MatirxArray;
	})()


	//class laya.webgl.utils.RenderState2D
	var RenderState2D=(function(){
		function RenderState2D(){};
		__class(RenderState2D,'laya.webgl.utils.RenderState2D');
		RenderState2D.getMatrArray=function(){
			return [1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1];
		}

		RenderState2D.mat2MatArray=function(mat,matArray){
			var m=mat;
			var m4=matArray;
			m4[0]=m.a;
			m4[1]=m.b;
			m4[2]=RenderState2D.EMPTYMAT4_ARRAY[2];
			m4[3]=RenderState2D.EMPTYMAT4_ARRAY[3];
			m4[4]=m.c;
			m4[5]=m.d;
			m4[6]=RenderState2D.EMPTYMAT4_ARRAY[6];
			m4[7]=RenderState2D.EMPTYMAT4_ARRAY[7];
			m4[8]=RenderState2D.EMPTYMAT4_ARRAY[8];
			m4[9]=RenderState2D.EMPTYMAT4_ARRAY[9];
			m4[10]=RenderState2D.EMPTYMAT4_ARRAY[10];
			m4[11]=RenderState2D.EMPTYMAT4_ARRAY[11];
			m4[12]=m.tx;
			m4[13]=m.ty;
			m4[14]=RenderState2D.EMPTYMAT4_ARRAY[14];
			m4[15]=RenderState2D.EMPTYMAT4_ARRAY[15];
			return matArray;
		}

		RenderState2D.restoreTempArray=function(){
			RenderState2D.TEMPMAT4_ARRAY[0]=1;
			RenderState2D.TEMPMAT4_ARRAY[1]=0;
			RenderState2D.TEMPMAT4_ARRAY[4]=0;
			RenderState2D.TEMPMAT4_ARRAY[5]=1;
			RenderState2D.TEMPMAT4_ARRAY[12]=0;
			RenderState2D.TEMPMAT4_ARRAY[13]=0;
		}

		RenderState2D.clear=function(){
			RenderState2D.worldScissorTest=false;
			RenderState2D.worldShaderDefines=null;
			RenderState2D.worldFilters=null;
			RenderState2D.worldAlpha=1;
			RenderState2D.worldClipRect.x=RenderState2D.worldClipRect.y=0;
			RenderState2D.worldClipRect.width=RenderState2D.width;
			RenderState2D.worldClipRect.height=RenderState2D.height;
			RenderState2D.curRenderTarget=null;
		}

		RenderState2D._MAXSIZE=99999999;
		RenderState2D.EMPTYMAT4_ARRAY=[1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1];
		RenderState2D.TEMPMAT4_ARRAY=[1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1];
		RenderState2D.worldMatrix4=RenderState2D.TEMPMAT4_ARRAY;
		RenderState2D.worldAlpha=1.0;
		RenderState2D.worldScissorTest=false;
		RenderState2D.worldFilters=null
		RenderState2D.worldShaderDefines=null
		RenderState2D.curRenderTarget=null
		RenderState2D.width=0;
		RenderState2D.height=0;
		__static(RenderState2D,
		['worldMatrix',function(){return this.worldMatrix=new Matrix();},'worldClipRect',function(){return this.worldClipRect=new Rectangle(0,0,99999999,99999999);}
		]);
		return RenderState2D;
	})()


	//class laya.webgl.utils.ShaderCompile
	var ShaderCompile=(function(){
		var ShaderScriptBlock;
		function ShaderCompile(name,vs,ps,nameMap,includeFiles){
			//this._VS=null;
			//this._PS=null;
			//this._VSTXT=null;
			//this._PSTXT=null;
			//this._nameMap=null;
			this._VSTXT=vs;
			this._PSTXT=ps;
			function split (str){
				var words=str.split(' ');
				var out=[];
				for (var i=0;i < words.length;i++)
				words[i].length > 0 && out.push(words[i]);
				return out;
			}
			function c (script){
				var i=0,n=0,ofs=0,words,condition;
				var top=new ShaderScriptBlock(0,null,null,null);
				var parent=top;
				var lines=script.split('\n');
				for (i=0,n=lines.length;i < n;i++){
					var line=lines[i];
					if (line.indexOf("#ifdef")>=0){
						words=split(line);
						parent=new ShaderScriptBlock(1,words[1],"",parent);
						continue ;
					}
					if (line.indexOf("#else")>=0){
						condition=parent.condition;
						parent=new ShaderScriptBlock(2,null,"",parent.parent);
						parent.condition=condition;
						continue ;
					}
					if (line.indexOf("#endif")>=0){
						parent=parent.parent;
						continue ;
					}
					if (line.indexOf("#include")>=0){
						words=split(line);
						var fname=words[1];
						var chr=fname.charAt(0);
						if (chr==='"' || chr==="'"){
							fname=fname.substr(1,fname.length-2);
							ofs=fname.lastIndexOf(chr);
							if (ofs > 0)fname=fname.substr(0,ofs);
						}
						ofs=words[0].indexOf('?');
						var str=ofs > 0 ? words[0].substr(ofs+1):words[0];
						new ShaderScriptBlock(1,str,includeFiles[fname],parent);
						continue ;
					}
					if (parent.childs.length > 0 && parent.childs[parent.childs.length-1].type===0){
						parent.childs[parent.childs.length-1].text+="\n"+line;
					}else new ShaderScriptBlock(0,null,line,parent);
				}
				return top;
			}
			this._VS=c(vs);
			this._PS=c(ps);
			this._nameMap=nameMap;
		}

		__class(ShaderCompile,'laya.webgl.utils.ShaderCompile');
		var __proto=ShaderCompile.prototype;
		__proto.createShader=function(define,shaderName,createShader){
			var defMap={};
			var defineStr="";
			if (define){
				for (var i in define){
					defineStr+="#define "+i+"\n";
					defMap[i]=true;
				}
			};
			var vs=this._VS.toscript(defMap,[]);
			var ps=this._PS.toscript(defMap,[]);
			return (createShader || Shader.create)(defineStr+vs.join('\n'),defineStr+ps.join('\n'),shaderName,this._nameMap);
		}

		ShaderCompile.IFDEF_NO=0;
		ShaderCompile.IFDEF_YES=1;
		ShaderCompile.IFDEF_ELSE=2;
		ShaderCompile.__init$=function(){
			//class ShaderScriptBlock
			ShaderScriptBlock=(function(){
				function ShaderScriptBlock(type,condition,text,parent){
					//this.type=0;
					//this.condition=null;
					//this.text=null;
					//this.parent=null;
					this.childs=new Array;
					this.type=type;
					this.text=text;
					this.parent=parent;
					parent && parent.childs.push(this);
					if (!condition)return;
					var newcondition="";
					var preIsParam=false,isParam=false;
					for (var i=0,n=condition.length;i < n;i++){
						var c=condition.charAt(i);
						isParam="!&|() \t".indexOf(c)< 0;
						if (preIsParam !=isParam){
							isParam && (newcondition+="this.");
							preIsParam=isParam;
						}
						newcondition+=c;
					}
					this.condition=RunDriver.createShaderCondition(newcondition);
				}
				__class(ShaderScriptBlock,'');
				var __proto=ShaderScriptBlock.prototype;
				__proto.toscript=function(def,out){
					if (this.type===0){
						this.text && out.push(this.text);
					}
					if (this.childs.length < 1 && !this.text)return out;
					if (this.type!==0){
						var ifdef=!!this.condition.call(def);
						this.type===2 && (ifdef=!ifdef);
						if (!ifdef)return out;
						this.text && out.push(this.text);
					}
					this.childs.length > 0 && this.childs.forEach(function(o,index,arr){
						o.toscript(def,out)
					});
					return out;
				}
				return ShaderScriptBlock;
			})()
		}

		return ShaderCompile;
	})()


	/**
	*@private
	*/
	//class laya.webgl.WebGL
	var WebGL=(function(){
		function WebGL(){};
		__class(WebGL,'laya.webgl.WebGL');
		WebGL._uint8ArraySlice=function(){
			var _this=this;
			var sz=_this.length;
			var dec=new Uint8Array(_this.length);
			for (var i=0;i < sz;i++)dec[i]=_this[i];
			return dec;
		}

		WebGL._float32ArraySlice=function(){
			var _this=this;
			var sz=_this.length;
			var dec=new Float32Array(_this.length);
			for (var i=0;i < sz;i++)dec[i]=_this[i];
			return dec;
		}

		WebGL._uint16ArraySlice=function(__arg){
			var arg=arguments;
			var _this=this;
			var sz=0;
			var dec;
			var i=0;
			if (arg.length===0){
				sz=_this.length;
				dec=new Uint16Array(sz);
				for (i=0;i < sz;i++)
				dec[i]=_this[i];
				}else if (arg.length===2){
				var start=arg[0];
				var end=arg[1];
				if (end > start){
					sz=end-start;
					dec=new Uint16Array(sz);
					for (i=start;i < end;i++)
					dec[i-start]=_this[i];
					}else {
					dec=new Uint16Array(0);
				}
			}
			return dec;
		}

		WebGL.expandContext=function(){
			var from=Context.prototype;
			var to=CanvasRenderingContext2D.prototype;
			to.fillTrangles=from.fillTrangles;
			Buffer2D.__int__(null);
			to.setIBVB=function (x,y,ib,vb,numElement,mat,shader,shaderValues,startIndex,offset){
				(startIndex===void 0)&& (startIndex=0);
				(offset===void 0)&& (offset=0);
				if (ib===null){
					this._ib=this._ib || IndexBuffer2D.QuadrangleIB;
					ib=this._ib;
					GlUtils.expandIBQuadrangle(ib,(vb.byteLength / (4 *16)+8));
				}
				this._setIBVB(x,y,ib,vb,numElement,mat,shader,shaderValues,startIndex,offset);
			};
			to.fillTrangles=function (tex,x,y,points,m){
				this._curMat=this._curMat || Matrix.create();
				this._vb=this._vb || VertexBuffer2D.create();
				if (!this._ib){
					this._ib=IndexBuffer2D.create();
					GlUtils.fillIBQuadrangle(this._ib,length / 4);
				};
				var vb=this._vb;
				var length=points.length >> 4;
				GlUtils.fillTranglesVB(vb,x,y,points,m || this._curMat,0,0);
				GlUtils.expandIBQuadrangle(this._ib,(vb.byteLength / (4 *16)+8));
				var shaderValues=new Value2D(0x01,0);
				shaderValues.textureHost=tex;
				var sd=new Shader2X("attribute vec2 position; attribute vec2 texcoord; uniform vec2 size; uniform mat4 mmat; varying vec2 v_texcoord; void main() { vec4 p=vec4(position.xy,0.0,1.0);vec4 pos=mmat*p; gl_Position =vec4((pos.x/size.x-0.5)*2.0,(0.5-pos.y/size.y)*2.0,pos.z,1.0); v_texcoord = texcoord; }","precision mediump float; varying vec2 v_texcoord; uniform sampler2D texture; void main() {vec4 color= texture2D(texture, v_texcoord); color.a*=1.0; gl_FragColor= color;}");
				vb._vertType=3;
				this._setIBVB(x,y,this._ib,vb,length *6,m,sd,shaderValues,0,0);
			}
		}

		WebGL.enable=function(){
			Browser.__init__();
			if (Render.isConchApp){
				if (!Render.isConchWebGL){
					RunDriver.skinAniSprite=function (){
						var tSkinSprite=new SkinMesh()
						return tSkinSprite;
					}
					WebGL.expandContext();
					return false;
				}
			}
			RunDriver.getWebGLContext=function getWebGLContext (canvas){
				var gl;
				var names=["webgl","experimental-webgl","webkit-3d","moz-webgl"];
				for (var i=0;i < names.length;i++){
					try {
						gl=canvas.getContext(names[i],{stencil:Config.isStencil,alpha:Config.isAlpha,antialias:Config.isAntialias,premultipliedAlpha:Config.premultipliedAlpha,preserveDrawingBuffer:Config.preserveDrawingBuffer});
					}catch (e){}
					if (gl){
						(i!==0)&& (WebGL._isExperimentalWebgl=true);
						return gl;
					}
				}
				return null;
			}
			WebGL.mainContext=RunDriver.getWebGLContext(Render._mainCanvas);
			if (WebGL.mainContext==null)
				return false;
			if (Render.isWebGL)return true;
			HTMLImage.create=function (src,def){
				return new WebGLImage(src,def);
			}
			HTMLSubImage.create=function (canvas,offsetX,offsetY,width,height,atlasImage,src){
				return new WebGLSubImage(canvas,offsetX,offsetY,width,height,atlasImage,src);
			}
			Render.WebGL=WebGL;
			Render.isWebGL=true;
			DrawText.__init__();
			RunDriver.createRenderSprite=function (type,next){
				return new RenderSprite3D(type,next);
			}
			RunDriver.createWebGLContext2D=function (c){
				return new WebGLContext2D(c);
			}
			RunDriver.changeWebGLSize=function (width,height){
				laya.webgl.WebGL.onStageResize(width,height);
			}
			RunDriver.createGraphics=function (){
				return new GraphicsGL();
			};
			var action=RunDriver.createFilterAction;
			RunDriver.createFilterAction=action ? action :function (type){
				return new ColorFilterActionGL()
			}
			RunDriver.clear=function (color){
				RenderState2D.worldScissorTest && laya.webgl.WebGL.mainContext.disable(0x0C11);
				var ctx=Render.context.ctx;
				var c=(ctx._submits._length==0 || Config.preserveDrawingBuffer)? Color.create(color)._color :Laya.stage._wgColor;
				if (c)ctx.clearBG(c[0],c[1],c[2],c[3]);
				RenderState2D.clear();
			}
			RunDriver.addToAtlas=function (texture,force){
				(force===void 0)&& (force=false);
				var bitmap=texture.bitmap;
				if (!Render.optimizeTextureMemory(texture.url,texture)){
					(bitmap).enableMerageInAtlas=false;
					return;
				}
				if ((Laya.__typeof(bitmap,'laya.webgl.resource.IMergeAtlasBitmap'))&& ((bitmap).allowMerageInAtlas)){
					bitmap.on("recovered",texture,texture.addTextureToAtlas);
				}
			}
			AtlasResourceManager._enable();
			RunDriver.beginFlush=function (){
				var atlasResourceManager=AtlasResourceManager.instance;
				var count=atlasResourceManager.getAtlaserCount();
				for (var i=0;i < count;i++){
					var atlerCanvas=atlasResourceManager.getAtlaserByIndex(i).texture;
					(atlerCanvas._flashCacheImageNeedFlush)&& (RunDriver.flashFlushImage(atlerCanvas));
				}
			}
			RunDriver.drawToCanvas=function (sprite,_renderType,canvasWidth,canvasHeight,offsetX,offsetY){
				offsetX-=sprite.x;
				offsetY-=sprite.y;
				var renderTarget=new RenderTarget2D(canvasWidth,canvasHeight,0x1908,0x1401,0,false);
				renderTarget.start();
				Render.context.clear();
				sprite.render(Render.context,offsetX,RenderState2D.height-canvasHeight+offsetY);
				Render.context.flush();
				renderTarget.end();
				var pixels=renderTarget.getData(0,0,renderTarget.width,renderTarget.height);
				renderTarget.dispose();
				var htmlCanvas=new WebGLCanvas();
				htmlCanvas._canvas=Browser.createElement("canvas");
				htmlCanvas.size(canvasWidth,canvasHeight);
				var context=htmlCanvas._canvas.getContext('2d');
				Browser.canvas.size(canvasWidth,canvasHeight);
				var tempContext=Browser.context;
				var imgData=tempContext.createImageData(canvasWidth,canvasHeight);
				imgData.data.set(new Uint8ClampedArray(pixels.buffer));
				tempContext.putImageData(imgData,0,0);
				context.save();
				context.translate(0,canvasHeight);
				context.scale(1,-1);
				context.drawImage(Browser.canvas.source,0,0);
				context.restore();
				return htmlCanvas;
			}
			RunDriver.createFilterAction=function (type){
				var action;
				switch (type){
					case 0x20:
						action=new ColorFilterActionGL();
						break ;
					}
				return action;
			}
			RunDriver.addTextureToAtlas=function (texture){
				texture._uvID++;
				AtlasResourceManager._atlasRestore++;
				((texture.bitmap).enableMerageInAtlas)&& (AtlasResourceManager.instance.addToAtlas(texture));
			}
			RunDriver.getTexturePixels=function (value,x,y,width,height){
				(Render.context.ctx).clear();
				var tSprite=new Sprite();
				tSprite.graphics.drawTexture(value,-x,-y);
				var tRenderTarget=RenderTarget2D.create(width,height);
				tRenderTarget.start();
				tRenderTarget.clear(0,0,0,0);
				tSprite.render(Render.context,0,0);
				(Render.context.ctx).flush();
				tRenderTarget.end();
				var tUint8Array=tRenderTarget.getData(0,0,width,height);
				var tArray=[];
				var tIndex=0;
				for (var i=height-1;i >=0;i--){
					for (var j=0;j < width;j++){
						tIndex=(i *width+j)*4;
						tArray.push(tUint8Array[tIndex]);
						tArray.push(tUint8Array[tIndex+1]);
						tArray.push(tUint8Array[tIndex+2]);
						tArray.push(tUint8Array[tIndex+3]);
					}
				}
				return tArray;
			}
			RunDriver.skinAniSprite=function (){
				var tSkinSprite=new SkinMesh()
				return tSkinSprite;
			}
			Filter._filterStart=function (scope,sprite,context,x,y){
				var b=scope.getValue("bounds");
				var source=RenderTarget2D.create(b.width,b.height);
				source.start();
				source.clear(0,0,0,0);
				scope.addValue("src",source);
				scope.addValue("ScissorTest",RenderState2D.worldScissorTest);
				if (RenderState2D.worldScissorTest){
					var tClilpRect=new Rectangle();
					tClilpRect.copyFrom((context.ctx)._clipRect)
					scope.addValue("clipRect",tClilpRect);
					RenderState2D.worldScissorTest=false;
					laya.webgl.WebGL.mainContext.disable(0x0C11);
				}
			}
			Filter._filterEnd=function (scope,sprite,context,x,y){
				var b=scope.getValue("bounds");
				var source=scope.getValue("src");
				source.end();
				var out=RenderTarget2D.create(b.width,b.height);
				out.start();
				out.clear(0,0,0,0);
				scope.addValue("out",out);
				sprite._set$P('_filterCache',out);
				sprite._set$P('_isHaveGlowFilter',scope.getValue("_isHaveGlowFilter"));
			}
			Filter._EndTarget=function (scope,context){
				var source=scope.getValue("src");
				source.recycle();
				var out=scope.getValue("out");
				out.end();
				var b=scope.getValue("ScissorTest");
				if (b){
					RenderState2D.worldScissorTest=true;
					laya.webgl.WebGL.mainContext.enable(0x0C11);
					context.ctx.save();
					var tClipRect=scope.getValue("clipRect");
					(context.ctx).clipRect(tClipRect.x,tClipRect.y,tClipRect.width,tClipRect.height);
				}
			}
			Filter._useSrc=function (scope){
				var source=scope.getValue("out");
				source.end();
				source=scope.getValue("src");
				source.start();
				source.clear(0,0,0,0);
			}
			Filter._endSrc=function (scope){
				var source=scope.getValue("src");
				source.end();
			}
			Filter._useOut=function (scope){
				var source=scope.getValue("src");
				source.end();
				source=scope.getValue("out");
				source.start();
				source.clear(0,0,0,0);
			}
			Filter._endOut=function (scope){
				var source=scope.getValue("out");
				source.end();
			}
			Filter._recycleScope=function (scope){
				scope.recycle();
			}
			Filter._filter=function (sprite,context,x,y){
				var next=this._next;
				if (next){
					var filters=sprite.filters,len=filters.length;
					if (len==1 && (filters[0].type==0x20)){
						context.ctx.save();
						context.ctx.setFilters([filters[0]]);
						next._fun.call(next,sprite,context,x,y);
						context.ctx.restore();
						return;
					};
					var shaderValue;
					var b;
					var scope=SubmitCMDScope.create();
					var p=Point.TEMP;
					var tMatrix=context.ctx._getTransformMatrix();
					var mat=Matrix.create();
					tMatrix.copyTo(mat);
					var tPadding=0;
					var tHalfPadding=0;
					var tIsHaveGlowFilter=false;
					var out=sprite._$P._filterCache ? sprite._$P._filterCache :null;
					if (!out || sprite._repaint){
						tIsHaveGlowFilter=sprite._isHaveGlowFilter();
						scope.addValue("_isHaveGlowFilter",tIsHaveGlowFilter);
						if (tIsHaveGlowFilter){
							tPadding=50;
							tHalfPadding=25;
						}
						b=new Rectangle();
						b.copyFrom((sprite).getSelfBounds());
						b.x+=(sprite).x;
						b.y+=(sprite).y;
						b.x-=(sprite).pivotX+4;
						b.y-=(sprite).pivotY+4;
						var tSX=b.x;
						var tSY=b.y;
						b.width+=(tPadding+8);
						b.height+=(tPadding+8);
						p.x=b.x *mat.a+b.y *mat.c;
						p.y=b.y *mat.d+b.x *mat.b;
						b.x=p.x;
						b.y=p.y;
						p.x=b.width *mat.a+b.height *mat.c;
						p.y=b.height *mat.d+b.width *mat.b;
						b.width=p.x;
						b.height=p.y;
						if (b.width <=0 || b.height <=0){
							return;
						}
						out && out.recycle();
						scope.addValue("bounds",b);
						var submit=SubmitCMD.create([scope,sprite,context,0,0],Filter._filterStart);
						context.addRenderObject(submit);
						(context.ctx)._renderKey=0;
						(context.ctx)._shader2D.glTexture=null;
						var tX=sprite.x-tSX+tHalfPadding;
						var tY=sprite.y-tSY+tHalfPadding;
						next._fun.call(next,sprite,context,tX,tY);
						submit=SubmitCMD.create([scope,sprite,context,0,0],Filter._filterEnd);
						context.addRenderObject(submit);
						for (var i=0;i < len;i++){
							if (i !=0){
								submit=SubmitCMD.create([scope],Filter._useSrc);
								context.addRenderObject(submit);
								shaderValue=Value2D.create(0x01,0);
								Matrix.TEMP.identity();
								context.ctx.drawTarget(scope,0,0,b.width,b.height,Matrix.TEMP,"out",shaderValue,null,BlendMode.TOINT.overlay);
								submit=SubmitCMD.create([scope],Filter._useOut);
								context.addRenderObject(submit);
							};
							var fil=filters[i];
							fil.action.apply3d(scope,sprite,context,0,0);
						}
						submit=SubmitCMD.create([scope,context],Filter._EndTarget);
						context.addRenderObject(submit);
						}else {
						tIsHaveGlowFilter=sprite._$P._isHaveGlowFilter ? sprite._$P._isHaveGlowFilter :false;
						if (tIsHaveGlowFilter){
							tPadding=50;
							tHalfPadding=25;
						}
						b=sprite.getBounds();
						if (b.width <=0 || b.height <=0){
							return;
						}
						b.width+=tPadding;
						b.height+=tPadding;
						p.x=b.x *mat.a+b.y *mat.c;
						p.y=b.y *mat.d+b.x *mat.b;
						b.x=p.x;
						b.y=p.y;
						p.x=b.width *mat.a+b.height *mat.c;
						p.y=b.height *mat.d+b.width *mat.b;
						b.width=p.x;
						b.height=p.y;
						scope.addValue("out",out);
					}
					x=x-tHalfPadding-sprite.x;
					y=y-tHalfPadding-sprite.y;
					p.setTo(x,y);
					mat.transformPoint(p);
					x=p.x+b.x;
					y=p.y+b.y;
					shaderValue=Value2D.create(0x01,0);
					Matrix.TEMP.identity();
					(context.ctx).drawTarget(scope,x,y,b.width,b.height,Matrix.TEMP,"out",shaderValue,null,BlendMode.TOINT.overlay);
					submit=SubmitCMD.create([scope],Filter._recycleScope);
					context.addRenderObject(submit);
					mat.destroy();
				}
			}
			Float32Array.prototype.slice || (Float32Array.prototype.slice=WebGL._float32ArraySlice);
			Uint16Array.prototype.slice || (Uint16Array.prototype.slice=WebGL._uint16ArraySlice);
			Uint8Array.prototype.slice || (Uint8Array.prototype.slice=WebGL._uint8ArraySlice);
			return true;
		}

		WebGL.onStageResize=function(width,height){
			if (WebGL.mainContext==null)return;
			WebGL.mainContext.viewport(0,0,width,height);
			RenderState2D.width=width;
			RenderState2D.height=height;
		}

		WebGL.isExperimentalWebgl=function(){
			return WebGL._isExperimentalWebgl;
		}

		WebGL.addRenderFinish=function(){
			if (WebGL._isExperimentalWebgl || Render.isFlash){
				RunDriver.endFinish=function (){
					Render.context.ctx.finish();
				}
			}
		}

		WebGL.removeRenderFinish=function(){
			if (WebGL._isExperimentalWebgl){
				RunDriver.endFinish=function (){}
			}
		}

		WebGL.onInvalidGLRes=function(){
			AtlasResourceManager.instance.freeAll();
			ResourceManager.releaseContentManagers(true);
			WebGL.doNodeRepaint(Laya.stage);
			WebGL.mainContext.viewport(0,0,RenderState2D.width,RenderState2D.height);
			Laya.stage.event("devicelost");
		}

		WebGL.doNodeRepaint=function(sprite){
			(sprite.numChildren==0)&& (sprite.repaint());
			for (var i=0;i < sprite.numChildren;i++)
			WebGL.doNodeRepaint(sprite.getChildAt(i));
		}

		WebGL.init=function(canvas,width,height){
			WebGL.mainCanvas=canvas;
			HTMLCanvas._createContext=function (canvas){
				return new WebGLContext2D(canvas);
			}
			WebGL._isExperimentalWebgl=(WebGL._isExperimentalWebgl && (Browser.onWeiXin || Browser.onMQQBrowser));
			WebGL.frameShaderHighPrecision=false;
			var gl=laya.webgl.WebGL.mainContext;
			try {
				var precisionFormat=gl.getShaderPrecisionFormat(0x8B30,0x8DF2);
				precisionFormat.precision ? WebGL.frameShaderHighPrecision=true :WebGL.frameShaderHighPrecision=false;
			}catch (e){}
			gl.deleteTexture1=gl.deleteTexture;
			gl.deleteTexture=function (t){
				if (t==WebGLContext.curBindTexValue){
					WebGLContext.curBindTexValue=null;
				}
				gl.deleteTexture1(t);
			}
			WebGL.onStageResize(width,height);
			if (WebGL.mainContext==null)
				throw new Error("webGL getContext err!");
			System.__init__();
			AtlasResourceManager.__init__();
			ShaderDefines2D.__init__();
			Submit.__init__();
			WebGLContext2D.__init__();
			Value2D.__init__();
			Shader2D.__init__();
			Buffer2D.__int__(gl);
			BlendMode._init_(gl);
			if (Render.isConchApp){
				conch.setOnInvalidGLRes(WebGL.onInvalidGLRes);
			}
		}

		WebGL.mainCanvas=null
		WebGL.mainContext=null
		WebGL.antialias=true;
		WebGL.frameShaderHighPrecision=false;
		WebGL._bg_null=[0,0,0,0];
		WebGL._isExperimentalWebgl=false;
		return WebGL;
	})()


	//class laya.webgl.WebGLContext
	var WebGLContext=(function(){
		function WebGLContext(){};
		__class(WebGLContext,'laya.webgl.WebGLContext');
		WebGLContext.UseProgram=function(program){
			if (WebGLContext._useProgram===program)return false;
			WebGL.mainContext.useProgram(program);
			WebGLContext._useProgram=program;
			return true;
		}

		WebGLContext.setDepthTest=function(gl,value){
			value!==WebGLContext._depthTest && (WebGLContext._depthTest=value,value?gl.enable(0x0B71):gl.disable(0x0B71));
		}

		WebGLContext.setDepthMask=function(gl,value){
			value!==WebGLContext._depthMask && (WebGLContext._depthMask=value,gl.depthMask(value));
		}

		WebGLContext.setDepthFunc=function(gl,value){
			value!==WebGLContext._depthFunc && (WebGLContext._depthFunc=value,gl.depthFunc(value));
		}

		WebGLContext.setBlend=function(gl,value){
			value!==WebGLContext._blend && (WebGLContext._blend=value,value?gl.enable(0x0BE2):gl.disable(0x0BE2));
		}

		WebGLContext.setBlendFunc=function(gl,sFactor,dFactor){
			(sFactor!==WebGLContext._sFactor||dFactor!==WebGLContext._dFactor)&& (WebGLContext._sFactor=sFactor,WebGLContext._dFactor=dFactor,gl.blendFunc(sFactor,dFactor));
		}

		WebGLContext.setCullFace=function(gl,value){
			value!==WebGLContext._cullFace && (WebGLContext._cullFace=value,value?gl.enable(0x0B44):gl.disable(0x0B44));
		}

		WebGLContext.setFrontFace=function(gl,value){
			value!==WebGLContext._frontFace && (WebGLContext._frontFace=value,gl.frontFace(value));
		}

		WebGLContext.bindTexture=function(gl,target,texture){
			gl.bindTexture(target,texture);
			WebGLContext.curBindTexTarget=target;
			WebGLContext.curBindTexValue=texture;
		}

		WebGLContext.DEPTH_BUFFER_BIT=0x00000100;
		WebGLContext.STENCIL_BUFFER_BIT=0x00000400;
		WebGLContext.COLOR_BUFFER_BIT=0x00004000;
		WebGLContext.POINTS=0x0000;
		WebGLContext.LINES=0x0001;
		WebGLContext.LINE_LOOP=0x0002;
		WebGLContext.LINE_STRIP=0x0003;
		WebGLContext.TRIANGLES=0x0004;
		WebGLContext.TRIANGLE_STRIP=0x0005;
		WebGLContext.TRIANGLE_FAN=0x0006;
		WebGLContext.ZERO=0;
		WebGLContext.ONE=1;
		WebGLContext.SRC_COLOR=0x0300;
		WebGLContext.ONE_MINUS_SRC_COLOR=0x0301;
		WebGLContext.SRC_ALPHA=0x0302;
		WebGLContext.ONE_MINUS_SRC_ALPHA=0x0303;
		WebGLContext.DST_ALPHA=0x0304;
		WebGLContext.ONE_MINUS_DST_ALPHA=0x0305;
		WebGLContext.DST_COLOR=0x0306;
		WebGLContext.ONE_MINUS_DST_COLOR=0x0307;
		WebGLContext.SRC_ALPHA_SATURATE=0x0308;
		WebGLContext.FUNC_ADD=0x8006;
		WebGLContext.BLEND_EQUATION=0x8009;
		WebGLContext.BLEND_EQUATION_RGB=0x8009;
		WebGLContext.BLEND_EQUATION_ALPHA=0x883D;
		WebGLContext.FUNC_SUBTRACT=0x800A;
		WebGLContext.FUNC_REVERSE_SUBTRACT=0x800B;
		WebGLContext.BLEND_DST_RGB=0x80C8;
		WebGLContext.BLEND_SRC_RGB=0x80C9;
		WebGLContext.BLEND_DST_ALPHA=0x80CA;
		WebGLContext.BLEND_SRC_ALPHA=0x80CB;
		WebGLContext.CONSTANT_COLOR=0x8001;
		WebGLContext.ONE_MINUS_CONSTANT_COLOR=0x8002;
		WebGLContext.CONSTANT_ALPHA=0x8003;
		WebGLContext.ONE_MINUS_CONSTANT_ALPHA=0x8004;
		WebGLContext.BLEND_COLOR=0x8005;
		WebGLContext.ARRAY_BUFFER=0x8892;
		WebGLContext.ELEMENT_ARRAY_BUFFER=0x8893;
		WebGLContext.ARRAY_BUFFER_BINDING=0x8894;
		WebGLContext.ELEMENT_ARRAY_BUFFER_BINDING=0x8895;
		WebGLContext.STREAM_DRAW=0x88E0;
		WebGLContext.STATIC_DRAW=0x88E4;
		WebGLContext.DYNAMIC_DRAW=0x88E8;
		WebGLContext.BUFFER_SIZE=0x8764;
		WebGLContext.BUFFER_USAGE=0x8765;
		WebGLContext.CURRENT_VERTEX_ATTRIB=0x8626;
		WebGLContext.FRONT=0x0404;
		WebGLContext.BACK=0x0405;
		WebGLContext.CULL_FACE=0x0B44;
		WebGLContext.FRONT_AND_BACK=0x0408;
		WebGLContext.BLEND=0x0BE2;
		WebGLContext.DITHER=0x0BD0;
		WebGLContext.STENCIL_TEST=0x0B90;
		WebGLContext.DEPTH_TEST=0x0B71;
		WebGLContext.SCISSOR_TEST=0x0C11;
		WebGLContext.POLYGON_OFFSET_FILL=0x8037;
		WebGLContext.SAMPLE_ALPHA_TO_COVERAGE=0x809E;
		WebGLContext.SAMPLE_COVERAGE=0x80A0;
		WebGLContext.NO_ERROR=0;
		WebGLContext.INVALID_ENUM=0x0500;
		WebGLContext.INVALID_VALUE=0x0501;
		WebGLContext.INVALID_OPERATION=0x0502;
		WebGLContext.OUT_OF_MEMORY=0x0505;
		WebGLContext.CW=0x0900;
		WebGLContext.CCW=0x0901;
		WebGLContext.LINE_WIDTH=0x0B21;
		WebGLContext.ALIASED_POINT_SIZE_RANGE=0x846D;
		WebGLContext.ALIASED_LINE_WIDTH_RANGE=0x846E;
		WebGLContext.CULL_FACE_MODE=0x0B45;
		WebGLContext.FRONT_FACE=0x0B46;
		WebGLContext.DEPTH_RANGE=0x0B70;
		WebGLContext.DEPTH_WRITEMASK=0x0B72;
		WebGLContext.DEPTH_CLEAR_VALUE=0x0B73;
		WebGLContext.DEPTH_FUNC=0x0B74;
		WebGLContext.STENCIL_CLEAR_VALUE=0x0B91;
		WebGLContext.STENCIL_FUNC=0x0B92;
		WebGLContext.STENCIL_FAIL=0x0B94;
		WebGLContext.STENCIL_PASS_DEPTH_FAIL=0x0B95;
		WebGLContext.STENCIL_PASS_DEPTH_PASS=0x0B96;
		WebGLContext.STENCIL_REF=0x0B97;
		WebGLContext.STENCIL_VALUE_MASK=0x0B93;
		WebGLContext.STENCIL_WRITEMASK=0x0B98;
		WebGLContext.STENCIL_BACK_FUNC=0x8800;
		WebGLContext.STENCIL_BACK_FAIL=0x8801;
		WebGLContext.STENCIL_BACK_PASS_DEPTH_FAIL=0x8802;
		WebGLContext.STENCIL_BACK_PASS_DEPTH_PASS=0x8803;
		WebGLContext.STENCIL_BACK_REF=0x8CA3;
		WebGLContext.STENCIL_BACK_VALUE_MASK=0x8CA4;
		WebGLContext.STENCIL_BACK_WRITEMASK=0x8CA5;
		WebGLContext.VIEWPORT=0x0BA2;
		WebGLContext.SCISSOR_BOX=0x0C10;
		WebGLContext.COLOR_CLEAR_VALUE=0x0C22;
		WebGLContext.COLOR_WRITEMASK=0x0C23;
		WebGLContext.UNPACK_ALIGNMENT=0x0CF5;
		WebGLContext.PACK_ALIGNMENT=0x0D05;
		WebGLContext.MAX_TEXTURE_SIZE=0x0D33;
		WebGLContext.MAX_VIEWPORT_DIMS=0x0D3A;
		WebGLContext.SUBPIXEL_BITS=0x0D50;
		WebGLContext.RED_BITS=0x0D52;
		WebGLContext.GREEN_BITS=0x0D53;
		WebGLContext.BLUE_BITS=0x0D54;
		WebGLContext.ALPHA_BITS=0x0D55;
		WebGLContext.DEPTH_BITS=0x0D56;
		WebGLContext.STENCIL_BITS=0x0D57;
		WebGLContext.POLYGON_OFFSET_UNITS=0x2A00;
		WebGLContext.POLYGON_OFFSET_FACTOR=0x8038;
		WebGLContext.TEXTURE_BINDING_2D=0x8069;
		WebGLContext.SAMPLE_BUFFERS=0x80A8;
		WebGLContext.SAMPLES=0x80A9;
		WebGLContext.SAMPLE_COVERAGE_VALUE=0x80AA;
		WebGLContext.SAMPLE_COVERAGE_INVERT=0x80AB;
		WebGLContext.NUM_COMPRESSED_TEXTURE_FORMATS=0x86A2;
		WebGLContext.COMPRESSED_TEXTURE_FORMATS=0x86A3;
		WebGLContext.DONT_CARE=0x1100;
		WebGLContext.FASTEST=0x1101;
		WebGLContext.NICEST=0x1102;
		WebGLContext.GENERATE_MIPMAP_HINT=0x8192;
		WebGLContext.BYTE=0x1400;
		WebGLContext.UNSIGNED_BYTE=0x1401;
		WebGLContext.SHORT=0x1402;
		WebGLContext.UNSIGNED_SHORT=0x1403;
		WebGLContext.INT=0x1404;
		WebGLContext.UNSIGNED_INT=0x1405;
		WebGLContext.FLOAT=0x1406;
		WebGLContext.DEPTH_COMPONENT=0x1902;
		WebGLContext.ALPHA=0x1906;
		WebGLContext.RGB=0x1907;
		WebGLContext.RGBA=0x1908;
		WebGLContext.LUMINANCE=0x1909;
		WebGLContext.LUMINANCE_ALPHA=0x190A;
		WebGLContext.UNSIGNED_SHORT_4_4_4_4=0x8033;
		WebGLContext.UNSIGNED_SHORT_5_5_5_1=0x8034;
		WebGLContext.UNSIGNED_SHORT_5_6_5=0x8363;
		WebGLContext.FRAGMENT_SHADER=0x8B30;
		WebGLContext.VERTEX_SHADER=0x8B31;
		WebGLContext.MAX_VERTEX_ATTRIBS=0x8869;
		WebGLContext.MAX_VERTEX_UNIFORM_VECTORS=0x8DFB;
		WebGLContext.MAX_VARYING_VECTORS=0x8DFC;
		WebGLContext.MAX_COMBINED_TEXTURE_IMAGE_UNITS=0x8B4D;
		WebGLContext.MAX_VERTEX_TEXTURE_IMAGE_UNITS=0x8B4C;
		WebGLContext.MAX_TEXTURE_IMAGE_UNITS=0x8872;
		WebGLContext.MAX_FRAGMENT_UNIFORM_VECTORS=0x8DFD;
		WebGLContext.SHADER_TYPE=0x8B4F;
		WebGLContext.DELETE_STATUS=0x8B80;
		WebGLContext.LINK_STATUS=0x8B82;
		WebGLContext.VALIDATE_STATUS=0x8B83;
		WebGLContext.ATTACHED_SHADERS=0x8B85;
		WebGLContext.ACTIVE_UNIFORMS=0x8B86;
		WebGLContext.ACTIVE_ATTRIBUTES=0x8B89;
		WebGLContext.SHADING_LANGUAGE_VERSION=0x8B8C;
		WebGLContext.CURRENT_PROGRAM=0x8B8D;
		WebGLContext.NEVER=0x0200;
		WebGLContext.LESS=0x0201;
		WebGLContext.EQUAL=0x0202;
		WebGLContext.LEQUAL=0x0203;
		WebGLContext.GREATER=0x0204;
		WebGLContext.NOTEQUAL=0x0205;
		WebGLContext.GEQUAL=0x0206;
		WebGLContext.ALWAYS=0x0207;
		WebGLContext.KEEP=0x1E00;
		WebGLContext.REPLACE=0x1E01;
		WebGLContext.INCR=0x1E02;
		WebGLContext.DECR=0x1E03;
		WebGLContext.INVERT=0x150A;
		WebGLContext.INCR_WRAP=0x8507;
		WebGLContext.DECR_WRAP=0x8508;
		WebGLContext.VENDOR=0x1F00;
		WebGLContext.RENDERER=0x1F01;
		WebGLContext.VERSION=0x1F02;
		WebGLContext.NEAREST=0x2600;
		WebGLContext.LINEAR=0x2601;
		WebGLContext.NEAREST_MIPMAP_NEAREST=0x2700;
		WebGLContext.LINEAR_MIPMAP_NEAREST=0x2701;
		WebGLContext.NEAREST_MIPMAP_LINEAR=0x2702;
		WebGLContext.LINEAR_MIPMAP_LINEAR=0x2703;
		WebGLContext.TEXTURE_MAG_FILTER=0x2800;
		WebGLContext.TEXTURE_MIN_FILTER=0x2801;
		WebGLContext.TEXTURE_WRAP_S=0x2802;
		WebGLContext.TEXTURE_WRAP_T=0x2803;
		WebGLContext.TEXTURE_2D=0x0DE1;
		WebGLContext.TEXTURE=0x1702;
		WebGLContext.TEXTURE_CUBE_MAP=0x8513;
		WebGLContext.TEXTURE_BINDING_CUBE_MAP=0x8514;
		WebGLContext.TEXTURE_CUBE_MAP_POSITIVE_X=0x8515;
		WebGLContext.TEXTURE_CUBE_MAP_NEGATIVE_X=0x8516;
		WebGLContext.TEXTURE_CUBE_MAP_POSITIVE_Y=0x8517;
		WebGLContext.TEXTURE_CUBE_MAP_NEGATIVE_Y=0x8518;
		WebGLContext.TEXTURE_CUBE_MAP_POSITIVE_Z=0x8519;
		WebGLContext.TEXTURE_CUBE_MAP_NEGATIVE_Z=0x851A;
		WebGLContext.MAX_CUBE_MAP_TEXTURE_SIZE=0x851C;
		WebGLContext.TEXTURE0=0x84C0;
		WebGLContext.TEXTURE1=0x84C1;
		WebGLContext.TEXTURE2=0x84C2;
		WebGLContext.TEXTURE3=0x84C3;
		WebGLContext.TEXTURE4=0x84C4;
		WebGLContext.TEXTURE5=0x84C5;
		WebGLContext.TEXTURE6=0x84C6;
		WebGLContext.TEXTURE7=0x84C7;
		WebGLContext.TEXTURE8=0x84C8;
		WebGLContext.TEXTURE9=0x84C9;
		WebGLContext.TEXTURE10=0x84CA;
		WebGLContext.TEXTURE11=0x84CB;
		WebGLContext.TEXTURE12=0x84CC;
		WebGLContext.TEXTURE13=0x84CD;
		WebGLContext.TEXTURE14=0x84CE;
		WebGLContext.TEXTURE15=0x84CF;
		WebGLContext.TEXTURE16=0x84D0;
		WebGLContext.TEXTURE17=0x84D1;
		WebGLContext.TEXTURE18=0x84D2;
		WebGLContext.TEXTURE19=0x84D3;
		WebGLContext.TEXTURE20=0x84D4;
		WebGLContext.TEXTURE21=0x84D5;
		WebGLContext.TEXTURE22=0x84D6;
		WebGLContext.TEXTURE23=0x84D7;
		WebGLContext.TEXTURE24=0x84D8;
		WebGLContext.TEXTURE25=0x84D9;
		WebGLContext.TEXTURE26=0x84DA;
		WebGLContext.TEXTURE27=0x84DB;
		WebGLContext.TEXTURE28=0x84DC;
		WebGLContext.TEXTURE29=0x84DD;
		WebGLContext.TEXTURE30=0x84DE;
		WebGLContext.TEXTURE31=0x84DF;
		WebGLContext.ACTIVE_TEXTURE=0x84E0;
		WebGLContext.REPEAT=0x2901;
		WebGLContext.CLAMP_TO_EDGE=0x812F;
		WebGLContext.MIRRORED_REPEAT=0x8370;
		WebGLContext.FLOAT_VEC2=0x8B50;
		WebGLContext.FLOAT_VEC3=0x8B51;
		WebGLContext.FLOAT_VEC4=0x8B52;
		WebGLContext.INT_VEC2=0x8B53;
		WebGLContext.INT_VEC3=0x8B54;
		WebGLContext.INT_VEC4=0x8B55;
		WebGLContext.BOOL=0x8B56;
		WebGLContext.BOOL_VEC2=0x8B57;
		WebGLContext.BOOL_VEC3=0x8B58;
		WebGLContext.BOOL_VEC4=0x8B59;
		WebGLContext.FLOAT_MAT2=0x8B5A;
		WebGLContext.FLOAT_MAT3=0x8B5B;
		WebGLContext.FLOAT_MAT4=0x8B5C;
		WebGLContext.SAMPLER_2D=0x8B5E;
		WebGLContext.SAMPLER_CUBE=0x8B60;
		WebGLContext.VERTEX_ATTRIB_ARRAY_ENABLED=0x8622;
		WebGLContext.VERTEX_ATTRIB_ARRAY_SIZE=0x8623;
		WebGLContext.VERTEX_ATTRIB_ARRAY_STRIDE=0x8624;
		WebGLContext.VERTEX_ATTRIB_ARRAY_TYPE=0x8625;
		WebGLContext.VERTEX_ATTRIB_ARRAY_NORMALIZED=0x886A;
		WebGLContext.VERTEX_ATTRIB_ARRAY_POINTER=0x8645;
		WebGLContext.VERTEX_ATTRIB_ARRAY_BUFFER_BINDING=0x889F;
		WebGLContext.COMPILE_STATUS=0x8B81;
		WebGLContext.LOW_FLOAT=0x8DF0;
		WebGLContext.MEDIUM_FLOAT=0x8DF1;
		WebGLContext.HIGH_FLOAT=0x8DF2;
		WebGLContext.LOW_INT=0x8DF3;
		WebGLContext.MEDIUM_INT=0x8DF4;
		WebGLContext.HIGH_INT=0x8DF5;
		WebGLContext.FRAMEBUFFER=0x8D40;
		WebGLContext.RENDERBUFFER=0x8D41;
		WebGLContext.RGBA4=0x8056;
		WebGLContext.RGB5_A1=0x8057;
		WebGLContext.RGB565=0x8D62;
		WebGLContext.DEPTH_COMPONENT16=0x81A5;
		WebGLContext.STENCIL_INDEX=0x1901;
		WebGLContext.STENCIL_INDEX8=0x8D48;
		WebGLContext.DEPTH_STENCIL=0x84F9;
		WebGLContext.RENDERBUFFER_WIDTH=0x8D42;
		WebGLContext.RENDERBUFFER_HEIGHT=0x8D43;
		WebGLContext.RENDERBUFFER_INTERNAL_FORMAT=0x8D44;
		WebGLContext.RENDERBUFFER_RED_SIZE=0x8D50;
		WebGLContext.RENDERBUFFER_GREEN_SIZE=0x8D51;
		WebGLContext.RENDERBUFFER_BLUE_SIZE=0x8D52;
		WebGLContext.RENDERBUFFER_ALPHA_SIZE=0x8D53;
		WebGLContext.RENDERBUFFER_DEPTH_SIZE=0x8D54;
		WebGLContext.RENDERBUFFER_STENCIL_SIZE=0x8D55;
		WebGLContext.FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE=0x8CD0;
		WebGLContext.FRAMEBUFFER_ATTACHMENT_OBJECT_NAME=0x8CD1;
		WebGLContext.FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL=0x8CD2;
		WebGLContext.FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE=0x8CD3;
		WebGLContext.COLOR_ATTACHMENT0=0x8CE0;
		WebGLContext.DEPTH_ATTACHMENT=0x8D00;
		WebGLContext.STENCIL_ATTACHMENT=0x8D20;
		WebGLContext.DEPTH_STENCIL_ATTACHMENT=0x821A;
		WebGLContext.NONE=0;
		WebGLContext.FRAMEBUFFER_COMPLETE=0x8CD5;
		WebGLContext.FRAMEBUFFER_INCOMPLETE_ATTACHMENT=0x8CD6;
		WebGLContext.FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT=0x8CD7;
		WebGLContext.FRAMEBUFFER_INCOMPLETE_DIMENSIONS=0x8CD9;
		WebGLContext.FRAMEBUFFER_UNSUPPORTED=0x8CDD;
		WebGLContext.FRAMEBUFFER_BINDING=0x8CA6;
		WebGLContext.RENDERBUFFER_BINDING=0x8CA7;
		WebGLContext.MAX_RENDERBUFFER_SIZE=0x84E8;
		WebGLContext.INVALID_FRAMEBUFFER_OPERATION=0x0506;
		WebGLContext.UNPACK_FLIP_Y_WEBGL=0x9240;
		WebGLContext.UNPACK_PREMULTIPLY_ALPHA_WEBGL=0x9241;
		WebGLContext.CONTEXT_LOST_WEBGL=0x9242;
		WebGLContext.UNPACK_COLORSPACE_CONVERSION_WEBGL=0x9243;
		WebGLContext.BROWSER_DEFAULT_WEBGL=0x9244;
		WebGLContext._useProgram=null;
		WebGLContext._depthTest=true;
		WebGLContext._depthMask=true;
		WebGLContext._depthFunc=0x0201;
		WebGLContext._blend=false;
		WebGLContext._sFactor=1;
		WebGLContext._dFactor=0;
		WebGLContext._cullFace=false;
		WebGLContext._frontFace=0x0901;
		WebGLContext.curBindTexTarget=null
		WebGLContext.curBindTexValue=null
		return WebGLContext;
	})()


	/**
	*@private
	*/
	//class laya.particle.ParticleData
	var ParticleData=(function(){
		function ParticleData(){
			this.position=null;
			this.velocity=null;
			this.startColor=null;
			this.endColor=null;
			this.sizeRotation=null;
			this.radius=null;
			this.radian=null;
			this.durationAddScale=NaN;
			this.time=NaN;
		}

		__class(ParticleData,'laya.particle.ParticleData');
		ParticleData.Create=function(settings,position,velocity,time){
			var particleData=new ParticleData();
			particleData.position=position;
			MathUtil.scaleVector3(velocity,settings.emitterVelocitySensitivity,ParticleData._tempVelocity);
			var horizontalVelocity=MathUtil.lerp(settings.minHorizontalVelocity,settings.maxHorizontalVelocity,Math.random());
			var horizontalAngle=Math.random()*Math.PI *2;
			ParticleData._tempVelocity[0]+=horizontalVelocity *Math.cos(horizontalAngle);
			ParticleData._tempVelocity[2]+=horizontalVelocity *Math.sin(horizontalAngle);
			ParticleData._tempVelocity[1]+=MathUtil.lerp(settings.minVerticalVelocity,settings.maxVerticalVelocity,Math.random());
			particleData.velocity=ParticleData._tempVelocity;
			particleData.startColor=ParticleData._tempStartColor;
			particleData.endColor=ParticleData._tempEndColor;
			var i=0;
			if (settings.disableColor){
				for (i=0;i < 4;i++){
					particleData.startColor[i]=1;
					particleData.endColor[i]=1;
				}
			}
			else{
				if (settings.colorComponentInter){
					for (i=0;i < 4;i++){
						particleData.startColor[i]=MathUtil.lerp(settings.minStartColor[i],settings.maxStartColor[i],Math.random());
						particleData.endColor[i]=MathUtil.lerp(settings.minEndColor[i],settings.maxEndColor[i],Math.random());
					}
					}else {
					MathUtil.lerpVector4(settings.minStartColor,settings.maxStartColor,Math.random(),particleData.startColor);
					MathUtil.lerpVector4(settings.minEndColor,settings.maxEndColor,Math.random(),particleData.endColor);
				}
			}
			particleData.sizeRotation=ParticleData._tempSizeRotation;
			var sizeRandom=Math.random();
			particleData.sizeRotation[0]=MathUtil.lerp(settings.minStartSize,settings.maxStartSize,sizeRandom);
			particleData.sizeRotation[1]=MathUtil.lerp(settings.minEndSize,settings.maxEndSize,sizeRandom);
			particleData.sizeRotation[2]=MathUtil.lerp(settings.minRotateSpeed,settings.maxRotateSpeed,Math.random());
			particleData.radius=ParticleData._tempRadius;
			var radiusRandom=Math.random();
			particleData.radius[0]=MathUtil.lerp(settings.minStartRadius,settings.maxStartRadius,radiusRandom);
			particleData.radius[1]=MathUtil.lerp(settings.minEndRadius,settings.maxEndRadius,radiusRandom);
			particleData.radian=ParticleData._tempRadian;
			particleData.radian[0]=MathUtil.lerp(settings.minHorizontalStartRadian,settings.maxHorizontalStartRadian,Math.random());
			particleData.radian[1]=MathUtil.lerp(settings.minVerticalStartRadian,settings.maxVerticalStartRadian,Math.random());
			var useEndRadian=settings.useEndRadian;
			particleData.radian[2]=useEndRadian?MathUtil.lerp(settings.minHorizontalEndRadian,settings.maxHorizontalEndRadian,Math.random()):particleData.radian[0];
			particleData.radian[3]=useEndRadian?MathUtil.lerp(settings.minVerticalEndRadian,settings.maxVerticalEndRadian,Math.random()):particleData.radian[1];
			particleData.durationAddScale=settings.ageAddScale *Math.random();
			particleData.time=time;
			return particleData;
		}

		__static(ParticleData,
		['_tempVelocity',function(){return this._tempVelocity=new Float32Array(3);},'_tempStartColor',function(){return this._tempStartColor=new Float32Array(4);},'_tempEndColor',function(){return this._tempEndColor=new Float32Array(4);},'_tempSizeRotation',function(){return this._tempSizeRotation=new Float32Array(3);},'_tempRadius',function(){return this._tempRadius=new Float32Array(2);},'_tempRadian',function(){return this._tempRadian=new Float32Array(4);}
		]);
		return ParticleData;
	})()


	/**
	*<code>ParticleSettings</code> 类是粒子配置数据类
	*/
	//class laya.particle.ParticleSetting
	var ParticleSetting=(function(){
		function ParticleSetting(){
			this.textureName=null;
			this.textureCount=1;
			this.maxPartices=100;
			this.duration=1;
			this.ageAddScale=0;
			this.emitterVelocitySensitivity=1;
			this.minStartSize=100;
			this.maxStartSize=100;
			this.minEndSize=100;
			this.maxEndSize=100;
			this.minHorizontalVelocity=0;
			this.maxHorizontalVelocity=0;
			this.minVerticalVelocity=0;
			this.maxVerticalVelocity=0;
			this.endVelocity=1;
			this.minRotateSpeed=0;
			this.maxRotateSpeed=0;
			this.minStartRadius=0;
			this.maxStartRadius=0;
			this.minEndRadius=0;
			this.maxEndRadius=0;
			this.minHorizontalStartRadian=0;
			this.maxHorizontalStartRadian=0;
			this.minVerticalStartRadian=0;
			this.maxVerticalStartRadian=0;
			this.useEndRadian=true;
			this.minHorizontalEndRadian=0;
			this.maxHorizontalEndRadian=0;
			this.minVerticalEndRadian=0;
			this.maxVerticalEndRadian=0;
			this.colorComponentInter=false;
			this.disableColor=false;
			this.blendState=0;
			this.emitterType="null";
			this.emissionRate=0;
			this.sphereEmitterRadius=1;
			this.sphereEmitterVelocity=0;
			this.sphereEmitterVelocityAddVariance=0;
			this.ringEmitterRadius=30;
			this.ringEmitterVelocity=0;
			this.ringEmitterVelocityAddVariance=0;
			this.ringEmitterUp=2;
			this.gravity=new Float32Array([0,0,0]);
			this.minStartColor=new Float32Array([1,1,1,1]);
			this.maxStartColor=new Float32Array([1,1,1,1]);
			this.minEndColor=new Float32Array([1,1,1,1]);
			this.maxEndColor=new Float32Array([1,1,1,1]);
			this.pointEmitterPosition=new Float32Array([0,0,0]);
			this.pointEmitterPositionVariance=new Float32Array([0,0,0]);
			this.pointEmitterVelocity=new Float32Array([0,0,0]);
			this.pointEmitterVelocityAddVariance=new Float32Array([0,0,0]);
			this.boxEmitterCenterPosition=new Float32Array([0,0,0]);
			this.boxEmitterSize=new Float32Array([0,0,0]);
			this.boxEmitterVelocity=new Float32Array([0,0,0]);
			this.boxEmitterVelocityAddVariance=new Float32Array([0,0,0]);
			this.sphereEmitterCenterPosition=new Float32Array([0,0,0]);
			this.ringEmitterCenterPosition=new Float32Array([0,0,0]);
			this.positionVariance=new Float32Array([0,0,0]);
		}

		__class(ParticleSetting,'laya.particle.ParticleSetting');
		ParticleSetting.checkSetting=function(setting){
			var key;
			for (key in ParticleSetting._defaultSetting){
				if (!setting.hasOwnProperty(key)){
					setting[key]=ParticleSetting._defaultSetting[key];
				}
			}
		}

		__static(ParticleSetting,
		['_defaultSetting',function(){return this._defaultSetting=new ParticleSetting();}
		]);
		return ParticleSetting;
	})()


	/**
	*@private
	*/
	//class laya.particle.particleUtils.CanvasShader
	var CanvasShader=(function(){
		function CanvasShader(){
			this.u_Duration=NaN;
			this.u_EndVelocity=NaN;
			this.u_Gravity=null;
			this.a_Position=null;
			this.a_Velocity=null;
			this.a_StartColor=null;
			this.a_EndColor=null;
			this.a_SizeRotation=null;
			this.a_Radius=null;
			this.a_Radian=null;
			this.a_AgeAddScale=NaN;
			this.gl_Position=null;
			this.v_Color=null;
			this.oSize=NaN;
			this._color=new Float32Array(4);
			this._position=new Float32Array(3);
		}

		__class(CanvasShader,'laya.particle.particleUtils.CanvasShader');
		var __proto=CanvasShader.prototype;
		__proto.getLen=function(position){
			return Math.sqrt(position[0] *position[0]+position[1] *position[1]+position[2] *position[2]);
		}

		__proto.ComputeParticlePosition=function(position,velocity,age,normalizedAge){
			this._position[0]=position[0];
			this._position[1]=position[1];
			this._position[2]=position[2];
			var startVelocity=this.getLen(velocity);
			var endVelocity=startVelocity *this.u_EndVelocity;
			var velocityIntegral=startVelocity *normalizedAge+(endVelocity-startVelocity)*normalizedAge *normalizedAge / 2.0;
			var lenVelocity=NaN;
			lenVelocity=this.getLen(velocity);
			var i=0,len=0;
			len=3;
			for (i=0;i < len;i++){
				this._position[i]=this._position[i]+(velocity[i] / lenVelocity)*velocityIntegral *this.u_Duration;
				this._position[i]+=this.u_Gravity[i] *age *normalizedAge;
			};
			var radius=MathUtil.lerp(this.a_Radius[0],this.a_Radius[1],normalizedAge);
			var radianHorizontal=MathUtil.lerp(this.a_Radian[0],this.a_Radian[2],normalizedAge);
			var radianVertical=MathUtil.lerp(this.a_Radian[1],this.a_Radian[3],normalizedAge);
			var r=Math.cos(radianVertical)*radius;
			this._position[1]+=Math.sin(radianVertical)*radius;
			this._position[0]+=Math.cos(radianHorizontal)*r;
			this._position[2]+=Math.sin(radianHorizontal)*r;
			return new Float32Array([this._position[0],this._position[1],0.0,1.0]);
		}

		__proto.ComputeParticleSize=function(startSize,endSize,normalizedAge){
			var size=MathUtil.lerp(startSize,endSize,normalizedAge);
			return size;
		}

		__proto.ComputeParticleRotation=function(rot,age){
			return rot *age;
		}

		__proto.ComputeParticleColor=function(startColor,endColor,normalizedAge){
			var rst=this._color;
			MathUtil.lerpVector4(startColor,endColor,normalizedAge,rst);
			rst[3]=rst[3]*normalizedAge *(1.0-normalizedAge)*(1.0-normalizedAge)*6.7;
			return rst;
		}

		__proto.clamp=function(value,min,max){
			if(value<min)return min;
			if(value>max)return max;
			return value;
		}

		__proto.getData=function(age){
			age *=1.0+this.a_AgeAddScale;
			var normalizedAge=this.clamp(age / this.u_Duration,0.0,1.0);
			this.gl_Position=this.ComputeParticlePosition(this.a_Position,this.a_Velocity,age,normalizedAge);
			var pSize=this.ComputeParticleSize(this.a_SizeRotation[0],this.a_SizeRotation[1],normalizedAge);
			var rotation=this.ComputeParticleRotation(this.a_SizeRotation[2],age);
			this.v_Color=this.ComputeParticleColor(this.a_StartColor,this.a_EndColor,normalizedAge);
			var matric=new Matrix();
			var scale=NaN;
			scale=pSize/this.oSize*2;
			matric.scale(scale,scale);
			matric.rotate(rotation);
			matric.setTranslate(this.gl_Position[0],-this.gl_Position[1]);
			var alpha=NaN;
			alpha=this.v_Color[3];
			return [this.v_Color,alpha,matric,this.v_Color[0]*alpha,this.v_Color[1]*alpha,this.v_Color[2]*alpha];
		}

		return CanvasShader;
	})()


	/**
	*
	*@private
	*
	*@created 2015-8-25 下午3:41:07
	*/
	//class laya.particle.particleUtils.CMDParticle
	var CMDParticle=(function(){
		function CMDParticle(){
			this.maxIndex=0;
			this.cmds=null;
			this.id=0;
		}

		__class(CMDParticle,'laya.particle.particleUtils.CMDParticle');
		var __proto=CMDParticle.prototype;
		__proto.setCmds=function(cmds){
			this.cmds=cmds;
			this.maxIndex=cmds.length-1;
		}

		return CMDParticle;
	})()


	//class laya.particle.particleUtils.PicTool
	var PicTool=(function(){
		function PicTool(){};
		__class(PicTool,'laya.particle.particleUtils.PicTool');
		PicTool.getCanvasPic=function(img,color){
			img=img.bitmap;
			var canvas=new HTMLCanvas("2D");
			var ctx=canvas.getContext('2d');
			canvas.size(img.width,img.height);
			var red=(color >> 16 & 0xFF);
			var green=(color >> 8 & 0xFF);
			var blue=(color & 0xFF);
			if(Render.isConchApp){
				ctx.setFilter(red/255,green/255,blue/255,0);
			}
			ctx.drawImage(img.source,0,0);
			if (!Render.isConchApp){
				var imgdata=ctx.getImageData(0,0,canvas.width,canvas.height);
				var data=imgdata.data;
				for (var i=0,n=data.length;i < n;i+=4){
					if (data[i+3]==0)continue ;
					data[i] *=red/255;
					data[i+1] *=green/255;
					data[i+2] *=blue/255;
				}
				ctx.putImageData(imgdata,0,0);
			}
			return canvas;
		}

		PicTool.getRGBPic=function(img){
			var rst;
			rst=[new Texture(PicTool.getCanvasPic(img,0xFF0000)),new Texture(PicTool.getCanvasPic(img,0x00FF00)),new Texture(PicTool.getCanvasPic(img,0x0000FF))];
			return rst;
		}

		return PicTool;
	})()


	/**
	*@private
	*/
	//class laya.html.utils.HTMLParse
	var HTMLParse=(function(){
		function HTMLParse(){};
		__class(HTMLParse,'laya.html.utils.HTMLParse');
		HTMLParse.parse=function(ower,xmlString,url){
			xmlString=xmlString.replace(/<br>/g,"<br/>");
			xmlString="<root>"+xmlString+"</root>";
			xmlString=xmlString.replace(HTMLParse.spacePattern,HTMLParse.char255);
			var xml=Utils$1.parseXMLFromString(xmlString);
			HTMLParse._parseXML(ower,xml.childNodes[0].childNodes,url);
		}

		HTMLParse._parseXML=function(parent,xml,url,href){
			var i=0,n=0;
			if (xml.join || xml.item){
				for (i=0,n=xml.length;i < n;++i){
					HTMLParse._parseXML(parent,xml[i],url,href);
				}
				}else {
				var node;
				var nodeName;
				if (xml.nodeType==3){
					var txt;
					if ((parent instanceof laya.html.dom.HTMLDivElement )){
						if (xml.nodeName==null){
							xml.nodeName="#text";
						}
						nodeName=xml.nodeName.toLowerCase();
						txt=xml.textContent.replace(/^\s+|\s+$/g,'');
						if (txt.length > 0){
							node=ClassUtils.getInstance(nodeName);
							if (node){
								parent.addChild(node);
								((node).innerTEXT=txt.replace(HTMLParse.char255AndOneSpacePattern," "));
							}
						}
						}else {
						txt=xml.textContent.replace(/^\s+|\s+$/g,'');
						if (txt.length > 0){
							((parent).innerTEXT=txt.replace(HTMLParse.char255AndOneSpacePattern," "));
						}
					}
					return;
					}else {
					nodeName=xml.nodeName.toLowerCase();
					if (nodeName=="#comment")return;
					node=ClassUtils.getInstance(nodeName);
					if (node){
						node=parent.addChild(node);
						(node).URI=url;
						(node).href=href;
						var attributes=xml.attributes;
						if (attributes && attributes.length > 0){
							for (i=0,n=attributes.length;i < n;++i){
								var attribute=attributes[i];
								var attrName=attribute.nodeName;
								var value=attribute.value;
								node._setAttributes(attrName,value);
							}
						}
						HTMLParse._parseXML(node,xml.childNodes,url,(node).href);
						}else {
						HTMLParse._parseXML(parent,xml.childNodes,url,href);
					}
				}
			}
		}

		HTMLParse.char255=String.fromCharCode(255);
		HTMLParse.spacePattern=/&nbsp;|&#160;/g;
		HTMLParse.char255AndOneSpacePattern=new RegExp(String.fromCharCode(255)+"|(\\s+)","g");
		return HTMLParse;
	})()


	/**
	*@private
	*HTML的布局类
	*对HTML的显示对象进行排版
	*/
	//class laya.html.utils.Layout
	var Layout=(function(){
		function Layout(){};
		__class(Layout,'laya.html.utils.Layout');
		Layout.later=function(element){
			if (Layout._will==null){
				Layout._will=[];
				Laya.stage.frameLoop(1,null,function(){
					if (Layout._will.length < 1)
						return;
					for (var i=0;i < Layout._will.length;i++){
						laya.html.utils.Layout.layout(Layout._will[i]);
					}
					Layout._will.length=0;
				});
			}
			Layout._will.push(element);
		}

		Layout.layout=function(element){
			if (!element || !element._style)return null;
			if ((element._style._type & 0x200)===0)
				return null;
			element.getStyle()._type &=~0x200;
			var arr=Layout._multiLineLayout(element);
			if (Render.isConchApp&&element["layaoutCallNative"]){
				(element).layaoutCallNative();
			}
			return arr;
		}

		Layout._multiLineLayout=function(element){
			var elements=new Array;
			element._addChildsToLayout(elements);
			var i=0,n=elements.length,j=0;
			var style=element._getCSSStyle();
			var letterSpacing=style.letterSpacing;
			var leading=style.leading;
			var lineHeight=style.lineHeight;
			var widthAuto=style._widthAuto()|| !style.wordWrap;
			var width=widthAuto ? 999999 :element.width;
			var height=element.height;
			var maxWidth=0;
			var exWidth=style.italic ? style.fontSize / 3 :0;
			var align=style._getAlign();
			var valign=style._getValign();
			var endAdjust=valign!==0 || align!==0 || lineHeight !=0;
			var oneLayout;
			var x=0;
			var y=0;
			var w=0;
			var h=0;
			var tBottom=0;
			var lines=new Array;
			var curStyle;
			var curPadding;
			var curLine=lines[0]=new LayoutLine();
			var newLine=false,nextNewline=false;
			var htmlWord;
			var sprite;
			curLine.h=0;
			if (style.italic)
				width-=style.fontSize / 3;
			var tWordWidth=0;
			var tLineFirstKey=true;
			function addLine (){
				curLine.y=y;
				y+=curLine.h+leading;
				curLine.mWidth=tWordWidth;
				tWordWidth=0;
				curLine=new LayoutLine();
				lines.push(curLine);
				curLine.h=0;
				x=0;
				tLineFirstKey=true;
				newLine=false;
			}
			for (i=0;i < n;i++){
				oneLayout=elements[i];
				if (oneLayout==null){
					if (!tLineFirstKey){
						x+=Layout.DIV_ELEMENT_PADDING;
					}
					curLine.wordStartIndex=curLine.elements.length;
					continue ;
				}
				tLineFirstKey=false;
				if ((oneLayout instanceof laya.html.dom.HTMLBrElement )){
					addLine();
					curLine.y=y;
					curLine.h=lineHeight;
					continue ;
					}else if (oneLayout._isChar()){
					htmlWord=oneLayout;
					if (!htmlWord.isWord){
						if (lines.length > 0 && (x+w)> width && curLine.wordStartIndex > 0){
							var tLineWord=0;
							tLineWord=curLine.elements.length-curLine.wordStartIndex+1;
							curLine.elements.length=curLine.wordStartIndex;
							i-=tLineWord;
							addLine();
							continue ;
						}
						newLine=false;
						tWordWidth+=htmlWord.width;
						}else {
						newLine=nextNewline || (htmlWord.char==='\n');
						curLine.wordStartIndex=curLine.elements.length;
					}
					w=htmlWord.width+letterSpacing;
					h=htmlWord.height;
					nextNewline=false;
					newLine=newLine || ((x+w)> width);
					newLine && addLine();
					curLine.minTextHeight=Math.min(curLine.minTextHeight,oneLayout.height);
					}else {
					curStyle=oneLayout._getCSSStyle();
					sprite=oneLayout;
					curPadding=curStyle.padding;
					curStyle._getCssFloat()===0 || (endAdjust=true);
					newLine=nextNewline || curStyle.lineElement;
					w=sprite.width *sprite._style._tf.scaleX+curPadding[1]+curPadding[3]+letterSpacing;
					h=sprite.height *sprite._style._tf.scaleY+curPadding[0]+curPadding[2];
					nextNewline=curStyle.lineElement;
					newLine=newLine || ((x+w)> width && curStyle.wordWrap);
					newLine && addLine();
				}
				curLine.elements.push(oneLayout);
				curLine.h=Math.max(curLine.h,h);
				oneLayout.x=x;
				oneLayout.y=y;
				x+=w;
				curLine.w=x-letterSpacing;
				curLine.y=y;
				maxWidth=Math.max(x+exWidth,maxWidth);
			}
			y=curLine.y+curLine.h;
			if (endAdjust){
				var tY=0;
				var tWidth=width;
				if (widthAuto && element.width > 0){
					tWidth=element.width;
				}
				for (i=0,n=lines.length;i < n;i++){
					lines[i].updatePos(0,tWidth,i,tY,align,valign,lineHeight);
					tY+=Math.max(lineHeight,lines[i].h+leading);
				}
				y=tY;
			}
			widthAuto && (element.width=maxWidth);
			(y > element.height)&& (element.height=y);
			return [maxWidth,y];
		}

		Layout._will=null
		Layout.DIV_ELEMENT_PADDING=0;
		return Layout;
	})()


	/**
	*@private
	*/
	//class laya.html.utils.LayoutLine
	var LayoutLine=(function(){
		function LayoutLine(){
			this.x=0;
			this.y=0;
			this.w=0;
			this.h=0;
			this.wordStartIndex=0;
			this.minTextHeight=99999;
			this.mWidth=0;
			this.elements=new Array;
		}

		__class(LayoutLine,'laya.html.utils.LayoutLine');
		var __proto=LayoutLine.prototype;
		/**
		*底对齐（默认）
		*@param left
		*@param width
		*@param dy
		*@param align 水平
		*@param valign 垂直
		*@param lineHeight 行高
		*/
		__proto.updatePos=function(left,width,lineNum,dy,align,valign,lineHeight){
			var w=0;
			var one
			if (this.elements.length > 0){
				one=this.elements[this.elements.length-1];
				w=one.x+one.width-this.elements[0].x;
			};
			var dx=0,ddy=NaN;
			align===1 && (dx=(width-w)/ 2);
			align===2 && (dx=(width-w));
			lineHeight===0 || valign !=0 || (valign=1);
			for (var i=0,n=this.elements.length;i < n;i++){
				one=this.elements[i];
				var tCSSStyle=one._getCSSStyle();
				dx!==0 && (one.x+=dx);
				switch (tCSSStyle._getValign()){
					case 0:
						one.y=dy;
						break ;
					case 1:;
						var tMinTextHeight=0;
						if (this.minTextHeight !=99999){
							tMinTextHeight=this.minTextHeight;
						};
						var tBottomLineY=(tMinTextHeight+lineHeight)/ 2;
						tBottomLineY=Math.max(tBottomLineY,this.h);
						if ((one instanceof laya.html.dom.HTMLImageElement )){
							ddy=dy+tBottomLineY-one.height;
							}else {
							ddy=dy+tBottomLineY-one.height;
						}
						one.y=ddy;
						break ;
					case 2:
						one.y=dy+(lineHeight-one.height);
						break ;
					}
			}
		}

		return LayoutLine;
	})()


	//class laya.debug.data.Base64AtlasManager
	var Base64AtlasManager=(function(){
		function Base64AtlasManager(){}
		__class(Base64AtlasManager,'laya.debug.data.Base64AtlasManager');
		Base64AtlasManager.replaceRes=function(uiO){
			Base64AtlasManager.base64.replaceRes(uiO);
		}

		__static(Base64AtlasManager,
		['dataO',function(){return this.dataO={"comp/button1.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGIAAABRCAYAAAApS3MNAAABSUlEQVR4Xu3a0QmFMADFUJ1JXM0h3moPZ6qg4AoNeLqAIenFn65jjLE40w2sQkxvcAMI0eggRKSDEEJUDEQ4/COEiBiIYFiEEBEDEQyLECJiIIJhEUJEDEQwLEKIiIEIhkUIETEQwbAIISIGIhgWIUTEQATDIoSIGIhgWIQQEQMRDIsQImIggnEvYvv9IzjfxDiP/XlgJsTcCyDEXP/v14UQImIggmERQkQMRDAsQoiIgQiGRQgRMRDBsAghIgYiGBYhRMRABMMihIgYiGBYhBARAxEMixAiYiCCYRFCRAxEMCxCiIiBCMa7iAjPpzG8fY3kF0KIiIEIhkUIETEQwbAIISIGIhgWIUTEQATDIoSIGIhgWIQQEQMRDIsQImIggmERQkQMRDAsQoiIgQiGRQgRMRDBsAghIgYiGBYhRMRABMMihIgYiGBcGJiOHTRZjZAAAAAASUVORK5CYII=","comp/line2.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAAECAYAAACOXx+WAAAAG0lEQVQYV2NkoDJgpLJ5DIxtra3/qWko1V0IAJvgApS1libIAAAAAElFTkSuQmCC","view/create.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAwAAAAkCAYAAAC9itu8AAAAdElEQVQ4T2NkwAIWLFjwH5t4QkICIyM2CXQxmAHka/j///9mXDYxMjL6YtgwBDUg+w8crIT8MBQ0oEca55JvWNPS9xgu4tISzADyNfz///8MnrRkgmHDENSALWng9fRQ0DA40xLecglbWhpqGoZCMUNKUQkANAHAJVkE5XwAAAAASUVORK5CYII=","view/rendertime.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAwAAAAkCAYAAAC9itu8AAABeUlEQVQ4T+2Uv0tCURSAvyNdcwiXBlsaaomWFgeHlqAtCPsDJHwIiUtDSxERtErtmQ6CjkHo4FpDBQ0tbVFR0BYE0eQvOnFF7T17QlOTd3m88873OD8+rtA9uVzOBIPBlIisAwvd8B1QajQahXQ63bIx6QHFYrEEJHrv7qeqZhzHOfYA+Xw+Yow5B+YHoGwymdxW1QAQEFWNAk8i8uEDuZM3gUcLZIEJYNcNqWrVcZyd7p9t8jLwYIFTYBx47UHlcjmcSCQ+B5JtpU0LnAFj3br7kE+yTalb4BCYczVqoT3AjteW4T73FlgFNgY+1IGQz4hPLGCAI2DGbweu2Auw1Vmcqk4C+8DsEOgZOBCR9/6mVdU2vgIsAdOuIVwANRFpezatuahpTYVSop1m+y6pasm8NQqSvvW61KwslkSHuCRkgvErr0taiUXaal1Sr0siWRO/9HfpF+RN9nfpB/qqmrXrv7mktVhYVm5GLo1cct9LI5e8d84/3UvfAgdlKH0EO7MAAAAASUVORK5CYII=","view/cache.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA0AAAAkCAYAAABSSLCCAAAAcElEQVQ4T2NcsGDB/4SEBEYGBgYGYtmMxCpENhhsA6mA8f///5tHNTEwkBcQpIYcSD15kUtWigi51vR/jVYdOGUQy2YkViGywWSnvTOkhiAonkY1gZIRqSEHTntkRe4g10RWQIyWe5Bgo2O5R7dkBADztyP+yFzirAAAAABJRU5ErkJggg==","comp/clip_selectBox.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGQAAAAoCAYAAAAIeF9DAAAAsElEQVRoQ+3ZQQ0AMQzEwAuqEgh/Sj2pKObhIrBsrfLonHPu12MMTEGYFg+kIFaPgmA9ClIQzQDG0w0pCGYAw2khBcEMYDgtpCCYAQynhRQEM4DhtJCCYAYwnBZSEMwAhtNCCoIZwHBmd/tTh6IUBIrx/tRbiFWkIFaPFoL1KEhBNAMYTzekIJgBDKeFFAQzgOG0kIJgBjCcFlIQzACG00IKghnAcFpIQTADGE4LwYL8U/BE1dCJ3PsAAAAASUVORK5CYII=","comp/label.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAHgAAAASCAYAAACQCxruAAAAmElEQVRoQ+3aMQqAQBBDUef+hx4Zq1mrbPnhWylECHmghVZ397OOqqp97TlugdNzgEXFIaaFuwROt0LmBEay5aXb920+FjIpMJItLy1wvhUyKTCSLS8tcL4VMikwki0vLXC+FTIpMJItLy1wvhUyKTCSLS89wPP1Qeh8M0zy+84gMMbruqjA15OxbtjAu7mPa5bj0fb/A8cLgD4n/wQKNiIAAAAASUVORK5CYII=","comp/clip_tree_arrow.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAgAAAAQCAYAAAArij59AAAAwUlEQVQoU5WRPRKCMBCFWUt6vYQeB06RUDpoBbFDa7yDwm30FGi9dHnOMiQDBgvT5c3b7+0PRVEUlVV9A3NmzL6T//SRfMz5CgCdtVafjlmzaHAigAbM2tE8YVo1pf0yvABoc9D3wACgBbMKIgD4qqDJsqqlMV8VGL5n/88geCJKlijSMBXFZUNx/CSi9WwX1r7R99thzKKqkxXRbMUWSE2u2sEwHsxHCbrMVSq6N4xRD9HAvJstylEkarhurlqnfQC58YP5+CvQNwAAAABJRU5ErkJggg==","view/bg_panel.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAMUlEQVRYR+3QQREAAAjDMGZk/l2CDD6pgl7SduexGCBAgAABAgQIECBAgAABAgS+BQ4oyStBhXcy5AAAAABJRU5ErkJggg==","view/bg_top.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAMUlEQVRYR+3QQREAAAjDMKZp/rWBDD6pgl7SduexGCBAgAABAgQIECBAgAABAgS+BQ6WyDMhXMLeQgAAAABJRU5ErkJggg==","view/clickselect.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA4AAAAqCAYAAACDdWrxAAACfElEQVRIS8WVO2iTYRSGn5OWqpMOurg0VRBdVVCsg7GgDjpZECyirl4GEYfSgBlaB5VSpApdxCJIoeKgg7dKC21ALahIiyiKKUjxAiI4qCH1lRP/hPhfAnHpGZPv+c4573nP95ukO/xHmINmtq8RtswsPiipB/gAPAFem5nCbcSWKukIsD84/A2YBh4DL8ysWLkk0qOkDcD5GLF+Ac+Ap35ZHGjAdWB5gtJvgZFYVSWdBHaFwBlg1Mw8K0ngFiAbAm+a2XBij/6HpBbgBrAEmAVeAZ1AFU40QDCWrcBZL0/S4Vq4HtgB7DWzU5XyauDBMhhWz70ryVVdb2ZuhGpI2g1MODjfiMFrxZk3s9WNwJ6snHFxQUlXgXfAPeC5mf2O2Y5oqZLcMceCw1+AseCSSTP7mSiOpM3A7RixfvgYgAd+WUQcSSnfPWBlgtIvgf5YVSVdBA6GQF/mS2bmWcvbERmHJF+payFw0MzO1TWApKXBViwL3h5/Pk4AVTjRAMFY9njJXl6wLccrcD3wAHDUzBwuRw18JtbkbkFJruomM7sf2o4u4Jals/mFRgxeFcfBQm97UyOwM+WMiwums/k3QnMps+HWpuLIRC5TCrcRW2pbT35MRiY4XDRsVmiU5uJQIZfxb0k5Ij229eQPySJ287MLGO8Rd1M0XY6AO3LjzYVSy3fAH+VICL4a6o9VtTWbnzbYGKI+IrtQ6Ns2EFuq/5jOTnWD9f4DikeFvvbqhyg2Yzo3voJSy2fAjfEJMYPRQQ2caAAfC7AW2WkvrzU79dCwnRW4Hjgg6JrrbV9VKbkKw1Csyd2Ca7on1y2krHOub3t16//2n79SarbsH7BKtfejoCjmAAAAAElFTkSuQmCC","view/resize.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA4AAAAqCAYAAACDdWrxAAABeUlEQVRIS+2UvUpdURCFvxXRKJpIEBURsVAIiiBoaaGCjY2VLyH4MBaCPoWlnQlpI6SxsQmkURQL5eK/6JK57iuRnMPZtxAkuOFUhzWz96xvjcg8tluAT5LOQqJMHba/AgPAD0nOEtruAOaB6Lon6U+ucAoYTLe7Bb5XCm1/BCaAXqAVOAHyOkYn27PA5/TGWmXHxvBeT2i7TVIM4MUp7ZhGPlY3V/pVKUxEjAIjyac74LIAjK70PwCoyfYXYDJwyqDoHtiRdFOfql0naBgIrILF/ZIi1yH6h1XbYXCPpKOq7s34GEX7JB00m445YBzYlPSQ1dF2N7CaWN2W9DNXuJxAj1uGVeuVQtvh32LyuR34DexWCv+CfAXoBzYkHb8Boe1OSRcFkBdfNY18IQiUtFUpTJjNAPEFHVfAaQFyjZ3zNBzbQ8BSWkZViEbk1uIpjXR8AKbT7jwEvpVUqEk6L0pHLN5hSWWxeq7XjI/v6Sgz0vZ7Ov7DdDwCkcb1m86tSukAAAAASUVORK5CYII=","view/clickanalyse.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA4AAAAqCAYAAACDdWrxAAAC7UlEQVRIS5WWT2hUZxTFfyfGFolkoUVKrHQiEaX+IfgHa54UQzUqpWYhLbQU6ULNwgYXuog6yiiTgK2LgtAu6yqbFkpRBEURQzJEBN200NqKkxoDLnQhFUrizJU7vje8SSbzZr7FwDy+c75z7z3nfU80uMxMDin9JC0zewvYAHwIrAH65wWaWQuwOdy8CVgUHnBd0sUKoJktBbYC24B1QHMVNeck3ZWZrYhtXpUg/3/gS0kzDnT2/cDqpFqBUUnnK5pjZutDgo01Tr0g6XbVrprZypBgO9AUU/EK+ErSyzLQzC5XkTkCfBR7fl/Smeh/qasOlPRp9DAkOgp8H5P9o6SriUAnMrOzgNdswNeSntcL9IYNAQ8kHYuXU5Y6u8ZIupldAO5I+nkOsNb8wjk/ljTZKFCSvMbSMrPSiOpNx9uAz3UP4IbfWSsdrcDH4eZuYHF46LCk47PT8S6wG9gbJmRhlfoPSLrhJvdERJs7E+S73dZKmnagsx8JB50UEHdY3+x0dIUEO2qcekTSr/OlY21I4N5dEJMwA6yX9CKejqkqGn8DemPPb0v6YrZXpyS1xYbsRD3AtZjsk5IuJQKdyMyGAa/ZnbNR0tN6gd6wXwAP8SfV0jGnxki6mV1xyf4ubdTkPue/Jf3TEJCMNZFRMQLtyNwqvaTrSkdHZry1MFM8bLLPgY5U8/SyeYHvncotb5b1A/t8c2QGg3sT2WBLBbD95PiGogr9Ej0Gbap8r4ZJ5kR+MPhW7WdGd5npEFaa15IE+YWW5uklf2S6/1N7OnfasG+Ad5KiAfyVzwYfVDQnlc71YTaA8Ntrvtq/y2eDgapdTZ0a60UMhjdvmcCgWDClJge7npSBqfRYYY5M6U/M/NqO1mQ+G7xf4VUH5rNBOXtviLQfzH0afizop0fZroOJQCdKpcfyUKrZFhTpfDgU/F4nMNcH9gPwLJ8Nls3xarUaI+mp9NhTg5GJbPBZQyb3OReayP17rutmHPga1PpCOk+zrlEAAAAASUVORK5CYII=","view/res.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABYAAAAoCAYAAAD6xArmAAADwUlEQVRIS+3WT2gcdRQH8O/b2SwNC7l4MAEPvbilUkoPOUmLjSDrZn4hxYKH/kGwyB4tQogiu/N+GymyoWguhVBQKKkHQTHsW9fUQwqKp4AgtMXkInhILl4CkoTdmSe/6XZp2pntLli8uMedt9/3mze/33yW8Jw+9Jxy0TeYmV8FcFVVTxPRiwA6AP5U1TvZbHapUqn8nrawxGBVJWvtNVWdJ6K05h1V/dhaW08KT/wRM1sAVQCRqn5JRLdyudw9Iora7faJKIrKqnrBNSWiahAEC0+GHwpm5utEdD+KopsuBMDbzPxt0oqstRdV9Za7lslkzlar1Z8erzsUHATBJhG93C34fmJi4ly5XG6nzTEIgjoRzanqkrX2amowM98F8Fq3wK34PWb+Ii14cXExv7e3V6hWq78+axQrANwt/kVEl5j5h0G2IzMfUdWCtfa3R/VPzvhTAG8AOM/MfwwYehTANwB+ZOYPE4ODIDhJRJvMvD9IqLW2GEXRbSJ6AcBtZr6UGPzoS2Y+lc/nt+bm5v5Oa2CtvaKqywC8bs06M7+eGszMn7nTBqDOzPNpwcvLyyPb29vfAZh2Naq6Za0tpAbXarUzURS53eGKL1trv0oKZ+a3AHytqplMJlOOoui4tfaDvqOw1lZUtabubBOtqOqN0dHRB/v7++62XwHwDoB33dkAUGPmoO92e/yitXZeVT8BkE1acbdpPQiCj4hIBw52hQsLC8c6nc77AN4E8FK3yQ4R/Qzgc2b+Je0ZDPU+fjiZp1eXFD5U8CB7u+/DGybgXxnFMA3/m1GISGwegNMAeuYBuON53lKpVBrePBG5RkTuSPc1b2ZmZnDzRKRnHoDYvIODg3u5XM69/E8AKAO40G1aNcb0N6/ZbF5X1fsAbjpInXnGmETzGo3GRdew+0DPGmPSzRORTQA988bHx89NTk6mmtdoNGLziGjJ9/1085rN5l1VPWSeMSbVvLW1tXwYhoXp6en+5olIbB6A2Dzf9wcyb319/cju7m5hdnY22TwRic3zPO98qVQayLxWq3U0DMPYPGNMsnmrq6snx8bGNqempgYyT0SKzjoAsXnGmP7mNZvNU9lsdqtYLKaaJyJXABwyzxiTbp6IxOYRUd33/VTzNjY2RnZ2dnrmAdgyxqSbJyJnAMTmEdFl3/cTzROR2DzHk6qWiei4Maa/eSJScZY99FRXPM+7MTIy8iAMQ6/dbsfmEVHPPGPM4OaJiBtDqnmuqfuL4Pv+8Oa1Wq1jYRg+ZR6A2DxjzP/mPRupfwAf56Q4urCh6QAAAABJRU5ErkJggg==","view/tab_panel.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABYAAABICAYAAADyMAW8AAAAcUlEQVRYR+3WsQ3AMAhE0TCMeyTvP1tShRQo7lxYegxA8fUPLuac97VhwuKXKhTlFxRQ9GPDClawYvGEDwxIZu7pFRZXr4ACinY1ghWsYMX/NxWQr22edyvGGHt6hcV1NqGAon8QVrCCFYteISDnBuQB3xJuQcDkEngAAAAASUVORK5CYII=","view/btn_close.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAAqCAYAAACz+XvQAAACmUlEQVRIS7WWS0/bUBCFz7mJmyZxENm06mNVoVZC7LqGn9FNqy55/BSWSEhs2/4uuqFVoA150JLKJvGdaiIH2TfXNoKQpeP5PHPO3GMTK/5xxTwsAUWkBeBZ+qAByb/Zh4pIA8CL9NqY5Dj7vw9YA/ABwDsAfwB8ITnUIhF5CuATgNcAfgH4RnJSCkwLl6AA/lXBtLZQQxFxoTr6q6LOFl2WmuJAtcY7ZuXIixsczfRyTlPfhpSN7BpwBeBtFdQLFJE2gI8AXi7GBBBl3Fdnv5L87XbpWxuFfQbw3NXM0dQLLdrDIH3ylGTiLLYB8CS9lpCc3tmU+xzL1Z9lEXl/n06KavjowCiK1uM4fqMd1Ov1s3a7fZntZjabtSeTiQYHgiC4aLVavZwpbofT6TQYDAaH1tod3bMwDHc7nc5PLZrNZmG/3z8WkS1jzGm32z1oNBqjUqD+6YM2m81xFWyeNkUaulAAlyKyWdTZbdqUmZKFakEVrLRDV7P5zY6m3rQp6tA1AMC5tXY7he51Op0fdwbGcdwdDodHWc2MMdcL9wGM1tbW9sMw/L6UNm6HChuNRifW2g1XM0dTL3TJZS1KkkTDFbVaLQqCIJcm6k0URRpxuvg39Xo9rtzDh5zt1Z/lXq+32rR5dKC1dt0YM08bAGd65BxN1ZB52ojIBcl82rgdWmsDkocAdgDoW22X5DxtSIZJkhyT3AJwCuCAZD5tfCP7oMaYcRVs/tAiDT1QHX2zqLPbtCkzxYFqjXfM3GKXAR3NtC6nqTccioAeA84BbCuU5B4Af9r4gCLSBXCU1UxErjPuj0Rk3xiznDYuMIWdANhwNXM09UKXXNai9LtQ9y4yxuS/XUijr9L0lXBDMp82j370HhJdWvsftiHJYFPSIqEAAAAASUVORK5CYII=","comp/combobox.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAFsAAABCCAYAAAA476rKAAACfElEQVR4Xu3bMYsTURQF4PMmExgIWkgEU5hskyJYxGYKY5VS7NzCylL8Bftj3NbKQjuxTBWbaUwhKdIYLCJotlACA5m8kQTZZZkkeN9dbuNJOXPPu/DN5ZHkMa7dbpfgx0TAEdvEedeE2HbWxDa0JjaxLQUMe3HPJrahQECrNE3RarUOJheLBbIsq9znZAdgJ0mC4XCIer1eSa/Xa4xGI+R5TuwA272RTqeDfr9fuTeZTDCfz/dmONkK/cFggGazebnCcrnEeDw+uCKxFdiNRmO3nURRBO/9bvtYrVbEVpgejXa7XfR6PUynU8xms6O1nGzlU3DO7fbu7V5dlsf/0yO2ElsSJ7ZES1lLbCWgJE5siZaylthKQEmc2BItZS2xlYCSOLElWspaYisBJXFiS7SUtcRWAkrixJZoKWuJrQSUxIkt0VLWElsJKIkTW6L1t5an6wFooRGerofKBeZ4uh4IFxrj6XqoXECOp+sBaJoIT9c1esIsT9eFYFbl/J5tJc13agyliU1sWwHDbtyziW0oYNiKk22JfXJ6xnfXjcDdFttnb43a/b9tovQ5iG30/IltBL1tQ2xiGwoYtuJkE9tQILBV/ugl4rh2MF1sPJJP59fuc7IDsTe37mHz8Bki+MoKHhFqn9+j9vs7sQN9K7G89xRx837levHzG5Lph8p1TrZK3iF//ApxdLVI4YFk/BpA9Uc5sVXYwObOCfyDJ3AoUcIh+vIRtYuve1clthJ7G8/7p4hv30Xx6weSybuDKxL7BrARxcjTF0iyN4AviH0Tpto1ONlaQUGe2AIsbSmxtYKCPLEFWNpSYmsFBXliC7C0pZfY2oWY/zeBP8uaLni/AFTVAAAAAElFTkSuQmCC","comp/textinput.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAFsAAAAWCAYAAACv8OArAAAAZElEQVRYR+3UQQkAMAwEwcZI/LtsoSL2NTGwMByZ3b3HJQIDO3H+EdidNezQGjbsUiBs+dmwQ4EwZdmwQ4EwZdmwQ4EwZdmwQ4EwZdmwQ4EwZdmwQ4EwZdmwQ4EwZdmwQ4Ew9QBe0R29X9x+dwAAAABJRU5ErkJggg==","comp/vscroll.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABEAAAAhCAYAAAA/F0BXAAAAOklEQVRIS2N8+OzVf2YWFgYmJiYGcgHjqCEYQTcaJpipaTRMRsOEmDJmNJ2MppPRdEJMCIymE2JCCQAYonwDuu2VMAAAAABJRU5ErkJggg==","comp/vscroll$down.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABEAAAAzCAYAAABxCePHAAAC/klEQVRIS+2WS0wTURSG/zszBcrLFVvjio0LiAqRRDAmGpRodFE1MQQQkOKGqBujRo3ExLjB4MaKgDzUaGQhvoJGYwAjYoioERcuDGxYEIwPkBY6nWvObXuLnXZaSklYOIu5M/fxzZn/nvPPsInJKa5qGhRFQaIH+w8xSbcymtTd+gBFYXAdyjM9sf7ORxgGR0t5/j9jpkhq2t5B0xQwBrgqNsnJ9V0j4BzQdQNtNYXWkKz0NDiaXkBTFTCFoaWmCHVtQ+AGh+4z0HNiO2bmPNYQGiXQvkuPoaqqiIgi8Pl8eHBqtwlA86MKS6Cy8z1gjIFzjqcXHBEBlpBgRNuOd+HVlYqogJiQIChcg/BtW5k8SaSSkxPJ5PRPTttHfkI7kcghIpn8NYfp33NLXp+TnYG1OWvA3ox9499nPSjdkCsgHJxOIjc43VMrugL9dEUD4Oj/PA4CsUfDX/jOjbmisHTDCCzi4t4QgLDrQF+qTYOmqhgYGw9BvLpv0ZNjQwieaU9b7ZCDriFhSt3VBSZNartHA6aUJ7SK+jqO5n5pSp1HiqSw1e3Di0ypwBpiU1XsudwnTanraDEqrg2GmZLbGkJh2jQVZY29JlPqPe03JX/uxLE7Nk3DjjP3pCn1Ne7HrNsjdYoLQsmWYtNQ3NCBgeZKzLrn/foEoogbQgvSUmz4454P7VQikGhpHzGSZdVOUqqYTGli6gemZ9yJ+0lSTalk/TrxtQOYaBnESbTinokev4UG+p+9/xoyJQKQn8x7vf7JjEFZ1FJBBvuC12RINIdAwtkIQuksnxgHhKBUZ6scQtLSNyiWJpav47z9STjbjfJ8k5iVN0eEs911bhZjUTWpbR+RztZ6uFBERNCq1rfS2e43lFhDsjPscDS9lM7W4dyCquuvpbM9PFkq0iHm7mSl2yP+bj05uxdeXZe5FHOL6Xdr17nQ79bziwew4NXFqwUTMiaEtKBPwtZjnRi8WgXPglfqsyQITc60pwpAeNpH1GRZtRM0pWVVcTJM6S+dYaRsIf025wAAAABJRU5ErkJggg==","comp/vscroll$bar.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABEAAAA/CAYAAAAGyyO8AAABYElEQVRYR+2Wv0sDMRTH30tarCg6dRWnQnFT6OiqoP+tk+Cig+AiHayDiNSlg+jgD47K1US+Lwm5s4o/mkElN1xy73KfcF/efTi+Ht3Y0X1Btw8FffdoLy3QSnuZ+HhwZe+exrS13hGGJYsTWSszN0rJ1zHDDbJ0eDYkgHjv5Nxub3TIGEsTY/xDVq6NAN7MfW2u2aCG1nQ0GEZIOXmp7Pw5BPDF+VaGIGQfbM6k0ng5kw8/wF/eJzP5JInZkjg2CSS8zk6vCys7Wb8r5qqsncAP+pdR1Lu9rvgVT4uYg+3F+PCtAzjzu/taKdKKBSS2/wkEMBg/Q+rB50zqzZb7ZPoD/GeZ1HySxGxJHJsEEl5nc22VmCFalpFJTjLKNUtFxlDfP72IogYAP8PPZekWM5OqjErFWpjjbxprABJRA/JYjOOOX4Bgo6bWGYKsfMg5k+lmy5n8uUxm8kkSs6Vw7Cstibc9Fv5vWQAAAABJRU5ErkJggg==","comp/vscroll$up.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABEAAAAzCAYAAABxCePHAAADF0lEQVRIS92WTUhUURTHz31vPv0KKmkXrtxUGNomkCANLdCUpEatJFuIClIEFRl9kGH0BYWQElLpotGKEJXAtKQooYUFpi1axLQZMCyyZJqv926cM2/uTM288emoUHfx3v16v3fuuef+72Hume/c7/cBAwaLKWaLBZjLPc0Zk0CSJGBs4SDOObDP7i9ckuXkIbLJRJDFFrJk2SGNvZNwy7ExoZEJLWnqfQ+4SlUFaHNs0gXpQhq6x0GWGe0Y7oCicGivyYsLigup7XgFJlkCJjFwNm2HqrZR4CqHoKLC3fr8GFAMpPLqEJhMoZjpay6Bnx4vpKfYoLx1kCwKBlXoOV78BygGsudCH1nwtNVBgHBBUFFzL1n0+Gx5YghOxhINiAbFG1uZODESxf+bJShKrulv8HUusp1G/IBz1qTZIGvdamBjU584Aopzs+lbDhwfFFgc2/imLq0fazgAHF5MumBtuh3YwJsPfGdeNqgY1qqqfcSprRLgr7rWZzWbwCTL8HLKFYEEgkrUn+eHIDzNbltBSG33O+jcnxNZmrYcw5Yc7hoXotRenRPyz0IgBzrGYkTp9qEtxiEV10eEKD08Wgh7bzwTonSvIV/soK5jd53rE6I0eGY3/PL5wWYxQ+nFgShRKqK6LqTwhJNEafRKNQHCcWK3WmDHqR5NlMoSQzAWUV+9vkBMsKXYLCSbs3Oe+SGqqupGrIL3h3YclifYkjo7yZ7izIzUUGrhnvXAzA+PURkR8xCwPnMVsCUVpW0bsiCUKOH9S0980JvaLJSQUTal9Q+9/RgRJQSgnvgCgdBkxkCKektSpC9cR0HCOQgiZUMI3njijwYg+COzLP9rkLr7E3Dn4Gbhp7BPDC+n0TkhlK2zJpccuSBIfVdsutVdt9U4pLbjtVC2B0cKYN/N50LZHh0rFGGguztV14aFsvWfLiVhSrVboaSlXyjbk/NlBNKFVLT0k7INX3KAx+sXfkBlKzjpJItGLlcmhmSkptAB83h9MTuCICxBRUkMwUmY5+uFPY7LmJ7GW05SZycsSos9xUsmSr8BfgGeWI6+BgEAAAAASUVORK5CYII=","comp/button.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAE0AAABFCAYAAAAPWmvdAAABA0lEQVR4Xu3ZMRGDUBRFwXwfKSgxFhfRgAbUxEakkCEO3qmX+p9m5w7NW9v7cz18I4EFbeT1fwxtbgYtmEGDVgRC458GLQiExNKgBYGQWBq0IBASS4MWBEJiadCCQEgsDVoQCImlQQsCIbE0aEEgJJZW0Pbj64Q3hFvQhmL3CQ8atLlAKCwNWhAIiaVBCwIhsTRoQSAklgYtCITE0qAFgZBYGrQgEBJLgxYEQmJp0IJASCwNWhAIiaUVtOfrdMIbwi1oQ7H7hAcN2lwgFJYGLQiExNKgBYGQWBq0IBASS4MWBEJiadCCQEgsDVoQCImlQQsCIbE0aEEgJJYGLQiExNIC2g/MxaMp6CSauwAAAABJRU5ErkJggg==","view/bg_tool.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAMklEQVRYR+3QQREAAAjDMCYG/DsEGXxSBb2ke7YeiwECBAgQIECAAAECBAgQIEDgW+AAAeIuAVS/mngAAAAASUVORK5CYII=","comp/minBtn.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABwAAAA8CAYAAAB1odqiAAAArUlEQVRYR+3X0QmAMAwE0GQN19B9nM193CmiIH7ZXOAoRc/fpjl8jVDdOj/eOc8USBcXqUjLAtDQRMSOdHb3JatTYCZUXodIy10bGxTI1Lx6/YA0Ima6W2tKFcjmdpGKtCow7NBAdxozy+804Gfx/cDqbLzWDzs0ekNY4B9nOMEehMKTVIEEyKeFSKmc18+MppRtipJuYPCa1SkwEyqvo6Tlxm8bFEijvBt9n/QA/fOPydLHcUIAAAAASUVORK5CYII=","view/zoom_out.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABYAAAAoCAYAAAD6xArmAAACy0lEQVRIS92WQU8TQRTH/28oQkj0CL0QOMAJQkz4DkS6A+GA+A00Hrhj0uy8NiTwEdBPAOrB0Fnq3U8g6gkOSjxUjpCQCu08M5u2qaVAt7YmOqfNZPa3b9/+Z35L6NOgPnHx98Gbm5sTlUplA0AGQBpACcBBKpXazmaz3+5607YVM/MjEXlNRPdbASJyTkRrzPz+Nvg1MDNPAvgI4AGA10qpvHPuSCk17ZwLAazV4HPM/PUmeDvwSwBPAbxl5sf+RmYWZo7XMvOehwPYYebnScAnAMaVUrNhGH5pBefz+Rnn3GcAJ8w8kQT8E8A9AEMA/HXrqM9fMrO/bjvataJvFdd7/IaZfS9/67ExZpeIngB4xczPklQ8KSKHPmoispdKpXKjo6PHp6enU5VKxXhoV6moVXhnjpVS5wDOwjD81K7qG7e033lXV1cviMjvvDEAP0TkYHBwcKtarT4UkXcALolo1RhTaIV3dVYYY9aIyOfZDw9fMcYUm+FdgWvtYgCmBisrpRbCMPxQh3cNbgM3zJzvCdhDcrncuojMA8gy8/eegTvO8U0Lk87/UY9ve9h/BI6iyJ+1GyLScB4RHQDYDoKgO+dFURSfFQCuOQ9A7LwgCJI5r1gsTlar1YbznHP5crl8NDw8PK2Uip3n4QMDA3OLi4udO89a23Ce1jp2nrVWtNbxh7bWxs4jop0gCDp3XhRFJyIy7pybXV5ejp3XDN7f359RSsXO01p37jxrbey8i4uLoZGRkWvOa5q/1Fp37rx+VtxwntY6dl5zK6Io2hWR2Hla686dV0vFoY+aP8xFJJdOp49LpdIUEZkaNHkqfIWd5JiIzkXkLAiCZM7zO09EYueJyBgRxc4joi0ADeeJyOrS0lJvnBdFkf8xbDhPKbWSyWR647xCocC+53XnAVjQWvfGeS1wo7XunfOstesA5pVS2Uwm8w877xeHf444cscwYAAAAABJRU5ErkJggg==","view/refresh2.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABUAAAA/CAYAAAAPIIPGAAAEIElEQVRYR+2XTUhjVxTH/+fGpBrGT/xoBQdFFMMQLNLNbLooLbaFzqKMUhCSZwsuhGG6KCNd6DuRLgqzmGVxUd8LUrpoYWZTKO1yNi2F1oVtceEHflSLqNEav8bklPuqgsl75sUPSsucTQj33v895+R/7y+XcA1B16CJ/6GoYRiDItKfzWZjExMTv5/XtoLlx2Kxm0qp1wH0AHgTwC4RfWRZ1mdewp6ig4ODN9Lp9CMieh+AchH41Lbtj92EXUUHBgaCh4eH3wJ4zSObGSLqtSzrZ9+ihmF8CODR8YIflFL3MplMNxF9IiJWIBC4Pz4+/ldR5RuG8QuAlwGsAWi3bTsVj8dvAWhOJpPfFPK2a/mGYewDeAHAV7Zt9+aK9PX1VYRCoVcApNxa4CX6J4B6AE9t2341V9QwjO8AvAFg27btytxxL9EvAbynJxNRj2VZX58sjMfjd4joyT9D9NiyrHf9iup+/gggBCALQPfxVwARAO8cWywD4LZt2z/5EtWT+vv774rIBIBSlx/mmT5dyWTyC9+WOpkYi8XalVIPRKQbwItEpHv9PRE9tCzrt6IsVcgyhcYLnv1CAkWXfxFBxzEXXXipq+8imz7P9CJdO3+N754y86A+vYFAIDY8PHw58DHzTQB54DNNs3jwMfONY6R4go+Z/YNvbGwsuLKyci74APQys3/wMfMZ8InIPaVUt4g44AuHw/eHhoaKAx8znwEfM6dGR0dviUizaZoXA59pmvtE5ICPmfPAx8wVABzwubXA1VLM7IBPRJ4mEok88DHzKfiY2R/4mPkUfCLSk0gkTsHHzHdE5Immnog8TiQS/sDHzK7gE5EIEZ2CTyl1e2RkxD/4TNO8S0Su4BORZ0qpftM0iwefaZrtAB4QkQM+AA74ADxk5ufgc78CfV99xdy61yMajUbfAvA5gJeKycZj7gqADygajf5xRYIn+6xoUbmCDM9I/LuidXV1qK2txdzcHPb39ZPAOwpmGgqFUFFRgerqauczm81iaWkJa2v64eLhU6+eKqXQ1NTkZOcWq6urWF5edh1zzZSI0NbWhvLyctdFBwcHmJ2dxe7urn/R+vp6J0sd6XQaCwsLqKysRGNjI9bX17G4uIhMRr8jiig/EokgHA7j6OgIU1NTjkBZWRl0f7e2tgo60LX8rq4u/UjC5uamU2ZuBAIBZ1O9mVsLXEU7OztRUlKCnZ0dTE9P54nqfmsnaNHJycm8cVfRlpYW1NTUOJN1pjrjk6iqqkJra6vzNZVKYWZmxp+oLq2jo8NpgQ7dx729PZSWlkKL6hARpwr9Q+aGp/m12Zubm6H9mhtacH5+HhsbG/4tdTJTZ9bQ0OD0LxgMOm7Y3t6GNv55R7XgMS3oH5cJ/y3Rq775V3X5bx8zSv8DuWzoa2vgb5tumbHGlerDAAAAAElFTkSuQmCC","view/settings2.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABUAAAA/CAYAAAAPIIPGAAAD2ElEQVRYR+1Xz08bRxT+ZjAGYQoH4rS9IBJBQJEsUC8VKNdQtamUE0fLayqhKHeOaGbFkT8gFVLZtXzk1qqKSs4NUg8RXCIQVoOQ2jRFHHCwBRj2VW+zttY/14BXVaPOyR7NfPN9771536xACEOEgImPDHRhYaHv/Pz8kEMVjUbjq6urxVZhayo/lUo9chzndTabfWMYxkMAGx7QrG3bL5LJ5B0p5f1MJvNz7QENQdPp9LdE9CMAZrcHYAaoxJ8AvARwD8AtAI9t2/7JD9wQdH5+/q7jOLzx04DqeCelnFlbW/s9EJQXGIbxq8eQ//4mhPieiJjlEwBf8qQQYtOyLFZRNeqYJpPJWCQSeUBEzz3JrwqFwvT6+vo575ybm4vGYrFNAF8AICnlbKlU2sxms4Uych2oYRh5AJ9UFggxb1mW5aeSTqfTRLTmm3tv2/bAVUCfWpb1zA9qGAaHwD/XGjQU+WVGHU0Ug4ZSUjXFnwMwXVP8nP1RAPG2i5/Z+q9pKpWaFUL8wvNE9FUmk9m48jWtLWavofztNZTb124oN2neH1mTvmoo/pcfHDGtdZ9nLbw4rrW+nvGZpvlISvl6aWnpjWmaD4nINT4hxKxS6sXy8vIdx3HuK6XaMz6ttWt8QohDInKNTwjhJtWzlJdCiHtEdEtK+VgpFWx8Wuu7RMQbWxofEb0TQsxordszPq11Q+MjoidCCNf4AGxqrYONb2VlJVYsFh84jvPck/yKW5/W2jU+rXWUwdj4OBQcYzbCxcXF5sanlMoLIaqMTylVZXymaVYZHxG9N02zufE1AH2qlKoyPqUUh6AyFwgaivzyVehoorxkdL6k/MUPIEdE0/7i5zcUGx8Rxdsufmbrv6ZKqSrjM01z48rXtLbFeA3FNT4At6/dUIJ7V/MV/6HOn0gkvgbwA4DPbyLZ2/sWwHcikUj82SHAMqe3DMrv+I6Ofw9USonJyUlXzfb2NhzHaamsKdPBwUGcnp7i7OwMAwMDGBsbc4H29vaQz+fR09OD3t5eHB8f1x3QEJQBR0dHcXFx4QL39/dXbTw5OXEBI5EIcrlcHXBDUGYxPj6O7u7uljJLpRJ2d3ddNf7RVD6DlhkWCgUcHrof0YjH44jFYu5vnt/Z2QmWz0lhsHIMi8Wiu/HDF6T7mMDExAT6+vjR8iHGHA5/8uqYTk1Noaurq3L6/v4+jo6OqtgMDQ1hZGSkMnd5eYmtra3K/0DQg4ODivTyLg7B8PBw+6ChyC8f39FEMWgoJRVK8TPbjl/T2mruWEO5SYMNo/P/xaDfeB712U3YeXv/ALDwD+TbY8Dbd9BBAAAAAElFTkSuQmCC","view/setting.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAwAAAAkCAYAAAC9itu8AAACAklEQVQ4T5XUS4iOcRTH8c9xCeVeiiiXhSJRJFIusRO2lEtZKFlgY6GxZDUrk2TFwii22JJLlERRLKRQJmXBkHIb8+hM/2d6ememed93957n93v+55zf9/mHll9VVTNxopTPR8T3piTyT1VVs7AL9zEd+4roOn5gK25HxLfacAjL8A8TWw6ta28jorc2LMLhIu7Ds2Jah4XlRVci4mNUVTUDadiLFF/G5GL4iyOYjxsYMnQ1BDfxujk0VmJPecFAO4bV2Nk05Bqzz3Za6ut86JJDx2vN4Hbj3hjBbcOt4eCaQZXUj5daT4pGoNFimI1zpdYVEf2jsTQX+5MX5NaOFdFFJHzJ2bWI+FJv6SRWYACTWliqa68ioqc2LMWpwtJ7PCymzVhSWOqOiHeZdPachqNIcXdBJV/2B6cLa5cwZLjQYOkqnuNsOeEM1uJgE43xDBsaH9QQfJ21VNBoHfpBaWHLiKGLoeO1ZnAHkpcxgkvOeoeDa0FjTnNLEfF1PJamYkcR3YmIX6OxNA35Kb7BFKwvoqf4jeV4GRE/azQ2Yh4GMaGFpbr2OSKe1Ibse1MRJ84fimkxMqc0Pc55MrjsOYvZRoofNW6/vPUSwEQ+2+tPQ14h9fX4Ap+aQ2MB1pQTB9sx5K24qmnorKWCRvtDF0PHa+0suBaW0ry91O5mus3n/wHmQwUTIH+tVgAAAABJRU5ErkJggg==","view/refresh.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAwAAAAkCAYAAAC9itu8AAACiElEQVQ4T4WVS4iPYRTGf4/7/X6XcivXcktEUhTKQkqyYCOKjWyUhezFThbIlJ3LYrIRkoWGUhhhTMko4zJujYRpxgxHj9737/P3zfh239c57/uc5/zO+UQ3T0QsBRYCtZI+5jBVx0fEcGA6MA+YCXQCVyXddWwlISL6ARuARcXvhQPrJF3/nRARvYHtwLRuFLYCFyW15ITl6XTHvwIuJzlrgHrgiqSOiqSI2ANMAL4BxyW1R8RYYKSkp8Vb8w2HgD7AE0kXSozoD0wC2nPCAWAw0CyppiRhBzAD6MgJW4D5KdDFNeSkiJgFbEvONeYE698N2K0ArPsDMAZwguN+AmeKfZgLbAb6llj7A7gk6eFfnY6I0cDKpNc1tQFNwG1JvvFPp0sKXQ2sAGokveuJpVHAHGBJ4ul76vLNapbs9dYk6R8oU7driyztA2Z3w5L1n5LUnBPWptMd/xw4l+RscsHAeeNSZMloTAG+AIcltUXERPdB0qMylk4klu5LOlni2ABgqm3Oko4BQ4Fnko6WJOxPzlXg2wV4hv2czuOYhmsBsDf1rD7fYP0HkyyzZN0twHjACZmlI0WWFgM7e2DprKQ71SyNA9YDBnFYcq0RuOZ5/h9LdsVS6yV97YmlgYDn2X3wjUa7QdKLapY8015ePrWMJVtembhewLI0YWU4eZvck/Q525pXo4M/AY+TLMP40u+SuooseVjsitm/IakzItz5QcXhKSZsBCyrpdjlwuZwfSO8mLOkdYAHqFXSrRKWvErtXFdOcJcnp0AX96ZwuldQ5uxtTrD+VUmWWXqfujwk8eQ4f68rsuRG+d/gZVb9eIk9kPS6miXvIv91rNc12TXPc5MkTyO/AFhJCujHqZlCAAAAAElFTkSuQmCC","comp/checkbox.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA4AAAAqCAYAAACDdWrxAAABbUlEQVRIS+2TP0gCURzHv88GRYsrExyOo5cEQVEtWdQQpE4N0R+HxmirXXCrKYigqMF2IRqCQByaLJqNIFpyUIzu4rIwpExODy88ITD/cJ603Rsf7/OGz+/zI5TSEAE20cZRgBMySKni8XrbwICrWAwG2ESZIadFS53J0R25brCyHZNud1vbcRuPV7fDAOu9GXJatNSZHN2R6wb/PfJCrxOZCR8Gbk6hWc6Xg8PrcgBETMIVPdIGSjYG/NoOSHcfkLqDK3qsBSRIrgRAuBF1quUPEUPhYGMwb2dhywrqQ3F0Dt++jSokJMBdhmDO52pB2WwFP7OK8rgH9os99IgppNf3QWwMFP4RNHKALrmoflIj53l6CaWpRcBkgiIkYHl6gDTrh5JJg57v/kJ1YOUixw7jfWELxMpAKUmAXAR7tg3LZ7am3IbjKDBOvPiDqkUmcoj+9H1d7k3nmHdweBubB70ON9wRzQH8pVVQb+Q/zZAEfpwDCU4AAAAASUVORK5CYII=","comp/btn_close.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABwAAAA8CAYAAAB1odqiAAAE6UlEQVRYR+3Y30+bVRgH8G/T0t/0Jy0USrIsC0E2GMKAVYcRpmSbEzIGZhqyxCxeceGVF3pjvJl/wYyJWZYY4hZBFnBuBBUW2ewYAxlsSMiyLKH8aEt/0vZtSxvM+562We15C6jlxr53zfO8z+ec5z2nOTmCk598tY19fAQs+Hlvz76QX1zpAwd+1NMNXzieU1QtFeKbvn4CXvqgC95wLKegRirC1e8GCPjh+53wMnRwedkG54aLG4yhSI/ycnPawHaKJ5M1MhGuXR8k4MX3OnjBx3NPcLX3DPfepSu3odfrYC4r5X7bVlbhcrnT4kdrjlA7xYLffj9EwJ6udnhCW9TEJ08XUgWTqE6n5XLdbk9G7MjhKmodrbwAfQPDBLxw7h1ecH3dDq/Xm1GYrZqceXIgGo0GJSXFvOCNmz8RsLv9NNyhKO+icTqc8Pl8acDLyWyr1Wo1DEYDbw2dXIz+4TsE7DzbBneQH2SruDZc8Pv9GSiLqVQq6Iv0WVe5TiHG4K1RAnaceguuYCTrCx63G4FAgAoqlUpodbqs7+sVEgyN/ELAs20t2Ajwgz6vF6FgMGtL5QoF1BoNL1qklODW6DgBT518gxcM+P1gQqFdLRqZXA6lSkVFWXDk198I2NZyAs7NMDXR7XRmYBKZjMuNMEzmljHQF46hUIrR8XsEbG228IJ+T/rGFkskkMoVHBgOBRGNRNI2vkpL/5YsODZhJeCbJ47D4WeoM4wyDLai5PsWiCUQJ2aXTN4pnswzqmS4e+8BAZstDbxg1qW3hyALTlinCPh6Uz1C0Rg2w/S/tz3UpaYWSgsgF4twf3IagvOXr297PR5YGuv+bd2s71sfzkCj1ULQe+3u9vraGlg0lw+LlZhMEIzUNu7vmYYFmz/9LJeTS9We+PIymaGl6wLizo2cokJDEawDNxLg+W7EHTkGjUWw/tBPwOMdnYg7nNQZep4/Q2B9jYspS0zQHjyUlrdTPJksNBrwYGiQgE3vtiNup4O2SSuOzk5y7z2ubYKyuBiaAwe5394XzxGw29Pi5iYLdeDCYgMmfxxOgKfPIG53UBNt049SBVNo4g864HRmxMz1x3hAIybv3CZg49ttiK/bqYneFRuCLldGYTY5OfPkQBR6PTRl6cfIVEtLivHw51ECNrS2Ir62zrtKfWtrCHo8acDLyWyrFVot1CYTbw2hqQRTY2MJsLk5K8hW8TkcCPp8GSiHqdVQG41ZtxUHTkwQ8NhrFsRXyUrke3wuF0L+TSooVxVCrc9+iBKWmvDodysB65saEFtZ5cX8Hi+YQDBrS2VKBVRa/jONqKwU05NTBKyrexWxlRUquOnfBBNidrVoZHIZClWF1DqisjLMzPxBwNraasRsdHDD6c7ApDIJVzTMRDJiRQb6EUNkLsPs7DwBa6qrELPZqCNzu/1pG1siEUOhkHK5wWAYkUg0La7T0U9tIrMZc/MLBKw+XImtZTrIMBFEouQkIBEXQJaYXXJ0O8WTeQXlZsw/XSRg1SsVvGDWpbuHIAsu/LlEwMrKCsQDAcQ93j2U2H2qUKuBUKnE4uISBF9f/Hj7wJwVhyordl/hH2Q+W1zCixoLOdNUj98Ei+byYbH5lnPkmJhL6O+18/c0/1m38/c0qVbm72nYVuTvadgu5O9pUtsif0+Tv6dhF8P/657mLz4NfQVdLmZiAAAAAElFTkSuQmCC","comp/textarea.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAFsAAAAXCAYAAABkrDOOAAAA4klEQVRoQ+3ZvQrCMBiF4e9rU+sPOErRqxDRe/KG9Fp0EAc3VzuIg1ML4uDmlkaaquDenMUTyJoDD+8W3ZyKlaoshSeogHOy1m1euOmoI1EU+auqQUf/8XHnnBzLp3jsWdaVJEnEGEPsADXU2Ifro8Gej/uSpqnHruvmaVegqirZX+4N9mIy8Nh13XEct7vE18RaK7vzjdiIFoiNUH5vEJvYQAHgFMsmNlAAOMWyiQ0UAE6xbGIDBYBTLJvYQAHgFMsmNlAAOMWyiQ0UAE79lM2fmrDy358a/q6Hhf68ng175QueKdEXxUGVVwAAAABJRU5ErkJggg==","view/re.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABYAAAAoCAYAAAD6xArmAAACpklEQVRIS+WWPUgcQRiG3+8O70QEUwTB1EJgsTGdRRrhOMjOtEtSRbBIBMFKuCtkZleES2uRQoWQJggKKW7Of7GyTRvBLkVShhS73OXMfWGOU85Es7uXs0m2XeZh+OZ95xnCHX10R1ykBvu+P5fP59+VSqVvf9pUarBS6jWAR0Q0rbWOboP3BCaiOQAHAKTW+vtN8L8BW96W4zjPPM/78Ss8FlypVEYajYbHzALAJIAHALJdoDWl1Esi4m74rWBmpiAI5pk5AHAvJj0VrXU5Fmyhvu+/AfA8YRxfaa1LsWDf92eZeSMJlJnXtdYvEo1Ca30G4GEH/ImI1lqt1nE+nz9vNBrLnVTY39uO4zxNdHgrKytjzWbzs13FzKfDw8PFxcXF8HL3Nscd8BEAN3HcgiCYbLVaHyyIiGaUUm+7R9JzQZRSo0T0BUCGmRd831/tBttK53K5zXK5/DV1pZVSG0Q0C2BXa/0kySEmKojWeoiZD4hoKpvNTiwtLX1MC7+1IFrrQWZeJaJxx3EKN5186lF0LwiC4DEz31dKvU+z69i7Ig0stnm9wv4zsDGm7bxCodBf5xlj2s5j5mkpZf+c1wHPEdFBGIbS87z+OO8S3EnAVhRFvTnv8PBwpF6ve0QkiGiSmX9znuu66ZxXq9XmAcQ6j5krUspkzqvVaqmcJ4SId54xxl6ZiZwHYN113WTOq1arZ0R05TwAa5lM5rher5/ncrllAPYl1HZeFEXJnLe3tzd2cXHRdh6A04GBgWKxWLxyXlcqjqIochPHbWdn58p5AGaEENec13NB9vf3R5vNZtt5RLTguu4159lKA9gUQqR3njHGHpx9tOxKKfvnvGq1OmQrC2AKwIQQon/OOzk5GQzD0I5hPIqi/jvPGNN2npTyH3feTzoJOzgswwlqAAAAAElFTkSuQmCC","view/search.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABUAAAAqCAYAAABcOxDuAAABX0lEQVRIS+3VsUrEQBAG4H9HiDZiJQg+gJVaiKAoWClYXWeZ7D6CtbWFr5Ai2ayQxkLQRgsLGwtBUQsRC6sDCxHxEIvIZSRwxRGSu83pNUe23c0H+89kR2AISwzBxAiinuctCSH2AawD+AFwRkR7QRC85CO0ur5SaoOZzwGM54A3IlrJw1aolPIewEJJUY+01jvde31RKeUMgNceXdLSWk9VQl3XnSWiZhnKzF9RFE1WQrPDUsonAHNFsBDiJAzDRmXUdd1tIjoFMJaDW0KI1TAMH61RpdQ0Mx8z8zMzHxLRAYBlAG0Al2ma7hpjHqxbqgNeAJgHcKW1XutEMeE4Ttv3/axXC1dh9XPgbZqmW8aYd9t3ohCVUt4BWARwkyTJZhzHH7Zgdq4MvQbw7ThOw/f9zypgKVoVsS7UX+C+v+kgeI0Oklrvb0Yw03rwlZW8Hnz14OvqjXrw1e/pPyfwCww91CttlMG7AAAAAElFTkSuQmCC","view/save.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABYAAAAoCAYAAAD6xArmAAAA1klEQVRIS+2VzQ3DIAyFwxwdoMMAA/VQ8ZByyEBhmA7QOVxxKLIaOcIoSZUfrlifHw/wM91Ky6zE7SZgANTaDEDhzYJ5odSMC7nA5U7+b4X2dVQr3ic4hHCTlMcY33xPZUUGcwBvdEJwjcfGGIQQ4rd2qenWA3hyAUuABwCP31NtN+i1v02qP4DicRybM885J2ceB/NCyUupfuLxBS4WbmKF9rNUv4p9gq21d0l5SunF91RWZDAH8EYnBNd4nDPPWitnXst0I6Leez+feVowEQ3e+wNk3ge7C/Qp3GfwkgAAAABJRU5ErkJggg=="};},'base64',function(){return this.base64=new Base64Atlas(Base64AtlasManager.dataO);}
		]);
		return Base64AtlasManager;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.debug.DebugPanel
	var DebugPanel=(function(){
		function DebugPanel(){
			this.tShowObj=null;
			this.preValueO={};
			this.div=null;
			this.debug_view=null;
			this.height=300;
			this.clickedHandler=null;
			this.fromMe=false;
			this._treeDataList=null;
			this._init();
		}

		__class(DebugPanel,'laya.debug.DebugPanel');
		var __proto=DebugPanel.prototype;
		__proto.removeNoDisplayKeys=function(arr){
			var i=0;
			for (i=arr.length-1;i >=0;i--){
				if (DebugPanel.noDisplayKeys[arr[i]]){
					arr.splice(i,1);
				}
			}
		}

		__proto.updateShowKeys=function(){
			DebugPanel.tObjKeys.length=0;
			if (!this.tShowObj)
				return;
			DebugPanel.tObjKeys=ClassTool.getObjectDisplayAbleKeys(this.tShowObj,DebugPanel.tObjKeys);
			if (this.tShowObj==Laya.stage){
				this.removeNoDisplayKeys(DebugPanel.tObjKeys);
			}
			DebugPanel.tObjKeys.sort(MathUtil.sortSmallFirst);
		}

		__proto._init=function(){
			var _$this=this;
			this.div=Browser.document.createElement('div');
			Browser.document.body.appendChild(this.div);
			this.clickedHandler=new Handler(this,this.onClickSelected);
			this.debug_view=Browser.window.layaair_debug_view;
			this.debug_view.initLayaAirDebugView(this.div);
			this.debug_view.tree.attachEvent("onSelect",function(id){
				var dataO;
				dataO=_$this.getDataByID(id,_$this._treeDataList[0]);
				if (dataO.target){
					DebugTool.showDisBound(dataO.target);
					_$this.showTargetInfo(dataO.target);
				}
			});
			this.debug_view.setValueChangeHandler(function(data,new_value){
				_$this.onValueChange(data,new_value);
			});
			this.debug_view.onRefresh(function(){
				DebugPanel.I.setRoot(Laya.stage);
			});
			this.debug_view.onInspectElement(function(){
				ClickSelectTool.I.beginClickSelect(_$this.clickedHandler);
			});
			this.debug_view.onLogInfo(function(){
				console.log(_$this.tShowObj);
			});
			this.debug_view.onPrintEnabledNodeChain(function(){
				DebugTool.traceDisMouseEnable(_$this.tShowObj);
			});
			this.debug_view.onPrintSizeChain(function(){
				DebugTool.traceDisSizeChain(_$this.tShowObj);
			});
			this.debug_view.onToggleVisibility(function(selectd){
				if (_$this.tShowObj){
					_$this.tShowObj.visible=_$this.debug_view.getVisibility();
				}
			});
			this.debug_view.onToggleDebugBorder(function(selectd){
				if (!_$this.tShowObj)
					return;
				SpriteRenderHook.showDisplayBorder(_$this.tShowObj,_$this.debug_view.getShowDebugBorder());
			});
			this.debug_view.onToggleShowCurrentCache(function(selectd){
				CacheAnalyser.showRecacheSprite=_$this.debug_view.getShowCurrentCache();
			});
			this.debug_view.onToggleShowAllCache(function(selectd){
				CacheAnalyser.showCacheSprite=_$this.debug_view.getShowAllCache();
			});
			this.debug_view.onToggleShowAtlas(function(selectd){
				console.log("toggle show atlas:",_$this.debug_view.getShowAtlas());
				if (_$this.debug_view.getShowAtlas()){
					AtlasTools.getInstance().start();
				}
				else {
					AtlasTools.getInstance().end();
				}
			});
			JSTools.showToBody(this.div,0,0);
			Laya.stage.on("resize",this,this.adptPos);
			this.adptPos();
		}

		__proto.onClickSelected=function(target){
			var dataO;
			if (!this._treeDataList)
				return;
			this.debug_view.tree.selectItem(IDTools.getObjID(target));
			this.debug_view.bounceUpInspectButton();
		}

		__proto.updateLoop=function(){
			if (this.tShowObj){
				this.showTargetInfo(this.tShowObj);
			}
		}

		__proto.onSelectItem=function(obj){
			var tTarget;
			tTarget=obj.target;
			this.showTargetInfo(tTarget);
		}

		__proto.onValueChange=function(obj,newValue){
			if (obj["type"]=="number"){
				newValue=DebugPanel.mParseFloat(newValue);
			}
			if (obj["type"]=="boolean"){
				newValue=newValue.toString()=="true";
			}
			if (this.tShowObj){
				var key;
				key=obj["key"];
				this.preValueO[key]=this.tShowObj[key]=newValue;
			}
		}

		__proto.showTargetInfo=function(tTarget){
			if (!tTarget)
				return;
			this.debug_view.setVisibility(tTarget.visible);
			this.debug_view.setShowDebugBorder(SpriteRenderHook.isDisplayShowBorder(tTarget));
			var i=0,len=0;
			len=DebugPanel.tObjKeys.length;
			var key;
			if (this.tShowObj==tTarget){
				for (i=0;i < len;i++){
					key=DebugPanel.tObjKeys[i];
					if (this.preValueO[key] !=tTarget[key]){
						this.debug_view.changeValueByLabel(key,tTarget[key]);
					}
				}
			}
			else {
				this.tShowObj=tTarget;
				this.updateShowKeys();
				var dataList;
				dataList=DebugPanel.getObjectData(tTarget);
				this.debug_view.setContents(dataList);
			}
			for (i=0;i < len;i++){
				key=DebugPanel.tObjKeys[i];
				this.preValueO[key]=tTarget[key];
			}
		}

		__proto.adptPos=function(){
			if (this.fromMe)return;
			this.fromMe=true;
			JSTools.setPos(this.div,0,Browser.clientHeight-this.height);
			this.debug_view.resize(Browser.clientWidth,this.height);
			if (!DebugPanel.overlay){
				Laya.stage.setScreenSize(Browser.clientWidth *Browser.pixelRatio,(Browser.clientHeight-this.height)*Browser.pixelRatio);
			}
			this.fromMe=false;
		}

		__proto.setRoot=function(sprite){
			var mtreeo;
			mtreeo=DebugPanel.getSpriteTreeArr(sprite);
			this._treeDataList=[mtreeo];
			var wraped;
			wraped={};
			wraped.id=0;
			wraped.item=[mtreeo];
			this.debug_view.setTree(wraped);
			Laya.timer.loop(500,this,this.updateLoop);
		}

		__proto.getDataByID=function(targetID,nodeO){
			if (!nodeO)
				return null;
			if (targetID==nodeO.id)
				return nodeO;
			var childs;
			childs=nodeO["item"];
			if (!childs)
				return null;
			var i=0,len=0;
			len=childs.length;
			var tRst;
			for (i=0;i < len;i++){
				tRst=this.getDataByID(targetID,childs[i]);
				if (tRst)
					return tRst;
			}
			return null;
		}

		__proto.getDataByTarget=function(target,nodeO){
			if (!nodeO)
				return null;
			if (target==nodeO.target)
				return nodeO;
			var childs;
			childs=nodeO["item"];
			if (!childs)
				return null;
			var i=0,len=0;
			len=childs.length;
			var tRst;
			for (i=0;i < len;i++){
				tRst=this.getDataByTarget(target,childs[i]);
				if (tRst)
					return tRst;
			}
			return null;
		}

		DebugPanel.init=function(underGame,bgColor){
			(underGame===void 0)&& (underGame=true);
			(bgColor===void 0)&& (bgColor="#ffffff");
			if (!DebugPanel.I){
				DebugPanel.overlay=!underGame;
				DivScripts.init();
				DebugTool.initBasicFunctions();
				RenderSpriteHook.init();
				SpriteRenderHook.init();
				DebugPanel.I=new DebugPanel();
				DebugPanel.I.setRoot(Laya.stage);
				CacheAnalyser.showRecacheSprite=false;
				if (bgColor){
					DebugPanel.I.div.style.background=bgColor;
				}
			}
		}

		DebugPanel.getSpriteTreeArr=function(sprite){
			var rst;
			rst={};
			rst["text"]=""+ClassTool.getNodeClassAndName(sprite);
			rst.target=sprite;
			IDTools.idObj(sprite);
			rst.id=IDTools.getObjID(sprite);
			var childs;
			childs=sprite._childs;
			var i=0,len=0;
			len=childs.length;
			var tchild;
			var childsList;
			childsList=[];
			rst["item"]=childsList;
			for (i=0;i < len;i++){
				childsList.push(DebugPanel.getSpriteTreeArr(childs[i]));
			}
			return rst;
		}

		DebugPanel.getObjectData=function(data){
			var dataList;
			var tData;
			var key;
			var tValue;
			var tType;
			dataList=[];
			var keys;
			keys=DebugPanel.tObjKeys;
			var i=0,len=0;
			len=keys.length;
			for (i=0;i < len;i++){
				key=keys[i];
				tValue=data[key];
				tType=typeof(tValue);
				if (key.charAt(0)=="_")
					continue ;
				if (DebugPanel.displayTypes[tType]){
					tData={};
					tData["key"]=key;
					tData["value"]=tValue;
					tData["type"]=tType;
					dataList.push(tData);
				}
			}
			return dataList;
		}

		DebugPanel.mParseFloat=function(v){
			var rst=NaN;
			rst=parseFloat(v);
			if (isNaN(rst))
				return 0;
			return rst;
		}

		DebugPanel.I=null
		DebugPanel.overlay=false;
		DebugPanel.ChildrenSign="item";
		DebugPanel.LabelSign="text";
		DebugPanel.tObjKeys=[];
		__static(DebugPanel,
		['displayTypes',function(){return this.displayTypes={"boolean":true,"number":true,"string":true};},'displayKeys',function(){return this.displayKeys=[["x","number"],["y","number"],["width","number"],["width","number"],["width","number"],["width","number"],["width","number"],["width","number"],["width","number"],["width","number"],["width","number"],];},'noDisplayKeys',function(){return this.noDisplayKeys={"desginWidth":true,"desginHeight":true };}
		]);
		return DebugPanel;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-9-24 下午3:00:38
	*/
	//class laya.debug.DebugTool
	var DebugTool=(function(){
		function DebugTool(){}
		__class(DebugTool,'laya.debug.DebugTool');
		__getset(1,DebugTool,'target',function(){
			return DebugTool._target;
			},function(v){
			DebugTool._target=v;
		});

		__getset(1,DebugTool,'isThisShow',function(){
			return false;
		});

		/**
		*设置是否显示帧率信息
		*@param value 是否显示true|false
		*/
		__getset(1,DebugTool,'showStatu',null,function(value){
			if (value){
				Stat.show();
			}
			else{
				Stat.hide();
				DebugTool.clearDebugLayer();
			}
		});

		/**
		*是否自动显示点击对象的边框
		*@param value
		*/
		__getset(1,DebugTool,'showBound',function(){
			return DebugTool._showBound;
			},function(value){
			DebugTool._showBound=value;
			if (!DebugTool._showBound){
				DebugTool.clearDebugLayer();
			}
		});

		DebugTool.getMenuShowEvent=function(){
			if (Browser.onMobile){
				return "doubleclick";
				}else{
				return "rightclick";
			}
		}

		DebugTool.init=function(cacheAnalyseEnable,loaderAnalyseEnable,createAnalyseEnable,renderAnalyseEnable,showCacheRec){
			(cacheAnalyseEnable===void 0)&& (cacheAnalyseEnable=true);
			(loaderAnalyseEnable===void 0)&& (loaderAnalyseEnable=true);
			(createAnalyseEnable===void 0)&& (createAnalyseEnable=true);
			(renderAnalyseEnable===void 0)&& (renderAnalyseEnable=true);
			(showCacheRec===void 0)&& (showCacheRec=false);
			DebugTool.enableCacheAnalyse=cacheAnalyseEnable;
			if (DebugTool.enableCacheAnalyse){
				RenderSpriteHook.init();
			}
			if (renderAnalyseEnable){
				SpriteRenderHook.init();
			}
			DebugTool.enableNodeCreateAnalyse=createAnalyseEnable;
			if (DebugTool.enableNodeCreateAnalyse){
				ClassCreateHook.I.hookClass(Node);
			}
			if (loaderAnalyseEnable){
				LoaderHook$1.init();
			}
			CacheAnalyser.showCacheSprite=showCacheRec;
			NodeInfoPanel.init();
			DebugTool.initBasicFunctions();
		}

		DebugTool.initBasicFunctions=function(){
			DisplayHook.initMe();
			if (!DebugTool.debugLayer){
				DebugInfoLayer.init();
				DebugTool.debugLayer=DebugInfoLayer.I.graphicLayer;
				DebugTool.debugLayer.mouseEnabled=false;
				DebugTool.debugLayer.mouseThrough=true;
				DebugTool.showStatu=true;
				Laya.stage.on("keydown",null,DebugTool.keyHandler);
				DebugTool.cmdToTypeO[0x01]="IMAGE";
				DebugTool.cmdToTypeO[0x02]="ALPHA";
				DebugTool.cmdToTypeO[0x04]="TRANSFORM";
				DebugTool.cmdToTypeO[0x10]="CANVAS";
				DebugTool.cmdToTypeO[0x200]="GRAPHICS";
				DebugTool.cmdToTypeO[0x400]="CUSTOM";
				DebugTool.cmdToTypeO[0x800]="CHILDS";
				DebugExport.export();
			}
		}

		DebugTool.dTrace=function(str){
			if (DebugTool._traceFun !=null){
				DebugTool._traceFun(str);
			}
			console.log(str);
		}

		DebugTool.keyHandler=function(e){
			var key;
			key=String.fromCharCode(e.keyCode);
			if (!e.altKey)
				return;
			switch (e.keyCode){
				case 38:
					DebugTool.showParent();
					break ;
				case 40:
					DebugTool.showChild();
					break ;
				case 37:
					DebugTool.showBrother(DebugTool.target,1);
					break ;
				case 39:
					DebugTool.showBrother(DebugTool.target,-1);
					break ;
				}
			DebugTool.dealCMDKey(key);
		}

		DebugTool.dealCMDKey=function(key){
			switch (key){
				case "上":
					DebugTool.showParent();
					break ;
				case "下":
					DebugTool.showChild();
					break ;
				case "左":
					DebugTool.showBrother(DebugTool.target,1);
					break ;
				case "右":
					DebugTool.showBrother(DebugTool.target,-1);
					break ;
				case "B":
					DebugTool.showAllBrother();
					break ;
				case "C":
					DebugTool.showAllChild();
					break ;
				case "E":
					DebugTool.traceDisMouseEnable();
					break ;
				case "S":
					DebugTool.traceDisSizeChain();
					break ;
				case "D":
					DisControlTool.downDis(DebugTool.target);
					break ;
				case "U":
					DisControlTool.upDis(DebugTool.target);
					break ;
				case "N":
					DebugTool.getNodeInfo();
					break ;
				case "M":
					DebugTool.showAllUnderMosue();
					break ;
				case "I":
					break ;
				case "O":
					ObjectCreateView.I.show();
					break ;
				case "L":
					DisController.I.switchType();
					break ;
				case "Q":
					DebugTool.showNodeInfo();
					break ;
				case "F":
					DebugTool.showToolPanel();
					break ;
				case "P":
					DebugTool.showToolFilter();
					break ;
				case "V":
					DebugTool.selectNodeUnderMouse();
					break ;
				case "A":
					if (NodeToolView.I.target){
						MouseEventAnalyser.analyseNode(NodeToolView.I.target);
					}
					break ;
				case "K":
					NodeUtils.traceStage();
					break ;
				case "T":
					DebugTool.switchNodeTree();
					break ;
				case "R":
					RenderCostRankView.I.show();
					break ;
				case "X":
					NodeTree$1.I.fresh();
					break ;
				case "mCMD":
					DebugTool.traceCMD();
					break ;
				case "allCMD":
					DebugTool.traceCMDR();
					break ;
				}
		}

		DebugTool.switchNodeTree=function(){
			ToolPanel.I.switchShow("Tree");
		}

		DebugTool.analyseMouseHit=function(){
			if (DebugTool.target)
				MouseEventAnalyser.analyseNode(DebugTool.target);
		}

		DebugTool.selectNodeUnderMouse=function(){
			DisplayHook.instance.selectDisUnderMouse();
			DebugTool.showDisBound();
			return;
		}

		DebugTool.showToolPanel=function(){
			ToolPanel.I.switchShow("Find");
		}

		DebugTool.showToolFilter=function(){
			ToolPanel.I.switchShow("Filter");
		}

		DebugTool.showNodeInfo=function(){
			if (NodeInfoPanel.I.isWorkState){
				NodeInfoPanel.I.recoverNodes();
			}
			else{
				NodeInfoPanel.I.showDisInfo(DebugTool.target);
			}
		}

		DebugTool.switchDisController=function(){
			if (DisController.I.target){
				DisController.I.target=null;
			}
			else{
				if (DebugTool.target){
					DisController.I.target=DebugTool.target;
				}
			}
		}

		DebugTool.showParent=function(sprite){
			if (!sprite)
				sprite=DebugTool.target;
			if (!sprite){
				console.log("no targetAvalible");
				return null;
			}
			DebugTool.target=sprite.parent;
			DebugTool.autoWork();
		}

		DebugTool.showChild=function(sprite){
			if (!sprite)
				sprite=DebugTool.target;
			if (!sprite){
				console.log("no targetAvalible");
				return null;
			}
			if (sprite.numChildren > 0){
				DebugTool.target=sprite.getChildAt(0);
				DebugTool.autoWork();
			}
		}

		DebugTool.showAllChild=function(sprite){
			if (!sprite)
				sprite=DebugTool.target;
			if (!sprite){
				console.log("no targetAvalible");
				return null;
			}
			DebugTool.selectedNodes=DisControlTool.getAllChild(sprite);
			DebugTool.showSelected();
		}

		DebugTool.showAllUnderMosue=function(){
			DebugTool.selectedNodes=DisControlTool.getObjectsUnderGlobalPoint(Laya.stage);
			DebugTool.showSelected();
		}

		DebugTool.showParentChain=function(sprite){
			if (!sprite)
				return;
			DebugTool.selectedNodes=[];
			var tar;
			tar=sprite.parent;
			while (tar){
				DebugTool.selectedNodes.push(tar);
				tar=tar.parent;
			}
			DebugTool.showSelected();
		}

		DebugTool.showAllBrother=function(sprite){
			if (!sprite)
				sprite=DebugTool.target;
			if (!sprite){
				console.log("no targetAvalible");
				return null;
			}
			if (!sprite.parent)
				return;
			DebugTool.selectedNodes=DisControlTool.getAllChild(sprite.parent);
			DebugTool.showSelected();
		}

		DebugTool.showBrother=function(sprite,dID){
			(dID===void 0)&& (dID=1);
			if (!sprite)
				sprite=DebugTool.target;
			if (!sprite){
				console.log("no targetAvalible");
				return null;
			};
			var p;
			p=sprite.parent;
			if (!p)
				return;
			var n=0;
			n=p.getChildIndex(sprite);
			n+=dID;
			if (n < 0)
				n+=p.numChildren;
			if (n >=p.numChildren)
				n-=p.numChildren;
			DebugTool.target=p.getChildAt(n);
			DebugTool.autoWork();
		}

		DebugTool.clearDebugLayer=function(){
			if (DebugTool.debugLayer.graphics)
				DebugTool.debugLayer.graphics.clear();
		}

		DebugTool.showSelected=function(){
			if (!DebugTool.autoShowSelected)
				return;
			if (!DebugTool.selectedNodes || DebugTool.selectedNodes.length < 1)
				return;
			console.log("selected:",DebugTool.selectedNodes);
			var i=0;
			var len=0;
			len=DebugTool.selectedNodes.length;
			DebugTool.clearDebugLayer();
			for (i=0;i < len;i++){
				DebugTool.showDisBound(DebugTool.selectedNodes[i],false);
			}
		}

		DebugTool.getClassCreateInfo=function(className){
			return RunProfile.getRunInfo(className);
		}

		DebugTool.autoWork=function(){
			if (!DebugTool.isThisShow)
				return;
			if (DebugTool.showBound)
				DebugTool.showDisBound();
			if (DebugTool.autoTraceSpriteInfo && DebugTool.target){
				TraceTool.traceSpriteInfo(DebugTool.target,DebugTool.autoTraceBounds,DebugTool.autoTraceSize,DebugTool.autoTraceTree);
			}
			if (!DebugTool.target)
				return;
			if (DebugTool.autoTraceCMD){
				DebugTool.traceCMD();
			}
			if (DebugTool.autoTraceCMDR){
				DebugTool.traceCMDR();
			}
			if (DebugTool.autoTraceEnable){
				DebugTool.traceDisMouseEnable(DebugTool.target);
			}
		}

		DebugTool.traceDisMouseEnable=function(tar){
			console.log("----------------traceDisMouseEnable--------------------");
			if (!tar)
				tar=DebugTool.target;
			if (!tar){
				console.log("no targetAvalible");
				return null;
			};
			var strArr;
			strArr=[];
			DebugTool.selectedNodes=[];
			while (tar){
				strArr.push(ClassTool.getNodeClassAndName(tar)+": mouseEnabled:"+tar.mouseEnabled+" hitFirst:"+tar.hitTestPrior);
				DebugTool.selectedNodes.push(tar);
				tar=tar.parent;
			}
			console.log(strArr.join("\n"));
			DebugTool.showSelected();
			return strArr.join("\n");
		}

		DebugTool.traceDisSizeChain=function(tar){
			console.log("---------------------traceDisSizeChain-------------------");
			if (!tar)
				tar=DebugTool.target;
			if (!tar){
				console.log("no targetAvalible");
				return null;
			}
			DebugTool.selectedNodes=[];
			var strArr;
			strArr=[];
			while (tar){
				strArr.push(ClassTool.getNodeClassAndName(tar)+": x:"+tar.x+" y:"+tar.y+" w:"+tar.width+" h:"+tar.height+" scaleX:"+tar.scaleX+" scaleY:"+tar.scaleY);
				DebugTool.selectedNodes.push(tar);
				tar=tar.parent;
			}
			console.log(strArr.join("\n"));
			DebugTool.showSelected();
			return strArr.join("\n");
		}

		DebugTool.showDisBound=function(sprite,clearPre,color){
			(clearPre===void 0)&& (clearPre=true);
			(color===void 0)&& (color="#ff0000");
			if (!sprite)
				sprite=DebugTool.target;
			if (!sprite){
				console.log("no targetAvalible");
				return null;
			}
			if (clearPre)
				DebugTool.clearDebugLayer();
			var pointList;
			pointList=sprite._getBoundPointsM(true);
			if (!pointList || pointList.length < 1)
				return;
			pointList=GrahamScan.pListToPointList(pointList,true);
			WalkTools.walkArr(pointList,sprite.localToGlobal,sprite);
			pointList=GrahamScan.pointListToPlist(pointList);
			DebugTool._disBoundRec=Rectangle._getWrapRec(pointList,DebugTool._disBoundRec);
			DebugTool.debugLayer.graphics.drawRect(DebugTool._disBoundRec.x,DebugTool._disBoundRec.y,DebugTool._disBoundRec.width,DebugTool._disBoundRec.height,null,color);
			DebugInfoLayer.I.setTop();
		}

		DebugTool.showDisBoundToSprite=function(sprite,graphicSprite,color,lineWidth){
			(color===void 0)&& (color="#ff0000");
			(lineWidth===void 0)&& (lineWidth=1);
			var pointList;
			pointList=sprite._getBoundPointsM(true);
			if (!pointList || pointList.length < 1)
				return;
			pointList=GrahamScan.pListToPointList(pointList,true);
			WalkTools.walkArr(pointList,sprite.localToGlobal,sprite);
			pointList=GrahamScan.pointListToPlist(pointList);
			DebugTool._disBoundRec=Rectangle._getWrapRec(pointList,DebugTool._disBoundRec);
			graphicSprite.graphics.drawRect(DebugTool._disBoundRec.x,DebugTool._disBoundRec.y,DebugTool._disBoundRec.width,DebugTool._disBoundRec.height,null,color,lineWidth);
		}

		DebugTool.getNodeInfo=function(){
			DebugTool.counter.reset();
			WalkTools.walkTarget(Laya.stage,DebugTool.addNodeInfo);
			console.log("node info:");
			DebugTool.counter.traceSelf();
			return DebugTool.counter.data;
		}

		DebugTool.findByClass=function(className){
			DebugTool._classList=[];
			DebugTool._tFindClass=className;
			WalkTools.walkTarget(Laya.stage,DebugTool.addClassNode);
			DebugTool.selectedNodes=DebugTool._classList;
			DebugTool.showSelected();
			return DebugTool._classList;
		}

		DebugTool.addClassNode=function(node){
			var type;
			type=node["constructor"].name;
			if (type==DebugTool._tFindClass){
				DebugTool._classList.push(node);
			}
		}

		DebugTool.traceCMD=function(sprite){
			if (!sprite)
				sprite=DebugTool.target;
			if (!sprite){
				console.log("no targetAvalible");
				return null;
			}
			console.log("self CMDs:");
			console.log(sprite.graphics.cmds);
			var renderSprite;
			renderSprite=RenderSprite.renders[sprite._renderType];
			console.log("renderSprite:",renderSprite);
			DebugTool._rSpList.length=0;
			while (renderSprite && renderSprite["_sign"] > 0){
				DebugTool._rSpList.push(DebugTool.cmdToTypeO[renderSprite["_sign"]]);
				renderSprite=renderSprite._next;
			}
			console.log("fun:",DebugTool._rSpList.join(","));
			DebugTool.counter.reset();
			DebugTool.addCMDs(sprite.graphics.cmds);
			DebugTool.counter.traceSelf();
			return DebugTool.counter.data;
		}

		DebugTool.addCMDs=function(cmds){
			WalkTools.walkArr(cmds,DebugTool.addCMD);
		}

		DebugTool.addCMD=function(cmd){
			DebugTool.counter.add(cmd.callee);
		}

		DebugTool.traceCMDR=function(sprite){
			if (!sprite)
				sprite=DebugTool.target;
			if (!sprite){
				console.log("no targetAvalible");
				return 0;
			}
			DebugTool.counter.reset();
			WalkTools.walkTarget(sprite,DebugTool.getCMdCount);
			console.log("cmds include children");
			DebugTool.counter.traceSelf();
			return DebugTool.counter.data;
		}

		DebugTool.getCMdCount=function(target){
			if (!target)
				return 0;
			if (! (target instanceof laya.display.Sprite ))
				return 0;
			if (!target.graphics.cmds)
				return 0;
			DebugTool.addCMDs(target.graphics.cmds);
			var rst=target.graphics.cmds.length;
			return rst;
		}

		DebugTool.addNodeInfo=function(node){
			var type;
			type=node["constructor"].name;
			DebugTool.counter.add(type);
		}

		DebugTool.find=function(filter,ifShowSelected){
			(ifShowSelected===void 0)&& (ifShowSelected=true);
			var rst;
			rst=DebugTool.findTarget(Laya.stage,filter);
			DebugTool.selectedNodes=rst;
			if (DebugTool.selectedNodes){
				DebugTool.target=DebugTool.selectedNodes[0];
			}
			if (ifShowSelected)
				DebugTool.showSelected();
			return rst;
		}

		DebugTool.findByName=function(name){
			DebugTool.nameFilter.name=name;
			return DebugTool.find(DebugTool.nameFilter);
		}

		DebugTool.findNameStartWith=function(startStr){
			DebugTool.nameFilter.name=DebugTool.getStartWithFun(startStr);
			return DebugTool.find(DebugTool.nameFilter);
		}

		DebugTool.findNameHas=function(hasStr,showSelected){
			(showSelected===void 0)&& (showSelected=true);
			DebugTool.nameFilter.name=DebugTool.getHasFun(hasStr);
			return DebugTool.find(DebugTool.nameFilter,showSelected);
		}

		DebugTool.getStartWithFun=function(startStr){
			var rst=function (str){
				if (!str)
					return false;
				if (str.indexOf(startStr)==0)
					return true;
				return false;
			};
			return rst;
		}

		DebugTool.getHasFun=function(hasStr){
			var rst=function (str){
				if (!str)
					return false;
				if (str.indexOf(hasStr)>=0)
					return true;
				return false;
			};
			return rst;
		}

		DebugTool.findTarget=function(target,filter){
			var rst=[];
			if (DebugTool.isFit(target,filter))
				rst.push(target);
			var i=0;
			var len=0;
			var tChild;
			len=target.numChildren;
			for (i=0;i < len;i++){
				tChild=target.getChildAt(i);
				if ((tChild instanceof laya.display.Sprite )){
					rst=rst.concat(DebugTool.findTarget(tChild,filter));
				}
			}
			return rst;
		}

		DebugTool.findClassHas=function(target,str){
			var rst=[];
			if (ClassTool.getClassName(target).indexOf(str)>=0)
				rst.push(target);
			var i=0;
			var len=0;
			var tChild;
			len=target.numChildren;
			for (i=0;i < len;i++){
				tChild=target.getChildAt(i);
				if ((tChild instanceof laya.display.Sprite )){
					rst=rst.concat(DebugTool.findClassHas(tChild,str));
				}
			}
			return rst;
		}

		DebugTool.isFit=function(tar,filter){
			if (!tar)
				return false;
			if (!filter)
				return true;
			if ((typeof filter=='function')){
				return (filter)(tar);
			};
			var key;
			for (key in filter){
				if ((typeof (filter[key])=='function')){
					if (!filter[key](tar[key]))
						return false;
				}
				else{
					if (tar[key] !=filter[key])
						return false;
				}
			}
			return true;
		}

		DebugTool.log=function(__args){
			var args=arguments;
			var arr;
			arr=DTrace.getArgArr(args);
			if (DebugTool._logFun!=null){
				DebugTool._logFun(arr.join(" "));
			}
		}

		DebugTool.enableCacheAnalyse=false;
		DebugTool.enableNodeCreateAnalyse=true;
		DebugTool._traceFun=null
		DebugTool.debugLayer=null
		DebugTool._target=null
		DebugTool.selectedNodes=[];
		DebugTool.autoShowSelected=true;
		DebugTool._showBound=true;
		DebugTool._disBoundRec=null
		DebugTool.autoTraceEnable=false;
		DebugTool.autoTraceBounds=false;
		DebugTool.autoTraceSize=false;
		DebugTool.autoTraceTree=true;
		DebugTool.autoTraceCMD=true;
		DebugTool.autoTraceCMDR=false;
		DebugTool.autoTraceSpriteInfo=true;
		DebugTool._classList=null
		DebugTool._tFindClass=null
		DebugTool._rSpList=[];
		DebugTool._logFun=null
		__static(DebugTool,
		['text',function(){return this.text=new Stat();},'cmdToTypeO',function(){return this.cmdToTypeO={
		};},'counter',function(){return this.counter=new CountTool();},'nameFilter',function(){return this.nameFilter={"name":"name"};}

		]);
		return DebugTool;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.debug.divui.DivScripts
	var DivScripts=(function(){
		function DivScripts(){}
		__class(DivScripts,'laya.debug.divui.DivScripts');
		DivScripts.init=function(){
			var script;
			script=Base64Tool.decodeToByte(DivScripts.data).readUTFBytes();
			Browser.window.eval(script);
		}

		DivScripts.data="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";
		return DivScripts;
	})()


	/**
	*tianpeng
	*@author
	*/
	//class laya.debug.tools.AtlasTools
	var AtlasTools=(function(){
		function AtlasTools(){
			this.mSprite=null;
			this.mIndex=0;
			this.mTextureDic={};
		}

		__class(AtlasTools,'laya.debug.tools.AtlasTools');
		var __proto=AtlasTools.prototype;
		__proto.start=function(){
			if (!Render.isWebGL)return;
			if (this.mSprite==null){
				this.mSprite=new Sprite();
			}
			Laya.stage.addChild(this.mSprite);
			this.showNext();
		}

		__proto.end=function(){
			if (!Render.isWebGL)return;
			if (this.mSprite){
				Laya.stage.removeChild(this.mSprite);
			}
		}

		__proto.showNext=function(){
			if (!Render.isWebGL)return;
			if (this.mSprite==null){
				this.mSprite=new Sprite();
			}
			Laya.stage.addChild(this.mSprite);
			this.mIndex++;
			var resManager;
			resManager=laya.webgl.atlas.AtlasResourceManager.instance;;
			var tCount=resManager.getAtlaserCount();
			if (this.mIndex >=tCount){
				this.mIndex=0;
			};
			var tTexture;
			if (this.mTextureDic[this.mIndex]){
				tTexture=this.mTextureDic[this.mIndex];
				}else {
				var tAtlaser=resManager.getAtlaserByIndex(this.mIndex);
				if (tAtlaser && tAtlaser.texture){
					tTexture=Texture.create(tAtlaser.texture,0,0,2048,2048);
					this.mTextureDic[this.mIndex]=tTexture;
				}
			}
			if (tTexture){
				this.mSprite.graphics.clear();
				this.mSprite.graphics.save();
				this.mSprite.graphics.alpha(0.9);
				this.mSprite.graphics.drawRect(0,0,1024,1024,"#efefefe");
				this.mSprite.graphics.restore();
				this.mSprite.graphics.drawTexture(tTexture,0,0,1024,1024);
				this.mSprite.graphics.fillText((this.mIndex+1).toString()+"/"+tCount.toString(),25,100,"40px Arial","#ff0000","left");
			}
		}

		AtlasTools.getInstance=function(){
			return AtlasTools.mInstance=AtlasTools.mInstance|| new AtlasTools();
		}

		AtlasTools.mInstance=null
		return AtlasTools;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.debug.tools.Base64Atlas
	var Base64Atlas=(function(){
		function Base64Atlas(data,idKey){
			this.data=null;
			this.replaceO=null;
			this.idKey=null;
			this._loadedHandler=null;
			this.data=data;
			if (!idKey)idKey=Math.random()+"key";
			this.idKey=idKey;
			this.init();
		}

		__class(Base64Atlas,'laya.debug.tools.Base64Atlas');
		var __proto=Base64Atlas.prototype;
		//preLoad();
		__proto.init=function(){
			this.replaceO={};
			var key;
			for (key in this.data){
				this.replaceO[key]=this.idKey+"/"+key;
			}
		}

		__proto.getAdptUrl=function(url){
			return this.replaceO[url];
		}

		__proto.preLoad=function(completeHandler){
			this._loadedHandler=completeHandler;
			Laya.loader.load(Base64ImageTool.getPreloads(this.data),new Handler(this,this.preloadEnd));
		}

		__proto.preloadEnd=function(){
			var key;
			for (key in this.data){
				var tx;
				tx=Laya.loader.getRes(this.data[key]);
				Loader.cacheRes(this.replaceO[key],tx);
			}
			if (this._loadedHandler){
				this._loadedHandler.run();
			}
		}

		__proto.replaceRes=function(uiObj){
			ObjectTools$1.replaceValue(uiObj,this.replaceO);
		}

		return Base64Atlas;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.debug.tools.Base64ImageTool
	var Base64ImageTool=(function(){
		function Base64ImageTool(){}
		__class(Base64ImageTool,'laya.debug.tools.Base64ImageTool');
		Base64ImageTool.getCanvasPic=function(img){
			img=img.bitmap;
			var canvas=Browser.createElement("canvas");
			var ctx=canvas.getContext('2d');
			canvas.height=img.height;
			canvas.width=img.width;
			ctx.drawImage(img.source,0,0);
			return canvas;
		}

		Base64ImageTool.getBase64Pic=function(img){
			return Base64ImageTool.getCanvasPic(img).toDataURL("image/png");
		}

		Base64ImageTool.getPreloads=function(base64Data){
			var rst;
			rst=[];
			var key;
			for (key in base64Data){
				rst.push({url:base64Data[key],type:"image" });
			}
			return rst;
		}

		return Base64ImageTool;
	})()


	/**
	*base64编码解码类
	*@author ww
	*/
	//class laya.debug.tools.Base64Tool
	var Base64Tool=(function(){
		function Base64Tool(){}
		__class(Base64Tool,'laya.debug.tools.Base64Tool');
		Base64Tool.init=function(){
			if (Base64Tool.lookup)
				return;
			Base64Tool.lookup=new Uint8Array(256)
			for (var i=0;i < Base64Tool.chars.length;i++){
				Base64Tool.lookup[Base64Tool.chars.charCodeAt(i)]=i;
			}
		}

		Base64Tool.encode=function(arraybuffer){
			var bytes=new Uint8Array(arraybuffer),i=0,len=bytes.length,base64="";
			for (i=0;i < len;i+=3){
				base64+=Base64Tool.chars[bytes[i] >> 2];
				base64+=Base64Tool.chars[((bytes[i] & 3)<< 4)| (bytes[i+1] >> 4)];
				base64+=Base64Tool.chars[((bytes[i+1] & 15)<< 2)| (bytes[i+2] >> 6)];
				base64+=Base64Tool.chars[bytes[i+2] & 63];
			}
			if ((len % 3)===2){
				base64=base64.substring(0,base64.length-1)+"=";
			}
			else if (len % 3===1){
				base64=base64.substring(0,base64.length-2)+"==";
			}
			return base64;
		}

		Base64Tool.encodeStr=function(str){
			var byte;
			byte=new Byte();
			byte.writeUTFString(str);
			return Base64Tool.encodeByte(byte);
		}

		Base64Tool.encodeStr2=function(str){
			var byte;
			byte=new Byte();
			byte.writeUTFBytes(str);
			return Base64Tool.encodeByte(byte);
		}

		Base64Tool.encodeByte=function(byte,start,end){
			(start===void 0)&& (start=0);
			(end===void 0)&& (end=-1);
			if (end < 0){
				end=byte.length;
			}
			return Base64Tool.encode(byte.buffer.slice(start,end));
		}

		Base64Tool.decodeToByte=function(base64){
			return new Byte(Base64Tool.decode(base64));
		}

		Base64Tool.decode=function(base64){
			Base64Tool.init();
			var bufferLength=base64.length *0.75,len=base64.length,i=0,p=0,encoded1=0,encoded2=0,encoded3=0,encoded4=0;
			if (base64[base64.length-1]==="="){
				bufferLength--;
				if (base64[base64.length-2]==="="){
					bufferLength--;
				}
			};
			var arraybuffer=new ArrayBuffer(bufferLength),bytes=new Uint8Array(arraybuffer);
			for (i=0;i < len;i+=4){
				encoded1=Base64Tool.lookup[base64.charCodeAt(i)];
				encoded2=Base64Tool.lookup[base64.charCodeAt(i+1)];
				encoded3=Base64Tool.lookup[base64.charCodeAt(i+2)];
				encoded4=Base64Tool.lookup[base64.charCodeAt(i+3)];
				bytes[p++]=(encoded1 << 2)| (encoded2 >> 4);
				bytes[p++]=((encoded2 & 15)<< 4)| (encoded3 >> 2);
				bytes[p++]=((encoded3 & 3)<< 6)| (encoded4 & 63);
			}
			return arraybuffer;
		}

		Base64Tool.chars="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
		Base64Tool.lookup=null;
		return Base64Tool;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.debug.tools.CacheAnalyser
	var CacheAnalyser=(function(){
		function CacheAnalyser(){}
		__class(CacheAnalyser,'laya.debug.tools.CacheAnalyser');
		var __proto=CacheAnalyser.prototype;
		__proto.renderCanvas=function(sprite,time){
			(time===void 0)&& (time=0);
			if (!CacheAnalyser.showCacheSprite)return;
			if (DebugInfoLayer.I.isDebugItem(sprite))return;
			DebugTool.showDisBoundToSprite(sprite,DebugInfoLayer.I.cacheViewLayer,DebugConsts.CANVAS_REC_COLOR,4);
		}

		__proto.reCacheCanvas=function(sprite,time){
			(time===void 0)&& (time=0);
			if (!CacheAnalyser.showRecacheSprite)return;
			if (DebugInfoLayer.I.isDebugItem(sprite))return;
			var info;
			info=CacheAnalyser.getNodeInfoByNode(sprite);
			info.addCount(time);
			CacheAnalyser.counter.addTime(sprite,time);
			if (!info.parent){
				DebugInfoLayer.I.nodeRecInfoLayer.addChild(info);
			}
		}

		CacheAnalyser.renderLoopBegin=function(){
			DebugInfoLayer.I.cacheViewLayer.graphics.clear();
		}

		CacheAnalyser.getNodeInfoByNode=function(node){
			IDTools.idObj(node);
			var key=0;
			key=IDTools.getObjID(node);
			if (!CacheAnalyser._nodeInfoDic[key]){
				CacheAnalyser._nodeInfoDic[key]=new ReCacheRecInfo();
			}
			(CacheAnalyser._nodeInfoDic [key]).setTarget(node);
			return CacheAnalyser._nodeInfoDic[key];
		}

		CacheAnalyser._nodeInfoDic={};
		CacheAnalyser.showCacheSprite=false;
		CacheAnalyser.showRecacheSprite=true;
		__static(CacheAnalyser,
		['counter',function(){return this.counter=new ObjTimeCountTool();},'I',function(){return this.I=new CacheAnalyser();}
		]);
		return CacheAnalyser;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2017-3-2 下午12:11:59
	*/
	//class laya.debug.tools.CallLaterTool
	var CallLaterTool=(function(){
		function CallLaterTool(){
			this._getHandler=null;
			this._indexHandler=null;
			this._pool=null;
			this._laters=null;
		}

		__class(CallLaterTool,'laya.debug.tools.CallLaterTool');
		var __proto=CallLaterTool.prototype;
		/**
		*延迟执行。
		*@param caller 执行域(this)。
		*@param method 定时器回调函数。
		*@param args 回调参数。
		*/
		__proto.callLater=function(caller,method,args){
			if (this._getHandler(caller,method)==null){
				CallLaterTool.oldCallLater.call(this,caller,method,args);
				if(CallLaterTool._isRecording){
					CallLaterTool._recordedCallLaters.push(this._laters[this._laters.length-1]);
				}
			}
		}

		CallLaterTool.initCallLaterRecorder=function(){
			if(CallLaterTool.oldCallLater)return;
			CallLaterTool.oldCallLater=Laya.timer["callLater"];
			Laya.timer["callLater"]=CallLaterTool["prototype"]["callLater"];
		}

		CallLaterTool.beginRecordCallLater=function(){
			CallLaterTool.initCallLaterRecorder();
			CallLaterTool._isRecording=true;
		}

		CallLaterTool.runRecordedCallLaters=function(){
			CallLaterTool._isRecording=false;
			var timer;
			timer=Laya.timer;
			var laters=timer["_laters"];
			laters=CallLaterTool._recordedCallLaters;
			for (var i=0,n=laters.length-1;i <=n;i++){
				var handler=laters[i];
				if(CallLaterTool._recordedCallLaters.indexOf(handler)<0)continue ;
				handler.method!==null && handler.run(false);
				timer["_recoverHandler"](handler);
				laters.splice(i,1);
			}
			CallLaterTool._recordedCallLaters.length=0;
		}

		CallLaterTool._recordedCallLaters=[];
		CallLaterTool._isRecording=false;
		CallLaterTool.oldCallLater=null
		return CallLaterTool;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.debug.tools.CanvasTools
	var CanvasTools=(function(){
		function CanvasTools(){}
		__class(CanvasTools,'laya.debug.tools.CanvasTools');
		CanvasTools.createCanvas=function(width,height){
			var rst=new HTMLCanvas("2D");
			rst.getContext('2d');
			rst.size(width,height);
			return rst;
		}

		CanvasTools.renderSpriteToCanvas=function(sprite,canvas,offsetX,offsetY){
			RenderSprite.renders[sprite._renderType]._fun(sprite,canvas.context,offsetX,offsetY);
		}

		CanvasTools.getImageDataFromCanvas=function(canvas,x,y,width,height){
			(x===void 0)&& (x=0);
			(y===void 0)&& (y=0);
			(width===void 0)&& (width=0);
			(height===void 0)&& (height=0);
			if (width <=0)
				width=canvas.width;
			if (height <=0)
				height=canvas.height;
			var imgdata=canvas.context.getImageData(x,y,width,height);
			return imgdata;
		}

		CanvasTools.getImageDataFromCanvasByRec=function(canvas,rec){
			var imgdata=canvas.context.getImageData(rec.x,rec.y,rec.width,rec.height);
			return imgdata;
		}

		CanvasTools.getDifferCount=function(imageData1,imageData2){
			var data1=imageData1.data;
			var data2=imageData2.data;
			var differCount=0;
			differCount=0;
			CanvasTools.walkImageData(imageData1,myWalkFun);
			return differCount;
			function myWalkFun (i,j,tarPos,data){
				if (!CanvasTools.isPoinSame(tarPos,data1,data2))differCount++;
			}
		}

		CanvasTools.getDifferRate=function(imageData1,imageData2){
			return CanvasTools.getDifferCount(imageData1,imageData2)/(imageData1.width *imageData1.height);
		}

		CanvasTools.getCanvasDisRec=function(canvas){
			var rst;
			rst=new Rectangle;
			var imgdata;
			imgdata=CanvasTools.getImageDataFromCanvas(canvas,0,0);
			var maxX=0;
			var minX=0;
			var maxY=0;
			var minY=0;
			maxX=maxY=0;
			minX=imgdata.width;
			minY=imgdata.height;
			var i=0,iLen=0;
			var j=0,jLen=0;
			iLen=imgdata.width;
			jLen=imgdata.height;
			var data;
			data=imgdata.data;
			var tarPos=0;
			for (j=0;j < jLen;j++){
				for (i=0;i < iLen;i++){
					if (!CanvasTools.isEmptyPoint(data,tarPos)){
						if (minX > i)
							minX=i;
						if (maxX < i)
							maxX=i;
						if (minY > j)
							minY=j;
						if (maxY < j)
							maxY=j;
					}
					tarPos+=4;
				}
			}
			rst.setTo(minX,minY,maxX-minX+1,maxY-minY+1);
			return rst;
		}

		CanvasTools.fillCanvasRec=function(canvas,rec,color){
			var ctx=canvas.context;
			ctx.fillStyle=color;
			ctx.fillRect(rec.x,rec.y,rec.width,rec.height);
		}

		CanvasTools.isEmptyPoint=function(data,pos){
			if (data[pos]==0 && data[pos+1]==0 && data[pos+2]==0 && data[pos+3]==0){
				return true;
			}
			else{
				return false;
			}
		}

		CanvasTools.isPoinSame=function(pos,data1,data2){
			if (data1[pos]==data2[pos] && data1[pos+1]==data2[pos+1] && data1[pos+2]==data2[pos+2] && data1[pos+3]==data2[pos+3]){
				return true;
			}
			else{
				return false;
			}
		}

		CanvasTools.walkImageData=function(imgdata,walkFun){
			var i=0,iLen=0;
			var j=0,jLen=0;
			iLen=imgdata.width;
			jLen=imgdata.height;
			var tarPos=0;
			var data=imgdata.data;
			for (i=0;i < iLen;i++){
				for (j=0;j < jLen;j++){
					walkFun(i,j,tarPos,data);
					tarPos+=4;
				}
			}
		}

		CanvasTools.getSpriteByCanvas=function(canvas){
			var rst;
			rst=new Sprite();
			rst.graphics.drawTexture(new Texture(canvas),0,0,canvas.width,canvas.height);
			return rst;
		}

		CanvasTools.renderSpritesToCanvas=function(canvas,sprites,offx,offy,startIndex){
			(offx===void 0)&& (offx=0);
			(offy===void 0)&& (offy=0);
			(startIndex===void 0)&& (startIndex=0);
			var i=0,len=0;
			len=sprites.length;
			for (i=startIndex;i < len;i++){
				CanvasTools.renderSpriteToCanvas(sprites[i],canvas,offx,offy);
			}
		}

		CanvasTools.clearCanvas=function(canvas){
			var preWidth=NaN;
			var preHeight=NaN;
			preWidth=canvas.width;
			preHeight=canvas.height;
			canvas.size(preWidth+1,preHeight);
			canvas.size(preWidth,preHeight);
		}

		CanvasTools.getImagePixels=function(x,y,width,data,colorLen){
			(colorLen===void 0)&& (colorLen=4);
			var pos=0;
			pos=(x *width+y)*colorLen;
			var i=0,len=0;
			var rst;
			rst=[];
			len=colorLen;
			for (i=0;i < len;i++){
				rst.push(data[pos+i]);
			}
			return rst;
		}

		return CanvasTools;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-10-23 下午2:24:04
	*/
	//class laya.debug.tools.ClassTool
	var ClassTool=(function(){
		function ClassTool(){}
		__class(ClassTool,'laya.debug.tools.ClassTool');
		ClassTool.defineProperty=function(obj,name,des){
			Object.defineProperty(obj,name,des);;
		}

		ClassTool.getOwnPropertyDescriptor=function(obj,name){
			var rst;
			rst=Object.getOwnPropertyDescriptor(obj,name);;
			return rst;
		}

		ClassTool.getOwnPropertyDescriptors=function(obj){
			var rst;
			rst=Object.getOwnPropertyDescriptors(obj);;
			return rst;
		}

		ClassTool.getOwnPropertyNames=function(obj){
			var rst;
			rst=Object.getOwnPropertyNames(obj);;
			return rst;
		}

		ClassTool.getObjectGetSetKeys=function(obj,rst){
			if (!rst)rst=[];
			var keys;
			keys=laya.debug.tools.ClassTool.getOwnPropertyNames(obj);
			var key;
			for (key in keys){
				key=keys[key];
				if (key.indexOf("_$get_")>=0){
					key=key.replace("_$get_","");
					rst.push(key);
				}
			}
			if (obj["__proto__"]){
				ClassTool.getObjectGetSetKeys(obj["__proto__"],rst);
			}
			return rst;
		}

		ClassTool.getObjectDisplayAbleKeys=function(obj,rst){
			if (!rst)rst=[];
			var key;
			var tValue;
			var tType;
			for (key in obj){
				tValue=obj[key];
				tType=typeof(tValue);
				if (key.charAt(0)=="_")continue ;
				rst.push(key);
			}
			ClassTool.getObjectGetSetKeys(obj,rst);
			rst=ObjectTools$1.getNoSameArr(rst);
			return rst;
		}

		ClassTool.getClassName=function(tar){
			if ((typeof tar=='function'))return tar.name;
			return tar["constructor"].name;
		}

		ClassTool.getNodeClassAndName=function(tar){
			if (!tar)return "null";
			var rst;
			if (tar.name){
				rst=ClassTool.getClassName(tar)+"("+tar.name+")";
				}else{
				rst=ClassTool.getClassName(tar);
			}
			return rst;
		}

		ClassTool.getClassNameByClz=function(clz){
			return clz["name"];
		}

		ClassTool.getClassByName=function(className){
			var rst;
			rst=eval(className);
			return rst;
		}

		ClassTool.createObjByName=function(className){
			var clz;
			clz=ClassTool.getClassByName(className);
			return new clz();
		}

		__static(ClassTool,
		['displayTypes',function(){return this.displayTypes={"boolean":true,"number":true,"string":true };}
		]);
		return ClassTool;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.debug.tools.ClickSelectTool
	var ClickSelectTool=(function(){
		function ClickSelectTool(){
			this.completeHandler=null;
			this.tSelectTar=null;
			this._selectTip=new Sprite();
			this._selectTip.setBounds(new Rectangle(0,0,0,0));
			Notice$1.listen("ItemClicked",this,this.itemClicked);
		}

		__class(ClickSelectTool,'laya.debug.tools.ClickSelectTool');
		var __proto=ClickSelectTool.prototype;
		__proto.beginClickSelect=function(complete){
			this.completeHandler=complete;
			ClickSelectTool.isClickSelectState=true;
			this.clickSelectChange();
		}

		__proto.clickSelectChange=function(){
			if (!Browser.onPC)return;
			this.tSelectTar=null;
			this.clearSelectTip();
			if (ClickSelectTool.isClickSelectState){
				Laya.timer.loop(200,this,this.updateSelectTar,null,true);
				}else{
				Laya.timer.clear(this,this.updateSelectTar);
			}
		}

		__proto.clearSelectTip=function(){
			this._selectTip.removeSelf();
		}

		__proto.updateSelectTar=function(){
			this.clearSelectTip();
			this.tSelectTar=DisplayHook.instance.getDisUnderMouse();
			if (!this.tSelectTar){
				return;
			}
			if (DebugInfoLayer.I.isDebugItem(this.tSelectTar))return;
			var g;
			g=this._selectTip.graphics;
			g.clear();
			var rec;
			rec=NodeUtils.getGRec(this.tSelectTar);
			DebugInfoLayer.I.popLayer.addChild(this._selectTip);
			g.drawRect(0,0,rec.width,rec.height,null,DebugConsts.CLICK_SELECT_COLOR,2);
			this._selectTip.pos(rec.x,rec.y);
		}

		__proto.itemClicked=function(tar){
			if (!ClickSelectTool.isClickSelectState)return;
			if (ClickSelectTool.ignoreDebugTool){
				if (DebugInfoLayer.I.isDebugItem(tar))return;
			}
			if ((tar instanceof laya.debug.uicomps.ContextMenuItem )|| (tar.parent instanceof laya.debug.uicomps.ContextMenuItem )){
				return;
			}
			DebugTool.showDisBound(tar);
			if (this.completeHandler){
				this.completeHandler.runWith(tar);
			}
			ClickSelectTool.isClickSelectState=false;
			this.clickSelectChange();
		}

		__getset(1,ClickSelectTool,'I',function(){
			if (!ClickSelectTool._I)ClickSelectTool._I=new ClickSelectTool();
			return ClickSelectTool._I;
		});

		ClickSelectTool._I=null
		ClickSelectTool.isClickSelectState=false;
		ClickSelectTool.ignoreDebugTool=false;
		return ClickSelectTool;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.debug.tools.ColorTool
	var ColorTool=(function(){
		function ColorTool(){
			this.red=NaN;
			this.green=NaN;
			this.blue=NaN;
		}

		__class(ColorTool,'laya.debug.tools.ColorTool');
		ColorTool.toHexColor=function(color){
			return Utils$1.toHexColor(color);
		}

		ColorTool.getRGBByRGBStr=function(str){
			str.charAt(0)=='#' && (str=str.substr(1));
			var color=parseInt(str,16);
			var flag=(str.length==8);
			var _color;
			_color=[((0x00FF0000 & color)>> 16),((0x0000FF00 & color)>> 8),(0x000000FF & color)];
			return _color;
		}

		ColorTool.getColorBit=function(value){
			var rst;
			rst=Math.floor(value).toString(16);
			rst=rst.length > 1 ? rst :"0"+rst;
			return rst;
		}

		ColorTool.getRGBStr=function(rgb){
			return "#"+ColorTool.getColorBit(rgb[0])+ColorTool.getColorBit(rgb[1])+ColorTool.getColorBit(rgb[2]);
		}

		ColorTool.traseHSB=function(hsb){
			console.log("hsb:",hsb[0],hsb[1],hsb[2]);
		}

		ColorTool.rgb2hsb=function(rgbR,rgbG,rgbB){
			var rgb=[rgbR,rgbG,rgbB];
			rgb.sort(MathTools.sortNumSmallFirst);
			var max=rgb[2];
			var min=rgb[0];
			var hsbB=max / 255.0;
			var hsbS=max==0 ? 0 :(max-min)/ max;
			var hsbH=0;
			if(max==min){
				hsbH=1;
			}
			else
			if (rgbR==0 && rgbG==0&&rgbB==0){
			}else
			if (max==rgbR && rgbG >=rgbB){
				hsbH=(rgbG-rgbB)*60 / (max-min)+0;
			}
			else if (max==rgbR && rgbG < rgbB){
				hsbH=(rgbG-rgbB)*60 / (max-min)+360;
			}
			else if (max==rgbG){
				hsbH=(rgbB-rgbR)*60 / (max-min)+120;
			}
			else if (max==rgbB){
				hsbH=(rgbR-rgbG)*60 / (max-min)+240;
			}
			return [hsbH,hsbS,hsbB];
		}

		ColorTool.hsb2rgb=function(h,s,v){
			var r=0,g=0,b=0;
			var i=Math.floor((h / 60)% 6);
			var f=(h / 60)-i;
			var p=v *(1-s);
			var q=v *(1-f *s);
			var t=v *(1-(1-f)*s);
			switch (i){
				case 0:
					r=v;
					g=t;
					b=p;
					break ;
				case 1:
					r=q;
					g=v;
					b=p;
					break ;
				case 2:
					r=p;
					g=v;
					b=t;
					break ;
				case 3:
					r=p;
					g=q;
					b=v;
					break ;
				case 4:
					r=t;
					g=p;
					b=v;
					break ;
				case 5:
					r=v;
					g=p;
					b=q;
					break ;
				default :
					break ;
				}
			return [Math.floor(r *255.0),Math.floor(g *255.0),Math.floor(b *255.0)];
		}

		return ColorTool;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-9-24 下午6:37:56
	*/
	//class laya.debug.tools.CountTool
	var CountTool=(function(){
		function CountTool(){
			this.data={};
			this.preO={};
			this.changeO={};
			this.count=0;
		}

		__class(CountTool,'laya.debug.tools.CountTool');
		var __proto=CountTool.prototype;
		__proto.reset=function(){
			this.data={};
			this.count=0;
		}

		__proto.add=function(name,num){
			(num===void 0)&& (num=1);
			this.count++;
			if(!this.data.hasOwnProperty(name)){
				this.data[name]=0;
			}
			this.data[name]=this.data[name]+num;
		}

		__proto.getKeyCount=function(key){
			if(!this.data.hasOwnProperty(key)){
				this.data[key]=0;
			}
			return this.data[key];
		}

		__proto.getKeyChange=function(key){
			if (!this.changeO[key])return 0;
			return this.changeO[key];
		}

		__proto.record=function(){
			var key;
			for (key in this.changeO){
				this.changeO[key]=0;
			}
			for (key in this.data){
				if (!this.preO[key])this.preO[key]=0;
				this.changeO[key]=this.data[key]-this.preO[key];
				this.preO[key]=this.data[key]
			}
		}

		__proto.getCount=function(dataO){
			var rst=0;
			var key;
			for (key in dataO){
				rst+=dataO[key];
			}
			return rst;
		}

		__proto.traceSelf=function(dataO){
			if (!dataO)dataO=this.data;
			var tCount=0;
			tCount=this.getCount(dataO);
			console.log("total:"+tCount);
			return "total:"+tCount+"\n"+TraceTool.traceObj(dataO);
		}

		__proto.traceSelfR=function(dataO){
			if (!dataO)dataO=this.data;
			var tCount=0;
			tCount=this.getCount(dataO);
			console.log("total:"+tCount);
			return "total:"+tCount+"\n"+TraceTool.traceObjR(dataO);
		}

		return CountTool;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.debug.tools.DebugConsts
	var DebugConsts=(function(){
		function DebugConsts(){}
		__class(DebugConsts,'laya.debug.tools.DebugConsts');
		DebugConsts.CLICK_SELECT_COLOR="#ff0000";
		DebugConsts.CANVAS_REC_COLOR="#FF00FF";
		DebugConsts.RECACHE_REC_COLOR="#00ff00";
		DebugConsts.SPRITE_REC_COLOR="#ff0000";
		DebugConsts.SPRITE_REC_LINEWIDTH=2;
		return DebugConsts;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-10-31 下午3:35:16
	*/
	//class laya.debug.tools.DebugExport
	var DebugExport=(function(){
		function DebugExport(){}
		__class(DebugExport,'laya.debug.tools.DebugExport');
		DebugExport.export=function(){
			var _window;
			_window=window;;
			var key;
			for(key in DebugExport._exportsDic){
				_window[key]=DebugExport._exportsDic[key];
			}
		}

		__static(DebugExport,
		['_exportsDic',function(){return this._exportsDic={
				"DebugTool":DebugTool,
				"Watcher":Watcher
		};}

		]);
		return DebugExport;
	})()


	/**
	*本类用于显示对象值变化过程
	*@author ww
	*@version 1.0
	*
	*@created 2015-10-23 上午10:41:50
	*/
	//class laya.debug.tools.DifferTool
	var DifferTool=(function(){
		function DifferTool(sign,autoTrace){
			this.autoTrace=true;
			this.sign="";
			this.obj=null;
			(sign===void 0)&& (sign="");
			(autoTrace===void 0)&& (autoTrace=true);
			this.sign=sign;
			this.autoTrace=autoTrace;
		}

		__class(DifferTool,'laya.debug.tools.DifferTool');
		var __proto=DifferTool.prototype;
		__proto.update=function(data,msg){
			if(msg){
				console.log(msg);
			};
			var tObj=ObjectTools$1.copyObj(data);
			if(!this.obj)this.obj={};
			var rst;
			rst=ObjectTools$1.differ(this.obj,tObj);
			this.obj=tObj;
			if(this.autoTrace){
				console.log(this.sign+" differ:");
				ObjectTools$1.traceDifferObj(rst);
			}
			return rst;
		}

		DifferTool.differ=function(sign,data,msg){
			if(!DifferTool._differO[sign])DifferTool._differO[sign]=new DifferTool(sign,true);
			var tDiffer;
			tDiffer=DifferTool._differO[sign];
			return tDiffer.update(data,msg);
		}

		DifferTool._differO={};
		return DifferTool;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-1-14 下午4:32:47
	*/
	//class laya.debug.tools.DisController
	var DisController=(function(){
		function DisController(){
			this.arrowAxis=null;
			this._target=null;
			this.recInfo=null;
			DisController.init();
			this.arrowAxis=new Axis();
			this.arrowAxis.mouseEnabled=true;
		}

		__class(DisController,'laya.debug.tools.DisController');
		var __proto=DisController.prototype;
		__proto.switchType=function(){
			this.arrowAxis.switchType();
		}

		__proto.updateMe=function(){
			if(!this._target)return;
			this.recInfo=RecInfo.getGlobalRecInfo(this._target,0,0,1,0,0,1);
			console.log("rotation:",this.recInfo.rotation);
			console.log("pos:",this.recInfo.x,this.recInfo.y);
			console.log("scale:",this.recInfo.width,this.recInfo.height);
			this.arrowAxis.x=this.recInfo.x;
			this.arrowAxis.y=this.recInfo.y;
			this.arrowAxis.rotation=this.recInfo.rotation;
			this.arrowAxis.yAxis.rotation=this.recInfo.rotationV-this.recInfo.rotation;
		}

		__getset(0,__proto,'target',function(){
			return this._target;
			},function(target){
			this._target=target;
			if(target){
				DisController._container.addChild(this.arrowAxis);
				Laya.timer.loop(100,this,this.updateMe);
				}else{
				this.arrowAxis.removeSelf();
				Laya.timer.clear(this,this.updateMe);
			}
			this.arrowAxis.target=target;
			this.updateMe();
		});

		__getset(0,__proto,'type',function(){
			return this.arrowAxis.type;
			},function(lenType){
			this.arrowAxis.type=lenType;
		});

		DisController.init=function(){
			if (DisController._container){
				DisControlTool.setTop(DisController._container);
				return;
			};
			DisController._container=new Sprite();
			DisController._container.mouseEnabled=true;
			Laya.stage.addChild(DisController._container);
		}

		DisController._container=null
		__static(DisController,
		['I',function(){return this.I=new DisController();}
		]);
		return DisController;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-9-25 下午7:19:44
	*/
	//class laya.debug.tools.DisControlTool
	var DisControlTool=(function(){
		function DisControlTool(){}
		__class(DisControlTool,'laya.debug.tools.DisControlTool');
		DisControlTool.getObjectsUnderPoint=function(sprite,x,y,rst,filterFun){
			rst=rst?rst:[];
			if(filterFun!=null&&!filterFun(sprite))return rst;
			if (sprite.getBounds().contains(x,y)){
				rst.push(sprite);
				var tS;
				var tempP=new Point();
				tempP.setTo(x,y);
				tempP=sprite.fromParentPoint(tempP);
				x=tempP.x;
				y=tempP.y;
				for (var i=sprite._childs.length-1;i >-1;i--){
					var child=sprite._childs[i];
					if((child instanceof laya.display.Sprite ))
						DisControlTool.getObjectsUnderPoint(child,x,y,rst,filterFun);
				}
			}
			return rst;
		}

		DisControlTool.getObjectsUnderGlobalPoint=function(sprite,filterFun){
			var point=new Point();
			point.setTo(Laya.stage.mouseX,Laya.stage.mouseY);
			if(sprite.parent)
				point=(sprite.parent).globalToLocal(point);
			return DisControlTool.getObjectsUnderPoint(sprite,point.x,point.y,null,filterFun);
		}

		DisControlTool.findFirstObjectsUnderGlobalPoint=function(){
			var disList;
			disList=DisControlTool.getObjectsUnderGlobalPoint(Laya.stage);
			if (!disList)return null;
			var i=0,len=0;
			var tDis;
			len=disList.length;
			for (i=len-1;i>=0;i--){
				tDis=disList[i];
				if (tDis && tDis.numChildren < 1){
					return tDis;
				}
			}
			return tDis;
		}

		DisControlTool.visibleAndEnableObjFun=function(tar){
			return tar.visible&&tar.mouseEnabled;
		}

		DisControlTool.visibleObjFun=function(tar){
			return tar.visible;
		}

		DisControlTool.getMousePoint=function(sprite){
			var point=new Point();
			point.setTo(Laya.stage.mouseX,Laya.stage.mouseY);
			point=sprite.globalToLocal(point);
			return point;
		}

		DisControlTool.isChildE=function(parent,child){
			if (!parent)return false;
			while (child){
				if (child.parent==parent)return true;
				child=child.parent;
			}
			return false;
		}

		DisControlTool.isInTree=function(pNode,child){
			return pNode==child || DisControlTool.isChildE(pNode,child);
		}

		DisControlTool.setTop=function(tar){
			if(tar&&tar.parent){
				var tParent;
				tParent=tar.parent;
				tParent.setChildIndex(tar,tParent.numChildren-1);
			}
		}

		DisControlTool.clearItemRelativeInfo=function(item){
			var Nan="NaN";
			item.getLayout().left=Nan;
			item.getLayout().right=Nan;
			item.getLayout().top=Nan;
			item.getLayout().bottom=Nan;
		}

		DisControlTool.swap=function(tarA,tarB){
			if (tarA==tarB)return;
			var iA=0;
			iA=tarA.parent.getChildIndex(tarA);
			var iB=0;
			iB=tarB.parent.getChildIndex(tarB);
			var bP;
			bP=tarB.parent;
			tarA.parent.addChildAt(tarB,iA);
			bP.addChildAt(tarA,iB);
		}

		DisControlTool.insertToTarParent=function(tarA,tars,after){
			(after===void 0)&& (after=false);
			var tIndex=0;
			var parent;
			if(!tarA)return;
			parent=tarA.parent;
			if(!parent)return;
			tIndex=parent.getChildIndex(tarA);
			if(after)tIndex++;
			DisControlTool.insertToParent(parent,tars,tIndex);
		}

		DisControlTool.insertToParent=function(parent,tars,index){
			(index===void 0)&& (index=-1);
			if(!parent)return;
			if(index<0)index=parent.numChildren;
			var i=0,len=0;
			len=tars.length;
			for(i=0;i<len;i++){
				DisControlTool.transParent(tars[i],parent);
				parent.addChildAt(tars[i],index);
			}
		}

		DisControlTool.transParent=function(tar,newParent){
			if(!tar||!newParent)return;
			if(!tar.parent)return;
			var preParent;
			preParent=tar.parent;
			var pos;
			pos=new Point(tar.x,tar.y);
			pos=preParent.localToGlobal(pos);
			pos=newParent.globalToLocal(pos);
			tar.pos(pos.x,pos.y);
		}

		DisControlTool.transPoint=function(nowParent,tarParent,point){
			point=nowParent.localToGlobal(point);
			point=tarParent.globalToLocal(point);
			return point;
		}

		DisControlTool.removeItems=function(itemList){
			var i=0,len=0;
			len=itemList.length;
			for (i=0;i < len;i++){
				(itemList [i]).removeSelf();
			}
		}

		DisControlTool.addItems=function(itemList,parent){
			var i=0,len=0;
			len=itemList.length;
			for (i=0;i < len;i++){
				parent.addChild(itemList[i]);
			}
		}

		DisControlTool.getAllChild=function(tar){
			if(!tar)return [];
			var i=0;
			var len=0;
			var rst=[];
			len=tar.numChildren;
			for(i=0;i<len;i++){
				rst.push(tar.getChildAt(i));
			}
			return rst;
		}

		DisControlTool.upDis=function(child){
			if(child&&child.parent){
				var tParent;
				tParent=child.parent;
				var newIndex=0;
				newIndex=tParent.getChildIndex(child)+1;
				if(newIndex>=tParent.numChildren){
					newIndex=tParent.numChildren-1;
				}
				console.log("setChildIndex:"+newIndex);
				tParent.setChildIndex(child,newIndex);
			}
		}

		DisControlTool.downDis=function(child){
			if(child&&child.parent){
				var tParent;
				tParent=child.parent;
				var newIndex=0;
				newIndex=tParent.getChildIndex(child)-1;
				if(newIndex<0)newIndex=0;
				console.log("setChildIndex:"+newIndex);
				tParent.setChildIndex(child,newIndex);
			}
		}

		DisControlTool.setResizeAbleEx=function(node){
			var clickItem;
			clickItem=node.getChildByName("resizeBtn");
			if (clickItem){
				SimpleResizer.setResizeAble(clickItem,node);
			}
		}

		DisControlTool.setResizeAble=function(node){
			node.on("click",null,DisControlTool.resizeHandler,[node]);
		}

		DisControlTool.resizeHandler=function(tar){
			DisResizer$1.setUp(tar);
		}

		DisControlTool.setDragingItem=function(dragBar,tar){
			dragBar.on("mousedown",null,DisControlTool.dragingHandler,[tar]);
			tar.on("dragend",null,DisControlTool.dragingEnd,[tar]);
		}

		DisControlTool.dragingHandler=function(tar){
			if (tar){
				tar.startDrag();
			}
		}

		DisControlTool.dragingEnd=function(tar){
			DisControlTool.intFyDisPos(tar);
			console.log(tar.x,tar.y);
		}

		DisControlTool.showToStage=function(dis,offX,offY){
			(offX===void 0)&& (offX=0);
			(offY===void 0)&& (offY=0);
			var rec=dis.getBounds();
			dis.x=Laya.stage.mouseX+offX;
			dis.y=Laya.stage.mouseY+offY;
			if (dis.x+rec.width > Laya.stage.width){
				dis.x-=rec.width+offX;
			}
			if (dis.y+rec.height > Laya.stage.height){
				dis.y-=rec.height+offY;
			}
			DisControlTool.intFyDisPos(dis);
		}

		DisControlTool.intFyDisPos=function(dis){
			if (!dis)return;
			dis.x=Math.round(dis.x);
			dis.y=Math.round(dis.y);
		}

		DisControlTool.showOnly=function(disList,showItem){
			var i=0,len=0;
			len=disList.length;
			for (i=0;i < len;i++){
				disList[i].visible=disList[i]==showItem;
			}
		}

		DisControlTool.showOnlyByIndex=function(disList,index){
			DisControlTool.showOnly(disList,disList[index]);
		}

		DisControlTool.addOnly=function(disList,showItem,parent){
			var i=0,len=0;
			len=disList.length;
			for (i=0;i < len;i++){
				if (disList[i] !=showItem){
					disList[i].removeSelf();
					}else{
					parent.addChild(disList[i]);
				}
			}
		}

		DisControlTool.addOnlyByIndex=function(disList,index,parent){
			DisControlTool.addOnly(disList,disList[index],parent);
		}

		__static(DisControlTool,
		['tempP',function(){return this.tempP=new Point();}
		]);
		return DisControlTool;
	})()


	/**
	*调试拾取显示对象类
	*@author ww
	*/
	//class laya.debug.tools.DisplayHook
	var DisplayHook=(function(){
		function DisplayHook(){
			this.mouseX=NaN;
			this.mouseY=NaN;
			this._stage=null;
			this._target=null;
			this.isGetting=false;
			this._matrix=new Matrix();
			this._point=new Point();
			this._rect=new Rectangle();
			this._event=Event.EMPTY;
			this._stage=Laya.stage;
			this.init(Render.context.canvas);
		}

		__class(DisplayHook,'laya.debug.tools.DisplayHook');
		var __proto=DisplayHook.prototype;
		__proto.init=function(canvas){
			var _$this=this;
			if (Browser.window.navigator.msPointerEnabled){
				canvas.style['-ms-content-zooming']='none';
				canvas.style['-ms-touch-action']='none';
			};
			var _this=this;
			Browser.document.addEventListener('mousedown',function(e){
				_$this._event._stoped=false;
				DisplayHook.isFirst=true;
				_this.check(_this._stage,e.offsetX,e.offsetY,_this.onMouseDown,true,false);
			},true);
			Browser.document.addEventListener('touchstart',function(e){
				_$this._event._stoped=false;
				DisplayHook.isFirst=true;
				var touches=e.changedTouches;
				for (var i=0,n=touches.length;i < n;i++){
					var touch=touches[i];
					initEvent(touch,e);
					_this.check(_this._stage,_this.mouseX,_this.mouseY,_this.onMouseDown,true,false);
				}
			},true);
			function initEvent (e,event){
				_this._event._stoped=false;
				_this._event.nativeEvent=event || e;
				_this._target=null;
				if (e.offsetX){
					_this.mouseX=e.offsetX;
					_this.mouseY=e.offsetY;
					}else {
					_this.mouseX=e.clientX-Laya.stage.offset.x;
					_this.mouseY=e.clientY-Laya.stage.offset.y;
				}
			}
		}

		__proto.onMouseMove=function(ele,hit){
			this.sendEvent(ele,"mousemove");
			return;
			if (hit && ele !=this._stage && ele!==this._target){
				if (this._target){
					if (this._target.$_MOUSEOVER){
						this._target.$_MOUSEOVER=false;
						this._target.event("mouseout");
					}
				}
				this._target=ele;
				if (!ele.$_MOUSEOVER){
					ele.$_MOUSEOVER=true;
					this.sendEvent(ele,"mouseover");
				}
				}else if (!hit && this._target && ele===this._target){
				this._target=null;
				if (ele.$_MOUSEOVER){
					ele.$_MOUSEOVER=false;
					this.sendEvent(ele,"mouseout");
				}
			}
		}

		__proto.onMouseUp=function(ele,hit){
			hit && this.sendEvent(ele,"mouseup");
		}

		__proto.onMouseDown=function(ele,hit){
			if (hit){
				ele.$_MOUSEDOWN=true;
				this.sendEvent(ele,"mousedown");
			}
		}

		__proto.sendEvent=function(ele,type){
			if (!this._event._stoped){
				ele.event(type,this._event.setTo(type,ele,ele));
				if (type==="mouseup" && ele.$_MOUSEDOWN){
					ele.$_MOUSEDOWN=false;
					ele.event("click",this._event.setTo("click",ele,ele));
				}
			}
		}

		__proto.selectDisUnderMouse=function(){
			DisplayHook.isFirst=true;
			this.check(Laya.stage,Laya.stage.mouseX,Laya.stage.mouseY,null,true,false);
			SelectInfosView.I.setSelectTarget(DebugTool.target);
		}

		__proto.getDisUnderMouse=function(){
			this.isGetting=true;
			DisplayHook.isFirst=true;
			DebugTool.target=null;
			this.check(Laya.stage,Laya.stage.mouseX,Laya.stage.mouseY,null,true,false);
			this.isGetting=false;
			return DebugTool.target;
		}

		__proto.check=function(sp,mouseX,mouseY,callBack,hitTest,mouseEnable){
			if (sp==DebugTool.debugLayer)return false;
			if (sp==DebugInfoLayer.I)return false;
			if (this.isGetting && sp==DebugInfoLayer.I)return false;
			if (!sp.visible || sp.getSelfBounds().width<=0)return false;
			var isHit=false;
			mouseEnable=true
			if (mouseEnable){
				var graphicHit=false;
				if (hitTest){
					this._rect=sp.getBounds();
					isHit=this._rect.contains(mouseX,mouseY);
					this._point.setTo(mouseX,mouseY);
					sp.fromParentPoint(this._point);
					mouseX=this._point.x;
					mouseY=this._point.y;
				}
				if (isHit){
					var flag=false;
					for (var i=sp._childs.length-1;i >-1;i--){
						var child=sp._childs[i];
						(flag=this.check(child,mouseX,mouseY,callBack,hitTest,true));
						if (flag)break ;
					}
					graphicHit=sp.getGraphicBounds().contains(mouseX,mouseY);
					isHit=flag||graphicHit;
					if(isHit&&!flag&&DisplayHook.isFirst){
						DisplayHook.isFirst=false;
						if(! ((sp instanceof laya.debug.tools.debugUI.DButton ))){
							DebugTool.target=sp;
							if (!this.isGetting){
								DebugTool.autoWork();
								Notice$1.notify("ItemClicked",sp);
							}
						}
					}
				}
			}
			return isHit;
		}

		DisplayHook.initMe=function(){
			if(!DisplayHook.instance){
				DisplayHook.instance=new DisplayHook();
			}
		}

		DisplayHook.ITEM_CLICKED="ItemClicked";
		DisplayHook.instance=null
		DisplayHook.isFirst=false;
		return DisplayHook;
	})()


	/**
	*简单的显示对象对象池
	*从父容器上移除时即被视为可被重用
	*@author ww
	*@version 1.0
	*
	*@created 2015-11-13 下午8:05:13
	*/
	//class laya.debug.tools.DisPool
	var DisPool=(function(){
		function DisPool(){}
		__class(DisPool,'laya.debug.tools.DisPool');
		DisPool.getDis=function(clz){
			var clzName;
			clzName=ClassTool.getClassNameByClz(clz);
			if(!DisPool._objDic[clzName]){
				DisPool._objDic[clzName]=[];
			};
			var disList;
			disList=DisPool._objDic[clzName];
			var i=0,len=0;
			len=disList.length;
			for(i=0;i<len;i++){
				if(!disList[i].parent){
					return disList[i];
				}
			}
			disList.push(new clz());
			return disList[disList.length-1];
		}

		DisPool._objDic={};
		return DisPool;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-9-28 上午10:39:47
	*/
	//class laya.debug.tools.DTrace
	var DTrace=(function(){
		function DTrace(){}
		__class(DTrace,'laya.debug.tools.DTrace');
		DTrace.getArgArr=function(arg){
			var rst;
			rst=[];
			var i=0,len=arg.length;
			for(i=0;i<len;i++){
				rst.push(arg[i]);
			}
			return rst;
		}

		DTrace.dTrace=function(__arg){
			var arg=arguments;
			arg=DTrace.getArgArr(arg);
			arg.push(TraceTool.getCallLoc(2));
			console.log.apply(console,arg);
			var str;
			str=arg.join(" ");
		}

		DTrace.timeStart=function(sign){
			console.time(sign);;
		}

		DTrace.timeEnd=function(sign){
			console.timeEnd(sign);;
		}

		DTrace.traceTable=function(data){
			console.table(data);;
		}

		return DTrace;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.debug.tools.enginehook.ClassCreateHook
	var ClassCreateHook=(function(){
		function ClassCreateHook(){
			this.createInfo={};
		}

		__class(ClassCreateHook,'laya.debug.tools.enginehook.ClassCreateHook');
		var __proto=ClassCreateHook.prototype;
		__proto.hookClass=function(clz){
			var _$this=this;
			if (ClassCreateHook.isInited)return;
			ClassCreateHook.isInited=true;
			var createFun=function (sp){
				_$this.classCreated(sp,clz);
			}
			FunHook.hook(clz,"call",createFun);
		}

		__proto.classCreated=function(clz,oClass){
			var key;
			key=ClassTool.getNodeClassAndName(clz);
			var depth=0;
			var tClz;
			tClz=clz;
			while (tClz && tClz !=oClass){
				tClz=tClz.__super;
				depth++;
			}
			if (!ClassCreateHook.I.createInfo[key]){
				ClassCreateHook.I.createInfo[key]=0;
			}
			ClassCreateHook.I.createInfo[key]=ClassCreateHook.I.createInfo[key]+1;
			RunProfile.run(key,depth+6);
		}

		__proto.getClassCreateInfo=function(clz){
			var key;
			key=ClassTool.getClassName(clz);
			return RunProfile.getRunInfo(key);
		}

		ClassCreateHook.isInited=false;
		__static(ClassCreateHook,
		['I',function(){return this.I=new ClassCreateHook();}
		]);
		return ClassCreateHook;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.debug.tools.enginehook.RenderSpriteHook
	var RenderSpriteHook=(function(){
		function RenderSpriteHook(){
			//this._next=null;
			//this._fun=null;
			//this._oldCanvas=null;
		}

		__class(RenderSpriteHook,'laya.debug.tools.enginehook.RenderSpriteHook');
		var __proto=RenderSpriteHook.prototype;
		__proto.createRenderSprite=function(type,next){
			var rst;
			rst=RenderSpriteHook._preCreateFun(type,next);
			if (type==0x10){
				rst["_oldCanvas"]=rst._fun;
				rst._fun=RenderSpriteHook.I._canvas;
			}
			return rst;
		}

		__proto._canvas=function(sprite,context,x,y){
			if (!SpriteRenderForVisibleAnalyse.allowRendering)return;
			var _cacheCanvas=sprite._$P.cacheCanvas;
			var _next=this._next;
			if (!_cacheCanvas||SpriteRenderForVisibleAnalyse.isVisibleTesting){
				_next._fun.call(_next,sprite,context,x,y);
				return;
			};
			var preTime;
			preTime=Browser.now();
			var tx=_cacheCanvas.ctx;
			var _repaint=sprite._needRepaint()|| (!tx);
			this._oldCanvas(sprite,context,x,y);
			if (Config.showCanvasMark){
			}
			if (_repaint){
				CacheAnalyser.I.reCacheCanvas(sprite,Browser.now()-preTime);
				}else{
				CacheAnalyser.I.renderCanvas(sprite,Browser.now()-preTime);
			}
		}

		RenderSpriteHook.init=function(){
			if (RenderSpriteHook.I)return;
			RenderSpriteHook.I=new RenderSpriteHook();
			RenderSpriteHook._preCreateFun=RunDriver.createRenderSprite;
			RunDriver.createRenderSprite=RenderSpriteHook.I.createRenderSprite;
		}

		RenderSpriteHook.IMAGE=0x01;
		RenderSpriteHook.FILTERS=0x02;
		RenderSpriteHook.ALPHA=0x04;
		RenderSpriteHook.TRANSFORM=0x08;
		RenderSpriteHook.CANVAS=0x10;
		RenderSpriteHook.BLEND=0x20;
		RenderSpriteHook.CLIP=0x40;
		RenderSpriteHook.STYLE=0x80;
		RenderSpriteHook.GRAPHICS=0x100;
		RenderSpriteHook.CUSTOM=0x200;
		RenderSpriteHook.ENABLERENDERMERGE=0x400;
		RenderSpriteHook.CHILDS=0x800;
		RenderSpriteHook.INIT=0x11111;
		RenderSpriteHook.renders=[];
		RenderSpriteHook.I=null
		RenderSpriteHook._preCreateFun=null
		return RenderSpriteHook;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.debug.tools.enginehook.SpriteRenderForVisibleAnalyse
	var SpriteRenderForVisibleAnalyse=(function(){
		function SpriteRenderForVisibleAnalyse(){
			this._repaint=1;
			this._renderType=1;
			this._x=0;
			this._y=0;
			this.target=null;
			this.isTargetRenderd=false;
			this.preFun=null;
			this._next=null;
			this.pgraphic=RenderSprite["prototype"]["_graphics"];
			this.pimage=RenderSprite["prototype"]["_image"];
			this.pimage2=RenderSprite["prototype"]["_image2"];
		}

		__class(SpriteRenderForVisibleAnalyse,'laya.debug.tools.enginehook.SpriteRenderForVisibleAnalyse');
		var __proto=SpriteRenderForVisibleAnalyse.prototype;
		__proto.setRenderHook=function(){
			Sprite["prototype"]["render"]=SpriteRenderForVisibleAnalyse.I.render;
		}

		/**
		*更新、呈现显示对象。
		*@param context 渲染的上下文引用。
		*@param x X轴坐标。
		*@param y Y轴坐标。
		*/
		__proto.render=function(context,x,y){
			var me;
			me=this;
			if (DebugInfoLayer.I.isDebugItem(me))return;
			if (me==laya.debug.tools.enginehook.SpriteRenderForVisibleAnalyse.I.target){
				laya.debug.tools.enginehook.SpriteRenderForVisibleAnalyse.allowRendering=true;
				laya.debug.tools.enginehook.SpriteRenderForVisibleAnalyse.I.isTargetRenderd=true;
				CanvasTools.clearCanvas(SpriteRenderForVisibleAnalyse.mainCanvas);
			}
			RenderSprite.renders[this._renderType]._fun(this,context,x+this._x,y+this._y);
			if (me==laya.debug.tools.enginehook.SpriteRenderForVisibleAnalyse.I.target){
				SpriteRenderForVisibleAnalyse.tarRec=CanvasTools.getCanvasDisRec(laya.debug.tools.enginehook.SpriteRenderForVisibleAnalyse.mainCanvas);
				console.log("rec",SpriteRenderForVisibleAnalyse.tarRec.toString());
				if (SpriteRenderForVisibleAnalyse.tarRec.width >0&& SpriteRenderForVisibleAnalyse.tarRec.height > 0){
					SpriteRenderForVisibleAnalyse.isTarRecOK=true;
					SpriteRenderForVisibleAnalyse.preImageData=CanvasTools.getImageDataFromCanvasByRec(SpriteRenderForVisibleAnalyse.mainCanvas,SpriteRenderForVisibleAnalyse.tarRec);
					SpriteRenderForVisibleAnalyse.tarImageData=CanvasTools.getImageDataFromCanvasByRec(SpriteRenderForVisibleAnalyse.mainCanvas,SpriteRenderForVisibleAnalyse.tarRec);
					}else{
					console.log("tarRec Not OK:",SpriteRenderForVisibleAnalyse.tarRec);
				}
				}else{
				if (SpriteRenderForVisibleAnalyse.isTarRecOK){
					SpriteRenderForVisibleAnalyse.tImageData=CanvasTools.getImageDataFromCanvasByRec(SpriteRenderForVisibleAnalyse.mainCanvas,SpriteRenderForVisibleAnalyse.tarRec);
					var dRate=NaN;
					dRate=CanvasTools.getDifferRate(SpriteRenderForVisibleAnalyse.preImageData,SpriteRenderForVisibleAnalyse.tImageData);
					SpriteRenderForVisibleAnalyse.preImageData=SpriteRenderForVisibleAnalyse.tImageData;
					if (dRate > 0){
						VisibleAnalyser.addCoverNode(me,dRate);
					}
				}
			}
		}

		__proto.analyseNode=function(node){
			VisibleAnalyser.resetCoverList();
			if (Sprite["prototype"]["render"] !=SpriteRenderForVisibleAnalyse.I.render){
				this.preFun=Sprite["prototype"]["render"];
			}
			this.target=node;
			Sprite["prototype"]["render"]=this.render;
			if (!SpriteRenderForVisibleAnalyse.tarCanvas)
				SpriteRenderForVisibleAnalyse.tarCanvas=CanvasTools.createCanvas(Laya.stage.width,Laya.stage.height);
			if (!SpriteRenderForVisibleAnalyse.mainCanvas)
				SpriteRenderForVisibleAnalyse.mainCanvas=CanvasTools.createCanvas(Laya.stage.width,Laya.stage.height);
			this.isTargetRenderd=false;
			SpriteRenderForVisibleAnalyse.isVisibleTesting=true;
			SpriteRenderForVisibleAnalyse.allowRendering=false;
			CanvasTools.clearCanvas(SpriteRenderForVisibleAnalyse.mainCanvas);
			CanvasTools.clearCanvas(SpriteRenderForVisibleAnalyse.tarCanvas);
			SpriteRenderForVisibleAnalyse.isTarRecOK=false;
			var ctx=new RenderContext(SpriteRenderForVisibleAnalyse.mainCanvas.width,SpriteRenderForVisibleAnalyse.mainCanvas.height,SpriteRenderForVisibleAnalyse.mainCanvas);
			SpriteRenderForVisibleAnalyse.mainCanvas=ctx.canvas;
			this.render.call(Laya.stage,ctx,0,0);
			if (!SpriteRenderForVisibleAnalyse.isTarRecOK){
				SpriteRenderForVisibleAnalyse.coverRate=0;
				}else{
				SpriteRenderForVisibleAnalyse.coverRate=CanvasTools.getDifferRate(SpriteRenderForVisibleAnalyse.preImageData,SpriteRenderForVisibleAnalyse.tarImageData);
			}
			VisibleAnalyser.coverRate=SpriteRenderForVisibleAnalyse.coverRate;
			VisibleAnalyser.isTarRecOK=SpriteRenderForVisibleAnalyse.isTarRecOK;
			console.log("coverRate:",SpriteRenderForVisibleAnalyse.coverRate);
			this.isTargetRenderd=false;
			SpriteRenderForVisibleAnalyse.isVisibleTesting=false;
			SpriteRenderForVisibleAnalyse.allowRendering=true;
			Sprite["prototype"]["render"]=this.preFun;
		}

		__proto.noRenderMode=function(){
			return;
			RenderSprite["prototype"]["_graphics"]=this.m_graphics;
			RenderSprite["prototype"]["_image"]=this.m_image;
			RenderSprite["prototype"]["_image2"]=this.m_image2;
		}

		__proto.normalMode=function(){
			RenderSprite["prototype"]["_graphics"]=this.pgraphic;
			RenderSprite["prototype"]["_image"]=this.pimage;
			RenderSprite["prototype"]["_image2"]=this.pimage2;
		}

		__proto.inits=function(){
			this.noRenderMode();
		}

		__proto.m_graphics=function(sprite,context,x,y){
			if (laya.debug.tools.enginehook.SpriteRenderForVisibleAnalyse.allowRendering){
				var tf=sprite._style._tf;
				sprite._graphics && sprite._graphics._render(sprite,context,x-tf.translateX,y-tf.translateY);
			};
			var next=this._next;
			next._fun.call(next,sprite,context,x,y);
		}

		__proto.m_image=function(sprite,context,x,y){
			if (laya.debug.tools.enginehook.SpriteRenderForVisibleAnalyse.allowRendering){
				var style=sprite._style;
				context.ctx.drawTexture2(x,y,style._tf.translateX,style._tf.translateY,sprite.transform,style.alpha,style.blendMode,sprite._graphics._one);
			}
		}

		__proto.m_image2=function(sprite,context,x,y){
			if (laya.debug.tools.enginehook.SpriteRenderForVisibleAnalyse.allowRendering){
				var tf=sprite._style._tf;
				context.ctx.drawTexture2(x,y,tf.translateX,tf.translateY,sprite.transform,1,null,sprite._graphics._one);
			}
		}

		SpriteRenderForVisibleAnalyse.tarCanvas=null
		SpriteRenderForVisibleAnalyse.mainCanvas=null
		SpriteRenderForVisibleAnalyse.preImageData=null
		SpriteRenderForVisibleAnalyse.tImageData=null
		SpriteRenderForVisibleAnalyse.tarImageData=null
		SpriteRenderForVisibleAnalyse.tarRec=null
		SpriteRenderForVisibleAnalyse.isTarRecOK=false;
		SpriteRenderForVisibleAnalyse.isVisibleTesting=false;
		SpriteRenderForVisibleAnalyse.allowRendering=true;
		SpriteRenderForVisibleAnalyse.coverRate=NaN
		__static(SpriteRenderForVisibleAnalyse,
		['I',function(){return this.I=new SpriteRenderForVisibleAnalyse();}
		]);
		return SpriteRenderForVisibleAnalyse;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.debug.tools.enginehook.SpriteRenderHook
	var SpriteRenderHook=(function(){
		function SpriteRenderHook(){
			this._repaint=1;
			this._renderType=1;
			this._x=0;
			this._y=0;
		}

		__class(SpriteRenderHook,'laya.debug.tools.enginehook.SpriteRenderHook');
		var __proto=SpriteRenderHook.prototype;
		/**
		*更新、呈现显示对象。
		*@param context 渲染的上下文引用。
		*@param x X轴坐标。
		*@param y Y轴坐标。
		*/
		__proto.render=function(context,x,y){
			if ((this)==Laya.stage){
				CacheAnalyser.renderLoopBegin();
			};
			var preTime=0;
			preTime=Browser.now();
			Stat.spriteCount++;
			if (this["ShowBorderSign"]){
				DebugTool.showDisBoundToSprite(this,DebugInfoLayer.I.cacheViewLayer,DebugConsts.SPRITE_REC_COLOR,DebugConsts.SPRITE_REC_LINEWIDTH);
			}
			RenderSprite.renders[this._renderType]._fun(this,context,x+this._x,y+this._y);
			this._repaint=0;
			RenderAnalyser.I.render(this,Browser.now()-preTime);
		}

		SpriteRenderHook.init=function(){
			if (SpriteRenderHook.I)return;
			SpriteRenderHook.I=new SpriteRenderHook();
			SpriteRenderHook.setRenderHook();
		}

		SpriteRenderHook.setRenderHook=function(){
			Sprite["prototype"]["render"]=SpriteRenderHook.I.render;
		}

		SpriteRenderHook.showDisplayBorder=function(sprite,ifShowBorder){
			(ifShowBorder===void 0)&& (ifShowBorder=true);
			sprite["ShowBorderSign"]=ifShowBorder;
		}

		SpriteRenderHook.isDisplayShowBorder=function(sprite){
			return sprite["ShowBorderSign"];
		}

		SpriteRenderHook.I=null
		SpriteRenderHook.ShowBorderSign="ShowBorderSign";
		return SpriteRenderHook;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-10-30 下午1:06:56
	*/
	//class laya.debug.tools.FilterTool
	var FilterTool=(function(){
		function FilterTool(){}
		__class(FilterTool,'laya.debug.tools.FilterTool');
		FilterTool.getArrByFilter=function(arr,filterFun){
			var i=0,len=arr.length;
			var rst=[];
			for(i=0;i<len;i++){
				if(filterFun(arr[i]))rst.push(arr[i]);
			}
			return rst;
		}

		FilterTool.getArr=function(arr,sign,value){
			var i=0,len=arr.length;
			var rst=[];
			for(i=0;i<len;i++){
				if(arr[i][sign]==value)rst.push(arr[i]);
			}
			return rst;
		}

		return FilterTool;
	})()


	/**
	*本类用于在对象的函数上挂钩子
	*@author ww
	*@version 1.0
	*
	*@created 2015-10-23 下午1:13:13
	*/
	//class laya.debug.tools.hook.FunHook
	var FunHook=(function(){
		function FunHook(){}
		__class(FunHook,'laya.debug.tools.hook.FunHook');
		FunHook.hook=function(obj,funName,preFun,aftFun){
			FunHook.hookFuns(obj,funName,[preFun,obj[funName],aftFun],1);
		}

		FunHook.hookAllFun=function(obj){
			var key;
			var arr;
			arr=ClassTool.getOwnPropertyNames(obj);
			for(key in arr){
				key=arr[key];
				if (FunHook.special[key])continue ;
				console.log("try hook:",key);
				if((typeof (obj[key])=='function')){
					console.log("hook:",key);
					FunHook.hookFuns(obj,key,[FunHook.getTraceMsg("call:"+key),obj[key]],1);
				}
			}
			if(obj["__proto__"]){
				FunHook.hookAllFun(obj["__proto__"]);
				}else{
				console.log("end:",obj);
			}
		}

		FunHook.getTraceMsg=function(msg){
			var rst;
			rst=function (){
				console.log(msg);
			}
			return rst;
		}

		FunHook.hookFuns=function(obj,funName,funList,rstI){
			(rstI===void 0)&& (rstI=-1);
			var _preFun=obj[funName];
			var newFun;
			newFun=function (__args){
				var args=arguments;
				var rst;
				var i=0;
				var len=0;
				len=funList.length;
				for(i=0;i<len;i++){
					if(!funList[i])continue ;
					if(i==rstI){
						rst=funList[i].apply(this,args);
						}else{
						funList[i].apply(this,args);
					}
				}
				return rst;
			};
			newFun["pre"]=_preFun;
			obj[funName]=newFun;
		}

		FunHook.removeHook=function(obj,funName){
			if(obj[funName].pre!=null){
				obj[funName]=obj[funName].pre;
			}
		}

		FunHook.debugHere=function(){
			debugger;;
		}

		FunHook.traceLoc=function(level,msg){
			(level===void 0)&& (level=0);
			(msg===void 0)&& (msg="");
			console.log(msg,"fun loc:",TraceTool.getCallLoc(3+level));
		}

		FunHook.getLocFun=function(level,msg){
			(level===void 0)&& (level=0);
			(msg===void 0)&& (msg="");
			level+=1;
			var rst;
			rst=function (){
				FunHook.traceLoc(level,msg);
			}
			return rst;
		}

		__static(FunHook,
		['special',function(){return this.special={
				"length":true,
				"name":true,
				"arguments":true,
				"caller":true,
				"prototype":true,
				"is":true,
				"isExtensible":true,
				"isFrozen":true,
				"isSealed":true,
				"preventExtensions":true,
				"seal":true,
				"unobserve":true,
				"apply":true,
				"call":true,
				"bind":true,
				"freeze":true,
				"unobserve":true
		};}

		]);
		return FunHook;
	})()


	/**
	*本类用于监控对象 set get 函数的调用
	*@author ww
	*@version 1.0
	*
	*@created 2015-10-23 下午2:52:48
	*/
	//class laya.debug.tools.hook.VarHook
	var VarHook=(function(){
		function VarHook(){}
		__class(VarHook,'laya.debug.tools.hook.VarHook');
		VarHook.hookVar=function(obj,name,setHook,getHook){
			if(!setHook)setHook=[];
			if(!getHook)getHook=[];
			var preO=obj;
			var preValue=obj[name];
			var des;
			des=ClassTool.getOwnPropertyDescriptor(obj,name);
			var ndes={};
			var mSet=function (value){
				console.log("var hook set "+name+":",value);
				preValue=value;
			};
			var mGet=function (){
				console.log("var hook get"+name+":",preValue);
				return preValue;
			}
			if(des){
				ndes.set=mSet;
				ndes.get=mGet;
				ndes.enumerable=des.enumerable;
				setHook.push(ndes.set);
				getHook.push(ndes.get);
				FunHook.hookFuns(ndes,"set",setHook);
				FunHook.hookFuns(ndes,"get",getHook,getHook.length-1);
				ClassTool.defineProperty(obj,name,ndes);
				return;
			}
			while(!des&&obj["__proto__"]){
				obj=obj["__proto__"];
				des=ClassTool.getOwnPropertyDescriptor(obj,name);
			}
			if (des){
				ndes.set=des.set?des.set:mSet;
				ndes.get=des.get?des.get:mGet;
				ndes.enumerable=des.enumerable;
				setHook.push(ndes.set);
				getHook.push(ndes.get);
				FunHook.hookFuns(ndes,"set",setHook);
				FunHook.hookFuns(ndes,"get",getHook,getHook.length-1);
				ClassTool.defineProperty(preO,name,ndes);
			}
			if(!des){
				console.log("get des fail add directly");
				ndes.set=mSet;
				ndes.get=mGet;
				setHook.push(ndes.set);
				getHook.push(ndes.get);
				FunHook.hookFuns(ndes,"set",setHook);
				FunHook.hookFuns(ndes,"get",getHook,getHook.length-1);
				ClassTool.defineProperty(obj,name,ndes);
			}
		}

		VarHook.getLocFun=function(msg,level){
			(msg===void 0)&& (msg="");
			(level===void 0)&& (level=0);
			level+=1;
			var rst;
			rst=function (){
				FunHook.traceLoc(level,msg);
			}
			return rst;
		}

		return VarHook;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-10-29 上午9:45:33
	*/
	//class laya.debug.tools.IDTools
	var IDTools=(function(){
		function IDTools(){
			this.tID=1;
		}

		__class(IDTools,'laya.debug.tools.IDTools');
		var __proto=IDTools.prototype;
		__proto.getID=function(){
			return this.tID++;
		}

		IDTools.getAID=function(){
			return IDTools._ID.getID();
		}

		IDTools.idObjE=function(obj,sign){
			(sign===void 0)&& (sign="default");
			if (obj["_M_id_"])return obj;
			if(!sign){
				sign="default";
			}
			if(!IDTools._idDic[sign]){
				IDTools._idDic[sign]=new IDTools();
			}
			obj["_M_id_"]=IDTools._idDic[sign].getAID();
			return obj;
		}

		IDTools.setObjID=function(obj,id){
			obj["_M_id_"]=id;
			return obj;
		}

		IDTools.idObj=function(obj){
			if (obj["_M_id_"])return obj;
			obj["_M_id_"]=IDTools.getAID();
			return obj;
		}

		IDTools.getObjID=function(obj){
			if(!obj)return-1;
			return obj["_M_id_"];
		}

		IDTools.idSign="_M_id_";
		__static(IDTools,
		['_ID',function(){return this._ID=new IDTools();},'_idDic',function(){return this._idDic={"default":new IDTools()};}
		]);
		return IDTools;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-11-27 上午9:58:59
	*/
	//class laya.debug.tools.JsonTool
	var JsonTool=(function(){
		function JsonTool(){}
		__class(JsonTool,'laya.debug.tools.JsonTool');
		JsonTool.getJsonString=function(obj,singleLine,split,depth,Width){
			(singleLine===void 0)&& (singleLine=true);
			(split===void 0)&& (split="\n");
			(depth===void 0)&& (depth=0);
			(Width===void 0)&& (Width=4);
			var preStr="";
			preStr=JsonTool.getEmptyStr(depth*Width);
			var rst;
			var keyValues;
			keyValues={};
			var tKey;
			var tValue;
			var type;
			var keys;
			keys=[];
			for(tKey in obj){
				keys.push(tKey);
				tValue=obj[tKey];
				if(JsonTool.singleLineKey[tKey]){
					keyValues[tKey]=JsonTool.getValueStr(tValue,true,split,depth+1,Width);
					}else{
					keyValues[tKey]=JsonTool.getValueStr(tValue,singleLine,split,depth+1,Width);
				}
			};
			var i=0,len=0;
			len=keys.length;
			keys.sort();
			keys=keys.reverse();
			var keyPreStr;
			keyPreStr=JsonTool.getEmptyStr((depth+1)*Width);
			if(singleLine){
				split="";
				preStr="";
				keyPreStr="";
			};
			var keyValueStrArr;
			keyValueStrArr=[];
			for(i=0;i<len;i++){
				tKey=keys[i];
				keyValueStrArr.push(keyPreStr+JsonTool.wrapValue(tKey)+":"+keyValues[tKey]);
			}
			rst="{"+split+keyValueStrArr.join(","+split)+split+preStr+"}";
			return rst;
		}

		JsonTool.wrapValue=function(value,wraper){
			(wraper===void 0)&& (wraper="\"");
			return wraper+value+wraper;
		}

		JsonTool.getArrStr=function(arr,singleLine,split,depth,Width){
			(singleLine===void 0)&& (singleLine=true);
			(split===void 0)&& (split="\n");
			(depth===void 0)&& (depth=0);
			(Width===void 0)&& (Width=4);
			var rst;
			var i=0,len=0;
			len=arr.length;
			var valueStrArr;
			valueStrArr=[];
			for(i=0;i<len;i++){
				valueStrArr.push(JsonTool.getValueStr(arr[i],singleLine,split,depth+1,Width));
			};
			var preStr="";
			preStr=JsonTool.getEmptyStr((depth+1)*Width);
			if(singleLine){
				split="";
				preStr="";
			}
			rst="["+split+preStr+valueStrArr.join(","+split+preStr)+"]";
			return rst;
		}

		JsonTool.quote=function(string){
			JsonTool.escapable.lastIndex=0;
			return JsonTool.escapable.test(string)? '"'+string.replace(JsonTool.escapable,function(a){
				var c=JsonTool.meta[a];
				return typeof c==='string' ? c :
				'\\u'+('0000'+a.charCodeAt(0).toString(16)).slice(-4);
			})+'"' :'"'+string+'"';
		}

		JsonTool.getValueStr=function(tValue,singleLine,split,depth,Width){
			(singleLine===void 0)&& (singleLine=true);
			(split===void 0)&& (split="\n");
			(depth===void 0)&& (depth=0);
			(Width===void 0)&& (Width=0);
			var rst;
			if((typeof tValue=='string')){
				rst=JsonTool.quote(tValue);
				}else if(tValue==null){
				rst="null";
				}else if((typeof tValue=='number')|| ((typeof tValue=='number')&& Math.floor(tValue)==tValue)|| (typeof tValue=='boolean')){
				rst=tValue;
				}else if((tValue instanceof Array)){
				rst=JsonTool.getArrStr(tValue,singleLine,split,depth,Width);
				}else if((typeof tValue=='object')){
				rst=JsonTool.getJsonString(tValue,singleLine,split,depth,Width);
				}else{
				rst=tValue;
			}
			return rst;
		}

		JsonTool.getEmptyStr=function(width){
			if(!JsonTool.emptyDic.hasOwnProperty(width)){
				var i=0;
				var len=0;
				len=width;
				var rst;
				rst="";
				for(i=0;i<len;i++){
					rst+=" ";
				}
				JsonTool.emptyDic[width]=rst;
			}
			return JsonTool.emptyDic[width];
		}

		JsonTool.emptyDic={};
		__static(JsonTool,
		['singleLineKey',function(){return this.singleLineKey={
				"props":true
			};},'escapable',function(){return this.escapable=/[\\\"\x00-\x1f\x7f-\x9f\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g;},'meta',function(){return this.meta = {   
			'\b':'\\b',
			'\t':'\\t',
			'\n':'\\n',
			'\f':'\\f',
			'\r':'\\r',
			'"' :'\\"',
			'\\':'\\\\'
	};}


	]);
	return JsonTool;
	})()


	/**
	*本类用于操作html对象
	*@author ww
	*/
	//class laya.debug.tools.JSTools
	var JSTools=(function(){
		function JSTools(){}
		__class(JSTools,'laya.debug.tools.JSTools');
		JSTools.showToBody=function(el,x,y){
			(x===void 0)&& (x=0);
			(y===void 0)&& (y=0);
			Browser.document.body.appendChild(el);
			var style;
			style=el.style;
			style.position="absolute";
			style.top=y+"px";
			style.left=x+"px";
		}

		JSTools.showToParent=function(el,x,y,parent){
			(x===void 0)&& (x=0);
			(y===void 0)&& (y=0);
			parent.appendChild(el);
			var style;
			style=el.style;
			style.position="absolute";
			style.top=y+"px";
			style.left=x+"px";
		}

		JSTools.addToBody=function(el){
			Browser.document.body.appendChild(el);
		}

		JSTools.setPos=function(el,x,y){
			var style;
			style=el.style;
			style.top=y+"px";
			style.left=x+"px";
		}

		JSTools.setSize=function(el,width,height){
			var style;
			style=el.style;
			style.width=width+"px";
			style.height=height+"px";
		}

		JSTools.setTransform=function(el,mat){
			var style;
			style=el.style;
			style.transformOrigin=style.webkitTransformOrigin=style.msTransformOrigin=style.mozTransformOrigin=style.oTransformOrigin="0px 0px 0px";
			style.transform=style.webkitTransform=style.msTransform=style.mozTransform=style.oTransform="matrix("+mat.toString()+")";
		}

		JSTools.noMouseEvent=function(el){
			var style;
			style=el.style;
			style["pointer-events"]="none";
		}

		JSTools.setMouseEnable=function(el,enable){
			var style;
			style=el.style;
			style["pointer-events"]=enable?"auto":"none";
		}

		JSTools.setZIndex=function(el,zIndex){
			var style;
			style=el.style;
			style["z-index"]=zIndex;
		}

		JSTools.showAboveSprite=function(el,sprite,dx,dy){
			(dx===void 0)&& (dx=0);
			(dy===void 0)&& (dy=0);
			var pos;
			pos=new Point();
			pos=sprite.localToGlobal(pos);
			pos.x+=dx;
			pos.y+=dy;
			pos.x+=Laya.stage.offset.x;
			pos.y+=Laya.stage.offset.y;
			JSTools.showToBody(el,pos.x,pos.y);
		}

		JSTools.removeElement=function(el){
			Browser.removeElement(el);
		}

		JSTools.isElementInDom=function(el){
			return el && el.parentNode;
		}

		JSTools.getImageSpriteByFile=function(file,width,height){
			(width===void 0)&& (width=0);
			(height===void 0)&& (height=0);
			var reader;
			reader=new FileReader();;
			reader.readAsDataURL(file);
			var sprite;
			sprite=new Sprite();
			reader.onload=function (e){
				var txt;
				txt=new Texture();
				txt.load(reader.result);
				sprite.graphics.drawTexture(txt,0,0,width,height);
			}
			return sprite;
		}

		JSTools.getPixelRatio=function(){
			if (JSTools._pixelRatio > 0)return JSTools._pixelRatio;
			var canvas=Browser.createElement("canvas");
			var context=canvas.getContext('2d');
			var devicePixelRatio=Browser.window.devicePixelRatio || 1;
			var backingStoreRatio=context.webkitBackingStorePixelRatio ||
			context.mozBackingStorePixelRatio ||
			context.msBackingStorePixelRatio ||
			context.oBackingStorePixelRatio ||
			context.backingStorePixelRatio || 1;
			var ratio=devicePixelRatio / backingStoreRatio;
			console.log("pixelRatioc:",ratio);
			JSTools._pixelRatio=ratio;
			return ratio;
		}

		JSTools._pixelRatio=-1;
		return JSTools;
	})()


	/**
	*布局工具类,目前只支持水平方向布局
	*@author ww
	*/
	//class laya.debug.tools.layout.Layouter
	var Layouter=(function(){
		function Layouter(){
			this.data=null;
			this._items=null;
			this.layoutFun=null;
			this._sX=0;
			this._width=0;
		}

		__class(Layouter,'laya.debug.tools.layout.Layouter');
		var __proto=Layouter.prototype;
		__proto.layout=function(){
			this.layoutFun(this._width,this._items,this.data,this._sX);
		}

		/**
		*重新布局
		*
		*/
		__proto.changed=function(){
			Laya.timer.callLater(this,this.layout);
		}

		/**
		*根据当前的对象状态计算位置大小
		*
		*/
		__proto.calSize=function(){
			var i=0,len=0;
			var tItem;
			tItem=this.items[0];
			this._sX=tItem.x;
			var maxX=NaN;
			maxX=this._sX+tItem.width;
			len=this.items.length;
			for (i=1;i < len;i++){
				tItem=this.items[i];
				if (this._sX > tItem.x){
					this._sX=tItem.x;
				}
				if (maxX < tItem.x+tItem.width){
					maxX=tItem.x+tItem.width;
				}
			}
			this._width=maxX-this._sX;
		}

		__getset(0,__proto,'width',function(){
			return this._width;
			},function(v){
			this._width=v;
			this.changed();
		});

		__getset(0,__proto,'x',function(){
			return this._sX;
			},function(v){
			this._sX=v;
			this.changed();
		});

		__getset(0,__proto,'items',function(){
			return this._items;
			},function(arr){
			this._items=arr;
			this.calSize();
		});

		return Layouter;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.debug.tools.layout.LayoutFuns
	var LayoutFuns=(function(){
		function LayoutFuns(){}
		__class(LayoutFuns,'laya.debug.tools.layout.LayoutFuns');
		LayoutFuns.sameWidth=function(totalWidth,items,data,sX){
			(sX===void 0)&& (sX=0);
			var dWidth=0;
			if (data && data.dWidth)
				dWidth=data.dWidth;
			var perWidth=NaN;
			perWidth=(totalWidth-(items.length-1)*dWidth)/ items.length;
			var tItem;
			var i=0,len=0;
			var tX=NaN;
			tX=sX;
			len=items.length;
			for (i=0;i < len;i++){
				tItem=items[i];
				tItem.x=tX;
				tItem.width=perWidth;
				tX+=dWidth+perWidth;
			}
		}

		LayoutFuns.getSameWidthLayout=function(items,dWidth){
			var data;
			data={};
			data.dWidth=dWidth;
			return LayoutFuns.getLayouter(items,data,laya.debug.tools.layout.LayoutFuns.sameWidth);
		}

		LayoutFuns.getLayouter=function(items,data,fun){
			var layouter;
			layouter=new Layouter();
			layouter.items=items;
			layouter.data=data;
			layouter.layoutFun=fun;
			return layouter;
		}

		LayoutFuns.sameDis=function(totalWidth,items,data,sX){
			(sX===void 0)&& (sX=0);
			var dWidth=NaN;
			dWidth=totalWidth;
			var tItem;
			var i=0,len=0;
			len=items.length;
			LayoutFuns.prepareForLayoutWidth(totalWidth,items);
			for (i=0;i < len;i++){
				tItem=items[i];
				dWidth-=tItem.width;
			}
			if (items.length > 1)
				dWidth=dWidth / (items.length-1);
			var tX=NaN;
			tX=sX;
			len=items.length;
			for (i=0;i < len;i++){
				tItem=items[i];
				tItem.x=tX;
				tX+=dWidth+tItem.width;
			}
		}

		LayoutFuns.getSameDisLayout=function(items,rateSame){
			(rateSame===void 0)&& (rateSame=false);
			var data;
			data={};
			if (rateSame){
				var i=0,len=0;
				len=items.length;
				var tItem;
				var totalWidth=NaN;
				totalWidth=0;
				for (i=0;i < len;i++){
					tItem=items[i];
					totalWidth+=tItem.width;
				}
				totalWidth=tItem.x+tItem.width;
				for (i=0;i < len;i++){
					tItem=items[i];
					LayoutFuns.setItemRate(tItem,tItem.width / totalWidth);
				}
			}
			return LayoutFuns.getLayouter(items,data,laya.debug.tools.layout.LayoutFuns.sameDis);
		}

		LayoutFuns.fullFill=function(totalWidth,items,data,sX){
			(sX===void 0)&& (sX=0);
			var dL=0,dR=0;
			if (data){
				if (data.dL)
					dL=data.dL;
				if (data.dR)
					dR=data.dR;
			};
			var item;
			var i=0,len=0;
			len=items.length;
			for (i=0;i < len;i++){
				item=items[i];
				item.x=sX+dL;
				item.width=totalWidth-dL-dR;
			}
		}

		LayoutFuns.getFullFillLayout=function(items,dL,dR){
			(dL===void 0)&& (dL=0);
			(dR===void 0)&& (dR=0);
			var data;
			data={};
			data.dL=dL;
			data.dR=dR;
			return LayoutFuns.getLayouter(items,data,laya.debug.tools.layout.LayoutFuns.fullFill);
		}

		LayoutFuns.fixPos=function(totalWidth,items,data,sX){
			(sX===void 0)&& (sX=0);
			var dLen=0;
			var poss=[];
			var isRate=false;
			if (data){
				if (data.dLen)
					dLen=data.dLen;
				if (data.poss)
					poss=data.poss;
				if (data.isRate)
					isRate=data.isRate;
			};
			var item;
			var i=0,len=0;
			len=poss.length;
			var tX=NaN;
			tX=sX;
			var tValue=NaN;
			var preItem;
			preItem=null;
			for (i=0;i < len;i++){
				item=items[i];
				tValue=sX+poss[i];
				if (isRate){
					tValue=sX+poss[i] *totalWidth;
				}
				item.x=tValue;
				if (preItem){
					preItem.width=item.x-dLen-preItem.x;
				}
				preItem=item;
			};
			var lastItem;
			lastItem=items[items.length-1];
			lastItem.width=sX+totalWidth-dLen-lastItem.x;
		}

		LayoutFuns.getFixPos=function(items,dLen,isRate,poss){
			(dLen===void 0)&& (dLen=0);
			(isRate===void 0)&& (isRate=false);
			var data;
			data={};
			var layout;
			layout=LayoutFuns.getLayouter(items,data,LayoutFuns.fixPos);
			var i=0,len=0;
			var sX=NaN;
			var totalWidth=NaN;
			sX=layout.x;
			totalWidth=layout.width;
			if (!poss){
				poss=[];
				len=items.length;
				var tValue=NaN;
				for (i=0;i < len;i++){
					tValue=items[i].x-sX;
					if (isRate){
						tValue=tValue / totalWidth;
					}
					else{
					}
					poss.push(tValue);
				}
			}
			data.dLen=dLen;
			data.poss=poss;
			data.isRate=isRate;
			return layout;
		}

		LayoutFuns.clearItemsRelativeInfo=function(items){
			var i=0,len=0;
			len=items.length;
			for (i=0;i < len;i++){
				LayoutFuns.clearItemRelativeInfo(items[i]);
			}
		}

		LayoutFuns.clearItemRelativeInfo=function(item){
			var Nan="NaN";
			item.getLayout().left=Nan;
			item.getLayout().right=Nan;
		}

		LayoutFuns.prepareForLayoutWidth=function(totalWidth,items){
			var i=0,len=0;
			len=items.length;
			for (i=0;i < len;i++){
				LayoutFuns.prepareItemForLayoutWidth(totalWidth,items[i]);
			}
		}

		LayoutFuns.getSumWidth=function(items){
			var sum=NaN;
			sum=0;
			var i=0,len=0;
			len=items.length;
			for (i=0;i < len;i++){
				sum+=items[i].width;
			}
			return sum;
		}

		LayoutFuns.prepareItemForLayoutWidth=function(totalWidth,item){
			if (LayoutFuns.getItemRate(item)> 0){
				item.width=totalWidth *LayoutFuns.getItemRate(item);
			}
		}

		LayoutFuns.setItemRate=function(item,rate){
			item["layoutRate"]=rate;
		}

		LayoutFuns.getItemRate=function(item){
			return item["layoutRate"] ? item["layoutRate"] :-1;
		}

		LayoutFuns.setItemFreeSize=function(item,free){
			(free===void 0)&& (free=true);
			item["layoutFreeSize"]=free;
		}

		LayoutFuns.isItemFreeSize=function(item){
			return item["layoutFreeSize"];
		}

		LayoutFuns.lockedDis=function(totalWidth,items,data,sX){
			(sX===void 0)&& (sX=0);
			var dists;
			dists=data.dists;
			var sumDis=NaN;
			sumDis=data.sumDis;
			var sumWidth=NaN;
			var i=0,len=0;
			var tItem;
			var preItem;
			LayoutFuns.prepareForLayoutWidth(totalWidth,items);
			sumWidth=LayoutFuns.getSumWidth(items);
			var dWidth=NaN;
			dWidth=totalWidth-sumDis-sumWidth;
			var freeItem;
			freeItem=LayoutFuns.getFreeItem(items);
			if(freeItem){
				freeItem.width+=dWidth;
			}
			preItem=items[0];
			preItem.x=sX;
			len=items.length;
			for(i=1;i<len;i++){
				tItem=items[i];
				tItem.x=preItem.x+preItem.width+dists[i-1];
				preItem=tItem;
			}
		}

		LayoutFuns.getFreeItem=function(items){
			var i=0,len=0;
			len=items.length;
			for (i=0;i < len;i++){
				if(LayoutFuns.isItemFreeSize(items[i])){
					return items[i];
				}
			}
			return null;
		}

		LayoutFuns.getLockedDis=function(items){
			var data;
			data={};
			var dists;
			var i=0,len=0;
			var tItem;
			var preItem;
			var sumDis=NaN;
			sumDis=0;
			var tDis=NaN;
			preItem=items[0];
			dists=[];
			len=items.length;
			for(i=1;i<len;i++){
				tItem=items[i];
				tDis=tItem.x-preItem.x-preItem.width;
				dists.push(tDis);
				sumDis+=tDis;
				preItem=tItem;
			}
			data.dists=dists;
			data.sumDis=sumDis;
			return LayoutFuns.getLayouter(items,data,laya.debug.tools.layout.LayoutFuns.lockedDis);
		}

		LayoutFuns.RateSign="layoutRate";
		LayoutFuns.FreeSizeSign="layoutFreeSize";
		return LayoutFuns;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-11-9 下午3:26:01
	*/
	//class laya.debug.tools.LayoutTools
	var LayoutTools=(function(){
		function LayoutTools(){}
		__class(LayoutTools,'laya.debug.tools.LayoutTools');
		LayoutTools.layoutToXCount=function(items,xCount,dx,dY,sx,sy){
			(xCount===void 0)&& (xCount=1);
			(dx===void 0)&& (dx=0);
			(dY===void 0)&& (dY=0);
			(sx===void 0)&& (sx=0);
			(sy===void 0)&& (sy=0);
			var tX=NaN,tY=NaN;
			var tItem;
			var i=0,len=0;
			var tCount=0;
			var maxHeight=0;
			tCount=0;
			maxHeight=0;
			tX=sx;
			tY=sy;
			len=items.length;
			for (i=0;i < len;i++){
				tItem=items[i];
				tItem.x=tX;
				tItem.y=tY;
				if (tItem.height > maxHeight){
					maxHeight=tItem.height;
				}
				tCount++;
				if (tCount >=xCount){
					tCount=tCount % xCount;
					tItem.y+=maxHeight+dY;
					maxHeight=0;
					}else{
					tX+=tItem.width+dx;
				}
			}
		}

		LayoutTools.layoutToWidth=function(items,width,dX,dY,sx,sy){
			var tX=NaN,tY=NaN;
			var tItem;
			var i=0,len=0;
			tX=sx;
			tY=sy;
			len=items.length;
			for(i=0;i<len;i++){
				tItem=items[i];
				if(tX+tItem.width+dX>width){
					tX=sx;
					tY+=dY+tItem.height;
					}else{
				}
				tItem.x=tX;
				tItem.y=tY;
				tX+=dX+tItem.width;
			}
		}

		return LayoutTools;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.debug.tools.MathTools
	var MathTools=(function(){
		function MathTools(){}
		__class(MathTools,'laya.debug.tools.MathTools');
		MathTools.sortBigFirst=function(a,b){
			if (a==b)
				return 0;
			return b > a ? 1 :-1;
		}

		MathTools.sortSmallFirst=function(a,b){
			if (a==b)
				return 0;
			return b > a ?-1 :1;
		}

		MathTools.sortNumBigFirst=function(a,b){
			return parseFloat(b)-parseFloat(a);
		}

		MathTools.sortNumSmallFirst=function(a,b){
			return parseFloat(a)-parseFloat(b);
		}

		MathTools.sortByKey=function(key,bigFirst,forceNum){
			(bigFirst===void 0)&& (bigFirst=false);
			(forceNum===void 0)&& (forceNum=true);
			var _sortFun;
			if (bigFirst){
				_sortFun=forceNum ? MathTools.sortNumBigFirst :MathTools.sortBigFirst;
				}else {
				_sortFun=forceNum ? MathTools.sortNumSmallFirst :MathTools.sortSmallFirst;
			}
			return function (a,b){
				return _sortFun(a[key],b[key]);
			};
		}

		return MathTools;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.debug.tools.MouseEventAnalyser
	var MouseEventAnalyser=(function(){
		function MouseEventAnalyser(){}
		__class(MouseEventAnalyser,'laya.debug.tools.MouseEventAnalyser');
		MouseEventAnalyser.analyseNode=function(node){
			DebugTool.showDisBound(node,true);
			var _node;
			_node=node;
			ObjectTools$1.clearObj(MouseEventAnalyser.infoO);
			ObjectTools$1.clearObj(MouseEventAnalyser.nodeO);
			ObjectTools$1.clearObj(MouseEventAnalyser.hitO);
			var nodeList;
			nodeList=[];
			while (node){
				IDTools.idObj(node);
				MouseEventAnalyser.nodeO[IDTools.getObjID(node)]=node;
				nodeList.push(node);
				node=node.parent;
			}
			MouseEventAnalyser.check(Laya.stage,Laya.stage.mouseX,Laya.stage.mouseY,null);
			var canStr;
			if (MouseEventAnalyser.hitO[IDTools.getObjID(_node)]){
				console.log("can hit");
				canStr="can hit";
			}
			else{
				console.log("can't hit");
				canStr="can't hit";
			};
			var i=0,len=0;
			nodeList=nodeList.reverse();
			len=nodeList.length;
			var rstTxts;
			rstTxts=["[分析对象]:"+ClassTool.getNodeClassAndName(_node)+":"+canStr];
			for (i=0;i < len;i++){
				node=nodeList[i];
				if (MouseEventAnalyser.hitO[IDTools.getObjID(node)]){
					console.log("can hit:",ClassTool.getNodeClassAndName(node));
					console.log("原因:",MouseEventAnalyser.infoO[IDTools.getObjID(node)]);
					rstTxts.push("can hit:"+" "+ClassTool.getNodeClassAndName(node));
					rstTxts.push("原因:"+" "+MouseEventAnalyser.infoO[IDTools.getObjID(node)]);
				}
				else{
					console.log("can't hit:"+ClassTool.getNodeClassAndName(node));
					console.log("原因:",MouseEventAnalyser.infoO[IDTools.getObjID(node)] ? MouseEventAnalyser.infoO[IDTools.getObjID(node)] :"鼠标事件在父级已停止派发");
					rstTxts.push("can't hit:"+" "+ClassTool.getNodeClassAndName(node));
					rstTxts.push("原因:"+" "+(MouseEventAnalyser.infoO[IDTools.getObjID(node)] ? MouseEventAnalyser.infoO[IDTools.getObjID(node)] :"鼠标事件在父级已停止派发"));
				}
			};
			var rstStr;
			rstStr=rstTxts.join("\n");
			ToolPanel.I.showTxtInfo(rstStr);
		}

		MouseEventAnalyser.check=function(sp,mouseX,mouseY,callBack){
			IDTools.idObj(sp);
			var isInAnlyseChain=false;
			isInAnlyseChain=MouseEventAnalyser.nodeO[IDTools.getObjID(sp)];
			MouseEventAnalyser._point.setTo(mouseX,mouseY);
			sp.fromParentPoint(MouseEventAnalyser._point);
			mouseX=MouseEventAnalyser._point.x;
			mouseY=MouseEventAnalyser._point.y;
			var scrollRect=sp.scrollRect;
			if (scrollRect){
				MouseEventAnalyser._rect.setTo(scrollRect.x,scrollRect.y,scrollRect.width,scrollRect.height);
				var isHit=MouseEventAnalyser._rect.contains(mouseX,mouseY);
				if (!isHit){
					if (isInAnlyseChain){
						MouseEventAnalyser.infoO[IDTools.getObjID(sp)]="scrollRect没有包含鼠标"+MouseEventAnalyser._rect.toString()+":"+mouseX+","+mouseY;
					}
					return false;
				}
			};
			var i=0,len=0;
			var cList;
			cList=sp._childs;
			len=cList.length;
			var child;
			var childInChain;
			childInChain=null;
			for (i=0;i < len;i++){
				child=cList[i];
				IDTools.idObj(child);
				if (MouseEventAnalyser.nodeO[IDTools.getObjID(child)]){
					childInChain=child;
					break ;
				}
			};
			var coverByOthers=false;
			coverByOthers=childInChain ? true :false;
			var flag=false;
			if (sp.hitTestPrior && !sp.mouseThrough && !MouseEventAnalyser.hitTest(sp,mouseX,mouseY)){
				MouseEventAnalyser.infoO[IDTools.getObjID(sp)]="hitTestPrior=true，宽高区域不包含鼠标:"+":"+mouseX+","+mouseY+" size:"+sp.width+","+sp.height;
				return false;
			}
			for (i=sp._childs.length-1;i >-1;i--){
				child=sp._childs[i];
				if (child==childInChain){
					if (!childInChain.mouseEnabled){
						MouseEventAnalyser.infoO[IDTools.getObjID(childInChain)]="mouseEnabled=false";
					}
					if (!childInChain.visible){
						MouseEventAnalyser.infoO[IDTools.getObjID(childInChain)]="visible=false";
					}
					coverByOthers=false;
				}
				if (child.mouseEnabled && child.visible){
					flag=MouseEventAnalyser.check(child,mouseX ,mouseY,callBack);
					if (flag){
						MouseEventAnalyser.hitO[IDTools.getObjID(sp)]=true;
						MouseEventAnalyser.infoO[IDTools.getObjID(sp)]="子对象被击中";
						if (child==childInChain){
							MouseEventAnalyser.infoO[IDTools.getObjID(sp)]="子对象被击中,"+"击中对象在分析链中";
						}
						else{
							MouseEventAnalyser.infoO[IDTools.getObjID(sp)]="子对象被击中,"+"击中对象不在分析链中";
							if (coverByOthers){
								MouseEventAnalyser.infoO[IDTools.getObjID(childInChain)]="被兄弟节点挡住,兄弟节点信息:"+ClassTool.getNodeClassAndName(child)+","+child.getBounds().toString();
								DebugTool.showDisBound(child,false,"#ffff00");
							}
						}
						return true;
					}
					else{
						if (child==childInChain){
							coverByOthers=false;
						}
					}
				}
			};
			var mHitRect=new Rectangle();
			var graphicHit=false;
			graphicHit=sp.getGraphicBounds().contains(mouseX,mouseY);
			if (sp.width > 0 && sp.height > 0){
				var hitRect=MouseEventAnalyser._rect;
				if (!sp.mouseThrough){
					if (sp.hitArea)
						hitRect=sp.hitArea;
					else
					hitRect.setTo(0,0,sp.width,sp.height);
					mHitRect.copyFrom(hitRect);
					isHit=hitRect.contains(mouseX,mouseY);
				}
				else{
					isHit=graphicHit;
					mHitRect.copyFrom(sp.getGraphicBounds());
				}
				if (isHit){
					MouseEventAnalyser.hitO[IDTools.getObjID(sp)]=true;
				}
				}else{
			}
			if (!isHit){
				if (graphicHit){
					MouseEventAnalyser.infoO[IDTools.getObjID(sp)]="子对象未包含鼠标，实际绘图区域包含鼠标，设置的宽高区域不包含鼠标:"+":"+mouseX+","+mouseY+" hitRec:"+mHitRect.toString()+" graphicBounds:"+sp.getGraphicBounds().toString()+"，设置mouseThrough=true或将宽高设置到实际绘图区域可解决问题";
					}else{
					MouseEventAnalyser.infoO[IDTools.getObjID(sp)]="子对象未包含鼠标，实际绘图区域不包含鼠标，设置的宽高区域不包含鼠标:"+":"+mouseX+","+mouseY+" hitRec:"+mHitRect.toString()+" graphicBounds:"+sp.getGraphicBounds().toString();
				}
			}
			else{
				MouseEventAnalyser.infoO[IDTools.getObjID(sp)]="自身区域被击中";
			}
			return isHit;
		}

		MouseEventAnalyser.hitTest=function(sp,mouseX,mouseY){
			var isHit=false;
			if ((sp.hitArea instanceof laya.utils.HitArea )){
				return sp.hitArea.isHit(mouseX,mouseY);
			}
			if (sp.width > 0 && sp.height > 0 || sp.mouseThrough || sp.hitArea){
				var hitRect=MouseEventAnalyser._rect;
				if (!sp.mouseThrough){
					if (sp.hitArea)hitRect=sp.hitArea;
					else hitRect.setTo(0,0,sp.width,sp.height);
					isHit=hitRect.contains(mouseX,mouseY);
					}else {
					isHit=sp.getGraphicBounds().contains(mouseX,mouseY);
				}
			}
			return isHit;
		}

		MouseEventAnalyser.infoO={};
		MouseEventAnalyser.nodeO={};
		MouseEventAnalyser.hitO={};
		__static(MouseEventAnalyser,
		['_matrix',function(){return this._matrix=new Matrix();},'_point',function(){return this._point=new Point();},'_rect',function(){return this._rect=new Rectangle();}
		]);
		return MouseEventAnalyser;
	})()


	/**
	*本类提供obj相关的一些操作
	*@author ww
	*@version 1.0
	*
	*@created 2015-10-21 下午2:03:36
	*/
	//class laya.debug.tools.ObjectTools
	var ObjectTools$1=(function(){
		function ObjectTools(){}
		__class(ObjectTools,'laya.debug.tools.ObjectTools',null,'ObjectTools$1');
		ObjectTools.getFlatKey=function(tKey,aKey){
			if(tKey=="")return aKey;
			return tKey+ObjectTools.sign+aKey;
		}

		ObjectTools.flatObj=function(obj,rst,tKey){
			(tKey===void 0)&& (tKey="");
			rst=rst?rst:{};
			var key;
			var tValue;
			for(key in obj){
				if((typeof (obj[key])=='object')){
					ObjectTools.flatObj(obj[key],rst,ObjectTools.getFlatKey(tKey,key));
					}else{
					tValue=obj[key];
					rst[ObjectTools.getFlatKey(tKey,key)]=obj[key];
				}
			}
			return rst;
		}

		ObjectTools.recoverObj=function(obj){
			var rst={};
			var tKey;
			for(tKey in obj){
				ObjectTools.setKeyValue(rst,tKey,obj[tKey]);
			}
			return rst;
		}

		ObjectTools.differ=function(objA,objB){
			var tKey;
			var valueA;
			var valueB;
			objA=ObjectTools.flatObj(objA);
			objB=ObjectTools.flatObj(objB);
			var rst={};
			for(tKey in objA){
				if(!objB.hasOwnProperty(tKey)){
					rst[tKey]="被删除";
				}
			}
			for(tKey in objB){
				if(objB[tKey]!=objA[tKey]){
					rst[tKey]={"pre":objA[tKey],"now":objB[tKey]};
				}
			}
			return rst;
		}

		ObjectTools.traceDifferObj=function(obj){
			var key;
			var tO;
			for(key in obj){
				if((typeof (obj[key])=='string')){
					console.log(key+":",obj[key]);
					}else{
					tO=obj[key];
					console.log(key+":","now:",tO["now"],"pre:",tO["pre"]);
				}
			}
		}

		ObjectTools.setKeyValue=function(obj,flatKey,value){
			if(flatKey.indexOf(ObjectTools.sign)>=0){
				var keys=flatKey.split(ObjectTools.sign);
				var tKey;
				while(keys.length>1){
					tKey=keys.shift();
					if(!obj[tKey]){
						obj[tKey]={};
						console.log("addKeyObj:",tKey);
					}
					obj=obj[tKey];
					if(!obj){
						console.log("wrong flatKey:",flatKey);
						return;
					}
				}
				obj[keys.shift()]=value;
				}else{
				obj[flatKey]=value;
			}
		}

		ObjectTools.clearObj=function(obj){
			var key;
			for (key in obj){
				delete obj[key];
			}
		}

		ObjectTools.copyObjFast=function(obj){
			var jsStr;
			jsStr=laya.debug.tools.ObjectTools.getJsonString(obj);
			return laya.debug.tools.ObjectTools.getObj(jsStr);
		}

		ObjectTools.copyObj=function(obj){
			if((obj instanceof Array))return ObjectTools.copyArr(obj);
			var rst={};
			var key;
			for(key in obj){
				if(obj[key]===null||obj[key]===undefined){
					rst[key]=obj[key];
				}else
				if(((obj[key])instanceof Array)){
					rst[key]=ObjectTools.copyArr(obj[key]);
				}
				else
				if((typeof (obj[key])=='object')){
					rst[key]=ObjectTools.copyObj(obj[key]);
					}else{
					rst[key]=obj[key];
				}
			}
			return rst;
		}

		ObjectTools.copyArr=function(arr){
			var rst;
			rst=[];
			var i=0,len=0;
			len=arr.length;
			for(i=0;i<len;i++){
				rst.push(ObjectTools.copyObj(arr[i]));
			}
			return rst;
		}

		ObjectTools.concatArr=function(src,a){
			if (!a)return src;
			if (!src)return a;
			var i=0,len=a.length;
			for (i=0;i < len;i++){
				src.push(a[i]);
			}
			return src;
		}

		ObjectTools.insertArrToArr=function(src,insertArr,pos){
			(pos===void 0)&& (pos=0);
			if (pos < 0)pos=0;
			if (pos > src.length)pos=src.length;
			var preLen=src.length;
			var i=0,len=0;
			src.length+=insertArr.length;
			var moveLen=0;
			moveLen=insertArr.length;
			for (i=src.length-1;i >=pos;i--){
				src[i]=src[i-moveLen];
			}
			len=insertArr.length;
			for (i=0;i < len;i++){
				src[pos+i]=insertArr[i];
			}
			return src;
		}

		ObjectTools.clearArr=function(arr){
			if (!arr)return arr;
			arr.length=0;
			return arr;
		}

		ObjectTools.removeFromArr=function(arr,item){
			var i=0,len=0;
			len=arr.length;
			for(i=0;i<len;i++){
				if(arr[i]==item){
					arr[i].splice(i,1);
					return;
				}
			}
		}

		ObjectTools.setValueArr=function(src,v){
			src || (src=[]);
			src.length=0;
			return ObjectTools.concatArr(src,v);
		}

		ObjectTools.getFrom=function(rst,src,count){
			var i=0;
			for (i=0;i < count;i++){
				rst.push(src[i]);
			}
			return rst;
		}

		ObjectTools.getFromR=function(rst,src,count){
			var i=0;
			for (i=0;i < count;i++){
				rst.push(src.pop());
			}
			return rst;
		}

		ObjectTools.enableDisplayTree=function(dis){
			while (dis){
				dis.mouseEnabled=true;
				dis=dis.parent;
			}
		}

		ObjectTools.getJsonString=function(obj){
			var rst;
			rst=JSON.stringify(obj);
			return rst;
		}

		ObjectTools.getObj=function(jsonStr){
			var rst;
			rst=JSON.parse(jsonStr);
			return rst;
		}

		ObjectTools.getKeyArr=function(obj){
			var rst;
			var key;
			rst=[];
			for(key in obj){
				rst.push(key);
			}
			return rst;
		}

		ObjectTools.getObjValues=function(dataList,key){
			var rst;
			var i=0,len=0;
			len=dataList.length;
			rst=[];
			for(i=0;i<len;i++){
				rst.push(dataList[i][key]);
			}
			return rst;
		}

		ObjectTools.hasKeys=function(obj,keys){
			var i=0,len=0;
			len=keys.length;
			for(i=0;i<len;i++){
				if(!obj.hasOwnProperty(keys[i]))return false;
			}
			return true;
		}

		ObjectTools.copyValueByArr=function(tar,src,keys){
			var i=0,len=keys.length;
			for(i=0;i<len;i++){
				if(!(src[keys[i]]===null))
					tar[keys[i]]=src[keys[i]];
			}
		}

		ObjectTools.getNoSameArr=function(arr){
			var i=0,len=0;
			var rst;
			rst=[];
			var tItem;
			len=arr.length;
			for (i=0;i < len;i++){
				tItem=arr[i];
				if (rst.indexOf(tItem)< 0){
					rst.push(tItem);
				}
			}
			return rst;
		}

		ObjectTools.insertValue=function(tar,src){
			var key;
			for (key in src){
				tar[key]=src[key];
			}
		}

		ObjectTools.replaceValue=function(obj,replaceO){
			var key;
			for(key in obj){
				if(replaceO.hasOwnProperty(obj[key])){
					obj[key]=replaceO[obj[key]];
				}
				if((typeof (obj[key])=='object')){
					ObjectTools.replaceValue(obj[key],replaceO);
				}
			}
		}

		ObjectTools.setKeyValues=function(items,key,value){
			var i=0,len=0;
			len=items.length;
			for(i=0;i<len;i++){
				items[i][key]=value;
			}
		}

		ObjectTools.findItemPos=function(items,sign,value){
			var i=0,len=0;
			len=items.length;
			for(i=0;i<len;i++){
				if(items[i][sign]==value){
					return i;
				}
			}
			return-1;
		}

		ObjectTools.setObjValue=function(obj,key,value){
			obj[key]=value;
			return obj;
		}

		ObjectTools.setAutoTypeValue=function(obj,key,value){
			if(obj.hasOwnProperty(key)){
				if(ObjectTools.isNumber(obj[key])){
					obj[key]=parseFloat(value);
					}else{
					obj[key]=value;
				}
				}else{
				obj[key]=value;
			}
			return obj;
		}

		ObjectTools.getAutoValue=function(value){
			var tFloat=parseFloat(value);
			if(typeof(value)=="string"){
				if(tFloat+""===StringTool$1.trimSide(value))return tFloat;
			}
			return value;
		}

		ObjectTools.isNumber=function(value){
			return (parseFloat(value)==value);
		}

		ObjectTools.isNaNS=function(value){
			return (value.toString()=="NaN");
		}

		ObjectTools.isNaN=function(value){
			if(typeof(value)=="number")return false;
			if(typeof(value)=="string"){
				if(parseFloat(value).toString()!="NaN"){
					if(parseFloat(value)==value){
						return false;
					}
				}
			}
			return true;
		}

		ObjectTools.getStrTypedValue=function(value){
			if(value=="false"){
				return false;
			}else
			if(value=="true"){
				return true;
			}else
			if(value=="null"){
				return null;
			}else
			if(value=="undefined"){
				return null;
				}else{
				return ObjectTools.getAutoValue(value);
			}
		}

		ObjectTools.createKeyValueDic=function(dataList,keySign){
			var rst;
			rst={};
			var i=0,len=0;
			len=dataList.length;
			var tItem;
			var tKey;
			for(i=0;i<len;i++){
				tItem=dataList[i];
				tKey=tItem[keySign];
				rst[tKey]=tItem;
			}
			return rst;
		}

		ObjectTools.sign="_";
		return ObjectTools;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.debug.tools.ObjTimeCountTool
	var ObjTimeCountTool=(function(){
		function ObjTimeCountTool(){
			this.timeDic={};
			this.resultDic={};
			this.countDic={};
			this.resultCountDic={};
			this.nodeDic={};
			this.resultNodeDic={};
		}

		__class(ObjTimeCountTool,'laya.debug.tools.ObjTimeCountTool');
		var __proto=ObjTimeCountTool.prototype;
		__proto.addTime=function(sprite,time){
			IDTools.idObj(sprite);
			var key=0;
			key=IDTools.getObjID(sprite);
			if (!this.timeDic.hasOwnProperty(key)){
				this.timeDic[key]=0;
			}
			this.timeDic[key]=this.timeDic[key]+time;
			if (!this.countDic.hasOwnProperty(key)){
				this.countDic[key]=0;
			}
			this.countDic[key]=this.countDic[key]+1;
			this.nodeDic[key]=sprite;
		}

		__proto.getTime=function(sprite){
			IDTools.idObj(sprite);
			var key=0;
			key=IDTools.getObjID(sprite);
			if (!this.resultDic[key])return 0;
			return this.resultDic[key];
		}

		__proto.getCount=function(sprite){
			IDTools.idObj(sprite);
			var key=0;
			key=IDTools.getObjID(sprite);
			return this.resultCountDic[key];
		}

		__proto.reset=function(){
			var key;
			for (key in this.timeDic){
				this.timeDic[key]=0;
				this.countDic[key]=0;
			}
			ObjectTools$1.clearObj(this.nodeDic);
		}

		__proto.updates=function(){
			ObjectTools$1.clearObj(this.resultDic);
			ObjectTools$1.insertValue(this.resultDic,this.timeDic);
			ObjectTools$1.clearObj(this.resultCountDic);
			ObjectTools$1.insertValue(this.resultCountDic,this.countDic);
			ObjectTools$1.insertValue(this.resultNodeDic,this.nodeDic);
			this.reset();
		}

		return ObjTimeCountTool;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-12-23 下午12:00:48
	*/
	//class laya.debug.tools.RecInfo
	var RecInfo=(function(){
		function RecInfo(){
			this.oX=0;
			this.oY=0;
			this.hX=1;
			this.hY=0;
			this.vX=0;
			this.vY=1;
		}

		__class(RecInfo,'laya.debug.tools.RecInfo');
		var __proto=RecInfo.prototype;
		__proto.initByPoints=function(oPoint,ePoint,vPoint){
			this.oX=oPoint.x;
			this.oY=oPoint.y;
			this.hX=ePoint.x;
			this.hY=ePoint.y;
			this.vX=vPoint.x;
			this.vY=vPoint.y;
		}

		__getset(0,__proto,'rotation',function(){
			return this.rotationRad/Math.PI*180;
		});

		__getset(0,__proto,'width',function(){
			return Math.sqrt((this.hX-this.oX)*(this.hX-this.oX)+(this.hY-this.oY)*(this.hY-this.oY));
		});

		__getset(0,__proto,'x',function(){
			return this.oX;
		});

		__getset(0,__proto,'rotationRadV',function(){
			var dx=this.vX-this.oX;
			var dy=this.vY-this.oY;
			return Math.atan2(dy,dx);
		});

		__getset(0,__proto,'y',function(){
			return this.oY;
		});

		__getset(0,__proto,'rotationRad',function(){
			var dx=this.hX-this.oX;
			var dy=this.hY-this.oY;
			return Math.atan2(dy,dx);
		});

		__getset(0,__proto,'height',function(){
			return Math.sqrt((this.vX-this.oX)*(this.vX-this.oX)+(this.vY-this.oY)*(this.vY-this.oY));
		});

		__getset(0,__proto,'rotationV',function(){
			return this.rotationRadV/Math.PI*180;
		});

		RecInfo.createByPoints=function(oPoint,ePoint,vPoint){
			var rst;
			rst=new RecInfo();
			rst.initByPoints(oPoint,ePoint,vPoint);
			return rst;
		}

		RecInfo.getGlobalPoints=function(sprite,x,y){
			return sprite.localToGlobal(new Point(x,y));
		}

		RecInfo.getGlobalRecInfo=function(sprite,x0,y0,x1,y1,x2,y2){
			(x0===void 0)&& (x0=0);
			(y0===void 0)&& (y0=0);
			(x1===void 0)&& (x1=1);
			(y1===void 0)&& (y1=0);
			(x2===void 0)&& (x2=0);
			(y2===void 0)&& (y2=1);
			return RecInfo.createByPoints(RecInfo.getGlobalPoints(sprite,x0,y0),RecInfo.getGlobalPoints(sprite,x1,y1),RecInfo.getGlobalPoints(sprite,x2,y2));
		}

		return RecInfo;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.debug.tools.RenderAnalyser
	var RenderAnalyser=(function(){
		function RenderAnalyser(){
			this.timeDic={};
			this.resultDic={};
			this.countDic={};
			this.resultCountDic={};
			this.nodeDic={};
			this.isWorking=false;
			this.working=true;
		}

		__class(RenderAnalyser,'laya.debug.tools.RenderAnalyser');
		var __proto=RenderAnalyser.prototype;
		__proto.render=function(sprite,time){
			this.addTime(sprite,time);
		}

		__proto.addTime=function(sprite,time){
			IDTools.idObj(sprite);
			var key=0;
			key=IDTools.getObjID(sprite);
			if (!this.timeDic.hasOwnProperty(key)){
				this.timeDic[key]=0;
			}
			this.timeDic[key]=this.timeDic[key]+time;
			if (!this.countDic.hasOwnProperty(key)){
				this.countDic[key]=0;
			}
			this.countDic[key]=this.countDic[key]+1;
			this.nodeDic[key]=sprite;
		}

		__proto.getTime=function(sprite){
			IDTools.idObj(sprite);
			var key=0;
			key=IDTools.getObjID(sprite);
			if (!this.resultDic[key])return 0;
			return this.resultDic[key];
		}

		__proto.getCount=function(sprite){
			IDTools.idObj(sprite);
			var key=0;
			key=IDTools.getObjID(sprite);
			return this.resultCountDic[key];
		}

		__proto.reset=function(){
			var key;
			for (key in this.timeDic){
				this.timeDic[key]=0;
				this.countDic[key]=0;
			}
			ObjectTools$1.clearObj(this.nodeDic);
		}

		__proto.updates=function(){
			ObjectTools$1.clearObj(this.resultDic);
			ObjectTools$1.insertValue(this.resultDic,this.timeDic);
			ObjectTools$1.clearObj(this.resultCountDic);
			ObjectTools$1.insertValue(this.resultCountDic,this.countDic);
			this.reset();
		}

		__getset(0,__proto,'working',null,function(v){
			this.isWorking=v;
			if (v){
				Laya.timer.loop(NodeConsts.RenderCostMaxTime,this,this.updates);
				}else{
				Laya.timer.clear(this,this.updates);
			}
		});

		__static(RenderAnalyser,
		['I',function(){return this.I=new RenderAnalyser();}
		]);
		return RenderAnalyser;
	})()


	/**
	*本类用于调整对象的宽高以及坐标
	*@author ww
	*/
	//class laya.debug.tools.resizer.DisResizer
	var DisResizer$1=(function(){
		function DisResizer(){}
		__class(DisResizer,'laya.debug.tools.resizer.DisResizer',null,'DisResizer$1');
		DisResizer.init=function(){
			if (DisResizer._up)return;
			DisResizer._up=new AutoFillRec$1("T");
			DisResizer._up.height=2;
			DisResizer._up.type=0;
			DisResizer._down=new AutoFillRec$1("T");
			DisResizer._down.height=2;
			DisResizer._down.type=0;
			DisResizer._left=new AutoFillRec$1("R");
			DisResizer._left.width=2;
			DisResizer._left.type=1;
			DisResizer._right=new AutoFillRec$1("R");
			DisResizer._right.width=2;
			DisResizer._right.type=1;
			DisResizer._barList=[DisResizer._up,DisResizer._down,DisResizer._left,DisResizer._right];
			DisResizer.addEvent();
		}

		DisResizer.stageDown=function(e){
			var target;
			target=e.target;
			if (DisResizer._tar && DisControlTool.isInTree(DisResizer._tar,target)){
				return;
			}
			DisResizer.clear();
		}

		DisResizer.clear=function(){
			DisResizer._tar=null;
			Laya.stage.off("mouseup",null,DisResizer.stageDown);
			DisControlTool.removeItems(DisResizer._barList);
			DisResizer.clearDragEvents();
		}

		DisResizer.addEvent=function(){
			var i=0,len=0;
			var tBar;
			len=DisResizer._barList.length;
			for (i=0;i < len;i++){
				tBar=DisResizer._barList[i];
				tBar.on("mousedown",null,DisResizer.barDown);
			}
		}

		DisResizer.barDown=function(e){
			DisResizer.clearDragEvents();
			DisResizer.tBar=e.target;
			if (!DisResizer.tBar)return;
			var area;
			area=new Rectangle();
			if (DisResizer.tBar.type==0){
				area.x=DisResizer.tBar.x;
				area.width=0;
				area.y=DisResizer.tBar.y-200;
				area.height=400;
				}else{
				area.x=DisResizer.tBar.x-200;
				area.width=400;
				area.y=0;
				area.height=0;
			};
			var option;
			option={};
			option.area=area;
			DisResizer.tBar.record();
			DisResizer.tBar.startDrag(area);
			DisResizer.tBar.on("dragmove",null,DisResizer.draging);
			DisResizer.tBar.on("dragend",null,DisResizer.dragEnd);
		}

		DisResizer.draging=function(e){
			console.log("draging");
			if (!DisResizer.tBar)return;
			if (!DisResizer._tar)return;
			switch(DisResizer.tBar){
				case DisResizer._left:
					DisResizer._tar.x+=DisResizer.tBar.getDx();
					DisResizer._tar.width-=DisResizer.tBar.getDx();
					DisResizer._up.width-=DisResizer.tBar.getDx();
					DisResizer._down.width-=DisResizer.tBar.getDx();
					DisResizer._right.x-=DisResizer.tBar.getDx();
					DisResizer.tBar.x-=DisResizer.tBar.getDx();
					break ;
				case DisResizer._right:
					DisResizer._tar.width+=DisResizer.tBar.getDx();
					DisResizer._up.width+=DisResizer.tBar.getDx();
					DisResizer._down.width+=DisResizer.tBar.getDx();
					break ;
				case DisResizer._up:
					DisResizer._tar.y+=DisResizer.tBar.getDy();
					DisResizer._tar.height-=DisResizer.tBar.getDy();
					DisResizer._right.height-=DisResizer.tBar.getDy();
					DisResizer._left.height-=DisResizer.tBar.getDy();
					DisResizer._down.y-=DisResizer.tBar.getDy();
					DisResizer.tBar.y-=DisResizer.tBar.getDy();
					break ;
				case DisResizer._down:
					DisResizer._tar.height+=DisResizer.tBar.getDy();
					DisResizer._right.height+=DisResizer.tBar.getDy();
					DisResizer._left.height+=DisResizer.tBar.getDy();
					break ;
				}
			DisResizer.tBar.record();
		}

		DisResizer.dragEnd=function(e){
			console.log("dragEnd");
			DisResizer.clearDragEvents();
			DisResizer.updates();
		}

		DisResizer.clearDragEvents=function(){
			if (!DisResizer.tBar)return;
			DisResizer.tBar.off("dragmove",null,DisResizer.draging);
			DisResizer.tBar.off("dragend",null,DisResizer.dragEnd);
		}

		DisResizer.setUp=function(dis,force){
			(force===void 0)&& (force=false);
			if (force && dis==DisResizer._tar){
				return;
			};
			DisControlTool.removeItems(DisResizer._barList);
			if (DisResizer._tar==dis){
				DisResizer._tar=null;
				DisResizer.clearDragEvents();
				if(!force)
					return;
			}
			DisResizer._tar=dis;
			DisResizer.updates();
			DisControlTool.addItems(DisResizer._barList,dis);
			Laya.stage.off("mouseup",null,DisResizer.stageDown);
			Laya.stage.on("mouseup",null,DisResizer.stageDown);
		}

		DisResizer.updates=function(){
			var dis;
			dis=DisResizer._tar;
			if(!dis)return;
			var bounds;
			bounds=new Rectangle(0,0,dis.width,dis.height);
			DisResizer._up.x=bounds.x;
			DisResizer._up.y=bounds.y;
			DisResizer._up.width=bounds.width;
			DisResizer._down.x=bounds.x;
			DisResizer._down.y=bounds.y+bounds.height-2;
			DisResizer._down.width=bounds.width;
			DisResizer._left.x=bounds.x;
			DisResizer._left.y=bounds.y;
			DisResizer._left.height=bounds.height;
			DisResizer._right.x=bounds.x+bounds.width-2;
			DisResizer._right.y=bounds.y;
			DisResizer._right.height=bounds.height;
		}

		DisResizer.Side=2;
		DisResizer.Vertical=1;
		DisResizer.Horizon=0;
		DisResizer._up=null
		DisResizer._down=null
		DisResizer._left=null
		DisResizer._right=null
		DisResizer._barList=null
		DisResizer._tar=null
		DisResizer.barWidth=2;
		DisResizer.useGetBounds=false;
		DisResizer.tBar=null
		return DisResizer;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.debug.tools.resizer.SimpleResizer
	var SimpleResizer=(function(){
		function SimpleResizer(){}
		__class(SimpleResizer,'laya.debug.tools.resizer.SimpleResizer');
		SimpleResizer.setResizeAble=function(clickItem,tar,minWidth,minHeight){
			(minWidth===void 0)&& (minWidth=150);
			(minHeight===void 0)&& (minHeight=150);
			clickItem.on("mousedown",null,SimpleResizer.onMouseDown,[tar,minWidth,minHeight]);
		}

		SimpleResizer.onMouseDown=function(tar,minWidth,minHeight,e){
			SimpleResizer.clearEvents();
			if (!tar)return;
			SimpleResizer.preMousePoint.setTo(Laya.stage.mouseX,Laya.stage.mouseY);
			SimpleResizer.preTarSize.setTo(tar.width,tar.height);
			SimpleResizer.preScale.setTo(1,1);
			var rTar;
			rTar=tar;
			while (rTar&&rTar!=Laya.stage){
				SimpleResizer.preScale.x *=rTar.scaleX;
				SimpleResizer.preScale.y *=rTar.scaleY;
				rTar=rTar.parent;
			}
			Laya.stage.on("mouseup",null,SimpleResizer.onMouseMoveEnd);
			Laya.timer.loop(100,null,SimpleResizer.onMouseMoving,[tar,minWidth,minHeight]);
		}

		SimpleResizer.onMouseMoving=function(tar,minWidth,minHeight,e){
			var tWidth=(Laya.stage.mouseX-SimpleResizer.preMousePoint.x)/ SimpleResizer.preScale.x+SimpleResizer.preTarSize.x;
			var tHeight=(Laya.stage.mouseY-SimpleResizer.preMousePoint.y)/SimpleResizer.preScale.y+SimpleResizer.preTarSize.y;
			tar.width=tWidth > minWidth?tWidth:minWidth;
			tar.height=tHeight>minHeight?tHeight:minHeight;
		}

		SimpleResizer.onMouseMoveEnd=function(e){
			SimpleResizer.clearEvents();
		}

		SimpleResizer.clearEvents=function(){
			Laya.timer.clear(null,SimpleResizer.onMouseMoving);
			Laya.stage.off("mouseup",null,SimpleResizer.onMouseMoveEnd);
		}

		__static(SimpleResizer,
		['preMousePoint',function(){return this.preMousePoint=new Point();},'preTarSize',function(){return this.preTarSize=new Point();},'preScale',function(){return this.preScale=new Point();}
		]);
		return SimpleResizer;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.debug.tools.ResTools
	var ResTools=(function(){
		function ResTools(){}
		__class(ResTools,'laya.debug.tools.ResTools');
		ResTools.getCachedResList=function(){
			if (Render.isWebGL){
				return ResTools.getWebGlResList();
				}else{
				return ResTools.getCanvasResList();
			}
		}

		ResTools.getWebGlResList=function(){
			var rst;
			rst=[];
			var tResource;
			var _resources;
			_resources=ResourceManager.currentResourceManager["_resources"];
			for(var i=0;i <_resources.length;i++){
				tResource=_resources[i];
				if(ClassTool.getClassName(tResource)=="WebGLImage"){
					var url=tResource["src"];
					if(url&&url.indexOf("data:image/png;base64")<0)
						rst.push(url);
				}
			}
			return rst;
		}

		ResTools.getCanvasResList=function(){
			var picDic;
			picDic={};
			var dataO;
			dataO=Loader.loadedMap;
			ResTools.collectPics(dataO,picDic);
			return ResTools.getArrFromDic(picDic);
		}

		ResTools.getArrFromDic=function(dic){
			var key;
			var rst;
			rst=[];
			for (key in dic){
				rst.push(key);
			}
			return rst;
		}

		ResTools.collectPics=function(dataO,picDic){
			if (!dataO)return;
			var key;
			var tTexture;
			for (key in dataO){
				tTexture=dataO[key];
				if (tTexture){
					if (tTexture.bitmap&&tTexture.bitmap.src){
						var url=tTexture.bitmap.src;
						if(url.indexOf("data:image/png;base64")<0)
							picDic[tTexture.bitmap.src]=true;
					}
				}
			}
		}

		return ResTools;
	})()


	/**
	*类实例创建分析工具
	*@author ww
	*@version 1.0
	*
	*@created 2015-9-25 下午3:31:46
	*/
	//class laya.debug.tools.RunProfile
	var RunProfile=(function(){
		function RunProfile(){}
		__class(RunProfile,'laya.debug.tools.RunProfile');
		RunProfile.run=function(funName,callLen){
			(callLen===void 0)&& (callLen=3);
			var tCount;
			if(!RunProfile.infoDic.hasOwnProperty(funName)){
				RunProfile.infoDic[funName]=new CountTool();
			}
			tCount=RunProfile.infoDic[funName];
			var msg;
			msg=TraceTool.getCallLoc(callLen)+"\n"+TraceTool.getCallStack(1,callLen-3);
			tCount.add(msg);
			if(RunProfile._runShowDic[funName]){
				console.log("Create:"+funName);
				console.log(msg);
			}
		}

		RunProfile.showClassCreate=function(funName){
			RunProfile._runShowDic[funName]=true;
		}

		RunProfile.hideClassCreate=function(funName){
			RunProfile._runShowDic[funName]=false;
		}

		RunProfile.getRunInfo=function(funName){
			var rst;
			rst=RunProfile.infoDic[funName];
			if(rst){
			}
			return RunProfile.infoDic[funName];
		}

		RunProfile.runTest=function(fun,count,sign){
			(sign===void 0)&& (sign="runTest");
			DTrace.timeStart(sign);
			var i=0;
			for(i=0;i<count;i++){
				fun();
			}
			DTrace.timeEnd(sign);
		}

		RunProfile.runTest2=function(fun,count,sign){
			(sign===void 0)&& (sign="runTest");
			var preTime=NaN;
			preTime=Browser.now();
			var i=0;
			for(i=0;i<count;i++){
				fun();
			}
			return Browser.now()-preTime;
		}

		RunProfile.infoDic={};
		RunProfile._runShowDic={};
		return RunProfile;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-6-24 下午6:07:30
	*/
	//class laya.debug.tools.SingleTool
	var SingleTool=(function(){
		function SingleTool(){
			this._objDic={};
		}

		__class(SingleTool,'laya.debug.tools.SingleTool');
		var __proto=SingleTool.prototype;
		__proto.getArr=function(sign){
			var dic;
			dic=this.getTypeDic("Array");
			if(!dic[sign])dic[sign]=[];
			return dic[sign];
		}

		__proto.getObject=function(sign){
			var dic;
			dic=this.getTypeDic("Object");
			if(!dic[sign])dic[sign]={};
			return dic[sign];
		}

		__proto.getByClass=function(sign,clzSign,clz){
			var dic;
			dic=this.getTypeDic(clzSign);
			if(!dic[sign])dic[sign]=new clz();
			return dic[sign];
		}

		__proto.getTypeDic=function(type){
			if(!this._objDic[type])this._objDic[type]={};
			return this._objDic[type];
		}

		__static(SingleTool,
		['I',function(){return this.I=new SingleTool();}
		]);
		return SingleTool;
	})()


	/**
	*一些字符串操作函数
	*@author ww
	*
	*/
	//class laya.debug.tools.StringTool
	var StringTool$1=(function(){
		function StringTool(){}
		__class(StringTool,'laya.debug.tools.StringTool',null,'StringTool$1');
		StringTool.toUpCase=function(str){
			return str.toUpperCase();
		}

		StringTool.toLowCase=function(str){
			return str.toLowerCase();
		}

		StringTool.toUpHead=function(str){
			var rst;
			if(str.length<=1)return str.toUpperCase();
			rst=str.charAt(0).toUpperCase()+str.substr(1);
			return rst;
		}

		StringTool.toLowHead=function(str){
			var rst;
			if(str.length<=1)return str.toLowerCase();
			rst=str.charAt(0).toLowerCase()+str.substr(1);
			return rst;
		}

		StringTool.packageToFolderPath=function(packageName){
			var rst;
			rst=packageName.replace(".","/");
			return rst;
		}

		StringTool.insert=function(str,iStr,index){
			return str.substring(0,index)+iStr+str.substr(index);
		}

		StringTool.insertAfter=function(str,iStr,tarStr,isLast){
			(isLast===void 0)&& (isLast=false);
			var i=0;
			if(isLast){
				i=str.lastIndexOf(tarStr);
				}else{
				i=str.indexOf(tarStr);
			}
			if(i>=0){
				return StringTool.insert(str,iStr,i+tarStr.length);
			}
			return str;
		}

		StringTool.insertBefore=function(str,iStr,tarStr,isLast){
			(isLast===void 0)&& (isLast=false);
			var i=0;
			if(isLast){
				i=str.lastIndexOf(tarStr);
				}else{
				i=str.indexOf(tarStr);
			}
			if(i>=0){
				return StringTool.insert(str,iStr,i);
			}
			return str;
		}

		StringTool.insertParamToFun=function(funStr,params){
			var oldParam;
			oldParam=StringTool.getParamArr(funStr);
			var inserStr;
			inserStr=params.join(",");
			if(oldParam.length>0){
				inserStr=","+inserStr;
			}
			return StringTool.insertBefore(funStr,inserStr,")",true);
		}

		StringTool.trim=function(str,vList){
			if(!vList){
				vList=[" ","\r","\n","\t",String.fromCharCode(65279)];
			};
			var rst;
			var i=0;
			var len=0;
			rst=str;
			len=vList.length;
			for(i=0;i<len;i++){
				rst=StringTool.getReplace(rst,vList[i],"");
			}
			return rst;
		}

		StringTool.isEmpty=function(str){
			if(str.length<1)return true;
			return StringTool.emptyStrDic.hasOwnProperty(str);
		}

		StringTool.trimLeft=function(str){
			var i=0;
			i=0;
			var len=0;
			len=str.length;
			while(StringTool.isEmpty(str.charAt(i))&&i<len){
				i++;
			}
			if(i<len){
				return str.substr(i);
			}
			return "";
		}

		StringTool.trimRight=function(str){
			var i=0;
			i=str.length-1;
			while(StringTool.isEmpty(str.charAt(i))&&i>=0){
				i--;
			};
			var rst;
			rst=str.substring(0,i)
			if(i>=0){
				return str.substring(0,i+1);
			}
			return "";
		}

		StringTool.trimSide=function(str){
			var rst;
			rst=StringTool.trimLeft(str);
			rst=StringTool.trimRight(rst);
			return rst;
		}

		StringTool.isOkFileName=function(fileName){
			if(laya.debug.tools.StringTool.trimSide(fileName)=="")return false;
			var i=0,len=0;
			len=fileName.length;
			for(i=0;i<len;i++){
				if(StringTool.specialChars[fileName.charAt(i)])return false;
			}
			return true;
		}

		StringTool.trimButEmpty=function(str){
			return StringTool.trim(str,["\r","\n","\t"]);
		}

		StringTool.removeEmptyStr=function(strArr){
			var i=0;
			i=strArr.length-1;
			var str;
			for(i=i;i>=0;i--){
				str=strArr[i];
				str=laya.debug.tools.StringTool.trimSide(str);
				if(StringTool.isEmpty(str)){
					strArr.splice(i,1);
					}else{
					strArr[i]=str;
				}
			}
			return strArr;
		}

		StringTool.ifNoAddToTail=function(str,sign){
			if(str.indexOf(sign)>=0){
				return str;
			}
			return str+sign;
		}

		StringTool.trimEmptyLine=function(str){
			var i=0;
			var len=0;
			var tLines;
			var tLine;
			tLines=str.split("\n");
			for(i=tLines.length-1;i>=0;i--){
				tLine=tLines[i];
				if(StringTool.isEmptyLine(tLine)){
					tLines.splice(i,1);
				}
			}
			return tLines.join("\n");
		}

		StringTool.isEmptyLine=function(str){
			str=laya.debug.tools.StringTool.trim(str);
			if(str=="")return true;
			return false;
		}

		StringTool.removeCommentLine=function(lines){
			var rst;
			rst=[];
			var i=0;
			var tLine;
			var adptLine;
			i=0;
			var len=0;
			var index=0;
			len=lines.length;
			while(i<len){
				adptLine=tLine=lines[i];
				index=tLine.indexOf("/**");
				if(index>=0){
					adptLine=tLine.substring(0,index-1);
					StringTool.addIfNotEmpty(rst,adptLine);
					while(i<len){
						tLine=lines[i];
						index=tLine.indexOf("*/");
						if(index>=0){
							adptLine=tLine.substring(index+2);
							StringTool.addIfNotEmpty(rst,adptLine);
							break ;
						}
						i++;
					}
					}else if(tLine.indexOf("//")>=0){
					if(laya.debug.tools.StringTool.trim(tLine).indexOf("//")==0){
						}else{
						StringTool.addIfNotEmpty(rst,adptLine);
					}
					}else{
					StringTool.addIfNotEmpty(rst,adptLine);
				}
				i++;
			}
			return rst;
		}

		StringTool.addIfNotEmpty=function(arr,str){
			if(!str)return;
			var tStr;
			tStr=StringTool.trim(str);
			if(tStr!=""){
				arr.push(str);
			}
		}

		StringTool.trimExt=function(str,vars){
			var rst;
			rst=StringTool.trim(str);
			var i=0;
			var len=0;
			len=vars.length;
			for(i=0;i<len;i++){
				rst=StringTool.getReplace(rst,vars[i],"");
			}
			return rst;
		}

		StringTool.getBetween=function(str,left,right,ifMax){
			(ifMax===void 0)&& (ifMax=false);
			if(!str)return "";
			if(!left)return "";
			if(!right)return "";
			var lId=0;
			var rId=0;
			lId=str.indexOf(left);
			if(lId<0)return"";
			if(ifMax){
				rId=str.lastIndexOf(right);
				if(rId<lId)return "";
				}else{
				rId=str.indexOf(right,lId+1);
			}
			if(rId<0)return "";
			return str.substring(lId+left.length,rId);
		}

		StringTool.getSplitLine=function(line,split){
			(split===void 0)&& (split=" ");
			return line.split(split);
		}

		StringTool.getLeft=function(str,sign){
			var i=0;
			i=str.indexOf(sign);
			return str.substr(0,i);
		}

		StringTool.getRight=function(str,sign){
			var i=0;
			i=str.indexOf(sign);
			return str.substr(i+1);
		}

		StringTool.delelteItem=function(arr){
			while (arr.length>0){
				if(arr[0]==""){
					arr.shift();
					}else{
					break ;
				}
			}
		}

		StringTool.getWords=function(line){
			var rst=StringTool.getSplitLine(line);
			StringTool.delelteItem(rst);
			return rst;
		}

		StringTool.getLinesI=function(startLine,endLine,lines){
			var i=0;
			var rst=[];
			for(i=startLine;i<=endLine;i++){
				rst.push(lines[i]);
			}
			return rst;
		}

		StringTool.structfy=function(str,inWidth,removeEmpty){
			(inWidth===void 0)&& (inWidth=4);
			(removeEmpty===void 0)&& (removeEmpty=true);
			if(removeEmpty){
				str=laya.debug.tools.StringTool.trimEmptyLine(str);
			};
			var lines;
			var tIn=0;
			tIn=0;
			var tInStr;
			tInStr=StringTool.getEmptyStr(0);
			lines=str.split("\n");
			var i=0;
			var len=0;
			var tLineStr;
			len=lines.length;
			for(i=0;i<len;i++){
				tLineStr=lines[i];
				tLineStr=laya.debug.tools.StringTool.trimLeft(tLineStr);
				tLineStr=laya.debug.tools.StringTool.trimRight(tLineStr);
				tIn+=StringTool.getPariCount(tLineStr);
				if(tLineStr.indexOf("}")>=0){
					tInStr=StringTool.getEmptyStr(tIn*inWidth);
				}
				tLineStr=tInStr+tLineStr;
				lines[i]=tLineStr;
				tInStr=StringTool.getEmptyStr(tIn*inWidth);
			}
			return lines.join("\n");
		}

		StringTool.getEmptyStr=function(width){
			if(!StringTool.emptyDic.hasOwnProperty(width)){
				var i=0;
				var len=0;
				len=width;
				var rst;
				rst="";
				for(i=0;i<len;i++){
					rst+=" ";
				}
				StringTool.emptyDic[width]=rst;
			}
			return StringTool.emptyDic[width];
		}

		StringTool.getPariCount=function(str,inChar,outChar){
			(inChar===void 0)&& (inChar="{");
			(outChar===void 0)&& (outChar="}");
			var varDic;
			varDic={};
			varDic[inChar]=1;
			varDic[outChar]=-1;
			var i=0;
			var len=0;
			var tChar;
			len=str.length;
			var rst=0;
			rst=0;
			for(i=0;i<len;i++){
				tChar=str.charAt(i);
				if(varDic.hasOwnProperty(tChar)){
					rst+=varDic[tChar];
				}
			}
			return rst;
		}

		StringTool.readInt=function(str,startI){
			(startI===void 0)&& (startI=0);
			var rst=NaN;
			rst=0;
			var tNum=0;
			var tC;
			var i=0;
			var isBegin=false;
			isBegin=false;
			var len=0;
			len=str.length;
			for(i=startI;i<len;i++){
				tC=str.charAt(i);
				if(Number(tC)>0||tC=="0"){
					rst=10*rst+Number(tC);
					if(rst>0)isBegin=true;
					}else{
					if(isBegin)return rst;
				}
			}
			return rst;
		}

		StringTool.getReplace=function(str,oStr,nStr){
			if(!str)return "";
			var rst;
			rst=str.replace(new RegExp(oStr,"g"),nStr);
			return rst;
		}

		StringTool.getWordCount=function(str,findWord){
			var rg=new RegExp(findWord,"g")
			return str.match(rg).length;
		}

		StringTool.getResolvePath=function(path,basePath){
			if(StringTool.isAbsPath(path)){
				return path;
			};
			var tSign;
			tSign="\\";
			if(basePath.indexOf("/")>=0){
				tSign="/";
			}
			if(basePath.charAt(basePath.length-1)==tSign){
				basePath=basePath.substr(0,basePath.length-1);
			};
			var parentSign;
			parentSign=".."+tSign;
			var tISign;
			tISign="."+tSign;
			var pCount=0;
			pCount=StringTool.getWordCount(path,parentSign);
			path=laya.debug.tools.StringTool.getReplace(path,parentSign,"");
			path=laya.debug.tools.StringTool.getReplace(path,tISign,"");
			var i=0;
			var len=0;
			len=pCount;
			var iPos=0;
			for(i=0;i<len;i++){
				basePath=StringTool.removeLastSign(path,tSign);
			}
			return basePath+tSign+path;
		}

		StringTool.isAbsPath=function(path){
			if(path.indexOf(":")>=0)return true;
			return false;
		}

		StringTool.removeLastSign=function(str,sign){
			var iPos=0;
			iPos=str.lastIndexOf(sign);
			str=str.substring(0,iPos);
			return str;
		}

		StringTool.getParamArr=function(str){
			var paramStr;
			paramStr=laya.debug.tools.StringTool.getBetween(str,"(",")",true);
			if(StringTool.trim(paramStr).length<1)return [];
			return paramStr.split(",");
		}

		StringTool.copyStr=function(str){
			return str.substring();
		}

		StringTool.ArrayToString=function(arr){
			var rst;
			rst="[{items}]".replace(new RegExp("\\{items\\}","g"),StringTool.getArrayItems(arr));
			return rst;
		}

		StringTool.getArrayItems=function(arr){
			var rst;
			if(arr.length<1)return "";
			rst=StringTool.parseItem(arr[0]);
			var i=0;
			var len=0;
			len=arr.length;
			for(i=1;i<len;i++){
				rst+=","+StringTool.parseItem(arr[i]);
			}
			return rst;
		}

		StringTool.parseItem=function(item){
			var rst;
			rst="\""+item+"\"";
			return "";
		}

		StringTool.initAlphaSign=function(){
			if (StringTool.alphaSigns)return;
			StringTool.alphaSigns={};
			StringTool.addSign("a","z",StringTool.alphaSigns);
			StringTool.addSign("A","Z",StringTool.alphaSigns);
			StringTool.addSign("0","9",StringTool.alphaSigns);
		}

		StringTool.addSign=function(ss,e,tar){
			var i=0;
			var len=0;
			var s=0;
			s=ss.charCodeAt(0);
			len=e.charCodeAt(0);
			for(i=s;i<=len;i++){
				tar[String.fromCharCode(i)]=true;
				console.log("add :"+String.fromCharCode(i));
			}
		}

		StringTool.isPureAlphaNum=function(str){
			StringTool.initAlphaSign();
			if (!str)return true;
			var i=0,len=0;
			len=str.length;
			for (i=0;i < len;i++){
				if (!StringTool.alphaSigns[str.charAt(i)])return false;
			}
			return true;
		}

		StringTool.emptyDic={};
		StringTool.alphaSigns=null;
		__static(StringTool,
		['emptyStrDic',function(){return this.emptyStrDic={
				" ":true,
				"\r":true,
				"\n":true,
				"\t":true
		};},'specialChars',function(){return this.specialChars={"*":true,"&":true,"%":true,"#":true,"?":true};}

		]);
		return StringTool;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.debug.tools.TimeTool
	var TimeTool=(function(){
		function TimeTool(){}
		__class(TimeTool,'laya.debug.tools.TimeTool');
		TimeTool.getTime=function(sign,update){
			(update===void 0)&& (update=true);
			if (!TimeTool.timeDic[sign]){
				TimeTool.timeDic[sign]=0;
			};
			var tTime=NaN;
			tTime=Browser.now();
			var rst=NaN;
			rst=tTime-TimeTool.timeDic[sign];
			TimeTool.timeDic[sign]=tTime;
			return rst;
		}

		TimeTool.runAllCallLater=function(){
			if(TimeTool._deep>0)debugger;
			TimeTool._deep++;
			var timer;
			timer=Laya.timer;
			var laters=timer["_laters"];
			for (var i=0,n=laters.length-1;i <=n;i++){
				var handler=laters[i];
				if(handler){
					handler.method!==null && handler.run(false);
					timer["_recoverHandler"](handler);
					}else{
					debugger;
				}
				i===n && (n=laters.length-1);
			}
			laters.length=0;
			TimeTool._deep--;
		}

		TimeTool.timeDic={};
		TimeTool._deep=0;
		return TimeTool;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-9-25 上午10:48:54
	*/
	//class laya.debug.tools.TraceTool
	var TraceTool=(function(){
		function TraceTool(){}
		__class(TraceTool,'laya.debug.tools.TraceTool');
		TraceTool.closeAllLog=function(){
			var logFun;
			logFun=TraceTool.emptyLog;
			Browser.window.console.log=logFun;
		}

		TraceTool.emptyLog=function(){}
		TraceTool.traceObj=function(obj){
			TraceTool.tempArr.length=0;
			var key;
			for(key in obj){
				TraceTool.tempArr.push(key+":"+obj[key]);
			};
			var rst;
			rst=TraceTool.tempArr.join("\n");
			console.log(rst);
			return rst;
		}

		TraceTool.traceObjR=function(obj){
			TraceTool.tempArr.length=0;
			var key;
			for(key in obj){
				TraceTool.tempArr.push(obj[key]+":"+key);
			};
			var rst;
			rst=TraceTool.tempArr.join("\n");
			console.log(rst);
			return rst;
		}

		TraceTool.traceSize=function(tar){
			DebugTool.dTrace("Size: x:"+tar.x+" y:"+tar.y+" w:"+tar.width+" h:"+tar.height+" scaleX:"+tar.scaleX+" scaleY:"+tar.scaleY);
		}

		TraceTool.traceSplit=function(msg){
			console.log("---------------------"+msg+"---------------------------");
		}

		TraceTool.group=function(gName){
			console.group(gName);;
		}

		TraceTool.groupEnd=function(){
			console.groupEnd();;
		}

		TraceTool.getCallStack=function(life,s){
			(life===void 0)&& (life=1);
			(s===void 0)&& (s=1);
			var caller;
			caller=TraceTool.getCallStack;
			caller=caller.caller.caller;
			var msg;
			msg="";
			while(caller&&life>0){
				if(s<=0){
					msg+=caller+"<-";
					life--;
					}else{
				}
				caller=caller.caller;
				s--;
			}
			return msg;
		}

		TraceTool.getCallLoc=function(index){
			(index===void 0)&& (index=2);
			var loc;
			try {
				TraceTool.Erroer.i++;
				}catch (e){
				var arr;
				arr=e.stack.replace(/Error\n/).split(/\n/);
				if (arr[index]){
					loc=arr[index].replace(/^\s+|\s+$/,"");
					}else{
					loc="unknow";
				}
			}
			return loc;
		}

		TraceTool.traceCallStack=function(){
			var loc;
			try {
				TraceTool.Erroer.i++;
				}catch (e){
				loc=e.stack;
			}
			console.log(loc);
			return loc;
		}

		TraceTool.getPlaceHolder=function(len){
			if(!TraceTool.holderDic.hasOwnProperty(len)){
				var rst;
				rst="";
				var i=0;
				for(i=0;i<len;i++){
					rst+="-";
				}
				TraceTool.holderDic[len]=rst;
			}
			return TraceTool.holderDic[len];
		}

		TraceTool.traceTree=function(tar,depth,isFirst){
			(depth===void 0)&& (depth=0);
			(isFirst===void 0)&& (isFirst=true);
			if(isFirst){
				console.log("traceTree");
			}
			if(!tar)return;
			var i=0;
			var len=0;
			if(tar.numChildren<1){
				console.log(tar);
				return;
			}
			TraceTool.group(tar);
			len=tar.numChildren;
			depth++;
			for(i=0;i<len;i++){
				TraceTool.traceTree(tar.getChildAt(i),depth,false);
			}
			TraceTool.groupEnd();
		}

		TraceTool.getClassName=function(tar){
			return tar["constructor"].name;
		}

		TraceTool.traceSpriteInfo=function(tar,showBounds,showSize,showTree){
			(showBounds===void 0)&& (showBounds=true);
			(showSize===void 0)&& (showSize=true);
			(showTree===void 0)&& (showTree=true);
			if(!((tar instanceof laya.display.Sprite ))){
				console.log("not Sprite");
				return;
			}
			if(!tar){
				console.log("null Sprite");
				return;
			}
			TraceTool.traceSplit("traceSpriteInfo");
			DebugTool.dTrace(laya.debug.tools.TraceTool.getClassName(tar)+":"+tar.name);
			if(showTree){
				TraceTool.traceTree(tar);
				}else{
				console.log(tar);
			}
			if(showSize){
				TraceTool.traceSize(tar);
			}
			if(showBounds){
				console.log("bounds:"+tar.getBounds());
			}
		}

		TraceTool.tempArr=[];
		TraceTool.Erroer=null;
		TraceTool.holderDic={};
		return TraceTool;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-12-30 下午5:12:53
	*/
	//class laya.debug.tools.ValueChanger
	var ValueChanger=(function(){
		function ValueChanger(){
			this.target=null;
			this.key=null;
			this._tValue=NaN;
			this.preValue=0;
		}

		__class(ValueChanger,'laya.debug.tools.ValueChanger');
		var __proto=ValueChanger.prototype;
		__proto.record=function(){
			this.preValue=this.value;
		}

		__proto.showValueByAdd=function(addValue){
			this.value=this.preValue+addValue;
		}

		__proto.showValueByScale=function(scale){
			this.value=this.preValue *scale;
		}

		__proto.recover=function(){
			this.value=this.preValue;
		}

		__proto.dispose=function(){
			this.target=null;
		}

		__getset(0,__proto,'value',function(){
			if(this.target){
				this._tValue=this.target[this.key];
			}
			return this._tValue;
			},function(nValue){
			this._tValue=nValue;
			if(this.target){
				this.target[this.key]=nValue;
			}
		});

		__getset(0,__proto,'dValue',function(){
			return this.value-this.preValue;
		});

		__getset(0,__proto,'scaleValue',function(){
			return this.value/this.preValue;
		});

		ValueChanger.create=function(target,key){
			var rst;
			rst=new ValueChanger();
			rst.target=target;
			rst.key=key;
			return rst;
		}

		return ValueChanger;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.debug.tools.VisibleAnalyser
	var VisibleAnalyser=(function(){
		function VisibleAnalyser(){}
		__class(VisibleAnalyser,'laya.debug.tools.VisibleAnalyser');
		VisibleAnalyser.analyseTarget=function(node){
			var isInstage=false;
			isInstage=node.displayedInStage;
			var gRec;
			gRec=NodeUtils.getGRec(node);
			var stageRec=new Rectangle();
			stageRec.setTo(0,0,Laya.stage.width,Laya.stage.height);
			var isInVisibleRec=false;
			var visibleRec;
			visibleRec=stageRec.intersection(gRec);
			if (visibleRec.width > 0 && visibleRec.height > 0){
				isInVisibleRec=true;
			}
			else{
				isInVisibleRec=false;
			};
			var gAlpha=NaN;
			gAlpha=NodeUtils.getGAlpha(node);
			var gVisible=false;
			gVisible=NodeUtils.getGVisible(node);
			var msg;
			msg="";
			msg+="isInstage:"+isInstage+"\n";
			msg+="isInVisibleRec:"+isInVisibleRec+"\n";
			msg+="gVisible:"+gVisible+"\n";
			msg+="gAlpha:"+gAlpha+"\n";
			if (isInstage && isInVisibleRec && gVisible && gAlpha > 0){
				if (Render.isWebGL){
					VisibleAnalyser.anlyseRecVisible(node);
					}else{
					SpriteRenderForVisibleAnalyse.I.analyseNode(node);
				}
				msg+="coverRate:"+VisibleAnalyser.coverRate+"\n";
				if (VisibleAnalyser._coverList.length > 0){
					Laya.timer.once(1000,null,VisibleAnalyser.showListLater);
				}
			}
			console.log(msg);
			OutPutView.I.showTxt(msg);
		}

		VisibleAnalyser.showListLater=function(){
			NodeListPanelView.I.showList(VisibleAnalyser._coverList);
		}

		VisibleAnalyser.isCoverByBrother=function(node){
			var parent=node.parent;
			if (!parent)
				return;
			var _childs;
			_childs=parent._childs;
			var index=0;
			index=_childs.indexOf(node);
			if (index < 0)
				return;
			var i=0,len=0;
			var canvas;
			var rec;
			rec=parent.getSelfBounds();
			if (rec.width <=0 || rec.height <=0)
				return;
		}

		VisibleAnalyser.anlyseRecVisible=function(node){
			VisibleAnalyser.isNodeWalked=false;
			VisibleAnalyser._analyseTarget=node;
			if (!VisibleAnalyser.mainCanvas)
				VisibleAnalyser.mainCanvas=CanvasTools.createCanvas(Laya.stage.width,Laya.stage.height);
			CanvasTools.clearCanvas(VisibleAnalyser.mainCanvas);
			VisibleAnalyser.tColor=1;
			VisibleAnalyser.resetCoverList();
			WalkTools.walkTargetEX(Laya.stage,VisibleAnalyser.recVisibleWalker,null,VisibleAnalyser.filterFun);
			if (!VisibleAnalyser.isTarRecOK){
				VisibleAnalyser.coverRate=0;
			}
			else{
				VisibleAnalyser.coverRate=CanvasTools.getDifferRate(VisibleAnalyser.preImageData,VisibleAnalyser.tarImageData);
			}
			console.log("coverRate:",VisibleAnalyser.coverRate);
		}

		VisibleAnalyser.getRecArea=function(rec){
			return rec.width *rec.height;
		}

		VisibleAnalyser.addCoverNode=function(node,coverRate){
			var data;
			data={};
			data.path=node;
			data.label=ClassTool.getNodeClassAndName(node)+":"+coverRate;
			data.coverRate=coverRate;
			VisibleAnalyser._coverList.push(data);
			console.log("coverByNode:",node,coverRate);
		}

		VisibleAnalyser.resetCoverList=function(){
			VisibleAnalyser._coverList.length=0;
		}

		VisibleAnalyser.recVisibleWalker=function(node){
			if (node==VisibleAnalyser._analyseTarget){
				VisibleAnalyser.isNodeWalked=true;
				VisibleAnalyser.tarRec.copyFrom(NodeUtils.getGRec(node));
				console.log("tarRec:",VisibleAnalyser.tarRec.toString());
				if (VisibleAnalyser.tarRec.width > 0 && VisibleAnalyser.tarRec.height > 0){
					VisibleAnalyser.isTarRecOK=true;
					VisibleAnalyser.tColor++;
					CanvasTools.fillCanvasRec(VisibleAnalyser.mainCanvas,VisibleAnalyser.tarRec,ColorTool.toHexColor(VisibleAnalyser.tColor));
					VisibleAnalyser.preImageData=CanvasTools.getImageDataFromCanvasByRec(VisibleAnalyser.mainCanvas,VisibleAnalyser.tarRec);
					VisibleAnalyser.tarImageData=CanvasTools.getImageDataFromCanvasByRec(VisibleAnalyser.mainCanvas,VisibleAnalyser.tarRec);
				}
				else{
					console.log("tarRec Not OK:",VisibleAnalyser.tarRec);
				}
			}
			else{
				if (VisibleAnalyser.isTarRecOK){
					var tRec;
					tRec=NodeUtils.getGRec(node);
					VisibleAnalyser.interRec=VisibleAnalyser.tarRec.intersection(tRec,VisibleAnalyser.interRec);
					if (VisibleAnalyser.interRec && VisibleAnalyser.interRec.width > 0 && VisibleAnalyser.interRec.height > 0){
						VisibleAnalyser.tColor++;
						CanvasTools.fillCanvasRec(VisibleAnalyser.mainCanvas,tRec,ColorTool.toHexColor(VisibleAnalyser.tColor));
						VisibleAnalyser.tImageData=CanvasTools.getImageDataFromCanvasByRec(VisibleAnalyser.mainCanvas,VisibleAnalyser.tarRec);
						var dRate=NaN;
						dRate=CanvasTools.getDifferRate(VisibleAnalyser.preImageData,VisibleAnalyser.tImageData);
						VisibleAnalyser.preImageData=VisibleAnalyser.tImageData;
						VisibleAnalyser.addCoverNode(node,dRate);
					}
				}
			}
		}

		VisibleAnalyser.filterFun=function(node){
			if (node.visible==false)
				return false;
			if (node.alpha < 0)
				return false;
			if (DebugInfoLayer.I.isDebugItem(node))return false;
			return true;
		}

		VisibleAnalyser.isNodeWalked=false;
		VisibleAnalyser._analyseTarget=null
		VisibleAnalyser.isTarRecOK=false;
		VisibleAnalyser.mainCanvas=null
		VisibleAnalyser.preImageData=null
		VisibleAnalyser.tImageData=null
		VisibleAnalyser.tarImageData=null
		VisibleAnalyser.coverRate=NaN
		VisibleAnalyser.tColor=0;
		VisibleAnalyser._coverList=[];
		__static(VisibleAnalyser,
		['tarRec',function(){return this.tarRec=new Rectangle();},'interRec',function(){return this.interRec=new Rectangle();}
		]);
		return VisibleAnalyser;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-9-24 下午6:15:01
	*/
	//class laya.debug.tools.WalkTools
	var WalkTools=(function(){
		function WalkTools(){}
		__class(WalkTools,'laya.debug.tools.WalkTools');
		WalkTools.walkTarget=function(target,fun,_this){
			fun.apply(_this,[target]);
			var i=0;
			var len=0;
			var tChild;
			len=target.numChildren;
			for(i=0;i<len;i++){
				tChild=target.getChildAt(i);
				WalkTools.walkTarget(tChild,fun,tChild);
			}
		}

		WalkTools.walkTargetEX=function(target,fun,_this,filterFun){
			if (filterFun !=null && !filterFun(target))return;
			fun.apply(_this,[target]);
			var i=0;
			var len=0;
			var tChild;
			var childs;
			childs=target._childs;
			len=childs.length;
			for(i=0;i<len;i++){
				tChild=childs[i];
				WalkTools.walkTarget(tChild,fun,tChild);
			}
		}

		WalkTools.walkChildren=function(target,fun,_this){
			if(!target||target.numChildren<1)return;
			WalkTools.walkArr(DisControlTool.getAllChild(target),fun,_this);
		}

		WalkTools.walkArr=function(arr,fun,_this){
			if(!arr)return;
			var i=0;
			var len=0;
			len=arr.length;
			for(i=0;i<len;i++){
				fun.apply(_this,[arr[i],i]);
			}
		}

		return WalkTools;
	})()


	/**
	*本类用于监控对象值变化
	*@author ww
	*@version 1.0
	*
	*@created 2015-10-23 下午4:18:27
	*/
	//class laya.debug.tools.Watcher
	var Watcher=(function(){
		function Watcher(){}
		__class(Watcher,'laya.debug.tools.Watcher');
		Watcher.watch=function(obj,name,funs){
			VarHook.hookVar(obj,name,funs);
		}

		Watcher.traceChange=function(obj,name,sign){
			(sign===void 0)&& (sign="var changed:");
			VarHook.hookVar(obj,name,[Watcher.getTraceValueFun(name),VarHook.getLocFun(sign)]);
		}

		Watcher.debugChange=function(obj,name){
			VarHook.hookVar(obj,name,[VarHook.getLocFun("debug loc"),FunHook.debugHere]);
		}

		Watcher.differChange=function(obj,name,sign,msg){
			(msg===void 0)&& (msg="");
			VarHook.hookVar(obj,name,[Watcher.getDifferFun(obj,name,sign,msg)]);
		}

		Watcher.getDifferFun=function(obj,name,sign,msg){
			(msg===void 0)&& (msg="");
			var rst;
			rst=function (){
				DifferTool.differ(sign,obj[name],msg);
			}
			return rst;
		}

		Watcher.traceValue=function(value){
			console.log("value:",value);
		}

		Watcher.getTraceValueFun=function(name){
			var rst;
			rst=function (value){
				console.log("set "+name+" :",value);
			}
			return rst;
		}

		return Watcher;
	})()


	/**
	*XML转Object类
	*@author ww
	*
	*/
	//class laya.debug.tools.XML2Object
	var XML2Object=(function(){
		function XML2Object(){};
		__class(XML2Object,'laya.debug.tools.XML2Object');
		__getset(1,XML2Object,'arrays',function(){
			if(!XML2Object._arrays){
				XML2Object._arrays=[];
			}
			return XML2Object._arrays;
			},function(a){
			XML2Object._arrays=a;
		});

		XML2Object.parse=function(node,isFirst){
			(isFirst===void 0)&& (isFirst=true);
			var obj={};
			if(isFirst)
				obj.Name=node.localName;
			var numOfChilds=node.children.length;
			var childs=[];
			var children={};
			obj.c=children;
			obj.cList=childs;
			for(var i=0;i<numOfChilds;i++){
				var childNode=node.children[i];
				var childNodeName=childNode.localName;
				var value;
				var numOfAttributes
				value=XML2Object.parse(childNode,true);
				childs.push(value);
				if(children[childNodeName]){
					if(XML2Object.getTypeof(children[childNodeName])=="array"){
						children[childNodeName].push(value);
						}else {
						children[childNodeName]=[children[childNodeName],value];
					}
					}else if(XML2Object.isArray(childNodeName)){
					children[childNodeName]=[value];
					}else {
					children[childNodeName]=value;
				}
			}
			numOfAttributes=0;
			if(node.attributes){
				numOfAttributes=node.attributes.length;
				var prop={};
				obj.p=prop;
				for(i=0;i<numOfAttributes;i++){
					prop[node.attributes[i].name.toString()]=String(node.attributes[i].nodeValue);
				}
			}
			if(numOfChilds==0){
				if(numOfAttributes==0){
					obj="";
				}else {}
			}
			return obj;
		}

		XML2Object.getArr=function(v){
			if(!v)return [];
			if(XML2Object.getTypeof(v)=="array")return v;
			return [v];
		}

		XML2Object.isArray=function(nodeName){
			var numOfArrays=XML2Object._arrays ? XML2Object._arrays.length :0;
			for(var i=0;i<numOfArrays;i++){
				if(nodeName==XML2Object._arrays[i]){
					return true;
				}
			}
			return false;
		}

		XML2Object.getTypeof=function(o){
			if(typeof(o)=="object"){
				if(o.length==null){
					return "object";
					}else if(typeof(o.length)=="number"){
					return "array";
					}else {
					return "object";
				}
				}else {
				return typeof(o);
			}
		}

		XML2Object._arrays=null
		return XML2Object;
	})()


	/**
	*XML转Object类
	*@author ww
	*
	*/
	//class laya.debug.tools.XML2ObjectNodejs
	var XML2ObjectNodejs=(function(){
		function XML2ObjectNodejs(){};
		__class(XML2ObjectNodejs,'laya.debug.tools.XML2ObjectNodejs');
		__getset(1,XML2ObjectNodejs,'arrays',function(){
			if(!XML2ObjectNodejs._arrays){
				XML2ObjectNodejs._arrays=[];
			}
			return XML2ObjectNodejs._arrays;
			},function(a){
			XML2ObjectNodejs._arrays=a;
		});

		XML2ObjectNodejs.parse=function(node,isFirst){
			(isFirst===void 0)&& (isFirst=true);
			var obj={};
			if(isFirst)
				obj.Name=node.localName;
			var numOfChilds=node[XML2ObjectNodejs.ChildrenSign]?node[XML2ObjectNodejs.ChildrenSign].length:0;
			var childs=[];
			var children={};
			obj.c=children;
			obj.cList=childs;
			for(var i=0;i<numOfChilds;i++){
				var childNode=node[XML2ObjectNodejs.ChildrenSign][i];
				var childNodeName=childNode.localName;
				var value;
				var numOfAttributes=0
				if (!childNodeName)continue ;
				value=XML2ObjectNodejs.parse(childNode,true);
				childs.push(value);
				if(children[childNodeName]){
					if(XML2ObjectNodejs.getTypeof(children[childNodeName])=="array"){
						children[childNodeName].push(value);
						}else {
						children[childNodeName]=[children[childNodeName],value];
					}
					}else if(XML2ObjectNodejs.isArray(childNodeName)){
					children[childNodeName]=[value];
					}else {
					children[childNodeName]=value;
				}
			}
			numOfAttributes=0;
			if(node.attributes){
				numOfAttributes=node.attributes.length;
				var prop={};
				obj.p=prop;
				for(i=0;i<numOfAttributes;i++){
					prop[node.attributes[i].name.toString()]=String(node.attributes[i].nodeValue);
				}
			}
			if(numOfChilds==0){
				if(numOfAttributes==0){
				}else {}
			}
			return obj;
		}

		XML2ObjectNodejs.getArr=function(v){
			if(!v)return [];
			if(XML2ObjectNodejs.getTypeof(v)=="array")return v;
			return [v];
		}

		XML2ObjectNodejs.isArray=function(nodeName){
			var numOfArrays=XML2ObjectNodejs._arrays ? XML2ObjectNodejs._arrays.length :0;
			for(var i=0;i<numOfArrays;i++){
				if(nodeName==XML2ObjectNodejs._arrays[i]){
					return true;
				}
			}
			return false;
		}

		XML2ObjectNodejs.getTypeof=function(o){
			if(typeof(o)=="object"){
				if(o.length==null){
					return "object";
					}else if(typeof(o.length)=="number"){
					return "array";
					}else {
					return "object";
				}
				}else {
				return typeof(o);
			}
		}

		XML2ObjectNodejs._arrays=null
		XML2ObjectNodejs.ChildrenSign="childNodes";
		return XML2ObjectNodejs;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.debug.view.nodeInfo.menus.NodeMenu
	var NodeMenu=(function(){
		function NodeMenu(){
			this._tar=null;
			this._menu=null;
			this._shareBtns=[
			"信息面板",
			"边框",
			"进入节点",
			"树定位",
			"Enable链",
			"Size链",
			"节点工具",
			"可见分析",
			"输出到控制台"];
			this._menuItems=["隐藏节点"];
			this._menuHide=null;
			this._menuItemsHide=["显示节点"];
			this._menu1=null;
			this._menuItems1=["输出到控制台"];
		}

		__class(NodeMenu,'laya.debug.view.nodeInfo.menus.NodeMenu');
		var __proto=NodeMenu.prototype;
		__proto.showNodeMenu=function(node){
			if (!node._style){
				DebugTool.log("该节点已不存在，请刷新列表");
				return;
			}
			this._tar=node;
			if (!this._menu){
				this._menuItems=this._menuItems.concat(this._shareBtns);
				this._menu=ContextMenu$1.createMenuByArray(this._menuItems);
				this._menu.on("select",this,this.onEmunSelect);
				this._menuItemsHide=this._menuItemsHide.concat(this._shareBtns);
				this._menuHide=ContextMenu$1.createMenuByArray(this._menuItemsHide);
				this._menuHide.on("select",this,this.onEmunSelect);
			}
			if (node.visible){
				this._menu.show();
			}
			else{
				this._menuHide.show();
			}
		}

		__proto.nodeDoubleClick=function(node){
			NodeToolView.I.showByNode(node);
		}

		__proto.setNodeListDoubleClickAction=function(list){
			if (Browser.onMobile)return;
			list.on("doubleclick",this,this.onListDoubleClick,[list]);
		}

		__proto.onListDoubleClick=function(list){
			if (list.selectedItem){
				var tarNode;
				tarNode=list.selectedItem.path;
				laya.debug.view.nodeInfo.menus.NodeMenu.I.nodeDoubleClick(tarNode);
			}
		}

		__proto.setNodeListAction=function(list){
			list.on(DebugTool.getMenuShowEvent(),this,this.onListRightClick,[list]);
		}

		//setNodeListDoubleClickAction(list);
		__proto.onListRightClick=function(list){
			if (list.selectedItem){
				var tarNode;
				tarNode=list.selectedItem.path;
				laya.debug.view.nodeInfo.menus.NodeMenu.I.objRightClick(tarNode);
			}
		}

		__proto.objRightClick=function(obj){
			if ((obj instanceof laya.display.Sprite )){
				laya.debug.view.nodeInfo.menus.NodeMenu.I.showNodeMenu(obj);
			}
			else if ((typeof obj=='object')){
				laya.debug.view.nodeInfo.menus.NodeMenu.I.showObjectMenu(obj);
			}
		}

		__proto.showObjectMenu=function(obj){
			this._tar=obj;
			if (!this._menu1){
				this._menu1=ContextMenu$1.createMenuByArray(this._menuItems1);
				this._menu1.on("select",this,this.onEmunSelect);
			}
			this._menu1.show();
		}

		__proto.onEmunSelect=function(e){
			var data=(e.target).data;
			if ((typeof data=='string')){
				var key;
				key=data;
				switch (key){
					case "信息面板":
						ObjectInfoView.showObject(this._tar);
						break ;
					case "边框":
						DebugTool.showDisBound(this._tar);
						break ;
					case "输出到控制台":
						console.log(this._tar);
						break ;
					case "树节点":
						ToolPanel.I.showNodeTree(this._tar);
						break ;
					case "进入节点":
						ToolPanel.I.showNodeTree(this._tar);
						break ;
					case "树定位":
						ToolPanel.I.showSelectInStage(this._tar);
						break ;
					case "Enable链":
						OutPutView.I.dTrace(DebugTool.traceDisMouseEnable(this._tar));
						SelectInfosView.I.setSelectList(DebugTool.selectedNodes);
						break ;
					case "Size链":
						OutPutView.I.dTrace(DebugTool.traceDisSizeChain(this._tar));
						SelectInfosView.I.setSelectList(DebugTool.selectedNodes);
						break ;
					case "节点工具":
						NodeToolView.I.showByNode(this._tar);
						break ;
					case "显示节点":
						this._tar.visible=true;
						break ;
					case "隐藏节点":
						this._tar.visible=false;
						break ;
					case "可见分析":
						if (this._tar){
							VisibleAnalyser.analyseTarget(this._tar);
						}
						break ;
					}
			}
		}

		__getset(1,NodeMenu,'I',function(){
			if (!NodeMenu._I)
				NodeMenu._I=new NodeMenu();
			return NodeMenu._I;
		});

		NodeMenu._I=null
		return NodeMenu;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.debug.view.nodeInfo.NodeConsts
	var NodeConsts=(function(){
		function NodeConsts(){}
		__class(NodeConsts,'laya.debug.view.nodeInfo.NodeConsts');
		NodeConsts.defaultFitlerStr="x,y,width,height,scaleX,scaleY,alpha,renderCost";
		NodeConsts.RenderCostMaxTime=3000;
		return NodeConsts;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.debug.view.nodeInfo.NodeUtils
	var NodeUtils=(function(){
		function NodeUtils(){}
		__class(NodeUtils,'laya.debug.view.nodeInfo.NodeUtils');
		NodeUtils.getFilterdTree=function(sprite,keys){
			if (!keys)
				keys=NodeUtils.defaultKeys;
			var me;
			me={};
			var key;
			var i=0,len=0;
			len=keys.length;
			for (i=0;i < len;i++){
				key=keys[i];
				me[key]=sprite[key];
			};
			var cList;
			var tChild;
			cList=sprite._childs;
			len=cList.length;
			var mClist;
			mClist=[];
			for (i=0;i < len;i++){
				tChild=cList[i];
				mClist.push(NodeUtils.getFilterdTree(tChild,keys));
			}
			me.childs=mClist;
			return me;
		}

		NodeUtils.getPropertyDesO=function(tValue,keys){
			if (!keys)
				keys=NodeUtils.defaultKeys;
			var rst={};
			if ((typeof tValue=='object')){
				rst.label=""+ClassTool.getNodeClassAndName(tValue);
			}
			else{
				rst.label=""+tValue;
			}
			rst.type="";
			rst.path=tValue;
			rst.childs=[];
			rst.isDirectory=false;
			var key;
			var i=0,len=0;
			var tChild;
			if ((tValue instanceof laya.display.Node )){
				rst.des=ClassTool.getNodeClassAndName(tValue);
				rst.isDirectory=true;
				len=keys.length;
				for (i=0;i < len;i++){
					key=keys[i];
					tChild=NodeUtils.getPropertyDesO(tValue[key],keys);
					if (tValue.hasOwnProperty(key)){
						tChild.label=""+key+":"+tChild.des;
					}
					else{
						tChild.label=""+key+":"+ObjectInfoView.getNodeValue(tValue,key);
					}
					rst.childs.push(tChild);
				}
				key="_childs";
				tChild=NodeUtils.getPropertyDesO(tValue[key],keys);
				tChild.label=""+key+":"+tChild.des;
				tChild.isChilds=true;
				rst.childs.push(tChild);
			}
			else if ((tValue instanceof Array)){
				rst.des="Array["+(tValue).length+"]";
				rst.isDirectory=true;
				var tList;
				tList=tValue;
				len=tList.length;
				for (i=0;i < len;i++){
					tChild=NodeUtils.getPropertyDesO(tList[i],keys);
					tChild.label=""+i+":"+tChild.des;
					rst.childs.push(tChild);
				}
			}
			else if ((typeof tValue=='object')){
				rst.des=ClassTool.getNodeClassAndName(tValue);
				rst.isDirectory=true;
				for (key in tValue){
					tChild=NodeUtils.getPropertyDesO(tValue[key],keys);
					tChild.label=""+key+":"+tChild.des;
					rst.childs.push(tChild);
				}
			}
			else{
				rst.des=""+tValue;
			}
			rst.hasChild=rst.childs.length > 0;
			return rst;
		}

		NodeUtils.adptShowKeys=function(keys){
			var i=0,len=0;
			len=keys.length;
			for (i=len-1;i >=0;i--){
				keys[i]=StringTool$1.trimSide(keys[i]);
				if (keys[i].length < 1){
					keys.splice(i,1);
				}
			}
			return keys;
		}

		NodeUtils.getNodeTreeData=function(sprite,keys){
			NodeUtils.adptShowKeys(keys);
			var treeO;
			treeO=NodeUtils.getPropertyDesO(sprite,keys);
			var treeArr;
			treeArr=[];
			NodeUtils.getTreeArr(treeO,treeArr);
			return treeArr;
		}

		NodeUtils.getTreeArr=function(treeO,arr,add){
			(add===void 0)&& (add=true);
			if (add)
				arr.push(treeO);
			var tArr=treeO.childs;
			var i=0,len=tArr.length;
			for (i=0;i < len;i++){
				if (!add){
					tArr[i].nodeParent=null;
				}
				else{
					tArr[i].nodeParent=treeO;
				}
				if (tArr[i].isDirectory){
					NodeUtils.getTreeArr(tArr[i],arr);
				}
				else{
					arr.push(tArr[i]);
				}
			}
		}

		NodeUtils.traceStage=function(){
			console.log(NodeUtils.getFilterdTree(Laya.stage,null));
			console.log("treeArr:",NodeUtils.getNodeTreeData(Laya.stage,null));
		}

		NodeUtils.getNodeCount=function(node,visibleRequire){
			(visibleRequire===void 0)&& (visibleRequire=false);
			if (visibleRequire){
				if (!node.visible)return 0;
			};
			var rst=0;
			rst=1;
			var i=0,len=0;
			var cList;
			cList=node._childs;
			len=cList.length;
			for (i=0;i < len;i++){
				rst+=NodeUtils.getNodeCount(cList[i],visibleRequire);
			}
			return rst;
		}

		NodeUtils.getGVisible=function(node){
			while (node){
				if (!node.visible)return false;
				node=node.parent;
			}
			return true;
		}

		NodeUtils.getGAlpha=function(node){
			var rst=NaN;
			rst=1;
			while (node){
				rst *=node.alpha;
				node=node.parent;
			}
			return rst;
		}

		NodeUtils.getGPos=function(node){
			var point;
			point=new Point();
			node.localToGlobal(point);
			return point;
		}

		NodeUtils.getGRec=function(node){
			var pointList;
			pointList=node._getBoundPointsM(true);
			if (!pointList || pointList.length < 1)
				return Rectangle.TEMP.setTo(0,0,0,0);
			pointList=GrahamScan.pListToPointList(pointList,true);
			WalkTools.walkArr(pointList,node.localToGlobal,node);
			pointList=GrahamScan.pointListToPlist(pointList);
			var _disBoundRec;
			_disBoundRec=Rectangle._getWrapRec(pointList,_disBoundRec);
			return _disBoundRec;
		}

		NodeUtils.getGGraphicRec=function(node){
			var pointList;
			pointList=node.getGraphicBounds()._getBoundPoints();
			if (!pointList || pointList.length < 1)
				return Rectangle.TEMP.setTo(0,0,0,0);
			pointList=GrahamScan.pListToPointList(pointList,true);
			WalkTools.walkArr(pointList,node.localToGlobal,node);
			pointList=GrahamScan.pointListToPlist(pointList);
			var _disBoundRec;
			_disBoundRec=Rectangle._getWrapRec(pointList,_disBoundRec);
			return _disBoundRec;
		}

		NodeUtils.getNodeCmdCount=function(node){
			var rst=0;
			if (node.graphics){
				if (node.graphics.cmds){
					rst=node.graphics.cmds.length;
				}
				else{
					if (node.graphics._one){
						rst=1;
					}
					else{
						rst=0;
					}
				}
			}
			else{
				rst=0;
			}
			return rst;
		}

		NodeUtils.getNodeCmdTotalCount=function(node){
			var rst=0;
			var i=0,len=0;
			var cList;
			cList=node._childs;
			len=cList.length;
			rst=NodeUtils.getNodeCmdCount(node);
			for (i=0;i < len;i++){
				rst+=NodeUtils.getNodeCmdTotalCount(cList[i]);
			}
			return rst;
		}

		NodeUtils.getRenderNodeCount=function(node){
			if (node.cacheAs !="none")return 1;
			var rst=0;
			var i=0,len=0;
			var cList;
			cList=node._childs;
			len=cList.length;
			rst=1;
			for (i=0;i < len;i++){
				rst+=NodeUtils.getRenderNodeCount(cList[i]);
			}
			return rst;
		}

		NodeUtils.getReFreshRenderNodeCount=function(node){
			var rst=0;
			var i=0,len=0;
			var cList;
			cList=node._childs;
			len=cList.length;
			rst=1;
			for (i=0;i < len;i++){
				rst+=NodeUtils.getRenderNodeCount(cList[i]);
			}
			return rst;
		}

		NodeUtils.showCachedSpriteRecs=function(){
			NodeUtils.g=DebugInfoLayer.I.graphicLayer.graphics;
			NodeUtils.g.clear();
			WalkTools.walkTarget(Laya.stage,NodeUtils.drawCachedBounds,null);
		}

		NodeUtils.drawCachedBounds=function(sprite){
			if (sprite.cacheAs=="none")return;
			if (DebugInfoLayer.I.isDebugItem(sprite))return;
			var rec;
			rec=NodeUtils.getGRec(sprite);
			NodeUtils.g.drawRect(rec.x,rec.y,rec.width,rec.height,null,"#0000ff",2);
		}

		NodeUtils.g=null
		__static(NodeUtils,
		['defaultKeys',function(){return this.defaultKeys=["x","y","width","height"];}
		]);
		return NodeUtils;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.debug.view.StyleConsts
	var StyleConsts$1=(function(){
		function StyleConsts(){}
		__class(StyleConsts,'laya.debug.view.StyleConsts',null,'StyleConsts$1');
		StyleConsts.setViewScale=function(view){
			view.scaleX=view.scaleY=StyleConsts.PanelScale;
		}

		__static(StyleConsts,
		['PanelScale',function(){return this.PanelScale=Browser.onPC?1:Browser.pixelRatio;}
		]);
		return StyleConsts;
	})()


	/**
	*<code>Node</code> 类是可放在显示列表中的所有对象的基类。该显示列表管理 Laya 运行时中显示的所有对象。使用 Node 类排列显示列表中的显示对象。Node 对象可以有子显示对象。
	*/
	//class laya.display.Node extends laya.events.EventDispatcher
	var Node=(function(_super){
		function Node(){
			this._bits=0;
			this._displayedInStage=false;
			this._parent=null;
			this.conchModel=null;
			this.name="";
			this.destroyed=false;
			Node.__super.call(this);
			this._childs=Node.ARRAY_EMPTY;
			this._$P=Node.PROP_EMPTY;
			this.timer=Laya.timer;
			this.conchModel=Render.isConchNode ? this.createConchModel():null;
		}

		__class(Node,'laya.display.Node',_super);
		var __proto=Node.prototype;
		/**@private */
		__proto._setBit=function(type,value){
			if (type==0x1){
				var preValue=this._getBit(type);
				if (preValue !=value){
					this._updateDisplayedInstage();
				}
			}
			if (value){
				this._bits |=type;
				}else {
				this._bits &=~type;
			}
		}

		/**@private */
		__proto._getBit=function(type){
			return (this._bits & type)!=0;
		}

		/**@private */
		__proto._setUpNoticeChain=function(){
			if (this._getBit(0x1)){
				this._setUpNoticeType(0x1);
			}
		}

		/**@private */
		__proto._setUpNoticeType=function(type){
			var ele=this;
			ele._setBit(type,true);
			ele=ele.parent;
			while (ele){
				if (ele._getBit(type))return;
				ele._setBit(type,true);
				ele=ele.parent;
			}
		}

		/**
		*<p>增加事件侦听器，以使侦听器能够接收事件通知。</p>
		*<p>如果侦听鼠标事件，则会自动设置自己和父亲节点的属性 mouseEnabled 的值为 true(如果父节点mouseEnabled=false，则停止设置父节点mouseEnabled属性)。</p>
		*@param type 事件的类型。
		*@param caller 事件侦听函数的执行域。
		*@param listener 事件侦听函数。
		*@param args （可选）事件侦听函数的回调参数。
		*@return 此 EventDispatcher 对象。
		*/
		__proto.on=function(type,caller,listener,args){
			if (type==="display" || type==="undisplay"){
				if (!this._getBit(0x1)){
					this._setUpNoticeType(0x1);
				}
			}
			return this._createListener(type,caller,listener,args,false);
		}

		/**
		*<p>增加事件侦听器，以使侦听器能够接收事件通知，此侦听事件响应一次后则自动移除侦听。</p>
		*<p>如果侦听鼠标事件，则会自动设置自己和父亲节点的属性 mouseEnabled 的值为 true(如果父节点mouseEnabled=false，则停止设置父节点mouseEnabled属性)。</p>
		*@param type 事件的类型。
		*@param caller 事件侦听函数的执行域。
		*@param listener 事件侦听函数。
		*@param args （可选）事件侦听函数的回调参数。
		*@return 此 EventDispatcher 对象。
		*/
		__proto.once=function(type,caller,listener,args){
			if (type==="display" || type==="undisplay"){
				if (!this._getBit(0x1)){
					this._setUpNoticeType(0x1);
				}
			}
			return this._createListener(type,caller,listener,args,true);
		}

		/**@private */
		__proto.createConchModel=function(){
			return null;
		}

		/**
		*<p>销毁此对象。destroy对象默认会把自己从父节点移除，并且清理自身引用关系，等待js自动垃圾回收机制回收。destroy后不能再使用。</p>
		*<p>destroy时会移除自身的事情监听，自身的timer监听，移除子对象及从父节点移除自己。</p>
		*@param destroyChild （可选）是否同时销毁子节点，若值为true,则销毁子节点，否则不销毁子节点。
		*/
		__proto.destroy=function(destroyChild){
			(destroyChild===void 0)&& (destroyChild=true);
			this.destroyed=true;
			this._parent && this._parent.removeChild(this);
			if (this._childs){
				if (destroyChild)this.destroyChildren();
				else this.removeChildren();
			}
			this._childs=null;
			this._$P=null;
			this.offAll();
			this.timer.clearAll(this);
		}

		/**
		*销毁所有子对象，不销毁自己本身。
		*/
		__proto.destroyChildren=function(){
			if (this._childs){
				for (var i=this._childs.length-1;i >-1;i--){
					this._childs[i].destroy(true);
				}
			}
		}

		/**
		*添加子节点。
		*@param node 节点对象
		*@return 返回添加的节点
		*/
		__proto.addChild=function(node){
			if (!node || this.destroyed || node===this)return node;
			if ((node).zOrder)this._set$P("hasZorder",true);
			if (node._parent===this){
				var index=this.getChildIndex(node);
				if (index!==this._childs.length-1){
					this._childs.splice(index,1);
					this._childs.push(node);
					if (this.conchModel){
						this.conchModel.removeChild(node.conchModel);
						this.conchModel.addChildAt(node.conchModel,this._childs.length-1);
					}
					this._childChanged();
				}
				}else {
				node.parent && node.parent.removeChild(node);
				this._childs===Node.ARRAY_EMPTY && (this._childs=[]);
				this._childs.push(node);
				this.conchModel && this.conchModel.addChildAt(node.conchModel,this._childs.length-1);
				node.parent=this;
				this._childChanged();
			}
			return node;
		}

		/**
		*批量增加子节点
		*@param ...args 无数子节点。
		*/
		__proto.addChildren=function(__args){
			var args=arguments;
			var i=0,n=args.length;
			while (i < n){
				this.addChild(args[i++]);
			}
		}

		/**
		*添加子节点到指定的索引位置。
		*@param node 节点对象。
		*@param index 索引位置。
		*@return 返回添加的节点。
		*/
		__proto.addChildAt=function(node,index){
			if (!node || this.destroyed || node===this)return node;
			if ((node).zOrder)this._set$P("hasZorder",true);
			if (index >=0 && index <=this._childs.length){
				if (node._parent===this){
					var oldIndex=this.getChildIndex(node);
					this._childs.splice(oldIndex,1);
					this._childs.splice(index,0,node);
					if (this.conchModel){
						this.conchModel.removeChild(node.conchModel);
						this.conchModel.addChildAt(node.conchModel,index);
					}
					this._childChanged();
					}else {
					node.parent && node.parent.removeChild(node);
					this._childs===Node.ARRAY_EMPTY && (this._childs=[]);
					this._childs.splice(index,0,node);
					this.conchModel && this.conchModel.addChildAt(node.conchModel,index);
					node.parent=this;
				}
				return node;
				}else {
				throw new Error("appendChildAt:The index is out of bounds");
			}
		}

		/**
		*根据子节点对象，获取子节点的索引位置。
		*@param node 子节点。
		*@return 子节点所在的索引位置。
		*/
		__proto.getChildIndex=function(node){
			return this._childs.indexOf(node);
		}

		/**
		*根据子节点的名字，获取子节点对象。
		*@param name 子节点的名字。
		*@return 节点对象。
		*/
		__proto.getChildByName=function(name){
			var nodes=this._childs;
			if (nodes){
				for (var i=0,n=nodes.length;i < n;i++){
					var node=nodes[i];
					if (node.name===name)return node;
				}
			}
			return null;
		}

		/**@private */
		__proto._get$P=function(key){
			return this._$P[key];
		}

		/**@private */
		__proto._set$P=function(key,value){
			if (!this.destroyed){
				this._$P===Node.PROP_EMPTY && (this._$P={});
				this._$P[key]=value;
			}
			return value;
		}

		/**
		*根据子节点的索引位置，获取子节点对象。
		*@param index 索引位置
		*@return 子节点
		*/
		__proto.getChildAt=function(index){
			return this._childs[index];
		}

		/**
		*设置子节点的索引位置。
		*@param node 子节点。
		*@param index 新的索引。
		*@return 返回子节点本身。
		*/
		__proto.setChildIndex=function(node,index){
			var childs=this._childs;
			if (index < 0 || index >=childs.length){
				throw new Error("setChildIndex:The index is out of bounds.");
			};
			var oldIndex=this.getChildIndex(node);
			if (oldIndex < 0)throw new Error("setChildIndex:node is must child of this object.");
			childs.splice(oldIndex,1);
			childs.splice(index,0,node);
			if (this.conchModel){
				this.conchModel.removeChild(node.conchModel);
				this.conchModel.addChildAt(node.conchModel,index);
			}
			this._childChanged();
			return node;
		}

		/**
		*@private
		*子节点发生改变。
		*@param child 子节点。
		*/
		__proto._childChanged=function(child){}
		/**
		*删除子节点。
		*@param node 子节点
		*@return 被删除的节点
		*/
		__proto.removeChild=function(node){
			if (!this._childs)return node;
			var index=this._childs.indexOf(node);
			return this.removeChildAt(index);
		}

		/**
		*从父容器删除自己，如已经被删除不会抛出异常。
		*@return 当前节点（ Node ）对象。
		*/
		__proto.removeSelf=function(){
			this._parent && this._parent.removeChild(this);
			return this;
		}

		/**
		*根据子节点名字删除对应的子节点对象，如果找不到不会抛出异常。
		*@param name 对象名字。
		*@return 查找到的节点（ Node ）对象。
		*/
		__proto.removeChildByName=function(name){
			var node=this.getChildByName(name);
			node && this.removeChild(node);
			return node;
		}

		/**
		*根据子节点索引位置，删除对应的子节点对象。
		*@param index 节点索引位置。
		*@return 被删除的节点。
		*/
		__proto.removeChildAt=function(index){
			var node=this.getChildAt(index);
			if (node){
				this._childs.splice(index,1);
				this.conchModel && this.conchModel.removeChild(node.conchModel);
				node.parent=null;
			}
			return node;
		}

		/**
		*删除指定索引区间的所有子对象。
		*@param beginIndex 开始索引。
		*@param endIndex 结束索引。
		*@return 当前节点对象。
		*/
		__proto.removeChildren=function(beginIndex,endIndex){
			(beginIndex===void 0)&& (beginIndex=0);
			(endIndex===void 0)&& (endIndex=0x7fffffff);
			if (this._childs && this._childs.length > 0){
				var childs=this._childs;
				if (beginIndex===0 && endIndex >=n){
					var arr=childs;
					this._childs=Node.ARRAY_EMPTY;
					}else {
					arr=childs.splice(beginIndex,endIndex-beginIndex);
				}
				for (var i=0,n=arr.length;i < n;i++){
					arr[i].parent=null;
					this.conchModel && this.conchModel.removeChild(arr[i].conchModel);
				}
			}
			return this;
		}

		/**
		*替换子节点。
		*@internal 将传入的新节点对象替换到已有子节点索引位置处。
		*@param newNode 新节点。
		*@param oldNode 老节点。
		*@return 返回新节点。
		*/
		__proto.replaceChild=function(newNode,oldNode){
			var index=this._childs.indexOf(oldNode);
			if (index >-1){
				this._childs.splice(index,1,newNode);
				if (this.conchModel){
					this.conchModel.removeChild(oldNode.conchModel);
					this.conchModel.addChildAt(newNode.conchModel,index);
				}
				oldNode.parent=null;
				newNode.parent=this;
				return newNode;
			}
			return null;
		}

		/**@private */
		__proto._updateDisplayedInstage=function(){
			var ele;
			ele=this;
			var stage=Laya.stage;
			this._displayedInStage=false;
			while (ele){
				if (ele._getBit(0x1)){
					this._displayedInStage=ele._displayedInStage;
					break ;
				}
				if (ele==stage || ele._displayedInStage){
					this._displayedInStage=true;
					break ;
				}
				ele=ele.parent;
			}
		}

		/**@private */
		__proto._setDisplay=function(value){
			if (this._displayedInStage!==value){
				this._displayedInStage=value;
				if (value)this.event("display");
				else this.event("undisplay");
			}
		}

		/**
		*@private
		*设置指定节点对象是否可见(是否在渲染列表中)。
		*@param node 节点。
		*@param display 是否可见。
		*/
		__proto._displayChild=function(node,display){
			var childs=node._childs;
			if (childs){
				for (var i=0,n=childs.length;i < n;i++){
					var child=childs[i];
					if (!child._getBit(0x1))continue ;
					if (child._childs.length > 0){
						this._displayChild(child,display);
						}else {
						child._setDisplay(display);
					}
				}
			}
			node._setDisplay(display);
		}

		/**
		*当前容器是否包含指定的 <code>Node</code> 节点对象 。
		*@param node 指定的 <code>Node</code> 节点对象 。
		*@return 一个布尔值表示是否包含指定的 <code>Node</code> 节点对象 。
		*/
		__proto.contains=function(node){
			if (node===this)return true;
			while (node){
				if (node.parent===this)return true;
				node=node.parent;
			}
			return false;
		}

		/**
		*定时重复执行某函数。功能同Laya.timer.timerLoop()。
		*@param delay 间隔时间(单位毫秒)。
		*@param caller 执行域(this)。
		*@param method 结束时的回调方法。
		*@param args （可选）回调参数。
		*@param coverBefore （可选）是否覆盖之前的延迟执行，默认为true。
		*@param jumpFrame 时钟是否跳帧。基于时间的循环回调，单位时间间隔内，如能执行多次回调，出于性能考虑，引擎默认只执行一次，设置jumpFrame=true后，则回调会连续执行多次
		*/
		__proto.timerLoop=function(delay,caller,method,args,coverBefore,jumpFrame){
			(coverBefore===void 0)&& (coverBefore=true);
			(jumpFrame===void 0)&& (jumpFrame=false);
			this.timer.loop(delay,caller,method,args,coverBefore,jumpFrame);
		}

		/**
		*定时执行某函数一次。功能同Laya.timer.timerOnce()。
		*@param delay 延迟时间(单位毫秒)。
		*@param caller 执行域(this)。
		*@param method 结束时的回调方法。
		*@param args （可选）回调参数。
		*@param coverBefore （可选）是否覆盖之前的延迟执行，默认为true。
		*/
		__proto.timerOnce=function(delay,caller,method,args,coverBefore){
			(coverBefore===void 0)&& (coverBefore=true);
			this.timer._create(false,false,delay,caller,method,args,coverBefore);
		}

		/**
		*定时重复执行某函数(基于帧率)。功能同Laya.timer.frameLoop()。
		*@param delay 间隔几帧(单位为帧)。
		*@param caller 执行域(this)。
		*@param method 结束时的回调方法。
		*@param args （可选）回调参数。
		*@param coverBefore （可选）是否覆盖之前的延迟执行，默认为true。
		*/
		__proto.frameLoop=function(delay,caller,method,args,coverBefore){
			(coverBefore===void 0)&& (coverBefore=true);
			this.timer._create(true,true,delay,caller,method,args,coverBefore);
		}

		/**
		*定时执行一次某函数(基于帧率)。功能同Laya.timer.frameOnce()。
		*@param delay 延迟几帧(单位为帧)。
		*@param caller 执行域(this)
		*@param method 结束时的回调方法
		*@param args （可选）回调参数
		*@param coverBefore （可选）是否覆盖之前的延迟执行，默认为true
		*/
		__proto.frameOnce=function(delay,caller,method,args,coverBefore){
			(coverBefore===void 0)&& (coverBefore=true);
			this.timer._create(true,false,delay,caller,method,args,coverBefore);
		}

		/**
		*清理定时器。功能同Laya.timer.clearTimer()。
		*@param caller 执行域(this)。
		*@param method 结束时的回调方法。
		*/
		__proto.clearTimer=function(caller,method){
			this.timer.clear(caller,method);
		}

		/**
		*子对象数量。
		*/
		__getset(0,__proto,'numChildren',function(){
			return this._childs.length;
		});

		/**父节点。*/
		__getset(0,__proto,'parent',function(){
			return this._parent;
			},function(value){
			if (this._parent!==value){
				if (value){
					this._parent=value;
					this.event("added");
					if (this._getBit(0x1)){
						this._setUpNoticeChain();
						value.displayedInStage && this._displayChild(this,true);
					}
					value._childChanged(this);
					}else {
					this.event("removed");
					this._parent._childChanged();
					if (this._getBit(0x1))this._displayChild(this,false);
					this._parent=value;
				}
			}
		});

		/**表示是否在显示列表中显示。*/
		__getset(0,__proto,'displayedInStage',function(){
			if (this._getBit(0x1))return this._displayedInStage;
			this._setUpNoticeType(0x1);
			return this._displayedInStage;
		});

		Node.ARRAY_EMPTY=[];
		Node.PROP_EMPTY={};
		Node.NOTICE_DISPLAY=0x1;
		Node.MOUSEENABLE=0x2;
		return Node;
	})(EventDispatcher)


	/**
	*<code>Loader</code> 类可用来加载文本、JSON、XML、二进制、图像等资源。
	*/
	//class laya.net.Loader extends laya.events.EventDispatcher
	var Loader=(function(_super){
		function Loader(){
			this._data=null;
			this._url=null;
			this._type=null;
			this._cache=false;
			this._http=null;
			Loader.__super.call(this);
		}

		__class(Loader,'laya.net.Loader',_super);
		var __proto=Loader.prototype;
		/**
		*加载资源。加载错误会派发 Event.ERROR 事件，参数为错误信息。
		*@param url 资源地址。
		*@param type (default=null)资源类型。可选值为：Loader.TEXT、Loader.JSON、Loader.XML、Loader.BUFFER、Loader.IMAGE、Loader.SOUND、Loader.ATLAS、Loader.FONT。如果为null，则根据文件后缀分析类型。
		*@param cache (default=true)是否缓存数据。
		*@param group (default=null)分组名称。
		*@param ignoreCache (default=false)是否忽略缓存，强制重新加载。
		*/
		__proto.load=function(url,type,cache,group,ignoreCache){
			(cache===void 0)&& (cache=true);
			(ignoreCache===void 0)&& (ignoreCache=false);
			this._url=url;
			if (url.indexOf("data:image")===0)this._type=type="image";
			else {
				this._type=type || (type=this.getTypeFromUrl(url));
				url=URL.formatURL(url);
			}
			this._cache=cache;
			this._data=null;
			if (!ignoreCache && Loader.loadedMap[url]){
				this._data=Loader.loadedMap[url];
				this.event("progress",1);
				this.event("complete",this._data);
				return;
			}
			if (group)Loader.setGroup(url,group);
			if (Loader.parserMap[type] !=null){
				if (((Loader.parserMap[type])instanceof laya.utils.Handler ))Loader.parserMap[type].runWith(this);
				else Loader.parserMap[type].call(null,this);
				return;
			}
			if (type==="image" || type==="htmlimage" || type==="nativeimage")return this._loadImage(url);
			if (type==="sound")return this._loadSound(url);
			if (type=="atlas"){
				if (Loader.preLoadedAtlasConfigMap[url]){
					this.onLoaded(Loader.preLoadedAtlasConfigMap[url]);
					delete Loader.preLoadedAtlasConfigMap[url];
					return;
				}
			}
			if (!this._http){
				this._http=new HttpRequest();
				this._http.on("progress",this,this.onProgress);
				this._http.on("error",this,this.onError);
				this._http.on("complete",this,this.onLoaded);
			};
			var contentType;
			switch (type){
				case "atlas":
					contentType="json";
					break ;
				case "font":
					contentType="xml";
					break ;
				default :
					contentType=type;
				}
			this._http.send(url,null,"get",contentType);
		}

		/**
		*获取指定资源地址的数据类型。
		*@param url 资源地址。
		*@return 数据类型。
		*/
		__proto.getTypeFromUrl=function(url){
			var type=Utils$1.getFileExtension(url);
			if (type)return Loader.typeMap[type];
			console.warn("Not recognize the resources suffix",url);
			return "text";
		}

		/**
		*@private
		*加载图片资源。
		*@param url 资源地址。
		*/
		__proto._loadImage=function(url){
			url=URL.formatURL(url);
			var _this=this;
			var image;
			function clear (){
				image.onload=null;
				image.onerror=null;
				delete Loader.imgCache[url]
			};
			var onload=function (){
				clear();
				_this.onLoaded(image);
			};
			var onerror=function (){
				clear();
				_this.event("error","Load image failed");
			}
			if (this._type==="nativeimage"){
				image=new Browser.window.Image();
				image.crossOrigin="";
				image.onload=onload;
				image.onerror=onerror;
				image.src=url;
				Loader.imgCache[url]=image;
				}else {
				new HTMLImage.create(url,{onload:onload,onerror:onerror,onCreate:function (img){
						image=img;
						Loader.imgCache[url]=img;
				}});
			}
		}

		/**
		*@private
		*加载声音资源。
		*@param url 资源地址。
		*/
		__proto._loadSound=function(url){
			var sound=(new SoundManager._soundClass());
			var _this=this;
			sound.on("complete",this,soundOnload);
			sound.on("error",this,soundOnErr);
			sound.load(url);
			function soundOnload (){
				clear();
				_this.onLoaded(sound);
			}
			function soundOnErr (){
				clear();
				sound.dispose();
				_this.event("error","Load sound failed");
			}
			function clear (){
				sound.offAll();
			}
		}

		/**@private */
		__proto.onProgress=function(value){
			if (this._type==="atlas")this.event("progress",value *0.3);
			else this.event("progress",value);
		}

		/**@private */
		__proto.onError=function(message){
			this.event("error",message);
		}

		/**
		*资源加载完成的处理函数。
		*@param data 数据。
		*/
		__proto.onLoaded=function(data){
			var type=this._type;
			if (type==="image"){
				var tex=new Texture(data);
				tex.url=this._url;
				this.complete(tex);
				}else if (type==="sound" || type==="htmlimage" || type==="nativeimage"){
				this.complete(data);
				}else if (type==="atlas"){
				if (!data.src && !data._setContext){
					if (!this._data){
						this._data=data;
						if (data.meta && data.meta.image){
							var toloadPics=data.meta.image.split(",");
							var split=this._url.indexOf("/")>=0 ? "/" :"\\";
							var idx=this._url.lastIndexOf(split);
							var folderPath=idx >=0 ? this._url.substr(0,idx+1):"";
							for (var i=0,len=toloadPics.length;i < len;i++){
								toloadPics[i]=folderPath+toloadPics[i];
							}
							}else {
							toloadPics=[this._url.replace(".json",".png")];
						}
						toloadPics.reverse();
						data.toLoads=toloadPics;
						data.pics=[];
					}
					this.event("progress",0.3+1 / toloadPics.length *0.6);
					return this._loadImage(toloadPics.pop());
					}else {
					this._data.pics.push(data);
					if (this._data.toLoads.length > 0){
						this.event("progress",0.3+1 / this._data.toLoads.length *0.6);
						return this._loadImage(this._data.toLoads.pop());
					};
					var frames=this._data.frames;
					var cleanUrl=this._url.split("?")[0];
					var directory=(this._data.meta && this._data.meta.prefix)? this._data.meta.prefix :cleanUrl.substring(0,cleanUrl.lastIndexOf("."))+"/";
					var pics=this._data.pics;
					var atlasURL=URL.formatURL(this._url);
					var map=Loader.atlasMap[atlasURL] || (Loader.atlasMap[atlasURL]=[]);
					map.dir=directory;
					for (var name in frames){
						var obj=frames[name];
						var tPic=pics[obj.frame.idx ? obj.frame.idx :0];
						var url=URL.formatURL(directory+name);
						Loader.cacheRes(url,Texture.create(tPic,obj.frame.x,obj.frame.y,obj.frame.w,obj.frame.h,obj.spriteSourceSize.x,obj.spriteSourceSize.y,obj.sourceSize.w,obj.sourceSize.h));
						Loader.loadedMap[url].url=url;
						map.push(url);
					}
					delete this._data.pics;
					this.complete(this._data);
				}
				}else if (type=="font"){
				if (!data.src){
					this._data=data;
					this.event("progress",0.5);
					return this._loadImage(this._url.replace(".fnt",".png"));
					}else {
					var bFont=new BitmapFont();
					bFont.parseFont(this._data,data);
					var tArr=this._url.split(".fnt")[0].split("/");
					var fontName=tArr[tArr.length-1];
					Text.registerBitmapFont(fontName,bFont);
					this._data=bFont;
					this.complete(this._data);
				}
				}else {
				this.complete(data);
			}
		}

		/**
		*加载完成。
		*@param data 加载的数据。
		*/
		__proto.complete=function(data){
			this._data=data;
			Loader._loaders.push(this);
			if (!Loader._isWorking)Loader.checkNext();
		}

		/**
		*结束加载，处理是否缓存及派发完成事件 <code>Event.COMPLETE</code> 。
		*@param content 加载后的数据
		*/
		__proto.endLoad=function(content){
			content && (this._data=content);
			if (this._cache)Loader.cacheRes(this._url,this._data);
			this.event("progress",1);
			this.event("complete",(this.data instanceof Array)? [this.data] :this.data);
		}

		/**加载地址。*/
		__getset(0,__proto,'url',function(){
			return this._url;
		});

		/**返回的数据。*/
		__getset(0,__proto,'data',function(){
			return this._data;
		});

		/**是否缓存。*/
		__getset(0,__proto,'cache',function(){
			return this._cache;
		});

		/**加载类型。*/
		__getset(0,__proto,'type',function(){
			return this._type;
		});

		Loader.checkNext=function(){
			Loader._isWorking=true;
			var startTimer=Browser.now();
			var thisTimer=startTimer;
			while (Loader._startIndex < Loader._loaders.length){
				thisTimer=Browser.now();
				Loader._loaders[Loader._startIndex].endLoad();
				Loader._startIndex++;
				if (Browser.now()-startTimer > Loader.maxTimeOut){
					console.warn("loader callback cost a long time:"+(Browser.now()-startTimer)+" url="+Loader._loaders[Loader._startIndex-1].url);
					Laya.timer.frameOnce(1,null,Loader.checkNext);
					return;
				}
			}
			Loader._loaders.length=0;
			Loader._startIndex=0;
			Loader._isWorking=false;
		}

		Loader.clearRes=function(url,forceDispose){
			(forceDispose===void 0)&& (forceDispose=false);
			url=URL.formatURL(url);
			var arr=Loader.getAtlas(url);
			if (arr){
				for (var i=0,n=arr.length;i < n;i++){
					var resUrl=arr[i];
					var tex=Loader.getRes(resUrl);
					if (tex)tex.destroy(forceDispose);
					delete Loader.loadedMap[resUrl];
				}
				arr.length=0;
				delete Loader.atlasMap[url];
				delete Loader.loadedMap[url];
				}else {
				var res=Loader.loadedMap[url];
				if (res){
					if ((res instanceof laya.resource.Texture )&& res.bitmap)(res).destroy(forceDispose);
					delete Loader.loadedMap[url];
				}
			}
		}

		Loader.setAtlasConfigs=function(url,config){
			Loader.preLoadedAtlasConfigMap[URL.formatURL(url)]=config;
		}

		Loader.getRes=function(url){
			return Loader.loadedMap[URL.formatURL(url)];
		}

		Loader.getAtlas=function(url){
			return Loader.atlasMap[URL.formatURL(url)];
		}

		Loader.cacheRes=function(url,data){
			url=URL.formatURL(url);
			if (Loader.loadedMap[url] !=null){
				console.warn("Resources already exist,is repeated loading:",url);
				}else {
				Loader.loadedMap[url]=data;
			}
		}

		Loader.setGroup=function(url,group){
			if (!Loader.groupMap[group])Loader.groupMap[group]=[];
			Loader.groupMap[group].push(url);
		}

		Loader.clearResByGroup=function(group){
			if (!Loader.groupMap[group])return;
			var arr=Loader.groupMap[group],i=0,len=arr.length;
			for (i=0;i < len;i++){
				Loader.clearRes(arr[i]);
			}
			arr.length=0;
		}

		Loader.TEXT="text";
		Loader.JSON="json";
		Loader.XML="xml";
		Loader.BUFFER="arraybuffer";
		Loader.IMAGE="image";
		Loader.SOUND="sound";
		Loader.ATLAS="atlas";
		Loader.FONT="font";
		Loader.typeMap={"png":"image","jpg":"image","jpeg":"image","txt":"text","json":"json","xml":"xml","als":"atlas","atlas":"atlas","mp3":"sound","ogg":"sound","wav":"sound","part":"json","fnt":"font"};
		Loader.parserMap={};
		Loader.groupMap={};
		Loader.maxTimeOut=100;
		Loader.loadedMap={};
		Loader.preLoadedAtlasConfigMap={};
		Loader.atlasMap={};
		Loader._loaders=[];
		Loader._isWorking=false;
		Loader._startIndex=0;
		Loader.imgCache={};
		return Loader;
	})(EventDispatcher)


	/**
	*@private
	*<code>Resource</code> 资源存取类。
	*/
	//class laya.resource.Resource extends laya.events.EventDispatcher
	var Resource=(function(_super){
		function Resource(){
			//this._id=0;
			//this._lastUseFrameCount=0;
			//this._memorySize=0;
			//this._name=null;
			//this._url=null;
			//this.__loaded=false;
			//this._released=false;
			//this._disposed=false;
			//this._resourceManager=null;
			//this.lock=false;
			Resource.__super.call(this);
			this._$1__id=++Resource._uniqueIDCounter;
			this.__loaded=true;
			this._disposed=false;
			Resource._loadedResources.push(this);
			Resource._isLoadedResourcesSorted=false;
			this._released=true;
			this.lock=false;
			this._memorySize=0;
			this._lastUseFrameCount=-1;
			(ResourceManager.currentResourceManager)&& (ResourceManager.currentResourceManager.addResource(this));
		}

		__class(Resource,'laya.resource.Resource',_super);
		var __proto=Resource.prototype;
		Laya.imps(__proto,{"laya.resource.ICreateResource":true,"laya.resource.IDispose":true})
		/**
		*@private
		*/
		__proto._endLoaded=function(){
			this.__loaded=true;
			this.event("loaded",this);
		}

		/**重新创建资源,override it，同时修改memorySize属性、处理startCreate()和compoleteCreate()方法。*/
		__proto.recreateResource=function(){
			this.startCreate();
			this.completeCreate();
		}

		/**销毁资源，override it,同时修改memorySize属性。*/
		__proto.detoryResource=function(){}
		/**
		*激活资源，使用资源前应先调用此函数激活。
		*@param force 是否强制创建。
		*/
		__proto.activeResource=function(force){
			(force===void 0)&& (force=false);
			this._lastUseFrameCount=Stat.loopCount;
			if (this._released || force){
				this.recreateResource();
			}
		}

		/**
		*释放资源。
		*@param force 是否强制释放。
		*@return 是否成功释放。
		*/
		__proto.releaseResource=function(force){
			(force===void 0)&& (force=false);
			if (!force && this.lock)
				return false;
			if (!this._released || force){
				this.detoryResource();
				this._released=true;
				this._lastUseFrameCount=-1;
				this.event("released",this);
				return true;
				}else {
				return false;
			}
		}

		/**
		*设置唯一名字,如果名字重复则自动加上“-copy”。
		*@param newName 名字。
		*/
		__proto.setUniqueName=function(newName){
			var isUnique=true;
			for (var i=0;i < Resource._loadedResources.length;i++){
				if (Resource._loadedResources[i]._name!==newName || Resource._loadedResources[i]===this)
					continue ;
				isUnique=false;
				return;
			}
			if (isUnique){
				if (this.name !=newName){
					this.name=newName;
					Resource._isLoadedResourcesSorted=false;
				}
				}else{
				this.setUniqueName(newName.concat("-copy"));
			}
		}

		/**
		*@private
		*/
		__proto.onAsynLoaded=function(url,data,params){
			throw new Error("Resource: must override this function!");
		}

		/**
		*<p>彻底处理资源，处理后不能恢复。</p>
		*<p><b>注意：</b>会强制解锁清理。</p>
		*/
		__proto.dispose=function(){
			if (this._resourceManager!==null)
				throw new Error("附属于resourceManager的资源不能独立释放！");
			this._disposed=true;
			this.lock=false;
			this.releaseResource();
			var index=Resource._loadedResources.indexOf(this);
			if (index!==-1){
				Resource._loadedResources.splice(index,1);
				Resource._isLoadedResourcesSorted=false;
			}
			Loader.clearRes(this.url);
		}

		/**开始资源激活。*/
		__proto.startCreate=function(){
			this.event("recovering",this);
		}

		/**完成资源激活。*/
		__proto.completeCreate=function(){
			this._released=false;
			this.event("recovered",this);
		}

		/**
		*占用内存尺寸。
		*/
		__getset(0,__proto,'memorySize',function(){
			return this._memorySize;
			},function(value){
			var offsetValue=value-this._memorySize;
			this._memorySize=value;
			this.resourceManager && this.resourceManager.addSize(offsetValue);
		});

		/**
		*@private
		*/
		__getset(0,__proto,'_loaded',null,function(value){
			this.__loaded=value;
		});

		/**
		*获取是否已加载完成。
		*/
		__getset(0,__proto,'loaded',function(){
			return this.__loaded;
		});

		/**
		*获取唯一标识ID,通常用于识别。
		*/
		__getset(0,__proto,'id',function(){
			return this._$1__id;
		});

		/**
		*设置名字
		*/
		/**
		*获取名字。
		*/
		__getset(0,__proto,'name',function(){
			return this._name;
			},function(value){
			if ((value || value!=="")&& this.name!==value){
				this._name=value;
				Resource._isLoadedResourcesSorted=false;
			}
		});

		/**
		*是否已处理。
		*/
		__getset(0,__proto,'disposed',function(){
			return this._disposed;
		});

		/**
		*是否已释放。
		*/
		__getset(0,__proto,'released',function(){
			return this._released;
		});

		/**
		*资源管理员。
		*/
		__getset(0,__proto,'resourceManager',function(){
			return this._resourceManager;
		});

		/**
		*距离上次使用帧率。
		*/
		__getset(0,__proto,'lastUseFrameCount',function(){
			return this._lastUseFrameCount;
		});

		/**
		*色湖之资源的URL地址。
		*@param value URL地址。
		*/
		/**
		*获取资源的URL地址。
		*@return URL地址。
		*/
		__getset(0,__proto,'url',function(){
			return this._url;
			},function(value){
			this._url=value;
		});

		/**
		*本类型排序后的已载入资源。
		*/
		__getset(1,Resource,'sortedLoadedResourcesByName',function(){
			if (!Resource._isLoadedResourcesSorted){
				Resource._isLoadedResourcesSorted=true;
				Resource._loadedResources.sort(Resource.compareResourcesByName);
			}
			return Resource._loadedResources;
		},laya.events.EventDispatcher._$SET_sortedLoadedResourcesByName);

		Resource.getLoadedResourceByIndex=function(index){
			return Resource._loadedResources[index];
		}

		Resource.getLoadedResourcesCount=function(){
			return Resource._loadedResources.length;
		}

		Resource.compareResourcesByName=function(left,right){
			if (left===right)
				return 0;
			var x=left.name;
			var y=right.name;
			if (x===null){
				if (y===null)
					return 0;
				else
				return-1;
				}else {
				if (y==null)
					return 1;
				else {
					var retval=x.localeCompare(y);
					if (retval !=0)
						return retval;
					else {
						right.setUniqueName(y);
						y=right.name;
						return x.localeCompare(y);
					}
				}
			}
		}

		Resource._uniqueIDCounter=0;
		Resource._loadedResources=[];
		Resource._isLoadedResourcesSorted=false;
		return Resource;
	})(EventDispatcher)


	/**
	*@private
	*使用Audio标签播放声音
	*/
	//class laya.media.h5audio.AudioSound extends laya.events.EventDispatcher
	var AudioSound=(function(_super){
		function AudioSound(){
			this.url=null;
			this.audio=null;
			this.loaded=false;
			AudioSound.__super.call(this);
		}

		__class(AudioSound,'laya.media.h5audio.AudioSound',_super);
		var __proto=AudioSound.prototype;
		/**
		*释放声音
		*
		*/
		__proto.dispose=function(){
			var ad=AudioSound._audioCache[this.url];
			if (ad){
				ad.src="";
				delete AudioSound._audioCache[this.url];
			}
		}

		/**
		*加载声音
		*@param url
		*
		*/
		__proto.load=function(url){
			url=URL.formatURL(url);
			this.url=url;
			var ad;
			if (url==SoundManager._tMusic){
				AudioSound._initMusicAudio();
				ad=AudioSound._musicAudio;
				if (ad.src !=url){
					AudioSound._audioCache[ad.src]=null;
					ad=null;
				}
				}else{
				ad=AudioSound._audioCache[url];
			}
			if (ad && ad.readyState >=2){
				this.event("complete");
				return;
			}
			if (!ad){
				if (url==SoundManager._tMusic){
					AudioSound._initMusicAudio();
					ad=AudioSound._musicAudio;
					}else{
					ad=Browser.createElement("audio");
				}
				AudioSound._audioCache[url]=ad;
				ad.src=url;
			}
			ad.addEventListener("canplaythrough",onLoaded);
			ad.addEventListener("error",onErr);
			var me=this;
			function onLoaded (){
				offs();
				me.loaded=true;
				me.event("complete");
			}
			function onErr (){
				ad.load=null;
				offs();
				me.event("error");
			}
			function offs (){
				ad.removeEventListener("canplaythrough",onLoaded);
				ad.removeEventListener("error",onErr);
			}
			this.audio=ad;
			if (ad.load){
				ad.load();
				}else {
				onErr();
			}
		}

		/**
		*播放声音
		*@param startTime 起始时间
		*@param loops 循环次数
		*@return
		*
		*/
		__proto.play=function(startTime,loops){
			(startTime===void 0)&& (startTime=0);
			(loops===void 0)&& (loops=0);
			if (!this.url)return null;
			var ad;
			if (this.url==SoundManager._tMusic){
				ad=AudioSound._musicAudio;
				}else{
				ad=AudioSound._audioCache[this.url];
			}
			if (!ad)return null;
			var tAd;
			tAd=Pool.getItem("audio:"+this.url);
			if (Render.isConchApp){
				if (!tAd){
					tAd=Browser.createElement("audio");
					tAd.src=ad.src;
				}
			}
			else {
				if (this.url==SoundManager._tMusic){
					AudioSound._initMusicAudio();
					tAd=AudioSound._musicAudio;
					tAd.src=this.url;
					}else{
					tAd=tAd ? tAd :ad.cloneNode(true);
				}
			};
			var channel=new AudioSoundChannel(tAd);
			channel.url=this.url;
			channel.loops=loops;
			channel.startTime=startTime;
			channel.play();
			SoundManager.addChannel(channel);
			return channel;
		}

		/**
		*获取总时间。
		*/
		__getset(0,__proto,'duration',function(){
			var ad;
			ad=AudioSound._audioCache[this.url];
			if (!ad)
				return 0;
			return ad.duration;
		});

		AudioSound._initMusicAudio=function(){
			if (AudioSound._musicAudio)return;
			if (!AudioSound._musicAudio)AudioSound._musicAudio=Browser.createElement("audio");
			Browser.document.addEventListener("touchstart",AudioSound._makeMusicOK);
		}

		AudioSound._makeMusicOK=function(){
			Browser.document.removeEventListener("touchstart",AudioSound._makeMusicOK);
			if (!AudioSound._musicAudio.src){
				AudioSound._musicAudio.src="";
				AudioSound._musicAudio.load();
				}else{
				AudioSound._musicAudio.play();
			}
		}

		AudioSound._audioCache={};
		AudioSound._musicAudio=null
		return AudioSound;
	})(EventDispatcher)


	/**
	*<p> <code>SoundChannel</code> 用来控制程序中的声音。每个声音均分配给一个声道，而且应用程序可以具有混合在一起的多个声道。</p>
	*<p> <code>SoundChannel</code> 类包含控制声音的播放、暂停、停止、音量的方法，以及获取声音的播放状态、总时间、当前播放时间、总循环次数、播放地址等信息的方法。</p>
	*/
	//class laya.media.SoundChannel extends laya.events.EventDispatcher
	var SoundChannel=(function(_super){
		function SoundChannel(){
			this.url=null;
			this.loops=0;
			this.startTime=NaN;
			this.isStopped=false;
			this.completeHandler=null;
			SoundChannel.__super.call(this);
		}

		__class(SoundChannel,'laya.media.SoundChannel',_super);
		var __proto=SoundChannel.prototype;
		/**
		*播放。
		*/
		__proto.play=function(){}
		/**
		*停止。
		*/
		__proto.stop=function(){}
		/**
		*暂停。
		*/
		__proto.pause=function(){}
		/**
		*继续播放。
		*/
		__proto.resume=function(){}
		/**
		*private
		*/
		__proto.__runComplete=function(handler){
			if (handler){
				handler.run();
			}
		}

		/**
		*音量范围从 0（静音）至 1（最大音量）。
		*/
		__getset(0,__proto,'volume',function(){
			return 1;
			},function(v){
		});

		/**
		*获取当前播放时间。
		*/
		__getset(0,__proto,'position',function(){
			return 0;
		});

		/**
		*获取总时间。
		*/
		__getset(0,__proto,'duration',function(){
			return 0;
		});

		return SoundChannel;
	})(EventDispatcher)


	/**
	*<code>Sound</code> 类是用来播放控制声音的类。
	*/
	//class laya.media.Sound extends laya.events.EventDispatcher
	var Sound=(function(_super){
		function Sound(){Sound.__super.call(this);;
		};

		__class(Sound,'laya.media.Sound',_super);
		var __proto=Sound.prototype;
		/**
		*加载声音。
		*@param url 地址。
		*
		*/
		__proto.load=function(url){}
		/**
		*播放声音。
		*@param startTime 开始时间,单位秒
		*@param loops 循环次数,0表示一直循环
		*@return 声道 SoundChannel 对象。
		*
		*/
		__proto.play=function(startTime,loops){
			(startTime===void 0)&& (startTime=0);
			(loops===void 0)&& (loops=0);
			return null;
		}

		/**
		*释放声音资源。
		*
		*/
		__proto.dispose=function(){}
		/**
		*获取总时间。
		*/
		__getset(0,__proto,'duration',function(){
			return 0;
		});

		return Sound;
	})(EventDispatcher)


	/**
	*@private
	*web audio api方式播放声音
	*/
	//class laya.media.webaudio.WebAudioSound extends laya.events.EventDispatcher
	var WebAudioSound=(function(_super){
		function WebAudioSound(){
			this.url=null;
			this.loaded=false;
			this.data=null;
			this.audioBuffer=null;
			this.__toPlays=null;
			WebAudioSound.__super.call(this);
		}

		__class(WebAudioSound,'laya.media.webaudio.WebAudioSound',_super);
		var __proto=WebAudioSound.prototype;
		/**
		*加载声音
		*@param url
		*
		*/
		__proto.load=function(url){
			var me=this;
			url=URL.formatURL(url);
			this.url=url;
			this.audioBuffer=WebAudioSound._dataCache[url];
			if (this.audioBuffer){
				this._loaded(this.audioBuffer);
				return;
			}
			WebAudioSound.e.on("loaded:"+url,this,this._loaded);
			WebAudioSound.e.on("err:"+url,this,this._err);
			if (WebAudioSound.__loadingSound[url]){
				return;
			}
			WebAudioSound.__loadingSound[url]=true;
			var request=new Browser.window.XMLHttpRequest();
			request.open("GET",url,true);
			request.responseType="arraybuffer";
			request.onload=function (){
				me.data=request.response;
				WebAudioSound.buffs.push({"buffer":me.data,"url":me.url});
				WebAudioSound.decode();
			};
			request.onerror=function (e){
				me._err();
			}
			request.send();
		}

		__proto._err=function(){
			this._removeLoadEvents();
			WebAudioSound.__loadingSound[this.url]=false;
			this.event("error");
		}

		__proto._loaded=function(audioBuffer){
			this._removeLoadEvents();
			this.audioBuffer=audioBuffer;
			WebAudioSound._dataCache[this.url]=this.audioBuffer;
			this.loaded=true;
			this.event("complete");
		}

		__proto._removeLoadEvents=function(){
			WebAudioSound.e.off("loaded:"+this.url,this,this._loaded);
			WebAudioSound.e.off("err:"+this.url,this,this._err);
		}

		__proto.__playAfterLoaded=function(){
			if (!this.__toPlays)return;
			var i=0,len=0;
			var toPlays;
			toPlays=this.__toPlays;
			len=toPlays.length;
			var tParams;
			for (i=0;i < len;i++){
				tParams=toPlays[i];
				if (tParams[2] && !(tParams [2]).isStopped){
					this.play(tParams[0],tParams[1],tParams[2]);
				}
			}
			this.__toPlays.length=0;
		}

		/**
		*播放声音
		*@param startTime 起始时间
		*@param loops 循环次数
		*@return
		*
		*/
		__proto.play=function(startTime,loops,channel){
			(startTime===void 0)&& (startTime=0);
			(loops===void 0)&& (loops=0);
			channel=channel ? channel :new WebAudioSoundChannel();
			if (!this.audioBuffer){
				if (this.url){
					if (!this.__toPlays)this.__toPlays=[];
					this.__toPlays.push([startTime,loops,channel]);
					this.once("complete",this,this.__playAfterLoaded);
					this.load(this.url);
				}
			}
			channel.url=this.url;
			channel.loops=loops;
			channel["audioBuffer"]=this.audioBuffer;
			channel.startTime=startTime;
			channel.play();
			SoundManager.addChannel(channel);
			return channel;
		}

		__proto.dispose=function(){
			delete WebAudioSound._dataCache[this.url];
			delete WebAudioSound.__loadingSound[this.url];
		}

		__getset(0,__proto,'duration',function(){
			if (this.audioBuffer){
				return this.audioBuffer.duration;
			}
			return 0;
		});

		WebAudioSound.decode=function(){
			if (WebAudioSound.buffs.length <=0 || WebAudioSound.isDecoding){
				return;
			}
			WebAudioSound.isDecoding=true;
			WebAudioSound.tInfo=WebAudioSound.buffs.shift();
			WebAudioSound.ctx.decodeAudioData(WebAudioSound.tInfo["buffer"],WebAudioSound._done,WebAudioSound._fail);
		}

		WebAudioSound._done=function(audioBuffer){
			WebAudioSound.e.event("loaded:"+WebAudioSound.tInfo.url,audioBuffer);
			WebAudioSound.isDecoding=false;
			WebAudioSound.decode();
		}

		WebAudioSound._fail=function(){
			WebAudioSound.e.event("err:"+WebAudioSound.tInfo.url,null);
			WebAudioSound.isDecoding=false;
			WebAudioSound.decode();
		}

		WebAudioSound._playEmptySound=function(){
			if (WebAudioSound.ctx==null){
				return;
			};
			var source=WebAudioSound.ctx.createBufferSource();
			source.buffer=WebAudioSound._miniBuffer;
			source.connect(WebAudioSound.ctx.destination);
			source.start(0,0,0);
		}

		WebAudioSound._unlock=function(){
			if (WebAudioSound._unlocked){
				return;
			}
			WebAudioSound._playEmptySound();
			if (WebAudioSound.ctx.state=="running"){
				Browser.document.removeEventListener("mousedown",WebAudioSound._unlock,true);
				Browser.document.removeEventListener("touchend",WebAudioSound._unlock,true);
				WebAudioSound._unlocked=true;
			}
		}

		WebAudioSound.initWebAudio=function(){
			if (WebAudioSound.ctx.state !="running"){
				WebAudioSound._unlock();
				Browser.document.addEventListener("mousedown",WebAudioSound._unlock,true);
				Browser.document.addEventListener("touchend",WebAudioSound._unlock,true);
			}
		}

		WebAudioSound._dataCache={};
		WebAudioSound.buffs=[];
		WebAudioSound.isDecoding=false;
		WebAudioSound._unlocked=false;
		WebAudioSound.tInfo=null
		WebAudioSound.__loadingSound={};
		__static(WebAudioSound,
		['window',function(){return this.window=Browser.window;},'webAudioEnabled',function(){return this.webAudioEnabled=WebAudioSound.window["AudioContext"] || WebAudioSound.window["webkitAudioContext"] || WebAudioSound.window["mozAudioContext"];},'ctx',function(){return this.ctx=WebAudioSound.webAudioEnabled ? new (WebAudioSound.window["AudioContext"] || WebAudioSound.window["webkitAudioContext"] || WebAudioSound.window["mozAudioContext"])():undefined;},'_miniBuffer',function(){return this._miniBuffer=WebAudioSound.ctx.createBuffer(1,1,22050);},'e',function(){return this.e=new EventDispatcher();}
		]);
		return WebAudioSound;
	})(EventDispatcher)


	/**
	*<p> <code>HttpRequest</code> 通过封装 HTML <code>XMLHttpRequest</code> 对象提供了对 HTTP 协议的完全的访问，包括做出 POST 和 HEAD 请求以及普通的 GET 请求的能力。 <code>HttpRequest</code> 只提供以异步的形式返回 Web 服务器的响应，并且能够以文本或者二进制的形式返回内容。</p>
	*<p><b>注意：</b>建议每次请求都使用新的 <code>HttpRequest</code> 对象，因为每次调用该对象的send方法时，都会清空之前设置的数据，并重置 HTTP 请求的状态，这会导致之前还未返回响应的请求被重置，从而得不到之前请求的响应结果。</p>
	*/
	//class laya.net.HttpRequest extends laya.events.EventDispatcher
	var HttpRequest=(function(_super){
		function HttpRequest(){
			this._responseType=null;
			this._data=null;
			HttpRequest.__super.call(this);
			this._http=new Browser.window.XMLHttpRequest();
		}

		__class(HttpRequest,'laya.net.HttpRequest',_super);
		var __proto=HttpRequest.prototype;
		/**
		*发送 HTTP 请求。
		*@param url 请求的地址。大多数浏览器实施了一个同源安全策略，并且要求这个 URL 与包含脚本的文本具有相同的主机名和端口。
		*@param data (default=null)发送的数据。
		*@param method (default="get")用于请求的 HTTP 方法。值包括 "get"、"post"、"head"。
		*@param responseType (default="text")Web 服务器的响应类型，可设置为 "text"、"json"、"xml"、"arraybuffer"。
		*@param headers (default=null)HTTP 请求的头部信息。参数形如key-value数组：key是头部的名称，不应该包括空白、冒号或换行；value是头部的值，不应该包括换行。比如["Content-Type","application/json"]。
		*/
		__proto.send=function(url,data,method,responseType,headers){
			(method===void 0)&& (method="get");
			(responseType===void 0)&& (responseType="text");
			this._responseType=responseType;
			this._data=null;
			var _this=this;
			var http=this._http;
			http.open(method,url,true);
			if (headers){
				for (var i=0;i < headers.length;i++){
					http.setRequestHeader(headers[i++],headers[i]);
				}
				}else if (!Render.isConchApp){
				if (!data || (typeof data=='string'))http.setRequestHeader("Content-Type","application/x-www-form-urlencoded");
				else http.setRequestHeader("Content-Type","application/json");
			}
			http.responseType=responseType!=="arraybuffer" ? "text" :"arraybuffer";
			http.onerror=function (e){
				_this._onError(e);
			}
			http.onabort=function (e){
				_this._onAbort(e);
			}
			http.onprogress=function (e){
				_this._onProgress(e);
			}
			http.onload=function (e){
				_this._onLoad(e);
			}
			http.send(data);
		}

		/**
		*@private
		*请求进度的侦听处理函数。
		*@param e 事件对象。
		*/
		__proto._onProgress=function(e){
			if (e && e.lengthComputable)this.event("progress",e.loaded / e.total);
		}

		/**
		*@private
		*请求中断的侦听处理函数。
		*@param e 事件对象。
		*/
		__proto._onAbort=function(e){
			this.error("Request was aborted by user");
		}

		/**
		*@private
		*请求出错侦的听处理函数。
		*@param e 事件对象。
		*/
		__proto._onError=function(e){
			this.error("Request failed Status:"+this._http.status+" text:"+this._http.statusText);
		}

		/**
		*@private
		*请求消息返回的侦听处理函数。
		*@param e 事件对象。
		*/
		__proto._onLoad=function(e){
			var http=this._http;
			var status=http.status!==undefined ? http.status :200;
			if (status===200 || status===204 || status===0){
				this.complete();
				}else {
				this.error("["+http.status+"]"+http.statusText+":"+http.responseURL);
			}
		}

		/**
		*@private
		*请求错误的处理函数。
		*@param message 错误信息。
		*/
		__proto.error=function(message){
			this.clear();
			this.event("error",message);
		}

		/**
		*@private
		*请求成功完成的处理函数。
		*/
		__proto.complete=function(){
			this.clear();
			var flag=true;
			try {
				if (this._responseType==="json"){
					this._data=JSON.parse(this._http.responseText);
					}else if (this._responseType==="xml"){
					this._data=Utils$1.parseXMLFromString(this._http.responseText);
					}else {
					this._data=this._http.response || this._http.responseText;
				}
				}catch (e){
				flag=false;
				this.error(e.message);
			}
			flag && this.event("complete",(this._data instanceof Array)? [this._data] :this._data);
		}

		/**
		*@private
		*清除当前请求。
		*/
		__proto.clear=function(){
			var http=this._http;
			http.onerror=http.onabort=http.onprogress=http.onload=null;
		}

		/**请求的地址。*/
		__getset(0,__proto,'url',function(){
			return this._http.responseURL;
		});

		/**
		*本对象所封装的原生 XMLHttpRequest 引用。
		*/
		__getset(0,__proto,'http',function(){
			return this._http;
		});

		/**返回的数据。*/
		__getset(0,__proto,'data',function(){
			return this._data;
		});

		return HttpRequest;
	})(EventDispatcher)


	/**
	*<p> <code>LoaderManager</code> 类用于用于批量加载资源。此类是单例，不要手动实例化此类，请通过Laya.loader访问。</p>
	*<p>全部队列加载完成，会派发 Event.COMPLETE 事件；如果队列中任意一个加载失败，会派发 Event.ERROR 事件，事件回调参数值为加载出错的资源地址。</p>
	*<p> <code>LoaderManager</code> 类提供了以下几种功能：<br/>
	*多线程：默认5个加载线程，可以通过maxLoader属性修改线程数量；<br/>
	*多优先级：有0-4共5个优先级，优先级高的优先加载。0最高，4最低；<br/>
	*重复过滤：自动过滤重复加载（不会有多个相同地址的资源同时加载）以及复用缓存资源，防止重复加载；<br/>
	*错误重试：资源加载失败后，会重试加载（以最低优先级插入加载队列），retryNum设定加载失败后重试次数，retryDelay设定加载重试的时间间隔。</p>
	*@see laya.net.Loader
	*/
	//class laya.net.LoaderManager extends laya.events.EventDispatcher
	var LoaderManager=(function(_super){
		var ResInfo;
		function LoaderManager(){
			this.retryNum=1;
			this.retryDelay=0;
			this.maxLoader=5;
			this._loaders=[];
			this._loaderCount=0;
			this._resInfos=[];
			this._infoPool=[];
			this._maxPriority=5;
			this._failRes={};
			LoaderManager.__super.call(this);
			for (var i=0;i < this._maxPriority;i++)this._resInfos[i]=[];
		}

		__class(LoaderManager,'laya.net.LoaderManager',_super);
		var __proto=LoaderManager.prototype;
		/**
		*<p>根据clas类型创建一个未初始化资源的对象，随后进行异步加载，资源加载完成后，初始化对象的资源，并通过此对象派发 Event.LOADED 事件，事件回调参数值为此对象本身。套嵌资源的子资源会保留资源路径"?"后的部分。</p>
		*<p>如果url为数组，返回true；否则返回指定的资源类对象，可以通过侦听此对象的 Event.LOADED 事件来判断资源是否已经加载完毕。</p>
		*<p><b>注意：</b>cache参数只能对文件后缀为atlas的资源进行缓存控制，其他资源会忽略缓存，强制重新加载。</p>
		*@param url 资源地址或者数组。如果url和clas同时指定了资源类型，优先使用url指定的资源类型。参数形如：[{url:xx,clas:xx,priority:xx,params:xx},{url:xx,clas:xx,priority:xx,params:xx}]。
		*@param progress 资源加载进度回调，回调参数值为当前资源加载的进度信息(0-1)。
		*@param clas 资源类名。如果url和clas同时指定了资源类型，优先使用url指定的资源类型。参数形如：Texture。
		*@param type 资源类型。参数形如：Loader.IMAGE。
		*@param priority (default=1)加载的优先级，优先级高的优先加载。有0-4共5个优先级，0最高，4最低。
		*@param cache 是否缓存加载的资源。
		*@return 如果url为数组，返回true；否则返回指定的资源类对象。
		*/
		__proto.create=function(url,complete,progress,clas,params,priority,cache){
			(priority===void 0)&& (priority=1);
			(cache===void 0)&& (cache=true);
			if ((url instanceof Array)){
				var items=url;
				var itemCount=items.length;
				var loadedCount=0;
				if (progress){
					var progress2=Handler.create(progress.caller,progress.method,progress.args,false);
				}
				for (var i=0;i < itemCount;i++){
					var item=items[i];
					if ((typeof item=='string'))item=items[i]={url:item};
					item.progress=0;
					var progressHandler=progress ? Handler.create(null,onProgress,[item],false):null;
					var completeHandler=(progress || complete)? Handler.create(null,onComplete,[item]):null;
					this._create(item.url,completeHandler,progressHandler,item.clas || clas,item.params || params,item.priority || priority,cache);
				}
				function onComplete (item,content){
					loadedCount++;
					item.progress=1;
					if (loadedCount===itemCount && complete){
						complete.run();
					}
				}
				function onProgress (item,value){
					item.progress=value;
					var num=0;
					for (var j=0;j < itemCount;j++){
						var item1=items[j];
						num+=item1.progress;
					};
					var v=num / itemCount;
					progress2.runWith(v);
				}
				return true;
			}else return this._create(url,complete,progress,clas,params,priority,cache);
		}

		__proto._create=function(url,complete,progress,clas,params,priority,cache){
			(priority===void 0)&& (priority=1);
			(cache===void 0)&& (cache=true);
			url=URL.formatURL(url)
			var item=this.getRes(url);
			if (!item){
				var extension=Utils$1.getFileExtension(url);
				var creatItem=LoaderManager.createMap[extension];
				if (!clas)clas=creatItem[0];
				var type=creatItem[1];
				if (extension=="atlas"){
					this.load(url,complete,progress,type,priority,cache);
					}else {
					if (clas===Texture)type="htmlimage";
					item=clas ? new clas():null;
					if (item.hasOwnProperty("_loaded"))
						item._loaded=false;
					this.load(url,Handler.create(null,onLoaded),progress,type,priority,false,null,true);
					function onLoaded (data){
						item && item.onAsynLoaded.call(item,url,data,params);
						if (complete)complete.run();
						Laya.loader.event(url);
					}
					if (cache){
						this.cacheRes(url,item);
						item.url=url;
					}
				}
				}else {
				if (!item.hasOwnProperty("loaded")|| item.loaded){
					progress && progress.runWith(1);
					complete && complete.run();
					}else if (complete){
					Laya.loader._createListener(url,complete.caller,complete.method,complete.args,true,false);
				}
			}
			return item;
		}

		/**
		*<p>加载资源。资源加载错误时，本对象会派发 Event.ERROR 事件，事件回调参数值为加载出错的资源地址。</p>
		*<p>因为返回值为 LoaderManager 对象本身，所以可以使用如下语法：Laya.loader.load(...).load(...);</p>
		*@param url 要加载的单个资源地址或资源信息数组。比如：简单数组：["a.png","b.png"]；复杂数组[{url:"a.png",type:Loader.IMAGE,size:100,priority:1},{url:"b.json",type:Loader.JSON,size:50,priority:1}]。
		*@param complete 加载结束回调。根据url类型不同分为2种情况：1. url为String类型，也就是单个资源地址，如果加载成功，则回调参数值为加载完成的资源，否则为null；2. url为数组类型，指定了一组要加载的资源，如果全部加载成功，则回调参数值为true，否则为false。
		*@param progress 加载进度回调。回调参数值为当前资源的加载进度信息(0-1)。
		*@param type 资源类型。比如：Loader.IMAGE。
		*@param priority (default=1)加载的优先级，优先级高的优先加载。有0-4共5个优先级，0最高，4最低。
		*@param cache 是否缓存加载结果。
		*@param group 分组，方便对资源进行管理。
		*@param ignoreCache 是否忽略缓存，强制重新加载。
		*@return 此 LoaderManager 对象本身。
		*/
		__proto.load=function(url,complete,progress,type,priority,cache,group,ignoreCache){
			(priority===void 0)&& (priority=1);
			(cache===void 0)&& (cache=true);
			(ignoreCache===void 0)&& (ignoreCache=false);
			if ((url instanceof Array))return this._loadAssets(url,complete,progress,type,priority,cache,group);
			var content=Loader.getRes(url);
			if (content !=null){
				progress && progress.runWith(1);
				complete && complete.runWith(content);
				this._loaderCount || this.event("complete");
				}else {
				var info=LoaderManager._resMap[url];
				if (!info){
					info=this._infoPool.length ? this._infoPool.pop():new ResInfo();
					info.url=url;
					info.type=type;
					info.cache=cache;
					info.group=group;
					info.ignoreCache=ignoreCache;
					complete && info.on("complete",complete.caller,complete.method,complete.args);
					progress && info.on("progress",progress.caller,progress.method,progress.args);
					LoaderManager._resMap[url]=info;
					priority=priority < this._maxPriority ? priority :this._maxPriority-1;
					this._resInfos[priority].push(info);
					this._next();
					}else {
					complete && info._createListener("complete",complete.caller,complete.method,complete.args,false,false);
					progress && info._createListener("progress",progress.caller,progress.method,progress.args,false,false);
				}
			}
			return this;
		}

		__proto._next=function(){
			if (this._loaderCount >=this.maxLoader)return;
			for (var i=0;i < this._maxPriority;i++){
				var infos=this._resInfos[i];
				if (infos.length > 0){
					var info=infos.shift();
					if (info)return this._doLoad(info);
				}
			}
			this._loaderCount || this.event("complete");
		}

		__proto._doLoad=function(resInfo){
			this._loaderCount++;
			var loader=this._loaders.length ? this._loaders.pop():new Loader();
			loader.on("complete",null,onLoaded);
			loader.on("progress",null,function(num){
				resInfo.event("progress",num);
			});
			loader.on("error",null,function(msg){
				onLoaded(null);
			});
			var _this=this;
			function onLoaded (data){
				loader.offAll();
				loader._data=null;
				_this._loaders.push(loader);
				_this._endLoad(resInfo,(data instanceof Array)? [data] :data);
				_this._loaderCount--;
				_this._next();
			}
			loader.load(resInfo.url,resInfo.type,resInfo.cache,resInfo.group,resInfo.ignoreCache);
		}

		__proto._endLoad=function(resInfo,content){
			var url=resInfo.url;
			if (content==null){
				var errorCount=this._failRes[url] || 0;
				if (errorCount < this.retryNum){
					console.warn("[warn]Retry to load:",url);
					this._failRes[url]=errorCount+1;
					Laya.timer.once(this.retryDelay,this,this._addReTry,[resInfo],false);
					return;
					}else {
					console.warn("[error]Failed to load:",url);
					this.event("error",url);
				}
			}
			if (this._failRes[url])this._failRes[url]=0;
			delete LoaderManager._resMap[url];
			resInfo.event("complete",content);
			resInfo.offAll();
			this._infoPool.push(resInfo);
		}

		__proto._addReTry=function(resInfo){
			this._resInfos[this._maxPriority-1].push(resInfo);
			this._next();
		}

		/**
		*清理指定资源地址缓存。
		*@param url 资源地址。
		*@param forceDispose 是否强制销毁，有些资源是采用引用计数方式销毁，如果forceDispose=true，则忽略引用计数，直接销毁，比如Texture，默认为false
		*/
		__proto.clearRes=function(url,forceDispose){
			(forceDispose===void 0)&& (forceDispose=false);
			Loader.clearRes(url,forceDispose);
		}

		/**
		*获取指定资源地址的资源。
		*@param url 资源地址。
		*@return 返回资源。
		*/
		__proto.getRes=function(url){
			return Loader.getRes(url);
		}

		/**
		*缓存资源。
		*@param url 资源地址。
		*@param data 要缓存的内容。
		*/
		__proto.cacheRes=function(url,data){
			Loader.cacheRes(url,data);
		}

		/**
		*设置资源分组。
		*@param url 资源地址。
		*@param group 分组名
		*/
		__proto.setGroup=function(url,group){
			Loader.setGroup(url,group);
		}

		/**
		*根据分组清理资源。
		*@param group 分组名
		*/
		__proto.clearResByGroup=function(group){
			Loader.clearResByGroup(group);
		}

		/**清理当前未完成的加载，所有未加载的内容全部停止加载。*/
		__proto.clearUnLoaded=function(){
			for (var i=0;i < this._maxPriority;i++){
				var infos=this._resInfos[i];
				for (var j=infos.length-1;j >-1;j--){
					var info=infos[j];
					if (info){
						info.offAll();
						this._infoPool.push(info);
					}
				}
				infos.length=0;
			}
			this._loaderCount=0;
			LoaderManager._resMap={};
		}

		/**
		*根据地址集合清理掉未加载的内容
		*@param urls 资源地址集合
		*/
		__proto.cancelLoadByUrls=function(urls){
			if (!urls)return;
			for (var i=0,n=urls.length;i < n;i++){
				this.cancelLoadByUrl(urls[i]);
			}
		}

		/**
		*根据地址清理掉未加载的内容
		*@param url 资源地址
		*/
		__proto.cancelLoadByUrl=function(url){
			for (var i=0;i < this._maxPriority;i++){
				var infos=this._resInfos[i];
				for (var j=infos.length-1;j >-1;j--){
					var info=infos[j];
					if (info && info.url===url){
						infos[j]=null;
						info.offAll();
						this._infoPool.push(info);
					}
				}
			}
			if (LoaderManager._resMap[url])delete LoaderManager._resMap[url];
		}

		/**
		*@private
		*加载数组里面的资源。
		*@param arr 简单：["a.png","b.png"]，复杂[{url:"a.png",type:Loader.IMAGE,size:100,priority:1},{url:"b.json",type:Loader.JSON,size:50,priority:1}]*/
		__proto._loadAssets=function(arr,complete,progress,type,priority,cache,group){
			(priority===void 0)&& (priority=1);
			(cache===void 0)&& (cache=true);
			var itemCount=arr.length;
			var loadedCount=0;
			var totalSize=0;
			var items=[];
			var success=true;
			for (var i=0;i < itemCount;i++){
				var item=arr[i];
				if ((typeof item=='string'))item={url:item,type:type,size:1,priority:priority};
				if (!item.size)item.size=1;
				item.progress=0;
				totalSize+=item.size;
				items.push(item);
				var progressHandler=progress ? Handler.create(null,loadProgress,[item],false):null;
				var completeHandler=(complete || progress)? Handler.create(null,loadComplete,[item]):null;
				this.load(item.url,completeHandler,progressHandler,item.type,item.priority || 1,cache,item.group || group);
			}
			function loadComplete (item,content){
				loadedCount++;
				item.progress=1;
				if (!content)success=false;
				if (loadedCount===itemCount && complete){
					complete.runWith(success);
				}
			}
			function loadProgress (item,value){
				if (progress !=null){
					item.progress=value;
					var num=0;
					for (var j=0;j < items.length;j++){
						var item1=items[j];
						num+=item1.size *item1.progress;
					};
					var v=num / totalSize;
					progress.runWith(v);
				}
			}
			return this;
		}

		LoaderManager.cacheRes=function(url,data){
			Loader.cacheRes(url,data);
		}

		LoaderManager._resMap={};
		__static(LoaderManager,
		['createMap',function(){return this.createMap={atlas:[null,"atlas"]};}
		]);
		LoaderManager.__init$=function(){
			//class ResInfo extends laya.events.EventDispatcher
			ResInfo=(function(_super){
				function ResInfo(){
					this.url=null;
					this.type=null;
					this.cache=false;
					this.group=null;
					this.ignoreCache=false;
					ResInfo.__super.call(this);
				}
				__class(ResInfo,'',_super);
				return ResInfo;
			})(EventDispatcher)
		}

		return LoaderManager;
	})(EventDispatcher)


	/**
	*<code>Texture</code> 是一个纹理处理类。
	*/
	//class laya.resource.Texture extends laya.events.EventDispatcher
	var Texture=(function(_super){
		function Texture(bitmap,uv){
			//this.bitmap=null;
			//this.uv=null;
			this.offsetX=0;
			this.offsetY=0;
			this.sourceWidth=0;
			this.sourceHeight=0;
			//this._loaded=false;
			this._w=0;
			this._h=0;
			//this.$_GID=NaN;
			//this.url=null;
			this._uvID=0;
			Texture.__super.call(this);
			if (bitmap){
				bitmap.useNum++;
			}
			this.setTo(bitmap,uv);
		}

		__class(Texture,'laya.resource.Texture',_super);
		var __proto=Texture.prototype;
		/**
		*设置此对象的位图资源、UV数据信息。
		*@param bitmap 位图资源
		*@param uv UV数据信息
		*/
		__proto.setTo=function(bitmap,uv){
			this.bitmap=bitmap;
			this.uv=uv || Texture.DEF_UV;
			if (bitmap){
				this._w=bitmap.width;
				this._h=bitmap.height;
				this.sourceWidth=this.sourceWidth || this._w;
				this.sourceHeight=this.sourceHeight || this._h
				this._loaded=this._w > 0;
				var _this=this;
				if (this._loaded){
					RunDriver.addToAtlas && RunDriver.addToAtlas(_this);
					}else {
					var bm=bitmap;
					if ((bm instanceof laya.resource.HTMLImage )&& bm.image)
						bm.image.addEventListener('load',function(e){
						RunDriver.addToAtlas && RunDriver.addToAtlas(_this);
					},false);
				}
			}
		}

		/**@private 激活资源。*/
		__proto.active=function(){
			if(this.bitmap)this.bitmap.activeResource();
		}

		/**
		*销毁纹理（分直接销毁，跟计数销毁两种）。
		*@param forceDispose (default=false)true为强制销毁主纹理，false是通过计数销毁纹理。
		*/
		__proto.destroy=function(forceDispose){
			(forceDispose===void 0)&& (forceDispose=false);
			if (this.bitmap && (this.bitmap).useNum > 0){
				var temp=this.bitmap;
				if (forceDispose){
					this.bitmap=null;
					temp.dispose();
					(temp).useNum=0;
					}else {
					(temp).useNum--;
					if ((temp).useNum==0){
						this.bitmap=null;
						temp.dispose();
					}
				}
				if (this.url && this===Laya.loader.getRes(this.url))Laya.loader.clearRes(this.url,forceDispose);
				this._loaded=false;
			}
		}

		/**
		*加载指定地址的图片。
		*@param url 图片地址。
		*/
		__proto.load=function(url){
			var _$this=this;
			this._loaded=false;
			url=URL.customFormat(url);
			var fileBitmap=(this.bitmap || (this.bitmap=HTMLImage.create(url)));
			if (fileBitmap)fileBitmap.useNum++;
			var _this=this;
			fileBitmap.onload=function (){
				fileBitmap.onload=null;
				_this._loaded=true;
				_$this.sourceWidth=_$this._w=fileBitmap.width;
				_$this.sourceHeight=_$this._h=fileBitmap.height;
				_this.event("loaded",this);
				(RunDriver.addToAtlas)&& (RunDriver.addToAtlas(_this));
			};
		}

		/**@private */
		__proto.addTextureToAtlas=function(e){
			RunDriver.addTextureToAtlas(this);
		}

		/**
		*获取Texture上的某个区域的像素点
		*@param x
		*@param y
		*@param width
		*@param height
		*@return 返回像素点集合
		*/
		__proto.getPixels=function(x,y,width,height){
			if (Render.isWebGL){
				return RunDriver.getTexturePixels(this,x,y,width,height);
				}else {
				Browser.canvas.size(width,height);
				Browser.canvas.clear();
				Browser.context.drawTexture(this,-x,-y,this.width,this.height,0,0);
				var info=Browser.context.getImageData(0,0,width,height);
			}
			return info.data;
		}

		/**@private */
		__proto.onAsynLoaded=function(url,bitmap){
			if (bitmap)bitmap.useNum++;
			this.setTo(bitmap,this.uv);
		}

		/**激活并获取资源。*/
		__getset(0,__proto,'source',function(){
			if (!this.bitmap)return null;
			this.bitmap.activeResource();
			return this.bitmap.source;
		});

		/**
		*表示是否加载成功，只能表示初次载入成功（通常包含下载和载入）,并不能完全表示资源是否可立即使用（资源管理机制释放影响等）。
		*/
		__getset(0,__proto,'loaded',function(){
			return this._loaded;
		});

		/**
		*表示资源是否已释放。
		*/
		__getset(0,__proto,'released',function(){
			if (!this.bitmap)return true;
			return this.bitmap.released;
		});

		/**实际宽度。*/
		__getset(0,__proto,'width',function(){
			if (this._w)return this._w;
			return (this.uv && this.uv!==Texture.DEF_UV)? (this.uv[2]-this.uv[0])*this.bitmap.width :this.bitmap.width;
			},function(value){
			this._w=value;
			this.sourceWidth || (this.sourceWidth=value);
		});

		/**
		*通过外部设置是否启用纹理平铺(后面要改成在着色器里计算)
		*/
		/**
		*获取当前纹理是否启用了纹理平铺
		*/
		__getset(0,__proto,'repeat',function(){
			if (Render.isWebGL && this.bitmap){
				return this.bitmap.repeat;
			}
			return true;
			},function(value){
			if (value){
				if (Render.isWebGL && this.bitmap){
					this.bitmap.repeat=value;
					if (value){
						this.bitmap.enableMerageInAtlas=false;
					}
				}
			}
		});

		/**实际高度。*/
		__getset(0,__proto,'height',function(){
			if (this._h)return this._h;
			return (this.uv && this.uv!==Texture.DEF_UV)? (this.uv[5]-this.uv[1])*this.bitmap.height :this.bitmap.height;
			},function(value){
			this._h=value;
			this.sourceHeight || (this.sourceHeight=value);
		});

		/**
		*设置线性采样的状态（目前只能第一次绘制前设置false生效,来关闭线性采样）。
		*/
		/**
		*获取当前纹理是否启用了线性采样。
		*/
		__getset(0,__proto,'isLinearSampling',function(){
			return Render.isWebGL ? (this.bitmap.minFifter !=0x2600):true;
			},function(value){
			if (!value && Render.isWebGL){
				if (!value && (this.bitmap.minFifter==-1)&& (this.bitmap.magFifter==-1)){
					this.bitmap.minFifter=0x2600;
					this.bitmap.magFifter=0x2600;
					this.bitmap.enableMerageInAtlas=false;
				}
			}
		});

		Texture.moveUV=function(offsetX,offsetY,uv){
			for (var i=0;i < 8;i+=2){
				uv[i]+=offsetX;
				uv[i+1]+=offsetY;
			}
			return uv;
		}

		Texture.create=function(source,x,y,width,height,offsetX,offsetY,sourceWidth,sourceHeight){
			(offsetX===void 0)&& (offsetX=0);
			(offsetY===void 0)&& (offsetY=0);
			(sourceWidth===void 0)&& (sourceWidth=0);
			(sourceHeight===void 0)&& (sourceHeight=0);
			var btex=(source instanceof laya.resource.Texture );
			var uv=btex ? source.uv :Texture.DEF_UV;
			var bitmap=btex ? source.bitmap :source;
			var tex=new Texture(bitmap,null);
			if (bitmap.width && (x+width)> bitmap.width)width=bitmap.width-x;
			if (bitmap.height && (y+height)> bitmap.height)height=bitmap.height-y;
			tex.width=width;
			tex.height=height;
			tex.offsetX=offsetX;
			tex.offsetY=offsetY;
			tex.sourceWidth=sourceWidth || width;
			tex.sourceHeight=sourceHeight || height;
			var dwidth=1 / bitmap.width;
			var dheight=1 / bitmap.height;
			x *=dwidth;
			y *=dheight;
			width *=dwidth;
			height *=dheight;
			var u1=tex.uv[0],v1=tex.uv[1],u2=tex.uv[4],v2=tex.uv[5];
			var inAltasUVWidth=(u2-u1),inAltasUVHeight=(v2-v1);
			var oriUV=Texture.moveUV(uv[0],uv[1],[x,y,x+width,y,x+width,y+height,x,y+height]);
			tex.uv=[u1+oriUV[0] *inAltasUVWidth,v1+oriUV[1] *inAltasUVHeight,u2-(1-oriUV[2])*inAltasUVWidth,v1+oriUV[3] *inAltasUVHeight,u2-(1-oriUV[4])*inAltasUVWidth,v2-(1-oriUV[5])*inAltasUVHeight,u1+oriUV[6] *inAltasUVWidth,v2-(1-oriUV[7])*inAltasUVHeight];
			return tex;
		}

		Texture.createFromTexture=function(texture,x,y,width,height){
			var rect=Rectangle.TEMP.setTo(x-texture.offsetX,y-texture.offsetY,width,height);
			var result=rect.intersection(Texture._rect1.setTo(0,0,texture.width,texture.height),Texture._rect2);
			if (result)
				var tex=Texture.create(texture,result.x,result.y,result.width,result.height,result.x-rect.x,result.y-rect.y,width,height);
			else return null;
			tex.bitmap.useNum--;
			return tex;
		}

		Texture.DEF_UV=[0,0,1.0,0,1.0,1.0,0,1.0];
		Texture.INV_UV=[0,1,1.0,1,1.0,0.0,0,0.0];
		Texture._rect1=new Rectangle();
		Texture._rect2=new Rectangle();
		return Texture;
	})(EventDispatcher)


	/**
	*<code>TimeLine</code> 是一个用来创建时间轴动画的类。
	*/
	//class laya.utils.TimeLine extends laya.events.EventDispatcher
	var TimeLine=(function(_super){
		var tweenData;
		function TimeLine(){
			this._labelDic=null;
			this._tweenDic={};
			this._tweenDataList=[];
			this._endTweenDataList=null;
			this._currTime=0;
			this._lastTime=0;
			this._startTime=0;
			this._index=0;
			this._gidIndex=0;
			this._firstTweenDic={};
			this._startTimeSort=false;
			this._endTimeSort=false;
			this._loopKey=false;
			this.scale=1;
			this._frameRate=60;
			this._frameIndex=0;
			this._total=0;
			TimeLine.__super.call(this);
		}

		__class(TimeLine,'laya.utils.TimeLine',_super);
		var __proto=TimeLine.prototype;
		/**
		*控制一个对象，从当前点移动到目标点。
		*@param target 要控制的对象。
		*@param props 要控制对象的属性。
		*@param duration 对象TWEEN的时间。
		*@param ease 缓动类型
		*@param offset 相对于上一个对象，偏移多长时间（单位：毫秒）。
		*/
		__proto.to=function(target,props,duration,ease,offset){
			(offset===void 0)&& (offset=0);
			return this._create(target,props,duration,ease,offset,true);
		}

		/**
		*从 props 属性，缓动到当前状态。
		*@param target target 目标对象(即将更改属性值的对象)
		*@param props 要控制对象的属性
		*@param duration 对象TWEEN的时间
		*@param ease 缓动类型
		*@param offset 相对于上一个对象，偏移多长时间（单位：毫秒）
		*/
		__proto.from=function(target,props,duration,ease,offset){
			(offset===void 0)&& (offset=0);
			return this._create(target,props,duration,ease,offset,false);
		}

		/**@private */
		__proto._create=function(target,props,duration,ease,offset,isTo){
			var tTweenData=Pool.getItemByClass("tweenData",tweenData);
			tTweenData.isTo=isTo;
			tTweenData.type=0;
			tTweenData.target=target;
			tTweenData.duration=duration;
			tTweenData.data=props;
			tTweenData.startTime=this._startTime+offset;
			tTweenData.endTime=tTweenData.startTime+tTweenData.duration;
			tTweenData.ease=ease;
			this._startTime=Math.max(tTweenData.endTime,this._startTime);
			this._tweenDataList.push(tTweenData);
			this._startTimeSort=true;
			this._endTimeSort=true;
			return this;
		}

		/**
		*在时间队列中加入一个标签。
		*@param label 标签名称。
		*@param offset 标签相对于上个动画的偏移时间(单位：毫秒)。
		*/
		__proto.addLabel=function(label,offset){
			var tTweenData=Pool.getItemByClass("tweenData",tweenData);
			tTweenData.type=1;
			tTweenData.data=label;
			tTweenData.endTime=tTweenData.startTime=this._startTime+offset;
			this._labelDic || (this._labelDic={});
			this._labelDic[label]=tTweenData;
			this._tweenDataList.push(tTweenData);
			return this;
		}

		/**
		*移除指定的标签
		*@param label
		*/
		__proto.removeLabel=function(label){
			if (this._labelDic && this._labelDic[label]){
				var tTweenData=this._labelDic[label];
				if (tTweenData){
					var tIndex=this._tweenDataList.indexOf(tTweenData);
					if (tIndex >-1){
						this._tweenDataList.splice(tIndex,1);
					}
				}
				delete this._labelDic[label];
			}
		}

		/**
		*动画从整个动画的某一时间开始。
		*@param time(单位：毫秒)。
		*/
		__proto.gotoTime=function(time){
			if (this._tweenDataList==null || this._tweenDataList.length==0)return;
			var tTween;
			var tObject;
			for (var p in this._firstTweenDic){
				tObject=this._firstTweenDic[p];
				if (tObject){
					for (var tDataP in tObject){
						if (tObject.diyTarget.hasOwnProperty(tDataP)){
							tObject.diyTarget[tDataP]=tObject[tDataP];
						}
					}
				}
			}
			for (p in this._tweenDic){
				tTween=this._tweenDic[p];
				tTween.clear();
				delete this._tweenDic[p];
			}
			this._index=0;
			this._gidIndex=0;
			this._currTime=time;
			this._lastTime=Browser.now();
			var tTweenDataCopyList;
			if (this._endTweenDataList==null || this._endTimeSort){
				this._endTimeSort=false;
				this._endTweenDataList=tTweenDataCopyList=this._tweenDataList.concat();
				function Compare (paraA,paraB){
					if (paraA.endTime > paraB.endTime){
						return 1;
						}else if (paraA.endTime < paraB.endTime){
						return-1;
						}else {
						return 0;
					}
				}
				tTweenDataCopyList.sort(Compare);
				}else {
				tTweenDataCopyList=this._endTweenDataList
			};
			var tTweenData;
			for (var i=0,n=tTweenDataCopyList.length;i < n;i++){
				tTweenData=tTweenDataCopyList[i];
				if (tTweenData.type==0){
					if (time >=tTweenData.endTime){
						this._index=Math.max(this._index,i+1);
						var props=tTweenData.data;
						if (tTweenData.isTo){
							for (var tP in props){
								tTweenData.target[tP]=props[tP];
							}
						}
						}else {
						break ;
					}
				}
			}
			for (i=0,n=this._tweenDataList.length;i < n;i++){
				tTweenData=this._tweenDataList[i];
				if (tTweenData.type==0){
					if (time >=tTweenData.startTime && time < tTweenData.endTime){
						this._index=Math.max(this._index,i+1);
						this._gidIndex++;
						tTween=Pool.getItemByClass("tween",Tween);
						tTween._create(tTweenData.target,tTweenData.data,tTweenData.duration,tTweenData.ease,Handler.create(this,this._animComplete,[this._gidIndex]),0,false,tTweenData.isTo,true,false);
						tTween.setStartTime(this._currTime-(time-tTweenData.startTime));
						tTween._updateEase(this._currTime);
						tTween.gid=this._gidIndex;
						this._tweenDic[this._gidIndex]=tTween;
					}
				}
			}
		}

		/**
		*从指定的标签开始播。
		*@param Label 标签名。
		*/
		__proto.gotoLabel=function(Label){
			if (this._labelDic==null)return;
			var tLabelData=this._labelDic[Label];
			if (tLabelData)this.gotoTime(tLabelData.startTime);
		}

		/**
		*暂停整个动画。
		*/
		__proto.pause=function(){
			Laya.timer.clear(this,this._update);
		}

		/**
		*恢复暂停动画的播放。
		*/
		__proto.resume=function(){
			this.play(this._currTime,this._loopKey);
		}

		/**
		*播放动画。
		*@param timeOrLabel 开启播放的时间点或标签名。
		*@param loop 是否循环播放。
		*/
		__proto.play=function(timeOrLabel,loop){
			(timeOrLabel===void 0)&& (timeOrLabel=0);
			(loop===void 0)&& (loop=false);
			if (!this._tweenDataList)return;
			if (this._startTimeSort){
				this._startTimeSort=false;
				function Compare (paraA,paraB){
					if (paraA.startTime > paraB.startTime){
						return 1;
						}else if (paraA.startTime < paraB.startTime){
						return-1;
						}else {
						return 0;
					}
				}
				this._tweenDataList.sort(Compare);
				for (var i=0,n=this._tweenDataList.length;i < n;i++){
					var tTweenData=this._tweenDataList[i];
					if (tTweenData !=null && tTweenData.type==0){
						var tTarget=tTweenData.target;
						var gid=(tTarget.$_GID || (tTarget.$_GID=Utils$1.getGID()));
						var tSrcData=null;
						if (this._firstTweenDic[gid]==null){
							tSrcData={};
							tSrcData.diyTarget=tTarget;
							this._firstTweenDic[gid]=tSrcData;
							}else {
							tSrcData=this._firstTweenDic[gid];
						}
						for (var p in tTweenData.data){
							if (tSrcData[p]==null){
								tSrcData[p]=tTarget[p];
							}
						}
					}
				}
			}
			if ((typeof timeOrLabel=='string')){
				this.gotoLabel(timeOrLabel);
				}else {
				this.gotoTime(timeOrLabel);
			}
			this._loopKey=loop;
			this._lastTime=Browser.now();
			Laya.timer.frameLoop(1,this,this._update);
		}

		/**
		*更新当前动画。
		*/
		__proto._update=function(){
			if (this._currTime >=this._startTime){
				if (this._loopKey){
					this._complete();
					if (!this._tweenDataList)return;
					this.gotoTime(0);
					}else {
					for (var p in this._tweenDic){
						tTween=this._tweenDic[p];
						tTween.complete();
					}
					this._complete();
					this.pause();
					return;
				}
			};
			var tNow=Browser.now();
			var tFrameTime=tNow-this._lastTime;
			var tCurrTime=this._currTime+=tFrameTime *this.scale;
			this._lastTime=tNow;
			for (p in this._tweenDic){
				tTween=this._tweenDic[p];
				tTween._updateEase(tCurrTime);
			};
			var tTween;
			if (this._tweenDataList.length !=0 && this._index < this._tweenDataList.length){
				var tTweenData=this._tweenDataList[this._index];
				if (tCurrTime >=tTweenData.startTime){
					this._index++;
					if (tTweenData.type==0){
						this._gidIndex++;
						tTween=Pool.getItemByClass("tween",Tween);
						tTween._create(tTweenData.target,tTweenData.data,tTweenData.duration,tTweenData.ease,Handler.create(this,this._animComplete,[this._gidIndex]),0,false,tTweenData.isTo,true,false);
						tTween.setStartTime(tCurrTime);
						tTween.gid=this._gidIndex;
						this._tweenDic[this._gidIndex]=tTween;
						tTween._updateEase(tCurrTime);
						}else {
						this.event("label",tTweenData.data);
					}
				}
			}
		}

		/**
		*指定的动画索引处的动画播放完成后，把此动画从列表中删除。
		*@param index
		*/
		__proto._animComplete=function(index){
			var tTween=this._tweenDic[index];
			if (tTween)delete this._tweenDic[index];
		}

		/**@private */
		__proto._complete=function(){
			this.event("complete");
		}

		/**
		*重置所有对象，复用对象的时候使用。
		*/
		__proto.reset=function(){
			var p;
			if (this._labelDic){
				for (p in this._labelDic){
					delete this._labelDic[p];
				}
			};
			var tTween;
			for (p in this._tweenDic){
				tTween=this._tweenDic[p];
				tTween.clear();
				delete this._tweenDic[p];
			}
			for (p in this._firstTweenDic){
				delete this._firstTweenDic[p];
			}
			this._endTweenDataList=null;
			if (this._tweenDataList && this._tweenDataList.length){
				var i=0,len=0;
				len=this._tweenDataList.length;
				for (i=0;i < len;i++){
					if(this._tweenDataList[i])
						this._tweenDataList[i].destroy();
				}
			}
			this._tweenDataList.length=0;
			this._currTime=0;
			this._lastTime=0;
			this._startTime=0;
			this._index=0;
			this._gidIndex=0;
			this.scale=1;
			Laya.timer.clear(this,this._update);
		}

		/**
		*彻底销毁此对象。
		*/
		__proto.destroy=function(){
			this.reset();
			this._labelDic=null;
			this._tweenDic=null;
			this._tweenDataList=null;
			this._firstTweenDic=null;
		}

		/**
		*@private
		*设置帧索引
		*/
		/**
		*@private
		*得到帧索引
		*/
		__getset(0,__proto,'index',function(){
			return this._frameIndex;
			},function(value){
			this._frameIndex=value;
			this.gotoTime(this._frameIndex / this._frameRate *1000);
		});

		/**
		*得到总帧数。
		*/
		__getset(0,__proto,'total',function(){
			this._total=Math.floor(this._startTime / 1000 *this._frameRate);
			return this._total;
		});

		TimeLine.to=function(target,props,duration,ease,offset){
			(offset===void 0)&& (offset=0);
			return (new TimeLine()).to(target,props,duration,ease,offset);
		}

		TimeLine.from=function(target,props,duration,ease,offset){
			(offset===void 0)&& (offset=0);
			return (new TimeLine()).from(target,props,duration,ease,offset);
		}

		TimeLine.__init$=function(){
			//class tweenData
			tweenData=(function(){
				function tweenData(){
					this.type=0;
					this.isTo=true;
					this.startTime=NaN;
					this.endTime=NaN;
					this.target=null;
					this.duration=NaN;
					this.ease=null;
					this.data=null;
				}
				__class(tweenData,'');
				var __proto=tweenData.prototype;
				__proto.destroy=function(){
					this.target=null;
					this.ease=null;
					this.data=null;
					this.isTo=true;
					this.type=0;
					Pool.recover("tweenData",this);
				}
				return tweenData;
			})()
		}

		return TimeLine;
	})(EventDispatcher)


	/**
	*<code>AnimationPlayer</code> 类用于动画播放器。
	*/
	//class laya.ani.AnimationPlayer extends laya.events.EventDispatcher
	var AnimationPlayer=(function(_super){
		function AnimationPlayer(){
			this._destroyed=false;
			this._templet=null;
			this._currentTime=NaN;
			this._currentFrameTime=NaN;
			this._playStart=NaN;
			this._playEnd=NaN;
			this._playDuration=NaN;
			this._overallDuration=NaN;
			this._stopWhenCircleFinish=false;
			this._elapsedPlaybackTime=NaN;
			this._startUpdateLoopCount=NaN;
			this._currentAnimationClipIndex=0;
			this._currentKeyframeIndex=0;
			this._paused=false;
			this._cacheFrameRate=0;
			this._cacheFrameRateInterval=NaN;
			this._cachePlayRate=NaN;
			this._fullFrames=null;
			this.isCache=true;
			this.playbackRate=1.0;
			this.returnToZeroStopped=false;
			AnimationPlayer.__super.call(this);
			this._destroyed=false;
			this._currentAnimationClipIndex=-1;
			this._currentKeyframeIndex=-1;
			this._currentTime=0.0;
			this._overallDuration=Number.MAX_VALUE;
			this._stopWhenCircleFinish=false;
			this._elapsedPlaybackTime=0;
			this._startUpdateLoopCount=-1;
			this._cachePlayRate=1.0;
			this.cacheFrameRate=60;
			this.returnToZeroStopped=false;
		}

		__class(AnimationPlayer,'laya.ani.AnimationPlayer',_super);
		var __proto=AnimationPlayer.prototype;
		Laya.imps(__proto,{"laya.resource.IDestroy":true})
		/**
		*@private
		*/
		__proto._onTempletLoadedComputeFullKeyframeIndices=function(cachePlayRate,cacheFrameRate,templet){
			if (this._templet===templet && this._cachePlayRate===cachePlayRate && this._cacheFrameRate===cacheFrameRate)
				this._computeFullKeyframeIndices();
		}

		/**
		*@private
		*/
		__proto._computeFullKeyframeIndices=function(){
			var anifullFrames=this._fullFrames=[];
			var templet=this._templet;
			var cacheFrameInterval=this._cacheFrameRateInterval *this._cachePlayRate;
			for (var i=0,iNum=templet.getAnimationCount();i < iNum;i++){
				var aniFullFrame=[];
				for (var j=0,jNum=templet.getAnimation(i).nodes.length;j < jNum;j++){
					var node=templet.getAnimation(i).nodes[j];
					var frameCount=Math.floor(node.playTime / cacheFrameInterval+0.01);
					var nodeFullFrames=new Uint16Array(frameCount+1);
					var lastFrameIndex=-1;
					for (var n=0,nNum=node.keyFrame.length;n < nNum;n++){
						var keyFrame=node.keyFrame[n];
						var tm=keyFrame.startTime;
						var endTm=tm+keyFrame.duration+cacheFrameInterval;
						do {
							var frameIndex=Math.floor(tm / cacheFrameInterval+0.5);
							for (var k=lastFrameIndex+1;k < frameIndex;k++)
							nodeFullFrames[k]=n;
							lastFrameIndex=frameIndex;
							nodeFullFrames[frameIndex]=n;
							tm+=cacheFrameInterval;
						}while (tm <=endTm);
					}
					aniFullFrame.push(nodeFullFrames);
				}
				anifullFrames.push(aniFullFrame);
			}
		}

		/**
		*@private
		*/
		__proto._onAnimationTempletLoaded=function(){
			(this.destroyed)|| (this._calculatePlayDuration());
		}

		/**
		*@private
		*/
		__proto._calculatePlayDuration=function(){
			if (this.state!==0){
				var oriDuration=this._templet.getAniDuration(this._currentAnimationClipIndex);
				(this._playEnd===0)&& (this._playEnd=oriDuration);
				if (this._playEnd > oriDuration)
					this._playEnd=oriDuration;
				this._playDuration=this._playEnd-this._playStart;
			}
		}

		/**
		*@private
		*/
		__proto._setPlayParams=function(time,cacheFrameInterval){
			this._currentTime=time;
			this._currentKeyframeIndex=Math.floor((this.currentPlayTime)/ cacheFrameInterval+0.01);
			this._currentFrameTime=this._currentKeyframeIndex *cacheFrameInterval;
		}

		/**
		*@private
		*/
		__proto._setPlayParamsWhenStop=function(currentAniClipPlayDuration,cacheFrameInterval){
			this._currentTime=currentAniClipPlayDuration;
			this._currentKeyframeIndex=Math.floor(currentAniClipPlayDuration / cacheFrameInterval+0.01);
			this._currentFrameTime=this._currentKeyframeIndex *cacheFrameInterval;
			this._currentAnimationClipIndex=-1;
		}

		/**
		*@private
		*/
		__proto._update=function(elapsedTime){
			if (this._currentAnimationClipIndex===-1 || this._paused || !this._templet || !this._templet.loaded)
				return;
			var cacheFrameInterval=this._cacheFrameRateInterval *this._cachePlayRate;
			var time=0;
			(this._startUpdateLoopCount!==Stat.loopCount)&& (time=elapsedTime *this.playbackRate,this._elapsedPlaybackTime+=time);
			var currentAniClipPlayDuration=this.playDuration;
			if ((this._overallDuration!==0 && this._elapsedPlaybackTime >=this._overallDuration)|| (this._overallDuration===0 && this._elapsedPlaybackTime >=currentAniClipPlayDuration)){
				this._setPlayParamsWhenStop(currentAniClipPlayDuration,cacheFrameInterval);
				this.event("stopped");
				return;
			}
			time+=this._currentTime;
			if (currentAniClipPlayDuration > 0){
				if (time >=currentAniClipPlayDuration){
					do {
						time-=currentAniClipPlayDuration;
						if (this._stopWhenCircleFinish){
							this._setPlayParamsWhenStop(currentAniClipPlayDuration,cacheFrameInterval);
							this._stopWhenCircleFinish=false;
							this.event("stopped");
							return;
						}
						if (time < currentAniClipPlayDuration){
							this._setPlayParams(time,cacheFrameInterval);
							this.event("complete");
						}
					}while (time >=currentAniClipPlayDuration)
					}else {
					this._setPlayParams(time,cacheFrameInterval);
				}
				}else {
				if (this._stopWhenCircleFinish){
					this._setPlayParamsWhenStop(currentAniClipPlayDuration,cacheFrameInterval);
					this._stopWhenCircleFinish=false;
					this.event("stopped");
					return;
				}
				this._currentTime=this._currentFrameTime=this._currentKeyframeIndex=0;
				this.event("complete");
			}
		}

		/**
		*@private
		*/
		__proto._destroy=function(){
			this.offAll();
			this._templet=null;
			this._fullFrames=null;
			this._destroyed=true;
		}

		/**
		*播放动画。
		*@param index 动画索引。
		*@param playbackRate 播放速率。
		*@param duration 播放时长（0为1次,Number.MAX_VALUE为循环播放）。
		*@param playStart 播放的起始时间位置。
		*@param playEnd 播放的结束时间位置。（0为动画一次循环的最长结束时间位置）。
		*/
		__proto.play=function(index,playbackRate,overallDuration,playStart,playEnd){
			(index===void 0)&& (index=0);
			(playbackRate===void 0)&& (playbackRate=1.0);
			(overallDuration===void 0)&& (overallDuration=2147483647);
			(playStart===void 0)&& (playStart=0);
			(playEnd===void 0)&& (playEnd=0);
			if (!this._templet)
				throw new Error("AnimationPlayer:templet must not be null,maybe you need to set url.");
			if (overallDuration < 0 || playStart < 0 || playEnd < 0)
				throw new Error("AnimationPlayer:overallDuration,playStart and playEnd must large than zero.");
			if ((playEnd!==0)&& (playStart > playEnd))
				throw new Error("AnimationPlayer:start must less than end.");
			this._currentTime=0;
			this._currentFrameTime=0;
			this._elapsedPlaybackTime=0;
			this.playbackRate=playbackRate;
			this._overallDuration=overallDuration;
			this._playStart=playStart;
			this._playEnd=playEnd;
			this._paused=false;
			this._currentAnimationClipIndex=index;
			this._currentKeyframeIndex=0;
			this._startUpdateLoopCount=Stat.loopCount;
			this.event("played");
			if (this._templet.loaded)
				this._calculatePlayDuration();
			else
			this._templet.once("loaded",this,this._onAnimationTempletLoaded);
			this._update(0);
		}

		/**
		*播放动画。
		*@param index 动画索引。
		*@param playbackRate 播放速率。
		*@param duration 播放时长（0为1次,Number.MAX_VALUE为循环播放）。
		*@param playStartFrame 播放的原始起始帧率位置。
		*@param playEndFrame 播放的原始结束帧率位置。（0为动画一次循环的最长结束时间位置）。
		*/
		__proto.playByFrame=function(index,playbackRate,overallDuration,playStartFrame,playEndFrame,fpsIn3DBuilder){
			(index===void 0)&& (index=0);
			(playbackRate===void 0)&& (playbackRate=1.0);
			(overallDuration===void 0)&& (overallDuration=2147483647);
			(playStartFrame===void 0)&& (playStartFrame=0);
			(playEndFrame===void 0)&& (playEndFrame=0);
			(fpsIn3DBuilder===void 0)&& (fpsIn3DBuilder=30);
			var interval=1000.0 / fpsIn3DBuilder;
			this.play(index,playbackRate,overallDuration,playStartFrame *interval,playEndFrame *interval);
		}

		/**
		*停止播放当前动画
		*@param immediate 是否立即停止
		*/
		__proto.stop=function(immediate){
			(immediate===void 0)&& (immediate=true);
			if (immediate){
				this._currentTime=this._currentFrameTime=this._currentKeyframeIndex=0;
				this._currentAnimationClipIndex=-1;
				this.event("stopped");
				}else {
				this._stopWhenCircleFinish=true;
			}
		}

		/**
		*动画播放的结束时间位置。
		*@return 结束时间位置。
		*/
		__getset(0,__proto,'playEnd',function(){
			return this._playEnd;
		});

		/**
		*设置动画数据模板,注意：修改此值会有计算开销。
		*@param value 动画数据模板
		*/
		/**
		*获取动画数据模板
		*@param value 动画数据模板
		*/
		__getset(0,__proto,'templet',function(){
			return this._templet;
			},function(value){
			if (!this.state===0)
				this.stop(true);
			if (this._templet!==value){
				this._templet=value;
				if (value.loaded)
					this._computeFullKeyframeIndices();
				else
				value.once("loaded",this,this._onTempletLoadedComputeFullKeyframeIndices,[this._cachePlayRate,this._cacheFrameRate]);
			}
		});

		/**
		*动画播放的起始时间位置。
		*@return 起始时间位置。
		*/
		__getset(0,__proto,'playStart',function(){
			return this._playStart;
		});

		/**
		*获取动画播放一次的总时间
		*@return 动画播放一次的总时间
		*/
		__getset(0,__proto,'playDuration',function(){
			return this._playDuration;
		});

		/**
		*获取当前播放状态
		*@return 当前播放状态
		*/
		__getset(0,__proto,'state',function(){
			if (this._currentAnimationClipIndex===-1)
				return 0;
			if (this._paused)
				return 1;
			return 2;
		});

		/**
		*获取当前帧数
		*@return 当前帧数
		*/
		__getset(0,__proto,'currentKeyframeIndex',function(){
			return this._currentKeyframeIndex;
		});

		/**
		*获取动画播放的总总时间
		*@return 动画播放的总时间
		*/
		__getset(0,__proto,'overallDuration',function(){
			return this._overallDuration;
		});

		/**
		*获取当前帧时间，不包括重播时间
		*@return value 当前时间
		*/
		__getset(0,__proto,'currentFrameTime',function(){
			return this._currentFrameTime;
		});

		/**
		*获取当前动画索引
		*@return value 当前动画索引
		*/
		__getset(0,__proto,'currentAnimationClipIndex',function(){
			return this._currentAnimationClipIndex;
		});

		/**
		*获取当前精确时间，不包括重播时间
		*@return value 当前时间
		*/
		__getset(0,__proto,'currentPlayTime',function(){
			return this._currentTime+this._playStart;
		});

		/**
		*设置缓存播放速率,默认值为1.0,注意：修改此值会有计算开销。*
		*@return value 缓存播放速率。
		*/
		/**
		*获取缓存播放速率。*
		*@return 缓存播放速率。
		*/
		__getset(0,__proto,'cachePlayRate',function(){
			return this._cachePlayRate;
			},function(value){
			if (this._cachePlayRate!==value){
				this._cachePlayRate=value;
				if (this._templet)
					if (this._templet.loaded)
				this._computeFullKeyframeIndices();
				else
				this._templet.once("loaded",this,this._onTempletLoadedComputeFullKeyframeIndices,[value,this._cacheFrameRate]);
			}
		});

		/**
		*设置默认帧率,每秒60帧,注意：修改此值会有计算开销。*
		*@return value 缓存帧率
		*/
		/**
		*获取默认帧率*
		*@return value 默认帧率
		*/
		__getset(0,__proto,'cacheFrameRate',function(){
			return this._cacheFrameRate;
			},function(value){
			if (this._cacheFrameRate!==value){
				this._cacheFrameRate=value;
				this._cacheFrameRateInterval=1000.0 / this._cacheFrameRate;
				if (this._templet)
					if (this._templet.loaded)
				this._computeFullKeyframeIndices();
				else
				this._templet.once("loaded",this,this._onTempletLoadedComputeFullKeyframeIndices,[this._cachePlayRate,value]);
			}
		});

		/**
		*设置当前播放位置
		*@param value 当前时间
		*/
		__getset(0,__proto,'currentTime',null,function(value){
			if (this._currentAnimationClipIndex===-1 || !this._templet || !this._templet.loaded)
				return;
			if (value < this._playStart || value > this._playEnd)
				throw new Error("AnimationPlayer:value must large than playStartTime,small than playEndTime.");
			this._startUpdateLoopCount=Stat.loopCount;
			var cacheFrameInterval=this._cacheFrameRateInterval *this._cachePlayRate;
			this._currentTime=value;
			this._currentKeyframeIndex=Math.floor(this.currentPlayTime / cacheFrameInterval);
			this._currentFrameTime=this._currentKeyframeIndex *cacheFrameInterval;
		});

		/**
		*设置是否暂停
		*@param value 是否暂停
		*/
		/**
		*获取当前是否暂停
		*@return 是否暂停
		*/
		__getset(0,__proto,'paused',function(){
			return this._paused;
			},function(value){
			this._paused=value;
			value && this.event("paused");
		});

		/**
		*获取缓存帧率间隔时间
		*@return 缓存帧率间隔时间
		*/
		__getset(0,__proto,'cacheFrameRateInterval',function(){
			return this._cacheFrameRateInterval;
		});

		/**
		*获取是否已销毁。
		*@return 是否已销毁。
		*/
		__getset(0,__proto,'destroyed',function(){
			return this._destroyed;
		});

		return AnimationPlayer;
	})(EventDispatcher)


	/**
	*@private
	*<code>CSSStyle</code> 类是元素CSS样式定义类。
	*/
	//class laya.display.css.CSSStyle extends laya.display.css.Style
	var CSSStyle=(function(_super){
		function CSSStyle(ower){
			this._bgground=null;
			this._border=null;
			//this._ower=null;
			this._rect=null;
			this.lineHeight=0;
			CSSStyle.__super.call(this);
			this._padding=CSSStyle._PADDING;
			this._spacing=CSSStyle._SPACING;
			this._aligns=CSSStyle._ALIGNS;
			this._font=Font.EMPTY;
			this._ower=ower;
		}

		__class(CSSStyle,'laya.display.css.CSSStyle',_super);
		var __proto=CSSStyle.prototype;
		/**@inheritDoc */
		__proto.destroy=function(){
			this._ower=null;
			this._font=null;
			this._rect=null;
		}

		/**
		*复制传入的 CSSStyle 属性值。
		*@param src 待复制的 CSSStyle 对象。
		*/
		__proto.inherit=function(src){
			this._font=src._font;
			this._spacing=src._spacing===CSSStyle._SPACING ? CSSStyle._SPACING :src._spacing.slice();
			this.lineHeight=src.lineHeight;
		}

		/**@private */
		__proto._widthAuto=function(){
			return (this._type & 0x40000)!==0;
		}

		/**@inheritDoc */
		__proto.widthed=function(sprite){
			return (this._type & 0x8)!=0;
		}

		/**
		*@private
		*/
		__proto._calculation=function(type,value){
			if (value.indexOf('%')< 0)return false;
			var ower=this._ower;
			var parent=ower.parent;
			var rect=this._rect;
			function getValue (pw,w,nums){
				return (pw *nums[0]+w *nums[1]+nums[2]);
			}
			function onParentResize (type){
				var pw=parent.width,w=ower.width;
				rect.width && (ower.width=getValue(pw,w,rect.width));
				rect.height && (ower.height=getValue(pw,w,rect.height));
				rect.left && (ower.x=getValue(pw,w,rect.left));
				rect.top && (ower.y=getValue(pw,w,rect.top));
			}
			if (rect===null){
				parent._getCSSStyle()._type |=0x80000;
				parent.on("resize",this,onParentResize);
				this._rect=rect={input:{}};
			};
			var nums=value.split(' ');
			nums[0]=parseFloat(nums[0])/ 100;
			if (nums.length==1)
				nums[1]=nums[2]=0;
			else {
				nums[1]=parseFloat(nums[1])/ 100;
				nums[2]=parseFloat(nums[2]);
			}
			rect[type]=nums;
			rect.input[type]=value;
			onParentResize(type);
			return true;
		}

		/**
		*是否已设置高度。
		*@param sprite 显示对象 Sprite。
		*@return 一个Boolean 表示是否已设置高度。
		*/
		__proto.heighted=function(sprite){
			return (this._type & 0x2000)!=0;
		}

		/**
		*设置宽高。
		*@param w 宽度。
		*@param h 高度。
		*/
		__proto.size=function(w,h){
			var ower=this._ower;
			var resize=false;
			if (w!==-1 && w !=this._ower.width){
				this._type |=0x8;
				this._ower.width=w;
				resize=true;
			}
			if (h!==-1 && h !=this._ower.height){
				this._type |=0x2000;
				this._ower.height=h;
				resize=true;
			}
			if (resize){
				ower._layoutLater();
				(this._type & 0x80000)&& ower.event("resize",this);
			}
		}

		/**@private */
		__proto._getAlign=function(){
			return this._aligns[0];
		}

		/**@private */
		__proto._getValign=function(){
			return this._aligns[1];
		}

		/**@private */
		__proto._getCssFloat=function(){
			return (this._type & 0x8000)!=0 ? 0x8000 :0;
		}

		__proto._createFont=function(){
			return (this._type & 0x1000)? this._font :(this._type |=0x1000,this._font=new Font(this._font));
		}

		/**@inheritDoc */
		__proto.render=function(sprite,context,x,y){
			var w=sprite.width;
			var h=sprite.height;
			x-=sprite.pivotX;
			y-=sprite.pivotY;
			this._bgground && this._bgground.color !=null && context.ctx.fillRect(x,y,w,h,this._bgground.color);
			this._border && this._border.color && context.drawRect(x,y,w,h,this._border.color.strColor,this._border.size);
		}

		/**@inheritDoc */
		__proto.getCSSStyle=function(){
			return this;
		}

		/**
		*设置 CSS 样式字符串。
		*@param text CSS样式字符串。
		*/
		__proto.cssText=function(text){
			this.attrs(CSSStyle.parseOneCSS(text,';'));
		}

		/**
		*根据传入的属性名、属性值列表，设置此对象的属性值。
		*@param attrs 属性名与属性值列表。
		*/
		__proto.attrs=function(attrs){
			if (attrs){
				for (var i=0,n=attrs.length;i < n;i++){
					var attr=attrs[i];
					this[attr[0]]=attr[1];
				}
			}
		}

		/**@inheritDoc */
		__proto.setTransform=function(value){
			(value==='none')? (this._tf=Style._TF_EMPTY):this.attrs(CSSStyle.parseOneCSS(value,','));
		}

		/**
		*定义 X 轴、Y 轴移动转换。
		*@param x X 轴平移量。
		*@param y Y 轴平移量。
		*/
		__proto.translate=function(x,y){
			this._tf===Style._TF_EMPTY && (this._tf=new TransformInfo());
			this._tf.translateX=x;
			this._tf.translateY=y;
		}

		/**
		*定义 缩放转换。
		*@param x X 轴缩放值。
		*@param y Y 轴缩放值。
		*/
		__proto.scale=function(x,y){
			this._tf===Style._TF_EMPTY && (this._tf=new TransformInfo());
			this._tf.scaleX=x;
			this._tf.scaleY=y;
		}

		/**@private */
		__proto._enableLayout=function(){
			return (this._type & 0x2)===0 && (this._type & 0x4)===0;
		}

		/**
		*是否显示为块级元素。
		*/
		__getset(0,__proto,'block',_super.prototype._$get_block,function(value){
			value ? (this._type |=0x1):(this._type &=(~0x1));
		});

		/**
		*垂直对齐方式。
		*/
		__getset(0,__proto,'valign',function(){
			return CSSStyle._valigndef[this._aligns[1]];
			},function(value){
			this._aligns===CSSStyle._ALIGNS && (this._aligns=[0,0,0]);
			this._aligns[1]=CSSStyle._valigndef[value];
		});

		/**
		*高度。
		*/
		__getset(0,__proto,'height',null,function(h){
			this._type |=0x2000;
			if ((typeof h=='string')){
				if (this._calculation("height",h))return;
				h=parseInt(h);
			}
			this.size(-1,h);
		});

		/**
		*宽度。
		*/
		__getset(0,__proto,'width',null,function(w){
			this._type |=0x8;
			if ((typeof w=='string')){
				var offset=w.indexOf('auto');
				if (offset >=0){
					this._type |=0x40000;
					w=w.substr(0,offset);
				}
				if (this._calculation("width",w))return;
				w=parseInt(w);
			}
			this.size(w,-1);
		});

		/**
		*字体粗细。
		*/
		__getset(0,__proto,'fontWeight',function(){
			return this._font.weight;
			},function(value){
			this._createFont().weight=value;
		});

		/**
		*表示左边距。
		*/
		__getset(0,__proto,'left',null,function(value){
			var ower=this._ower;
			if (((typeof value=='string'))){
				if (value==="center")
					value="50% -50% 0";
				else if (value==="right")
				value="100% -100% 0";
				if (this._calculation("left",value))return;
				value=parseInt(value);
			}
			ower.x=value;
		});

		__getset(0,__proto,'_translate',null,function(value){
			this.translate(value[0],value[1]);
		});

		/**@inheritDoc */
		__getset(0,__proto,'absolute',function(){
			return (this._type & 0x4)!==0;
		});

		/**
		*表示上边距。
		*/
		__getset(0,__proto,'top',null,function(value){
			var ower=this._ower;
			if (((typeof value=='string'))){
				if (value==="middle")
					value="50% -50% 0";
				else if (value==="bottom")
				value="100% -100% 0";
				if (this._calculation("top",value))return;
				value=parseInt(value);
			}
			ower.y=value;
		});

		/**
		*水平对齐方式。
		*/
		__getset(0,__proto,'align',function(){
			return CSSStyle._aligndef[this._aligns[0]];
			},function(value){
			this._aligns===CSSStyle._ALIGNS && (this._aligns=[0,0,0]);
			this._aligns[0]=CSSStyle._aligndef[value];
		});

		/**
		*表示是否加粗。
		*/
		__getset(0,__proto,'bold',function(){
			return this._font.bold;
			},function(value){
			this._createFont().bold=value;
		});

		/**
		*边距信息。
		*/
		__getset(0,__proto,'padding',function(){
			return this._padding;
			},function(value){
			this._padding=value;
		});

		/**
		*行间距。
		*/
		__getset(0,__proto,'leading',function(){
			return this._spacing[1];
			},function(d){
			((typeof d=='string'))&& (d=parseInt(d+""));
			this._spacing===CSSStyle._SPACING && (this._spacing=[0,0]);
			this._spacing[1]=d;
		});

		/**
		*是否是行元素。
		*/
		__getset(0,__proto,'lineElement',function(){
			return (this._type & 0x10000)!=0;
			},function(value){
			value ? (this._type |=0x10000):(this._type &=(~0x10000));
		});

		/**
		*浮动方向。
		*/
		__getset(0,__proto,'cssFloat',function(){
			return (this._type & 0x8000)!=0 ? "right" :"left";
			},function(value){
			this.lineElement=false;
			value==="right" ? (this._type |=0x8000):(this._type &=(~0x8000));
		});

		/**
		*添加到文本的修饰。
		*/
		__getset(0,__proto,'textDecoration',function(){
			return this._font.decoration;
			},function(value){
			this._createFont().decoration=value;
		});

		/**
		*设置如何处理元素内的空白。
		*/
		__getset(0,__proto,'whiteSpace',function(){
			return (this._type & 0x20000)? "nowrap" :"";
			},function(type){
			type==="nowrap" && (this._type |=0x20000);
			type==="none" && (this._type &=~0x20000);
		});

		__getset(0,__proto,'background',null,function(value){
			if (!value){
				this._bgground=null;
				return;
			}
			this._bgground || (this._bgground={});
			this._bgground.color=value;
			this._ower.conchModel && this._ower.conchModel.bgColor(value);
			this._type |=0x4000;
			this._ower._renderType |=0x100;
		});

		/**
		*表示是否换行。
		*/
		__getset(0,__proto,'wordWrap',function(){
			return (this._type & 0x20000)===0;
			},function(value){
			value ? (this._type &=~0x20000):(this._type |=0x20000);
		});

		/**
		*字体颜色。
		*/
		__getset(0,__proto,'color',function(){
			return this._font.color;
			},function(value){
			this._createFont().color=value;
		});

		/**
		*<p>指定文本字段是否是密码文本字段。</p>
		*如果此属性的值为 true，则文本字段被视为密码文本字段，并使用星号而不是实际字符来隐藏输入的字符。如果为 false，则不会将文本字段视为密码文本字段。
		*/
		__getset(0,__proto,'password',function(){
			return this._font.password;
			},function(value){
			this._createFont().password=value;
		});

		/**
		*背景颜色。
		*/
		__getset(0,__proto,'backgroundColor',function(){
			return this._bgground ? this._bgground.color :null;
			},function(value){
			if (value==='none')this._bgground=null;
			else (this._bgground || (this._bgground={}),this._bgground.color=value);
			this._ower.conchModel && this._ower.conchModel.bgColor(value);
			this._ower._renderType |=0x100;
		});

		/**
		*字体信息。
		*/
		__getset(0,__proto,'font',function(){
			return this._font.toString();
			},function(value){
			this._createFont().set(value);
		});

		/**
		*文本的粗细。
		*/
		__getset(0,__proto,'weight',null,function(value){
			this._createFont().weight=value;
		});

		/**
		*间距。
		*/
		__getset(0,__proto,'letterSpacing',function(){
			return this._spacing[0];
			},function(d){
			((typeof d=='string'))&& (d=parseInt(d+""));
			this._spacing===CSSStyle._SPACING && (this._spacing=[0,0]);
			this._spacing[0]=d;
		});

		/**
		*字体大小。
		*/
		__getset(0,__proto,'fontSize',function(){
			return this._font.size;
			},function(value){
			this._createFont().size=value;
		});

		/**
		*表示是否为斜体。
		*/
		__getset(0,__proto,'italic',function(){
			return this._font.italic;
			},function(value){
			this._createFont().italic=value;
		});

		/**
		*字体系列。
		*/
		__getset(0,__proto,'fontFamily',function(){
			return this._font.family;
			},function(value){
			this._createFont().family=value;
		});

		/**
		*<p>描边宽度（以像素为单位）。</p>
		*默认值0，表示不描边。
		*@default 0
		*/
		__getset(0,__proto,'stroke',function(){
			return this._font.stroke[0];
			},function(value){
			if (this._createFont().stroke===Font._STROKE)this._font.stroke=[0,"#000000"];
			this._font.stroke[0]=value;
		});

		/**
		*<p>描边颜色，以字符串表示。</p>
		*@default "#000000";
		*/
		__getset(0,__proto,'strokeColor',function(){
			return this._font.stroke[1];
			},function(value){
			if (this._createFont().stroke===Font._STROKE)this._font.stroke=[0,"#000000"];
			this._font.stroke[1]=value;
		});

		/**
		*边框属性，比如border="5px solid red"
		*/
		__getset(0,__proto,'border',function(){
			return this._border ? this._border.value :"";
			},function(value){
			if (value=='none'){
				this._border=null;
				return;
			}
			this._border || (this._border={});
			this._border.value=value;
			var values=value.split(' ');
			this._border.color=Color.create(values[values.length-1]);
			if (values.length==1){
				this._border.size=1;
				this._border.type='solid';
				return;
			};
			var i=0;
			if (values[0].indexOf('px')> 0){
				this._border.size=parseInt(values[0]);
				i++;
			}else this._border.size=1;
			this._border.type=values[i];
			this._ower._renderType |=0x100;
		});

		/**
		*边框的颜色。
		*/
		__getset(0,__proto,'borderColor',function(){
			return (this._border && this._border.color)? this._border.color.strColor :null;
			},function(value){
			if (!value){
				this._border=null;
				return;
			}
			this._border || (this._border={size:1,type:'solid'});
			this._border.color=(value==null)? null :Color.create(value);
			this._ower.conchModel && this._ower.conchModel.border(this._border.color.strColor);
			this._ower._renderType |=0x100;
		});

		/**
		*元素的定位类型。
		*/
		__getset(0,__proto,'position',function(){
			return (this._type & 0x4)? "absolute" :"";
			},function(value){
			value=="absolute" ? (this._type |=0x4):(this._type &=~0x4);
		});

		/**
		*规定元素应该生成的框的类型。
		*/
		__getset(0,__proto,'display',null,function(value){
			switch (value){
				case '':
					this._type &=~0x2;
					this.visible=true;
					break ;
				case 'none':
					this._type |=0x2;
					this.visible=false;
					this._ower._layoutLater();
					break ;
				}
		});

		/**@inheritDoc */
		__getset(0,__proto,'paddingLeft',function(){
			return this.padding[3];
		});

		/**@inheritDoc */
		__getset(0,__proto,'paddingTop',function(){
			return this.padding[0];
		});

		__getset(0,__proto,'_scale',null,function(value){
			this._ower.scale(value[0],value[1]);
		});

		__getset(0,__proto,'_rotate',null,function(value){
			this._ower.rotation=value;
		});

		CSSStyle.parseOneCSS=function(text,clipWord){
			var out=[];
			var attrs=text.split(clipWord);
			var valueArray;
			for (var i=0,n=attrs.length;i < n;i++){
				var attr=attrs[i];
				var ofs=attr.indexOf(':');
				var name=attr.substr(0,ofs).replace(/^\s+|\s+$/g,'');
				if (name.length==0)
					continue ;
				var value=attr.substr(ofs+1).replace(/^\s+|\s+$/g,'');
				var one=[name,value];
				switch (name){
					case 'italic':
					case 'bold':
						one[1]=value=="true";
						break ;
					case 'line-height':
						one[0]='lineHeight';
						one[1]=parseInt(value);
						break ;
					case 'font-size':
						one[0]='fontSize';
						one[1]=parseInt(value);
						break ;
					case 'padding':
						valueArray=value.split(' ');
						valueArray.length > 1 || (valueArray[1]=valueArray[2]=valueArray[3]=valueArray[0]);
						one[1]=[parseInt(valueArray[0]),parseInt(valueArray[1]),parseInt(valueArray[2]),parseInt(valueArray[3])];
						break ;
					case 'rotate':
						one[0]="_rotate";
						one[1]=parseFloat(value);
						break ;
					case 'scale':
						valueArray=value.split(' ');
						one[0]="_scale";
						one[1]=[parseFloat(valueArray[0]),parseFloat(valueArray[1])];
						break ;
					case 'translate':
						valueArray=value.split(' ');
						one[0]="_translate";
						one[1]=[parseInt(valueArray[0]),parseInt(valueArray[1])];
						break ;
					default :
						(one[0]=CSSStyle._CSSTOVALUE[name])|| (one[0]=name);
					}
				out.push(one);
			}
			return out;
		}

		CSSStyle.parseCSS=function(text,uri){
			var one;
			while ((one=CSSStyle._parseCSSRegExp.exec(text))!=null){
				CSSStyle.styleSheets[one[1]]=CSSStyle.parseOneCSS(one[2],';');
			}
		}

		CSSStyle.EMPTY=new CSSStyle(null);
		CSSStyle._CSSTOVALUE={'letter-spacing':'letterSpacing','line-spacing':'lineSpacing','white-space':'whiteSpace','line-height':'lineHeight','scale-x':'scaleX','scale-y':'scaleY','translate-x':'translateX','translate-y':'translateY','font-family':'fontFamily','font-weight':'fontWeight','vertical-align':'valign','text-decoration':'textDecoration','background-color':'backgroundColor','border-color':'borderColor','float':'cssFloat'};
		CSSStyle._parseCSSRegExp=new RegExp("([\.\#]\\w+)\\s*{([\\s\\S]*?)}","g");
		CSSStyle._aligndef={'left':0,'center':1,'right':2,0:'left',1:'center',2:'right'};
		CSSStyle._valigndef={'top':0,'middle':1,'bottom':2,0:'top',1:'middle',2:'bottom'};
		CSSStyle.styleSheets={};
		CSSStyle.ALIGN_CENTER=1;
		CSSStyle.ALIGN_RIGHT=2;
		CSSStyle.VALIGN_MIDDLE=1;
		CSSStyle.VALIGN_BOTTOM=2;
		CSSStyle._CSS_BLOCK=0x1;
		CSSStyle._DISPLAY_NONE=0x2;
		CSSStyle._ABSOLUTE=0x4;
		CSSStyle._WIDTH_SET=0x8;
		CSSStyle._PADDING=[0,0,0,0];
		CSSStyle._RECT=[-1,-1,-1,-1];
		CSSStyle._SPACING=[0,0];
		CSSStyle._ALIGNS=[0,0,0];
		CSSStyle.ADDLAYOUTED=0x200;
		CSSStyle._NEWFONT=0x1000;
		CSSStyle._HEIGHT_SET=0x2000;
		CSSStyle._BACKGROUND_SET=0x4000;
		CSSStyle._FLOAT_RIGHT=0x8000;
		CSSStyle._LINE_ELEMENT=0x10000;
		CSSStyle._NOWARP=0x20000;
		CSSStyle._WIDTHAUTO=0x40000;
		CSSStyle._LISTERRESZIE=0x80000;
		return CSSStyle;
	})(Style)


	/**
	*本类用于模块间消息传递
	*@author ww
	*/
	//class ide.managers.Notice extends laya.events.EventDispatcher
	var Notice=(function(_super){
		function Notice(){
			Notice.__super.call(this);
		}

		__class(Notice,'ide.managers.Notice',_super);
		Notice.notify=function(type,data){
			Notice.I.event(type,data);
		}

		Notice.listen=function(type,_scope,fun,args,cancelBefore){
			(cancelBefore===void 0)&& (cancelBefore=false);
			if(cancelBefore)Notice.cancel(type,_scope,fun);
			Notice.I.on(type,_scope,fun,args);
		}

		Notice.cancel=function(type,_scope,fun){
			Notice.I.off(type,_scope,fun);
		}

		__static(Notice,
		['I',function(){return this.I=new Notice();}
		]);
		return Notice;
	})(EventDispatcher)


	/**
	*<p><code>ColorFilter</code> 是颜色滤镜。使用 ColorFilter 类可以将 4 x 5 矩阵转换应用于输入图像上的每个像素的 RGBA 颜色和 Alpha 值，以生成具有一组新的 RGBA 颜色和 Alpha 值的结果。该类允许饱和度更改、色相旋转、亮度转 Alpha 以及各种其他效果。您可以将滤镜应用于任何显示对象（即，从 Sprite 类继承的对象）。</p>
	*<p>注意：对于 RGBA 值，最高有效字节代表红色通道值，其后的有效字节分别代表绿色、蓝色和 Alpha 通道值。</p>
	*/
	//class laya.filters.ColorFilter extends laya.filters.Filter
	var ColorFilter=(function(_super){
		function ColorFilter(mat){
			//this._mat=null;
			//this._alpha=null;
			ColorFilter.__super.call(this);
			if (!mat){
				mat=[0.3,0.59,0.11,0,0,0.3,0.59,0.11,0,0,0.3,0.59,0.11,0,0,0,0,0,1,0];
			}
			this._mat=new Float32Array(16);
			this._alpha=new Float32Array(4);
			var j=0;
			var z=0;
			for (var i=0;i < 20;i++){
				if (i % 5 !=4){
					this._mat[j++]=mat[i];
					}else {
					this._alpha[z++]=mat[i];
				}
			}
			this._action=RunDriver.createFilterAction(0x20);
			this._action.data=this;
		}

		__class(ColorFilter,'laya.filters.ColorFilter',_super);
		var __proto=ColorFilter.prototype;
		Laya.imps(__proto,{"laya.filters.IFilter":true})
		/**
		*@private 通知微端
		*/
		__proto.callNative=function(sp){
			var t=sp._$P.cf=this;
			sp.conchModel && sp.conchModel.setFilterMatrix && sp.conchModel.setFilterMatrix(this._mat,this._alpha);
		}

		/**@private */
		__getset(0,__proto,'type',function(){
			return 0x20;
		});

		/**@private */
		__getset(0,__proto,'action',function(){
			return this._action;
		});

		return ColorFilter;
	})(Filter)


	/**
	*<code>UIEvent</code> 类用来定义UI组件类的事件类型。
	*/
	//class laya.ui.UIEvent extends laya.events.Event
	var UIEvent$1=(function(_super){
		function UIEvent(){UIEvent.__super.call(this);;
		};

		__class(UIEvent,'laya.ui.UIEvent',_super,'UIEvent$1');
		UIEvent.SHOW_TIP="showtip";
		UIEvent.HIDE_TIP="hidetip";
		return UIEvent;
	})(Event)


	/**
	*本类用于模块间消息传递
	*@author ww
	*/
	//class laya.debug.tools.Notice extends laya.events.EventDispatcher
	var Notice$1=(function(_super){
		function Notice(){
			Notice.__super.call(this);
		}

		__class(Notice,'laya.debug.tools.Notice',_super,'Notice$1');
		Notice.notify=function(type,data){
			Notice.I.event(type,data);
		}

		Notice.listen=function(type,_scope,fun,args,cancelBefore){
			(cancelBefore===void 0)&& (cancelBefore=false);
			if(cancelBefore)Notice.cancel(type,_scope,fun);
			Notice.I.on(type,_scope,fun,args);
		}

		Notice.cancel=function(type,_scope,fun){
			Notice.I.off(type,_scope,fun);
		}

		__static(Notice,
		['I',function(){return this.I=new Notice();}
		]);
		return Notice;
	})(EventDispatcher)


	/**
	*@private
	*/
	//class laya.ani.GraphicsAni extends laya.display.Graphics
	var GraphicsAni=(function(_super){
		function GraphicsAni(){
			GraphicsAni.__super.call(this);
			if (Render.isConchNode){
				this["drawSkin"]=function (skin){
					skin.transform || (skin.transform=Matrix.EMPTY);
					this.setSkinMesh&&this.setSkinMesh(skin._ps,skin.mVBData,skin.mEleNum,0,skin.mTexture,skin.transform);
				};
			}
		}

		__class(GraphicsAni,'laya.ani.GraphicsAni',_super);
		var __proto=GraphicsAni.prototype;
		/**
		*@private
		*画自定义蒙皮动画
		*@param skin
		*/
		__proto.drawSkin=function(skin){
			var arr=[skin];
			this._saveToCmd(Render._context._drawSkin,arr);
		}

		return GraphicsAni;
	})(Graphics)


	/**
	*<code>AutoBitmap</code> 类是用于表示位图图像或绘制图形的显示对象。
	*<p>封装了位置，宽高及九宫格的处理，供UI组件使用。</p>
	*/
	//class laya.ui.AutoBitmap extends laya.display.Graphics
	var AutoBitmap=(function(_super){
		function AutoBitmap(){
			this.autoCacheCmd=true;
			this._width=0;
			this._height=0;
			this._source=null;
			this._sizeGrid=null;
			this._isChanged=false;
			this._offset=null;
			AutoBitmap.__super.call(this);
		}

		__class(AutoBitmap,'laya.ui.AutoBitmap',_super);
		var __proto=AutoBitmap.prototype;
		/**@inheritDoc */
		__proto.destroy=function(){
			_super.prototype.destroy.call(this);
			this._source=null;
			this._sizeGrid=null;
			this._offset=null;
		}

		/**@private */
		__proto._setChanged=function(){
			if (!this._isChanged){
				this._isChanged=true;
				Laya.timer.callLater(this,this.changeSource);
			}
		}

		/**
		*@private
		*修改纹理资源。
		*/
		__proto.changeSource=function(){
			if (AutoBitmap.cacheCount++> 50)AutoBitmap.clearCache();
			this._isChanged=false;
			var source=this._source;
			if (!source || !source.bitmap)return;
			var width=this.width;
			var height=this.height;
			var sizeGrid=this._sizeGrid;
			var sw=source.sourceWidth;
			var sh=source.sourceHeight;
			if (!sizeGrid || (sw===width && sh===height)){
				this.cleanByTexture(source,this._offset ? this._offset[0] :0,this._offset ? this._offset[1] :0,width,height);
				}else {
				source.$_GID || (source.$_GID=Utils$1.getGID());
				var key=source.$_GID+"."+width+"."+height+"."+sizeGrid.join(".");
				if (AutoBitmap.cmdCaches[key]){
					this.cmds=AutoBitmap.cmdCaches[key];
					return;
				}
				this.clear();
				var top=sizeGrid[0];
				var right=sizeGrid[1];
				var bottom=sizeGrid[2];
				var left=sizeGrid[3];
				var repeat=sizeGrid[4];
				var needClip=false;
				if (left+right > width){
					var clipWidth=width;
					needClip=true;
					width=left+right;
				}
				if (needClip){
					this.save();
					this.clipRect(0,0,clipWidth,height);
				}
				left && top && this.drawTexture(AutoBitmap.getTexture(source,0,0,left,top),0,0,left,top);
				right && top && this.drawTexture(AutoBitmap.getTexture(source,sw-right,0,right,top),width-right,0,right,top);
				left && bottom && this.drawTexture(AutoBitmap.getTexture(source,0,sh-bottom,left,bottom),0,height-bottom,left,bottom);
				right && bottom && this.drawTexture(AutoBitmap.getTexture(source,sw-right,sh-bottom,right,bottom),width-right,height-bottom,right,bottom);
				top && this.drawBitmap(repeat,AutoBitmap.getTexture(source,left,0,sw-left-right,top),left,0,width-left-right,top);
				bottom && this.drawBitmap(repeat,AutoBitmap.getTexture(source,left,sh-bottom,sw-left-right,bottom),left,height-bottom,width-left-right,bottom);
				left && this.drawBitmap(repeat,AutoBitmap.getTexture(source,0,top,left,sh-top-bottom),0,top,left,height-top-bottom);
				right && this.drawBitmap(repeat,AutoBitmap.getTexture(source,sw-right,top,right,sh-top-bottom),width-right,top,right,height-top-bottom);
				this.drawBitmap(repeat,AutoBitmap.getTexture(source,left,top,sw-left-right,sh-top-bottom),left,top,width-left-right,height-top-bottom);
				if (needClip)this.restore();
				if (this.autoCacheCmd && !Render.isConchApp)AutoBitmap.cmdCaches[key]=this.cmds;
			}
			this._repaint();
		}

		__proto.drawBitmap=function(repeat,tex,x,y,width,height){
			(width===void 0)&& (width=0);
			(height===void 0)&& (height=0);
			if (width < 0.1 || height < 0.1)return;
			if (repeat && (tex.width!=width || tex.height !=height))this.fillTexture(tex,x,y,width,height);
			else this.drawTexture(tex,x,y,width,height);
		}

		__proto.clear=function(recoverCmds){
			(recoverCmds===void 0)&& (recoverCmds=true);
			_super.prototype.clear.call(this,false);
		}

		/**
		*当前实例的有效缩放网格数据。
		*<p>如果设置为null,则在应用任何缩放转换时，将正常缩放整个显示对象。</p>
		*<p>数据格式：[上边距,右边距,下边距,左边距,是否重复填充(值为0：不重复填充，1：重复填充)]。
		*<ul><li>例如：[4,4,4,4,1]</li></ul></p>
		*<p> <code>sizeGrid</code> 的值如下所示：
		*<ol>
		*<li>上边距</li>
		*<li>右边距</li>
		*<li>下边距</li>
		*<li>左边距</li>
		*<li>是否重复填充(值为0：不重复填充，1：重复填充)</li>
		*</ol></p>
		*<p>当定义 <code>sizeGrid</code> 属性时，该显示对象被分割到以 <code>sizeGrid</code> 数据中的"上边距,右边距,下边距,左边距" 组成的矩形为基础的具有九个区域的网格中，该矩形定义网格的中心区域。网格的其它八个区域如下所示：
		*<ul>
		*<li>矩形上方的区域</li>
		*<li>矩形外的右上角</li>
		*<li>矩形左侧的区域</li>
		*<li>矩形右侧的区域</li>
		*<li>矩形外的左下角</li>
		*<li>矩形下方的区域</li>
		*<li>矩形外的右下角</li>
		*<li>矩形外的左上角</li>
		*</ul>
		*同时也支持3宫格，比如0,4,0,4,1为水平3宫格，4,0,4,0,1为垂直3宫格，3宫格性能比9宫格高。
		*</p>
		*/
		__getset(0,__proto,'sizeGrid',function(){
			return this._sizeGrid;
			},function(value){
			this._sizeGrid=value;
			this._setChanged();
		});

		/**
		*表示显示对象的宽度，以像素为单位。
		*/
		__getset(0,__proto,'width',function(){
			if (this._width)return this._width;
			if (this._source)return this._source.sourceWidth;
			return 0;
			},function(value){
			if (this._width !=value){
				this._width=value;
				this._setChanged();
			}
		});

		/**
		*表示显示对象的高度，以像素为单位。
		*/
		__getset(0,__proto,'height',function(){
			if (this._height)return this._height;
			if (this._source)return this._source.sourceHeight;
			return 0;
			},function(value){
			if (this._height !=value){
				this._height=value;
				this._setChanged();
			}
		});

		/**
		*对象的纹理资源。
		*@see laya.resource.Texture
		*/
		__getset(0,__proto,'source',function(){
			return this._source;
			},function(value){
			if (value){
				this._source=value
				this._setChanged();
				}else {
				this._source=null;
				this.clear();
			}
		});

		AutoBitmap.getTexture=function(tex,x,y,width,height){
			if (width <=0)width=1;
			if (height <=0)height=1;
			tex.$_GID || (tex.$_GID=Utils$1.getGID())
			var key=tex.$_GID+"."+x+"."+y+"."+width+"."+height;
			var texture=AutoBitmap.textureCache[key];
			if (!texture){
				texture=AutoBitmap.textureCache[key]=Texture.createFromTexture(tex,x,y,width,height);
			}
			return texture;
		}

		AutoBitmap.clearCache=function(){
			AutoBitmap.cacheCount=0;
			AutoBitmap.cmdCaches={};
			AutoBitmap.textureCache={};
		}

		AutoBitmap.setCache=function(key,value){
			AutoBitmap.cacheCount++;
			AutoBitmap.textureCache[key]=value;
		}

		AutoBitmap.getCache=function(key){
			return AutoBitmap.textureCache[key];
		}

		AutoBitmap.cmdCaches={};
		AutoBitmap.cacheCount=0;
		AutoBitmap.textureCache={};
		return AutoBitmap;
	})(Graphics)


	//class laya.webgl.display.GraphicsGL extends laya.display.Graphics
	var GraphicsGL=(function(_super){
		function GraphicsGL(){
			GraphicsGL.__super.call(this);
		}

		__class(GraphicsGL,'laya.webgl.display.GraphicsGL',_super);
		var __proto=GraphicsGL.prototype;
		__proto.setShader=function(shader){
			this._saveToCmd(Render.context._setShader,[shader]);
		}

		__proto.setIBVB=function(x,y,ib,vb,numElement,shader){
			this._saveToCmd(Render.context._setIBVB,[x,y,ib,vb,numElement,shader]);
		}

		__proto.drawParticle=function(x,y,ps){
			var pt=RunDriver.createParticleTemplate2D(ps);
			pt.x=x;
			pt.y=y;
			this._saveToCmd(Render.context._drawParticle,[pt]);
		}

		return GraphicsGL;
	})(Graphics)


	//class laya.webgl.canvas.WebGLContext2D extends laya.resource.Context
	var WebGLContext2D=(function(_super){
		var ContextParams;
		function WebGLContext2D(c){
			this._x=0;
			this._y=0;
			this._id=++WebGLContext2D._COUNT;
			//this._other=null;
			this._path=null;
			//this._primitiveValue2D=null;
			this._drawCount=1;
			this._maxNumEle=0;
			this._clear=false;
			this._isMain=false;
			this._atlasResourceChange=0;
			this._submits=[];
			this._curSubmit=null;
			this._ib=null;
			this._vb=null;
			//this._curMat=null;
			this._nBlendType=0;
			//this._save=null;
			//this._targets=null;
			//this._renderKey=NaN;
			this._saveMark=null;
			//this.sprite=null;
			this.mId=-1;
			this.mHaveKey=false;
			this.mHaveLineKey=false;
			this.mX=0;
			this.mY=0;
			WebGLContext2D.__super.call(this);
			this._width=99999999;
			this._height=99999999;
			this._clipRect=WebGLContext2D.MAXCLIPRECT;
			this._shader2D=new Shader2D();
			this.mOutPoint
			this._canvas=c;
			this._curMat=Matrix.create();
			if (Render.isFlash){
				this._ib=IndexBuffer2D.create(0x88E4);
				GlUtils.fillIBQuadrangle(this._ib,16);
			}
			else
			this._ib=IndexBuffer2D.QuadrangleIB;
			this._vb=VertexBuffer2D.create(-1);
			this._other=ContextParams.DEFAULT;
			this._save=[SaveMark.Create(this)];
			this._save.length=10;
			this.clear();
		}

		__class(WebGLContext2D,'laya.webgl.canvas.WebGLContext2D',_super);
		var __proto=WebGLContext2D.prototype;
		__proto.setIsMainContext=function(){
			this._isMain=true;
		}

		__proto.clearBG=function(r,g,b,a){
			var gl=WebGL.mainContext;
			gl.clearColor(r,g,b,a);
			gl.clear(0x00004000);
		}

		__proto._getSubmits=function(){
			return this._submits;
		}

		__proto.destroy=function(){
			this.sprite=null;
			this._curMat && this._curMat.destroy();
			this._targets && this._targets.destroy();
			this._targets=null;
			for (var i=0,n=this._submits._length;i < n;i++)
			this._submits[i].releaseRender();
			this._submits.length=0;
			this._submits._length=0;
			this._curSubmit=null;
			this._path && this._path.recover();
			this._path=null;
			if (this._vb){
				this._vb.releaseResource();
				this._vb.dispose();
				this._vb.destory();
				this._vb=null;
			}
			this._canvas=null;
			this._ib && (this._ib !=IndexBuffer2D.QuadrangleIB)&& this._ib.releaseResource();
		}

		__proto.clear=function(){
			this._vb.clear();
			this._targets && (this._targets.repaint=true);
			this._other=ContextParams.DEFAULT;
			this._clear=true;
			this._repaint=false;
			this._drawCount=1;
			this._renderKey=0;
			this._other.lineWidth=this._shader2D.ALPHA=1.0;
			this._nBlendType=0;
			this._clipRect=WebGLContext2D.MAXCLIPRECT;
			this._curSubmit=Submit.RENDERBASE;
			this._shader2D.glTexture=null;
			this._shader2D.fillStyle=this._shader2D.strokeStyle=DrawStyle.DEFAULT;
			for (var i=0,n=this._submits._length;i < n;i++)
			this._submits[i].releaseRender();
			this._submits._length=0;
			this._curMat.identity();
			this._other.clear();
			this._saveMark=this._save[0];
			this._save._length=1;
		}

		__proto.size=function(w,h){
			if (this._width !=w || this._height !=h){
				if (w==0 || h==0){
					if (this._vb._byteLength !=0){
						this._width=w;
						this._height=h;
						this._vb.clear();
						this._vb.upload();
					}
					for (var i=0,n=this._submits._length;i < n;i++)
					this._submits[i].releaseRender();
					this._submits.length=0;
					this._submits._length=0;
					this._curSubmit=null;
					this._path && this._path.recover();
					this._path=null;
					this.sprite=null;
					this._targets && (this._targets.destroy());
					this._targets=null;
				}
				else{
					this._width=w;
					this._height=h;
					this._targets && (this._targets.size(w,h));
					this._canvas.memorySize-=this._canvas.memorySize;
				}
			}
		}

		__proto._getTransformMatrix=function(){
			return this._curMat;
		}

		__proto.translate=function(x,y){
			if (x!==0 || y!==0){
				SaveTranslate.save(this);
				if (this._curMat.bTransform){
					SaveTransform.save(this);
					this._curMat.transformPointN(Point.TEMP.setTo(x,y));
					x=Point.TEMP.x;
					y=Point.TEMP.y;
				}
				this._x+=x;
				this._y+=y;
			}
		}

		__proto.save=function(){
			this._save[this._save._length++]=SaveMark.Create(this);
		}

		__proto.restore=function(){
			var sz=this._save._length;
			if (sz < 1)
				return;
			for (var i=sz-1;i >=0;i--){
				var o=this._save[i];
				o.restore(this);
				if (o.isSaveMark()){
					this._save._length=i;
					return;
				}
			}
		}

		__proto._fillText=function(txt,words,x,y,fontStr,color,strokeColor,lineWidth,textAlign){
			var shader=this._shader2D;
			var curShader=this._curSubmit.shaderValue;
			var font=fontStr ? FontInContext.create(fontStr):this._other.font;
			if (AtlasResourceManager.enabled){
				if (shader.ALPHA!==curShader.ALPHA)
					shader.glTexture=null;
				DrawText.drawText(this,txt,words,this._curMat,font,textAlign || this._other.textAlign,color,strokeColor,lineWidth,x,y);
			}
			else{
				var preDef=this._shader2D.defines.getValue();
				var colorAdd=color ? Color.create(color)._color :shader.colorAdd;
				if (shader.ALPHA!==curShader.ALPHA || colorAdd!==shader.colorAdd || curShader.colorAdd!==shader.colorAdd){
					shader.glTexture=null;
					shader.colorAdd=colorAdd;
				}
				DrawText.drawText(this,txt,words,this._curMat,font,textAlign || this._other.textAlign,color,strokeColor,lineWidth,x,y);
			}
		}

		//shader.defines.setValue(preDef);
		__proto.fillWords=function(words,x,y,fontStr,color){
			this._fillText(null,words,x,y,fontStr,color,null,-1,null);
		}

		__proto.fillText=function(txt,x,y,fontStr,color,textAlign){
			this._fillText(txt,null,x,y,fontStr,color,null,-1,textAlign);
		}

		__proto.strokeText=function(txt,x,y,fontStr,color,lineWidth,textAlign){
			this._fillText(txt,null,x,y,fontStr,null,color,lineWidth || 1,textAlign);
		}

		__proto.fillBorderText=function(txt,x,y,fontStr,fillColor,borderColor,lineWidth,textAlign){
			this._fillBorderText(txt,null,x,y,fontStr,fillColor,borderColor,lineWidth,textAlign);
		}

		__proto._fillBorderText=function(txt,words,x,y,fontStr,fillColor,borderColor,lineWidth,textAlign){
			if (!AtlasResourceManager.enabled){
				this._fillText(txt,words,x,y,fontStr,null,borderColor,lineWidth || 1,textAlign);
				this._fillText(txt,words,x,y,fontStr,fillColor,null,-1,textAlign);
				return;
			};
			var shader=this._shader2D;
			var curShader=this._curSubmit.shaderValue;
			if (shader.ALPHA!==curShader.ALPHA)
				shader.glTexture=null;
			var font=fontStr ? (WebGLContext2D._fontTemp.setFont(fontStr),WebGLContext2D._fontTemp):this._other.font;
			DrawText.drawText(this,txt,words,this._curMat,font,textAlign || this._other.textAlign,fillColor,borderColor,lineWidth || 1,x,y);
		}

		__proto.fillBorderWords=function(words,x,y,font,color,borderColor,lineWidth){
			this._fillBorderText(null,words,x,y,font,color,borderColor,lineWidth,null);
		}

		__proto.fillRect=function(x,y,width,height,fillStyle){
			var vb=this._vb;
			if (GlUtils.fillRectImgVb(vb,this._clipRect,x,y,width,height,Texture.DEF_UV,this._curMat,this._x,this._y,0,0)){
				this._renderKey=0;
				var pre=this._shader2D.fillStyle;
				fillStyle && (this._shader2D.fillStyle=DrawStyle.create(fillStyle));
				var shader=this._shader2D;
				var curShader=this._curSubmit.shaderValue;
				if (shader.fillStyle!==curShader.fillStyle || shader.ALPHA!==curShader.ALPHA){
					shader.glTexture=null;
					var submit=this._curSubmit=Submit.create(this,this._ib,vb,((vb._byteLength-16 *4)/ 32)*3,Value2D.create(0x02,0));
					submit.shaderValue.color=shader.fillStyle._color._color;
					submit.shaderValue.ALPHA=shader.ALPHA;
					this._submits[this._submits._length++]=submit;
				}
				this._curSubmit._numEle+=6;
				this._shader2D.fillStyle=pre;
			}
		}

		__proto.fillTexture=function(texture,x,y,width,height,type,offset,other){
			if (!(texture.loaded && texture.bitmap && texture.source)){
				if (this.sprite){
					Laya.timer.callLater(this,this._repaintSprite);
				}
				return;
			};
			var vb=this._vb;
			var w=texture.bitmap.width,h=texture.bitmap.height,uv=texture.uv;
			var ox=offset.x % texture.width,oy=offset.y % texture.height;
			if (w!=other.w||h!=other.h){
				if (!other.w && !other.h){
					other.oy=other.ox=0;
					switch(type){
						case "repeat":
							other.width=width;
							other.height=height;
							break ;
						case "repeat-x":
							other.width=width;
							if (oy < 0){
								if (texture.height+oy > height){
									other.height=height;
								}
								else{
									other.height=texture.height+oy;
								}
							}
							else{
								other.oy=oy;
								if (texture.height+oy > height){
									other.height=height-oy;
								}
								else{
									other.height=texture.height;
								}
							}
							break ;
						case "repeat-y":
							if (ox < 0){
								if (texture.width+ox > width){
									other.width=width;
								}
								else{
									other.width=texture.width+ox;
								}
							}
							else{
								other.ox=ox;
								if (texture.width+ox > width){
									other.width=width-ox;
								}
								else{
									other.width=texture.width;
								}
							}
							other.height=height;
							break ;
						default :
							other.width=width;
							other.height=height;
							break ;
						}
				}
				other.w=w;
				other.h=h;
				other.uv=[0,0,other.width / w,0,other.width / w,other.height / h,0,other.height / h];
			}
			x+=other.ox;
			y+=other.oy;
			ox-=other.ox;
			oy-=other.oy;
			if (GlUtils.fillRectImgVb(vb,this._clipRect,x,y,other.width,other.height,other.uv,this._curMat,this._x,this._y,0,0)){
				this._renderKey=0;
				var submit=SubmitTexture.create(this,this._ib,vb,((vb._byteLength-16 *4)/ 32)*3,Value2D.create(0x100,0));
				this._submits[this._submits._length++]=submit;
				var shaderValue=submit.shaderValue;
				shaderValue.textureHost=texture;
				var tTextureX=uv[0] *w;
				var tTextureY=uv[1] *h;
				var tTextureW=(uv[2]-uv[0])*w;
				var tTextureH=(uv[5]-uv[3])*h;
				var tx=-ox / w;
				var ty=-oy/ h;
				shaderValue.u_TexRange[0]=tTextureX / w;
				shaderValue.u_TexRange[1]=tTextureW / w;
				shaderValue.u_TexRange[2]=tTextureY / h;
				shaderValue.u_TexRange[3]=tTextureH / h;
				shaderValue.u_offset[0]=tx;
				shaderValue.u_offset[1]=ty;
				if (AtlasResourceManager.enabled && !this._isMain)
					submit.addTexture(texture,(vb._byteLength >> 2)-16);
				this._curSubmit=submit;
				submit._renderType=10017;
				submit._numEle+=6;
			}
		}

		__proto.setShader=function(shader){
			SaveBase.save(this,0x80000,this._shader2D,true);
			this._shader2D.shader=shader;
		}

		__proto.setFilters=function(value){
			SaveBase.save(this,0x100000,this._shader2D,true);
			this._shader2D.filters=value;
			this._curSubmit=Submit.RENDERBASE;
			this._renderKey=0;
			this._drawCount++;
		}

		__proto.drawTexture=function(tex,x,y,width,height,tx,ty){
			this._drawTextureM(tex,x,y,width,height,tx,ty,null,1);
		}

		__proto.addTextureVb=function(invb,x,y){
			var finalVB=this._curSubmit._vb || this._vb;
			var vpos=(finalVB._byteLength >> 2);
			finalVB.byteLength=((vpos+16)<< 2);
			var vbdata=finalVB.getFloat32Array();
			for (var i=0,ci=0;i < 16;i+=4){
				vbdata[vpos++]=invb[i]+x;
				vbdata[vpos++]=invb[i+1]+y;
				vbdata[vpos++]=invb[i+2];
				vbdata[vpos++]=invb[i+3];
			}
			this._curSubmit._numEle+=6;
			this._maxNumEle=Math.max(this._maxNumEle,this._curSubmit._numEle);
			finalVB._upload=true;
		}

		__proto.willDrawTexture=function(tex,alpha){
			if (!(tex.loaded && tex.bitmap && tex.source)){
				if (this.sprite){
					Laya.timer.callLater(this,this._repaintSprite);
				}
				return 0;
			};
			var webGLImg=tex.bitmap;
			var rid=webGLImg.id+this._shader2D.ALPHA*alpha+10016;
			if (rid==this._renderKey)return rid;
			var shader=this._shader2D;
			var preAlpha=shader.ALPHA;
			var curShader=this._curSubmit.shaderValue;
			shader.ALPHA *=alpha;
			this._renderKey=rid;
			this._drawCount++;
			shader.glTexture=webGLImg;
			var vb=this._vb;
			var submit=null;
			var vbSize=(vb._byteLength / 32)*3;
			submit=SubmitTexture.create(this,this._ib,vb,vbSize,Value2D.create(0x01,0));
			this._submits[this._submits._length++]=submit;
			submit.shaderValue.textureHost=tex;
			submit._renderType=10016;
			submit._preIsSameTextureShader=this._curSubmit._renderType===10016 && shader.ALPHA===curShader.ALPHA;
			this._curSubmit=submit;
			shader.ALPHA=preAlpha;
			return rid;
		}

		__proto.drawTextures=function(tex,pos,tx,ty){
			if (!(tex.loaded && tex.bitmap && tex.source)){
				this.sprite && Laya.timer.callLater(this,this._repaintSprite);
				return;
			};
			var pre=this._clipRect;
			this._clipRect=WebGLContext2D.MAXCLIPRECT;
			if (!this._drawTextureM(tex,pos[0],pos[1],tex.width,tex.height,tx,ty,null,1)){
				alert("drawTextures err");
				return;
			}
			this._clipRect=pre;
			Stat.drawCall++;
			if (pos.length < 4)
				return;
			var finalVB=this._curSubmit._vb || this._vb;
			var sx=this._curMat.a,sy=this._curMat.d;
			for (var i=2,sz=pos.length;i < sz;i+=2){
				GlUtils.copyPreImgVb(finalVB,(pos[i]-pos[i-2])*sx,(pos[i+1]-pos[i-1])*sy);
				this._curSubmit._numEle+=6;
			}
			this._maxNumEle=Math.max(this._maxNumEle,this._curSubmit._numEle);
		}

		__proto._drawTextureM=function(tex,x,y,width,height,tx,ty,m,alpha){
			if (!(tex.loaded && tex.source)){
				if (this.sprite){
					Laya.timer.callLater(this,this._repaintSprite);
				}
				return false;
			};
			var finalVB=this._curSubmit._vb || this._vb;
			var webGLImg=tex.bitmap;
			x+=tx;
			y+=ty;
			this._drawCount++;
			var rid=webGLImg.id+this._shader2D.ALPHA *alpha+10016;
			if (rid!=this._renderKey){
				this._renderKey=rid;
				var curShader=this._curSubmit.shaderValue;
				var shader=this._shader2D;
				var alphaBack=shader.ALPHA;
				shader.ALPHA *=alpha;
				shader.glTexture=webGLImg;
				var vb=this._vb;
				var submit=null;
				var vbSize=(vb._byteLength / 32)*3;
				submit=SubmitTexture.create(this,this._ib,vb,vbSize,Value2D.create(0x01,0));
				this._submits[this._submits._length++]=submit;
				submit.shaderValue.textureHost=tex;
				submit._renderType=10016;
				submit._preIsSameTextureShader=this._curSubmit._renderType===10016 && shader.ALPHA===curShader.ALPHA;
				this._curSubmit=submit;
				finalVB=this._curSubmit._vb || this._vb;
				shader.ALPHA=alphaBack;
			}
			if (GlUtils.fillRectImgVb(finalVB,this._clipRect,x,y,width || tex.width,height || tex.height,tex.uv,m || this._curMat,this._x,this._y,0,0)){
				if (AtlasResourceManager.enabled && !this._isMain)
					(this._curSubmit).addTexture(tex,(finalVB._byteLength >> 2)-16);
				this._curSubmit._numEle+=6;
				this._maxNumEle=Math.max(this._maxNumEle,this._curSubmit._numEle);
				return true;
			}
			return false;
		}

		__proto._repaintSprite=function(){
			this.sprite.repaint();
		}

		//}
		__proto._drawText=function(tex,x,y,width,height,m,tx,ty,dx,dy){
			var webGLImg=tex.bitmap;
			this._drawCount++;
			var rid=webGLImg.id+this._shader2D.ALPHA+10016;
			if (rid!=this._renderKey){
				this._renderKey=rid;
				var curShader=this._curSubmit.shaderValue;
				var shader=this._shader2D;
				shader.glTexture=webGLImg;
				var vb=this._vb;
				var submit=null;
				var submitID=NaN;
				var vbSize=(vb._byteLength / 32)*3;
				if (AtlasResourceManager.enabled){
					submit=SubmitTexture.create(this,this._ib,vb,vbSize,Value2D.create(0x01,0));
				}
				else{
					submit=SubmitTexture.create(this,this._ib,vb,vbSize,TextSV.create());
				}
				submit._preIsSameTextureShader=this._curSubmit._renderType===10016 && shader.ALPHA===curShader.ALPHA;
				this._submits[this._submits._length++]=submit;
				submit.shaderValue.textureHost=tex;
				submit._renderType=10016;
				this._curSubmit=submit;
			}
			tex.active();
			var finalVB=this._curSubmit._vb || this._vb;
			if (GlUtils.fillRectImgVb(finalVB,this._clipRect,x+tx,y+ty,width || tex.width,height || tex.height,tex.uv,m || this._curMat,this._x,this._y,dx,dy,true)){
				if (AtlasResourceManager.enabled && !this._isMain){
					(this._curSubmit).addTexture(tex,(finalVB._byteLength >> 2)-16);
				}
				this._curSubmit._numEle+=6;
				this._maxNumEle=Math.max(this._maxNumEle,this._curSubmit._numEle);
			}
		}

		__proto.drawTextureWithTransform=function(tex,x,y,width,height,transform,tx,ty,alpha){
			if (!transform){
				this._drawTextureM(tex,x,y,width,height,tx,ty,null,alpha);
				return;
			};
			var curMat=this._curMat;
			var prex=this._x;
			var prey=this._y;
			(tx!==0 || ty!==0)&& (this._x=tx *curMat.a+ty *curMat.c,this._y=ty *curMat.d+tx *curMat.b);
			if (transform && curMat.bTransform){
				Matrix.mul(transform,curMat,WebGLContext2D._tmpMatrix);
				transform=WebGLContext2D._tmpMatrix;
				transform._checkTransform();
			}
			else{
				this._x+=curMat.tx;
				this._y+=curMat.ty;
			}
			this._drawTextureM(tex,x,y,width,height,0,0,transform,alpha);
			this._x=prex;
			this._y=prey;
		}

		__proto.fillQuadrangle=function(tex,x,y,point4,m){
			var submit=this._curSubmit;
			var vb=this._vb;
			var shader=this._shader2D;
			var curShader=submit.shaderValue;
			this._renderKey=0;
			if (tex.bitmap){
				var t_tex=tex.bitmap;
				if (shader.glTexture !=t_tex || shader.ALPHA!==curShader.ALPHA){
					shader.glTexture=t_tex;
					submit=this._curSubmit=Submit.create(this,this._ib,vb,((vb._byteLength)/ 32)*3,Value2D.create(0x01,0));
					submit.shaderValue.glTexture=t_tex;
					this._submits[this._submits._length++]=submit;
				}
				GlUtils.fillQuadrangleImgVb(vb,x,y,point4,tex.uv,m || this._curMat,this._x,this._y);
			}
			else{
				if (!submit.shaderValue.fillStyle || !submit.shaderValue.fillStyle.equal(tex)|| shader.ALPHA!==curShader.ALPHA){
					shader.glTexture=null;
					submit=this._curSubmit=Submit.create(this,this._ib,vb,((vb._byteLength)/ 32)*3,Value2D.create(0x02,0));
					submit.shaderValue.defines.add(0x02);
					submit.shaderValue.fillStyle=DrawStyle.create(tex);
					this._submits[this._submits._length++]=submit;
				}
				GlUtils.fillQuadrangleImgVb(vb,x,y,point4,Texture.DEF_UV,m || this._curMat,this._x,this._y);
			}
			submit._numEle+=6;
		}

		__proto.drawTexture2=function(x,y,pivotX,pivotY,transform,alpha,blendMode,args){
			if (alpha==0)return;
			var curMat=this._curMat;
			this._x=x *curMat.a+y *curMat.c;
			this._y=y *curMat.d+x *curMat.b;
			if (transform){
				if (curMat.bTransform || transform.bTransform){
					Matrix.mul(transform,curMat,WebGLContext2D._tmpMatrix);
					transform=WebGLContext2D._tmpMatrix;
				}
				else{
					this._x+=transform.tx+curMat.tx;
					this._y+=transform.ty+curMat.ty;
					transform=Matrix.EMPTY;
				}
			}
			if (alpha===1 && !blendMode)
				this._drawTextureM(args[0],args[1]-pivotX,args[2]-pivotY,args[3],args[4],0,0,transform,1);
			else{
				var preAlpha=this._shader2D.ALPHA;
				var preblendType=this._nBlendType;
				this._shader2D.ALPHA=alpha;
				blendMode && (this._nBlendType=BlendMode.TOINT(blendMode));
				this._drawTextureM(args[0],args[1]-pivotX,args[2]-pivotY,args[3],args[4],0,0,transform,1);
				this._shader2D.ALPHA=preAlpha;
				this._nBlendType=preblendType;
			}
			this._x=this._y=0;
		}

		__proto.drawCanvas=function(canvas,x,y,width,height){
			var src=canvas.context;
			this._renderKey=0;
			if (src._targets){
				this._submits[this._submits._length++]=SubmitCanvas.create(src,0,null);
				this._curSubmit=Submit.RENDERBASE;
				src._targets.drawTo(this,x,y,width,height);
			}
			else{
				var submit=this._submits[this._submits._length++]=SubmitCanvas.create(src,this._shader2D.ALPHA,this._shader2D.filters);
				var sx=width / canvas.width;
				var sy=height / canvas.height;
				var mat=submit._matrix;
				this._curMat.copyTo(mat);
				sx !=1 && sy !=1 && mat.scale(sx,sy);
				var tx=mat.tx,ty=mat.ty;
				mat.tx=mat.ty=0;
				mat.transformPoint(Point.TEMP.setTo(x,y));
				mat.translate(Point.TEMP.x+tx,Point.TEMP.y+ty);
				this._curSubmit=Submit.RENDERBASE;
			}
			if (Config.showCanvasMark){
				this.save();
				this.lineWidth=4;
				this.strokeStyle=src._targets ? "yellow" :"green";
				this.strokeRect(x-1,y-1,width+2,height+2,1);
				this.strokeRect(x,y,width,height,1);
				this.restore();
			}
		}

		__proto.drawTarget=function(scope,x,y,width,height,m,proName,shaderValue,uv,blend){
			(blend===void 0)&& (blend=-1);
			var vb=this._vb;
			if (GlUtils.fillRectImgVb(vb,this._clipRect,x,y,width,height,uv || Texture.DEF_UV,m || this._curMat,this._x,this._y,0,0)){
				this._renderKey=0;
				var shader=this._shader2D;
				shader.glTexture=null;
				var curShader=this._curSubmit.shaderValue;
				var submit=this._curSubmit=SubmitTarget.create(this,this._ib,vb,((vb._byteLength-16 *4)/ 32)*3,shaderValue,proName);
				if (blend==-1){
					submit.blendType=this._nBlendType;
				}
				else{
					submit.blendType=blend;
				}
				submit.scope=scope;
				this._submits[this._submits._length++]=submit;
				this._curSubmit._numEle+=6;
			}
		}

		__proto.transform=function(a,b,c,d,tx,ty){
			SaveTransform.save(this);
			Matrix.mul(Matrix.TEMP.setTo(a,b,c,d,tx,ty),this._curMat,this._curMat);
			this._curMat._checkTransform();
		}

		__proto.setTransformByMatrix=function(value){
			value.copyTo(this._curMat);
		}

		__proto.transformByMatrix=function(value){
			SaveTransform.save(this);
			Matrix.mul(value,this._curMat,this._curMat);
			this._curMat._checkTransform();
		}

		__proto.rotate=function(angle){
			SaveTransform.save(this);
			this._curMat.rotateEx(angle);
		}

		__proto.scale=function(scaleX,scaleY){
			SaveTransform.save(this);
			this._curMat.scaleEx(scaleX,scaleY);
		}

		__proto.clipRect=function(x,y,width,height){
			width *=this._curMat.a;
			height *=this._curMat.d;
			var p=Point.TEMP;
			this._curMat.transformPoint(p.setTo(x,y));
			this._renderKey=0;
			var submit=this._curSubmit=SubmitScissor.create(this);
			this._submits[this._submits._length++]=submit;
			submit.submitIndex=this._submits._length;
			submit.submitLength=9999999;
			SaveClipRect.save(this,submit);
			var clip=this._clipRect;
			var x1=clip.x,y1=clip.y;
			var r=p.x+width,b=p.y+height;
			x1 < p.x && (clip.x=p.x);
			y1 < p.y && (clip.y=p.y);
			clip.width=Math.min(r,x1+clip.width)-clip.x;
			clip.height=Math.min(b,y1+clip.height)-clip.y;
			this._shader2D.glTexture=null;
			submit.clipRect.copyFrom(clip);
			this._curSubmit=Submit.RENDERBASE;
		}

		__proto.setIBVB=function(x,y,ib,vb,numElement,mat,shader,shaderValues,startIndex,offset,type){
			(startIndex===void 0)&& (startIndex=0);
			(offset===void 0)&& (offset=0);
			(type===void 0)&& (type=0);
			if (ib===null){
				if (!Render.isFlash){
					ib=this._ib;
				}
				else{
					var falshVB=vb;
					(falshVB._selfIB)|| (falshVB._selfIB=IndexBuffer2D.create(0x88E4));
					falshVB._selfIB.clear();
					ib=falshVB._selfIB;
				}
				GlUtils.expandIBQuadrangle(ib,(vb.byteLength / (4 *vb.vertexStride *4)));
			}
			if (!shaderValues || !shader)
				throw Error("setIBVB must input:shader shaderValues");
			var submit=SubmitOtherIBVB.create(this,vb,ib,numElement,shader,shaderValues,startIndex,offset,type);
			mat || (mat=Matrix.EMPTY);
			mat.translate(x,y);
			Matrix.mul(mat,this._curMat,submit._mat);
			mat.translate(-x,-y);
			this._submits[this._submits._length++]=submit;
			this._curSubmit=Submit.RENDERBASE;
			this._renderKey=0;
		}

		__proto.addRenderObject=function(o){
			this._submits[this._submits._length++]=o;
		}

		__proto.fillTrangles=function(tex,x,y,points,m){
			var submit=this._curSubmit;
			var vb=this._vb;
			var shader=this._shader2D;
			var curShader=submit.shaderValue;
			var length=points.length >> 4;
			var t_tex=tex.bitmap;
			this._renderKey=0;
			if (shader.glTexture !=t_tex || shader.ALPHA!==curShader.ALPHA){
				submit=this._curSubmit=Submit.create(this,this._ib,vb,((vb._byteLength)/ 32)*3,Value2D.create(0x01,0));
				submit.shaderValue.textureHost=tex;
				this._submits[this._submits._length++]=submit;
			}
			GlUtils.fillTranglesVB(vb,x,y,points,m || this._curMat,this._x,this._y);
			submit._numEle+=length *6;
		}

		__proto.submitElement=function(start,end){
			var renderList=this._submits;
			end < 0 && (end=renderList._length);
			while (start < end){
				start+=renderList[start].renderSubmit();
			}
		}

		__proto.finish=function(){
			WebGL.mainContext.finish();
		}

		__proto.flush=function(){
			var maxNum=Math.max(this._vb.byteLength / (4 *16),this._maxNumEle / 6)+8;
			if (maxNum > (this._ib.bufferLength / (6 *2))){
				GlUtils.expandIBQuadrangle(this._ib,maxNum);
			}
			if (!this._isMain && AtlasResourceManager.enabled && AtlasResourceManager._atlasRestore > this._atlasResourceChange){
				this._atlasResourceChange=AtlasResourceManager._atlasRestore;
				var renderList=this._submits;
				for (var i=0,s=renderList._length;i < s;i++){
					var submit=renderList [i];
					if (submit.getRenderType()===10016)
						(submit).checkTexture();
				}
			}
			this.submitElement(0,this._submits._length);
			this._path && this._path.reset();
			SkinMeshBuffer.instance && SkinMeshBuffer.getInstance().reset();
			this._curSubmit=Submit.RENDERBASE;
			this._renderKey=0;
			return this._submits._length;
		}

		__proto.setPathId=function(id){
			this.mId=id;
			if (this.mId !=-1){
				this.mHaveKey=false;
				var tVGM=VectorGraphManager.getInstance();
				if (tVGM.shapeDic[this.mId]){
					this.mHaveKey=true;
				}
				this.mHaveLineKey=false;
				if (tVGM.shapeLineDic[this.mId]){
					this.mHaveLineKey=true;
				}
			}
		}

		__proto.movePath=function(x,y){
			var _x1=x,_y1=y;
			x=this._curMat.a *_x1+this._curMat.c *_y1+this._curMat.tx;
			y=this._curMat.b *_x1+this._curMat.d *_y1+this._curMat.ty;
			this.mX+=x;
			this.mY+=y;
		}

		__proto.beginPath=function(){
			var tPath=this._getPath();
			tPath.tempArray.length=0;
			tPath.closePath=false;
			this.mX=0;
			this.mY=0;
		}

		__proto.closePath=function(){
			this._path.closePath=true;
		}

		__proto.fill=function(isConvexPolygon){
			(isConvexPolygon===void 0)&& (isConvexPolygon=false);
			var tPath=this._getPath();
			this.drawPoly(0,0,tPath.tempArray,this.fillStyle._color.numColor,0,0,isConvexPolygon);
		}

		__proto.stroke=function(){
			var tPath=this._getPath();
			if (this.lineWidth > 0){
				if (this.mId==-1){
					tPath.drawLine(0,0,tPath.tempArray,this.lineWidth,this.strokeStyle._color.numColor);
				}
				else{
					if (this.mHaveLineKey){
						var tShapeLine=VectorGraphManager.getInstance().shapeLineDic[this.mId];
						tShapeLine.rebuild(tPath.tempArray);
						tPath.setGeomtry(tShapeLine);
					}
					else{
						VectorGraphManager.getInstance().addLine(this.mId,tPath.drawLine(0,0,tPath.tempArray,this.lineWidth,this.strokeStyle._color.numColor));
					}
				}
				tPath.update();
				var tPosArray=[this.mX,this.mY];
				var tempSubmit=Submit.createShape(this,tPath.ib,tPath.vb,tPath.count,tPath.offset,Value2D.create(0x04,0));
				tempSubmit.shaderValue.ALPHA=this._shader2D.ALPHA;
				(tempSubmit.shaderValue).u_pos=tPosArray;
				tempSubmit.shaderValue.u_mmat2=RenderState2D.TEMPMAT4_ARRAY;
				this._submits[this._submits._length++]=tempSubmit;
			}
		}

		__proto.line=function(fromX,fromY,toX,toY,lineWidth,mat){
			var submit=this._curSubmit;
			var vb=this._vb;
			if (GlUtils.fillLineVb(vb,this._clipRect,fromX,fromY,toX,toY,lineWidth,mat)){
				this._renderKey=0;
				var shader=this._shader2D;
				var curShader=submit.shaderValue;
				if (shader.strokeStyle!==curShader.strokeStyle || shader.ALPHA!==curShader.ALPHA){
					shader.glTexture=null;
					submit=this._curSubmit=Submit.create(this,this._ib,vb,((vb._byteLength-16 *4)/ 32)*3,Value2D.create(0x02,0));
					submit.shaderValue.strokeStyle=shader.strokeStyle;
					submit.shaderValue.mainID=0x02;
					submit.shaderValue.ALPHA=shader.ALPHA;
					this._submits[this._submits._length++]=submit;
				}
				submit._numEle+=6;
			}
		}

		__proto.moveTo=function(x,y,b){
			(b===void 0)&& (b=true);
			var tPath=this._getPath();
			if (b){
				var _x1=x,_y1=y;
				x=this._curMat.a *_x1+this._curMat.c *_y1;
				y=this._curMat.b *_x1+this._curMat.d *_y1;
			}
			tPath.addPoint(x,y);
		}

		__proto.lineTo=function(x,y,b){
			(b===void 0)&& (b=true);
			var tPath=this._getPath();
			if (b){
				var _x1=x,_y1=y;
				x=this._curMat.a *_x1+this._curMat.c *_y1;
				y=this._curMat.b *_x1+this._curMat.d *_y1;
			}
			tPath.addPoint(x,y);
		}

		__proto.drawCurves=function(x,y,args){
			this.setPathId(-1);
			this.beginPath();
			this.strokeStyle=args[3];
			this.lineWidth=args[4];
			var points=args[2];
			x+=args[0],y+=args[1];
			this.movePath(x,y);
			this.moveTo(points[0],points[1]);
			var i=2,n=points.length;
			while (i < n){
				this.quadraticCurveTo(points[i++],points[i++],points[i++],points[i++]);
			}
			this.stroke();
		}

		__proto.arcTo=function(x1,y1,x2,y2,r){
			if (this.mId !=-1){
				if (this.mHaveKey){
					return;
				}
			};
			var tPath=this._getPath();
			var x0=tPath.getEndPointX();
			var y0=tPath.getEndPointY();
			var dx0=NaN,dy0=NaN,dx1=NaN,dy1=NaN,a=NaN,d=NaN,cx=NaN,cy=NaN,a0=NaN,a1=NaN;
			var dir=false;
			var _x1=x1,_y1=y1;
			x1=this._curMat.a *_x1+this._curMat.c *_y1;
			y1=this._curMat.b *_x1+this._curMat.d *_y1;
			_x1=x2,_y1=y2;
			x2=this._curMat.a *_x1+this._curMat.c *_y1;
			y2=this._curMat.b *_x1+this._curMat.d *_y1;
			r=this._curMat.a *r+this._curMat.c *r;
			dx0=x0-x1;
			dy0=y0-y1;
			dx1=x2-x1;
			dy1=y2-y1;
			Point.TEMP.setTo(dx0,dy0);
			Point.TEMP.normalize();
			dx0=Point.TEMP.x;
			dy0=Point.TEMP.y;
			Point.TEMP.setTo(dx1,dy1);
			Point.TEMP.normalize();
			dx1=Point.TEMP.x;
			dy1=Point.TEMP.y;
			a=Math.acos(dx0 *dx1+dy0 *dy1);
			var tTemp=Math.tan(a / 2.0);
			d=r / tTemp;
			if (d > 10000){
				this.lineTo(x1,y1);
				return;
			}
			if (dx0 *dy1-dx1 *dy0 <=0.0){
				cx=x1+dx0 *d+dy0 *r;
				cy=y1+dy0 *d-dx0 *r;
				a0=Math.atan2(dx0,-dy0);
				a1=Math.atan2(-dx1,dy1);
				dir=false;
			}
			else{
				cx=x1+dx0 *d-dy0 *r;
				cy=y1+dy0 *d+dx0 *r;
				a0=Math.atan2(-dx0,dy0);
				a1=Math.atan2(dx1,-dy1);
				dir=true;
			}
			this.arc(cx,cy,r,a0,a1,dir,false);
		}

		__proto.arc=function(cx,cy,r,startAngle,endAngle,counterclockwise,b){
			(counterclockwise===void 0)&& (counterclockwise=false);
			(b===void 0)&& (b=true);
			if (this.mId !=-1){
				var tShape=VectorGraphManager.getInstance().shapeDic[this.mId];
				if (tShape){
					if (this.mHaveKey && !tShape.needUpdate(this._curMat))
						return;
				}
				cx=0;
				cy=0;
			};
			var a=0,da=0,hda=0,kappa=0;
			var dx=0,dy=0,x=0,y=0,tanx=0,tany=0;
			var px=0,py=0,ptanx=0,ptany=0;
			var i=0,ndivs=0,nvals=0;
			da=endAngle-startAngle;
			if (!counterclockwise){
				if (Math.abs(da)>=Math.PI *2){
					da=Math.PI *2;
				}
				else{
					while (da < 0.0){
						da+=Math.PI *2;
					}
				}
			}
			else{
				if (Math.abs(da)>=Math.PI *2){
					da=-Math.PI *2;
				}
				else{
					while (da > 0.0){
						da-=Math.PI *2;
					}
				}
			}
			if (r < 101){
				ndivs=Math.max(10,da *r / 5);
			}
			else if (r < 201){
				ndivs=Math.max(10,da *r / 20);
			}
			else{
				ndivs=Math.max(10,da *r / 40);
			}
			hda=(da / ndivs)/ 2.0;
			kappa=Math.abs(4 / 3 *(1-Math.cos(hda))/ Math.sin(hda));
			if (counterclockwise)
				kappa=-kappa;
			nvals=0;
			var tPath=this._getPath();
			var _x1=NaN,_y1=NaN;
			for (i=0;i <=ndivs;i++){
				a=startAngle+da *(i / ndivs);
				dx=Math.cos(a);
				dy=Math.sin(a);
				x=cx+dx *r;
				y=cy+dy *r;
				if (b){
					_x1=x,_y1=y;
					x=this._curMat.a *_x1+this._curMat.c *_y1;
					y=this._curMat.b *_x1+this._curMat.d *_y1;
				}
				if (x !=this._path.getEndPointX()|| y !=this._path.getEndPointY()){
					tPath.addPoint(x,y);
				}
			}
			dx=Math.cos(endAngle);
			dy=Math.sin(endAngle);
			x=cx+dx *r;
			y=cy+dy *r;
			if (b){
				_x1=x,_y1=y;
				x=this._curMat.a *_x1+this._curMat.c *_y1;
				y=this._curMat.b *_x1+this._curMat.d *_y1;
			}
			if (x !=this._path.getEndPointX()|| y !=this._path.getEndPointY()){
				tPath.addPoint(x,y);
			}
		}

		__proto.quadraticCurveTo=function(cpx,cpy,x,y){
			var tBezier=Bezier.I;
			var tResultArray=[];
			var _x1=x,_y1=y;
			x=this._curMat.a *_x1+this._curMat.c *_y1;
			y=this._curMat.b *_x1+this._curMat.d *_y1;
			_x1=cpx,_y1=cpy;
			cpx=this._curMat.a *_x1+this._curMat.c *_y1;
			cpy=this._curMat.b *_x1+this._curMat.d *_y1;
			var tArray=tBezier.getBezierPoints([this._path.getEndPointX(),this._path.getEndPointY(),cpx,cpy,x,y],30,2);
			for (var i=0,n=tArray.length / 2;i < n;i++){
				this.lineTo(tArray[i *2],tArray[i *2+1],false);
			}
			this.lineTo(x,y,false);
		}

		__proto.rect=function(x,y,width,height){
			this._other=this._other.make();
			this._other.path || (this._other.path=new Path());
			this._other.path.rect(x,y,width,height);
		}

		__proto.strokeRect=function(x,y,width,height,parameterLineWidth){
			var tW=parameterLineWidth *0.5;
			this.line(x-tW,y,x+width+tW,y,parameterLineWidth,this._curMat);
			this.line(x+width,y,x+width,y+height,parameterLineWidth,this._curMat);
			this.line(x,y,x,y+height,parameterLineWidth,this._curMat);
			this.line(x-tW,y+height,x+width+tW,y+height,parameterLineWidth,this._curMat);
		}

		__proto.clip=function(){}
		/**
		*画多边形(用)
		*@param x
		*@param y
		*@param points
		*/
		__proto.drawPoly=function(x,y,points,color,lineWidth,boderColor,isConvexPolygon){
			(isConvexPolygon===void 0)&& (isConvexPolygon=false);
			this._renderKey=0;
			this._shader2D.glTexture=null;
			var tPath=this._getPath();
			if (this.mId==-1){
				tPath.polygon(x,y,points,color,lineWidth ? lineWidth :1,boderColor)
			}
			else{
				if (this.mHaveKey){
					var tShape=VectorGraphManager.getInstance().shapeDic[this.mId];
					tShape.setMatrix(this._curMat);
					tShape.rebuild(tPath.tempArray);
					tPath.setGeomtry(tShape);
				}
				else{
					var t=tPath.polygon(x,y,points,color,lineWidth ? lineWidth :1,boderColor);
					VectorGraphManager.getInstance().addShape(this.mId,t);
					t.setMatrix(this._curMat);
				}
			}
			tPath.update();
			var tPosArray=[this.mX,this.mY];
			var tempSubmit;
			if (!isConvexPolygon){
				var submit=SubmitStencil.create(4);
				this.addRenderObject(submit);
				tempSubmit=Submit.createShape(this,tPath.ib,tPath.vb,tPath.count,tPath.offset,Value2D.create(0x04,0));
				tempSubmit.shaderValue.ALPHA=this._shader2D.ALPHA;
				(tempSubmit.shaderValue).u_pos=tPosArray;
				tempSubmit.shaderValue.u_mmat2=RenderState2D.EMPTYMAT4_ARRAY;
				this._submits[this._submits._length++]=tempSubmit;
				submit=SubmitStencil.create(5);
				this.addRenderObject(submit);
			}
			tempSubmit=Submit.createShape(this,tPath.ib,tPath.vb,tPath.count,tPath.offset,Value2D.create(0x04,0));
			tempSubmit.shaderValue.ALPHA=this._shader2D.ALPHA;
			(tempSubmit.shaderValue).u_pos=tPosArray;
			tempSubmit.shaderValue.u_mmat2=RenderState2D.EMPTYMAT4_ARRAY;
			this._submits[this._submits._length++]=tempSubmit;
			if (!isConvexPolygon){
				submit=SubmitStencil.create(3);
				this.addRenderObject(submit);
			}
			if (lineWidth > 0){
				if (this.mHaveLineKey){
					var tShapeLine=VectorGraphManager.getInstance().shapeLineDic[this.mId];
					tShapeLine.rebuild(tPath.tempArray);
					tPath.setGeomtry(tShapeLine);
				}
				else{
					VectorGraphManager.getInstance().addShape(this.mId,tPath.drawLine(x,y,points,lineWidth,boderColor));
				}
				tPath.update();
				tempSubmit=Submit.createShape(this,tPath.ib,tPath.vb,tPath.count,tPath.offset,Value2D.create(0x04,0));
				tempSubmit.shaderValue.ALPHA=this._shader2D.ALPHA;
				tempSubmit.shaderValue.u_mmat2=RenderState2D.EMPTYMAT4_ARRAY;
				this._submits[this._submits._length++]=tempSubmit;
			}
		}

		/*******************************************end矢量绘制***************************************************/
		__proto.drawParticle=function(x,y,pt){
			pt.x=x;
			pt.y=y;
			this._submits[this._submits._length++]=pt;
		}

		__proto._getPath=function(){
			return this._path || (this._path=new Path());
		}

		/*,_shader2D.ALPHA=1*/
		__getset(0,__proto,'globalCompositeOperation',function(){
			return BlendMode.NAMES[this._nBlendType];
			},function(value){
			var n=BlendMode.TOINT[value];
			n==null || (this._nBlendType===n)|| (SaveBase.save(this,0x10000,this,true),this._curSubmit=Submit.RENDERBASE,this._renderKey=0,this._nBlendType=n);
		});

		__getset(0,__proto,'strokeStyle',function(){
			return this._shader2D.strokeStyle;
			},function(value){
			this._shader2D.strokeStyle.equal(value)|| (SaveBase.save(this,0x200,this._shader2D,false),this._shader2D.strokeStyle=DrawStyle.create(value));
		});

		__getset(0,__proto,'globalAlpha',function(){
			return this._shader2D.ALPHA;
			},function(value){
			value=Math.floor(value *1000)/ 1000;
			if (value !=this._shader2D.ALPHA){
				SaveBase.save(this,0x1,this._shader2D,true);
				this._shader2D.ALPHA=value;
			}
		});

		//webGLCanvas为0;
		__getset(0,__proto,'asBitmap',null,function(value){
			if (value){
				this._targets || (this._targets=new RenderTargetMAX());
				this._targets.repaint=true;
				if (!this._width || !this._height)
					throw Error("asBitmap no size!");
				this._targets.setSP(this.sprite);
				this._targets.size(this._width,this._height);
			}
			else
			this._targets=null;
		});

		__getset(0,__proto,'fillStyle',function(){
			return this._shader2D.fillStyle;
			},function(value){
			this._shader2D.fillStyle.equal(value)|| (SaveBase.save(this,0x2,this._shader2D,false),this._shader2D.fillStyle=DrawStyle.create(value));
		});

		__getset(0,__proto,'textAlign',function(){
			return this._other.textAlign;
			},function(value){
			(this._other.textAlign===value)|| (this._other=this._other.make(),SaveBase.save(this,0x8000,this._other,false),this._other.textAlign=value);
		});

		__getset(0,__proto,'lineWidth',function(){
			return this._other.lineWidth;
			},function(value){
			(this._other.lineWidth===value)|| (this._other=this._other.make(),SaveBase.save(this,0x100,this._other,false),this._other.lineWidth=value);
		});

		__getset(0,__proto,'textBaseline',function(){
			return this._other.textBaseline;
			},function(value){
			(this._other.textBaseline===value)|| (this._other=this._other.make(),SaveBase.save(this,0x4000,this._other,false),this._other.textBaseline=value);
		});

		__getset(0,__proto,'font',null,function(str){
			if (str==this._other.font.toString())
				return;
			this._other=this._other.make();
			SaveBase.save(this,0x8,this._other,false);
			this._other.font===FontInContext.EMPTY ? (this._other.font=new FontInContext(str)):(this._other.font.setFont(str));
		});

		WebGLContext2D.__init__=function(){
			ContextParams.DEFAULT=new ContextParams();
		}

		WebGLContext2D._SUBMITVBSIZE=32000;
		WebGLContext2D._MAXSIZE=99999999;
		WebGLContext2D._RECTVBSIZE=16;
		WebGLContext2D.MAXCLIPRECT=new Rectangle(0,0,99999999,99999999);
		WebGLContext2D._COUNT=0;
		WebGLContext2D._tmpMatrix=new Matrix();
		__static(WebGLContext2D,
		['_fontTemp',function(){return this._fontTemp=new FontInContext();},'_drawStyleTemp',function(){return this._drawStyleTemp=new DrawStyle(null);}
		]);
		WebGLContext2D.__init$=function(){
			//class ContextParams
			ContextParams=(function(){
				function ContextParams(){
					this.lineWidth=1;
					this.path=null;
					this.textAlign=null;
					this.textBaseline=null;
					this.font=FontInContext.EMPTY;
				}
				__class(ContextParams,'');
				var __proto=ContextParams.prototype;
				__proto.clear=function(){
					this.lineWidth=1;
					this.path && this.path.clear();
					this.textAlign=this.textBaseline=null;
					this.font=FontInContext.EMPTY;
				}
				__proto.make=function(){
					return this===ContextParams.DEFAULT ? new ContextParams():this;
				}
				ContextParams.DEFAULT=null
				return ContextParams;
			})()
		}

		return WebGLContext2D;
	})(Context)


	//class laya.webgl.utils.RenderSprite3D extends laya.renders.RenderSprite
	var RenderSprite3D=(function(_super){
		function RenderSprite3D(type,next){
			RenderSprite3D.__super.call(this,type,next);
		}

		__class(RenderSprite3D,'laya.webgl.utils.RenderSprite3D',_super);
		var __proto=RenderSprite3D.prototype;
		__proto.onCreate=function(type){
			switch (type){
				case 0x08:
					this._fun=this._blend;
					return;
				case 0x04:
					this._fun=this._transform;
					return;
				}
		}

		__proto._mask=function(sprite,context,x,y){
			var next=this._next;
			var mask=sprite.mask;
			var submitCMD;
			var submitStencil;
			if (mask){
				context.ctx.save();
				var preBlendMode=(context.ctx).globalCompositeOperation;
				var tRect=new Rectangle();
				tRect.copyFrom(mask.getBounds());
				tRect.width=Math.round(tRect.width);
				tRect.height=Math.round(tRect.height);
				tRect.x=Math.round(tRect.x);
				tRect.y=Math.round(tRect.y);
				if (tRect.width > 0 && tRect.height > 0){
					var scope=SubmitCMDScope.create();
					scope.addValue("bounds",tRect);
					submitCMD=SubmitCMD.create([scope,context],laya.webgl.utils.RenderSprite3D.tmpTarget);
					context.addRenderObject(submitCMD);
					mask.render(context,-tRect.x,-tRect.y);
					submitCMD=SubmitCMD.create([scope],laya.webgl.utils.RenderSprite3D.endTmpTarget);
					context.addRenderObject(submitCMD);
					context.ctx.save();
					context.clipRect(x+tRect.x,y+tRect.y,tRect.width,tRect.height);
					next._fun.call(next,sprite,context,x,y);
					context.ctx.restore();
					submitStencil=SubmitStencil.create(6);
					preBlendMode=(context.ctx).globalCompositeOperation;
					submitStencil.blendMode="mask";
					context.addRenderObject(submitStencil);
					Matrix.TEMP.identity();
					var shaderValue=Value2D.create(0x01,0);
					var uv=Texture.INV_UV;
					var w=tRect.width;
					var h=tRect.height;
					var tempLimit=32;
					if (tRect.width < tempLimit || tRect.height < tempLimit){
						uv=RenderSprite3D.tempUV;
						uv[0]=0;
						uv[1]=0;
						uv[2]=(tRect.width >=32)? 1 :tRect.width/tempLimit;
						uv[3]=0
						uv[4]=(tRect.width >=32)? 1 :tRect.width/tempLimit;
						uv[5]=(tRect.height >=32)? 1 :tRect.height/tempLimit;
						uv[6]=0;
						uv[7]=(tRect.height >=32)? 1 :tRect.height/tempLimit;
						tRect.width=(tRect.width >=32)? tRect.width :tempLimit;
						tRect.height=(tRect.height >=32)? tRect.height :tempLimit;
						uv[1] *=-1;uv[3] *=-1;uv[5] *=-1;uv[7] *=-1;
						uv[1]+=1;uv[3]+=1;uv[5]+=1;uv[7]+=1;
					}
					(context.ctx).drawTarget(scope,x+tRect.x,y+tRect.y,w,h,Matrix.TEMP,"tmpTarget",shaderValue,uv,6);
					submitCMD=SubmitCMD.create([scope],laya.webgl.utils.RenderSprite3D.recycleTarget);
					context.addRenderObject(submitCMD);
					submitStencil=SubmitStencil.create(6);
					submitStencil.blendMode=preBlendMode;
					context.addRenderObject(submitStencil);
				}
				context.ctx.restore();
			}
			else{
				next._fun.call(next,sprite,context,x,y);
			}
		}

		__proto._blend=function(sprite,context,x,y){
			var style=sprite._style;
			var next=this._next;
			if (style.blendMode){
				context.ctx.save();
				context.ctx.globalCompositeOperation=style.blendMode;
				next._fun.call(next,sprite,context,x,y);
				context.ctx.restore();
			}
			else{
				next._fun.call(next,sprite,context,x,y);
			}
		}

		__proto._transform=function(sprite,context,x,y){
			'use strict';
			var transform=sprite.transform,_next=this._next;
			if (transform && _next !=RenderSprite.NORENDER){
				var ctx=context.ctx;
				var style=sprite._style;
				transform.tx=x;
				transform.ty=y;
				var m2=ctx._getTransformMatrix();
				var m1=m2.clone();
				Matrix.mul(transform,m2,m2);
				m2._checkTransform();
				transform.tx=transform.ty=0;
				_next._fun.call(_next,sprite,context,0,0);
				m1.copyTo(m2);
				m1.destroy();
				}else {
				_next._fun.call(_next,sprite,context,x,y);
			}
		}

		RenderSprite3D.tmpTarget=function(scope,context){
			var b=scope.getValue("bounds");
			var tmpTarget=RenderTarget2D.create(b.width,b.height);
			tmpTarget.start();
			tmpTarget.clear(0,0,0,0);
			scope.addValue("tmpTarget",tmpTarget);
		}

		RenderSprite3D.endTmpTarget=function(scope){
			var tmpTarget=scope.getValue("tmpTarget");
			tmpTarget.end();
		}

		RenderSprite3D.recycleTarget=function(scope){
			var tmpTarget=scope.getValue("tmpTarget");
			tmpTarget.recycle();
			scope.recycle();
		}

		__static(RenderSprite3D,
		['tempUV',function(){return this.tempUV=new Array(8);}
		]);
		return RenderSprite3D;
	})(RenderSprite)


	/**
	*@private
	*/
	//class laya.particle.ParticleTemplateWebGL extends laya.particle.ParticleTemplateBase
	var ParticleTemplateWebGL=(function(_super){
		function ParticleTemplateWebGL(parSetting){
			this._vertices=null;
			this._vertexBuffer=null;
			this._indexBuffer=null;
			this._floatCountPerVertex=29;
			this._firstActiveElement=0;
			this._firstNewElement=0;
			this._firstFreeElement=0;
			this._firstRetiredElement=0;
			this._currentTime=0;
			this._drawCounter=0;
			ParticleTemplateWebGL.__super.call(this);
			this.settings=parSetting;
		}

		__class(ParticleTemplateWebGL,'laya.particle.ParticleTemplateWebGL',_super);
		var __proto=ParticleTemplateWebGL.prototype;
		__proto.initialize=function(){
			this._vertices=new Float32Array(this.settings.maxPartices *this._floatCountPerVertex *4);
			var particleOffset=0;
			for (var i=0;i < this.settings.maxPartices;i++){
				var random=Math.random();
				var cornerYSegement=this.settings.textureCount ? 1.0 / this.settings.textureCount :1.0;
				var cornerY=NaN;
				for (cornerY=0;cornerY < this.settings.textureCount;cornerY+=cornerYSegement){
					if (random < cornerY+cornerYSegement)
						break ;
				}
				particleOffset=i *this._floatCountPerVertex *4;
				this._vertices[particleOffset+this._floatCountPerVertex *0+0]=-1;
				this._vertices[particleOffset+this._floatCountPerVertex *0+1]=-1;
				this._vertices[particleOffset+this._floatCountPerVertex *0+2]=0;
				this._vertices[particleOffset+this._floatCountPerVertex *0+3]=cornerY;
				this._vertices[particleOffset+this._floatCountPerVertex *1+0]=1;
				this._vertices[particleOffset+this._floatCountPerVertex *1+1]=-1;
				this._vertices[particleOffset+this._floatCountPerVertex *1+2]=1;
				this._vertices[particleOffset+this._floatCountPerVertex *1+3]=cornerY;
				this._vertices[particleOffset+this._floatCountPerVertex *2+0]=1;
				this._vertices[particleOffset+this._floatCountPerVertex *2+1]=1;
				this._vertices[particleOffset+this._floatCountPerVertex *2+2]=1;
				this._vertices[particleOffset+this._floatCountPerVertex *2+3]=cornerY+cornerYSegement;
				this._vertices[particleOffset+this._floatCountPerVertex *3+0]=-1;
				this._vertices[particleOffset+this._floatCountPerVertex *3+1]=1;
				this._vertices[particleOffset+this._floatCountPerVertex *3+2]=0;
				this._vertices[particleOffset+this._floatCountPerVertex *3+3]=cornerY+cornerYSegement;
			}
		}

		__proto.loadContent=function(){}
		__proto.update=function(elapsedTime){
			this._currentTime+=elapsedTime / 1000;
			this.retireActiveParticles();
			this.freeRetiredParticles();
			if (this._firstActiveElement==this._firstFreeElement)
				this._currentTime=0;
			if (this._firstRetiredElement==this._firstActiveElement)
				this._drawCounter=0;
		}

		__proto.retireActiveParticles=function(){
			var epsilon=0.0001;
			var particleDuration=this.settings.duration;
			while (this._firstActiveElement !=this._firstNewElement){
				var offset=this._firstActiveElement *this._floatCountPerVertex *4;
				var index=offset+28;
				var particleAge=this._currentTime-this._vertices[index];
				particleAge *=(1.0+this._vertices[offset+27]);
				if (particleAge+epsilon < particleDuration)
					break ;
				this._vertices[index]=this._drawCounter;
				this._firstActiveElement++;
				if (this._firstActiveElement >=this.settings.maxPartices)
					this._firstActiveElement=0;
			}
		}

		__proto.freeRetiredParticles=function(){
			while (this._firstRetiredElement !=this._firstActiveElement){
				var age=this._drawCounter-this._vertices[this._firstRetiredElement *this._floatCountPerVertex *4+28];
				if (age < 3)
					break ;
				this._firstRetiredElement++;
				if (this._firstRetiredElement >=this.settings.maxPartices)
					this._firstRetiredElement=0;
			}
		}

		__proto.addNewParticlesToVertexBuffer=function(){}
		__proto.addParticleArray=function(position,velocity){
			var nextFreeParticle=this._firstFreeElement+1;
			if (nextFreeParticle >=this.settings.maxPartices)
				nextFreeParticle=0;
			if (nextFreeParticle===this._firstRetiredElement)
				return;
			var particleData=ParticleData.Create(this.settings,position,velocity,this._currentTime);
			var startIndex=this._firstFreeElement *this._floatCountPerVertex *4;
			for (var i=0;i < 4;i++){
				var j=0,offset=0;
				for (j=0,offset=4;j < 3;j++)
				this._vertices[startIndex+i *this._floatCountPerVertex+offset+j]=particleData.position[j];
				for (j=0,offset=7;j < 3;j++)
				this._vertices[startIndex+i *this._floatCountPerVertex+offset+j]=particleData.velocity[j];
				for (j=0,offset=10;j < 4;j++)
				this._vertices[startIndex+i *this._floatCountPerVertex+offset+j]=particleData.startColor[j];
				for (j=0,offset=14;j < 4;j++)
				this._vertices[startIndex+i *this._floatCountPerVertex+offset+j]=particleData.endColor[j];
				for (j=0,offset=18;j < 3;j++)
				this._vertices[startIndex+i *this._floatCountPerVertex+offset+j]=particleData.sizeRotation[j];
				for (j=0,offset=21;j < 2;j++)
				this._vertices[startIndex+i *this._floatCountPerVertex+offset+j]=particleData.radius[j];
				for (j=0,offset=23;j < 4;j++)
				this._vertices[startIndex+i *this._floatCountPerVertex+offset+j]=particleData.radian[j];
				this._vertices[startIndex+i *this._floatCountPerVertex+27]=particleData.durationAddScale;
				this._vertices[startIndex+i *this._floatCountPerVertex+28]=particleData.time;
			}
			this._firstFreeElement=nextFreeParticle;
		}

		return ParticleTemplateWebGL;
	})(ParticleTemplateBase)


	/**
	*
	*@private
	*/
	//class laya.particle.emitter.Emitter2D extends laya.particle.emitter.EmitterBase
	var Emitter2D=(function(_super){
		function Emitter2D(_template){
			this.setting=null;
			this._posRange=null;
			this._canvasTemplate=null;
			this._emitFun=null;
			Emitter2D.__super.call(this);
			this.template=_template;
		}

		__class(Emitter2D,'laya.particle.emitter.Emitter2D',_super);
		var __proto=Emitter2D.prototype;
		__proto.emit=function(){
			_super.prototype.emit.call(this);
			if(this._emitFun!=null)
				this._emitFun();
		}

		__proto.getRandom=function(value){
			return (Math.random()*2-1)*value;
		}

		__proto.webGLEmit=function(){
			var pos=new Float32Array(3);
			pos[0]=this.getRandom(this._posRange[0]);
			pos[1]=this.getRandom(this._posRange[1]);
			pos[2]=this.getRandom(this._posRange[2]);
			var v=new Float32Array(3);
			v[0]=0;
			v[1]=0;
			v[2]=0;
			this._particleTemplate.addParticleArray(pos,v);
		}

		__proto.canvasEmit=function(){
			var pos=new Float32Array(3);
			pos[0]=this.getRandom(this._posRange[0]);
			pos[1]=this.getRandom(this._posRange[1]);
			pos[2]=this.getRandom(this._posRange[2]);
			var v=new Float32Array(3);
			v[0]=0;
			v[1]=0;
			v[2]=0;
			this._particleTemplate.addParticleArray(pos,v);
		}

		__getset(0,__proto,'template',function(){
			return this._particleTemplate;
			},function(template){
			this._particleTemplate=template;
			if (!template){
				this._emitFun=null;
				this.setting=null;
				this._posRange=null;
			};
			this.setting=template.settings;
			this._posRange=this.setting.positionVariance;
			if((this._particleTemplate instanceof laya.particle.ParticleTemplate2D )){
				this._emitFun=this.webGLEmit;
			}else
			if((this._particleTemplate instanceof laya.particle.ParticleTemplateCanvas )){
				this._canvasTemplate=template;
				this._emitFun=this.canvasEmit;
			}
		});

		return Emitter2D;
	})(EmitterBase)


	/**
	*@private
	*Canvas版本的SkinMesh
	*/
	//class laya.ani.bone.canvasmesh.SkinMeshCanvas extends laya.ani.bone.canvasmesh.CanvasMeshRender
	var SkinMeshCanvas=(function(_super){
		function SkinMeshCanvas(){
			SkinMeshCanvas.__super.call(this);
			this.mesh=new MeshData();
		}

		__class(SkinMeshCanvas,'laya.ani.bone.canvasmesh.SkinMeshCanvas',_super);
		var __proto=SkinMeshCanvas.prototype;
		__proto.init2=function(texture,vs,ps,verticles,uvs){
			if (this.transform){
				this.transform=null;
			};
			var _ps;
			if (ps){
				_ps=ps;
				}else {
				_ps=[];
				_ps.push(0,1,3,3,1,2);
			}
			this.mesh.texture=texture;
			this.mesh.indexes=_ps;
			this.mesh.vertices=verticles;
			this.mesh.uvs=uvs;
		}

		__proto.render=function(context,x,y){
			if(!this.mesh.texture)return;
			if(!this.transform){
				this.transform=SkinMeshCanvas._tempMatrix;
				this.transform.identity();
				this.transform.translate(x,y);
				this.renderToContext(context);
				this.transform.translate(-x,-y);
				this.transform=null;
				}else{
				this.transform.translate(x,y);
				this.renderToContext(context);
				this.transform.translate(-x,-y);
			}
		}

		__static(SkinMeshCanvas,
		['_tempMatrix',function(){return this._tempMatrix=new Matrix();}
		]);
		return SkinMeshCanvas;
	})(CanvasMeshRender)


	/**
	*@private
	*/
	//class laya.particle.ParticleTemplateCanvas extends laya.particle.ParticleTemplateBase
	var ParticleTemplateCanvas=(function(_super){
		function ParticleTemplateCanvas(particleSetting){
			this._ready=false;
			this.textureList=[];
			this.particleList=[];
			this.pX=0;
			this.pY=0;
			this.activeParticles=[];
			this.deadParticles=[];
			this.iList=[];
			this._maxNumParticles=0;
			this.textureWidth=NaN;
			this.dTextureWidth=NaN;
			this.colorChange=true;
			this.step=1/60;
			this.canvasShader=new CanvasShader();
			ParticleTemplateCanvas.__super.call(this);
			this.settings=particleSetting;
			this._maxNumParticles=particleSetting.maxPartices;
			this.texture=new Texture();
			this.texture.on("loaded",this,this._textureLoaded);
			this.texture.load(particleSetting.textureName);
		}

		__class(ParticleTemplateCanvas,'laya.particle.ParticleTemplateCanvas',_super);
		var __proto=ParticleTemplateCanvas.prototype;
		__proto._textureLoaded=function(e){
			this.setTexture(this.texture);
			this._ready=true;
		}

		__proto.clear=function(clearTexture){
			(clearTexture===void 0)&& (clearTexture=true);
			this.deadParticles.length=0;
			this.activeParticles.length=0;
			this.textureList.length=0;
		}

		/**
		*设置纹理
		*@param texture
		*
		*/
		__proto.setTexture=function(texture){
			this.texture=texture;
			this.textureWidth=texture.width;
			this.dTextureWidth=1/this.textureWidth;
			this.pX=-texture.width*0.5;
			this.pY=-texture.height*0.5;
			this.textureList=ParticleTemplateCanvas.changeTexture(texture,this.textureList);
			this.particleList.length=0;
			this.deadParticles.length=0;
			this.activeParticles.length=0;
		}

		/**
		*创建一个粒子数据
		*@return
		*
		*/
		__proto._createAParticleData=function(position,velocity){
			this.canvasShader.u_EndVelocity=this.settings.endVelocity;
			this.canvasShader.u_Gravity=this.settings.gravity;
			this.canvasShader.u_Duration=this.settings.duration;
			var particle;
			particle=ParticleData.Create(this.settings,position,velocity,0);
			this.canvasShader.a_Position=particle.position;
			this.canvasShader.a_Velocity=particle.velocity;
			this.canvasShader.a_StartColor=particle.startColor;
			this.canvasShader.a_EndColor=particle.endColor;
			this.canvasShader.a_SizeRotation=particle.sizeRotation;
			this.canvasShader.a_Radius=particle.radius;
			this.canvasShader.a_Radian=particle.radian;
			this.canvasShader.a_AgeAddScale=particle.durationAddScale;
			this.canvasShader.oSize=this.textureWidth;
			var rst=new CMDParticle();
			var i=0,len=this.settings.duration/(1+particle.durationAddScale);
			var params=[];
			var mStep=NaN;
			for(i=0;i<len;i+=this.step){
				params.push(this.canvasShader.getData(i));
			}
			rst.id=this.particleList.length;
			this.particleList.push(rst);
			rst.setCmds(params);
			return rst;
		}

		__proto.addParticleArray=function(position,velocity){
			if(!this._ready)return;
			var tParticle;
			if(this.particleList.length<this._maxNumParticles){
				tParticle=this._createAParticleData(position,velocity);
				this.iList[tParticle.id]=0;
				this.activeParticles.push(tParticle);
				}else{
				if(this.deadParticles.length>0){
					tParticle=this.deadParticles.pop();
					this.iList[tParticle.id]=0;
					this.activeParticles.push(tParticle);
				}
			}
		}

		__proto.advanceTime=function(passedTime){
			(passedTime===void 0)&& (passedTime=1);
			if(!this._ready)return;
			var particleList=this.activeParticles;
			var pool=this.deadParticles;
			var i=0,len=particleList.length;
			var tcmd;
			var tI=0;
			var iList=this.iList;
			for(i=len-1;i>-1;i--){
				tcmd=particleList[i];
				tI=iList[tcmd.id];
				if(tI>=tcmd.maxIndex){
					tI=0;
					particleList.splice(i,1);
					pool.push(tcmd);
					}else{
					tI+=1;
				}
				iList[tcmd.id]=tI;
			}
		}

		__proto.render=function(context,x,y){
			if(!this._ready)return;
			if(this.activeParticles.length<1)return;
			if (this.textureList.length < 2)return;
			if (this.settings.disableColor){
				this.noColorRender(context,x,y);
				}else{
				this.canvasRender(context,x,y);
			}
		}

		__proto.noColorRender=function(context,x,y){
			var particleList=this.activeParticles;
			var i=0,len=particleList.length;
			var tcmd;
			var tParam;
			var tAlpha=NaN;
			var px=this.pX,py=this.pY;
			var pw=-px*2,ph=-py*2;
			var tI=0;
			var textureList=this.textureList;
			var iList=this.iList;
			var preAlpha=NaN;
			context.translate(x,y);
			preAlpha=context.ctx.globalAlpha;
			for(i=0;i<len;i++){
				tcmd=particleList[i];
				tI=iList[tcmd.id];
				tParam=tcmd.cmds[tI];
				if (!tParam)continue ;
				if ((tAlpha=tParam[1])<=0.01)continue ;
				context.setAlpha(preAlpha*tAlpha);
				context.drawTextureWithTransform(this.texture,px,py,pw,ph,tParam[2],1);
			}
			context.setAlpha(preAlpha);
			context.translate(-x,-y);
		}

		__proto.canvasRender=function(context,x,y){
			var particleList=this.activeParticles;
			var i=0,len=particleList.length;
			var tcmd;
			var tParam;
			var tAlpha=NaN;
			var px=this.pX,py=this.pY;
			var pw=-px*2,ph=-py*2;
			var tI=0;
			var textureList=this.textureList;
			var iList=this.iList;
			var preAlpha=NaN;
			var preB;
			context.translate(x,y);
			preAlpha=context.ctx.globalAlpha;
			preB=context.ctx.globalCompositeOperation;
			context.blendMode("lighter");
			for(i=0;i<len;i++){
				tcmd=particleList[i];
				tI=iList[tcmd.id];
				tParam=tcmd.cmds[tI];
				if (!tParam)continue ;
				if ((tAlpha=tParam[1])<=0.01)continue ;
				context.save();
				context.transformByMatrix(tParam[2]);
				if(tParam[3]>0.01){
					context.setAlpha(preAlpha*tParam[3]);
					context.drawTexture(textureList[0],px,py,pw,ph);
				}
				if(tParam[4]>0.01){
					context.setAlpha(preAlpha*tParam[4]);
					context.drawTexture(textureList[1],px,py,pw,ph);
				}
				if(tParam[5]>0.01){
					context.setAlpha(preAlpha*tParam[5]);
					context.drawTexture(textureList[2],px,py,pw,ph);
				}
				context.restore();
			}
			context.setAlpha(preAlpha);
			context.translate(-x,-y);
			context.blendMode(preB);
		}

		ParticleTemplateCanvas.changeTexture=function(texture,rst,settings){
			if(!rst)rst=[];
			rst.length=0;
			if (settings&&settings.disableColor){
				rst.push(texture,texture,texture);
				}else{
				Utils$1.copyArray(rst,PicTool.getRGBPic(texture));
			}
			return rst;
		}

		return ParticleTemplateCanvas;
	})(ParticleTemplateBase)


	//class laya.filters.webgl.ColorFilterActionGL extends laya.filters.webgl.FilterActionGL
	var ColorFilterActionGL=(function(_super){
		function ColorFilterActionGL(){
			this.data=null;
			ColorFilterActionGL.__super.call(this);
		}

		__class(ColorFilterActionGL,'laya.filters.webgl.ColorFilterActionGL',_super);
		var __proto=ColorFilterActionGL.prototype;
		Laya.imps(__proto,{"laya.filters.IFilterActionGL":true})
		__proto.setValue=function(shader){
			shader.colorMat=this.data._mat;
			shader.colorAlpha=this.data._alpha;
		}

		__proto.apply3d=function(scope,sprite,context,x,y){
			var b=scope.getValue("bounds");
			var shaderValue=Value2D.create(0x01,0);
			shaderValue.setFilters([this.data]);
			var tMatrix=Matrix.TEMP;
			tMatrix.identity();
			context.ctx.drawTarget(scope,0,0,b.width,b.height,tMatrix,"src",shaderValue);
		}

		return ColorFilterActionGL;
	})(FilterActionGL)


	//class laya.webgl.atlas.Atlaser extends laya.webgl.atlas.AtlasGrid
	var Atlaser=(function(_super){
		function Atlaser(gridNumX,gridNumY,width,height,atlasID){
			this._atlasCanvas=null;
			this._inAtlasTextureKey=null;
			this._inAtlasTextureBitmapValue=null;
			this._inAtlasTextureOriUVValue=null;
			this._InAtlasWebGLImagesKey=null;
			this._InAtlasWebGLImagesOffsetValue=null;
			Atlaser.__super.call(this,gridNumX,gridNumY,atlasID);
			this._inAtlasTextureKey=[];
			this._inAtlasTextureBitmapValue=[];
			this._inAtlasTextureOriUVValue=[];
			this._InAtlasWebGLImagesKey=[];
			this._InAtlasWebGLImagesOffsetValue=[];
			this._atlasCanvas=new AtlasWebGLCanvas();
			this._atlasCanvas.width=width;
			this._atlasCanvas.height=height;
			this._atlasCanvas.activeResource();
			this._atlasCanvas.lock=true;
		}

		__class(Atlaser,'laya.webgl.atlas.Atlaser',_super);
		var __proto=Atlaser.prototype;
		__proto.computeUVinAtlasTexture=function(texture,oriUV,offsetX,offsetY){
			var tex=texture;
			var _width=AtlasResourceManager.atlasTextureWidth;
			var _height=AtlasResourceManager.atlasTextureHeight;
			var u1=offsetX / _width,v1=offsetY / _height,u2=(offsetX+texture.bitmap.width)/ _width,v2=(offsetY+texture.bitmap.height)/ _height;
			var inAltasUVWidth=texture.bitmap.width / _width,inAltasUVHeight=texture.bitmap.height / _height;
			texture.uv=[u1+oriUV[0] *inAltasUVWidth,v1+oriUV[1] *inAltasUVHeight,u2-(1-oriUV[2])*inAltasUVWidth,v1+oriUV[3] *inAltasUVHeight,u2-(1-oriUV[4])*inAltasUVWidth,v2-(1-oriUV[5])*inAltasUVHeight,u1+oriUV[6] *inAltasUVWidth,v2-(1-oriUV[7])*inAltasUVHeight];
		}

		/**
		*
		*@param inAtlasRes
		*@return 是否已经存在队列中
		*/
		__proto.addToAtlasTexture=function(mergeAtlasBitmap,offsetX,offsetY){
			((mergeAtlasBitmap instanceof laya.webgl.resource.WebGLImage ))&& (this._InAtlasWebGLImagesKey.push(mergeAtlasBitmap),this._InAtlasWebGLImagesOffsetValue.push([offsetX,offsetY]));
			this._atlasCanvas.texSubImage2D(offsetX,offsetY,mergeAtlasBitmap.atlasSource);
			mergeAtlasBitmap.clearAtlasSource();
		}

		__proto.addToAtlas=function(texture,offsetX,offsetY){
			var oriUV=texture.uv.slice();
			var oriBitmap=texture.bitmap;
			this._inAtlasTextureKey.push(texture);
			this._inAtlasTextureOriUVValue.push(oriUV);
			this._inAtlasTextureBitmapValue.push(oriBitmap);
			this.computeUVinAtlasTexture(texture,oriUV,offsetX,offsetY);
			texture.bitmap=this._atlasCanvas;
		}

		__proto.clear=function(){
			for (var i=0,n=this._inAtlasTextureKey.length;i < n;i++){
				this._inAtlasTextureKey[i].bitmap=this._inAtlasTextureBitmapValue[i];
				this._inAtlasTextureKey[i].uv=this._inAtlasTextureOriUVValue[i];
				this._inAtlasTextureKey[i].bitmap.lock=false;
				this._inAtlasTextureKey[i].bitmap.releaseResource();
			}
			this._inAtlasTextureKey.length=0;
			this._inAtlasTextureBitmapValue.length=0;
			this._inAtlasTextureOriUVValue.length=0;
			this._InAtlasWebGLImagesKey.length=0;
			this._InAtlasWebGLImagesOffsetValue.length=0;
		}

		__proto.dispose=function(){
			this.clear();
			this._atlasCanvas.dispose();
		}

		__getset(0,__proto,'InAtlasWebGLImagesOffsetValue',function(){
			return this._InAtlasWebGLImagesOffsetValue;
		});

		__getset(0,__proto,'texture',function(){
			return this._atlasCanvas;
		});

		__getset(0,__proto,'inAtlasWebGLImagesKey',function(){
			return this._InAtlasWebGLImagesKey;
		});

		return Atlaser;
	})(AtlasGrid)


	//class laya.webgl.shader.d2.ShaderDefines2D extends laya.webgl.shader.ShaderDefines
	var ShaderDefines2D=(function(_super){
		function ShaderDefines2D(){
			ShaderDefines2D.__super.call(this,ShaderDefines2D.__name2int,ShaderDefines2D.__int2name,ShaderDefines2D.__int2nameMap);
		}

		__class(ShaderDefines2D,'laya.webgl.shader.d2.ShaderDefines2D',_super);
		ShaderDefines2D.__init__=function(){
			ShaderDefines2D.reg("TEXTURE2D",0x01);
			ShaderDefines2D.reg("COLOR2D",0x02);
			ShaderDefines2D.reg("PRIMITIVE",0x04);
			ShaderDefines2D.reg("GLOW_FILTER",0x08);
			ShaderDefines2D.reg("BLUR_FILTER",0x10);
			ShaderDefines2D.reg("COLOR_FILTER",0x20);
			ShaderDefines2D.reg("COLOR_ADD",0x40);
			ShaderDefines2D.reg("WORLDMAT",0x80);
			ShaderDefines2D.reg("FILLTEXTURE",0x100);
			ShaderDefines2D.reg("FSHIGHPRECISION",0x400);
		}

		ShaderDefines2D.reg=function(name,value){
			ShaderDefines._reg(name,value,ShaderDefines2D.__name2int,ShaderDefines2D.__int2name);
		}

		ShaderDefines2D.toText=function(value,int2name,int2nameMap){
			return ShaderDefines._toText(value,int2name,int2nameMap);
		}

		ShaderDefines2D.toInt=function(names){
			return ShaderDefines._toInt(names,ShaderDefines2D.__name2int);
		}

		ShaderDefines2D.TEXTURE2D=0x01;
		ShaderDefines2D.COLOR2D=0x02;
		ShaderDefines2D.PRIMITIVE=0x04;
		ShaderDefines2D.FILTERGLOW=0x08;
		ShaderDefines2D.FILTERBLUR=0x10;
		ShaderDefines2D.FILTERCOLOR=0x20;
		ShaderDefines2D.COLORADD=0x40;
		ShaderDefines2D.WORLDMAT=0x80;
		ShaderDefines2D.FILLTEXTURE=0x100;
		ShaderDefines2D.SKINMESH=0x200;
		ShaderDefines2D.SHADERDEFINE_FSHIGHPRECISION=0x400;
		ShaderDefines2D.__name2int={};
		ShaderDefines2D.__int2name=[];
		ShaderDefines2D.__int2nameMap=[];
		return ShaderDefines2D;
	})(ShaderDefines)


	//class laya.webgl.shader.d2.value.Value2D extends laya.webgl.shader.ShaderValue
	var Value2D=(function(_super){
		function Value2D(mainID,subID){
			this.size=[0,0];
			this.alpha=1.0;
			//this.mmat=null;
			this.ALPHA=1.0;
			//this.shader=null;
			//this.mainID=0;
			this.subID=0;
			//this.filters=null;
			//this.textureHost=null;
			//this.texture=null;
			//this.fillStyle=null;
			//this.color=null;
			//this.strokeStyle=null;
			//this.colorAdd=null;
			//this.glTexture=null;
			//this.u_mmat2=null;
			//this._inClassCache=null;
			this._cacheID=0;
			Value2D.__super.call(this);
			this.defines=new ShaderDefines2D();
			this.position=Value2D._POSITION;
			this.mainID=mainID;
			this.subID=subID;
			this.textureHost=null;
			this.texture=null;
			this.fillStyle=null;
			this.color=null;
			this.strokeStyle=null;
			this.colorAdd=null;
			this.glTexture=null;
			this.u_mmat2=null;
			this._cacheID=mainID|subID;
			this._inClassCache=Value2D._cache[this._cacheID];
			if (mainID>0 && !this._inClassCache){
				this._inClassCache=Value2D._cache[this._cacheID]=[];
				this._inClassCache._length=0;
			}
			this.clear();
		}

		__class(Value2D,'laya.webgl.shader.d2.value.Value2D',_super);
		var __proto=Value2D.prototype;
		__proto.setValue=function(value){}
		//throw new Error("todo in subclass");
		__proto.refresh=function(){
			var size=this.size;
			size[0]=RenderState2D.width;
			size[1]=RenderState2D.height;
			this.alpha=this.ALPHA *RenderState2D.worldAlpha;
			this.mmat=RenderState2D.worldMatrix4;
			return this;
		}

		__proto._ShaderWithCompile=function(){
			return Shader.withCompile2D(0,this.mainID,this.defines.toNameDic(),this.mainID | this.defines._value,Shader2X.create);
		}

		__proto._withWorldShaderDefines=function(){
			var defs=RenderState2D.worldShaderDefines;
			var sd=Shader.sharders [this.mainID | this.defines._value | defs.getValue()];
			if (!sd){
				var def={};
				var dic;
				var name;
				dic=this.defines.toNameDic();for (name in dic)def[name]="";
				dic=defs.toNameDic();for (name in dic)def[name]="";
				sd=Shader.withCompile2D(0,this.mainID,def,this.mainID | this.defines._value| defs.getValue(),Shader2X.create);
			};
			var worldFilters=RenderState2D.worldFilters;
			if (!worldFilters)return sd;
			var n=worldFilters.length,f;
			for (var i=0;i < n;i++){
				((f=worldFilters[i]))&& f.action.setValue(this);
			}
			return sd;
		}

		__proto.upload=function(){
			var renderstate2d=RenderState2D;
			this.alpha=this.ALPHA *renderstate2d.worldAlpha;
			if (RenderState2D.worldMatrix4!==RenderState2D.TEMPMAT4_ARRAY)this.defines.add(0x80);
			(WebGL.frameShaderHighPrecision)&& (this.defines.add(0x400));
			var sd=renderstate2d.worldShaderDefines?this._withWorldShaderDefines():(Shader.sharders [this.mainID | this.defines._value] || this._ShaderWithCompile());
			var params;
			this.size[0]=renderstate2d.width,this.size[1]=renderstate2d.height;
			this.mmat=renderstate2d.worldMatrix4;
			if (BaseShader.activeShader!==sd){
				if (sd._shaderValueWidth!==renderstate2d.width || sd._shaderValueHeight!==renderstate2d.height){
					sd._shaderValueWidth=renderstate2d.width;
					sd._shaderValueHeight=renderstate2d.height;
				}
				else{
					params=sd._params2dQuick2 || sd._make2dQuick2();
				}
				sd.upload(this,params);
			}
			else{
				if (sd._shaderValueWidth!==renderstate2d.width || sd._shaderValueHeight!==renderstate2d.height){
					sd._shaderValueWidth=renderstate2d.width;
					sd._shaderValueHeight=renderstate2d.height;
				}
				else{
					params=(sd._params2dQuick1)|| sd._make2dQuick1();
				}
				sd.upload(this,params);
			}
		}

		__proto.setFilters=function(value){
			this.filters=value;
			if (!value)
				return;
			var n=value.length,f;
			for (var i=0;i < n;i++){
				f=value[i];
				if (f){
					this.defines.add(f.type);
					f.action.setValue(this);
				}
			}
		}

		__proto.clear=function(){
			this.defines.setValue(this.subID);
		}

		__proto.release=function(){
			this._inClassCache[this._inClassCache._length++]=this;
			this.fillStyle=null;
			this.strokeStyle=null;
			this.clear();
		}

		Value2D._initone=function(type,classT){
			Value2D._typeClass[type]=classT;
			Value2D._cache[type]=[];
			Value2D._cache[type]._length=0;
		}

		Value2D.__init__=function(){
			Value2D._POSITION=[2,0x1406,false,4 *CONST3D2D.BYTES_PE,0];
			Value2D._TEXCOORD=[2,0x1406,false,4 *CONST3D2D.BYTES_PE,2 *CONST3D2D.BYTES_PE];
			Value2D._initone(0x02,Color2dSV);
			Value2D._initone(0x04,PrimitiveSV);
			Value2D._initone(0x100,FillTextureSV);
			Value2D._initone(0x200,SkinSV);
			Value2D._initone(0x01,TextureSV);
			Value2D._initone(0x01 | 0x40,TextSV);
			Value2D._initone(0x01 | 0x08,TextureSV);
		}

		Value2D.create=function(mainType,subType){
			var types=Value2D._cache[mainType|subType];
			if (types._length)
				return types[--types._length];
			else
			return new Value2D._typeClass[mainType|subType](subType);
		}

		Value2D._POSITION=null
		Value2D._TEXCOORD=null
		Value2D._cache=[];
		Value2D._typeClass=[];
		Value2D.TEMPMAT4_ARRAY=[1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1];
		return Value2D;
	})(ShaderValue)


	//class laya.webgl.shapes.Line extends laya.webgl.shapes.BasePoly
	var Line=(function(_super){
		function Line(x,y,points,borderWidth,color){
			this._points=[];
			this.rebuild(points);
			Line.__super.call(this,x,y,0,0,0,color,borderWidth,color,0);
		}

		__class(Line,'laya.webgl.shapes.Line',_super);
		var __proto=Line.prototype;
		__proto.rebuild=function(points){
			var len=points.length;
			var preLen=this._points.length;
			if (len !=preLen){
				this.mUint16Array=new Uint16Array((len/2-1)*6);
				this.mFloat32Array=new Float32Array(len*5);
			}
			this._points.length=0;
			var tCurrX=NaN;
			var tCurrY=NaN;
			var tLastX=-1;
			var tLastY=-1;
			var tLen=points.length / 2;
			for (var i=0;i < tLen;i++){
				tCurrX=points[i *2];
				tCurrY=points[i *2+1];
				if (Math.abs(tLastX-tCurrX)> 0.01 || Math.abs(tLastY-tCurrY)>0.01){
					this._points.push(tCurrX,tCurrY);
				}
				tLastX=tCurrX;
				tLastY=tCurrY;
			}
		}

		__proto.getData=function(ib,vb,start){
			var indices=[];
			var verts=[];
			(this.borderWidth > 0)&& this.createLine2(this._points,indices,this.borderWidth,start,verts,this._points.length / 2);
			this.mUint16Array.set(indices,0);
			this.mFloat32Array.set(verts,0);
			ib.append(this.mUint16Array);
			vb.append(this.mFloat32Array);
		}

		return Line;
	})(BasePoly)


	//class laya.webgl.shapes.LoopLine extends laya.webgl.shapes.BasePoly
	var LoopLine=(function(_super){
		function LoopLine(x,y,points,width,color){
			this._points=[];
			var tCurrX=NaN;
			var tCurrY=NaN;
			var tLastX=-1;
			var tLastY=-1;
			var tLen=points.length / 2-1;
			for (var i=0;i < tLen;i++){
				tCurrX=points[i *2];
				tCurrY=points[i *2+1];
				if (Math.abs(tLastX-tCurrX)> 0.01 || Math.abs(tLastY-tCurrY)> 0.01){
					this._points.push(tCurrX,tCurrY);
				}
				tLastX=tCurrX;
				tLastY=tCurrY;
			}
			tCurrX=points[tLen *2];
			tCurrY=points[tLen *2+1];
			tLastX=this._points[0];
			tLastY=this._points[1];
			if (Math.abs(tLastX-tCurrX)> 0.01 || Math.abs(tLastY-tCurrY)> 0.01){
				this._points.push(tCurrX,tCurrY);
			}
			LoopLine.__super.call(this,x,y,0,0,this._points.length / 2,0,width,color);
		}

		__class(LoopLine,'laya.webgl.shapes.LoopLine',_super);
		var __proto=LoopLine.prototype;
		__proto.getData=function(ib,vb,start){
			if (this.borderWidth > 0){
				var color=this.color;
				var r=((color >> 16)& 0x0000ff)/ 255,g=((color >> 8)& 0xff)/ 255,b=(color & 0x0000ff)/ 255;
				var verts=[];
				var tLastX=-1,tLastY=-1;
				var tCurrX=0,tCurrY=0;
				var indices=[];
				var tLen=Math.floor(this._points.length / 2);
				for (var i=0;i < tLen;i++){
					tCurrX=this._points[i *2];
					tCurrY=this._points[i *2+1];
					verts.push(this.x+tCurrX,this.y+tCurrY,r,g,b);
				}
				this.createLoopLine(verts,indices,this.borderWidth,start+verts.length / 5);
				ib.append(new Uint16Array(indices));
				vb.append(new Float32Array(verts));
			}
		}

		__proto.createLoopLine=function(p,indices,lineWidth,len,outVertex,outIndex){
			var tLen=p.length / 5;
			var points=p.concat();
			var result=outVertex ? outVertex :p;
			var color=this.borderColor;
			var r=((color >> 16)& 0x0000ff)/ 255,g=((color >> 8)& 0xff)/ 255,b=(color & 0x0000ff)/ 255;
			var firstPoint=[points[0],points[1]];
			var lastPoint=[points[points.length-5],points[points.length-4]];
			var midPointX=lastPoint[0]+(firstPoint[0]-lastPoint[0])*0.5;
			var midPointY=lastPoint[1]+(firstPoint[1]-lastPoint[1])*0.5;
			points.unshift(midPointX,midPointY,0,0,0);
			points.push(midPointX,midPointY,0,0,0);
			var length=points.length / 5;
			var iStart=len,w=lineWidth / 2;
			var px,py,p1x,p1y,p2x,p2y,p3x,p3y;
			var perpx,perpy,perp2x,perp2y,perp3x,perp3y;
			var a1,b1,c1,a2,b2,c2;
			var denom,pdist,dist;
			p1x=points[0];
			p1y=points[1];
			p2x=points[5];
			p2y=points[6];
			perpx=-(p1y-p2y);
			perpy=p1x-p2x;
			dist=Math.sqrt(perpx *perpx+perpy *perpy);
			perpx=perpx / dist *w;
			perpy=perpy / dist *w;
			result.push(p1x-perpx,p1y-perpy,r,g,b,p1x+perpx,p1y+perpy,r,g,b);
			for (var i=1;i < length-1;i++){
				p1x=points[(i-1)*5];
				p1y=points[(i-1)*5+1];
				p2x=points[(i)*5];
				p2y=points[(i)*5+1];
				p3x=points[(i+1)*5];
				p3y=points[(i+1)*5+1];
				perpx=-(p1y-p2y);
				perpy=p1x-p2x;
				dist=Math.sqrt(perpx *perpx+perpy *perpy);
				perpx=perpx / dist *w;
				perpy=perpy / dist *w;
				perp2x=-(p2y-p3y);
				perp2y=p2x-p3x;
				dist=Math.sqrt(perp2x *perp2x+perp2y *perp2y);
				perp2x=perp2x / dist *w;
				perp2y=perp2y / dist *w;
				a1=(-perpy+p1y)-(-perpy+p2y);
				b1=(-perpx+p2x)-(-perpx+p1x);
				c1=(-perpx+p1x)*(-perpy+p2y)-(-perpx+p2x)*(-perpy+p1y);
				a2=(-perp2y+p3y)-(-perp2y+p2y);
				b2=(-perp2x+p2x)-(-perp2x+p3x);
				c2=(-perp2x+p3x)*(-perp2y+p2y)-(-perp2x+p2x)*(-perp2y+p3y);
				denom=a1 *b2-a2 *b1;
				if (Math.abs(denom)< 0.1){
					denom+=10.1;
					result.push(p2x-perpx,p2y-perpy,r,g,b,p2x+perpx,p2y+perpy,r,g,b);
					continue ;
				}
				px=(b1 *c2-b2 *c1)/ denom;
				py=(a2 *c1-a1 *c2)/ denom;
				pdist=(px-p2x)*(px-p2x)+(py-p2y)+(py-p2y);
				result.push(px,py,r,g,b,p2x-(px-p2x),p2y-(py-p2y),r,g,b);
			}
			if (outIndex){
				indices=outIndex;
			};
			var groupLen=this.edges+1;
			for (i=1;i < groupLen;i++){
				indices.push(iStart+(i-1)*2,iStart+(i-1)*2+1,iStart+i *2+1,iStart+i *2+1,iStart+i *2,iStart+(i-1)*2);
			}
			indices.push(iStart+(i-1)*2,iStart+(i-1)*2+1,iStart+1,iStart+1,iStart,iStart+(i-1)*2);
			return result;
		}

		return LoopLine;
	})(BasePoly)


	//class laya.webgl.shapes.Polygon extends laya.webgl.shapes.BasePoly
	var Polygon=(function(_super){
		function Polygon(x,y,points,color,borderWidth,borderColor){
			this._points=null;
			this._start=-1;
			this._repaint=false;
			this._mat=Matrix.create();
			this._points=points.slice(0,points.length);
			Polygon.__super.call(this,x,y,0,0,this._points.length / 2,color,borderWidth,borderColor);
		}

		__class(Polygon,'laya.webgl.shapes.Polygon',_super);
		var __proto=Polygon.prototype;
		__proto.rebuild=function(point){
			if (!this._repaint){
				this._points.length=0;
				this._points=this._points.concat(point);
			}
		}

		__proto.setMatrix=function(mat){
			mat.copyTo(this._mat);
		}

		__proto.needUpdate=function(mat){
			this._repaint=(this._mat.a==mat.a && this._mat.b==mat.b && this._mat.c==mat.c && this._mat.d==mat.d && this._mat.tx==mat.tx && this._mat.ty==mat.ty);
			return !this._repaint;
		}

		__proto.getData=function(ib,vb,start){
			var indices,i=0;
			var tArray=this._points;
			var tLen=0;
			if (this.mUint16Array && this.mFloat32Array&&this._repaint){
				if (this._start !=start){
					this._start=start;
					indices=[];
					tLen=Math.floor(tArray.length / 2);
					for (i=2;i < tLen;i++){
						indices.push(start,start+i-1,start+i);
					}
					this.mUint16Array=new Uint16Array(indices);
				}
			}
			else {
				this._start=start;
				indices=[];
				var verts=[];
				var color=this.color;
				var r=((color >> 16)& 0x0000ff)/ 255,g=((color >> 8)& 0xff)/ 255,b=(color & 0x0000ff)/ 255;
				tLen=Math.floor(tArray.length / 2);
				for (i=0;i < tLen;i++){
					verts.push(this.x+tArray[i *2],this.y+tArray[i *2+1],r,g,b);
				}
				for (i=2;i < tLen;i++){
					indices.push(start,start+i-1,start+i);
				}
				this.mUint16Array=new Uint16Array(indices);
				this.mFloat32Array=new Float32Array(verts);
			}
			ib.append(this.mUint16Array);
			vb.append(this.mFloat32Array);
		}

		return Polygon;
	})(BasePoly)


	//class laya.webgl.submit.SubmitCanvas extends laya.webgl.submit.Submit
	var SubmitCanvas=(function(_super){
		function SubmitCanvas(){
			//this._ctx_src=null;
			this._matrix=new Matrix();
			this._matrix4=CONST3D2D.defaultMatrix4.concat();
			SubmitCanvas.__super.call(this,10000);
			this.shaderValue=new Value2D(0,0);
		}

		__class(SubmitCanvas,'laya.webgl.submit.SubmitCanvas',_super);
		var __proto=SubmitCanvas.prototype;
		__proto.renderSubmit=function(){
			if (this._ctx_src._targets){
				this._ctx_src._targets.flush(this._ctx_src);
				return 1;
			};
			var preAlpha=RenderState2D.worldAlpha;
			var preMatrix4=RenderState2D.worldMatrix4;
			var preMatrix=RenderState2D.worldMatrix;
			var preFilters=RenderState2D.worldFilters;
			var preWorldShaderDefines=RenderState2D.worldShaderDefines;
			var v=this.shaderValue;
			var m=this._matrix;
			var m4=this._matrix4;
			var mout=Matrix.TEMP;
			Matrix.mul(m,preMatrix,mout);
			m4[0]=mout.a;
			m4[1]=mout.b;
			m4[4]=mout.c;
			m4[5]=mout.d;
			m4[12]=mout.tx;
			m4[13]=mout.ty;
			RenderState2D.worldMatrix=mout.clone();
			RenderState2D.worldMatrix4=m4;
			RenderState2D.worldAlpha=RenderState2D.worldAlpha *v.alpha;
			if (v.filters && v.filters.length){
				RenderState2D.worldFilters=v.filters;
				RenderState2D.worldShaderDefines=v.defines;
			}
			this._ctx_src.flush();
			RenderState2D.worldAlpha=preAlpha;
			RenderState2D.worldMatrix4=preMatrix4;
			RenderState2D.worldMatrix.destroy();
			RenderState2D.worldMatrix=preMatrix;
			RenderState2D.worldFilters=preFilters;
			RenderState2D.worldShaderDefines=preWorldShaderDefines;
			return 1;
		}

		__proto.releaseRender=function(){
			var cache=SubmitCanvas._cache;
			this._ctx_src=null;
			cache[cache._length++]=this;
		}

		__proto.getRenderType=function(){
			return 10003;
		}

		SubmitCanvas.create=function(ctx_src,alpha,filters){
			var o=(!SubmitCanvas._cache._length)? (new SubmitCanvas()):SubmitCanvas._cache[--SubmitCanvas._cache._length];
			o._ctx_src=ctx_src;
			var v=o.shaderValue;
			v.alpha=alpha;
			v.defines.setValue(0);
			filters && filters.length && v.setFilters(filters);
			return o;
		}

		SubmitCanvas._cache=(SubmitCanvas._cache=[],SubmitCanvas._cache._length=0,SubmitCanvas._cache);
		return SubmitCanvas;
	})(Submit)


	//class laya.webgl.submit.SubmitTexture extends laya.webgl.submit.Submit
	var SubmitTexture=(function(_super){
		function SubmitTexture(renderType){
			this._preIsSameTextureShader=false;
			this._isSameTexture=true;
			this._texs=new Array;
			this._texsID=new Array;
			this._vbPos=new Array;
			(renderType===void 0)&& (renderType=10000);
			SubmitTexture.__super.call(this,renderType);
		}

		__class(SubmitTexture,'laya.webgl.submit.SubmitTexture',_super);
		var __proto=SubmitTexture.prototype;
		__proto.releaseRender=function(){
			var cache=SubmitTexture._cache;
			cache[cache._length++]=this;
			this.shaderValue.release();
			this._preIsSameTextureShader=false;
			this._vb=null;
			this._texs.length=0;
			this._vbPos.length=0;
			this._isSameTexture=true;
		}

		__proto.addTexture=function(tex,vbpos){
			this._texsID[this._texs.length]=tex._uvID;
			this._texs.push(tex);
			this._vbPos.push(vbpos);
		}

		//检查材质是否修改，修改UV，设置是否是同一材质
		__proto.checkTexture=function(){
			if (this._texs.length < 1){
				this._isSameTexture=true;
				return;
			};
			var _tex=this.shaderValue.textureHost;
			var webGLImg=_tex.bitmap;
			if (webGLImg===null)return;
			var vbdata=this._vb.getFloat32Array();
			for (var i=0,s=this._texs.length;i < s;i++){
				var tex=this._texs[i];
				tex.active();
				var newUV=tex.uv;
				if (this._texsID[i]!==tex._uvID){
					this._texsID[i]=tex._uvID;
					var vbPos=this._vbPos[i];
					vbdata[vbPos+2]=newUV[0];
					vbdata[vbPos+3]=newUV[1];
					vbdata[vbPos+6]=newUV[2];
					vbdata[vbPos+7]=newUV[3];
					vbdata[vbPos+10]=newUV[4];
					vbdata[vbPos+11]=newUV[5];
					vbdata[vbPos+14]=newUV[6];
					vbdata[vbPos+15]=newUV[7];
					this._vb.setNeedUpload();
				}
				if (tex.bitmap!==webGLImg){
					this._isSameTexture=false;
				}
			}
		}

		__proto.renderSubmit=function(){
			if (this._numEle===0){
				SubmitTexture._shaderSet=false;
				return 1;
			};
			var _tex=this.shaderValue.textureHost;
			if (_tex){
				var source=_tex.source;
				if (!_tex.bitmap || !source){
					SubmitTexture._shaderSet=false;
					return 1;
				}
				this.shaderValue.texture=source;
			}
			this._vb.bind_upload(this._ib);
			var gl=WebGL.mainContext;
			if (BlendMode.activeBlendFunction!==this._blendFn){
				gl.enable(0x0BE2);
				this._blendFn(gl);
				BlendMode.activeBlendFunction=this._blendFn;
			}
			Stat.drawCall++;
			Stat.trianglesFaces+=this._numEle / 3;
			if (this._preIsSameTextureShader && BaseShader.activeShader && SubmitTexture._shaderSet)
				(BaseShader.activeShader).uploadTexture2D(this.shaderValue.texture);
			else this.shaderValue.upload();
			SubmitTexture._shaderSet=true;
			if (this._texs.length > 1 && !this._isSameTexture){
				var webGLImg=_tex.bitmap;
				var index=0;
				var shader=BaseShader.activeShader;
				for (var i=0,s=this._texs.length;i < s;i++){
					var tex2=this._texs[i];
					if (tex2.bitmap!==webGLImg || (i+1)===s){
						shader.uploadTexture2D(tex2.source);
						gl.drawElements(0x0004,(i-index+1)*6,0x1403,this._startIdx+index *6 *CONST3D2D.BYTES_PIDX);
						webGLImg=tex2.bitmap;
						index=i;
					}
				}
				}else {
				gl.drawElements(0x0004,this._numEle,0x1403,this._startIdx);
			}
			return 1;
		}

		SubmitTexture.create=function(context,ib,vb,pos,sv){
			var o=SubmitTexture._cache._length ? SubmitTexture._cache[--SubmitTexture._cache._length] :new SubmitTexture();
			if (vb==null){
				vb=o._selfVb || (o._selfVb=VertexBuffer2D.create(-1));
				vb.clear();
				pos=0;
			}
			o._ib=ib;
			o._vb=vb;
			o._startIdx=pos *CONST3D2D.BYTES_PIDX;
			o._numEle=0;
			var blendType=context._nBlendType;
			o._blendFn=context._targets ? BlendMode.targetFns[blendType] :BlendMode.fns[blendType];
			o.shaderValue=sv;
			o.shaderValue.setValue(context._shader2D);
			var filters=context._shader2D.filters;
			filters && o.shaderValue.setFilters(filters);
			return o;
		}

		SubmitTexture._cache=(SubmitTexture._cache=[],SubmitTexture._cache._length=0,SubmitTexture._cache);
		SubmitTexture._shaderSet=true;
		return SubmitTexture;
	})(Submit)


	/**
	*<p> <code>Sprite</code> 是基本的显示图形的显示列表节点。 <code>Sprite</code> 默认没有宽高，默认不接受鼠标事件。通过 <code>graphics</code> 可以绘制图片或者矢量图，支持旋转，缩放，位移等操作。<code>Sprite</code>同时也是容器类，可用来添加多个子节点。</p>
	*<p>注意： <code>Sprite</code> 默认没有宽高，可以通过<code>getBounds</code>函数获取；也可手动设置宽高；还可以设置<code>autoSize=true</code>，然后再获取宽高。<code>Sprite</code>的宽高一般用于进行碰撞检测和排版，并不影响显示图像大小，如果需要更改显示图像大小，请使用 <code>scaleX</code> ， <code>scaleY</code> ， <code>scale</code>。</p>
	*<p> <code>Sprite</code> 默认不接受鼠标事件，即<code>mouseEnabled=false</code>，但是只要对其监听任意鼠标事件，会自动打开自己以及所有父对象的<code>mouseEnabled=true</code>。所以一般也无需手动设置<code>mouseEnabled</code>。</p>
	*<p>LayaAir引擎API设计精简巧妙。核心显示类只有一个<code>Sprite</code>。<code>Sprite</code>针对不同的情况做了渲染优化，所以保证一个类实现丰富功能的同时，又达到高性能。</p>
	*
	*@example <caption>创建了一个 <code>Sprite</code> 实例。</caption>
	*package
	*{
		*import laya.display.Sprite;
		*import laya.events.Event;
		*
		*public class Sprite_Example
		*{
			*private var sprite:Sprite;
			*private var shape:Sprite
			*public function Sprite_Example()
			*{
				*Laya.init(640,800);//设置游戏画布宽高、渲染模式。
				*Laya.stage.bgColor="#efefef";//设置画布的背景颜色。
				*onInit();
				*}
			*private function onInit():void
			*{
				*sprite=new Sprite();//创建一个 Sprite 类的实例对象 sprite 。
				*sprite.loadImage("resource/ui/bg.png");//加载并显示图片。
				*sprite.x=200;//设置 sprite 对象相对于父容器的水平方向坐标值。
				*sprite.y=200;//设置 sprite 对象相对于父容器的垂直方向坐标值。
				*sprite.pivotX=0;//设置 sprite 对象的水平方法轴心点坐标。
				*sprite.pivotY=0;//设置 sprite 对象的垂直方法轴心点坐标。
				*Laya.stage.addChild(sprite);//将此 sprite 对象添加到显示列表。
				*sprite.on(Event.CLICK,this,onClickSprite);//给 sprite 对象添加点击事件侦听。
				*shape=new Sprite();//创建一个 Sprite 类的实例对象 sprite 。
				*shape.graphics.drawRect(0,0,100,100,"#ccff00","#ff0000",2);//绘制一个有边框的填充矩形。
				*shape.x=400;//设置 shape 对象相对于父容器的水平方向坐标值。
				*shape.y=200;//设置 shape 对象相对于父容器的垂直方向坐标值。
				*shape.width=100;//设置 shape 对象的宽度。
				*shape.height=100;//设置 shape 对象的高度。
				*shape.pivotX=50;//设置 shape 对象的水平方法轴心点坐标。
				*shape.pivotY=50;//设置 shape 对象的垂直方法轴心点坐标。
				*Laya.stage.addChild(shape);//将此 shape 对象添加到显示列表。
				*shape.on(Event.CLICK,this,onClickShape);//给 shape 对象添加点击事件侦听。
				*}
			*private function onClickSprite():void
			*{
				*trace("点击 sprite 对象。");
				*sprite.rotation+=5;//旋转 sprite 对象。
				*}
			*private function onClickShape():void
			*{
				*trace("点击 shape 对象。");
				*shape.rotation+=5;//旋转 shape 对象。
				*}
			*}
		*}
	*
	*@example
	*var sprite;
	*var shape;
	*Sprite_Example();
	*function Sprite_Example()
	*{
		*Laya.init(640,800);//设置游戏画布宽高、渲染模式。
		*Laya.stage.bgColor="#efefef";//设置画布的背景颜色。
		*onInit();
		*}
	*function onInit()
	*{
		*sprite=new laya.display.Sprite();//创建一个 Sprite 类的实例对象 sprite 。
		*sprite.loadImage("resource/ui/bg.png");//加载并显示图片。
		*sprite.x=200;//设置 sprite 对象相对于父容器的水平方向坐标值。
		*sprite.y=200;//设置 sprite 对象相对于父容器的垂直方向坐标值。
		*sprite.pivotX=0;//设置 sprite 对象的水平方法轴心点坐标。
		*sprite.pivotY=0;//设置 sprite 对象的垂直方法轴心点坐标。
		*Laya.stage.addChild(sprite);//将此 sprite 对象添加到显示列表。
		*sprite.on(Event.CLICK,this,onClickSprite);//给 sprite 对象添加点击事件侦听。
		*shape=new laya.display.Sprite();//创建一个 Sprite 类的实例对象 sprite 。
		*shape.graphics.drawRect(0,0,100,100,"#ccff00","#ff0000",2);//绘制一个有边框的填充矩形。
		*shape.x=400;//设置 shape 对象相对于父容器的水平方向坐标值。
		*shape.y=200;//设置 shape 对象相对于父容器的垂直方向坐标值。
		*shape.width=100;//设置 shape 对象的宽度。
		*shape.height=100;//设置 shape 对象的高度。
		*shape.pivotX=50;//设置 shape 对象的水平方法轴心点坐标。
		*shape.pivotY=50;//设置 shape 对象的垂直方法轴心点坐标。
		*Laya.stage.addChild(shape);//将此 shape 对象添加到显示列表。
		*shape.on(laya.events.Event.CLICK,this,onClickShape);//给 shape 对象添加点击事件侦听。
		*}
	*function onClickSprite()
	*{
		*console.log("点击 sprite 对象。");
		*sprite.rotation+=5;//旋转 sprite 对象。
		*}
	*function onClickShape()
	*{
		*console.log("点击 shape 对象。");
		*shape.rotation+=5;//旋转 shape 对象。
		*}
	*
	*@example
	*import Sprite=laya.display.Sprite;
	*class Sprite_Example {
		*private sprite:Sprite;
		*private shape:Sprite
		*public Sprite_Example(){
			*Laya.init(640,800);//设置游戏画布宽高、渲染模式。
			*Laya.stage.bgColor="#efefef";//设置画布的背景颜色。
			*this.onInit();
			*}
		*private onInit():void {
			*this.sprite=new Sprite();//创建一个 Sprite 类的实例对象 sprite 。
			*this.sprite.loadImage("resource/ui/bg.png");//加载并显示图片。
			*this.sprite.x=200;//设置 sprite 对象相对于父容器的水平方向坐标值。
			*this.sprite.y=200;//设置 sprite 对象相对于父容器的垂直方向坐标值。
			*this.sprite.pivotX=0;//设置 sprite 对象的水平方法轴心点坐标。
			*this.sprite.pivotY=0;//设置 sprite 对象的垂直方法轴心点坐标。
			*Laya.stage.addChild(this.sprite);//将此 sprite 对象添加到显示列表。
			*this.sprite.on(laya.events.Event.CLICK,this,this.onClickSprite);//给 sprite 对象添加点击事件侦听。
			*this.shape=new Sprite();//创建一个 Sprite 类的实例对象 sprite 。
			*this.shape.graphics.drawRect(0,0,100,100,"#ccff00","#ff0000",2);//绘制一个有边框的填充矩形。
			*this.shape.x=400;//设置 shape 对象相对于父容器的水平方向坐标值。
			*this.shape.y=200;//设置 shape 对象相对于父容器的垂直方向坐标值。
			*this.shape.width=100;//设置 shape 对象的宽度。
			*this.shape.height=100;//设置 shape 对象的高度。
			*this.shape.pivotX=50;//设置 shape 对象的水平方法轴心点坐标。
			*this.shape.pivotY=50;//设置 shape 对象的垂直方法轴心点坐标。
			*Laya.stage.addChild(this.shape);//将此 shape 对象添加到显示列表。
			*this.shape.on(laya.events.Event.CLICK,this,this.onClickShape);//给 shape 对象添加点击事件侦听。
			*}
		*private onClickSprite():void {
			*console.log("点击 sprite 对象。");
			*this.sprite.rotation+=5;//旋转 sprite 对象。
			*}
		*private onClickShape():void {
			*console.log("点击 shape 对象。");
			*this.shape.rotation+=5;//旋转 shape 对象。
			*}
		*}
	*/
	//class laya.display.Sprite extends laya.display.Node
	var Sprite=(function(_super){
		function Sprite(){
			this._transform=null;
			this._tfChanged=false;
			this._x=0;
			this._y=0;
			this._width=0;
			this._height=0;
			this._repaint=1;
			this._mouseEnableState=0;
			this._zOrder=0;
			this._graphics=null;
			this._renderType=0;
			this._optimizeScrollRect=false;
			this._texture=null;
			this._childRenderMax=false;
			this.mouseThrough=false;
			this.autoSize=false;
			this.hitTestPrior=false;
			this.viewport=null;
			Sprite.__super.call(this);
			this._style=Style.EMPTY;
		}

		__class(Sprite,'laya.display.Sprite',_super);
		var __proto=Sprite.prototype;
		Laya.imps(__proto,{"laya.display.ILayout":true})
		/**@private */
		__proto.createConchModel=function(){
			return new ConchNode();
		}

		/**@inheritDoc */
		__proto.destroy=function(destroyChild){
			(destroyChild===void 0)&& (destroyChild=true);
			_super.prototype.destroy.call(this,destroyChild);
			this._style && this._style.destroy();
			this._transform=null;
			this._style=null;
			this._graphics=null;
		}

		/**根据zOrder进行重新排序。*/
		__proto.updateZOrder=function(){
			Utils$1.updateOrder(this._childs)&& this.repaint();
		}

		/**在设置cacheAs的情况下，调用此方法会重新刷新缓存。*/
		__proto.reCache=function(){
			if (this._$P.cacheCanvas)this._$P.cacheCanvas.reCache=true;
			this._repaint=1;
		}

		/**
		*<p>设置对象在自身坐标系下的边界范围。与 <code>getSelfBounds</code> 对应。当 autoSize==true 时，会影响对象宽高。设置后，当需要获取自身边界范围时，就不再需要计算，合理使用能提高性能。比如 <code>getBounds</code> 会优先使用 <code>setBounds</code> 指定的值，如果没有指定则进行计算，此计算会对性能消耗比较大。</p>
		*<p><b>注意：</b> <code>setBounds</code> 与 <code>getBounds</code> 并非对应相等关系， <code>getBounds</code> 获取的是本对象在父容器坐标系下的边界范围，通过设置 <code>setBounds</code> 会影响 <code>getBounds</code> 的结果。</p>
		*@param bound bounds矩形区域
		*/
		__proto.setBounds=function(bound){
			this._set$P("uBounds",bound);
		}

		/**
		*<p>获取本对象在父容器坐标系的矩形显示区域。</p>
		*<p><b>注意：</b> 1.计算量较大，尽量少用，如果需要频繁使用，可以通过手动设置 <code>setBounds</code> 来缓存自身边界信息，从而避免比较消耗性能的计算。2. <code>setBounds</code> 与 <code>getBounds</code> 并非对应相等关系， <code>getBounds</code> 获取的是本对象在父容器坐标系下的边界范围，通过设置 <code>setBounds</code> 会影响 <code>getBounds</code> 的结果。</p>
		*@return 矩形区域。
		*/
		__proto.getBounds=function(){
			if (!this._$P.mBounds)this._set$P("mBounds",new Rectangle());
			return Rectangle._getWrapRec(this._boundPointsToParent(),this._$P.mBounds);
		}

		/**
		*获取对象在自身坐标系的边界范围。与 <code>setBounds</code> 对应。
		*<p><b>注意：</b>计算量较大，尽量少用，如果需要频繁使用，可以提前手动设置 <code>setBounds</code> 来缓存自身边界信息，从而避免比较消耗性能的计算。</p>
		*@return 矩形区域。
		*/
		__proto.getSelfBounds=function(){
			if (this._$P.uBounds)return this._$P.uBounds;
			if (!this._$P.mBounds)this._set$P("mBounds",new Rectangle());
			return Rectangle._getWrapRec(this._getBoundPointsM(false),this._$P.mBounds);
		}

		/**
		*@private
		*获取本对象在父容器坐标系的显示区域多边形顶点列表。
		*当显示对象链中有旋转时，返回多边形顶点列表，无旋转时返回矩形的四个顶点。
		*@param ifRotate （可选）之前的对象链中是否有旋转。
		*@return 顶点列表。结构：[x1,y1,x2,y2,x3,y3,...]。
		*/
		__proto._boundPointsToParent=function(ifRotate){
			(ifRotate===void 0)&& (ifRotate=false);
			var pX=0,pY=0;
			if (this._style){
				pX=this._style._tf.translateX;
				pY=this._style._tf.translateY;
				ifRotate=ifRotate || (this._style._tf.rotate!==0);
				if (this._style.scrollRect){
					pX+=this._style.scrollRect.x;
					pY+=this._style.scrollRect.y;
				}
			};
			var pList=this._getBoundPointsM(ifRotate);
			if (!pList || pList.length < 1)return pList;
			if (pList.length !=8){
				pList=ifRotate ? GrahamScan.scanPList(pList):Rectangle._getWrapRec(pList,Rectangle.TEMP)._getBoundPoints();
			}
			if (!this.transform){
				Utils$1.transPointList(pList,this._x-pX,this._y-pY);
				return pList;
			};
			var tPoint=Point.TEMP;
			var i=0,len=pList.length;
			for (i=0;i < len;i+=2){
				tPoint.x=pList[i];
				tPoint.y=pList[i+1];
				this.toParentPoint(tPoint);
				pList[i]=tPoint.x;
				pList[i+1]=tPoint.y;
			}
			return pList;
		}

		/**
		*返回此实例中的绘图对象（ <code>Graphics</code> ）的显示区域，不包括子对象。
		*@param realSize （可选）使用图片的真实大小，默认为false
		*@return 一个 Rectangle 对象，表示获取到的显示区域。
		*/
		__proto.getGraphicBounds=function(realSize){
			(realSize===void 0)&& (realSize=false);
			if (!this._graphics)return Rectangle.TEMP.setTo(0,0,0,0);
			return this._graphics.getBounds(realSize);
		}

		/**
		*
		*@private
		*获取自己坐标系的显示区域多边形顶点列表
		*@param ifRotate （可选）当前的显示对象链是否由旋转
		*@return 顶点列表。结构：[x1,y1,x2,y2,x3,y3,...]。
		*/
		__proto._getBoundPointsM=function(ifRotate){
			(ifRotate===void 0)&& (ifRotate=false);
			if (this._$P.uBounds)return this._$P.uBounds._getBoundPoints();
			if (!this._$P.temBM)this._set$P("temBM",[]);
			if (this.scrollRect){
				var rst=Utils$1.clearArray(this._$P.temBM);
				var rec=Rectangle.TEMP;
				rec.copyFrom(this.scrollRect);
				Utils$1.concatArray(rst,rec._getBoundPoints());
				return rst;
			};
			var pList=this._graphics ? this._graphics.getBoundPoints():Utils$1.clearArray(this._$P.temBM);
			var child;
			var cList;
			var __childs;
			__childs=this._childs;
			for (var i=0,n=__childs.length;i < n;i++){
				child=__childs [i];
				if ((child instanceof laya.display.Sprite )&& child.visible==true){
					cList=child._boundPointsToParent(ifRotate);
					if (cList)
						pList=pList ? Utils$1.concatArray(pList,cList):cList;
				}
			}
			return pList;
		}

		/**
		*@private
		*获取样式。
		*@return 样式 Style 。
		*/
		__proto.getStyle=function(){
			this._style===Style.EMPTY && (this._style=new Style(),this._childRenderMax=true);
			return this._style;
		}

		/**
		*@private
		*设置样式。
		*@param value 样式。
		*/
		__proto.setStyle=function(value){
			this._style=value;
		}

		/**@private */
		__proto._adjustTransform=function(){
			'use strict';
			this._tfChanged=false;
			var style=this._style;
			var tf=style._tf;
			var sx=tf.scaleX,sy=tf.scaleY;
			var m;
			if (tf.rotate || sx!==1 || sy!==1 || tf.skewX || tf.skewY){
				m=this._transform || (this._transform=Matrix.create());
				m.bTransform=true;
				var skx=(tf.rotate-tf.skewX)*0.0174532922222222;
				var sky=(tf.rotate+tf.skewY)*0.0174532922222222;
				var cx=Math.cos(sky);
				var ssx=Math.sin(sky);
				var cy=Math.sin(skx);
				var ssy=Math.cos(skx);
				m.a=sx *cx;
				m.b=sx *ssx;
				m.c=-sy *cy;
				m.d=sy *ssy;
				m.tx=m.ty=0;
				return m;
				}else {
				this._transform && this._transform.destroy();
				this._transform=null;
				this._renderType &=~0x04;
			}
			return m;
		}

		/**
		*<p>设置坐标位置。相当于分别设置x和y属性。</p>
		*<p>因为返回值为Sprite对象本身，所以可以使用如下语法：spr.pos(...).scale(...);</p>
		*@param x X轴坐标。
		*@param y Y轴坐标。
		*@param speedMode （可选）是否极速模式，正常是调用this.x=value进行赋值，极速模式直接调用内部函数处理，如果未重写x,y属性，建议设置为急速模式性能更高。
		*@return 返回对象本身。
		*/
		__proto.pos=function(x,y,speedMode){
			(speedMode===void 0)&& (speedMode=false);
			if (this._x!==x || this._y!==y){
				if (this.destroyed)return this;
				if (speedMode){
					this._x=x;
					this._y=y;
					this.conchModel && this.conchModel.pos(this._x,this._y);
					var p=this._parent;
					if (p && p._repaint===0){
						p._repaint=1;
						p.parentRepaint();
					}
					if (this._$P.maskParent && this._$P.maskParent._repaint===0){
						this._$P.maskParent._repaint=1;
						this._$P.maskParent.parentRepaint();
					}
					}else {
					this.x=x;
					this.y=y;
				}
			}
			return this;
		}

		/**
		*<p>设置轴心点。相当于分别设置pivotX和pivotY属性。</p>
		*<p>因为返回值为Sprite对象本身，所以可以使用如下语法：spr.pivot(...).pos(...);</p>
		*@param x X轴心点。
		*@param y Y轴心点。
		*@return 返回对象本身。
		*/
		__proto.pivot=function(x,y){
			this.pivotX=x;
			this.pivotY=y;
			return this;
		}

		/**
		*<p>设置宽高。相当于分别设置width和height属性。</p>
		*<p>因为返回值为Sprite对象本身，所以可以使用如下语法：spr.size(...).pos(...);</p>
		*@param width 宽度值。
		*@param hegiht 高度值。
		*@return 返回对象本身。
		*/
		__proto.size=function(width,height){
			this.width=width;
			this.height=height;
			return this;
		}

		/**
		*<p>设置缩放。相当于分别设置scaleX和scaleY属性。</p>
		*<p>因为返回值为Sprite对象本身，所以可以使用如下语法：spr.scale(...).pos(...);</p>
		*@param scaleX X轴缩放比例。
		*@param scaleY Y轴缩放比例。
		*@param speedMode （可选）是否极速模式，正常是调用this.scaleX=value进行赋值，极速模式直接调用内部函数处理，如果未重写scaleX,scaleY属性，建议设置为急速模式性能更高。
		*@return 返回对象本身。
		*/
		__proto.scale=function(scaleX,scaleY,speedMode){
			(speedMode===void 0)&& (speedMode=false);
			var style=this.getStyle();
			var _tf=style._tf;
			if (_tf.scaleX !=scaleX || _tf.scaleY !=scaleY){
				if (this.destroyed)return this;
				if (speedMode){
					style.setScale(scaleX,scaleY);
					this._tfChanged=true;
					this.conchModel && this.conchModel.scale(scaleX,scaleY);
					this._renderType |=0x04;
					var p=this._parent;
					if (p && p._repaint===0){
						p._repaint=1;
						p.parentRepaint();
					}
					}else {
					this.scaleX=scaleX;
					this.scaleY=scaleY;
				}
			}
			return this;
		}

		/**
		*<p>设置倾斜角度。相当于分别设置skewX和skewY属性。</p>
		*<p>因为返回值为Sprite对象本身，所以可以使用如下语法：spr.skew(...).pos(...);</p>
		*@param skewX 水平倾斜角度。
		*@param skewY 垂直倾斜角度。
		*@return 返回对象本身
		*/
		__proto.skew=function(skewX,skewY){
			this.skewX=skewX;
			this.skewY=skewY;
			return this;
		}

		/**
		*更新、呈现显示对象。由系统调用。
		*@param context 渲染的上下文引用。
		*@param x X轴坐标。
		*@param y Y轴坐标。
		*/
		__proto.render=function(context,x,y){
			Stat.spriteCount++;
			RenderSprite.renders[this._renderType]._fun(this,context,x+this._x,y+this._y);
			this._repaint=0;
		}

		/**
		*<p>绘制 当前<code>Sprite</code> 到 <code>Canvas</code> 上，并返回一个HtmlCanvas。</p>
		*<p>绘制的结果可以当作图片源，再次绘制到其他Sprite里面，示例：</p>
		*
		*var htmlCanvas:HTMLCanvas=sprite.drawToCanvas(100,100,0,0);//把精灵绘制到canvas上面
		*var texture:Texture=new Texture(htmlCanvas);//使用htmlCanvas创建Texture
		*var sp:Sprite=new Sprite().pos(0,200);//创建精灵并把它放倒200位置
		*sp.graphics.drawTexture(texture);//把截图绘制到精灵上
		*Laya.stage.addChild(sp);//把精灵显示到舞台
		*
		*<p>也可以获取原始图片数据，分享到网上，从而实现截图效果，示例：</p>
		*
		*var htmlCanvas:HTMLCanvas=sprite.drawToCanvas(100,100,0,0);//把精灵绘制到canvas上面
		*var canvas:*=htmlCanvas.getCanvas();//获取原生的canvas对象
		*trace(canvas.toDataURL("image/png"));//打印图片base64信息，可以发给服务器或者保存为图片
		*
		*@param canvasWidth 画布宽度。
		*@param canvasHeight 画布高度。
		*@param x 绘制的 X 轴偏移量。
		*@param y 绘制的 Y 轴偏移量。
		*@return HTMLCanvas 对象。
		*/
		__proto.drawToCanvas=function(canvasWidth,canvasHeight,offsetX,offsetY){
			if (Render.isConchNode){
				var canvas=HTMLCanvas.create("2D");
				var context=new RenderContext(canvasWidth,canvasHeight,canvas);
				context.ctx.setCanvasType(1);
				this.conchModel.drawToCanvas(canvas.source,offsetX,offsetY);
				return canvas;
				}else {
				return RunDriver.drawToCanvas(this,this._renderType,canvasWidth,canvasHeight,offsetX,offsetY);
			}
		}

		/**
		*<p>自定义更新、呈现显示对象。一般用来扩展渲染模式，请合理使用，可能会导致在加速器上无法渲染。</p>
		*<p><b>注意</b>不要在此函数内增加或删除树节点，否则会对树节点遍历造成影响。</p>
		*@param context 渲染的上下文引用。
		*@param x X轴坐标。
		*@param y Y轴坐标。
		*/
		__proto.customRender=function(context,x,y){
			this._renderType |=0x400;
		}

		/**
		*@private
		*应用滤镜。
		*/
		__proto._applyFilters=function(){
			if (Render.isWebGL)return;
			var _filters;
			_filters=this._$P.filters;
			if (!_filters || _filters.length < 1)return;
			for (var i=0,n=_filters.length;i < n;i++){
				_filters[i].action.apply(this._$P.cacheCanvas);
			}
		}

		/**
		*@private
		*查看当前原件中是否包含发光滤镜。
		*@return 一个 Boolean 值，表示当前原件中是否包含发光滤镜。
		*/
		__proto._isHaveGlowFilter=function(){
			var i=0,len=0;
			if (this.filters){
				for (i=0;i < this.filters.length;i++){
					if (this.filters[i].type==0x08){
						return true;
					}
				}
			}
			for (i=0,len=this._childs.length;i < len;i++){
				if (this._childs[i]._isHaveGlowFilter()){
					return true;
				}
			}
			return false;
		}

		/**
		*把本地坐标转换为相对stage的全局坐标。
		*@param point 本地坐标点。
		*@param createNewPoint （可选）是否创建一个新的Point对象作为返回值，默认为false，使用输入的point对象返回，减少对象创建开销。
		*@return 转换后的坐标的点。
		*/
		__proto.localToGlobal=function(point,createNewPoint){
			(createNewPoint===void 0)&& (createNewPoint=false);
			if (createNewPoint===true){
				point=new Point(point.x,point.y);
			};
			var ele=this;
			while (ele){
				if (ele==Laya.stage)break ;
				point=ele.toParentPoint(point);
				ele=ele.parent;
			}
			return point;
		}

		/**
		*把stage的全局坐标转换为本地坐标。
		*@param point 全局坐标点。
		*@param createNewPoint （可选）是否创建一个新的Point对象作为返回值，默认为false，使用输入的point对象返回，减少对象创建开销。
		*@return 转换后的坐标的点。
		*/
		__proto.globalToLocal=function(point,createNewPoint){
			(createNewPoint===void 0)&& (createNewPoint=false);
			if (createNewPoint){
				point=new Point(point.x,point.y);
			};
			var ele=this;
			var list=[];
			while (ele){
				if (ele==Laya.stage)break ;
				list.push(ele);
				ele=ele.parent;
			};
			var i=list.length-1;
			while (i >=0){
				ele=list[i];
				point=ele.fromParentPoint(point);
				i--;
			}
			return point;
		}

		/**
		*将本地坐标系坐标转转换到父容器坐标系。
		*@param point 本地坐标点。
		*@return 转换后的点。
		*/
		__proto.toParentPoint=function(point){
			if (!point)return point;
			point.x-=this.pivotX;
			point.y-=this.pivotY;
			if (this.transform){
				this._transform.transformPoint(point);
			}
			point.x+=this._x;
			point.y+=this._y;
			var scroll=this._style.scrollRect;
			if (scroll){
				point.x-=scroll.x;
				point.y-=scroll.y;
			}
			return point;
		}

		/**
		*将父容器坐标系坐标转换到本地坐标系。
		*@param point 父容器坐标点。
		*@return 转换后的点。
		*/
		__proto.fromParentPoint=function(point){
			if (!point)return point;
			point.x-=this._x;
			point.y-=this._y;
			var scroll=this._style.scrollRect;
			if (scroll){
				point.x+=scroll.x;
				point.y+=scroll.y;
			}
			if (this.transform){
				this._transform.invertTransformPoint(point);
			}
			point.x+=this.pivotX;
			point.y+=this.pivotY;
			return point;
		}

		/**
		*<p>增加事件侦听器，以使侦听器能够接收事件通知。</p>
		*<p>如果侦听鼠标事件，则会自动设置自己和父亲节点的属性 mouseEnabled 的值为 true(如果父节点mouseEnabled=false，则停止设置父节点mouseEnabled属性)。</p>
		*@param type 事件的类型。
		*@param caller 事件侦听函数的执行域。
		*@param listener 事件侦听函数。
		*@param args （可选）事件侦听函数的回调参数。
		*@return 此 EventDispatcher 对象。
		*/
		__proto.on=function(type,caller,listener,args){
			if (this._mouseEnableState!==1 && this.isMouseEvent(type)){
				this.mouseEnabled=true;
				this._setBit(0x2,true);
				if (this._parent){
					this._$2__onDisplay();
				}
				return this._createListener(type,caller,listener,args,false);
			}
			return _super.prototype.on.call(this,type,caller,listener,args);
		}

		/**
		*<p>增加事件侦听器，以使侦听器能够接收事件通知，此侦听事件响应一次后则自动移除侦听。</p>
		*<p>如果侦听鼠标事件，则会自动设置自己和父亲节点的属性 mouseEnabled 的值为 true(如果父节点mouseEnabled=false，则停止设置父节点mouseEnabled属性)。</p>
		*@param type 事件的类型。
		*@param caller 事件侦听函数的执行域。
		*@param listener 事件侦听函数。
		*@param args （可选）事件侦听函数的回调参数。
		*@return 此 EventDispatcher 对象。
		*/
		__proto.once=function(type,caller,listener,args){
			if (this._mouseEnableState!==1 && this.isMouseEvent(type)){
				this.mouseEnabled=true;
				this._setBit(0x2,true);
				if (this._parent){
					this._$2__onDisplay();
				}
				return this._createListener(type,caller,listener,args,true);
			}
			return _super.prototype.once.call(this,type,caller,listener,args);
		}

		/**@private */
		__proto._$2__onDisplay=function(){
			if (this._mouseEnableState!==1){
				var ele=this;
				ele=ele.parent;
				while (ele && ele._mouseEnableState!==1){
					if (ele._getBit(0x2))break ;
					ele.mouseEnabled=true;
					ele._setBit(0x2,true);
					ele=ele.parent;
				}
			}
		}

		/**
		*<p>加载并显示一个图片。功能等同于graphics.loadImage方法。支持异步加载。</p>
		*<p>注意：多次调用loadImage绘制不同的图片，会同时显示。</p>
		*@param url 图片地址。
		*@param x （可选）显示图片的x位置。
		*@param y （可选）显示图片的y位置。
		*@param width （可选）显示图片的宽度，设置为0表示使用图片默认宽度。
		*@param height （可选）显示图片的高度，设置为0表示使用图片默认高度。
		*@param complete （可选）加载完成回调。
		*@return 返回精灵对象本身。
		*/
		__proto.loadImage=function(url,x,y,width,height,complete){
			var _$this=this;
			(x===void 0)&& (x=0);
			(y===void 0)&& (y=0);
			(width===void 0)&& (width=0);
			(height===void 0)&& (height=0);
			function loaded (tex){
				if (!_$this.destroyed){
					_$this.size(x+(width || tex.width),y+(height || tex.height));
					_$this.repaint();
					complete && complete.runWith(tex);
				}
			}
			this.graphics.loadImage(url,x,y,width,height,loaded);
			return this;
		}

		/**cacheAs后，设置自己和父对象缓存失效。*/
		__proto.repaint=function(){
			this.conchModel && this.conchModel.repaint && this.conchModel.repaint();
			if (this._repaint===0){
				this._repaint=1;
				this.parentRepaint();
			}
			if (this._$P && this._$P.maskParent){
				this._$P.maskParent.repaint();
			}
		}

		/**
		*@private
		*获取是否重新缓存。
		*@return 如果重新缓存值为 true，否则值为 false。
		*/
		__proto._needRepaint=function(){
			return (this._repaint!==0)&& this._$P.cacheCanvas && this._$P.cacheCanvas.reCache;
		}

		/**@private */
		__proto._childChanged=function(child){
			if (this._childs.length)this._renderType |=0x800;
			else this._renderType &=~0x800;
			if (child && this._get$P("hasZorder"))Laya.timer.callLater(this,this.updateZOrder);
			this.repaint();
		}

		/**cacheAs时，设置所有父对象缓存失效。 */
		__proto.parentRepaint=function(){
			var p=this._parent;
			if (p && p._repaint===0){
				p._repaint=1;
				p.parentRepaint();
			}
		}

		/**
		*开始拖动此对象。
		*@param area （可选）拖动区域，此区域为当前对象注册点活动区域（不包括对象宽高），可选。
		*@param hasInertia （可选）鼠标松开后，是否还惯性滑动，默认为false，可选。
		*@param elasticDistance （可选）橡皮筋效果的距离值，0为无橡皮筋效果，默认为0，可选。
		*@param elasticBackTime （可选）橡皮筋回弹时间，单位为毫秒，默认为300毫秒，可选。
		*@param data （可选）拖动事件携带的数据，可选。
		*@param disableMouseEvent （可选）禁用其他对象的鼠标检测，默认为false，设置为true能提高性能。
		*@param ratio （可选）惯性阻尼系数，影响惯性力度和时长。
		*/
		__proto.startDrag=function(area,hasInertia,elasticDistance,elasticBackTime,data,disableMouseEvent,ratio){
			(hasInertia===void 0)&& (hasInertia=false);
			(elasticDistance===void 0)&& (elasticDistance=0);
			(elasticBackTime===void 0)&& (elasticBackTime=300);
			(disableMouseEvent===void 0)&& (disableMouseEvent=false);
			(ratio===void 0)&& (ratio=0.92);
			this._$P.dragging || (this._set$P("dragging",new Dragging()));
			this._$P.dragging.start(this,area,hasInertia,elasticDistance,elasticBackTime,data,disableMouseEvent,ratio);
		}

		/**停止拖动此对象。*/
		__proto.stopDrag=function(){
			this._$P.dragging && this._$P.dragging.stop();
		}

		/**@private */
		__proto._setDisplay=function(value){
			if (!value){
				var cc=this._$P.cacheCanvas;
				if (cc && cc.ctx){
					Pool.recover("RenderContext",cc.ctx);
					cc.ctx.canvas.size(0,0);
					cc.ctx=null;
				};
				var fc=this._$P._filterCache;
				if (fc){
					fc.destroy();
					fc.recycle();
					this._set$P('_filterCache',null);
				}
				this._$P._isHaveGlowFilter && this._set$P('_isHaveGlowFilter',false);
			}
			_super.prototype._setDisplay.call(this,value);
		}

		/**
		*检测某个点是否在此对象内。
		*@param x 全局x坐标。
		*@param y 全局y坐标。
		*@return 表示是否在对象内。
		*/
		__proto.hitTestPoint=function(x,y){
			var point=this.globalToLocal(Point.TEMP.setTo(x,y));
			var rect=this._$P.hitArea ? this._$P.hitArea :(this._width > 0 && this._height > 0)? Rectangle.TEMP.setTo(0,0,this._width,this._height):this.getSelfBounds();
			return rect.contains(point.x,point.y);
		}

		/**获得相对于本对象上的鼠标坐标信息。*/
		__proto.getMousePoint=function(){
			return this.globalToLocal(Point.TEMP.setTo(Laya.stage.mouseX,Laya.stage.mouseY));
		}

		/**@private */
		__proto._getWords=function(){
			return null;
		}

		/**@private */
		__proto._addChildsToLayout=function(out){
			var words=this._getWords();
			if (words==null && this._childs.length==0)return false;
			if (words){
				for (var i=0,n=words.length;i < n;i++){
					out.push(words[i]);
				}
			}
			this._childs.forEach(function(o,index,array){
				o._style._enableLayout()&& o._addToLayout(out);
			});
			return true;
		}

		/**@private */
		__proto._addToLayout=function(out){
			if (this._style.absolute)return;
			this._style.block ? out.push(this):(this._addChildsToLayout(out)&& (this.x=this.y=0));
		}

		/**@private */
		__proto._isChar=function(){
			return false;
		}

		/**@private */
		__proto._getCSSStyle=function(){
			return this._style.getCSSStyle();
		}

		/**
		*@private
		*设置指定属性名的属性值。
		*@param name 属性名。
		*@param value 属性值。
		*/
		__proto._setAttributes=function(name,value){
			switch (name){
				case 'x':
					this.x=parseFloat(value);
					break ;
				case 'y':
					this.y=parseFloat(value);
					break ;
				case 'width':
					this.width=parseFloat(value);
					break ;
				case 'height':
					this.height=parseFloat(value);
					break ;
				default :
					this[name]=value;
				}
		}

		/**
		*@private
		*/
		__proto._layoutLater=function(){
			this.parent && (this.parent)._layoutLater();
		}

		/**
		*<p>指定是否对使用了 scrollRect 的显示对象进行优化处理。默认为false(不优化)。</p>
		*<p>当值为ture时：将对此对象使用了scrollRect 设定的显示区域以外的显示内容不进行渲染，以提高性能(如果子对象有旋转缩放或者中心点偏移，则显示筛选会不精确)。</p>
		*/
		__getset(0,__proto,'optimizeScrollRect',function(){
			return this._optimizeScrollRect;
			},function(b){
			if (this._optimizeScrollRect !=b){
				this._optimizeScrollRect=b;
				this.conchModel && this.conchModel.optimizeScrollRect(b);
			}
		});

		/**
		*设置是否开启自定义渲染，只有开启自定义渲染，才能使用customRender函数渲染。
		*/
		__getset(0,__proto,'customRenderEnable',null,function(b){
			if (b){
				this._renderType |=0x400;
				if (Render.isConchNode){
					Sprite.CustomList.push(this);
					var canvas=new HTMLCanvas("2d");
					canvas._setContext(new CanvasRenderingContext2D());
					this.customContext=new RenderContext(0,0,canvas);
					canvas.context.setCanvasType && canvas.context.setCanvasType(2);
					this.conchModel.custom(canvas.context);
				}
			}
		});

		/**
		*指定显示对象是否缓存为静态图像。功能同cacheAs的normal模式。建议优先使用cacheAs代替。
		*/
		__getset(0,__proto,'cacheAsBitmap',function(){
			return this.cacheAs!=="none";
			},function(value){
			this.cacheAs=value ? (this._$P["hasFilter"] ? "none" :"normal"):"none";
		});

		/**
		*<p>指定显示对象是否缓存为静态图像，cacheAs时，子对象发生变化，会自动重新缓存，同时也可以手动调用reCache方法更新缓存。</p>
		*<p>建议把不经常变化的“复杂内容”缓存为静态图像，能极大提高渲染性能。cacheAs有"none"，"normal"和"bitmap"三个值可选。
		*<li>默认为"none"，不做任何缓存。</li>
		*<li>当值为"normal"时，canvas模式下进行画布缓存，webgl模式下进行命令缓存。</li>
		*<li>当值为"bitmap"时，canvas模式下进行依然是画布缓存，webgl模式下使用renderTarget缓存。</li></p>
		*<p>webgl下renderTarget缓存模式缺点：会额外创建renderTarget对象，增加内存开销，缓存面积有最大2048限制，不断重绘时会增加CPU开销。优点：大幅减少drawcall，渲染性能最高。
		*webgl下命令缓存模式缺点：只会减少节点遍历及命令组织，不会减少drawcall数，性能中等。优点：没有额外内存开销，无需renderTarget支持。</p>
		*/
		__getset(0,__proto,'cacheAs',function(){
			return this._$P.cacheCanvas==null ? "none" :this._$P.cacheCanvas.type;
			},function(value){
			var cacheCanvas=this._$P.cacheCanvas;
			if (value===(cacheCanvas ? cacheCanvas.type :"none"))return;
			if (value!=="none"){
				if (!this._getBit(0x1))this._setUpNoticeType(0x1);
				cacheCanvas || (cacheCanvas=this._set$P("cacheCanvas",Pool.getItemByClass("cacheCanvas",Object)));
				cacheCanvas.type=value;
				cacheCanvas.reCache=true;
				this._renderType |=0x10;
				if (value=="bitmap")this.conchModel && this.conchModel.cacheAs(1);
				this._set$P("cacheForFilters",false);
				}else {
				if (this._$P["hasFilter"]){
					this._set$P("cacheForFilters",true);
					}else {
					if (cacheCanvas){
						var cc=cacheCanvas;
						if (cc && cc.ctx){
							Pool.recover("RenderContext",cc.ctx);
							cc.ctx.canvas.size(0,0);
							cc.ctx=null;
						}
						Pool.recover("cacheCanvas",cacheCanvas);
					}
					this._$P.cacheCanvas=null;
					this._renderType &=~0x10;
					this.conchModel && this.conchModel.cacheAs(0);
				}
			}
			this.repaint();
		});

		/**z排序，更改此值，则会按照值的大小对同一容器的所有对象重新排序。值越大，越靠上。默认为0，则根据添加顺序排序。*/
		__getset(0,__proto,'zOrder',function(){
			return this._zOrder;
			},function(value){
			if (this._zOrder !=value){
				this._zOrder=value;
				this.conchModel && this.conchModel.setZOrder && this.conchModel.setZOrder(value);
				if (this._parent){
					value && this._parent._set$P("hasZorder",true);
					Laya.timer.callLater(this._parent,this.updateZOrder);
				}
			}
		});

		/**旋转角度，默认值为0。以角度为单位。*/
		__getset(0,__proto,'rotation',function(){
			return this._style._tf.rotate;
			},function(value){
			var style=this.getStyle();
			if (style._tf.rotate!==value){
				style.setRotate(value);
				this._tfChanged=true;
				this.conchModel && this.conchModel.rotate(value);
				this._renderType |=0x04;
				var p=this._parent;
				if (p && p._repaint===0){
					p._repaint=1;
					p.parentRepaint();
				}
			}
		});

		/**
		*<p>显示对象的宽度，单位为像素，默认为0。</p>
		*<p>此宽度用于鼠标碰撞检测，并不影响显示对象图像大小。需要对显示对象的图像进行缩放，请使用scale、scaleX、scaleY。</p>
		*<p>可以通过getbounds获取显示对象图像的实际宽度。</p>
		*/
		__getset(0,__proto,'width',function(){
			if (!this.autoSize)return this._width;
			return this.getSelfBounds().width;
			},function(value){
			if (this._width!==value){
				this._width=value;
				this.conchModel && this.conchModel.size(value,this._height)
				this.repaint();
			}
		});

		/**表示显示对象相对于父容器的水平方向坐标值。*/
		__getset(0,__proto,'x',function(){
			return this._x;
			},function(value){
			if (this._x!==value){
				if (this.destroyed)return;
				this._x=value;
				this.conchModel && this.conchModel.pos(value,this._y);
				var p=this._parent;
				if (p && p._repaint===0){
					p._repaint=1;
					p.parentRepaint();
				}
				if (this._$P.maskParent && this._$P.maskParent._repaint===0){
					this._$P.maskParent._repaint=1;
					this._$P.maskParent.parentRepaint();
				}
			}
		});

		/**
		*获得相对于stage的全局Y轴缩放值（会叠加父亲节点的缩放值）。
		*/
		__getset(0,__proto,'globalScaleY',function(){
			var scale=1;
			var ele=this;
			while (ele){
				if (ele===Laya.stage)break ;
				scale *=ele.scaleY;
				ele=ele.parent;
			}
			return scale;
		});

		/**
		*<p>可以设置一个Rectangle区域作为点击区域，或者设置一个<code>HitArea</code>实例作为点击区域，HitArea内可以设置可点击和不可点击区域。</p>
		*<p>如果不设置hitArea，则根据宽高形成的区域进行碰撞。</p>
		*/
		__getset(0,__proto,'hitArea',function(){
			return this._$P.hitArea;
			},function(value){
			this._set$P("hitArea",value);
		});

		/**
		*是否静态缓存此对象的当前帧的最终属性。为 true 时，子对象变化时不会自动更新缓存，但是可以通过调用 reCache 方法手动刷新。
		*<b>注意：</b> 1. 设置 cacheAs 为非空和非"none"时才有效。 2. 由于渲染的时机在脚本执行之后，也就是说当前帧渲染的是对象的最终属性，所以如果在当前帧渲染之前、设置静态缓存之后改变对象属性，则最终渲染结果表现的是对象的最终属性。
		*/
		__getset(0,__proto,'staticCache',function(){
			return this._$P.staticCache;
			},function(value){
			this._set$P("staticCache",value);
			if (!value)this.reCache();
		});

		/**设置一个Texture实例，并显示此图片（如果之前有其他绘制，则会被清除掉）。等同于graphics.clear();graphics.drawTexture()*/
		__getset(0,__proto,'texture',function(){
			return this._texture;
			},function(value){
			if (this._texture !=value){
				this._texture=value;
				this.graphics.cleanByTexture(value,0,0);
			}
		});

		/**表示显示对象相对于父容器的垂直方向坐标值。*/
		__getset(0,__proto,'y',function(){
			return this._y;
			},function(value){
			if (this._y!==value){
				if (this.destroyed)return;
				this._y=value;
				this.conchModel && this.conchModel.pos(this._x,value);
				var p=this._parent;
				if (p && p._repaint===0){
					p._repaint=1;
					p.parentRepaint();
				}
				if (this._$P.maskParent && this._$P.maskParent._repaint===0){
					this._$P.maskParent._repaint=1;
					this._$P.maskParent.parentRepaint();
				}
			}
		});

		/**
		*<p>显示对象的高度，单位为像素，默认为0。</p>
		*<p>此高度用于鼠标碰撞检测，并不影响显示对象图像大小。需要对显示对象的图像进行缩放，请使用scale、scaleX、scaleY。</p>
		*<p>可以通过getbounds获取显示对象图像的实际高度。</p>
		*/
		__getset(0,__proto,'height',function(){
			if (!this.autoSize)return this._height;
			return this.getSelfBounds().height;
			},function(value){
			if (this._height!==value){
				this._height=value;
				this.conchModel && this.conchModel.size(this._width,value);
				this.repaint();
			}
		});

		/**指定要使用的混合模式。目前只支持"lighter"。*/
		__getset(0,__proto,'blendMode',function(){
			return this._style.blendMode;
			},function(value){
			this.getStyle().blendMode=value;
			this.conchModel && this.conchModel.blendMode(value);
			if (value && value !="source-over")this._renderType |=0x08;
			else this._renderType &=~0x08;
			this.parentRepaint();
		});

		/**X轴缩放值，默认值为1。设置为负数，可以实现水平反转效果，比如scaleX=-1。*/
		__getset(0,__proto,'scaleX',function(){
			return this._style._tf.scaleX;
			},function(value){
			var style=this.getStyle();
			if (style._tf.scaleX!==value){
				style.setScaleX(value);
				this._tfChanged=true;
				this.conchModel && this.conchModel.scale(value,style._tf.scaleY);
				this._renderType |=0x04;
				var p=this._parent;
				if (p && p._repaint===0){
					p._repaint=1;
					p.parentRepaint();
				}
			}
		});

		/**Y轴缩放值，默认值为1。设置为负数，可以实现垂直反转效果，比如scaleX=-1。*/
		__getset(0,__proto,'scaleY',function(){
			return this._style._tf.scaleY;
			},function(value){
			var style=this.getStyle();
			if (style._tf.scaleY!==value){
				style.setScaleY(value);
				this._tfChanged=true;
				this.conchModel && this.conchModel.scale(style._tf.scaleX,value);
				this._renderType |=0x04;
				var p=this._parent;
				if (p && p._repaint===0){
					p._repaint=1;
					p.parentRepaint();
				}
			}
		});

		/**对舞台 <code>stage</code> 的引用。*/
		__getset(0,__proto,'stage',function(){
			return Laya.stage;
		});

		/**水平倾斜角度，默认值为0。以角度为单位。*/
		__getset(0,__proto,'skewX',function(){
			return this._style._tf.skewX;
			},function(value){
			var style=this.getStyle();
			if (style._tf.skewX!==value){
				style.setSkewX(value);
				this._tfChanged=true;
				this.conchModel && this.conchModel.skew(value,style._tf.skewY);
				this._renderType |=0x04;
				var p=this._parent;
				if (p && p._repaint===0){
					p._repaint=1;
					p.parentRepaint();
				}
			}
		});

		/**
		*<p>显示对象的滚动矩形范围，具有裁剪效果(如果只想限制子对象渲染区域，请使用viewport)，设置optimizeScrollRect=true，可以优化裁剪区域外的内容不进行渲染。</p>
		*<p> srollRect和viewport的区别：<br/>
		*1.srollRect自带裁剪效果，viewport只影响子对象渲染是否渲染，不具有裁剪效果（性能更高）。<br/>
		*2.设置rect的x,y属性均能实现区域滚动效果，但scrollRect会保持0,0点位置不变。</p>
		*/
		__getset(0,__proto,'scrollRect',function(){
			return this._style.scrollRect;
			},function(value){
			this.getStyle().scrollRect=value;
			this.repaint();
			if (value){
				this._renderType |=0x80;
				this.conchModel && this.conchModel.scrollRect(value.x,value.y,value.width,value.height);
				}else {
				this._renderType &=~0x80;
				if (this.conchModel){
					if (Sprite.RUNTIMEVERION < "0.9.1")
						this.conchModel.removeType(0x40);
					else
					this.conchModel.removeType(0x80);
				}
			}
		});

		/**垂直倾斜角度，默认值为0。以角度为单位。*/
		__getset(0,__proto,'skewY',function(){
			return this._style._tf.skewY;
			},function(value){
			var style=this.getStyle();
			if (style._tf.skewY!==value){
				style.setSkewY(value);
				this._tfChanged=true;
				this.conchModel && this.conchModel.skew(style._tf.skewX,value);
				this._renderType |=0x04;
				var p=this._parent;
				if (p && p._repaint===0){
					p._repaint=1;
					p.parentRepaint();
				}
			}
		});

		/**
		*<p>对象的矩阵信息。通过设置矩阵可以实现节点旋转，缩放，位移效果。</p>
		*<p>矩阵更多信息请参考 <code>Matrix</code></p>
		*/
		__getset(0,__proto,'transform',function(){
			return this._tfChanged ? this._adjustTransform():this._transform;
			},function(value){
			this._tfChanged=false;
			this._transform=value;
			if (value){
				this._x=value.tx;
				this._y=value.ty;
				value.tx=value.ty=0;
				this.conchModel && this.conchModel.transform(value.a,value.b,value.c,value.d,this._x,this._y);
			}
			if (value)this._renderType |=0x04;
			else {
				this._renderType &=~0x04;
				this.conchModel && this.conchModel.removeType(0x04);
			}
			this.parentRepaint();
		});

		/**X轴 轴心点的位置，单位为像素，默认为0。轴心点会影响对象位置，缩放中心，旋转中心。*/
		__getset(0,__proto,'pivotX',function(){
			return this._style._tf.translateX;
			},function(value){
			this.getStyle().setTranslateX(value);
			this.conchModel && this.conchModel.pivot(value,this._style._tf.translateY);
			this.repaint();
		});

		/**Y轴 轴心点的位置，单位为像素，默认为0。轴心点会影响对象位置，缩放中心，旋转中心。*/
		__getset(0,__proto,'pivotY',function(){
			return this._style._tf.translateY;
			},function(value){
			this.getStyle().setTranslateY(value);
			this.conchModel && this.conchModel.pivot(this._style._tf.translateX,value);
			this.repaint();
		});

		/**透明度，值为0-1，默认值为1，表示不透明。更改alpha值会影响drawcall。*/
		__getset(0,__proto,'alpha',function(){
			return this._style.alpha;
			},function(value){
			if (this._style && this._style.alpha!==value){
				value=value < 0 ? 0 :(value > 1 ? 1 :value);
				this.getStyle().alpha=value;
				this.conchModel && this.conchModel.alpha(value);
				if (value!==1)this._renderType |=0x02;
				else this._renderType &=~0x02;
				this.parentRepaint();
			}
		});

		/**表示是否可见，默认为true。如果设置不可见，节点将不被渲染。*/
		__getset(0,__proto,'visible',function(){
			return this._style.visible;
			},function(value){
			if (this._style && this._style.visible!==value){
				this.getStyle().visible=value;
				this.conchModel && this.conchModel.visible(value);
				this.parentRepaint();
			}
		});

		/**绘图对象。封装了绘制位图和矢量图的接口，Sprite所有的绘图操作都通过Graphics来实现的。*/
		__getset(0,__proto,'graphics',function(){
			return this._graphics || (this.graphics=RunDriver.createGraphics());
			},function(value){
			if (this._graphics)this._graphics._sp=null;
			this._graphics=value;
			if (value){
				this._renderType &=~0x01;
				this._renderType |=0x200;
				value._sp=this;
				this.conchModel && this.conchModel.graphics(this._graphics);
				}else {
				this._renderType &=~0x200;
				this._renderType &=~0x01;
				if (this.conchModel){
					if (Sprite.RUNTIMEVERION < "0.9.1")
						this.conchModel.removeType(0x100);
					else
					this.conchModel.removeType(0x200);
				}
			}
			this.repaint();
		});

		/**滤镜集合。可以设置多个滤镜组合。*/
		__getset(0,__proto,'filters',function(){
			return this._$P.filters;
			},function(value){
			value && value.length===0 && (value=null);
			if (this._$P.filters==value)return;
			this._set$P("filters",value ? value.slice():null);
			if (Render.isConchApp){
				if (this.conchModel){
					if (Sprite.RUNTIMEVERION < "0.9.1")
						this.conchModel.removeType(0x10);
					else
					this.conchModel.removeType(0x20);
				}
				if (this._$P.filters && this._$P.filters.length==1){
					this._$P.filters[0].callNative(this);
				}
			}
			if (Render.isWebGL){
				if (value && value.length){
					this._renderType |=0x20;
					}else {
					this._renderType &=~0x20;
				}
			}
			if (value && value.length > 0){
				if (!this._getBit(0x1))this._setUpNoticeType(0x1);
				if (!(Render.isWebGL && value.length==1 && (((value[0])instanceof laya.filters.ColorFilter )))){
					if (this.cacheAs !="bitmap"){
						if (!Render.isConchNode)this.cacheAs="bitmap";
						this._set$P("cacheForFilters",true);
					}
					this._set$P("hasFilter",true);
				}
				}else {
				this._set$P("hasFilter",false);
				if (this._$P["cacheForFilters"] && this.cacheAs=="bitmap"){
					this.cacheAs="none";
				}
			}
			this.repaint();
		});

		__getset(0,__proto,'parent',_super.prototype._$get_parent,function(value){
			_super.prototype._$set_parent.call(this,value);
			if (value && this._getBit(0x2)){
				this._$2__onDisplay();
			}
		});

		/**
		*<p>遮罩，可以设置一个对象(支持位图和矢量图)，根据对象形状进行遮罩显示。</p>
		*<p>【注意】遮罩对象坐标系是相对遮罩对象本身的，和Flash机制不同</p>
		*/
		__getset(0,__proto,'mask',function(){
			return this._$P._mask;
			},function(value){
			if (value && this.mask && this.mask._$P.maskParent)return;
			if (value){
				this.cacheAs="bitmap";
				this._set$P("_mask",value);
				value._set$P("maskParent",this);
				}else {
				this.cacheAs="none";
				this.mask && this.mask._set$P("maskParent",null);
				this._set$P("_mask",value);
			}
			this.conchModel && this.conchModel.mask(value ? value.conchModel :null);
			this._renderType |=0x40;
			this.parentRepaint();
		});

		/**
		*是否接受鼠标事件。
		*默认为false，如果监听鼠标事件，则会自动设置本对象及父节点的属性 mouseEnable 的值都为 true（如果父节点手动设置为false，则不会更改）。
		**/
		__getset(0,__proto,'mouseEnabled',function(){
			return this._mouseEnableState > 1;
			},function(value){
			this._mouseEnableState=value ? 2 :1;
		});

		/**
		*获得相对于stage的全局X轴缩放值（会叠加父亲节点的缩放值）。
		*/
		__getset(0,__proto,'globalScaleX',function(){
			var scale=1;
			var ele=this;
			while (ele){
				if (ele===Laya.stage)break ;
				scale *=ele.scaleX;
				ele=ele.parent;
			}
			return scale;
		});

		/**
		*返回鼠标在此对象坐标系上的 X 轴坐标信息。
		*/
		__getset(0,__proto,'mouseX',function(){
			return this.getMousePoint().x;
		});

		/**
		*返回鼠标在此对象坐标系上的 Y 轴坐标信息。
		*/
		__getset(0,__proto,'mouseY',function(){
			return this.getMousePoint().y;
		});

		Sprite.fromImage=function(url){
			return new Sprite().loadImage(url);
		}

		Sprite.CustomList=[];
		__static(Sprite,
		['RUNTIMEVERION',function(){return this.RUNTIMEVERION=window.conch?conchConfig.getRuntimeVersion().substr(conchConfig.getRuntimeVersion().lastIndexOf('-')+1):'';}
		]);
		return Sprite;
	})(Node)


	/**
	*@private
	*<code>Bitmap</code> 是图片资源类。
	*/
	//class laya.resource.Bitmap extends laya.resource.Resource
	var Bitmap=(function(_super){
		function Bitmap(){
			//this._source=null;
			//this._w=NaN;
			//this._h=NaN;
			this.useNum=0;
			Bitmap.__super.call(this);
			this._w=0;
			this._h=0;
		}

		__class(Bitmap,'laya.resource.Bitmap',_super);
		var __proto=Bitmap.prototype;
		/**
		*彻底清理资源。
		*/
		__proto.dispose=function(){
			if (this.disposed)return;
			this._resourceManager.removeResource(this);
			_super.prototype.dispose.call(this);
		}

		/***
		*宽度。
		*/
		__getset(0,__proto,'width',function(){
			return this._w;
		});

		/***
		*高度。
		*/
		__getset(0,__proto,'height',function(){
			return this._h;
		});

		/***
		*HTML Image 或 HTML Canvas 或 WebGL Texture 。
		*/
		__getset(0,__proto,'source',function(){
			return this._source;
		});

		return Bitmap;
	})(Resource)


	/**
	*@private
	*audio标签播放声音的音轨控制
	*/
	//class laya.media.h5audio.AudioSoundChannel extends laya.media.SoundChannel
	var AudioSoundChannel=(function(_super){
		function AudioSoundChannel(audio){
			this._audio=null;
			this._onEnd=null;
			this._resumePlay=null;
			AudioSoundChannel.__super.call(this);
			this._onEnd=Utils$1.bind(this.__onEnd,this);
			this._resumePlay=Utils$1.bind(this.__resumePlay,this);
			audio.addEventListener("ended",this._onEnd);
			this._audio=audio;
		}

		__class(AudioSoundChannel,'laya.media.h5audio.AudioSoundChannel',_super);
		var __proto=AudioSoundChannel.prototype;
		__proto.__onEnd=function(){
			if (this.loops==1){
				if (this.completeHandler){
					Laya.timer.once(10,this,this.__runComplete,[this.completeHandler],false);
					this.completeHandler=null;
				}
				this.stop();
				this.event("complete");
				return;
			}
			if (this.loops > 0){
				this.loops--;
			}
			this.play();
		}

		__proto.__resumePlay=function(){
			if(this._audio)this._audio.removeEventListener("canplay",this._resumePlay);
			try {
				this._audio.currentTime=this.startTime;
				Browser.container.appendChild(this._audio);
				this._audio.play();
				}catch (e){
				this.event("error");
			}
		}

		/**
		*播放
		*/
		__proto.play=function(){
			this.isStopped=false;
			try {
				this._audio.playbackRate=SoundManager.playbackRate;
				this._audio.currentTime=this.startTime;
				}catch (e){
				this._audio.addEventListener("canplay",this._resumePlay);
				return;
			}
			SoundManager.addChannel(this);
			Browser.container.appendChild(this._audio);
			if("play" in this._audio)
				this._audio.play();
		}

		/**
		*停止播放
		*
		*/
		__proto.stop=function(){
			this.isStopped=true;
			SoundManager.removeChannel(this);
			this.completeHandler=null;
			if (!this._audio)
				return;
			if ("pause" in this._audio)
				if (Render.isConchApp){
				this._audio.stop();
			}
			this._audio.pause();
			this._audio.removeEventListener("ended",this._onEnd);
			this._audio.removeEventListener("canplay",this._resumePlay);
			if (!Browser.onIE){
				if (this._audio!=AudioSound._musicAudio){
					Pool.recover("audio:"+this.url,this._audio);
				}
			}
			Brows