
(function(window,document,Laya){
	var __un=Laya.un,__uns=Laya.uns,__static=Laya.static,__class=Laya.class,__getset=Laya.getset,__newvec=Laya.__newvec;

	var Animation=laya.display.Animation,AnimationPlayerBase=laya.display.AnimationPlayerBase,Base64ImageTool=laya.debug.tools.Base64ImageTool;
	var BitmapFont=laya.display.BitmapFont,Box=laya.ui.Box,Browser=laya.utils.Browser,Button=laya.ui.Button,CheckBox=laya.ui.CheckBox;
	var ClassTool=laya.debug.tools.ClassTool,ClassUtils=laya.utils.ClassUtils,Clip=laya.ui.Clip,ColorPicker=laya.ui.ColorPicker;
	var ColorSelector=laya.debug.tools.ColorSelector,ColorTool=laya.debug.tools.ColorTool,ComboBox=laya.ui.ComboBox;
	var Component=laya.ui.Component,Dialog=laya.ui.Dialog,DisControlTool=laya.debug.tools.DisControlTool,DisPool=laya.debug.tools.DisPool;
	var Ease=laya.utils.Ease,EffectAnimation=laya.display.EffectAnimation,Event=laya.events.Event,EventDispatcher=laya.events.EventDispatcher;
	var FileBitmap=laya.resource.FileBitmap,Font=laya.display.css.Font,FrameAnimation=laya.display.FrameAnimation;
	var Graphics=laya.display.Graphics,HScrollBar=laya.ui.HScrollBar,HSlider=laya.ui.HSlider,HTMLCanvas=laya.resource.HTMLCanvas;
	var HTMLDivElement=laya.html.dom.HTMLDivElement,Handler=laya.utils.Handler,HttpRequest=laya.net.HttpRequest;
	var IDTools=laya.debug.tools.IDTools,Image=laya.ui.Image,Input=laya.display.Input,JSTools=laya.debug.tools.JSTools;
	var JsonTool=laya.debug.tools.JsonTool,KeyBoardManager=laya.events.KeyBoardManager,Keyboard$1=laya.events.Keyboard;
	var Label=laya.ui.Label,LayoutFuns=laya.debug.tools.layout.LayoutFuns,LayoutTools=laya.debug.tools.LayoutTools;
	var Layouter=laya.debug.tools.layout.Layouter,List=laya.ui.List,Loader=laya.net.Loader,MathUtil=laya.maths.MathUtil;
	var Matrix=laya.maths.Matrix,MouseManager=laya.events.MouseManager,MovieClip=laya.ani.swf.MovieClip,Node=laya.display.Node;
	var NodeUtils=laya.debug.view.nodeInfo.NodeUtils,Notice=ide.managers.Notice,Notices=ide.event.Notices,ObjectTools$1=laya.debug.tools.ObjectTools;
	var Panel=laya.ui.Panel,Particle2D=laya.particle.Particle2D,Point=laya.maths.Point,Pool=laya.utils.Pool,Rectangle=laya.maths.Rectangle;
	var Render=laya.renders.Render,RenderContext=laya.renders.RenderContext,RenderSprite=laya.renders.RenderSprite;
	var ScrollBar=laya.ui.ScrollBar,SingleTool=laya.debug.tools.SingleTool,Skeleton=laya.ani.bone.Skeleton,Slider=laya.ui.Slider;
	var SoundNode=laya.media.SoundNode,Sprite=laya.display.Sprite,Stage=laya.display.Stage,Stat=laya.utils.Stat;
	var StringTool$1=laya.debug.tools.StringTool,Styles=laya.ui.Styles,Tab=laya.ui.Tab,Text=laya.display.Text;
	var TextArea=laya.ui.TextArea,TextInput=laya.ui.TextInput,Texture=laya.resource.Texture,TimeTool=laya.debug.tools.TimeTool;
	var TraceTool=laya.debug.tools.TraceTool,Tree=laya.ui.Tree,Tween=laya.utils.Tween,UIConfig=Laya.UIConfig;
	var UIEvent$1=laya.ui.UIEvent,URL=laya.net.URL,Utils$1=laya.utils.Utils,VScrollBar=laya.ui.VScrollBar,View=laya.ui.View;
	var ViewRenderBase=viewRender.ViewRenderBase,ViewStack=laya.ui.ViewStack,WalkTools=laya.debug.tools.WalkTools;
	var XML2Object=laya.debug.tools.XML2Object,XML2ObjectNodejs=laya.debug.tools.XML2ObjectNodejs;
	Laya.interface('laya.editor.core.IClip');
	Laya.interface('laya.editor.core.IContent');
	Laya.interface('as3analyser.parser.struct.ICodePiece');
	Laya.interface('laya.editor.core.Wraps.xml.IXMLElement');
	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-8-30 上午9:49:01
	*/
	//class as3analyser.As3ParserTool
	var As3ParserTool=(function(){
		function As3ParserTool(){}
		__class(As3ParserTool,'as3analyser.As3ParserTool');
		As3ParserTool.parserAsFile=function(path){
			var parser;
			parser=new AsFileParser();
			parser.setFile(path);
			console.log("parser:",parser);
		}

		return As3ParserTool;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-8-31 下午7:38:09
	*/
	//class as3analyser.parser.AsFileParser
	var AsFileParser=(function(){
		function AsFileParser(){
			this.oTxt=null;
			this.adptTxt=null;
			this.lines=null;
			this.rawLines=null;
			this.path=null;
			this.functionList=[];
			this.packageName=null;
			this.className=null;
			this.classNameFull=null;
			this.importList=null;
			this.importListRaw=null;
			this.memberDic={};
			this.allMemberDic={};
			this.parentClass=null;
			this.interfaces=[];
			this.type=null;
			this.pType=null;
			this.dependClassDic={};
			this.directReferDic={};
			this.varDic={};
			this.functionDic={};
			this.notUsedImportList=[];
			this.codeT=null;
			this.code=null;
			this.isWorkFile=true;
			ASLex.init();
		}

		__class(AsFileParser,'as3analyser.parser.AsFileParser');
		var __proto=AsFileParser.prototype;
		__proto.reset=function(){}
		__proto.setFile=function(path){
			this.path=path;
			this.oTxt=ToolFuns.readTxtFile(path);
			if(!this.oTxt)return;
			this.setClassStr(this.oTxt);
		}

		__proto.setClassStr=function(oTxt){
			this.rawLines=LineItem.getLineItems(oTxt,true,true);
			this.lines=StringTool.removeCommentLineS(this.rawLines);
			this.parse();
			if(this.type=="class")
				this.build();
		}

		__proto.parse=function(){
			var i=0;
			var len=0;
			var tline;
			var tmpStr;
			len=this.lines.length;
			i=this.findFirstMatchLine("package");
			tline=this.lines[i];
			this.packageName=StringTool.trimExt(tline.lineStr,["package",";","{"]);
			i++;
			i=this.findFirstMatchLine("class ",i);
			this.type="class";
			if(i<0){
				i=this.findFirstMatchLine("interface ",i);
				this.type="interface";
			}
			if(i<0){
				i=this.findFirstMatchLine("function ",i);
				this.type="function";
			}
			if(i<0){
				i=this.findFirstMatchLine("var ",i);
				this.type="var";
			}
			if(i<0){
				i=this.findFirstMatchLine("namespace",i);
				this.type="namespace";
			}
			tline=this.lines[i];
			var tLineWords;
			tLineWords=StringTool.getSplitLine(tline.lineStr);
			this.parseClassInfo(tLineWords,this.type);
			if(this.type=="class")
				this.parseClassBody(i);
			this.importList=[];
			this.importListRaw=[];
			len=this.lines.length;
			for(i=0;i<len;i++){
				tmpStr=this.lines[i].lineStr;
				tmpStr=StringTool.trimButEmpty(tmpStr);
				tLineWords=StringTool.getWords(tmpStr);
				if(tLineWords[0]=="import"){
					tmpStr=StringTool.trimExt(tmpStr,["import",";"]);
					this.importList.push(tmpStr);
					this.importListRaw.push(tline);
				}
			}
		}

		__proto.parseClassBody=function(i){
			var cCount=0;
			var len=0;
			var tLine;
			var tCIndex=0;
			var lineLen=0;
			var lineStr;
			var tPair;
			var tPos;
			len=this.lines.length;
			i=this.findFirstMatchLine("{",i);
			i++;
			tPos=new PosItem(i,0);
			var sPos;
			var preLine=0;
			preLine=0;
			tPos.line=this.findFirstMatchLine(" function ",i);
			if(tPos.line>=0)
				tPair=StringTool.findPair("{","}",tPos,this.lines);
			this.codeT="";
			var tFun;
			while(tPair&&tPair.length>1){
				tFun=this.parseFunction(tPair);
				tPos=tPair[tPair.length-1];
				sPos=tPair[0];
				tPos.index++;
				if(tFun.hasAsy||1){
					this.codeT+="\n"+StringTool.getSelectLinesStr(this.rawLines,preLine-1,tFun.posStart.line-2)+"\n"+this.getFunctionHold(this.functionList.length-1)+"\n";
					preLine=tFun.posEnd.line+1;
				}
				tPos.line=this.findFirstMatchLine(" function ",tPos.line);
				if(tPos.line<0)break ;
				tPair=StringTool.findPair("{","}",tPos,this.lines);
			}
			if(preLine<this.rawLines.length){
				this.codeT+="\n"+StringTool.getSelectLinesStr(this.rawLines,preLine-1,this.rawLines.length);
			}
			this.parseClassMembers();
		}

		__proto.parseClassMembers=function(){
			var codeLines;
			codeLines=LineItem.getLineItems(this.codeT,true,true);
			var i=0;
			var len=0;
			var tLine;
			var tStr;
			len=codeLines.length;
			for(i=0;i<len;i++){
				tLine=codeLines[i];
				tStr=tLine.lineStr;
				this.addMember(tStr);
			}
		}

		__proto.addMember=function(tStr){
			var tMember;
			if(SingleMemberParser.getMemberType(tStr)){
				tMember=SingleMemberParser.parseMember(tStr);
				this.addMemberOne(tMember);
			}
		}

		__proto.addMemberOne=function(tMember){
			this.allMemberDic[tMember.name]=tMember;
			if(!tMember.modifiesO["static"]){
				this.memberDic[tMember.name]=tMember;
			}
		}

		//trace("add mem:"+tMember.name+" type:"+tMember.type);
		__proto.getFunctionHold=function(funID){
			return "{functionHolder_"+funID+"}";
		}

		__proto.build=function(){}
		// }
		__proto.parseFunction=function(pari){
			var functionLinePos;
			functionLinePos=this.traceBack(pari[0]," function");
			if(functionLinePos){
				var tFunctionDefineLine;
				var lineStr;
				tFunctionDefineLine=this.lines[functionLinePos.line];
				this.addMember(tFunctionDefineLine.lineStr);
				var tFun;
				tFun=new FunctionItem();
				tFun.setData(tFunctionDefineLine,StringTool.getLines(functionLinePos,pari[pari.length-1],this.lines,this.rawLines));
				this.functionList.push(tFun);
				return tFun;
			}
			return null;
		}

		__proto.traceBack=function(pos,str){
			var tLineItem;
			var len=0;
			len=pos.line;
			var i=0;
			var lineStr;
			var tIndex=0;
			for(i=len;i>=0;i--){
				tLineItem=this.lines[i];
				lineStr=tLineItem.lineStr;
				tIndex=lineStr.indexOf(str);
				if(tIndex>=0){
					var rst;
					rst=new PosItem();
					rst.line=i;
					rst.index=tIndex;
					rst.str=str;
					rst.oLine=tLineItem.lineIndex;
					return rst;
				}
			}
			return null;
		}

		__proto.setFullName=function(fullName){
			this.classNameFull=fullName;
			var i=0;
			i=fullName.lastIndexOf(".");
			if(i>=0){
				this.className=fullName.substr(i+1);
				this.packageName=fullName.substr(0,i-1);
				}else{
				this.className=fullName;
			}
		}

		__proto.traceMyInfo=function(){
			console.log("package:"+this.packageName);
			console.log("className:"+this.className);
			console.log("classNameFull:"+this.classNameFull);
			console.log("parentClass:"+this.parentClass);
			console.log("interfaces:"+this.interfaces.join("|"));
		}

		__proto.parseClassInfo=function(words,type){
			(type===void 0)&& (type="class");
			this.type=type;
			var i=0;
			var word;
			i=words.indexOf(type);
			if(i>0){
				this.pType=words[i-1];
				}else{
				this.pType="internal";
			}
			i++;
			this.className=StringTool.trim(words[i]);
			if(type=="var"){
				this.className=this.className.split(":")[0];
			}
			if(type=="function"){
				this.className=this.className.split("(")[0];
			};
			var len=0;
			len=words.length;
			i++;
			while(i<len){
				word=words[i];
				switch(word){
					case "extends":
						i++;
						this.parentClass=StringTool.trim(words[i]);
						break ;
					case "implements":
						i++;
						words[i]=StringTool.trim(words[i]);
						this.interfaces=words[i].split(",");
						break ;
					}
				i++;
			}
			if(this.packageName!=""){
				this.classNameFull=this.packageName+"."+this.className;
				}else{
				this.classNameFull=this.className;
			}
		}

		__proto.findFirstMatchLine=function(str,startLine){
			(startLine===void 0)&& (startLine=0);
			var i=0;
			var len=0;
			var tLine;
			len=this.lines.length;
			if(startLine<0)startLine=0;
			for(i=startLine;i<len;i++){
				tLine=this.lines[i].lineStr;
				if(tLine.indexOf(str)>=0){
					return i;
				}
			}
			return-1;
		}

		AsFileParser.workAFile=function(filePath,outPutPath){
			if(!outPutPath)outPutPath=filePath;
			var asfile;
			asfile=new AsFileParser();
			asfile.setFile(filePath);
			if(asfile.isWorkFile){
				var data;
				data=asfile.code;
				if(data.indexOf("/*[COMPILER OPTIONS:DISABLE2SYNC]*/")<0){
					data=StringTool.insertAfter(data,"\n"+"/*[COMPILER OPTIONS:DISABLE2SYNC]*/","{");
				}
				data=StringTool.structfy(data);
				ToolFuns.saveTxtFile(outPutPath,data);
			}
		}

		AsFileParser.workFileList=function(fileList){
			var i=0;
			var len=0;
			len=fileList.length;
			for(i=0;i<len;i++){
				AsFileParser.workAFile(fileList[i]);
			}
		}

		AsFileParser.insertSign="/*[COMPILER OPTIONS:DISABLE2SYNC]*/";
		return AsFileParser;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-9-1 上午9:37:34
	*/
	//class as3analyser.parser.Defines
	var Defines=(function(){
		function Defines(){}
		__class(Defines,'as3analyser.parser.Defines');
		Defines.getParam=function(line){
			Defines.commonParam[1]=line;
			return Defines.commonParam;
		}

		Defines.isBWrap=function(str){
			return str=="{"||str=="}";
		}

		Defines.isNoWrapLine=function(line){
			var tStr;
			tStr=line.lineStr;
			if(tStr.indexOf("case ")>=0)return true;
			if(tStr.indexOf("break;")>=0)return true;
			if(tStr.indexOf("default")>=0)return true;
			return false;
		}

		Defines.Var="var";
		Defines.Expression="Expression";
		Defines.FunctionDefine="FunctionDefine";
		Defines.CallFun="CallFun";
		Defines.Block="Block";
		Defines.While="While";
		Defines.For="For";
		__static(Defines,
		['specialCallList',function(){return this.specialCallList=
			[
			"Sync.wait",
			"Sync.sleep",
			"Sync.load",
			"Sync::work.connectTo",
			"Far::netObj"];},'FunParams',function(){return this.FunParams={
				"Sync.wait":["null","null","_$this"],
				"Sync.sleep":["1000"],
				"Sync.load":["null","null"],
				"Sync::work.connectTo":["null"],
				"Far::netObj":[],
				"Sync::work.getFarObject":[]
		};},'commonParam',function(){return this.commonParam=["__$",0];}

		]);
		return Defines;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-9-1 下午5:18:21
	*/
	//class as3analyser.parser.struct.CodePiece
	var CodePiece=(function(){
		function CodePiece(){
			this.lines=null;
			this.posStart=null;
			this.posEnd=null;
			this.type=null;
			this.code=null;
			this.oCode=null;
			this.hasAsy=false;
			this.posStart=new PosItem();
			this.posEnd=new PosItem();
		}

		__class(CodePiece,'as3analyser.parser.struct.CodePiece');
		var __proto=CodePiece.prototype;
		Laya.imps(__proto,{"as3analyser.parser.struct.ICodePiece":true})
		__proto.dealContinue=function(){
			this.code=StringTool.getReplace(this.code,"continue","{__line=0;continue}");
		}

		__proto.isAsy=function(){
			return this.hasAsy;
		}

		__proto.setLines=function(lines){
			this.lines=lines;
			var i=0;
			var len=0;
			var tPiece;
			len=lines.length;
			for(i=0;i<len;i++){
				tPiece=lines[i];
				if(tPiece.isAsy()){
					this.hasAsy=true;
					break ;
				}
			}
			this.oCode=StringTool.getPiecesCode(lines);
			this.posStart.line=(lines [0]).getStartLine();
			this.posEnd.line=(lines [lines.length-1]).getEndLine();
		}

		__proto.getCode=function(){
			if(!this.hasAsy)return this.oCode;
			return this.code;
		}

		__proto.getEndLine=function(){
			return this.posEnd.line;
		}

		__proto.getStartLine=function(){
			return this.posStart.line;
		}

		return CodePiece;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-9-23 下午5:10:24
	*/
	//class as3analyser.parser.lex.ASLex
	var ASLex=(function(){
		function ASLex(){}
		__class(ASLex,'as3analyser.parser.lex.ASLex');
		ASLex.isWordBegin=function(s){
			return ASLex.alphaSigns[s]||ASLex.extSigns[s];
		}

		ASLex.isWordBody=function(s){
			return ASLex.isWordBegin(s)||ASLex.numSigns[s];
		}

		ASLex.init=function(){
			ASLex.addSign("a","z",ASLex.alphaSigns);
			ASLex.addSign("A","Z",ASLex.alphaSigns);
			ASLex.addSign("0","9",ASLex.numSigns);
		}

		ASLex.addSign=function(ss,e,tar){
			var i=0;
			var len=0;
			var s=0;
			s=ss.charCodeAt(0);
			len=e.charCodeAt(0);
			for(i=s;i<=len;i++){
				tar[String.fromCharCode(i)]=true;
			}
		}

		ASLex.toWords=function(str){
			var i=0;
			var tWord;
			var len=0;
			len=str.length;
			var rst=[];
			var tch;
			for(i=0;i<len;i++){
				tch=str.charAt(i);
				if(!tWord){
					createNewWord();
					}else{
					if(tWord.type=="Word"&&ASLex.isWordBody(tch)){
						tWord.str+=tch;
						}else{
						savePre();
						createNewWord();
					}
				}
			}
			savePre();
			return rst;
			function savePre (){
				if(tWord){
					tWord.endPos=i-1;
					rst.push(tWord);
				}
			}
			function createNewWord (){
				tWord=new ASWord();
				tWord.str=tch;
				tWord.sPos=i;
				if(ASLex.isWordBegin(tch)){
					tWord.type="Word";
					}else{
					tWord.type="Other";
				}
			}
		}

		ASLex.numSigns={};
		__static(ASLex,
		['alphaSigns',function(){return this.alphaSigns={
		};},'extSigns',function(){return this.extSigns={"_":true,"$":true};}

		]);
		return ASLex;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-9-23 下午5:12:46
	*/
	//class as3analyser.parser.lex.ASWord
	var ASWord=(function(){
		function ASWord(){
			this.str="";
			this.sPos=0;
			this.endPos=0;
			this.type="Other";
		}

		__class(ASWord,'as3analyser.parser.lex.ASWord');
		ASWord.wordListToStr=function(wordList){
			var strs=[];
			var i=0;
			var len=0;
			len=wordList.length;
			for(i=0;i<len;i++){
				strs.push(wordList[i].str);
			}
			return strs.join("");
		}

		ASWord.Word="Word";
		ASWord.Other="Other";
		return ASWord;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-8-31 下午7:41:04
	*/
	//class as3analyser.parser.LineItem
	var LineItem=(function(){
		function LineItem(){
			this.lineIndex=0;
			this.lineStr=null;
			this.lineType=null;
			this.paramed=false;
			this.data=null;
			this.hasAsy=false;
		}

		__class(LineItem,'as3analyser.parser.LineItem');
		var __proto=LineItem.prototype;
		Laya.imps(__proto,{"as3analyser.parser.struct.ICodePiece":true})
		__proto.isAsy=function(){
			return this.data||this.hasAsy;
		}

		__proto.getCode=function(){
			if(this.data){
				return "return "+this.lineStr;
				}else{
				return this.lineStr;
			}
		}

		__proto.getEndLine=function(){
			return this.lineIndex;
		}

		__proto.getStartLine=function(){
			return this.lineIndex;
		}

		LineItem.create=function(str,lineIndex){
			var rst;
			rst=new LineItem();
			rst.lineStr=str;
			rst.lineIndex=lineIndex;
			return rst;
		}

		LineItem.getLineItems=function(str,ifTrim,reStruct){
			(ifTrim===void 0)&& (ifTrim=false);
			(reStruct===void 0)&& (reStruct=false);
			var lines;
			var i=0;
			var len=0;
			var tLine;
			var rst;
			var daptStr;
			var nLine;
			rst=[];
			lines=str.split("\n");
			len=lines.length;
			for(i=0;i<len;i++){
				tLine=new LineItem();
				tLine.lineIndex=1+i;
				tLine.lineStr=lines[i];
				rst.push(tLine);
				if(ifTrim){
					tLine.lineStr=StringTool.trimLeft(tLine.lineStr);
				}
				if(reStruct&&0){
					daptStr=StringTool.trimSide(tLine.lineStr);
					if(daptStr.length<2)continue ;
					var tSign;
					while(daptStr.length>0&&Defines.isBWrap(daptStr.charAt(daptStr.length-1))){
						nLine=new LineItem();
						nLine.lineStr=daptStr.charAt(daptStr.length-1);
						nLine.lineIndex=tLine.lineIndex+1;
						rst.push(nLine);
						daptStr=daptStr.substr(0,daptStr.length-1);
					}
				}
			}
			return rst;
		}

		return LineItem;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-8-31 下午8:23:44
	*/
	//class as3analyser.parser.PosItem
	var PosItem=(function(){
		function PosItem(line,index){
			this.line=0;
			this.index=0;
			this.str=null;
			this.oLine=0;
			(line===void 0)&& (line=0);
			(index===void 0)&& (index=0);
			this.line=line;
			this.index=index;
		}

		__class(PosItem,'as3analyser.parser.PosItem');
		PosItem.pre=function(a,b){
			if(a.line<b.line)return true;
			if(a.line>b.line)return false;
			return a.index<b.index;
		}

		return PosItem;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-9-23 下午4:01:43
	*/
	//class as3analyser.parser.SingleMemberParser
	var SingleMemberParser=(function(){
		function SingleMemberParser(){
			this.type=null;
			this.name=null;
			this.varType=null;
			this.modifiesO={};
			this.params=null;
			this.exType=null;
			this.defaultV=null;
		}

		__class(SingleMemberParser,'as3analyser.parser.SingleMemberParser');
		var __proto=SingleMemberParser.prototype;
		__proto.setLine=function(str){
			this.type=SingleMemberParser.getMemberType(str);
			str=this.getModifies(str);
			var arr;
			switch(this.type){
				case "function":
					this.name=StringTool.getBetween(str,this.type,"(",false);
					if(str.indexOf(" set ")>=0){
						this.exType="set";
					}
					if(str.indexOf(" get ")>=0){
						this.exType="get";
					};
					var i=0;
					i=str.lastIndexOf(")");
					if(i>=0){
						var tail;
						tail=str.substr(i);
						if(this.exType=="set"){
							tail=StringTool.getBetween(str,"(",")",false);
						}
						i=tail.indexOf(":");
						if(i>=0){
							arr=tail.split(":");
							if(arr[1]){
								this.varType=StringTool.trim(arr[1],SingleMemberParser.trimArr);
							}
						}
					}
					break ;
				default :
					if(str.indexOf(":")>=0){
						arr=str.split(":");
						str=arr[0];
						this.varType=arr[1];
						this.varType=StringTool.trim(this.varType,SingleMemberParser.trimArr);
					}
					str=str.replace(this.type,"");
					str=StringTool.trim(str,SingleMemberParser.trimArr);
					this.name=str;
				}
			if(this.varType&&this.varType.indexOf("=")>=0){
				arr=this.varType.split("=");
				this.varType=StringTool.trim(arr[0],SingleMemberParser.trimArr);
				this.defaultV=StringTool.trim(arr[0],SingleMemberParser.trimArr);
			}
			this.name=StringTool.trim(this.name);
		}

		__proto.getModifies=function(str){
			var i=0;
			var len=0;
			len=SingleMemberParser.modifies.length;
			var tKey;
			for(i=0;i<len;i++){
				tKey=SingleMemberParser.modifies[i];
				if(str.indexOf(tKey+" ")>=0){
					this.modifiesO[tKey]=true;
					str=str.replace(tKey,"");
				}
			}
			return str;
		}

		SingleMemberParser.getMemberType=function(str){
			var i=0;
			var len=0;
			len=SingleMemberParser.keyWords.length;
			var tKey;
			for(i=0;i<len;i++){
				tKey=SingleMemberParser.keyWords[i];
				if(str.indexOf(tKey+" ")>=0)return tKey;
			}
			return null;
		}

		SingleMemberParser.parseMember=function(lineStr){
			var rst;
			rst=new SingleMemberParser();
			rst.setLine(lineStr);
			return rst;
		}

		SingleMemberParser.parseMembers=function(lineStr){
			if(lineStr.indexOf(",")>=0)return [SingleMemberParser.parseMember(lineStr)];
			var type;
			type=SingleMemberParser.getMemberType(lineStr);
			var mStr;
			var arr;
			var dStr;
			arr=lineStr.split(type);
			mStr=arr[0];
			dStr=arr[1];
			var i=0;
			var len=0;
			var strs;
			strs=dStr.split(",");
			len=strs.length;
			var rst=[];
			for(i=0;i<len;i++){
				rst.push(SingleMemberParser.parseMember(mStr+" "+type+" "+strs[i]));
			}
			return rst;
		}

		__static(SingleMemberParser,
		['trimArr',function(){return this.trimArr=[";"," ","\r","\n","\t",String.fromCharCode(65279)];},'modifies',function(){return this.modifies=["public","private","protected","internal","static","override"];},'keyWords',function(){return this.keyWords=["var","const","function"];}
		]);
		return SingleMemberParser;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-9-2 下午7:09:11
	*/
	//class as3analyser.parser.VarParser
	var VarParser=(function(){
		function VarParser(){
			this.name=null;
			this.type=null;
			this.init=null;
			this.oStr=null;
			this.noType=null;
		}

		__class(VarParser,'as3analyser.parser.VarParser');
		var __proto=VarParser.prototype;
		__proto.getDefineStr=function(){
			var rst;
			rst="var "+this.name;
			if(this.type){
				rst+=":"+this.type;
			}
			return StringTool.ifNoAddToTail(rst,";");
		}

		__proto.getInitStr=function(){
			var rst;
			return StringTool.ifNoAddToTail(this.name+"="+this.init,";");
		}

		__proto.getNoType=function(oStr){
			var notype;
			notype=oStr;
			notype=StringTool.getReplace(notype,this.type,"");
			notype=StringTool.getReplace(notype,":","");
			return notype;
		}

		VarParser.getVar=function(str,parser){
			if(!parser)parser=new VarParser();
			parser.name=null;
			parser.init=null;
			parser.type=null;
			parser.oStr=str;
			var tArr;
			if(str.indexOf("=")>=0){
				parser.init=StringTool.getRight(str,"=");
				str=StringTool.getLeft(str,"=");
			}
			if(str.indexOf(":")>=0){
				parser.type=StringTool.getRight(str,":");
				str=StringTool.getLeft(str,":");
			}
			parser.name=str;
			var notype;
			notype=parser.oStr;
			notype=StringTool.getReplace(notype,parser.type,"");
			notype=StringTool.getReplace(notype,":","");
			parser.noType=notype;
			return parser;
		}

		VarParser.parseValueLine=function(line){
			var lineStr;
			lineStr=line.lineStr;
			var defines;
			defines=lineStr.split("var ");
			defines.splice(0,1);
			defines=StringTool.removeEmptyStr(defines);
			var singleVars;
			var i=0;
			var len=0;
			len=defines.length;
			var tVars;
			var tUnit;
			singleVars=[];
			for(i=0;i<len;i++){
				tUnit=defines[i];
				tVars=tUnit.split(",");
				tVars=StringTool.removeEmptyStr(tVars);
				singleVars=singleVars.concat(tVars);
			}
			len=singleVars.length;
			var tVarStr;
			var tParser;
			var defineList;
			defineList=[];
			var initList;
			var lineCount=0;
			lineCount=line.lineIndex;
			initList=[];
			for(i=0;i<len;i++){
				tVarStr=singleVars[i];
				tParser=VarParser.getVar(tVarStr,tParser);
				defineList.push(LineItem.create(tParser.getDefineStr(),lineCount));
				if(tParser.init){
					initList.push(LineItem.create(tParser.getInitStr(),lineCount));
					lineStr=tParser.getNoType(lineStr);
					}else{
					lineStr=StringTool.getReplace(lineStr,tParser.oStr,"");
				}
			}
			lineStr=StringTool.getReplace(lineStr,"var ","");
			line.lineStr=lineStr;
			return [defineList,initList];
		}

		return VarParser;
	})()


	/**
	*一些字符串操作函数
	*@author ww
	*
	*/
	//class as3analyser.tools.StringTool
	var StringTool=(function(){
		function StringTool(){}
		__class(StringTool,'as3analyser.tools.StringTool');
		StringTool.toUpCase=function(str){
			return str.toUpperCase();
		}

		StringTool.toLowCase=function(str){
			return str.toLowerCase();
		}

		StringTool.toUpHead=function(str){
			var rst;
			if(str.length<=1)return str.toUpperCase();
			rst=str.charAt(0).toUpperCase()+str.substr(1);
			return rst;
		}

		StringTool.toLowHead=function(str){
			var rst;
			if(str.length<=1)return str.toLowerCase();
			rst=str.charAt(0).toLowerCase()+str.substr(1);
			return rst;
		}

		StringTool.packageToFolderPath=function(packageName){
			var rst;
			rst=packageName.replace(".","/");
			return rst;
		}

		StringTool.insert=function(str,iStr,index){
			return str.substring(0,index)+iStr+str.substr(index);
		}

		StringTool.insertAfter=function(str,iStr,tarStr,isLast){
			(isLast===void 0)&& (isLast=false);
			var i=0;
			if(isLast){
				i=str.lastIndexOf(tarStr);
				}else{
				i=str.indexOf(tarStr);
			}
			if(i>=0){
				return StringTool.insert(str,iStr,i+tarStr.length);
			}
			return str;
		}

		StringTool.insertBefore=function(str,iStr,tarStr,isLast){
			(isLast===void 0)&& (isLast=false);
			var i=0;
			if(isLast){
				i=str.lastIndexOf(tarStr);
				}else{
				i=str.indexOf(tarStr);
			}
			if(i>=0){
				return StringTool.insert(str,iStr,i);
			}
			return str;
		}

		StringTool.insertParamToFun=function(funStr,params){
			var oldParam;
			oldParam=StringTool.getParamArr(funStr);
			var inserStr;
			inserStr=params.join(",");
			if(oldParam.length>0){
				inserStr=","+inserStr;
			}
			return StringTool.insertBefore(funStr,inserStr,")",true);
		}

		StringTool.trim=function(str,vList){
			if(!vList){
				vList=[" ","\r","\n","\t",String.fromCharCode(65279)];
			};
			var rst;
			var i=0;
			var len=0;
			rst=str;
			len=vList.length;
			for(i=0;i<len;i++){
				rst=StringTool.getReplace(rst,vList[i],"");
			}
			return rst;
		}

		StringTool.isEmpty=function(str){
			if(str.length<1)return true;
			return StringTool.emptyStrDic.hasOwnProperty(str);
		}

		StringTool.trimLeft=function(str){
			var i=0;
			i=0;
			var len=0;
			len=str.length;
			while(StringTool.isEmpty(str.charAt(i))&&i<len){
				i++;
			}
			if(i<len){
				return str.substr(i);
			}
			return "";
		}

		StringTool.trimRight=function(str){
			var i=0;
			i=str.length-1;
			while(StringTool.isEmpty(str.charAt(i))&&i>=0){
				i--;
			};
			var rst;
			rst=str.substring(0,i)
			if(i>=0){
				return str.substring(0,i+1);
			}
			return "";
		}

		StringTool.trimSide=function(str){
			var rst;
			rst=StringTool.trimLeft(str);
			rst=StringTool.trimRight(rst);
			return rst;
		}

		StringTool.trimButEmpty=function(str){
			return StringTool.trim(str,["\r","\n","\t"]);
		}

		StringTool.removeEmptyStr=function(strArr){
			var i=0;
			i=strArr.length-1;
			var str;
			for(i=i;i>=0;i--){
				str=strArr[i];
				str=as3analyser.tools.StringTool.trimSide(str);
				if(StringTool.isEmpty(str)){
					strArr.splice(i,1);
					}else{
					strArr[i]=str;
				}
			}
			return strArr;
		}

		StringTool.ifNoAddToTail=function(str,sign){
			if(str.indexOf(sign)>=0){
				return str;
			}
			return str+sign;
		}

		StringTool.getSelectLinesStr=function(lines,startLine,endLine){
			var i=0;
			var rLines;
			rLines=[];
			if(startLine<0)startLine=0;
			if(endLine>lines.length-1)endLine=lines.length-1;
			var tLine;
			for(i=startLine;i<=endLine;i++){
				tLine=lines[i];
				rLines.push(tLine.lineStr);
			}
			return rLines.join("\n");
		}

		StringTool.getPiecesCode=function(pieces,ifTrim){
			(ifTrim===void 0)&& (ifTrim=true);
			var pArr;
			pArr=[];
			var i=0;
			var len=0;
			var tPiece;
			len=pieces.length;
			for(i=0;i<len;i++){
				tPiece=pieces[i];
				pArr.push(tPiece.getCode());
			}
			if(ifTrim){
				StringTool.trimLines(pieces);
			}
			return pArr.join("\n");
		}

		StringTool.trimEmptyLine=function(str){
			var i=0;
			var len=0;
			var tLines;
			var tLine;
			tLines=str.split("\n");
			for(i=tLines.length-1;i>=0;i--){
				tLine=tLines[i];
				if(StringTool.isEmptyLine(tLine)){
					tLines.splice(i,1);
				}
			}
			return tLines.join("\n");
		}

		StringTool.trimLines=function(lines){
			var i=0;
			i=0;
			while(lines.length>0&&StringTool.isEmptyFunLineStr(lines[0])){
				lines.shift();
			}
			while(lines.length>0&&StringTool.isEmptyFunLineStr(lines[lines.length-1])){
				lines.pop();
			}
			return lines;
		}

		StringTool.isEmptyFunLineStr=function(str){
			str=as3analyser.tools.StringTool.trim(str);
			if(Defines.isBWrap(str)){
				return true;
			}
			if(str=="")return true;
			return false;
		}

		StringTool.isEmptyLine=function(str){
			str=as3analyser.tools.StringTool.trim(str);
			if(str=="")return true;
			return false;
		}

		StringTool.removeCommentLine=function(lines){
			var rst;
			rst=[];
			var i=0;
			var tLine;
			var adptLine;
			i=0;
			var len=0;
			var index=0;
			len=lines.length;
			while(i<len){
				adptLine=tLine=lines[i];
				if((index=tLine.indexOf("/**"))&&(index>=0)){
					adptLine=tLine.substring(0,index-1);
					StringTool.addIfNotEmpty(rst,adptLine);
					while(i<len){
						tLine=lines[i];
						if((index=tLine.indexOf("*/"))&&(index>=0)){
							adptLine=tLine.substring(index+2);
							StringTool.addIfNotEmpty(rst,adptLine);
							break ;
						}
						i++;
					}
					}else if(tLine.indexOf("//")>=0){
					if(as3analyser.tools.StringTool.trim(tLine).indexOf("//")==0){
						}else{
						StringTool.addIfNotEmpty(rst,adptLine);
					}
					}else{
					StringTool.addIfNotEmpty(rst,adptLine);
				}
				i++;
			}
			return rst;
		}

		StringTool.removeCommentLineS=function(lines){
			var rst;
			rst=[];
			var i=0;
			var tLine;
			var adptLine;
			i=0;
			var len=0;
			var index=0;
			var tLineItem;
			len=lines.length;
			while(i<len){
				tLineItem=lines[i];
				adptLine=tLine=tLineItem.lineStr;
				index=tLine.indexOf("/*");
				if(index>=0){
					adptLine=tLine.substring(0,index-1);
					StringTool.addIfNotEmptyS(rst,adptLine,tLineItem);
					while(i<len){
						tLineItem=lines[i];
						adptLine=tLine=tLineItem.lineStr;
						index=tLine.indexOf("*/");
						if(index>=0){
							adptLine=tLine.substring(index+2);
							StringTool.addIfNotEmptyS(rst,adptLine,tLineItem);
							break ;
						}
						i++;
					}
					}else if(tLine.indexOf("//")>=0){
					if(as3analyser.tools.StringTool.trim(tLine).indexOf("//")==0){
						}else{
						StringTool.addIfNotEmptyS(rst,adptLine,tLineItem);
					}
					}else{
					StringTool.addIfNotEmptyS(rst,adptLine,tLineItem);
				}
				i++;
			}
			return rst;
		}

		StringTool.addIfNotEmptyS=function(arr,str,lineItem){
			if(!str)return;
			var tStr;
			tStr=StringTool.trim(str);
			if(tStr!=""){
				arr.push(lineItem);
			}
		}

		StringTool.addIfNotEmpty=function(arr,str){
			if(!str)return;
			var tStr;
			tStr=StringTool.trim(str);
			if(tStr!=""){
				arr.push(str);
			}
		}

		StringTool.trimExt=function(str,vars){
			var rst;
			rst=StringTool.trim(str);
			var i=0;
			var len=0;
			len=vars.length;
			for(i=0;i<len;i++){
				rst=StringTool.getReplace(rst,vars[i],"");
			}
			return rst;
		}

		StringTool.getBetween=function(str,left,right,ifMax){
			(ifMax===void 0)&& (ifMax=false);
			if(!str)return "";
			if(!left)return "";
			if(!right)return "";
			var lId=0;
			var rId=0;
			lId=str.indexOf(left);
			if(lId<0)return"";
			if(ifMax){
				rId=str.lastIndexOf(right);
				if(rId<lId)return "";
				}else{
				rId=str.indexOf(right,lId);
			}
			if(rId<0)return "";
			return str.substring(lId+left.length,rId);
		}

		StringTool.getSplitLine=function(line,split){
			(split===void 0)&& (split=" ");
			return line.split(split);
		}

		StringTool.getLeft=function(str,sign){
			var i=0;
			i=str.indexOf(sign);
			return str.substr(0,i);
		}

		StringTool.getRight=function(str,sign){
			var i=0;
			i=str.indexOf(sign);
			return str.substr(i+1);
		}

		StringTool.delelteItem=function(arr){
			while (arr.length>0){
				if(arr[0]==""){
					arr.shift();
					}else{
					break ;
				}
			}
		}

		StringTool.getWords=function(line){
			var rst=StringTool.getSplitLine(line);
			StringTool.delelteItem(rst);
			return rst;
		}

		StringTool.getOLine=function(pos,lines,oLines){
			var tLine=lines[pos.line];
			return oLines.indexOf(tLine);
		}

		StringTool.getLines=function(posS,posE,lines,rawLines){
			var startLine=0;
			startLine=posS.line;
			var endLine=0;
			endLine=posE.line;
			if(rawLines){
				startLine=StringTool.getOLine(posS,lines,rawLines);
				endLine=StringTool.getOLine(posE,lines,rawLines);
				lines=rawLines;
			}
			return StringTool.getLinesI(startLine,endLine,lines);
		}

		StringTool.getLinesI=function(startLine,endLine,lines){
			var i=0;
			var rst=[];
			for(i=startLine;i<=endLine;i++){
				rst.push(lines[i]);
			}
			return rst;
		}

		StringTool.structfy=function(str,inWidth,removeEmpty){
			(inWidth===void 0)&& (inWidth=4);
			(removeEmpty===void 0)&& (removeEmpty=true);
			if(removeEmpty){
				str=as3analyser.tools.StringTool.trimEmptyLine(str);
			};
			var lines;
			var tIn=0;
			tIn=0;
			var tInStr;
			tInStr=StringTool.getEmptyStr(0);
			lines=str.split("\n");
			var i=0;
			var len=0;
			var tLineStr;
			len=lines.length;
			for(i=0;i<len;i++){
				tLineStr=lines[i];
				tLineStr=as3analyser.tools.StringTool.trimLeft(tLineStr);
				tLineStr=as3analyser.tools.StringTool.trimRight(tLineStr);
				tIn+=StringTool.getPariCount(tLineStr);
				if(tLineStr.indexOf("}")>=0){
					tInStr=StringTool.getEmptyStr(tIn*inWidth);
				}
				tLineStr=tInStr+tLineStr;
				lines[i]=tLineStr;
				tInStr=StringTool.getEmptyStr(tIn*inWidth);
			}
			return lines.join("\n");
		}

		StringTool.getEmptyStr=function(width){
			if(!StringTool.emptyDic.hasOwnProperty(width)){
				var i=0;
				var len=0;
				len=width;
				var rst;
				rst="";
				for(i=0;i<len;i++){
					rst+=" ";
				}
				StringTool.emptyDic[width]=rst;
			}
			return StringTool.emptyDic[width];
		}

		StringTool.getPariCount=function(str,inChar,outChar){
			(inChar===void 0)&& (inChar="{");
			(outChar===void 0)&& (outChar="}");
			var varDic;
			varDic={};
			varDic[inChar]=1;
			varDic[outChar]=-1;
			var i=0;
			var len=0;
			var tChar;
			len=str.length;
			var rst=0;
			rst=0;
			for(i=0;i<len;i++){
				tChar=str.charAt(i);
				if(varDic.hasOwnProperty(tChar)){
					rst+=varDic[tChar];
				}
			}
			return rst;
		}

		StringTool.readInt=function(str,startI){
			(startI===void 0)&& (startI=0);
			var rst=NaN;
			rst=0;
			var tNum=0;
			var tC;
			var i=0;
			var isBegin=false;
			isBegin=false;
			var len=0;
			len=str.length;
			for(i=startI;i<len;i++){
				tC=str.charAt(i);
				if(Number(tC)>0||tC=="0"){
					rst=10*rst+Number(tC);
					if(rst>0)isBegin=true;
					}else{
					if(isBegin)return rst;
				}
			}
			return rst;
		}

		StringTool.getReplace=function(str,oStr,nStr){
			if(!str)return "";
			str+="";
			var rst;
			rst=str.replace(new RegExp(oStr,"g"),nStr);
			return rst;
		}

		StringTool.getWordCount=function(str,findWord){
			var rg=new RegExp(findWord,"g")
			return str.match(rg).length;
		}

		StringTool.getResolvePath=function(path,basePath){
			if(StringTool.isAbsPath(path)){
				return path;
			};
			var tSign;
			tSign="\\";
			if(basePath.indexOf("/")>=0){
				tSign="/";
			}
			if(basePath.charAt(basePath.length-1)==tSign){
				basePath=basePath.substr(0,basePath.length-1);
			};
			var parentSign;
			parentSign=".."+tSign;
			var tISign;
			tISign="."+tSign;
			var pCount=0;
			pCount=StringTool.getWordCount(path,parentSign);
			path=as3analyser.tools.StringTool.getReplace(path,parentSign,"");
			path=as3analyser.tools.StringTool.getReplace(path,tISign,"");
			var i=0;
			var len=0;
			len=pCount;
			var iPos=0;
			for(i=0;i<len;i++){
				basePath=StringTool.removeLastSign(path,tSign);
			}
			return basePath+tSign+path;
		}

		StringTool.isAbsPath=function(path){
			if(path.indexOf(":")>=0)return true;
			return false;
		}

		StringTool.removeLastSign=function(str,sign){
			var iPos=0;
			iPos=str.lastIndexOf(sign);
			str=str.substring(0,iPos);
			return str;
		}

		StringTool.getParamArr=function(str){
			var paramStr;
			paramStr=as3analyser.tools.StringTool.getBetween(str,"(",")",true);
			if(StringTool.trim(paramStr).length<1)return [];
			return paramStr.split(",");
		}

		StringTool.nextIS=function(str,pos,lines){
			var tStr;
			var tLine;
			var i=0;
			var len=0;
			var tIndex=0;
			tIndex=pos.index;
			len=lines.length;
			tStr="";
			for(i=pos.line;i<len;i++){
				tLine=lines[i];
				tStr+=StringTool.trimLeft(tLine.lineStr.substr(tIndex));
				tIndex=0;
				if(tStr.indexOf(str)==0){
					return true;
					}else{
					if(tStr.length>0){
						return false;
					}
				}
			}
			return false;
		}

		StringTool.findFirstMatchLineS=function(str,pos,lines){
			var i=0;
			var len=0;
			var tLine;
			var rst;
			len=lines.length;
			var tIndex=0;
			if(!pos)pos=new PosItem();
			tIndex=pos.index;
			for(i=pos.line;i<len;i++){
				tLine=lines[i].lineStr;
				tIndex=tLine.indexOf(str,tIndex);
				if(tIndex>=0){
					rst=new PosItem();
					rst.line=i;
					rst.index=tIndex;
					rst.oLine=lines[i].lineIndex;
					return rst;
				}
				tIndex=0;
			}
			return rst;
		}

		StringTool.copyStr=function(str){
			return str.substring();
		}

		StringTool.findPair=function(l,r,pos,lines){
			var tCount=0;
			var first=0;
			var tPos;
			var rPos;
			var lPos;
			var valueDic;
			valueDic={};
			valueDic[l]=1;
			valueDic[r]=-1;
			tPos=StringTool.findFirstMatchLineS(l,pos,lines);
			var posList;
			posList=[];
			if(tPos){
				setTPos(tPos,l);
				while(tCount>0){
					lPos=StringTool.findFirstMatchLineS(l,tPos,lines);
					rPos=StringTool.findFirstMatchLineS(r,tPos,lines);
					if(!lPos&&!rPos){
						break ;
					}
					if(!lPos){
						setTPos(rPos,r);
						continue ;
					}
					if(!rPos){
						setTPos(lPos,l);
						continue ;
					}
					if(PosItem.pre(rPos,lPos)){
						setTPos(rPos,r);
						}else{
						setTPos(lPos,l);
					}
				}
				if(tCount==0){
					return posList;
					}else{
					return null;
				}
			}
			return null;
			function setTPos (pos,str){
				tPos=pos;
				tPos.str=str;
				tPos.index++;
				posList.push(tPos);
				tCount+=valueDic[str];
			}
		}

		StringTool.ArrayToString=function(arr){
			var rst;
			rst="[{items}]".replace(new RegExp("\\{items\\}","g"),StringTool.getArrayItems(arr));
			return rst;
		}

		StringTool.getArrayItems=function(arr){
			var rst;
			if(arr.length<1)return "";
			rst=StringTool.parseItem(arr[0]);
			var i=0;
			var len=0;
			len=arr.length;
			for(i=1;i<len;i++){
				rst+=","+StringTool.parseItem(arr[i]);
			}
			return rst;
		}

		StringTool.parseItem=function(item){
			var rst;
			rst="\""+item+"\"";
			return "";
		}

		StringTool.emptyDic={};
		__static(StringTool,
		['emptyStrDic',function(){return this.emptyStrDic={
				" ":true,
				"\r":true,
				"\n":true,
				"\t":true
		};}

		]);
		return StringTool;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-7-30 下午4:49:08
	*/
	//class as3analyser.tools.ToolFuns
	var ToolFuns=(function(){
		function ToolFuns(){}
		__class(ToolFuns,'as3analyser.tools.ToolFuns');
		ToolFuns.saveTxtFile=function(fileName,fileContent){
			FileManager.createTxtFile(fileName,fileContent);
		}

		ToolFuns.readTxtFile=function(fileName){
			return FileManager.readTxtFile(fileName);
		}

		ToolFuns.getArrFromDic=function(dic){
			var rst;
			rst=[];
			var key;
			for(key in dic){
				rst.push(key);
			}
			return rst;
		}

		ToolFuns.getArrFromObj=function(obj){
			var rst;
			rst=[];
			var key;
			for(key in obj){
				rst.push(obj[key]);
			}
			return rst;
		}

		ToolFuns.getNotIn=function(oA,oB){
			var rst;
			rst={};
			var key;
			for (key in oA){
				if(!oB.hasOwnProperty(key)){
					rst[key]=true;
				}
			}
			return rst;
		}

		ToolFuns.mergeO=function(oA,oB){
			var rst;
			rst={};
			var key;
			for (key in oA){
				rst[key]=true;
			}
			for (key in oB){
				rst[key]=true;
			}
			return rst;
		}

		ToolFuns.getSimpleFileName=function(filePath){
			return filePath.substr(filePath.lastIndexOf("\\")+1);
		}

		ToolFuns.myTrace=function(msg){
			console.log(msg);
		}

		return ToolFuns;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-8-31 下午7:19:15
	*/
	//class as3analyser.Tracer
	var Tracer=(function(){
		function Tracer(){}
		__class(Tracer,'as3analyser.Tracer');
		Tracer.myTrace=function(msg){}
		return Tracer;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2017-5-17 下午3:43:28
	*/
	//class laya.editor.core.align.AlignTool
	var AlignTool=(function(){
		function AlignTool(){}
		__class(AlignTool,'laya.editor.core.align.AlignTool');
		AlignTool.getAlignV=function(sp,valueType){
			var rst=NaN;
			switch(valueType){
				case "x":
				case "y":
					rst=sp[valueType]
					break ;
				case "right":
					rst=sp.x+sp.width;
					break ;
				case "xCenter":
					rst=sp.x+sp.width*0.5;
					break ;
				case "bottom":
					rst=sp.y+sp.height;
					break ;
				case "yCenter":
					rst=sp.y+sp.height*0.5;
					break ;
				}
			return rst;
		}

		AlignTool.getMinType=function(sp,tar,xDir,rst,isAlignLine){
			(xDir===void 0)&& (xDir=true);
			(isAlignLine===void 0)&& (isAlignLine=false);
			var vKeys;
			if(xDir){
				vKeys=AlignTool.xValues;
				}else{
				vKeys=AlignTool.yValues;
			};
			var tMinV=NaN;
			var i=0,iLen=0;
			var j=0,jLen=0;
			iLen=vKeys.length;
			jLen=vKeys.length;
			if(isAlignLine)jLen=1;
			var mV=NaN;
			var tV=NaN;
			var tDv=NaN;
			tMinV=999;
			var tAlignInfo;
			tAlignInfo=rst||new MinAlignInfo();
			tAlignInfo.sp=sp;
			tAlignInfo.tar=tar;
			tAlignInfo.minD=tMinV;
			for(i=0;i<iLen;i++){
				mV=AlignTool.getAlignV(sp,vKeys[i]);
				for(j=0;j<jLen;j++){
					tV=AlignTool.getAlignV(tar,vKeys[j]);
					tDv=tV-mV;
					if(Math.abs(tDv)<tMinV){
						tAlignInfo.spType=vKeys[i];
						tAlignInfo.tarType=vKeys[j];
						tAlignInfo.minD=tDv;
						tMinV=Math.abs(tDv);
					}
				}
			}
			return tAlignInfo;
		}

		AlignTool.getAlignLine=function(type,value){
			var rst;
			rst=Pool.getItemByClass("TempAlignLine",Object);
			rst.type=type;
			rst[type]=value;
			return rst;
		}

		__static(AlignTool,
		['xValues',function(){return this.xValues=["x","xCenter","right"];},'yValues',function(){return this.yValues=["y","yCenter","bottom"];}
		]);
		return AlignTool;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2017-5-17 下午3:53:57
	*/
	//class laya.editor.core.align.MinAlignInfo
	var MinAlignInfo=(function(){
		function MinAlignInfo(){
			this.sp=null;
			this.tar=null;
			this.minD=NaN;
			this.spType=null;
			this.tarType=null;
			console.log("create MinAlignInfo");
		}

		__class(MinAlignInfo,'laya.editor.core.align.MinAlignInfo');
		var __proto=MinAlignInfo.prototype;
		__getset(0,__proto,'minAbs',function(){
			return Math.abs(this.minD);
		});

		__getset(0,__proto,'tValue',function(){
			return AlignTool.getAlignV(this.tar,this.tarType);
		});

		return MinAlignInfo;
	})()


	/**
	*本类用于节点数据不同格式间的转换
	*@author ww
	*/
	//class laya.editor.core.design.DesignInfo
	var DesignInfo=(function(){
		function DesignInfo(){
			this.type=null;
			this.child=null;
			this.props=null;
			this.compId=0;
		}

		__class(DesignInfo,'laya.editor.core.design.DesignInfo');
		DesignInfo.uiObjToXml=function(uiObj,aniXml){
			var xml;
			xml=new XMLElement();
			xml.setLocalName(uiObj.type);
			if(!aniXml){
				aniXml=new XMLElement();
				aniXml.setLocalName("Ani");
			};
			var key;
			var props;
			props=uiObj.props;
			for(key in props){
				xml.setAttribute(key,props[key]);
			};
			var childs;
			childs=uiObj.child;
			if(!childs)childs=[];
			var i=0,len=0;
			len=childs.length;
			for(i=0;i<len;i++){
				xml.appendChild(DesignInfo.uiObjToXml(childs[i],aniXml));
			}
			xml.setAttribute("editorInfo",DesignInfo.getIDEValue(uiObj));
			var frames;
			frames=uiObj.frames;
			if(!frames)frames=[];
			var frameXml;
			frameXml=new XMLElement();
			frameXml.setLocalName("tarAni");
			frameXml.setAttribute("target",uiObj.compId);
			len=frames.length;
			var tFrame;
			var tFrameO;
			for(i=0;i<len;i++){
				tFrameO=frames[i];
				tFrame=new XMLElement();
				tFrame.setLocalName("frame");
				props=tFrameO.props;
				for(key in props){
					tFrame.setAttribute(key,props[key]);
				}
				tFrame.setAttribute("editorInfo",DesignInfo.getIDEValue(tFrameO,DesignInfo.frameSaveKeys));
				frameXml.appendChild(tFrame);
			}
			return xml;
		}

		DesignInfo.getIDEValue=function(node,saveKeys){
			if(!saveKeys)saveKeys=DesignInfo.saveEmpty;
			var rst;
			var key;
			var KeyValues;
			KeyValues=[];
			for(key in node){
				if(!DesignInfo.specialKeys.hasOwnProperty(key)||saveKeys.hasOwnProperty(key)){
					if(key=="compId")
						KeyValues.push(key+"="+node[key]);
					if(key=="source"){
						KeyValues.push(key+"="+node[key]);
					}
				}
			}
			rst=KeyValues.join(";");
			return rst;
		}

		DesignInfo.xmlStrToUIObj=function(xmlString){
			return DesignInfo.uiXmlToObj(Utils$1.parseXMLFromString(xmlString));
		}

		DesignInfo.uiXmlToObj=function(xml){
			var xmlObj;
			xmlObj=XML2Object.parse(xml);
			var rst;
			var aniDic;
			aniDic=DesignInfo.parseFramesData(xmlObj.cList[0]);
			rst=DesignInfo.getUIObjByXmlObj(xmlObj.cList[0],aniDic);
			return rst;
		}

		DesignInfo.parseFramesData=function(data){
			var aniDic;
			aniDic={};
			var ani;
			ani=data.cList[0];
			if(!ani)return aniDic;
			var frames;
			frames=ani.c["tarAni"];
			if(!frames)frames=[];
			var i=0,len=0;
			len=frames.length;
			var tAni;
			var tarFrames;
			for(i=0;i<len;i++){
				tAni=frames[i];
				tarFrames=tAni.c.frame;
				if(!tarFrames)tarFrames=[];
				if(! (tarFrames instanceof Array)){
					tarFrames=[tarFrames];
				}
				aniDic[tAni.p["target"]]=DesignInfo.parseTarFrames(tarFrames);
			}
			return aniDic;
		}

		DesignInfo.parseTarFrames=function(tarFrames){
			var i=0,len=0;
			len=tarFrames.length;
			var tFrame;
			var rst;
			rst=[];
			for(i=0;i<len;i++){
				rst.push(DesignInfo.createNodeObj(tarFrames[i]));
			}
			return rst;
		}

		DesignInfo.getUIObjByXmlObj=function(xmlObj,aniDic){
			var rst;
			var cList;
			rst=DesignInfo.createNodeObj(xmlObj);
			var props;
			var key;
			var i=0,len=0;
			cList=xmlObj.cList;
			var frames;
			frames=[];
			if(cList)
				len=cList.length;
			var tObj;
			var childs;
			childs=[];
			for(i=0;i<len;i++){
				tObj=cList[i];
				if(tObj.Name=="parsererror"){
					throw new Error();
					continue ;
				}
				if(tObj.Name=="Ani")continue ;
				if(!tObj.Name)continue ;
				if(tObj.Name=="")continue ;
				if(tObj.Name=="frame"){
					frames.push(DesignInfo.createNodeObj(tObj));
					}else{
					childs.push(DesignInfo.getUIObjByXmlObj(tObj,aniDic));
				}
			}
			rst.child=childs;
			if(aniDic[rst.compId])
				rst.frames=aniDic[rst.compId];
			return rst;
		}

		DesignInfo.createNodeObj=function(data){
			var rst;
			rst={};
			rst.type=data.Name;
			rst.props={};
			if(rst.type=="UIView"&&!rst.source){
				rst.source=data.p.source;
			}
			if(!rst.type){
				debugger;
			}
			DesignInfo.createValueObj(data.p,rst.props);
			delete rst["frame"];
			DesignInfo.solveEditorInfo(rst);
			return rst;
		}

		DesignInfo.createValueObj=function(srcProps,rst){
			if(!rst)
				rst={};
			var key;
			for(key in srcProps){
				rst[key]=ObjectTools$1.getStrTypedValue(srcProps[key]);
			}
			return rst;
		}

		DesignInfo.solveEditorInfo=function(node){
			var keyValueStr;
			keyValueStr=node.props["editorInfo"];
			delete node.props["editorInfo"];
			var keyvalueStrs;
			if(keyValueStr){
				keyvalueStrs=keyValueStr.split(";");
				var i=0,len=0;
				var tArr;
				len=keyvalueStrs.length;
				for(i=0;i<len;i++){
					tArr=keyvalueStrs[i].split("=");
					node[tArr[0]]=ObjectTools$1.getStrTypedValue(tArr[1]);
				}
			}
		}

		DesignInfo.EditorInfo="editorInfo";
		DesignInfo.Frame="frame";
		DesignInfo.Ani="Ani";
		DesignInfo.TarAni="tarAni";
		DesignInfo.Target="target";
		DesignInfo.saveEmpty={};
		__static(DesignInfo,
		['specialKeys',function(){return this.specialKeys={
				type:true,
				child:true,
				props:true,
				editorInfo:true,
				frames:true
				};},'frameSaveKeys',function(){return this.frameSaveKeys={
				type:true
		};}

		]);
		return DesignInfo;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-12-15 下午2:55:24
	*/
	//class laya.editor.core.design.TreeData
	var TreeData=(function(){
		function TreeData(){
			this._nodeDic=null;
			this._root=null;
			this._nodeList=null;
		}

		__class(TreeData,'laya.editor.core.design.TreeData');
		var __proto=TreeData.prototype;
		__proto.addChild=function(child,parent){
			TreeData.getNodeChilds(parent).push(child);
			this.setNodeParent(child,parent);
			return child;
		}

		__proto.removeSelf=function(child){
			this.removeChild(child,this.getNodeParent(child));
		}

		__proto.removeChild=function(child,parent){
			child.nodeParent=null;
			if(!parent)return child;
			var childList;
			childList=TreeData.getNodeChilds(parent);
			var i=0,len=0;
			len=childList.length;
			for(i=len-1;i>=0;i--){
				if(this.isNodeSame(childList[i],child)){
					childList.splice(i,1);
				}
			}
			return child;
		}

		__proto.isChildE=function(parent,child){
			if (!parent)return false;
			while (child){
				if (this.getNodeParent(child)==parent)return true;
				child=this.getNodeParent(child);
			}
			return false;
		}

		__proto.isInTree=function(pNode,child){
			return pNode==child || this.isChildE(pNode,child);
		}

		__proto.insertToTarParent=function(tarA,tars,after){
			(after===void 0)&& (after=false);
			var tIndex=0;
			var parent;
			if(!tarA)return;
			parent=this.getNodeParent(tarA);
			if(!parent)return;
			this.transTarsParent(parent,tars);
			var i=0,len=0;
			len=tars.length;
			for(i=0;i<len;i++){
				this.removeSelf(tars[i]);
				tIndex=this.getChildIndex(tarA,parent);
				if(after)tIndex++;
				this.addChildAt(tars[i],tIndex,parent);
			}
		}

		//insertToParent(parent,tars,tIndex);
		__proto.insertToParent=function(parent,tars,index){
			(index===void 0)&& (index=-1);
			if(!parent)return;
			this.transTarsParent(parent,tars);
			this.removeItemFromParent(tars);
			if(index<0)index=this.numChildren(parent);
			var i=0,len=0;
			len=tars.length;
			for(i=0;i<len;i++){
				this.transParent(tars[i],parent);
				this.addChildAt(tars[i],index,parent);
			}
		}

		__proto.transTarsParent=function(parent,tars){
			var i=0,len=0;
			len=tars.length;
			for(i=0;i<len;i++){
				this.transParent(tars[i],parent);
			}
		}

		__proto.removeItemFromParent=function(tars){
			var i=0,len=0;
			len=tars.length;
			for(i=0;i<len;i++){
				this.removeSelf(tars[i]);
			}
		}

		__proto.transParent=function(tar,newParent){
			Notice.notify("Display_transParent",[tar,newParent]);
		}

		__proto.addChildAt=function(child,index,parent){
			if(child==parent){
				throw new Error("appendChildAt:add self to self");
			}
			this.removeSelf(child);
			var childs;
			childs=TreeData.getNodeChilds(parent);
			if (index >=0 && index <=childs.length){
				childs.splice(index,0,child);
				this.setNodeParent(child,parent);
				return child;
				}else {
				throw new Error("appendChildAt:The index is out of bounds");
			}
			return child;
		}

		__proto.isNodeSame=function(nodeA,nodeB){
			if(!nodeA||!nodeB)return false;
			return nodeA==nodeB||nodeA.compId==nodeB.compId;
		}

		__proto.numChildren=function(parent){
			return TreeData.getNodeChilds(parent).length;
		}

		__proto.getChildIndex=function(child,parent){
			var i=0,len=0;
			var childs;
			childs=TreeData.getNodeChilds(parent);
			len=childs.length;
			for(i=0;i<len;i++){
				if(this.isNodeSame(childs[i],child))return i;
			}
			return TreeData.getNodeChilds(parent).indexOf(child);
		}

		__proto.getNodeByID=function(id){
			return this._nodeDic[id];
		}

		__proto.getNodeParent=function(child){
			return this.getNodeByID(child.nodeParent);
		}

		__proto.setNodeParent=function(child,parent){
			if(TreeData.getNodeID(child)==TreeData.getNodeID(parent)){
				debugger;
			}
			child.nodeParent=TreeData.getNodeID(parent);
		}

		__proto.getNodeLabel=function(node){
			var str;
			if(node.type=="Script"){
				str=AppendPropGroupTool.getScriptName(node.source);
			}else
			if(node.props["var"]){
				str=node.type+"("+node.props["var"]+")";
			}else
			if(node.props.name){
				str=node.type+"("+node.props.name+")";
			}else
			if(node.props.preset){
				var presetName;
				presetName=node.props.preset.split("/").pop();
				presetName=StringTool$1.getReplace(presetName,".prefab","");
				str=node.type+"("+presetName+")";
				}else{
				str=node.type
			}
			return str;
		}

		__proto.reset=function(){
			this._root=null;
			this._nodeDic={};
			this._nodeList=[];
		}

		__proto.setData=function(uiObj){
			this.reset();
			this._root=uiObj;
			this.modifyNode(this._root,null);
		}

		__proto.modifyNode=function(node,parent,isAniNode){
			(isAniNode===void 0)&& (isAniNode=true);
			this._nodeList.push(node);
			delete node.x;
			delete node.y;
			if(!node.compId){
				debugger;
			}
			node.isAniNode=isAniNode;
			this._nodeDic[node.compId]=node;
			this.setNodeParent(node,parent);
			node.label=this.getNodeLabel(node);
			var i=0,len=0;
			var childs;
			childs=TreeData.getNodeChilds(node);
			len=childs.length;
			var childAni=false;
			childAni=isAniNode&&(!FilterFuns.isUnAnimationAbleType(node.type));
			for(i=0;i<len;i++){
				this.modifyNode(childs[i],node,childAni);
			}
			node.hasChild=node.isDirectory=childs.length>0;
			delete node["frames"];
		}

		__proto.getTreeArr=function(){
			return this._nodeList;
		}

		__proto.recordFrameData=function(node,frame,workChild){
			(workChild===void 0)&& (workChild=false);
			if(!node)node=this._root;
			TreeData.recordTreeFrame(node,frame);
		}

		__proto.getMaxFrame=function(){
			var maxFrame=0;
			var i=0,len=0;
			var nodes;
			var tFrameCount=0;
			nodes=this._nodeList;
			len=nodes.length;
			maxFrame=0;
			for(i=0;i<len;i++){
				tFrameCount=TreeData.getNodeMaxFrame(nodes[i]);
				if(maxFrame<tFrameCount){
					maxFrame=tFrameCount;
				}
			}
			return maxFrame;
		}

		__getset(0,__proto,'root',function(){
			return this._root;
		});

		TreeData.getNodeID=function(node){
			if(!node)return-1;
			return node.compId;
		}

		TreeData.getNodeChilds=function(node){
			if(!node.child){
				node.child=[];
			}
			return node.child;
		}

		TreeData.cleanNode=function(node){
			var i=0,len=0;
			len=TreeData._cleanNames.length;
			for(i=0;i<len;i++){
				delete node[TreeData._cleanNames[i]];
			};
			var childs;
			childs=TreeData.getNodeChilds(node);
			len=childs.length;
			for(i=0;i<len;i++){
				TreeData.cleanNode(childs[i]);
			}
		}

		TreeData.recordTreeFrame=function(node,frame,workChild){
			(workChild===void 0)&& (workChild=false);
			TreeData.recordFrame(node,frame,false);
			if(!workChild)return;
			var i=0,len=0;
			var childs;
			childs=TreeData.getNodeChilds(node);
			len=childs.length;
			for(i=0;i<len;i++){
				TreeData.recordTreeFrame(childs[i],frame,workChild);
			}
		}

		TreeData.isNodeFrameChanged=function(node,frame){
			return true;
		}

		TreeData.recordFrame=function(node,frame,autoCreate){
			(autoCreate===void 0)&& (autoCreate=false);
			var frameData;
			frameData=TreeData.getFrameData(node,frame,autoCreate);
			if(!frameData){
				return;
			}
			TreeData.copyAniValues(frameData.props,node.props);
		}

		TreeData.getNodeMaxFrame=function(node){
			var frames;
			frames=TreeData.getNodeFrames(node);
			if(frames.length<1)return 0;
			return frames[frames.length-1].frame;
		}

		TreeData.getFrameProps=function(frameData){
			if(!frameData.props){
				frameData.props={};
			}
			return frameData.props;
		}

		TreeData.copyAniValues=function(dest,src){
			var key;
			for(key in src){
				if((typeof (src[key])=='object')){
					debugger;
				}
				dest[key]=src[key];
				if(ObjectTools$1.isNaN(dest[key])){
					debugger;
				}
			}
		}

		TreeData.getFrameData=function(node,frame,autoCreate){
			(autoCreate===void 0)&& (autoCreate=true);
			var frames;
			frames=TreeData.getNodeFrames(node);
			var pos=0;
			pos=ObjectTools$1.findItemPos(frames,"frame",frame);
			if(pos<0){
				if(!autoCreate){
					return null;
					}else{
					return TreeData.addFrame(node,frame);
				}
				}else{
				return frames[pos];
			}
		}

		TreeData.getWrapFrame=function(node,frame,autoCreate){
			(autoCreate===void 0)&& (autoCreate=true);
			TreeData.sortNodeFrames(node);
			var i=0,len=0;
			var frames;
			frames=TreeData.getNodeFrames(node);
			len=frames.length;
			var tFrame;
			for(i=0;i<len;i++){
				tFrame=frames[i];
				if(tFrame.frame==frame){
					return [tFrame];
				}
				if(tFrame.frame>frame){
					break ;
				}
			}
			if(tFrame&&tFrame.frame>=frame){
				if(tFrame.frame==frame){
					return [tFrame];
				}else
				if(tFrame.frame>frame){
					return [frames[i-1],tFrame];
				}
				}else{
				var frameProps;
				frameProps=tFrame?ObjectTools$1.copyObj(tFrame.props):ObjectTools$1.copyObj(node.props);
				tFrame=TimeFrameData.create(frame,frameProps);
				if(autoCreate){
					TreeData.addFrameToNode(tFrame,node);
					}else{
				}
				return [tFrame];
			}
			return null;
		}

		TreeData.getNodeFrameProps=function(node,frame){
			var wrapsFrames;
			wrapsFrames=TreeData.getWrapFrame(node,frame,false);
			var rst;
			if(wrapsFrames.length==1){
				rst=wrapsFrames[0].props;
				}else{
				rst=TreeData.getFrameProp(wrapsFrames[0],wrapsFrames[1],frame);
			}
			return ObjectTools$1.copyObj(rst);
		}

		TreeData.setDefaultValues=function(propA,propB){
			TreeData.setDefaultValueTo(propA,propB);
			TreeData.setDefaultValueTo(propB,propA);
		}

		TreeData.setDefaultValueTo=function(propA,propB){
			var key;
			for(key in propA){
				if(!propB.hasOwnProperty(key)){
					if(TreeData.defaultValueDic.hasOwnProperty(key)){
						propB[key]=TreeData.defaultValueDic[key];
						}else{
						propB[key]=propA[key];
					}
				}
			}
		}

		TreeData.getFrameProp=function(leftFrame,rightFrame,frame){
			var left=0;
			var right=0;
			var props;
			props={};
			left=leftFrame.frame;
			right=rightFrame.frame;
			var percent=NaN;
			percent=(frame-left)/(right-left);
			var key;
			var leftProps;
			var rightProps;
			leftProps=leftFrame.props;
			rightProps=rightFrame.props;
			TreeData.setDefaultValues(rightProps,leftProps);
			var leftValue=NaN;
			var rightValue=NaN;
			for(key in leftProps){
				if(ObjectTools$1.isNumber(leftProps[key])){
					leftValue=parseFloat(leftProps[key]);
					rightValue=parseFloat(rightProps[key]);
					props[key]=leftValue+percent*(rightValue-leftValue);
					}else{
					props[key]=leftProps[key];
				}
				if(ObjectTools$1.isNaN(props[key])){
					debugger;
				}
			}
			return props;
		}

		TreeData.sortNodeFrames=function(node){
			var frames=TreeData.getNodeFrames(node);
			frames.sort(MathUtil.sortByKey("frame"));
		}

		TreeData.getNodeFrames=function(node){
			if(!node.frames){
				var frameData;
				frameData=TimeFrameData.create(0,ObjectTools$1.copyObj(node.props));
				node.frames=[frameData];
			}
			return node.frames;
		}

		TreeData.displayFrame=function(node,frame){
			var disProps;
			disProps=TreeData.getNodeFrameProps(node,frame);
			TreeData.copyAniValues(node.props,disProps);
		}

		TreeData.displayTreeToFrame=function(node,frame,self,child){
			(self===void 0)&& (self=true);
			(child===void 0)&& (child=true);
			if(self){
				TreeData.displayFrame(node,frame);
			}
			if(!child)return;
			var i=0,len=0;
			var childs;
			childs=TreeData.getNodeChilds(node);
			len=childs.length;
			for(i=0;i<len;i++){
				TreeData.displayTreeToFrame(childs[i],frame,true,true);
			}
		}

		TreeData.addFrame=function(node,frame,props){
			if(!props){
				props={};
				var wrapFrames;
				wrapFrames=TreeData.getWrapFrame(node,frame);
				TreeData.copyAniValues(props,wrapFrames[0].props);
			};
			var frameData;
			frameData=TimeFrameData.create(frame,props);
			TreeData.addFrameToNode(frameData,node);
			return frameData;
		}

		TreeData.addFrameToNode=function(frameData,node){
			var preFrameData;
			preFrameData=TreeData.getFrameData(node,frameData.frame,false);
			if(preFrameData){
				TreeData.copyAniValues(preFrameData.props,frameData.props);
				}else{
				var frames;
				frames=TreeData.getNodeFrames(node);
				frames.push(frameData);
				TreeData.sortNodeFrames(node);
			}
		}

		TreeData.moveFrame=function(node,preFrame,newFrame){}
		TreeData.createByUIObj=function(uiObj){
			var treeData;
			treeData=new TreeData();
			treeData.setData(uiObj);
			return treeData;
		}

		TreeData.removeNodeFromNodeTree=function(nodeTree,compId){
			if(!nodeTree)return;
			var childs;
			childs=nodeTree.child;
			if(!childs)return;
			var i=0,len=0;
			var tChild;
			len=childs.length;
			for(i=0;i<len;i++){
				tChild=childs[i];
				if(tChild&&tChild.compId==compId){
					childs.splice(i,1);
					return;
				}
			}
			len=childs.length;
			for(i=0;i<len;i++){
				tChild=childs[i];
				if(tChild){
					TreeData.removeNodeFromNodeTree(tChild,compId);
				}
			}
		}

		__static(TreeData,
		['_cleanNames',function(){return this._cleanNames=
			[
			"label",
			"nodeParent"];},'defaultValueDic',function(){return this.defaultValueDic={
				x:0,
				y:0,
				scaleX:1,
				scaleY:1,
				rotation:0
				};},'defaultValueSameDic',function(){return this.defaultValueSameDic={
				width:0,
				height:0
		};}

		]);
		return TreeData;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-12-15 下午2:42:50
	*/
	//class laya.editor.core.design.TreeDataTool
	var TreeDataTool=(function(){
		function TreeDataTool(){}
		__class(TreeDataTool,'laya.editor.core.design.TreeDataTool');
		TreeDataTool.getNodeData=function(){
			var rst;
			rst={};
			rst.nodeParent=null;
			rst.name="node";
			rst.data={};
			rst.childs=[];
			return rst;
		}

		TreeDataTool.deleteNodePropKeyBut=function(node,keyDic,isBut){
			(isBut===void 0)&& (isBut=true);
			var prop;
			prop=node.props;
			var key;
			if(isBut){
				for(key in prop){
					if(!keyDic[key]){
						delete prop[key];
					}
				}
				}else{
				for(key in keyDic){
					delete prop[key];
				}
			}
		}

		TreeDataTool.deleteAllKeyBut=function(node,keyDic,isBut){
			(isBut===void 0)&& (isBut=true);
			TreeDataTool.deleteNodePropKeyBut(node,keyDic,isBut);
			var childs;
			childs=node.child;
			if(!childs)return;
			var i=0,len=0;
			len=childs.length;
			for(i=0;i<len;i++){
				TreeDataTool.deleteAllKeyBut(childs[i],keyDic,isBut);
			}
		}

		TreeDataTool.deleteNodeKey=function(node,key){
			delete node[key];
			var childs;
			childs=node.child;
			if(!childs)return;
			var i=0,len=0;
			len=childs.length;
			for(i=0;i<len;i++){
				TreeDataTool.deleteNodeKey(childs[i],key);
			}
		}

		TreeDataTool.setNodeValue=function(node,key,value){
			if(!node||!node.props)return;
			node.props[key]=value;
		}

		TreeDataTool.setNodeKey=function(node,key,value){
			TreeDataTool.setNodeValue(node,key,value);
			var childs;
			childs=node.child;
			if(!childs)return;
			var i=0,len=0;
			len=childs.length;
			for(i=0;i<len;i++){
				TreeDataTool.setNodeKey(childs[i],key,value);
			}
		}

		TreeDataTool.changeOneNodeKey=function(node,key,newKey){
			if(!node||!node.props)return;
			var props;
			props=node.props;
			if(props.hasOwnProperty(key)){
				props[newKey]=props[key];
				delete props[key];
				}else{
				delete props[newKey];
			}
		}

		TreeDataTool.changeNodeKey=function(node,key,newKey){
			TreeDataTool.changeOneNodeKey(node,key,newKey);
			var childs;
			childs=node.child;
			if(!childs)return;
			var i=0,len=0;
			len=childs.length;
			for(i=0;i<len;i++){
				TreeDataTool.changeNodeKey(childs[i],key,newKey);
			}
		}

		TreeDataTool.setNodeID=function(node,key,start){
			if(!node||!node.props)return start;
			node.props[key]=start;
			start++;
			return start;
		}

		TreeDataTool.resetNodeID=function(node,key,start){
			(start===void 0)&& (start=1);
			start=TreeDataTool.setNodeID(node,key,start);
			var childs;
			childs=node.child;
			if(!childs)return start;
			var i=0,len=0;
			len=childs.length;
			for(i=0;i<len;i++){
				start=TreeDataTool.resetNodeID(childs[i],key,start);
			}
			return start;
		}

		TreeDataTool.getNodeKeyValue=function(node,key,isProp){
			(isProp===void 0)&& (isProp=true);
			if(!node)return null;
			if(!isProp)return node[key];
			if(!node.props)return null;
			return node.props[key];
		}

		TreeDataTool.saveNodeToDic=function(node,dic,idKey,isProp){
			(isProp===void 0)&& (isProp=true);
			var key;
			key=TreeDataTool.getNodeKeyValue(node,idKey,isProp);
			if(!key)return;
			dic[key]=node;
		}

		TreeDataTool.buildNode=function(node,dic,idKey,isProp){
			(isProp===void 0)&& (isProp=true);
			if(!dic)dic={};
			TreeDataTool.saveNodeToDic(node,dic,idKey,isProp);
			var childs;
			childs=node.child;
			if(!childs)return dic;
			var i=0,len=0;
			len=childs.length;
			for(i=0;i<len;i++){
				TreeDataTool.buildNode(childs[i],dic,idKey,isProp);
			}
			return dic;
		}

		return TreeDataTool;
	})()


	/**拖动管理类*/
	//class laya.editor.core.managers.DragManager
	var DragManager=(function(){
		function DragManager(){
			this._dragInitiator=null;
			this._dragImage=null;
			this._offSet=new Point();
			Laya.stage.on("keydown",this,this.onStageKeyDown);
		}

		__class(DragManager,'laya.editor.core.managers.DragManager');
		var __proto=DragManager.prototype;
		__proto.onStageKeyDown=function(e){
			switch(e.keyCode){
				case 27:
					Laya.stage.off("mousemove",this,this.onStageMouseMove);
					Laya.stage.off("mouseup",this,this.onStageMouseUp);
					this.clears();
					break ;
				}
		}

		/**开始拖动
		*@param dragInitiator 拖动的源对象
		*@param dragImage 显示拖动的图片，如果为null，则是源对象本身
		*@param data 拖动传递的数据
		*@param offset 鼠标居拖动图片的偏移*/
		__proto.doDrag=function(dragInitiator,dragImage,data,offset){
			this.clears();
			DragManager.prePos.setTo(Laya.stage.mouseX,Laya.stage.mouseY);
			this._dragInitiator=dragInitiator;
			this._dragImage=dragImage ? dragImage :dragInitiator;
			if((this._dragImage instanceof laya.ui.Clip )){
				this._dragImage.width*=0.5;
				this._dragImage.height*=0.5;
			}
			DragManager._data=data || {};
			offset=null;
			if(offset){
				this._offSet.setTo(offset.x,offset.y);
				}else{
				this._offSet.setTo(this._dragImage.width*0.5,this._dragImage.height*0.5);
			}
			if (this._dragImage !=this._dragInitiator){
				if (!this._dragImage.parent){
					Laya._currentStage.addChild(this._dragImage);
				}
				offset=offset || new Point();
				var p=this._dragImage.globalToLocal(new Point(Laya.stage.mouseX,Laya.stage.mouseY));
				this._dragImage.x=p.x-offset.x;
				this._dragImage.y=p.y-offset.y;
				this._dragImage.visible=false;
				this._dragImage.mouseEnabled=false;
			}
			Laya.stage.on("mousemove",this,this.onStageMouseMove);
			Laya.stage.on("mouseup",this,this.onStageMouseUp);
		}

		/**放置把拖动条拖出显示区域*/
		__proto.onStageMouseMove=function(e){
			if (Math.abs(DragManager.prePos.x-Laya.stage.mouseX)+Math.abs(DragManager.prePos.y-Laya.stage.mouseY)<8){
				return;
			}
			if(!this._dragImage)return;
			if (!DragManager.isDraging){
				this._dragImage.visible=true;
				this._dragImage.x=Laya.stage.mouseX-this._offSet.x;
				this._dragImage.y=Laya.stage.mouseY-this._offSet.y;
				this._dragImage.startDrag();
				this._dragImage.on("dragmove",this,this.onDraging);
				this._dragInitiator.event("dragStart",[ this._dragInitiator,DragManager._data]);
				DragManager.isDraging=true;
				this._dragImage.mouseEnabled=false;
			}
			this.sendDragEvent("Draging_Hit");
		}

		__proto.onDraging=function(){
			if(!this._dragImage)return;
			this._dragImage.x=Laya.stage.mouseX-this._offSet.x;
			this._dragImage.y=Laya.stage.mouseY-this._offSet.y;
		}

		__proto.onStageMouseUp=function(e){
			Laya.stage.off("mousemove",this,this.onStageMouseMove);
			Laya.stage.off("mouseup",this,this.onStageMouseUp);
			DragManager.dPos.setTo(Laya.stage.mouseX-DragManager.prePos.x,Laya.stage.mouseY-DragManager.prePos.y);
			if (Math.abs(DragManager.prePos.x-Laya.stage.mouseX)+Math.abs(DragManager.prePos.y-Laya.stage.mouseY)<8){
				this.clears();
				return;
			}
			this.getTarList();
			if(!this._dragInitiator)return;
			this._dragInitiator.event("dragComplete",[ this._dragInitiator,DragManager._data]);
			this.clears();
		}

		__proto.clears=function(){
			if(this._dragImage){
				this._dragImage.off("dragmove",this,this.onDraging);
				this._dragImage.mouseEnabled=true;
				if(this._dragImage!=this._dragInitiator)
					this._dragImage.removeSelf();
			}
			this._dragInitiator=null;
			DragManager._data=null;
			this._dragImage=null;
			DragManager.isDraging=false;
			FocusManager.clearFocus();
		}

		__proto.sendDragEvent=function(type){
			this.getTarList(type);
		}

		__proto.getTarList=function(type){
			(type===void 0)&& (type="dragDrop");
			DragManager.sendDragEventByData(type,this._dragInitiator,DragManager._data);
			return;
			var rst;
			rst=DisControlTool.getObjectsUnderPoint(Laya.stage,Laya.stage.mouseX*Browser.pixelRatio,Laya.stage.mouseY*Browser.pixelRatio,null,DisControlTool.visibleAndEnableObjFun);
			var i=0,len=0;
			var tTar;
			len=rst.length;
			var tEvent=DragEvent.TEMP;
			tEvent.dragInitiator=this._dragInitiator;
			tEvent.data=DragManager._data;
			tEvent.hitList=rst;
			for (i=0;i < len;i++){
				tTar=rst[i];
				if ((tTar instanceof laya.events.EventDispatcher )){
					if (tTar.hasListener(type)){
						tEvent.target=tTar;
						tTar.event(type,tEvent);
					}
				}
			}
		}

		DragManager.getDragType=function(){
			if (!DragManager._data||!DragManager._data.type)return null;
			return DragManager._data.type;
		}

		DragManager.getDragTarget=function(){
			if (!DragManager._data || !DragManager._data.target)return null;
			return DragManager._data.target;
		}

		DragManager.sendDragEventByData=function(type,_dragInitiator,_data,x,y){
			(x===void 0)&& (x="s");
			(y===void 0)&& (y="s");
			if(x=="s"){
				x=Laya.stage.mouseX;
			}
			if(y=="s"){
				y=Laya.stage.mouseY;
			};
			var rst;
			rst=DisControlTool.getObjectsUnderPoint(Laya.stage,x*Browser.pixelRatio,y*Browser.pixelRatio,null,DisControlTool.visibleAndEnableObjFun);
			var i=0,len=0;
			var tTar;
			len=rst.length;
			var tEvent=DragEvent.TEMP;
			tEvent.dragInitiator=_dragInitiator;
			tEvent.data=_data;
			tEvent.hitList=rst;
			for (i=0;i < len;i++){
				tTar=rst[i];
				if ((tTar instanceof laya.events.EventDispatcher )){
					if (tTar.hasListener(type)){
						tEvent.target=tTar;
						tTar.event(type,tEvent);
					}
				}
			}
		}

		DragManager._data=null
		DragManager.isDraging=false;
		__static(DragManager,
		['dragOffset',function(){return this.dragOffset=new Point(7,7);},'prePos',function(){return this.prePos=new Point();},'dPos',function(){return this.dPos=new Point();}
		]);
		return DragManager;
	})()


	/**语言管理器*/
	//class laya.editor.core.managers.LangManager
	var LangManager=(function(){
		function LangManager(){
			this._data={};
		}

		__class(LangManager,'laya.editor.core.managers.LangManager');
		var __proto=LangManager.prototype;
		/**获取语言
		*@param code 索引key
		*@param ...args 参数*/
		__proto.getLang=function(code,__args){
			var args=[];for(var i=1,sz=arguments.length;i<sz;i++)args.push(arguments[i]);
			var str=this._data[code] || code;
			if (args.length > 0){
				for (var i=0,n=args.length;i < n;i++){
					str=str.replace("{"+i+"}",args[i]);
				}
			}
			return str;
		}

		/**语言包(key:value方式)*/
		__getset(0,__proto,'data',function(){
			return this._data;
			},function(value){
			this._data=value;
		});

		return LangManager;
	})()


	/**对象工具集*/
	//class laya.editor.core.utils.ObjectUtils
	var ObjectUtils=(function(){
		function ObjectUtils(){};
		__class(ObjectUtils,'laya.editor.core.utils.ObjectUtils');
		ObjectUtils.addFilter=function(target,filter){
			var filters=target.filters || [];
			filters.push(filter);
			target.filters=filters;
		}

		ObjectUtils.clearFilter=function(target,filterType){
			var filters=target.filters;
			if (filters !=null && filters.length > 0){
				for (var i=filters.length-1;i >-1;i--){
					var filter=filters[i];
					if (Laya.__typeof(filter,filterType)){
						filters.splice(i,1);
					}
				}
				target.filters=filters;
			}
		}

		ObjectUtils.getTextField=function(format,text){
			(text===void 0)&& (text="Test");
			ObjectUtils._tf.align="left";
			ObjectUtils._tf.text=text;
			return ObjectUtils._tf;
		}

		ObjectUtils.measureTextWidth=function(format,text){
			(text===void 0)&& (text="Test");
			return ObjectUtils.getTextField(format,text).width;
		}

		__static(ObjectUtils,
		['_tf',function(){return this._tf=new TextField();}
		]);
		return ObjectUtils;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-10-16 上午11:09:00
	*/
	//class laya.editor.core.Wraps.DictionaryIDE
	var DictionaryIDE=(function(){
		function DictionaryIDE(){
			this.itemList=[];
		}

		__class(DictionaryIDE,'laya.editor.core.Wraps.DictionaryIDE');
		var __proto=DictionaryIDE.prototype;
		__proto.add=function(key,value){
			var item;
			item=this.getValue(key);
			if(!item){
				item={key:key,value:value};
				this.itemList.push(item);
				}else{
				item.value=value;
			}
		}

		__proto.getValue=function(key){
			var i=0,len=this.itemList.length;
			for(i=0;i<len;i++){
				if(this.itemList[i].key==key)return this.itemList[i].value;
			}
			return null;
		}

		__proto.deleteKey=function(key){
			var i=0,len=this.itemList.length;
			for(i=0;i<len;i++){
				if(this.itemList[i].key==key)return this.itemList.splice(i,1);
			}
		}

		__proto.reset=function(){
			this.itemList.length=0;
		}

		return DictionaryIDE;
	})()


	//class laya.editor.core.Wraps.Keyboard
	var Keyboard=(function(){
		function Keyboard(){
			;
		}

		__class(Keyboard,'laya.editor.core.Wraps.Keyboard');
		__getset(1,Keyboard,'capsLock',function(){return false});
		__getset(1,Keyboard,'numLock',function(){return false});
		__getset(1,Keyboard,'hasVirtualKeyboard',function(){return false});
		__getset(1,Keyboard,'physicalKeyboardType',function(){return ""});
		Keyboard.isAccessible=function(){return false}
		Keyboard.KEYNAME_UPARROW="Up";
		Keyboard.KEYNAME_DOWNARROW="Down";
		Keyboard.KEYNAME_LEFTARROW="Left";
		Keyboard.KEYNAME_RIGHTARROW="Right";
		Keyboard.KEYNAME_F1="F1";
		Keyboard.KEYNAME_F2="F2";
		Keyboard.KEYNAME_F3="F3";
		Keyboard.KEYNAME_F4="F4";
		Keyboard.KEYNAME_F5="F5";
		Keyboard.KEYNAME_F6="F6";
		Keyboard.KEYNAME_F7="F7";
		Keyboard.KEYNAME_F8="F8";
		Keyboard.KEYNAME_F9="F9";
		Keyboard.KEYNAME_F10="F10";
		Keyboard.KEYNAME_F11="F11";
		Keyboard.KEYNAME_F12="F12";
		Keyboard.KEYNAME_F13="F13";
		Keyboard.KEYNAME_F14="F14";
		Keyboard.KEYNAME_F15="F15";
		Keyboard.KEYNAME_F16="F16";
		Keyboard.KEYNAME_F17="F17";
		Keyboard.KEYNAME_F18="F18";
		Keyboard.KEYNAME_F19="F19";
		Keyboard.KEYNAME_F20="F20";
		Keyboard.KEYNAME_F21="F21";
		Keyboard.KEYNAME_F22="F22";
		Keyboard.KEYNAME_F23="F23";
		Keyboard.KEYNAME_F24="F24";
		Keyboard.KEYNAME_F25="F25";
		Keyboard.KEYNAME_F26="F26";
		Keyboard.KEYNAME_F27="F27";
		Keyboard.KEYNAME_F28="F28";
		Keyboard.KEYNAME_F29="F29";
		Keyboard.KEYNAME_F30="F30";
		Keyboard.KEYNAME_F31="F31";
		Keyboard.KEYNAME_F32="F32";
		Keyboard.KEYNAME_F33="F33";
		Keyboard.KEYNAME_F34="F34";
		Keyboard.KEYNAME_F35="F35";
		Keyboard.KEYNAME_INSERT="Insert";
		Keyboard.KEYNAME_DELETE="Delete";
		Keyboard.KEYNAME_HOME="Home";
		Keyboard.KEYNAME_BEGIN="Begin";
		Keyboard.KEYNAME_END="End";
		Keyboard.KEYNAME_PAGEUP="PgUp";
		Keyboard.KEYNAME_PAGEDOWN="PgDn";
		Keyboard.KEYNAME_PRINTSCREEN="PrntScrn";
		Keyboard.KEYNAME_SCROLLLOCK="ScrlLck";
		Keyboard.KEYNAME_PAUSE="Pause";
		Keyboard.KEYNAME_SYSREQ="SysReq";
		Keyboard.KEYNAME_BREAK="Break";
		Keyboard.KEYNAME_RESET="Reset";
		Keyboard.KEYNAME_STOP="Stop";
		Keyboard.KEYNAME_MENU="Menu";
		Keyboard.KEYNAME_USER="User";
		Keyboard.KEYNAME_SYSTEM="Sys";
		Keyboard.KEYNAME_PRINT="Print";
		Keyboard.KEYNAME_CLEARLINE="ClrLn";
		Keyboard.KEYNAME_CLEARDISPLAY="ClrDsp";
		Keyboard.KEYNAME_INSERTLINE="InsLn";
		Keyboard.KEYNAME_DELETELINE="DelLn";
		Keyboard.KEYNAME_INSERTCHAR="InsChr";
		Keyboard.KEYNAME_DELETECHAR="DelChr";
		Keyboard.KEYNAME_PREV="Prev";
		Keyboard.KEYNAME_NEXT="Next";
		Keyboard.KEYNAME_SELECT="Select";
		Keyboard.KEYNAME_EXECUTE="Exec";
		Keyboard.KEYNAME_UNDO="Undo";
		Keyboard.KEYNAME_REDO="Redo";
		Keyboard.KEYNAME_FIND="Find";
		Keyboard.KEYNAME_HELP="Help";
		Keyboard.KEYNAME_MODESWITCH="ModeSw";
		Keyboard.NUMBER_0=48;
		Keyboard.NUMBER_1=49;
		Keyboard.NUMBER_2=50;
		Keyboard.NUMBER_3=51;
		Keyboard.NUMBER_4=52;
		Keyboard.NUMBER_5=53;
		Keyboard.NUMBER_6=54;
		Keyboard.NUMBER_7=55;
		Keyboard.NUMBER_8=56;
		Keyboard.NUMBER_9=57;
		Keyboard.A=65;
		Keyboard.B=66;
		Keyboard.C=67;
		Keyboard.D=68;
		Keyboard.E=69;
		Keyboard.F=70;
		Keyboard.G=71;
		Keyboard.H=72;
		Keyboard.I=73;
		Keyboard.J=74;
		Keyboard.K=75;
		Keyboard.L=76;
		Keyboard.M=77;
		Keyboard.N=78;
		Keyboard.O=79;
		Keyboard.P=80;
		Keyboard.Q=81;
		Keyboard.R=82;
		Keyboard.S=83;
		Keyboard.T=84;
		Keyboard.U=85;
		Keyboard.V=86;
		Keyboard.W=87;
		Keyboard.X=88;
		Keyboard.Y=89;
		Keyboard.Z=90;
		Keyboard.SEMICOLON=186;
		Keyboard.EQUAL=187;
		Keyboard.COMMA=188;
		Keyboard.MINUS=189;
		Keyboard.PERIOD=190;
		Keyboard.SLASH=191;
		Keyboard.BACKQUOTE=192;
		Keyboard.LEFTBRACKET=219;
		Keyboard.BACKSLASH=220;
		Keyboard.RIGHTBRACKET=221;
		Keyboard.QUOTE=222;
		Keyboard.ALTERNATE=18;
		Keyboard.BACKSPACE=8;
		Keyboard.CAPS_LOCK=20;
		Keyboard.COMMAND=15;
		Keyboard.CONTROL=17;
		Keyboard.DELETE=46;
		Keyboard.MacDELETE=8;
		Keyboard.DOWN=40;
		Keyboard.END=35;
		Keyboard.ENTER=13;
		Keyboard.ESCAPE=27;
		Keyboard.F1=112;
		Keyboard.F2=113;
		Keyboard.F3=114;
		Keyboard.F4=115;
		Keyboard.F5=116;
		Keyboard.F6=117;
		Keyboard.F7=118;
		Keyboard.F8=119;
		Keyboard.F9=120;
		Keyboard.F10=121;
		Keyboard.F11=122;
		Keyboard.F12=123;
		Keyboard.F13=124;
		Keyboard.F14=125;
		Keyboard.F15=126;
		Keyboard.HOME=36;
		Keyboard.INSERT=45;
		Keyboard.LEFT=37;
		Keyboard.NUMPAD=21;
		Keyboard.NUMPAD_0=96;
		Keyboard.NUMPAD_1=97;
		Keyboard.NUMPAD_2=98;
		Keyboard.NUMPAD_3=99;
		Keyboard.NUMPAD_4=100;
		Keyboard.NUMPAD_5=101;
		Keyboard.NUMPAD_6=102;
		Keyboard.NUMPAD_7=103;
		Keyboard.NUMPAD_8=104;
		Keyboard.NUMPAD_9=105;
		Keyboard.NUMPAD_ADD=107;
		Keyboard.NUMPAD_DECIMAL=110;
		Keyboard.NUMPAD_DIVIDE=111;
		Keyboard.NUMPAD_ENTER=108;
		Keyboard.NUMPAD_MULTIPLY=106;
		Keyboard.NUMPAD_SUBTRACT=109;
		Keyboard.PAGE_DOWN=34;
		Keyboard.PAGE_UP=33;
		Keyboard.RIGHT=39;
		Keyboard.SHIFT=16;
		Keyboard.SPACE=32;
		Keyboard.TAB=9;
		Keyboard.UP=38;
		Keyboard.RED=16777216;
		Keyboard.GREEN=16777217;
		Keyboard.YELLOW=16777218;
		Keyboard.BLUE=16777219;
		Keyboard.CHANNEL_UP=16777220;
		Keyboard.CHANNEL_DOWN=16777221;
		Keyboard.RECORD=16777222;
		Keyboard.PLAY=16777223;
		Keyboard.PAUSE=16777224;
		Keyboard.STOP=16777225;
		Keyboard.FAST_FORWARD=16777226;
		Keyboard.REWIND=16777227;
		Keyboard.SKIP_FORWARD=16777228;
		Keyboard.SKIP_BACKWARD=16777229;
		Keyboard.NEXT=16777230;
		Keyboard.PREVIOUS=16777231;
		Keyboard.LIVE=16777232;
		Keyboard.LAST=16777233;
		Keyboard.MENU=16777234;
		Keyboard.INFO=16777235;
		Keyboard.GUIDE=16777236;
		Keyboard.EXIT=16777237;
		Keyboard.BACK=16777238;
		Keyboard.AUDIO=16777239;
		Keyboard.SUBTITLE=16777240;
		Keyboard.DVR=16777241;
		Keyboard.VOD=16777242;
		Keyboard.INPUT=16777243;
		Keyboard.SETUP=16777244;
		Keyboard.HELP=16777245;
		Keyboard.MASTER_SHELL=16777246;
		Keyboard.SEARCH=16777247;
		__static(Keyboard,
		['CharCodeStrings',function(){return this.CharCodeStrings=["Up","Down","Left","Right","F1","F2","F3","F4","F5","F6","F7","F8","F9","F10","F11","F12","F13","F14","F15","F16","F17","F18","F19","F20","F21","F22","F23","F24","F25","F26","F27","F28","F29","F30","F31","F32","F33","F34","F35","Insert","Delete","Home","Begin","End","PgUp","PgDn","PrntScrn","ScrlLck","Pause","SysReq","Break","Reset","Stop","Menu","User","Sys","Print","ClrLn","ClrDsp","InsLn","DelLn","InsChr","DelChr","Prev","Next","Select","Exec","Undo","Redo","Find","Help","ModeSw"];}
		]);
		return Keyboard;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-6-23 下午2:33:23
	*/
	//class laya.editor.core.Wraps.MenuManager
	var MenuManager=(function(){
		function MenuManager(){}
		__class(MenuManager,'laya.editor.core.Wraps.MenuManager');
		MenuManager.showMenu=function(menuStr,thisO,fun){
			var tMenu;
			if(!MenuManager._menuDic[menuStr]){
				tMenu=ContextMenu.createMenuByArray2(menuStr.split(","));
				MenuManager._menuDic[menuStr]=tMenu;
			}
			tMenu=MenuManager._menuDic[menuStr];
			tMenu.offAll("select");
			tMenu.once("select",thisO,fun);
			tMenu.show();
		}

		MenuManager._menuDic={};
		return MenuManager;
	})()


	//class laya.editor.core.Wraps.xml.XMLElement
	var XMLElement=(function(){
		function XMLElement(value){
			this._nodeName=null;
			this._nodeType=null;
			this._nodeValue=null;
			this._parentNode=null;
			this._attributes=[];
			this._childNodes=[];
			this._nestCount=0;
			if((value instanceof laya.editor.core.Wraps.xml.XMLElement )){return value}
				else if ((value instanceof laya.editor.core.Wraps.xml.XMLElementList )){if (value.lengths()==1){return value[0]}else {return value;}}
			if (value){
				if(value && value['_data_']){value=value.toString();}
					if (value){
					XMLElement.create(value,this);
				}
			}
		}

		__class(XMLElement,'laya.editor.core.Wraps.xml.XMLElement');
		var __proto=XMLElement.prototype;
		Laya.imps(__proto,{"laya.editor.core.Wraps.xml.IXMLElement":true})
		__proto.addNamespace=function(ns){
			return this;
		}

		/**同xml.@name=value*/
		__proto.setAttribute=function(name,value){
			var o;
			for(var $each_o in this._attributes){
				o=this._attributes[$each_o];
				if (o.key==name){
					o.val=value;
					return value;
				}
			}
			this._attributes.push({key:name,val:value});
			return value;
		}

		/**同xml.attributes()*/
		__proto.getAttributes=function(){
			return this.getAttribute("*");
		}

		/**同xml.attributes()*/
		__proto.attributes=function(){
			return this.getAttribute("*");
		}

		/**同xml.@name*/
		__proto.getAttribute=function(name){
			var attributes=this._attributes;
			var arr=[];
			for (var j=0;j < attributes.length;j++){
				var value=attributes[j]['key'];
				if (name=="*" || value==name){
					arr.push({"key":attributes[j]['key'],"val":attributes[j]['val']});
				}
			}
			if (name!="*"){
				return arr.length>0?arr[0].val:undefined;
			}
			return XMLElementList.createFromAttribute(arr);
		}

		/**同xml..@name*/
		__proto.getAllAttribute=function(name){
			var arr=[];
			this._getAllAttribute_(arr,this,name);
			return XMLElementList.createFromAttribute(arr);
		}

		__proto._getAllAttribute_=function(arr,xml,name){
			var len=xml._childNodes ? xml._childNodes.length :0;
			for (var i=0;i < len;i++){
				var node=xml._childNodes [i];
				for (var j=0;j < node._attributes.length;j++){
					var key=node._attributes[j]['key'];
					var val=node._attributes[j]['val'];
					if (name=="*"){
						arr.push({"key":key,"val":val});
						}else if (key==name){
						arr.push({"key":key,"val":val});
					}
				}
				this._getAllAttribute_(arr,node,name);
			}
		}

		/**同xml.@name*/
		__proto.attribute=function(name){
			return this.getAttribute(name);
		}

		/**同xml.name*/
		__proto.getChildByName=function(name){
			return this.child(name);
		}

		/**同xml..name*/
		__proto.getAllChildByName=function(name){
			var arr=[];
			this._getAllChildByName_(arr,this,name);
			return XMLElementList.create(arr);
		}

		__proto._getAllChildByName_=function(arr,xml,name){
			var len=xml._childNodes ? xml._childNodes.length :0;
			for (var i=0;i < len;i++){
				var node=xml._childNodes [i];
				if(name=="*"){
					arr.push(node);
					}else if (node._nodeName==name){
					arr.push(node);
				}
				this._getAllChildByName_(arr,node,name);
			}
		}

		__proto.nodeKind=function(){
			return this._nodeType;
		}

		/**同xml.(@attribute==value);或者xml.(@attribute!=value)*/
		__proto.getChildByAttribute=function(attribute,value,equal){
			(equal===void 0)&& (equal=true);
			if (attribute=="" || attribute==null)
				return null;
			if (value=="" || value==null)
				return null;
			var ar=[],len=this._childNodes ? this._childNodes.length :0;
			for (var i=0;i < len;i++){
				var n=this._childNodes [i];
				for (var j=0;j < n._attributes.length;j++){
					if (n._attributes[j]['key']==attribute){
						if (equal && n._attributes[j]['val']==value){
							ar.push(n);
							}else if (!equal && n._attributes[j]['val'] !=value){
							ar.push(n);
						}
					}
				}
			}
			return XMLElementList.create(ar);
		}

		/**xml.children()*/
		__proto.children=function(){
			var l=XMLElementList.create(this._childNodes);
			if(!l.length)
				if((typeof this._nodeValue=='string')&& this._nodeValue !=""){
				l.push(this._nodeValue);
			}
			return l;
		}

		/**xml[0];same with XMLElementList,different in with XMLElement;
		*In Flash XML class xml[0] return self,xml[1] return undefined;
		**/
		__proto.getChildAt=function(index){
			if (!this._childNodes || index > this._childNodes.length)
				return null;
			return this._childNodes[index];
		}

		/**同xml.element(*)*/
		__proto.elements=function(name){
			(name===void 0)&& (name="*");
			if (name=='*')
				return XMLElementList.create(this._childNodes);
			return this.child(name);
		}

		/**同xml.appendchild(value)*/
		__proto.appendChild=function(value){
			if ((typeof value=='string')){
				value=laya.editor.core.Wraps.xml.XMLElement.create(String(value));
			}
			if ((value instanceof laya.editor.core.Wraps.xml.XMLElement )){
				var name=value._nodeName;
				var list=this[name];
				if (!list){
					this[name]=list=new XMLElementList();
				}
				(((typeof list=='function'))!=true)&&(list.__addChild__(value));
				this._childNodes.push(value);
				}else if ((value instanceof laya.editor.core.Wraps.xml.XMLElementList )){
				var len=value.lengths();
				for (var i=0;i < len;i++){
					this.appendChild(value[i]);
				}
			}
			value._parentNode=this;
			return value;
		}

		__proto.prependChild=function(value){
			var xml=this.appendChild(value);
			var nodes=this._childNodes;
			nodes.pop();
			nodes.splice(0,0,xml);
			return xml;
		}

		/**同xml.name=value*/
		__proto.setChildByName=function(nName,value){
			var c=this.getChildByName(nName);
			if (!c)
				return null;
			var spliceIndex=this._childNodes.length;
			for (var i=this._childNodes.length-1;i >=0;i--){
				if (this._childNodes[i].localName==nName){
					this._childNodes.splice(i,1);
					spliceIndex=i;
				}
			}
			if ((value instanceof laya.editor.core.Wraps.xml.XMLElementList )){
				for (i=0;i < value.lengths();i++){
					this._childNodes.splice(spliceIndex,0,value[i]);
					spliceIndex++;
				}
				}else if ((value instanceof laya.editor.core.Wraps.xml.XMLElement )){
				this._childNodes.splice(spliceIndex,0,value);
				}else {
				return null;
			}
			return c;
		}

		/**同xml.copy()*/
		__proto.copy=function(){
			var xml=new XMLElement(this.toXMLString());
			return xml;
		}

		__proto.copyFrom=function(source){
			if ((source instanceof laya.editor.core.Wraps.xml.XMLElement )){
				var value=source;
				this._nodeName=value._nodeName;
				this._nodeValue=value._nodeValue;
				this._attributes=value._attributes;
				this._childNodes=value._childNodes;
				return this;
			}
			return null;
		}

		/**同xml.setName(name)*/
		__proto.setName=function(str){
			this._nodeName=str;
		}

		/**同xml.hasOwnProperty(p)*/
		__proto.hasOwnProperty=function(pName){
			var len=0,i=0;
			if(pName.indexOf("@")!=-1){
				var tmpPName=pName.substring(1);
				len=this._attributes.length;
				for (i=0;i < len;i++){
					if (this._attributes[i].key==tmpPName)
						return true;
				}
				}else{
				len=this._childNodes.length;
				for (i=0;i < len;i++){
					if (this._childNodes[i]._nodeName==pName)
						return true;
				}
			}
			return false;
		}

		/**同xml.hasSimpleContent()*/
		__proto.hasSimpleContent=function(){
			if (this._childNodes.length > 0){
				return false;
				}else if (this._childNodes.length==1){
				if (!this._childNodes[0].localName)
					return true;
				return false;
			}
			return true;
		}

		/**同xml.hasComplexContent()*/
		__proto.hasComplexContent=function(){
			return this._childNodes.length > 0
		}

		/**同xml.length()*/
		__proto.lengths=function(){
			return 1
		}

		/**同xml.name()*/
		__proto.name=function(){
			return this._nodeName;
		}

		/**同xml.parent()*/
		__proto.parent=function(){
			return this._parentNode;
		}

		/**同xml.toString()*/
		__proto.toString=function(){
			var str="";
			if (this._childNodes.length){
				str=this.toXMLString();
			}else
			str=this._nodeValue;
			return str;
		}

		__proto.getString=function(){
			var str="";
			str=this.toXMLString();
			return str;
		}

		__proto.getNodeValueStr=function(){
			return this._nodeValue;
			var rst;
			rst="<![CDATA["+this._nodeValue+"]]>";
			return rst;
			return this._nodeValue;
		}

		/**同xml.toXMLString()*/
		__proto.toXMLString=function(){
			if (!XMLElement._callee)
				XMLElement._callee=this;
			var str="";
			str+=XMLElement.getStartEmpty(this._nestCount);
			if (this._nodeName){
				str+="<"+this._nodeName;
				for (var i=0;i < this._attributes.length;i++){
					str+=" "+this._attributes[i]['key']+'="'+XMLElement.getAttributeStr(this._attributes[i]['val'])+'"'
				}
			}
			if (this.hasSimpleContent()&& !this.value)
				str+="/>";
			else {
				str+=this._nodeName ? ">" :"";
				str+=(this._childNodes.length ? "\n" :this.getNodeValueStr());
				for (i=0;i < this._childNodes.length;i++){
					this._childNodes[i]._nestCount=this._nestCount+1;
					str+=this._childNodes[i].toXMLString();
					str+="\n";
				}
				if (this._nodeName)
					str+=XMLElement.getStartEmpty(this._nestCount)+"</"+this._nodeName+">";
			}
			if (XMLElement._callee !=this){
			}
			else
			XMLElement._callee=null;
			return str;
		}

		__proto.child=function(nName){
			if((typeof nName=='number')){
				return XMLElementList.create([ this._childNodes[nName]]);
			};
			var ar=[],len=this._childNodes ? this._childNodes.length :0;
			for (var i=0;i < len;i++){
				var n=this._childNodes [i];
				if (n.localName==nName){
					ar.push(n);
				}
			}
			return XMLElementList.create(ar);
		}

		__proto.childIndex=function(){
			var parent=this._parentNode;
			if (parent){
				var nodes=parent._childNodes;
				for (var i=0,n=nodes.length;i < n;i++){
					if (nodes[i]==this){
						return i;
					}
				}
			}
			return-1;
		}

		__proto.insertChildBefore=function(child1,child2){
			return null;
		}

		__proto.normalize=function(){
			return null;
		}

		__proto.comments=function(){
			return null;
		}

		__proto.contains=function(value){
			return true;
		}

		__proto.defaultSettings=function(){
			return null;
		}

		__proto.descendants=function(name){
			return null;
		}

		__proto.inScopeNamespaces=function(){
			return [];
		}

		__proto.setLocalName=function(name){
			this._nodeName=name;
		}

		__getset(0,__proto,'nodeType',function(){
			return this._nodeType;
		});

		/**同xml.toString()*/
		/**同xml.toString()*/
		__getset(0,__proto,'value',function(){
			return this._nodeValue;
			},function(str){
			this._nodeValue=str;
		});

		__getset(0,__proto,'childNodes',function(){
			return this._childNodes;
		});

		__getset(0,__proto,'nodeName',function(){
			return this._nodeName;
		});

		/**同xml.localName()*/
		__getset(0,__proto,'localName',function(){
			return this._nodeName;
			},function(str){
			this._nodeName=str;
		});

		/*微端顶级节点的value*/
		__getset(0,__proto,'conchValue',function(){
			var temp="";
			if (this._childNodes){
				for (var i=0,len=this._childNodes.length;i < len;i++){
					temp+=this._childNodes[i].conchValue;
				}
				temp+=this.value;
			}
			else
			temp=this.value;
			return temp;
		});

		XMLElement.create=function(value,node){
			node=node ? node :new XMLElement();
			var xmld;
			if (false && !((typeof value=='string'))){
				xmld=value;
				xmld=xmld.childNodes[0];
				}else {
				if (SystemSetting.isCMDVer){
					var DOMParser=require('xmldom').DOMParser;;
					}else{
					DOMParser=Browser.window.DOMParser;;
				}
				xmld=(new DOMParser()).parseFromString(value,'text/xml');var t_i=0;var t_xmld=null;do{t_xmld=xmld.childNodes[t_i++];if(t_xmld.nodeName !='#comment' ){xmld=t_xmld;break;}}while(t_i<xmld.childNodes.length);;
			}
			XMLElement.cloneXmlFromData(node,xmld);
			return node;
		}

		XMLElement.parseXmlFromString=function(xmlString){
			var xmld;
			if (SystemSetting.isCMDVer){
				var DOMParser=require('xmldom').DOMParser;;
				}else{
				DOMParser=Browser.window.DOMParser;;
			}
			xmld=(new DOMParser()).parseFromString(xmlString,'text/xml');;
			return xmld;
		}

		XMLElement.cloneXmlFromData=function(xml,data){
			xml._nodeName=data.nodeName;
			xml._nodeValue=data.nodeValue==null ? data.textContent :data.nodeValue;
			var attribs=data.attributes;
			var len=attribs ? attribs.length :0;
			var attributes=xml._attributes;
			for (var j=0;j < len;j++){
				var attr=attribs[j];
				attributes.push({key:attr.nodeName,val:attr.nodeValue});
			};
			var nodes=data.childNodes;
			var child;
			for (var i=0;i < nodes.length;i++){
				var node=nodes[i];
				var nodeName=node.nodeName;
				if(nodeName=="#text"){
					if(node.parentNode&&node.parentNode.textContent!=node.textContent){
						var tValue;
						tValue=node.nodeValue.replace(/(^\s*)|(\s*$)/g,'');
						if(tValue.length>1){
							node.nodeValue=tValue;
							child=new XMLElement();
							XMLElement.cloneXmlFromData(child,node);
							xml.appendChild(child);
						}
					}
				}else
				if (nodeName !="#text" && nodeName !="#comment"){
					if (nodeName=="#cdata-section" || nodeName==""){
						xml._nodeValue=node.nodeValue==null ? node.textContent :node.nodeValue;
						continue ;
					}
					child=new XMLElement();
					XMLElement.cloneXmlFromData(child,node);
					xml.appendChild(child);
				}
			}
		}

		XMLElement.getStartEmpty=function(count){
			var str="";
			for (var j=0;j < count;j++){
				str+="   ";
			}
			return str;
		}

		XMLElement.hasSpSigns=function(str){
			if(! (typeof str=='string'))return false;
			var i=0,len=0;
			len=XMLElement.spSigns.length;
			for(i=0;i<len;i++){
				if(str.indexOf(XMLElement.spSigns[i])>=0)return true;
			}
			return false;
		}

		XMLElement.getAttributeStr=function(val){
			if(! (typeof val=='string'))return val;
			var key;
			for(key in XMLElement.xmlSpecials){
				var sign;
				val=val.split(key).join(XMLElement.xmlSpecials[key]);
			}
			return val;
		}

		XMLElement._callee=null
		__static(XMLElement,
		['spSigns',function(){return this.spSigns=["<",">"];},'xmlSpecials',function(){return this.xmlSpecials={
				"<":"&lt;",
				">":"&gt;",
				"'":"&apos;",
				"\"":"&quot;"
		};}

		]);
		return XMLElement;
	})()


	/**全局配置*/
	//class laya.editor.LayaConfig
	var LayaConfig=(function(){
		function LayaConfig(){};
		__class(LayaConfig,'laya.editor.LayaConfig');
		LayaConfig.GAME_FPS=50;
		LayaConfig.MOVIE_INTERVAL=100;
		LayaConfig.resPath="";
		LayaConfig.uiPath="";
		LayaConfig.tipDelay=200;
		LayaConfig.tipFollowMove=true;
		LayaConfig.touchScrollEnable=true;
		LayaConfig.mouseWheelEnable=true;
		LayaConfig.VER="0.9.9 beta";
		LayaConfig.$HIDDEN="$HIDDEN";
		LayaConfig.$LOCKED="$LOCKED";
		return LayaConfig;
	})()


	/**代码管理类
	*@author yung
	*/
	//class laya.editor.manager.CodeManager
	var CodeManager=(function(){
		function CodeManager(){};
		__class(CodeManager,'laya.editor.manager.CodeManager');
		CodeManager.exportCode=function(){
			console.log("ExportCode");
			CodeManager.uiObjMap={};
			CodeManager.projectExportType=PageStyleManager.getProjectExportType();
			CodeManager.isLoadMode=PageExportType.isLoadType(CodeManager.projectExportType);
			CodeManager.isUIPackMode=CodeManager.projectExportType==PageExportType.LOAD_PACK;
			CodeManager.isAs=Math.ceil(ProjectSetting.codeType)==0;
			CodeManager.initPreExportInfo();
			CodeTplManager.initCodeTpls();
			CodeManager.tPageFileInfos={};
			CodeManager.uiDataExportFolder=FileTools.getFolder(FileManager.getWorkPath(ProjectSetting.uiExportPath));
			CodeManager.createByDir(SystemSetting.pagesPath);
			if(CodeManager.isUIPackMode){
				FileManager.createJSONFile(FileManager.getWorkPath(ProjectSetting.uiExportPath),CodeManager.uiObjMap);
				CodeManager.uiObjMap={};
			}
			CodeManager.saveExportInfo();
			console.log("Export code complete");
		}

		CodeManager.initPreExportInfo=function(){
			var filePath;
			filePath=CodeManager.getPreExportFilePath();
			CodeManager.preExportInfo=null;
			CodeManager.prePageFileInfos=null;
			CodeManager.hasPreExportInfo=false;
			CodeManager.isConfigsChanged=true;
			if(!FileTools.exist(filePath))return;
			try{
				CodeManager.preExportInfo=FileManager.readJSONFile(filePath);
				CodeManager.prePageFileInfos=CodeManager.preExportInfo["files"];
				CodeManager.hasPreExportInfo=true;
				if(CodeManager.getConfigsStatuStr()==CodeManager.preExportInfo["configStr"]){
					CodeManager.isConfigsChanged=false;
				}
			}catch(e){}
		}

		CodeManager.getConfigsStatuStr=function(){
			var ctimes;
			ctimes=[];
			var i=0,len=0;
			len=CodeManager.configFiles.length;
			for(i=0;i<len;i++){
				var tFile;
				tFile=FileManager.getWorkPath("laya/"+CodeManager.configFiles[i]);
				if(FileTools.exist(tFile)){
					ctimes.push(FileTools.getMTime(tFile));
				}
			}
			return ctimes.join("_");
		}

		CodeManager.saveExportInfo=function(){
			var saveO;
			saveO={};
			saveO["configStr"]=CodeManager.getConfigsStatuStr();
			saveO["files"]=CodeManager.tPageFileInfos;
			FileManager.createJSONFile(CodeManager.getPreExportFilePath(),saveO);
			CodeManager.tPageFileInfos={};
		}

		CodeManager.getPrePageInfoO=function(pagePath){
			if(CodeManager.prePageFileInfos&&CodeManager.prePageFileInfos[pagePath]){
				return CodeManager.prePageFileInfos[pagePath];
				}else{
				return null;
			}
		}

		CodeManager.isCacheCodeOK=function(pagePath,mTime){
			if(CodeManager.isUIPackMode)return false;
			if(!CodeManager.hasPreExportInfo)return false;
			if(CodeManager.isConfigsChanged)return false;
			var pageInfo;
			pageInfo=CodeManager.getPrePageInfoO(pagePath);
			if(pageInfo){
				if(mTime==pageInfo["mTime"]&&!pageInfo["hasSpecial"]&&pageInfo["code"]){
					return true;
				}
			}
			return false;
		}

		CodeManager.getCacheCode=function(pagePath,mTime){
			if(!CodeManager.isCacheCodeOK(pagePath,mTime))return null;
			return CodeManager.getPrePageInfoO(pagePath)["code"];
		}

		CodeManager.isSpecialPageFile=function(pageTxt){
			var i=0,len=0;
			len=CodeManager.SpecialPageKeyWords.length;
			for(i=0;i<len;i++){
				if(pageTxt.indexOf(CodeManager.SpecialPageKeyWords[i])>=0){
					return true;
				}
			}
			return false;
		}

		CodeManager.getPreExportFilePath=function(){
			return FileManager.getDataPath("codeCache/"+CodeManager.getProjectSign()+"code.cache");
			return FileManager.getWorkPath("laya/code.cache");
		}

		CodeManager.getProjectSign=function(){
			var sign;
			sign=FileManager.adptToCommonUrl(SystemSetting.workPath);
			sign=SMD5.md5(sign,null,null);
			return sign;
		}

		CodeManager.getCodePath=function(pagePath){
			var page1=FileManager.getRelativePath(SystemSetting.pagesPath,pagePath);
			var page2=FileManager.getWorkPath(ProjectSetting.codeExportPath+"/"+page1);
			var newNameSign;
			switch(Math.ceil(ProjectSetting.codeType)){
				case 0:
					newNameSign="UI.as";
					break ;
				case 2:
				case 2:
					newNameSign="UI.js";
					break ;
				case 1:
					newNameSign="UI.ts";
					break ;
				};
			var i=0,len=0;
			len=CodeManager.pageFileSigns.length;
			for(i=0;i<len;i++){
				if(page2.indexOf(CodeManager.pageFileSigns[i])>=0){
					return page2.replace(CodeManager.pageFileSigns[i],newNameSign);
				}
			}
			return page2.replace(".ui",newNameSign);
		}

		CodeManager.initTsCodePre=function(){
			ObjectTools$1.clearObj(CodeManager.importDic);
			var arr;
			arr=ProjectSetting.codeImportsTS.split("\n");
			var preImports;
			var preCodes;
			preImports=[];
			preCodes=[];
			var i=0,len=0;
			len=arr.length;
			var tStr;
			for(i=0;i<len;i++){
				tStr=arr[i];
				if(tStr.indexOf("import")>=0){
					preImports.push(tStr);
					CodeManager.parseTsImport(tStr);
					}else{
					preCodes.push(tStr);
				}
			}
			CodeManager.tsCodePreImport=preImports.join("\n");
			CodeManager.tsCodePreFromImport=preCodes.join("\n");
		}

		CodeManager.parseTsImport=function(str){
			var tStr;
			tStr=str.replace("import","");
			var arr;
			arr=tStr.split("=");
			tStr=StringTool$1.trimSide(arr[0]);
			CodeManager.importDic[tStr]=true;
		}

		CodeManager.createByDir=function(file){
			var fileList;
			fileList=FileTools.getFileList(file);
			var i=0,len=0;
			len=fileList.length;
			var tFile;
			var code;
			var obj;
			var codePath;
			var resUsed;
			resUsed=[];
			var allInOneFile;
			CodeManager.initTsCodePre();
			switch(Math.ceil(ProjectSetting.codeType)){
				case 0:
					break ;
				case 2:
					CodeManager.allInOnePre=CodeTplManager.jsCodePre;
					allInOneFile=CodeManager.allInOnePre+"\n"+ProjectSetting.codeImportsJS;
					break ;
				case 1:
					CodeManager.allInOnePre=CodeTplManager.tsCodePre;
					allInOneFile=CodeManager.allInOnePre+"\n"+ProjectSetting.codeImportsTS;
					break ;
				};
			var hasCodeFile=false;
			hasCodeFile=false;
			var changeTime;
			var rPath;
			var tPageInfo;
			var isCacheOK=false;
			for(i=0;i<len;i++){
				tFile=fileList[i];
				if(FileTools.isDirectory(tFile)){
					}else{
					rPath=FileManager.getRelativePath(SystemSetting.pagesPath,tFile);
					changeTime=FileTools.getMTime(tFile).toString();
					isCacheOK=CodeManager.isCacheCodeOK(rPath,changeTime);
					if(isCacheOK&&CodeManager.isAs){
						continue ;
					}
					tPageInfo=CodeManager.getPrePageInfoO(rPath);
					if(!tPageInfo){
						tPageInfo={};
					}
					tPageInfo["mTime"]=changeTime;
					CodeManager.tPageFileInfos[rPath]=tPageInfo;
					if(TypeManager.getFileType(tFile)=="graphic_animation"){
						var tarPath;
						tarPath=FileManager.getPath(FileManager.getWorkPath(ProjectSetting.asynResExportPath),rPath);
						var tDataConfig;
						tDataConfig=FileManager.readJSONFile(tFile);
						CodeManager.cleanUIObj(tDataConfig,null);
						FileManager.createJSONFile(tarPath,tDataConfig);
					}else
					if(TypeManager.isCodeViewFile(tFile)){
						if(TypeManager.getFileType(tFile)=="Prefab"){
							if(!PageStyleManager.getIfPageExport(FileManager.getRelativePath(SystemSetting.pagesPath,tFile))){
								continue ;
							}
						}
						hasCodeFile=true;
						try{
							if(isCacheOK){
								code=CodeManager.getCacheCode(rPath,changeTime);
								}else{
								console.log("Export:",rPath);
								code=FileManager.readTxtFile(tFile);
								tPageInfo["hasSpecial"]=CodeManager.isSpecialPageFile(code);
								obj=ObjectTools$1.getObj(code);
								if(obj.props){
									delete obj.props["var"];
								}
								if(obj.props&&obj.props["base64pic"]==true){
									CodeManager.collectSkins(obj,resUsed);
								}
								code=CodeManager.objToUI(obj,tFile);
							}
							tPageInfo["code"]=code;
							codePath=CodeManager.getCodePath(tFile);
							if(ProjectSetting.codeType==2||ProjectSetting.codeType==1){
								allInOneFile+="\n"+code;
								}else{
								if(ProjectSetting.codeType==1){
									code=CodeTplManager.tsCodePre+"\n"+code;
								}
								FileManager.createTxtFile(codePath,code);
							}
							}catch(e){
							Alert.show(Sys.lang("读取页面({0})出错\n{1}读取页面出错",tFile,e.toString()));
						}
					}else
					if(TypeManager.getFileType(tFile)=="particle"||TypeManager.getFileType(tFile)=="particle3D"||TypeManager.getFileType(tFile)=="particlepoly"){
						rPath=FileManager.getRelativePath(SystemSetting.pagesPath,tFile);
						tarPath=FileManager.getPath(FileManager.getWorkPath(ProjectSetting.asynResExportPath),rPath);
						FileTools.copyFile(tFile,tarPath);
						var tParticleConfig;
						tParticleConfig=FileManager.readJSONFile(tFile);
						var textureFile;
						if(!tParticleConfig){
							Alert.show(Sys.lang("文件已损坏！：{0}",tFile));
							continue ;
						}
						textureFile=tParticleConfig.textureName;
						var texturePath;
						if(textureFile){
							texturePath=FileManager.getResPath(textureFile);
							var tarTexturePath;
							tarTexturePath=FileManager.getPath(FileManager.getWorkPath(ProjectSetting.asynResExportPath),textureFile);
							FileTools.copyFile(texturePath,tarTexturePath);
						}
					}
				}
			}
			if(!hasCodeFile)return;
			CodeManager.saveBase64Pics(resUsed);
			if(ProjectSetting.codeType==2||ProjectSetting.codeType==1){
				var fileType;
				fileType=ProjectSetting.codeType==2?"js":"ts";
				codePath=CodeManager.getCodePath(FileManager.getPath(file,"layaUI.max.all."+fileType));
				FileManager.createTxtFile(codePath,allInOneFile);
				var tarFolder;
				tarFolder=codePath.replace(".ts",".js");
				if(ProjectSetting.codeType==1){
					var cmdTSC;
					cmdTSC="tsc --out \""+tarFolder+"\" \""+codePath+"\"";
				}
			}
		}

		CodeManager.collectSkins=function(uiO,resUsed){
			resUsed=TemplateManager.findAllResUsed(uiO,resUsed);
		}

		CodeManager.saveBase64Pics=function(resUsed){
			if(!resUsed||resUsed.length<1)return;
			var i=0,len=0;
			len=resUsed.length;
			var data;
			data={};
			for(i=0;i<len;i++){
				CodeManager.convertSkinRes(resUsed[i],data);
			};
			var codePath;
			codePath=FileManager.getPath(FileManager.getWorkPath(ProjectSetting.resExportPath),"base64pic.json");
			FileManager.createTxtFile(codePath,JSON.stringify(data));
			if(ProjectSetting.codeType==0){
				CodeManager.saveAsBase64Class(data);
			}
		}

		CodeManager.saveAsBase64Class=function(data){
			var tpl;
			tpl=FileManager.readTxtFile(FileManager.getAppPath(Paths.ASBase64Template));
			var codePath;
			codePath=FileManager.getWorkPath(CodeTplManager.base64path);
			var dataO;
			dataO={};
			dataO["pack"]=CodeTplManager.base64pack;
			dataO["base64data"]=JSON.stringify(data);
			var code;
			code=CodeManager.createExportCode(tpl,dataO);
			FileManager.createTxtFile(codePath,code);
		}

		CodeManager.convertSkinRes=function(skinPath,data){
			var tex;
			var tPath;
			var i=0,len=0;
			len=CodeManager.specialFiles.length;
			for(i=0;i<len;i++){
				tPath=StringTool$1.getReplace(skinPath,".png",CodeManager.specialFiles[i]);
				if(!data[tPath]&&ResFileManager.hasRes(tPath)){
					tex=ResFileManager.getRes(tPath);
					if(tex){
						data[tPath]=Base64ImageTool.getBase64Pic(tex);
					}
				}
			}
		}

		CodeManager.getSkinSpecialRes=function(skinPath,arr){
			var tex;
			var tPath;
			var i=0,len=0;
			len=CodeManager.specialFiles.length;
			for(i=0;i<len;i++){
				tPath=StringTool$1.getReplace(skinPath,".png",CodeManager.specialFiles[i]);
				if(tPath==skinPath)continue ;
				if(ResFileManager.hasRes(tPath)){
					arr.push(tPath);
				}
			}
		}

		CodeManager.getReferStr=function(myPack,tarClass){
			var rst;
			var myArr;
			var tarArr;
			myArr=myPack.split(".");
			tarArr=tarClass.split(".");
			while(myArr.length&&tarArr.length&&myArr[0]==tarArr[0]){
				myArr.shift();
				tarArr.shift();
			};
			var i=0,len=0;
			len=myArr.length;
			for(i=0;i<len;i++){
				myArr[i]="../";
			}
			if(myArr.length>0){
				rst=myArr.join("")+tarArr.join("/");
				}else{
				rst=tarArr.join("/");
			}
			rst=rst+".ts";
			rst="///<reference path=\""+rst+"\" />";
			return rst;
		}

		CodeManager.objToUI=function(obj,pagePath){
			var pageType;
			pageType=TypeManager.getFileType(pagePath);
			var isEfc=false;
			isEfc=pageType=="MoveEffect";
			var isPreset=false;
			var className=FileManager.getFileName(pagePath)+"UI";
			var pack=CodeManager.getPackage(pagePath);
			var uiXml=ObjectTools$1.copyObjFast(obj);
			var viewMap={};
			isPreset=TypeManager.isPreFabNodeType(obj.type);
			CodeManager.parseUIobj(uiXml,viewMap);
			var imports="";
			var temp=[];
			for (var key in viewMap){
				temp.push({name:key,lib:viewMap[key]});
			}
			temp.sort(MathUtil.sortByKey("name"));
			var viewClassMap="";
			var preRefers="";
			var obj1;
			for(var $each_obj1 in temp){
				obj1=temp[$each_obj1];
				var lib=obj1.lib;
				var libName=lib.substring(lib.lastIndexOf(".")+1,lib.length);
				var regName;
				if(obj1.lib==obj1.name&&CodeManager.getRunClass(obj1.name)){
					lib=CodeManager.getRunClass(obj1.name);
					libName=lib.substring(lib.lastIndexOf(".")+1,lib.length);
					regName=obj1.name;
					}else{
					regName=lib;
				}
				if(ProjectSetting.codeType==0){
					imports+="	import "+lib+";\n";
					viewClassMap+="			View.regComponent(\""+regName+"\","+libName+");\n";
					}else{
					imports+="	import "+libName+" = "+lib+";\n";
					viewClassMap+="			View.regComponent(\""+regName+"\","+lib+");\n";
					preRefers+="\n"+CodeManager.getReferStr(pack,lib);
				}
			};
			var str="";
			if(isEfc){
				obj.type="EffectAnimation";
			};
			var baseName=obj.type;
			var uiObj;
			uiObj=ObjectTools$1.copyObjFast(uiXml);
			var needCompIdNode;
			needCompIdNode=AnimationDataWorker.getAnimationedNode(uiObj);
			CodeManager.cleanUIObj(uiObj,needCompIdNode);
			if(!CodeManager.isViewHasAnimation(uiObj)){
				delete uiObj.animations;
			};
			var uiPath;
			var pageLink;
			uiPath=pack+"."+className;
			uiPath=FileManager.getRelativePath(SystemSetting.pagesPath,pagePath);
			pageLink=uiPath=FileManager.adptToCommonUrl(uiPath);
			uiPath=uiPath.split(".")[0];
			var classObj;
			classObj={};
			classObj["className"]=className;
			classObj["classType"]=baseName;
			if(ProjectSetting.codeType==1){
				classObj["classType"]=CodeManager.getFullClassPath(baseName);
			}
			classObj["pack"]=pack;
			classObj["viewClassMap"]=viewClassMap;
			classObj["uiObj"]=JSON.stringify(uiObj);
			classObj["uiPath"]=uiPath;
			var fullClassname;
			if(!pack){
				fullClassname=className;
				}else{
				fullClassname=pack+"."+className;
			}
			classObj["fullClassname"]=fullClassname;
			var pageExportType;
			pageExportType=PageStyleManager.getPageFinalExportType(pageLink);
			switch(pageExportType){
				case PageExportType.INCODE:
					break ;
				case PageExportType.LOAD_ONE:
					FileManager.createJSONFile(FileManager.getPath(CodeManager.uiDataExportFolder,uiPath+".json"),uiObj);
					break ;
				case PageExportType.LOAD_PACK:
					CodeManager.uiObjMap[uiPath]=ObjectTools$1.copyObjFast(uiObj);
					break ;
				}
			switch(Math.ceil(ProjectSetting.codeType)){
				case 0:
					classObj["vars"]=CodeManager.createVarByObj(uiXml,viewMap);
					break ;
				case 2:
				case 2:
					classObj["vars"]=CodeManager.createJSVarByObj(uiXml,viewMap);
					break ;
				case 1:
					classObj["vars"]=CodeManager.createTSVarByObj(uiXml,viewMap);
					break ;
				}
			if(ProjectSetting.codeType==0){
				classObj["imports"]=CodeManager.prefixStr(ProjectSetting.codeImports,"	")+"\n"+imports;
				}else{
				classObj["imports"]=CodeManager.prefixStr(CodeManager.tsCodePreImport,"	")+"\n"+imports;
				classObj["importsPre"]=CodeManager.tsCodePreFromImport+"\n"+preRefers;
				classObj["imports"]=CodeManager.prefixStr("","	")+imports;
				classObj["importsPre"]="";
			};
			var tplStr;
			tplStr=CodeTplManager.getCodeTpl(ProjectSetting.codeType,isPreset,PageExportType.isLoadType(pageExportType),isEfc);
			str=CodeManager.createExportCode(tplStr,classObj);
			return str;
		}

		CodeManager.createExportCode=function(tplStr,data){
			var rst;
			var key;
			rst=tplStr;
			for(key in data){
				rst=StringTool$1.getReplace(rst,"{!"+key+"!}",data[key]);
			}
			return rst;
		}

		CodeManager.cleanUIObj=function(node,compIdNeedDic){
			var tkey;
			var childs;
			var i=0,len=0;
			if(!node.child)node.child=[];
			childs=node.child;
			len=childs.length;
			var type;
			type=node.type;
			var skinLabel;
			skinLabel=UIConfigManager.getCompSkinLabel(type);
			if(node.props&&node.props[skinLabel]){
				var skinStr;
				skinStr=node.props[skinLabel];
				if(skinStr.indexOf("~")>=0){
					delete node.props[skinLabel];
				}
			}
			for(i=0;i<len;i++){
				CodeManager.cleanUIObj(childs[i],compIdNeedDic);
			}
			for(tkey in node){
				if(!CodeManager.keysNeeded.hasOwnProperty(tkey)){
					delete node[tkey];
				}
			};
			var props;
			props=node.props;
			if(props){
				for(tkey in CodeManager.propkeysRemove){
					delete props[tkey];
				}
				for(tkey in CodeManager.NumKeys){
					if(tkey in props){
						props[tkey]=parseFloat(props[tkey]);
					}
				}
			}
			if(node.compId&&compIdNeedDic&&!compIdNeedDic[node.compId]){
				delete node.compId;
			}
			if(childs.length<1){
				delete node.child;
			}
			if(!CodeManager.isViewHasAnimation(node)){
				delete node.animations;
			}
		}

		CodeManager.createJSVarByObj=function(obj,viewMap){
			var arr=[];
			CodeManager.parseVarByObj(obj,arr);
			var str="";
			for(var i=0;i<arr.length;i++){
				var a=arr[i];
				var compType=a[1];
				if(viewMap[compType]==null){
					str+="		    this."+a[0]+"=null;\n";
					}else{
					var lib=viewMap[compType];
					var libName=lib.substring(lib.lastIndexOf(".")+1,lib.length);
					str+="		    this."+a[0]+"=null;\n";
				}
			}
			return str;
		}

		CodeManager.createVarByObj=function(obj,viewMap){
			var arr=[];
			CodeManager.parseVarByObj(obj,arr);
			var str="";
			for(var i=0;i<arr.length;i++){
				var a=arr[i];
				var compType=a[1];
				if(viewMap[compType]==null){
					str+="		public var "+a[0]+":"+compType+";\n";
					}else{
					var lib=viewMap[compType];
					if(CodeManager.getRunClass(lib)){
						lib=CodeManager.getRunClass(lib);
					};
					var libName=lib.substring(lib.lastIndexOf(".")+1,lib.length);
					str+="		public var "+a[0]+":"+libName+";\n";
				}
			}
			return str;
		}

		CodeManager.createTSVarByObj=function(obj,viewMap){
			var arr=[];
			CodeManager.parseVarByObj(obj,arr);
			var str="";
			for(var i=0;i<arr.length;i++){
				var a=arr[i];
				var compType=a[1];
				if(viewMap[compType]==null){
					str+="		public "+a[0]+":"+CodeManager.getFullClassPath(compType)+";\n";
					}else{
					var lib=viewMap[compType];
					if(CodeManager.getRunClass(lib)){
						lib=CodeManager.getRunClass(lib);
					};
					var libName=lib.substring(lib.lastIndexOf(".")+1,lib.length);
					str+="		public "+a[0]+":"+lib+";\n";
				}
			}
			return str;
		}

		CodeManager.getFullClassPath=function(className){
			var runClass;
			runClass=UIConfigManager.getCompProp(className,"runClass");
			if(CodeManager.importDic[className]){
				return className;
			}
			if(!runClass)runClass="Laya."+className;
			return runClass;
		}

		CodeManager.getRunClass=function(className){
			if(CodeManager.importDic[className]){
				return null;
			};
			var runClass;
			runClass=UIConfigManager.getCompProp(className,"runClass");
			return runClass;
		}

		CodeManager.cleanNodeAnimations=function(node){
			if(!CodeManager.isViewHasAnimation(node)){
				delete node.animations;
			}
		}

		CodeManager.isViewHasAnimation=function(obj){
			if(obj.animations){
				var i=0,len=0;
				var animations;
				animations=obj.animations;
				len=animations.length;
				for(i=0;i<len;i++){
					if(animations[i].nodes&&animations[i].nodes.length>0)
						return true;
				}
			}
			return false;
		}

		CodeManager.parseVarByObj=function(obj,arr){
			if(obj.animations){
				var i=0,len=0;
				var animations;
				animations=obj.animations;
				len=animations.length;
				for(i=0;i<len;i++){
					if(animations[i].nodes&&animations[i].nodes.length>0)
						arr.push([String(animations[i].name),"FrameAnimation"]);
				}
			}
			if(obj.props["var"]){
				arr.push([String(obj.props["var"]),obj.props.runtime?String(obj.props.runtime):obj.type]);
			};
			var list=obj.child;
			if(list)
				for (var j=0,n=list.length;j < n;j++){
				CodeManager.parseVarByObj(list[j],arr);
			}
		}

		CodeManager.prefixStr=function(str,prefix){
			var arr=str.split("\n");
			for (var i=0,n=arr.length;i < n;i++){
				arr[i]=prefix+arr[i];
			}
			return arr.join("\n");
		}

		CodeManager.getPackage=function(path){
			if (path==null)
				return null;
			path=FileManager.getRelativePath(SystemSetting.pagesPath,path);
			path=FileManager.adptToCommonUrl(path);
			path=path.substring(0,path.lastIndexOf("\/")).replace(/\//g,".");
			var uiPath=ProjectSetting.codeExportPath;
			uiPath=FileManager.adptToCommonUrl(uiPath);
			if(uiPath.charAt(uiPath.length-1)!="\/"){
				uiPath=uiPath+"\/";
			};
			var startIndex=uiPath.indexOf("src/")>-1?(uiPath.indexOf("src/")+4):(uiPath.indexOf("/")+1);
			uiPath=uiPath.substring(startIndex,uiPath.length-1).replace(/\//g,".");
			var pack=uiPath+(path!=""?"."+path:"");
			return pack;
		}

		CodeManager.parseUIobj=function(obj,viewMap){
			var compType=obj.type;
			compType=StringTool$1.trimSide(compType);
			obj.type=compType;
			var runtime;
			var prefabO;
			prefabO=PreFabManager.I.getPreFabByNode(obj);
			if (compType !="View" && compType !="Dialog"){
				if (compType !="UIView"){
					var skinLabel=""
					skinLabel=UIConfigManager.getCompProp(compType,"skinLabel");
					skinLabel=skinLabel || "styleSkin";
					var skin=obj.props[skinLabel]||obj.props["skin"];
					if(prefabO&&prefabO.props&&prefabO.props[skinLabel]){
						skin=prefabO.props[skinLabel];
					}
					if (Boolean(skin)){
						var defaultProps=ResStyleManager.getPropArr(skin);
						CodeManager.setObjDefaultValue(obj,defaultProps);
					}
					}else {
					var sourcePath=obj.source;
					if (Boolean(sourcePath)){
						defaultProps=ResStyleManager.getPropArrByPropStr(PageStyleManager.getPageProps(sourcePath));
						CodeManager.setObjDefaultValue(obj,defaultProps);
					}
				}
			}
			if(prefabO&&obj.props&&prefabO.props){
				PreFabManager.insertValues(obj.props,prefabO.props,obj.props);
			}
			AppendPropGroupTool.insertAppendProps(obj);
			AppendPropGroupTool.adptScriptNode(obj);
			PreFabManager.I.clearPreFabProps(obj);
			if (compType=="UIView"){
				var source=obj.source;
				source=FileManager.getPath(SystemSetting.pagesPath,source);
				var viewName=FileManager.getFileName(source);
				obj.type=viewName;
				runtime=obj.props.runtime;
				if(!runtime){
					runtime=obj.props.runtime=CodeManager.getPackage(source)+"."+viewName+"UI";
				}
				viewMap[runtime]=runtime;
				}else{
				runtime=obj.props.runtime;
				if(runtime){
					viewMap[runtime]=runtime;
					}else{
					var runClass;
					runClass=CodeManager.getRunClass(compType);
					if(runClass){
						viewMap[compType]=compType;
					}
				}
			}
			if(compType=="EffectAnimation"&&obj.props&&obj.props.effect){
				var effect=obj.props.effect;
				effect=FileManager.getPath(SystemSetting.pagesPath,effect);
				var effectName=FileManager.getFileName(effect);
				obj.props.runtime=CodeManager.getPackage(effect)+"."+effectName+"UI";
				obj.type="Script";
				delete obj.props.effect;
				delete obj.props.skin;
				viewMap[obj.props.runtime]=obj.props.runtime;
			}
			delete obj.props.layers;
			delete obj.props.layer;
			delete obj.props.sceneWidth;
			delete obj.props.sceneHeight;
			delete obj.props.sceneColor;
			delete obj.props.sceneBg;
			delete obj.props.styleSkin;
			var list=obj.child;
			if(list)
				for (var j=0,n=list.length;j < n;j++){
				CodeManager.parseUIobj(list[j],viewMap);
			}
			CodeManager.cleanNodeAnimations(obj);
		}

		CodeManager.setObjDefaultValue=function(obj,props){
			var prop;
			for(var $each_prop in props){
				prop=props[$each_prop];
				var a=prop.split("=");
				if (a.length==2){
					var key=a[0];
					var val=a[1];
					if (!obj.props.hasOwnProperty(key)){
						obj.props[key]=ObjectTools$1.getAutoValue(val);
					}
				}
			}
		}

		CodeManager.isLoadMode=false;
		CodeManager.isAs=false;
		CodeManager.uiObjMap=null
		CodeManager.projectExportType=null
		CodeManager.isUIPackMode=false;
		CodeManager.uiDataExportFolder=null
		CodeManager.hasPreExportInfo=false;
		CodeManager.isConfigsChanged=false;
		CodeManager.preExportInfo=null
		CodeManager.prePageFileInfos=null
		CodeManager.tPageFileInfos=null
		CodeManager.ChangeTimeSign="mTime";
		CodeManager.HasSpecialSign="hasSpecial";
		CodeManager.ExportCodeSign="code";
		CodeManager.CodeType_AS=0;
		CodeManager.CodeType_JS=2;
		CodeManager.CodeType_JSInOne=2;
		CodeManager.CodeType_TS=1;
		CodeManager.tsCodePreFromImport=null
		CodeManager.tsCodePreImport=null
		CodeManager.allInOnePre="";
		CodeManager.importDic={};
		__static(CodeManager,
		['configFiles',function(){return this.configFiles=[".laya","pageStyles.xml","styles.xml"];},'SpecialPageKeyWords',function(){return this.SpecialPageKeyWords=
			[
			"preset",
			"UIView",
			"Script",
			"appendProps"];},'pageFileSigns',function(){return this.pageFileSigns=
			[
			".ani",
			".scene",
			".prefabui",
			".prefab",
			".gani",
			".efc",
			".ui"];},'specialFiles',function(){return this.specialFiles=[".png","$down.png","$bar.png","$up.png"];},'keysNeeded',function(){return this.keysNeeded={
				"type":true,
				"props":true,
				"child":true,
				"compId":true,
				"animations":true
				};},'propkeysRemove',function(){return this.propkeysRemove={
				"appendProps":true,
				"preset":true,
				"presetID":true,
				"presetPre":true,
				"presetIDPre":true
		};},'NumKeys',function(){return this.NumKeys={"fontSize":true,"stateNum":true};}

		]);
		return CodeManager;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-10-21 下午4:03:09
	*/
	//class laya.editor.manager.CodeTplManager
	var CodeTplManager=(function(){
		function CodeTplManager(){}
		__class(CodeTplManager,'laya.editor.manager.CodeTplManager');
		CodeTplManager.init=function(type){
			(type===void 0)&& (type="");
			CodeTplManager.jsCodeTpl=FileManager.readTxtFile(FileManager.getAppPath(Paths.JSCodeTemplate+type));
			CodeTplManager.jsCodeTplPst=FileManager.readTxtFile(FileManager.getAppPath(Paths.JSCodeTemplate+".preset"));
			CodeTplManager.jsCodeTplEfc=FileManager.readTxtFile(FileManager.getAppPath(Paths.JSCodeTemplate+".efc"));
			CodeTplManager.jsCodePre=FileManager.readTxtFile(FileManager.getAppPath(Paths.JSCodePreTemplate));
			CodeTplManager.tsCodeTpl=FileManager.readTxtFile(FileManager.getAppPath(Paths.TSCodeTemplate+type));
			CodeTplManager.tsCodeTplPst=FileManager.readTxtFile(FileManager.getAppPath(Paths.TSCodeTemplate+".preset"));
			CodeTplManager.tsCodeTplEfc=FileManager.readTxtFile(FileManager.getAppPath(Paths.TSCodeTemplate+".efc"));
			CodeTplManager.tsCodePre=FileManager.readTxtFile(FileManager.getAppPath(Paths.TSCodePreTemplate));
			CodeTplManager.asCodeTpl=FileManager.readTxtFile(FileManager.getAppPath(Paths.ASCodeTemplate+type));
			CodeTplManager.asCodeTplPst=FileManager.readTxtFile(FileManager.getAppPath(Paths.ASCodeTemplate+".preset"));
			CodeTplManager.asCodeTplEfc=FileManager.readTxtFile(FileManager.getAppPath(Paths.ASCodeTemplate+".efc"));
			CodeTplManager.parsePublishConfig();
		}

		CodeTplManager.recordCodeTpls=function(sign){
			var tData;
			if(!CodeTplManager.codeTplsDic[sign]){
				CodeTplManager.codeTplsDic[sign]={};
			}
			tData=CodeTplManager.codeTplsDic[sign];
			var i=0,len=0;
			len=CodeTplManager._codeTplsNames.length;
			var tKey;
			for(i=0;i<len;i++){
				tKey=CodeTplManager._codeTplsNames[i];
				tData[tKey]=CodeTplManager[tKey];
			}
		}

		CodeTplManager.setCodeTpls=function(sign){
			var tData;
			tData=CodeTplManager.codeTplsDic[sign];
			var i=0,len=0;
			len=CodeTplManager._codeTplsNames.length;
			var tKey;
			for(i=0;i<len;i++){
				tKey=CodeTplManager._codeTplsNames[i];
				CodeTplManager[tKey]=tData[tKey];
			}
		}

		CodeTplManager.initCodeTpls=function(){
			CodeTplManager.initCodeTplsByLoadMode(false);
			CodeTplManager.recordCodeTpls("NoLoad");
			CodeTplManager.initCodeTplsByLoadMode(true);
			CodeTplManager.recordCodeTpls("Load");
		}

		CodeTplManager.getCodeTpl=function(codeType,isPreset,isLoad,isEfc){
			(isEfc===void 0)&& (isEfc=false);
			if(isLoad){
				CodeTplManager.setCodeTpls("Load");
				}else{
				CodeTplManager.setCodeTpls("NoLoad");
			};
			var tplStr;
			codeType=Math.ceil(codeType);
			switch(codeType){
				case 0:
					tplStr=CodeTplManager.asCodeTpl;
					if(isEfc){
						tplStr=CodeTplManager.asCodeTplEfc;
					}
					else
					if(isPreset){
						tplStr=CodeTplManager.asCodeTplPst;
					}
					break ;
				case 2:
				case 2:
					tplStr=CodeTplManager.jsCodeTpl;
					if(isEfc){
						tplStr=CodeTplManager.jsCodeTplEfc;
					}
					else
					if(isPreset){
						tplStr=CodeTplManager.jsCodeTplPst;
					}
					break ;
				case 1:
					tplStr=CodeTplManager.tsCodeTpl;
					if(isEfc){
						tplStr=CodeTplManager.tsCodeTplEfc;
					}
					else
					if(isPreset){
						tplStr=CodeTplManager.tsCodeTplPst;
					}
					break ;
				}
			return tplStr;
		}

		CodeTplManager.initCodeTplsByLoadMode=function(isLoadMode){
			if(isLoadMode){
				CodeTplManager.codeModeType=".load";
				CodeTplManager.init(".load");
				}else{
				CodeTplManager.codeModeType="";
				CodeTplManager.init();
			}
			CodeTplManager.parsePublishConfig();
		}

		CodeTplManager.parsePublishConfig=function(){
			var buildConfigPath;
			buildConfigPath=FileManager.getWorkPath("laya/build.cfg");
			if(!FileTools.exist(buildConfigPath)){
				CodeTplManager.setDefaultBuildAction();
				}else{
				try{
					var config;
					config=FileManager.readJSONFile(buildConfigPath);
					if(config.codemode=="2"){
						CodeTplManager.asCodeTpl=FileManager.readTxtFile(FileManager.getAppPath(Paths.ASCodeTemplate2));
						}else{
						CodeTplManager.asCodeTpl=FileManager.readTxtFile(FileManager.getAppPath(Paths.ASCodeTemplate+CodeTplManager.codeModeType));
					}
					CodeTplManager.base64path=config["base64path"];
					CodeTplManager.base64pack=config["base64pack"];
					}catch(e){
					CodeTplManager.setDefaultBuildAction();
				}
			}
		}

		CodeTplManager.setDefaultBuildAction=function(){
			CodeTplManager.asCodeTpl=FileManager.readTxtFile(FileManager.getAppPath(Paths.ASCodeTemplate+CodeTplManager.codeModeType));
			CodeTplManager.base64path="src/data/Base64AtlasManager.as";
			CodeTplManager.base64pack="data";
		}

		CodeTplManager.jsCodeTpl="";
		CodeTplManager.jsCodeTplPst="";
		CodeTplManager.jsCodeTplEfc="";
		CodeTplManager.jsCodePre="";
		CodeTplManager.tsCodeTpl="";
		CodeTplManager.tsCodeTplPst="";
		CodeTplManager.tsCodeTplEfc="";
		CodeTplManager.tsCodePre="";
		CodeTplManager.asCodeTpl="";
		CodeTplManager.asCodeTplPst="";
		CodeTplManager.asCodeTplEfc="";
		CodeTplManager.codeTplsDic={};
		CodeTplManager.codeModeType=null
		CodeTplManager.base64path="src/data/Base64AtlasManager.as";
		CodeTplManager.base64pack="data";
		__static(CodeTplManager,
		['_codeTplsNames',function(){return this._codeTplsNames=[
			"jsCodeTpl",
			"jsCodeTplPst",
			"jsCodeTplEfc",
			"jsCodePre",
			"tsCodeTpl",
			"tsCodeTplPst",
			"tsCodeTplEfc",
			"tsCodePre",
			"asCodeTpl",
			"asCodeTplPst",
			"asCodeTplEfc"];}
		]);
		return CodeTplManager;
	})()


	/**导出管理器
	*@author yung
	*/
	//class laya.editor.manager.ExportManager
	var ExportManager=(function(){
		function ExportManager(){};
		__class(ExportManager,'laya.editor.manager.ExportManager');
		ExportManager.init=function(){
			Notice.listen("Release_Project",null,ExportManager.release);
		}

		ExportManager.release=function(){
			ExportManager.clear();
			ExportManager.export(true);
		}

		ExportManager.forceExport=function(){
			ExportManager.clear();
			ExportManager.export(false,null,true);
		}

		ExportManager.clear=function(){
			ExportManager.clearRes=true;
			FileManager.removeFile(CodeManager.getPreExportFilePath());
			var uiCodePath=FileManager.getWorkPath(ProjectSetting.codeExportPath);
			FileManager.removeFile(uiCodePath);
			FileManager.createDirectory(uiCodePath);
		}

		ExportManager.export=function(release,complete,force){
			(release===void 0)&& (release=false);
			(force===void 0)&& (force=false);
			ExportManager.clearRes=force||ExportManager.configChanged;
			laya.editor.manager.ExportManager.complete=complete;
			if (UIPanel.instance.hasChange){
				Confirm.show(Sys.lang("在发布代码之前，有页面还未保存，是否保存然后发布？"),Sys.lang("有页面未保存"),ExportManager.confirmBack,[release],Sys.lang("保存并发布"),Sys.lang("直接发布"));
				}else {
				ExportManager.doExport(release);
			}
		}

		ExportManager.confirmBack=function(release,sure,type){
			if (sure){
				UIPanel.instance.saveAll();
			}
			if(type!="close")
				ExportManager.doExport(release);
		}

		ExportManager.packingEndHandler=function(err,stdOut,stdErr){
			console.log("err:",err);
			if (ExportManager.isCmdVer){
				if (ExportManager._packingEndHandler !=null){
					ExportManager._packingEndHandler(err,stdOut,stdErr);
				}
				return;
			}
			Waiting.hide();
			MessageManager.instance.show(Sys.lang("发布成功"));
			if(Browser.window["changeViewCode"]){
				Browser.window["changeViewCode"]();
			}
			if(SystemSetting.toCodeModeWhenPublicEnd){
				Laya.timer.once(1000,null,ExportManager.switchToCodeMode);
			}
		}

		ExportManager.switchToCodeMode=function(){
			if(Browser.window["changeLayaIDECodeMode"]){
				Browser.window["changeLayaIDECodeMode"]();
			}
		}

		ExportManager.getSkipRes=function(){
			return ExportManager.getRessStr(ResStyleManager.getPackFilesByType(2));
		}

		ExportManager.getWhitePackList=function(){
			return ExportManager.getRessStr(ResStyleManager.getPackFilesByType(1));
		}

		ExportManager.getRepeatList=function(){
			return ExportManager.getRessStr(ResStyleManager.getPicTypeFilesByType(1));
		}

		ExportManager.getRessStr=function(resList){
			var strs;
			strs=[];
			var i=0,len=0;
			var tPath;
			var addStrs=[];
			len=resList.length;
			for(i=0;i<len;i++){
				tPath=FileManager.getPath(SystemSetting.assetsPath,resList[i]);
				if(FileTools.exist(tPath)){
					strs.push(tPath);
				}
				CodeManager.getSkinSpecialRes(resList[i],addStrs);
			}
			len=addStrs.length;
			for(i=0;i<len;i++){
				tPath=FileManager.getPath(SystemSetting.assetsPath,addStrs[i]);
				if(FileTools.exist(tPath)){
					strs.push(tPath);
				}
			}
			return strs.join(",");
		}

		ExportManager.adptCallPath=function(filePath){
			if(!filePath)return filePath;
			var lastStr;
			lastStr=filePath.charAt(filePath.length-1);
			if(lastStr=="/"||lastStr=="\\"){
				return filePath.substr(0,filePath.length-1);
			}
			return filePath;
		}

		ExportManager.doExport=function(release){
			Waiting.show(Sys.lang("发布中，请稍等。。"),Sys.lang("发布代码"));
			Laya.timer.frameOnce(2,null,ExportManager.doExportLater,[release]);
		}

		ExportManager.getNewParamList=function(str){
			if(str=="")return [];
			return str.split(",");
		}

		ExportManager.exportCodeOnly=function(){
			Waiting.show(Sys.lang("发布中，请稍等。。"),Sys.lang("发布代码"));
			Laya.timer.once(500,this,ExportManager.doExportLater,[false,true,false]);
		}

		ExportManager.doExportLater=function(release,exportUICode,exportRes){
			(exportUICode===void 0)&& (exportUICode=true);
			(exportRes===void 0)&& (exportRes=true);
			if(exportUICode){
				ExportManager.exportUICodeWork();
			}
			if (exportRes){
				ExportManager.exportResWork(release);
			}
			if(!exportRes){
				ExportManager.packingEndHandler("export end");
			}
			ExportManager.configChanged=false;
		}

		ExportManager.exportUICodeWork=function(){
			FileManager.createDirectory(FileManager.getWorkPath(ProjectSetting.codeExportPath));
			CodeManager.exportCode();
		}

		ExportManager.exportResWork=function(release){
			var blackList=ExportManager.getSkipRes();
			var whilteList=ExportManager.getWhitePackList();
			var repeatList=ExportManager.getRepeatList();
			if(release)blackList=blackList.concat(ResManager.getUnUserdList());
			var allNotPacks;
			allNotPacks=ResFileManager.getAllUnPackLinkList(null);
			var notPackDirs;
			notPackDirs=ResStyleManager.getAllUnPackDir();
			allNotPacks=allNotPacks.concat(notPackDirs);
			var notPackFilePath;
			notPackFilePath=FileManager.getWorkPath(ExportManager.adptCallPath(ProjectSetting.asynResExportPath)+"/unpack.json");
			FileManager.createJSONFile(notPackFilePath,allNotPacks);
			var oldPathPackPath="libs/TP/TileAtlasPacker";
			var newPathPackPath="libs/TP/atlas-generator";
			if (SystemSetting.isCMDVer){
				oldPathPackPath=oldPathPackPath.replace("libs/","");
				newPathPackPath=newPathPackPath.replace("libs/","");
			};
			var cmd="\""+FileManager.getAppPath(oldPathPackPath)+"\""+
			" -maxAltasWidth="+ProjectSetting.textureWidth+" -maxAltasHeight="+ProjectSetting.textureHeight+
			" -tileWidthLimit="+ProjectSetting.picWidth+" -tileHeightLimit="+ProjectSetting.picHeight+
			" "+"\""+ExportManager.adptCallPath(SystemSetting.assetsPath)+"\""+
			" -outputDir="+"\""+ExportManager.adptCallPath(FileManager.getWorkPath(ProjectSetting.resExportPath))+"\"";
			if(ExportManager.clearRes){
				cmd+=" -force=true";
			}
			if(ProjectSetting.power2=="true"){
				cmd+=" -powerOfTwo=true";
			}
			if(ProjectSetting.trimempty=="true"){
				cmd+=" -trim=true";
				}else{
				cmd+=" -trim=false";
			}
			cmd+=" -htmlDir="+"\""+ExportManager.adptCallPath(FileManager.getWorkPath(ProjectSetting.asynResExportPath))+"\"";
			cmd+=" -blackList="+"\""+blackList+"\"";
			cmd+=" -inflateList="+"\""+repeatList+"\"";
			cmd+=" -includeList="+"\""+whilteList+"\"";
			var packFilePath=Paths.getPackParamFile();
			var packObj;
			packObj={};
			packObj["inputDir"]=ExportManager.adptCallPath(SystemSetting.assetsPath);
			packObj["outputDir"]=ExportManager.adptCallPath(FileManager.getWorkPath(ProjectSetting.resExportPath));
			packObj["resDir"]=ExportManager.adptCallPath(FileManager.getWorkPath(ProjectSetting.asynResExportPath));
			packObj["force"]=ExportManager.clearRes;
			packObj["includeList"]=ExportManager.getNewParamList(whilteList);
			packObj["excludeList"]=ExportManager.getNewParamList(blackList);
			packObj["extrudeList"]=ExportManager.getNewParamList(repeatList);
			if(ProjectSetting.copyRes!="true"){
				packObj["resDir"]="";
			};
			var atlas;
			atlas={};
			atlas["width"]=ProjectSetting.textureWidth;
			atlas["height"]=ProjectSetting.textureHeight;
			atlas["size"]=parseInt(ProjectSetting.textureWidth);
			atlas["quality"]=-1;
			atlas["pixelFormat"]=ProjectSetting.picType==0?"ARGB32":"Indexed8";
			atlas["powerOfTwo"]=ProjectSetting.power2=="true";
			console.log("picType:",ProjectSetting.picType);
			atlas["textureFormat"]="PNG";
			packObj["atlas"]=atlas;
			var dataParam;
			dataParam={};
			dataParam["format"]=ProjectSetting.atlasType==0?"json":"atlas";
			dataParam["compact"]=ProjectSetting.dataCompact=="true";
			packObj["data"]=dataParam;
			var spriteConfig;
			spriteConfig={};
			spriteConfig["width"]=ProjectSetting.picWidth;
			spriteConfig["height"]=ProjectSetting.picHeight;
			spriteConfig["size"]=parseInt(ProjectSetting.picWidth);
			spriteConfig["rotation"]=false;
			spriteConfig["extrude"]=1;
			spriteConfig["padding"]=1;
			spriteConfig["cropAlpha"]=ProjectSetting.trimempty=="true";
			packObj["sprite"]=spriteConfig;
			FileManager.createJSONFile(packFilePath,packObj);
			var option;
			option={encoding:"binary",maxBuffer:1024*1024*20};;
			var newCmd;
			newCmd="AtlasGenerator  "+"\""+ExportManager.adptCallPath(packFilePath)+"\"";
			newCmd="\""+FileManager.adptToCommonUrl(FileManager.getAppPath(newPathPackPath))+"\""+" "+"\""+ExportManager.adptCallPath(packFilePath)+"\"";
			newCmd="\""+FileManager.adptToCommonUrl(FileManager.getAppPath(newPathPackPath))+"\""+" "+"\""+FileManager.adptToCommonUrl(ExportManager.adptCallPath(packFilePath))+"\"";
			console.log("newCmd:",newCmd);
			cmd=newCmd;
			console.log("Waiting for pics packing");
			FileManager.createDirectory(FileManager.getWorkPath(ProjectSetting.resExportPath));
			CMDShell.execute(cmd,function(err,stdOut,stdErr){
				if (err){
					console.log("Error Occured: "+err);
				}
				else{
					console.log(stdErr);
				}
				if (SystemSetting.isCMDVer){
					console.log(stdOut);
				}
				ExportManager.packingEndHandler(err,stdOut,stdErr);
			},option);
			return true;
		}

		ExportManager.swfMap=null
		ExportManager.createSwfQueue=null
		ExportManager.fileUnUsed={};
		ExportManager.complete=null
		ExportManager.clearRes=false;
		ExportManager.configChanged=false;
		ExportManager.isCmdVer=false;
		ExportManager._packingEndHandler=null
		ExportManager.powerOfTwo=false;
		return ExportManager;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2017-5-15 下午2:55:06
	*/
	//class laya.editor.manager.IDESettingResTypeManager
	var IDESettingResTypeManager=(function(){
		function IDESettingResTypeManager(){}
		__class(IDESettingResTypeManager,'laya.editor.manager.IDESettingResTypeManager');
		IDESettingResTypeManager.getTypeRes=function(type){
			return IDESettingResTypeManager.typeDic[type];
		}

		IDESettingResTypeManager.getResType=function(res){
			return IDESettingResTypeManager.resTypeDic[res.toLocaleLowerCase()];
		}

		IDESettingResTypeManager.loadConfig=function(){
			var filePath;
			filePath=Paths.getResTypeConfigPath();
			if(FileManager.exists(filePath)){
				try{
					IDESettingResTypeManager.typeDic=FileManager.readJSONFile(filePath);
					}catch(e){
					IDESettingResTypeManager.typeDic={};
				}
				}else{
				IDESettingResTypeManager.typeDic={};
			}
			IDESettingResTypeManager.updateTypeDic();
		}

		IDESettingResTypeManager.updateTypeDic=function(){
			IDESettingResTypeManager.resTypeDic={};
			var key;
			var tV;
			for(key in IDESettingResTypeManager.typeDic){
				tV=IDESettingResTypeManager.typeDic[key];
				if(tV){
					IDESettingResTypeManager.resTypeDic[tV.toLocaleLowerCase()]=key;
				}
			}
		}

		IDESettingResTypeManager.saveConfig=function(){
			var filePath;
			filePath=Paths.getResTypeConfigPath();
			FileManager.createJSONFile(filePath,IDESettingResTypeManager.typeDic);
		}

		IDESettingResTypeManager.typeDic={};
		IDESettingResTypeManager.resTypeDic={};
		return IDESettingResTypeManager;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-12-25 上午10:19:18
	*/
	//class laya.editor.manager.LayerManager
	var LayerManager=(function(){
		function LayerManager(){}
		__class(LayerManager,'laya.editor.manager.LayerManager');
		LayerManager.init=function(){
			LayerManager.stage=new Box();
			LayerManager.stage.mouseEnabled=true;
			Laya.stage.addChild(LayerManager.stage);
			Laya.stage.on("resize",null,LayerManager.onStage);
		}

		LayerManager.onStage=function(){
			if (Browser.pixelRatio !=1){
				Laya.stage._width=Browser.clientWidth;
				Laya.stage._height=Browser.clientHeight;
				Laya.stage.scale(Browser.pixelRatio,Browser.pixelRatio);
			}
			LayerManager.stage.width=Laya.stage._width>900?Laya.stage._width:900;
			LayerManager.stage.height=Laya.stage._height>700?Laya.stage._height:700;
		}

		LayerManager.stage=null
		LayerManager.minWidth=900;
		LayerManager.minHeight=700;
		return LayerManager;
	})()


	/**页面管理器
	*@author yung
	*/
	//class laya.editor.manager.PageManager
	var PageManager=(function(){
		function PageManager(){}
		__class(PageManager,'laya.editor.manager.PageManager');
		PageManager.copyPageBg=function(pagePath,bgImgPath){
			if (!FileTools.exist(bgImgPath)){
				return bgImgPath;
			}
			if (Boolean(bgImgPath)){
				var file=new File(bgImgPath);
				if (file.exists){
					var f=FileTools.path.sep;
					var newPath=pagePath.replace("laya"+f+"pages"+f,"laya"+f+"views"+f).replace(".ui","."+file.extension);
					FileManager.copyFile(bgImgPath,newPath);
					return FileManager.getWorkRelativePath(newPath);
				}
			}
			return "";
		}

		PageManager.find=function(word){
			var pages=FileManager.getFileList(FileManager.getWorkPath("laya/pages/"));
			var arr=[];
			var a;
			for(var $each_a in pages){
				a=pages[$each_a];
				var path=a;
				if(FileTools.isDirectory(path))continue ;
				var txt=FileManager.readTxtFile(path);
				if(txt.indexOf(word)!=-1){
					arr.push({label:FileManager.getRelativePath(SystemSetting.pagesPath,path),path:path});
				}
			}
			return arr;
		}

		PageManager.replace=function(oldWord,newWord){
			Waiting.instance.start(Sys.lang("替换中,请等待。。"),Sys.lang("替换中"));
			var pages=FileManager.getFileList(FileManager.getWorkPath("laya/pages/"));
			pages=pages.concat(PreFabManager.getPrefabFiles());
			var arr=[];
			var a;
			for(var $each_a in pages){
				a=pages[$each_a];
				var path=a;
				if(FileTools.isDirectory(path))continue ;
				var uiViewer=UIPanel.instance.getUIViewer(path);
				oldWord.lastIndex=0;
				if (uiViewer){
					try{
						var txt=JsonTool.getJsonString(uiViewer.getDesignData());
						if(oldWord.test(txt)){
							txt=txt.replace(oldWord,newWord);
							uiViewer.changeDataO(ObjectTools$1.getObj(txt));
							arr.push(path);
						}
						}catch(e){
						Alert.show(Sys.lang("替换文件失败：{0}",path));
					}
					}else{
					txt=FileManager.readTxtFile(path);
					if(oldWord.test(txt)){
						txt=txt.replace(oldWord,newWord);
						FileManager.createTxtFile(path,txt);
						arr.push({label:FileManager.getRelativePath(SystemSetting.pagesPath,path),path:path});
					}
				}
			}
			Waiting.instance.close();
			return arr;
		}

		return PageManager;
	})()


	/**页面样式管理器
	*@author yung
	*/
	//class laya.editor.manager.PageStyleManager
	var PageStyleManager=(function(){
		function PageStyleManager(){};
		__class(PageStyleManager,'laya.editor.manager.PageStyleManager');
		PageStyleManager.init=function(){
			var txt=FileManager.readTxtFile(SystemSetting.pageStylePath);
			try {
				PageStyleManager.styleXML=new XMLElement(Boolean(txt)? txt :"<?xml version=\"1.0\" encoding=\"UTF-8\"?><page></page>");
				}catch (e){
				Alert.show(Sys.lang("PageStyleManager 读取文件{0}出错",SystemSetting.pageStylePath),Sys.lang("读取文件出错"));
			}
			if (PageStyleManager.styleXML){
				PageStyleManager.styleMap={};
				var list=PageStyleManager.styleXML.children();
				var item;
				for(var $each_item in list){
					item=list[$each_item];
					PageStyleManager.styleMap[String(item.getAttribute('name'))]=item;
				}
			}
		}

		PageStyleManager.getPageProps=function(name){
			if (PageStyleManager.styleMap&&PageStyleManager.styleMap[name]){
				return String(PageStyleManager.styleMap[name].getAttribute('props'));
			}
			return "";
		}

		PageStyleManager.getPageAName=function(name){
			if (PageStyleManager.styleMap&&PageStyleManager.styleMap[name]){
				var rst;
				rst=PageStyleManager.styleMap[name].getAttribute('aName');
				if(!rst)rst="";
				return rst;
			}
			return "";
		}

		PageStyleManager.getIfPageExport=function(name){
			var pagetype;
			pagetype=TypeManager.getFileType(name);
			if(pagetype=="Prefab"){
				return PageStyleManager.getPageExportType(name)==Sys.lang("导出");
				}else{
				return true;
			}
		}

		PageStyleManager.getPageExportType=function(name){
			var rst;
			if(PageStyleManager.styleMap&&PageStyleManager.styleMap[name]){
				rst=PageStyleManager.styleMap[name].getAttribute('ifExport');
			}
			if(!rst)rst=Sys.lang("默认");
			if(PageExportType.isOKType(rst)){
				return rst;
			}
			return Sys.lang("默认");
		}

		PageStyleManager.getPageFinalExportType=function(name){
			var type;
			type=PageStyleManager.getPageExportType(name);
			if(type!=Sys.lang("默认"))return type;
			return PageStyleManager.getProjectExportType();
		}

		PageStyleManager.getProjectExportType=function(){
			var id=0;
			id=Math.ceil(ProjectSetting.uiType);
			if(id>=0&&id<=2){
				return PageExportType.typeList[id];
			}
			return PageExportType.INCODE;
		}

		PageStyleManager.updatePageStyle=function(name,props,ifExport,aName){
			(aName===void 0)&& (aName="");
			if(!ifExport){
				ifExport="默认";
			}
			ifExport=Sys.lang(ifExport);
			props=ResStyleManager.getPropStrByArr(props.split("\n"));
			if (PageStyleManager.styleMap&&PageStyleManager.styleMap[name]){
				PageStyleManager.styleMap[name].setAttribute('props',props);
				PageStyleManager.styleMap[name].setAttribute('ifExport',ifExport);
				PageStyleManager.styleMap[name].setAttribute('aName',aName);
				}else {
				var xml=new XMLElement("<item name=\""+name+"\"/>");
				xml.setAttribute('props',props);
				PageStyleManager.styleXML.appendChild(xml);
				PageStyleManager.styleMap[name]=xml;
				PageStyleManager.styleMap[name].setAttribute('ifExport',ifExport);
				PageStyleManager.styleMap[name].setAttribute('aName',aName);
			}
			FileManager.createTxtFile(SystemSetting.pageStylePath,PageStyleManager.styleXML.toString());
		}

		PageStyleManager.styleXML=null
		PageStyleManager.styleMap=null
		return PageStyleManager;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-9-1 上午10:09:44
	*/
	//class laya.editor.manager.PreFabManager
	var PreFabManager=(function(){
		function PreFabManager(){
			this.preFabDic={};
		}

		__class(PreFabManager,'laya.editor.manager.PreFabManager');
		var __proto=PreFabManager.prototype;
		__proto.getPreFabData=function(preFabPath){
			var filePath;
			filePath=FileManager.getWorkPath(preFabPath);
			if(!FileTools.exist(filePath))return null;
			var rst;
			try{
				rst=FileManager.readJSONFile(filePath);
				this.preFabDic[preFabPath]=TreeDataTool.buildNode(rst,null,"presetID",true);
			}catch(e){}
			return rst;
		}

		__proto.cleanPrefabCache=function(){
			var key;
			for(key in this.preFabDic){
				delete this.preFabDic[key];
			}
		}

		__proto.prefabFileChange=function(path){
			var rPath;
			rPath=FileManager.getWorkRelativePath(path);
			if(this.preFabDic[rPath]){
				this.preFabDic[rPath]=null;
				Notice.notify("FRESH_Page",[false]);
			}
		}

		__proto.getPreFabProps=function(preFabPath,preSetID){
			if(!preFabPath||!preSetID)return null;
			var filePath;
			filePath=FileManager.getWorkPath(preFabPath);
			if(!FileTools.exist(filePath))return null;
			if(this.preFabDic[preFabPath])return this.preFabDic[preFabPath][preSetID];
			var data;
			data=this.getPreFabData(preFabPath);
			if(this.preFabDic[preFabPath])return this.preFabDic[preFabPath][preSetID];
			return null;
		}

		__proto.clearPreFabProps=function(node){
			TreeDataTool.deleteNodePropKeyBut(node,PreFabManager.reserveKeys,false);
		}

		__proto.convertDataToPreFabUI=function(data,dir){
			var savePath;
			savePath=this.findOkFileName(data.type,dir,TypeManager.getExtension("page"));
			var preSetSign;
			preSetSign=FileManager.getWorkRelativePath(savePath);
			var saveO;
			saveO=ObjectTools$1.copyObj(data);
			if(!saveO.props)saveO.props={};
			saveO.props.x=0;
			saveO.props.y=0;
			TreeDataTool.deleteNodeKey(saveO,"compId");
			var prefabO;
			if(PreFabManager.PrefabHasWrap){
				prefabO={};
				prefabO.type="View";
				prefabO.child=[saveO];
				prefabO.props={};
				prefabO.props.width=300;
				prefabO.props.height=300;
				prefabO.props.sceneColor="#000000";
				}else{
				prefabO=saveO;
			}
			FileManager.createJSONFile(savePath,prefabO);
		}

		__proto.convertDataToPreFab=function(data,dir){
			var savePath;
			savePath=this.findOkFileName(data.type,dir);
			var preSetSign;
			preSetSign=FileManager.getWorkRelativePath(savePath);
			if(preSetSign!=data.props["preset"]){
				TreeDataTool.changeNodeKey(data,"preset","presetPre");
				TreeDataTool.changeNodeKey(data,"presetID","presetIDPre");
			}
			TreeDataTool.setNodeKey(data,"preset",preSetSign);
			TreeDataTool.resetNodeID(data,"presetID",1);
			var saveO;
			saveO=ObjectTools$1.copyObj(data);
			if(!saveO.props)saveO.props={};
			saveO.props.x=0;
			saveO.props.y=0;
			TreeDataTool.deleteNodeKey(saveO,"compId");
			var prefabO;
			if(PreFabManager.PrefabHasWrap){
				prefabO={};
				prefabO.type="View";
				prefabO.child=[saveO];
				prefabO.props={};
				prefabO.props.width=300;
				prefabO.props.height=300;
				prefabO.props.sceneColor="#000000";
				}else{
				prefabO=saveO;
			};
			var preX=0,preY=0;
			preX=data.props.x;
			preY=data.props.y;
			TreeDataTool.deleteAllKeyBut(data,PreFabManager.reserveKeysS);
			if(preX){
				data.props.x=preX;
			}
			if(preY){
				data.props.y=preY;
			}
			FileManager.createJSONFile(savePath,prefabO);
			Notice.notify("Prop_Changed");
		}

		__proto.isNodeHasPreFab=function(node){
			if(!node)return false;
			var props;
			props=node.props;
			if(!props)return false;
			if(!props["preset"]||!props["presetID"])return false;
			return true;
		}

		__proto.cutOffNodePrefab=function(node,preset){
			if(!this.isNodeHasPreFab(node))return;
			var props;
			props=node.props;
			if(!props)return;
			preset=props["preset"];
			if(preset&&(preset!=props["preset"]))return;
			this.insertPrefabToProps(node);
			delete props["preset"];
			delete props["presetID"];
			delete props["presetPre"];
			delete props["presetIDPre"];
		}

		__proto.cutOffNodeTreePrefab=function(node,preset){
			if(!this.isNodeHasPreFab(node))return;
			var props;
			props=node.props;
			if(!props["preset"]||!props["presetID"])return;
			if(preset&&(preset!=props["preset"]))return;
			preset=props["preset"];
			this.cutOffNodePrefab(node,preset);
			var childs;
			childs=node.child;
			if(!childs)return;
			var i=0,len=0;
			len=childs.length;
			for(i=0;i<len;i++){
				this.cutOffNodeTreePrefab(childs[i],preset);
			}
		}

		__proto.getPreFabPreByNode=function(node){
			if(!node)return null;
			var props;
			props=node.props;
			if(!props)return null;
			var preData;
			preData=this.getPreFabProps(props["preset"],props["presetID"]);
			if(!preData)return null;
			var rst;
			rst={};
			props=preData.props;
			var prepreData;
			if(props){
				prepreData=this.getPreFabPreByNode(this.getPreFabProps(props["presetPre"],props["presetIDPre"]));
				if(prepreData&&prepreData.props){
					PreFabManager.insertValues(PreFabManager.mMask,prepreData.props,rst);
				}
			}
			if(preData&&preData.props){
				PreFabManager.insertValues(PreFabManager.mMask,preData.props,rst);
			};
			var rstNode;
			rstNode={};
			rstNode.props=rst;
			return rstNode;
		}

		__proto.getPreFabByNode=function(node){
			return this.getPreFabPreByNode(node);
			var props;
			props=node.props;
			if(!props)return null;
			var preFabProps;
			preFabProps=this.getPreFabProps(props["preset"],props["presetID"]);
			return preFabProps;
		}

		__proto.getPreFabUIPropByNode=function(node){
			if(!TypeManager.isPrefabUINode(node))return null;
			var source=node.source;
			var sourcePath;
			var xml;
			try{
				sourcePath=FileManager.getPath(SystemSetting.pagesPath,source.replace(".xml","."+TypeManager.getExtension("page")));
				xml=FileManager.readJSONFile(sourcePath);
				if(PreFabManager.PrefabHasWrap)return xml.child[0];
				return xml;
				return xml.child[0];
				}catch(e){
			};
			return null;
		}

		// }
		__proto.getPrefabUIPropByKey=function(node,key){
			var propNode;
			propNode=this.getPreFabUIPropByNode(node);
			if(!propNode)return null;
			return propNode.props[key];
		}

		__proto.getPreFabPropByKey=function(node,key){
			var preFabProps;
			preFabProps=this.getPreFabByNode(node);
			if(!preFabProps||!preFabProps.props)return null;
			return preFabProps.props[key];
		}

		__proto.insertPrefabVar=function(data,comp){
			var props;
			props=data.props;
			if(!props)return;
			var preFabProps;
			preFabProps=this.getPreFabByNode(data);
			if(!preFabProps||!preFabProps.props)return;
			preFabProps=preFabProps.props;
			PreFabManager.insertValues(props,preFabProps,comp);
		}

		// }
		__proto.insertPrefabToProps=function(node){
			var props;
			props=node.props;
			if(!props)return;
			var preFabProps;
			preFabProps=this.getPreFabByNode(node);
			if(!preFabProps||!preFabProps.props)return;
			preFabProps=preFabProps.props;
			PreFabManager.insertValues(props,preFabProps,props);
		}

		__proto.findOkFileName=function(preSign,dir,fileSign){
			(fileSign===void 0)&& (fileSign="prefab");
			var pDir;
			pDir=dir;
			var id=1;
			var tPath
			while(true){
				tPath=FileManager.getPath(pDir,preSign+""+id+"."+fileSign);
				if(!FileTools.exist(tPath)){
					break ;
				}
				id++;
			}
			return tPath;
		}

		PreFabManager.insertValues=function(oData,insertData,tar){
			var key;
			for(key in insertData){
				if(!oData.hasOwnProperty(key)){
					tar[key]=insertData[key];
				}
			}
		}

		PreFabManager.getPrefabFiles=function(){
			var pages=FileManager.getFileList(SystemSetting.assetsPath);
			var rst;
			rst=[];
			var i=0,len=0;
			len=pages.length;
			for(i=0;i<len;i++){
				if(TypeManager.getFileType(pages[i])=="Prefab"){
					rst.push(pages[i]);
				}
			}
			return rst;
		}

		PreFabManager.PrefabHasWrap=false;
		PreFabManager.mMask={};
		__static(PreFabManager,
		['I',function(){return this.I=new PreFabManager();},'reserveKeys',function(){return this.reserveKeys={
				"preset":true,
				"presetID":true
				};},'reserveKeysS',function(){return this.reserveKeysS={
				"preset":true,
				"presetID":true,
				"presetPre":true,
				"presetIDPre":true
		};}

		]);
		return PreFabManager;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-1-20 下午5:52:11
	*/
	//class laya.editor.manager.ProjectConvertManager
	var ProjectConvertManager=(function(){
		function ProjectConvertManager(){}
		__class(ProjectConvertManager,'laya.editor.manager.ProjectConvertManager');
		ProjectConvertManager.convertProject=function(oPath,tarPath){
			var oBasePath;
			oBasePath=FileTools.getFileDir(oPath);
			ProjectConvertManager.parseConvertConfig(FileTools.getPath(oBasePath,"convert.cfg"));
			var relativePath;
			relativePath=FileManager.getRelativePath(oBasePath,oPath);
			var tarProjectFile;
			tarProjectFile=FileManager.getPath(tarPath,"laya/.laya");
			FileManager.copyFile(oPath,tarProjectFile);
			var pagesFolder;
			pagesFolder=FileManager.getPath(oBasePath,"morn/pages");
			var tFile;
			tFile=FileManager.getPath(oBasePath,"morn/assets");
			ProjectConvertManager.copyFileToTarFolder(tFile,oBasePath,tarPath);
			tFile=FileManager.getPath(oBasePath,"morn/styles.xml");
			ProjectConvertManager.copyFileToTarFolder(tFile,oBasePath,tarPath,true);
			tFile=FileManager.getPath(oBasePath,"morn/pageStyles.xml");
			ProjectConvertManager.copyFileToTarFolder(tFile,oBasePath,tarPath,true);
			ProjectConvertManager.createByDir(pagesFolder,oBasePath,tarPath);
			MessageManager.instance.show(Sys.lang("转换成功"));
		}

		ProjectConvertManager.parseConvertConfig=function(configPath){
			ProjectConvertManager.adptSizeGrid=true;
			var configStr;
			configStr=FileTools.readFile(configPath);
			if(!configStr)return;
			var configs;
			configs=configStr.split("\n");
			var i=0,len=0;
			len=configs.length;
			var tLine;
			var configO={};
			var param;
			for(i=0;i<len;i++){
				tLine=StringTool$1.trimSide(configs[i]);
				if(tLine.indexOf("=")>0){
					param=tLine.split("=");
					configO[param[0]]=param[1];
				}
			}
			if(configO.hasOwnProperty("sizeGrid")){
				ProjectConvertManager.adptSizeGrid=!(configO["sizeGrid"]=="false");
			}
		}

		ProjectConvertManager.getNewProjectRelativePath=function(path){
			return path.replace("morn","laya");
		}

		ProjectConvertManager.copyFileToTarFolder=function(file,oBase,tarFolder,adpt){
			(adpt===void 0)&& (adpt=false);
			if(!FileTools.exist(file))return;
			var tarFilePath;
			var tarFolderS;
			tarFolderS=ProjectConvertManager.getNewProjectRelativePath(FileManager.getRelativePath(oBase,file));
			tarFilePath=FileManager.getPath(tarFolder,tarFolderS);
			FileManager.copyFile(file,tarFilePath);
			if(adpt){
				ProjectConvertManager.adaptStyleXML(tarFilePath);
			}
		}

		ProjectConvertManager.adptXmlProps=function(str){
			if(StringTool$1.trimSide(str)=="")return str;
			var obj;
			obj=ResStyleManager.getResPropsObjByPropStr(str,"\n");
			ProjectConvertManager.adptObj(obj);
			str=ResStyleManager.getResPropStrByObj(obj," ");
			return str;
		}

		ProjectConvertManager.adaptStyleXML=function(path){
			var str;
			str=FileManager.readTxtFile(path);
			var styleXML;
			try {
				styleXML=new XMLElement(str);
			}catch (e){}
			if (styleXML){
				var list=styleXML.children();
				var item;
				for(var $each_item in list){
					item=list[$each_item];
					item.setAttribute('name',ProjectConvertManager.getAdptSkin(item.getAttribute('name')));
					if(item.getAttribute('props')){
						item.setAttribute('props',ProjectConvertManager.adptXmlProps(item.getAttribute('props')));
					}
				}
			}
			FileManager.createTxtFile(path,styleXML.toString());
			return;
			var arr;
			arr=str.split("\"");
			var i=0,len=0;
			len=arr.length;
			for(i=0;i<len;i++){
				arr[i]=ProjectConvertManager.getAdptSkin(arr[i]);
			}
			FileManager.createTxtFile(path,arr.join("\""));
		}

		ProjectConvertManager.createByDir=function(file,basePath,tarPath){
			var fileList;
			fileList=FileTools.getFileList(file);
			var i=0,len=0;
			len=fileList.length;
			var tFile;
			var code;
			var obj;
			var codePath;
			for(i=0;i<len;i++){
				tFile=fileList[i];
				if(FileTools.isDirectory(tFile)){
					}else{
					if(FileTools.getExtensionName(tFile)==ProjectConvertManager.oldUIExtension){
						code=FileManager.readTxtFile(tFile);
						var uiObj;
						try{
							uiObj=DesignInfo.xmlStrToUIObj(code);
							ProjectConvertManager.adptObj(uiObj);
							var tarFilePath;
							tarFilePath=FileManager.getPath(tarPath,ProjectConvertManager.getNewProjectRelativePath(FileManager.getRelativePath(basePath,tFile)));
							tarFilePath=tarFilePath.replace("."+ProjectConvertManager.oldUIExtension,"."+TypeManager.getExtension("page"));
							FileManager.createJSONFile(tarFilePath,uiObj);
							}catch(e){
							Alert.show(Sys.lang("转换文件失败：\n{0}",tFile));
						}
					}
				}
			}
		}

		ProjectConvertManager.getAdptSizeGrid=function(sizeGridStr){
			if(!ProjectConvertManager.adptSizeGrid)return sizeGridStr;
			sizeGridStr=sizeGridStr+"";
			var arr;
			arr=sizeGridStr.split(",");
			arr.push(arr.shift());
			return arr.join(",");
		}

		ProjectConvertManager.adptObj=function(obj){
			ProjectConvertManager.adptType(obj);
			var key;
			if(obj.hasOwnProperty("scale")){
				obj["scaleX"]=obj["scaleY"]=obj["scale"];
				delete obj["scale"];
			}
			if(obj.hasOwnProperty("compId")){
				delete obj["compId"];
			}
			if(obj.hasOwnProperty("sizeGrid")){
				obj["sizeGrid"]=ProjectConvertManager.getAdptSizeGrid(obj["sizeGrid"]);
			}
			for(key in obj){
				if(obj[key]==0&&key.toLocaleLowerCase().indexOf("color")>=0){
					obj[key]="0x000000";
				}
				if((typeof (obj[key])=='string')){
					var tStr;
					tStr=obj[key];
					if(tStr.indexOf("0x")>=0){
						tStr=StringTool$1.getReplace(tStr,"0x","#");
						obj[key]=tStr;
					}
					if(key=="skin"||1){
						obj[key]=ProjectConvertManager.getAdptSkin(tStr);
					}
				}else
				if((typeof (obj[key])=='object')){
					ProjectConvertManager.adptObj(obj[key]);
				}
			}
		}

		ProjectConvertManager.adptType=function(obj){
			if(obj.type=="Label"&&obj.props){
				var prop;
				prop=obj.props;
				if(prop.size){
					prop.fontSize=prop.size;
					delete prop["size"];
				}
			}
			if(ProjectConvertManager.typeConvertO[obj.type]){
				obj.type=ProjectConvertManager.typeConvertO[obj.type];
			}
			if(obj.url&&!obj.skin){
				obj.skin=obj.url;
			}
		}

		ProjectConvertManager.getAdptSkin=function(skin){
			var rst;
			if(skin.indexOf(".")<0)return skin;
			if(skin.indexOf("png.")<0&&skin.indexOf("jpg.")<0)return skin;
			var arr;
			arr=skin.split(".");
			if(arr.length<3)return skin;
			var extension;
			extension=arr.shift();
			rst=arr.join("/")+"."+extension;
			return rst;
		}

		ProjectConvertManager.oldUIExtension="xml";
		ProjectConvertManager.adptSizeGrid=true;
		__static(ProjectConvertManager,
		['typeConvertO',function(){return this.typeConvertO={
				"LinkButton":"Button",
				"Container":"Box",
				"FrameClip":"Box",
				"RadioButton":"Radio"
		};}

		]);
		return ProjectConvertManager;
	})()


	//class laya.editor.manager.ProjectManager
	var ProjectManager=(function(){
		function ProjectManager(){};
		__class(ProjectManager,'laya.editor.manager.ProjectManager');
		ProjectManager.loadProject=function(path,complete,fromCMD){
			(fromCMD===void 0)&& (fromCMD=false);
			console.log("loadProject:",path);
			if (Boolean(path)){
				if (ProjectManager.lastProjectPath !=path){
					ProjectManager.lastProjectPath=path;
					if (FileTools.exist(path)){
						ResManager.clear();
						SystemSetting.setProject(path);
						ProjectSetting.asynResExportPath="";
						ProjectManager.xml=new XMLElement(FileManager.readTxtFile(path,true));
						var list=ProjectManager.xml.children();
						ProjectSetting.disableBinaryPic=0;
						var child;
						for(var $each_child in list){
							child=list[$each_child];
							var name=child.name();
							if (ProjectSetting[name] !=null){
								ProjectSetting[name]=((ProjectSetting[name])instanceof Array)? StringTool$1.trimSide(String(child)).split(","):String(child);
								if(ProjectSetting[name].replace)
									ProjectSetting[name]=ProjectSetting[name].replace(/\\/g,FileTools.path.sep);
							}
						}
						if(ProjectSetting.disableBinaryPic==1){
							ResFileManager.enableBinaryPic=false;
							}else{
							ResFileManager.enableBinaryPic=true;
						}
						ProjectSetting.adptPaths();
						if (fromCMD)return;
						ProjectManager.refreshProject(complete);
						ProjectManager.addProjectOpened(path);
						RenderManager.I.setRenderPropByFont(ProjectSetting.defaultFont);
						LanguageManager.loadProjectLanguageFile();
						RenderManager.I.loadProjectCustomUIConfig();
					}
					else{
						Alert.show(Sys.lang("项目不存在"));
						ProjectManager.lastProjectPath="";
						ProjectManager.removeProjectOpened(path);
					}
				}
				return;
			}
			if (complete !=null){
				complete.run();
			}
		}

		ProjectManager.refreshProject=function(complete){
			ResStyleManager.init();
			PageStyleManager.init();
			PagePanel.instance.init(SystemSetting.pagesPath);
			ResPanel.instance.init(SystemSetting.assetsPath,complete);
		}

		ProjectManager.saveProject=function(){
			ProjectSetting.adptPaths();
			var i=0,len=0;
			var tKey;
			len=ProjectManager.keys.length;
			var tXml;
			for(i=0;i<len;i++){
				tKey=ProjectManager.keys[i];
				tXml=new XMLElement();
				tXml.setName(tKey);
				if(ProjectManager.SpecialXmlKeys[tKey]){
					tXml.value="<![CDATA["+ProjectSetting[tKey]+"]]>";
					}else{
					tXml.value=ProjectSetting[tKey];
				}
				ProjectManager.xml.setChildByName(tKey,tXml);
			}
			tXml=new XMLElement();
			tXml.setName("ver");
			tXml.value="0.9.9 beta";
			ProjectManager.xml.setChildByName("ver",tXml);
			FileManager.createTxtFile(SystemSetting.projectPath,ProjectManager.xml.toString());
		}

		ProjectManager.openProject=function(){
			DialogTools.showOpenFile(Sys.lang("打开项目"),ProjectManager.onFileSelect,DialogTools.getOpenProO());
		}

		ProjectManager.onFileSelect=function(files){
			if (!files || !files[0])
				return;
			ProjectManager.openProjectByPath(files[0]);
		}

		ProjectManager.openProjectDir=function(){
			if (Boolean(SystemSetting.workPath)){
				var file=new File(SystemSetting.workPath);
				if (file.exists){
					FileTools.openItem(SystemSetting.workPath);
				}
			}
		}

		ProjectManager.openProjectByPath=function(path){
			Dialog.manager.closeAll();
			UIPanel.instance.closeAll(ProjectManager.loadProject,[path]);
		}

		ProjectManager.setProjectOpened=function(projects){
			ProjectManager.projectOpened.length=0;
			if (!projects)return;
			var len=projects.length;
			for (var i=0;i < len;i++){
				ProjectManager.projectOpened.push(projects[i]);
			}
			MenuBar.instance.showProjectOpened(ProjectManager.projectOpened);
		}

		ProjectManager.addProjectOpened=function(path){
			var index=ProjectManager.projectOpened.indexOf(path);
			if (index !=-1){
				ProjectManager.projectOpened.splice(index,1);
			}
			ProjectManager.projectOpened.splice(0,0,path);
			MenuBar.instance.showProjectOpened(ProjectManager.projectOpened);
		}

		ProjectManager.removeProjectOpened=function(path){
			var index=ProjectManager.projectOpened.indexOf(path);
			if (index !=-1){
				ProjectManager.projectOpened.splice(index,1);
				MenuBar.instance.showProjectOpened(ProjectManager.projectOpened);
			}
		}

		ProjectManager.xml=null
		ProjectManager.lastProjectPath=null
		ProjectManager.projectOpened=[];
		__static(ProjectManager,
		['keys',function(){return this.keys=
			[
			"resTypes",
			"resExportPath",
			"asynResExportPath",
			"resCanCompress",
			"resPublishQuality",
			"codeExportPath",
			"uiType",
			"codeType",
			"picType",
			"atlasType",
			"defaultFont",
			"uiExportPath",
			"boxTypes",
			"pageTypes",
			"pageTypes",
			"codeImports",
			"codeImportsJS",
			"codeImportsTS",
			"shareResPath",
			"langPath",
			"textureWidth",
			"textureHeight",
			"picWidth",
			"picHeight",
			"power2",
			"copyRes",
			"dataCompact",
			"trimempty"];},'SpecialXmlKeys',function(){return this.SpecialXmlKeys={
				"codeImports":true,
				"codeImportsJS":true,
				"codeImportsTS":true
		};}

		]);
		return ProjectManager;
	})()


	/**资源管理器
	*@author yung
	*/
	//class laya.editor.manager.ResManager
	var ResManager=(function(){
		function ResManager(){};
		__class(ResManager,'laya.editor.manager.ResManager');
		ResManager.refresh=function(complete){
			ResManager._complete=complete;
			ResManager._reses=[];
		}

		ResManager.clear=function(){
			ResManager._resVerMap={};
		}

		ResManager.removeRes=function(path){
			FileManager.removeFile(path);
			ResFileManager.clearRes(path);
		}

		ResManager.getResLinkName=function(f){
			var rootPath=SystemSetting.assetsPath;
			if (Boolean(ProjectSetting.shareResPath)){
				var sharePath=FileManager.getWorkPath(ProjectSetting.shareResPath);
				if (f.indexOf(sharePath)>-1){
					rootPath=sharePath;
				}
			}
			if(TypeManager.getFileType(f)=="Prefab"){
				rootPath=SystemSetting.workPath;
			}
			return FileManager.getRelativePath(rootPath,f).toString();
		}

		ResManager.findUnUsed=function(){
			var reses;
			reses=ResFileManager.getAllResLinkList();
			var pages=FileManager.getFileList(FileManager.getWorkPath("laya/pages/"));
			var i=0,len=0;
			var a;
			for(var $each_a in pages){
				a=pages[$each_a];
				var path=a;
				if(FileTools.isDirectory(path))continue ;
				var txt=FileManager.readTxtFile(path);
				for (i=reses.length-1;i >-1;i--){
					var item=reses[i];
					if(item.indexOf("@")>=0||item.indexOf("$")>=0){
						reses.splice(i,1);
						continue ;
					}
					if (txt.indexOf("\""+item+"\"")!=-1){
						reses.splice(i,1);
					}
				}
			};
			var rst;
			rst=[];
			len=reses.length;
			for(i=0;i<len;i++){
				rst.push({label:reses[i],path:FileManager.getResPath(reses[i])});
			}
			return rst;
		}

		ResManager.getUnUserdList=function(){
			var reses;
			reses=ResFileManager.getAllResLinkList();
			var pages=FileManager.getFileList(FileManager.getWorkPath("laya/pages/"));
			var i=0,len=0;
			var a;
			for(var $each_a in pages){
				a=pages[$each_a];
				var path=a;
				if(FileTools.isDirectory(path))continue ;
				var txt=FileManager.readTxtFile(path);
				for (i=reses.length-1;i >-1;i--){
					var item=reses[i];
					if(item.indexOf("@")>=0||item.indexOf("$")>=0){
						reses.splice(i,1);
						continue ;
					}
					if (txt.indexOf("\""+item+"\"")!=-1){
						reses.splice(i,1);
					}
				}
			}
			return reses;
		}

		ResManager.findResRefer=function(res){
			var pages=FileManager.getFileList(FileManager.getWorkPath("laya/pages/"));
			var i=0,len=0;
			var rst;
			rst=[];
			var a;
			for(var $each_a in pages){
				a=pages[$each_a];
				var path=a;
				if(FileTools.isDirectory(path))continue ;
				var txt=FileManager.readTxtFile(path);
				var item=res;
				if (txt.indexOf("\""+item+"\"")!=-1){
					rst.push({label:FileManager.getRelativePath(SystemSetting.pagesPath,path),path:path});
				}
			}
			return rst;
		}

		ResManager.findFileUnUsed=function(){
			var objs={};
			var arr=ResManager.findUnUsed();
			var obj;
			for(var $each_obj in arr){
				obj=arr[$each_obj];
				objs[obj.path]=1;
			}
			return objs;
		}

		ResManager._resVerMap={};
		ResManager._resNeedLoaded=null
		ResManager._complete=null
		ResManager._reses=null
		ResManager.timer=0;
		return ResManager;
	})()


	/**资源样式管理器
	*@author yung
	*/
	//class laya.editor.manager.ResStyleManager
	var ResStyleManager=(function(){
		function ResStyleManager(){};
		__class(ResStyleManager,'laya.editor.manager.ResStyleManager');
		ResStyleManager.init=function(){
			var txt=FileManager.readTxtFile(SystemSetting.stylePath);
			try {
				ResStyleManager.styleXML=new XMLElement(Boolean(txt)?txt:"<?xml version=\"1.0\" encoding=\"UTF-8\"?><res></res>");
				}catch (e){
				Alert.show(Sys.lang("ResStyleManager 读取文件{0}出错",SystemSetting.stylePath),Sys.lang("读取文件出错"));
			}
			if (ResStyleManager.styleXML){
				ResStyleManager.styleMap={};
				var list=ResStyleManager.styleXML.children();
				var item;
				for(var $each_item in list){
					item=list[$each_item];
					ResStyleManager.styleMap[String(item.getAttribute('name'))]=item;
				}
			}
		}

		ResStyleManager.getResProps=function(asset){
			if(ResStyleManager.styleMap&&ResStyleManager.styleMap[asset]){
				return String(ResStyleManager.styleMap[asset].getAttribute('props'));
			}
			return "";
		}

		ResStyleManager.getPropArr=function(asset){
			return ResStyleManager.getPropArrByPropStr(ResStyleManager.getResProps(asset));
		}

		ResStyleManager.getPropStrByArr=function(arr){
			return arr.join("@@!@@");
			return arr.join(" ");
		}

		ResStyleManager.renameRes=function(asset,newAsset){
			if(ResStyleManager.styleMap[asset]){
				ResStyleManager.styleMap[asset].setAttribute('name',newAsset);
				ResStyleManager.styleMap[newAsset]=ResStyleManager.styleMap[asset];
				delete ResStyleManager.styleMap[asset];
				FileManager.createTxtFile(SystemSetting.stylePath,ResStyleManager.styleXML.toString());
			}
		}

		ResStyleManager.getPropArrByPropStr=function(propStr){
			if(propStr.indexOf("@@!@@")>=0){
				return propStr.split("@@!@@");
			}
			return propStr.split(" ");
		}

		ResStyleManager.getResIfPack=function(asset){
			if(ResStyleManager.styleMap&&ResStyleManager.styleMap[asset]){
				if(ResStyleManager.styleMap[asset].getAttribute('pack')===false)return false;
				return true;
				return ObjectTools$1.getStrTypedValue(ResStyleManager.styleMap[asset].getAttribute('pack'));
			}
			return true;
		}

		ResStyleManager.getResPicType=function(asset){
			if(ResStyleManager.styleMap&&ResStyleManager.styleMap[asset]){
				var v=0;
				v=ResStyleManager.styleMap[asset].getAttribute('picType');
				if(v==1)return 1;
				return 0;
			}
			return 0;
		}

		ResStyleManager.getResPackType=function(asset){
			if(ResStyleManager.styleMap&&ResStyleManager.styleMap[asset]){
				if(ResStyleManager.styleMap[asset].getAttribute('pack')===false)return 2;
				if(ResStyleManager.styleMap[asset].getAttribute('pack')===true)return 0;
				return LayaBuilder.mParseInt(ResStyleManager.styleMap[asset].getAttribute('pack'));
			}
			return 0;
		}

		ResStyleManager.getAllUnPackDir=function(rst){
			if(!rst)rst=[];
			if(!ResStyleManager.styleMap)return rst;
			var asset;
			for(asset in ResStyleManager.styleMap){
				if(asset.indexOf(".")<=0){
					if(ResStyleManager.getFinalPackResult(asset,true)){
						}else{
						rst.push(asset);
					}
				}
			}
			return rst;
		}

		ResStyleManager.getFinalPackResult=function(asset,otherResult){
			var type=0;
			type=ResStyleManager.getResPackType(asset);
			switch(type){
				case 0:
					return otherResult;
					break ;
				case 1:
					return true;
					break ;
				case 2:
					return false;
					break ;
				}
			return true;
		}

		ResStyleManager.getResPropsObj=function(asset){
			var propStr;
			propStr=ResStyleManager.getResProps(asset);
			var rst;
			rst={};
			if(propStr.indexOf("=")>=0){
				var props;
				props=ResStyleManager.getPropArrByPropStr(propStr);
				for (var i=0,n=props.length;i < n;i++){
					var a=props[i].split("=");
					if (a.length==2){
						var key=a[0];
						var val=a[1];
						rst[key]=val;
					}
				}
			}
			return rst;
		}

		ResStyleManager.getResPropsKeyValue=function(asset,key){
			return ResStyleManager.getResPropsObj(asset)[key];
		}

		ResStyleManager.getResPropsKeyByNode=function(node,key){
			var skinLabel=UIConfigManager.getCompSkinLabel(node.type);
			var skin;
			skin=node.props[skinLabel];
			if (skin){
				return ResStyleManager.getResPropsKeyValue(skin,key);
			}
			return null;
		}

		ResStyleManager.getResPropsObjByPropStr=function(propStr,split){
			(split===void 0)&& (split=" ");
			var rst;
			rst={};
			if(propStr.indexOf("=")>=0){
				var props;
				props=propStr.split(split);
				for (var i=0,n=props.length;i < n;i++){
					var a=props[i].split("=");
					if (a.length==2){
						var key=a[0];
						var val=a[1];
						rst[key]=val;
					}
				}
			}
			return rst;
		}

		ResStyleManager.getResPropStrByObj=function(propObj,split){
			(split===void 0)&& (split=" ");
			var rstArr;
			var key;
			rstArr=[];
			for(key in propObj){
				rstArr.push(key+"="+propObj[key]);
			}
			return rstArr.join(split);
		}

		ResStyleManager.getResCompType=function(asset,isIcon,ignoreIDESetting){
			(isIcon===void 0)&& (isIcon=false);
			(ignoreIDESetting===void 0)&& (ignoreIDESetting=false);
			if (!asset){
				return "Image";
			};
			var resPath;
			resPath=FileManager.adptToCommonUrl(asset);
			if (ResStyleManager.styleMap&&ResStyleManager.styleMap[resPath]){
				var compType=String(ResStyleManager.styleMap[resPath].getAttribute('type'));
			}
			if (!Boolean(compType)){
				var extension=FileTools.getExtensionName(asset);
				compType=UIConfigManager.getCompTypeByExtension(extension);
				if(compType)return compType;
				var fileName=FileTools.getFileName(asset);
				var res=fileName.split("_")[0];
				compType=UIConfigManager.getCompTypeByResName(res,isIcon,ignoreIDESetting);
			}
			return compType || "Image";
		}

		ResStyleManager.getResCanCompress=function(asset){
			if(ResStyleManager.styleMap&&ResStyleManager.styleMap[asset]){
				return ResStyleManager.styleMap[asset].getAttribute('compress')==1;
			}
			return ProjectSetting.resCanCompress==1;
		}

		ResStyleManager.getNotPackFiles=function(){
			var rst;
			rst=[];
			var key;
			for(key in ResStyleManager.styleMap){
				if(!ResStyleManager.getResIfPack(key)){
					rst.push(key);
				}
			}
			return rst;
		}

		ResStyleManager.getPackFilesByType=function(type){
			var rst;
			rst=[];
			var key;
			for(key in ResStyleManager.styleMap){
				if(type==ResStyleManager.getResPackType(key)){
					rst.push(key);
				}
			}
			return rst;
		}

		ResStyleManager.getPicTypeFilesByType=function(type){
			var rst;
			rst=[];
			var key;
			for(key in ResStyleManager.styleMap){
				if(type==ResStyleManager.getResPicType(key)){
					rst.push(key);
				}
			}
			return rst;
		}

		ResStyleManager.getResQuality=function(asset){
			if(ResStyleManager.styleMap&&ResStyleManager.styleMap[asset]){
				return LayaBuilder.mParseInt(ResStyleManager.styleMap[asset].getAttribute('quality'));
			}
			return ProjectSetting.resPublishQuality;
		}

		ResStyleManager.updateResStyle=function(asset,type,compress,quality,props,packType,picType){
			(packType===void 0)&& (packType=0);
			(picType===void 0)&& (picType=0);
			props=ResStyleManager.getPropStrByArr(props.split("\n"));
			if(ResStyleManager.styleMap&&ResStyleManager.styleMap[asset]){
				ResStyleManager.styleMap[asset].setAttribute('type',type);
				ResStyleManager.styleMap[asset].setAttribute('compress',compress);
				ResStyleManager.styleMap[asset].setAttribute('quality',quality);
				ResStyleManager.styleMap[asset].setAttribute('props',props);
				ResStyleManager.styleMap[asset].setAttribute('pack',packType);
				ResStyleManager.styleMap[asset].setAttribute('picType',picType);
				}else {
				var xml=new XMLElement("<item name=\""+asset+"\" type='"+type+"' compress=\""+compress+"\" pack=\""+packType+"\" quality=\""+quality+"\" />");
				ResStyleManager.styleXML.appendChild(xml);
				ResStyleManager.styleMap[asset]=xml;
				ResStyleManager.styleMap[asset].setAttribute('type',type);
				ResStyleManager.styleMap[asset].setAttribute('compress',compress);
				ResStyleManager.styleMap[asset].setAttribute('quality',quality);
				ResStyleManager.styleMap[asset].setAttribute('props',props);
				ResStyleManager.styleMap[asset].setAttribute('pack',packType);
				ResStyleManager.styleMap[asset].setAttribute('picType',picType);
			}
			FileManager.createTxtFile(SystemSetting.stylePath,ResStyleManager.styleXML.toString());
		}

		ResStyleManager.styleXML=null
		ResStyleManager.styleMap=null
		ResStyleManager.PropSplitSign="@@!@@";
		ResStyleManager.Pic_Default=0;
		ResStyleManager.Pic_Repeat=1;
		ResStyleManager.Pack_Default=0;
		ResStyleManager.Pack_Pack=1;
		ResStyleManager.Pack_NotPack=2;
		return ResStyleManager;
	})()


	/**快捷键管理器
	*@author yung
	*/
	//class laya.editor.manager.ShortcutManager
	var ShortcutManager=(function(){
		function ShortcutManager(){};
		__class(ShortcutManager,'laya.editor.manager.ShortcutManager');
		ShortcutManager.init=function(){
			Laya.stage.on("keydown",ShortcutManager,ShortcutManager.onStageKeyDown);
		}

		ShortcutManager.onStageKeyDown=function(e){
			if(Browser.window["layaideconfig"]){
				if(Browser.window["layaideconfig"].mode=="0")return;
			}
			if(Input.isInputting)return;
			ShortcutManager.exeKey(e.keyCode,KeyManager.I.isCommandKeyDown,e.shiftKey);
		}

		ShortcutManager.getKey=function(key,ctrl,shift){
			var str=""+key;
			str+=ctrl ? "_ctrl" :"";
			str+=shift ? "_shift" :"";
			return str;
		}

		ShortcutManager.addKey=function(key,ctrl,shift,handler,args,focusClass,name,_this){
			(name===void 0)&& (name="");
			var str=ShortcutManager.getKey(key,ctrl,shift);
			if (ShortcutManager.keyMap[str]==null || ShortcutManager.keyMap[str].focusClass !=focusClass){
				ShortcutManager.keyMap[str]={focusClass:focusClass,handler:handler,args:args,_this:_this};
				}else {
				Sys.warn(Sys.lang("快捷键冲突")+name,"key:"+key,"ctrl:"+ctrl,"shift:"+shift);
			}
		}

		ShortcutManager.addKeyE=function(key,ctrl,shift,notice,args,focusClass,name,_this){
			(name===void 0)&& (name="");
			var str=ShortcutManager.getKey(key,ctrl,shift);
			if (ShortcutManager.keyMapE[str]==null || ShortcutManager.keyMapE[str].focusClass !=focusClass){
				ShortcutManager.keyMapE[str]={focusClass:focusClass,notice:notice,args:args,_this:_this};
				}else {
				Sys.warn(Sys.lang("快捷键冲突")+name,"key:"+key,"ctrl:"+ctrl,"shift:"+shift);
			}
		}

		ShortcutManager.exeKey=function(key,ctrl,shift){
			(ctrl===void 0)&& (ctrl=false);
			(shift===void 0)&& (shift=false);
			var str=ShortcutManager.getKey(key,ctrl,shift);
			if (ShortcutManager.keyMap[str] !=null){
				var fClass;
				if (!fClass||(Laya.__typeof(Laya.stage.focus,fClass))){
					var fun=ShortcutManager.keyMap[str].handler;
					var args=ShortcutManager.keyMap[str].args;
					fun.apply(ShortcutManager.keyMap[str]._this,args);
				}
			}
			if (ShortcutManager.keyMapE[str] !=null){
				if (!fClass||(Laya.__typeof(Laya.stage.focus,fClass))){
					Notice.notify(ShortcutManager.keyMapE[str].notice,ShortcutManager.keyMapE[str].args);
				}
			}
		}

		ShortcutManager.keyMap={};
		ShortcutManager.keyMapE={};
		return ShortcutManager;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.editor.manager.UIConfigManager
	var UIConfigManager=(function(){
		function UIConfigManager(){}
		__class(UIConfigManager,'laya.editor.manager.UIConfigManager');
		UIConfigManager.addNewConfig=function(data){
			UIConfigManager._fullConfigCache={};
			if(!UIConfigManager.configMap){
				UIConfigManager.configMap=data;
				return;
			};
			var key;
			for(key in data){
				UIConfigManager.configMap[key]=data[key];
				UIConfigManager.addPropKeys(data[key]);
			}
		}

		UIConfigManager.getCompPropValueType=function(type,prop){
			var comp=UIConfigManager.getCompConfig(type);
			if(!comp||!comp.prop||!comp.prop[prop])return "unknow:"+type+","+prop;
			return comp.prop[prop].type;
		}

		UIConfigManager.getCompPropValueAccept=function(type,prop){
			var comp=UIConfigManager.getCompConfig(type);
			if(!comp||!comp.prop||!comp.prop[prop])return "";
			return comp.prop[prop].accept;
		}

		UIConfigManager.getCompConfig=function(type){
			return UIConfigManager.getFullConfig(type);
			return UIConfigManager.configMap[type];
		}

		UIConfigManager.addPropKeys=function(tdata){
			var cList=tdata.cList;
			var i=0,len=0;
			len=cList.length;
			for(i=0;i<len;i++){
				UIConfigManager.propKeysDic[cList[i].p.name]=true;
			}
		}

		UIConfigManager.getCompDefaultValueO=function(type){
			var configObj;
			var defaultObj;
			defaultObj=UIConfigManager.defaultPropDic[type];
			if(defaultObj)return defaultObj;
			defaultObj={};
			UIConfigManager.defaultPropDic[type]=configObj;
			configObj=laya.editor.manager.UIConfigManager.getCompConfig(type);
			if(!configObj)return defaultObj;
			var defaultStr;
			defaultStr=configObj.p.defaultValue;
			if(!defaultStr||defaultStr.length<1)return defaultObj;
			var keyValues;
			keyValues=defaultStr.split(" ");
			var tKValue;
			var i=0,len=0;
			len=keyValues.length;
			for(i=0;i<len;i++){
				if(!keyValues[i]||keyValues[i]==""||keyValues[i]==" ")continue ;
				tKValue=keyValues[i].split("=");
				defaultObj[tKValue[0]]=StringTool$1.getReplace(tKValue[1],"'","");
			}
			return defaultObj;
		}

		UIConfigManager.getTypedValue=function(valueType,value){
			if(!valueType)return ObjectTools$1.getAutoValue(value);
			switch(valueType){
				case "int":
					value=LayaBuilder.mParseInt(value);
				case "Number":
				case "sNumber":
				case "number":
					value=parseFloat(value);
					break ;
				case "pNumber":
					value=Math.abs(parseFloat(value));
					break ;
				case "bool":
					value=value=="true"?true:false;
					break ;
				}
			if(ObjectTools$1.isNaNS(value)){
				value=0;
			}
			return value;
		}

		UIConfigManager.getNodeTypedKeyValue=function(nodeType,key,value){
			return UIConfigManager.getTypedValue(UIConfigManager.getCompPropValueType(nodeType,key),value);
		}

		UIConfigManager.inserDefaultValue=function(node){
			var defaultObj;
			defaultObj=UIConfigManager.getCompDefaultValueO(node.type);
			var key;
			var assetDefault;
			assetDefault=ResStyleManager.getResPropsObj(node.props[laya.editor.manager.UIConfigManager.getCompSkinLabel(node.type)]);
			for(key in defaultObj){
				if(assetDefault[key])continue ;
				node.props[key]=UIConfigManager.getNodeTypedKeyValue(node.type,key,defaultObj[key]);
			}
		}

		UIConfigManager.getFullConfig=function(type){
			if(UIConfigManager._fullConfigCache[type])return UIConfigManager._fullConfigCache[type];
			var rst;
			rst=UIConfigManager.configMap[type];
			if (!rst)return null;
			rst=ObjectTools$1.copyObj(rst);
			if (!rst.c.prop)rst.c.prop=[];
			if (! (rst.c.prop instanceof Array))rst.c.prop=[rst.c.prop];
			if (rst.p.inherit){
				UIConfigManager.inherit(rst,UIConfigManager.getFullConfig(rst.p.inherit));
			}
			UIConfigManager.createPropDic(rst);
			UIConfigManager._fullConfigCache[type]=rst;
			return rst;
		}

		UIConfigManager.createPropDic=function(node){
			var props;
			props=node.c.prop;
			var propO;
			propO={};
			var i=0,len=0;
			len=props.length;
			var tProp;
			for(i=0;i<len;i++){
				tProp=props[i].p;
				propO[tProp.name]=tProp;
			}
			node.prop=propO;
		}

		UIConfigManager.getCompNames=function(){
			var rst=[];
			var key;
			for(key in UIConfigManager.configMap){
				if(UIConfigManager.NoCompDic[key])continue ;
				rst.push(key);
			}
			rst.sort();
			return rst;
		}

		UIConfigManager.getCompTreeIcon=function(type){
			var iconurl;
			iconurl=laya.editor.manager.UIConfigManager.getCompProp(type,"icon");
			if(!iconurl){
				iconurl="Image";
			}
			return FileTools.getAbsPath(FileManager.getAppPath("laya/icons/components/"+iconurl+".png"));
		}

		UIConfigManager.getCompProp=function(type,key){
			var dataO=UIConfigManager.getFullConfig(type);
			if(!dataO||!dataO.p)return null;
			return dataO.p[key];
		}

		UIConfigManager.getCompSkinLabel=function(type){
			var prop=laya.editor.manager.UIConfigManager.getCompProp(type,"skinLabel");
			prop=prop || "styleSkin";
			return prop;
		}

		UIConfigManager.getCompResStr=function(type){
			return UIConfigManager.getCompProp(type,"resName");
		}

		UIConfigManager.getCompTypeByResNameOfIDESetting=function(res){
			res=IDESettingResTypeManager.getResType(res);
			return res;
		}

		UIConfigManager.getCompTypeByResName=function(res,isIcon,ignoreIDESetting){
			(isIcon===void 0)&& (isIcon=false);
			(ignoreIDESetting===void 0)&& (ignoreIDESetting=false);
			var ideSettingType;
			ideSettingType=UIConfigManager.getCompTypeByResNameOfIDESetting(res);
			if(ideSettingType&&!ignoreIDESetting){
				res=ideSettingType;
			};
			var type;
			for(type in UIConfigManager.configMap){
				if(UIConfigManager.configMap[type].p.resName==res||type.toLowerCase()==res.toLowerCase()){
					if(isIcon)return UIConfigManager.configMap[type].p.icon;
					return type;
				}
			}
			return "Image";
		}

		UIConfigManager.getCompTypeByExtension=function(extension,isIcon){
			(isIcon===void 0)&& (isIcon=false);
			var type;
			for(type in UIConfigManager.configMap){
				if(UIConfigManager.configMap[type].p.extension&&!UIConfigManager.configMap[type].p.extensionDic){
					var extStr=UIConfigManager.configMap[type].p.extension;
					var exts;
					exts=extStr.split(",");
					var i=0,len=0;
					len=exts.length;
					var dic;
					dic={};
					for(i=0;i<len;i++){
						dic[exts[i]]=true;
					}
					UIConfigManager.configMap[type].p.extensionDic=dic;
				}
				if(UIConfigManager.configMap[type].p.extension==extension||(UIConfigManager.configMap[type].p.extensionDic&&UIConfigManager.configMap[type].p.extensionDic[extension])){
					if(isIcon)return UIConfigManager.configMap[type].p.icon;
					return type;
				}
			}
			return null;
		}

		UIConfigManager.inherit=function(child,parent){
			if (!parent)return;
			var cClist;
			var pClist;
			cClist=child.c.prop;
			pClist=parent.c.prop;
			var keys={};
			var i=0;
			var len=0;
			len=cClist.length;
			for (i=0;i < len;i++){
				keys[cClist[i].p.name]=true;
			}
			len=pClist.length;
			for (i=0;i < len;i++){
				if (!keys[pClist[i].p.name]){
					cClist.push(pClist[i]);
				};
			}
		}

		UIConfigManager.configMap={};
		UIConfigManager.propKeysDic={};
		UIConfigManager.defaultPropDic={};
		UIConfigManager._fullConfigCache={};
		__static(UIConfigManager,
		['NoCompDic',function(){return this.NoCompDic={
				"EffectAnimation":true,
				"GraphicPic":true,
				"GraphicNode":true,
				"GraphicBase":true,
				"MixItems":true,
				"ParticlePlayer":true,
				"FillTexture":true,
				"Prefab":true,
				"Props":true,
				"Particle":true,
				"PolyEmitter":true,
				"Rect":true,
				"Texture":true,
				"FillTexture":true,
				"Circle":true,
				"Pie":true,
				"Line":true,
				"Lines":true,
				"Curves":true,
				"Poly":true,
				"Curves":true,
				"FillText":true,
				"GridEditor":true,
				"Curves":true,
				"UIView":true
		};}

		]);
		return UIConfigManager;
	})()


	/**编辑器系统类，提供扩展插件使用
	*@author yung
	*/
	//class laya.editor.Sys
	var Sys$1=(function(){
		function Sys(){};
		__class(Sys,'laya.editor.Sys',null,'Sys$1');
		Sys.SetBmdVer=function(name){
			var obj=Sys.bmdMap[name];
			if (obj){
				obj.ver=Sys.bmdVer;
			}
		}

		Sys.init=function(main){
			laya.editor.Sys.main=main;
			laya.editor.Sys.stage=main.stage;
		}

		Sys.clearRes=function(){
			Sys.resDomainMap={};
		}

		Sys.loadRes=function(url,complete){}
		Sys.onResLoaded=function(loader,complete){
			if (complete !=null){
				complete();
			}
		}

		Sys.onBitmapDataLoaded=function(loader,assetName,complete,args){
			if (complete !=null){
				complete.apply(null,args);
			}
		}

		Sys.disposeBitmap=function(assetName){
			var obj=Sys.bmdMap[assetName];
			if (obj){
				obj.bmd.dispose();
				delete Sys.bmdMap[assetName];
			}
		}

		Sys.hasRes=function(name){
			if (name==null || name.indexOf(".png")>-1 || name.indexOf(".jpg")>-1){
				return true;
			}
			return false;
		}

		Sys.getResClass=function(name){
			return null;
		}

		Sys.getRes=function(name){
			var sp=new Sprite();
			return sp;
		}

		Sys.getResBitmapData=function(name){
			return null;
		}

		Sys.info=function(__args){
			var args=arguments;
			console.log("info",args,0x3EBDF4);
		}

		Sys.error=function(__args){
			var args=arguments;
			console.log("error",args,0xFF4646);
		}

		Sys.warn=function(__args){
			var args=arguments;
			console.log("warn",args,0xFFFF80);
		}

		Sys.plugin=function(__args){
			var args=arguments;
			console.log("plugin",args,0xFF0080);
		}

		Sys.log=function(__args){
			var args=arguments;
			console.log("swc",args,0xFF0080);
		}

		Sys.stage=null
		Sys.main=null
		Sys.resDomainMap=null
		Sys.bmdMap={};
		Sys.bmdVer=0;
		return Sys;
	})()


	/**工具类
	*@author yung
	*/
	//class laya.editor.utils.Utils
	var Utils=(function(){
		function Utils(){};
		__class(Utils,'laya.editor.utils.Utils');
		Utils.clone=function(source){
			return ObjectTools$1.copyObj(source);
		}

		Utils.bind=function(fun,_scope){
			var rst;
			rst=fun.bind(_scope);;
			return rst;
		}

		Utils.createMaskArea=function(width,height,color,alpha){
			(color===void 0)&& (color="#ff0000");
			(alpha===void 0)&& (alpha=1);
			var sp=new Sprite();
			sp.graphics.drawRect(0,0,width,height,color);
			sp.alpha=alpha;
			return sp;
		}

		Utils.drawDashedRect=function(g,width,height,lineWidth,lineColor,lineAlpha,solidLen,brokenLen){
			(lineWidth===void 0)&& (lineWidth=1);
			(lineColor===void 0)&& (lineColor=0xff0000);
			(lineAlpha===void 0)&& (lineAlpha=1);
			(solidLen===void 0)&& (solidLen=5);
			(brokenLen===void 0)&& (brokenLen=2);
			g.clear();
			Utils.drawDashed(g,new Point(0,0),new Point(width,0),lineWidth,lineColor,lineAlpha,solidLen,brokenLen);
			Utils.drawDashed(g,new Point(width,0),new Point(width,height),lineWidth,lineColor,lineAlpha,solidLen,brokenLen);
			Utils.drawDashed(g,new Point(width,height),new Point(0,height),lineWidth,lineColor,lineAlpha,solidLen,brokenLen);
			Utils.drawDashed(g,new Point(0,height),new Point(0,0),lineWidth,lineColor,lineAlpha,solidLen,brokenLen);
		}

		Utils.drawDashed=function(g,p1,p2,lineWidth,lineColor,lineAlpha,solidLen,brokenLen){
			(lineWidth===void 0)&& (lineWidth=1);
			(lineColor===void 0)&& (lineColor=0xff0000);
			(lineAlpha===void 0)&& (lineAlpha=1);
			(solidLen===void 0)&& (solidLen=5);
			(brokenLen===void 0)&& (brokenLen=2);
			g.drawLine(p1.x,p1.y,p2.x,p2.y,"#"+lineColor.toString(16));
		}

		Utils.getPoint=function(from,x,y,to){
			var g=from.localToGlobal(new Point(x,y));
			var p=to.globalToLocal(g);
			return p;
		}

		Utils.xmlToMapByCompId=function(xml,map){
			map[xml.compId]=xml;
			var list=xml.child;
			if(!list)return;
			for (var j=0,n=list.length;j < n;j++){
				Utils.xmlToMapByCompId(list[j],map);
			}
		}

		Utils.getClass=function(classname){
			var arr=classname.split(".");
			var obj=Browser.window;
			for(var i=0,n=arr.length;i<n;i++){
				obj=obj[arr[i]];
			}
			return obj;
		}

		return Utils;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-6-12 下午3:59:36
	*/
	//class laya.editor.view.ani.AnimationDataWorker
	var AnimationDataWorker=(function(){
		function AnimationDataWorker(){
			this._animations=null;
			this.treeData=null;
			this.compMap=null;
			this.design=null;
			this.targetAnimation=null;
			this.selectLabel=null;
			this.tSelectAni=null;
			this.treeNodeDic={};
			this.isFirstSetUp=false;
			this.keyIndexDic={};
			this.targetAnimation=new TargetAnimation();
		}

		__class(AnimationDataWorker,'laya.editor.view.ani.AnimationDataWorker');
		var __proto=AnimationDataWorker.prototype;
		/**
		*获取最大的动画id
		*@return
		*
		*/
		__proto.getMaxAniID=function(){
			if(!this._animations)return 1;
			var i=0,len=0;
			var rst=1;
			len=this._animations.length;
			var tAniData;
			for(i=0;i<len;i++){
				tAniData=this._animations[i];
				if(tAniData.id>=rst){
					rst=tAniData.id+1;
				}
			}
			return rst;
		}

		/**
		*创建一个新的动画
		*@return
		*
		*/
		__proto.createDefaultAnimationData=function(){
			var aniData;
			aniData={};
			aniData.id=this.getMaxAniID();
			aniData.name="ani"+aniData.id;
			aniData.frameRate=24;
			aniData.nodes=[];
			return aniData;
		}

		/**
		*获取节点动画数据
		*@param compId 节点ID
		*@param aniO 动画数据对象
		*@return
		*
		*/
		__proto.getAniNodeObj=function(compId,aniO){
			if(!aniO)aniO=this.tSelectAni;
			var nodes;
			nodes=aniO.nodes;
			var i=0,len=0;
			len=nodes.length;
			var tNode;
			for(i=0;i<len;i++){
				tNode=nodes[i];
				if(tNode.target==compId){
					return tNode;
				}
			}
			return null;
		}

		/**
		*创建一个节点动画数据
		*@param tar 目标节点
		*@return
		*
		*/
		__proto.createDefaultNodeData=function(tar){
			var nodeData;
			nodeData={};
			nodeData.target=tar.compId;
			nodeData.keyframes={};
			return nodeData;
		}

		/**
		*获取动画列表
		*@return
		*
		*/
		__proto.getAnimationSelects=function(){
			var i=0,len=0;
			len=this._animations.length;
			var tAniData;
			var rsts;
			rsts=AnimationDataWorker.selectLabels;
			rsts.length=0;
			for(i=0;i<len;i++){
				tAniData=this._animations[i];
				rsts.push(tAniData.name);
			}
			return rsts.join(",");
		}

		/**
		*删除动画名
		*@param aniName 动画名
		*
		*/
		__proto.removeAniByAniName=function(aniName){
			var i=0,len=0;
			len=this._animations.length;
			var tAniData;
			for(i=0;i<len;i++){
				tAniData=this._animations[i];
				if(aniName==tAniData.name){
					this._animations.splice(i,1);
					return;
				}
			}
		}

		__proto.isNewNameOk=function(aniName){
			if(!this._animations)return false;
			var i=0,len=0;
			len=this._animations.length;
			var tAniData;
			for(i=0;i<len;i++){
				tAniData=this._animations[i];
				if(aniName==tAniData.name){
					return false;
				}
			}
			return true;
		}

		/**
		*选择动画
		*@param aniName 动画名
		*
		*/
		__proto.selectAniByAniName=function(aniName){
			var i=0,len=0;
			len=this._animations.length;
			var tAniData;
			for(i=0;i<len;i++){
				tAniData=this._animations[i];
				if(aniName==tAniData.name){
					this.selectAniByIndex(i);
					return;
				}
			}
			this.selectAniByIndex(0);
		}

		/**
		*选择动画
		*@param index 动画id
		*
		*/
		__proto.selectAniByIndex=function(index){
			if(!this._animations[index])debugger;
			var tAniData;
			tAniData=this._animations[index];
			this.tSelectAni=tAniData;
			this.selectLabel=tAniData.name;
		}

		__proto.inits=function(){
			if(!this._animations)this._animations=[];
			if(this._animations.length<1){
				this._animations.push(this.createDefaultAnimationData());
			}
			if(!this.tSelectAni){
				this.selectAniByIndex(0);
			}
		}

		/**
		*添加动画
		*
		*/
		__proto.addAni=function(){
			this._animations.push(this.createDefaultAnimationData());
			this.selectAniByIndex(this._animations.length-1);
		}

		__proto.cloneAni=function(aniO){
			if(!aniO)aniO=this.tSelectAni;
			var newAniO;
			newAniO=ObjectTools$1.copyObj(aniO);
			var tName;
			var i=0;
			tName=aniO.name+"_"+i;
			while(!this.isNewNameOk(tName)){
				i++;
				tName=aniO.name+"_"+i;
			}
			newAniO.name=tName;
			this._animations.push(newAniO);
			this.selectAniByIndex(this._animations.length-1);
		}

		/**
		*删除动画节点
		*@param compId
		*@param aniO
		*
		*/
		__proto.removeNode=function(compId,aniO,onlyData){
			(onlyData===void 0)&& (onlyData=false);
			if(!aniO)aniO=this.tSelectAni;
			var nodes;
			nodes=aniO.nodes;
			var i=0,len=0;
			len=nodes.length;
			var tNode;
			for(i=0;i<len;i++){
				tNode=nodes[i];
				if(tNode.target==compId){
					if(onlyData){
						tNode.keyframes={};
						tNode.frames={};
						}else{
						nodes.splice(i,1);
					}
					return;
				}
			}
		}

		/**
		*添加节点
		*@param nodeId
		*
		*/
		__proto.addNode=function(nodeId){
			var node;
			var compO;
			compO=this.treeData.getNodeByID(nodeId);
			if(!compO)debugger;
			node=this.getAniNodeObj(nodeId);
			if(!node){
				node=this.createDefaultNodeData(compO);
				this.tSelectAni.nodes.push(node);
			}
		}

		/**
		*修改动画对象节点ID
		*@param preID
		*@param newID
		*
		*/
		__proto.changeNodeId=function(preID,newID){
			var node;
			node=this.getAniNodeObj(preID);
			var newNode;
			newNode=this.getAniNodeObj(newID);
			if(newNode){
				this.removeNode(newID);
			}
			if(node){
				node.target=newID;
				var nodeO;
				nodeO=this.treeNodeDic[preID+""];
				if(nodeO){
					delete this.treeNodeDic[preID+""];
					this.treeNodeDic[newID+""]=nodeO;
				}
			}
		}

		/**
		*删除节点属性动画
		*@param nodeId
		*@param prop
		*
		*/
		__proto.removeNodeProp=function(nodeId,prop){
			var node;
			node=this.getAniNodeObj(nodeId);
			if(node&&node.keyframes){
				delete node.keyframes[prop];
			}
			if(node&&node.frames){
				delete node.frames[prop];
			}
			if(this.design&&this.design.xml){
			}
		}

		__proto.removeFrame=function(aniO,frame){
			if(!aniO)aniO=this.tSelectAni;
			var nodes;
			nodes=aniO.nodes;
			var i=0,len=0;
			len=nodes.length;
			var tNode;
			for(i=0;i<len;i++){
				tNode=nodes[i];
				this.removeNodeFrame(tNode,frame);
			}
		}

		__proto.removeNodeFrameByNodeID=function(nodeId,frame){
			var node;
			node=this.getAniNodeObj(nodeId);
			if(node){
				this.removeNodeFrame(node,frame);
			}
		}

		__proto.displayToInitState=function(){
			if(this.targetAnimation){
				this.targetAnimation.displayToInitState();
			}
		}

		__proto.removeNodeFrame=function(nodeO,frame){
			var props;
			props=nodeO.keyframes;
			var propKey;
			for(propKey in props){
				this.removeNodePropFrame(props[propKey],frame);
			}
		}

		__proto.getNodeIndex=function(nodeId,aniO){
			if(!aniO)aniO=this.tSelectAni;
			var nodes;
			nodes=aniO.nodes;
			var i=0,len=0;
			len=nodes.length;
			var tNode;
			for(i=0;i<len;i++){
				tNode=nodes[i];
				if(tNode.target==nodeId){
					return i;
				}
			}
			return-1;
		}

		__proto.getNodeIDByIndex=function(index,aniO){
			if(!aniO)aniO=this.tSelectAni;
			var nodes;
			nodes=aniO.nodes;
			var i=0,len=0;
			len=nodes.length;
			var tNode;
			if(nodes[index])return nodes[index].target;
			return-1;
		}

		__proto.getNodeKeyFramesByNodeID=function(nodeId,frame){
			var node;
			node=this.getAniNodeObj(nodeId);
			var key;
			var keyFrameO;
			var rst;
			rst=[];
			if(node&&node.keyframes){
				keyFrameO=node.keyframes;
				for(key in keyFrameO){
					var keyFrameList;
					keyFrameList=keyFrameO[key];
					var i=0,len=0;
					len=keyFrameList.length;
					for(i=0;i<len;i++){
						if(keyFrameList[i].index==frame){
							rst.push(keyFrameList[i]);
						}
					}
				}
			}
			return rst;
		}

		__proto.removeNodePropFrameByKeyAndFrame=function(nodeId,key,frame){
			var node;
			node=this.getAniNodeObj(nodeId);
			if(node&&node.keyframes&&node.keyframes[key]){
				this.removeNodePropFrame(node.keyframes[key],frame);
			}
		}

		__proto.removeNodePropFrame=function(keyFrames,frame){
			if(!keyFrames)return;
			var i=0;
			for(i=keyFrames.length-1;i>=0;i--){
				if(keyFrames[i].index==frame){
					keyFrames.splice(i,1);
				}
			}
		}

		__proto.moveNodePropFrameTo=function(nodeID,prop,preFrame,newFrame){
			var preKeyFrame;
			var tarKeyFrame;
			preKeyFrame=this.targetAnimation.getNodePropKeyFrame(nodeID+"",preFrame,prop,false);
			if(!preKeyFrame)return;
			this.removeNodePropFrame(this.targetAnimation.getNodePropKeyFrames(nodeID+"",prop),newFrame);
			preKeyFrame.index=newFrame;
		}

		__proto.addKeyFrameOToNode=function(nodeID,keyFrameO,offSetFrame){
			var nodeO;
			nodeO=this.getAniNodeObj(nodeID);
			if(!nodeO)return;
			var props;
			props=nodeO.keyframes;
			var propKey;
			propKey=keyFrameO["key"];
			var keyO;
			keyO=this.targetAnimation.getNodePropKeyFrame(nodeID+"",parseInt(keyFrameO.index)+offSetFrame,keyFrameO.key,true);
			var i=0,len=0;
			len=AnimationDataWorker.keyCopyKeys.length;
			var tKey;
			for(i=0;i<len;i++){
				tKey=AnimationDataWorker.keyCopyKeys[i];
				keyO[tKey]=keyFrameO[tKey];
			}
		}

		__proto.moveNodeFrameTo=function(nodeID,preFrame,newFrame){
			var nodeO;
			nodeO=this.getAniNodeObj(nodeID);
			if(!nodeO)return;
			var props;
			props=nodeO.keyframes;
			var propKey;
			for(propKey in props){
				this.moveNodePropFrameTo(nodeID,propKey,preFrame,newFrame);
			}
		}

		__proto.moveFrameTo=function(aniO,preFrame,newFrame){
			if(!aniO)aniO=this.tSelectAni;
			var nodes;
			nodes=aniO.nodes;
			var i=0,len=0;
			len=nodes.length;
			var tNode;
			for(i=0;i<len;i++){
				tNode=nodes[i];
				this.moveNodeFrameTo(tNode.target,preFrame,newFrame);
			}
		}

		/**
		*添加属性关键帧
		*@param node
		*@param prop
		*@param frame
		*
		*/
		__proto.addNodeFrame=function(node,prop,frame,force,forceDelete){
			(force===void 0)&& (force=false);
			(forceDelete===void 0)&& (forceDelete=false);
			if(!node.props.hasOwnProperty(prop)){
				if(force){
					node.props[prop]=this.targetAnimation.getNodeFrameProp(node.compId,frame,prop);
					}else{
					if(!forceDelete)
						return;
					var preV;
					preV=this.targetAnimation.getNodeFrameProp(node.compId,frame,prop);
					if((typeof preV=='string')){
						node.props[prop]="";
						}else{
						node.props[prop]=0;
					}
				}
			};
			var value;
			value=node.props[prop];
			if(force||value!=this.targetAnimation.getNodeFrameProp(node.compId,frame,prop)){
				this.addNode(node.compId);
				var keyFrame;
				keyFrame=this.targetAnimation.getNodePropKeyFrame(node.compId,frame,prop,true);
				keyFrame.value=value;
				AnimationDataWorker.adptFrameData(keyFrame);
				this.targetAnimation.calculateDatas();
			}
		}

		__proto.makeKeyFrame=function(nodeId,prop,frame){
			this.addNode(nodeId);
			var keyFrame;
			keyFrame=this.targetAnimation.getNodePropKeyFrame(nodeId+"",frame,prop,true);
			keyFrame.value=this.targetAnimation.getNodeFrameProp(nodeId+"",frame,prop);
			if((typeof keyFrame.value=='string')){
				keyFrame.tween=false;
			}
			return keyFrame;
		}

		/**
		*获取显示用的节点数据
		*@param key
		*@return
		*
		*/
		__proto.getTreeNodeObj=function(key){
			if(!this.treeNodeDic[key])this.treeNodeDic[key]={};
			var rst;
			rst=this.treeNodeDic[key];
			rst.hasChild=false;
			return rst;
		}

		__proto.makeAllNodeAni=function(){
			if(!IDEVars.isGraphicAnimationMode)return;
			if(!this.treeData)return;
			var rootNode;
			rootNode=this.treeData.root;
			if(!rootNode)return;
			this.makeNodeAnis(rootNode);
			return;
			var childs;
			childs=rootNode.child;
			var i=0,len=0;
			len=childs.length;
			for(i=0;i<len;i++){
				var tChild;
				tChild=childs[i];
				if(tChild.compId>0){
					this.addNode(tChild.compId);
				}
			}
		}

		__proto.makeNodeAnis=function(rootNode){
			var childs;
			childs=rootNode.child;
			var i=0,len=0;
			len=childs.length;
			for(i=0;i<len;i++){
				var tChild;
				tChild=childs[i];
				if(tChild.compId>0){
					this.addNode(tChild.compId);
					this.makeNodeAnis(tChild);
				}
			}
		}

		/**
		*获取显示用的动画数据
		*@return
		*
		*/
		__proto.getAniDataList=function(){
			if(this.isFirstSetUp){
				this.targetAnimation.setUp(this.compMap,null,this.tSelectAni);
				}else{
				this.targetAnimation.setUp(this.compMap,this.targetAnimation.initProps,this.tSelectAni);
			}
			this.makeAllNodeAni();
			this.isFirstSetUp=false;
			var rst;
			rst=[];
			var i=0,len=0;
			var nodes;
			nodes=this.tSelectAni.nodes;
			len=nodes.length;
			var tNode;
			var propNode;
			var tCompID=0;
			ObjectTools$1.clearObj(this.keyIndexDic);
			for(i=0;i<len;i++){
				tNode=nodes[i];
				tCompID=tNode.target;
				var nodeO;
				var compO;
				nodeO=this.getTreeNodeObj(tCompID+"");
				nodeO.path=tNode;
				nodeO.label=tCompID+"";
				nodeO.target=tCompID;
				nodeO.loseTarget=true;
				compO=this.treeData.getNodeByID(tCompID);
				if(compO){
					nodeO.type=compO.type;
					nodeO.label=compO.type+":"+compO.compId;
					if(compO.props){
						var AName;
						AName=compO.props["var"]||compO.props.name;
						if(AName){
							nodeO.label=compO.type+"("+AName+")"+":"+compO.compId;
						}
					}
					nodeO.loseTarget=false;
				};
				var nodeFrameList;
				nodeFrameList=[];
				var nodeFrameDic;
				nodeFrameDic={};
				var labelFrameDic;
				labelFrameDic={};
				if(!nodeO.childs)nodeO.childs=[];
				childs=nodeO.childs;
				childs.length=0;
				var childs;
				var propKey;
				var props;
				props=tNode.keyframes;
				rst.push(nodeO);
				for(propKey in props){
					propNode=this.getTreeNodeObj(tCompID+":"+propKey);
					propNode.path=props[propKey];
					propNode.nodeParent=nodeO;
					propNode.label=propKey;
					propNode.target=tCompID;
					propNode.key=propKey;
					childs.push(propNode);
					rst.push(propNode);
					this.collectKeyFrames(props[propKey],nodeFrameDic);
					this.collectKeyFrames(props[propKey],this.keyIndexDic);
					this.collectLabelFrames(props[propKey],labelFrameDic);
				}
				nodeO.keyFrames=this.createNodeKeyFramesData(nodeFrameDic,tCompID,labelFrameDic);
				nodeO.isDirectory=true;
				nodeO.hasChild=true;
			}
			return rst;
		}

		__proto.createNodeKeyFramesData=function(keyFrameDic,target,labelFrameDic){
			var rst;
			rst=SingleTool.I.getArr("keyframe:"+target);
			rst.length=0;
			var key;
			var tKeyFrameData;
			for(key in keyFrameDic){
				tKeyFrameData=SingleTool.I.getObject("keyframedata:"+target+"_"+key);
				tKeyFrameData.target=target;
				tKeyFrameData.index=key;
				if(labelFrameDic[key]){
					tKeyFrameData.label=labelFrameDic[key];
					}else{
					tKeyFrameData.label=null;
				}
				rst.push(tKeyFrameData);
			}
			return rst;
		}

		__proto.collectLabelFrames=function(frames,labelFrameDic){
			var i=0,len=0;
			len=frames.length;
			var tIndex=0;
			for(i=0;i<len;i++){
				if(frames[i].label){
					tIndex=frames[i].index;
					labelFrameDic[tIndex]=frames[i].label;
				}
			}
		}

		__proto.collectKeyFrames=function(frames,keyFrameDic){
			var i=0,len=0;
			len=frames.length;
			for(i=0;i<len;i++){
				keyFrameDic[frames[i].index]=true;
			}
		}

		/**
		*获取动画列表
		*@return
		*
		*/
		__getset(0,__proto,'animations',function(){
			return this._animations;
			},function(v){
			this._animations=v;
			this.inits();
		});

		AnimationDataWorker.createFrameData=function(index){
			(index===void 0)&& (index=0);
			var frameData;
			frameData={};
			frameData.index=index;
			frameData.value="";
			frameData.tween=true;
			frameData.tweenMethod="linearNone";
			return frameData;
		}

		AnimationDataWorker.cleanAnimationData=function(animationData,createNew){
			(createNew===void 0)&& (createNew=false);
			if(createNew){
				animationData=ObjectTools$1.copyObj(animationData);
			};
			var aniO;
			var ii=0,iiLen=0;
			iiLen=animationData.length;
			for(ii=0;ii<iiLen;ii++){
				aniO=animationData[ii];
				var nodes;
				nodes=aniO.nodes;
				var i=0,len=0;
				len=nodes.length;
				var tNode;
				for(i=0;i<len;i++){
					tNode=nodes[i];
					delete tNode.frames;
				}
			}
			return animationData;
		}

		AnimationDataWorker.removeWrongValueAniMationData=function(animationData){
			var aniO;
			var ii=0,iiLen=0;
			var changed=false;
			changed=false;
			var tChange=false;
			iiLen=animationData.length;
			for(ii=0;ii<iiLen;ii++){
				aniO=animationData[ii];
				var nodes;
				nodes=aniO.nodes;
				var i=0,len=0;
				len=nodes.length;
				var tNode;
				for(i=0;i<len;i++){
					tNode=nodes[i];
					var keyframes;
					keyframes=tNode.keyframes;
					var key;
					if(keyframes){
						for(key in keyframes){
							tChange=AnimationDataWorker.removeWrongValueFromKeyFrames(keyframes[key]);
							if(tChange)changed=true;
						}
					}
				}
			}
			return changed;
		}

		AnimationDataWorker.removeWrongValueFromKeyFrames=function(keyFrames){
			var i=0,len=0;
			len=keyFrames.length;
			var tKeyO;
			var changed=false;
			changed=false;
			for(i=len-1;i>=0;i--){
				tKeyO=keyFrames[i];
				if(typeof(tKeyO.value)=="object"){
					keyFrames.splice(i,1);
					changed=true;
				}
			}
			return changed;
		}

		AnimationDataWorker.removeNodeFromAnimationData=function(animationData,nodeID){
			var aniO;
			var ii=0,iiLen=0;
			iiLen=animationData.length;
			for(ii=0;ii<iiLen;ii++){
				aniO=animationData[ii];
				var nodes;
				nodes=aniO.nodes;
				var i=0,len=0;
				len=nodes.length;
				var tNode;
				for(i=len-1;i>=0;i--){
					tNode=nodes[i];
					if(tNode.target==nodeID){
						nodes.splice(i,1);
					}
				}
			}
		}

		AnimationDataWorker.getAnimationedNode=function(uiObj){
			var rst;
			rst={};
			var animationData;
			animationData=uiObj.animations;
			if(!animationData)return rst;
			var aniO;
			var ii=0,iiLen=0;
			iiLen=animationData.length;
			for(ii=0;ii<iiLen;ii++){
				aniO=animationData[ii];
				var nodes;
				nodes=aniO.nodes;
				var i=0,len=0;
				len=nodes.length;
				var tNode;
				for(i=0;i<len;i++){
					tNode=nodes[i];
					rst[tNode.target]=true;
				}
			}
			return rst;
		}

		AnimationDataWorker.adptFrameData=function(keyFrame){
			if(ObjectTools$1.isNaN(keyFrame.value)){
				keyFrame.tween=false;
			}
			return keyFrame;
		}

		AnimationDataWorker.selectLabels=[];
		__static(AnimationDataWorker,
		['keyCopyKeys',function(){return this.keyCopyKeys=["label","tween","tweenMethod","value"];}
		]);
		return AnimationDataWorker;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-6-13 上午10:56:49
	*/
	//class laya.editor.view.ani.TargetAnimation
	var TargetAnimation=(function(){
		function TargetAnimation(){
			this.targetDic=null;
			this.initProps=null;
			this.aniData=null;
			this.changedNodes={};
			this.count=0;
			this.sortIndexFun=null;
			if(this.sortIndexFun==null){
				this.sortIndexFun=MathUtil.sortByKey("index",false,true);
			}
		}

		__class(TargetAnimation,'laya.editor.view.ani.TargetAnimation');
		var __proto=TargetAnimation.prototype;
		/**
		*初始化动画数据
		*@param targetDic 对象表
		*@param initProps 对象初始化数据
		*@param aniData 动画数据
		*
		*/
		__proto.setUp=function(targetDic,initProps,aniData){
			this.targetDic=targetDic;
			this.initProps=initProps;
			if(!initProps)this.recordInitProps();
			this.aniData=aniData;
			this.calculateDatas();
		}

		/**
		*获取节点某帧某属性的数据
		*@param nodeKey 节点ID
		*@param frame 帧
		*@param prop 属性名
		*@return
		*
		*/
		__proto.getNodeFrameProp=function(nodeKey,frame,prop){
			var nodeData;
			nodeData=this.getNodeData(nodeKey);
			if(!nodeData||!nodeData.frames||!nodeData.frames[prop]){
				if(isNaN(this.initProps[nodeKey][prop]))return 0;
				return this.initProps[nodeKey][prop];
			};
			var frames;
			frames=nodeData.frames[prop];
			if(frames.length>frame&&frame>=0){
				return frames[frame];
				}else{
				return frames[frames.length-1];
			}
		}

		/**
		*获取节点的属性关键帧列表
		*@param nodeKey 节点ID
		*@param prop 属性名
		*@return
		*
		*/
		__proto.getNodePropKeyFrames=function(nodeKey,prop){
			var nodeData;
			nodeData=this.getNodeData(nodeKey);
			var keyFrames;
			keyFrames=nodeData.keyframes;
			if(!keyFrames[prop]){
				keyFrames[prop]=[];
			}
			return keyFrames[prop];
		}

		/**
		*获取节点的属性关键帧对象
		*@param nodeKey 节点ID
		*@param frame 帧
		*@param prop 属性名
		*@param autoCreate 如果没有是否自动创建
		*@return
		*
		*/
		__proto.getNodePropKeyFrame=function(nodeKey,frame,prop,autoCreate){
			(autoCreate===void 0)&& (autoCreate=false);
			var keyFrames;
			keyFrames=this.getNodePropKeyFrames(nodeKey,prop);
			var i=0,len=0;
			len=keyFrames.length;
			for(i=0;i<len;i++){
				if(keyFrames[i].index==frame)return keyFrames[i];
			}
			if(autoCreate){
				var frameData;
				frameData=AnimationDataWorker.createFrameData(frame);
				keyFrames.push(frameData);
				keyFrames.sort(this.sortIndexFun);
				return frameData;
				}else{
				return null;
			}
		}

		/**
		*获取节点数据
		*@param nodeKey 节点ID
		*@return
		*
		*/
		__proto.getNodeData=function(nodeKey){
			var nodes;
			nodes=this.aniData.nodes;
			var i=0,len=0;
			len=nodes.length;
			for(i=0;i<len;i++){
				if(nodes[i].target==nodeKey)return nodes[i];
			}
			return null;
		}

		/**
		*将所有节点设置到初始化状态
		*
		*/
		__proto.displayToInitState=function(){
			this.displayToInitStateSS();
			return;
			this.displayToInitStateEx();
			return;
			if(!this.initProps)return;
			if(!this.aniData)return;
			var nodeKey;
			var tNode;
			var props;
			for(nodeKey in this.initProps){
				tNode=this.targetDic[nodeKey];
				try{
					if(tNode){
						props=this.initProps[nodeKey];
						var prop;
						for(prop in props){
							tNode[prop]=props[prop];
						}
					}
				}catch(e){}
			}
		}

		__proto.displayToInitStateSS=function(){
			if(!this.initProps)return;
			if(!this.aniData)return;
			var key;
			var target;
			var datas;
			for(target in this.changedNodes){
				var props;
				props=this.initProps[target];
				var tNode;
				tNode=this.targetDic[target];
				datas=this.changedNodes[target];
				if(tNode&&props){
					for(key in datas){
						tNode[key]=props[key];
						if(tNode.comXml&&tNode.comXml.props&&tNode.comXml.props.hasOwnProperty(key)){
							if(TargetAnimation.isNoDisplayValue(tNode.comXml.props[key])){
								delete tNode.comXml.props[key];
								}else{
								tNode.comXml.props[key]=props[key];
							}
						}
					}
				}
			}
		}

		__proto.displayToInitStateEx=function(){
			if(!this.initProps)return;
			if(!this.aniData)return;
			var nodes;
			nodes=this.aniData.nodes;
			var i=0,len=0;
			len=nodes.length;
			for(i=0;i<len;i++){
				this.displayNodeToInitState(nodes[i]);
			}
		}

		__proto.displayNodeToInitState=function(node){
			var keyFrames;
			keyFrames=node.keyframes;
			var key;
			var tKeyFrames;
			var target=0;
			target=node.target;
			var props;
			props=this.initProps[target];
			var tNode;
			tNode=this.targetDic[target];
			for(key in keyFrames){
				tNode[key]=props[key];
			}
		}

		/**
		*将节点设置到某一帧的状态
		*@param frame
		*
		*/
		__proto.displayToFrame=function(frame){
			if(!this.aniData)return;
			if(frame<0)frame=0;
			if(frame>this.count)frame=this.count;
			var i=0,len=0;
			var nodes;
			nodes=this.aniData.nodes;
			len=nodes.length;
			for(i=0;i<len;i++){
				this.displayNodeToFrame(nodes[i],frame,null);
			}
		}

		/**
		*将节点设置到某一帧的状态
		*@param node 节点ID
		*@param frame
		*@param targetDic 节点表
		*
		*/
		__proto.displayNodeToFrame=function(node,frame,targetDic){
			if(!targetDic)targetDic=this.targetDic;
			var target;
			target=targetDic[node.target];
			if(!target){
				console.log("loseTarget:",node.target);
				return;
			};
			var frames;
			frames=node.frames;
			var key;
			var propFrames;
			var value;
			var propO;
			if(target.comXml&&target.comXml.props){
				propO=target.comXml.props;
			}
			if(!this.changedNodes[node.target]){
				this.changedNodes[node.target]={};
			}
			for(key in frames){
				this.changedNodes[node.target][key]=true;
				propFrames=frames[key];
				if(propFrames.length>frame){
					value=propFrames[frame];
					}else{
					value=propFrames[propFrames.length-1];
				}
				target[key]=value;
				if(propO){
					if(TargetAnimation.isNoDisplayValue(value)){
						delete propO[key];
						}else{
						propO[key]=value;
					}
				}
			}
		}

		/**
		*记录所有节点的初始化信息
		*
		*/
		__proto.recordInitProps=function(){
			if(!this.initProps)this.initProps={};
			ObjectTools$1.clearObj(this.initProps);
			var key;
			for(key in this.targetDic){
				this.recordNodeInfo(key,this.targetDic[key]);
			}
		}

		/**
		*记录某个节点的初始化信息
		*@param objKey
		*@param node
		*
		*/
		__proto.recordNodeInfo=function(objKey,node,force,keys){
			(force===void 0)&& (force=false);
			var key;
			var value;
			var tProp;
			tProp={};
			keys=keys||UIConfigManager.propKeysDic;
			var props;
			if(node.comXml&&node.comXml.props){
				props=node.comXml.props;
			}
			for(key in keys){
				value=node[key];
				tProp[key]=value;
				if(props&&props.hasOwnProperty(key)){
					tProp[key]=props[key];
				}
			}
			this.initProps[objKey]=tProp;
		}

		/**
		*计算帧数据
		*
		*/
		__proto.calculateDatas=function(){
			if(!this.aniData)return;
			var nodes;
			nodes=this.aniData.nodes;
			var i=0,len=0;
			len=nodes.length;
			var tNode;
			this.count=0;
			for(i=0;i<len;i++){
				tNode=nodes[i];
				this.calculateNodeKeyFrames(tNode);
			}
		}

		/**
		*计算某个节点的帧数据
		*@param node
		*
		*/
		__proto.calculateNodeKeyFrames=function(node){
			var keyFrames;
			keyFrames=node.keyframes;
			var key;
			var tKeyFrames;
			var target=0;
			target=node.target;
			if(!node.frames){
				node.frames={};
			}
			if(!this.initProps[node.target]){
			}
			for(key in keyFrames){
				tKeyFrames=keyFrames[key];
				if(!node.frames[key]){
					node.frames[key]=[];
				}
				tKeyFrames.sort(this.sortIndexFun);
				var isNew=false;
				if(tKeyFrames.length<1||tKeyFrames[0].index!=0){
					tKeyFrames.unshift(AnimationDataWorker.createFrameData(0));
					isNew=true;
				};
				var initData;
				initData=this.initProps[node.target];
				if(initData&&isNew){
					if(!(initData[key]===undefined)&&isNaN(initData[key])&&!((typeof (initData[key])=='string'))){
						tKeyFrames[0].value=0;
						}else{
						tKeyFrames[0].value=initData[key];
					}
				}
				if(tKeyFrames[0]){
					AnimationDataWorker.adptFrameData(tKeyFrames[0]);
				}
				this.calculateNodePropFrames(tKeyFrames,node.frames[key],key,target);
			}
		}

		/**
		*计算节点某个属性的帧数据
		*@param keyframes
		*@param frames
		*@param key
		*@param target
		*
		*/
		__proto.calculateNodePropFrames=function(keyframes,frames,key,target){
			var i=0,len=0;
			len=keyframes.length-1;
			frames.length=keyframes[len].index+1;
			for(i=0;i<len;i++){
				keyframes[i].key=key;
				keyframes[i].target=target;
				this.calculateFrameValues(keyframes[i],keyframes[i+1],frames);
			}
			if(len==0){
				frames[0]=keyframes[0].value;
			}
			keyframes[i].key=key;
			keyframes[i].target=target;
		}

		/**
		*计算两个关键帧直接的帧数据
		*@param startFrame
		*@param endFrame
		*@param result
		*
		*/
		__proto.calculateFrameValues=function(startFrame,endFrame,result){
			var i=0;
			var start=0,end=0;
			var easeFun;
			start=startFrame.index;
			end=endFrame.index;
			var startValue=0;
			startValue=startFrame.value;
			var dValue=0;
			dValue=endFrame.value-startFrame.value;
			var dLen=0;
			dLen=end-start;
			if(end>this.count)this.count=end;
			if(startFrame.tween){
				easeFun=Ease[startFrame.tweenMethod];
				if(easeFun==null){
					easeFun=Ease.linearNone;
				}
				for(i=start;i<end;i++){
					result[i]=easeFun(i-start,startValue,dValue,dLen);
				}
				}else{
				for(i=start;i<end;i++){
					result[i]=startValue;
				}
			}
			result[endFrame.index]=endFrame.value;
		}

		TargetAnimation.isNoDisplayValue=function(value){
			if(value===null||value===undefined||value.toString()=="NaN")return true;
			return false;
		}

		return TargetAnimation;
	})()


	/**帮助
	*@author yung
	*/
	//class laya.editor.view.other.Help
	var Help=(function(){
		function Help(){};
		__class(Help,'laya.editor.view.other.Help');
		var __proto=Help.prototype;
		__proto.start=function(){}
		__getset(1,Help,'instance',function(){
			return Help._instance ? Help._instance :Help._instance=new Help();
		});

		Help._instance=null
		return Help;
	})()


	/**感谢
	*@author yung
	*/
	//class laya.editor.view.other.Thank
	var Thank=(function(){
		function Thank(){};
		__class(Thank,'laya.editor.view.other.Thank');
		var __proto=Thank.prototype;
		__proto.start=function(){}
		__getset(1,Thank,'instance',function(){
			return Thank._instance ? Thank._instance :Thank._instance=new Thank();
		});

		Thank._instance=null
		return Thank;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-8-30 下午3:04:18
	*/
	//class laya.editor.view.prop.AppendPropGroupTool
	var AppendPropGroupTool=(function(){
		function AppendPropGroupTool(){}
		__class(AppendPropGroupTool,'laya.editor.view.prop.AppendPropGroupTool');
		AppendPropGroupTool.getNodePropKeyValue=function(node,key){
			if(!node)return null;
			return node.props[key]||PreFabManager.I.getPrefabUIPropByKey(node,key)||ResStyleManager.getResPropsKeyByNode(node,key)||PreFabManager.I.getPreFabPropByKey(node,key);
		}

		AppendPropGroupTool.addAppendPropsToData=function(appendPropPath,node){
			if(IDEVars.isGraphicAnimationMode){
				return;
			};
			var propO;
			propO=node.props;
			if(!propO[ "appendProps"])propO[ "appendProps"]=AppendPropGroupTool.getNodePropKeyValue(node,"appendProps");
			if(!propO[ "appendProps"])propO[ "appendProps"]="";
			var appends;
			var tstr;
			tstr=propO[ "appendProps"];
			if(tstr==""){
				appends=[];
				}else{
				appends=[];
			}
			if(appends.indexOf(appendPropPath)<0){
				appends.push(appendPropPath);
				propO[ "appendProps"]=appends.join(",");
			}
		}

		AppendPropGroupTool.removeAppendPropsFromData=function(appendPropPath,node){
			var propO;
			propO=node.props;
			if(!propO[ "appendProps"])propO[ "appendProps"]=AppendPropGroupTool.getNodePropKeyValue(node,"appendProps");
			if(!propO[ "appendProps"])return;
			var appends;
			appends=propO[ "appendProps"].split(",");
			if(appends.indexOf(appendPropPath)>=0){
				appends.splice(appends.indexOf(appendPropPath),1);
				if(appends.length<=0){
					delete propO[ "appendProps"];
					}else{
					propO[ "appendProps"]=appends.join(",");
				}
			}
		}

		AppendPropGroupTool.getProp=function(propName,type){
			(type===void 0)&& (type="input");
			var rst;
			rst={};
			rst.name=propName;
			rst.type=type;
			rst.tips=propName+":"+type;
			return rst;
		}

		AppendPropGroupTool.getTestData=function(){
			var rst;
			rst={};
			rst.name="testLabel";
			var props;
			props=[];
			rst.props=props;
			props.push(AppendPropGroupTool.getProp("lim"),AppendPropGroupTool.getProp("lam"));
			return rst;
		}

		AppendPropGroupTool.createGroupData=function(groupName,props,data){
			var rst;
			rst={};
			rst.name=groupName;
			rst.props=props;
			rst.data=data;
			return rst;
		}

		AppendPropGroupTool.getTestGroups=function(){
			var rst;
			rst=[];
			rst.push(AppendPropGroupTool.getTestData());
			return rst;
		}

		AppendPropGroupTool.readXMLPropConfig=function(path,insertRender){
			(insertRender===void 0)&& (insertRender=false);
			if(!FileTools.exist(path))return {};
			var xmlFile;
			xmlFile=FileTools.readFile(path);
			var xml;
			xml=Utils$1.parseXMLFromString(xmlFile);
			var obj;
			obj=XML2Object.parse(xml);
			if(insertRender){
				UIConfigManager.addNewConfig(obj.c);
			}
			return obj.cList[0];
		}

		AppendPropGroupTool.initScriptConfig=function(scriptPath){
			var data;
			data=AppendPropGroupTool.readXMLPropConfig(FileManager.getWorkPath(scriptPath),true);
			if(data&&data.Name){
				AppendPropGroupTool.scriptTypeDic[scriptPath]=data.Name;
			}
		}

		AppendPropGroupTool.isScriptInit=function(scriptPath){
			return AppendPropGroupTool.scriptTypeDic.hasOwnProperty(scriptPath);
		}

		AppendPropGroupTool.clearScript=function(scriptPath){
			delete AppendPropGroupTool.scriptTypeDic[scriptPath];
		}

		AppendPropGroupTool.getScriptName=function(scriptPath){
			if(! AppendPropGroupTool.scriptTypeDic[scriptPath])AppendPropGroupTool.initScriptConfig(scriptPath);
			if(!AppendPropGroupTool.scriptTypeDic[scriptPath])return "lostScript";
			return AppendPropGroupTool.scriptTypeDic[scriptPath];
		}

		AppendPropGroupTool.getPropsOByPath=function(path){
			var tData;
			try{
				tData=AppendPropGroupTool.readXMLPropConfig(path);
			}
			catch(error){
				tData={};
				tData.props={};
			}
			return tData;
		}

		AppendPropGroupTool.adptScriptNode=function(node){
			if(!node.type=="Script")return;
			AppendPropGroupTool.insertAppendPropsByPath(node,node.source);
		}

		AppendPropGroupTool.insertAppendProps=function(node){
			var path=laya.editor.view.prop.AppendPropGroupTool.getNodePropKeyValue(node,"appendProps");
			AppendPropGroupTool.insertAppendPropsByPath(node,path);
		}

		AppendPropGroupTool.insertAppendPropsByPath=function(node,path){
			if(!path)return;
			var tPath;
			tPath=FileManager.getWorkPath(path);
			if(!TypeManager.isScriptFile(path))return;
			var tData;
			tData=AppendPropGroupTool.getPropsOByPath(tPath);
			if(tData&&tData.p&&tData.p["className"]&&node.props){
				node.props.runtime=tData.p["className"];
			}
		}

		AppendPropGroupTool.getAppendPropByAppendProps=function(propsStr){
			if(!propsStr)return null;
			var strs;
			strs=propsStr.split(",");
			var i=0,len=0;
			len=strs.length;
			var rsts;
			rsts=[];
			for(i=0;i<len;i++){
				var tPath;
				tPath=FileManager.getWorkPath(strs[i]);
				if(FileTools.exist(tPath)){
					var tData;
					var gData;
					try{
						tData=AppendPropGroupTool.getPropsOByPath(tPath);
						gData={};
						gData.type="appendProps";
						gData.path=strs[i];
						gData.removeAble=true;
						rsts.push(AppendPropGroupTool.createGroupData(tData.Name,tData.c.prop,gData));
					}
					catch(error){
					}
				}
			}
			if(rsts.length>0)return rsts;
			return null;
		}

		AppendPropGroupTool.getAppendPropByRunTime=function(runTime){
			if(!runTime)return null;
			var filePath;
			filePath=runTime.split(".").join("/");
			filePath=FileManager.getWorkPath("src/"+filePath+".as");
			if(!FileTools.exist(filePath)){
				return null;
			};
			var code;
			code=new AsFileParser();
			code.setFile(filePath);
			var members;
			members=code.allMemberDic;
			var key;
			var tMemberO;
			var props;
			props=[];
			for(key in members){
				tMemberO=members[key];
				if(!tMemberO.modifiesO["public"])continue ;
				if(!AppendPropGroupTool.editablePropType[tMemberO.varType])continue ;
				switch(tMemberO.type){
					case "function":
						if(tMemberO.exType=="set"){
							var vName;
							vName=tMemberO.name;
							vName=vName.substr(3);
							props.push(AppendPropGroupTool.getProp(vName,tMemberO.varType));
						}
						break ;
					case "var":
						props.push(AppendPropGroupTool.getProp(tMemberO.name,tMemberO.varType));
						break ;
					}
			};
			var rst;
			if(props.length>0){
				rst=[AppendPropGroupTool.createGroupData(code.className,props)];
			}
			return rst;
		}

		AppendPropGroupTool.AppendPropsKey="appendProps";
		AppendPropGroupTool.scriptTypeDic={};
		AppendPropGroupTool.ConfigClassNameSign="className";
		__static(AppendPropGroupTool,
		['editablePropType',function(){return this.editablePropType={
				"Number":true,
				"int":true,
				"Boolean":true,
				"String":true
		};}

		]);
		return AppendPropGroupTool;
	})()


	/**
	*时间轴帧数据
	*@author ww
	*@version 1.0
	*
	*@created 2015-12-5 下午1:55:45
	*/
	//class laya.editor.view.timeline.TimeFrameData
	var TimeFrameData=(function(){
		function TimeFrameData(){
			this.frame=0;
			this.type=0;
			this.props=null;
		}

		__class(TimeFrameData,'laya.editor.view.timeline.TimeFrameData');
		TimeFrameData.create=function(frame,props,type){
			(type===void 0)&& (type=1);
			var rst;
			rst=Pool.getItemByClass("TimeFrameData",TimeFrameData);
			rst.type=type;
			rst.frame=frame;
			rst.props=props;
			return rst;
		}

		return TimeFrameData;
	})()


	/**
	*时间轴相关的事件
	*@author WW
	*@version 1.0
	*
	*@created 2015-12-8 上午9:01:12
	*/
	//class laya.editor.view.timeline.TimeLineEvent
	var TimeLineEvent=(function(){
		function TimeLineEvent(){}
		__class(TimeLineEvent,'laya.editor.view.timeline.TimeLineEvent');
		TimeLineEvent.LIST_CHANGE="ListChange";
		TimeLineEvent.TIMELINE_CLICKFRAME="TIMELINE_CLICKFRAME";
		return TimeLineEvent;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-6-27 下午10:41:37
	*/
	//class laya.editor.view.timeline.TimeLineStyles
	var TimeLineStyles=(function(){
		function TimeLineStyles(){}
		__class(TimeLineStyles,'laya.editor.view.timeline.TimeLineStyles');
		TimeLineStyles.cursorArrowColor="#00ffff";
		TimeLineStyles.cursorTxtColor="#00ffff";
		TimeLineStyles.cursorLineColor="#00ffff";
		TimeLineStyles.FrameBorderColor="#cc00cc";
		TimeLineStyles.FrameBorderColor_Focus="#ccFFcc";
		TimeLineStyles.FrameColor_KeyFrame="#13b5b1";
		TimeLineStyles.FrameColor_Holder="#111111";
		TimeLineStyles.FrameColor_Node="#ffffff";
		TimeLineStyles.FrameColor_Label="#f8b551";
		TimeLineStyles.FrameColor_Circle="#f8b551";
		TimeLineStyles.TitleBigLineColor="#009999";
		TimeLineStyles.TitleSmallLineColor="#006666";
		TimeLineStyles.TitleTxtColor="#d8d8d8";
		TimeLineStyles.FrameLineColor="#343434";
		__static(TimeLineStyles,
		['FrameColors',function(){return this.FrameColors=["#356692","#515151","#404040"];}
		]);
		return TimeLineStyles;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-12-7 下午7:47:46
	*/
	//class laya.editor.view.timeline.TimeLineUtils
	var TimeLineUtils=(function(){
		function TimeLineUtils(){}
		__class(TimeLineUtils,'laya.editor.view.timeline.TimeLineUtils');
		TimeLineUtils.fakeTimeLineTreeArrData=function(){
			var disTree;
			disTree=TimeLineUtils.fakeDisTreeData();
			var timeLineData;
			timeLineData=TimeLineUtils.fakeTimeLineData(disTree);
			var treeArr;
			treeArr=TimeLineUtils.fakeTreeArr(timeLineData);
			return treeArr;
		}

		TimeLineUtils.fakeDisTreeData=function(){
			var data;
			data=TimeLineUtils.getNodeData();
			var childNode;
			var i=0,len=0;
			len=5;
			for(i=0;i<len;i++){
				TimeLineUtils.addChildTo(TimeLineUtils.getNodeData(),data)
			}
			childNode=TimeLineUtils.getNodeData();
			len=3;
			for(i=0;i<len;i++){
				TimeLineUtils.addChildTo(TimeLineUtils.getNodeData(),childNode)
			}
			TimeLineUtils.addChildTo(childNode,data)
			return data;
		}

		TimeLineUtils.fakeTreeArr=function(treeO){
			var rst;
			rst=[];
			DisTools.getTreeArr(treeO,rst);
			return rst;
		}

		TimeLineUtils.fakeTimeLineData=function(treeData,parent){
			var rst;
			rst={};
			rst.nodeParent=parent;
			rst.name=treeData.name;
			rst.label=rst.name;
			var childs;
			childs=treeData.childs;
			var i=0,len=0;
			len=childs.length;
			var nChild;
			nChild=[];
			for(i=0;i<len;i++){
				nChild.push(TimeLineUtils.fakeTimeLineData(childs[i],rst));
			}
			rst.frames=TimeLineUtils.fakeFrameData();
			rst.childs=nChild;
			rst.isDirectory=nChild.length>0;
			rst.hasChild=nChild.length>0;
			return rst;
		}

		TimeLineUtils.fakeFrameData=function(){
			var frameList;
			frameList=[];
			var tFrameData;
			tFrameData=new TimeFrameData();
			tFrameData.frame=9;
			frameList.push(tFrameData);
			tFrameData=new TimeFrameData();
			tFrameData.frame=10;
			frameList.push(tFrameData);
			tFrameData=new TimeFrameData();
			tFrameData.frame=Math.floor(30*Math.random());
			frameList.push(tFrameData);
			tFrameData=new TimeFrameData();
			tFrameData.frame=Math.floor(30*Math.random());
			frameList.push(tFrameData);
			return frameList;
		}

		TimeLineUtils.getNodeData=function(){
			var rst;
			rst={};
			rst.nodeParent=null;
			rst.name="node";
			rst.data={};
			rst.childs=[];
			return rst;
		}

		TimeLineUtils.addChildTo=function(child,parent){
			parent.childs.push(child);
			child.nodeParent=parent;
		}

		return TimeLineUtils;
	})()


	/**项目配置
	*@author yung
	*/
	//class laya.ide.config.ProjectSetting
	var ProjectSetting=(function(){
		function ProjectSetting(){};
		__class(ProjectSetting,'laya.ide.config.ProjectSetting');
		ProjectSetting.makeSureType=function(labels,pageType){
			(pageType===void 0)&& (pageType="Scene2D");
			if(labels.indexOf(pageType)<0){
				labels+=","+pageType;
			}
			return labels;
		}

		ProjectSetting.getPageTypeLabel=function(){
			var labels;
			labels=laya.ide.config.ProjectSetting.pageTypes.join(",");
			return labels;
		}

		ProjectSetting.isPageType=function(type){
			return ProjectSetting.pageTypes.indexOf(type)>=0;
		}

		ProjectSetting.adptPaths=function(){
			var i=0,len=0;
			var tKey;
			len=ProjectSetting.UiPaths.length;
			for(i=0;i<len;i++){
				tKey=ProjectSetting.UiPaths[i];
				ProjectSetting[tKey]=StringTool$1.trimSide(ProjectSetting[tKey]+"");
			}
			laya.ide.config.ProjectSetting.atlasType=Sys.mParseInt(laya.ide.config.ProjectSetting.atlasType);
			if(!laya.ide.config.ProjectSetting.atlasType)laya.ide.config.ProjectSetting.atlasType=0;
			if(laya.ide.config.ProjectSetting.asynResExportPath==""){
				if(ProjectSetting.codeType==0){
					laya.ide.config.ProjectSetting.asynResExportPath="bin/h5";
					}else{
					laya.ide.config.ProjectSetting.asynResExportPath="bin";
				}
			}
		}

		ProjectSetting.isContainer=function(type){
			return ProjectSetting.boxTypes.indexOf(type)>=0;
		}

		ProjectSetting.codeExportPath="src/game/ui/";
		ProjectSetting.defaultFont="";
		ProjectSetting.codeImportsTS=" ";
		ProjectSetting.resExportPath="bin/h5";
		ProjectSetting.asynResExportPath="bin/h5";
		ProjectSetting.resCanCompress=0;
		ProjectSetting.resPublishQuality=80;
		ProjectSetting.disableBinaryPic=0;
		ProjectSetting.uiType=0;
		ProjectSetting.codeType=0;
		ProjectSetting.picType=0;
		ProjectSetting.atlasType=0;
		ProjectSetting.uiExportPath="bin/ui.json";
		ProjectSetting.shareResPath="";
		ProjectSetting.exportResType="swf";
		ProjectSetting.createSwfType="image";
		ProjectSetting.langPath="";
		ProjectSetting.textureWidth=2048;
		ProjectSetting.textureHeight=2048;
		ProjectSetting.picWidth=512;
		ProjectSetting.picHeight=512;
		ProjectSetting.power2="true";
		ProjectSetting.trimempty="false";
		ProjectSetting.copyRes="true";
		ProjectSetting.dataCompact="true";
		__static(ProjectSetting,
		['resTypes',function(){return this.resTypes=["png","jpg"];},'codeImports',function(){return this.codeImports="import laya.ui.*;import laya.display.*; ";},'codeImportsJS',function(){return this.codeImportsJS="var View=laya.ui.View;\nvar Dialog=laya.ui.Dialog;";},'boxTypes',function(){return this.boxTypes=["Sprite","Box","List","Tab","RadioGroup","ViewStack","Panel","Tree","Vbox","Hbox"];},'pageTypes',function(){return this.pageTypes=["View","Dialog"];},'sceneTypes',function(){return this.sceneTypes=["Scene2D"];},'UiPaths',function(){return this.UiPaths=
			[
			"codeExportPath",
			"resExportPath",
			"asynResExportPath",
			"shareResPath",
			"uiExportPath",
			"codeType",
			"defaultFont",
			"uiType",
			"textureWidth",
			"textureHeight",
			"picWidth",
			"picHeight",
			"power2",
			"trimempty",
			"copyRes",
			"dataCompact",
			"langPath",
			"picType",
			"atlasType"];}
		]);
		return ProjectSetting;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-3-18 上午11:14:51
	*/
	//class laya.ide.config.StyleConsts
	var StyleConsts=(function(){
		function StyleConsts(){}
		__class(StyleConsts,'laya.ide.config.StyleConsts');
		StyleConsts.FolderTxtColor="#c5c5c5";
		StyleConsts.ItemTxtColor="#c5c5c5";
		StyleConsts.ItemSelectColor="#ffffff";
		StyleConsts.MenuButtonLabelColor="#d2d2d2,#d2d2d2,#d2d2d2,#d2d2d2";
		StyleConsts.LayoutTabTitleBtnColor="#8a8a8a,#c8c8c8,#c8c8c8,#c8c8c8";
		StyleConsts.SkinBtnLabelColor="#44a7ff,#44a7ff,#44a7ff,#44a7ff";
		StyleConsts.CheckBoxLabelColors="#c5c5c5,#c5c5c5,#c5c5c5,#c5c5c5";
		StyleConsts.ComboBoxLabelColors="#c5c5c5,#c5c5c5,#c5c5c5,#c5c5c5";
		StyleConsts.PropPanelTitleColor="#44a7ff";
		StyleConsts.TextInputColor="#c5c5c5";
		StyleConsts.TextInputColorDefault="#525252,#ffffff,#efefef";
		StyleConsts.SelectItemInfoColor="#9f9f9f";
		StyleConsts.DefaultTextColor="#c5c5c5";
		StyleConsts.PanelTipTextColor="#00cc00";
		StyleConsts.PanelTipTextColor2="#cccc00";
		StyleConsts.ButtonLabelColors="#efefef,#ffffff,#c5c5c5,#c5c5c5";
		StyleConsts.BroswerButtonLabelColors="#c5c5c5,#c5c5c5,#c5c5c5";
		StyleConsts.RuleGridLineColor="#696969";
		StyleConsts.RuleGridTextColor="#696969";
		StyleConsts.RuleRangeColor="#dddddd";
		StyleConsts.TimelineTitleTxtColor="#d8d8d8";
		StyleConsts.fileNameRestrict="0-9a-zA-Z_";
		StyleConsts.NumberRestrict="0-9.-";
		StyleConsts.IntRestrict="0-9-";
		StyleConsts.DisplayIconWidth=16;
		StyleConsts.DisplayIconHeight=16;
		StyleConsts.AutoAlignLineColor="#00ffff";
		return StyleConsts;
	})()


	/**系统配置
	*@author yung
	*/
	//class laya.ide.config.SystemSetting
	var SystemSetting=(function(){
		function SystemSetting(){};
		__class(SystemSetting,'laya.ide.config.SystemSetting');
		SystemSetting.setProject=function(path){
			if (FileTools.exist(path)){
				SystemSetting.projectPath=path;
				SystemSetting.projectName=FileTools.getFileName(path).replace(".laya","");
				SystemSetting.workPath=FileTools.path.dirname(path);
				SystemSetting.workPath=FileTools.path.dirname(SystemSetting.workPath);
				SystemSetting.pagesPath=FileManager.getWorkPath("laya/pages");
				SystemSetting.assetsPath=FileManager.getWorkPath("laya/assets");
				SystemSetting.stylePath=FileManager.getWorkPath("laya/styles.xml");
				SystemSetting.pageStylePath=FileManager.getWorkPath("laya/pageStyles.xml");
				SystemSetting.tempPath=FileManager.getPath(FileTools.tempApp,"data/"+SystemSetting.projectName)
				FileManager.createDirectory(SystemSetting.pagesPath);
				FileManager.createDirectory(SystemSetting.assetsPath);
				FileManager.createDirectory(SystemSetting.tempPath);
			}
		}

		SystemSetting.workPath="";
		SystemSetting.appPath="";
		SystemSetting.projectName="";
		SystemSetting.projectPath="";
		SystemSetting.pagesPath="";
		SystemSetting.assetsPath="";
		SystemSetting.stylePath="";
		SystemSetting.pageStylePath="";
		SystemSetting.tempResPath="";
		SystemSetting.tempVerPath="";
		SystemSetting.tempPath="";
		SystemSetting.lang="";
		SystemSetting.ifShowRuleGrid=true;
		SystemSetting.toCodeModeWhenPublicEnd=false;
		SystemSetting.autoFocsEditRect=false;
		SystemSetting.IDEFrameType=0;
		SystemSetting.isCMDVer=false;
		return SystemSetting;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-11-26 上午10:04:47
	*/
	//class laya.ide.consts.FilterFuns
	var FilterFuns=(function(){
		function FilterFuns(){}
		__class(FilterFuns,'laya.ide.consts.FilterFuns');
		FilterFuns.isEditorComp=function(comp){
			if (comp !=null && Laya.__typeof(comp,'laya.ui.IComponent')&& comp["comXml"]){
				if((comp.parent instanceof laya.ui.Button )){
				}
				if(Laya.__typeof(comp.parent,'laya.ui.IBox'))
					return true;
			}
			return false;
		}

		FilterFuns.isEditorEnterAble=function(comp){
			if(!comp)return false;
			if(comp["comXml"]){
				if(DisplayTreePanel.AnyItemContains|| Laya.__typeof(comp,'laya.ui.IBox')){
					if(!FilterFuns.isEditorEnterAbleType(comp["comXml"].type))return false;
					return true;
				}
			}
			return false;
		}

		FilterFuns.isEditorEnterAbleType=function(type){
			if(type==TypeManager.GraphicPic&&IDEVars.isNewGraphicAnimationMode)return true;
			if(TypeManager.UnEnterAbleType[type])return false;
			return true;
		}

		FilterFuns.isEditorSelectable=function(comp,ignoreLock,ignoreHide){
			(ignoreLock===void 0)&& (ignoreLock=false);
			(ignoreHide===void 0)&& (ignoreHide=false);
			var data;
			data=comp["comXml"];
			if(comp.name=="panelContent")return true;
			if(!data)return true;
			if(!ignoreLock){
				if(data.hasOwnProperty(Signs.LockSign)&&data[Signs.LockSign])return false;
			}
			if(!ignoreHide){
				if(data.hasOwnProperty(Signs.HideSign)&&data[Signs.HideSign])return false;
			}
			return true;
		}

		FilterFuns.isEditorSelectableChain=function(comp,ignoreLock,ignoreHide){
			(ignoreLock===void 0)&& (ignoreLock=false);
			(ignoreHide===void 0)&& (ignoreHide=false);
			if(!FilterFuns.isEditorSelectable(comp,ignoreLock,ignoreHide))return false;
			return true;
			if(!comp.parent)return true;
			return FilterFuns.isEditorSelectableChain(comp.parent,ignoreLock,ignoreHide);
		}

		FilterFuns.isSpecialRes=function(url){
			if(url.indexOf("$")>0){
				return true;
			}
			if(url.indexOf(".DS_Store")>=0){
				return true;
			}
			return false;
		}

		FilterFuns.isShowResFile=function(url){
			return !FilterFuns.isSpecialRes(url);
		}

		FilterFuns.isUnAnimationAbleType=function(type){
			if(type=="List"||type=="Tree"){
				return true;
			}
			return false;
		}

		FilterFuns.getOnlyAnimationAbleNodes=function(arr){
			var i=0,len=0;
			var tNode;
			var safeNodes={};
			len=arr.length;
			var rst;
			rst=[];
			for(i=0;i<len;i++){
				if(arr[i].isAniNode){
					rst.push(arr[i]);
				}
			}
			return rst;
		}

		FilterFuns.findAnimationAbleNodes=function(parentNode,safeNodes){
			if(!parentNode)return;
			var tType;
			tType=parentNode.type;
		}

		return FilterFuns;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-8-4 上午10:12:53
	*/
	//class laya.ide.consts.IDEConsts
	var IDEConsts=(function(){
		function IDEConsts(){}
		__class(IDEConsts,'laya.ide.consts.IDEConsts');
		IDEConsts.cachePanels=false;
		IDEConsts.showRenderDebug=false;
		return IDEConsts;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-10-21 下午5:02:21
	*/
	//class laya.ide.consts.PageExportType
	var PageExportType=(function(){
		function PageExportType(){}
		__class(PageExportType,'laya.ide.consts.PageExportType');
		PageExportType.init=function(){
			PageExportType.ParticleGravity=Sys.lang("重力模式");
			PageExportType.ParticleRad=Sys.lang("半径模式");
			PageExportType.Particle3D=Sys.lang("粒子3D");
			PageExportType.ParticleTypeList=[PageExportType.ParticleGravity,PageExportType.ParticleRad];
			PageExportType.INCODE=Sys.lang("内嵌模式");
			PageExportType.LOAD_PACK=Sys.lang("加载模式");
			PageExportType.LOAD_ONE=Sys.lang("分离模式");
			PageExportType.typeList=[PageExportType.INCODE,PageExportType.LOAD_PACK,PageExportType.LOAD_ONE];
			PageExportType.typeDic[PageExportType.INCODE]=true;
			PageExportType.typeDic[PageExportType.LOAD_PACK]=true;
			PageExportType.typeDic[PageExportType.LOAD_ONE]=true;
		}

		PageExportType.isOKType=function(type){
			if(PageExportType.typeDic.hasOwnProperty(type))return true;
			return false;
		}

		PageExportType.isLoadType=function(type){
			return type==PageExportType.LOAD_ONE||type==PageExportType.LOAD_PACK;
		}

		PageExportType.ParticleGravity="重力模式";
		PageExportType.ParticleRad="半径模式";
		PageExportType.Particle3D="粒子3D";
		PageExportType.ParticleTypeList=[];
		PageExportType.INCODE="内嵌模式";
		PageExportType.LOAD_PACK="加载模式";
		PageExportType.LOAD_ONE="分离模式";
		PageExportType.typeList=[];
		__static(PageExportType,
		['typeDic',function(){return this.typeDic={
		};}

		]);
		PageExportType.__init$=function(){
			;
			PageExportType.init();
		}

		return PageExportType;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.ide.consts.Paths
	var Paths=(function(){
		function Paths(){}
		__class(Paths,'laya.ide.consts.Paths');
		Paths.getLayoutFilePathByType=function(type){
			return "layout/"+type+".config";
		}

		Paths.getPluginPath=function(plugin){
			return FileManager.getPath(Paths.PluginPath,plugin+"/");
		}

		Paths.getPackParamFile=function(){
			return FileManager.getDataPath("packParam.json");
		}

		Paths.getConfigVarPath=function(){
			return FileManager.getDataPath("builder.cfg");
		}

		Paths.getResTypeConfigPath=function(){
			return FileManager.getDataPath("resconfig.cfg");
		}

		Paths.ParticleTmpGravity="laya/tpls/particle.json";
		Paths.ParticleTmpRadial="laya/tpls/particle1.json";
		Paths.ParticleTmp3D="laya/tpls/particle3d.json";
		Paths.ParticleTmpPoly="laya/tpls/particlepoly.json";
		Paths.ParticleTmpTexture="laya/tpls/texture.png";
		Paths.ParticleDefaultTextureName="texture.png";
		Paths.CustomUIConfigPath="renders/";
		Paths.IDESkinPath="h5/skins/";
		Paths.IDELangPath="h5/langs/";
		Paths.TemplateFolder="laya/template/";
		Paths.BasicsFolder="laya/basics/";
		Paths.TemplateDefaultIcon="laya/tpls/templateIcon.png";
		Paths.PluginPath="h5/plugins/";
		Paths.PluginConfigPath="plugin.cfg";
		Paths.CodeTemplatePath="codeTemplate/";
		Paths.AirTool="libs/LayaAirTool/LayaAirTool";
		Paths.IDEConfigFile="builder.xml";
		Paths.IDEConfigVars="builder.cfg";
		Paths.IDEResTypeConfig="resconfig.cfg";
		Paths.LogFile="log.txt";
		Paths.PackParamFile="packParam.json";
		Paths.LayoutFile_Default="layout/layout.config";
		Paths.LayoutFile_Static="laya/tpls/default.config";
		__static(Paths,
		['JSCodeTemplate',function(){return this.JSCodeTemplate="codeTemplate/"+"jsCodeTpl.txt";},'JSCodePreTemplate',function(){return this.JSCodePreTemplate="codeTemplate/"+"jsCodePre.txt";},'TSCodeTemplate',function(){return this.TSCodeTemplate="codeTemplate/"+"tsCodeTpl.txt";},'TSCodePreTemplate',function(){return this.TSCodePreTemplate="codeTemplate/"+"tsCodePre.txt";},'ASCodeTemplate',function(){return this.ASCodeTemplate="codeTemplate/"+"asCodeTpl.txt";},'ASCodeTemplate2',function(){return this.ASCodeTemplate2="codeTemplate/"+"asCodeTpl2.txt";},'ASBase64Template',function(){return this.ASBase64Template="codeTemplate/"+"asBase64Tpl.txt";}
		]);
		return Paths;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-11-25 上午11:08:41
	*/
	//class laya.ide.consts.Signs
	var Signs=(function(){
		function Signs(){}
		__class(Signs,'laya.ide.consts.Signs');
		Signs.LockSign="$LOCKED";
		Signs.HideSign="$HIDDEN";
		Signs.NodeTypeSign="renderType";
		return Signs;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.ide.consts.SkinDefines
	var SkinDefines=(function(){
		function SkinDefines(){}
		__class(SkinDefines,'laya.ide.consts.SkinDefines');
		SkinDefines.DisDragIcon="comp/clip_folder.png";
		SkinDefines.PageDragIcon="comp/clip_folder.png";
		SkinDefines.ResDragIcon="comp/clip_folder.png";
		SkinDefines.LayoutRecDragIcon="comp/clip_folder.png";
		SkinDefines.LayoutTabDragIcon="comp/clip_folder.png";
		return SkinDefines;
	})()


	/**
	*本地程序调用封装
	*@author ww
	*@version 1.0
	*
	*@created 2015-10-30 下午3:27:37
	*/
	//class laya.ide.devices.CMDShell
	var CMDShell=(function(){
		function CMDShell(){}
		__class(CMDShell,'laya.ide.devices.CMDShell');
		CMDShell.init=function(){
			CMDShell.childProcess=Device.require("child_process");
			CMDShell.iconv=Device.require('iconv-lite');
		}

		CMDShell.exeFile=function(fileName,param,callBack){
			CMDShell.childProcess.execFile(fileName,param,callBack);
		}

		CMDShell.execute=function(cmd,callBack,option){
			console.log("execute:",cmd);
			if(!option){
				option={encoding:"binary",maxBuffer:1024*1024*20};
			}
			CMDShell.childProcess.exec(cmd,option,callBack);
		}

		CMDShell.callBackTmp=function(err,stdOut,stdErr){
			console.log("err:",err);
			console.log("stdErr:",stdErr);
			console.log("stdOut:",CMDShell.iconv.decode(stdOut,"gbk"));
		}

		CMDShell.executeExtra=function(cmd,callBack){
			CMDShell.childProcess.exec(cmd,{encoding:"binary",maxBuffer:1024*1024*20},callBackTmp=function(err,stdOut,stdErr){
				console.log("err:",err);
				console.log("stdErr:",stdErr);
				callBack(CMDShell.iconv.decode(stdOut,"gbk"));
			});
		}

		CMDShell.decode=function(data,type){
			return CMDShell.iconv.decode(data,type);
		}

		CMDShell.childProcess=null
		CMDShell.iconv=null
		return CMDShell;
	})()


	/**
	*封装所有驱动级接口
	*@author yung
	*/
	//class laya.ide.devices.Device
	var Device=(function(){
		function Device(){};
		__class(Device,'laya.ide.devices.Device');
		Device.init=function(){
			Device.electron=Device.require("electron");
			Device.remote=Device.electron.remote;
			Device.app=Device.remote.app;
			Device.dataPath=laya.ide.devices.Device.app.getPath("appData")+"/"+Device.appName;;
			Device.Buffer=Browser.window.Buffer;
			Device.appPath=Device.app.getPath("appData")+"/"+Device.appName;
			Device.tempPath=Device.app.getPath("temp")+"/"+Device.appName;
			Device.userHome=Device.app.getPath("home")+"/"+Device.appName;
			Device.extensionPath=Device.app.getPath("home")+"/"+".laya/plugins/";
			Sys.log("appPath:",Device.appPath);
			Sys.log("extensionPath:",Device.extensionPath);
			Paths.PluginPath=Device.extensionPath;
			Sys.log("PluginPath:",Paths.PluginPath);
			Device.app.on('quit',function(){
				console.log("quit from app");
			});
		}

		Device.winFun=function(fun){
			if(!Device.win){
				Device.win=Device.remote.getCurrentWindow();
			}
			Device.win[fun]();
		}

		Device.require=function(mod){
			var rst;
			rst=require(mod);
			return rst;
		}

		Device.requireRemote=function(mod){
			if (!Device.remote)return Device.require(mod);
			return Device.remote[mod];
			return Device.remote.require(mod);
		}

		Device.app=null
		Device.appName="LayaAirIDE";
		Device.appPath=null
		Device.dataPath=null
		Device.tempPath=null
		Device.workPath=null
		Device.userHome=null
		Device.extensionPath=null
		Device.remote=null
		Device.Buffer=null
		Device.electron=null
		Device.win=null
		return Device;
	})()


	/**
	*本类封装弹出本地对话框
	*@author ww
	*/
	//class laya.ide.devices.DialogTools
	var DialogTools=(function(){
		function DialogTools(){}
		__class(DialogTools,'laya.ide.devices.DialogTools');
		DialogTools.init=function(){
			DialogTools.dialog=Device.requireRemote("dialog");
		}

		DialogTools.showOpenDialog=function(win,options,callBack){
			DialogTools.dialog.showOpenDialog(win,options,callBack);
		}

		DialogTools.showSaveDialog=function(win,options,callBack){
			DialogTools.dialog.showSaveDialog(win,options,callBack);
		}

		DialogTools.showSave=function(title,fileName,callBack){
			var option={
				title:title,
				defaultPath:fileName,
				filters:[],
				properties:[]
			};
			DialogTools.showSaveDialog(null,option,callBack);
		}

		DialogTools.showMessageBox=function(win,options,callBack){
			return DialogTools.dialog.showMessageBox(win,options,callBack);
		}

		DialogTools.showErrorBox=function(title,content){
			DialogTools.dialog.showErrorBox(title,content);
		}

		DialogTools.getOpenDirO=function(title,defaultPath){
			(title===void 0)&& (title="open Dir");
			var rst;
			rst={title:title,properties:["openDirectory"]};
			if(defaultPath!=null){
				rst.defaultPath=defaultPath;
			}
			return rst;
		}

		DialogTools.getOpenProO=function(title,extension){
			(title===void 0)&& (title="open Project");
			(extension===void 0)&& (extension="laya");
			return {title:title,filters:[{name:'*.'+extension,extensions:[extension]}]};
		}

		DialogTools.showOpenDir=function(title,callBack,defaultPath){
			(title===void 0)&& (title="open Dir");
			DialogTools.showOpenDialog(null,DialogTools.getOpenDirO(title,defaultPath),callBack);
		}

		DialogTools.showOpenFile=function(title,callBack,filter,defaultPath){
			(title===void 0)&& (title="open file");
			if (!filter)filter=DialogTools.filterO;
			filter.title=title;
			if(defaultPath){
				filter.defaultPath=defaultPath;
			}
			DialogTools.showOpenDialog(null,filter,callBack);
		}

		DialogTools.getOpenParticleO=function(title){
			(title===void 0)&& (title="open Particle");
			return {title:title,filters:[{name:'*.json',extensions:['json']}]};
		}

		DialogTools.dialog=null
		__static(DialogTools,
		['tempOptionO',function(){return this.tempOptionO={
				title:"",
				defaultPath:null,
				filters:[],
				properties:[]
		};},'imgFilterO',function(){return this.imgFilterO={title:"open Img",filters:[{name:'Images',extensions:['jpg','png']}]};},'filterO',function(){return this.filterO={title:"open file",filters:[{name:'Images',extensions:['jpg','png','gif']},{name:'Movies',extensions:['mkv','avi','mp4']},{name:'Custom File Type',extensions:['as']},{name:'All Files',extensions:['*']}]};}

		]);
		return DialogTools;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.ide.devices.File
	var File=(function(){
		function File(path){
			this.nativePath=null;
			this.nativePath=path;
		}

		__class(File,'laya.ide.devices.File');
		var __proto=File.prototype;
		__proto.copyTo=function(path,overwrite){
			(overwrite===void 0)&& (overwrite=false);
			FileTools.copyE(this.nativePath,path);
		}

		__proto.deleteFile=function(){
			FileTools.removeE(this.nativePath);
		}

		__proto.moveToTrash=function(){
			this.deleteFile();
		}

		__proto.getRelativePath=function(path){
			return FileTools.getRelativePath(this.nativePath,path);
		}

		__proto.moveTo=function(path,overwrite){
			(overwrite===void 0)&& (overwrite=false);
			FileTools.rename(this.nativePath,path);
		}

		__proto.resolvePath=function(path){
			return new File(FileTools.getPath(this.nativePath,path));
		}

		__getset(0,__proto,'extension',function(){
			return FileTools.getExtensionName(this.nativePath);
		});

		__getset(0,__proto,'isDirectory',function(){
			return FileTools.isDirectory(this.nativePath);
		});

		__getset(0,__proto,'parent',function(){
			return new File(FileTools.getParent(this.nativePath));
		});

		__getset(0,__proto,'exists',function(){
			return FileTools.exist(this.nativePath);
		});

		__getset(0,__proto,'name',function(){
			return FileTools.getFileNameWithExtension(this.nativePath);
		});

		__static(File,
		['applicationDirectory',function(){return this.applicationDirectory=new File("");},'applicationStorageDirectory',function(){return this.applicationStorageDirectory=new File("");},'userDirectory',function(){return this.userDirectory=new File("");}
		]);
		return File;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.ide.devices.FileTools
	var FileTools=(function(){
		function FileTools(){}
		__class(FileTools,'laya.ide.devices.FileTools');
		__getset(1,FileTools,'appPath',function(){
			var rst;
			var dirName;
			dirName=__dirname;;
			rst=FileTools.path.resolve(dirName,"../");
			return rst;
			var aPath;
			aPath=Browser.window.location.href;
			aPath=aPath.replace("file:///","");
			aPath=aPath.replace("/h5/index.html","");
			aPath=aPath.split("index.")[0];
			aPath=decodeURI(aPath);
			return aPath;
		});

		__getset(1,FileTools,'workPath',function(){
			return "workPath";
		});

		FileTools.init=function(){
			FileTools.fs=Device.require("fs");
			FileTools.path=Device.require("path");
			FileTools.shell=Device.requireRemote("shell");
			FileTools.tempApp=Device.dataPath;
		}

		FileTools.init2=function(){
			FileTools.fs=Device.require("fs");
			FileTools.path=Device.require("path");
		}

		FileTools.getSep=function(){
			return FileTools.path.sep;
		}

		FileTools.getPathSep=function(path){
			var rst;
			rst="/";
			if (path.indexOf(rst)>=0)return rst;
			rst="\\";
			if (path.indexOf(rst)>=0)return rst;
			return FileTools.getSep();
		}

		FileTools.getAbsPath=function(path){
			return path;
		}

		FileTools.isAbsPath=function(path){
			if(!path)return false;
			if(path.indexOf(":")>0)return true;
			if(path.substr(0,1)=="/")return true;
			return false;
		}

		FileTools.getPath=function(basePath,relativePath){
			return FileTools.path.join(basePath,relativePath);
		}

		FileTools.getRelativePath=function(basePath,targetPath){
			return FileTools.path.relative(basePath,targetPath);
		}

		FileTools.getAppPath=function(path){
			return FileTools.getPath(FileTools.appPath,path);
		}

		FileTools.getAppRelativePath=function(path){
			return FileTools.getRelativePath(FileTools.appPath,path);
		}

		FileTools.getWorkPath=function(path){
			return FileTools.getPath(FileTools.workPath,path);
		}

		FileTools.getWorkRelativePath=function(path){
			return FileTools.getRelativePath(FileTools.workPath,path);
		}

		FileTools.getFileDir=function(path){
			if (!path)return path;
			if(laya.ide.devices.FileTools.isDirectory(path))return path;
			return laya.ide.devices.FileTools.path.dirname(path);
		}

		FileTools.getParent=function(path){
			if (!path)return path;
			var lasti=0;
			lasti=path.lastIndexOf(laya.ide.devices.FileTools.path.sep);
			return path.substring(0,lasti);
		}

		FileTools.getFileName=function(path){
			return FileManager.getFileName(path);
		}

		FileTools.getFileNameWithExtension=function(path){
			if (path==null)
				return null;
			var a=path.split(laya.ide.devices.FileTools.path.sep);
			var file=a[a.length-1];
			return file;
		}

		FileTools.getExtensionName=function(path){
			if (path==null)
				return null;
			var a=path.split(".");
			var file=a[a.length-1];
			return file;
		}

		FileTools.createDirectory=function(path){
			if (Boolean(path)){
				FileTools.ensurePath(path);
				if (!FileTools.fs.existsSync(path)){
					FileTools.fs.mkdirSync(path);
				}
			}
		}

		FileTools.ensurePath=function(pathStr){
			FileTools.mkdirsSync(pathStr,null);
			return;
			if (pathStr==null)return;
			var sep;
			sep=FileTools.path.sep;
			var a=pathStr.split(sep);
			var i=0,len=0;
			var tPath;
			tPath=a[0];
			len=a.length-1;
			for (i=1;i < len;i++){
				tPath+=sep+a[i];
				if (!FileTools.exist(tPath)){
					FileTools.createDirectory(tPath);
				}
			}
		}

		FileTools.mkdirsSync=function(dirpath,mode){
			if (!FileTools.fs.existsSync(dirpath)){
				var pathtmp;
				var pathParts=dirpath.split(FileTools.getPathSep(dirpath));
				pathParts.pop();
				var onWindows=Browser.userAgent.indexOf("Windows")>-1;
				if(!onWindows){
					pathtmp="/"+pathParts[1];
					pathParts.splice(0,2);
				}
				pathParts.forEach(function(dirname){
					if (pathtmp){
						pathtmp=FileTools.path.join(pathtmp,dirname);
					}
					else {
						pathtmp=dirname;
					}
					if (!FileTools.fs.existsSync(pathtmp)){
						if (!FileTools.fs.mkdirSync(pathtmp,mode)){
							return false;
						}
					}
				});
			}
			return true;
		}

		FileTools.createFile=function(path,value){
			FileTools.ensurePath(path);
			FileTools.fs.writeFileSync(path,value);
		}

		FileTools.toBuffer=function(ab){
			var buffer=new Device.Buffer(ab.byteLength);
			var view=new Uint8Array(ab);
			for (var i=0;i < buffer.length;++i){
				buffer[i]=view[i];
			}
			return buffer;
		}

		FileTools.readFile=function(path,encoding){
			(encoding===void 0)&& (encoding="utf8");
			if (FileTools.fs.existsSync(path)){
				var rst;
				rst=FileTools.fs.readFileSync(path,encoding);
				if(((typeof rst=='string'))&&rst.charCodeAt(0)==65279&&encoding=="utf8"){
					rst=rst.substr(1);
				}
				return rst;
			}
			return null;
		}

		FileTools.appendFile=function(path,data){
			FileTools.fs.appendFileSync(path,data);
		}

		FileTools.moveToTrash=function(path){
			if (FileTools.exist(path)){
				if (FileTools.shell){
					FileTools.shell.moveItemToTrash(path);
					}else{
					FileTools.removeE(path,false);
				}
			}
		}

		FileTools.removeFile=function(path,toTrash){
			(toTrash===void 0)&& (toTrash=true);
			if (toTrash){
				FileTools.moveToTrash(path);
				return;
			}
			if (Boolean(path)){
				FileTools.fs.unlinkSync(path)
			}
		}

		FileTools.removeE=function(path,toTrash){
			(toTrash===void 0)&& (toTrash=true);
			if (!FileTools.exist(path))
				return;
			if (FileTools.isDirectory(path)){
				FileTools.removeDir(path,toTrash);
			}
			else{
				FileTools.removeFile(path,toTrash);
			}
		}

		FileTools.removeDir=function(path,toTrash){
			(toTrash===void 0)&& (toTrash=true);
			if (toTrash){
				FileTools.moveToTrash(path);
				return;
			};
			var files=[];
			if (FileTools.fs.existsSync(path)){
				files=FileTools.fs.readdirSync(path);
				files.forEach(function(file,index){
					var curPath=FileTools.getPath(path,file);
					if (FileTools.fs.statSync(curPath).isDirectory()){
						FileTools.removeDir(curPath);
					}
					else{
						FileTools.fs.unlinkSync(curPath);
					}
				});
				FileTools.fs.rmdirSync(path);
			}
		}

		FileTools.exist=function(path){
			if(!path)return false;
			return FileTools.fs.existsSync(path);
		}

		FileTools.isDirSimple=function(path){
			if(!path)return false;
			path=FileManager.adptToCommonUrl(path);
			var arrs;
			arrs=path.split("/");
			return arrs[arrs.length-1].indexOf(".")<0;
		}

		FileTools.isDirectory=function(path){
			path=FileManager.adptToCommonUrl(path);
			var st;
			try{
				st=FileTools.fs.statSync(path);
				}catch(e){
				return FileTools.isDirSimple(path);
				return false;
			}
			if(!st)return false;
			return st.isDirectory();
		}

		FileTools.getStat=function(path){
			return FileTools.fs.statSync(path);
		}

		FileTools.getMTime=function(path){
			if(!FileTools.exist(path))return "";
			return FileTools.getStat(path).mtime;
		}

		FileTools.watch=function(path,callBack){
			FileTools.watcherDic[path]=FileTools.fs.watch(path,callBack);
			return FileTools.watcherDic[path];
		}

		FileTools.isDirWatched=function(path){
			return FileTools.watcherDic.hasOwnProperty(path);
		}

		FileTools.unwatch=function(path){
			if (FileTools.watcherDic[path]){
				FileTools.watcherDic[path].close();
				delete FileTools.watcherDic[path];
			}
		}

		FileTools.copyE=function(from,to){
			if (!FileTools.exist(from))
				return;
			if (FileTools.isDirectory(from)){
				FileTools.copyDir(from,to);
			}
			else{
				FileTools.copyFile(from,to);
			}
		}

		FileTools.copyFile=function(from,to){
			FileTools.createFile(to,FileTools.readFile(from,null));
		}

		FileTools.copyDir=function(from,to){
			var files=[];
			if (FileTools.fs.existsSync(from)){
				FileTools.createDirectory(to);
				files=FileTools.fs.readdirSync(from);
				files.forEach(function(file,index){
					var curPath=FileTools.getPath(from,file);
					var tPath=FileTools.getPath(to,file);
					if (FileTools.fs.statSync(curPath).isDirectory()){
						FileTools.copyDir(curPath,tPath);
					}
					else{
						FileTools.copyFile(curPath,tPath);
					}
				});
			}
		}

		FileTools.walk=function(path,floor,handleFile,self){
			(self===void 0)&& (self=false);
			if(self)
				handleFile(path,floor);
			floor++;
			var files=FileTools.fs.readdirSync(path);
			files.forEach(function(item){
				var tmpPath=FileTools.getPath(path,item);
				if (tmpPath.indexOf(".svn")>-1)
					return;
				var stats=FileTools.fs.statSync(tmpPath);
				if (stats.isDirectory()){
					FileTools.walk(tmpPath,floor,handleFile);
				}
				else{
					handleFile(tmpPath,floor);
				}
			});
		}

		FileTools.getFileList=function(path){
			var arr=[];
			if(!laya.ide.devices.FileTools.exist(path))return arr;
			FileTools.walk(path,0,findFiles);
			function findFiles (spath,floor){
				arr.push(spath);
			}
			return arr;
		}

		FileTools.getFileDesO=function(path){
			if (!FileTools.exist(path))
				return null;
			var rst={};
			rst.label=FileTools.getFileName(path);
			rst.path=path;
			if (FileTools.isDirectory(path)){
				rst.files=[];
				rst.dirs=[];
				rst.childs=[];
				rst.isDirectory=true;
				}else{
				rst.isDirectory=false;
			}
			return rst;
		}

		FileTools.getDirChildDirs=function(p){
			var files=laya.ide.devices.FileTools.getDirFiles(p);
			var i=0,len=0;
			var rst;
			rst=[];
			len=files.length;
			for(i=0;i<len;i++){
				files[i]=FileTools.path.join(p,files[i]);
				if(laya.ide.devices.FileTools.isDirectory(files[i])){
					rst.push(files[i]);
				}
			}
			return rst;
		}

		FileTools.getDirFiles=function(path){
			var rst;
			rst=FileTools.fs.readdirSync(path);
			rst.sort(FileTools.folderFirst);
			return rst;
		}

		FileTools.folderFirst=function(pathA,pathB){
			var isFolderA=false;
			isFolderA=pathA.indexOf(".")<0;
			var isFolderB=false;
			isFolderB=pathB.indexOf(".")<0;
			var right=-1;
			if(isFolderA){
				if(!isFolderB){
					return right;
				}
				return pathA<pathB?right:-right;
			}
			if(isFolderB){
				return-right;
			}
			return pathA<pathB?right:-right;
		}

		FileTools.getFileTreeArr=function(path){
			var tTreeO=FileTools.getFileTreeO(path);
			var rst=[];
			FileTools.getTreeArr(tTreeO,rst,false);
			return rst;
		}

		FileTools.getTreeArr=function(treeO,arr,add){
			(add===void 0)&& (add=true);
			if(add)
				arr.push(treeO);
			var tArr=treeO.childs;
			var i=0,len=tArr.length;
			for(i=0;i<len;i++){
				if(!add){
					tArr[i].nodeParent=null;
				}
				if(tArr[i].isDirectory){
					FileTools.getTreeArr(tArr[i],arr);
					}else{
					arr.push(tArr[i]);
				}
			}
		}

		FileTools.getFileTreeO=function(path){
			var rst=FileTools.getFileDesO(path);
			if (FileTools.fs.existsSync(path)){
				var files=FileTools.getDirFiles(path);
				var tO;
				files.forEach(function(file,index){
					var curPath=FileTools.getPath(path,file);
					if (FileTools.fs.statSync(curPath).isDirectory()){
						tO=FileTools.getFileTreeO(curPath);
						tO.nodeParent=rst;
						tO.hasChild=tO.childs.length > 0;
						rst.dirs.push(tO);
					}
					else{
						tO=FileTools.getFileDesO(curPath);
						tO.nodeParent=rst;
						tO.hasChild=false;
						rst.files.push(tO);
					}
					tO.label=file;
					rst.childs.push(tO);
				});
				rst.hasChild=rst.childs.length > 0;
			}
			return rst;
		}

		FileTools.isPathSame=function(a,b){
			if(a.toLocaleLowerCase()==b.toLocaleLowerCase())return true;
			return false;
		}

		FileTools.rename=function(oldPath,newPath){
			if (!FileTools.exist(oldPath))
				return;
			if(FileTools.isPathSame(oldPath,newPath)){
				Alert.show(Sys.lang("在移动文件到同一个位置！！"));
				return;
			}
			FileTools.copyE(oldPath,newPath);
			FileTools.moveToTrash(oldPath);
			return;
			FileTools.fs.renameSync(oldPath,newPath);
		}

		FileTools.openItem=function(path){
			FileTools.shell.openItem(path);
		}

		FileTools.showItemInFolder=function(path){
			FileTools.shell.showItemInFolder(path);
		}

		FileTools.getFolder=function(path){
			path=FileManager.adptToCommonUrl(path);
			var idx=0;
			idx=path.lastIndexOf(".");
			if(idx>=0){
				idx=path.lastIndexOf("/",idx);
				if(idx>=0){
					path=path.substr(0,idx);
				}
			}
			return path;
		}

		FileTools.win=null
		FileTools.fs=null
		FileTools.path=null
		FileTools.shell=null
		FileTools.tempApp=null
		FileTools.watcherDic={};
		return FileTools;
	})()


	/**
	*本类用于和主进程通讯
	*@author ww
	*/
	//class laya.ide.devices.IPCTools
	var IPCTools=(function(){
		function IPCTools(){}
		__class(IPCTools,'laya.ide.devices.IPCTools');
		IPCTools.init=function(){
			IPCTools.ipc=Device.electron.ipcRenderer;
			IPCTools.ipc.on("message",function(__args){
				var args=arguments;
				console.log("message:",args);
			})
			IPCTools.ipc.on("tryOpen",function(__args){
				var args=arguments;
				var path;
				path=args[0];
				console.log("tryOpen:",path);
				if(FileTools.getExtensionName(path)=="laya"){
					Laya.timer.once(2000,null,ProjectManager.loadProject,[path]);
				}
			})
			IPCTools.ipc.on('openWork',function(event,message){
				SystemDragOverManager.handlerFile(message);
			})
		}

		IPCTools.send=function(type,data){
			IPCTools.ipc.send("message",type,data);
		}

		IPCTools.cmd=function(funName,param){
			var data={};
			data.type;
			data.funName=funName;
			data.param=param;
			IPCTools.send("cmd",data);
		}

		IPCTools.setWindow=function(){
			var data={};
			data.type="ccc";;
			IPCTools.send("window",Browser.window);
			console.log(data);
		}

		IPCTools.ipc=null
		return IPCTools;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2017-2-20 下午5:27:36
	*/
	//class laya.ide.devices.SaveUnSavedDialog
	var SaveUnSavedDialog=(function(){
		function SaveUnSavedDialog(){
			this.layaPageSaveAndCallBackResult=3;
			this.tempFunction={};
			this.event=null;
		}

		__class(SaveUnSavedDialog,'laya.ide.devices.SaveUnSavedDialog');
		var __proto=SaveUnSavedDialog.prototype;
		__proto.layaPageSaveAndCallBack=function(saveHandler,nosaveHandler){
			this.tempFunction.save=saveHandler;
			this.tempFunction.nosave=nosaveHandler;
			if (this.layaPageSaveAndCallBackResult==3){
				var obj={};
				obj.title="LayaAir";
				obj.message=Sys.lang("UI页面还未保存，是否保存这些修改？");
				obj.type="warning";
				obj.detail=Sys.lang("如果不保存，更改将丢失");
				obj.buttons=[Sys.lang("保存(&S)"),Sys.lang("不保存(&N)"),Sys.lang("取消")];
				obj.cancelId=2;
				obj.noLink=true;
				var show=DialogTools.showMessageBox(Device.remote.getCurrentWindow(),obj);
				if (show==2){
					this.event.returnValue=false;
					}else if (show==0){
					this.tempFunction.save();
					}else {
					this.tempFunction.nosave();
				}
			}
		}

		__static(SaveUnSavedDialog,
		['I',function(){return this.I=new SaveUnSavedDialog();}
		]);
		return SaveUnSavedDialog;
	})()


	/**
	*本类集中定义IDE中的各种事件
	*@author ww
	*/
	//class laya.ide.event.IDEEvent
	var IDEEvent=(function(){
		function IDEEvent(){}
		__class(IDEEvent,'laya.ide.event.IDEEvent');
		IDEEvent.emitKeyEvent=function(keyCode,ctrl,shift){
			(ctrl===void 0)&& (ctrl=false);
			(shift===void 0)&& (shift=false);
			var evt;
			evt={};
			evt.keyCode=keyCode;
			evt.ctrlKey=ctrl;
			evt.shiftKey=ctrl;
			Notice.notify("IDEKey_Event",evt);
		}

		IDEEvent.RELEASE_PROJECT="Release_Project";
		IDEEvent.RES_ITEM_CLICK="ResItemClick";
		IDEEvent.OPEN_ADDPARTICLE="open_AddParticle";
		IDEEvent.ADD_PARTICLE="AddParticle";
		IDEEvent.OPEN_ADDPAGE="OPEN_ADDPage";
		IDEEvent.ADD_PAGE="ADDPage";
		IDEEvent.ADD_SCRIPT="addScript";
		IDEEvent.OPEN_ADD_TIMELINE_ANIMATION="OPEN_ADD_TIMELINE_ANIMATION";
		IDEEvent.ADD_TIMELINE_ANIMATION="ADDTimeLineAnimation";
		IDEEvent.ADD_Effect_ANIMATION="ADDEffectAnimation";
		IDEEvent.CLOSE_PAGE="closePage";
		IDEEvent.OPEN_PAGE="openPAGE";
		IDEEvent.FOCUS_DESIGN="Focus_design";
		IDEEvent.FRESH_RES="FRESH_RES";
		IDEEvent.FRESH_PAGE="FRESH_Page";
		IDEEvent.FRESH_CURVIEW="FRESH_CurView";
		IDEEvent.FRESH_PICCHANGED="Fresh_picChanged";
		IDEEvent.OPEN_ADDDIR="open_adddir";
		IDEEvent.ADD_DIR="adddir";
		IDEEvent.OPEN_ADDSCENE="OPEN_ADDSCENE";
		IDEEvent.ADD_SCENE="ADDSCENE";
		IDEEvent.OPEN_MOVEPAGE="OPEN_MovePage";
		IDEEvent.OPEN_BASICSPANEL="Open_BasicsPanel";
		IDEEvent.MOVE_PAGE="MovePage";
		IDEEvent.OPEN_RENAME="OPEN_RENAME";
		IDEEvent.RENAME_PAGE="RENAME_PAGE";
		IDEEvent.OPEN_SETPAGEPROP="OPEN_SEtPageProp";
		IDEEvent.PROPPANEL_SETBYOBJ="PropPanel_setByObj";
		IDEEvent.PROPPANEL_INITBYOBJ="PROPPANEL_InitBYOBJ";
		IDEEvent.PROP_CHANGE="Prop_change";
		IDEEvent.PROP_CHANGEING="Prop_changeing";
		IDEEvent.PROP_FORCESET="PROP_FORCESET";
		IDEEvent.PROP_CHANGED="Prop_Changed";
		IDEEvent.CUTOFF_PREFAB="CutOff_Prefab";
		IDEEvent.DROP_RENDER="DROP_RENDER";
		IDEEvent.PAGE_CHANGED="pageChanged";
		IDEEvent.IDE_QUIT="IDE_QUIT";
		IDEEvent.RESFILE_CHANGE="RESFILE_CHANGE";
		IDEEvent.SHOW_DISPLAY_TREE="SHOW_DISPLAY_TREE";
		IDEEvent.DISPLAY_SELECTED="Display_selected";
		IDEEvent.DISPLAY_MULTISELECTED="Display_multiSelected";
		IDEEvent.SELECT_CHANGED="select_changed";
		IDEEvent.SELECTED_NODES="SELECTED_NODES";
		IDEEvent.DISPLAY_ENTER="Display_Enter";
		IDEEvent.DELETE_SELECTED="DELETE_SELECTED";
		IDEEvent.NODE_DELETED="Node_deleted";
		IDEEvent.DISPLAY_CUT="Display_Cut";
		IDEEvent.DISPLAY_COPY="DISPLAY_Copy";
		IDEEvent.DISPLAY_PASTE="DISPLAY_Paste";
		IDEEvent.ADD_NODE="AddNode";
		IDEEvent.ADD_NODE_BY_DRAGDROP="Add_node_byDragDrop";
		IDEEvent.DISPLAY_TRANSPARENT="Display_transParent";
		IDEEvent.DISPLAYTREE_DRAGDROP="DisplayTree_dragDrop";
		IDEEvent.DISPLAY_VALUE_CHANGE="display_value_changes";
		IDEEvent.DISPLAY_TREE_CHANGE="Display_tree_change";
		IDEEvent.TIMELINE_FRAME_SELECTED="TimeLineFrameSelected";
		IDEEvent.RECORD_KEYFRAME="RECORD_KEYFRAME";
		IDEEvent.DESIGN_ITEM_SELECTED="DesignItemSelected";
		IDEEvent.CLEAR_DESIGN_SELECT="ClearDesignSelect";
		IDEEvent.TIMELINE_CHANGED="TimeLine_changed";
		IDEEvent.TO_ANIMATION_MODE="To_AnimationMode";
		IDEEvent.TO_DESIGN_MODE="To_designMode";
		IDEEvent.FRESH_ANIMATIONDATA="Fresh_animationData";
		IDEEvent.ANIMATIONMODE_CHANGE="AnimationMode_Change";
		IDEEvent.ADD_ANIMATIONNODE="Add_animationNode";
		IDEEvent.PLAYCONTROL_TOBEGINPOS="PlayControl_ToBeginPos";
		IDEEvent.PLAYCONTROL_PRE="PLAYCONTROL_Pre";
		IDEEvent.PLAYCONTROL_PLAY="PLAYCONTROL_Play";
		IDEEvent.PLAYCONTROL_NEXT="PLAYCONTROL_Next";
		IDEEvent.PLAYCONTROL_TOENDPOS="PLAYCONTROL_TOEndPOS";
		IDEEvent.PLAYCONTROL_STOP="PLAYCONTROL_Stop";
		IDEEvent.PLAYCONTROL_SWITCHPLAY="PLAYCONTROL_SwitchPlay";
		IDEEvent.UIChange="UIChange";
		IDEEvent.FRESH_COMPPANEL="Fresh_CompPanel";
		IDEEvent.SHOW_RULE_RANGE="SHOW_RULE_RANGE";
		IDEEvent.CLEAR_RULE_RANGE="Clear_RULE_RANGE";
		IDEEvent.RULE_SHOW_CHANGE="RULE_SHOW_CHANGE";
		IDEEvent.OPEN_LANGPANEL="LangPanel";
		IDEEvent.OPEN_IDESETTING="OPEN_IDESETTING";
		IDEEvent.CLOSE_IDESETTING="CLOSE_IDESETTING";
		IDEEvent.IDEKEY_EVENT="IDEKey_Event";
		IDEEvent.SELECT_RES_FILE="SelecteResFile";
		IDEEvent.SHOW_LAYOUTTAB_BY_NAME="SHOW_LayoutTab_By_Name";
		IDEEvent.FIND_RES_REFER="findResRefer";
		IDEEvent.REPLACE_SELECTEDCOMPS="REPLACE_SELECTEDCOMPS";
		IDEEvent.SELECT_INPUT="SELECTE_INPUT";
		IDEEvent.CLIP_VIEW="CLIP_VIEW";
		return IDEEvent;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-6-12 下午7:47:10
	*/
	//class laya.ide.event.IDEVars
	var IDEVars=(function(){
		function IDEVars(){}
		__class(IDEVars,'laya.ide.event.IDEVars');
		__getset(1,IDEVars,'isGraphicAnimationMode',function(){
			if(UIPanel.instance.currViewer&&TypeManager.getFileType(UIPanel.instance.currViewer.pagePath)=="graphic_animation"){
				return true;
			}
			return false;
		});

		__getset(1,IDEVars,'isPageView',function(){
			if(UIPanel.instance.currViewer&&TypeManager.getFileType(UIPanel.instance.currViewer.pagePath)=="page"){
				return true;
			}
			return false;
		});

		__getset(1,IDEVars,'isNewGraphicAnimationMode',function(){
			return IDEVars.isGraphicAnimationMode&&IDEVars.enableNewAnimation;
		});

		// public static var enableAutoAlign:Boolean=true;
		__getset(1,IDEVars,'enableAutoAlign',function(){
			return KeyManager.I.isCommandKeyDown;
		});

		IDEVars.isAnimationEditMode=false;
		IDEVars.enableNewAnimation=false;
		IDEVars.cacheBothTreeAndAnimation=false;
		return IDEVars;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2017-5-27 上午11:25:49
	*/
	//class laya.ide.hook.KeyBoardHook
	var KeyBoardHook=(function(){
		function KeyBoardHook(){}
		__class(KeyBoardHook,'laya.ide.hook.KeyBoardHook');
		KeyBoardHook.hook=function(){
			KeyBoardManager["_addEvent"]=KeyBoardHook._addEvent;
		}

		KeyBoardHook._addEvent=function(type){
			Browser.document.addEventListener(type,function(e){
				if(KeyBoardHook.hasOverLays())return;
				KeyBoardManager["_dispatch"](e,type);
			},true);
		}

		KeyBoardHook.hasOverLays=function(){
			if(Browser.window.hasOwnProperty("codeDivPopLayer")){
				return Browser.window["codeDivPopLayer"];
			}
			return Browser.document.getElementsByClassName("compressJSFile").length>0;
		}

		return KeyBoardHook;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-10-21 上午11:49:37
	*/
	//class laya.ide.hook.MouseHook
	var MouseHook=(function(){
		function MouseHook(){
			this._isLeftMouse=false;
			this._event=null;
			this._target=null;
		}

		__class(MouseHook,'laya.ide.hook.MouseHook');
		var __proto=MouseHook.prototype;
		__proto.onMouseDown=function(ele){
			if(Laya.stage.focus&&!(DisControlTool.isChildE(Laya.stage.focus,this._target))){
				IDEAPIS.unFocusInput();
				if(Input.isInputting){
					if(Input["inputElement"]&&Input["inputElement"].target)
						Input["inputElement"].target.focus=false;
				}
			}
			MouseHook._preMouseDown.call(MouseManager.instance,ele);
		}

		MouseHook.hook=function(){
			MouseHook._preMouseDown=MouseManager.instance["onMouseDown"];
			MouseManager.instance["onMouseDown"]=MouseHook.I.onMouseDown;
		}

		MouseHook._preMouseDown=null
		__static(MouseHook,
		['I',function(){return this.I=new MouseHook();}
		]);
		return MouseHook;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-8-3 上午10:16:07
	*/
	//class laya.ide.managers.CanvasViewsManager
	var CanvasViewsManager=(function(){
		function CanvasViewsManager(){
			this.dialogContainer=null;
		}

		__class(CanvasViewsManager,'laya.ide.managers.CanvasViewsManager');
		var __proto=CanvasViewsManager.prototype;
		__proto.init=function(){
			return;
			this.dialogContainer=new CanvasView(Laya.stage.width,Laya.stage.height);
			this.dialogContainer.canvas.source.id="dialogContainer";
			this.dialogContainer.addChild(Dialog.manager);
			this.dialogContainer.float(0,0);
			JSTools.setZIndex(this.dialogContainer.canvas.source,100);
			Dialog.manager.on("close",this,this.dialogClose);
			Dialog.manager.on("open",this,this.dialogOpen);
		}

		__proto.dialogClose=function(){
			if(Dialog.manager.numChildren==1&&Dialog.manager.numChildren<1){
				JSTools.removeElement(this.dialogContainer.canvas.source);
			}
		}

		__proto.dialogOpen=function(){
			Browser.document.body.appendChild(this.dialogContainer.canvas.source);
		}

		__static(CanvasViewsManager,
		['I',function(){return this.I=new CanvasViewsManager();}
		]);
		return CanvasViewsManager;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-3-22 下午7:37:47
	*/
	//class laya.ide.managers.CodeViewManager
	var CodeViewManager=(function(){
		function CodeViewManager(){
			if(!CodeViewManager.codeDiv){
				CodeViewManager.init();
			}
		}

		__class(CodeViewManager,'laya.ide.managers.CodeViewManager');
		var __proto=CodeViewManager.prototype;
		__proto.setZIndex=function(index){
			if(!CodeViewManager.style)return;
			CodeViewManager.style["z-index"]=index;
		}

		__proto.show=function(){
			this.setZIndex(9);
			CodeViewManager.showed=true;
		}

		__proto.hide=function(){
			this.setZIndex(-1);
			CodeViewManager.showed=false;
		}

		CodeViewManager.init=function(){
			CodeViewManager.codeDiv=Browser.window["layaEditor"];
			if(!CodeViewManager.codeDiv)return;
			CodeViewManager.style=CodeViewManager.codeDiv.style;
			CodeViewManager.style["z-index"]=9;
			CodeViewManager.style["position"]="absolute";
			CodeViewManager.adpt();
		}

		CodeViewManager.openFile=function(file){
			if(!CodeViewManager.codeDiv)return;
			Browser.window["openFile"](file);
		}

		CodeViewManager.sizeDiv=function(width,height){
			if(!CodeViewManager.codeDiv)return;
			Browser.window["windowLayout"](width,height);
		}

		CodeViewManager.adpt=function(){
			if(!CodeViewManager.codeDiv)return;
			var pos=new Point();
			pos=UIPanel.instance.localToGlobal(pos);
			var dLen=0;
			dLen=25;
			var tW=0;
			var tH=0;
			var dWidth=4;
			tW=UIPanel.instance.width-dWidth*2;
			tH=(UIPanel.instance.height-dLen);
			CodeViewManager.style.width=tW+"px";
			CodeViewManager.style.height=tH+"px";
			CodeViewManager.style.left=(pos.x+dWidth)+"px";
			CodeViewManager.style.top=pos.y+dLen+"px";
			CodeViewManager.sizeDiv(tW,tH);
		}

		CodeViewManager.codeDiv=null
		CodeViewManager.style=null
		CodeViewManager.showed=false;
		__static(CodeViewManager,
		['I',function(){return this.I=new CodeViewManager();}
		]);
		return CodeViewManager;
	})()


	/**
	*本类控制鼠标光标样式
	*@author ww
	*/
	//class laya.ide.managers.CursorManager
	var CursorManager=(function(){
		function CursorManager(){}
		__class(CursorManager,'laya.ide.managers.CursorManager');
		CursorManager.init=function(){
			CursorManager._style=Browser.document.body.style;
			CursorManager.setType("default");
		}

		CursorManager.setType=function(type){
			CursorManager._style.cursor=type;
		}

		CursorManager.Auto="default";
		CursorManager.Hand="all-scroll";
		CursorManager.HResize="e-resize";
		CursorManager.VResize="n-resize";
		CursorManager._style=null
		return CursorManager;
	})()


	/**
	*ide右上方拖动条
	*@author ww
	*/
	//class laya.ide.managers.DragBarManager
	var DragBarManager=(function(){
		function DragBarManager(){}
		__class(DragBarManager,'laya.ide.managers.DragBarManager');
		DragBarManager.init=function(){
			DragBarManager._drag=Browser.document.getElementById("_dragBar");
			DragBarManager._style=DragBarManager._drag.style;
			DragBarManager.adpt();
		}

		DragBarManager.adpt=function(){
			var menuWidth=580;
			DragBarManager._style.left=menuWidth+"px";
			DragBarManager._style.width=Browser.clientWidth-menuWidth-200;
		}

		DragBarManager._drag=null
		DragBarManager._style=null
		return DragBarManager;
	})()


	/**
	*文件夹监控
	*@author ww
	*@version 1.0
	*
	*@created 2015-11-17 下午5:16:45
	*/
	//class laya.ide.managers.file.DirWatcher
	var DirWatcher=(function(){
		function DirWatcher(){
			this.path=null;
			this._childs=[];
		}

		__class(DirWatcher,'laya.ide.managers.file.DirWatcher');
		var __proto=DirWatcher.prototype;
		__proto.clear=function(){
			FileTools.unwatch(this.path);
			var i=0,len=0;
			len=this._childs.length;
			var tChild;
			for(i=0;i<len;i++){
				tChild=this._childs[i];
				tChild.clear();
			}
			this._childs.length=0;
		}

		__proto.setPath=function(path){
			return;
			this.clear();
			this.path=path;
			if(!FileTools.exist(path))return;
			if(FileTools.isDirectory(path)){
				var childs;
				childs=FileTools.getDirChildDirs(path);
				var i=0,len=0;
				len=childs.length;
				var tChild;
				for(i=0;i<len;i++){
					tChild=new DirWatcher();
					tChild.setPath(childs[i]);
					this._childs.push(tChild);
				}
				}else{
			}
			FileTools.watch(path,Utils$1.bind(this.changeHandler,this));
		}

		__proto.checkChanges=function(){}
		__proto.changeHandler=function(event,filename){
			if(!filename)return;
			filename=CMDShell.decode(filename,"utf8");
			var filePath;
			filePath=FileTools.path.join(this.path,filename);
			console.log("FileChange:",event,filename);
			if(!FileTools.exist(filePath))return;
			if(FileTools.isDirectory(filePath)){
				if(!FileTools.isDirWatched(filePath)){
					var tChild;
					tChild=new DirWatcher();
					tChild.setPath(filePath);
					this._childs.push(tChild);
				}
				return;
			}
			Laya.timer.once(500,Notice,Notice.notify,["RESFILE_CHANGE",filePath],true);
		}

		return DirWatcher;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-5-26 上午9:27:43
	*/
	//class laya.ide.managers.file.DirWatcherNew
	var DirWatcherNew=(function(){
		function DirWatcherNew(){
			this.updateO={};
			this.path=null;
		}

		__class(DirWatcherNew,'laya.ide.managers.file.DirWatcherNew');
		var __proto=DirWatcherNew.prototype;
		__proto.setPath=function(path){
			return;
			this.path=path;
			ObjectTools$1.clearObj(this.updateO);
			this.work=false;
			this.record();
			this.work=true;
		}

		__proto.record=function(){
			var files;
			files=FileTools.getFileList(this.path);
			var i=0,len=0;
			var tFile;
			var infor;
			len=files.length;
			for(i=0;i<len;i++){
				tFile=files[i];
				infor=FileTools.getStat(tFile);
				this.updateO[tFile]=infor.mtime.toString();
			}
		}

		__proto.check=function(){
			var files;
			files=FileTools.getFileList(this.path);
			var i=0,len=0;
			var tFile;
			var infor;
			var newTime;
			len=files.length;
			for(i=0;i<len;i++){
				tFile=files[i];
				infor=FileTools.getStat(tFile);
				newTime=infor.mtime.toString();
				if(newTime!=this.updateO[tFile]){
					Notice.notify("RESFILE_CHANGE",tFile);
				}
				this.updateO[tFile]=newTime;
			}
		}

		__getset(0,__proto,'work',null,function(v){
			if(v){
				Laya.timer.loop(5000,this,this.check);
				}else{
				Laya.timer.clear(this,this.check);
			}
		});

		return DirWatcherNew;
	})()


	/**文件管理类
	*@author yung
	*/
	//class laya.ide.managers.FileManager
	var FileManager=(function(){
		function FileManager(){};
		__class(FileManager,'laya.ide.managers.FileManager');
		FileManager.getPath=function(basePath,relativePath){
			return FileTools.getPath(basePath,relativePath);
		}

		FileManager.getRelativePath=function(basePath,targetPath){
			return FileManager.adptToCommonUrl(FileTools.getRelativePath(basePath,targetPath));
		}

		FileManager.getAppPath=function(path){
			return FileManager.getPath(SystemSetting.appPath,path);
		}

		FileManager.getDataPath=function(path){
			return FileManager.getPath(Device.dataPath,path);
		}

		FileManager.getAppRelativePath=function(path){
			return FileManager.getRelativePath(SystemSetting.appPath,path);
		}

		FileManager.getWorkPath=function(path){
			return FileManager.getPath(SystemSetting.workPath,path);
		}

		FileManager.getWorkRelativePath=function(path){
			return FileManager.adptToCommonUrl(FileManager.getRelativePath(SystemSetting.workPath,path));
		}

		FileManager.getResRelativePath=function(path){
			return FileManager.adptToCommonUrl(""+FileManager.getRelativePath(SystemSetting.assetsPath,path));
		}

		FileManager.adptToCommonUrl=function(url){
			return StringTool$1.getReplace(url,"\\\\","/");
		}

		FileManager.adptToLocalUrl=function(url){
			return FileTools.path.normalize(url);
		}

		FileManager.getResPath=function(path){
			return FileManager.getPath(SystemSetting.assetsPath,path);
		}

		FileManager.getPagePath=function(path){
			return FileManager.getPath(SystemSetting.pagesPath,path);
		}

		FileManager.getFileName=function(path){
			return FileTools.path.basename(path).split(".")[0];
		}

		FileManager.createDirectory=function(path){
			try {
				FileTools.createDirectory(path);
				}catch (e){
				Sys.alert("Create folder failed:"+path);
			}
		}

		FileManager.createTxtFile=function(path,value){
			try {
				FileTools.createFile(path,value);
				}catch (e){
				Sys.alert("Create file failed:"+path);
			}
		}

		FileManager.createJSONFile=function(path,value){
			try {
				FileTools.createFile(path,JSON.stringify(value));
				}catch (e){
				Sys.alert("Create file failed:"+path);
			}
		}

		FileManager.createBytesFile=function(path,bytes){
			try {
				FileTools.createFile(path,bytes);
				}catch (e){
				Sys.alert("Create file failed:"+path);
			}
		}

		FileManager.removeFile=function(path){
			FileTools.removeE(path);
		}

		FileManager.copyFile=function(from,to){
			try {
				FileTools.copyE(from,to);
				}catch (e){
				Sys.alert("Copy file failed:(from:"+from+" to:"+to+")");
				console.log("Copy file failed:(from:"+from+" to:"+to+")");
			}
		}

		FileManager.readTxtFile=function(path,errorAlert){
			(errorAlert===void 0)&& (errorAlert=true);
			try {
				return FileTools.readFile(path);
				}catch (e){
				if (errorAlert)Sys.alert("Read file failed:"+path);
			}
			return null;
		}

		FileManager.readJSONFile=function(path,errorAlert){
			(errorAlert===void 0)&& (errorAlert=true);
			try {
				var str=laya.ide.managers.FileManager.readTxtFile(path);
				return JSON.parse(str);
				}catch (e){
				if (errorAlert)Sys.alert("Read file failed:"+path);
				debugger;
			}
			return null;
		}

		FileManager.readByteFile=function(path,errorAlert){
			(errorAlert===void 0)&& (errorAlert=true);
			try {
				return FileTools.readFile(path);
				}catch (e){
				if (errorAlert)Sys.alert("Read file failed:"+path);
			}
			return null;
		}

		FileManager.getFileList=function(path){
			return FileTools.getFileList(path);
		}

		FileManager.exists=function(path){
			return FileTools.exist(path);
		}

		FileManager.getFileTree=function(path,hasExtension){
			(hasExtension===void 0)&& (hasExtension=false);
			var xml=findFiles(path);
			function findFiles (path){
				var node;
				if (FileTools.exist(path)){
					var fileName=FileTools.getFileName(path);
					node=new XMLElement("<item label='"+fileName+"' path='"+path+"' isDirectory='true'/>");
					var a=FileTools.getDirFiles(path);
					var f;
					for(var $each_f in a){
						f=a[$each_f];
						f=FileTools.getPath(path,f);
						if (FileTools.isDirectory(f)&& f.indexOf(".svn")==-1){
							node.appendChild(findFiles(f));
						}
					}
					var $each_f;
					for($each_f in a){
						f=a[$each_f];
						f=FileTools.getPath(path,f);
						if (FileTools.isDirectory(f)==false){
							if (fileName.indexOf("$")==-1 && fileName.indexOf("@")==-1){
								node.appendChild(new XMLElement("<item label='"+fileName+"' path='"+f+"' isDirectory='false'/>"));
							}
						}
					}
				}
				return node;
			}
			return xml
		}

		FileManager.rename=function(oldPath,newPath){
			try {
				FileTools.rename(oldPath,newPath);
				}catch (e){
				Sys.alert("Rename file failed:(from:"+oldPath+" to:"+newPath+")");
			}
		}

		return FileManager;
	})()


	/**
	*用于在对象上显示焦点框的工具类
	*@author ww
	*/
	//class laya.ide.managers.FocusManager
	var FocusManager=(function(){
		function FocusManager(){}
		__class(FocusManager,'laya.ide.managers.FocusManager');
		FocusManager.showFocus=function(tar,width,clearPre){
			(width===void 0)&& (width=5);
			(clearPre===void 0)&& (clearPre=true);
			var bounds;
			bounds=FocusManager.getTarBounds(tar);
			FocusManager.showBorder(tar,"up",clearPre,bounds,width);
			FocusManager.showBorder(tar,"down",false,bounds,width);
			FocusManager.showBorder(tar,"left",false,bounds,width);
			FocusManager.showBorder(tar,"right",false,bounds,width);
		}

		FocusManager.getTarBounds=function(tar){
			if(FocusManager.useGetBounds){
				return tar.getSelfBounds();
				}else{
				return new Rectangle().setTo(0,0,tar.width,tar.height);
			}
		}

		FocusManager.showBorder=function(tar,type,clearPre,rec,width){
			(clearPre===void 0)&& (clearPre=true);
			(width===void 0)&& (width=5);
			if (clearPre==true){
				FocusManager.clearFocus();
			};
			var bounds;
			bounds=rec?rec:FocusManager.getTarBounds(tar);
			var tFocus;
			tFocus=DisPool.getDis(FocusItem);
			switch (type){
				case "left":
					tFocus.width=width;
					tFocus.height=bounds.height;
					tFocus.x=bounds.x;
					tFocus.y=bounds.y;
					break ;
				case "right":
					tFocus.width=width;
					tFocus.height=bounds.height;
					tFocus.x=bounds.x+bounds.width-width;
					tFocus.y=bounds.y;
					break ;
				case "up":
					tFocus.width=bounds.width;
					tFocus.height=width;
					tFocus.x=bounds.x;
					tFocus.y=bounds.y;
					break ;
				case "down":
					tFocus.width=bounds.width;
					tFocus.height=width;
					tFocus.x=bounds.x;
					tFocus.y=bounds.y+bounds.height-width;
					break ;
				}
			FocusManager.showFocusToTar(tar,tFocus);
		}

		FocusManager.showFocusToTar=function(tar,focus){
			FocusManager._focusList.push(focus);
			tar.addChild(focus);
		}

		FocusManager.clearFocus=function(tar){
			var i=0,len=0;
			len=FocusManager._focusList.length;
			if (tar){
				for (i=len-1;i >=0;i--){
					if (FocusManager._focusList[i].parent==tar){
						(FocusManager._focusList [i]).removeSelf();
						FocusManager._focusList.splice(i,1);
					}
				}
			}
			else{
				for (i=0;i < len;i++){
					(FocusManager._focusList [i]).removeSelf();
				}
				FocusManager._focusList.length=0;
			}
		}

		FocusManager.focusWidth=5;
		FocusManager.useGetBounds=false;
		FocusManager._focusList=[];
		return FocusManager;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-3-23 下午9:19:23
	*/
	//class laya.ide.managers.HtmlLayerManager
	var HtmlLayerManager=(function(){
		function HtmlLayerManager(){
			HtmlLayerManager.init();
		}

		__class(HtmlLayerManager,'laya.ide.managers.HtmlLayerManager');
		HtmlLayerManager.init=function(){
			HtmlLayerManager.CanvasStyle=Render._mainCanvas.source["style"];
			Dialog.manager.on("open",null,HtmlLayerManager.openDialog);
			Dialog.manager.on("close",null,HtmlLayerManager.closeDialog);
		}

		HtmlLayerManager.setCanvasIndex=function(index){
			if(!HtmlLayerManager.CanvasStyle)HtmlLayerManager.init();
			HtmlLayerManager.CanvasStyle["z-index"]=index;
		}

		HtmlLayerManager.update=function(){
			return;
			if(HtmlLayerManager.hasPops()){
				HtmlLayerManager.switchToTop();
				}else{
				HtmlLayerManager.switchToBack();
			}
		}

		HtmlLayerManager.hasPops=function(){
			return HtmlLayerManager.hasMenu||HtmlLayerManager.hasDialog||HtmlLayerManager.hasTip;
		}

		HtmlLayerManager.switchToTop=function(){
			HtmlLayerManager.setCanvasIndex(99);
		}

		HtmlLayerManager.switchToBack=function(){
			HtmlLayerManager.setCanvasIndex(1);
		}

		HtmlLayerManager.openDialog=function(){
			HtmlLayerManager.hasDialog=true;
			HtmlLayerManager.update();
		}

		HtmlLayerManager.closeDialog=function(){
			HtmlLayerManager.hasDialog=false;
			HtmlLayerManager.update();
		}

		HtmlLayerManager.openMenu=function(){
			HtmlLayerManager.hasMenu=true;
			HtmlLayerManager.update();
		}

		HtmlLayerManager.closeMenu=function(){
			HtmlLayerManager.hasMenu=false;
			HtmlLayerManager.update();
		}

		HtmlLayerManager.openTip=function(){
			HtmlLayerManager.hasTip=true;
			HtmlLayerManager.update();
		}

		HtmlLayerManager.closeTip=function(){
			HtmlLayerManager.hasTip=false;
			HtmlLayerManager.update();
		}

		HtmlLayerManager.CanvasStyle=null
		HtmlLayerManager.hasDialog=false;
		HtmlLayerManager.hasMenu=false;
		HtmlLayerManager.hasTip=false;
		return HtmlLayerManager;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-8-19 上午11:23:03
	*/
	//class laya.ide.managers.IDEAPIS
	var IDEAPIS=(function(){
		function IDEAPIS(){}
		__class(IDEAPIS,'laya.ide.managers.IDEAPIS');
		/**
		*资源文件存放的目录
		*
		*/
		__getset(1,IDEAPIS,'assetsPath',function(){
			return SystemSetting.assetsPath;
		});

		/**
		*当前工作目录
		*
		*/
		__getset(1,IDEAPIS,'workPath',function(){
			return SystemSetting.workPath;
		});

		/**
		*导出图集资源的目录
		*
		*/
		__getset(1,IDEAPIS,'resExportPath',function(){
			return ProjectSetting.resExportPath;
		});

		/**
		*页面文件存放目录
		*
		*/
		__getset(1,IDEAPIS,'pagesPath',function(){
			return SystemSetting.pagesPath;
		});

		/**
		*导出代码的目录
		*
		*/
		__getset(1,IDEAPIS,'codeExportPath',function(){
			return ProjectSetting.codeExportPath;
		});

		/**
		*导出非图集资源的目录
		*
		*/
		__getset(1,IDEAPIS,'asynResExportPath',function(){
			return ProjectSetting.asynResExportPath;
		});

		IDEAPIS.nodeChange=function(node,changeProps,reCreate){
			(reCreate===void 0)&& (reCreate=false);
			var design;
			design=IDEAPIS.getCurDesign();
			if(!design)return;
			design.nodeChanged(node,["x","y","width","height"]);
			design.change(reCreate);
			design.changeSelectComp();
		}

		IDEAPIS.getCurDesign=function(){
			if(!UIPanel.instance.currViewer)return null;
			return UIPanel.instance.currViewer.design;
		}

		IDEAPIS.getSelectComps=function(){
			var design;
			design=IDEAPIS.getCurDesign();
			if(!design)return null;
			return design.getIDedSelectedXmls();
		}

		IDEAPIS.getCurPagePath=function(){
			if(!UIPanel.instance.currViewer)return null;
			return UIPanel.instance.currViewer.pagePath;
		}

		IDEAPIS.getCurPageType=function(){
			var path;
			path=IDEAPIS.getCurPagePath();
			if(!path)return null;
			return TypeManager.getFileType(path);
		}

		IDEAPIS.getDesignData=function(){
			var design;
			design=IDEAPIS.getCurDesign();
			if(!design)return null;
			return design.xml;
		}

		IDEAPIS.unFocusInput=function(){
			if(Laya.stage.focus&& (Laya.stage.focus instanceof laya.ui.TextInput )){
				(Laya.stage.focus).focus=false;
			}
		}

		return IDEAPIS;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-12-27 下午3:00:03
	*/
	//class laya.ide.managers.IDEConfigsManager
	var IDEConfigsManager=(function(){
		function IDEConfigsManager(){}
		__class(IDEConfigsManager,'laya.ide.managers.IDEConfigsManager');
		var __proto=IDEConfigsManager.prototype;
		__proto.getConfig=function(sign){
			var configO;
			configO=FileManager.readJSONFile(Paths.getConfigVarPath());
			if(!configO)return null;
			return configO[sign];
		}

		__proto.saveConfig=function(sign,dataO){
			var configO;
			configO=FileManager.readJSONFile(Paths.getConfigVarPath());
			if(!configO)configO={};
			if(!dataO)dataO={};
			configO[sign]=dataO;
			FileManager.createJSONFile(Paths.getConfigVarPath(),configO);
		}

		__proto.insertDefaultValue=function(target,configO){
			var key;
			key=configO["sign"];
			if(!key)return;
			var vars;
			vars=configO["vars"];
			if(!vars)return;
			var i=0,len=0;
			len=vars.length;
			var tName;
			var tChild;
			var tValue;
			var tData;
			tData=this.getConfig(key);
			if(!tData)return;
			for(i=0;i<len;i++){
				tName=vars[i];
				tChild=target[tName];
				if(!tChild)continue ;
				if(tData[tName]){
					tChild.text=tData[tName];
				}
			}
		}

		__proto.saveDefaultValue=function(target,configO){
			var key;
			key=configO["sign"];
			if(!key)return;
			var vars;
			vars=configO["vars"];
			if(!vars)return;
			var i=0,len=0;
			len=vars.length;
			var tName;
			var tChild;
			var tValue;
			var tData;
			tData=this.getConfig(key);
			if(!tData)tData={};
			for(i=0;i<len;i++){
				tName=vars[i];
				tChild=target[tName];
				if(!tChild)continue ;
				tData[tName]=tChild.text;
			}
			this.saveConfig(key,tData);
		}

		__static(IDEConfigsManager,
		['I',function(){return this.I=new IDEConfigsManager();}
		]);
		return IDEConfigsManager;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2017-3-6 下午3:43:41
	*/
	//class laya.ide.managers.IDELangManager
	var IDELangManager=(function(){
		function IDELangManager(){}
		__class(IDELangManager,'laya.ide.managers.IDELangManager');
		IDELangManager.switchToLang=function(lang){
			if(!FileTools.exist(FileManager.getAppPath("h5/langs/"+lang))){
				lang=IDELangManager.DefaultLang;
			}
			IDELangManager.tLang=lang;
			IDESkinManager.reloadIDE();
		}

		IDELangManager.getLangPath=function(){
			if(!IDELangManager.tLang)return null;
			return FileManager.getAppPath("h5/langs/"+IDELangManager.tLang);
		}

		IDELangManager.setLangPath=function(path){
			if(!path){
				path=IDELangManager.DefaultLang;
			}
			if(!FileTools.exist(FileManager.getAppPath("h5/langs/"+path))){
				path=IDELangManager.DefaultLang;
			}
			IDELangManager.tLang=path;
		}

		IDELangManager.testSwitch=function(){
			if(IDELangManager.tLang==IDELangManager.DefaultLang){
				IDELangManager.switchToLang("english.json");
				}else{
				IDELangManager.switchToLang(IDELangManager.DefaultLang);
			}
		}

		IDELangManager.tLang=null;
		IDELangManager.DefaultLang=null;
		return IDELangManager;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-7-18 上午10:44:47
	*/
	//class laya.ide.managers.IDESkinManager
	var IDESkinManager=(function(){
		function IDESkinManager(){}
		__class(IDESkinManager,'laya.ide.managers.IDESkinManager');
		IDESkinManager.reloadIDE=function(){
			Device.remote.getCurrentWindow().reload();
		}

		IDESkinManager.switchToSkin=function(skinPath){
			if(!FileTools.exist(FileManager.getAppPath("h5/skins/"+skinPath))){
				skinPath="default";
			}
			IDESkinManager.tSkinPath=skinPath;
			IDESkinManager.reloadIDE();
		}

		IDESkinManager.setSkinPath=function(path){
			if(!path){
				path="default";
			}
			if(!FileTools.exist(FileManager.getAppPath("h5/skins/"+path))){
				path="default";
			}
			IDESkinManager.tSkinPath=path;
		}

		IDESkinManager.getSkinPath=function(){
			return FileManager.getAppPath("h5/skins/"+IDESkinManager.tSkinPath+"/");
		}

		IDESkinManager.getStylePath=function(){
			return IDESkinManager.getSkinPath()+"styles.cfg";
		}

		IDESkinManager.testSwitch=function(){
			if(IDESkinManager.tSkinPath=="default"){
				IDESkinManager.switchToSkin("lighter");
				}else{
				IDESkinManager.switchToSkin("default");
			}
		}

		IDESkinManager.tSkinPath="lighter";
		IDESkinManager.DefaultSkinPath="default";
		return IDESkinManager;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-4-20 下午4:48:41
	*/
	//class laya.ide.managers.KeyManager
	var KeyManager=(function(){
		function KeyManager(){
			this.isCommandKeyDown=false;
		}

		__class(KeyManager,'laya.ide.managers.KeyManager');
		var __proto=KeyManager.prototype;
		__proto.init=function(){
			Laya.stage.on("keydown",this,this.keyDown);
			Laya.stage.on("keyup",this,this.keyUp);
			Laya.stage.on("blur",this,this.onBlur);
		}

		__proto.onBlur=function(){
			this.isCommandKeyDown=false;
		}

		__proto.isCommandKey=function(keyCode){
			if(KeyManager.commandKeys[keyCode])return true;
			return false;
		}

		__proto.keyDown=function(e){
			if(this.isCommandKey(e.keyCode)){
				this.isCommandKeyDown=true;
			}
			if(Input.isInputting){
				this.isCommandKeyDown=false;
			}
		}

		__proto.keyUp=function(e){
			if(Input.isInputting){
				this.isCommandKeyDown=false;
			}
			if(this.isCommandKey(e.keyCode)){
				this.isCommandKeyDown=false;
			}
		}

		KeyManager.isABC=function(keyCode){
			return keyCode>=65&&keyCode<=90;
		}

		KeyManager.getCharByCode=function(code){
			return String.fromCharCode(code);
		}

		KeyManager.setNewFocus=function(item){
			if(Laya.stage.focus){
				KeyManager.focusList.push(Laya.stage.focus);
			}
			Laya.stage.focus=item;
		}

		KeyManager.restoreFocus=function(){
			if(KeyManager.focusList.length>0){
				Laya.stage.focus=KeyManager.focusList.pop();
			}
		}

		KeyManager.focusList=[];
		__static(KeyManager,
		['I',function(){return this.I=new KeyManager();},'commandKeys',function(){return this.commandKeys={
				91:true,
				93:true,
				244:true,
				17:true
		};}

		]);
		return KeyManager;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-7-4 下午8:19:47
	*/
	//class laya.ide.managers.LanguageManager
	var LanguageManager=(function(){
		function LanguageManager(){}
		__class(LanguageManager,'laya.ide.managers.LanguageManager');
		LanguageManager.loadProjectLanguageFile=function(){
			if(ProjectSetting)
				LanguageManager.loadLanguageFile(FileManager.getWorkPath(ProjectSetting.langPath));
		}

		LanguageManager.loadLanguageFile=function(file){
			if(!FileTools.exist(file)){
				return;
			}
			if(FileTools.isDirectory(file))return;
			var txt;
			txt=FileTools.readFile(file);
			var langData;
			try{
				langData=ObjectTools$1.getObj(txt);
				}catch(e){
			}
			if(langData){
				Text.langPacks=langData;
			}
			Notice.notify("FRESH_CurView");
			console.log("languagePack loaded");
		}

		LanguageManager.getLanguagePack=function(){
			LanguageManager.saveLanguagePack(FileManager.getWorkPath(ProjectSetting.resExportPath));
		}

		LanguageManager.updateLangDic=function(oldLangDic,newLangDic){
			var key;
			for(key in oldLangDic){
				newLangDic[key]=oldLangDic[key];
			}
			return newLangDic;
		}

		LanguageManager.saveLanguagePack=function(file){
			try{
				var outPath;
				outPath=FileManager.getPath(file,"lang.lang");
				var langDic;
				langDic=LanguageManager.createByDir(SystemSetting.pagesPath,null,null);
				var preLangDic;
				if(FileManager.exists(outPath)){
					preLangDic=FileManager.readJSONFile(outPath);
					if(preLangDic){
						LanguageManager.updateLangDic(preLangDic,langDic);
					}
				}
				console.log("langDic:",langDic);
				FileTools.createFile(outPath,ObjectTools$1.getJsonString(langDic));
				MessageManager.instance.show(Sys.lang("生成语言包成功"));
				}catch(e){
				Alert.show(Sys.lang("生成语言包失败：")+e.message);
			}
		}

		LanguageManager.createByDir=function(file,basePath,tarPath){
			var fileList;
			fileList=FileTools.getFileList(file);
			var i=0,len=0;
			len=fileList.length;
			var tFile;
			var code;
			var obj;
			var codePath;
			var uiObj;
			var textDic={};
			for(i=0;i<len;i++){
				tFile=fileList[i];
				if(FileTools.isDirectory(tFile)){
					}else{
					if(TypeManager.getFileType(tFile)=="page"||TypeManager.getFileType(tFile)=="animation"){
						code=FileManager.readTxtFile(tFile);
						try{
							uiObj=ObjectTools$1.getObj(code);
							LanguageManager.collectTexts(uiObj,textDic);
							}catch(e){
							Alert.show(Sys.lang("提取文件失败：\n")+tFile);
						}
					}
				}
			}
			LanguageManager.getStylesText(ResStyleManager.styleMap,textDic);
			return textDic;
		}

		LanguageManager.getStylesText=function(styleObj,textDic){
			if(!styleObj)return;
			var key;
			var xml;
			for(key in styleObj){
				xml=styleObj[key];
				if(xml){
					LanguageManager.collectPropStrText(xml.getAttribute('props'),textDic);
				}
			}
		}

		LanguageManager.collectPropStrText=function(propStr,textDic){
			if(!propStr)return;
			if(propStr.indexOf("=")>=0){
				var props;
				props=ResStyleManager.getPropArrByPropStr(propStr);
				for (var i=0,n=props.length;i < n;i++){
					var a=props[i].split("=");
					if (a.length==2){
						var key=a[0];
						var val=a[1];
						var adptVal;
						if(!LanguageManager.textKeysDefault[key])continue ;
						adptVal=ObjectTools$1.getAutoValue(val);
						if((typeof adptVal=='string')){
							LanguageManager.addText(adptVal,textDic);
						}
					}
				}
			}
		}

		LanguageManager.getTypeCollects=function(type){
			if(LanguageManager.collectConfigO[type])return LanguageManager.collectConfigO[type];
			var rst;
			rst=[];
			var configO;
			configO=UIConfigManager.getFullConfig(type);
			if(configO){
				var props;
				props=configO.prop;
				var key;
				for(key in props){
					if(props[key]["text"]=="true"||LanguageManager.textKeysDefault[key]){
						rst.push(key);
					}
				}
			}
			Utils$1.concatArray(rst,LanguageManager.defaultKeys);
			LanguageManager.collectConfigO[type]=rst;
			return rst;
		}

		LanguageManager.collectTexts=function(nodeO,textDic){
			var i=0,len=0;
			var props;
			props=nodeO.props;
			var keys;
			keys=LanguageManager.getTypeCollects(nodeO.type);
			if(keys){
				len=keys.length;
				for(i=0;i<len;i++){
					if(props.hasOwnProperty(keys[i])){
						LanguageManager.addText(props[keys[i]],textDic);
					}
				}
			};
			var childs;
			childs=nodeO.child;
			if(childs){
				len=childs.length;
				for(i=0;i<len;i++){
					LanguageManager.collectTexts(childs[i],textDic)
				}
			}
		}

		LanguageManager.addText=function(text,textDic){
			if(text==null)return;
			if(text=="")return;
			textDic[text]=text;
		}

		__static(LanguageManager,
		['textKeysDefault',function(){return this.textKeysDefault={
				"text":true,
				"label":true,
				"title":true,
				"prompt":true
				};},'defaultKeys',function(){return this.defaultKeys=["text","label","title","prompt","toolTip"];},'collectConfigO',function(){return this.collectConfigO={
		};}

		]);
		return LanguageManager;
	})()


	/**
	*本类用于处理对象之间的排版关系
	*@author ww
	*/
	//class laya.ide.managers.layout.RelativePos
	var RelativePos=(function(){
		function RelativePos(fun,tar,to,d){
			this.tar=null;
			this.to=null;
			this.d=NaN;
			this._fun=null;
			this.tar=tar;
			this.to=to;
			this.d=d;
			this._fun=fun;
		}

		__class(RelativePos,'laya.ide.managers.layout.RelativePos');
		var __proto=RelativePos.prototype;
		/**
		*更新排版
		*
		*/
		__proto.update=function(){
			this._fun(this.tar,this.to,this.d);
		}

		RelativePos.getDisMouseRelativePos=function(tTarget,edgePercent){
			(edgePercent===void 0)&& (edgePercent=0.1);
			var pos;
			pos=DisControlTool.getMousePoint(tTarget);
			if (pos.x < 0 || pos.x > tTarget.width || pos.y < 0 || pos.y > tTarget.height)return "out";
			if (pos.y < tTarget.height *edgePercent){
				return "up";
			}
			else if (pos.y > tTarget.height *(1-edgePercent)){
				return "down";
			}
			else if (pos.x > tTarget.width *(1-edgePercent)){
				return "right";
				}else if (pos.x < tTarget.width *edgePercent){
				return "left";
				}else{
				return "center";
			}
			return "center";
		}

		RelativePos.rightTo=function(tar,to,d){
			(d===void 0)&& (d=0);
			if (!to.parent)
				return;
			tar.right=Math.ceil((to.parent).width-to.x+d);
		}

		RelativePos.leftTo=function(tar,to,d){
			(d===void 0)&& (d=0);
			tar.left=Math.ceil(to.x+to.width+d);
		}

		RelativePos.downTo=function(tar,to,d){
			(d===void 0)&& (d=0);
			if (!to.parent)
				return;
			tar.bottom=Math.ceil((to.parent).height-to.y+d);
		}

		RelativePos.upTo=function(tar,to,d){
			(d===void 0)&& (d=0);
			tar.top=Math.ceil(to.y+to.height+d);
		}

		RelativePos.saveRelative=function(tar){
			var relativeO;
			relativeO=tar["relativeO"];
			if (!relativeO)
				return {};
			var key;
			var rst={};
			for (key in relativeO){
				rst[key]=IDTools.getObjID(relativeO[key]);
			}
			return rst;
		}

		RelativePos.getTypeByFun=function(fun){
			var key;
			for (key in RelativePos.typeToFunO){
				if (RelativePos.typeToFunO[key]==fun)
					return key;
			}
			return null;
		}

		RelativePos.getOtherSide=function(type){
			return RelativePos.otherSideO[type];
		}

		RelativePos.getOnlySide=function(o){
			var relativeO;
			relativeO=o["relativeO"];
			if (!relativeO)
				return null;
			var type;
			var tBar;
			var tRst;
			var tArea=0;
			var tRstBar;
			for (type in relativeO){
				tBar=relativeO[type];
				if (tBar){
					if (tBar.isOnly(o)){
						if (!tRst || RelativePos.getBarWeight(tBar)> tArea){
							tRst=type;
							tRstBar=tBar;
							tArea=RelativePos.getBarWeight(tBar);
						}
					}
				}
			}
			return tRst;
		}

		RelativePos.getBarWeight=function(bar){
			var tRec;
			tRec=bar.getDragArea();
			return tRec.width+tRec.height;
		}

		RelativePos.addRelative=function(o,dragBar,type,d){
			(d===void 0)&& (d=0);
			if (!dragBar)
				return;
			RelativePos.cancelRelative(o,type);
			dragBar.addItem(o,RelativePos.typeToFunO[type]);
			var relativeO;
			if (!o["relativeO"])
				o["relativeO"]={};
			relativeO=o["relativeO"];
			relativeO[type]=dragBar;
		}

		RelativePos.copyRelative=function(o,tar,type){
			RelativePos.addRelative(o,RelativePos.getBar(tar,type),type);
		}

		RelativePos.cancelRelative=function(o,sign){
			var relativeO;
			relativeO=o["relativeO"];
			if (!relativeO)
				return;
			if (relativeO[sign]){
				(relativeO [sign]).removeTarget(o);
			}
			delete relativeO[sign];
		}

		RelativePos.getBar=function(o,sign){
			var relativeO;
			relativeO=o["relativeO"];
			if (!relativeO)
				return null;
			return relativeO[sign];
		}

		RelativePos.clearBar=function(o){
			RelativePos.cancelRelative(o,"left");
			RelativePos.cancelRelative(o,"right");
			RelativePos.cancelRelative(o,"up");
			RelativePos.cancelRelative(o,"down");
		}

		RelativePos.Right="right";
		RelativePos.Left="left";
		RelativePos.Down="down";
		RelativePos.Up="up";
		RelativePos.Center="center";
		RelativePos.Out="out";
		RelativePos.EdgePercent=0.1;
		__static(RelativePos,
		['typeToFunO',function(){return this.typeToFunO={"right":laya.ide.managers.layout.RelativePos.rightTo,"left":laya.ide.managers.layout.RelativePos.leftTo,"up":laya.ide.managers.layout.RelativePos.upTo,"down":laya.ide.managers.layout.RelativePos.downTo};},'otherSideO',function(){return this.otherSideO={"right":"left","left":"right","up":"down","down":"up"};}
		]);
		return RelativePos;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-6-27 上午10:10:36
	*/
	//class laya.ide.managers.layout.ResizeRecStruct
	var ResizeRecStruct=(function(){
		function ResizeRecStruct(){
			this.upSide=null;
			this.downSide=null;
			this.leftSide=null;
			this.rightSide=null;
			this.isRoot=false;
			this.resizeItems=null;
			this.mDis=NaN;
			this.sortByXFun=MathUtil.sortByKey("x",false,true);
			this.sortByYFun=MathUtil.sortByKey("y",false,true);
		}

		__class(ResizeRecStruct,'laya.ide.managers.layout.ResizeRecStruct');
		var __proto=ResizeRecStruct.prototype;
		__proto.reset=function(){
			this.upSide=null;
			this.downSide=null;
			this.leftSide=null;
			this.rightSide=null;
		}

		__proto.setBars=function(left,right,up,down){
			this.upSide=up;
			this.downSide=down;
			this.leftSide=left;
			this.rightSide=right;
		}

		__proto.isSame=function(left,right,up,down){
			return this.upSide==up&&this.downSide==down&&this.leftSide==left&&this.rightSide==right;
		}

		__proto.isSameStruct=function(st){
			return this.upSide==st.upSide&&this.downSide==st.downSide&&this.leftSide==st.leftSide&&this.rightSide==st.rightSide;
		}

		__proto.traceMyInfo=function(){
			console.log("up:",this.upSide.getDragBarInfo("up"));
			console.log("down:",this.downSide.getDragBarInfo("down"));
			console.log("left:",this.leftSide.getDragBarInfo("left"));
			console.log("right:",this.rightSide.getDragBarInfo("right"));
		}

		/**
		*调整垂直方向的拖动条
		*@param dis
		*@return
		*
		*/
		__proto.tryMoveRight=function(dis){
			this.mDis=dis;
			var i=0,len=0;
			var _updaters;
			_updaters=this.upSide._updaters;
			len=_updaters.length;
			var tR;
			var dragBarList;
			dragBarList=[];
			var tDragBar;
			for (i=len-1;i >=0;i--){
				tR=_updaters[i];
				if((tR.tar instanceof laya.editor.comonents.LayoutDragBar )){
					tDragBar=tR.tar;
					if(tDragBar.cusorType=="e-resize"&&RelativePos.getTypeByFun(tR._fun)=="up"){
						if(this.downSide.findTarType(tDragBar)!=null){
							if(tDragBar.x>=this.leftSide.x&&tDragBar.x<=this.rightSide.x)
								dragBarList.push(tDragBar);
						}
					}
				}
			}
			dragBarList.sort(this.sortByXFun);
			if(dragBarList[0]!=this.leftSide){
				dragBarList.unshift(this.leftSide);
			}
			if(dragBarList[dragBarList.length-1]!=this.rightSide){
				dragBarList.push(this.rightSide);
			}
			if(dragBarList.length<2){
				return false;
			};
			var tWidth=NaN;
			tWidth=0;
			var maxWidth=NaN;
			maxWidth=0;
			var tSelecteDragBar;
			len=dragBarList.length;
			for(i=1;i<len;i++){
				tWidth=dragBarList[i].x-dragBarList[i-1].x;
				if(tWidth>maxWidth){
					maxWidth=tWidth;
					tSelecteDragBar=dragBarList[i];
				}
				if(tWidth+dis>150&&LayoutDragBar.hasFreeTar((dragBarList [i]).getTarsByType("right"))){
					tSelecteDragBar=dragBarList[i];
					break ;
				}
			}
			if(tSelecteDragBar){
				this.moveRightWork(tSelecteDragBar,dragBarList,dis)
				}else{
				debugger;
			}
			return true;
		}

		/**
		*调整水平方向的拖动条
		*@param dis
		*
		*/
		__proto.moveRightWork=function(selectBar,barList,dis){
			var i=0,len=0;
			var rightIndex=0;
			rightIndex=barList.indexOf(selectBar);
			var tLeftBar;
			var tRightBar;
			if(rightIndex>=1){
				tLeftBar=barList[rightIndex-1];
				tRightBar=barList[rightIndex];
				if(tLeftBar==this.leftSide&&tRightBar==this.rightSide){
					}else{
				}
				this.resizeSmallRec(tLeftBar,tRightBar);
			}
			len=barList.length;
			if(this.isRoot){
				len=this.resizeItems.length;
				for(i=0;i<len;i++){
					if(!this.resizeItems[i].walked){
						this.resizeItems[i].left+=dis;
						this.resizeItems[i].walked=true;
					}
				}
				}else{
				for(i=rightIndex;i<len;i++){
					this.resizeItems.push(barList[i]);
				}
			}
		}

		__proto.resizeSmallRec=function(tLeftBar,tRightBar){
			var i=0,len=0;
			var _updaters;
			_updaters=tRightBar._updaters;
			len=_updaters.length;
			var tR;
			var dragBarList;
			dragBarList=[];
			var tDragBar;
			for (i=len-1;i >=0;i--){
				tR=_updaters[i];
				if((tR.tar instanceof laya.editor.comonents.LayoutDragBar )){
					tDragBar=tR.tar;
					if(tDragBar.cusorType=="n-resize"&&RelativePos.getTypeByFun(tR._fun)=="right"){
						if(this.leftSide.findTarType(tDragBar)!=null){
							if(tDragBar.y>=this.upSide.y&&tDragBar.y<=this.downSide.y)
								dragBarList.push(tDragBar);
						}
					}
				}
			};
			var tSelecteDragBar;
			dragBarList.sort(this.sortByYFun);
			if(dragBarList[0]!=this.upSide){
				dragBarList.unshift(this.upSide);
			}
			if(dragBarList[dragBarList.length-1]!=this.downSide){
				dragBarList.push(this.downSide);
			}
			len=dragBarList.length;
			var resizeRec;
			for(i=1;i<len;i++){
				resizeRec=new ResizeRecStruct();
				resizeRec.resizeItems=this.resizeItems;
				resizeRec.setBars(tLeftBar,tRightBar,dragBarList[i-1],dragBarList[i]);
				if(this.isSameStruct(resizeRec)){
					}else{
					resizeRec.tryMoveRight(this.mDis);
				}
			}
		}

		return ResizeRecStruct;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.ide.managers.layout.Updater
	var Updater=(function(){
		function Updater(tar,tarSign,src,srcSign,dValue){
			this.tar=null;
			this.tarSign=null;
			this.src=null;
			this.srcSign=null;
			this.dValue=0;
			(dValue===void 0)&& (dValue=0);
			this.tar=tar;
			this.tarSign=tarSign;
			this.src=src;
			this.srcSign=srcSign;
			this.dValue=dValue;
		}

		__class(Updater,'laya.ide.managers.layout.Updater');
		var __proto=Updater.prototype;
		__proto.update=function(){
			this.tar[this.tarSign]=this.dValue+this.src[this.srcSign];
		}

		__proto.clear=function(){
			this.tar=null;
			this.src=null;
		}

		return Updater;
	})()


	/**
	*布局管理类
	*@author ww
	*/
	//class laya.ide.managers.LayoutRecManager
	var LayoutRecManager=(function(){
		function LayoutRecManager(){}
		__class(LayoutRecManager,'laya.ide.managers.LayoutRecManager');
		var __proto=LayoutRecManager.prototype;
		__proto.saveDragBarInfo=function(dragBar){}
		__getset(1,LayoutRecManager,'tLayoutFile',function(){
			return LayoutRecManager._layoutFile?LayoutRecManager._layoutFile:"layout/layout.config";
		});

		LayoutRecManager.popLocked=function(){
			return CodeViewManager.showed;
			return false;
		}

		LayoutRecManager.onMouseDown=function(e){
			LayoutRecManager.target=e.currentTarget;
			LayoutRecManager.dragItem(LayoutRecManager.target,LayoutRecManager.target["type"]);
			LayerManager.stage.on("mouseup",null,LayoutRecManager.onMouseUp);
			LayerManager.stage.on("mousemove",null,LayoutRecManager.onMouseMove);
		}

		LayoutRecManager.dragItem=function(target,type){
			(type===void 0)&& (type=0);
			var option={};
			var area=new Rectangle();
			if (type==0){
				area=(target).getDragArea();
			}
			else if (type==1){
				area=(target).getDragArea();
			}
			else{
				return;
			}
			option.area=area;
			DisControlTool.setTop(target);
			target.startDrag(area);
		}

		LayoutRecManager.onMouseUp=function(e){
			LayerManager.stage.off("mouseup",null,LayoutRecManager.onMouseUp);
			LayerManager.stage.off("mousemove",null,LayoutRecManager.onMouseMove);
			LayoutRecManager.doLayOut();
			LayoutRecManager.target.stopDrag();
			LayoutRecManager.target.left=Math.ceil(LayoutRecManager.target.x);
			LayoutRecManager.target.top=Math.ceil(LayoutRecManager.target.y);
		}

		LayoutRecManager.onMouseMove=function(e){
			LayoutRecManager.doLayOut();
		}

		LayoutRecManager.doLayOut=function(){
			(LayoutRecManager.target).updates();
		}

		LayoutRecManager.init=function(){
			LayoutRecManager._ct=new Box();
			LayoutRecManager._ct.mouseEnabled=true;
			LayoutRecManager._ct.name="LayoutRecManager_Container";
			LayoutRecManager._ct.width=0;
			LayoutRecManager._ct.height=0;
			LayerManager.stage.addChild(LayoutRecManager._ct);
			LayerManager.stage.on("resize",null,LayoutRecManager.resizeWork);
			LayoutRecManager._ct.on("dragDrop",null,LayoutRecManager.onDragDrop);
			LayerManager.stage.addChild(QuickTool.instance);
			MenuBar.instance.pos(1,1);
			QuickTool.instance.pos(LayoutRecManager.ctOffSetX+10,25);
			LayoutRecManager.layoutToPageType("page");
		}

		LayoutRecManager.resizeWork=function(e){
			LayoutRecManager._ct.x=LayoutRecManager.ctOffSetX;
			LayoutRecManager._ct.y=QuickTool.instance.y+LayoutRecManager.dToQuickTool;
			Laya.timer.once(50,null,LayoutRecManager.tryResizeNoScale,null,true);
			return;
		}

		LayoutRecManager.scaleResize=function(){
			var nW=LayerManager.stage.width-LayoutRecManager.ctOffSetX;
			var nH=LayerManager.stage.height-30+LayoutRecManager.ctOffHeight;
			if ((nW *nH *LayoutRecManager._ct.width *LayoutRecManager._ct.height)!=0){
				var scaleX=nW / LayoutRecManager._ct.width;
				var scaleY=nH / LayoutRecManager._ct.height;
				LayoutRecManager.adptScales(scaleX,scaleY);
			}
			LayoutRecManager._ct.width=LayerManager.stage.width-LayoutRecManager.ctOffSetX;
			LayoutRecManager._ct.height=LayerManager.stage.height-LayoutRecManager._ct.y+LayoutRecManager.ctOffHeight;
			Laya.timer.once(100,null,LayoutRecManager.adptAll);
		}

		LayoutRecManager.tryResizeNoScale=function(){
			var items;
			items=DisControlTool.getAllChild(LayoutRecManager._ct);
			var i=0,len=0;
			len=items.length;
			var tRec;
			var tRecHeight=0;
			var maxFree;
			for (i=0;i < len;i++){
				tRec=items[i];
				if ((tRec instanceof laya.editor.view.LayoutRec )){
					if(tRec.sizeFree){
						if(!maxFree||maxFree.height<tRec.height){
							maxFree=tRec;
						}
					}
				}
			}
			tRec=maxFree;
			if(!tRec||!tRec.sizeFree){
				LayoutRecManager.scaleResize();
				return;
				}else{
			};
			var nW=LayerManager.stage.width-LayoutRecManager.ctOffSetX;
			var nH=LayerManager.stage.height-LayoutRecManager._ct.y+LayoutRecManager.ctOffHeight;
			var pW=LayoutRecManager._ct.width;
			var pH=LayoutRecManager._ct.height;
			var dW=NaN;
			var dH=NaN;
			dW=nW-pW;
			dH=nH-pH;
			if ((nW *nH *pW *pH)!=0){
				if(dW+tRec.width<0){
					console.log("width not availeble");
					LayoutRecManager.scaleResize();
					return;
				}
				if(dH+tRec.height<0){
					console.log("height not availeble");
					LayoutRecManager.scaleResize();
					return;
				}
				}else{
				console.log("wrong size");
				LayoutRecManager.scaleResize();
				return;
			};
			var tDragBar;
			var barList;
			barList=[];
			var resizeStruct;
			resizeStruct=new ResizeRecStruct();
			var workDragBar;
			for (i=0;i < len;i++){
				tDragBar=items[i];
				if ((tDragBar instanceof laya.editor.comonents.LayoutDragBar )){
					tDragBar.walked=false;
					if(tDragBar.cusorType=="e-resize"){
						if(tDragBar.x>=tRec.x+10){
							barList.push(tDragBar);
						}
					}
					if(tDragBar.type==2){
						workDragBar=tDragBar;
						switch(tDragBar.getSideType()){
							case "right":
								resizeStruct.rightSide=tDragBar;
								break ;
							case "left":
								resizeStruct.leftSide=tDragBar;
								break ;
							case "up":
								resizeStruct.upSide=tDragBar;
								break ;
							case "down":
								resizeStruct.downSide=tDragBar;
								break ;
							}
					}
				}
			}
			resizeStruct.isRoot=true;
			resizeStruct.resizeItems=[];
			resizeStruct.tryMoveRight(dW);
			barList=[];
			for (i=0;i < len;i++){
				tDragBar=items[i];
				if ((tDragBar instanceof laya.editor.comonents.LayoutDragBar )){
					tDragBar.walked=false;
					if(tDragBar.cusorType=="n-resize"){
						if(tDragBar.y>=tRec.y+tRec.height||tDragBar.y+200>nH){
							barList.push(tDragBar);
							tDragBar.top+=dH;
						}
						if(tDragBar.type==2&&tDragBar.getSideType()=="down"&&tDragBar.cusorType=="n-resize"){
							workDragBar=tDragBar;
						}
					}
				}
			}
			if(workDragBar){
			}
			LayoutRecManager._ct.width=nW;
			LayoutRecManager._ct.height=nH;
			Laya.timer.once(100,null,LayoutRecManager.adptAll);
			MenuBar.instance.width=LayerManager.stage.width-2;
			QuickTool.instance.width=LayerManager.stage.width-2;
		}

		LayoutRecManager.adptDis=function(dis,scaleX,scaleY){
			dis.left *=scaleX;
			dis.right *=scaleX;
			dis.top *=scaleY;
			dis.bottom *=scaleY;
		}

		LayoutRecManager.adptScales=function(scaleX,scaleY){
			var items;
			items=DisControlTool.getAllChild(LayoutRecManager._ct);
			var i=0,len=0;
			len=items.length;
			var tDragBar;
			for (i=0;i < len;i++){
				tDragBar=items[i];
				if ((tDragBar instanceof laya.editor.comonents.LayoutDragBar )){
					LayoutRecManager.adptDis(tDragBar,scaleX,scaleY);
				}
			}
		}

		LayoutRecManager.adptAll=function(){
			var items;
			items=DisControlTool.getAllChild(LayoutRecManager._ct);
			var i=0,len=0;
			len=items.length;
			var tDragBar;
			for (i=0;i < len;i++){
				tDragBar=items[i];
				if ((tDragBar instanceof laya.editor.comonents.LayoutDragBar )){
					tDragBar.updates();
				}
			}
		}

		LayoutRecManager.saveLayoutInfo=function(){
			var items;
			items=DisControlTool.getAllChild(LayoutRecManager._ct);
			var i=0,len=0;
			len=items.length;
			for (i=0;i < len;i++){
				IDTools.idObj(items[i]);
			};
			var rst=[];
			var tDis;
			for (i=0;i < len;i++){
				tDis=items[i];
				if ((tDis instanceof laya.editor.comonents.LayoutDragBar )){
					rst.push(LayoutRecManager.getInfoO(tDis));
				}
				else if ((tDis instanceof laya.editor.view.LayoutRec )){
					rst.push(LayoutRecManager.saveRecInfo(tDis));
				}
			};
			var saveO;
			saveO={};
			saveO.width=LayoutRecManager._ct.width;
			saveO.height=LayoutRecManager._ct.height;
			saveO.items=rst;
			FileManager.createTxtFile(FileManager.getDataPath(LayoutRecManager.tLayoutFile),ObjectTools$1.getJsonString(saveO));
		}

		LayoutRecManager.showPanelByClassName=function(className){
			if(LayoutRecManager.popLocked())return;
			LayoutRecManager.initClassToUIO();
			var tPanel;
			tPanel=LayoutRecManager.classToUIO[className];
			LayoutRecManager.showPanelToStage(tPanel);
		}

		LayoutRecManager.showPanelToStage=function(tPanel){
			if (!tPanel)
				return;
			if (LayoutRecManager.isPanelInStage(tPanel))
				return;
			var rec=new LayoutRec();
			if (tPanel.width > 0 && tPanel.height > 0 && 0){
				rec.width=tPanel.width+5;
				rec.height=tPanel.height+20;
			}
			else{
				rec.width=tPanel["minWidth"]? tPanel["minWidth"]:200;
				if(rec.width<200)rec.width=200;
				rec.height=300;
			}
			LayoutRecManager.addPanelToRec(tPanel,rec);
			DisTools.showToCenter(rec,LayerManager.stage);
		}

		LayoutRecManager.removePanel=function(tPanel){
			var rec;
			rec=LayoutRecManager.findPanelRec(tPanel);
			if(rec){
				rec.removeUI(tPanel,true);
			}
		}

		LayoutRecManager.isPanelInStage=function(panel){
			var i=0,len=0;
			var childs;
			var layouts;
			layouts=[];
			childs=DisControlTool.getAllChild(LayoutRecManager._ct);
			len=childs.length;
			for (i=0;i < len;i++){
				if (((childs[i])instanceof laya.editor.view.LayoutRec )){
					ObjectTools$1.concatArr(layouts,childs[i].getUIs());
				}
			}
			childs=DisControlTool.getAllChild(LayerManager.stage);
			len=childs.length;
			for (i=0;i < len;i++){
				if (((childs[i])instanceof laya.editor.view.LayoutRec )){
					ObjectTools$1.concatArr(layouts,childs[i].getUIs());
				}
			}
			len=layouts.length;
			for (i=0;i < len;i++){
				if (layouts[i]==panel)
					return true;
			}
			return false;
		}

		LayoutRecManager.findPanelRec=function(panel){
			var i=0,len=0;
			var childs;
			var layouts;
			layouts=[];
			childs=DisControlTool.getAllChild(LayoutRecManager._ct);
			len=childs.length;
			for (i=0;i < len;i++){
				if (((childs[i])instanceof laya.editor.view.LayoutRec )){
					if(LayoutRecManager.isPanelInRec(panel,childs[i])){
						return childs[i];
					}
				}
			}
			childs=DisControlTool.getAllChild(LayerManager.stage);
			len=childs.length;
			for (i=0;i < len;i++){
				if (((childs[i])instanceof laya.editor.view.LayoutRec )){
					if(LayoutRecManager.isPanelInRec(panel,childs[i])){
						return childs[i];
					}
				}
			}
			return null;
		}

		LayoutRecManager.isPanelInRec=function(panel,rec){
			var layouts;
			layouts=rec.getUIs();
			if(!layouts)return false;
			return layouts.indexOf(panel)>=0;
		}

		LayoutRecManager.initClassToUIO=function(){
			if (!LayoutRecManager.classToUIO){
				LayoutRecManager.classToUIO={};
				LayoutRecManager.classToUIO["ResPanel"]=ResPanel.instance;
				LayoutRecManager.classToUIO["PagePanel"]=PagePanel.instance;
				LayoutRecManager.classToUIO["UIPanel"]=UIPanel.instance;
				LayoutRecManager.classToUIO["PropPanel"]=PropPanel.instance;
				LayoutRecManager.classToUIO["DisplayTreePanel"]=DisplayTreePanel.instance;
				LayoutRecManager.classToUIO["TimeLinePanel"]=TimeLinePanel.instance;
				LayoutRecManager.classToUIO["CompPanel"]=CompPanel.instance;
				LayoutRecManager.classToUIO["FramePropPanel"]=FramePropPanel.instance;
				LayoutRecManager.classToUIO["BasicPanel"]=BasicPanel.instance;
			}
		}

		LayoutRecManager.layoutByPagePath=function(pagePath){
			LayoutRecManager.layoutToPageType(TypeManager.getFileType(pagePath));
		}

		LayoutRecManager.layoutToPageType=function(type){
			LayoutRecManager.recoverLayoutInfo(Paths.getLayoutFilePathByType(type));
		}

		LayoutRecManager.recoverLayoutInfo=function(layoutFile){
			(layoutFile===void 0)&& (layoutFile="layout/layout.config");
			if(LayoutRecManager._layoutFile==layoutFile)return;
			if(LayoutRecManager._layoutFile){
				LayoutRecManager.saveLayoutInfo();
			}
			LayoutRecManager.clearAll();
			LayoutRecManager.initClassToUIO();
			LayoutRecManager._layoutFile=layoutFile;
			var path;
			path=FileManager.getDataPath(LayoutRecManager.tLayoutFile);
			if (!FileTools.exist(path)){
				LayoutRecManager.createDefault();
				return;
			}
			LayoutRecManager.layoutByLayoutFile(path);
		}

		LayoutRecManager.layoutByLayoutFile=function(path){
			var layoutO;
			layoutO=ObjectTools$1.getObj(FileManager.readTxtFile(path));
			LayoutRecManager._ct.width=layoutO.width;
			LayoutRecManager._ct.height=layoutO.height;
			var itemList;
			itemList=layoutO.items;
			var i=0,len=0;
			len=itemList.length;
			var tO;
			var tDis;
			var tClass;
			var objDic={};
			for (i=0;i < len;i++){
				tO=itemList[i];
				tClass=LayoutRecManager.itemClassO[tO.className];
				if (!tClass)
					continue ;
				if (tClass==LayoutDragBar){
					var type=tO.width < tO.height ? "R" :"T";
					tDis=LayoutRecManager.getADragBar(type);
				}
				else{
					tDis=new tClass();
				}
				ObjectTools$1.copyValueByArr(tDis,tO,LayoutRecManager.sizeInfos);
				objDic[tO.id]=tDis;
				if ((tDis instanceof laya.editor.comonents.LayoutDragBar )){
				}
				if ((tDis instanceof laya.editor.view.LayoutRec )){
					LayoutRecManager.recoverLayoutRec(tDis,tO);
				}
				LayoutRecManager._ct.addChild(tDis);
			};
			var key;
			var tar;
			var relativeO;
			for (i=0;i < len;i++){
				tO=itemList[i];
				tDis=objDic[tO.id];
				relativeO=tO.relativeO;
				if (relativeO){
					for (key in relativeO){
						tar=objDic[relativeO[key]];
						if (tar){
							RelativePos.addRelative(tDis,tar,key);
						}
						else{
							console.log("tar not find");
						}
					}
				}
				else{
					console.log("relativeO not find");
				}
				ObjectTools$1.copyValueByArr(tDis,tO,LayoutRecManager.sizeInfos);
			}
			LayoutRecManager.adptAll();
			LayoutRecManager.resizeWork();
		}

		LayoutRecManager.recoverLayoutRec=function(rec,data){
			var i=0,len=0;
			var uiList;
			uiList=data.uiList;
			len=uiList.length;
			var tUI;
			for (i=0;i < len;i++){
				tUI=LayoutRecManager.classToUIO[uiList[i]];
				if (tUI){
					LayoutRecManager.addPanelToRec(tUI,rec);
				}
			}
			if(parseInt(data.select)>0){
				rec.tab.selectedIndex=data.select;
			}
			if(rec.tab.items.length<1){
				Laya.timer.once(1000,null,LayoutRecManager.removeRec,[rec]);
			}
		}

		LayoutRecManager.saveRecInfo=function(rec){
			var rst;
			rst=LayoutRecManager.getInfoO(rec);
			var uiList;
			var i=0,len=0;
			uiList=rec.tab.items;
			var saveList;
			len=uiList.length;
			var tab;
			saveList=[];
			for (i=0;i < len;i++){
				tab=uiList[i];
				saveList.push(ClassTool.getClassName(tab.ui));
			}
			rst.select=rec.tab.selectedIndex;
			rst.uiList=saveList;
			return rst;
		}

		LayoutRecManager.getInfoO=function(obj){
			var rst;
			rst={};
			ObjectTools$1.copyValueByArr(rst,obj,LayoutRecManager.sizeInfos);
			rst.className=ClassTool.getClassName(obj);
			rst.id=IDTools.getObjID(obj);
			rst.relativeO=RelativePos.saveRelative(obj);
			return rst;
		}

		LayoutRecManager.onDragDrop=function(e){
			if (!e.data)
				return;
			var tType;
			tType=e.data.type;
			if (tType !="LayoutRec" && tType !="LayoutTab")
				return;
			var src;
			src=e.data.target;
			if (!src)
				return;
			var hitList;
			hitList=e.hitList;
			var i=0,len=0;
			len=hitList.length;
			var tTarget;
			if (hitList.indexOf(src)>=0){
				tTarget=src;
				if (tType !="LayoutTab"){
					if (tType=="LayoutRec"){
						LayoutRecManager.popRec(src);
						return;
					}
				}
			}
			else{
				for (i=0;i < len;i++){
					tTarget=hitList[i];
					if ((tTarget instanceof laya.editor.view.LayoutRec )){
						if(RelativePos.getDisMouseRelativePos(tTarget)!="out"){
							break ;
						}
					}
				}
			}
			if (!((tTarget instanceof laya.editor.view.LayoutRec )))
				return;
			if(tTarget.parent!=LayoutRecManager._ct)return;
			if (src !=tTarget || tType=="LayoutTab"){
				var posType;
				posType=RelativePos.getDisMouseRelativePos(tTarget);
				if (tType=="LayoutRec"){
					switch (posType){
						case "up":
							LayoutRecManager.removeRec(src);
							LayoutRecManager.insetToBarV(RelativePos.getBar(tTarget,"up"),src);
							break ;
						case "down":
							LayoutRecManager.removeRec(src);
							LayoutRecManager.insertV(tTarget,src);
							break ;
						case "left":
							LayoutRecManager.removeRec(src);
							LayoutRecManager.insertL(tTarget,src);
							break ;
						case "center":
							if(src.parent==LayerManager.stage)return;
						case "right":
							LayoutRecManager.removeRec(src);
							LayoutRecManager.insert(tTarget,src);
							break ;
						default :
							return;
						}
				}
				else if (tType=="LayoutTab"){
					var tTab;
					tTab=e.dragInitiator;
					var tRec;
					tRec=tTarget;
					if (src==tTarget){
						if (src.tab.items.length <=1){
							LayoutRecManager.popRec(src);
							return;
						}
						else{
							if (posType=="center"){
								src.removeTab(tTab);
								tRec=new LayoutRec();
								tRec.pos(src.x,src.y);
								src.parent.addChild(tRec);
								tRec.addTab(tTab);
								LayoutRecManager.popRec(tRec);
								return;
							}
						}
					}
					switch (posType){
						case "down":
							src.removeTab(tTab);
							tRec=new LayoutRec();
							tRec.addTab(tTab);
							LayoutRecManager.insertV(tTarget,tRec);
							break ;
						case "right":
							src.removeTab(tTab);
							tRec=new LayoutRec();
							tRec.addTab(tTab);
							LayoutRecManager.insert(tTarget,tRec);
							break ;
						case "left":
							src.removeTab(tTab);
							tRec=new LayoutRec();
							tRec.addTab(tTab);
							LayoutRecManager.insertL(tTarget,tRec);
							break ;
						case "center":
						case "up":
							if(!tRec.canAddTab)return;
							if (src !=tRec){
								src.removeTab(tTab);
								tRec.addTab(tTab);
							}
							else{
								return;
								src.removeTab(tTab);
								tRec=new LayoutRec();
								tRec.addTab(tTab);
								LayoutRecManager.popRec(tRec);
							}
							break ;
						default :
							return;
						}
					if (src.tab.items.length < 1){
						LayoutRecManager.removeRec(src);
					}
				}
			}
		}

		LayoutRecManager.test=function(){
			var _leftBar;
			var _rightBar;
			var _upBar;
			var _downBar;
			_leftBar=LayoutRecManager.getADragBar("R");
			_leftBar.width=5;
			_leftBar.left=0;
			_leftBar.top=0;
			_leftBar.bottom=0;
			_leftBar.type=2;
			LayoutRecManager._ct.addChild(_leftBar);
			_rightBar=LayoutRecManager.getADragBar("R");
			_rightBar.width=5;
			_rightBar.right=0;
			_rightBar.top=0;
			_rightBar.bottom=0;
			_rightBar.type=2;
			LayoutRecManager._ct.addChild(_rightBar);
			_upBar=LayoutRecManager.getADragBar("T");
			_upBar.height=5;
			_upBar.left=0;
			_upBar.top=0;
			_upBar.right=0;
			_upBar.type=2;
			LayoutRecManager._ct.addChild(_upBar);
			_downBar=LayoutRecManager.getADragBar("T");
			_downBar.height=5;
			_downBar.left=0;
			_downBar.bottom=0;
			_downBar.right=0;
			_downBar.type=2;
			LayoutRecManager._ct.addChild(_downBar);
			var rec=LayoutRecManager.getARec();
			LayoutRecManager._ct.addChild(rec);
			rec.left=0;
			rec.right=0;
			rec.top=0;
			rec.bottom=0;
			RelativePos.addRelative(rec,_leftBar,"left");
			RelativePos.addRelative(rec,_rightBar,"right");
			RelativePos.addRelative(rec,_upBar,"up");
			RelativePos.addRelative(rec,_downBar,"down");
			LayoutRecManager.insert(rec,LayoutRecManager.getARec());
			var tRec;
			tRec=LayoutRecManager.getARec();
			LayoutRecManager.insertV(rec,tRec);
			LayoutRecManager.insert(tRec,LayoutRecManager.getARec());
			console.log("onlySide:",RelativePos.getOnlySide(tRec));
			LayoutRecManager.insertV(tRec,LayoutRecManager.getARec());
			console.log("onlySide:",RelativePos.getOnlySide(tRec));
		}

		LayoutRecManager.clearAll=function(){
			LayoutRecManager.clearLayoutsOfContainer(LayoutRecManager._ct);
			LayoutRecManager.clearLayoutsOfContainer(LayerManager.stage);
		}

		LayoutRecManager.clearLayoutsOfContainer=function(_ct){
			var items;
			items=DisControlTool.getAllChild(_ct);
			var i=0,len=0;
			len=items.length;
			var tDis;
			for (i=0;i < len;i++){
				tDis=items[i];
				if ((tDis instanceof laya.editor.comonents.LayoutDragBar )){
					(tDis).clears();
					tDis.removeSelf();
				}
				else if ((tDis instanceof laya.editor.view.LayoutRec )){
					(tDis).clears();
					tDis.removeSelf();
				}
			}
		}

		LayoutRecManager.createDefault=function(){
			LayoutRecManager.clearAll();
			LayoutRecManager.resizeWork();
			var path;
			path=FileManager.getAppPath("laya/tpls/default.config");
			if(FileTools.exist(path)){
				LayoutRecManager.layoutByLayoutFile(path);
				return;
			};
			var _leftBar;
			var _rightBar;
			var _upBar;
			var _downBar;
			_leftBar=LayoutRecManager.getADragBar("R");
			_leftBar.width=5;
			_leftBar.left=0;
			_leftBar.top=0;
			_leftBar.bottom=0;
			_leftBar.type=2;
			LayoutRecManager._ct.addChild(_leftBar);
			_rightBar=LayoutRecManager.getADragBar("R");
			_rightBar.width=5;
			_rightBar.right=0;
			_rightBar.top=0;
			_rightBar.bottom=0;
			_rightBar.type=2;
			LayoutRecManager._ct.addChild(_rightBar);
			_upBar=LayoutRecManager.getADragBar("T");
			_upBar.height=5;
			_upBar.left=0;
			_upBar.top=0;
			_upBar.right=0;
			_upBar.type=2;
			LayoutRecManager._ct.addChild(_upBar);
			_downBar=LayoutRecManager.getADragBar("T");
			_downBar.height=5;
			_downBar.left=0;
			_downBar.bottom=0;
			_downBar.right=0;
			_downBar.type=2;
			LayoutRecManager._ct.addChild(_downBar);
			RelativePos.addRelative(_upBar,_leftBar,"left");
			RelativePos.addRelative(_upBar,_rightBar,"right");
			RelativePos.addRelative(_downBar,_leftBar,"left");
			RelativePos.addRelative(_downBar,_rightBar,"right");
			RelativePos.addRelative(_leftBar,_upBar,"up");
			RelativePos.addRelative(_leftBar,_downBar,"down");
			RelativePos.addRelative(_rightBar,_upBar,"up");
			RelativePos.addRelative(_rightBar,_downBar,"down");
			var rec=new LayoutRec();
			LayoutRecManager._ct.addChild(rec);
			rec.left=0;
			rec.right=0;
			rec.top=0;
			rec.bottom=0;
			RelativePos.addRelative(rec,_leftBar,"left");
			RelativePos.addRelative(rec,_rightBar,"right");
			RelativePos.addRelative(rec,_upBar,"up");
			RelativePos.addRelative(rec,_downBar,"down");
			LayoutRecManager.addPanelToRec(PagePanel.instance,rec);
			var uiRec;
			uiRec=new LayoutRec();
			LayoutRecManager.insert(rec,uiRec,0.8);
			LayoutRecManager.addPanelToRec(UIPanel.instance,uiRec);
			var resRec;
			resRec=new LayoutRec();
			LayoutRecManager.insertV(rec,resRec);
			LayoutRecManager.addPanelToRec(CompPanel.instance,resRec);
			LayoutRecManager.addPanelToRec(ResPanel.instance,resRec);
			var propRec;
			propRec=new LayoutRec();
			LayoutRecManager.insert(uiRec,propRec,0.3);
			LayoutRecManager.addPanelToRec(PropPanel.instance,propRec);
			var disTreeRec;
			disTreeRec=new LayoutRec();
			LayoutRecManager.insertV(propRec,disTreeRec);
			LayoutRecManager.addPanelToRec(DisplayTreePanel.instance,disTreeRec);
		}

		LayoutRecManager.popRec=function(tar){
			if (tar.parent==LayerManager.stage)
				return;
			var point;
			point=new Point();
			point=tar.localToGlobal(point);
			point=LayerManager.stage.globalToLocal(point);
			var posInfo={};
			ObjectTools$1.copyValueByArr(posInfo,tar,LayoutRecManager.sizePosKeys);
			posInfo.x=point.x+DragManager.dPos.x;
			posInfo.y=point.y+DragManager.dPos.y;
			LayoutRecManager.removeRec(tar);
			DisControlTool.clearItemRelativeInfo(tar);
			LayoutRecManager.addToStageLater(tar,posInfo);
		}

		LayoutRecManager.addToStageLater=function(tar,posInfo){
			LayerManager.stage.addChild(tar);
			if(posInfo.height<200)posInfo.height=200;
			tar.x=posInfo.x-10;
			tar.y=posInfo.y-10;
			tar.width=posInfo.width+20;
			tar.height=posInfo.height+20;
		}

		LayoutRecManager.clearRelativePosition=function(tar){
			tar.top=NaN;
			tar.bottom=NaN;
			tar.left=NaN;
			tar.right=NaN;
		}

		LayoutRecManager.removeRec=function(tar){
			var onlySide;
			onlySide=RelativePos.getOnlySide(tar);
			if (!onlySide){
				console.log("无可拖动条");
				tar.removeSelf();
				RelativePos.clearBar(tar);
				return;
			};
			var onlyBar;
			onlyBar=RelativePos.getBar(tar,onlySide);
			var otherSide;
			otherSide=RelativePos.getOtherSide(onlySide);
			var otherBar;
			otherBar=RelativePos.getBar(tar,otherSide);
			if (onlyBar && otherBar){
				otherBar.mergeUpdates(onlyBar);
				onlyBar.removeSelf();
				onlyBar.clears();
				RelativePos.clearBar(onlyBar);
				tar.removeSelf();
				RelativePos.clearBar(tar);
			}
			LayoutRecManager.adptAll();
		}

		LayoutRecManager.minRec=function(tar){
			var onlySide;
			onlySide=RelativePos.getOnlySide(tar);
			if (!onlySide)
				return;
			var onlyBar;
			onlyBar=RelativePos.getBar(tar,onlySide);
			var otherSide;
			otherSide=RelativePos.getOtherSide(onlySide);
			var otherBar;
			otherBar=RelativePos.getBar(tar,otherSide);
			if (onlyBar && otherBar){
				switch (onlySide){
					case "right":
						onlyBar.left-=tar.width-4;
						break ;
					case "left":
						onlyBar.left+=tar.width-4;
						break ;
					case "up":
						onlyBar.top+=tar.height-4;
						break ;
					case "down":
						onlyBar.top-=tar.height-4;
						break ;
					}
			}
			onlyBar.updates();
		}

		LayoutRecManager.recoverRec=function(tar){
			var onlySide;
			onlySide=RelativePos.getOnlySide(tar);
			if (!onlySide)
				return;
			var onlyBar;
			onlyBar=RelativePos.getBar(tar,onlySide);
			var otherSide;
			otherSide=RelativePos.getOtherSide(onlySide);
			var otherBar;
			otherBar=RelativePos.getBar(tar,otherSide);
			if (onlyBar && otherBar){
				switch (onlySide){
					case "right":
						onlyBar.left-=tar.width-tar.preWidth;
						break ;
					case "left":
						onlyBar.left+=tar.width-tar.preWidth;
						break ;
					case "up":
						onlyBar.top+=tar.height-tar.preHeight;
						break ;
					case "down":
						onlyBar.top-=tar.height-tar.preHeight;
						break ;
					}
			}
			onlyBar.updates();
		}

		LayoutRecManager.adptTo=function(tar){
			var onlySide;
			onlySide=RelativePos.getOnlySide(tar);
			if (!onlySide)
				return;
			var onlyBar;
			onlyBar=RelativePos.getBar(tar,onlySide);
			var otherSide;
			otherSide=RelativePos.getOtherSide(onlySide);
			var otherBar;
			otherBar=RelativePos.getBar(tar,otherSide);
			if (onlyBar && otherBar){
				switch (onlySide){
					case "right":
						onlyBar.left=tar.left+tar.width;
						break ;
					case "left":
						onlyBar.left=tar.left-onlyBar.width;
						break ;
					case "up":
						onlyBar.top=tar.top-onlyBar.height;
						break ;
					case "down":
						onlyBar.top=tar.top+tar.height;
						break ;
					}
			}
			onlyBar.updates();
		}

		LayoutRecManager.insetToBar=function(tar,insert,rate){
			(rate===void 0)&& (rate=0.4);
			var rec;
			rec=tar.getDragArea();
			rec.width=200;
			if (rec.width < 20)
				return;
			var tLen=0;
			tLen=rec.width;
			var dragBar;
			dragBar=LayoutRecManager.getADragBar("R");
			dragBar.size(5,tar.height);
			dragBar.right=tar.right;
			dragBar.left=tar.left
			dragBar.top=tar.top;
			dragBar.bottom=tar.bottom;
			dragBar.type=0;
			dragBar.mergeUpdates(tar);
			tar.clear();
			dragBar.left+=rate *tLen;
			RelativePos.clearBar(insert);
			insert.left=tar.left
			insert.top=tar.top;
			insert.bottom=tar.bottom;
			if (RelativePos.getBar(tar,"right")){
				RelativePos.copyRelative(dragBar,tar,"right");
			}
			RelativePos.addRelative(insert,tar,"left");
			RelativePos.addRelative(insert,dragBar,"right");
			RelativePos.copyRelative(insert,tar,"down");
			RelativePos.copyRelative(dragBar,tar,"down");
			RelativePos.copyRelative(insert,tar,"up");
			RelativePos.copyRelative(dragBar,tar,"up");
			LayoutRecManager._ct.addChild(dragBar);
			LayoutRecManager._ct.addChild(insert);
			LayoutRecManager.adptAll();
		}

		LayoutRecManager.insetToBarV=function(tar,insert,rate){
			(rate===void 0)&& (rate=0.4);
			var rec;
			rec=tar.getDragArea();
			rec.height=200;
			if (rec.height < 20)
				return;
			var tLen=0;
			tLen=rec.height;
			var dragBar;
			dragBar=LayoutRecManager.getADragBar("T");
			dragBar.size(tar.width,5);
			dragBar.right=tar.right;
			dragBar.left=tar.left
			dragBar.top=tar.top;
			dragBar.bottom=tar.bottom;
			dragBar.type=1;
			dragBar.copyUpdates(tar,"up");
			dragBar.top+=rate *tLen;
			RelativePos.clearBar(insert);
			insert.right=tar.right;
			insert.left=tar.left
			insert.top=tar.top;
			insert.bottom=tar.bottom;
			if (RelativePos.getBar(tar,"down")){
				RelativePos.copyRelative(dragBar,tar,"down");
				RelativePos.cancelRelative(tar,"down");
			}
			RelativePos.addRelative(insert,tar,"up");
			RelativePos.addRelative(insert,dragBar,"down");
			RelativePos.copyRelative(insert,tar,"right");
			RelativePos.copyRelative(dragBar,tar,"right");
			RelativePos.copyRelative(insert,tar,"left");
			RelativePos.copyRelative(dragBar,tar,"left");
			LayoutRecManager._ct.addChild(dragBar);
			LayoutRecManager._ct.addChild(insert);
			LayoutRecManager.adptAll();
		}

		LayoutRecManager.insert=function(tar,insert,rate){
			(rate===void 0)&& (rate=0.4);
			var tLen=0;
			tLen=tar.width;
			insert.right=tar.right;
			tar.right+=tLen *rate;
			insert.left=tar.x+tar.width;
			insert.top=tar.top;
			insert.bottom=tar.bottom;
			var dragBar;
			dragBar=LayoutRecManager.getADragBar("R");
			dragBar.size(5,tar.height);
			dragBar.left=tar.x+tar.width;
			dragBar.top=tar.top;
			dragBar.bottom=tar.bottom;
			if (RelativePos.getBar(tar,"right")){
				RelativePos.copyRelative(insert,tar,"right");
				RelativePos.cancelRelative(tar,"right");
			}
			RelativePos.addRelative(tar,dragBar,"right");
			RelativePos.addRelative(insert,dragBar,"left");
			RelativePos.copyRelative(insert,tar,"down");
			RelativePos.copyRelative(dragBar,tar,"down");
			RelativePos.copyRelative(insert,tar,"up");
			RelativePos.copyRelative(dragBar,tar,"up");
			tar.parent.addChild(dragBar);
			tar.parent.addChild(insert);
			DisControlTool.setTop(dragBar);
			dragBar.type=0;
			LayoutRecManager.adptAll();
		}

		LayoutRecManager.insertL=function(tar,insert,rate){
			(rate===void 0)&& (rate=0.4);
			var tLen=0;
			tLen=tar.width;
			insert.right=tar.right;
			insert.left=tar.left;
			tar.left+=tLen *rate;
			insert.top=tar.top;
			insert.bottom=tar.bottom;
			var dragBar;
			dragBar=LayoutRecManager.getADragBar("R");
			dragBar.size(5,tar.height);
			dragBar.left=tar.x;
			dragBar.top=tar.top;
			dragBar.bottom=tar.bottom;
			if (RelativePos.getBar(tar,"left")){
				RelativePos.copyRelative(insert,tar,"left");
				RelativePos.cancelRelative(tar,"left");
			}
			RelativePos.addRelative(tar,dragBar,"left");
			RelativePos.addRelative(insert,dragBar,"right");
			RelativePos.copyRelative(insert,tar,"down");
			RelativePos.copyRelative(dragBar,tar,"down");
			RelativePos.copyRelative(insert,tar,"up");
			RelativePos.copyRelative(dragBar,tar,"up");
			tar.parent.addChild(dragBar);
			tar.parent.addChild(insert);
			DisControlTool.setTop(dragBar);
			dragBar.type=0;
			LayoutRecManager.adptAll();
		}

		LayoutRecManager.insertV=function(tar,insert,rate){
			(rate===void 0)&& (rate=0.4);
			if(tar.height<150){
				var downBar;
				downBar=RelativePos.getBar(tar,"down");
				if(downBar.type!=2){
					LayoutRecManager.insetToBarV(downBar,insert);
					return;
				}
			};
			var tLen=0;
			tLen=tar.height;
			insert.right=tar.right;
			insert.bottom=tar.bottom;
			tar.bottom+=tLen *rate;
			insert.left=tar.left;
			insert.top=tar.y+tar.height;
			var dragBar;
			dragBar=LayoutRecManager.getADragBar("T");
			dragBar.size(tar.width,5);
			dragBar.left=tar.x;
			dragBar.top=tar.y+tar.height;
			if (RelativePos.getBar(tar,"down")){
				RelativePos.copyRelative(insert,tar,"down");
				RelativePos.cancelRelative(tar,"down");
			}
			RelativePos.addRelative(tar,dragBar,"down");
			RelativePos.addRelative(insert,dragBar,"up");
			RelativePos.copyRelative(insert,tar,"right");
			RelativePos.copyRelative(dragBar,tar,"right");
			RelativePos.copyRelative(insert,tar,"left");
			RelativePos.copyRelative(dragBar,tar,"left");
			tar.parent.addChild(dragBar);
			tar.parent.addChild(insert);
			DisControlTool.setTop(dragBar);
			dragBar.type=1;
			LayoutRecManager.adptAll();
		}

		LayoutRecManager.getADragBar=function(type){
			var dragBar=new LayoutDragBar(type);
			dragBar.on("mousedown",null,LayoutRecManager.onMouseDown);
			return dragBar;
		}

		LayoutRecManager.addPanelToRec=function(panel,rec){
			panel.top=20;
			panel.left=0;
			panel.right=0;
			panel.bottom=0;
			rec.addUI(panel);
		}

		LayoutRecManager.getARec=function(){
			var rec=new LayoutRec();
			rec.addUI(LayoutRecManager.getAUI("#ff00ff"));
			rec.addUI(LayoutRecManager.getAUI("#ff000f"));
			return rec;
		}

		LayoutRecManager.getAUI=function(color){
			(color===void 0)&& (color="#ff00ff");
			var box=new Box();
			box.graphics.drawRect(0,0,20,20,color);
			box.width=20;
			box.height=20;
			box.left=5;
			box.right=5;
			box["title"]="tt:"+Math.ceil(Math.random()*10);
			return box;
		}

		LayoutRecManager.target=null
		LayoutRecManager.Side=2;
		LayoutRecManager.Vertical=1;
		LayoutRecManager.Horizon=0;
		LayoutRecManager._ct=null
		LayoutRecManager.ctOffSetX=47;
		LayoutRecManager.dToQuickTool=32;
		LayoutRecManager.ctOffHeight=5;
		LayoutRecManager.classToUIO=null
		LayoutRecManager._layoutFile=null;
		LayoutRecManager.minRecLen=4;
		LayoutRecManager.DragBarWidth=5;
		__static(LayoutRecManager,
		['itemClassO',function(){return this.itemClassO={"LayoutDragBar":LayoutDragBar,"LayoutRec":LayoutRec};},'sizeInfos',function(){return this.sizeInfos=["height","width","left","right","bottom","top","x","y","type"];},'sizePosKeys',function(){return this.sizePosKeys=["x","y","width","height"];},'emptyLayoutO',function(){return this.emptyLayoutO={"top":NaN,"bottom":NaN,"left":NaN,"right":NaN};}
		]);
		return LayoutRecManager;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2017-4-6 上午10:07:48
	*/
	//class laya.ide.managers.NodeAtlasManager
	var NodeAtlasManager=(function(){
		function NodeAtlasManager(){}
		__class(NodeAtlasManager,'laya.ide.managers.NodeAtlasManager');
		NodeAtlasManager.getNodeAtlas=function(node){
			var type;
			type=node.type;
			if(!type)return null;
			if(NodeAtlasManager.isTextType(type)){
				return "TextAtlas";
			}
			if(!node.props)return null;
			var skinLabel;
			skinLabel=UIConfigManager.getCompSkinLabel(type);
			if(!skinLabel)return null;
			return node.props[skinLabel];
		}

		NodeAtlasManager.isTextType=function(type){
			return NodeAtlasManager._txtTypeDic[type];
		}

		NodeAtlasManager.getSkinPathColor=function(path){
			if(!path)return null;
			var folder;
			folder=FileTools.getFolder(path);
			if(!NodeAtlasManager._colorDic[folder]){
				NodeAtlasManager._index++;
				NodeAtlasManager._index=NodeAtlasManager._index%NodeAtlasManager._colors.length;
				NodeAtlasManager._colorDic[folder]=NodeAtlasManager._colors[NodeAtlasManager._index];
			}
			return NodeAtlasManager._colorDic[folder];
		}

		NodeAtlasManager.getNodeAtlasColor=function(node){
			return NodeAtlasManager.getSkinPathColor(NodeAtlasManager.getNodeAtlas(node));
		}

		NodeAtlasManager._colorDic={};
		NodeAtlasManager._index=0;
		__static(NodeAtlasManager,
		['_txtTypeDic',function(){return this._txtTypeDic={"Text":true,"Label":true,"TextArea":true};},'_colors',function(){return this._colors=["#FFFF00","#FF8247","#EE82EE","#CD00CD","#C6E2FF","#A52A2A","#9ACD32","#8B4513","#76EE00","#0000CD","#2E8B57"];}
		]);
		return NodeAtlasManager;
	})()


	/**
	*本类集中初始化各个模块监听的消息
	*@author ww
	*@version 1.0
	*
	*@created 2015-10-26 上午10:39:45
	*/
	//class laya.ide.managers.NoticeRouter
	var NoticeRouter=(function(){
		function NoticeRouter(){}
		__class(NoticeRouter,'laya.ide.managers.NoticeRouter');
		NoticeRouter.init=function(){
			NoticeRouter._initsList=[];
			NoticeRouter._initsList.push(AddDocument.instance);
			NoticeRouter._initsList.push(AddAnimation.instance);
			NoticeRouter._initsList.push(PagePanel.instance);
			NoticeRouter._initsList.push(UIPanel.instance);
			NoticeRouter._initsList.push(ResPanel.instance);
			NoticeRouter._initsList.push(AddDirectory.instance);
			NoticeRouter._initsList.push(MovePage.instance);
			NoticeRouter._initsList.push(RenamePage.instance);
			NoticeRouter._initsList.push(SetPageProp.instance);
			NoticeRouter._initsList.push(PropPanel.instance);
			NoticeRouter._initsList.push(DisplayTreePanel.instance);
			NoticeRouter._initsList.push(FindAndReplace.instance);
			NoticeRouter._initsList.push(FramePropPanel.instance);
			NoticeRouter._initsList.push(LangPanel.instance);
			NoticeRouter._initsList.push(SetIDE.instance);
			NoticeRouter._initsList.push(SetIDENew.instance);
			NoticeRouter._initsList.push(BasicPanel.instance);
			var i=0,len=NoticeRouter._initsList.length;
			for (i=0;i < len;i++){
				NoticeRouter._initsList[i].initListener();
			}
			Laya.stage.on("keydown",null,NoticeRouter.onKeyDown);
		}

		NoticeRouter.onKeyDown=function(e){
			if(!e.ctrlKey)return;
			switch(e.keyCode){
				case 73:
					Notice.notify("OPEN_ADD_TIMELINE_ANIMATION");
					return;
				case 77:
					IDELangManager.testSwitch();
					return;
				}
		}

		NoticeRouter._initsList=null
		return NoticeRouter;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-8-10 上午10:56:47
	*/
	//class laya.ide.managers.PluginManager
	var PluginManager=(function(){
		function PluginManager(){
			PluginPanel;
		}

		__class(PluginManager,'laya.ide.managers.PluginManager');
		var __proto=PluginManager.prototype;
		__proto.loadPlugins=function(){
			var config;
			var configPath;
			configPath=Paths.getPluginPath("plugin.cfg");
			if(FileTools.exist(configPath)){
				try{
					config=FileManager.readJSONFile(configPath);
					}catch(e){
				}
			}
			if(config){
				this.loadPluginsByConfig(config);
			}
		}

		__proto.loadPluginsByConfig=function(config){
			var pluginList;
			pluginList=config["plugins"];
			var i=0,len=0;
			len=pluginList.length;
			for(i=0;i<len;i++){
				this.loadPlugin(pluginList[i]);
			}
		}

		__proto.loadPlugin=function(plugin){
			var pluginPath;
			pluginPath=Paths.getPluginPath(plugin);
			if(!FileTools.exist(pluginPath)){
				console.log("plugin not find:",plugin);
				return;
			};
			var pluginConfig;
			try{
				pluginConfig=FileManager.readJSONFile(FileManager.getPath(pluginPath,"config.cfg"));
				}catch(e){
			}
			if(!pluginConfig){
				console.log("pluginConfig not find:",plugin);
				return;
			};
			var codes;
			codes=pluginConfig.codes;
			var i=0,len=0;
			len=codes.length;
			for(i=0;i<len;i++){
				this.loadPluginCodes(codes[i],pluginPath);
			}
			if(pluginConfig["menus"]){
				PluginManager.regMenus(pluginConfig["menus"]);
			}
		}

		__proto.loadPluginCodes=function(codeO,pluginPath){
			var hasUI=false;
			var htmlSp;
			var uiFile;
			var jsFile;
			if(codeO["ui"]){
				uiFile=FileManager.readTxtFile(FileManager.getPath(pluginPath,codeO["ui"]));
				hasUI=true;
			}
			if(codeO["code"]){
				jsFile=FileManager.readTxtFile(FileManager.getPath(pluginPath,codeO["code"]));
				eval(jsFile);
			};
			var plugin;
			if(codeO["class"]){
				var clz;
				var clzStr;
				clzStr=codeO["class"];
				clz=eval(clzStr);
				if(clz){
					plugin=new clz();
				}
			}
			if(!plugin)return;
			if(hasUI){
				htmlSp=new JSPlugin();
				htmlSp.setHtmlTxt(uiFile);
				htmlSp.title=codeO["title"];
			}
			if(codeO["isPanel"]){
				if(htmlSp){
					plugin.setUI(htmlSp);
					}else{
					plugin.title=codeO["title"];
					plugin.canClose=true;
				}
				}else{
				if(codeO["isDialog"]){
					var dialog;
					if(htmlSp){
						dialog=new PluginDialog();
						if(plugin.width&&plugin.height){
							htmlSp.size(plugin.width,plugin.height);
						}
						dialog.setHtmlContent(htmlSp);
						plugin.setUI(dialog);
						}else{
						dialog=plugin;
					}
					dialog.setTitle(codeO["title"]);
				}
			}
		}

		PluginManager.regMenus=function(menuList){
			var i=0,len=0;
			len=menuList.length;
			for(i=0;i<len;i++){
				var tMenuO;
				tMenuO=menuList[i];
				MenuBar.registButton("layaToolsMenu",tMenuO["title"],tMenuO["notice"]);
			}
		}

		__static(PluginManager,
		['I',function(){return this.I=new PluginManager();}
		]);
		return PluginManager;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-3-5 上午11:00:22
	*/
	//class laya.ide.managers.RenderManager
	var RenderManager=(function(){
		function RenderManager(){
			this.param=null;
			this.initors=[];
		}

		__class(RenderManager,'laya.ide.managers.RenderManager');
		var __proto=RenderManager.prototype;
		__proto.initCustomUIConfig=function(path,relative){
			(relative===void 0)&& (relative=true);
			var bPath;
			if(relative){
				bPath=FileManager.getAppPath(path);
				}else{
				bPath=path;
			}
			if(!FileTools.exist(bPath))return;
			var fileList;
			fileList=FileTools.getDirFiles(bPath);
			var i=0,len=0;
			len=fileList.length;
			var tFile;
			for(i=0;i<len;i++){
				tFile=fileList[i];
				if(tFile.indexOf(".xml")>=0){
					this.addCustomUIConfig(FileTools.getPath(bPath,tFile));
				}
			}
		}

		__proto.addCustomUIConfig=function(path){
			var jsFile;
			jsFile=path.replace(".xml",".js");
			var xmlFile;
			xmlFile=FileTools.readFile(path);
			var xml;
			xml=Utils$1.parseXMLFromString(xmlFile);
			var obj;
			obj=XML2Object.parse(xml);
			UIConfigManager.addNewConfig(obj.c.uiComp.c);
			if(!FileTools.exist(jsFile))return;
			var jsStrs;
			jsStrs=FileTools.readFile(jsFile);
			var tempscript=Browser.document.createElement("script");
			tempscript.innerHTML=jsStrs;
			Browser.document.body.appendChild(tempscript);
			var me=this;
			var initor;
			initor=laya.ide.Initiator;
			if(initor){
				me.initors.push(initor);
			}
			this.setRenderPropByFont(null);
		}

		__proto.setRenderProp=function(param){
			var i=0,len=0;
			len=this.initors.length;
			var initor;
			for(i=0;i<len;i++){
				initor=this.initors[i];
				if(initor&&initor["init"]){
					initor["init"](param);
				}
			}
		}

		__proto.setRenderPropByFont=function(font){
			if(!this.param){
				this.param={};
				this.param.createComp=UIView.createCompS;
			}
			if(font&&font.length>0){
				this.param.font=font;
				}else{
				delete this.param["font"];
			}
			this.setRenderProp(this.param);
		}

		__proto.initRenders=function(){
			this.initCustomUIConfig("renders/");
			this.initCustomUIConfig("renders/"+"/custom");
			this.setRenderPropByFont(null);
		}

		__proto.loadProjectCustomUIConfig=function(){
			var uiConfigPath;
			uiConfigPath=FileManager.getWorkPath("laya/custom");
			console.log("customUI:",uiConfigPath);
			this.initCustomUIConfig(uiConfigPath,false);
		}

		RenderManager.addXMLConfig=function(path){
			var xmlFile;
			xmlFile=FileTools.readFile(path);
			var xml;
			xml=XMLElement.parseXmlFromString(xmlFile);
			var obj;
			obj=XML2ObjectNodejs.parse(xml);
			UIConfigManager.addNewConfig(obj.c.uiComp.c);
		}

		__static(RenderManager,
		['I',function(){return this.I=new RenderManager();}
		]);
		return RenderManager;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.ide.managers.ResFileManager
	var ResFileManager=(function(){
		function ResFileManager(){}
		__class(ResFileManager,'laya.ide.managers.ResFileManager');
		ResFileManager.setPath=function(path){
			if(ResFileManager._oldGetRes==null){
			}
			if(!FileTools.exist(path))return;
			ResFileManager._prePath=path;
			ResFileManager.basePath=FileTools.getAbsPath(path);
			if (SystemSetting.isCMDVer)return;
			if(!ResFileManager._watcher){
				ResFileManager._watcher=new DirWatcherNew();
			}
			ResFileManager._watcher.setPath(path);
			ResFileManager.getAllResFiles(path);
			Notice.listen("RESFILE_CHANGE",null,ResFileManager.resFileChange,null,true);
		}

		ResFileManager.resFileChange=function(file){
			if(!file)return;
			if(!FileTools.exist(file))return;
			if(FontLoader.isFontFile(file)){
				file=FileTools.getAbsPath(file);
				if(!FontLoader.isOkFont(file))return;
				var tdata;
				tdata=FontLoader.getFontLoaderItem(file);
				ResFileManager.clearRes(tdata.url);
				Laya.loader.load([tdata],new Handler(null,ResFileManager.resLoaded));
				return;
			}
			if(!ResFileManager.isResFile(file))return;
			file=FileTools.getAbsPath(file);
			ResFileManager.clearRes(file);
			Laya.loader.load([file],new Handler(null,ResFileManager.resLoaded));
		}

		ResFileManager.clearPreLoadRes=function(){
			var i=0,len=0;
			len=ResFileManager.preLoadList.length;
			for(i=0;i<len;i++){
				ResFileManager.clearRes(ResFileManager.preLoadList[i]);
			}
			ResFileManager.preLoadList.length=0;
		}

		ResFileManager.getAllResFiles=function(path){
			ResFileManager.clearPreLoadRes();
			path=path?path:ResFileManager._prePath;
			if(!FileTools.exist(path))return;
			var arr;
			arr=FileTools.getFileList(path);
			var i=0,len=0;
			len=arr.length;
			var loadList;
			loadList=[];
			for(i=0;i<len;i++){
				if (ResFileManager.isResFile(arr[i])){
					if(ResFileManager.enableBinaryPic)continue ;
					arr[i]=FileTools.getAbsPath(arr[i]);
					ResFileManager.clearRes(arr[i]);
					loadList.push(arr[i]);
					ResFileManager.preLoadList.push(arr[i]);
				}
				if(FontLoader.isFontFile(arr[i])){
					arr[i]=FileTools.getAbsPath(arr[i]);
					if(!FontLoader.isOkFont(arr[i]))continue ;
					var tdata;
					tdata=FontLoader.getFontLoaderItem(arr[i]);
					ResFileManager.clearRes(tdata.url);
					loadList.push(tdata);
					ResFileManager.preLoadList.push(arr[i]);
				}
			}
			if(loadList.length<1){
				ResFileManager.resLoaded();
				return;
			}
			Laya.loader.load(loadList,new Handler(null,ResFileManager.resLoaded));
		}

		ResFileManager.getAllResFileList=function(path){
			path=path?path:ResFileManager._prePath;
			if(!FileTools.exist(path))return [];
			var arr;
			arr=FileTools.getFileList(path);
			var i=0,len=0;
			len=arr.length;
			var loadList;
			loadList=[];
			for(i=0;i<len;i++){
				if (ResFileManager.isResFile(arr[i])){
					loadList.push(arr[i]);
				}
			}
			return loadList;
		}

		ResFileManager.getAllResLinkList=function(path){
			path=path?path:ResFileManager._prePath;
			var resList;
			resList=ResFileManager.getAllResFileList(path);
			var i=0,len=0;
			var rst;
			rst=[];
			len=resList.length;
			for(i=0;i<len;i++){
				rst.push(FileManager.adptToCommonUrl(FileManager.getRelativePath(SystemSetting.assetsPath,resList[i])));
			}
			return rst;
		}

		ResFileManager.getAllUnPackLinkList=function(path){
			path=path?path:ResFileManager._prePath;
			path=path?path:ResFileManager._prePath;
			var resList;
			resList=ResFileManager.getAllResFileList(path);
			var i=0,len=0;
			var rst;
			rst=[];
			len=resList.length;
			var compStr;
			for(i=0;i<len;i++){
				compStr=FileManager.adptToCommonUrl(FileManager.getRelativePath(SystemSetting.assetsPath,resList[i]));
				if(!ResStyleManager.getFinalPackResult(compStr,ResPanel.isPackRes(compStr)||compStr.indexOf(".")<=0)){
					rst.push(compStr);
				}
			}
			return rst;
		}

		ResFileManager.resLoaded=function(){
			console.log("resLoaded");
			if(ResFileManager.resLoadCompleteHandler){
				ResFileManager.resLoadCompleteHandler.run();
				ResFileManager.resLoadCompleteHandler=null;
			}
			ResFileManager.clearePreResWorkLater();
		}

		ResFileManager.isResFile=function(path){
			if (FileTools.isDirectory(path))return false;
			var exName;
			exName=FileTools.getExtensionName(path);
			if (exName=="png" || exName=="jpg")return true;
			return false;
		}

		ResFileManager.clearRes=function(url){
			var fmtUrl;
			fmtUrl=ResFileManager.formatURL(url);
			ResFileManager.clearLoaderRes(fmtUrl);
		}

		ResFileManager.clearLoaderRes=function(url){
			url=URL.formatURL(url);
			var res=Loader.loadedMap[url];
			delete Loader.loadedMap[url];
			if ((res instanceof laya.resource.Texture )){
				ResFileManager.preClearRess.push(res);
			}
			Laya.timer.clear(null,ResFileManager.clearPreResWork);
		}

		ResFileManager.clearPreResWork=function(){
			console.log("clearTextures");
			var i=0,len=0;
			len=ResFileManager.preClearRess.length;
			for(i=0;i<len;i++){
				(ResFileManager.preClearRess [i]).destroy();
			}
			ResFileManager.preClearRess.length=0;
		}

		ResFileManager.clearePreResWorkLater=function(){
			Laya.timer.once(6*1000,null,ResFileManager.clearPreResWork);
		}

		ResFileManager.getRes=function(url){
			var rst;
			var apPath;
			apPath=ResFileManager.formatURL(url);
			rst=BinaryPicTools.getRes(apPath);
			if(rst)return rst;
			rst=ResFileManager.oldGetRes(ResFileManager.formatURL(url));
			if(!rst){
				rst=ResFileManager.oldGetRes("comp/loseskin.png");
			}
			return rst;
			return ResFileManager.oldGetRes(ResFileManager.formatURL(url));
		}

		ResFileManager.hookGetRes=function(url){
			var o;
			o=ResFileManager.hookGetRes;
			if(Loader.loadedMap[URL.formatURL(url)]||o["caller"]==Laya.loader.load)return Loader.loadedMap[URL.formatURL(url)];
			return ResFileManager.getRes(url);
		}

		ResFileManager.oldGetRes=function(url){
			if(ResFileManager._oldGetRes!=null)return ResFileManager._oldGetRes(url);
			return Loader.getRes(url);
		}

		ResFileManager.hookLoaderLoad=function(){}
		ResFileManager.hasRes=function(url){
			var fUrl;
			fUrl=ResFileManager.formatURL(url);
			if (SystemSetting.isCMDVer){
				return FileTools.exist(fUrl);
			}
			if(!FileTools.exist(fUrl))return false;
			if(ResFileManager.enableBinaryPic){
				return ResFileManager.getRes(url);
			}
			if(Loader.getRes(ResFileManager.formatURL(url)))return true;
			return false;
		}

		ResFileManager.cacheRes=function(url,data){
			Loader.cacheRes(ResFileManager.formatURL(url),data);
		}

		ResFileManager.formatURL=function(url){
			if (!url)return url;
			if(FileTools.isAbsPath(url))return url;
			var rst;
			rst=(url.indexOf(":/")> 0)?url:ResFileManager.basePath+FileTools.path.sep+FileManager.adptToLocalUrl(url);
			return rst;
		}

		ResFileManager.adptToCommonUrl=function(url){
			return FileManager.adptToCommonUrl(url);
		}

		ResFileManager.getIDEResPath=function(url){
			return FileManager.adptToCommonUrl(FileTools.getAbsPath(FileManager.getPath(SystemSetting.assetsPath,url)));
		}

		ResFileManager.getIDEPagePath=function(url){
			return FileTools.getAbsPath(FileManager.getPath(SystemSetting.pagesPath,url));
		}

		ResFileManager.getIDECompIconPath=function(iconSign){
			return FileTools.getAbsPath(FileManager.getAppPath("laya/icons/components/"+iconSign+".png"));
		}

		ResFileManager._prePath=null
		ResFileManager._watcher=null
		ResFileManager.preLoadList=[];
		ResFileManager.enableBinaryPic=true;
		ResFileManager.resLoadCompleteHandler=null
		ResFileManager.preClearRess=[];
		ResFileManager._oldGetRes=null
		ResFileManager.basePath="";
		return ResFileManager;
	})()


	/**
	*本类用于调整对象的宽高以及坐标
	*@author ww
	*/
	//class laya.ide.managers.resizer.DisResizer
	var DisResizer=(function(){
		function DisResizer(){}
		__class(DisResizer,'laya.ide.managers.resizer.DisResizer');
		DisResizer.init=function(){
			if (DisResizer._up)return;
			DisResizer._up=new AutoFillRec("T");
			DisResizer._up.height=2;
			DisResizer._up.type=0;
			DisResizer._down=new AutoFillRec("T");
			DisResizer._down.height=2;
			DisResizer._down.type=0;
			DisResizer._left=new AutoFillRec("R");
			DisResizer._left.width=2;
			DisResizer._left.type=1;
			DisResizer._right=new AutoFillRec("R");
			DisResizer._right.width=2;
			DisResizer._right.type=1;
			DisResizer._barList=[DisResizer._up,DisResizer._down,DisResizer._left,DisResizer._right];
			DisResizer.addEvent();
		}

		DisResizer.stageDown=function(e){
			var target;
			target=e.target;
			if (DisResizer._tar && DisControlTool.isInTree(DisResizer._tar,target)){
				return;
			}
			DisResizer.clear();
		}

		DisResizer.clear=function(){
			DisResizer._tar=null;
			Laya.stage.off("mouseup",null,DisResizer.stageDown);
			DisControlTool.removeItems(DisResizer._barList);
			DisResizer.clearDragEvents();
		}

		DisResizer.addEvent=function(){
			var i=0,len=0;
			var tBar;
			len=DisResizer._barList.length;
			for (i=0;i < len;i++){
				tBar=DisResizer._barList[i];
				tBar.on("mousedown",null,DisResizer.barDown);
			}
		}

		DisResizer.barDown=function(e){
			DisResizer.clearDragEvents();
			DisResizer.tBar=e.target;
			if (!DisResizer.tBar)return;
			var area;
			area=new Rectangle();
			if (DisResizer.tBar.type==0){
				area.x=DisResizer.tBar.x;
				area.width=0;
				area.y=DisResizer.tBar.y-200;
				area.height=400;
				}else{
				area.x=DisResizer.tBar.x-200;
				area.width=400;
				area.y=0;
				area.height=0;
			};
			var option;
			option={};
			option.area=area;
			DisResizer.tBar.record();
			DisResizer.tBar.startDrag(area);
			DisResizer.tBar.on("dragmove",null,DisResizer.draging);
			DisResizer.tBar.on("dragend",null,DisResizer.dragEnd);
		}

		DisResizer.draging=function(e){
			if (!DisResizer.tBar)return;
			if (!DisResizer._tar)return;
			switch(DisResizer.tBar){
				case DisResizer._left:
					DisResizer._tar.x+=DisResizer.tBar.getDx();
					DisResizer._tar.width-=DisResizer.tBar.getDx();
					DisResizer._up.width-=DisResizer.tBar.getDx();
					DisResizer._down.width-=DisResizer.tBar.getDx();
					DisResizer._right.x-=DisResizer.tBar.getDx();
					DisResizer.tBar.x-=DisResizer.tBar.getDx();
					break ;
				case DisResizer._right:
					DisResizer._tar.width+=DisResizer.tBar.getDx();
					DisResizer._up.width+=DisResizer.tBar.getDx();
					DisResizer._down.width+=DisResizer.tBar.getDx();
					break ;
				case DisResizer._up:
					DisResizer._tar.y+=DisResizer.tBar.getDy();
					DisResizer._tar.height-=DisResizer.tBar.getDy();
					DisResizer._right.height-=DisResizer.tBar.getDy();
					DisResizer._left.height-=DisResizer.tBar.getDy();
					DisResizer._down.y-=DisResizer.tBar.getDy();
					DisResizer.tBar.y-=DisResizer.tBar.getDy();
					break ;
				case DisResizer._down:
					DisResizer._tar.height+=DisResizer.tBar.getDy();
					DisResizer._right.height+=DisResizer.tBar.getDy();
					DisResizer._left.height+=DisResizer.tBar.getDy();
					break ;
				}
			DisResizer.tBar.record();
		}

		DisResizer.dragEnd=function(e){
			DisResizer.clearDragEvents();
			DisResizer.updates();
		}

		DisResizer.clearDragEvents=function(){
			if (!DisResizer.tBar)return;
			DisResizer.tBar.off("dragmove",null,DisResizer.draging);
			DisResizer.tBar.off("dragend",null,DisResizer.dragEnd);
		}

		DisResizer.setUp=function(dis,force){
			(force===void 0)&& (force=false);
			if (force && dis==DisResizer._tar){
				return;
			};
			DisControlTool.removeItems(DisResizer._barList);
			if (DisResizer._tar==dis){
				DisResizer._tar=null;
				DisResizer.clearDragEvents();
				if(!force)
					return;
			}
			DisResizer._tar=dis;
			DisResizer.updates();
			DisControlTool.addItems(DisResizer._barList,dis);
			Laya.stage.off("mouseup",null,DisResizer.stageDown);
			Laya.stage.on("mouseup",null,DisResizer.stageDown);
		}

		DisResizer.updates=function(){
			var dis;
			dis=DisResizer._tar;
			if(!dis)return;
			var bounds;
			bounds=new Rectangle(0,0,dis.width,dis.height);
			DisResizer._up.x=bounds.x;
			DisResizer._up.y=bounds.y;
			DisResizer._up.width=bounds.width;
			DisResizer._down.x=bounds.x;
			DisResizer._down.y=bounds.y+bounds.height-2;
			DisResizer._down.width=bounds.width;
			DisResizer._left.x=bounds.x;
			DisResizer._left.y=bounds.y;
			DisResizer._left.height=bounds.height;
			DisResizer._right.x=bounds.x+bounds.width-2;
			DisResizer._right.y=bounds.y;
			DisResizer._right.height=bounds.height;
		}

		DisResizer._up=null
		DisResizer._down=null
		DisResizer._left=null
		DisResizer._right=null
		DisResizer._barList=null
		DisResizer._tar=null
		DisResizer.barWidth=2;
		DisResizer.useGetBounds=false;
		DisResizer.tBar=null
		return DisResizer;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-10-21 下午7:53:19
	*/
	//class laya.ide.managers.SceneManager
	var SceneManager=(function(){
		function SceneManager(){}
		__class(SceneManager,'laya.ide.managers.SceneManager');
		SceneManager.init=function(){
			SceneManager.sceneO["PARTICLE"]=new ParticleScene();
		}

		SceneManager.changeTo=function(scene){
			if(!SceneManager.sceneO[scene])return;
			SceneManager.tScene=SceneManager.sceneO[scene];
			SceneManager.tScene.setUp();
		}

		SceneManager.save=function(){
			if(SceneManager.tScene){
				SceneManager.tScene.save();
			}
		}

		SceneManager.open=function(){
			if(SceneManager.tScene){
				SceneManager.tScene.open();
			}
		}

		SceneManager.PARTICLE="PARTICLE";
		SceneManager.sceneO={};
		SceneManager.tScene=null
		return SceneManager;
	})()


	/**
	*历史状态管理类
	*@author ww
	*/
	//class laya.ide.managers.state.State
	var State=(function(){
		function State(){
			this._stateList=[];
			this._tI=-1;
		}

		__class(State,'laya.ide.managers.state.State');
		var __proto=State.prototype;
		/**
		*添加状态 ，直接使用传入的状态值
		*@param data
		*
		*/
		__proto.add=function(data){
			this.traceState();
			if(this._tI!=this._stateList.length-1){
				this._stateList.length=this._tI+1;
			}
			this._stateList.push(data);
			this._tI=this._stateList.length-1;
			this.traceState();
		}

		__proto.traceState=function(){}
		/**
		*添加状态 ，会拷贝一个副本数据存入
		*@param data
		*
		*/
		__proto.addE=function(data){
			this.add(ObjectTools$1.copyObj(data));
		}

		/**
		*获取当前状态
		*@return
		*
		*/
		__proto.now=function(){
			return ObjectTools$1.copyObj(this._stateList[this._tI]);
		}

		/**
		*向后回退
		*@return
		*
		*/
		__proto.back=function(){
			if(this._tI<=0)return null;
			this._tI--;
			this.traceState();
			return this.now();
		}

		/**
		*向前重做
		*@return
		*
		*/
		__proto.forward=function(){
			if(this._tI>=this._stateList.length-1)return null;
			this._tI++;
			this.traceState();
			return this.now();
		}

		return State;
	})()


	/**
	*状态管理类
	*@author ww
	*@version 1.0
	*
	*@created 2015-10-22 下午7:45:51
	*/
	//class laya.ide.managers.StateManager
	var StateManager=(function(){
		function StateManager(){}
		__class(StateManager,'laya.ide.managers.StateManager');
		StateManager.has=function(sign){
			return StateManager._stateDic.hasOwnProperty(sign);
		}

		StateManager.getState=function(sign){
			if(!StateManager._stateDic[sign])StateManager._stateDic[sign]=new State();
			return StateManager._stateDic[sign];
		}

		StateManager.updateState=function(sign,data){
			StateManager.setChangeState(sign,StateManager.has(sign));
			StateManager.getState(sign).addE(data);
		}

		StateManager.removeState=function(sign){
			delete StateManager._stateDic[sign];
		}

		StateManager.hasChange=function(sign){
			return StateManager._changeDic[sign];
		}

		StateManager.setChangeState=function(sign,changed){
			StateManager._changeDic[sign]=changed;
		}

		StateManager._stateDic={};
		StateManager._changeDic={};
		return StateManager;
	})()


	/**
	*本地文件日志类
	*@author ww
	*@version 1.0
	*
	*@created 2015-12-2 上午9:14:31
	*/
	//class laya.ide.managers.SysLog
	var SysLog=(function(){
		function SysLog(){}
		__class(SysLog,'laya.ide.managers.SysLog');
		/**
		*表示是否捕获全局错误并弹出提示。
		*/
		__getset(1,SysLog,'logGlobalError',null,function(value){
			var erralert=0;
			if (value){
				Browser.window.onerror=function (msg,url,line,column,detail){
					if (erralert++< 5 && detail)
						SysLog.log(Sys.lang("出错啦，请把此信息截图给研发商\n")+msg+"\n"+detail.stack,"GlobalError");
				}
				}else {
				Browser.window.onerror=null;
			}
		});

		SysLog.log=function(msg,type){
			(type===void 0)&& (type="log");
			var str;
			str=(new Date()).toString()+":"+type+":"+msg;
			console.log(str);
			if(SysLog.fileLogEnabled){
				FileTools.appendFile(FileManager.getDataPath("log.txt"),"\n"+str);
			}
		}

		SysLog.fileLogEnabled=true;
		return SysLog;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.ide.managers.SystemDragOverManager
	var SystemDragOverManager=(function(){
		function SystemDragOverManager(){}
		__class(SystemDragOverManager,'laya.ide.managers.SystemDragOverManager');
		SystemDragOverManager.init=function(){
			var canvas=Render.canvas;
			Browser.container.ondrop=SystemDragOverManager.dragDrop;
			Browser.container.ondragover=SystemDragOverManager.dragOver;
		}

		SystemDragOverManager.dragOver=function(e){
			e.preventDefault();
		}

		SystemDragOverManager.dragDrop=function(e){
			console.log("system dragover",e);
			var file;
			try{
				file=e.dataTransfer.files[0];
				SystemDragOverManager.handlerFile(file.path);
				SystemDragOverManager.onFileDrag(e.dataTransfer.files,e.clientX,e.clientY);
				e.preventDefault();
			}catch(e){}
			return false;
		}

		SystemDragOverManager.handlerFile=function(path){
			console.log("handlerFIle:",path);
			if (path){
				var extension;
				extension=FileTools.getExtensionName(path);
				switch(extension){
					case "laya":
						ProjectManager.loadProject(path);
						break ;
					}
			}
		}

		SystemDragOverManager.onFileDrag=function(files,x,y){
			if(!files||files.length<1)return;
			var data;
			var type="SystemDrag";
			var files;
			files=Utils$1.copyArray(files,[]);
			data={type:type,files:files};
			DragManager.sendDragEventByData("dragDrop",data,data,x,y);
		}

		return SystemDragOverManager;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-1-4 上午10:30:59
	*/
	//class laya.ide.managers.TemplateManager
	var TemplateManager=(function(){
		function TemplateManager(){}
		__class(TemplateManager,'laya.ide.managers.TemplateManager');
		TemplateManager.getRootPath=function(){
			return FileManager.getAppPath("laya/template/");
		}

		TemplateManager.getDefaultFolder=function(){
			return TemplateManager.getTypedFolder("常用模板");
		}

		TemplateManager.getTypedFolder=function(type){
			return FileManager.getPath(TemplateManager.getRootPath(),type);
		}

		TemplateManager.getTemplateFolderPath=function(templateName,type){
			(type===void 0)&& (type="自定义模板");
			return FileManager.getPath(TemplateManager.getTypedFolder(type),templateName);
		}

		TemplateManager.getTemplateUIFilePath=function(templateName,type){
			(type===void 0)&& (type="自定义模板");
			return FileManager.getPath(TemplateManager.getTypedFolder(type),templateName+"/"+"UI"+"."+TypeManager.getExtension("ui_template"));
		}

		TemplateManager.getTemplateUIResPath=function(templateName,type){
			(type===void 0)&& (type="自定义模板");
			return FileManager.getPath(TemplateManager.getTypedFolder(type),templateName+"/"+"res");
		}

		TemplateManager.getUIFilePath=function(templateFolder){
			return FileManager.getPath(templateFolder,"UI"+"."+TypeManager.getExtension("ui_template"));
		}

		TemplateManager.getUIResPath=function(templateFolder){
			return FileManager.getPath(templateFolder,"res");
		}

		TemplateManager.init=function(){
			FileTools.ensurePath(TemplateManager.getRootPath());
		}

		TemplateManager.getTemplatePanelData=function(){
			var rst;
			var folders;
			folders=FileTools.getDirChildDirs(TemplateManager.getRootPath());
			var i=0,len=0;
			len=folders.length;
			var groupDatas;
			groupDatas=[];
			for(i=0;i<len;i++){
				groupDatas.push(TemplateManager.getTypedTemplateData(folders[i]));
			}
			rst={};
			rst.groups=groupDatas;
			return rst;
		}

		TemplateManager.getTypedTemplateData=function(path){
			var templates;
			templates=FileTools.getDirChildDirs(path);
			var typeName;
			typeName=FileTools.getFileName(path);
			var i=0,len=0;
			len=templates.length;
			var items;
			items=[];
			for(i=0;i<len;i++){
				items.push(TemplateManager.getTemplateFileData(templates[i],typeName));
			};
			var rst;
			rst={};
			rst.name=typeName;
			rst.items=items;
			return rst;
		}

		TemplateManager.getTemplateFileData=function(path,type){
			var templateName;
			templateName=FileTools.getFileName(path);
			var rst;
			rst={};
			rst.icon=FileTools.getAbsPath(FileManager.getPath(path,"icon.png"));
			rst.image=rst.icon;
			rst.title=templateName;
			rst.path=path;
			return rst;
		}

		TemplateManager.changeToTemplate=function(fileName){
			if(TypeManager.getFileType(fileName)!="page"){
				Alert.show(Sys.lang("UI文件才能转换为模板文件"),Sys.lang("提示"));
				return;
			};
			var folderName;
			folderName=FileTools.getFileName(fileName);
			AddTemplate.instance.start(fileName,folderName);
		}

		TemplateManager.convertUIFileByPaths=function(srcFile,templateName,folderName){
			var tarFolder;
			tarFolder=TemplateManager.getTemplateFolderPath(templateName,folderName);
			if(FileTools.exist(tarFolder)){
				Confirm.show(Sys.lang("目标文件已存在，是否覆盖？"),Sys.lang("提示"),Utils$1.bind(TemplateManager.convertUIFileToTemplate,null),[srcFile,tarFolder,templateName,folderName]);
				}else{
				TemplateManager.convertUIFileToTemplate(srcFile,tarFolder,templateName,folderName);
			}
		}

		TemplateManager.convertUIFileToTemplate=function(oldFile,tarFolder,templateName,folderName){
			var xml=FileManager.readJSONFile(oldFile);
			var view=new UIView();
			view.createView(xml);
			var tarFile;
			tarFile=TemplateManager.getTemplateUIFilePath(templateName,folderName);
			var resFolder;
			resFolder=TemplateManager.getTemplateUIResPath(templateName,folderName);
			var tarData;
			tarData=FileManager.readJSONFile(oldFile);
			var resUsed;
			resUsed=TemplateManager.findAllResUsed(tarData,resUsed);
			var resNameDic;
			resNameDic=TemplateManager.getAdptSkins(resUsed);
			var oldTxt;
			oldTxt=FileManager.readTxtFile(oldFile);
			var key;
			var newPath;
			var uiO;
			uiO=ObjectTools$1.getObj(oldTxt);
			delete resNameDic[""];
			for(key in resNameDic){
				if(!key)continue ;
				TemplateManager.copySkinRes(key,resFolder,resNameDic[key]);
				resNameDic[key]="template"+"/"+templateName+"/"+resNameDic[key];
			}
			ObjectTools$1.replaceValue(uiO,resNameDic);
			FileManager.createTxtFile(tarFile,ObjectTools$1.getJsonString(uiO));
			URL.version[FileTools.getAbsPath(FileManager.getPath(tarFolder,"icon.png"))]=Math.random();
			Laya.timer.once(200,null,TemplateManager.createLittlePic,[view,tarFolder]);
		}

		TemplateManager.copySkinRes=function(skinPath,resFolder,resName){
			if(!skinPath)return;
			if(!resName)return;
			var srcP;
			srcP=FileManager.getResPath(skinPath);
			var tarP;
			tarP=FileTools.getPath(resFolder,resName);
			var i=0,len=0;
			len=TemplateManager.specialFiles.length;
			for(i=0;i<len;i++){
				TemplateManager.copyIfExists(StringTool$1.getReplace(srcP,".png",TemplateManager.specialFiles[i]),StringTool$1.getReplace(tarP,".png",TemplateManager.specialFiles[i]));
			}
		}

		TemplateManager.copyIfExists=function(src,tar){
			if(FileTools.exist(src)){
				if(FileTools.isDirectory(src)){
					debugger;
					return;
				}
				FileTools.copyFile(src,tar);
			}
		}

		TemplateManager.createLittlePic=function(view,tarFolder){
			var pic;
			var bounds;
			bounds=view.getSelfBounds();
			pic=view.drawToCanvas(bounds.width+bounds.x,bounds.height+bounds.y,0 ,0).source;
			var baseStr;
			baseStr=pic.toDataURL("image/png");
			baseStr=baseStr.replace(/^data:image\/\w+;base64,/,"");
			var bf;
			bf=new Device.Buffer(baseStr,'base64');
			FileManager.createBytesFile(FileManager.getPath(tarFolder,"icon.png"),bf);
			MessageManager.instance.show(Sys.lang("转换成模板成功"));
			Laya.timer.once(10,null,TemplateManager.freshCompPanel);
		}

		TemplateManager.freshCompPanel=function(){
			Notice.notify("Fresh_CompPanel");
		}

		TemplateManager.getAdptSkins=function(skinList){
			var renameDic;
			var i=0,len=0;
			len=skinList.length;
			renameDic={};
			for(i=0;i<len;i++){
				if(!skinList[i]||skinList[i]=="")continue ;
				renameDic[skinList[i]]=true;
			};
			var tSkin;
			var usedNameDic;
			usedNameDic={};
			var tName;
			for(tSkin in renameDic){
				tName=FileTools.getFileNameWithExtension(tSkin);
				if(usedNameDic.hasOwnProperty(tName)){
					i=0;
					while(usedNameDic.hasOwnProperty(tName.replace(".",i+"."))){
						i++;
					}
					tName=tName.replace(".",i+".");
					}else{
				}
				usedNameDic[tName]=true;
				renameDic[tSkin]=tName;
			}
			return renameDic;
		}

		TemplateManager.renamePageSkins=function(pageFile,reNameDic){
			var oldTxt;
			oldTxt=pageFile;
			var key;
			var newPath;
			for(key in reNameDic){
				newPath=reNameDic[key];
				oldTxt=StringTool$1.getReplace(oldTxt,"\""+key+"\"","\""+newPath+"\"");
			}
			return oldTxt;
		}

		TemplateManager.findAllResUsedDic=function(pageData){
			var skinList;
			skinList=TemplateManager.findAllResUsed(pageData,[]);
			var renameDic;
			var i=0,len=0;
			len=skinList.length;
			renameDic={};
			for(i=0;i<len;i++){
				renameDic[skinList[i]]=true;
			}
			return renameDic;
		}

		TemplateManager.findAllResUsed=function(pageData,rst){
			if(!rst)rst=[];
			TemplateManager.getNodeSkin(pageData,rst);
			var i=0,len=0;
			var childList;
			var tChild;
			childList=pageData.child;
			len=childList.length;
			for(i=0;i<len;i++){
				tChild=childList[i];
				TemplateManager.findAllResUsed(tChild,rst);
			}
			return rst;
		}

		TemplateManager.getNodeSkin=function(node,rst){
			if(!rst)rst=[];
			var i=0,len=0;
			var tFrame;
			var frames;
			TemplateManager.getResByProps(node.props,rst);
			return rst;
		}

		TemplateManager.getResByProps=function(props,rst){
			if(!rst)rst=[];
			var key;
			for(key in props){
				if(TemplateManager.isResRefer(props[key])){
					rst.push(props[key]);
				}
			}
			return rst;
		}

		TemplateManager.isResRefer=function(value){
			if(!((typeof value=='string')))return false;
			if(FileTools.exist(FileManager.getResPath(value)))return true;
			return false;
		}

		TemplateManager.DefaultFolder="常用模板";
		TemplateManager.CustomFolder="自定义模板";
		TemplateManager.TemplateResFolder="template";
		__static(TemplateManager,
		['specialFiles',function(){return this.specialFiles=[".png","$down.png","$bar.png","$up.png"];}
		]);
		return TemplateManager;
	})()


	/**
	*本类定义不同的页面类型
	*@author ww
	*/
	//class laya.ide.managers.TypeManager
	var TypeManager=(function(){
		function TypeManager(){}
		__class(TypeManager,'laya.ide.managers.TypeManager');
		TypeManager.init=function(){
			TypeManager.ViewCodeTypeDic["page"]=true;
			TypeManager.ViewCodeTypeDic["scene"]=true;
			TypeManager.ViewCodeTypeDic["prefab_ui"]=true;
			TypeManager.ViewCodeTypeDic["Prefab"]=true;
			TypeManager.ViewCodeTypeDic["animation"]=true;
			TypeManager.ViewCodeTypeDic["graphic_animation"]=true;
			TypeManager.ViewCodeTypeDic["MoveEffect"]=true;
			TypeManager.XmlCodeTypeDic["Script"]=true;
			TypeManager.XmlCodeTypeDic["prop"]=true;
			TypeManager.insertArrToObj(TypeManager.Res2D,TypeManager.ResTypes);
			TypeManager.insertArrToObj(TypeManager.GraphicRes,TypeManager.ResTypes);
			TypeManager.insertArrToObj(TypeManager.UIRes,TypeManager.ResTypes);
			TypeManager.insertArrToObj(TypeManager.GraphicRes,TypeManager.UnEnterAbleType);
			TypeManager.UnEnterAbleType["Graphic"]=false;
			TypeManager.insertArrToObj(TypeManager.GraphicRes,TypeManager.GraphicCmdTypeDic);
			TypeManager.GraphicCmdTypeDic["Graphic"]=false;
			TypeManager.NoRenderTypeNodes["EffectAnimation"]=true;
		}

		TypeManager.getExtension=function(type){
			var key;
			var tO=TypeManager.TypeO;
			for(key in tO){
				if(tO[key]==type){
					return key;
				}
			}
			console.log("未知type:",type);
			return "unKnow";
		}

		TypeManager.getFileType=function(path){
			var extention=FileTools.getExtensionName(path);
			if(!TypeManager.TypeO[extention])return "unKnow";
			return TypeManager.TypeO[extention];
		}

		TypeManager.isPreFabNodeType=function(type){
			if(!type)return false;
			return !ProjectSetting.isPageType(type);
		}

		TypeManager.isPreFabPage=function(path){
			return TypeManager.isPreFabNodeType(TypeManager.getPageFileType(path));
		}

		TypeManager.getPageFileType=function(path){
			var xml;
			var dataStr;
			try{
				dataStr=FileManager.getPath(SystemSetting.pagesPath,path.replace(".xml","."+laya.ide.managers.TypeManager.getExtension("page")));
				xml=FileManager.readJSONFile(dataStr);
				var type;
				type=xml.type;
				return type;
				}catch(e){
			};
			return null;
		}

		TypeManager.isPrefabUINode=function(node){
			if(node.type!="UIView"||!node.source)return false;
			return TypeManager.isPreFabPage(node.source);
		}

		TypeManager.isCodeViewFile=function(path){
			var type;
			type=TypeManager.getFileType(path);
			return TypeManager.ViewCodeTypeDic.hasOwnProperty(type);
		}

		TypeManager.isXmlViewFile=function(path){
			var type;
			type=TypeManager.getFileType(path);
			return TypeManager.XmlCodeTypeDic.hasOwnProperty(type);
		}

		TypeManager.isScriptFile=function(path){
			return TypeManager.isXmlViewFile(path);
		}

		TypeManager.insertArrToObj=function(arr,obj){
			var i=0,len=0;
			len=arr.length;
			for(i=0;i<len;i++){
				obj[arr[i]]=true;
			}
		}

		TypeManager.isResTypeName=function(typeStr){
			return TypeManager.ResTypes[typeStr];
		}

		TypeManager.isGraphicCmdType=function(type){
			if(type==TypeManager.GraphicPic&&IDEVars.isNewGraphicAnimationMode)return false;
			if(TypeManager.GraphicCmdTypeDic[type])return true;
			return false;
		}

		TypeManager.canNodeAddToType=function(childType,parentType){
			if(parentType=="Graphic"){
				if(!TypeManager.isGraphicCmdType(childType)){
					return false;
				}
			}
			return true;
		}

		TypeManager.isGraphicAniNodeType=function(type){
			return type=="Texture"||type==TypeManager.GraphicPic;
		}

		TypeManager.Particle="particle";
		TypeManager.Particle3D="particle3D";
		TypeManager.ParticlePoly="particlepoly";
		TypeManager.Page="page";
		TypeManager.Animation="animation";
		TypeManager.UITemplate="ui_template";
		TypeManager.Scene="scene";
		TypeManager.Prefab="Prefab";
		TypeManager.PrefabUI="prefab_ui";
		TypeManager.GraphicAnimation="graphic_animation";
		TypeManager.Script="Script";
		TypeManager.Prop="prop";
		TypeManager.MoveEffect="MoveEffect";
		TypeManager.ViewCodeTypeDic={};
		TypeManager.XmlCodeTypeDic={};
		TypeManager.GraphicCmdTypeDic={};
		TypeManager.ParticlePlayer="Particle2D";
		TypeManager.GraphicPic="Texture";
		TypeManager.MoveEffectNode="EffectAnimation";
		TypeManager.FrameAnimationNode="FrameAnimation";
		__static(TypeManager,
		['NoRenderTypeNodes',function(){return this.NoRenderTypeNodes={
				"SoundNode":true,
				"GraphicPic":true,
				"GridEditor":true,
				"Script":true
				};},'TypeO',function(){return this.TypeO={
				"part":"particle",
				"part3d":"particle3D",
				"partPoly":"particlepoly",
				"ui":"page",
				"ani":"graphic_animation",
				"scene":"scene",
				"prefab":"Prefab",
				"prefabui":"prefab_ui",
				"script":"Script",
				"prop":"prop",
				"temp":"ui_template",
				"efc":"MoveEffect"
				};},'Res2D',function(){return this.Res2D=["Sprite","Animation","Text","HTMLDivElement"];},'GraphicRes',function(){return this.GraphicRes=["Circle","Curves","FillText","FillTexture","Graphic","Line","Lines","Pie","Poly","Rect","Texture"];},'UIRes',function(){return this.UIRes=["Button","CheckBox","Clip","ColorPicker","ComboBox","Dialog","FontClip","HBox","HScrollBar","HSlider","Image","Label","List","Panel","ProgressBar","Radio","RadioGroup","Tab","Text","TextArea","TextInput","Tree","VBox","VScrollBar","VSlider","View","ViewStack","Box"];},'ResTypes',function(){return this.ResTypes={
				};},'UnEnterAbleType',function(){return this.UnEnterAbleType={
				"GraphicPic":true,
				"HTMLDivElement":true,
				"SoundNode":true,
				"GridEditor":true,
				"UIView":true,
				"Script":true
		};}

		]);
		return TypeManager;
	})()


	/**
	*本类用于在ide中显示iframe
	*@author ww
	*@version 1.0
	*
	*@created 2015-10-21 上午11:23:12
	*/
	//class laya.ide.managers.ViewRenderManager
	var ViewRenderManager=(function(){
		function ViewRenderManager(){}
		__class(ViewRenderManager,'laya.ide.managers.ViewRenderManager');
		ViewRenderManager.init=function(){
			if (ViewRenderManager.renderFrame)return;
			ViewRenderManager.renderHit.name="renderHit";
			ViewRenderManager.renderHit.mouseEnabled=true;
			ViewRenderManager.renderHit.on("dragDrop",null,ViewRenderManager.renderDragDrop);
			ViewRenderManager.renderFrame=Browser.createElement("iframe");
			ViewRenderManager.renderFrame.id="viewrender";
			ViewRenderManager.renderFrame.width="400";
			ViewRenderManager.renderFrame.height="300";
			ViewRenderManager.renderFrame.left="400";
			ViewRenderManager.renderFrame.top="400";
			ViewRenderManager.style=ViewRenderManager.renderFrame.style;
			ViewRenderManager.style.position="absolute";
			ViewRenderManager.style.top="100px";
			ViewRenderManager.style.left="220px";
			ViewRenderManager.style["z-index"]=101;
			ViewRenderManager.style.border="0";
			ViewRenderManager.render=ViewRenderManager.renderFrame.contentWindow;
			var passEventList=["mousemove","mouseup","keydown","keypress","keyup"];
			ViewRenderManager.renderFrame.addEventListener("load",function(){
				ViewRenderManager.render=ViewRenderManager.renderFrame.contentWindow.renderBinds;
				ViewRenderManager.window=ViewRenderManager.renderFrame.contentWindow;
				var i=0,len=0;
				len=passEventList.length;
				for(i=0;i<len;i++){
					ViewRenderManager.window.document.removeEventListener(passEventList[i],ViewRenderManager.passEvent);
					ViewRenderManager.window.document.addEventListener(passEventList[i],ViewRenderManager.passEvent);
				}
				Laya.timer.once(200,null,ViewRenderManager.loaded);
			},false)
			var idePassEventList=["keydown","keypress","keyup"];
			var i=0,len=0;
			len=idePassEventList.length;
			for(i=0;i<len;i++){
				Laya.stage.on(idePassEventList[i],null,ViewRenderManager.passEvent2);
			}
		}

		ViewRenderManager.passEvent=function(e){
			var evt;
			evt=Browser.document.createEvent("Events");
			evt.initEvent(e.type,true,true);
			var key;
			for(key in e){
				if(!((typeof (e[key])=='function'))){
					evt[key]=e[key];
				}
			}
			evt.isFromIDE=true;
			evt.clientX+=ViewRenderManager.offPos.x;
			evt.clientY+=ViewRenderManager.offPos.y;
			evt.pageX=0;
			evt.pageY=0;
			if(!ViewRenderManager.isFromMe)
				Render.canvas.dispatchEvent(evt);
		}

		ViewRenderManager.passEvent2=function(e){
			if(!ViewRenderManager.window)return;
			e=e.nativeEvent;
			if(e.isFromIDE)return;
			var evt;
			evt=Browser.document.createEvent("Events");
			evt.initEvent(e.type,true,true);
			var key;
			for(key in e){
				if(!((typeof (e[key])=='function'))){
					evt[key]=e[key];
				}
			}
			ViewRenderManager.isFromMe=true;
			ViewRenderManager.window.document.dispatchEvent(evt);
			ViewRenderManager.isFromMe=false;
		}

		ViewRenderManager.renderDragDrop=function(e){
			var point=DisControlTool.getMousePoint(ViewRenderManager.renderHit);
			e.data.dropX=point.x;
			e.data.dropY=point.y;
			Notice.notify("DROP_RENDER",[e]);
		}

		ViewRenderManager.renderMouseHandler=function(e){
			if(!ViewRenderManager.window)return;
			var point;
			point=DisControlTool.getMousePoint(ViewRenderManager.renderHit);
			var evt;
			evt=Browser.document.createEvent("MouseEvents");
			evt.initMouseEvent(
			e.type,
			true,
			true,
			Browser.document.defaultView,
			0,
			point.x,
			point.y,
			point.x,
			point.y);
			ViewRenderManager.window.dispatchEvent(evt);
		}

		ViewRenderManager.loaded=function(){
			Notice.listen("RenderInited",null,ViewRenderManager.renderInited);
			if(ViewRenderManager.render)
				ViewRenderManager.render.setNotice(Notice.I);
			ViewRenderManager.eDispatcher.event("complete");
			ViewRenderManager.adpt();
		}

		ViewRenderManager.renderInited=function(){}
		ViewRenderManager.adpt=function(){
			if (laya.ide.managers.ViewRenderManager.renderFrame){
				var pos=new Point();
				pos=UIPanel.instance.localToGlobal(pos);
				var dLen=0;
				dLen=25;
				ViewRenderManager.renderHit.width=UIPanel.instance.width;
				ViewRenderManager.renderHit.height=UIPanel.instance.height-dLen;
				ViewRenderManager.renderHit.x=UIPanel.instance.x;
				ViewRenderManager.renderHit.y=UIPanel.instance.y+dLen;
				var style;
				style=laya.ide.managers.ViewRenderManager.renderFrame.style;
				ViewRenderManager.offPos.setTo(pos.x,pos.y+dLen);
				style.top=pos.y+dLen+"px";
				style.left=(pos.x)+"px";
				laya.ide.managers.ViewRenderManager.renderFrame.width=ViewRenderManager.renderHit.width;
				laya.ide.managers.ViewRenderManager.renderFrame.height=ViewRenderManager.renderHit.height-5;
				ViewRenderManager.hitBounds.width=ViewRenderManager.renderHit.width;
				ViewRenderManager.hitBounds.height=ViewRenderManager.renderHit.height;
				ViewRenderManager.hitBounds.x=0;
				ViewRenderManager.hitBounds.y=0;
				ViewRenderManager.renderHit.setBounds(ViewRenderManager.hitBounds);
			}
		}

		ViewRenderManager.setRender=function(url){
			ViewRenderManager.renderFrame.src=url;
		}

		ViewRenderManager.show=function(){
			Browser.container.appendChild(ViewRenderManager.renderFrame);
			UIPanel.instance.parent.addChild(ViewRenderManager.renderHit);
		}

		ViewRenderManager.hide=function(){
			Browser.removeElement(ViewRenderManager.renderFrame);
			ViewRenderManager.renderFrame.src="";
			ViewRenderManager.renderHit.removeSelf();
		}

		ViewRenderManager.renderFrame=null
		ViewRenderManager.render=null
		ViewRenderManager.style=null
		ViewRenderManager.window=null
		ViewRenderManager.isFromMe=false;
		__static(ViewRenderManager,
		['eDispatcher',function(){return this.eDispatcher=new EventDispatcher();},'renderHit',function(){return this.renderHit=new Sprite();},'hitBounds',function(){return this.hitBounds=new Rectangle(0,0);},'offPos',function(){return this.offPos=new Point();}
		]);
		return ViewRenderManager;
	})()


	/**
	*显示对象常用的工具类
	*@author ww
	*/
	//class laya.ide.utils.DisTools
	var DisTools=(function(){
		function DisTools(){}
		__class(DisTools,'laya.ide.utils.DisTools');
		DisTools.showToStage=function(dis,offX,offY){
			(offX===void 0)&& (offX=0);
			(offY===void 0)&& (offY=0);
			var rec=dis.getBounds();
			dis.x=Laya.stage.mouseX+offX;
			dis.y=Laya.stage.mouseY+offY;
			if (dis.x+rec.width > Laya.stage.width){
				dis.x-=rec.width+offX;
			}
			if (dis.y+rec.height > Laya.stage.height){
				dis.y-=rec.height+offY;
			}
		}

		DisTools.showToCenter=function(dis,parent){
			dis.x=0.5 *(parent.width-dis.width);
			dis.y=0.5 *(parent.height-dis.height);
			parent.addChild(dis);
		}

		DisTools.getDisDesO=function(dis){
			if (!dis)
				return null;
			var rst={};
			if(dis.name){
				rst.label=TraceTool.getClassName(dis)+"("+dis.name+")";
				}else{
				rst.label=TraceTool.getClassName(dis);
			}
			if(dis["comXml"]){
				rst.compId=dis["comXml"]["compId"];
			}
			rst.path=dis;
			rst.files=[];
			rst.dirs=[];
			rst.childs=[];
			rst.isDirectory=true;
			return rst;
		}

		DisTools.getDisTreeArr=function(sp,filterFun){
			var tTreeO=DisTools.getDisTreeO(sp,filterFun);
			var rst=[];
			DisTools.getTreeArr(tTreeO,rst);
			return rst;
		}

		DisTools.getTreeArr=function(treeO,arr,filterFun){
			arr.push(treeO);
			var tArr=treeO.childs||treeO.child;
			var i=0,len=tArr.length;
			for (i=0;i < len;i++){
				if (tArr[i].isDirectory){
					DisTools.getTreeArr(tArr[i],arr);
				}
				else{
					arr.push(tArr[i]);
				}
			}
		}

		DisTools.getDisTreeO=function(dis,filterFun){
			var rst=DisTools.getDisDesO(dis);
			var i=0,len=0;
			var tChild;
			var tO;
			len=dis.numChildren;
			for (i=0;i < len;i++){
				tChild=dis.getChildAt(i);
				if(filterFun!=null&&!filterFun(tChild)){
					continue ;
				}
				tO=DisTools.getDisTreeO(tChild,filterFun);
				tO.nodeParent=rst;
				tO.hasChild=tO.childs.length > 0;
				tO.isDirectory=tO.hasChild;
				rst.dirs.push(tO);
				rst.childs.push(tO);
			}
			rst.hasChild=rst.childs.length > 0;
			return rst;
		}

		DisTools.addTextChangeHandler=function(input,_this,fun,param){
			input.on("enter",_this,fun);
			input.on("blur",_this,fun);
		}

		return DisTools;
	})()


	/**
	*编辑页基类
	*@author ww
	*/
	//class laya.ide.viewer.SceneBase
	var SceneBase=(function(){
		function SceneBase(){
			this.data=null;
			this._path=null;
			this._title=null;
			this._changed=false;
		}

		__class(SceneBase,'laya.ide.viewer.SceneBase');
		var __proto=SceneBase.prototype;
		Laya.imps(__proto,{"laya.ide.viewer.IViewer":true})
		__proto.setUp=function(parent){}
		//trace("SceneBase setUp");
		__proto.save=function(){}
		__proto.open=function(){}
		__proto.removeSelf=function(){
			ViewRenderManager.hide();
			Notice.cancel("ResItemClick",this,this.onResClick);
			Notice.cancel("Prop_change",this,this.propChange);
			Notice.cancel("DROP_RENDER",this,this.renderDragDrop);
		}

		__proto.dealAction=function(funName,param){
			if ((typeof (this[funName])=='function')){
				this[funName].apply(this,param);
			}
		}

		__proto.show=function(){
			ViewRenderManager.show();
			Notice.listen("ResItemClick",this,this.onResClick,null,true);
			Notice.listen("Prop_change",this,this.propChange,null,true);
			Notice.listen("DROP_RENDER",this,this.renderDragDrop,null,true);
		}

		__proto.renderDragDrop=function(e){}
		__proto.propChange=function(key,data){}
		__proto.onResClick=function(data){}
		__proto.getDesignData=function(){
			return {};
		}

		__proto.changeDataO=function(dataO){}
		__proto.goBack=function(){}
		__proto.goForward=function(){}
		__getset(0,__proto,'pagePath',function(){
			return this._path;
			},function(path){
			this._path=path;
			this._title=FileTools.getFileName(this._path);
		});

		__getset(0,__proto,'title',function(){
			return this._title;
		});

		__getset(0,__proto,'design',function(){
			return this;
		});

		__getset(0,__proto,'hasChange',function(){
			return this._changed;
		});

		return SceneBase;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-8-10 下午4:21:23
	*/
	//class laya.rendercanvas.HtmlZIndexManager
	var HtmlZIndexManager=(function(){
		function HtmlZIndexManager(){}
		__class(HtmlZIndexManager,'laya.rendercanvas.HtmlZIndexManager');
		HtmlZIndexManager.init=function(){
			Laya.stage.on("mousedown",null,HtmlZIndexManager.onMouseDown);
			Laya.stage.on("mouseup",null,HtmlZIndexManager.onMouseUp);
		}

		HtmlZIndexManager.onMouseDown=function(){
			HtmlZIndexManager.isMouseDown=true;
			HtmlZIndexManager.prePos.setTo(Laya.stage.mouseX,Laya.stage.mouseY);
			HtmlZIndexManager.isDrag=false;
			Laya.stage.on("mousemove",null,HtmlZIndexManager.onMouseMove);
		}

		HtmlZIndexManager.onMouseMove=function(){
			if(Math.abs(HtmlZIndexManager.prePos.x-Laya.stage.mouseX)+Math.abs(HtmlZIndexManager.prePos.y-Laya.stage.mouseY)>5){
				Notice.notify("DisableOverlays");
				HtmlZIndexManager.setHtmlEnable(false);
				HtmlZIndexManager.isDrag=true;
				Laya.stage.off("mousemove",null,HtmlZIndexManager.onMouseMove);
			}
		}

		HtmlZIndexManager.onMouseUp=function(){
			HtmlZIndexManager.isMouseDown=false;
			Laya.stage.off("mousemove",null,HtmlZIndexManager.onMouseMove);
			if(!HtmlZIndexManager.preValue){
				Notice.notify("EnableOverlays");
				HtmlZIndexManager.setHtmlEnable(true);
			}
			HtmlZIndexManager.isDrag=false;
		}

		HtmlZIndexManager.setHtmlEnable=function(enable){
			HtmlZIndexManager.preValue=enable;
			var i=0,len=0;
			len=HtmlZIndexManager.htmlList.length;
			for(i=0;i<len;i++){
				if(HtmlZIndexManager.htmlList[i].disableAutoControl)continue ;
				JSTools.setMouseEnable(HtmlZIndexManager.htmlList[i],enable);
			}
		}

		HtmlZIndexManager.addHtml=function(html){
			if(!html)return;
			if(!HtmlZIndexManager.htmlList.indexOf(html)>=0){
				HtmlZIndexManager.htmlList.push(html);
			}
		}

		HtmlZIndexManager.removeHtml=function(html){
			if(!html)return;
			var index=0;
			index=HtmlZIndexManager.htmlList.indexOf(html);
			if(index>=0){
				HtmlZIndexManager.htmlList.splice(index,1);
			}
		}

		HtmlZIndexManager.DisableOverlays="DisableOverlays";
		HtmlZIndexManager.EnableOverlays="EnableOverlays";
		HtmlZIndexManager.isDrag=false;
		HtmlZIndexManager.isMouseDown=false;
		HtmlZIndexManager.preValue=true;
		HtmlZIndexManager.htmlList=[];
		__static(HtmlZIndexManager,
		['prePos',function(){return this.prePos=new Point();}
		]);
		return HtmlZIndexManager;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-8-12 下午6:56:18
	*/
	//class laya.rendercanvas.StageHook
	var StageHook=(function(){
		function StageHook(){
			this.preEvent=null;
			this.preRender=null;
			this.renderingEnabled=true;
			this._repaint=1;
		}

		__class(StageHook,'laya.rendercanvas.StageHook');
		var __proto=StageHook.prototype;
		__proto.event=function(type,data){
			if(type=="mouseout")return false;
			return laya.rendercanvas.StageHook.I.preEvent.apply(this,[type,data]);
		}

		__proto.render=function(context,x,y){
			this.renderingEnabled=this._repaint!=0;
			if(this.renderingEnabled){
				if(IDEConsts.showRenderDebug){
					console.log("renderStage");
				}
			}
			laya.rendercanvas.StageHook.I.preRender.apply(this,[context,x,y]);
		}

		StageHook.hookStage=function(){
			StageHook.I.preEvent=Laya.stage.event;
			Laya.stage["event"]=StageHook.I.event;
			StageHook.I.preRender=Laya.stage.render;
			Laya.stage["render"]=StageHook.I.render;
		}

		__static(StageHook,
		['I',function(){return this.I=new StageHook();}
		]);
		return StageHook;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.test.TempData
	var TempData=(function(){
		function TempData(){}
		__class(TempData,'laya.test.TempData');
		TempData.temTreeData=null
		return TempData;
	})()


	/**
	*编辑器全局静态入口
	*@author yung
	*/
	//class Sys
	var Sys=(function(){
		function Sys(){};
		__class(Sys,'Sys');
		Sys.mParseInt=function(v){
			return parseInt(v);
		}

		Sys.log=function(__args){
			var args=arguments;
			Sys.print("log",args,"#0080C0");
		}

		Sys.error=function(__args){
			var args=arguments;
			Sys.print("error",args,"#FF0000");
		}

		Sys.warn=function(__args){
			var args=arguments;
			Sys.print("warn",args,"#9B9B00");
		}

		Sys.plugin=function(__args){
			var args=arguments;
			Sys.print("plugin",args,"#007300");
		}

		Sys.print=function(type,args,color){
			var msg="";
			for (var i=0;i < args.length;i++){
				msg+=args[i]+" ";
			}
			console.log("%c ["+type+"]"+msg,"color: "+color+"");
		}

		Sys.alert=function(msg){
			if (SystemSetting.isCMDVer){
				console.log(msg);
				return;
			}
			alert(msg);
			SysLog.log(msg,"alert");
		}

		Sys.lang=function(body,__args){
			var args=[];for(var i=1,sz=arguments.length;i<sz;i++)args.push(arguments[i]);
			var i=0,len=0;
			len=args.length;
			if(Sys.langPack&&Sys.langPack[body]){
				body=Sys.langPack[body];
			}
			for (i=0;i < len;i++){
				body=body.replace("{"+i+"}",args[i]);
			}
			return body;
		}

		Sys.adptLangPack=function(){
			if(!Sys.langPack)return;
			var key;
			var newKey;
			for(key in Sys.langPack){
				if(key.indexOf("\\n")>=0){
					newKey=StringTool$1.getReplace(key,"\\\\n","\n");
					Sys.langPack[newKey]=StringTool$1.getReplace(Sys.langPack[key],"\\\\n","\n");
				}
			}
		}

		Sys.langArr=function(txtList){
			if(!Sys.langPack)return txtList;
			var i=0,len=0;
			len=txtList.length;
			var tTxt;
			for(i=0;i<len;i++){
				tTxt=txtList[i];
				if(Sys.langPack[tTxt]){
					txtList[i]=Sys.langPack[tTxt];
				}
			}
			return txtList;
		}

		Sys.langPack=null
		return Sys;
	})()


	/**
	*...
	*@author ww
	*/
	//class tools.PreLoads
	var PreLoads=(function(){
		function PreLoads(){
			this.handler=null;
			this.skinResList=["view.json","comp.json","play.json"];
			this.mXML=null;
			this.mData=null;
		}

		__class(PreLoads,'tools.PreLoads');
		var __proto=PreLoads.prototype;
		__proto.loadRes=function(){
			var i=0,len=0;
			var loadList;
			loadList=[];
			var skinPath;
			skinPath=IDESkinManager.getSkinPath();
			len=this.skinResList.length;
			for(i=0;i<len;i++){
				loadList.push({url:skinPath+this.skinResList[i],type:"atlas"});
			}
			if(IDELangManager.getLangPath()){
				loadList.push({url:IDELangManager.getLangPath(),type:"json"});
			}
			Laya.loader.load(loadList,Handler.create(this,this.loadXMLFile),Handler.create(this,this.progressFun));
		}

		__proto.progressFun=function(){}
		__proto.loadXMLFile=function(){
			if(IDELangManager.getLangPath()){
				var langData;
				langData=Loader.getRes(IDELangManager.getLangPath());
				console.log("lang:",langData);
				Sys.langPack=langData;
				Sys.adptLangPack();
			}
			PageExportType.init();
			this.xmlLoaded(null);
		}

		__proto.xmlLoaded=function(data){
			RenderManager.I.initRenders();
			this.handler.run();
		}

		PreLoads.LangPack="lang.json";
		PreLoads.TestMode=false;
		return PreLoads;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-10-19 上午10:45:14
	*/
	//class wraps.binarypic.BinaryPicTools
	var BinaryPicTools=(function(){
		function BinaryPicTools(){}
		__class(BinaryPicTools,'wraps.binarypic.BinaryPicTools');
		BinaryPicTools.init=function(){
			PNGTools.init();
			JPGTools.init();
		}

		BinaryPicTools.clearCache=function(){}
		BinaryPicTools.getResInfo=function(path){
			if(!FileTools.exist(path))return null;
			var extension;
			extension=FileTools.getExtensionName(path);
			extension=extension.toLowerCase();
			if(extension!="png"&&extension!="jpg")return null;
			var changeTime;
			changeTime=FileTools.getMTime(path).toString();
			var cacheO;
			cacheO=BinaryPicTools.infoCacheDic[path];
			if(cacheO){
				if(cacheO["mTime"]==changeTime&&cacheO["tex"]){
					return cacheO["tex"];
				}
				}else{
				cacheO={};
			}
			cacheO["mTime"]=changeTime;
			BinaryPicTools.infoCacheDic[path]=cacheO;
			var data;
			data=FileTools.readFile(path,null);
			var rst;
			rst=ImageInfo.imageInfo(data);
			cacheO["tex"]=rst;
			return rst;
		}

		BinaryPicTools.getRes=function(path){
			if(!ResFileManager.enableBinaryPic)return null;
			if(!FileTools.exist(path))return null;
			var extension;
			extension=FileTools.getExtensionName(path);
			extension=extension.toLowerCase();
			if(extension!="png"&&extension!="jpg")return null;
			var changeTime;
			changeTime=FileTools.getMTime(path).toString();
			var cacheO;
			cacheO=BinaryPicTools.cacheDic[path];
			if(cacheO){
				if(cacheO["mTime"]==changeTime&&cacheO["tex"]){
					return cacheO["tex"];
				}
				}else{
				cacheO={};
				BinaryPicTools.cacheDic[path]=cacheO;
			}
			cacheO["mTime"]=changeTime;
			var data;
			data=FileTools.readFile(path,null);
			rst=BinaryPicTools.createTextureByBinary(data,path);
			cacheO["tex"]=rst;
			BinaryPicTools.cacheDic[path]=cacheO;
			return rst;
			console.log("path:",path);
			console.log("img:",ImageInfo.imageInfo(data));
			var rst;
			if(extension=="png"){
				rst=PNGTools.createTextureByBinary(data);
			}
			if(extension=="jpg"){
				rst=JPGTools.createTextureByBinary(data);
			}
			cacheO["tex"]=rst;
			return rst;
		}

		BinaryPicTools.createTextureByBinary=function(data,path){
			var bmp=new BinaryBitmap();
			bmp.setBinaryData(data,path);
			return new Texture(bmp);
		}

		BinaryPicTools.cacheDic={};
		BinaryPicTools.infoCacheDic={};
		return BinaryPicTools;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-10-19 上午11:46:38
	*/
	//class wraps.binarypic.ImageInfo
	var ImageInfo=(function(){
		function ImageInfo(){}
		__class(ImageInfo,'wraps.binarypic.ImageInfo');
		ImageInfo.readUInt32=function(buffer,offset,bigEndian){
			if (buffer.readUInt32){
				return buffer.readUInt32(offset,bigEndian);
			};
			var value=0;
			if (bigEndian){
				if (buffer.readUInt32BE){
					return buffer.readUInt32BE(offset);
				}
				value=(buffer[offset] << 24)+(buffer[offset+1] << 16)+(buffer[offset+2] << 8)+buffer[offset+3];
			}
			else {
				if (buffer.readUInt32LE){
					return buffer.readUInt32LE(offset);
				}
				value=buffer[offset]+(buffer[offset+1] << 8)+(buffer[offset+2] << 16)+(buffer[offset+3] << 24);
			}
			return value;
		}

		ImageInfo.readUInt16=function(buffer,offset,bigEndian){
			if (buffer.readUInt16){
				return buffer.readUInt16(offset,bigEndian);
			};
			var value=0;
			if (bigEndian){
				if (buffer.readUInt16BE){
					return buffer.readUInt16BE(offset);
				}
				value=(buffer[offset] << 8)+buffer[offset+1];
			}
			else {
				if (buffer.readUInt16LE){
					return buffer.readUInt16LE(offset);
				}
				value=buffer[offset]+(buffer[offset+1] << 8);
			}
			return value;
		}

		ImageInfo.readBit=function(buffer,offset,bitOffset){
			if (bitOffset > 7){
				offset+=Math.floor(bitOffset / 8);
				bitOffset=bitOffset % 8;
			};
			var b=buffer[offset];
			if (bitOffset < 7){
				b >>>=(7-bitOffset);
			};
			var val=b & 0x01;
			return val;
		}

		ImageInfo.readBits=function(buffer,offset,bitOffset,bitLen,signed){
			var val=0;
			var neg=false;
			if (signed){
				if (ImageInfo.readBit(buffer,offset,bitOffset)> 0){
					neg=true;
				}
				bitLen--;
				bitOffset++;
			};
			var bytes=[];
			for (var i=0;i < bitLen;i++){
				var b=ImageInfo.readBit(buffer,offset,bitOffset+i);
				if (i>0 && (bitLen-i)% 8==0){
					bytes.push(val);
					val=0;
				}
				val <<=1;
				val |=b;
			}
			bytes.push(val);
			val=new Buffer(bytes);;
			val.negative=neg?true:false;
			return val;
		}

		ImageInfo.imageInfoPng=function(buffer){
			var imageHeader=[0x49,0x48,0x44,0x52],
			pos=12;
			if (!ImageInfo.checkSig(buffer,pos,imageHeader)){
				return false;
			}
			pos+=4;
			return {
				type:'image',
				format:'PNG',
				mimeType:'image/png',
				width:ImageInfo.readUInt32(buffer,pos,true),
				height:ImageInfo.readUInt32(buffer,pos+4,true)
			};
		}

		ImageInfo.imageInfoJpg=function(buffer){
			var pos=2,
			len=buffer.length,
			sizeSig=[0xff,[0xc0,0xc2]];
			while (pos < len){
				if (ImageInfo.checkSig(buffer,pos,sizeSig)){
					pos+=5;
					return {
						type:'image',
						format:'JPG',
						mimeType:'image/jpeg',
						width:ImageInfo.readUInt16(buffer,pos+2,true),
						height:ImageInfo.readUInt16(buffer,pos,true)
					};
				}
				pos+=2;
				var size=ImageInfo.readUInt16(buffer,pos,true);
				pos+=size;
			}
		}

		ImageInfo.imageInfoGif=function(buffer){
			var pos=6;
			return {
				type:'image',
				format:'GIF',
				mimeType:'image/gif',
				width:ImageInfo.readUInt16(buffer,pos,false),
				height:ImageInfo.readUInt16(buffer,pos+2,false)
			};
		}

		ImageInfo.checkSig=function(buffer,offset,sig){
			var len=sig.length;
			for (var i=0;i < len;i++){
				var b=buffer[i+offset],
				s=sig[i],
				m=false;
				if ('number'==typeof s){
					m=s===b;
				}
				else {
					for (var k in s){
						var o=s[k];
						if (o===b){
							m=true;
						}
					}
				}
				if (!m){
					return false;
				}
			}
			return true;
		}

		ImageInfo.imageInfo=function(buffer){
			var pngSig=[0x89,0x50,0x4e,0x47,0x0d,0x0a,0x1a,0x0a];
			var jpgSig=[0xff,0xd8,0xff];
			var gifSig=[0x47,0x49,0x46,0x38,[0x37,0x39],0x61];
			var swfSig=[[0x46,0x43],0x57,0x53];
			if (ImageInfo.checkSig(buffer,0,pngSig))return ImageInfo.imageInfoPng(buffer);
			if (ImageInfo.checkSig(buffer,0,jpgSig))return ImageInfo.imageInfoJpg(buffer);
			if (ImageInfo.checkSig(buffer,0,gifSig))return ImageInfo.imageInfoGif(buffer);
			return false;
		}

		return ImageInfo;
	})()


	/**
	*...
	*@author ww
	*/
	//class wraps.binarypic.JPGTools
	var JPGTools=(function(){
		function JPGTools(){}
		__class(JPGTools,'wraps.binarypic.JPGTools');
		var __proto=JPGTools.prototype;
		__proto.PNGTools=function(){}
		JPGTools.init=function(){
			var zclss;
			zclss=JpegImage;
			JPGTools.JPG=zclss;
		}

		JPGTools.createCanvasByBinary=function(data){
			var canvas=new HTMLCanvas("2D");
			var ctx=canvas.getContext('2d');
			canvas.size(100,100);
			var jpg;
			jpg=new JPGTools.JPG();
			jpg.parse(data);
			return JPGTools.renderJpgToCanvas(jpg,canvas);
		}

		JPGTools.renderJpgToCanvas=function(jpg,canvas){
			var ctx;
			ctx=canvas.source.getContext("2d");
			canvas.size(jpg.width,jpg.height);
			var data;
			data=ctx.createImageData(jpg.width,jpg.height);
			jpg.copyToImageData(data);
			ctx.putImageData(data,0,0);
			return canvas;
		}

		JPGTools.createTextureByBinary=function(data){
			var canvas;
			canvas=wraps.binarypic.JPGTools.createCanvasByBinary(data);
			return new Texture(canvas);
		}

		JPGTools.JPG=null
		return JPGTools;
	})()


	/**
	*...
	*@author ww
	*/
	//class wraps.binarypic.PNGTools
	var PNGTools=(function(){
		function PNGTools(){}
		__class(PNGTools,'wraps.binarypic.PNGTools');
		PNGTools.init=function(){
			var zclss;
			zclss=PNG;
			PNGTools.PNG=zclss;
		}

		PNGTools.loadPngToCanvas=function(url){
			var canvas=new HTMLCanvas("2D");
			var ctx=canvas.getContext('2d');
			canvas.size(100,100);
			PNGTools.PNG.load(url,canvas.source);
			return canvas;
		}

		PNGTools.createCanvasByBinary=function(data){
			var canvas=new HTMLCanvas("2D");
			var ctx=canvas.getContext('2d');
			PNGTools.PNG.setByData(data,canvas.source);
			canvas["_w"]=canvas.source.width;
			canvas["_h"]=canvas.source.height;
			return canvas;
		}

		PNGTools.createTextureByBinary=function(data){
			var canvas;
			canvas=wraps.binarypic.PNGTools.createCanvasByBinary(data);
			return new Texture(canvas);
		}

		PNGTools.PNG=null
		return PNGTools;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-10-20 下午4:14:49
	*/
	//class wraps.SMD5
	var SMD5=(function(){
		function SMD5(){}
		__class(SMD5,'wraps.SMD5');
		SMD5.safeAdd=function(x,y){
			var lsw=(x & 0xFFFF)+(y & 0xFFFF);
			var msw=(x >> 16)+(y >> 16)+(lsw >> 16);
			return (msw << 16)| (lsw & 0xFFFF);
		}

		SMD5.bitRotateLeft=function(num,cnt){
			return (num << cnt)| (num >>> (32-cnt))
		}

		SMD5.md5cmn=function(q,a,b,x,s,t){
			return SMD5.safeAdd(SMD5.bitRotateLeft(SMD5.safeAdd(SMD5.safeAdd(a,q),SMD5.safeAdd(x,t)),s),b)
		}

		SMD5.md5ff=function(a,b,c,d,x,s,t){
			return SMD5.md5cmn((b & c)| ((~b)& d),a,b,x,s,t)
		}

		SMD5.md5gg=function(a,b,c,d,x,s,t){
			return SMD5.md5cmn((b & d)| (c & (~d)),a,b,x,s,t)
		}

		SMD5.md5hh=function(a,b,c,d,x,s,t){
			return SMD5.md5cmn(b ^ c ^ d,a,b,x,s,t)
		}

		SMD5.md5ii=function(a,b,c,d,x,s,t){
			return SMD5.md5cmn(c ^ (b | (~d)),a,b,x,s,t)
		}

		SMD5.binlMD5=function(x,len){
			x[len >> 5] |=0x80 << (len % 32)
			x[(((len+64)>>> 9)<< 4)+14]=len;
			var i=0;
			var olda=0;
			var oldb=0;
			var oldc=0;
			var oldd=0;
			var a=1732584193;
			var b=-271733879;
			var c=-1732584194;
			var d=271733878;
			for (i=0;i < x.length;i+=16){
				olda=a
				oldb=b
				oldc=c
				oldd=d
				a=SMD5.md5ff(a,b,c,d,x[i],7,-680876936)
				d=SMD5.md5ff(d,a,b,c,x[i+1],12,-389564586)
				c=SMD5.md5ff(c,d,a,b,x[i+2],17,606105819)
				b=SMD5.md5ff(b,c,d,a,x[i+3],22,-1044525330)
				a=SMD5.md5ff(a,b,c,d,x[i+4],7,-176418897)
				d=SMD5.md5ff(d,a,b,c,x[i+5],12,1200080426)
				c=SMD5.md5ff(c,d,a,b,x[i+6],17,-1473231341)
				b=SMD5.md5ff(b,c,d,a,x[i+7],22,-45705983)
				a=SMD5.md5ff(a,b,c,d,x[i+8],7,1770035416)
				d=SMD5.md5ff(d,a,b,c,x[i+9],12,-1958414417)
				c=SMD5.md5ff(c,d,a,b,x[i+10],17,-42063)
				b=SMD5.md5ff(b,c,d,a,x[i+11],22,-1990404162)
				a=SMD5.md5ff(a,b,c,d,x[i+12],7,1804603682)
				d=SMD5.md5ff(d,a,b,c,x[i+13],12,-40341101)
				c=SMD5.md5ff(c,d,a,b,x[i+14],17,-1502002290)
				b=SMD5.md5ff(b,c,d,a,x[i+15],22,1236535329)
				a=SMD5.md5gg(a,b,c,d,x[i+1],5,-165796510)
				d=SMD5.md5gg(d,a,b,c,x[i+6],9,-1069501632)
				c=SMD5.md5gg(c,d,a,b,x[i+11],14,643717713)
				b=SMD5.md5gg(b,c,d,a,x[i],20,-373897302)
				a=SMD5.md5gg(a,b,c,d,x[i+5],5,-701558691)
				d=SMD5.md5gg(d,a,b,c,x[i+10],9,38016083)
				c=SMD5.md5gg(c,d,a,b,x[i+15],14,-660478335)
				b=SMD5.md5gg(b,c,d,a,x[i+4],20,-405537848)
				a=SMD5.md5gg(a,b,c,d,x[i+9],5,568446438)
				d=SMD5.md5gg(d,a,b,c,x[i+14],9,-1019803690)
				c=SMD5.md5gg(c,d,a,b,x[i+3],14,-187363961)
				b=SMD5.md5gg(b,c,d,a,x[i+8],20,1163531501)
				a=SMD5.md5gg(a,b,c,d,x[i+13],5,-1444681467)
				d=SMD5.md5gg(d,a,b,c,x[i+2],9,-51403784)
				c=SMD5.md5gg(c,d,a,b,x[i+7],14,1735328473)
				b=SMD5.md5gg(b,c,d,a,x[i+12],20,-1926607734)
				a=SMD5.md5hh(a,b,c,d,x[i+5],4,-378558)
				d=SMD5.md5hh(d,a,b,c,x[i+8],11,-2022574463)
				c=SMD5.md5hh(c,d,a,b,x[i+11],16,1839030562)
				b=SMD5.md5hh(b,c,d,a,x[i+14],23,-35309556)
				a=SMD5.md5hh(a,b,c,d,x[i+1],4,-1530992060)
				d=SMD5.md5hh(d,a,b,c,x[i+4],11,1272893353)
				c=SMD5.md5hh(c,d,a,b,x[i+7],16,-155497632)
				b=SMD5.md5hh(b,c,d,a,x[i+10],23,-1094730640)
				a=SMD5.md5hh(a,b,c,d,x[i+13],4,681279174)
				d=SMD5.md5hh(d,a,b,c,x[i],11,-358537222)
				c=SMD5.md5hh(c,d,a,b,x[i+3],16,-722521979)
				b=SMD5.md5hh(b,c,d,a,x[i+6],23,76029189)
				a=SMD5.md5hh(a,b,c,d,x[i+9],4,-640364487)
				d=SMD5.md5hh(d,a,b,c,x[i+12],11,-421815835)
				c=SMD5.md5hh(c,d,a,b,x[i+15],16,530742520)
				b=SMD5.md5hh(b,c,d,a,x[i+2],23,-995338651)
				a=SMD5.md5ii(a,b,c,d,x[i],6,-198630844)
				d=SMD5.md5ii(d,a,b,c,x[i+7],10,1126891415)
				c=SMD5.md5ii(c,d,a,b,x[i+14],15,-1416354905)
				b=SMD5.md5ii(b,c,d,a,x[i+5],21,-57434055)
				a=SMD5.md5ii(a,b,c,d,x[i+12],6,1700485571)
				d=SMD5.md5ii(d,a,b,c,x[i+3],10,-1894986606)
				c=SMD5.md5ii(c,d,a,b,x[i+10],15,-1051523)
				b=SMD5.md5ii(b,c,d,a,x[i+1],21,-2054922799)
				a=SMD5.md5ii(a,b,c,d,x[i+8],6,1873313359)
				d=SMD5.md5ii(d,a,b,c,x[i+15],10,-30611744)
				c=SMD5.md5ii(c,d,a,b,x[i+6],15,-1560198380)
				b=SMD5.md5ii(b,c,d,a,x[i+13],21,1309151649)
				a=SMD5.md5ii(a,b,c,d,x[i+4],6,-145523070)
				d=SMD5.md5ii(d,a,b,c,x[i+11],10,-1120210379)
				c=SMD5.md5ii(c,d,a,b,x[i+2],15,718787259)
				b=SMD5.md5ii(b,c,d,a,x[i+9],21,-343485551)
				a=SMD5.safeAdd(a,olda)
				b=SMD5.safeAdd(b,oldb)
				c=SMD5.safeAdd(c,oldc)
				d=SMD5.safeAdd(d,oldd)
			}
			return [a,b,c,d]
		}

		SMD5.binl2rstr=function(input){
			var i=0;
			var output='';
			var length32=input.length *32
			for (i=0;i < length32;i+=8){
				output+=String.fromCharCode((input[i >> 5] >>> (i % 32))& 0xFF)
			}
			return output;
		}

		SMD5.rstr2binl=function(input){
			var i=0;
			var output=[]
			output[(input.length >> 2)-1]=undefined
			for (i=0;i < output.length;i+=1){
				output[i]=0
			};
			var length8=input.length *8
			for (i=0;i < length8;i+=8){
				output[i >> 5] |=(input.charCodeAt(i / 8)& 0xFF)<< (i % 32)
			}
			return output;
		}

		SMD5.rstrMD5=function(s){
			return SMD5.binl2rstr(SMD5.binlMD5(SMD5.rstr2binl(s),s.length *8))
		}

		SMD5.rstrHMACMD5=function(key,data){
			var i=0;
			var bkey=SMD5.rstr2binl(key);
			var ipad=[];
			var opad=[];
			var hash;
			ipad[15]=opad[15]=undefined;
			if (bkey.length > 16){
				bkey=SMD5.binlMD5(bkey,key.length *8)
			}
			for (i=0;i < 16;i+=1){
				ipad[i]=bkey[i] ^ 0x36363636
				opad[i]=bkey[i] ^ 0x5C5C5C5C
			}
			hash=SMD5.binlMD5(ipad.concat(SMD5.rstr2binl(data)),512+data.length *8)
			return SMD5.binl2rstr(SMD5.binlMD5(opad.concat(hash),512+128))
		}

		SMD5.rstr2hex=function(input){
			var hexTab='0123456789abcdef';
			var output='';
			var x=0;
			var i=0;
			for (i=0;i < input.length;i+=1){
				x=input.charCodeAt(i)
				output+=hexTab.charAt((x >>> 4)& 0x0F)+
				hexTab.charAt(x & 0x0F)
			}
			return output
		}

		SMD5.str2rstrUTF8=function(input){
			return unescape(encodeURIComponent(input))
		}

		SMD5.rawMD5=function(s){
			return SMD5.rstrMD5(SMD5.str2rstrUTF8(s))
		}

		SMD5.hexMD5=function(s){
			return SMD5.rstr2hex(SMD5.rawMD5(s))
		}

		SMD5.rawHMACMD5=function(k,d){
			return SMD5.rstrHMACMD5(SMD5.str2rstrUTF8(k),SMD5.str2rstrUTF8(d))
		}

		SMD5.hexHMACMD5=function(k,d){
			return SMD5.rstr2hex(SMD5.rawHMACMD5(k,d))
		}

		SMD5.md5=function(string,key,raw){
			if (!key){
				if (!raw){
					return SMD5.hexMD5(string)
				}
				return SMD5.rawMD5(string)
			}
			if (!raw){
				return SMD5.hexHMACMD5(key,string)
			}
			return SMD5.rawHMACMD5(key,string)
		}

		return SMD5;
	})()


	//class laya.editor.core.Wraps.xml.XMLElementList extends Array
	var XMLElementList=(function(_super){
		function XMLElementList(value){
			this._value="";
			this._parentNode=null;
			XMLElementList.__super.call(this);
			__uns(this,['_value','_parentNode']);
			if (value){
				value="<data>"+value+"</data>";
				var list=XMLElementList.create(XMLElement.create(value).childNodes);
				for (var i=0;i < list.length;i++){
					this.push(list[i]);
				}
			}
			Object.defineProperty(this,'length',{value:this.length,writable:true,enumerable:false,configurable:false});
		}

		__class(XMLElementList,'laya.editor.core.Wraps.xml.XMLElementList',Array);
		var __proto=XMLElementList.prototype;
		Laya.imps(__proto,{"laya.editor.core.Wraps.xml.IXMLElement":true})
		__proto.childIndex=function(){
			if (this.lengths()==1){
				var xml=this[0];
				var parent=xml._parentNode;
				if (parent){
					var nodes=parent._childNodes;
					for (var i=0,n=nodes.length;i < n;i++){
						if (nodes[i]==xml){
							return i;
						}
					}
				}
			}
			return-1;
		}

		__proto.getAttributes=function(){
			return this.attributes();
		}

		__proto.attributes=function(){
			return this.getAttribute("*");
		}

		//xml.@name
		__proto.getAttribute=function(name){
			var arr=[],len=this.length;
			for (var i=0;i < len;i++){
				var attributes=this[i]._attributes;
				for (var j=0;j < attributes.length;j++){
					var value=attributes[j]['key'];
					if (name=="*" || value==name){
						arr.push({"key":attributes[j]['key'],"val":attributes[j]['val']});
					}
				}
			}
			if (name!="*"){
				return arr.length>0?arr[0].val:undefined;
			}
			return laya.editor.core.Wraps.xml.XMLElementList.createFromAttribute(arr);
		}

		//xml.@name
		__proto.attribute=function(name){
			return this.getAttribute(name);
		}

		//xml.@name=value;
		__proto.setAttribute=function(name,value){
			if (this.length==1){
				var o;
				for(var $each_o in this[0]._attributes){
					o=this[0]._attributes[$each_o];
					if (o['key']==name){
						o['val']=value;
						return value;
					}
				}
				this[0]._attributes.push({key:name,val:value});
			}
			return null;
		}

		//xml.name;
		__proto.getChildByName=function(name){
			return this.child(name);
		}

		__proto.child=function(name){
			if (!this.length)
				return new XMLElementList();
			var arr=[],len=this.lengths();
			for (var i=0;i < len;i++){
				var nodes=this[i].getChildByName(name);
				(nodes && nodes.length)&& (arr=arr.concat(this[i].getChildByName(name)));
			}
			return XMLElementList.create(arr);
		}

		//xml.(@attribute==value);或者xml.(@attribute!=value)
		__proto.getChildByAttribute=function(attribute,value,equal){
			(equal===void 0)&& (equal=true);
			if (attribute=="" || attribute==null)
				return null;
			if (value=="" || value==null)
				return null;
			var ar=[],len=this.length;
			for (var i=0;i < len;i++){
				var n=this [i];
				for (var j=0;j < n._attributes.length;j++){
					if (n._attributes[j]['key']==attribute){
						if (equal && n._attributes[j]['val']==value){
							ar.push(n);
							}else if (!equal && n._attributes[j]['val'] !=value){
							ar.push(n);
						}
					}
				}
			}
			return laya.editor.core.Wraps.xml.XMLElementList.create(ar);
		}

		__proto.getChildAt=function(index){
			if (!this.length || index > this.length)
				return null;
			else
			return this[index];
		}

		// return this[0].getChildAt(index);
		__proto.children=function(){
			var xl=new XMLElementList();
			var len=this.lengths();
			for (var i=0;i < len;i++){
				var childs=this[i]._childNodes;
				var n=childs.length;
				for (var j=0;j < n;j++){
					xl.push(childs[j]);
				}
				if(n<1){
					xl.push(this[i]);
				}
			}
			return xl;
		}

		__proto.elements=function(name){
			(name===void 0)&& (name="*");
			if (!this.length)
				return new XMLElementList();
			if (name=="*")
				return this.children();
			return this.child(name);
		}

		__proto.appendChild=function(value){
			if ((typeof value=='string')){
				value=XMLElement.create(String(value));
			}
			this.__doAdd__(value);
			return value;
		}

		__proto.__addChild__=function(value){
			if ((value instanceof laya.editor.core.Wraps.xml.XMLElement )){
				var ixl=value._childNodes,len=ixl.length;
				for (var i=0;i < len;i++){
					this.__doAdd__(ixl[i]);
				}
				this.push(value);
				}else if ((value instanceof laya.editor.core.Wraps.xml.XMLElementList )){
				len=value.lengths();
				for (i=0;i < len;i++){
					this.__addChild__(value[i]);
				}
			}
		}

		__proto.__doAdd__=function(value){
			if (this.indexOf(value)!=-1)
				return;
			var n=value._nodeName;
			var x=this[n];
			if ((x instanceof laya.editor.core.Wraps.xml.XMLElementList )){
				x.__addChild__(value);
				}else if ((x instanceof laya.editor.core.Wraps.xml.XMLElement )){
				var tmp=x;
				x=this[n]=new XMLElementList();
				Object.defineProperty(this,[n],{value:this[n],writable:true,enumerable:false,configurable:false});
				x.__addChild__(tmp);
				x.__addChild__(value);
				}else if (!x){
				x=this[n]=new XMLElementList();
				x.__addChild__(value);
				Object.defineProperty(this,[n],{value:this[n],writable:true,enumerable:false,configurable:false});
			}
		}

		__proto.setName=function(str){
			if (this.length==1){
				this[0]._nodeName=str;
			}
		}

		__proto.copyFrom=function(source){
			if (this.lengths()> 1)
				return null;
			var il=((source instanceof laya.editor.core.Wraps.xml.XMLElementList ));
			if (source.lengths()> 1)
				return null;
			if (il)
				this[0].copyFrom(source.getChildAt(0));
			else
			this[0].copyFrom(source);
			return this [0];
		}

		__proto.hasOwnProperty=function(pName){
			if (this.length==0){
				return this[0].hasOwnProperty(pName);
				}else {
				var x;
				for(var $each_x in this){
					x=this[$each_x];
					if (x['hasOwnProperty'](pName))
						return true;
				}
			}
			return false;
		}

		__proto.setChildByName=function(nName,value){
			return null;
		}

		// return this;
		__proto.hasComplexContent=function(){
			return this.length > 0;
		}

		__proto.hasSimpleContent=function(){
			var len=this.length;
			for (var i=0;i < len;i++){
				if (this['_nodeValue'] !=null){
					return true
				}
			}
			return false
		}

		__proto.name=function(){
			if (this.length==1)
				return this[0].name();
			return null;
		}

		__proto.lengths=function(){
			for (var i=this.length-1;i >=0;i--){
				if (this[i]==undefined)
					this.splice(i,1);
			}
			return this.length;
		}

		__proto.toString=function(){
			var str="";
			if (this.lengths()){
				if (this.length==1){
					str+=this[0].toString();
					}else {
					for (var i=0;i < this.length;i++){
						if (this.length > 1)
							str+=this[i].getString();
					}
				}
			}
			return str;
		}

		__proto.toXMLString=function(){
			var str="";
			for (var i=0;i < this.length;i++){
				str+=this[i].toXMLString();
			}
			return str;
		}

		__proto.parent=function(){
			return this._parentNode;
		}

		__proto.copy=function(){
			var list=new XMLElementList(this.toXMLString());
			return list;
		}

		__proto.getString=function(){
			var str="";
			str=this.toXMLString();
			return str;
		}

		__proto.comments=function(){
			return null;
		}

		__proto.contains=function(value){
			return true;
		}

		__getset(0,__proto,'nodeType',function(){
			return "*";
		});

		__getset(0,__proto,'childNodes',function(){
			return null;
		});

		__getset(0,__proto,'value',function(){
			if (this.length==1){
				return this[0]._nodeValue;
			}
			return "";
			},function(str){
			if (this.length==1){
				this[0]._nodeValue=str;
			}
		});

		__getset(0,__proto,'localName',function(){
			return null
			},function(str){
			if (this.length==1){
				this[0]._nodeName=str;
			}
		});

		__getset(0,__proto,'nodeName',function(){
			return null;
		});

		__uns(__proto,['childIndex','getAttributes','attributes','getAttribute','attribute','setAttribute','getChildByName','child','getChildByAttribute','getChildAt','children','elements','appendChild','__addChild__','__doAdd__','setName','copyFrom','hasOwnProperty','setChildByName','hasComplexContent','hasSimpleContent','name','lengths','toString','toXMLString','parent','copy','getString','comments','contains']);
		XMLElementList.create=function(arr){
			var xl=new XMLElementList();
			for (var i=0;i < arr.length;i++){
				xl.__addChild__(arr[i]);
			}
			return xl;
		}

		XMLElementList.createFromAttribute=function(arr){
			var xl=new XMLElementList();
			for (var i=0;i < arr.length;i++){
				var xml=new XMLElement();
				var obj=arr[i];
				xml._nodeName=obj.key;
				xml._nodeValue=obj.val;
				xl.push(xml);
			}
			return xl;
		}

		return XMLElementList;
	})(Array)


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-9-2 上午9:51:29
	*/
	//class as3analyser.parser.struct.DefineAndBody extends as3analyser.parser.struct.CodePiece
	var DefineAndBody=(function(_super){
		function DefineAndBody(){
			this.keyWord="DefineAndBody";
			this.defineNoBody=null;
			this.defineLine=null;
			this.body=null;
			this.bodyLines=null;
			DefineAndBody.__super.call(this);
		}

		__class(DefineAndBody,'as3analyser.parser.struct.DefineAndBody',_super);
		var __proto=DefineAndBody.prototype;
		__proto.dealDifineStr=function(defineStr){
			var i=0;
			i=defineStr.indexOf("{");
			if(i>=0){
				this.defineNoBody=defineStr.substring(0,i);
				this.lines.shift();
				var lineItem;
				lineItem=new LineItem();
				lineItem.lineIndex=0;
				lineItem.lineStr="{";
				this.lines.unshift(lineItem);
				}else{
				this.defineNoBody=defineStr;
			}
		}

		__proto.parseInfo=function(defineLine){
			defineLine=defineLine;
			this.dealDifineStr(defineLine.lineStr);
			this.parseMyInfo();
		}

		__proto.parseMyInfo=function(){}
		__proto.build=function(){
			this.code=this.defineNoBody+"\n{\n"+this.body.getCode()+"\n}";
		}

		DefineAndBody.findBodyLines=function(lineCount,lines){
			var pairs;
			var tPos;
			tPos=new PosItem();
			tPos.line=lineCount;
			pairs=StringTool.findPair("{","}",tPos,lines);
			if(pairs){
				return pairs[pairs.length-1].line;
				}else{
				return-1;
			}
		}

		DefineAndBody.test=function(lineCount,lines,testFun){
			var tLine;
			tLine=lines[lineCount];
			var rst=0;
			rst=-1;
			if(testFun(tLine.lineStr,lineCount,lines)){
				rst=DefineAndBody.findBodyLines(lineCount,lines);
			}
			return rst;
		}

		return DefineAndBody;
	})(CodePiece)


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-9-2 上午9:31:02
	*/
	//class as3analyser.parser.struct.CodeBlock extends as3analyser.parser.struct.CodePiece
	var CodeBlock=(function(_super){
		function CodeBlock(){
			this.varLines=null;
			this.funName=null;
			this.BlockCodeT=
			""+
			"var _$this:*=this;"+"\n"+
			"{varDefines}"+"\n"+
			"var _SyNrTn_:*,__$:Function=function (__line:int):*"+""+
			"{"+"\n"+
			"{codeBlock}"+"\n"+
			"};"+"\n"+
			"__$(0);";
			CodeBlock.__super.call(this);
		}

		__class(CodeBlock,'as3analyser.parser.struct.CodeBlock',_super);
		var __proto=CodeBlock.prototype;
		__proto.build=function(){
			var i=0;
			var len=0;
			var tLineItem;
			var tCodes;
			len=this.varLines.length;
			tCodes=[];
			for(i=0;i<len;i++){
				tLineItem=this.varLines[i];
				tCodes.push(tLineItem.lineStr);
			}
			this.code=StringTool.getReplace(this.BlockCodeT,"{varDefines}",tCodes.join("\n"));
			this.code=StringTool.getReplace(this.code,"{codeBlock}",tCodes.join("\n"));
		}

		__proto.getVarDefines=function(){
			var i=0;
			var len=0;
			len=this.lines.length;
			var tLineItem;
			this.varLines=[];
			for(i=len-1;i>=0;i--){
				tLineItem=this.lines[i];
				if(tLineItem.lineStr.indexOf("var ")>=0){
					var cLines;
					cLines=VarParser.parseValueLine(tLineItem);
					this.varLines=this.varLines.concat(cLines[0]);
					tLineItem.lineType="var";
				}
			}
		}

		// lines=ArrayTool.insertArr(lines,cLines[1],i);
		__proto.parseFunctionBody=function(){
			this.getVarDefines();
		}

		CodeBlock.createByLines=function(lines,funName,codeT){
			var rst;
			rst=new CodeBlock();
			if(codeT){
				rst.BlockCodeT=codeT;
			}
			rst.setLines(lines);
			rst.funName=funName;
			rst.parseFunctionBody();
			rst.build();
			return rst;
		}

		return CodeBlock;
	})(CodePiece)


	/**拖动事件类*/
	//class laya.editor.core.events.DragEvent extends laya.events.Event
	var DragEvent=(function(_super){
		function DragEvent(type,dragInitiator,data,bubbles,cancelable){
			this._data=null;
			this._dragInitiator=null;
			this.hitList=null;
			DragEvent.__super.call(this);
			(bubbles===void 0)&& (bubbles=true);
			(cancelable===void 0)&& (cancelable=false);
			this.type=type;
			this._dragInitiator=dragInitiator;
			this._data=data;
		}

		__class(DragEvent,'laya.editor.core.events.DragEvent',_super);
		var __proto=DragEvent.prototype;
		__proto.clone=function(){
			return new DragEvent(this.type,this._dragInitiator,this._data);
		}

		/**拖动的源对象*/
		__getset(0,__proto,'dragInitiator',function(){
			return this._dragInitiator;
			},function(value){
			this._dragInitiator=value;
		});

		/**拖动传递的数据*/
		__getset(0,__proto,'data',function(){
			return this._data;
			},function(value){
			this._data=value;
		});

		DragEvent.getMutiDragFiles=function(e){
			var data=e.data;
			if(data.type!="multiResFile"&&data.type!="resDir"){
				return null;
			};
			var src=e.dragInitiator;
			var fileList;
			fileList=data.fileList;
			if(data.type=="resDir"){
				fileList=FileTools.getFileList(data.asset);
			};
			var i=0,len=0;
			len=fileList.length;
			var files;
			files=[];
			for(i=0;i<len;i++){
				var path;
				path=fileList[i];
				if(FileTools.isDirectory(path))continue ;
				path=FileManager.getRelativePath(SystemSetting.assetsPath,path);
				path=FileManager.adptToCommonUrl(path);
				files.push(path);
			}
			files.sort();
			return files;
		}

		DragEvent.DRAG_START="dragStart";
		DragEvent.DRAG_DROP="dragDrop";
		DragEvent.Draging_Hit="Draging_Hit";
		DragEvent.DRAG_COMPLETE="dragComplete";
		DragEvent.DRAG_MOVE="dragMove";
		DragEvent.Res="res";
		DragEvent.ResDir="resDir";
		DragEvent.Props="Props";
		DragEvent.MULTI_RESFILE="multiResFile";
		DragEvent.DisplayDrag="displayDrag";
		DragEvent.SystemDrag="SystemDrag";
		DragEvent.Page="page";
		DragEvent.PageDir="pageDir";
		DragEvent.MULTI_PAGEFILE="multiPageFile";
		__static(DragEvent,
		['TEMP',function(){return this.TEMP=new DragEvent("dragDrop");}
		]);
		return DragEvent;
	})(Event)


	/**UI事件类*/
	//class laya.editor.core.events.UIEvent extends laya.events.Event
	var UIEvent=(function(_super){
		function UIEvent(type,data,bubbles,cancelable){
			this._data=null;
			UIEvent.__super.call(this);
			(bubbles===void 0)&& (bubbles=false);
			(cancelable===void 0)&& (cancelable=false);
			this.type=type;
			this._data=data;
		}

		__class(UIEvent,'laya.editor.core.events.UIEvent',_super);
		var __proto=UIEvent.prototype;
		__proto.clone=function(){
			return new UIEvent(this.type,this._data);
		}

		/**事件数据*/
		__getset(0,__proto,'data',function(){
			return this._data;
			},function(value){
			this._data=value;
		});

		UIEvent.MOVE="move";
		UIEvent.RENDER_COMPLETED="renderCompleted";
		UIEvent.SHOW_TIP="showTip";
		UIEvent.HIDE_TIP="hideTip";
		UIEvent.IMAGE_LOADED="imageLoaded";
		UIEvent.SCROLL="scroll";
		UIEvent.FRAME_CHANGED="frameChanged";
		UIEvent.ITEM_RENDER="listRender";
		UIEvent.CHANGING="changing";
		return UIEvent;
	})(Event)


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-3-22 下午7:18:25
	*/
	//class laya.ide.viewer.CodeScene extends laya.ide.viewer.SceneBase
	var CodeScene=(function(_super){
		function CodeScene(){
			CodeScene.__super.call(this);
		}

		__class(CodeScene,'laya.ide.viewer.CodeScene',_super);
		var __proto=CodeScene.prototype;
		__proto.setUp=function(parent){
			CodeViewManager.I.show();
			CodeViewManager.openFile(this.pagePath);
		}

		__proto.removeSelf=function(){
			_super.prototype.removeSelf.call(this);
			CodeViewManager.I.hide();
		}

		// trace("codeScene init");
		__getset(0,__proto,'pagePath',_super.prototype._$get_pagePath,function(path){
			_super.prototype._$set_pagePath.call(this,path);
		});

		return CodeScene;
	})(SceneBase)


	/**
	*粒子编辑页面
	*@author ww
	*@version 1.0
	*
	*@created 2015-10-21 下午7:51:20
	*/
	//class laya.ide.viewer.ParticleScene extends laya.ide.viewer.SceneBase
	var ParticleScene=(function(_super){
		function ParticleScene(){
			this.mType=null;
			ParticleScene.__super.call(this);
			this.mType=ParticleScene.ParticleType;
		}

		__class(ParticleScene,'laya.ide.viewer.ParticleScene',_super);
		var __proto=ParticleScene.prototype;
		__proto.setUp=function(parent){
			Laya.timer.frameOnce(2,this,this.addRenderFrame);
		}

		// addRenderFrame();
		__proto.open=function(){
			_super.prototype.open.call(this);
			DialogTools.showOpenFile(Sys.lang("打开粒子文件"),Utils$1.bind(this.openFile,this),DialogTools.getOpenParticleO());
		}

		__proto.openFile=function(file){
			if(file){
				var jsonStr=FileTools.readFile(file[0]);
				var data=ObjectTools$1.getObj(jsonStr);
				ViewRenderManager.render.setData(data);
				var particleData;
				particleData=ObjectTools$1.flatObj(data);
				Notice.notify("PropPanel_setByObj",[particleData,this.mType]);
			}
		}

		// trace("configJson:",ObjectTools.getJsonString(data));
		__proto.getDesignData=function(){
			return ViewRenderManager.render.getRenderData();
		}

		__proto.changeDataO=function(dataO){
			var particleData;
			particleData=ObjectTools$1.flatObj(this.data);
			Notice.notify("PropPanel_setByObj",[particleData,this.mType]);
			this.setRenderData(this.data);
		}

		__proto.save=function(){
			_super.prototype.save.call(this);
			if (this.pagePath){
				this.saveFile(this.pagePath);
				}else{
				DialogTools.showSave(Sys.lang("保存粒子配置文件"),"particle.json",Utils$1.bind(this.saveFile,this));
			}
		}

		__proto.onResClick=function(data){}
		//ViewRenderManager.render.updateData(updateData);
		__proto.renderDragDrop=function(e){
			_super.prototype.renderDragDrop.call(this,e);
			if(e.data&&e.data.type=="res"){
				if(!e.data.asset||e.data.asset=="")return;
				if(ResFileManager.isResFile(e.data.asset))
					this.changeValue("textureName",FileManager.getRelativePath(SystemSetting.assetsPath,e.data.asset));
			}
		}

		__proto.propChange=function(key,data){
			_super.prototype.propChange.call(this,key,data);
			this.particleValueChange(key,data)
		}

		__proto.changeTextureByPath=function(path){
			var updateData;
			updateData={};
			updateData.type="texture";
			updateData.url=path;
			ViewRenderManager.render.updateData(updateData);
		}

		__proto.saveFile=function(file){
			if(file){
				var data=StateManager.getState(this.pagePath).now();
				var fileStr;
				fileStr=ObjectTools$1.getJsonString(data);
				try{
					var obj=ObjectTools$1.getObj(fileStr);
					if(!obj.textureName){
						Alert.show(Sys.lang("保存粒子文件出错"));
						return;
					}
					}catch(e){
					Alert.show(Sys.lang("保存粒子文件出错"));
					return;
				}
				FileTools.createFile(file,ObjectTools$1.getJsonString(data));
				MessageManager.instance.show(Sys.lang("保存成功"));
				this._changed=false;
				StateManager.setChangeState(this.pagePath,false);
				Laya.stage.event("pageSaved");
				Laya.stage.event("pageChanged");
			}
		}

		__proto.addRenderFrame=function(){
			var renderPath;
			var type;
			type=TypeManager.getFileType(this.pagePath);
			switch(type){
				case "particle3D":
					renderPath="renders/particle3d/editor.max.html";
					break ;
				case "particlepoly":
					renderPath="renders/particlepoly/editor.max.html";
					break ;
				default :
					renderPath="renders/particle/editor.max.html";
				}
			ViewRenderManager.setRender(renderPath);
			this.show();
			ViewRenderManager.eDispatcher.once("complete",this,this.initParticleEditor);
		}

		//changeTest();
		__proto.initParticleEditor=function(){
			this._changed=false;
			var data;
			if(this.pagePath){
				if(StateManager.has(this.pagePath)){
					data=StateManager.getState(this.pagePath).now();
					}else{
					try{
						var jsonStr=FileTools.readFile(this.pagePath);
						data=ObjectTools$1.getObj(jsonStr);
						StateManager.updateState(this.pagePath,data);
						}catch(e){
						Alert.show(Sys.lang("读取粒子数据出错，请查看粒子文件是否已损坏"));
						return;
					}
				}
				if(TypeManager.getFileType(this.pagePath)=="particlepoly"){
					this.mType=ParticleScene.ParticlePolyType;
				}
				}else{
				data=ViewRenderManager.render.getRenderData();
			};
			var particleData;
			particleData=ObjectTools$1.flatObj(data);
			Notice.notify("PropPanel_setByObj",[particleData,this.mType]);
			try{
				Laya.timer.frameOnce(1,this,this.renderByData,[data]);
			}
			catch(e){}
		}

		__proto.renderByData=function(data){
			var updateData;
			updateData={};
			updateData.type="init";
			updateData.url=FileTools.getAbsPath(this.pagePath);
			updateData.base=FileTools.getAbsPath(SystemSetting.assetsPath+FileTools.getSep());
			updateData.data=data;
			try{
				ViewRenderManager.render.getStage()["bgColor"]=data.backColor;
				ViewRenderManager.render.updateData(updateData);
				}catch(e){
			}
		}

		// Notice.notify(IDEEvent.SHOW_DISPLAY_TREE,[ViewRenderManager.render.getStage()]);
		__proto.goBack=function(){
			_super.prototype.goBack.call(this);
			var data=StateManager.getState(this.pagePath).back();
			if(!data){
				console.log("当前不可回退");
				return;
			};
			var particleData;
			particleData=ObjectTools$1.flatObj(data);
			Notice.notify("PropPanel_setByObj",[particleData,this.mType]);
			this.setRenderData(data);
		}

		__proto.goForward=function(){
			_super.prototype.goForward.call(this);
			var data=StateManager.getState(this.pagePath).forward();
			if(!data){
				console.log("当前不可前进");
				return;
			};
			var particleData;
			particleData=ObjectTools$1.flatObj(data);
			Notice.notify("PropPanel_setByObj",[particleData,this.mType]);
			this.setRenderData(data);
		}

		__proto.changeValue=function(key,value){
			var data=ViewRenderManager.render.getRenderData();
			if(data.hasOwnProperty(key)){
				ObjectTools$1.setKeyValue(data,key,value);
			};
			var particleData;
			particleData=ObjectTools$1.flatObj(data);
			Notice.notify("PropPanel_setByObj",[particleData,this.mType]);
			this.particleValueChange(key,value);
		}

		__proto.particleValueChange=function(key,value){
			var data=ViewRenderManager.render.getRenderData();
			if (key=="textureFileName"){
				ObjectTools$1.setKeyValue(data,key,value);
				this.changeTextureByPath(value);
				this._changed=true;
				StateManager.updateState(this.pagePath,data);
				Laya.stage.event("pageChanged");
				return;
				}else{
				ObjectTools$1.setKeyValue(data,key,ObjectTools$1.getAutoValue(value));
				StateManager.updateState(this.pagePath,data);
			}
			this.setRenderData(data);
			var particleData;
			particleData=ObjectTools$1.flatObj(data);
			Notice.notify("PropPanel_setByObj",[particleData,this.mType]);
		}

		__proto.setRenderData=function(data){
			this.renderByData(data);
			this._changed=true;
			StateManager.setChangeState(this.pagePath,true);
			Laya.stage.event("pageChanged");
		}

		__getset(0,__proto,'hasChange',function(){
			return StateManager.hasChange(this.pagePath);
		});

		ParticleScene.ParticleType="Particle";
		ParticleScene.ParticlePolyType="PolyEmitter";
		return ParticleScene;
	})(SceneBase)


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-2-23 上午11:06:53
	*/
	//class laya.ide.viewer.SceneEditorScene extends laya.ide.viewer.SceneBase
	var SceneEditorScene=(function(_super){
		function SceneEditorScene(){
			this._parent=null;
			this._ui=null;
			SceneEditorScene.__super.call(this);
		}

		__class(SceneEditorScene,'laya.ide.viewer.SceneEditorScene',_super);
		var __proto=SceneEditorScene.prototype;
		__proto.setUp=function(parent){
			_super.prototype.setUp.call(this);
			this._parent=parent;
			this.createUI();
		}

		__proto.createUI=function(){
			this._ui=new Sprite();
			var txt=new Text();
			txt.text="我是场景编辑器";
			txt.pos(100,100);
			txt.color="#ff0000";
			this._ui.addChild(txt);
			if(this._ui){
				this._ui["top"]=0;
				this._ui["left"]=0;
			}
		}

		//_ui["right"]=0;
		__proto.removeSelf=function(){
			_super.prototype.removeSelf.call(this);
			if(this._ui)this._ui.removeSelf();
		}

		__proto.show=function(){
			if(this._parent&&this._ui){
				this._parent.addChild(this._ui);
			}
		}

		return SceneEditorScene;
	})(SceneBase)


	/**
	*显示对象页
	*@author ww
	*@version 1.0
	*
	*@created 2015-11-28 上午10:36:33
	*/
	//class laya.ide.viewer.UIPageScene extends laya.ide.viewer.SceneBase
	var UIPageScene=(function(_super){
		function UIPageScene(){
			this._parent=null;
			this._ui=null;
			UIPageScene.__super.call(this);
		}

		__class(UIPageScene,'laya.ide.viewer.UIPageScene',_super);
		var __proto=UIPageScene.prototype;
		__proto.setUp=function(parent){
			_super.prototype.setUp.call(this);
			this._parent=parent;
			this._ui=this.data;
			if(this._ui){
				this._ui["top"]=0;
				this._ui["left"]=0;
			}
		}

		//_ui["right"]=0;
		__proto.removeSelf=function(){
			_super.prototype.removeSelf.call(this);
			if(this._ui)this._ui.removeSelf();
		}

		__proto.show=function(){
			if(this._parent&&this._ui){
				this._parent.addChild(this._ui);
			}
		}

		return UIPageScene;
	})(SceneBase)


	/**
	*iFrame页
	*@author ww
	*@version 1.0
	*
	*@created 2015-11-27 下午7:55:01
	*/
	//class laya.ide.viewer.WebPageScene extends laya.ide.viewer.SceneBase
	var WebPageScene=(function(_super){
		function WebPageScene(){
			WebPageScene.__super.call(this);
		}

		__class(WebPageScene,'laya.ide.viewer.WebPageScene',_super);
		var __proto=WebPageScene.prototype;
		__proto.setUp=function(parent){
			_super.prototype.setUp.call(this);
			this.addRenderFrame();
		}

		__proto.addRenderFrame=function(){
			ViewRenderManager.setRender(this.pagePath);
			ViewRenderManager.show();
			ViewRenderManager.eDispatcher.once("complete",this,this.initWebScene);
		}

		//changeTest();
		__proto.initWebScene=function(){}
		return WebPageScene;
	})(SceneBase)


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-9-18 下午5:52:36
	*/
	//class laya.ide.viewer.XmlEditorScene extends laya.ide.viewer.SceneBase
	var XmlEditorScene=(function(_super){
		function XmlEditorScene(){
			this._parent=null;
			this._ui=null;
			this.iFrameCodeView=null;
			this._preCode=null;
			this._oldCode=null;
			XmlEditorScene.__super.call(this);
			this.iFrameCodeView=new XMLEditorSprite();
			this.iFrameCodeView.top=this.iFrameCodeView.bottom=this.iFrameCodeView.left=0;
			this.iFrameCodeView.right=0;
			this.iFrameCodeView.bottom=0;
			this.iFrameCodeView.on("txtchange",this,this.txtChange);
			this.iFrameCodeView.on("editorsave",this,this.save);
		}

		__class(XmlEditorScene,'laya.ide.viewer.XmlEditorScene',_super);
		var __proto=XmlEditorScene.prototype;
		__proto.setUp=function(parent){
			_super.prototype.setUp.call(this);
			this._parent=parent;
			this._ui=new Box();
			this._ui.addChild(this.iFrameCodeView);
			this._ui.on("mousedown",this,this.mouseDownW);
			if(this._ui){
				this._ui["top"]=0;
				this._ui["bottom"]=0;
				this._ui["left"]=0;
				this._ui["right"]=0;
			}
		}

		__proto.txtChange=function(){
			this._changed=(this._oldCode!=this.iFrameCodeView.getCode());
			Laya.stage.event("pageChanged");
		}

		__proto.mouseDownW=function(){}
		__proto.removeSelf=function(){
			_super.prototype.removeSelf.call(this);
			if(this._ui)this._ui.removeSelf();
			if(this.iFrameCodeView){
				this._preCode=this.iFrameCodeView.getCode();
			}
		}

		__proto.show=function(){
			if(this._parent&&this._ui){
				this._parent.addChild(this._ui);
				if(this._preCode){
					this.iFrameCodeView.setCode(this._preCode);
				}
			}
		}

		__proto.save=function(){
			_super.prototype.save.call(this);
			this._oldCode=this.iFrameCodeView.getCode();
			FileManager.createTxtFile(this.pagePath,this._oldCode);
			this._changed=false;
			Laya.stage.event("pageChanged");
			if(TypeManager.getFileType(this.pagePath)=="Script"){
				var sPath;
				sPath=FileManager.getWorkRelativePath(this.pagePath);
				if(AppendPropGroupTool.isScriptInit(sPath)){
					PropPanel.instance.clearPanelCache(AppendPropGroupTool.getScriptName(sPath));
					AppendPropGroupTool.clearScript(sPath);
				}
			}
		}

		__getset(0,__proto,'pagePath',_super.prototype._$get_pagePath,function(path){
			_super.prototype._$set_pagePath.call(this,path);
			var txt=FileManager.readTxtFile(path);
			this._oldCode=txt;
			this.iFrameCodeView.setCode(txt);
		});

		return XmlEditorScene;
	})(SceneBase)


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-8-31 下午9:17:20
	*/
	//class as3analyser.parser.FunctionItem extends as3analyser.parser.struct.DefineAndBody
	var FunctionItem=(function(_super){
		function FunctionItem(){
			this.funName=null;
			this.allLines=null;
			this.params=null;
			this.isSigned=false;
			this.isMachineCode=false;
			this.memberDic={};
			this.words=null;
			FunctionItem.__super.call(this);
			this.keyWord="function";
		}

		__class(FunctionItem,'as3analyser.parser.FunctionItem',_super);
		var __proto=FunctionItem.prototype;
		__proto.addMember=function(tStr){
			var tMember;
			if(SingleMemberParser.getMemberType(tStr)){
				tMember=SingleMemberParser.parseMember(tStr);
				this.memberDic[tMember.name]=tMember;
			}
		}

		//trace("function add mem:"+tMember.name+" type:"+tMember.type);
		__proto.setData=function(defineLine,lines){
			this.setLines(lines);
			this.parseInfo(defineLine);
			this.parse();
		}

		__proto.parse=function(){
			var i=0;
			var len=0;
			var tLine;
			var tStr;
			len=this.lines.length;
			for(i=0;i<len;i++){
				tLine=this.lines[i];
				tStr=tLine.lineStr;
				if(SingleMemberParser.getMemberType(tStr)){
					this.addMembers(SingleMemberParser.parseMembers(tStr));
				}
			}
			this.words=ASLex.toWords(this.oCode);
			this.build();
		}

		__proto.addMembers=function(mList){
			var i=0;
			var len=0;
			var tMember;
			len=mList.length;
			for(i=0;i<len;i++){
				tMember=mList[i];
				this.memberDic[tMember.name]=tMember;
			}
		}

		//trace("function add mem:"+tMember.name+" type:"+tMember.type);
		__proto.build=function(){}
		// TODO Auto Generated method stub
		__proto.parseMyInfo=function(){
			this.funName=StringTool.getBetween(this.defineNoBody,"function","(");
			this.funName=StringTool.trim(this.funName);
			this.params=StringTool.getBetween(this.defineNoBody,"(",")").split(",");
			var i=0;
			var len=0;
			this.params=StringTool.removeEmptyStr(this.params);
			len=this.params.length;
			for(i=0;i<len;i++){
				this.addMember("var "+this.params[i]);
			}
		}

		FunctionItem.createByLines=function(lines,defineLine){
			var rst;
			rst=new FunctionItem();
			rst.setData(defineLine,lines);
			return rst;
		}

		FunctionItem.AsySign="";
		return FunctionItem;
	})(DefineAndBody)


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-9-30 下午5:10:00
	*/
	//class laya.ide.hook.LoaderHook extends laya.net.Loader
	var LoaderHook=(function(_super){
		function LoaderHook(){
			LoaderHook.__super.call(this);
		}

		__class(LoaderHook,'laya.ide.hook.LoaderHook',_super);
		var __proto=LoaderHook.prototype;
		__proto.hookedLoad=function(url,type,cache){
			(cache===void 0)&& (cache=true);
			url=URL.formatURL(url);
			this._url=url;
			this._type=type || (type=this.getTypeFromUrl(url));
			this._cache=cache;
			this._data=null;
			if (Loader.loadedMap[url]){
				this._data=Loader.loadedMap[url];
				this.event("progress",1);
				this.event("complete",this._data);
				return;
			}
			if (Loader.parserMap[type] !=null){
				if (((Loader.parserMap[type])instanceof laya.utils.Handler ))Loader.parserMap[type].runWith(this);
				else Loader.parserMap[type].call(null,this);
				return;
			}
			if(url.indexOf("data:image/png")<0)
				url=url+"?v="+Math.random();
			if (type==="image" || type==="htmlimage" || type==="nativeimage")return this._loadImage(url);
			if (type==="sound")return this._loadSound(url);
			if (!this._http){
				this._http=new HttpRequest();
				this._http.on("progress",this,this.onProgress);
				this._http.on("error",this,this.onError);
				this._http.on("complete",this,this.onLoaded);
			}
			this._http.send(url,null,"get",type!=="atlas" ? type :"json");
		}

		LoaderHook.init=function(){
			LoaderHook.I=new LoaderHook();
			LoaderHook.setRenderHook();
		}

		LoaderHook.setRenderHook=function(){
			Loader["prototype"]["load"]=LoaderHook.I.hookedLoad;
		}

		LoaderHook.I=null
		return LoaderHook;
	})(Loader)


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-5-30 下午8:41:00
	*/
	//class laya.ide.managers.FontLoader extends laya.net.Loader
	var FontLoader=(function(_super){
		function FontLoader(){
			FontLoader.__super.call(this);
		}

		__class(FontLoader,'laya.ide.managers.FontLoader',_super);
		FontLoader.init=function(){
			Loader.parserMap["Font"]=FontLoader.loadFont;
		}

		FontLoader.isFontFile=function(file){
			return FileTools.getExtensionName(file)=="fnt";
		}

		FontLoader.getFontLoaderItem=function(file){
			var url;
			url=file.substr(0,file.length-4);
			url+=".font";
			return {url:url,type:"Font",priority:2 };
		}

		FontLoader.loadFont=function(loader){
			var font;
			font=new BitmapFont();
			var url;
			url=loader.url.replace(".font",".fnt");
			ResFileManager.clearRes(url);
			ResFileManager.clearRes(loader.url.replace(".font",".png"));
			var fontName;
			fontName=FileTools.getFileName(url);
			console.log("load font:",fontName,url);
			font.loadFont(url,Handler.create(null,FontLoader.loadFontComplete,[loader,fontName,font]));
		}

		FontLoader.loadFontComplete=function(loader,fontName,font){
			console.log("loaded font:",fontName);
			Text.registerBitmapFont(fontName,font);
			loader.endLoad(font);
		}

		FontLoader.isOkFont=function(file){
			if(!FileTools.exist(file.replace(".fnt",".png")))return false;
			if(!FileTools.exist(file.replace(".fnt",".fnt")))return false;
			var ftStr;
			ftStr=FileManager.readTxtFile(file.replace(".fnt",".fnt"));
			try {
				Utils$1.parseXMLFromString(ftStr);
				}catch (e){
				MessageManager.instance.show("FontFile not right:"+FileManager.adptToCommonUrl(file));
				return false;
			}
			return true;
		}

		FontLoader.Font="Font";
		return FontLoader;
	})(Loader)


	/**容器线框动画*/
	//class laya.editor.core.BoxEffect extends laya.display.Sprite
	var BoxEffect=(function(_super){
		function BoxEffect(){
			BoxEffect.__super.call(this);
		}

		__class(BoxEffect,'laya.editor.core.BoxEffect',_super);
		var __proto=BoxEffect.prototype;
		/**播放*/
		__proto.play=function(px,py,box,isBack){
			var _$this=this;
			(isBack===void 0)&& (isBack=false);
			var x=box.x;
			var y=box.y;
			var w=box.width;
			var h=box.height;
			var totalTimer=10;
			var currTimer=0;
			Laya.timer.frameLoop(1,null,onEnterFrame);
			function onEnterFrame (e){
				currTimer++;
				_$this.graphics.clear();
				var t=currTimer / totalTimer;
				if (isBack){
					_$this.graphics.drawRect(x+(px-x)*t,y+(py-y)*t,w *(1-t),h *(1-t),null,"#ff0000");
					}else {
					_$this.graphics.drawRect(px+(x-px)*t,py+(y-py)*t,w *t,h *t,null,"#ff0000");
				}
				if (currTimer >=totalTimer){
					Laya.timer.clear(null,onEnterFrame);
					_$this.remove();
				}
			}
		}

		__proto.remove=function(){
			if (this.parent){
				this.parent.removeChild(this);
			}
		}

		return BoxEffect;
	})(Sprite)


	//class laya.editor.core.DragBox extends laya.display.Sprite
	var DragBox=(function(_super){
		function DragBox(type){
			this._box=null;
			this._target=null;
			this._currDir=null;
			this._type=0;
			this._dragBlocks=null;
			this.fixScale=NaN;
			this._mouseTar=null;
			this.lineWidth=1;
			DragBox.__super.call(this);
			this._left=this.drawBlock();
			this._right=this.drawBlock();
			this._top=this.drawBlock();
			this._bottom=this.drawBlock();
			this._topLeft=this.drawBlock();
			this._topRight=this.drawBlock();
			this._bottomLeft=this.drawBlock();
			this._bottomRight=this.drawBlock();
			this._pivotPoint=this.drawCircle();
			this._lastPoint=new Point();
			this.moveOffPoint=new Point();
			this._type=type;
			this.addChild(this._box=this.drawBorder(0,0,0xff0000));
			if (type==1 || type==3){
				this.addChild(this._left);
				this.addChild(this._right);
			}
			if (type==2 || type==3){
				this.addChild(this._top);
				this.addChild(this._bottom);
			}
			if (type==3){
				this.addChild(this._topLeft);
				this.addChild(this._topRight);
				this.addChild(this._bottomLeft);
				this.addChild(this._bottomRight);
			}
			this._dragBlocks=[this._left,this._right,this._top,this._bottom,this._topLeft,this._topRight,this._bottomLeft,this._bottomRight,this._pivotPoint];
			if(type!=5)
				this.addChild(this._pivotPoint);
			this._left["cursor"]="w-resize";
			this._right["cursor"]="e-resize";
			this._top["cursor"]="n-resize";
			this._bottom["cursor"]="s-resize";
			this._topLeft["cursor"]="nw-resize";
			this._topRight["cursor"]="ne-resize";
			this._bottomLeft["cursor"]="sw-resize";
			this._bottomRight["cursor"]="se-resize";
			this._pivotPoint.on("dragmove",this,this.pivortDraging);
			this.on("mousedown",this,this.onMouseDown);
			this.mouseThrough=true;
			this.on("mouseover",this,this.onMouseOver);
			this.on("mouseout",this,this.onMouseOut);
		}

		__class(DragBox,'laya.editor.core.DragBox',_super);
		var __proto=DragBox.prototype;
		__proto.updateBlocks=function(){
			if(!UIPanel.instance.currViewer)return;
			var adptScale=NaN;
			adptScale=UIPanel.instance.currViewer.scaleView;
			if(adptScale<=0)adptScale=1;
			this.lineWidth=1/adptScale;
			var i=0,len=0;
			var tBlock;
			len=this._dragBlocks.length;
			for(i=0;i<len;i++){
				tBlock=this._dragBlocks[i];
				tBlock.scaleX=tBlock.scaleY=1/adptScale;
			}
		}

		__proto.onMouseOver=function(e){
			if(e.target["cursor"]){
				CursorManager.setType(e.target["cursor"]);
			}
		}

		__proto.onMouseOut=function(e){
			CursorManager.setType("default");
		}

		__proto._setUpMouseHihi=function(){
			if(!DragBox._mouseHiHi)DragBox._mouseHiHi=new Sprite();
			DragBox._mouseHiHi.width=0;
			DragBox._mouseHiHi.height=0;
			var i=0,len=0;
			var tKey;
			len=DragBox._copyValues.length;
			for(i=0;i<len;i++){
				tKey=DragBox._copyValues[i];
				DragBox._mouseHiHi[tKey]=this._target[tKey];
			}
			this._target.parent.addChild(DragBox._mouseHiHi);
		}

		__proto.onMouseDown=function(e){
			this._currDir=e.target;
			this._mouseTar=this._target.parent;
			this._mouseTar=this._target;
			this._setUpMouseHihi();
			this._mouseTar=DragBox._mouseHiHi;
			if(e.nativeEvent.shiftKey){
				this.initFixScale();
			}
			if (this._currDir !=this){
				this.updateLastPoint();
				if(this._currDir!=this._pivotPoint){
					Laya.stage.on("mousemove",this,this.onMouseMove);
					}else{
					this._currDir.startDrag();
				}
				Laya.stage.on("mouseup",this,this.onMouseUp);
				e.stopPropagation();
			}
		}

		__proto.updateLastPoint=function(){
			if(!this._mouseTar)return;
			this._lastPoint.x=this._mouseTar.mouseX;
			this._lastPoint.y=this._mouseTar.mouseY;
		}

		__proto.pivortDraging=function(){
			this._pivotPoint.pos(this.mouseX,this.mouseY);
		}

		__proto.onMouseUp=function(e){
			Laya.stage.off("mousemove",this,this.onMouseMove);
			Laya.stage.off("mouseup",this,this.onMouseUp);
			if(this._currDir==this._pivotPoint){
				this.onMouseMove(null);
				this._target.pivotX=Math.round(this._target.pivotX);
				this._target.pivotY=Math.round(this._target.pivotY);
				this._target.x=Math.round(this._target.x);
				this._target.y=Math.round(this._target.y);
			};
			var info=(this._target).comXml;
			this.fixScale=-1;
			info.props.x=this._target.x;
			info.props.y=this._target.y;
			info.props.width=this._target.width;
			info.props.height=this._target.height;
			if(!info.props.hasOwnProperty("anchorX")){
				info.props.pivotX=this._target.pivotX;
				if(info.props.pivotX==0){
					delete info.props.pivotX;
					}else{
					delete info.props.anchorX;
				}
			}
			if(!info.props.hasOwnProperty("anchorY")){
				info.props.pivotY=this._target.pivotY;
				if(info.props.pivotY==0){
					delete info.props.pivotY;
					}else{
					delete info.props.anchorY;
				}
			};
			var tParent;
			if(info.props.hasOwnProperty("centerY")){
				tParent=this._target.parent;
				info.props.centerY=this._target.y-(tParent.height-this._target.height*this._target.scaleY)*0.5-this._target.pivotY*this._target.scaleY;
				this._target["centerY"]=info.props.centerY;
				delete info.props.y;
			}
			if(info.props.hasOwnProperty("centerX")){
				tParent=this._target.parent;
				info.props.centerX=this._target.x-(tParent.width-this._target.width*this._target.scaleX)*0.5-this._target.pivotX*this._target.scaleX;
				this._target["centerX"]=info.props.centerX;
				delete info.props.x;
			}
			UIPanel.instance.currViewer.design.updateNodePosInfo(info.props,this._target);
			UIPanel.instance.currViewer.design.nodeChanged(info,["x","y","width","height"]);
			UIPanel.instance.currViewer.design.change(false);
			UIPanel.instance.currViewer.design.changeSelectComp();
		}

		__proto.initFixScale=function(){
			this.fixScale=this._target.height / this._target.width;
		}

		__proto.onMouseMove=function(e){
			var scale=UIPanel.instance.currViewer.scaleView;
			var tx=(this._mouseTar.mouseX-this._lastPoint.x);
			var ty=(this._mouseTar.mouseY-this._lastPoint.y);
			var tParent;
			var xScale=NaN;
			var yScale=NaN;
			tParent=this._target.parent;
			if(tParent){
				xScale=tParent.scaleX;
				yScale=tParent.scaleY;
				}else{
				xScale=1;
				yScale=1;
			}
			xScale=1;
			yScale=1;
			scale=1;
			var sameScale=false;
			var adptX=NaN;
			var adptY=NaN;
			if(e&&e.nativeEvent.shiftKey){
				if(this.fixScale<0)this.initFixScale();
				adptY=tx *this.fixScale;
				adptX=ty/this.fixScale;
				sameScale=true;
				switch(this._currDir){
					case this._topLeft:
					case this._bottomLeft:
						this._currDir=this._left;
						break ;
					case this._topRight:
					case this._bottomRight:
						this._currDir=this._right;
						break ;
					}
			}
			if (tx !=0 || ty !=0){
				this._lastPoint.x+=tx *scale;
				this._lastPoint.y+=ty *scale;
				var tw=tx / this._target.scaleX;
				var th=ty / this._target.scaleY;
				if (this._currDir==this._left){
					this._target.x+=tx;
					this._target.width-=tw;
					if (sameScale){
						this._target.height=this._target.width*this.fixScale;
					}
					}else if (this._currDir==this._right){
					this._target.width+=tw;
					if (sameScale){
						this._target.height=this._target.width*this.fixScale;
					}
					}else if (this._currDir==this._top){
					this._target.y+=ty;
					this._target.height-=th;
					if (sameScale){
						this._target.width=this._target.height/this.fixScale;
					}
					}else if (this._currDir==this._bottom){
					this._target.height+=th;
					if (sameScale){
						this._target.width=this._target.height/this.fixScale;
					}
					}else if (this._currDir==this._topLeft){
					this._target.x+=tx;
					this._target.y+=ty;
					this._target.width-=tw;
					this._target.height-=th;
					}else if (this._currDir==this._topRight){
					this._target.y+=ty;
					this._target.width+=tw;
					this._target.height-=th;
					}else if (this._currDir==this._bottomLeft){
					this._target.x+=tx;
					this._target.width-=tw;
					this._target.height+=th;
					}else if (this._currDir==this._bottomRight){
					this._target.width+=tw;
					this._target.height+=th;
					}else if(this._currDir==this._pivotPoint){
					var info=(this._target).comXml;
					delete info.props.anchorX;
					delete info.props.anchorY;
					(this._target).anchorX=NaN;
					(this._target).anchorY=NaN;
					this._target.pivotX+=tx;
					this._target.pivotY+=ty;
					this._target.x+=tx;
					this._target.y+=ty;
				}
				if (this._target.width < 1){
					this._target.width=1;
				}
				if (this._target.height < 1){
					this._target.height=1;
				}
				if ((this._target instanceof laya.display.Sprite )){}
					this._target.width=Math.round(this._target.width);
				this._target.x=Math.round(this._target.x);
				this._target.y=Math.round(this._target.y);
				this._target.height=Math.round(this._target.height);
				this.refresh();
				UIPanel.instance.currViewer.design.refreshStatusInfo();
			}
		}

		/**画矩形*/
		__proto.drawBorder=function(width,height,color,alpha){
			(alpha===void 0)&& (alpha=1);
			var box=new Sprite();
			var g=box.graphics;
			g.clear();
			g.drawRect(0,0,width,height,null,"#"+color);
			return box;
		}

		/**画矩形*/
		__proto.drawBlock=function(){
			var box=new Sprite();
			var g=box.graphics;
			g.clear();
			box.width=DragBox.BLOCK_WIDTH;
			box.height=DragBox.BLOCK_WIDTH;
			g.drawRect(-DragBox.BLOCK_WIDTH *0.5,-DragBox.BLOCK_WIDTH *0.5,DragBox.BLOCK_WIDTH,DragBox.BLOCK_WIDTH,"#ffffff","#ff0000",1);
			box.mouseEnabled=true;
			box.mouseThrough=true;
			return box;
		}

		__proto.drawCircle=function(){
			var box=new Sprite();
			var g=box.graphics;
			g.clear();
			var circleWidth=0;
			circleWidth=DragBox.BLOCK_WIDTH+2;
			box.width=circleWidth;
			box.height=circleWidth;
			g.drawCircle(circleWidth *0.5,circleWidth *0.5,circleWidth *0.5,"#ffffff","#ff0000",1);
			box.pivot(circleWidth *0.5,circleWidth *0.5);
			box.mouseEnabled=true;
			box.mouseThrough=true;
			return box;
		}

		/**设置对象*/
		__proto.setTarget=function(target){
			this._target=target;
			this.refresh();
			Laya.timer.frameOnce(2,this,this.refresh,null,true);
		}

		// Laya.timer.once(150,this,refresh,null,true);
		__proto.refresh=function(){
			this.changePoint();
			this.changeSize();
		}

		__proto.changePoint=function(){
			if(!this._target)return;
			if(!this.parent)return;
			var p=this._target.localToGlobal(new Point());
			var np=(this.parent).globalToLocal(p);
			this.x=np.x;
			this.y=np.y;
		}

		/**设置大小*/
		__proto.changeSize=function(){
			this.updateBlocks();
			var width=this._target.width *this._target.scaleX;
			var height=this._target.height *this._target.scaleY;
			this.rotation=this._target.rotation;
			this.skewX=this._target.skewX;
			this.skewY=this._target.skewY;
			var tParent;
			tParent=this._target.parent;
			if(tParent){
				width*=tParent.scaleX;
				height*=tParent.scaleY;
				this.rotation+=tParent.rotation;
				}else{
				this.scale(1,1);
			}
			this.updatePivot();
			this._pivotPoint.visible=!this._target["disablePivot"];
			if (this._box.width !=width || this._box.height !=height||1){
				this._box.graphics.clear();
				this._box.graphics.drawRect(0,0,Math.abs(width),Math.abs(height),null,"#ff0000",this.lineWidth);
				this._box.size(width,height);
				this.size(width,height);
				this._box.scaleX=Math.abs(this._box.scaleX)*(this._target.scaleX > 0 ? 1 :-1);
				this._box.scaleY=Math.abs(this._box.scaleY)*(this._target.scaleY > 0 ? 1 :-1);
				this._left.x=0;
				this._left.y=Math.round(height *0.5);
				this._right.x=width;
				this._right.y=Math.round(height *0.5);
				this._top.x=Math.round(width *0.5);
				this._top.y=0;
				this._bottom.x=Math.round(width *0.5);
				this._bottom.y=height;
				this._topLeft.x=this._topLeft.y=0;
				this._topRight.x=width;
				this._topRight.y=0;
				this._bottomLeft.x=0;
				this._bottomLeft.y=height;
				this._bottomRight.x=width;
				this._bottomRight.y=height;
			}
		}

		__proto.updatePivot=function(){
			if(!this._target)return;
			if(this._target.parent){
				var tP;
				tP=this._target.parent;
				this._pivotPoint.pos(this._target.pivotX*this._target.scaleX*tP.scaleX,this._target.pivotY*this._target.scaleY*tP.scaleY);
				}else{
				this._pivotPoint.pos(this._target.pivotX*this._target.scaleX,this._target.pivotY*this._target.scaleY);
			}
		}

		__getset(0,__proto,'type',function(){
			return this._type;
		});

		DragBox.BLOCK_WIDTH=6;
		DragBox._mouseHiHi=null
		__static(DragBox,
		['_copyValues',function(){return this._copyValues=["x","y","pivotX","pivotY","rotation","skewX","skewY"];}
		]);
		return DragBox;
	})(Sprite)


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2017-7-3 下午3:00:41
	*/
	//class laya.editor.core.reference.ReferenceLine extends laya.display.Sprite
	var ReferenceLine=(function(_super){
		function ReferenceLine(){
			this.isDraging=false;
			this.type=null;
			this.data=null;
			ReferenceLine.__super.call(this);
			this.mouseEnabled=true;
			this.hitTestPrior=false;
			this.on("mouseout",this,this.onMouseOut);
			this.on("mouseup",this,this.onMouseUp);
			this.on("mouseover",this,this.onMouseOver);
		}

		__class(ReferenceLine,'laya.editor.core.reference.ReferenceLine',_super);
		var __proto=ReferenceLine.prototype;
		__proto.onMouseOver=function(){
			var mType;
			mType=this.type==0?"e-resize":"n-resize";
			CursorManager.setType(mType);
		}

		__proto.onMouseUp=function(){
			this.isDraging=false;
		}

		__proto.onMouseOut=function(){
			if(!this.isDraging)
				CursorManager.setType("default");
		}

		__proto.recover=function(){
			this.removeSelf();
			this.graphics.clear();
			Pool.recover("ReferenceLine",this);
		}

		ReferenceLine.create=function(data){
			var rst;
			rst=Pool.getItemByClass("ReferenceLine",ReferenceLine);
			rst.data=data;
			rst.type=data.type;
			return rst;
		}

		return ReferenceLine;
	})(Sprite)


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2017-7-3 上午11:25:13
	*/
	//class laya.editor.core.reference.ReferenceLineLayer extends laya.display.Sprite
	var ReferenceLineLayer=(function(_super){
		function ReferenceLineLayer(){
			this.lineList=[];
			this.lineItems=[];
			this._ruleH=null;
			this._ruleV=null;
			this.renderWidth=0;
			this.renderHeight=0;
			ReferenceLineLayer.__super.call(this);
			this.lineColor=StyleConsts.AutoAlignLineColor;
			this.size(1,1);
			this.mouseEnabled=true;
		}

		__class(ReferenceLineLayer,'laya.editor.core.reference.ReferenceLineLayer',_super);
		var __proto=ReferenceLineLayer.prototype;
		__proto.getLocalReferencePoints=function(sprite,rst){
			if(!rst)rst=[];
			if(!this.lineList)return rst;
			var i=0,len=0;
			len=this.lineList.length;
			var tLineO;
			var tPoint;
			for(i=0;i<len;i++){
				tLineO=this.lineList[i];
				if(tLineO.type==0){
					if(!this._ruleH.isValueOK(tLineO.value)){
						continue ;
					}
					tPoint=this._ruleH.getPosByV(tLineO.value);
					tPoint=this._ruleH.localToGlobal(tPoint);
					sprite.globalToLocal(tPoint);
					rst.push(AlignTool.getAlignLine("x",tPoint.x));
					}else{
					if(!this._ruleV.isValueOK(tLineO.value)){
						continue ;
					}
					tPoint=this._ruleV.getPosByV(tLineO.value);
					tPoint=this._ruleV.localToGlobal(tPoint);
					sprite.globalToLocal(tPoint);
					rst.push(AlignTool.getAlignLine("y",tPoint.y));
				}
			}
			return rst;
		}

		__proto.recoverLines=function(){
			var i=0,len=0;
			len=this.lineItems.length;
			var tLine;
			for(i=0;i<len;i++){
				tLine=this.lineItems[i];
				tLine.recover();
			}
			this.lineItems.length=0;
		}

		__proto.renderMe=function(width,height){
			this.renderWidth=width;
			this.renderHeight=height;
			this.fresh();
		}

		__proto.clearMe=function(){
			this.recoverLines();
		}

		__proto.fresh=function(){
			this.recoverLines();
			if(!this.lineList){
				this.lineList=[];
				return;
			};
			var i=0,len=0;
			var tLineO;
			len=this.lineList.length;
			var tPoint;
			var tSprite;
			var tVisible=false;
			for(i=0;i<len;i++){
				tLineO=this.lineList[i];
				tVisible=true;
				if(tLineO.type==0){
					if(!this._ruleH.isValueOK(tLineO.value)){
						tVisible=false;
					}
					tSprite=this.getAReferenceLine(tLineO);
					tPoint=this._ruleH.getPosByV(tLineO.value);
					this._ruleH.toParentPoint(tPoint);
					this.fromParentPoint(tPoint);
					tSprite.graphics.drawLine(1,0,1,this.renderHeight,this.lineColor,1);
					tSprite.size(3,this.renderHeight);
					tSprite.pos(tPoint.x-1,tPoint.y);
					tSprite.visible=tVisible;
					this.addChild(tSprite);
					}else{
					if(!this._ruleV.isValueOK(tLineO.value)){
						tVisible=false;
					}
					tSprite=this.getAReferenceLine(tLineO);
					tPoint=this._ruleV.getPosByV(tLineO.value);
					this._ruleV.toParentPoint(tPoint);
					this.fromParentPoint(tPoint);
					tSprite.graphics.drawLine(0,1,this.renderWidth,1,this.lineColor);
					tSprite.size(this.renderWidth,3);
					tSprite.pos(tPoint.x,tPoint.y-1);
					tSprite.visible=tVisible;
					this.addChild(tSprite);
				}
			}
		}

		__proto.getAReferenceLine=function(data){
			var tSprite;
			tSprite=ReferenceLine.create(data);
			this.lineItems.push(tSprite);
			tSprite.off("mousedown",this,this.onDragStart);
			tSprite.on("mousedown",this,this.onDragStart,[tSprite]);
			tSprite.off("keydown",this,this.onKeyDown);
			tSprite.on("keydown",this,this.onKeyDown,[tSprite]);
			return tSprite;
		}

		__proto.onKeyDown=function(referenceLine,e){
			if(e.keyCode==46||e.keyCode==8){
				this.removeLineByID(referenceLine.data.id);
			}
		}

		__proto.onDragStart=function(referenceLine,e){
			if(!ReferenceLineLayer._dragRec)ReferenceLineLayer._dragRec=new Rectangle();
			Laya.stage.focus=referenceLine;
			e&&e.stopPropagation();
			if(referenceLine.type==0){
				ReferenceLineLayer._dragRec.setTo(0,referenceLine.y,this.renderWidth,0);
				}else{
				ReferenceLineLayer._dragRec.setTo(referenceLine.x,0,0,this.renderHeight);
			}
			referenceLine.on("dragend",this,this.onDragEnd,[referenceLine]);
			referenceLine.isDraging=true;
			referenceLine.startDrag(ReferenceLineLayer._dragRec);
		}

		__proto.onDragEnd=function(referenceLine){
			referenceLine.isDraging=false;
			ReferenceLineLayer._tempPos.setTo(referenceLine.x,referenceLine.y);
			var tRule;
			if(referenceLine.type==0){
				tRule=this._ruleH;
				}else{
				tRule=this._ruleV;
			}
			this.toParentPoint(ReferenceLineLayer._tempPos);
			tRule.fromParentPoint(ReferenceLineLayer._tempPos);
			referenceLine.data.value=tRule.getValueByPos(ReferenceLineLayer._tempPos);
			var tId=0;
			tId=referenceLine.data.id;
			this.event("Lines_Changed");
			this.fresh();
			var tLine;
			tLine=this.getLineByID(tId);
			if(tLine){
				Laya.stage.focus=tLine;
			}
		}

		__proto.createTestData=function(){
			this.lineList=[];
			this.addLine(0,100);
			this.addLine(1,200);
		}

		__proto.getMaxID=function(){
			var tMax=0;
			var i=0,len=0;
			len=this.lineList.length;
			var tLineO;
			for(i=0;i<len;i++){
				tLineO=this.lineList[i];
				if(tLineO.id>tMax){
					tMax=tLineO.id;
				}
			}
			return tMax;
		}

		__proto.addLine=function(type,value){
			var tLineO;
			tLineO={};
			tLineO.type=type;
			tLineO.value=value;
			tLineO.id=this.getMaxID()+1;
			this.lineList.push(tLineO);
			this.event("Lines_Changed");
			return tLineO;
		}

		__proto.addLineAndStartDrag=function(type,value){
			var lineO;
			lineO=this.addLine(type,value);
			this.fresh();
			var tLine;
			tLine=this.getLineByID(lineO.id);
			if(tLine){
				tLine.visible=true;
				this.onDragStart(tLine,null);
			}
		}

		__proto.getLineByID=function(id){
			var i=0,len=0;
			len=this.lineItems.length;
			for(i=0;i<len;i++){
				if(this.lineItems[i].data.id==id){
					return this.lineItems[i];
				}
			}
			return null;
		}

		__proto.removeLineByID=function(id){
			var i=0,len=0;
			len=this.lineList.length;
			for(i=0;i<len;i++){
				if(this.lineList[i].id==id){
					this.lineList.splice(i,1);
					this.event("Lines_Changed");
					this.fresh();
					return;
				}
			}
		}

		ReferenceLineLayer.Line_Width=1;
		ReferenceLineLayer.Hit_Width=3;
		ReferenceLineLayer.Off=1;
		ReferenceLineLayer.Lines_Changed="Lines_Changed";
		ReferenceLineLayer._dragRec=null
		__static(ReferenceLineLayer,
		['_tempTransPoint',function(){return this._tempTransPoint=new Point();},'_tempPos',function(){return this._tempPos=new Point();}
		]);
		return ReferenceLineLayer;
	})(Sprite)


	/**消息管理器
	*@author yung
	*/
	//class laya.editor.manager.MessageManager extends laya.display.Sprite
	var MessageManager=(function(_super){
		function MessageManager(){
			this.preTime=0;
			MessageManager.__super.call(this);
			this._vbox=new Box();
			this.addChild(this._vbox);
			this.setBounds(new Rectangle(0,0,150,150));
		}

		__class(MessageManager,'laya.editor.manager.MessageManager',_super);
		var __proto=MessageManager.prototype;
		__proto.show=function(msg,color,time){
			(color===void 0)&& (color="00cc00");
			(time===void 0)&& (time=1000);
			var label=new Label();
			label.color="#"+color;
			label.fontSize=14;
			label.text=msg;
			label.y=100;
			label.height=30;
			var delayTime=0;
			var nowTime=0;
			var startTime=0;
			nowTime=Browser.now();
			startTime=Math.max(this.preTime+500,nowTime);
			delayTime=startTime-nowTime;
			this.preTime=startTime;
			CanvasSprite.setSpriteCanvasRender(label,101,true);
			Laya.timer.once(delayTime,this,this.showLabel,[label,time],false);
		}

		__proto.showLabel=function(label,time){
			this._vbox.addChild(label);
			Tween.to(label,{y:-20},time,Ease.cubicOut,null);
			Laya.timer.once(time,this,this.clear,[label],false);
		}

		__proto.clear=function(label){
			label.removeSelf();
		}

		__getset(1,MessageManager,'instance',function(){
			return MessageManager._instance ? MessageManager._instance :MessageManager._instance=new MessageManager();
		},laya.display.Sprite._$SET_instance);

		MessageManager._instance=null
		return MessageManager;
	})(Sprite)


	/**
	*时间轴帧显示对象
	*@author ww
	*@version 1.0
	*
	*@created 2015-12-5 下午1:33:59
	*/
	//class laya.editor.view.timeline.TimeFrame extends laya.display.Sprite
	var TimeFrame=(function(_super){
		function TimeFrame(){
			this._isSelect=false;
			this._isFocus=false;
			this.data=null;
			this._boderColor="#cc00cc";
			this._label=null;
			this._frame=new Sprite();
			TimeFrame.__super.call(this);
			this._frame.mouseEnabled=true;
			this._frame.width=TimeGrid.frameWidth-0*2;
			this._frame.height=TimeGrid.frameHeight-0*2;
			this._frame.width=5;
			this._frame.pivotX=-Math.floor((TimeGrid.frameWidth-this._frame.width)*0.5)-0;
			this._frame.height=TimeGrid.frameHeight-8;
			this._frame.pivotY=-(TimeGrid.frameHeight-this._frame.height)*0.5+1;
			this._frame.x=0;
			this._frame.y=0;
			this._frame.name="timeFrame";
			this.mouseEnabled=true;
			this.size(1,1);
			this.addChild(this._frame);
			this.on("mouseover",this,this.mouseOver);
			this.on("mouseout",this,this.mouseOut);
		}

		__class(TimeFrame,'laya.editor.view.timeline.TimeFrame',_super);
		var __proto=TimeFrame.prototype;
		// }
		__proto.onDragDrop=function(e){
			console.log("frameDragDrop");
		}

		__proto.mouseOver=function(e){
			this._isFocus=true;
			this.update();
			DisControlTool.setTop(this);
			if(this._label){
				Laya.stage.event("showtip",this._label);
			}
		}

		__proto.mouseOut=function(e){
			this._isFocus=false;
			this.update();
			if(this._label){
				Laya.stage.event("hidetip",this._label);
			}
		}

		__proto.update=function(){
			this._frame.pivotX=Math.floor((this._frame.width)*0.5);
			if(!this.data)return;
			if(this.data.type!=2&&(this._isSelect||this._isFocus)){
				this._boderColor="#ccFFcc";
				}else{
				this._boderColor="#cc00cc";
			};
			var g;
			g=this._frame.graphics;
			g.clear();
			var color;
			color="#13b5b1";
			switch(this.data.type){
				case 2:
					color="#111111";
					break ;
				case 3:
					color="#ffffff";
					break ;
				default :
				}
			g.drawRect(0,0,this._frame.width,this._frame.height,color,this._boderColor,1);
			if(this.data.props&&this.data.props.label&&this.data.props.label!=""){
				this._label=this.data.props.label;
				g.drawRect(0,(this._frame.height-5)*0.5,this._frame.width,5,"#f8b551");
				}else{
				this._label=null;
			}
		}

		__proto.setData=function(data){
			this.data=data;
			if(TimeFrame.selecteData&&TimeFrame.selecteData==this.data.props){
				this.isSelect=true;
			}
			this.update();
		}

		__proto.recover=function(){
			if(this.data){
				Pool.recover("TimeFrameData",this.data);
			}
			this.data=null;
			this._isFocus=false;
			this._isSelect=false;
			Pool.recover("TimeFrame",this);
		}

		__getset(0,__proto,'isSelect',function(){
			return this._isSelect;
			},function(v){
			this._isSelect=v;
			if(v){
				TimeFrame.selecteData=this.data.props;
			}
			this.update();
		});

		TimeFrame.Focus_Frame=0;
		TimeFrame.Normal=1;
		TimeFrame.Holder=2;
		TimeFrame.Parent=3;
		TimeFrame.FrameTop=4;
		TimeFrame.selecteData=null
		TimeFrame.frameBorder=0;
		return TimeFrame;
	})(Sprite)


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-12-6 上午10:54:19
	*/
	//class laya.editor.view.timeline.TopFrame extends laya.display.Sprite
	var TopFrame=(function(_super){
		function TopFrame(){
			this.frame=0;
			TopFrame.__super.call(this);
			this.init();
		}

		__class(TopFrame,'laya.editor.view.timeline.TopFrame',_super);
		var __proto=TopFrame.prototype;
		__proto.init=function(){
			this.graphics.drawRect(0,0,3.5*2,3.5*2,"#f8b551");
			this.pivot(Math.floor(3.5),3.5);
			this.size(3.5*2,3.5*2);
		}

		TopFrame.FrameWidth=3.5;
		return TopFrame;
	})(Sprite)


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-8-4 上午9:24:35
	*/
	//class laya.rendercanvas.CanvasSpriteContainer extends laya.display.Sprite
	var CanvasSpriteContainer=(function(_super){
		function CanvasSpriteContainer(){
			this.canvasZIndex=100;
			this.autoTop=true;
			CanvasSpriteContainer.__super.call(this);
		}

		__class(CanvasSpriteContainer,'laya.rendercanvas.CanvasSpriteContainer',_super);
		var __proto=CanvasSpriteContainer.prototype;
		__proto.addChild=function(node){
			this.childAddHandler(node);
			return laya.display.Node.prototype.addChild.call(this,node);
		}

		__proto.addChildAt=function(node,index){
			this.childAddHandler(node);
			return laya.display.Node.prototype.addChildAt.call(this,node,index);
		}

		__proto.removeChild=function(node){
			this.removeChildHandler(node);
			return laya.display.Node.prototype.removeChild.call(this,node);
		}

		__proto.removeChildAt=function(index){
			var node=this.getChildAt(index);
			if (node){
				this.removeChildHandler(node);
			}
			return laya.display.Node.prototype.removeChildAt.call(this,index);
		}

		__proto.childAddHandler=function(node){
			if(this.autoTop){
				DisControlTool.setTop(this);
			}
			CanvasSprite.setSpriteCanvasRender(node,this.canvasZIndex,true);
		}

		__proto.removeChildHandler=function(node){
			CanvasSprite.removeSpriteCanvas(node);
		}

		return CanvasSpriteContainer;
	})(Sprite)


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-8-3 下午5:34:23
	*/
	//class laya.rendercanvas.DialogHook extends laya.display.Sprite
	var DialogHook=(function(_super){
		function DialogHook(){
			this._centerDialog=null;
			this._checkMask=null;
			this.popupEffect=null;
			DialogHook.__super.call(this);
			this.dialogLayer=new Sprite();
			this.modalLayer=new Sprite();
			this.maskLayer=new Sprite();
		}

		__class(DialogHook,'laya.rendercanvas.DialogHook',_super);
		var __proto=DialogHook.prototype;
		__proto.hookDialog=function(){
			Dialog.manager["open"]=this.open;
			Dialog.manager.closeEffect=null;
			Dialog.manager.popupEffect=null;
			Dialog.manager.closeEffectHandler=null;
			Dialog.manager.popupEffectHandler=null;
		}

		/**
		*显示对话框(非模式窗口类型)。
		*@param dialog 需要显示的对象框 <code>Dialog</code> 实例。
		*@param closeOther 是否关闭其它对话框，若值为ture，则关闭其它的对话框。
		*/
		__proto.open=function(dialog,closeOther){
			(closeOther===void 0)&& (closeOther=false);
			if (closeOther)this.removeChildren();
			CanvasSprite.setSpriteCanvasRender(dialog,101);
			DialogHook.tZorder++;
			dialog.zOrder=DialogHook.tZorder;
			if (dialog.popupCenter)this._centerDialog(dialog);
			this.addChild(dialog);
			if (dialog.isModal || this._$P["hasZorder"])this.timer.callLater(this,this._checkMask);
			this.popupEffect && this.popupEffect(dialog);
			this.event("open");
		}

		/**
		*关闭对话框。
		*@param dialog 需要关闭的对象框 <code>Dialog</code> 实例。
		*/
		__proto.close=function(dialog){
			try{
				dialog.removeSelf();
				if (this.modalLayer.numChildren < 2){
					this.maskLayer.removeSelf();
					}else {
					this.modalLayer.setChildIndex(this.maskLayer,this.modalLayer.numChildren-2);
				}
			}catch(e){}
			this.event("close");
		}

		/**
		*显示对话框(非模式窗口类型)。
		*@param dialog 需要显示的对象框 <code>Dialog</code> 实例。
		*@param closeOther 是否关闭其它对话框，若值为ture，则关闭其它的对话框。
		*/
		__proto.show=function(dialog,closeOther){
			(closeOther===void 0)&& (closeOther=false);
			CanvasSprite.setSpriteCanvasRender(dialog,101);
			if (closeOther)this.dialogLayer.removeChildren();
			if (dialog.popupCenter)this._centerDialog(dialog);
			this.dialogLayer.addChild(dialog);
			this.event("open");
		}

		/**
		*显示对话框(模式窗口类型)。
		*@param dialog 需要显示的对象框 <code>Dialog</code> 实例。
		*@param closeOther 是否关闭其它对话框，若值为ture，则关闭其它的对话框。
		*/
		__proto.popup=function(dialog,closeOther){
			(closeOther===void 0)&& (closeOther=false);
			CanvasSprite.setSpriteCanvasRender(dialog,101);
			if (closeOther)this.modalLayer.removeChildren();
			if (dialog.popupCenter)this._centerDialog(dialog);
			this.modalLayer.addChild(dialog);
			this.addChild(this.modalLayer);
			this.event("open");
		}

		DialogHook.tZorder=1;
		__static(DialogHook,
		['I',function(){return this.I=new DialogHook();}
		]);
		return DialogHook;
	})(Sprite)


	//class LayaBuilder extends laya.display.Sprite
	var LayaBuilder=(function(_super){
		function LayaBuilder(){
			this._builderConfig=null;
			this._projectPath=null;
			this._isInitCompleted=false;
			ViewHook;
			KeyBoardHook.hook();
			if (!Laya.stage)Laya.init(1000,800);
			LayaBuilder.__super.call(this);
			UIConfig.popupBgAlpha=0.1;
			UIConfig.closeDialogOnSide=false;
			DialogHook.I.hookDialog();
			IDEVars.cacheBothTreeAndAnimation=true;
			var enableNewAnimation=false;
			enableNewAnimation=true;
			if(enableNewAnimation){
				TypeManager.GraphicPic="GraphicNode";
				IDEVars.enableNewAnimation=true;
			}
			CanvasSprite.parentNode=Browser.container;
			var canvasLayer;
			canvasLayer=new CanvasSpriteContainer();
			canvasLayer.canvasZIndex=102;
			canvasLayer.mouseEnabled=true;
			canvasLayer.hitTestPrior=false;
			canvasLayer.size(1,1);
			canvasLayer.autoTop=true;
			Laya._currentStage=canvasLayer;
			Laya.stage.addChild(canvasLayer);
			StageHook.hookStage();
			View.regComponent("TreeEx",TreeEx);
			View.regComponent("TextInput",EditorTextInput);
			View.regComponent("Tab",TabEx);
			View.regComponent("List",ListBase);
			View.regComponent("Tree",TreeBase);
			TypeManager.init();
			ExportManager.init();
			HookedView.hookView();
			MouseHook.hook();
			var noNew=false;
			if(noNew){
				LayoutRecManager.ctOffSetX=0;
				UIViewer.EnableXMLEditor=false;
				BasicPanel.EnableBasicPanel=false;
				DisplayTreePanel.AnyItemContains=false;
			}
			LayaBuilder.initConfig();
			Skeleton;
			HTMLDivElement;
			MovieClip;
			Particle2D;
			Animation;
			Text;
			SoundNode;
			EffectAnimation;
			IDEAPIS;
			BinaryPicTools.init();
			LayerManager.init();
			Laya.stage.bgColor=null;
			Laya.stage.scaleMode="full";
			Font.defaultFamily="Arial";
			LayaBuilder.drag=new DragManager();
			LayaBuilder.tip=new TipManager();
			this.initBasics();
			this.loadConfig();
			HookedView.initByStyleFile(IDESkinManager.getStylePath());
			this.mouseEnabled=true;
			Slider.label.color="#dddddd";
			LayerManager.stage.addChild(this);
			var pLoads=new PreLoads();
			pLoads.handler=new Handler(this,this.start);
			pLoads.loadRes();
			LoaderHook.init();
			Notice.listen("IDE_QUIT",this,this.onNativeWindowClosing);
			Browser.window.onbeforeunload=this.beforeClose;
			Laya.stage.frameRate="slow";
			Laya.stage.on("blur",this,this.onBlur);
			Laya.stage.on("focus",this,this.onFocus);
			CanvasViewsManager.I.init();
			SysLog.logGlobalError=true;
			this.hookTab();
		}

		__class(LayaBuilder,'LayaBuilder',_super);
		var __proto=LayaBuilder.prototype;
		__proto.hookTab=function(){
			Browser.document.onkeydown=function HandleTabKey (evt){
				if (evt.keyCode==9){
					if (evt.preventDefault){evt.preventDefault();}
						else {evt.returnValue=false;}
				}
			}
		}

		__proto.onFocus=function(){
			SetIDE.updateToSettings();
		}

		// Laya.stage.frameRate=Stage.FRAME_SLOW;
		__proto.onBlur=function(){
			Laya.stage.frameRate="sleep";
		}

		__proto.beforeClose=function(e){
			LayaBuilder.noticeQuite();
			return;
			SaveUnSavedDialog.I.event=e;
			LayoutRecManager.saveLayoutInfo();
			if (UIPanel.instance.hasChange){
				UIPanel.instance.closeAll(LayaBuilder.tryClose);
				e.returnValue=false;
				}else {
				LayaBuilder.noticeQuite();
			}
		}

		__proto.onStageResize=function(e){
			Laya.timer.once(100,this,this.adpts);
		}

		__proto.adpts=function(){
			this.adptRenderFrame();
		}

		__proto.adptRenderFrame=function(){
			ViewRenderManager.adpt();
			DragBarManager.adpt();
			CodeViewManager.adpt();
		}

		__proto.start=function(){
			this.initApp();
			this.initBuilder();
			this.onStageResize();
			Laya.stage.on("resize",this,this.onStageResize);
		}

		//uiTestHere();
		__proto.uiTestHere=function(){
			Laya.stage.addChild(DisplayTreePanel.instance);
			DisplayTreePanel.instance.x=300;
			DisplayTreePanel.instance.y=200;
		}

		__proto.initBasics=function(){
			Device.init();
			CMDShell.init();
			FileTools.init();
			FontLoader.init();
			console.log("location:",Browser.window.location);
			console.log("appPath:",FileTools.appPath);
			SystemSetting.appPath=FileTools.appPath;
			SystemSetting.tempPath=FileManager.getAppPath("data");
		}

		__proto.initApp=function(){
			ViewRenderManager.init();
			SceneManager.init();
			ContextMenu.init();
			NoticeRouter.init();
			DragBarManager.init();
			DialogTools.init();
			IPCTools.init();
			IPCTools.send("hello",{o:"oo"});
			SystemDragOverManager.init();
			TemplateManager.init();
			CodeTplManager.initCodeTpls();
			LayoutRecManager.init();
			CursorManager.init();
			DisResizer.init();
			KeyManager.I.init();
			HtmlZIndexManager.init();
			Laya.timer.once(1200,this,this.openFirstPage);
		}

		__proto.openFirstPage=function(){
			PluginManager.I.loadPlugins();
			return;
			var codePath;
			codePath="E:/wangwei/codes/laya/libs/LayaAir/plugins/debugtool/src/laya/debug/view/nodeInfo/views/FindSmallView.as";
			As3ParserTool.parserAsFile(codePath);
			return;
			var iFrame;
			iFrame=new IFrameSprite();
			iFrame.setUrl("E:/wangwei/codes/layanew/libs/LayaAir/publish/LayaAirPublish/ide/resources/app/out/vs/layaEditor/h5/initPlugin/ace/index.html");
			LayoutRecManager.showPanelToStage(iFrame);
			console.log("iframe:",iFrame);
			return;
			var panel;
			panel=JSPlugin.loadPlugin("testplugin");
			LayoutRecManager.showPanelToStage(panel);
			return;
		}

		// Notice.notify(IDEEvent.OPENPAGE,[new NewsPage(),"欢迎页"]);
		__proto.onNativeWindowClosing=function(e){
			this._builderConfig.lang=SystemSetting.lang;
			this._builderConfig.lastProject=SystemSetting.projectPath;
			this._builderConfig.ifShowRuleGrid=SystemSetting.ifShowRuleGrid;
			this._builderConfig.toCodeModeWhenPublicEnd=SystemSetting.toCodeModeWhenPublicEnd;
			this._builderConfig.autoFocsEditRect=SystemSetting.autoFocsEditRect;
			this._builderConfig.IDEFrameType=SystemSetting.IDEFrameType;
			IDESettingResTypeManager.saveConfig();
			this._builderConfig["skinPath"]=IDESkinManager.tSkinPath;
			this._builderConfig["langPath"]=IDELangManager.tLang;
			if (!SystemSetting.projectPath){
				debugger;
			}
			this._builderConfig.lastProjects=[];
			for (var i=0;i < ProjectManager.projectOpened.length && i < 5;i++){
				this._builderConfig.lastProjects.push(ProjectManager.projectOpened[i]);
			}
			FileManager.createTxtFile(FileManager.getDataPath("builder.xml"),ObjectTools$1.getJsonString(this._builderConfig));
			LayoutRecManager.saveLayoutInfo();
		}

		/**全局错误捕捉 */
		__proto.onUncaughtError=function(e){}
		/**处理项目文件被打开*/
		__proto.onInvoke=function(e){
			if (e.arguments.length > 0){
				if (e.arguments.length > 1 && e.arguments[0]=="publish"){
					this._projectPath=e.arguments[1];
					}else {
					var file=new File(e.arguments[0]);
					if (file.extension.toLowerCase()=="laya"){
						this._projectPath=file.nativePath;
					}
				}
				if (this._isInitCompleted){
					ProjectManager.loadProject(this._projectPath);
				}
			}
		}

		__proto.loadConfig=function(){
			try{
				var str=FileManager.readTxtFile(FileManager.getDataPath("builder.xml"));
				if (str){
					this._builderConfig=JSON.parse(str);
				}
				}catch(e){
				this._builderConfig=null;
			}
			if(!this._builderConfig)this._builderConfig={layaout:'',projects:[]};
			this._projectPath=this._builderConfig.lastProject;
			SystemSetting.ifShowRuleGrid=this._builderConfig.ifShowRuleGrid;
			SystemSetting.toCodeModeWhenPublicEnd=this._builderConfig.toCodeModeWhenPublicEnd?true:false;
			SystemSetting.autoFocsEditRect=this._builderConfig.autoFocsEditRect?true:false;
			SystemSetting.IDEFrameType=this._builderConfig.IDEFrameType?1:0;
			HelpTipView.isFirst=!this._builderConfig.openedBefore;
			this._builderConfig.openedBefore=true;
			IDESkinManager.setSkinPath(this._builderConfig["skinPath"]);
			if(Browser.window["laya_available_languages"]){
				var tLangStr;
				tLangStr=Browser.window["laya_available_languages"];
				if(tLangStr=="en"){
					IDELangManager.setLangPath("english.json");
					}else{
					IDELangManager.setLangPath(null);
				}
				}else{
				IDELangManager.setLangPath(this._builderConfig["langPath"]);
			}
			SetIDE.updateToSettings();
			IDESettingResTypeManager.loadConfig();
		}

		//getSysArg();
		__proto.getSysArg=function(){
			IPCTools.setWindow();
			var path;
			path=Browser.window.openPath;
		}

		__proto.initBuilder=function(){
			var iconPath=FileManager.getAppPath("laya/icons/components");
			this.loadComplete();
		}

		__proto.loadComplete=function(loader){
			MessageManager.instance.x=240;
			MessageManager.instance.y=140;
			LayerManager.stage.addChild(MessageManager.instance);
			ShortcutManager.init();
			this.regSystemShortcuts();
			this._isInitCompleted=true;
			CanvasSprite.inits();
			ProjectManager.setProjectOpened(this._builderConfig.lastProjects);
		}

		__proto.closeLoginPanel=function(){
			this.visible=true;
		}

		__proto.regSystemShortcuts=function(){
			ShortcutManager.addKeyE(78,true,false,"OPEN_ADDPage",null,null,"",AddDocument.instance);
			ShortcutManager.addKey(80,true,false,SetPage.instance.start,null,null,"",SetPage.instance);
			ShortcutManager.addKeyE(68,true,false,"open_adddir",null,null,"",AddDirectory.instance);
			ShortcutManager.addKeyE(76,true,false,"CLIP_VIEW",null,null,"");
			ShortcutManager.addKey(87,true,false,UIPanel.instance.closeCurrPage,null,null,"",UIPanel.instance);
			ShortcutManager.addKey(83,true,false,UIPanel.instance.save,null,null,"",UIPanel.instance);
			ShortcutManager.addKey(83,true,true,UIPanel.instance.saveAll,null,null,"",UIPanel.instance);
			ShortcutManager.addKey(70,true,false,FindAndReplace.instance.start,null,null,"",FindAndReplace.instance);
			ShortcutManager.addKey(67,true,false,UIPanel.instance.copy,null,Design,null,UIPanel.instance);
			ShortcutManager.addKey(86,true,false,UIPanel.instance.pasteComp,[false],Design,null,UIPanel.instance);
			ShortcutManager.addKey(86,true,true,UIPanel.instance.pasteComp,[true],Design,null,UIPanel.instance);
			ShortcutManager.addKey(88,true,false,UIPanel.instance.cut,null,Design,null,UIPanel.instance);
			ShortcutManager.addKey(66,true,false,BoxComp.instance.start,null,Design,"",BoxComp.instance);
			ShortcutManager.addKey(84,true,false,ChangeCompType.instance.start,null,Design,"",ChangeCompType.instance);
			ShortcutManager.addKey(85,true,false,UIPanel.instance.unBoxComp,null,Design,null,UIPanel.instance);
			ShortcutManager.addKey(82,true,false,RepeatComp.instance.start,null,Design,"",RepeatComp.instance);
			ShortcutManager.addKey(65,true,false,UIPanel.instance.selectAll,null,Design,null,UIPanel.instance);
			ShortcutManager.addKey(46,false,false,UIPanel.instance.deleteSelect,null,Design,null,UIPanel.instance);
			ShortcutManager.addKey(8,false,false,UIPanel.instance.deleteSelect,null,Design,null,UIPanel.instance);
			ShortcutManager.addKey(90,true,false,UIPanel.instance.goBack,null,Design,"",UIPanel.instance);
			ShortcutManager.addKey(89,true,false,UIPanel.instance.goForward,null,Design,"",UIPanel.instance);
			ShortcutManager.addKey(187,true,false,UIPanel.instance.setScale,[0.1],UIPanel,null,UIPanel.instance);
			ShortcutManager.addKey(189,true,false,UIPanel.instance.setScale,[-0.1],UIPanel,null,UIPanel.instance);
			ShortcutManager.addKey(107,true,false,UIPanel.instance.setScale,[0.1],UIPanel,null,UIPanel.instance);
			ShortcutManager.addKey(109,true,false,UIPanel.instance.setScale,[-0.1],UIPanel,null,UIPanel.instance);
			ShortcutManager.addKey(220,true,false,UIPanel.instance.resizeScale,[1],UIPanel,null,UIPanel.instance);
			ShortcutManager.addKey(48,true,false,UIPanel.instance.resizeScale,[1],UIPanel,null,UIPanel.instance);
			ShortcutManager.addKey(96,true,false,UIPanel.instance.resizeScale,[1],UIPanel,null,UIPanel.instance);
			ShortcutManager.addKey(13,true,false,UIPanel.instance.preview);
			ShortcutManager.addKeyE(117,false,false,"FRESH_Page");
			ShortcutManager.addKeyE(118,false,false,"FRESH_RES");
			ShortcutManager.addKey(116,false,false,this.refreshResAndPage,null,null,null,this);
			ShortcutManager.addKey(119,false,false,UIPanel.instance.toggleBg,null,null,"",UIPanel.instance);
			ShortcutManager.addKey(82,true,true,UIPanel.instance.switchRuleGrid,null,null,"",UIPanel.instance);
			ShortcutManager.addKey(120,false,false,SetProject.instance.start,null,null,"",SetProject.instance);
			ShortcutManager.addKey(114,false,false,LayoutRecManager.createDefault,null,null,"",LayoutRecManager);
			ShortcutManager.addKey(115,false,false,FindUnUsedRes.instance.start,null,null,"",FindUnUsedRes.instance);
			ShortcutManager.addKey(123,false,false,ExportManager.export,null,null,"",ExportManager);
			ShortcutManager.addKey(123,true,false,ExportManager.forceExport,null,null,"",ExportManager);
			ShortcutManager.addKey(122,false,false,ExportManager.exportCodeOnly,null,null,"",ExportManager);
		}

		__proto.refreshResAndPage=function(){
			PagePanel.instance.refresh();
			Notice.notify("FRESH_RES");
		}

		__proto.showLoginPanel=function(){}
		LayaBuilder.mParseInt=function(v){
			return LayaBuilder._preParseInt(v)|| 0;
		}

		LayaBuilder.mParserFloat=function(v){
			return parseFloat(v)||0;
		}

		LayaBuilder.initConfig=function(){
			UIConfig.touchScrollEnable=false;
			UIConfig.showButtons=false;
			Styles.labelColor="#c5c5c5";
			Styles.buttonLabelColors=["#dddddd","#ffffff","#efefef"];
			Styles.comboBoxItemColors=["#0c6fa6","#e0e7ef","#d2d2d2","#484647","#2f2f2f"];
		}

		LayaBuilder.tryClose=function(){}
		LayaBuilder.noticeQuite=function(){
			Notice.notify("IDE_QUIT");
		}

		LayaBuilder.closeAllLog=function(){
			var logFun;
			logFun=LayaBuilder.emptyLog;
			Browser.window.console.log=logFun;
		}

		LayaBuilder.emptyLog=function(){}
		LayaBuilder.drag=null
		LayaBuilder.tip=null
		__static(LayaBuilder,
		['_preParseInt',function(){return this._preParseInt=parseInt;}
		]);
		return LayaBuilder;
	})(Sprite)


	/**
	*...
	*@author ww
	*/
	//class laya.editor.comonents.ColorPickerItem extends laya.ui.Component
	var ColorPickerItem=(function(_super){
		function ColorPickerItem(){
			this.text=null;
			this.tColorStr="";
			this.recWidth=20;
			ColorPickerItem.__super.call(this);
			this.mouseEnabled=true;
			this.inits();
		}

		__class(ColorPickerItem,'laya.editor.comonents.ColorPickerItem',_super);
		var __proto=ColorPickerItem.prototype;
		__proto.inits=function(){
			this.text=new EditorTextInput();
			this.text.skin="comp/input_22.png";
			this.text.sizeGrid="0,4,0,4";
			this.addChild(this.text);
			this.text.height=22;
			ColorPickerItem._picker=ColorPickerItem._picker||new ColorPickerPanel();
			this.on("click",this,this.onClick);
			this.on("resize",this,this.freshMe);
			this.text.on("enter",this,this.textChange);
			this.text.on("blur",this,this.textChange);
			this.text.text="";
		}

		__proto.textChange=function(){
			if(this.text.text==""){
				this.colorCleared();
				return;
			}
			if(this.text.text==this.getColorStr())return;
			this.tColorStr=this.text.text;
			this.freshMe();
			this.event("ColorChanged",this);
		}

		__proto.colorChanged=function(){
			this.tColorStr=ColorPickerItem._picker.colorTxt.text;
			this.freshMe();
			this.event("ColorChanged",this);
		}

		__proto.colorCleared=function(){
			this.tColorStr="";
			this.freshMe();
			this.text.text="";
			this.event("COLOR_CLEARED",this);
			this.close();
		}

		__proto.onClick=function(){
			this.open();
		}

		/**
		*打开颜色样本列表面板。
		*/
		__proto.open=function(){
			if(ColorPickerItem._picker.prePickerItem){
				ColorPickerItem._picker.prePickerItem.close();
			}
			if (ColorPickerItem.showed){
				this.close();
				return;
			}
			ColorPickerItem._picker.prePickerItem=this;
			ColorPickerItem.showed=true;
			var p=this.localToGlobal(new Point());
			var px=p.x+ColorPickerItem._picker.width <=Laya.stage.width ? p.x :Laya.stage.width-ColorPickerItem._picker.width;
			var py=p.y+this.height;
			py=py+ColorPickerItem._picker.height <=Laya.stage.height ? py :p.y-ColorPickerItem._picker.height;
			ColorPickerItem._picker.setColor(ColorTool.getRGBByRGBStr(this.tColorStr));
			ColorPickerItem._picker.pos(px,py);
			ColorPickerItem._picker.on("ColorChanged",this,this.colorChanged);
			ColorPickerItem._picker.on("COLOR_CLEARED",this,this.colorCleared);
			Laya.stage.addChild(ColorPickerItem._picker);
			Laya.timer.once(10,this,this.addEvent);
		}

		__proto.addEvent=function(){
			Laya.stage.off("click",this,this.removeColorBox);
			Laya.stage.on("click",this,this.removeColorBox);
		}

		/**
		*关闭颜色样本列表面板。
		*/
		__proto.close=function(){
			Laya.stage.off("click",this,this.removeColorBox);
			ColorPickerItem._picker.removeSelf();
			ColorPickerItem._picker.off("ColorChanged",this,this.colorChanged);
			ColorPickerItem._picker.off("COLOR_CLEARED",this,this.colorCleared);
			ColorPickerItem.showed=false;
		}

		/**
		*舞台的 <code>Event.MOUSE_DOWN</code> 事件侦听处理函数。
		*/
		__proto.removeColorBox=function(e){
			if (DisControlTool.isInTree(ColorPickerItem._picker,e.target))return;
			this.close();
		}

		// public var tColor:Array;
		__proto.getColorStr=function(){
			if(!this.tColorStr||this.tColorStr==""){
				return "";
				return "#000000";
			}
			return this.tColorStr;
		}

		// return ColorTool.getRGBStr(tColor);
		__proto.setColor=function(color){
			if (this.tColorStr !=color){
				this.tColorStr=color;
				this.freshMe();
			}
		}

		__proto.freshMe=function(){
			var g;
			g=this.graphics;
			g.clear();
			this.text.width=this.width-this.recWidth;
			g.drawRect(this.width-this.recWidth,0,this.recWidth,this.height+2,this.getColorStr());
			this.text.text=this.getColorStr();
		}

		__proto.changeSize=function(){
			_super.prototype.changeSize.call(this);
			this.freshMe();
		}

		ColorPickerItem.showed=false;
		ColorPickerItem._picker=null
		return ColorPickerItem;
	})(Component)


	/**
	*独立的Canvas模式
	*/
	//class laya.editor.comonents.CanvasView extends laya.display.Stage
	var CanvasView=(function(_super){
		function CanvasView(width,height,awakeInterval,sleepInterval){
			this.canvas=null;
			this.sleepInterval=500;
			this.awakeInterval=33;
			this.awakeDuration=2000;
			this._context=null;
			this._mouseManager=null;
			this._awakeTime=0;
			this._isOver=false;
			this._oldStage=null;
			CanvasView.__super.call(this);
			var _$this=this;
			(awakeInterval===void 0)&& (awakeInterval=33);
			(sleepInterval===void 0)&& (sleepInterval=500);
			this.designWidth=this.width=width;
			this.designHeight=this.height=height;
			this.awakeInterval=awakeInterval;
			this.sleepInterval=sleepInterval;
			this.canvas=HTMLCanvas.create('2D');
			this._context=new RenderContext(width,height,this.canvas);
			this._mouseManager=new MouseManager();
			this._mouseManager.__init__(this,this.canvas.source);
			var _this=this;
			_this.awake();
			this._isOver=false;
			this.canvas.source.addEventListener('mouseover',function(e){
				if (!_$this._isOver){
					_this._isOver=true;
					_this.awake();
					_this._oldStage=Laya.stage;
				}
			});
			this.canvas.source.addEventListener('mouseout',function(e){
				if (_$this._isOver){
					_this._awakeTime=Laya.timer.currTimer;
					_this._isOver=false;
				}
			});
		}

		__class(CanvasView,'laya.editor.comonents.CanvasView',_super);
		var __proto=CanvasView.prototype;
		/**
		*唤醒
		*@param duration 唤醒后，没有鼠标活动后，持续多少时间后自动休眠，0为不休眠
		*/
		__proto.awake=function(duration){
			(duration===void 0)&& (duration=2000);
			this.awakeDuration=duration || Number.MAX_VALUE;
			this._awakeTime=Laya.timer.currTimer;
			this._loop();
			Laya.timer.frameLoop(Math.round(60 / Math.min(1000 / this.awakeInterval,60)),this,this._loop);
		}

		/**
		*休眠
		*/
		__proto.sleep=function(){
			Laya.timer.loop(this.sleepInterval,this,this._loop);
		}

		__proto._loop=function(){
			if (!this._isOver && (Laya.timer.currTimer-this._awakeTime)> this.awakeDuration){
				this.sleep();
			}
			this.render(this._context,0,0);
			return true;
		}

		__proto.render=function(context,x,y){
			if (this.renderingEnabled){
				this._mouseManager.runEvent();
				context.clear();
				RenderSprite.renders[this._renderType]._fun(this,context,x+this._x,y+this._y);
				this._repaint=0;
			}
		}

		/**
		*浮动到某个位置
		*@param left x左边
		*@param top y坐标
		*/
		__proto.float=function(left,top){
			var style=this.canvas.source.style;
			style.position='absolute';
			style.left=left+"px";
			style.top=top+"px";
			this._canvasTransform.identity();
			this._canvasTransform.translate(left,top);
		}

		__proto.setScreenSize=function(screenWidth,screenHeight){
			this.renderingEnabled=true;
			this._canvasTransform.identity();
			this._canvasTransform.translate(this.canvas.source.offsetLeft,this.canvas.source.offsetTop);
		}

		__getset(0,__proto,'mouseX',function(){
			return Math.round(this._mouseManager.mouseX / this.clientScaleX);
		});

		__getset(0,__proto,'mouseY',function(){
			return Math.round(this._mouseManager.mouseY / this.clientScaleY);
		});

		return CanvasView;
	})(Stage)


	/**拖动条
	*@author yung
	*/
	//class laya.editor.comonents.DragBar extends laya.ui.Component
	var DragBar=(function(_super){
		function DragBar(mouseType){
			this._map={"R":"WE","L":"WE","T":"NS","B":"NS","BL":"NESW","BR":"NWSE"};
			this._cursorType=null;
			this.isDraging=false;
			DragBar.__super.call(this);
			this._bitmap=new Image();
			(mouseType===void 0)&& (mouseType="R");
			switch(mouseType){
				case "R":
					this._cursorType="e-resize";
					break ;
				case "T":
					this._cursorType="n-resize";
					break ;
				default :
				this._cursorType="default";
				}
			this.on("mouseover",this,this.onRollOver);
			this.on("mouseout",this,this.onRollOut);
			this.mouseEnabled=true;
			Laya.stage.on("mouseout",this,this.onRollOut);
			this.on("dragstart",this,this.dragingBegin);
			this.on("dragend",this,this.dragingEnd);
		}

		__class(DragBar,'laya.editor.comonents.DragBar',_super);
		var __proto=DragBar.prototype;
		__proto.dragingBegin=function(e){
			this.isDraging=true;
		}

		__proto.dragingEnd=function(e){
			this.isDraging=false;
			CursorManager.setType("default");
		}

		__proto.onStageMouseLeave=function(e){
			this.onRollOut();
		}

		__proto.onRollOut=function(e){
			if (this.isDraging)return;
			CursorManager.setType("default");
		}

		__proto.onRollOver=function(e){
			CursorManager.setType(this._cursorType);
		}

		__getset(0,__proto,'cusorType',function(){
			return this._cursorType;
		});

		return DragBar;
	})(Component)


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-5-31 下午5:26:05
	*/
	//class laya.editor.comonents.SizeGridPanel extends laya.ui.Component
	var SizeGridPanel=(function(_super){
		function SizeGridPanel(){
			this.dLen=100;
			this.LineWidth=1;
			this.dragWidth=21;
			this.lineColor="#ff0000";
			this.tComp=null;
			this.compContainer=null;
			this.maskSp=null;
			this.topLine=null;
			this.rightLine=null;
			this.downLine=null;
			this.leftLine=null;
			this.tSizeGridStr="0,0,0,0";
			this.hasFill=false;
			this.lineDragArea=new Rectangle();
			this.tarRec=new Rectangle();
			SizeGridPanel.__super.call(this);
			this.size(180,180);
			this.compContainer=new Sprite();
			this.topLine=new Sprite();
			this.rightLine=new Sprite();
			this.downLine=new Sprite();
			this.leftLine=new Sprite();
			this.addLineEvents(this.topLine)
			this.addLineEvents(this.rightLine)
			this.addLineEvents(this.downLine)
			this.addLineEvents(this.leftLine)
			this.compContainer.on("rightmousedown",this,this.onRightDown);
			this.compContainer.on("rightmouseup",this,this.onRightUp);
			this.compContainer.pos(20,20);
			this.addChild(this.compContainer);
			this.on("resize",this,this.resizeFun);
			this.resizeFun();
		}

		__class(SizeGridPanel,'laya.editor.comonents.SizeGridPanel',_super);
		var __proto=SizeGridPanel.prototype;
		__proto.addLineEvents=function(line){
			line.on("mousedown",this,this.lineDown);
			line.on("dragend",this,this.lineDragEnd);
		}

		__proto.lineDown=function(e){
			var tar;
			tar=e.target;
			var dragArea;
			dragArea=this.lineDragArea;
			switch(tar){
				case this.topLine:
				case this.downLine:
					dragArea.setTo(tar.x,-200,0,1000);
					break ;
				case this.rightLine:
				case this.leftLine:
					dragArea.setTo(-200,tar.y,1000,0);
					break ;
				}
			tar.startDrag(dragArea);
		}

		__proto.lineDragEnd=function(e){
			this.updateSizeGridStr();
		}

		__proto.updateSizeGridStr=function(){
			var poss;
			poss=[];
			poss.push(Math.ceil(this.topLine.y-this.tarRec.y));
			poss.push(Math.ceil(this.tarRec.right-this.rightLine.x));
			poss.push(Math.ceil(this.tarRec.bottom-this.downLine.y));
			poss.push(Math.ceil(this.leftLine.x-this.tarRec.x));
			if(this.hasFill)poss.push(1);
			this.tSizeGridStr=poss.join(",");
			this.setSizeGridStr(this.tSizeGridStr);
			this.event("change",this.tSizeGridStr);
		}

		__proto.onRightDown=function(){
			this.compContainer.startDrag();
		}

		__proto.onRightUp=function(){
			this.compContainer.stopDrag();
		}

		__proto.resizeFun=function(){
			this.scrollRect=new Rectangle(0,0,this.width,this.height);
		}

		__proto.setUpView=function(path,type){
			if(type=="TextInput"){
				type="Image";
			}
			if(this.tComp)this.tComp.removeSelf();
			var classObj=Utils.getClass(UIConfigManager.getCompProp(type,"className"));
			this.tComp=new classObj();
			this.tComp.mouseEnabled=true;
			this.tComp[UIConfigManager.getCompSkinLabel(type)]=path;
			this.compContainer.addChild(this.tComp);
			Laya.timer.once(200,this,this.updateLines);
		}

		__proto.updateLines=function(){
			var rec;
			rec=this.tComp.getBounds();
			this.tarRec.copyFrom(rec);
			this.compContainer.x=(this.width-this.tarRec.width)*0.5;
			this.compContainer.y=(this.height-this.tarRec.height)*0.5;
			this.tComp.size(this.tarRec.width,this.tarRec.height);
			var dWidth=0;
			dWidth=(this.dragWidth-this.LineWidth)/2;
			this.topLine.graphics.clear();
			this.topLine.graphics.drawLine(0,dWidth,rec.width+2*this.dLen,dWidth,this.lineColor,this.LineWidth);
			this.topLine.x=-this.dLen;
			this.topLine.y=this.tarRec.y;
			this.topLine.pivot(0,dWidth);
			this.topLine.size(rec.width+2*this.dLen,this.dragWidth);
			this.compContainer.addChild(this.topLine);
			this.downLine.graphics.clear();
			this.downLine.graphics.drawLine(0,dWidth,rec.width+2*this.dLen,dWidth,this.lineColor,this.LineWidth);
			this.downLine.x=-this.dLen;
			this.downLine.y=this.tarRec.bottom;
			this.downLine.pivot(0,dWidth);
			this.downLine.size(rec.width+2*this.dLen,this.dragWidth);
			this.compContainer.addChild(this.downLine);
			this.leftLine.graphics.clear();
			this.leftLine.graphics.drawLine(dWidth,0,dWidth,rec.height+2*this.dLen,this.lineColor,this.LineWidth);
			this.leftLine.x=this.tarRec.x;
			this.leftLine.y=-this.dLen;
			this.leftLine.pivot(dWidth,0);
			this.leftLine.size(this.dragWidth,this.tarRec.height+2*this.dLen);
			this.compContainer.addChild(this.leftLine);
			this.rightLine.graphics.clear();
			this.rightLine.graphics.drawLine(dWidth,0,dWidth,rec.height+2*this.dLen,this.lineColor,this.LineWidth);
			this.rightLine.x=this.tarRec.right;
			this.rightLine.y=-this.dLen;
			this.rightLine.pivot(dWidth,0);
			this.rightLine.size(this.dragWidth,this.tarRec.height+2*this.dLen);
			this.compContainer.addChild(this.rightLine);
			this.updateLinePos();
		}

		__proto.updateLinePos=function(){
			var poss;
			poss=this.tSizeGridStr.split(",");
			this.adptStrToNum(poss);
			this.topLine.y=this.tarRec.y+poss[0];
			this.rightLine.x=this.tarRec.right-poss[1];
			this.downLine.y=this.tarRec.bottom-poss[2];
			this.leftLine.x=this.tarRec.x+poss[3];
			this.hasFill=poss[4]?true:false;
		}

		__proto.adptStrToNum=function(arr){
			var i=0,len=0;
			len=arr.length;
			for(i=0;i<len;i++){
				arr[i]=LayaBuilder.mParseInt(arr[i]);
			}
		}

		__proto.setSizeGridStr=function(sizeGridStr){
			this.tSizeGridStr=sizeGridStr;
			this.updateLinePos();
		}

		return SizeGridPanel;
	})(Component)


	/**鼠标提示管理类*/
	//class laya.editor.core.managers.TipManager extends laya.ui.Component
	var TipManager=(function(_super){
		function TipManager(){
			this._tipBox=null;
			this._tipText=null;
			this._defaultTipHandler=null;
			this.lastTip=null;
			this.hasTipToShow=false;
			TipManager.__super.call(this);
			this._tipBox=new Component();
			this._tipBox.addChild(this._tipText=new TextField());
			this._tipText.x=this._tipText.y=5;
			this._tipText.color="#ffffff";
			this._tipText.leading=3;
			this._tipText.width=200;
			this._tipText.wordWrap=true;
			this._defaultTipHandler=this.showDefaultTip;
			Laya.stage.on("showtip",this,this.onStageShowTip);
			Laya.stage.on("hidetip",this,this.onStageHideTip);
		}

		__class(TipManager,'laya.editor.core.managers.TipManager',_super);
		var __proto=TipManager.prototype;
		__proto.onStageHideTip=function(data){
			if(data==this.lastTip){
				this.hasTipToShow=false;
				Laya.timer.clear(this,this.showTip);
			}
			if(this.hasTipToShow)return
				this.closeAll();
			this.removeSelf();
		}

		__proto.onStageShowTip=function(data){
			this.lastTip=data;
			this.hasTipToShow=true;
			Laya.timer.once(LayaConfig.tipDelay,this,this.showTip,[data],true);
		}

		__proto.showTip=function(tip){
			this.hasTipToShow=false;
			if ((typeof tip=='string')){
				var text=String(tip);
				if (Boolean(text)){
					this._defaultTipHandler(text);
				}
				}else if ((tip instanceof laya.utils.Handler )){
				(tip).run();
				}else if ((typeof tip=='function')){
				(tip).apply();
			}
			if (LayaConfig.tipFollowMove){
				Laya.stage.on("mousemove",this,this.onStageMouseMove);
				Laya.stage.on("mousedown",this,this.onStageMouseDown);
			}
			this.onStageMouseMove(null);
		}

		__proto.onStageMouseDown=function(e){
			this.closeAll();
		}

		__proto.onStageMouseMove=function(e){
			DisTools.showToStage(this,TipManager.offsetX,TipManager.offsetY);
		}

		/**关闭所有鼠标提示*/
		__proto.closeAll=function(){
			Laya.timer.clear(this,this.showTip);
			Laya.stage.off("mousemove",this,this.onStageMouseMove);
			Laya.stage.off("mousedown",this,this.onStageMouseDown);
			this.removeChildren();
			HtmlLayerManager.closeTip();
		}

		__proto.showDisTip=function(tip){
			this.setBounds(null);
			this.addChild(tip);
			DisControlTool.showToStage(this);
			Laya._currentStage.addChild(this);
			HtmlLayerManager.openTip();
		}

		__proto.showDefaultTip=function(text){
			this._tipText.text=text;
			var g=this._tipBox.graphics;
			g.clear();
			g.drawRect(0,0,this._tipText.width+10,this._tipText.height+10,"#111111");
			this.addChild(this._tipBox);
			this.setBounds(TipManager._mRec.setTo(0,0,this._tipText.width+10,this._tipText.height+10));
			DisTools.showToStage(this);
			Laya._currentStage.addChild(this);
			HtmlLayerManager.openTip();
		}

		/**默认鼠标提示函数*/
		__getset(0,__proto,'defaultTipHandler',function(){
			return this._defaultTipHandler;
			},function(value){
			this._defaultTipHandler=value;
		});

		TipManager.offsetX=10;
		TipManager.offsetY=15;
		__static(TipManager,
		['_mRec',function(){return this._mRec=new Rectangle();}
		]);
		return TipManager;
	})(Component)


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-1-11 下午3:02:05
	*/
	//class laya.editor.core.RuleGrid extends laya.ui.Component
	var RuleGrid=(function(_super){
		function RuleGrid(){
			this.type=0;
			this._rate=NaN;
			this._startNum=NaN;
			this._endNum=NaN;
			RuleGrid.__super.call(this);
			this.cacheAsBitmap=true;
			this.mouseEnabled=true;
			this.on("mousedown",this,this.onMouseDown);
		}

		__class(RuleGrid,'laya.editor.core.RuleGrid',_super);
		var __proto=RuleGrid.prototype;
		__proto.clearMe=function(){
			var g;
			g=this.graphics;
			g.clear();
		}

		__proto.onMouseDown=function(e){
			e.stopPropagation();
			this.event("Add_ReferenceLine");
		}

		__proto.getMouseValue=function(){
			return this.getValueByPos(RuleGrid._tempPos.setTo(this.mouseX,this.mouseY));
		}

		__proto.renderMe=function(totalLen,startNum,endNum){
			var numLen=NaN;
			numLen=endNum-startNum;
			var g;
			g=this.graphics;
			g.clear();
			var rate=NaN;
			rate=totalLen/numLen;
			var tNum=NaN;
			var dNum=NaN;
			dNum=this.getMinDlen(rate);
			tNum=Math.ceil(startNum/dNum)*dNum;
			var numI=NaN;
			numI=tNum/dNum;
			var tValue=NaN;
			var lineWidth=1;
			var isFirst=true;
			this._rate=rate;
			this._startNum=startNum;
			this._endNum=endNum;
			if(this.type==0){
				this.size(totalLen,25);
				for(tNum=tNum;tNum<endNum;tNum+=dNum){
					tValue=Math.ceil((tNum-startNum)*rate+0.5);
					if(numI%10==0){
						lineWidth=3;
						if(isFirst){
							isFirst=false;
							}else{
							g.fillText(tNum+"",tValue,12,RuleGrid.defaultFont,StyleConsts.RuleGridTextColor,"center");
						}
					}else
					if(numI%5==0){
						lineWidth=2;
						if(isFirst){
							isFirst=false;
						}
						}else{
						lineWidth=1;
					}
					g.drawLine(tValue,0-0.5,tValue,lineWidth*4+0.5,StyleConsts.RuleGridLineColor,1);
					numI++;
				}
				}else{
				this.size(30,totalLen);
				for(tNum=tNum;tNum<endNum;tNum+=dNum){
					tValue=Math.ceil((tNum-startNum)*rate+0.5);
					if(numI%10==0){
						lineWidth=3;
						if(isFirst){
							isFirst=false;
							}else{
							g.fillText(tNum+"",15+0.5,tValue-5,RuleGrid.defaultFont,StyleConsts.RuleGridTextColor,"left");
						}
					}else
					if(numI%5==0){
						lineWidth=2;
						if(isFirst){
							isFirst=false;
						}
						}else{
						lineWidth=1;
					}
					g.drawLine(0-0.5,tValue,lineWidth*4+0.5,tValue,StyleConsts.RuleGridLineColor,1);
					numI++;
				}
			}
		}

		__proto.getPosByV=function(value){
			if(!RuleGrid._tempPos)RuleGrid._tempPos=new Point();
			var tValue=NaN;
			tValue=Math.ceil((value-this._startNum)*this._rate+0.5);
			if(this.type==0){
				RuleGrid._tempPos.setTo(tValue,-0.5);
				}else{
				RuleGrid._tempPos.setTo(-0.5,tValue);
			}
			return RuleGrid._tempPos;
		}

		__proto.getValueByPos=function(pos){
			var tPosV=NaN;
			if(this.type==0){
				tPosV=pos.x;
				}else{
				tPosV=pos.y;
			}
			return Math.round((tPosV)/this._rate+this._startNum);
		}

		__proto.isValueOK=function(value){
			return value>=this._startNum&&value<=this._endNum;
		}

		__proto.fillTextH=function(g,tNum,tValue){
			g.fillText(tNum+"",tValue,10,RuleGrid.defaultFont,"#00ffff",null);
		}

		__proto.fillTextV=function(g,tNum,tValue){
			g.fillText(tNum+"",10,tValue,RuleGrid.defaultFont,"#00ffff",null);
		}

		__proto.drawLineH=function(g,tValue,lineWidth){
			g.drawLine(tValue,0,tValue,lineWidth*3,"#ff0000",lineWidth);
		}

		__proto.drawLineV=function(g,tValue,lineWidth){
			g.drawLine(0,tValue,lineWidth*3,tValue,"#ff0000",lineWidth);
		}

		__proto.getMinDlen=function(rate){
			var i=0;
			i=1;
			while(i*rate<5){
				i++;
			}
			return i;
		}

		RuleGrid.Vertic=1;
		RuleGrid.Horizon=0;
		RuleGrid.Add_ReferenceLine="Add_ReferenceLine";
		RuleGrid.LineColor="#696969";
		RuleGrid.TextColor="#696969";
		RuleGrid.defaultFont="10px Arial";
		RuleGrid.drawLineWidth=1;
		__static(RuleGrid,
		['_tempPos',function(){return this._tempPos=new Point();}
		]);
		return RuleGrid;
	})(Component)


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-10-19 上午11:59:05
	*/
	//class wraps.binarypic.BinaryBitmap extends laya.resource.FileBitmap
	var BinaryBitmap=(function(_super){
		function BinaryBitmap(){
			BinaryBitmap.__super.call(this);
			this._source=new Browser.window.Image();
		}

		__class(BinaryBitmap,'wraps.binarypic.BinaryBitmap',_super);
		var __proto=BinaryBitmap.prototype;
		__proto.setBinaryData=function(data,url){
			var _$this=this;
			var me;
			this._source.onload=function (){
				Laya.timer.frameOnce(2,me,_$this.myOnLoaded);
				_$this._source.onload=null;
			}
			this._source.src=url+"?V="+Math.random();
			var info;
			info=ImageInfo.imageInfo(data);
			this._w=info.width;
			this._h=info.height;
		}

		__proto.myOnLoaded=function(){
			Notice.notify("FRESH_CurView");
		}

		return BinaryBitmap;
	})(FileBitmap)


	/**
	*...
	*@author ww
	*/
	//class laya.editor.comonents.LayoutDragBar extends laya.editor.comonents.DragBar
	var LayoutDragBar=(function(_super){
		function LayoutDragBar(mouseType){
			this.type=0;
			this.mId=0;
			this.walked=false;
			this._updaters=[];
			this.relativeO={};
			this.sortByXFun=MathUtil.sortByKey("x",false,true);
			this.sortByYFun=MathUtil.sortByKey("y",false,true);
			(mouseType===void 0)&& (mouseType="R");
			LayoutDragBar.__super.call(this,mouseType);
			this.mId=LayoutDragBar.ID;
			LayoutDragBar.ID++;
			CanvasSprite.setSpriteRenderEmpty(this);
		}

		__class(LayoutDragBar,'laya.editor.comonents.LayoutDragBar',_super);
		var __proto=LayoutDragBar.prototype;
		/**
		*获取可拖动范围
		*@return
		*
		*/
		__proto.getDragArea=function(){
			var area;
			area=new Rectangle();
			var borderVar=NaN;
			switch (this.type){
				case 0:
					area.y=this.y;
					area.height=0;
					area.x=this.getBorderVar("right","left",0,false)+165;
					borderVar=this.x+this.getBorderVar("left","width",999,true);
					borderVar-=165;
					if (borderVar < this.x)
						borderVar=this.x;
					area.width=borderVar-area.x;
					break ;
				case 1:
					area.y=this.getBorderVar("down","top",0,false)+165;
					borderVar=this.y+this.getBorderVar("up","height",999,true);
					borderVar-=165;
					if (borderVar < this.y)
						borderVar=this.y;
					area.height=borderVar-area.y;
					area.x=this.x;
					area.width=0;
					break ;
				}
			return area;
		}

		__proto.changeSize=function(){
			laya.ui.Component.prototype.changeSize.call(this);
			var g=this.graphics;
			g.clear();
			this.updates();
		}

		__proto.updates=function(){
			var i=0,len=0;
			len=this._updaters.length;
			for (i=0;i < len;i++){
				this._updaters[i].update();
			}
		}

		__proto.getBorderVar=function(type,sign,sValue,isMin){
			(isMin===void 0)&& (isMin=true);
			var i=0,len=0;
			var uList=this._updaters;
			len=uList.length;
			var tValue=NaN;
			tValue=sValue;
			var tUpdater;
			var tFun;
			tFun=RelativePos.typeToFunO[type];
			if (isMin){
				for (i=0;i < len;i++){
					tUpdater=uList[i];
					if (tUpdater._fun==tFun){
						if (tUpdater.tar[sign] < tValue){
							tValue=tUpdater.tar[sign];
						}
					}
				}
			}
			else{
				for (i=0;i < len;i++){
					tUpdater=uList[i];
					if (tUpdater._fun==tFun){
						if (tUpdater.tar[sign] > tValue){
							tValue=tUpdater.tar[sign];
						}
					}
				}
			}
			return tValue;
		}

		__proto.clear=function(){
			this._updaters.length=0;
		}

		/**
		*
		*@param tar
		*
		*/
		__proto.mergeUpdates=function(tar){
			if (!tar)
				return;
			var i=0,len=0;
			var tarUpdaters;
			tarUpdaters=tar._updaters;
			tarUpdaters=ObjectTools$1.setValueArr([],tarUpdaters);
			len=tarUpdaters.length;
			var tR;
			var tType;
			for (i=0;i < len;i++){
				tR=tarUpdaters[i];
				tType=RelativePos.getTypeByFun(tR._fun);
				if(tR.tar==this||tR.to==this)continue ;
				RelativePos.addRelative(tR.tar,this,tType,tR.d);
			}
			this.updates();
		}

		__proto.copyUpdates=function(tar,side){
			var i=0,len=0;
			var tarUpdaters;
			tarUpdaters=tar._updaters;
			tarUpdaters=ObjectTools$1.setValueArr([],tarUpdaters);
			len=tarUpdaters.length;
			var tR;
			var tType;
			for (i=0;i < len;i++){
				tR=tarUpdaters[i];
				tType=RelativePos.getTypeByFun(tR._fun);
				if(tR.tar==this||tR.to==this)continue ;
				if(side==tType){
					RelativePos.addRelative(tR.tar,this,tType,tR.d);
				}
			}
			this.updates();
		}

		/**
		*
		*@param tar
		*
		*/
		__proto.removeTarget=function(tar){
			var i=0,len=0;
			len=this._updaters.length;
			for (i=len-1;i >=0;i--){
				if (this._updaters[i].tar==tar){
					this._updaters.splice(i,1);
				}
			}
		}

		__proto.findTarType=function(tar){
			var i=0,len=0;
			len=this._updaters.length;
			var tR;
			for (i=0;i < len;i++){
				tR=this._updaters[i];
				if (tR.tar==tar){
					return tR._fun;
				}
			}
			return null;
		}

		__proto.canMove=function(dirType,len){
			if (!LayoutDragBar.canMoveO){
				LayoutDragBar.canMoveO={};
				var tO;
				tO={};
				tO["left"]=true;
				tO["right"]=true;
				LayoutDragBar.canMoveO[0]=tO;
				tO={};
				tO["up"]=true;
				tO["down"]=true;
				LayoutDragBar.canMoveO[1]=tO;
			}
			if (!LayoutDragBar.canMoveO[this.type][dirType])return false;
			return false;
		}

		/**
		*对象所在的方向是否只有它一个对象
		*@param tar
		*@return
		*
		*/
		__proto.isOnly=function(tar){
			if (this.type==2)
				return false;
			var i=0,len=0;
			len=this._updaters.length;
			var fun=this.findTarType(tar);
			if (fun==null)
				return false;
			var tR;
			for (i=0;i < len;i++){
				tR=this._updaters[i];
				if ((tR._fun==fun)&& (tR.tar !=tar)){
					return false;
				}
				if (tR.tar !=tar){
					if ((tR.tar instanceof laya.editor.view.LayoutRec )){
						if ((tR.tar).disMode==1){
							return false;
						}
					}
				}
			}
			return true;
		}

		__proto.getSideType=function(){
			if(this._updaters.length>0){
				return RelativePos.getTypeByFun(this._updaters[0]._fun);
			}
			return null;
		}

		__proto.addItem=function(tar,fun,d){
			(d===void 0)&& (d=0);
			var updater;
			updater=new RelativePos(fun,tar,this,0);
			this._updaters.push(updater);
		}

		__proto.clears=function(){
			this.clear();
			this.destroy(false);
		}

		__proto.getTarsByType=function(type){
			var i=0,len=0;
			len=this._updaters.length;
			var tR;
			var tFun;
			tFun=tFun=RelativePos.typeToFunO[type];
			var rst;
			rst=[];
			for (i=0;i < len;i++){
				tR=this._updaters[i];
				if (tR._fun==tFun){
					rst.push(tR.tar);
				}
			}
			return rst;
		}

		__proto.getDragBarInfo=function(type){
			var rsts;
			rsts=[];
			var i=0,len=0;
			len=this._updaters.length;
			var tR;
			var dragBarList;
			dragBarList=[];
			var tDragBar;
			for (i=len-1;i >=0;i--){
				tR=this._updaters[i];
				if((tR.tar instanceof laya.editor.view.LayoutRec )){
					if(type&&type==RelativePos.getTypeByFun(tR._fun))
						rsts.push((tR.tar).tTabTxt);
				}
			}
			return "id:"+this.mId+"_"+rsts.join(",");
		}

		/**
		*调整垂直方向的拖动条
		*@param dis
		*@return
		*
		*/
		__proto.tryMoveRight=function(dis){
			if(this.walked)return false;
			this.walked=true;
			var i=0,len=0;
			len=this._updaters.length;
			var tR;
			var dragBarList;
			dragBarList=[];
			var tDragBar;
			for (i=len-1;i >=0;i--){
				tR=this._updaters[i];
				if((tR.tar instanceof laya.editor.comonents.LayoutDragBar )){
					tDragBar=tR.tar;
					if(tDragBar.cusorType=="e-resize"&&RelativePos.getTypeByFun(tR._fun)=="up"){
						dragBarList.push(tDragBar);
					}
				}
			}
			if(dragBarList.length<2){
				return false;
			}
			dragBarList.sort(this.sortByXFun);
			var tWidth=NaN;
			tWidth=0;
			var maxWidth=NaN;
			maxWidth=0;
			var tSelecteDragBar;
			len=dragBarList.length;
			for(i=1;i<len;i++){
				tWidth=dragBarList[i].x-dragBarList[i-1].x;
				if(tWidth>maxWidth){
					maxWidth=tWidth;
					tSelecteDragBar=dragBarList[i];
				}
			}
			if(tSelecteDragBar){
				tSelecteDragBar.moveRightWork(dis);
			}
			return true;
		}

		/**
		*调整水平方向的拖动条
		*@param dis
		*
		*/
		__proto.moveRightWork=function(dis){
			if(this.walked)return;
			this.walked=true;
			var i=0,len=0;
			len=this._updaters.length;
			var tR;
			var dragBarList;
			dragBarList=[];
			var tDragBar;
			for (i=len-1;i >=0;i--){
				tR=this._updaters[i];
				if((tR.tar instanceof laya.editor.comonents.LayoutDragBar )){
					tDragBar=tR.tar;
					if(tDragBar.cusorType=="n-resize"&&RelativePos.getTypeByFun(tR._fun)=="right"){
						dragBarList.push(tDragBar);
					}
				}
			};
			var tSelecteDragBar;
			dragBarList.sort(this.sortByYFun);
			len=dragBarList.length;
			for(i=0;i<len;i++){
				tSelecteDragBar=dragBarList[i];
				tSelecteDragBar.tryMoveRight(dis);
			}
			this.left+=dis;
		}

		/**
		*调整垂直方向的拖动条
		*@param dis
		*@return
		*
		*/
		__proto.tryMoveDown=function(dis){
			var i=0,len=0;
			len=this._updaters.length;
			var tR;
			var dragBarList;
			dragBarList=[];
			var tDragBar;
			for (i=len-1;i >=0;i--){
				tR=this._updaters[i];
				if((tR.tar instanceof laya.editor.comonents.LayoutDragBar )){
					tDragBar=tR.tar;
					if(tDragBar.cusorType=="n-resize"){
						dragBarList.push(tDragBar);
					}
				}
			}
			if(dragBarList.length<2){
				return false;
			}
			dragBarList.sort(this.sortByYFun);
			var tWidth=NaN;
			tWidth=0;
			var maxWidth=NaN;
			maxWidth=0;
			var tSelecteDragBar;
			len=dragBarList.length;
			for(i=1;i<len;i++){
				tWidth=dragBarList[i].y-dragBarList[i-1].y;
				if(tWidth>maxWidth){
					maxWidth=tWidth;
					tSelecteDragBar=dragBarList[i];
				}
			}
			if(tSelecteDragBar){
				tSelecteDragBar.moveDownWork(dis);
			}
			return true;
		}

		/**
		*调整水平方向的拖动条
		*@param dis
		*
		*/
		__proto.moveDownWork=function(dis){
			if(this.walked)return;
			this.walked=true;
			var i=0,len=0;
			len=this._updaters.length;
			var tR;
			var dragBarList;
			dragBarList=[];
			var tDragBar;
			for (i=len-1;i >=0;i--){
				tR=this._updaters[i];
				if((tR.tar instanceof laya.editor.comonents.LayoutDragBar )){
					tDragBar=tR.tar;
					if(tDragBar.cusorType=="e-resize"&&RelativePos.getTypeByFun(tR._fun)=="down"){
						if(!tDragBar.walked)
							dragBarList.push(tDragBar);
					}
				}
			};
			var tSelecteDragBar;
			dragBarList.sort(this.sortByXFun);
			len=dragBarList.length;
			for(i=0;i<len;i++){
				tSelecteDragBar=dragBarList[i];
				tSelecteDragBar.tryMoveDown(dis);
			}
			this.top+=dis;
		}

		LayoutDragBar.hasFreeTar=function(items){
			var i=0,len=0;
			len=items.length;
			var tRec;
			for (i=0;i < len;i++){
				tRec=items[i];
				if ((tRec instanceof laya.editor.view.LayoutRec )){
					if(tRec.sizeFree){
						return true;
					}
				}
			}
			return false;
		}

		LayoutDragBar.ID=1;
		LayoutDragBar.debugMode=true;
		LayoutDragBar.minWidth=165;
		LayoutDragBar.canMoveO=null;
		return LayoutDragBar;
	})(DragBar)


	//class laya.editor.core.UIBox extends laya.ui.Box
	var UIBox=(function(_super){
		function UIBox(){
			this.stateInit={};
			UIBox.__super.call(this);
			this.recordState();
		}

		__class(UIBox,'laya.editor.core.UIBox',_super);
		var __proto=UIBox.prototype;
		__proto.recordState=function(){
			var i=0,len=0;
			var key;
			len=UIBox.stateKeys.length;
			for(i=0;i<len;i++){
				key=UIBox.stateKeys[i];
				this.stateInit[key]=this[key];
			}
		}

		__proto.resetState=function(){
			var i=0,len=0;
			var key;
			len=UIBox.stateKeys.length;
			for(i=0;i<len;i++){
				key=UIBox.stateKeys[i];
				this[key]=this.stateInit[key];
			}
		}

		__static(UIBox,
		['stateKeys',function(){return this.stateKeys=["x","y","scaleX","scaleY"];}
		]);
		return UIBox;
	})(Box)


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-10-24 下午2:58:37
	*/
	//class laya.editor.core.Wraps.ContextMenu extends laya.ui.Box
	var ContextMenu=(function(_super){
		function ContextMenu(){
			this.nativeMenu=null;
			this._tY=0;
			ContextMenu.__super.call(this);
		}

		__class(ContextMenu,'laya.editor.core.Wraps.ContextMenu',_super);
		var __proto=ContextMenu.prototype;
		__proto.addItem=function(item){
			this.addChild(item);
			item.y=this._tY;
			this._tY+=item.height;
			item.on("mousedown",this,this.onClick);
		}

		__proto.onClick=function(e){
			this.event("select",e);
			this.removeSelf();
		}

		__proto.show=function(posX,posY){
			(posX===void 0)&& (posX=-999);
			(posY===void 0)&& (posY=-999);
			Laya.timer.once(50,this,this.nativeMenu.popup,[Laya.stage.mouseX,Laya.stage.mouseY]);
		}

		ContextMenu.init=function(){
			Laya.stage.on("click",null,ContextMenu.cleanMenu);
		}

		ContextMenu.cleanMenu=function(e){
			var i=0;
			var len=0;
			len=ContextMenu._menuList.length;
			for (i=0;i < len;i++){
				if (ContextMenu._menuList[i]){
					ContextMenu._menuList[i].removeSelf();
				}
			}
			ContextMenu._menuList.length=0;
			HtmlLayerManager.closeMenu();
		}

		ContextMenu.showMenu=function(menu,posX,posY){
			(posX===void 0)&& (posX=-999);
			(posY===void 0)&& (posY=-999);
			ContextMenu.cleanMenu();
			ContextMenu.adptMenu(menu);
			Laya._currentStage.addChild(menu);
			DisTools.showToStage(menu);
			if (posX !=-999 && posY !=-999){
				menu.pos(posX,posY);
			}
			ContextMenu._menuList.push(menu);
			HtmlLayerManager.openMenu();
		}

		ContextMenu.createMenu=function(__args){
			var args=arguments;
			return ContextMenu.createMenuByArray2(args);
		}

		ContextMenu.createMenuByArray=function(args){
			var menu=new ContextMenu();
			var separatorBefore=false;
			var item;
			for (var i=0,n=args.length;i < n;i++){
				var obj=args[i];
				var info={};
				if ((typeof obj=='string')){
					info.label=obj;
					}else {
					info=obj;
				}
				if (info.label !=""){
					item=new ContextMenuItem(Sys.lang(info.label),separatorBefore);
					item.data=obj;
					menu.addItem(item);
					separatorBefore=false;
					}else {
					item=new ContextMenuItem("",separatorBefore);
					item.data=obj;
					menu.addItem(item);
					separatorBefore=true;
				}
			}
			return menu;
		}

		ContextMenu.getContextMenuLang=function(str){
			var langStr;
			langStr=Sys.lang(str);
			if(langStr!=str){
				ContextMenu.revertLangDic[langStr]=str;
			}
			return langStr;
		}

		ContextMenu.revertMenuLang=function(str){
			if(ContextMenu.revertLangDic[str])return ContextMenu.revertLangDic[str];
			return str;
		}

		ContextMenu.createMenuByArray2=function(args){
			var cmenu=new ContextMenu();
			var template=[];
			var tMenuStr;
			var tMenuO;
			for (var j=0,n=args.length;j < n;j++){
				var item=args[j];
				if (item==""){
					template.push({type:"separator"});
					}else if ((item instanceof Array)){
					var arr=item;
					var last=template[template.length-1];
					for (var k=0;k < arr.length;k++){
						tMenuStr=arr[k];
						if (arr[k]==""){
							arr[k]={type:"separator"};
							}else {
							tMenuO=arr[k]={label:ContextMenu.getContextMenuLang(arr[k]),click:click,preLabel:arr[k]};
							if(ContextMenu.shortDic[tMenuStr]){
								tMenuO["accelerator"]=ContextMenu.shortDic[tMenuStr];
							}
						}
					}
					last.submenu=arr;
					}else {
					tMenuStr=item;
					tMenuO={label:ContextMenu.getContextMenuLang(item),click:click,preLabel:item};
					template.push(tMenuO);
					if(ContextMenu.shortDic[tMenuStr]){
						tMenuO["accelerator"]=ContextMenu.shortDic[tMenuStr];
					}
				}
			}
			function click (item,focusedWindow){
				cmenu.event("select",item.preLabel);
			}
			if (SystemSetting.isCMDVer)return null;
			var menu;
			const remote=require("electron").remote;;
			const Menu=remote.Menu;;
			const MenuItem=remote.MenuItem;
			menu=Menu.buildFromTemplate(template);
			cmenu.nativeMenu=menu;
			return cmenu;
		}

		ContextMenu.adptMenu=function(menu){
			var tWidth=80;
			var maxWidth=80;
			var i=0,len=menu.numChildren;
			for (i=0;i < len;i++){
				tWidth=(menu.getChildAt(i)).width;
				if (maxWidth < tWidth){
					maxWidth=tWidth;
				}
			}
			for (i=0;i < len;i++){
				(menu.getChildAt(i)).width=maxWidth;
			}
		}

		ContextMenu._menuList=[];
		ContextMenu.revertLangDic={};
		__static(ContextMenu,
		['shortDic',function(){return this.shortDic={
				"转换为容器":"CmdOrCtrl+B",
				"转换类型":"CmdOrCtrl+T",
				"复制":"CmdOrCtrl+C",
				"剪切":"CmdOrCtrl+X",
				"粘贴":"CmdOrCtrl+V",
				"删除":"Delete",
				"打散容器":"CmdOrCtrl+U"
		};}

		]);
		return ContextMenu;
	})(Box)


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-11-25 下午3:24:13
	*/
	//class laya.editor.core.components.InputSelect extends laya.ui.ComboBox
	var InputSelect=(function(_super){
		function InputSelect(){
			this._input=null;
			InputSelect.__super.call(this);
		}

		__class(InputSelect,'laya.editor.core.components.InputSelect',_super);
		var __proto=InputSelect.prototype;
		/**@inheritDoc */
		__proto.createChildren=function(){
			_super.prototype.createChildren.call(this);
			this._input=new EditorTextInput();
			this._input.left=0;
			this._input.right=20;
			this._input.height=24;
			this._button["_text"].visible=false;
			this.addChild(this._input);
		}

		__proto.mchangeSelected=function(){
			this._button.label=this.selectedLabel;
			this._input.text=this.selectedLabel;
		}

		__getset(0,__proto,'input',function(){
			return this._input;
		});

		__getset(0,__proto,'selectedIndex',_super.prototype._$get_selectedIndex,function(value){
			if (this._selectedIndex !=value){
				this._selectedIndex=value;
				if (this._labels.length > 0)this.mchangeSelected();
				else this.callLater(this.mchangeSelected);
				this.event("change",[Event.EMPTY.setTo("change",this,this)]);
				this._selectHandler && this._selectHandler.runWith(this._selectedIndex);
			}
		});

		__getset(0,__proto,'selectedLabel',_super.prototype._$get_selectedLabel,function(value){
			_super.prototype._$set_selectedLabel.call(this,value);
			this._input.text=value;
		});

		return InputSelect;
	})(ComboBox)


	/**
	*...
	*@author ww
	*/
	//class laya.editor.core.components.TextField extends laya.ui.Label
	var TextField=(function(_super){
		function TextField(text){
			(text===void 0)&& (text="");
			TextField.__super.call(this,text);
		}

		__class(TextField,'laya.editor.core.components.TextField',_super);
		var __proto=TextField.prototype;
		__getset(0,__proto,'text',_super.prototype._$get_text,function(value){
			if (this._tf.text !=value){
				this._tf.text=value;
				this._tf.typeset();
				this.event("change");
			}
		});

		__getset(0,__proto,'width',function(){
			return this._tf.textWidth;
		},_super.prototype._$set_width);

		return TextField;
	})(Label)


	/**
	*...
	*@author ww
	*/
	//class laya.editor.core.Wraps.ContextMenuItem extends laya.ui.Button
	var ContextMenuItem=(function(_super){
		function ContextMenuItem(txt,isSeparator){
			this.data=null;
			this.img=null;
			ContextMenuItem.__super.call(this);
			if(!this.img)this.img=new Image();
			if(txt!=""){
				this.label=txt;
				this.name=txt;
				}else{
				this.label="------";
				this.height=5;
				this.mouseEnabled=false;
				this.img.skin="comp/line2.png";
				this.img.sizeGrid="0,2,0,2";
				this.addChild(this.img);
			}
			this.labelColors="#000000,#000000,#000000,#000000";
			this._text.x=10;
			this._text.padding=[-2,0,0,0];
			this._text.align="left";
			this._text.wordWrap=false;
			this._text.typeset();
			this.width=this._text.width+25;
			this.sizeGrid="3,3,3,3";
			this.skin="comp/button1.png";
		}

		__class(ContextMenuItem,'laya.editor.core.Wraps.ContextMenuItem',_super);
		var __proto=ContextMenuItem.prototype;
		__getset(0,__proto,'width',_super.prototype._$get_width,function(v){
			_super.prototype._$set_width.call(this,v);
			this.img.width=this.width;
			this.img.x=0;
		});

		return ContextMenuItem;
	})(Button)


	/**
	*时间轴当前帧标志线
	*@author ww
	*@version 1.0
	*
	*@created 2015-12-5 上午11:05:12
	*/
	//class laya.editor.view.timeline.TimeCursor extends laya.ui.Box
	var TimeCursor=(function(_super){
		function TimeCursor(){
			this.head=null;
			this.headWidth=3;
			this.headHeight=20;
			this.txt=null;
			TimeCursor.__super.call(this);
			this.headWidth=TimeGrid.frameWidth-1;
			this.head=new Sprite();
			var cHeight=0;
			cHeight=8;
			var g;
			g=this.head.graphics;
			var headWHalf=NaN;
			headWHalf=Math.ceil(0.5*this.headWidth);
			g.drawPoly(-this.head.width+0.5,0,[-headWHalf,-cHeight,headWHalf,-cHeight,0,0],"#00ffff");
			this.head.x=0;
			this.head.y=-5;
			this.head.width=this.headWidth;
			this.head.height=this.headHeight;
			this.head.mouseEnabled=true;
			this.addChild(this.head);
			this.txt=new Text();
			this.addChild(this.txt);
			this.txt.align="center";
			this.txt.color="#00ffff";
			this.txt.width=30;
			this.txt.pos(-this.txt.width*0.5,-28);
			this.size(1,1);
		}

		__class(TimeCursor,'laya.editor.view.timeline.TimeCursor',_super);
		var __proto=TimeCursor.prototype;
		__proto.changeSize=function(){
			laya.ui.Component.prototype.changeSize.call(this);
		}

		// head.x=-0.5*head.width;
		__proto.setFrame=function(frame){
			this.txt.text=frame+"";
		}

		__proto.sizeTo=function(height){
			var g;
			g=this.graphics;
			g.clear();
			g.drawLine(0,this.head.y,0,height,"#00ffff",1);
		}

		return TimeCursor;
	})(Box)


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-12-7 上午10:26:19
	*/
	//class laya.editor.view.timeline.tree.TreeNodeRender extends laya.ui.Box
	var TreeNodeRender=(function(_super){
		function TreeNodeRender(){
			this.arrow=null;
			this.icon=null;
			this.selectBox=null;
			this.label=null;
			this.dY=3;
			TreeNodeRender.__super.call(this);
			this.selectBox=new Clip("comp/clip_selectBox.png",1,2);
			this.selectBox.pos(13,0);
			this.selectBox.height=TimeGrid.frameHeight;
			this.selectBox.left=12;
			this.selectBox.right=0;
			this.selectBox.name="selectBox";
			this.addChild(this.selectBox);
			this.arrow=new Clip("comp/clip_tree.png",1,2);
			this.arrow.pos(0,5+this.dY);
			this.arrow.name="arrow";
			this.arrow.size(11,12);
			this.addChild(this.arrow);
			this.icon=new Image("comp/clip_folder.png");
			this.icon.pos(14,4+this.dY);
			this.icon.name="folder";
			this.addChild(this.icon);
			this.label=new Label();
			this.label.left=33;
			this.label.right=0;
			this.label.text="tree node";
			this.label.name="label";
			this.label.color="#ffffff";
			this.label.height=TimeGrid.frameHeight;
			this.label.y=5+this.dY;
			this.addChild(this.label);
			this.left=this.right=0;
			this.height=TimeGrid.frameHeight;
		}

		__class(TreeNodeRender,'laya.editor.view.timeline.tree.TreeNodeRender',_super);
		return TreeNodeRender;
	})(Box)


	/**
	*...
	*@author ww
	*/
	//class laya.ide.managers.focus.FocusItem extends laya.ui.Box
	var FocusItem=(function(_super){
		function FocusItem(){
			FocusItem.__super.call(this);
		}

		__class(FocusItem,'laya.ide.managers.focus.FocusItem',_super);
		var __proto=FocusItem.prototype;
		__proto.changeSize=function(){
			laya.ui.Component.prototype.changeSize.call(this);
			var g=this.graphics;
			g.clear();
			g.drawRect(0,0,this.width,this.height,"#33c5f5");
		}

		return FocusItem;
	})(Box)


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-8-10 下午3:12:59
	*/
	//class laya.ide.plugin.PluginPanel extends laya.ui.Box
	var PluginPanel=(function(_super){
		function PluginPanel(){
			PluginPanel.__super.call(this);
		}

		__class(PluginPanel,'laya.ide.plugin.PluginPanel',_super);
		var __proto=PluginPanel.prototype;
		__proto.show=function(){
			LayoutRecManager.showPanelToStage(this);
		}

		__proto.close=function(){
			LayoutRecManager.removePanel(this);
		}

		return PluginPanel;
	})(Box)


	/**
	*自动根据宽布局的容器
	*@author ww
	*@version 1.0
	*
	*@created 2016-1-4 下午5:39:35
	*/
	//class laya.ide.ui.BoxFitToWidth extends laya.ui.Box
	var BoxFitToWidth=(function(_super){
		function BoxFitToWidth(){
			this._items=null;
			this.dX=0;
			this.dY=0;
			this.sX=0;
			this.sY=0;
			BoxFitToWidth.__super.call(this);
		}

		__class(BoxFitToWidth,'laya.ide.ui.BoxFitToWidth',_super);
		var __proto=BoxFitToWidth.prototype;
		__proto.setItems=function(items){
			this.removeChildren();
			this._items=items;
			DisControlTool.addItems(items,this);
			this.reRender();
		}

		__proto.changeSize=function(){
			laya.ui.Component.prototype.changeSize.call(this);
			this.reRender();
		}

		__proto.reRender=function(){
			LayoutTools.layoutToWidth(this._items,this.width,this.dX,this.dY,this.sX,this.sY);
		}

		return BoxFitToWidth;
	})(Box)


	/**
	*自动根据大小填充自己全部区域的显示对象
	*@author ww
	*/
	//class laya.ide.managers.resizer.AutoFillRec extends laya.editor.comonents.DragBar
	var AutoFillRec=(function(_super){
		function AutoFillRec(type){
			this.type=0;
			this.preX=NaN;
			this.preY=NaN;
			AutoFillRec.__super.call(this,type);
		}

		__class(AutoFillRec,'laya.ide.managers.resizer.AutoFillRec',_super);
		var __proto=AutoFillRec.prototype;
		__proto.changeSize=function(){
			laya.ui.Component.prototype.changeSize.call(this);
			var g=this.graphics;
			g.clear();
			g.drawRect(0,0,this.width,this.height,"#33c5f5");
		}

		__proto.record=function(){
			this.preX=this.x;
			this.preY=this.y;
		}

		__proto.getDx=function(){
			return this.x-this.preX;
		}

		__proto.getDy=function(){
			return this.y-this.preY;
		}

		return AutoFillRec;
	})(DragBar)


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-8-3 下午2:43:22
	*/
	//class laya.rendercanvas.CanvasSprite extends laya.ui.Box
	var CanvasSprite=(function(_super){
		function CanvasSprite(){
			this.canvas=null;
			this._context=null;
			this.clearWhenRemove=false;
			this.mat=null;
			this.tar=null;
			CanvasSprite.__super.call(this);
			this.rate
			this.prePoint=new Point();
			this.canvas=HTMLCanvas.create('2D');
			this._context=new RenderContext(100,100,this.canvas);
			JSTools.setZIndex(this.canvas.source,100);
			this.rate=Browser.pixelRatio;
			if(this.rate<1)this.rate=1;
			if (this.rate!=1){
				this.mat=new Matrix();
				this.mat.scale(1 / this.rate,1 / this.rate);
				JSTools.setTransform(this.canvas.source,this.mat);
			}
			this.canvas.source.addEventListener("mouseup",this.passEvent);
			this.canvas.source.addEventListener("mousemove",this.passEvent);
			this.canvas.source.addEventListener("mousedown",this.passEvent);
			this.canvas.source.addEventListener('mousewheel',this.passEvent);
		}

		__class(CanvasSprite,'laya.rendercanvas.CanvasSprite',_super);
		var __proto=CanvasSprite.prototype;
		// Laya.timer.loop(1,this,updateCanvas);
		__proto.passEvent=function(e){
			var evt;
			evt=Browser.document.createEvent("Events");
			evt.initEvent(e.type,true,true);
			var key;
			for(key in e){
				if(!((typeof (e[key])=='function'))){
					evt[key]=e[key];
				}
			}
			Render.canvas.dispatchEvent(evt);
		}

		__proto.setTarget=function(tar){
			this.tar=tar;
			tar["render"]=Utils$1.bind(this.newRender,this);
			tar.on("display",this,this._$5__onDisplay);
			tar.on("undisplay",this,this._$5__onDisplay);
			this.canvas.source.id=ClassTool.getNodeClassAndName(tar);
			tar["_repaint"]=1;
		}

		__proto.canvasMouseOver=function(){}
		// JSTools.setMouseEnable(canvas.source,false);
		__proto.tarMouseOut=function(){
			if(HtmlZIndexManager.isMouseDown)return;
			JSTools.setMouseEnable(this.canvas.source,true);
		}

		__proto.clearMe=function(){
			if(this.tar){
				this.tar.off("display",this,this._$5__onDisplay);
				this.tar.off("undisplay",this,this._$5__onDisplay);
				this.tar.off("mouseout",this,this.tarMouseOut);
				var canvasSprite;
				canvasSprite=this.tar["canvasSprite"];
				if(canvasSprite){
					delete this.tar["canvasSprite"];
					JSTools.removeElement(this.canvas.source);
				}
			}
			Pool.recover("CanvasSprite",this);
		}

		/**@private */
		__proto._$5__onDisplay=function(){
			if(!this.tar)return;
			if(this.tar.displayedInStage){
				}else{
				JSTools.removeElement(this.canvas.source);
				if (this.clearWhenRemove){
					this.clearMe();
				}
			}
		}

		__proto.renderOld=function(context,x,y){
			Stat.spriteCount++;
			RenderSprite.renders[this.tar._renderType]._fun(this.tar,context,x,y);
			this.tar["_repaint"]=0;
		}

		__proto.newRender=function(context,x,y){
			this.updateCanvas(x,y);
		}

		__proto.updateCanvas=function(x,y){
			if(this.tar.displayedInStage){
				var point;
				point=NodeUtils.getGPos(this.tar);
				if(!JSTools.isElementInDom(this.canvas.source)){
					JSTools.showToParent(this.canvas.source,point.x,point.y,CanvasSprite.parentNode);
					this.prePoint.setTo(point.x,point.y);
					}else{
					if(this.prePoint.x!=point.x||this.prePoint.y!=point.y){
						JSTools.setPos(this.canvas.source,point.x,point.y);
						this.prePoint.setTo(point.x,point.y);
					}
				}
				if(this.tar["_repaint"]==0)return;
				if(IDEConsts.showRenderDebug){
					console.log("CanvasSprite:",this.tar);
				};
				var gRec;
				gRec=this.tar.getSelfBounds();
				this.canvas.size(gRec.width*this.rate,gRec.height*this.rate);
				this.canvas.clear();
				if (this.rate !=1){
					this.canvas.context.save();
					this.canvas.context.scale(this.rate,this.rate);
					this.renderOld(this._context,0,0);
					this.canvas.context.restore();
					}else{
					this.renderOld(this._context,0,0);
				}
				}else{
				JSTools.removeElement(this.canvas.source);
			}
		}

		CanvasSprite.setSpriteCanvasRender=function(tar,index,autoClear){
			(index===void 0)&& (index=100);
			(autoClear===void 0)&& (autoClear=false);
			if(!CanvasSprite.enableCanvasSprite)return;
			if(tar["canvasSprite"])return;
			var canvasSprite;
			canvasSprite=Pool.getItemByClass("CanvasSprite",CanvasSprite);
			canvasSprite.clearWhenRemove=autoClear;
			canvasSprite.setTarget(tar);
			tar["canvasSprite"]=canvasSprite;
			CanvasSprite.setSpriteCanvasIndex(tar,index);
		}

		CanvasSprite.setSpriteCanvasIndex=function(tar,index){
			var canvasSprite;
			canvasSprite=tar["canvasSprite"];
			if(canvasSprite){
				JSTools.setZIndex(canvasSprite.canvas.source,index);
			}
		}

		CanvasSprite.removeSpriteCanvas=function(tar){
			var canvasSprite;
			canvasSprite=tar["canvasSprite"];
			if(canvasSprite){
				canvasSprite.clearMe();
				delete tar["canvasSprite"];
			}
		}

		CanvasSprite.inits=function(){
			CanvasSprite.setSpriteCanvasRender(QuickTool.instance);
			CanvasSprite.hookDialog();
		}

		CanvasSprite.hookDialog=function(){
			DialogHook.I.hookDialog();
		}

		CanvasSprite.setSpriteRenderEmpty=function(tar){
			tar["render"]=CanvasSprite.renderEmpty;
		}

		CanvasSprite.renderEmpty=function(){}
		CanvasSprite.parentNode=null
		CanvasSprite.enableCanvasSprite=true;
		return CanvasSprite;
	})(Box)


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-8-9 上午11:59:23
	*/
	//class laya.rendercanvas.HtmlSprite extends laya.ui.Box
	var HtmlSprite=(function(_super){
		function HtmlSprite(){
			this.canClose=true;
			this.disableAutoControl=true;
			this.div=null;
			this.prePoint=new Point();
			var _$this=this;
			HtmlSprite.__super.call(this);
			HtmlSprite.parentNode=Browser.container;
			this.mouseEnabled=true;
			this.createHtml();
			this.size(100,100);
			this.on("display",this,this._$5__onDisplay);
			this.on("undisplay",this,this._$5__onDisplay);
			this.setZIndex(101);
			this.on("mouseover",this,this.renderMouseHandler);
			JSTools.setMouseEnable(this.div,false);
			this.div.addEventListener("mouseout",function(e){
				_$this.divMouseOut();
			})
		}

		__class(HtmlSprite,'laya.rendercanvas.HtmlSprite',_super);
		var __proto=HtmlSprite.prototype;
		__proto.divMouseOut=function(){
			JSTools.setMouseEnable(this.div,false);
		}

		__proto.renderMouseHandler=function(e){
			if(Input.isInputting){
				HtmlZIndexManager.isMouseDown=false;
			}
			if(HtmlZIndexManager.isMouseDown)return;
			JSTools.setMouseEnable(this.div,true);
		}

		__proto.createHtml=function(){
			this.div=Browser.createElement("div");
		}

		__proto.setHtmlTxt=function(html){
			this.div.innerHTML=html;
		}

		__proto.setZIndex=function(zIndex){
			(zIndex===void 0)&& (zIndex=101);
			JSTools.setZIndex(this.div,zIndex);
		}

		/**@private */
		__proto._$5__onDisplay=function(){
			if(this.displayedInStage){
				Laya.timer.frameLoop(1,this,this.updateMyPos);
				if(!this.disableAutoControl)
					HtmlZIndexManager.addHtml(this.div);
				}else{
				Laya.timer.clear(this,this.updateMyPos);
				JSTools.removeElement(this.div);
				HtmlZIndexManager.removeHtml(this.div);
			}
		}

		__proto.render=function(context,x,y){
			laya.display.Sprite.prototype.render.call(this,context,x,y);
		}

		// updateMyPos();
		__proto.updateMyPos=function(){
			if(this.displayedInStage&&this.visible){
				var point;
				point=NodeUtils.getGPos(this);
				if(!JSTools.isElementInDom(this.div)){
					JSTools.showToParent(this.div,point.x,point.y,HtmlSprite.parentNode);
					this.prePoint.setTo(point.x,point.y);
					}else{
					if(this.prePoint.x!=point.x||this.prePoint.y!=point.y){
						JSTools.setPos(this.div,point.x,point.y);
						this.prePoint.setTo(point.x,point.y);
					}
				}
				}else{
				JSTools.removeElement(this.div);
			}
		}

		__proto.changeSize=function(){
			laya.ui.Component.prototype.changeSize.call(this);
			JSTools.setSize(this.div,this.width,this.height);
		}

		HtmlSprite.testDiv="";
		HtmlSprite.parentNode=null
		return HtmlSprite;
	})(Box)


	//class laya.editor.ui.other.ColorPickerPanelUI extends laya.ui.View
	var ColorPickerPanelUI=(function(_super){
		function ColorPickerPanelUI(){
			this.pickBack=null;
			this.colorTxt=null;
			this.redTxt=null;
			this.greenTxt=null;
			this.blueTxt=null;
			ColorPickerPanelUI.__super.call(this);
		}

		__class(ColorPickerPanelUI,'laya.editor.ui.other.ColorPickerPanelUI',_super);
		var __proto=ColorPickerPanelUI.prototype;
		__proto.createChildren=function(){
			laya.ui.Component.prototype.createChildren.call(this);
			this.createView(ColorPickerPanelUI.uiView);
		}

		__static(ColorPickerPanelUI,
		['uiView',function(){return this.uiView={"child":[{"type":"Image","props":{"skin":"view/bg_panel4.png","y":"137","sizeGrid":"4,4,4,4","bottom":"0","left":"0","top":"0","right":"0","x":"165"}},{"type":"Image","props":{"skin":"comp/blank2.png","y":"5","width":"189","height":"180","var":"pickBack","x":"5"}},{"type":"Label","props":{"y":"202","text":"Color：","width":"50","align":"right","height":"18","color":"#c5c5c5","x":"2"}},{"type":"TextInput","props":{"skin":"comp/input_22.png","y":"200","sizeGrid":"0,3,0,3","text":"#ffffff","width":"138","left":"50","height":"22","var":"colorTxt","color":"#c5c5c5","right":"5","x":"50"}},{"type":"Label","props":{"y":"229","text":"Red：","width":"50","align":"right","height":"18","color":"#c5c5c5","x":"2"}},{"type":"TextInput","props":{"skin":"comp/input_22.png","y":"227","sizeGrid":"0,3,0,3","text":"255","width":"135","left":"50","height":"22","var":"redTxt","color":"#c5c5c5","right":"5","x":"50"}},{"type":"Label","props":{"y":"258","text":"Green：","width":"50","align":"right","height":"18","color":"#c5c5c5","x":"2"}},{"type":"TextInput","props":{"skin":"comp/input_22.png","y":"256","sizeGrid":"0,3,0,3","text":"255","width":"132","left":"50","height":"22","var":"greenTxt","color":"#c5c5c5","right":"5","x":"50"}},{"type":"Label","props":{"y":"287","text":"Blue：","width":"50","align":"right","height":"18","color":"#c5c5c5","x":"2"}},{"type":"TextInput","props":{"skin":"comp/input_22.png","y":"285","sizeGrid":"0,3,0,3","text":"255","width":"135","left":"50","height":"22","var":"blueTxt","color":"#c5c5c5","right":"5","x":"50"}}],"type":"View","props":{"height":"320","scenecolor":"#dddddd","width":"200"}};}
		]);
		return ColorPickerPanelUI;
	})(View)


	//class laya.editor.ui.comp.LayoutTabUI extends laya.ui.View
	var LayoutTabUI=(function(_super){
		function LayoutTabUI(){
			this.btn=null;
			this.close=null;
			LayoutTabUI.__super.call(this);
		}

		__class(LayoutTabUI,'laya.editor.ui.comp.LayoutTabUI',_super);
		var __proto=LayoutTabUI.prototype;
		__proto.createChildren=function(){
			laya.ui.Component.prototype.createChildren.call(this);
			this.createView(LayoutTabUI.uiView);
		}

		__static(LayoutTabUI,
		['uiView',function(){return this.uiView={"child":[{"type":"Button","props":{"skin":"view/tab_panel.png","y":"0","label":"label","x":"0","height":"25","var":"btn","width":"75","labelColors":"#dddddd,#888888,#e0e0e0"}},{"type":"Button","props":{"skin":"view/btn_close1.png","y":"7","scaleY":"0.5","scaleX":"0.5","var":"close","x":"59"}}],"type":"View","props":{"scenecolor":"#dddddd"}};}
		]);
		return LayoutTabUI;
	})(View)


	//class laya.editor.ui.comp.viewTabUI extends laya.ui.View
	var viewTabUI=(function(_super){
		function viewTabUI(){
			this.btn=null;
			this.close=null;
			viewTabUI.__super.call(this);
		}

		__class(viewTabUI,'laya.editor.ui.comp.viewTabUI',_super);
		var __proto=viewTabUI.prototype;
		__proto.createChildren=function(){
			laya.ui.Component.prototype.createChildren.call(this);
			this.createView(viewTabUI.uiView);
		}

		__static(viewTabUI,
		['uiView',function(){return this.uiView={"child":[{"type":"Button","props":{"skin":"view/tab_panel.png","y":"0","label":"label","x":"0","height":"25","var":"btn","labelMargin":"0,0,15,0","width":"75","labelColors":"#dddddd,#888888,#e0e0e0"}},{"type":"Button","props":{"skin":"view/btn_close1.png","y":"7","scaleY":"0.5","scaleX":"0.5","var":"close","x":"58"}}],"type":"View","props":{"scenecolor":"#dddddd"}};}
		]);
		return viewTabUI;
	})(View)


	//class laya.editor.core.UIView extends laya.editor.core.UIBox
	var UIView=(function(_super){
		function UIView(){
			this._viewLayer=null;
			UIView.__super.call(this);
			this.addChild(this._viewLayer=new UIBox());
			this._viewLayer.mouseEnabled=true;
		}

		__class(UIView,'laya.editor.core.UIView',_super);
		var __proto=UIView.prototype;
		/**创建视图*/
		__proto.createView=function(xml){
			if(this._viewLayer)
				this._viewLayer.removeSelf();
			if(this.hasClassByType(xml.type)){
				this._viewLayer=this.createComp(xml,null,{});
				}else{
				this._viewLayer=this.createComp(xml,new UIBox(),{});
			};
			var n=0;
			n=this.numChildren>0?1:0;
			this._viewLayer["disableLayout"]=true;
			this.addChildAt(this._viewLayer,n);
			this._viewLayer.mouseEnabled=true;
		}

		__proto.createViewCC=function(xml){
			this._viewLayer.removeChildren();
			this._viewLayer.resetState();
			this.createComp(xml,this._viewLayer,{});
		}

		/**根据容器创建，重新创建子对象，容器保持不变*/
		__proto.createByBox=function(box,xml){
			var map=this.getLayersInfo(xml);
			box.comXml=xml;
			var sprite=box;
			sprite.removeChildren();
			var list=xml.child;
			for (var j=0,n=list.length;j < n;j++){
				var node=list[j];
				var child=this.createComp(node,null,map);
				child && sprite.addChild(child);
			}
			return sprite;
		}

		__proto.getLayersInfo=function(xml){
			var obj={};
			return obj;
		}

		/**创建组件*/
		__proto.createComp=function(xml,comp,visibleMap){
			var layer=xml.layer;
			if (layer){
				if (visibleMap[layer]==0){
					return null;
				}
			}
			comp=comp || UIView.getCompInstance(xml);
			if (comp==null)return null;
			comp.mouseEnabled=true;
			var map=this.getLayersInfo(xml);
			var child;
			var list=xml.child;
			var addChilds;
			addChilds=[];
			if (list){
				for (var j=0,n=list.length;j < n;j++){
					var node=list[j];
					if (Laya.__typeof(comp,'laya.ui.IRender')&& node.props&&(node.props.name=="render"||node.props["renderType"]=="render")){
						child=this.createComp(node,null,map);
						if (child){
							child.name="render";
							comp.addChild(child);
						}
						try {
							comp["itemRender"]=node;
						}catch (e){}
						}else if(node){
						child=this.createComp(node,null,map);
						if (child){
							comp.addChild(child);
							if(xml.type=="Graphic"||node.type=="Graphic"||ClassUtils.isDrawType(node.type)){
								addChilds.push(child);
							}
							if(node.props["renderType"]=="mask"){
								comp.mask=child;
								child.removeSelf();
							}
						}
					}
				}
			}
			UIView.addGraphicsToSp(addChilds,comp);
			var props=xml.props;
			if(props){
				if(props["renderType"]=="hit"||props["renderType"]=="unHit"){
					comp.alpha=0.5;
				}
			}
			if(xml.hasOwnProperty(Signs.HideSign)){
				comp[Signs.HideSign]=xml[Signs.HideSign];
				comp.visible=comp.visible&&!xml[Signs.HideSign];
			}
			if(xml.hasOwnProperty(Signs.LockSign)){
				comp[Signs.LockSign]=xml[Signs.LockSign];
			};
			var prop,value;
			for (prop in props){
				value=props[prop];
				if (prop !="visible"){
					try {
						if (prop==="width" || prop==="height" || prop==="x" || prop==="y" || (typeof (comp[prop])=='number')){
							comp[prop]=Number(value);
							}else {
							comp[prop]=(value==="true" ? true :(value==="false" ? false :value))
						}
						}catch (e){
						var msg=Sys.lang("对[{0}]的{1}属性赋值{2}时遇错误：",xml.type,prop,value)+"\n"+e.message;
						alert(msg);
					}
				}
			};
			var compType=xml.type;
			var prefabO;
			prefabO=PreFabManager.I.getPreFabByNode(xml);
			if (compType !="View" && compType !="Dialog"){
				if (compType !="UIView"){
					var skinLabel=UIConfigManager.getCompSkinLabel(compType);
					var skin;
					if(xml.props)skin=xml.props[skinLabel];
					if(prefabO&&prefabO.props&&prefabO.props[skinLabel]){
						skin=prefabO.props[skinLabel];
					}
					if (skin){
						var defaultProps=ResStyleManager.getPropArr(skin);
						UIView.setDefaultValue(comp,xml,defaultProps);
					}
					}else {
					var source=xml.source;
					if (source){
						defaultProps=ResStyleManager.getPropArrByPropStr(PageStyleManager.getPageProps(source));
						UIView.setDefaultValue(comp,xml,defaultProps);
					}
				}
			}
			PreFabManager.I.insertPrefabVar(xml,comp);
			if (comp["initItems"])(comp).initItems();
			return comp;
		}

		__proto.hasClassByType=function(type){
			if(!UIConfigManager.getCompProp(type,"className"))return false;
			return Utils.getClass(UIConfigManager.getCompProp(type,"className"))?true:false;
		}

		__getset(0,__proto,'width',_super.prototype._$get_width,function(value){
			_super.prototype._$set_width.call(this,value);
			if((this._viewLayer instanceof laya.ui.View ))
				this._viewLayer.width=value;
		});

		__getset(0,__proto,'height',_super.prototype._$get_height,function(value){
			_super.prototype._$set_height.call(this,value);
			if((this._viewLayer instanceof laya.ui.View ))
				this._viewLayer.height=value;
		});

		UIView.setDefaultValue=function(comp,xml,props){
			for (var i=0,n=props.length;i < n;i++){
				var a=props[i].split("=");
				if (a.length==2){
					var key=a[0];
					var val=a[1];
					if (xml.props[key]==null){
						try {
							val=ObjectTools$1.getAutoValue(val);
							comp[key]=(val=="true" ? true :(val=="false" ? false :val))
							}catch (e){
							var msg=Sys.lang("对[{0}]的{1}属性赋值{2}时遇错误：",xml.name,key,val)+"\n"+e.message;
							alert(msg);
						}
					}
				}
			}
		}

		UIView.createCompS=function(xml,comp,visibleMap){
			if(UIView._createCompS_!=null){
			};
			var layer=xml.layer;
			if (layer){
				if (visibleMap[layer]==0){
					return null;
				}
			}
			comp=comp || UIView.getCompInstance(xml);
			if (comp==null)return null;
			var map={};
			var list=xml.child;
			var child;
			var addChilds;
			addChilds=[];
			if (list){
				for (var j=0,n=list.length;j < n;j++){
					var node=list[j];
					if (Laya.__typeof(comp,'laya.ui.IRender')&&node.props&& (node.props.name=="render"||node.props["renderType"]=="render")){
						child=UIView.createCompS(node,null,map);
						if (child){
							child.name="render";
							comp.addChild(child);
						}
						try {
							comp["itemRender"]=node;
						}catch (e){}
						}else if(node){
						child=UIView.createCompS(node,null,map);
						if (child){
							comp.addChild(child);
							if(xml.type=="Graphic"||node.type=="Graphic"||ClassUtils.isDrawType(node.type)){
								addChilds.push(child);
							}
						}
					}
				}
			}
			UIView.addGraphicsToSp(addChilds,comp);
			var props=xml.props;
			if(xml.hasOwnProperty(Signs.HideSign)){
				comp[Signs.HideSign]=xml[Signs.HideSign];
				comp.visible=comp.visible&&!xml[Signs.HideSign];
			}
			if(xml.hasOwnProperty(Signs.LockSign)){
				comp[Signs.LockSign]=xml[Signs.LockSign];
			};
			var prop,value;
			for (prop in props){
				value=props[prop];
				if (prop !="visible"){
					try {
						if (prop==="width" || prop==="height" || prop==="x" || prop==="y" || (typeof (comp[prop])=='number')){
							comp[prop]=Number(value);
							}else {
							comp[prop]=(value==="true" ? true :(value==="false" ? false :value))
						}
						}catch (e){
						var msg=Sys.lang("对[{0}]的{1}属性赋值{2}时遇错误：",xml.type,prop,value)+"\n"+e.message;
						alert(msg);
					}
				}
			};
			var prefabO;
			prefabO=PreFabManager.I.getPreFabByNode(xml);
			var compType=xml.type;
			if (compType !="View" && compType !="Dialog"){
				if (compType !="UIView"){
					var skinLabel=UIConfigManager.getCompSkinLabel(compType);
					var skin;
					if(xml.props)skin=xml.props[skinLabel];
					if(prefabO&&prefabO.props&&prefabO.props[skinLabel]){
						skin=prefabO.props[skinLabel];
					}
					if (skin){
						var defaultProps=ResStyleManager.getPropArr(skin);
						UIView.setDefaultValue(comp,xml,defaultProps);
					}
					}else {
					var source=xml.source;
					if (source){
						defaultProps=ResStyleManager.getPropArrByPropStr(PageStyleManager.getPageProps(source));
						UIView.setDefaultValue(comp,xml,defaultProps);
					}
				}
			}
			PreFabManager.I.insertPrefabVar(xml,comp);
			return comp;
		}

		UIView.addGraphicsToSp=function(addChilds,comp){
			if(comp.numChildren<1)return;
			try{
				var i=0,len=0;
				len=addChilds.length;
				for(i=0;i<len;i++){
					comp.setChildIndex(addChilds[len-1-i],0);
				}
			}catch(e){}
		}

		UIView.getCompInstance=function(xml){
			var name=xml.type;
			var source=xml.source;
			if (name=="UIView"){
				try {
					var sourcePath;
					sourcePath=FileManager.getPath(SystemSetting.pagesPath,source.replace(".xml","."+TypeManager.getExtension("page")));
					xml=FileManager.readJSONFile(sourcePath);
					if(TypeManager.isPreFabNodeType(xml.type)){
						if(PreFabManager.PrefabHasWrap){
							return UIView.createCompS(xml.child[0]);
							}else{
							return UIView.createCompS(xml);
						}
						}else{
						var view=new UIView();
						view.createView(xml);
						return view;
					}
					}catch (e){
					var msg=Sys.lang("创建页面嵌套时遇到错误，可能是嵌套的页面丢失或者错误 \n页面:{0}\n路径:{1}\n错误{2}",source,sourcePath,e.toString());
					Alert.show(msg);
					var classObj=Utils.getClass(UIConfigManager.getCompProp("Image","className"));
					var rst;
					rst=new classObj();
					rst.skin="comp/loseskin.png";
					return rst;
				}
				}else {
				try {
					classObj=Utils.getClass(UIConfigManager.getCompProp(name,"className"));
					return new classObj();
					}catch (e){
					msg=Sys.lang("创建[{0}]时遇到错误(手动实例一次本组件可定位错误)",name)+"\n"+e.toString();
					Alert.show(msg);
					classObj=Utils.getClass(UIConfigManager.getCompProp("Image","className"));
					rst=new classObj();
					rst.skin="comp/loseskin.png";
					return rst;
				}
			}
			return null;
		}

		UIView._createCompS_=null
		return UIView;
	})(UIBox)


	/**
	*...
	*@author ww
	*/
	//class laya.editor.core.components.EditorTextInput extends laya.ui.TextInput
	var EditorTextInput=(function(_super){
		function EditorTextInput(text){
			this._oldSkin=null;
			(text===void 0)&& (text="");
			EditorTextInput.__super.call(this,text);
			this._tf.on("blur",this,this.mOnBlur);
			this._tf.on("focus",this,this.mOnFocus);
			this.color=StyleConsts.TextInputColor;
		}

		__class(EditorTextInput,'laya.editor.core.components.EditorTextInput',_super);
		var __proto=EditorTextInput.prototype;
		__proto.mOnBlur=function(e){
			if(this._oldSkin)
				this.skin=this._oldSkin;
		}

		__proto.mOnFocus=function(e){
			if(this._oldSkin)
				this.skin=this._oldSkin.replace(".png","_selected.png");
			this.select();
		}

		__getset(0,__proto,'skin',_super.prototype._$get_skin,function(value){
			_super.prototype._$set_skin.call(this,value);
			if (!this._oldSkin){
				this._oldSkin=value;
			}
		});

		return EditorTextInput;
	})(TextInput)


	/**
	*可拖动布局框的基类
	*@author ww
	*/
	//class laya.ide.ui.DragView extends laya.ui.View
	var DragView=(function(_super){
		function DragView(){
			this.minWidth=50;
			this.minHeight=50;
			this.defaultWidth=100;
			this.defaultHeight=100;
			this.title="";
			this.helpUrl="";
			this.canClose=true;
			this.canMix=true;
			this.freeSize=false;
			DragView.__super.call(this);
		}

		__class(DragView,'laya.ide.ui.DragView',_super);
		return DragView;
	})(View)


	//class laya.editor.ui.group.ItemGroupUI extends laya.ui.View
	var ItemGroupUI=(function(_super){
		function ItemGroupUI(){
			this.groubBar=null;
			this.groupLabl=null;
			this.arrowClip=null;
			this.groupBox=null;
			ItemGroupUI.__super.call(this);
		}

		__class(ItemGroupUI,'laya.editor.ui.group.ItemGroupUI',_super);
		var __proto=ItemGroupUI.prototype;
		__proto.createChildren=function(){
			laya.ui.Component.prototype.createChildren.call(this);
			this.createView(ItemGroupUI.uiView);
		}

		__static(ItemGroupUI,
		['uiView',function(){return this.uiView={"child":[{"type":"Image","props":{"skin":"view/bg_bar.png","y":"0","width":"100","left":"0","mouseEnabled":"true","height":"20","var":"groubBar","right":"0","x":"0"}},{"type":"Label","props":{"var":"groupLabl","text":"label","mouseChildren":"false","mouseEnabled":"false","y":"0","color":"#d8d8d8","x":"29"}},{"type":"Clip","props":{"skin":"comp/clip_tree.png","y":"4","x":"15","mouseChildren":"false","mouseEnabled":"false","height":"12","var":"arrowClip","width":"11","clipY":"2"}},{"child":[{"type":"Button","props":{"skin":"comp/button.png","sizeGrid":"0,4,0,4","label":"label","labelColors":"#dddddd,#dddddd,#dddddd"}}],"type":"Box","props":{"x":"0","var":"groupBox","left":"0","y":"20","right":"0","mouseEnabled":"true"}}],"type":"View","props":{"scenecolor":"#dddddd"}};}
		]);
		return ItemGroupUI;
	})(View)


	//class laya.editor.ui.LayoutRecUI extends laya.ui.View
	var LayoutRecUI=(function(_super){
		function LayoutRecUI(){
			this.back=null;
			this.tab=null;
			this.tipIcon=null;
			LayoutRecUI.__super.call(this);
		}

		__class(LayoutRecUI,'laya.editor.ui.LayoutRecUI',_super);
		var __proto=LayoutRecUI.prototype;
		__proto.createChildren=function(){
			laya.ui.Component.prototype.createChildren.call(this);
			this.createView(LayoutRecUI.uiView);
		}

		__static(LayoutRecUI,
		['uiView',function(){return this.uiView={"child":[{"type":"Image","props":{"skin":"view/bg_panel_layoutrec.png","y":"0","sizeGrid":"0,3,0,3","width":"600","left":"0","height":"25","var":"back","top":"0","right":"0","x":"0"}},{"type":"Tab","props":{"skin":"view/tab_panel.png","y":"0","var":"tab","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5,#c5c5c5","x":"0"}},{"type":"Image","props":{"skin":"comp/iconhelp.png","y":"6","visible":"false","width":"14","height":"14","var":"tipIcon","right":"5","x":"581"}}],"type":"View","props":{"hitTestPrior":"true"}};}
		]);
		return LayoutRecUI;
	})(View)


	//class laya.editor.ui.MenuBarUI extends laya.ui.View
	var MenuBarUI=(function(_super){
		function MenuBarUI(){
			this.tab=null;
			this.btnBox=null;
			this.minBtn=null;
			this.backBtn=null;
			this.closeBtn=null;
			this.switchBtn=null;
			MenuBarUI.__super.call(this);
		}

		__class(MenuBarUI,'laya.editor.ui.MenuBarUI',_super);
		var __proto=MenuBarUI.prototype;
		__proto.createChildren=function(){
			laya.ui.Component.prototype.createChildren.call(this);
			this.createView(MenuBarUI.uiView);
		}

		__static(MenuBarUI,
		['uiView',function(){return this.uiView={"child":[{"type":"Image","props":{"skin":"view/bg_menu.png","y":"0","sizeGrid":"4,4,4,4","width":"200","left":"0","height":"34","right":"0","x":"0"}},{"type":"Image","props":{"skin":"view/logo.png","y":"6","x":"13"}},{"child":[{"type":"Button","props":{"skin":"view/btn_menu.png","name":"item0","label":"项目(P)","labelColors":"#e0e0e0,#e0e0e0,#e0e0e0"}},{"type":"Button","props":{"skin":"view/btn_menu.png","labelColors":"#e0e0e0,#e0e0e0,#e0e0e0","name":"item1","label":"文件(F)","x":"68"}},{"type":"Button","props":{"skin":"view/btn_menu.png","labelColors":"#e0e0e0,#e0e0e0,#e0e0e0","name":"item2","label":"编辑(E)","x":"136"}},{"type":"Button","props":{"skin":"view/btn_menu.png","labelColors":"#e0e0e0,#e0e0e0,#e0e0e0","name":"item3","label":"视图(V)","x":"204"}},{"type":"Button","props":{"skin":"view/btn_menu.png","labelColors":"#e0e0e0,#e0e0e0,#e0e0e0","name":"item5","label":"发布(I)","x":"340"}},{"type":"Button","props":{"skin":"view/btn_menu.png","labelColors":"#e0e0e0,#e0e0e0,#e0e0e0","name":"item6","label":"插件(T)","x":"408"}},{"type":"Button","props":{"skin":"view/btn_menu.png","name":"item7","label":"关于(A)","x":"476","visible":"false","labelColors":"#e0e0e0,#e0e0e0,#e0e0e0"}},{"type":"Button","props":{"skin":"view/btn_menu.png","name":"item4","label":"窗口(W)","x":"272","y":"0","labelColors":"#e0e0e0,#e0e0e0,#e0e0e0"}}],"type":"Tab","props":{"var":"tab","y":"5","x":"40"}},{"child":[{"type":"Button","props":{"skin":"view/btn_min.png","var":"minBtn","y":"0","x":"65"}},{"type":"Button","props":{"skin":"view/btn_max.png","var":"backBtn","y":"0","x":"98"}},{"type":"Button","props":{"skin":"view/btn_close2.png","var":"closeBtn","y":"0","x":"131"}},{"type":"Button","props":{"skin":"view/btn_menu.png","name":"item5","var":"switchBtn","label":"代码模式","x":"-12","height":"24","y":"5","width":"79","labelColors":"#e0e0e0,#e0e0e0,#e0e0e0"}}],"type":"Box","props":{"var":"btnBox","y":"1","right":"1","x":"712"}}],"type":"View","props":{"height":"34","scenecolor":"#dddddd","width":"600"}};}
		]);
		return MenuBarUI;
	})(View)


	//class laya.editor.ui.other.HelpTipUI extends laya.ui.View
	var HelpTipUI=(function(_super){
		function HelpTipUI(){
			this.tipTxt=null;
			this.closeBtn=null;
			HelpTipUI.__super.call(this);
		}

		__class(HelpTipUI,'laya.editor.ui.other.HelpTipUI',_super);
		var __proto=HelpTipUI.prototype;
		__proto.createChildren=function(){
			laya.ui.Component.prototype.createChildren.call(this);
			this.createView(HelpTipUI.uiView);
		}

		__static(HelpTipUI,
		['uiView',function(){return this.uiView={"child":[{"type":"Image","props":{"skin":"view/helptipbg.png","y":"0","x":"0"}},{"type":"Label","props":{"y":"11","text":"点击这里查看帮助","width":"165","align":"center","height":"43","var":"tipTxt","color":"#f1ea71","fontSize":"12","x":"-24"}},{"type":"Button","props":{"skin":"view/btn_close1.png","y":"2","scaleY":"0.5","scaleX":"0.5","var":"closeBtn","x":"98"}}],"type":"View","props":{"height":"46","width":"114"}};}
		]);
		return HelpTipUI;
	})(View)


	//class laya.editor.manager.DragBoxManager extends laya.editor.core.UIBox
	var DragBoxManager=(function(_super){
		function DragBoxManager(){
			this._selfControledDrag=[];
			DragBoxManager.__super.call(this);
			this._drags=new DictionaryIDE();
		}

		__class(DragBoxManager,'laya.editor.manager.DragBoxManager',_super);
		var __proto=DragBoxManager.prototype;
		__proto.addDrag=function(target,type){
			if(target["setIDESelectState"]!=null){
				target["setIDESelectState"](true);
				if(this._selfControledDrag.indexOf(target)<0){
					this._selfControledDrag.push(this._selfControledDrag);
				}
				return;
			}
			this.removeDrag(target);
			this.setTargetFocusState(target,true);
			var dragBox;
			dragBox=Pool.getItem("DragBox_"+type);
			if (!dragBox){
				dragBox=new DragBox(type);
			}
			this.addChild(dragBox);
			dragBox.setTarget(target);
			this._drags.add(target,dragBox);
		}

		__proto.removeDrag=function(target){
			this.setTargetFocusState(target,false);
			if(target["setIDESelectState"]!=null){
				target["setIDESelectState"](false);
				if(this._selfControledDrag.indexOf(target)>=0){
					this._selfControledDrag.splice(this._selfControledDrag.indexOf(target),1);
				}
				return;
			};
			var dragBox=this._drags.getValue(target);
			if (dragBox){
				dragBox.removeSelf();
				this._drags.deleteKey(target);
				Pool.recover("DragBox_"+dragBox.type,dragBox);
			}
		}

		__proto.removeAll=function(){
			this.removeChildren();
			this._drags.reset();
			var i=0;
			var target;
			for(i=this._selfControledDrag.length-1;i>=0;i--){
				target=this._selfControledDrag[i];
				this.setTargetFocusState(target,false);
				if(target["setIDESelectState"]!=null){
					target["setIDESelectState"](false);
				}
			}
			this._selfControledDrag.length=0;
		}

		__proto.setTargetFocusState=function(target,focus){
			if(!target)return;
			if(!target["setIDEFocusState"])return;
			target["setIDEFocusState"](focus);
		}

		// trace("setFocus:",focus);
		__proto.refreshDrag=function(target){
			if(target["freshIDESelect"]!=null){
				target["freshIDESelect"]();
				return;
			};
			var dragBox=this._drags.getValue(target);
			if (dragBox){
				dragBox.refresh();
			}
		}

		return DragBoxManager;
	})(UIBox)


	//class laya.editor.ui.other.ResTypeSettingViewUI extends laya.ui.View
	var ResTypeSettingViewUI=(function(_super){
		function ResTypeSettingViewUI(){
			this.typeList=null;
			this.okBtn=null;
			ResTypeSettingViewUI.__super.call(this);
		}

		__class(ResTypeSettingViewUI,'laya.editor.ui.other.ResTypeSettingViewUI',_super);
		var __proto=ResTypeSettingViewUI.prototype;
		__proto.createChildren=function(){
			laya.ui.Component.prototype.createChildren.call(this);
			this.createView(ResTypeSettingViewUI.uiView);
		}

		__static(ResTypeSettingViewUI,
		['uiView',function(){return this.uiView={"child":[{"child":[{"child":[{"type":"Label","props":{"y":"4","text":"type","width":"77","align":"left","height":"20","name":"nameTxt","color":"#c5c5c5","x":"0"}},{"type":"TextInput","props":{"skin":"comp/input_24.png","name":"inputTxt","sizeGrid":"0,3,0,3","width":"80","height":"24","y":"0","color":"#c5c5c5","x":"89"}}],"type":"Box","props":{"height":"26","y":"0","name":"render","width":"191","x":"0"}}],"type":"List","props":{"vScrollBarSkin":"comp/vscroll.png","y":"25","width":"366","height":"234","var":"typeList","x":"18"}},{"type":"Button","props":{"skin":"comp/button.png","y":"269","sizeGrid":"0,4,0,4","label":"确定","x":"145","var":"okBtn","labelColors":"#efefef,#ffffff,#c5c5c5,#c5c5c5"}}],"type":"View","props":{"height":"300","width":"400"}};}
		]);
		return ResTypeSettingViewUI;
	})(View)


	//class laya.editor.ui.page.AddGraphicAniUI extends laya.ui.View
	var AddGraphicAniUI=(function(_super){
		function AddGraphicAniUI(){
			this.nametip=null;
			this.widthTip=null;
			this.heightTip=null;
			this.nameTxt=null;
			this.widthTxt=null;
			this.heightTxt=null;
			this.bgColorPicker=null;
			this.typetip=null;
			this.typeDrop=null;
			AddGraphicAniUI.__super.call(this);
		}

		__class(AddGraphicAniUI,'laya.editor.ui.page.AddGraphicAniUI',_super);
		var __proto=AddGraphicAniUI.prototype;
		__proto.createChildren=function(){
			laya.ui.Component.prototype.createChildren.call(this);
			this.createView(AddGraphicAniUI.uiView);
		}

		__static(AddGraphicAniUI,
		['uiView',function(){return this.uiView={"child":[{"type":"Label","props":{"y":"96","color":"#c5c5c5","text":"参考宽度，实际无效","x":"428"}},{"type":"Label","props":{"y":"134","color":"#c5c5c5","text":"参考高度，实际无效","x":"428"}},{"type":"Label","props":{"y":"54","text":"页面名称：","width":"70","align":"right","var":"nametip","color":"#c5c5c5","x":"10"}},{"type":"Label","props":{"y":"93","text":"页面宽度：","width":"70","align":"right","var":"widthTip","color":"#c5c5c5","x":"10"}},{"type":"Label","props":{"y":"133","text":"页面高度：","width":"70","align":"right","var":"heightTip","color":"#c5c5c5","x":"10"}},{"type":"Label","props":{"y":"171","wordWrap":"true","text":"参考背景：","width":"70","align":"right","height":"40","color":"#c5c5c5","x":"10"}},{"type":"TextInput","props":{"skin":"comp/input_32.png","y":"47","sizeGrid":"0,3,0,3","width":"451","height":"32","var":"nameTxt","color":"#c5c5c5","x":"83"}},{"type":"TextInput","props":{"skin":"comp/input_32.png","y":"86","sizeGrid":"0,3,0,3","text":"600","width":"339","height":"32","var":"widthTxt","color":"#c5c5c5","x":"83"}},{"type":"TextInput","props":{"skin":"comp/input_32.png","y":"126","sizeGrid":"0,3,0,3","text":"400","width":"339","height":"32","var":"heightTxt","color":"#c5c5c5","x":"83"}},{"type":"ColorPicker","props":{"skin":"comp/color.png","y":"171","selectedcolor":"#dddddd","scaleX":"0.5","var":"bgColorPicker","scaleY":"0.5","x":"83"}},{"type":"Label","props":{"y":"173","text":"(可选，设计面板的背景颜色)","width":"417","height":"18","color":"#c5c5c5","x":"103"}},{"type":"Label","props":{"y":"16","text":"动画类型：","width":"70","align":"right","var":"typetip","color":"#c5c5c5","x":"10"}},{"type":"ComboBox","props":{"skin":"comp/combo_32.png","var":"typeDrop","sizeGrid":"0,20,0,3","labels":"View,Dialog","scrollBarSkin":"comp/vscroll.png","width":"451","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5,#c5c5c5","height":"32","y":"8","selectedIndex":"0","x":"83"}}],"type":"View","props":{"height":"250","scenecolor":"#dddddd","width":"550"}};}
		]);
		return AddGraphicAniUI;
	})(View)


	//class laya.editor.ui.page.AddPageUI extends laya.ui.View
	var AddPageUI=(function(_super){
		function AddPageUI(){
			this.typetip=null;
			this.nametip=null;
			this.widthTip=null;
			this.heightTip=null;
			this.typeDrop=null;
			this.nameTxt=null;
			this.imgTxt=null;
			this.widthTxt=null;
			this.heightTxt=null;
			this.bgColorPicker=null;
			this.selectBtn=null;
			this.widthCheck=null;
			this.heightCheck=null;
			AddPageUI.__super.call(this);
		}

		__class(AddPageUI,'laya.editor.ui.page.AddPageUI',_super);
		var __proto=AddPageUI.prototype;
		__proto.createChildren=function(){
			laya.ui.Component.prototype.createChildren.call(this);
			this.createView(AddPageUI.uiView);
		}

		__static(AddPageUI,
		['uiView',function(){return this.uiView={"child":[{"type":"Label","props":{"y":"16","text":"页面类型：","width":"70","align":"right","var":"typetip","color":"#c5c5c5","x":"10"}},{"type":"Label","props":{"y":"54","text":"页面名称：","width":"70","align":"right","var":"nametip","color":"#c5c5c5","x":"10"}},{"type":"Label","props":{"y":"94","text":"参考视图：","width":"70","align":"right","color":"#c5c5c5","x":"10"}},{"type":"Label","props":{"y":"133","text":"页面宽度：","width":"70","align":"right","var":"widthTip","color":"#c5c5c5","x":"10"}},{"type":"Label","props":{"y":"173","text":"页面高度：","width":"70","align":"right","var":"heightTip","color":"#c5c5c5","x":"10"}},{"type":"Label","props":{"y":"211","wordWrap":"true","text":"参考背景：","width":"70","align":"right","height":"40","color":"#c5c5c5","x":"10"}},{"type":"ComboBox","props":{"skin":"comp/combo_32.png","var":"typeDrop","sizeGrid":"0,20,0,3","labels":"View,Dialog","scrollBarSkin":"comp/vscroll.png","width":"451","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5,#c5c5c5","height":"32","y":"8","selectedIndex":"0","x":"83"}},{"type":"TextInput","props":{"skin":"comp/input_32.png","y":"47","sizeGrid":"0,3,0,3","width":"451","height":"32","var":"nameTxt","color":"#c5c5c5","x":"83"}},{"type":"TextInput","props":{"skin":"comp/input_32.png","y":"86","sizeGrid":"0,3,0,3","width":"300","height":"32","var":"imgTxt","color":"#c5c5c5","x":"83"}},{"type":"TextInput","props":{"skin":"comp/input_32.png","y":"126","sizeGrid":"0,3,0,3","text":"600","width":"339","height":"32","var":"widthTxt","color":"#c5c5c5","x":"83"}},{"type":"TextInput","props":{"skin":"comp/input_32.png","y":"166","sizeGrid":"0,3,0,3","text":"400","width":"339","height":"32","var":"heightTxt","color":"#c5c5c5","x":"83"}},{"type":"ColorPicker","props":{"skin":"comp/color.png","y":"211","selectedcolor":"#dddddd","scaleX":"0.5","var":"bgColorPicker","scaleY":"0.5","x":"83"}},{"type":"Label","props":{"y":"94","wordWrap":"true","text":"(可选，参考背景)","height":"40","color":"#c5c5c5","x":"435"}},{"type":"Label","props":{"y":"213","text":"(可选，设计面板的背景颜色)","width":"352","height":"18","color":"#c5c5c5","x":"105"}},{"type":"Button","props":{"skin":"comp/btn_browser.png","y":"86","width":"40","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5","height":"32","var":"selectBtn","label":"选择","x":"383"}},{"type":"CheckBox","props":{"skin":"comp/checkbox.png","y":"138","label":"仅作为参考宽度","x":"428","var":"widthCheck","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5,#c5c5c5"}},{"type":"CheckBox","props":{"skin":"comp/checkbox.png","y":"178","label":"仅作为参考高度","x":"428","var":"heightCheck","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5,#c5c5c5"}}],"type":"View","props":{"height":"250","scenecolor":"#dddddd","width":"550"}};}
		]);
		return AddPageUI;
	})(View)


	//class laya.editor.ui.page.AddParticleUI extends laya.ui.View
	var AddParticleUI=(function(_super){
		function AddParticleUI(){
			this.nameTxt=null;
			this.typeDrop=null;
			AddParticleUI.__super.call(this);
		}

		__class(AddParticleUI,'laya.editor.ui.page.AddParticleUI',_super);
		var __proto=AddParticleUI.prototype;
		__proto.createChildren=function(){
			laya.ui.Component.prototype.createChildren.call(this);
			this.createView(AddParticleUI.uiView);
		}

		__static(AddParticleUI,
		['uiView',function(){return this.uiView={"child":[{"type":"Label","props":{"y":"54","text":"粒子名称：","width":"78","align":"right","height":"18","color":"#c5c5c5","x":"2"}},{"type":"TextInput","props":{"skin":"comp/input_32.png","var":"nameTxt","sizeGrid":"0,3,0,3","width":"451","height":"32","y":"47","color":"#c5c5c5","x":"83"}},{"type":"Label","props":{"y":"16","text":"粒子类型：","width":"70","align":"right","color":"#c5c5c5","x":"10"}},{"type":"ComboBox","props":{"skin":"comp/combo_32.png","y":"8","sizeGrid":"0,20,0,3","labels":"重力模式,半径模式","selectedIndex":"0","width":"451","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5,#c5c5c5","height":"32","var":"typeDrop","scrollBarSkin":"comp/vscroll.png","x":"83"}}],"type":"View","props":{"height":"250","scenecolor":"#dddddd","width":"550"}};}
		]);
		return AddParticleUI;
	})(View)


	//class laya.editor.ui.page.AddScriptUI extends laya.ui.View
	var AddScriptUI=(function(_super){
		function AddScriptUI(){
			this.nameTxt=null;
			this.typeDrop=null;
			this.classTxt=null;
			AddScriptUI.__super.call(this);
		}

		__class(AddScriptUI,'laya.editor.ui.page.AddScriptUI',_super);
		var __proto=AddScriptUI.prototype;
		__proto.createChildren=function(){
			laya.ui.Component.prototype.createChildren.call(this);
			this.createView(AddScriptUI.uiView);
		}

		__static(AddScriptUI,
		['uiView',function(){return this.uiView={"child":[{"type":"Label","props":{"y":"54","text":"脚本名称：","width":"70","align":"right","color":"#c5c5c5","x":"10"}},{"type":"TextInput","props":{"skin":"comp/input_32.png","var":"nameTxt","sizeGrid":"0,3,0,3","width":"451","height":"32","y":"47","color":"#c5c5c5","x":"83"}},{"type":"Label","props":{"y":"16","text":"脚本类型：","width":"70","align":"right","color":"#c5c5c5","x":"10"}},{"type":"ComboBox","props":{"skin":"comp/combo_32.png","y":"8","sizeGrid":"0,20,0,3","labels":"扩展脚本,附加脚本","selectedIndex":"0","width":"451","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5,#c5c5c5","height":"32","var":"typeDrop","scrollBarSkin":"comp/vscroll.png","x":"83"}},{"type":"Label","props":{"y":"94","text":"运行类名：","width":"85","align":"right","height":"18","color":"#c5c5c5","x":"-5"}},{"type":"TextInput","props":{"skin":"comp/input_32.png","var":"classTxt","sizeGrid":"0,3,0,3","width":"340","height":"32","y":"87","color":"#c5c5c5","x":"83"}},{"type":"Label","props":{"y":"91","wordWrap":"true","text":"(运行时的类名，比如game.view.MyScript)","width":"117","height":"41","color":"#c5c5c5","x":"433"}}],"type":"View","props":{"height":"250","scenecolor":"#dddddd","width":"550"}};}
		]);
		return AddScriptUI;
	})(View)


	//class laya.editor.ui.prop.PropGroupUI extends laya.ui.View
	var PropGroupUI=(function(_super){
		function PropGroupUI(){
			this.groubBar=null;
			this.groupLabl=null;
			this.arrowClip=null;
			this.groupBox=null;
			PropGroupUI.__super.call(this);
		}

		__class(PropGroupUI,'laya.editor.ui.prop.PropGroupUI',_super);
		var __proto=PropGroupUI.prototype;
		__proto.createChildren=function(){
			laya.ui.Component.prototype.createChildren.call(this);
			this.createView(PropGroupUI.uiView);
		}

		__static(PropGroupUI,
		['uiView',function(){return this.uiView={"child":[{"type":"Image","props":{"skin":"view/bg_bar.png","y":"0","width":"100","left":"0","mouseEnabled":"true","height":"24","var":"groubBar","right":"0","x":"0"}},{"type":"Label","props":{"var":"groupLabl","text":"label","mouseChildren":"false","mouseEnabled":"false","y":"3","color":"#efeded","x":"19"}},{"type":"Clip","props":{"skin":"comp/clip_tree.png","y":"4","x":"5","mouseChildren":"false","mouseEnabled":"false","height":"12","var":"arrowClip","width":"11","clipY":"2"}},{"child":[{"type":"Button","props":{"skin":"comp/button.png","sizeGrid":"0,4,0,4","label":"label","labelColors":"#dddddd,#dddddd,#dddddd"}}],"type":"Box","props":{"x":"0","var":"groupBox","left":"0","y":"24","right":"0","mouseEnabled":"true"}}],"type":"View","props":{"hitTestPrior":"true","scenecolor":"#dddddd"}};}
		]);
		return PropGroupUI;
	})(View)


	//class laya.editor.ui.QuickToolUI extends laya.ui.View
	var QuickToolUI=(function(_super){
		function QuickToolUI(){
			QuickToolUI.__super.call(this);
		}

		__class(QuickToolUI,'laya.editor.ui.QuickToolUI',_super);
		var __proto=QuickToolUI.prototype;
		__proto.createChildren=function(){
			laya.ui.Component.prototype.createChildren.call(this);
			this.createView(QuickToolUI.uiView);
		}

		__static(QuickToolUI,
		['uiView',function(){return this.uiView={"child":[{"type":"Button","props":{"skin":"view/folder_add.png","stateNum":"2","y":"5","toolTip":"新建页面文件夹","name":"addFolder","x":"20"}},{"type":"Button","props":{"skin":"view/page_add.png","stateNum":"2","y":"5","toolTip":"新建页面","name":"addPage","x":"54"}},{"type":"Button","props":{"skin":"view/save.png","stateNum":"2","y":"5","toolTip":"保存页面","name":"save","x":"94"}},{"type":"Button","props":{"skin":"view/saveall.png","stateNum":"2","y":"5","toolTip":"保存所有页面","name":"saveAll","x":"128"}},{"type":"Button","props":{"skin":"view/back.png","stateNum":"2","y":"5","toolTip":"恢复","name":"back","x":"168"}},{"type":"Button","props":{"skin":"view/re.png","stateNum":"2","y":"5","toolTip":"撤销恢复","name":"reBack","x":"202"}},{"type":"Button","props":{"skin":"view/zoom_in.png","stateNum":"2","y":"5","toolTip":"缩小视图","name":"zoomIn","x":"242"}},{"type":"Button","props":{"skin":"view/zoom_out.png","stateNum":"2","y":"5","toolTip":"放大视图","name":"zoomOut","x":"276"}},{"type":"Button","props":{"skin":"view/zoom_back.png","stateNum":"2","y":"5","toolTip":"恢复视图","name":"zoomBack","x":"310"}},{"type":"Button","props":{"skin":"view/res.png","stateNum":"2","y":"5","toolTip":"刷新资源及页面","name":"refresh","x":"354"}},{"type":"Button","props":{"skin":"view/publish.png","stateNum":"2","y":"5","toolTip":"发布","name":"publish","x":"388"}},{"type":"Button","props":{"skin":"view/align_left.png","stateNum":"2","y":"5","toolTip":"左对齐","name":"alignLeft","x":"432"}},{"type":"Button","props":{"skin":"view/align_center.png","stateNum":"2","y":"5","toolTip":"垂直居中对齐","name":"alignCenter","x":"466"}},{"type":"Button","props":{"skin":"view/align_right.png","stateNum":"2","y":"5","toolTip":"右对齐","name":"alignRight","x":"500"}},{"type":"Button","props":{"skin":"view/align_top.png","stateNum":"2","y":"5","toolTip":"顶部对齐","name":"alignTop","x":"534"}},{"type":"Button","props":{"skin":"view/align_middle.png","stateNum":"2","y":"5","toolTip":"水平居中对齐","name":"alignMiddle","x":"566"}},{"type":"Button","props":{"skin":"view/align_bottom.png","stateNum":"2","y":"5","toolTip":"底部对齐","name":"alignbottom","x":"600"}},{"type":"Button","props":{"skin":"view/space_h.png","stateNum":"2","y":"5","toolTip":"水平平均间隔","name":"spaceH","x":"644"}},{"type":"Button","props":{"skin":"view/space_v.png","stateNum":"2","y":"5","toolTip":"垂直平均间隔","name":"spaceV","x":"678"}},{"type":"Button","props":{"skin":"view/move_top_left.png","stateNum":"2","y":"5","toolTip":"移动到左上角","name":"topLeft","x":"722"}},{"type":"Button","props":{"skin":"view/move_top_right.png","stateNum":"2","y":"5","toolTip":"移动到右上角","name":"topRight","x":"756"}},{"type":"Button","props":{"skin":"view/center.png","stateNum":"2","y":"5","toolTip":"移动到水平居中","name":"center","x":"850"}},{"type":"Button","props":{"skin":"view/middle.png","stateNum":"2","y":"5","toolTip":"移动到垂直居中","name":"middle","x":"884"}},{"type":"Button","props":{"skin":"view/move_bottom_left.png","stateNum":"2","y":"5","toolTip":"移动到左下角","name":"bottomLeft","x":"786"}},{"type":"Button","props":{"skin":"view/move_bottom_right.png","stateNum":"2","y":"5","toolTip":"移动到右下角","name":"bottomRight","x":"816"}},{"type":"Button","props":{"skin":"view/tomiddle.png","stateNum":"2","y":"4","toolTip":"相对原点居中","name":"tomiddle","x":"915"}}],"type":"View","props":{"hitTestPrior":"true","height":"32","scenecolor":"#dddddd","title":"工具","width":"900"}};}
		]);
		return QuickToolUI;
	})(View)


	//class laya.editor.ui.template.TemplateItemUI extends laya.ui.View
	var TemplateItemUI=(function(_super){
		function TemplateItemUI(){
			this.imgBg=null;
			this.tLabel=null;
			TemplateItemUI.__super.call(this);
		}

		__class(TemplateItemUI,'laya.editor.ui.template.TemplateItemUI',_super);
		var __proto=TemplateItemUI.prototype;
		__proto.createChildren=function(){
			laya.ui.Component.prototype.createChildren.call(this);
			this.createView(TemplateItemUI.uiView);
		}

		__static(TemplateItemUI,
		['uiView',function(){return this.uiView={"child":[{"type":"Image","props":{"skin":"view/bg_content.png","sizeGrid":"5,5,5,5","bottom":"0","left":"0","top":"0","right":"0"}},{"type":"Image","props":{"skin":"comp/blank.png","y":"8","var":"imgBg","bottom":"15","left":"2","top":"2","right":"2","x":"8"}},{"type":"Image","props":{"skin":"view/bg_content.png","y":"60","sizeGrid":"5,5,5,5","width":"74","left":"0","height":"20","right":"0","x":"0"}},{"type":"Label","props":{"y":"61","text":"控件名","width":"65","left":"5","align":"center","height":"18","var":"tLabel","color":"#dddddd","right":"5","x":"7"}}],"type":"View","props":{"height":"80","scenecolor":"#dddddd","width":"80"}};}
		]);
		return TemplateItemUI;
	})(View)


	//class laya.editor.ui.timeline.PlayControlUI extends laya.ui.View
	var PlayControlUI=(function(_super){
		function PlayControlUI(){
			this.play=null;
			this.next=null;
			this.toEndPos=null;
			this.stop=null;
			this.toBeginPos=null;
			this.pre=null;
			PlayControlUI.__super.call(this);
		}

		__class(PlayControlUI,'laya.editor.ui.timeline.PlayControlUI',_super);
		var __proto=PlayControlUI.prototype;
		__proto.createChildren=function(){
			laya.ui.Component.prototype.createChildren.call(this);
			this.createView(PlayControlUI.uiView);
		}

		__static(PlayControlUI,
		['uiView',function(){return this.uiView={"child":[{"type":"Button","props":{"skin":"play/btn_play.png","y":"4","var":"play","mouseEnabled":"true","scaleX":"0.5","name":"play","scaleY":"0.5","toolTip":"播放","x":"50"}},{"type":"Button","props":{"skin":"play/btn_forward.png","y":"4","var":"next","mouseEnabled":"true","scaleX":"0.5","name":"next","scaleY":"0.5","toolTip":"前进","x":"72"}},{"type":"Button","props":{"skin":"play/btn_end.png","y":"4","var":"toEndPos","mouseEnabled":"true","scaleX":"0.5","name":"toEndPos","scaleY":"0.5","toolTip":"跳到末尾","x":"94"}},{"type":"Button","props":{"skin":"play/btn_stop.png","y":"4","var":"stop","mouseEnabled":"true","scaleX":"0.5","name":"stop","scaleY":"0.5","toolTip":"停止","x":"50"}},{"type":"Button","props":{"skin":"play/btn_begin.png","y":"4","var":"toBeginPos","mouseEnabled":"true","scaleX":"0.5","name":"toBeginPos","scaleY":"0.5","toolTip":"跳到开始","x":"6"}},{"type":"Button","props":{"skin":"play/btn_back.png","y":"4","var":"pre","mouseEnabled":"true","scaleX":"0.5","name":"pre","scaleY":"0.5","toolTip":"后退","x":"28"}}],"type":"View","props":{"height":"34","scenecolor":"#dddddd","width":"123"}};}
		]);
		return PlayControlUI;
	})(View)


	//class laya.editor.ui.timeline.TimeGridUI extends laya.ui.View
	var TimeGridUI=(function(_super){
		function TimeGridUI(){
			this.bgPic=null;
			TimeGridUI.__super.call(this);
		}

		__class(TimeGridUI,'laya.editor.ui.timeline.TimeGridUI',_super);
		var __proto=TimeGridUI.prototype;
		__proto.createChildren=function(){
			laya.ui.Component.prototype.createChildren.call(this);
			this.createView(TimeGridUI.uiView);
		}

		__static(TimeGridUI,
		['uiView',function(){return this.uiView={"child":[{"type":"Image","props":{"skin":"view/bg_panel4.png","y":"183","var":"bgPic","sizeGrid":"4,4,4,4","x":"202"}}],"type":"View","props":{"scenecolor":"#dddddd"}};}
		]);
		return TimeGridUI;
	})(View)


	//class laya.editor.ui.UIViewerUI extends laya.ui.View
	var UIViewerUI=(function(_super){
		function UIViewerUI(){
			this.viewStack=null;
			this.designView=null;
			this.codeView=null;
			this.scaleInfo=null;
			this.compInfo=null;
			this.typeBtn=null;
			UIViewerUI.__super.call(this);
		}

		__class(UIViewerUI,'laya.editor.ui.UIViewerUI',_super);
		var __proto=UIViewerUI.prototype;
		__proto.createChildren=function(){
			laya.ui.Component.prototype.createChildren.call(this);
			this.createView(UIViewerUI.uiView);
		}

		__static(UIViewerUI,
		['uiView',function(){return this.uiView={"child":[{"type":"Image","props":{"skin":"view/bg_panel.png","y":"-62","sizeGrid":"4,4,4,4","bottom":"0","left":"0","top":"0","right":"0","x":"482"}},{"child":[{"type":"Box","props":{"name":"item0","var":"designView","bottom":"2","width":"600","left":"2","height":"280","top":"2","right":"2"}},{"type":"TextArea","props":{"var":"codeView","text":"TextArea","top":"2","color":"#8080ff","fontSize":"14","name":"item1","leading":"10","x":"563","y":"445","bottom":"30","padding":"5,5,5,5","left":"2","font":"Consolas","right":"2","multiline":"true"}}],"type":"ViewStack","props":{"var":"viewStack","bottom":"28","left":"0","mouseEnabled":"true","y":"2283","top":"0","right":"0","x":"82"}},{"type":"Image","props":{"skin":"view/bg_panel_bar.png","y":"387","sizeGrid":"0,4,0,4","bottom":"0","left":"0","mouseEnabled":"true","right":"0","x":"5"}},{"type":"Label","props":{"var":"scaleInfo","bottom":"0","width":"102","mouseEnabled":"false","align":"right","height":"20","y":"378","color":"#333333","right":"10","x":"488"}},{"type":"Label","props":{"padding":"0,10,0,10","text":"label111","color":"#9f9f9f","bottom":"0","valign":"center","x":"35","y":"373","wordWrap":"false","width":"359","left":"35","align":"left","height":"22","var":"compInfo"}},{"type":"Image","props":{"skin":"comp/infoicon.png","y":"378","width":"14","left":"15","height":"14","bottom":"8","x":"4"}},{"type":"Clip","props":{"skin":"view/codeswitch.png","y":"379","right":"110","width":"70","clipY":"2","height":"18","var":"typeBtn","index":"0","bottom":"5","x":"420"}}],"type":"View","props":{"height":"400","hitTestPrior":"true","width":"600"}};}
		]);
		return UIViewerUI;
	})(View)


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2017-3-1 下午8:14:05
	*/
	//class laya.ide.hook.ViewHook extends laya.ui.View
	var ViewHook=(function(_super){
		function ViewHook(){
			ViewHook.__super.call(this);
		}

		__class(ViewHook,'laya.ide.hook.ViewHook',_super);
		var __proto=ViewHook.prototype;
		/**
		*@private
		*通过视图数据创建视图。
		*@param uiView 视图数据信息。
		*/
		__proto.createView1=function(uiView){
			ViewHook.adptUIView(uiView,true);
			if (uiView.animations && !this._idMap)this._idMap={};
			View.createComp(uiView,this,this);
			if (uiView.animations){
				var anilist=[];
				var animations=uiView.animations;
				var i=0,len=animations.length;
				var tAni;
				var tAniO;
				for (i=0;i < len;i++){
					tAni=new FrameAnimation();
					tAniO=animations[i];
					tAni._setUp(this._idMap,tAniO);
					this[tAniO.name]=tAni;
					tAni._setControlNode(this);
					switch (tAniO.action){
						case 1:
							tAni.play(0,false);
							break ;
						case 2:
							tAni.play(0,true);
							break ;
						}
					anilist.push(tAni);
				}
				this._aniList=anilist;
			}
			if (this._width > 0 && uiView.props.hitTestPrior==null && !this.mouseThrough)this.hitTestPrior=true;
		}

		ViewHook.init=function(){
			if(!ViewHook.I){
				ViewHook.I=new ViewHook();
				View["prototype"]["createView"]=ViewHook.I.createView1;
				View["setCompValue"]=ViewHook.setCompValue;
			}
		}

		ViewHook.setCompValue=function(comp,prop,value,view){
			if (prop==="var" && view){
				view[value]=comp;
			}
			else if (prop==="x" || prop==="y" || prop==="width" || prop==="height" || (typeof (comp[prop])=='number')){
				comp[prop]=parseFloat(value);
			}
			else {
				comp[prop]=(value==="true" ? true :(value==="false" ? false :value))
			}
		}

		ViewHook.adptUIView=function(uiView,isRoot){
			(isRoot===void 0)&& (isRoot=false);
			if(!((typeof uiView=='object')))return;
			if(uiView["adpted"])return;
			if(!Sys.langPack)return;
			var key;
			var tV;
			for(key in uiView){
				tV=uiView[key];
				if((typeof tV=='string')){
					uiView[key]=Sys.lang(tV);
					continue ;
				}
				if((tV instanceof Array)){
					var i=0,len=0;
					len=tV.length;
					for(i=0;i<len;i++){
						ViewHook.adptUIView(tV[i]);
					}
				};
				if((typeof tV=='object'))ViewHook.adptUIView(tV);
			}
			if(isRoot)
				uiView["adpted"]=true;
		}

		ViewHook.I=null
		ViewHook.__init$=function(){
			ViewHook.init();
		}

		return ViewHook;
	})(View)


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-7-18 下午2:46:28
	*/
	//class laya.ide.managers.HookedView extends laya.ui.View
	var HookedView=(function(_super){
		function HookedView(){
			HookedView.__super.call(this);
		}

		__class(HookedView,'laya.ide.managers.HookedView',_super);
		HookedView.recordConfig=function(rst){
			if(!rst)rst={};
			ObjectTools$1.clearObj(rst);
			var i=0,len=0;
			len=HookedView.StyleVars.length;
			var tKey;
			for(i=0;i<len;i++){
				tKey=HookedView.StyleVars[i];
				rst[tKey]=StyleConsts[tKey];
			}
			console.log(ObjectTools$1.getJsonString(rst));
			return rst;
		}

		HookedView.initStylesByObj=function(configO){
			var i=0,len=0;
			len=HookedView.StyleVars.length;
			var tKey;
			for(i=0;i<len;i++){
				tKey=HookedView.StyleVars[i];
				if(configO.hasOwnProperty(tKey))
					StyleConsts[tKey]=configO[tKey];
			}
		}

		HookedView.initByStyleFile=function(path){
			HookedView.initStylesByObj(HookedView.DefaultConfigO);
			if(!FileTools.exist(path))return;
			var config;
			try{
				config=FileManager.readJSONFile(path);
				HookedView.initStylesByObj(config);
				}catch(e){
				console.log("initStyleFileFail:",path);
			}
			HookedView.hookVars();
		}

		HookedView.hookView=function(){
			HookedView.recordConfig(HookedView.DefaultConfigO);
			View["createComp"]=HookedView.createCompT;
		}

		HookedView.hookVars=function(){
			laya.ide.managers.HookedView.registVar("Label","color","#c5c5c5",StyleConsts.DefaultTextColor);
			laya.ide.managers.HookedView.registVar("Label","color","#00cc00",StyleConsts.PanelTipTextColor);
			laya.ide.managers.HookedView.registVar("Label","color","#cccc00",StyleConsts.PanelTipTextColor2);
			laya.ide.managers.HookedView.registVar("TextInput","color","#c5c5c5",StyleConsts.TextInputColor);
			laya.ide.managers.HookedView.registVar("TextArea","color","#c5c5c5",StyleConsts.TextInputColor);
			laya.ide.managers.HookedView.registVar("ComboBox","labelColors","#c5c5c5,#c5c5c5,#c5c5c5,#c5c5c5",StyleConsts.ComboBoxLabelColors);
			laya.ide.managers.HookedView.registVar("CheckBox","labelColors","#c5c5c5,#c5c5c5,#c5c5c5,#c5c5c5",StyleConsts.CheckBoxLabelColors);
			laya.ide.managers.HookedView.registVar("Button","labelColors","#efefef,#ffffff,#c5c5c5,#c5c5c5",StyleConsts.ButtonLabelColors);
			laya.ide.managers.HookedView.registVar("Button","labelColors","#c5c5c5,#c5c5c5,#c5c5c5",StyleConsts.BroswerButtonLabelColors);
		}

		HookedView.InitDefaultStyles=function(){
			return;
			StyleConsts.DefaultTextColor="#ff0000";
			StyleConsts.TextInputColor="#ff0000,#ff0000,#ff0000,#ff0000";
			StyleConsts.LayoutTabTitleBtnColor="#ff0000,#ff0000,#ff0000,#ff0000";
			StyleConsts.CheckBoxLabelColors="#ff0000,#ff0000,#ff0000,#ff0000";
			StyleConsts.ButtonLabelColors="#ff0000,#ff0000,#ff0000,#ff0000";
			StyleConsts.BroswerButtonLabelColors="#ff0000,#ff0000,#ff0000,#ff0000";
			StyleConsts.PropPanelTitleColor="#ff0000";
			StyleConsts.FolderTxtColor="#ff0000";
			StyleConsts.ItemTxtColor="#ff0000";
			StyleConsts.ItemSelectColor="#ff0000";
			StyleConsts.MenuButtonLabelColor="#ff0000";
			StyleConsts.SkinBtnLabelColor="#ff0000";
			StyleConsts.TextInputColorDefault="#ff0000";
			StyleConsts.PanelTipTextColor="#ff0000";
			StyleConsts.PanelTipTextColor2="#ff0000";
			StyleConsts.SelectItemInfoColor="#ff0000";
			HookedView.recordConfig(null);
		}

		HookedView.registVar=function(type,prop,preValue,newValue){
			if(!HookedView.ConstVars[type])HookedView.ConstVars[type]={};
			if(!HookedView.ConstVars[type][prop])HookedView.ConstVars[type][prop]={};
			HookedView.ConstVars[type][prop][preValue]=newValue;
		}

		HookedView.hasVar=function(type,prop,preValue){
			if(!HookedView.ConstVars[type])return false;
			if(!HookedView.ConstVars[type][prop])return false;
			if(!HookedView.ConstVars[type][prop].hasOwnProperty(preValue))return false;
			return true;
		}

		HookedView.getVar=function(type,prop,preValue){
			return HookedView.ConstVars[type][prop][preValue];
		}

		HookedView.createCompT=function(uiView,comp,view){
			comp=comp || View.getCompInstance(uiView);
			var child=uiView.child;
			if (child){
				for (var i=0,n=child.length;i < n;i++){
					var node=child[i];
					if (comp.hasOwnProperty("itemRender")&& node.props.name=="render"){
						(comp).itemRender=node;
						}else {
						comp.addChild(View.createComp(node,null,view));
					}
				}
			};
			var props=uiView.props;
			for (var prop in props){
				var value=props[prop];
				if(HookedView.hasVar(uiView.type,prop,value)){
					value=HookedView.getVar(uiView.type,prop,value);
				}
				View["setCompValue"](comp,prop,value,view);
			}
			if (Laya.__typeof(comp,'laya.ui.IItem')){
				(comp).initItems();
			}
			if (uiView.compId&&view&&view["_idMap"]){
				view["_idMap"][uiView.compId]=comp;
			}
			return comp;
		}

		HookedView.DefaultConfigO={};
		HookedView.ConstVars={};
		__static(HookedView,
		['StyleVars',function(){return this.StyleVars=
			[
			"DefaultTextColor",
			"TextInputColor",
			"LayoutTabTitleBtnColor",
			"CheckBoxLabelColors",
			"ButtonLabelColors",
			"BroswerButtonLabelColors",
			"PropPanelTitleColor",
			"FolderTxtColor",
			"ItemTxtColor",
			"ItemSelectColor",
			"MenuButtonLabelColor",
			"SkinBtnLabelColor",
			"TextInputColorDefault",
			"PanelTipTextColor",
			"PanelTipTextColor2",
			"SelectItemInfoColor",
			"RuleGridLineColor",
			"RuleGridTextColor",
			"TimelineTitleTxtColor",
			"ComboBoxLabelColors",
			"RuleRangeColor"];}
		]);
		return HookedView;
	})(View)


	/**
	*...
	*@author ww
	*/
	//class laya.editor.view.group.GroupList extends laya.ui.Panel
	var GroupList=(function(_super){
		function GroupList(){
			this._groups=null;
			GroupList.__super.call(this);
			this.vScrollBarSkin="comp/vscroll.png";
			this.content.mouseEnabled=true;
		}

		__class(GroupList,'laya.editor.view.group.GroupList',_super);
		var __proto=GroupList.prototype;
		__proto.setGroups=function(groups){
			this.clearPreGroups();
			this._groups=groups;
			var i=0,len=0;
			var tGroup;
			len=groups.length;
			for (i=0;i < len;i++){
				tGroup=groups[i];
				tGroup.on("UIChange",this,this.freshUI);
				this.addChild(tGroup);
			}
			this.callLater(this.freshUI);
		}

		__proto.clearPreGroups=function(){
			if (!this._groups)return;
			var groups=this._groups;
			var i=0,len=0;
			var tGroup;
			len=groups.length;
			for (i=0;i < len;i++){
				tGroup=groups[i];
				tGroup.off("UIChange",this,this.freshUI);
				tGroup.removeSelf();
			}
		}

		__proto.changeSize=function(){
			_super.prototype.changeSize.call(this);
			this.callLater(this.freshUI);
		}

		__proto.freshUI=function(){
			var _panel=this;
			var y=0;
			for (var i=0,n=_panel.numChildren;i < n;i++){
				var item=_panel.getChildAt(i);
				if (item){
					item.y=y;
					y=y+item.height+5;
				}
			}
			Laya.timer.once(200,this,this.freshPanel,[_panel]);
		}

		__proto.freshPanel=function(_panel){
			_panel.refresh();
			this.event("UIChange");
		}

		return GroupList;
	})(Panel)


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-7-6 上午9:42:46
	*/
	//class laya.ide.ui.ListBase extends laya.ui.List
	var ListBase=(function(_super){
		function ListBase(){
			ListBase.__super.call(this);
		}

		__class(ListBase,'laya.ide.ui.ListBase',_super);
		var __proto=ListBase.prototype;
		__proto.scrollToIndex=function(value){
			if (this.selectEnable && this._scrollBar){
				var numX=this._isVertical ? this.repeatX :this.repeatY;
				if (value < this._startIndex || (value+numX > this._startIndex+this.repeatX *this.repeatY)){
					this.scrollTo(value);
				}
			}
		}

		__getset(0,__proto,'selectedIndex',_super.prototype._$get_selectedIndex,function(value){
			if (this._selectedIndex !=value){
				this._selectedIndex=value;
				this.changeSelectStatus();
				this.event("change");
				this.selectHandler && this.selectHandler.runWith(value);
			}
			if (this.selectEnable && this._scrollBar){
				var numX=this._isVertical ? this.repeatX :this.repeatY;
				if (value < this._startIndex || (value+numX > this._startIndex+this.repeatX *this.repeatY)){
					this.scrollTo(value);
				}
			}
		});

		return ListBase;
	})(List)


	/**
	*节点树基类
	*@author ww
	*@version 1.0
	*
	*@created 2015-12-25 下午2:21:31
	*/
	//class laya.ide.ui.NodeTree extends laya.ui.Tree
	var NodeTree=(function(_super){
		function NodeTree(){
			this._treeData=null;
			this.arrFilterFun=null;
			NodeTree.__super.call(this);
			this.spaceLeft=15;
		}

		__class(NodeTree,'laya.ide.ui.NodeTree',_super);
		var __proto=NodeTree.prototype;
		// list.spaceY=2;
		__proto.refreshList=function(){
			this._list.array=this.getArray();
		}

		__proto.selectByCompId=function(compId){
			var arr;
			arr=this.list.array;
			var i=0,len=0;
			len=arr.length;
			var tItem;
			for(i=0;i<len;i++){
				tItem=arr[i];
				if(tItem.compId==compId){
					this.list.selectedIndex=i;
					return;
				}
			}
		}

		__proto.setTreeData=function(treeData){
			this._treeData=treeData;
			var treeArr;
			treeArr=treeData.getTreeArr();
			if(this.arrFilterFun!=null){
				this.array=this.arrFilterFun(treeArr);
				}else{
				this.array=treeArr;
			}
		}

		// trace("treeArr:",treeArr);
		__proto.getDepth=function(item,num){
			(num===void 0)&& (num=0);
			if(!this._treeData){
				return _super.prototype.getDepth.call(this,item,num);
			};
			var parent;
			parent=this._treeData.getNodeParent(item);
			if (parent==null)return num;
			else return this.getDepth(parent,num+1);
		}

		/**
		*@private
		*获取项对象的上一级的打开状态。
		*@param item
		*@return
		*/
		__proto.getParentOpenStatus=function(item){
			if(!this._treeData){
				return _super.prototype.getParentOpenStatus.call(this,item);
			};
			var parent=this._treeData.getNodeParent(item);
			if (parent==null){
				return true;
				}else {
				if (parent.isOpen){
					if (this._treeData.getNodeParent(parent)!=null)return this.getParentOpenStatus(parent);
					else return true;
					}else {
					return false;
				}
			}
		}

		__proto.getParentIndex=function(item){
			if(!this._treeData){
				return this.getIndexByData(item.nodeParent);
			}
			return-1;
		}

		__proto.getIndexByData=function(dis){
			var dataList;
			dataList=this.list.array;
			var i=0,len=0;
			len=dataList.length;
			for (i=0;i < len;i++){
				if (dataList[i]==dis){
					return i;
				}
			}
			return-1;
		}

		/**
		*@private
		*判断两个项对象在树结构中的父节点是否相同。
		*@param item1 项对象。
		*@param item2 项对象。
		*@return
		*/
		__proto.isSameParent=function(item1,item2){
			if(!this._treeData){
				return _super.prototype.isSameParent.call(this,item1,item2);
			};
			var parent1;
			var parent2;
			parent1=this._treeData.getNodeParent(item1);
			parent2=this._treeData.getNodeParent(item2);
			if (parent1==null && parent2==null)return true;
			else if (parent1==null || parent2==null)return false
			else {
				if (parent1.label==parent2.label)return this.isSameParent(parent1,parent2);
				else return false;
			}
		}

		__proto.isSameNode=function(tarA,tarB){
			if(!tarA)return false;
			if(!tarB)return false;
			if(tarA==tarB)return true;
			if(tarA.compId){
				if(tarA.compId==tarB.compId)return true;
				return false;
			}
			return tarA.label==tarB.label;
		}

		/**
		*@private
		*处理数据项的打开状态。
		*/
		__proto.parseOpenStatus=function(oldSource,newSource){
			for (var i=0,n=newSource.length;i < n;i++){
				var newItem=newSource[i];
				if (newItem.isDirectory){
					for (var j=0,m=oldSource.length;j < m;j++){
						var oldItem=oldSource[j];
						if (oldItem.isDirectory && this.isSameNode(oldItem,newItem)){
							newItem.isOpen=oldItem.isOpen;
							break ;
						}
					}
				}
			}
		}

		NodeTree.TreeSpaceLeft=15;
		return NodeTree;
	})(Tree)


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-7-6 上午9:49:47
	*/
	//class laya.ide.ui.TreeBase extends laya.ui.Tree
	var TreeBase=(function(_super){
		function TreeBase(){
			TreeBase.__super.call(this);
		}

		__class(TreeBase,'laya.ide.ui.TreeBase',_super);
		var __proto=TreeBase.prototype;
		/**@inheritDoc */
		__proto.createChildren=function(){
			this.addChild(this._list=new ListBase());
			this._list.renderHandler=Handler.create(this,this.renderItem,null,false);
			this._list.repeatX=1;
			this._list.on("change",this,this.onListChange);
		}

		return TreeBase;
	})(Tree)


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-8-12 上午11:35:20
	*/
	//class laya.rendercanvas.IFrameSprite extends laya.rendercanvas.HtmlSprite
	var IFrameSprite=(function(_super){
		function IFrameSprite(){
			IFrameSprite.__super.call(this);
		}

		__class(IFrameSprite,'laya.rendercanvas.IFrameSprite',_super);
		var __proto=IFrameSprite.prototype;
		__proto.createHtml=function(){
			this.div=Browser.createElement("iframe");
			this.div.style.border="0px";
		}

		__proto.setUrl=function(path){
			this.div.src=path;
		}

		return IFrameSprite;
	})(HtmlSprite)


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-8-9 下午2:22:33
	*/
	//class laya.rendercanvas.JSPlugin extends laya.rendercanvas.HtmlSprite
	var JSPlugin=(function(_super){
		function JSPlugin(){
			this.title="我是插件";
			JSPlugin.__super.call(this);
		}

		__class(JSPlugin,'laya.rendercanvas.JSPlugin',_super);
		var __proto=JSPlugin.prototype;
		__proto.show=function(){
			LayoutRecManager.showPanelToStage(this);
		}

		__proto.close=function(){
			LayoutRecManager.removePanel(this);
		}

		JSPlugin.loadPlugin=function(plugin){
			(plugin===void 0)&& (plugin="testplugin");
			var htmlSp;
			var uiFile;
			uiFile=FileManager.readTxtFile(FileManager.getAppPath("h5/plugins/"+plugin+"/ui.div"));
			var jsFile;
			jsFile=FileManager.readTxtFile(FileManager.getAppPath("h5/plugins/"+plugin+"/code.js"));
			htmlSp=new JSPlugin();
			htmlSp.setHtmlTxt(uiFile);
			htmlSp.title=plugin;
			eval(jsFile);
			window.tPlugin.setUI(htmlSp.div);
			return htmlSp;
		}

		return JSPlugin;
	})(HtmlSprite)


	//class laya.editor.ui.comp.AlertUI extends laya.ui.Dialog
	var AlertUI=(function(_super){
		function AlertUI(){
			this.titleLbl=null;
			this.msgLbl=null;
			AlertUI.__super.call(this);
		}

		__class(AlertUI,'laya.editor.ui.comp.AlertUI',_super);
		var __proto=AlertUI.prototype;
		__proto.createChildren=function(){
			laya.ui.Component.prototype.createChildren.call(this);
			this.createView(AlertUI.uiView);
		}

		__static(AlertUI,
		['uiView',function(){return this.uiView={"child":[{"type":"Image","props":{"skin":"view/bg_dialog.png","y":"0","sizeGrid":"60,10,10,10","width":"450","height":"180","x":"0"}},{"type":"Button","props":{"skin":"view/btn_close.png","name":"close","scaleY":"0.5","scaleX":"0.5","top":"18","right":"18"}},{"type":"Image","props":{"skin":"comp/blank.png","y":"8","width":"397","height":"38","name":"drag","x":"9"}},{"type":"Label","props":{"y":"18","text":"提示","var":"titleLbl","color":"#c5c5c5","fontSize":"14","x":"28"}},{"type":"Label","props":{"text":"确认内容","mouseEnabled":"false","color":"#c5c5c5","multiline":"true","x":"43","isHtml":"true","y":"66","wordWrap":"true","width":"364","align":"center","height":"56","var":"msgLbl","mouseChildren":"false"}},{"type":"Button","props":{"skin":"comp/button.png","name":"sure","sizeGrid":"0,4,0,4","label":"确定","x":"182","y":"123","labelColors":"#efefef,#ffffff,#c5c5c5,#c5c5c5"}}],"type":"Dialog","props":{"height":"180","scenecolor":"#dddddd","width":"450"}};}
		]);
		return AlertUI;
	})(Dialog)


	//class laya.editor.ui.comp.ConfirmUI extends laya.ui.Dialog
	var ConfirmUI=(function(_super){
		function ConfirmUI(){
			this.titleLbl=null;
			this.msgLbl=null;
			this.cancelBtn=null;
			this.okBtn=null;
			ConfirmUI.__super.call(this);
		}

		__class(ConfirmUI,'laya.editor.ui.comp.ConfirmUI',_super);
		var __proto=ConfirmUI.prototype;
		__proto.createChildren=function(){
			laya.ui.Component.prototype.createChildren.call(this);
			this.createView(ConfirmUI.uiView);
		}

		__static(ConfirmUI,
		['uiView',function(){return this.uiView={"child":[{"type":"Image","props":{"skin":"view/bg_dialog.png","y":"0","sizeGrid":"60,10,10,10","width":"450","height":"180","x":"0"}},{"type":"Button","props":{"skin":"view/btn_close.png","name":"close","scaleY":"0.5","scaleX":"0.5","top":"18","right":"18"}},{"type":"Image","props":{"skin":"comp/blank.png","y":"8","width":"397","height":"38","name":"drag","x":"9"}},{"type":"Label","props":{"y":"18","text":"确认框","var":"titleLbl","color":"#c5c5c5","fontSize":"14","x":"28"}},{"type":"Label","props":{"text":"确认内容","mouseEnabled":"false","color":"#c5c5c5","multiline":"true","x":"35.5","isHtml":"true","y":"67","wordWrap":"true","width":"379","align":"center","height":"54","var":"msgLbl","mouseChildren":"false"}},{"type":"Button","props":{"skin":"comp/btn.png","name":"cancel","var":"cancelBtn","label":"取消","labelColors":"#efefef,#ffffff,#c5c5c5,#c5c5c5","y":"125","sizeGrid":"0,4,0,4","x":"247"}},{"type":"Button","props":{"skin":"comp/button.png","name":"sure","var":"okBtn","label":"确定","labelColors":"#efefef,#ffffff,#c5c5c5,#c5c5c5","y":"125","sizeGrid":"0,4,0,4","x":"117"}}],"type":"Dialog","props":{"height":"180","scenecolor":"#dddddd","width":"450"}};}
		]);
		return ConfirmUI;
	})(Dialog)


	//class laya.editor.ui.comp.WaitingUI extends laya.ui.Dialog
	var WaitingUI=(function(_super){
		function WaitingUI(){
			this.titleLbl=null;
			this.msgLbl=null;
			WaitingUI.__super.call(this);
		}

		__class(WaitingUI,'laya.editor.ui.comp.WaitingUI',_super);
		var __proto=WaitingUI.prototype;
		__proto.createChildren=function(){
			laya.ui.Component.prototype.createChildren.call(this);
			this.createView(WaitingUI.uiView);
		}

		__static(WaitingUI,
		['uiView',function(){return this.uiView={"child":[{"type":"Image","props":{"skin":"view/bg_dialog.png","y":"0","sizeGrid":"60,10,10,10","width":"450","height":"180","x":"0"}},{"type":"Image","props":{"skin":"comp/blank.png","y":"8","width":"433","height":"38","name":"drag","x":"9"}},{"type":"Label","props":{"var":"titleLbl","text":"处理中","y":"18","color":"#dddddd","fontSize":"14","x":"28"}},{"type":"Label","props":{"height":"49","var":"msgLbl","wordWrap":"true","text":"确认内容","width":"386","align":"center","multiline":"true","y":"89","color":"#dddddd","isHtml":"true","x":"29.5"}}],"type":"Dialog","props":{"height":"180","scenecolor":"#dddddd","width":"450"}};}
		]);
		return WaitingUI;
	})(Dialog)


	/**
	*...
	*@author ww
	*/
	//class laya.editor.comonents.ColorPickerPanel extends laya.editor.ui.other.ColorPickerPanelUI
	var ColorPickerPanel=(function(_super){
		function ColorPickerPanel(){
			this.prePickerItem=null;
			this.picker=null;
			ColorPickerPanel.__super.call(this);
			this.createUI();
			CanvasSprite.setSpriteCanvasRender(this,101);
		}

		__class(ColorPickerPanel,'laya.editor.comonents.ColorPickerPanel',_super);
		var __proto=ColorPickerPanel.prototype;
		__proto.createUI=function(){
			this.picker=new ColorSelector();
			this.pickBack.addChild(this.picker);
			this.picker.on("ColorChanged",this,this.updateToUI);
			this.updateToUI();
			this.addTxtChangeH(this.colorTxt,this.colorTxtChange);
			this.addTxtChangeH(this.redTxt,this.rgbTxtChange);
			this.addTxtChangeH(this.greenTxt,this.rgbTxtChange);
			this.addTxtChangeH(this.blueTxt,this.rgbTxtChange);
		}

		__proto.addTxtChangeH=function(tar,fun){
			tar.on("enter",this,fun);
			tar.on("blur",this,fun);
		}

		__proto.updateToUI=function(){
			var rgb;
			rgb=this.picker.tColor;
			this.setColorTxts(rgb,true);
		}

		__proto.setColor=function(rgb){
			this.setColorTxts(rgb);
		}

		__proto.setColorTxts=function(rgb,fromPicker){
			(fromPicker===void 0)&& (fromPicker=false);
			this.colorTxt.text=ColorTool.getRGBStr(rgb);
			this.redTxt.text=Math.floor(rgb[0])+"";
			this.greenTxt.text=Math.floor(rgb[1])+"";
			this.blueTxt.text=Math.floor(rgb[2])+"";
			if(!fromPicker)
				this.picker.setColor(rgb[0],rgb[1],rgb[2],false);
			this.event("ColorChanged",this);
		}

		__proto.colorTxtChange=function(){
			if(this.colorTxt.text==""){
				this.event("COLOR_CLEARED",this);
				return;
			};
			var rgb;
			rgb=ColorTool.getRGBByRGBStr(this.colorTxt.text);
			this.setColorTxts(rgb);
		}

		__proto.rgbTxtChange=function(){
			var rgb;
			rgb=[this.getInt(this.redTxt.text),this.getInt(this.greenTxt.text),this.getInt(this.blueTxt.text)];
			this.setColorTxts(rgb);
		}

		__proto.getInt=function(str){
			return Math.floor(parseFloat(str));
		}

		__proto.updateFromUI=function(){}
		return ColorPickerPanel;
	})(ColorPickerPanelUI)


	/**
	*布局框标签
	*@author ww
	*/
	//class laya.editor.comonents.LayoutTab extends laya.editor.ui.comp.LayoutTabUI
	var LayoutTab=(function(_super){
		function LayoutTab(tabUI){
			this._ui=null;
			this._rec=null;
			LayoutTab.__super.call(this);
			this._ui=tabUI;
			this._ui.left=this._ui.right=this._ui.bottom=0;
			if((this._ui instanceof laya.rendercanvas.HtmlSprite )){
				this._ui.left=this._ui.right=this._ui.bottom=5;
			}
			this._ui.top=25;
			if(!this.canMix){
				this._ui.top=0;
			}
			this.close.on("click",this,this.onCloseClick);
			this.btn.on("mousedown",this,this.onBtnDown);
			this.onTitleChange();
			if(!this.canClose){
				this.close.visible=false;
			}
			this.btn.labelAlign="left";
			this.btn.labelPadding="-2,5,0,5"
			this.btn.labelColors=StyleConsts.LayoutTabTitleBtnColor;
		}

		__class(LayoutTab,'laya.editor.comonents.LayoutTab',_super);
		var __proto=LayoutTab.prototype;
		__proto.onBtnDown=function(e){
			if(LayoutRecManager.popLocked())return;
			if(this._rec&&!this._rec.canDragMe)return;
			var clip=new Clip(SkinDefines.LayoutTabDragIcon,1,3);
			clip.index=2;
			var type="LayoutTab";
			LayaBuilder.drag.doDrag(this ,clip,{type:type,target:this._rec},DragManager.dragOffset);
		}

		__proto.onCloseClick=function(e){
			if(this._rec)
				this._rec.removeTab(this,true);
			this.clears();
		}

		__proto.onTitleChange=function(e){
			var title;
			title=this._ui["title"]?this._ui["title"]:"我是标题啊";
			var len=ObjectUtils.getTextField(null,"*"+title).width+20;
			this.btn.width=len;
			this.close.x=len-this.close.displayWidth-3;
			this.btn.label=title;
		}

		__proto.clears=function(){
			this._ui=null;
		}

		__getset(0,__proto,'ui',function(){
			return this._ui;
		});

		__getset(0,__proto,'canClose',function(){
			if(!this._ui)return true;
			return this._ui["canClose"];
		});

		/**点击处理器(无默认参数)*/
		__getset(0,__proto,'clickHandler',function(){
			return this.btn.clickHandler;
			},function(value){
			this.btn.clickHandler=value;
		});

		__getset(0,__proto,'canMix',function(){
			if(!this._ui||!this._ui.hasOwnProperty("canMix"))return true;
			return this._ui["canMix"];
		});

		__getset(0,__proto,'freeSize',function(){
			if(!this._ui||!this._ui.hasOwnProperty("freeSize"))return false;
			return this._ui["freeSize"];
		});

		__getset(0,__proto,'width',function(){
			return this.btn.width;
		},_super.prototype._$set_width);

		/**是否是选择状态*/
		__getset(0,__proto,'selected',function(){
			return this.btn.selected;
			},function(value){
			this.btn.selected=value;
		});

		return LayoutTab;
	})(LayoutTabUI)


	/**视图标签
	*@author yung
	*/
	//class laya.editor.comonents.ViewTab extends laya.editor.ui.comp.viewTabUI
	var ViewTab=(function(_super){
		function ViewTab(uiViewer,tip){
			this._uiViewer=null;
			ViewTab.__super.call(this);
			this._uiViewer=uiViewer;
			uiViewer.left=uiViewer.right=uiViewer.bottom=0;
			uiViewer.top=0;
			if ((uiViewer instanceof laya.editor.view.UIViewer )){
				uiViewer.design.on("change",this,this.onDesignChange);
				}else{
				Laya.stage.on("pageChanged",this,this.onDesignChange);
			}
			this.onDesignChange(null);
			this.close.on("click",this,this.onCloseClick);
			this.btn.labelAlign="left";
			this.btn.labelPadding="-2,5,0,5"
			this.btn.labelColors=StyleConsts.LayoutTabTitleBtnColor;
			this.toolTip=tip?tip:FileManager.getRelativePath(SystemSetting.pagesPath,uiViewer.pagePath);
		}

		__class(ViewTab,'laya.editor.comonents.ViewTab',_super);
		var __proto=ViewTab.prototype;
		__proto.onCloseClick=function(e){
			UIPanel.instance.tryToClose(this._uiViewer);
		}

		//e.stopPropagation();
		__proto.onDesignChange=function(e){
			var len=ObjectUtils.getTextField(null,"*"+this._uiViewer.title).width+25;
			this.btn.width=len;
			this.close.x=len-this.close.displayWidth-3;
			this.btn.label=(this._uiViewer.hasChange ? "*" :"")+this._uiViewer.title;
		}

		__getset(0,__proto,'width',function(){
			return this.btn.width;
		},_super.prototype._$set_width);

		__getset(0,__proto,'uiViewer',function(){
			return this._uiViewer;
		});

		/**点击处理器(无默认参数)*/
		__getset(0,__proto,'clickHandler',function(){
			return this.btn.clickHandler;
			},function(value){
			this.btn.clickHandler=value;
		});

		/**是否是选择状态*/
		__getset(0,__proto,'selected',function(){
			return this.btn.selected;
			},function(value){
			this.btn.selected=value;
		});

		return ViewTab;
	})(viewTabUI)


	//class laya.editor.ui.other.BoxCompUI extends laya.ui.Dialog
	var BoxCompUI=(function(_super){
		function BoxCompUI(){
			this.typeDrop=null;
			BoxCompUI.__super.call(this);
		}

		__class(BoxCompUI,'laya.editor.ui.other.BoxCompUI',_super);
		var __proto=BoxCompUI.prototype;
		__proto.createChildren=function(){
			laya.ui.Component.prototype.createChildren.call(this);
			this.createView(BoxCompUI.uiView);
		}

		__static(BoxCompUI,
		['uiView',function(){return this.uiView={"child":[{"type":"Image","props":{"skin":"view/bg_dialog.png","y":"0","sizeGrid":"60,10,10,10","width":"470","height":"230","x":"0"}},{"type":"Button","props":{"skin":"view/btn_close.png","name":"close","scaleY":"0.5","scaleX":"0.5","top":"18","right":"18"}},{"type":"Image","props":{"skin":"comp/blank.png","y":"8","width":"418","height":"38","name":"drag","x":"9"}},{"type":"Label","props":{"y":"18","color":"#c5c5c5","fontSize":"14","text":"转换为容器","x":"28"}},{"type":"Label","props":{"y":"70","text":"容器类型：","width":"129","height":"18","color":"#c5c5c5","x":"40"}},{"type":"Button","props":{"skin":"comp/button.png","y":"165","sizeGrid":"0,4,0,4","label":"确定","x":"192","name":"sure","labelColors":"#efefef,#ffffff,#c5c5c5,#c5c5c5"}},{"type":"ComboBox","props":{"skin":"comp/combo_32.png","y":"104","sizeGrid":"0,20,0,3","width":"390","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5,#c5c5c5","height":"32","var":"typeDrop","scrollBarSkin":"comp/vscroll.png","x":"40.5"}}],"type":"Dialog","props":{"height":"230","scenecolor":"#dddddd","width":"470"}};}
		]);
		return BoxCompUI;
	})(Dialog)


	//class laya.editor.ui.other.ChangeCompTypeUI extends laya.ui.Dialog
	var ChangeCompTypeUI=(function(_super){
		function ChangeCompTypeUI(){
			this.typeDrop=null;
			ChangeCompTypeUI.__super.call(this);
		}

		__class(ChangeCompTypeUI,'laya.editor.ui.other.ChangeCompTypeUI',_super);
		var __proto=ChangeCompTypeUI.prototype;
		__proto.createChildren=function(){
			laya.ui.Component.prototype.createChildren.call(this);
			this.createView(ChangeCompTypeUI.uiView);
		}

		__static(ChangeCompTypeUI,
		['uiView',function(){return this.uiView={"child":[{"type":"Image","props":{"skin":"view/bg_dialog.png","y":"0","sizeGrid":"60,10,10,10","width":"470","height":"230","x":"0"}},{"type":"Button","props":{"skin":"view/btn_close.png","name":"close","scaleY":"0.5","scaleX":"0.5","top":"18","right":"18"}},{"type":"Image","props":{"skin":"comp/blank.png","y":"8","width":"418","height":"38","name":"drag","x":"9"}},{"type":"Label","props":{"y":"18","color":"#c5c5c5","fontSize":"14","text":"转换类型","x":"28"}},{"type":"Label","props":{"y":"70","text":"组件类型：","width":"129","height":"18","color":"#c5c5c5","x":"40"}},{"type":"Button","props":{"skin":"comp/button.png","y":"165","sizeGrid":"0,4,0,4","label":"确定","x":"192","name":"sure","labelColors":"#efefef,#ffffff,#c5c5c5,#c5c5c5"}},{"type":"ComboBox","props":{"skin":"comp/combo_32.png","y":"104","sizeGrid":"0,20,0,3","width":"390","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5,#c5c5c5","height":"32","var":"typeDrop","scrollBarSkin":"comp/vscroll.png","x":"40.5"}}],"type":"Dialog","props":{"height":"230","scenecolor":"#dddddd","width":"470"}};}
		]);
		return ChangeCompTypeUI;
	})(Dialog)


	//class laya.editor.ui.other.ConvertProjectUI extends laya.ui.Dialog
	var ConvertProjectUI=(function(_super){
		function ConvertProjectUI(){
			this.pathTxt=null;
			this.browseBtn=null;
			this.pathOldTxt=null;
			this.browseOldBtn=null;
			ConvertProjectUI.__super.call(this);
		}

		__class(ConvertProjectUI,'laya.editor.ui.other.ConvertProjectUI',_super);
		var __proto=ConvertProjectUI.prototype;
		__proto.createChildren=function(){
			laya.ui.Component.prototype.createChildren.call(this);
			this.createView(ConvertProjectUI.uiView);
		}

		__static(ConvertProjectUI,
		['uiView',function(){return this.uiView={"child":[{"type":"Image","props":{"skin":"view/bg_dialog.png","y":"0","sizeGrid":"60,10,10,10","width":"530","height":"290","x":"0"}},{"type":"Button","props":{"skin":"view/btn_close.png","name":"close","scaleY":"0.5","scaleX":"0.5","top":"18","right":"18"}},{"type":"Image","props":{"skin":"comp/blank.png","y":"8","width":"478","height":"38","name":"drag","x":"9"}},{"type":"Label","props":{"y":"18","color":"#c5c5c5","fontSize":"14","text":"转换项目","x":"28"}},{"type":"Button","props":{"skin":"comp/button.png","name":"sure","sizeGrid":"0,4,0,4","label":"确定","centerX":"0","bottom":"24","width":"100","labelColors":"#efefef,#ffffff,#c5c5c5,#c5c5c5"}},{"type":"TextInput","props":{"skin":"comp/input_32.png","var":"pathTxt","sizeGrid":"0,3,0,3","width":"406","height":"32","y":"144","color":"#c5c5c5","x":"32"}},{"type":"Button","props":{"skin":"comp/btn_browser.png","var":"browseBtn","text":"项目名称：","label":"浏览","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5","height":"32","y":"144","width":"60","x":"438"}},{"type":"TextInput","props":{"skin":"comp/input_32.png","var":"pathOldTxt","sizeGrid":"0,3,0,3","width":"406","height":"32","y":"86","color":"#c5c5c5","x":"32"}},{"type":"Button","props":{"skin":"comp/btn_browser.png","var":"browseOldBtn","text":"项目名称：","label":"浏览","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5","height":"32","y":"86","width":"60","x":"438"}},{"type":"Label","props":{"y":"58","wordWrap":"true","text":"项目转换可以把旧的MornUI项目转换成LayaUI项目。","width":"466","height":"23","color":"#3399ff","fontSize":"12","x":"34"}}],"type":"Dialog","props":{"height":"290","scenecolor":"#dddddd","width":"530"}};}
		]);
		return ConvertProjectUI;
	})(Dialog)


	//class laya.editor.ui.other.FindAndReplaceUI extends laya.ui.Dialog
	var FindAndReplaceUI=(function(_super){
		function FindAndReplaceUI(){
			this.msgTxt=null;
			this.list=null;
			this.findTxt=null;
			this.replaceTxt=null;
			this.findBtn=null;
			this.replaceBtn=null;
			FindAndReplaceUI.__super.call(this);
		}

		__class(FindAndReplaceUI,'laya.editor.ui.other.FindAndReplaceUI',_super);
		var __proto=FindAndReplaceUI.prototype;
		__proto.createChildren=function(){
			laya.ui.Component.prototype.createChildren.call(this);
			this.createView(FindAndReplaceUI.uiView);
		}

		__static(FindAndReplaceUI,
		['uiView',function(){return this.uiView={"child":[{"type":"Image","props":{"skin":"view/bg_dialog.png","y":"0","sizeGrid":"60,10,10,10","width":"500","height":"380","x":"0"}},{"type":"Button","props":{"skin":"view/btn_close.png","name":"close","scaleY":"0.5","scaleX":"0.5","top":"18","right":"18"}},{"type":"Image","props":{"skin":"comp/blank.png","y":"8","width":"449","height":"38","name":"drag","x":"9"}},{"type":"Label","props":{"y":"18","color":"#c5c5c5","fontSize":"14","text":"查找替换","x":"28"}},{"type":"Image","props":{"skin":"view/bg_panel.png","y":"214","sizeGrid":"4,4,4,4","width":"454","height":"144","x":"24"}},{"type":"Label","props":{"y":"193","text":"共找到 {0} 个页面，双击列表打开页面","width":"454","height":"18","var":"msgTxt","color":"#c5c5c5","x":"25"}},{"child":[{"child":[{"type":"Clip","props":{"skin":"comp/clip_selectBox.png","name":"selectBox","left":"0","height":"24","right":"0","clipY":"2"}},{"type":"Label","props":{"name":"label","text":"label","width":"150","left":"10","height":"24","color":"#c5c5c5","right":"80","x":"20"}}],"type":"Box","props":{"name":"render","right":"0","left":"0"}}],"type":"List","props":{"repeatX":"1","vScrollBarSkin":"comp/vscroll.png","var":"list","width":"450","height":"140","y":"217","x":"26"}},{"type":"Label","props":{"y":"67.5","text":"查找文本：","width":"108","align":"right","height":"18","color":"#c5c5c5","x":"6"}},{"type":"TextInput","props":{"skin":"comp/input_32.png","y":"63","sizeGrid":"0,3,0,3","width":"315","height":"32","var":"findTxt","color":"#c5c5c5","x":"117"}},{"type":"Label","props":{"y":"107","text":"替换文本：","width":"114","align":"right","height":"18","color":"#c5c5c5","x":"0"}},{"type":"TextInput","props":{"skin":"comp/input_32.png","y":"103","sizeGrid":"0,3,0,3","width":"315","height":"32","var":"replaceTxt","color":"#c5c5c5","x":"117"}},{"type":"Button","props":{"skin":"comp/button.png","var":"findBtn","sizeGrid":"0,4,0,4","label":"查找","labelColors":"#efefef,#ffffff,#c5c5c5,#c5c5c5","y":"147","width":"100","x":"128"}},{"type":"Button","props":{"skin":"comp/btn.png","var":"replaceBtn","sizeGrid":"0,4,0,4","width":"100","labelColors":"#efefef,#ffffff,#c5c5c5,#c5c5c5","y":"147","label":"替换","x":"272"}}],"type":"Dialog","props":{"height":"380","scenecolor":"#dddddd","width":"500"}};}
		]);
		return FindAndReplaceUI;
	})(Dialog)


	//class laya.editor.ui.other.FindUnUsedResUI extends laya.ui.Dialog
	var FindUnUsedResUI=(function(_super){
		function FindUnUsedResUI(){
			this.resultBox=null;
			this.msgTxt=null;
			this.delBtn=null;
			this.checkSelectAll=null;
			this.list=null;
			this.findBtn=null;
			FindUnUsedResUI.__super.call(this);
		}

		__class(FindUnUsedResUI,'laya.editor.ui.other.FindUnUsedResUI',_super);
		var __proto=FindUnUsedResUI.prototype;
		__proto.createChildren=function(){
			laya.ui.Component.prototype.createChildren.call(this);
			this.createView(FindUnUsedResUI.uiView);
		}

		__static(FindUnUsedResUI,
		['uiView',function(){return this.uiView={"child":[{"type":"Image","props":{"skin":"view/bg_dialog.png","y":"0","sizeGrid":"60,10,10,10","width":"500","height":"380","x":"0"}},{"type":"Button","props":{"skin":"view/btn_close.png","name":"close","scaleY":"0.5","scaleX":"0.5","top":"18","right":"18"}},{"type":"Image","props":{"skin":"comp/blank.png","y":"8","width":"450","height":"38","name":"drag","x":"9"}},{"type":"Label","props":{"y":"18","color":"#c5c5c5","fontSize":"14","text":"查找未被使用的资源","x":"28"}},{"type":"Image","props":{"skin":"view/bg_panel.png","y":"158","sizeGrid":"4,4,4,4","width":"454","height":"200","x":"24"}},{"child":[{"type":"Label","props":{"var":"msgTxt","color":"#c5c5c5","text":"共找到 {0} 个资源"}},{"type":"Button","props":{"skin":"comp/btn.png","var":"delBtn","sizeGrid":"0,4,0,4","width":"50","labelColors":"#efefef,#ffffff,#c5c5c5,#c5c5c5","height":"20","y":"0","label":"删除","x":"347"}},{"type":"CheckBox","props":{"skin":"comp/checkbox.png","y":"3","label":"全选","x":"410","var":"checkSelectAll","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5,#c5c5c5"}},{"child":[{"child":[{"type":"Clip","props":{"skin":"comp/clip_selectBox.png","name":"selectBox","left":"0","height":"24","right":"0","clipY":"2"}},{"type":"Label","props":{"name":"label","text":"label","width":"360","height":"24","y":"0","color":"#c5c5c5","x":"5"}},{"type":"CheckBox","props":{"skin":"comp/checkbox.png","y":"4","width":"13","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5,#c5c5c5","height":"13","name":"check","x":"409"}}],"type":"Box","props":{"name":"render","right":"0","left":"0"}}],"type":"List","props":{"vScrollBarSkin":"comp/vscroll.png","var":"list","width":"450","height":"195","y":"26","x":"1"}}],"type":"Box","props":{"var":"resultBox","y":"135","x":"25"}},{"type":"Button","props":{"skin":"comp/button.png","y":"63","sizeGrid":"0,4,0,4","width":"120","labelColors":"#efefef,#ffffff,#c5c5c5,#c5c5c5","height":"40","var":"findBtn","label":"查找","x":"190"}}],"type":"Dialog","props":{"height":"380","scenecolor":"#dddddd","width":"500"}};}
		]);
		return FindUnUsedResUI;
	})(Dialog)


	//class laya.editor.ui.other.LangPanelUI extends laya.ui.Dialog
	var LangPanelUI=(function(_super){
		function LangPanelUI(){
			this.langPath=null;
			this.langPathBtn=null;
			LangPanelUI.__super.call(this);
		}

		__class(LangPanelUI,'laya.editor.ui.other.LangPanelUI',_super);
		var __proto=LangPanelUI.prototype;
		__proto.createChildren=function(){
			laya.ui.Component.prototype.createChildren.call(this);
			this.createView(LangPanelUI.uiView);
		}

		__static(LangPanelUI,
		['uiView',function(){return this.uiView={"child":[{"type":"Image","props":{"skin":"view/bg_dialog.png","y":"0","sizeGrid":"60,10,10,10","width":"450","height":"220","x":"0"}},{"type":"Button","props":{"skin":"view/btn_close.png","name":"close","scaleY":"0.5","scaleX":"0.5","top":"18","right":"18"}},{"type":"Image","props":{"skin":"comp/blank.png","y":"8","width":"396","height":"38","name":"drag","x":"9"}},{"type":"Label","props":{"y":"18","color":"#c5c5c5","fontSize":"14","text":"导出语言包","x":"28"}},{"type":"Button","props":{"skin":"comp/button.png","name":"sure","sizeGrid":"0,4,0,4","label":"确定","labelColors":"#efefef,#ffffff,#c5c5c5,#c5c5c5","height":"30","y":"158","width":"100","x":"100"}},{"type":"Button","props":{"skin":"comp/btn.png","name":"cancel","sizeGrid":"0,4,0,4","width":"100","labelColors":"#efefef,#ffffff,#c5c5c5,#c5c5c5","height":"30","y":"158","label":"取消","x":"250"}},{"type":"Label","props":{"y":"90","text":"导出路径：","width":"117","align":"right","height":"20","color":"#c5c5c5","x":"9"}},{"type":"TextInput","props":{"skin":"comp/input_32.png","y":"85","sizeGrid":"0,3,0,3","width":"200","height":"32","var":"langPath","color":"#c5c5c5","x":"134"}},{"type":"Button","props":{"skin":"comp/btn_browser.png","y":"85","text":"项目名称：","width":"50","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5","height":"32","var":"langPathBtn","label":"浏览","x":"335"}}],"type":"Dialog","props":{"scenecolor":"#dddddd"}};}
		]);
		return LangPanelUI;
	})(Dialog)


	//class laya.editor.ui.other.PluginDialogUI extends laya.ui.Dialog
	var PluginDialogUI=(function(_super){
		function PluginDialogUI(){
			this.title=null;
			PluginDialogUI.__super.call(this);
		}

		__class(PluginDialogUI,'laya.editor.ui.other.PluginDialogUI',_super);
		var __proto=PluginDialogUI.prototype;
		__proto.createChildren=function(){
			laya.ui.Component.prototype.createChildren.call(this);
			this.createView(PluginDialogUI.uiView);
		}

		__static(PluginDialogUI,
		['uiView',function(){return this.uiView={"child":[{"type":"Image","props":{"skin":"view/bg_dialog.png","y":"0","sizeGrid":"60,10,10,10","bottom":"0","width":"450","left":"0","height":"220","top":"0","right":"0","x":"0"}},{"type":"Button","props":{"skin":"view/btn_close.png","name":"close","scaleY":"0.5","scaleX":"0.5","top":"18","right":"18"}},{"type":"Image","props":{"skin":"comp/blank.png","y":"7","width":"396","left":"9","height":"38","name":"drag","right":"40","x":"9"}},{"type":"Label","props":{"y":"17","text":"提取语言包","width":"169","height":"18","var":"title","color":"#c5c5c5","fontSize":"14","x":"21"}}],"type":"Dialog","props":{"scenecolor":"#dddddd"}};}
		]);
		return PluginDialogUI;
	})(Dialog)


	//class laya.editor.ui.other.PreviewUI extends laya.ui.Dialog
	var PreviewUI=(function(_super){
		function PreviewUI(){
			this.panel=null;
			PreviewUI.__super.call(this);
		}

		__class(PreviewUI,'laya.editor.ui.other.PreviewUI',_super);
		var __proto=PreviewUI.prototype;
		__proto.createChildren=function(){
			laya.ui.Component.prototype.createChildren.call(this);
			this.createView(PreviewUI.uiView);
		}

		__static(PreviewUI,
		['uiView',function(){return this.uiView={"child":[{"type":"Image","props":{"skin":"view/bg_panel.png","y":"137","sizeGrid":"4,4,4,4","right":"0","left":"0","top":"0","bottom":"0","x":"164"}},{"child":[{"type":"Button","props":{"skin":"comp/button.png","sizeGrid":"0,4,0,4","label":"label","labelColors":"#efefef,#ffffff,#c5c5c5,#c5c5c5"}}],"type":"Panel","props":{"vScrollBarSkin":"comp/vscroll.png","y":"26","var":"panel","hScrollBarSkin":"comp/hscroll.png","bottom":"5","left":"5","top":"5","right":"5","x":"21"}},{"type":"Button","props":{"skin":"view/btn_close.png","y":"33","name":"close","scaleX":"0.5","top":"5","scaleY":"0.5","right":"5","x":"550"}}],"type":"Dialog","props":{"height":"400","scenecolor":"#dddddd","width":"600"}};}
		]);
		return PreviewUI;
	})(Dialog)


	//class laya.editor.core.Design extends laya.editor.core.UIView
	var Design=(function(_super){
		function Design(){
			this._xml=null;
			this._autoId=1;
			this._compMap={};
			this._selectedBox=null;
			this._selectedComps=[];
			this._isMove=false;
			this._isDragSelect=false;
			this._hasChange=false;
			this._maskLayer=null;
			this._sceneWidth=0;
			this._sceneHeight=0;
			this._sceneColor=null;
			this._sceneBg=null;
			this.animation=null;
			this.myID=0;
			this.aniSign=null;
			this.pageType=null;
			this.animationNodeMenu=null;
			this._menu=null;
			this.referenceLayer=null;
			this.isRightClick=false;
			this.uiXmlRestored=null;
			this._isAnimationMode=false;
			this._count=0;
			this._MouseTar=null;
			this._alignLine=null;
			this.isFirstReFresh=true;
			this._treeData=null;
			this._createComp=null;
			this._idUsed={};
			Design.__super.call(this);
			this._xmls=[];
			this._xmlsRemoved=[];
			this._currMouse=new Point();
			this._bgLayer=new Image();
			this._maskAboveLayer=new UIBox();
			this._dragBoxLayer=new DragBoxManager();
			this._selectLineLayer=new Sprite();
			this.rightMouseDownPos=new Point();
			this._dPosInfo=new Point();
			this.parseInt=LayaBuilder.mParseInt;
			this.graphics.drawRect(0,0,100,100,null,"#ff0000");
			this.addChildAt(this._bgLayer,0);
			this.myID=Design.designID;
			Design.designID++;
			this.aniSign="designAni:"+this.myID;
			this._dragBoxLayer.mouseThrough=true;
			this._dragBoxLayer.height=2;
			this._dragBoxLayer.mouseEnabled=true;
			this._maskLayer=Utils.createMaskArea(5000,5000,"#575757",0.5);
			this._maskLayer.pivot(2500,2500);
			this._maskLayer.mouseEnabled=true;
			this._maskLayer.on("doubleclick",this,this.onMaskDoubleClick);
			this._maskLayer.visible=false;
			this._maskLayer.width=this._maskLayer.height=5000;
			this._maskLayer.name="_maskLayer";
			this.addChild(this._maskLayer);
			this.addChild(this._maskAboveLayer);
			this._maskAboveLayer.width=this._maskAboveLayer.height=5000;
			this._maskAboveLayer.visible=false;
			this._maskAboveLayer.on("doubleclick",this,this.onDoubleClick);
			this._maskAboveLayer.name="_maskAboveLayer";
			this.addChild(this._dragBoxLayer);
			this.addChild(this._selectLineLayer);
			this.on("keydown",this,this.onKeyDown);
			this.on("mousedown",this,this.onMouseDown);
			this.on("mouseup",this,this.onMouseClick);
			this.on("doubleclick",this,this.onDoubleClick);
			this.mouseThrough=true;
			this.on("display",this,this.addListens);
			this.on("undisplay",this,this.removeListens);
			this.on("rightmousedown",this,this.onRightMouseDown);
			this.on("rightmouseup",this,this.onRightMouseUp);
			this.animationNodeMenu=ContextMenu.createMenu("创建关键帧");
			this.animationNodeMenu.on("select",this,this.onEmunSelect);
			this._menu=ContextMenu.createMenuByArray2(["复制","剪切","粘贴","删除","","转换为容器","转换类型","打散容器","","创建Sprite节点","创建2D",ObjectTools$1.setValueArr([],TypeManager.Res2D),"创建Graphics",ObjectTools$1.setValueArr([],TypeManager.GraphicRes),"创建UI组件",ObjectTools$1.setValueArr([],TypeManager.UIRes)]);
			this._menu.on("select",this,this.onEmunSelect);
		}

		__class(Design,'laya.editor.core.Design',_super);
		var __proto=Design.prototype;
		__proto.onEmunSelect=function(name){
			var target;
			target=this.selectedCompXml;
			if(!target)return;
			if(TypeManager.isResTypeName(name)){
				Notice.notify("AddNode",[name,0,0,target.compId]);
				return;
			}
			switch (name){
				case "存储为预设":
					break ;
				case "创建关键帧":
					if(target)
						Notice.notify("RECORD_KEYFRAME",[target.compId]);
					break ;
				case "转换为容器":
					ShortcutManager.exeKey(66,true,false);
					break ;
				case "打散容器":
					ShortcutManager.exeKey(85,true,false);
					break ;
				case "转换类型":
					ShortcutManager.exeKey(84,true,false);
					break ;
				case "删除":
					Notice.notify("DELETE_SELECTED");
					break ;
				case "切断预设":
					Notice.notify("CutOff_Prefab",[target.compId]);
					break ;
				case "定位预设":
					if(target&&target.props&&target.props.preset){
						var pPath=target.props.preset;
						pPath=StringTool$1.getReplace(pPath,"laya/assets/","");
						Notice.notify("SelecteResFile",[pPath]);
					}
					break ;
				case "粘贴":
					Laya.stage.focus=this;
					ShortcutManager.exeKey(86,true,false);
					break ;
				case "复制":
					Laya.stage.focus=this;
					ShortcutManager.exeKey(67,true,false);
					break ;
				case "剪切":
					Laya.stage.focus=this;
					ShortcutManager.exeKey(88,true,false);
					break ;
				case "创建Sprite节点":
					Notice.notify("AddNode",["Sprite",0,0,target.compId]);
					break ;
				}
			switch (name){
				case "创建关键帧":
					if(this.selectedCompXml){
						Notice.notify("RECORD_KEYFRAME",[this.selectedCompXml.compId]);
					}
					break ;
				}
		}

		__proto.onRightMouseDown=function(){
			this.isRightClick=false;
			if(this.selectedComp){
				this.rightMouseDownPos.setTo(Laya.stage.mouseX,Laya.stage.mouseY);
				this.isRightClick=true;
			}
		}

		__proto.onRightMouseUp=function(){
			if(!this.isRightClick)return;
			this.isRightClick=false;
			if(Math.abs(Laya.stage.mouseX-this.rightMouseDownPos.x)>5||Math.abs(Laya.stage.mouseX-this.rightMouseDownPos.x)>5){
				return;
			}
			if(!this.selectedComp)return;
			if(!this.isAnimationMode){
				this._menu.show();
				}else{
				this.animationNodeMenu.show();
			}
		}

		__proto.addListens=function(){
			Notice.listen("Prop_Changed",this,this.propChangedNotice,null,true);
			Notice.listen("Prop_change",this,this.changeProps,null,true);
			Notice.listen("PROP_FORCESET",this,this.forceSetProps,null,true);
			Notice.listen("Prop_changeing",this,this.changeingProps,null,true);
			Notice.listen("Display_selected",this,this.selectCompChainHandler,null,true);
			Notice.listen("Display_multiSelected",this,this.mutiSelectComps,null,true);
			Notice.listen("ClearDesignSelect",this,this.clearSelect,null,true);
			Notice.listen("display_value_changes",this,this.displayValueChangeHandler,null,true);
			Notice.listen("Display_tree_change",this,this.displayTreeChangeHandler,null,true);
			Notice.listen("IDEKey_Event",this,this.onKeyDown,null,true);
			Notice.listen("Display_transParent",this,this.transNodeParent,null,true);
			Notice.listen("Display_Enter",this,this.enterComp,null,true);
			Notice.listen("AddNode",this,this.addNode,null,true);
			Notice.listen("CutOff_Prefab",this,this.cutOffPrefab,null,true);
			Notice.listen("REPLACE_SELECTEDCOMPS",this,this.replaceSelecteCompsByRes,null,true);
			Notice.listen("CLIP_VIEW",this,this.fitSizeToUI);
		}

		__proto.removeListens=function(){
			Notice.cancel("Prop_Changed",this,this.propChangedNotice);
			Notice.cancel("Prop_change",this,this.changeProps);
			Notice.cancel("PROP_FORCESET",this,this.forceSetProps);
			Notice.cancel("Prop_changeing",this,this.changeingProps);
			Notice.cancel("Display_selected",this,this.selectCompChainHandler);
			Notice.cancel("Display_multiSelected",this,this.mutiSelectComps);
			Notice.cancel("ClearDesignSelect",this,this.clearSelect);
			Notice.cancel("display_value_changes",this,this.displayValueChangeHandler);
			Notice.cancel("Display_tree_change",this,this.displayTreeChangeHandler);
			Notice.cancel("IDEKey_Event",this,this.onKeyDown);
			Notice.cancel("Display_transParent",this,this.transNodeParent);
			Notice.cancel("Display_Enter",this,this.enterComp);
			Notice.cancel("AddNode",this,this.addNode);
			Notice.cancel("CutOff_Prefab",this,this.cutOffPrefab);
			Notice.cancel("REPLACE_SELECTEDCOMPS",this,this.replaceSelecteCompsByRes);
			Notice.cancel("CLIP_VIEW",this,this.fitSizeToUI);
		}

		__proto.replaceSelecteCompsByRes=function(path){
			if(this.isAnimationMode){
				Alert.show(Sys.lang("动画编辑模式中，该功能不可用。"));
				return;
			};
			var items;
			var i=0,len=0;
			var tItem;
			items=this._selectedComps;
			if(!items)return;
			len=items.length;
			if(items.length<1)return;
			var compType;
			compType=ResStyleManager.getResCompType(FileManager.getResRelativePath(path));
			var replaceNodeData;
			replaceNodeData=this.getAddCompData(path,compType);
			if(!replaceNodeData)return;
			delete replaceNodeData["compId"];
			var tData;
			for(i=0;i<len;i++){
				tItem=items[i];
				if(!tItem)continue ;
				tData=tItem.comXml;
				if(!tData)continue ;
				if(tData["compId"]==this.getRootID())continue ;
				this.replaceCompData(tData,replaceNodeData);
			}
			this.changeXml(this._xml,true);
		}

		__proto.replaceCompData=function(oData,newData){
			var oldProps;
			var newProps;
			oldProps=oData.props;
			newProps=newData.props;
			var key;
			if(oldProps){
				for(key in oldProps){
					if(!Design.KeepKeys[key]){
						delete oldProps[key];
					}
				}
			}
			if(newProps){
				for(key in newProps){
					if(!oldProps.hasOwnProperty(key)){
						oldProps[key]=newProps[key];
					}
				}
			}
			for(key in newData){
				if(key !="props"&&key!="child"){
					oData[key]=newData[key];
				}
			}
		}

		__proto.cutOffPrefab=function(nodeID){
			var node;
			node=this.findXmlById(this._xml,nodeID);
			if(!node)node=this.selectedCompXml;
			if(!node)return;
			PreFabManager.I.cutOffNodeTreePrefab(node);
			this.changeXml(this._xml,true);
		}

		__proto.addNode=function(type,x,y,parentId,abPos){
			(abPos===void 0)&& (abPos=false);
			this.addCompWork(this.getAddCompData("",type),x,y,parentId,abPos);
		}

		__proto.getCompByNodeData=function(node){
			if(!node)return null;
			if(!node.compId)return null;
			return this.getCompById(node.compId);
		}

		__proto.transNodeParent=function(tar,newParent){
			var tarNode;
			var newParentNode;
			tarNode=this.getCompByNodeData(tar);
			newParentNode=this.getCompByNodeData(newParent);
			if(!tarNode||!tarNode.displayedInStage)return;
			if(!newParentNode||!newParentNode.displayedInStage)return;
			var preParent;
			preParent=tarNode.parent;
			if(!preParent&&preParent.displayedInStage)return;
			var pos;
			pos=Design._tempTransPoint;
			pos.setTo(tarNode.x,tarNode.y);
			pos=preParent.localToGlobal(pos);
			pos=newParentNode.globalToLocal(pos);
			pos.x=Math.round(pos.x);
			pos.y=Math.round(pos.y);
			tar.props.x=pos.x;
			tar.props.y=pos.y;
		}

		// tar.pos(pos.x,pos.y);
		__proto.propChangedNotice=function(){
			this.hasChange=true;
			this.changeXml(this._xml,false);
		}

		__proto.isActive=function(){
			if(!UIPanel.instance.currViewer)return false;
			return this==UIPanel.instance._currViewer.design;
		}

		__proto.onActive=function(){
			this.setAnimationData();
		}

		__proto.setAnimationData=function(){
			if(!this.animation)return;
			Notice.notify("Fresh_animationData",[this.animation]);
		}

		__proto.displayValueChangeHandler=function(itemId,key,value){
			this.changeCompProp(itemId,key,value);
		}

		__proto.displayTreeChangeHandler=function(){
			this.changeXml(this._xml,true);
		}

		__proto.getRootID=function(){
			return this._xml.compId;
		}

		__proto.goToRoot=function(){
			if(this.getRootID()==this.getSelectRootID())return;
			this.enterComp(this.getRootID());
		}

		//改变属性通知
		__proto.changeMixItemProps=function(proName,pro,targetID,cache){
			(cache===void 0)&& (cache=true);
			var mixO;
			mixO=this.getSelectePropItem();
			var dValue=NaN;
			switch(proName){
				case "x":
				case "y":
					dValue=pro-mixO.props[proName];
					this.changeSelecteCompValues(proName,dValue,cache);
					mixO.props[proName]=pro;
					break ;
				case "mouseEnabled":
				case "visible":
					this.setSelecteCompValues(proName,pro,cache);
					break ;
				}
			if(this._selectedComps){
				var tComp;
				var len=0;
				var i=0;
				len=this._selectedComps.length;
				for(i=0;i<len;i++){
					this.nodeChanged(this._selectedComps[i].comXml,["x","y","mouseEnabled","visible"]);
				}
			}
			this.refreshStatusInfo();
		}

		__proto.changeSelecteCompValues=function(key,dValue,cache){
			(cache===void 0)&& (cache=true);
			var items;
			var i=0,len=0;
			var tItem;
			items=this._selectedComps;
			len=items.length;
			for(i=0;i<len;i++){
				tItem=items[i];
				tItem[key]+=dValue;
				this._dragBoxLayer.refreshDrag(tItem);
				tItem.comXml.props[key]=tItem[key];
			}
			if(cache)
				this.changeXml(this._xml,false);
		}

		__proto.refreshDragBlocks=function(){
			var items;
			var i=0,len=0;
			var tItem;
			items=this._selectedComps;
			len=items.length;
			for(i=0;i<len;i++){
				tItem=items[i];
				this._dragBoxLayer.refreshDrag(tItem);
			}
		}

		__proto.setSelecteCompValues=function(key,dValue,cache){
			(cache===void 0)&& (cache=true);
			var items;
			var i=0,len=0;
			var tItem;
			items=this._selectedComps;
			len=items.length;
			for(i=0;i<len;i++){
				tItem=items[i];
				if(key!="visible")
					tItem[key]=dValue;
				this._dragBoxLayer.refreshDrag(tItem);
				tItem.comXml.props[key]=dValue;
			}
			if(cache)
				this.changeXml(this._xml,false);
		}

		__proto.changeingProps=function(proName,pro,targetID){
			this.changeProps(proName,pro,targetID,false);
		}

		__proto.checkVarOk=function(proName,pro,alertIfNotOK){
			(alertIfNotOK===void 0)&& (alertIfNotOK=true);
			if(proName!="var")return true;
			var data;
			data=this._xml;
			var varsO;
			varsO={};
			return Design.parseVarByObj(data,varsO);
		}

		/**
		*是否var已经存在
		*@param varKey
		*@return
		*
		*/
		__proto.isVarExist=function(varKey){
			var data;
			data=this._xml;
			var varsO;
			varsO={};
			varsO[varKey]=true;
			return Design.parseVarByObj(data,varsO);
		}

		__proto.forceSetProps=function(propName,targetID){
			(targetID===void 0)&& (targetID=-1);
			var comp;
			comp=this.getCompById(targetID);
			if(comp){
				if(isNaN(comp[propName])){
					this.changeProps(propName,0,targetID,true,true);
					}else{
					this.changeProps(propName,comp[propName],targetID,true,true);
				}
			}
		}

		__proto.changeProps=function(proName,pro,targetID,cache,ifRefreshComp){
			(targetID===void 0)&& (targetID=-1);
			(cache===void 0)&& (cache=true);
			(ifRefreshComp===void 0)&& (ifRefreshComp=true);
			if(this._selectedComps&&this._selectedComps.length>1){
				this.changeMixItemProps(proName,pro,targetID,cache);
				return;
			};
			var hasDelete=false;
			hasDelete=false;
			var selected;
			if(targetID>0){
				selected=this.findXmlById(this._xml,targetID);
				}else{
			}
			if(!selected){
				selected=this.selectedCompXml?this.selectedCompXml:this._xml;
			}
			if(!selected)return;
			if(!this.checkVarOk(proName,pro)){
				if(proName=="var"){
					delete selected.props["var"];
					pro="";
				}
			};
			var propNames;
			propNames=[proName];
			var preComp;
			preComp=this.getCompById(selected.compId);
			var prePValue=NaN;
			var DPValue=NaN;
			var newPValue=NaN;
			newPValue=LayaBuilder.mParseInt(pro);
			if(proName=="pivotX"){
				prePValue=preComp.pivotX;
				DPValue=preComp.pivotX-newPValue;
				preComp.x-=DPValue;
				preComp.x=Math.floor(preComp.x);
				selected.props.x=preComp.x;
				propNames.push("x");
			};
			var newPV=NaN;
			if(proName=="anchorX"){
				newPValue=LayaBuilder.mParserFloat(pro);
				prePValue=preComp.pivotX;
				newPV=preComp.width*newPValue;
				DPValue=preComp.pivotX-newPV;
				preComp.x-=DPValue;
				preComp.x=Math.floor(preComp.x);
				selected.props.x=preComp.x;
				propNames.push("x");
			}
			if(proName=="pivotY"){
				prePValue=preComp.pivotY;
				DPValue=preComp.pivotY-newPValue;
				preComp.y-=DPValue;
				preComp.y=Math.floor(preComp.y);
				selected.props.y=preComp.y;
				propNames.push("y");
			}
			if(proName=="anchorY"){
				newPValue=LayaBuilder.mParserFloat(pro);
				prePValue=preComp.pivotY;
				newPV=preComp.height*newPValue;
				DPValue=preComp.pivotY-newPV;
				preComp.y-=DPValue;
				preComp.y=Math.floor(preComp.y);
				selected.props.y=preComp.y;
				propNames.push("y");
			}
			if(pro===""){
				delete selected.props[proName];
				hasDelete=true;
				if(proName=="right"||proName=="left"){
					if(!selected.props["right"]&&!selected.props["left"]){
						selected.props["x"]=preComp.x;
					}
				}
				if(proName=="top"||proName=="bottom"){
					if(!selected.props["top"]&&!selected.props["bottom"]){
						selected.props["y"]=preComp.y;
					}
				}
				}else{
				ObjectTools$1.setObjValue(selected.props,proName,pro);
			};
			var dataO;
			dataO=selected.props;
			var conflictKey;
			var i=0,len=0;
			var dKey;
			if(selected!=this._xml&&pro!==""){
				len=Design.conflictGroups.length;
				var tGroup;
				var gId;
				for(i=0;i<len;i++){
					tGroup=Design.conflictGroups[i];
					if(tGroup[proName]){
						gId=tGroup[proName];
						for(dKey in tGroup){
							if(dataO.hasOwnProperty(dKey)){
								if(tGroup[dKey]!=gId){
									delete dataO[dKey];
									hasDelete=true;
								}
							}
						}
						break ;
					}
				}
				len=Design.conditionChangeDic.length;
				var tCondition;
				for(i=0;i<len;i++){
					tCondition=Design.conditionChangeDic[i];
					if(ObjectTools$1.hasKeys(dataO,tCondition["keys"])){
						dKey=tCondition["trans"][proName];
						delete dataO[dKey];
						hasDelete=true;
						break ;
					}
				}
			}
			if(ifRefreshComp){
				this.refreshComp(this.getCompById(selected.compId),proName,pro,hasDelete);
			}
			this.nodeChanged(selected,propNames,propNames.length==1);
			if(cache)
				this.changeXml(this._xml,false);
			if(proName=="name"||proName=="var"){
				if(this._treeData){
					this._treeData=TreeData.createByUIObj(this._xml);
				}
				this.updateNameToPanels();
			}
			if(ifRefreshComp){
				this.clearSelect();
				if(preComp!=this.getCompById(selected.compId)){
					this.removeBorder(preComp);
					this.unSelectComp(preComp);
					this.selectComp(this.getCompById(selected.compId),true,true,false);
					}else{
					this.removeBorder(preComp);
					this.selectComp(this.getCompById(selected.compId),true,true,false);
				}
			}
		}

		// addBorder(getCompById(selected.compId));
		__proto.updateChanges=function(){}
		__proto.changeCompProp=function(itemId,key,value){
			var comp;
			comp=this.getCompById(itemId);
			var dataO;
			dataO=this._treeData.getNodeByID(itemId);
			if(key==Signs.HideSign){
				if(comp)
					comp["visible"]=!value;
				ObjectTools$1.setAutoTypeValue(dataO,key,value);
				if(value&&this._treeData.isNodeSame(this.selectedCompXml,dataO)){
					this.clearSelect();
				}
				}else if(key==Signs.LockSign){
				ObjectTools$1.setAutoTypeValue(dataO,key,value);
				if(value&&this._treeData.isNodeSame(this.selectedCompXml,dataO)){
					this.clearSelect();
				}
				}else{
				ObjectTools$1.setAutoTypeValue(dataO.props,key,value);
			}
			if(comp){
			}
			this.callLater(this.changeXmlLater);
		}

		__proto.changeXmlLater=function(){
			this.changeXml(this._xml,false);
		}

		// trace("_coount:",_count++);
		__proto.enterComp=function(compId){
			var item;
			item=this.getCompById(compId);
			if(!item)return;
			if(!FilterFuns.isEditorEnterAble(item))return;
			this.clearSelect();
			this._xml.selectedBox=(item).comXml.compId;
			this.refresh();
		}

		__proto.mutiSelectComps=function(compList){
			var i=0,len=0;
			len=compList.length;
			this.clearSelect();
			var rootID=0;
			rootID=this.getSelectRootID();
			for(i=0;i<len;i++){
				var tID=0;
				tID=compList[i];
				if(this.getCompParentID(tID)==rootID){
					this.selectCompByID(tID,true,true);
				}
			}
		}

		__proto.getSelectRootID=function(){
			if(this._selectedBox&&this._selectedBox["comXml"]&&this.selectedBox["comXml"].compId){
				return this.selectedBox["comXml"].compId;
				}else{
				return this.getRootID();
			}
		}

		__proto.getCompParentID=function(compID){
			var item;
			item=this.getCompById(compID);
			if(item&&item.comXml&&item.comXml.nodeParent){
				return item.comXml.nodeParent;
			}
			return-1;
		}

		//
		__proto.selectCompChainHandler=function(compId,ignoreLock,ignoreHide){
			(ignoreLock===void 0)&& (ignoreLock=false);
			(ignoreHide===void 0)&& (ignoreHide=false);
			var item;
			item=this.getCompById(compId);
			if(!item)return;
			if(this.selectedCompXml&&compId==this.selectedCompXml.compId)return;
			if(!FilterFuns.isEditorSelectableChain(item,ignoreLock,ignoreHide)){
				return;
			}
			if(compId==this.getRootID()){
				this.clearSelect(true);
				return;
			};
			var tParent;
			tParent=this.getCompById((item).comXml.nodeParent);
			var isSameSelectBox=false;
			if(this._selectedBox&&this._selectedBox["comXml"]&&this.selectedBox["comXml"].compId==(item).comXml.nodeParent){
				isSameSelectBox=true;
				}else{
				isSameSelectBox=false;
			}
			if(!tParent)return;
			this.clearSelect();
			if(FilterFuns.isEditorEnterAble(item)&&0){
				this.selectComp(item);
				}else{
				if(!isSameSelectBox){
					if(FilterFuns.isEditorEnterAble(tParent)){
						if(tParent==this._viewLayer||tParent.parent==this){
							if(this._selectedBox!=this._viewLayer){
								this._xml.selectedBox=this.getRootID();
							}
							}else{
							this._xml.selectedBox=(item).comXml.nodeParent;
						}
					}
					this.refresh();
				}
			}
			this.selectComp(this.getCompById(compId),ignoreLock,ignoreHide);
		}

		/**处理鼠标按下*/
		__proto.onMouseDown=function(e){
			Design._isClickOK=false;
			if(Design.isCtrlAdding){
				this.pasetCompUnderMouse();
				return;
			}
			if(e&&e.ctrlKey&&e.shiftKey){
				this.pasetCompUnderMouse();
				return;
			}
			this._MouseTar=this.selectedBox;
			this.stage.focus=this;
			this.onMouseDownWork(e);
		}

		__proto.onMouseClick=function(e){
			if(!Design._isClickOK)return;
			Design._isClickOK=false;
			if(ColorPickerItem.showed)return;
			var comp=this.getCompSelectedAtCurrBox;
			if (comp !=null && (comp).comXml){
				var index=this._selectedComps.indexOf(comp);
				if (e&&(e.nativeEvent.ctrlKey || e.nativeEvent.shiftKey)){
					if (index==-1){
						this.selectComp(comp);
						}else {
						this.unSelectComp(comp);
					}
					}else {
					if (index==-1){
						this.clearSelect();
						this.selectComp(comp);
					}
				}
			}
		}

		/**单击选择和取消*/
		__proto.onMouseDownWork=function(e){
			if(ColorPickerItem.showed)return;
			if(this.isSelectedCompsUnderMouse()){
				if(this._selectedComps&&this._selectedComps.length==1){
					if(this._selectedComps[0]["disableDragMove"]){
						return;
					}
				}
				Design._isClickOK=true;
				this.readyToMove();
				}else{
				var comp=this.getCompSelectedAtCurrBox;
				if (comp !=null && (comp).comXml){
					Design._isClickOK=true;
					}else{
					this.clearSelect();
					this.readyToDragSelect();
				}
			}
		}

		/**准备移动*/
		__proto.readyToMove=function(){
			this._isDragSelect=false;
			if (this._selectedComps.length > 0){
				this._currMouse.x=this._MouseTar.mouseX;
				this._currMouse.y=this._MouseTar.mouseY;
				this.stage.on("mousemove",this,this.onStageMouseMove);
				this.stage.on("mouseup",this,this.onStageMouseUp);
			}
		}

		/**开始选择（显示选择框）*/
		__proto.readyToDragSelect=function(){
			this._isDragSelect=true;
			this._selectLineLayer.x=this.mouseX;
			this._selectLineLayer.y=this.mouseY;
			this.stage.on("mousemove",this,this.onStageMouseMove);
			this.stage.on("mouseup",this,this.onStageMouseUp);
		}

		__proto.cancelMouseState=function(){
			return;
			this._isDragSelect=false;
			this.stage.off("mousemove",this,this.onStageMouseMove);
			this.stage.off("mouseup",this,this.onStageMouseUp);
			this._selectLineLayer.graphics.clear();
		}

		/**移动组件*/
		__proto.onStageMouseMove=function(e){
			if (this._isDragSelect){
				this._selectLineLayer.graphics.clear();
				Utils.drawDashedRect(this._selectLineLayer.graphics,this.mouseX-this._selectLineLayer.x,this.mouseY-this._selectLineLayer.y);
				}else {
				var mx=(this._MouseTar.mouseX-this._currMouse.x);
				var my=(this._MouseTar.mouseY-this._currMouse.y);
				if (this._isMove==false && (Math.abs(mx)> 2 || Math.abs(my)> 2)){
					this._isMove=true;
					Design._isClickOK=false;
				}
				if (this._isMove){
					this._currMouse.x+=mx;
					this._currMouse.y+=my;
					for (var i=0,n=this._selectedComps.length;i < n;i++){
						var comp=this._selectedComps[i];
						comp.x=Math.round(comp.x+mx);
						comp.y=Math.round(comp.y+my);
						if(IDEVars.enableAutoAlign&&i==0){
							this.updateAutoAlignHandler(comp);
							comp.x+=this._dPosInfo.x;
							comp.y+=this._dPosInfo.y;
							this._currMouse.x+=this._dPosInfo.x;
							this._currMouse.y+=this._dPosInfo.y;
							mx+=this._dPosInfo.x;
							my+=this._dPosInfo.y;
						};
						var info=(comp).comXml.props;
						this.updateNodePosInfo(info,comp);
						this._dragBoxLayer.refreshDrag(comp);
					}
					this.refreshStatusInfo();
					this.showSelectRuleRange();
				}
			}
		}

		__proto.getAlignLines=function(tar){
			var rst;
			rst=Design._tempAlignLines;
			Design.clearAlignLines();
			rst.length=0;
			var tParent;
			tParent=tar.parent;
			if(!tParent)return rst;
			rst.push(AlignTool.getAlignLine("x",0));
			rst.push(AlignTool.getAlignLine("x",tParent.width));
			rst.push(AlignTool.getAlignLine("y",0));
			rst.push(AlignTool.getAlignLine("y",tParent.height));
			if(this.referenceLayer&&this.referenceLayer.visible){
				this.referenceLayer.getLocalReferencePoints(tParent,rst);
			}
			return rst;
		}

		/**
		*处理自动对齐
		*@param tar
		*@return
		*
		*/
		__proto.updateAutoAlignHandler=function(tar){
			this._dPosInfo.setTo(0,0);
			if(!tar)return this._dPosInfo;
			var tParent;
			tParent=tar.parent;
			var i=0,len=0;
			len=tParent.numChildren;
			var tItem;
			var tMinX;
			var tMinY;
			var tAlignInfo;
			for(i=0;i<len;i++){
				tItem=tParent.getChildAt(i);
				if(!tItem.comXml)continue ;
				if(this._selectedComps.indexOf(tItem)>=0)continue ;
				tAlignInfo=AlignTool.getMinType(tar,tItem,true,Pool.getItemByClass("MinAlignInfo",MinAlignInfo));
				if(!tMinX||tMinX.minAbs>tAlignInfo.minAbs){
					if(tMinX){
						Pool.recover("MinAlignInfo",tMinX);
					}
					tMinX=tAlignInfo;
					}else{
					Pool.recover("MinAlignInfo",tAlignInfo);
				}
				tAlignInfo=AlignTool.getMinType(tar,tItem,false,Pool.getItemByClass("MinAlignInfo",MinAlignInfo));
				if(!tMinY||tMinY.minAbs>tAlignInfo.minAbs){
					if(tMinY){
						Pool.recover("MinAlignInfo",tMinY);
					}
					tMinY=tAlignInfo;
					}else{
					Pool.recover("MinAlignInfo",tAlignInfo);
				}
			};
			var alignLines;
			alignLines=this.getAlignLines(tar);
			len=alignLines.length;
			var tAlignLine;
			for(i=0;i<len;i++){
				tAlignLine=alignLines[i];
				if(tAlignLine.type=="x"){
					tAlignInfo=AlignTool.getMinType(tar,tAlignLine,true,Pool.getItemByClass("MinAlignInfo",MinAlignInfo),true);
					if(!tMinX||tMinX.minAbs>tAlignInfo.minAbs){
						if(tMinX){
							Pool.recover("MinAlignInfo",tMinX);
						}
						tMinX=tAlignInfo;
						}else{
						Pool.recover("MinAlignInfo",tAlignInfo);
					}
				}
				if(tAlignLine.type=="y"){
					tAlignInfo=AlignTool.getMinType(tar,tAlignLine,false,Pool.getItemByClass("MinAlignInfo",MinAlignInfo),true);
					if(!tMinY||tMinY.minAbs>tAlignInfo.minAbs){
						if(tMinY){
							Pool.recover("MinAlignInfo",tMinY);
						}
						tMinY=tAlignInfo;
						}else{
						Pool.recover("MinAlignInfo",tAlignInfo);
					}
				}
			}
			if(!this._alignLine){
				this._alignLine=new Sprite();
				this._alignLine.zOrder=9999;
			}
			this._alignLine.graphics.clear();
			var min=NaN;
			var max=NaN;
			this._alignLine.removeSelf();
			this._dPosInfo.setTo(0,0);
			if(tMinX&&tMinX.minAbs<8){
				if((tMinX.tar instanceof laya.display.Sprite )){
					min=Math.min(tar.y,tMinX.tar.y);
					max=Math.max(tar.y+tar.height,tMinX.tar.y+tMinX.tar.height);
					this._alignLine.graphics.drawLine(tMinX.tValue,min,tMinX.tValue,max,StyleConsts.AutoAlignLineColor);
					tParent.addChild(this._alignLine);
				}
				this._dPosInfo.x=tMinX.minD;
			}
			if(tMinY&&tMinY.minAbs<8){
				if((tMinY.tar instanceof laya.display.Sprite )){
					min=Math.min(tar.x,tMinY.tar.x);
					max=Math.max(tar.x+tar.width,tMinY.tar.x+tMinY.tar.width);
					this._alignLine.graphics.drawLine(min,tMinY.tValue,max,tMinY.tValue,StyleConsts.AutoAlignLineColor);
					tParent.addChild(this._alignLine);
				}
				this._dPosInfo.y=tMinY.minD;
			}
			if(tMinX){
				Pool.recover("MinAlignInfo",tMinX);
			}
			if(tMinY){
				Pool.recover("MinAlignInfo",tMinY);
			}
			return this._dPosInfo;
		}

		/**
		*清除自动对齐调试线
		*
		*/
		__proto.clearAutoAlign=function(){
			if(this._alignLine){
				this._alignLine.removeSelf();
			}
		}

		/**
		*更新节点坐标相关的信息，处理属性冲突
		*@param info
		*@param comp
		*
		*/
		__proto.updateNodePosInfo=function(info,comp){
			if(info.hasOwnProperty("left")){
				comp.left=info.left=comp.x-comp.pivotX*comp.scaleX;
				delete info.x;
				}else{
				info.x=comp.x;
			}
			if(info.hasOwnProperty("top")){
				comp.top=info.top=comp.y-comp.pivotY*comp.scaleY;
				delete info.y;
				}else{
				info.y=comp.y;
			};
			var tParent;
			tParent=comp.parent;
			if(!tParent)return;
			if(info.hasOwnProperty("right")){
				comp.right=info.right=tParent.width-comp.x-comp.width+comp.pivotX*comp.scaleX;
				delete info.x;
			}
			if(info.hasOwnProperty("bottom")){
				comp.bottom=info.bottom=tParent.height-comp.y-comp.height+comp.pivotY*comp.scaleY;
				delete info.y;
			}
			if(info.hasOwnProperty("centerY")){
				comp["centerY"]=info.centerY=comp.y-(tParent.height-comp.height*comp.scaleY)*0.5-comp.pivotY*comp.scaleY;
				delete info.y;
			}
			if(info.hasOwnProperty("centerX")){
				comp["centerX"]=info.centerX=comp.x-(tParent.width-comp.width*comp.scaleX)*0.5-comp.pivotX*comp.scaleX;
				delete info.x;
			}
		}

		__proto.showCompRuleRange=function(comp){
			Design._recPoints[0].setTo(comp.x,comp.y);
			Design._recPoints[1].setTo(comp.x+comp.width,comp.y+comp.height);
			this.showRuleRange(comp.parent);
		}

		__proto.showSelectRuleRange=function(){
			if(!this._selectedComps||this._selectedComps.length<1){
				Notice.notify("Clear_RULE_RANGE");
				return;
			};
			var tComp;
			tComp=this._selectedComps[0];
			this.calculateSelecteRange();
			this.showRuleRange(tComp.parent);
		}

		__proto.getReferenceLines=function(){
			return this._xml.referenceLines;
		}

		__proto.changeReferenceLine=function(lines){
			this._xml.referenceLines=lines;
			this.changeXml(this._xml,false);
		}

		__proto.calculateSelecteRange=function(){
			var sPoint;
			var ePoint;
			sPoint=Design._recPoints[0];
			ePoint=Design._recPoints[1];
			var i=0,len=0;
			len=this._selectedComps.length;
			var tCompRec;
			tCompRec=this._selectedComps[0].getBounds();
			sPoint.x=tCompRec.x;
			sPoint.y=tCompRec.y;
			ePoint.x=tCompRec.x+tCompRec.width;
			ePoint.y=tCompRec.y+tCompRec.height;
			for(i=1;i<len;i++){
				tCompRec=this._selectedComps[i];
				if(sPoint.x>tCompRec.x){
					sPoint.x=tCompRec.x;
				}
				if(sPoint.y>tCompRec.y){
					sPoint.y=tCompRec.y;
				}
				if(ePoint.x<tCompRec.x+tCompRec.width){
					ePoint.x=tCompRec.x+tCompRec.width;
				}
				if(ePoint.y<tCompRec.y+tCompRec.height){
					ePoint.y=tCompRec.y+tCompRec.height;
				}
			}
		}

		__proto.getSelectePropItem=function(){
			this.calculateSelecteRange();
			var sPoint;
			var ePoint;
			sPoint=Design._recPoints[0];
			ePoint=Design._recPoints[1];
			var prop;
			prop=Design._selectePropItem.props;
			var key;
			for(key in prop){
				delete prop[key];
			}
			prop.x=sPoint.x;
			prop.y=sPoint.y;
			prop.width=ePoint.x-sPoint.x;
			prop.height=ePoint.y-sPoint.y;
			return Design._selectePropItem;
		}

		__proto.showRuleRange=function(container){
			if(!container)return;
			var i=0,len=0;
			var tPoint;
			len=Design._recPoints.length;
			for(i=0;i<len;i++){
				tPoint=Design._recPoints[i];
				tPoint=container.localToGlobal(tPoint);
			}
			Notice.notify("SHOW_RULE_RANGE",[Design._recPoints]);
		}

		/**处理鼠标点开*/
		__proto.onStageMouseUp=function(e){
			this.clearAutoAlign();
			this.stage.off("mousemove",this,this.onStageMouseMove);
			this.stage.off("mouseup",this,this.onStageMouseUp);
			if (this._isDragSelect){
				this._selectLineLayer.width=this.mouseX-this._selectLineLayer.x;this._selectLineLayer.height=this.mouseY-this._selectLineLayer.y;
				var rect=this._selectLineLayer.getBounds();
				var point;
				point=new Point();
				point.setTo(rect.x,rect.y);
				point=(this._selectLineLayer.parent).localToGlobal(point);
				point=this._selectedBox.globalToLocal(point);
				rect.x=point.x;
				rect.y=point.y;
				if (rect.width>0){
					var box=new Rectangle();
					box.copyFrom(rect);
					var compRect=new Rectangle();
					for (var i=0,n=this._selectedBox.numChildren;i < n;i++){
						var display=this._selectedBox.getChildAt(i);
						if ((display).comXml){
							compRect.copyFrom(display.getBounds());
							if(compRect.width==0||compRect.height==0){
								compRect.x=display.x;
								compRect.y=display.y;
							}
							if (box.intersects(compRect)){
								if(FilterFuns.isEditorSelectableChain(display))
									this.selectComp(display);
							}
						}
					}
				}
				this._selectLineLayer.graphics.clear();
				}else if (this._isMove){
				if(this._selectedComps){
					var tComp;
					var len=0;
					len=this._selectedComps.length;
					for(i=0;i<len;i++){
						this.nodeChanged(this._selectedComps[i].comXml,["x","y","width","height"]);
					}
				}
				this.changeXml(this._xml,false);
				this._isMove=false;
				this.callLater(this.changeSelectComp);
			}
		}

		/**刷新参考视图*/
		__proto.refreshBg=function(){
			if (Boolean(this._sceneBg)){
				this._bgLayer.skin="";
				ResFileManager.clearRes(FileTools.getAbsPath(FileManager.getWorkPath(this._sceneBg)));
				this._bgLayer.skin=FileTools.getAbsPath(FileManager.getWorkPath(this._sceneBg));
				}else {
				this._bgLayer.skin=null;
			}
		}

		/**显示隐藏参考视图*/
		__proto.toggleBg=function(){
			this._bgLayer.visible=!this._bgLayer.visible;
		}

		/**更改场景大小*/
		__proto.changeSceneSize=function(){
			var g=this.graphics;
			g.clear();
			var offX=0;
			var offY=0;
			if(this.isGraphicAnimation||this.pageType=="MoveEffect"){
				offX=this._sceneWidth*0.5;
				offY=this._sceneHeight*0.5;
				g.drawRect(-offX,-offY,this._sceneWidth,this._sceneHeight,this._sceneColor);
				g.drawLine(0,-offY,0,-offY+this._sceneHeight,"#ff0000");
				g.drawLine(-offX,0,-offX+this._sceneWidth,0,"#ff0000");
				}else{
				g.drawRect(-offX,-offY,this._sceneWidth,this._sceneHeight,this._sceneColor);
			}
			if(this._sceneWidth>0&&this._sceneHeight>0){
				if(this.pageType!="prefab_ui"&&this.pageType!="Prefab")
					this._viewLayer.size(this._sceneWidth,this._sceneHeight);
			}
		}

		/**初始化视图*/
		__proto.init=function(viewXml){
			delete viewXml.selecteID;
			delete viewXml.selectedBox;
			this._xml=viewXml;
			this.animation=new AnimationDataWorker();
			this.animation.design=this;
			this.animation.animations=this._xml.animations;
			var changed=false;
			if(this.animation.animations){
				changed=AnimationDataWorker.removeWrongValueAniMationData(this.animation.animations);
			}
			this.animation.compMap=this._compMap;
			if(!this.animation.animations)this.animation.animations=[];
			delete this._xml.animations;
			if(changed){
				this.hasChange=true;
			}
		}

		__proto.recoverFromData=function(uixml,animations){
			if(this.animation){
				this.animation.animations=animations;
				if(!this.animation.animations)this.animation.animations=[];
			}
			this.xml=uixml;
			if(this.isAnimationMode){
				if(this.animation){
					this.animation.compMap=this._compMap;
					this.uiXmlRestored=uixml;
				}
				this.animation.isFirstSetUp=true;
				this.setAnimationData();
			}
		}

		/**更改视图*/
		__proto.change=function(reCreate){
			(reCreate===void 0)&& (reCreate=true);
			this.changeXml(this._xml,reCreate);
		}

		/**改变视图*/
		__proto.changeXml=function(newXml,reCreate){
			(reCreate===void 0)&& (reCreate=true);
			if (reCreate){
				this.xml=newXml;
			}
			this.cacheXML(newXml);
			this.hasChange=true;
			this._xmlsRemoved.length=0;
		}

		__proto.changeFromRepalce=function(newXml,reCreate){
			(reCreate===void 0)&& (reCreate=true);
			this.changeXml(newXml,reCreate);
		}

		/**缓存视图*/
		__proto.cacheXML=function(newXml){
			if(this.isAnimationMode){
				return;
			};
			var cacheData;
			cacheData=ObjectTools$1.copyObj(newXml);
			this._xmls.push(cacheData);
			if (this._xmls.length > 500+50){
				this._xmls.splice(1,50);
			}
		}

		__proto.getLastCache=function(){
			if(this._xmls&&this._xmls.length>1){
				return this._xmls[this._xmls.length-2];
			}
			return null;
		}

		__proto.cacheAni=function(){
			if(this.animation){
				StateManager.updateState(this.aniSign,this.animation.animations);
			}
		}

		/**向前恢复*/
		__proto.goForward=function(){
			if(this.isAnimationMode){
				if(this.animation){
					var tAnis;
					tAnis=StateManager.getState(this.aniSign).forward();
					if(tAnis){
						this.animation.animations=tAnis;
						this.setAnimationData();
					}
				}
				return;
			}
			if (this._xmlsRemoved.length > 0){
				this.clearSelect();
				var newXml=this._xmlsRemoved.pop();
				this.xml=newXml;
				this.cacheXML(newXml);
				this.hasChange=true;
			}
		}

		/**向后恢复*/
		__proto.goBack=function(){
			if(this.isAnimationMode){
				var tAnis;
				tAnis=StateManager.getState(this.aniSign).back();
				if(tAnis){
					this.animation.animations=tAnis;
					this.setAnimationData();
				}
				return;
			}
			this.clearSelect();
			if (this._xmls.length > 1){
				this._xmlsRemoved.push(this._xmls.pop());
			}
			this.xml=Utils.clone(this._xmls[this._xmls.length-1]);
			this.hasChange=true;
		}

		/**清除选择*/
		__proto.clearSelect=function(ifGotoRoot){
			(ifGotoRoot===void 0)&& (ifGotoRoot=false);
			if(!this.displayedInStage)return;
			var comp;
			for(var $each_comp in this._selectedComps){
				comp=this._selectedComps[$each_comp];
				this.removeBorder(comp);
			}
			this._selectedComps.length=0;
			this.callLater(this.changeSelectComp);
			if(ifGotoRoot){
				this.goToRoot();
			}
		}

		/**改变选择*/
		__proto.changeSelectComp=function(){
			if(!this.displayedInStage)return;
			this.updatePropPanel();
			this.refreshStatusInfo();
			this.showSelectRuleRange();
			Notice.notify("select_changed");
			Notice.notify("SELECTED_NODES",[this._selectedComps]);
		}

		__proto.updateDisplayTreeSelect=function(){
			DisplayTreePanel.instance.selectBySelectList(this._selectedComps);
		}

		__proto.updatePropPanel=function(){
			var selectedXml=this.selectedCompXml;
			this.updateDisplayTreeSelect();
			if (selectedXml){
				PropPanel.instance.init(selectedXml,selectedXml.compId);
				Notice.notify("DesignItemSelected",[selectedXml.compId]);
				}else if (this._selectedComps.length==0&&this.selectedBox){
				PropPanel.instance.init((this.selectedBox).comXml,(this.selectedBox).comXml.compId);
				}else if(this._selectedComps&&this._selectedComps.length>1){
				PropPanel.instance.init(this.getSelectePropItem());
				}else{
				PropPanel.instance.init(null);
			}
		}

		__proto.updateNameToPanels=function(){
			this.updateDisTreePanel();
			this.updateTimeLinePanel();
		}

		/**状态栏信息*/
		__proto.refreshStatusInfo=function(){
			var rect=this.getSelectCompsBonus();
			if(!UIPanel.instance.currViewer)return;
			if(!UIPanel.instance.currViewer.compInfo)return;
			if (rect){
				UIPanel.instance.currViewer.compInfo.text=Sys.lang("选择对象：")+"x:"+rect.x+" y:"+rect.y+"  w:"+rect.width+" h:"+rect.height;
				}else {
				UIPanel.instance.currViewer.compInfo.text=Sys.lang("使用右键拖动视窗，使用滚轮缩放视窗，Ctrl+0键恢复缩放");
			}
		}

		/**获得多个选择对象的区域*/
		__proto.getSelectCompsBonus=function(){
			if (this._selectedComps.length < 1){
				return null;
				}else {
				var rect=Design._designCompsBouns;
				rect.width=-1;
				for (var i=0,n=this._selectedComps.length;i < n;i++){
					var comp=this._selectedComps[i];
					var rt=comp.getBounds();
					rect=rect.width >=0 ? rect.union(rt,rect):rect.setTo(rt.x,rt.y,rt.width,rt.height);
				}
				return rect;
			}
		}

		/**刷新视图*/
		__proto.refresh=function(){
			this.xml=this._xml;
			this.changeSelectedBox();
			this.changeSelectComp();
			if(this.isFirstReFresh){
				this.isFirstReFresh=false;
				this.cacheXML(this._xml);
				this.setAnimationData();
				this.cacheAni();
				if(this.isGraphicAnimation){
					this.isAnimationMode=true;
				}
			}
		}

		// freshDatasLater();
		__proto.freshDatasLater=function(){
			if(!this.displayedInStage)return;
			this.setAnimationData();
			this.updateTreePanels();
			this.showSelectRuleRange();
		}

		__proto.updateTreePanels=function(){
			this.updateDisTreePanel();
			this.updateTimeLinePanel();
		}

		__proto.updateTimeLinePanel=function(){}
		__proto.updateDisTreePanel=function(){
			DisplayTreePanel.instance.init(this._treeData);
			this.updateDisplayTreeSelect();
		}

		__proto.createView=function(xml){
			if(!this.findXmlById(xml,xml.selectedBox)){
				xml.selectedBox=xml.compId;
			};
			var box=this.getCompById(xml.selectedBox);
			if(box&&box.parent==this){
				box=null;
			}
			if (box&&box.parent){
				_super.prototype.createView.call(this,xml);
				this.changeSceneSize();
				TimeTool.runAllCallLater();
				this.adptRootTree();
				var preSelects;
				preSelects=ObjectTools$1.concatArr([],this._selectedComps);
				this.selectedBox=this.getCompById(xml.selectedBox,false);
				Design.adptIRender(this.getCompById(xml.selectedBox,false));
				this.reSelectSelects(preSelects);
				}else {
				_super.prototype.createView.call(this,xml);
				this.changeSceneSize();
				this.adptRootTree();
				TimeTool.runAllCallLater();
				this.setSelectedBoxLater(this._viewLayer,xml);
			}
		}

		// trace("_selectedBox after create",_selectedBox);
		__proto.adptRootTree=function(){
			WalkTools.walkTargetEX(this._viewLayer,Design.removeRenders,this);
		}

		__proto.findSelecteBoxAndSet=function(xml){
			var nowBox=this.getCompById(xml.selectedBox);
			if(!nowBox.displayedInStage){
				Laya.timer.once(100,this,this.findSelecteBoxAndSet,[xml],true);
				}else{
				this.setSelectedBoxLater(nowBox,xml);
			}
		}

		__proto.setSelectedBoxLater=function(tSelectBox,xml){
			var preSelects;
			preSelects=ObjectTools$1.concatArr([],this._selectedComps);
			this.selectedBox=tSelectBox;
			if(!xml.props){
				xml.props={};
			}
			this.sceneColor=xml.props.sceneColor;
			this.sceneWidth=this.parseInt(xml.props.width || xml.props.sceneWidth || "800");
			this.sceneHeight=this.parseInt(xml.props.height || xml.props.sceneHeight || "600");
			this.size(this.sceneWidth,this.sceneHeight);
			this.sceneBg=xml.props.sceneBg;
			this._dragBoxLayer.removeAll();
			var arr=[];
			var comp;
			for(var $each_comp in preSelects){
				comp=preSelects[$each_comp];
				var display=this.getCompById((comp).comXml.compId);
				if (display !=null){
					arr.push(display);
					this.addBorder(display);
				}
			}
			this._selectedComps=arr;
		}

		__proto.getPropWidth=function(){
			return this.parseInt(this.xml.props.width || this.xml.props.sceneWidth || "0");
		}

		__proto.getPropHeight=function(){
			return this.parseInt(this.xml.props.height || this.xml.props.sceneHeight || "0");
		}

		__proto.reSelectSelects=function(preSelects){
			var arr=[];
			var comp;
			for(var $each_comp in preSelects){
				comp=preSelects[$each_comp];
				var display=this.getCompById((comp).comXml.compId);
				if (display !=null){
					arr.push(display);
					this.addBorder(display);
				}
			}
			this._selectedComps=arr;
		}

		/**根据compId查找xml*/
		__proto.findXmlById=function(xml,id){
			var map={};
			Utils.xmlToMapByCompId(xml,map);
			return map[id];
		}

		__proto.createComp=function(xml,comp,visibleMap){
			if(this._createComp==null){
				this._createComp=Utils.bind(this.createComp,this);
			}
			UIView._createCompS_=this._createComp;
			comp=_super.prototype.createComp.call(this,xml,comp,visibleMap);
			if (comp==null){
				return null;
			};
			var compId=(xml.compId)? xml.compId :this._autoId++;
			this._autoId=Math.max(compId+1,this._autoId);
			xml.compId=compId;
			this._compMap[compId]=comp;
			(comp).comXml=xml;
			return comp;
		}

		/**画矩形*/
		__proto.drawBox=function(width,height){
			var box=new Sprite();
			box.size(width,height);
			box.graphics.drawRect(0,0,width,height,null,"#ff0000");
			return box;
		}

		/**添加描边*/
		__proto.addBorder=function(target){
			if(target&&target.parent==this)return;
			var dragType=this.parseInt(UIConfigManager.getCompProp((target).comXml.type,"drag"));
			this._dragBoxLayer.addDrag(target,dragType);
		}

		/**去除描边*/
		__proto.removeBorder=function(target){
			this._dragBoxLayer.removeDrag(target);
		}

		/**根据id获取组件*/
		__proto.getCompById=function(id,adpt){
			(adpt===void 0)&& (adpt=true);
			if(adpt)this.adptCompMapByID(id);
			return this._compMap[id];
		}

		__proto.getCompOById=function(id){
			var node;
			node=this.getCompById(id);
			if(!node)return null;
			return node.comXml;
		}

		__proto.adptCompMapByID=function(id){
			if(this._compMap[id]&&(this._compMap [id]).displayedInStage)return;
			if(this._selectedBox)
				WalkTools.walkTarget(this._selectedBox,this.adptTTID,this);
		}

		__proto.adptTTID=function(item){
			if(item["comXml"]&&item["comXml"].compId){
				if(this._compMap)
					this._compMap[item["comXml"].compId]=item;
			}
		}

		__proto.selectCompByID=function(id,ignoreLock,ignoreHide){
			(ignoreLock===void 0)&& (ignoreLock=false);
			(ignoreHide===void 0)&& (ignoreHide=false);
			var comp;
			comp=this.getCompById(id);
			if(comp){
				this.selectComp(comp,ignoreLock,ignoreHide);
			}
		}

		__proto.recoverSelected=function(){
			if(this._selectedBox==this._viewLayer)return;
			this._maskLayer.visible=false;
			if (this._selectedBox !=null && this._selectedBox !=this._viewLayer){
				var boxParent=this.getCompById((this._selectedBox).comXml.nodeParent);
				boxParent.addChild(this._selectedBox);
			}
			this._selectedBox=null;
			this._xml.selectedBox=-1;
		}

		__proto.isItemSame=function(itemA,itemB){
			if(!itemA||!itemB)return false;
			if(itemA==itemB)return true;
			if(itemA.compId==itemB.compId&&itemA.compId)return true;
			return false;
		}

		/**选择容器变化*/
		__proto.changeSelectedBox=function(){}
		/**双击选择父容器*/
		__proto.onMaskDoubleClick=function(e){
			if(e){
				e.stopPropagation();
			}
			this.cancelMouseState();
			if (this._selectedBox !=this._viewLayer){
				}else{
				return;
			}
			this.selectCompChainHandler(this._xml.selectedBox,true);
			this.playBoxEffect(true);
		}

		/**
		*取消层级选中，回到最顶层
		*
		*/
		__proto.goBackToStage=function(){
			delete this._xml.selectedBox;
			this.xml=this._xml;
		}

		/**处理双击*/
		__proto.onDoubleClick=function(e){
			e.stopPropagation();
			var target=this.selectedComp;
			if(target==null){
				this.onMaskDoubleClick(null);
				return;
			}
			if ((target).comXml.type=="UIView"){
				var path=FileManager.getPath(SystemSetting.pagesPath,(target).comXml.source);
				path=path.replace(".xml","."+TypeManager.getExtension("page"));
				Notice.notify("openPAGE",[path]);
				}else if (target && this._selectedBox !=target && FilterFuns.isEditorEnterAble(target)){
				if(this.isAnimationMode){
					var tType;
					tType=(target).comXml.type;
					if(FilterFuns.isUnAnimationAbleType(tType)){
						return;
					}
				}
				this._xml.selectedBox=(target).comXml.compId;
				this.cacheXML(this._xml);
				this.selectedBox=target;
				this.playBoxEffect(false);
			}
		}

		// if(!DisControlTool.isInTree(tar
		__proto.playBoxEffect=function(isBack){
			return;
			var point=(this._selectedBox.parent).localToGlobal(new Point(this._selectedBox.x+this._selectedBox.width *0.5,this._selectedBox.y+this._selectedBox.height *0.5));
			UIPanel.instance.currViewer.playBoxEffect(point.x,point.y,isBack);
		}

		__proto.isSelectedCompsUnderMouse=function(){
			if(!this._selectedComps||this._selectedComps.length<1)return false;
			if(!this._selectedBox)return false;
			var compRect=new Rectangle();
			var mousePos;
			mousePos=this._selectedBox.getMousePoint();
			Design.smousePos.setTo(mousePos.x,mousePos.y);
			mousePos=Design.smousePos;
			for (var i=this._selectedComps.length-1;i>=0;i--){
				var display=this._selectedComps[i];
				if ((display).comXml){
					compRect.setTo(display.x,display.y,display.width,display.height);
					compRect.copyFrom(display.getBounds());
					if (compRect.contains(mousePos.x,mousePos.y)){
						return true;
					}
				}
			}
			return false;
		}

		/**移动组件*/
		__proto.moveSelectedComps=function(mx,my){
			if (this._selectedComps.length > 0){
				for (var i=0,n=this._selectedComps.length;i < n;i++){
					var comp=this._selectedComps[i];
					comp.x+=mx;
					comp.y+=my;
					var info=(comp).comXml;
					info.props.x=comp.x;
					info.props.y=comp.y;
					this.updateNodePosInfo(info.props,comp);
					this._dragBoxLayer.refreshDrag(comp);
					this.nodeChanged(info,["x","y"]);
				}
				this.changeXml(this._xml,false);
				this.callLater(this.changeSelectComp);
			}
		}

		/**选择组件*/
		__proto.selectComp=function(comp,ignoreLock,ignoreHide,dealInput){
			(ignoreLock===void 0)&& (ignoreLock=false);
			(ignoreHide===void 0)&& (ignoreHide=false);
			(dealInput===void 0)&& (dealInput=true);
			if(!comp)return;
			if(!FilterFuns.isEditorSelectableChain(comp,ignoreLock,ignoreHide))return;
			this._selectedComps.push(comp);
			this.addBorder(comp);
			this.callLater(this.changeSelectComp);
			this._xml.selecteID=(comp).comXml.compId;
		}

		/**撤销组件选择*/
		__proto.unSelectComp=function(comp){
			var index=this._selectedComps.indexOf(comp);
			if (index !=-1){
				this._selectedComps.splice(index,1);
				this.removeBorder(comp);
				this.callLater(this.changeSelectComp);
			}
		}

		/**选择所有*/
		__proto.selectAll=function(){
			this.clearSelect();
			var box=this._selectedBox;
			for (var i=0,n=box.numChildren;i < n;i++){
				var comp=box.getChildAt(i);
				if(!FilterFuns.isEditorSelectableChain(comp))continue ;
				if ((comp).comXml){
					this.selectComp(comp);
				}
			}
		}

		__proto.getIDedSelectedXmls=function(){
			return this.getSelectedXmls(true);
		}

		__proto.getSelectedXmls=function(withID){
			(withID===void 0)&& (withID=false);
			var arr=[];
			if (this._selectedComps.length > 0){
				var comp;
				for(var $each_comp in this._selectedComps){
					comp=this._selectedComps[$each_comp];
					var info=(comp).comXml;
					var clone=Utils.clone(info);
					if(!withID)
						this.deleteCompId(clone);
					var parentChilds=this._treeData.getNodeParent(info).child;
					arr.push({index:parentChilds.indexOf(info),xml:clone});
				}
				arr.sort(MathUtil.sortByKey("index"));
			}
			return arr;
		}

		__proto.deleteCompId=function(xml){
			delete xml.compId;
			var list=xml.child;
			if(!list)return;
			var child;
			for(var $each_child in list){
				child=list[$each_child];
				this.deleteCompId(child);
			}
		}

		__proto.onDelConfirm=function(sure){
			if(sure){
				this.delSelectedCompsWork();
			}
		}

		/**删除组件*/
		__proto.delSelectedComps=function(){
			if(this.isAnimationMode||this.isGraphicAnimation){
				Confirm.show(Sys.lang("是否确认删除（可能会导致其他动画丢失）"),Sys.lang("是否删除"),Utils.bind(this.onDelConfirm,this));
				return;
			}
			this.delSelectedCompsWork();
		}

		__proto.delSelectedCompsWork=function(){
			if(!this._selectedComps||this._selectedComps.length<1)return;
			var deletedIds;
			deletedIds=[];
			for (var i=0,n=this._selectedComps.length;i < n;i++){
				var comp=this._selectedComps[i];
				if (comp.parent){
					var compX;
					compX=(comp).comXml;
					var info=this._treeData.getNodeParent(compX).child;
					info.splice(info.indexOf(compX),1);
					comp.parent.removeChild(comp);
					deletedIds.push(compX.compId);
					if(this.uiXmlRestored){
						TreeData.removeNodeFromNodeTree(this.uiXmlRestored,compX.compId);
					}
					if(this.animation&&this.animation.animations){
						AnimationDataWorker.removeNodeFromAnimationData(this.animation.animations,compX.compId);
					}
				}
			}
			Notice.notify("Node_deleted",[deletedIds]);
			this.clearSelect();
			this.changeXml(this._xml,true);
			this.updateTreePanels();
		}

		/**根据层选择组件*/
		__proto.selectByLayer=function(layer){
			this.clearSelect();
			var box=(this._selectedBox).comXml;
			var list=box.child;
			var child;
			for(var $each_child in list){
				child=list[$each_child];
				if (child.layer==layer){
					this.selectComp(this.getCompById(child.compId));
				}
			}
		}

		/**转换容器内部坐标为相对坐标*/
		__proto.parseAutoBox=function(box,dX,dy){
			(dX===void 0)&& (dX=0);
			(dy===void 0)&& (dy=0);
			var list=box.child;
			var length=list.length;
			if(!box.props.x){
				box.props.x=0;
			}
			if(!box.props.y){
				box.props.y=0;
			}
			if (length < 1 || box.props.width || box.props.height||box.props.pivotX||box.props.pivotY){
				return box;
			};
			var mx=this.parseInt(list[0].props.x)||0;
			var my=this.parseInt(list[0].props.y)||0;
			for (var i=1;i < length;i++){
				var child=list[i];
				mx=Math.min(mx,child.props.x||0);
				my=Math.min(my,child.props.y||0);
			}
			if(dX!=0&&dy!=0){
				mx=dX;
				my=dy;
			}
			if (mx !=0 || my !=0){
				box.props.x=this.parseInt(box.props.x)+mx;
				box.props.y=this.parseInt(box.props.y)+my;
				for (var j=0;j < length;j++){
					child=list[j];
					child.props.x=this.parseInt(child.props.x)-mx;
					child.props.y=this.parseInt(child.props.y)-my;
					if (child.props.x=="0"){
						delete child.props.x;
					}
					if (child.props.y=="0"){
						delete child.props.y;
					}
				}
			}
			return box;
		}

		/**根据图层清理选择*/
		__proto.clearSelectByLayer=function(layer){
			for (var i=this._selectedComps.length-1;i >-1;i--){
				var comp=this._selectedComps[i];
				if ((comp).comXml.layer==layer){
					this.removeBorder(comp);
					this._selectedComps.splice(i,1);
				}
			}
		}

		/**根据图层控制，隐藏关闭的图层上面的组件*/
		__proto.refreshCompsByLayer=function(){
			var info=(this._selectedBox).comXml;
			var layers=String(info.layers).split(";");
			var closeLayers=[];
			for (var i=0,n=layers.length;i < n;i++){
				var a=layers[i].split(",");
				if (a[1]==0){
					closeLayers.push(a[0]);
				}
			}
			for (var j=0,m=this._selectedBox.numChildren;j < m;j++){
				var comp=this._selectedBox.getChildAt(j);
				if (Laya.__typeof(comp,'laya.ui.IComponent')&& (comp).comXml !=null){
					comp.visible=closeLayers.indexOf(String((comp).comXml.layer))==-1;
				}
			}
		}

		__proto.getAddPrefabData=function(resPath){
			var obj;
			try{
				var prefabPath;
				prefabPath=resPath;
				obj=FileManager.readJSONFile(prefabPath);
				TreeDataTool.deleteAllKeyBut(obj,PreFabManager.reserveKeys);
				if(PreFabManager.PrefabHasWrap){
					if(obj.child&&obj.child[0]){
						obj=obj.child[0];
					}
				}
				}catch(e){
				obj=null;
			}
			if(!obj){
				Alert.show(Sys.lang("创建预设实例失败！")+prefabPath);
				return null;
			};
			var compId=this._autoId++;
			obj.compId=compId;
			return obj;
		}

		__proto.getAddCompData=function(resPath,type){
			var compId=this._autoId++;
			var str="";
			var obj;
			obj={};
			var prop=UIConfigManager.getCompSkinLabel(type);
			if(type=="Prefab"){
				return this.getAddPrefabData(resPath);
			}else
			if(type=="Script"){
				obj.type=type;
				obj.props={};
				obj.source=FileManager.getWorkRelativePath(resPath);
				}else{
				obj.type=type;
				obj.props={};
				if(resPath!=""){
					obj.props[prop]=FileManager.getResRelativePath(resPath);
				}
				UIConfigManager.inserDefaultValue(obj);
			}
			obj.compId=compId;
			return obj;
		}

		__proto.addCompWork=function(compData,x,y,parentId,abPos,index){
			(x===void 0)&& (x=-1);
			(y===void 0)&& (y=-1);
			(parentId===void 0)&& (parentId=-1);
			(abPos===void 0)&& (abPos=false);
			(index===void 0)&& (index=-1);
			if(!compData)return;
			this.stage.focus=this;
			var point=new Point();
			var box;
			if(parentId<0){
				parentId=this.xml.selectedBox;
				x=(x==-1 ? this.stage.mouseX :x);
				y=(y==-1 ? this.stage.mouseY :y);
				point.setTo(x,y);
				box=this.getCompById(parentId);
				if(!abPos){
					point=box.globalToLocal(point);
				}
				}else{
				box=this.getCompById(parentId);
				point.setTo(0,0);
			}
			if(!box)return;
			var boxXml=(box).comXml;
			if(boxXml==null){
				return;
			}
			boxXml=this.findXmlById(this._xml,(box).comXml.compId);
			if(point.x!=0){
				compData.props.x=Math.round(point.x);
			}
			if(point.y!=0){
				compData.props.y=Math.round(point.y);
			}
			if(!TypeManager.canNodeAddToType(compData.type,boxXml.type)){
				MessageManager.instance.show(Sys.lang("{0}不可创建{1}子对象",boxXml.type,compData.type));
				return;
			}
			if(index<0||index>=boxXml.child.length){
				boxXml.child.push(compData);
				}else{
				boxXml.child.splice(index,0,compData);
			}
			if(this.isGraphicAnimation&&this.isAnimationMode){
				var preProp;
				preProp=compData.props;
				compData.props={};
			}
			this._xml.selectedBox=parentId;
			this.changeXml(this._xml);
			var compId=compData.compId;
			if(this.getCompById(compId)){
				this.clearSelect();
				this.selectComp(this.getCompById(compId));
			}
			if(this.isGraphicAnimation&&this.isAnimationMode){
				compData.props=preProp;
			}
			this.addCompHandler(compData,boxXml.compId);
			Design.beginCtrlAdd();
		}

		__proto.addCompHandler=function(node,parentId){}
		__proto.getAddDataByDragEvent=function(e){
			if(this.isGraphicAnimation){
				if(e.data.type=="res"){
					if(e.data.asset=="")return null;
					if(!ResFileManager.isResFile(e.data.asset))return null;
					return this.getAddCompData(e.data.asset,TypeManager.GraphicPic);
					}else{
					return null;
				}
			};
			var addData;
			switch(e.data.type){
				case "res":
					addData=this.getAddCompData(e.data.asset,e.data.compType);
					break ;
				case "page":
					addData=this.getAddUIViewData(e.data.path);
					break ;
				}
			return addData;
		}

		__proto.getAddParticlePlayerData=function(particlePath){
			var compId=this._autoId++;
			var path=FileManager.adptToCommonUrl(FileManager.getRelativePath(SystemSetting.pagesPath,particlePath));
			var nData;
			nData={
				type:"Particle2D",
				compId:compId,
				source:path,
				props:{
					url:path
				},
				child:[]
			};
			return nData;
		}

		__proto.getAddUIViewData=function(uiPath){
			if(FileManager.adptToCommonUrl(uiPath)==FileManager.adptToCommonUrl(IDEAPIS.getCurPagePath())){
				Alert.show(Sys.lang("不能循环嵌套！"));
				return null;
			};
			var nData;
			switch(TypeManager.getFileType(uiPath)){
				case "particle":
					nData=this.getAddParticlePlayerData(uiPath);
					break ;
				case "ui_template":
					break ;
				case "particle3D":
					break ;
				case "Script":
					nData=this.getAddCompData(uiPath,"Script");
					break ;
				case "graphic_animation":
					break ;
				case "Prefab":
					nData=this.getAddPrefabData(uiPath);
					break ;
				default :;
					var compId=this._autoId++;
					var path=FileManager.adptToCommonUrl(FileManager.getRelativePath(SystemSetting.pagesPath,uiPath));
					nData={
						type:"UIView",
						compId:compId,
						source:path,
						props:{
						},
						child:[]
					};
				}
			return nData;
		}

		__proto.addTemplate=function(tempPath,x,y,parentId){
			(x===void 0)&& (x=-1);
			(y===void 0)&& (y=-1);
			(parentId===void 0)&& (parentId=-1);
			if(this.isAnimationMode){
				Alert.show(Sys.lang("动画编辑模式中，该功能不可用。"));
				return;
			}
			this.stage.focus=this;
			x=(x==-1 ? this.stage.mouseX :x);
			y=(y==-1 ? this.stage.mouseY :y);
			var box=this.getCompById(this.xml.selectedBox);
			var point=box.globalToLocal(new Point(x,y));
			var boxXml=(box).comXml;
			if (boxXml !=null){
				var compId=0;
				var path=FileManager.adptToCommonUrl(FileManager.getRelativePath(SystemSetting.pagesPath,tempPath));
				var filePath;
				filePath=TemplateManager.getUIFilePath(tempPath);
				var resPath;
				resPath=TemplateManager.getUIResPath(tempPath);
				FileTools.copyDir(resPath,FileManager.getResPath("template"+"/"+FileTools.getFileName(tempPath)));
				Notice.notify("FRESH_RES");
				var tempData;
				tempData=FileManager.readJSONFile(filePath);
				this.reIDNode(tempData);
				var addChilds;
				addChilds=tempData.child;
				if(!addChilds)addChilds=[];
				var tarChilds;
				if(!boxXml.child)boxXml.child=[];
				tarChilds=boxXml.child;
				var i=0,len=0;
				var tChild;
				len=addChilds.length;
				var tProp;
				var addCompIds;
				addCompIds=[];
				for(i=0;i<len;i++){
					tChild=addChilds[i];
					compId=tChild.compId;
					addCompIds.push(compId);
					tProp=tChild.props;
					tProp.x=tProp.x?tProp.x:0;
					tProp.y=tProp.y?tProp.y:0;
					tProp.x=Math.floor(parseFloat(tProp.x)+point.x);
					tProp.y=Math.floor(parseFloat(tProp.y)+point.y);
					tarChilds.push(tChild);
				}
				Laya.timer.once(1000,this,this.freshUI,[this._xml,addCompIds]);
			}
		}

		__proto.reIDNode=function(node){
			this._autoId++;
			node.compId=this._autoId;
			var childs;
			if(!node.child)node.child=[];
			childs=node.child;
			var i=0,len=0;
			len=childs.length;
			for(i=0;i<len;i++){
				this.reIDNode(childs[i]);
			}
		}

		__proto.cleanIDUsed=function(){
			var key;
			for(key in this._idUsed){
				delete this._idUsed[key];
			}
		}

		__proto.ensureIDNode=function(node,root){
			(root===void 0)&& (root=false);
			if(root){
				this.cleanIDUsed();
			}
			this.idNode(node,false);
			var childs;
			if(!node.child)node.child=[];
			childs=node.child;
			var i=0,len=0;
			len=childs.length;
			for(i=0;i<len;i++){
				this.ensureIDNode(childs[i]);
			}
		}

		__proto.freshUI=function(newXML,selects){
			this.changeXml(newXML);
			this.clearSelect();
			var i=0,len=0;
			len=selects.length;
			for(i=0;i<len;i++){
				this.selectCompByID(selects[i]);
			}
		}

		/**层变化后切换*/
		__proto.refreshAtLayerChanged=function(){
			this.sortXmlByLayer((this._selectedBox).comXml);
			this.changeXml(this._xml);
		}

		/**根据层进行排序*/
		__proto.sortXmlByLayer=function(box){}
		__proto.changeCompType=function(type){
			if(this.isAnimationMode||this.isGraphicAnimation){
				Alert.show(Sys.lang("动画编辑模式中，该功能不可用。"));
				return;
			}
			if (type && this._selectedComps.length > 0){
				var comps=this.getIDedSelectedXmls();
				for (var i=comps.length-1;i >-1;i--){
					var info=comps[i].xml;
					var tCompId=0;
					var tComp;
					if(!info)continue ;
					tCompId=info.compId;
					tComp=this.getCompOById(tCompId);
					if(tComp){
						tComp.type=type;
					}
				}
				this.clearSelect();
				this.changeXml(this._xml);
			}
		}

		/**将所选组件打包到容器内*/
		__proto.boxComp=function(type){
			if(this.isAnimationMode||this.isGraphicAnimation){
				Alert.show(Sys.lang("动画编辑模式中，该功能不可用。"));
				return;
			}
			if (type && this._selectedComps.length > 0){
				var box;
				var compId=this._autoId++;
				box={
					type:type,
					compId:compId,
					child:[],
					props:{}
				};
				var comps=this.getIDedSelectedXmls();
				var parent=(this._selectedBox).comXml;
				var parentChilds=parent.child;
				if(!Design.boxC)
					Design.boxC=new Box();
				Design.boxC.removeChildren();
				for (var i=comps.length-1;i >-1;i--){
					var info=comps[i];
					parentChilds.splice(info.index,1);
					Design.boxC.addChild(this.getCompById(info.xml.compId));
					this._treeData.addChild(info.xml,box);
				}
				box.child=box.child.reverse();
				var rec;
				rec=Design.boxC.getSelfBounds();
				box=this.parseAutoBox(box,rec.x,rec.y);
				this._treeData.addChild(box,parent);
				this.clearSelect();
				this.changeXml(this._xml);
			}
		}

		__proto.idNode=function(node,force){
			(force===void 0)&& (force=false);
			if(!force&&node.compId&&(!this._idUsed[node.compId])){
				}else{
				var compId=this._autoId++;
				while(this._idUsed[compId])compId++;
				this._autoId=compId+1;
				node.compId=compId;
			}
			this._idUsed[node.compId]=true;
		}

		__proto.dealAction=function(funName,param){
			if ((typeof (this[funName])=='function')){
				this[funName].apply(this,param);
			}
		}

		__proto.refreshComp=function(comp,key,value,hasDelete){
			(hasDelete===void 0)&& (hasDelete=false);
			if(!comp){
				console.log("refreshComp but comp==null");
				return;
			};
			var data=(comp).comXml;
			if(data.compId==this._xml.compId){
				if(key=="width"){
					this.sceneWidth=value;
				}
				if(key=="height"){
					this.sceneHeight=value;
				}
			}
			if(this._treeData.isNodeSame(data,this._treeData.root)){
				this.xml=this._xml;
				return;
			}
			if(comp==this._selectedBox||(Design.simpleValueDic[key]&&value!=""&&!hasDelete)){
				ObjectTools$1.setObjValue(comp,key,value);
				return;
			};
			var newComp;
			newComp=this.createComp(data);
			if(comp.parent){
				var preIndex=0;
				var preParent;
				preParent=comp.parent;
				preIndex=preParent.getChildIndex(comp);
				preParent.addChildAt(newComp,preIndex);
				comp.removeSelf();
			}
		}

		/**
		*获取节点的配置信息
		*@param comp
		*@return
		*
		*/
		__proto.getConfigData=function(comp){
			if(!comp)return null;
			var data=(comp).comXml;
			if(!data)return null;
			var i=0,len=0;
			var childList;
			if(!data.child)data.child=[];
			var dataChildList;
			dataChildList=data.child;
			dataChildList.length=0;
			childList=DisControlTool.getAllChild(comp);
			len=childList.length;
			var tChildData;
			for(i=0;i<len;i++){
				tChildData=this.getConfigData(childList[i]);
				if(tChildData){
					if(!tChildData.type){
						debugger;
					}
					dataChildList.push(tChildData);
				}
			}
			return data;
		}

		/**把组件从容器内打散*/
		__proto.unBoxComp=function(){
			if(this.isAnimationMode){
				Alert.show(Sys.lang("动画编辑模式中，该功能不可用。"));
				return;
			};
			var target=this.selectedComp;
			if (target !=null && Laya.__typeof(target,'laya.ui.IBox')){
				var box=(target).comXml;
				var parent=this._treeData.getNodeParent(box).child;
				var parentIndex=0;
				parentIndex=parent.indexOf(box);
				var preChilds;
				preChilds=parent.slice(0,parentIndex);
				var afterChilds;
				afterChilds=parent.slice(parentIndex+1);
				var ox=box.props.x || 0;
				var oy=box.props.y || 0;
				var list=box.child;
				var newChilds=[];
				for (var j=0,n=list.length;j < n;j++){
					var child=list[j];
					preChilds.push(child);
					child.props.x=this.parseInt(child.props.x || "0")+ox;
					child.props.y=this.parseInt(child.props.y ||"0")+oy;
				}
				preChilds=preChilds.concat(afterChilds);
				this._treeData.getNodeParent(box).child=preChilds;
				this.clearSelect();
				this.changeXml(this._xml);
			}
		}

		__proto.toInt=function(v){
			return Math.floor(v);
		}

		/**对齐选中的组件*/
		__proto.alignComp=function(type){
			if (Boolean(type)&& this._selectedComps.length > 1){
				var goal=0;
				var target=this._selectedComps[0];
				if (type=="left"){
					goal=target.x;
					}else if (type=="right"){
					goal=target.x+target.width*target.scaleX;
					}else if (type=="top"){
					goal=target.y;
					}else if (type=="bottom"){
					goal=target.y+target.height*target.scaleY;
					}else if (type=="middle"){
					goal=target.y+target.height *0.5*target.scaleY;
					}else if (type=="center"){
					goal=target.x+target.width *0.5*target.scaleX;
				}
				for (var i=1,n=this._selectedComps.length;i < n;i++){
					target=this._selectedComps[i];
					if (type=="left"){
						goal=Math.min(target.x,goal);
						}else if (type=="right"){
						goal=Math.max(target.x+target.width*target.scaleX,goal);
						}else if (type=="top"){
						goal=Math.min(target.y,goal);
						}else if (type=="bottom"){
						goal=Math.max(target.y+target.height*target.scaleY,goal);
						}else if (type=="middle"){
						goal=Math.max(target.y+target.height*target.scaleY *0.5,goal);
						}else if (type=="center"){
						goal=Math.max(target.x+target.width*target.scaleX *0.5,goal);
					}
				}
				for (var j=0,m=this._selectedComps.length;j < m;j++){
					target=this._selectedComps[j];
					var info=(target).comXml;
					var props;
					props=info.props;
					if (type=="left"){
						target.x=props.x=goal;
						}else if (type=="right"){
						target.x=props.x=goal-target.width*target.scaleX;
						}else if (type=="top"){
						target.y=props.y=goal;
						}else if (type=="bottom"){
						target.y=props.y=goal-target.height*target.scaleY;
						}else if (type=="middle"){
						target.y=props.y=goal-target.height*target.scaleY *0.5;
						}else if (type=="center"){
						target.x=props.x=goal-target.width*target.scaleX *0.5;
						}else if(type=="toCenter"){
						target.x=props.x=-target.width*0.5*target.scaleX;
						target.y=props.y=-target.height*0.5*target.scaleY;
					}
					this.adptPosToInt(target,props);
					this._dragBoxLayer.refreshDrag(target);
					this.nodeChanged(info,["x","y"]);
				}
				this.changeXml(this._xml,false);
			}
		}

		__proto.adptPosToInt=function(target,props){
			if(!target||!props)return;
			target.x=props.x=this.toInt(target.x);
			target.y=props.y=this.toInt(target.y);
		}

		/**调整组件对其*/
		__proto.placeComp=function(type){
			var target=this.selectedComp;
			if(!target||!target.parent)return;
			var width=(target.parent).width;
			var height=(target.parent).height;
			if(this.isGraphicAnimation){
				width=this.getPropWidth();
				height=this.getPropHeight();
			}
			if (target !=null){
				var info=(target).comXml;
				if (type=="top_left"){
					target.x=info.props.x=target.pivotX;
					target.y=info.props.y=target.pivotY
					}else if (type=="top_right" && target.parent){
					target.x=info.props.x=width-target.width*target.scaleX+target.pivotX;
					target.y=info.props.y=target.pivotY;
					}else if (type=="bottom_left" && target.parent){
					target.x=info.props.x=target.pivotX;
					target.y=info.props.y=height-target.height*target.scaleY+target.pivotY;
					}else if (type=="bottom_right" && target.parent){
					target.x=info.props.x=width-target.width*target.scaleX+target.pivotX;
					target.y=info.props.y=height-target.height*target.scaleY+target.pivotY;
					}else if (type=="center" && target.parent){
					target.x=info.props.x=(width-target.width*target.scaleX)*0.5+target.pivotX;
					}else if (type=="middle" && target.parent){
					target.y=info.props.y=(height-target.height*target.scaleY)*0.5+target.pivotY;
					}else if(type=="toCenter"){
					target.x=info.props.x=-target.width*0.5*target.scaleX;
					target.y=info.props.y=-target.height*0.5*target.scaleY;
				}
				this.adptPosToInt(target,info.props);
				this._dragBoxLayer.refreshDrag(target);
				this.changeSelectComp();
				this.nodeChanged(info,["x","y"]);
				this.changeXml(this._xml,false);
			}
		}

		/**平均分配组件*/
		__proto.spaceComp=function(type){
			if (this._selectedComps.length > 2){
				var total=0;
				var count=0;
				var num=this._selectedComps.length;
				this._selectedComps.sort(MathUtil.sortByKey(type=="h" ? "x" :"y"));
				var first=this._selectedComps[0];
				var last=this._selectedComps[num-1];
				total=type=="h" ? last.x+last.width-first.x :last.y+last.height-this._selectedComps[0].y;
				for (var i=0;i < num;i++){
					var comp=this._selectedComps[i];
					count+=type=="h" ? comp.width :comp.height;
				};
				var space=(total-count)/ (num-1);
				var start=type=="h" ? first.x :first.y;
				for (var j=0;j < num;j++){
					comp=this._selectedComps[j];
					var info=(comp).comXml;
					if (type=="h"){
						comp.x=info.props.x=Math.round(start);
						start+=comp.width+space;
						}else {
						comp.y=info.props.y=Math.round(start);
						start+=comp.height+space;
					}
					this._dragBoxLayer.refreshDrag(comp);
					this.nodeChanged(info,["x","y"]);
				}
				this.changeXml(this._xml,false);
			}
		}

		/**重复组件*/
		__proto.repeatComp=function(row,column,paddingX,paddingY){
			if(this.isAnimationMode){
				Alert.show(Sys.lang("动画编辑模式中，该功能不可用。"));
				return;
			};
			var target=this.selectedComp;
			if (target !=null){
				var currXml=(target).comXml;
				var parent=target.parent;
				for (var i=0;i < row;i++){
					for (var j=0;j < column;j++){
						if (i==0 && j==0){
							currXml.props.name="item0";
							}else {
							var clone=Utils.clone(currXml);
							clone.props.x=this.parseInt(clone.props.x)+j *(paddingX+target.width);
							clone.props.y=this.parseInt(clone.props.y)+i *(paddingY+target.height);
							clone.props.name="item"+(j+i *column);
							delete clone.compId;
							parent.comXml.child.push(clone);
						}
					}
				}
				this.changeXml(this._xml);
			}
		}

		__proto.makeVarOK=function(compO){
			delete compO.props["var"];
		}

		/**粘贴组件*/
		__proto.pasteComp=function(copyTemp,samePoint){
			if(this.isAnimationMode){
				Alert.show(Sys.lang("动画编辑模式中，该功能不可用。"));
				return;
			};
			var ids=[];
			var parent=(this._selectedBox).comXml;
			var obj;
			for(var $each_obj in copyTemp){
				obj=copyTemp[$each_obj];
				var temp=obj.xml;
				temp.props.x=this.parseInt(temp.props.x)+(samePoint ? 0 :10);
				temp.props.y=this.parseInt(temp.props.y)+(samePoint ? 0 :10);
				var newXml=Utils.clone(temp);
				ids.push(this._autoId);
				newXml.compId=this._autoId++;
				this.makeVarOK(newXml);
				parent.child.push(newXml);
			}
			this.changeXml(this._xml);
			this.clearSelect();
			var compId;
			for(var $each_compId in ids){
				compId=ids[$each_compId];
				this.selectComp(this.getCompById(compId));
			}
		}

		__proto.pasetCompUnderMouse=function(){
			var copyTemp;
			copyTemp=UIPanel.instance.getCopyTemp();
			if(!copyTemp||copyTemp.length<1)return;
			if(this.isAnimationMode){
				Alert.show(Sys.lang("动画编辑模式中，该功能不可用。"));
				return;
			};
			var ids=[];
			var parent=(this._selectedBox).comXml;
			var dx=NaN;
			var dy=NaN;
			dx=0;
			dy=0;
			var i=0,len=0;
			len=copyTemp.length;
			var temp;
			temp=copyTemp[0].xml;
			dx=this.parseInt(temp.props.x);
			dy=this.parseInt(temp.props.y);
			var tx=NaN;
			var ty=NaN;
			for(i=1;i<len;i++){
				temp=copyTemp[i].xml;
				tx=this.parseInt(temp.props.x);
				ty=this.parseInt(temp.props.y);
				if(dx>tx)dx=tx;
				if(dy>ty)dy=ty;
			}
			dx=this.selectedBox.mouseX-dx;
			dy=this.selectedBox.mouseY-dy;
			var obj;
			for(var $each_obj in copyTemp){
				obj=copyTemp[$each_obj];
				temp=obj.xml;
				temp.props.x=this.parseInt(temp.props.x)+dx;
				temp.props.y=this.parseInt(temp.props.y)+dy;
				var newXml=Utils.clone(temp);
				ids.push(this._autoId);
				newXml.compId=this._autoId++;
				this.makeVarOK(newXml);
				parent.child.push(newXml);
			}
			this.changeXml(this._xml);
			this.clearSelect();
			var compId;
			for(var $each_compId in ids){
				compId=ids[$each_compId];
				this.selectComp(this.getCompById(compId));
			}
		}

		__proto.nodeChanged=function(node,props,forceChange){
			(forceChange===void 0)&& (forceChange=false);
		}

		/**更改同层先后顺序*/
		__proto.sortComp1=function(up){
			(up===void 0)&& (up=true);
			if(this.isAnimationMode){
				Alert.show(Sys.lang("动画编辑模式中，该功能不可用。"));
				return;
			};
			var arr=this._selectedComps.sort(this.sortOnIndex);
			if (up){
				arr.reverse();
			};
			var flag=false;
			for (var i=0,n=arr.length;i < n;i++){
				var target=arr[i];
				var info=(target).comXml;
				var parent=(target.parent).comXml;
				var index=info.childIndex();
				delete parent.children()[index];
				var insertIndex=up ? index :index-1;
				var count=parent.children().length();
				insertIndex=insertIndex < 0 ? 0 :(insertIndex > count-1 ? count-1 :insertIndex);
				if (up){
					parent.insertChildAfter(parent.children()[insertIndex],info);
					}else {
					parent.insertChildBefore(parent.children()[insertIndex],info);
				}
				flag=true;
				this.nodeChanged(info);
			}
			if (flag){
				this.sortXmlByLayer((target.parent).comXml);
				this.changeXml(this._xml);
			}
		}

		/**更改同层先后顺序*/
		__proto.sortComp=function(up){
			(up===void 0)&& (up=true);
			if(this.isAnimationMode){
				Alert.show(Sys.lang("动画编辑模式中，该功能不可用。"));
				return;
			};
			var arr=this._selectedComps.sort(this.sortOnIndex);
			if (up){
				arr.reverse();
			};
			var flag=false;
			for (var i=0,n=arr.length;i < n;i++){
				var target=arr[i];
				var info=(target).comXml;
				var parent=this._treeData.getNodeParent(info);
				var index=this._treeData.getChildIndex(info,parent);
				this._treeData.removeSelf(info);
				var insertIndex=up ? index+1 :index-1;
				var count=TreeData.getNodeChilds(parent).length;
				insertIndex=insertIndex < 0 ? 0 :(insertIndex > count ? count :insertIndex);
				this._treeData.addChildAt(info,insertIndex,parent);
				flag=true;
				this.nodeChanged(info);
			}
			if (flag){
				this.changeXml(this._xml);
			}
		}

		__proto.sortOnIndex=function(a,b){
			var parent=a.parent;
			var aindex=parent.getChildIndex(a);
			var bindex=parent.getChildIndex(b);
			if (aindex > bindex){
				return 1;
				}else if (aindex < bindex){
				return-1;
				}else {
				return 0;
			}
		}

		/**改变层*/
		__proto.moveLayer=function(isUp){}
		/**
		*将页面大小自适应到实际对象大小
		*
		*/
		__proto.fitSizeToUI=function(){
			if(!UIPanel.instance.currViewer)return;
			if(UIPanel.instance.currViewer.design!=this)return;
			if(this.isAnimationMode){
				Alert.show(Sys.lang("动画编辑模式中，该功能不可用。"));
				return;
			};
			var view=new UIView();
			view.createViewCC(this.xml);
			Laya.timer.once(100,this,this.fitSizeToUILater,[view]);
		}

		__proto.fitSizeToUILater=function(view){
			var rec=view.getBounds();
			var width=Math.ceil(rec.x+rec.width);
			var height=Math.ceil(rec.y+rec.height);
			delete this.xml.props.width;
			delete this.xml.props.sceneWidth;
			this.xml.props.sceneWidth=width;
			this.xml.props.width=width;
			delete this.xml.props.height;
			delete this.xml.props.sceneHeight;
			this.xml.props.sceneHeight=height;
			this.xml.props.height=height;
			this.change()
		}

		__proto.designOnEnterDown=function(){
			if(this.isAnimationMode){
				Notice.notify("PLAYCONTROL_SwitchPlay",["PLAYCONTROL_Play"]);
				return;
			}
			if(this._selectedComps&&this._selectedComps.length>1){
				return;
			};
			var selected;
			selected=this.selectedCompXml?this.selectedCompXml:this._xml;
			if(!selected)return;
			var comp;
			comp=this.getCompByNodeData(selected);
			if((comp instanceof laya.display.AnimationPlayerBase )){
				if(comp.isPlaying){
					comp.stop();
					}else{
					comp.play(0,true);
				}
			}
		}

		/**处理快捷键*/
		__proto.onKeyDown=function(e){
			if(!UIPanel.instance.currViewer)return;
			if(UIPanel.instance.currViewer.design!=this)return;
			if(e.keyCode==13){
				this.designOnEnterDown();
				return;
			};
			var isCtrlKey=false;
			isCtrlKey=KeyManager.I.isCommandKeyDown||e.ctrlKey;
			if (isCtrlKey && e.shiftKey && e.keyCode==84){
				this.setAllCompSizeInfo();
				}else if (isCtrlKey && e.keyCode==38){
				this.sortComp(true);
				}else if (isCtrlKey && e.keyCode==40){
				this.sortComp(false);
				}else if (isCtrlKey && e.keyCode==76){
				}else if (isCtrlKey && e.keyCode==75){
				this.showSelecteRes();
				}else if (isCtrlKey && e.keyCode==37){
				this.moveLayer(false);
				}else if (isCtrlKey && e.keyCode==39){
				this.moveLayer(true);
				}else if (e.keyCode==38 && e.shiftKey){
				this.moveSelectedComps(0,-10);
				}else if (e.keyCode==40 && e.shiftKey){
				this.moveSelectedComps(0,10);
				}else if (e.keyCode==37 && e.shiftKey){
				this.moveSelectedComps(-10,0);
				}else if (e.keyCode==39 && e.shiftKey){
				this.moveSelectedComps(10,0);
				}else if (e.keyCode==38){
				this.moveSelectedComps(0,-1);
				}else if (e.keyCode==40){
				this.moveSelectedComps(0,1);
				}else if (e.keyCode==37){
				this.moveSelectedComps(-1,0);
				}else if (e.keyCode==39){
				this.moveSelectedComps(1,0);
				}else if (e.keyCode==13){
				var target=this.selectedComp;
				if (target !=null){
					if (Laya.__typeof(target,'laya.editor.core.IClip')){
						(target).autoPlay=!(target).autoPlay;
					}
				}
				}else if(e.shiftKey &&isCtrlKey && e.keyCode==82){
			}
		}

		__proto.setAllCompSizeInfo=function(){
			if(!this._xml)return;
			this._setCompSizeInfo(this._xml,false);
			this.changeXml(this._xml,true);
		}

		__proto._setCompSizeInfo=function(compO,me){
			(me===void 0)&& (me=true);
			if(!compO)return;
			var tCompID=0;
			tCompID=compO.compId;
			var tCompSp;
			tCompSp=this.getCompById(tCompID,false);
			if(me&&tCompSp&&compO.props){
				var tPropO;
				tPropO=compO.props;
				if(!("width" in tPropO)){
					tPropO["width"]=tCompSp.width;
				}
				if(!("height" in tPropO)){
					tPropO["height"]=tCompSp.height;
				}
			};
			var childs;
			childs=compO.child;
			if(!childs)return;
			var i=0,len=0;
			len=childs.length;
			for(i=0;i<len;i++){
				this._setCompSizeInfo(childs[i]);
			}
		}

		__proto.showSelecteRes=function(){
			var selecteO=this.selectedCompXml;
			if(selecteO){
				if(selecteO.props&&selecteO.props.skin){
					Notice.notify("SelecteResFile",[selecteO.props.skin]);
				}
			}
		}

		/**场景背景颜色*/
		__getset(0,__proto,'sceneColor',function(){
			return this._sceneColor;
			},function(value){
			if (this._sceneColor !=value){
				this._sceneColor=value;
				this.callLater(this.changeSceneSize);
			}
		});

		__getset(0,__proto,'isAnimationMode',function(){
			return this._isAnimationMode;
			},function(v){
			if(!v==this._isAnimationMode){
				if(v){
					this.goBackToStage();
					this.uiXmlRestored=ObjectTools$1.copyObj(this._xml);
					this.cacheXML(this._xml);
					this._isAnimationMode=v;
					DisplayTreePanel.instance.refresh();
					this.animation.isFirstSetUp=true;
					if(this.isGraphicAnimation){
						if(this.getLastCache()){
							this.uiXmlRestored=this.getLastCache();
						}
					}
					}else{
					this._isAnimationMode=v;
					PropPanel.instance.initByObj(null,null,-1);
					if(this.animation){
						this.animation.targetAnimation.displayToInitState();
					};
					var preChange=this.hasChange;
					this.uiXmlRestored=null;
					this.goBack();
					this.hasChange=preChange;
				}
			}
			Notice.notify("AnimationMode_Change");
		});

		__getset(0,__proto,'isGraphicAnimation',function(){
			return this.pageType=="graphic_animation";
		});

		__getset(0,__proto,'measureWidth',function(){
			var max=0;
			for (var i=this.numChildren-1;i >-1;i--){
				var comp=this.getChildAt(i);
				if (comp !=this._maskLayer){
					max=Math.max(comp.x+comp.width *comp.scaleX,max);
				}
			}
			return max;
		});

		/**获得当前选中的单一组件XML*/
		__getset(0,__proto,'selectedCompXml',function(){
			var selectComp=this.selectedComp;
			return selectComp !=null ? (selectComp).comXml :null;
		});

		__getset(0,__proto,'measureHeight',function(){
			var max=0;
			for (var i=this.numChildren-1;i >-1;i--){
				var comp=this.getChildAt(i);
				if (comp !=this._maskLayer){
					max=Math.max(comp.y+comp.height *comp.scaleY,max);
				}
			}
			return max;
		});

		/**场景高度*/
		__getset(0,__proto,'sceneHeight',function(){
			return this._sceneHeight;
			},function(value){
			if (this._sceneHeight !=value){
				this._sceneHeight=value;
				if((this._viewLayer instanceof laya.ui.View ))
					this._viewLayer.height=this._sceneHeight;
				this.callLater(this.changeSceneSize);
			}
		});

		__getset(0,__proto,'mouseX',function(){
			return DisControlTool.getMousePoint(this).x;
		});

		/**是否有变化*/
		__getset(0,__proto,'hasChange',function(){
			return this._hasChange;
			},function(value){
			if (this._hasChange !=value){
				this._hasChange=value;
				this.event("change");
			}
		});

		__getset(0,__proto,'mouseY',function(){
			return DisControlTool.getMousePoint(this).y;
		});

		/**场景宽度*/
		__getset(0,__proto,'sceneWidth',function(){
			return this._sceneWidth;
			},function(value){
			if (this._sceneWidth !=value){
				this._sceneWidth=value;
				if((this._viewLayer instanceof laya.ui.View ))
					this._viewLayer.width=this._sceneWidth;
				this.callLater(this.changeSceneSize);
			}
		});

		/**参考视图*/
		__getset(0,__proto,'sceneBg',function(){
			return this._sceneBg;
			},function(value){
			if (this._sceneBg !=value){
				this._sceneBg=value;
				this.refreshBg();
			}
		});

		/**视图代码*/
		__getset(0,__proto,'xml',function(){
			return this._xml;
			},function(value){
			this._xml=value;
			if(!this._xml)return;
			this.ensureIDNode(this._xml,true);
			this._treeData=TreeData.createByUIObj(this._xml);
			this.createView(this._xml);
			this.animation.treeData=this._treeData;
			this.callLater(this.freshDatasLater);
			Notice.notify("RULE_SHOW_CHANGE");
		});

		/**当前选择的容器*/
		__getset(0,__proto,'selectedBox',function(){
			return this._selectedBox;
			},function(value){
			if(!value)debugger;
			if(value.alpha<1)value.alpha=1;
			Design.adptIRender(value);
			if(!value.parent){
				if(!value["comXml"]||!value["comXml"].nodeParent)return;
				var vParent;
				vParent=this.getCompById(value["comXml"].nodeParent);
				if(!vParent)return;
				vParent.addChild(value);
			}
			if (!this.isItemSame(this._selectedBox,value)&&this._selectedBox !=value && FilterFuns.isEditorEnterAble(value)&& !((value instanceof laya.editor.core.UIView ))){
				if (this._selectedBox !=null && this._selectedBox !=this._viewLayer && (value.parent==this._selectedBox || (Laya.__typeof(this._selectedBox,'laya.editor.core.IContent')&& value.parent==(this._selectedBox).content))){
					var boxParent=this.getCompById((this._selectedBox).comXml.nodeParent);
					if(boxParent)
						boxParent.addChild(this._selectedBox);
				}
				value.mask=null;
				this._selectedBox=value;
				var point;
				var newPoint;
				if(this._selectedBox.parent){
					point=(this._selectedBox.parent).localToGlobal(new Point());
					newPoint=(this._maskAboveLayer.parent).globalToLocal(point);
				}
				this._maskAboveLayer.removeChildren();
				this.clearSelect();
				if (this._selectedBox !=this._viewLayer){
					this._maskLayer.visible=true;
					this._maskAboveLayer.visible=true;
					this._maskAboveLayer.x=newPoint.x;
					this._maskAboveLayer.y=newPoint.y;
					this._maskAboveLayer.width=(this._selectedBox.parent).width;
					this._maskAboveLayer.height=(this._selectedBox.parent).height;
					(this._selectedBox).comXml.nodeParent=this._treeData.getNodeParent((this._selectedBox).comXml).compId;
					this._maskAboveLayer.addChild(this._selectedBox);
					if (Laya.__typeof(this._selectedBox,'laya.ui.IRender')){
						this.createByBox((this._selectedBox),(this._selectedBox).comXml);
					}
					}else if (this._maskLayer.visible){
					this._maskLayer.visible=false;
					this._maskAboveLayer.visible=false;
				}
			}
			if(this._selectedBox){
				this._xml.selectedBox=this._selectedBox["comXml"].compId;
			}
			this.callLater(this.changeSelectedBox);
		});

		__getset(0,__proto,'canAddComp',function(){
			return this.isGraphicAnimation||!this.isAnimationMode;
		});

		/**获得当前选中的单一组件*/
		__getset(0,__proto,'selectedComp',function(){
			return this._selectedComps.length==1 ? this._selectedComps[0] :null;
		});

		/**获取当前点击被选中的组件*/
		__getset(0,__proto,'getCompSelectedAtCurrBox',function(){
			var compRect=new Rectangle();
			var mousePos;
			mousePos=this._selectedBox.getMousePoint();
			Design.smousePos.setTo(mousePos.x,mousePos.y);
			mousePos=Design.smousePos;
			for (var i=this._selectedBox.numChildren-1;i>=0;i--){
				var display=this._selectedBox.getChildAt(i);
				if ((display).comXml){
					compRect.setTo(display.x,display.y,display.width,display.height);
					compRect.copyFrom(display.getBounds());
					if (compRect.contains(mousePos.x,mousePos.y)){
						if(FilterFuns.isEditorSelectableChain(display)){
							return display;
						}
					}
				}
			}
			return null;
		});

		/**选择的所有组件*/
		__getset(0,__proto,'selectedComps',function(){
			return this._selectedComps;
		});

		/**获得被选中的内容*/
		__getset(0,__proto,'selectedXmls',function(){
			return this.getSelectedXmls(false);
		});

		Design.parseVarByObj=function(obj,varsO,alertIfNotOK){
			(alertIfNotOK===void 0)&& (alertIfNotOK=true);
			if(obj.props["var"]){
				var tVar;
				tVar=obj.props["var"];
				if(varsO[tVar]){
					if(alertIfNotOK)
						Alert.show(Sys.lang("存在重复的值为{0}的var属性",tVar));
					return false;
				}
				varsO[tVar]=true;
			};
			var list=obj.child;
			if(list)
				for (var j=0,n=list.length;j < n;j++){
				if(!Design.parseVarByObj(list[j],varsO)){
					return false;
				}
			}
			return true;
		}

		Design.clearAlignLines=function(){
			var rst;
			rst=Design._tempAlignLines;
			var i=0,len=0;
			len=rst.length;
			for(i=0;i<len;i++){
				Pool.recover("TempAlignLine",rst[i]);
			}
			rst.length=0;
		}

		Design.removeRenders=function(sprite){
			if(!sprite)return;
			if(sprite.getChildByName("render")){
				(sprite.getChildByName("render")).alpha=0.1;
			}
		}

		Design.adptIRender=function(value){
			if(!value)return;
			Design.clearIRender(value);
			if(value.mask){
				value.addChild(value.mask);
			}
			if(value&&value.name=="render"&&value.parent){
				Design.clearIRender(value.parent);
			}
		}

		Design.clearIRender=function(value){
			if (value !=null && Laya.__typeof(value,'laya.ui.IRender')){
				if (value.getChildByName("render")){
					for (var i=value.numChildren-1;i >-1;i--){
						var child=value.getChildAt(i);
						if (child.name.indexOf("item")!=-1){
							value.removeChild(child);
						}
					}
				}
				(value).itemRender=null;
			}
		}

		Design.beginCtrlAdd=function(){
			if(KeyManager.I.isCommandKeyDown){
				Design.isCtrlAdding=true;
				ShortcutManager.exeKey(67,true,false);
				Laya.stage.off("keyup",null,Design.onStageKeyUp);
				Laya.stage.on("keyup",null,Design.onStageKeyUp);
				if(!Design.clip){
					Design.clip=new Clip(SkinDefines.ResDragIcon,1,3);
					Design.clip.scale(0.5,0.5);
					Design.clip.index=2;
				}
				Laya._currentStage.addChild(Design.clip);
				Laya.stage.off("mousemove",null,this.onStageMouseMove);
				Laya.stage.on("mousemove",null,this.onStageMouseMove);
			}
		}

		Design.onStageMouseMove=function(){
			Design.clip.pos(Laya._currentStage.mouseX,Laya._currentStage.mouseY);
		}

		Design.onStageKeyUp=function(){
			Design.clip.removeSelf();
			Laya.stage.off("keyup",null,Design.onStageKeyUp);
			Laya.stage.off("mousemove",null,this.onStageMouseMove);
			Design.isCtrlAdding=false;
		}

		Design.MAX_HISTORY=500;
		Design.designID=1;
		Design._isClickOK=false;
		Design._tempAlignLines=[];
		Design.AlignLen=8;
		Design.isCtrlAdding=false;
		Design.clip=null
		Design.boxC=null
		__static(Design,
		['KeepKeys',function(){return this.KeepKeys={
				"x":true,
				"y":true,
				"alpha":true,
				"left":true,
				"right":true,
				"top":true,
				"bottom":true,
				"centerX":true,
				"centerY":true
				};},'_tempTransPoint',function(){return this._tempTransPoint=new Point();},'ConflictKeys',function(){return this.ConflictKeys={
				"anchorX":"pivotX",
				"anchorY":"pivotY",
				"pivotX":"anchorX",
				"pivotY":"anchorY",
				"left":"x",
				"top":"y",
				"x":"left",
				"y":"top"
			};},'conditionChangeDic',function(){return this.conditionChangeDic=
			[{
				keys:["left","width","right"],
				trans:{
					"left":"width",
					"width":"right",
					"right":"width"
				}
				},{
				keys:["top","height","bottom"],
				trans:{
					"top":"height",
					"height":"bottom",
					"bottom":"height"
				}
			}];},'conflictGroups',function(){return this.conflictGroups=
			[{
				"x":1,
				"centerX":2,
				"left":3,
				"right":3
				},{
				"y":1,
				"centerY":2,
				"top":3,
				"bottom":3
				},{
				"anchorX":1,
				"pivotX":2
				},{
				"anchorY":1,
				"pivotY":2
				}];},'_recPoints',function(){return this._recPoints=[new Point(),new Point()];},'_selectePropItem',function(){return this._selectePropItem={type:"MixItems",props:{}};},'_designCompsBouns',function(){return this._designCompsBouns=new Rectangle();},'smousePos',function(){return this.smousePos=new Point();},'simpleValueDic',function(){return this.simpleValueDic={
				"x":true,
				"y":true,
				"width":true,
				"height":true,
				"skin":true,
				"left":true,
				"right":true,
				"top":true,
				"disabled":true,
				"visible":true,
				"bottom":true
		};}

		]);
		return Design;
	})(UIView)


	/**
	*...
	*@author ww
	*/
	//class laya.editor.core.components.NumberInput extends laya.editor.core.components.EditorTextInput
	var NumberInput=(function(_super){
		function NumberInput(text){
			this._slideBtn=null;
			this._preX=NaN;
			this._preValue=NaN;
			this._isChanging=false;
			this._moveRate=0.2;
			(text===void 0)&& (text="");
			NumberInput.__super.call(this,text);
			this._slideBtn=new Image("comp/blank2.png");
			this._slideBtn.on("mousedown",this,this.slideMouseDown);
			this._slideBtn.top=1;
			this._slideBtn.bottom=1;
			this._slideBtn.width=10;
			this._slideBtn.right=1;
			this._slideBtn.toolTip=Sys.lang("鼠标按下上下拖动可修改值");
			this.addChild(this._slideBtn);
			this._tf.on("focus",this,this._$7_mOnFocus);
			this._tf.on("mousewheel",this,this.mOnMouseWheel);
			this._slideBtn.on("mouseover",this,this.onSlideMouseOver);
			this._slideBtn.on("mouseout",this,this.onSlideMouseOut);
			this.on("keydown",this,this.onKeyDown);
		}

		__class(NumberInput,'laya.editor.core.components.NumberInput',_super);
		var __proto=NumberInput.prototype;
		__proto.onKeyDown=function(e){
			var preV=NaN;
			preV=parseFloat(this.text);
			switch(e.keyCode){
				case 38:
					if (!this.text||this.text.length<1){
						this.event("Get_Value",this);
						return;
					}
					this.text=(preV+1)+"";
					this.event("enter",this);
					break ;
				case 40:
					if (!this.text||this.text.length<1){
						this.event("Get_Value",this);
						return;
					}
					this.text=(preV-1)+"";
					this.event("enter",this);
					break ;
				}
		}

		__proto.onSlideMouseOver=function(){
			NumberInput.lastIsOver=true;
			CursorManager.setType("n-resize");
		}

		__proto.onSlideMouseOut=function(){
			NumberInput.lastIsOver=false;
			if(NumberInput.hasOneChanging)return;
			CursorManager.setType("default");
		}

		__proto.mOnMouseWheel=function(e){
			console.log("mouseWheel:",e);
		}

		__proto._$7_mOnFocus=function(e){
			if (this._isChanging){
				this.stageMouseUp(null);
			}
		}

		__proto.slideMouseDown=function(e){
			if (!this.text||this.text.length<1){
				this.event("Get_Value",this);
				Laya.timer.once(100,this,this.beginMoveChange,[e&&e.shiftKey]);
				return;
			}
			this.beginMoveChange(e&&e.shiftKey);
		}

		__proto.beginMoveChange=function(shift){
			(shift===void 0)&& (shift=false);
			this._preValue=parseFloat(this.text);
			this._preX=Laya.stage.mouseY;
			this.clearSlideEvents();
			if(shift){
				this._moveRate=2;
				}else{
				this._moveRate=0.5;
			}
			Laya.timer.loop(100,this,this.updateValue);
			Laya.stage.on("mouseup",this,this.stageMouseUp);
			NumberInput.hasOneChanging=true;
			this._isChanging=true;
		}

		__proto.updateValue=function(){
			this.text=((Laya.stage.mouseY-this._preX)*this._moveRate+this._preValue).toFixed(0);
			this.event("changing",this);
		}

		__proto.stageMouseUp=function(e){
			this.clearSlideEvents();
			this.event("enter",[this,true]);
			this._isChanging=false;
			NumberInput.hasOneChanging=false;
			if(!NumberInput.lastIsOver)
				CursorManager.setType("default");
		}

		__proto.clearSlideEvents=function(){
			Laya.stage.off("mouseup",this,this.stageMouseUp);
			Laya.timer.clear(this,this.updateValue);
		}

		__proto.changeSize=function(){
			laya.ui.Component.prototype.changeSize.call(this);
		}

		__getset(0,__proto,'width',function(){
			return _super.prototype._$get_width.call(this)+12;
			},function(value){
			_super.prototype._$set_width.call(this,value-12);
		});

		NumberInput.Get_Value="Get_Value";
		NumberInput.hasOneChanging=false;
		NumberInput.lastIsOver=false;
		return NumberInput;
	})(EditorTextInput)


	//class laya.editor.ui.other.RepeatCompUI extends laya.ui.Dialog
	var RepeatCompUI=(function(_super){
		function RepeatCompUI(){
			this.rowTxt=null;
			this.columnTxt=null;
			this.paddingXTxt=null;
			this.paddingYTxt=null;
			RepeatCompUI.__super.call(this);
		}

		__class(RepeatCompUI,'laya.editor.ui.other.RepeatCompUI',_super);
		var __proto=RepeatCompUI.prototype;
		__proto.createChildren=function(){
			laya.ui.Component.prototype.createChildren.call(this);
			this.createView(RepeatCompUI.uiView);
		}

		__static(RepeatCompUI,
		['uiView',function(){return this.uiView={"child":[{"type":"Image","props":{"skin":"view/bg_dialog.png","y":"0","sizeGrid":"60,10,10,10","width":"450","height":"220","x":"0"}},{"type":"Button","props":{"skin":"view/btn_close.png","name":"close","scaleY":"0.5","scaleX":"0.5","top":"18","right":"18"}},{"type":"Image","props":{"skin":"comp/blank.png","y":"8","width":"399","height":"38","name":"drag","x":"9"}},{"type":"Label","props":{"y":"18","color":"#c5c5c5","fontSize":"14","text":"重复组件","x":"28"}},{"type":"Label","props":{"y":"78","text":"行个数：","width":"114","align":"right","height":"18","color":"#c5c5c5","x":"30"}},{"type":"TextInput","props":{"skin":"comp/input_24.png","y":"76","sizeGrid":"0,3,0,3","text":"5","width":"60","height":"24","var":"rowTxt","color":"#c5c5c5","x":"145"}},{"type":"Button","props":{"skin":"comp/button.png","y":"159","sizeGrid":"0,4,0,4","width":"100","labelColors":"#efefef,#ffffff,#c5c5c5,#c5c5c5","name":"sure","label":"确定","x":"175"}},{"type":"Label","props":{"y":"78","text":"列个数：","width":"85","align":"right","height":"18","color":"#c5c5c5","x":"209"}},{"type":"TextInput","props":{"skin":"comp/input_24.png","y":"76","sizeGrid":"0,3,0,3","text":"1","width":"60","height":"24","var":"columnTxt","color":"#c5c5c5","x":"295"}},{"type":"Label","props":{"y":"118","text":"右间距：","width":"125","align":"right","height":"18","color":"#c5c5c5","x":"19"}},{"type":"TextInput","props":{"skin":"comp/input_24.png","y":"114","sizeGrid":"0,3,0,3","text":"8","width":"60","height":"24","var":"paddingXTxt","color":"#c5c5c5","x":"145"}},{"type":"Label","props":{"y":"118","text":"下间距：","width":"85","align":"right","height":"18","color":"#c5c5c5","x":"209"}},{"type":"TextInput","props":{"skin":"comp/input_24.png","y":"114","sizeGrid":"0,3,0,3","text":"8","width":"60","height":"24","var":"paddingYTxt","color":"#c5c5c5","x":"295"}}],"type":"Dialog","props":{"height":"220","scenecolor":"#dddddd","width":"450"}};}
		]);
		return RepeatCompUI;
	})(Dialog)


	//class laya.editor.ui.other.SetIDENewUI extends laya.ui.Dialog
	var SetIDENewUI=(function(_super){
		function SetIDENewUI(){
			this.typeTab=null;
			this.views=null;
			SetIDENewUI.__super.call(this);
		}

		__class(SetIDENewUI,'laya.editor.ui.other.SetIDENewUI',_super);
		var __proto=SetIDENewUI.prototype;
		__proto.createChildren=function(){
			View.viewClassMap["laya.editor.view.other.ResTypeSettingView"]=ResTypeSettingView;
			View.viewClassMap["laya.editor.view.other.SetIDEView"]=SetIDEView;
			laya.ui.Component.prototype.createChildren.call(this);
			this.createView(SetIDENewUI.uiView);
		}

		__static(SetIDENewUI,
		['uiView',function(){return this.uiView={"child":[{"type":"Image","props":{"skin":"view/bg_dialog.png","y":"8","sizeGrid":"60,10,10,10","bottom":"0","left":"0","top":"0","right":"0","x":"12"}},{"type":"Button","props":{"skin":"view/btn_close.png","name":"close","y":"8","scaleX":"0.5","top":"18","scaleY":"0.5","right":"18","x":"12"}},{"type":"Image","props":{"skin":"comp/blank.png","y":"16","width":"517","height":"38","name":"drag","x":"21"}},{"type":"Label","props":{"y":"17","color":"#c5c5c5","fontSize":"14","text":"IDE设置","x":"25"}},{"type":"Tab","props":{"skin":"comp/tab.png","y":"78","labels":"常规,组件","labelColors":"#aaaaaa,#aaaaaa,#aaaaaa","var":"typeTab","direction":"vertical","x":"24"}},{"child":[{"type":"ResTypeSettingView","props":{"name":"item1","runtime":"laya.editor.view.other.ResTypeSettingView","y":"-27","x":"-3"}},{"type":"SetIDEView","props":{"name":"item0","y":"10","runtime":"laya.editor.view.other.SetIDEView","x":"28"}}],"type":"ViewStack","props":{"var":"views","y":"83","x":"117"}}],"type":"Dialog","props":{"height":"400","width":"600"}};}
		]);
		return SetIDENewUI;
	})(Dialog)


	//class laya.editor.ui.other.SetIDEUI extends laya.ui.Dialog
	var SetIDEUI=(function(_super){
		function SetIDEUI(){
			this.autoSwitch=null;
			this.showRule=null;
			this.frameSelect=null;
			SetIDEUI.__super.call(this);
		}

		__class(SetIDEUI,'laya.editor.ui.other.SetIDEUI',_super);
		var __proto=SetIDEUI.prototype;
		__proto.createChildren=function(){
			laya.ui.Component.prototype.createChildren.call(this);
			this.createView(SetIDEUI.uiView);
		}

		__static(SetIDEUI,
		['uiView',function(){return this.uiView={"child":[{"type":"Image","props":{"skin":"view/bg_dialog.png","y":"0","sizeGrid":"60,10,10,10","bottom":"0","left":"0","top":"0","right":"0","x":"0"}},{"type":"Button","props":{"skin":"view/btn_close.png","name":"close","scaleY":"0.5","scaleX":"0.5","top":"18","right":"18"}},{"type":"Image","props":{"skin":"comp/blank.png","y":"8","width":"249","height":"38","name":"drag","x":"9"}},{"type":"Label","props":{"y":"18","color":"#c5c5c5","fontSize":"14","text":"IDE设置","x":"28"}},{"type":"Button","props":{"skin":"comp/button.png","y":"157","sizeGrid":"0,4,0,4","label":"确定","x":"115","name":"sure","labelColors":"#efefef,#ffffff,#c5c5c5,#c5c5c5"}},{"type":"CheckBox","props":{"skin":"comp/checkbox.png","y":"72","selected":"true","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5,#c5c5c5","var":"autoSwitch","label":" 发布后自动切换到代码模式","x":"81"}},{"type":"CheckBox","props":{"skin":"comp/checkbox.png","y":"95","selected":"true","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5,#c5c5c5","var":"showRule","label":" 默认是否显示标尺","x":"80"}},{"child":[{"type":"ComboBox","props":{"skin":"comp/combo_22.png","var":"frameSelect","sizeGrid":"0,20,0,3","labels":"30,60","scrollBarSkin":"comp/vscroll.png","width":"97","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5,#c5c5c5","height":"22","selectedIndex":"0","x":"42"}},{"type":"Label","props":{"y":"3","color":"#c5c5c5","text":"帧率"}}],"type":"HBox","props":{"space":"2","y":"117","x":"81"}}],"type":"Dialog","props":{"height":"220","scenecolor":"#dddddd","width":"300"}};}
		]);
		return SetIDEUI;
	})(Dialog)


	//class laya.editor.ui.other.SetIDEViewUI extends laya.ui.Dialog
	var SetIDEViewUI=(function(_super){
		function SetIDEViewUI(){
			this.frameSelect=null;
			this.okBtn=null;
			this.autoSwitch=null;
			this.showRule=null;
			this.autoFocus=null;
			SetIDEViewUI.__super.call(this);
		}

		__class(SetIDEViewUI,'laya.editor.ui.other.SetIDEViewUI',_super);
		var __proto=SetIDEViewUI.prototype;
		__proto.createChildren=function(){
			laya.ui.Component.prototype.createChildren.call(this);
			this.createView(SetIDEViewUI.uiView);
		}

		__static(SetIDEViewUI,
		['uiView',function(){return this.uiView={"child":[{"child":[{"type":"ComboBox","props":{"skin":"comp/combo_22.png","var":"frameSelect","sizeGrid":"0,20,0,3","labels":"30,60","scrollBarSkin":"comp/vscroll.png","width":"97","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5,#c5c5c5","height":"22","selectedIndex":"0","x":"42"}},{"type":"Label","props":{"y":"3","color":"#c5c5c5","text":"帧率"}}],"type":"HBox","props":{"space":"2","y":"117","x":"81"}},{"type":"Button","props":{"skin":"comp/button.png","y":"157","sizeGrid":"0,4,0,4","label":"确定","x":"115","var":"okBtn","labelColors":"#efefef,#ffffff,#c5c5c5,#c5c5c5"}},{"type":"CheckBox","props":{"skin":"comp/checkbox.png","y":"72","selected":"true","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5,#c5c5c5","var":"autoSwitch","label":" 发布后自动切换到代码模式","x":"80"}},{"type":"CheckBox","props":{"skin":"comp/checkbox.png","y":"95","selected":"true","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5,#c5c5c5","var":"showRule","label":" 默认是否显示标尺","x":"80"}},{"type":"CheckBox","props":{"skin":"comp/checkbox.png","y":"51","selected":"true","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5,#c5c5c5","var":"autoFocus","label":"自动切换编辑区焦点","x":"80"}}],"type":"Dialog","props":{"height":"220","scenecolor":"#dddddd","width":"300"}};}
		]);
		return SetIDEViewUI;
	})(Dialog)


	//class laya.editor.ui.other.SetProjectUI extends laya.ui.Dialog
	var SetProjectUI=(function(_super){
		function SetProjectUI(){
			this.resTypes=null;
			this.resExportPath=null;
			this.resExportPathBtn=null;
			this.codeImports=null;
			this.codeExportPath=null;
			this.codeExportPathBtn=null;
			this.boxTypes=null;
			this.pageTypes=null;
			this.langPath=null;
			this.langPathBtn=null;
			this.codeType=null;
			this.defaultFont=null;
			this.resExportPathE=null;
			this.resExportPathEBtn=null;
			this.picType=null;
			this.atlasType=null;
			this.textureWidth=null;
			this.textureHeight=null;
			this.picWidth=null;
			this.picHeight=null;
			this.power2=null;
			this.trimempty=null;
			this.copyRes=null;
			this.dataCompact=null;
			this.uiType=null;
			this.uiExportPath=null;
			this.shareResPath=null;
			this.shareResPathBtn=null;
			SetProjectUI.__super.call(this);
		}

		__class(SetProjectUI,'laya.editor.ui.other.SetProjectUI',_super);
		var __proto=SetProjectUI.prototype;
		__proto.createChildren=function(){
			laya.ui.Component.prototype.createChildren.call(this);
			this.createView(SetProjectUI.uiView);
		}

		__static(SetProjectUI,
		['uiView',function(){return this.uiView={"child":[{"type":"Image","props":{"skin":"view/bg_dialog.png","height":"671","sizeGrid":"60,10,10,10","width":"600"}},{"type":"Button","props":{"skin":"view/btn_close.png","name":"close","scaleY":"0.5","scaleX":"0.5","top":"18","right":"18"}},{"type":"Image","props":{"skin":"comp/blank.png","y":"8","width":"547","height":"38","name":"drag","x":"9"}},{"type":"Label","props":{"y":"18","color":"#c5c5c5","fontSize":"14","text":"项目设置","x":"28"}},{"type":"Label","props":{"y":"66.5","text":"位图资源类型：","width":"140","align":"right","height":"20","color":"#c5c5c5","x":"13"}},{"type":"TextInput","props":{"skin":"comp/input_24.png","y":"62","sizeGrid":"0,3,0,3","width":"200","height":"24","var":"resTypes","color":"#c5c5c5","x":"150"}},{"type":"Button","props":{"skin":"comp/button.png","y":"616","sizeGrid":"0,4,0,4","label":"确定","x":"250","name":"sure","labelColors":"#efefef,#ffffff,#c5c5c5,#c5c5c5"}},{"type":"Label","props":{"y":"100","text":"资源发布目录：","width":"142","align":"right","height":"20","color":"#c5c5c5","x":"11"}},{"type":"TextInput","props":{"skin":"comp/input_24.png","y":"95","sizeGrid":"0,3,0,3","width":"200","height":"24","var":"resExportPath","color":"#c5c5c5","x":"150"}},{"type":"Button","props":{"skin":"comp/btn_browser.png","y":"95","text":"项目名称：","width":"50","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5","height":"24","var":"resExportPathBtn","label":"浏览","x":"351"}},{"type":"Image","props":{"skin":"comp/line.png","y":"285","width":"496","x":"40"}},{"type":"Label","props":{"y":"296","text":"UICode导入类：","width":"141","align":"right","height":"20","color":"#c5c5c5","x":"12"}},{"type":"TextArea","props":{"skin":"comp/input_32.png","y":"296","sizeGrid":"0,3,0,3","padding":"5,5,5,5","width":"300","height":"60","var":"codeImports","color":"#c5c5c5","scrollBarSkin":"comp/vscroll.png","multiline":"true","x":"150"}},{"type":"Label","props":{"align":"left","y":"315","color":"#999999","text":"回车换行","x":"459"}},{"type":"Label","props":{"y":"369","text":"UICode发布目录：","width":"142","align":"right","height":"20","color":"#c5c5c5","x":"11"}},{"type":"TextInput","props":{"skin":"comp/input_24.png","y":"365","sizeGrid":"0,3,0,3","width":"200","height":"24","var":"codeExportPath","color":"#c5c5c5","x":"150"}},{"type":"Button","props":{"skin":"comp/btn_browser.png","y":"365","text":"项目名称：","width":"50","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5","height":"24","var":"codeExportPathBtn","label":"浏览","x":"351"}},{"type":"Image","props":{"skin":"comp/line.png","y":"486","width":"496","x":"40"}},{"type":"Label","props":{"y":"498","text":"容器列表：","width":"120","align":"right","height":"20","color":"#c5c5c5","x":"33"}},{"type":"TextInput","props":{"skin":"comp/input_24.png","y":"494","sizeGrid":"0,3,0,3","width":"200","height":"24","var":"boxTypes","color":"#c5c5c5","x":"150"}},{"type":"Label","props":{"y":"530","text":"页面类型：","width":"120","align":"right","height":"20","color":"#c5c5c5","x":"33"}},{"type":"TextInput","props":{"skin":"comp/input_24.png","y":"526","sizeGrid":"0,3,0,3","width":"200","height":"24","var":"pageTypes","color":"#c5c5c5","x":"150"}},{"type":"Label","props":{"align":"left","y":"499","color":"#999999","text":"转换为容器功能使用","x":"355"}},{"type":"Label","props":{"align":"left","y":"531","color":"#999999","text":"用于自定义页面继承","x":"355"}},{"type":"Label","props":{"y":"564","text":"UI语言包路径：","width":"143","align":"right","height":"20","color":"#c5c5c5","x":"10"}},{"type":"TextInput","props":{"skin":"comp/input_24.png","y":"561","sizeGrid":"0,3,0,3","width":"200","height":"24","var":"langPath","color":"#c5c5c5","x":"150"}},{"type":"Button","props":{"skin":"comp/btn_browser.png","y":"561","text":"项目名称：","width":"50","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5","height":"24","var":"langPathBtn","label":"浏览","x":"351"}},{"type":"Label","props":{"y":"560","wordWrap":"true","text":"设置后，会按照语言包内的配置替换UI界面语言","width":"169","align":"left","height":"45","color":"#999999","x":"409"}},{"type":"Label","props":{"y":"99","wordWrap":"true","text":"需和项目在同一个盘符","width":"131","align":"left","height":"30","color":"#999999","x":"405"}},{"type":"Label","props":{"y":"370","wordWrap":"true","text":"需和项目在同一个盘符","width":"175","align":"left","height":"37","color":"#999999","x":"409"}},{"type":"Label","props":{"y":"399","text":"语言：","width":"120","align":"right","height":"20","color":"#c5c5c5","x":"33"}},{"type":"ComboBox","props":{"skin":"comp/combo_24.png","y":"395","sizeGrid":"0,20,0,3","labels":"ActionScript3,TypeScript,JavaScript","width":"200","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5,#c5c5c5","height":"24","var":"codeType","x":"150"}},{"type":"Label","props":{"y":"257","text":"默认字体：","width":"142","align":"right","height":"20","color":"#c5c5c5","x":"11"}},{"type":"TextInput","props":{"skin":"comp/input_24.png","y":"254","sizeGrid":"0,3,0,3","width":"200","height":"24","var":"defaultFont","color":"#c5c5c5","x":"150"}},{"type":"Label","props":{"y":"131","text":"发布html目录：","width":"142","align":"right","height":"20","color":"#c5c5c5","x":"11"}},{"type":"TextInput","props":{"skin":"comp/input_24.png","y":"127","sizeGrid":"0,3,0,3","width":"200","height":"24","var":"resExportPathE","color":"#c5c5c5","x":"149"}},{"type":"Button","props":{"skin":"comp/btn_browser.png","y":"127","text":"项目名称：","width":"50","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5","height":"24","var":"resExportPathEBtn","label":"浏览","x":"350"}},{"type":"Label","props":{"y":"130","wordWrap":"true","text":"未打包图片输出目录","width":"128","align":"left","height":"31","color":"#999999","x":"405"}},{"type":"ComboBox","props":{"skin":"comp/combo_24.png","y":"223","sizeGrid":"0,20,0,3","labels":"png32,png8","width":"80","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5,#c5c5c5","height":"24","var":"picType","selectedIndex":"0","x":"319"}},{"type":"Label","props":{"y":"226","text":"图片格式：","width":"78","align":"right","height":"20","color":"#c5c5c5","x":"243"}},{"type":"ComboBox","props":{"skin":"comp/combo_24.png","y":"223","sizeGrid":"0,20,0,3","labels":"json,atlas","width":"80","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5,#c5c5c5","height":"24","var":"atlasType","selectedIndex":"0","x":"150"}},{"type":"Label","props":{"y":"227","text":"图集后缀：","width":"78","align":"right","height":"20","color":"#c5c5c5","x":"75"}},{"type":"Label","props":{"y":"165","text":"图集最大宽：","width":"143","align":"right","height":"20","color":"#c5c5c5","x":"10"}},{"type":"TextInput","props":{"skin":"comp/input_24.png","y":"159","sizeGrid":"0,3,0,3","width":"80","height":"24","var":"textureWidth","color":"#c5c5c5","x":"150"}},{"type":"Label","props":{"y":"163","text":"图集最大高：","width":"100","align":"right","height":"20","color":"#c5c5c5","x":"221"}},{"type":"TextInput","props":{"skin":"comp/input_24.png","y":"159","sizeGrid":"0,3,0,3","width":"80","height":"24","var":"textureHeight","color":"#c5c5c5","x":"319"}},{"type":"Label","props":{"y":"196","text":"单图最大宽：","width":"145","align":"right","height":"20","color":"#c5c5c5","x":"8"}},{"type":"TextInput","props":{"skin":"comp/input_24.png","y":"191","sizeGrid":"0,3,0,3","width":"80","height":"24","var":"picWidth","color":"#c5c5c5","x":"150"}},{"type":"Label","props":{"y":"194","text":"单图最大高：","width":"79","align":"right","height":"20","color":"#c5c5c5","x":"242"}},{"type":"TextInput","props":{"skin":"comp/input_24.png","y":"191","sizeGrid":"0,3,0,3","width":"80","height":"24","var":"picHeight","color":"#c5c5c5","x":"319"}},{"type":"CheckBox","props":{"skin":"comp/checkbox.png","y":"165","selected":"true","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5,#c5c5c5","var":"power2","label":"是否限定2的幂次方","x":"405"}},{"type":"CheckBox","props":{"skin":"comp/checkbox.png","y":"194","selected":"false","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5,#c5c5c5","var":"trimempty","label":"是否裁剪空白区域","x":"405"}},{"type":"CheckBox","props":{"skin":"comp/checkbox.png","y":"226","selected":"false","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5,#c5c5c5","var":"copyRes","label":"复制未被打包的资源","x":"405"}},{"type":"CheckBox","props":{"skin":"comp/checkbox.png","y":"254","selected":"false","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5,#c5c5c5","var":"dataCompact","label":"压缩图集数据","x":"405"}},{"type":"Label","props":{"y":"429","text":"UI模式：","width":"120","align":"right","height":"20","color":"#c5c5c5","x":"33"}},{"type":"ComboBox","props":{"skin":"comp/combo_24.png","var":"uiType","sizeGrid":"0,20,0,3","labels":"内嵌模式,加载模式,分离模式","width":"200","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5,#c5c5c5","height":"24","y":"426","x":"151"}},{"type":"Label","props":{"y":"460","text":"加载UI发布目录：","width":"143","align":"right","height":"20","color":"#c5c5c5","x":"10"}},{"type":"TextInput","props":{"skin":"comp/input_24.png","y":"457","sizeGrid":"0,3,0,3","width":"200","height":"24","var":"uiExportPath","color":"#c5c5c5","x":"151"}},{"type":"Label","props":{"align":"left","y":"461","color":"#999999","text":"加载模式可用","x":"355"}},{"child":[{"type":"Label","props":{"y":"2","text":"共用资源目录：","width":"120","align":"right","height":"20","color":"#c5c5c5"}},{"type":"TextInput","props":{"skin":"comp/input_24.png","var":"shareResPath","sizeGrid":"0,3,0,3","width":"200","height":"24","color":"#c5c5c5","x":"118"}},{"type":"Button","props":{"skin":"comp/btn_browser.png","var":"shareResPathBtn","text":"项目名称：","width":"50","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5","height":"24","label":"浏览","x":"319"}},{"type":"Label","props":{"align":"left","y":"2","color":"#999999","text":"多项目共用的资源目录","x":"377"}}],"type":"Box","props":{"visible":"false","y":"71","x":"49"}}],"type":"Dialog","props":{"height":"670","scenecolor":"#dddddd","width":"600"}};}
		]);
		return SetProjectUI;
	})(Dialog)


	//class laya.editor.ui.page.AddAnimationUI extends laya.ui.Dialog
	var AddAnimationUI=(function(_super){
		function AddAnimationUI(){
			this.title=null;
			this.typeDrop=null;
			this.nameTxt=null;
			this.imgTxt=null;
			this.widthTxt=null;
			this.heightTxt=null;
			this.bgColorPicker=null;
			this.sureBtn=null;
			this.selectBtn=null;
			this.widthCheck=null;
			this.heightCheck=null;
			AddAnimationUI.__super.call(this);
		}

		__class(AddAnimationUI,'laya.editor.ui.page.AddAnimationUI',_super);
		var __proto=AddAnimationUI.prototype;
		__proto.createChildren=function(){
			laya.ui.Component.prototype.createChildren.call(this);
			this.createView(AddAnimationUI.uiView);
		}

		__static(AddAnimationUI,
		['uiView',function(){return this.uiView={"child":[{"type":"Image","props":{"skin":"view/bg_dialog.png","y":"0","sizeGrid":"60,10,10,10","width":"450","height":"330","x":"0"}},{"type":"Image","props":{"skin":"comp/blank.png","y":"8","width":"400","height":"38","name":"drag","x":"9"}},{"type":"Button","props":{"skin":"view/btn_close.png","name":"close","scaleY":"0.5","scaleX":"0.5","top":"18","right":"18"}},{"type":"Label","props":{"y":"15","var":"title","color":"#c5c5c5","text":"新增动画","x":"16"}},{"type":"Label","props":{"y":"57","color":"#c5c5c5","text":"页面类型：","x":"78"}},{"type":"Label","props":{"y":"90","color":"#c5c5c5","text":"页面名称：","x":"78"}},{"type":"Label","props":{"y":"123","color":"#c5c5c5","text":"参考视图：","x":"78"}},{"type":"Label","props":{"y":"156","color":"#c5c5c5","text":"页面宽度：","x":"78"}},{"type":"Label","props":{"y":"189","color":"#c5c5c5","text":"页面高度：","x":"78"}},{"type":"Label","props":{"y":"222","color":"#c5c5c5","text":"参考背景：","x":"78"}},{"type":"ComboBox","props":{"skin":"comp/combo_24.png","y":"55","sizeGrid":"0,20,0,3","labels":"View,Dialog","scrollBarSkin":"comp/vscroll.png","width":"140","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5,#c5c5c5","height":"24","var":"typeDrop","selectedIndex":"0","x":"151"}},{"type":"TextInput","props":{"skin":"comp/input_24.png","y":"89","sizeGrid":"0,3,0,3","width":"140","height":"24","var":"nameTxt","color":"#c5c5c5","x":"151"}},{"type":"TextInput","props":{"skin":"comp/input_24.png","y":"122","sizeGrid":"0,3,0,3","width":"100","height":"24","var":"imgTxt","color":"#c5c5c5","x":"151"}},{"type":"TextInput","props":{"skin":"comp/input_24.png","y":"155","sizeGrid":"0,3,0,3","text":"600","width":"140","height":"24","var":"widthTxt","color":"#c5c5c5","x":"151"}},{"type":"TextInput","props":{"skin":"comp/input_24.png","y":"188","sizeGrid":"0,3,0,3","text":"400","width":"140","height":"24","var":"heightTxt","color":"#c5c5c5","x":"151"}},{"type":"ColorPicker","props":{"skin":"comp/color.png","y":"221","selectedcolor":"#dddddd","scaleX":"0.5","var":"bgColorPicker","scaleY":"0.5","x":"151"}},{"type":"Button","props":{"skin":"comp/button.png","y":"272","var":"sureBtn","label":"新增","labelColors":"#efefef,#ffffff,#c5c5c5,#c5c5c5","name":"sure","sizeGrid":"0,4,0,4","width":"100","x":"175"}},{"type":"Label","props":{"y":"123","color":"#c5c5c5","text":"(可选，参考背景)","x":"306"}},{"type":"Label","props":{"y":"221","wordWrap":"true","text":"(可选，设计面板的背景颜色)","width":"207","height":"36","color":"#c5c5c5","x":"173"}},{"type":"Button","props":{"skin":"comp/btn.png","y":"122","sizeGrid":"0,4,0,4","width":"40","labelColors":"#efefef,#ffffff,#c5c5c5,#c5c5c5","height":"22","var":"selectBtn","label":"选择","x":"251"}},{"type":"CheckBox","props":{"skin":"comp/checkbox.png","y":"159","label":"仅作为参考宽度","x":"298","var":"widthCheck","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5,#c5c5c5"}},{"type":"CheckBox","props":{"skin":"comp/checkbox.png","y":"192","label":"仅作为参考高度","x":"298","var":"heightCheck","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5,#c5c5c5"}}],"type":"Dialog","props":{"height":"330","scenecolor":"#dddddd","width":"450"}};}
		]);
		return AddAnimationUI;
	})(Dialog)


	//class laya.editor.ui.page.AddDirectoryUI extends laya.ui.Dialog
	var AddDirectoryUI=(function(_super){
		function AddDirectoryUI(){
			this.nameTxt=null;
			AddDirectoryUI.__super.call(this);
		}

		__class(AddDirectoryUI,'laya.editor.ui.page.AddDirectoryUI',_super);
		var __proto=AddDirectoryUI.prototype;
		__proto.createChildren=function(){
			laya.ui.Component.prototype.createChildren.call(this);
			this.createView(AddDirectoryUI.uiView);
		}

		__static(AddDirectoryUI,
		['uiView',function(){return this.uiView={"child":[{"type":"Image","props":{"skin":"view/bg_dialog.png","y":"0","sizeGrid":"60,10,10,10","width":"470","height":"220","x":"0"}},{"type":"Button","props":{"skin":"view/btn_close.png","name":"close","scaleY":"0.5","scaleX":"0.5","top":"18","right":"18"}},{"type":"Image","props":{"skin":"comp/blank.png","y":"8","width":"412","height":"38","name":"drag","x":"9"}},{"type":"Label","props":{"y":"18","color":"#c5c5c5","text":"新增目录","x":"28"}},{"type":"Label","props":{"y":"96","text":"目录名称：","width":"92","align":"right","height":"18","color":"#c5c5c5","x":"12"}},{"type":"TextInput","props":{"skin":"comp/input_32.png","y":"89","sizeGrid":"0,3,0,3","width":"322","height":"32","var":"nameTxt","color":"#dddddd","x":"101"}},{"type":"Button","props":{"skin":"comp/button.png","y":"145","sizeGrid":"0,4,0,4","label":"新增","x":"192","name":"sure","labelColors":"#efefef,#ffffff,#c5c5c5,#c5c5c5"}}],"type":"Dialog","props":{"height":"220","scenecolor":"#dddddd","width":"470"}};}
		]);
		return AddDirectoryUI;
	})(Dialog)


	//class laya.editor.ui.page.AddDocumentUI extends laya.ui.Dialog
	var AddDocumentUI=(function(_super){
		function AddDocumentUI(){
			this.tab=null;
			this.title=null;
			this.views=null;
			this.sureBtn=null;
			this.tipImg=null;
			this.tipIcon=null;
			AddDocumentUI.__super.call(this);
		}

		__class(AddDocumentUI,'laya.editor.ui.page.AddDocumentUI',_super);
		var __proto=AddDocumentUI.prototype;
		__proto.createChildren=function(){
			View.viewClassMap["laya.editor.view.page.AddAnimation"]=AddAnimation;
			View.viewClassMap["laya.editor.view.page.AddPage"]=AddPage;
			View.viewClassMap["laya.editor.view.page.AddParticle"]=AddParticle;
			View.viewClassMap["laya.editor.view.page.AddScript"]=AddScript;
			laya.ui.Component.prototype.createChildren.call(this);
			this.createView(AddDocumentUI.uiView);
		}

		__static(AddDocumentUI,
		['uiView',function(){return this.uiView={"child":[{"type":"Image","props":{"skin":"view/bg_dialog.png","y":"0","sizeGrid":"60,10,10,10","width":"610","height":"430","x":"0"}},{"type":"Image","props":{"skin":"view/bg_dialog2.png","y":"89","sizeGrid":"3,3,3,3","width":"578","height":"325","x":"15"}},{"child":[{"type":"Button","props":{"skin":"comp/tab3.png","name":"item0","label":"页面","height":"30","width":"75","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5,#c5c5c5"}},{"type":"Button","props":{"skin":"comp/tab3.png","name":"item1","width":"75","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5,#c5c5c5","height":"30","y":"0","label":"粒子","x":"75"}},{"type":"Button","props":{"skin":"comp/tab3.png","name":"item2","width":"75","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5,#c5c5c5","height":"30","y":"0","label":"动画","x":"150"}},{"type":"Button","props":{"skin":"comp/tab3.png","name":"item3","width":"75","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5,#c5c5c5","height":"30","y":"0","label":"脚本","x":"225"}}],"type":"Tab","props":{"var":"tab","y":"59","selectedIndex":"0","x":"15"}},{"type":"Button","props":{"skin":"view/btn_close.png","name":"close","scaleY":"0.5","scaleX":"0.5","top":"18","right":"18"}},{"type":"Image","props":{"skin":"comp/blank.png","y":"8","width":"558","height":"38","name":"drag","x":"9"}},{"type":"Label","props":{"y":"18","text":"新建","var":"title","color":"#c5c5c5","fontSize":"14","x":"28"}},{"child":[{"type":"AddPage","props":{"name":"item0","runtime":"laya.editor.view.page.AddPage"}},{"type":"AddParticle","props":{"name":"item1","runtime":"laya.editor.view.page.AddParticle"}},{"type":"AddGraphicAni","props":{"name":"item2","runtime":"laya.editor.view.page.AddAnimation"}},{"type":"AddScript","props":{"name":"item3","runtime":"laya.editor.view.page.AddScript"}}],"type":"ViewStack","props":{"mouseEnabled":"true","var":"views","y":"96","x":"29"}},{"type":"Button","props":{"skin":"comp/button.png","y":"362","var":"sureBtn","label":"确定","labelColors":"#efefef,#ffffff,#c5c5c5,#c5c5c5","height":"30","name":"sure","sizeGrid":"0,4,0,4","width":"100","x":"458"}},{"type":"Image","props":{"skin":"view/question.png","y":"108","var":"tipImg","visible":"false","x":"563"}},{"type":"Image","props":{"skin":"comp/iconhelp.png","y":"65","visible":"false","width":"14","height":"14","var":"tipIcon","x":"566"}}],"type":"Dialog","props":{"height":"430","scenecolor":"#dddddd","width":"610"}};}
		]);
		return AddDocumentUI;
	})(Dialog)


	//class laya.editor.ui.page.AddSceneUI extends laya.ui.Dialog
	var AddSceneUI=(function(_super){
		function AddSceneUI(){
			this.nameTxt=null;
			this.imgTxt=null;
			this.widthTxt=null;
			this.heightTxt=null;
			this.bgColorPicker=null;
			this.selectBtn=null;
			this.widthCheck=null;
			this.heightCheck=null;
			AddSceneUI.__super.call(this);
		}

		__class(AddSceneUI,'laya.editor.ui.page.AddSceneUI',_super);
		var __proto=AddSceneUI.prototype;
		__proto.createChildren=function(){
			laya.ui.Component.prototype.createChildren.call(this);
			this.createView(AddSceneUI.uiView);
		}

		__static(AddSceneUI,
		['uiView',function(){return this.uiView={"child":[{"type":"Label","props":{"y":"12","color":"#dddddd","text":"场景名称：","x":"10"}},{"type":"Label","props":{"y":"45","color":"#dddddd","text":"参考视图：","x":"10"}},{"type":"Label","props":{"y":"78","color":"#dddddd","text":"场景宽度：","x":"10"}},{"type":"Label","props":{"y":"111","color":"#dddddd","text":"场景高度：","x":"10"}},{"type":"Label","props":{"y":"144","color":"#dddddd","text":"参考背景：","x":"10"}},{"type":"TextInput","props":{"skin":"comp/input_24.png","var":"nameTxt","sizeGrid":"0,3,0,3","width":"160","height":"24","y":"10","color":"#dddddd","x":"83"}},{"type":"TextInput","props":{"skin":"comp/input_24.png","y":"43","sizeGrid":"0,3,0,3","width":"120","height":"24","var":"imgTxt","color":"#dddddd","x":"83"}},{"type":"TextInput","props":{"skin":"comp/input_24.png","y":"76","sizeGrid":"0,3,0,3","text":"600","width":"160","height":"24","var":"widthTxt","color":"#dddddd","x":"83"}},{"type":"TextInput","props":{"skin":"comp/input_24.png","y":"109","sizeGrid":"0,3,0,3","text":"400","width":"160","height":"24","var":"heightTxt","color":"#dddddd","x":"83"}},{"type":"ColorPicker","props":{"skin":"comp/color.png","y":"142","selectedcolor":"#dddddd","scaleX":"0.5","var":"bgColorPicker","scaleY":"0.5","x":"83"}},{"type":"Label","props":{"y":"44","color":"#dddddd","text":"(可选，参考背景)","x":"248"}},{"type":"Label","props":{"y":"142","color":"#dddddd","text":"(可选，设计面板的背景颜色)","x":"104"}},{"type":"Button","props":{"skin":"comp/btn.png","y":"43","sizeGrid":"0,4,0,4","width":"40","x":"202","height":"22","var":"selectBtn","label":"选择","labelColors":"#dddddd,#dddddd,#dddddd"}},{"type":"CheckBox","props":{"skin":"comp/checkbox.png","y":"80","label":"仅作为参考宽度","x":"248","var":"widthCheck","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5,#c5c5c5"}},{"type":"CheckBox","props":{"skin":"comp/checkbox.png","y":"113","label":"仅作为参考高度","x":"248","var":"heightCheck","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5,#c5c5c5"}}],"type":"Dialog","props":{"scenecolor":"#dddddd"}};}
		]);
		return AddSceneUI;
	})(Dialog)


	//class laya.editor.ui.page.MovePageUI extends laya.ui.Dialog
	var MovePageUI=(function(_super){
		function MovePageUI(){
			this.msgLbl=null;
			this.updateCheck=null;
			MovePageUI.__super.call(this);
		}

		__class(MovePageUI,'laya.editor.ui.page.MovePageUI',_super);
		var __proto=MovePageUI.prototype;
		__proto.createChildren=function(){
			laya.ui.Component.prototype.createChildren.call(this);
			this.createView(MovePageUI.uiView);
		}

		__static(MovePageUI,
		['uiView',function(){return this.uiView={"child":[{"type":"Image","props":{"skin":"view/bg_dialog.png","y":"0","sizeGrid":"60,10,10,10","width":"440","height":"200","x":"0"}},{"type":"Button","props":{"skin":"view/btn_close.png","name":"close","scaleY":"0.5","scaleX":"0.5","top":"18","right":"18"}},{"type":"Image","props":{"skin":"comp/blank.png","y":"8","width":"388","height":"38","name":"drag","x":"9"}},{"type":"Label","props":{"y":"18","color":"#c5c5c5","fontSize":"14","text":"移动页面","x":"28"}},{"type":"Label","props":{"y":"55","wordWrap":"true","text":"确定移动页面吗？","width":"332","align":"center","height":"43","var":"msgLbl","color":"#c5c5c5","multiline":"true","x":"54"}},{"type":"CheckBox","props":{"skin":"comp/checkbox.png","y":"107","selected":"true","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5,#c5c5c5","var":"updateCheck","label":"是否更新页面嵌套引用(不选择能提高性能)","x":"99"}},{"type":"Button","props":{"skin":"comp/button.png","name":"sure","sizeGrid":"0,4,0,4","label":"确定","x":"100","y":"139","labelColors":"#efefef,#ffffff,#c5c5c5,#c5c5c5"}},{"type":"Button","props":{"skin":"comp/btn.png","name":"cancel","sizeGrid":"0,4,0,4","label":"取消","x":"240","y":"139","labelColors":"#efefef,#ffffff,#c5c5c5,#c5c5c5"}}],"type":"Dialog","props":{"height":"200","scenecolor":"#dddddd","width":"440"}};}
		]);
		return MovePageUI;
	})(Dialog)


	//class laya.editor.ui.page.NeedSaveUI extends laya.ui.Dialog
	var NeedSaveUI=(function(_super){
		function NeedSaveUI(){
			this.msgLbl=null;
			NeedSaveUI.__super.call(this);
		}

		__class(NeedSaveUI,'laya.editor.ui.page.NeedSaveUI',_super);
		var __proto=NeedSaveUI.prototype;
		__proto.createChildren=function(){
			laya.ui.Component.prototype.createChildren.call(this);
			this.createView(NeedSaveUI.uiView);
		}

		__static(NeedSaveUI,
		['uiView',function(){return this.uiView={"child":[{"type":"Image","props":{"skin":"view/bg_dialog.png","y":"0","sizeGrid":"60,10,10,10","width":"470","height":"200","x":"0"}},{"type":"Button","props":{"skin":"view/btn_close.png","name":"close","scaleY":"0.5","scaleX":"0.5","top":"18","right":"18"}},{"type":"Image","props":{"skin":"comp/blank.png","y":"8","width":"418","height":"38","name":"drag","x":"9"}},{"type":"Label","props":{"y":"18","color":"#c5c5c5","fontSize":"14","text":"提醒","x":"28"}},{"type":"Label","props":{"y":"73","wordWrap":"true","text":"是否保存修改？","width":"383","align":"center","height":"21","var":"msgLbl","color":"#c5c5c5","multiline":"true","x":"43.5"}},{"child":[{"type":"Button","props":{"skin":"comp/button.png","name":"sure","sizeGrid":"0,4,0,4","label":"保存","labelColors":"#efefef,#ffffff,#c5c5c5,#c5c5c5"}},{"type":"Button","props":{"skin":"comp/btn.png","name":"cancel","sizeGrid":"0,4,0,4","label":"不保存","x":"130","labelColors":"#efefef,#ffffff,#c5c5c5,#c5c5c5"}},{"type":"Button","props":{"skin":"comp/btn.png","name":"close","sizeGrid":"0,4,0,4","label":"取消关闭","x":"260","labelColors":"#efefef,#ffffff,#c5c5c5,#c5c5c5"}}],"type":"Box","props":{"y":"123","x":"62"}}],"type":"Dialog","props":{"height":"200","scenecolor":"#dddddd","width":"470"}};}
		]);
		return NeedSaveUI;
	})(Dialog)


	//class laya.editor.ui.page.RenamePageUI extends laya.ui.Dialog
	var RenamePageUI=(function(_super){
		function RenamePageUI(){
			this.nameTxt=null;
			this.updateCheck=null;
			this.resLbl=null;
			RenamePageUI.__super.call(this);
		}

		__class(RenamePageUI,'laya.editor.ui.page.RenamePageUI',_super);
		var __proto=RenamePageUI.prototype;
		__proto.createChildren=function(){
			laya.ui.Component.prototype.createChildren.call(this);
			this.createView(RenamePageUI.uiView);
		}

		__static(RenamePageUI,
		['uiView',function(){return this.uiView={"child":[{"type":"Image","props":{"skin":"view/bg_dialog.png","y":"0","sizeGrid":"60,10,10,10","width":"450","height":"220","x":"0"}},{"type":"Button","props":{"skin":"view/btn_close.png","name":"close","scaleY":"0.5","scaleX":"0.5","top":"18","right":"18"}},{"type":"Image","props":{"skin":"comp/blank.png","y":"8","width":"400","height":"38","name":"drag","x":"9"}},{"type":"Label","props":{"y":"18","color":"#c5c5c5","fontSize":"14","text":"重命名页面","x":"28"}},{"type":"Label","props":{"y":"88","text":"新名称：","width":"122","align":"right","height":"18","color":"#c5c5c5","x":"31"}},{"type":"TextInput","props":{"skin":"comp/input_32.png","y":"82","sizeGrid":"0,3,0,3","height":"32","var":"nameTxt","color":"#c5c5c5","x":"157"}},{"type":"CheckBox","props":{"skin":"comp/checkbox.png","y":"121","selected":"true","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5,#c5c5c5","var":"updateCheck","label":"是否更新页面嵌套引用(不选择能提高性能)","x":"155"}},{"type":"Label","props":{"y":"56","text":"原名称：","width":"111","align":"right","height":"18","color":"#c5c5c5","x":"42"}},{"type":"Label","props":{"var":"resLbl","text":"页面内容","width":"214","height":"20","y":"56","color":"#cccc00","x":"157"}},{"type":"Button","props":{"skin":"comp/button.png","name":"sure","sizeGrid":"0,4,0,4","label":"确定","x":"108","y":"156","labelColors":"#efefef,#ffffff,#c5c5c5,#c5c5c5"}},{"type":"Button","props":{"skin":"comp/btn.png","name":"cancel","sizeGrid":"0,4,0,4","label":"取消","x":"248","y":"156","labelColors":"#efefef,#ffffff,#c5c5c5,#c5c5c5"}}],"type":"Dialog","props":{"height":"220","scenecolor":"#dddddd","width":"450"}};}
		]);
		return RenamePageUI;
	})(Dialog)


	//class laya.editor.ui.page.SetPagePropUI extends laya.ui.Dialog
	var SetPagePropUI=(function(_super){
		function SetPagePropUI(){
			this.nameLbl=null;
			this.propsTxt=null;
			this.packType=null;
			this.anameTxt=null;
			SetPagePropUI.__super.call(this);
		}

		__class(SetPagePropUI,'laya.editor.ui.page.SetPagePropUI',_super);
		var __proto=SetPagePropUI.prototype;
		__proto.createChildren=function(){
			laya.ui.Component.prototype.createChildren.call(this);
			this.createView(SetPagePropUI.uiView);
		}

		__static(SetPagePropUI,
		['uiView',function(){return this.uiView={"child":[{"type":"Image","props":{"skin":"view/bg_dialog.png","y":"0","sizeGrid":"60,10,10,10","width":"450","height":"360","x":"0"}},{"type":"Button","props":{"skin":"view/btn_close.png","name":"close","scaleY":"0.5","scaleX":"0.5","top":"18","right":"18"}},{"type":"Image","props":{"skin":"comp/blank.png","y":"8","width":"395","height":"38","name":"drag","x":"9"}},{"type":"Label","props":{"y":"18","color":"#c5c5c5","fontSize":"14","text":"设置页面默认属性","x":"28"}},{"type":"Label","props":{"y":"58","text":"页面内容","width":"260","height":"20","var":"nameLbl","color":"#cccc00","x":"126"}},{"type":"Label","props":{"y":"58","text":"页面名称：","width":"95","align":"right","height":"18","color":"#c5c5c5","x":"27"}},{"type":"Label","props":{"y":"120","text":"默认属性：","width":"93","align":"right","height":"18","color":"#c5c5c5","x":"29"}},{"type":"Label","props":{"y":"153","wordWrap":"true","text":"示例(回车换行)\\ncolor=#00ff00\\nsize=14\\ntext=test","width":"100","isHtml":"true","height":"85","color":"#c5c5c5","multiline":"true","x":"26"}},{"type":"Button","props":{"skin":"comp/button.png","y":"299","sizeGrid":"0,4,0,4","width":"100","labelColors":"#efefef,#ffffff,#c5c5c5,#c5c5c5","height":"30","name":"sure","label":"确定","x":"126"}},{"type":"TextArea","props":{"sizeGrid":"3,3,3,3","padding":"5,5,5,5","margin":"2,2,2,2","color":"#c5c5c5","multiline":"true","x":"126","skin":"comp/input_32.png","vScrollBarSkin":"comp/vscroll.png","y":"120","wordWrap":"true","width":"249","height":"122","var":"propsTxt"}},{"type":"Label","props":{"y":"248","wordWrap":"true","text":"提示：页面嵌套时，会自动应用上面设置默认属性，此属性为全局属性","width":"269","height":"41","color":"#cc00","multiline":"true","x":"123"}},{"type":"Label","props":{"y":"59","text":"导出类型：","width":"85","align":"right","height":"19","color":"#c5c5c5","x":"219"}},{"type":"ComboBox","props":{"skin":"comp/combo_22.png","y":"55","sizeGrid":"0,20,0,3","labels":"默认,内嵌模式,加载模式,分离模式","width":"75","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5,#c5c5c5","height":"22","var":"packType","x":"299"}},{"type":"Label","props":{"y":"86","text":"页面别名：","width":"81","align":"right","height":"18","color":"#c5c5c5","x":"41"}},{"type":"TextInput","props":{"skin":"comp/input_24.png","y":"85","sizeGrid":"0,3,0,3","width":"140","height":"24","var":"anameTxt","color":"#c5c5c5","x":"126"}}],"type":"Dialog","props":{"height":"360","scenecolor":"#dddddd","width":"450"}};}
		]);
		return SetPagePropUI;
	})(Dialog)


	//class laya.editor.ui.page.SetPageUI extends laya.ui.Dialog
	var SetPageUI=(function(_super){
		function SetPageUI(){
			this.title=null;
			this.widthCheck=null;
			this.heightCheck=null;
			this.typeDrop=null;
			this.nameTxt=null;
			this.imgTxt=null;
			this.widthTxt=null;
			this.heightTxt=null;
			this.bgColorPicker=null;
			this.sureBtn=null;
			this.selectBtn=null;
			SetPageUI.__super.call(this);
		}

		__class(SetPageUI,'laya.editor.ui.page.SetPageUI',_super);
		var __proto=SetPageUI.prototype;
		__proto.createChildren=function(){
			laya.ui.Component.prototype.createChildren.call(this);
			this.createView(SetPageUI.uiView);
		}

		__static(SetPageUI,
		['uiView',function(){return this.uiView={"child":[{"type":"Image","props":{"skin":"view/bg_dialog.png","y":"0","sizeGrid":"60,10,10,10","width":"470","height":"330","x":"0"}},{"type":"Button","props":{"skin":"view/btn_close.png","name":"close","scaleY":"0.5","scaleX":"0.5","top":"18","right":"18"}},{"type":"Image","props":{"skin":"comp/blank.png","y":"8","width":"420","height":"38","name":"drag","x":"9"}},{"type":"Label","props":{"y":"18","text":"设置页面","var":"title","color":"#c5c5c5","fontSize":"14","x":"28"}},{"type":"CheckBox","props":{"skin":"comp/checkbox.png","y":"159","label":"仅作为参考宽度","x":"298","var":"widthCheck","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5,#c5c5c5"}},{"type":"CheckBox","props":{"skin":"comp/checkbox.png","y":"192","label":"仅作为参考高度","x":"298","var":"heightCheck","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5,#c5c5c5"}},{"type":"Label","props":{"y":"57","color":"#c5c5c5","text":"页面类型：","x":"78"}},{"type":"Label","props":{"y":"90","color":"#c5c5c5","text":"页面名称：","x":"78"}},{"type":"Label","props":{"y":"123","color":"#c5c5c5","text":"参考视图：","x":"78"}},{"type":"Label","props":{"y":"156","color":"#c5c5c5","text":"页面宽度：","x":"78"}},{"type":"Label","props":{"y":"189","color":"#c5c5c5","text":"页面高度：","x":"78"}},{"type":"Label","props":{"y":"222","wordWrap":"true","text":"参考背景：","width":"68","height":"60","color":"#c5c5c5","x":"78"}},{"type":"ComboBox","props":{"skin":"comp/combo_24.png","y":"55","sizeGrid":"0,20,0,3","labels":"View,Dialog","scrollBarSkin":"comp/vscroll.png","width":"140","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5,#c5c5c5","height":"24","var":"typeDrop","selectedIndex":"0","x":"151"}},{"type":"TextInput","props":{"skin":"comp/input_24.png","y":"89","sizeGrid":"0,3,0,3","disabled":"true","width":"140","height":"24","var":"nameTxt","color":"#c5c5c5","x":"151"}},{"type":"TextInput","props":{"skin":"comp/input_24.png","y":"122","sizeGrid":"0,3,0,3","width":"108","height":"24","var":"imgTxt","color":"#c5c5c5","x":"151"}},{"type":"TextInput","props":{"skin":"comp/input_24.png","y":"155","sizeGrid":"0,3,0,3","text":"600","width":"140","height":"24","var":"widthTxt","color":"#c5c5c5","x":"151"}},{"type":"TextInput","props":{"skin":"comp/input_24.png","y":"188","sizeGrid":"0,3,0,3","text":"400","width":"140","height":"24","var":"heightTxt","color":"#c5c5c5","x":"151"}},{"type":"ColorPicker","props":{"skin":"comp/color.png","y":"221","selectedcolor":"#dddddd","scaleX":"0.5","var":"bgColorPicker","scaleY":"0.5","x":"151"}},{"type":"Button","props":{"skin":"comp/button.png","y":"271","var":"sureBtn","label":"修改","labelColors":"#efefef,#ffffff,#c5c5c5,#c5c5c5","height":"30","name":"sure","sizeGrid":"0,4,0,4","width":"100","x":"175"}},{"type":"Label","props":{"y":"123","wordWrap":"true","text":"(可选，参考背景)","width":"146","height":"32","color":"#c5c5c5","x":"306"}},{"type":"Label","props":{"y":"223","text":"(可选，设计面板的背景颜色)","width":"226","height":"18","color":"#c5c5c5","x":"172"}},{"type":"Button","props":{"skin":"comp/btn_browser.png","y":"122","label":"浏览","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5","height":"24","var":"selectBtn","width":"46","x":"259"}}],"type":"Dialog","props":{"height":"330","scenecolor":"#dddddd","width":"470"}};}
		]);
		return SetPageUI;
	})(Dialog)


	//class laya.editor.ui.res.MoveResUI extends laya.ui.Dialog
	var MoveResUI=(function(_super){
		function MoveResUI(){
			this.msgLbl=null;
			this.updateCheck=null;
			MoveResUI.__super.call(this);
		}

		__class(MoveResUI,'laya.editor.ui.res.MoveResUI',_super);
		var __proto=MoveResUI.prototype;
		__proto.createChildren=function(){
			laya.ui.Component.prototype.createChildren.call(this);
			this.createView(MoveResUI.uiView);
		}

		__static(MoveResUI,
		['uiView',function(){return this.uiView={"child":[{"type":"Image","props":{"skin":"view/bg_dialog.png","y":"0","sizeGrid":"60,10,10,10","width":"450","height":"200","x":"0"}},{"type":"Button","props":{"skin":"view/btn_close.png","name":"close","scaleY":"0.5","scaleX":"0.5","top":"18","right":"18"}},{"type":"Image","props":{"skin":"comp/blank.png","y":"8","width":"396","height":"38","name":"drag","x":"9"}},{"type":"Label","props":{"y":"18","color":"#c5c5c5","fontSize":"14","text":"移动资源","x":"28"}},{"type":"Label","props":{"y":"62","wordWrap":"true","leading":"10","text":"确定移动资源吗？","width":"350","align":"center","height":"66","var":"msgLbl","color":"#c5c5c5","multiline":"true","x":"50"}},{"type":"CheckBox","props":{"skin":"comp/checkbox.png","y":"108","visible":"false","selected":"true","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5,#c5c5c5","var":"updateCheck","label":"是否更新页面引用(不选择能提高性能)","x":"116"}},{"type":"Button","props":{"skin":"comp/button.png","name":"sure","sizeGrid":"0,4,0,4","label":"确定","labelColors":"#efefef,#ffffff,#c5c5c5,#c5c5c5","height":"30","y":"140","width":"100","x":"100"}},{"type":"Button","props":{"skin":"comp/btn.png","name":"cancel","sizeGrid":"0,4,0,4","width":"100","labelColors":"#efefef,#ffffff,#c5c5c5,#c5c5c5","height":"30","y":"140","label":"取消","x":"250"}}],"type":"Dialog","props":{"height":"200","scenecolor":"#dddddd","width":"450"}};}
		]);
		return MoveResUI;
	})(Dialog)


	//class laya.editor.ui.res.RenameResUI extends laya.ui.Dialog
	var RenameResUI=(function(_super){
		function RenameResUI(){
			this.nameTxt=null;
			this.updateCheck=null;
			this.resLbl=null;
			RenameResUI.__super.call(this);
		}

		__class(RenameResUI,'laya.editor.ui.res.RenameResUI',_super);
		var __proto=RenameResUI.prototype;
		__proto.createChildren=function(){
			laya.ui.Component.prototype.createChildren.call(this);
			this.createView(RenameResUI.uiView);
		}

		__static(RenameResUI,
		['uiView',function(){return this.uiView={"child":[{"type":"Image","props":{"skin":"view/bg_dialog.png","y":"0","sizeGrid":"60,10,10,10","width":"450","height":"220","x":"0"}},{"type":"Button","props":{"skin":"view/btn_close.png","name":"close","scaleY":"0.5","scaleX":"0.5","top":"18","right":"18"}},{"type":"Image","props":{"skin":"comp/blank.png","y":"8","width":"396","height":"38","name":"drag","x":"9"}},{"type":"Label","props":{"y":"18","color":"#c5c5c5","fontSize":"14","text":"重命名资源","x":"28"}},{"type":"Label","props":{"y":"94","text":"新名称：","width":"134","align":"right","height":"18","color":"#c5c5c5","x":"12"}},{"type":"TextInput","props":{"skin":"comp/input_32.png","y":"89","sizeGrid":"0,3,0,3","width":"150","height":"32","var":"nameTxt","color":"#c5c5c5","x":"150"}},{"type":"CheckBox","props":{"skin":"comp/checkbox.png","y":"129","selected":"true","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5,#c5c5c5","var":"updateCheck","label":"是否更新页面引用(不选择能提高性能)","x":"151"}},{"type":"Label","props":{"y":"63","text":"原名称：","width":"123","align":"right","height":"18","color":"#c5c5c5","x":"23"}},{"type":"Label","props":{"var":"resLbl","text":"资源内容","width":"214","height":"20","y":"63","color":"#cccc00","x":"150"}},{"type":"Button","props":{"skin":"comp/button.png","name":"sure","sizeGrid":"0,4,0,4","label":"确定","labelColors":"#efefef,#ffffff,#c5c5c5,#c5c5c5","height":"30","y":"158","width":"100","x":"100"}},{"type":"Button","props":{"skin":"comp/btn.png","name":"cancel","sizeGrid":"0,4,0,4","width":"100","labelColors":"#efefef,#ffffff,#c5c5c5,#c5c5c5","height":"30","y":"158","label":"取消","x":"250"}}],"type":"Dialog","props":{"scenecolor":"#dddddd"}};}
		]);
		return RenameResUI;
	})(Dialog)


	//class laya.editor.ui.res.SetDirPropUI extends laya.ui.Dialog
	var SetDirPropUI=(function(_super){
		function SetDirPropUI(){
			this.nameLbl=null;
			this.packType=null;
			SetDirPropUI.__super.call(this);
		}

		__class(SetDirPropUI,'laya.editor.ui.res.SetDirPropUI',_super);
		var __proto=SetDirPropUI.prototype;
		__proto.createChildren=function(){
			laya.ui.Component.prototype.createChildren.call(this);
			this.createView(SetDirPropUI.uiView);
		}

		__static(SetDirPropUI,
		['uiView',function(){return this.uiView={"child":[{"type":"Image","props":{"skin":"view/bg_dialog.png","y":"0","sizeGrid":"60,10,10,10","width":"510","mouseEnabled":"true","height":"240","x":"0"}},{"type":"Button","props":{"skin":"view/btn_close.png","name":"close","scaleY":"0.5","scaleX":"0.5","top":"18","right":"18"}},{"type":"Image","props":{"skin":"comp/blank.png","y":"8","width":"468","height":"38","name":"drag","x":"9"}},{"type":"Label","props":{"y":"18","color":"#c5c5c5","fontSize":"14","text":"目录属性设置","x":"28"}},{"type":"Label","props":{"y":"60","text":"目录名称：","width":"145","align":"right","height":"18","color":"#c5c5c5","x":"13"}},{"type":"Button","props":{"skin":"comp/button.png","y":"171","sizeGrid":"0,4,0,4","width":"100","labelColors":"#efefef,#ffffff,#c5c5c5,#c5c5c5","name":"sure","label":"确定","x":"190"}},{"type":"Label","props":{"y":"60","text":"页面内容","width":"260","height":"20","var":"nameLbl","color":"#cccc00","x":"162"}},{"type":"Label","props":{"y":"109","text":"打包类型：","width":"145","align":"right","height":"19","color":"#c5c5c5","x":"13"}},{"type":"ComboBox","props":{"skin":"comp/combo_22.png","y":"105","sizeGrid":"0,20,0,3","labels":"默认,打包,不打包","width":"237","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5,#c5c5c5","height":"22","var":"packType","x":"161"}}],"type":"Dialog","props":{"height":"240","scenecolor":"#dddddd","width":"510"}};}
		]);
		return SetDirPropUI;
	})(Dialog)


	//class laya.editor.ui.res.SetMultiResPropUI extends laya.ui.Dialog
	var SetMultiResPropUI=(function(_super){
		function SetMultiResPropUI(){
			this.nameLbl=null;
			this.packType=null;
			SetMultiResPropUI.__super.call(this);
		}

		__class(SetMultiResPropUI,'laya.editor.ui.res.SetMultiResPropUI',_super);
		var __proto=SetMultiResPropUI.prototype;
		__proto.createChildren=function(){
			laya.ui.Component.prototype.createChildren.call(this);
			this.createView(SetMultiResPropUI.uiView);
		}

		__static(SetMultiResPropUI,
		['uiView',function(){return this.uiView={"child":[{"type":"Image","props":{"skin":"view/bg_dialog.png","y":"0","sizeGrid":"60,10,10,10","width":"510","mouseEnabled":"true","height":"240","x":"0"}},{"type":"Button","props":{"skin":"view/btn_close.png","name":"close","scaleY":"0.5","scaleX":"0.5","top":"18","right":"18"}},{"type":"Image","props":{"skin":"comp/blank.png","y":"8","width":"468","height":"38","name":"drag","x":"9"}},{"type":"Label","props":{"y":"18","color":"#c5c5c5","fontSize":"14","text":"资源属性设置","x":"28"}},{"type":"Label","props":{"y":"60","text":"资源名称：","width":"145","align":"right","height":"18","color":"#c5c5c5","x":"13"}},{"type":"Button","props":{"skin":"comp/button.png","y":"171","sizeGrid":"0,4,0,4","width":"100","labelColors":"#efefef,#ffffff,#c5c5c5,#c5c5c5","name":"sure","label":"确定","x":"190"}},{"type":"Label","props":{"y":"60","wordWrap":"true","text":"页面内容","width":"260","height":"41","var":"nameLbl","color":"#cccc00","x":"162"}},{"type":"Label","props":{"y":"109","text":"打包类型：","width":"145","align":"right","height":"19","color":"#c5c5c5","x":"13"}},{"type":"ComboBox","props":{"skin":"comp/combo_22.png","y":"105","sizeGrid":"0,20,0,3","labels":"默认,打包,不打包","width":"237","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5,#c5c5c5","height":"22","var":"packType","x":"161"}}],"type":"Dialog","props":{"height":"240","scenecolor":"#dddddd","width":"510"}};}
		]);
		return SetMultiResPropUI;
	})(Dialog)


	//class laya.editor.ui.res.SetResPropUI extends laya.ui.Dialog
	var SetResPropUI=(function(_super){
		function SetResPropUI(){
			this.nameLbl=null;
			this.propsTxt=null;
			this.typeDrop=null;
			this.setSizeGridBtn=null;
			this.packType=null;
			this.picType=null;
			SetResPropUI.__super.call(this);
		}

		__class(SetResPropUI,'laya.editor.ui.res.SetResPropUI',_super);
		var __proto=SetResPropUI.prototype;
		__proto.createChildren=function(){
			laya.ui.Component.prototype.createChildren.call(this);
			this.createView(SetResPropUI.uiView);
		}

		__static(SetResPropUI,
		['uiView',function(){return this.uiView={"child":[{"type":"Image","props":{"skin":"view/bg_dialog.png","y":"0","sizeGrid":"60,10,10,10","width":"520","mouseEnabled":"true","height":"410","x":"0"}},{"type":"Button","props":{"skin":"view/btn_close.png","name":"close","scaleY":"0.5","scaleX":"0.5","top":"18","right":"18"}},{"type":"Image","props":{"skin":"comp/blank.png","y":"8","width":"468","height":"38","name":"drag","x":"9"}},{"type":"Label","props":{"y":"18","color":"#c5c5c5","fontSize":"14","text":"资源属性设置","x":"28"}},{"type":"Label","props":{"y":"60","text":"资源名称：","width":"137","align":"right","height":"18","color":"#c5c5c5","x":"21"}},{"type":"Label","props":{"y":"134","text":"默认全局属性：","width":"143","align":"right","height":"18","color":"#c5c5c5","x":"14"}},{"type":"Label","props":{"y":"166","wordWrap":"true","text":"示例(回车换行)\\ncolor=#00ff00\\nsize=14\\ntext=test","width":"100","height":"115","color":"#c5c5c5","multiline":"true","x":"62"}},{"type":"Button","props":{"skin":"comp/button.png","y":"363","sizeGrid":"0,4,0,4","width":"100","labelColors":"#efefef,#ffffff,#c5c5c5,#c5c5c5","name":"sure","label":"确定","x":"162"}},{"type":"Label","props":{"y":"60","text":"页面内容","width":"260","height":"20","var":"nameLbl","color":"#cccc00","x":"162"}},{"type":"TextArea","props":{"sizeGrid":"3,3,3,3","padding":"5,5,5,5","margin":"2,2,2,2","color":"#c5c5c5","multiline":"true","x":"162","skin":"comp/input_32.png","vScrollBarSkin":"comp/vscroll.png","y":"133","width":"250","height":"150","var":"propsTxt"}},{"type":"Label","props":{"y":"93","text":"组件类型：","width":"142","align":"right","height":"18","color":"#c5c5c5","x":"16"}},{"type":"ComboBox","props":{"skin":"comp/combo_32.png","y":"88","sizeGrid":"0,20,0,3","labels":"Button,CheckBox,Clip,ComboBox,HScrollBar,HSlider,Image,Label,LinkButton,List,ProgressBar,Radio,RadioGroup,Tab,TextArea,TextInput,VScrollBar,VSlider,Tree","width":"150","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5,#c5c5c5","height":"32","var":"typeDrop","scrollBarSkin":"comp/vscroll.png","x":"162"}},{"type":"Label","props":{"y":"292","wordWrap":"true","text":"提示：使用组件时，会自动应用上面设置默认属性。此属性为全局属性，","width":"312","height":"38","color":"#00cc00","x":"160"}},{"type":"Button","props":{"skin":"comp/btn.png","y":"90","sizeGrid":"0,4,0,4","width":"81","labelColors":"#efefef,#ffffff,#c5c5c5,#c5c5c5","var":"setSizeGridBtn","label":"设置九宫","x":"330"}},{"type":"Label","props":{"y":"333","text":"打包类型：","width":"64","height":"19","color":"#c5c5c5","x":"162"}},{"type":"ComboBox","props":{"skin":"comp/combo_22.png","y":"329","sizeGrid":"0,20,0,3","labels":"默认,打包,不打包","width":"59","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5,#c5c5c5","height":"22","var":"packType","x":"221"}},{"type":"Label","props":{"y":"333","text":"图片类型：","width":"72","align":"right","height":"19","color":"#c5c5c5","x":"283"}},{"type":"ComboBox","props":{"skin":"comp/combo_22.png","y":"329","sizeGrid":"0,20,0,3","labels":"默认,Repeat","width":"59","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5,#c5c5c5","height":"22","var":"picType","x":"352"}}],"type":"Dialog","props":{"height":"420","scenecolor":"#dddddd","width":"520"}};}
		]);
		return SetResPropUI;
	})(Dialog)


	//class laya.editor.ui.res.SetSizeGridUI extends laya.ui.Dialog
	var SetSizeGridUI=(function(_super){
		function SetSizeGridUI(){
			this.upTxt=null;
			this.rightTxt=null;
			this.downTxt=null;
			this.leftTxt=null;
			this.nameLbl=null;
			this.typeDrop=null;
			this.typeTxt=null;
			this.desTxt=null;
			this.demoRec=null;
			this.opRec=null;
			SetSizeGridUI.__super.call(this);
		}

		__class(SetSizeGridUI,'laya.editor.ui.res.SetSizeGridUI',_super);
		var __proto=SetSizeGridUI.prototype;
		__proto.createChildren=function(){
			laya.ui.Component.prototype.createChildren.call(this);
			this.createView(SetSizeGridUI.uiView);
		}

		__static(SetSizeGridUI,
		['uiView',function(){return this.uiView={"child":[{"type":"Image","props":{"skin":"view/bg_dialog.png","y":"0","sizeGrid":"60,10,10,10","width":"520","height":"420","x":"0"}},{"type":"Button","props":{"skin":"view/btn_close.png","name":"close","scaleY":"0.5","scaleX":"0.5","top":"18","right":"18"}},{"type":"Image","props":{"skin":"comp/blank.png","y":"8","width":"468","height":"38","name":"drag","x":"9"}},{"type":"Label","props":{"y":"14","color":"#c5c5c5","fontSize":"14","text":"九宫格设置","x":"23"}},{"type":"Label","props":{"align":"right","y":"335","color":"#c5c5c5","text":"上：","x":"47"}},{"type":"TextInput","props":{"skin":"comp/input_24.png","y":"331","sizeGrid":"0,3,0,3","disabled":"true","width":"72","height":"24","var":"upTxt","color":"#c5c5c5","x":"76"}},{"type":"Label","props":{"align":"right","y":"335","color":"#c5c5c5","text":"右：","x":"156"}},{"type":"TextInput","props":{"skin":"comp/input_24.png","y":"331","sizeGrid":"0,3,0,3","disabled":"true","width":"72","height":"24","var":"rightTxt","color":"#c5c5c5","x":"185"}},{"type":"Label","props":{"y":"335","text":"下：","width":"33","align":"right","height":"18","color":"#c5c5c5","x":"264"}},{"type":"TextInput","props":{"skin":"comp/input_24.png","y":"331","sizeGrid":"0,3,0,3","disabled":"true","width":"72","height":"24","var":"downTxt","color":"#c5c5c5","x":"298"}},{"type":"Label","props":{"align":"right","y":"335","color":"#c5c5c5","text":"左：","x":"385"}},{"type":"TextInput","props":{"skin":"comp/input_24.png","y":"332","sizeGrid":"0,3,0,3","disabled":"true","width":"72","height":"24","var":"leftTxt","color":"#c5c5c5","x":"414"}},{"type":"Image","props":{"skin":"view/bg_panel.png","y":"103","sizeGrid":"4,4,4,4","width":"485","height":"215","x":"14"}},{"type":"Label","props":{"y":"54","color":"#c5c5c5","text":"资源名称：","x":"21"}},{"type":"Button","props":{"skin":"comp/button.png","y":"366","sizeGrid":"0,4,0,4","width":"100","labelColors":"#efefef,#ffffff,#c5c5c5,#c5c5c5","name":"sure","label":"确定","x":"205"}},{"type":"Label","props":{"y":"54","text":"页面内容","width":"260","height":"20","var":"nameLbl","color":"#cccc00","x":"89"}},{"type":"Label","props":{"y":"45","visible":"false","color":"#c5c5c5","text":"组件类型：","x":"223"}},{"type":"ComboBox","props":{"skin":"comp/combo_24.png","y":"47","visible":"false","labels":"Button,CheckBox,Clip,ComboBox,HScrollBar,HSlider,Image,Label,LinkButton,List,ProgressBar,Radio,RadioGroup,Tab,TextArea,TextInput,VScrollBar,VSlider,Tree","width":"127","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5,#c5c5c5","height":"24","var":"typeDrop","sizeGrid":"0,20,0,3","scrollBarSkin":"comp/vscroll.png","x":"366"}},{"type":"Label","props":{"y":"46","visible":"false","text":"页面内容","width":"64","height":"20","var":"typeTxt","color":"#cccc00","x":"290"}},{"type":"Label","props":{"y":"78","text":"提示：拖动红线调整数值，右键按下可整体拖动","width":"473","height":"20","var":"desTxt","color":"#c5c5c5","x":"19"}},{"type":"Image","props":{"skin":"view/bg_content.png","y":"107","sizeGrid":"5,5,5,5","width":"233","height":"205","var":"demoRec","x":"18"}},{"type":"Image","props":{"skin":"view/bg_content.png","y":"107","sizeGrid":"5,5,5,5","width":"235","height":"205","var":"opRec","x":"259"}},{"type":"Label","props":{"y":"105","text":"预览","width":"64","height":"20","visible":"true","color":"#c5c5c5","x":"24"}}],"type":"Dialog","props":{"height":"420","scenecolor":"#dddddd","width":"520"}};}
		]);
		return SetSizeGridUI;
	})(Dialog)


	//class laya.editor.ui.template.AddTemplateUI extends laya.ui.Dialog
	var AddTemplateUI=(function(_super){
		function AddTemplateUI(){
			this.title=null;
			this.typeDrop=null;
			this.nameTxt=null;
			this.sureBtn=null;
			AddTemplateUI.__super.call(this);
		}

		__class(AddTemplateUI,'laya.editor.ui.template.AddTemplateUI',_super);
		var __proto=AddTemplateUI.prototype;
		__proto.createChildren=function(){
			laya.ui.Component.prototype.createChildren.call(this);
			this.createView(AddTemplateUI.uiView);
		}

		__static(AddTemplateUI,
		['uiView',function(){return this.uiView={"child":[{"type":"Image","props":{"skin":"view/bg_dialog.png","y":"0","sizeGrid":"60,10,10,10","width":"470","height":"220","x":"0"}},{"type":"Button","props":{"skin":"view/btn_close.png","name":"close","scaleY":"0.5","scaleX":"0.5","top":"18","right":"18"}},{"type":"Image","props":{"skin":"comp/blank.png","y":"8","width":"418","height":"38","name":"drag","x":"9"}},{"type":"Label","props":{"y":"18","text":"转换成模板","width":"119","height":"18","var":"title","color":"#c5c5c5","fontSize":"14","x":"28"}},{"type":"Label","props":{"y":"74","text":"目录：","width":"164","align":"right","height":"18","color":"#c5c5c5","x":"18"}},{"type":"Label","props":{"y":"108","text":"页面名称：","width":"159","align":"right","height":"18","color":"#c5c5c5","x":"23"}},{"type":"ComboBox","props":{"skin":"comp/combo_24.png","y":"72","sizeGrid":"0,20,0,3","labels":"自定义模板,常用模板","scrollBarSkin":"comp/vscroll.png","width":"140","labelColors":"#dddddd","height":"24","var":"typeDrop","selectedIndex":"0","x":"191"}},{"type":"TextInput","props":{"skin":"comp/input_24.png","y":"107","sizeGrid":"0,3,0,3","width":"140","height":"24","var":"nameTxt","color":"#c5c5c5","x":"191"}},{"type":"Button","props":{"skin":"comp/button.png","y":"159","var":"sureBtn","label":"新增","labelColors":"#efefef,#ffffff,#c5c5c5,#c5c5c5","height":"30","name":"sure","sizeGrid":"0,4,0,4","width":"100","x":"190"}}],"type":"Dialog","props":{"height":"220","scenecolor":"#dddddd","width":"470"}};}
		]);
		return AddTemplateUI;
	})(Dialog)


	//class laya.editor.ui.BasicPanelUI extends laya.ide.ui.DragView
	var BasicPanelUI=(function(_super){
		function BasicPanelUI(){
			this.resTree=null;
			this.opBox=null;
			BasicPanelUI.__super.call(this);
		}

		__class(BasicPanelUI,'laya.editor.ui.BasicPanelUI',_super);
		var __proto=BasicPanelUI.prototype;
		__proto.createChildren=function(){
			laya.ui.Component.prototype.createChildren.call(this);
			this.createView(BasicPanelUI.uiView);
		}

		__static(BasicPanelUI,
		['uiView',function(){return this.uiView={"child":[{"type":"Image","props":{"skin":"view/bg_panel.png","y":"48","sizeGrid":"4,4,4,4","right":"0","width":"200","left":"0","height":"300","top":"0","bottom":"0","x":"415"}},{"child":[{"child":[{"type":"Clip","props":{"skin":"comp/clip_selectBox.png","y":"0","x":"13","left":"9","height":"25","name":"selectBox","right":"0","clipY":"2"}},{"type":"Image","props":{"skin":"comp/folder.png","name":"icon","width":"16","height":"16","y":"4","x":"14"}},{"type":"Label","props":{"padding":"4,0,0,0","y":"2","text":"label","width":"150","left":"38","height":"22","name":"label","color":"#d8d8d8","right":"0","x":"33"}},{"type":"Clip","props":{"skin":"comp/clip_tree.png","y":"6","width":"11","clipY":"2","height":"12","name":"arrow","x":"0"}}],"type":"Box","props":{"name":"render","right":"0","left":"0"}}],"type":"TreeEx","props":{"y":"552","right":"2","width":"196","left":"2","hitTestPrior":"true","height":"136","var":"resTree","top":"2","scrollBarSkin":"comp/vscroll.png","bottom":"29","x":"173"}},{"child":[{"type":"Image","props":{"skin":"view/bg_panel_bar.png","sizeGrid":"0,4,0,4","bottom":"0","width":"191","left":"0","top":"0","right":"0"}},{"type":"Button","props":{"skin":"view/login2.png","stateNum":"3","y":"3","name":"openDirBtn","scaleX":"0.5","toolTip":"打开所在目录","scaleY":"0.5","x":"3"}},{"type":"Button","props":{"skin":"view/refresh2.png","stateNum":"3","y":"4","name":"refreshBtn","scaleX":"0.5","toolTip":"刷新资源树","scaleY":"0.5","x":"26"}}],"type":"Box","props":{"y":"271","right":"0","width":"198","left":"0","height":"28","var":"opBox","bottom":"0","x":"1"}}],"type":"DragView","props":{"title":"元件","height":"300","scenecolor":"#dddddd","hitTestPrior":"true","width":"200"}};}
		]);
		return BasicPanelUI;
	})(DragView)


	//class laya.editor.ui.DisplayTreePanelUI extends laya.ide.ui.DragView
	var DisplayTreePanelUI=(function(_super){
		function DisplayTreePanelUI(){
			this.opBox=null;
			this.fliterTxt=null;
			this.clearSearchBtn=null;
			this.displayTree=null;
			DisplayTreePanelUI.__super.call(this);
		}

		__class(DisplayTreePanelUI,'laya.editor.ui.DisplayTreePanelUI',_super);
		var __proto=DisplayTreePanelUI.prototype;
		__proto.createChildren=function(){
			laya.ui.Component.prototype.createChildren.call(this);
			this.createView(DisplayTreePanelUI.uiView);
		}

		__static(DisplayTreePanelUI,
		['uiView',function(){return this.uiView={"child":[{"type":"Image","props":{"skin":"view/bg_panel.png","y":"10","sizeGrid":"4,4,4,4","right":"0","width":"200","left":"0","height":"300","top":"0","bottom":"0","x":"10"}},{"child":[{"type":"Image","props":{"skin":"view/bg_panel_bar.png","sizeGrid":"0,4,0,4","bottom":"0","width":"191","left":"0","top":"0","right":"0"}},{"type":"TextInput","props":{"skin":"comp/input_filter.png","y":"4","toolTip":"输入关键词过滤","sizeGrid":"0,3,0,3","padding":"0,10,0,20","width":"115","left":"80","var":"fliterTxt","color":"#dddddd","right":"5","x":"80"}},{"type":"Button","props":{"skin":"view/refresh2.png","stateNum":"3","y":"4","name":"refreshBtn","scaleX":"0.5","toolTip":"刷新层级列表","scaleY":"0.5","x":"3"}},{"type":"Clip","props":{"skin":"view/clip_hide.png","y":"9","name":"ifShowAll","clipY":"2","scaleX":"0.5","toolTip":"全部隐藏","scaleY":"0.5","x":"31"}},{"type":"Clip","props":{"skin":"view/clip_lock.png","y":"3","name":"ifLockAll","width":"24","clipY":"2","height":"24","toolTip":"全部锁定","x":"55"}},{"type":"Clip","props":{"skin":"view/search.png","y":"5","scaleY":"0.5","clipY":"2","scaleX":"0.5","index":"1","x":"79"}},{"type":"Button","props":{"skin":"view/btn_close1.png","y":"10","scaleY":"0.5","scaleX":"0.5","var":"clearSearchBtn","right":"5","x":"181"}}],"type":"Box","props":{"y":"291","right":"0","left":"0","height":"28","var":"opBox","bottom":"0","x":"25"}},{"child":[{"child":[{"type":"Clip","props":{"skin":"comp/clip_selectBox.png","y":"0","x":"12","width":"184","left":"9","height":"26","name":"selectBox","right":"0","clipY":"2"}},{"type":"Label","props":{"padding":"4,0,0,0","y":"3","text":"label","width":"108","left":"38","height":"18","name":"label","color":"#d8d8d8","right":"50","x":"38"}},{"type":"Clip","props":{"skin":"comp/clip_tree.png","y":"6","width":"11","clipY":"2","height":"12","name":"arrow","x":"0"}},{"type":"Clip","props":{"skin":"view/clip_hide1.png","y":"0","name":"ifShow","width":"22","clipY":"2","height":"26","clipX":"1","right":"22","mouseEnabled":"true"}},{"type":"Clip","props":{"skin":"view/clip_lock1.png","y":"0","name":"ifLock","width":"22","clipY":"2","mouseEnabled":"true","height":"26","clipX":"1","right":"0","x":"160"}},{"type":"Image","props":{"skin":"comp/folder.png","y":"5","width":"16","height":"16","name":"icon","x":"14"}}],"type":"Box","props":{"height":"26","name":"render","right":"0","left":"0"}}],"type":"TreeEx","props":{"y":"45","var":"displayTree","bottom":"30","left":"2","top":"10","right":"2","scrollBarSkin":"comp/vscroll.png","x":"15"}}],"type":"DragView","props":{"title":"层级","height":"400","scenecolor":"#dddddd","hitTestPrior":"true","width":"200"}};}
		]);
		return DisplayTreePanelUI;
	})(DragView)


	//class laya.editor.ui.FramePropUI extends laya.ide.ui.DragView
	var FramePropUI=(function(_super){
		function FramePropUI(){
			this.tweenTip=null;
			this.tweenSelect=null;
			this.nameTxt=null;
			this.keyTxt=null;
			this.valueTxt=null;
			this.hasTween=null;
			this.targetTxt=null;
			this.targetIDTxt=null;
			this.labelTipTxt=null;
			this.labelTxt=null;
			FramePropUI.__super.call(this);
		}

		__class(FramePropUI,'laya.editor.ui.FramePropUI',_super);
		var __proto=FramePropUI.prototype;
		__proto.createChildren=function(){
			laya.ui.Component.prototype.createChildren.call(this);
			this.createView(FramePropUI.uiView);
		}

		__static(FramePropUI,
		['uiView',function(){return this.uiView={"child":[{"type":"Image","props":{"skin":"view/bg_panel.png","y":"0","sizeGrid":"4,4,4,4","right":"0","width":"200","left":"0","height":"300","top":"0","bottom":"0","x":"0"}},{"type":"Label","props":{"y":"145","text":"缓动类型","align":"right","var":"tweenTip","color":"#c5c5c5","x":"13"}},{"type":"Label","props":{"y":"15","color":"#c5c5c5","text":"动效名称","x":"12"}},{"type":"ComboBox","props":{"sizeGrid":"0,20,0,3","labels":"自定义模板,常用模板","scrollBarSkin":"comp/vscroll.png","x":"70","skin":"comp/combo_22.png","y":"141","selectedIndex":"0","width":"124","left":"70","height":"22","var":"tweenSelect","right":"5","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5,#c5c5c5"}},{"type":"TextInput","props":{"skin":"comp/input_22.png","y":"11","sizeGrid":"0,3,0,3","width":"109","left":"70","restrict":"0-9A-Za-z_","height":"22","var":"nameTxt","color":"#c5c5c5","right":"5","x":"83"}},{"type":"Label","props":{"y":"66","text":"关键帧值","width":"58","height":"18","var":"keyTxt","color":"#c5c5c5","x":"12"}},{"type":"TextInput","props":{"skin":"comp/input_22.png","y":"63","sizeGrid":"0,3,0,3","width":"109","left":"70","height":"22","var":"valueTxt","color":"#c5c5c5","right":"5","x":"70"}},{"type":"CheckBox","props":{"skin":"comp/checkbox.png","y":"120","label":"是否缓动","x":"15","var":"hasTween","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5,#c5c5c5"}},{"type":"Label","props":{"y":"41","text":"目标对象","width":"58","height":"18","var":"targetTxt","color":"#c5c5c5","x":"12"}},{"type":"TextInput","props":{"skin":"comp/input_22.png","y":"37","sizeGrid":"0,3,0,3","width":"109","left":"70","height":"22","var":"targetIDTxt","color":"#c5c5c5","right":"5","x":"70"}},{"type":"Label","props":{"y":"91","text":"标签label","width":"58","height":"18","var":"labelTipTxt","color":"#c5c5c5","x":"12"}},{"type":"TextInput","props":{"skin":"comp/input_22.png","y":"89","sizeGrid":"0,3,0,3","width":"109","left":"70","height":"22","var":"labelTxt","color":"#c5c5c5","right":"5","x":"68"}}],"type":"DragView","props":{"height":"300","scenecolor":"#dddddd","title":"帧属性","width":"200"}};}
		]);
		return FramePropUI;
	})(DragView)


	//class laya.editor.ui.PagePanelUI extends laya.ide.ui.DragView
	var PagePanelUI=(function(_super){
		function PagePanelUI(){
			this.pageTree=null;
			this.opBox=null;
			this.fliterTxt=null;
			this.clearSearchBtn=null;
			PagePanelUI.__super.call(this);
		}

		__class(PagePanelUI,'laya.editor.ui.PagePanelUI',_super);
		var __proto=PagePanelUI.prototype;
		__proto.createChildren=function(){
			laya.ui.Component.prototype.createChildren.call(this);
			this.createView(PagePanelUI.uiView);
		}

		__static(PagePanelUI,
		['uiView',function(){return this.uiView={"child":[{"type":"Image","props":{"skin":"view/bg_panel.png","y":"0","sizeGrid":"4,4,4,4","right":"0","width":"200","left":"0","height":"300","top":"0","bottom":"0","x":"0"}},{"child":[{"child":[{"type":"Clip","props":{"skin":"comp/clip_selectBox.png","y":"0","x":"13","left":"9","height":"24","name":"selectBox","right":"0","clipY":"2"}},{"type":"Image","props":{"skin":"comp/folder.png","name":"icon","width":"16","height":"16","y":"3","x":"15"}},{"type":"Label","props":{"padding":"4,0,0,0","y":"1","text":"label","width":"150","left":"38","height":"22","name":"label","color":"#d8d8d8","right":"0","x":"33"}},{"type":"Clip","props":{"skin":"comp/clip_tree.png","y":"5","width":"11","clipY":"2","height":"12","name":"arrow","x":"0"}}],"type":"Box","props":{"name":"render","right":"0","left":"0"}}],"type":"TreeEx","props":{"y":"22","right":"2","width":"190","left":"2","height":"260","var":"pageTree","top":"5","scrollBarSkin":"comp/vscroll.png","bottom":"29","x":"306"}},{"child":[{"type":"Image","props":{"skin":"view/bg_panel_bar.png","sizeGrid":"0,4,0,4","bottom":"0","width":"191","left":"0","top":"0","right":"0"}},{"type":"TextInput","props":{"skin":"comp/input_filter.png","y":"4","toolTip":"输入关键词过滤","sizeGrid":"0,3,0,3","padding":"0,10,0,20","width":"148","left":"80","var":"fliterTxt","color":"#dddddd","right":"5","x":"80"}},{"type":"Button","props":{"skin":"view/login2.png","stateNum":"3","y":"3","toolTip":"打开所在目录","scaleX":"0.5","name":"openDirBtn","scaleY":"0.5","x":"3"}},{"type":"Button","props":{"skin":"view/settings2.png","stateNum":"3","y":"3","name":"setPropBtn","scaleX":"0.5","toolTip":"设置默认属性","scaleY":"0.5","x":"29"}},{"type":"Button","props":{"skin":"view/refresh2.png","stateNum":"3","y":"4","name":"refreshBtn","scaleX":"0.5","toolTip":"刷新页面列表","scaleY":"0.5","x":"55"}},{"type":"Clip","props":{"skin":"view/search.png","y":"4","scaleY":"0.5","clipY":"2","scaleX":"0.5","index":"1","x":"79"}},{"type":"Button","props":{"skin":"view/btn_close1.png","y":"10","scaleY":"0.5","scaleX":"0.5","var":"clearSearchBtn","right":"5","x":"180"}}],"type":"Box","props":{"y":"271","right":"0","width":"198","left":"0","height":"28","var":"opBox","bottom":"0","x":"1"}}],"type":"DragView","props":{"hitTestPrior":"true","height":"300","scenecolor":"#dddddd","title":"项目","width":"200"}};}
		]);
		return PagePanelUI;
	})(DragView)


	//class laya.editor.ui.PropPanelUI extends laya.ide.ui.DragView
	var PropPanelUI=(function(_super){
		function PropPanelUI(){
			this.typeIcon=null;
			this.typeLbl=null;
			PropPanelUI.__super.call(this);
		}

		__class(PropPanelUI,'laya.editor.ui.PropPanelUI',_super);
		var __proto=PropPanelUI.prototype;
		__proto.createChildren=function(){
			laya.ui.Component.prototype.createChildren.call(this);
			this.createView(PropPanelUI.uiView);
		}

		__static(PropPanelUI,
		['uiView',function(){return this.uiView={"child":[{"type":"Image","props":{"skin":"view/bg_panel.png","y":"0","sizeGrid":"4,4,4,4","bottom":"0","width":"200","left":"0","height":"300","top":"0","right":"0","x":"0"}},{"type":"Image","props":{"skin":"comp/image.png","y":"10","var":"typeIcon","x":"7"}},{"type":"Label","props":{"var":"typeLbl","text":"label","y":"10","color":"#ffff00","fontSize":"14","bold":"true","x":"34"}}],"type":"DragView","props":{"scenecolor":"#dddddd","minWidth":"200","hitTestPrior":"true","title":"属性","mouseEnabled":"true"}};}
		]);
		return PropPanelUI;
	})(DragView)


	//class laya.editor.ui.ResPanelUI extends laya.ide.ui.DragView
	var ResPanelUI=(function(_super){
		function ResPanelUI(){
			this.resTree=null;
			this.resViewer=null;
			this.opBox=null;
			this.fliterTxt=null;
			this.clearSearchBtn=null;
			this.sizeTxt=null;
			ResPanelUI.__super.call(this);
		}

		__class(ResPanelUI,'laya.editor.ui.ResPanelUI',_super);
		var __proto=ResPanelUI.prototype;
		__proto.createChildren=function(){
			laya.ui.Component.prototype.createChildren.call(this);
			this.createView(ResPanelUI.uiView);
		}

		__static(ResPanelUI,
		['uiView',function(){return this.uiView={"child":[{"type":"Image","props":{"skin":"view/bg_panel.png","y":"48","sizeGrid":"4,4,4,4","right":"0","width":"200","left":"0","height":"300","top":"0","bottom":"0","x":"415"}},{"child":[{"child":[{"type":"Clip","props":{"skin":"comp/clip_selectBox.png","y":"0","x":"13","left":"9","height":"25","name":"selectBox","right":"0","clipY":"2"}},{"type":"Image","props":{"skin":"comp/folder.png","name":"icon","width":"16","height":"16","y":"4","x":"14"}},{"type":"Label","props":{"padding":"4,0,0,0","y":"2","text":"label","width":"150","left":"38","height":"22","name":"label","color":"#d8d8d8","right":"0","x":"33"}},{"type":"Clip","props":{"skin":"comp/clip_tree.png","y":"6","width":"11","clipY":"2","height":"12","name":"arrow","x":"0"}}],"type":"Box","props":{"name":"render","right":"0","left":"0"}}],"type":"TreeEx","props":{"y":"552","right":"2","width":"196","left":"2","hitTestPrior":"true","height":"136","var":"resTree","top":"112","scrollBarSkin":"comp/vscroll.png","bottom":"29","x":"173"}},{"type":"Image","props":{"y":"3","width":"198","left":"1","height":"100","var":"resViewer","right":"1","x":"222"}},{"type":"Image","props":{"skin":"comp/line.png","y":"106","left":"0","height":"1","right":"0","x":"2"}},{"child":[{"type":"Image","props":{"skin":"view/bg_panel_bar.png","sizeGrid":"0,4,0,4","bottom":"0","width":"191","left":"0","top":"0","right":"0"}},{"type":"TextInput","props":{"skin":"comp/input_filter.png","y":"4","toolTip":"输入关键词过滤","sizeGrid":"0,3,0,3","padding":"0,10,0,20","width":"148","left":"80","var":"fliterTxt","color":"#dddddd","right":"5","x":"80"}},{"type":"Button","props":{"skin":"view/login2.png","stateNum":"3","y":"3","name":"openDirBtn","scaleX":"0.5","toolTip":"打开所在目录","scaleY":"0.5","x":"3"}},{"type":"Button","props":{"skin":"view/settings2.png","stateNum":"3","y":"3","name":"setPropBtn","scaleX":"0.5","toolTip":"设置默认属性","scaleY":"0.5","x":"29"}},{"type":"Button","props":{"skin":"view/refresh2.png","stateNum":"3","y":"4","name":"refreshBtn","scaleX":"0.5","toolTip":"刷新资源树","scaleY":"0.5","x":"55"}},{"type":"Clip","props":{"skin":"view/search.png","y":"4","scaleY":"0.5","clipY":"2","scaleX":"0.5","index":"1","x":"79"}},{"type":"Button","props":{"skin":"view/btn_close1.png","y":"10","scaleY":"0.5","scaleX":"0.5","var":"clearSearchBtn","right":"5","x":"182"}}],"type":"Box","props":{"y":"271","right":"0","width":"198","left":"0","height":"28","var":"opBox","bottom":"0","x":"1"}},{"type":"Label","props":{"y":"82","var":"sizeTxt","text":"512*512","width":"162","align":"left","height":"19","name":"label","color":"#d8d8d8","padding":"4,0,0,0","x":"6"}}],"type":"DragView","props":{"title":"资源","height":"300","scenecolor":"#dddddd","hitTestPrior":"true","width":"200"}};}
		]);
		return ResPanelUI;
	})(DragView)


	//class laya.editor.ui.template.CompPanelUI extends laya.ide.ui.DragView
	var CompPanelUI=(function(_super){
		function CompPanelUI(){
			this.bg=null;
			this.groupBox=null;
			CompPanelUI.__super.call(this);
		}

		__class(CompPanelUI,'laya.editor.ui.template.CompPanelUI',_super);
		var __proto=CompPanelUI.prototype;
		__proto.createChildren=function(){
			laya.ui.Component.prototype.createChildren.call(this);
			this.createView(CompPanelUI.uiView);
		}

		__static(CompPanelUI,
		['uiView',function(){return this.uiView={"child":[{"type":"Image","props":{"skin":"view/bg_panel.png","y":"20","sizeGrid":"4,4,4,4","bottom":"0","left":"0","height":"31","var":"bg","top":"0","right":"0","x":"20"}},{"child":[{"type":"Button","props":{"skin":"comp/button.png","sizeGrid":"0,4,0,4","label":"label","labelColors":"#dddddd,#dddddd,#dddddd"}}],"type":"Box","props":{"x":"0","var":"groupBox","bottom":"2","left":"0","y":"0","top":"2","right":"0","mouseEnabled":"true"}}],"type":"DragView","props":{"height":"400","scenecolor":"#dddddd","title":"模板","width":"600"}};}
		]);
		return CompPanelUI;
	})(DragView)


	//class laya.editor.ui.TimeLinePanelUI extends laya.ide.ui.DragView
	var TimeLinePanelUI=(function(_super){
		function TimeLinePanelUI(){
			this.timeLine=null;
			this.mHScroll=null;
			this.mVScroll=null;
			this.aniSelect=null;
			this.addBtn=null;
			this.removeBtn=null;
			this.editMode=null;
			this.cloneBtn=null;
			this.frameRateTxt=null;
			this.loadedtip=null;
			this.action=null;
			this.frameTxt=null;
			this.timelineSizeControl=null;
			this.circlePlay=null;
			this.playControlBar=null;
			this.opMask=null;
			TimeLinePanelUI.__super.call(this);
		}

		__class(TimeLinePanelUI,'laya.editor.ui.TimeLinePanelUI',_super);
		var __proto=TimeLinePanelUI.prototype;
		__proto.createChildren=function(){
			View.viewClassMap["laya.editor.view.timeline.PlayControl"]=PlayControl;
			View.viewClassMap["laya.editor.view.timeline.TimeGrid"]=TimeGrid;
			laya.ui.Component.prototype.createChildren.call(this);
			this.createView(TimeLinePanelUI.uiView);
		}

		__static(TimeLinePanelUI,
		['uiView',function(){return this.uiView={"child":[{"type":"Image","props":{"skin":"view/bg_panel.png","y":"0","sizeGrid":"4,4,4,4","right":"0","width":"200","left":"0","height":"300","top":"0","bottom":"0","x":"0"}},{"type":"TimeGrid","props":{"runtime":"laya.editor.view.timeline.TimeGrid","y":"35","var":"timeLine","x":"203"}},{"type":"HScrollBar","props":{"skin":"comp/hscroll.png","y":"282","right":"5","width":"177","height":"13","var":"mHScroll","bottom":"5","x":"443"}},{"type":"VScrollBar","props":{"skin":"comp/vscroll.png","y":"15","var":"mVScroll","right":"-2","width":"13","height":"264","top":"30","bottom":"20","x":"582"}},{"child":[{"type":"Label","props":{"y":"4","color":"#c5c5c5","text":"动效：","x":"94"}},{"type":"ComboBox","props":{"skin":"comp/combo_22.png","var":"aniSelect","sizeGrid":"0,20,0,3","labels":"自定义模板,常用模板","scrollBarSkin":"comp/vscroll.png","width":"97","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5,#c5c5c5","height":"22","selectedIndex":"0","x":"129"}},{"type":"Button","props":{"skin":"play/btn_add.png","y":"1","toolTip":"添加","scaleX":"0.5","name":"sure","scaleY":"0.5","var":"addBtn","x":"233"}},{"type":"Button","props":{"skin":"play/btn_del.png","y":"1","toolTip":"删除","scaleX":"0.5","name":"sure","scaleY":"0.5","var":"removeBtn","x":"283"}},{"type":"CheckBox","props":{"skin":"comp/checkbox.png","y":"4","var":"editMode","label":" 动画编辑模式","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5,#c5c5c5"}},{"type":"Button","props":{"skin":"play/btn_clone.png","y":"1","toolTip":"复制","scaleX":"0.5","var":"cloneBtn","scaleY":"0.5","x":"258"}}],"type":"Box","props":{"y":"3","x":"7"}},{"type":"Image","props":{"skin":"comp/line.png","y":"26","width":"587","left":"5","height":"1","right":"5","x":"5"}},{"child":[{"type":"Label","props":{"y":"4","wordWrap":"false","text":"帧率：","align":"right","height":"20","color":"#c5c5c5"}},{"type":"TextInput","props":{"skin":"comp/input_22.png","var":"frameRateTxt","sizeGrid":"0,3,0,3","text":"24","width":"26","mouseEnabled":"true","restrict":"0-9","height":"22","color":"#c5c5c5","disabled":"true","x":"48"}},{"type":"Label","props":{"y":"4","wordWrap":"false","text":"加载后：","align":"right","height":"20","var":"loadedtip","color":"#c5c5c5","x":"140"}},{"type":"ComboBox","props":{"skin":"comp/combo_22.png","var":"action","sizeGrid":"0,20,0,3","labels":"不播放,播放一次,循环播放","width":"76","labelColors":"#c5c5c5,#c5c5c5,#c5c5c5,#c5c5c5","height":"24","y":"-2","selectedIndex":"0","x":"197"}},{"type":"Label","props":{"y":"4","wordWrap":"false","text":"帧：","align":"right","height":"20","color":"#c5c5c5","x":"76"}},{"type":"TextInput","props":{"skin":"comp/input_22.png","var":"frameTxt","sizeGrid":"0,3,0,3","text":"0","width":"26","mouseEnabled":"true","restrict":"0-9","height":"22","color":"#c5c5c5","x":"102"}}],"type":"HBox","props":{"y":"276","mouseEnabled":"true","left":"5","space":"5","bottom":"0","x":"2"}},{"type":"HSlider","props":{"value":"12","x":"370","bottom":"8","tick":"2","skin":"comp/hslider.png","y":"293","max":"20","width":"62","min":"6","height":"6","var":"timelineSizeControl","right":"190"}},{"type":"CheckBox","props":{"skin":"play/btn_replay.png","y":"33","toolTip":"循环","scaleX":"0.5","var":"circlePlay","scaleY":"0.5","x":"133"}},{"type":"PlayControl","props":{"var":"playControlBar","name":"playControl","y":"29","runtime":"laya.editor.view.timeline.PlayControl","x":"3"}},{"type":"Image","props":{"sizeGrid":"4,4,4,4","mouseEnabled":"true","top":"28","bottom":"2","x":"1","skin":"view/bg_panel.png","y":"28","width":"600","left":"2","height":"270","var":"opMask","right":"2"}}],"type":"DragView","props":{"minWidth":"400","title":"时间轴","width":"600","left":"0","hitTestPrior":"true","height":"300","scenecolor":"#dddddd","bottom":"0","right":"0"}};}
		]);
		return TimeLinePanelUI;
	})(DragView)


	//class laya.editor.ui.UIPanelUI extends laya.ide.ui.DragView
	var UIPanelUI=(function(_super){
		function UIPanelUI(){
			this.tab=null;
			UIPanelUI.__super.call(this);
		}

		__class(UIPanelUI,'laya.editor.ui.UIPanelUI',_super);
		var __proto=UIPanelUI.prototype;
		__proto.createChildren=function(){
			laya.ui.Component.prototype.createChildren.call(this);
			this.createView(UIPanelUI.uiView);
		}

		__static(UIPanelUI,
		['uiView',function(){return this.uiView={"child":[{"type":"Image","props":{"skin":"view/bg_panel_layoutrec.png","y":"0","sizeGrid":"0,3,0,3","width":"164","left":"0","height":"25","right":"0","x":"0"}},{"type":"Tab","props":{"skin":"comp/tab.png","y":"0","var":"tab","labelColors":"#aaaaaa,#aaaaaa,#aaaaaa","x":"0"}}],"type":"DragView","props":{"scenecolor":"#dddddd","hitTestPrior":"true","title":"UI"}};}
		]);
		return UIPanelUI;
	})(DragView)


	/**
	*...
	*@author ww
	*/
	//class laya.editor.view.group.ItemGroup extends laya.editor.ui.group.ItemGroupUI
	var ItemGroup=(function(_super){
		function ItemGroup(){
			this._itemBox=null;
			ItemGroup.__super.call(this);
			this.groupBox.removeChildren();
			this.groubBar.on("mousedown",this,this.onGroubBarClick);
			this.left=0;
			this.right=0;
			this.groupBox.left=0;
			this.groupBox.right=0;
			this.groupLabl.color=StyleConsts.FolderTxtColor;
		}

		__class(ItemGroup,'laya.editor.view.group.ItemGroup',_super);
		var __proto=ItemGroup.prototype;
		__proto.setData=function(name,itemBox){
			this._itemBox=itemBox;
			this.groupLabl.text=name;
			this.arrowClip.index=1;
			this.groupBox.removeChildren();
			this.groupBox.addChild(itemBox);
		}

		//
		__proto.onGroubBarClick=function(e){
			if (this.groupBox.parent){
				this.groupBox.removeSelf();
				this.arrowClip.index=0;
				}else {
				this.addChild(this.groupBox);
				this.arrowClip.index=1;
			}
			this.event("UIChange");
		}

		return ItemGroup;
	})(ItemGroupUI)


	/**
	*布局框
	*@author ww
	*/
	//class laya.editor.view.LayoutRec extends laya.editor.ui.LayoutRecUI
	var LayoutRec=(function(_super){
		function LayoutRec(){
			this.disList=null;
			this._dragBox=null;
			this._backHeight=NaN;
			this.preWidth=0;
			this.preHeight=0;
			this._curUI=null;
			this.tTabTxt=null;
			this.tTabHelpUrl=null;
			this.relativeO={};
			this._disMode=2;
			LayoutRec.__super.call(this);
			this.tab.on("change",this,this.onTabChange);
			this.back.on("mousedown",this,this.onBackDown);
			this.back.on("doubleclick",this,this.onBackDoubleDown);
			this.disList=[this.tab];
			this._backHeight=this.back.height;
			this.on("Draging_Hit",this,this._$7_onMouseOver);
			this.on("mouseover",this,this.onMouseOverThis);
			this.on("mouseout",this,this.onMouseOutThis);
			this.updateUIState();
			CanvasSprite.setSpriteCanvasRender(this);
			this.on("added",this,this._$7_onAdded);
			Notice.listen("SHOW_LayoutTab_By_Name",this,this.showTabByName);
			this.tipIcon.on("mousedown",this,this.onTipClick);
			this.tipIcon.toolTip=Sys.lang("点击打开帮助文档");
		}

		__class(LayoutRec,'laya.editor.view.LayoutRec',_super);
		var __proto=LayoutRec.prototype;
		__proto.onTipClick=function(){
			if(!this._curUI)return;
			var className;
			className=ClassTool.getClassName(this._curUI);
			var tUrl;
			tUrl=LayoutRec.PanelTips[className];
			if(tUrl){
				HelpTipView.endHelpTip();
				Browser.window.open(tUrl);
			}
		}

		__proto.getCurTipUrl=function(){
			if(!this._curUI)return null;
			var className;
			className=ClassTool.getClassName(this._curUI);
			var tUrl;
			tUrl=LayoutRec.PanelTips[className];
			return tUrl;
		}

		__proto.onMouseOutThis=function(){}
		// HelpTipView.hideTip();
		__proto._$7_onAdded=function(){
			if(this.parent==LayerManager.stage){
				CanvasSprite.setSpriteCanvasIndex(this,102);
			}
		}

		__proto.updateUIState=function(){
			this.back.visible=this.tab.visible=this.canAddTab;
		}

		__proto.onMouseOverThis=function(E){
			if(1||this.getCurTipUrl()){
				if(LayoutRec.preTipIcon)LayoutRec.preTipIcon.visible=false;
				LayoutRec.preTipIcon=this.tipIcon;
				this.tipIcon.visible=true;
				HelpTipView.showHelpTipTo(this.tipIcon);
			}
			if (this.parent==LayerManager.stage){
				DisResizer.setUp(this,true);
			}
		}

		__proto.onThisDown=function(e){
			if (this.parent==LayerManager.stage){
				DisResizer.setUp(this,true);
			}
		}

		__proto.onBackDown=function(e){
			if (this.parent==LayerManager.stage){
				this.startDrag();
				this.once("dragend",this,this.stopDrag);
				}else{
				this.startDragMe();
			}
		}

		__proto.onBackDoubleDown=function(e){
			if (this.parent !=LayerManager.stage){
				LayoutRecManager.popRec(this);
			}
			else{
			}
		}

		//DisResizer.setUp(this);
		__proto.goMinState=function(){
			DisControlTool.removeItems(this.disList);
		}

		//back.bottom=0;
		__proto.goMaxState=function(){
			DisControlTool.addItems(this.disList,this);
		}

		//Laya.timer.once(100,this,later);
		__proto.later=function(){
			this.back.height=this._backHeight;
		}

		__proto._$7_onMouseOver=function(e){
			if (!DragManager.isDraging)return;
			if (!(DragManager.getDragType()=="LayoutRec" || DragManager.getDragType()=="LayoutTab"))return;
			var type=RelativePos.getDisMouseRelativePos(this);
			if(DragManager.getDragTarget()==this){
				if(type=="up"){
					type="center";
				}
			}
			if(DragManager.getDragType()=="LayoutTab"){
				if(type=="up"){
					type="center";
				}
			};
			var focusWidth=NaN;
			switch (type){
				case "right":
				case "left":
					focusWidth=0.5*this.width;
					FocusManager.showBorder(this,type,true,null,focusWidth);
					break ;
				case "up":
				case "down":
					focusWidth=0.5*this.height;
					FocusManager.showBorder(this,type,true,null,focusWidth);
					break ;
				case "center":
					FocusManager.showFocus(this);
					break ;
				}
			DisControlTool.setTop(this);
		}

		__proto._$7_onMouseOut=function(e){}
		__proto.onDragDown=function(e){
			e.stopPropagation();
			this.startDragMe();
		}

		__proto.startDragMe=function(self){
			(self===void 0)&& (self=false);
			if(LayoutRecManager.popLocked())return;
			if(!this.canDragMe)return;
			var clip=new Clip(SkinDefines.LayoutRecDragIcon,1,3);
			clip.index=2;
			var type="LayoutRec";
			LayaBuilder.drag.doDrag(this,self?null:clip,{type:type,target:this},DragManager.dragOffset);
		}

		__proto.closeHandler=function(e){
			LayoutRecManager.removeRec(this);
		}

		__proto.changeSize=function(){
			laya.ui.Component.prototype.changeSize.call(this);
			if(this.tab){
				var rec;
				rec=this.tab.scrollRect||new Rectangle();
				rec.setTo(0,0,this.width,25);
				this.tab.scrollRect=rec;
			}
		}

		__proto.onTabChange=function(e){
			if (this._curUI){
				this._curUI.removeSelf();
				this._curUI=null;
			}
			if (this.tab.selectedIndex !=-1){
				this._curUI=(this.tab.selection).ui;
				this.addChildAt(this._curUI,0);
				this.tTabTxt=this._curUI["title"];
				this.tTabHelpUrl=this._curUI["helpUrl"];
				if((this._curUI instanceof laya.editor.view.UIPanel )){
					this.cacheAsBitmap=false;
					(this.tab.selection).cacheAsBitmap=false;
				}
			}
		}

		__proto.addUI=function(ui){
			var uiTab=new LayoutTab(ui);
			this.addTab(uiTab);
		}

		__proto.addTab=function(uiTab){
			var index=0;
			index=this.tab.addItem(uiTab);
			this.tab.selectedIndex=index;
			uiTab._rec=this;
			this.updateUIState();
		}

		__proto.removeTab=function(uiTab,autoRemove){
			(autoRemove===void 0)&& (autoRemove=false);
			this.tab.delItem(uiTab);
			uiTab._rec=null;
			this.updateUIState();
			if(autoRemove&&this.tab.items.length<1){
				LayoutRecManager.removeRec(this);
			}
		}

		// onTabChange(null);
		__proto.removeUI=function(ui,autoRemove){
			(autoRemove===void 0)&& (autoRemove=false);
			var tabList;
			tabList=this.tab.items;
			var i=0,len=0;
			len=tabList.length;
			for(i=0;i<len;i++){
				if(tabList[i].ui==ui){
					this.removeTab(tabList[i],autoRemove);
					return;
				}
			}
		}

		__proto.getUIs=function(){
			var i=0,len=0;
			var items;
			items=this.tab.items;
			len=items.length;
			var rst;
			rst=[];
			for (i=0;i < len;i++){
				rst.push((items [i]).ui);
			}
			return rst;
		}

		__proto.clearRelative=function(){
			RelativePos.clearBar(this);
		}

		__proto.showTabByName=function(tabName){
			if(this._curUI&&this._curUI["title"]==tabName)return;
			var tabList;
			tabList=this.tab.items;
			var i=0,len=0;
			len=tabList.length;
			for(i=0;i<len;i++){
				if(tabList[i].ui&&tabList[i].ui["title"]==tabName){
					this.tab.selectedIndex=i;
					return;
				}
			}
		}

		__proto.clears=function(){
			Notice.cancel("SHOW_LayoutTab_By_Name",this,this.showTabByName);
			this.clearRelative();
			this.tab.destroy();
			this.destroy(false);
			CanvasSprite.removeSpriteCanvas(this);
		}

		__getset(0,__proto,'disMode',function(){
			return this._disMode;
			},function(type){
			if (this._disMode !=1){
				this.preWidth=this.width;
				this.preHeight=this.height;
			}
			if (this._disMode==type)
				return;
			this._disMode=type;
			switch (this._disMode){
				case 1:
					this.goMinState();
					LayoutRecManager.minRec(this);
					this.back.off("mousedown",this,this.onBackDown);
					this.back.on("mousedown",this,this.onBackDown);
					break ;
				default :
					this.back.off("mousedown",this,this.onBackDown);
					this.goMaxState();
					LayoutRecManager.recoverRec(this);
				}
		});

		__getset(0,__proto,'canAddTab',function(){
			var tabList;
			tabList=this.tab.items;
			var i=0,len=0;
			len=tabList.length;
			for(i=0;i<len;i++){
				if(!tabList[i].canMix)return false;
			}
			return true;
		});

		__getset(0,__proto,'canClose',function(){
			var tabList;
			tabList=this.tab.items;
			var i=0,len=0;
			len=tabList.length;
			for(i=0;i<len;i++){
				if(!tabList[i].canClose)return false;
			}
			return true;
		});

		__getset(0,__proto,'hasFree',function(){
			var tabList;
			tabList=this.tab.items;
			var i=0,len=0;
			len=tabList.length;
			for(i=0;i<len;i++){
				if(tabList[i].freeSize)return true;
			}
			return false;
		});

		__getset(0,__proto,'canDragMe',function(){
			return this.canAddTab;
		});

		__getset(0,__proto,'sizeFree',function(){
			if(this.hasFree){
				return true;
			}
			return !this.canAddTab;
		});

		LayoutRec.Min=1;
		LayoutRec.Normal=2;
		LayoutRec.Max=3;
		LayoutRec.preTipIcon=null
		__static(LayoutRec,
		['PanelTips',function(){return this.PanelTips={
				"PagePanel":"http://ldc.layabox.com/doc/?nav=ch-as-2-1-4",
				"BasicPanel":"http://ldc.layabox.com/doc/?nav=ch-as-2-1-12",
				"ResPanel":"http://ldc.layabox.com/doc/?nav=ch-as-2-1-5",
				"CompPanel":"http://ldc.layabox.com/doc/?nav=ch-as-2-1-7",
				"DisplayTreePanel":"http://ldc.layabox.com/doc/?nav=ch-as-2-1-11",
				"TimeLinePanel":"http://ldc.layabox.com/doc/?nav=ch-as-2-2-2",
				"FramePropPanel":"http://ldc.layabox.com/doc/?nav=ch-as-2-2-2",
				"UIPanel":"http://ldc.layabox.com/doc/?nav=ch-as-2-1-8",
				"PropPanel":"http://ldc.layabox.com/doc/?nav=ch-as-2-1-9"
		};}

		]);
		return LayoutRec;
	})(LayoutRecUI)


	/**菜单
	*@author yung
	*/
	//class laya.editor.view.MenuBar extends laya.editor.ui.MenuBarUI
	var MenuBar=(function(_super){
		function MenuBar(){
			this._isMax=false;
			this._menuMap={};
			this._menuContexts={
				item0:[ "转换项目","","设置项目(F9)"],
				item1:["新建目录(Ctrl+D)","新建文件(Ctrl+N)","","设置页面(Ctrl+P)","资源转换工具","图集打包工具"],
				item2:["撤销(Ctrl+Z)","重做(Ctrl+Y)","","删除(Delete)","复制(Ctrl+C)","粘贴(Ctrl+V)","原位粘贴(Ctrl+Shift+V)","剪贴(Ctrl+X)","全选(Ctrl+A)","","移动组件(方向键)","快速移动(Ctrl+方向键)","","转换为容器(Ctrl+B)","移除容器(Ctrl+U)","重复复制(Ctrl+R)","定位资源(Ctrl+K)","","查找替换(Ctrl+F)","保存文件(Ctrl+S)","保存所有文件(Ctrl+Shift+S)"],
				item3:["放大视图(Ctrl++)","缩小视图(Ctrl+-)","恢复视图(Ctrl+|)","","拖动视图(鼠标右键)","显示/隐藏参考视图(F8)","显示/隐藏标尺(Ctrl+Shift+R)","","节点向上(Ctrl+↑)","节点向下(Ctrl+↓)"],
				item4:["项目面板","资源面板","属性面板","层级面板","模板面板","","恢复面板位置(F3)"],
				item5:["发布(F12)","清理并发布(Ctrl+F12)","正式发布(不打包未使用资源)(F11)","","刷新资源及页面(F5)","刷新页面(F6)","刷新资源(F7)","","查找未被使用的资源(F4)"],
				item6:[],
				item7:["关于","帮助"]
			};
			MenuBar.__super.call(this);
			Laya.stage.on("click",this,this.onStageClick);
			this.tab.on("mousedown",this,this.onTabMouseDown);
			this.tab.on("click",this,this.onTabClick);
			this.tab.on("change",this,this.onTabChange);
			this.on("mousedown",this,this.onMouseDown);
			this.on("doubleclick",this,this.onDoubleClick);
			this.minBtn.on("click",this,this.onMinBtnClick);
			this.backBtn.on("click",this,this.onBackBtnClick);
			this.closeBtn.on("click",this,this.onCloseBtnClick);
			this.switchBtn.on("click",this,this.onSwitchBtnDown);
			var img=new Image();
			img.skin="view/editmode.png";
			img.pos(1,6);
			this.switchBtn.addChild(img);
			this.switchBtn.labelPadding="0,0,0,8";
			var btns;
			btns=this.tab.items;
			var i=0,len=0;
			len=btns.length;
			for(i=0;i<len;i++){
				(btns [i]).labelColors=StyleConsts.MenuButtonLabelColor;
			}
			this.cacheAsBitmap=IDEConsts.cachePanels;;
		}

		__class(MenuBar,'laya.editor.view.MenuBar',_super);
		var __proto=MenuBar.prototype;
		__proto.onSwitchBtnDown=function(e){
			if(Browser.window["changeLayaIDECodeMode"]){
				Browser.window["changeLayaIDECodeMode"]();
			}
		}

		__proto.onTabMouseDown=function(e){
			if (e.target==this.tab.selection){
				this.tab.selectedIndex=-1;
			}
		}

		__proto.onCloseBtnClick=function(e){
			Device.winFun("close");
		}

		//stage.nativeWindow.dispatchEvent(new Event(Event.CLOSING));
		__proto.onBackBtnClick=function(e){
			if (this._isMax){
				Device.winFun("unmaximize");
			}
			else{
				Device.winFun("maximize");
			}
			this._isMax=!this._isMax;
		}

		__proto.onMinBtnClick=function(e){
			Device.winFun("minimize");
		}

		//stage.nativeWindow.minimize();
		__proto.onDoubleClick=function(e){
			var target=e.target;
			if (!target.parent==this.tab && !target.parent==this.btnBox){
				this.onBackBtnClick(null);
			}
		}

		__proto.onMouseDown=function(e){
			return;
			var target=e.target;
		}

		// }
		__proto.onStageMouseUp=function(e){
			this.off("mousemove",this,this.onMouseMove);
			this.off("mousemove",this,this.onStageMouseUp);
		}

		__proto.onMouseMove=function(e){
			this.off("mousemove",this,this.onMouseMove);
			this.off("mousemove",this,this.onStageMouseUp);
			this.onBackBtnClick(null);
		}

		__proto.onTabChange=function(e){
			if (this.tab.selectedIndex !=-1){
				this.showMenu(this.tab.selection);
			}
		}

		__proto.onTabClick=function(e){
			e.stopPropagation();
		}

		__proto.onStageClick=function(e){
			this.tab.selectedIndex=-1;
		}

		__proto.showMenu=function(btn){
			var type=btn.name;
			var menu=this._menuMap[type];
			if (menu==null){
				menu=ContextMenu.createMenuByArray(this._menuContexts[type]);
				menu.on("select",this,this.onEmunSelect);
				this._menuMap[type]=menu;
			};
			var p=btn.localToGlobal(new Point());
			menu.show(p.x,p.y+btn.height);
		}

		/**处理菜单选择*/
		__proto.onEmunSelect=function(e){
			var data=(e.target).data;
			if ((typeof data=='string')){
				var name=data;
				switch (name){
					case "新建项目":
						break ;
					case "设置项目(F9)":
						ShortcutManager.exeKey(120);
						break ;
					case "转换项目":
						ConvertProject.instance.start();
						break ;
					case "打开项目(Ctrl+O)":
						ShortcutManager.exeKey(79,true);
						break ;
					case "打开项目所在目录":
						ProjectManager.openProjectDir();
						break ;
					case "新建文件(Ctrl+N)":
						ShortcutManager.exeKey(78,true);
						break ;
					case "新建粒子":
						Notice.notify("open_AddParticle");
						return;
						break ;
					case "新建场景":
						Notice.notify("OPEN_ADDSCENE");
						return;
						break ;
					case "新建时间轴动画":
						Notice.notify("OPEN_ADD_TIMELINE_ANIMATION");
						return;
						break ;
					case "新建目录(Ctrl+D)":
						ShortcutManager.exeKey(68,true);
						break ;
					case "设置页面(Ctrl+P)":
						ShortcutManager.exeKey(80,true);
						break ;
					case "保存页面(Ctrl+S)":
						ShortcutManager.exeKey(83,true);
						break ;
					case "保存所有页面(Ctrl+Shift+S)":
						ShortcutManager.exeKey(83,true,true);
						break ;
					case "放大视图(Ctrl++)":
						ShortcutManager.exeKey(187,true);
						break ;
					case "缩小视图(Ctrl+-)":
						ShortcutManager.exeKey(189,true);
						break ;
					case "恢复视图(Ctrl+|)":
						ShortcutManager.exeKey(220,true);
						break ;
					case "显示/隐藏参考视图(F8)":
						ShortcutManager.exeKey(119);
						break ;
					case "显示/隐藏标尺(Ctrl+Shift+R)":
						ShortcutManager.exeKey(82,true,true);
						IDEEvent.emitKeyEvent(82,true,true);
						break ;
					case "预览视图(Ctrl+Enter)":
						ShortcutManager.exeKey(13,true);
						break ;
					case "撤销(Ctrl+Z)":
						ShortcutManager.exeKey(90,true);
						break ;
					case "重做(Ctrl+Y)":
						ShortcutManager.exeKey(89,true);
						break ;
					case "复制(Ctrl+C)":
						ShortcutManager.exeKey(67,true);
						break ;
					case "粘贴(Ctrl+V)":
						ShortcutManager.exeKey(86,true);
						break ;
					case "原位粘贴(Ctrl+Shift+V)":
						ShortcutManager.exeKey(86,true,true);
						break ;
					case "剪贴(Ctrl+X)":
						ShortcutManager.exeKey(88,true);
						break ;
					case "全选(Ctrl+A)":
						ShortcutManager.exeKey(65,true);
						break ;
					case "转换为容器(Ctrl+B)":
						ShortcutManager.exeKey(66,true);
						break ;
					case "移除容器(Ctrl+U)":
						ShortcutManager.exeKey(85,true);
						break ;
					case "重复复制(Ctrl+R)":
						ShortcutManager.exeKey(82,true);
						break ;
					case "查找替换(Ctrl+F)":
						ShortcutManager.exeKey(70,true);
						break ;
					case "向上(Ctrl+↑)":
						ShortcutManager.exeKey(38,true);
						IDEEvent.emitKeyEvent(38,true);
						break ;
					case "向下(Ctrl+↓)":
						ShortcutManager.exeKey(40,true);
						IDEEvent.emitKeyEvent(40,true);
						break ;
					case "到上一层(Ctrl+→)":
						ShortcutManager.exeKey(39,true);
						break ;
					case "到下一层(Ctrl+←)":
						ShortcutManager.exeKey(37,true);
						break ;
					case "刷新资源及页面(F5)":
						ShortcutManager.exeKey(116);
						break ;
					case "刷新页面(F6)":
						ShortcutManager.exeKey(117);
						break ;
					case "刷新资源(F7)":
						ShortcutManager.exeKey(118);
						break ;
					case "查找未被使用的资源(F4)":
						ShortcutManager.exeKey(115);
						break ;
					case "发布(F12)":
						ShortcutManager.exeKey(123);
						break ;
					case "清理并发布(Ctrl+F12)":
						ShortcutManager.exeKey(123,true);
						break ;
					case "正式发布(不打包未使用资源)(F11)":
						ShortcutManager.exeKey(122);
						break ;
					case "编辑器设置(F10)":
						ShortcutManager.exeKey(121);
						break ;
					case "恢复面板位置(F3)":
						ShortcutManager.exeKey(114);
						break ;
					case "显示/隐藏日志(Ctrl+L)":
						ShortcutManager.exeKey(76,true);
						break ;
					case "扩展(F1)":
						break ;
					case "关于":
						break ;
					case "帮助":
						Help.instance.start();
						break ;
					case "项目面板":
						LayoutRecManager.showPanelByClassName("PagePanel");
						break ;
					case "资源面板":
						LayoutRecManager.showPanelByClassName("ResPanel");
						break ;
					case "模板面板":
						LayoutRecManager.showPanelByClassName("CompPanel");
						break ;
					case "属性面板":
						LayoutRecManager.showPanelByClassName("PropPanel");
						break ;
					case "层级面板":
						LayoutRecManager.showPanelByClassName("DisplayTreePanel");
						break ;
					case "时间轴":
						LayoutRecManager.showPanelByClassName("TimeLinePanel");
						break ;
					case "资源转换工具":
						CMDShell.exeFile(FileManager.getAppPath("libs/LayaAirTool/LayaAirTool"),null,null);
						break ;
					case "图集打包工具":
						break ;
					case "定位资源(Ctrl+K)":
						IDEEvent.emitKeyEvent(75,true,false);
						break ;
					}
			}
			else{
				if (data.key=="project"){
					ProjectManager.openProjectByPath(data.label);
				}
			}
			this.tab.selectedIndex=-1;
		}

		/**添加插件菜单*/
		__proto.addPluginMenu=function(name){
			var menus=this._menuContexts["item7"];
			if (menus.length > 0){
				menus.push("");
			}
			menus.push({label:name,key:"plugin"});
			this._menuMap["item7"]=null;
		}

		/**显示最近打开的项目*/
		__proto.showProjectOpened=function(projects){
			return;
			var menus=this._menuContexts["item0"];
			if (menus.length > 5){
				menus.length=5;
			}
			menus.push("");
			for (var i=0;i < projects.length && i < 5;i++){
				menus.push({label:projects[i],key:"project"});
			}
			this._menuMap["item0"]=null;
		}

		__getset(1,MenuBar,'instance',function(){
			return MenuBar._instance ? MenuBar._instance :MenuBar._instance=new MenuBar();
		},laya.editor.ui.MenuBarUI._$SET_instance);

		MenuBar.registButton=function(id,title,notice){
			var registFun=Browser.window["addMenuListItem"];
			if(registFun!=null){
				registFun(id,title,notice);
			}
		}

		MenuBar._instance=null
		return MenuBar;
	})(MenuBarUI)


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2017-5-15 上午10:48:09
	*/
	//class laya.editor.view.other.HelpTipView extends laya.editor.ui.other.HelpTipUI
	var HelpTipView=(function(_super){
		function HelpTipView(){
			HelpTipView.__super.call(this);
			this.tipTxt.text=Sys.lang("点击这里查看帮助");
			this.closeBtn.on("click",this,HelpTipView.endHelpTip);
		}

		__class(HelpTipView,'laya.editor.view.other.HelpTipView',_super);
		__getset(1,HelpTipView,'I',function(){
			if(!HelpTipView._I)HelpTipView._I=new HelpTipView();
			return HelpTipView._I;
		},laya.editor.ui.other.HelpTipUI._$SET_I);

		HelpTipView.endHelpTip=function(){
			HelpTipView.isFirst=false;
			HelpTipView.hideTip();
		}

		HelpTipView.showHelpTipTo=function(tar){
			if(!HelpTipView.isFirst)return;
			if(!tar.parent)return;
			Laya._currentStage.addChild(HelpTipView.I);
			tar.localToGlobal(HelpTipView._point.setTo(0,0));
			HelpTipView.I.pos(HelpTipView._point.x-HelpTipView.I.width*HelpTipView.I.scaleX+40,HelpTipView._point.y-HelpTipView.I.height*HelpTipView.I.scaleY+3);
			tar.repaint();
		}

		HelpTipView.hideTip=function(){
			HelpTipView.I.removeSelf();
		}

		HelpTipView._I=null
		HelpTipView.isFirst=false;
		__static(HelpTipView,
		['_point',function(){return this._point=new Point();}
		]);
		return HelpTipView;
	})(HelpTipUI)


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2017-5-15 下午3:25:10
	*/
	//class laya.editor.view.other.ResTypeSettingView extends laya.editor.ui.other.ResTypeSettingViewUI
	var ResTypeSettingView=(function(_super){
		function ResTypeSettingView(){
			ResTypeSettingView.__super.call(this);
			this.typeList.renderHandler=Handler.create(this,this.itemRender,null,false);
			this.okBtn.on("click",this,this.onOkBtn);
		}

		__class(ResTypeSettingView,'laya.editor.view.other.ResTypeSettingView',_super);
		var __proto=ResTypeSettingView.prototype;
		__proto.onOkBtn=function(){
			var datas;
			datas=this.typeList.array;
			if(!datas)return;
			var i=0,len=0;
			len=datas.length;
			var typeDic;
			typeDic={};
			var type;
			var res;
			var tData;
			for(i=0;i<len;i++){
				tData=datas[i];
				res=tData.res;
				if(res){
					if(res!=UIConfigManager.getCompResStr(tData.type))
						typeDic[tData.type]=res;
				}
			}
			IDESettingResTypeManager.typeDic=typeDic;
			IDESettingResTypeManager.updateTypeDic();
			IDESettingResTypeManager.saveConfig();
			ResPanel.instance.refreshProp();
			Notice.notify("FRESH_CurView");
			Notice.notify("CLOSE_IDESETTING");
		}

		__proto.reset=function(){
			var names;
			names=BasicPanel.getUIItems();
			var items;
			items=[];
			names.sort(MathUtil.sortSmallFirst);
			var i=0,len=0;
			len=names.length;
			var tItem;
			for(i=0;i<len;i++){
				tItem={};
				tItem.type=names[i];
				tItem.res=IDESettingResTypeManager.getTypeRes(names[i]);
				if(!tItem.res){
					tItem.res=UIConfigManager.getCompResStr(names[i]);
				}
				items.push(tItem);
			}
			this.typeList.array=items;
		}

		__proto.itemRender=function(cell,index){
			var item=cell.dataSource;
			var label;
			label=cell.getChildByName("nameTxt");
			var input;
			input=cell.getChildByName("inputTxt");
			label.text=item.type;
			input.text=item.res?item.res:"";
			input.on("blur",this,this.onInputChange,[input,item]);
			input.on("enter",this,this.onInputChange,[input,item]);
		}

		__proto.onInputChange=function(input,data){
			data.res=input.text;
		}

		return ResTypeSettingView;
	})(ResTypeSettingViewUI)


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-12-15 上午10:50:52
	*/
	//class laya.editor.view.page.AddAnimation extends laya.editor.ui.page.AddGraphicAniUI
	var AddAnimation=(function(_super){
		function AddAnimation(){
			AddAnimation.__super.call(this);
			this.typeDrop.labels="GraphicAnimation"+","+"EffectAnimation";
			this.nameTxt.restrict=StyleConsts.fileNameRestrict;
			this.widthTxt.restrict="0-9";
			this.heightTxt.restrict="0-9";
			this.typetip.text=Sys.lang("动画类型：");
			this.nametip.text=Sys.lang("动画名称：");
			this.widthTip.text=Sys.lang("动画宽度：");
			this.heightTip.text=Sys.lang("动画高度：");
			this.typeDrop.selectedIndex=0;
		}

		__class(AddAnimation,'laya.editor.view.page.AddAnimation',_super);
		var __proto=AddAnimation.prototype;
		__proto.initListener=function(){}
		// Notice.listen(IDEEvent.OPEN_ADD_TIMELINE_ANIMATION,this,start);
		__proto.onSelectBtnClick=function(e){
			DialogTools.showOpenFile(Sys.lang("请选择视图参考图片"),Utils$1.bind(this.onSelected,this),DialogTools.imgFilterO);
		}

		__proto.onSelected=function(files){}
		__proto.reset=function(){
			this.bgColorPicker.selectedColor="#F00000";
			this.bgColorPicker.selectedColor="#000000";
			this.nameTxt.text="";
			this.widthTxt.text="600";
			this.heightTxt.text="400";
			IDEConfigsManager.I.insertDefaultValue(this,AddAnimation.ConfigO);
		}

		__proto.start=function(){}
		__proto.check=function(){
			if (!Boolean(this.nameTxt.text)){
				Alert.show(Sys.lang("动画名称不能为空"));
				return false;
			}
			Notice.notify("ADDTimeLineAnimation",[this.typeDrop.selectedLabel,this.nameTxt.text,"",LayaBuilder.mParseInt(this.widthTxt.text),LayaBuilder.mParseInt(this.heightTxt.text),this.bgColorPicker.selectedColor,true,true]);
			Notice.notify("Focus_design");
			IDEConfigsManager.I.saveDefaultValue(this,AddAnimation.ConfigO);
			return true;
		}

		__getset(1,AddAnimation,'instance',function(){
			return AddAnimation._instance ? AddAnimation._instance :AddAnimation._instance=new AddAnimation();
		},laya.editor.ui.page.AddGraphicAniUI._$SET_instance);

		AddAnimation._instance=null
		AddAnimation.GraphicAnimation="GraphicAnimation";
		AddAnimation.MoveEffectAnimation="EffectAnimation";
		__static(AddAnimation,
		['ConfigO',function(){return this.ConfigO={
				"sign":"AddAnimation",
				"vars":["widthTxt","heightTxt"]
		};}

		]);
		return AddAnimation;
	})(AddGraphicAniUI)


	/**UI视图
	*@author yung
	*/
	//class laya.editor.view.UIViewer extends laya.editor.ui.UIViewerUI
	var UIViewer=(function(_super){
		function UIViewer(){
			this._design=null;
			this._title=null;
			this._uiName=null;
			this._pagePath=null;
			this._lastSelectXml=null;
			this.ruleSideLen=2;
			this.iFrameCodeView=null;
			this.isUserChanged=false;
			this._gridPoints=[new Point(),new Point()];
			this.preXmlStr=null;
			this.preReferrence=null;
			UIViewer.__super.call(this);
			this._ruleH=new RuleGrid();
			this._ruleV=new RuleGrid();
			this._ruleRangeLayer=new Sprite();
			this._referenceLayer=new ReferenceLineLayer();
			this.initPanel();
			this.myResize();
			this.on("resize",this,this.myResize);
		}

		__class(UIViewer,'laya.editor.view.UIViewer',_super);
		var __proto=UIViewer.prototype;
		__proto.myResize=function(){
			if(this.width<480){
				this.typeBtn.visible=this.scaleInfo.visible=false;
				}else{
				this.typeBtn.visible=this.scaleInfo.visible=true;
			}
		}

		__proto.initPanel=function(){
			if(UIViewer.EnableXMLEditor){
				this.iFrameCodeView=new XMLEditorSprite();
				this.viewStack.items[1]=this.iFrameCodeView;
				this.iFrameCodeView.top=this.iFrameCodeView.bottom=this.iFrameCodeView.left=0;
				this.iFrameCodeView.right=0;
				this.iFrameCodeView.bottom=0;
				var carr;
				carr=[this.viewStack.items[0],this.iFrameCodeView];
				this.viewStack.setItems(carr);
			}
			this.viewStack.on("resize",this,this.onResize);
			this.on("mousedown",this,this.onMouseDown);
			this.on("dragDrop",this,this.onDragDrop);
			this.createDesign();
			this.designView.on("rightmousedown",this,this.onDesignRightMouseDown);
			this.designView.addChild(this._design);
			this.typeBtn.index=1;
			this.typeBtn.on("click",this,this.typeBtnClick);
			this.addChild(this._ruleH);
			this._ruleH.y=this.designView.y-0;
			this._ruleH.type=0;
			this._ruleH.x=this.ruleSideLen;
			this.addChild(this._ruleV);
			this._ruleV.y=this._ruleH.y+5;
			this._ruleV.type=1;
			this._ruleV.x=this.ruleSideLen;
			this._ruleRangeLayer.mouseEnabled=false;
			this.addChild(this._ruleRangeLayer);
			this._referenceLayer._ruleH=this._ruleH;
			this._referenceLayer._ruleV=this._ruleV;
			this.addChild(this._referenceLayer);
			this._design.referenceLayer=this._referenceLayer;
			this.onResize(null);
			this.on("display",this,this.addListens);
			this.on("undisplay",this,this.removeListens);
			this.compInfo.color=this.scaleInfo.color=StyleConsts.SelectItemInfoColor;
			this.setScaleInfo(1);
			this.addChild(this.typeBtn);
			this.codeView.wordWrap=true;
			Notice.listen("RULE_SHOW_CHANGE",this,this.freshRule,null,true);
			this._ruleH.on("Add_ReferenceLine",this,this.onAddReferenceLine,[this._ruleV]);
			this._ruleV.on("Add_ReferenceLine",this,this.onAddReferenceLine,[this._ruleH]);
			this._referenceLayer.on("Lines_Changed",this,this.onReferenceLineChange);
		}

		__proto.onReferenceLineChange=function(){
			this._design.changeReferenceLine(this._referenceLayer.lineList);
		}

		__proto.onAddReferenceLine=function(rule){
			this._referenceLayer.addLineAndStartDrag(rule.type,rule.getMouseValue());
		}

		__proto.createDesign=function(){
			if(IDEVars.cacheBothTreeAndAnimation){
				this._design=new AnimationDesignBothCache();
				}else{
				this._design=new AnimationDesign();
			}
		}

		__proto.typeBtnClick=function(e){
			this.typeBtn.index=1-this.typeBtn.index;
			this.onTabSelect(1-this.typeBtn.index);
		}

		__proto.addListens=function(){
			Notice.listen("SHOW_RULE_RANGE",this,this.showRuleRange,null,true);
			Notice.listen("Clear_RULE_RANGE",this,this.clearRuleRange,null,true);
			Notice.listen("Add_node_byDragDrop",this,this.onDragDrop,null,true);
		}

		__proto.removeListens=function(){
			Notice.cancel("SHOW_RULE_RANGE",this,this.showRuleRange);
			Notice.cancel("Clear_RULE_RANGE",this,this.clearRuleRange);
			Notice.cancel("Add_node_byDragDrop",this,this.onDragDrop);
		}

		__proto.clears=function(){
			Notice.cancel("RULE_SHOW_CHANGE",this,this.freshRule);
		}

		__proto.clearRuleRange=function(){
			this._ruleRangeLayer.graphics.clear();
		}

		__proto.showRuleRange=function(pointList){
			if(!SystemSetting.ifShowRuleGrid){
				this.clearRuleRange();
				return;
			};
			var i=0,len=0;
			var tPoint;
			len=pointList.length;
			for(i=0;i<len;i++){
				tPoint=pointList[i];
				tPoint=this.globalToLocal(tPoint);
			};
			var g;
			g=this._ruleRangeLayer.graphics;
			g.clear();
			var sY=NaN;
			sY=this._ruleH.y;
			g.drawLine(pointList[0].x,sY,pointList[0].x,sY+20,StyleConsts.RuleRangeColor,1);
			g.drawLine(pointList[1].x,sY,pointList[1].x,sY+20,StyleConsts.RuleRangeColor,1);
			var sX=NaN;
			sX=this._ruleV.x;
			g.drawLine(sX,pointList[0].y,sX+20,pointList[0].y,StyleConsts.RuleRangeColor,1);
			g.drawLine(sX,pointList[1].y,sX+20,pointList[1].y,StyleConsts.RuleRangeColor,1);
		}

		__proto.switchRuleGrid=function(){
			SystemSetting.ifShowRuleGrid=!SystemSetting.ifShowRuleGrid;
			Notice.notify("RULE_SHOW_CHANGE");
		}

		// freshRule();
		__proto.dealAction=function(funName,param){
			if ((typeof (this[funName])=='function')){
				this[funName].apply(this,param);
			}else
			if(this.design){
				this.design.dealAction(funName,param);
			}
		}

		__proto.onMouseDown=function(event){
			if (this.viewStack.selectedIndex==0){
				this._lastSelectXml=this._design.selectedCompXml;
				Laya.stage.focus=this._design;
				if(event.target!=this.typeBtn)
					this._design.event("mousedown",event);
			}
		}

		__proto.onActive=function(){
			this._design.onActive();
		}

		__proto.onAddedToStage=function(e){
			this.showAndHidePanels();
		}

		__proto.onDesignRightMouseUp=function(e){
			this._design.stopDrag();
			this.freshRule();
			CursorManager.setType("default");
		}

		__proto.onDesignRightMouseDown=function(e){
			this._design.startDrag();
			CursorManager.setType("all-scroll");
			this.isUserChanged=true;
			Laya.stage.once("rightmouseup",this,this.onDesignRightMouseUp);
		}

		__proto.onResize=function(e){
			if(this.designView.width<0){
				Laya.timer.frameOnce(1,this,this.onResize);
				return;
			}
			this.designView.scrollRect=new Rectangle(0,0,this.designView.width,this.designView.height);
			if(this.isUserChanged)return;
			switch(this._design.pageType){
				case "graphic_animation":
				case "MoveEffect":
					this._design.x=Math.floor((this.designView.width-this._design.width*0)*0.5);
					this._design.y=Math.floor((this.designView.height-this._design.height*0)*0.5);
					break ;
				case "Prefab":
					this._design.x=Math.floor((this.designView.width-this._design.width*0)*0.5);
					this._design.y=Math.floor((this.designView.height-this._design.height*0)*0.5);
					break ;
				case "prefab_ui":
					this._design.x=Math.floor((this.designView.width-this._design.width*0)*0.5);
					this._design.y=Math.floor((this.designView.height-this._design.height*0)*0.5);
					break ;
				default :
					this._design.x=Math.floor((this.designView.width-this._design.width)*0.5);
					this._design.y=Math.floor((this.designView.height-this._design.height)*0.5);
				}
			this.freshRule();
		}

		__proto.freshRule=function(){
			this.clearRuleRange();
			if(!SystemSetting.ifShowRuleGrid){
				this._ruleH.clearMe();
				this._ruleV.clearMe();
				this._referenceLayer.clearMe();
				this._referenceLayer.visible=false;
				return;
			}
			this._referenceLayer.visible=true;
			this._ruleV.height=this.height-40;
			this._gridPoints[0].setTo(this._ruleH.x,this._ruleV.y);
			this._gridPoints[1].setTo(this.width+this._ruleH.x,this._ruleV.height+this._ruleV.y);
			var i=0,len=0;
			var tPoint;
			for(i=0;i<2;i++){
				tPoint=this._gridPoints[i];
				tPoint=this.localToGlobal(tPoint);
				tPoint=this._design.globalToLocal(tPoint);
			}
			this._ruleH.width=this.width;
			var ruleWidth=30;
			this._ruleH.setBounds(new Rectangle(0,0,this._ruleH.width,ruleWidth));
			this._ruleH.renderMe(this.width,this._gridPoints[0].x,this._gridPoints[1].x);
			this._ruleV.setBounds(new Rectangle(0,0,ruleWidth,this._ruleV.height));
			this._ruleV.cacheAsBitmap=false;
			this._ruleV.renderMe(this._ruleV.height,this._gridPoints[0].y,this._gridPoints[1].y);
			this._ruleV.cacheAsBitmap=true;
			this._referenceLayer.lineList=this._design.getReferenceLines()||[];
			this._referenceLayer.renderMe(this.width,this.height-35);
		}

		/**根据页面地址加载页面*/
		__proto.loadPage=function(path){
			try {
				var con=FileManager.readTxtFile(path);
				var uiView=JSON.parse(con);
				if(this._design.pageType=="page"){
					if(TypeManager.isPreFabNodeType(uiView.type)){
						this._design.pageType="prefab_ui";
					}
				}
				this._design.init(uiView);
				}catch (e){
				Alert.show(Sys.lang("读取视图({0})出错\n{1}" ,path,e.toString()),Sys.lang("读取视图出错"));
				var xml;
				xml={
					type:"View",
					child:[],
					props:{}
				};
				this._design.init(xml);
				return;
			}
		}

		__proto.setScaleInfo=function(value){
			this.scaleInfo.text=Sys.lang("当前缩放：")+Math.floor(value*100)+"%";
		}

		/**保存*/
		__proto.save=function(){
			if (this.typeBtn.index==1){
				if (this._design.hasChange){
					var dataO;
					if(this._design.isAnimationMode){
						dataO=this._design.uiXmlRestored;
						}else{
						dataO=this._design.xml;
					}
					if(this._design.animation){
						dataO.animations=AnimationDataWorker.cleanAnimationData(this._design.animation.animations,true);
					}
					PagePanel.instance.save(this._pagePath,dataO);
					delete dataO.animations;
					this._design.hasChange=false;
					MessageManager.instance.show(Sys.lang("保存成功"));
					Laya.stage.event("pageSaved");
					if(TypeManager.getFileType(this._pagePath)=="Prefab"){
						PreFabManager.I.prefabFileChange(this._pagePath);
					}
				}
				}else {
				Alert.instance.start(Sys.lang("请先切换到设计模式后再保存"),Sys.lang("保存出错"));
			}
		}

		__proto.getDesignData=function(){
			var dataO;
			if(this._design.isAnimationMode){
				dataO=this._design.uiXmlRestored;
				}else{
				dataO=this._design.xml;
			}
			if(this._design.animation){
				dataO.animations=AnimationDataWorker.cleanAnimationData(this._design.animation.animations,true);
			}
			return dataO;
		}

		__proto.changeDataO=function(dataO){
			if(this._design.animation){
				this._design.animation.animations=dataO.animations;
			}
			this._design.changeFromRepalce(dataO,true);
		}

		/**容器线框动画*/
		__proto.playBoxEffect=function(gx,gy,isBack){
			(isBack===void 0)&& (isBack=false);
			var point=this.localToGlobal(new Point(0,0));
			var effect=new BoxEffect();
			Laya._currentStage.addChild(effect);
			effect.play(gx,gy,new Rectangle(point.x,point.y,this.designView.width,this.designView.height),isBack);
		}

		/**处理资源或页面拖入*/
		__proto.onDragDrop=function(e,x,y,parentId,index){
			(x===void 0)&& (x=-1);
			(y===void 0)&& (y=-1);
			(parentId===void 0)&& (parentId=-1);
			(index===void 0)&& (index=-1);
			if(!this._design.canAddComp){
				Alert.show(Sys.lang("动画编辑模式中，该功能不可用。"));
				return;
			}
			switch(e.data.type){
				case "res":
				case "page":
					this._design.addCompWork(this._design.getAddDataByDragEvent(e),x,y,parentId,false,index);
					break ;
				case "template":
					this._design.addTemplate(e.data.data.path,x,y,parentId);
					break ;
				}
		}

		__proto.showAndHidePanels=function(){}
		//}
		__proto.findSelecteStrPos=function(xmlStr,compID){
			if(compID<1)return null;
			var pos=0;
			pos=xmlStr.indexOf("compId="+compID+"\"");
			if(pos<0)return null;
			var posBegin=0;
			posBegin=xmlStr.lastIndexOf("<",pos);
			var i=0;
			var compType;
			var posEnd=0;
			compType="";
			for(i=posBegin+1;i<xmlStr.length;i++){
				if(xmlStr.charAt(i)==" ")break ;
				compType+=xmlStr.charAt(i);
			};
			var iCount=0;
			iCount=1;
			var tStr;
			var isFirst=true;
			for(i=pos;i<xmlStr.length;i++){
				if(xmlStr.charAt(i)==">"){
					iCount--;
					if(xmlStr.charAt(i-1)=="/"&& isFirst){
						if(iCount==0){
							console.log("posOk");
							posEnd=i+1;
							break ;
						}
					};
					tStr=xmlStr.substr(i-compType.length,compType.length);
					if(tStr==compType&&iCount==0){
						console.log("posOk");
						posEnd=i+1;
						break ;
					}
					isFirst=false;
				}
				if(xmlStr.charAt(i)=="<")iCount++;
			}
			return xmlStr.substring(posBegin,posEnd);
		}

		/**切换设计和代码视图*/
		__proto.onTabSelect=function(index){
			this.viewStack.selectedIndex=index;
			this._referenceLayer.visible=this._ruleH.visible=this._ruleV.visible=index==0;
			var backData;
			if (index==1){
				var xmlStr;
				this.preReferrence=this._design.xml.referenceLines;
				xmlStr=DesignInfo.uiObjToXml(this._design.xml).toXMLString();
				var selecteID=0;
				if(this._design.selectedCompXml){
					selecteID=this._design.selectedCompXml.compId;
					}else{
					selecteID=-1;
				}
				this.codeView.text=xmlStr;
				if(this.codeView.parent){
					this.clearRuleRange();
				}
				DisControlTool.setTop(this.codeView);
				if(this.iFrameCodeView){
					this.iFrameCodeView.setCode(xmlStr);
					if(selecteID>0)
						this.iFrameCodeView.find(this.findSelecteStrPos(xmlStr.toString(),selecteID));
				}
				this.preXmlStr=xmlStr;
				}else {
				var changeCode;
				changeCode=this.codeView.text;
				if(this.iFrameCodeView){
					changeCode=this.iFrameCodeView.getCode();
				}
				if(this.preXmlStr&&this.preXmlStr!=changeCode){
					try{
						backData=DesignInfo.xmlStrToUIObj(changeCode);
						backData.referenceLines=this.preReferrence;
						this._design.changeXml(backData);
						}catch(e){
						Alert.show(Sys.lang("文本格式有错误！修改未生效"));
					}
					}else{
				}
			}
			this.showAndHidePanels();
		}

		/**页面显示的标题*/
		__getset(0,__proto,'title',function(){
			return this._title;
			},function(value){
			this._title=value;
		});

		/**页面地址*/
		__getset(0,__proto,'pagePath',function(){
			return this._pagePath;
			},function(value){
			if (this._pagePath !=value){
				this._pagePath=value;
				if(this._design){
					this._design.pageType=TypeManager.getFileType(this._pagePath);
				}
				this.title=this._uiName=FileManager.getFileName(this._pagePath);
				this.loadPage(this._pagePath);
			}
		});

		__getset(0,__proto,'hasChange',function(){
			return this.design.hasChange;
		});

		/**获得编辑器实体*/
		__getset(0,__proto,'design',function(){
			return this._design;
		});

		/**缩放页面视图*/
		__getset(0,__proto,'scaleView',function(){
			return this._design.scaleX;
			},function(value){
			value=Math.round(value *100)/ 100;
			if(value<0.05)value=0.05;
			if (this._design.scaleX !=value){
				var center=this.localToGlobal(new Point(this.width *0.5,this.height *0.5));
				var tCenter=new Point();
				tCenter.setTo(center.x,center.y);
				var viewCenter=this._design.globalToLocal(tCenter);
				this._design.scaleY=this._design.scaleX=value;
				var newCenter=this._design.localToGlobal(viewCenter);
				this._design.x+=center.x-newCenter.x;
				this._design.y+=center.y-newCenter.y;
				this.setScaleInfo(value);
				this._design.refreshDragBlocks();
			}
			this.freshRule();
		});

		UIViewer.EnableXMLEditor=true;
		return UIViewer;
	})(UIViewerUI)


	/**添加页面
	*@author yung
	*/
	//class laya.editor.view.page.AddPage extends laya.editor.ui.page.AddPageUI
	var AddPage=(function(_super){
		function AddPage(){
			AddPage.__super.call(this);
			this.nameTxt.restrict=StyleConsts.fileNameRestrict;
			this.widthTxt.restrict="0-9";
			this.heightTxt.restrict="0-9";
			this.selectBtn.on("click",this,this.onSelectBtnClick);
		}

		__class(AddPage,'laya.editor.view.page.AddPage',_super);
		var __proto=AddPage.prototype;
		__proto.onSelectBtnClick=function(e){
			DialogTools.showOpenFile(Sys.lang("请选择视图参考图片"),Utils$1.bind(this.onSelected,this),DialogTools.imgFilterO);
		}

		__proto.onSelected=function(files){
			if (files && files[0])this.imgTxt.text=FileManager.adptToCommonUrl(files[0]);
		}

		__proto.reset=function(){
			this.typeDrop.labels=ProjectSetting.getPageTypeLabel();
			this.typeDrop.selectedIndex=0;
			this.bgColorPicker.selectedColor="#F00000";
			this.bgColorPicker.selectedColor="#000000";
			this.nameTxt.text="";
			this.imgTxt.text="";
			this.widthTxt.text="600";
			this.heightTxt.text="400";
			IDEConfigsManager.I.insertDefaultValue(this,AddPage.ConfigO);
			this.widthCheck.selected=false;
			this.heightCheck.selected=false;
		}

		__proto.check=function(){
			if (!this.nameTxt.text){
				Alert.show(Sys.lang("页面名称不能为空"));
				return false;
			}
			Notice.notify("ADDPage",[this.typeDrop.selectedLabel,this.nameTxt.text,this.imgTxt.text,LayaBuilder.mParseInt(this.widthTxt.text),LayaBuilder.mParseInt(this.heightTxt.text),this.bgColorPicker.selectedColor,this.widthCheck.selected,this.heightCheck.selected]);
			Notice.notify("Focus_design");
			IDEConfigsManager.I.saveDefaultValue(this,AddPage.ConfigO);
			return true;
		}

		__static(AddPage,
		['ConfigO',function(){return this.ConfigO={
				"sign":"AddPage",
				"vars":["widthTxt","heightTxt"]
		};}

		]);
		return AddPage;
	})(AddPageUI)


	/**
	*...
	*@author ww
	*/
	//class laya.editor.view.page.AddParticle extends laya.editor.ui.page.AddParticleUI
	var AddParticle=(function(_super){
		function AddParticle(){
			AddParticle.__super.call(this);
			this.nameTxt.restrict=StyleConsts.fileNameRestrict;
			this.typeDrop.labels=PageExportType.ParticleTypeList.join(",");
			this.typeDrop.selectedIndex=0;
			this.on("doubleclick",this,this.onDoubleClick);
		}

		__class(AddParticle,'laya.editor.view.page.AddParticle',_super);
		var __proto=AddParticle.prototype;
		__proto.onDoubleClick=function(){
			this.typeDrop.labels="重力模式,半径模式,粒子3D,PolyEmitter";
		}

		__proto.reset=function(){
			this.nameTxt.text="";
		}

		__proto.check=function(){
			if (!this.nameTxt.text){
				Alert.show(Sys.lang("粒子名称不能为空"));
				return false;
			}
			Notice.notify("AddParticle",[this.typeDrop.selectedLabel,this.nameTxt.text]);
			Notice.notify("Focus_design");
			return true;
		}

		return AddParticle;
	})(AddParticleUI)


	/**
	*...
	*@author yung
	*/
	//class laya.editor.view.page.AddScript extends laya.editor.ui.page.AddScriptUI
	var AddScript=(function(_super){
		function AddScript(){
			AddScript.__super.call(this);
			this.nameTxt.restrict=StyleConsts.fileNameRestrict;
			this.classTxt.restrict=StyleConsts.fileNameRestrict+".";
		}

		__class(AddScript,'laya.editor.view.page.AddScript',_super);
		var __proto=AddScript.prototype;
		__proto.reset=function(){
			this.nameTxt.text="";
			this.classTxt.text="";
		}

		__proto.check=function(){
			if (!this.nameTxt.text){
				Alert.show(Sys.lang("脚本名称不能为空"));
				return false;
			}
			if (!this.classTxt.text){
				Alert.show(Sys.lang("运行时类名不能为空"));
				return false;
			}
			Notice.notify("addScript",[this.typeDrop.selectedIndex,this.nameTxt.text,this.classTxt.text]);
			Notice.notify("Focus_design");
			return true;
		}

		return AddScript;
	})(AddScriptUI)


	/**属性组
	*@author yung
	*/
	//class laya.editor.view.prop.PropGroup extends laya.editor.ui.prop.PropGroupUI
	var PropGroup=(function(_super){
		function PropGroup(name,props,inputList){
			this._props=[];
			this._isSettingValue=false;
			this._xml=null;
			this.isSpecial=false;
			this.layouter=null;
			this._items=null;
			this.ItemHeight=30;
			this.ItemD=5;
			this.inputList=null;
			this.nameTypeO={};
			this._nameList=[];
			this.groupData=null;
			this.removeBtn=null;
			this.node=null;
			this.x2=85;
			this.x1=15;
			this.rightD=15;
			this.sizeGridSetHandler=null;
			this._data=null;
			this.itemType=null;
			PropGroup.__super.call(this);
			if(!name)return;
			this.createBy(name,props,inputList);
		}

		__class(PropGroup,'laya.editor.view.prop.PropGroup',_super);
		var __proto=PropGroup.prototype;
		__proto.removeBtnClick=function(){
			if(!this.groupData)return;
			if(this.groupData.type=="appendProps"&&this.node){
				AppendPropGroupTool.removeAppendPropsFromData(this.groupData.path,this.node);
				Notice.notify("Prop_Changed");
				PropPanel.instance.refresh();
			}
		}

		__proto.createBy=function(name,props,inputList,groupData){
			this.groupData=groupData;
			if(this.removeBtn){
				this.removeBtn.removeSelf();
			}
			if(this.groupData&&this.groupData.removeAble){
				if(!this.removeBtn){
					this.removeBtn=new Button();
					this.removeBtn.stateNum=1;
					this.removeBtn.skin="view/del.png";
					this.removeBtn.right=5;
					this.removeBtn.top=2;
					this.removeBtn.toolTip=Sys.lang("删除");
					this.removeBtn.on("click",this,this.removeBtnClick);
				}
				this.addChild(this.removeBtn);
			}
			this.inputList=inputList?inputList:[];
			this._props.length=0;
			this.groupLabl.text=name;
			this.groupLabl.color=StyleConsts.FolderTxtColor;
			this.groupLabl.bold=true;
			this.groupBox.removeChildren();
			this.arrowClip.index=1;
			this._items=[];
			if (name=="公用"){
			};
			var nickName;
			var tY=NaN;
			for (var i=0,n=props.length;i < n;i++){
				var prop=props[i].p||props[i];
				nickName=prop.nickname || prop.name;
				tY=i *this.ItemHeight+this.ItemD;
				if (this.isSpecial){
					tY=Math.floor(i / 2)*this.ItemHeight+this.ItemD;
				}
				if(prop.type=="group"){
					this.createGroupProp(props[i],tY);
					}else{
					this.createPropUI(prop.name,nickName,prop.type,prop.tips,tY,prop.option,prop);
				}
			}
			this.groubBar.on("mousedown",this,this.onGroubBarClick);
			var len=0;
			var lItems;
			lItems=[];
			len=this._items.length;
			var tLayout;
			var items;
			if (this.isSpecial){
				for (i=0;i < len;i+=2){
					if (this._items[i+1]){
						items=[this._items[i],this._items[i+1]];
						(this._items [i+1]).items[0].align="right";
						}else{
						items=[ this._items[i+1]];
					}
					tLayout=LayoutFuns.getSameWidthLayout(items,5);
					lItems.push(tLayout);
				}
				this._items=lItems;
			}
			if(this._items.length>0){
				this.layouter=LayoutFuns.getFullFillLayout(this._items,0,20);
			}
			this.cacheAsBitmap=true;
		}

		__proto.reset=function(){
			var childs;
			childs=this.groupBox._childs;
			var i=0,len=0;
			var tChild;
			for(i=0;i<len;i++){
				tChild=childs[i];
				tChild.offAll();
				if(this.inputList){
					ObjectTools$1.removeFromArr(this.inputList,tChild);
				}
			}
			this.groupBox.removeChildren();
			this._nameList.length=0;
			this.node=null;
		}

		__proto.changeSize=function(){
			laya.ui.Component.prototype.changeSize.call(this);
			if (this.layouter){
				this.layouter.width=this.width;
			}
		}

		__proto.onGroubBarClick=function(e){
			if (this.groupBox.parent){
				this.groupBox.removeSelf();
				this.arrowClip.index=0;
				}else {
				this.addChild(this.groupBox);
				this.arrowClip.index=1;
			}
			PropPanel.instance.refreshGroupsPosition();
		}

		__proto.createGroupProp=function(groupData,tY){
			var tgLayout;
			var props;
			props=groupData.cList;
			var i=0,len=0;
			len=props.length;
			var nickName;
			var items;
			items=[];
			var labelWidth=NaN;
			labelWidth=66;
			if(len>2){
				labelWidth=30;
			}
			if(Sys.mParseInt(groupData["labelWidth"])){
				labelWidth=Sys.mParseInt(groupData["labelWidth"]);
			}
			for(i=0;i<len;i++){
				var prop=props[i].p||props[i];
				var tLabelWidth=NaN;
				tLabelWidth=Sys.mParseInt(prop["labelWidth"]);
				tLabelWidth=tLabelWidth?tLabelWidth:labelWidth;
				nickName=prop.nickname || prop.name;
				var showLabel=false;
				showLabel=!(prop.noLabel=="true");
				items.push(this.createPropUI(prop.name,nickName,prop.type,prop.tips,tY,prop.option,prop,tLabelWidth,showLabel));
			}
			tgLayout=LayoutFuns.getSameWidthLayout(items,5);
			this._items.push(tgLayout);
		}

		/**创建属性设置面板*/
		__proto.createPropUI=function(name,nickName,type,tips,y,option,data,labelWidth,showLabel){
			(labelWidth===void 0)&& (labelWidth=105);
			(showLabel===void 0)&& (showLabel=true);
			this._props.push(data);
			this._nameList.push(name);
			var tItems;
			tItems=[];
			var label;
			if(showLabel){
				label=new Label();
				label.text=nickName;
				label.pos(this.x1,y+4);
				label.color=StyleConsts.ItemTxtColor;
				label.width=labelWidth;
				label.height=20;
				label.toolTip=nickName+"\n"+Sys.lang(tips);
				label.textField.overflow=Text.HIDDEN;
				if (this.isSpecial){
					label.width=60;
					}else{
				}
				this.x2=label.width;
				this.groupBox.addChild(label);
				tItems.push(label);
				}else{
				this.x2=this.x1;
			}
			if(PropGroup.typeTrans[type]){
				type=PropGroup.typeTrans[type];
			}
			this.nameTypeO[name]=type;
			if(type=="label"){
			}else
			if(type=="editoption"){
				var dropInput=new InputSelect();
				dropInput.skin="comp/combo_22.png";
				dropInput.name=name;
				dropInput.labels=type=="bool" ? ",false,true" :","+option;
				dropInput.left=this.x2;
				dropInput.sizeGrid="0,30,0,3";
				dropInput.right=this.rightD;
				dropInput.labelColors="#8a8a8a, #ffffff, #efefef";
				dropInput.scrollBarSkin="comp/vscroll.png";
				tItems.push(dropInput);
				dropInput.input.name=name;
				dropInput.input.on("enter",this,this.onInput);
				dropInput.input.on("blur",this,this.onInput);
				dropInput.input.on("focus",this,this.inputFocus,[dropInput.input]);
				dropInput.y=y;
				dropInput.on("change",this,this.onDropChange);
				this.groupBox.addChild(dropInput);
			}else
			if (type=="bool" || type=="option" ||type=="comboBox"){
				var drop=new ComboBox();
				drop.skin="comp/combo_22.png";
				drop.name=name;
				drop.labels=type=="bool" ? ",false,true" :","+option;
				drop.left=this.x2;
				drop.sizeGrid="0,30,0,3";
				drop.right=this.rightD;
				drop.labelColors="#8a8a8a, #ffffff, #efefef";
				drop.scrollBarSkin="comp/vscroll.png";
				tItems.push(drop);
				drop.y=y;
				drop.on("change",this,this.onDropChange);
				this.groupBox.addChild(drop);
			}else
			if (type=="check"){
				var check=new CheckBox();
				check.skin="comp/checkbox.png";
				check.name=name;
				check.selected=false;
				check.left=this.x2;
				check.right=this.rightD;
				check.labelColors="#8a8a8a, #ffffff, #efefef";
				check.label=nickName;
				tItems.push(check);
				check.y=y;
				check.on("change",this,this.onCheckChange,[check]);
				this.groupBox.addChild(check);
				}else if (type=="color"){
				var picker;
				picker=new ColorPickerItem();
				picker.right=this.rightD;
				picker.left=this.x2;
				picker.height=20;
				picker.y=y;
				picker.name=name;
				this.groupBox.addChild(picker);
				picker.on("ColorChanged",this,this.onColorChangeNew);
				picker.on("COLOR_CLEARED",this,this.onColorCleared);
				tItems.push(picker);
				}else if (type=="colorBox"){
				var colorInput=new TextInput();
				colorInput.skin="comp/input_22.png";
				colorInput.sizeGrid="4,4,4,4";
				colorInput.name=name;
				colorInput.left=this.x2;
				colorInput.right=this.rightD+15;
				colorInput.y=y;
				this.groupBox.addChild(colorInput);
				var colorPic=new ColorPicker();
				colorPic.skin="comp/color.png";
				colorPic.name=name+"_color";
				colorPic.on("change",this,this.onColorBoxChange);
				colorPic.right=this.rightD;
				colorPic.y=y;
				this.groupBox.addChild(colorPic);
				tItems.push(colorInput,colorPic);
				}else if (type=="sNumber"){
				var slider=new HSlider("comp/hslider.png");
				slider.name=name;
				slider.left=this.x2;
				slider.right=this.rightD;
				slider.y=y+8;
				slider.tick=0.01;
				slider.setSlider(parseFloat(data.min),parseFloat(data.max),0.5*(parseFloat(data.min)+parseFloat(data.max)));
				this.groupBox.addChild(slider);
				slider.on("changed",this,this.onSliderChange,[slider]);
				if(label)
					this.groupBox.addChild(label);
				tItems.push(slider);
				}else {
				var input;
				if (type=="number"||type=="Number"){
					input=new NumberInput();
					input.on("changing",this,this.onInputChanging);
					input.on("Get_Value",this,this.onGetCurValue);
					}else{
					input=new EditorTextInput();
				}
				input.skin="comp/input_22.png";
				input.name=name;
				input.left=this.x2;
				input.right=this.rightD;
				input.y=y;
				input.color=StyleConsts.TextInputColor;
				input.padding="0,0,0,5";
				input.height=24;
				input.sizeGrid="0,4,0,4";
				input.overflow=Text.HIDDEN;
				this.inputList.push(input);
				input.on("keydown",this,this.onkeyDown,[input]);
				this.mouseEnabled=true;
				input.on("enter",this,this.onInput);
				input.on("blur",this,this.onInput);
				input.on("focus",this,this.inputFocus,[input]);
				this.groupBox.addChild(input);
				if (type=="stringdrag"||name=="skin"||data.accept=="res"){
					input.padding="1,36,1,3"
					input.on("dragDrop",this,this.onDragDrop,[data.acceptTypes]);
					var btn=new Button();
					btn.label="";
					btn.y=y+6;
					btn.skin="comp/skinres.png";
					btn.scale(0.5,0.5);
					btn.right=this.rightD-1;
					btn.labelColors=StyleConsts.SkinBtnLabelColor;
					btn.on("mousedown",this,this.onSkinDown,[input]);
					btn.toolTip=Sys.lang("拖动资源到输入框可替换皮肤\n点击skin可快速定位皮肤资源");
					this.groupBox.addChild(btn);
				}
				if(data.accept=="files"){
					input.on("dragDrop",this,this.onMutiDragDrop,[data.acceptTypes,data.failtip]);
				}
				if(name=="sizeGrid"){
					input.padding="1,36,1,3"
					btn=new Button();
					btn.label="";
					btn.y=y+6;
					btn.scale(0.5,0.5);
					btn.skin="comp/gridset.png";
					btn.right=this.rightD-1;
					btn.labelColors=StyleConsts.SkinBtnLabelColor;
					btn.on("mousedown",this,this.sizeGridBtnClick,[input]);
					btn.toolTip=Sys.lang("点击设置九宫数据");
					this.groupBox.addChild(btn);
				}
				if(type=="Number"||type=="number"){
					input.restrict=StyleConsts.NumberRestrict;
				}
				if(type=="int"){
					input.restrict=StyleConsts.IntRestrict;
				}
				tItems.push(input);
			}
			LayoutFuns.clearItemsRelativeInfo(tItems);
			var tLayout;
			tLayout=LayoutFuns.getFixPos(tItems,5,false);
			this._items.push(tLayout);
			return tLayout;
		}

		__proto.sizeGridBtnClick=function(input){
			var skinLabel=UIConfigManager.getCompSkinLabel(this.itemType);
			var skin;
			skin=this._data[skinLabel];
			if (skin){
				var defaultProps=ResStyleManager.getResPropsObj(skin);
				}else{
				Alert.show(Sys.lang("没有皮肤资源，不可设置九宫"));
				return;
			};
			var sizeGridStr;
			sizeGridStr=input.text;
			if(sizeGridStr==""&&defaultProps["sizeGrid"]){
				sizeGridStr=defaultProps["sizeGrid"];
			}
			if(!this.sizeGridSetHandler)this.sizeGridSetHandler=new Handler(this,this.sizeGridSetBack,[input]);
			SetSizeGrid.instance.start(skin,this.itemType,sizeGridStr,this.sizeGridSetHandler,this._data);
		}

		__proto.sizeGridSetBack=function(input,sizeGridStr){
			this.setCompProp(input.name,sizeGridStr);
		}

		__proto.inputFocus=function(input){
			Laya.timer.once(100,this,this.setFocus,[input],true);
		}

		__proto.setFocus=function(input){
			Laya.stage.focus=input;
		}

		__proto.onkeyDown=function(input,event){
			if(event.keyCode!=9)return;
			var index=0;
			var tInputList;
			tInputList=this.inputList;
			index=tInputList.indexOf(input);
			if(index>=0){
				index++;
				if(index>=tInputList.length){
					index=0;
				}
				input=this.findNextInput(index,tInputList);
				(input.textField).focus=true;
				Notice.notify("SELECTE_INPUT",[input]);
			}
		}

		__proto.findNextInput=function(startIndex,inputList){
			var i=0,len=0;
			len=inputList.length;
			var tInput;
			for(i=startIndex;i<len;i++){
				tInput=inputList[i];
				if(tInput.displayedInStage)return tInput;
			}
			for(i=0;i<startIndex;i++){
				tInput=inputList[i];
				if(tInput.displayedInStage)return tInput;
			}
			return inputList[0];
		}

		__proto.onSkinDown=function(input,e){
			Notice.notify("SelecteResFile",[input.text]);
		}

		__proto.onDragDrop=function(types,e,failTip){
			var tar=e.target;
			var data=e.data;
			var asset;
			asset=data.asset||data.path;
			if(!asset)return;
			if(! (typeof asset=='string'))return;
			var prefix;
			prefix=FileTools.getExtensionName(asset);
			if(types&&prefix){
				var typeArr;
				typeArr=types.split(",");
				if(typeArr.indexOf(prefix)<0){
					if(failTip)
						Alert.show(failTip);
					return;
				}
			}
			if(!types){
				if(data.type!="res")return;
			};
			var src=e.dragInitiator;
			var path;
			switch(data.type){
				case "res":
					path=FileManager.getRelativePath(SystemSetting.assetsPath,asset);
					break ;
				case "page":
					path=FileManager.getRelativePath(SystemSetting.pagesPath,asset);
					break ;
				default :
					path=FileManager.getWorkRelativePath(asset);
				}
			path=FileManager.adptToCommonUrl(path);
			tar.text=path;
			this.onInput(tar);
		}

		__proto.onMutiDragDrop=function(types,failTip,e){
			var tar=e.target;
			var data=e.data;
			if(data.type!="multiResFile"&&data.type!="resDir"){
				if(types){
					this.onDragDrop(types,e,failTip);
				}
				return;
			};
			var files;
			files=DragEvent.getMutiDragFiles(e);
			if(!files||files.length<1)return;
			tar.text=files.join(",");
			this.onInput(tar);
		}

		__proto.onSliderChanging=function(txt,tar){}
		//txt.text=tar.value+"";
		__proto.onSliderChange=function(slider){
			this.setCompProp(slider.name,slider.value);
		}

		/**处理颜色变化*/
		__proto.onColorChange=function(e){
			var color=e.currentTarget;
			this.setCompProp(color.name,color.selectedColor);
		}

		__proto.onColorChangeNew=function(picker){
			this.setCompProp(picker.name,picker.getColorStr());
		}

		__proto.onColorCleared=function(picker){
			this.setCompProp(picker.name,"");
		}

		/**处理颜色变化*/
		__proto.onColorBoxChange=function(e){
			var color=e.currentTarget;
			var colorStr=color.selectedColor;
			var propName=color.name.replace("_color","");
			var input=color.parent.getChildByName(propName);
			var arr=input.text.split(",");
			if (input.text !="" && arr){
				for (var i=0;i < arr.length;i++){
					var item=arr[i];
					if (item.indexOf("#")>-1){
						arr[i]=colorStr;
						break ;
					}
				}
				input.text=arr.join(",");
				}else {
				input.text=colorStr;
			}
			this.setCompProp(input.name,input.text);
		}

		/**处理下拉框变化*/
		__proto.onDropChange=function(e){
			var drop=e.currentTarget;
			this.setCompProp(drop.name,drop.selectedLabel);
		}

		__proto.onCheckChange=function(check){
			this.setCompProp(check.name,check.selected);
		}

		__proto.onGetCurValue=function(input){
			if(this.node){
				Notice.notify("PROP_FORCESET",[input.name,this.node.compId]);
			}
		}

		// debugger;
		__proto.onInputChanging=function(input){
			this.setCompProp(input.name,input.text,true);
		}

		__proto.onInput=function(input,forceSetValue){
			(forceSetValue===void 0)&& (forceSetValue=false);
			this.setCompProp(input.name,input.text,false,forceSetValue);
		}

		/**处理输入框回车*/
		__proto.onInputKeyDown=function(e){
			if (e.keyCode==13){
				var input=e.currentTarget;
				this.setCompProp(input.name,input.text);
			}
		}

		/**输入框获得焦点处理*/
		__proto.onTextFocusIn=function(e){
			var input=e.currentTarget;
			Laya.timer.once(1,this,this.selectAllText,[input]);
		}

		__proto.selectAllText=function(input){}
		/**处理输入框失去焦点*/
		__proto.onTextFocusOut=function(e){
			var input=e.currentTarget;
			this.setCompProp(input.name,input.text);
		}

		/**设置组件属性*/
		__proto.setCompProp=function(key,value,isChanging,forceSetValue){
			(isChanging===void 0)&& (isChanging=false);
			(forceSetValue===void 0)&& (forceSetValue=false);
			if (!this._isSettingValue){
				var flag=false;
				var oldValue=String(this._data[key]);
				if(value==""&&!this._data.hasOwnProperty(key))return;
				if (oldValue !=value){
					if (Boolean(value)){
						this._data[key]=value;
						flag=true;
						}else if (Boolean(oldValue)){
						delete this._data[key];
						flag=true;
					}
				}
				if (flag||forceSetValue){
					this.event("change",[]);
					PropPanel.instance.valueChange(key,value,isChanging,this.nameTypeO[key],this.name!="appendProps");
				}
			}
		}

		/**设置属性*/
		__proto.setData=function(data){}
		// setValueD(data.cList[0].p);
		__proto.setValueD=function(data,defaultData,itemType,node){
			this.itemType=itemType;
			this._data=data=data;
			this.node=node;
			this._isSettingValue=true;
			for (var i=0,n=this._props.length;i < n;i++){
				var prop=this._props[i].p||this._props[i];;
				var name=prop.name;
				var value="";
				var isDefault=false;
				if (!data.hasOwnProperty(name)){
					if(defaultData&&defaultData.hasOwnProperty(name)){
						value=ObjectTools$1.getAutoValue(defaultData[name]);
						if(prop.type=="bool"){
							value=value?"true":"false";
						}
						isDefault=true;
					}
					}else{
					value=data[name];
					if(prop.type=="bool"){
						value=value?"true":"false";
					}
				};
				var target=this.groupBox.getChildByName(name);
				if ((target instanceof laya.ui.TextInput )){
					(target).text=value+"";
					(target).color=isDefault?StyleConsts.TextInputColorDefault:StyleConsts.TextInputColor;
					}else if ((target instanceof laya.ui.ComboBox )){
					(target).selectedLabel=value+"";
					(target).labelColors=isDefault?StyleConsts.TextInputColorDefault:StyleConsts.TextInputColor;
					}else if ((target instanceof laya.ui.ColorPicker )){
					(target).selectedColor=value;
					}else if ((target instanceof laya.ui.Slider )){
					(target).value=parseFloat(value);
					}else if ((target instanceof laya.editor.comonents.ColorPickerItem )){
					(target).setColor(value);
					}else if((target instanceof laya.ui.CheckBox )){
					(target).selected=value;
				}
			}
			this._isSettingValue=false;
		}

		__static(PropGroup,
		['typeTrans',function(){return this.typeTrans={
				"Boolean":"bool",
				"String":"string"
		};}

		]);
		return PropGroup;
	})(PropGroupUI)


	/**快捷工具栏
	*@author yung
	*/
	//class laya.editor.view.QuickTool extends laya.editor.ui.QuickToolUI
	var QuickTool=(function(_super){
		function QuickTool(){
			this.commonBtns=
			[
			"addFolder",
			"addPage",
			"|",
			"save",
			"saveAll",
			"|",
			"back",
			"reBack",
			"|",
			"refresh",
			"publish"];
			this.zoomBtns=
			[
			"zoomIn",
			"zoomOut",
			"zoomBack"];
			this.alignBtns=
			[
			"alignLeft",
			"alignCenter",
			"alignRight",
			"alignTop",
			"alignMiddle",
			"alignbottom",
			"|",
			"spaceH",
			"spaceV",
			"|",
			"topLeft",
			"topRight",
			"bottomLeft",
			"bottomRight",
			"center",
			"middle",
			"tomiddle"];
			this.allBtns=null;
			this.tBtns=null;
			this.btnDic=null;
			this.typeBtnsDic={};
			this._BtnList=null;
			QuickTool.__super.call(this);
			this._visibleRec=new Rectangle();
			this.on("click",this,this.onClick);
			var _btnNames=
			[
			"addFolder",
			"addPage",
			"save",
			"saveAll",
			"back",
			"reBack",
			"zoomIn",
			"zoomOut",
			"zoomBack",
			"refresh",
			"publish",
			"alignLeft",
			"alignCenter",
			"alignRight",
			"alignTop",
			"alignMiddle",
			"alignbottom",
			"spaceH",
			"spaceV",
			"topLeft",
			"topRight",
			"bottomLeft",
			"bottomRight",
			"center",
			"middle",
			"tomiddle"];
			this._BtnList=[];
			var i=0,len=0;
			len=_btnNames.length;
			this.btnDic={};
			var tBtn;
			for(i=0;i<len;i++){
				tBtn=this.getChildByName(_btnNames[i]);
				tBtn.width=22;
				tBtn.height=20;
				this._BtnList.push(tBtn);
				this.btnDic[_btnNames[i]]=tBtn;
			}
			DisControlTool.removeItems(this._BtnList);
			this.allBtns=ObjectTools$1.setValueArr([],this._BtnList);
			this.typeBtnsDic["Common"]=this.commonBtns;
			this.typeBtnsDic["Zoom"]=this.zoomBtns;
			this.typeBtnsDic["Align"]=this.alignBtns;
			this.namesToBtns(this.commonBtns);
			this.namesToBtns(this.zoomBtns);
			this.namesToBtns(this.alignBtns);
			this.setShowBtns(["Common"]);
			this.cacheAsBitmap=IDEConsts.cachePanels;
		}

		__class(QuickTool,'laya.editor.view.QuickTool',_super);
		var __proto=QuickTool.prototype;
		// cacheAsBitmap=false;
		__proto.namesToBtns=function(names){
			var i=0,len=0;
			len=names.length;
			for(i=0;i<len;i++){
				if(names[i]=="|"){
					names[i]=new Image("view/line.png");
					}else{
					names[i]=this.btnDic[names[i]];
				}
			}
			return names[i];
		}

		__proto.setShowBtns=function(types){
			DisControlTool.removeItems(this.allBtns);
			if(this._BtnList)
				DisControlTool.removeItems(this._BtnList);
			var i=0,len=0;
			var tType;
			var tTypeBtns;
			len=types.length;
			ObjectTools$1.clearArr(this._BtnList);
			for(i=0;i<len;i++){
				if(this._BtnList.length>0){
					this._BtnList.push(new Image("view/line.png"));
				}
				ObjectTools$1.concatArr(this._BtnList,this.typeBtnsDic[types[i]]);
			}
			DisControlTool.addItems(this._BtnList,this);
			this.changeSize();
			return this._BtnList;
		}

		__proto.changeSize=function(){
			laya.ui.Component.prototype.changeSize.call(this);
			var nWidth=NaN;
			nWidth=this.width;
			LayoutTools.layoutToWidth(this._BtnList,nWidth,5,5,20,9);
			this._visibleRec.setTo(0,0,this.width,this.height);
			this.scrollRect=this._visibleRec;
		}

		//public var title:String="工具";
		__proto.onClick=function(e){
			var btn=e.target;
			if (btn){
				switch (btn.name){
					case "addFolder":
						ShortcutManager.exeKey(68,true);
						break ;
					case "addPage":
						ShortcutManager.exeKey(78,true);
						break ;
					case "save":
						ShortcutManager.exeKey(83,true);
						break ;
					case "saveAll":
						ShortcutManager.exeKey(83,true,true);
						break ;
					case "back":
						ShortcutManager.exeKey(90,true);
						break ;
					case "reBack":
						ShortcutManager.exeKey(89,true);
						break ;
					case "zoomIn":
						ShortcutManager.exeKey(189,true);
						break ;
					case "zoomOut":
						ShortcutManager.exeKey(187,true);
						break ;
					case "zoomBack":
						ShortcutManager.exeKey(220,true);
						break ;
					case "refresh":
						ShortcutManager.exeKey(116);
						break ;
					case "publish":
						ShortcutManager.exeKey(123);
						break ;
					case "alignLeft":
						UIPanel.instance.alignComp("left");
						break ;
					case "alignCenter":
						UIPanel.instance.alignComp("center");
						break ;
					case "alignRight":
						UIPanel.instance.alignComp("right");
						break ;
					case "alignTop":
						UIPanel.instance.alignComp("top");
						break ;
					case "alignMiddle":
						UIPanel.instance.alignComp("middle");
						break ;
					case "alignbottom":
						UIPanel.instance.alignComp("bottom");
						break ;
					case "spaceH":
						UIPanel.instance.spaceComp("h");
						break ;
					case "spaceV":
						UIPanel.instance.spaceComp("v");
						break ;
					case "topLeft":
						UIPanel.instance.placeComp("top_left");
						break ;
					case "topRight":
						UIPanel.instance.placeComp("top_right");
						break ;
					case "bottomLeft":
						UIPanel.instance.placeComp("bottom_left");
						break ;
					case "bottomRight":
						UIPanel.instance.placeComp("bottom_right");
						break ;
					case "center":
						UIPanel.instance.placeComp("center");
						break ;
					case "middle":
						UIPanel.instance.placeComp("middle");
						break ;
					case "tomiddle":
						UIPanel.instance.placeComp("toCenter");
						break ;
					}
			}
		}

		__getset(1,QuickTool,'instance',function(){
			return QuickTool._instance ? QuickTool._instance :QuickTool._instance=new QuickTool();
		},laya.editor.ui.QuickToolUI._$SET_instance);

		QuickTool._instance=null
		QuickTool.Common="Common";
		QuickTool.Zoom="Zoom";
		QuickTool.Align="Align";
		return QuickTool;
	})(QuickToolUI)


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-2-24 上午11:13:48
	*/
	//class laya.editor.view.template.TemplateItem extends laya.editor.ui.template.TemplateItemUI
	var TemplateItem=(function(_super){
		function TemplateItem(){
			this.imgWidth=NaN;
			this.imgHeight=NaN;
			this.tImg=null;
			TemplateItem.__super.call(this);
			this.tImg=new Image();
			this.tImg.on("loaded",this,this.adptImg);
			this.imgWidth=this.imgBg.width;
			this.imgHeight=this.imgBg.height;
			this.addChild(this.tImg);
			this.tLabel.textField.overflow=Text.HIDDEN;
			this.tLabel.color=StyleConsts.ItemTxtColor;
		}

		__class(TemplateItem,'laya.editor.view.template.TemplateItem',_super);
		var __proto=TemplateItem.prototype;
		__proto.initData=function(tData,picWidth,picHeight,tipFun){
			this.tImg.skin=tData.icon;
			this.tImg["uData"]=tData;
			this.tImg.mouseEnabled=true;
			this.mouseEnabled=true;
			this.toolTip=new Handler(null,tipFun,[tData]);
			this.size(picWidth,picHeight);
			this.tLabel.text=tData.title;
			this.tLabel.align="center";
		}

		__proto.adptImg=function(){
			this.imgWidth=this.imgBg.width;
			this.imgHeight=this.imgBg.height;
			this.imgWidth=76;
			this.imgHeight=65;
			var tt;
			tt=this.tImg.source;
			if(!tt)return;
			var sX=NaN;
			sX=this.imgWidth/tt.width;
			var sY=NaN;
			sY=this.imgHeight/tt.height;
			var scale=NaN;
			scale=sX<sY?sX:sY;
			this.tImg.width*=scale;
			this.tImg.height*=scale;
			this.tImg.x=(this.imgWidth-this.tImg.width)*0.5;
			this.tImg.y=(this.imgHeight-this.tImg.height)*0.5;
		}

		return TemplateItem;
	})(TemplateItemUI)


	/**
	*动画播放控制
	*@author ww
	*@version 1.0
	*
	*@created 2015-12-19 上午11:10:12
	*/
	//class laya.editor.view.timeline.PlayControl extends laya.editor.ui.timeline.PlayControlUI
	var PlayControl=(function(_super){
		function PlayControl(){
			this.isPlaying=false;
			PlayControl.__super.call(this);
			this.on("mousedown",this,this.mouseClickHandler);
			this.setIfPlay(false);
		}

		__class(PlayControl,'laya.editor.view.timeline.PlayControl',_super);
		var __proto=PlayControl.prototype;
		__proto.mouseClickHandler=function(e){
			var tKey;
			tKey=e.target.name;
			if(PlayControl.nameToActionDic.hasOwnProperty(tKey)){
				Notice.notify(PlayControl.nameToActionDic[tKey],[PlayControl.nameToActionDic[tKey]])
			}
		}

		__proto.setIfPlay=function(v){
			this.isPlaying=v;
			this.play.visible=!v;
			this.stop.visible=!this.play.visible;
		}

		__static(PlayControl,
		['nameToActionDic',function(){return this.nameToActionDic={
				"toBeginPos":"PlayControl_ToBeginPos",
				"pre":"PLAYCONTROL_Pre",
				"play":"PLAYCONTROL_Play",
				"next":"PLAYCONTROL_Next",
				"toEndPos":"PLAYCONTROL_TOEndPOS",
				"stop":"PLAYCONTROL_Stop"
		};}

		]);
		return PlayControl;
	})(PlayControlUI)


	/**
	*时间轴网格
	*@author ww
	*@version 1.0
	*
	*@created 2015-12-4 上午11:06:05
	*/
	//class laya.editor.view.timeline.TimeGrid extends laya.editor.ui.timeline.TimeGridUI
	var TimeGrid=(function(_super){
		function TimeGrid(){
			this.SideDistance=3;
			this._copyFrames=null;
			this._holder=null;
			this.preMouseX=0;
			this.preCursourX=0;
			this.tSelectFrame=null;
			this.clickLayer=0;
			this.clickFrame=0;
			this._isDragSelect=false;
			this.selectFrames=[];
			this.preScrollValue=NaN;
			this.preStageMouseX=NaN;
			this.tempFrameData={};
			this._isMultiDragEndRefresh=false;
			this._selectFramesInfo={};
			this._selectFrame=0;
			this.titleLayer=null;
			this.lineLayer=null;
			this.frameLayer=null;
			this.markLayer=null;
			this.timeCursor=null;
			this.topLayer=null;
			this.frameCount=130;
			this.lineStartPos=6;
			this.bigLine=5;
			this.lineScrollX=0;
			this.lineScrollY=0;
			this.keyIndexDic={};
			this.layerDataList=null;
			this.frameDic={};
			this.lineDY=0.5;
			this._selectLineLayer=new Sprite();
			TimeGrid.__super.call(this);
			this.bgPic.visible=false;
			this.lineLayer=new Sprite();
			this.addChild(this.lineLayer);
			this.titleLayer=new Sprite();
			this.addChild(this.titleLayer);
			this.titleLayer.on("mousedown",this,this.onTitleMouseDown);
			this.titleLayer.x=0;
			this.titleLayer.y=0;
			this.titleLayer.height=TimeGrid.titleHeight;
			this.lineLayer.x=0;
			this.lineLayer.y=TimeGrid.titleHeight;
			this.scrollRect=new Rectangle(0,0,this.width,this.height);
			this.lineLayer.on("mousedown",this,this.lineClick);
			this.lineLayer.on("rightmousedown",this,this.lineClick);
			this.lineLayer.cacheAsBitmap=true;
			this.timeCursor=new TimeCursor();
			this.timeCursor.visible=false;
			this.timeCursor.y=this.lineLayer.y;
			this.addChild(this.timeCursor);
			this.timeCursor.on("mousedown",this,this.cursorMouseDown);
			this.timeCursor.on("rightmousedown",this,this.cursorMouseDown);
			this.timeCursor.on("dragend",this,this.cursorDragEnd);
			this.timeCursor.on("dragmove",this,this.cursorMove);
			this.frameLayer=new Sprite();
			this.addChild(this.frameLayer);
			this.frameLayer.x=this.lineLayer.x;
			this.frameLayer.y=this.lineLayer.y;
			this.frameLayer.size(1,1);
			this.frameLayer.on("mousedown",this,this.lineClick);
			this.frameLayer.on("rightmousedown",this,this.lineClick);
			this.topLayer=new Sprite();
			this.topLayer.mouseEnabled=true;
			this.addChild(this.topLayer);
			this.topLayer.x=this.lineLayer.x;
			this.topLayer.y=this.lineLayer.y;
			this.topLayer.size(1,1);
			this.markLayer=new Sprite();
			this.addChild(this.markLayer);
			this.markLayer.mouseEnabled=false;
			this.markLayer.y=this.titleLayer.y;
			this.markLayer.x=this.lineLayer.x;
			this.addChild(this._selectLineLayer);
			this._holder=new TimeFrame();
			var hData;
			hData=new TimeFrameData();
			hData.type=2;
			hData.props=this.tempFrameData;
			this._holder.setData(hData);
			this.addListens();
			this.on("dragDrop",this,this.onDragDrop);
		}

		__class(TimeGrid,'laya.editor.view.timeline.TimeGrid',_super);
		var __proto=TimeGrid.prototype;
		// this.parent.on(Event.KEY_DOWN,this,onKeyDown);
		__proto.onKeyDown=function(e){
			if (e.keyCode==46||e.keyCode==8){
				this.removeSelectFrames();
			}
			if(e.keyCode==75){
				this.makeKeyFrame();
			}
			if(e.keyCode==86&&KeyManager.I.isCommandKeyDown){
				this.pasteFrames();
			}
			if(e.keyCode==67&&KeyManager.I.isCommandKeyDown){
				this.copyFrames();
			}
		}

		//e.stopPropagation();
		__proto.makeKeyFrame=function(){
			console.log("makeKeyFrame");
			if(this._holder.parent){
				this.removeHolder();
				if(!this.tempFrameData.isDirectory){
					TimeFrame.selecteData=TimeLinePanel.instance.aniData.makeKeyFrame(this.tempFrameData.target,this.tempFrameData.key,this.selectFrame);
					TimeLinePanel.instance.reFresh();
					}else{
					TimeFrame.selecteData=TimeLinePanel.instance.aniData.makeKeyFrame(this.tempFrameData.target,"x",this.selectFrame);
					TimeLinePanel.instance.reFresh();
				}
			}
		}

		__proto.onDragDrop=function(e){
			if(!IDEVars.isGraphicAnimationMode){
				MessageManager.instance.show(Sys.lang("动画文件编辑才支持该功能"));
				return;
			};
			var mousePoint;
			mousePoint=DisControlTool.getMousePoint(this.lineLayer);
			var tLayer=0;
			var tFrame=0;
			tLayer=this.getLayerByY(mousePoint.y);
			tFrame=this.getFrameByX(mousePoint.x);
			var layerItem;
			layerItem=this.layerDataList[tLayer];
			if(layerItem){
				this.selectFrame=tFrame;
				this.addFilesByDragEvent(e,layerItem,tFrame);
				}else{
				if(this.layerDataList.length<1){
					this.selectFrame=0;
					Notice.notify("AddNode",[TypeManager.GraphicPic,0,0,-1,true]);
					layerItem=this.layerDataList[0];
					if(layerItem){
						this.addFilesByDragEvent(e,layerItem,0);
						}else{
						Laya.timer.once(100,this,this.addFilesLater,[e]);
					}
					}else{
					this.selectFrame=0;
					Notice.notify("AddNode",[TypeManager.GraphicPic,0,0,-1,true]);
					Laya.timer.once(100,this,this.addFilesLater,[e]);
				}
			}
		}

		__proto.addFilesLater=function(e){
			var layerItem;
			layerItem=this.layerDataList[this.layerDataList.length-1];
			if(layerItem){
				this.addFilesByDragEvent(e,layerItem,0);
			}
		}

		__proto.addFilesByDragEvent=function(e,layerItem,tFrame){
			var data=e.data;
			var asset;
			asset=data.asset||data.path;
			var type;
			type=data.type;
			if(type=="res"){
				if(!asset||asset=="")return;
				asset=FileManager.getRelativePath(SystemSetting.assetsPath,asset);
				Notice.notify("Prop_change",["skin",asset,layerItem.target]);
			}
			if(type=="multiResFile"||type=="resDir"){
				this.addFiles(DragEvent.getMutiDragFiles(e),layerItem.target,tFrame);
			}
		}

		__proto.addFiles=function(files,target,startFrame){
			if(!files||files.length<1)return;
			if(target<0)return;
			if(startFrame<0)return;
			var i=0,len=0;
			len=files.length;
			for(i=0;i<len;i++){
				this.selectFrame=startFrame;
				Notice.notify("Prop_change",["skin",files[i],target]);
				startFrame++;
			}
		}

		__proto.onTitleMouseDown=function(e){
			var mousePoint;
			mousePoint=DisControlTool.getMousePoint(this.lineLayer);
			this.clickFrame=this.getFrameByX(mousePoint.x);
			this.selectFrame=this.clickFrame;
			this.cursorMouseDown(null);
			this.event("TIMELINE_CLICKFRAME",[-1,this.clickFrame]);
			this.updateFocusFrame();
		}

		/**处理菜单选择*/
		__proto.onEmunSelect=function(name){
			var tarData;
			var layerItem;
			var frameList;
			switch (name){
				case "删除帧":
					if(this.tSelectFrame){
						tarData=this.tSelectFrame.data.props;
						layerItem=this.layerDataList[this.clickLayer];
						if(layerItem){
							TimeLinePanel.instance.aniData.displayToInitState();
							frameList=layerItem.path;
							if(frameList&&frameList.indexOf(tarData)>=0){
								frameList.splice(frameList.indexOf(tarData),1);
								TimeLinePanel.instance.reFresh();
							}
						}
					}
					break ;
				case "复制":
					this.copyFrames();
					break ;
				case "批量删除帧":
					if(this.tSelectFrame&&this.tSelectFrame.data.type==3){
						TimeLinePanel.instance.aniData.removeNodeFrameByNodeID(this.tSelectFrame.data.props.target,this.tSelectFrame.data.props.index);
						TimeLinePanel.instance.reFresh();
					}
					break ;
				case "删除选中的帧":
					this.removeSelectFrames();
					break ;
				case "删除本帧所有关键帧":
					TimeLinePanel.instance.aniData.removeFrame(null,this.selectFrame);
					TimeLinePanel.instance.reFresh();
					break ;
				case "删除Tween":
					if(this.tSelectFrame){
						tarData=this.tSelectFrame.data.props;
						layerItem=this.layerDataList[this.clickLayer];
						if(layerItem){
							tarData.tween=false;
							TimeLinePanel.instance.reFresh();
						}
					}
					break ;
				case "添加Tween":
					if(this.tSelectFrame){
						tarData=this.tSelectFrame.data.props;
						layerItem=this.layerDataList[this.clickLayer];
						if(layerItem){
							tarData.tween=true;
							TimeLinePanel.instance.reFresh();
						}
					}
					break ;
				case "转换为关键帧":
					if(this._holder.parent){
						this.removeHolder();
						if(!this.tempFrameData.isDirectory){
							TimeFrame.selecteData=TimeLinePanel.instance.aniData.makeKeyFrame(this.tempFrameData.target,this.tempFrameData.key,this.selectFrame);
							TimeLinePanel.instance.reFresh();
						}
					}
					break ;
				}
		}

		__proto.copyFrames=function(){
			this._copyFrames=[];
			var tempArr;
			tempArr=this.getNoSameSelectFrameList();
			if(tempArr.length<1){
				if(this.tSelectFrame){
					if(this.tSelectFrame!=this._holder){
						tempArr.push(this.tSelectFrame);
					}
				}
			}
			if(tempArr.length<1){
				MessageManager.instance.show(Sys.lang("没有可以复制的帧"));
				return;
			};
			var i=0,len=0;
			len=tempArr.length;
			var tempO;
			var rst;
			rst=[];
			var copyO;
			copyO={};
			var targetID=0;
			var tIndex=0;
			var tArr;
			for(i=0;i<len;i++){
				tempO=tempArr[i].data;
				targetID=tempO.props.target;
				tIndex=TimeLinePanel.instance.aniData.getNodeIndex(targetID);
				if(!copyO[tIndex])copyO[tIndex]=[];
				tArr=copyO[tIndex];
				if(tempO.type==3){
					ObjectTools$1.concatArr(tArr,TimeLinePanel.instance.aniData.getNodeKeyFramesByNodeID(tempO.props.target,tempO.props.index));
					}else if(tempO.type==1){
					tArr.push(tempO.props);
				}
			};
			var indexKey;
			var minIndex=0;
			minIndex=-1;
			var minNodeIndex=-1;
			var maxNodeIndex=-1;
			for(indexKey in copyO){
				tArr=copyO[indexKey];
				len=tArr.length;
				tIndex=parseInt(indexKey);
				if(minNodeIndex<0||tIndex<minNodeIndex){
					minNodeIndex=tIndex;
				}
				if(maxNodeIndex<0||tIndex>maxNodeIndex){
					maxNodeIndex=tIndex;
				}
				for(i=0;i<len;i++){
					tIndex=parseInt(tArr[i].index);
					if(minIndex<0||tIndex<minIndex){
						minIndex=tIndex;
					}
				}
			}
			copyO=ObjectTools$1.copyObjFast(copyO);
			rst=[];
			for(indexKey in copyO){
				tArr=copyO[indexKey];
				tIndex=parseInt(indexKey);
				rst[tIndex-minNodeIndex]=tArr;
				len=tArr.length;
				for(i=0;i<len;i++){
					tArr[i].index=parseInt(tArr[i].index)-minIndex;
				}
			}
			this._copyFrames=rst;
			MessageManager.instance.show(Sys.lang("复制帧成功"));
		}

		__proto.pasteFrames=function(){
			if(!this._copyFrames||this._copyFrames.length<0)return;
			if(this.tSelectFrame){
				var tar=0;
				tar=this.tSelectFrame.data.props.target;
				var tarFrame=0;
				tarFrame=this.selectFrame;
				var tIndex=0;
				tIndex=TimeLinePanel.instance.aniData.getNodeIndex(tar);
				var i=0,len=0;
				len=this._copyFrames.length;
				for(i=0;i<len;i++){
					this.addFramesToTar(this._copyFrames[i],TimeLinePanel.instance.aniData.getNodeIDByIndex(i+tIndex),tarFrame);
				}
				TimeLinePanel.instance.reFresh();
			}
		}

		__proto.addFramesToTar=function(frames,tar,offSet){
			if(tar<0)return;
			var i=0,len=0;
			len=frames.length;
			for(i=0;i<len;i++){
				TimeLinePanel.instance.aniData.addKeyFrameOToNode(tar,frames[i],offSet);
			}
		}

		__proto.removeSelectFrames=function(){
			var tarData;
			var layerItem;
			var frameList;
			if(this.selectFrames&&this.selectFrames.length>0){
				var i=0,len=0;
				len=this.selectFrames.length;
				var tWorkFrame;
				var tPropsO;
				for(i=0;i<len;i++){
					tWorkFrame=this.selectFrames[i];
					if(tWorkFrame){
						if(tWorkFrame.data.type==3){
							tPropsO=tWorkFrame.data.props;
							TimeLinePanel.instance.aniData.removeNodeFrameByNodeID(tPropsO.target,tPropsO.index);
							}else if(tWorkFrame.data.type==1){
							tPropsO=tWorkFrame.data.props;
							TimeLinePanel.instance.aniData.removeNodePropFrameByKeyAndFrame(tPropsO.target,tPropsO.key,tPropsO.index);
						}
					}
				}
				TimeLinePanel.instance.reFresh();
				}else{
				if(this.tSelectFrame){
					tWorkFrame=this.tSelectFrame;
					if(!tWorkFrame.data)return;
					if(tWorkFrame.data.type==3){
						tPropsO=tWorkFrame.data.props;
						TimeLinePanel.instance.aniData.removeNodeFrameByNodeID(tPropsO.target,tPropsO.index);
						}else if(tWorkFrame.data.type==1){
						tPropsO=tWorkFrame.data.props;
						TimeLinePanel.instance.aniData.removeNodePropFrameByKeyAndFrame(tPropsO.target,tPropsO.key,tPropsO.index);
					}
					TimeLinePanel.instance.reFresh();
				}
			}
		}

		__proto.addListens=function(){}
		__proto.removeListens=function(){}
		__proto.removeHolder=function(){
			this._holder.removeSelf();
		}

		__proto.fakeFrameData=function(){
			var layerList;
			layerList=[];
			var frameList;
			frameList=[];
			var tFrameData;
			tFrameData=new TimeFrameData();
			tFrameData.frame=9;
			frameList.push(tFrameData);
			tFrameData=new TimeFrameData();
			tFrameData.frame=10;
			frameList.push(tFrameData);
			tFrameData=new TimeFrameData();
			tFrameData.frame=34;
			frameList.push(tFrameData);
			tFrameData=new TimeFrameData();
			tFrameData.frame=79;
			frameList.push(tFrameData);
			layerList.push([]);
			layerList.push(frameList);
			layerList.push([]);
			layerList.push([]);
			this.layerDataList=layerList;
		}

		__proto.cursorMouseDown=function(e){
			if(!e||e.type=="mousedown"){
				var option;
				option={};
				option.area=new Rectangle(0,this.timeCursor.y,this.width,0);
				this.preMouseX=Laya.stage.mouseX;
				this.preCursourX=this.timeCursor.x;
				this.timeCursor.startDrag(option.area);
				}else{
			}
		}

		__proto.cursorMove=function(){
			this.updateTimeCursorToMouse();
		}

		__proto.cursorDragEnd=function(e){
			this.updateTimeCursorToMouse();
			this.updateFocusFrame();
		}

		__proto.updateTimeCursorToMouse=function(){
			this.timeCursor.x=this.preCursourX+Laya.stage.mouseX-this.preMouseX;
			this.selectFrame=this.getFrameByX(this.timeCursor.x);
		}

		__proto.getFrameByX=function(xPos){
			return this.lineScrollX+Math.floor(xPos/TimeGrid.frameWidth);
		}

		__proto.getLayerByY=function(yPos){
			return this.lineScrollY+Math.floor(yPos/TimeGrid.frameHeight);
		}

		__proto.updateFocusFrame=function(){
			this.removeHolder();
			this.lineClick(null,false);
		}

		__proto.lineClick=function(e,fromMouse){
			(fromMouse===void 0)&& (fromMouse=true);
			var tType;
			if(fromMouse){
				tType=e.type;
				}else{
				tType="NOTMOUSE";
			}
			this._isDragSelect=false;
			if(fromMouse){
				var mousePoint;
				mousePoint=DisControlTool.getMousePoint(this.lineLayer);
				this.clickLayer=this.getLayerByY(mousePoint.y);
				this.clickFrame=this.getFrameByX(mousePoint.x);
			};
			var tFrame;
			tFrame=this.frameDic[this.clickLayer+"_"+this.clickFrame];
			if(fromMouse&&tFrame&&this.isTimeFrameSelected(tFrame)&&this.selectFrames.length>1&&fromMouse){
				if(tType=="rightmousedown"){
					MenuManager.showMenu("删除选中的帧",this,this.onEmunSelect);
					return;
				}
			}
			if(!tFrame||!this.isTimeFrameSelected(tFrame)||tType!="mousedown"){
				if(fromMouse)
					this.clearSelectFrames();
			}
			if(this.selectFrames.length>0&&tType=="mousedown"){
				this.beginDragSelectFrames();
				return;
			}
			if(fromMouse){
				this.selectFrame=this.clickFrame;
				this.event("TIMELINE_CLICKFRAME",[this.clickLayer,this.clickFrame]);
			}
			if(!tFrame){
				if(this._holder.parent&&this.getLayerByY(this._holder.y)==this.clickLayer&&this.getFrameByX(this._holder.x)==this.clickFrame){
					tFrame=this._holder;
				}
			}
			this.removeHolder();
			if(tFrame){
				if(tFrame.data.type==2){
					this.frameLayer.addChild(this._holder);
					if(!this.tempFrameData.isDirectory&&tType=="rightmousedown"){
						MenuManager.showMenu("转换为关键帧",this,this.onEmunSelect);
					}
					return;
				}
				if(tFrame.data.type==3){
					if(this.tSelectFrame)this.tSelectFrame.isSelect=false;
					this.tSelectFrame=tFrame;
					this.tSelectFrame.isSelect=true;
					this.tempFrameData.target=tFrame.data.props.target;
					this.tempFrameData.isDirectory=true;
					FramePropPanel.instance.setNodeData(this.tempFrameData);
					if(tType=="rightmousedown"){
						MenuManager.showMenu("批量删除帧",this,this.onEmunSelect);
						}else{
						if(tFrame.data.frame!=0){
							this.offFrameDragEvents(tFrame);
							tFrame.on("dragend",this,this.frameDragEnd,[tFrame]);
							var option;
							option={};
							option.area=new Rectangle(0,tFrame.y,this.width,0);
							if(fromMouse){
								tFrame.startDrag(option.area);
							}
						}
					}
					return;
				}
				this.removeHolder();
				if(tType=="mousedown"){
					if(this.tSelectFrame)this.tSelectFrame.isSelect=false;
					this.tSelectFrame=tFrame;
					this.tSelectFrame.isSelect=true;
					if(tFrame.data.frame!=0&&fromMouse){
						this.offFrameDragEvents(tFrame);
						tFrame.on("dragend",this,this.frameDragEnd,[tFrame]);
						option={};
						option.area=new Rectangle(0,tFrame.y,this.width,0);
						tFrame.startDrag(option.area);
					}
					}else if(tType=="rightmousedown"){
					if(this.tSelectFrame)this.tSelectFrame.isSelect=false;
					this.tSelectFrame=tFrame;
					this.tSelectFrame.isSelect=true;
					if(tFrame.data){
						if(tFrame.data.props.tween){
							MenuManager.showMenu("删除帧,删除Tween",this,this.onEmunSelect);
							}else{
							MenuManager.showMenu("删除帧,添加Tween",this,this.onEmunSelect);
						}
					}
				}
				if(tType=="NOTMOUSE"){
					if(this.tSelectFrame)this.tSelectFrame.isSelect=false;
					this.tSelectFrame=tFrame;
					tFrame.isSelect=true;
				}
				FramePropPanel.instance.setFrameData(tFrame.data);
				}else{
				this.clearSelectFrames();
				if(tType=="rightmousedown"){
					this.startRecDrag();
					return;
				}
				if(this.tSelectFrame)this.tSelectFrame.isSelect=false;
				if(this.clickLayer<this.layerCount&&this.clickFrame<this.frameCount){
					this.frameLayer.addChild(this._holder);
					this._holder.x=this.getXByFrame(this.clickFrame);
					this._holder.y=this.getYByLayer(this.clickLayer);
					var propData;
					propData=this.layerDataList[this.clickLayer];
					if(!propData.isDirectory){
						this.tempFrameData.key=propData.key;
						this.tempFrameData.target=propData.target;
						this.tempFrameData.value=TimeLinePanel.instance.aniData.targetAnimation.getNodeFrameProp(propData.target,this.clickFrame,propData.key);
						this.tempFrameData.isDirectory=false;
						FramePropPanel.instance.setNoKeyFrameData(this.tempFrameData);
						}else{
						this.tempFrameData.target=propData.target;
						this.tempFrameData.isDirectory=true;
						FramePropPanel.instance.setNodeData(this.tempFrameData);
					}
					this.tSelectFrame=this._holder;
					if(fromMouse){
						this.readyToDragSelect();
					}
					}else{
					FramePropPanel.instance.clearData();
				}
			}
		}

		/**开始选择（显示选择框）*/
		__proto.readyToDragSelect=function(){
			this.clearSelectFrames();
			this._isDragSelect=true;
			this._selectLineLayer.x=this.mouseX;
			this._selectLineLayer.y=this.mouseY;
			this.stage.on("mousemove",this,this.onStageMouseMove);
			this.stage.on("mouseup",this,this.onStageMouseUp);
		}

		/**移动组件*/
		__proto.onStageMouseMove=function(e){
			if (this._isDragSelect){
				if(Math.abs(this.mouseX-this._selectLineLayer.x)+Math.abs(this.mouseY-this._selectLineLayer.y)>5){
					this.removeHolder();
				}
				this._selectLineLayer.graphics.clear();
				Utils.drawDashedRect(this._selectLineLayer.graphics,this.mouseX-this._selectLineLayer.x,this.mouseY-this._selectLineLayer.y);
			}
		}

		/**处理鼠标点开*/
		__proto.onStageMouseUp=function(e){
			this.stage.off("mousemove",this,this.onStageMouseMove);
			this.stage.off("mouseup",this,this.onStageMouseUp);
			this.clearSelectFrames();
			if (this._isDragSelect){
				this._selectLineLayer.width=this.mouseX-this._selectLineLayer.x;this._selectLineLayer.height=this.mouseY-this._selectLineLayer.y;
				var rect=this._selectLineLayer.getBounds();
				var point;
				point=new Point();
				point.setTo(rect.x,rect.y);
				point=(this._selectLineLayer.parent).localToGlobal(point);
				point=this.frameLayer.globalToLocal(point);
				rect.x=point.x;
				rect.y=point.y;
				if (rect.width>0){
					var box=new Rectangle();
					box.copyFrom(rect);
					var compRect=new Rectangle();
					for (var i=0,n=this.frameLayer.numChildren;i < n;i++){
						var display=this.frameLayer.getChildAt(i);
						if ((display instanceof laya.editor.view.timeline.TimeFrame )&&display!=this._holder){
							compRect.copyFrom(display.getBounds());
							if(compRect.width==0||compRect.height==0){
								compRect.x=display.x;
								compRect.y=display.y;
							}
							if (box.intersects(compRect)){
								this.selectFrames.push(display);
								display.isSelect=true;
							}
						}
					}
				}
				this._selectLineLayer.graphics.clear();
			}
		}

		__proto.selectFramesByArr=function(frameList){
			var i=0,len=0;
			len=frameList.length;
			var tFrame;
			for(i=0;i<len;i++){
				tFrame=frameList[i];
				this.selectFrames.push(tFrame);
				tFrame.isSelect=true;
			}
		}

		__proto.isTimeFrameSelected=function(frame){
			return this.selectFrames.indexOf(frame)>=0;
		}

		__proto.clearSelectFrames=function(){
			var i=0,len=0;
			len=this.selectFrames.length;
			for(i=0;i<len;i++){
				this.selectFrames[i].isSelect=false;
			}
			this.selectFrames.length=0;
		}

		__proto.startRecDrag=function(){
			this.preStageMouseX=Laya.stage.mouseX;
			this.preScrollValue=TimeLinePanel.instance.mHScroll.value;
			this.clearRightMouseEvents();
			Laya.stage.on("mousemove",this,this.rightMouseMove);
			Laya.stage.on("rightmouseup",this,this.rightMouseUp);
		}

		__proto.rightMouseMove=function(){
			var newValue=NaN;
			newValue=this.preScrollValue-Laya.stage.mouseX+this.preStageMouseX;
			var bar;
			bar=TimeLinePanel.instance.mHScroll;
			if(newValue<bar.min)newValue=bar.min;
			if(newValue>bar.max)newValue=bar.max;
			bar.value=newValue;
		}

		__proto.rightMouseUp=function(){
			this.clearRightMouseEvents();
		}

		__proto.clearRightMouseEvents=function(){
			Laya.stage.off("mousemove",this,this.rightMouseMove);
			Laya.stage.off("rightmouseup",this,this.rightMouseUp);
		}

		__proto.getNoSameSelectFrameList=function(){
			var rst;
			rst=[];
			if(this.selectFrames.length<1)return rst;
			var i=0,len=0;
			var tFrame;
			len=this.selectFrames.length;
			for(i=0;i<len;i++){
				tFrame=this.selectFrames[i];
				if(!this.hasParentInList(tFrame,this.selectFrames)){
					rst.push(tFrame);
				}
			}
			return rst;
		}

		__proto.multiFrameDragEnd=function(frames){
			if(frames.length<1)return;
			var i=0,len=0;
			var tFrame;
			len=this.selectFrames.length;
			var adptFrames=[];
			tFrame=this.selectFrames[0];
			var newIndex=0;
			newIndex=this.getFrameByX(tFrame.x);
			var type=0;
			type=newIndex-tFrame.data.frame;
			for(i=0;i<len;i++){
				tFrame=this.selectFrames[i];
				this.offFrameDragEvents(tFrame);
				this.adptFramePos(tFrame);
				if(!this.hasParentInList(tFrame,this.selectFrames)){
					adptFrames.push(tFrame);
				}
			}
			if(type==0){
				return;
			}
			len=adptFrames.length;
			adptFrames.sort(this.sortFrameFun);
			if(type>0){
				adptFrames=adptFrames.reverse();
			}
			for(i=0;i<len;i++){
				tFrame=adptFrames[i];
				this.dealFrameDragEnd(tFrame);
			}
			this.recordSelectFrames();
			this.clearSelectFrames();
			this._isMultiDragEndRefresh=true;
			TimeLinePanel.instance.reFresh();
		}

		__proto.recordSelectFrames=function(){
			ObjectTools$1.clearObj(this._selectFramesInfo);
			var i=0,len=0;
			len=this.selectFrames.length;
			var tFrame;
			var tLayer=0;
			var tFrameID=0;
			for(i=0;i<len;i++){
				tFrame=this.selectFrames[i];
				tLayer=this.getLayerByY(tFrame.y);
				tFrameID=this.getFrameByX(tFrame.x);
				this._selectFramesInfo[tLayer+"_"+tFrameID]=true;
			}
		}

		__proto.sortFrameFun=function(frameA,frameB){
			return frameA.data.frame-frameB.data.frame;
		}

		__proto.adptFramePos=function(frame){
			frame.x=this.getXByFrame(this.getFrameByX(frame.x));
		}

		__proto.hasParentInList=function(tFrame,frames){
			if(tFrame.data.type==3)return false;
			var i=0,len=0;
			var tPFrame;
			len=frames.length;
			var tTarget=0;
			tTarget=tFrame.data.props.target;
			for(i=0;i<len;i++){
				tPFrame=frames[i];
				if(tPFrame.data.type==3&&tPFrame.data.props.target==tTarget){
					return true;
				}
			}
			return false;
		}

		__proto.beginDragSelectFrames=function(){
			var i=0,len=0;
			var tFrame;
			len=this.selectFrames.length;
			var option;
			for(i=0;i<len;i++){
				tFrame=this.selectFrames[i];
				this.offFrameDragEvents(tFrame);
				if(i==0){
					tFrame.on("dragend",this,this.multiFrameDragEnd,[this.selectFrames]);
				}
				option={};
				option.area=new Rectangle(0,tFrame.y,this.width,0);
				tFrame.startDrag(option.area);
			}
		}

		__proto.offFrameDragEvents=function(tFrame){
			tFrame.off("dragend",this,this.multiFrameDragEnd);
			tFrame.off("dragend",this,this.frameDragEnd);
			tFrame.off("dragstart",this,this.frameDragStart);
		}

		__proto.frameDragStart=function(frame){
			this.removeHolder();
		}

		__proto.frameDragEnd=function(frame){
			this.offFrameDragEvents(frame);
			var layer=0;
			layer=this.getLayerByY(frame.y);
			this.selectFrame=this.getFrameByX(frame.x);
			frame.x=this.getXByFrame(this.selectFrame);
			if(!frame.data)return;
			if(frame.data.frame==this.selectFrame)return;
			if(frame.data.frame==0){
				var newFrameData;
				frame.data.frame=this.selectFrame;
				newFrameData=TreeData.addFrame(this.layerDataList[layer],0,ObjectTools$1.copyObj(frame.data.props));
				var newFrame;
				newFrame=new TimeFrame();
				newFrame.setData(newFrameData);
				frame.parent.addChild(newFrame);
				newFrame.y=frame.y;
				newFrame.x=this.getXByFrame(0);
				}else{
			};
			var tNodeData;
			tNodeData=frame.data.props;
			if(frame.data.type==3){
				TimeLinePanel.instance.aniData.moveNodeFrameTo(tNodeData.target,tNodeData.index,this.selectFrame);
				}else{
				TimeLinePanel.instance.aniData.moveNodePropFrameTo(tNodeData.target,tNodeData.key,tNodeData.index,this.selectFrame);
			}
			TimeLinePanel.instance.reFresh();
		}

		//Notice.notify(IDEEvent.TIMELINE_CHANGED);
		__proto.dealFrameDragEnd=function(frame){
			var newFrameIndex=this.getFrameByX(frame.x);
			var layer=0;
			layer=this.getLayerByY(frame.y);
			if(frame.data.frame==newFrameIndex)return;
			if(frame.data.frame==0){
				var newFrameData;
				frame.data.frame=newFrameIndex;
				newFrameData=TreeData.addFrame(this.layerDataList[layer],0,ObjectTools$1.copyObj(frame.data.props));
				var newFrame;
				newFrame=new TimeFrame();
				newFrame.setData(newFrameData);
				frame.parent.addChild(newFrame);
				newFrame.y=frame.y;
				newFrame.x=this.getXByFrame(0);
				}else{
			};
			var tNodeData;
			tNodeData=frame.data.props;
			if(frame.data.type==3){
				TimeLinePanel.instance.aniData.moveNodeFrameTo(tNodeData.target,tNodeData.index,newFrameIndex);
				}else{
				TimeLinePanel.instance.aniData.moveNodePropFrameTo(tNodeData.target,tNodeData.key,tNodeData.index,newFrameIndex);
			}
		}

		__proto.updateCursor=function(){
			if(this.selectFrame<this.lineScrollX||this.selectFrame>this.lineScrollX+this.xCount){
				this.timeCursor.visible=false;
				}else{
				this.timeCursor.visible=true;
				this.timeCursor.x=this.getXByFrame(this.selectFrame);
				this.timeCursor.setFrame(this.selectFrame);
			}
			Notice.notify("TimeLineFrameSelected",[this.selectFrame]);
		}

		__proto.getFramePos=function(layer,frame){
			TimeGrid.framePos.x=this.getXByFrame(frame);
			TimeGrid.framePos.y=this.getYByLayer(layer);
			return TimeGrid.framePos;
		}

		__proto.getXByFrame=function(frame){
			return (frame-this.lineScrollX)*TimeGrid.frameWidth+this.lineStartPos;
		}

		__proto.getYByLayer=function(layer){
			return (layer-this.lineScrollY)*TimeGrid.frameHeight;
		}

		__proto.changeSize=function(){
			laya.ui.Component.prototype.changeSize.call(this);
			this.adptToSize();
		}

		__proto.adptToSize=function(){
			var rec;
			rec=this.scrollRect;
			rec.width=this.width;
			rec.height=this.height;
			this.titleLayer.width=this.width;
			this.lineLayer.width=this.width;
			this.lineLayer.height=this.height-this.lineLayer.y;
			this.timeCursor.sizeTo(this.lineLayer.height);
			this.renderData();
		}

		__proto.changeFrameWidth=function(newWidth){
			if(TimeGrid.frameWidth==newWidth)return;
			TimeGrid.frameWidth=newWidth;
			this.renderData();
		}

		__proto.setHScrollValue=function(value){
			this.lineScrollX=Math.floor(value);
			this.renderData();
		}

		__proto.setVScrollValue=function(value){
			this.lineScrollY=Math.floor(value);
			this.renderData();
		}

		__proto.setData=function(layerList){
			if(!layerList){
				this.frameLayer.removeChildren();
				this.lineLayer.removeChildren();
				var g=this.lineLayer.graphics;
				g.clear();
				return;
			}
			this.layerDataList=layerList;
			this.renderData();
		}

		__proto.renderData=function(){
			this.clearSelectFrames();
			this.lineStartPos=TimeGrid.frameWidth*0.5;
			this.drawTitle();
			this.drawGrids();
			this.updateCursor();
			this.renderItems();
		}

		// private var frameIndexDic:Object={};
		__proto.renderItems=function(){
			var i=0,len=0;
			var tFrame;
			for(i=this.frameLayer.numChildren-1;i>=0;i--){
				tFrame=this.frameLayer.getChildAt(i);
				if((tFrame instanceof laya.editor.view.timeline.TimeFrame )){
					if(tFrame!=this._holder)
						tFrame.recover();
				}
			}
			ObjectTools$1.clearObj(this.frameDic);
			this.frameLayer.removeChildren();
			if(!this.layerDataList)return;
			var layerStart=0;
			var layerMax=0;
			layerStart=this.lineScrollY;
			layerMax=layerStart+this.yCount+1;
			var toSelectList=[];
			for(i=layerStart;i<layerMax;i++){
				this.renderLayerData(i,toSelectList);
			}
			Laya.timer.once(1000,this,this.clearSelectInfo);
			this.selectFramesByArr(toSelectList);
		}

		__proto.clearSelectInfo=function(){
			this._isMultiDragEndRefresh=false;
			ObjectTools$1.clearObj(this._selectFramesInfo);
		}

		__proto.renderLayerData=function(layer,toSelects){
			if(!this.layerDataList||!this.layerDataList[layer])return;
			var frameStart=0;
			var frameMax=0;
			var i=0;
			frameStart=this.lineScrollX;
			frameMax=frameStart+this.xCount+1;
			var dataO;
			dataO=this.layerDataList[layer];
			var frameList;
			var isNode=false;
			isNode=dataO.isDirectory;
			if(isNode){
				frameList=dataO.keyFrames;
				}else{
				frameList=dataO.path;
			};
			var len=0;
			len=frameList.length;
			var tFrame;
			var tData;
			var tY=NaN;
			tY=this.getYByLayer(layer);
			var frameO;
			var g;
			g=this.lineLayer.graphics;
			var preIndex=0;
			preIndex=-1;
			var frameType=0;
			frameType=isNode?3:1;
			var tg=this.titleLayer.graphics;
			for(i=0;i<len;i++){
				frameO=frameList[i];
				tData=TimeFrameData.create(frameO.index,frameO,frameType);
				if(preIndex>=0){
					g.drawLine(this.getXByFrame(preIndex),tY+13,this.getXByFrame(frameO.index),tY+13,"#cbcbcb");
				}
				if(tData.props.tween){
					preIndex=tData.frame;
					}else{
					preIndex=-1;
				}
				if(tData.frame<frameStart)continue ;
				if(tData.frame>frameMax)break ;
				tFrame=Pool.getItemByClass("TimeFrame",TimeFrame);
				tFrame.setData(tData);
				tFrame.pos(this.getXByFrame(tData.frame),tY);
				this.frameLayer.addChild(tFrame);
				if(this._selectFramesInfo[layer+"_"+tData.frame]&&this._isMultiDragEndRefresh){
					toSelects.push(tFrame);
				}
				if(tFrame.isSelect){
					this.tSelectFrame=tFrame;
					if(tFrame.data.type!=3){
						FramePropPanel.instance.setFrameData(tFrame.data);
						}else{
						FramePropPanel.instance.setNodeData(this.tempFrameData);
					}
				}
				this.frameDic[layer+"_"+tData.frame]=tFrame;
			}
		}

		/**
		*画标题部分
		*
		*/
		__proto.drawTitle=function(){
			var i=0,len=0;
			var g=this.titleLayer.graphics;
			g.clear();
			this.recoverTopFrame(this.topLayer);
			var tX=NaN;
			tX=0;
			tX=this.lineStartPos;
			var startI=NaN;
			startI=this.lineScrollX;
			var maxX=NaN;
			maxX=tX+this.titleLayer.width;
			var mY=0;
			mY=TimeGrid.titleHeight;
			var top;
			for(i=startI;tX<maxX;i++){
				if(i%this.bigLine==0){
					g.drawLine(tX,mY+this.lineDY,tX,mY-10+this.lineDY,"#009999",1);
					g.fillText(i+"",tX,2,null,StyleConsts.TimelineTitleTxtColor,"center");
					}else{
					g.drawLine(tX,mY+this.lineDY,tX,mY-5+this.lineDY,"#006666",1);
				}
				if(this.keyIndexDic&&this.keyIndexDic[i]){
					top=this.getATopFrame();
					top.frame=i;
					this.topLayer.addChild(top);
					top.pos(tX,-3.5+1);
				}
				tX+=TimeGrid.frameWidth;
			}
		}

		__proto.recoverTopFrame=function(container){
			var i=0,len=0;
			var tChild;
			for(i=container.numChildren-1;i>=0;i--){
				tChild=container.getChildAt(i);
				if((tChild instanceof laya.editor.view.timeline.TopFrame )){
					tChild.removeSelf();
					Pool.recover("TopFrame",tChild);
				}
			}
		}

		__proto.getATopFrame=function(){
			var rst;
			rst=Pool.getItemByClass("TopFrame",TopFrame);
			rst.on("mousedown",this,this.topFrameMouseDown,[rst]);
			rst.on("dragend",this,this.topFrameDragEnd,[rst]);
			rst.on("rightmousedown",this,this.topFrameRightMouseDown,[rst]);
			return rst;
		}

		__proto.topFrameMouseDown=function(frame){
			var option;
			option={};
			option.area=new Rectangle(0,frame.y,this.width,0);
			frame.startDrag(option.area);
		}

		__proto.topFrameRightMouseDown=function(frame){
			this.selectFrame=frame.frame;
			MenuManager.showMenu("删除本帧所有关键帧",this,this.onEmunSelect);
		}

		__proto.topFrameDragEnd=function(frame){
			var tFrame=this.getFrameByX(frame.x);
			frame.x=this.getXByFrame(tFrame);
			if(tFrame==frame.frame)return;
			TimeLinePanel.instance.aniData.moveFrameTo(null,frame.frame,tFrame);
			TimeLinePanel.instance.reFresh();
		}

		/**
		*画主体底图
		*
		*/
		__proto.drawGrids=function(){
			var i=0,len=0;
			this.lineLayer.removeChildren();
			var g=this.lineLayer.graphics;
			g.clear();
			var sx=NaN;
			sx=0;
			var startYI=0;
			startYI=this.lineScrollY;
			var maxY=NaN;
			maxY=this.lineLayer.height;
			var lineWidth=0;
			lineWidth=this.lineLayer.width;
			var tY=NaN;
			tY=0;
			var colorList=TimeLineStyles.FrameColors;
			for(i=startYI;tY<=maxY;i++){
				if(i>=this.layerCount)break ;
				g.drawRect(sx,tY,lineWidth,TimeGrid.frameHeight-2,colorList[i%3],"#222222",1);
				tY+=TimeGrid.frameHeight;
			};
			var tX=NaN;
			tX=this.scrollRect.x;
			var startI=NaN;
			startI=this.lineScrollX;
			tX=0;
			tX=this.lineStartPos;
			var lineHeight=NaN;
			lineHeight=tY-2;
			var maxX=NaN;
			maxX=tX+this.lineLayer.width;
			for(i=startI;tX<maxX;i++){
				if(i%this.bigLine==0){
					g.drawLine(tX,0,tX,lineHeight,"#343434",1);
					}else{
				}
				tX+=TimeGrid.frameWidth;
			}
		}

		__getset(0,__proto,'xCount',function(){
			return Math.floor(this.lineLayer.width/TimeGrid.frameWidth);
		});

		__getset(0,__proto,'selectFrame',function(){
			return this._selectFrame;
			},function(value){
			this._selectFrame=value;
			if(this._selectFrame<0)this._selectFrame=0;
			TimeLinePanel.instance.frameTxt.text=this._selectFrame+"";
			this.clickFrame=value;
			this.updateCursor();
		});

		// public var layerCount:int=6;
		__getset(0,__proto,'layerCount',function(){
			if(!this.layerDataList)return 0;
			return this.layerDataList.length;
		});

		__getset(0,__proto,'startXRange',function(){
			return this.frameCount-Math.floor(this.lineLayer.width/TimeGrid.frameWidth);
		});

		__getset(0,__proto,'startYRange',function(){
			return this.layerCount-Math.floor(this.lineLayer.height/TimeGrid.frameHeight);
		});

		__getset(0,__proto,'yCount',function(){
			return Math.floor(this.lineLayer.height/TimeGrid.frameHeight);
		});

		TimeGrid.NOTMOUSE="NOTMOUSE";
		TimeGrid.frameWidth=12;
		TimeGrid.frameHeight=29;
		TimeGrid.titleHeight=30;
		__static(TimeGrid,
		['framePos',function(){return this.framePos=new Point();}
		]);
		return TimeGrid;
	})(TimeGridUI)


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-12-7 上午10:20:12
	*/
	//class laya.editor.view.timeline.tree.TimeLineList extends laya.ide.ui.ListBase
	var TimeLineList=(function(_super){
		function TimeLineList(){
			TimeLineList.__super.call(this);
		}

		__class(TimeLineList,'laya.editor.view.timeline.tree.TimeLineList',_super);
		var __proto=TimeLineList.prototype;
		__proto.changeCells=function(){
			if (this._itemRender){
				for (var i=this._cells.length-1;i >-1;i--){
					this._cells[i].destroy();
				}
				this._cells.length=0;
				if(!this.scrollBar)return;
				var cell=this.createItem();
				var cellWidth=cell.width+this._spaceX;
				var cellHeight=cell.height+this._spaceY;
				if (this._repeatX < 1 && this._width > 0)this._repeatX2=Math.round(this._width / cellWidth);
				if (this._repeatY < 1 && this._height > 0)this._repeatY2=Math.round(this._height / cellHeight);
				var listWidth=this._width ? this._width :(cellWidth *this.repeatX-this._spaceX);
				var listHeight=this._height ? this._height :(cellHeight *this.repeatY-this._spaceY);
				this._cellSize=this._isVertical ? cellHeight :cellWidth;
				if (this._isVertical && this._scrollBar)this._scrollBar.height=listHeight;
				else if (!this._isVertical && this._scrollBar)this._scrollBar.width=listWidth;
				this.setContentSize(listWidth,listHeight);
				this._content.removeChildren();
				var numX=this._isVertical ? this.repeatX :this.repeatY;
				var numY=(this._isVertical ? this.repeatY :this.repeatX)+(this._scrollBar ? 1 :0);
				for (var k=0;k < numY;k++){
					for (var l=0;l < numX;l++){
						cell=this.createItem();
						cell.x=(this._isVertical ? l :k)*cellWidth;
						cell.y=(this._isVertical ? k :l)*cellHeight;
						cell.name="item"+(k *numX+l);
						this._content.addChild(cell);
						this.addCell(cell);
					}
				}
				if (this._array){
					this.array=this._array;
					this.runCallLater(this.renderItems);
				}
			}
		}

		__proto.freshUI=function(){
			this.array=this.array;
		}

		__proto.onScrollBarChange=function(e){
			this.runCallLater(this.changeCells);
			var scrollValue=Math.ceil(this._scrollBar.value);
			var lineX=(this._isVertical ? this.repeatX :this.repeatY);
			var lineY=(this._isVertical ? this.repeatY :this.repeatX);
			var index=scrollValue *lineX;
			if (index > this._startIndex){
				var num=index-this._startIndex;
				var down=true;
				var toIndex=this._startIndex+lineX *(lineY+1);
				this._isMoved=true;
				}else if (index < this._startIndex){
				num=this._startIndex-index;
				down=false;
				toIndex=this._startIndex-1;
				this._isMoved=true;
			}
			for (var i=0;i < num;i++){
				if (down){
					var cell=this._cells.shift();
					this._cells[this._cells.length]=cell;
					var cellIndex=toIndex+i;
					}else {
					cell=this._cells.pop();
					this._cells.unshift(cell);
					cellIndex=toIndex-i;
				};
				var pos=Math.ceil(cellIndex / lineX)*this._cellSize;
				this._isVertical ? cell.y=pos :cell.x=pos;
				this.renderItem(cell,cellIndex);
			}
			this._startIndex=index;
			if (this._isVertical)this._content.scrollRect.y=scrollValue*this._cellSize;
			else this._content.scrollRect.x=scrollValue*this._cellSize;
		}

		__proto.replaceScrollBar=function(value){
			if(this._scrollBar){
				this._scrollBar.removeSelf();
				this._scrollBar.offAll();
			}
			this.scrollBar=value;
			this.callLater(this.changeCells);
		}

		__proto.changeSize=function(){
			laya.ui.List.prototype.changeSize.call(this);
			if (this._scrollBar)
				Laya.timer.once(10,this,this.changeCells);
		}

		__getset(0,__proto,'scrollBar',_super.prototype._$get_scrollBar,function(value){
			if (this._scrollBar !=value){
				this._scrollBar=value;
				if (value){
					this._scrollBar.on("change",this,this.onScrollBarChange);
					this._isVertical=this._scrollBar.isVertical;
				}
			}
		});

		// hideScrollBar=_hideScrollBar;
		__getset(0,__proto,'array',_super.prototype._$get_array,function(value){
			this.runCallLater(this.changeCells);
			this._array=value || [];
			var length=this._array.length;
			this.totalPage=Math.ceil((length / (this.repeatX *this.repeatY))+0.5);
			this._selectedIndex=this._selectedIndex < length ? this._selectedIndex :length-1;
			this.startIndex=this._startIndex;
			if (this._scrollBar){
				var numX=this._isVertical ? this.repeatX :this.repeatY;
				var numY=this._isVertical ? this.repeatY :this.repeatX;
				var lineCount=Math.ceil(length / numX);
				if (this.totalPage > 1){
					this._scrollBar.scrollSize=1;
					this._scrollBar.thumbPercent=numY / lineCount;
					this._scrollBar.setScroll(0,(lineCount-numY+1),Math.ceil(this._startIndex / numX));
					this._scrollBar.target=this._content;
					}else {
					this._scrollBar.setScroll(0,0,0);
					this._scrollBar.target=this._content;
				}
			}
			this.event("ListChange",[value]);
		});

		return TimeLineList;
	})(ListBase)


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-12-7 上午10:20:44
	*/
	//class laya.editor.view.timeline.tree.TimeLineTree extends laya.ide.ui.NodeTree
	var TimeLineTree=(function(_super){
		function TimeLineTree(){
			TimeLineTree.__super.call(this);
		}

		__class(TimeLineTree,'laya.editor.view.timeline.tree.TimeLineTree',_super);
		var __proto=TimeLineTree.prototype;
		__proto.createChildren=function(){
			this.addChild(this._list=new TimeLineList());
			this._list.renderHandler=Handler.create(this,this.renderItem,null,false);
			this._list.repeatX=1;
			this._list.on("change",this,this.onListChange);
		}

		__getset(0,__proto,'mList',function(){
			return this._list;
		});

		return TimeLineTree;
	})(NodeTree)


	/**
	*节点树上用的List 支持多选
	*@author ww
	*@version 1.0
	*
	*@created 2015-11-13 上午11:27:36
	*/
	//class laya.ide.ui.ListEx extends laya.ide.ui.ListBase
	var ListEx=(function(_super){
		function ListEx(){
			this._selectIndexs=[];
			this._preIndex=0;
			this._preClickIndex=0;
			this.onlySameParentSelect=false;
			this.mutiSelectEnable=true;
			this._preNoShiftIndex=-1;
			this.changeCellStateH=null;
			this._selectItems=[];
			this._plainSelectList=[];
			ListEx.__super.call(this);
		}

		__class(ListEx,'laya.ide.ui.ListEx',_super);
		var __proto=ListEx.prototype;
		__proto.isIDSelected=function(id){
			return this._selectIndexs.indexOf(id)>=0;
		}

		__proto.setSelectList=function(selectList){
			this._selectIndexs=selectList;
			this.changeSelectStatus();
			if(this._selectIndexs&&this._selectIndexs.length>0){
				this._selectedIndex=selectList[0];
				this.scrollToIndex(this._selectIndexs[0]);
			}
		}

		__proto.getCellUnderMouse=function(maxLen){
			(maxLen===void 0)&& (maxLen=5);
			if(!this._cells||this._cells.length<1)return null;
			var mouseY=this.mouseY;
			var i=0,len=0;
			len=this._cells.length;
			var tCell;
			var mCell;
			for(i=0;i<len;i++){
				tCell=this._cells[i];
				if(tCell.y<=mouseY&&tCell.y+tCell.height>=mouseY){
					return tCell;
				}
				console.log(Math.abs(tCell.y-mouseY));
				if(Math.abs(tCell.y-mouseY)<maxLen){
					mCell=tCell;
				}
			}
			return mCell;
		}

		__proto.getParentByIndex=function(index){
			var item;
			item=this.getItem(index);
			if(item){
				return item.nodeParent;
			}
			return-1;
		}

		__proto.onCellMouse=function(e){
			if (e.type==="mousedown")this._isMoved=false;
			var cell=e.currentTarget;
			var index=this._startIndex+this._cells.indexOf(cell);
			var ctrl=e.nativeEvent.ctrlKey;
			var shift=e.nativeEvent.shiftKey;
			if (index < 0)return;
			if (e.type==="mousedown" || e.type==="rightmousedown"){
				this._preIndex=-1;
				this._preClickIndex=index;
				if(ctrl&&this.mutiSelectEnable){
					if(this.onlySameParentSelect){
						var tP=0;
						tP=this.tSelectParent;
						if(tP<=0||tP==this.getParentByIndex(index)){
							this.switchSelect(index);
						}
						}else{
						this.switchSelect(index);
					}
					}else{
					if(shift&&this.mutiSelectEnable){
					}else
					if(this.isIDSelected(index)){
						}else{
						this.clearSelect();
						if (this.selectEnable && !this._isMoved){
							this.selectedIndex=index;
							this._preIndex=index;
						}
						else this.changeCellState(cell,true,0);
					}
				}
			}else
			if (e.type==="click" || e.type==="rightclick"){
				var isShiftSelectSuccess=false;
				if(shift&&this.mutiSelectEnable){
					if(this.mutiSelectEnable){
						isShiftSelectSuccess=this.dealShiftSelect(index);
					}
				}
				else
				if(ctrl){
					}else{
					if(this.isIDSelected(index)&&index!=this._preIndex&&index==this._preClickIndex){
						if(this._selectIndexs.length==1&&this._selectIndexs[0]==index||e.type=="rightclick"){
							}else{
							this.clearSelect();
							this.changeSelectStatus();
							if (this.selectEnable && !this._isMoved)this.selectedIndex=index;
							else this.changeCellState(cell,true,0);
						}
					}
				}
				if(!isShiftSelectSuccess){
					if(this.isIDSelected(index)){
						this._preNoShiftIndex=index;
					}
				}
				}else if ((e.type==="mouseover" || e.type==="mouseout")&& !this.isIDSelected(index)){
				this.changeCellState(cell,e.type==="mouseover",0);
			}
			this.mouseHandler && this.mouseHandler.runWith([e,index]);
		}

		__proto.dealShiftSelect=function(index){
			if(this._preNoShiftIndex<0)return false;
			if(!this.isIDSelected(this._preNoShiftIndex))return false;
			var i=0,len=0;
			this.clearSelect();
			var min=0,max=0;
			if(index>this._preNoShiftIndex){
				min=this._preNoShiftIndex;
				max=index;
				}else{
				max=this._preNoShiftIndex;
				min=index;
			};
			var parent=0;
			parent=this.getParentByIndex(min);
			if(parent!=this.getParentByIndex(max))return false;
			for(i=min;i<=max;i++){
				if(this.getParentByIndex(i)==parent){
					this._selectIndexs.push(i);
				}
			}
			this.changeSelectStatus();
			return true;
		}

		__proto.reRender=function(){
			this.renderItems();
		}

		/**
		*@private
		*改变单元格的可视状态。
		*@param cell 单元格对象。
		*@param visable 是否显示。
		*@param index 单元格的属性 <code>index</code> 值。
		*/
		__proto.changeCellState=function(cell,visable,index){
			laya.ui.List.prototype.changeCellState.call(this,cell,visable,index);
			if(this.changeCellStateH){
				this.changeCellStateH.runWith([cell,visable,index]);
			}
		}

		__proto.changeSelectStatus=function(){
			for (var i=0,n=this._cells.length;i < n;i++){
				this.changeCellState(this._cells[i],this.isIDSelected(this._startIndex+i),1);
			}
		}

		__proto.renderItem=function(cell,index){
			if (index >=0 && index < this._array.length){
				cell.visible=true;
				cell.dataSource=this._array[index];
				this._$7_posCell(cell,index);
				}else {
				cell.visible=false;
				cell.dataSource=null;
			}
			this.event("render",[cell,index]);
			this.renderHandler && this.renderHandler.runWith([cell,index]);
		}

		__proto._$7_posCell=function(cell,cellIndex){
			if (!this._scrollBar)return;
			if (!this._isVertical)return;
			var lineX=(this._isVertical ? this.repeatX :this.repeatY);
			var lineY=(this._isVertical ? this.repeatY :this.repeatX);
			var pos=Math.floor(cellIndex / lineX)*this._cellSize;
			this._isVertical ? cell.y=pos :cell.x=pos;
		}

		__proto.getIndexByCell=function(cell){
			return this._array.indexOf(cell.dataSource);
		}

		__proto.clearSelect=function(autoChange){
			(autoChange===void 0)&& (autoChange=false);
			this._selectedIndex=-1;
			this._selectIndexs.length=0;
			if(autoChange){
				this.changeSelectStatus();
			}
		}

		__proto.switchSelect=function(index){
			var i=0;
			for(i=this._selectIndexs.length-1;i>=0;i--){
				if(index==this._selectIndexs[i]){
					this._selectIndexs.splice(i,1);
					this.changeSelectStatus();
					return;
				}
			}
			this._selectIndexs.push(index);
			this.changeSelectStatus();
		}

		__proto.addSelect=function(index){
			if(!this.isIDSelected(index)){
				this._selectIndexs.push(index);
			}
		}

		__getset(0,__proto,'selectedItem',function(){
			return _super.prototype._$get_selectedItem.call(this);
			},function(value){
			_super.prototype._$set_selectedItem.call(this,value);
		});

		__getset(0,__proto,'tSelectParent',function(){
			if(!this._selectIndexs||this._selectIndexs.length<1)return-1;
			var i=0,len=0;
			var item;
			return this.getParentByIndex(this._selectIndexs[0]);
		});

		__getset(0,__proto,'selectItems',function(){
			this._selectItems.length=0;
			var i=0,len=0;
			len=this._selectIndexs.length;
			var tItem;
			for(i=0;i<len;i++){
				tItem=this.getItem(this._selectIndexs[i]);
				if(tItem)
					this._selectItems.push(tItem);
			}
			return this._selectItems;
		});

		__getset(0,__proto,'plainSelectItems',function(){
			this._plainSelectList.length=0;
			var selectList;
			selectList=this.selectItems;
			var i=0,len=0;
			len=selectList.length;
			var tItem;
			var tItemParent;
			for(i=0;i<len;i++){
				tItem=selectList[i];
				if(selectList.indexOf(tItem.parent)<0){
					this._plainSelectList.push(tItem);
				}
			}
			return this._plainSelectList;
		});

		__getset(0,__proto,'selectedIndex',function(){
			return _super.prototype._$get_selectedIndex.call(this);
			},function(value){
			this.clearSelect();
			this.addSelect(value);
			this._selectedIndex=-1;
			_super.prototype._$set_selectedIndex.call(this,value);
		});

		ListEx.dealAbcKey=function(keyCode,list){
			if(!list)return;
			var key;
			key=KeyManager.getCharByCode(keyCode);
			key=key.toLowerCase();
			var i=0,len=0;
			var startI=0;
			startI=list.selectedIndex;
			if(startI<0)startI=0;
			var arr;
			arr=list.array;
			len=arr.length;
			var tLabel;
			for(i=startI+1;i<len;i++){
				if(arr[i])
					tLabel=arr[i]["label"];
				if(tLabel&&tLabel.charAt(0).toLowerCase()==key){
					list.selectedIndex=i;
					return;
				}
			}
			for(i=0;i<len;i++){
				if(arr[i])
					tLabel=arr[i]["label"];
				if(tLabel&&tLabel.charAt(0).toLowerCase()==key){
					list.selectedIndex=i;
					return;
				}
			}
		}

		return ListEx;
	})(ListBase)


	/**
	*...
	*@author ww
	*/
	//class laya.ide.ui.TreeEx extends laya.ide.ui.NodeTree
	var TreeEx=(function(_super){
		function TreeEx(){
			this._isDragUpdate=false;
			TreeEx.__super.call(this);
			this.enableDragingAuto();
			this.on("mouseout",this,this.stopDragUpdate);
			this.on("mouseup",this,this.stopDragUpdate);
		}

		__class(TreeEx,'laya.ide.ui.TreeEx',_super);
		var __proto=TreeEx.prototype;
		__proto.createChildren=function(){
			this.addChild(this._list=new ListEx());
			this._list.renderHandler=Handler.create(this,this.renderItem,null,false);
			this._list.repeatX=1;
			this._list.on("change",this,this.onListChange);
		}

		__proto.enableDragingAuto=function(){
			this.on("Draging_Hit",this,this.onDragHit);
		}

		__proto.onDragHit=function(){
			if (!DragManager.isDraging)return;
			if (DragManager.getDragType()=="LayoutRec" || DragManager.getDragType()=="LayoutTab")return;
			var mouseY=NaN;
			mouseY=this.mouseY;
			if(!this.scrollBar)return;
			this.startDragUpdate();
		}

		__proto.stopDragUpdate=function(){
			this._isDragUpdate=false;
			Laya.timer.clear(this,this._dragUpdateLoop);
		}

		__proto.startDragUpdate=function(){
			if(this._isDragUpdate)return;
			this._isDragUpdate=true;
			Laya.timer.loop(50,this,this._dragUpdateLoop);
		}

		__proto._dragUpdateLoop=function(){
			if(!this.scrollBar)return;
			var mouseY=NaN;
			mouseY=this.mouseY;
			if(mouseY<20){
				this.scrollBar.value-=10;
				return;
			}
			if(mouseY>this.height-20){
				this.scrollBar.value+=10;
				return;
			}
			this.stopDragUpdate();
		}

		/**
		*更新项列表，显示指定键名的数据项。
		*@param key 键名。
		*/
		__proto.filter=function(key){
			if (Boolean(key)){
				var result=[];
				this.__getFilterSource(this._source,result,key);
				this._list.array=result;
				}else {
				this._list.array=this.getArray();
			}
		}

		/**
		*@private
		*获取数据源中指定键名的值。
		*/
		__proto.__getFilterSource=function(array,result,key){
			key=key.toLocaleLowerCase();
			var item;
			for(var $each_item in array){
				item=array[$each_item];
				if (!item.isDirectory && String(item.label).toLowerCase().indexOf(key)>-1){
					item.x=0;
					if(result.indexOf(item)<0)
						result.push(item);
				}
				if (item.child && item.child.length > 0){
					this.__getFilterSource(item.child,result,key);
				}
			}
		}

		__getset(0,__proto,'mList',function(){
			return this._list;
		});

		TreeEx.onItemCellMouseOver=function(index,cell,tree){
			FocusManager.clearFocus();
			if (tree.mList.isIDSelected(index)){
				return;
			}
			if (!DragManager.isDraging)return;
			var dataO;
			dataO=cell.dataSource;
			if(dataO.isDirectory){
				FocusManager.showFocus(cell,1,true);
				}else{
				var type=RelativePos.getDisMouseRelativePos(cell,0.2);
				var target=cell;
				switch (type){
					case "up":
					case "down":
						FocusManager.showBorder(target,type,true,null,1);
						break ;
					case "center":
					case "left":
					case "right":
						FocusManager.showBorder(target,"down",true,null,1);
						break ;
					};
				var parentIndex=0;
				parentIndex=tree.getParentIndex(dataO);
				if(parentIndex>0){
					var parentCell;
					parentCell=tree.list.getCell(parentIndex);
					if(parentCell){
						FocusManager.showFocus(parentCell,1,false);
					}
				}
			}
		}

		return TreeEx;
	})(NodeTree)


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-2-29 下午3:07:35
	*/
	//class laya.ide.ui.TabEx extends laya.ui.Tab
	var TabEx=(function(_super){
		function TabEx(){
			this._otherBack=null;
			this.maxLen=-1;
			this._otherContainer=null;
			this._otherBtn=null;
			TabEx.__super.call(this);
			this._otherContainer=new Box();
			this._otherContainer.mouseEnabled=true;
			this._otherBtn=new Button();
			this._otherBtn.skin="comp/button.png";
			this._otherBtn.width=20;
			this._otherBtn.on("click",this,this.switchOtherContainer);
			this._otherContainer.on("click",this,this.hideOtherContainer);
		}

		__class(TabEx,'laya.ide.ui.TabEx',_super);
		var __proto=TabEx.prototype;
		__proto.switchOtherContainer=function(){
			if(this._otherContainer.parent){
				this.hideOtherContainer();
				}else{
				this.showOtherContainer();
			}
		}

		__proto.hideOtherContainer=function(){
			this._otherContainer.removeSelf();
			Laya.stage.off("click",this,this.hideOtherContainer);
		}

		__proto.showOtherContainer=function(){
			var tPoint;
			tPoint=Point.TEMP;
			tPoint.setTo(this._otherBtn.width,this._otherBtn.height);
			tPoint=this._otherBtn.localToGlobal(tPoint);
			Laya._currentStage.addChild(this._otherContainer);
			this._otherContainer.pos(tPoint.x-this._otherContainer.width,tPoint.y);
			Laya.timer.once(100,this,this.addRemoveEvents);
		}

		__proto.addRemoveEvents=function(){
			if(!this._otherContainer.parent)return;
			Laya.stage.off("click",this,this.hideOtherContainer);
			Laya.stage.on("click",this,this.hideOtherContainer);
		}

		__proto.addItem=function(item,autoLayOut){
			(autoLayOut===void 0)&& (autoLayOut=true);
			var rst=0;
			rst=laya.ui.UIGroup.prototype.addItem.call(this,item,autoLayOut);
			this.updateUI();
			if(this.maxLen<0)return rst;
			if((item).parent==this._otherContainer){
				this.itemClick(rst);
			}
			return this._items.indexOf(item);
		}

		__proto.delItem=function(item,autoLayOut){
			(autoLayOut===void 0)&& (autoLayOut=true);
			var index=this._items.indexOf(item);
			if (index !=-1){
				var display=item;
				this.removeChild(display);
				for (var i=index+1,n=this._items.length;i < n;i++){
					var child=this._items [i];
					child.name="item"+(i-1);
					if (autoLayOut){
						if (this._direction=="horizontal"){
							child.x-=display.width+this._space;
							}else {
							child.y-=display.height+this._space;
						}
					}
				}
				this._items.splice(index,1);
				this.initItems();
				if (this._selectedIndex >-1){
					var newIndex=0;
					newIndex=this._selectedIndex < this._items.length ? this._selectedIndex :(this._selectedIndex-1);
					this._selectedIndex=99;
					this.selectedIndex=newIndex;
				}
			}
			this.updateUI();
		}

		__proto.switchItemToDis=function(index){
			var tItem;
			tItem=this._items[index];
			this._items.splice(index,1);
			this._items.unshift(tItem);
			this.reNameItems();
			this.initItems();
			this.updateUI();
			return this._items.indexOf(tItem);
		}

		__proto.reNameItems=function(){
			var i=0,len=0;
			var tItem;
			len=this._items.length;
			for(i=0;i<len;i++){
				tItem=this._items [i];
				tItem.name="item"+i;
			}
		}

		__proto.itemClick=function(index){
			laya.ui.UIGroup.prototype.itemClick.call(this,index);
		}

		__proto.updateUI=function(){
			if(this.maxLen<0)return;
			var maxUILen=NaN;
			maxUILen=this.maxLen-this._otherBtn.width-2;
			var i=0,len=0;
			len=this._items.length;
			var _otherList;
			_otherList=[];
			var preItem;
			var tItem;
			var tX=NaN;
			var tY=NaN;
			tX=0;
			tY=0;
			for(i=0;i<len;i++){
				tItem=this._items [i];
				tItem.pos(tX,tY);
				this.addChild(tItem);
				if (this._direction=="horizontal"){
					tX=tItem.x+tItem.width+this._space;
					if(tX>maxUILen){
						_otherList.push(tItem);
					}
					}else {
					tY=tItem.y+tItem.height+this._space;
				}
			}
			if(_otherList.length>0){
				this.addChild(this._otherBtn);
				this._otherBtn.pos(this.maxLen-this._otherBtn.width,0);
				}else{
				this._otherBtn.removeSelf();
			}
			this.setUpOtherList(_otherList);
		}

		__proto.setUpOtherList=function(_items){
			if(!this._otherBack){
				this._otherBack=new Image();
				this._otherBack.skin="view/bg_menu.png";
			}
			this._otherContainer.removeChildren();
			this._otherBack.size(10,10);
			this._otherContainer.addChild(this._otherBack);
			var i=0,len=0;
			len=_items.length;
			var tItem;
			var tX=NaN;
			var tY=NaN;
			tX=0;
			tY=0;
			for(i=0;i<len;i++){
				tItem=_items[i];
				tItem.pos(tX,tY);
				this._otherContainer.addChild(tItem);
				tY=tItem.y+tItem.height+this._space;
			}
			this._otherBack.size(this._otherContainer.width,this._otherContainer.height);
		}

		__proto.initItems=function(){
			if(this.maxLen>0){
				if(this._items){
					var i=0,len=0;
					len=this._items.length;
					var tItem;
					for(i=0;i<len;i++){
						tItem=this._items [i];
						this.addChild(tItem);
					}
				}
			}
			laya.ui.UIGroup.prototype.initItems.call(this);
		}

		__getset(0,__proto,'selectedIndex',_super.prototype._$get_selectedIndex,function(value){
			if(this.maxLen<0){
				_super.prototype._$set_selectedIndex.call(this,value);
				return;
			};
			var tItem;
			tItem=this._items [value];
			if(tItem){
				if(tItem.parent==this._otherContainer){
					var newIndex=0;
					newIndex=this.switchItemToDis(value);
					this._selectedIndex=-2;
					_super.prototype._$set_selectedIndex.call(this,newIndex);
					return;
				}
			}
			this.setSelect(this._selectedIndex,false);
			this._selectedIndex=-2;
			_super.prototype._$set_selectedIndex.call(this,value);
		});

		return TabEx;
	})(Tab)


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-8-12 下午2:46:09
	*/
	//class laya.rendercanvas.XMLEditorSprite extends laya.rendercanvas.IFrameSprite
	var XMLEditorSprite=(function(_super){
		function XMLEditorSprite(){
			this.contentWindow=null;
			this.codeStr="";
			this.editor=null;
			this.isOned=false;
			this.findStr=null;
			var _$this=this;
			XMLEditorSprite.__super.call(this);
			this.disableAutoControl=true;
			var me=this;
			this.div.addEventListener("load",function(){
				_$this.contentWindow=_$this.div.contentWindow;
				_$this.editor=_$this.contentWindow.editor;
				_$this.setCode(_$this.codeStr);
				_$this.find(_$this.findStr);
				if(!_$this.isOned){
					_$this.editor.getSession().on('change',function(e){
						me.event("txtchange");
					});
					_$this.editor.commands.addCommand({
						name:'myCommand',
						bindKey:{win:'Ctrl-S',mac:'Command-S'},
						exec:function (editor){
							me.event("editorsave");
						}
					});
				}
			},false);
			var path;
			path=FileManager.getAppPath("h5/plugin/ace/index.html");
			this.setUrl(path);
		}

		__class(XMLEditorSprite,'laya.rendercanvas.XMLEditorSprite',_super);
		var __proto=XMLEditorSprite.prototype;
		__proto.setCode=function(code){
			this.codeStr=code;
			if (this.editor){
				this.editor.setValue(code);
				this.editor.moveCursorTo(0);
			}
		}

		__proto.getCode=function(){
			return this.editor?this.editor.getValue():this.codeStr;
		}

		__proto.find=function(str){
			this.findStr=str;
			if(!str)return;
			if(this.editor){
				this.editor.find(str);
			}
		}

		__proto.select=function(start,end){
			if(!this.editor)return;
			var i;
			i={};
			i.start=start;
			i.end=end;
			this.editor.selection.setRange(i);
		}

		return XMLEditorSprite;
	})(IFrameSprite)


	/**提示框
	*@author yung
	*/
	//class laya.editor.comonents.Alert extends laya.editor.ui.comp.AlertUI
	var Alert=(function(_super){
		function Alert(){Alert.__super.call(this);;
		};

		__class(Alert,'laya.editor.comonents.Alert',_super);
		var __proto=Alert.prototype;
		__proto.start=function(msg,title){
			this.titleLbl.text=title;
			this.msgLbl.text=msg;
			this.popup();
		}

		__getset(1,Alert,'instance',function(){
			return Alert._instance?Alert._instance:Alert._instance=new Alert();
		},laya.editor.ui.comp.AlertUI._$SET_instance);

		Alert.show=function(msg,title){
			(title===void 0)&& (title="提示");
			if(title=="提示"){
				title=Sys.lang("提示");
			}
			if (SystemSetting.isCMDVer){
				console.log(msg,title);
				return;
			}
			Alert.instance.start(msg,title);
		}

		Alert._instance=null
		return Alert;
	})(AlertUI)


	/**确认框
	*@author yung
	*/
	//class laya.editor.comonents.Confirm extends laya.editor.ui.comp.ConfirmUI
	var Confirm=(function(_super){
		function Confirm(){
			this._handler=null;
			this._args=null;
			Confirm.__super.call(this);
			this.on("keydown",this,this.onKeyDown);
		}

		__class(Confirm,'laya.editor.comonents.Confirm',_super);
		var __proto=Confirm.prototype;
		__proto.start=function(msg,title,handler,args){
			this.titleLbl.text=title;
			this.msgLbl.text=msg;
			this._handler=handler;
			this._args=args;
			this.popup();
			KeyManager.setNewFocus(this);
		}

		__proto.close=function(type){
			laya.ui.Dialog.prototype.close.call(this,type);
			if (this._handler !=null){
				var data=[type=="sure",type];
				this._handler.apply(null,this._args ? this._args.concat(data):data);
			}
			KeyManager.restoreFocus();
		}

		__proto.onKeyDown=function(e){
			switch(e.keyCode){
				case 13:
					this.close("sure");
					break ;
				case 27:
					this.close("cancel");
					break ;
				}
		}

		__getset(1,Confirm,'instance',function(){
			return Confirm._instance ? Confirm._instance :Confirm._instance=new Confirm();
		},laya.editor.ui.comp.ConfirmUI._$SET_instance);

		Confirm.show=function(msg,title,handler,args,okName,cancelName){
			if(!okName)okName=Sys.lang("确定");
			if(!cancelName)cancelName=Sys.lang("取消");
			Confirm.instance.okBtn.label=okName;
			Confirm.instance.cancelBtn.label=cancelName;
			Confirm.instance.start(msg,title,handler,args);
		}

		Confirm._instance=null
		return Confirm;
	})(ConfirmUI)


	/**等待提示框
	*@author yung
	*/
	//class laya.editor.comonents.Waiting extends laya.editor.ui.comp.WaitingUI
	var Waiting=(function(_super){
		function Waiting(){Waiting.__super.call(this);;
		};

		__class(Waiting,'laya.editor.comonents.Waiting',_super);
		var __proto=Waiting.prototype;
		__proto.start=function(msg,title){
			this.titleLbl.text=title;
			this.msgLbl.text=msg;
			this.popup();
		}

		__getset(1,Waiting,'instance',function(){
			return Waiting._instance ? Waiting._instance :Waiting._instance=new Waiting();
		},laya.editor.ui.comp.WaitingUI._$SET_instance);

		Waiting.show=function(msg,title){
			Waiting.instance.start(msg,title);
		}

		Waiting.hide=function(){
			Waiting.instance.close();
		}

		Waiting._instance=null
		return Waiting;
	})(WaitingUI)


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-12-15 上午9:55:29
	*/
	//class laya.editor.view.ani.AnimationDesign extends laya.editor.core.Design
	var AnimationDesign=(function(_super){
		function AnimationDesign(){
			this._frame=0;
			AnimationDesign.__super.call(this);
		}

		__class(AnimationDesign,'laya.editor.view.ani.AnimationDesign',_super);
		var __proto=AnimationDesign.prototype;
		__proto.addListens=function(){
			_super.prototype.addListens.call(this);
			Notice.listen("TimeLineFrameSelected",this,this.frameSelected,null,true);
			Notice.listen("TimeLine_changed",this,this.timeLineChanged,null,true);
			Notice.listen("RECORD_KEYFRAME",this,this.makeKeyframeByNodeId);
		}

		__proto.removeListens=function(){
			_super.prototype.removeListens.call(this);
			Notice.cancel("TimeLineFrameSelected",this,this.frameSelected);
			Notice.cancel("TimeLine_changed",this,this.timeLineChanged);
			Notice.cancel("RECORD_KEYFRAME",this,this.makeKeyframeByNodeId);
		}

		__proto.makeKeyframeByNodeId=function(nodeID){
			if(!this.isAnimationMode)return;
			if(!this.animation)return;
			var node;
			node=this.getCompOById(nodeID);
			if(!node)return;
			this.animation.addNodeFrame(node,"x",this.frame,true);
			this.hasChange=true;
			TimeLinePanel.instance.dataChanged();
			Laya.timer.once(200,this,this.updateTimeLinePanel,null,true);
		}

		__proto.frameSelected=function(selectFrame){
			this.frame=selectFrame;
		}

		__proto.timeLineChanged=function(){
			this.changeXml(this._xml,false);
		}

		__proto.setAnimationData=function(){
			TimeLinePanel.instance.setFrame(this._frame);
			_super.prototype.setAnimationData.call(this);
		}

		/**
		*显示UI到当前帧
		*
		*/
		__proto.showToFrame=function(){
			this.animation.targetAnimation.displayToFrame(this.frame);
		}

		/**
		*更新节点树
		*@param comp
		*
		*/
		__proto.updateUIs=function(comp){
			this.freshComp(comp);
			var i=0,len=0;
			var childs;
			childs=DisControlTool.getAllChild(comp);
			len=childs.length;
			for(i=0;i<len;i++){
				this.updateUIs(childs[i]);
			}
		}

		/**
		*刷新节点
		*@param comp
		*
		*/
		__proto.freshComp=function(comp){
			var data;
			if(!comp["comXml"])return;
			data=comp["comXml"].props;
			var key;
			for(key in data){
				comp[key]=data[key];
			}
		}

		__proto.cacheXML=function(newXml){
			_super.prototype.cacheXML.call(this,newXml);
		}

		__proto.addCompHandler=function(node,parentId){
			if(this.isGraphicAnimation){
				var comp;
				comp=this.getCompById(node.compId);
				var saveData;
				saveData=ObjectTools$1.copyObj(node);
				if(comp){
					var preSkin;
					var props;
					props=comp.comXml.props;
					comp.comXml.props={};
					this.animation.targetAnimation.recordNodeInfo(node.compId,this.getCompById(node.compId),true);
					comp.comXml.props=props;
					var key;
					for(key in props){
						comp[key]=props[key];
					}
					}else{
					if(comp){
						this.animation.targetAnimation.recordNodeInfo(node.compId,this.getCompById(node.compId),true);
					}
				}
				if(this.isAnimationMode&&this.uiXmlRestored){
					var boxXml;
					boxXml=this.findXmlById(this.uiXmlRestored,parentId);
					if(boxXml){
						if(!boxXml.child)boxXml.child=[];
						saveData.props={};
						boxXml.child.push(ObjectTools$1.copyObj(saveData));
					}
				}
				this.nodeChanged(node,["skin","x","y"]);
			}
		}

		__proto.nodeChanged=function(node,props,forceChange){
			(forceChange===void 0)&& (forceChange=false);
			if(!node)return;
			_super.prototype.nodeChanged.call(this,node);
			if(!this.isAnimationMode)return;
			var i=0,len=0;
			if(!props)return;
			len=props.length;
			var isGAniFirst=false;
			isGAniFirst=this.isGraphicAnimation&&this.frame==0;
			for(i=0;i<len;i++){
				if(this.isGraphicAnimation&&!TypeManager.isGraphicAniNodeType(node.type)){
					continue ;
				}
				this.animation.addNodeFrame(node,props[i],this.frame,false,forceChange);
				if(isGAniFirst){
					if(0){
						var tarO;
						tarO=this.findXmlById(this.uiXmlRestored,node.compId);
						if(tarO){
							tarO.props=ObjectTools$1.copyObj(node.props);
						}
					}
				}
			}
			this.hasChange=true;
			TimeLinePanel.instance.dataChanged();
			Laya.timer.once(200,this,this.updateTimeLinePanel,null,true);
			if(this.frame==0&&!isGAniFirst){
				Laya.timer.once(200,this,this.alertLater,null,true);
			}
		}

		__proto.alertLater=function(){}
		// MessageManager.instance.show("动画起始帧不可编辑");
		__proto.updateTimeLinePanel=function(){
			TimeLinePanel.instance.aniChanged=true;
			TimeLinePanel.instance.freshData();
		}

		__getset(0,__proto,'frame',function(){
			return this._frame;
			},function(value){
			this._frame=value;
			this.showToFrame();
			var preSelect;
			preSelect=this.selectedComp;
			if(preSelect){
				this.clearSelect();
				preSelect=this._compMap[preSelect["comXml"].compId];
				if(preSelect){
					this.selectComp(preSelect);
				}
			}
		});

		return AnimationDesign;
	})(Design)


	/**打包组件
	*@author yung
	*/
	//class laya.editor.view.other.BoxComp extends laya.editor.ui.other.BoxCompUI
	var BoxComp=(function(_super){
		function BoxComp(){BoxComp.__super.call(this);;
		};

		__class(BoxComp,'laya.editor.view.other.BoxComp',_super);
		var __proto=BoxComp.prototype;
		__proto.start=function(){
			this.popup();
			this.typeDrop.labels=ProjectSetting.boxTypes.join(",");
			this.typeDrop.selectedIndex=0;
		}

		__proto.close=function(type){
			laya.ui.Dialog.prototype.close.call(this,type);
			if (type=="sure"){
				var boxType=this.typeDrop.selectedLabel;
				if (Boolean(boxType)){
					UIPanel.instance.boxComp(boxType);
				}
			}
			UIPanel.instance.focusDesign();
			Notice.notify("Focus_design");
		}

		__getset(1,BoxComp,'instance',function(){
			return BoxComp._instance ? BoxComp._instance :BoxComp._instance=new BoxComp();
		},laya.editor.ui.other.BoxCompUI._$SET_instance);

		BoxComp._instance=null
		return BoxComp;
	})(BoxCompUI)


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2017-7-3 上午10:38:23
	*/
	//class laya.editor.view.other.ChangeCompType extends laya.editor.ui.other.ChangeCompTypeUI
	var ChangeCompType=(function(_super){
		function ChangeCompType(){ChangeCompType.__super.call(this);;
		};

		__class(ChangeCompType,'laya.editor.view.other.ChangeCompType',_super);
		var __proto=ChangeCompType.prototype;
		__proto.start=function(type){
			this.popup();
			this.typeDrop.labels=UIConfigManager.getCompNames().join(",");
			this.typeDrop.selectedIndex=0;
		}

		__proto.close=function(type){
			laya.ui.Dialog.prototype.close.call(this,type);
			if (type=="sure"){
				var boxType=this.typeDrop.selectedLabel;
				if (Boolean(boxType)){
					UIPanel.instance.changeCompType(boxType);
				}
			}
			UIPanel.instance.focusDesign();
			Notice.notify("Focus_design");
		}

		__getset(1,ChangeCompType,'instance',function(){
			return ChangeCompType._instance ? ChangeCompType._instance :ChangeCompType._instance=new ChangeCompType();
		},laya.editor.ui.other.ChangeCompTypeUI._$SET_instance);

		ChangeCompType._instance=null
		return ChangeCompType;
	})(ChangeCompTypeUI)


	/**
	*...
	*@author ww
	*/
	//class laya.editor.view.other.ConvertProject extends laya.editor.ui.other.ConvertProjectUI
	var ConvertProject=(function(_super){
		function ConvertProject(){
			ConvertProject.__super.call(this);
			this.pathOldTxt.prompt=Sys.lang("原项目位置");
			this.pathTxt.prompt=Sys.lang("目标项目位置");
			this.browseBtn.on("click",this,this.onBrowseBtnClick);
			this.browseOldBtn.on("click",this,this.onOldBrowseBtnClick);
		}

		__class(ConvertProject,'laya.editor.view.other.ConvertProject',_super);
		var __proto=ConvertProject.prototype;
		__proto.onBrowseBtnClick=function(e){
			DialogTools.showOpenDir(Sys.lang("选择目标项目所在的位置"),Utils$1.bind(this.onFileSelect,this));
		}

		__proto.onFileSelect=function(files){
			if(files&&files[0])
				this.pathTxt.text=FileManager.adptToCommonUrl(files[0]);
		}

		__proto.onOldBrowseBtnClick=function(e){
			DialogTools.showOpenFile(Sys.lang("打开项目"),Utils$1.bind(this.onOldFileSelect,this),DialogTools.getOpenProO(Sys.lang("打开要转换的项目"),"morn"));
		}

		__proto.onOldFileSelect=function(files){
			if(files&&files[0])
				this.pathOldTxt.text=FileManager.adptToCommonUrl(files[0]);
		}

		__proto.start=function(){
			this.pathTxt.text="";
			this.popup();
		}

		__proto.close=function(type){
			if (type=="sure"){
				if(this.pathOldTxt.text==this.pathOldTxt.prompt){
					Alert.show(Sys.lang("请选择旧项目"));
					return;
				}
				if(this.pathTxt.text==this.pathTxt.prompt){
					Alert.show(Sys.lang("请选择目标项目"));
					return;
				}
				if(!FileTools.exist(this.pathOldTxt.text)){
					Alert.show(Sys.lang("旧项目不存在"));
					return;
				}
				if (Boolean(this.pathOldTxt.text)&& Boolean(this.pathTxt.text)){
					if (FileTools.exist(FileManager.getPath(this.pathTxt.text,"laya"))){
						Confirm.instance.start(Sys.lang("此目录已经有Laya项目了，确定覆盖掉吗？"),Sys.lang("是否覆盖"),Utils$1.bind(this.createProject,this));
						}else{
						this.createProject(true);
					}
					laya.ui.Dialog.prototype.close.call(this,type);
					}else {
					Alert.show(Sys.lang("项目名称及路径不能为空"));
				}
				}else{
				laya.ui.Dialog.prototype.close.call(this,type);
			}
		}

		__proto.createProject=function(sure){
			if (sure){
				ProjectConvertManager.convertProject(this.pathOldTxt.text,this.pathTxt.text);
			}
		}

		__getset(1,ConvertProject,'instance',function(){
			return ConvertProject._instance ? ConvertProject._instance :ConvertProject._instance=new ConvertProject();
		},laya.editor.ui.other.ConvertProjectUI._$SET_instance);

		ConvertProject._instance=null
		return ConvertProject;
	})(ConvertProjectUI)


	/**查找替换
	*@author yung
	*/
	//class laya.editor.view.other.FindAndReplace extends laya.editor.ui.other.FindAndReplaceUI
	var FindAndReplace=(function(_super){
		function FindAndReplace(){
			FindAndReplace.__super.call(this);
			this.findBtn.on("click",this,this.onFindBtnClick);
			this.replaceBtn.on("click",this,this.onReplaceBtnClick);
			this.list.on("doubleclick",this,this.onListDoubleClick);
		}

		__class(FindAndReplace,'laya.editor.view.other.FindAndReplace',_super);
		var __proto=FindAndReplace.prototype;
		__proto.initListener=function(){
			Notice.listen("findResRefer",this,this.start);
		}

		// list.doubleClickEnabled=true;
		__proto.onListDoubleClick=function(e){
			if(!this.list.array[this.list.selectedIndex])return;
			var path=this.list.array[this.list.selectedIndex].path;
			if (path){
				Notice.notify("openPAGE",[path]);
			}
		}

		__proto.onReplaceBtnClick=function(e){
			if (this.findTxt.text !="" && this.findTxt.text !=this.replaceTxt.text){
				if(PageManager.find(this.findTxt.text).length>0){
					Confirm.show(Sys.lang("你确定要将 [{0}] 替换为 [{1}] 吗？替换后不能直接恢复",this.findTxt.text,this.replaceTxt.text),Sys.lang("确定替换"),Utils$1.bind(this.onConfirmBack,this));
					}else{
					Alert.show(Sys.lang("未找到指定内容"));
				}
			}
		}

		__proto.onConfirmBack=function(sure){
			if (sure){
				var arr=PageManager.replace(new RegExp(this.findTxt.text,"g"),this.replaceTxt.text);
				this.list.array=arr;
				this.msgTxt.text=Sys.lang("共替换了 {0} 个页面，双击列表打开页面",arr.length);
			}
		}

		__proto.onFindBtnClick=function(e){
			if (this.findTxt.text !=""){
				this.doFind();
			}
		}

		__proto.doFind=function(){
			var arr=PageManager.find(this.findTxt.text);
			this.list.array=arr;
			if(arr.length>0){
				this.msgTxt.text=Sys.lang("共找到 {0} 个页面，双击列表打开页面",arr.length);
				}else{
				this.msgTxt.text=Sys.lang("共找到 {0} 个页面",arr.length);
			}
		}

		__proto.start=function(content){
			this.popup(true);
			this.msgTxt.text="";
			if(content){
				this.findTxt.text=content;
			}
			this.list.array=[];
		}

		__getset(1,FindAndReplace,'instance',function(){
			return FindAndReplace._instance ? FindAndReplace._instance :FindAndReplace._instance=new FindAndReplace();
		},laya.editor.ui.other.FindAndReplaceUI._$SET_instance);

		FindAndReplace._instance=null
		return FindAndReplace;
	})(FindAndReplaceUI)


	/**查找未被使用的资源
	*@author yung
	*/
	//class laya.editor.view.other.FindUnUsedRes extends laya.editor.ui.other.FindUnUsedResUI
	var FindUnUsedRes=(function(_super){
		function FindUnUsedRes(){
			this._arr=null;
			this.isCodeChange=false;
			FindUnUsedRes.__super.call(this);
			this.findBtn.on("click",this,this.onFindBtnClick);
			this.list.mouseHandler=new Handler(this,this.onList);
			this.delBtn.on("click",this,this.onDelBtnClick);
		}

		__class(FindUnUsedRes,'laya.editor.view.other.FindUnUsedRes',_super);
		var __proto=FindUnUsedRes.prototype;
		__proto.onDelBtnClick=function(e){
			if (this.getSelecteList().length > 0){
				Confirm.show(Sys.lang("你确定删除选中的资源吗(删除后可在垃圾箱内找回)"),Sys.lang("确定删除"),Utils$1.bind(this.onConfirmBack,this));
				}else{
				Alert.show(Sys.lang("还未选中任何资源，请重试"));
			}
		}

		__proto.getSelecteList=function(){
			var i=0,len=0;
			len=this._arr.length;
			var rst;
			rst=[];
			for(i=0;i<len;i++){
				if(this._arr[i].check.selected){
					rst.push(this._arr[i]);
				}
			}
			return rst;
		}

		__proto.onConfirmBack=function(sure){
			if (sure){
				var item;
				for(var $each_item in this._arr){
					item=this._arr[$each_item];
					if (item.check.selected){
						ResManager.removeRes(item.path);
					}
				}
				Notice.notify("FRESH_RES");
				this.onFindBtnClick(null);
			}
		}

		__proto.onList=function(e,index){
			if (e.type=="click"){
				if ((e.target instanceof laya.ui.CheckBox )){
					this._arr[index].check.selected=(e.target).selected;
					this.list.refresh();
					this.updateCheckStatu();
				}
			}
		}

		__proto.updateCheckStatu=function(){
			if(!this._arr)return;
			var i=0,len=0;
			len=this._arr.length;
			var selecteCount=0;
			selecteCount=0;
			for(i=0;i<len;i++){
				if(this._arr[i].check.selected){
					selecteCount++;
				}
			}
			this.isCodeChange=true;
			if(selecteCount==0){
				this.checkSelectAll.selected=false;
				}else{
				if(selecteCount==this._arr.length){
					this.checkSelectAll.selected=true;
				}
			}
			this.isCodeChange=false;
		}

		__proto.onCheckSelectAllChange=function(e){
			if(this.isCodeChange)return;
			var item;
			for(var $each_item in this._arr){
				item=this._arr[$each_item];
				if (Boolean(item.path)){
					item.check={selected:this.checkSelectAll.selected,visible:true};
					}else {
					item.check={selected:false,visible:false};
				}
			}
			this.list.array=this._arr;
		}

		__proto.onFindBtnClick=function(e){
			this.resultBox.visible=true;
			this._arr=ResManager.findUnUsed();
			this.msgTxt.text=Sys.lang("共找到 {0} 个资源",this._arr.length);
			this.checkSelectAll.selected=true;
			this.onCheckSelectAllChange(null);
			this.checkSelectAll.on("change",this,this.onCheckSelectAllChange);
		}

		__proto.start=function(){
			this.popup(true);
			this.resultBox.visible=false;
			this.checkSelectAll.off("change",this,this.onCheckSelectAllChange);
		}

		__getset(1,FindUnUsedRes,'instance',function(){
			return FindUnUsedRes._instance ? FindUnUsedRes._instance :FindUnUsedRes._instance=new FindUnUsedRes();
		},laya.editor.ui.other.FindUnUsedResUI._$SET_instance);

		FindUnUsedRes._instance=null
		return FindUnUsedRes;
	})(FindUnUsedResUI)


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-7-5 下午8:42:38
	*/
	//class laya.editor.view.other.LangPanel extends laya.editor.ui.other.LangPanelUI
	var LangPanel=(function(_super){
		function LangPanel(){
			LangPanel.__super.call(this);
			this.langPathBtn.on("click",this,this.onLangPathBtnClick);
		}

		__class(LangPanel,'laya.editor.view.other.LangPanel',_super);
		var __proto=LangPanel.prototype;
		__proto.initListener=function(){
			Notice.listen("LangPanel",this,this.start);
		}

		__proto.start=function(){
			this.langPath.text="";
			this.popup();
		}

		__proto.onLangPathBtnClick=function(e){
			DialogTools.showOpenDir(Sys.lang("选择导出路径"),Utils.bind(this.onFileSelect4,this),FileManager.getWorkPath(ProjectSetting.resExportPath));
		}

		__proto.onFileSelect4=function(path){
			if (!path)return;
			this.langPath.text=path[0];
		}

		__proto.close=function(type){
			if (type=="sure"){
				if(this.langPath.text==""){
					Alert.show(Sys.lang("请选择导出路径"));
					}else{
					if(FileTools.exist(this.langPath.text)){
						LanguageManager.saveLanguagePack(this.langPath.text);
						laya.ui.Dialog.prototype.close.call(this,type);
						}else{
						Alert.show(Sys.lang("导出路径不存在"));
					}
				}
				}else{
				laya.ui.Dialog.prototype.close.call(this,type);
			}
		}

		__getset(1,LangPanel,'instance',function(){
			return LangPanel._instance ? LangPanel._instance :LangPanel._instance=new LangPanel();
		},laya.editor.ui.other.LangPanelUI._$SET_instance);

		LangPanel._instance=null
		return LangPanel;
	})(LangPanelUI)


	/**预览
	*@author yung
	*/
	//class laya.editor.view.other.Preview extends laya.editor.ui.other.PreviewUI
	var Preview=(function(_super){
		function Preview(){
			Preview.__super.call(this);
		}

		__class(Preview,'laya.editor.view.other.Preview',_super);
		var __proto=Preview.prototype;
		__proto.start=function(xml){
			this.size(Laya.stage.width,Laya.stage.height);
			this.popup();
			this.panel.removeChildren();
			var view=new UIView();
			view.createView(Utils.clone(xml));
			var box=view.getChildAt(0);
			view.x=(this._width-view.width)*0.5;
			view.y=(this._height-view.height)*0.5;
			this.panel.addChild(view);
		}

		__getset(1,Preview,'instance',function(){
			return Preview._instance ? Preview._instance :Preview._instance=new Preview();
		},laya.editor.ui.other.PreviewUI._$SET_instance);

		Preview._instance=null
		return Preview;
	})(PreviewUI)


	/**重复创建组件
	*@author yung
	*/
	//class laya.editor.view.other.RepeatComp extends laya.editor.ui.other.RepeatCompUI
	var RepeatComp=(function(_super){
		function RepeatComp(){
			RepeatComp.__super.call(this);
			this.columnTxt.restrict=this.rowTxt.restrict="0-9";
			this.paddingYTxt.restrict=this.paddingXTxt.restrict="-.0-9";
		}

		__class(RepeatComp,'laya.editor.view.other.RepeatComp',_super);
		var __proto=RepeatComp.prototype;
		__proto.start=function(){
			this.popup();
		}

		__proto.close=function(type){
			laya.ui.Dialog.prototype.close.call(this,type);
			if (type=="sure"){
				UIPanel.instance.repeatComp(LayaBuilder.mParseInt(this.rowTxt.text),LayaBuilder.mParseInt(this.columnTxt.text),LayaBuilder.mParseInt(this.paddingXTxt.text),LayaBuilder.mParseInt(this.paddingYTxt.text));
			}
			Notice.notify("Focus_design");
		}

		__getset(1,RepeatComp,'instance',function(){
			return RepeatComp._instance ? RepeatComp._instance :RepeatComp._instance=new RepeatComp();
		},laya.editor.ui.other.RepeatCompUI._$SET_instance);

		RepeatComp._instance=null
		return RepeatComp;
	})(RepeatCompUI)


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2017-5-15 下午2:44:03
	*/
	//class laya.editor.view.other.SetIDENew extends laya.editor.ui.other.SetIDENewUI
	var SetIDENew=(function(_super){
		function SetIDENew(){
			SetIDENew.__super.call(this);
			this.typeTab.selectedIndex=0;
			this.typeTab.selectHandler=Handler.create(this,this.selectedHandler,null,false);
		}

		__class(SetIDENew,'laya.editor.view.other.SetIDENew',_super);
		var __proto=SetIDENew.prototype;
		__proto.initListener=function(){
			Notice.listen("OPEN_IDESETTING",this,this.start);
			Notice.listen("CLOSE_IDESETTING",this,this.close);
		}

		__proto.selectedHandler=function(index){
			this.views.setIndexHandler.runWith(index);
		}

		__proto.start=function(){
			for (var i=this.views.numChildren-1;i >-1;i--){
				var view=this.views.getChildAt(i);
				view.reset();
			}
			this.popup();
		}

		__getset(1,SetIDENew,'instance',function(){
			return SetIDENew._instance ? SetIDENew._instance :SetIDENew._instance=new SetIDENew();
		},laya.editor.ui.other.SetIDENewUI._$SET_instance);

		SetIDENew._instance=null
		return SetIDENew;
	})(SetIDENewUI)


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-7-21 下午2:51:21
	*/
	//class laya.editor.view.other.SetIDE extends laya.editor.ui.other.SetIDEUI
	var SetIDE=(function(_super){
		function SetIDE(){
			SetIDE.__super.call(this);
		}

		__class(SetIDE,'laya.editor.view.other.SetIDE',_super);
		var __proto=SetIDE.prototype;
		__proto.initListener=function(){}
		__proto.start=function(){
			this.showRule.selected=SystemSetting.ifShowRuleGrid;
			this.autoSwitch.selected=SystemSetting.toCodeModeWhenPublicEnd;
			this.frameSelect.selectedIndex=SystemSetting.IDEFrameType;
			this.popup();
		}

		__proto.close=function(type){
			laya.ui.Dialog.prototype.close.call(this,type);
			if (type=="sure"){
				SystemSetting.ifShowRuleGrid=this.showRule.selected;
				SystemSetting.toCodeModeWhenPublicEnd=this.autoSwitch.selected;
				SystemSetting.IDEFrameType=this.frameSelect.selectedIndex;
				SetIDE.updateToSettings();
				Notice.notify("RULE_SHOW_CHANGE");
			}
		}

		__getset(1,SetIDE,'instance',function(){
			return SetIDE._instance ? SetIDE._instance :SetIDE._instance=new SetIDE();
		},laya.editor.ui.other.SetIDEUI._$SET_instance);

		SetIDE.updateToSettings=function(){
			if(SystemSetting.IDEFrameType==1){
				Laya.stage.frameRate="fast";
				}else{
				Laya.stage.frameRate="slow";
			}
		}

		SetIDE._instance=null
		return SetIDE;
	})(SetIDEUI)


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2017-5-15 下午3:16:31
	*/
	//class laya.editor.view.other.SetIDEView extends laya.editor.ui.other.SetIDEViewUI
	var SetIDEView=(function(_super){
		function SetIDEView(){
			SetIDEView.__super.call(this);
			this.okBtn.on("mousedown",this,this.okDown);
		}

		__class(SetIDEView,'laya.editor.view.other.SetIDEView',_super);
		var __proto=SetIDEView.prototype;
		__proto.reset=function(){
			this.showRule.selected=SystemSetting.ifShowRuleGrid;
			this.autoSwitch.selected=SystemSetting.toCodeModeWhenPublicEnd;
			this.frameSelect.selectedIndex=SystemSetting.IDEFrameType;
			this.autoFocus.selected=SystemSetting.autoFocsEditRect;
		}

		__proto.okDown=function(){
			SystemSetting.ifShowRuleGrid=this.showRule.selected;
			SystemSetting.toCodeModeWhenPublicEnd=this.autoSwitch.selected;
			SystemSetting.autoFocsEditRect=this.autoFocus.selected;
			SystemSetting.IDEFrameType=this.frameSelect.selectedIndex;
			SetIDEView.updateToSettings();
			Notice.notify("RULE_SHOW_CHANGE");
			Notice.notify("CLOSE_IDESETTING");
		}

		SetIDEView.updateToSettings=function(){
			if(SystemSetting.IDEFrameType==1){
				Laya.stage.frameRate="fast";
				}else{
				Laya.stage.frameRate="slow";
			}
		}

		return SetIDEView;
	})(SetIDEViewUI)


	/**设置项目
	*@author yung
	*/
	//class laya.editor.view.other.SetProject extends laya.editor.ui.other.SetProjectUI
	var SetProject=(function(_super){
		function SetProject(){
			SetProject.__super.call(this);
			this.codeExportPathBtn.on("click",this,this.onCodeExportPathBtnClick);
			this.resExportPathBtn.on("click",this,this.onResExportPathBtnClick);
			this.resExportPathEBtn.on("click",this,this.onResExportPathEBtnClick);
			this.shareResPathBtn.on("click",this,this.onShareResPathBtnClick);
			this.langPathBtn.on("click",this,this.onLangPathBtnClick);
			this.codeType.on("change" ,this,this.onCodeTypeChange);
			this.uiType.labels=PageExportType.typeList.join(",");
		}

		__class(SetProject,'laya.editor.view.other.SetProject',_super);
		var __proto=SetProject.prototype;
		// uiType.labels="内嵌模式,加载模式";
		__proto.onCodeTypeChange=function(){
			this.updateCodeImportToUI();
		}

		__proto.updateCodeImportToUI=function(){
			switch(Math.ceil(this.codeType.selectedIndex)){
				case 0:
					this.codeImports.text=ProjectSetting.codeImports;
					break ;
				case 2:
				case 2:
					this.codeImports.text=ProjectSetting.codeImportsJS;
					break ;
				case 1:
					this.codeImports.text=ProjectSetting.codeImportsTS;
					break ;
				}
		}

		__proto.init=function(){
			ProjectSetting.adptPaths();
			this.resTypes.text=StringTool$1.trimSide(ProjectSetting.resTypes.toString());
			this.resExportPath.text=StringTool$1.trimSide(ProjectSetting.resExportPath);
			this.resExportPathE.text=StringTool$1.trimSide(ProjectSetting.asynResExportPath);
			this.codeExportPath.text=StringTool$1.trimSide(ProjectSetting.codeExportPath);
			this.uiType.selectedIndex=Math.ceil(ProjectSetting.uiType);
			this.codeType.selectedIndex=Math.ceil(ProjectSetting.codeType);
			this.picType.selectedIndex=Math.ceil(ProjectSetting.picType);
			this.atlasType.selectedIndex=Math.ceil(ProjectSetting.atlasType);
			this.uiExportPath.text=StringTool$1.trimSide(ProjectSetting.uiExportPath);
			this.boxTypes.text=StringTool$1.trimSide(ProjectSetting.boxTypes.toString());
			this.pageTypes.text=StringTool$1.trimSide(ProjectSetting.pageTypes.toString());
			this.defaultFont.text=StringTool$1.trimSide(ProjectSetting.defaultFont)||"12px Arial";
			this.textureWidth.text=StringTool$1.trimSide(ProjectSetting.textureWidth.toString());
			this.textureHeight.text=StringTool$1.trimSide(ProjectSetting.textureHeight.toString());
			this.picWidth.text=StringTool$1.trimSide(ProjectSetting.picWidth.toString());
			this.picHeight.text=StringTool$1.trimSide(ProjectSetting.picHeight.toString());
			this.power2.selected=StringTool$1.trimSide(ProjectSetting.power2)=="true";
			this.trimempty.selected=StringTool$1.trimSide(ProjectSetting.trimempty)=="true";
			this.copyRes.selected=StringTool$1.trimSide(ProjectSetting.copyRes)=="true";
			this.dataCompact.selected=StringTool$1.trimSide(ProjectSetting.dataCompact)=="true";
			this.updateCodeImportToUI();
			this.shareResPath.text=ProjectSetting.shareResPath;
			this.langPath.text=ProjectSetting.langPath;
		}

		__proto.start=function(){
			this.init();
			this.popup();
		}

		__proto.close=function(type){
			laya.ui.Dialog.prototype.close.call(this,type);
			if (type=="sure"){
				ExportManager.configChanged=true;
				ProjectSetting.resTypes=this.resTypes.text.split(",");
				ProjectSetting.resExportPath=StringTool$1.trimSide(this.resExportPath.text);
				ProjectSetting.asynResExportPath=StringTool$1.trimSide(this.resExportPathE.text);
				ProjectSetting.codeExportPath=StringTool$1.trimSide(this.codeExportPath.text);
				ProjectSetting.uiType=this.uiType.selectedIndex;
				ProjectSetting.codeType=this.codeType.selectedIndex;
				ProjectSetting.picType=this.picType.selectedIndex;
				ProjectSetting.atlasType=this.atlasType.selectedIndex;
				ProjectSetting.uiExportPath=this.uiExportPath.text;
				ProjectSetting.boxTypes=this.boxTypes.text.split(",");
				ProjectSetting.pageTypes=StringTool$1.trimSide(this.pageTypes.text).split(",");
				ProjectSetting.defaultFont=StringTool$1.trimSide(this.defaultFont.text);
				if(ProjectSetting.defaultFont=="12px Arial"){
					ProjectSetting.defaultFont="";
				}
				ProjectSetting.textureWidth=LayaBuilder.mParseInt(this.textureWidth.text);
				ProjectSetting.textureHeight=LayaBuilder.mParseInt(this.textureHeight.text);
				ProjectSetting.picWidth=LayaBuilder.mParseInt(this.picWidth.text);
				ProjectSetting.picHeight=LayaBuilder.mParseInt(this.picHeight.text);
				ProjectSetting.power2=this.power2.selected?"true":"false";
				ProjectSetting.trimempty=this.trimempty.selected?"true":"false";
				ProjectSetting.dataCompact=this.dataCompact.selected?"true":"false";
				ProjectSetting.copyRes=this.copyRes.selected?"true":"false";
				switch(Math.ceil(ProjectSetting.codeType)){
					case 0:
						ProjectSetting.codeImports=this.codeImports.text;
						break ;
					case 2:
					case 2:
						ProjectSetting.codeImportsJS=this.codeImports.text;
						break ;
					case 1:
						ProjectSetting.codeImportsTS=this.codeImports.text;
						break ;
					}
				ProjectSetting.shareResPath=this.shareResPath.text;
				ProjectSetting.langPath=this.langPath.text;
				ProjectSetting.adptPaths();
				ProjectManager.saveProject();
				RenderManager.I.setRenderPropByFont(ProjectSetting.defaultFont)
				LanguageManager.loadProjectLanguageFile();
			}
		}

		//UILibManager.reloadUILang();
		__proto.onResExportPathBtnClick=function(event){
			DialogTools.showOpenDir(Sys.lang("选择资源发布目录"),Utils$1.bind(this.onFileSelect1,this));
		}

		__proto.onFileSelect1=function(path){
			if (!path)return;
			this.resExportPath.text=FileManager.getWorkRelativePath(path[0]);
		}

		__proto.onResExportPathEBtnClick=function(event){
			DialogTools.showOpenDir(Sys.lang("选择页面发布目录"),Utils$1.bind(this.onFileSelect1E,this));
		}

		__proto.onFileSelect1E=function(path){
			if (!path)return;
			this.resExportPathE.text=FileManager.getWorkRelativePath(path[0]);
		}

		__proto.onCodeExportPathBtnClick=function(event){
			DialogTools.showOpenDir(Sys.lang("选择UI代码发布目录"),Utils$1.bind(this.onFileSelect2,this));
		}

		__proto.onFileSelect2=function(path){
			if (!path)return;
			this.codeExportPath.text=FileManager.getWorkRelativePath(path[0]);
		}

		__proto.onShareResPathBtnClick=function(event){
			var file=new File(FileManager.getWorkPath(ProjectSetting.shareResPath));
			DialogTools.showOpenDir(Sys.lang("选择多项目共用的资源目录"),Utils$1.bind(this.onFileSelect3,this));
		}

		__proto.onFileSelect3=function(path){
			if (!path)return;
			this.shareResPath.text=FileManager.getWorkRelativePath(path[0]);
		}

		__proto.onLangPathBtnClick=function(e){
			DialogTools.showOpenFile(Sys.lang("选择语言文件"),Utils$1.bind(this.onFileSelect4,this),DialogTools.getOpenProO(Sys.lang("打开语言包"),"*"),FileManager.getWorkPath(ProjectSetting.resExportPath));
		}

		__proto.onFileSelect4=function(path){
			if (!path)return;
			this.langPath.text=FileManager.getWorkRelativePath(path[0]);
		}

		__getset(1,SetProject,'instance',function(){
			return SetProject._instance ? SetProject._instance :SetProject._instance=new SetProject();
		},laya.editor.ui.other.SetProjectUI._$SET_instance);

		SetProject._instance=null
		SetProject.DefaultUIFont="12px Arial";
		return SetProject;
	})(SetProjectUI)


	/**添加目录
	*@author yung
	*/
	//class laya.editor.view.page.AddDirectory extends laya.editor.ui.page.AddDirectoryUI
	var AddDirectory=(function(_super){
		function AddDirectory(){AddDirectory.__super.call(this);;
		};

		__class(AddDirectory,'laya.editor.view.page.AddDirectory',_super);
		var __proto=AddDirectory.prototype;
		__proto.initListener=function(){
			Notice.listen("open_adddir",this,this.start);
		}

		__proto.start=function(){
			this.nameTxt.restrict=StyleConsts.fileNameRestrict;
			this.nameTxt.text="";
			this.popup();
			this.nameTxt.focus=true;
		}

		__proto.close=function(type){
			if (type=="sure"){
				if (this.nameTxt.text){
					laya.ui.Dialog.prototype.close.call(this,type);
					Notice.notify("adddir",[this.nameTxt.text]);
					}else {
					Alert.show(Sys.lang("目录名称不能为空"));
				}
				}else{
				laya.ui.Dialog.prototype.close.call(this,type);
			}
		}

		__getset(1,AddDirectory,'instance',function(){
			return AddDirectory._instance ? AddDirectory._instance :AddDirectory._instance=new AddDirectory();
		},laya.editor.ui.page.AddDirectoryUI._$SET_instance);

		AddDirectory._instance=null
		return AddDirectory;
	})(AddDirectoryUI)


	/**
	*...
	*@author yung
	*/
	//class laya.editor.view.page.AddDocument extends laya.editor.ui.page.AddDocumentUI
	var AddDocument=(function(_super){
		function AddDocument(){
			this.tipDic={};
			AddDocument.__super.call(this);
			this.tipDic[0]=Sys.lang("View为普通页面视图，使用之前需要预加载资源\nDialog为对话框，在View的基础上，增加弹出效果，拖动，关闭处理等逻辑");
			this.tipDic[1]=Sys.lang("重力模式为预设了重力参数的粒子效果\n半径模式为预设了半径参数的粒子效果\n粒子3D为3D的粒子效果");
			this.tipDic[2]=Sys.lang("GarphicAnimation为Graphics动画，比较高性能的动画系统，可以实现丰富动画效果\nEffectAnimation为特效模板动画，创建一个模板动画后，可以把模板动画拖动到UI的某个节点上，然后节点就获得这个动画效果");
			this.tipDic[3]=Sys.lang("扩展脚本为继承式扩展脚本描述，把此脚本拖动到UI的某个节点上，节点就会实例脚本类替换原来的类\n附加脚本为组件式扩展脚本描述，把此脚本拖动到UI的某个节点上，会把此节点作为target对象给脚本，由脚本进行控制\n区别：扩展脚本为继承脚本，比如继承Button类实现了MyButton类，扩展脚本为附加控制脚本类，此节点作为target对象给脚本，然后对target进行操作");
			this.tipImg.mouseEnabled=true;
			this.tab.selectHandler=Handler.create(this,this.selectedHandler,null,false);
			this.tipIcon.toolTip=Sys.lang("点击打开帮助文档");
			this.tipIcon.visible=true;
			this.tipIcon.on("click",this,this.onHelpTip);
		}

		__class(AddDocument,'laya.editor.view.page.AddDocument',_super);
		var __proto=AddDocument.prototype;
		__proto.onHelpTip=function(){
			HelpTipView.endHelpTip();
			Browser.window.open("http://ldc.layabox.com/doc/?nav=ch-as-2-1-10");
		}

		__proto.selectedHandler=function(index){
			this.tipImg.toolTip=this.tipDic[index];
			this.views.setIndexHandler.runWith(index);
		}

		__proto.initListener=function(){
			Notice.listen("OPEN_ADDPage",this,this.start);
		}

		__proto.start=function(type){
			(type===void 0)&& (type=0);
			this.tab.selectedIndex=type;
			this.tipImg.toolTip=this.tipDic[type];
			for (var i=this.views.numChildren-1;i >-1;i--){
				var view=this.views.getChildAt(i);
				view.reset();
			}
			this.popup();
		}

		__proto.close=function(type){
			if (type=="sure"){
				var view=this.views.selection;
				if (view.check())laya.ui.Dialog.prototype.close.call(this,type);
				}else {
				laya.ui.Dialog.prototype.close.call(this,type);
			}
		}

		__getset(1,AddDocument,'instance',function(){
			return AddDocument._instance ? AddDocument._instance :AddDocument._instance=new AddDocument();
		},laya.editor.ui.page.AddDocumentUI._$SET_instance);

		AddDocument._instance=null
		return AddDocument;
	})(AddDocumentUI)


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-2-23 上午11:34:50
	*/
	//class laya.editor.view.page.AddScene extends laya.editor.ui.page.AddSceneUI
	var AddScene=(function(_super){
		function AddScene(){
			AddScene.__super.call(this);
		}

		__class(AddScene,'laya.editor.view.page.AddScene',_super);
		var __proto=AddScene.prototype;
		__proto.initListener=function(){
			Notice.listen("OPEN_ADDSCENE",this,this.start);
		}

		__proto.start=function(){
			this.nameTxt.text="";
			this.popup();
			Laya.stage.focus=this.nameTxt.textField;
		}

		__proto.close=function(type){
			if (type=="sure"){
				Notice.notify("ADDSCENE",[this.nameTxt.text]);
			}
		}

		__getset(1,AddScene,'instance',function(){
			return AddScene._instance ? AddScene._instance :AddScene._instance=new AddScene();
		},laya.editor.ui.page.AddSceneUI._$SET_instance);

		AddScene._instance=null
		return AddScene;
	})(AddSceneUI)


	/**移动页面
	*@author yung
	*/
	//class laya.editor.view.page.MovePage extends laya.editor.ui.page.MovePageUI
	var MovePage=(function(_super){
		function MovePage(){
			this._oldFile=null;
			this._newFile=null;
			MovePage.__super.call(this);
		}

		__class(MovePage,'laya.editor.view.page.MovePage',_super);
		var __proto=MovePage.prototype;
		__proto.initListener=function(){
			Notice.listen("OPEN_MovePage",this,this.start);
		}

		__proto.start=function(oldFile,newFile){
			var oldPage=FileManager.getWorkRelativePath(oldFile.nativePath).replace("laya/pages/","").replace(".ui","");
			var newPage=FileManager.getWorkRelativePath(newFile.nativePath).replace("laya/pages/","").replace(".ui","");
			this.msgLbl.text=Sys.lang("确定移动页面{0}\n到{1}吗",oldPage,newPage);
			this.updateCheck.selected=true;
			this._oldFile=oldFile;
			this._newFile=newFile;
			this.popup();
		}

		__proto.close=function(type){
			laya.ui.Dialog.prototype.close.call(this,type);
			if (type=="sure"){
				Notice.notify("MovePage",[this._oldFile.nativePath,this._newFile.nativePath,this.updateCheck.selected]);
			}
		}

		__getset(1,MovePage,'instance',function(){
			return MovePage._instance ? MovePage._instance :MovePage._instance=new MovePage();
		},laya.editor.ui.page.MovePageUI._$SET_instance);

		MovePage._instance=null
		return MovePage;
	})(MovePageUI)


	/**需要保存
	*@author yung
	*/
	//class laya.editor.view.page.NeedSave extends laya.editor.ui.page.NeedSaveUI
	var NeedSave=(function(_super){
		function NeedSave(){
			this._ok=null;
			this._no=null;
			NeedSave.__super.call(this);
		}

		__class(NeedSave,'laya.editor.view.page.NeedSave',_super);
		var __proto=NeedSave.prototype;
		__proto.start=function(msg,ok,no){
			this.msgLbl.text=msg;
			this._ok=ok;
			this._no=no;
			this.popup();
		}

		__proto.close=function(type){
			laya.ui.Dialog.prototype.close.call(this,type);
			if (type=="sure"){
				if (this._ok !=null){
					this._ok.run();
				}
				}else if (type=="cancel"){
				if (this._no !=null){
					this._no.run();
				}
			}
		}

		__getset(1,NeedSave,'instance',function(){
			return NeedSave._instance ? NeedSave._instance :NeedSave._instance=new NeedSave();
		},laya.editor.ui.page.NeedSaveUI._$SET_instance);

		NeedSave._instance=null
		return NeedSave;
	})(NeedSaveUI)


	/**重命名页面
	*@author yung
	*/
	//class laya.editor.view.page.RenamePage extends laya.editor.ui.page.RenamePageUI
	var RenamePage=(function(_super){
		function RenamePage(){RenamePage.__super.call(this);;
		};

		__class(RenamePage,'laya.editor.view.page.RenamePage',_super);
		var __proto=RenamePage.prototype;
		__proto.initListener=function(){
			Notice.listen("OPEN_RENAME",this,this.start);
		}

		__proto.start=function(oldName){
			this.resLbl.text=oldName;
			this.nameTxt.restrict=StyleConsts.fileNameRestrict;
			this.nameTxt.text=oldName;
			this.updateCheck.selected=true;
			this.popup();
			Laya.stage.focus=this.nameTxt.textField;
		}

		__proto.close=function(type){
			if (type=="sure"){
				if(!StringTool$1.isOkFileName(this.nameTxt.text)){
					Alert.show(Sys.lang("文件名不合法"));
					return;
				}
				if(FileTools.isPathSame(this.nameTxt.text,this.resLbl.text)){
					Alert.show(Sys.lang("文件名不能相同！！"));
					return;
				}
				Notice.notify("RENAME_PAGE",[this.nameTxt.text,this.updateCheck.selected]);
				laya.ui.Dialog.prototype.close.call(this,type);
				}else{
				laya.ui.Dialog.prototype.close.call(this,type);
			}
		}

		__getset(1,RenamePage,'instance',function(){
			return RenamePage._instance ? RenamePage._instance :RenamePage._instance=new RenamePage();
		},laya.editor.ui.page.RenamePageUI._$SET_instance);

		RenamePage._instance=null
		return RenamePage;
	})(RenamePageUI)


	/**设置页面默认属性
	*@author yung
	*/
	//class laya.editor.view.page.SetPageProp extends laya.editor.ui.page.SetPagePropUI
	var SetPageProp=(function(_super){
		function SetPageProp(){
			this._preAname=null;
			SetPageProp.__super.call(this);
		}

		__class(SetPageProp,'laya.editor.view.page.SetPageProp',_super);
		var __proto=SetPageProp.prototype;
		__proto.initListener=function(){
			Notice.listen("OPEN_SEtPageProp",this,this.start);
		}

		__proto.start=function(path){
			path=FileManager.adptToCommonUrl(path);
			this.nameLbl.text=path;
			var props;
			props=PageStyleManager.getPageProps(path);
			props=ResStyleManager.getPropArrByPropStr(props).join("\n");
			this.propsTxt.text=props;
			this.packType.labels=Sys.lang("默认")+","+PageExportType.typeList.join(",");
			this.packType.selectedLabel=PageStyleManager.getPageExportType(path);
			this.anameTxt.text=PageStyleManager.getPageAName(path);
			this._preAname=this.anameTxt.text;
			this.popup();
			Laya.stage.focus=this.propsTxt.textField;
		}

		__proto.close=function(type){
			laya.ui.Dialog.prototype.close.call(this,type);
			if (type=="sure"){
				PageStyleManager.updatePageStyle(this.nameLbl.text,this.propsTxt.text,this.packType.selectedLabel,this.anameTxt.text);
				UIPanel.instance.refreshCurrView();
				if(this.anameTxt.text!=this._preAname)
					Notice.notify("FRESH_Page",[false]);
			}
		}

		__getset(1,SetPageProp,'instance',function(){
			return SetPageProp._instance ? SetPageProp._instance :SetPageProp._instance=new SetPageProp();
		},laya.editor.ui.page.SetPagePropUI._$SET_instance);

		SetPageProp._instance=null
		return SetPageProp;
	})(SetPagePropUI)


	/**添加页面
	*@author yung
	*/
	//class laya.editor.view.page.SetPage extends laya.editor.ui.page.SetPageUI
	var SetPage=(function(_super){
		function SetPage(){
			this._viewer=null;
			SetPage.__super.call(this);
			this.selectBtn.on("click",this,this.onSelectBtnClick);
		}

		__class(SetPage,'laya.editor.view.page.SetPage',_super);
		var __proto=SetPage.prototype;
		__proto.onSelectBtnClick=function(e){
			DialogTools.showOpenFile(Sys.lang("请选择视图参考图片"),Utils$1.bind(this.onSelected,this),DialogTools.imgFilterO);
		}

		__proto.onSelected=function(files){
			if(!files||!files[0])return;
			files[0]=FileManager.adptToCommonUrl(files[0]);
			this.imgTxt.text=files[0];
			Laya.loader.load(FileTools.getAbsPath(files[0]),Handler.create(this,this.picLoaded));
		}

		__proto.picLoaded=function(pic){
			this.widthTxt.text=pic.width+"";
			this.heightTxt.text=pic.height+"";
		}

		__proto.start=function(){
			if ((UIPanel.instance.currViewer instanceof laya.editor.view.UIViewer )){
				this._viewer=UIPanel.instance.currViewer;
				if(this._viewer.design.isAnimationMode){
					Alert.show(Sys.lang("动画编辑模式不可设置页面，请切换到非动画编辑模式切换"));
					return;
				};
				var xml=this._viewer.design.xml;
				var pageType;
				pageType=xml.type=StringTool$1.trimSide(xml.type);
				var labels;
				labels=ProjectSetting.getPageTypeLabel();
				if(labels.indexOf(pageType)<0){
					labels+=","+pageType;
				}
				this.typeDrop.labels=labels;
				if (this.typeDrop.selectedIndex==-1){
					this.typeDrop.selectedIndex=0;
				}
				this.typeDrop.selectedLabel=xml.type;
				this.nameTxt.text=FileManager.getFileName(this._viewer.pagePath);
				this.nameTxt.alpha=0.5;
				this.imgTxt.text=xml.props.sceneBg?xml.props.sceneBg:"";
				this.bgColorPicker.selectedColor=xml.props.sceneColor;
				var width=LayaBuilder.mParseInt(xml.props.width);
				if (width > 0){
					this.widthTxt.text=width+"";
					this.widthCheck.selected=false;
					}else {
					this.widthTxt.text=xml.props.sceneWidth?xml.props.sceneWidth:"";
					this.widthCheck.selected=true;
				};
				var height=LayaBuilder.mParseInt(xml.props.height);
				if (height > 0){
					this.heightTxt.text=height+"";
					this.heightCheck.selected=false;
					}else {
					this.heightTxt.text=xml.props.sceneHeight?xml.props.sceneHeight:"";
					this.heightCheck.selected=true;
				}
				this.popup();
			}
		}

		__proto.close=function(type){
			laya.ui.Dialog.prototype.close.call(this,type);
			if (type=="sure"){
				if (!Boolean(this.typeDrop.selectedLabel)){
					return Alert.show(Sys.lang("请选择页面类型"));
				};
				var xml=this._viewer.design.xml;
				var width=LayaBuilder.mParseInt(this.widthTxt.text);
				var height=LayaBuilder.mParseInt(this.heightTxt.text);
				var imgPath=FileManager.adptToCommonUrl(this.imgTxt.text);
				var bgColor=this.bgColorPicker.selectedColor;
				xml.type=this.typeDrop.selectedLabel;
				delete xml.props.width;
				delete xml.props.sceneWidth;
				if(this.widthTxt.text==""){
					}else{
					if (this.widthCheck.selected){
						xml.props.sceneWidth=width;
						}else {
						xml.props.width=width;
					}
				}
				delete xml.props.height;
				delete xml.props.sceneHeight;
				if(this.heightTxt.text==""){
					}else{
					if (this.heightCheck.selected){
						xml.props.sceneHeight=height;
						}else {
						xml.props.height=height;
					}
				}
				xml.props.sceneColor=bgColor;
				if (Boolean(imgPath)&&FileTools.exist(imgPath)){
					imgPath=PageManager.copyPageBg(this._viewer.pagePath,imgPath);
					xml.props.sceneBg=FileManager.adptToCommonUrl(imgPath);
					}else {
					delete xml.props.sceneBg;
				}
				this._viewer.design.change()
				this._viewer.design.refreshBg();
				Notice.notify("Focus_design");
			}
		}

		__getset(1,SetPage,'instance',function(){
			return SetPage._instance ? SetPage._instance :SetPage._instance=new SetPage();
		},laya.editor.ui.page.SetPageUI._$SET_instance);

		SetPage._instance=null
		return SetPage;
	})(SetPageUI)


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-8-31 下午5:01:20
	*/
	//class laya.editor.view.page.MoveMultiPage extends laya.editor.ui.res.MoveResUI
	var MoveMultiPage=(function(_super){
		function MoveMultiPage(){
			this._files=null;
			this._tarDir=null;
			MoveMultiPage.__super.call(this);
		}

		__class(MoveMultiPage,'laya.editor.view.page.MoveMultiPage',_super);
		var __proto=MoveMultiPage.prototype;
		__proto.start=function(files,tarDir){
			this._files=files;
			this._tarDir=tarDir;
			var oldPage;
			if(this._files.length==1){
				oldPage=FileManager.getWorkRelativePath(this._files[0]).replace("laya/pages/","");
				}else{
				oldPage=Sys.lang("选中文件");
			};
			var newPage=FileManager.getWorkRelativePath(tarDir).replace("laya/pages/","");
			this.msgLbl.text=Sys.lang("确定移动{0}\n到{1}目录吗?",oldPage,newPage);
			this.updateCheck.selected=true;
			this.popup();
		}

		__proto.close=function(type){
			laya.ui.Dialog.prototype.close.call(this,type);
			if (type=="sure"){
				PagePanel.instance.moveFileList(this._files,this._tarDir,this.updateCheck.selected);
			}
		}

		__getset(1,MoveMultiPage,'instance',function(){
			return MoveMultiPage._instance ? MoveMultiPage._instance :MoveMultiPage._instance=new MoveMultiPage();
		},laya.editor.ui.res.MoveResUI._$SET_instance);

		MoveMultiPage._instance=null
		return MoveMultiPage;
	})(MoveResUI)


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-8-15 上午11:09:53
	*/
	//class laya.editor.view.BasicPanel extends laya.editor.ui.BasicPanelUI
	var BasicPanel=(function(_super){
		function BasicPanel(){
			this._resPath=null;
			this._refreshComplete=null;
			this._mouseIndex=0;
			this.isRefreshing=false;
			this._menu=null;
			this._mutiMenu=null;
			BasicPanel.__super.call(this);
			this.title=Sys.lang("组件");
			this.initPanel();
			this.resTree.spa