var window = window || global;
var document = document || (window.document = {});
/***********************************/
/*http://www.layabox.com 2016/05/19*/
/***********************************/
var Laya=window.Laya=(function(window,document){
	var Laya={
		__internals:[],
		__packages:{},
		__classmap:{'Object':Object,'Function':Function,'Array':Array,'String':String},
		__sysClass:{'object':'Object','array':'Array','string':'String','dictionary':'Dictionary'},
		__propun:{writable: true,enumerable: false,configurable: true},
		__presubstr:String.prototype.substr,
		__substr:function(ofs,sz){return arguments.length==1?Laya.__presubstr.call(this,ofs):Laya.__presubstr.call(this,ofs,sz>0?sz:(this.length+sz));},
		__init:function(_classs){_classs.forEach(function(o){o.__init$ && o.__init$();});},
		__isClass:function(o){return o && (o.__isclass || o==Object || o==String || o==Array);},
		__newvec:function(sz,value){
			var d=[];
			d.length=sz;
			for(var i=0;i<sz;i++) d[i]=value;
			return d;
		},
		__extend:function(d,b){
			for (var p in b){
				if (!b.hasOwnProperty(p)) continue;
				var g = Object.getOwnPropertyDescriptor(b, p).get, s = Object.getOwnPropertyDescriptor(b, p).set; 
				if ( g || s ) {
					g && Object.defineProperty(d, p, g);
					s && Object.defineProperty(d, p, s);
				}
				else d[p] = b[p];
			}
			function __() { Laya.un(this,'constructor',d); }__.prototype=b.prototype;d.prototype=new __();Laya.un(d.prototype,'__imps',Laya.__copy({},b.prototype.__imps));
		},
		__copy:function(dec,src){
			if(!src) return null;
			dec=dec||{};
			for(var i in src) dec[i]=src[i];
			return dec;
		},
		__package:function(name,o){
			if(Laya.__packages[name]) return;
			Laya.__packages[name]=true;
			var p=window,strs=name.split('.');
			if(strs.length>1){
				for(var i=0,sz=strs.length-1;i<sz;i++){
					var c=p[strs[i]];
					p=c?c:(p[strs[i]]={});
				}
			}
			p[strs[strs.length-1]] || (p[strs[strs.length-1]]=o||{});
		},
		__hasOwnProperty:function(name,o){
			o=o ||this;
		    function classHas(name,o){
				if(Object.hasOwnProperty.call(o.prototype,name)) return true;
				var s=o.prototype.__super;
				return s==null?null:classHas(name,s);
			}
			return (Object.hasOwnProperty.call(o,name)) || classHas(name,o.__class);
		},
		__typeof:function(o,value){
			if(!o || !value) return false;
			if(value===String) return (typeof o==='string');
			if(value===Number) return (typeof o==='number');
			if(value.__interface__) value=value.__interface__;
			else if(typeof value!='string')  return (o instanceof value);
			return (o.__imps && o.__imps[value]) || (o.__class==value);
		},
		__as:function(value,type){
			return (this.__typeof(value,type))?value:null;
		},		
		interface:function(name,_super){
			Laya.__package(name,{});
			var ins=Laya.__internals;
			var a=ins[name]=ins[name] || {self:name};
			if(_super)
			{
				var supers=_super.split(',');
				a.extend=[];
				for(var i=0;i<supers.length;i++){
					var name=supers[i];
					ins[name]=ins[name] || {self:name};
					a.extend.push(ins[name]);
				}
			}
			var o=window,words=name.split('.');
			for(var i=0;i<words.length-1;i++) o=o[words[i]];o[words[words.length-1]]={__interface__:name};
		},
		class:function(o,fullName,_super,miniName){
			_super && Laya.__extend(o,_super);
			if(fullName){
				Laya.__package(fullName,o);
				Laya.__classmap[fullName]=o;
				if(fullName.indexOf('.')>0){
					if(fullName.indexOf('laya.')==0){
						var paths=fullName.split('.');
						miniName=miniName || paths[paths.length-1];
						if(miniName!="Image")
						{
							if(Laya[miniName]) console.log("Warning!,this class["+miniName+"] already exist:",Laya[miniName]);
							Laya[miniName]=o;
						}
					}
				}
				else {
					if(fullName=="Main")
						window.Main=o;
					else{
						if(Laya[fullName]){
							console.log("Error!,this class["+fullName+"] already exist:",Laya[fullName]);
						}
						Laya[fullName]=o;
					}
				}
			}
			var un=Laya.un,p=o.prototype;
			un(p,'hasOwnProperty',Laya.__hasOwnProperty);
			un(p,'__class',o);
			un(p,'__super',_super);
			un(p,'__className',fullName);
			un(o,'__super',_super);
			un(o,'__className',fullName);
			un(o,'__isclass',true);
			un(o,'super',function(o){this.__super.call(o);});
		},
		imps:function(dec,src){
			if(!src) return null;
			var d=dec.__imps|| Laya.un(dec,'__imps',{});
			function __(name){
				var c,exs;
				if(! (c=Laya.__internals[name]) ) return;
				d[name]=true;
				if(!(exs=c.extend)) return;
				for(var i=0;i<exs.length;i++){
					__(exs[i].self);
				}
			}
			for(var i in src) __(i);
		},
		getset:function(isStatic,o,name,getfn,setfn){
			if(!isStatic){
				getfn && Laya.un(o,'_$get_'+name,getfn);
				setfn && Laya.un(o,'_$set_'+name,setfn);
			}
			else{
				getfn && (o['_$GET_'+name]=getfn);
				setfn && (o['_$SET_'+name]=setfn);
			}
			if(getfn && setfn) 
				Object.defineProperty(o,name,{get:getfn,set:setfn,enumerable:false});
			else{
				getfn && Object.defineProperty(o,name,{get:getfn,enumerable:false});
				setfn && Object.defineProperty(o,name,{set:setfn,enumerable:false});
			}
		},
		static:function(_class,def){
				for(var i=0,sz=def.length;i<sz;i+=2){
					if(def[i]=='length') 
						_class.length=def[i+1].call(_class);
					else{
						function tmp(){
							var name=def[i];
							var getfn=def[i+1];
							Object.defineProperty(_class,name,{
								get:function(){delete this[name];return this[name]=getfn.call(this);},
								set:function(v){delete this[name];this[name]=v;},enumerable: true,configurable: true});
						}
						tmp();
					}
				}
		},		
		un:function(obj,name,value){
			value || (value=obj[name]);
			Laya.__propun.value=value;
			Object.defineProperty(obj, name, Laya.__propun);
			return value;
		},
		uns:function(obj,names){
			names.forEach(function(o){Laya.un(obj,o)});
		}
	};

	window.console=window.console || ({log:function(){}});
	window.trace=window.console.log;
	Error.prototype.throwError=function(){throw arguments;};
	String.prototype.substr=Laya.__substr;
	Object.defineProperty(Array.prototype,'fixed',{enumerable: false});

	return Laya;
})(window,document);

(function(window,document,Laya){
	var __un=Laya.un,__uns=Laya.uns,__static=Laya.static,__class=Laya.class,__getset=Laya.getset,__newvec=Laya.__newvec;
	Laya.interface('laya.ui.IItem');
	Laya.interface('laya.ui.ISelect');
	Laya.interface('laya.ui.IRender');
	Laya.interface('laya.ui.IComponent');
	Laya.interface('laya.runtime.IMarket');
	Laya.interface('laya.filters.IFilter');
	Laya.interface('laya.display.ILayout');
	Laya.interface('laya.editor.core.IClip');
	Laya.interface('laya.resource.IDispose');
	Laya.interface('laya.runtime.IConchNode');
	Laya.interface('laya.editor.core.IContent');
	Laya.interface('laya.filters.IFilterAction');
	Laya.interface('laya.runtime.ICPlatformClass');
	Laya.interface('laya.resource.ICreateResource');
	Laya.interface('as3analyser.parser.struct.ICodePiece');
	Laya.interface('laya.editor.core.Wraps.xml.IXMLElement');
	Laya.interface('laya.ui.IBox','laya.ui.IComponent');
	/**
	*@private
	*/
	//class laya.utils.RunDriver
	var RunDriver=(function(){
		function RunDriver(){};
		__class(RunDriver,'laya.utils.RunDriver');
		RunDriver.FILTER_ACTIONS=[];
		RunDriver.pixelRatio=-1;
		RunDriver._charSizeTestDiv=null
		RunDriver.now=function(){
			return Date.now();
		}

		RunDriver.getWindow=function(){
			return window;
		}

		RunDriver.newWebGLContext=function(canvas,webGLName){
			return canvas.getContext(webGLName,{stencil:true,alpha:Config.isAlpha,antialias:Config.isAntialias,premultipliedAlpha:Config.premultipliedAlpha});
		}

		RunDriver.getPixelRatio=function(){
			if (RunDriver.pixelRatio < 0){
				var ctx=Browser.context;
				var backingStore=ctx.backingStorePixelRatio || ctx.webkitBackingStorePixelRatio || ctx.mozBackingStorePixelRatio || ctx.msBackingStorePixelRatio || ctx.oBackingStorePixelRatio || ctx.backingStorePixelRatio || 1;
				RunDriver.pixelRatio=(Browser.window.devicePixelRatio || 1)/ backingStore;
			}
			return RunDriver.pixelRatio;
		}

		RunDriver.getIncludeStr=function(name){
			return null;
		}

		RunDriver.createShaderCondition=function(conditionScript){
			var fn="(function() {return "+conditionScript+";})";
			return Browser.window.eval(fn);
		}

		RunDriver.measureText=function(txt,font){
			if (Render.isConchApp){
				var ctx=ConchTextCanvas;
				ctx.font=font;
				return ctx.measureText(txt);
			}
			if (RunDriver._charSizeTestDiv==null){
				RunDriver._charSizeTestDiv=Browser.createElement('div');
				RunDriver._charSizeTestDiv.style.cssText="z-index:10000000;padding:0px;position: absolute;left:0px;visibility:hidden;top:0px;background:white";
				Browser.container.appendChild(RunDriver._charSizeTestDiv);
			}
			RunDriver._charSizeTestDiv.style.font=font;
			RunDriver._charSizeTestDiv.innerText=txt==" " ? "i" :txt;
			return {width:RunDriver._charSizeTestDiv.offsetWidth,height:RunDriver._charSizeTestDiv.offsetHeight};
		}

		RunDriver.beginFlush=function(){
		};

		RunDriver.endFinish=function(){
		};

		RunDriver.addToAtlas=null
		RunDriver.flashFlushImage=function(atlasWebGLCanvas){
		};

		RunDriver.drawToCanvas=function(sprite,_renderType,canvasWidth,canvasHeight,offsetX,offsetY){
			var canvas=HTMLCanvas.create("2D");
			var context=new RenderContext(canvasWidth,canvasHeight,canvas);
			RenderSprite.renders[_renderType]._fun(sprite,context,offsetX,offsetY);
			return canvas;
		}

		RunDriver.createParticleTemplate2D=null
		RunDriver.createGLTextur=null;
		RunDriver.createWebGLContext2D=null;
		RunDriver.changeWebGLSize=function(w,h){
		};

		RunDriver.createRenderSprite=function(type,next){
			return new RenderSprite(type,next);
		}

		RunDriver.createFilterAction=function(type){
			return new ColorFilterAction();
		}

		RunDriver.createGraphics=function(){
			return new Graphics();
		}

		RunDriver.clear=function(value){
			Render._context.ctx.clear();
		}

		RunDriver.clearAtlas=function(value){
		};

		RunDriver.addTextureToAtlas=function(value){
		};

		RunDriver.getTexturePixels=function(value,x,y,width,height){
			return null;
		}

		RunDriver.skinAniSprite=function(){
			return null;
		}

		return RunDriver;
	})()


	/**
	*<code>Laya</code> 是全局对象的引用入口集。
	*/
	//class Laya
	var ___Laya=(function(){
		//function Laya(){};
		/**
		*表示是否捕获全局错误并弹出提示。
		*/
		__getset(1,Laya,'alertGlobalError',null,function(value){
			var erralert=0;
			if (value){
				Browser.window.onerror=function (msg,url,line,column,detail){
					if (erralert++< 5 && detail)
						alert("出错啦，请把此信息截图给研发商\n"+msg+"\n"+detail.stack);
				}
				}else {
				Browser.window.onerror=null;
			}
		});

		Laya.init=function(width,height,__plugins){
			var plugins=[];for(var i=2,sz=arguments.length;i<sz;i++)plugins.push(arguments[i]);
			if (Laya._isinit)return;
			Laya._isinit=true;
			Browser.__init__();
			Context.__init__();
			Graphics.__init__();
			Laya.timer=new Timer();
			Laya.loader=new LoaderManager();
			for (var i=0,n=plugins.length;i < n;i++){
				if (plugins[i].enable)plugins[i].enable();
			}
			Font.__init__();
			Style.__init__();
			ResourceManager.__init__();
			CacheManger.beginCheck();
			Laya.stageBox=Laya.stage=new Stage();
			Laya.stage.conchModel&&Laya.stage.conchModel.setRootNode();
			var location=Browser.window.location;
			var pathName=location.pathname;
			pathName=pathName.charAt(2)==':' ? pathName.substring(1):pathName;
			URL.rootPath=URL.basePath=URL.getPath(location.protocol=="file:" ? pathName :location.protocol+"//"+location.host+location.pathname);
			Laya.render=new Render(0,0);
			Laya.stage.size(width,height);
			RenderSprite.__init__();
			KeyBoardManager.__init__();
			MouseManager.instance.__init__(Laya.stage,Render.canvas);
			Input.__init__();
			SoundManager.autoStopMusic=true;
			LocalStorage.__init__();
			return Render.canvas;
		}

		Laya.stage=null;
		Laya.timer=null;
		Laya.loader=null;
		Laya.render=null
		Laya.version="1.6.1Beta2";
		Laya.stageBox=null
		Laya._isinit=false;
		__static(Laya,
		['conchMarket',function(){return this.conchMarket=window.conch?conchMarket:null;},'PlatformClass',function(){return this.PlatformClass=window.PlatformClass;}
		]);
		return Laya;
	})()


	/**
	*...
	*@author ww
	*/
	//class LayaAirCmdTool
	var LayaAirCmdTool=(function(){
		function LayaAirCmdTool(){
			this.tarProject=null;
			this.releasemode="normal";
			this.appPath=null;
			this.clear="false";
			this.scriptPath=null;
			this.exportUICode="true";
			this.exportRes="true";
			LayaAirCmdTool.I=this;
			this.init();
		}

		__class(LayaAirCmdTool,'LayaAirCmdTool');
		var __proto=LayaAirCmdTool.prototype;
		__proto.init=function(){
			SystemSetting.isCMDVer=true;
			TypeManager.init();
			var argv;
			argv=process.argv;;
			console.log("argv:",argv);
			this.parseCMD(argv);
			CMDShell.init();
			FileTools.init2();
			this.appPath=this.getAbsPath("./");
			OSInfo.init();
			Browser.userAgent=OSInfo.type;
			FileTools.tempApp=FileManager.getPath(OSInfo.env["APPDATA"],"LayaAirIDE");
			Device.dataPath=FileManager.getPath(OSInfo.env["APPDATA"],"LayaAirIDE");
			SystemSetting.appPath=this.appPath;
			SystemSetting.tempPath=FileManager.getAppPath("data");
			console.log("appPath:",this.appPath);
			ExportManager.isCmdVer=true;
			TemplateManager.init();
			CodeTplManager.initCodeTpls();
			this.openProject(this.tarProject,this.releasemode=="release");
		}

		__proto.getAbsPath=function(path){
			return FileManager.getPath(FileTools.getFolder(this.scriptPath),path);
		}

		__proto.initConfig=function(){
			var configO;
			configO=FileManager.readJSONFile("./CmdConfig.json");
			console.log("configO:",configO);
			var tAppPath=configO.appPath;
			tAppPath=FileManager.getPath(FileTools.getFolder(this.scriptPath),tAppPath);
			console.log("appPath:",tAppPath);
			this.appPath=tAppPath;
		}

		__proto.parseCMD=function(args){
			this.scriptPath=args[1];
			this.tarProject=args[2];
			var i=0,len=0;
			len=args.length;
			var tParam;
			var pArr;
			for (i=3;i < len;i++){
				tParam=args[i];
				if (tParam.indexOf("=")> 0){
					pArr=tParam.split("=");
					this[pArr[0]]=pArr[1];
				}
			}
		}

		__proto.openProject=function(projectPath,release){
			(release===void 0)&& (release=true);
			console.log("openProject:",projectPath);
			ProjectManager.loadProject(projectPath,null,true);
			console.log("assetsPath:",SystemSetting.assetsPath);
			ResFileManager.setPath(SystemSetting.assetsPath);
			ResStyleManager.init();
			PageStyleManager.init();
			ExportManager.packingEndHandler=Utils.bind(this.packingEnd,this);
			ExportManager.clearRes=false;
			var ifExportCode=false;
			ifExportCode=this.exportUICode !="false";
			var ifExportRes=false;
			ifExportRes=this.exportRes !="false";
			if (this.clear !="false"){
				if (ifExportCode){
					ExportManager.clear();
				}
				ExportManager.clearRes=true;
			}
			ExportManager.doExportLater(release,ifExportCode,ifExportRes);
		}

		__proto.packingEnd=function(){
			console.log("Packing complete");
			console.log("All Work complete");
		}

		LayaAirCmdTool.I=null
		return LayaAirCmdTool;
	})()


	/**
	*Config 用于配置一些全局参数。
	*/
	//class Config
	var Config=(function(){
		function Config(){};
		__class(Config,'Config');
		Config.WebGLTextCacheCount=500;
		Config.atlasEnable=false;
		Config.showCanvasMark=false;
		Config.CPUMemoryLimit=120 *1024 *1024;
		Config.GPUMemoryLimit=160 *1024 *1024;
		Config.animationInterval=50;
		Config.isAntialias=false;
		Config.isAlpha=false;
		Config.premultipliedAlpha=false;
		return Config;
	})()


	/**
	*<code>EventDispatcher</code> 类是可调度事件的所有类的基类。
	*/
	//class laya.events.EventDispatcher
	var EventDispatcher=(function(){
		var EventHandler;
		function EventDispatcher(){
			this._events=null;
			Object.defineProperty(this,"_events",{enumerable:false});
		}

		__class(EventDispatcher,'laya.events.EventDispatcher');
		var __proto=EventDispatcher.prototype;
		/**
		*检查 EventDispatcher 对象是否为特定事件类型注册了任何侦听器。
		*@param type 事件的类型。
		*@return 如果指定类型的侦听器已注册，则值为 true；否则，值为 false。
		*/
		__proto.hasListener=function(type){
			var listener=this._events && this._events[type];
			return !!listener;
		}

		/**
		*派发事件。
		*@param type 事件类型。
		*@param data 回调数据。
		*<b>注意：</b>如果是需要传递多个参数 p1,p2,p3,...可以使用数组结构如：[p1,p2,p3,...] ；如果需要回调单个参数 p 是一个数组，则需要使用结构如：[p]，其他的单个参数 p ，可以直接传入参数 p。
		*@return 此事件类型是否有侦听者，如果有侦听者则值为 true，否则值为 false。
		*/
		__proto.event=function(type,data){
			if (!this._events || !this._events[type])return false;
			var listeners=this._events[type];
			if (listeners.run){
				if (listeners.once)delete this._events[type];
				data !=null ? listeners.runWith(data):listeners.run();
				}else {
				for (var i=0,n=listeners.length;i < n;i++){
					var listener=listeners[i];
					if (listener){
						(data !=null)? listener.runWith(data):listener.run();
					}
					if (!listener || listener.once){
						listeners.splice(i,1);
						i--;
						n--;
					}
				}
				if (listeners.length===0 && this._events)delete this._events[type];
			}
			return true;
		}

		/**
		*使用 EventDispatcher 对象注册指定类型的事件侦听器对象，以使侦听器能够接收事件通知。
		*@param type 事件的类型。
		*@param caller 事件侦听函数的执行域。
		*@param listener 事件侦听函数。
		*@param args 事件侦听函数的回调参数。
		*@return 此 EventDispatcher 对象。
		*/
		__proto.on=function(type,caller,listener,args){
			return this._createListener(type,caller,listener,args,false);
		}

		/**
		*使用 EventDispatcher 对象注册指定类型的事件侦听器对象，以使侦听器能够接收事件通知，此侦听事件响应一次后自动移除。
		*@param type 事件的类型。
		*@param caller 事件侦听函数的执行域。
		*@param listener 事件侦听函数。
		*@param args 事件侦听函数的回调参数。
		*@return 此 EventDispatcher 对象。
		*/
		__proto.once=function(type,caller,listener,args){
			return this._createListener(type,caller,listener,args,true);
		}

		/**@private */
		__proto._createListener=function(type,caller,listener,args,once,offBefore){
			(offBefore===void 0)&& (offBefore=true);
			offBefore && this.off(type,caller,listener,once);
			var handler=EventHandler.create(caller || this,listener,args,once);
			this._events || (this._events={});
			var events=this._events;
			if (!events[type])events[type]=handler;
			else {
				if (!events[type].run)events[type].push(handler);
				else events[type]=[events[type],handler];
			}
			return this;
		}

		/**
		*从 EventDispatcher 对象中删除侦听器。
		*@param type 事件的类型。
		*@param caller 事件侦听函数的执行域。
		*@param listener 事件侦听函数。
		*@param onceOnly 如果值为 true ,则只移除通过 once 方法添加的侦听器。
		*@return 此 EventDispatcher 对象。
		*/
		__proto.off=function(type,caller,listener,onceOnly){
			(onceOnly===void 0)&& (onceOnly=false);
			if (!this._events || !this._events[type])return this;
			var listeners=this._events[type];
			if (listener !=null){
				if (listeners.run){
					if ((!caller || listeners.caller===caller)&& listeners.method===listener && (!onceOnly || listeners.once)){
						delete this._events[type];
						listeners.recover();
					}
					}else {
					var count=0;
					for (var i=0,n=listeners.length;i < n;i++){
						var item=listeners[i];
						if (item && (!caller || item.caller===caller)&& item.method===listener && (!onceOnly || item.once)){
							count++;
							listeners[i]=null;
							item.recover();
						}
					}
					if (count===n)delete this._events[type];
				}
			}
			return this;
		}

		/**
		*从 EventDispatcher 对象中删除指定事件类型的所有侦听器。
		*@param type 事件类型，如果值为 null，则移除本对象所有类型的侦听器。
		*@return 此 EventDispatcher 对象。
		*/
		__proto.offAll=function(type){
			var events=this._events;
			if (!events)return this;
			if (type){
				this._recoverHandlers(events[type]);
				delete events[type];
				}else {
				for (var name in events){
					this._recoverHandlers(events[name]);
				}
				this._events=null;
			}
			return this;
		}

		__proto._recoverHandlers=function(arr){
			if (!arr)return;
			if (arr.run){
				arr.recover();
				}else {
				for (var i=arr.length-1;i >-1;i--){
					if (arr[i]){
						arr[i].recover();
						arr[i]=null;
					}
				}
			}
		}

		/**
		*检测指定事件类型是否是鼠标事件。
		*@param type 事件的类型。
		*@return 如果是鼠标事件，则值为 true;否则，值为 false。
		*/
		__proto.isMouseEvent=function(type){
			return EventDispatcher.MOUSE_EVENTS[type];
		}

		EventDispatcher.MOUSE_EVENTS={"rightmousedown":true,"rightmouseup":true,"rightclick":true,"mousedown":true,"mouseup":true,"mousemove":true,"mouseover":true,"mouseout":true,"click":true,"doubleclick":true};
		EventDispatcher.__init$=function(){
			/**@private */
			//class EventHandler extends laya.utils.Handler
			EventHandler=(function(_super){
				function EventHandler(caller,method,args,once){
					EventHandler.__super.call(this,caller,method,args,once);
				}
				__class(EventHandler,'',_super);
				var __proto=EventHandler.prototype;
				__proto.recover=function(){
					if (this._id > 0){
						this._id=0;
						EventHandler._pool.push(this.clear());
					}
				}
				EventHandler.create=function(caller,method,args,once){
					(once===void 0)&& (once=true);
					if (EventHandler._pool.length)return EventHandler._pool.pop().setTo(caller,method,args,once);
					return new EventHandler(caller,method,args,once);
				}
				EventHandler._pool=[];
				return EventHandler;
			})(Handler)
		}

		return EventDispatcher;
	})()


	/**
	*<p><code>Handler</code> 是事件处理器类。</p>
	*<p>推荐使用 Handler.create()方法从对象池创建，减少对象创建消耗。</p>
	*<p><b>注意：</b>由于鼠标事件也用本对象池，不正确的回收及调用，可能会影响鼠标事件的执行。</p>
	*/
	//class laya.utils.Handler
	var Handler=(function(){
		function Handler(caller,method,args,once){
			//this.caller=null;
			//this.method=null;
			//this.args=null;
			this.once=false;
			this._id=0;
			(once===void 0)&& (once=false);
			this.setTo(caller,method,args,once);
		}

		__class(Handler,'laya.utils.Handler');
		var __proto=Handler.prototype;
		/**
		*设置此对象的指定属性值。
		*@param caller 执行域(this)。
		*@param method 回调方法。
		*@param args 携带的参数。
		*@param once 是否只执行一次，如果为true，执行后执行recover()进行回收。
		*@return 返回 handler 本身。
		*/
		__proto.setTo=function(caller,method,args,once){
			this._id=Handler._gid++;
			this.caller=caller;
			this.method=method;
			this.args=args;
			this.once=once;
			return this;
		}

		/**
		*执行处理器。
		*/
		__proto.run=function(){
			if (this.method==null)return null;
			var id=this._id;
			var result=this.method.apply(this.caller,this.args);
			this._id===id && this.once && this.recover();
			return result;
		}

		/**
		*执行处理器，携带额外数据。
		*@param data 附加的回调数据，可以是单数据或者Array(作为多参)。
		*/
		__proto.runWith=function(data){
			if (this.method==null)return null;
			var id=this._id;
			if (data==null)
				var result=this.method.apply(this.caller,this.args);
			else if (!this.args && !data.unshift)result=this.method.call(this.caller,data);
			else if (this.args)result=this.method.apply(this.caller,this.args.concat(data));
			else result=this.method.apply(this.caller,data);
			this._id===id && this.once && this.recover();
			return result;
		}

		/**
		*清理对象引用。
		*/
		__proto.clear=function(){
			this.caller=null;
			this.method=null;
			this.args=null;
			return this;
		}

		/**
		*清理并回收到 Handler 对象池内。
		*/
		__proto.recover=function(){
			if (this._id > 0){
				this._id=0;
				Handler._pool.push(this.clear());
			}
		}

		Handler.create=function(caller,method,args,once){
			(once===void 0)&& (once=true);
			if (Handler._pool.length)return Handler._pool.pop().setTo(caller,method,args,once);
			return new Handler(caller,method,args,once);
		}

		Handler._pool=[];
		Handler._gid=1;
		return Handler;
	})()


	/**
	*<code>BitmapFont</code> 是位图字体类，用于定义位图字体信息。
	*/
	//class laya.display.BitmapFont
	var BitmapFont=(function(){
		function BitmapFont(){
			this._texture=null;
			this._fontCharDic={};
			this._fontWidthMap={};
			this._complete=null;
			this._path=null;
			this._maxWidth=0;
			this._spaceWidth=10;
			this._padding=null;
			this.fontSize=12;
			this.autoScaleSize=false;
			this.letterSpacing=0;
		}

		__class(BitmapFont,'laya.display.BitmapFont');
		var __proto=BitmapFont.prototype;
		/**
		*通过指定位图字体文件路径，加载位图字体文件。
		*@param path 位图字体文件的路径。
		*@param complete 加载完成的回调，通知上层字体文件已经完成加载并解析。
		*/
		__proto.loadFont=function(path,complete){
			this._path=path;
			this._complete=complete;
			Laya.loader.load([{url:this._path,type:"xml"},{url:this._path.replace(".fnt",".png"),type:"image"}],Handler.create(this,this.onLoaded));
		}

		/**
		*@private
		*/
		__proto.onLoaded=function(){
			this.parseFont(Loader.getRes(this._path),Loader.getRes(this._path.replace(".fnt",".png")));
			this._complete && this._complete.run();
		}

		/**
		*解析字体文件。
		*@param xml 字体文件XML。
		*@param texture 字体的纹理。
		*/
		__proto.parseFont=function(xml,texture){
			if (xml==null || texture==null)return;
			this._texture=texture;
			var tX=0;
			var tScale=1;
			var tInfo=xml.getElementsByTagName("info");
			this.fontSize=parseInt(tInfo[0].attributes["size"].nodeValue);
			var tPadding=tInfo[0].attributes["padding"].nodeValue;
			var tPaddingArray=tPadding.split(",");
			this._padding=[parseInt(tPaddingArray[0]),parseInt(tPaddingArray[1]),parseInt(tPaddingArray[2]),parseInt(tPaddingArray[3])];
			var chars=xml.getElementsByTagName("char");
			var i=0;
			for (i=0;i < chars.length;i++){
				var tAttribute=chars[i].attributes;
				var tId=parseInt(tAttribute["id"].nodeValue);
				var xOffset=parseInt(tAttribute["xoffset"].nodeValue)/ tScale;
				var yOffset=parseInt(tAttribute["yoffset"].nodeValue)/ tScale;
				var xAdvance=parseInt(tAttribute["xadvance"].nodeValue)/ tScale;
				var region=new Rectangle();
				region.x=parseInt(tAttribute["x"].nodeValue);
				region.y=parseInt(tAttribute["y"].nodeValue);
				region.width=parseInt(tAttribute["width"].nodeValue);
				region.height=parseInt(tAttribute["height"].nodeValue);
				var tTexture=Texture.create(texture,region.x,region.y,region.width,region.height,xOffset,yOffset);
				this._maxWidth=Math.max(this._maxWidth,xAdvance+this.letterSpacing);
				this._fontCharDic[tId]=tTexture;
				this._fontWidthMap[tId]=xAdvance;
			}
		}

		/**
		*获取指定字符的字体纹理对象。
		*@param char 字符。
		*@return 指定的字体纹理对象。
		*/
		__proto.getCharTexture=function(char){
			return this._fontCharDic[char.charCodeAt(0)];
		}

		/**
		*销毁位图字体，调用Text.unregisterBitmapFont 时，默认会销毁。
		*/
		__proto.destroy=function(){
			if (this._texture){
				for (var p in this._fontCharDic){
					var tTexture=this._fontCharDic[p];
					if (tTexture)tTexture.destroy();
				}
				this._texture.destroy();
				this._fontCharDic=null;
				this._fontWidthMap=null;
				this._texture=null;
			}
		}

		/**
		*设置空格的宽（如果字体库有空格，这里就可以不用设置了）。
		*@param spaceWidth 宽度，单位为像素。
		*/
		__proto.setSpaceWidth=function(spaceWidth){
			this._spaceWidth=spaceWidth;
		}

		/**
		*获取指定字符的宽度。
		*@param char 字符。
		*@return 宽度。
		*/
		__proto.getCharWidth=function(char){
			var code=char.charCodeAt(0);
			if (this._fontWidthMap[code])return this._fontWidthMap[code]+this.letterSpacing;
			if (char==" ")return this._spaceWidth+this.letterSpacing;
			return 0;
		}

		/**
		*获取指定文本内容的宽度。
		*@param text 文本内容。
		*@return 宽度。
		*/
		__proto.getTextWidth=function(text){
			var tWidth=0;
			for (var i=0,n=text.length;i < n;i++){
				tWidth+=this.getCharWidth(text.charAt(i));
			}
			return tWidth;
		}

		/**
		*获取最大字符宽度。
		*/
		__proto.getMaxWidth=function(){
			return this._maxWidth;
		}

		/**
		*获取最大字符高度。
		*/
		__proto.getMaxHeight=function(){
			return this.fontSize;
		}

		/**
		*@private
		*将指定的文本绘制到指定的显示对象上。
		*/
		__proto.drawText=function(text,sprite,drawX,drawY,align,width){
			var tWidth=this.getTextWidth(text);
			var tTexture;
			var dx=0;
			align==="center" && (dx=(width-tWidth)/ 2);
			align==="right" && (dx=(width-tWidth));
			var tX=0;
			for (var i=0,n=text.length;i < n;i++){
				tTexture=this.getCharTexture(text.charAt(i));
				if (tTexture){
					sprite.graphics.drawTexture(tTexture,drawX+tX+dx,drawY);
					tX+=this.getCharWidth(text.charAt(i));
				}
			}
		}

		return BitmapFont;
	})()


	/**
	*@private
	*<code>Style</code> 类是元素样式定义类。
	*/
	//class laya.display.css.Style
	var Style=(function(){
		function Style(){
			this.alpha=1;
			this.visible=true;
			this.scrollRect=null;
			this.blendMode=null;
			this._type=0;
			this._tf=Style._TF_EMPTY;
		}

		__class(Style,'laya.display.css.Style');
		var __proto=Style.prototype;
		__proto.getTransform=function(){
			return this._tf;
		}

		__proto.setTransform=function(value){
			this._tf=value==='none' || !value ? Style._TF_EMPTY :value;
		}

		__proto.setTranslateX=function(value){
			this._tf===Style._TF_EMPTY && (this._tf=new TransformInfo());
			this._tf.translateX=value;
		}

		__proto.setTranslateY=function(value){
			this._tf===Style._TF_EMPTY && (this._tf=new TransformInfo());
			this._tf.translateY=value;
		}

		__proto.setScaleX=function(value){
			this._tf===Style._TF_EMPTY && (this._tf=new TransformInfo());
			this._tf.scaleX=value;
		}

		__proto.setScale=function(x,y){
			this._tf===Style._TF_EMPTY && (this._tf=new TransformInfo());
			this._tf.scaleX=x;
			this._tf.scaleY=y;
		}

		__proto.setScaleY=function(value){
			this._tf===Style._TF_EMPTY && (this._tf=new TransformInfo());
			this._tf.scaleY=value;
		}

		__proto.setRotate=function(value){
			this._tf===Style._TF_EMPTY && (this._tf=new TransformInfo());
			this._tf.rotate=value;
		}

		__proto.setSkewX=function(value){
			this._tf===Style._TF_EMPTY && (this._tf=new TransformInfo());
			this._tf.skewX=value;
		}

		__proto.setSkewY=function(value){
			this._tf===Style._TF_EMPTY && (this._tf=new TransformInfo());
			this._tf.skewY=value;
		}

		/**销毁此对象。*/
		__proto.destroy=function(){
			this.scrollRect=null;
		}

		/**@private */
		__proto.render=function(sprite,context,x,y){}
		/**@private */
		__proto.getCSSStyle=function(){
			return CSSStyle.EMPTY;
		}

		/**@private */
		__proto._enableLayout=function(){
			return false;
		}

		/**X 轴缩放值。*/
		__getset(0,__proto,'scaleX',function(){
			return this._tf.scaleX;
			},function(value){
			this.setScaleX(value);
		});

		/**元素应用的 2D 或 3D 转换的值。该属性允许我们对元素进行旋转、缩放、移动或倾斜。*/
		__getset(0,__proto,'transform',function(){
			return this.getTransform();
			},function(value){
			this.setTransform(value);
		});

		/**定义转换，只是用 X 轴的值。*/
		__getset(0,__proto,'translateX',function(){
			return this._tf.translateX;
			},function(value){
			this.setTranslateX(value);
		});

		/**定义转换，只是用 Y 轴的值。*/
		__getset(0,__proto,'translateY',function(){
			return this._tf.translateY;
			},function(value){
			this.setTranslateY(value);
		});

		/**Y 轴缩放值。*/
		__getset(0,__proto,'scaleY',function(){
			return this._tf.scaleY;
			},function(value){
			this.setScaleY(value);
		});

		/**表示元素是否显示为块级元素。*/
		__getset(0,__proto,'block',function(){
			return (this._type & 0x1)!=0;
		});

		/**定义沿着 Y 轴的 2D 倾斜转换。*/
		__getset(0,__proto,'skewY',function(){
			return this._tf.skewY;
			},function(value){
			this.setSkewY(value);
		});

		/**定义旋转角度。*/
		__getset(0,__proto,'rotate',function(){
			return this._tf.rotate;
			},function(value){
			this.setRotate(value);
		});

		/**定义沿着 X 轴的 2D 倾斜转换。*/
		__getset(0,__proto,'skewX',function(){
			return this._tf.skewX;
			},function(value){
			this.setSkewX(value);
		});

		/**表示元素的左内边距。*/
		__getset(0,__proto,'paddingLeft',function(){
			return 0;
		});

		/**表示元素的上内边距。*/
		__getset(0,__proto,'paddingTop',function(){
			return 0;
		});

		/**是否为绝对定位。*/
		__getset(0,__proto,'absolute',function(){
			return true;
		});

		Style.__init__=function(){
			Style._TF_EMPTY=new TransformInfo();
			Style.EMPTY=new Style();
		}

		Style.EMPTY=null
		Style._TF_EMPTY=null
		return Style;
	})()


	/**
	*@private
	*<code>Font</code> 类是字体显示定义类。
	*/
	//class laya.display.css.Font
	var Font=(function(){
		function Font(src){
			this._type=0;
			this._weight=0;
			this._decoration=null;
			this._text=null;
			this.indent=0;
			this._color=Color.create(Font.defaultColor);
			this.family=Font.defaultFamily;
			this.stroke=Font._STROKE;
			this.size=Font.defaultSize;
			src && src!==Font.EMPTY && src.copyTo(this);
		}

		__class(Font,'laya.display.css.Font');
		var __proto=Font.prototype;
		/**
		*字体样式字符串。
		*/
		__proto.set=function(value){
			this._text=null;
			var strs=value.split(' ');
			for (var i=0,n=strs.length;i < n;i++){
				var str=strs[i];
				switch (str){
					case 'italic':
						this.italic=true;
						continue ;
					case 'bold':
						this.bold=true;
						continue ;
					}
				if (str.indexOf('px')> 0){
					this.size=parseInt(str);
					this.family=strs[i+1];
					i++;
					continue ;
				}
			}
		}

		/**
		*返回字体样式字符串。
		*@return 字体样式字符串。
		*/
		__proto.toString=function(){
			this._text=""
			this.italic && (this._text+="italic ");
			this.bold && (this._text+="bold ");
			return this._text+=this.size+"px "+this.family;
		}

		/**
		*将当前的属性值复制到传入的 <code>Font</code> 对象。
		*@param dec 一个 Font 对象。
		*/
		__proto.copyTo=function(dec){
			dec._type=this._type;
			dec._text=this._text;
			dec._weight=this._weight;
			dec._color=this._color;
			dec.family=this.family;
			dec.stroke=this.stroke !=Font._STROKE ? this.stroke.slice():Font._STROKE;
			dec.indent=this.indent;
			dec.size=this.size;
		}

		/**
		*表示是否为密码格式。
		*/
		__getset(0,__proto,'password',function(){
			return (this._type & 0x400)!==0;
			},function(value){
			value ? (this._type |=0x400):(this._type &=~0x400);
		});

		/**
		*表示颜色字符串。
		*/
		__getset(0,__proto,'color',function(){
			return this._color.strColor;
			},function(value){
			this._color=Color.create(value);
		});

		/**
		*表示是否为斜体。
		*/
		__getset(0,__proto,'italic',function(){
			return (this._type & 0x200)!==0;
			},function(value){
			value ? (this._type |=0x200):(this._type &=~0x200);
		});

		/**
		*表示是否为粗体。
		*/
		__getset(0,__proto,'bold',function(){
			return (this._type & 0x800)!==0;
			},function(value){
			value ? (this._type |=0x800):(this._type &=~0x800);
		});

		/**
		*文本的粗细。
		*/
		__getset(0,__proto,'weight',function(){
			return ""+this._weight;
			},function(value){
			var weight=0;
			switch (value){
				case 'normal':
					break ;
				case 'bold':
					this.bold=true;
					weight=700;
					break ;
				case 'bolder':
					weight=800;
					break ;
				case 'lighter':
					weight=100;
					break ;
				default :
					weight=parseInt(value);
				}
			this._weight=weight;
			this._text=null;
		});

		/**
		*规定添加到文本的修饰。
		*/
		__getset(0,__proto,'decoration',function(){
			return this._decoration ? this._decoration.value :"none";
			},function(value){
			var strs=value.split(' ');
			this._decoration || (this._decoration={});
			switch (strs[0]){
				case '_':
					this._decoration.type='underline'
					break ;
				case '-':
					this._decoration.type='line-through'
					break ;
				case 'overline':
					this._decoration.type='overline'
					break ;
				default :
					this._decoration.type=strs[0];
				}
			strs[1] && (this._decoration.color=Color.create(strs));
			this._decoration.value=value;
		});

		Font.__init__=function(){
			Font.EMPTY=new Font(null);
		}

		Font.EMPTY=null
		Font.defaultColor="#000000";
		Font.defaultSize=12;
		Font.defaultFamily="Arial";
		Font.defaultFont="12px Arial";
		Font._STROKE=[0,"#000000"];
		Font._ITALIC=0x200;
		Font._PASSWORD=0x400;
		Font._BOLD=0x800;
		return Font;
	})()


	/**
	*@private
	*/
	//class laya.display.css.TransformInfo
	var TransformInfo=(function(){
		function TransformInfo(){
			this.translateX=0;
			this.translateY=0;
			this.scaleX=1;
			this.scaleY=1;
			this.rotate=0;
			this.skewX=0;
			this.skewY=0;
		}

		__class(TransformInfo,'laya.display.css.TransformInfo');
		return TransformInfo;
	})()


	/**
	*<code>Graphics</code> 类用于创建绘图显示对象。
	*@see laya.display.Sprite#graphics
	*/
	//class laya.display.Graphics
	var Graphics=(function(){
		function Graphics(){
			//this._sp=null;
			this._one=null;
			this._cmds=null;
			//this._temp=null;
			//this._bounds=null;
			//this._rstBoundPoints=null;
			//this._vectorgraphArray=null;
			this._render=this._renderEmpty;
			this._render=this._renderEmpty;
			if (Render.isConchNode){
				this._nativeObj=new _conchGraphics();;
				this.id=this._nativeObj.conchID;;
			}
		}

		__class(Graphics,'laya.display.Graphics');
		var __proto=Graphics.prototype;
		/**
		*<p>销毁此对象。</p>
		*/
		__proto.destroy=function(){
			this.clear();
			this._temp=null;
			this._bounds=null;
			this._rstBoundPoints=null;
			this._sp && (this._sp._renderType=0);
			this._sp=null;
		}

		/**
		*<p>清空绘制命令。</p>
		*/
		__proto.clear=function(){
			this._one=null;
			this._render=this._renderEmpty;
			this._cmds=null;
			this._temp && (this._temp.length=0);
			this._sp && (this._sp._renderType &=~0x01);
			this._sp && (this._sp._renderType &=~0x200);
			this._repaint();
			if (this._vectorgraphArray){
				for (var i=0,n=this._vectorgraphArray.length;i < n;i++){
					VectorGraphManager.getInstance().deleteShape(this._vectorgraphArray[i]);
				}
				this._vectorgraphArray.length=0;
			}
		}

		/**
		*@private
		*重绘此对象。
		*/
		__proto._repaint=function(){
			this._temp && (this._temp.length=0);
			this._sp && this._sp.repaint();
		}

		/**@private */
		__proto._isOnlyOne=function(){
			return !this._cmds || this._cmds.length===0;
		}

		/**
		*获取位置及宽高信息矩阵(比较耗，尽量少用)。
		*@return 位置与宽高组成的 一个 Rectangle 对象。
		*/
		__proto.getBounds=function(){
			if (!this._bounds || !this._temp || this._temp.length < 1){
				this._bounds=Rectangle._getWrapRec(this.getBoundPoints(),this._bounds)
			}
			return this._bounds;
		}

		/**
		*@private
		*获取端点列表。
		*/
		__proto.getBoundPoints=function(){
			if (!this._temp || this._temp.length < 1)
				this._temp=this._getCmdPoints();
			return this._rstBoundPoints=Utils.copyArray(this._rstBoundPoints,this._temp);
		}

		__proto._addCmd=function(a){
			this._cmds=this._cmds || [];
			a.callee=a.shift();
			this._cmds.push(a);
		}

		__proto._getCmdPoints=function(){
			var context=Render._context;
			var cmds=this._cmds;
			var rst;
			rst=this._temp || (this._temp=[]);
			rst.length=0;
			if (!cmds && this._one !=null){
				Graphics._tempCmds.length=0;
				Graphics._tempCmds.push(this._one);
				cmds=Graphics._tempCmds;
			}
			if (!cmds)
				return rst;
			var matrixs;
			matrixs=Graphics._tempMatrixArrays;
			matrixs.length=0;
			var tMatrix=Graphics._initMatrix;
			tMatrix.identity();
			var tempMatrix=Graphics._tempMatrix;
			var cmd;
			for (var i=0,n=cmds.length;i < n;i++){
				cmd=cmds[i];
				switch (cmd.callee){
					case context._save:
					case 7:
						matrixs.push(tMatrix);
						tMatrix=tMatrix.clone();
						break ;
					case context._restore:
					case 8:
						tMatrix=matrixs.pop();
						break ;
					case context._scale:
					case 5:
						tempMatrix.identity();
						tempMatrix.translate(-cmd[2],-cmd[3]);
						tempMatrix.scale(cmd[0],cmd[1]);
						tempMatrix.translate(cmd[2],cmd[3]);
						this._switchMatrix(tMatrix,tempMatrix);
						break ;
					case context._rotate:
					case 3:
						tempMatrix.identity();
						tempMatrix.translate(-cmd[1],-cmd[2]);
						tempMatrix.rotate(cmd[0]);
						tempMatrix.translate(cmd[1],cmd[2]);
						this._switchMatrix(tMatrix,tempMatrix);
						break ;
					case context._translate:
					case 6:
						tempMatrix.identity();
						tempMatrix.translate(cmd[0],cmd[1]);
						this._switchMatrix(tMatrix,tempMatrix);
						break ;
					case context._transform:
					case 4:
						tempMatrix.identity();
						tempMatrix.translate(-cmd[1],-cmd[2]);
						tempMatrix.concat(cmd[0]);
						tempMatrix.translate(cmd[1],cmd[2]);
						this._switchMatrix(tMatrix,tempMatrix);
						break ;
					case 16:
					case 24:
						Graphics._addPointArrToRst(rst,Rectangle._getBoundPointS(cmd[0],cmd[1],cmd[2],cmd[3]),tMatrix);
						break ;
					case 17:
						tMatrix.copyTo(tempMatrix);
						tempMatrix.concat(cmd[4]);
						Graphics._addPointArrToRst(rst,Rectangle._getBoundPointS(cmd[0],cmd[1],cmd[2],cmd[3]),tempMatrix);
						break ;
					case context._drawTexture:
					case context._fillTexture:
						if (cmd[3] && cmd[4]){
							Graphics._addPointArrToRst(rst,Rectangle._getBoundPointS(cmd[1],cmd[2],cmd[3],cmd[4]),tMatrix);
							}else {
							var tex=cmd[0];
							Graphics._addPointArrToRst(rst,Rectangle._getBoundPointS(cmd[1],cmd[2],tex.width,tex.height),tMatrix);
						}
						break ;
					case context._drawTextureWithTransform:;
						var drawMatrix;
						if (cmd[5]){
							tMatrix.copyTo(tempMatrix);
							tempMatrix.concat(cmd[5]);
							drawMatrix=tempMatrix;
							}else {
							drawMatrix=tMatrix;
						}
						if (cmd[3] && cmd[4]){
							Graphics._addPointArrToRst(rst,Rectangle._getBoundPointS(cmd[1],cmd[2],cmd[3],cmd[4]),drawMatrix);
							}else {
							tex=cmd[0];
							Graphics._addPointArrToRst(rst,Rectangle._getBoundPointS(cmd[1],cmd[2],tex.width,tex.height),drawMatrix);
						}
						break ;
					case context._drawRect:
					case 13:
						Graphics._addPointArrToRst(rst,Rectangle._getBoundPointS(cmd[0],cmd[1],cmd[2],cmd[3]),tMatrix);
						break ;
					case context._drawCircle:
					case context._fillCircle:
					case 14:
						Graphics._addPointArrToRst(rst,Rectangle._getBoundPointS(cmd[0]-cmd[2],cmd[1]-cmd[2],cmd[2]+cmd[2],cmd[2]+cmd[2]),tMatrix);
						break ;
					case context._drawLine:
					case 20:
						Graphics._tempPoints.length=0;
						var lineWidth=NaN;
						lineWidth=cmd[5] *0.5;
						if (cmd[0]==cmd[2]){
							Graphics._tempPoints.push(cmd[0]+lineWidth,cmd[1],cmd[2]+lineWidth,cmd[3],cmd[0]-lineWidth,cmd[1],cmd[2]-lineWidth,cmd[3]);
							}else if (cmd[1]==cmd[3]){
							Graphics._tempPoints.push(cmd[0],cmd[1]+lineWidth,cmd[2],cmd[3]+lineWidth,cmd[0],cmd[1]-lineWidth,cmd[2],cmd[3]-lineWidth);
							}else {
							Graphics._tempPoints.push(cmd[0],cmd[1],cmd[2],cmd[3]);
						}
						Graphics._addPointArrToRst(rst,Graphics._tempPoints,tMatrix);
						break ;
					case context._drawCurves:
					case 22:
						Graphics._addPointArrToRst(rst,Bezier.I.getBezierPoints(cmd[2]),tMatrix,cmd[0],cmd[1]);
						break ;
					case context._drawPoly:
					case context._drawLines:
					case 18:
						Graphics._addPointArrToRst(rst,cmd[2],tMatrix,cmd[0],cmd[1]);
						break ;
					case context._drawPath:
					case 19:
						Graphics._addPointArrToRst(rst,this._getPathPoints(cmd[2]),tMatrix,cmd[0],cmd[1]);
						break ;
					case context._drawPie:
					case 15:
						Graphics._addPointArrToRst(rst,this._getPiePoints(cmd[0],cmd[1],cmd[2],cmd[3],cmd[4]),tMatrix);
						break ;
					}
			}
			if (rst.length > 200){
				rst=Utils.copyArray(rst,Rectangle._getWrapRec(rst)._getBoundPoints());
			}else if (rst.length > 8)
			rst=GrahamScan.scanPList(rst);
			return rst;
		}

		__proto._switchMatrix=function(tMatix,tempMatrix){
			tempMatrix.concat(tMatix);
			tempMatrix.copyTo(tMatix);
		}

		/**
		*绘制纹理。
		*@param tex 纹理。
		*@param x X 轴偏移量。
		*@param y Y 轴偏移量。
		*@param width 宽度。
		*@param height 高度。
		*@param m 矩阵信息。
		*/
		__proto.drawTexture=function(tex,x,y,width,height,m,alpha){
			(x===void 0)&& (x=0);
			(y===void 0)&& (y=0);
			(width===void 0)&& (width=0);
			(height===void 0)&& (height=0);
			(alpha===void 0)&& (alpha=1);
			if (!tex)return;
			if (!width)width=tex.sourceWidth;
			if (!height)height=tex.sourceHeight;
			width=width-tex.sourceWidth+tex.width;
			height=height-tex.sourceHeight+tex.height;
			if (tex.loaded && (width <=0 || height <=0))return;
			x+=tex.offsetX;
			y+=tex.offsetY;
			this._sp && (this._sp._renderType |=0x200);
			var args=[tex,x,y,width,height,m,alpha];
			args.callee=(m || alpha !=1)? Render._context._drawTextureWithTransform :Render._context._drawTexture;
			if (this._one==null && !m && alpha==1){
				this._one=args;
				this._render=this._renderOneImg;
				}else {
				this._saveToCmd(args.callee,args);
			}
			if (!tex.loaded){
				tex.once("loaded",this,this._textureLoaded,[tex,args]);
			}
			this._repaint();
		}

		/**
		*@private 清理贴图并替换为最新的
		*@param tex
		*/
		__proto.cleanByTexture=function(tex,x,y,width,height){
			(width===void 0)&& (width=0);
			(height===void 0)&& (height=0);
			if (!tex)return this.clear();
			if (this._one && this._render===this._renderOneImg){
				if (!width)width=tex.sourceWidth;
				if (!height)height=tex.sourceHeight;
				width=width-tex.sourceWidth+tex.width;
				height=height-tex.sourceHeight+tex.height;
				x+=tex.offsetX;
				y+=tex.offsetY;
				this._one[0]=tex;
				this._one[1]=x;
				this._one[2]=y;
				this._one[3]=width;
				this._one[4]=height;
				}else {
				this.clear();
				tex && this.drawTexture(tex,x,y,width,height);
			}
		}

		/**
		*批量绘制同样纹理。
		*@param tex 纹理。
		*@param pos 绘制次数和坐标。
		*/
		__proto.drawTextures=function(tex,pos){
			if (!tex)return;
			this._saveToCmd(Render._context._drawTextures,[tex,pos]);
		}

		/**
		*用texture填充
		*@param tex 纹理。
		*@param x X 轴偏移量。
		*@param y Y 轴偏移量。
		*@param width 宽度。
		*@param height 高度。
		*@param type 填充类型 repeat|repeat-x|repeat-y|no-repeat
		*@param offset 贴图纹理偏移
		*
		*/
		__proto.fillTexture=function(tex,x,y,width,height,type,offset){
			(width===void 0)&& (width=0);
			(height===void 0)&& (height=0);
			(type===void 0)&& (type="repeat");
			if (!tex)return;
			var args=[tex,x,y,width,height,type,offset || Point.EMPTY,{}];
			if (!tex.loaded){
				tex.once("loaded",this,this._textureLoaded,[tex,args]);
			}
			this._saveToCmd(Render._context._fillTexture,args);
		}

		__proto._textureLoaded=function(tex,param){
			param[3]=param[3] || tex.width;
			param[4]=param[4] || tex.height;
			this._repaint();
		}

		/**
		*@private
		*保存到命令流。
		*/
		__proto._saveToCmd=function(fun,args){
			this._sp && (this._sp._renderType |=0x200);
			if (this._one==null){
				this._one=args;
				this._render=this._renderOne;
				}else {
				this._sp && (this._sp._renderType &=~0x01);
				this._render=this._renderAll;
				(this._cmds || (this._cmds=[])).length===0 && this._cmds.push(this._one);
				this._cmds.push(args);
			}
			args.callee=fun;
			this._temp && (this._temp.length=0);
			this._repaint();
			return args;
		}

		/**
		*设置剪裁区域，超出剪裁区域的坐标不显示。
		*@param x X 轴偏移量。
		*@param y Y 轴偏移量。
		*@param width 宽度。
		*@param height 高度。
		*/
		__proto.clipRect=function(x,y,width,height){
			this._saveToCmd(Render._context._clipRect,[x,y,width,height]);
		}

		/**
		*在画布上绘制文本。
		*@param text 在画布上输出的文本。
		*@param x 开始绘制文本的 x 坐标位置（相对于画布）。
		*@param y 开始绘制文本的 y 坐标位置（相对于画布）。
		*@param font 定义字号和字体，比如"20px Arial"。
		*@param color 定义文本颜色，比如"#ff0000"。
		*@param textAlign 文本对齐方式，可选值："left"，"center"，"right"。
		*/
		__proto.fillText=function(text,x,y,font,color,textAlign){
			this._saveToCmd(Render._context._fillText,[text,x,y,font || Font.defaultFont,color,textAlign]);
		}

		/**
		*在画布上绘制“被填充且镶边的”文本。
		*@param text 在画布上输出的文本。
		*@param x 开始绘制文本的 x 坐标位置（相对于画布）。
		*@param y 开始绘制文本的 y 坐标位置（相对于画布）。
		*@param font 定义字体和字号，比如"20px Arial"。
		*@param fillColor 定义文本颜色，比如"#ff0000"。
		*@param borderColor 定义镶边文本颜色。
		*@param lineWidth 镶边线条宽度。
		*@param textAlign 文本对齐方式，可选值："left"，"center"，"right"。
		*/
		__proto.fillBorderText=function(text,x,y,font,fillColor,borderColor,lineWidth,textAlign){
			this._saveToCmd(Render._context._fillBorderText,[text,x,y,font || Font.defaultFont,fillColor,borderColor,lineWidth,textAlign]);
		}

		/**
		*在画布上绘制文本（没有填色）。文本的默认颜色是黑色。
		*@param text 在画布上输出的文本。
		*@param x 开始绘制文本的 x 坐标位置（相对于画布）。
		*@param y 开始绘制文本的 y 坐标位置（相对于画布）。
		*@param font 定义字体和字号，比如"20px Arial"。
		*@param color 定义文本颜色，比如"#ff0000"。
		*@param lineWidth 线条宽度。
		*@param textAlign 文本对齐方式，可选值："left"，"center"，"right"。
		*/
		__proto.strokeText=function(text,x,y,font,color,lineWidth,textAlign){
			this._saveToCmd(Render._context._strokeText,[text,x,y,font || Font.defaultFont,color,lineWidth,textAlign]);
		}

		/**
		*设置透明度。
		*@param value 透明度。
		*/
		__proto.alpha=function(value){
			this._saveToCmd(Render._context._alpha,[value]);
		}

		/**
		*替换绘图的当前转换矩阵。
		*@param mat 矩阵。
		*@param pivotX 水平方向轴心点坐标。
		*@param pivotY 垂直方向轴心点坐标。
		*/
		__proto.transform=function(matrix,pivotX,pivotY){
			(pivotX===void 0)&& (pivotX=0);
			(pivotY===void 0)&& (pivotY=0);
			this._saveToCmd(Render._context._transform,[matrix,pivotX,pivotY]);
		}

		/**
		*旋转当前绘图。(推荐使用transform，性能更高)
		*@param angle 旋转角度，以弧度计。
		*@param pivotX 水平方向轴心点坐标。
		*@param pivotY 垂直方向轴心点坐标。
		*/
		__proto.rotate=function(angle,pivotX,pivotY){
			(pivotX===void 0)&& (pivotX=0);
			(pivotY===void 0)&& (pivotY=0);
			this._saveToCmd(Render._context._rotate,[angle,pivotX,pivotY]);
		}

		/**
		*缩放当前绘图至更大或更小。(推荐使用transform，性能更高)
		*@param scaleX 水平方向缩放值。
		*@param scaleY 垂直方向缩放值。
		*@param pivotX 水平方向轴心点坐标。
		*@param pivotY 垂直方向轴心点坐标。
		*/
		__proto.scale=function(scaleX,scaleY,pivotX,pivotY){
			(pivotX===void 0)&& (pivotX=0);
			(pivotY===void 0)&& (pivotY=0);
			this._saveToCmd(Render._context._scale,[scaleX,scaleY,pivotX,pivotY]);
		}

		/**
		*重新映射画布上的 (0,0)位置。
		*@param x 添加到水平坐标（x）上的值。
		*@param y 添加到垂直坐标（y）上的值。
		*/
		__proto.translate=function(x,y){
			this._saveToCmd(Render._context._translate,[x,y]);
		}

		/**
		*保存当前环境的状态。
		*/
		__proto.save=function(){
			this._saveToCmd(Render._context._save,[]);
		}

		/**
		*返回之前保存过的路径状态和属性。
		*/
		__proto.restore=function(){
			this._saveToCmd(Render._context._restore,[]);
		}

		/**
		*@private
		*替换文本内容。
		*@param text 文本内容。
		*@return 替换成功则值为true，否则值为flase。
		*/
		__proto.replaceText=function(text){
			this._repaint();
			var cmds=this._cmds;
			if (!cmds){
				if (this._one && this._isTextCmd(this._one.callee)){
					if (this._one[0].toUpperCase)this._one[0]=text;
					else this._one[0].setText(text);
					return true;
				}
				}else {
				for (var i=cmds.length-1;i >-1;i--){
					if (this._isTextCmd(cmds[i].callee)){
						if (cmds[i][0].toUpperCase)cmds[i][0]=text;
						else cmds[i][0].setText(text);
						return true;
					}
				}
			}
			return false;
		}

		/**@private */
		__proto._isTextCmd=function(fun){
			return fun===Render._context._fillText || fun===Render._context._fillBorderText || fun===Render._context._strokeText;
		}

		/**
		*@private
		*替换文本颜色。
		*@param color 颜色。
		*/
		__proto.replaceTextColor=function(color){
			this._repaint();
			var cmds=this._cmds;
			if (!cmds){
				if (this._one && this._isTextCmd(this._one.callee)){
					this._one[4]=color;
					if (!this._one[0].toUpperCase)this._one[0].changed=true;
				}
				}else {
				for (var i=cmds.length-1;i >-1;i--){
					if (this._isTextCmd(cmds[i].callee)){
						cmds[i][4]=color;
						if (!cmds[i][0].toUpperCase)cmds[i][0].changed=true;
					}
				}
			}
		}

		/**
		*加载并显示一个图片。
		*@param url 图片地址。
		*@param x 显示图片的x位置。
		*@param y 显示图片的y位置。
		*@param width 显示图片的宽度，设置为0表示使用图片默认宽度。
		*@param height 显示图片的高度，设置为0表示使用图片默认高度。
		*@param complete 加载完成回调。
		*/
		__proto.loadImage=function(url,x,y,width,height,complete){
			var _$this=this;
			(x===void 0)&& (x=0);
			(y===void 0)&& (y=0);
			(width===void 0)&& (width=0);
			(height===void 0)&& (height=0);
			var tex=Loader.getRes(url);
			if (tex)onloaded(tex);
			else Laya.loader.load(url,Handler.create(null,onloaded),null,"image");
			function onloaded (tex){
				if (tex){
					_$this.drawTexture(tex,x,y,width,height);
					if (complete !=null)complete.call(_$this._sp,tex);
				}
			}
		}

		/**
		*@private
		*/
		__proto._renderEmpty=function(sprite,context,x,y){}
		/**
		*@private
		*/
		__proto._renderAll=function(sprite,context,x,y){
			var cmds=this._cmds,cmd;
			for (var i=0,n=cmds.length;i < n;i++){
				(cmd=cmds[i]).callee.call(context,x,y,cmd);
			}
		}

		/**
		*@private
		*/
		__proto._renderOne=function(sprite,context,x,y){
			this._one.callee.call(context,x,y,this._one);
		}

		/**
		*@private
		*/
		__proto._renderOneImg=function(sprite,context,x,y){
			this._one.callee.call(context,x,y,this._one);
			if (sprite._renderType!==2305){
				sprite._renderType |=0x01;
			}
		}

		/**
		*绘制一条线。
		*@param fromX X 轴开始位置。
		*@param fromY Y 轴开始位置。
		*@param toX X 轴结束位置。
		*@param toY Y 轴结束位置。
		*@param lineColor 颜色。
		*@param lineWidth 线条宽度。
		*/
		__proto.drawLine=function(fromX,fromY,toX,toY,lineColor,lineWidth){
			(lineWidth===void 0)&& (lineWidth=1);
			var tId=0;
			if (Render.isWebGL){
				tId=VectorGraphManager.getInstance().getId();
				if (this._vectorgraphArray==null)this._vectorgraphArray=[];
				this._vectorgraphArray.push(tId);
			};
			var offset=lineWidth % 2===0 ? 0 :0.5;
			var arr=[fromX+offset,fromY+offset,toX+offset,toY+offset,lineColor,lineWidth,tId];
			this._saveToCmd(Render._context._drawLine,arr);
		}

		/**
		*绘制一系列线段。
		*@param x 开始绘制的 X 轴位置。
		*@param y 开始绘制的 Y 轴位置。
		*@param points 线段的点集合。格式:[x1,y1,x2,y2,x3,y3...]。
		*@param lineColor 线段颜色，或者填充绘图的渐变对象。
		*@param lineWidth 线段宽度。
		*/
		__proto.drawLines=function(x,y,points,lineColor,lineWidth){
			(lineWidth===void 0)&& (lineWidth=1);
			var tId=0;
			if (Render.isWebGL){
				tId=VectorGraphManager.getInstance().getId();
				if (this._vectorgraphArray==null)this._vectorgraphArray=[];
				this._vectorgraphArray.push(tId);
			};
			var offset=lineWidth % 2===0 ? 0 :0.5;
			var arr=[x+offset,y+offset,points,lineColor,lineWidth,tId];
			this._saveToCmd(Render._context._drawLines,arr);
		}

		/**
		*绘制一系列曲线。
		*@param x 开始绘制的 X 轴位置。
		*@param y 开始绘制的 Y 轴位置。
		*@param points 线段的点集合，格式[startx,starty,ctrx,ctry,startx,starty...]。
		*@param lineColor 线段颜色，或者填充绘图的渐变对象。
		*@param lineWidth 线段宽度。
		*/
		__proto.drawCurves=function(x,y,points,lineColor,lineWidth){
			(lineWidth===void 0)&& (lineWidth=1);
			var arr=[x,y,points,lineColor,lineWidth];
			this._saveToCmd(Render._context._drawCurves,arr);
		}

		/**
		*绘制矩形。
		*@param x 开始绘制的 X 轴位置。
		*@param y 开始绘制的 Y 轴位置。
		*@param width 矩形宽度。
		*@param height 矩形高度。
		*@param fillColor 填充颜色，或者填充绘图的渐变对象。
		*@param lineColor 边框颜色，或者填充绘图的渐变对象。
		*@param lineWidth 边框宽度。
		*/
		__proto.drawRect=function(x,y,width,height,fillColor,lineColor,lineWidth){
			(lineWidth===void 0)&& (lineWidth=1);
			var offset=lineColor ? lineWidth / 2 :0;
			var lineOffset=lineColor ? lineWidth :0;
			var arr=[x+offset,y+offset,width-lineOffset,height-lineOffset,fillColor,lineColor,lineWidth];
			this._saveToCmd(Render._context._drawRect,arr);
		}

		/**
		*绘制圆形。
		*@param x 圆点X 轴位置。
		*@param y 圆点Y 轴位置。
		*@param radius 半径。
		*@param fillColor 填充颜色，或者填充绘图的渐变对象。
		*@param lineColor 边框颜色，或者填充绘图的渐变对象。
		*@param lineWidth 边框宽度。
		*/
		__proto.drawCircle=function(x,y,radius,fillColor,lineColor,lineWidth){
			(lineWidth===void 0)&& (lineWidth=1);
			var offset=lineColor ? lineWidth / 2 :0;
			var tId=0;
			if (Render.isWebGL){
				tId=VectorGraphManager.getInstance().getId();
				if (this._vectorgraphArray==null)this._vectorgraphArray=[];
				this._vectorgraphArray.push(tId);
			};
			var arr=[x,y,radius-offset,fillColor,lineColor,lineWidth,tId];
			this._saveToCmd(Render._context._drawCircle,arr);
		}

		/**
		*绘制扇形。
		*@param x 开始绘制的 X 轴位置。
		*@param y 开始绘制的 Y 轴位置。
		*@param radius 扇形半径。
		*@param startAngle 开始角度。
		*@param endAngle 结束角度。
		*@param fillColor 填充颜色，或者填充绘图的渐变对象。
		*@param lineColor 边框颜色，或者填充绘图的渐变对象。
		*@param lineWidth 边框宽度。
		*/
		__proto.drawPie=function(x,y,radius,startAngle,endAngle,fillColor,lineColor,lineWidth){
			(lineWidth===void 0)&& (lineWidth=1);
			var offset=lineColor ? lineWidth / 2 :0;
			var lineOffset=lineColor ? lineWidth :0;
			var tId=0;
			if (Render.isWebGL){
				tId=VectorGraphManager.getInstance().getId();
				if (this._vectorgraphArray==null)this._vectorgraphArray=[];
				this._vectorgraphArray.push(tId);
			};
			var arr=[x+offset,y+offset,radius-lineOffset,startAngle,endAngle,fillColor,lineColor,lineWidth,tId];
			arr[3]=Utils.toRadian(startAngle);
			arr[4]=Utils.toRadian(endAngle);
			this._saveToCmd(Render._context._drawPie,arr);
		}

		__proto._getPiePoints=function(x,y,radius,startAngle,endAngle){
			var rst=Graphics._tempPoints;
			Graphics._tempPoints.length=0;
			rst.push(x,y);
			var dP=Math.PI / 10;
			var i=NaN;
			for (i=startAngle;i < endAngle;i+=dP){
				rst.push(x+radius *Math.cos(i),y+radius *Math.sin(i));
			}
			if (endAngle !=i){
				rst.push(x+radius *Math.cos(endAngle),y+radius *Math.sin(endAngle));
			}
			return rst;
		}

		/**
		*绘制多边形。
		*@param x 开始绘制的 X 轴位置。
		*@param y 开始绘制的 Y 轴位置。
		*@param points 多边形的点集合。
		*@param fillColor 填充颜色，或者填充绘图的渐变对象。
		*@param lineColor 边框颜色，或者填充绘图的渐变对象。
		*@param lineWidth 边框宽度。
		*/
		__proto.drawPoly=function(x,y,points,fillColor,lineColor,lineWidth){
			(lineWidth===void 0)&& (lineWidth=1);
			var tId=0;
			if (Render.isWebGL){
				tId=VectorGraphManager.getInstance().getId();
				if (this._vectorgraphArray==null)this._vectorgraphArray=[];
				this._vectorgraphArray.push(tId);
				var tIsConvexPolygon=false;
				if (points.length > 6){
					tIsConvexPolygon=false;
					}else {
					tIsConvexPolygon=true;
				}
			};
			var offset=lineColor ? (lineWidth % 2===0 ? 0 :0.5):0;
			var arr=[x+offset,y+offset,points,fillColor,lineColor,lineWidth,tId,tIsConvexPolygon];
			this._saveToCmd(Render._context._drawPoly,arr);
		}

		__proto._getPathPoints=function(paths){
			var i=0,len=0;
			var rst=Graphics._tempPoints;
			rst.length=0;
			len=paths.length;
			var tCMD;
			for (i=0;i < len;i++){
				tCMD=paths[i];
				if (tCMD.length > 1){
					rst.push(tCMD[1],tCMD[2]);
					if (tCMD.length > 3){
						rst.push(tCMD[3],tCMD[4]);
					}
				}
			}
			return rst;
		}

		/**
		*绘制路径。
		*@param x 开始绘制的 X 轴位置。
		*@param y 开始绘制的 Y 轴位置。
		*@param paths 路径集合，路径支持以下格式：[["moveTo",x,y],["lineTo",x,y,x,y,x,y],["arcTo",x1,y1,x2,y2,r],["closePath"]]。
		*@param brush 刷子定义，支持以下设置{fillStyle}。
		*@param pen 画笔定义，支持以下设置{strokeStyle,lineWidth,lineJoin,lineCap,miterLimit}。
		*/
		__proto.drawPath=function(x,y,paths,brush,pen){
			var arr=[x,y,paths,brush,pen];
			this._saveToCmd(Render._context._drawPath,arr);
		}

		/**@private */
		/**
		*@private
		*命令流。
		*/
		__getset(0,__proto,'cmds',function(){
			return this._cmds;
			},function(value){
			this._sp && (this._sp._renderType |=0x200);
			this._cmds=value;
			this._render=this._renderAll;
			this._repaint();
		});

		Graphics.__init__=function(){
			if (Render.isConchNode){
				var from=laya.display.Graphics.prototype;
				var to=ConchGraphics.prototype;
				var list=["clear","destroy","alpha","rotate","transform","scale","translate","save","restore","clipRect","blendMode","fillText","fillBorderText","_fands","drawRect","drawCircle","drawPie","drawPoly","drawPath","drawImageM","drawLine","drawLines","_drawPs","drawCurves","replaceText","replaceTextColor","_fillImage","fillTexture","setSkinMesh","drawParticle","drawImageS"];
				for (var i=0,len=list.length;i <=len;i++){
					var temp=list[i];
					from[temp]=to[temp];
				}
				from._saveToCmd=null;
				if (to.drawImageS){
					from.drawTextures=function (tex,pos){
						if (!tex)return;
						if (!(tex.loaded && tex.bitmap && tex.source)){
							return;
						};
						var uv=tex.uv,w=tex.bitmap.width,h=tex.bitmap.height;
						this.drawImageS(tex.bitmap.source,uv[0] *w,uv[1] *h,(uv[2]-uv[0])*w,(uv[5]-uv[3])*h,tex.offsetX,tex.offsetY,tex.width,tex.height,pos);
					}
				}
				from.drawTexture=function (tex,x,y,width,height,m){
					(x===void 0)&& (x=0);
					(y===void 0)&& (y=0);
					(width===void 0)&& (width=0);
					(height===void 0)&& (height=0);
					if (!tex)return;
					if (!(tex.loaded && tex.bitmap && tex.source)){
						return;
					}
					if (!width)width=tex.sourceWidth;
					if (!height)height=tex.sourceHeight;
					width=width-tex.sourceWidth+tex.width;
					height=height-tex.sourceHeight+tex.height;
					if (width <=0 || height <=0)return;
					x+=tex.offsetX;
					y+=tex.offsetY;
					var uv=tex.uv,w=tex.bitmap.width,h=tex.bitmap.height;
					this.drawImageM(tex.bitmap.source,uv[0] *w,uv[1] *h,(uv[2]-uv[0])*w,(uv[5]-uv[3])*h,x,y,width,height,m);
					this._repaint();
				}
				from.fillTexture=function (tex,x,y,width,height,type,offset){
					(width===void 0)&& (width=0);
					(height===void 0)&& (height=0);
					(type===void 0)&& (type="repeat");
					if (!tex)return;
					if (tex.loaded){
						var ctxi=Render._context.ctx;
						var w=tex.bitmap.width,h=tex.bitmap.height,uv=tex.uv;
						var pat;
						if (tex.uv !=Texture.DEF_UV){
							pat=ctxi.createPattern(tex.bitmap.source,type,uv[0] *w,uv[1] *h,(uv[2]-uv[0])*w,(uv[5]-uv[3])*h);
							}else {
							pat=ctxi.createPattern(tex.bitmap.source,type);
						};
						var sX=0,sY=0;
						if (offset){
							x+=offset.x % tex.width;
							y+=offset.y % tex.height;
							sX-=offset.x % tex.width;
							sY-=offset.y % tex.height;
						}
						this._fillImage(pat,x,y,sX,sY,width,height);
					}
				}
			}
		}

		Graphics._addPointArrToRst=function(rst,points,matrix,dx,dy){
			(dx===void 0)&& (dx=0);
			(dy===void 0)&& (dy=0);
			var i=0,len=0;
			len=points.length;
			for (i=0;i < len;i+=2){
				Graphics._addPointToRst(rst,points[i]+dx,points[i+1]+dy,matrix);
			}
		}

		Graphics._addPointToRst=function(rst,x,y,matrix){
			var _tempPoint=Point.TEMP;
			_tempPoint.setTo(x ? x :0,y ? y :0);
			matrix.transformPoint(_tempPoint);
			rst.push(_tempPoint.x,_tempPoint.y);
		}

		Graphics._tempPoints=[];
		Graphics._tempMatrixArrays=[];
		Graphics._tempCmds=[];
		__static(Graphics,
		['_tempMatrix',function(){return this._tempMatrix=new Matrix();},'_initMatrix',function(){return this._initMatrix=new Matrix();}
		]);
		return Graphics;
	})()


	/**
	*<code>Event</code> 是事件类型的集合。
	*/
	//class laya.events.Event
	var Event=(function(){
		function Event(){
			//this.type=null;
			//this.nativeEvent=null;
			//this.target=null;
			//this.currentTarget=null;
			//this._stoped=false;
			//this.touchId=0;
			//this.keyCode=0;
		}

		__class(Event,'laya.events.Event');
		var __proto=Event.prototype;
		/**
		*设置事件数据。
		*@param type 事件类型。
		*@param currentTarget 事件目标触发对象。
		*@param target 事件当前冒泡对象。
		*@return 返回当前 Event 对象。
		*/
		__proto.setTo=function(type,currentTarget,target){
			this.type=type;
			this.currentTarget=currentTarget;
			this.target=target;
			return this;
		}

		/**
		*防止对事件流中当前节点的后续节点中的所有事件侦听器进行处理。
		*/
		__proto.stopPropagation=function(){
			this._stoped=true;
		}

		/**鼠标在 Stage 上的 Y 轴坐标*/
		__getset(0,__proto,'stageY',function(){
			return Laya.stage.mouseY;
		});

		/**
		*包含按下或释放的键的字符代码值。字符代码值为英文键盘值。
		*/
		__getset(0,__proto,'charCode',function(){
			return this.nativeEvent.charCode;
		});

		/**
		*触摸点列表。
		*/
		__getset(0,__proto,'touches',function(){
			var arr=this.nativeEvent.touches;
			if (arr){
				var stage=Laya.stage;
				for (var i=0,n=arr.length;i < n;i++){
					var e=arr[i];
					var point=Point.TEMP;
					point.setTo(e.clientX,e.clientY);
					stage._canvasTransform.invertTransformPoint(point);
					stage.transform.invertTransformPoint(point);
					e.stageX=point.x;
					e.stageY=point.y;
				}
			}
			return arr;
		});

		/**
		*表示键在键盘上的位置。这对于区分在键盘上多次出现的键非常有用。<br>
		*例如，您可以根据此属性的值来区分左 Shift 键和右 Shift 键：左 Shift 键的值为 KeyLocation.LEFT，右 Shift 键的值为 KeyLocation.RIGHT。另一个示例是区分标准键盘 (KeyLocation.STANDARD)与数字键盘 (KeyLocation.NUM_PAD)上按下的数字键。
		*/
		__getset(0,__proto,'keyLocation',function(){
			return this.nativeEvent.keyLocation;
		});

		/**
		*表示 Ctrl 键是处于活动状态 (true)还是非活动状态 (false)。
		*/
		__getset(0,__proto,'ctrlKey',function(){
			return this.nativeEvent.ctrlKey;
		});

		/**
		*表示 Alt 键是处于活动状态 (true)还是非活动状态 (false)。
		*/
		__getset(0,__proto,'altKey',function(){
			return this.nativeEvent.altKey;
		});

		/**
		*表示 Shift 键是处于活动状态 (true)还是非活动状态 (false)。
		*/
		__getset(0,__proto,'shiftKey',function(){
			return this.nativeEvent.shiftKey;
		});

		/**鼠标在 Stage 上的 X 轴坐标*/
		__getset(0,__proto,'stageX',function(){
			return Laya.stage.mouseX;
		});

		Event.EMPTY=new Event();
		Event.MOUSE_DOWN="mousedown";
		Event.MOUSE_UP="mouseup";
		Event.CLICK="click";
		Event.RIGHT_MOUSE_DOWN="rightmousedown";
		Event.RIGHT_MOUSE_UP="rightmouseup";
		Event.RIGHT_CLICK="rightclick";
		Event.MOUSE_MOVE="mousemove";
		Event.MOUSE_OVER="mouseover";
		Event.MOUSE_OUT="mouseout";
		Event.MOUSE_WHEEL="mousewheel";
		Event.ROLL_OVER="mouseover";
		Event.ROLL_OUT="mouseout";
		Event.DOUBLE_CLICK="doubleclick";
		Event.CHANGE="change";
		Event.CHANGED="changed";
		Event.RESIZE="resize";
		Event.ADDED="added";
		Event.REMOVED="removed";
		Event.DISPLAY="display";
		Event.UNDISPLAY="undisplay";
		Event.ERROR="error";
		Event.COMPLETE="complete";
		Event.LOADED="loaded";
		Event.PROGRESS="progress";
		Event.INPUT="input";
		Event.RENDER="render";
		Event.OPEN="open";
		Event.MESSAGE="message";
		Event.CLOSE="close";
		Event.KEY_DOWN="keydown";
		Event.KEY_PRESS="keypress";
		Event.KEY_UP="keyup";
		Event.FRAME="enterframe";
		Event.DRAG_START="dragstart";
		Event.DRAG_MOVE="dragmove";
		Event.DRAG_END="dragend";
		Event.ENTER="enter";
		Event.SELECT="select";
		Event.BLUR="blur";
		Event.FOCUS="focus";
		Event.VISIBILITY_CHANGE="visibilitychange";
		Event.FOCUS_CHANGE="focuschange";
		Event.PLAYED="played";
		Event.PAUSED="paused";
		Event.STOPPED="stopped";
		Event.START="start";
		Event.END="end";
		Event.ENABLED_CHANGED="enabledchanged";
		Event.COMPONENT_ADDED="componentadded";
		Event.COMPONENT_REMOVED="componentremoved";
		Event.ACTIVE_CHANGED="activechanged";
		Event.LAYER_CHANGED="layerchanged";
		Event.HIERARCHY_LOADED="hierarchyloaded";
		Event.RECOVERING="recovering";
		Event.RECOVERED="recovered";
		Event.RELEASED="released";
		Event.LINK="link";
		Event.LABEL="label";
		Event.FULL_SCREEN_CHANGE="fullscreenchange";
		Event.DEVICE_LOST="devicelost";
		Event.MESH_CHANGED="meshchanged";
		Event.MATERIAL_CHANGED="materialchanged";
		Event.RENDERQUEUE_CHANGED="renderqueuechanged";
		Event.WORLDMATRIX_NEEDCHANGE="worldmatrixneedchanged";
		Event.ANIMATION_CHANGED="animationchanged";
		return Event;
	})()


	/**
	*<code>Keyboard</code> 类的属性是一些常数，这些常数表示控制游戏时最常用的键。
	*/
	//class laya.events.Keyboard
	var Keyboard=(function(){
		function Keyboard(){};
		__class(Keyboard,'laya.events.Keyboard');
		Keyboard.NUMBER_0=48;
		Keyboard.NUMBER_1=49;
		Keyboard.NUMBER_2=50;
		Keyboard.NUMBER_3=51;
		Keyboard.NUMBER_4=52;
		Keyboard.NUMBER_5=53;
		Keyboard.NUMBER_6=54;
		Keyboard.NUMBER_7=55;
		Keyboard.NUMBER_8=56;
		Keyboard.NUMBER_9=57;
		Keyboard.A=65;
		Keyboard.B=66;
		Keyboard.C=67;
		Keyboard.D=68;
		Keyboard.E=69;
		Keyboard.F=70;
		Keyboard.G=71;
		Keyboard.H=72;
		Keyboard.I=73;
		Keyboard.J=74;
		Keyboard.K=75;
		Keyboard.L=76;
		Keyboard.M=77;
		Keyboard.N=78;
		Keyboard.O=79;
		Keyboard.P=80;
		Keyboard.Q=81;
		Keyboard.R=82;
		Keyboard.S=83;
		Keyboard.T=84;
		Keyboard.U=85;
		Keyboard.V=86;
		Keyboard.W=87;
		Keyboard.X=88;
		Keyboard.Y=89;
		Keyboard.Z=90;
		Keyboard.F1=112;
		Keyboard.F2=113;
		Keyboard.F3=114;
		Keyboard.F4=115;
		Keyboard.F5=116;
		Keyboard.F6=117;
		Keyboard.F7=118;
		Keyboard.F8=119;
		Keyboard.F9=120;
		Keyboard.F10=121;
		Keyboard.F11=122;
		Keyboard.F12=123;
		Keyboard.F13=124;
		Keyboard.F14=125;
		Keyboard.F15=126;
		Keyboard.NUMPAD=21;
		Keyboard.NUMPAD_0=96;
		Keyboard.NUMPAD_1=97;
		Keyboard.NUMPAD_2=98;
		Keyboard.NUMPAD_3=99;
		Keyboard.NUMPAD_4=100;
		Keyboard.NUMPAD_5=101;
		Keyboard.NUMPAD_6=102;
		Keyboard.NUMPAD_7=103;
		Keyboard.NUMPAD_8=104;
		Keyboard.NUMPAD_9=105;
		Keyboard.NUMPAD_ADD=107;
		Keyboard.NUMPAD_DECIMAL=110;
		Keyboard.NUMPAD_DIVIDE=111;
		Keyboard.NUMPAD_ENTER=108;
		Keyboard.NUMPAD_MULTIPLY=106;
		Keyboard.NUMPAD_SUBTRACT=109;
		Keyboard.SEMICOLON=186;
		Keyboard.EQUAL=187;
		Keyboard.COMMA=188;
		Keyboard.MINUS=189;
		Keyboard.PERIOD=190;
		Keyboard.SLASH=191;
		Keyboard.BACKQUOTE=192;
		Keyboard.LEFTBRACKET=219;
		Keyboard.BACKSLASH=220;
		Keyboard.RIGHTBRACKET=221;
		Keyboard.QUOTE=222;
		Keyboard.ALTERNATE=18;
		Keyboard.BACKSPACE=8;
		Keyboard.CAPS_LOCK=20;
		Keyboard.COMMAND=15;
		Keyboard.CONTROL=17;
		Keyboard.DELETE=46;
		Keyboard.ENTER=13;
		Keyboard.ESCAPE=27;
		Keyboard.PAGE_UP=33;
		Keyboard.PAGE_DOWN=34;
		Keyboard.END=35;
		Keyboard.HOME=36;
		Keyboard.LEFT=37;
		Keyboard.UP=38;
		Keyboard.RIGHT=39;
		Keyboard.DOWN=40;
		Keyboard.SHIFT=16;
		Keyboard.SPACE=32;
		Keyboard.TAB=9;
		Keyboard.INSERT=45;
		return Keyboard;
	})()


	/**
	*<p><code>KeyBoardManager</code> 是键盘事件管理类。</p>
	*<p>该类从浏览器中接收键盘事件，并派发该事件。
	*派发事件时若 Stage.focus 为空则只从 Stage 上派发该事件，否则将从 Stage.focus 对象开始一直冒泡派发该事件。
	*所以在 Laya.stage 上监听键盘事件一定能够收到，如果在其他地方监听，则必须处在Stage.focus的冒泡链上才能收到该事件。</p>
	*<p>用户可以通过代码 Laya.stage.focus=someNode 的方式来设置focus对象。</p>
	*<p>用户可统一的根据事件对象中 e.keyCode 来判断按键类型，该属性兼容了不同浏览器的实现。</p>
	*/
	//class laya.events.KeyBoardManager
	var KeyBoardManager=(function(){
		function KeyBoardManager(){};
		__class(KeyBoardManager,'laya.events.KeyBoardManager');
		KeyBoardManager.__init__=function(){
			KeyBoardManager._addEvent("keydown");
			KeyBoardManager._addEvent("keypress");
			KeyBoardManager._addEvent("keyup");
		}

		KeyBoardManager._addEvent=function(type){
			Browser.document.addEventListener(type,function(e){
				laya.events.KeyBoardManager._dispatch(e,type);
			},true);
		}

		KeyBoardManager._dispatch=function(e,type){
			if (!KeyBoardManager.enabled)return;
			KeyBoardManager._event._stoped=false;
			KeyBoardManager._event.nativeEvent=e;
			KeyBoardManager._event.keyCode=e.keyCode || e.which || e.charCode;
			if (type==="keydown")KeyBoardManager._pressKeys[KeyBoardManager._event.keyCode]=true;
			else if (type==="keyup")KeyBoardManager._pressKeys[KeyBoardManager._event.keyCode]=null;
			var target=(Laya.stage.focus && (Laya.stage.focus.event !=null))? Laya.stage.focus :Laya.stage;
			var ct=target;
			while (ct){
				ct.event(type,KeyBoardManager._event.setTo(type,ct,target));
				ct=ct.parent;
			}
		}

		KeyBoardManager.hasKeyDown=function(key){
			return KeyBoardManager._pressKeys[key];
		}

		KeyBoardManager._pressKeys={};
		KeyBoardManager.enabled=true;
		__static(KeyBoardManager,
		['_event',function(){return this._event=new Event();}
		]);
		return KeyBoardManager;
	})()


	/**
	*<code>MouseManager</code> 是鼠标、触摸交互管理器。
	*/
	//class laya.events.MouseManager
	var MouseManager=(function(){
		function MouseManager(){
			this.mouseX=0;
			this.mouseY=0;
			this.disableMouseEvent=false;
			this.mouseDownTime=0;
			this.mouseMoveAccuracy=2;
			this._stage=null;
			this._target=null;
			this._lastOvers=[];
			this._currOvers=[];
			this._lastClickTimer=0;
			this._lastMoveTimer=0;
			this._isDoubleClick=false;
			this._isLeftMouse=false;
			this._eventList=[];
			this._touchIDs={};
			this._id=1;
			this._event=new Event();
			this._matrix=new Matrix();
			this._point=new Point();
			this._rect=new Rectangle();
			this._prePoint=new Point();
		}

		__class(MouseManager,'laya.events.MouseManager');
		var __proto=MouseManager.prototype;
		/**
		*@private
		*初始化。
		*/
		__proto.__init__=function(stage,canvas){
			var _$this=this;
			this._stage=stage;
			var _this=this;
			var list=this._eventList;
			canvas.oncontextmenu=function (e){
				if (MouseManager.enabled)return false;
			}
			canvas.addEventListener('mousedown',function(e){
				if (MouseManager.enabled){
					e.preventDefault();
					list.push(e);
					_this.mouseDownTime=Browser.now();
				}
			});
			canvas.addEventListener('mouseup',function(e){
				if (MouseManager.enabled){
					e.preventDefault();
					list.push(e);
					_this.mouseDownTime=-Browser.now();
				}
			},true);
			canvas.addEventListener('mousemove',function(e){
				if (MouseManager.enabled){
					e.preventDefault();
					var now=Browser.now();
					if (now-_this._lastMoveTimer < 10)return;
					_this._lastMoveTimer=now;
					list.push(e);
				}
			},true);
			canvas.addEventListener("mouseout",function(e){
				if (MouseManager.enabled)list.push(e);
			})
			canvas.addEventListener("mouseover",function(e){
				if (MouseManager.enabled)list.push(e);
			})
			canvas.addEventListener("touchstart",function(e){
				if (MouseManager.enabled){
					list.push(e);
					_$this.runEvent();
					if (!Input.isInputting)e.preventDefault();
					_this.mouseDownTime=Browser.now();
				}
			});
			canvas.addEventListener("touchend",function(e){
				if (MouseManager.enabled){
					if (!Input.isInputting)e.preventDefault();
					list.push(e);
					_this.mouseDownTime=-Browser.now();
				}
			},true);
			canvas.addEventListener("touchmove",function(e){
				if (MouseManager.enabled){
					e.preventDefault();
					list.push(e);
				}
			},true);
			canvas.addEventListener('mousewheel',function(e){
				if (MouseManager.enabled)list.push(e);
			});
			canvas.addEventListener('DOMMouseScroll',function(e){
				if (MouseManager.enabled)list.push(e);
			});
		}

		__proto.initEvent=function(e,nativeEvent){
			var _this=this;
			_this._event._stoped=false;
			_this._event.nativeEvent=nativeEvent || e;
			_this._target=null;
			this._point.setTo(e.clientX,e.clientY);
			this._stage._canvasTransform.invertTransformPoint(this._point);
			_this.mouseX=this._point.x;
			_this.mouseY=this._point.y;
			_this._event.touchId=e.identifier || 0;
		}

		__proto.checkMouseWheel=function(e){
			this._event.delta=e.wheelDelta ? e.wheelDelta *0.025 :-e.detail;
			for (var i=0,n=this._lastOvers.length;i < n;i++){
				var ele=this._lastOvers[i];
				ele.event("mousewheel",this._event.setTo("mousewheel",ele,this._target));
			}
			this._stage.event("mousewheel",this._event.setTo("mousewheel",this._stage,this._target));
		}

		__proto.checkMouseOut=function(){
			if (this.disableMouseEvent)return;
			for (var i=0,n=this._lastOvers.length;i < n;i++){
				var ele=this._lastOvers[i];
				if (!ele.destroyed && this._currOvers.indexOf(ele)< 0){
					ele._set$P("$_MOUSEOVER",false);
					ele.event("mouseout",this._event.setTo("mouseout",ele,ele));
				}
			};
			var temp=this._lastOvers;
			this._lastOvers=this._currOvers;
			this._currOvers=temp;
			this._currOvers.length=0;
		}

		__proto.onMouseMove=function(ele){
			this.sendMouseMove(ele);
			this._event._stoped=false;
			this.sendMouseOver(this._target);
		}

		__proto.sendMouseMove=function(ele){
			ele.event("mousemove",this._event.setTo("mousemove",ele,this._target));
			!this._event._stoped && ele.parent && this.sendMouseMove(ele.parent);
		}

		__proto.sendMouseOver=function(ele){
			if (ele.parent || ele===this._stage){
				if (!ele._get$P("$_MOUSEOVER")){
					ele._set$P("$_MOUSEOVER",true);
					ele.event("mouseover",this._event.setTo("mouseover",ele,this._target));
				}
				this._currOvers.push(ele);
			}
			!this._event._stoped && ele.parent && this.sendMouseOver(ele.parent);
		}

		__proto.onMouseDown=function(ele){
			if (Input.isInputting && Laya.stage.focus && Laya.stage.focus["focus"] && !Laya.stage.focus.contains(this._target)){
				Laya.stage.focus["focus"]=false;
			}
			this._onMouseDown(ele);
		}

		__proto._onMouseDown=function(ele){
			if (this._isLeftMouse){
				ele._set$P("$_MOUSEDOWN",this._touchIDs[this._event.touchId]);
				ele.event("mousedown",this._event.setTo("mousedown",ele,this._target));
				}else {
				ele._set$P("$_RIGHTMOUSEDOWN",this._touchIDs[this._event.touchId]);
				ele.event("rightmousedown",this._event.setTo("rightmousedown",ele,this._target));
			}
			!this._event._stoped && ele.parent && this.onMouseDown(ele.parent);
		}

		__proto.onMouseUp=function(ele){
			var type=this._isLeftMouse ? "mouseup" :"rightmouseup";
			this.sendMouseUp(ele,type);
			this._event._stoped=false;
			this.sendClick(this._target,type);
		}

		__proto.sendMouseUp=function(ele,type){
			ele.event(type,this._event.setTo(type,ele,this._target));
			!this._event._stoped && ele.parent && this.sendMouseUp(ele.parent,type);
		}

		__proto.sendClick=function(ele,type){
			if (ele.destroyed)return;
			if (type==="mouseup" && ele._get$P("$_MOUSEDOWN")===this._touchIDs[this._event.touchId]){
				ele._set$P("$_MOUSEDOWN",-1);
				ele.event("click",this._event.setTo("click",ele,this._target));
				this._isDoubleClick && ele.event("doubleclick",this._event.setTo("doubleclick",ele,this._target));
				}else if (type==="rightmouseup" && ele._get$P("$_RIGHTMOUSEDOWN")===this._touchIDs[this._event.touchId]){
				ele._set$P("$_RIGHTMOUSEDOWN",-1);
				ele.event("rightclick",this._event.setTo("rightclick",ele,this._target));
			}
			!this._event._stoped && ele.parent && this.sendClick(ele.parent,type);
		}

		__proto.check=function(sp,mouseX,mouseY,callBack){
			var transform=sp.transform || this._matrix;
			var pivotX=sp.pivotX;
			var pivotY=sp.pivotY;
			if (pivotX===0 && pivotY===0){
				transform.setTranslate(sp.x,sp.y);
				}else {
				if (transform===this._matrix){
					transform.setTranslate(sp.x-pivotX,sp.y-pivotY);
					}else {
					var cos=transform.cos;
					var sin=transform.sin;
					transform.setTranslate(sp.x-(pivotX *cos-pivotY *sin)*sp.scaleX,sp.y-(pivotX *sin+pivotY *cos)*sp.scaleY);
				}
			}
			transform.invertTransformPoint(this._point.setTo(mouseX,mouseY));
			transform.setTranslate(0,0);
			mouseX=this._point.x;
			mouseY=this._point.y;
			var scrollRect=sp.scrollRect;
			if (scrollRect){
				this._rect.setTo(0,0,scrollRect.width,scrollRect.height);
				var isHit=this._rect.contains(mouseX,mouseY);
				if (!isHit)return false;
			}
			if (!this.disableMouseEvent){
				var flag=false;
				if (sp.hitTestPrior && !sp.mouseThrough && !this.hitTest(sp,mouseX,mouseY)){
					return false;
				}
				for (var i=sp._childs.length-1;i >-1;i--){
					var child=sp._childs[i];
					if (!child.destroyed && child.mouseEnabled && child.visible){
						flag=this.check(child,mouseX+(scrollRect ? scrollRect.x :0),mouseY+(scrollRect ? scrollRect.y :0),callBack);
						if (flag)return true;
					}
				}
			}
			isHit=this.hitTest(sp,mouseX,mouseY);
			if (isHit){
				this._target=sp;
				callBack.call(this,sp);
				}else if (callBack===this.onMouseUp && sp===this._stage){
				this._target=this._stage;
				callBack.call(this,this._target);
			}
			return isHit;
		}

		__proto.hitTest=function(sp,mouseX,mouseY){
			var isHit=false;
			if ((sp.hitArea instanceof laya.utils.HitArea )){
				return sp.hitArea.isHit(mouseX,mouseY);
			}
			if (sp.width > 0 && sp.height > 0 || sp.mouseThrough || sp.hitArea){
				var hitRect=this._rect;
				if (!sp.mouseThrough){
					if (sp.hitArea)hitRect=sp.hitArea;
					else hitRect.setTo(0,0,sp.width,sp.height);
					isHit=hitRect.contains(mouseX,mouseY);
					}else {
					isHit=sp.getGraphicBounds().contains(mouseX,mouseY);
				}
			}
			return isHit;
		}

		/**
		*执行事件处理。
		*/
		__proto.runEvent=function(){
			var len=this._eventList.length;
			if (!len)return;
			var _this=this;
			var i=0;
			while (i < len){
				var evt=this._eventList[i];
				if (evt.type!=='mousemove')this._prePoint.x=this._prePoint.y=-1000000;
				switch (evt.type){
					case 'mousedown':
						this._touchIDs[0]=this._id++;
						if (!MouseManager._isTouchRespond){
							_this._isLeftMouse=evt.button===0;
							_this.initEvent(evt);
							_this.check(_this._stage,_this.mouseX,_this.mouseY,_this.onMouseDown);
						}else
						MouseManager._isTouchRespond=false;
						break ;
					case 'mouseup':
						_this._isLeftMouse=evt.button===0;
						var now=Browser.now();
						_this._isDoubleClick=(now-_this._lastClickTimer)< 300;
						_this._lastClickTimer=now;
						_this.initEvent(evt);
						_this.check(_this._stage,_this.mouseX,_this.mouseY,_this.onMouseUp);
						break ;
					case 'mousemove':
						if ((Math.abs(this._prePoint.x-evt.clientX)+Math.abs(this._prePoint.y-evt.clientY))>=this.mouseMoveAccuracy){
							this._prePoint.x=evt.clientX;
							this._prePoint.y=evt.clientY;
							_this.initEvent(evt);
							_this.check(_this._stage,_this.mouseX,_this.mouseY,_this.onMouseMove);
							_this.checkMouseOut();
						}
						break ;
					case "touchstart":
						MouseManager._isTouchRespond=true;
						_this._isLeftMouse=true;
						var touches=evt.changedTouches;
						for (var j=0,n=touches.length;j < n;j++){
							var touch=touches[j];
							if (this._id % 200===0)this._touchIDs={};
							this._touchIDs[touch.identifier]=this._id++;
							_this.initEvent(touch,evt);
							_this.check(_this._stage,_this.mouseX,_this.mouseY,_this.onMouseDown);
						}
						break ;
					case "touchend":
						MouseManager._isTouchRespond=true;
						_this._isLeftMouse=true;
						now=Browser.now();
						_this._isDoubleClick=(now-_this._lastClickTimer)< 300;
						_this._lastClickTimer=now;
						var touchends=evt.changedTouches;
						for (j=0,n=touchends.length;j < n;j++){
							_this.initEvent(touchends[j],evt);
							_this.check(_this._stage,_this.mouseX,_this.mouseY,_this.onMouseUp);
						}
						break ;
					case "touchmove":;
						var touchemoves=evt.changedTouches;
						for (j=0,n=touchemoves.length;j < n;j++){
							_this.initEvent(touchemoves[j],evt);
							_this.check(_this._stage,_this.mouseX,_this.mouseY,_this.onMouseMove);
						}
						_this.checkMouseOut();
						break ;
					case "wheel":
					case "mousewheel":
					case "DOMMouseScroll":
						_this.checkMouseWheel(evt);
						break ;
					case "mouseout":
						_this._stage.event("mouseout",_this._event.setTo("mouseout",_this._stage,_this._stage));
						break ;
					case "mouseover":
						_this._stage.event("mouseover",_this._event.setTo("mouseover",_this._stage,_this._stage));
						break ;
					}
				i++;
			}
			this._eventList.length=0;
		}

		MouseManager.enabled=true;
		MouseManager._isTouchRespond=false;
		__static(MouseManager,
		['instance',function(){return this.instance=new MouseManager();}
		]);
		return MouseManager;
	})()


	/**
	*<code>Filter</code> 是滤镜基类。
	*/
	//class laya.filters.Filter
	var Filter=(function(){
		function Filter(){
			this._action=null;
		}

		__class(Filter,'laya.filters.Filter');
		var __proto=Filter.prototype;
		Laya.imps(__proto,{"laya.filters.IFilter":true})
		/**@private */
		__proto.callNative=function(sp){}
		/**@private 滤镜类型。*/
		__getset(0,__proto,'type',function(){return-1});
		/**@private 滤镜动作。*/
		__getset(0,__proto,'action',function(){return this._action });
		Filter.BLUR=0x10;
		Filter.COLOR=0x20;
		Filter.GLOW=0x08;
		Filter._filterStart=null
		Filter._filterEnd=null
		Filter._EndTarget=null
		Filter._recycleScope=null
		Filter._filter=null
		Filter._useSrc=null
		Filter._endSrc=null
		Filter._useOut=null
		Filter._endOut=null
		return Filter;
	})()


	/**
	*<code>ColorFilterAction</code> 是一个颜色滤镜应用类。
	*/
	//class laya.filters.ColorFilterAction
	var ColorFilterAction=(function(){
		function ColorFilterAction(){
			this.data=null;
		}

		__class(ColorFilterAction,'laya.filters.ColorFilterAction');
		var __proto=ColorFilterAction.prototype;
		Laya.imps(__proto,{"laya.filters.IFilterAction":true})
		/**
		*给指定的对象应用颜色滤镜。
		*@param srcCanvas 需要应用画布对象。
		*@return 应用了滤镜后的画布对象。
		*/
		__proto.apply=function(srcCanvas){
			var ctx=srcCanvas.ctx.ctx;
			var canvas=srcCanvas.ctx.ctx.canvas;
			if (canvas.width==0 || canvas.height==0)return canvas;
			var imgdata=ctx.getImageData(0,0,canvas.width,canvas.height);
			var data=imgdata.data;
			var nData;
			for (var i=0,n=data.length;i < n;i+=4){
				nData=this.getColor(data[i],data[i+1],data[i+2],data[i+3]);
				if (data[i+3]==0)continue ;
				data[i]=nData[0];
				data[i+1]=nData[1];
				data[i+2]=nData[2];
				data[i+3]=nData[3];
			}
			ctx.putImageData(imgdata,0,0);
			return srcCanvas;
		}

		__proto.getColor=function(red,green,blue,alpha){
			var rst=[];
			if (this.data._mat && this.data._alpha){
				var mat=this.data._mat;
				var tempAlpha=this.data._alpha;
				rst[0]=mat[0] *red+mat[1] *green+mat[2] *blue+mat[3] *alpha+tempAlpha[0];
				rst[1]=mat[4] *red+mat[5] *green+mat[6] *blue+mat[7] *alpha+tempAlpha[1];
				rst[2]=mat[8] *red+mat[9] *green+mat[10] *blue+mat[11] *alpha+tempAlpha[2];
				rst[3]=mat[12] *red+mat[13] *green+mat[14] *blue+mat[15] *alpha+tempAlpha[3];
			}
			return rst;
		}

		return ColorFilterAction;
	})()


	/**
	*@private
	*计算贝塞尔曲线的工具类。
	*/
	//class laya.maths.Bezier
	var Bezier=(function(){
		function Bezier(){
			this._controlPoints=[new Point(),new Point(),new Point()];
			this._calFun=this.getPoint2;
		}

		__class(Bezier,'laya.maths.Bezier');
		var __proto=Bezier.prototype;
		/**@private */
		__proto._switchPoint=function(x,y){
			var tPoint=this._controlPoints.shift();
			tPoint.setTo(x,y);
			this._controlPoints.push(tPoint);
		}

		/**
		*计算二次贝塞尔点。
		*@param t
		*@param rst
		*
		*/
		__proto.getPoint2=function(t,rst){
			var p1=this._controlPoints[0];
			var p2=this._controlPoints[1];
			var p3=this._controlPoints[2];
			var lineX=Math.pow((1-t),2)*p1.x+2 *t *(1-t)*p2.x+Math.pow(t,2)*p3.x;
			var lineY=Math.pow((1-t),2)*p1.y+2 *t *(1-t)*p2.y+Math.pow(t,2)*p3.y;
			rst.push(lineX,lineY);
		}

		/**
		*计算三次贝塞尔点
		*@param t
		*@param rst
		*
		*/
		__proto.getPoint3=function(t,rst){
			var p1=this._controlPoints[0];
			var p2=this._controlPoints[1];
			var p3=this._controlPoints[2];
			var p4=this._controlPoints[3];
			var lineX=Math.pow((1-t),3)*p1.x+3 *p2.x *t *(1-t)*(1-t)+3 *p3.x *t *t *(1-t)+p4.x *Math.pow(t,3);
			var lineY=Math.pow((1-t),3)*p1.y+3 *p2.y *t *(1-t)*(1-t)+3 *p3.y *t *t *(1-t)+p4.y *Math.pow(t,3);
			rst.push(lineX,lineY);
		}

		/**
		*计算贝塞尔点序列
		*@param count
		*@param rst
		*
		*/
		__proto.insertPoints=function(count,rst){
			var i=NaN;
			count=count > 0 ? count :5;
			var dLen=NaN;
			dLen=1 / count;
			for (i=0;i <=1;i+=dLen){
				this._calFun(i,rst);
			}
		}

		/**
		*获取贝塞尔曲线上的点。
		*@param pList 控制点[x0,y0,x1,y1...]
		*@param inSertCount 每次曲线的插值数量
		*@return
		*
		*/
		__proto.getBezierPoints=function(pList,inSertCount,count){
			(inSertCount===void 0)&& (inSertCount=5);
			(count===void 0)&& (count=2);
			var i=0,len=0;
			len=pList.length;
			if (len < (count+1)*2)return [];
			var rst;
			rst=[];
			switch (count){
				case 2:
					this._calFun=this.getPoint2;
					break ;
				case 3:
					this._calFun=this.getPoint3;
					break ;
				default :
					return [];
				}
			while(this._controlPoints.length<=count){
				this._controlPoints.push(new Point());
			}
			for (i=0;i < count *2;i+=2){
				this._switchPoint(pList[i],pList[i+1]);
			}
			for (i=count *2;i < len;i+=2){
				this._switchPoint(pList[i],pList[i+1]);
				if ((i / 2)% count==0)
					this.insertPoints(inSertCount,rst);
			}
			return rst;
		}

		__static(Bezier,
		['I',function(){return this.I=new Bezier();}
		]);
		return Bezier;
	})()


	/**
	*@private
	*凸包算法。
	*/
	//class laya.maths.GrahamScan
	var GrahamScan=(function(){
		function GrahamScan(){};
		__class(GrahamScan,'laya.maths.GrahamScan');
		GrahamScan.multiply=function(p1,p2,p0){
			return ((p1.x-p0.x)*(p2.y-p0.y)-(p2.x-p0.x)*(p1.y-p0.y));
		}

		GrahamScan.dis=function(p1,p2){
			return (p1.x-p2.x)*(p1.x-p2.x)+(p1.y-p2.y)*(p1.y-p2.y);
		}

		GrahamScan._getPoints=function(count,tempUse,rst){
			(tempUse===void 0)&& (tempUse=false);
			if (!GrahamScan._mPointList)GrahamScan._mPointList=[];
			while (GrahamScan._mPointList.length < count)GrahamScan._mPointList.push(new Point());
			if (!rst)rst=[];
			rst.length=0;
			if (tempUse){
				GrahamScan.getFrom(rst,GrahamScan._mPointList,count);
				}else {
				GrahamScan.getFromR(rst,GrahamScan._mPointList,count);
			}
			return rst;
		}

		GrahamScan.getFrom=function(rst,src,count){
			var i=0;
			for (i=0;i < count;i++){
				rst.push(src[i]);
			}
			return rst;
		}

		GrahamScan.getFromR=function(rst,src,count){
			var i=0;
			for (i=0;i < count;i++){
				rst.push(src.pop());
			}
			return rst;
		}

		GrahamScan.pListToPointList=function(pList,tempUse){
			(tempUse===void 0)&& (tempUse=false);
			var i=0,len=pList.length / 2,rst=GrahamScan._getPoints(len,tempUse,GrahamScan._tempPointList);
			for (i=0;i < len;i++){
				rst[i].setTo(pList[i+i],pList[i+i+1]);
			}
			return rst;
		}

		GrahamScan.pointListToPlist=function(pointList){
			var i=0,len=pointList.length,rst=GrahamScan._temPList,tPoint;
			rst.length=0;
			for (i=0;i < len;i++){
				tPoint=pointList[i];
				rst.push(tPoint.x,tPoint.y);
			}
			return rst;
		}

		GrahamScan.scanPList=function(pList){
			return Utils.copyArray(pList,GrahamScan.pointListToPlist(GrahamScan.scan(GrahamScan.pListToPointList(pList,true))));
		}

		GrahamScan.scan=function(PointSet){
			var i=0,j=0,k=0,top=2,tmp,n=PointSet.length,ch;
			var _tmpDic={};
			var key;
			ch=GrahamScan._temArr;
			ch.length=0;
			n=PointSet.length;
			for (i=n-1;i >=0;i--){
				tmp=PointSet[i];
				key=tmp.x+"_"+tmp.y;
				if (!_tmpDic.hasOwnProperty(key)){
					_tmpDic[key]=true;
					ch.push(tmp);
				}
			}
			n=ch.length;
			Utils.copyArray(PointSet,ch);
			for (i=1;i < n;i++)
			if ((PointSet[i].y < PointSet[k].y)|| ((PointSet[i].y==PointSet[k].y)&& (PointSet[i].x < PointSet[k].x)))
				k=i;
			tmp=PointSet[0];
			PointSet[0]=PointSet[k];
			PointSet[k]=tmp;
			for (i=1;i < n-1;i++){
				k=i;
				for (j=i+1;j < n;j++)
				if ((GrahamScan.multiply(PointSet[j],PointSet[k],PointSet[0])> 0)|| ((GrahamScan.multiply(PointSet[j],PointSet[k],PointSet[0])==0)&& (GrahamScan.dis(PointSet[0],PointSet[j])< GrahamScan.dis(PointSet[0],PointSet[k]))))
					k=j;
				tmp=PointSet[i];
				PointSet[i]=PointSet[k];
				PointSet[k]=tmp;
			}
			ch=GrahamScan._temArr;
			ch.length=0;
			if (PointSet.length < 3){
				return Utils.copyArray(ch,PointSet);
			}
			ch.push(PointSet[0],PointSet[1],PointSet[2]);
			for (i=3;i < n;i++){
				while (ch.length >=2 && GrahamScan.multiply(PointSet[i],ch[ch.length-1],ch[ch.length-2])>=0)ch.pop();
				PointSet[i] && ch.push(PointSet[i]);
			}
			return ch;
		}

		GrahamScan._mPointList=null
		GrahamScan._tempPointList=[];
		GrahamScan._temPList=[];
		GrahamScan._temArr=[];
		return GrahamScan;
	})()


	/**
	*@private
	*<code>MathUtil</code> 是一个数据处理工具类。
	*/
	//class laya.maths.MathUtil
	var MathUtil=(function(){
		function MathUtil(){};
		__class(MathUtil,'laya.maths.MathUtil');
		MathUtil.subtractVector3=function(l,r,o){
			o[0]=l[0]-r[0];
			o[1]=l[1]-r[1];
			o[2]=l[2]-r[2];
		}

		MathUtil.lerp=function(left,right,amount){
			return left *(1-amount)+right *amount;
		}

		MathUtil.scaleVector3=function(f,b,e){
			e[0]=f[0] *b;
			e[1]=f[1] *b;
			e[2]=f[2] *b;
		}

		MathUtil.lerpVector3=function(l,r,t,o){
			var ax=l[0],ay=l[1],az=l[2];
			o[0]=ax+t *(r[0]-ax);
			o[1]=ay+t *(r[1]-ay);
			o[2]=az+t *(r[2]-az);
		}

		MathUtil.lerpVector4=function(l,r,t,o){
			var ax=l[0],ay=l[1],az=l[2],aw=l[3];
			o[0]=ax+t *(r[0]-ax);
			o[1]=ay+t *(r[1]-ay);
			o[2]=az+t *(r[2]-az);
			o[3]=aw+t *(r[3]-aw);
		}

		MathUtil.slerpQuaternionArray=function(a,Offset1,b,Offset2,t,out,Offset3){
			var ax=a[Offset1+0],ay=a[Offset1+1],az=a[Offset1+2],aw=a[Offset1+3],bx=b[Offset2+0],by=b[Offset2+1],bz=b[Offset2+2],bw=b[Offset2+3];
			var omega,cosom,sinom,scale0,scale1;
			cosom=ax *bx+ay *by+az *bz+aw *bw;
			if (cosom < 0.0){
				cosom=-cosom;
				bx=-bx;
				by=-by;
				bz=-bz;
				bw=-bw;
			}
			if ((1.0-cosom)> 0.000001){
				omega=Math.acos(cosom);
				sinom=Math.sin(omega);
				scale0=Math.sin((1.0-t)*omega)/ sinom;
				scale1=Math.sin(t *omega)/ sinom;
				}else {
				scale0=1.0-t;
				scale1=t;
			}
			out[Offset3+0]=scale0 *ax+scale1 *bx;
			out[Offset3+1]=scale0 *ay+scale1 *by;
			out[Offset3+2]=scale0 *az+scale1 *bz;
			out[Offset3+3]=scale0 *aw+scale1 *bw;
			return out;
		}

		MathUtil.getRotation=function(x0,y0,x1,y1){
			return Math.atan2(y1-y0,x1-x0)/ Math.PI *180;
		}

		MathUtil.sortBigFirst=function(a,b){
			if (a==b)
				return 0;
			return b > a ? 1 :-1;
		}

		MathUtil.sortSmallFirst=function(a,b){
			if (a==b)
				return 0;
			return b > a ?-1 :1;
		}

		MathUtil.sortNumBigFirst=function(a,b){
			return parseFloat(b)-parseFloat(a);
		}

		MathUtil.sortNumSmallFirst=function(a,b){
			return parseFloat(a)-parseFloat(b);
		}

		MathUtil.sortByKey=function(key,bigFirst,forceNum){
			(bigFirst===void 0)&& (bigFirst=false);
			(forceNum===void 0)&& (forceNum=true);
			var _sortFun;
			if (bigFirst){
				_sortFun=forceNum ? MathUtil.sortNumBigFirst :MathUtil.sortBigFirst;
				}else {
				_sortFun=forceNum ? MathUtil.sortNumSmallFirst :MathUtil.sortSmallFirst;
			}
			return function (a,b){
				return _sortFun(a[key],b[key]);
			}
		}

		return MathUtil;
	})()


	/**
	*<code>Matrix</code> 类表示一个转换矩阵，它确定如何将点从一个坐标空间映射到另一个坐标空间。
	*/
	//class laya.maths.Matrix
	var Matrix=(function(){
		function Matrix(a,b,c,d,tx,ty){
			this.cos=1;
			this.sin=0;
			//this.a=NaN;
			//this.b=NaN;
			//this.c=NaN;
			//this.d=NaN;
			//this.tx=NaN;
			//this.ty=NaN;
			this.inPool=false;
			this.bTransform=false;
			(a===void 0)&& (a=1);
			(b===void 0)&& (b=0);
			(c===void 0)&& (c=0);
			(d===void 0)&& (d=1);
			(tx===void 0)&& (tx=0);
			(ty===void 0)&& (ty=0);
			this.a=a;
			this.b=b;
			this.c=c;
			this.d=d;
			this.tx=tx;
			this.ty=ty;
			this._checkTransform();
		}

		__class(Matrix,'laya.maths.Matrix');
		var __proto=Matrix.prototype;
		/**
		*为每个矩阵属性设置一个值。
		*@return 返回当前矩形。
		*/
		__proto.identity=function(){
			this.a=this.d=1;
			this.b=this.tx=this.ty=this.c=0;
			this.bTransform=false;
			return this;
		}

		/**@private*/
		__proto._checkTransform=function(){
			return this.bTransform=(this.a!==1 || this.b!==0 || this.c!==0 || this.d!==1);
		}

		/**
		*设置沿 x 、y 轴平移每个点的距离。
		*@param x 沿 x 轴平移每个点的距离。
		*@param y 沿 y 轴平移每个点的距离。
		*@return 返回对象本身
		*/
		__proto.setTranslate=function(x,y){
			this.tx=x;
			this.ty=y;
			return this;
		}

		/**
		*沿 x 和 y 轴平移矩阵，由 x 和 y 参数指定。
		*@param x 沿 x 轴向右移动的量（以像素为单位）。
		*@param y 沿 y 轴向下移动的量（以像素为单位）。
		*@return 返回此矩形。
		*/
		__proto.translate=function(x,y){
			this.tx+=x;
			this.ty+=y;
			return this;
		}

		/**
		*对矩阵应用缩放转换。
		*@param x 用于沿 x 轴缩放对象的乘数。
		*@param y 用于沿 y 轴缩放对象的乘数。
		*/
		__proto.scale=function(x,y){
			this.a *=x;
			this.d *=y;
			this.c *=x;
			this.b *=y;
			this.tx *=x;
			this.ty *=y;
			this.bTransform=true;
		}

		/**
		*对 Matrix 对象应用旋转转换。
		*@param angle 以弧度为单位的旋转角度。
		*/
		__proto.rotate=function(angle){
			var cos=this.cos=Math.cos(angle);
			var sin=this.sin=Math.sin(angle);
			var a1=this.a;
			var c1=this.c;
			var tx1=this.tx;
			this.a=a1 *cos-this.b *sin;
			this.b=a1 *sin+this.b *cos;
			this.c=c1 *cos-this.d *sin;
			this.d=c1 *sin+this.d *cos;
			this.tx=tx1 *cos-this.ty *sin;
			this.ty=tx1 *sin+this.ty *cos;
			this.bTransform=true;
		}

		/**
		*对 Matrix 对象应用倾斜转换。
		*@param x 沿着 X 轴的 2D 倾斜弧度。
		*@param y 沿着 Y 轴的 2D 倾斜弧度。
		*@return 当前 Matrix 对象。
		*/
		__proto.skew=function(x,y){
			var tanX=Math.tan(x);
			var tanY=Math.tan(y);
			var a1=this.a;
			var b1=this.b;
			this.a+=tanY *this.c;
			this.b+=tanY *this.d;
			this.c+=tanX *a1;
			this.d+=tanX *b1;
			return this;
		}

		/**
		*对指定的点应用当前矩阵的逆转化并返回此点。
		*@param out 待转化的点 Point 对象。
		*@return 返回out
		*/
		__proto.invertTransformPoint=function(out){
			var a1=this.a;
			var b1=this.b;
			var c1=this.c;
			var d1=this.d;
			var tx1=this.tx;
			var n=a1 *d1-b1 *c1;
			var a2=d1 / n;
			var b2=-b1 / n;
			var c2=-c1 / n;
			var d2=a1 / n;
			var tx2=(c1 *this.ty-d1 *tx1)/ n;
			var ty2=-(a1 *this.ty-b1 *tx1)/ n;
			return out.setTo(a2 *out.x+c2 *out.y+tx2,b2 *out.x+d2 *out.y+ty2);
		}

		/**
		*将 Matrix 对象表示的几何转换应用于指定点。
		*@param out 用来设定输出结果的点。
		*@return 返回out
		*/
		__proto.transformPoint=function(out){
			return out.setTo(this.a *out.x+this.c *out.y+this.tx,this.b *out.x+this.d *out.y+this.ty);
		}

		/**
		*@private
		*将 Matrix 对象表示的几何转换应用于指定点。
		*@param data 点集合。
		*@param out 存储应用转化的点的列表。
		*@return 返回out数组
		*/
		__proto.transformPointArray=function(data,out){
			var len=data.length;
			for (var i=0;i < len;i+=2){
				var x=data[i],y=data[i+1];
				out[i]=this.a *x+this.c *y+this.tx;
				out[i+1]=this.b *x+this.d *y+this.ty;
			}
			return out;
		}

		/**
		*@private
		*将 Matrix 对象表示的几何缩放转换应用于指定点。
		*@param data 点集合。
		*@param out 存储应用转化的点的列表。
		*@return 返回out数组
		*/
		__proto.transformPointArrayScale=function(data,out){
			var len=data.length;
			for (var i=0;i < len;i+=2){
				var x=data[i],y=data[i+1];
				out[i]=this.a *x+this.c *y;
				out[i+1]=this.b *x+this.d *y;
			}
			return out;
		}

		/**
		*获取 X 轴缩放值。
		*@return X 轴缩放值。
		*/
		__proto.getScaleX=function(){
			return this.b===0 ? this.a :Math.sqrt(this.a *this.a+this.b *this.b);
		}

		/**
		*获取 Y 轴缩放值。
		*@return Y 轴缩放值。
		*/
		__proto.getScaleY=function(){
			return this.c===0 ? this.d :Math.sqrt(this.c *this.c+this.d *this.d);
		}

		/**
		*执行原始矩阵的逆转换。
		*@return 当前矩阵对象。
		*/
		__proto.invert=function(){
			var a1=this.a;
			var b1=this.b;
			var c1=this.c;
			var d1=this.d;
			var tx1=this.tx;
			var n=a1 *d1-b1 *c1;
			this.a=d1 / n;
			this.b=-b1 / n;
			this.c=-c1 / n;
			this.d=a1 / n;
			this.tx=(c1 *this.ty-d1 *tx1)/ n;
			this.ty=-(a1 *this.ty-b1 *tx1)/ n;
			return this;
		}

		/**
		*将 Matrix 的成员设置为指定值。
		*@param a 缩放或旋转图像时影响像素沿 x 轴定位的值。
		*@param b 旋转或倾斜图像时影响像素沿 y 轴定位的值。
		*@param c 旋转或倾斜图像时影响像素沿 x 轴定位的值。
		*@param d 缩放或旋转图像时影响像素沿 y 轴定位的值。
		*@param tx 沿 x 轴平移每个点的距离。
		*@param ty 沿 y 轴平移每个点的距离。
		*@return 当前矩阵对象。
		*/
		__proto.setTo=function(a,b,c,d,tx,ty){
			this.a=a,this.b=b,this.c=c,this.d=d,this.tx=tx,this.ty=ty;
			return this;
		}

		/**
		*将指定矩阵与当前矩阵连接，从而将这两个矩阵的几何效果有效地结合在一起。
		*@param matrix 要连接到源矩阵的矩阵。
		*@return 当前矩阵。
		*/
		__proto.concat=function(matrix){
			var a=this.a;
			var c=this.c;
			var tx=this.tx;
			this.a=a *matrix.a+this.b *matrix.c;
			this.b=a *matrix.b+this.b *matrix.d;
			this.c=c *matrix.a+this.d *matrix.c;
			this.d=c *matrix.b+this.d *matrix.d;
			this.tx=tx *matrix.a+this.ty *matrix.c+matrix.tx;
			this.ty=tx *matrix.b+this.ty *matrix.d+matrix.ty;
			return this;
		}

		/**
		*对矩阵应用缩放转换。反向相乘
		*@param x 用于沿 x 轴缩放对象的乘数。
		*@param y 用于沿 y 轴缩放对象的乘数。
		*/
		__proto.scaleEx=function(x,y){
			var ba=this.a,bb=this.b,bc=this.c,bd=this.d;
			if (bb!==0 || bc!==0){
				this.a=x *ba;
				this.b=x *bb;
				this.c=y *bc;
				this.d=y *bd;
			}
			else{
				this.a=x *ba;
				this.b=0 *bd;
				this.c=0 *ba;
				this.d=y *bd;
			}
			this.bTransform=true;
		}

		/**
		*对 Matrix 对象应用旋转转换。反向相乘
		*@param angle 以弧度为单位的旋转角度。
		*/
		__proto.rotateEx=function(angle){
			var cos=Math.cos(angle);
			var sin=Math.sin(angle);
			var ba=this.a,bb=this.b,bc=this.c,bd=this.d;
			if (bb!==0 || bc!==0){
				this.a=cos *ba+sin *bc;
				this.b=cos *bb+sin *bd;
				this.c=-sin *ba+cos *bc;
				this.d=-sin *bb+cos *bd;
			}
			else{
				this.a=cos *ba;
				this.b=sin *bd;
				this.c=-sin *ba;
				this.d=cos *bd;
			}
			this.bTransform=true;
		}

		/**
		*返回一个新的 Matrix 对象，它是此矩阵的克隆，带有与所含对象完全相同的副本。
		*@return 一个 Matrix 对象。
		*/
		__proto.clone=function(){
			var no=Matrix._cache;
			var dec=!no._length ? (new Matrix()):no[--no._length];
			dec.a=this.a;
			dec.b=this.b;
			dec.c=this.c;
			dec.d=this.d;
			dec.tx=this.tx;
			dec.ty=this.ty;
			dec.bTransform=this.bTransform;
			return dec;
		}

		/**
		*将当前 Matrix 对象中的所有矩阵数据复制到指定的 Matrix 对象中。
		*@param dec 要复制当前矩阵数据的 Matrix 对象。
		*@return 已复制当前矩阵数据的 Matrix 对象。
		*/
		__proto.copyTo=function(dec){
			dec.a=this.a;
			dec.b=this.b;
			dec.c=this.c;
			dec.d=this.d;
			dec.tx=this.tx;
			dec.ty=this.ty;
			dec.bTransform=this.bTransform;
			return dec;
		}

		/**
		*返回列出该 Matrix 对象属性的文本值。
		*@return 一个字符串，它包含 Matrix 对象的属性值：a、b、c、d、tx 和 ty。
		*/
		__proto.toString=function(){
			return this.a+","+this.b+","+this.c+","+this.d+","+this.tx+","+this.ty;
		}

		/**
		*销毁此对象。
		*/
		__proto.destroy=function(){
			if (this.inPool)return;
			var cache=Matrix._cache;
			this.inPool=true;
			cache._length || (cache._length=0);
			cache[cache._length++]=this;
			this.a=this.d=1;
			this.b=this.c=this.tx=this.ty=0;
			this.bTransform=false;
		}

		Matrix.mul=function(m1,m2,out){
			var aa=m1.a,ab=m1.b,ac=m1.c,ad=m1.d,atx=m1.tx,aty=m1.ty;
			var ba=m2.a,bb=m2.b,bc=m2.c,bd=m2.d,btx=m2.tx,bty=m2.ty;
			if (bb!==0 || bc!==0){
				out.a=aa *ba+ab *bc;
				out.b=aa *bb+ab *bd;
				out.c=ac *ba+ad *bc;
				out.d=ac *bb+ad *bd;
				out.tx=ba *atx+bc *aty+btx;
				out.ty=bb *atx+bd *aty+bty;
				}else {
				out.a=aa *ba;
				out.b=ab *bd;
				out.c=ac *ba;
				out.d=ad *bd;
				out.tx=ba *atx+btx;
				out.ty=bd *aty+bty;
			}
			return out;
		}

		Matrix.mul16=function(m1,m2,out){
			var aa=m1.a,ab=m1.b,ac=m1.c,ad=m1.d,atx=m1.tx,aty=m1.ty;
			var ba=m2.a,bb=m2.b,bc=m2.c,bd=m2.d,btx=m2.tx,bty=m2.ty;
			if (bb!==0 || bc!==0){
				out[0]=aa *ba+ab *bc;
				out[1]=aa *bb+ab *bd;
				out[4]=ac *ba+ad *bc;
				out[5]=ac *bb+ad *bd;
				out[12]=ba *atx+bc *aty+btx;
				out[13]=bb *atx+bd *aty+bty;
				}else {
				out[0]=aa *ba;
				out[1]=ab *bd;
				out[4]=ac *ba;
				out[5]=ad *bd;
				out[12]=ba *atx+btx;
				out[13]=bd *aty+bty;
			}
			return out;
		}

		Matrix.mulPre=function(m1,ba,bb,bc,bd,btx,bty,out){
			var aa=m1.a,ab=m1.b,ac=m1.c,ad=m1.d,atx=m1.tx,aty=m1.ty;
			if (bb!==0 || bc!==0){
				out.a=aa *ba+ab *bc;
				out.b=aa *bb+ab *bd;
				out.c=ac *ba+ad *bc;
				out.d=ac *bb+ad *bd;
				out.tx=ba *atx+bc *aty+btx;
				out.ty=bb *atx+bd *aty+bty;
				}else {
				out.a=aa *ba;
				out.b=ab *bd;
				out.c=ac *ba;
				out.d=ad *bd;
				out.tx=ba *atx+btx;
				out.ty=bd *aty+bty;
			}
			return out;
		}

		Matrix.mulPos=function(m1,aa,ab,ac,ad,atx,aty,out){
			var ba=m1.a,bb=m1.b,bc=m1.c,bd=m1.d,btx=m1.tx,bty=m1.ty;
			if (bb!==0 || bc!==0){
				out.a=aa *ba+ab *bc;
				out.b=aa *bb+ab *bd;
				out.c=ac *ba+ad *bc;
				out.d=ac *bb+ad *bd;
				out.tx=ba *atx+bc *aty+btx;
				out.ty=bb *atx+bd *aty+bty;
				}else {
				out.a=aa *ba;
				out.b=ab *bd;
				out.c=ac *ba;
				out.d=ad *bd;
				out.tx=ba *atx+btx;
				out.ty=bd *aty+bty;
			}
			return out;
		}

		Matrix.preMul=function(parent,self,out){
			var pa=parent.a,pb=parent.b,pc=parent.c,pd=parent.d;
			var na=self.a,nb=self.b,nc=self.c,nd=self.d,ntx=self.tx,nty=self.ty;
			out.a=na *pa;
			out.b=out.c=0;
			out.d=nd *pd;
			out.tx=ntx *pa+parent.tx;
			out.ty=nty *pd+parent.ty;
			if (nb!==0 || nc!==0 || pb!==0 || pc!==0){
				out.a+=nb *pc;
				out.d+=nc *pb;
				out.b+=na *pb+nb *pd;
				out.c+=nc *pa+nd *pc;
				out.tx+=nty *pc;
				out.ty+=ntx *pb;
			}
			return out;
		}

		Matrix.preMulXY=function(parent,x,y,out){
			var pa=parent.a,pb=parent.b,pc=parent.c,pd=parent.d;
			out.a=pa;
			out.b=pb;
			out.c=pc;
			out.d=pd;
			out.tx=x *pa+parent.tx+y *pc;
			out.ty=y *pd+parent.ty+x *pb;
			return out;
		}

		Matrix.create=function(){
			var cache=Matrix._cache;
			var mat=!cache._length ? (new Matrix()):cache[--cache._length];
			mat.inPool=false;
			return mat;
		}

		Matrix.EMPTY=new Matrix();
		Matrix.TEMP=new Matrix();
		Matrix._cache=[];
		return Matrix;
	})()


	/**
	*<code>Point</code> 对象表示二维坐标系统中的某个位置，其中 x 表示水平轴，y 表示垂直轴。
	*/
	//class laya.maths.Point
	var Point=(function(){
		function Point(x,y){
			//this.x=NaN;
			//this.y=NaN;
			(x===void 0)&& (x=0);
			(y===void 0)&& (y=0);
			this.x=x;
			this.y=y;
		}

		__class(Point,'laya.maths.Point');
		var __proto=Point.prototype;
		/**
		*将 <code>Point</code> 的成员设置为指定值。
		*@param x 水平坐标。
		*@param y 垂直坐标。
		*@return 当前 Point 对象。
		*/
		__proto.setTo=function(x,y){
			this.x=x;
			this.y=y;
			return this;
		}

		/**
		*计算当前点和目标x，y点的距离
		*@param x 水平坐标。
		*@param y 垂直坐标。
		*@return 返回之间的距离
		*/
		__proto.distance=function(x,y){
			return Math.sqrt((this.x-x)*(this.x-x)+(this.y-y)*(this.y-y));
		}

		/**返回包含 x 和 y 坐标的值的字符串。*/
		__proto.toString=function(){
			return this.x+","+this.y;
		}

		/**
		*标准化向量
		*/
		__proto.normalize=function(){
			var d=Math.sqrt(this.x *this.x+this.y *this.y);
			if (d > 0){
				var id=1.0 / d;
				this.x *=id;
				this.y *=id;
			}
		}

		Point.TEMP=new Point();
		Point.EMPTY=new Point();
		return Point;
	})()


	/**
	*<code>Rectangle</code> 对象是按其位置（由它左上角的点 (x,y)确定）以及宽度和高度定义的区域。
	*/
	//class laya.maths.Rectangle
	var Rectangle=(function(){
		function Rectangle(x,y,width,height){
			//this.x=NaN;
			//this.y=NaN;
			//this.width=NaN;
			//this.height=NaN;
			(x===void 0)&& (x=0);
			(y===void 0)&& (y=0);
			(width===void 0)&& (width=0);
			(height===void 0)&& (height=0);
			this.x=x;
			this.y=y;
			this.width=width;
			this.height=height;
		}

		__class(Rectangle,'laya.maths.Rectangle');
		var __proto=Rectangle.prototype;
		/**
		*将 Rectangle 的属性设置为指定值。
		*@param x x 矩形左上角的 X 轴坐标。
		*@param y x 矩形左上角的 Y 轴坐标。
		*@param width 矩形的宽度。
		*@param height 矩形的高。
		*@return 返回属性值修改后的矩形对象本身。
		*/
		__proto.setTo=function(x,y,width,height){
			this.x=x;
			this.y=y;
			this.width=width;
			this.height=height;
			return this;
		}

		/**
		*复制 source 对象的属性值到此矩形对象中。
		*@param sourceRect 源 Rectangle 对象。
		*@return 返回属性值修改后的矩形对象本身。
		*/
		__proto.copyFrom=function(source){
			this.x=source.x;
			this.y=source.y;
			this.width=source.width;
			this.height=source.height;
			return this;
		}

		/**
		*检测此矩形对象是否包含指定的点。
		*@param x 点的 X 轴坐标值（水平位置）。
		*@param y 点的 Y 轴坐标值（垂直位置）。
		*@return 如果 Rectangle 对象包含指定的点，则值为 true；否则为 false。
		*/
		__proto.contains=function(x,y){
			if (this.width <=0 || this.height <=0)return false;
			if (x >=this.x && x < this.right){
				if (y >=this.y && y < this.bottom){
					return true;
				}
			}
			return false;
		}

		/**
		*检测传入的矩形对象是否与此对象相交。
		*@param rect Rectangle 对象。
		*@return 如果传入的矩形对象与此对象相交，则返回 true 值，否则返回 false。
		*/
		__proto.intersects=function(rect){
			return !(rect.x > (this.x+this.width)|| (rect.x+rect.width)< this.x || rect.y > (this.y+this.height)|| (rect.y+rect.height)< this.y);
		}

		/**
		*获取此对象与传入的矩形对象的相交区域。并将相交区域赋值给传入的输出矩形对象。
		*@param rect 待比较的矩形区域。
		*@param out 待输出的矩形区域。建议：尽量用此对象复用对象，减少对象创建消耗。
		*@return 返回相交的矩形区域对象。
		*/
		__proto.intersection=function(rect,out){
			if (!this.intersects(rect))return null;
			out || (out=new Rectangle());
			out.x=Math.max(this.x,rect.x);
			out.y=Math.max(this.y,rect.y);
			out.width=Math.min(this.right,rect.right)-out.x;
			out.height=Math.min(this.bottom,rect.bottom)-out.y;
			return out;
		}

		/**
		*矩形联合，通过填充两个矩形之间的水平和垂直空间，将这两个矩形组合在一起以创建一个新的 Rectangle 对象。
		*@param 目标矩形对象。
		*@param out 待输出结果的矩形对象。建议：尽量用此对象复用对象，减少对象创建消耗。
		*@return 两个矩形后联合的 Rectangle 对象 out 。
		*/
		__proto.union=function(source,out){
			out || (out=new Rectangle());
			this.clone(out);
			if (source.width <=0 || source.height <=0)return out;
			out.addPoint(source.x,source.y);
			out.addPoint(source.right,source.bottom);
			return this;
		}

		/**
		*返回一个 Rectangle 对象，其 x、y、width 和 height 属性的值与当前 Rectangle 对象的对应值相同。
		*@param out 待输出的矩形对象。建议：尽量用此对象复用对象，减少对象创建消耗。
		*@return Rectangle 对象 out ，其 x、y、width 和 height 属性的值与当前 Rectangle 对象的对应值相同。
		*/
		__proto.clone=function(out){
			out || (out=new Rectangle());
			out.x=this.x;
			out.y=this.y;
			out.width=this.width;
			out.height=this.height;
			return out;
		}

		/**
		*当前 Rectangle 对象的水平位置 x 和垂直位置 y 以及高度 width 和宽度 height 以逗号连接成的字符串。
		*/
		__proto.toString=function(){
			return this.x+","+this.y+","+this.width+","+this.height;
		}

		/**
		*检测传入的 Rectangle 对象的属性是否与当前 Rectangle 对象的属性 x、y、width、height 属性值都相等。
		*@param rect 待比较的 Rectangle 对象。
		*@return 如果判断的属性都相等，则返回 true ,否则返回 false。
		*/
		__proto.equals=function(rect){
			if (!rect || rect.x!==this.x || rect.y!==this.y || rect.width!==this.width || rect.height!==this.height)return false;
			return true;
		}

		/**
		*在当前矩形区域中加一个点。
		*@param x 点的 X 坐标。
		*@param y 点的 Y 坐标。
		*@return 返回此 Rectangle 对象。
		*/
		__proto.addPoint=function(x,y){
			this.x > x && (this.width+=this.x-x,this.x=x);
			this.y > y && (this.height+=this.y-y,this.y=y);
			if (this.width < x-this.x)this.width=x-this.x;
			if (this.height < y-this.y)this.height=y-this.y;
			return this;
		}

		/**
		*@private
		*返回代表当前矩形的顶点数据。
		*@return 顶点数据。
		*/
		__proto._getBoundPoints=function(){
			var rst=Rectangle._temB;
			rst.length=0;
			if (this.width==0 || this.height==0)return rst;
			rst.push(this.x,this.y,this.x+this.width,this.y,this.x,this.y+this.height,this.x+this.width,this.y+this.height);
			return rst;
		}

		/**确定此 Rectangle 对象是否为空。*/
		__proto.isEmpty=function(){
			if (this.width <=0 || this.height <=0)return true;
			return false;
		}

		/**此矩形的右边距。 x 和 width 属性的和。*/
		__getset(0,__proto,'right',function(){
			return this.x+this.width;
		});

		/**此矩形的底边距。y 和 height 属性的和。*/
		__getset(0,__proto,'bottom',function(){
			return this.y+this.height;
		});

		Rectangle._getBoundPointS=function(x,y,width,height){
			var rst=Rectangle._temA;
			rst.length=0;
			if (width==0 || height==0)return rst;
			rst.push(x,y,x+width,y,x,y+height,x+width,y+height);
			return rst;
		}

		Rectangle._getWrapRec=function(pointList,rst){
			if (!pointList || pointList.length < 1)return rst ? rst.setTo(0,0,0,0):Rectangle.TEMP.setTo(0,0,0,0);
			rst=rst ? rst :new Rectangle();
			var i,len=pointList.length,minX,maxX,minY,maxY,tPoint=Point.TEMP;
			minX=minY=99999;
			maxX=maxY=-minX;
			for (i=0;i < len;i+=2){
				tPoint.x=pointList[i];
				tPoint.y=pointList[i+1];
				minX=minX < tPoint.x ? minX :tPoint.x;
				minY=minY < tPoint.y ? minY :tPoint.y;
				maxX=maxX > tPoint.x ? maxX :tPoint.x;
				maxY=maxY > tPoint.y ? maxY :tPoint.y;
			}
			return rst.setTo(minX,minY,maxX-minX,maxY-minY);
		}

		Rectangle.EMPTY=new Rectangle();
		Rectangle.TEMP=new Rectangle();
		Rectangle._temB=[];
		Rectangle._temA=[];
		return Rectangle;
	})()


	/**
	*<code>SoundManager</code> 是一个声音管理类。
	*/
	//class laya.media.SoundManager
	var SoundManager=(function(){
		function SoundManager(){};
		__class(SoundManager,'laya.media.SoundManager');
		/**
		*设置是否失去焦点后自动停止背景音乐。
		*@param v Boolean 值。
		*
		*/
		/**
		*表示是否失去焦点后自动停止背景音乐。
		*@return
		*/
		__getset(1,SoundManager,'autoStopMusic',function(){
			return SoundManager._autoStopMusic;
			},function(v){
			Laya.stage.off("blur",null,SoundManager._stageOnBlur);
			Laya.stage.off("focus",null,SoundManager._stageOnFocus);
			SoundManager._autoStopMusic=v;
			if (v){
				Laya.stage.on("blur",null,SoundManager._stageOnBlur);
				Laya.stage.on("focus",null,SoundManager._stageOnFocus);
			}
		});

		/**
		*表示是否静音。
		*/
		__getset(1,SoundManager,'muted',function(){
			return SoundManager._muted;
			},function(value){
			if (value){
				SoundManager.stopAllSound();
			}
			SoundManager.musicMuted=value;
			SoundManager._muted=value;
		});

		/**表示是否使背景音乐静音。*/
		__getset(1,SoundManager,'musicMuted',function(){
			return SoundManager._musicMuted;
			},function(value){
			if (value){
				if (SoundManager._tMusic)
					SoundManager.stopSound(SoundManager._tMusic);
				SoundManager._musicMuted=value;
				}else {
				SoundManager._musicMuted=value;
				if (SoundManager._tMusic){
					SoundManager.playMusic(SoundManager._tMusic);
				}
			}
		});

		/**表示是否使音效静音。*/
		__getset(1,SoundManager,'soundMuted',function(){
			return SoundManager._soundMuted;
			},function(value){
			SoundManager._soundMuted=value;
		});

		SoundManager.addChannel=function(channel){
			if (SoundManager._channels.indexOf(channel)>=0)return;
			SoundManager._channels.push(channel);
		}

		SoundManager.removeChannel=function(channel){
			var i=0;
			for (i=SoundManager._channels.length-1;i >=0;i--){
				if (SoundManager._channels[i]==channel){
					SoundManager._channels.splice(i,1);
				}
			}
		}

		SoundManager._stageOnBlur=function(){
			if (SoundManager._musicChannel){
				if (!SoundManager._musicChannel.isStopped){
					SoundManager._blurPaused=true;
					SoundManager._musicLoops=SoundManager._musicChannel.loops;
					SoundManager._musicCompleteHandler=SoundManager._musicChannel.completeHandler;
					SoundManager._musicPosition=SoundManager._musicChannel.position;
					SoundManager._musicChannel.stop();
					Laya.stage.once("mousedown",null,SoundManager._stageOnFocus);
				}
			}
		}

		SoundManager._stageOnFocus=function(){
			Laya.stage.off("mousedown",null,SoundManager._stageOnFocus);
			if (SoundManager._blurPaused){
				SoundManager.playMusic(SoundManager._tMusic,SoundManager._musicLoops,SoundManager._musicCompleteHandler,SoundManager._musicPosition);
				SoundManager._blurPaused=false;
			}
		}

		SoundManager.playSound=function(url,loops,complete,soundClass,startTime){
			(loops===void 0)&& (loops=1);
			(startTime===void 0)&& (startTime=0);
			if (SoundManager._muted)
				return null;
			url=URL.formatURL(url);
			if (url==SoundManager._tMusic){
				if (SoundManager._musicMuted)return null;
				}else {
				if (SoundManager._soundMuted)return null;
			};
			var tSound=Laya.loader.getRes(url);
			if (!soundClass)soundClass=SoundManager._soundClass;
			if (!tSound){
				tSound=new soundClass();
				tSound.load(url);
				Loader.cacheRes(url,tSound);
			};
			var channel;
			channel=tSound.play(startTime,loops);
			channel.url=url;
			channel.volume=(url==SoundManager._tMusic)? SoundManager.musicVolume :SoundManager.soundVolume;
			channel.completeHandler=complete;
			return channel;
		}

		SoundManager.destroySound=function(url){
			var tSound=Laya.loader.getRes(url);
			if (tSound){
				Loader.clearRes(url);
				tSound.dispose();
			}
		}

		SoundManager.playMusic=function(url,loops,complete,startTime){
			(loops===void 0)&& (loops=0);
			(startTime===void 0)&& (startTime=0);
			url=URL.formatURL(url);
			SoundManager._tMusic=url;
			if (SoundManager._musicChannel)
				SoundManager._musicChannel.stop();
			return SoundManager._musicChannel=SoundManager.playSound(url,loops,complete,null,startTime);
		}

		SoundManager.stopSound=function(url){
			url=URL.formatURL(url);
			var i=0;
			var channel;
			for (i=SoundManager._channels.length-1;i >=0;i--){
				channel=SoundManager._channels[i];
				if (channel.url==url){
					channel.stop();
				}
			}
		}

		SoundManager.stopAll=function(){
			SoundManager._tMusic=null;
			var i=0;
			var channel;
			for (i=SoundManager._channels.length-1;i >=0;i--){
				channel=SoundManager._channels[i];
				channel.stop();
			}
		}

		SoundManager.stopAllSound=function(){
			var i=0;
			var channel;
			for (i=SoundManager._channels.length-1;i >=0;i--){
				channel=SoundManager._channels[i];
				if (channel.url !=SoundManager._tMusic){
					channel.stop();
				}
			}
		}

		SoundManager.stopMusic=function(){
			SoundManager._tMusic=null;
			if (SoundManager._musicChannel)
				SoundManager._musicChannel.stop();
		}

		SoundManager.setSoundVolume=function(volume,url){
			if (url){
				url=URL.formatURL(url);
				SoundManager._setVolume(url,volume);
				}else {
				SoundManager.soundVolume=volume;
				var i=0;
				var channel;
				for (i=SoundManager._channels.length-1;i >=0;i--){
					channel=SoundManager._channels[i];
					if (channel.url !=SoundManager._tMusic){
						channel.volume=volume;
					}
				}
			}
		}

		SoundManager.setMusicVolume=function(volume){
			SoundManager.musicVolume=volume;
			SoundManager._setVolume(SoundManager._tMusic,volume);
		}

		SoundManager._setVolume=function(url,volume){
			var i=0;
			var channel;
			for (i=SoundManager._channels.length-1;i >=0;i--){
				channel=SoundManager._channels[i];
				if (channel.url==url){
					channel.volume=volume;
				}
			}
		}

		SoundManager.musicVolume=1;
		SoundManager.soundVolume=1;
		SoundManager.playbackRate=1;
		SoundManager._muted=false;
		SoundManager._soundMuted=false;
		SoundManager._musicMuted=false;
		SoundManager._tMusic=null;
		SoundManager._musicChannel=null;
		SoundManager._channels=[];
		SoundManager._autoStopMusic=false;
		SoundManager._blurPaused=false;
		SoundManager._musicLoops=0;
		SoundManager._musicPosition=0;
		SoundManager._musicCompleteHandler=null;
		SoundManager._soundClass=null
		return SoundManager;
	})()


	/**
	*<p> <code>LocalStorage</code> 类用于没有时间限制的数据存储。</p>
	*/
	//class laya.net.LocalStorage
	var LocalStorage=(function(){
		var Storage;
		function LocalStorage(){};
		__class(LocalStorage,'laya.net.LocalStorage');
		LocalStorage.__init__=function(){
			if (!LocalStorage._baseClass){
				LocalStorage._baseClass=Storage;
				Storage.init();
			}
			LocalStorage.items=LocalStorage._baseClass.items;
			LocalStorage.support=LocalStorage._baseClass.support;
		}

		LocalStorage.setItem=function(key,value){
			LocalStorage._baseClass.setItem(key,value);
		}

		LocalStorage.getItem=function(key){
			return LocalStorage._baseClass.getItem(key);
		}

		LocalStorage.setJSON=function(key,value){
			LocalStorage._baseClass.setJSON(key,value);
		}

		LocalStorage.getJSON=function(key){
			return LocalStorage._baseClass.getJSON(key);
		}

		LocalStorage.removeItem=function(key){
			LocalStorage._baseClass.removeItem(key);
		}

		LocalStorage.clear=function(){
			LocalStorage._baseClass.clear();
		}

		LocalStorage._baseClass=null
		LocalStorage.items=null
		LocalStorage.support=false;
		LocalStorage.__init$=function(){
			//class Storage
			Storage=(function(){
				function Storage(){};
				__class(Storage,'');
				Storage.init=function(){
					try{Storage.items=window.localStorage;Storage.setItem('laya','1');Storage.removeItem('laya');Storage.support=true;}catch(e){}if(!Storage.support)console.log('LocalStorage is not supprot or browser is private mode.');
				}
				Storage.setItem=function(key,value){
					try {
						Storage.support && Storage.items.setItem(key,value);
						}catch (e){
						console.log("set localStorage failed",e);
					}
				}
				Storage.getItem=function(key){
					return Storage.support ? Storage.items.getItem(key):null;
				}
				Storage.setJSON=function(key,value){
					try {
						Storage.support && Storage.items.setItem(key,JSON.stringify(value));
						}catch (e){
						console.log("set localStorage failed",e);
					}
				}
				Storage.getJSON=function(key){
					return JSON.parse(Storage.support ? Storage.items.getItem(key):null);
				}
				Storage.removeItem=function(key){
					Storage.support && Storage.items.removeItem(key);
				}
				Storage.clear=function(){
					Storage.support && Storage.items.clear();
				}
				Storage.items=null
				Storage.support=true;
				return Storage;
			})()
		}

		return LocalStorage;
	})()


	/**
	*<p> <code>URL</code> 类用于定义地址信息。</p>
	*/
	//class laya.net.URL
	var URL=(function(){
		function URL(url){
			this._url=null;
			this._path=null;
			this._url=URL.formatURL(url);
			this._path=URL.getPath(url);
		}

		__class(URL,'laya.net.URL');
		var __proto=URL.prototype;
		/**地址的路径。*/
		__getset(0,__proto,'path',function(){
			return this._path;
		});

		/**格式化后的地址。*/
		__getset(0,__proto,'url',function(){
			return this._url;
		});

		URL.formatURL=function(url,base){
			if (URL.customFormat !=null)url=URL.customFormat(url,base);
			if (!url)return "null path";
			if (url.indexOf("data:image")===0)return url;
			if (Render.isConchApp==false){
				URL.version[url] && (url+="?v="+URL.version[url]);
			}
			if (url.charAt(0)=='~')return URL.rootPath+url.substring(1);
			if (URL.isAbsolute(url))return url;
			var retVal=(base || URL.basePath)+url;
			return URL.formatRelativePath(retVal);
		}

		URL.formatRelativePath=function(value){
			if (value.indexOf("../")>-1){
				var parts=value.split("/");
				for (var i=0,len=parts.length;i < len;i++){
					if (parts[i]=='..'){
						parts.splice(i-1,2);
						i-=2;
					}
				}
				return parts.join('/');
			}
			return value;
		}

		URL.isAbsolute=function(url){
			return url.indexOf(":")> 0 || url.charAt(0)=='/';
		}

		URL.getPath=function(url){
			var ofs=url.lastIndexOf('/');
			return ofs > 0 ? url.substr(0,ofs+1):"";
		}

		URL.getFileName=function(url){
			var ofs=url.lastIndexOf('/');
			return ofs > 0 ? url.substr(ofs+1):url;
		}

		URL.version={};
		URL.basePath="";
		URL.rootPath="";
		URL.customFormat=null
		return URL;
	})()


	/**
	*@private
	*<code>Render</code> 是渲染管理类。它是一个单例，可以使用 Laya.render 访问。
	*/
	//class laya.renders.Render
	var Render=(function(){
		function Render(width,height){
			this._timeId=0;
			var style=Render._mainCanvas.source.style;
			style.position='absolute';
			style.top=style.left="0px";
			style.background="#000000";
			Render._mainCanvas.source.id=Render._mainCanvas.source.id || "layaCanvas";
			var isWebGl=laya.renders.Render.isWebGL;
			isWebGl && Render.WebGL.init(Render._mainCanvas,width,height);
			if (Render._mainCanvas.source.nodeName || laya.renders.Render.isConchApp){
				Browser.container.appendChild(Render._mainCanvas.source);
			}
			Render._context=new RenderContext(width,height,isWebGl ? null :Render._mainCanvas);
			Render._context.ctx.setIsMainContext();
			var arr=/\bChrome\/(\d+)/.exec(Browser.userAgent);
			if (arr && arr.length>1 && arr[1] < 38){
				Browser.window.setInterval(function(){Laya.stage._loop();},1000/60);
				return;
			}
			Browser.window.requestAnimationFrame(loop);
			function loop (){
				Laya.stage._loop();
				Browser.window.requestAnimationFrame(loop);
			}
			Laya.stage.on("blur",this,this._onBlur);
			Laya.stage.on("focus",this,this._onFocus);
		}

		__class(Render,'laya.renders.Render');
		var __proto=Render.prototype;
		/**@private */
		__proto._onFocus=function(){
			Browser.window.clearInterval(this._timeId);
		}

		/**@private */
		__proto._onBlur=function(){
			this._timeId=Browser.window.setInterval(this._enterFrame,1000);
		}

		/**@private */
		__proto._enterFrame=function(e){
			Laya.stage._loop();
		}

		/**是否是加速器 只读*/
		__getset(1,Render,'isConchApp',function(){
			return (window.ConchRenderType & 0x04)==0x04;
		});

		/**目前使用的渲染器。*/
		__getset(1,Render,'context',function(){
			return Render._context;
		});

		/**加速器模式下设置是否是节点模式 如果是否就是非节点模式 默认为canvas模式 如果设置了isConchWebGL则是webGL模式*/
		__getset(1,Render,'isConchNode',function(){
			return (window.ConchRenderType & 5)==5;
			},function(b){
			if (b){
				window.ConchRenderType |=0x01;
				}else {
				window.ConchRenderType &=~ 0x01;
			}
		});

		/**加速器模式下设置是否是WebGL模式*/
		__getset(1,Render,'isConchWebGL',function(){
			return window.ConchRenderType==6;
			},function(b){
			if (b){
				Render.isConchNode=false;
				window.ConchRenderType |=0x02;
				}else {
				window.ConchRenderType &=~ 0x02;
			}
		});

		/**渲染使用的原生画布引用。 */
		__getset(1,Render,'canvas',function(){
			return Render._mainCanvas.source;
		});

		Render._context=null
		Render._mainCanvas=null
		Render.WebGL=null
		Render.NODE=0x01;
		Render.WEBGL=0x02;
		Render.CONCH=0x04;
		Render.isWebGL=false;
		Render.is3DMode=false;
		Render.optimizeTextureMemory=function(url,texture){
			return true;
		}

		Render.__init$=function(){
			window.ConchRenderType=window.ConchRenderType||1;;
			window.ConchRenderType|=(!window.conch?0:0x04);;;
		}

		return Render;
	})()


	/**
	*@private
	*渲染环境
	*/
	//class laya.renders.RenderContext
	var RenderContext=(function(){
		function RenderContext(width,height,canvas){
			this.x=0;
			this.y=0;
			//this.canvas=null;
			//this.ctx=null;
			this._drawTexture=function(x,y,args){
				if (args[0].loaded)this.ctx.drawTexture(args[0],args[1],args[2],args[3],args[4],x,y);
			}
			this._fillTexture=function(x,y,args){
				if (args[0].loaded)this.ctx.fillTexture(args[0],args[1]+x,args[2]+y,args[3],args[4],args[5],args[6],args[7]);
			}
			this._drawTextureWithTransform=function(x,y,args){
				if (args[0].loaded)this.ctx.drawTextureWithTransform(args[0],args[1],args[2],args[3],args[4],args[5],x,y,args[6]);
			}
			this._fillQuadrangle=function(x,y,args){
				this.ctx.fillQuadrangle(args[0],args[1],args[2],args[3],args[4]);
			}
			this._drawRect=function(x,y,args){
				var ctx=this.ctx;
				if (args[4] !=null){
					ctx.fillStyle=args[4];
					ctx.fillRect(x+args[0],y+args[1],args[2],args[3],null);
				}
				if (args[5] !=null){
					ctx.strokeStyle=args[5];
					ctx.lineWidth=args[6];
					ctx.strokeRect(x+args[0],y+args[1],args[2],args[3],args[6]);
				}
			}
			this._drawPie=function(x,y,args){
				var ctx=this.ctx;
				Render.isWebGL && ctx.setPathId(args[8]);
				ctx.beginPath();
				if (Render.isWebGL){
					ctx.movePath(args[0]+x,args[1]+y);
					ctx.moveTo(0,0);
					}else {
					ctx.moveTo(x+args[0],y+args[1]);
				}
				ctx.arc(x+args[0],y+args[1],args[2],args[3],args[4]);
				ctx.closePath();
				this._fillAndStroke(args[5],args[6],args[7],true);
			}
			this._clipRect=function(x,y,args){
				this.ctx.clipRect(x+args[0],y+args[1],args[2],args[3]);
			}
			this._fillRect=function(x,y,args){
				this.ctx.fillRect(x+args[0],y+args[1],args[2],args[3],args[4]);
			}
			this._drawCircle=function(x,y,args){
				var ctx=this.ctx;
				Render.isWebGL && ctx.setPathId(args[6]);
				Stat.drawCall++;
				ctx.beginPath();
				Render.isWebGL && ctx.movePath(args[0]+x,args[1]+y);
				ctx.arc(args[0]+x,args[1]+y,args[2],0,RenderContext.PI2);
				ctx.closePath();
				this._fillAndStroke(args[3],args[4],args[5],true);
			}
			this._fillCircle=function(x,y,args){
				Stat.drawCall++;
				var ctx=this.ctx;
				ctx.beginPath();
				ctx.fillStyle=args[3];
				ctx.arc(args[0]+x,args[1]+y,args[2],0,RenderContext.PI2);
				ctx.fill();
			}
			this._setShader=function(x,y,args){
				this.ctx.setShader(args[0]);
			}
			this._drawLine=function(x,y,args){
				var ctx=this.ctx;
				Render.isWebGL && ctx.setPathId(args[6]);
				ctx.beginPath();
				ctx.strokeStyle=args[4];
				ctx.lineWidth=args[5];
				if (Render.isWebGL){
					ctx.movePath(x,y);
					ctx.moveTo(args[0],args[1]);
					ctx.lineTo(args[2],args[3]);
					}else {
					ctx.moveTo(x+args[0],y+args[1]);
					ctx.lineTo(x+args[2],y+args[3]);
				}
				ctx.stroke();
			}
			this._drawLines=function(x,y,args){
				var ctx=this.ctx;
				Render.isWebGL && ctx.setPathId(args[5]);
				ctx.beginPath();
				x+=args[0],y+=args[1];
				Render.isWebGL && ctx.movePath(x,y);
				ctx.strokeStyle=args[3];
				ctx.lineWidth=args[4];
				var points=args[2];
				var i=2,n=points.length;
				if (Render.isWebGL){
					ctx.moveTo(points[0],points[1]);
					while (i < n){
						ctx.lineTo(points[i++],points[i++]);
					}
					}else {
					ctx.moveTo(x+points[0],y+points[1]);
					while (i < n){
						ctx.lineTo(x+points[i++],y+points[i++]);
					}
				}
				ctx.stroke();
			}
			this._drawLinesWebGL=function(x,y,args){
				this.ctx.drawLines(x+this.x+args[0],y+this.y+args[1],args[2],args[3],args[4]);
			}
			this._drawCurves=function(x,y,args){
				this.ctx.drawCurves(x,y,args);
			}
			this._draw=function(x,y,args){
				args[0].call(null,this,x,y);
			}
			this._transformByMatrix=function(x,y,args){
				this.ctx.transformByMatrix(args[0]);
			}
			this._setTransform=function(x,y,args){
				this.ctx.setTransform(args[0],args[1],args[2],args[3],args[4],args[5]);
			}
			this._setTransformByMatrix=function(x,y,args){
				this.ctx.setTransformByMatrix(args[0]);
			}
			this._save=function(x,y,args){
				this.ctx.save();
			}
			this._restore=function(x,y,args){
				this.ctx.restore();
			}
			this._translate=function(x,y,args){
				this.ctx.translate(args[0],args[1]);
			}
			this._transform=function(x,y,args){
				this.ctx.translate(args[1]+x,args[2]+y);
				var mat=args[0];
				this.ctx.transform(mat.a,mat.b,mat.c,mat.d,mat.tx,mat.ty);
				this.ctx.translate(-x-args[1],-y-args[2]);
			}
			this._rotate=function(x,y,args){
				this.ctx.translate(args[1]+x,args[2]+y);
				this.ctx.rotate(args[0]);
				this.ctx.translate(-x-args[1],-y-args[2]);
			}
			this._scale=function(x,y,args){
				this.ctx.translate(args[2]+x,args[3]+y);
				this.ctx.scale(args[0],args[1]);
				this.ctx.translate(-x-args[2],-y-args[3]);
			}
			this._alpha=function(x,y,args){
				this.ctx.globalAlpha *=args[0];
			}
			this._setAlpha=function(x,y,args){
				this.ctx.globalAlpha=args[0];
			}
			this._fillText=function(x,y,args){
				this.ctx.fillText(args[0],args[1]+x,args[2]+y,args[3],args[4],args[5]);
			}
			this._strokeText=function(x,y,args){
				this.ctx.strokeText(args[0],args[1]+x,args[2]+y,args[3],args[4],args[5],args[6]);
			}
			this._fillBorderText=function(x,y,args){
				this.ctx.fillBorderText(args[0],args[1]+x,args[2]+y,args[3],args[4],args[5],args[6],args[7]);
			}
			this._blendMode=function(x,y,args){
				this.ctx.globalCompositeOperation=args[0];
			}
			this._beginClip=function(x,y,args){
				this.ctx.beginClip && this.ctx.beginClip(x+args[0],y+args[1],args[2],args[3]);
			}
			this._setIBVB=function(x,y,args){
				this.ctx.setIBVB(args[0]+x,args[1]+y,args[2],args[3],args[4],args[5],args[6],args[7]);
			}
			this._fillTrangles=function(x,y,args){
				this.ctx.fillTrangles(args[0],args[1]+x,args[2]+y,args[3],args[4]);
			}
			this._drawPath=function(x,y,args){
				var ctx=this.ctx;
				Render.isWebGL && ctx.setPathId(-1);
				ctx.beginPath();
				x+=args[0],y+=args[1];
				var paths=args[2];
				for (var i=0,n=paths.length;i < n;i++){
					var path=paths[i];
					switch (path[0]){
						case "moveTo":
							ctx.moveTo(x+path[1],y+path[2]);
							break ;
						case "lineTo":
							ctx.lineTo(x+path[1],y+path[2]);
							break ;
						case "arcTo":
							ctx.arcTo(x+path[1],y+path[2],x+path[3],y+path[4],path[5]);
							break ;
						case "closePath":
							ctx.closePath();
							break ;
						}
				};
				var brush=args[3];
				if (brush !=null){
					ctx.fillStyle=brush.fillStyle;
					ctx.fill();
				};
				var pen=args[4];
				if (pen !=null){
					ctx.strokeStyle=pen.strokeStyle;
					ctx.lineWidth=pen.lineWidth || 1;
					ctx.lineJoin=pen.lineJoin;
					ctx.lineCap=pen.lineCap;
					ctx.miterLimit=pen.miterLimit;
					ctx.stroke();
				}
			}
			this.drawPoly=function(x,y,args){
				this.ctx.drawPoly(x+this.x+args[0],y+this.y+args[1],args[2],args[3],args[4],args[5],args[6]);
			}
			this._drawPoly=function(x,y,args){
				var ctx=this.ctx;
				var points=args[2];
				var i=2,n=points.length;
				if (Render.isWebGL){
					ctx.setPathId(args[6]);
					ctx.beginPath();
					x+=args[0],y+=args[1];
					ctx.movePath(x,y);
					ctx.moveTo(points[0],points[1]);
					while (i < n){
						ctx.lineTo(points[i++],points[i++]);
					}
					}else {
					ctx.beginPath();
					x+=args[0],y+=args[1];
					ctx.moveTo(x+points[0],y+points[1]);
					while (i < n){
						ctx.lineTo(x+points[i++],y+points[i++]);
					}
				}
				ctx.closePath();
				this._fillAndStroke(args[3],args[4],args[5],args[7]);
			}
			this._drawSkin=function(x,y,args){
				var tSprite=args[0];
				if (tSprite){
					var ctx=this.ctx;
					tSprite.render(ctx,x,y);
				}
			}
			this._drawParticle=function(x,y,args){
				this.ctx.drawParticle(x+this.x,y+this.y,args[0]);
			}
			if (canvas){
				this.ctx=canvas.getContext('2d');
				}else {
				canvas=HTMLCanvas.create("3D");
				this.ctx=RunDriver.createWebGLContext2D(canvas);
				canvas._setContext(this.ctx);
			}
			canvas.size(width,height);
			this.canvas=canvas;
		}

		__class(RenderContext,'laya.renders.RenderContext');
		var __proto=RenderContext.prototype;
		/**销毁当前渲染环境*/
		__proto.destroy=function(){
			if (this.canvas){
				this.canvas.destroy();
				this.canvas=null;
			}
			if (this.ctx){
				this.ctx.destroy();
				this.ctx=null;
			}
		}

		__proto.drawTexture=function(tex,x,y,width,height){
			if (tex.loaded)this.ctx.drawTexture(tex,x,y,width,height,this.x,this.y);
		}

		__proto._drawTextures=function(x,y,args){
			if (args[0].loaded)this.ctx.drawTextures(args[0],args[1],x+this.x,y+this.y);
		}

		__proto.drawTextureWithTransform=function(tex,x,y,width,height,m,alpha){
			if (tex.loaded)this.ctx.drawTextureWithTransform(tex,x,y,width,height,m,this.x,this.y,alpha);
		}

		__proto.fillQuadrangle=function(tex,x,y,point4,m){
			this.ctx.fillQuadrangle(tex,x,y,point4,m);
		}

		__proto.drawCanvas=function(canvas,x,y,width,height){
			this.ctx.drawCanvas(canvas,x+this.x,y+this.y,width,height);
		}

		__proto.drawRect=function(x,y,width,height,color,lineWidth){
			(lineWidth===void 0)&& (lineWidth=1);
			var ctx=this.ctx;
			ctx.strokeStyle=color;
			ctx.lineWidth=lineWidth;
			ctx.strokeRect(x+this.x,y+this.y,width,height,lineWidth);
		}

		__proto._fillAndStroke=function(fillColor,strokeColor,lineWidth,isConvexPolygon){
			(isConvexPolygon===void 0)&& (isConvexPolygon=false);
			var ctx=this.ctx;
			if (fillColor !=null){
				ctx.fillStyle=fillColor;
				if (Render.isWebGL){
					ctx.fill(isConvexPolygon);
					}else {
					ctx.fill();
				}
			}
			if (strokeColor !=null && lineWidth > 0){
				ctx.strokeStyle=strokeColor;
				ctx.lineWidth=lineWidth;
				ctx.stroke();
			}
		}

		//ctx.translate(-x-args[0],-y-args[1]);
		__proto.clipRect=function(x,y,width,height){
			this.ctx.clipRect(x+this.x,y+this.y,width,height);
		}

		__proto.fillRect=function(x,y,width,height,fillStyle){
			this.ctx.fillRect(x+this.x,y+this.y,width,height,fillStyle);
		}

		__proto.drawCircle=function(x,y,radius,color,lineWidth){
			(lineWidth===void 0)&& (lineWidth=1);
			Stat.drawCall++;
			var ctx=this.ctx;
			ctx.beginPath();
			ctx.strokeStyle=color;
			ctx.lineWidth=lineWidth;
			ctx.arc(x+this.x,y+this.y,radius,0,RenderContext.PI2);
			ctx.stroke();
		}

		__proto.fillCircle=function(x,y,radius,color){
			Stat.drawCall++;
			var ctx=this.ctx;
			ctx.beginPath();
			ctx.fillStyle=color;
			ctx.arc(x+this.x,y+this.y,radius,0,RenderContext.PI2);
			ctx.fill();
		}

		__proto.setShader=function(shader){
			this.ctx.setShader(shader);
		}

		__proto.drawLine=function(fromX,fromY,toX,toY,color,lineWidth){
			(lineWidth===void 0)&& (lineWidth=1);
			var ctx=this.ctx;
			ctx.beginPath();
			ctx.strokeStyle=color;
			ctx.lineWidth=lineWidth;
			ctx.moveTo(this.x+fromX,this.y+fromY);
			ctx.lineTo(this.x+toX,this.y+toY);
			ctx.stroke();
		}

		__proto.clear=function(){
			this.ctx.clear();
		}

		__proto.transformByMatrix=function(value){
			this.ctx.transformByMatrix(value);
		}

		__proto.setTransform=function(a,b,c,d,tx,ty){
			this.ctx.setTransform(a,b,c,d,tx,ty);
		}

		__proto.setTransformByMatrix=function(value){
			this.ctx.setTransformByMatrix(value);
		}

		__proto.save=function(){
			this.ctx.save();
		}

		__proto.restore=function(){
			this.ctx.restore();
		}

		__proto.translate=function(x,y){
			this.ctx.translate(x,y);
		}

		__proto.transform=function(a,b,c,d,tx,ty){
			this.ctx.transform(a,b,c,d,tx,ty);
		}

		__proto.rotate=function(angle){
			this.ctx.rotate(angle);
		}

		__proto.scale=function(scaleX,scaleY){
			this.ctx.scale(scaleX,scaleY);
		}

		__proto.alpha=function(value){
			this.ctx.globalAlpha *=value;
		}

		__proto.setAlpha=function(value){
			this.ctx.globalAlpha=value;
		}

		__proto.fillWords=function(words,x,y,font,color){
			this.ctx.fillWords(words,x,y,font,color);
		}

		/***@private */
		__proto.fillBorderWords=function(words,x,y,font,fillColor,borderColor,lineWidth){
			this.ctx.fillBorderWords(words,x,y,font,fillColor,borderColor,lineWidth);
		}

		__proto.fillText=function(text,x,y,font,color,textAlign){
			this.ctx.fillText(text,x+this.x,y+this.y,font,color,textAlign);
		}

		__proto.strokeText=function(text,x,y,font,color,lineWidth,textAlign){
			this.ctx.strokeText(text,x+this.x,y+this.y,font,color,lineWidth,textAlign);
		}

		__proto.blendMode=function(type){
			this.ctx.globalCompositeOperation=type;
		}

		__proto.flush=function(){
			this.ctx.flush && this.ctx.flush();
		}

		__proto.addRenderObject=function(o){
			this.ctx.addRenderObject(o);
		}

		__proto.beginClip=function(x,y,w,h){
			this.ctx.beginClip && this.ctx.beginClip(x,y,w,h);
		}

		__proto.endClip=function(){
			this.ctx.endClip && this.ctx.endClip();
		}

		__proto.fillTrangles=function(x,y,args){
			this.ctx.fillTrangles(args[0],args[1],args[2],args[3],args.length > 4 ? args[4] :null);
		}

		RenderContext.PI2=2 *Math.PI;
		return RenderContext;
	})()


	/**
	*@private
	*精灵渲染器
	*/
	//class laya.renders.RenderSprite
	var RenderSprite=(function(){
		function RenderSprite(type,next){
			//this._next=null;
			//this._fun=null;
			this._next=next || RenderSprite.NORENDER;
			switch (type){
				case 0:
					this._fun=this._no;
					return;
				case 0x01:
					this._fun=this._image;
					return;
				case 0x02:
					this._fun=this._alpha;
					return;
				case 0x04:
					this._fun=this._transform;
					return;
				case 0x08:
					this._fun=this._blend;
					return;
				case 0x10:
					this._fun=this._canvas;
					return;
				case 0x40:
					this._fun=this._mask;
					return;
				case 0x80:
					this._fun=this._clip;
					return;
				case 0x100:
					this._fun=this._style;
					return;
				case 0x200:
					this._fun=this._graphics;
					return;
				case 0x800:
					this._fun=this._childs;
					return;
				case 0x400:
					this._fun=this._custom;
					return;
				case 0x01 | 0x200:
					this._fun=this._image2;
					return;
				case 0x01 | 0x04 | 0x200:
					this._fun=this._image2;
					return;
				case 0x20:
					this._fun=Filter._filter;
					return;
				case 0x11111:
					this._fun=RenderSprite._initRenderFun;
					return;
				}
			this.onCreate(type);
		}

		__class(RenderSprite,'laya.renders.RenderSprite');
		var __proto=RenderSprite.prototype;
		__proto.onCreate=function(type){}
		__proto._style=function(sprite,context,x,y){
			sprite._style.render(sprite,context,x,y);
			var next=this._next;
			next._fun.call(next,sprite,context,x,y);
		}

		__proto._no=function(sprite,context,x,y){}
		__proto._custom=function(sprite,context,x,y){
			sprite.customRender(context,x,y);
			var tf=sprite._style._tf;
			this._next._fun.call(this._next,sprite,context,x-tf.translateX,y-tf.translateY);
		}

		__proto._clip=function(sprite,context,x,y){
			var next=this._next;
			if (next==RenderSprite.NORENDER)return;
			var r=sprite._style.scrollRect;
			context.ctx.save();
			context.ctx.clipRect(x,y,r.width,r.height);
			next._fun.call(next,sprite,context,x-r.x,y-r.y);
			context.ctx.restore();
		}

		__proto._blend=function(sprite,context,x,y){
			var style=sprite._style;
			if (style.blendMode){
				context.ctx.globalCompositeOperation=style.blendMode;
			};
			var next=this._next;
			next._fun.call(next,sprite,context,x,y);
			context.ctx.globalCompositeOperation="source-over";
		}

		__proto._mask=function(sprite,context,x,y){
			var next=this._next;
			next._fun.call(next,sprite,context,x,y);
			var mask=sprite.mask;
			if (mask){
				context.ctx.globalCompositeOperation="destination-in";
				if (mask.numChildren > 0 || !mask.graphics._isOnlyOne()){
					mask.cacheAsBitmap=true;
				}
				mask.render(context,x,y);
			}
			context.ctx.globalCompositeOperation="source-over";
		}

		__proto._graphics=function(sprite,context,x,y){
			var tf=sprite._style._tf;
			sprite._graphics && sprite._graphics._render(sprite,context,x-tf.translateX,y-tf.translateY);
			var next=this._next;
			next._fun.call(next,sprite,context,x,y);
		}

		__proto._image=function(sprite,context,x,y){
			var style=sprite._style;
			context.ctx.drawTexture2(x,y,style._tf.translateX,style._tf.translateY,sprite.transform,style.alpha,style.blendMode,sprite._graphics._one);
		}

		__proto._image2=function(sprite,context,x,y){
			var tf=sprite._style._tf;
			context.ctx.drawTexture2(x,y,tf.translateX,tf.translateY,sprite.transform,1,null,sprite._graphics._one);
		}

		__proto._alpha=function(sprite,context,x,y){
			var style=sprite._style;
			var alpha;
			if ((alpha=style.alpha)> 0.01){
				var temp=context.ctx.globalAlpha;
				context.ctx.globalAlpha *=alpha;
				var next=this._next;
				next._fun.call(next,sprite,context,x,y);
				context.ctx.globalAlpha=temp;
			}
		}

		__proto._transform=function(sprite,context,x,y){
			var transform=sprite.transform,_next=this._next;
			if (transform && _next !=RenderSprite.NORENDER){
				context.save();
				context.transform(transform.a,transform.b,transform.c,transform.d,transform.tx+x,transform.ty+y);
				_next._fun.call(_next,sprite,context,0,0);
				context.restore();
			}else
			_next._fun.call(_next,sprite,context,x,y);
		}

		__proto._childs=function(sprite,context,x,y){
			var style=sprite._style;
			x+=-style._tf.translateX+style.paddingLeft;
			y+=-style._tf.translateY+style.paddingTop;
			if (style._calculation){
				var words=sprite._getWords();
				if (words){
					var tStyle=style;
					if (tStyle){
						if (tStyle.stroke){
							context.fillBorderWords(words,x,y,tStyle.font,tStyle.color,tStyle.strokeColor,tStyle.stroke);
							}else{
							context.fillWords(words,x,y,tStyle.font,tStyle.color);
						}
					}
				}
			};
			var childs=sprite._childs,n=childs.length,ele;
			if (sprite.viewport || (sprite.optimizeScrollRect && sprite._style.scrollRect)){
				var rect=sprite.viewport || sprite._style.scrollRect;
				var left=rect.x;
				var top=rect.y;
				var right=rect.right;
				var bottom=rect.bottom;
				var _x=NaN,_y=NaN;
				for (i=0;i < n;++i){
					if ((ele=childs [i]).visible && ((_x=ele._x)< right && (_x+ele.width)> left && (_y=ele._y)< bottom && (_y+ele.height)> top)){
						ele.render(context,x,y);
					}
				}
				}else {
				for (var i=0;i < n;++i)
				(ele=(childs [i]))._style.visible && ele.render(context,x,y);
			}
		}

		__proto._canvas=function(sprite,context,x,y){
			var _cacheCanvas=sprite._$P.cacheCanvas;
			var _next=this._next;
			if (!_cacheCanvas){
				_next._fun.call(_next,sprite,tx,x,y);
				return;
			};
			var tx=_cacheCanvas.ctx;
			var _repaint=sprite._needRepaint()|| (!tx);
			var canvas;
			var left;
			var top;
			var tRec;
			_cacheCanvas.type==='bitmap' ? (Stat.canvasBitmap++):(Stat.canvasNormal++);
			if (_repaint){
				if (!_cacheCanvas._cacheRec)
					_cacheCanvas._cacheRec=new Rectangle();
				var w,h;
				tRec=sprite.getSelfBounds();
				tRec.x-=sprite.pivotX;
				tRec.y-=sprite.pivotY;
				tRec.x-=16;
				tRec.y-=16;
				tRec.width+=32;
				tRec.height+=32;
				tRec.x=Math.floor(tRec.x+x)-x;
				tRec.y=Math.floor(tRec.y+y)-y;
				tRec.width=Math.floor(tRec.width);
				tRec.height=Math.floor(tRec.height);
				_cacheCanvas._cacheRec.copyFrom(tRec);
				tRec=_cacheCanvas._cacheRec;
				var scaleX=Render.isWebGL ? 1 :Browser.pixelRatio *Laya.stage.clientScaleX;
				var scaleY=Render.isWebGL ? 1 :Browser.pixelRatio *Laya.stage.clientScaleY;
				if (!Render.isWebGL){
					var chainScaleX=1;
					var chainScaleY=1;
					var tar;
					tar=sprite;
					while (tar && tar !=Laya.stage){
						chainScaleX *=tar.scaleX;
						chainScaleY *=tar.scaleY;
						tar=tar.parent;
					}
					if (Render.isWebGL){
						if (chainScaleX < 1)scaleX *=chainScaleX;
						if (chainScaleY < 1)scaleY *=chainScaleY;
						}else {
						if (chainScaleX > 1)scaleX *=chainScaleX;
						if (chainScaleY > 1)scaleY *=chainScaleY;
					}
				}
				w=tRec.width *scaleX;
				h=tRec.height *scaleY;
				left=tRec.x;
				top=tRec.y;
				if (Render.isWebGL && _cacheCanvas.type==='bitmap' && (w > 2048 || h > 2048)){
					console.log("cache bitmap size larger than 2048,cache ignored");
					if (_cacheCanvas.ctx){
						Pool.recover("RenderContext",_cacheCanvas.ctx);
						_cacheCanvas.ctx.canvas.size(0,0);
						_cacheCanvas.ctx=null;
					}
					_next._fun.call(_next,sprite,context,x,y);
					return;
				}
				if (!tx){
					tx=_cacheCanvas.ctx=Pool.getItem("RenderContext")|| new RenderContext(w,h,HTMLCanvas.create("AUTO"));
					tx.ctx.sprite=sprite;
				}
				canvas=tx.canvas;
				canvas.clear();
				(canvas.width !=w || canvas.height !=h)&& canvas.size(w,h);
				if (_cacheCanvas.type==='bitmap')canvas.context.asBitmap=true;
				var t;
				if (scaleX !=1 || scaleY !=1){
					var ctx=(tx).ctx;
					ctx.save();
					ctx.scale(scaleX,scaleY);
					if (!Render.isConchWebGL && Render.isConchApp){
						t=sprite._$P.cf;
						t && ctx.setFilterMatrix && ctx.setFilterMatrix(t._mat,t._alpha);
					}
					_next._fun.call(_next,sprite,tx,-left,-top);
					ctx.restore();
					if (!Render.isConchApp || Render.isConchWebGL)sprite._applyFilters();
					}else {
					ctx=(tx).ctx;
					if (!Render.isConchWebGL && Render.isConchApp){
						t=sprite._$P.cf;
						t && ctx.setFilterMatrix && ctx.setFilterMatrix(t._mat,t._alpha);
					}
					_next._fun.call(_next,sprite,tx,-left,-top);
					if (!Render.isConchApp || Render.isConchWebGL)sprite._applyFilters();
				}
				if (sprite._$P.staticCache)_cacheCanvas.reCache=false;
				Stat.canvasReCache++;
				}else {
				tRec=_cacheCanvas._cacheRec;
				left=tRec.x;
				top=tRec.y;
				canvas=tx.canvas;
			}
			context.drawCanvas(canvas,x+left,y+top,tRec.width,tRec.height);
		}

		RenderSprite.__init__=function(){
			var i=0,len=0;
			var initRender;
			initRender=RunDriver.createRenderSprite(0x11111,null);
			len=RenderSprite.renders.length=0x800 *2;
			for (i=0;i < len;i++)
			RenderSprite.renders[i]=initRender;
			RenderSprite.renders[0]=RunDriver.createRenderSprite(0,null);
			function _initSame (value,o){
				var n=0;
				for (var i=0;i < value.length;i++){
					n |=value[i];
					RenderSprite.renders[n]=o;
				}
			}
			_initSame([0x01,0x200,0x04,0x02],new RenderSprite(0x01,null));
			RenderSprite.renders[0x01 | 0x200]=RunDriver.createRenderSprite(0x01 | 0x200,null);
			RenderSprite.renders[0x01 | 0x04 | 0x200]=new RenderSprite(0x01 | 0x04 | 0x200,null);
		}

		RenderSprite._initRenderFun=function(sprite,context,x,y){
			var type=sprite._renderType;
			var r=RenderSprite.renders[type]=RenderSprite._getTypeRender(type);
			r._fun(sprite,context,x,y);
		}

		RenderSprite._getTypeRender=function(type){
			var rst=null;
			var tType=0x800;
			while (tType > 1){
				if (tType & type)
					rst=RunDriver.createRenderSprite(tType,rst);
				tType=tType >> 1;
			}
			return rst;
		}

		RenderSprite.IMAGE=0x01;
		RenderSprite.ALPHA=0x02;
		RenderSprite.TRANSFORM=0x04;
		RenderSprite.BLEND=0x08;
		RenderSprite.CANVAS=0x10;
		RenderSprite.FILTERS=0x20;
		RenderSprite.MASK=0x40;
		RenderSprite.CLIP=0x80;
		RenderSprite.STYLE=0x100;
		RenderSprite.GRAPHICS=0x200;
		RenderSprite.CUSTOM=0x400;
		RenderSprite.CHILDS=0x800;
		RenderSprite.INIT=0x11111;
		RenderSprite.renders=[];
		RenderSprite.NORENDER=new RenderSprite(0,null);
		return RenderSprite;
	})()


	/**
	*@private
	*Context扩展类
	*/
	//class laya.resource.Context
	var Context=(function(){
		function Context(){
			//this._canvas=null;
			this._repaint=false;
		}

		__class(Context,'laya.resource.Context');
		var __proto=Context.prototype;
		__proto.setIsMainContext=function(){}
		__proto.drawTextures=function(tex,pos,tx,ty){
			Stat.drawCall+=pos.length / 2;
			var w=tex.bitmap.width;
			var h=tex.bitmap.height;
			for (var i=0,sz=pos.length;i < sz;i+=2){
				this.drawTexture(tex,pos[i],pos[i+1],w,h,tx,ty);
			}
		}

		/***@private */
		__proto.drawCanvas=function(canvas,x,y,width,height){
			Stat.drawCall++;
			this.drawImage(canvas.source,x,y,width,height);
		}

		/***@private */
		__proto.fillRect=function(x,y,width,height,style){
			Stat.drawCall++;
			style && (this.fillStyle=style);
			this.__fillRect(x,y,width,height);
		}

		/***@private */
		__proto.fillText=function(text,x,y,font,color,textAlign){
			Stat.drawCall++;
			if (arguments.length > 3 && font !=null){
				this.font=font;
				this.fillStyle=color;
				this.textAlign=textAlign;
				this.textBaseline="top";
			}
			this.__fillText(text,x,y);
		}

		/***@private */
		__proto.fillBorderText=function(text,x,y,font,fillColor,borderColor,lineWidth,textAlign){
			Stat.drawCall++;
			this.font=font;
			this.fillStyle=fillColor;
			this.textBaseline="top";
			this.strokeStyle=borderColor;
			this.lineWidth=lineWidth;
			this.textAlign=textAlign;
			this.__strokeText(text,x,y);
			this.__fillText(text,x,y);
		}

		/***@private */
		__proto.strokeText=function(text,x,y,font,color,lineWidth,textAlign){
			Stat.drawCall++;
			if (arguments.length > 3 && font !=null){
				this.font=font;
				this.strokeStyle=color;
				this.lineWidth=lineWidth;
				this.textAlign=textAlign;
				this.textBaseline="top";
			}
			this.__strokeText(text,x,y);
		}

		/***@private */
		__proto.transformByMatrix=function(value){
			this.transform(value.a,value.b,value.c,value.d,value.tx,value.ty);
		}

		/***@private */
		__proto.setTransformByMatrix=function(value){
			this.setTransform(value.a,value.b,value.c,value.d,value.tx,value.ty);
		}

		/***@private */
		__proto.clipRect=function(x,y,width,height){
			Stat.drawCall++;
			this.beginPath();
			this.rect(x,y,width,height);
			this.clip();
		}

		/***@private */
		__proto.drawTexture=function(tex,x,y,width,height,tx,ty){
			Stat.drawCall++;
			var uv=tex.uv,w=tex.bitmap.width,h=tex.bitmap.height;
			this.drawImage(tex.source,uv[0] *w,uv[1] *h,(uv[2]-uv[0])*w,(uv[5]-uv[3])*h,x+tx,y+ty,width,height);
		}

		/***@private */
		__proto.drawTextureWithTransform=function(tex,x,y,width,height,m,tx,ty,alpha){
			Stat.drawCall++;
			var uv=tex.uv,w=tex.bitmap.width,h=tex.bitmap.height;
			this.save();
			alpha !=1 && (this.globalAlpha *=alpha);
			if (m){
				this.transform(m.a,m.b,m.c,m.d,m.tx+tx,m.ty+ty);
				this.drawImage(tex.source,uv[0] *w,uv[1] *h,(uv[2]-uv[0])*w,(uv[5]-uv[3])*h,x ,y,width,height);
				}else {
				this.drawImage(tex.source,uv[0] *w,uv[1] *h,(uv[2]-uv[0])*w,(uv[5]-uv[3])*h,x+tx ,y+ty,width,height);
			}
			this.restore();
		}

		/***@private */
		__proto.drawTexture2=function(x,y,pivotX,pivotY,m,alpha,blendMode,args2){
			'use strict';
			var tex=args2[0];
			if (!(tex.loaded && tex.bitmap && tex.source)){
				return;
			}
			Stat.drawCall++;
			var alphaChanged=alpha!==1;
			if (alphaChanged){
				var temp=this.globalAlpha;
				this.globalAlpha *=alpha;
			};
			var uv=tex.uv,w=tex.bitmap.width,h=tex.bitmap.height;
			if (m){
				this.save();
				this.transform(m.a,m.b,m.c,m.d,m.tx+x,m.ty+y);
				this.drawImage(tex.source,uv[0] *w,uv[1] *h,(uv[2]-uv[0])*w,(uv[5]-uv[3])*h,args2[1]-pivotX ,args2[2]-pivotY,args2[3],args2[4]);
				this.restore();
				}else {
				this.drawImage(tex.source,uv[0] *w,uv[1] *h,(uv[2]-uv[0])*w,(uv[5]-uv[3])*h,args2[1]-pivotX+x ,args2[2]-pivotY+y,args2[3],args2[4]);
			}
			if (alphaChanged)this.globalAlpha=temp;
		}

		__proto.fillTexture=function(texture,x,y,width,height,type,offset,other){
			if (!other.pat){
				if (texture.uv !=Texture.DEF_UV){
					var canvas=new HTMLCanvas("2D");
					canvas.getContext('2d');
					canvas.size(texture.width,texture.height);
					canvas.context.drawTexture(texture,0,0,texture.width,texture.height,0,0);
					texture=new Texture(canvas);
				}
				other.pat=this.createPattern(texture.bitmap.source,type);
			};
			var oX=x,oY=y;
			var sX=0,sY=0;
			if (offset){
				oX+=offset.x % texture.width;
				oY+=offset.y % texture.height;
				sX-=offset.x % texture.width;
				sY-=offset.y % texture.height;
			}
			this.translate(oX,oY);
			this.fillRect(sX,sY,width,height,other.pat);
			this.translate(-oX,-oY);
		}

		/***@private */
		__proto.flush=function(){
			return 0;
		}

		/***@private */
		__proto.fillWords=function(words,x,y,font,color){
			font && (this.font=font);
			color && (this.fillStyle=color);
			var _this=this;
			this.textBaseline="top";
			this.textAlign='left';
			for (var i=0,n=words.length;i < n;i++){
				var a=words[i];
				this.__fillText(a.char,a.x+x,a.y+y);
			}
		}

		/***@private */
		__proto.fillBorderWords=function(words,x,y,font,color,borderColor,lineWidth){
			font && (this.font=font);
			color && (this.fillStyle=color);
			this.textBaseline="top";
			this.lineWidth=lineWidth;
			this.textAlign='left';
			this.strokeStyle=borderColor;
			for (var i=0,n=words.length;i < n;i++){
				var a=words[i];
				this.__strokeText(a.char,a.x+x,a.y+y);
				this.__fillText(a.char,a.x+x,a.y+y);
			}
		}

		/***@private */
		__proto.destroy=function(){
			this.canvas.width=this.canvas.height=0;
		}

		/***@private */
		__proto.clear=function(){
			this.clearRect(0,0,this._canvas.width,this._canvas.height);
			this._repaint=false;
		}

		__proto.drawCurves=function(x,y,args){
			this.beginPath();
			this.strokeStyle=args[3];
			this.lineWidth=args[4];
			var points=args[2];
			x+=args[0],y+=args[1];
			this.moveTo(x+points[0],y+points[1]);
			var i=2,n=points.length;
			while (i < n){
				this.quadraticCurveTo(x+points[i++],y+points[i++],x+points[i++],y+points[i++]);
			}
			this.stroke();
		}

		Context.__init__=function(to){
			var from=laya.resource.Context.prototype;
			to=to || CanvasRenderingContext2D.prototype;
			to.__fillText=to.fillText;
			to.__fillRect=to.fillRect;
			to.__strokeText=to.strokeText;
			var funs=['drawTextures','fillWords','fillBorderWords','setIsMainContext','fillRect','strokeText','fillTexture','fillText','transformByMatrix','setTransformByMatrix','clipRect','drawTexture','drawTexture2','drawTextureWithTransform','flush','clear','destroy','drawCanvas','fillBorderText','drawCurves'];
			funs.forEach(function(i){
				to[i]=from[i] || to[i];
			});
		}

		Context._default=new Context();
		return Context;
	})()


	/**
	*<code>ResourceManager</code> 是资源管理类。它用于资源的载入、获取、销毁。
	*/
	//class laya.resource.ResourceManager
	var ResourceManager=(function(){
		function ResourceManager(){
			this._id=0;
			this._name=null;
			this._resources=null;
			this._memorySize=0;
			this._garbageCollectionRate=NaN;
			this._isOverflow=false;
			this.autoRelease=false;
			this.autoReleaseMaxSize=0;
			this._id=++ResourceManager._uniqueIDCounter;
			this._name="Content Manager";
			ResourceManager._isResourceManagersSorted=false;
			this._memorySize=0;
			this._isOverflow=false;
			this.autoRelease=false;
			this.autoReleaseMaxSize=1024 *1024 *512;
			this._garbageCollectionRate=0.2;
			ResourceManager._resourceManagers.push(this);
			this._resources=[];
		}

		__class(ResourceManager,'laya.resource.ResourceManager');
		var __proto=ResourceManager.prototype;
		Laya.imps(__proto,{"laya.resource.IDispose":true})
		/**
		*获取指定索引的资源 Resource 对象。
		*@param 索引。
		*@return 资源 Resource 对象。
		*/
		__proto.getResourceByIndex=function(index){
			return this._resources[index];
		}

		/**
		*获取此管理器所管理的资源个数。
		*@return 资源个数。
		*/
		__proto.getResourcesLength=function(){
			return this._resources.length;
		}

		/**
		*添加指定资源。
		*@param resource 需要添加的资源 Resource 对象。
		*@return 是否添加成功。
		*/
		__proto.addResource=function(resource){
			if (resource.resourceManager)
				resource.resourceManager.removeResource(resource);
			var index=this._resources.indexOf(resource);
			if (index===-1){
				resource._resourceManager=this;
				this._resources.push(resource);
				this.addSize(resource.memorySize);
				return true;
			}
			return false;
		}

		/**
		*移除指定资源。
		*@param resource 需要移除的资源 Resource 对象
		*@return 是否移除成功。
		*/
		__proto.removeResource=function(resource){
			var index=this._resources.indexOf(resource);
			if (index!==-1){
				this._resources.splice(index,1);
				resource._resourceManager=null;
				this._memorySize-=resource.memorySize;
				return true;
			}
			return false;
		}

		/**
		*卸载此资源管理器载入的资源。
		*/
		__proto.unload=function(){
			var tempResources=this._resources.slice(0,this._resources.length);
			for (var i=0;i < tempResources.length;i++){
				var resource=tempResources[i];
				resource.dispose();
			}
			tempResources.length=0;
		}

		/**
		*设置唯一名字。
		*@param newName 名字，如果名字重复则自动加上“-copy”。
		*/
		__proto.setUniqueName=function(newName){
			var isUnique=true;
			for (var i=0;i < ResourceManager._resourceManagers.length;i++){
				if (ResourceManager._resourceManagers[i]._name!==newName || ResourceManager._resourceManagers[i]===this)
					continue ;
				isUnique=false;
				return;
			}
			if (isUnique){
				if (this.name !=newName){
					this.name=newName;
					ResourceManager._isResourceManagersSorted=false;
				}
				}else{
				this.setUniqueName(newName.concat("-copy"));
			}
		}

		/**释放资源。*/
		__proto.dispose=function(){
			if (this===ResourceManager._systemResourceManager)
				throw new Error("systemResourceManager不能被释放！");
			ResourceManager._resourceManagers.splice(ResourceManager._resourceManagers.indexOf(this),1);
			ResourceManager._isResourceManagersSorted=false;
			var tempResources=this._resources.slice(0,this._resources.length);
			for (var i=0;i < tempResources.length;i++){
				var resource=tempResources[i];
				resource.resourceManager.removeResource(resource);
				resource.dispose();
			}
			tempResources.length=0;
		}

		/**
		*增加内存。
		*@param add 需要增加的内存大小。
		*/
		__proto.addSize=function(add){
			if (add){
				if (this.autoRelease && add > 0)
					((this._memorySize+add)> this.autoReleaseMaxSize)&& (this.garbageCollection((1-this._garbageCollectionRate)*this.autoReleaseMaxSize));
				this._memorySize+=add;
			}
		}

		/**
		*垃圾回收。
		*@param reserveSize 保留尺寸。
		*/
		__proto.garbageCollection=function(reserveSize){
			var all=this._resources;
			all=all.slice();
			all.sort(function(a,b){
				if (!a || !b)
					throw new Error("a或b不能为空！");
				if (a.released && b.released)
					return 0;
				else if (a.released)
				return 1;
				else if (b.released)
				return-1;
				return a.lastUseFrameCount-b.lastUseFrameCount;
			});
			var currentFrameCount=Stat.loopCount;
			for (var i=0,n=all.length;i < n;i++){
				var resou=all[i];
				if (currentFrameCount-resou.lastUseFrameCount > 1){
					resou.releaseResource();
					}else {
					if (this._memorySize >=reserveSize)
						this._isOverflow=true;
					return;
				}
				if (this._memorySize < reserveSize){
					this._isOverflow=false;
					return;
				}
			}
		}

		/**
		*唯一标识 ID 。
		*/
		__getset(0,__proto,'id',function(){
			return this._id;
		});

		/**
		*名字。
		*/
		__getset(0,__proto,'name',function(){
			return this._name;
			},function(value){
			if ((value || value!=="")&& this._name!==value){
				this._name=value;
				ResourceManager._isResourceManagersSorted=false;
			}
		});

		/**
		*此管理器所管理资源的累计内存，以字节为单位。
		*/
		__getset(0,__proto,'memorySize',function(){
			return this._memorySize;
		});

		/**
		*系统资源管理器。
		*/
		__getset(1,ResourceManager,'systemResourceManager',function(){
			(ResourceManager._systemResourceManager===null)&& (ResourceManager._systemResourceManager=new ResourceManager(),ResourceManager._systemResourceManager._name="System Resource Manager");
			return ResourceManager._systemResourceManager;
		});

		/**
		*排序后的资源管理器列表。
		*/
		__getset(1,ResourceManager,'sortedResourceManagersByName',function(){
			if (!ResourceManager._isResourceManagersSorted){
				ResourceManager._isResourceManagersSorted=true;
				ResourceManager._resourceManagers.sort(ResourceManager.compareResourceManagersByName);
			}
			return ResourceManager._resourceManagers;
		});

		ResourceManager.__init__=function(){
			ResourceManager.currentResourceManager=ResourceManager.systemResourceManager;
		}

		ResourceManager.getLoadedResourceManagerByIndex=function(index){
			return ResourceManager._resourceManagers[index];
		}

		ResourceManager.getLoadedResourceManagersCount=function(){
			return ResourceManager._resourceManagers.length;
		}

		ResourceManager.recreateContentManagers=function(force){
			(force===void 0)&& (force=false);
			var temp=ResourceManager.currentResourceManager;
			for (var i=0;i < ResourceManager._resourceManagers.length;i++){
				ResourceManager.currentResourceManager=ResourceManager._resourceManagers[i];
				for (var j=0;j < ResourceManager.currentResourceManager._resources.length;j++){
					ResourceManager.currentResourceManager._resources[j].releaseResource(force);
					ResourceManager.currentResourceManager._resources[j].activeResource(force);
				}
			}
			ResourceManager.currentResourceManager=temp;
		}

		ResourceManager.releaseContentManagers=function(force){
			(force===void 0)&& (force=false);
			var temp=ResourceManager.currentResourceManager;
			for (var i=0;i < ResourceManager._resourceManagers.length;i++){
				ResourceManager.currentResourceManager=ResourceManager._resourceManagers[i];
				for (var j=0;j < ResourceManager.currentResourceManager._resources.length;j++){
					var resource=ResourceManager.currentResourceManager._resources[j];
					(!resource.released)&& (resource.releaseResource(force));
				}
			}
			ResourceManager.currentResourceManager=temp;
		}

		ResourceManager.compareResourceManagersByName=function(left,right){
			if (left==right)
				return 0;
			var x=left._name;
			var y=right._name;
			if (x==null){
				if (y==null)
					return 0;
				else
				return-1;
				}else {
				if (y==null)
					return 1;
				else {
					var retval=x.localeCompare(y);
					if (retval !=0)
						return retval;
					else {
						right.setUniqueName(y);
						y=right._name;
						return x.localeCompare(y);
					}
				}
			}
		}

		ResourceManager._uniqueIDCounter=0;
		ResourceManager._systemResourceManager=null
		ResourceManager._isResourceManagersSorted=false;
		ResourceManager._resourceManagers=[];
		ResourceManager.currentResourceManager=null
		return ResourceManager;
	})()


	/**
	*@private
	*/
	//class laya.resource.WXCanvas
	var WXCanvas=(function(){
		function WXCanvas(id){
			this._ctx=null;
			this._id=null;
			this.style={};
			this._id=id;
		}

		__class(WXCanvas,'laya.resource.WXCanvas');
		var __proto=WXCanvas.prototype;
		__proto.getContext=function(){
			var wx=laya.resource.WXCanvas.wx;
			var ctx=wx.createContext();
			ctx.id=this._id;
			ctx.fillRect=function (x,y,w,h){
				this.rect(x,y,w,h);
				this.fill();
			}
			ctx.strokeRect=function (x,y,w,h){
				this.rect(x,y,w,h);
				this.stroke();
			}
			ctx.___drawImage=ctx.drawImage;
			ctx.drawImage=function (){
				var img=arguments[0].tempFilePath;
				if (img==null)return;
				switch(arguments.length){
					case 3:
						this.___drawImage(img,arguments[1],arguments[2],arguments[0].width,arguments[0].height);
						return;
					case 5:
						this.___drawImage(img,arguments[1],arguments[2],arguments[3],arguments[4]);
						return;
					case 9:
						this.___drawImage(img,arguments[5],arguments[6],arguments[7],arguments[8]);
						return;
					}
			}
			Object.defineProperty(ctx,"strokeStyle",{set:function (value){this.setStrokeStyle(value)},enumerable:false });
			Object.defineProperty(ctx,"fillStyle",{set:function (value){this.setFillStyle(value)},enumerable:false });
			Object.defineProperty(ctx,"fontSize",{set:function (value){this.setFontSize(value)},enumerable:false });
			Object.defineProperty(ctx,"lineWidth",{set:function (value){this.setLineWidth(value)},enumerable:false });
			Context.__init__(ctx);
			ctx.flush=function (){
				wx.drawCanvas({canvasId:this.id,actions:this.getActions()});
			}
			return ctx;
		}

		__proto.oncontextmenu=function(e){}
		__proto.addEventListener=function(){}
		__getset(0,__proto,'id',function(){
			return this._id;
			},function(value){
			this._id=value;
		});

		WXCanvas.wx=null;
		return WXCanvas;
	})()


	SoundManager;
	/**
	*<code>Browser</code> 是浏览器代理类。封装浏览器及原生 js 提供的一些功能。
	*/
	//class laya.utils.Browser
	var Browser=(function(){
		function Browser(){};
		__class(Browser,'laya.utils.Browser');
		/**设备像素比。*/
		__getset(1,Browser,'pixelRatio',function(){
			Browser.__init__();
			return RunDriver.getPixelRatio();
		});

		/**浏览器物理高度。*/
		__getset(1,Browser,'height',function(){
			Browser.__init__();
			return ((Laya.stage && Laya.stage.canvasRotation)? Browser.clientWidth :Browser.clientHeight)*Browser.pixelRatio;
		});

		/**浏览器可视宽度。*/
		__getset(1,Browser,'clientWidth',function(){
			Browser.__init__();
			return Browser.window.innerWidth || Browser.document.body.clientWidth;
		});

		/**浏览器原生 window 对象的引用。*/
		__getset(1,Browser,'window',function(){
			Browser.__init__();
			return Browser._window;
		});

		/**浏览器可视高度。*/
		__getset(1,Browser,'clientHeight',function(){
			Browser.__init__();
			return Browser.window.innerHeight || Browser.document.body.clientHeight || Browser.document.documentElement.clientHeight;
		});

		/**浏览器物理宽度，。*/
		__getset(1,Browser,'width',function(){
			Browser.__init__();
			return ((Laya.stage && Laya.stage.canvasRotation)? Browser.clientHeight :Browser.clientWidth)*Browser.pixelRatio;
		});

		/**画布容器，用来盛放画布的容器。方便对画布进行控制*/
		__getset(1,Browser,'container',function(){
			Browser.__init__();
			if (!Browser._container){
				Browser._container=Browser.createElement("div");
				Browser._container.id="layaContainer";
				Browser.document.body.appendChild(Browser._container);
			}
			return Browser._container;
			},function(value){
			Browser._container=value;
		});

		/**浏览器原生 document 对象的引用。*/
		__getset(1,Browser,'document',function(){
			Browser.__init__();
			return Browser._document;
		});

		Browser.__init__=function(){
			SoundManager;
			if (Browser._window)return;
			Browser._window=RunDriver.getWindow();
			Browser._document=Browser.window.document;
			Browser._window.addEventListener('message',function(e){
				laya.utils.Browser._onMessage(e);
			},false);
			Browser.document.__createElement=Browser.document.createElement;
			window.requestAnimationFrame=window.requestAnimationFrame || window.webkitRequestAnimationFrame || window.mozRequestAnimationFrame || window.oRequestAnimationFrame || window.msRequestAnimationFrame || function (c){return window.setTimeout(c,1000 / 60);};;
			var $BS=window.document.body.style;$BS.margin=0;$BS.overflow='hidden';;
			var metas=window.document.getElementsByTagName('meta');;
			var i=0,flag=false,content='width=device-width,initial-scale=1.0,minimum-scale=1.0,maximum-scale=1.0,user-scalable=no';;
			while(i<metas.length){var meta=metas[i];if(meta.name=='viewport'){meta.content=content;flag=true;break;}i++;};
			if(!flag){meta=document.createElement('meta');meta.name='viewport',meta.content=content;document.getElementsByTagName('head')[0].appendChild(meta);};
			Browser.userAgent=/*[SAFE]*/ Browser.window.navigator.userAgent;
			Browser.u=/*[SAFE]*/ Browser.userAgent;
			Browser.onIOS=/*[SAFE]*/ !!Browser.u.match(/\(i[^;]+;(U;)? CPU.+Mac OS X/);
			Browser.onMobile=/*[SAFE]*/ Browser.u.indexOf("Mobile")>-1;
			Browser.onIPhone=/*[SAFE]*/ Browser.u.indexOf("iPhone")>-1;
			Browser.onIPad=/*[SAFE]*/ Browser.u.indexOf("iPad")>-1;
			Browser.onAndriod=/*[SAFE]*/ Browser.u.indexOf('Android')>-1 || Browser.u.indexOf('Adr')>-1;
			Browser.onWP=/*[SAFE]*/ Browser.u.indexOf("Windows Phone")>-1;
			Browser.onQQBrowser=/*[SAFE]*/ Browser.u.indexOf("QQBrowser")>-1;
			Browser.onMQQBrowser=/*[SAFE]*/ Browser.u.indexOf("MQQBrowser")>-1;
			Browser.onWeiXin=/*[SAFE]*/ Browser.u.indexOf('MicroMessenger')>-1;
			Browser.onPC=/*[SAFE]*/ !Browser.onMobile;
			Browser.onSafari=/*[SAFE]*/ !!Browser.u.match(/Version\/\d+\.\d\x20Mobile\/\S+\x20Safari/);
			Browser.httpProtocol=/*[SAFE]*/ Browser.window.location.protocol=="http:";
			Browser.webAudioEnabled=/*[SAFE]*/ Browser.window["AudioContext"] || Browser.window["webkitAudioContext"] || Browser.window["mozAudioContext"] ? true :false;
			Browser.soundType=/*[SAFE]*/ Browser.webAudioEnabled ? "WEBAUDIOSOUND" :"AUDIOSOUND";
			Sound=Browser.webAudioEnabled?WebAudioSound:AudioSound;;
			if (Browser.webAudioEnabled)WebAudioSound.initWebAudio();;
			Browser.enableTouch=(('ontouchstart' in window)|| window.DocumentTouch && document instanceof DocumentTouch);
			window.focus();
			SoundManager._soundClass=Sound;;
			var MainCanvas=null;
			if (Browser.window.MainCanvasID){
				var _wx=wx;
				if (_wx && !_wx.createContext)_wx=null;
				if ((WXCanvas.wx=_wx)!=null){
					MainCanvas=new WXCanvas(Browser.window.MainCanvasID);
					var from=Context.prototype;
					from.flush=null;
					Browser.window.Image=function (){
						this.setSrc=function (url){
							this.__src=url;
							var _this=this;
							this.success();
						}
						this.success=function (res){
							this.width=200;
							this.height=200;
							this.tempFilePath=res ? res.tempFilePath :this.__src;
							this.onload && this.onload();
						}
						this.getSrc=function (){
							return this.__src;
						}
						Object.defineProperty(this,"src",{get:this.getSrc,set:this.setSrc,enumerable:false });
					}
					}else {
					MainCanvas=Browser.document.getElementById(Browser.window.MainCanvasID);
				}
			}
			Render._mainCanvas=Render._mainCanvas || HTMLCanvas.create('2D',MainCanvas);
			if (Browser.canvas)return;
			Browser.canvas=HTMLCanvas.create('2D');
			Browser.context=Browser.canvas.getContext('2d');
		}

		Browser._onMessage=function(e){
			if (!e.data)return;
			if (e.data.name=="size"){
				Browser.window.innerWidth=e.data.width;
				Browser.window.innerHeight=e.data.height;
				Browser.window.__innerHeight=e.data.clientHeight;
				if (!Browser.document.createEvent){
					console.log("no document.createEvent");
					return;
				};
				var evt=Browser.document.createEvent("HTMLEvents");
				evt.initEvent("resize",false,false);
				Browser.window.dispatchEvent(evt);
				return;
			}
		}

		Browser.createElement=function(type){
			Browser.__init__();
			return Browser.document.__createElement(type);
		}

		Browser.getElementById=function(type){
			Browser.__init__();
			return Browser.document.getElementById(type);
		}

		Browser.removeElement=function(ele){
			if (ele && ele.parentNode)ele.parentNode.removeChild(ele);
		}

		Browser.now=function(){
			return RunDriver.now();
		}

		Browser._window=null
		Browser._document=null
		Browser._container=null
		Browser.userAgent=null
		Browser.u=null
		Browser.onIOS=false;
		Browser.onMobile=false;
		Browser.onIPhone=false;
		Browser.onIPad=false;
		Browser.onAndriod=false;
		Browser.onWP=false;
		Browser.onQQBrowser=false;
		Browser.onMQQBrowser=false;
		Browser.onSafari=false;
		Browser.onWeiXin=false;
		Browser.onPC=false;
		Browser.httpProtocol=false;
		Browser.webAudioEnabled=false;
		Browser.soundType=null
		Browser.enableTouch=false;
		Browser.canvas=null
		Browser.context=null
		Browser.__init$=function(){
			AudioSound;
			WebAudioSound;
		}

		return Browser;
	})()


	/**
	*对象缓存统一管理类
	*/
	//class laya.utils.CacheManger
	var CacheManger=(function(){
		function CacheManger(){}
		__class(CacheManger,'laya.utils.CacheManger');
		CacheManger.regCacheByFunction=function(disposeFunction,getCacheListFunction){
			CacheManger.unRegCacheByFunction(disposeFunction,getCacheListFunction);
			var cache;
			cache={
				tryDispose:disposeFunction,
				getCacheList:getCacheListFunction
			};
			CacheManger._cacheList.push(cache);
		}

		CacheManger.unRegCacheByFunction=function(disposeFunction,getCacheListFunction){
			var i=0,len=0;
			len=CacheManger._cacheList.length;
			for (i=0;i < len;i++){
				if (CacheManger._cacheList[i].tryDispose==disposeFunction && CacheManger._cacheList[i].getCacheList==getCacheListFunction){
					CacheManger._cacheList.splice(i,1);
					return;
				}
			}
		}

		CacheManger.forceDispose=function(){
			var i=0,len=CacheManger._cacheList.length;
			for(i=0;i<len;i++){
				CacheManger._cacheList[i].tryDispose(true);
			}
		}

		CacheManger.beginCheck=function(waitTime){
			(waitTime===void 0)&& (waitTime=15000);
			Laya.timer.loop(waitTime,null,CacheManger._checkLoop);
		}

		CacheManger.stopCheck=function(){
			Laya.timer.clear(null,CacheManger._checkLoop);
		}

		CacheManger._checkLoop=function(){
			var cacheList=CacheManger._cacheList;
			if (cacheList.length < 1)return;
			var tTime=Browser.now();
			var count=0;
			var len=0;
			len=count=cacheList.length;
			while (count > 0){
				CacheManger._index++;
				CacheManger._index=CacheManger._index % len;
				cacheList[CacheManger._index].tryDispose(false);
				if (Browser.now()-tTime > CacheManger.loopTimeLimit)break ;
				count--;
			}
		}

		CacheManger.loopTimeLimit=2;
		CacheManger._cacheList=[];
		CacheManger._index=0;
		return CacheManger;
	})()


	/**
	*<code>ClassUtils</code> 是一个类工具类。
	*/
	//class laya.utils.ClassUtils
	var ClassUtils=(function(){
		function ClassUtils(){};
		__class(ClassUtils,'laya.utils.ClassUtils');
		ClassUtils.regClass=function(className,classDef){
			ClassUtils._classMap[className]=classDef;
		}

		ClassUtils.getRegClass=function(className){
			return ClassUtils._classMap[className];
		}

		ClassUtils.getInstance=function(className){
			var compClass=ClassUtils.getClass(className);
			if (compClass)
				return new compClass();
			else
			console.log("[error] Undefined class:",className);
			return null;
		}

		ClassUtils.createByJson=function(json,node,root,customHandler,instanceHandler){
			if ((typeof json=='string'))
				json=JSON.parse(json);
			var props=json.props;
			if (!node){
				node=instanceHandler ? instanceHandler.runWith(json):ClassUtils.getInstance(props.runtime || json.type);
				if (!node)
					return null;
			};
			var child=json.child;
			if (child){
				for (var i=0,n=child.length;i < n;i++){
					var data=child[i];
					if ((data.props.name==="render" || data.props.renderType==="render")&& node["_$set_itemRender"])
						node.itemRender=data;
					else {
						if (data.type=="Graphic"){
							ClassUtils.addGraphicsToSprite(data,node);
							}else if (ClassUtils.isDrawType(data.type)){
							ClassUtils.addGraphicToSprite(data,node,true);
							}else {
							var tChild=ClassUtils.createByJson(data,null,root,customHandler,instanceHandler)
							if (data.type=="Script"){
								tChild["owner"]=node;
								}else if (data.props.renderType=="mask"){
								node.mask=tChild;
								}else {
								node.addChild(tChild);
							}
						}
					}
				}
			}
			if (props){
				for (var prop in props){
					var value=props[prop];
					if (prop==="var" && root){
						root[value]=node;
						}else if ((value instanceof Array)&& (typeof (node[prop])=='function')){
						node[prop].apply(node,value);
						}else {
						node[prop]=value;
					}
				}
			}
			if (customHandler && json.customProps){
				customHandler.runWith([node,json]);
			}
			if (node["created"])
				node.created();
			return node;
		}

		ClassUtils.addGraphicsToSprite=function(graphicO,sprite){
			var graphics;
			graphics=graphicO.child;
			if (!graphics || graphics.length < 1)
				return;
			var g;
			g=ClassUtils._getGraphicsFromSprite(graphicO,sprite);
			var ox=0;
			var oy=0;
			if (graphicO.props){
				ox=ClassUtils._getObjVar(graphicO.props,"x",0);
				oy=ClassUtils._getObjVar(graphicO.props,"y",0);
			}
			if (ox !=0 && oy !=0){
				g.translate(ox,oy);
			};
			var i=0,len=0;
			len=graphics.length;
			for (i=0;i < len;i++){
				ClassUtils._addGraphicToGraphics(graphics[i],g);
			}
			if (ox !=0 && oy !=0){
				g.translate(-ox,-oy);
			}
		}

		ClassUtils.addGraphicToSprite=function(graphicO,sprite,isChild){
			(isChild===void 0)&& (isChild=false);
			var g;
			g=isChild ? ClassUtils._getGraphicsFromSprite(graphicO,sprite):sprite.graphics;
			ClassUtils._addGraphicToGraphics(graphicO,g);
		}

		ClassUtils._getGraphicsFromSprite=function(dataO,sprite){
			var g;
			if (!dataO || !dataO.props)
				return sprite.graphics;
			var propsName;
			propsName=dataO.props.renderType;
			switch (propsName){
				case "hit":
				case "unHit":;
					var hitArea;
					if (!sprite.hitArea){
						sprite.hitArea=new HitArea();
					}
					hitArea=sprite.hitArea;
					if (!hitArea[propsName]){
						hitArea[propsName]=new Graphics();
					}
					g=hitArea[propsName];
					break ;
				default :
				}
			if (!g)
				g=sprite.graphics;
			return g;
		}

		ClassUtils._getTransformData=function(propsO){
			var m;
			if (propsO.hasOwnProperty("pivotX")|| propsO.hasOwnProperty("pivotY")){
				m=m || new Matrix();
				m.translate(-ClassUtils._getObjVar(propsO,"pivotX",0),-ClassUtils._getObjVar(propsO,"pivotY",0));
			};
			var sx=ClassUtils._getObjVar(propsO,"scaleX",1),sy=ClassUtils._getObjVar(propsO,"scaleY",1);
			var rotate=ClassUtils._getObjVar(propsO,"rotation",0);
			var skewX=ClassUtils._getObjVar(propsO,"skewX",0);
			var skewY=ClassUtils._getObjVar(propsO,"skewY",0);
			if (sx !=1 || sy !=1 || rotate !=0){
				m=m || new Matrix();
				m.scale(sx,sy);
				m.rotate(rotate *0.0174532922222222);
			}
			return m;
		}

		ClassUtils._addGraphicToGraphics=function(graphicO,graphic){
			var propsO;
			propsO=graphicO.props;
			if (!propsO)
				return;
			var drawConfig;
			drawConfig=ClassUtils.DrawTypeDic[graphicO.type];
			if (!drawConfig)
				return;
			var g;
			g=graphic;
			var m;
			var params=ClassUtils._getParams(propsO,drawConfig[1],drawConfig[2],drawConfig[3]);
			m=ClassUtils._tM;
			if (m || ClassUtils._alpha !=1){
				g.save();
				if (m)
					g.transform(m);
				if (ClassUtils._alpha !=1)
					g.alpha(ClassUtils._alpha);
			}
			g[drawConfig[0]].apply(g,params);
			if (m || ClassUtils._alpha !=1){
				g.restore();
			}
		}

		ClassUtils._adptLineData=function(params){
			params[2]=parseFloat(params[0])+parseFloat(params[2]);
			params[3]=parseFloat(params[1])+parseFloat(params[3]);
			return params;
		}

		ClassUtils._adptTextureData=function(params){
			params[0]=Loader.getRes(params[0]);
			return params;
		}

		ClassUtils._adptLinesData=function(params){
			params[2]=ClassUtils._getPointListByStr(params[2]);
			return params;
		}

		ClassUtils.isDrawType=function(type){
			if (type=="Image")
				return false;
			return ClassUtils.DrawTypeDic.hasOwnProperty(type);
		}

		ClassUtils._getParams=function(obj,params,xPos,adptFun){
			(xPos===void 0)&& (xPos=0);
			var rst;
			rst=ClassUtils._temParam;
			rst.length=params.length;
			var i=0,len=0;
			len=params.length;
			for (i=0;i < len;i++){
				rst[i]=ClassUtils._getObjVar(obj,params[i][0],params[i][1]);
			}
			ClassUtils._alpha=ClassUtils._getObjVar(obj,"alpha",1);
			var m;
			m=ClassUtils._getTransformData(obj);
			if (m){
				if (!xPos)xPos=0;
				m.translate(rst[xPos],rst[xPos+1]);
				rst[xPos]=rst[xPos+1]=0;
				ClassUtils._tM=m;
				}else {
				ClassUtils._tM=null;
			}
			if (adptFun && ClassUtils[adptFun]){
				rst=ClassUtils[adptFun](rst);
			}
			return rst;
		}

		ClassUtils._getPointListByStr=function(str){
			var pointArr;
			pointArr=str.split(",");
			var i=0,len=0;
			len=pointArr.length;
			for (i=0;i < len;i++){
				pointArr[i]=parseFloat(pointArr[i]);
			}
			return pointArr;
		}

		ClassUtils._getObjVar=function(obj,key,noValue){
			if (obj.hasOwnProperty(key)){
				return obj[key];
			}
			return noValue;
		}

		ClassUtils._temParam=[];
		ClassUtils._classMap={'Sprite':'laya.display.Sprite','Text':'laya.display.Text','Animation':'laya.display.Animation','Skeleton':'laya.ani.bone.Skeleton','Particle2D':'laya.particle.Particle2D','div':'laya.html.dom.HTMLDivElement','p':'laya.html.dom.HTMLElement','img':'laya.html.dom.HTMLImageElement','span':'laya.html.dom.HTMLElement','br':'laya.html.dom.HTMLBrElement','style':'laya.html.dom.HTMLStyleElement','font':'laya.html.dom.HTMLElement','a':'laya.html.dom.HTMLElement','#text':'laya.html.dom.HTMLElement'};
		ClassUtils.getClass=function(className){
			var classObject=ClassUtils._classMap[className] || className;
			if ((typeof classObject=='string'))
				return Laya["__classmap"][classObject];
			return classObject;
		}

		ClassUtils._tM=null
		ClassUtils._alpha=NaN
		__static(ClassUtils,
		['DrawTypeDic',function(){return this.DrawTypeDic={"Rect":["drawRect",[["x",0],["y",0],["width",0],["height",0],["fillColor",null],["lineColor",null],["lineWidth",1]]],"Circle":["drawCircle",[["x",0],["y",0],["radius",0],["fillColor",null],["lineColor",null],["lineWidth",1]]],"Pie":["drawPie",[["x",0],["y",0],["radius",0],["startAngle",0],["endAngle",0],["fillColor",null],["lineColor",null],["lineWidth",1]]],"Image":["drawTexture",[["x",0],["y",0],["width",0],["height",0]]],"Texture":["drawTexture",[["skin",null],["x",0],["y",0],["width",0],["height",0]],1,"_adptTextureData"],"FillTexture":["fillTexture",[["skin",null],["x",0],["y",0],["width",0],["height",0],["repeat",null]],1,"_adptTextureData"],"FillText":["fillText",[["text",""],["x",0],["y",0],["font",null],["color",null],["textAlign",null]],1],"Line":["drawLine",[["x",0],["y",0],["toX",0],["toY",0],["lineColor",null],["lineWidth",0]],0,"_adptLineData"],"Lines":["drawLines",[["x",0],["y",0],["points",""],["lineColor",null],["lineWidth",0]],0,"_adptLinesData"],"Curves":["drawCurves",[["x",0],["y",0],["points",""],["lineColor",null],["lineWidth",0]],0,"_adptLinesData"],"Poly":["drawPoly",[["x",0],["y",0],["points",""],["fillColor",null],["lineColor",null],["lineWidth",1]],0,"_adptLinesData"]};}
		]);
		return ClassUtils;
	})()


	/**
	*<code>Color</code> 是一个颜色值处理类。
	*/
	//class laya.utils.Color
	var Color=(function(){
		function Color(str){
			this._color=[];
			//this.strColor=null;
			//this.numColor=0;
			//this._drawStyle=null;
			if ((typeof str=='string')){
				this.strColor=str;
				if (str===null)str="#000000";
				str.charAt(0)=='#' && (str=str.substr(1));
				var color=this.numColor=parseInt(str,16);
				var flag=(str.length==8);
				if (flag){
					this._color=[parseInt(str.substr(0,2),16)/ 255,((0x00FF0000 & color)>> 16)/ 255,((0x0000FF00 & color)>> 8)/ 255,(0x000000FF & color)/ 255];
					return;
				}
				}else {
				color=this.numColor=str;
				this.strColor=Utils.toHexColor(color);
			}
			this._color=[((0xFF0000 & color)>> 16)/ 255,((0xFF00 & color)>> 8)/ 255,(0xFF & color)/ 255,1];
			(this._color).__id=++Color._COLODID;
		}

		__class(Color,'laya.utils.Color');
		Color._initDefault=function(){
			Color._DEFAULT={};
			for (var i in Color._COLOR_MAP)Color._SAVE[i]=Color._DEFAULT[i]=new Color(Color._COLOR_MAP[i]);
			return Color._DEFAULT;
		}

		Color._initSaveMap=function(){
			Color._SAVE_SIZE=0;
			Color._SAVE={};
			for (var i in Color._DEFAULT)Color._SAVE[i]=Color._DEFAULT[i];
		}

		Color.create=function(str){
			var color=Color._SAVE[str+""];
			if (color !=null)return color;
			(Color._SAVE_SIZE < 1000)|| Color._initSaveMap();
			return Color._SAVE[str+""]=new Color(str);
		}

		Color._SAVE={};
		Color._SAVE_SIZE=0;
		Color._COLOR_MAP={"white":'#FFFFFF',"red":'#FF0000',"green":'#00FF00',"blue":'#0000FF',"black":'#000000',"yellow":'#FFFF00','gray':'#AAAAAA'};
		Color._DEFAULT=Color._initDefault();
		Color._COLODID=1;
		return Color;
	})()


	/**
	*<code>Dragging</code> 类是触摸滑动控件。
	*/
	//class laya.utils.Dragging
	var Dragging=(function(){
		function Dragging(){
			//this.target=null;
			this.ratio=0.92;
			this.maxOffset=60;
			//this.area=null;
			//this.hasInertia=false;
			//this.elasticDistance=NaN;
			//this.elasticBackTime=NaN;
			//this.data=null;
			this._dragging=false;
			this._clickOnly=true;
			//this._elasticRateX=NaN;
			//this._elasticRateY=NaN;
			//this._lastX=NaN;
			//this._lastY=NaN;
			//this._offsetX=NaN;
			//this._offsetY=NaN;
			//this._offsets=null;
			//this._disableMouseEvent=false;
			//this._tween=null;
			//this._parent=null;
		}

		__class(Dragging,'laya.utils.Dragging');
		var __proto=Dragging.prototype;
		/**
		*开始拖拽。
		*@param target 待拖拽的 <code>Sprite</code> 对象。
		*@param area 滑动范围。
		*@param hasInertia 拖动是否有惯性。
		*@param elasticDistance 橡皮筋最大值。
		*@param elasticBackTime 橡皮筋回弹时间，单位为毫秒。
		*@param data 事件携带数据。
		*@param disableMouseEvent 鼠标事件是否有效。
		*@param ratio 惯性阻尼系数
		*/
		__proto.start=function(target,area,hasInertia,elasticDistance,elasticBackTime,data,disableMouseEvent,ratio){
			(ratio===void 0)&& (ratio=0.92);
			this.clearTimer();
			this.target=target;
			this.area=area;
			this.hasInertia=hasInertia;
			this.elasticDistance=area ? elasticDistance :0;
			this.elasticBackTime=elasticBackTime;
			this.data=data;
			this._disableMouseEvent=disableMouseEvent;
			this.ratio=ratio;
			if (target.globalScaleX !=1 || target.globalScaleY !=1){
				this._parent=target.parent;
				}else {
				this._parent=Laya.stage;
			}
			this._clickOnly=true;
			this._dragging=true;
			this._elasticRateX=this._elasticRateY=1;
			this._lastX=this._parent.mouseX;
			this._lastY=this._parent.mouseY;
			Laya.stage.on("mouseup",this,this.onStageMouseUp);
			Laya.stage.on("mouseout",this,this.onStageMouseUp);
			Laya.timer.frameLoop(1,this,this.loop);
		}

		/**
		*清除计时器。
		*/
		__proto.clearTimer=function(){
			Laya.timer.clear(this,this.loop);
			Laya.timer.clear(this,this.tweenMove);
			if (this._tween){
				this._tween.recover();
				this._tween=null;
			}
		}

		/**
		*停止拖拽。
		*/
		__proto.stop=function(){
			if (this._dragging){
				MouseManager.instance.disableMouseEvent=false;
				Laya.stage.off("mouseup",this,this.onStageMouseUp);
				Laya.stage.off("mouseout",this,this.onStageMouseUp);
				this._dragging=false;
				this.target && this.area && this.backToArea();
				this.clear();
			}
		}

		/**
		*拖拽的循环处理函数。
		*/
		__proto.loop=function(){
			var point=this._parent.getMousePoint();
			var mouseX=point.x;
			var mouseY=point.y;
			var offsetX=mouseX-this._lastX;
			var offsetY=mouseY-this._lastY;
			if (this._clickOnly){
				if (Math.abs(offsetX *Laya.stage._canvasTransform.getScaleX())> 1 || Math.abs(offsetY *Laya.stage._canvasTransform.getScaleY())> 1){
					this._clickOnly=false;
					this._offsets || (this._offsets=[]);
					this._offsets.length=0;
					this.target.event("dragstart",this.data);
					MouseManager.instance.disableMouseEvent=this._disableMouseEvent;
					this.target._set$P("$_MOUSEDOWN",false);
				}else return;
				}else {
				this._offsets.push(offsetX,offsetY);
			}
			if (offsetX===0 && offsetY===0)return;
			this._lastX=mouseX;
			this._lastY=mouseY;
			this.target.x+=offsetX *this._elasticRateX;
			this.target.y+=offsetY *this._elasticRateY;
			this.area && this.checkArea();
			this.target.event("dragmove",this.data);
		}

		/**
		*拖拽区域检测。
		*/
		__proto.checkArea=function(){
			if (this.elasticDistance <=0){
				this.backToArea();
				}else {
				if (this.target.x < this.area.x){
					var offsetX=this.area.x-this.target.x;
					}else if (this.target.x > this.area.x+this.area.width){
					offsetX=this.target.x-this.area.x-this.area.width;
					}else {
					offsetX=0;
				}
				this._elasticRateX=Math.max(0,1-(offsetX / this.elasticDistance));
				if (this.target.y < this.area.y){
					var offsetY=this.area.y-this.target.y;
					}else if (this.target.y > this.area.y+this.area.height){
					offsetY=this.target.y-this.area.y-this.area.height;
					}else {
					offsetY=0;
				}
				this._elasticRateY=Math.max(0,1-(offsetY / this.elasticDistance));
			}
		}

		/**
		*移动至设定的拖拽区域。
		*/
		__proto.backToArea=function(){
			this.target.x=Math.min(Math.max(this.target.x,this.area.x),this.area.x+this.area.width);
			this.target.y=Math.min(Math.max(this.target.y,this.area.y),this.area.y+this.area.height);
		}

		/**
		*舞台的抬起事件侦听函数。
		*@param e Event 对象。
		*/
		__proto.onStageMouseUp=function(e){
			MouseManager.instance.disableMouseEvent=false;
			Laya.stage.off("mouseup",this,this.onStageMouseUp);
			Laya.stage.off("mouseout",this,this.onStageMouseUp);
			Laya.timer.clear(this,this.loop);
			if (this._clickOnly || !this.target)return;
			if (this.hasInertia){
				if (this._offsets.length < 1){
					this._offsets.push(this._parent.mouseX-this._lastX,this._parent.mouseY-this._lastY);
				}
				this._offsetX=this._offsetY=0;
				var len=this._offsets.length;
				var n=Math.min(len,6);
				var m=this._offsets.length-n;
				for (var i=len-1;i > m;i--){
					this._offsetY+=this._offsets[i--];
					this._offsetX+=this._offsets[i];
				}
				this._offsetX=this._offsetX / n *2;
				this._offsetY=this._offsetY / n *2;
				if (Math.abs(this._offsetX)> this.maxOffset)this._offsetX=this._offsetX > 0 ? this.maxOffset :-this.maxOffset;
				if (Math.abs(this._offsetY)> this.maxOffset)this._offsetY=this._offsetY > 0 ? this.maxOffset :-this.maxOffset;
				Laya.timer.frameLoop(1,this,this.tweenMove);
				}else if (this.elasticDistance > 0){
				this.checkElastic();
				}else {
				this.clear();
			}
		}

		/**
		*橡皮筋效果检测。
		*/
		__proto.checkElastic=function(){
			var tx=NaN;
			var ty=NaN;
			if (this.target.x < this.area.x)tx=this.area.x;
			else if (this.target.x > this.area.x+this.area.width)tx=this.area.x+this.area.width;
			if (this.target.y < this.area.y)ty=this.area.y;
			else if (this.target.y > this.area.y+this.area.height)ty=this.area.y+this.area.height;
			if (!isNaN(tx)|| !isNaN(ty)){
				var obj={};
				if (!isNaN(tx))obj.x=tx;
				if (!isNaN(ty))obj.y=ty;
				this._tween=Tween.to(this.target,obj,this.elasticBackTime,Ease.sineOut,Handler.create(this,this.clear),0,false,false);
				}else {
				this.clear();
			}
		}

		/**
		*移动。
		*/
		__proto.tweenMove=function(){
			this._offsetX *=this.ratio *this._elasticRateX;
			this._offsetY *=this.ratio *this._elasticRateY;
			this.target.x+=this._offsetX;
			this.target.y+=this._offsetY;
			this.area && this.checkArea();
			this.target.event("dragmove",this.data);
			if ((Math.abs(this._offsetX)< 1 && Math.abs(this._offsetY)< 1)|| this._elasticRateX < 0.5 || this._elasticRateY < 0.5){
				Laya.timer.clear(this,this.tweenMove);
				if (this.elasticDistance > 0)this.checkElastic();
				else this.clear();
			}
		}

		/**
		*结束拖拽。
		*/
		__proto.clear=function(){
			if (this.target){
				this.clearTimer();
				var sp=this.target;
				this.target=null;
				this._parent=null;
				sp.event("dragend",this.data);
			}
		}

		return Dragging;
	})()


	/**
	*<code>Ease</code> 类定义了缓动函数，以便实现 <code>Tween</code> 动画的缓动效果。
	*/
	//class laya.utils.Ease
	var Ease=(function(){
		function Ease(){};
		__class(Ease,'laya.utils.Ease');
		Ease.linearNone=function(t,b,c,d){
			return c *t / d+b;
		}

		Ease.linearIn=function(t,b,c,d){
			return c *t / d+b;
		}

		Ease.linearInOut=function(t,b,c,d){
			return c *t / d+b;
		}

		Ease.linearOut=function(t,b,c,d){
			return c *t / d+b;
		}

		Ease.bounceIn=function(t,b,c,d){
			return c-Ease.bounceOut(d-t,0,c,d)+b;
		}

		Ease.bounceInOut=function(t,b,c,d){
			if (t < d *0.5)return Ease.bounceIn(t *2,0,c,d)*.5+b;
			else return Ease.bounceOut(t *2-d,0,c,d)*.5+c *.5+b;
		}

		Ease.bounceOut=function(t,b,c,d){
			if ((t /=d)< (1 / 2.75))return c *(7.5625 *t *t)+b;
			else if (t < (2 / 2.75))return c *(7.5625 *(t-=(1.5 / 2.75))*t+.75)+b;
			else if (t < (2.5 / 2.75))return c *(7.5625 *(t-=(2.25 / 2.75))*t+.9375)+b;
			else return c *(7.5625 *(t-=(2.625 / 2.75))*t+.984375)+b;
		}

		Ease.backIn=function(t,b,c,d,s){
			(s===void 0)&& (s=1.70158);
			return c *(t /=d)*t *((s+1)*t-s)+b;
		}

		Ease.backInOut=function(t,b,c,d,s){
			(s===void 0)&& (s=1.70158);
			if ((t /=d *0.5)< 1)return c *0.5 *(t *t *(((s *=(1.525))+1)*t-s))+b;
			return c / 2 *((t-=2)*t *(((s *=(1.525))+1)*t+s)+2)+b;
		}

		Ease.backOut=function(t,b,c,d,s){
			(s===void 0)&& (s=1.70158);
			return c *((t=t / d-1)*t *((s+1)*t+s)+1)+b;
		}

		Ease.elasticIn=function(t,b,c,d,a,p){
			(a===void 0)&& (a=0);
			(p===void 0)&& (p=0);
			var s;
			if (t==0)return b;
			if ((t /=d)==1)return b+c;
			if (!p)p=d *.3;
			if (!a || (c > 0 && a < c)|| (c < 0 && a <-c)){
				a=c;
				s=p / 4;
			}else s=p / Ease.PI2 *Math.asin(c / a);
			return-(a *Math.pow(2,10 *(t-=1))*Math.sin((t *d-s)*Ease.PI2 / p))+b;
		}

		Ease.elasticInOut=function(t,b,c,d,a,p){
			(a===void 0)&& (a=0);
			(p===void 0)&& (p=0);
			var s;
			if (t==0)return b;
			if ((t /=d *0.5)==2)return b+c;
			if (!p)p=d *(.3 *1.5);
			if (!a || (c > 0 && a < c)|| (c < 0 && a <-c)){
				a=c;
				s=p / 4;
			}else s=p / Ease.PI2 *Math.asin(c / a);
			if (t < 1)return-.5 *(a *Math.pow(2,10 *(t-=1))*Math.sin((t *d-s)*Ease.PI2 / p))+b;
			return a *Math.pow(2,-10 *(t-=1))*Math.sin((t *d-s)*Ease.PI2 / p)*.5+c+b;
		}

		Ease.elasticOut=function(t,b,c,d,a,p){
			(a===void 0)&& (a=0);
			(p===void 0)&& (p=0);
			var s;
			if (t==0)return b;
			if ((t /=d)==1)return b+c;
			if (!p)p=d *.3;
			if (!a || (c > 0 && a < c)|| (c < 0 && a <-c)){
				a=c;
				s=p / 4;
			}else s=p / Ease.PI2 *Math.asin(c / a);
			return (a *Math.pow(2,-10 *t)*Math.sin((t *d-s)*Ease.PI2 / p)+c+b);
		}

		Ease.strongIn=function(t,b,c,d){
			return c *(t /=d)*t *t *t *t+b;
		}

		Ease.strongInOut=function(t,b,c,d){
			if ((t /=d *0.5)< 1)return c *0.5 *t *t *t *t *t+b;
			return c *0.5 *((t-=2)*t *t *t *t+2)+b;
		}

		Ease.strongOut=function(t,b,c,d){
			return c *((t=t / d-1)*t *t *t *t+1)+b;
		}

		Ease.sineInOut=function(t,b,c,d){
			return-c *0.5 *(Math.cos(Math.PI *t / d)-1)+b;
		}

		Ease.sineIn=function(t,b,c,d){
			return-c *Math.cos(t / d *Ease.HALF_PI)+c+b;
		}

		Ease.sineOut=function(t,b,c,d){
			return c *Math.sin(t / d *Ease.HALF_PI)+b;
		}

		Ease.quintIn=function(t,b,c,d){
			return c *(t /=d)*t *t *t *t+b;
		}

		Ease.quintInOut=function(t,b,c,d){
			if ((t /=d *0.5)< 1)return c *0.5 *t *t *t *t *t+b;
			return c *0.5 *((t-=2)*t *t *t *t+2)+b;
		}

		Ease.quintOut=function(t,b,c,d){
			return c *((t=t / d-1)*t *t *t *t+1)+b;
		}

		Ease.quartIn=function(t,b,c,d){
			return c *(t /=d)*t *t *t+b;
		}

		Ease.quartInOut=function(t,b,c,d){
			if ((t /=d *0.5)< 1)return c *0.5 *t *t *t *t+b;
			return-c *0.5 *((t-=2)*t *t *t-2)+b;
		}

		Ease.quartOut=function(t,b,c,d){
			return-c *((t=t / d-1)*t *t *t-1)+b;
		}

		Ease.cubicIn=function(t,b,c,d){
			return c *(t /=d)*t *t+b;
		}

		Ease.cubicInOut=function(t,b,c,d){
			if ((t /=d *0.5)< 1)return c *0.5 *t *t *t+b;
			return c *0.5 *((t-=2)*t *t+2)+b;
		}

		Ease.cubicOut=function(t,b,c,d){
			return c *((t=t / d-1)*t *t+1)+b;
		}

		Ease.quadIn=function(t,b,c,d){
			return c *(t /=d)*t+b;
		}

		Ease.quadInOut=function(t,b,c,d){
			if ((t /=d *0.5)< 1)return c *0.5 *t *t+b;
			return-c *0.5 *((--t)*(t-2)-1)+b;
		}

		Ease.quadOut=function(t,b,c,d){
			return-c *(t /=d)*(t-2)+b;
		}

		Ease.expoIn=function(t,b,c,d){
			return (t==0)? b :c *Math.pow(2,10 *(t / d-1))+b-c *0.001;
		}

		Ease.expoInOut=function(t,b,c,d){
			if (t==0)return b;
			if (t==d)return b+c;
			if ((t /=d *0.5)< 1)return c *0.5 *Math.pow(2,10 *(t-1))+b;
			return c *0.5 *(-Math.pow(2,-10 *--t)+2)+b;
		}

		Ease.expoOut=function(t,b,c,d){
			return (t==d)? b+c :c *(-Math.pow(2,-10 *t / d)+1)+b;
		}

		Ease.circIn=function(t,b,c,d){
			return-c *(Math.sqrt(1-(t /=d)*t)-1)+b;
		}

		Ease.circInOut=function(t,b,c,d){
			if ((t /=d *0.5)< 1)return-c *0.5 *(Math.sqrt(1-t *t)-1)+b;
			return c *0.5 *(Math.sqrt(1-(t-=2)*t)+1)+b;
		}

		Ease.circOut=function(t,b,c,d){
			return c *Math.sqrt(1-(t=t / d-1)*t)+b;
		}

		Ease.HALF_PI=Math.PI *0.5;
		Ease.PI2=Math.PI *2;
		return Ease;
	})()


	/**
	*鼠标点击区域，可以设置绘制一系列矢量图作为点击区域和非点击区域（目前只支持圆形，矩形，多边形）
	*/
	//class laya.utils.HitArea
	var HitArea=(function(){
		function HitArea(){
			this._hit=null;
			this._unHit=null;
		}

		__class(HitArea,'laya.utils.HitArea');
		var __proto=HitArea.prototype;
		/**
		*是否包含某个点
		*@param x x坐标
		*@param y y坐标
		*@return 是否点击到
		*/
		__proto.isHit=function(x,y){
			if (!HitArea.isHitGraphic(x,y,this.hit))return false;
			return !HitArea.isHitGraphic(x,y,this.unHit);
		}

		/**
		*检测对象是否包含指定的点。
		*@param x 点的 X 轴坐标值（水平位置）。
		*@param y 点的 Y 轴坐标值（垂直位置）。
		*@return 如果包含指定的点，则值为 true；否则为 false。
		*/
		__proto.contains=function(x,y){
			return this.isHit(x,y);
		}

		/**
		*可点击区域，可以设置绘制一系列矢量图作为点击区域（目前只支持圆形，矩形，多边形）
		*/
		__getset(0,__proto,'hit',function(){
			if (!this._hit)this._hit=new Graphics();
			return this._hit;
			},function(value){
			this._hit=value;
		});

		/**
		*不可点击区域，可以设置绘制一系列矢量图作为非点击区域（目前只支持圆形，矩形，多边形）
		*/
		__getset(0,__proto,'unHit',function(){
			if (!this._unHit)this._unHit=new Graphics();
			return this._unHit;
			},function(value){
			this._unHit=value;
		});

		HitArea.isHitGraphic=function(x,y,graphic){
			if (!graphic)return false;
			var cmds;
			cmds=graphic.cmds;
			if (!cmds && graphic._one){
				cmds=HitArea._cmds;
				cmds.length=1;
				cmds[0]=graphic._one;
			}
			if (!cmds)return false;
			var i=0,len=0;
			len=cmds.length;
			var cmd;
			for (i=0;i < len;i++){
				cmd=cmds[i];
				if (!cmd)continue ;
				var context=Render._context;
				switch (cmd.callee){
					case context._translate:
					case 6:
						x-=cmd[0];
						y-=cmd[1];
					default :
					}
				if (HitArea.isHitCmd(x,y,cmd))return true;
			}
			return false;
		}

		HitArea.isHitCmd=function(x,y,cmd){
			if (!cmd)return false;
			var context=Render._context;
			var rst=false;
			switch (cmd["callee"]){
				case context._drawRect:
				case 13:
					HitArea._rec.setTo(cmd[0],cmd[1],cmd[2],cmd[3]);
					rst=HitArea._rec.contains(x,y);
					break ;
				case context._drawCircle:
				case context._fillCircle:
				case 14:;
					var d=NaN;
					x-=cmd[0];
					y-=cmd[1];
					d=x *x+y *y;
					rst=d < cmd[2] *cmd[2];
					break ;
				case context._drawPoly:
				case 18:
					x-=cmd[0];
					y-=cmd[1];
					rst=HitArea.ptInPolygon(x,y,cmd[2]);
					break ;
				default :
					break ;
				}
			return rst;
		}

		HitArea.ptInPolygon=function(x,y,areaPoints){
			var p;
			p=HitArea._ptPoint;
			p.setTo(x,y);
			var nCross=0;
			var p1x=NaN,p1y=NaN,p2x=NaN,p2y=NaN;
			var len=0;
			len=areaPoints.length;
			for (var i=0;i < len;i+=2){
				p1x=areaPoints[i];
				p1y=areaPoints[i+1];
				p2x=areaPoints[(i+2)% len];
				p2y=areaPoints[(i+3)% len];
				if (p1y==p2y)
					continue ;
				if (p.y < Math.min(p1y,p2y))
					continue ;
				if (p.y >=Math.max(p1y,p2y))
					continue ;
				var tx=(p.y-p1y)*(p2x-p1x)/ (p2y-p1y)+p1x;
				if (tx > p.x){
					nCross++;
				}
			}
			return (nCross % 2==1);
		}

		HitArea._cmds=[];
		__static(HitArea,
		['_rec',function(){return this._rec=new Rectangle();},'_ptPoint',function(){return this._ptPoint=new Point();}
		]);
		return HitArea;
	})()


	/**
	*<code>HTMLChar</code> 是一个 HTML 字符类。
	*/
	//class laya.utils.HTMLChar
	var HTMLChar=(function(){
		function HTMLChar(char,w,h,style){
			//this._sprite=null;
			//this._x=NaN;
			//this._y=NaN;
			//this._w=NaN;
			//this._h=NaN;
			//this.isWord=false;
			//this.char=null;
			//this.charNum=NaN;
			//this.style=null;
			this.char=char;
			this.charNum=char.charCodeAt(0);
			this._x=this._y=0;
			this.width=w;
			this.height=h;
			this.style=style;
			this.isWord=!HTMLChar._isWordRegExp.test(char);
		}

		__class(HTMLChar,'laya.utils.HTMLChar');
		var __proto=HTMLChar.prototype;
		Laya.imps(__proto,{"laya.display.ILayout":true})
		/**
		*设置与此对象绑定的显示对象 <code>Sprite</code> 。
		*@param sprite 显示对象 <code>Sprite</code> 。
		*/
		__proto.setSprite=function(sprite){
			this._sprite=sprite;
		}

		/**
		*获取与此对象绑定的显示对象 <code>Sprite</code>。
		*@return
		*/
		__proto.getSprite=function(){
			return this._sprite;
		}

		/**@private */
		__proto._isChar=function(){
			return true;
		}

		/**@private */
		__proto._getCSSStyle=function(){
			return this.style;
		}

		/**
		*宽度。
		*/
		__getset(0,__proto,'width',function(){
			return this._w;
			},function(value){
			this._w=value;
		});

		/**
		*此对象存储的 X 轴坐标值。
		*当设置此值时，如果此对象有绑定的 Sprite 对象，则改变 Sprite 对象的属性 x 的值。
		*/
		__getset(0,__proto,'x',function(){
			return this._x;
			},function(value){
			if (this._sprite){
				this._sprite.x=value;
			}
			this._x=value;
		});

		/**
		*此对象存储的 Y 轴坐标值。
		*当设置此值时，如果此对象有绑定的 Sprite 对象，则改变 Sprite 对象的属性 y 的值。
		*/
		__getset(0,__proto,'y',function(){
			return this._y;
			},function(value){
			if (this._sprite){
				this._sprite.y=value;
			}
			this._y=value;
		});

		/**
		*高度。
		*/
		__getset(0,__proto,'height',function(){
			return this._h;
			},function(value){
			this._h=value;
		});

		HTMLChar._isWordRegExp=new RegExp("[\\w\.]","");
		return HTMLChar;
	})()


	/**
	*<code>Pool</code> 是对象池类，用于对象的存贮、重复使用。
	*/
	//class laya.utils.Pool
	var Pool=(function(){
		function Pool(){};
		__class(Pool,'laya.utils.Pool');
		Pool.getPoolBySign=function(sign){
			return Pool._poolDic[sign] || (Pool._poolDic[sign]=[]);
		}

		Pool.clearBySign=function(sign){
			if (Pool._poolDic[sign])Pool._poolDic[sign].length=0;
		}

		Pool.recover=function(sign,item){
			if (item["__InPool"])return;
			item["__InPool"]=true;
			Pool.getPoolBySign(sign).push(item);
		}

		Pool.getItemByClass=function(sign,cls){
			var pool=Pool.getPoolBySign(sign);
			var rst=pool.length ? pool.pop():new cls();
			rst["__InPool"]=false;
			return rst;
		}

		Pool.getItemByCreateFun=function(sign,createFun){
			var pool=Pool.getPoolBySign(sign);
			var rst=pool.length ? pool.pop():createFun();
			rst["__InPool"]=false;
			return rst;
		}

		Pool.getItem=function(sign){
			var pool=Pool.getPoolBySign(sign);
			var rst=pool.length ? pool.pop():null;
			if (rst){
				rst["__InPool"]=false;
			}
			return rst;
		}

		Pool._poolDic={};
		Pool.InPoolSign="__InPool";
		return Pool;
	})()


	/**
	*<code>Stat</code> 用于显示帧率统计信息。
	*/
	//class laya.utils.Stat
	var Stat=(function(){
		function Stat(){};
		__class(Stat,'laya.utils.Stat');
		/**
		*点击帧频显示区域的处理函数。
		*/
		__getset(1,Stat,'onclick',null,function(fn){
			Stat._canvas.source.onclick=fn;
			Stat._canvas.source.style.pointerEvents='';
		});

		Stat.show=function(x,y){
			(x===void 0)&& (x=0);
			(y===void 0)&& (y=0);
			if (Render.isConchApp){
				conch.showFPS&&conch.showFPS(x,y);
				return;
			};
			var pixel=Browser.pixelRatio;
			Stat._width=pixel *130;
			Stat._vx=pixel *75;
			Stat._view[0]={title:"FPS(Canvas)",value:"_fpsStr",color:"yellow",units:"int"};
			Stat._view[1]={title:"Sprite",value:"spriteCount",color:"white",units:"int"};
			Stat._view[2]={title:"DrawCall",value:"drawCall",color:"white",units:"int"};
			Stat._view[3]={title:"CurMem",value:"currentMemorySize",color:"yellow",units:"M"};
			if (Render.isWebGL){
				Stat._view[4]={title:"Shader",value:"shaderCall",color:"white",units:"int"};
				if (!Render.is3DMode){
					Stat._view[0].title="FPS(WebGL)";
					Stat._view[5]={title:"Canvas",value:"_canvasStr",color:"white",units:"int"};
					}else {
					Stat._view[0].title="FPS(3D)";
					Stat._view[5]={title:"TriFaces",value:"trianglesFaces",color:"white",units:"int"};
				}
				}else {
				Stat._view[4]={title:"Canvas",value:"_canvasStr",color:"white",units:"int"};
			}
			Stat._fontSize=12 *pixel;
			for (var i=0;i < Stat._view.length;i++){
				Stat._view[i].x=4;
				Stat._view[i].y=i *Stat._fontSize+2 *pixel;
			}
			Stat._height=pixel *(Stat._view.length *12+3 *pixel);
			if (!Stat._canvas){
				Stat._canvas=new HTMLCanvas('2D');
				Stat._canvas.size(Stat._width,Stat._height);
				Stat._ctx=Stat._canvas.getContext('2d');
				Stat._ctx.textBaseline="top";
				Stat._ctx.font=Stat._fontSize+"px Sans-serif";
				Stat._canvas.source.style.cssText="pointer-events:none;background:rgba(150,150,150,0.8);z-index:100000;position: absolute;left:"+x+"px;top:"+y+"px;width:"+(Stat._width / pixel)+"px;height:"+(Stat._height / pixel)+"px;";
			}
			Stat._first=true;
			Stat.loop();
			Stat._first=false;
			Browser.container.appendChild(Stat._canvas.source);
			Stat.enable();
		}

		Stat.enable=function(){
			Laya.timer.frameLoop(1,Stat,Stat.loop);
		}

		Stat.hide=function(){
			Browser.removeElement(Stat._canvas.source);
			Laya.timer.clear(Stat,Stat.loop);
		}

		Stat.clear=function(){
			Stat.trianglesFaces=Stat.drawCall=Stat.shaderCall=Stat.spriteCount=Stat.canvasNormal=Stat.canvasBitmap=Stat.canvasReCache=0;
		}

		Stat.loop=function(){
			Stat._count++;
			var timer=Browser.now();
			if (timer-Stat._timer < 1000)return;
			var count=Stat._count;
			Stat.FPS=Math.round((count *1000)/ (timer-Stat._timer));
			if (Stat._canvas){
				Stat.trianglesFaces=Math.round(Stat.trianglesFaces / count);
				Stat.drawCall=Math.round(Stat.drawCall / count)-2;
				Stat.shaderCall=Math.round(Stat.shaderCall / count);
				Stat.spriteCount=Math.round(Stat.spriteCount / count)-1;
				Stat.canvasNormal=Math.round(Stat.canvasNormal / count);
				Stat.canvasBitmap=Math.round(Stat.canvasBitmap / count);
				Stat.canvasReCache=Math.ceil(Stat.canvasReCache / count);
				Stat._fpsStr=Stat.FPS+(Stat.renderSlow ? " slow" :"");
				Stat._canvasStr=Stat.canvasReCache+"/"+Stat.canvasNormal+"/"+Stat.canvasBitmap;
				Stat.currentMemorySize=ResourceManager.systemResourceManager.memorySize;
				var ctx=Stat._ctx;
				ctx.clearRect(Stat._first ? 0 :Stat._vx,0,Stat._width,Stat._height);
				for (var i=0;i < Stat._view.length;i++){
					var one=Stat._view[i];
					if (Stat._first){
						ctx.fillStyle="white";
						ctx.fillText(one.title,one.x,one.y,null,null,null);
					}
					ctx.fillStyle=one.color;
					var value=Stat[one.value];
					(one.units=="M")&& (value=Math.floor(value / (1024 *1024)*100)/ 100+" M");
					ctx.fillText(value+"",one.x+Stat._vx,one.y,null,null,null);
				}
				Stat.clear();
			}
			Stat._count=0;
			Stat._timer=timer;
		}

		Stat.loopCount=0;
		Stat.shaderCall=0;
		Stat.drawCall=0;
		Stat.trianglesFaces=0;
		Stat.spriteCount=0;
		Stat.FPS=0;
		Stat.canvasNormal=0;
		Stat.canvasBitmap=0;
		Stat.canvasReCache=0;
		Stat.renderSlow=false;
		Stat.currentMemorySize=0;
		Stat._fpsStr=null
		Stat._canvasStr=null
		Stat._canvas=null
		Stat._ctx=null
		Stat._timer=0;
		Stat._count=0;
		Stat._width=130;
		Stat._height=100;
		Stat._view=[];
		Stat._fontSize=12;
		Stat._first=false;
		Stat._vx=NaN
		return Stat;
	})()


	/**
	*<code>Timer</code> 是时钟管理类。它是一个单例，可以通过 Laya.timer 访问。
	*/
	//class laya.utils.Timer
	var Timer=(function(){
		var TimerHandler;
		function Timer(){
			this._delta=0;
			this.scale=1;
			this.currFrame=0;
			this._mid=1;
			this._map=[];
			this._laters=[];
			this._handlers=[];
			this._temp=[];
			this._count=0;
			this.currTimer=Browser.now();
			this._lastTimer=Browser.now();
			Laya.timer && Laya.timer.frameLoop(1,this,this._update);
		}

		__class(Timer,'laya.utils.Timer');
		var __proto=Timer.prototype;
		/**
		*@private
		*帧循环处理函数。
		*/
		__proto._update=function(){
			if (this.scale <=0){
				this._lastTimer=Browser.now();
				return;
			};
			var frame=this.currFrame=this.currFrame+this.scale;
			var now=Browser.now();
			this._delta=(now-this._lastTimer)*this.scale;
			var timer=this.currTimer=this.currTimer+this._delta;
			this._lastTimer=now;
			var handlers=this._handlers;
			this._count=0;
			for (i=0,n=handlers.length;i < n;i++){
				handler=handlers[i];
				if (handler.method!==null){
					var t=handler.userFrame ? frame :timer;
					if (t >=handler.exeTime){
						if (handler.repeat){
							if (t > handler.exeTime){
								handler.exeTime+=handler.delay;
								handler.run(false);
								if (t > handler.exeTime){
									handler.exeTime+=Math.ceil((t-handler.exeTime)/ handler.delay)*handler.delay;
								}
							}
							}else {
							handler.run(true);
						}
					}
					}else {
					this._count++;
				}
			}
			if (this._count > 30 || frame % 200===0)this._clearHandlers();
			var laters=this._laters;
			for (var i=0,n=laters.length-1;i <=n;i++){
				var handler=laters[i];
				handler.method!==null && handler.run(false);
				this._recoverHandler(handler);
				i===n && (n=laters.length-1);
			}
			laters.length=0;
		}

		/**@private */
		__proto._clearHandlers=function(){
			var handlers=this._handlers;
			for (var i=0,n=handlers.length;i < n;i++){
				var handler=handlers[i];
				if (handler.method!==null)this._temp.push(handler);
				else this._recoverHandler(handler);
			}
			this._handlers=this._temp;
			this._temp=handlers;
			this._temp.length=0;
		}

		/**@private */
		__proto._recoverHandler=function(handler){
			this._map[handler.key]=null;
			handler.clear();
			Timer._pool.push(handler);
		}

		/**@private */
		__proto._create=function(useFrame,repeat,delay,caller,method,args,coverBefore){
			if (!delay){
				method.apply(caller,args);
				return;
			}
			if (coverBefore){
				var handler=this._getHandler(caller,method);
				if (handler){
					handler.repeat=repeat;
					handler.userFrame=useFrame;
					handler.delay=delay;
					handler.caller=caller;
					handler.method=method;
					handler.args=args;
					handler.exeTime=delay+(useFrame ? this.currFrame :this.currTimer);
					return;
				}
			}
			handler=Timer._pool.length > 0 ? Timer._pool.pop():new TimerHandler();
			handler.repeat=repeat;
			handler.userFrame=useFrame;
			handler.delay=delay;
			handler.caller=caller;
			handler.method=method;
			handler.args=args;
			handler.exeTime=delay+(useFrame ? this.currFrame :this.currTimer);
			this._indexHandler(handler);
			this._handlers.push(handler);
		}

		/**@private */
		__proto._indexHandler=function(handler){
			var caller=handler.caller;
			var method=handler.method;
			var cid=caller ? caller.$_GID || (caller.$_GID=Utils.getGID()):0;
			var mid=method.$_TID || (method.$_TID=(this._mid++)*100000);
			handler.key=cid+mid;
			this._map[handler.key]=handler;
		}

		/**
		*定时执行一次。
		*@param delay 延迟时间(单位为毫秒)。
		*@param caller 执行域(this)。
		*@param method 定时器回调函数。
		*@param args 回调参数。
		*@param coverBefore 是否覆盖之前的延迟执行，默认为 true 。
		*/
		__proto.once=function(delay,caller,method,args,coverBefore){
			(coverBefore===void 0)&& (coverBefore=true);
			this._create(false,false,delay,caller,method,args,coverBefore);
		}

		/**
		*定时重复执行。
		*@param delay 间隔时间(单位毫秒)。
		*@param caller 执行域(this)。
		*@param method 定时器回调函数。
		*@param args 回调参数。
		*@param coverBefore 是否覆盖之前的延迟执行，默认为 true 。
		*/
		__proto.loop=function(delay,caller,method,args,coverBefore){
			(coverBefore===void 0)&& (coverBefore=true);
			this._create(false,true,delay,caller,method,args,coverBefore);
		}

		/**
		*定时执行一次(基于帧率)。
		*@param delay 延迟几帧(单位为帧)。
		*@param caller 执行域(this)。
		*@param method 定时器回调函数。
		*@param args 回调参数。
		*@param coverBefore 是否覆盖之前的延迟执行，默认为 true 。
		*/
		__proto.frameOnce=function(delay,caller,method,args,coverBefore){
			(coverBefore===void 0)&& (coverBefore=true);
			this._create(true,false,delay,caller,method,args,coverBefore);
		}

		/**
		*定时重复执行(基于帧率)。
		*@param delay 间隔几帧(单位为帧)。
		*@param caller 执行域(this)。
		*@param method 定时器回调函数。
		*@param args 回调参数。
		*@param coverBefore 是否覆盖之前的延迟执行，默认为 true 。
		*/
		__proto.frameLoop=function(delay,caller,method,args,coverBefore){
			(coverBefore===void 0)&& (coverBefore=true);
			this._create(true,true,delay,caller,method,args,coverBefore);
		}

		/**返回统计信息。*/
		__proto.toString=function(){
			return "callLater:"+this._laters.length+" handlers:"+this._handlers.length+" pool:"+Timer._pool.length;
		}

		/**
		*清理定时器。
		*@param caller 执行域(this)。
		*@param method 定时器回调函数。
		*/
		__proto.clear=function(caller,method){
			var handler=this._getHandler(caller,method);
			if (handler){
				this._map[handler.key]=null;handler.key=0;
				handler.clear();
			}
		}

		/**
		*清理对象身上的所有定时器。
		*@param caller 执行域(this)。
		*/
		__proto.clearAll=function(caller){
			if (!caller)return;
			for (var i=0,n=this._handlers.length;i < n;i++){
				var handler=this._handlers[i];
				if (handler.caller===caller){
					this._map[handler.key]=null;handler.key=0;
					handler.clear();
				}
			}
		}

		/**@private */
		__proto._getHandler=function(caller,method){
			var cid=caller ? caller.$_GID || (caller.$_GID=Utils.getGID()):0;
			var mid=method.$_TID || (method.$_TID=(this._mid++)*100000);
			return this._map[cid+mid];
		}

		/**
		*延迟执行。
		*@param caller 执行域(this)。
		*@param method 定时器回调函数。
		*@param args 回调参数。
		*/
		__proto.callLater=function(caller,method,args){
			if (this._getHandler(caller,method)==null){
				if (Timer._pool.length)
					var handler=Timer._pool.pop();
				else handler=new TimerHandler();
				handler.caller=caller;
				handler.method=method;
				handler.args=args;
				this._indexHandler(handler);
				this._laters.push(handler);
			}
		}

		/**
		*立即执行 callLater 。
		*@param caller 执行域(this)。
		*@param method 定时器回调函数。
		*/
		__proto.runCallLater=function(caller,method){
			var handler=this._getHandler(caller,method);
			if (handler && handler.method !=null){
				this._map[handler.key]=null;
				handler.run(true);
			}
		}

		/**
		*两帧之间的时间间隔,单位毫秒。
		*/
		__getset(0,__proto,'delta',function(){
			return this._delta;
		});

		Timer._pool=[];
		Timer.__init$=function(){
			/**@private */
			//class TimerHandler
			TimerHandler=(function(){
				function TimerHandler(){
					this.key=0;
					this.repeat=false;
					this.delay=0;
					this.userFrame=false;
					this.exeTime=0;
					this.caller=null;
					this.method=null;
					this.args=null;
				}
				__class(TimerHandler,'');
				var __proto=TimerHandler.prototype;
				__proto.clear=function(){
					this.caller=null;
					this.method=null;
					this.args=null;
				}
				__proto.run=function(widthClear){
					var caller=this.caller;
					if (caller && caller.destroyed)return this.clear();
					var method=this.method;
					var args=this.args;
					widthClear && this.clear();
					if (method==null)return;
					args ? method.apply(caller,args):method.call(caller);
				}
				return TimerHandler;
			})()
		}

		return Timer;
	})()


	/**
	*<code>Tween</code> 是一个缓动类。使用实现目标对象属性的渐变。
	*/
	//class laya.utils.Tween
	var Tween=(function(){
		function Tween(){
			//this._complete=null;
			//this._target=null;
			//this._ease=null;
			//this._props=null;
			//this._duration=0;
			//this._delay=0;
			//this._startTimer=0;
			//this._usedTimer=0;
			//this._usedPool=false;
			this.gid=0;
			//this.update=null;
		}

		__class(Tween,'laya.utils.Tween');
		var __proto=Tween.prototype;
		/**
		*缓动对象的props属性到目标值。
		*@param target 目标对象(即将更改属性值的对象)。
		*@param props 变化的属性列表，比如{x:100,y:20,ease:Ease.backOut,complete:Handler.create(this,onComplete),update:new Handler(this,onComplete)}。
		*@param duration 花费的时间，单位毫秒。
		*@param ease 缓动类型，默认为匀速运动。
		*@param complete 结束回调函数。
		*@param delay 延迟执行时间。
		*@param coverBefore 是否覆盖之前的缓动。
		*@return 返回Tween对象。
		*/
		__proto.to=function(target,props,duration,ease,complete,delay,coverBefore){
			(delay===void 0)&& (delay=0);
			(coverBefore===void 0)&& (coverBefore=false);
			return this._create(target,props,duration,ease,complete,delay,coverBefore,true,false,true);
		}

		/**
		*从props属性，缓动到当前状态。
		*@param target 目标对象(即将更改属性值的对象)。
		*@param props 变化的属性列表，比如{x:100,y:20,ease:Ease.backOut,complete:Handler.create(this,onComplete),update:new Handler(this,onComplete)}。
		*@param duration 花费的时间，单位毫秒。
		*@param ease 缓动类型，默认为匀速运动。
		*@param complete 结束回调函数。
		*@param delay 延迟执行时间。
		*@param coverBefore 是否覆盖之前的缓动。
		*@return 返回Tween对象。
		*/
		__proto.from=function(target,props,duration,ease,complete,delay,coverBefore){
			(delay===void 0)&& (delay=0);
			(coverBefore===void 0)&& (coverBefore=false);
			return this._create(target,props,duration,ease,complete,delay,coverBefore,false,false,true);
		}

		/**@private */
		__proto._create=function(target,props,duration,ease,complete,delay,coverBefore,isTo,usePool,runNow){
			if (!target)throw new Error("Tween:target is null");
			this._target=target;
			this._duration=duration;
			this._ease=ease || props.ease || Tween.easeNone;
			this._complete=complete || props.complete;
			this._delay=delay;
			this._props=[];
			this._usedTimer=0;
			this._startTimer=Browser.now();
			this._usedPool=usePool;
			this.update=props.update;
			var gid=(target.$_GID || (target.$_GID=Utils.getGID()));
			if (!Tween.tweenMap[gid]){
				Tween.tweenMap[gid]=[this];
				}else {
				if (coverBefore)Tween.clearTween(target);
				Tween.tweenMap[gid].push(this);
			}
			if (runNow){
				if (delay <=0)this.firstStart(target,props,isTo);
				else Laya.timer.once(delay,this,this.firstStart,[target,props,isTo]);
				}else {
				this._initProps(target,props,isTo);
			}
			return this;
		}

		__proto.firstStart=function(target,props,isTo){
			this._initProps(target,props,isTo);
			this._beginLoop();
		}

		__proto._initProps=function(target,props,isTo){
			for (var p in props){
				if ((typeof (target[p])=='number')){
					var start=isTo ? target[p] :props[p];
					var end=isTo ? props[p] :target[p];
					this._props.push([p,start,end-start]);
				}
			}
		}

		__proto._beginLoop=function(){
			Laya.timer.frameLoop(1,this,this._doEase);
		}

		/**执行缓动**/
		__proto._doEase=function(){
			this._updateEase(Browser.now());
		}

		/**@private */
		__proto._updateEase=function(time){
			var target=this._target;
			if (target.destroyed)return Tween.clearTween(target);
			var usedTimer=this._usedTimer=time-this._startTimer-this._delay;
			if (usedTimer < 0)return;
			if (usedTimer >=this._duration)return this.complete();
			var ratio=usedTimer > 0 ? this._ease(usedTimer,0,1,this._duration):0;
			var props=this._props;
			for (var i=0,n=props.length;i < n;i++){
				var prop=props[i];
				target[prop[0]]=prop[1]+(ratio *prop[2]);
			}
			if (this.update)this.update.run();
		}

		/**
		*立即结束缓动并到终点。
		*/
		__proto.complete=function(){
			if (!this._target)return;
			var target=this._target;
			var props=this._props;
			var handler=this._complete;
			for (var i=0,n=props.length;i < n;i++){
				var prop=props[i];
				target[prop[0]]=prop[1]+prop[2];
			}
			if (this.update)this.update.run();
			this.clear();
			handler && handler.run();
		}

		/**
		*暂停缓动，可以通过resume或restart重新开始。
		*/
		__proto.pause=function(){
			Laya.timer.clear(this,this._beginLoop);
			Laya.timer.clear(this,this._doEase);
		}

		/**
		*设置开始时间。
		*@param startTime 开始时间。
		*/
		__proto.setStartTime=function(startTime){
			this._startTimer=startTime;
		}

		/**
		*停止并清理当前缓动。
		*/
		__proto.clear=function(){
			if (this._target){
				this._remove();
				this._clear();
			}
		}

		/**
		*@private
		*/
		__proto._clear=function(){
			this.pause();
			Laya.timer.clear(this,this.firstStart);
			this._complete=null;
			this._target=null;
			this._ease=null;
			this._props=null;
			if (this._usedPool){
				this.update=null;
				Pool.recover("tween",this);
			}
		}

		/**回收到对象池。*/
		__proto.recover=function(){
			this._usedPool=true;
			this._clear();
		}

		__proto._remove=function(){
			var tweens=Tween.tweenMap[this._target.$_GID];
			if (tweens){
				for (var i=0,n=tweens.length;i < n;i++){
					if (tweens[i]===this){
						tweens.splice(i,1);
						break ;
					}
				}
			}
		}

		/**
		*重新开始暂停的缓动。
		*/
		__proto.restart=function(){
			this.pause();
			this._usedTimer=0;
			this._startTimer=Browser.now();
			var props=this._props;
			for (var i=0,n=props.length;i < n;i++){
				var prop=props[i];
				this._target[prop[0]]=prop[1];
			}
			Laya.timer.once(this._delay,this,this._beginLoop);
		}

		/**
		*恢复暂停的缓动。
		*/
		__proto.resume=function(){
			if (this._usedTimer >=this._duration)return;
			this._startTimer=Browser.now()-this._usedTimer-this._delay;
			this._beginLoop();
		}

		/**设置当前执行比例**/
		__getset(0,__proto,'progress',null,function(v){
			var uTime=v *this._duration;
			this._startTimer=Browser.now()-this._delay-uTime;
		});

		Tween.to=function(target,props,duration,ease,complete,delay,coverBefore,autoRecover){
			(delay===void 0)&& (delay=0);
			(coverBefore===void 0)&& (coverBefore=false);
			(autoRecover===void 0)&& (autoRecover=true);
			return Pool.getItemByClass("tween",Tween)._create(target,props,duration,ease,complete,delay,coverBefore,true,autoRecover,true);
		}

		Tween.from=function(target,props,duration,ease,complete,delay,coverBefore,autoRecover){
			(delay===void 0)&& (delay=0);
			(coverBefore===void 0)&& (coverBefore=false);
			(autoRecover===void 0)&& (autoRecover=true);
			return Pool.getItemByClass("tween",Tween)._create(target,props,duration,ease,complete,delay,coverBefore,false,autoRecover,true);
		}

		Tween.clearAll=function(target){
			if (!target || !target.$_GID)return;
			var tweens=Tween.tweenMap[target.$_GID];
			if (tweens){
				for (var i=0,n=tweens.length;i < n;i++){
					tweens[i]._clear();
				}
				tweens.length=0;
			}
		}

		Tween.clear=function(tween){
			tween.clear();
		}

		Tween.clearTween=function(target){
			Tween.clearAll(target);
		}

		Tween.easeNone=function(t,b,c,d){
			return c *t / d+b;
		}

		Tween.tweenMap={};
		return Tween;
	})()


	/**
	*<code>Utils</code> 是工具类。
	*/
	//class laya.utils.Utils
	var Utils=(function(){
		function Utils(){};
		__class(Utils,'laya.utils.Utils');
		Utils.toRadian=function(angle){
			return angle *Utils._pi2;
		}

		Utils.toAngle=function(radian){
			return radian *Utils._pi;
		}

		Utils.toHexColor=function(color){
			if (color < 0 || isNaN(color))return null;
			var str=color.toString(16);
			while (str.length < 6)str="0"+str;
			return "#"+str;
		}

		Utils.getGID=function(){
			return Utils._gid++;
		}

		Utils.concatArray=function(source,array){
			if (!array)return source;
			if (!source)return array;
			var i=0,len=array.length;
			for (i=0;i < len;i++){
				source.push(array[i]);
			}
			return source;
		}

		Utils.clearArray=function(array){
			if (!array)return array;
			array.length=0;
			return array;
		}

		Utils.copyArray=function(source,array){
			source || (source=[]);
			if (!array)return source;
			source.length=array.length;
			var i=0,len=array.length;
			for (i=0;i < len;i++){
				source[i]=array[i];
			}
			return source;
		}

		Utils.getGlobalRecByPoints=function(sprite,x0,y0,x1,y1){
			var newLTPoint;
			newLTPoint=new Point(x0,y0);
			newLTPoint=sprite.localToGlobal(newLTPoint);
			var newRBPoint;
			newRBPoint=new Point(x1,y1);
			newRBPoint=sprite.localToGlobal(newRBPoint);
			return Rectangle._getWrapRec([newLTPoint.x,newLTPoint.y,newRBPoint.x,newRBPoint.y]);
		}

		Utils.getGlobalPosAndScale=function(sprite){
			return Utils.getGlobalRecByPoints(sprite,0,0,1,1);
		}

		Utils.bind=function(fun,scope){
			var rst=fun;
			rst=fun.bind(scope);;
			return rst;
		}

		Utils.measureText=function(txt,font){
			return RunDriver.measureText(txt,font);
		}

		Utils.updateOrder=function(array){
			if (!array || array.length < 2)return false;
			var i=1,j=0,len=array.length,key=NaN,c;
			while (i < len){
				j=i;
				c=array[j];
				key=array[j]._zOrder;
				while (--j >-1){
					if (array[j]._zOrder > key)array[j+1]=array[j];
					else break ;
				}
				array[j+1]=c;
				i++;
			};
			var model=c.parent.conchModel;
			if (model){
				if (model.updateZOrder !=null){
					model.updateZOrder();
				}
				else{
					for (i=0;i < len;i++){
						model.removeChild(array[i].conchModel);
					}
					for (i=0;i < len;i++){
						model.addChildAt(array[i].conchModel,i);
					}
				}
			}
			return true;
		}

		Utils.transPointList=function(points,x,y){
			var i=0,len=points.length;
			for (i=0;i < len;i+=2){
				points[i]+=x;
				points[i+1]+=y;
			}
		}

		Utils.parseInt=function(str,radix){
			(radix===void 0)&& (radix=0);
			var result=Browser.window.parseInt(str,radix);
			if (isNaN(result))return 0;
			return result;
		}

		Utils.getFileExtension=function(path){
			Utils._extReg.lastIndex=path.lastIndexOf(".");
			var result=Utils._extReg.exec(path);
			if (result && result.length > 1){
				return result[1].toLowerCase();
			}
			return null;
		}

		Utils._gid=1;
		Utils._pi=180 / Math.PI;
		Utils._pi2=Math.PI / 180;
		Utils._extReg=/\.(\w+)\??/g;
		Utils.parseXMLFromString=function(value){
			var rst;
			value=value.replace(/>\s+</g,'><');
			rst=(new DOMParser()).parseFromString(value,'text/xml');
			if (rst.firstChild.textContent.indexOf("This page contains the following errors")>-1){
				throw new Error(rst.firstChild.firstChild.textContent);
			}
			return rst;
		}

		return Utils;
	})()


	/**
	*@private
	*/
	//class laya.utils.VectorGraphManager
	var VectorGraphManager=(function(){
		function VectorGraphManager(){
			this.useDic={};
			this.shapeDic={};
			this.shapeLineDic={};
			this._id=0;
			this._checkKey=false;
			this._freeIdArray=[];
			if (Render.isWebGL){
				CacheManger.regCacheByFunction(Utils.bind(this.startDispose,this),Utils.bind(this.getCacheList,this));
			}
		}

		__class(VectorGraphManager,'laya.utils.VectorGraphManager');
		var __proto=VectorGraphManager.prototype;
		/**
		*得到个空闲的ID
		*@return
		*/
		__proto.getId=function(){
			return this._id++;
		}

		/**
		*添加一个图形到列表中
		*@param id
		*@param shape
		*/
		__proto.addShape=function(id,shape){
			this.shapeDic[id]=shape;
			if (!this.useDic[id]){
				this.useDic[id]=true;
			}
		}

		/**
		*添加一个线图形到列表中
		*@param id
		*@param Line
		*/
		__proto.addLine=function(id,Line){
			this.shapeLineDic[id]=Line;
			if (!this.shapeLineDic[id]){
				this.shapeLineDic[id]=true;
			}
		}

		/**
		*检测一个对象是否在使用中
		*@param id
		*/
		__proto.getShape=function(id){
			if (this._checkKey){
				if (this.useDic[id] !=null){
					this.useDic[id]=true;
				}
			}
		}

		/**
		*删除一个图形对象
		*@param id
		*/
		__proto.deleteShape=function(id){
			if (this.shapeDic[id]){
				this.shapeDic[id]=null;
				delete this.shapeDic[id];
			}
			if (this.shapeLineDic[id]){
				this.shapeLineDic[id]=null;
				delete this.shapeLineDic[id];
			}
			if (this.useDic[id] !=null){
				delete this.useDic[id];
			}
		}

		/**
		*得到缓存列表
		*@return
		*/
		__proto.getCacheList=function(){
			var str;
			var list=[];
			for (str in this.shapeDic){
				list.push(this.shapeDic[str]);
			}
			for (str in this.shapeLineDic){
				list.push(this.shapeLineDic[str]);
			}
			return list;
		}

		/**
		*开始清理状态，准备销毁
		*/
		__proto.startDispose=function(key){
			var str;
			for (str in this.useDic){
				this.useDic[str]=false;
			}
			this._checkKey=true;
		}

		/**
		*确认销毁
		*/
		__proto.endDispose=function(){
			if (this._checkKey){
				var str;
				for (str in this.useDic){
					if (!this.useDic[str]){
						this.deleteShape(str);
					}
				}
				this._checkKey=false;
			}
		}

		VectorGraphManager.getInstance=function(){
			return VectorGraphManager.instance=VectorGraphManager.instance|| new VectorGraphManager();
		}

		VectorGraphManager.instance=null
		return VectorGraphManager;
	})()


	/**
	*@private
	*/
	//class laya.utils.WordText
	var WordText=(function(){
		function WordText(){
			this.id=NaN;
			this.save=[];
			this.toUpperCase=null;
			this.changed=false;
			this._text=null;
		}

		__class(WordText,'laya.utils.WordText');
		var __proto=WordText.prototype;
		__proto.setText=function(txt){
			this.changed=true;
			this._text=txt;
		}

		__proto.toString=function(){
			return this._text;
		}

		__proto.charCodeAt=function(i){
			return this._text ? this._text.charCodeAt(i):NaN;
		}

		__proto.charAt=function(i){
			return this._text ? this._text.charAt(i):null;
		}

		__getset(0,__proto,'length',function(){
			return this._text ? this._text.length :0;
		});

		return WordText;
	})()


	/**
	*<code>LayoutStyle</code> 是一个布局样式类。
	*/
	//class laya.ui.LayoutStyle
	var LayoutStyle=(function(){
		function LayoutStyle(){
			this.enable=false;
			this.top=NaN;
			this.bottom=NaN;
			this.left=NaN;
			this.right=NaN;
			this.centerX=NaN;
			this.centerY=NaN;
			this.anchorX=NaN;
			this.anchorY=NaN;
		}

		__class(LayoutStyle,'laya.ui.LayoutStyle');
		__static(LayoutStyle,
		['EMPTY',function(){return this.EMPTY=new LayoutStyle();}
		]);
		return LayoutStyle;
	})()


	/**
	*<code>Styles</code> 定义了组件常用的样式属性。
	*/
	//class laya.ui.Styles
	var Styles=(function(){
		function Styles(){};
		__class(Styles,'laya.ui.Styles');
		Styles.labelColor="#000000";
		Styles.buttonStateNum=3;
		Styles.scrollBarMinNum=15;
		Styles.scrollBarDelayTime=500;
		__static(Styles,
		['defaultSizeGrid',function(){return this.defaultSizeGrid=[4,4,4,4,0];},'labelPadding',function(){return this.labelPadding=[2,2,2,2];},'inputLabelPadding',function(){return this.inputLabelPadding=[1,1,1,3];},'buttonLabelColors',function(){return this.buttonLabelColors=["#32556b","#32cc6b","#ff0000","#C0C0C0"];},'comboBoxItemColors',function(){return this.comboBoxItemColors=["#5e95b6","#ffffff","#000000","#8fa4b1","#ffffff"];}
		]);
		return Styles;
	})()


	/**
	*<code>UIUtils</code> 是文本工具集。
	*/
	//class laya.ui.UIUtils
	var UIUtils=(function(){
		function UIUtils(){};
		__class(UIUtils,'laya.ui.UIUtils');
		UIUtils.fillArray=function(arr,str,type){
			var temp=arr.concat();
			if (str){
				var a=str.split(",");
				for (var i=0,n=Math.min(temp.length,a.length);i < n;i++){
					var value=a[i];
					temp[i]=(value=="true" ? true :(value=="false" ? false :value));
					if (type !=null)temp[i]=type(value);
				}
			}
			return temp;
		}

		UIUtils.toColor=function(color){
			return Utils.toHexColor(color);
		}

		UIUtils.gray=function(traget,isGray){
			(isGray===void 0)&& (isGray=true);
			if (isGray){
				UIUtils.addFilter(traget,UIUtils.grayFilter);
				}else {
				UIUtils.clearFilter(traget,ColorFilter);
			}
		}

		UIUtils.addFilter=function(target,filter){
			var filters=target.filters || [];
			filters.push(filter);
			target.filters=filters;
		}

		UIUtils.clearFilter=function(target,filterType){
			var filters=target.filters;
			if (filters !=null && filters.length > 0){
				for (var i=filters.length-1;i >-1;i--){
					var filter=filters[i];
					if (Laya.__typeof(filter,filterType))filters.splice(i,1);
				}
				target.filters=filters;
			}
		}

		__static(UIUtils,
		['grayFilter',function(){return this.grayFilter=new ColorFilter([0.3086,0.6094,0.082,0,0,0.3086,0.6094,0.082,0,0,0.3086,0.6094,0.082,0,0,0,0,0,1,0]);}
		]);
		return UIUtils;
	})()


	/**全局配置*/
	//class UIConfig
	var UIConfig=(function(){
		function UIConfig(){};
		__class(UIConfig,'UIConfig');
		UIConfig.touchScrollEnable=true;
		UIConfig.mouseWheelEnable=true;
		UIConfig.showButtons=true;
		UIConfig.popupBgColor="#000000";
		UIConfig.popupBgAlpha=0.5;
		return UIConfig;
	})()


	//class laya.debug.data.Base64AtlasManager
	var Base64AtlasManager=(function(){
		function Base64AtlasManager(){}
		__class(Base64AtlasManager,'laya.debug.data.Base64AtlasManager');
		Base64AtlasManager.replaceRes=function(uiO){
			Base64AtlasManager.base64.replaceRes(uiO);
		}

		__static(Base64AtlasManager,
		['dataO',function(){return this.dataO={"comp/button1.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGIAAABRCAYAAAApS3MNAAABSUlEQVR4Xu3a0QmFMADFUJ1JXM0h3moPZ6qg4AoNeLqAIenFn65jjLE40w2sQkxvcAMI0eggRKSDEEJUDEQ4/COEiBiIYFiEEBEDEQyLECJiIIJhEUJEDEQwLEKIiIEIhkUIETEQwbAIISIGIhgWIUTEQATDIoSIGIhgWIQQEQMRDIsQImIggnEvYvv9IzjfxDiP/XlgJsTcCyDEXP/v14UQImIggmERQkQMRDAsQoiIgQiGRQgRMRDBsAghIgYiGBYhRMRABMMihIgYiGBYhBARAxEMixAiYiCCYRFCRAxEMCxCiIiBCMa7iAjPpzG8fY3kF0KIiIEIhkUIETEQwbAIISIGIhgWIUTEQATDIoSIGIhgWIQQEQMRDIsQImIggmERQkQMRDAsQoiIgQiGRQgRMRDBsAghIgYiGBYhRMRABMMihIgYiGBcGJiOHTRZjZAAAAAASUVORK5CYII=","comp/line2.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAAECAYAAACOXx+WAAAAG0lEQVQYV2NkoDJgpLJ5DIxtra3/qWko1V0IAJvgApS1libIAAAAAElFTkSuQmCC","view/create.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAwAAAAkCAYAAAC9itu8AAAAdElEQVQ4T2NkwAIWLFjwH5t4QkICIyM2CXQxmAHka/j///9mXDYxMjL6YtgwBDUg+w8crIT8MBQ0oEca55JvWNPS9xgu4tISzADyNfz///8MnrRkgmHDENSALWng9fRQ0DA40xLecglbWhpqGoZCMUNKUQkANAHAJVkE5XwAAAAASUVORK5CYII=","view/rendertime.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAwAAAAkCAYAAAC9itu8AAABeUlEQVQ4T+2Uv0tCURSAvyNdcwiXBlsaaomWFgeHlqAtCPsDJHwIiUtDSxERtErtmQ6CjkHo4FpDBQ0tbVFR0BYE0eQvOnFF7T17QlOTd3m88873OD8+rtA9uVzOBIPBlIisAwvd8B1QajQahXQ63bIx6QHFYrEEJHrv7qeqZhzHOfYA+Xw+Yow5B+YHoGwymdxW1QAQEFWNAk8i8uEDuZM3gUcLZIEJYNcNqWrVcZyd7p9t8jLwYIFTYBx47UHlcjmcSCQ+B5JtpU0LnAFj3br7kE+yTalb4BCYczVqoT3AjteW4T73FlgFNgY+1IGQz4hPLGCAI2DGbweu2Auw1Vmcqk4C+8DsEOgZOBCR9/6mVdU2vgIsAdOuIVwANRFpezatuahpTYVSop1m+y6pasm8NQqSvvW61KwslkSHuCRkgvErr0taiUXaal1Sr0siWRO/9HfpF+RN9nfpB/qqmrXrv7mktVhYVm5GLo1cct9LI5e8d84/3UvfAgdlKH0EO7MAAAAASUVORK5CYII=","view/cache.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA0AAAAkCAYAAABSSLCCAAAAcElEQVQ4T2NcsGDB/4SEBEYGBgYGYtmMxCpENhhsA6mA8f///5tHNTEwkBcQpIYcSD15kUtWigi51vR/jVYdOGUQy2YkViGywWSnvTOkhiAonkY1gZIRqSEHTntkRe4g10RWQIyWe5Bgo2O5R7dkBADztyP+yFzirAAAAABJRU5ErkJggg==","comp/clip_selectBox.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGQAAAAoCAYAAAAIeF9DAAAAsElEQVRoQ+3ZQQ0AMQzEwAuqEgh/Sj2pKObhIrBsrfLonHPu12MMTEGYFg+kIFaPgmA9ClIQzQDG0w0pCGYAw2khBcEMYDgtpCCYAQynhRQEM4DhtJCCYAYwnBZSEMwAhtNCCoIZwHBmd/tTh6IUBIrx/tRbiFWkIFaPFoL1KEhBNAMYTzekIJgBDKeFFAQzgOG0kIJgBjCcFlIQzACG00IKghnAcFpIQTADGE4LwYL8U/BE1dCJ3PsAAAAASUVORK5CYII=","comp/label.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAHgAAAASCAYAAACQCxruAAAAmElEQVRoQ+3aMQqAQBBDUef+hx4Zq1mrbPnhWylECHmghVZ397OOqqp97TlugdNzgEXFIaaFuwROt0LmBEay5aXb920+FjIpMJItLy1wvhUyKTCSLS8tcL4VMikwki0vLXC+FTIpMJItLy1wvhUyKTCSLS89wPP1Qeh8M0zy+84gMMbruqjA15OxbtjAu7mPa5bj0fb/A8cLgD4n/wQKNiIAAAAASUVORK5CYII=","comp/clip_tree_arrow.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAgAAAAQCAYAAAArij59AAAAwUlEQVQoU5WRPRKCMBCFWUt6vYQeB06RUDpoBbFDa7yDwm30FGi9dHnOMiQDBgvT5c3b7+0PRVEUlVV9A3NmzL6T//SRfMz5CgCdtVafjlmzaHAigAbM2tE8YVo1pf0yvABoc9D3wACgBbMKIgD4qqDJsqqlMV8VGL5n/88geCJKlijSMBXFZUNx/CSi9WwX1r7R99thzKKqkxXRbMUWSE2u2sEwHsxHCbrMVSq6N4xRD9HAvJstylEkarhurlqnfQC58YP5+CvQNwAAAABJRU5ErkJggg==","view/bg_panel.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAMUlEQVRYR+3QQREAAAjDMGZk/l2CDD6pgl7SduexGCBAgAABAgQIECBAgAABAgS+BQ4oyStBhXcy5AAAAABJRU5ErkJggg==","view/bg_top.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAMUlEQVRYR+3QQREAAAjDMKZp/rWBDD6pgl7SduexGCBAgAABAgQIECBAgAABAgS+BQ6WyDMhXMLeQgAAAABJRU5ErkJggg==","view/clickselect.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA4AAAAqCAYAAACDdWrxAAACfElEQVRIS8WVO2iTYRSGn5OWqpMOurg0VRBdVVCsg7GgDjpZECyirl4GEYfSgBlaB5VSpApdxCJIoeKgg7dKC21ALahIiyiKKUjxAiI4qCH1lRP/hPhfAnHpGZPv+c4573nP95ukO/xHmINmtq8RtswsPiipB/gAPAFem5nCbcSWKukIsD84/A2YBh4DL8ysWLkk0qOkDcD5GLF+Ac+Ap35ZHGjAdWB5gtJvgZFYVSWdBHaFwBlg1Mw8K0ngFiAbAm+a2XBij/6HpBbgBrAEmAVeAZ1AFU40QDCWrcBZL0/S4Vq4HtgB7DWzU5XyauDBMhhWz70ryVVdb2ZuhGpI2g1MODjfiMFrxZk3s9WNwJ6snHFxQUlXgXfAPeC5mf2O2Y5oqZLcMceCw1+AseCSSTP7mSiOpM3A7RixfvgYgAd+WUQcSSnfPWBlgtIvgf5YVSVdBA6GQF/mS2bmWcvbERmHJF+payFw0MzO1TWApKXBViwL3h5/Pk4AVTjRAMFY9njJXl6wLccrcD3wAHDUzBwuRw18JtbkbkFJruomM7sf2o4u4Jals/mFRgxeFcfBQm97UyOwM+WMiwums/k3QnMps+HWpuLIRC5TCrcRW2pbT35MRiY4XDRsVmiU5uJQIZfxb0k5Ij229eQPySJ287MLGO8Rd1M0XY6AO3LjzYVSy3fAH+VICL4a6o9VtTWbnzbYGKI+IrtQ6Ns2EFuq/5jOTnWD9f4DikeFvvbqhyg2Yzo3voJSy2fAjfEJMYPRQQ2caAAfC7AW2WkvrzU79dCwnRW4Hjgg6JrrbV9VKbkKw1Csyd2Ca7on1y2krHOub3t16//2n79SarbsH7BKtfejoCjmAAAAAElFTkSuQmCC","view/resize.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA4AAAAqCAYAAACDdWrxAAABeUlEQVRIS+2UvUpdURCFvxXRKJpIEBURsVAIiiBoaaGCjY2VLyH4MBaCPoWlnQlpI6SxsQmkURQL5eK/6JK57iuRnMPZtxAkuOFUhzWz96xvjcg8tluAT5LOQqJMHba/AgPAD0nOEtruAOaB6Lon6U+ucAoYTLe7Bb5XCm1/BCaAXqAVOAHyOkYn27PA5/TGWmXHxvBeT2i7TVIM4MUp7ZhGPlY3V/pVKUxEjAIjyac74LIAjK70PwCoyfYXYDJwyqDoHtiRdFOfql0naBgIrILF/ZIi1yH6h1XbYXCPpKOq7s34GEX7JB00m445YBzYlPSQ1dF2N7CaWN2W9DNXuJxAj1uGVeuVQtvh32LyuR34DexWCv+CfAXoBzYkHb8Boe1OSRcFkBdfNY18IQiUtFUpTJjNAPEFHVfAaQFyjZ3zNBzbQ8BSWkZViEbk1uIpjXR8AKbT7jwEvpVUqEk6L0pHLN5hSWWxeq7XjI/v6Sgz0vZ7Ov7DdDwCkcb1m86tSukAAAAASUVORK5CYII=","view/clickanalyse.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA4AAAAqCAYAAACDdWrxAAAC7UlEQVRIS5WWT2hUZxTFfyfGFolkoUVKrHQiEaX+IfgHa54UQzUqpWYhLbQU6ULNwgYXuog6yiiTgK2LgtAu6yqbFkpRBEURQzJEBN200NqKkxoDLnQhFUrizJU7vje8SSbzZr7FwDy+c75z7z3nfU80uMxMDin9JC0zewvYAHwIrAH65wWaWQuwOdy8CVgUHnBd0sUKoJktBbYC24B1QHMVNeck3ZWZrYhtXpUg/3/gS0kzDnT2/cDqpFqBUUnnK5pjZutDgo01Tr0g6XbVrprZypBgO9AUU/EK+ErSyzLQzC5XkTkCfBR7fl/Smeh/qasOlPRp9DAkOgp8H5P9o6SriUAnMrOzgNdswNeSntcL9IYNAQ8kHYuXU5Y6u8ZIupldAO5I+nkOsNb8wjk/ljTZKFCSvMbSMrPSiOpNx9uAz3UP4IbfWSsdrcDH4eZuYHF46LCk47PT8S6wG9gbJmRhlfoPSLrhJvdERJs7E+S73dZKmnagsx8JB50UEHdY3+x0dIUEO2qcekTSr/OlY21I4N5dEJMwA6yX9CKejqkqGn8DemPPb0v6YrZXpyS1xYbsRD3AtZjsk5IuJQKdyMyGAa/ZnbNR0tN6gd6wXwAP8SfV0jGnxki6mV1xyf4ubdTkPue/Jf3TEJCMNZFRMQLtyNwqvaTrSkdHZry1MFM8bLLPgY5U8/SyeYHvncotb5b1A/t8c2QGg3sT2WBLBbD95PiGogr9Ej0Gbap8r4ZJ5kR+MPhW7WdGd5npEFaa15IE+YWW5uklf2S6/1N7OnfasG+Ad5KiAfyVzwYfVDQnlc71YTaA8Ntrvtq/y2eDgapdTZ0a60UMhjdvmcCgWDClJge7npSBqfRYYY5M6U/M/NqO1mQ+G7xf4VUH5rNBOXtviLQfzH0afizop0fZroOJQCdKpcfyUKrZFhTpfDgU/F4nMNcH9gPwLJ8Nls3xarUaI+mp9NhTg5GJbPBZQyb3OReayP17rutmHPga1PpCOk+zrlEAAAAASUVORK5CYII=","view/res.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABYAAAAoCAYAAAD6xArmAAADwUlEQVRIS+3WT2gcdRQH8O/b2SwNC7l4MAEPvbilUkoPOUmLjSDrZn4hxYKH/kGwyB4tQogiu/N+GymyoWguhVBQKKkHQTHsW9fUQwqKp4AgtMXkInhILl4CkoTdmSe/6XZp2pntLli8uMedt9/3mze/33yW8Jw+9Jxy0TeYmV8FcFVVTxPRiwA6AP5U1TvZbHapUqn8nrawxGBVJWvtNVWdJ6K05h1V/dhaW08KT/wRM1sAVQCRqn5JRLdyudw9Iora7faJKIrKqnrBNSWiahAEC0+GHwpm5utEdD+KopsuBMDbzPxt0oqstRdV9Za7lslkzlar1Z8erzsUHATBJhG93C34fmJi4ly5XG6nzTEIgjoRzanqkrX2amowM98F8Fq3wK34PWb+Ii14cXExv7e3V6hWq78+axQrANwt/kVEl5j5h0G2IzMfUdWCtfa3R/VPzvhTAG8AOM/MfwwYehTANwB+ZOYPE4ODIDhJRJvMvD9IqLW2GEXRbSJ6AcBtZr6UGPzoS2Y+lc/nt+bm5v5Oa2CtvaKqywC8bs06M7+eGszMn7nTBqDOzPNpwcvLyyPb29vfAZh2Naq6Za0tpAbXarUzURS53eGKL1trv0oKZ+a3AHytqplMJlOOoui4tfaDvqOw1lZUtabubBOtqOqN0dHRB/v7++62XwHwDoB33dkAUGPmoO92e/yitXZeVT8BkE1acbdpPQiCj4hIBw52hQsLC8c6nc77AN4E8FK3yQ4R/Qzgc2b+Je0ZDPU+fjiZp1eXFD5U8CB7u+/DGybgXxnFMA3/m1GISGwegNMAeuYBuON53lKpVBrePBG5RkTuSPc1b2ZmZnDzRKRnHoDYvIODg3u5XM69/E8AKAO40G1aNcb0N6/ZbF5X1fsAbjpInXnGmETzGo3GRdew+0DPGmPSzRORTQA988bHx89NTk6mmtdoNGLziGjJ9/1085rN5l1VPWSeMSbVvLW1tXwYhoXp6en+5olIbB6A2Dzf9wcyb319/cju7m5hdnY22TwRic3zPO98qVQayLxWq3U0DMPYPGNMsnmrq6snx8bGNqempgYyT0SKzjoAsXnGmP7mNZvNU9lsdqtYLKaaJyJXABwyzxiTbp6IxOYRUd33/VTzNjY2RnZ2dnrmAdgyxqSbJyJnAMTmEdFl3/cTzROR2DzHk6qWiei4Maa/eSJScZY99FRXPM+7MTIy8iAMQ6/dbsfmEVHPPGPM4OaJiBtDqnmuqfuL4Pv+8Oa1Wq1jYRg+ZR6A2DxjzP/mPRupfwAf56Q4urCh6QAAAABJRU5ErkJggg==","view/tab_panel.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABYAAABICAYAAADyMAW8AAAAcUlEQVRYR+3WsQ3AMAhE0TCMeyTvP1tShRQo7lxYegxA8fUPLuac97VhwuKXKhTlFxRQ9GPDClawYvGEDwxIZu7pFRZXr4ACinY1ghWsYMX/NxWQr22edyvGGHt6hcV1NqGAon8QVrCCFYteISDnBuQB3xJuQcDkEngAAAAASUVORK5CYII=","view/btn_close.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAAqCAYAAACz+XvQAAACmUlEQVRIS7WWS0/bUBCFz7mJmyZxENm06mNVoVZC7LqGn9FNqy55/BSWSEhs2/4uuqFVoA150JLKJvGdaiIH2TfXNoKQpeP5PHPO3GMTK/5xxTwsAUWkBeBZ+qAByb/Zh4pIA8CL9NqY5Dj7vw9YA/ABwDsAfwB8ITnUIhF5CuATgNcAfgH4RnJSCkwLl6AA/lXBtLZQQxFxoTr6q6LOFl2WmuJAtcY7ZuXIixsczfRyTlPfhpSN7BpwBeBtFdQLFJE2gI8AXi7GBBBl3Fdnv5L87XbpWxuFfQbw3NXM0dQLLdrDIH3ylGTiLLYB8CS9lpCc3tmU+xzL1Z9lEXl/n06KavjowCiK1uM4fqMd1Ov1s3a7fZntZjabtSeTiQYHgiC4aLVavZwpbofT6TQYDAaH1tod3bMwDHc7nc5PLZrNZmG/3z8WkS1jzGm32z1oNBqjUqD+6YM2m81xFWyeNkUaulAAlyKyWdTZbdqUmZKFakEVrLRDV7P5zY6m3rQp6tA1AMC5tXY7he51Op0fdwbGcdwdDodHWc2MMdcL9wGM1tbW9sMw/L6UNm6HChuNRifW2g1XM0dTL3TJZS1KkkTDFbVaLQqCIJcm6k0URRpxuvg39Xo9rtzDh5zt1Z/lXq+32rR5dKC1dt0YM08bAGd65BxN1ZB52ojIBcl82rgdWmsDkocAdgDoW22X5DxtSIZJkhyT3AJwCuCAZD5tfCP7oMaYcRVs/tAiDT1QHX2zqLPbtCkzxYFqjXfM3GKXAR3NtC6nqTccioAeA84BbCuU5B4Af9r4gCLSBXCU1UxErjPuj0Rk3xiznDYuMIWdANhwNXM09UKXXNai9LtQ9y4yxuS/XUijr9L0lXBDMp82j370HhJdWvsftiHJYFPSIqEAAAAASUVORK5CYII=","comp/combobox.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAFsAAABCCAYAAAA476rKAAACfElEQVR4Xu3bMYsTURQF4PMmExgIWkgEU5hskyJYxGYKY5VS7NzCylL8Bftj3NbKQjuxTBWbaUwhKdIYLCJotlACA5m8kQTZZZkkeN9dbuNJOXPPu/DN5ZHkMa7dbpfgx0TAEdvEedeE2HbWxDa0JjaxLQUMe3HPJrahQECrNE3RarUOJheLBbIsq9znZAdgJ0mC4XCIer1eSa/Xa4xGI+R5TuwA272RTqeDfr9fuTeZTDCfz/dmONkK/cFggGazebnCcrnEeDw+uCKxFdiNRmO3nURRBO/9bvtYrVbEVpgejXa7XfR6PUynU8xms6O1nGzlU3DO7fbu7V5dlsf/0yO2ElsSJ7ZES1lLbCWgJE5siZaylthKQEmc2BItZS2xlYCSOLElWspaYisBJXFiS7SUtcRWAkrixJZoKWuJrQSUxIkt0VLWElsJKIkTW6L1t5an6wFooRGerofKBeZ4uh4IFxrj6XqoXECOp+sBaJoIT9c1esIsT9eFYFbl/J5tJc13agyliU1sWwHDbtyziW0oYNiKk22JfXJ6xnfXjcDdFttnb43a/b9tovQ5iG30/IltBL1tQ2xiGwoYtuJkE9tQILBV/ugl4rh2MF1sPJJP59fuc7IDsTe37mHz8Bki+MoKHhFqn9+j9vs7sQN9K7G89xRx837levHzG5Lph8p1TrZK3iF//ApxdLVI4YFk/BpA9Uc5sVXYwObOCfyDJ3AoUcIh+vIRtYuve1clthJ7G8/7p4hv30Xx6weSybuDKxL7BrARxcjTF0iyN4AviH0Tpto1ONlaQUGe2AIsbSmxtYKCPLEFWNpSYmsFBXliC7C0pZfY2oWY/zeBP8uaLni/AFTVAAAAAElFTkSuQmCC","comp/textinput.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAFsAAAAWCAYAAACv8OArAAAAZElEQVRYR+3UQQkAMAwEwcZI/LtsoSL2NTGwMByZ3b3HJQIDO3H+EdidNezQGjbsUiBs+dmwQ4EwZdmwQ4EwZdmwQ4EwZdmwQ4EwZdmwQ4EwZdmwQ4EwZdmwQ4EwZdmwQ4Ew9QBe0R29X9x+dwAAAABJRU5ErkJggg==","comp/vscroll.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABEAAAAhCAYAAAA/F0BXAAAAOklEQVRIS2N8+OzVf2YWFgYmJiYGcgHjqCEYQTcaJpipaTRMRsOEmDJmNJ2MppPRdEJMCIymE2JCCQAYonwDuu2VMAAAAABJRU5ErkJggg==","comp/vscroll$down.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABEAAAAzCAYAAABxCePHAAAC/klEQVRIS+2WS0wTURSG/zszBcrLFVvjio0LiAqRRDAmGpRodFE1MQQQkOKGqBujRo3ExLjB4MaKgDzUaGQhvoJGYwAjYoioERcuDGxYEIwPkBY6nWvObXuLnXZaSklYOIu5M/fxzZn/nvPPsInJKa5qGhRFQaIH+w8xSbcymtTd+gBFYXAdyjM9sf7ORxgGR0t5/j9jpkhq2t5B0xQwBrgqNsnJ9V0j4BzQdQNtNYXWkKz0NDiaXkBTFTCFoaWmCHVtQ+AGh+4z0HNiO2bmPNYQGiXQvkuPoaqqiIgi8Pl8eHBqtwlA86MKS6Cy8z1gjIFzjqcXHBEBlpBgRNuOd+HVlYqogJiQIChcg/BtW5k8SaSSkxPJ5PRPTttHfkI7kcghIpn8NYfp33NLXp+TnYG1OWvA3ox9499nPSjdkCsgHJxOIjc43VMrugL9dEUD4Oj/PA4CsUfDX/jOjbmisHTDCCzi4t4QgLDrQF+qTYOmqhgYGw9BvLpv0ZNjQwieaU9b7ZCDriFhSt3VBSZNartHA6aUJ7SK+jqO5n5pSp1HiqSw1e3Di0ypwBpiU1XsudwnTanraDEqrg2GmZLbGkJh2jQVZY29JlPqPe03JX/uxLE7Nk3DjjP3pCn1Ne7HrNsjdYoLQsmWYtNQ3NCBgeZKzLrn/foEoogbQgvSUmz4454P7VQikGhpHzGSZdVOUqqYTGli6gemZ9yJ+0lSTalk/TrxtQOYaBnESbTinokev4UG+p+9/xoyJQKQn8x7vf7JjEFZ1FJBBvuC12RINIdAwtkIQuksnxgHhKBUZ6scQtLSNyiWJpav47z9STjbjfJ8k5iVN0eEs911bhZjUTWpbR+RztZ6uFBERNCq1rfS2e43lFhDsjPscDS9lM7W4dyCquuvpbM9PFkq0iHm7mSl2yP+bj05uxdeXZe5FHOL6Xdr17nQ79bziwew4NXFqwUTMiaEtKBPwtZjnRi8WgXPglfqsyQITc60pwpAeNpH1GRZtRM0pWVVcTJM6S+dYaRsIf025wAAAABJRU5ErkJggg==","comp/vscroll$bar.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABEAAAA/CAYAAAAGyyO8AAABYElEQVRYR+2Wv0sDMRTH30tarCg6dRWnQnFT6OiqoP+tk+Cig+AiHayDiNSlg+jgD47K1US+Lwm5s4o/mkElN1xy73KfcF/efTi+Ht3Y0X1Btw8FffdoLy3QSnuZ+HhwZe+exrS13hGGJYsTWSszN0rJ1zHDDbJ0eDYkgHjv5Nxub3TIGEsTY/xDVq6NAN7MfW2u2aCG1nQ0GEZIOXmp7Pw5BPDF+VaGIGQfbM6k0ng5kw8/wF/eJzP5JInZkjg2CSS8zk6vCys7Wb8r5qqsncAP+pdR1Lu9rvgVT4uYg+3F+PCtAzjzu/taKdKKBSS2/wkEMBg/Q+rB50zqzZb7ZPoD/GeZ1HySxGxJHJsEEl5nc22VmCFalpFJTjLKNUtFxlDfP72IogYAP8PPZekWM5OqjErFWpjjbxprABJRA/JYjOOOX4Bgo6bWGYKsfMg5k+lmy5n8uUxm8kkSs6Vw7Cstibc9Fv5vWQAAAABJRU5ErkJggg==","comp/vscroll$up.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABEAAAAzCAYAAABxCePHAAADF0lEQVRIS92WTUhUURTHz31vPv0KKmkXrtxUGNomkCANLdCUpEatJFuIClIEFRl9kGH0BYWQElLpotGKEJXAtKQooYUFpi1axLQZMCyyZJqv926cM2/uTM288emoUHfx3v16v3fuuef+72Hume/c7/cBAwaLKWaLBZjLPc0Zk0CSJGBs4SDOObDP7i9ckuXkIbLJRJDFFrJk2SGNvZNwy7ExoZEJLWnqfQ+4SlUFaHNs0gXpQhq6x0GWGe0Y7oCicGivyYsLigup7XgFJlkCJjFwNm2HqrZR4CqHoKLC3fr8GFAMpPLqEJhMoZjpay6Bnx4vpKfYoLx1kCwKBlXoOV78BygGsudCH1nwtNVBgHBBUFFzL1n0+Gx5YghOxhINiAbFG1uZODESxf+bJShKrulv8HUusp1G/IBz1qTZIGvdamBjU584Aopzs+lbDhwfFFgc2/imLq0fazgAHF5MumBtuh3YwJsPfGdeNqgY1qqqfcSprRLgr7rWZzWbwCTL8HLKFYEEgkrUn+eHIDzNbltBSG33O+jcnxNZmrYcw5Yc7hoXotRenRPyz0IgBzrGYkTp9qEtxiEV10eEKD08Wgh7bzwTonSvIV/soK5jd53rE6I0eGY3/PL5wWYxQ+nFgShRKqK6LqTwhJNEafRKNQHCcWK3WmDHqR5NlMoSQzAWUV+9vkBMsKXYLCSbs3Oe+SGqqupGrIL3h3YclifYkjo7yZ7izIzUUGrhnvXAzA+PURkR8xCwPnMVsCUVpW0bsiCUKOH9S0980JvaLJSQUTal9Q+9/RgRJQSgnvgCgdBkxkCKektSpC9cR0HCOQgiZUMI3njijwYg+COzLP9rkLr7E3Dn4Gbhp7BPDC+n0TkhlK2zJpccuSBIfVdsutVdt9U4pLbjtVC2B0cKYN/N50LZHh0rFGGguztV14aFsvWfLiVhSrVboaSlXyjbk/NlBNKFVLT0k7INX3KAx+sXfkBlKzjpJItGLlcmhmSkptAB83h9MTuCICxBRUkMwUmY5+uFPY7LmJ7GW05SZycsSos9xUsmSr8BfgGeWI6+BgEAAAAASUVORK5CYII=","comp/button.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAE0AAABFCAYAAAAPWmvdAAABA0lEQVR4Xu3ZMRGDUBRFwXwfKSgxFhfRgAbUxEakkCEO3qmX+p9m5w7NW9v7cz18I4EFbeT1fwxtbgYtmEGDVgRC458GLQiExNKgBYGQWBq0IBASS4MWBEJiadCCQEgsDVoQCImlQQsCIbE0aEEgJJZW0Pbj64Q3hFvQhmL3CQ8atLlAKCwNWhAIiaVBCwIhsTRoQSAklgYtCITE0qAFgZBYGrQgEBJLgxYEQmJp0IJASCwNWhAIiaUVtOfrdMIbwi1oQ7H7hAcN2lwgFJYGLQiExNKgBYGQWBq0IBASS4MWBEJiadCCQEgsDVoQCImlQQsCIbE0aEEgJJYGLQiExNIC2g/MxaMp6CSauwAAAABJRU5ErkJggg==","view/bg_tool.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAMklEQVRYR+3QQREAAAjDMCYG/DsEGXxSBb2ke7YeiwECBAgQIECAAAECBAgQIEDgW+AAAeIuAVS/mngAAAAASUVORK5CYII=","comp/minBtn.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABwAAAA8CAYAAAB1odqiAAAArUlEQVRYR+3X0QmAMAwE0GQN19B9nM193CmiIH7ZXOAoRc/fpjl8jVDdOj/eOc8USBcXqUjLAtDQRMSOdHb3JatTYCZUXodIy10bGxTI1Lx6/YA0Ima6W2tKFcjmdpGKtCow7NBAdxozy+804Gfx/cDqbLzWDzs0ekNY4B9nOMEehMKTVIEEyKeFSKmc18+MppRtipJuYPCa1SkwEyqvo6Tlxm8bFEijvBt9n/QA/fOPydLHcUIAAAAASUVORK5CYII=","view/zoom_out.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABYAAAAoCAYAAAD6xArmAAACy0lEQVRIS92WQU8TQRTH/28oQkj0CL0QOMAJQkz4DkS6A+GA+A00Hrhj0uy8NiTwEdBPAOrB0Fnq3U8g6gkOSjxUjpCQCu08M5u2qaVAt7YmOqfNZPa3b9/+Z35L6NOgPnHx98Gbm5sTlUplA0AGQBpACcBBKpXazmaz3+5607YVM/MjEXlNRPdbASJyTkRrzPz+Nvg1MDNPAvgI4AGA10qpvHPuSCk17ZwLAazV4HPM/PUmeDvwSwBPAbxl5sf+RmYWZo7XMvOehwPYYebnScAnAMaVUrNhGH5pBefz+Rnn3GcAJ8w8kQT8E8A9AEMA/HXrqM9fMrO/bjvataJvFdd7/IaZfS9/67ExZpeIngB4xczPklQ8KSKHPmoispdKpXKjo6PHp6enU5VKxXhoV6moVXhnjpVS5wDOwjD81K7qG7e033lXV1cviMjvvDEAP0TkYHBwcKtarT4UkXcALolo1RhTaIV3dVYYY9aIyOfZDw9fMcYUm+FdgWvtYgCmBisrpRbCMPxQh3cNbgM3zJzvCdhDcrncuojMA8gy8/eegTvO8U0Lk87/UY9ve9h/BI6iyJ+1GyLScB4RHQDYDoKgO+dFURSfFQCuOQ9A7LwgCJI5r1gsTlar1YbznHP5crl8NDw8PK2Uip3n4QMDA3OLi4udO89a23Ce1jp2nrVWtNbxh7bWxs4jop0gCDp3XhRFJyIy7pybXV5ejp3XDN7f359RSsXO01p37jxrbey8i4uLoZGRkWvOa5q/1Fp37rx+VtxwntY6dl5zK6Io2hWR2Hla686dV0vFoY+aP8xFJJdOp49LpdIUEZkaNHkqfIWd5JiIzkXkLAiCZM7zO09EYueJyBgRxc4joi0ADeeJyOrS0lJvnBdFkf8xbDhPKbWSyWR647xCocC+53XnAVjQWvfGeS1wo7XunfOstesA5pVS2Uwm8w877xeHf444cscwYAAAAABJRU5ErkJggg==","view/refresh2.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABUAAAA/CAYAAAAPIIPGAAAEIElEQVRYR+2XTUhjVxTH/+fGpBrGT/xoBQdFFMMQLNLNbLooLbaFzqKMUhCSZwsuhGG6KCNd6DuRLgqzmGVxUd8LUrpoYWZTKO1yNi2F1oVtceEHflSLqNEav8bklPuqgsl75sUPSsucTQj33v895+R/7y+XcA1B16CJ/6GoYRiDItKfzWZjExMTv5/XtoLlx2Kxm0qp1wH0AHgTwC4RfWRZ1mdewp6ig4ODN9Lp9CMieh+AchH41Lbtj92EXUUHBgaCh4eH3wJ4zSObGSLqtSzrZ9+ihmF8CODR8YIflFL3MplMNxF9IiJWIBC4Pz4+/ldR5RuG8QuAlwGsAWi3bTsVj8dvAWhOJpPfFPK2a/mGYewDeAHAV7Zt9+aK9PX1VYRCoVcApNxa4CX6J4B6AE9t2341V9QwjO8AvAFg27btytxxL9EvAbynJxNRj2VZX58sjMfjd4joyT9D9NiyrHf9iup+/gggBCALQPfxVwARAO8cWywD4LZt2z/5EtWT+vv774rIBIBSlx/mmT5dyWTyC9+WOpkYi8XalVIPRKQbwItEpHv9PRE9tCzrt6IsVcgyhcYLnv1CAkWXfxFBxzEXXXipq+8imz7P9CJdO3+N754y86A+vYFAIDY8PHw58DHzTQB54DNNs3jwMfONY6R4go+Z/YNvbGwsuLKyci74APQys3/wMfMZ8InIPaVUt4g44AuHw/eHhoaKAx8znwEfM6dGR0dviUizaZoXA59pmvtE5ICPmfPAx8wVABzwubXA1VLM7IBPRJ4mEok88DHzKfiY2R/4mPkUfCLSk0gkTsHHzHdE5Immnog8TiQS/sDHzK7gE5EIEZ2CTyl1e2RkxD/4TNO8S0Su4BORZ0qpftM0iwefaZrtAB4QkQM+AA74ADxk5ufgc78CfV99xdy61yMajUbfAvA5gJeKycZj7gqADygajf5xRYIn+6xoUbmCDM9I/LuidXV1qK2txdzcHPb39ZPAOwpmGgqFUFFRgerqauczm81iaWkJa2v64eLhU6+eKqXQ1NTkZOcWq6urWF5edh1zzZSI0NbWhvLyctdFBwcHmJ2dxe7urn/R+vp6J0sd6XQaCwsLqKysRGNjI9bX17G4uIhMRr8jiig/EokgHA7j6OgIU1NTjkBZWRl0f7e2tgo60LX8rq4u/UjC5uamU2ZuBAIBZ1O9mVsLXEU7OztRUlKCnZ0dTE9P54nqfmsnaNHJycm8cVfRlpYW1NTUOJN1pjrjk6iqqkJra6vzNZVKYWZmxp+oLq2jo8NpgQ7dx729PZSWlkKL6hARpwr9Q+aGp/m12Zubm6H9mhtacH5+HhsbG/4tdTJTZ9bQ0OD0LxgMOm7Y3t6GNv55R7XgMS3oH5cJ/y3Rq775V3X5bx8zSv8DuWzoa2vgb5tumbHGlerDAAAAAElFTkSuQmCC","view/settings2.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABUAAAA/CAYAAAAPIIPGAAAD2ElEQVRYR+1Xz08bRxT+ZjAGYQoH4rS9IBJBQJEsUC8VKNdQtamUE0fLayqhKHeOaGbFkT8gFVLZtXzk1qqKSs4NUg8RXCIQVoOQ2jRFHHCwBRj2VW+zttY/14BXVaPOyR7NfPN9771536xACEOEgImPDHRhYaHv/Pz8kEMVjUbjq6urxVZhayo/lUo9chzndTabfWMYxkMAGx7QrG3bL5LJ5B0p5f1MJvNz7QENQdPp9LdE9CMAZrcHYAaoxJ8AvARwD8AtAI9t2/7JD9wQdH5+/q7jOLzx04DqeCelnFlbW/s9EJQXGIbxq8eQ//4mhPieiJjlEwBf8qQQYtOyLFZRNeqYJpPJWCQSeUBEzz3JrwqFwvT6+vo575ybm4vGYrFNAF8AICnlbKlU2sxms4Uych2oYRh5AJ9UFggxb1mW5aeSTqfTRLTmm3tv2/bAVUCfWpb1zA9qGAaHwD/XGjQU+WVGHU0Ug4ZSUjXFnwMwXVP8nP1RAPG2i5/Z+q9pKpWaFUL8wvNE9FUmk9m48jWtLWavofztNZTb124oN2neH1mTvmoo/pcfHDGtdZ9nLbw4rrW+nvGZpvlISvl6aWnpjWmaD4nINT4hxKxS6sXy8vIdx3HuK6XaMz6ttWt8QohDInKNTwjhJtWzlJdCiHtEdEtK+VgpFWx8Wuu7RMQbWxofEb0TQsxordszPq11Q+MjoidCCNf4AGxqrYONb2VlJVYsFh84jvPck/yKW5/W2jU+rXWUwdj4OBQcYzbCxcXF5sanlMoLIaqMTylVZXymaVYZHxG9N02zufE1AH2qlKoyPqUUh6AyFwgaivzyVehoorxkdL6k/MUPIEdE0/7i5zcUGx8Rxdsufmbrv6ZKqSrjM01z48rXtLbFeA3FNT4At6/dUIJ7V/MV/6HOn0gkvgbwA4DPbyLZ2/sWwHcikUj82SHAMqe3DMrv+I6Ofw9USonJyUlXzfb2NhzHaamsKdPBwUGcnp7i7OwMAwMDGBsbc4H29vaQz+fR09OD3t5eHB8f1x3QEJQBR0dHcXFx4QL39/dXbTw5OXEBI5EIcrlcHXBDUGYxPj6O7u7uljJLpRJ2d3ddNf7RVD6DlhkWCgUcHrof0YjH44jFYu5vnt/Z2QmWz0lhsHIMi8Wiu/HDF6T7mMDExAT6+vjR8iHGHA5/8uqYTk1Noaurq3L6/v4+jo6OqtgMDQ1hZGSkMnd5eYmtra3K/0DQg4ODivTyLg7B8PBw+6ChyC8f39FEMWgoJRVK8TPbjl/T2mruWEO5SYMNo/P/xaDfeB712U3YeXv/ALDwD+TbY8Dbd9BBAAAAAElFTkSuQmCC","view/setting.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAwAAAAkCAYAAAC9itu8AAACAklEQVQ4T5XUS4iOcRTH8c9xCeVeiiiXhSJRJFIusRO2lEtZKFlgY6GxZDUrk2TFwii22JJLlERRLKRQJmXBkHIb8+hM/2d6ememed93957n93v+55zf9/mHll9VVTNxopTPR8T3piTyT1VVs7AL9zEd+4roOn5gK25HxLfacAjL8A8TWw6ta28jorc2LMLhIu7Ds2Jah4XlRVci4mNUVTUDadiLFF/G5GL4iyOYjxsYMnQ1BDfxujk0VmJPecFAO4bV2Nk05Bqzz3Za6ut86JJDx2vN4Hbj3hjBbcOt4eCaQZXUj5daT4pGoNFimI1zpdYVEf2jsTQX+5MX5NaOFdFFJHzJ2bWI+FJv6SRWYACTWliqa68ioqc2LMWpwtJ7PCymzVhSWOqOiHeZdPachqNIcXdBJV/2B6cLa5cwZLjQYOkqnuNsOeEM1uJgE43xDBsaH9QQfJ21VNBoHfpBaWHLiKGLoeO1ZnAHkpcxgkvOeoeDa0FjTnNLEfF1PJamYkcR3YmIX6OxNA35Kb7BFKwvoqf4jeV4GRE/azQ2Yh4GMaGFpbr2OSKe1Ibse1MRJ84fimkxMqc0Pc55MrjsOYvZRoofNW6/vPUSwEQ+2+tPQ14h9fX4Ap+aQ2MB1pQTB9sx5K24qmnorKWCRvtDF0PHa+0suBaW0ry91O5mus3n/wHmQwUTIH+tVgAAAABJRU5ErkJggg==","view/refresh.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAwAAAAkCAYAAAC9itu8AAACiElEQVQ4T4WVS4iPYRTGf4/7/X6XcivXcktEUhTKQkqyYCOKjWyUhezFThbIlJ3LYrIRkoWGUhhhTMko4zJujYRpxgxHj9737/P3zfh239c57/uc5/zO+UQ3T0QsBRYCtZI+5jBVx0fEcGA6MA+YCXQCVyXddWwlISL6ARuARcXvhQPrJF3/nRARvYHtwLRuFLYCFyW15ITl6XTHvwIuJzlrgHrgiqSOiqSI2ANMAL4BxyW1R8RYYKSkp8Vb8w2HgD7AE0kXSozoD0wC2nPCAWAw0CyppiRhBzAD6MgJW4D5KdDFNeSkiJgFbEvONeYE698N2K0ArPsDMAZwguN+AmeKfZgLbAb6llj7A7gk6eFfnY6I0cDKpNc1tQFNwG1JvvFPp0sKXQ2sAGokveuJpVHAHGBJ4ul76vLNapbs9dYk6R8oU7driyztA2Z3w5L1n5LUnBPWptMd/xw4l+RscsHAeeNSZMloTAG+AIcltUXERPdB0qMylk4klu5LOlni2ABgqm3Oko4BQ4Fnko6WJOxPzlXg2wV4hv2czuOYhmsBsDf1rD7fYP0HkyyzZN0twHjACZmlI0WWFgM7e2DprKQ71SyNA9YDBnFYcq0RuOZ5/h9LdsVS6yV97YmlgYDn2X3wjUa7QdKLapY8015ePrWMJVtembhewLI0YWU4eZvck/Q525pXo4M/AY+TLMP40u+SuooseVjsitm/IakzItz5QcXhKSZsBCyrpdjlwuZwfSO8mLOkdYAHqFXSrRKWvErtXFdOcJcnp0AX96ZwuldQ5uxtTrD+VUmWWXqfujwk8eQ4f68rsuRG+d/gZVb9eIk9kPS6miXvIv91rNc12TXPc5MkTyO/AFhJCujHqZlCAAAAAElFTkSuQmCC","comp/checkbox.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA4AAAAqCAYAAACDdWrxAAABbUlEQVRIS+2TP0gCURzHv88GRYsrExyOo5cEQVEtWdQQpE4N0R+HxmirXXCrKYigqMF2IRqCQByaLJqNIFpyUIzu4rIwpExODy88ITD/cJ603Rsf7/OGz+/zI5TSEAE20cZRgBMySKni8XrbwICrWAwG2ESZIadFS53J0R25brCyHZNud1vbcRuPV7fDAOu9GXJatNSZHN2R6wb/PfJCrxOZCR8Gbk6hWc6Xg8PrcgBETMIVPdIGSjYG/NoOSHcfkLqDK3qsBSRIrgRAuBF1quUPEUPhYGMwb2dhywrqQ3F0Dt++jSokJMBdhmDO52pB2WwFP7OK8rgH9os99IgppNf3QWwMFP4RNHKALrmoflIj53l6CaWpRcBkgiIkYHl6gDTrh5JJg57v/kJ1YOUixw7jfWELxMpAKUmAXAR7tg3LZ7am3IbjKDBOvPiDqkUmcoj+9H1d7k3nmHdweBubB70ON9wRzQH8pVVQb+Q/zZAEfpwDCU4AAAAASUVORK5CYII=","comp/btn_close.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABwAAAA8CAYAAAB1odqiAAAE6UlEQVRYR+3Y30+bVRgH8G/T0t/0Jy0USrIsC0E2GMKAVYcRpmSbEzIGZhqyxCxeceGVF3pjvJl/wYyJWZYY4hZBFnBuBBUW2ewYAxlsSMiyLKH8aEt/0vZtSxvM+562We15C6jlxr53zfO8z+ec5z2nOTmCk598tY19fAQs+Hlvz76QX1zpAwd+1NMNXzieU1QtFeKbvn4CXvqgC95wLKegRirC1e8GCPjh+53wMnRwedkG54aLG4yhSI/ycnPawHaKJ5M1MhGuXR8k4MX3OnjBx3NPcLX3DPfepSu3odfrYC4r5X7bVlbhcrnT4kdrjlA7xYLffj9EwJ6udnhCW9TEJ08XUgWTqE6n5XLdbk9G7MjhKmodrbwAfQPDBLxw7h1ecH3dDq/Xm1GYrZqceXIgGo0GJSXFvOCNmz8RsLv9NNyhKO+icTqc8Pl8acDLyWyr1Wo1DEYDbw2dXIz+4TsE7DzbBneQH2SruDZc8Pv9GSiLqVQq6Iv0WVe5TiHG4K1RAnaceguuYCTrCx63G4FAgAoqlUpodbqs7+sVEgyN/ELAs20t2Ajwgz6vF6FgMGtL5QoF1BoNL1qklODW6DgBT518gxcM+P1gQqFdLRqZXA6lSkVFWXDk198I2NZyAs7NMDXR7XRmYBKZjMuNMEzmljHQF46hUIrR8XsEbG228IJ+T/rGFkskkMoVHBgOBRGNRNI2vkpL/5YsODZhJeCbJ47D4WeoM4wyDLai5PsWiCUQJ2aXTN4pnswzqmS4e+8BAZstDbxg1qW3hyALTlinCPh6Uz1C0Rg2w/S/tz3UpaYWSgsgF4twf3IagvOXr297PR5YGuv+bd2s71sfzkCj1ULQe+3u9vraGlg0lw+LlZhMEIzUNu7vmYYFmz/9LJeTS9We+PIymaGl6wLizo2cokJDEawDNxLg+W7EHTkGjUWw/tBPwOMdnYg7nNQZep4/Q2B9jYspS0zQHjyUlrdTPJksNBrwYGiQgE3vtiNup4O2SSuOzk5y7z2ubYKyuBiaAwe5394XzxGw29Pi5iYLdeDCYgMmfxxOgKfPIG53UBNt049SBVNo4g864HRmxMz1x3hAIybv3CZg49ttiK/bqYneFRuCLldGYTY5OfPkQBR6PTRl6cfIVEtLivHw51ECNrS2Ir62zrtKfWtrCHo8acDLyWyrFVot1CYTbw2hqQRTY2MJsLk5K8hW8TkcCPp8GSiHqdVQG41ZtxUHTkwQ8NhrFsRXyUrke3wuF0L+TSooVxVCrc9+iBKWmvDodysB65saEFtZ5cX8Hi+YQDBrS2VKBVRa/jONqKwU05NTBKyrexWxlRUquOnfBBNidrVoZHIZClWF1DqisjLMzPxBwNraasRsdHDD6c7ApDIJVzTMRDJiRQb6EUNkLsPs7DwBa6qrELPZqCNzu/1pG1siEUOhkHK5wWAYkUg0La7T0U9tIrMZc/MLBKw+XImtZTrIMBFEouQkIBEXQJaYXXJ0O8WTeQXlZsw/XSRg1SsVvGDWpbuHIAsu/LlEwMrKCsQDAcQ93j2U2H2qUKuBUKnE4uISBF9f/Hj7wJwVhyordl/hH2Q+W1zCixoLOdNUj98Ei+byYbH5lnPkmJhL6O+18/c0/1m38/c0qVbm72nYVuTvadgu5O9pUtsif0+Tv6dhF8P/657mLz4NfQVdLmZiAAAAAElFTkSuQmCC","comp/textarea.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAFsAAAAXCAYAAABkrDOOAAAA4klEQVRoQ+3ZvQrCMBiF4e9rU+sPOErRqxDRe/KG9Fp0EAc3VzuIg1ML4uDmlkaaquDenMUTyJoDD+8W3ZyKlaoshSeogHOy1m1euOmoI1EU+auqQUf/8XHnnBzLp3jsWdaVJEnEGEPsADXU2Ifro8Gej/uSpqnHruvmaVegqirZX+4N9mIy8Nh13XEct7vE18RaK7vzjdiIFoiNUH5vEJvYQAHgFMsmNlAAOMWyiQ0UAE6xbGIDBYBTLJvYQAHgFMsmNlAAOMWyiQ0UAE79lM2fmrDy358a/q6Hhf68ng175QueKdEXxUGVVwAAAABJRU5ErkJggg==","view/re.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABYAAAAoCAYAAAD6xArmAAACpklEQVRIS+WWPUgcQRiG3+8O70QEUwTB1EJgsTGdRRrhOMjOtEtSRbBIBMFKuCtkZleES2uRQoWQJggKKW7Of7GyTRvBLkVShhS73OXMfWGOU85Es7uXs0m2XeZh+OZ95xnCHX10R1ykBvu+P5fP59+VSqVvf9pUarBS6jWAR0Q0rbWOboP3BCaiOQAHAKTW+vtN8L8BW96W4zjPPM/78Ss8FlypVEYajYbHzALAJIAHALJdoDWl1Esi4m74rWBmpiAI5pk5AHAvJj0VrXU5Fmyhvu+/AfA8YRxfaa1LsWDf92eZeSMJlJnXtdYvEo1Ca30G4GEH/ImI1lqt1nE+nz9vNBrLnVTY39uO4zxNdHgrKytjzWbzs13FzKfDw8PFxcXF8HL3Nscd8BEAN3HcgiCYbLVaHyyIiGaUUm+7R9JzQZRSo0T0BUCGmRd831/tBttK53K5zXK5/DV1pZVSG0Q0C2BXa/0kySEmKojWeoiZD4hoKpvNTiwtLX1MC7+1IFrrQWZeJaJxx3EKN5186lF0LwiC4DEz31dKvU+z69i7Ig0stnm9wv4zsDGm7bxCodBf5xlj2s5j5mkpZf+c1wHPEdFBGIbS87z+OO8S3EnAVhRFvTnv8PBwpF6ve0QkiGiSmX9znuu66ZxXq9XmAcQ6j5krUspkzqvVaqmcJ4SId54xxl6ZiZwHYN113WTOq1arZ0R05TwAa5lM5rher5/ncrllAPYl1HZeFEXJnLe3tzd2cXHRdh6A04GBgWKxWLxyXlcqjqIochPHbWdn58p5AGaEENec13NB9vf3R5vNZtt5RLTguu4159lKA9gUQqR3njHGHpx9tOxKKfvnvGq1OmQrC2AKwIQQon/OOzk5GQzD0I5hPIqi/jvPGNN2npTyH3feTzoJOzgswwlqAAAAAElFTkSuQmCC","view/search.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABUAAAAqCAYAAABcOxDuAAABX0lEQVRIS+3VsUrEQBAG4H9HiDZiJQg+gJVaiKAoWClYXWeZ7D6CtbWFr5Ai2ayQxkLQRgsLGwtBUQsRC6sDCxHxEIvIZSRwxRGSu83pNUe23c0H+89kR2AISwzBxAiinuctCSH2AawD+AFwRkR7QRC85CO0ur5SaoOZzwGM54A3IlrJw1aolPIewEJJUY+01jvde31RKeUMgNceXdLSWk9VQl3XnSWiZhnKzF9RFE1WQrPDUsonAHNFsBDiJAzDRmXUdd1tIjoFMJaDW0KI1TAMH61RpdQ0Mx8z8zMzHxLRAYBlAG0Al2ma7hpjHqxbqgNeAJgHcKW1XutEMeE4Ttv3/axXC1dh9XPgbZqmW8aYd9t3ohCVUt4BWARwkyTJZhzHH7Zgdq4MvQbw7ThOw/f9zypgKVoVsS7UX+C+v+kgeI0Oklrvb0Yw03rwlZW8Hnz14OvqjXrw1e/pPyfwCww91CttlMG7AAAAAElFTkSuQmCC","view/save.png":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABYAAAAoCAYAAAD6xArmAAAA1klEQVRIS+2VzQ3DIAyFwxwdoMMAA/VQ8ZByyEBhmA7QOVxxKLIaOcIoSZUfrlifHw/wM91Ky6zE7SZgANTaDEDhzYJ5odSMC7nA5U7+b4X2dVQr3ic4hHCTlMcY33xPZUUGcwBvdEJwjcfGGIQQ4rd2qenWA3hyAUuABwCP31NtN+i1v02qP4DicRybM885J2ceB/NCyUupfuLxBS4WbmKF9rNUv4p9gq21d0l5SunF91RWZDAH8EYnBNd4nDPPWitnXst0I6Leez+feVowEQ3e+wNk3ge7C/Qp3GfwkgAAAABJRU5ErkJggg=="};},'base64',function(){return this.base64=new Base64Atlas(Base64AtlasManager.dataO);}
		]);
		return Base64AtlasManager;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-9-24 下午3:00:38
	*/
	//class laya.debug.DebugTool
	var DebugTool=(function(){
		function DebugTool(){}
		__class(DebugTool,'laya.debug.DebugTool');
		__getset(1,DebugTool,'target',function(){
			return DebugTool._target;
			},function(v){
			DebugTool._target=v;
		});

		__getset(1,DebugTool,'isThisShow',function(){
			return false;
		});

		/**
		*设置是否显示帧率信息
		*@param value 是否显示true|false
		*/
		__getset(1,DebugTool,'showStatu',null,function(value){
			if (value){
				Stat.show();
			}
			else{
				Stat.hide();
				DebugTool.clearDebugLayer();
			}
		});

		/**
		*是否自动显示点击对象的边框
		*@param value
		*/
		__getset(1,DebugTool,'showBound',function(){
			return DebugTool._showBound;
			},function(value){
			DebugTool._showBound=value;
			if (!DebugTool._showBound){
				DebugTool.clearDebugLayer();
			}
		});

		DebugTool.getMenuShowEvent=function(){
			if (Browser.onMobile){
				return "doubleclick";
				}else{
				return "rightclick";
			}
		}

		DebugTool.init=function(cacheAnalyseEnable,loaderAnalyseEnable,createAnalyseEnable,renderAnalyseEnable,showCacheRec){
			(cacheAnalyseEnable===void 0)&& (cacheAnalyseEnable=true);
			(loaderAnalyseEnable===void 0)&& (loaderAnalyseEnable=true);
			(createAnalyseEnable===void 0)&& (createAnalyseEnable=true);
			(renderAnalyseEnable===void 0)&& (renderAnalyseEnable=true);
			(showCacheRec===void 0)&& (showCacheRec=false);
			DebugTool.enableCacheAnalyse=cacheAnalyseEnable;
			if (DebugTool.enableCacheAnalyse){
				RenderSpriteHook.init();
			}
			if (renderAnalyseEnable){
				SpriteRenderHook.init();
			}
			DebugTool.enableNodeCreateAnalyse=createAnalyseEnable;
			if (DebugTool.enableNodeCreateAnalyse){
				ClassCreateHook.I.hookClass(Node);
			}
			if (loaderAnalyseEnable){
				LoaderHook.init();
			}
			CacheAnalyser.showCacheSprite=showCacheRec;
			DisplayHook.initMe();
			NodeInfoPanel.init();
			if (!DebugTool.debugLayer){
				DebugTool.debugLayer=DebugInfoLayer.I.graphicLayer;
				DebugTool.debugLayer.mouseEnabled=false;
				DebugTool.debugLayer.mouseThrough=true;
				DebugTool.showStatu=true;
				Laya.stage.on("keydown",null,DebugTool.keyHandler);
				DebugTool.cmdToTypeO[0x01]="IMAGE";
				DebugTool.cmdToTypeO[0x02]="ALPHA";
				DebugTool.cmdToTypeO[0x04]="TRANSFORM";
				DebugTool.cmdToTypeO[0x10]="CANVAS";
				DebugTool.cmdToTypeO[0x200]="GRAPHICS";
				DebugTool.cmdToTypeO[0x400]="CUSTOM";
				DebugTool.cmdToTypeO[0x800]="CHILDS";
				DebugExport.export();
			}
		}

		DebugTool.dTrace=function(str){
			if (DebugTool._traceFun !=null){
				DebugTool._traceFun(str);
			}
			console.log(str);
		}

		DebugTool.keyHandler=function(e){
			var key;
			key=String.fromCharCode(e.keyCode);
			if (!e.altKey)
				return;
			switch (e.keyCode){
				case 38:
					DebugTool.showParent();
					break ;
				case 40:
					DebugTool.showChild();
					break ;
				case 37:
					DebugTool.showBrother(DebugTool.target,1);
					break ;
				case 39:
					DebugTool.showBrother(DebugTool.target,-1);
					break ;
				}
			DebugTool.dealCMDKey(key);
		}

		DebugTool.dealCMDKey=function(key){
			switch (key){
				case "上":
					DebugTool.showParent();
					break ;
				case "下":
					DebugTool.showChild();
					break ;
				case "左":
					DebugTool.showBrother(DebugTool.target,1);
					break ;
				case "右":
					DebugTool.showBrother(DebugTool.target,-1);
					break ;
				case "B":
					DebugTool.showAllBrother();
					break ;
				case "C":
					DebugTool.showAllChild();
					break ;
				case "E":
					DebugTool.traceDisMouseEnable();
					break ;
				case "S":
					DebugTool.traceDisSizeChain();
					break ;
				case "D":
					DisControlTool.downDis(DebugTool.target);
					break ;
				case "U":
					DisControlTool.upDis(DebugTool.target);
					break ;
				case "N":
					DebugTool.getNodeInfo();
					break ;
				case "M":
					DebugTool.showAllUnderMosue();
					break ;
				case "I":
					break ;
				case "O":
					ObjectCreateView.I.show();
					break ;
				case "L":
					DisController.I.switchType();
					break ;
				case "Q":
					DebugTool.showNodeInfo();
					break ;
				case "F":
					DebugTool.showToolPanel();
					break ;
				case "P":
					DebugTool.showToolFilter();
					break ;
				case "V":
					DebugTool.selectNodeUnderMouse();
					break ;
				case "A":
					if (NodeToolView.I.target){
						MouseEventAnalyser.analyseNode(NodeToolView.I.target);
					}
					break ;
				case "K":
					NodeUtils.traceStage();
					break ;
				case "T":
					DebugTool.switchNodeTree();
					break ;
				case "R":
					RenderCostRankView.I.show();
					break ;
				case "X":
					NodeTree.I.fresh();
					break ;
				case "mCMD":
					DebugTool.traceCMD();
					break ;
				case "allCMD":
					DebugTool.traceCMDR();
					break ;
				}
		}

		DebugTool.switchNodeTree=function(){
			ToolPanel.I.switchShow("Tree");
		}

		DebugTool.analyseMouseHit=function(){
			if (DebugTool.target)
				MouseEventAnalyser.analyseNode(DebugTool.target);
		}

		DebugTool.selectNodeUnderMouse=function(){
			DisplayHook.instance.selectDisUnderMouse();
			DebugTool.showDisBound();
			return;
		}

		DebugTool.showToolPanel=function(){
			ToolPanel.I.switchShow("Find");
		}

		DebugTool.showToolFilter=function(){
			ToolPanel.I.switchShow("Filter");
		}

		DebugTool.showNodeInfo=function(){
			if (NodeInfoPanel.I.isWorkState){
				NodeInfoPanel.I.recoverNodes();
			}
			else{
				NodeInfoPanel.I.showDisInfo(DebugTool.target);
			}
		}

		DebugTool.switchDisController=function(){
			if (DisController.I.target){
				DisController.I.target=null;
			}
			else{
				if (DebugTool.target){
					DisController.I.target=DebugTool.target;
				}
			}
		}

		DebugTool.showParent=function(sprite){
			if (!sprite)
				sprite=DebugTool.target;
			if (!sprite){
				console.log("no targetAvalible");
				return null;
			}
			DebugTool.target=sprite.parent;
			DebugTool.autoWork();
		}

		DebugTool.showChild=function(sprite){
			if (!sprite)
				sprite=DebugTool.target;
			if (!sprite){
				console.log("no targetAvalible");
				return null;
			}
			if (sprite.numChildren > 0){
				DebugTool.target=sprite.getChildAt(0);
				DebugTool.autoWork();
			}
		}

		DebugTool.showAllChild=function(sprite){
			if (!sprite)
				sprite=DebugTool.target;
			if (!sprite){
				console.log("no targetAvalible");
				return null;
			}
			DebugTool.selectedNodes=DisControlTool.getAllChild(sprite);
			DebugTool.showSelected();
		}

		DebugTool.showAllUnderMosue=function(){
			DebugTool.selectedNodes=DisControlTool.getObjectsUnderGlobalPoint(Laya.stage);
			DebugTool.showSelected();
		}

		DebugTool.showParentChain=function(sprite){
			if (!sprite)
				return;
			DebugTool.selectedNodes=[];
			var tar;
			tar=sprite.parent;
			while (tar){
				DebugTool.selectedNodes.push(tar);
				tar=tar.parent;
			}
			DebugTool.showSelected();
		}

		DebugTool.showAllBrother=function(sprite){
			if (!sprite)
				sprite=DebugTool.target;
			if (!sprite){
				console.log("no targetAvalible");
				return null;
			}
			if (!sprite.parent)
				return;
			DebugTool.selectedNodes=DisControlTool.getAllChild(sprite.parent);
			DebugTool.showSelected();
		}

		DebugTool.showBrother=function(sprite,dID){
			(dID===void 0)&& (dID=1);
			if (!sprite)
				sprite=DebugTool.target;
			if (!sprite){
				console.log("no targetAvalible");
				return null;
			};
			var p;
			p=sprite.parent;
			if (!p)
				return;
			var n=0;
			n=p.getChildIndex(sprite);
			n+=dID;
			if (n < 0)
				n+=p.numChildren;
			if (n >=p.numChildren)
				n-=p.numChildren;
			DebugTool.target=p.getChildAt(n);
			DebugTool.autoWork();
		}

		DebugTool.clearDebugLayer=function(){
			if (DebugTool.debugLayer.graphics)
				DebugTool.debugLayer.graphics.clear();
		}

		DebugTool.showSelected=function(){
			if (!DebugTool.autoShowSelected)
				return;
			if (!DebugTool.selectedNodes || DebugTool.selectedNodes.length < 1)
				return;
			console.log("selected:");
			console.log(DebugTool.selectedNodes);
			var i=0;
			var len=0;
			len=DebugTool.selectedNodes.length;
			DebugTool.clearDebugLayer();
			for (i=0;i < len;i++){
				DebugTool.showDisBound(DebugTool.selectedNodes[i],false);
			}
		}

		DebugTool.getClassCreateInfo=function(className){
			return RunProfile.getRunInfo(className);
		}

		DebugTool.autoWork=function(){
			if (!DebugTool.isThisShow)
				return;
			if (DebugTool.showBound)
				DebugTool.showDisBound();
			if (DebugTool.autoTraceSpriteInfo && DebugTool.target){
				TraceTool.traceSpriteInfo(DebugTool.target,DebugTool.autoTraceBounds,DebugTool.autoTraceSize,DebugTool.autoTraceTree);
			}
			if (!DebugTool.target)
				return;
			if (DebugTool.autoTraceCMD){
				DebugTool.traceCMD();
			}
			if (DebugTool.autoTraceCMDR){
				DebugTool.traceCMDR();
			}
			if (DebugTool.autoTraceEnable){
				DebugTool.traceDisMouseEnable(DebugTool.target);
			}
		}

		DebugTool.traceDisMouseEnable=function(tar){
			console.log("traceDisMouseEnable:");
			if (!tar)
				tar=DebugTool.target;
			if (!tar){
				console.log("no targetAvalible");
				return null;
			};
			var strArr;
			strArr=["TraceDisMouseEnable"];
			DebugTool.selectedNodes=[];
			while (tar){
				strArr.push(ClassTool.getNodeClassAndName(tar)+":"+tar.mouseEnabled+" hitFirst:"+tar.hitTestPrior);
				DebugTool.selectedNodes.push(tar);
				tar=tar.parent;
			}
			DebugTool.showSelected();
			return strArr.join("\n");
		}

		DebugTool.traceDisSizeChain=function(tar){
			console.log("traceDisSizeChain:");
			if (!tar)
				tar=DebugTool.target;
			if (!tar){
				console.log("no targetAvalible");
				return null;
			}
			DebugTool.selectedNodes=[];
			var strArr;
			strArr=["traceDisSizeChain"];
			while (tar){
				DebugTool.dTrace(TraceTool.getClassName(tar)+":");
				strArr.push(ClassTool.getNodeClassAndName(tar)+":");
				strArr.push("Size: x:"+tar.x+" y:"+tar.y+" w:"+tar.width+" h:"+tar.height+" scaleX:"+tar.scaleX+" scaleY:"+tar.scaleY);
				TraceTool.traceSize(tar);
				DebugTool.selectedNodes.push(tar);
				tar=tar.parent;
			}
			DebugTool.showSelected();
			return strArr.join("\n");
		}

		DebugTool.showDisBound=function(sprite,clearPre,color){
			(clearPre===void 0)&& (clearPre=true);
			(color===void 0)&& (color="#ff0000");
			if (!sprite)
				sprite=DebugTool.target;
			if (!sprite){
				console.log("no targetAvalible");
				return null;
			}
			if (clearPre)
				DebugTool.clearDebugLayer();
			var pointList;
			pointList=sprite._getBoundPointsM(true);
			if (!pointList || pointList.length < 1)
				return;
			pointList=GrahamScan.pListToPointList(pointList,true);
			WalkTools.walkArr(pointList,sprite.localToGlobal,sprite);
			pointList=GrahamScan.pointListToPlist(pointList);
			DebugTool._disBoundRec=Rectangle._getWrapRec(pointList,DebugTool._disBoundRec);
			DebugTool.debugLayer.graphics.drawRect(DebugTool._disBoundRec.x,DebugTool._disBoundRec.y,DebugTool._disBoundRec.width,DebugTool._disBoundRec.height,null,color);
			DebugInfoLayer.I.setTop();
		}

		DebugTool.showDisBoundToSprite=function(sprite,graphicSprite,color,lineWidth){
			(color===void 0)&& (color="#ff0000");
			(lineWidth===void 0)&& (lineWidth=1);
			var pointList;
			pointList=sprite._getBoundPointsM(true);
			if (!pointList || pointList.length < 1)
				return;
			pointList=GrahamScan.pListToPointList(pointList,true);
			WalkTools.walkArr(pointList,sprite.localToGlobal,sprite);
			pointList=GrahamScan.pointListToPlist(pointList);
			DebugTool._disBoundRec=Rectangle._getWrapRec(pointList,DebugTool._disBoundRec);
			graphicSprite.graphics.drawRect(DebugTool._disBoundRec.x,DebugTool._disBoundRec.y,DebugTool._disBoundRec.width,DebugTool._disBoundRec.height,null,color,lineWidth);
		}

		DebugTool.getNodeInfo=function(){
			DebugTool.counter.reset();
			WalkTools.walkTarget(Laya.stage,DebugTool.addNodeInfo);
			console.log("node info:");
			DebugTool.counter.traceSelf();
			return DebugTool.counter.data;
		}

		DebugTool.findByClass=function(className){
			DebugTool._classList=[];
			DebugTool._tFindClass=className;
			WalkTools.walkTarget(Laya.stage,DebugTool.addClassNode);
			DebugTool.selectedNodes=DebugTool._classList;
			DebugTool.showSelected();
			return DebugTool._classList;
		}

		DebugTool.addClassNode=function(node){
			var type;
			type=node["constructor"].name;
			if (type==DebugTool._tFindClass){
				DebugTool._classList.push(node);
			}
		}

		DebugTool.traceCMD=function(sprite){
			if (!sprite)
				sprite=DebugTool.target;
			if (!sprite){
				console.log("no targetAvalible");
				return null;
			}
			console.log("self CMDs:");
			console.log(sprite.graphics.cmds);
			var renderSprite;
			renderSprite=RenderSprite.renders[sprite._renderType];
			console.log("renderSprite:",renderSprite);
			DebugTool._rSpList.length=0;
			while (renderSprite && renderSprite["_sign"] > 0){
				DebugTool._rSpList.push(DebugTool.cmdToTypeO[renderSprite["_sign"]]);
				renderSprite=renderSprite._next;
			}
			console.log("fun:",DebugTool._rSpList.join(","));
			DebugTool.counter.reset();
			DebugTool.addCMDs(sprite.graphics.cmds);
			DebugTool.counter.traceSelf();
			return DebugTool.counter.data;
		}

		DebugTool.addCMDs=function(cmds){
			WalkTools.walkArr(cmds,DebugTool.addCMD);
		}

		DebugTool.addCMD=function(cmd){
			DebugTool.counter.add(cmd.callee);
		}

		DebugTool.traceCMDR=function(sprite){
			if (!sprite)
				sprite=DebugTool.target;
			if (!sprite){
				console.log("no targetAvalible");
				return 0;
			}
			DebugTool.counter.reset();
			WalkTools.walkTarget(sprite,DebugTool.getCMdCount);
			console.log("cmds include children");
			DebugTool.counter.traceSelf();
			return DebugTool.counter.data;
		}

		DebugTool.getCMdCount=function(target){
			if (!target)
				return 0;
			if (! (target instanceof laya.display.Sprite ))
				return 0;
			if (!target.graphics.cmds)
				return 0;
			DebugTool.addCMDs(target.graphics.cmds);
			var rst=target.graphics.cmds.length;
			return rst;
		}

		DebugTool.addNodeInfo=function(node){
			var type;
			type=node["constructor"].name;
			DebugTool.counter.add(type);
		}

		DebugTool.find=function(filter,ifShowSelected){
			(ifShowSelected===void 0)&& (ifShowSelected=true);
			var rst;
			rst=DebugTool.findTarget(Laya.stage,filter);
			DebugTool.selectedNodes=rst;
			if (DebugTool.selectedNodes){
				DebugTool.target=DebugTool.selectedNodes[0];
			}
			if (ifShowSelected)
				DebugTool.showSelected();
			return rst;
		}

		DebugTool.findByName=function(name){
			DebugTool.nameFilter.name=name;
			return DebugTool.find(DebugTool.nameFilter);
		}

		DebugTool.findNameStartWith=function(startStr){
			DebugTool.nameFilter.name=DebugTool.getStartWithFun(startStr);
			return DebugTool.find(DebugTool.nameFilter);
		}

		DebugTool.findNameHas=function(hasStr,showSelected){
			(showSelected===void 0)&& (showSelected=true);
			DebugTool.nameFilter.name=DebugTool.getHasFun(hasStr);
			return DebugTool.find(DebugTool.nameFilter,showSelected);
		}

		DebugTool.getStartWithFun=function(startStr){
			var rst=function (str){
				if (!str)
					return false;
				if (str.indexOf(startStr)==0)
					return true;
				return false;
			};
			return rst;
		}

		DebugTool.getHasFun=function(hasStr){
			var rst=function (str){
				if (!str)
					return false;
				if (str.indexOf(hasStr)>=0)
					return true;
				return false;
			};
			return rst;
		}

		DebugTool.findTarget=function(target,filter){
			var rst=[];
			if (DebugTool.isFit(target,filter))
				rst.push(target);
			var i=0;
			var len=0;
			var tChild;
			len=target.numChildren;
			for (i=0;i < len;i++){
				tChild=target.getChildAt(i);
				if ((tChild instanceof laya.display.Sprite )){
					rst=rst.concat(DebugTool.findTarget(tChild,filter));
				}
			}
			return rst;
		}

		DebugTool.findClassHas=function(target,str){
			var rst=[];
			if (ClassTool.getClassName(target).indexOf(str)>=0)
				rst.push(target);
			var i=0;
			var len=0;
			var tChild;
			len=target.numChildren;
			for (i=0;i < len;i++){
				tChild=target.getChildAt(i);
				if ((tChild instanceof laya.display.Sprite )){
					rst=rst.concat(DebugTool.findClassHas(tChild,str));
				}
			}
			return rst;
		}

		DebugTool.isFit=function(tar,filter){
			if (!tar)
				return false;
			if (!filter)
				return true;
			if ((typeof filter=='function')){
				return (filter)(tar);
			};
			var key;
			for (key in filter){
				if ((typeof (filter[key])=='function')){
					if (!filter[key](tar[key]))
						return false;
				}
				else{
					if (tar[key] !=filter[key])
						return false;
				}
			}
			return true;
		}

		DebugTool.log=function(__args){
			var args=arguments;
			var arr;
			arr=DTrace.getArgArr(args);
			if (DebugTool._logFun!=null){
				DebugTool._logFun(arr.join(" "));
			}
		}

		DebugTool.enableCacheAnalyse=false;
		DebugTool.enableNodeCreateAnalyse=true;
		DebugTool._traceFun=null
		DebugTool.debugLayer=null
		DebugTool._target=null
		DebugTool.selectedNodes=[];
		DebugTool.autoShowSelected=true;
		DebugTool._showBound=true;
		DebugTool._disBoundRec=null
		DebugTool.autoTraceEnable=false;
		DebugTool.autoTraceBounds=false;
		DebugTool.autoTraceSize=false;
		DebugTool.autoTraceTree=true;
		DebugTool.autoTraceCMD=true;
		DebugTool.autoTraceCMDR=false;
		DebugTool.autoTraceSpriteInfo=true;
		DebugTool._classList=null
		DebugTool._tFindClass=null
		DebugTool._rSpList=[];
		DebugTool._logFun=null
		__static(DebugTool,
		['text',function(){return this.text=new Stat();},'cmdToTypeO',function(){return this.cmdToTypeO={
		};},'counter',function(){return this.counter=new CountTool();},'nameFilter',function(){return this.nameFilter={"name":"name"};}

		]);
		return DebugTool;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.debug.tools.Base64Atlas
	var Base64Atlas=(function(){
		function Base64Atlas(data,idKey){
			this.data=null;
			this.replaceO=null;
			this.idKey=null;
			this._loadedHandler=null;
			this.data=data;
			if (!idKey)idKey=Math.random()+"key";
			this.idKey=idKey;
			this.init();
		}

		__class(Base64Atlas,'laya.debug.tools.Base64Atlas');
		var __proto=Base64Atlas.prototype;
		//preLoad();
		__proto.init=function(){
			this.replaceO={};
			var key;
			for (key in this.data){
				this.replaceO[key]=this.idKey+"/"+key;
			}
		}

		__proto.getAdptUrl=function(url){
			return this.replaceO[url];
		}

		__proto.preLoad=function(completeHandler){
			this._loadedHandler=completeHandler;
			Laya.loader.load(Base64ImageTool.getPreloads(this.data),new Handler(this,this.preloadEnd));
		}

		__proto.preloadEnd=function(){
			var key;
			for (key in this.data){
				var tx;
				tx=Laya.loader.getRes(this.data[key]);
				Loader.cacheRes(this.replaceO[key],tx);
			}
			if (this._loadedHandler){
				this._loadedHandler.run();
			}
		}

		__proto.replaceRes=function(uiObj){
			ObjectTools.replaceValue(uiObj,this.replaceO);
		}

		return Base64Atlas;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.debug.tools.Base64ImageTool
	var Base64ImageTool=(function(){
		function Base64ImageTool(){}
		__class(Base64ImageTool,'laya.debug.tools.Base64ImageTool');
		Base64ImageTool.getCanvasPic=function(img){
			img=img.bitmap;
			var canvas=Browser.createElement("canvas");
			var ctx=canvas.getContext('2d');
			canvas.height=img.height;
			canvas.width=img.width;
			ctx.drawImage(img.source,0,0);
			return canvas;
		}

		Base64ImageTool.getBase64Pic=function(img){
			return Base64ImageTool.getCanvasPic(img).toDataURL("image/png");
		}

		Base64ImageTool.getPreloads=function(base64Data){
			var rst;
			rst=[];
			var key;
			for (key in base64Data){
				rst.push({url:base64Data[key],type:"image" });
			}
			return rst;
		}

		return Base64ImageTool;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.debug.tools.CacheAnalyser
	var CacheAnalyser=(function(){
		function CacheAnalyser(){}
		__class(CacheAnalyser,'laya.debug.tools.CacheAnalyser');
		var __proto=CacheAnalyser.prototype;
		__proto.renderCanvas=function(sprite,time){
			(time===void 0)&& (time=0);
			if (!CacheAnalyser.showCacheSprite)return;
			if (DebugInfoLayer.I.isDebugItem(sprite))return;
			DebugTool.showDisBoundToSprite(sprite,DebugInfoLayer.I.cacheViewLayer,"#ff0000",2);
		}

		__proto.reCacheCanvas=function(sprite,time){
			(time===void 0)&& (time=0);
			if (DebugInfoLayer.I.isDebugItem(sprite))return;
			var info;
			info=CacheAnalyser.getNodeInfoByNode(sprite);
			info.addCount(time);
			CacheAnalyser.counter.addTime(sprite,time);
			if (!info.parent){
				DebugInfoLayer.I.nodeRecInfoLayer.addChild(info);
			}
		}

		CacheAnalyser.renderLoopBegin=function(){
			DebugInfoLayer.I.cacheViewLayer.graphics.clear();
		}

		CacheAnalyser.getNodeInfoByNode=function(node){
			IDTools.idObj(node);
			var key=0;
			key=IDTools.getObjID(node);
			if (!CacheAnalyser._nodeInfoDic[key]){
				CacheAnalyser._nodeInfoDic[key]=new ReCacheRecInfo();
			}
			(CacheAnalyser._nodeInfoDic [key]).setTarget(node);
			return CacheAnalyser._nodeInfoDic[key];
		}

		CacheAnalyser._nodeInfoDic={};
		CacheAnalyser.showCacheSprite=false;
		__static(CacheAnalyser,
		['counter',function(){return this.counter=new ObjTimeCountTool();},'I',function(){return this.I=new CacheAnalyser();}
		]);
		return CacheAnalyser;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.debug.tools.CanvasTools
	var CanvasTools=(function(){
		function CanvasTools(){}
		__class(CanvasTools,'laya.debug.tools.CanvasTools');
		CanvasTools.createCanvas=function(width,height){
			var rst=new HTMLCanvas("2D");
			rst.getContext('2d');
			rst.size(width,height);
			return rst;
		}

		CanvasTools.renderSpriteToCanvas=function(sprite,canvas,offsetX,offsetY){
			RenderSprite.renders[sprite._renderType]._fun(sprite,canvas.context,offsetX,offsetY);
		}

		CanvasTools.getImageDataFromCanvas=function(canvas,x,y,width,height){
			(x===void 0)&& (x=0);
			(y===void 0)&& (y=0);
			(width===void 0)&& (width=0);
			(height===void 0)&& (height=0);
			if (width <=0)
				width=canvas.width;
			if (height <=0)
				height=canvas.height;
			var imgdata=canvas.context.getImageData(x,y,width,height);
			return imgdata;
		}

		CanvasTools.getImageDataFromCanvasByRec=function(canvas,rec){
			var imgdata=canvas.context.getImageData(rec.x,rec.y,rec.width,rec.height);
			return imgdata;
		}

		CanvasTools.getDifferCount=function(imageData1,imageData2){
			var data1=imageData1.data;
			var data2=imageData2.data;
			var differCount=0;
			differCount=0;
			CanvasTools.walkImageData(imageData1,myWalkFun);
			return differCount;
			function myWalkFun (i,j,tarPos,data){
				if (!CanvasTools.isPoinSame(tarPos,data1,data2))differCount++;
			}
		}

		CanvasTools.getDifferRate=function(imageData1,imageData2){
			return CanvasTools.getDifferCount(imageData1,imageData2)/(imageData1.width *imageData1.height);
		}

		CanvasTools.getCanvasDisRec=function(canvas){
			var rst;
			rst=new Rectangle;
			var imgdata;
			imgdata=CanvasTools.getImageDataFromCanvas(canvas,0,0);
			var maxX=0;
			var minX=0;
			var maxY=0;
			var minY=0;
			maxX=maxY=0;
			minX=imgdata.width;
			minY=imgdata.height;
			var i=0,iLen=0;
			var j=0,jLen=0;
			iLen=imgdata.width;
			jLen=imgdata.height;
			var data;
			data=imgdata.data;
			var tarPos=0;
			for (j=0;j < jLen;j++){
				for (i=0;i < iLen;i++){
					if (!CanvasTools.isEmptyPoint(data,tarPos)){
						if (minX > i)
							minX=i;
						if (maxX < i)
							maxX=i;
						if (minY > j)
							minY=j;
						if (maxY < j)
							maxY=j;
					}
					tarPos+=4;
				}
			}
			rst.setTo(minX,minY,maxX-minX+1,maxY-minY+1);
			return rst;
		}

		CanvasTools.fillCanvasRec=function(canvas,rec,color){
			var ctx=canvas.context;
			ctx.fillStyle=color;
			ctx.fillRect(rec.x,rec.y,rec.width,rec.height);
		}

		CanvasTools.isEmptyPoint=function(data,pos){
			if (data[pos]==0 && data[pos+1]==0 && data[pos+2]==0 && data[pos+3]==0){
				return true;
			}
			else{
				return false;
			}
		}

		CanvasTools.isPoinSame=function(pos,data1,data2){
			if (data1[pos]==data2[pos] && data1[pos+1]==data2[pos+1] && data1[pos+2]==data2[pos+2] && data1[pos+3]==data2[pos+3]){
				return true;
			}
			else{
				return false;
			}
		}

		CanvasTools.walkImageData=function(imgdata,walkFun){
			var i=0,iLen=0;
			var j=0,jLen=0;
			iLen=imgdata.width;
			jLen=imgdata.height;
			var tarPos=0;
			var data=imgdata.data;
			for (i=0;i < iLen;i++){
				for (j=0;j < jLen;j++){
					walkFun(i,j,tarPos,data);
					tarPos+=4;
				}
			}
		}

		CanvasTools.getSpriteByCanvas=function(canvas){
			var rst;
			rst=new Sprite();
			rst.graphics.drawTexture(new Texture(canvas),0,0,canvas.width,canvas.height);
			return rst;
		}

		CanvasTools.renderSpritesToCanvas=function(canvas,sprites,offx,offy,startIndex){
			(offx===void 0)&& (offx=0);
			(offy===void 0)&& (offy=0);
			(startIndex===void 0)&& (startIndex=0);
			var i=0,len=0;
			len=sprites.length;
			for (i=startIndex;i < len;i++){
				CanvasTools.renderSpriteToCanvas(sprites[i],canvas,offx,offy);
			}
		}

		CanvasTools.clearCanvas=function(canvas){
			var preWidth=NaN;
			var preHeight=NaN;
			preWidth=canvas.width;
			preHeight=canvas.height;
			canvas.size(preWidth+1,preHeight);
			canvas.size(preWidth,preHeight);
		}

		return CanvasTools;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-10-23 下午2:24:04
	*/
	//class laya.debug.tools.ClassTool
	var ClassTool=(function(){
		function ClassTool(){}
		__class(ClassTool,'laya.debug.tools.ClassTool');
		ClassTool.defineProperty=function(obj,name,des){
			Object.defineProperty(obj,name,des);;
		}

		ClassTool.getOwnPropertyDescriptor=function(obj,name){
			var rst;
			rst=Object.getOwnPropertyDescriptor(obj,name);;
			return rst;
		}

		ClassTool.getOwnPropertyNames=function(obj){
			var rst;
			rst=Object.getOwnPropertyNames(obj);;
			return rst;
		}

		ClassTool.getClassName=function(tar){
			if ((typeof tar=='function'))return tar.name;
			return tar["constructor"].name;
		}

		ClassTool.getNodeClassAndName=function(tar){
			if (!tar)return "null";
			var rst;
			if (tar.name){
				rst=ClassTool.getClassName(tar)+"("+tar.name+")";
				}else{
				rst=ClassTool.getClassName(tar);
			}
			return rst;
		}

		ClassTool.getClassNameByClz=function(clz){
			return clz["name"];
		}

		ClassTool.getClassByName=function(className){
			var rst;
			rst=eval(className);
			return rst;
		}

		ClassTool.createObjByName=function(className){
			var clz;
			clz=ClassTool.getClassByName(className);
			return new clz();
		}

		return ClassTool;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.debug.tools.ColorTool
	var ColorTool=(function(){
		function ColorTool(){
			this.red=NaN;
			this.green=NaN;
			this.blue=NaN;
		}

		__class(ColorTool,'laya.debug.tools.ColorTool');
		ColorTool.toHexColor=function(color){
			return Utils.toHexColor(color);
		}

		ColorTool.getRGBByRGBStr=function(str){
			str.charAt(0)=='#' && (str=str.substr(1));
			var color=parseInt(str,16);
			var flag=(str.length==8);
			var _color;
			_color=[((0x00FF0000 & color)>> 16),((0x0000FF00 & color)>> 8),(0x000000FF & color)];
			return _color;
		}

		ColorTool.getColorBit=function(value){
			var rst;
			rst=Math.floor(value).toString(16);
			rst=rst.length > 1 ? rst :"0"+rst;
			return rst;
		}

		ColorTool.getRGBStr=function(rgb){
			return "#"+ColorTool.getColorBit(rgb[0])+ColorTool.getColorBit(rgb[1])+ColorTool.getColorBit(rgb[2]);
		}

		ColorTool.traseHSB=function(hsb){
			console.log("hsb:",hsb[0],hsb[1],hsb[2]);
		}

		ColorTool.rgb2hsb=function(rgbR,rgbG,rgbB){
			var rgb=[rgbR,rgbG,rgbB];
			rgb.sort(MathTools.sortNumSmallFirst);
			var max=rgb[2];
			var min=rgb[0];
			var hsbB=max / 255.0;
			var hsbS=max==0 ? 0 :(max-min)/ max;
			var hsbH=0;
			if(max==min){
				hsbH=1;
			}
			else
			if (rgbR==0 && rgbG==0&&rgbB==0){
			}else
			if (max==rgbR && rgbG >=rgbB){
				hsbH=(rgbG-rgbB)*60 / (max-min)+0;
			}
			else if (max==rgbR && rgbG < rgbB){
				hsbH=(rgbG-rgbB)*60 / (max-min)+360;
			}
			else if (max==rgbG){
				hsbH=(rgbB-rgbR)*60 / (max-min)+120;
			}
			else if (max==rgbB){
				hsbH=(rgbR-rgbG)*60 / (max-min)+240;
			}
			return [hsbH,hsbS,hsbB];
		}

		ColorTool.hsb2rgb=function(h,s,v){
			var r=0,g=0,b=0;
			var i=Math.floor((h / 60)% 6);
			var f=(h / 60)-i;
			var p=v *(1-s);
			var q=v *(1-f *s);
			var t=v *(1-(1-f)*s);
			switch (i){
				case 0:
					r=v;
					g=t;
					b=p;
					break ;
				case 1:
					r=q;
					g=v;
					b=p;
					break ;
				case 2:
					r=p;
					g=v;
					b=t;
					break ;
				case 3:
					r=p;
					g=q;
					b=v;
					break ;
				case 4:
					r=t;
					g=p;
					b=v;
					break ;
				case 5:
					r=v;
					g=p;
					b=q;
					break ;
				default :
					break ;
				}
			return [Math.floor(r *255.0),Math.floor(g *255.0),Math.floor(b *255.0)];
		}

		return ColorTool;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-9-24 下午6:37:56
	*/
	//class laya.debug.tools.CountTool
	var CountTool=(function(){
		function CountTool(){
			this.data={};
			this.preO={};
			this.changeO={};
			this.count=0;
		}

		__class(CountTool,'laya.debug.tools.CountTool');
		var __proto=CountTool.prototype;
		__proto.reset=function(){
			this.data={};
			this.count=0;
		}

		__proto.add=function(name,num){
			(num===void 0)&& (num=1);
			this.count++;
			if(!this.data.hasOwnProperty(name)){
				this.data[name]=0;
			}
			this.data[name]=this.data[name]+num;
		}

		__proto.getKeyCount=function(key){
			if(!this.data.hasOwnProperty(key)){
				this.data[key]=0;
			}
			return this.data[key];
		}

		__proto.getKeyChange=function(key){
			if (!this.changeO[key])return 0;
			return this.changeO[key];
		}

		__proto.record=function(){
			var key;
			for (key in this.changeO){
				this.changeO[key]=0;
			}
			for (key in this.data){
				if (!this.preO[key])this.preO[key]=0;
				this.changeO[key]=this.data[key]-this.preO[key];
				this.preO[key]=this.data[key]
			}
		}

		__proto.getCount=function(dataO){
			var rst=0;
			var key;
			for (key in dataO){
				rst+=dataO[key];
			}
			return rst;
		}

		__proto.traceSelf=function(dataO){
			if (!dataO)dataO=this.data;
			var tCount=0;
			tCount=this.getCount(dataO);
			console.log("total:"+tCount);
			return "total:"+tCount+"\n"+TraceTool.traceObj(dataO);
		}

		__proto.traceSelfR=function(dataO){
			if (!dataO)dataO=this.data;
			var tCount=0;
			tCount=this.getCount(dataO);
			console.log("total:"+tCount);
			return "total:"+tCount+"\n"+TraceTool.traceObjR(dataO);
		}

		return CountTool;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-10-31 下午3:35:16
	*/
	//class laya.debug.tools.DebugExport
	var DebugExport=(function(){
		function DebugExport(){}
		__class(DebugExport,'laya.debug.tools.DebugExport');
		DebugExport.export=function(){
			var _window;
			_window=window;;
			var key;
			for(key in DebugExport._exportsDic){
				_window[key]=DebugExport._exportsDic[key];
			}
		}

		__static(DebugExport,
		['_exportsDic',function(){return this._exportsDic={
				"DebugTool":DebugTool,
				"Watcher":Watcher
		};}

		]);
		return DebugExport;
	})()


	/**
	*本类用于显示对象值变化过程
	*@author ww
	*@version 1.0
	*
	*@created 2015-10-23 上午10:41:50
	*/
	//class laya.debug.tools.DifferTool
	var DifferTool=(function(){
		function DifferTool(sign,autoTrace){
			this.autoTrace=true;
			this.sign="";
			this.obj=null;
			(sign===void 0)&& (sign="");
			(autoTrace===void 0)&& (autoTrace=true);
			this.sign=sign;
			this.autoTrace=autoTrace;
		}

		__class(DifferTool,'laya.debug.tools.DifferTool');
		var __proto=DifferTool.prototype;
		__proto.update=function(data,msg){
			if(msg){
				console.log(msg);
			};
			var tObj=ObjectTools.copyObj(data);
			if(!this.obj)this.obj={};
			var rst;
			rst=ObjectTools.differ(this.obj,tObj);
			this.obj=tObj;
			if(this.autoTrace){
				console.log(this.sign+" differ:");
				ObjectTools.traceDifferObj(rst);
			}
			return rst;
		}

		DifferTool.differ=function(sign,data,msg){
			if(!DifferTool._differO[sign])DifferTool._differO[sign]=new DifferTool(sign,true);
			var tDiffer;
			tDiffer=DifferTool._differO[sign];
			return tDiffer.update(data,msg);
		}

		DifferTool._differO={};
		return DifferTool;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-1-14 下午4:32:47
	*/
	//class laya.debug.tools.DisController
	var DisController=(function(){
		function DisController(){
			this.arrowAxis=null;
			this._target=null;
			this.recInfo=null;
			DisController.init();
			this.arrowAxis=new Axis();
			this.arrowAxis.mouseEnabled=true;
		}

		__class(DisController,'laya.debug.tools.DisController');
		var __proto=DisController.prototype;
		__proto.switchType=function(){
			this.arrowAxis.switchType();
		}

		__proto.updateMe=function(){
			if(!this._target)return;
			this.recInfo=RecInfo.getGlobalRecInfo(this._target,0,0,1,0,0,1);
			console.log("rotation:",this.recInfo.rotation);
			console.log("pos:",this.recInfo.x,this.recInfo.y);
			console.log("scale:",this.recInfo.width,this.recInfo.height);
			this.arrowAxis.x=this.recInfo.x;
			this.arrowAxis.y=this.recInfo.y;
			this.arrowAxis.rotation=this.recInfo.rotation;
			this.arrowAxis.yAxis.rotation=this.recInfo.rotationV-this.recInfo.rotation;
		}

		__getset(0,__proto,'target',function(){
			return this._target;
			},function(target){
			this._target=target;
			if(target){
				DisController._container.addChild(this.arrowAxis);
				Laya.timer.loop(100,this,this.updateMe);
				}else{
				this.arrowAxis.removeSelf();
				Laya.timer.clear(this,this.updateMe);
			}
			this.arrowAxis.target=target;
			this.updateMe();
		});

		__getset(0,__proto,'type',function(){
			return this.arrowAxis.type;
			},function(lenType){
			this.arrowAxis.type=lenType;
		});

		DisController.init=function(){
			if (DisController._container){
				DisControlTool.setTop(DisController._container);
				return;
			};
			DisController._container=new Sprite();
			DisController._container.mouseEnabled=true;
			Laya.stage.addChild(DisController._container);
		}

		DisController._container=null
		__static(DisController,
		['I',function(){return this.I=new DisController();}
		]);
		return DisController;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-9-25 下午7:19:44
	*/
	//class laya.debug.tools.DisControlTool
	var DisControlTool=(function(){
		function DisControlTool(){}
		__class(DisControlTool,'laya.debug.tools.DisControlTool');
		DisControlTool.getObjectsUnderPoint=function(sprite,x,y,rst,filterFun){
			rst=rst?rst:[];
			if(filterFun!=null&&!filterFun(sprite))return rst;
			if (sprite.getBounds().contains(x,y)){
				rst.push(sprite);
				var tS;
				var tempP=new Point();
				tempP.setTo(x,y);
				tempP=sprite.fromParentPoint(tempP);
				x=tempP.x;
				y=tempP.y;
				for (var i=sprite._childs.length-1;i >-1;i--){
					var child=sprite._childs[i];
					if((child instanceof laya.display.Sprite ))
						DisControlTool.getObjectsUnderPoint(child,x,y,rst,filterFun);
				}
			}
			return rst;
		}

		DisControlTool.getObjectsUnderGlobalPoint=function(sprite,filterFun){
			var point=new Point();
			point.setTo(Laya.stage.mouseX,Laya.stage.mouseY);
			if(sprite.parent)
				point=(sprite.parent).globalToLocal(point);
			return DisControlTool.getObjectsUnderPoint(sprite,point.x,point.y,null,filterFun);
		}

		DisControlTool.findFirstObjectsUnderGlobalPoint=function(){
			var disList;
			disList=DisControlTool.getObjectsUnderGlobalPoint(Laya.stage);
			if (!disList)return null;
			var i=0,len=0;
			var tDis;
			len=disList.length;
			for (i=len-1;i>=0;i--){
				tDis=disList[i];
				if (tDis && tDis.numChildren < 1){
					return tDis;
				}
			}
			return tDis;
		}

		DisControlTool.visibleAndEnableObjFun=function(tar){
			return tar.visible&&tar.mouseEnabled;
		}

		DisControlTool.visibleObjFun=function(tar){
			return tar.visible;
		}

		DisControlTool.getMousePoint=function(sprite){
			var point=new Point();
			point.setTo(Laya.stage.mouseX,Laya.stage.mouseY);
			point=sprite.globalToLocal(point);
			return point;
		}

		DisControlTool.isChildE=function(parent,child){
			if (!parent)return false;
			while (child){
				if (child.parent==parent)return true;
				child=child.parent;
			}
			return false;
		}

		DisControlTool.isInTree=function(pNode,child){
			return pNode==child || DisControlTool.isChildE(pNode,child);
		}

		DisControlTool.setTop=function(tar){
			if(tar&&tar.parent){
				var tParent;
				tParent=tar.parent;
				tParent.setChildIndex(tar,tParent.numChildren-1);
			}
		}

		DisControlTool.clearItemRelativeInfo=function(item){
			var Nan="NaN";
			item.getLayout().left=Nan;
			item.getLayout().right=Nan;
			item.getLayout().top=Nan;
			item.getLayout().bottom=Nan;
		}

		DisControlTool.swap=function(tarA,tarB){
			if (tarA==tarB)return;
			var iA=0;
			iA=tarA.parent.getChildIndex(tarA);
			var iB=0;
			iB=tarB.parent.getChildIndex(tarB);
			var bP;
			bP=tarB.parent;
			tarA.parent.addChildAt(tarB,iA);
			bP.addChildAt(tarA,iB);
		}

		DisControlTool.insertToTarParent=function(tarA,tars,after){
			(after===void 0)&& (after=false);
			var tIndex=0;
			var parent;
			if(!tarA)return;
			parent=tarA.parent;
			if(!parent)return;
			tIndex=parent.getChildIndex(tarA);
			if(after)tIndex++;
			DisControlTool.insertToParent(parent,tars,tIndex);
		}

		DisControlTool.insertToParent=function(parent,tars,index){
			(index===void 0)&& (index=-1);
			if(!parent)return;
			if(index<0)index=parent.numChildren;
			var i=0,len=0;
			len=tars.length;
			for(i=0;i<len;i++){
				DisControlTool.transParent(tars[i],parent);
				parent.addChildAt(tars[i],index);
			}
		}

		DisControlTool.transParent=function(tar,newParent){
			if(!tar||!newParent)return;
			if(!tar.parent)return;
			var preParent;
			preParent=tar.parent;
			var pos;
			pos=new Point(tar.x,tar.y);
			pos=preParent.localToGlobal(pos);
			pos=newParent.globalToLocal(pos);
			tar.pos(pos.x,pos.y);
		}

		DisControlTool.transPoint=function(nowParent,tarParent,point){
			point=nowParent.localToGlobal(point);
			point=tarParent.globalToLocal(point);
			return point;
		}

		DisControlTool.removeItems=function(itemList){
			var i=0,len=0;
			len=itemList.length;
			for (i=0;i < len;i++){
				(itemList [i]).removeSelf();
			}
		}

		DisControlTool.addItems=function(itemList,parent){
			var i=0,len=0;
			len=itemList.length;
			for (i=0;i < len;i++){
				parent.addChild(itemList[i]);
			}
		}

		DisControlTool.getAllChild=function(tar){
			if(!tar)return [];
			var i=0;
			var len=0;
			var rst=[];
			len=tar.numChildren;
			for(i=0;i<len;i++){
				rst.push(tar.getChildAt(i));
			}
			return rst;
		}

		DisControlTool.upDis=function(child){
			if(child&&child.parent){
				var tParent;
				tParent=child.parent;
				var newIndex=0;
				newIndex=tParent.getChildIndex(child)+1;
				if(newIndex>=tParent.numChildren){
					newIndex=tParent.numChildren-1;
				}
				console.log("setChildIndex:"+newIndex);
				tParent.setChildIndex(child,newIndex);
			}
		}

		DisControlTool.downDis=function(child){
			if(child&&child.parent){
				var tParent;
				tParent=child.parent;
				var newIndex=0;
				newIndex=tParent.getChildIndex(child)-1;
				if(newIndex<0)newIndex=0;
				console.log("setChildIndex:"+newIndex);
				tParent.setChildIndex(child,newIndex);
			}
		}

		DisControlTool.setResizeAbleEx=function(node){
			var clickItem;
			clickItem=node.getChildByName("resizeBtn");
			if (clickItem){
				SimpleResizer.setResizeAble(clickItem,node);
			}
		}

		DisControlTool.setResizeAble=function(node){
			node.on("click",null,DisControlTool.resizeHandler,[node]);
		}

		DisControlTool.resizeHandler=function(tar){
			DisResizer.setUp(tar);
		}

		DisControlTool.setDragingItem=function(dragBar,tar){
			dragBar.on("mousedown",null,DisControlTool.dragingHandler,[tar]);
			tar.on("dragend",null,DisControlTool.dragingEnd,[tar]);
		}

		DisControlTool.dragingHandler=function(tar){
			if (tar){
				tar.startDrag();
			}
		}

		DisControlTool.dragingEnd=function(tar){
			DisControlTool.intFyDisPos(tar);
			console.log(tar.x,tar.y);
		}

		DisControlTool.showToStage=function(dis,offX,offY){
			(offX===void 0)&& (offX=0);
			(offY===void 0)&& (offY=0);
			var rec=dis.getBounds();
			dis.x=Laya.stage.mouseX+offX;
			dis.y=Laya.stage.mouseY+offY;
			if (dis.x+rec.width > Laya.stage.width){
				dis.x-=rec.width+offX;
			}
			if (dis.y+rec.height > Laya.stage.height){
				dis.y-=rec.height+offY;
			}
			DisControlTool.intFyDisPos(dis);
		}

		DisControlTool.intFyDisPos=function(dis){
			if (!dis)return;
			dis.x=Math.round(dis.x);
			dis.y=Math.round(dis.y);
		}

		DisControlTool.showOnly=function(disList,showItem){
			var i=0,len=0;
			len=disList.length;
			for (i=0;i < len;i++){
				disList[i].visible=disList[i]==showItem;
			}
		}

		DisControlTool.showOnlyByIndex=function(disList,index){
			DisControlTool.showOnly(disList,disList[index]);
		}

		DisControlTool.addOnly=function(disList,showItem,parent){
			var i=0,len=0;
			len=disList.length;
			for (i=0;i < len;i++){
				if (disList[i] !=showItem){
					disList[i].removeSelf();
					}else{
					parent.addChild(disList[i]);
				}
			}
		}

		DisControlTool.addOnlyByIndex=function(disList,index,parent){
			DisControlTool.addOnly(disList,disList[index],parent);
		}

		__static(DisControlTool,
		['tempP',function(){return this.tempP=new Point();}
		]);
		return DisControlTool;
	})()


	/**
	*调试拾取显示对象类
	*@author ww
	*/
	//class laya.debug.tools.DisplayHook
	var DisplayHook=(function(){
		function DisplayHook(){
			this.mouseX=NaN;
			this.mouseY=NaN;
			this._stage=null;
			this._target=null;
			this.isGetting=false;
			this._matrix=new Matrix();
			this._point=new Point();
			this._rect=new Rectangle();
			this._event=Event.EMPTY;
			this._stage=Laya.stage;
			this.init(Render.context.canvas);
		}

		__class(DisplayHook,'laya.debug.tools.DisplayHook');
		var __proto=DisplayHook.prototype;
		__proto.init=function(canvas){
			var _$this=this;
			if (Browser.window.navigator.msPointerEnabled){
				canvas.style['-ms-content-zooming']='none';
				canvas.style['-ms-touch-action']='none';
			};
			var _this=this;
			Browser.document.addEventListener('mousedown',function(e){
				_$this._event._stoped=false;
				DisplayHook.isFirst=true;
				_this.check(_this._stage,e.offsetX,e.offsetY,_this.onMouseDown,true,false);
			},true);
			Browser.document.addEventListener('touchstart',function(e){
				_$this._event._stoped=false;
				DisplayHook.isFirst=true;
				var touches=e.changedTouches;
				for (var i=0,n=touches.length;i < n;i++){
					var touch=touches[i];
					initEvent(touch,e);
					_this.check(_this._stage,_this.mouseX,_this.mouseY,_this.onMouseDown,true,false);
				}
			},true);
			function initEvent (e,event){
				_this._event._stoped=false;
				_this._event.nativeEvent=event || e;
				_this._target=null;
				if (e.offsetX){
					_this.mouseX=e.offsetX;
					_this.mouseY=e.offsetY;
					}else {
					_this.mouseX=e.clientX-Laya.stage.offset.x;
					_this.mouseY=e.clientY-Laya.stage.offset.y;
				}
			}
		}

		__proto.onMouseMove=function(ele,hit){
			this.sendEvent(ele,"mousemove");
			return;
			if (hit && ele !=this._stage && ele!==this._target){
				if (this._target){
					if (this._target.$_MOUSEOVER){
						this._target.$_MOUSEOVER=false;
						this._target.event("mouseout");
					}
				}
				this._target=ele;
				if (!ele.$_MOUSEOVER){
					ele.$_MOUSEOVER=true;
					this.sendEvent(ele,"mouseover");
				}
				}else if (!hit && this._target && ele===this._target){
				this._target=null;
				if (ele.$_MOUSEOVER){
					ele.$_MOUSEOVER=false;
					this.sendEvent(ele,"mouseout");
				}
			}
		}

		__proto.onMouseUp=function(ele,hit){
			hit && this.sendEvent(ele,"mouseup");
		}

		__proto.onMouseDown=function(ele,hit){
			if (hit){
				ele.$_MOUSEDOWN=true;
				this.sendEvent(ele,"mousedown");
			}
		}

		__proto.sendEvent=function(ele,type){
			if (!this._event._stoped){
				ele.event(type,this._event.setTo(type,ele,ele));
				if (type==="mouseup" && ele.$_MOUSEDOWN){
					ele.$_MOUSEDOWN=false;
					ele.event("click",this._event.setTo("click",ele,ele));
				}
			}
		}

		__proto.selectDisUnderMouse=function(){
			DisplayHook.isFirst=true;
			this.check(Laya.stage,Laya.stage.mouseX,Laya.stage.mouseY,null,true,false);
			SelectInfosView.I.setSelectTarget(DebugTool.target);
		}

		__proto.getDisUnderMouse=function(){
			this.isGetting=true;
			DisplayHook.isFirst=true;
			DebugTool.target=null;
			this.check(Laya.stage,Laya.stage.mouseX,Laya.stage.mouseY,null,true,false);
			this.isGetting=false;
			return DebugTool.target;
		}

		__proto.check=function(sp,mouseX,mouseY,callBack,hitTest,mouseEnable){
			if (sp==DebugTool.debugLayer)return false;
			if (sp==DebugInfoLayer.I)return false;
			if (this.isGetting && sp==DebugInfoLayer.I)return false;
			if (!sp.visible || sp.getSelfBounds().width<=0)return false;
			var isHit=false;
			mouseEnable=true
			if (mouseEnable){
				var graphicHit=false;
				if (hitTest){
					this._rect=sp.getBounds();
					isHit=this._rect.contains(mouseX,mouseY);
					this._point.setTo(mouseX,mouseY);
					sp.fromParentPoint(this._point);
					mouseX=this._point.x;
					mouseY=this._point.y;
				}
				if (isHit){
					var flag=false;
					for (var i=sp._childs.length-1;i >-1;i--){
						var child=sp._childs[i];
						(flag=this.check(child,mouseX,mouseY,callBack,hitTest,true));
						if (flag)break ;
					}
					graphicHit=sp.getGraphicBounds().contains(mouseX,mouseY);
					isHit=flag||graphicHit;
					if(isHit&&!flag&&DisplayHook.isFirst){
						DisplayHook.isFirst=false;
						if(! ((sp instanceof laya.debug.tools.debugUI.DButton ))){
							DebugTool.target=sp;
							if (!this.isGetting){
								DebugTool.autoWork();
								Notice.notify("ItemClicked",sp);
							}
						}
					}
				}
			}
			return isHit;
		}

		DisplayHook.initMe=function(){
			if(!DisplayHook.instance){
				DisplayHook.instance=new DisplayHook();
			}
		}

		DisplayHook.ITEM_CLICKED="ItemClicked";
		DisplayHook.instance=null
		DisplayHook.isFirst=false;
		return DisplayHook;
	})()


	/**
	*简单的显示对象对象池
	*从父容器上移除时即被视为可被重用
	*@author ww
	*@version 1.0
	*
	*@created 2015-11-13 下午8:05:13
	*/
	//class laya.debug.tools.DisPool
	var DisPool=(function(){
		function DisPool(){}
		__class(DisPool,'laya.debug.tools.DisPool');
		DisPool.getDis=function(clz){
			var clzName;
			clzName=ClassTool.getClassNameByClz(clz);
			if(!DisPool._objDic[clzName]){
				DisPool._objDic[clzName]=[];
			};
			var disList;
			disList=DisPool._objDic[clzName];
			var i=0,len=0;
			len=disList.length;
			for(i=0;i<len;i++){
				if(!disList[i].parent){
					return disList[i];
				}
			}
			disList.push(new clz());
			return disList[disList.length-1];
		}

		DisPool._objDic={};
		return DisPool;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-9-28 上午10:39:47
	*/
	//class laya.debug.tools.DTrace
	var DTrace=(function(){
		function DTrace(){}
		__class(DTrace,'laya.debug.tools.DTrace');
		DTrace.getArgArr=function(arg){
			var rst;
			rst=[];
			var i=0,len=arg.length;
			for(i=0;i<len;i++){
				rst.push(arg[i]);
			}
			return rst;
		}

		DTrace.dTrace=function(__arg){
			var arg=arguments;
			arg=DTrace.getArgArr(arg);
			arg.push(TraceTool.getCallLoc(2));
			console.log.apply(console,arg);
			var str;
			str=arg.join(" ");
		}

		DTrace.timeStart=function(sign){
			console.time(sign);;
		}

		DTrace.timeEnd=function(sign){
			console.timeEnd(sign);;
		}

		DTrace.traceTable=function(data){
			console.table(data);;
		}

		return DTrace;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.debug.tools.enginehook.ClassCreateHook
	var ClassCreateHook=(function(){
		function ClassCreateHook(){
			this.createInfo={};
		}

		__class(ClassCreateHook,'laya.debug.tools.enginehook.ClassCreateHook');
		var __proto=ClassCreateHook.prototype;
		__proto.hookClass=function(clz){
			var _$this=this;
			var createFun=function (sp){
				_$this.classCreated(sp,clz);
			}
			FunHook.hook(clz,"call",createFun);
		}

		__proto.classCreated=function(clz,oClass){
			var key;
			key=ClassTool.getNodeClassAndName(clz);
			var depth=0;
			var tClz;
			tClz=clz;
			while (tClz && tClz !=oClass){
				tClz=tClz.__super;
				depth++;
			}
			if (!ClassCreateHook.I.createInfo[key]){
				ClassCreateHook.I.createInfo[key]=0;
			}
			ClassCreateHook.I.createInfo[key]=ClassCreateHook.I.createInfo[key]+1;
			RunProfile.run(key,depth+6);
		}

		__proto.getClassCreateInfo=function(clz){
			var key;
			key=ClassTool.getClassName(clz);
			return RunProfile.getRunInfo(key);
		}

		__static(ClassCreateHook,
		['I',function(){return this.I=new ClassCreateHook();}
		]);
		return ClassCreateHook;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.debug.tools.enginehook.RenderSpriteHook
	var RenderSpriteHook=(function(){
		function RenderSpriteHook(){
			//this._next=null;
			//this._fun=null;
			//this._oldCanvas=null;
		}

		__class(RenderSpriteHook,'laya.debug.tools.enginehook.RenderSpriteHook');
		var __proto=RenderSpriteHook.prototype;
		__proto.createRenderSprite=function(type,next){
			var rst;
			rst=RenderSpriteHook._preCreateFun(type,next);
			if (type==0x10){
				rst["_oldCanvas"]=rst._fun;
				rst._fun=RenderSpriteHook.I._canvas;
			}
			return rst;
		}

		__proto._canvas=function(sprite,context,x,y){
			if (!SpriteRenderForVisibleAnalyse.allowRendering)return;
			var _cacheCanvas=sprite._$P.cacheCanvas;
			var _next=this._next;
			if (!_cacheCanvas||SpriteRenderForVisibleAnalyse.isVisibleTesting){
				_next._fun.call(_next,sprite,context,x,y);
				return;
			};
			var preTime;
			preTime=Browser.now();
			var tx=_cacheCanvas.ctx;
			var _repaint=sprite._needRepaint()|| (!tx);
			this._oldCanvas(sprite,context,x,y);
			if (Config.showCanvasMark){
			}
			if (_repaint){
				CacheAnalyser.I.reCacheCanvas(sprite,Browser.now()-preTime);
				}else{
				CacheAnalyser.I.renderCanvas(sprite,Browser.now()-preTime);
			}
		}

		RenderSpriteHook.init=function(){
			RenderSpriteHook.I=new RenderSpriteHook();
			RenderSpriteHook._preCreateFun=RunDriver.createRenderSprite;
			RunDriver.createRenderSprite=RenderSpriteHook.I.createRenderSprite;
		}

		RenderSpriteHook.IMAGE=0x01;
		RenderSpriteHook.FILTERS=0x02;
		RenderSpriteHook.ALPHA=0x04;
		RenderSpriteHook.TRANSFORM=0x08;
		RenderSpriteHook.CANVAS=0x10;
		RenderSpriteHook.BLEND=0x20;
		RenderSpriteHook.CLIP=0x40;
		RenderSpriteHook.STYLE=0x80;
		RenderSpriteHook.GRAPHICS=0x100;
		RenderSpriteHook.CUSTOM=0x200;
		RenderSpriteHook.ENABLERENDERMERGE=0x400;
		RenderSpriteHook.CHILDS=0x800;
		RenderSpriteHook.INIT=0x11111;
		RenderSpriteHook.renders=[];
		RenderSpriteHook.I=null
		RenderSpriteHook._preCreateFun=null
		return RenderSpriteHook;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.debug.tools.enginehook.SpriteRenderForVisibleAnalyse
	var SpriteRenderForVisibleAnalyse=(function(){
		function SpriteRenderForVisibleAnalyse(){
			this._repaint=1;
			this._renderType=1;
			this._x=0;
			this._y=0;
			this.target=null;
			this.isTargetRenderd=false;
			this.preFun=null;
			this._next=null;
			this.pgraphic=RenderSprite["prototype"]["_graphics"];
			this.pimage=RenderSprite["prototype"]["_image"];
			this.pimage2=RenderSprite["prototype"]["_image2"];
		}

		__class(SpriteRenderForVisibleAnalyse,'laya.debug.tools.enginehook.SpriteRenderForVisibleAnalyse');
		var __proto=SpriteRenderForVisibleAnalyse.prototype;
		__proto.setRenderHook=function(){
			Sprite["prototype"]["render"]=SpriteRenderForVisibleAnalyse.I.render;
		}

		/**
		*更新、呈现显示对象。
		*@param context 渲染的上下文引用。
		*@param x X轴坐标。
		*@param y Y轴坐标。
		*/
		__proto.render=function(context,x,y){
			var me;
			me=this;
			if (DebugInfoLayer.I.isDebugItem(me))return;
			if (me==laya.debug.tools.enginehook.SpriteRenderForVisibleAnalyse.I.target){
				laya.debug.tools.enginehook.SpriteRenderForVisibleAnalyse.allowRendering=true;
				laya.debug.tools.enginehook.SpriteRenderForVisibleAnalyse.I.isTargetRenderd=true;
				CanvasTools.clearCanvas(SpriteRenderForVisibleAnalyse.mainCanvas);
			}
			RenderSprite.renders[this._renderType]._fun(this,context,x+this._x,y+this._y);
			if (me==laya.debug.tools.enginehook.SpriteRenderForVisibleAnalyse.I.target){
				SpriteRenderForVisibleAnalyse.tarRec=CanvasTools.getCanvasDisRec(laya.debug.tools.enginehook.SpriteRenderForVisibleAnalyse.mainCanvas);
				console.log("rec",SpriteRenderForVisibleAnalyse.tarRec.toString());
				if (SpriteRenderForVisibleAnalyse.tarRec.width >0&& SpriteRenderForVisibleAnalyse.tarRec.height > 0){
					SpriteRenderForVisibleAnalyse.isTarRecOK=true;
					SpriteRenderForVisibleAnalyse.preImageData=CanvasTools.getImageDataFromCanvasByRec(SpriteRenderForVisibleAnalyse.mainCanvas,SpriteRenderForVisibleAnalyse.tarRec);
					SpriteRenderForVisibleAnalyse.tarImageData=CanvasTools.getImageDataFromCanvasByRec(SpriteRenderForVisibleAnalyse.mainCanvas,SpriteRenderForVisibleAnalyse.tarRec);
					}else{
					console.log("tarRec Not OK:",SpriteRenderForVisibleAnalyse.tarRec);
				}
				}else{
				if (SpriteRenderForVisibleAnalyse.isTarRecOK){
					SpriteRenderForVisibleAnalyse.tImageData=CanvasTools.getImageDataFromCanvasByRec(SpriteRenderForVisibleAnalyse.mainCanvas,SpriteRenderForVisibleAnalyse.tarRec);
					var dRate=NaN;
					dRate=CanvasTools.getDifferRate(SpriteRenderForVisibleAnalyse.preImageData,SpriteRenderForVisibleAnalyse.tImageData);
					SpriteRenderForVisibleAnalyse.preImageData=SpriteRenderForVisibleAnalyse.tImageData;
					if (dRate > 0){
						VisibleAnalyser.addCoverNode(me,dRate);
					}
				}
			}
		}

		__proto.analyseNode=function(node){
			VisibleAnalyser.resetCoverList();
			if (Sprite["prototype"]["render"] !=SpriteRenderForVisibleAnalyse.I.render){
				this.preFun=Sprite["prototype"]["render"];
			}
			this.target=node;
			Sprite["prototype"]["render"]=this.render;
			if (!SpriteRenderForVisibleAnalyse.tarCanvas)
				SpriteRenderForVisibleAnalyse.tarCanvas=CanvasTools.createCanvas(Laya.stage.width,Laya.stage.height);
			if (!SpriteRenderForVisibleAnalyse.mainCanvas)
				SpriteRenderForVisibleAnalyse.mainCanvas=CanvasTools.createCanvas(Laya.stage.width,Laya.stage.height);
			this.isTargetRenderd=false;
			SpriteRenderForVisibleAnalyse.isVisibleTesting=true;
			SpriteRenderForVisibleAnalyse.allowRendering=false;
			CanvasTools.clearCanvas(SpriteRenderForVisibleAnalyse.mainCanvas);
			CanvasTools.clearCanvas(SpriteRenderForVisibleAnalyse.tarCanvas);
			SpriteRenderForVisibleAnalyse.isTarRecOK=false;
			var ctx=new RenderContext(SpriteRenderForVisibleAnalyse.mainCanvas.width,SpriteRenderForVisibleAnalyse.mainCanvas.height,SpriteRenderForVisibleAnalyse.mainCanvas);
			SpriteRenderForVisibleAnalyse.mainCanvas=ctx.canvas;
			this.render.call(Laya.stage,ctx,0,0);
			if (!SpriteRenderForVisibleAnalyse.isTarRecOK){
				SpriteRenderForVisibleAnalyse.coverRate=0;
				}else{
				SpriteRenderForVisibleAnalyse.coverRate=CanvasTools.getDifferRate(SpriteRenderForVisibleAnalyse.preImageData,SpriteRenderForVisibleAnalyse.tarImageData);
			}
			VisibleAnalyser.coverRate=SpriteRenderForVisibleAnalyse.coverRate;
			VisibleAnalyser.isTarRecOK=SpriteRenderForVisibleAnalyse.isTarRecOK;
			console.log("coverRate:",SpriteRenderForVisibleAnalyse.coverRate);
			this.isTargetRenderd=false;
			SpriteRenderForVisibleAnalyse.isVisibleTesting=false;
			SpriteRenderForVisibleAnalyse.allowRendering=true;
			Sprite["prototype"]["render"]=this.preFun;
		}

		__proto.noRenderMode=function(){
			return;
			RenderSprite["prototype"]["_graphics"]=this.m_graphics;
			RenderSprite["prototype"]["_image"]=this.m_image;
			RenderSprite["prototype"]["_image2"]=this.m_image2;
		}

		__proto.normalMode=function(){
			RenderSprite["prototype"]["_graphics"]=this.pgraphic;
			RenderSprite["prototype"]["_image"]=this.pimage;
			RenderSprite["prototype"]["_image2"]=this.pimage2;
		}

		__proto.inits=function(){
			this.noRenderMode();
		}

		__proto.m_graphics=function(sprite,context,x,y){
			if (laya.debug.tools.enginehook.SpriteRenderForVisibleAnalyse.allowRendering){
				var tf=sprite._style._tf;
				sprite._graphics && sprite._graphics._render(sprite,context,x-tf.translateX,y-tf.translateY);
			};
			var next=this._next;
			next._fun.call(next,sprite,context,x,y);
		}

		__proto.m_image=function(sprite,context,x,y){
			if (laya.debug.tools.enginehook.SpriteRenderForVisibleAnalyse.allowRendering){
				var style=sprite._style;
				context.ctx.drawTexture2(x,y,style._tf.translateX,style._tf.translateY,sprite.transform,style.alpha,style.blendMode,sprite._graphics._one);
			}
		}

		__proto.m_image2=function(sprite,context,x,y){
			if (laya.debug.tools.enginehook.SpriteRenderForVisibleAnalyse.allowRendering){
				var tf=sprite._style._tf;
				context.ctx.drawTexture2(x,y,tf.translateX,tf.translateY,sprite.transform,1,null,sprite._graphics._one);
			}
		}

		SpriteRenderForVisibleAnalyse.tarCanvas=null
		SpriteRenderForVisibleAnalyse.mainCanvas=null
		SpriteRenderForVisibleAnalyse.preImageData=null
		SpriteRenderForVisibleAnalyse.tImageData=null
		SpriteRenderForVisibleAnalyse.tarImageData=null
		SpriteRenderForVisibleAnalyse.tarRec=null
		SpriteRenderForVisibleAnalyse.isTarRecOK=false;
		SpriteRenderForVisibleAnalyse.isVisibleTesting=false;
		SpriteRenderForVisibleAnalyse.allowRendering=true;
		SpriteRenderForVisibleAnalyse.coverRate=NaN
		__static(SpriteRenderForVisibleAnalyse,
		['I',function(){return this.I=new SpriteRenderForVisibleAnalyse();}
		]);
		return SpriteRenderForVisibleAnalyse;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.debug.tools.enginehook.SpriteRenderHook
	var SpriteRenderHook=(function(){
		function SpriteRenderHook(){
			this._repaint=1;
			this._renderType=1;
			this._x=0;
			this._y=0;
		}

		__class(SpriteRenderHook,'laya.debug.tools.enginehook.SpriteRenderHook');
		var __proto=SpriteRenderHook.prototype;
		/**
		*更新、呈现显示对象。
		*@param context 渲染的上下文引用。
		*@param x X轴坐标。
		*@param y Y轴坐标。
		*/
		__proto.render=function(context,x,y){
			if ((this)==Laya.stage){
				CacheAnalyser.renderLoopBegin();
			};
			var preTime=0;
			preTime=Browser.now();
			Stat.spriteCount++;
			RenderSprite.renders[this._renderType]._fun(this,context,x+this._x,y+this._y);
			this._repaint=0;
			RenderAnalyser.I.render(this,Browser.now()-preTime);
		}

		SpriteRenderHook.init=function(){
			SpriteRenderHook.I=new SpriteRenderHook();
			SpriteRenderHook.setRenderHook();
		}

		SpriteRenderHook.setRenderHook=function(){
			Sprite["prototype"]["render"]=SpriteRenderHook.I.render;
		}

		SpriteRenderHook.I=null
		return SpriteRenderHook;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-10-30 下午1:06:56
	*/
	//class laya.debug.tools.FilterTool
	var FilterTool=(function(){
		function FilterTool(){}
		__class(FilterTool,'laya.debug.tools.FilterTool');
		FilterTool.getArrByFilter=function(arr,filterFun){
			var i=0,len=arr.length;
			var rst=[];
			for(i=0;i<len;i++){
				if(filterFun(arr[i]))rst.push(arr[i]);
			}
			return rst;
		}

		FilterTool.getArr=function(arr,sign,value){
			var i=0,len=arr.length;
			var rst=[];
			for(i=0;i<len;i++){
				if(arr[i][sign]==value)rst.push(arr[i]);
			}
			return rst;
		}

		return FilterTool;
	})()


	/**
	*本类用于在对象的函数上挂钩子
	*@author ww
	*@version 1.0
	*
	*@created 2015-10-23 下午1:13:13
	*/
	//class laya.debug.tools.hook.FunHook
	var FunHook=(function(){
		function FunHook(){}
		__class(FunHook,'laya.debug.tools.hook.FunHook');
		FunHook.hook=function(obj,funName,preFun,aftFun){
			FunHook.hookFuns(obj,funName,[preFun,obj[funName],aftFun],1);
		}

		FunHook.hookAllFun=function(obj){
			var key;
			var arr;
			arr=ClassTool.getOwnPropertyNames(obj);
			for(key in arr){
				key=arr[key];
				if (FunHook.special[key])continue ;
				console.log("try hook:",key);
				if((typeof (obj[key])=='function')){
					console.log("hook:",key);
					FunHook.hookFuns(obj,key,[FunHook.getTraceMsg("call:"+key),obj[key]],1);
				}
			}
			if(obj["__proto__"]){
				FunHook.hookAllFun(obj["__proto__"]);
				}else{
				console.log("end:",obj);
			}
		}

		FunHook.getTraceMsg=function(msg){
			var rst;
			rst=function (){
				console.log(msg);
			}
			return rst;
		}

		FunHook.hookFuns=function(obj,funName,funList,rstI){
			(rstI===void 0)&& (rstI=-1);
			var _preFun=obj[funName];
			var newFun;
			newFun=function (__args){
				var args=arguments;
				var rst;
				var i=0;
				var len=0;
				len=funList.length;
				for(i=0;i<len;i++){
					if(!funList[i])continue ;
					if(i==rstI){
						rst=funList[i].apply(this,args);
						}else{
						funList[i].apply(this,args);
					}
				}
				return rst;
			};
			newFun["pre"]=_preFun;
			obj[funName]=newFun;
		}

		FunHook.removeHook=function(obj,funName){
			if(obj[funName].pre!=null){
				obj[funName]=obj[funName].pre;
			}
		}

		FunHook.debugHere=function(){
			debugger;;
		}

		FunHook.traceLoc=function(level,msg){
			(level===void 0)&& (level=0);
			(msg===void 0)&& (msg="");
			console.log(msg,"fun loc:",TraceTool.getCallLoc(3+level));
		}

		FunHook.getLocFun=function(level,msg){
			(level===void 0)&& (level=0);
			(msg===void 0)&& (msg="");
			level+=1;
			var rst;
			rst=function (){
				FunHook.traceLoc(level,msg);
			}
			return rst;
		}

		__static(FunHook,
		['special',function(){return this.special={
				"length":true,
				"name":true,
				"arguments":true,
				"caller":true,
				"prototype":true,
				"is":true,
				"isExtensible":true,
				"isFrozen":true,
				"isSealed":true,
				"preventExtensions":true,
				"seal":true,
				"unobserve":true,
				"apply":true,
				"call":true,
				"bind":true,
				"freeze":true,
				"unobserve":true
		};}

		]);
		return FunHook;
	})()


	/**
	*本类用于监控对象 set get 函数的调用
	*@author ww
	*@version 1.0
	*
	*@created 2015-10-23 下午2:52:48
	*/
	//class laya.debug.tools.hook.VarHook
	var VarHook=(function(){
		function VarHook(){}
		__class(VarHook,'laya.debug.tools.hook.VarHook');
		VarHook.hookVar=function(obj,name,setHook,getHook){
			if(!setHook)setHook=[];
			if(!getHook)getHook=[];
			var preO=obj;
			var preValue=obj[name];
			var des;
			des=ClassTool.getOwnPropertyDescriptor(obj,name);
			var ndes={};
			var mSet=function (value){
				console.log("var hook set "+name+":",value);
				preValue=value;
			};
			var mGet=function (){
				console.log("var hook get"+name+":",preValue);
				return preValue;
			}
			if(des){
				ndes.set=mSet;
				ndes.get=mGet;
				ndes.enumerable=des.enumerable;
				setHook.push(ndes.set);
				getHook.push(ndes.get);
				FunHook.hookFuns(ndes,"set",setHook);
				FunHook.hookFuns(ndes,"get",getHook,getHook.length-1);
				ClassTool.defineProperty(obj,name,ndes);
				return;
			}
			while(!des&&obj["__proto__"]){
				obj=obj["__proto__"];
				des=ClassTool.getOwnPropertyDescriptor(obj,name);
			}
			if (des){
				ndes.set=des.set?des.set:mSet;
				ndes.get=des.get?des.get:mGet;
				ndes.enumerable=des.enumerable;
				setHook.push(ndes.set);
				getHook.push(ndes.get);
				FunHook.hookFuns(ndes,"set",setHook);
				FunHook.hookFuns(ndes,"get",getHook,getHook.length-1);
				ClassTool.defineProperty(preO,name,ndes);
			}
			if(!des){
				console.log("get des fail add directly");
				ndes.set=mSet;
				ndes.get=mGet;
				setHook.push(ndes.set);
				getHook.push(ndes.get);
				FunHook.hookFuns(ndes,"set",setHook);
				FunHook.hookFuns(ndes,"get",getHook,getHook.length-1);
				ClassTool.defineProperty(obj,name,ndes);
			}
		}

		VarHook.getLocFun=function(msg,level){
			(msg===void 0)&& (msg="");
			(level===void 0)&& (level=0);
			level+=1;
			var rst;
			rst=function (){
				FunHook.traceLoc(level,msg);
			}
			return rst;
		}

		return VarHook;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-10-29 上午9:45:33
	*/
	//class laya.debug.tools.IDTools
	var IDTools=(function(){
		function IDTools(){
			this.tID=1;
		}

		__class(IDTools,'laya.debug.tools.IDTools');
		var __proto=IDTools.prototype;
		__proto.getID=function(){
			return this.tID++;
		}

		IDTools.getAID=function(){
			return IDTools._ID.getID();
		}

		IDTools.idObjE=function(obj,sign){
			(sign===void 0)&& (sign="default");
			if (obj["_M_id_"])return obj;
			if(!sign){
				sign="default";
			}
			if(!IDTools._idDic[sign]){
				IDTools._idDic[sign]=new IDTools();
			}
			obj["_M_id_"]=IDTools._idDic[sign].getAID();
			return obj;
		}

		IDTools.setObjID=function(obj,id){
			obj["_M_id_"]=id;
			return obj;
		}

		IDTools.idObj=function(obj){
			if (obj["_M_id_"])return obj;
			obj["_M_id_"]=IDTools.getAID();
			return obj;
		}

		IDTools.getObjID=function(obj){
			if(!obj)return-1;
			return obj["_M_id_"];
		}

		IDTools.idSign="_M_id_";
		__static(IDTools,
		['_ID',function(){return this._ID=new IDTools();},'_idDic',function(){return this._idDic={"default":new IDTools()};}
		]);
		return IDTools;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-11-27 上午9:58:59
	*/
	//class laya.debug.tools.JsonTool
	var JsonTool=(function(){
		function JsonTool(){}
		__class(JsonTool,'laya.debug.tools.JsonTool');
		JsonTool.getJsonString=function(obj,singleLine,split,depth,Width){
			(singleLine===void 0)&& (singleLine=true);
			(split===void 0)&& (split="\n");
			(depth===void 0)&& (depth=0);
			(Width===void 0)&& (Width=4);
			var preStr="";
			preStr=JsonTool.getEmptyStr(depth*Width);
			var rst;
			var keyValues;
			keyValues={};
			var tKey;
			var tValue;
			var type;
			var keys;
			keys=[];
			for(tKey in obj){
				keys.push(tKey);
				tValue=obj[tKey];
				if(JsonTool.singleLineKey[tKey]){
					keyValues[tKey]=JsonTool.getValueStr(tValue,true,split,depth+1,Width);
					}else{
					keyValues[tKey]=JsonTool.getValueStr(tValue,singleLine,split,depth+1,Width);
				}
			};
			var i=0,len=0;
			len=keys.length;
			keys.sort();
			keys=keys.reverse();
			var keyPreStr;
			keyPreStr=JsonTool.getEmptyStr((depth+1)*Width);
			if(singleLine){
				split="";
				preStr="";
				keyPreStr="";
			};
			var keyValueStrArr;
			keyValueStrArr=[];
			for(i=0;i<len;i++){
				tKey=keys[i];
				keyValueStrArr.push(keyPreStr+JsonTool.wrapValue(tKey)+":"+keyValues[tKey]);
			}
			rst="{"+split+keyValueStrArr.join(","+split)+split+preStr+"}";
			return rst;
		}

		JsonTool.wrapValue=function(value,wraper){
			(wraper===void 0)&& (wraper="\"");
			return wraper+value+wraper;
		}

		JsonTool.getArrStr=function(arr,singleLine,split,depth,Width){
			(singleLine===void 0)&& (singleLine=true);
			(split===void 0)&& (split="\n");
			(depth===void 0)&& (depth=0);
			(Width===void 0)&& (Width=4);
			var rst;
			var i=0,len=0;
			len=arr.length;
			var valueStrArr;
			valueStrArr=[];
			for(i=0;i<len;i++){
				valueStrArr.push(JsonTool.getValueStr(arr[i],singleLine,split,depth+1,Width));
			};
			var preStr="";
			preStr=JsonTool.getEmptyStr((depth+1)*Width);
			if(singleLine){
				split="";
				preStr="";
			}
			rst="["+split+preStr+valueStrArr.join(","+split+preStr)+"]";
			return rst;
		}

		JsonTool.quote=function(string){
			JsonTool.escapable.lastIndex=0;
			return JsonTool.escapable.test(string)? '"'+string.replace(JsonTool.escapable,function(a){
				var c=JsonTool.meta[a];
				return typeof c==='string' ? c :
				'\\u'+('0000'+a.charCodeAt(0).toString(16)).slice(-4);
			})+'"' :'"'+string+'"';
		}

		JsonTool.getValueStr=function(tValue,singleLine,split,depth,Width){
			(singleLine===void 0)&& (singleLine=true);
			(split===void 0)&& (split="\n");
			(depth===void 0)&& (depth=0);
			(Width===void 0)&& (Width=0);
			var rst;
			if((typeof tValue=='string')){
				rst=JsonTool.quote(tValue);
				}else if(tValue==null){
				rst="null";
				}else if((typeof tValue=='number')|| ((typeof tValue=='number')&& Math.floor(tValue)==tValue)|| (typeof tValue=='boolean')){
				rst=tValue;
				}else if((tValue instanceof Array)){
				rst=JsonTool.getArrStr(tValue,singleLine,split,depth,Width);
				}else if((typeof tValue=='object')){
				rst=JsonTool.getJsonString(tValue,singleLine,split,depth,Width);
				}else{
				rst=tValue;
			}
			return rst;
		}

		JsonTool.getEmptyStr=function(width){
			if(!JsonTool.emptyDic.hasOwnProperty(width)){
				var i=0;
				var len=0;
				len=width;
				var rst;
				rst="";
				for(i=0;i<len;i++){
					rst+=" ";
				}
				JsonTool.emptyDic[width]=rst;
			}
			return JsonTool.emptyDic[width];
		}

		JsonTool.emptyDic={};
		__static(JsonTool,
		['singleLineKey',function(){return this.singleLineKey={
				"props":true
			};},'escapable',function(){return this.escapable=/[\\\"\x00-\x1f\x7f-\x9f\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g;},'meta',function(){return this.meta = {   
			'\b':'\\b',
			'\t':'\\t',
			'\n':'\\n',
			'\f':'\\f',
			'\r':'\\r',
			'"' :'\\"',
			'\\':'\\\\'
	};}


	]);
	return JsonTool;
	})()


	/**
	*本类用于操作html对象
	*@author ww
	*/
	//class laya.debug.tools.JSTools
	var JSTools=(function(){
		function JSTools(){}
		__class(JSTools,'laya.debug.tools.JSTools');
		JSTools.showToBody=function(el,x,y){
			(x===void 0)&& (x=0);
			(y===void 0)&& (y=0);
			Browser.document.body.appendChild(el);
			var style;
			style=el.style;
			style.position="absolute";
			style.top=y+"px";
			style.left=x+"px";
		}

		JSTools.showToParent=function(el,x,y,parent){
			(x===void 0)&& (x=0);
			(y===void 0)&& (y=0);
			parent.appendChild(el);
			var style;
			style=el.style;
			style.position="absolute";
			style.top=y+"px";
			style.left=x+"px";
		}

		JSTools.addToBody=function(el){
			Browser.document.body.appendChild(el);
		}

		JSTools.setPos=function(el,x,y){
			var style;
			style=el.style;
			style.top=y+"px";
			style.left=x+"px";
		}

		JSTools.setSize=function(el,width,height){
			var style;
			style=el.style;
			style.width=width+"px";
			style.height=height+"px";
		}

		JSTools.setTransform=function(el,mat){
			var style;
			style=el.style;
			style.transformOrigin=style.webkitTransformOrigin=style.msTransformOrigin=style.mozTransformOrigin=style.oTransformOrigin="0px 0px 0px";
			style.transform=style.webkitTransform=style.msTransform=style.mozTransform=style.oTransform="matrix("+mat.toString()+")";
		}

		JSTools.noMouseEvent=function(el){
			var style;
			style=el.style;
			style["pointer-events"]="none";
		}

		JSTools.setMouseEnable=function(el,enable){
			var style;
			style=el.style;
			style["pointer-events"]=enable?"auto":"none";
		}

		JSTools.setZIndex=function(el,zIndex){
			var style;
			style=el.style;
			style["z-index"]=zIndex;
		}

		JSTools.showAboveSprite=function(el,sprite,dx,dy){
			(dx===void 0)&& (dx=0);
			(dy===void 0)&& (dy=0);
			var pos;
			pos=new Point();
			pos=sprite.localToGlobal(pos);
			pos.x+=dx;
			pos.y+=dy;
			pos.x+=Laya.stage.offset.x;
			pos.y+=Laya.stage.offset.y;
			JSTools.showToBody(el,pos.x,pos.y);
		}

		JSTools.removeElement=function(el){
			Browser.removeElement(el);
		}

		JSTools.isElementInDom=function(el){
			return el && el.parentNode;
		}

		JSTools.getImageSpriteByFile=function(file,width,height){
			(width===void 0)&& (width=0);
			(height===void 0)&& (height=0);
			var reader;
			reader=new FileReader();;
			reader.readAsDataURL(file);
			var sprite;
			sprite=new Sprite();
			reader.onload=function (e){
				var txt;
				txt=new Texture();
				txt.load(reader.result);
				sprite.graphics.drawTexture(txt,0,0,width,height);
			}
			return sprite;
		}

		JSTools.getPixelRatio=function(){
			if (JSTools._pixelRatio > 0)return JSTools._pixelRatio;
			var canvas=Browser.createElement("canvas");
			var context=canvas.getContext('2d');
			var devicePixelRatio=Browser.window.devicePixelRatio || 1;
			var backingStoreRatio=context.webkitBackingStorePixelRatio ||
			context.mozBackingStorePixelRatio ||
			context.msBackingStorePixelRatio ||
			context.oBackingStorePixelRatio ||
			context.backingStorePixelRatio || 1;
			var ratio=devicePixelRatio / backingStoreRatio;
			console.log("pixelRatioc:",ratio);
			JSTools._pixelRatio=ratio;
			return ratio;
		}

		JSTools._pixelRatio=-1;
		return JSTools;
	})()


	/**
	*布局工具类,目前只支持水平方向布局
	*@author ww
	*/
	//class laya.debug.tools.layout.Layouter
	var Layouter=(function(){
		function Layouter(){
			this.data=null;
			this._items=null;
			this.layoutFun=null;
			this._sX=0;
			this._width=0;
		}

		__class(Layouter,'laya.debug.tools.layout.Layouter');
		var __proto=Layouter.prototype;
		__proto.layout=function(){
			this.layoutFun(this._width,this._items,this.data,this._sX);
		}

		/**
		*重新布局
		*
		*/
		__proto.changed=function(){
			Laya.timer.callLater(this,this.layout);
		}

		/**
		*根据当前的对象状态计算位置大小
		*
		*/
		__proto.calSize=function(){
			var i=0,len=0;
			var tItem;
			tItem=this.items[0];
			this._sX=tItem.x;
			var maxX=NaN;
			maxX=this._sX+tItem.width;
			len=this.items.length;
			for (i=1;i < len;i++){
				tItem=this.items[i];
				if (this._sX > tItem.x){
					this._sX=tItem.x;
				}
				if (maxX < tItem.x+tItem.width){
					maxX=tItem.x+tItem.width;
				}
			}
			this._width=maxX-this._sX;
		}

		__getset(0,__proto,'width',function(){
			return this._width;
			},function(v){
			this._width=v;
			this.changed();
		});

		__getset(0,__proto,'x',function(){
			return this._sX;
			},function(v){
			this._sX=v;
			this.changed();
		});

		__getset(0,__proto,'items',function(){
			return this._items;
			},function(arr){
			this._items=arr;
			this.calSize();
		});

		return Layouter;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.debug.tools.layout.LayoutFuns
	var LayoutFuns=(function(){
		function LayoutFuns(){}
		__class(LayoutFuns,'laya.debug.tools.layout.LayoutFuns');
		LayoutFuns.sameWidth=function(totalWidth,items,data,sX){
			(sX===void 0)&& (sX=0);
			var dWidth=0;
			if (data && data.dWidth)
				dWidth=data.dWidth;
			var perWidth=NaN;
			perWidth=(totalWidth-(items.length-1)*dWidth)/ items.length;
			var tItem;
			var i=0,len=0;
			var tX=NaN;
			tX=sX;
			len=items.length;
			for (i=0;i < len;i++){
				tItem=items[i];
				tItem.x=tX;
				tItem.width=perWidth;
				tX+=dWidth+perWidth;
			}
		}

		LayoutFuns.getSameWidthLayout=function(items,dWidth){
			var data;
			data={};
			data.dWidth=dWidth;
			return LayoutFuns.getLayouter(items,data,laya.debug.tools.layout.LayoutFuns.sameWidth);
		}

		LayoutFuns.getLayouter=function(items,data,fun){
			var layouter;
			layouter=new Layouter();
			layouter.items=items;
			layouter.data=data;
			layouter.layoutFun=fun;
			return layouter;
		}

		LayoutFuns.sameDis=function(totalWidth,items,data,sX){
			(sX===void 0)&& (sX=0);
			var dWidth=NaN;
			dWidth=totalWidth;
			var tItem;
			var i=0,len=0;
			len=items.length;
			LayoutFuns.prepareForLayoutWidth(totalWidth,items);
			for (i=0;i < len;i++){
				tItem=items[i];
				dWidth-=tItem.width;
			}
			if (items.length > 1)
				dWidth=dWidth / (items.length-1);
			var tX=NaN;
			tX=sX;
			len=items.length;
			for (i=0;i < len;i++){
				tItem=items[i];
				tItem.x=tX;
				tX+=dWidth+tItem.width;
			}
		}

		LayoutFuns.getSameDisLayout=function(items,rateSame){
			(rateSame===void 0)&& (rateSame=false);
			var data;
			data={};
			if (rateSame){
				var i=0,len=0;
				len=items.length;
				var tItem;
				var totalWidth=NaN;
				totalWidth=0;
				for (i=0;i < len;i++){
					tItem=items[i];
					totalWidth+=tItem.width;
				}
				totalWidth=tItem.x+tItem.width;
				for (i=0;i < len;i++){
					tItem=items[i];
					LayoutFuns.setItemRate(tItem,tItem.width / totalWidth);
				}
			}
			return LayoutFuns.getLayouter(items,data,laya.debug.tools.layout.LayoutFuns.sameDis);
		}

		LayoutFuns.fullFill=function(totalWidth,items,data,sX){
			(sX===void 0)&& (sX=0);
			var dL=0,dR=0;
			if (data){
				if (data.dL)
					dL=data.dL;
				if (data.dR)
					dR=data.dR;
			};
			var item;
			var i=0,len=0;
			len=items.length;
			for (i=0;i < len;i++){
				item=items[i];
				item.x=sX+dL;
				item.width=totalWidth-dL-dR;
			}
		}

		LayoutFuns.getFullFillLayout=function(items,dL,dR){
			(dL===void 0)&& (dL=0);
			(dR===void 0)&& (dR=0);
			var data;
			data={};
			data.dL=dL;
			data.dR=dR;
			return LayoutFuns.getLayouter(items,data,laya.debug.tools.layout.LayoutFuns.fullFill);
		}

		LayoutFuns.fixPos=function(totalWidth,items,data,sX){
			(sX===void 0)&& (sX=0);
			var dLen=0;
			var poss=[];
			var isRate=false;
			if (data){
				if (data.dLen)
					dLen=data.dLen;
				if (data.poss)
					poss=data.poss;
				if (data.isRate)
					isRate=data.isRate;
			};
			var item;
			var i=0,len=0;
			len=poss.length;
			var tX=NaN;
			tX=sX;
			var tValue=NaN;
			var preItem;
			preItem=null;
			for (i=0;i < len;i++){
				item=items[i];
				tValue=sX+poss[i];
				if (isRate){
					tValue=sX+poss[i] *totalWidth;
				}
				item.x=tValue;
				if (preItem){
					preItem.width=item.x-dLen-preItem.x;
				}
				preItem=item;
			};
			var lastItem;
			lastItem=items[items.length-1];
			lastItem.width=sX+totalWidth-dLen-lastItem.x;
		}

		LayoutFuns.getFixPos=function(items,dLen,isRate,poss){
			(dLen===void 0)&& (dLen=0);
			(isRate===void 0)&& (isRate=false);
			var data;
			data={};
			var layout;
			layout=LayoutFuns.getLayouter(items,data,LayoutFuns.fixPos);
			var i=0,len=0;
			var sX=NaN;
			var totalWidth=NaN;
			sX=layout.x;
			totalWidth=layout.width;
			if (!poss){
				poss=[];
				len=items.length;
				var tValue=NaN;
				for (i=0;i < len;i++){
					tValue=items[i].x-sX;
					if (isRate){
						tValue=tValue / totalWidth;
					}
					else{
					}
					poss.push(tValue);
				}
			}
			data.dLen=dLen;
			data.poss=poss;
			data.isRate=isRate;
			return layout;
		}

		LayoutFuns.clearItemsRelativeInfo=function(items){
			var i=0,len=0;
			len=items.length;
			for (i=0;i < len;i++){
				LayoutFuns.clearItemRelativeInfo(items[i]);
			}
		}

		LayoutFuns.clearItemRelativeInfo=function(item){
			var Nan="NaN";
			item.getLayout().left=Nan;
			item.getLayout().right=Nan;
		}

		LayoutFuns.prepareForLayoutWidth=function(totalWidth,items){
			var i=0,len=0;
			len=items.length;
			for (i=0;i < len;i++){
				LayoutFuns.prepareItemForLayoutWidth(totalWidth,items[i]);
			}
		}

		LayoutFuns.getSumWidth=function(items){
			var sum=NaN;
			sum=0;
			var i=0,len=0;
			len=items.length;
			for (i=0;i < len;i++){
				sum+=items[i].width;
			}
			return sum;
		}

		LayoutFuns.prepareItemForLayoutWidth=function(totalWidth,item){
			if (LayoutFuns.getItemRate(item)> 0){
				item.width=totalWidth *LayoutFuns.getItemRate(item);
			}
		}

		LayoutFuns.setItemRate=function(item,rate){
			item["layoutRate"]=rate;
		}

		LayoutFuns.getItemRate=function(item){
			return item["layoutRate"] ? item["layoutRate"] :-1;
		}

		LayoutFuns.setItemFreeSize=function(item,free){
			(free===void 0)&& (free=true);
			item["layoutFreeSize"]=free;
		}

		LayoutFuns.isItemFreeSize=function(item){
			return item["layoutFreeSize"];
		}

		LayoutFuns.lockedDis=function(totalWidth,items,data,sX){
			(sX===void 0)&& (sX=0);
			var dists;
			dists=data.dists;
			var sumDis=NaN;
			sumDis=data.sumDis;
			var sumWidth=NaN;
			var i=0,len=0;
			var tItem;
			var preItem;
			LayoutFuns.prepareForLayoutWidth(totalWidth,items);
			sumWidth=LayoutFuns.getSumWidth(items);
			var dWidth=NaN;
			dWidth=totalWidth-sumDis-sumWidth;
			var freeItem;
			freeItem=LayoutFuns.getFreeItem(items);
			if(freeItem){
				freeItem.width+=dWidth;
			}
			preItem=items[0];
			preItem.x=sX;
			len=items.length;
			for(i=1;i<len;i++){
				tItem=items[i];
				tItem.x=preItem.x+preItem.width+dists[i-1];
				preItem=tItem;
			}
		}

		LayoutFuns.getFreeItem=function(items){
			var i=0,len=0;
			len=items.length;
			for (i=0;i < len;i++){
				if(LayoutFuns.isItemFreeSize(items[i])){
					return items[i];
				}
			}
			return null;
		}

		LayoutFuns.getLockedDis=function(items){
			var data;
			data={};
			var dists;
			var i=0,len=0;
			var tItem;
			var preItem;
			var sumDis=NaN;
			sumDis=0;
			var tDis=NaN;
			preItem=items[0];
			dists=[];
			len=items.length;
			for(i=1;i<len;i++){
				tItem=items[i];
				tDis=tItem.x-preItem.x-preItem.width;
				dists.push(tDis);
				sumDis+=tDis;
				preItem=tItem;
			}
			data.dists=dists;
			data.sumDis=sumDis;
			return LayoutFuns.getLayouter(items,data,laya.debug.tools.layout.LayoutFuns.lockedDis);
		}

		LayoutFuns.RateSign="layoutRate";
		LayoutFuns.FreeSizeSign="layoutFreeSize";
		return LayoutFuns;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-11-9 下午3:26:01
	*/
	//class laya.debug.tools.LayoutTools
	var LayoutTools=(function(){
		function LayoutTools(){}
		__class(LayoutTools,'laya.debug.tools.LayoutTools');
		LayoutTools.layoutToXCount=function(items,xCount,dx,dY,sx,sy){
			(xCount===void 0)&& (xCount=1);
			(dx===void 0)&& (dx=0);
			(dY===void 0)&& (dY=0);
			(sx===void 0)&& (sx=0);
			(sy===void 0)&& (sy=0);
			var tX=NaN,tY=NaN;
			var tItem;
			var i=0,len=0;
			var tCount=0;
			var maxHeight=0;
			tCount=0;
			maxHeight=0;
			tX=sx;
			tY=sy;
			len=items.length;
			for (i=0;i < len;i++){
				tItem=items[i];
				tItem.x=tX;
				tItem.y=tY;
				if (tItem.height > maxHeight){
					maxHeight=tItem.height;
				}
				tCount++;
				if (tCount >=xCount){
					tCount=tCount % xCount;
					tItem.y+=maxHeight+dY;
					maxHeight=0;
					}else{
					tX+=tItem.width+dx;
				}
			}
		}

		LayoutTools.layoutToWidth=function(items,width,dX,dY,sx,sy){
			var tX=NaN,tY=NaN;
			var tItem;
			var i=0,len=0;
			tX=sx;
			tY=sy;
			len=items.length;
			for(i=0;i<len;i++){
				tItem=items[i];
				if(tX+tItem.width+dX>width){
					tX=sx;
					tY+=dY+tItem.height;
					}else{
				}
				tItem.x=tX;
				tItem.y=tY;
				tX+=dX+tItem.width;
			}
		}

		return LayoutTools;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.debug.tools.MathTools
	var MathTools=(function(){
		function MathTools(){}
		__class(MathTools,'laya.debug.tools.MathTools');
		MathTools.sortBigFirst=function(a,b){
			if (a==b)
				return 0;
			return b > a ? 1 :-1;
		}

		MathTools.sortSmallFirst=function(a,b){
			if (a==b)
				return 0;
			return b > a ?-1 :1;
		}

		MathTools.sortNumBigFirst=function(a,b){
			return parseFloat(b)-parseFloat(a);
		}

		MathTools.sortNumSmallFirst=function(a,b){
			return parseFloat(a)-parseFloat(b);
		}

		MathTools.sortByKey=function(key,bigFirst,forceNum){
			(bigFirst===void 0)&& (bigFirst=false);
			(forceNum===void 0)&& (forceNum=true);
			var _sortFun;
			if (bigFirst){
				_sortFun=forceNum ? MathTools.sortNumBigFirst :MathTools.sortBigFirst;
				}else {
				_sortFun=forceNum ? MathTools.sortNumSmallFirst :MathTools.sortSmallFirst;
			}
			return function (a,b){
				return _sortFun(a[key],b[key]);
			};
		}

		return MathTools;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.debug.tools.MouseEventAnalyser
	var MouseEventAnalyser=(function(){
		function MouseEventAnalyser(){}
		__class(MouseEventAnalyser,'laya.debug.tools.MouseEventAnalyser');
		MouseEventAnalyser.analyseNode=function(node){
			DebugTool.showDisBound(node,true);
			var _node;
			_node=node;
			ObjectTools.clearObj(MouseEventAnalyser.infoO);
			ObjectTools.clearObj(MouseEventAnalyser.nodeO);
			ObjectTools.clearObj(MouseEventAnalyser.hitO);
			var nodeList;
			nodeList=[];
			while (node){
				IDTools.idObj(node);
				MouseEventAnalyser.nodeO[IDTools.getObjID(node)]=node;
				nodeList.push(node);
				node=node.parent;
			}
			MouseEventAnalyser.check(Laya.stage,Laya.stage.mouseX,Laya.stage.mouseY,null);
			var canStr;
			if (MouseEventAnalyser.hitO[IDTools.getObjID(_node)]){
				console.log("can hit");
				canStr="can hit";
			}
			else{
				console.log("can't hit");
				canStr="can't hit";
			};
			var i=0,len=0;
			nodeList=nodeList.reverse();
			len=nodeList.length;
			var rstTxts;
			rstTxts=["[分析对象]:"+ClassTool.getNodeClassAndName(_node)+":"+canStr];
			for (i=0;i < len;i++){
				node=nodeList[i];
				if (MouseEventAnalyser.hitO[IDTools.getObjID(node)]){
					console.log("can hit:",ClassTool.getNodeClassAndName(node));
					console.log("原因:",MouseEventAnalyser.infoO[IDTools.getObjID(node)]);
					rstTxts.push("can hit:"+" "+ClassTool.getNodeClassAndName(node));
					rstTxts.push("原因:"+" "+MouseEventAnalyser.infoO[IDTools.getObjID(node)]);
				}
				else{
					console.log("can't hit:"+ClassTool.getNodeClassAndName(node));
					console.log("原因:",MouseEventAnalyser.infoO[IDTools.getObjID(node)] ? MouseEventAnalyser.infoO[IDTools.getObjID(node)] :"鼠标事件在父级已停止派发");
					rstTxts.push("can't hit:"+" "+ClassTool.getNodeClassAndName(node));
					rstTxts.push("原因:"+" "+(MouseEventAnalyser.infoO[IDTools.getObjID(node)] ? MouseEventAnalyser.infoO[IDTools.getObjID(node)] :"鼠标事件在父级已停止派发"));
				}
			};
			var rstStr;
			rstStr=rstTxts.join("\n");
			ToolPanel.I.showTxtInfo(rstStr);
		}

		MouseEventAnalyser.check=function(sp,mouseX,mouseY,callBack){
			IDTools.idObj(sp);
			var isInAnlyseChain=false;
			isInAnlyseChain=MouseEventAnalyser.nodeO[IDTools.getObjID(sp)];
			var transform=sp.transform || MouseEventAnalyser._matrix;
			var pivotX=sp.pivotX;
			var pivotY=sp.pivotY;
			if (pivotX===0 && pivotY===0){
				transform.setTranslate(sp.x,sp.y);
			}
			else{
				if (transform===MouseEventAnalyser._matrix){
					transform.setTranslate(sp.x-pivotX,sp.y-pivotY);
				}
				else{
					var cos=transform.cos;
					var sin=transform.sin;
					transform.setTranslate(sp.x-(pivotX *cos-pivotY *sin)*sp.scaleX,sp.y-(pivotX *sin+pivotY *cos)*sp.scaleY);
				}
			}
			transform.invertTransformPoint(MouseEventAnalyser._point.setTo(mouseX,mouseY));
			transform.setTranslate(0,0);
			mouseX=MouseEventAnalyser._point.x;
			mouseY=MouseEventAnalyser._point.y;
			var scrollRect=sp.scrollRect;
			if (scrollRect){
				MouseEventAnalyser._rect.setTo(0,0,scrollRect.width,scrollRect.height);
				var isHit=MouseEventAnalyser._rect.contains(mouseX,mouseY);
				if (!isHit){
					if (isInAnlyseChain){
						MouseEventAnalyser.infoO[IDTools.getObjID(sp)]="scrollRect没有包含鼠标"+MouseEventAnalyser._rect.toString()+":"+mouseX+","+mouseY;
					}
					return false;
				}
			};
			var i=0,len=0;
			var cList;
			cList=sp._childs;
			len=cList.length;
			var child;
			var childInChain;
			childInChain=null;
			for (i=0;i < len;i++){
				child=cList[i];
				IDTools.idObj(child);
				if (MouseEventAnalyser.nodeO[IDTools.getObjID(child)]){
					childInChain=child;
					break ;
				}
			};
			var coverByOthers=false;
			coverByOthers=childInChain ? true :false;
			var flag=false;
			if (sp.hitTestPrior && !sp.mouseThrough && !MouseEventAnalyser.hitTest(sp,mouseX,mouseY)){
				MouseEventAnalyser.infoO[IDTools.getObjID(sp)]="hitTestPrior=true，宽高区域不包含鼠标:"+":"+mouseX+","+mouseY+" size:"+sp.width+","+sp.height;
				return false;
			}
			for (i=sp._childs.length-1;i >-1;i--){
				child=sp._childs[i];
				if (child==childInChain){
					if (!childInChain.mouseEnabled){
						MouseEventAnalyser.infoO[IDTools.getObjID(childInChain)]="mouseEnabled=false";
					}
					if (!childInChain.visible){
						MouseEventAnalyser.infoO[IDTools.getObjID(childInChain)]="visible=false";
					}
					coverByOthers=false;
				}
				if (child.mouseEnabled && child.visible){
					flag=MouseEventAnalyser.check(child,mouseX+(scrollRect ? scrollRect.x :0),mouseY+(scrollRect ? scrollRect.y :0),callBack);
					if (flag){
						MouseEventAnalyser.hitO[IDTools.getObjID(sp)]=true;
						MouseEventAnalyser.infoO[IDTools.getObjID(sp)]="子对象被击中";
						if (child==childInChain){
							MouseEventAnalyser.infoO[IDTools.getObjID(sp)]="子对象被击中,"+"击中对象在分析链中";
						}
						else{
							MouseEventAnalyser.infoO[IDTools.getObjID(sp)]="子对象被击中,"+"击中对象不在分析链中";
							if (coverByOthers){
								MouseEventAnalyser.infoO[IDTools.getObjID(childInChain)]="被兄弟节点挡住,兄弟节点信息:"+ClassTool.getNodeClassAndName(child)+","+child.getBounds().toString();
								DebugTool.showDisBound(child,false,"#ffff00");
							}
						}
						return true;
					}
					else{
						if (child==childInChain){
							coverByOthers=false;
						}
					}
				}
			};
			var mHitRect=new Rectangle();
			var graphicHit=false;
			graphicHit=sp.getGraphicBounds().contains(mouseX,mouseY);
			if (sp.width > 0 && sp.height > 0){
				var hitRect=MouseEventAnalyser._rect;
				if (!sp.mouseThrough){
					if (sp.hitArea)
						hitRect=sp.hitArea;
					else
					hitRect.setTo(0,0,sp.width,sp.height);
					mHitRect.copyFrom(hitRect);
					isHit=hitRect.contains(mouseX,mouseY);
				}
				else{
					isHit=graphicHit;
					mHitRect.copyFrom(sp.getGraphicBounds());
				}
				if (isHit){
					MouseEventAnalyser.hitO[IDTools.getObjID(sp)]=true;
				}
				}else{
			}
			if (!isHit){
				if (graphicHit){
					MouseEventAnalyser.infoO[IDTools.getObjID(sp)]="子对象未包含鼠标，实际绘图区域包含鼠标，设置的宽高区域不包含鼠标:"+":"+mouseX+","+mouseY+" hitRec:"+mHitRect.toString()+" graphicBounds:"+sp.getGraphicBounds().toString()+"，设置mouseThrough=true或将宽高设置到实际绘图区域可解决问题";
					}else{
					MouseEventAnalyser.infoO[IDTools.getObjID(sp)]="子对象未包含鼠标，实际绘图区域不包含鼠标，设置的宽高区域不包含鼠标:"+":"+mouseX+","+mouseY+" hitRec:"+mHitRect.toString()+" graphicBounds:"+sp.getGraphicBounds().toString();
				}
			}
			else{
				MouseEventAnalyser.infoO[IDTools.getObjID(sp)]="自身区域被击中";
			}
			return isHit;
		}

		MouseEventAnalyser.hitTest=function(sp,mouseX,mouseY){
			var isHit=false;
			if (sp.width > 0 && sp.height > 0 || sp.mouseThrough || sp.hitArea){
				var hitRect=MouseEventAnalyser._rect;
				if (!sp.mouseThrough){
					if (sp.hitArea)hitRect=sp.hitArea;
					else hitRect.setTo(0,0,sp.width,sp.height);
					isHit=hitRect.contains(mouseX,mouseY);
					}else {
					isHit=sp.getGraphicBounds().contains(mouseX,mouseY);
				}
			}
			return isHit;
		}

		MouseEventAnalyser.infoO={};
		MouseEventAnalyser.nodeO={};
		MouseEventAnalyser.hitO={};
		__static(MouseEventAnalyser,
		['_matrix',function(){return this._matrix=new Matrix();},'_point',function(){return this._point=new Point();},'_rect',function(){return this._rect=new Rectangle();}
		]);
		return MouseEventAnalyser;
	})()


	/**
	*本类提供obj相关的一些操作
	*@author ww
	*@version 1.0
	*
	*@created 2015-10-21 下午2:03:36
	*/
	//class laya.debug.tools.ObjectTools
	var ObjectTools=(function(){
		function ObjectTools(){}
		__class(ObjectTools,'laya.debug.tools.ObjectTools');
		ObjectTools.getFlatKey=function(tKey,aKey){
			if(tKey=="")return aKey;
			return tKey+ObjectTools.sign+aKey;
		}

		ObjectTools.flatObj=function(obj,rst,tKey){
			(tKey===void 0)&& (tKey="");
			rst=rst?rst:{};
			var key;
			var tValue;
			for(key in obj){
				if((typeof (obj[key])=='object')){
					ObjectTools.flatObj(obj[key],rst,ObjectTools.getFlatKey(tKey,key));
					}else{
					tValue=obj[key];
					rst[ObjectTools.getFlatKey(tKey,key)]=obj[key];
				}
			}
			return rst;
		}

		ObjectTools.recoverObj=function(obj){
			var rst={};
			var tKey;
			for(tKey in obj){
				ObjectTools.setKeyValue(rst,tKey,obj[tKey]);
			}
			return rst;
		}

		ObjectTools.differ=function(objA,objB){
			var tKey;
			var valueA;
			var valueB;
			objA=ObjectTools.flatObj(objA);
			objB=ObjectTools.flatObj(objB);
			var rst={};
			for(tKey in objA){
				if(!objB.hasOwnProperty(tKey)){
					rst[tKey]="被删除";
				}
			}
			for(tKey in objB){
				if(objB[tKey]!=objA[tKey]){
					rst[tKey]={"pre":objA[tKey],"now":objB[tKey]};
				}
			}
			return rst;
		}

		ObjectTools.traceDifferObj=function(obj){
			var key;
			var tO;
			for(key in obj){
				if((typeof (obj[key])=='string')){
					console.log(key+":",obj[key]);
					}else{
					tO=obj[key];
					console.log(key+":","now:",tO["now"],"pre:",tO["pre"]);
				}
			}
		}

		ObjectTools.setKeyValue=function(obj,flatKey,value){
			if(flatKey.indexOf(ObjectTools.sign)>=0){
				var keys=flatKey.split(ObjectTools.sign);
				var tKey;
				while(keys.length>1){
					tKey=keys.shift();
					if(!obj[tKey]){
						obj[tKey]={};
						console.log("addKeyObj:",tKey);
					}
					obj=obj[tKey];
					if(!obj){
						console.log("wrong flatKey:",flatKey);
						return;
					}
				}
				obj[keys.shift()]=value;
				}else{
				obj[flatKey]=value;
			}
		}

		ObjectTools.clearObj=function(obj){
			var key;
			for (key in obj){
				delete obj[key];
			}
		}

		ObjectTools.copyObjFast=function(obj){
			var jsStr;
			jsStr=laya.debug.tools.ObjectTools.getJsonString(obj);
			return laya.debug.tools.ObjectTools.getObj(jsStr);
		}

		ObjectTools.copyObj=function(obj){
			if((obj instanceof Array))return ObjectTools.copyArr(obj);
			var rst={};
			var key;
			for(key in obj){
				if(((obj[key])instanceof Array)){
					rst[key]=ObjectTools.copyArr(obj[key]);
				}
				else
				if((typeof (obj[key])=='object')){
					rst[key]=ObjectTools.copyObj(obj[key]);
					}else{
					rst[key]=obj[key];
				}
			}
			return rst;
		}

		ObjectTools.copyArr=function(arr){
			var rst;
			rst=[];
			var i=0,len=0;
			len=arr.length;
			for(i=0;i<len;i++){
				rst.push(ObjectTools.copyObj(arr[i]));
			}
			return rst;
		}

		ObjectTools.concatArr=function(src,a){
			if (!a)return src;
			if (!src)return a;
			var i=0,len=a.length;
			for (i=0;i < len;i++){
				src.push(a[i]);
			}
			return src;
		}

		ObjectTools.insertArrToArr=function(src,insertArr,pos){
			(pos===void 0)&& (pos=0);
			if (pos < 0)pos=0;
			if (pos > src.length)pos=src.length;
			var preLen=src.length;
			var i=0,len=0;
			src.length+=insertArr.length;
			var moveLen=0;
			moveLen=insertArr.length;
			for (i=src.length-1;i >=pos;i--){
				src[i]=src[i-moveLen];
			}
			len=insertArr.length;
			for (i=0;i < len;i++){
				src[pos+i]=insertArr[i];
			}
			return src;
		}

		ObjectTools.clearArr=function(arr){
			if (!arr)return arr;
			arr.length=0;
			return arr;
		}

		ObjectTools.removeFromArr=function(arr,item){
			var i=0,len=0;
			len=arr.length;
			for(i=0;i<len;i++){
				if(arr[i]==item){
					arr[i].splice(i,1);
					return;
				}
			}
		}

		ObjectTools.setValueArr=function(src,v){
			src || (src=[]);
			src.length=0;
			return ObjectTools.concatArr(src,v);
		}

		ObjectTools.getFrom=function(rst,src,count){
			var i=0;
			for (i=0;i < count;i++){
				rst.push(src[i]);
			}
			return rst;
		}

		ObjectTools.getFromR=function(rst,src,count){
			var i=0;
			for (i=0;i < count;i++){
				rst.push(src.pop());
			}
			return rst;
		}

		ObjectTools.enableDisplayTree=function(dis){
			while (dis){
				dis.mouseEnabled=true;
				dis=dis.parent;
			}
		}

		ObjectTools.getJsonString=function(obj){
			var rst;
			rst=JSON.stringify(obj);
			return rst;
		}

		ObjectTools.getObj=function(jsonStr){
			var rst;
			rst=JSON.parse(jsonStr);
			return rst;
		}

		ObjectTools.getKeyArr=function(obj){
			var rst;
			var key;
			rst=[];
			for(key in obj){
				rst.push(key);
			}
			return rst;
		}

		ObjectTools.getObjValues=function(dataList,key){
			var rst;
			var i=0,len=0;
			len=dataList.length;
			rst=[];
			for(i=0;i<len;i++){
				rst.push(dataList[i][key]);
			}
			return rst;
		}

		ObjectTools.hasKeys=function(obj,keys){
			var i=0,len=0;
			len=keys.length;
			for(i=0;i<len;i++){
				if(!obj.hasOwnProperty(keys[i]))return false;
			}
			return true;
		}

		ObjectTools.copyValueByArr=function(tar,src,keys){
			var i=0,len=keys.length;
			for(i=0;i<len;i++){
				if(!(src[keys[i]]===null))
					tar[keys[i]]=src[keys[i]];
			}
		}

		ObjectTools.insertValue=function(tar,src){
			var key;
			for (key in src){
				tar[key]=src[key];
			}
		}

		ObjectTools.replaceValue=function(obj,replaceO){
			var key;
			for(key in obj){
				if(replaceO.hasOwnProperty(obj[key])){
					obj[key]=replaceO[obj[key]];
				}
				if((typeof (obj[key])=='object')){
					ObjectTools.replaceValue(obj[key],replaceO);
				}
			}
		}

		ObjectTools.setKeyValues=function(items,key,value){
			var i=0,len=0;
			len=items.length;
			for(i=0;i<len;i++){
				items[i][key]=value;
			}
		}

		ObjectTools.findItemPos=function(items,sign,value){
			var i=0,len=0;
			len=items.length;
			for(i=0;i<len;i++){
				if(items[i][sign]==value){
					return i;
				}
			}
			return-1;
		}

		ObjectTools.setObjValue=function(obj,key,value){
			obj[key]=value;
			return obj;
		}

		ObjectTools.setAutoTypeValue=function(obj,key,value){
			if(obj.hasOwnProperty(key)){
				if(ObjectTools.isNumber(obj[key])){
					obj[key]=parseFloat(value);
					}else{
					obj[key]=value;
				}
				}else{
				obj[key]=value;
			}
			return obj;
		}

		ObjectTools.getAutoValue=function(value){
			if (parseFloat(value)==value)return parseFloat(value);
			return value;
		}

		ObjectTools.isNumber=function(value){
			return (parseFloat(value)==value);
		}

		ObjectTools.isNaNS=function(value){
			return (value.toString()=="NaN");
		}

		ObjectTools.isNaN=function(value){
			if(typeof(value)=="number")return false;
			if(typeof(value)=="string"){
				if(parseFloat(value).toString()!="NaN"){
					if(parseFloat(value)==value){
						return false;
					}
				}
			}
			return true;
		}

		ObjectTools.getStrTypedValue=function(value){
			if(value=="false"){
				return false;
			}else
			if(value=="true"){
				return true;
			}else
			if(value=="null"){
				return null;
			}else
			if(value=="undefined"){
				return null;
				}else{
				return ObjectTools.getAutoValue(value);
			}
		}

		ObjectTools.createKeyValueDic=function(dataList,keySign){
			var rst;
			rst={};
			var i=0,len=0;
			len=dataList.length;
			var tItem;
			var tKey;
			for(i=0;i<len;i++){
				tItem=dataList[i];
				tKey=tItem[keySign];
				rst[tKey]=tItem;
			}
			return rst;
		}

		ObjectTools.sign="_";
		return ObjectTools;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.debug.tools.ObjTimeCountTool
	var ObjTimeCountTool=(function(){
		function ObjTimeCountTool(){
			this.timeDic={};
			this.resultDic={};
			this.countDic={};
			this.resultCountDic={};
			this.nodeDic={};
			this.resultNodeDic={};
		}

		__class(ObjTimeCountTool,'laya.debug.tools.ObjTimeCountTool');
		var __proto=ObjTimeCountTool.prototype;
		__proto.addTime=function(sprite,time){
			IDTools.idObj(sprite);
			var key=0;
			key=IDTools.getObjID(sprite);
			if (!this.timeDic.hasOwnProperty(key)){
				this.timeDic[key]=0;
			}
			this.timeDic[key]=this.timeDic[key]+time;
			if (!this.countDic.hasOwnProperty(key)){
				this.countDic[key]=0;
			}
			this.countDic[key]=this.countDic[key]+1;
			this.nodeDic[key]=sprite;
		}

		__proto.getTime=function(sprite){
			IDTools.idObj(sprite);
			var key=0;
			key=IDTools.getObjID(sprite);
			if (!this.resultDic[key])return 0;
			return this.resultDic[key];
		}

		__proto.getCount=function(sprite){
			IDTools.idObj(sprite);
			var key=0;
			key=IDTools.getObjID(sprite);
			return this.resultCountDic[key];
		}

		__proto.reset=function(){
			var key;
			for (key in this.timeDic){
				this.timeDic[key]=0;
				this.countDic[key]=0;
			}
			ObjectTools.clearObj(this.nodeDic);
		}

		__proto.updates=function(){
			ObjectTools.clearObj(this.resultDic);
			ObjectTools.insertValue(this.resultDic,this.timeDic);
			ObjectTools.clearObj(this.resultCountDic);
			ObjectTools.insertValue(this.resultCountDic,this.countDic);
			ObjectTools.insertValue(this.resultNodeDic,this.nodeDic);
			this.reset();
		}

		return ObjTimeCountTool;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-12-23 下午12:00:48
	*/
	//class laya.debug.tools.RecInfo
	var RecInfo=(function(){
		function RecInfo(){
			this.oX=0;
			this.oY=0;
			this.hX=1;
			this.hY=0;
			this.vX=0;
			this.vY=1;
		}

		__class(RecInfo,'laya.debug.tools.RecInfo');
		var __proto=RecInfo.prototype;
		__proto.initByPoints=function(oPoint,ePoint,vPoint){
			this.oX=oPoint.x;
			this.oY=oPoint.y;
			this.hX=ePoint.x;
			this.hY=ePoint.y;
			this.vX=vPoint.x;
			this.vY=vPoint.y;
		}

		__getset(0,__proto,'rotation',function(){
			return this.rotationRad/Math.PI*180;
		});

		__getset(0,__proto,'width',function(){
			return Math.sqrt((this.hX-this.oX)*(this.hX-this.oX)+(this.hY-this.oY)*(this.hY-this.oY));
		});

		__getset(0,__proto,'x',function(){
			return this.oX;
		});

		__getset(0,__proto,'rotationRadV',function(){
			var dx=this.vX-this.oX;
			var dy=this.vY-this.oY;
			return Math.atan2(dy,dx);
		});

		__getset(0,__proto,'y',function(){
			return this.oY;
		});

		__getset(0,__proto,'rotationRad',function(){
			var dx=this.hX-this.oX;
			var dy=this.hY-this.oY;
			return Math.atan2(dy,dx);
		});

		__getset(0,__proto,'height',function(){
			return Math.sqrt((this.vX-this.oX)*(this.vX-this.oX)+(this.vY-this.oY)*(this.vY-this.oY));
		});

		__getset(0,__proto,'rotationV',function(){
			return this.rotationRadV/Math.PI*180;
		});

		RecInfo.createByPoints=function(oPoint,ePoint,vPoint){
			var rst;
			rst=new RecInfo();
			rst.initByPoints(oPoint,ePoint,vPoint);
			return rst;
		}

		RecInfo.getGlobalPoints=function(sprite,x,y){
			return sprite.localToGlobal(new Point(x,y));
		}

		RecInfo.getGlobalRecInfo=function(sprite,x0,y0,x1,y1,x2,y2){
			(x0===void 0)&& (x0=0);
			(y0===void 0)&& (y0=0);
			(x1===void 0)&& (x1=1);
			(y1===void 0)&& (y1=0);
			(x2===void 0)&& (x2=0);
			(y2===void 0)&& (y2=1);
			return RecInfo.createByPoints(RecInfo.getGlobalPoints(sprite,x0,y0),RecInfo.getGlobalPoints(sprite,x1,y1),RecInfo.getGlobalPoints(sprite,x2,y2));
		}

		return RecInfo;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.debug.tools.RenderAnalyser
	var RenderAnalyser=(function(){
		function RenderAnalyser(){
			this.timeDic={};
			this.resultDic={};
			this.countDic={};
			this.resultCountDic={};
			this.nodeDic={};
			this.isWorking=false;
			this.working=true;
		}

		__class(RenderAnalyser,'laya.debug.tools.RenderAnalyser');
		var __proto=RenderAnalyser.prototype;
		__proto.render=function(sprite,time){
			this.addTime(sprite,time);
		}

		__proto.addTime=function(sprite,time){
			IDTools.idObj(sprite);
			var key=0;
			key=IDTools.getObjID(sprite);
			if (!this.timeDic.hasOwnProperty(key)){
				this.timeDic[key]=0;
			}
			this.timeDic[key]=this.timeDic[key]+time;
			if (!this.countDic.hasOwnProperty(key)){
				this.countDic[key]=0;
			}
			this.countDic[key]=this.countDic[key]+1;
			this.nodeDic[key]=sprite;
		}

		__proto.getTime=function(sprite){
			IDTools.idObj(sprite);
			var key=0;
			key=IDTools.getObjID(sprite);
			if (!this.resultDic[key])return 0;
			return this.resultDic[key];
		}

		__proto.getCount=function(sprite){
			IDTools.idObj(sprite);
			var key=0;
			key=IDTools.getObjID(sprite);
			return this.resultCountDic[key];
		}

		__proto.reset=function(){
			var key;
			for (key in this.timeDic){
				this.timeDic[key]=0;
				this.countDic[key]=0;
			}
			ObjectTools.clearObj(this.nodeDic);
		}

		__proto.updates=function(){
			ObjectTools.clearObj(this.resultDic);
			ObjectTools.insertValue(this.resultDic,this.timeDic);
			ObjectTools.clearObj(this.resultCountDic);
			ObjectTools.insertValue(this.resultCountDic,this.countDic);
			this.reset();
		}

		__getset(0,__proto,'working',null,function(v){
			this.isWorking=v;
			if (v){
				Laya.timer.loop(NodeConsts.RenderCostMaxTime,this,this.updates);
				}else{
				Laya.timer.clear(this,this.updates);
			}
		});

		__static(RenderAnalyser,
		['I',function(){return this.I=new RenderAnalyser();}
		]);
		return RenderAnalyser;
	})()


	/**
	*本类用于调整对象的宽高以及坐标
	*@author ww
	*/
	//class laya.debug.tools.resizer.DisResizer
	var DisResizer=(function(){
		function DisResizer(){}
		__class(DisResizer,'laya.debug.tools.resizer.DisResizer');
		DisResizer.init=function(){
			if (DisResizer._up)return;
			DisResizer._up=new AutoFillRec("T");
			DisResizer._up.height=2;
			DisResizer._up.type=0;
			DisResizer._down=new AutoFillRec("T");
			DisResizer._down.height=2;
			DisResizer._down.type=0;
			DisResizer._left=new AutoFillRec("R");
			DisResizer._left.width=2;
			DisResizer._left.type=1;
			DisResizer._right=new AutoFillRec("R");
			DisResizer._right.width=2;
			DisResizer._right.type=1;
			DisResizer._barList=[DisResizer._up,DisResizer._down,DisResizer._left,DisResizer._right];
			DisResizer.addEvent();
		}

		DisResizer.stageDown=function(e){
			var target;
			target=e.target;
			if (DisResizer._tar && DisControlTool.isInTree(DisResizer._tar,target)){
				return;
			}
			DisResizer.clear();
		}

		DisResizer.clear=function(){
			DisResizer._tar=null;
			Laya.stage.off("mouseup",null,DisResizer.stageDown);
			DisControlTool.removeItems(DisResizer._barList);
			DisResizer.clearDragEvents();
		}

		DisResizer.addEvent=function(){
			var i=0,len=0;
			var tBar;
			len=DisResizer._barList.length;
			for (i=0;i < len;i++){
				tBar=DisResizer._barList[i];
				tBar.on("mousedown",null,DisResizer.barDown);
			}
		}

		DisResizer.barDown=function(e){
			DisResizer.clearDragEvents();
			DisResizer.tBar=e.target;
			if (!DisResizer.tBar)return;
			var area;
			area=new Rectangle();
			if (DisResizer.tBar.type==0){
				area.x=DisResizer.tBar.x;
				area.width=0;
				area.y=DisResizer.tBar.y-200;
				area.height=400;
				}else{
				area.x=DisResizer.tBar.x-200;
				area.width=400;
				area.y=0;
				area.height=0;
			};
			var option;
			option={};
			option.area=area;
			DisResizer.tBar.record();
			DisResizer.tBar.startDrag(area);
			DisResizer.tBar.on("dragmove",null,DisResizer.draging);
			DisResizer.tBar.on("dragend",null,DisResizer.dragEnd);
		}

		DisResizer.draging=function(e){
			console.log("draging");
			if (!DisResizer.tBar)return;
			if (!DisResizer._tar)return;
			switch(DisResizer.tBar){
				case DisResizer._left:
					DisResizer._tar.x+=DisResizer.tBar.getDx();
					DisResizer._tar.width-=DisResizer.tBar.getDx();
					DisResizer._up.width-=DisResizer.tBar.getDx();
					DisResizer._down.width-=DisResizer.tBar.getDx();
					DisResizer._right.x-=DisResizer.tBar.getDx();
					DisResizer.tBar.x-=DisResizer.tBar.getDx();
					break ;
				case DisResizer._right:
					DisResizer._tar.width+=DisResizer.tBar.getDx();
					DisResizer._up.width+=DisResizer.tBar.getDx();
					DisResizer._down.width+=DisResizer.tBar.getDx();
					break ;
				case DisResizer._up:
					DisResizer._tar.y+=DisResizer.tBar.getDy();
					DisResizer._tar.height-=DisResizer.tBar.getDy();
					DisResizer._right.height-=DisResizer.tBar.getDy();
					DisResizer._left.height-=DisResizer.tBar.getDy();
					DisResizer._down.y-=DisResizer.tBar.getDy();
					DisResizer.tBar.y-=DisResizer.tBar.getDy();
					break ;
				case DisResizer._down:
					DisResizer._tar.height+=DisResizer.tBar.getDy();
					DisResizer._right.height+=DisResizer.tBar.getDy();
					DisResizer._left.height+=DisResizer.tBar.getDy();
					break ;
				}
			DisResizer.tBar.record();
		}

		DisResizer.dragEnd=function(e){
			console.log("dragEnd");
			DisResizer.clearDragEvents();
			DisResizer.updates();
		}

		DisResizer.clearDragEvents=function(){
			if (!DisResizer.tBar)return;
			DisResizer.tBar.off("dragmove",null,DisResizer.draging);
			DisResizer.tBar.off("dragend",null,DisResizer.dragEnd);
		}

		DisResizer.setUp=function(dis,force){
			(force===void 0)&& (force=false);
			if (force && dis==DisResizer._tar){
				return;
			};
			DisControlTool.removeItems(DisResizer._barList);
			if (DisResizer._tar==dis){
				DisResizer._tar=null;
				DisResizer.clearDragEvents();
				if(!force)
					return;
			}
			DisResizer._tar=dis;
			DisResizer.updates();
			DisControlTool.addItems(DisResizer._barList,dis);
			Laya.stage.off("mouseup",null,DisResizer.stageDown);
			Laya.stage.on("mouseup",null,DisResizer.stageDown);
		}

		DisResizer.updates=function(){
			var dis;
			dis=DisResizer._tar;
			if(!dis)return;
			var bounds;
			bounds=new Rectangle(0,0,dis.width,dis.height);
			DisResizer._up.x=bounds.x;
			DisResizer._up.y=bounds.y;
			DisResizer._up.width=bounds.width;
			DisResizer._down.x=bounds.x;
			DisResizer._down.y=bounds.y+bounds.height-2;
			DisResizer._down.width=bounds.width;
			DisResizer._left.x=bounds.x;
			DisResizer._left.y=bounds.y;
			DisResizer._left.height=bounds.height;
			DisResizer._right.x=bounds.x+bounds.width-2;
			DisResizer._right.y=bounds.y;
			DisResizer._right.height=bounds.height;
		}

		DisResizer.Side=2;
		DisResizer.Vertical=1;
		DisResizer.Horizon=0;
		DisResizer._up=null
		DisResizer._down=null
		DisResizer._left=null
		DisResizer._right=null
		DisResizer._barList=null
		DisResizer._tar=null
		DisResizer.barWidth=2;
		DisResizer.useGetBounds=false;
		DisResizer.tBar=null
		return DisResizer;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.debug.tools.resizer.SimpleResizer
	var SimpleResizer=(function(){
		function SimpleResizer(){}
		__class(SimpleResizer,'laya.debug.tools.resizer.SimpleResizer');
		SimpleResizer.setResizeAble=function(clickItem,tar,minWidth,minHeight){
			(minWidth===void 0)&& (minWidth=150);
			(minHeight===void 0)&& (minHeight=150);
			clickItem.on("mousedown",null,SimpleResizer.onMouseDown,[tar,minWidth,minHeight]);
		}

		SimpleResizer.onMouseDown=function(tar,minWidth,minHeight,e){
			SimpleResizer.clearEvents();
			if (!tar)return;
			SimpleResizer.preMousePoint.setTo(Laya.stage.mouseX,Laya.stage.mouseY);
			SimpleResizer.preTarSize.setTo(tar.width,tar.height);
			SimpleResizer.preScale.setTo(1,1);
			var rTar;
			rTar=tar;
			while (rTar&&rTar!=Laya.stage){
				SimpleResizer.preScale.x *=rTar.scaleX;
				SimpleResizer.preScale.y *=rTar.scaleY;
				rTar=rTar.parent;
			}
			Laya.stage.on("mouseup",null,SimpleResizer.onMouseMoveEnd);
			Laya.timer.loop(100,null,SimpleResizer.onMouseMoving,[tar,minWidth,minHeight]);
		}

		SimpleResizer.onMouseMoving=function(tar,minWidth,minHeight,e){
			var tWidth=(Laya.stage.mouseX-SimpleResizer.preMousePoint.x)/ SimpleResizer.preScale.x+SimpleResizer.preTarSize.x;
			var tHeight=(Laya.stage.mouseY-SimpleResizer.preMousePoint.y)/SimpleResizer.preScale.y+SimpleResizer.preTarSize.y;
			tar.width=tWidth > minWidth?tWidth:minWidth;
			tar.height=tHeight>minHeight?tHeight:minHeight;
		}

		SimpleResizer.onMouseMoveEnd=function(e){
			SimpleResizer.clearEvents();
		}

		SimpleResizer.clearEvents=function(){
			Laya.timer.clear(null,SimpleResizer.onMouseMoving);
			Laya.stage.off("mouseup",null,SimpleResizer.onMouseMoveEnd);
		}

		__static(SimpleResizer,
		['preMousePoint',function(){return this.preMousePoint=new Point();},'preTarSize',function(){return this.preTarSize=new Point();},'preScale',function(){return this.preScale=new Point();}
		]);
		return SimpleResizer;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.debug.tools.ResTools
	var ResTools=(function(){
		function ResTools(){}
		__class(ResTools,'laya.debug.tools.ResTools');
		ResTools.getCachedResList=function(){
			if (Render.isWebGL){
				return ResTools.getWebGlResList();
				}else{
				return ResTools.getCanvasResList();
			}
		}

		ResTools.getWebGlResList=function(){
			var rst;
			rst=[];
			var tResource;
			var _resources;
			_resources=ResourceManager.currentResourceManager["_resources"];
			for(var i=0;i <_resources.length;i++){
				tResource=_resources[i];
				if(ClassTool.getClassName(tResource)=="WebGLImage"){
					var url=tResource["src"];
					if(url&&url.indexOf("data:image/png;base64")<0)
						rst.push(url);
				}
			}
			return rst;
		}

		ResTools.getCanvasResList=function(){
			var picDic;
			picDic={};
			var dataO;
			dataO=Loader.loadedMap;
			ResTools.collectPics(dataO,picDic);
			return ResTools.getArrFromDic(picDic);
		}

		ResTools.getArrFromDic=function(dic){
			var key;
			var rst;
			rst=[];
			for (key in dic){
				rst.push(key);
			}
			return rst;
		}

		ResTools.collectPics=function(dataO,picDic){
			if (!dataO)return;
			var key;
			var tTexture;
			for (key in dataO){
				tTexture=dataO[key];
				if (tTexture){
					if (tTexture.bitmap&&tTexture.bitmap.src){
						var url=tTexture.bitmap.src;
						if(url.indexOf("data:image/png;base64")<0)
							picDic[tTexture.bitmap.src]=true;
					}
				}
			}
		}

		return ResTools;
	})()


	/**
	*类实例创建分析工具
	*@author ww
	*@version 1.0
	*
	*@created 2015-9-25 下午3:31:46
	*/
	//class laya.debug.tools.RunProfile
	var RunProfile=(function(){
		function RunProfile(){}
		__class(RunProfile,'laya.debug.tools.RunProfile');
		RunProfile.run=function(funName,callLen){
			(callLen===void 0)&& (callLen=3);
			var tCount;
			if(!RunProfile.infoDic.hasOwnProperty(funName)){
				RunProfile.infoDic[funName]=new CountTool();
			}
			tCount=RunProfile.infoDic[funName];
			var msg;
			msg=TraceTool.getCallLoc(callLen)+"\n"+TraceTool.getCallStack(1,callLen-3);
			tCount.add(msg);
			if(RunProfile._runShowDic[funName]){
				console.log("Create:"+funName);
				console.log(msg);
			}
		}

		RunProfile.showClassCreate=function(funName){
			RunProfile._runShowDic[funName]=true;
		}

		RunProfile.hideClassCreate=function(funName){
			RunProfile._runShowDic[funName]=false;
		}

		RunProfile.getRunInfo=function(funName){
			var rst;
			rst=RunProfile.infoDic[funName];
			if(rst){
			}
			return RunProfile.infoDic[funName];
		}

		RunProfile.runTest=function(fun,count,sign){
			(sign===void 0)&& (sign="runTest");
			DTrace.timeStart(sign);
			var i=0;
			for(i=0;i<count;i++){
				fun();
			}
			DTrace.timeEnd(sign);
		}

		RunProfile.infoDic={};
		RunProfile._runShowDic={};
		return RunProfile;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-6-24 下午6:07:30
	*/
	//class laya.debug.tools.SingleTool
	var SingleTool=(function(){
		function SingleTool(){
			this._objDic={};
		}

		__class(SingleTool,'laya.debug.tools.SingleTool');
		var __proto=SingleTool.prototype;
		__proto.getArr=function(sign){
			var dic;
			dic=this.getTypeDic("Array");
			if(!dic[sign])dic[sign]=[];
			return dic[sign];
		}

		__proto.getObject=function(sign){
			var dic;
			dic=this.getTypeDic("Object");
			if(!dic[sign])dic[sign]={};
			return dic[sign];
		}

		__proto.getByClass=function(sign,clzSign,clz){
			var dic;
			dic=this.getTypeDic(clzSign);
			if(!dic[sign])dic[sign]=new clz();
			return dic[sign];
		}

		__proto.getTypeDic=function(type){
			if(!this._objDic[type])this._objDic[type]={};
			return this._objDic[type];
		}

		__static(SingleTool,
		['I',function(){return this.I=new SingleTool();}
		]);
		return SingleTool;
	})()


	/**
	*一些字符串操作函数
	*@author ww
	*
	*/
	//class laya.debug.tools.StringTool
	var StringTool=(function(){
		function StringTool(){}
		__class(StringTool,'laya.debug.tools.StringTool');
		StringTool.toUpCase=function(str){
			return str.toUpperCase();
		}

		StringTool.toLowCase=function(str){
			return str.toLowerCase();
		}

		StringTool.toUpHead=function(str){
			var rst;
			if(str.length<=1)return str.toUpperCase();
			rst=str.charAt(0).toUpperCase()+str.substr(1);
			return rst;
		}

		StringTool.toLowHead=function(str){
			var rst;
			if(str.length<=1)return str.toLowerCase();
			rst=str.charAt(0).toLowerCase()+str.substr(1);
			return rst;
		}

		StringTool.packageToFolderPath=function(packageName){
			var rst;
			rst=packageName.replace(".","/");
			return rst;
		}

		StringTool.insert=function(str,iStr,index){
			return str.substring(0,index)+iStr+str.substr(index);
		}

		StringTool.insertAfter=function(str,iStr,tarStr,isLast){
			(isLast===void 0)&& (isLast=false);
			var i=0;
			if(isLast){
				i=str.lastIndexOf(tarStr);
				}else{
				i=str.indexOf(tarStr);
			}
			if(i>=0){
				return StringTool.insert(str,iStr,i+tarStr.length);
			}
			return str;
		}

		StringTool.insertBefore=function(str,iStr,tarStr,isLast){
			(isLast===void 0)&& (isLast=false);
			var i=0;
			if(isLast){
				i=str.lastIndexOf(tarStr);
				}else{
				i=str.indexOf(tarStr);
			}
			if(i>=0){
				return StringTool.insert(str,iStr,i);
			}
			return str;
		}

		StringTool.insertParamToFun=function(funStr,params){
			var oldParam;
			oldParam=StringTool.getParamArr(funStr);
			var inserStr;
			inserStr=params.join(",");
			if(oldParam.length>0){
				inserStr=","+inserStr;
			}
			return StringTool.insertBefore(funStr,inserStr,")",true);
		}

		StringTool.trim=function(str,vList){
			if(!vList){
				vList=[" ","\r","\n","\t",String.fromCharCode(65279)];
			};
			var rst;
			var i=0;
			var len=0;
			rst=str;
			len=vList.length;
			for(i=0;i<len;i++){
				rst=StringTool.getReplace(rst,vList[i],"");
			}
			return rst;
		}

		StringTool.isEmpty=function(str){
			if(str.length<1)return true;
			return StringTool.emptyStrDic.hasOwnProperty(str);
		}

		StringTool.trimLeft=function(str){
			var i=0;
			i=0;
			var len=0;
			len=str.length;
			while(StringTool.isEmpty(str.charAt(i))&&i<len){
				i++;
			}
			if(i<len){
				return str.substr(i);
			}
			return "";
		}

		StringTool.trimRight=function(str){
			var i=0;
			i=str.length-1;
			while(StringTool.isEmpty(str.charAt(i))&&i>=0){
				i--;
			};
			var rst;
			rst=str.substring(0,i)
			if(i>=0){
				return str.substring(0,i+1);
			}
			return "";
		}

		StringTool.trimSide=function(str){
			var rst;
			rst=StringTool.trimLeft(str);
			rst=StringTool.trimRight(rst);
			return rst;
		}

		StringTool.isOkFileName=function(fileName){
			if(laya.debug.tools.StringTool.trimSide(fileName)=="")return false;
			var i=0,len=0;
			len=fileName.length;
			for(i=0;i<len;i++){
				if(StringTool.specialChars[fileName.charAt(i)])return false;
			}
			return true;
		}

		StringTool.trimButEmpty=function(str){
			return StringTool.trim(str,["\r","\n","\t"]);
		}

		StringTool.removeEmptyStr=function(strArr){
			var i=0;
			i=strArr.length-1;
			var str;
			for(i=i;i>=0;i--){
				str=strArr[i];
				str=laya.debug.tools.StringTool.trimSide(str);
				if(StringTool.isEmpty(str)){
					strArr.splice(i,1);
					}else{
					strArr[i]=str;
				}
			}
			return strArr;
		}

		StringTool.ifNoAddToTail=function(str,sign){
			if(str.indexOf(sign)>=0){
				return str;
			}
			return str+sign;
		}

		StringTool.trimEmptyLine=function(str){
			var i=0;
			var len=0;
			var tLines;
			var tLine;
			tLines=str.split("\n");
			for(i=tLines.length-1;i>=0;i--){
				tLine=tLines[i];
				if(StringTool.isEmptyLine(tLine)){
					tLines.splice(i,1);
				}
			}
			return tLines.join("\n");
		}

		StringTool.isEmptyLine=function(str){
			str=laya.debug.tools.StringTool.trim(str);
			if(str=="")return true;
			return false;
		}

		StringTool.removeCommentLine=function(lines){
			var rst;
			rst=[];
			var i=0;
			var tLine;
			var adptLine;
			i=0;
			var len=0;
			var index=0;
			len=lines.length;
			while(i<len){
				adptLine=tLine=lines[i];
				index=tLine.indexOf("/**");
				if(index>=0){
					adptLine=tLine.substring(0,index-1);
					StringTool.addIfNotEmpty(rst,adptLine);
					while(i<len){
						tLine=lines[i];
						index=tLine.indexOf("*/");
						if(index>=0){
							adptLine=tLine.substring(index+2);
							StringTool.addIfNotEmpty(rst,adptLine);
							break ;
						}
						i++;
					}
					}else if(tLine.indexOf("//")>=0){
					if(laya.debug.tools.StringTool.trim(tLine).indexOf("//")==0){
						}else{
						StringTool.addIfNotEmpty(rst,adptLine);
					}
					}else{
					StringTool.addIfNotEmpty(rst,adptLine);
				}
				i++;
			}
			return rst;
		}

		StringTool.addIfNotEmpty=function(arr,str){
			if(!str)return;
			var tStr;
			tStr=StringTool.trim(str);
			if(tStr!=""){
				arr.push(str);
			}
		}

		StringTool.trimExt=function(str,vars){
			var rst;
			rst=StringTool.trim(str);
			var i=0;
			var len=0;
			len=vars.length;
			for(i=0;i<len;i++){
				rst=StringTool.getReplace(rst,vars[i],"");
			}
			return rst;
		}

		StringTool.getBetween=function(str,left,right,ifMax){
			(ifMax===void 0)&& (ifMax=false);
			if(!str)return "";
			if(!left)return "";
			if(!right)return "";
			var lId=0;
			var rId=0;
			lId=str.indexOf(left);
			if(lId<0)return"";
			if(ifMax){
				rId=str.lastIndexOf(right);
				if(rId<lId)return "";
				}else{
				rId=str.indexOf(right,lId);
			}
			if(rId<0)return "";
			return str.substring(lId+left.length,rId);
		}

		StringTool.getSplitLine=function(line,split){
			(split===void 0)&& (split=" ");
			return line.split(split);
		}

		StringTool.getLeft=function(str,sign){
			var i=0;
			i=str.indexOf(sign);
			return str.substr(0,i);
		}

		StringTool.getRight=function(str,sign){
			var i=0;
			i=str.indexOf(sign);
			return str.substr(i+1);
		}

		StringTool.delelteItem=function(arr){
			while (arr.length>0){
				if(arr[0]==""){
					arr.shift();
					}else{
					break ;
				}
			}
		}

		StringTool.getWords=function(line){
			var rst=StringTool.getSplitLine(line);
			StringTool.delelteItem(rst);
			return rst;
		}

		StringTool.getLinesI=function(startLine,endLine,lines){
			var i=0;
			var rst=[];
			for(i=startLine;i<=endLine;i++){
				rst.push(lines[i]);
			}
			return rst;
		}

		StringTool.structfy=function(str,inWidth,removeEmpty){
			(inWidth===void 0)&& (inWidth=4);
			(removeEmpty===void 0)&& (removeEmpty=true);
			if(removeEmpty){
				str=laya.debug.tools.StringTool.trimEmptyLine(str);
			};
			var lines;
			var tIn=0;
			tIn=0;
			var tInStr;
			tInStr=StringTool.getEmptyStr(0);
			lines=str.split("\n");
			var i=0;
			var len=0;
			var tLineStr;
			len=lines.length;
			for(i=0;i<len;i++){
				tLineStr=lines[i];
				tLineStr=laya.debug.tools.StringTool.trimLeft(tLineStr);
				tLineStr=laya.debug.tools.StringTool.trimRight(tLineStr);
				tIn+=StringTool.getPariCount(tLineStr);
				if(tLineStr.indexOf("}")>=0){
					tInStr=StringTool.getEmptyStr(tIn*inWidth);
				}
				tLineStr=tInStr+tLineStr;
				lines[i]=tLineStr;
				tInStr=StringTool.getEmptyStr(tIn*inWidth);
			}
			return lines.join("\n");
		}

		StringTool.getEmptyStr=function(width){
			if(!StringTool.emptyDic.hasOwnProperty(width)){
				var i=0;
				var len=0;
				len=width;
				var rst;
				rst="";
				for(i=0;i<len;i++){
					rst+=" ";
				}
				StringTool.emptyDic[width]=rst;
			}
			return StringTool.emptyDic[width];
		}

		StringTool.getPariCount=function(str,inChar,outChar){
			(inChar===void 0)&& (inChar="{");
			(outChar===void 0)&& (outChar="}");
			var varDic;
			varDic={};
			varDic[inChar]=1;
			varDic[outChar]=-1;
			var i=0;
			var len=0;
			var tChar;
			len=str.length;
			var rst=0;
			rst=0;
			for(i=0;i<len;i++){
				tChar=str.charAt(i);
				if(varDic.hasOwnProperty(tChar)){
					rst+=varDic[tChar];
				}
			}
			return rst;
		}

		StringTool.readInt=function(str,startI){
			(startI===void 0)&& (startI=0);
			var rst=NaN;
			rst=0;
			var tNum=0;
			var tC;
			var i=0;
			var isBegin=false;
			isBegin=false;
			var len=0;
			len=str.length;
			for(i=startI;i<len;i++){
				tC=str.charAt(i);
				if(Number(tC)>0||tC=="0"){
					rst=10*rst+Number(tC);
					if(rst>0)isBegin=true;
					}else{
					if(isBegin)return rst;
				}
			}
			return rst;
		}

		StringTool.getReplace=function(str,oStr,nStr){
			if(!str)return "";
			var rst;
			rst=str.replace(new RegExp(oStr,"g"),nStr);
			return rst;
		}

		StringTool.getWordCount=function(str,findWord){
			var rg=new RegExp(findWord,"g")
			return str.match(rg).length;
		}

		StringTool.getResolvePath=function(path,basePath){
			if(StringTool.isAbsPath(path)){
				return path;
			};
			var tSign;
			tSign="\\";
			if(basePath.indexOf("/")>=0){
				tSign="/";
			}
			if(basePath.charAt(basePath.length-1)==tSign){
				basePath=basePath.substr(0,basePath.length-1);
			};
			var parentSign;
			parentSign=".."+tSign;
			var tISign;
			tISign="."+tSign;
			var pCount=0;
			pCount=StringTool.getWordCount(path,parentSign);
			path=laya.debug.tools.StringTool.getReplace(path,parentSign,"");
			path=laya.debug.tools.StringTool.getReplace(path,tISign,"");
			var i=0;
			var len=0;
			len=pCount;
			var iPos=0;
			for(i=0;i<len;i++){
				basePath=StringTool.removeLastSign(path,tSign);
			}
			return basePath+tSign+path;
		}

		StringTool.isAbsPath=function(path){
			if(path.indexOf(":")>=0)return true;
			return false;
		}

		StringTool.removeLastSign=function(str,sign){
			var iPos=0;
			iPos=str.lastIndexOf(sign);
			str=str.substring(0,iPos);
			return str;
		}

		StringTool.getParamArr=function(str){
			var paramStr;
			paramStr=laya.debug.tools.StringTool.getBetween(str,"(",")",true);
			if(StringTool.trim(paramStr).length<1)return [];
			return paramStr.split(",");
		}

		StringTool.copyStr=function(str){
			return str.substring();
		}

		StringTool.ArrayToString=function(arr){
			var rst;
			rst="[{items}]".replace(new RegExp("\\{items\\}","g"),StringTool.getArrayItems(arr));
			return rst;
		}

		StringTool.getArrayItems=function(arr){
			var rst;
			if(arr.length<1)return "";
			rst=StringTool.parseItem(arr[0]);
			var i=0;
			var len=0;
			len=arr.length;
			for(i=1;i<len;i++){
				rst+=","+StringTool.parseItem(arr[i]);
			}
			return rst;
		}

		StringTool.parseItem=function(item){
			var rst;
			rst="\""+item+"\"";
			return "";
		}

		StringTool.emptyDic={};
		__static(StringTool,
		['emptyStrDic',function(){return this.emptyStrDic={
				" ":true,
				"\r":true,
				"\n":true,
				"\t":true
		};},'specialChars',function(){return this.specialChars={"*":true,"&":true,"%":true,"#":true,"?":true};}

		]);
		return StringTool;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-9-25 上午10:48:54
	*/
	//class laya.debug.tools.TraceTool
	var TraceTool=(function(){
		function TraceTool(){}
		__class(TraceTool,'laya.debug.tools.TraceTool');
		TraceTool.closeAllLog=function(){
			var logFun;
			logFun=TraceTool.emptyLog;
			Browser.window.console.log=logFun;
		}

		TraceTool.emptyLog=function(){}
		TraceTool.traceObj=function(obj){
			TraceTool.tempArr.length=0;
			var key;
			for(key in obj){
				TraceTool.tempArr.push(key+":"+obj[key]);
			};
			var rst;
			rst=TraceTool.tempArr.join("\n");
			console.log(rst);
			return rst;
		}

		TraceTool.traceObjR=function(obj){
			TraceTool.tempArr.length=0;
			var key;
			for(key in obj){
				TraceTool.tempArr.push(obj[key]+":"+key);
			};
			var rst;
			rst=TraceTool.tempArr.join("\n");
			console.log(rst);
			return rst;
		}

		TraceTool.traceSize=function(tar){
			DebugTool.dTrace("Size: x:"+tar.x+" y:"+tar.y+" w:"+tar.width+" h:"+tar.height+" scaleX:"+tar.scaleX+" scaleY:"+tar.scaleY);
		}

		TraceTool.traceSplit=function(msg){
			console.log("---------------------"+msg+"---------------------------");
		}

		TraceTool.group=function(gName){
			console.group(gName);;
		}

		TraceTool.groupEnd=function(){
			console.groupEnd();;
		}

		TraceTool.getCallStack=function(life,s){
			(life===void 0)&& (life=1);
			(s===void 0)&& (s=1);
			var caller;
			caller=TraceTool.getCallStack;
			caller=caller.caller.caller;
			var msg;
			msg="";
			while(caller&&life>0){
				if(s<=0){
					msg+=caller+"<-";
					life--;
					}else{
				}
				caller=caller.caller;
				s--;
			}
			return msg;
		}

		TraceTool.getCallLoc=function(index){
			(index===void 0)&& (index=2);
			var loc;
			try {
				TraceTool.Erroer.i++;
				}catch (e){
				var arr;
				arr=e.stack.replace(/Error\n/).split(/\n/);
				if (arr[index]){
					loc=arr[index].replace(/^\s+|\s+$/,"");
					}else{
					loc="unknow";
				}
			}
			return loc;
		}

		TraceTool.traceCallStack=function(){
			var loc;
			try {
				TraceTool.Erroer.i++;
				}catch (e){
				loc=e.stack;
			}
			console.log(loc);
			return loc;
		}

		TraceTool.getPlaceHolder=function(len){
			if(!TraceTool.holderDic.hasOwnProperty(len)){
				var rst;
				rst="";
				var i=0;
				for(i=0;i<len;i++){
					rst+="-";
				}
				TraceTool.holderDic[len]=rst;
			}
			return TraceTool.holderDic[len];
		}

		TraceTool.traceTree=function(tar,depth,isFirst){
			(depth===void 0)&& (depth=0);
			(isFirst===void 0)&& (isFirst=true);
			if(isFirst){
				console.log("traceTree");
			}
			if(!tar)return;
			var i=0;
			var len=0;
			if(tar.numChildren<1){
				console.log(tar);
				return;
			}
			TraceTool.group(tar);
			len=tar.numChildren;
			depth++;
			for(i=0;i<len;i++){
				TraceTool.traceTree(tar.getChildAt(i),depth,false);
			}
			TraceTool.groupEnd();
		}

		TraceTool.getClassName=function(tar){
			return tar["constructor"].name;
		}

		TraceTool.traceSpriteInfo=function(tar,showBounds,showSize,showTree){
			(showBounds===void 0)&& (showBounds=true);
			(showSize===void 0)&& (showSize=true);
			(showTree===void 0)&& (showTree=true);
			if(!((tar instanceof laya.display.Sprite ))){
				console.log("not Sprite");
				return;
			}
			if(!tar){
				console.log("null Sprite");
				return;
			}
			TraceTool.traceSplit("traceSpriteInfo");
			DebugTool.dTrace(laya.debug.tools.TraceTool.getClassName(tar)+":"+tar.name);
			if(showTree){
				TraceTool.traceTree(tar);
				}else{
				console.log(tar);
			}
			if(showSize){
				TraceTool.traceSize(tar);
			}
			if(showBounds){
				console.log("bounds:"+tar.getBounds());
			}
		}

		TraceTool.tempArr=[];
		TraceTool.Erroer=null;
		TraceTool.holderDic={};
		return TraceTool;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-12-30 下午5:12:53
	*/
	//class laya.debug.tools.ValueChanger
	var ValueChanger=(function(){
		function ValueChanger(){
			this.target=null;
			this.key=null;
			this._tValue=NaN;
			this.preValue=0;
		}

		__class(ValueChanger,'laya.debug.tools.ValueChanger');
		var __proto=ValueChanger.prototype;
		__proto.record=function(){
			this.preValue=this.value;
		}

		__proto.showValueByAdd=function(addValue){
			this.value=this.preValue+addValue;
		}

		__proto.showValueByScale=function(scale){
			this.value=this.preValue *scale;
		}

		__proto.recover=function(){
			this.value=this.preValue;
		}

		__proto.dispose=function(){
			this.target=null;
		}

		__getset(0,__proto,'value',function(){
			if(this.target){
				this._tValue=this.target[this.key];
			}
			return this._tValue;
			},function(nValue){
			this._tValue=nValue;
			if(this.target){
				this.target[this.key]=nValue;
			}
		});

		__getset(0,__proto,'dValue',function(){
			return this.value-this.preValue;
		});

		__getset(0,__proto,'scaleValue',function(){
			return this.value/this.preValue;
		});

		ValueChanger.create=function(target,key){
			var rst;
			rst=new ValueChanger();
			rst.target=target;
			rst.key=key;
			return rst;
		}

		return ValueChanger;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.debug.tools.VisibleAnalyser
	var VisibleAnalyser=(function(){
		function VisibleAnalyser(){}
		__class(VisibleAnalyser,'laya.debug.tools.VisibleAnalyser');
		VisibleAnalyser.analyseTarget=function(node){
			var isInstage=false;
			isInstage=node.displayedInStage;
			var gRec;
			gRec=NodeUtils.getGRec(node);
			var stageRec=new Rectangle();
			stageRec.setTo(0,0,Laya.stage.width,Laya.stage.height);
			var isInVisibleRec=false;
			var visibleRec;
			visibleRec=stageRec.intersection(gRec);
			if (visibleRec.width > 0 && visibleRec.height > 0){
				isInVisibleRec=true;
			}
			else{
				isInVisibleRec=false;
			};
			var gAlpha=NaN;
			gAlpha=NodeUtils.getGAlpha(node);
			var gVisible=false;
			gVisible=NodeUtils.getGVisible(node);
			var msg;
			msg="";
			msg+="isInstage:"+isInstage+"\n";
			msg+="isInVisibleRec:"+isInVisibleRec+"\n";
			msg+="gVisible:"+gVisible+"\n";
			msg+="gAlpha:"+gAlpha+"\n";
			if (isInstage && isInVisibleRec && gVisible && gAlpha > 0){
				if (Render.isWebGL){
					VisibleAnalyser.anlyseRecVisible(node);
					}else{
					SpriteRenderForVisibleAnalyse.I.analyseNode(node);
				}
				msg+="coverRate:"+VisibleAnalyser.coverRate+"\n";
				if (VisibleAnalyser._coverList.length > 0){
					Laya.timer.once(1000,null,VisibleAnalyser.showListLater);
				}
			}
			console.log(msg);
			OutPutView.I.showTxt(msg);
		}

		VisibleAnalyser.showListLater=function(){
			NodeListPanelView.I.showList(VisibleAnalyser._coverList);
		}

		VisibleAnalyser.isCoverByBrother=function(node){
			var parent=node.parent;
			if (!parent)
				return;
			var _childs;
			_childs=parent._childs;
			var index=0;
			index=_childs.indexOf(node);
			if (index < 0)
				return;
			var i=0,len=0;
			var canvas;
			var rec;
			rec=parent.getSelfBounds();
			if (rec.width <=0 || rec.height <=0)
				return;
		}

		VisibleAnalyser.anlyseRecVisible=function(node){
			VisibleAnalyser.isNodeWalked=false;
			VisibleAnalyser._analyseTarget=node;
			if (!VisibleAnalyser.mainCanvas)
				VisibleAnalyser.mainCanvas=CanvasTools.createCanvas(Laya.stage.width,Laya.stage.height);
			CanvasTools.clearCanvas(VisibleAnalyser.mainCanvas);
			VisibleAnalyser.tColor=1;
			VisibleAnalyser.resetCoverList();
			WalkTools.walkTargetEX(Laya.stage,VisibleAnalyser.recVisibleWalker,null,VisibleAnalyser.filterFun);
			if (!VisibleAnalyser.isTarRecOK){
				VisibleAnalyser.coverRate=0;
			}
			else{
				VisibleAnalyser.coverRate=CanvasTools.getDifferRate(VisibleAnalyser.preImageData,VisibleAnalyser.tarImageData);
			}
			console.log("coverRate:",VisibleAnalyser.coverRate);
		}

		VisibleAnalyser.getRecArea=function(rec){
			return rec.width *rec.height;
		}

		VisibleAnalyser.addCoverNode=function(node,coverRate){
			var data;
			data={};
			data.path=node;
			data.label=ClassTool.getNodeClassAndName(node)+":"+coverRate;
			data.coverRate=coverRate;
			VisibleAnalyser._coverList.push(data);
			console.log("coverByNode:",node,coverRate);
		}

		VisibleAnalyser.resetCoverList=function(){
			VisibleAnalyser._coverList.length=0;
		}

		VisibleAnalyser.recVisibleWalker=function(node){
			if (node==VisibleAnalyser._analyseTarget){
				VisibleAnalyser.isNodeWalked=true;
				VisibleAnalyser.tarRec.copyFrom(NodeUtils.getGRec(node));
				console.log("tarRec:",VisibleAnalyser.tarRec.toString());
				if (VisibleAnalyser.tarRec.width > 0 && VisibleAnalyser.tarRec.height > 0){
					VisibleAnalyser.isTarRecOK=true;
					VisibleAnalyser.tColor++;
					CanvasTools.fillCanvasRec(VisibleAnalyser.mainCanvas,VisibleAnalyser.tarRec,ColorTool.toHexColor(VisibleAnalyser.tColor));
					VisibleAnalyser.preImageData=CanvasTools.getImageDataFromCanvasByRec(VisibleAnalyser.mainCanvas,VisibleAnalyser.tarRec);
					VisibleAnalyser.tarImageData=CanvasTools.getImageDataFromCanvasByRec(VisibleAnalyser.mainCanvas,VisibleAnalyser.tarRec);
				}
				else{
					console.log("tarRec Not OK:",VisibleAnalyser.tarRec);
				}
			}
			else{
				if (VisibleAnalyser.isTarRecOK){
					var tRec;
					tRec=NodeUtils.getGRec(node);
					VisibleAnalyser.interRec=VisibleAnalyser.tarRec.intersection(tRec,VisibleAnalyser.interRec);
					if (VisibleAnalyser.interRec && VisibleAnalyser.interRec.width > 0 && VisibleAnalyser.interRec.height > 0){
						VisibleAnalyser.tColor++;
						CanvasTools.fillCanvasRec(VisibleAnalyser.mainCanvas,tRec,ColorTool.toHexColor(VisibleAnalyser.tColor));
						VisibleAnalyser.tImageData=CanvasTools.getImageDataFromCanvasByRec(VisibleAnalyser.mainCanvas,VisibleAnalyser.tarRec);
						var dRate=NaN;
						dRate=CanvasTools.getDifferRate(VisibleAnalyser.preImageData,VisibleAnalyser.tImageData);
						VisibleAnalyser.preImageData=VisibleAnalyser.tImageData;
						VisibleAnalyser.addCoverNode(node,dRate);
					}
				}
			}
		}

		VisibleAnalyser.filterFun=function(node){
			if (node.visible==false)
				return false;
			if (node.alpha < 0)
				return false;
			if (DebugInfoLayer.I.isDebugItem(node))return false;
			return true;
		}

		VisibleAnalyser.isNodeWalked=false;
		VisibleAnalyser._analyseTarget=null
		VisibleAnalyser.isTarRecOK=false;
		VisibleAnalyser.mainCanvas=null
		VisibleAnalyser.preImageData=null
		VisibleAnalyser.tImageData=null
		VisibleAnalyser.tarImageData=null
		VisibleAnalyser.coverRate=NaN
		VisibleAnalyser.tColor=0;
		VisibleAnalyser._coverList=[];
		__static(VisibleAnalyser,
		['tarRec',function(){return this.tarRec=new Rectangle();},'interRec',function(){return this.interRec=new Rectangle();}
		]);
		return VisibleAnalyser;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-9-24 下午6:15:01
	*/
	//class laya.debug.tools.WalkTools
	var WalkTools=(function(){
		function WalkTools(){}
		__class(WalkTools,'laya.debug.tools.WalkTools');
		WalkTools.walkTarget=function(target,fun,_this){
			fun.apply(_this,[target]);
			var i=0;
			var len=0;
			var tChild;
			len=target.numChildren;
			for(i=0;i<len;i++){
				tChild=target.getChildAt(i);
				WalkTools.walkTarget(tChild,fun,tChild);
			}
		}

		WalkTools.walkTargetEX=function(target,fun,_this,filterFun){
			if (filterFun !=null && !filterFun(target))return;
			fun.apply(_this,[target]);
			var i=0;
			var len=0;
			var tChild;
			var childs;
			childs=target._childs;
			len=childs.length;
			for(i=0;i<len;i++){
				tChild=childs[i];
				WalkTools.walkTarget(tChild,fun,tChild);
			}
		}

		WalkTools.walkChildren=function(target,fun,_this){
			if(!target||target.numChildren<1)return;
			WalkTools.walkArr(DisControlTool.getAllChild(target),fun,_this);
		}

		WalkTools.walkArr=function(arr,fun,_this){
			if(!arr)return;
			var i=0;
			var len=0;
			len=arr.length;
			for(i=0;i<len;i++){
				fun.apply(_this,[arr[i],i]);
			}
		}

		return WalkTools;
	})()


	/**
	*本类用于监控对象值变化
	*@author ww
	*@version 1.0
	*
	*@created 2015-10-23 下午4:18:27
	*/
	//class laya.debug.tools.Watcher
	var Watcher=(function(){
		function Watcher(){}
		__class(Watcher,'laya.debug.tools.Watcher');
		Watcher.watch=function(obj,name,funs){
			VarHook.hookVar(obj,name,funs);
		}

		Watcher.traceChange=function(obj,name,sign){
			(sign===void 0)&& (sign="var changed:");
			VarHook.hookVar(obj,name,[Watcher.getTraceValueFun(name),VarHook.getLocFun(sign)]);
		}

		Watcher.debugChange=function(obj,name){
			VarHook.hookVar(obj,name,[VarHook.getLocFun("debug loc"),FunHook.debugHere]);
		}

		Watcher.differChange=function(obj,name,sign,msg){
			(msg===void 0)&& (msg="");
			VarHook.hookVar(obj,name,[Watcher.getDifferFun(obj,name,sign,msg)]);
		}

		Watcher.getDifferFun=function(obj,name,sign,msg){
			(msg===void 0)&& (msg="");
			var rst;
			rst=function (){
				DifferTool.differ(sign,obj[name],msg);
			}
			return rst;
		}

		Watcher.traceValue=function(value){
			console.log("value:",value);
		}

		Watcher.getTraceValueFun=function(name){
			var rst;
			rst=function (value){
				console.log("set "+name+" :",value);
			}
			return rst;
		}

		return Watcher;
	})()


	/**
	*XML转Object类
	*@author ww
	*
	*/
	//class laya.debug.tools.XML2Object
	var XML2Object=(function(){
		function XML2Object(){};
		__class(XML2Object,'laya.debug.tools.XML2Object');
		__getset(1,XML2Object,'arrays',function(){
			if(!XML2Object._arrays){
				XML2Object._arrays=[];
			}
			return XML2Object._arrays;
			},function(a){
			XML2Object._arrays=a;
		});

		XML2Object.parse=function(node,isFirst){
			(isFirst===void 0)&& (isFirst=true);
			var obj={};
			if(isFirst)
				obj.Name=node.localName;
			var numOfChilds=node.children.length;
			var childs=[];
			var children={};
			obj.c=children;
			obj.cList=childs;
			for(var i=0;i<numOfChilds;i++){
				var childNode=node.children[i];
				var childNodeName=childNode.localName;
				var value;
				var numOfAttributes
				value=XML2Object.parse(childNode,true);
				childs.push(value);
				if(children[childNodeName]){
					if(XML2Object.getTypeof(children[childNodeName])=="array"){
						children[childNodeName].push(value);
						}else {
						children[childNodeName]=[children[childNodeName],value];
					}
					}else if(XML2Object.isArray(childNodeName)){
					children[childNodeName]=[value];
					}else {
					children[childNodeName]=value;
				}
			}
			numOfAttributes=0;
			if(node.attributes){
				numOfAttributes=node.attributes.length;
				var prop={};
				obj.p=prop;
				for(i=0;i<numOfAttributes;i++){
					prop[node.attributes[i].name.toString()]=String(node.attributes[i].nodeValue);
				}
			}
			if(numOfChilds==0){
				if(numOfAttributes==0){
					obj="";
				}else {}
			}
			return obj;
		}

		XML2Object.getArr=function(v){
			if(!v)return [];
			if(XML2Object.getTypeof(v)=="array")return v;
			return [v];
		}

		XML2Object.isArray=function(nodeName){
			var numOfArrays=XML2Object._arrays ? XML2Object._arrays.length :0;
			for(var i=0;i<numOfArrays;i++){
				if(nodeName==XML2Object._arrays[i]){
					return true;
				}
			}
			return false;
		}

		XML2Object.getTypeof=function(o){
			if(typeof(o)=="object"){
				if(o.length==null){
					return "object";
					}else if(typeof(o.length)=="number"){
					return "array";
					}else {
					return "object";
				}
				}else {
				return typeof(o);
			}
		}

		XML2Object._arrays=null
		return XML2Object;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.debug.view.nodeInfo.menus.NodeMenu
	var NodeMenu=(function(){
		function NodeMenu(){
			this._tar=null;
			this._menu=null;
			this._shareBtns=[
			"信息面板",
			"边框",
			"进入节点",
			"树定位",
			"Enable链",
			"Size链",
			"节点工具",
			"可见分析",
			"输出到控制台"];
			this._menuItems=["隐藏节点"];
			this._menuHide=null;
			this._menuItemsHide=["显示节点"];
			this._menu1=null;
			this._menuItems1=["输出到控制台"];
		}

		__class(NodeMenu,'laya.debug.view.nodeInfo.menus.NodeMenu');
		var __proto=NodeMenu.prototype;
		__proto.showNodeMenu=function(node){
			if (!node._style){
				DebugTool.log("该节点已不存在，请刷新列表");
				return;
			}
			this._tar=node;
			if (!this._menu){
				this._menuItems=this._menuItems.concat(this._shareBtns);
				this._menu=ContextMenu.createMenuByArray(this._menuItems);
				this._menu.on("select",this,this.onEmunSelect);
				this._menuItemsHide=this._menuItemsHide.concat(this._shareBtns);
				this._menuHide=ContextMenu.createMenuByArray(this._menuItemsHide);
				this._menuHide.on("select",this,this.onEmunSelect);
			}
			if (node.visible){
				this._menu.show();
			}
			else{
				this._menuHide.show();
			}
		}

		__proto.nodeDoubleClick=function(node){
			NodeToolView.I.showByNode(node);
		}

		__proto.setNodeListDoubleClickAction=function(list){
			if (Browser.onMobile)return;
			list.on("doubleclick",this,this.onListDoubleClick,[list]);
		}

		__proto.onListDoubleClick=function(list){
			if (list.selectedItem){
				var tarNode;
				tarNode=list.selectedItem.path;
				laya.debug.view.nodeInfo.menus.NodeMenu.I.nodeDoubleClick(tarNode);
			}
		}

		__proto.setNodeListAction=function(list){
			list.on(DebugTool.getMenuShowEvent(),this,this.onListRightClick,[list]);
		}

		//setNodeListDoubleClickAction(list);
		__proto.onListRightClick=function(list){
			if (list.selectedItem){
				var tarNode;
				tarNode=list.selectedItem.path;
				laya.debug.view.nodeInfo.menus.NodeMenu.I.objRightClick(tarNode);
			}
		}

		__proto.objRightClick=function(obj){
			if ((obj instanceof laya.display.Sprite )){
				laya.debug.view.nodeInfo.menus.NodeMenu.I.showNodeMenu(obj);
			}
			else if ((typeof obj=='object')){
				laya.debug.view.nodeInfo.menus.NodeMenu.I.showObjectMenu(obj);
			}
		}

		__proto.showObjectMenu=function(obj){
			this._tar=obj;
			if (!this._menu1){
				this._menu1=ContextMenu.createMenuByArray(this._menuItems1);
				this._menu1.on("select",this,this.onEmunSelect);
			}
			this._menu1.show();
		}

		__proto.onEmunSelect=function(e){
			var data=(e.target).data;
			if ((typeof data=='string')){
				var key;
				key=data;
				switch (key){
					case "信息面板":
						ObjectInfoView.showObject(this._tar);
						break ;
					case "边框":
						DebugTool.showDisBound(this._tar);
						break ;
					case "输出到控制台":
						console.log(this._tar);
						break ;
					case "树节点":
						ToolPanel.I.showNodeTree(this._tar);
						break ;
					case "进入节点":
						ToolPanel.I.showNodeTree(this._tar);
						break ;
					case "树定位":
						ToolPanel.I.showSelectInStage(this._tar);
						break ;
					case "Enable链":
						OutPutView.I.dTrace(DebugTool.traceDisMouseEnable(this._tar));
						SelectInfosView.I.setSelectList(DebugTool.selectedNodes);
						break ;
					case "Size链":
						OutPutView.I.dTrace(DebugTool.traceDisSizeChain(this._tar));
						SelectInfosView.I.setSelectList(DebugTool.selectedNodes);
						break ;
					case "节点工具":
						NodeToolView.I.showByNode(this._tar);
						break ;
					case "显示节点":
						this._tar.visible=true;
						break ;
					case "隐藏节点":
						this._tar.visible=false;
						break ;
					case "可见分析":
						if (this._tar){
							VisibleAnalyser.analyseTarget(this._tar);
						}
						break ;
					}
			}
		}

		__getset(1,NodeMenu,'I',function(){
			if (!NodeMenu._I)
				NodeMenu._I=new NodeMenu();
			return NodeMenu._I;
		});

		NodeMenu._I=null
		return NodeMenu;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.debug.view.nodeInfo.NodeConsts
	var NodeConsts=(function(){
		function NodeConsts(){}
		__class(NodeConsts,'laya.debug.view.nodeInfo.NodeConsts');
		NodeConsts.defaultFitlerStr="x,y,width,height,scaleX,scaleY,alpha,renderCost";
		NodeConsts.RenderCostMaxTime=3000;
		return NodeConsts;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.debug.view.nodeInfo.NodeUtils
	var NodeUtils=(function(){
		function NodeUtils(){}
		__class(NodeUtils,'laya.debug.view.nodeInfo.NodeUtils');
		NodeUtils.getFilterdTree=function(sprite,keys){
			if (!keys)
				keys=NodeUtils.defaultKeys;
			var me;
			me={};
			var key;
			var i=0,len=0;
			len=keys.length;
			for (i=0;i < len;i++){
				key=keys[i];
				me[key]=sprite[key];
			};
			var cList;
			var tChild;
			cList=sprite._childs;
			len=cList.length;
			var mClist;
			mClist=[];
			for (i=0;i < len;i++){
				tChild=cList[i];
				mClist.push(NodeUtils.getFilterdTree(tChild,keys));
			}
			me.childs=mClist;
			return me;
		}

		NodeUtils.getPropertyDesO=function(tValue,keys){
			if (!keys)
				keys=NodeUtils.defaultKeys;
			var rst={};
			if ((typeof tValue=='object')){
				rst.label=""+ClassTool.getNodeClassAndName(tValue);
			}
			else{
				rst.label=""+tValue;
			}
			rst.type="";
			rst.path=tValue;
			rst.childs=[];
			rst.isDirectory=false;
			var key;
			var i=0,len=0;
			var tChild;
			if ((tValue instanceof laya.display.Node )){
				rst.des=ClassTool.getNodeClassAndName(tValue);
				rst.isDirectory=true;
				len=keys.length;
				for (i=0;i < len;i++){
					key=keys[i];
					tChild=NodeUtils.getPropertyDesO(tValue[key],keys);
					if (tValue.hasOwnProperty(key)){
						tChild.label=""+key+":"+tChild.des;
					}
					else{
						tChild.label=""+key+":"+ObjectInfoView.getNodeValue(tValue,key);
					}
					rst.childs.push(tChild);
				}
				key="_childs";
				tChild=NodeUtils.getPropertyDesO(tValue[key],keys);
				tChild.label=""+key+":"+tChild.des;
				tChild.isChilds=true;
				rst.childs.push(tChild);
			}
			else if ((tValue instanceof Array)){
				rst.des="Array["+(tValue).length+"]";
				rst.isDirectory=true;
				var tList;
				tList=tValue;
				len=tList.length;
				for (i=0;i < len;i++){
					tChild=NodeUtils.getPropertyDesO(tList[i],keys);
					tChild.label=""+i+":"+tChild.des;
					rst.childs.push(tChild);
				}
			}
			else if ((typeof tValue=='object')){
				rst.des=ClassTool.getNodeClassAndName(tValue);
				rst.isDirectory=true;
				for (key in tValue){
					tChild=NodeUtils.getPropertyDesO(tValue[key],keys);
					tChild.label=""+key+":"+tChild.des;
					rst.childs.push(tChild);
				}
			}
			else{
				rst.des=""+tValue;
			}
			rst.hasChild=rst.childs.length > 0;
			return rst;
		}

		NodeUtils.adptShowKeys=function(keys){
			var i=0,len=0;
			len=keys.length;
			for (i=len-1;i >=0;i--){
				keys[i]=StringTool.trimSide(keys[i]);
				if (keys[i].length < 1){
					keys.splice(i,1);
				}
			}
			return keys;
		}

		NodeUtils.getNodeTreeData=function(sprite,keys){
			NodeUtils.adptShowKeys(keys);
			var treeO;
			treeO=NodeUtils.getPropertyDesO(sprite,keys);
			var treeArr;
			treeArr=[];
			NodeUtils.getTreeArr(treeO,treeArr);
			return treeArr;
		}

		NodeUtils.getTreeArr=function(treeO,arr,add){
			(add===void 0)&& (add=true);
			if (add)
				arr.push(treeO);
			var tArr=treeO.childs;
			var i=0,len=tArr.length;
			for (i=0;i < len;i++){
				if (!add){
					tArr[i].nodeParent=null;
				}
				else{
					tArr[i].nodeParent=treeO;
				}
				if (tArr[i].isDirectory){
					NodeUtils.getTreeArr(tArr[i],arr);
				}
				else{
					arr.push(tArr[i]);
				}
			}
		}

		NodeUtils.traceStage=function(){
			console.log(NodeUtils.getFilterdTree(Laya.stage,null));
			console.log("treeArr:",NodeUtils.getNodeTreeData(Laya.stage,null));
		}

		NodeUtils.getNodeCount=function(node,visibleRequire){
			(visibleRequire===void 0)&& (visibleRequire=false);
			if (visibleRequire){
				if (!node.visible)return 0;
			};
			var rst=0;
			rst=1;
			var i=0,len=0;
			var cList;
			cList=node._childs;
			len=cList.length;
			for (i=0;i < len;i++){
				rst+=NodeUtils.getNodeCount(cList[i],visibleRequire);
			}
			return rst;
		}

		NodeUtils.getGVisible=function(node){
			while (node){
				if (!node.visible)return false;
				node=node.parent;
			}
			return true;
		}

		NodeUtils.getGAlpha=function(node){
			var rst=NaN;
			rst=1;
			while (node){
				rst *=node.alpha;
				node=node.parent;
			}
			return rst;
		}

		NodeUtils.getGPos=function(node){
			var point;
			point=new Point();
			node.localToGlobal(point);
			return point;
		}

		NodeUtils.getGRec=function(node){
			var pointList;
			pointList=node._getBoundPointsM(true);
			if (!pointList || pointList.length < 1)
				return Rectangle.TEMP.setTo(0,0,0,0);
			pointList=GrahamScan.pListToPointList(pointList,true);
			WalkTools.walkArr(pointList,node.localToGlobal,node);
			pointList=GrahamScan.pointListToPlist(pointList);
			var _disBoundRec;
			_disBoundRec=Rectangle._getWrapRec(pointList,_disBoundRec);
			return _disBoundRec;
		}

		NodeUtils.getGGraphicRec=function(node){
			var pointList;
			pointList=node.getGraphicBounds()._getBoundPoints();
			if (!pointList || pointList.length < 1)
				return Rectangle.TEMP.setTo(0,0,0,0);
			pointList=GrahamScan.pListToPointList(pointList,true);
			WalkTools.walkArr(pointList,node.localToGlobal,node);
			pointList=GrahamScan.pointListToPlist(pointList);
			var _disBoundRec;
			_disBoundRec=Rectangle._getWrapRec(pointList,_disBoundRec);
			return _disBoundRec;
		}

		NodeUtils.getNodeCmdCount=function(node){
			var rst=0;
			if (node.graphics){
				if (node.graphics.cmds){
					rst=node.graphics.cmds.length;
				}
				else{
					if (node.graphics._one){
						rst=1;
					}
					else{
						rst=0;
					}
				}
			}
			else{
				rst=0;
			}
			return rst;
		}

		NodeUtils.getNodeCmdTotalCount=function(node){
			var rst=0;
			var i=0,len=0;
			var cList;
			cList=node._childs;
			len=cList.length;
			rst=NodeUtils.getNodeCmdCount(node);
			for (i=0;i < len;i++){
				rst+=NodeUtils.getNodeCmdTotalCount(cList[i]);
			}
			return rst;
		}

		NodeUtils.getRenderNodeCount=function(node){
			if (node.cacheAs !="none")return 1;
			var rst=0;
			var i=0,len=0;
			var cList;
			cList=node._childs;
			len=cList.length;
			rst=1;
			for (i=0;i < len;i++){
				rst+=NodeUtils.getRenderNodeCount(cList[i]);
			}
			return rst;
		}

		NodeUtils.getReFreshRenderNodeCount=function(node){
			var rst=0;
			var i=0,len=0;
			var cList;
			cList=node._childs;
			len=cList.length;
			rst=1;
			for (i=0;i < len;i++){
				rst+=NodeUtils.getRenderNodeCount(cList[i]);
			}
			return rst;
		}

		NodeUtils.showCachedSpriteRecs=function(){
			NodeUtils.g=DebugInfoLayer.I.graphicLayer.graphics;
			NodeUtils.g.clear();
			WalkTools.walkTarget(Laya.stage,NodeUtils.drawCachedBounds,null);
		}

		NodeUtils.drawCachedBounds=function(sprite){
			if (sprite.cacheAs=="none")return;
			if (DebugInfoLayer.I.isDebugItem(sprite))return;
			var rec;
			rec=NodeUtils.getGRec(sprite);
			NodeUtils.g.drawRect(rec.x,rec.y,rec.width,rec.height,null,"#0000ff",2);
		}

		NodeUtils.g=null
		__static(NodeUtils,
		['defaultKeys',function(){return this.defaultKeys=["x","y","width","height"];}
		]);
		return NodeUtils;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.debug.view.StyleConsts
	var StyleConsts=(function(){
		function StyleConsts(){}
		__class(StyleConsts,'laya.debug.view.StyleConsts');
		StyleConsts.setViewScale=function(view){
			view.scaleX=view.scaleY=StyleConsts.PanelScale;
		}

		__static(StyleConsts,
		['PanelScale',function(){return this.PanelScale=Browser.onPC?1:Browser.pixelRatio;}
		]);
		return StyleConsts;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-8-30 上午9:49:01
	*/
	//class as3analyser.As3ParserTool
	var As3ParserTool=(function(){
		function As3ParserTool(){}
		__class(As3ParserTool,'as3analyser.As3ParserTool');
		As3ParserTool.parserAsFile=function(path){
			var parser;
			parser=new AsFileParser();
			parser.setFile(path);
			console.log("parser:",parser);
		}

		return As3ParserTool;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-8-31 下午7:38:09
	*/
	//class as3analyser.parser.AsFileParser
	var AsFileParser=(function(){
		function AsFileParser(){
			this.oTxt=null;
			this.adptTxt=null;
			this.lines=null;
			this.rawLines=null;
			this.path=null;
			this.functionList=[];
			this.packageName=null;
			this.className=null;
			this.classNameFull=null;
			this.importList=null;
			this.importListRaw=null;
			this.memberDic={};
			this.allMemberDic={};
			this.parentClass=null;
			this.interfaces=[];
			this.type=null;
			this.pType=null;
			this.dependClassDic={};
			this.directReferDic={};
			this.varDic={};
			this.functionDic={};
			this.notUsedImportList=[];
			this.codeT=null;
			this.code=null;
			this.isWorkFile=true;
			ASLex.init();
		}

		__class(AsFileParser,'as3analyser.parser.AsFileParser');
		var __proto=AsFileParser.prototype;
		__proto.reset=function(){}
		__proto.setFile=function(path){
			this.path=path;
			this.oTxt=ToolFuns.readTxtFile(path);
			if(!this.oTxt)return;
			console.log("work:"+path);
			this.setClassStr(this.oTxt);
		}

		__proto.setClassStr=function(oTxt){
			this.rawLines=LineItem.getLineItems(oTxt,true,true);
			this.lines=StringTool1.removeCommentLineS(this.rawLines);
			this.parse();
			if(this.type=="class")
				this.build();
		}

		__proto.parse=function(){
			var i=0;
			var len=0;
			var tline;
			var tmpStr;
			len=this.lines.length;
			i=this.findFirstMatchLine("package");
			tline=this.lines[i];
			this.packageName=StringTool1.trimExt(tline.lineStr,["package",";","{"]);
			i++;
			i=this.findFirstMatchLine("class ",i);
			this.type="class";
			if(i<0){
				i=this.findFirstMatchLine("interface ",i);
				this.type="interface";
			}
			if(i<0){
				i=this.findFirstMatchLine("function ",i);
				this.type="function";
			}
			if(i<0){
				i=this.findFirstMatchLine("var ",i);
				this.type="var";
			}
			if(i<0){
				i=this.findFirstMatchLine("namespace",i);
				this.type="namespace";
			}
			tline=this.lines[i];
			var tLineWords;
			tLineWords=StringTool1.getSplitLine(tline.lineStr);
			this.parseClassInfo(tLineWords,this.type);
			this.traceMyInfo();
			if(this.type=="class")
				this.parseClassBody(i);
			this.importList=[];
			this.importListRaw=[];
			len=this.lines.length;
			for(i=0;i<len;i++){
				tmpStr=this.lines[i].lineStr;
				tmpStr=StringTool1.trimButEmpty(tmpStr);
				tLineWords=StringTool1.getWords(tmpStr);
				if(tLineWords[0]=="import"){
					tmpStr=StringTool1.trimExt(tmpStr,["import",";"]);
					this.importList.push(tmpStr);
					this.importListRaw.push(tline);
				}
			}
		}

		__proto.parseClassBody=function(i){
			var cCount=0;
			var len=0;
			var tLine;
			var tCIndex=0;
			var lineLen=0;
			var lineStr;
			var tPair;
			var tPos;
			len=this.lines.length;
			i=this.findFirstMatchLine("{",i);
			i++;
			tPos=new PosItem(i,0);
			var sPos;
			var preLine=0;
			preLine=0;
			tPos.line=this.findFirstMatchLine(" function ",i);
			tPair=StringTool1.findPair("{","}",tPos,this.lines);
			this.codeT="";
			var tFun;
			while(tPair&&tPair.length>1){
				tFun=this.parseFunction(tPair);
				tPos=tPair[tPair.length-1];
				sPos=tPair[0];
				tPos.index++;
				if(tFun.hasAsy||1){
					this.codeT+="\n"+StringTool1.getSelectLinesStr(this.rawLines,preLine-1,tFun.posStart.line-2)+"\n"+this.getFunctionHold(this.functionList.length-1)+"\n";
					preLine=tFun.posEnd.line+1;
				}
				tPos.line=this.findFirstMatchLine(" function ",tPos.line);
				if(tPos.line<0)break ;
				tPair=StringTool1.findPair("{","}",tPos,this.lines);
			}
			if(preLine<this.rawLines.length){
				this.codeT+="\n"+StringTool1.getSelectLinesStr(this.rawLines,preLine-1,this.rawLines.length);
			}
			this.parseClassMembers();
		}

		__proto.parseClassMembers=function(){
			var codeLines;
			codeLines=LineItem.getLineItems(this.codeT,true,true);
			var i=0;
			var len=0;
			var tLine;
			var tStr;
			len=codeLines.length;
			for(i=0;i<len;i++){
				tLine=codeLines[i];
				tStr=tLine.lineStr;
				this.addMember(tStr);
			}
		}

		__proto.addMember=function(tStr){
			var tMember;
			if(SingleMemberParser.getMemberType(tStr)){
				tMember=SingleMemberParser.parseMember(tStr);
				this.addMemberOne(tMember);
			}
		}

		__proto.addMemberOne=function(tMember){
			this.allMemberDic[tMember.name]=tMember;
			if(!tMember.modifiesO["static"]){
				this.memberDic[tMember.name]=tMember;
			}
			console.log("add mem:"+tMember.name+" type:"+tMember.type);
		}

		__proto.getFunctionHold=function(funID){
			return "{functionHolder_"+funID+"}";
		}

		__proto.build=function(){}
		// }
		__proto.parseFunction=function(pari){
			var functionLinePos;
			functionLinePos=this.traceBack(pari[0]," function");
			if(functionLinePos){
				var tFunctionDefineLine;
				var lineStr;
				tFunctionDefineLine=this.lines[functionLinePos.line];
				this.addMember(tFunctionDefineLine.lineStr);
				var tFun;
				tFun=new FunctionItem();
				tFun.setData(tFunctionDefineLine,StringTool1.getLines(functionLinePos,pari[pari.length-1],this.lines,this.rawLines));
				this.functionList.push(tFun);
				return tFun;
			}
			return null;
		}

		__proto.traceBack=function(pos,str){
			var tLineItem;
			var len=0;
			len=pos.line;
			var i=0;
			var lineStr;
			var tIndex=0;
			for(i=len;i>=0;i--){
				tLineItem=this.lines[i];
				lineStr=tLineItem.lineStr;
				tIndex=lineStr.indexOf(str);
				if(tIndex>=0){
					var rst;
					rst=new PosItem();
					rst.line=i;
					rst.index=tIndex;
					rst.str=str;
					rst.oLine=tLineItem.lineIndex;
					return rst;
				}
			}
			return null;
		}

		__proto.setFullName=function(fullName){
			this.classNameFull=fullName;
			var i=0;
			i=fullName.lastIndexOf(".");
			if(i>=0){
				this.className=fullName.substr(i+1);
				this.packageName=fullName.substr(0,i-1);
				}else{
				this.className=fullName;
			}
		}

		__proto.traceMyInfo=function(){
			console.log("package:"+this.packageName);
			console.log("className:"+this.className);
			console.log("classNameFull:"+this.classNameFull);
			console.log("parentClass:"+this.parentClass);
			console.log("interfaces:"+this.interfaces.join("|"));
		}

		__proto.parseClassInfo=function(words,type){
			(type===void 0)&& (type="class");
			this.type=type;
			var i=0;
			var word;
			i=words.indexOf(type);
			if(i>0){
				this.pType=words[i-1];
				}else{
				this.pType="internal";
			}
			i++;
			this.className=StringTool1.trim(words[i]);
			if(type=="var"){
				this.className=this.className.split(":")[0];
			}
			if(type=="function"){
				this.className=this.className.split("(")[0];
			};
			var len=0;
			len=words.length;
			i++;
			while(i<len){
				word=words[i];
				switch(word){
					case "extends":
						i++;
						this.parentClass=StringTool1.trim(words[i]);
						break ;
					case "implements":
						i++;
						words[i]=StringTool1.trim(words[i]);
						this.interfaces=words[i].split(",");
						break ;
					}
				i++;
			}
			if(this.packageName!=""){
				this.classNameFull=this.packageName+"."+this.className;
				}else{
				this.classNameFull=this.className;
			}
		}

		__proto.findFirstMatchLine=function(str,startLine){
			(startLine===void 0)&& (startLine=0);
			var i=0;
			var len=0;
			var tLine;
			len=this.lines.length;
			if(startLine<0)startLine=0;
			for(i=startLine;i<len;i++){
				tLine=this.lines[i].lineStr;
				if(tLine.indexOf(str)>=0){
					return i;
				}
			}
			return-1;
		}

		AsFileParser.workAFile=function(filePath,outPutPath){
			if(!outPutPath)outPutPath=filePath;
			var asfile;
			asfile=new AsFileParser();
			asfile.setFile(filePath);
			if(asfile.isWorkFile){
				var data;
				data=asfile.code;
				if(data.indexOf("/*[COMPILER OPTIONS:DISABLE2SYNC]*/")<0){
					Tracer.myTrace("insertSign:"+filePath);
					data=StringTool1.insertAfter(data,"\n"+"/*[COMPILER OPTIONS:DISABLE2SYNC]*/","{");
				}
				data=StringTool1.structfy(data);
				ToolFuns.saveTxtFile(outPutPath,data);
				Tracer.myTrace("done:"+filePath);
			}
		}

		AsFileParser.workFileList=function(fileList){
			Tracer.myTrace("workAsFile:"+fileList.length);
			var i=0;
			var len=0;
			len=fileList.length;
			for(i=0;i<len;i++){
				AsFileParser.workAFile(fileList[i]);
			}
			Tracer.myTrace("workFileList done");
		}

		AsFileParser.insertSign="/*[COMPILER OPTIONS:DISABLE2SYNC]*/";
		return AsFileParser;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-9-1 上午9:37:34
	*/
	//class as3analyser.parser.Defines
	var Defines=(function(){
		function Defines(){}
		__class(Defines,'as3analyser.parser.Defines');
		Defines.getParam=function(line){
			Defines.commonParam[1]=line;
			return Defines.commonParam;
		}

		Defines.isBWrap=function(str){
			return str=="{"||str=="}";
		}

		Defines.isNoWrapLine=function(line){
			var tStr;
			tStr=line.lineStr;
			if(tStr.indexOf("case ")>=0)return true;
			if(tStr.indexOf("break;")>=0)return true;
			if(tStr.indexOf("default")>=0)return true;
			return false;
		}

		Defines.Var="var";
		Defines.Expression="Expression";
		Defines.FunctionDefine="FunctionDefine";
		Defines.CallFun="CallFun";
		Defines.Block="Block";
		Defines.While="While";
		Defines.For="For";
		__static(Defines,
		['specialCallList',function(){return this.specialCallList=
			[
			"Sync.wait",
			"Sync.sleep",
			"Sync.load",
			"Sync::work.connectTo",
			"Far::netObj"];},'FunParams',function(){return this.FunParams={
				"Sync.wait":["null","null","_$this"],
				"Sync.sleep":["1000"],
				"Sync.load":["null","null"],
				"Sync::work.connectTo":["null"],
				"Far::netObj":[],
				"Sync::work.getFarObject":[]
		};},'commonParam',function(){return this.commonParam=["__$",0];}

		]);
		return Defines;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-9-1 下午5:18:21
	*/
	//class as3analyser.parser.struct.CodePiece
	var CodePiece=(function(){
		function CodePiece(){
			this.lines=null;
			this.posStart=null;
			this.posEnd=null;
			this.type=null;
			this.code=null;
			this.oCode=null;
			this.hasAsy=false;
			this.posStart=new PosItem();
			this.posEnd=new PosItem();
		}

		__class(CodePiece,'as3analyser.parser.struct.CodePiece');
		var __proto=CodePiece.prototype;
		Laya.imps(__proto,{"as3analyser.parser.struct.ICodePiece":true})
		__proto.dealContinue=function(){
			this.code=StringTool1.getReplace(this.code,"continue","{__line=0;continue}");
		}

		__proto.isAsy=function(){
			return this.hasAsy;
		}

		__proto.setLines=function(lines){
			this.lines=lines;
			var i=0;
			var len=0;
			var tPiece;
			len=lines.length;
			for(i=0;i<len;i++){
				tPiece=lines[i];
				if(tPiece.isAsy()){
					this.hasAsy=true;
					break ;
				}
			}
			this.oCode=StringTool1.getPiecesCode(lines);
			console.log("oCode:",this.oCode);
			this.posStart.line=(lines [0]).getStartLine();
			this.posEnd.line=(lines [lines.length-1]).getEndLine();
		}

		__proto.getCode=function(){
			if(!this.hasAsy)return this.oCode;
			return this.code;
		}

		__proto.getEndLine=function(){
			return this.posEnd.line;
		}

		__proto.getStartLine=function(){
			return this.posStart.line;
		}

		return CodePiece;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-9-23 下午5:10:24
	*/
	//class as3analyser.parser.lex.ASLex
	var ASLex=(function(){
		function ASLex(){}
		__class(ASLex,'as3analyser.parser.lex.ASLex');
		ASLex.isWordBegin=function(s){
			return ASLex.alphaSigns[s]||ASLex.extSigns[s];
		}

		ASLex.isWordBody=function(s){
			return ASLex.isWordBegin(s)||ASLex.numSigns[s];
		}

		ASLex.init=function(){
			ASLex.addSign("a","z",ASLex.alphaSigns);
			ASLex.addSign("A","Z",ASLex.alphaSigns);
			ASLex.addSign("0","9",ASLex.numSigns);
		}

		ASLex.addSign=function(ss,e,tar){
			var i=0;
			var len=0;
			var s=0;
			s=ss.charCodeAt(0);
			len=e.charCodeAt(0);
			for(i=s;i<=len;i++){
				tar[String.fromCharCode(i)]=true;
				console.log("add :"+String.fromCharCode(i));
			}
		}

		ASLex.toWords=function(str){
			var i=0;
			var tWord;
			var len=0;
			len=str.length;
			var rst=[];
			var tch;
			for(i=0;i<len;i++){
				tch=str.charAt(i);
				if(!tWord){
					createNewWord();
					}else{
					if(tWord.type=="Word"&&ASLex.isWordBody(tch)){
						tWord.str+=tch;
						}else{
						savePre();
						createNewWord();
					}
				}
			}
			savePre();
			return rst;
			function savePre (){
				if(tWord){
					tWord.endPos=i-1;
					rst.push(tWord);
				}
			}
			function createNewWord (){
				tWord=new ASWord();
				tWord.str=tch;
				tWord.sPos=i;
				if(ASLex.isWordBegin(tch)){
					tWord.type="Word";
					}else{
					tWord.type="Other";
				}
			}
		}

		ASLex.numSigns={};
		__static(ASLex,
		['alphaSigns',function(){return this.alphaSigns={
		};},'extSigns',function(){return this.extSigns={"_":true,"$":true};}

		]);
		return ASLex;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-9-23 下午5:12:46
	*/
	//class as3analyser.parser.lex.ASWord
	var ASWord=(function(){
		function ASWord(){
			this.str="";
			this.sPos=0;
			this.endPos=0;
			this.type="Other";
		}

		__class(ASWord,'as3analyser.parser.lex.ASWord');
		ASWord.wordListToStr=function(wordList){
			var strs=[];
			var i=0;
			var len=0;
			len=wordList.length;
			for(i=0;i<len;i++){
				strs.push(wordList[i].str);
			}
			return strs.join("");
		}

		ASWord.Word="Word";
		ASWord.Other="Other";
		return ASWord;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-8-31 下午7:41:04
	*/
	//class as3analyser.parser.LineItem
	var LineItem=(function(){
		function LineItem(){
			this.lineIndex=0;
			this.lineStr=null;
			this.lineType=null;
			this.paramed=false;
			this.data=null;
			this.hasAsy=false;
		}

		__class(LineItem,'as3analyser.parser.LineItem');
		var __proto=LineItem.prototype;
		Laya.imps(__proto,{"as3analyser.parser.struct.ICodePiece":true})
		__proto.isAsy=function(){
			return this.data||this.hasAsy;
		}

		__proto.getCode=function(){
			if(this.data){
				return "return "+this.lineStr;
				}else{
				return this.lineStr;
			}
		}

		__proto.getEndLine=function(){
			return this.lineIndex;
		}

		__proto.getStartLine=function(){
			return this.lineIndex;
		}

		LineItem.create=function(str,lineIndex){
			var rst;
			rst=new LineItem();
			rst.lineStr=str;
			rst.lineIndex=lineIndex;
			return rst;
		}

		LineItem.getLineItems=function(str,ifTrim,reStruct){
			(ifTrim===void 0)&& (ifTrim=false);
			(reStruct===void 0)&& (reStruct=false);
			var lines;
			var i=0;
			var len=0;
			var tLine;
			var rst;
			var daptStr;
			var nLine;
			rst=[];
			lines=str.split("\n");
			len=lines.length;
			for(i=0;i<len;i++){
				tLine=new LineItem();
				tLine.lineIndex=1+i;
				tLine.lineStr=lines[i];
				rst.push(tLine);
				if(ifTrim){
					tLine.lineStr=StringTool1.trimLeft(tLine.lineStr);
				}
				if(reStruct&&0){
					daptStr=StringTool1.trimSide(tLine.lineStr);
					if(daptStr.length<2)continue ;
					var tSign;
					while(daptStr.length>0&&Defines.isBWrap(daptStr.charAt(daptStr.length-1))){
						nLine=new LineItem();
						nLine.lineStr=daptStr.charAt(daptStr.length-1);
						nLine.lineIndex=tLine.lineIndex+1;
						rst.push(nLine);
						daptStr=daptStr.substr(0,daptStr.length-1);
					}
				}
			}
			return rst;
		}

		return LineItem;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-8-31 下午8:23:44
	*/
	//class as3analyser.parser.PosItem
	var PosItem=(function(){
		function PosItem(line,index){
			this.line=0;
			this.index=0;
			this.str=null;
			this.oLine=0;
			(line===void 0)&& (line=0);
			(index===void 0)&& (index=0);
			this.line=line;
			this.index=index;
		}

		__class(PosItem,'as3analyser.parser.PosItem');
		PosItem.pre=function(a,b){
			if(a.line<b.line)return true;
			if(a.line>b.line)return false;
			return a.index<b.index;
		}

		return PosItem;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-9-23 下午4:01:43
	*/
	//class as3analyser.parser.SingleMemberParser
	var SingleMemberParser=(function(){
		function SingleMemberParser(){
			this.type=null;
			this.name=null;
			this.varType=null;
			this.modifiesO={};
			this.params=null;
			this.exType=null;
			this.defaultV=null;
		}

		__class(SingleMemberParser,'as3analyser.parser.SingleMemberParser');
		var __proto=SingleMemberParser.prototype;
		__proto.setLine=function(str){
			this.type=SingleMemberParser.getMemberType(str);
			str=this.getModifies(str);
			var arr;
			switch(this.type){
				case "function":
					this.name=StringTool1.getBetween(str,this.type,"(",false);
					if(str.indexOf(" set ")>=0){
						this.exType="set";
					}
					if(str.indexOf(" get ")>=0){
						this.exType="get";
					};
					var i=0;
					i=str.lastIndexOf(")");
					if(i>=0){
						var tail;
						tail=str.substr(i);
						if(this.exType=="set"){
							tail=StringTool1.getBetween(str,"(",")",false);
						}
						i=tail.indexOf(":");
						if(i>=0){
							arr=tail.split(":");
							if(arr[1]){
								this.varType=StringTool1.trim(arr[1],SingleMemberParser.trimArr);
							}
						}
					}
					break ;
				default :
					if(str.indexOf(":")>=0){
						arr=str.split(":");
						str=arr[0];
						this.varType=arr[1];
						this.varType=StringTool1.trim(this.varType,SingleMemberParser.trimArr);
					}
					str=str.replace(this.type,"");
					str=StringTool1.trim(str,SingleMemberParser.trimArr);
					this.name=str;
				}
			if(this.varType&&this.varType.indexOf("=")>=0){
				arr=this.varType.split("=");
				this.varType=StringTool1.trim(arr[0],SingleMemberParser.trimArr);
				this.defaultV=StringTool1.trim(arr[0],SingleMemberParser.trimArr);
			}
			this.name=StringTool1.trim(this.name);
		}

		__proto.getModifies=function(str){
			var i=0;
			var len=0;
			len=SingleMemberParser.modifies.length;
			var tKey;
			for(i=0;i<len;i++){
				tKey=SingleMemberParser.modifies[i];
				if(str.indexOf(tKey+" ")>=0){
					this.modifiesO[tKey]=true;
					str=str.replace(tKey,"");
				}
			}
			return str;
		}

		SingleMemberParser.getMemberType=function(str){
			var i=0;
			var len=0;
			len=SingleMemberParser.keyWords.length;
			var tKey;
			for(i=0;i<len;i++){
				tKey=SingleMemberParser.keyWords[i];
				if(str.indexOf(tKey+" ")>=0)return tKey;
			}
			return null;
		}

		SingleMemberParser.parseMember=function(lineStr){
			var rst;
			rst=new SingleMemberParser();
			rst.setLine(lineStr);
			return rst;
		}

		SingleMemberParser.parseMembers=function(lineStr){
			if(lineStr.indexOf(",")>=0)return [SingleMemberParser.parseMember(lineStr)];
			var type;
			type=SingleMemberParser.getMemberType(lineStr);
			var mStr;
			var arr;
			var dStr;
			arr=lineStr.split(type);
			mStr=arr[0];
			dStr=arr[1];
			var i=0;
			var len=0;
			var strs;
			strs=dStr.split(",");
			len=strs.length;
			var rst=[];
			for(i=0;i<len;i++){
				rst.push(SingleMemberParser.parseMember(mStr+" "+type+" "+strs[i]));
			}
			return rst;
		}

		__static(SingleMemberParser,
		['trimArr',function(){return this.trimArr=[";"," ","\r","\n","\t",String.fromCharCode(65279)];},'modifies',function(){return this.modifies=["public","private","protected","internal","static","override"];},'keyWords',function(){return this.keyWords=["var","const","function"];}
		]);
		return SingleMemberParser;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-9-2 下午7:09:11
	*/
	//class as3analyser.parser.VarParser
	var VarParser=(function(){
		function VarParser(){
			this.name=null;
			this.type=null;
			this.init=null;
			this.oStr=null;
			this.noType=null;
		}

		__class(VarParser,'as3analyser.parser.VarParser');
		var __proto=VarParser.prototype;
		__proto.getDefineStr=function(){
			var rst;
			rst="var "+this.name;
			if(this.type){
				rst+=":"+this.type;
			}
			return StringTool1.ifNoAddToTail(rst,";");
		}

		__proto.getInitStr=function(){
			var rst;
			return StringTool1.ifNoAddToTail(this.name+"="+this.init,";");
		}

		__proto.getNoType=function(oStr){
			var notype;
			notype=oStr;
			notype=StringTool1.getReplace(notype,this.type,"");
			notype=StringTool1.getReplace(notype,":","");
			return notype;
		}

		VarParser.getVar=function(str,parser){
			if(!parser)parser=new VarParser();
			parser.name=null;
			parser.init=null;
			parser.type=null;
			parser.oStr=str;
			var tArr;
			if(str.indexOf("=")>=0){
				parser.init=StringTool1.getRight(str,"=");
				str=StringTool1.getLeft(str,"=");
			}
			if(str.indexOf(":")>=0){
				parser.type=StringTool1.getRight(str,":");
				str=StringTool1.getLeft(str,":");
			}
			parser.name=str;
			var notype;
			notype=parser.oStr;
			notype=StringTool1.getReplace(notype,parser.type,"");
			notype=StringTool1.getReplace(notype,":","");
			parser.noType=notype;
			return parser;
		}

		VarParser.parseValueLine=function(line){
			var lineStr;
			lineStr=line.lineStr;
			var defines;
			defines=lineStr.split("var ");
			defines.splice(0,1);
			defines=StringTool1.removeEmptyStr(defines);
			var singleVars;
			var i=0;
			var len=0;
			len=defines.length;
			var tVars;
			var tUnit;
			singleVars=[];
			for(i=0;i<len;i++){
				tUnit=defines[i];
				tVars=tUnit.split(",");
				tVars=StringTool1.removeEmptyStr(tVars);
				singleVars=singleVars.concat(tVars);
			}
			len=singleVars.length;
			var tVarStr;
			var tParser;
			var defineList;
			defineList=[];
			var initList;
			var lineCount=0;
			lineCount=line.lineIndex;
			initList=[];
			for(i=0;i<len;i++){
				tVarStr=singleVars[i];
				tParser=VarParser.getVar(tVarStr,tParser);
				defineList.push(LineItem.create(tParser.getDefineStr(),lineCount));
				if(tParser.init){
					initList.push(LineItem.create(tParser.getInitStr(),lineCount));
					lineStr=tParser.getNoType(lineStr);
					}else{
					lineStr=StringTool1.getReplace(lineStr,tParser.oStr,"");
				}
			}
			lineStr=StringTool1.getReplace(lineStr,"var ","");
			line.lineStr=lineStr;
			return [defineList,initList];
		}

		return VarParser;
	})()


	/**
	*一些字符串操作函数
	*@author ww
	*
	*/
	//class as3analyser.tools.StringTool
	var StringTool1=(function(){
		function StringTool(){}
		__class(StringTool,'as3analyser.tools.StringTool',null,'StringTool1');
		StringTool.toUpCase=function(str){
			return str.toUpperCase();
		}

		StringTool.toLowCase=function(str){
			return str.toLowerCase();
		}

		StringTool.toUpHead=function(str){
			var rst;
			if(str.length<=1)return str.toUpperCase();
			rst=str.charAt(0).toUpperCase()+str.substr(1);
			return rst;
		}

		StringTool.toLowHead=function(str){
			var rst;
			if(str.length<=1)return str.toLowerCase();
			rst=str.charAt(0).toLowerCase()+str.substr(1);
			return rst;
		}

		StringTool.packageToFolderPath=function(packageName){
			var rst;
			rst=packageName.replace(".","/");
			return rst;
		}

		StringTool.insert=function(str,iStr,index){
			return str.substring(0,index)+iStr+str.substr(index);
		}

		StringTool.insertAfter=function(str,iStr,tarStr,isLast){
			(isLast===void 0)&& (isLast=false);
			var i=0;
			if(isLast){
				i=str.lastIndexOf(tarStr);
				}else{
				i=str.indexOf(tarStr);
			}
			if(i>=0){
				return StringTool.insert(str,iStr,i+tarStr.length);
			}
			return str;
		}

		StringTool.insertBefore=function(str,iStr,tarStr,isLast){
			(isLast===void 0)&& (isLast=false);
			var i=0;
			if(isLast){
				i=str.lastIndexOf(tarStr);
				}else{
				i=str.indexOf(tarStr);
			}
			if(i>=0){
				return StringTool.insert(str,iStr,i);
			}
			return str;
		}

		StringTool.insertParamToFun=function(funStr,params){
			var oldParam;
			oldParam=StringTool.getParamArr(funStr);
			var inserStr;
			inserStr=params.join(",");
			if(oldParam.length>0){
				inserStr=","+inserStr;
			}
			return StringTool.insertBefore(funStr,inserStr,")",true);
		}

		StringTool.trim=function(str,vList){
			if(!vList){
				vList=[" ","\r","\n","\t",String.fromCharCode(65279)];
			};
			var rst;
			var i=0;
			var len=0;
			rst=str;
			len=vList.length;
			for(i=0;i<len;i++){
				rst=StringTool.getReplace(rst,vList[i],"");
			}
			return rst;
		}

		StringTool.isEmpty=function(str){
			if(str.length<1)return true;
			return StringTool.emptyStrDic.hasOwnProperty(str);
		}

		StringTool.trimLeft=function(str){
			var i=0;
			i=0;
			var len=0;
			len=str.length;
			while(StringTool.isEmpty(str.charAt(i))&&i<len){
				i++;
			}
			if(i<len){
				return str.substr(i);
			}
			return "";
		}

		StringTool.trimRight=function(str){
			var i=0;
			i=str.length-1;
			while(StringTool.isEmpty(str.charAt(i))&&i>=0){
				i--;
			};
			var rst;
			rst=str.substring(0,i)
			if(i>=0){
				return str.substring(0,i+1);
			}
			return "";
		}

		StringTool.trimSide=function(str){
			var rst;
			rst=StringTool.trimLeft(str);
			rst=StringTool.trimRight(rst);
			return rst;
		}

		StringTool.trimButEmpty=function(str){
			return StringTool.trim(str,["\r","\n","\t"]);
		}

		StringTool.removeEmptyStr=function(strArr){
			var i=0;
			i=strArr.length-1;
			var str;
			for(i=i;i>=0;i--){
				str=strArr[i];
				str=as3analyser.tools.StringTool.trimSide(str);
				if(StringTool.isEmpty(str)){
					strArr.splice(i,1);
					}else{
					strArr[i]=str;
				}
			}
			return strArr;
		}

		StringTool.ifNoAddToTail=function(str,sign){
			if(str.indexOf(sign)>=0){
				return str;
			}
			return str+sign;
		}

		StringTool.getSelectLinesStr=function(lines,startLine,endLine){
			var i=0;
			var rLines;
			rLines=[];
			if(startLine<0)startLine=0;
			if(endLine>lines.length-1)endLine=lines.length-1;
			var tLine;
			for(i=startLine;i<=endLine;i++){
				tLine=lines[i];
				rLines.push(tLine.lineStr);
			}
			return rLines.join("\n");
		}

		StringTool.getPiecesCode=function(pieces,ifTrim){
			(ifTrim===void 0)&& (ifTrim=true);
			var pArr;
			pArr=[];
			var i=0;
			var len=0;
			var tPiece;
			len=pieces.length;
			for(i=0;i<len;i++){
				tPiece=pieces[i];
				pArr.push(tPiece.getCode());
			}
			if(ifTrim){
				StringTool.trimLines(pieces);
			}
			return pArr.join("\n");
		}

		StringTool.trimEmptyLine=function(str){
			var i=0;
			var len=0;
			var tLines;
			var tLine;
			tLines=str.split("\n");
			for(i=tLines.length-1;i>=0;i--){
				tLine=tLines[i];
				if(StringTool.isEmptyLine(tLine)){
					tLines.splice(i,1);
				}
			}
			return tLines.join("\n");
		}

		StringTool.trimLines=function(lines){
			var i=0;
			i=0;
			while(lines.length>0&&StringTool.isEmptyFunLineStr(lines[0])){
				lines.shift();
			}
			while(lines.length>0&&StringTool.isEmptyFunLineStr(lines[lines.length-1])){
				lines.pop();
			}
			return lines;
		}

		StringTool.isEmptyFunLineStr=function(str){
			str=as3analyser.tools.StringTool.trim(str);
			if(Defines.isBWrap(str)){
				return true;
			}
			if(str=="")return true;
			return false;
		}

		StringTool.isEmptyLine=function(str){
			str=as3analyser.tools.StringTool.trim(str);
			if(str=="")return true;
			return false;
		}

		StringTool.removeCommentLine=function(lines){
			var rst;
			rst=[];
			var i=0;
			var tLine;
			var adptLine;
			i=0;
			var len=0;
			var index=0;
			len=lines.length;
			while(i<len){
				adptLine=tLine=lines[i];
				if((index=tLine.indexOf("/**"))&&(index>=0)){
					adptLine=tLine.substring(0,index-1);
					StringTool.addIfNotEmpty(rst,adptLine);
					while(i<len){
						tLine=lines[i];
						if((index=tLine.indexOf("*/"))&&(index>=0)){
							adptLine=tLine.substring(index+2);
							StringTool.addIfNotEmpty(rst,adptLine);
							break ;
						}
						i++;
					}
					}else if(tLine.indexOf("//")>=0){
					if(as3analyser.tools.StringTool.trim(tLine).indexOf("//")==0){
						}else{
						StringTool.addIfNotEmpty(rst,adptLine);
					}
					}else{
					StringTool.addIfNotEmpty(rst,adptLine);
				}
				i++;
			}
			return rst;
		}

		StringTool.removeCommentLineS=function(lines){
			var rst;
			rst=[];
			var i=0;
			var tLine;
			var adptLine;
			i=0;
			var len=0;
			var index=0;
			var tLineItem;
			len=lines.length;
			while(i<len){
				tLineItem=lines[i];
				adptLine=tLine=tLineItem.lineStr;
				if((index=tLine.indexOf("/*"))&&(index>=0)){
					adptLine=tLine.substring(0,index-1);
					StringTool.addIfNotEmptyS(rst,adptLine,tLineItem);
					while(i<len){
						tLineItem=lines[i];
						adptLine=tLine=tLineItem.lineStr;
						if((index=tLine.indexOf("*/"))&&(index>=0)){
							adptLine=tLine.substring(index+2);
							StringTool.addIfNotEmptyS(rst,adptLine,tLineItem);
							break ;
						}
						i++;
					}
					}else if(tLine.indexOf("//")>=0){
					if(as3analyser.tools.StringTool.trim(tLine).indexOf("//")==0){
						}else{
						StringTool.addIfNotEmptyS(rst,adptLine,tLineItem);
					}
					}else{
					StringTool.addIfNotEmptyS(rst,adptLine,tLineItem);
				}
				i++;
			}
			return rst;
		}

		StringTool.addIfNotEmptyS=function(arr,str,lineItem){
			if(!str)return;
			var tStr;
			tStr=StringTool.trim(str);
			if(tStr!=""){
				arr.push(lineItem);
			}
		}

		StringTool.addIfNotEmpty=function(arr,str){
			if(!str)return;
			var tStr;
			tStr=StringTool.trim(str);
			if(tStr!=""){
				arr.push(str);
			}
		}

		StringTool.trimExt=function(str,vars){
			var rst;
			rst=StringTool.trim(str);
			var i=0;
			var len=0;
			len=vars.length;
			for(i=0;i<len;i++){
				rst=StringTool.getReplace(rst,vars[i],"");
			}
			return rst;
		}

		StringTool.getBetween=function(str,left,right,ifMax){
			(ifMax===void 0)&& (ifMax=false);
			if(!str)return "";
			if(!left)return "";
			if(!right)return "";
			var lId=0;
			var rId=0;
			lId=str.indexOf(left);
			if(lId<0)return"";
			if(ifMax){
				rId=str.lastIndexOf(right);
				if(rId<lId)return "";
				}else{
				rId=str.indexOf(right,lId);
			}
			if(rId<0)return "";
			return str.substring(lId+left.length,rId);
		}

		StringTool.getSplitLine=function(line,split){
			(split===void 0)&& (split=" ");
			return line.split(split);
		}

		StringTool.getLeft=function(str,sign){
			var i=0;
			i=str.indexOf(sign);
			return str.substr(0,i);
		}

		StringTool.getRight=function(str,sign){
			var i=0;
			i=str.indexOf(sign);
			return str.substr(i+1);
		}

		StringTool.delelteItem=function(arr){
			while (arr.length>0){
				if(arr[0]==""){
					arr.shift();
					}else{
					break ;
				}
			}
		}

		StringTool.getWords=function(line){
			var rst=StringTool.getSplitLine(line);
			StringTool.delelteItem(rst);
			return rst;
		}

		StringTool.getOLine=function(pos,lines,oLines){
			var tLine=lines[pos.line];
			return oLines.indexOf(tLine);
		}

		StringTool.getLines=function(posS,posE,lines,rawLines){
			var startLine=0;
			startLine=posS.line;
			var endLine=0;
			endLine=posE.line;
			if(rawLines){
				startLine=StringTool.getOLine(posS,lines,rawLines);
				endLine=StringTool.getOLine(posE,lines,rawLines);
				lines=rawLines;
			}
			return StringTool.getLinesI(startLine,endLine,lines);
		}

		StringTool.getLinesI=function(startLine,endLine,lines){
			var i=0;
			var rst=[];
			for(i=startLine;i<=endLine;i++){
				rst.push(lines[i]);
			}
			return rst;
		}

		StringTool.structfy=function(str,inWidth,removeEmpty){
			(inWidth===void 0)&& (inWidth=4);
			(removeEmpty===void 0)&& (removeEmpty=true);
			if(removeEmpty){
				str=as3analyser.tools.StringTool.trimEmptyLine(str);
			};
			var lines;
			var tIn=0;
			tIn=0;
			var tInStr;
			tInStr=StringTool.getEmptyStr(0);
			lines=str.split("\n");
			var i=0;
			var len=0;
			var tLineStr;
			len=lines.length;
			for(i=0;i<len;i++){
				tLineStr=lines[i];
				tLineStr=as3analyser.tools.StringTool.trimLeft(tLineStr);
				tLineStr=as3analyser.tools.StringTool.trimRight(tLineStr);
				tIn+=StringTool.getPariCount(tLineStr);
				if(tLineStr.indexOf("}")>=0){
					tInStr=StringTool.getEmptyStr(tIn*inWidth);
				}
				tLineStr=tInStr+tLineStr;
				lines[i]=tLineStr;
				tInStr=StringTool.getEmptyStr(tIn*inWidth);
			}
			return lines.join("\n");
		}

		StringTool.getEmptyStr=function(width){
			if(!StringTool.emptyDic.hasOwnProperty(width)){
				var i=0;
				var len=0;
				len=width;
				var rst;
				rst="";
				for(i=0;i<len;i++){
					rst+=" ";
				}
				StringTool.emptyDic[width]=rst;
			}
			return StringTool.emptyDic[width];
		}

		StringTool.getPariCount=function(str,inChar,outChar){
			(inChar===void 0)&& (inChar="{");
			(outChar===void 0)&& (outChar="}");
			var varDic;
			varDic={};
			varDic[inChar]=1;
			varDic[outChar]=-1;
			var i=0;
			var len=0;
			var tChar;
			len=str.length;
			var rst=0;
			rst=0;
			for(i=0;i<len;i++){
				tChar=str.charAt(i);
				if(varDic.hasOwnProperty(tChar)){
					rst+=varDic[tChar];
				}
			}
			return rst;
		}

		StringTool.readInt=function(str,startI){
			(startI===void 0)&& (startI=0);
			var rst=NaN;
			rst=0;
			var tNum=0;
			var tC;
			var i=0;
			var isBegin=false;
			isBegin=false;
			var len=0;
			len=str.length;
			for(i=startI;i<len;i++){
				tC=str.charAt(i);
				if(Number(tC)>0||tC=="0"){
					rst=10*rst+Number(tC);
					if(rst>0)isBegin=true;
					}else{
					if(isBegin)return rst;
				}
			}
			return rst;
		}

		StringTool.getReplace=function(str,oStr,nStr){
			if(!str)return "";
			str+="";
			var rst;
			rst=str.replace(new RegExp(oStr,"g"),nStr);
			return rst;
		}

		StringTool.getWordCount=function(str,findWord){
			var rg=new RegExp(findWord,"g")
			return str.match(rg).length;
		}

		StringTool.getResolvePath=function(path,basePath){
			if(StringTool.isAbsPath(path)){
				return path;
			};
			var tSign;
			tSign="\\";
			if(basePath.indexOf("/")>=0){
				tSign="/";
			}
			if(basePath.charAt(basePath.length-1)==tSign){
				basePath=basePath.substr(0,basePath.length-1);
			};
			var parentSign;
			parentSign=".."+tSign;
			var tISign;
			tISign="."+tSign;
			var pCount=0;
			pCount=StringTool.getWordCount(path,parentSign);
			path=as3analyser.tools.StringTool.getReplace(path,parentSign,"");
			path=as3analyser.tools.StringTool.getReplace(path,tISign,"");
			var i=0;
			var len=0;
			len=pCount;
			var iPos=0;
			for(i=0;i<len;i++){
				basePath=StringTool.removeLastSign(path,tSign);
			}
			return basePath+tSign+path;
		}

		StringTool.isAbsPath=function(path){
			if(path.indexOf(":")>=0)return true;
			return false;
		}

		StringTool.removeLastSign=function(str,sign){
			var iPos=0;
			iPos=str.lastIndexOf(sign);
			str=str.substring(0,iPos);
			return str;
		}

		StringTool.getParamArr=function(str){
			var paramStr;
			paramStr=as3analyser.tools.StringTool.getBetween(str,"(",")",true);
			if(StringTool.trim(paramStr).length<1)return [];
			return paramStr.split(",");
		}

		StringTool.nextIS=function(str,pos,lines){
			var tStr;
			var tLine;
			var i=0;
			var len=0;
			var tIndex=0;
			tIndex=pos.index;
			len=lines.length;
			tStr="";
			for(i=pos.line;i<len;i++){
				tLine=lines[i];
				tStr+=StringTool.trimLeft(tLine.lineStr.substr(tIndex));
				tIndex=0;
				if(tStr.indexOf(str)==0){
					return true;
					}else{
					if(tStr.length>0){
						return false;
					}
				}
			}
			return false;
		}

		StringTool.findFirstMatchLineS=function(str,pos,lines){
			var i=0;
			var len=0;
			var tLine;
			var rst;
			len=lines.length;
			var tIndex=0;
			if(!pos)pos=new PosItem();
			tIndex=pos.index;
			for(i=pos.line;i<len;i++){
				tLine=lines[i].lineStr;
				tIndex=tLine.indexOf(str,tIndex);
				if(tIndex>=0){
					rst=new PosItem();
					rst.line=i;
					rst.index=tIndex;
					rst.oLine=lines[i].lineIndex;
					return rst;
				}
				tIndex=0;
			}
			return rst;
		}

		StringTool.copyStr=function(str){
			return str.substring();
		}

		StringTool.findPair=function(l,r,pos,lines){
			var tCount=0;
			var first=0;
			var tPos;
			var rPos;
			var lPos;
			var valueDic;
			valueDic={};
			valueDic[l]=1;
			valueDic[r]=-1;
			tPos=StringTool.findFirstMatchLineS(l,pos,lines);
			var posList;
			posList=[];
			if(tPos){
				setTPos(tPos,l);
				while(tCount>0){
					lPos=StringTool.findFirstMatchLineS(l,tPos,lines);
					rPos=StringTool.findFirstMatchLineS(r,tPos,lines);
					if(!lPos&&!rPos){
						break ;
					}
					if(!lPos){
						setTPos(rPos,r);
						continue ;
					}
					if(!rPos){
						setTPos(lPos,l);
						continue ;
					}
					if(PosItem.pre(rPos,lPos)){
						setTPos(rPos,r);
						}else{
						setTPos(lPos,l);
					}
				}
				if(tCount==0){
					return posList;
					}else{
					return null;
				}
			}
			return null;
			function setTPos (pos,str){
				tPos=pos;
				tPos.str=str;
				tPos.index++;
				posList.push(tPos);
				tCount+=valueDic[str];
			}
		}

		StringTool.ArrayToString=function(arr){
			var rst;
			rst="[{items}]".replace(new RegExp("\\{items\\}","g"),StringTool.getArrayItems(arr));
			return rst;
		}

		StringTool.getArrayItems=function(arr){
			var rst;
			if(arr.length<1)return "";
			rst=StringTool.parseItem(arr[0]);
			var i=0;
			var len=0;
			len=arr.length;
			for(i=1;i<len;i++){
				rst+=","+StringTool.parseItem(arr[i]);
			}
			return rst;
		}

		StringTool.parseItem=function(item){
			var rst;
			rst="\""+item+"\"";
			return "";
		}

		StringTool.emptyDic={};
		__static(StringTool,
		['emptyStrDic',function(){return this.emptyStrDic={
				" ":true,
				"\r":true,
				"\n":true,
				"\t":true
		};}

		]);
		return StringTool;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-7-30 下午4:49:08
	*/
	//class as3analyser.tools.ToolFuns
	var ToolFuns=(function(){
		function ToolFuns(){}
		__class(ToolFuns,'as3analyser.tools.ToolFuns');
		ToolFuns.saveTxtFile=function(fileName,fileContent){
			FileManager.createTxtFile(fileName,fileContent);
		}

		ToolFuns.readTxtFile=function(fileName){
			return FileManager.readTxtFile(fileName);
		}

		ToolFuns.getArrFromDic=function(dic){
			var rst;
			rst=[];
			var key;
			for(key in dic){
				rst.push(key);
			}
			return rst;
		}

		ToolFuns.getArrFromObj=function(obj){
			var rst;
			rst=[];
			var key;
			for(key in obj){
				rst.push(obj[key]);
			}
			return rst;
		}

		ToolFuns.getNotIn=function(oA,oB){
			var rst;
			rst={};
			var key;
			for (key in oA){
				if(!oB.hasOwnProperty(key)){
					rst[key]=true;
				}
			}
			return rst;
		}

		ToolFuns.mergeO=function(oA,oB){
			var rst;
			rst={};
			var key;
			for (key in oA){
				rst[key]=true;
			}
			for (key in oB){
				rst[key]=true;
			}
			return rst;
		}

		ToolFuns.getSimpleFileName=function(filePath){
			return filePath.substr(filePath.lastIndexOf("\\")+1);
		}

		ToolFuns.myTrace=function(msg){
			console.log(msg);
		}

		return ToolFuns;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-8-31 下午7:19:15
	*/
	//class as3analyser.Tracer
	var Tracer=(function(){
		function Tracer(){}
		__class(Tracer,'as3analyser.Tracer');
		Tracer.myTrace=function(msg){}
		return Tracer;
	})()


	/**
	*本类用于节点数据不同格式间的转换
	*@author ww
	*/
	//class laya.editor.core.design.DesignInfo
	var DesignInfo=(function(){
		function DesignInfo(){
			this.type=null;
			this.child=null;
			this.props=null;
			this.compId=0;
		}

		__class(DesignInfo,'laya.editor.core.design.DesignInfo');
		DesignInfo.uiObjToXml=function(uiObj,aniXml){
			var xml;
			xml=new XMLElement();
			xml.setLocalName(uiObj.type);
			if(!aniXml){
				aniXml=new XMLElement();
				aniXml.setLocalName("Ani");
			};
			var key;
			var props;
			props=uiObj.props;
			for(key in props){
				xml.setAttribute(key,props[key]);
			};
			var childs;
			childs=uiObj.child;
			if(!childs)childs=[];
			var i=0,len=0;
			len=childs.length;
			for(i=0;i<len;i++){
				xml.appendChild(DesignInfo.uiObjToXml(childs[i],aniXml));
			}
			xml.setAttribute("editorInfo",DesignInfo.getIDEValue(uiObj));
			var frames;
			frames=uiObj.frames;
			if(!frames)frames=[];
			var frameXml;
			frameXml=new XMLElement();
			frameXml.setLocalName("tarAni");
			frameXml.setAttribute("target",uiObj.compId);
			len=frames.length;
			var tFrame;
			var tFrameO;
			for(i=0;i<len;i++){
				tFrameO=frames[i];
				tFrame=new XMLElement();
				tFrame.setLocalName("frame");
				props=tFrameO.props;
				for(key in props){
					tFrame.setAttribute(key,props[key]);
				}
				tFrame.setAttribute("editorInfo",DesignInfo.getIDEValue(tFrameO,DesignInfo.frameSaveKeys));
				frameXml.appendChild(tFrame);
			}
			return xml;
		}

		DesignInfo.getIDEValue=function(node,saveKeys){
			if(!saveKeys)saveKeys=DesignInfo.saveEmpty;
			var rst;
			var key;
			var KeyValues;
			KeyValues=[];
			for(key in node){
				if(!DesignInfo.specialKeys.hasOwnProperty(key)||saveKeys.hasOwnProperty(key)){
					if(key=="compId")
						KeyValues.push(key+"="+node[key]);
					if(key=="source"){
						KeyValues.push(key+"="+node[key]);
					}
				}
			}
			rst=KeyValues.join(";");
			return rst;
		}

		DesignInfo.xmlStrToUIObj=function(xmlString){
			return DesignInfo.uiXmlToObj(Utils.parseXMLFromString(xmlString));
		}

		DesignInfo.uiXmlToObj=function(xml){
			var xmlObj;
			xmlObj=XML2Object.parse(xml);
			var rst;
			var aniDic;
			aniDic=DesignInfo.parseFramesData(xmlObj.cList[0]);
			rst=DesignInfo.getUIObjByXmlObj(xmlObj.cList[0],aniDic);
			return rst;
		}

		DesignInfo.parseFramesData=function(data){
			var aniDic;
			aniDic={};
			var ani;
			ani=data.cList[0];
			if(!ani)return aniDic;
			var frames;
			frames=ani.c["tarAni"];
			if(!frames)frames=[];
			var i=0,len=0;
			len=frames.length;
			var tAni;
			var tarFrames;
			for(i=0;i<len;i++){
				tAni=frames[i];
				tarFrames=tAni.c.frame;
				if(!tarFrames)tarFrames=[];
				if(! (tarFrames instanceof Array)){
					tarFrames=[tarFrames];
				}
				aniDic[tAni.p["target"]]=DesignInfo.parseTarFrames(tarFrames);
			}
			return aniDic;
		}

		DesignInfo.parseTarFrames=function(tarFrames){
			var i=0,len=0;
			len=tarFrames.length;
			var tFrame;
			var rst;
			rst=[];
			for(i=0;i<len;i++){
				rst.push(DesignInfo.createNodeObj(tarFrames[i]));
			}
			return rst;
		}

		DesignInfo.getUIObjByXmlObj=function(xmlObj,aniDic){
			var rst;
			var cList;
			rst=DesignInfo.createNodeObj(xmlObj);
			var props;
			var key;
			var i=0,len=0;
			cList=xmlObj.cList;
			var frames;
			frames=[];
			if(cList)
				len=cList.length;
			var tObj;
			var childs;
			childs=[];
			for(i=0;i<len;i++){
				tObj=cList[i];
				if(tObj.Name=="parsererror"){
					throw new Error();
					continue ;
				}
				if(tObj.Name=="Ani")continue ;
				if(!tObj.Name)continue ;
				if(tObj.Name=="")continue ;
				if(tObj.Name=="frame"){
					frames.push(DesignInfo.createNodeObj(tObj));
					}else{
					childs.push(DesignInfo.getUIObjByXmlObj(tObj,aniDic));
				}
			}
			rst.child=childs;
			if(aniDic[rst.compId])
				rst.frames=aniDic[rst.compId];
			return rst;
		}

		DesignInfo.createNodeObj=function(data){
			var rst;
			rst={};
			rst.type=data.Name;
			rst.props={};
			if(rst.type=="UIView"&&!rst.source){
				rst.source=data.p.source;
			}
			if(!rst.type){
				debugger;
			}
			DesignInfo.createValueObj(data.p,rst.props);
			delete rst["frame"];
			DesignInfo.solveEditorInfo(rst);
			return rst;
		}

		DesignInfo.createValueObj=function(srcProps,rst){
			if(!rst)
				rst={};
			var key;
			for(key in srcProps){
				rst[key]=ObjectTools.getStrTypedValue(srcProps[key]);
			}
			return rst;
		}

		DesignInfo.solveEditorInfo=function(node){
			var keyValueStr;
			keyValueStr=node.props["editorInfo"];
			delete node.props["editorInfo"];
			var keyvalueStrs;
			if(keyValueStr){
				keyvalueStrs=keyValueStr.split(";");
				var i=0,len=0;
				var tArr;
				len=keyvalueStrs.length;
				for(i=0;i<len;i++){
					tArr=keyvalueStrs[i].split("=");
					node[tArr[0]]=ObjectTools.getStrTypedValue(tArr[1]);
				}
			}
		}

		DesignInfo.EditorInfo="editorInfo";
		DesignInfo.Frame="frame";
		DesignInfo.Ani="Ani";
		DesignInfo.TarAni="tarAni";
		DesignInfo.Target="target";
		DesignInfo.saveEmpty={};
		__static(DesignInfo,
		['specialKeys',function(){return this.specialKeys={
				type:true,
				child:true,
				props:true,
				editorInfo:true,
				frames:true
				};},'frameSaveKeys',function(){return this.frameSaveKeys={
				type:true
		};}

		]);
		return DesignInfo;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-12-15 下午2:55:24
	*/
	//class laya.editor.core.design.TreeData
	var TreeData=(function(){
		function TreeData(){
			this._nodeDic=null;
			this._root=null;
			this._nodeList=null;
		}

		__class(TreeData,'laya.editor.core.design.TreeData');
		var __proto=TreeData.prototype;
		__proto.addChild=function(child,parent){
			TreeData.getNodeChilds(parent).push(child);
			this.setNodeParent(child,parent);
			return child;
		}

		__proto.removeSelf=function(child){
			this.removeChild(child,this.getNodeParent(child));
		}

		__proto.removeChild=function(child,parent){
			child.nodeParent=null;
			if(!parent)return child;
			var childList;
			childList=TreeData.getNodeChilds(parent);
			var i=0,len=0;
			len=childList.length;
			for(i=len-1;i>=0;i--){
				if(this.isNodeSame(childList[i],child)){
					childList.splice(i,1);
				}
			}
			return child;
		}

		__proto.isChildE=function(parent,child){
			if (!parent)return false;
			while (child){
				if (this.getNodeParent(child)==parent)return true;
				child=this.getNodeParent(child);
			}
			return false;
		}

		__proto.isInTree=function(pNode,child){
			return pNode==child || this.isChildE(pNode,child);
		}

		__proto.insertToTarParent=function(tarA,tars,after){
			(after===void 0)&& (after=false);
			var tIndex=0;
			var parent;
			if(!tarA)return;
			parent=this.getNodeParent(tarA);
			if(!parent)return;
			this.transTarsParent(parent,tars);
			var i=0,len=0;
			len=tars.length;
			for(i=0;i<len;i++){
				this.removeSelf(tars[i]);
				tIndex=this.getChildIndex(tarA,parent);
				if(after)tIndex++;
				this.addChildAt(tars[i],tIndex,parent);
			}
		}

		//insertToParent(parent,tars,tIndex);
		__proto.insertToParent=function(parent,tars,index){
			(index===void 0)&& (index=-1);
			if(!parent)return;
			this.transTarsParent(parent,tars);
			this.removeItemFromParent(tars);
			if(index<0)index=this.numChildren(parent);
			var i=0,len=0;
			len=tars.length;
			for(i=0;i<len;i++){
				this.transParent(tars[i],parent);
				this.addChildAt(tars[i],index,parent);
			}
		}

		__proto.transTarsParent=function(parent,tars){
			var i=0,len=0;
			len=tars.length;
			for(i=0;i<len;i++){
				this.transParent(tars[i],parent);
			}
		}

		__proto.removeItemFromParent=function(tars){
			var i=0,len=0;
			len=tars.length;
			for(i=0;i<len;i++){
				this.removeSelf(tars[i]);
			}
		}

		__proto.transParent=function(tar,newParent){
			Notice1.notify("Display_transParent",[tar,newParent]);
		}

		__proto.addChildAt=function(child,index,parent){
			if(child==parent){
				throw new Error("appendChildAt:add self to self");
			}
			this.removeSelf(child);
			var childs;
			childs=TreeData.getNodeChilds(parent);
			if (index >=0 && index <=childs.length){
				childs.splice(index,0,child);
				this.setNodeParent(child,parent);
				return child;
				}else {
				throw new Error("appendChildAt:The index is out of bounds");
			}
			return child;
		}

		__proto.isNodeSame=function(nodeA,nodeB){
			if(!nodeA||!nodeB)return false;
			return nodeA==nodeB||nodeA.compId==nodeB.compId;
		}

		__proto.numChildren=function(parent){
			return TreeData.getNodeChilds(parent).length;
		}

		__proto.getChildIndex=function(child,parent){
			var i=0,len=0;
			var childs;
			childs=TreeData.getNodeChilds(parent);
			len=childs.length;
			for(i=0;i<len;i++){
				if(this.isNodeSame(childs[i],child))return i;
			}
			return TreeData.getNodeChilds(parent).indexOf(child);
		}

		__proto.getNodeByID=function(id){
			return this._nodeDic[id];
		}

		__proto.getNodeParent=function(child){
			return this.getNodeByID(child.nodeParent);
		}

		__proto.setNodeParent=function(child,parent){
			if(TreeData.getNodeID(child)==TreeData.getNodeID(parent)){
				debugger;
			}
			child.nodeParent=TreeData.getNodeID(parent);
		}

		__proto.getNodeLabel=function(node){
			var str;
			if(node.type=="Script"){
				str=AppendPropGroupTool.getScriptName(node.source);
			}else
			if(node.props["var"]){
				str=node.type+"("+node.props["var"]+")";
			}else
			if(node.props.name){
				str=node.type+"("+node.props.name+")";
			}else
			if(node.props.preset){
				var presetName;
				presetName=node.props.preset.split("/").pop();
				presetName=StringTool.getReplace(presetName,".prefab","");
				str=node.type+"("+presetName+")";
				}else{
				str=node.type
			}
			return str;
		}

		__proto.reset=function(){
			this._root=null;
			this._nodeDic={};
			this._nodeList=[];
		}

		__proto.setData=function(uiObj){
			this.reset();
			this._root=uiObj;
			this.modifyNode(this._root,null);
		}

		__proto.modifyNode=function(node,parent,isAniNode){
			(isAniNode===void 0)&& (isAniNode=true);
			this._nodeList.push(node);
			delete node.x;
			delete node.y;
			if(!node.compId){
				debugger;
			}
			node.isAniNode=isAniNode;
			this._nodeDic[node.compId]=node;
			this.setNodeParent(node,parent);
			node.label=this.getNodeLabel(node);
			var i=0,len=0;
			var childs;
			childs=TreeData.getNodeChilds(node);
			len=childs.length;
			var childAni=false;
			childAni=isAniNode&&(!FilterFuns.isUnAnimationAbleType(node.type));
			for(i=0;i<len;i++){
				this.modifyNode(childs[i],node,childAni);
			}
			node.hasChild=node.isDirectory=childs.length>0;
			TreeData.getNodeFrames(node);
		}

		__proto.getTreeArr=function(){
			return this._nodeList;
		}

		__proto.recordFrameData=function(node,frame,workChild){
			(workChild===void 0)&& (workChild=false);
			if(!node)node=this._root;
			TreeData.recordTreeFrame(node,frame);
		}

		__proto.getMaxFrame=function(){
			var maxFrame=0;
			var i=0,len=0;
			var nodes;
			var tFrameCount=0;
			nodes=this._nodeList;
			len=nodes.length;
			maxFrame=0;
			for(i=0;i<len;i++){
				tFrameCount=TreeData.getNodeMaxFrame(nodes[i]);
				if(maxFrame<tFrameCount){
					maxFrame=tFrameCount;
				}
			}
			return maxFrame;
		}

		__getset(0,__proto,'root',function(){
			return this._root;
		});

		TreeData.getNodeID=function(node){
			if(!node)return-1;
			return node.compId;
		}

		TreeData.getNodeChilds=function(node){
			if(!node.child){
				node.child=[];
			}
			return node.child;
		}

		TreeData.cleanNode=function(node){
			var i=0,len=0;
			len=TreeData._cleanNames.length;
			for(i=0;i<len;i++){
				delete node[TreeData._cleanNames[i]];
			};
			var childs;
			childs=TreeData.getNodeChilds(node);
			len=childs.length;
			for(i=0;i<len;i++){
				TreeData.cleanNode(childs[i]);
			}
		}

		TreeData.recordTreeFrame=function(node,frame,workChild){
			(workChild===void 0)&& (workChild=false);
			TreeData.recordFrame(node,frame,false);
			if(!workChild)return;
			var i=0,len=0;
			var childs;
			childs=TreeData.getNodeChilds(node);
			len=childs.length;
			for(i=0;i<len;i++){
				TreeData.recordTreeFrame(childs[i],frame,workChild);
			}
		}

		TreeData.isNodeFrameChanged=function(node,frame){
			return true;
		}

		TreeData.recordFrame=function(node,frame,autoCreate){
			(autoCreate===void 0)&& (autoCreate=false);
			var frameData;
			frameData=TreeData.getFrameData(node,frame,autoCreate);
			if(!frameData){
				return;
			}
			TreeData.copyAniValues(frameData.props,node.props);
		}

		TreeData.getNodeMaxFrame=function(node){
			var frames;
			frames=TreeData.getNodeFrames(node);
			if(frames.length<1)return 0;
			return frames[frames.length-1].frame;
		}

		TreeData.getFrameProps=function(frameData){
			if(!frameData.props){
				frameData.props={};
			}
			return frameData.props;
		}

		TreeData.copyAniValues=function(dest,src){
			var key;
			for(key in src){
				if((typeof (src[key])=='object')){
					debugger;
				}
				dest[key]=src[key];
				if(ObjectTools.isNaN(dest[key])){
					debugger;
				}
			}
		}

		TreeData.getFrameData=function(node,frame,autoCreate){
			(autoCreate===void 0)&& (autoCreate=true);
			var frames;
			frames=TreeData.getNodeFrames(node);
			var pos=0;
			pos=ObjectTools.findItemPos(frames,"frame",frame);
			if(pos<0){
				if(!autoCreate){
					return null;
					}else{
					return TreeData.addFrame(node,frame);
				}
				}else{
				return frames[pos];
			}
		}

		TreeData.getWrapFrame=function(node,frame,autoCreate){
			(autoCreate===void 0)&& (autoCreate=true);
			TreeData.sortNodeFrames(node);
			var i=0,len=0;
			var frames;
			frames=TreeData.getNodeFrames(node);
			len=frames.length;
			var tFrame;
			for(i=0;i<len;i++){
				tFrame=frames[i];
				if(tFrame.frame==frame){
					return [tFrame];
				}
				if(tFrame.frame>frame){
					break ;
				}
			}
			if(tFrame&&tFrame.frame>=frame){
				if(tFrame.frame==frame){
					return [tFrame];
				}else
				if(tFrame.frame>frame){
					return [frames[i-1],tFrame];
				}
				}else{
				var frameProps;
				frameProps=tFrame?ObjectTools.copyObj(tFrame.props):ObjectTools.copyObj(node.props);
				tFrame=TimeFrameData.create(frame,frameProps);
				if(autoCreate){
					TreeData.addFrameToNode(tFrame,node);
					}else{
				}
				return [tFrame];
			}
			return null;
		}

		TreeData.getNodeFrameProps=function(node,frame){
			var wrapsFrames;
			wrapsFrames=TreeData.getWrapFrame(node,frame,false);
			var rst;
			if(wrapsFrames.length==1){
				rst=wrapsFrames[0].props;
				}else{
				rst=TreeData.getFrameProp(wrapsFrames[0],wrapsFrames[1],frame);
			}
			return ObjectTools.copyObj(rst);
		}

		TreeData.setDefaultValues=function(propA,propB){
			TreeData.setDefaultValueTo(propA,propB);
			TreeData.setDefaultValueTo(propB,propA);
		}

		TreeData.setDefaultValueTo=function(propA,propB){
			var key;
			for(key in propA){
				if(!propB.hasOwnProperty(key)){
					if(TreeData.defaultValueDic.hasOwnProperty(key)){
						propB[key]=TreeData.defaultValueDic[key];
						}else{
						propB[key]=propA[key];
					}
				}
			}
		}

		TreeData.getFrameProp=function(leftFrame,rightFrame,frame){
			var left=0;
			var right=0;
			var props;
			props={};
			left=leftFrame.frame;
			right=rightFrame.frame;
			var percent=NaN;
			percent=(frame-left)/(right-left);
			var key;
			var leftProps;
			var rightProps;
			leftProps=leftFrame.props;
			rightProps=rightFrame.props;
			TreeData.setDefaultValues(rightProps,leftProps);
			var leftValue=NaN;
			var rightValue=NaN;
			for(key in leftProps){
				if(ObjectTools.isNumber(leftProps[key])){
					leftValue=parseFloat(leftProps[key]);
					rightValue=parseFloat(rightProps[key]);
					props[key]=leftValue+percent*(rightValue-leftValue);
					}else{
					props[key]=leftProps[key];
				}
				if(ObjectTools.isNaN(props[key])){
					debugger;
				}
			}
			return props;
		}

		TreeData.sortNodeFrames=function(node){
			var frames=TreeData.getNodeFrames(node);
			frames.sort(MathUtil.sortByKey("frame"));
		}

		TreeData.getNodeFrames=function(node){
			if(!node.frames){
				var frameData;
				frameData=TimeFrameData.create(0,ObjectTools.copyObj(node.props));
				node.frames=[frameData];
			}
			return node.frames;
		}

		TreeData.displayFrame=function(node,frame){
			var disProps;
			disProps=TreeData.getNodeFrameProps(node,frame);
			TreeData.copyAniValues(node.props,disProps);
		}

		TreeData.displayTreeToFrame=function(node,frame,self,child){
			(self===void 0)&& (self=true);
			(child===void 0)&& (child=true);
			if(self){
				TreeData.displayFrame(node,frame);
			}
			if(!child)return;
			var i=0,len=0;
			var childs;
			childs=TreeData.getNodeChilds(node);
			len=childs.length;
			for(i=0;i<len;i++){
				TreeData.displayTreeToFrame(childs[i],frame,true,true);
			}
		}

		TreeData.addFrame=function(node,frame,props){
			if(!props){
				props={};
				var wrapFrames;
				wrapFrames=TreeData.getWrapFrame(node,frame);
				TreeData.copyAniValues(props,wrapFrames[0].props);
			};
			var frameData;
			frameData=TimeFrameData.create(frame,props);
			TreeData.addFrameToNode(frameData,node);
			return frameData;
		}

		TreeData.addFrameToNode=function(frameData,node){
			var preFrameData;
			preFrameData=TreeData.getFrameData(node,frameData.frame,false);
			if(preFrameData){
				TreeData.copyAniValues(preFrameData.props,frameData.props);
				}else{
				var frames;
				frames=TreeData.getNodeFrames(node);
				frames.push(frameData);
				TreeData.sortNodeFrames(node);
			}
		}

		TreeData.moveFrame=function(node,preFrame,newFrame){}
		TreeData.createByUIObj=function(uiObj){
			var treeData;
			treeData=new TreeData();
			treeData.setData(uiObj);
			return treeData;
		}

		__static(TreeData,
		['_cleanNames',function(){return this._cleanNames=
			[
			"label",
			"nodeParent"];},'defaultValueDic',function(){return this.defaultValueDic={
				x:0,
				y:0,
				scaleX:1,
				scaleY:1,
				rotation:0
				};},'defaultValueSameDic',function(){return this.defaultValueSameDic={
				width:0,
				height:0
		};}

		]);
		return TreeData;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-12-15 下午2:42:50
	*/
	//class laya.editor.core.design.TreeDataTool
	var TreeDataTool=(function(){
		function TreeDataTool(){}
		__class(TreeDataTool,'laya.editor.core.design.TreeDataTool');
		TreeDataTool.getNodeData=function(){
			var rst;
			rst={};
			rst.nodeParent=null;
			rst.name="node";
			rst.data={};
			rst.childs=[];
			return rst;
		}

		TreeDataTool.deleteNodePropKeyBut=function(node,keyDic,isBut){
			(isBut===void 0)&& (isBut=true);
			var prop;
			prop=node.props;
			var key;
			if(isBut){
				for(key in prop){
					if(!keyDic[key]){
						delete prop[key];
					}
				}
				}else{
				for(key in keyDic){
					delete prop[key];
				}
			}
		}

		TreeDataTool.deleteAllKeyBut=function(node,keyDic,isBut){
			(isBut===void 0)&& (isBut=true);
			TreeDataTool.deleteNodePropKeyBut(node,keyDic,isBut);
			var childs;
			childs=node.child;
			if(!childs)return;
			var i=0,len=0;
			len=childs.length;
			for(i=0;i<len;i++){
				TreeDataTool.deleteAllKeyBut(childs[i],keyDic,isBut);
			}
		}

		TreeDataTool.deleteNodeKey=function(node,key){
			delete node[key];
			var childs;
			childs=node.child;
			if(!childs)return;
			var i=0,len=0;
			len=childs.length;
			for(i=0;i<len;i++){
				TreeDataTool.deleteNodeKey(childs[i],key);
			}
		}

		TreeDataTool.setNodeValue=function(node,key,value){
			if(!node||!node.props)return;
			node.props[key]=value;
		}

		TreeDataTool.setNodeKey=function(node,key,value){
			TreeDataTool.setNodeValue(node,key,value);
			var childs;
			childs=node.child;
			if(!childs)return;
			var i=0,len=0;
			len=childs.length;
			for(i=0;i<len;i++){
				TreeDataTool.setNodeKey(childs[i],key,value);
			}
		}

		TreeDataTool.changeOneNodeKey=function(node,key,newKey){
			if(!node||!node.props)return;
			var props;
			props=node.props;
			if(props.hasOwnProperty(key)){
				props[newKey]=props[key];
				delete props[key];
				}else{
				delete props[newKey];
			}
		}

		TreeDataTool.changeNodeKey=function(node,key,newKey){
			TreeDataTool.changeOneNodeKey(node,key,newKey);
			var childs;
			childs=node.child;
			if(!childs)return;
			var i=0,len=0;
			len=childs.length;
			for(i=0;i<len;i++){
				TreeDataTool.changeNodeKey(childs[i],key,newKey);
			}
		}

		TreeDataTool.setNodeID=function(node,key,start){
			if(!node||!node.props)return start;
			node.props[key]=start;
			start++;
			return start;
		}

		TreeDataTool.resetNodeID=function(node,key,start){
			(start===void 0)&& (start=1);
			start=TreeDataTool.setNodeID(node,key,start);
			var childs;
			childs=node.child;
			if(!childs)return start;
			var i=0,len=0;
			len=childs.length;
			for(i=0;i<len;i++){
				start=TreeDataTool.resetNodeID(childs[i],key,start);
			}
			return start;
		}

		TreeDataTool.getNodeKeyValue=function(node,key,isProp){
			(isProp===void 0)&& (isProp=true);
			if(!node)return null;
			if(!isProp)return node[key];
			if(!node.props)return null;
			return node.props[key];
		}

		TreeDataTool.saveNodeToDic=function(node,dic,idKey,isProp){
			(isProp===void 0)&& (isProp=true);
			var key;
			key=TreeDataTool.getNodeKeyValue(node,idKey,isProp);
			if(!key)return;
			dic[key]=node;
		}

		TreeDataTool.buildNode=function(node,dic,idKey,isProp){
			(isProp===void 0)&& (isProp=true);
			if(!dic)dic={};
			TreeDataTool.saveNodeToDic(node,dic,idKey,isProp);
			var childs;
			childs=node.child;
			if(!childs)return dic;
			var i=0,len=0;
			len=childs.length;
			for(i=0;i<len;i++){
				TreeDataTool.buildNode(childs[i],dic,idKey,isProp);
			}
			return dic;
		}

		return TreeDataTool;
	})()


	/**拖动管理类*/
	//class laya.editor.core.managers.DragManager
	var DragManager=(function(){
		function DragManager(){
			this._dragInitiator=null;
			this._dragImage=null;
			this._offSet=new Point();
		}

		__class(DragManager,'laya.editor.core.managers.DragManager');
		var __proto=DragManager.prototype;
		/**开始拖动
		*@param dragInitiator 拖动的源对象
		*@param dragImage 显示拖动的图片，如果为null，则是源对象本身
		*@param data 拖动传递的数据
		*@param offset 鼠标居拖动图片的偏移*/
		__proto.doDrag=function(dragInitiator,dragImage,data,offset){
			this.clears();
			DragManager.prePos.setTo(Laya.stage.mouseX,Laya.stage.mouseY);
			this._dragInitiator=dragInitiator;
			this._dragImage=dragImage ? dragImage :dragInitiator;
			DragManager._data=data || {};
			offset=null;
			if(offset){
				this._offSet.setTo(offset.x,offset.y);
				}else{
				this._offSet.setTo(this._dragImage.width*0.5,this._dragImage.height*0.5);
			}
			if (this._dragImage !=this._dragInitiator){
				if (!this._dragImage.parent){
					Laya.stageBox.addChild(this._dragImage);
				}
				offset=offset || new Point();
				var p=this._dragImage.globalToLocal(new Point(Laya.stage.mouseX,Laya.stage.mouseY));
				this._dragImage.x=p.x-offset.x;
				this._dragImage.y=p.y-offset.y;
				this._dragImage.visible=false;
				this._dragImage.mouseEnabled=false;
			}
			Laya.stage.on("mousemove",this,this.onStageMouseMove);
			Laya.stage.on("mouseup",this,this.onStageMouseUp);
		}

		/**放置把拖动条拖出显示区域*/
		__proto.onStageMouseMove=function(e){
			if (Math.abs(DragManager.prePos.x-Laya.stage.mouseX)+Math.abs(DragManager.prePos.y-Laya.stage.mouseY)<8){
				return;
			}
			if(!this._dragImage)return;
			if (!DragManager.isDraging){
				this._dragImage.visible=true;
				this._dragImage.x=Laya.stage.mouseX-this._offSet.x;
				this._dragImage.y=Laya.stage.mouseY-this._offSet.y;
				this._dragImage.startDrag();
				this._dragImage.on("dragmove",this,this.onDraging);
				this._dragInitiator.event("dragStart",[ this._dragInitiator,DragManager._data]);
				DragManager.isDraging=true;
				this._dragImage.mouseEnabled=false;
			}
			this.sendDragEvent("Draging_Hit");
		}

		__proto.onDraging=function(){
			if(!this._dragImage)return;
			this._dragImage.x=Laya.stage.mouseX-this._offSet.x;
			this._dragImage.y=Laya.stage.mouseY-this._offSet.y;
		}

		__proto.onStageMouseUp=function(e){
			Laya.stage.off("mousemove",this,this.onStageMouseMove);
			Laya.stage.off("mouseup",this,this.onStageMouseUp);
			DragManager.dPos.setTo(Laya.stage.mouseX-DragManager.prePos.x,Laya.stage.mouseY-DragManager.prePos.y);
			if (Math.abs(DragManager.prePos.x-Laya.stage.mouseX)+Math.abs(DragManager.prePos.y-Laya.stage.mouseY)<8){
				this.clears();
				return;
			}
			this.getTarList();
			if(!this._dragInitiator)return;
			this._dragInitiator.event("dragComplete",[ this._dragInitiator,DragManager._data]);
			this.clears();
		}

		__proto.clears=function(){
			if(this._dragImage){
				this._dragImage.off("dragmove",this,this.onDraging);
				this._dragImage.mouseEnabled=true;
				if(this._dragImage!=this._dragInitiator)
					this._dragImage.removeSelf();
			}
			this._dragInitiator=null;
			DragManager._data=null;
			this._dragImage=null;
			DragManager.isDraging=false;
			FocusManager.clearFocus();
		}

		__proto.sendDragEvent=function(type){
			this.getTarList(type);
		}

		__proto.getTarList=function(type){
			(type===void 0)&& (type="dragDrop");
			DragManager.sendDragEventByData(type,this._dragInitiator,DragManager._data);
			return;
			var rst;
			rst=DisControlTool.getObjectsUnderPoint(Laya.stage,Laya.stage.mouseX*Browser.pixelRatio,Laya.stage.mouseY*Browser.pixelRatio,null,DisControlTool.visibleAndEnableObjFun);
			var i=0,len=0;
			var tTar;
			len=rst.length;
			var tEvent=DragEvent.TEMP;
			tEvent.dragInitiator=this._dragInitiator;
			tEvent.data=DragManager._data;
			tEvent.hitList=rst;
			for (i=0;i < len;i++){
				tTar=rst[i];
				if ((tTar instanceof laya.events.EventDispatcher )){
					if (tTar.hasListener(type)){
						tEvent.target=tTar;
						tTar.event(type,tEvent);
					}
				}
			}
		}

		DragManager.getDragType=function(){
			if (!DragManager._data||!DragManager._data.type)return null;
			return DragManager._data.type;
		}

		DragManager.getDragTarget=function(){
			if (!DragManager._data || !DragManager._data.target)return null;
			return DragManager._data.target;
		}

		DragManager.sendDragEventByData=function(type,_dragInitiator,_data,x,y){
			(x===void 0)&& (x="s");
			(y===void 0)&& (y="s");
			if(x=="s"){
				x=Laya.stage.mouseX;
			}
			if(y=="s"){
				y=Laya.stage.mouseY;
			};
			var rst;
			rst=DisControlTool.getObjectsUnderPoint(Laya.stage,x*Browser.pixelRatio,y*Browser.pixelRatio,null,DisControlTool.visibleAndEnableObjFun);
			var i=0,len=0;
			var tTar;
			len=rst.length;
			var tEvent=DragEvent.TEMP;
			tEvent.dragInitiator=_dragInitiator;
			tEvent.data=_data;
			tEvent.hitList=rst;
			for (i=0;i < len;i++){
				tTar=rst[i];
				if ((tTar instanceof laya.events.EventDispatcher )){
					if (tTar.hasListener(type)){
						tEvent.target=tTar;
						tTar.event(type,tEvent);
					}
				}
			}
		}

		DragManager._data=null
		DragManager.isDraging=false;
		__static(DragManager,
		['dragOffset',function(){return this.dragOffset=new Point(7,7);},'prePos',function(){return this.prePos=new Point();},'dPos',function(){return this.dPos=new Point();}
		]);
		return DragManager;
	})()


	/**语言管理器*/
	//class laya.editor.core.managers.LangManager
	var LangManager=(function(){
		function LangManager(){
			this._data={};
		}

		__class(LangManager,'laya.editor.core.managers.LangManager');
		var __proto=LangManager.prototype;
		/**获取语言
		*@param code 索引key
		*@param ...args 参数*/
		__proto.getLang=function(code,__args){
			var args=[];for(var i=1,sz=arguments.length;i<sz;i++)args.push(arguments[i]);
			var str=this._data[code] || code;
			if (args.length > 0){
				for (var i=0,n=args.length;i < n;i++){
					str=str.replace("{"+i+"}",args[i]);
				}
			}
			return str;
		}

		/**语言包(key:value方式)*/
		__getset(0,__proto,'data',function(){
			return this._data;
			},function(value){
			this._data=value;
		});

		return LangManager;
	})()


	/**对象工具集*/
	//class laya.editor.core.utils.ObjectUtils
	var ObjectUtils=(function(){
		function ObjectUtils(){};
		__class(ObjectUtils,'laya.editor.core.utils.ObjectUtils');
		ObjectUtils.addFilter=function(target,filter){
			var filters=target.filters || [];
			filters.push(filter);
			target.filters=filters;
		}

		ObjectUtils.clearFilter=function(target,filterType){
			var filters=target.filters;
			if (filters !=null && filters.length > 0){
				for (var i=filters.length-1;i >-1;i--){
					var filter=filters[i];
					if (Laya.__typeof(filter,filterType)){
						filters.splice(i,1);
					}
				}
				target.filters=filters;
			}
		}

		ObjectUtils.getTextField=function(format,text){
			(text===void 0)&& (text="Test");
			ObjectUtils._tf.align="left";
			ObjectUtils._tf.text=text;
			return ObjectUtils._tf;
		}

		ObjectUtils.measureTextWidth=function(format,text){
			(text===void 0)&& (text="Test");
			return ObjectUtils.getTextField(format,text).width;
		}

		__static(ObjectUtils,
		['_tf',function(){return this._tf=new TextField();}
		]);
		return ObjectUtils;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-10-16 上午11:09:00
	*/
	//class laya.editor.core.Wraps.Dictionary
	var Dictionary1=(function(){
		function Dictionary(){
			this.itemList=[];
		}

		__class(Dictionary,'laya.editor.core.Wraps.Dictionary',null,'Dictionary1');
		var __proto=Dictionary.prototype;
		__proto.add=function(key,value){
			var item;
			item=this.getValue(key);
			if(!item){
				item={key:key,value:value};
				this.itemList.push(item);
				}else{
				item.value=value;
			}
		}

		__proto.getValue=function(key){
			var i=0,len=this.itemList.length;
			for(i=0;i<len;i++){
				if(this.itemList[i].key==key)return this.itemList[i].value;
			}
			return null;
		}

		__proto.deleteKey=function(key){
			var i=0,len=this.itemList.length;
			for(i=0;i<len;i++){
				if(this.itemList[i].key==key)return this.itemList.splice(i,1);
			}
		}

		__proto.reset=function(){
			this.itemList.length=0;
		}

		return Dictionary;
	})()


	//class laya.editor.core.Wraps.Keyboard
	var Keyboard1=(function(){
		function Keyboard(){
			;
		}

		__class(Keyboard,'laya.editor.core.Wraps.Keyboard',null,'Keyboard1');
		__getset(1,Keyboard,'capsLock',function(){return false});
		__getset(1,Keyboard,'numLock',function(){return false});
		__getset(1,Keyboard,'hasVirtualKeyboard',function(){return false});
		__getset(1,Keyboard,'physicalKeyboardType',function(){return ""});
		Keyboard.isAccessible=function(){return false}
		Keyboard.KEYNAME_UPARROW="Up";
		Keyboard.KEYNAME_DOWNARROW="Down";
		Keyboard.KEYNAME_LEFTARROW="Left";
		Keyboard.KEYNAME_RIGHTARROW="Right";
		Keyboard.KEYNAME_F1="F1";
		Keyboard.KEYNAME_F2="F2";
		Keyboard.KEYNAME_F3="F3";
		Keyboard.KEYNAME_F4="F4";
		Keyboard.KEYNAME_F5="F5";
		Keyboard.KEYNAME_F6="F6";
		Keyboard.KEYNAME_F7="F7";
		Keyboard.KEYNAME_F8="F8";
		Keyboard.KEYNAME_F9="F9";
		Keyboard.KEYNAME_F10="F10";
		Keyboard.KEYNAME_F11="F11";
		Keyboard.KEYNAME_F12="F12";
		Keyboard.KEYNAME_F13="F13";
		Keyboard.KEYNAME_F14="F14";
		Keyboard.KEYNAME_F15="F15";
		Keyboard.KEYNAME_F16="F16";
		Keyboard.KEYNAME_F17="F17";
		Keyboard.KEYNAME_F18="F18";
		Keyboard.KEYNAME_F19="F19";
		Keyboard.KEYNAME_F20="F20";
		Keyboard.KEYNAME_F21="F21";
		Keyboard.KEYNAME_F22="F22";
		Keyboard.KEYNAME_F23="F23";
		Keyboard.KEYNAME_F24="F24";
		Keyboard.KEYNAME_F25="F25";
		Keyboard.KEYNAME_F26="F26";
		Keyboard.KEYNAME_F27="F27";
		Keyboard.KEYNAME_F28="F28";
		Keyboard.KEYNAME_F29="F29";
		Keyboard.KEYNAME_F30="F30";
		Keyboard.KEYNAME_F31="F31";
		Keyboard.KEYNAME_F32="F32";
		Keyboard.KEYNAME_F33="F33";
		Keyboard.KEYNAME_F34="F34";
		Keyboard.KEYNAME_F35="F35";
		Keyboard.KEYNAME_INSERT="Insert";
		Keyboard.KEYNAME_DELETE="Delete";
		Keyboard.KEYNAME_HOME="Home";
		Keyboard.KEYNAME_BEGIN="Begin";
		Keyboard.KEYNAME_END="End";
		Keyboard.KEYNAME_PAGEUP="PgUp";
		Keyboard.KEYNAME_PAGEDOWN="PgDn";
		Keyboard.KEYNAME_PRINTSCREEN="PrntScrn";
		Keyboard.KEYNAME_SCROLLLOCK="ScrlLck";
		Keyboard.KEYNAME_PAUSE="Pause";
		Keyboard.KEYNAME_SYSREQ="SysReq";
		Keyboard.KEYNAME_BREAK="Break";
		Keyboard.KEYNAME_RESET="Reset";
		Keyboard.KEYNAME_STOP="Stop";
		Keyboard.KEYNAME_MENU="Menu";
		Keyboard.KEYNAME_USER="User";
		Keyboard.KEYNAME_SYSTEM="Sys";
		Keyboard.KEYNAME_PRINT="Print";
		Keyboard.KEYNAME_CLEARLINE="ClrLn";
		Keyboard.KEYNAME_CLEARDISPLAY="ClrDsp";
		Keyboard.KEYNAME_INSERTLINE="InsLn";
		Keyboard.KEYNAME_DELETELINE="DelLn";
		Keyboard.KEYNAME_INSERTCHAR="InsChr";
		Keyboard.KEYNAME_DELETECHAR="DelChr";
		Keyboard.KEYNAME_PREV="Prev";
		Keyboard.KEYNAME_NEXT="Next";
		Keyboard.KEYNAME_SELECT="Select";
		Keyboard.KEYNAME_EXECUTE="Exec";
		Keyboard.KEYNAME_UNDO="Undo";
		Keyboard.KEYNAME_REDO="Redo";
		Keyboard.KEYNAME_FIND="Find";
		Keyboard.KEYNAME_HELP="Help";
		Keyboard.KEYNAME_MODESWITCH="ModeSw";
		Keyboard.NUMBER_0=48;
		Keyboard.NUMBER_1=49;
		Keyboard.NUMBER_2=50;
		Keyboard.NUMBER_3=51;
		Keyboard.NUMBER_4=52;
		Keyboard.NUMBER_5=53;
		Keyboard.NUMBER_6=54;
		Keyboard.NUMBER_7=55;
		Keyboard.NUMBER_8=56;
		Keyboard.NUMBER_9=57;
		Keyboard.A=65;
		Keyboard.B=66;
		Keyboard.C=67;
		Keyboard.D=68;
		Keyboard.E=69;
		Keyboard.F=70;
		Keyboard.G=71;
		Keyboard.H=72;
		Keyboard.I=73;
		Keyboard.J=74;
		Keyboard.K=75;
		Keyboard.L=76;
		Keyboard.M=77;
		Keyboard.N=78;
		Keyboard.O=79;
		Keyboard.P=80;
		Keyboard.Q=81;
		Keyboard.R=82;
		Keyboard.S=83;
		Keyboard.T=84;
		Keyboard.U=85;
		Keyboard.V=86;
		Keyboard.W=87;
		Keyboard.X=88;
		Keyboard.Y=89;
		Keyboard.Z=90;
		Keyboard.SEMICOLON=186;
		Keyboard.EQUAL=187;
		Keyboard.COMMA=188;
		Keyboard.MINUS=189;
		Keyboard.PERIOD=190;
		Keyboard.SLASH=191;
		Keyboard.BACKQUOTE=192;
		Keyboard.LEFTBRACKET=219;
		Keyboard.BACKSLASH=220;
		Keyboard.RIGHTBRACKET=221;
		Keyboard.QUOTE=222;
		Keyboard.ALTERNATE=18;
		Keyboard.BACKSPACE=8;
		Keyboard.CAPS_LOCK=20;
		Keyboard.COMMAND=15;
		Keyboard.CONTROL=17;
		Keyboard.DELETE=46;
		Keyboard.MacDELETE=8;
		Keyboard.DOWN=40;
		Keyboard.END=35;
		Keyboard.ENTER=13;
		Keyboard.ESCAPE=27;
		Keyboard.F1=112;
		Keyboard.F2=113;
		Keyboard.F3=114;
		Keyboard.F4=115;
		Keyboard.F5=116;
		Keyboard.F6=117;
		Keyboard.F7=118;
		Keyboard.F8=119;
		Keyboard.F9=120;
		Keyboard.F10=121;
		Keyboard.F11=122;
		Keyboard.F12=123;
		Keyboard.F13=124;
		Keyboard.F14=125;
		Keyboard.F15=126;
		Keyboard.HOME=36;
		Keyboard.INSERT=45;
		Keyboard.LEFT=37;
		Keyboard.NUMPAD=21;
		Keyboard.NUMPAD_0=96;
		Keyboard.NUMPAD_1=97;
		Keyboard.NUMPAD_2=98;
		Keyboard.NUMPAD_3=99;
		Keyboard.NUMPAD_4=100;
		Keyboard.NUMPAD_5=101;
		Keyboard.NUMPAD_6=102;
		Keyboard.NUMPAD_7=103;
		Keyboard.NUMPAD_8=104;
		Keyboard.NUMPAD_9=105;
		Keyboard.NUMPAD_ADD=107;
		Keyboard.NUMPAD_DECIMAL=110;
		Keyboard.NUMPAD_DIVIDE=111;
		Keyboard.NUMPAD_ENTER=108;
		Keyboard.NUMPAD_MULTIPLY=106;
		Keyboard.NUMPAD_SUBTRACT=109;
		Keyboard.PAGE_DOWN=34;
		Keyboard.PAGE_UP=33;
		Keyboard.RIGHT=39;
		Keyboard.SHIFT=16;
		Keyboard.SPACE=32;
		Keyboard.TAB=9;
		Keyboard.UP=38;
		Keyboard.RED=16777216;
		Keyboard.GREEN=16777217;
		Keyboard.YELLOW=16777218;
		Keyboard.BLUE=16777219;
		Keyboard.CHANNEL_UP=16777220;
		Keyboard.CHANNEL_DOWN=16777221;
		Keyboard.RECORD=16777222;
		Keyboard.PLAY=16777223;
		Keyboard.PAUSE=16777224;
		Keyboard.STOP=16777225;
		Keyboard.FAST_FORWARD=16777226;
		Keyboard.REWIND=16777227;
		Keyboard.SKIP_FORWARD=16777228;
		Keyboard.SKIP_BACKWARD=16777229;
		Keyboard.NEXT=16777230;
		Keyboard.PREVIOUS=16777231;
		Keyboard.LIVE=16777232;
		Keyboard.LAST=16777233;
		Keyboard.MENU=16777234;
		Keyboard.INFO=16777235;
		Keyboard.GUIDE=16777236;
		Keyboard.EXIT=16777237;
		Keyboard.BACK=16777238;
		Keyboard.AUDIO=16777239;
		Keyboard.SUBTITLE=16777240;
		Keyboard.DVR=16777241;
		Keyboard.VOD=16777242;
		Keyboard.INPUT=16777243;
		Keyboard.SETUP=16777244;
		Keyboard.HELP=16777245;
		Keyboard.MASTER_SHELL=16777246;
		Keyboard.SEARCH=16777247;
		__static(Keyboard,
		['CharCodeStrings',function(){return this.CharCodeStrings=["Up","Down","Left","Right","F1","F2","F3","F4","F5","F6","F7","F8","F9","F10","F11","F12","F13","F14","F15","F16","F17","F18","F19","F20","F21","F22","F23","F24","F25","F26","F27","F28","F29","F30","F31","F32","F33","F34","F35","Insert","Delete","Home","Begin","End","PgUp","PgDn","PrntScrn","ScrlLck","Pause","SysReq","Break","Reset","Stop","Menu","User","Sys","Print","ClrLn","ClrDsp","InsLn","DelLn","InsChr","DelChr","Prev","Next","Select","Exec","Undo","Redo","Find","Help","ModeSw"];}
		]);
		return Keyboard;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-6-23 下午2:33:23
	*/
	//class laya.editor.core.Wraps.MenuManager
	var MenuManager=(function(){
		function MenuManager(){}
		__class(MenuManager,'laya.editor.core.Wraps.MenuManager');
		MenuManager.showMenu=function(menuStr,thisO,fun){
			var tMenu;
			if(!MenuManager._menuDic[menuStr]){
				tMenu=ContextMenu1.createMenuByArray2(menuStr.split(","));
				MenuManager._menuDic[menuStr]=tMenu;
			}
			tMenu=MenuManager._menuDic[menuStr];
			tMenu.offAll("select");
			tMenu.once("select",thisO,fun);
			tMenu.show();
		}

		MenuManager._menuDic={};
		return MenuManager;
	})()


	//class laya.editor.core.Wraps.xml.XMLElement
	var XMLElement=(function(){
		function XMLElement(value){
			this._nodeName=null;
			this._nodeType=null;
			this._nodeValue=null;
			this._parentNode=null;
			this._attributes=[];
			this._childNodes=[];
			this._nestCount=0;
			if((value instanceof laya.editor.core.Wraps.xml.XMLElement )){return value}
				else if ((value instanceof laya.editor.core.Wraps.xml.XMLElementList )){if (value.lengths()==1){return value[0]}else {return value;}}
			if (value){
				if(value && value['_data_']){value=value.toString();}
					if (value){
					XMLElement.create(value,this);
				}
			}
		}

		__class(XMLElement,'laya.editor.core.Wraps.xml.XMLElement');
		var __proto=XMLElement.prototype;
		Laya.imps(__proto,{"laya.editor.core.Wraps.xml.IXMLElement":true})
		__proto.addNamespace=function(ns){
			return this;
		}

		/**同xml.@name=value*/
		__proto.setAttribute=function(name,value){
			var o;
			for(var $each_o in this._attributes){
				o=this._attributes[$each_o];
				if (o.key==name){
					o.val=value;
					return value;
				}
			}
			this._attributes.push({key:name,val:value});
			return value;
		}

		/**同xml.attributes()*/
		__proto.getAttributes=function(){
			return this.getAttribute("*");
		}

		/**同xml.attributes()*/
		__proto.attributes=function(){
			return this.getAttribute("*");
		}

		/**同xml.@name*/
		__proto.getAttribute=function(name){
			var attributes=this._attributes;
			var arr=[];
			for (var j=0;j < attributes.length;j++){
				var value=attributes[j]['key'];
				if (name=="*" || value==name){
					arr.push({"key":attributes[j]['key'],"val":attributes[j]['val']});
				}
			}
			if (name!="*"){
				return arr.length>0?arr[0].val:undefined;
			}
			return XMLElementList.createFromAttribute(arr);
		}

		/**同xml..@name*/
		__proto.getAllAttribute=function(name){
			var arr=[];
			this._getAllAttribute_(arr,this,name);
			return XMLElementList.createFromAttribute(arr);
		}

		__proto._getAllAttribute_=function(arr,xml,name){
			var len=xml._childNodes ? xml._childNodes.length :0;
			for (var i=0;i < len;i++){
				var node=xml._childNodes [i];
				for (var j=0;j < node._attributes.length;j++){
					var key=node._attributes[j]['key'];
					var val=node._attributes[j]['val'];
					if (name=="*"){
						arr.push({"key":key,"val":val});
						}else if (key==name){
						arr.push({"key":key,"val":val});
					}
				}
				this._getAllAttribute_(arr,node,name);
			}
		}

		/**同xml.@name*/
		__proto.attribute=function(name){
			return this.getAttribute(name);
		}

		/**同xml.name*/
		__proto.getChildByName=function(name){
			return this.child(name);
		}

		/**同xml..name*/
		__proto.getAllChildByName=function(name){
			var arr=[];
			this._getAllChildByName_(arr,this,name);
			return XMLElementList.create(arr);
		}

		__proto._getAllChildByName_=function(arr,xml,name){
			var len=xml._childNodes ? xml._childNodes.length :0;
			for (var i=0;i < len;i++){
				var node=xml._childNodes [i];
				if(name=="*"){
					arr.push(node);
					}else if (node._nodeName==name){
					arr.push(node);
				}
				this._getAllChildByName_(arr,node,name);
			}
		}

		__proto.nodeKind=function(){
			return this._nodeType;
		}

		/**同xml.(@attribute==value);或者xml.(@attribute!=value)*/
		__proto.getChildByAttribute=function(attribute,value,equal){
			(equal===void 0)&& (equal=true);
			if (attribute=="" || attribute==null)
				return null;
			if (value=="" || value==null)
				return null;
			var ar=[],len=this._childNodes ? this._childNodes.length :0;
			for (var i=0;i < len;i++){
				var n=this._childNodes [i];
				for (var j=0;j < n._attributes.length;j++){
					if (n._attributes[j]['key']==attribute){
						if (equal && n._attributes[j]['val']==value){
							ar.push(n);
							}else if (!equal && n._attributes[j]['val'] !=value){
							ar.push(n);
						}
					}
				}
			}
			return XMLElementList.create(ar);
		}

		/**xml.children()*/
		__proto.children=function(){
			var l=XMLElementList.create(this._childNodes);
			if(!l.length)
				if((typeof this._nodeValue=='string')&& this._nodeValue !=""){
				l.push(this._nodeValue);
			}
			return l;
		}

		/**xml[0];same with XMLElementList,different in with XMLElement;
		*In Flash XML class xml[0] return self,xml[1] return undefined;
		**/
		__proto.getChildAt=function(index){
			if (!this._childNodes || index > this._childNodes.length)
				return null;
			return this._childNodes[index];
		}

		/**同xml.element(*)*/
		__proto.elements=function(name){
			(name===void 0)&& (name="*");
			if (name=='*')
				return XMLElementList.create(this._childNodes);
			return this.child(name);
		}

		/**同xml.appendchild(value)*/
		__proto.appendChild=function(value){
			if ((typeof value=='string')){
				value=laya.editor.core.Wraps.xml.XMLElement.create(String(value));
			}
			if ((value instanceof laya.editor.core.Wraps.xml.XMLElement )){
				var name=value._nodeName;
				var list=this[name];
				if (!list){
					this[name]=list=new XMLElementList();
				}
				(((typeof list=='function'))!=true)&&(list.__addChild__(value));
				this._childNodes.push(value);
				}else if ((value instanceof laya.editor.core.Wraps.xml.XMLElementList )){
				var len=value.lengths();
				for (var i=0;i < len;i++){
					this.appendChild(value[i]);
				}
			}
			value._parentNode=this;
			return value;
		}

		__proto.prependChild=function(value){
			var xml=this.appendChild(value);
			var nodes=this._childNodes;
			nodes.pop();
			nodes.splice(0,0,xml);
			return xml;
		}

		/**同xml.name=value*/
		__proto.setChildByName=function(nName,value){
			var c=this.getChildByName(nName);
			if (!c)
				return null;
			var spliceIndex=this._childNodes.length;
			for (var i=this._childNodes.length-1;i >=0;i--){
				if (this._childNodes[i].localName==nName){
					this._childNodes.splice(i,1);
					spliceIndex=i;
				}
			}
			if ((value instanceof laya.editor.core.Wraps.xml.XMLElementList )){
				for (i=0;i < value.lengths();i++){
					this._childNodes.splice(spliceIndex,0,value[i]);
					spliceIndex++;
				}
				}else if ((value instanceof laya.editor.core.Wraps.xml.XMLElement )){
				this._childNodes.splice(spliceIndex,0,value);
				}else {
				return null;
			}
			return c;
		}

		/**同xml.copy()*/
		__proto.copy=function(){
			var xml=new XMLElement(this.toXMLString());
			return xml;
		}

		__proto.copyFrom=function(source){
			if ((source instanceof laya.editor.core.Wraps.xml.XMLElement )){
				var value=source;
				this._nodeName=value._nodeName;
				this._nodeValue=value._nodeValue;
				this._attributes=value._attributes;
				this._childNodes=value._childNodes;
				return this;
			}
			return null;
		}

		/**同xml.setName(name)*/
		__proto.setName=function(str){
			this._nodeName=str;
		}

		/**同xml.hasOwnProperty(p)*/
		__proto.hasOwnProperty=function(pName){
			var len=0,i=0;
			if(pName.indexOf("@")!=-1){
				var tmpPName=pName.substring(1);
				len=this._attributes.length;
				for (i=0;i < len;i++){
					if (this._attributes[i].key==tmpPName)
						return true;
				}
				}else{
				len=this._childNodes.length;
				for (i=0;i < len;i++){
					if (this._childNodes[i]._nodeName==pName)
						return true;
				}
			}
			return false;
		}

		/**同xml.hasSimpleContent()*/
		__proto.hasSimpleContent=function(){
			if (this._childNodes.length > 0){
				return false;
				}else if (this._childNodes.length==1){
				if (!this._childNodes[0].localName)
					return true;
				return false;
			}
			return true;
		}

		/**同xml.hasComplexContent()*/
		__proto.hasComplexContent=function(){
			return this._childNodes.length > 0
		}

		/**同xml.length()*/
		__proto.lengths=function(){
			return 1
		}

		/**同xml.name()*/
		__proto.name=function(){
			return this._nodeName;
		}

		/**同xml.parent()*/
		__proto.parent=function(){
			return this._parentNode;
		}

		/**同xml.toString()*/
		__proto.toString=function(){
			var str="";
			if (this._childNodes.length){
				str=this.toXMLString();
			}else
			str=this._nodeValue;
			return str;
		}

		__proto.getString=function(){
			var str="";
			str=this.toXMLString();
			return str;
		}

		__proto.getNodeValueStr=function(){
			return this._nodeValue;
			var rst;
			rst="<![CDATA["+this._nodeValue+"]]>";
			return rst;
			return this._nodeValue;
		}

		/**同xml.toXMLString()*/
		__proto.toXMLString=function(){
			if (!XMLElement._callee)
				XMLElement._callee=this;
			var str="";
			str+=XMLElement.getStartEmpty(this._nestCount);
			if (this._nodeName){
				str+="<"+this._nodeName;
				for (var i=0;i < this._attributes.length;i++){
					str+=" "+this._attributes[i]['key']+'="'+XMLElement.getAttributeStr(this._attributes[i]['val'])+'"'
				}
			}
			if (this.hasSimpleContent()&& !this.value)
				str+="/>";
			else {
				str+=this._nodeName ? ">" :"";
				str+=(this._childNodes.length ? "\n" :this.getNodeValueStr());
				for (i=0;i < this._childNodes.length;i++){
					this._childNodes[i]._nestCount=this._nestCount+1;
					str+=this._childNodes[i].toXMLString();
					str+="\n";
				}
				if (this._nodeName)
					str+=XMLElement.getStartEmpty(this._nestCount)+"</"+this._nodeName+">";
			}
			if (XMLElement._callee !=this){
			}
			else
			XMLElement._callee=null;
			return str;
		}

		__proto.child=function(nName){
			if((typeof nName=='number')){
				return XMLElementList.create([ this._childNodes[nName]]);
			};
			var ar=[],len=this._childNodes ? this._childNodes.length :0;
			for (var i=0;i < len;i++){
				var n=this._childNodes [i];
				if (n.localName==nName){
					ar.push(n);
				}
			}
			return XMLElementList.create(ar);
		}

		__proto.childIndex=function(){
			var parent=this._parentNode;
			if (parent){
				var nodes=parent._childNodes;
				for (var i=0,n=nodes.length;i < n;i++){
					if (nodes[i]==this){
						return i;
					}
				}
			}
			return-1;
		}

		__proto.insertChildBefore=function(child1,child2){
			return null;
		}

		__proto.normalize=function(){
			return null;
		}

		__proto.comments=function(){
			return null;
		}

		__proto.contains=function(value){
			return true;
		}

		__proto.defaultSettings=function(){
			return null;
		}

		__proto.descendants=function(name){
			return null;
		}

		__proto.inScopeNamespaces=function(){
			return [];
		}

		__proto.setLocalName=function(name){
			this._nodeName=name;
		}

		__getset(0,__proto,'nodeType',function(){
			return this._nodeType;
		});

		/**同xml.toString()*/
		/**同xml.toString()*/
		__getset(0,__proto,'value',function(){
			return this._nodeValue;
			},function(str){
			this._nodeValue=str;
		});

		__getset(0,__proto,'childNodes',function(){
			return this._childNodes;
		});

		__getset(0,__proto,'nodeName',function(){
			return this._nodeName;
		});

		/**同xml.localName()*/
		__getset(0,__proto,'localName',function(){
			return this._nodeName;
			},function(str){
			this._nodeName=str;
		});

		/*微端顶级节点的value*/
		__getset(0,__proto,'conchValue',function(){
			var temp="";
			if (this._childNodes){
				for (var i=0,len=this._childNodes.length;i < len;i++){
					temp+=this._childNodes[i].conchValue;
				}
				temp+=this.value;
			}
			else
			temp=this.value;
			return temp;
		});

		XMLElement.create=function(value,node){
			node=node ? node :new XMLElement();
			var xmld;
			if (false && !((typeof value=='string'))){
				xmld=value;
				xmld=xmld.childNodes[0];
				}else {
				if (SystemSetting.isCMDVer){
					var DOMParser=require('xmldom').DOMParser;;
					}else{
					DOMParser=Browser.window.DOMParser;;
				}
				xmld=(new DOMParser()).parseFromString(value,'text/xml');var t_i=0;var t_xmld=null;do{t_xmld=xmld.childNodes[t_i++];if(t_xmld.nodeName !='#comment' ){xmld=t_xmld;break;}}while(t_i<xmld.childNodes.length);;
			}
			XMLElement.cloneXmlFromData(node,xmld);
			return node;
		}

		XMLElement.cloneXmlFromData=function(xml,data){
			xml._nodeName=data.nodeName;
			xml._nodeValue=data.nodeValue==null ? data.textContent :data.nodeValue;
			var attribs=data.attributes;
			var len=attribs ? attribs.length :0;
			var attributes=xml._attributes;
			for (var j=0;j < len;j++){
				var attr=attribs[j];
				attributes.push({key:attr.nodeName,val:attr.nodeValue});
			};
			var nodes=data.childNodes;
			var child;
			for (var i=0;i < nodes.length;i++){
				var node=nodes[i];
				var nodeName=node.nodeName;
				if(nodeName=="#text"){
					if(node.parentNode&&node.parentNode.textContent!=node.textContent){
						var tValue;
						tValue=node.nodeValue.replace(/(^\s*)|(\s*$)/g,'');
						if(tValue.length>1){
							node.nodeValue=tValue;
							child=new XMLElement();
							XMLElement.cloneXmlFromData(child,node);
							xml.appendChild(child);
						}
					}
				}else
				if (nodeName !="#text" && nodeName !="#comment"){
					if (nodeName=="#cdata-section" || nodeName==""){
						xml._nodeValue=node.nodeValue==null ? node.textContent :node.nodeValue;
						continue ;
					}
					child=new XMLElement();
					XMLElement.cloneXmlFromData(child,node);
					xml.appendChild(child);
				}
			}
		}

		XMLElement.getStartEmpty=function(count){
			var str="";
			for (var j=0;j < count;j++){
				str+="   ";
			}
			return str;
		}

		XMLElement.hasSpSigns=function(str){
			if(! (typeof str=='string'))return false;
			var i=0,len=0;
			len=XMLElement.spSigns.length;
			for(i=0;i<len;i++){
				if(str.indexOf(XMLElement.spSigns[i])>=0)return true;
			}
			return false;
		}

		XMLElement.getAttributeStr=function(val){
			if(! (typeof val=='string'))return val;
			var key;
			for(key in XMLElement.xmlSpecials){
				var sign;
				val=val.split(key).join(XMLElement.xmlSpecials[key]);
			}
			return val;
		}

		XMLElement._callee=null
		__static(XMLElement,
		['spSigns',function(){return this.spSigns=["<",">"];},'xmlSpecials',function(){return this.xmlSpecials={
				"<":"&lt;",
				">":"&gt;",
				"'":"&apos;",
				"\"":"&quot;"
		};}

		]);
		return XMLElement;
	})()


	/**全局配置*/
	//class laya.editor.LayaConfig
	var LayaConfig=(function(){
		function LayaConfig(){};
		__class(LayaConfig,'laya.editor.LayaConfig');
		LayaConfig.GAME_FPS=50;
		LayaConfig.MOVIE_INTERVAL=100;
		LayaConfig.resPath="";
		LayaConfig.uiPath="";
		LayaConfig.tipDelay=200;
		LayaConfig.tipFollowMove=true;
		LayaConfig.touchScrollEnable=true;
		LayaConfig.mouseWheelEnable=true;
		LayaConfig.VER="0.9.9 beta";
		LayaConfig.$HIDDEN="$HIDDEN";
		LayaConfig.$LOCKED="$LOCKED";
		return LayaConfig;
	})()


	/**代码管理类
	*@author yung
	*/
	//class laya.editor.manager.CodeManager
	var CodeManager=(function(){
		function CodeManager(){};
		__class(CodeManager,'laya.editor.manager.CodeManager');
		CodeManager.exportCode=function(){
			console.log("ExportCode");
			CodeManager.uiObjMap={};
			CodeManager.projectExportType=PageStyleManager.getProjectExportType();
			CodeManager.isLoadMode=PageExportType.isLoadType(CodeManager.projectExportType);
			CodeManager.isUIPackMode=CodeManager.projectExportType=="加载模式";
			CodeManager.isAs=Math.ceil(ProjectSetting.codeType)==0;
			CodeManager.initPreExportInfo();
			CodeTplManager.initCodeTpls();
			CodeManager.tPageFileInfos={};
			CodeManager.uiDataExportFolder=FileTools.getFolder(FileManager.getWorkPath(ProjectSetting.uiExportPath));
			CodeManager.createByDir(SystemSetting.pagesPath);
			if(CodeManager.isUIPackMode){
				FileManager.createJSONFile(FileManager.getWorkPath(ProjectSetting.uiExportPath),CodeManager.uiObjMap);
				CodeManager.uiObjMap={};
			}
			CodeManager.saveExportInfo();
			console.log("Export code complete");
		}

		CodeManager.initPreExportInfo=function(){
			var filePath;
			filePath=CodeManager.getPreExportFilePath();
			CodeManager.preExportInfo=null;
			CodeManager.prePageFileInfos=null;
			CodeManager.hasPreExportInfo=false;
			CodeManager.isConfigsChanged=true;
			if(!FileTools.exist(filePath))return;
			try{
				CodeManager.preExportInfo=FileManager.readJSONFile(filePath);
				CodeManager.prePageFileInfos=CodeManager.preExportInfo["files"];
				CodeManager.hasPreExportInfo=true;
				if(CodeManager.getConfigsStatuStr()==CodeManager.preExportInfo["configStr"]){
					CodeManager.isConfigsChanged=false;
				}
			}catch(e){}
		}

		CodeManager.getConfigsStatuStr=function(){
			var ctimes;
			ctimes=[];
			var i=0,len=0;
			len=CodeManager.configFiles.length;
			for(i=0;i<len;i++){
				var tFile;
				tFile=FileManager.getWorkPath("laya/"+CodeManager.configFiles[i]);
				if(FileTools.exist(tFile)){
					ctimes.push(FileTools.getMTime(tFile));
				}
			}
			return ctimes.join("_");
		}

		CodeManager.saveExportInfo=function(){
			var saveO;
			saveO={};
			saveO["configStr"]=CodeManager.getConfigsStatuStr();
			saveO["files"]=CodeManager.tPageFileInfos;
			FileManager.createJSONFile(CodeManager.getPreExportFilePath(),saveO);
			CodeManager.tPageFileInfos={};
		}

		CodeManager.getPrePageInfoO=function(pagePath){
			if(CodeManager.prePageFileInfos&&CodeManager.prePageFileInfos[pagePath]){
				return CodeManager.prePageFileInfos[pagePath];
				}else{
				return null;
			}
		}

		CodeManager.isCacheCodeOK=function(pagePath,mTime){
			if(CodeManager.isUIPackMode)return false;
			if(!CodeManager.hasPreExportInfo)return false;
			if(CodeManager.isConfigsChanged)return false;
			var pageInfo;
			pageInfo=CodeManager.getPrePageInfoO(pagePath);
			if(pageInfo){
				if(mTime==pageInfo["mTime"]&&!pageInfo["hasSpecial"]&&pageInfo["code"]){
					return true;
				}
			}
			return false;
		}

		CodeManager.getCacheCode=function(pagePath,mTime){
			if(!CodeManager.isCacheCodeOK(pagePath,mTime))return null;
			return CodeManager.getPrePageInfoO(pagePath)["code"];
		}

		CodeManager.isSpecialPageFile=function(pageTxt){
			var i=0,len=0;
			len=CodeManager.SpecialPageKeyWords.length;
			for(i=0;i<len;i++){
				if(pageTxt.indexOf(CodeManager.SpecialPageKeyWords[i])>=0){
					return true;
				}
			}
			return false;
		}

		CodeManager.getPreExportFilePath=function(){
			return FileManager.getDataPath("codeCache/"+CodeManager.getProjectSign()+"code.cache");
			return FileManager.getWorkPath("laya/code.cache");
		}

		CodeManager.getProjectSign=function(){
			var sign;
			sign=FileManager.adptToCommonUrl(SystemSetting.workPath);
			sign=SMD5.md5(sign,null,null);
			return sign;
		}

		CodeManager.getCodePath=function(pagePath){
			var page1=FileManager.getRelativePath(SystemSetting.pagesPath,pagePath);
			var page2=FileManager.getWorkPath(ProjectSetting.codeExportPath+"/"+page1);
			var newNameSign;
			switch(Math.ceil(ProjectSetting.codeType)){
				case 0:
					newNameSign="UI.as";
					break ;
				case 2:
				case 2:
					newNameSign="UI.js";
					break ;
				case 1:
					newNameSign="UI.ts";
					break ;
				};
			var i=0,len=0;
			len=CodeManager.pageFileSigns.length;
			for(i=0;i<len;i++){
				if(page2.indexOf(CodeManager.pageFileSigns[i])>=0){
					return page2.replace(CodeManager.pageFileSigns[i],newNameSign);
				}
			}
			return page2.replace(".ui",newNameSign);
		}

		CodeManager.initTsCodePre=function(){
			ObjectTools.clearObj(CodeManager.importDic);
			var arr;
			arr=ProjectSetting.codeImportsTS.split("\n");
			var preImports;
			var preCodes;
			preImports=[];
			preCodes=[];
			var i=0,len=0;
			len=arr.length;
			var tStr;
			for(i=0;i<len;i++){
				tStr=arr[i];
				if(tStr.indexOf("import")>=0){
					preImports.push(tStr);
					CodeManager.parseTsImport(tStr);
					}else{
					preCodes.push(tStr);
				}
			}
			CodeManager.tsCodePreImport=preImports.join("\n");
			CodeManager.tsCodePreFromImport=preCodes.join("\n");
		}

		CodeManager.parseTsImport=function(str){
			var tStr;
			tStr=str.replace("import","");
			var arr;
			arr=tStr.split("=");
			tStr=StringTool.trimSide(arr[0]);
			CodeManager.importDic[tStr]=true;
		}

		CodeManager.createByDir=function(file){
			var fileList;
			fileList=FileTools.getFileList(file);
			var i=0,len=0;
			len=fileList.length;
			var tFile;
			var code;
			var obj;
			var codePath;
			var resUsed;
			resUsed=[];
			var allInOneFile;
			CodeManager.initTsCodePre();
			switch(Math.ceil(ProjectSetting.codeType)){
				case 0:
					break ;
				case 2:
					CodeManager.allInOnePre=CodeTplManager.jsCodePre;
					allInOneFile=CodeManager.allInOnePre+"\n"+ProjectSetting.codeImportsJS;
					break ;
				case 1:
					CodeManager.allInOnePre=CodeTplManager.tsCodePre;
					allInOneFile=CodeManager.allInOnePre+"\n"+ProjectSetting.codeImportsTS;
					break ;
				};
			var hasCodeFile=false;
			hasCodeFile=false;
			var changeTime;
			var rPath;
			var tPageInfo;
			var isCacheOK=false;
			for(i=0;i<len;i++){
				tFile=fileList[i];
				if(FileTools.isDirectory(tFile)){
					}else{
					rPath=FileManager.getRelativePath(SystemSetting.pagesPath,tFile);
					changeTime=FileTools.getMTime(tFile).toString();
					isCacheOK=CodeManager.isCacheCodeOK(rPath,changeTime);
					if(isCacheOK&&CodeManager.isAs){
						continue ;
					}
					tPageInfo=CodeManager.getPrePageInfoO(rPath);
					if(!tPageInfo){
						tPageInfo={};
					}
					tPageInfo["mTime"]=changeTime;
					CodeManager.tPageFileInfos[rPath]=tPageInfo;
					if(TypeManager.getFileType(tFile)=="graphic_animation"){
						var tarPath;
						tarPath=FileManager.getPath(FileManager.getWorkPath(ProjectSetting.asynResExportPath),rPath);
						var tDataConfig;
						tDataConfig=FileManager.readJSONFile(tFile);
						CodeManager.cleanUIObj(tDataConfig,null);
						FileManager.createJSONFile(tarPath,tDataConfig);
					}else
					if(TypeManager.isCodeViewFile(tFile)){
						if(TypeManager.getFileType(tFile)=="Prefab"){
							if(!PageStyleManager.getIfPageExport(FileManager.getRelativePath(SystemSetting.pagesPath,tFile))){
								continue ;
							}
						}
						hasCodeFile=true;
						try{
							if(isCacheOK){
								code=CodeManager.getCacheCode(rPath,changeTime);
								}else{
								console.log("Export:",rPath);
								code=FileManager.readTxtFile(tFile);
								tPageInfo["hasSpecial"]=CodeManager.isSpecialPageFile(code);
								obj=ObjectTools.getObj(code);
								if(obj.props){
									delete obj.props["var"];
								}
								if(obj.props&&obj.props["base64pic"]==true){
									CodeManager.collectSkins(obj,resUsed);
								}
								code=CodeManager.objToUI(obj,tFile);
							}
							tPageInfo["code"]=code;
							codePath=CodeManager.getCodePath(tFile);
							if(ProjectSetting.codeType==2||ProjectSetting.codeType==1){
								allInOneFile+="\n"+code;
								}else{
								if(ProjectSetting.codeType==1){
									code=CodeTplManager.tsCodePre+"\n"+code;
								}
								FileManager.createTxtFile(codePath,code);
							}
							}catch(e){
							Alert.show(Sys.lang("读取页面({0})出错",tFile)+"\n"+e.toString(),"读取页面出错");
						}
					}else
					if(TypeManager.getFileType(tFile)=="particle"||TypeManager.getFileType(tFile)=="particle3D"||TypeManager.getFileType(tFile)=="particlepoly"){
						rPath=FileManager.getRelativePath(SystemSetting.pagesPath,tFile);
						tarPath=FileManager.getPath(FileManager.getWorkPath(ProjectSetting.asynResExportPath),rPath);
						FileTools.copyFile(tFile,tarPath);
						var tParticleConfig;
						tParticleConfig=FileManager.readJSONFile(tFile);
						var textureFile;
						if(!tParticleConfig){
							Alert.show("文件已损坏！："+tFile);
							continue ;
						}
						textureFile=tParticleConfig.textureName;
						var texturePath;
						if(textureFile){
							texturePath=FileManager.getResPath(textureFile);
							var tarTexturePath;
							tarTexturePath=FileManager.getPath(FileManager.getWorkPath(ProjectSetting.asynResExportPath),textureFile);
							FileTools.copyFile(texturePath,tarTexturePath);
						}
					}
				}
			}
			if(!hasCodeFile)return;
			CodeManager.saveBase64Pics(resUsed);
			if(ProjectSetting.codeType==2||ProjectSetting.codeType==1){
				var fileType;
				fileType=ProjectSetting.codeType==2?"js":"ts";
				codePath=CodeManager.getCodePath(FileManager.getPath(file,"layaUI.max.all."+fileType));
				FileManager.createTxtFile(codePath,allInOneFile);
				var tarFolder;
				tarFolder=codePath.replace(".ts",".js");
				if(ProjectSetting.codeType==1){
					var cmdTSC;
					cmdTSC="tsc --out \""+tarFolder+"\" \""+codePath+"\"";
				}
			}
		}

		CodeManager.collectSkins=function(uiO,resUsed){
			resUsed=TemplateManager.findAllResUsed(uiO,resUsed);
		}

		CodeManager.saveBase64Pics=function(resUsed){
			if(!resUsed||resUsed.length<1)return;
			var i=0,len=0;
			len=resUsed.length;
			var data;
			data={};
			for(i=0;i<len;i++){
				CodeManager.convertSkinRes(resUsed[i],data);
			};
			var codePath;
			codePath=FileManager.getPath(FileManager.getWorkPath(ProjectSetting.resExportPath),"base64pic.json");
			FileManager.createTxtFile(codePath,JSON.stringify(data));
			if(ProjectSetting.codeType==0){
				CodeManager.saveAsBase64Class(data);
			}
		}

		CodeManager.saveAsBase64Class=function(data){
			var tpl;
			tpl=FileManager.readTxtFile(FileManager.getAppPath(Paths.ASBase64Template));
			var codePath;
			codePath=FileManager.getWorkPath(CodeTplManager.base64path);
			var dataO;
			dataO={};
			dataO["pack"]=CodeTplManager.base64pack;
			dataO["base64data"]=JSON.stringify(data);
			var code;
			code=CodeManager.createExportCode(tpl,dataO);
			FileManager.createTxtFile(codePath,code);
		}

		CodeManager.convertSkinRes=function(skinPath,data){
			var tex;
			var tPath;
			var i=0,len=0;
			len=CodeManager.specialFiles.length;
			for(i=0;i<len;i++){
				tPath=StringTool.getReplace(skinPath,".png",CodeManager.specialFiles[i]);
				if(!data[tPath]&&ResFileManager.hasRes(tPath)){
					tex=ResFileManager.getRes(tPath);
					if(tex){
						data[tPath]=Base64ImageTool.getBase64Pic(tex);
					}
				}
			}
		}

		CodeManager.getSkinSpecialRes=function(skinPath,arr){
			var tex;
			var tPath;
			var i=0,len=0;
			len=CodeManager.specialFiles.length;
			for(i=0;i<len;i++){
				tPath=StringTool.getReplace(skinPath,".png",CodeManager.specialFiles[i]);
				if(tPath==skinPath)continue ;
				if(ResFileManager.hasRes(tPath)){
					arr.push(tPath);
				}
			}
		}

		CodeManager.getReferStr=function(myPack,tarClass){
			var rst;
			var myArr;
			var tarArr;
			myArr=myPack.split(".");
			tarArr=tarClass.split(".");
			while(myArr.length&&tarArr.length&&myArr[0]==tarArr[0]){
				myArr.shift();
				tarArr.shift();
			};
			var i=0,len=0;
			len=myArr.length;
			for(i=0;i<len;i++){
				myArr[i]="../";
			}
			if(myArr.length>0){
				rst=myArr.join("")+tarArr.join("/");
				}else{
				rst=tarArr.join("/");
			}
			rst=rst+".ts";
			rst="///<reference path=\""+rst+"\" />";
			return rst;
		}

		CodeManager.objToUI=function(obj,pagePath){
			var isPreset=false;
			var className=FileManager.getFileName(pagePath)+"UI";
			var pack=CodeManager.getPackage(pagePath);
			var uiXml=ObjectTools.copyObjFast(obj);
			var viewMap={};
			isPreset=TypeManager.isPreFabNodeType(obj.type);
			CodeManager.parseUIobj(uiXml,viewMap);
			var imports="";
			var temp=[];
			for (var key in viewMap){
				temp.push({name:key,lib:viewMap[key]});
			}
			temp.sort(MathUtil.sortByKey("name"));
			var viewClassMap="";
			var preRefers="";
			var obj1;
			for(var $each_obj1 in temp){
				obj1=temp[$each_obj1];
				var lib=obj1.lib;
				var libName=lib.substring(lib.lastIndexOf(".")+1,lib.length);
				var regName;
				if(obj1.lib==obj1.name&&CodeManager.getRunClass(obj1.name)){
					lib=CodeManager.getRunClass(obj1.name);
					libName=lib.substring(lib.lastIndexOf(".")+1,lib.length);
					regName=obj1.name;
					}else{
					regName=lib;
				}
				if(ProjectSetting.codeType==0){
					imports+="	import "+lib+";\n";
					viewClassMap+="			View.regComponent(\""+regName+"\","+libName+");\n";
					}else{
					imports+="	import "+libName+" = "+lib+";\n";
					viewClassMap+="			View.regComponent(\""+regName+"\","+lib+");\n";
					preRefers+="\n"+CodeManager.getReferStr(pack,lib);
				}
			};
			var str="";
			var baseName=obj.type;
			var uiObj;
			uiObj=ObjectTools.copyObjFast(uiXml);
			var needCompIdNode;
			needCompIdNode=AnimationDataWorker.getAnimationedNode(uiObj);
			CodeManager.cleanUIObj(uiObj,needCompIdNode);
			if(!CodeManager.isViewHasAnimation(uiObj)){
				delete uiObj.animations;
			};
			var uiPath;
			var pageLink;
			uiPath=pack+"."+className;
			uiPath=FileManager.getRelativePath(SystemSetting.pagesPath,pagePath);
			pageLink=uiPath=FileManager.adptToCommonUrl(uiPath);
			uiPath=uiPath.split(".")[0];
			var classObj;
			classObj={};
			classObj["className"]=className;
			classObj["classType"]=baseName;
			if(ProjectSetting.codeType==1){
				classObj["classType"]=CodeManager.getFullClassPath(baseName);
			}
			classObj["pack"]=pack;
			classObj["viewClassMap"]=viewClassMap;
			classObj["uiObj"]=JSON.stringify(uiObj);
			classObj["uiPath"]=uiPath;
			var pageExportType;
			pageExportType=PageStyleManager.getPageFinalExportType(pageLink);
			switch(pageExportType){
				case "内嵌模式":
					break ;
				case "分离模式":
					FileManager.createJSONFile(FileManager.getPath(CodeManager.uiDataExportFolder,uiPath+".json"),uiObj);
					break ;
				case "加载模式":
					CodeManager.uiObjMap[uiPath]=ObjectTools.copyObjFast(uiObj);
					break ;
				}
			switch(Math.ceil(ProjectSetting.codeType)){
				case 0:
					classObj["vars"]=CodeManager.createVarByObj(uiXml,viewMap);
					break ;
				case 2:
				case 2:
					classObj["vars"]=CodeManager.createJSVarByObj(uiXml,viewMap);
					break ;
				case 1:
					classObj["vars"]=CodeManager.createTSVarByObj(uiXml,viewMap);
					break ;
				}
			if(ProjectSetting.codeType==0){
				classObj["imports"]=CodeManager.prefixStr(ProjectSetting.codeImports,"	")+"\n"+imports;
				}else{
				classObj["imports"]=CodeManager.prefixStr(CodeManager.tsCodePreImport,"	")+"\n"+imports;
				classObj["importsPre"]=CodeManager.tsCodePreFromImport+"\n"+preRefers;
				classObj["imports"]=CodeManager.prefixStr("","	")+imports;
				classObj["importsPre"]="";
			};
			var tplStr;
			tplStr=CodeTplManager.getCodeTpl(ProjectSetting.codeType,isPreset,PageExportType.isLoadType(pageExportType));
			str=CodeManager.createExportCode(tplStr,classObj);
			return str;
		}

		CodeManager.createExportCode=function(tplStr,data){
			var rst;
			var key;
			rst=tplStr;
			for(key in data){
				rst=StringTool.getReplace(rst,"{!"+key+"!}",data[key]);
			}
			return rst;
		}

		CodeManager.cleanUIObj=function(node,compIdNeedDic){
			var tkey;
			var childs;
			var i=0,len=0;
			if(!node.child)node.child=[];
			childs=node.child;
			len=childs.length;
			var type;
			type=node.type;
			var skinLabel;
			skinLabel=UIConfigManager.getCompSkinLabel(type);
			if(node.props&&node.props[skinLabel]){
				var skinStr;
				skinStr=node.props[skinLabel];
				if(skinStr.indexOf("~")>=0){
					delete node.props[skinLabel];
				}
			}
			for(i=0;i<len;i++){
				CodeManager.cleanUIObj(childs[i],compIdNeedDic);
			}
			for(tkey in node){
				if(!CodeManager.keysNeeded.hasOwnProperty(tkey)){
					delete node[tkey];
				}
			};
			var props;
			props=node.props;
			if(props){
				for(tkey in CodeManager.propkeysRemove){
					delete props[tkey];
				}
			}
			if(node.compId&&compIdNeedDic&&!compIdNeedDic[node.compId]){
				delete node.compId;
			}
			if(childs.length<1){
				delete node.child;
			}
			if(!CodeManager.isViewHasAnimation(node)){
				delete node.animations;
			}
		}

		CodeManager.createJSVarByObj=function(obj,viewMap){
			var arr=[];
			CodeManager.parseVarByObj(obj,arr);
			var str="";
			for(var i=0;i<arr.length;i++){
				var a=arr[i];
				var compType=a[1];
				if(viewMap[compType]==null){
					str+="		    this."+a[0]+"=null;\n";
					}else{
					var lib=viewMap[compType];
					var libName=lib.substring(lib.lastIndexOf(".")+1,lib.length);
					str+="		    this."+a[0]+"=null;\n";
				}
			}
			return str;
		}

		CodeManager.createVarByObj=function(obj,viewMap){
			var arr=[];
			CodeManager.parseVarByObj(obj,arr);
			var str="";
			for(var i=0;i<arr.length;i++){
				var a=arr[i];
				var compType=a[1];
				if(viewMap[compType]==null){
					str+="		public var "+a[0]+":"+compType+";\n";
					}else{
					var lib=viewMap[compType];
					var libName=lib.substring(lib.lastIndexOf(".")+1,lib.length);
					str+="		public var "+a[0]+":"+libName+";\n";
				}
			}
			return str;
		}

		CodeManager.createTSVarByObj=function(obj,viewMap){
			var arr=[];
			CodeManager.parseVarByObj(obj,arr);
			var str="";
			for(var i=0;i<arr.length;i++){
				var a=arr[i];
				var compType=a[1];
				if(viewMap[compType]==null){
					str+="		public "+a[0]+":"+CodeManager.getFullClassPath(compType)+";\n";
					}else{
					var lib=viewMap[compType];
					if(CodeManager.getRunClass(lib)){
						lib=CodeManager.getRunClass(lib);
					};
					var libName=lib.substring(lib.lastIndexOf(".")+1,lib.length);
					str+="		public "+a[0]+":"+lib+";\n";
				}
			}
			return str;
		}

		CodeManager.getFullClassPath=function(className){
			var runClass;
			runClass=UIConfigManager.getCompProp(className,"runClass");
			if(CodeManager.importDic[className]){
				return className;
			}
			if(!runClass)runClass="Laya."+className;
			return runClass;
		}

		CodeManager.getRunClass=function(className){
			if(CodeManager.importDic[className]){
				return null;
			};
			var runClass;
			runClass=UIConfigManager.getCompProp(className,"runClass");
			return runClass;
		}

		CodeManager.cleanNodeAnimations=function(node){
			if(!CodeManager.isViewHasAnimation(node)){
				delete node.animations;
			}
		}

		CodeManager.isViewHasAnimation=function(obj){
			if(obj.animations){
				var i=0,len=0;
				var animations;
				animations=obj.animations;
				len=animations.length;
				for(i=0;i<len;i++){
					if(animations[i].nodes&&animations[i].nodes.length>0)
						return true;
				}
			}
			return false;
		}

		CodeManager.parseVarByObj=function(obj,arr){
			if(obj.animations){
				var i=0,len=0;
				var animations;
				animations=obj.animations;
				len=animations.length;
				for(i=0;i<len;i++){
					if(animations[i].nodes&&animations[i].nodes.length>0)
						arr.push([String(animations[i].name),"FrameClip"]);
				}
			}
			if(obj.props["var"]){
				arr.push([String(obj.props["var"]),obj.props.runtime?String(obj.props.runtime):obj.type]);
			};
			var list=obj.child;
			if(list)
				for (var j=0,n=list.length;j < n;j++){
				CodeManager.parseVarByObj(list[j],arr);
			}
		}

		CodeManager.prefixStr=function(str,prefix){
			var arr=str.split("\n");
			for (var i=0,n=arr.length;i < n;i++){
				arr[i]=prefix+arr[i];
			}
			return arr.join("\n");
		}

		CodeManager.getPackage=function(path){
			if (path==null)
				return null;
			path=FileManager.getRelativePath(SystemSetting.pagesPath,path);
			path=FileManager.adptToCommonUrl(path);
			path=path.substring(0,path.lastIndexOf("\/")).replace(/\//g,".");
			var uiPath=ProjectSetting.codeExportPath;
			uiPath=FileManager.adptToCommonUrl(uiPath);
			if(uiPath.charAt(uiPath.length-1)!="\/"){
				uiPath=uiPath+"\/";
			};
			var startIndex=uiPath.indexOf("src/")>-1?(uiPath.indexOf("src/")+4):(uiPath.indexOf("/")+1);
			uiPath=uiPath.substring(startIndex,uiPath.length-1).replace(/\//g,".");
			var pack=uiPath+(path!=""?"."+path:"");
			return pack;
		}

		CodeManager.parseUIobj=function(obj,viewMap){
			var compType=obj.type;
			compType=StringTool.trimSide(compType);
			obj.type=compType;
			var runtime;
			var prefabO;
			prefabO=PreFabManager.I.getPreFabByNode(obj);
			if (compType !="View" && compType !="Dialog"){
				if (compType !="UIView"){
					var skinLabel=""
					skinLabel=UIConfigManager.getCompProp(compType,"skinLabel");
					skinLabel=skinLabel || "styleSkin";
					var skin=obj.props[skinLabel]||obj.props["skin"];
					if(prefabO&&prefabO.props&&prefabO.props[skinLabel]){
						skin=prefabO.props[skinLabel];
					}
					if (Boolean(skin)){
						var defaultProps=ResStyleManager.getPropArr(skin);
						CodeManager.setObjDefaultValue(obj,defaultProps);
					}
					}else {
					var sourcePath=obj.source;
					if (Boolean(sourcePath)){
						defaultProps=ResStyleManager.getPropArrByPropStr(PageStyleManager.getPageProps(sourcePath));
						CodeManager.setObjDefaultValue(obj,defaultProps);
					}
				}
			}
			if(prefabO&&obj.props&&prefabO.props){
				PreFabManager.insertValues(obj.props,prefabO.props,obj.props);
			}
			AppendPropGroupTool.insertAppendProps(obj);
			AppendPropGroupTool.adptScriptNode(obj);
			PreFabManager.I.clearPreFabProps(obj);
			if (compType=="UIView"){
				var source=obj.source;
				source=FileManager.getPath(SystemSetting.pagesPath,source);
				var viewName=FileManager.getFileName(source);
				obj.type=viewName;
				runtime=obj.props.runtime;
				if(!runtime){
					runtime=obj.props.runtime=CodeManager.getPackage(source)+"."+viewName+"UI";
				}
				viewMap[runtime]=runtime;
				}else{
				runtime=obj.props.runtime;
				if(runtime){
					viewMap[runtime]=runtime;
					}else{
					var runClass;
					runClass=CodeManager.getRunClass(compType);
					if(runClass){
						viewMap[compType]=compType;
					}
				}
			}
			delete obj.props.layers;
			delete obj.props.layer;
			delete obj.props.sceneWidth;
			delete obj.props.sceneHeight;
			delete obj.props.sceneColor;
			delete obj.props.sceneBg;
			delete obj.props.styleSkin;
			var list=obj.child;
			if(list)
				for (var j=0,n=list.length;j < n;j++){
				CodeManager.parseUIobj(list[j],viewMap);
			}
			CodeManager.cleanNodeAnimations(obj);
		}

		CodeManager.setObjDefaultValue=function(obj,props){
			var prop;
			for(var $each_prop in props){
				prop=props[$each_prop];
				var a=prop.split("=");
				if (a.length==2){
					var key=a[0];
					var val=a[1];
					if (!obj.props.hasOwnProperty(key)){
						obj.props[key]=ObjectTools.getAutoValue(val);
					}
				}
			}
		}

		CodeManager.isLoadMode=false;
		CodeManager.isAs=false;
		CodeManager.uiObjMap=null
		CodeManager.projectExportType=null
		CodeManager.isUIPackMode=false;
		CodeManager.uiDataExportFolder=null
		CodeManager.hasPreExportInfo=false;
		CodeManager.isConfigsChanged=false;
		CodeManager.preExportInfo=null
		CodeManager.prePageFileInfos=null
		CodeManager.tPageFileInfos=null
		CodeManager.ChangeTimeSign="mTime";
		CodeManager.HasSpecialSign="hasSpecial";
		CodeManager.ExportCodeSign="code";
		CodeManager.CodeType_AS=0;
		CodeManager.CodeType_JS=2;
		CodeManager.CodeType_JSInOne=2;
		CodeManager.CodeType_TS=1;
		CodeManager.tsCodePreFromImport=null
		CodeManager.tsCodePreImport=null
		CodeManager.allInOnePre="";
		CodeManager.importDic={};
		__static(CodeManager,
		['configFiles',function(){return this.configFiles=[".laya","pageStyles.xml","styles.xml"];},'SpecialPageKeyWords',function(){return this.SpecialPageKeyWords=
			[
			"preset",
			"UIView",
			"Script",
			"appendProps"];},'pageFileSigns',function(){return this.pageFileSigns=
			[
			".ani",
			".scene",
			".prefabui",
			".prefab",
			".gani",
			".ui"];},'specialFiles',function(){return this.specialFiles=[".png","$down.png","$bar.png","$up.png"];},'keysNeeded',function(){return this.keysNeeded={
				"type":true,
				"props":true,
				"child":true,
				"compId":true,
				"animations":true
				};},'propkeysRemove',function(){return this.propkeysRemove={
				"appendProps":true,
				"preset":true,
				"presetID":true,
				"presetPre":true,
				"presetIDPre":true
		};}

		]);
		return CodeManager;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-10-21 下午4:03:09
	*/
	//class laya.editor.manager.CodeTplManager
	var CodeTplManager=(function(){
		function CodeTplManager(){}
		__class(CodeTplManager,'laya.editor.manager.CodeTplManager');
		CodeTplManager.init=function(type){
			(type===void 0)&& (type="");
			CodeTplManager.jsCodeTpl=FileManager.readTxtFile(FileManager.getAppPath(Paths.JSCodeTemplate+type));
			CodeTplManager.jsCodeTplPst=FileManager.readTxtFile(FileManager.getAppPath(Paths.JSCodeTemplate+".preset"));
			CodeTplManager.jsCodePre=FileManager.readTxtFile(FileManager.getAppPath(Paths.JSCodePreTemplate));
			CodeTplManager.tsCodeTpl=FileManager.readTxtFile(FileManager.getAppPath(Paths.TSCodeTemplate+type));
			CodeTplManager.tsCodeTplPst=FileManager.readTxtFile(FileManager.getAppPath(Paths.TSCodeTemplate+".preset"));
			CodeTplManager.tsCodePre=FileManager.readTxtFile(FileManager.getAppPath(Paths.TSCodePreTemplate));
			CodeTplManager.asCodeTpl=FileManager.readTxtFile(FileManager.getAppPath(Paths.ASCodeTemplate+type));
			CodeTplManager.asCodeTplPst=FileManager.readTxtFile(FileManager.getAppPath(Paths.ASCodeTemplate+".preset"));
			CodeTplManager.parsePublishConfig();
		}

		CodeTplManager.recordCodeTpls=function(sign){
			var tData;
			if(!CodeTplManager.codeTplsDic[sign]){
				CodeTplManager.codeTplsDic[sign]={};
			}
			tData=CodeTplManager.codeTplsDic[sign];
			var i=0,len=0;
			len=CodeTplManager._codeTplsNames.length;
			var tKey;
			for(i=0;i<len;i++){
				tKey=CodeTplManager._codeTplsNames[i];
				tData[tKey]=CodeTplManager[tKey];
			}
		}

		CodeTplManager.setCodeTpls=function(sign){
			var tData;
			tData=CodeTplManager.codeTplsDic[sign];
			var i=0,len=0;
			len=CodeTplManager._codeTplsNames.length;
			var tKey;
			for(i=0;i<len;i++){
				tKey=CodeTplManager._codeTplsNames[i];
				CodeTplManager[tKey]=tData[tKey];
			}
		}

		CodeTplManager.initCodeTpls=function(){
			CodeTplManager.initCodeTplsByLoadMode(false);
			CodeTplManager.recordCodeTpls("NoLoad");
			CodeTplManager.initCodeTplsByLoadMode(true);
			CodeTplManager.recordCodeTpls("Load");
		}

		CodeTplManager.getCodeTpl=function(codeType,isPreset,isLoad){
			if(isLoad){
				CodeTplManager.setCodeTpls("Load");
				}else{
				CodeTplManager.setCodeTpls("NoLoad");
			};
			var tplStr;
			codeType=Math.ceil(codeType);
			switch(codeType){
				case 0:
					tplStr=CodeTplManager.asCodeTpl;
					if(isPreset){
						tplStr=CodeTplManager.asCodeTplPst;
					}
					break ;
				case 2:
				case 2:
					tplStr=CodeTplManager.jsCodeTpl;
					if(isPreset){
						tplStr=CodeTplManager.jsCodeTplPst;
					}
					break ;
				case 1:
					tplStr=CodeTplManager.tsCodeTpl;
					if(isPreset){
						tplStr=CodeTplManager.tsCodeTplPst;
					}
					break ;
				}
			return tplStr;
		}

		CodeTplManager.initCodeTplsByLoadMode=function(isLoadMode){
			if(isLoadMode){
				CodeTplManager.codeModeType=".load";
				CodeTplManager.init(".load");
				}else{
				CodeTplManager.codeModeType="";
				CodeTplManager.init();
			}
			CodeTplManager.parsePublishConfig();
		}

		CodeTplManager.parsePublishConfig=function(){
			var buildConfigPath;
			buildConfigPath=FileManager.getWorkPath("laya/build.cfg");
			if(!FileTools.exist(buildConfigPath)){
				CodeTplManager.setDefaultBuildAction();
				}else{
				try{
					var config;
					config=FileManager.readJSONFile(buildConfigPath);
					if(config.codemode=="2"){
						CodeTplManager.asCodeTpl=FileManager.readTxtFile(FileManager.getAppPath(Paths.ASCodeTemplate2));
						}else{
						CodeTplManager.asCodeTpl=FileManager.readTxtFile(FileManager.getAppPath(Paths.ASCodeTemplate+CodeTplManager.codeModeType));
					}
					CodeTplManager.base64path=config["base64path"];
					CodeTplManager.base64pack=config["base64pack"];
					}catch(e){
					CodeTplManager.setDefaultBuildAction();
				}
			}
		}

		CodeTplManager.setDefaultBuildAction=function(){
			CodeTplManager.asCodeTpl=FileManager.readTxtFile(FileManager.getAppPath(Paths.ASCodeTemplate+CodeTplManager.codeModeType));
			CodeTplManager.base64path="src/data/Base64AtlasManager.as";
			CodeTplManager.base64pack="data";
		}

		CodeTplManager.jsCodeTpl="";
		CodeTplManager.jsCodeTplPst="";
		CodeTplManager.jsCodePre="";
		CodeTplManager.tsCodeTpl="";
		CodeTplManager.tsCodeTplPst="";
		CodeTplManager.tsCodePre="";
		CodeTplManager.asCodeTpl="";
		CodeTplManager.asCodeTplPst="";
		CodeTplManager.codeTplsDic={};
		CodeTplManager.codeModeType=null
		CodeTplManager.base64path="src/data/Base64AtlasManager.as";
		CodeTplManager.base64pack="data";
		__static(CodeTplManager,
		['_codeTplsNames',function(){return this._codeTplsNames=[
			"jsCodeTpl",
			"jsCodeTplPst",
			"jsCodePre",
			"tsCodeTpl",
			"tsCodeTplPst",
			"tsCodePre",
			"asCodeTpl",
			"asCodeTplPst"];}
		]);
		return CodeTplManager;
	})()


	/**导出管理器
	*@author yung
	*/
	//class laya.editor.manager.ExportManager
	var ExportManager=(function(){
		function ExportManager(){};
		__class(ExportManager,'laya.editor.manager.ExportManager');
		ExportManager.init=function(){
			Notice1.listen("Release_Project",null,ExportManager.release);
		}

		ExportManager.release=function(){
			ExportManager.clear();
			ExportManager.export(true);
		}

		ExportManager.forceExport=function(){
			ExportManager.clear();
			ExportManager.export(false,null,true);
		}

		ExportManager.clear=function(){
			ExportManager.clearRes=true;
			FileManager.removeFile(CodeManager.getPreExportFilePath());
			var uiCodePath=FileManager.getWorkPath(ProjectSetting.codeExportPath);
			FileManager.removeFile(uiCodePath);
			FileManager.createDirectory(uiCodePath);
		}

		ExportManager.export=function(release,complete,force){
			(release===void 0)&& (release=false);
			(force===void 0)&& (force=false);
			ExportManager.clearRes=force||ExportManager.configChanged;
			laya.editor.manager.ExportManager.complete=complete;
			if (UIPanel.instance.hasChange){
				Confirm.show("在发布代码之前，有页面还未保存，是否保存然后发布？","有页面未保存",ExportManager.confirmBack,[release]);
				}else {
				ExportManager.doExport(release);
			}
		}

		ExportManager.confirmBack=function(release,sure,type){
			if (sure){
				UIPanel.instance.saveAll();
			}
			if(type!="close")
				ExportManager.doExport(release);
		}

		ExportManager.packingEndHandler=function(err,stdOut,stdErr){
			console.log("err:",err);
			if (ExportManager.isCmdVer){
				if (ExportManager._packingEndHandler !=null){
					ExportManager._packingEndHandler(err,stdOut,stdErr);
				}
				return;
			}
			Waiting.hide();
			MessageManager.instance.show("发布成功");
			if(Browser.window["changeViewCode"]){
				Browser.window["changeViewCode"]();
			}
			if(SystemSetting.toCodeModeWhenPublicEnd){
				Laya.timer.once(1000,null,ExportManager.switchToCodeMode);
			}
		}

		ExportManager.switchToCodeMode=function(){
			if(Browser.window["changeLayaIDECodeMode"]){
				Browser.window["changeLayaIDECodeMode"]();
			}
		}

		ExportManager.getSkipRes=function(){
			return ExportManager.getRessStr(ResStyleManager.getPackFilesByType(2));
		}

		ExportManager.getWhitePackList=function(){
			return ExportManager.getRessStr(ResStyleManager.getPackFilesByType(1));
		}

		ExportManager.getRepeatList=function(){
			return ExportManager.getRessStr(ResStyleManager.getPicTypeFilesByType(1));
		}

		ExportManager.getRessStr=function(resList){
			var strs;
			strs=[];
			var i=0,len=0;
			var tPath;
			var addStrs=[];
			len=resList.length;
			for(i=0;i<len;i++){
				tPath=FileManager.getPath(SystemSetting.assetsPath,resList[i]);
				if(FileTools.exist(tPath)){
					strs.push(tPath);
				}
				CodeManager.getSkinSpecialRes(resList[i],addStrs);
			}
			len=addStrs.length;
			for(i=0;i<len;i++){
				tPath=FileManager.getPath(SystemSetting.assetsPath,addStrs[i]);
				if(FileTools.exist(tPath)){
					strs.push(tPath);
				}
			}
			return strs.join(",");
		}

		ExportManager.adptCallPath=function(filePath){
			if(!filePath)return filePath;
			var lastStr;
			lastStr=filePath.charAt(filePath.length-1);
			if(lastStr=="/"||lastStr=="\\"){
				return filePath.substr(0,filePath.length-1);
			}
			return filePath;
		}

		ExportManager.doExport=function(release){
			Waiting.show("发布中，请稍等。。","发布代码");
			Laya.timer.frameOnce(2,null,ExportManager.doExportLater,[release]);
		}

		ExportManager.getNewParamList=function(str){
			if(str=="")return [];
			return str.split(",");
		}

		ExportManager.doExportLater=function(release,exportUICode,exportRes){
			(exportUICode===void 0)&& (exportUICode=true);
			(exportRes===void 0)&& (exportRes=true);
			if (exportRes){
				ExportManager.exportResWork(release);
			}
			if(exportUICode){
				ExportManager.exportUICodeWork();
			}
			if(!exportRes){
				ExportManager.packingEndHandler("export end");
			}
			ExportManager.configChanged=false;
		}

		ExportManager.exportUICodeWork=function(){
			FileManager.createDirectory(FileManager.getWorkPath(ProjectSetting.codeExportPath));
			CodeManager.exportCode();
		}

		ExportManager.exportResWork=function(release){
			var blackList=ExportManager.getSkipRes();
			var whilteList=ExportManager.getWhitePackList();
			var repeatList=ExportManager.getRepeatList();
			if(release)blackList=blackList.concat(ResManager.getUnUserdList());
			var allNotPacks;
			allNotPacks=ResFileManager.getAllUnPackLinkList(null);
			var notPackDirs;
			notPackDirs=ResStyleManager.getAllUnPackDir();
			allNotPacks=allNotPacks.concat(notPackDirs);
			var notPackFilePath;
			notPackFilePath=FileManager.getWorkPath(ExportManager.adptCallPath(ProjectSetting.asynResExportPath)+"/unpack.json");
			FileManager.createJSONFile(notPackFilePath,allNotPacks);
			var oldPathPackPath="libs/TP/TileAtlasPacker";
			var newPathPackPath="libs/TP/AtlasGenerator";
			if (SystemSetting.isCMDVer){
				oldPathPackPath=oldPathPackPath.replace("libs/","");
				newPathPackPath=newPathPackPath.replace("libs/","");
			};
			var cmd="\""+FileManager.getAppPath(oldPathPackPath)+"\""+
			" -maxAltasWidth="+ProjectSetting.textureWidth+" -maxAltasHeight="+ProjectSetting.textureHeight+
			" -tileWidthLimit="+ProjectSetting.picWidth+" -tileHeightLimit="+ProjectSetting.picHeight+
			" "+"\""+ExportManager.adptCallPath(SystemSetting.assetsPath)+"\""+
			" -outputDir="+"\""+ExportManager.adptCallPath(FileManager.getWorkPath(ProjectSetting.resExportPath))+"\"";
			if(ExportManager.clearRes){
				cmd+=" -force=true";
			}
			if(ProjectSetting.power2=="true"){
				cmd+=" -powerOfTwo=true";
			}
			if(ProjectSetting.trimempty=="true"){
				cmd+=" -trim=true";
				}else{
				cmd+=" -trim=false";
			}
			cmd+=" -htmlDir="+"\""+ExportManager.adptCallPath(FileManager.getWorkPath(ProjectSetting.asynResExportPath))+"\"";
			cmd+=" -blackList="+"\""+blackList+"\"";
			cmd+=" -inflateList="+"\""+repeatList+"\"";
			cmd+=" -includeList="+"\""+whilteList+"\"";
			var packFilePath=Paths.getPackParamFile();
			var packObj;
			packObj={};
			packObj["inputDir"]=ExportManager.adptCallPath(SystemSetting.assetsPath);
			packObj["outputDir"]=ExportManager.adptCallPath(FileManager.getWorkPath(ProjectSetting.resExportPath));
			packObj["resDir"]=ExportManager.adptCallPath(FileManager.getWorkPath(ProjectSetting.asynResExportPath));
			packObj["force"]=ExportManager.clearRes;
			packObj["includeList"]=ExportManager.getNewParamList(whilteList);
			packObj["excludeList"]=ExportManager.getNewParamList(blackList);
			packObj["extrudeList"]=ExportManager.getNewParamList(repeatList);
			var atlas;
			atlas={};
			atlas["width"]=ProjectSetting.textureWidth;
			atlas["height"]=ProjectSetting.textureHeight;
			atlas["powerOfTwo"]=ProjectSetting.power2=="true";
			console.log("picType:",ProjectSetting.picType);
			atlas["textureFormat"]=ProjectSetting.picType==0?"png32":"png8";
			packObj["atlas"]=atlas;
			var spriteConfig;
			spriteConfig={};
			spriteConfig["width"]=ProjectSetting.picWidth;
			spriteConfig["height"]=ProjectSetting.picHeight;
			spriteConfig["cropAlpha"]=ProjectSetting.trimempty=="true";
			packObj["sprite"]=spriteConfig;
			FileManager.createJSONFile(packFilePath,packObj);
			var option;
			option={encoding:"binary",maxBuffer:1024*1024*20};;
			option.cwd=FileManager.getAppPath(newPathPackPath).replace("AtlasGenerator","");
			var newCmd;
			newCmd="AtlasGenerator --config "+"\""+ExportManager.adptCallPath(packFilePath)+"\"";
			cmd=newCmd;
			console.log("Waiting for pics packing");
			FileManager.createDirectory(FileManager.getWorkPath(ProjectSetting.resExportPath));
			CMDShell.execute(cmd,function(err,stdOut,stdErr){
				ExportManager.packingEndHandler(err,stdOut,stdErr);
			},option);
		}

		ExportManager.swfMap=null
		ExportManager.createSwfQueue=null
		ExportManager.fileUnUsed={};
		ExportManager.complete=null
		ExportManager.clearRes=false;
		ExportManager.configChanged=false;
		ExportManager.isCmdVer=false;
		ExportManager._packingEndHandler=null
		ExportManager.powerOfTwo=false;
		return ExportManager;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-12-25 上午10:19:18
	*/
	//class laya.editor.manager.LayerManager
	var LayerManager=(function(){
		function LayerManager(){}
		__class(LayerManager,'laya.editor.manager.LayerManager');
		LayerManager.init=function(){
			LayerManager.stage=new Box();
			LayerManager.stage.mouseEnabled=true;
			Laya.stage.addChild(LayerManager.stage);
			Laya.stage.on("resize",null,LayerManager.onStage);
		}

		LayerManager.onStage=function(){
			if (Browser.pixelRatio > 1){
				Laya.stage._width=Browser.clientWidth;
				Laya.stage._height=Browser.clientHeight;
				Laya.stage.scale(Browser.pixelRatio,Browser.pixelRatio);
			}
			LayerManager.stage.width=Laya.stage._width>900?Laya.stage._width:900;
			LayerManager.stage.height=Laya.stage._height>700?Laya.stage._height:700;
		}

		LayerManager.stage=null
		LayerManager.minWidth=900;
		LayerManager.minHeight=700;
		return LayerManager;
	})()


	/**页面管理器
	*@author yung
	*/
	//class laya.editor.manager.PageManager
	var PageManager=(function(){
		function PageManager(){}
		__class(PageManager,'laya.editor.manager.PageManager');
		PageManager.copyPageBg=function(pagePath,bgImgPath){
			if (!FileTools.exist(bgImgPath)){
				return bgImgPath;
			}
			if (Boolean(bgImgPath)){
				var file=new File(bgImgPath);
				if (file.exists){
					var f=FileTools.path.sep;
					var newPath=pagePath.replace("laya"+f+"pages"+f,"laya"+f+"views"+f).replace(".ui","."+file.extension);
					FileManager.copyFile(bgImgPath,newPath);
					return FileManager.getWorkRelativePath(newPath);
				}
			}
			return "";
		}

		PageManager.find=function(word){
			var pages=FileManager.getFileList(FileManager.getWorkPath("laya/pages/"));
			var arr=[];
			var a;
			for(var $each_a in pages){
				a=pages[$each_a];
				var path=a;
				if(FileTools.isDirectory(path))continue ;
				var txt=FileManager.readTxtFile(path);
				if(txt.indexOf(word)!=-1){
					arr.push({label:FileManager.getRelativePath(SystemSetting.pagesPath,path),path:path});
				}
			}
			return arr;
		}

		PageManager.replace=function(oldWord,newWord){
			Waiting.instance.start("替换中,请等待。。","替换中");
			var pages=FileManager.getFileList(FileManager.getWorkPath("laya/pages/"));
			pages=pages.concat(PreFabManager.getPrefabFiles());
			var arr=[];
			var a;
			for(var $each_a in pages){
				a=pages[$each_a];
				var path=a;
				if(FileTools.isDirectory(path))continue ;
				var uiViewer=UIPanel.instance.getUIViewer(path);
				oldWord.lastIndex=0;
				if (uiViewer){
					try{
						var txt=JsonTool.getJsonString(uiViewer.getDesignData());
						if(oldWord.test(txt)){
							txt=txt.replace(oldWord,newWord);
							uiViewer.changeDataO(ObjectTools.getObj(txt));
							arr.push(path);
						}
						}catch(e){
						Alert.show("替换文件失败："+path);
					}
					}else{
					txt=FileManager.readTxtFile(path);
					if(oldWord.test(txt)){
						txt=txt.replace(oldWord,newWord);
						FileManager.createTxtFile(path,txt);
						arr.push({label:FileManager.getRelativePath(SystemSetting.pagesPath,path),path:path});
					}
				}
			}
			Waiting.instance.close();
			return arr;
		}

		return PageManager;
	})()


	/**页面样式管理器
	*@author yung
	*/
	//class laya.editor.manager.PageStyleManager
	var PageStyleManager=(function(){
		function PageStyleManager(){};
		__class(PageStyleManager,'laya.editor.manager.PageStyleManager');
		PageStyleManager.init=function(){
			var txt=FileManager.readTxtFile(SystemSetting.pageStylePath);
			try {
				PageStyleManager.styleXML=new XMLElement(Boolean(txt)? txt :"<?xml version=\"1.0\" encoding=\"UTF-8\"?><page></page>");
				}catch (e){
				Alert.show(Sys.lang("PageStyleManager 读取文件{0}出错",SystemSetting.stylePath),"读取文件出错");
			}
			if (PageStyleManager.styleXML){
				PageStyleManager.styleMap={};
				var list=PageStyleManager.styleXML.children();
				var item;
				for(var $each_item in list){
					item=list[$each_item];
					PageStyleManager.styleMap[String(item.getAttribute('name'))]=item;
				}
			}
		}

		PageStyleManager.getPageProps=function(name){
			if (PageStyleManager.styleMap&&PageStyleManager.styleMap[name]){
				return String(PageStyleManager.styleMap[name].getAttribute('props'));
			}
			return "";
		}

		PageStyleManager.getIfPageExport=function(name){
			var pagetype;
			pagetype=TypeManager.getFileType(name);
			if(pagetype=="Prefab"){
				return PageStyleManager.getPageExportType(name)=="导出";
				}else{
				return true;
			}
		}

		PageStyleManager.getPageExportType=function(name){
			var rst;
			if(PageStyleManager.styleMap&&PageStyleManager.styleMap[name]){
				rst=PageStyleManager.styleMap[name].getAttribute('ifExport');
			}
			if(!rst)rst="默认";
			if(PageExportType.isOKType(rst)){
				return rst;
			}
			return "默认";
		}

		PageStyleManager.getPageFinalExportType=function(name){
			var type;
			type=PageStyleManager.getPageExportType(name);
			if(type!="默认")return type;
			return PageStyleManager.getProjectExportType();
		}

		PageStyleManager.getProjectExportType=function(){
			var id=0;
			id=Math.ceil(ProjectSetting.uiType);
			if(id>=0&&id<=2){
				return PageExportType.typeList[id];
			}
			return "内嵌模式";
		}

		PageStyleManager.updatePageStyle=function(name,props,ifExport){
			(ifExport===void 0)&& (ifExport="默认");
			props=ResStyleManager.getPropStrByArr(props.split("\n"));
			if (PageStyleManager.styleMap&&PageStyleManager.styleMap[name]){
				PageStyleManager.styleMap[name].setAttribute('props',props);
				PageStyleManager.styleMap[name].setAttribute('ifExport',ifExport);
				}else {
				var xml=new XMLElement("<item name=\""+name+"\"/>");
				xml.setAttribute('props',props);
				PageStyleManager.styleXML.appendChild(xml);
				PageStyleManager.styleMap[name]=xml;
				PageStyleManager.styleMap[name].setAttribute('ifExport',ifExport);
			}
			FileManager.createTxtFile(SystemSetting.pageStylePath,PageStyleManager.styleXML.toString());
		}

		PageStyleManager.styleXML=null
		PageStyleManager.styleMap=null
		return PageStyleManager;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-9-1 上午10:09:44
	*/
	//class laya.editor.manager.PreFabManager
	var PreFabManager=(function(){
		function PreFabManager(){
			this.preFabDic={};
		}

		__class(PreFabManager,'laya.editor.manager.PreFabManager');
		var __proto=PreFabManager.prototype;
		__proto.getPreFabData=function(preFabPath){
			var filePath;
			filePath=FileManager.getWorkPath(preFabPath);
			if(!FileTools.exist(filePath))return null;
			var rst;
			try{
				rst=FileManager.readJSONFile(filePath);
				this.preFabDic[preFabPath]=TreeDataTool.buildNode(rst,null,"presetID",true);
			}catch(e){}
			return rst;
		}

		__proto.cleanPrefabCache=function(){
			var key;
			for(key in this.preFabDic){
				delete this.preFabDic[key];
			}
		}

		__proto.prefabFileChange=function(path){
			var rPath;
			rPath=FileManager.getWorkRelativePath(path);
			if(this.preFabDic[rPath]){
				this.preFabDic[rPath]=null;
				Notice1.notify("FRESH_Page",[false]);
			}
		}

		__proto.getPreFabProps=function(preFabPath,preSetID){
			if(!preFabPath||!preSetID)return null;
			var filePath;
			filePath=FileManager.getWorkPath(preFabPath);
			if(!FileTools.exist(filePath))return null;
			if(this.preFabDic[preFabPath])return this.preFabDic[preFabPath][preSetID];
			var data;
			data=this.getPreFabData(preFabPath);
			if(this.preFabDic[preFabPath])return this.preFabDic[preFabPath][preSetID];
			return null;
		}

		__proto.clearPreFabProps=function(node){
			TreeDataTool.deleteNodePropKeyBut(node,PreFabManager.reserveKeys,false);
		}

		__proto.convertDataToPreFabUI=function(data,dir){
			var savePath;
			savePath=this.findOkFileName(data.type,dir,TypeManager.getExtension("page"));
			var preSetSign;
			preSetSign=FileManager.getWorkRelativePath(savePath);
			var saveO;
			saveO=ObjectTools.copyObj(data);
			if(!saveO.props)saveO.props={};
			saveO.props.x=0;
			saveO.props.y=0;
			TreeDataTool.deleteNodeKey(saveO,"compId");
			var prefabO;
			if(PreFabManager.PrefabHasWrap){
				prefabO={};
				prefabO.type="View";
				prefabO.child=[saveO];
				prefabO.props={};
				prefabO.props.width=300;
				prefabO.props.height=300;
				prefabO.props.sceneColor="#000000";
				}else{
				prefabO=saveO;
			}
			FileManager.createJSONFile(savePath,prefabO);
		}

		__proto.convertDataToPreFab=function(data,dir){
			var savePath;
			savePath=this.findOkFileName(data.type,dir);
			var preSetSign;
			preSetSign=FileManager.getWorkRelativePath(savePath);
			if(preSetSign!=data.props["preset"]){
				TreeDataTool.changeNodeKey(data,"preset","presetPre");
				TreeDataTool.changeNodeKey(data,"presetID","presetIDPre");
			}
			TreeDataTool.setNodeKey(data,"preset",preSetSign);
			TreeDataTool.resetNodeID(data,"presetID",1);
			var saveO;
			saveO=ObjectTools.copyObj(data);
			if(!saveO.props)saveO.props={};
			saveO.props.x=0;
			saveO.props.y=0;
			TreeDataTool.deleteNodeKey(saveO,"compId");
			var prefabO;
			if(PreFabManager.PrefabHasWrap){
				prefabO={};
				prefabO.type="View";
				prefabO.child=[saveO];
				prefabO.props={};
				prefabO.props.width=300;
				prefabO.props.height=300;
				prefabO.props.sceneColor="#000000";
				}else{
				prefabO=saveO;
			};
			var preX=0,preY=0;
			preX=data.props.x;
			preY=data.props.y;
			TreeDataTool.deleteAllKeyBut(data,PreFabManager.reserveKeysS);
			if(preX){
				data.props.x=preX;
			}
			if(preY){
				data.props.y=preY;
			}
			FileManager.createJSONFile(savePath,prefabO);
			Notice1.notify("Prop_Changed");
		}

		__proto.isNodeHasPreFab=function(node){
			if(!node)return false;
			var props;
			props=node.props;
			if(!props)return false;
			if(!props["preset"]||!props["presetID"])return false;
			return true;
		}

		__proto.cutOffNodePrefab=function(node,preset){
			if(!this.isNodeHasPreFab(node))return;
			var props;
			props=node.props;
			if(!props)return;
			preset=props["preset"];
			if(preset&&(preset!=props["preset"]))return;
			this.insertPrefabToProps(node);
			delete props["preset"];
			delete props["presetID"];
			delete props["presetPre"];
			delete props["presetIDPre"];
		}

		__proto.cutOffNodeTreePrefab=function(node,preset){
			if(!this.isNodeHasPreFab(node))return;
			var props;
			props=node.props;
			if(!props["preset"]||!props["presetID"])return;
			if(preset&&(preset!=props["preset"]))return;
			preset=props["preset"];
			this.cutOffNodePrefab(node,preset);
			var childs;
			childs=node.child;
			if(!childs)return;
			var i=0,len=0;
			len=childs.length;
			for(i=0;i<len;i++){
				this.cutOffNodeTreePrefab(childs[i],preset);
			}
		}

		__proto.getPreFabPreByNode=function(node){
			if(!node)return null;
			var props;
			props=node.props;
			if(!props)return null;
			var preData;
			preData=this.getPreFabProps(props["preset"],props["presetID"]);
			if(!preData)return null;
			var rst;
			rst={};
			props=preData.props;
			var prepreData;
			if(props){
				prepreData=this.getPreFabPreByNode(this.getPreFabProps(props["presetPre"],props["presetIDPre"]));
				if(prepreData&&prepreData.props){
					PreFabManager.insertValues(PreFabManager.mMask,prepreData.props,rst);
				}
			}
			if(preData&&preData.props){
				PreFabManager.insertValues(PreFabManager.mMask,preData.props,rst);
			};
			var rstNode;
			rstNode={};
			rstNode.props=rst;
			return rstNode;
		}

		__proto.getPreFabByNode=function(node){
			return this.getPreFabPreByNode(node);
			var props;
			props=node.props;
			if(!props)return null;
			var preFabProps;
			preFabProps=this.getPreFabProps(props["preset"],props["presetID"]);
			return preFabProps;
		}

		__proto.getPreFabUIPropByNode=function(node){
			if(!TypeManager.isPrefabUINode(node))return null;
			var source=node.source;
			var sourcePath;
			var xml;
			try{
				sourcePath=FileManager.getPath(SystemSetting.pagesPath,source.replace(".xml","."+TypeManager.getExtension("page")));
				xml=FileManager.readJSONFile(sourcePath);
				if(PreFabManager.PrefabHasWrap)return xml.child[0];
				return xml;
				return xml.child[0];
				}catch(e){
			};
			return null;
		}

		// }
		__proto.getPrefabUIPropByKey=function(node,key){
			var propNode;
			propNode=this.getPreFabUIPropByNode(node);
			if(!propNode)return null;
			return propNode.props[key];
		}

		__proto.getPreFabPropByKey=function(node,key){
			var preFabProps;
			preFabProps=this.getPreFabByNode(node);
			if(!preFabProps||!preFabProps.props)return null;
			return preFabProps.props[key];
		}

		__proto.insertPrefabVar=function(data,comp){
			var props;
			props=data.props;
			if(!props)return;
			var preFabProps;
			preFabProps=this.getPreFabByNode(data);
			if(!preFabProps||!preFabProps.props)return;
			preFabProps=preFabProps.props;
			PreFabManager.insertValues(props,preFabProps,comp);
		}

		// }
		__proto.insertPrefabToProps=function(node){
			var props;
			props=node.props;
			if(!props)return;
			var preFabProps;
			preFabProps=this.getPreFabByNode(node);
			if(!preFabProps||!preFabProps.props)return;
			preFabProps=preFabProps.props;
			PreFabManager.insertValues(props,preFabProps,props);
		}

		__proto.findOkFileName=function(preSign,dir,fileSign){
			(fileSign===void 0)&& (fileSign="prefab");
			var pDir;
			pDir=dir;
			var id=1;
			var tPath
			while(true){
				tPath=FileManager.getPath(pDir,preSign+""+id+"."+fileSign);
				if(!FileTools.exist(tPath)){
					break ;
				}
				id++;
			}
			return tPath;
		}

		PreFabManager.insertValues=function(oData,insertData,tar){
			var key;
			for(key in insertData){
				if(!oData.hasOwnProperty(key)){
					tar[key]=insertData[key];
				}
			}
		}

		PreFabManager.getPrefabFiles=function(){
			var pages=FileManager.getFileList(SystemSetting.assetsPath);
			var rst;
			rst=[];
			var i=0,len=0;
			len=pages.length;
			for(i=0;i<len;i++){
				if(TypeManager.getFileType(pages[i])=="Prefab"){
					rst.push(pages[i]);
				}
			}
			return rst;
		}

		PreFabManager.PrefabHasWrap=false;
		PreFabManager.mMask={};
		__static(PreFabManager,
		['I',function(){return this.I=new PreFabManager();},'reserveKeys',function(){return this.reserveKeys={
				"preset":true,
				"presetID":true
				};},'reserveKeysS',function(){return this.reserveKeysS={
				"preset":true,
				"presetID":true,
				"presetPre":true,
				"presetIDPre":true
		};}

		]);
		return PreFabManager;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-1-20 下午5:52:11
	*/
	//class laya.editor.manager.ProjectConvertManager
	var ProjectConvertManager=(function(){
		function ProjectConvertManager(){}
		__class(ProjectConvertManager,'laya.editor.manager.ProjectConvertManager');
		ProjectConvertManager.convertProject=function(oPath,tarPath){
			var oBasePath;
			oBasePath=FileTools.getFileDir(oPath);
			ProjectConvertManager.parseConvertConfig(FileTools.getPath(oBasePath,"convert.cfg"));
			var relativePath;
			relativePath=FileManager.getRelativePath(oBasePath,oPath);
			var tarProjectFile;
			tarProjectFile=FileManager.getPath(tarPath,ProjectConvertManager.getNewProjectRelativePath(relativePath));
			FileManager.copyFile(oPath,tarProjectFile);
			var pagesFolder;
			pagesFolder=FileManager.getPath(oBasePath,"morn/pages");
			var tFile;
			tFile=FileManager.getPath(oBasePath,"morn/assets");
			ProjectConvertManager.copyFileToTarFolder(tFile,oBasePath,tarPath);
			tFile=FileManager.getPath(oBasePath,"morn/styles.xml");
			ProjectConvertManager.copyFileToTarFolder(tFile,oBasePath,tarPath,true);
			tFile=FileManager.getPath(oBasePath,"morn/pageStyles.xml");
			ProjectConvertManager.copyFileToTarFolder(tFile,oBasePath,tarPath,true);
			ProjectConvertManager.createByDir(pagesFolder,oBasePath,tarPath);
			MessageManager.instance.show("转换成功");
		}

		ProjectConvertManager.parseConvertConfig=function(configPath){
			ProjectConvertManager.adptSizeGrid=true;
			var configStr;
			configStr=FileTools.readFile(configPath);
			if(!configStr)return;
			var configs;
			configs=configStr.split("\n");
			var i=0,len=0;
			len=configs.length;
			var tLine;
			var configO={};
			var param;
			for(i=0;i<len;i++){
				tLine=StringTool.trimSide(configs[i]);
				if(tLine.indexOf("=")>0){
					param=tLine.split("=");
					configO[param[0]]=param[1];
				}
			}
			if(configO.hasOwnProperty("sizeGrid")){
				ProjectConvertManager.adptSizeGrid=!(configO["sizeGrid"]=="false");
			}
		}

		ProjectConvertManager.getNewProjectRelativePath=function(path){
			return path.replace("morn","laya");
		}

		ProjectConvertManager.copyFileToTarFolder=function(file,oBase,tarFolder,adpt){
			(adpt===void 0)&& (adpt=false);
			if(!FileTools.exist(file))return;
			var tarFilePath;
			var tarFolderS;
			tarFolderS=ProjectConvertManager.getNewProjectRelativePath(FileManager.getRelativePath(oBase,file));
			tarFilePath=FileManager.getPath(tarFolder,tarFolderS);
			FileManager.copyFile(file,tarFilePath);
			if(adpt){
				ProjectConvertManager.adaptStyleXML(tarFilePath);
			}
		}

		ProjectConvertManager.adptXmlProps=function(str){
			if(StringTool.trimSide(str)=="")return str;
			var obj;
			obj=ResStyleManager.getResPropsObjByPropStr(str,"\n");
			ProjectConvertManager.adptObj(obj);
			str=ResStyleManager.getResPropStrByObj(obj," ");
			return str;
		}

		ProjectConvertManager.adaptStyleXML=function(path){
			var str;
			str=FileManager.readTxtFile(path);
			var styleXML;
			try {
				styleXML=new XMLElement(str);
			}catch (e){}
			if (styleXML){
				var list=styleXML.children();
				var item;
				for(var $each_item in list){
					item=list[$each_item];
					item.setAttribute('name',ProjectConvertManager.getAdptSkin(item.getAttribute('name')));
					if(item.getAttribute('props')){
						item.setAttribute('props',ProjectConvertManager.adptXmlProps(item.getAttribute('props')));
					}
				}
			}
			FileManager.createTxtFile(path,styleXML.toString());
			return;
			var arr;
			arr=str.split("\"");
			var i=0,len=0;
			len=arr.length;
			for(i=0;i<len;i++){
				arr[i]=ProjectConvertManager.getAdptSkin(arr[i]);
			}
			FileManager.createTxtFile(path,arr.join("\""));
		}

		ProjectConvertManager.createByDir=function(file,basePath,tarPath){
			var fileList;
			fileList=FileTools.getFileList(file);
			var i=0,len=0;
			len=fileList.length;
			var tFile;
			var code;
			var obj;
			var codePath;
			for(i=0;i<len;i++){
				tFile=fileList[i];
				if(FileTools.isDirectory(tFile)){
					}else{
					if(FileTools.getExtensionName(tFile)==ProjectConvertManager.oldUIExtension){
						code=FileManager.readTxtFile(tFile);
						var uiObj;
						try{
							uiObj=DesignInfo.xmlStrToUIObj(code);
							ProjectConvertManager.adptObj(uiObj);
							var tarFilePath;
							tarFilePath=FileManager.getPath(tarPath,ProjectConvertManager.getNewProjectRelativePath(FileManager.getRelativePath(basePath,tFile)));
							tarFilePath=tarFilePath.replace("."+ProjectConvertManager.oldUIExtension,"."+TypeManager.getExtension("page"));
							FileManager.createJSONFile(tarFilePath,uiObj);
							}catch(e){
							Alert.show("转换文件失败：\n"+tFile);
						}
					}
				}
			}
		}

		ProjectConvertManager.getAdptSizeGrid=function(sizeGridStr){
			if(!ProjectConvertManager.adptSizeGrid)return sizeGridStr;
			sizeGridStr=sizeGridStr+"";
			var arr;
			arr=sizeGridStr.split(",");
			arr.push(arr.shift());
			return arr.join(",");
		}

		ProjectConvertManager.adptObj=function(obj){
			ProjectConvertManager.adptType(obj);
			var key;
			if(obj.hasOwnProperty("scale")){
				obj["scaleX"]=obj["scaleY"]=obj["scale"];
				delete obj["scale"];
			}
			if(obj.hasOwnProperty("compId")){
				delete obj["compId"];
			}
			if(obj.hasOwnProperty("sizeGrid")){
				obj["sizeGrid"]=ProjectConvertManager.getAdptSizeGrid(obj["sizeGrid"]);
			}
			for(key in obj){
				if(obj[key]==0&&key.toLocaleLowerCase().indexOf("color")>=0){
					obj[key]="0x000000";
				}
				if((typeof (obj[key])=='string')){
					var tStr;
					tStr=obj[key];
					if(tStr.indexOf("0x")>=0){
						tStr=StringTool.getReplace(tStr,"0x","#");
						obj[key]=tStr;
					}
					if(key=="skin"||1){
						obj[key]=ProjectConvertManager.getAdptSkin(tStr);
					}
				}else
				if((typeof (obj[key])=='object')){
					ProjectConvertManager.adptObj(obj[key]);
				}
			}
		}

		ProjectConvertManager.adptType=function(obj){
			if(obj.type=="Label"&&obj.props){
				var prop;
				prop=obj.props;
				if(prop.size){
					prop.fontSize=prop.size;
					delete prop["size"];
				}
			}
			if(ProjectConvertManager.typeConvertO[obj.type]){
				obj.type=ProjectConvertManager.typeConvertO[obj.type];
			}
			if(obj.url&&!obj.skin){
				obj.skin=obj.url;
			}
		}

		ProjectConvertManager.getAdptSkin=function(skin){
			var rst;
			if(skin.indexOf(".")<0)return skin;
			if(skin.indexOf("png.")<0&&skin.indexOf("jpg.")<0)return skin;
			var arr;
			arr=skin.split(".");
			if(arr.length<3)return skin;
			var extension;
			extension=arr.shift();
			rst=arr.join("/")+"."+extension;
			return rst;
		}

		ProjectConvertManager.oldUIExtension="xml";
		ProjectConvertManager.adptSizeGrid=true;
		__static(ProjectConvertManager,
		['typeConvertO',function(){return this.typeConvertO={
				"LinkButton":"Button",
				"Container":"Box",
				"FrameClip":"Box",
				"RadioButton":"Radio"
		};}

		]);
		return ProjectConvertManager;
	})()


	//class laya.editor.manager.ProjectManager
	var ProjectManager=(function(){
		function ProjectManager(){};
		__class(ProjectManager,'laya.editor.manager.ProjectManager');
		ProjectManager.loadProject=function(path,complete,fromCMD){
			(fromCMD===void 0)&& (fromCMD=false);
			console.log("loadProject:",path);
			if (Boolean(path)){
				if (ProjectManager.lastProjectPath !=path){
					ProjectManager.lastProjectPath=path;
					if (FileTools.exist(path)){
						ResManager.clear();
						SystemSetting.setProject(path);
						ProjectSetting.asynResExportPath="";
						ProjectManager.xml=new XMLElement(FileManager.readTxtFile(path,true));
						var list=ProjectManager.xml.children();
						ProjectSetting.disableBinaryPic=0;
						var child;
						for(var $each_child in list){
							child=list[$each_child];
							var name=child.name();
							if (ProjectSetting[name] !=null){
								ProjectSetting[name]=((ProjectSetting[name])instanceof Array)? StringTool.trimSide(String(child)).split(","):String(child);
								if(ProjectSetting[name].replace)
									ProjectSetting[name]=ProjectSetting[name].replace(/\\/g,FileTools.path.sep);
							}
						}
						if(ProjectSetting.disableBinaryPic==1){
							ResFileManager.enableBinaryPic=false;
							}else{
							ResFileManager.enableBinaryPic=true;
						}
						ProjectSetting.adptPaths();
						if (fromCMD)return;
						ProjectManager.refreshProject(complete);
						ProjectManager.addProjectOpened(path);
						RenderManager.I.setRenderPropByFont(ProjectSetting.defaultFont);
						LanguageManager.loadProjectLanguageFile();
					}
					else{
						Alert.show("项目不存在");
						ProjectManager.lastProjectPath="";
						ProjectManager.removeProjectOpened(path);
					}
				}
				return;
			}
			if (complete !=null){
				complete.run();
			}
		}

		ProjectManager.refreshProject=function(complete){
			ResStyleManager.init();
			PageStyleManager.init();
			PagePanel.instance.init(SystemSetting.pagesPath);
			ResPanel.instance.init(SystemSetting.assetsPath,complete);
		}

		ProjectManager.saveProject=function(){
			ProjectSetting.adptPaths();
			var i=0,len=0;
			var tKey;
			len=ProjectManager.keys.length;
			var tXml;
			for(i=0;i<len;i++){
				tKey=ProjectManager.keys[i];
				tXml=new XMLElement();
				tXml.setName(tKey);
				if(ProjectManager.SpecialXmlKeys[tKey]){
					tXml.value="<![CDATA["+ProjectSetting[tKey]+"]]>";
					}else{
					tXml.value=ProjectSetting[tKey];
				}
				ProjectManager.xml.setChildByName(tKey,tXml);
			}
			tXml=new XMLElement();
			tXml.setName("ver");
			tXml.value="0.9.9 beta";
			ProjectManager.xml.setChildByName("ver",tXml);
			FileManager.createTxtFile(SystemSetting.projectPath,ProjectManager.xml.toString());
		}

		ProjectManager.openProject=function(){
			DialogTools.showOpenFile("打开项目",ProjectManager.onFileSelect,DialogTools.getOpenProO());
		}

		ProjectManager.onFileSelect=function(files){
			if (!files || !files[0])
				return;
			ProjectManager.openProjectByPath(files[0]);
		}

		ProjectManager.openProjectDir=function(){
			if (Boolean(SystemSetting.workPath)){
				var file=new File(SystemSetting.workPath);
				if (file.exists){
					FileTools.openItem(SystemSetting.workPath);
				}
			}
		}

		ProjectManager.openProjectByPath=function(path){
			Dialog.manager.closeAll();
			UIPanel.instance.closeAll(ProjectManager.loadProject,[path]);
		}

		ProjectManager.setProjectOpened=function(projects){
			ProjectManager.projectOpened.length=0;
			if (!projects)return;
			var len=projects.length;
			for (var i=0;i < len;i++){
				ProjectManager.projectOpened.push(projects[i]);
			}
			MenuBar.instance.showProjectOpened(ProjectManager.projectOpened);
		}

		ProjectManager.addProjectOpened=function(path){
			var index=ProjectManager.projectOpened.indexOf(path);
			if (index !=-1){
				ProjectManager.projectOpened.splice(index,1);
			}
			ProjectManager.projectOpened.splice(0,0,path);
			MenuBar.instance.showProjectOpened(ProjectManager.projectOpened);
		}

		ProjectManager.removeProjectOpened=function(path){
			var index=ProjectManager.projectOpened.indexOf(path);
			if (index !=-1){
				ProjectManager.projectOpened.splice(index,1);
				MenuBar.instance.showProjectOpened(ProjectManager.projectOpened);
			}
		}

		ProjectManager.xml=null
		ProjectManager.lastProjectPath=null
		ProjectManager.projectOpened=[];
		__static(ProjectManager,
		['keys',function(){return this.keys=
			[
			"resTypes",
			"resExportPath",
			"asynResExportPath",
			"resCanCompress",
			"resPublishQuality",
			"codeExportPath",
			"uiType",
			"codeType",
			"codeType",
			"defaultFont",
			"uiExportPath",
			"boxTypes",
			"pageTypes",
			"pageTypes",
			"codeImports",
			"codeImportsJS",
			"codeImportsTS",
			"shareResPath",
			"langPath",
			"textureWidth",
			"textureHeight",
			"picWidth",
			"picHeight",
			"power2",
			"trimempty"];},'SpecialXmlKeys',function(){return this.SpecialXmlKeys={
				"codeImports":true,
				"codeImportsJS":true,
				"codeImportsTS":true
		};}

		]);
		return ProjectManager;
	})()


	/**资源管理器
	*@author yung
	*/
	//class laya.editor.manager.ResManager
	var ResManager=(function(){
		function ResManager(){};
		__class(ResManager,'laya.editor.manager.ResManager');
		ResManager.refresh=function(complete){
			ResManager._complete=complete;
			ResManager._reses=[];
		}

		ResManager.clear=function(){
			ResManager._resVerMap={};
		}

		ResManager.removeRes=function(path){
			FileManager.removeFile(path);
			ResFileManager.clearRes(path);
		}

		ResManager.getResLinkName=function(f){
			var rootPath=SystemSetting.assetsPath;
			if (Boolean(ProjectSetting.shareResPath)){
				var sharePath=FileManager.getWorkPath(ProjectSetting.shareResPath);
				if (f.indexOf(sharePath)>-1){
					rootPath=sharePath;
				}
			}
			if(TypeManager.getFileType(f)=="Prefab"){
				rootPath=SystemSetting.workPath;
			}
			return FileManager.getRelativePath(rootPath,f).toString();
		}

		ResManager.findUnUsed=function(){
			var reses;
			reses=ResFileManager.getAllResLinkList();
			var pages=FileManager.getFileList(FileManager.getWorkPath("laya/pages/"));
			var i=0,len=0;
			var a;
			for(var $each_a in pages){
				a=pages[$each_a];
				var path=a;
				if(FileTools.isDirectory(path))continue ;
				var txt=FileManager.readTxtFile(path);
				for (i=reses.length-1;i >-1;i--){
					var item=reses[i];
					if(item.indexOf("@")>=0||item.indexOf("$")>=0){
						reses.splice(i,1);
						continue ;
					}
					if (txt.indexOf("\""+item+"\"")!=-1){
						reses.splice(i,1);
					}
				}
			};
			var rst;
			rst=[];
			len=reses.length;
			for(i=0;i<len;i++){
				rst.push({label:reses[i],path:FileManager.getResPath(reses[i])});
			}
			return rst;
		}

		ResManager.getUnUserdList=function(){
			var reses;
			reses=ResFileManager.getAllResLinkList();
			var pages=FileManager.getFileList(FileManager.getWorkPath("laya/pages/"));
			var i=0,len=0;
			var a;
			for(var $each_a in pages){
				a=pages[$each_a];
				var path=a;
				if(FileTools.isDirectory(path))continue ;
				var txt=FileManager.readTxtFile(path);
				for (i=reses.length-1;i >-1;i--){
					var item=reses[i];
					if(item.indexOf("@")>=0||item.indexOf("$")>=0){
						reses.splice(i,1);
						continue ;
					}
					if (txt.indexOf("\""+item+"\"")!=-1){
						reses.splice(i,1);
					}
				}
			}
			return reses;
		}

		ResManager.findResRefer=function(res){
			var pages=FileManager.getFileList(FileManager.getWorkPath("laya/pages/"));
			var i=0,len=0;
			var rst;
			rst=[];
			var a;
			for(var $each_a in pages){
				a=pages[$each_a];
				var path=a;
				if(FileTools.isDirectory(path))continue ;
				var txt=FileManager.readTxtFile(path);
				var item=res;
				if (txt.indexOf("\""+item+"\"")!=-1){
					rst.push({label:FileManager.getRelativePath(SystemSetting.pagesPath,path),path:path});
				}
			}
			return rst;
		}

		ResManager.findFileUnUsed=function(){
			var objs={};
			var arr=ResManager.findUnUsed();
			var obj;
			for(var $each_obj in arr){
				obj=arr[$each_obj];
				objs[obj.path]=1;
			}
			return objs;
		}

		ResManager._resVerMap={};
		ResManager._resNeedLoaded=null
		ResManager._complete=null
		ResManager._reses=null
		ResManager.timer=0;
		return ResManager;
	})()


	/**资源样式管理器
	*@author yung
	*/
	//class laya.editor.manager.ResStyleManager
	var ResStyleManager=(function(){
		function ResStyleManager(){};
		__class(ResStyleManager,'laya.editor.manager.ResStyleManager');
		ResStyleManager.init=function(){
			var txt=FileManager.readTxtFile(SystemSetting.stylePath);
			try {
				ResStyleManager.styleXML=new XMLElement(Boolean(txt)?txt:"<?xml version=\"1.0\" encoding=\"UTF-8\"?><res></res>");
				}catch (e){
				Alert.show(Sys.lang("ResStyleManager 读取文件{0}出错",SystemSetting.stylePath),"读取文件出错");
			}
			if (ResStyleManager.styleXML){
				ResStyleManager.styleMap={};
				var list=ResStyleManager.styleXML.children();
				var item;
				for(var $each_item in list){
					item=list[$each_item];
					ResStyleManager.styleMap[String(item.getAttribute('name'))]=item;
				}
			}
		}

		ResStyleManager.getResProps=function(asset){
			if(ResStyleManager.styleMap&&ResStyleManager.styleMap[asset]){
				return String(ResStyleManager.styleMap[asset].getAttribute('props'));
			}
			return "";
		}

		ResStyleManager.getPropArr=function(asset){
			return ResStyleManager.getPropArrByPropStr(ResStyleManager.getResProps(asset));
		}

		ResStyleManager.getPropStrByArr=function(arr){
			return arr.join("@@!@@");
			return arr.join(" ");
		}

		ResStyleManager.getPropArrByPropStr=function(propStr){
			if(propStr.indexOf("@@!@@")>=0){
				return propStr.split("@@!@@");
			}
			return propStr.split(" ");
		}

		ResStyleManager.getResIfPack=function(asset){
			if(ResStyleManager.styleMap&&ResStyleManager.styleMap[asset]){
				if(ResStyleManager.styleMap[asset].getAttribute('pack')===false)return false;
				return true;
				return ObjectTools.getStrTypedValue(ResStyleManager.styleMap[asset].getAttribute('pack'));
			}
			return true;
		}

		ResStyleManager.getResPicType=function(asset){
			if(ResStyleManager.styleMap&&ResStyleManager.styleMap[asset]){
				var v=0;
				v=ResStyleManager.styleMap[asset].getAttribute('picType');
				if(v==1)return 1;
				return 0;
			}
			return 0;
		}

		ResStyleManager.getResPackType=function(asset){
			if(ResStyleManager.styleMap&&ResStyleManager.styleMap[asset]){
				if(ResStyleManager.styleMap[asset].getAttribute('pack')===false)return 2;
				if(ResStyleManager.styleMap[asset].getAttribute('pack')===true)return 0;
				return LayaBuilder.mParseInt(ResStyleManager.styleMap[asset].getAttribute('pack'));
			}
			return 0;
		}

		ResStyleManager.getAllUnPackDir=function(rst){
			if(!rst)rst=[];
			if(!ResStyleManager.styleMap)return rst;
			var asset;
			for(asset in ResStyleManager.styleMap){
				if(asset.indexOf(".")<=0){
					if(ResStyleManager.getFinalPackResult(asset,true)){
						}else{
						rst.push(asset);
					}
				}
			}
			return rst;
		}

		ResStyleManager.getFinalPackResult=function(asset,otherResult){
			var type=0;
			type=ResStyleManager.getResPackType(asset);
			switch(type){
				case 0:
					return otherResult;
					break ;
				case 1:
					return true;
					break ;
				case 2:
					return false;
					break ;
				}
			return true;
		}

		ResStyleManager.getResPropsObj=function(asset){
			var propStr;
			propStr=ResStyleManager.getResProps(asset);
			var rst;
			rst={};
			if(propStr.indexOf("=")>=0){
				var props;
				props=ResStyleManager.getPropArrByPropStr(propStr);
				for (var i=0,n=props.length;i < n;i++){
					var a=props[i].split("=");
					if (a.length==2){
						var key=a[0];
						var val=a[1];
						rst[key]=val;
					}
				}
			}
			return rst;
		}

		ResStyleManager.getResPropsKeyValue=function(asset,key){
			return ResStyleManager.getResPropsObj(asset)[key];
		}

		ResStyleManager.getResPropsKeyByNode=function(node,key){
			var skinLabel=UIConfigManager.getCompSkinLabel(node.type);
			var skin;
			skin=node.props[skinLabel];
			if (skin){
				return ResStyleManager.getResPropsKeyValue(skin,key);
			}
			return null;
		}

		ResStyleManager.getResPropsObjByPropStr=function(propStr,split){
			(split===void 0)&& (split=" ");
			var rst;
			rst={};
			if(propStr.indexOf("=")>=0){
				var props;
				props=propStr.split(split);
				for (var i=0,n=props.length;i < n;i++){
					var a=props[i].split("=");
					if (a.length==2){
						var key=a[0];
						var val=a[1];
						rst[key]=val;
					}
				}
			}
			return rst;
		}

		ResStyleManager.getResPropStrByObj=function(propObj,split){
			(split===void 0)&& (split=" ");
			var rstArr;
			var key;
			rstArr=[];
			for(key in propObj){
				rstArr.push(key+"="+propObj[key]);
			}
			return rstArr.join(split);
		}

		ResStyleManager.getResCompType=function(asset,isIcon){
			(isIcon===void 0)&& (isIcon=false);
			if (!asset){
				return "Image";
			};
			var resPath;
			resPath=FileManager.adptToCommonUrl(asset);
			if (ResStyleManager.styleMap&&ResStyleManager.styleMap[resPath]){
				var compType=String(ResStyleManager.styleMap[resPath].getAttribute('type'));
			}
			if (!Boolean(compType)){
				var extension=FileTools.getExtensionName(asset);
				compType=UIConfigManager.getCompTypeByExtension(extension);
				if(compType)return compType;
				var fileName=FileTools.getFileName(asset);
				var res=fileName.split("_")[0];
				compType=UIConfigManager.getCompTypeByResName(res,isIcon);
			}
			return compType || "Image";
		}

		ResStyleManager.getResCanCompress=function(asset){
			if(ResStyleManager.styleMap&&ResStyleManager.styleMap[asset]){
				return ResStyleManager.styleMap[asset].getAttribute('compress')==1;
			}
			return ProjectSetting.resCanCompress==1;
		}

		ResStyleManager.getNotPackFiles=function(){
			var rst;
			rst=[];
			var key;
			for(key in ResStyleManager.styleMap){
				if(!ResStyleManager.getResIfPack(key)){
					rst.push(key);
				}
			}
			return rst;
		}

		ResStyleManager.getPackFilesByType=function(type){
			var rst;
			rst=[];
			var key;
			for(key in ResStyleManager.styleMap){
				if(type==ResStyleManager.getResPackType(key)){
					rst.push(key);
				}
			}
			return rst;
		}

		ResStyleManager.getPicTypeFilesByType=function(type){
			var rst;
			rst=[];
			var key;
			for(key in ResStyleManager.styleMap){
				if(type==ResStyleManager.getResPicType(key)){
					rst.push(key);
				}
			}
			return rst;
		}

		ResStyleManager.getResQuality=function(asset){
			if(ResStyleManager.styleMap&&ResStyleManager.styleMap[asset]){
				return LayaBuilder.mParseInt(ResStyleManager.styleMap[asset].getAttribute('quality'));
			}
			return ProjectSetting.resPublishQuality;
		}

		ResStyleManager.updateResStyle=function(asset,type,compress,quality,props,packType,picType){
			(packType===void 0)&& (packType=0);
			(picType===void 0)&& (picType=0);
			props=ResStyleManager.getPropStrByArr(props.split("\n"));
			if(ResStyleManager.styleMap&&ResStyleManager.styleMap[asset]){
				ResStyleManager.styleMap[asset].setAttribute('type',type);
				ResStyleManager.styleMap[asset].setAttribute('compress',compress);
				ResStyleManager.styleMap[asset].setAttribute('quality',quality);
				ResStyleManager.styleMap[asset].setAttribute('props',props);
				ResStyleManager.styleMap[asset].setAttribute('pack',packType);
				ResStyleManager.styleMap[asset].setAttribute('picType',picType);
				}else {
				var xml=new XMLElement("<item name=\""+asset+"\" type='"+type+"' compress=\""+compress+"\" pack=\""+packType+"\" quality=\""+quality+"\" />");
				ResStyleManager.styleXML.appendChild(xml);
				ResStyleManager.styleMap[asset]=xml;
				ResStyleManager.styleMap[asset].setAttribute('type',type);
				ResStyleManager.styleMap[asset].setAttribute('compress',compress);
				ResStyleManager.styleMap[asset].setAttribute('quality',quality);
				ResStyleManager.styleMap[asset].setAttribute('props',props);
				ResStyleManager.styleMap[asset].setAttribute('pack',packType);
				ResStyleManager.styleMap[asset].setAttribute('picType',picType);
			}
			FileManager.createTxtFile(SystemSetting.stylePath,ResStyleManager.styleXML.toString());
		}

		ResStyleManager.styleXML=null
		ResStyleManager.styleMap=null
		ResStyleManager.PropSplitSign="@@!@@";
		ResStyleManager.Pic_Default=0;
		ResStyleManager.Pic_Repeat=1;
		ResStyleManager.Pack_Default=0;
		ResStyleManager.Pack_Pack=1;
		ResStyleManager.Pack_NotPack=2;
		return ResStyleManager;
	})()


	/**快捷键管理器
	*@author yung
	*/
	//class laya.editor.manager.ShortcutManager
	var ShortcutManager=(function(){
		function ShortcutManager(){};
		__class(ShortcutManager,'laya.editor.manager.ShortcutManager');
		ShortcutManager.init=function(){
			Laya.stage.on("keydown",ShortcutManager,ShortcutManager.onStageKeyDown);
		}

		ShortcutManager.onStageKeyDown=function(e){
			if(Browser.window["layaideconfig"]){
				if(Browser.window["layaideconfig"].mode=="0")return;
			}
			ShortcutManager.exeKey(e.keyCode,KeyManager.I.isCommandKeyDown,e.shiftKey);
		}

		ShortcutManager.getKey=function(key,ctrl,shift){
			var str=""+key;
			str+=ctrl ? "_ctrl" :"";
			str+=shift ? "_shift" :"";
			return str;
		}

		ShortcutManager.addKey=function(key,ctrl,shift,handler,args,focusClass,name,_this){
			(name===void 0)&& (name="");
			var str=ShortcutManager.getKey(key,ctrl,shift);
			if (ShortcutManager.keyMap[str]==null || ShortcutManager.keyMap[str].focusClass !=focusClass){
				ShortcutManager.keyMap[str]={focusClass:focusClass,handler:handler,args:args,_this:_this};
				}else {
				Sys.warn(Sys.lang("快捷键冲突")+name,"key:"+key,"ctrl:"+ctrl,"shift:"+shift);
			}
		}

		ShortcutManager.addKeyE=function(key,ctrl,shift,notice,args,focusClass,name,_this){
			(name===void 0)&& (name="");
			var str=ShortcutManager.getKey(key,ctrl,shift);
			if (ShortcutManager.keyMapE[str]==null || ShortcutManager.keyMapE[str].focusClass !=focusClass){
				ShortcutManager.keyMapE[str]={focusClass:focusClass,notice:notice,args:args,_this:_this};
				}else {
				Sys.warn(Sys.lang("快捷键冲突")+name,"key:"+key,"ctrl:"+ctrl,"shift:"+shift);
			}
		}

		ShortcutManager.exeKey=function(key,ctrl,shift){
			(ctrl===void 0)&& (ctrl=false);
			(shift===void 0)&& (shift=false);
			var str=ShortcutManager.getKey(key,ctrl,shift);
			if (ShortcutManager.keyMap[str] !=null){
				var fClass;
				if (!fClass||(Laya.__typeof(Laya.stage.focus,fClass))){
					var fun=ShortcutManager.keyMap[str].handler;
					var args=ShortcutManager.keyMap[str].args;
					fun.apply(ShortcutManager.keyMap[str]._this,args);
				}
			}
			if (ShortcutManager.keyMapE[str] !=null){
				if (!fClass||(Laya.__typeof(Laya.stage.focus,fClass))){
					Notice1.notify(ShortcutManager.keyMapE[str].notice,ShortcutManager.keyMapE[str].args);
				}
			}
		}

		ShortcutManager.keyMap={};
		ShortcutManager.keyMapE={};
		return ShortcutManager;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.editor.manager.UIConfigManager
	var UIConfigManager=(function(){
		function UIConfigManager(){}
		__class(UIConfigManager,'laya.editor.manager.UIConfigManager');
		UIConfigManager.addNewConfig=function(data){
			if(!UIConfigManager.configMap){
				UIConfigManager.configMap=data;
				return;
			};
			var key;
			for(key in data){
				UIConfigManager.configMap[key]=data[key];
				UIConfigManager.addPropKeys(data[key]);
			}
		}

		UIConfigManager.getCompPropValueType=function(type,prop){
			var comp=UIConfigManager.getCompConfig(type);
			if(!comp||!comp.prop||!comp.prop[prop])return "unknow:"+type+","+prop;
			return comp.prop[prop].type;
		}

		UIConfigManager.getCompPropValueAccept=function(type,prop){
			var comp=UIConfigManager.getCompConfig(type);
			if(!comp||!comp.prop||!comp.prop[prop])return "";
			return comp.prop[prop].accept;
		}

		UIConfigManager.getCompConfig=function(type){
			return UIConfigManager.getFullConfig(type);
			return UIConfigManager.configMap[type];
		}

		UIConfigManager.addPropKeys=function(tdata){
			var cList=tdata.cList;
			var i=0,len=0;
			len=cList.length;
			for(i=0;i<len;i++){
				UIConfigManager.propKeysDic[cList[i].p.name]=true;
			}
		}

		UIConfigManager.getCompDefaultValueO=function(type){
			var configObj;
			var defaultObj;
			defaultObj=UIConfigManager.defaultPropDic[type];
			if(defaultObj)return defaultObj;
			defaultObj={};
			UIConfigManager.defaultPropDic[type]=configObj;
			configObj=laya.editor.manager.UIConfigManager.getCompConfig(type);
			if(!configObj)return defaultObj;
			var defaultStr;
			defaultStr=configObj.p.defaultValue;
			if(!defaultStr||defaultStr.length<1)return defaultObj;
			var keyValues;
			keyValues=defaultStr.split(" ");
			var tKValue;
			var i=0,len=0;
			len=keyValues.length;
			for(i=0;i<len;i++){
				if(!keyValues[i]||keyValues[i]==""||keyValues[i]==" ")continue ;
				tKValue=keyValues[i].split("=");
				defaultObj[tKValue[0]]=StringTool.getReplace(tKValue[1],"'","");
			}
			return defaultObj;
		}

		UIConfigManager.inserDefaultValue=function(node){
			var defaultObj;
			defaultObj=UIConfigManager.getCompDefaultValueO(node.type);
			var key;
			var assetDefault;
			assetDefault=ResStyleManager.getResPropsObj(node.props[laya.editor.manager.UIConfigManager.getCompSkinLabel(node.type)]);
			for(key in defaultObj){
				if(assetDefault[key])continue ;
				node.props[key]=ObjectTools.getAutoValue(defaultObj[key]);
			}
		}

		UIConfigManager.getFullConfig=function(type){
			var rst;
			rst=UIConfigManager.configMap[type];
			if (!rst)return null;
			rst=ObjectTools.copyObj(rst);
			if (!rst.c.prop)rst.c.prop=[];
			if (! (rst.c.prop instanceof Array))rst.c.prop=[rst.c.prop];
			if (rst.p.inherit){
				UIConfigManager.inherit(rst,UIConfigManager.getFullConfig(rst.p.inherit));
			}
			UIConfigManager.createPropDic(rst);
			return rst;
		}

		UIConfigManager.createPropDic=function(node){
			var props;
			props=node.c.prop;
			var propO;
			propO={};
			var i=0,len=0;
			len=props.length;
			var tProp;
			for(i=0;i<len;i++){
				tProp=props[i].p;
				propO[tProp.name]=tProp;
			}
			node.prop=propO;
		}

		UIConfigManager.getCompNames=function(){
			var rst=[];
			var key;
			for(key in UIConfigManager.configMap){
				rst.push(key);
			}
			return rst;
		}

		UIConfigManager.getCompTreeIcon=function(type){
			var iconurl;
			iconurl=laya.editor.manager.UIConfigManager.getCompProp(type,"icon");
			if(!iconurl){
				iconurl="Image";
			}
			return FileTools.getAbsPath(FileManager.getAppPath("laya/icons/components/"+iconurl+".png"));
		}

		UIConfigManager.getCompProp=function(type,key){
			var dataO=UIConfigManager.getFullConfig(type);
			if(!dataO||!dataO.p)return null;
			return dataO.p[key];
		}

		UIConfigManager.getCompSkinLabel=function(type){
			var prop=laya.editor.manager.UIConfigManager.getCompProp(type,"skinLabel");
			prop=prop || "styleSkin";
			return prop;
		}

		UIConfigManager.getCompTypeByResName=function(res,isIcon){
			(isIcon===void 0)&& (isIcon=false);
			var type;
			for(type in UIConfigManager.configMap){
				if(UIConfigManager.configMap[type].p.resName==res||type.toLowerCase()==res.toLowerCase()){
					if(isIcon)return UIConfigManager.configMap[type].p.icon;
					return type;
				}
			}
			return "Image";
		}

		UIConfigManager.getCompTypeByExtension=function(extension,isIcon){
			(isIcon===void 0)&& (isIcon=false);
			var type;
			for(type in UIConfigManager.configMap){
				if(UIConfigManager.configMap[type].p.extension&&!UIConfigManager.configMap[type].p.extensionDic){
					var extStr=UIConfigManager.configMap[type].p.extension;
					var exts;
					exts=extStr.split(",");
					var i=0,len=0;
					len=exts.length;
					var dic;
					dic={};
					for(i=0;i<len;i++){
						dic[exts[i]]=true;
					}
					UIConfigManager.configMap[type].p.extensionDic=dic;
				}
				if(UIConfigManager.configMap[type].p.extension==extension||(UIConfigManager.configMap[type].p.extensionDic&&UIConfigManager.configMap[type].p.extensionDic[extension])){
					if(isIcon)return UIConfigManager.configMap[type].p.icon;
					return type;
				}
			}
			return null;
		}

		UIConfigManager.inherit=function(child,parent){
			if (!parent)return;
			var cClist;
			var pClist;
			cClist=child.c.prop;
			pClist=parent.c.prop;
			var keys={};
			var i=0;
			var len=0;
			len=cClist.length;
			for (i=0;i < len;i++){
				keys[cClist[i].p.name]=true;
			}
			len=pClist.length;
			for (i=0;i < len;i++){
				if (!keys[pClist[i].p.name]){
					cClist.push(pClist[i]);
				};
			}
		}

		UIConfigManager.configMap={};
		UIConfigManager.propKeysDic={};
		UIConfigManager.defaultPropDic={};
		return UIConfigManager;
	})()


	/**编辑器系统类，提供扩展插件使用
	*@author yung
	*/
	//class laya.editor.Sys
	var Sys1=(function(){
		function Sys(){};
		__class(Sys,'laya.editor.Sys',null,'Sys1');
		Sys.SetBmdVer=function(name){
			var obj=Sys.bmdMap[name];
			if (obj){
				obj.ver=Sys.bmdVer;
			}
		}

		Sys.init=function(main){
			laya.editor.Sys.main=main;
			laya.editor.Sys.stage=main.stage;
		}

		Sys.clearRes=function(){
			Sys.resDomainMap={};
		}

		Sys.loadRes=function(url,complete){}
		Sys.onResLoaded=function(loader,complete){
			if (complete !=null){
				complete();
			}
		}

		Sys.onBitmapDataLoaded=function(loader,assetName,complete,args){
			if (complete !=null){
				complete.apply(null,args);
			}
		}

		Sys.disposeBitmap=function(assetName){
			var obj=Sys.bmdMap[assetName];
			if (obj){
				obj.bmd.dispose();
				delete Sys.bmdMap[assetName];
			}
		}

		Sys.hasRes=function(name){
			if (name==null || name.indexOf(".png")>-1 || name.indexOf(".jpg")>-1){
				return true;
			}
			return false;
		}

		Sys.getResClass=function(name){
			return null;
		}

		Sys.getRes=function(name){
			var sp=new Sprite();
			return sp;
		}

		Sys.getResBitmapData=function(name){
			return null;
		}

		Sys.info=function(__args){
			var args=arguments;
			console.log("info",args,0x3EBDF4);
		}

		Sys.error=function(__args){
			var args=arguments;
			console.log("error",args,0xFF4646);
		}

		Sys.warn=function(__args){
			var args=arguments;
			console.log("warn",args,0xFFFF80);
		}

		Sys.plugin=function(__args){
			var args=arguments;
			console.log("plugin",args,0xFF0080);
		}

		Sys.log=function(__args){
			var args=arguments;
			console.log("swc",args,0xFF0080);
		}

		Sys.stage=null
		Sys.main=null
		Sys.resDomainMap=null
		Sys.bmdMap={};
		Sys.bmdVer=0;
		return Sys;
	})()


	/**工具类
	*@author yung
	*/
	//class laya.editor.utils.Utils
	var Utils1=(function(){
		function Utils(){};
		__class(Utils,'laya.editor.utils.Utils',null,'Utils1');
		Utils.clone=function(source){
			return ObjectTools.copyObj(source);
		}

		Utils.bind=function(fun,_scope){
			var rst;
			rst=fun.bind(_scope);;
			return rst;
		}

		Utils.createMaskArea=function(width,height,color,alpha){
			(color===void 0)&& (color="#ff0000");
			(alpha===void 0)&& (alpha=1);
			var sp=new Sprite();
			sp.graphics.drawRect(0,0,width,height,color);
			sp.alpha=alpha;
			return sp;
		}

		Utils.drawDashedRect=function(g,width,height,lineWidth,lineColor,lineAlpha,solidLen,brokenLen){
			(lineWidth===void 0)&& (lineWidth=1);
			(lineColor===void 0)&& (lineColor=0xff0000);
			(lineAlpha===void 0)&& (lineAlpha=1);
			(solidLen===void 0)&& (solidLen=5);
			(brokenLen===void 0)&& (brokenLen=2);
			g.clear();
			Utils.drawDashed(g,new Point(0,0),new Point(width,0),lineWidth,lineColor,lineAlpha,solidLen,brokenLen);
			Utils.drawDashed(g,new Point(width,0),new Point(width,height),lineWidth,lineColor,lineAlpha,solidLen,brokenLen);
			Utils.drawDashed(g,new Point(width,height),new Point(0,height),lineWidth,lineColor,lineAlpha,solidLen,brokenLen);
			Utils.drawDashed(g,new Point(0,height),new Point(0,0),lineWidth,lineColor,lineAlpha,solidLen,brokenLen);
		}

		Utils.drawDashed=function(g,p1,p2,lineWidth,lineColor,lineAlpha,solidLen,brokenLen){
			(lineWidth===void 0)&& (lineWidth=1);
			(lineColor===void 0)&& (lineColor=0xff0000);
			(lineAlpha===void 0)&& (lineAlpha=1);
			(solidLen===void 0)&& (solidLen=5);
			(brokenLen===void 0)&& (brokenLen=2);
			g.drawLine(p1.x,p1.y,p2.x,p2.y,"#"+lineColor.toString(16));
		}

		Utils.getPoint=function(from,x,y,to){
			var g=from.localToGlobal(new Point(x,y));
			var p=to.globalToLocal(g);
			return p;
		}

		Utils.xmlToMapByCompId=function(xml,map){
			map[xml.compId]=xml;
			var list=xml.child;
			if(!list)return;
			for (var j=0,n=list.length;j < n;j++){
				Utils.xmlToMapByCompId(list[j],map);
			}
		}

		Utils.getClass=function(classname){
			var arr=classname.split(".");
			var obj=Browser.window;
			for(var i=0,n=arr.length;i<n;i++){
				obj=obj[arr[i]];
			}
			return obj;
		}

		return Utils;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-6-12 下午3:59:36
	*/
	//class laya.editor.view.ani.AnimationDataWorker
	var AnimationDataWorker=(function(){
		function AnimationDataWorker(){
			this._animations=null;
			this.treeData=null;
			this.compMap=null;
			this.design=null;
			this.targetAnimation=null;
			this.selectLabel=null;
			this.tSelectAni=null;
			this.treeNodeDic={};
			this.isFirstSetUp=false;
			this.keyIndexDic={};
			this.targetAnimation=new TargetAnimation();
		}

		__class(AnimationDataWorker,'laya.editor.view.ani.AnimationDataWorker');
		var __proto=AnimationDataWorker.prototype;
		/**
		*获取最大的动画id
		*@return
		*
		*/
		__proto.getMaxAniID=function(){
			if(!this._animations)return 1;
			var i=0,len=0;
			var rst=1;
			len=this._animations.length;
			var tAniData;
			for(i=0;i<len;i++){
				tAniData=this._animations[i];
				if(tAniData.id>=rst){
					rst=tAniData.id+1;
				}
			}
			return rst;
		}

		/**
		*创建一个新的动画
		*@return
		*
		*/
		__proto.createDefaultAnimationData=function(){
			var aniData;
			aniData={};
			aniData.id=this.getMaxAniID();
			aniData.name="ani"+aniData.id;
			aniData.frameRate=24;
			aniData.nodes=[];
			return aniData;
		}

		/**
		*获取节点动画数据
		*@param compId 节点ID
		*@param aniO 动画数据对象
		*@return
		*
		*/
		__proto.getAniNodeObj=function(compId,aniO){
			if(!aniO)aniO=this.tSelectAni;
			var nodes;
			nodes=aniO.nodes;
			var i=0,len=0;
			len=nodes.length;
			var tNode;
			for(i=0;i<len;i++){
				tNode=nodes[i];
				if(tNode.target==compId){
					return tNode;
				}
			}
			return null;
		}

		/**
		*创建一个节点动画数据
		*@param tar 目标节点
		*@return
		*
		*/
		__proto.createDefaultNodeData=function(tar){
			var nodeData;
			nodeData={};
			nodeData.target=tar.compId;
			nodeData.keyframes={};
			return nodeData;
		}

		/**
		*获取动画列表
		*@return
		*
		*/
		__proto.getAnimationSelects=function(){
			var i=0,len=0;
			len=this._animations.length;
			var tAniData;
			var rsts;
			rsts=AnimationDataWorker.selectLabels;
			rsts.length=0;
			for(i=0;i<len;i++){
				tAniData=this._animations[i];
				rsts.push(tAniData.name);
			}
			return rsts.join(",");
		}

		/**
		*删除动画名
		*@param aniName 动画名
		*
		*/
		__proto.removeAniByAniName=function(aniName){
			var i=0,len=0;
			len=this._animations.length;
			var tAniData;
			for(i=0;i<len;i++){
				tAniData=this._animations[i];
				if(aniName==tAniData.name){
					this._animations.splice(i,1);
					return;
				}
			}
		}

		__proto.isNewNameOk=function(aniName){
			if(!this._animations)return false;
			var i=0,len=0;
			len=this._animations.length;
			var tAniData;
			for(i=0;i<len;i++){
				tAniData=this._animations[i];
				if(aniName==tAniData.name){
					return false;
				}
			}
			return true;
		}

		/**
		*选择动画
		*@param aniName 动画名
		*
		*/
		__proto.selectAniByAniName=function(aniName){
			var i=0,len=0;
			len=this._animations.length;
			var tAniData;
			for(i=0;i<len;i++){
				tAniData=this._animations[i];
				if(aniName==tAniData.name){
					this.selectAniByIndex(i);
					return;
				}
			}
			this.selectAniByIndex(0);
		}

		/**
		*选择动画
		*@param index 动画id
		*
		*/
		__proto.selectAniByIndex=function(index){
			if(!this._animations[index])debugger;
			var tAniData;
			tAniData=this._animations[index];
			this.tSelectAni=tAniData;
			this.selectLabel=tAniData.name;
		}

		__proto.inits=function(){
			if(!this._animations)this._animations=[];
			if(this._animations.length<1){
				this._animations.push(this.createDefaultAnimationData());
			}
			if(!this.tSelectAni){
				this.selectAniByIndex(0);
			}
		}

		/**
		*添加动画
		*
		*/
		__proto.addAni=function(){
			this._animations.push(this.createDefaultAnimationData());
			this.selectAniByIndex(this._animations.length-1);
		}

		__proto.cloneAni=function(aniO){
			if(!aniO)aniO=this.tSelectAni;
			var newAniO;
			newAniO=ObjectTools.copyObj(aniO);
			var tName;
			var i=0;
			tName=aniO.name+"_"+i;
			while(!this.isNewNameOk(tName)){
				i++;
				tName=aniO.name+"_"+i;
			}
			newAniO.name=tName;
			this._animations.push(newAniO);
			this.selectAniByIndex(this._animations.length-1);
		}

		/**
		*删除动画节点
		*@param compId
		*@param aniO
		*
		*/
		__proto.removeNode=function(compId,aniO){
			if(!aniO)aniO=this.tSelectAni;
			var nodes;
			nodes=aniO.nodes;
			var i=0,len=0;
			len=nodes.length;
			var tNode;
			for(i=0;i<len;i++){
				tNode=nodes[i];
				if(tNode.target==compId){
					nodes.splice(i,1);
					return;
				}
			}
		}

		/**
		*添加节点
		*@param nodeId
		*
		*/
		__proto.addNode=function(nodeId){
			var node;
			var compO;
			compO=this.treeData.getNodeByID(nodeId);
			if(!compO)debugger;
			node=this.getAniNodeObj(nodeId);
			if(!node){
				node=this.createDefaultNodeData(compO);
				this.tSelectAni.nodes.push(node);
			}
		}

		/**
		*修改动画对象节点ID
		*@param preID
		*@param newID
		*
		*/
		__proto.changeNodeId=function(preID,newID){
			var node;
			node=this.getAniNodeObj(preID);
			if(node){
				node.target=newID;
				var nodeO;
				nodeO=this.treeNodeDic[preID+""];
				if(nodeO){
					delete this.treeNodeDic[preID+""];
					this.treeNodeDic[newID+""]=nodeO;
				}
			}
		}

		/**
		*删除节点属性动画
		*@param nodeId
		*@param prop
		*
		*/
		__proto.removeNodeProp=function(nodeId,prop){
			var node;
			node=this.getAniNodeObj(nodeId);
			if(node&&node.keyframes){
				delete node.keyframes[prop];
			}
			if(node&&node.frames){
				delete node.frames[prop];
			}
			if(this.design&&this.design.xml){
			}
		}

		__proto.removeFrame=function(aniO,frame){
			if(!aniO)aniO=this.tSelectAni;
			var nodes;
			nodes=aniO.nodes;
			var i=0,len=0;
			len=nodes.length;
			var tNode;
			for(i=0;i<len;i++){
				tNode=nodes[i];
				this.removeNodeFrame(tNode,frame);
			}
		}

		__proto.removeNodeFrameByNodeID=function(nodeId,frame){
			var node;
			node=this.getAniNodeObj(nodeId);
			if(node){
				this.removeNodeFrame(node,frame);
			}
		}

		__proto.displayToInitState=function(){
			if(this.targetAnimation){
				this.targetAnimation.displayToInitState();
			}
		}

		__proto.removeNodeFrame=function(nodeO,frame){
			var props;
			props=nodeO.keyframes;
			var propKey;
			for(propKey in props){
				this.removeNodePropFrame(props[propKey],frame);
			}
		}

		__proto.removeNodePropFrame=function(keyFrames,frame){
			if(!keyFrames)return;
			var i=0;
			for(i=keyFrames.length-1;i>=0;i--){
				if(keyFrames[i].index==frame){
					keyFrames.splice(i,1);
				}
			}
		}

		__proto.moveNodePropFrameTo=function(nodeID,prop,preFrame,newFrame){
			var preKeyFrame;
			var tarKeyFrame;
			preKeyFrame=this.targetAnimation.getNodePropKeyFrame(nodeID+"",preFrame,prop,false);
			if(!preKeyFrame)return;
			this.removeNodePropFrame(this.targetAnimation.getNodePropKeyFrames(nodeID+"",prop),newFrame);
			preKeyFrame.index=newFrame;
		}

		__proto.moveNodeFrameTo=function(nodeID,preFrame,newFrame){
			var nodeO;
			nodeO=this.getAniNodeObj(nodeID);
			if(!nodeO)return;
			var props;
			props=nodeO.keyframes;
			var propKey;
			for(propKey in props){
				this.moveNodePropFrameTo(nodeID,propKey,preFrame,newFrame);
			}
		}

		__proto.moveFrameTo=function(aniO,preFrame,newFrame){
			if(!aniO)aniO=this.tSelectAni;
			var nodes;
			nodes=aniO.nodes;
			var i=0,len=0;
			len=nodes.length;
			var tNode;
			for(i=0;i<len;i++){
				tNode=nodes[i];
				this.moveNodeFrameTo(tNode.target,preFrame,newFrame);
			}
		}

		/**
		*添加属性关键帧
		*@param node
		*@param prop
		*@param frame
		*
		*/
		__proto.addNodeFrame=function(node,prop,frame,force){
			(force===void 0)&& (force=false);
			if(!node.props.hasOwnProperty(prop)){
				if(force){
					node.props[prop]=this.targetAnimation.getNodeFrameProp(node.compId,frame,prop);
					}else{
					return;
				}
			};
			var value;
			value=node.props[prop];
			if(force||value!=this.targetAnimation.getNodeFrameProp(node.compId,frame,prop)){
				this.addNode(node.compId);
				var keyFrame;
				keyFrame=this.targetAnimation.getNodePropKeyFrame(node.compId,frame,prop,true);
				keyFrame.value=value;
				AnimationDataWorker.adptFrameData(keyFrame);
				this.targetAnimation.calculateDatas();
			}
		}

		__proto.makeKeyFrame=function(nodeId,prop,frame){
			this.addNode(nodeId);
			var keyFrame;
			keyFrame=this.targetAnimation.getNodePropKeyFrame(nodeId+"",frame,prop,true);
			keyFrame.value=this.targetAnimation.getNodeFrameProp(nodeId+"",frame,prop);
			return keyFrame;
		}

		/**
		*获取显示用的节点数据
		*@param key
		*@return
		*
		*/
		__proto.getTreeNodeObj=function(key){
			if(!this.treeNodeDic[key])this.treeNodeDic[key]={};
			var rst;
			rst=this.treeNodeDic[key];
			rst.hasChild=false;
			return rst;
		}

		__proto.makeAllNodeAni=function(){
			if(!IDEVars.isGraphicAnimationMode)return;
			if(!this.treeData)return;
			var rootNode;
			rootNode=this.treeData.root;
			if(!rootNode)return;
			var childs;
			childs=rootNode.child;
			var i=0,len=0;
			len=childs.length;
			for(i=0;i<len;i++){
				var tChild;
				tChild=childs[i];
				if(tChild.compId>0){
					this.addNode(tChild.compId);
				}
			}
		}

		/**
		*获取显示用的动画数据
		*@return
		*
		*/
		__proto.getAniDataList=function(){
			if(this.isFirstSetUp){
				this.targetAnimation.setUp(this.compMap,null,this.tSelectAni);
				}else{
				this.targetAnimation.setUp(this.compMap,this.targetAnimation.initProps,this.tSelectAni);
			}
			this.makeAllNodeAni();
			this.isFirstSetUp=false;
			var rst;
			rst=[];
			var i=0,len=0;
			var nodes;
			nodes=this.tSelectAni.nodes;
			len=nodes.length;
			var tNode;
			var propNode;
			var tCompID=0;
			ObjectTools.clearObj(this.keyIndexDic);
			for(i=0;i<len;i++){
				tNode=nodes[i];
				tCompID=tNode.target;
				var nodeO;
				var compO;
				nodeO=this.getTreeNodeObj(tCompID+"");
				nodeO.path=tNode;
				nodeO.label=tCompID+"";
				nodeO.target=tCompID;
				nodeO.loseTarget=true;
				compO=this.treeData.getNodeByID(tCompID);
				if(compO){
					nodeO.type=compO.type;
					nodeO.label=compO.type+":"+compO.compId;
					if(compO.props){
						var AName;
						AName=compO.props["var"]||compO.props.name;
						if(AName){
							nodeO.label=compO.type+"("+AName+")"+":"+compO.compId;
						}
					}
					nodeO.loseTarget=false;
				};
				var nodeFrameList;
				nodeFrameList=[];
				var nodeFrameDic;
				nodeFrameDic={};
				if(!nodeO.childs)nodeO.childs=[];
				childs=nodeO.childs;
				childs.length=0;
				var childs;
				var propKey;
				var props;
				props=tNode.keyframes;
				rst.push(nodeO);
				for(propKey in props){
					propNode=this.getTreeNodeObj(tCompID+":"+propKey);
					propNode.path=props[propKey];
					propNode.nodeParent=nodeO;
					propNode.label=propKey;
					propNode.target=tCompID;
					propNode.key=propKey;
					childs.push(propNode);
					rst.push(propNode);
					this.collectKeyFrames(props[propKey],nodeFrameDic);
					this.collectKeyFrames(props[propKey],this.keyIndexDic);
				}
				nodeO.keyFrames=this.createNodeKeyFramesData(nodeFrameDic,tCompID);
				nodeO.isDirectory=true;
				nodeO.hasChild=true;
			}
			return rst;
		}

		__proto.createNodeKeyFramesData=function(keyFrameDic,target){
			var rst;
			rst=SingleTool.I.getArr("keyframe:"+target);
			rst.length=0;
			var key;
			var tKeyFrameData;
			for(key in keyFrameDic){
				tKeyFrameData=SingleTool.I.getObject("keyframedata:"+target+"_"+key);
				tKeyFrameData.target=target;
				tKeyFrameData.index=key;
				rst.push(tKeyFrameData);
			}
			return rst;
		}

		__proto.collectKeyFrames=function(frames,keyFrameDic){
			var i=0,len=0;
			len=frames.length;
			for(i=0;i<len;i++){
				keyFrameDic[frames[i].index]=true;
			}
		}

		/**
		*获取动画列表
		*@return
		*
		*/
		__getset(0,__proto,'animations',function(){
			return this._animations;
			},function(v){
			this._animations=v;
			this.inits();
		});

		AnimationDataWorker.createFrameData=function(index){
			(index===void 0)&& (index=0);
			var frameData;
			frameData={};
			frameData.index=index;
			frameData.value="";
			frameData.tween=true;
			frameData.tweenMethod="linearNone";
			return frameData;
		}

		AnimationDataWorker.cleanAnimationData=function(animationData,createNew){
			(createNew===void 0)&& (createNew=false);
			if(createNew){
				animationData=ObjectTools.copyObj(animationData);
			};
			var aniO;
			var ii=0,iiLen=0;
			iiLen=animationData.length;
			for(ii=0;ii<iiLen;ii++){
				aniO=animationData[ii];
				var nodes;
				nodes=aniO.nodes;
				var i=0,len=0;
				len=nodes.length;
				var tNode;
				for(i=0;i<len;i++){
					tNode=nodes[i];
					delete tNode.frames;
				}
			}
			return animationData;
		}

		AnimationDataWorker.getAnimationedNode=function(uiObj){
			var rst;
			rst={};
			var animationData;
			animationData=uiObj.animations;
			if(!animationData)return rst;
			var aniO;
			var ii=0,iiLen=0;
			iiLen=animationData.length;
			for(ii=0;ii<iiLen;ii++){
				aniO=animationData[ii];
				var nodes;
				nodes=aniO.nodes;
				var i=0,len=0;
				len=nodes.length;
				var tNode;
				for(i=0;i<len;i++){
					tNode=nodes[i];
					rst[tNode.target]=true;
				}
			}
			return rst;
		}

		AnimationDataWorker.adptFrameData=function(keyFrame){
			if(ObjectTools.isNaN(keyFrame.value)){
				keyFrame.tween=false;
			}
			return keyFrame;
		}

		AnimationDataWorker.selectLabels=[];
		return AnimationDataWorker;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-6-13 上午10:56:49
	*/
	//class laya.editor.view.ani.TargetAnimation
	var TargetAnimation=(function(){
		function TargetAnimation(){
			this.targetDic=null;
			this.initProps=null;
			this.aniData=null;
			this.changedNodes={};
			this.count=0;
			this.sortIndexFun=null;
			if(this.sortIndexFun==null){
				this.sortIndexFun=MathUtil.sortByKey("index",false,true);
			}
		}

		__class(TargetAnimation,'laya.editor.view.ani.TargetAnimation');
		var __proto=TargetAnimation.prototype;
		/**
		*初始化动画数据
		*@param targetDic 对象表
		*@param initProps 对象初始化数据
		*@param aniData 动画数据
		*
		*/
		__proto.setUp=function(targetDic,initProps,aniData){
			this.targetDic=targetDic;
			this.initProps=initProps;
			if(!initProps)this.recordInitProps();
			this.aniData=aniData;
			this.calculateDatas();
		}

		/**
		*获取节点某帧某属性的数据
		*@param nodeKey 节点ID
		*@param frame 帧
		*@param prop 属性名
		*@return
		*
		*/
		__proto.getNodeFrameProp=function(nodeKey,frame,prop){
			var nodeData;
			nodeData=this.getNodeData(nodeKey);
			if(!nodeData||!nodeData.frames||!nodeData.frames[prop]){
				if(isNaN(this.initProps[nodeKey][prop]))return 0;
				return this.initProps[nodeKey][prop];
			};
			var frames;
			frames=nodeData.frames[prop];
			if(frames[frame]){
				return frames[frame];
				}else{
				return frames[frames.length-1];
			}
		}

		/**
		*获取节点的属性关键帧列表
		*@param nodeKey 节点ID
		*@param prop 属性名
		*@return
		*
		*/
		__proto.getNodePropKeyFrames=function(nodeKey,prop){
			var nodeData;
			nodeData=this.getNodeData(nodeKey);
			var keyFrames;
			keyFrames=nodeData.keyframes;
			if(!keyFrames[prop]){
				keyFrames[prop]=[];
			}
			return keyFrames[prop];
		}

		/**
		*获取节点的属性关键帧对象
		*@param nodeKey 节点ID
		*@param frame 帧
		*@param prop 属性名
		*@param autoCreate 如果没有是否自动创建
		*@return
		*
		*/
		__proto.getNodePropKeyFrame=function(nodeKey,frame,prop,autoCreate){
			(autoCreate===void 0)&& (autoCreate=false);
			var keyFrames;
			keyFrames=this.getNodePropKeyFrames(nodeKey,prop);
			var i=0,len=0;
			len=keyFrames.length;
			for(i=0;i<len;i++){
				if(keyFrames[i].index==frame)return keyFrames[i];
			}
			if(autoCreate){
				var frameData;
				frameData=AnimationDataWorker.createFrameData(frame);
				keyFrames.push(frameData);
				keyFrames.sort(this.sortIndexFun);
				return frameData;
				}else{
				return null;
			}
		}

		/**
		*获取节点数据
		*@param nodeKey 节点ID
		*@return
		*
		*/
		__proto.getNodeData=function(nodeKey){
			var nodes;
			nodes=this.aniData.nodes;
			var i=0,len=0;
			len=nodes.length;
			for(i=0;i<len;i++){
				if(nodes[i].target==nodeKey)return nodes[i];
			}
			return null;
		}

		/**
		*将所有节点设置到初始化状态
		*
		*/
		__proto.displayToInitState=function(){
			this.displayToInitStateSS();
			return;
			this.displayToInitStateEx();
			return;
			if(!this.initProps)return;
			if(!this.aniData)return;
			var nodeKey;
			var tNode;
			var props;
			for(nodeKey in this.initProps){
				tNode=this.targetDic[nodeKey];
				try{
					if(tNode){
						props=this.initProps[nodeKey];
						var prop;
						for(prop in props){
							tNode[prop]=props[prop];
						}
					}
				}catch(e){}
			}
		}

		__proto.displayToInitStateSS=function(){
			if(!this.initProps)return;
			if(!this.aniData)return;
			var key;
			var target;
			var datas;
			for(target in this.changedNodes){
				var props;
				props=this.initProps[target];
				var tNode;
				tNode=this.targetDic[target];
				datas=this.changedNodes[target];
				if(tNode&&props){
					for(key in datas){
						tNode[key]=props[key];
						if(tNode.comXml&&tNode.comXml.props&&tNode.comXml.props.hasOwnProperty(key)){
							if(TargetAnimation.isNoDisplayValue(tNode.comXml.props[key])){
								delete tNode.comXml.props[key];
								}else{
								tNode.comXml.props[key]=props[key];
							}
						}
					}
				}
			}
		}

		__proto.displayToInitStateEx=function(){
			if(!this.initProps)return;
			if(!this.aniData)return;
			var nodes;
			nodes=this.aniData.nodes;
			var i=0,len=0;
			len=nodes.length;
			for(i=0;i<len;i++){
				this.displayNodeToInitState(nodes[i]);
			}
		}

		__proto.displayNodeToInitState=function(node){
			var keyFrames;
			keyFrames=node.keyframes;
			var key;
			var tKeyFrames;
			var target=0;
			target=node.target;
			var props;
			props=this.initProps[target];
			var tNode;
			tNode=this.targetDic[target];
			for(key in keyFrames){
				tNode[key]=props[key];
			}
		}

		/**
		*将节点设置到某一帧的状态
		*@param frame
		*
		*/
		__proto.displayToFrame=function(frame){
			if(!this.aniData)return;
			if(frame<0)frame=0;
			if(frame>this.count)frame=this.count;
			var i=0,len=0;
			var nodes;
			nodes=this.aniData.nodes;
			len=nodes.length;
			for(i=0;i<len;i++){
				this.displayNodeToFrame(nodes[i],frame,null);
			}
		}

		/**
		*将节点设置到某一帧的状态
		*@param node 节点ID
		*@param frame
		*@param targetDic 节点表
		*
		*/
		__proto.displayNodeToFrame=function(node,frame,targetDic){
			if(!targetDic)targetDic=this.targetDic;
			var target;
			target=targetDic[node.target];
			if(!target){
				console.log("loseTarget:",node.target);
				return;
			};
			var frames;
			frames=node.frames;
			var key;
			var propFrames;
			var value;
			var propO;
			if(target.comXml&&target.comXml.props){
				propO=target.comXml.props;
			}
			if(!this.changedNodes[node.target]){
				this.changedNodes[node.target]={};
			}
			for(key in frames){
				this.changedNodes[node.target][key]=true;
				propFrames=frames[key];
				if(propFrames.length>frame){
					value=propFrames[frame];
					}else{
					value=propFrames[propFrames.length-1];
				}
				target[key]=value;
				if(propO){
					if(TargetAnimation.isNoDisplayValue(value)){
						delete propO[key];
						}else{
						propO[key]=value;
					}
				}
			}
		}

		/**
		*记录所有节点的初始化信息
		*
		*/
		__proto.recordInitProps=function(){
			if(!this.initProps)this.initProps={};
			ObjectTools.clearObj(this.initProps);
			var key;
			for(key in this.targetDic){
				this.recordNodeInfo(key,this.targetDic[key]);
			}
		}

		/**
		*记录某个节点的初始化信息
		*@param objKey
		*@param node
		*
		*/
		__proto.recordNodeInfo=function(objKey,node,force,keys){
			(force===void 0)&& (force=false);
			var key;
			var value;
			var tProp;
			tProp={};
			keys=keys||UIConfigManager.propKeysDic;
			var props;
			if(node.comXml&&node.comXml.props){
				props=node.comXml.props;
			}
			for(key in keys){
				value=node[key];
				tProp[key]=value;
				if(props&&props.hasOwnProperty(key)){
					tProp[key]=props[key];
				}
			}
			this.initProps[objKey]=tProp;
		}

		/**
		*计算帧数据
		*
		*/
		__proto.calculateDatas=function(){
			if(!this.aniData)return;
			var nodes;
			nodes=this.aniData.nodes;
			var i=0,len=0;
			len=nodes.length;
			var tNode;
			this.count=0;
			for(i=0;i<len;i++){
				tNode=nodes[i];
				this.calculateNodeKeyFrames(tNode);
			}
		}

		/**
		*计算某个节点的帧数据
		*@param node
		*
		*/
		__proto.calculateNodeKeyFrames=function(node){
			var keyFrames;
			keyFrames=node.keyframes;
			var key;
			var tKeyFrames;
			var target=0;
			target=node.target;
			if(!node.frames){
				node.frames={};
			}
			if(!this.initProps[node.target]){
			}
			for(key in keyFrames){
				tKeyFrames=keyFrames[key];
				if(!node.frames[key]){
					node.frames[key]=[];
				}
				tKeyFrames.sort(this.sortIndexFun);
				var isNew=false;
				if(tKeyFrames.length<1||tKeyFrames[0].index!=0){
					tKeyFrames.unshift(AnimationDataWorker.createFrameData(0));
					isNew=true;
				};
				var initData;
				initData=this.initProps[node.target];
				if(initData&&isNew){
					if(!(initData[key]===undefined)&&isNaN(initData[key])&&!((typeof (initData[key])=='string'))){
						tKeyFrames[0].value=0;
						}else{
						tKeyFrames[0].value=initData[key];
					}
				}
				if(tKeyFrames[0]){
					AnimationDataWorker.adptFrameData(tKeyFrames[0]);
				}
				this.calculateNodePropFrames(tKeyFrames,node.frames[key],key,target);
			}
		}

		/**
		*计算节点某个属性的帧数据
		*@param keyframes
		*@param frames
		*@param key
		*@param target
		*
		*/
		__proto.calculateNodePropFrames=function(keyframes,frames,key,target){
			var i=0,len=0;
			len=keyframes.length-1;
			frames.length=keyframes[len].index+1;
			for(i=0;i<len;i++){
				keyframes[i].key=key;
				keyframes[i].target=target;
				this.calculateFrameValues(keyframes[i],keyframes[i+1],frames);
			}
			if(len==0){
				frames[0]=keyframes[0].value;
			}
			keyframes[i].key=key;
			keyframes[i].target=target;
		}

		/**
		*计算两个关键帧直接的帧数据
		*@param startFrame
		*@param endFrame
		*@param result
		*
		*/
		__proto.calculateFrameValues=function(startFrame,endFrame,result){
			var i=0;
			var start=0,end=0;
			var easeFun;
			start=startFrame.index;
			end=endFrame.index;
			var startValue=0;
			startValue=startFrame.value;
			var dValue=0;
			dValue=endFrame.value-startFrame.value;
			var dLen=0;
			dLen=end-start;
			if(end>this.count)this.count=end;
			if(startFrame.tween){
				easeFun=Ease[startFrame.tweenMethod];
				if(easeFun==null){
					easeFun=Ease.linearNone;
				}
				for(i=start;i<end;i++){
					result[i]=easeFun(i-start,startValue,dValue,dLen);
				}
				}else{
				for(i=start;i<end;i++){
					result[i]=startValue;
				}
			}
			result[endFrame.index]=endFrame.value;
		}

		TargetAnimation.isNoDisplayValue=function(value){
			if(value===null||value===undefined||value.toString()=="NaN")return true;
			return false;
		}

		return TargetAnimation;
	})()


	/**帮助
	*@author yung
	*/
	//class laya.editor.view.other.Help
	var Help=(function(){
		function Help(){};
		__class(Help,'laya.editor.view.other.Help');
		var __proto=Help.prototype;
		__proto.start=function(){}
		__getset(1,Help,'instance',function(){
			return Help._instance ? Help._instance :Help._instance=new Help();
		});

		Help._instance=null
		return Help;
	})()


	/**感谢
	*@author yung
	*/
	//class laya.editor.view.other.Thank
	var Thank=(function(){
		function Thank(){};
		__class(Thank,'laya.editor.view.other.Thank');
		var __proto=Thank.prototype;
		__proto.start=function(){}
		__getset(1,Thank,'instance',function(){
			return Thank._instance ? Thank._instance :Thank._instance=new Thank();
		});

		Thank._instance=null
		return Thank;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-8-30 下午3:04:18
	*/
	//class laya.editor.view.prop.AppendPropGroupTool
	var AppendPropGroupTool=(function(){
		function AppendPropGroupTool(){}
		__class(AppendPropGroupTool,'laya.editor.view.prop.AppendPropGroupTool');
		AppendPropGroupTool.getNodePropKeyValue=function(node,key){
			if(!node)return null;
			return node.props[key]||PreFabManager.I.getPrefabUIPropByKey(node,key)||ResStyleManager.getResPropsKeyByNode(node,key)||PreFabManager.I.getPreFabPropByKey(node,key);
		}

		AppendPropGroupTool.addAppendPropsToData=function(appendPropPath,node){
			if(IDEVars.isGraphicAnimationMode){
				return;
			};
			var propO;
			propO=node.props;
			if(!propO[ "appendProps"])propO[ "appendProps"]=AppendPropGroupTool.getNodePropKeyValue(node,"appendProps");
			if(!propO[ "appendProps"])propO[ "appendProps"]="";
			var appends;
			var tstr;
			tstr=propO[ "appendProps"];
			if(tstr==""){
				appends=[];
				}else{
				appends=[];
			}
			if(appends.indexOf(appendPropPath)<0){
				appends.push(appendPropPath);
				propO[ "appendProps"]=appends.join(",");
			}
		}

		AppendPropGroupTool.removeAppendPropsFromData=function(appendPropPath,node){
			var propO;
			propO=node.props;
			if(!propO[ "appendProps"])propO[ "appendProps"]=AppendPropGroupTool.getNodePropKeyValue(node,"appendProps");
			if(!propO[ "appendProps"])return;
			var appends;
			appends=propO[ "appendProps"].split(",");
			if(appends.indexOf(appendPropPath)>=0){
				appends.splice(appends.indexOf(appendPropPath),1);
				if(appends.length<=0){
					delete propO[ "appendProps"];
					}else{
					propO[ "appendProps"]=appends.join(",");
				}
			}
		}

		AppendPropGroupTool.getProp=function(propName,type){
			(type===void 0)&& (type="input");
			var rst;
			rst={};
			rst.name=propName;
			rst.type=type;
			rst.tips=propName+":"+type;
			return rst;
		}

		AppendPropGroupTool.getTestData=function(){
			var rst;
			rst={};
			rst.name="testLabel";
			var props;
			props=[];
			rst.props=props;
			props.push(AppendPropGroupTool.getProp("lim"),AppendPropGroupTool.getProp("lam"));
			return rst;
		}

		AppendPropGroupTool.createGroupData=function(groupName,props,data){
			var rst;
			rst={};
			rst.name=groupName;
			rst.props=props;
			rst.data=data;
			return rst;
		}

		AppendPropGroupTool.getTestGroups=function(){
			var rst;
			rst=[];
			rst.push(AppendPropGroupTool.getTestData());
			return rst;
		}

		AppendPropGroupTool.readXMLPropConfig=function(path,insertRender){
			(insertRender===void 0)&& (insertRender=false);
			if(!FileTools.exist(path))return {};
			var xmlFile;
			xmlFile=FileTools.readFile(path);
			var xml;
			xml=Utils.parseXMLFromString(xmlFile);
			var obj;
			obj=XML2Object.parse(xml);
			if(insertRender){
				UIConfigManager.addNewConfig(obj.c);
			}
			return obj.cList[0];
		}

		AppendPropGroupTool.initScriptConfig=function(scriptPath){
			var data;
			data=AppendPropGroupTool.readXMLPropConfig(FileManager.getWorkPath(scriptPath),true);
			if(data&&data.Name){
				AppendPropGroupTool.scriptTypeDic[scriptPath]=data.Name;
			}
		}

		AppendPropGroupTool.isScriptInit=function(scriptPath){
			return AppendPropGroupTool.scriptTypeDic.hasOwnProperty(scriptPath);
		}

		AppendPropGroupTool.clearScript=function(scriptPath){
			delete AppendPropGroupTool.scriptTypeDic[scriptPath];
		}

		AppendPropGroupTool.getScriptName=function(scriptPath){
			if(! AppendPropGroupTool.scriptTypeDic[scriptPath])AppendPropGroupTool.initScriptConfig(scriptPath);
			if(!AppendPropGroupTool.scriptTypeDic[scriptPath])return "lostScript";
			return AppendPropGroupTool.scriptTypeDic[scriptPath];
		}

		AppendPropGroupTool.getPropsOByPath=function(path){
			var tData;
			try{
				tData=AppendPropGroupTool.readXMLPropConfig(path);
			}
			catch(error){
				tData={};
				tData.props={};
			}
			return tData;
		}

		AppendPropGroupTool.adptScriptNode=function(node){
			if(!node.type=="Script")return;
			AppendPropGroupTool.insertAppendPropsByPath(node,node.source);
		}

		AppendPropGroupTool.insertAppendProps=function(node){
			var path=laya.editor.view.prop.AppendPropGroupTool.getNodePropKeyValue(node,"appendProps");
			AppendPropGroupTool.insertAppendPropsByPath(node,path);
		}

		AppendPropGroupTool.insertAppendPropsByPath=function(node,path){
			if(!path)return;
			var tPath;
			tPath=FileManager.getWorkPath(path);
			if(!TypeManager.isScriptFile(path))return;
			var tData;
			tData=AppendPropGroupTool.getPropsOByPath(tPath);
			if(tData&&tData.p&&tData.p["className"]&&node.props){
				node.props.runtime=tData.p["className"];
			}
		}

		AppendPropGroupTool.getAppendPropByAppendProps=function(propsStr){
			if(!propsStr)return null;
			var strs;
			strs=propsStr.split(",");
			var i=0,len=0;
			len=strs.length;
			var rsts;
			rsts=[];
			for(i=0;i<len;i++){
				var tPath;
				tPath=FileManager.getWorkPath(strs[i]);
				if(FileTools.exist(tPath)){
					var tData;
					var gData;
					try{
						tData=AppendPropGroupTool.getPropsOByPath(tPath);
						gData={};
						gData.type="appendProps";
						gData.path=strs[i];
						gData.removeAble=true;
						rsts.push(AppendPropGroupTool.createGroupData(tData.Name,tData.c.prop,gData));
					}
					catch(error){
					}
				}
			}
			if(rsts.length>0)return rsts;
			return null;
		}

		AppendPropGroupTool.getAppendPropByRunTime=function(runTime){
			if(!runTime)return null;
			var filePath;
			filePath=runTime.split(".").join("/");
			filePath=FileManager.getWorkPath("src/"+filePath+".as");
			if(!FileTools.exist(filePath)){
				return null;
			};
			var code;
			code=new AsFileParser();
			code.setFile(filePath);
			var members;
			members=code.allMemberDic;
			var key;
			var tMemberO;
			var props;
			props=[];
			for(key in members){
				tMemberO=members[key];
				if(!tMemberO.modifiesO["public"])continue ;
				if(!AppendPropGroupTool.editablePropType[tMemberO.varType])continue ;
				switch(tMemberO.type){
					case "function":
						if(tMemberO.exType=="set"){
							var vName;
							vName=tMemberO.name;
							vName=vName.substr(3);
							props.push(AppendPropGroupTool.getProp(vName,tMemberO.varType));
						}
						break ;
					case "var":
						props.push(AppendPropGroupTool.getProp(tMemberO.name,tMemberO.varType));
						break ;
					}
			};
			var rst;
			if(props.length>0){
				rst=[AppendPropGroupTool.createGroupData(code.className,props)];
			}
			return rst;
		}

		AppendPropGroupTool.AppendPropsKey="appendProps";
		AppendPropGroupTool.scriptTypeDic={};
		AppendPropGroupTool.ConfigClassNameSign="className";
		__static(AppendPropGroupTool,
		['editablePropType',function(){return this.editablePropType={
				"Number":true,
				"int":true,
				"Boolean":true,
				"String":true
		};}

		]);
		return AppendPropGroupTool;
	})()


	/**
	*时间轴帧数据
	*@author ww
	*@version 1.0
	*
	*@created 2015-12-5 下午1:55:45
	*/
	//class laya.editor.view.timeline.TimeFrameData
	var TimeFrameData=(function(){
		function TimeFrameData(){
			this.frame=0;
			this.type=0;
			this.props=null;
		}

		__class(TimeFrameData,'laya.editor.view.timeline.TimeFrameData');
		TimeFrameData.create=function(frame,props,type){
			(type===void 0)&& (type=1);
			var rst;
			rst=Pool.getItemByClass("TimeFrameData",TimeFrameData);
			rst.type=type;
			rst.frame=frame;
			rst.props=props;
			return rst;
		}

		return TimeFrameData;
	})()


	/**
	*时间轴相关的事件
	*@author WW
	*@version 1.0
	*
	*@created 2015-12-8 上午9:01:12
	*/
	//class laya.editor.view.timeline.TimeLineEvent
	var TimeLineEvent=(function(){
		function TimeLineEvent(){}
		__class(TimeLineEvent,'laya.editor.view.timeline.TimeLineEvent');
		TimeLineEvent.LIST_CHANGE="ListChange";
		TimeLineEvent.TIMELINE_CLICKFRAME="TIMELINE_CLICKFRAME";
		return TimeLineEvent;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-6-27 下午10:41:37
	*/
	//class laya.editor.view.timeline.TimeLineStyles
	var TimeLineStyles=(function(){
		function TimeLineStyles(){}
		__class(TimeLineStyles,'laya.editor.view.timeline.TimeLineStyles');
		TimeLineStyles.cursorArrowColor="#00ffff";
		TimeLineStyles.cursorTxtColor="#00ffff";
		TimeLineStyles.cursorLineColor="#00ffff";
		TimeLineStyles.FrameBorderColor="#cc00cc";
		TimeLineStyles.FrameBorderColor_Focus="#ccFFcc";
		TimeLineStyles.FrameColor_KeyFrame="#13b5b1";
		TimeLineStyles.FrameColor_Holder="#111111";
		TimeLineStyles.FrameColor_Node="#ffffff";
		TimeLineStyles.FrameColor_Label="#ff0000";
		TimeLineStyles.FrameColor_Circle="#f8b551";
		TimeLineStyles.TitleBigLineColor="#009999";
		TimeLineStyles.TitleSmallLineColor="#006666";
		TimeLineStyles.TitleTxtColor="#d8d8d8";
		TimeLineStyles.FrameLineColor="#343434";
		__static(TimeLineStyles,
		['FrameColors',function(){return this.FrameColors=["#356692","#515151","#404040"];}
		]);
		return TimeLineStyles;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-12-7 下午7:47:46
	*/
	//class laya.editor.view.timeline.TimeLineUtils
	var TimeLineUtils=(function(){
		function TimeLineUtils(){}
		__class(TimeLineUtils,'laya.editor.view.timeline.TimeLineUtils');
		TimeLineUtils.fakeTimeLineTreeArrData=function(){
			var disTree;
			disTree=TimeLineUtils.fakeDisTreeData();
			var timeLineData;
			timeLineData=TimeLineUtils.fakeTimeLineData(disTree);
			var treeArr;
			treeArr=TimeLineUtils.fakeTreeArr(timeLineData);
			return treeArr;
		}

		TimeLineUtils.fakeDisTreeData=function(){
			var data;
			data=TimeLineUtils.getNodeData();
			var childNode;
			var i=0,len=0;
			len=5;
			for(i=0;i<len;i++){
				TimeLineUtils.addChildTo(TimeLineUtils.getNodeData(),data)
			}
			childNode=TimeLineUtils.getNodeData();
			len=3;
			for(i=0;i<len;i++){
				TimeLineUtils.addChildTo(TimeLineUtils.getNodeData(),childNode)
			}
			TimeLineUtils.addChildTo(childNode,data)
			return data;
		}

		TimeLineUtils.fakeTreeArr=function(treeO){
			var rst;
			rst=[];
			DisTools.getTreeArr(treeO,rst);
			return rst;
		}

		TimeLineUtils.fakeTimeLineData=function(treeData,parent){
			var rst;
			rst={};
			rst.nodeParent=parent;
			rst.name=treeData.name;
			rst.label=rst.name;
			var childs;
			childs=treeData.childs;
			var i=0,len=0;
			len=childs.length;
			var nChild;
			nChild=[];
			for(i=0;i<len;i++){
				nChild.push(TimeLineUtils.fakeTimeLineData(childs[i],rst));
			}
			rst.frames=TimeLineUtils.fakeFrameData();
			rst.childs=nChild;
			rst.isDirectory=nChild.length>0;
			rst.hasChild=nChild.length>0;
			return rst;
		}

		TimeLineUtils.fakeFrameData=function(){
			var frameList;
			frameList=[];
			var tFrameData;
			tFrameData=new TimeFrameData();
			tFrameData.frame=9;
			frameList.push(tFrameData);
			tFrameData=new TimeFrameData();
			tFrameData.frame=10;
			frameList.push(tFrameData);
			tFrameData=new TimeFrameData();
			tFrameData.frame=Math.floor(30*Math.random());
			frameList.push(tFrameData);
			tFrameData=new TimeFrameData();
			tFrameData.frame=Math.floor(30*Math.random());
			frameList.push(tFrameData);
			return frameList;
		}

		TimeLineUtils.getNodeData=function(){
			var rst;
			rst={};
			rst.nodeParent=null;
			rst.name="node";
			rst.data={};
			rst.childs=[];
			return rst;
		}

		TimeLineUtils.addChildTo=function(child,parent){
			parent.childs.push(child);
			child.nodeParent=parent;
		}

		return TimeLineUtils;
	})()


	/**项目配置
	*@author yung
	*/
	//class laya.ide.config.ProjectSetting
	var ProjectSetting=(function(){
		function ProjectSetting(){};
		__class(ProjectSetting,'laya.ide.config.ProjectSetting');
		ProjectSetting.makeSureType=function(labels,pageType){
			(pageType===void 0)&& (pageType="Scene2D");
			if(labels.indexOf(pageType)<0){
				labels+=","+pageType;
			}
			return labels;
		}

		ProjectSetting.getPageTypeLabel=function(){
			var labels;
			labels=laya.ide.config.ProjectSetting.pageTypes.join(",");
			return labels;
		}

		ProjectSetting.isPageType=function(type){
			return ProjectSetting.pageTypes.indexOf(type)>=0;
		}

		ProjectSetting.adptPaths=function(){
			var i=0,len=0;
			var tKey;
			len=ProjectSetting.UiPaths.length;
			for(i=0;i<len;i++){
				tKey=ProjectSetting.UiPaths[i];
				ProjectSetting[tKey]=StringTool.trimSide(ProjectSetting[tKey]+"");
			}
			if(laya.ide.config.ProjectSetting.asynResExportPath==""){
				if(ProjectSetting.codeType==0){
					laya.ide.config.ProjectSetting.asynResExportPath="bin/h5";
					}else{
					laya.ide.config.ProjectSetting.asynResExportPath="bin";
				}
			}
		}

		ProjectSetting.isContainer=function(type){
			return ProjectSetting.boxTypes.indexOf(type)>=0;
		}

		ProjectSetting.codeExportPath="src/game/ui/";
		ProjectSetting.defaultFont="";
		ProjectSetting.codeImportsTS=" ";
		ProjectSetting.resExportPath="bin/h5";
		ProjectSetting.asynResExportPath="bin/h5";
		ProjectSetting.resCanCompress=0;
		ProjectSetting.resPublishQuality=80;
		ProjectSetting.disableBinaryPic=0;
		ProjectSetting.uiType=0;
		ProjectSetting.codeType=0;
		ProjectSetting.picType=0;
		ProjectSetting.uiExportPath="bin/ui.json";
		ProjectSetting.shareResPath="";
		ProjectSetting.exportResType="swf";
		ProjectSetting.createSwfType="image";
		ProjectSetting.langPath="";
		ProjectSetting.textureWidth=2048;
		ProjectSetting.textureHeight=2048;
		ProjectSetting.picWidth=512;
		ProjectSetting.picHeight=512;
		ProjectSetting.power2="true";
		ProjectSetting.trimempty="false";
		__static(ProjectSetting,
		['resTypes',function(){return this.resTypes=["png","jpg"];},'codeImports',function(){return this.codeImports="import laya.ui.*;import laya.display.*; ";},'codeImportsJS',function(){return this.codeImportsJS="var View=laya.ui.View;\nvar Dialog=laya.ui.Dialog;";},'boxTypes',function(){return this.boxTypes=["Sprite","Box","List","Tab","RadioGroup","ViewStack","Panel","Tree","Vbox","Hbox"];},'pageTypes',function(){return this.pageTypes=["View","Dialog"];},'sceneTypes',function(){return this.sceneTypes=["Scene2D"];},'UiPaths',function(){return this.UiPaths=
			[
			"codeExportPath",
			"resExportPath",
			"asynResExportPath",
			"shareResPath",
			"uiExportPath",
			"codeType",
			"defaultFont",
			"uiType",
			"textureWidth",
			"textureHeight",
			"picWidth",
			"picHeight",
			"power2",
			"trimempty",
			"langPath",
			"picType"];}
		]);
		return ProjectSetting;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-3-18 上午11:14:51
	*/
	//class laya.ide.config.StyleConsts
	var StyleConsts1=(function(){
		function StyleConsts(){}
		__class(StyleConsts,'laya.ide.config.StyleConsts',null,'StyleConsts1');
		StyleConsts.FolderTxtColor="#c5c5c5";
		StyleConsts.ItemTxtColor="#c5c5c5";
		StyleConsts.ItemSelectColor="#ffffff";
		StyleConsts.MenuButtonLabelColor="#d2d2d2,#d2d2d2,#d2d2d2,#d2d2d2";
		StyleConsts.LayoutTabTitleBtnColor="#8a8a8a,#c8c8c8,#c8c8c8,#c8c8c8";
		StyleConsts.SkinBtnLabelColor="#44a7ff,#44a7ff,#44a7ff,#44a7ff";
		StyleConsts.CheckBoxLabelColors="#c5c5c5,#c5c5c5,#c5c5c5,#c5c5c5";
		StyleConsts.ComboBoxLabelColors="#c5c5c5,#c5c5c5,#c5c5c5,#c5c5c5";
		StyleConsts.PropPanelTitleColor="#44a7ff";
		StyleConsts.TextInputColor="#c5c5c5";
		StyleConsts.TextInputColorDefault="#525252,#ffffff,#efefef";
		StyleConsts.SelectItemInfoColor="#9f9f9f";
		StyleConsts.DefaultTextColor="#c5c5c5";
		StyleConsts.PanelTipTextColor="#00cc00";
		StyleConsts.PanelTipTextColor2="#cccc00";
		StyleConsts.ButtonLabelColors="#efefef,#ffffff,#c5c5c5,#c5c5c5";
		StyleConsts.BroswerButtonLabelColors="#c5c5c5,#c5c5c5,#c5c5c5";
		StyleConsts.RuleGridLineColor="#696969";
		StyleConsts.RuleGridTextColor="#696969";
		StyleConsts.RuleRangeColor="#dddddd";
		StyleConsts.TimelineTitleTxtColor="#d8d8d8";
		StyleConsts.fileNameRestrict="0-9a-zA-Z_";
		StyleConsts.NumberRestrict="0-9.-";
		StyleConsts.IntRestrict="0-9-";
		return StyleConsts;
	})()


	/**系统配置
	*@author yung
	*/
	//class laya.ide.config.SystemSetting
	var SystemSetting=(function(){
		function SystemSetting(){};
		__class(SystemSetting,'laya.ide.config.SystemSetting');
		SystemSetting.setProject=function(path){
			if (FileTools.exist(path)){
				SystemSetting.projectPath=path;
				SystemSetting.projectName=FileTools.getFileName(path).replace(".laya","");
				SystemSetting.workPath=FileTools.path.dirname(path);
				SystemSetting.workPath=FileTools.path.dirname(SystemSetting.workPath);
				SystemSetting.pagesPath=FileManager.getWorkPath("laya/pages");
				SystemSetting.assetsPath=FileManager.getWorkPath("laya/assets");
				SystemSetting.stylePath=FileManager.getWorkPath("laya/styles.xml");
				SystemSetting.pageStylePath=FileManager.getWorkPath("laya/pageStyles.xml");
				SystemSetting.tempPath=FileManager.getPath(FileTools.tempApp,"data/"+SystemSetting.projectName)
				FileManager.createDirectory(SystemSetting.pagesPath);
				FileManager.createDirectory(SystemSetting.assetsPath);
				FileManager.createDirectory(SystemSetting.tempPath);
			}
		}

		SystemSetting.workPath="";
		SystemSetting.appPath="";
		SystemSetting.projectName="";
		SystemSetting.projectPath="";
		SystemSetting.pagesPath="";
		SystemSetting.assetsPath="";
		SystemSetting.stylePath="";
		SystemSetting.pageStylePath="";
		SystemSetting.tempResPath="";
		SystemSetting.tempVerPath="";
		SystemSetting.tempPath="";
		SystemSetting.lang="";
		SystemSetting.ifShowRuleGrid=true;
		SystemSetting.toCodeModeWhenPublicEnd=false;
		SystemSetting.isCMDVer=false;
		return SystemSetting;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-11-26 上午10:04:47
	*/
	//class laya.ide.consts.FilterFuns
	var FilterFuns=(function(){
		function FilterFuns(){}
		__class(FilterFuns,'laya.ide.consts.FilterFuns');
		FilterFuns.isEditorComp=function(comp){
			if (comp !=null && Laya.__typeof(comp,'laya.ui.IComponent')&& comp["comXml"]){
				if((comp.parent instanceof laya.ui.Button )){
				}
				if(Laya.__typeof(comp.parent,'laya.ui.IBox'))
					return true;
			}
			return false;
		}

		FilterFuns.isEditorEnterAble=function(comp){
			if(!comp)return false;
			if(comp["comXml"]){
				if(DisplayTreePanel.AnyItemContains|| Laya.__typeof(comp,'laya.ui.IBox')){
					if(!FilterFuns.isEditorEnterAbleType(comp["comXml"].type))return false;
					return true;
				}
			}
			return false;
		}

		FilterFuns.isEditorEnterAbleType=function(type){
			if(TypeManager.UnEnterAbleType[type])return false;
			return true;
		}

		FilterFuns.isEditorSelectable=function(comp,ignoreLock,ignoreHide){
			(ignoreLock===void 0)&& (ignoreLock=false);
			(ignoreHide===void 0)&& (ignoreHide=false);
			var data;
			data=comp["comXml"];
			if(comp.name=="panelContent")return true;
			if(!data)return true;
			if(!ignoreLock){
				if(data.hasOwnProperty(Signs.LockSign)&&data[Signs.LockSign])return false;
			}
			if(!ignoreHide){
				if(data.hasOwnProperty(Signs.HideSign)&&data[Signs.HideSign])return false;
			}
			return true;
		}

		FilterFuns.isEditorSelectableChain=function(comp,ignoreLock,ignoreHide){
			(ignoreLock===void 0)&& (ignoreLock=false);
			(ignoreHide===void 0)&& (ignoreHide=false);
			if(!FilterFuns.isEditorSelectable(comp,ignoreLock,ignoreHide))return false;
			if(!comp.parent)return true;
			return FilterFuns.isEditorSelectableChain(comp.parent,ignoreLock,ignoreHide);
		}

		FilterFuns.isSpecialRes=function(url){
			if(url.indexOf("$")>0){
				return true;
			}
			if(url.indexOf(".DS_Store")>=0){
				return true;
			}
			return false;
		}

		FilterFuns.isShowResFile=function(url){
			return !FilterFuns.isSpecialRes(url);
		}

		FilterFuns.isUnAnimationAbleType=function(type){
			if(type=="List"||type=="Tree"){
				return true;
			}
			return false;
		}

		FilterFuns.getOnlyAnimationAbleNodes=function(arr){
			var i=0,len=0;
			var tNode;
			var safeNodes={};
			len=arr.length;
			var rst;
			rst=[];
			for(i=0;i<len;i++){
				if(arr[i].isAniNode){
					rst.push(arr[i]);
				}
			}
			return rst;
		}

		FilterFuns.findAnimationAbleNodes=function(parentNode,safeNodes){
			if(!parentNode)return;
			var tType;
			tType=parentNode.type;
		}

		return FilterFuns;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-8-4 上午10:12:53
	*/
	//class laya.ide.consts.IDEConsts
	var IDEConsts=(function(){
		function IDEConsts(){}
		__class(IDEConsts,'laya.ide.consts.IDEConsts');
		IDEConsts.cachePanels=false;
		IDEConsts.showRenderDebug=false;
		return IDEConsts;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-10-21 下午5:02:21
	*/
	//class laya.ide.consts.PageExportType
	var PageExportType=(function(){
		function PageExportType(){}
		__class(PageExportType,'laya.ide.consts.PageExportType');
		PageExportType.init=function(){
			PageExportType.typeList=["内嵌模式","加载模式","分离模式"];
			PageExportType.typeDic["内嵌模式"]=true;
			PageExportType.typeDic["加载模式"]=true;
			PageExportType.typeDic["分离模式"]=true;
		}

		PageExportType.isOKType=function(type){
			if(PageExportType.typeDic.hasOwnProperty(type))return true;
			return false;
		}

		PageExportType.isLoadType=function(type){
			return type=="分离模式"||type=="加载模式";
		}

		PageExportType.INCODE="内嵌模式";
		PageExportType.LOAD_PACK="加载模式";
		PageExportType.LOAD_ONE="分离模式";
		PageExportType.typeList=[];
		__static(PageExportType,
		['typeDic',function(){return this.typeDic={
		};}

		]);
		PageExportType.__init$=function(){
			;
			PageExportType.init();
		}

		return PageExportType;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.ide.consts.Paths
	var Paths=(function(){
		function Paths(){}
		__class(Paths,'laya.ide.consts.Paths');
		Paths.getLayoutFilePathByType=function(type){
			return "layout/"+type+".config";
		}

		Paths.getPluginPath=function(plugin){
			return FileManager.getPath(Paths.PluginPath,plugin+"/");
		}

		Paths.getPackParamFile=function(){
			return FileManager.getDataPath("packParam.json");
		}

		Paths.getConfigVarPath=function(){
			return FileManager.getDataPath("builder.cfg");
		}

		Paths.ParticleTmpGravity="laya/tpls/particle.json";
		Paths.ParticleTmpRadial="laya/tpls/particle1.json";
		Paths.ParticleTmp3D="laya/tpls/particle3d.json";
		Paths.ParticleTmpPoly="laya/tpls/particlepoly.json";
		Paths.ParticleTmpTexture="laya/tpls/texture.png";
		Paths.ParticleDefaultTextureName="texture.png";
		Paths.CustomUIConfigPath="renders/";
		Paths.IDESkinPath="h5/skins/";
		Paths.TemplateFolder="laya/template/";
		Paths.BasicsFolder="laya/basics/";
		Paths.TemplateDefaultIcon="laya/tpls/templateIcon.png";
		Paths.PluginPath="h5/plugins/";
		Paths.PluginConfigPath="plugin.cfg";
		Paths.CodeTemplatePath="codeTemplate/";
		Paths.AirTool="libs/LayaAirTool/LayaAirTool";
		Paths.IDEConfigFile="builder.xml";
		Paths.IDEConfigVars="builder.cfg";
		Paths.LogFile="log.txt";
		Paths.PackParamFile="packParam.json";
		Paths.LayoutFile_Default="layout/layout.config";
		Paths.LayoutFile_Static="laya/tpls/default.config";
		__static(Paths,
		['JSCodeTemplate',function(){return this.JSCodeTemplate="codeTemplate/"+"jsCodeTpl.txt";},'JSCodePreTemplate',function(){return this.JSCodePreTemplate="codeTemplate/"+"jsCodePre.txt";},'TSCodeTemplate',function(){return this.TSCodeTemplate="codeTemplate/"+"tsCodeTpl.txt";},'TSCodePreTemplate',function(){return this.TSCodePreTemplate="codeTemplate/"+"tsCodePre.txt";},'ASCodeTemplate',function(){return this.ASCodeTemplate="codeTemplate/"+"asCodeTpl.txt";},'ASCodeTemplate2',function(){return this.ASCodeTemplate2="codeTemplate/"+"asCodeTpl2.txt";},'ASBase64Template',function(){return this.ASBase64Template="codeTemplate/"+"asBase64Tpl.txt";}
		]);
		return Paths;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-11-25 上午11:08:41
	*/
	//class laya.ide.consts.Signs
	var Signs=(function(){
		function Signs(){}
		__class(Signs,'laya.ide.consts.Signs');
		Signs.LockSign="$LOCKED";
		Signs.HideSign="$HIDDEN";
		Signs.NodeTypeSign="renderType";
		return Signs;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.ide.consts.SkinDefines
	var SkinDefines=(function(){
		function SkinDefines(){}
		__class(SkinDefines,'laya.ide.consts.SkinDefines');
		SkinDefines.DisDragIcon="comp/clip_folder.png";
		SkinDefines.PageDragIcon="comp/clip_folder.png";
		SkinDefines.ResDragIcon="comp/clip_folder.png";
		SkinDefines.LayoutRecDragIcon="comp/clip_folder.png";
		SkinDefines.LayoutTabDragIcon="comp/clip_folder.png";
		return SkinDefines;
	})()


	/**
	*本地程序调用封装
	*@author ww
	*@version 1.0
	*
	*@created 2015-10-30 下午3:27:37
	*/
	//class laya.ide.devices.CMDShell
	var CMDShell=(function(){
		function CMDShell(){}
		__class(CMDShell,'laya.ide.devices.CMDShell');
		CMDShell.init=function(){
			CMDShell.childProcess=Device.requireRemote("child_process");
			CMDShell.iconv=Device.requireRemote('iconv-lite');
		}

		CMDShell.exeFile=function(fileName,param,callBack){
			CMDShell.childProcess.execFile(fileName,param,callBack);
		}

		CMDShell.execute=function(cmd,callBack,option){
			console.log("execute:",cmd);
			if(!option){
				option={encoding:"binary",maxBuffer:1024*1024*20};
			}
			CMDShell.childProcess.exec(cmd,option,callBack);
		}

		CMDShell.callBackTmp=function(err,stdOut,stdErr){
			console.log("err:",err);
			console.log("stdErr:",stdErr);
			console.log("stdOut:",CMDShell.iconv.decode(stdOut,"gbk"));
		}

		CMDShell.executeExtra=function(cmd,callBack){
			CMDShell.childProcess.exec(cmd,{encoding:"binary",maxBuffer:1024*1024*20},callBackTmp=function(err,stdOut,stdErr){
				console.log("err:",err);
				console.log("stdErr:",stdErr);
				callBack(CMDShell.iconv.decode(stdOut,"gbk"));
			});
		}

		CMDShell.decode=function(data,type){
			return CMDShell.iconv.decode(data,type);
		}

		CMDShell.childProcess=null
		CMDShell.iconv=null
		return CMDShell;
	})()


	/**
	*封装所有驱动级接口
	*@author yung
	*/
	//class laya.ide.devices.Device
	var Device=(function(){
		function Device(){};
		__class(Device,'laya.ide.devices.Device');
		Device.init=function(){
			Device.electron=Device.require("electron");
			Device.remote=Device.electron.remote;
			Device.app=Device.requireRemote('app');
			Device.dataPath=Device.app.getDataPath();
			Device.Buffer=Browser.window.Buffer;
			Device.appPath=Device.app.getPath("appData")+"/"+Device.appName;
			Device.tempPath=Device.app.getPath("temp")+"/"+Device.appName;
			Device.userHome=Device.app.getPath("home")+"/"+Device.appName;
			Device.extensionPath=Device.app.getPath("home")+"/"+".laya/plugins/";
			Sys.log("appPath:",Device.appPath);
			Sys.log("extensionPath:",Device.extensionPath);
			Paths.PluginPath=Device.extensionPath;
			Device.app.on('quit',function(){
				console.log("quit from app");
			});
		}

		Device.winFun=function(fun){
			if(!Device.win){
				Device.win=Device.remote.getCurrentWindow();
			}
			Device.win[fun]();
		}

		Device.require=function(mod){
			var rst;
			rst=require(mod);
			return rst;
		}

		Device.requireRemote=function(mod){
			if (!Device.remote)return Device.require(mod);
			return Device.remote.require(mod);
		}

		Device.app=null
		Device.appName="LayaAir";
		Device.appPath=null
		Device.dataPath=null
		Device.tempPath=null
		Device.workPath=null
		Device.userHome=null
		Device.extensionPath=null
		Device.remote=null
		Device.Buffer=null
		Device.electron=null
		Device.win=null
		return Device;
	})()


	/**
	*本类封装弹出本地对话框
	*@author ww
	*/
	//class laya.ide.devices.DialogTools
	var DialogTools=(function(){
		function DialogTools(){}
		__class(DialogTools,'laya.ide.devices.DialogTools');
		DialogTools.init=function(){
			DialogTools.dialog=Device.requireRemote("dialog");
		}

		DialogTools.showOpenDialog=function(win,options,callBack){
			DialogTools.dialog.showOpenDialog(win,options,callBack);
		}

		DialogTools.showSaveDialog=function(win,options,callBack){
			DialogTools.dialog.showSaveDialog(win,options,callBack);
		}

		DialogTools.showSave=function(title,fileName,callBack){
			var option={
				title:title,
				defaultPath:fileName,
				filters:[],
				properties:[]
			};
			DialogTools.showSaveDialog(null,option,callBack);
		}

		DialogTools.showMessageBox=function(win,options,callBack){
			DialogTools.dialog.showMessageBox(win,options,callBack);
		}

		DialogTools.showErrorBox=function(title,content){
			DialogTools.dialog.showErrorBox(title,content);
		}

		DialogTools.getOpenDirO=function(title,defaultPath){
			(title===void 0)&& (title="open Dir");
			var rst;
			rst={title:title,properties:["openDirectory"]};
			if(defaultPath!=null){
				rst.defaultPath=defaultPath;
			}
			return rst;
		}

		DialogTools.getOpenProO=function(title,extension){
			(title===void 0)&& (title="open Project");
			(extension===void 0)&& (extension="laya");
			return {title:title,filters:[{name:'*.'+extension,extensions:[extension]}]};
		}

		DialogTools.showOpenDir=function(title,callBack,defaultPath){
			(title===void 0)&& (title="open Dir");
			DialogTools.showOpenDialog(null,DialogTools.getOpenDirO(title,defaultPath),callBack);
		}

		DialogTools.showOpenFile=function(title,callBack,filter,defaultPath){
			(title===void 0)&& (title="open file");
			if (!filter)filter=DialogTools.filterO;
			filter.title=title;
			if(defaultPath){
				filter.defaultPath=defaultPath;
			}
			DialogTools.showOpenDialog(null,filter,callBack);
		}

		DialogTools.getOpenParticleO=function(title){
			(title===void 0)&& (title="open Particle");
			return {title:title,filters:[{name:'*.json',extensions:['json']}]};
		}

		DialogTools.dialog=null
		__static(DialogTools,
		['tempOptionO',function(){return this.tempOptionO={
				title:"",
				defaultPath:null,
				filters:[],
				properties:[]
		};},'imgFilterO',function(){return this.imgFilterO={title:"open Img",filters:[{name:'Images',extensions:['jpg','png']}]};},'filterO',function(){return this.filterO={title:"open file",filters:[{name:'Images',extensions:['jpg','png','gif']},{name:'Movies',extensions:['mkv','avi','mp4']},{name:'Custom File Type',extensions:['as']},{name:'All Files',extensions:['*']}]};}

		]);
		return DialogTools;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.ide.devices.File
	var File=(function(){
		function File(path){
			this.nativePath=null;
			this.nativePath=path;
		}

		__class(File,'laya.ide.devices.File');
		var __proto=File.prototype;
		__proto.copyTo=function(path,overwrite){
			(overwrite===void 0)&& (overwrite=false);
			FileTools.copyE(this.nativePath,path);
		}

		__proto.deleteFile=function(){
			FileTools.removeE(this.nativePath);
		}

		__proto.moveToTrash=function(){
			this.deleteFile();
		}

		__proto.getRelativePath=function(path){
			return FileTools.getRelativePath(this.nativePath,path);
		}

		__proto.moveTo=function(path,overwrite){
			(overwrite===void 0)&& (overwrite=false);
			FileTools.rename(this.nativePath,path);
		}

		__proto.resolvePath=function(path){
			return new File(FileTools.getPath(this.nativePath,path));
		}

		__getset(0,__proto,'extension',function(){
			return FileTools.getExtensionName(this.nativePath);
		});

		__getset(0,__proto,'isDirectory',function(){
			return FileTools.isDirectory(this.nativePath);
		});

		__getset(0,__proto,'parent',function(){
			return new File(FileTools.getParent(this.nativePath));
		});

		__getset(0,__proto,'exists',function(){
			return FileTools.exist(this.nativePath);
		});

		__getset(0,__proto,'name',function(){
			return FileTools.getFileNameWithExtension(this.nativePath);
		});

		__static(File,
		['applicationDirectory',function(){return this.applicationDirectory=new File("");},'applicationStorageDirectory',function(){return this.applicationStorageDirectory=new File("");},'userDirectory',function(){return this.userDirectory=new File("");}
		]);
		return File;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.ide.devices.FileTools
	var FileTools=(function(){
		function FileTools(){}
		__class(FileTools,'laya.ide.devices.FileTools');
		__getset(1,FileTools,'appPath',function(){
			var rst;
			var dirName;
			dirName=__dirname;;
			rst=FileTools.path.resolve(dirName,"../");
			return rst;
			var aPath;
			aPath=Browser.window.location.href;
			aPath=aPath.replace("file:///","");
			aPath=aPath.replace("/h5/index.html","");
			aPath=aPath.split("index.")[0];
			aPath=decodeURI(aPath);
			return aPath;
		});

		__getset(1,FileTools,'workPath',function(){
			return "workPath";
		});

		FileTools.init=function(){
			FileTools.fs=Device.require("fs");
			FileTools.path=Device.require("path");
			FileTools.shell=Device.requireRemote("shell");
			FileTools.tempApp=Device.remote.app.getDataPath();
		}

		FileTools.init2=function(){
			FileTools.fs=Device.require("fs");
			FileTools.path=Device.require("path");
		}

		FileTools.getSep=function(){
			return FileTools.path.sep;
		}

		FileTools.getAbsPath=function(path){
			return path;
		}

		FileTools.isAbsPath=function(path){
			if(!path)return false;
			if(path.indexOf(":")>0)return true;
			if(path.substr(0,1)=="/")return true;
			return false;
		}

		FileTools.getPath=function(basePath,relativePath){
			return FileTools.path.join(basePath,relativePath);
		}

		FileTools.getRelativePath=function(basePath,targetPath){
			return FileTools.path.relative(basePath,targetPath);
		}

		FileTools.getAppPath=function(path){
			return FileTools.getPath(FileTools.appPath,path);
		}

		FileTools.getAppRelativePath=function(path){
			return FileTools.getRelativePath(FileTools.appPath,path);
		}

		FileTools.getWorkPath=function(path){
			return FileTools.getPath(FileTools.workPath,path);
		}

		FileTools.getWorkRelativePath=function(path){
			return FileTools.getRelativePath(FileTools.workPath,path);
		}

		FileTools.getFileDir=function(path){
			if (!path)return path;
			if(laya.ide.devices.FileTools.isDirectory(path))return path;
			return laya.ide.devices.FileTools.path.dirname(path);
		}

		FileTools.getParent=function(path){
			if (!path)return path;
			var lasti=0;
			lasti=path.lastIndexOf(laya.ide.devices.FileTools.path.sep);
			return path.substring(0,lasti);
		}

		FileTools.getFileName=function(path){
			return FileManager.getFileName(path);
		}

		FileTools.getFileNameWithExtension=function(path){
			if (path==null)
				return null;
			var a=path.split(laya.ide.devices.FileTools.path.sep);
			var file=a[a.length-1];
			return file;
		}

		FileTools.getExtensionName=function(path){
			if (path==null)
				return null;
			var a=path.split(".");
			var file=a[a.length-1];
			return file;
		}

		FileTools.createDirectory=function(path){
			if (Boolean(path)){
				FileTools.ensurePath(path);
				if (!FileTools.fs.existsSync(path)){
					FileTools.fs.mkdirSync(path);
				}
			}
		}

		FileTools.ensurePath=function(pathStr){
			FileTools.mkdirsSync(pathStr,null);
			return;
			if (pathStr==null)return;
			var sep;
			sep=FileTools.path.sep;
			var a=pathStr.split(sep);
			var i=0,len=0;
			var tPath;
			tPath=a[0];
			len=a.length-1;
			for (i=1;i < len;i++){
				tPath+=sep+a[i];
				if (!FileTools.exist(tPath)){
					FileTools.createDirectory(tPath);
				}
			}
		}

		FileTools.mkdirsSync=function(dirpath,mode){
			if (!FileTools.fs.existsSync(dirpath)){
				var pathtmp;
				var pathParts=dirpath.split(FileTools.path.sep);
				pathParts.pop();
				var onWindows=Browser.userAgent.indexOf("Windows")>-1;
				if(!onWindows){
					pathtmp="/"+pathParts[1];
					pathParts.splice(0,2);
				}
				pathParts.forEach(function(dirname){
					if (pathtmp){
						pathtmp=FileTools.path.join(pathtmp,dirname);
					}
					else {
						pathtmp=dirname;
					}
					if (!FileTools.fs.existsSync(pathtmp)){
						if (!FileTools.fs.mkdirSync(pathtmp,mode)){
							return false;
						}
					}
				});
			}
			return true;
		}

		FileTools.createFile=function(path,value){
			FileTools.ensurePath(path);
			FileTools.fs.writeFileSync(path,value);
		}

		FileTools.toBuffer=function(ab){
			var buffer=new Device.Buffer(ab.byteLength);
			var view=new Uint8Array(ab);
			for (var i=0;i < buffer.length;++i){
				buffer[i]=view[i];
			}
			return buffer;
		}

		FileTools.readFile=function(path,encoding){
			(encoding===void 0)&& (encoding="utf8");
			if (FileTools.fs.existsSync(path)){
				var rst;
				rst=FileTools.fs.readFileSync(path,encoding);
				if(((typeof rst=='string'))&&rst.charCodeAt(0)==65279&&encoding=="utf8"){
					rst=rst.substr(1);
				}
				return rst;
			}
			return null;
		}

		FileTools.appendFile=function(path,data){
			FileTools.fs.appendFileSync(path,data);
		}

		FileTools.moveToTrash=function(path){
			if (FileTools.exist(path)){
				if (FileTools.shell){
					FileTools.shell.moveItemToTrash(path);
					}else{
					FileTools.removeE(path,false);
				}
			}
		}

		FileTools.removeFile=function(path,toTrash){
			(toTrash===void 0)&& (toTrash=true);
			if (toTrash){
				FileTools.moveToTrash(path);
				return;
			}
			if (Boolean(path)){
				FileTools.fs.unlinkSync(path)
			}
		}

		FileTools.removeE=function(path,toTrash){
			(toTrash===void 0)&& (toTrash=true);
			if (!FileTools.exist(path))
				return;
			if (FileTools.isDirectory(path)){
				FileTools.removeDir(path,toTrash);
			}
			else{
				FileTools.removeFile(path,toTrash);
			}
		}

		FileTools.removeDir=function(path,toTrash){
			(toTrash===void 0)&& (toTrash=true);
			if (toTrash){
				FileTools.moveToTrash(path);
				return;
			};
			var files=[];
			if (FileTools.fs.existsSync(path)){
				files=FileTools.fs.readdirSync(path);
				files.forEach(function(file,index){
					var curPath=FileTools.getPath(path,file);
					if (FileTools.fs.statSync(curPath).isDirectory()){
						FileTools.removeDir(curPath);
					}
					else{
						FileTools.fs.unlinkSync(curPath);
					}
				});
				FileTools.fs.rmdirSync(path);
			}
		}

		FileTools.exist=function(path){
			if(!path)return false;
			return FileTools.fs.existsSync(path);
		}

		FileTools.isDirectory=function(path){
			var st;
			try{
				st=FileTools.fs.statSync(path);
				}catch(e){
				return false;
			}
			if(!st)return false;
			return st.isDirectory();
		}

		FileTools.getStat=function(path){
			return FileTools.fs.statSync(path);
		}

		FileTools.getMTime=function(path){
			return FileTools.getStat(path).mtime;
		}

		FileTools.watch=function(path,callBack){
			FileTools.watcherDic[path]=FileTools.fs.watch(path,callBack);
			return FileTools.watcherDic[path];
		}

		FileTools.isDirWatched=function(path){
			return FileTools.watcherDic.hasOwnProperty(path);
		}

		FileTools.unwatch=function(path){
			if (FileTools.watcherDic[path]){
				FileTools.watcherDic[path].close();
				delete FileTools.watcherDic[path];
			}
		}

		FileTools.copyE=function(from,to){
			if (!FileTools.exist(from))
				return;
			if (FileTools.isDirectory(from)){
				FileTools.copyDir(from,to);
			}
			else{
				FileTools.copyFile(from,to);
			}
		}

		FileTools.copyFile=function(from,to){
			FileTools.createFile(to,FileTools.readFile(from,null));
		}

		FileTools.copyDir=function(from,to){
			var files=[];
			if (FileTools.fs.existsSync(from)){
				FileTools.createDirectory(to);
				files=FileTools.fs.readdirSync(from);
				files.forEach(function(file,index){
					var curPath=FileTools.getPath(from,file);
					var tPath=FileTools.getPath(to,file);
					if (FileTools.fs.statSync(curPath).isDirectory()){
						FileTools.copyDir(curPath,tPath);
					}
					else{
						FileTools.copyFile(curPath,tPath);
					}
				});
			}
		}

		FileTools.walk=function(path,floor,handleFile,self){
			(self===void 0)&& (self=false);
			if(self)
				handleFile(path,floor);
			floor++;
			var files=FileTools.fs.readdirSync(path);
			files.forEach(function(item){
				var tmpPath=FileTools.getPath(path,item);
				if (tmpPath.indexOf(".svn")>-1)
					return;
				var stats=FileTools.fs.statSync(tmpPath);
				if (stats.isDirectory()){
					FileTools.walk(tmpPath,floor,handleFile);
				}
				else{
					handleFile(tmpPath,floor);
				}
			});
		}

		FileTools.getFileList=function(path){
			var arr=[];
			if(!laya.ide.devices.FileTools.exist(path))return arr;
			FileTools.walk(path,0,findFiles);
			function findFiles (spath,floor){
				arr.push(spath);
			}
			return arr;
		}

		FileTools.getFileDesO=function(path){
			if (!FileTools.exist(path))
				return null;
			var rst={};
			rst.label=FileTools.getFileName(path);
			rst.path=path;
			if (FileTools.isDirectory(path)){
				rst.files=[];
				rst.dirs=[];
				rst.childs=[];
				rst.isDirectory=true;
				}else{
				rst.isDirectory=false;
			}
			return rst;
		}

		FileTools.getDirChildDirs=function(p){
			var files=laya.ide.devices.FileTools.getDirFiles(p);
			var i=0,len=0;
			var rst;
			rst=[];
			len=files.length;
			for(i=0;i<len;i++){
				files[i]=FileTools.path.join(p,files[i]);
				if(laya.ide.devices.FileTools.isDirectory(files[i])){
					rst.push(files[i]);
				}
			}
			return rst;
		}

		FileTools.getDirFiles=function(path){
			var rst;
			rst=FileTools.fs.readdirSync(path);
			rst.sort(FileTools.folderFirst);
			return rst;
		}

		FileTools.folderFirst=function(pathA,pathB){
			var isFolderA=false;
			isFolderA=pathA.indexOf(".")<0;
			var isFolderB=false;
			isFolderB=pathB.indexOf(".")<0;
			var right=-1;
			if(isFolderA){
				if(!isFolderB){
					return right;
				}
				return pathA<pathB?right:-right;
			}
			if(isFolderB){
				return-right;
			}
			return pathA<pathB?right:-right;
		}

		FileTools.getFileTreeArr=function(path){
			var tTreeO=FileTools.getFileTreeO(path);
			var rst=[];
			FileTools.getTreeArr(tTreeO,rst,false);
			return rst;
		}

		FileTools.getTreeArr=function(treeO,arr,add){
			(add===void 0)&& (add=true);
			if(add)
				arr.push(treeO);
			var tArr=treeO.childs;
			var i=0,len=tArr.length;
			for(i=0;i<len;i++){
				if(!add){
					tArr[i].nodeParent=null;
				}
				if(tArr[i].isDirectory){
					FileTools.getTreeArr(tArr[i],arr);
					}else{
					arr.push(tArr[i]);
				}
			}
		}

		FileTools.getFileTreeO=function(path){
			var rst=FileTools.getFileDesO(path);
			if (FileTools.fs.existsSync(path)){
				var files=FileTools.getDirFiles(path);
				var tO;
				files.forEach(function(file,index){
					var curPath=FileTools.getPath(path,file);
					if (FileTools.fs.statSync(curPath).isDirectory()){
						tO=FileTools.getFileTreeO(curPath);
						tO.nodeParent=rst;
						tO.hasChild=tO.childs.length > 0;
						rst.dirs.push(tO);
					}
					else{
						tO=FileTools.getFileDesO(curPath);
						tO.nodeParent=rst;
						tO.hasChild=false;
						rst.files.push(tO);
					}
					tO.label=file;
					rst.childs.push(tO);
				});
				rst.hasChild=rst.childs.length > 0;
			}
			return rst;
		}

		FileTools.isPathSame=function(a,b){
			if(a.toLocaleLowerCase()==b.toLocaleLowerCase())return true;
			return false;
		}

		FileTools.rename=function(oldPath,newPath){
			if (!FileTools.exist(oldPath))
				return;
			if(FileTools.isPathSame(oldPath,newPath)){
				Alert.show("在移动文件到同一个位置！！");
				return;
			}
			FileTools.copyE(oldPath,newPath);
			FileTools.moveToTrash(oldPath);
			return;
			FileTools.fs.renameSync(oldPath,newPath);
		}

		FileTools.openItem=function(path){
			FileTools.shell.openItem(path);
		}

		FileTools.showItemInFolder=function(path){
			FileTools.shell.showItemInFolder(path);
		}

		FileTools.getFolder=function(path){
			path=FileManager.adptToCommonUrl(path);
			var idx=0;
			idx=path.lastIndexOf(".");
			if(idx>=0){
				idx=path.lastIndexOf("/",idx);
				if(idx>=0){
					path=path.substr(0,idx);
				}
			}
			return path;
		}

		FileTools.win=null
		FileTools.fs=null
		FileTools.path=null
		FileTools.shell=null
		FileTools.tempApp=null
		FileTools.watcherDic={};
		return FileTools;
	})()


	/**
	*本类用于和主进程通讯
	*@author ww
	*/
	//class laya.ide.devices.IPCTools
	var IPCTools=(function(){
		function IPCTools(){}
		__class(IPCTools,'laya.ide.devices.IPCTools');
		IPCTools.init=function(){
			IPCTools.ipc=Device.electron.ipcRenderer;
			IPCTools.ipc.on("message",function(__args){
				var args=arguments;
				console.log("message:",args);
			})
			IPCTools.ipc.on("tryOpen",function(__args){
				var args=arguments;
				var path;
				path=args[0];
				console.log("tryOpen:",path);
				if(FileTools.getExtensionName(path)=="laya"){
					Laya.timer.once(2000,null,ProjectManager.loadProject,[path]);
				}
			})
			IPCTools.ipc.on('openWork',function(event,message){
				SystemDragOverManager.handlerFile(message);
			})
		}

		IPCTools.send=function(type,data){
			IPCTools.ipc.send("message",type,data);
		}

		IPCTools.cmd=function(funName,param){
			var data={};
			data.type;
			data.funName=funName;
			data.param=param;
			IPCTools.send("cmd",data);
		}

		IPCTools.setWindow=function(){
			var data={};
			data.type="ccc";;
			IPCTools.send("window",Browser.window);
			console.log(data);
		}

		IPCTools.ipc=null
		return IPCTools;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.ide.devices.OSInfo
	var OSInfo=(function(){
		function OSInfo(){}
		__class(OSInfo,'laya.ide.devices.OSInfo');
		OSInfo.init=function(){
			OSInfo.os=Device.require("os");
			OSInfo.platform=OSInfo.os.platform();
			OSInfo.tempdir=OSInfo.os.tmpdir();
			OSInfo.type=OSInfo.os.type();
			var tProcess;
			tProcess=process;;
			OSInfo.process=tProcess;
			OSInfo.env=OSInfo.process.env;
			console.log("type:",OSInfo.type);
		}

		OSInfo.os=null
		OSInfo.platform=null
		OSInfo.homedir=null
		OSInfo.tempdir=null
		OSInfo.type=null
		OSInfo.process=null
		OSInfo.env=null
		return OSInfo;
	})()


	/**
	*本类集中定义IDE中的各种事件
	*@author ww
	*/
	//class laya.ide.event.IDEEvent
	var IDEEvent=(function(){
		function IDEEvent(){}
		__class(IDEEvent,'laya.ide.event.IDEEvent');
		IDEEvent.emitKeyEvent=function(keyCode,ctrl,shift){
			(ctrl===void 0)&& (ctrl=false);
			(shift===void 0)&& (shift=false);
			var evt;
			evt={};
			evt.keyCode=keyCode;
			evt.ctrlKey=ctrl;
			evt.shiftKey=ctrl;
			Notice1.notify("IDEKey_Event",evt);
		}

		IDEEvent.RELEASE_PROJECT="Release_Project";
		IDEEvent.RES_ITEM_CLICK="ResItemClick";
		IDEEvent.OPEN_ADDPARTICLE="open_AddParticle";
		IDEEvent.ADD_PARTICLE="AddParticle";
		IDEEvent.OPEN_ADDPAGE="OPEN_ADDPage";
		IDEEvent.ADD_PAGE="ADDPage";
		IDEEvent.ADD_SCRIPT="addScript";
		IDEEvent.OPEN_ADD_TIMELINE_ANIMATION="OPEN_ADD_TIMELINE_ANIMATION";
		IDEEvent.ADD_TIMELINE_ANIMATION="ADDTimeLineAnimation";
		IDEEvent.CLOSE_PAGE="closePage";
		IDEEvent.OPEN_PAGE="openPAGE";
		IDEEvent.FOCUS_DESIGN="Focus_design";
		IDEEvent.FRESH_RES="FRESH_RES";
		IDEEvent.FRESH_PAGE="FRESH_Page";
		IDEEvent.FRESH_CURVIEW="FRESH_CurView";
		IDEEvent.FRESH_PICCHANGED="Fresh_picChanged";
		IDEEvent.OPEN_ADDDIR="open_adddir";
		IDEEvent.ADD_DIR="adddir";
		IDEEvent.OPEN_ADDSCENE="OPEN_ADDSCENE";
		IDEEvent.ADD_SCENE="ADDSCENE";
		IDEEvent.OPEN_MOVEPAGE="OPEN_MovePage";
		IDEEvent.OPEN_BASICSPANEL="Open_BasicsPanel";
		IDEEvent.MOVE_PAGE="MovePage";
		IDEEvent.OPEN_RENAME="OPEN_RENAME";
		IDEEvent.RENAME_PAGE="RENAME_PAGE";
		IDEEvent.OPEN_SETPAGEPROP="OPEN_SEtPageProp";
		IDEEvent.PROPPANEL_SETBYOBJ="PropPanel_setByObj";
		IDEEvent.PROPPANEL_INITBYOBJ="PROPPANEL_InitBYOBJ";
		IDEEvent.PROP_CHANGE="Prop_change";
		IDEEvent.PROP_CHANGEING="Prop_changeing";
		IDEEvent.PROP_CHANGED="Prop_Changed";
		IDEEvent.CUTOFF_PREFAB="CutOff_Prefab";
		IDEEvent.DROP_RENDER="DROP_RENDER";
		IDEEvent.PAGE_CHANGED="pageChanged";
		IDEEvent.IDE_QUIT="IDE_QUIT";
		IDEEvent.RESFILE_CHANGE="RESFILE_CHANGE";
		IDEEvent.SHOW_DISPLAY_TREE="SHOW_DISPLAY_TREE";
		IDEEvent.DISPLAY_SELECTED="Display_selected";
		IDEEvent.DISPLAY_MULTISELECTED="Display_multiSelected";
		IDEEvent.SELECT_CHANGED="select_changed";
		IDEEvent.DISPLAY_ENTER="Display_Enter";
		IDEEvent.DELETE_SELECTED="DELETE_SELECTED";
		IDEEvent.DISPLAY_CUT="Display_Cut";
		IDEEvent.DISPLAY_COPY="DISPLAY_Copy";
		IDEEvent.DISPLAY_PASTE="DISPLAY_Paste";
		IDEEvent.ADD_NODE="AddNode";
		IDEEvent.ADD_NODE_BY_DRAGDROP="Add_node_byDragDrop";
		IDEEvent.DISPLAY_TRANSPARENT="Display_transParent";
		IDEEvent.DISPLAYTREE_DRAGDROP="DisplayTree_dragDrop";
		IDEEvent.DISPLAY_VALUE_CHANGE="display_value_changes";
		IDEEvent.DISPLAY_TREE_CHANGE="Display_tree_change";
		IDEEvent.TIMELINE_FRAME_SELECTED="TimeLineFrameSelected";
		IDEEvent.RECORD_KEYFRAME="RECORD_KEYFRAME";
		IDEEvent.DESIGN_ITEM_SELECTED="DesignItemSelected";
		IDEEvent.CLEAR_DESIGN_SELECT="ClearDesignSelect";
		IDEEvent.TIMELINE_CHANGED="TimeLine_changed";
		IDEEvent.TO_ANIMATION_MODE="To_AnimationMode";
		IDEEvent.TO_DESIGN_MODE="To_designMode";
		IDEEvent.FRESH_ANIMATIONDATA="Fresh_animationData";
		IDEEvent.ANIMATIONMODE_CHANGE="AnimationMode_Change";
		IDEEvent.ADD_ANIMATIONNODE="Add_animationNode";
		IDEEvent.PLAYCONTROL_TOBEGINPOS="PlayControl_ToBeginPos";
		IDEEvent.PLAYCONTROL_PRE="PLAYCONTROL_Pre";
		IDEEvent.PLAYCONTROL_PLAY="PLAYCONTROL_Play";
		IDEEvent.PLAYCONTROL_NEXT="PLAYCONTROL_Next";
		IDEEvent.PLAYCONTROL_TOENDPOS="PLAYCONTROL_TOEndPOS";
		IDEEvent.PLAYCONTROL_STOP="PLAYCONTROL_Stop";
		IDEEvent.PLAYCONTROL_SWITCHPLAY="PLAYCONTROL_SwitchPlay";
		IDEEvent.UIChange="UIChange";
		IDEEvent.FRESH_COMPPANEL="Fresh_CompPanel";
		IDEEvent.SHOW_RULE_RANGE="SHOW_RULE_RANGE";
		IDEEvent.CLEAR_RULE_RANGE="Clear_RULE_RANGE";
		IDEEvent.RULE_SHOW_CHANGE="RULE_SHOW_CHANGE";
		IDEEvent.OPEN_LANGPANEL="LangPanel";
		IDEEvent.OPEN_IDESETTING="OPEN_IDESETTING";
		IDEEvent.IDEKEY_EVENT="IDEKey_Event";
		IDEEvent.SELECT_RES_FILE="SelecteResFile";
		IDEEvent.SHOW_LAYOUTTAB_BY_NAME="SHOW_LayoutTab_By_Name";
		IDEEvent.FIND_RES_REFER="findResRefer";
		IDEEvent.REPLACE_SELECTEDCOMPS="REPLACE_SELECTEDCOMPS";
		IDEEvent.SELECT_INPUT="SELECTE_INPUT";
		return IDEEvent;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-6-12 下午7:47:10
	*/
	//class laya.ide.event.IDEVars
	var IDEVars=(function(){
		function IDEVars(){}
		__class(IDEVars,'laya.ide.event.IDEVars');
		__getset(1,IDEVars,'isGraphicAnimationMode',function(){
			if(UIPanel.instance.currViewer&&TypeManager.getFileType(UIPanel.instance.currViewer.pagePath)=="graphic_animation"){
				return true;
			}
			return false;
		});

		IDEVars.isAnimationEditMode=false;
		return IDEVars;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-10-21 上午11:49:37
	*/
	//class laya.ide.hook.MouseHook
	var MouseHook=(function(){
		function MouseHook(){
			this._isLeftMouse=false;
			this._event=null;
			this._target=null;
		}

		__class(MouseHook,'laya.ide.hook.MouseHook');
		var __proto=MouseHook.prototype;
		__proto.onMouseDown=function(ele){
			if(Laya.stage.focus&&!(DisControlTool.isChildE(Laya.stage.focus,this._target))){
				IDEAPIS.unFocusInput();
			}
			MouseHook._preMouseDown.call(MouseManager.instance,ele);
		}

		MouseHook.hook=function(){
			return;
			MouseHook._preMouseDown=MouseManager.instance["onMouseDown"];
			MouseManager.instance["onMouseDown"]=MouseHook.I.onMouseDown;
		}

		MouseHook._preMouseDown=null
		__static(MouseHook,
		['I',function(){return this.I=new MouseHook();}
		]);
		return MouseHook;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-8-3 上午10:16:07
	*/
	//class laya.ide.managers.CanvasViewsManager
	var CanvasViewsManager=(function(){
		function CanvasViewsManager(){
			this.dialogContainer=null;
		}

		__class(CanvasViewsManager,'laya.ide.managers.CanvasViewsManager');
		var __proto=CanvasViewsManager.prototype;
		__proto.init=function(){
			return;
			this.dialogContainer=new CanvasView(Laya.stage.width,Laya.stage.height);
			this.dialogContainer.canvas.source.id="dialogContainer";
			this.dialogContainer.addChild(Dialog.manager);
			this.dialogContainer.float(0,0);
			JSTools.setZIndex(this.dialogContainer.canvas.source,100);
			Dialog.manager.on("close",this,this.dialogClose);
			Dialog.manager.on("open",this,this.dialogOpen);
		}

		__proto.dialogClose=function(){
			if(Dialog.manager.numChildren==1&&Dialog.manager.dialogLayer.numChildren<1){
				JSTools.removeElement(this.dialogContainer.canvas.source);
			}
		}

		__proto.dialogOpen=function(){
			Browser.document.body.appendChild(this.dialogContainer.canvas.source);
		}

		__static(CanvasViewsManager,
		['I',function(){return this.I=new CanvasViewsManager();}
		]);
		return CanvasViewsManager;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-3-22 下午7:37:47
	*/
	//class laya.ide.managers.CodeViewManager
	var CodeViewManager=(function(){
		function CodeViewManager(){
			if(!CodeViewManager.codeDiv){
				CodeViewManager.init();
			}
		}

		__class(CodeViewManager,'laya.ide.managers.CodeViewManager');
		var __proto=CodeViewManager.prototype;
		__proto.setZIndex=function(index){
			if(!CodeViewManager.style)return;
			CodeViewManager.style["z-index"]=index;
		}

		__proto.show=function(){
			this.setZIndex(9);
			CodeViewManager.showed=true;
		}

		__proto.hide=function(){
			this.setZIndex(-1);
			CodeViewManager.showed=false;
		}

		CodeViewManager.init=function(){
			CodeViewManager.codeDiv=Browser.window["layaEditor"];
			if(!CodeViewManager.codeDiv)return;
			CodeViewManager.style=CodeViewManager.codeDiv.style;
			CodeViewManager.style["z-index"]=9;
			CodeViewManager.style["position"]="absolute";
			CodeViewManager.adpt();
		}

		CodeViewManager.openFile=function(file){
			if(!CodeViewManager.codeDiv)return;
			Browser.window["openFile"](file);
		}

		CodeViewManager.sizeDiv=function(width,height){
			if(!CodeViewManager.codeDiv)return;
			Browser.window["windowLayout"](width,height);
		}

		CodeViewManager.adpt=function(){
			if(!CodeViewManager.codeDiv)return;
			var pos=new Point();
			pos=UIPanel.instance.localToGlobal(pos);
			var dLen=0;
			dLen=25;
			var tW=0;
			var tH=0;
			var dWidth=4;
			tW=UIPanel.instance.width-dWidth*2;
			tH=(UIPanel.instance.height-dLen);
			CodeViewManager.style.width=tW+"px";
			CodeViewManager.style.height=tH+"px";
			CodeViewManager.style.left=(pos.x+dWidth)+"px";
			CodeViewManager.style.top=pos.y+dLen+"px";
			CodeViewManager.sizeDiv(tW,tH);
		}

		CodeViewManager.codeDiv=null
		CodeViewManager.style=null
		CodeViewManager.showed=false;
		__static(CodeViewManager,
		['I',function(){return this.I=new CodeViewManager();}
		]);
		return CodeViewManager;
	})()


	/**
	*本类控制鼠标光标样式
	*@author ww
	*/
	//class laya.ide.managers.CursorManager
	var CursorManager=(function(){
		function CursorManager(){}
		__class(CursorManager,'laya.ide.managers.CursorManager');
		CursorManager.init=function(){
			CursorManager._style=Browser.document.body.style;
			CursorManager.setType("default");
		}

		CursorManager.setType=function(type){
			CursorManager._style.cursor=type;
		}

		CursorManager.Auto="default";
		CursorManager.Hand="all-scroll";
		CursorManager.HResize="e-resize";
		CursorManager.VResize="n-resize";
		CursorManager._style=null
		return CursorManager;
	})()


	/**
	*ide右上方拖动条
	*@author ww
	*/
	//class laya.ide.managers.DragBarManager
	var DragBarManager=(function(){
		function DragBarManager(){}
		__class(DragBarManager,'laya.ide.managers.DragBarManager');
		DragBarManager.init=function(){
			DragBarManager._drag=Browser.document.getElementById("_dragBar");
			DragBarManager._style=DragBarManager._drag.style;
			DragBarManager.adpt();
		}

		DragBarManager.adpt=function(){
			var menuWidth=580;
			DragBarManager._style.left=menuWidth+"px";
			DragBarManager._style.width=Browser.clientWidth-menuWidth-200;
		}

		DragBarManager._drag=null
		DragBarManager._style=null
		return DragBarManager;
	})()


	/**
	*文件夹监控
	*@author ww
	*@version 1.0
	*
	*@created 2015-11-17 下午5:16:45
	*/
	//class laya.ide.managers.file.DirWatcher
	var DirWatcher=(function(){
		function DirWatcher(){
			this.path=null;
			this._childs=[];
		}

		__class(DirWatcher,'laya.ide.managers.file.DirWatcher');
		var __proto=DirWatcher.prototype;
		__proto.clear=function(){
			FileTools.unwatch(this.path);
			var i=0,len=0;
			len=this._childs.length;
			var tChild;
			for(i=0;i<len;i++){
				tChild=this._childs[i];
				tChild.clear();
			}
			this._childs.length=0;
		}

		__proto.setPath=function(path){
			return;
			this.clear();
			this.path=path;
			if(!FileTools.exist(path))return;
			if(FileTools.isDirectory(path)){
				var childs;
				childs=FileTools.getDirChildDirs(path);
				var i=0,len=0;
				len=childs.length;
				var tChild;
				for(i=0;i<len;i++){
					tChild=new DirWatcher();
					tChild.setPath(childs[i]);
					this._childs.push(tChild);
				}
				}else{
			}
			FileTools.watch(path,Utils.bind(this.changeHandler,this));
		}

		__proto.checkChanges=function(){}
		__proto.changeHandler=function(event,filename){
			if(!filename)return;
			filename=CMDShell.decode(filename,"utf8");
			var filePath;
			filePath=FileTools.path.join(this.path,filename);
			console.log("FileChange:",event,filename);
			if(!FileTools.exist(filePath))return;
			if(FileTools.isDirectory(filePath)){
				if(!FileTools.isDirWatched(filePath)){
					var tChild;
					tChild=new DirWatcher();
					tChild.setPath(filePath);
					this._childs.push(tChild);
				}
				return;
			}
			Laya.timer.once(500,Notice1,Notice1.notify,["RESFILE_CHANGE",filePath],true);
		}

		return DirWatcher;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-5-26 上午9:27:43
	*/
	//class laya.ide.managers.file.DirWatcherNew
	var DirWatcherNew=(function(){
		function DirWatcherNew(){
			this.updateO={};
			this.path=null;
		}

		__class(DirWatcherNew,'laya.ide.managers.file.DirWatcherNew');
		var __proto=DirWatcherNew.prototype;
		__proto.setPath=function(path){
			return;
			this.path=path;
			ObjectTools.clearObj(this.updateO);
			this.work=false;
			this.record();
			this.work=true;
		}

		__proto.record=function(){
			var files;
			files=FileTools.getFileList(this.path);
			var i=0,len=0;
			var tFile;
			var infor;
			len=files.length;
			for(i=0;i<len;i++){
				tFile=files[i];
				infor=FileTools.getStat(tFile);
				this.updateO[tFile]=infor.mtime.toString();
			}
		}

		__proto.check=function(){
			var files;
			files=FileTools.getFileList(this.path);
			var i=0,len=0;
			var tFile;
			var infor;
			var newTime;
			len=files.length;
			for(i=0;i<len;i++){
				tFile=files[i];
				infor=FileTools.getStat(tFile);
				newTime=infor.mtime.toString();
				if(newTime!=this.updateO[tFile]){
					Notice1.notify("RESFILE_CHANGE",tFile);
				}
				this.updateO[tFile]=newTime;
			}
		}

		__getset(0,__proto,'work',null,function(v){
			if(v){
				Laya.timer.loop(5000,this,this.check);
				}else{
				Laya.timer.clear(this,this.check);
			}
		});

		return DirWatcherNew;
	})()


	/**文件管理类
	*@author yung
	*/
	//class laya.ide.managers.FileManager
	var FileManager=(function(){
		function FileManager(){};
		__class(FileManager,'laya.ide.managers.FileManager');
		FileManager.getPath=function(basePath,relativePath){
			return FileTools.getPath(basePath,relativePath);
		}

		FileManager.getRelativePath=function(basePath,targetPath){
			return FileManager.adptToCommonUrl(FileTools.getRelativePath(basePath,targetPath));
		}

		FileManager.getAppPath=function(path){
			return FileManager.getPath(SystemSetting.appPath,path);
		}

		FileManager.getDataPath=function(path){
			return FileManager.getPath(Device.dataPath,path);
		}

		FileManager.getAppRelativePath=function(path){
			return FileManager.getRelativePath(SystemSetting.appPath,path);
		}

		FileManager.getWorkPath=function(path){
			return FileManager.getPath(SystemSetting.workPath,path);
		}

		FileManager.getWorkRelativePath=function(path){
			return FileManager.adptToCommonUrl(FileManager.getRelativePath(SystemSetting.workPath,path));
		}

		FileManager.getResRelativePath=function(path){
			return FileManager.adptToCommonUrl(""+FileManager.getRelativePath(SystemSetting.assetsPath,path));
		}

		FileManager.adptToCommonUrl=function(url){
			return StringTool.getReplace(url,"\\\\","/");
		}

		FileManager.adptToLocalUrl=function(url){
			return FileTools.path.normalize(url);
		}

		FileManager.getResPath=function(path){
			return FileManager.getPath(SystemSetting.assetsPath,path);
		}

		FileManager.getPagePath=function(path){
			return FileManager.getPath(SystemSetting.pagesPath,path);
		}

		FileManager.getFileName=function(path){
			return FileTools.path.basename(path).split(".")[0];
		}

		FileManager.createDirectory=function(path){
			try {
				FileTools.createDirectory(path);
				}catch (e){
				Sys.alert("Create folder failed:"+path);
			}
		}

		FileManager.createTxtFile=function(path,value){
			try {
				FileTools.createFile(path,value);
				}catch (e){
				Sys.alert("Create file failed:"+path);
			}
		}

		FileManager.createJSONFile=function(path,value){
			try {
				FileTools.createFile(path,JSON.stringify(value));
				}catch (e){
				Sys.alert("Create file failed:"+path);
			}
		}

		FileManager.createBytesFile=function(path,bytes){
			try {
				FileTools.createFile(path,bytes);
				}catch (e){
				Sys.alert("Create file failed:"+path);
			}
		}

		FileManager.removeFile=function(path){
			FileTools.removeE(path);
		}

		FileManager.copyFile=function(from,to){
			try {
				FileTools.copyE(from,to);
				}catch (e){
				Sys.alert("Copy file failed:(from:"+from+" to:"+to+")");
				console.log("Copy file failed:(from:"+from+" to:"+to+")");
			}
		}

		FileManager.readTxtFile=function(path,errorAlert){
			(errorAlert===void 0)&& (errorAlert=true);
			try {
				return FileTools.readFile(path);
				}catch (e){
				if (errorAlert)Sys.alert("Read file failed:"+path);
			}
			return null;
		}

		FileManager.readJSONFile=function(path,errorAlert){
			(errorAlert===void 0)&& (errorAlert=true);
			try {
				var str=laya.ide.managers.FileManager.readTxtFile(path);
				return JSON.parse(str);
				}catch (e){
				if (errorAlert)Sys.alert("Read file failed:"+path);
				debugger;
			}
			return null;
		}

		FileManager.readByteFile=function(path,errorAlert){
			(errorAlert===void 0)&& (errorAlert=true);
			try {
				return FileTools.readFile(path);
				}catch (e){
				if (errorAlert)Sys.alert("Read file failed:"+path);
			}
			return null;
		}

		FileManager.getFileList=function(path){
			return FileTools.getFileList(path);
		}

		FileManager.exists=function(path){
			return FileTools.exist(path);
		}

		FileManager.getFileTree=function(path,hasExtension){
			(hasExtension===void 0)&& (hasExtension=false);
			var xml=findFiles(path);
			function findFiles (path){
				var node;
				if (FileTools.exist(path)){
					var fileName=FileTools.getFileName(path);
					node=new XMLElement("<item label='"+fileName+"' path='"+path+"' isDirectory='true'/>");
					var a=FileTools.getDirFiles(path);
					var f;
					for(var $each_f in a){
						f=a[$each_f];
						f=FileTools.getPath(path,f);
						if (FileTools.isDirectory(f)&& f.indexOf(".svn")==-1){
							node.appendChild(findFiles(f));
						}
					}
					var $each_f;
					for($each_f in a){
						f=a[$each_f];
						f=FileTools.getPath(path,f);
						if (FileTools.isDirectory(f)==false){
							if (fileName.indexOf("$")==-1 && fileName.indexOf("@")==-1){
								node.appendChild(new XMLElement("<item label='"+fileName+"' path='"+f+"' isDirectory='false'/>"));
							}
						}
					}
				}
				return node;
			}
			return xml
		}

		FileManager.rename=function(oldPath,newPath){
			try {
				FileTools.rename(oldPath,newPath);
				}catch (e){
				Sys.alert("Rename file failed:(from:"+oldPath+" to:"+newPath+")");
			}
		}

		return FileManager;
	})()


	/**
	*用于在对象上显示焦点框的工具类
	*@author ww
	*/
	//class laya.ide.managers.FocusManager
	var FocusManager=(function(){
		function FocusManager(){}
		__class(FocusManager,'laya.ide.managers.FocusManager');
		FocusManager.showFocus=function(tar,width,clearPre){
			(width===void 0)&& (width=5);
			(clearPre===void 0)&& (clearPre=true);
			var bounds;
			bounds=FocusManager.getTarBounds(tar);
			FocusManager.showBorder(tar,"up",clearPre,bounds,width);
			FocusManager.showBorder(tar,"down",false,bounds,width);
			FocusManager.showBorder(tar,"left",false,bounds,width);
			FocusManager.showBorder(tar,"right",false,bounds,width);
		}

		FocusManager.getTarBounds=function(tar){
			if(FocusManager.useGetBounds){
				return tar.getSelfBounds();
				}else{
				return new Rectangle().setTo(0,0,tar.width,tar.height);
			}
		}

		FocusManager.showBorder=function(tar,type,clearPre,rec,width){
			(clearPre===void 0)&& (clearPre=true);
			(width===void 0)&& (width=5);
			if (clearPre==true){
				FocusManager.clearFocus();
			};
			var bounds;
			bounds=rec?rec:FocusManager.getTarBounds(tar);
			var tFocus;
			tFocus=DisPool.getDis(FocusItem);
			switch (type){
				case "left":
					tFocus.width=width;
					tFocus.height=bounds.height;
					tFocus.x=bounds.x;
					tFocus.y=bounds.y;
					break ;
				case "right":
					tFocus.width=width;
					tFocus.height=bounds.height;
					tFocus.x=bounds.x+bounds.width-width;
					tFocus.y=bounds.y;
					break ;
				case "up":
					tFocus.width=bounds.width;
					tFocus.height=width;
					tFocus.x=bounds.x;
					tFocus.y=bounds.y;
					break ;
				case "down":
					tFocus.width=bounds.width;
					tFocus.height=width;
					tFocus.x=bounds.x;
					tFocus.y=bounds.y+bounds.height-width;
					break ;
				}
			FocusManager.showFocusToTar(tar,tFocus);
		}

		FocusManager.showFocusToTar=function(tar,focus){
			FocusManager._focusList.push(focus);
			tar.addChild(focus);
		}

		FocusManager.clearFocus=function(tar){
			var i=0,len=0;
			len=FocusManager._focusList.length;
			if (tar){
				for (i=len-1;i >=0;i--){
					if (FocusManager._focusList[i].parent==tar){
						(FocusManager._focusList [i]).removeSelf();
						FocusManager._focusList.splice(i,1);
					}
				}
			}
			else{
				for (i=0;i < len;i++){
					(FocusManager._focusList [i]).removeSelf();
				}
				FocusManager._focusList.length=0;
			}
		}

		FocusManager.focusWidth=5;
		FocusManager.useGetBounds=false;
		FocusManager._focusList=[];
		return FocusManager;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-3-23 下午9:19:23
	*/
	//class laya.ide.managers.HtmlLayerManager
	var HtmlLayerManager=(function(){
		function HtmlLayerManager(){
			HtmlLayerManager.init();
		}

		__class(HtmlLayerManager,'laya.ide.managers.HtmlLayerManager');
		HtmlLayerManager.init=function(){
			HtmlLayerManager.CanvasStyle=Render._mainCanvas.source["style"];
			Dialog.manager.on("open",null,HtmlLayerManager.openDialog);
			Dialog.manager.on("close",null,HtmlLayerManager.closeDialog);
		}

		HtmlLayerManager.setCanvasIndex=function(index){
			if(!HtmlLayerManager.CanvasStyle)HtmlLayerManager.init();
			HtmlLayerManager.CanvasStyle["z-index"]=index;
		}

		HtmlLayerManager.update=function(){
			return;
			if(HtmlLayerManager.hasPops()){
				HtmlLayerManager.switchToTop();
				}else{
				HtmlLayerManager.switchToBack();
			}
		}

		HtmlLayerManager.hasPops=function(){
			return HtmlLayerManager.hasMenu||HtmlLayerManager.hasDialog||HtmlLayerManager.hasTip;
		}

		HtmlLayerManager.switchToTop=function(){
			HtmlLayerManager.setCanvasIndex(99);
		}

		HtmlLayerManager.switchToBack=function(){
			HtmlLayerManager.setCanvasIndex(1);
		}

		HtmlLayerManager.openDialog=function(){
			HtmlLayerManager.hasDialog=true;
			HtmlLayerManager.update();
		}

		HtmlLayerManager.closeDialog=function(){
			HtmlLayerManager.hasDialog=false;
			HtmlLayerManager.update();
		}

		HtmlLayerManager.openMenu=function(){
			HtmlLayerManager.hasMenu=true;
			HtmlLayerManager.update();
		}

		HtmlLayerManager.closeMenu=function(){
			HtmlLayerManager.hasMenu=false;
			HtmlLayerManager.update();
		}

		HtmlLayerManager.openTip=function(){
			HtmlLayerManager.hasTip=true;
			HtmlLayerManager.update();
		}

		HtmlLayerManager.closeTip=function(){
			HtmlLayerManager.hasTip=false;
			HtmlLayerManager.update();
		}

		HtmlLayerManager.CanvasStyle=null
		HtmlLayerManager.hasDialog=false;
		HtmlLayerManager.hasMenu=false;
		HtmlLayerManager.hasTip=false;
		return HtmlLayerManager;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-8-19 上午11:23:03
	*/
	//class laya.ide.managers.IDEAPIS
	var IDEAPIS=(function(){
		function IDEAPIS(){}
		__class(IDEAPIS,'laya.ide.managers.IDEAPIS');
		/**
		*资源文件存放的目录
		*
		*/
		__getset(1,IDEAPIS,'assetsPath',function(){
			return SystemSetting.assetsPath;
		});

		/**
		*当前工作目录
		*
		*/
		__getset(1,IDEAPIS,'workPath',function(){
			return SystemSetting.workPath;
		});

		/**
		*导出图集资源的目录
		*
		*/
		__getset(1,IDEAPIS,'resExportPath',function(){
			return ProjectSetting.resExportPath;
		});

		/**
		*页面文件存放目录
		*
		*/
		__getset(1,IDEAPIS,'pagesPath',function(){
			return SystemSetting.pagesPath;
		});

		/**
		*导出代码的目录
		*
		*/
		__getset(1,IDEAPIS,'codeExportPath',function(){
			return ProjectSetting.codeExportPath;
		});

		/**
		*导出非图集资源的目录
		*
		*/
		__getset(1,IDEAPIS,'asynResExportPath',function(){
			return ProjectSetting.asynResExportPath;
		});

		IDEAPIS.nodeChange=function(node,changeProps,reCreate){
			(reCreate===void 0)&& (reCreate=false);
			var design;
			design=IDEAPIS.getCurDesign();
			if(!design)return;
			design.nodeChanged(node,["x","y","width","height"]);
			design.change(reCreate);
			design.changeSelectComp();
		}

		IDEAPIS.getCurDesign=function(){
			if(!UIPanel.instance.currViewer)return null;
			return UIPanel.instance.currViewer.design;
		}

		IDEAPIS.getSelectComps=function(){
			var design;
			design=IDEAPIS.getCurDesign();
			if(!design)return null;
			return design.getIDedSelectedXmls();
		}

		IDEAPIS.getCurPagePath=function(){
			if(!UIPanel.instance.currViewer)return null;
			return UIPanel.instance.currViewer.pagePath;
		}

		IDEAPIS.getCurPageType=function(){
			var path;
			path=IDEAPIS.getCurPagePath();
			if(!path)return null;
			return TypeManager.getFileType(path);
		}

		IDEAPIS.getDesignData=function(){
			var design;
			design=IDEAPIS.getCurDesign();
			if(!design)return null;
			return design.xml;
		}

		IDEAPIS.unFocusInput=function(){
			if(Laya.stage.focus&& (Laya.stage.focus instanceof laya.ui.TextInput )){
				(Laya.stage.focus).focus=false;
			}
		}

		return IDEAPIS;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-12-27 下午3:00:03
	*/
	//class laya.ide.managers.IDEConfigsManager
	var IDEConfigsManager=(function(){
		function IDEConfigsManager(){}
		__class(IDEConfigsManager,'laya.ide.managers.IDEConfigsManager');
		var __proto=IDEConfigsManager.prototype;
		__proto.getConfig=function(sign){
			var configO;
			configO=FileManager.readJSONFile(Paths.getConfigVarPath());
			if(!configO)return null;
			return configO[sign];
		}

		__proto.saveConfig=function(sign,dataO){
			var configO;
			configO=FileManager.readJSONFile(Paths.getConfigVarPath());
			if(!configO)configO={};
			if(!dataO)dataO={};
			configO[sign]=dataO;
			FileManager.createJSONFile(Paths.getConfigVarPath(),configO);
		}

		__proto.insertDefaultValue=function(target,configO){
			var key;
			key=configO["sign"];
			if(!key)return;
			var vars;
			vars=configO["vars"];
			if(!vars)return;
			var i=0,len=0;
			len=vars.length;
			var tName;
			var tChild;
			var tValue;
			var tData;
			tData=this.getConfig(key);
			if(!tData)return;
			for(i=0;i<len;i++){
				tName=vars[i];
				tChild=target[tName];
				if(!tChild)continue ;
				if(tData[tName]){
					tChild.text=tData[tName];
				}
			}
		}

		__proto.saveDefaultValue=function(target,configO){
			var key;
			key=configO["sign"];
			if(!key)return;
			var vars;
			vars=configO["vars"];
			if(!vars)return;
			var i=0,len=0;
			len=vars.length;
			var tName;
			var tChild;
			var tValue;
			var tData;
			tData=this.getConfig(key);
			if(!tData)tData={};
			for(i=0;i<len;i++){
				tName=vars[i];
				tChild=target[tName];
				if(!tChild)continue ;
				tData[tName]=tChild.text;
			}
			this.saveConfig(key,tData);
		}

		__static(IDEConfigsManager,
		['I',function(){return this.I=new IDEConfigsManager();}
		]);
		return IDEConfigsManager;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-7-18 上午10:44:47
	*/
	//class laya.ide.managers.IDESkinManager
	var IDESkinManager=(function(){
		function IDESkinManager(){}
		__class(IDESkinManager,'laya.ide.managers.IDESkinManager');
		IDESkinManager.reloadIDE=function(){
			Device.remote.getCurrentWindow().reload();
		}

		IDESkinManager.switchToSkin=function(skinPath){
			if(!FileTools.exist(FileManager.getAppPath("h5/skins/"+skinPath))){
				skinPath="default";
			}
			IDESkinManager.tSkinPath=skinPath;
			IDESkinManager.reloadIDE();
		}

		IDESkinManager.setSkinPath=function(path){
			if(!path){
				path="default";
			}
			if(!FileTools.exist(FileManager.getAppPath("h5/skins/"+path))){
				path="default";
			}
			IDESkinManager.tSkinPath=path;
		}

		IDESkinManager.getSkinPath=function(){
			return FileManager.getAppPath("h5/skins/"+IDESkinManager.tSkinPath+"/");
		}

		IDESkinManager.getStylePath=function(){
			return IDESkinManager.getSkinPath()+"styles.cfg";
		}

		IDESkinManager.testSwitch=function(){
			if(IDESkinManager.tSkinPath=="default"){
				IDESkinManager.switchToSkin("lighter");
				}else{
				IDESkinManager.switchToSkin("default");
			}
		}

		IDESkinManager.tSkinPath="lighter";
		IDESkinManager.DefaultSkinPath="default";
		return IDESkinManager;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-4-20 下午4:48:41
	*/
	//class laya.ide.managers.KeyManager
	var KeyManager=(function(){
		function KeyManager(){
			this.isCommandKeyDown=false;
		}

		__class(KeyManager,'laya.ide.managers.KeyManager');
		var __proto=KeyManager.prototype;
		__proto.init=function(){
			Laya.stage.on("keydown",this,this.keyDown);
			Laya.stage.on("keyup",this,this.keyUp);
			Laya.stage.on("blur",this,this.onBlur);
		}

		__proto.onBlur=function(){
			this.isCommandKeyDown=false;
		}

		__proto.isCommandKey=function(keyCode){
			if(KeyManager.commandKeys[keyCode])return true;
			return false;
		}

		__proto.keyDown=function(e){
			if(this.isCommandKey(e.keyCode)){
				this.isCommandKeyDown=true;
			}
			if(Input.isInputting){
				this.isCommandKeyDown=false;
			}
		}

		__proto.keyUp=function(e){
			if(Input.isInputting){
				this.isCommandKeyDown=false;
			}
			if(this.isCommandKey(e.keyCode)){
				this.isCommandKeyDown=false;
			}
		}

		KeyManager.isABC=function(keyCode){
			return keyCode>=65&&keyCode<=90;
		}

		KeyManager.getCharByCode=function(code){
			return String.fromCharCode(code);
		}

		KeyManager.setNewFocus=function(item){
			if(Laya.stage.focus){
				KeyManager.focusList.push(Laya.stage.focus);
			}
			Laya.stage.focus=item;
		}

		KeyManager.restoreFocus=function(){
			if(KeyManager.focusList.length>0){
				Laya.stage.focus=KeyManager.focusList.pop();
			}
		}

		KeyManager.focusList=[];
		__static(KeyManager,
		['I',function(){return this.I=new KeyManager();},'commandKeys',function(){return this.commandKeys={
				91:true,
				93:true,
				244:true,
				17:true
		};}

		]);
		return KeyManager;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-7-4 下午8:19:47
	*/
	//class laya.ide.managers.LanguageManager
	var LanguageManager=(function(){
		function LanguageManager(){}
		__class(LanguageManager,'laya.ide.managers.LanguageManager');
		LanguageManager.loadProjectLanguageFile=function(){
			if(ProjectSetting)
				LanguageManager.loadLanguageFile(FileManager.getWorkPath(ProjectSetting.langPath));
		}

		LanguageManager.loadLanguageFile=function(file){
			if(!FileTools.exist(file)){
				return;
			}
			if(FileTools.isDirectory(file))return;
			var txt;
			txt=FileTools.readFile(file);
			var langData;
			try{
				langData=ObjectTools.getObj(txt);
				}catch(e){
			}
			if(langData){
				Text.langPacks=langData;
			}
			Notice1.notify("FRESH_CurView");
			console.log("languagePack loaded");
		}

		LanguageManager.getLanguagePack=function(){
			LanguageManager.saveLanguagePack(FileManager.getWorkPath(ProjectSetting.resExportPath));
		}

		LanguageManager.saveLanguagePack=function(file){
			try{
				var langDic;
				langDic=LanguageManager.createByDir(SystemSetting.pagesPath,null,null);
				console.log("langDic:",langDic);
				var outPath;
				outPath=FileManager.getPath(file,"lang.lang");
				FileTools.createFile(outPath,ObjectTools.getJsonString(langDic));
				MessageManager.instance.show("生成语言包成功");
				}catch(e){
				Alert.show("生成语言包失败："+e.message);
			}
		}

		LanguageManager.createByDir=function(file,basePath,tarPath){
			var fileList;
			fileList=FileTools.getFileList(file);
			var i=0,len=0;
			len=fileList.length;
			var tFile;
			var code;
			var obj;
			var codePath;
			var uiObj;
			var textDic={};
			for(i=0;i<len;i++){
				tFile=fileList[i];
				if(FileTools.isDirectory(tFile)){
					}else{
					if(TypeManager.getFileType(tFile)=="page"||TypeManager.getFileType(tFile)=="animation"){
						code=FileManager.readTxtFile(tFile);
						try{
							uiObj=ObjectTools.getObj(code);
							LanguageManager.collectTexts(uiObj,textDic);
							}catch(e){
							Alert.show("提取文件失败：\n"+tFile);
						}
					}
				}
			}
			LanguageManager.getStylesText(ResStyleManager.styleMap,textDic);
			return textDic;
		}

		LanguageManager.getStylesText=function(styleObj,textDic){
			if(!styleObj)return;
			var key;
			var xml;
			for(key in styleObj){
				xml=styleObj[key];
				if(xml){
					LanguageManager.collectPropStrText(xml.getAttribute('props'),textDic);
				}
			}
		}

		LanguageManager.collectPropStrText=function(propStr,textDic){
			if(!propStr)return;
			if(propStr.indexOf("=")>=0){
				var props;
				props=ResStyleManager.getPropArrByPropStr(propStr);
				for (var i=0,n=props.length;i < n;i++){
					var a=props[i].split("=");
					if (a.length==2){
						var key=a[0];
						var val=a[1];
						var adptVal;
						adptVal=ObjectTools.getAutoValue(val);
						if((typeof adptVal=='string')){
							LanguageManager.addText(adptVal,textDic);
						}
					}
				}
			}
		}

		LanguageManager.getTypeCollects=function(type){
			if(LanguageManager.collectConfigO[type])return LanguageManager.collectConfigO[type];
			var rst;
			rst=[];
			var configO;
			configO=UIConfigManager.getFullConfig(type);
			if(configO){
				var props;
				props=configO.prop;
				var key;
				for(key in props){
					if(props[key]["text"]=="true"||LanguageManager.textKeysDefault[key]){
						rst.push(key);
					}
				}
			}
			LanguageManager.collectConfigO[type]=rst;
			return rst;
		}

		LanguageManager.collectTexts=function(nodeO,textDic){
			var i=0,len=0;
			var props;
			props=nodeO.props;
			var keys;
			keys=LanguageManager.getTypeCollects(nodeO.type);
			if(keys){
				len=keys.length;
				for(i=0;i<len;i++){
					if(props.hasOwnProperty(keys[i])){
						LanguageManager.addText(props[keys[i]],textDic);
					}
				}
			};
			var childs;
			childs=nodeO.child;
			if(childs){
				len=childs.length;
				for(i=0;i<len;i++){
					LanguageManager.collectTexts(childs[i],textDic)
				}
			}
		}

		LanguageManager.addText=function(text,textDic){
			if(text==null)return;
			if(text=="")return;
			textDic[text]=text;
		}

		__static(LanguageManager,
		['textKeysDefault',function(){return this.textKeysDefault={
				"text":true,
				"label":true,
				"prompt":true
				};},'collectConfigO',function(){return this.collectConfigO={
		};}

		]);
		return LanguageManager;
	})()


	/**
	*本类用于处理对象之间的排版关系
	*@author ww
	*/
	//class laya.ide.managers.layout.RelativePos
	var RelativePos=(function(){
		function RelativePos(fun,tar,to,d){
			this.tar=null;
			this.to=null;
			this.d=NaN;
			this._fun=null;
			this.tar=tar;
			this.to=to;
			this.d=d;
			this._fun=fun;
		}

		__class(RelativePos,'laya.ide.managers.layout.RelativePos');
		var __proto=RelativePos.prototype;
		/**
		*更新排版
		*
		*/
		__proto.update=function(){
			this._fun(this.tar,this.to,this.d);
		}

		RelativePos.getDisMouseRelativePos=function(tTarget,edgePercent){
			(edgePercent===void 0)&& (edgePercent=0.1);
			var pos;
			pos=DisControlTool.getMousePoint(tTarget);
			if (pos.x < 0 || pos.x > tTarget.width || pos.y < 0 || pos.y > tTarget.height)return "out";
			if (pos.y < tTarget.height *edgePercent){
				return "up";
			}
			else if (pos.y > tTarget.height *(1-edgePercent)){
				return "down";
			}
			else if (pos.x > tTarget.width *(1-edgePercent)){
				return "right";
				}else if (pos.x < tTarget.width *edgePercent){
				return "left";
				}else{
				return "center";
			}
			return "center";
		}

		RelativePos.rightTo=function(tar,to,d){
			(d===void 0)&& (d=0);
			if (!to.parent)
				return;
			tar.right=Math.ceil((to.parent).width-to.x+d);
		}

		RelativePos.leftTo=function(tar,to,d){
			(d===void 0)&& (d=0);
			tar.left=Math.ceil(to.x+to.width+d);
		}

		RelativePos.downTo=function(tar,to,d){
			(d===void 0)&& (d=0);
			if (!to.parent)
				return;
			tar.bottom=Math.ceil((to.parent).height-to.y+d);
		}

		RelativePos.upTo=function(tar,to,d){
			(d===void 0)&& (d=0);
			tar.top=Math.ceil(to.y+to.height+d);
		}

		RelativePos.saveRelative=function(tar){
			var relativeO;
			relativeO=tar["relativeO"];
			if (!relativeO)
				return {};
			var key;
			var rst={};
			for (key in relativeO){
				rst[key]=IDTools.getObjID(relativeO[key]);
			}
			return rst;
		}

		RelativePos.getTypeByFun=function(fun){
			var key;
			for (key in RelativePos.typeToFunO){
				if (RelativePos.typeToFunO[key]==fun)
					return key;
			}
			return null;
		}

		RelativePos.getOtherSide=function(type){
			return RelativePos.otherSideO[type];
		}

		RelativePos.getOnlySide=function(o){
			var relativeO;
			relativeO=o["relativeO"];
			if (!relativeO)
				return null;
			var type;
			var tBar;
			var tRst;
			var tArea=0;
			var tRstBar;
			for (type in relativeO){
				tBar=relativeO[type];
				if (tBar){
					if (tBar.isOnly(o)){
						if (!tRst || RelativePos.getBarWeight(tBar)> tArea){
							tRst=type;
							tRstBar=tBar;
							tArea=RelativePos.getBarWeight(tBar);
						}
					}
				}
			}
			return tRst;
		}

		RelativePos.getBarWeight=function(bar){
			var tRec;
			tRec=bar.getDragArea();
			return tRec.width+tRec.height;
		}

		RelativePos.addRelative=function(o,dragBar,type,d){
			(d===void 0)&& (d=0);
			if (!dragBar)
				return;
			RelativePos.cancelRelative(o,type);
			dragBar.addItem(o,RelativePos.typeToFunO[type]);
			var relativeO;
			if (!o["relativeO"])
				o["relativeO"]={};
			relativeO=o["relativeO"];
			relativeO[type]=dragBar;
		}

		RelativePos.copyRelative=function(o,tar,type){
			RelativePos.addRelative(o,RelativePos.getBar(tar,type),type);
		}

		RelativePos.cancelRelative=function(o,sign){
			var relativeO;
			relativeO=o["relativeO"];
			if (!relativeO)
				return;
			if (relativeO[sign]){
				(relativeO [sign]).removeTarget(o);
			}
			delete relativeO[sign];
		}

		RelativePos.getBar=function(o,sign){
			var relativeO;
			relativeO=o["relativeO"];
			if (!relativeO)
				return null;
			return relativeO[sign];
		}

		RelativePos.clearBar=function(o){
			RelativePos.cancelRelative(o,"left");
			RelativePos.cancelRelative(o,"right");
			RelativePos.cancelRelative(o,"up");
			RelativePos.cancelRelative(o,"down");
		}

		RelativePos.Right="right";
		RelativePos.Left="left";
		RelativePos.Down="down";
		RelativePos.Up="up";
		RelativePos.Center="center";
		RelativePos.Out="out";
		RelativePos.EdgePercent=0.1;
		__static(RelativePos,
		['typeToFunO',function(){return this.typeToFunO={"right":laya.ide.managers.layout.RelativePos.rightTo,"left":laya.ide.managers.layout.RelativePos.leftTo,"up":laya.ide.managers.layout.RelativePos.upTo,"down":laya.ide.managers.layout.RelativePos.downTo};},'otherSideO',function(){return this.otherSideO={"right":"left","left":"right","up":"down","down":"up"};}
		]);
		return RelativePos;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-6-27 上午10:10:36
	*/
	//class laya.ide.managers.layout.ResizeRecStruct
	var ResizeRecStruct=(function(){
		function ResizeRecStruct(){
			this.upSide=null;
			this.downSide=null;
			this.leftSide=null;
			this.rightSide=null;
			this.isRoot=false;
			this.resizeItems=null;
			this.mDis=NaN;
			this.sortByXFun=MathUtil.sortByKey("x",false,true);
			this.sortByYFun=MathUtil.sortByKey("y",false,true);
		}

		__class(ResizeRecStruct,'laya.ide.managers.layout.ResizeRecStruct');
		var __proto=ResizeRecStruct.prototype;
		__proto.reset=function(){
			this.upSide=null;
			this.downSide=null;
			this.leftSide=null;
			this.rightSide=null;
		}

		__proto.setBars=function(left,right,up,down){
			this.upSide=up;
			this.downSide=down;
			this.leftSide=left;
			this.rightSide=right;
		}

		__proto.isSame=function(left,right,up,down){
			return this.upSide==up&&this.downSide==down&&this.leftSide==left&&this.rightSide==right;
		}

		__proto.isSameStruct=function(st){
			return this.upSide==st.upSide&&this.downSide==st.downSide&&this.leftSide==st.leftSide&&this.rightSide==st.rightSide;
		}

		__proto.traceMyInfo=function(){
			console.log("up:",this.upSide.getDragBarInfo("up"));
			console.log("down:",this.downSide.getDragBarInfo("down"));
			console.log("left:",this.leftSide.getDragBarInfo("left"));
			console.log("right:",this.rightSide.getDragBarInfo("right"));
		}

		/**
		*调整垂直方向的拖动条
		*@param dis
		*@return
		*
		*/
		__proto.tryMoveRight=function(dis){
			this.mDis=dis;
			var i=0,len=0;
			var _updaters;
			_updaters=this.upSide._updaters;
			len=_updaters.length;
			var tR;
			var dragBarList;
			dragBarList=[];
			var tDragBar;
			for (i=len-1;i >=0;i--){
				tR=_updaters[i];
				if((tR.tar instanceof laya.editor.comonents.LayoutDragBar )){
					tDragBar=tR.tar;
					if(tDragBar.cusorType=="e-resize"&&RelativePos.getTypeByFun(tR._fun)=="up"){
						if(this.downSide.findTarType(tDragBar)!=null){
							if(tDragBar.x>=this.leftSide.x&&tDragBar.x<=this.rightSide.x)
								dragBarList.push(tDragBar);
						}
					}
				}
			}
			dragBarList.sort(this.sortByXFun);
			if(dragBarList[0]!=this.leftSide){
				dragBarList.unshift(this.leftSide);
			}
			if(dragBarList[dragBarList.length-1]!=this.rightSide){
				dragBarList.push(this.rightSide);
			}
			if(dragBarList.length<2){
				return false;
			};
			var tWidth=NaN;
			tWidth=0;
			var maxWidth=NaN;
			maxWidth=0;
			var tSelecteDragBar;
			len=dragBarList.length;
			for(i=1;i<len;i++){
				tWidth=dragBarList[i].x-dragBarList[i-1].x;
				if(tWidth>maxWidth){
					maxWidth=tWidth;
					tSelecteDragBar=dragBarList[i];
				}
				if(tWidth+dis>150&&LayoutDragBar.hasFreeTar((dragBarList [i]).getTarsByType("right"))){
					tSelecteDragBar=dragBarList[i];
					break ;
				}
			}
			if(tSelecteDragBar){
				this.moveRightWork(tSelecteDragBar,dragBarList,dis)
				}else{
				debugger;
			}
			return true;
		}

		/**
		*调整水平方向的拖动条
		*@param dis
		*
		*/
		__proto.moveRightWork=function(selectBar,barList,dis){
			var i=0,len=0;
			var rightIndex=0;
			rightIndex=barList.indexOf(selectBar);
			var tLeftBar;
			var tRightBar;
			if(rightIndex>=1){
				tLeftBar=barList[rightIndex-1];
				tRightBar=barList[rightIndex];
				if(tLeftBar==this.leftSide&&tRightBar==this.rightSide){
					}else{
				}
				this.resizeSmallRec(tLeftBar,tRightBar);
			}
			len=barList.length;
			if(this.isRoot){
				len=this.resizeItems.length;
				for(i=0;i<len;i++){
					if(!this.resizeItems[i].walked){
						this.resizeItems[i].left+=dis;
						this.resizeItems[i].walked=true;
					}
				}
				}else{
				for(i=rightIndex;i<len;i++){
					this.resizeItems.push(barList[i]);
				}
			}
		}

		__proto.resizeSmallRec=function(tLeftBar,tRightBar){
			var i=0,len=0;
			var _updaters;
			_updaters=tRightBar._updaters;
			len=_updaters.length;
			var tR;
			var dragBarList;
			dragBarList=[];
			var tDragBar;
			for (i=len-1;i >=0;i--){
				tR=_updaters[i];
				if((tR.tar instanceof laya.editor.comonents.LayoutDragBar )){
					tDragBar=tR.tar;
					if(tDragBar.cusorType=="n-resize"&&RelativePos.getTypeByFun(tR._fun)=="right"){
						if(this.leftSide.findTarType(tDragBar)!=null){
							if(tDragBar.y>=this.upSide.y&&tDragBar.y<=this.downSide.y)
								dragBarList.push(tDragBar);
						}
					}
				}
			};
			var tSelecteDragBar;
			dragBarList.sort(this.sortByYFun);
			if(dragBarList[0]!=this.upSide){
				dragBarList.unshift(this.upSide);
			}
			if(dragBarList[dragBarList.length-1]!=this.downSide){
				dragBarList.push(this.downSide);
			}
			len=dragBarList.length;
			var resizeRec;
			for(i=1;i<len;i++){
				resizeRec=new ResizeRecStruct();
				resizeRec.resizeItems=this.resizeItems;
				resizeRec.setBars(tLeftBar,tRightBar,dragBarList[i-1],dragBarList[i]);
				if(this.isSameStruct(resizeRec)){
					}else{
					resizeRec.tryMoveRight(this.mDis);
				}
			}
		}

		return ResizeRecStruct;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.ide.managers.layout.Updater
	var Updater=(function(){
		function Updater(tar,tarSign,src,srcSign,dValue){
			this.tar=null;
			this.tarSign=null;
			this.src=null;
			this.srcSign=null;
			this.dValue=0;
			(dValue===void 0)&& (dValue=0);
			this.tar=tar;
			this.tarSign=tarSign;
			this.src=src;
			this.srcSign=srcSign;
			this.dValue=dValue;
		}

		__class(Updater,'laya.ide.managers.layout.Updater');
		var __proto=Updater.prototype;
		__proto.update=function(){
			this.tar[this.tarSign]=this.dValue+this.src[this.srcSign];
		}

		__proto.clear=function(){
			this.tar=null;
			this.src=null;
		}

		return Updater;
	})()


	/**
	*布局管理类
	*@author ww
	*/
	//class laya.ide.managers.LayoutRecManager
	var LayoutRecManager=(function(){
		function LayoutRecManager(){}
		__class(LayoutRecManager,'laya.ide.managers.LayoutRecManager');
		var __proto=LayoutRecManager.prototype;
		__proto.saveDragBarInfo=function(dragBar){}
		__getset(1,LayoutRecManager,'tLayoutFile',function(){
			return LayoutRecManager._layoutFile?LayoutRecManager._layoutFile:"layout/layout.config";
		});

		LayoutRecManager.popLocked=function(){
			return CodeViewManager.showed;
			return false;
		}

		LayoutRecManager.onMouseDown=function(e){
			LayoutRecManager.target=e.currentTarget;
			LayoutRecManager.dragItem(LayoutRecManager.target,LayoutRecManager.target["type"]);
			LayerManager.stage.on("mouseup",null,LayoutRecManager.onMouseUp);
			LayerManager.stage.on("mousemove",null,LayoutRecManager.onMouseMove);
		}

		LayoutRecManager.dragItem=function(target,type){
			(type===void 0)&& (type=0);
			var option={};
			var area=new Rectangle();
			if (type==0){
				area=(target).getDragArea();
			}
			else if (type==1){
				area=(target).getDragArea();
			}
			else{
				return;
			}
			option.area=area;
			DisControlTool.setTop(target);
			target.startDrag(area);
		}

		LayoutRecManager.onMouseUp=function(e){
			LayerManager.stage.off("mouseup",null,LayoutRecManager.onMouseUp);
			LayerManager.stage.off("mousemove",null,LayoutRecManager.onMouseMove);
			LayoutRecManager.doLayOut();
			LayoutRecManager.target.stopDrag();
			LayoutRecManager.target.left=Math.ceil(LayoutRecManager.target.x);
			LayoutRecManager.target.top=Math.ceil(LayoutRecManager.target.y);
		}

		LayoutRecManager.onMouseMove=function(e){
			LayoutRecManager.doLayOut();
		}

		LayoutRecManager.doLayOut=function(){
			(LayoutRecManager.target).updates();
		}

		LayoutRecManager.init=function(){
			LayoutRecManager._ct=new Box();
			LayoutRecManager._ct.mouseEnabled=true;
			LayoutRecManager._ct.name="LayoutRecManager_Container";
			LayoutRecManager._ct.width=0;
			LayoutRecManager._ct.height=0;
			LayerManager.stage.addChild(LayoutRecManager._ct);
			LayerManager.stage.on("resize",null,LayoutRecManager.resizeWork);
			LayoutRecManager._ct.on("dragDrop",null,LayoutRecManager.onDragDrop);
			LayerManager.stage.addChild(QuickTool.instance);
			MenuBar.instance.pos(1,1);
			QuickTool.instance.pos(LayoutRecManager.ctOffSetX+10,30);
			LayoutRecManager.layoutToPageType("page");
		}

		LayoutRecManager.resizeWork=function(e){
			LayoutRecManager._ct.x=LayoutRecManager.ctOffSetX;
			LayoutRecManager._ct.y=QuickTool.instance.y+LayoutRecManager.dToQuickTool;
			Laya.timer.once(50,null,LayoutRecManager.tryResizeNoScale,null,true);
			return;
		}

		LayoutRecManager.scaleResize=function(){
			var nW=LayerManager.stage.width-LayoutRecManager.ctOffSetX;
			var nH=LayerManager.stage.height-30+LayoutRecManager.ctOffHeight;
			if ((nW *nH *LayoutRecManager._ct.width *LayoutRecManager._ct.height)!=0){
				var scaleX=nW / LayoutRecManager._ct.width;
				var scaleY=nH / LayoutRecManager._ct.height;
				LayoutRecManager.adptScales(scaleX,scaleY);
			}
			LayoutRecManager._ct.width=LayerManager.stage.width-LayoutRecManager.ctOffSetX;
			LayoutRecManager._ct.height=LayerManager.stage.height-LayoutRecManager._ct.y+LayoutRecManager.ctOffHeight;
			Laya.timer.once(100,null,LayoutRecManager.adptAll);
		}

		LayoutRecManager.tryResizeNoScale=function(){
			var items;
			items=DisControlTool.getAllChild(LayoutRecManager._ct);
			var i=0,len=0;
			len=items.length;
			var tRec;
			var tRecHeight=0;
			var maxFree;
			for (i=0;i < len;i++){
				tRec=items[i];
				if ((tRec instanceof laya.editor.view.LayoutRec )){
					if(tRec.sizeFree){
						if(!maxFree||maxFree.height<tRec.height){
							maxFree=tRec;
						}
					}
				}
			}
			tRec=maxFree;
			if(!tRec||!tRec.sizeFree){
				LayoutRecManager.scaleResize();
				return;
				}else{
			};
			var nW=LayerManager.stage.width-LayoutRecManager.ctOffSetX;
			var nH=LayerManager.stage.height-LayoutRecManager._ct.y+LayoutRecManager.ctOffHeight;
			var pW=LayoutRecManager._ct.width;
			var pH=LayoutRecManager._ct.height;
			var dW=NaN;
			var dH=NaN;
			dW=nW-pW;
			dH=nH-pH;
			if ((nW *nH *pW *pH)!=0){
				if(dW+tRec.width<0){
					console.log("width not availeble");
					LayoutRecManager.scaleResize();
					return;
				}
				if(dH+tRec.height<0){
					console.log("height not availeble");
					LayoutRecManager.scaleResize();
					return;
				}
				}else{
				console.log("wrong size");
				LayoutRecManager.scaleResize();
				return;
			};
			var tDragBar;
			var barList;
			barList=[];
			var resizeStruct;
			resizeStruct=new ResizeRecStruct();
			var workDragBar;
			for (i=0;i < len;i++){
				tDragBar=items[i];
				if ((tDragBar instanceof laya.editor.comonents.LayoutDragBar )){
					tDragBar.walked=false;
					if(tDragBar.cusorType=="e-resize"){
						if(tDragBar.x>=tRec.x+10){
							barList.push(tDragBar);
						}
					}
					if(tDragBar.type==2){
						workDragBar=tDragBar;
						switch(tDragBar.getSideType()){
							case "right":
								resizeStruct.rightSide=tDragBar;
								break ;
							case "left":
								resizeStruct.leftSide=tDragBar;
								break ;
							case "up":
								resizeStruct.upSide=tDragBar;
								break ;
							case "down":
								resizeStruct.downSide=tDragBar;
								break ;
							}
					}
				}
			}
			resizeStruct.isRoot=true;
			resizeStruct.resizeItems=[];
			resizeStruct.tryMoveRight(dW);
			barList=[];
			for (i=0;i < len;i++){
				tDragBar=items[i];
				if ((tDragBar instanceof laya.editor.comonents.LayoutDragBar )){
					tDragBar.walked=false;
					if(tDragBar.cusorType=="n-resize"){
						if(tDragBar.y>=tRec.y+tRec.height||tDragBar.y+200>nH){
							barList.push(tDragBar);
							tDragBar.top+=dH;
						}
						if(tDragBar.type==2&&tDragBar.getSideType()=="down"&&tDragBar.cusorType=="n-resize"){
							workDragBar=tDragBar;
						}
					}
				}
			}
			if(workDragBar){
			}
			LayoutRecManager._ct.width=nW;
			LayoutRecManager._ct.height=nH;
			Laya.timer.once(100,null,LayoutRecManager.adptAll);
			MenuBar.instance.width=LayerManager.stage.width-2;
			QuickTool.instance.width=LayerManager.stage.width-2;
		}

		LayoutRecManager.adptDis=function(dis,scaleX,scaleY){
			dis.left *=scaleX;
			dis.right *=scaleX;
			dis.top *=scaleY;
			dis.bottom *=scaleY;
		}

		LayoutRecManager.adptScales=function(scaleX,scaleY){
			var items;
			items=DisControlTool.getAllChild(LayoutRecManager._ct);
			var i=0,len=0;
			len=items.length;
			var tDragBar;
			for (i=0;i < len;i++){
				tDragBar=items[i];
				if ((tDragBar instanceof laya.editor.comonents.LayoutDragBar )){
					LayoutRecManager.adptDis(tDragBar,scaleX,scaleY);
				}
			}
		}

		LayoutRecManager.adptAll=function(){
			var items;
			items=DisControlTool.getAllChild(LayoutRecManager._ct);
			var i=0,len=0;
			len=items.length;
			var tDragBar;
			for (i=0;i < len;i++){
				tDragBar=items[i];
				if ((tDragBar instanceof laya.editor.comonents.LayoutDragBar )){
					tDragBar.updates();
				}
			}
		}

		LayoutRecManager.saveLayoutInfo=function(){
			var items;
			items=DisControlTool.getAllChild(LayoutRecManager._ct);
			var i=0,len=0;
			len=items.length;
			for (i=0;i < len;i++){
				IDTools.idObj(items[i]);
			};
			var rst=[];
			var tDis;
			for (i=0;i < len;i++){
				tDis=items[i];
				if ((tDis instanceof laya.editor.comonents.LayoutDragBar )){
					rst.push(LayoutRecManager.getInfoO(tDis));
				}
				else if ((tDis instanceof laya.editor.view.LayoutRec )){
					rst.push(LayoutRecManager.saveRecInfo(tDis));
				}
			};
			var saveO;
			saveO={};
			saveO.width=LayoutRecManager._ct.width;
			saveO.height=LayoutRecManager._ct.height;
			saveO.items=rst;
			FileManager.createTxtFile(FileManager.getDataPath(LayoutRecManager.tLayoutFile),ObjectTools.getJsonString(saveO));
		}

		LayoutRecManager.showPanelByClassName=function(className){
			if(LayoutRecManager.popLocked())return;
			LayoutRecManager.initClassToUIO();
			var tPanel;
			tPanel=LayoutRecManager.classToUIO[className];
			LayoutRecManager.showPanelToStage(tPanel);
		}

		LayoutRecManager.showPanelToStage=function(tPanel){
			if (!tPanel)
				return;
			if (LayoutRecManager.isPanelInStage(tPanel))
				return;
			var rec=new LayoutRec();
			if (tPanel.width > 0 && tPanel.height > 0 && 0){
				rec.width=tPanel.width+5;
				rec.height=tPanel.height+20;
			}
			else{
				rec.width=tPanel["minWidth"]? tPanel["minWidth"]:200;
				if(rec.width<200)rec.width=200;
				rec.height=300;
			}
			LayoutRecManager.addPanelToRec(tPanel,rec);
			DisTools.showToCenter(rec,LayerManager.stage);
		}

		LayoutRecManager.removePanel=function(tPanel){
			var rec;
			rec=LayoutRecManager.findPanelRec(tPanel);
			if(rec){
				rec.removeUI(tPanel,true);
			}
		}

		LayoutRecManager.isPanelInStage=function(panel){
			var i=0,len=0;
			var childs;
			var layouts;
			layouts=[];
			childs=DisControlTool.getAllChild(LayoutRecManager._ct);
			len=childs.length;
			for (i=0;i < len;i++){
				if (((childs[i])instanceof laya.editor.view.LayoutRec )){
					ObjectTools.concatArr(layouts,childs[i].getUIs());
				}
			}
			childs=DisControlTool.getAllChild(LayerManager.stage);
			len=childs.length;
			for (i=0;i < len;i++){
				if (((childs[i])instanceof laya.editor.view.LayoutRec )){
					ObjectTools.concatArr(layouts,childs[i].getUIs());
				}
			}
			len=layouts.length;
			for (i=0;i < len;i++){
				if (layouts[i]==panel)
					return true;
			}
			return false;
		}

		LayoutRecManager.findPanelRec=function(panel){
			var i=0,len=0;
			var childs;
			var layouts;
			layouts=[];
			childs=DisControlTool.getAllChild(LayoutRecManager._ct);
			len=childs.length;
			for (i=0;i < len;i++){
				if (((childs[i])instanceof laya.editor.view.LayoutRec )){
					if(LayoutRecManager.isPanelInRec(panel,childs[i])){
						return childs[i];
					}
				}
			}
			childs=DisControlTool.getAllChild(LayerManager.stage);
			len=childs.length;
			for (i=0;i < len;i++){
				if (((childs[i])instanceof laya.editor.view.LayoutRec )){
					if(LayoutRecManager.isPanelInRec(panel,childs[i])){
						return childs[i];
					}
				}
			}
			return null;
		}

		LayoutRecManager.isPanelInRec=function(panel,rec){
			var layouts;
			layouts=rec.getUIs();
			if(!layouts)return false;
			return layouts.indexOf(panel)>=0;
		}

		LayoutRecManager.initClassToUIO=function(){
			if (!LayoutRecManager.classToUIO){
				LayoutRecManager.classToUIO={};
				LayoutRecManager.classToUIO["ResPanel"]=ResPanel.instance;
				LayoutRecManager.classToUIO["PagePanel"]=PagePanel.instance;
				LayoutRecManager.classToUIO["UIPanel"]=UIPanel.instance;
				LayoutRecManager.classToUIO["PropPanel"]=PropPanel.instance;
				LayoutRecManager.classToUIO["DisplayTreePanel"]=DisplayTreePanel.instance;
				LayoutRecManager.classToUIO["TimeLinePanel"]=TimeLinePanel.instance;
				LayoutRecManager.classToUIO["CompPanel"]=CompPanel.instance;
				LayoutRecManager.classToUIO["FramePropPanel"]=FramePropPanel.instance;
				LayoutRecManager.classToUIO["BasicPanel"]=BasicPanel.instance;
			}
		}

		LayoutRecManager.layoutByPagePath=function(pagePath){
			LayoutRecManager.layoutToPageType(TypeManager.getFileType(pagePath));
		}

		LayoutRecManager.layoutToPageType=function(type){
			LayoutRecManager.recoverLayoutInfo(Paths.getLayoutFilePathByType(type));
		}

		LayoutRecManager.recoverLayoutInfo=function(layoutFile){
			(layoutFile===void 0)&& (layoutFile="layout/layout.config");
			if(LayoutRecManager._layoutFile==layoutFile)return;
			if(LayoutRecManager._layoutFile){
				LayoutRecManager.saveLayoutInfo();
			}
			LayoutRecManager.clearAll();
			LayoutRecManager.initClassToUIO();
			LayoutRecManager._layoutFile=layoutFile;
			var path;
			path=FileManager.getDataPath(LayoutRecManager.tLayoutFile);
			if (!FileTools.exist(path)){
				LayoutRecManager.createDefault();
				return;
			}
			LayoutRecManager.layoutByLayoutFile(path);
		}

		LayoutRecManager.layoutByLayoutFile=function(path){
			var layoutO;
			layoutO=ObjectTools.getObj(FileManager.readTxtFile(path));
			LayoutRecManager._ct.width=layoutO.width;
			LayoutRecManager._ct.height=layoutO.height;
			var itemList;
			itemList=layoutO.items;
			var i=0,len=0;
			len=itemList.length;
			var tO;
			var tDis;
			var tClass;
			var objDic={};
			for (i=0;i < len;i++){
				tO=itemList[i];
				tClass=LayoutRecManager.itemClassO[tO.className];
				if (!tClass)
					continue ;
				if (tClass==LayoutDragBar){
					var type=tO.width < tO.height ? "R" :"T";
					tDis=LayoutRecManager.getADragBar(type);
				}
				else{
					tDis=new tClass();
				}
				ObjectTools.copyValueByArr(tDis,tO,LayoutRecManager.sizeInfos);
				objDic[tO.id]=tDis;
				if ((tDis instanceof laya.editor.comonents.LayoutDragBar )){
				}
				if ((tDis instanceof laya.editor.view.LayoutRec )){
					LayoutRecManager.recoverLayoutRec(tDis,tO);
				}
				LayoutRecManager._ct.addChild(tDis);
			};
			var key;
			var tar;
			var relativeO;
			for (i=0;i < len;i++){
				tO=itemList[i];
				tDis=objDic[tO.id];
				relativeO=tO.relativeO;
				if (relativeO){
					for (key in relativeO){
						tar=objDic[relativeO[key]];
						if (tar){
							RelativePos.addRelative(tDis,tar,key);
						}
						else{
							console.log("tar not find");
						}
					}
				}
				else{
					console.log("relativeO not find");
				}
				ObjectTools.copyValueByArr(tDis,tO,LayoutRecManager.sizeInfos);
			}
			LayoutRecManager.adptAll();
			LayoutRecManager.resizeWork();
		}

		LayoutRecManager.recoverLayoutRec=function(rec,data){
			var i=0,len=0;
			var uiList;
			uiList=data.uiList;
			len=uiList.length;
			var tUI;
			for (i=0;i < len;i++){
				tUI=LayoutRecManager.classToUIO[uiList[i]];
				if (tUI){
					LayoutRecManager.addPanelToRec(tUI,rec);
				}
			}
			if(parseInt(data.select)>0){
				rec.tab.selectedIndex=data.select;
			}
			if(rec.tab.items.length<1){
				Laya.timer.once(1000,null,LayoutRecManager.removeRec,[rec]);
			}
		}

		LayoutRecManager.saveRecInfo=function(rec){
			var rst;
			rst=LayoutRecManager.getInfoO(rec);
			var uiList;
			var i=0,len=0;
			uiList=rec.tab.items;
			var saveList;
			len=uiList.length;
			var tab;
			saveList=[];
			for (i=0;i < len;i++){
				tab=uiList[i];
				saveList.push(ClassTool.getClassName(tab.ui));
			}
			rst.select=rec.tab.selectedIndex;
			rst.uiList=saveList;
			return rst;
		}

		LayoutRecManager.getInfoO=function(obj){
			var rst;
			rst={};
			ObjectTools.copyValueByArr(rst,obj,LayoutRecManager.sizeInfos);
			rst.className=ClassTool.getClassName(obj);
			rst.id=IDTools.getObjID(obj);
			rst.relativeO=RelativePos.saveRelative(obj);
			return rst;
		}

		LayoutRecManager.onDragDrop=function(e){
			if (!e.data)
				return;
			var tType;
			tType=e.data.type;
			if (tType !="LayoutRec" && tType !="LayoutTab")
				return;
			var src;
			src=e.data.target;
			if (!src)
				return;
			var hitList;
			hitList=e.hitList;
			var i=0,len=0;
			len=hitList.length;
			var tTarget;
			if (hitList.indexOf(src)>=0){
				tTarget=src;
				if (tType !="LayoutTab"){
					if (tType=="LayoutRec"){
						LayoutRecManager.popRec(src);
						return;
					}
				}
			}
			else{
				for (i=0;i < len;i++){
					tTarget=hitList[i];
					if ((tTarget instanceof laya.editor.view.LayoutRec )){
						if(RelativePos.getDisMouseRelativePos(tTarget)!="out"){
							break ;
						}
					}
				}
			}
			if (!((tTarget instanceof laya.editor.view.LayoutRec )))
				return;
			if(tTarget.parent!=LayoutRecManager._ct)return;
			if (src !=tTarget || tType=="LayoutTab"){
				var posType;
				posType=RelativePos.getDisMouseRelativePos(tTarget);
				if (tType=="LayoutRec"){
					switch (posType){
						case "up":
							LayoutRecManager.removeRec(src);
							LayoutRecManager.insetToBarV(RelativePos.getBar(tTarget,"up"),src);
							break ;
						case "down":
							LayoutRecManager.removeRec(src);
							LayoutRecManager.insertV(tTarget,src);
							break ;
						case "left":
							LayoutRecManager.removeRec(src);
							LayoutRecManager.insertL(tTarget,src);
							break ;
						case "center":
							if(src.parent==LayerManager.stage)return;
						case "right":
							LayoutRecManager.removeRec(src);
							LayoutRecManager.insert(tTarget,src);
							break ;
						default :
							return;
						}
				}
				else if (tType=="LayoutTab"){
					var tTab;
					tTab=e.dragInitiator;
					var tRec;
					tRec=tTarget;
					if (src==tTarget){
						if (src.tab.items.length <=1){
							LayoutRecManager.popRec(src);
							return;
						}
						else{
							if (posType=="center"){
								src.removeTab(tTab);
								tRec=new LayoutRec();
								tRec.pos(src.x,src.y);
								src.parent.addChild(tRec);
								tRec.addTab(tTab);
								LayoutRecManager.popRec(tRec);
								return;
							}
						}
					}
					switch (posType){
						case "down":
							src.removeTab(tTab);
							tRec=new LayoutRec();
							tRec.addTab(tTab);
							LayoutRecManager.insertV(tTarget,tRec);
							break ;
						case "right":
							src.removeTab(tTab);
							tRec=new LayoutRec();
							tRec.addTab(tTab);
							LayoutRecManager.insert(tTarget,tRec);
							break ;
						case "left":
							src.removeTab(tTab);
							tRec=new LayoutRec();
							tRec.addTab(tTab);
							LayoutRecManager.insertL(tTarget,tRec);
							break ;
						case "center":
						case "up":
							if(!tRec.canAddTab)return;
							if (src !=tRec){
								src.removeTab(tTab);
								tRec.addTab(tTab);
							}
							else{
								return;
								src.removeTab(tTab);
								tRec=new LayoutRec();
								tRec.addTab(tTab);
								LayoutRecManager.popRec(tRec);
							}
							break ;
						default :
							return;
						}
					if (src.tab.items.length < 1){
						LayoutRecManager.removeRec(src);
					}
				}
			}
		}

		LayoutRecManager.test=function(){
			var _leftBar;
			var _rightBar;
			var _upBar;
			var _downBar;
			_leftBar=LayoutRecManager.getADragBar("R");
			_leftBar.width=5;
			_leftBar.left=0;
			_leftBar.top=0;
			_leftBar.bottom=0;
			_leftBar.type=2;
			LayoutRecManager._ct.addChild(_leftBar);
			_rightBar=LayoutRecManager.getADragBar("R");
			_rightBar.width=5;
			_rightBar.right=0;
			_rightBar.top=0;
			_rightBar.bottom=0;
			_rightBar.type=2;
			LayoutRecManager._ct.addChild(_rightBar);
			_upBar=LayoutRecManager.getADragBar("T");
			_upBar.height=5;
			_upBar.left=0;
			_upBar.top=0;
			_upBar.right=0;
			_upBar.type=2;
			LayoutRecManager._ct.addChild(_upBar);
			_downBar=LayoutRecManager.getADragBar("T");
			_downBar.height=5;
			_downBar.left=0;
			_downBar.bottom=0;
			_downBar.right=0;
			_downBar.type=2;
			LayoutRecManager._ct.addChild(_downBar);
			var rec=LayoutRecManager.getARec();
			LayoutRecManager._ct.addChild(rec);
			rec.left=0;
			rec.right=0;
			rec.top=0;
			rec.bottom=0;
			RelativePos.addRelative(rec,_leftBar,"left");
			RelativePos.addRelative(rec,_rightBar,"right");
			RelativePos.addRelative(rec,_upBar,"up");
			RelativePos.addRelative(rec,_downBar,"down");
			LayoutRecManager.insert(rec,LayoutRecManager.getARec());
			var tRec;
			tRec=LayoutRecManager.getARec();
			LayoutRecManager.insertV(rec,tRec);
			LayoutRecManager.insert(tRec,LayoutRecManager.getARec());
			console.log("onlySide:",RelativePos.getOnlySide(tRec));
			LayoutRecManager.insertV(tRec,LayoutRecManager.getARec());
			console.log("onlySide:",RelativePos.getOnlySide(tRec));
		}

		LayoutRecManager.clearAll=function(){
			LayoutRecManager.clearLayoutsOfContainer(LayoutRecManager._ct);
			LayoutRecManager.clearLayoutsOfContainer(LayerManager.stage);
		}

		LayoutRecManager.clearLayoutsOfContainer=function(_ct){
			var items;
			items=DisControlTool.getAllChild(_ct);
			var i=0,len=0;
			len=items.length;
			var tDis;
			for (i=0;i < len;i++){
				tDis=items[i];
				if ((tDis instanceof laya.editor.comonents.LayoutDragBar )){
					(tDis).clears();
					tDis.removeSelf();
				}
				else if ((tDis instanceof laya.editor.view.LayoutRec )){
					(tDis).clears();
					tDis.removeSelf();
				}
			}
		}

		LayoutRecManager.createDefault=function(){
			LayoutRecManager.clearAll();
			LayoutRecManager.resizeWork();
			var path;
			path=FileManager.getAppPath("laya/tpls/default.config");
			if(FileTools.exist(path)){
				LayoutRecManager.layoutByLayoutFile(path);
				return;
			};
			var _leftBar;
			var _rightBar;
			var _upBar;
			var _downBar;
			_leftBar=LayoutRecManager.getADragBar("R");
			_leftBar.width=5;
			_leftBar.left=0;
			_leftBar.top=0;
			_leftBar.bottom=0;
			_leftBar.type=2;
			LayoutRecManager._ct.addChild(_leftBar);
			_rightBar=LayoutRecManager.getADragBar("R");
			_rightBar.width=5;
			_rightBar.right=0;
			_rightBar.top=0;
			_rightBar.bottom=0;
			_rightBar.type=2;
			LayoutRecManager._ct.addChild(_rightBar);
			_upBar=LayoutRecManager.getADragBar("T");
			_upBar.height=5;
			_upBar.left=0;
			_upBar.top=0;
			_upBar.right=0;
			_upBar.type=2;
			LayoutRecManager._ct.addChild(_upBar);
			_downBar=LayoutRecManager.getADragBar("T");
			_downBar.height=5;
			_downBar.left=0;
			_downBar.bottom=0;
			_downBar.right=0;
			_downBar.type=2;
			LayoutRecManager._ct.addChild(_downBar);
			RelativePos.addRelative(_upBar,_leftBar,"left");
			RelativePos.addRelative(_upBar,_rightBar,"right");
			RelativePos.addRelative(_downBar,_leftBar,"left");
			RelativePos.addRelative(_downBar,_rightBar,"right");
			RelativePos.addRelative(_leftBar,_upBar,"up");
			RelativePos.addRelative(_leftBar,_downBar,"down");
			RelativePos.addRelative(_rightBar,_upBar,"up");
			RelativePos.addRelative(_rightBar,_downBar,"down");
			var rec=new LayoutRec();
			LayoutRecManager._ct.addChild(rec);
			rec.left=0;
			rec.right=0;
			rec.top=0;
			rec.bottom=0;
			RelativePos.addRelative(rec,_leftBar,"left");
			RelativePos.addRelative(rec,_rightBar,"right");
			RelativePos.addRelative(rec,_upBar,"up");
			RelativePos.addRelative(rec,_downBar,"down");
			LayoutRecManager.addPanelToRec(PagePanel.instance,rec);
			var uiRec;
			uiRec=new LayoutRec();
			LayoutRecManager.insert(rec,uiRec,0.8);
			LayoutRecManager.addPanelToRec(UIPanel.instance,uiRec);
			var resRec;
			resRec=new LayoutRec();
			LayoutRecManager.insertV(rec,resRec);
			LayoutRecManager.addPanelToRec(CompPanel.instance,resRec);
			LayoutRecManager.addPanelToRec(ResPanel.instance,resRec);
			var propRec;
			propRec=new LayoutRec();
			LayoutRecManager.insert(uiRec,propRec,0.3);
			LayoutRecManager.addPanelToRec(PropPanel.instance,propRec);
			var disTreeRec;
			disTreeRec=new LayoutRec();
			LayoutRecManager.insertV(propRec,disTreeRec);
			LayoutRecManager.addPanelToRec(DisplayTreePanel.instance,disTreeRec);
		}

		LayoutRecManager.popRec=function(tar){
			if (tar.parent==LayerManager.stage)
				return;
			var point;
			point=new Point();
			point=tar.localToGlobal(point);
			point=LayerManager.stage.globalToLocal(point);
			var posInfo={};
			ObjectTools.copyValueByArr(posInfo,tar,LayoutRecManager.sizePosKeys);
			posInfo.x=point.x+DragManager.dPos.x;
			posInfo.y=point.y+DragManager.dPos.y;
			LayoutRecManager.removeRec(tar);
			DisControlTool.clearItemRelativeInfo(tar);
			LayoutRecManager.addToStageLater(tar,posInfo);
		}

		LayoutRecManager.addToStageLater=function(tar,posInfo){
			LayerManager.stage.addChild(tar);
			if(posInfo.height<200)posInfo.height=200;
			tar.x=posInfo.x-10;
			tar.y=posInfo.y-10;
			tar.width=posInfo.width+20;
			tar.height=posInfo.height+20;
		}

		LayoutRecManager.clearRelativePosition=function(tar){
			tar.top=NaN;
			tar.bottom=NaN;
			tar.left=NaN;
			tar.right=NaN;
		}

		LayoutRecManager.removeRec=function(tar){
			var onlySide;
			onlySide=RelativePos.getOnlySide(tar);
			if (!onlySide){
				console.log("无可拖动条");
				tar.removeSelf();
				RelativePos.clearBar(tar);
				return;
			};
			var onlyBar;
			onlyBar=RelativePos.getBar(tar,onlySide);
			var otherSide;
			otherSide=RelativePos.getOtherSide(onlySide);
			var otherBar;
			otherBar=RelativePos.getBar(tar,otherSide);
			if (onlyBar && otherBar){
				otherBar.mergeUpdates(onlyBar);
				onlyBar.removeSelf();
				onlyBar.clears();
				RelativePos.clearBar(onlyBar);
				tar.removeSelf();
				RelativePos.clearBar(tar);
			}
			LayoutRecManager.adptAll();
		}

		LayoutRecManager.minRec=function(tar){
			var onlySide;
			onlySide=RelativePos.getOnlySide(tar);
			if (!onlySide)
				return;
			var onlyBar;
			onlyBar=RelativePos.getBar(tar,onlySide);
			var otherSide;
			otherSide=RelativePos.getOtherSide(onlySide);
			var otherBar;
			otherBar=RelativePos.getBar(tar,otherSide);
			if (onlyBar && otherBar){
				switch (onlySide){
					case "right":
						onlyBar.left-=tar.width-4;
						break ;
					case "left":
						onlyBar.left+=tar.width-4;
						break ;
					case "up":
						onlyBar.top+=tar.height-4;
						break ;
					case "down":
						onlyBar.top-=tar.height-4;
						break ;
					}
			}
			onlyBar.updates();
		}

		LayoutRecManager.recoverRec=function(tar){
			var onlySide;
			onlySide=RelativePos.getOnlySide(tar);
			if (!onlySide)
				return;
			var onlyBar;
			onlyBar=RelativePos.getBar(tar,onlySide);
			var otherSide;
			otherSide=RelativePos.getOtherSide(onlySide);
			var otherBar;
			otherBar=RelativePos.getBar(tar,otherSide);
			if (onlyBar && otherBar){
				switch (onlySide){
					case "right":
						onlyBar.left-=tar.width-tar.preWidth;
						break ;
					case "left":
						onlyBar.left+=tar.width-tar.preWidth;
						break ;
					case "up":
						onlyBar.top+=tar.height-tar.preHeight;
						break ;
					case "down":
						onlyBar.top-=tar.height-tar.preHeight;
						break ;
					}
			}
			onlyBar.updates();
		}

		LayoutRecManager.adptTo=function(tar){
			var onlySide;
			onlySide=RelativePos.getOnlySide(tar);
			if (!onlySide)
				return;
			var onlyBar;
			onlyBar=RelativePos.getBar(tar,onlySide);
			var otherSide;
			otherSide=RelativePos.getOtherSide(onlySide);
			var otherBar;
			otherBar=RelativePos.getBar(tar,otherSide);
			if (onlyBar && otherBar){
				switch (onlySide){
					case "right":
						onlyBar.left=tar.left+tar.width;
						break ;
					case "left":
						onlyBar.left=tar.left-onlyBar.width;
						break ;
					case "up":
						onlyBar.top=tar.top-onlyBar.height;
						break ;
					case "down":
						onlyBar.top=tar.top+tar.height;
						break ;
					}
			}
			onlyBar.updates();
		}

		LayoutRecManager.insetToBar=function(tar,insert,rate){
			(rate===void 0)&& (rate=0.4);
			var rec;
			rec=tar.getDragArea();
			rec.width=200;
			if (rec.width < 20)
				return;
			var tLen=0;
			tLen=rec.width;
			var dragBar;
			dragBar=LayoutRecManager.getADragBar("R");
			dragBar.size(5,tar.height);
			dragBar.right=tar.right;
			dragBar.left=tar.left
			dragBar.top=tar.top;
			dragBar.bottom=tar.bottom;
			dragBar.type=0;
			dragBar.mergeUpdates(tar);
			tar.clear();
			dragBar.left+=rate *tLen;
			RelativePos.clearBar(insert);
			insert.left=tar.left
			insert.top=tar.top;
			insert.bottom=tar.bottom;
			if (RelativePos.getBar(tar,"right")){
				RelativePos.copyRelative(dragBar,tar,"right");
			}
			RelativePos.addRelative(insert,tar,"left");
			RelativePos.addRelative(insert,dragBar,"right");
			RelativePos.copyRelative(insert,tar,"down");
			RelativePos.copyRelative(dragBar,tar,"down");
			RelativePos.copyRelative(insert,tar,"up");
			RelativePos.copyRelative(dragBar,tar,"up");
			LayoutRecManager._ct.addChild(dragBar);
			LayoutRecManager._ct.addChild(insert);
			LayoutRecManager.adptAll();
		}

		LayoutRecManager.insetToBarV=function(tar,insert,rate){
			(rate===void 0)&& (rate=0.4);
			var rec;
			rec=tar.getDragArea();
			rec.height=200;
			if (rec.height < 20)
				return;
			var tLen=0;
			tLen=rec.height;
			var dragBar;
			dragBar=LayoutRecManager.getADragBar("T");
			dragBar.size(tar.width,5);
			dragBar.right=tar.right;
			dragBar.left=tar.left
			dragBar.top=tar.top;
			dragBar.bottom=tar.bottom;
			dragBar.type=1;
			dragBar.copyUpdates(tar,"up");
			dragBar.top+=rate *tLen;
			RelativePos.clearBar(insert);
			insert.right=tar.right;
			insert.left=tar.left
			insert.top=tar.top;
			insert.bottom=tar.bottom;
			if (RelativePos.getBar(tar,"down")){
				RelativePos.copyRelative(dragBar,tar,"down");
				RelativePos.cancelRelative(tar,"down");
			}
			RelativePos.addRelative(insert,tar,"up");
			RelativePos.addRelative(insert,dragBar,"down");
			RelativePos.copyRelative(insert,tar,"right");
			RelativePos.copyRelative(dragBar,tar,"right");
			RelativePos.copyRelative(insert,tar,"left");
			RelativePos.copyRelative(dragBar,tar,"left");
			LayoutRecManager._ct.addChild(dragBar);
			LayoutRecManager._ct.addChild(insert);
			LayoutRecManager.adptAll();
		}

		LayoutRecManager.insert=function(tar,insert,rate){
			(rate===void 0)&& (rate=0.4);
			var tLen=0;
			tLen=tar.width;
			insert.right=tar.right;
			tar.right+=tLen *rate;
			insert.left=tar.x+tar.width;
			insert.top=tar.top;
			insert.bottom=tar.bottom;
			var dragBar;
			dragBar=LayoutRecManager.getADragBar("R");
			dragBar.size(5,tar.height);
			dragBar.left=tar.x+tar.width;
			dragBar.top=tar.top;
			dragBar.bottom=tar.bottom;
			if (RelativePos.getBar(tar,"right")){
				RelativePos.copyRelative(insert,tar,"right");
				RelativePos.cancelRelative(tar,"right");
			}
			RelativePos.addRelative(tar,dragBar,"right");
			RelativePos.addRelative(insert,dragBar,"left");
			RelativePos.copyRelative(insert,tar,"down");
			RelativePos.copyRelative(dragBar,tar,"down");
			RelativePos.copyRelative(insert,tar,"up");
			RelativePos.copyRelative(dragBar,tar,"up");
			tar.parent.addChild(dragBar);
			tar.parent.addChild(insert);
			DisControlTool.setTop(dragBar);
			dragBar.type=0;
			LayoutRecManager.adptAll();
		}

		LayoutRecManager.insertL=function(tar,insert,rate){
			(rate===void 0)&& (rate=0.4);
			var tLen=0;
			tLen=tar.width;
			insert.right=tar.right;
			insert.left=tar.left;
			tar.left+=tLen *rate;
			insert.top=tar.top;
			insert.bottom=tar.bottom;
			var dragBar;
			dragBar=LayoutRecManager.getADragBar("R");
			dragBar.size(5,tar.height);
			dragBar.left=tar.x;
			dragBar.top=tar.top;
			dragBar.bottom=tar.bottom;
			if (RelativePos.getBar(tar,"left")){
				RelativePos.copyRelative(insert,tar,"left");
				RelativePos.cancelRelative(tar,"left");
			}
			RelativePos.addRelative(tar,dragBar,"left");
			RelativePos.addRelative(insert,dragBar,"right");
			RelativePos.copyRelative(insert,tar,"down");
			RelativePos.copyRelative(dragBar,tar,"down");
			RelativePos.copyRelative(insert,tar,"up");
			RelativePos.copyRelative(dragBar,tar,"up");
			tar.parent.addChild(dragBar);
			tar.parent.addChild(insert);
			DisControlTool.setTop(dragBar);
			dragBar.type=0;
			LayoutRecManager.adptAll();
		}

		LayoutRecManager.insertV=function(tar,insert,rate){
			(rate===void 0)&& (rate=0.4);
			if(tar.height<150){
				var downBar;
				downBar=RelativePos.getBar(tar,"down");
				if(downBar.type!=2){
					LayoutRecManager.insetToBarV(downBar,insert);
					return;
				}
			};
			var tLen=0;
			tLen=tar.height;
			insert.right=tar.right;
			insert.bottom=tar.bottom;
			tar.bottom+=tLen *rate;
			insert.left=tar.left;
			insert.top=tar.y+tar.height;
			var dragBar;
			dragBar=LayoutRecManager.getADragBar("T");
			dragBar.size(tar.width,5);
			dragBar.left=tar.x;
			dragBar.top=tar.y+tar.height;
			if (RelativePos.getBar(tar,"down")){
				RelativePos.copyRelative(insert,tar,"down");
				RelativePos.cancelRelative(tar,"down");
			}
			RelativePos.addRelative(tar,dragBar,"down");
			RelativePos.addRelative(insert,dragBar,"up");
			RelativePos.copyRelative(insert,tar,"right");
			RelativePos.copyRelative(dragBar,tar,"right");
			RelativePos.copyRelative(insert,tar,"left");
			RelativePos.copyRelative(dragBar,tar,"left");
			tar.parent.addChild(dragBar);
			tar.parent.addChild(insert);
			DisControlTool.setTop(dragBar);
			dragBar.type=1;
			LayoutRecManager.adptAll();
		}

		LayoutRecManager.getADragBar=function(type){
			var dragBar=new LayoutDragBar(type);
			dragBar.on("mousedown",null,LayoutRecManager.onMouseDown);
			return dragBar;
		}

		LayoutRecManager.addPanelToRec=function(panel,rec){
			panel.top=20;
			panel.left=0;
			panel.right=0;
			panel.bottom=0;
			rec.addUI(panel);
		}

		LayoutRecManager.getARec=function(){
			var rec=new LayoutRec();
			rec.addUI(LayoutRecManager.getAUI("#ff00ff"));
			rec.addUI(LayoutRecManager.getAUI("#ff000f"));
			return rec;
		}

		LayoutRecManager.getAUI=function(color){
			(color===void 0)&& (color="#ff00ff");
			var box=new Box();
			box.graphics.drawRect(0,0,20,20,color);
			box.width=20;
			box.height=20;
			box.left=5;
			box.right=5;
			box["title"]="tt:"+Math.ceil(Math.random()*10);
			return box;
		}

		LayoutRecManager.target=null
		LayoutRecManager.Side=2;
		LayoutRecManager.Vertical=1;
		LayoutRecManager.Horizon=0;
		LayoutRecManager._ct=null
		LayoutRecManager.ctOffSetX=47;
		LayoutRecManager.dToQuickTool=32;
		LayoutRecManager.ctOffHeight=5;
		LayoutRecManager.classToUIO=null
		LayoutRecManager._layoutFile=null;
		LayoutRecManager.minRecLen=4;
		LayoutRecManager.DragBarWidth=5;
		__static(LayoutRecManager,
		['itemClassO',function(){return this.itemClassO={"LayoutDragBar":LayoutDragBar,"LayoutRec":LayoutRec};},'sizeInfos',function(){return this.sizeInfos=["height","width","left","right","bottom","top","x","y","type"];},'sizePosKeys',function(){return this.sizePosKeys=["x","y","width","height"];},'emptyLayoutO',function(){return this.emptyLayoutO={"top":NaN,"bottom":NaN,"left":NaN,"right":NaN};}
		]);
		return LayoutRecManager;
	})()


	/**
	*本类集中初始化各个模块监听的消息
	*@author ww
	*@version 1.0
	*
	*@created 2015-10-26 上午10:39:45
	*/
	//class laya.ide.managers.NoticeRouter
	var NoticeRouter=(function(){
		function NoticeRouter(){}
		__class(NoticeRouter,'laya.ide.managers.NoticeRouter');
		NoticeRouter.init=function(){
			NoticeRouter._initsList=[];
			NoticeRouter._initsList.push(AddDocument.instance);
			NoticeRouter._initsList.push(AddAnimation.instance);
			NoticeRouter._initsList.push(PagePanel.instance);
			NoticeRouter._initsList.push(UIPanel.instance);
			NoticeRouter._initsList.push(ResPanel.instance);
			NoticeRouter._initsList.push(AddDirectory.instance);
			NoticeRouter._initsList.push(MovePage.instance);
			NoticeRouter._initsList.push(RenamePage.instance);
			NoticeRouter._initsList.push(SetPageProp.instance);
			NoticeRouter._initsList.push(PropPanel.instance);
			NoticeRouter._initsList.push(DisplayTreePanel.instance);
			NoticeRouter._initsList.push(FindAndReplace.instance);
			NoticeRouter._initsList.push(FramePropPanel.instance);
			NoticeRouter._initsList.push(LangPanel.instance);
			NoticeRouter._initsList.push(SetIDE.instance);
			NoticeRouter._initsList.push(BasicPanel.instance);
			var i=0,len=NoticeRouter._initsList.length;
			for (i=0;i < len;i++){
				NoticeRouter._initsList[i].initListener();
			}
			Laya.stage.on("keydown",null,NoticeRouter.onKeyDown);
		}

		NoticeRouter.onKeyDown=function(e){
			if(!e.ctrlKey)return;
			switch(e.keyCode){
				case 73:
					Notice1.notify("OPEN_ADD_TIMELINE_ANIMATION");
					return;
				case 77:
					return;
				}
		}

		NoticeRouter._initsList=null
		return NoticeRouter;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-8-10 上午10:56:47
	*/
	//class laya.ide.managers.PluginManager
	var PluginManager=(function(){
		function PluginManager(){
			PluginPanel;
		}

		__class(PluginManager,'laya.ide.managers.PluginManager');
		var __proto=PluginManager.prototype;
		__proto.loadPlugins=function(){
			var config;
			var configPath;
			configPath=Paths.getPluginPath("plugin.cfg");
			if(FileTools.exist(configPath)){
				try{
					config=FileManager.readJSONFile(configPath);
					}catch(e){
				}
			}
			if(config){
				this.loadPluginsByConfig(config);
			}
		}

		__proto.loadPluginsByConfig=function(config){
			var pluginList;
			pluginList=config["plugins"];
			var i=0,len=0;
			len=pluginList.length;
			for(i=0;i<len;i++){
				this.loadPlugin(pluginList[i]);
			}
		}

		__proto.loadPlugin=function(plugin){
			var pluginPath;
			pluginPath=Paths.getPluginPath(plugin);
			if(!FileTools.exist(pluginPath)){
				console.log("plugin not find:",plugin);
				return;
			};
			var pluginConfig;
			try{
				pluginConfig=FileManager.readJSONFile(FileManager.getPath(pluginPath,"config.cfg"));
				}catch(e){
			}
			if(!pluginConfig){
				console.log("pluginConfig not find:",plugin);
				return;
			};
			var codes;
			codes=pluginConfig.codes;
			var i=0,len=0;
			len=codes.length;
			for(i=0;i<len;i++){
				this.loadPluginCodes(codes[i],pluginPath);
			}
			if(pluginConfig["menus"]){
				PluginManager.regMenus(pluginConfig["menus"]);
			}
		}

		__proto.loadPluginCodes=function(codeO,pluginPath){
			var hasUI=false;
			var htmlSp;
			var uiFile;
			var jsFile;
			if(codeO["ui"]){
				uiFile=FileManager.readTxtFile(FileManager.getPath(pluginPath,codeO["ui"]));
				hasUI=true;
			}
			if(codeO["code"]){
				jsFile=FileManager.readTxtFile(FileManager.getPath(pluginPath,codeO["code"]));
				eval(jsFile);
			};
			var plugin;
			if(codeO["class"]){
				var clz;
				var clzStr;
				clzStr=codeO["class"];
				clz=eval(clzStr);
				if(clz){
					plugin=new clz();
				}
			}
			if(!plugin)return;
			if(hasUI){
				htmlSp=new JSPlugin();
				htmlSp.setHtmlTxt(uiFile);
				htmlSp.title=codeO["title"];
			}
			if(codeO["isPanel"]){
				if(htmlSp){
					plugin.setUI(htmlSp);
					}else{
					plugin.title=codeO["title"];
					plugin.canClose=true;
				}
				}else{
				if(codeO["isDialog"]){
					var dialog;
					if(htmlSp){
						dialog=new PluginDialog();
						if(plugin.width&&plugin.height){
							htmlSp.size(plugin.width,plugin.height);
						}
						dialog.setHtmlContent(htmlSp);
						plugin.setUI(dialog);
						}else{
						dialog=plugin;
					}
					dialog.setTitle(codeO["title"]);
				}
			}
		}

		PluginManager.regMenus=function(menuList){
			var i=0,len=0;
			len=menuList.length;
			for(i=0;i<len;i++){
				var tMenuO;
				tMenuO=menuList[i];
				MenuBar.registButton("layaToolsMenu",tMenuO["title"],tMenuO["notice"]);
			}
		}

		__static(PluginManager,
		['I',function(){return this.I=new PluginManager();}
		]);
		return PluginManager;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-3-5 上午11:00:22
	*/
	//class laya.ide.managers.RenderManager
	var RenderManager=(function(){
		function RenderManager(){
			this.param=null;
			this.initors=[];
		}

		__class(RenderManager,'laya.ide.managers.RenderManager');
		var __proto=RenderManager.prototype;
		__proto.initCustomUIConfig=function(path){
			var bPath;
			bPath=FileManager.getAppPath(path);
			if(!FileTools.exist(bPath))return;
			var fileList;
			fileList=FileTools.getDirFiles(bPath);
			var i=0,len=0;
			len=fileList.length;
			var tFile;
			for(i=0;i<len;i++){
				tFile=fileList[i];
				if(tFile.indexOf(".xml")>=0){
					this.addCustomUIConfig(FileTools.getPath(bPath,tFile));
				}
			}
		}

		__proto.addCustomUIConfig=function(path){
			var jsFile;
			jsFile=path.replace(".xml",".js");
			var xmlFile;
			xmlFile=FileTools.readFile(path);
			var xml;
			xml=Utils.parseXMLFromString(xmlFile);
			var obj;
			obj=XML2Object.parse(xml);
			UIConfigManager.addNewConfig(obj.c.uiComp.c);
			if(!FileTools.exist(jsFile))return;
			var jsStrs;
			jsStrs=FileTools.readFile(jsFile);
			var tempscript=Browser.document.createElement("script");
			tempscript.innerHTML=jsStrs;
			Browser.document.body.appendChild(tempscript);
			var me=this;
			var initor;
			initor=laya.ide.Initiator;
			if(initor){
				me.initors.push(initor);
			}
			this.setRenderPropByFont(null);
		}

		__proto.setRenderProp=function(param){
			var i=0,len=0;
			len=this.initors.length;
			var initor;
			for(i=0;i<len;i++){
				initor=this.initors[i];
				if(initor&&initor["init"]){
					initor["init"](param);
				}
			}
		}

		__proto.setRenderPropByFont=function(font){
			if(!this.param){
				this.param={};
				this.param.createComp=UIView.createCompS;
			}
			if(font&&font.length>0){
				this.param.font=font;
				}else{
				delete this.param["font"];
			}
			this.setRenderProp(this.param);
		}

		__proto.initRenders=function(){
			this.initCustomUIConfig("renders/");
			this.initCustomUIConfig("renders/"+"/custom");
			this.setRenderPropByFont(null);
		}

		__static(RenderManager,
		['I',function(){return this.I=new RenderManager();}
		]);
		return RenderManager;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.ide.managers.ResFileManager
	var ResFileManager=(function(){
		function ResFileManager(){}
		__class(ResFileManager,'laya.ide.managers.ResFileManager');
		ResFileManager.setPath=function(path){
			if(ResFileManager._oldGetRes==null){
			}
			if(!FileTools.exist(path))return;
			ResFileManager._prePath=path;
			ResFileManager.basePath=FileTools.getAbsPath(path);
			if (SystemSetting.isCMDVer)return;
			if(!ResFileManager._watcher){
				ResFileManager._watcher=new DirWatcherNew();
			}
			ResFileManager._watcher.setPath(path);
			ResFileManager.getAllResFiles(path);
			Notice1.listen("RESFILE_CHANGE",null,ResFileManager.resFileChange,null,true);
		}

		ResFileManager.resFileChange=function(file){
			if(!file)return;
			if(!FileTools.exist(file))return;
			if(FontLoader.isFontFile(file)){
				file=FileTools.getAbsPath(file);
				if(!FontLoader.isOkFont(file))return;
				var tdata;
				tdata=FontLoader.getFontLoaderItem(file);
				ResFileManager.clearRes(tdata.url);
				Laya.loader.load([tdata],new Handler(null,ResFileManager.resLoaded));
				return;
			}
			if(!ResFileManager.isResFile(file))return;
			file=FileTools.getAbsPath(file);
			ResFileManager.clearRes(file);
			Laya.loader.load([file],new Handler(null,ResFileManager.resLoaded));
		}

		ResFileManager.clearPreLoadRes=function(){
			var i=0,len=0;
			len=ResFileManager.preLoadList.length;
			for(i=0;i<len;i++){
				ResFileManager.clearRes(ResFileManager.preLoadList[i]);
			}
			ResFileManager.preLoadList.length=0;
		}

		ResFileManager.getAllResFiles=function(path){
			ResFileManager.clearPreLoadRes();
			path=path?path:ResFileManager._prePath;
			if(!FileTools.exist(path))return;
			var arr;
			arr=FileTools.getFileList(path);
			var i=0,len=0;
			len=arr.length;
			var loadList;
			loadList=[];
			for(i=0;i<len;i++){
				if (ResFileManager.isResFile(arr[i])){
					if(ResFileManager.enableBinaryPic)continue ;
					arr[i]=FileTools.getAbsPath(arr[i]);
					ResFileManager.clearRes(arr[i]);
					loadList.push(arr[i]);
					ResFileManager.preLoadList.push(arr[i]);
				}
				if(FontLoader.isFontFile(arr[i])){
					arr[i]=FileTools.getAbsPath(arr[i]);
					if(!FontLoader.isOkFont(arr[i]))continue ;
					var tdata;
					tdata=FontLoader.getFontLoaderItem(arr[i]);
					ResFileManager.clearRes(tdata.url);
					loadList.push(tdata);
					ResFileManager.preLoadList.push(arr[i]);
				}
			}
			if(loadList.length<1){
				ResFileManager.resLoaded();
				return;
			}
			Laya.loader.load(loadList,new Handler(null,ResFileManager.resLoaded));
		}

		ResFileManager.getAllResFileList=function(path){
			path=path?path:ResFileManager._prePath;
			if(!FileTools.exist(path))return [];
			var arr;
			arr=FileTools.getFileList(path);
			var i=0,len=0;
			len=arr.length;
			var loadList;
			loadList=[];
			for(i=0;i<len;i++){
				if (ResFileManager.isResFile(arr[i])){
					loadList.push(arr[i]);
				}
			}
			return loadList;
		}

		ResFileManager.getAllResLinkList=function(path){
			path=path?path:ResFileManager._prePath;
			var resList;
			resList=ResFileManager.getAllResFileList(path);
			var i=0,len=0;
			var rst;
			rst=[];
			len=resList.length;
			for(i=0;i<len;i++){
				rst.push(FileManager.adptToCommonUrl(FileManager.getRelativePath(SystemSetting.assetsPath,resList[i])));
			}
			return rst;
		}

		ResFileManager.getAllUnPackLinkList=function(path){
			path=path?path:ResFileManager._prePath;
			path=path?path:ResFileManager._prePath;
			var resList;
			resList=ResFileManager.getAllResFileList(path);
			var i=0,len=0;
			var rst;
			rst=[];
			len=resList.length;
			var compStr;
			for(i=0;i<len;i++){
				compStr=FileManager.adptToCommonUrl(FileManager.getRelativePath(SystemSetting.assetsPath,resList[i]));
				if(!ResStyleManager.getFinalPackResult(compStr,ResPanel.isPackRes(compStr)||compStr.indexOf(".")<=0)){
					rst.push(compStr);
				}
			}
			return rst;
		}

		ResFileManager.resLoaded=function(){
			console.log("resLoaded");
			if(ResFileManager.resLoadCompleteHandler){
				ResFileManager.resLoadCompleteHandler.run();
				ResFileManager.resLoadCompleteHandler=null;
			}
			ResFileManager.clearePreResWorkLater();
		}

		ResFileManager.isResFile=function(path){
			if (FileTools.isDirectory(path))return false;
			var exName;
			exName=FileTools.getExtensionName(path);
			if (exName=="png" || exName=="jpg")return true;
			return false;
		}

		ResFileManager.clearRes=function(url){
			var fmtUrl;
			fmtUrl=ResFileManager.formatURL(url);
			ResFileManager.clearLoaderRes(fmtUrl);
		}

		ResFileManager.clearLoaderRes=function(url){
			url=URL.formatURL(url);
			var res=Loader.loadedMap[url];
			delete Loader.loadedMap[url];
			if ((res instanceof laya.resource.Texture )){
				ResFileManager.preClearRess.push(res);
			}
			Laya.timer.clear(null,ResFileManager.clearPreResWork);
		}

		ResFileManager.clearPreResWork=function(){
			console.log("clearTextures");
			var i=0,len=0;
			len=ResFileManager.preClearRess.length;
			for(i=0;i<len;i++){
				(ResFileManager.preClearRess [i]).destroy();
			}
			ResFileManager.preClearRess.length=0;
		}

		ResFileManager.clearePreResWorkLater=function(){
			Laya.timer.once(6*1000,null,ResFileManager.clearPreResWork);
		}

		ResFileManager.getRes=function(url){
			var rst;
			var apPath;
			apPath=ResFileManager.formatURL(url);
			rst=BinaryPicTools.getRes(apPath);
			if(rst)return rst;
			rst=ResFileManager.oldGetRes(ResFileManager.formatURL(url));
			if(!rst){
				rst=ResFileManager.oldGetRes("comp/loseskin.png");
			}
			return rst;
			return ResFileManager.oldGetRes(ResFileManager.formatURL(url));
		}

		ResFileManager.hookGetRes=function(url){
			var o;
			o=ResFileManager.hookGetRes;
			if(Loader.loadedMap[URL.formatURL(url)]||o["caller"]==Laya.loader.load)return Loader.loadedMap[URL.formatURL(url)];
			return ResFileManager.getRes(url);
		}

		ResFileManager.oldGetRes=function(url){
			if(ResFileManager._oldGetRes!=null)return ResFileManager._oldGetRes(url);
			return Loader.getRes(url);
		}

		ResFileManager.hookLoaderLoad=function(){}
		ResFileManager.hasRes=function(url){
			if(ResFileManager.enableBinaryPic){
				return ResFileManager.getRes(url);
			}
			if(Loader.getRes(ResFileManager.formatURL(url)))return true;
			return false;
		}

		ResFileManager.cacheRes=function(url,data){
			Loader.cacheRes(ResFileManager.formatURL(url),data);
		}

		ResFileManager.formatURL=function(url){
			if (!url)return url;
			if(FileTools.isAbsPath(url))return url;
			var rst;
			rst=(url.indexOf(":/")> 0)?url:ResFileManager.basePath+FileTools.path.sep+FileManager.adptToLocalUrl(url);
			return rst;
		}

		ResFileManager.adptToCommonUrl=function(url){
			return FileManager.adptToCommonUrl(url);
		}

		ResFileManager.getIDEResPath=function(url){
			return FileTools.getAbsPath(FileManager.getPath(SystemSetting.assetsPath,url));
		}

		ResFileManager.getIDEPagePath=function(url){
			return FileTools.getAbsPath(FileManager.getPath(SystemSetting.pagesPath,url));
		}

		ResFileManager.getIDECompIconPath=function(iconSign){
			return FileTools.getAbsPath(FileManager.getAppPath("laya/icons/components/"+iconSign+".png"));
		}

		ResFileManager._prePath=null
		ResFileManager._watcher=null
		ResFileManager.preLoadList=[];
		ResFileManager.enableBinaryPic=true;
		ResFileManager.resLoadCompleteHandler=null
		ResFileManager.preClearRess=[];
		ResFileManager._oldGetRes=null
		ResFileManager.basePath="";
		return ResFileManager;
	})()


	/**
	*本类用于调整对象的宽高以及坐标
	*@author ww
	*/
	//class laya.ide.managers.resizer.DisResizer
	var DisResizer1=(function(){
		function DisResizer(){}
		__class(DisResizer,'laya.ide.managers.resizer.DisResizer',null,'DisResizer1');
		DisResizer.init=function(){
			if (DisResizer._up)return;
			DisResizer._up=new AutoFillRec1("T");
			DisResizer._up.height=2;
			DisResizer._up.type=0;
			DisResizer._down=new AutoFillRec1("T");
			DisResizer._down.height=2;
			DisResizer._down.type=0;
			DisResizer._left=new AutoFillRec1("R");
			DisResizer._left.width=2;
			DisResizer._left.type=1;
			DisResizer._right=new AutoFillRec1("R");
			DisResizer._right.width=2;
			DisResizer._right.type=1;
			DisResizer._barList=[DisResizer._up,DisResizer._down,DisResizer._left,DisResizer._right];
			DisResizer.addEvent();
		}

		DisResizer.stageDown=function(e){
			var target;
			target=e.target;
			if (DisResizer._tar && DisControlTool.isInTree(DisResizer._tar,target)){
				return;
			}
			DisResizer.clear();
		}

		DisResizer.clear=function(){
			DisResizer._tar=null;
			Laya.stage.off("mouseup",null,DisResizer.stageDown);
			DisControlTool.removeItems(DisResizer._barList);
			DisResizer.clearDragEvents();
		}

		DisResizer.addEvent=function(){
			var i=0,len=0;
			var tBar;
			len=DisResizer._barList.length;
			for (i=0;i < len;i++){
				tBar=DisResizer._barList[i];
				tBar.on("mousedown",null,DisResizer.barDown);
			}
		}

		DisResizer.barDown=function(e){
			DisResizer.clearDragEvents();
			DisResizer.tBar=e.target;
			if (!DisResizer.tBar)return;
			var area;
			area=new Rectangle();
			if (DisResizer.tBar.type==0){
				area.x=DisResizer.tBar.x;
				area.width=0;
				area.y=DisResizer.tBar.y-200;
				area.height=400;
				}else{
				area.x=DisResizer.tBar.x-200;
				area.width=400;
				area.y=0;
				area.height=0;
			};
			var option;
			option={};
			option.area=area;
			DisResizer.tBar.record();
			DisResizer.tBar.startDrag(area);
			DisResizer.tBar.on("dragmove",null,DisResizer.draging);
			DisResizer.tBar.on("dragend",null,DisResizer.dragEnd);
		}

		DisResizer.draging=function(e){
			if (!DisResizer.tBar)return;
			if (!DisResizer._tar)return;
			switch(DisResizer.tBar){
				case DisResizer._left:
					DisResizer._tar.x+=DisResizer.tBar.getDx();
					DisResizer._tar.width-=DisResizer.tBar.getDx();
					DisResizer._up.width-=DisResizer.tBar.getDx();
					DisResizer._down.width-=DisResizer.tBar.getDx();
					DisResizer._right.x-=DisResizer.tBar.getDx();
					DisResizer.tBar.x-=DisResizer.tBar.getDx();
					break ;
				case DisResizer._right:
					DisResizer._tar.width+=DisResizer.tBar.getDx();
					DisResizer._up.width+=DisResizer.tBar.getDx();
					DisResizer._down.width+=DisResizer.tBar.getDx();
					break ;
				case DisResizer._up:
					DisResizer._tar.y+=DisResizer.tBar.getDy();
					DisResizer._tar.height-=DisResizer.tBar.getDy();
					DisResizer._right.height-=DisResizer.tBar.getDy();
					DisResizer._left.height-=DisResizer.tBar.getDy();
					DisResizer._down.y-=DisResizer.tBar.getDy();
					DisResizer.tBar.y-=DisResizer.tBar.getDy();
					break ;
				case DisResizer._down:
					DisResizer._tar.height+=DisResizer.tBar.getDy();
					DisResizer._right.height+=DisResizer.tBar.getDy();
					DisResizer._left.height+=DisResizer.tBar.getDy();
					break ;
				}
			DisResizer.tBar.record();
		}

		DisResizer.dragEnd=function(e){
			DisResizer.clearDragEvents();
			DisResizer.updates();
		}

		DisResizer.clearDragEvents=function(){
			if (!DisResizer.tBar)return;
			DisResizer.tBar.off("dragmove",null,DisResizer.draging);
			DisResizer.tBar.off("dragend",null,DisResizer.dragEnd);
		}

		DisResizer.setUp=function(dis,force){
			(force===void 0)&& (force=false);
			if (force && dis==DisResizer._tar){
				return;
			};
			DisControlTool.removeItems(DisResizer._barList);
			if (DisResizer._tar==dis){
				DisResizer._tar=null;
				DisResizer.clearDragEvents();
				if(!force)
					return;
			}
			DisResizer._tar=dis;
			DisResizer.updates();
			DisControlTool.addItems(DisResizer._barList,dis);
			Laya.stage.off("mouseup",null,DisResizer.stageDown);
			Laya.stage.on("mouseup",null,DisResizer.stageDown);
		}

		DisResizer.updates=function(){
			var dis;
			dis=DisResizer._tar;
			if(!dis)return;
			var bounds;
			bounds=new Rectangle(0,0,dis.width,dis.height);
			DisResizer._up.x=bounds.x;
			DisResizer._up.y=bounds.y;
			DisResizer._up.width=bounds.width;
			DisResizer._down.x=bounds.x;
			DisResizer._down.y=bounds.y+bounds.height-2;
			DisResizer._down.width=bounds.width;
			DisResizer._left.x=bounds.x;
			DisResizer._left.y=bounds.y;
			DisResizer._left.height=bounds.height;
			DisResizer._right.x=bounds.x+bounds.width-2;
			DisResizer._right.y=bounds.y;
			DisResizer._right.height=bounds.height;
		}

		DisResizer._up=null
		DisResizer._down=null
		DisResizer._left=null
		DisResizer._right=null
		DisResizer._barList=null
		DisResizer._tar=null
		DisResizer.barWidth=2;
		DisResizer.useGetBounds=false;
		DisResizer.tBar=null
		return DisResizer;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-10-21 下午7:53:19
	*/
	//class laya.ide.managers.SceneManager
	var SceneManager=(function(){
		function SceneManager(){}
		__class(SceneManager,'laya.ide.managers.SceneManager');
		SceneManager.init=function(){
			SceneManager.sceneO["PARTICLE"]=new ParticleScene();
		}

		SceneManager.changeTo=function(scene){
			if(!SceneManager.sceneO[scene])return;
			SceneManager.tScene=SceneManager.sceneO[scene];
			SceneManager.tScene.setUp();
		}

		SceneManager.save=function(){
			if(SceneManager.tScene){
				SceneManager.tScene.save();
			}
		}

		SceneManager.open=function(){
			if(SceneManager.tScene){
				SceneManager.tScene.open();
			}
		}

		SceneManager.PARTICLE="PARTICLE";
		SceneManager.sceneO={};
		SceneManager.tScene=null
		return SceneManager;
	})()


	/**
	*历史状态管理类
	*@author ww
	*/
	//class laya.ide.managers.state.State
	var State=(function(){
		function State(){
			this._stateList=[];
			this._tI=-1;
		}

		__class(State,'laya.ide.managers.state.State');
		var __proto=State.prototype;
		/**
		*添加状态 ，直接使用传入的状态值
		*@param data
		*
		*/
		__proto.add=function(data){
			this.traceState();
			if(this._tI!=this._stateList.length-1){
				this._stateList.length=this._tI+1;
			}
			this._stateList.push(data);
			this._tI=this._stateList.length-1;
			this.traceState();
		}

		__proto.traceState=function(){}
		/**
		*添加状态 ，会拷贝一个副本数据存入
		*@param data
		*
		*/
		__proto.addE=function(data){
			this.add(ObjectTools.copyObj(data));
		}

		/**
		*获取当前状态
		*@return
		*
		*/
		__proto.now=function(){
			return ObjectTools.copyObj(this._stateList[this._tI]);
		}

		/**
		*向后回退
		*@return
		*
		*/
		__proto.back=function(){
			if(this._tI<=0)return null;
			this._tI--;
			this.traceState();
			return this.now();
		}

		/**
		*向前重做
		*@return
		*
		*/
		__proto.forward=function(){
			if(this._tI>=this._stateList.length-1)return null;
			this._tI++;
			this.traceState();
			return this.now();
		}

		return State;
	})()


	/**
	*状态管理类
	*@author ww
	*@version 1.0
	*
	*@created 2015-10-22 下午7:45:51
	*/
	//class laya.ide.managers.StateManager
	var StateManager=(function(){
		function StateManager(){}
		__class(StateManager,'laya.ide.managers.StateManager');
		StateManager.has=function(sign){
			return StateManager._stateDic.hasOwnProperty(sign);
		}

		StateManager.getState=function(sign){
			if(!StateManager._stateDic[sign])StateManager._stateDic[sign]=new State();
			return StateManager._stateDic[sign];
		}

		StateManager.updateState=function(sign,data){
			StateManager.setChangeState(sign,StateManager.has(sign));
			StateManager.getState(sign).addE(data);
		}

		StateManager.removeState=function(sign){
			delete StateManager._stateDic[sign];
		}

		StateManager.hasChange=function(sign){
			return StateManager._changeDic[sign];
		}

		StateManager.setChangeState=function(sign,changed){
			StateManager._changeDic[sign]=changed;
		}

		StateManager._stateDic={};
		StateManager._changeDic={};
		return StateManager;
	})()


	/**
	*本地文件日志类
	*@author ww
	*@version 1.0
	*
	*@created 2015-12-2 上午9:14:31
	*/
	//class laya.ide.managers.SysLog
	var SysLog=(function(){
		function SysLog(){}
		__class(SysLog,'laya.ide.managers.SysLog');
		/**
		*表示是否捕获全局错误并弹出提示。
		*/
		__getset(1,SysLog,'logGlobalError',null,function(value){
			var erralert=0;
			if (value){
				Browser.window.onerror=function (msg,url,line,column,detail){
					if (erralert++< 5 && detail)
						SysLog.log("出错啦，请把此信息截图给研发商\n"+msg+"\n"+detail.stack,"GlobalError");
				}
				}else {
				Browser.window.onerror=null;
			}
		});

		SysLog.log=function(msg,type){
			(type===void 0)&& (type="log");
			var str;
			str=(new Date()).toString()+":"+type+":"+msg;
			console.log(str);
			if(SysLog.fileLogEnabled){
				FileTools.appendFile(FileManager.getDataPath("log.txt"),"\n"+str);
			}
		}

		SysLog.fileLogEnabled=true;
		return SysLog;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.ide.managers.SystemDragOverManager
	var SystemDragOverManager=(function(){
		function SystemDragOverManager(){}
		__class(SystemDragOverManager,'laya.ide.managers.SystemDragOverManager');
		SystemDragOverManager.init=function(){
			var canvas=Render.canvas;
			Browser.container.ondrop=SystemDragOverManager.dragDrop;
			Browser.container.ondragover=SystemDragOverManager.dragOver;
		}

		SystemDragOverManager.dragOver=function(e){
			e.preventDefault();
		}

		SystemDragOverManager.dragDrop=function(e){
			console.log("system dragover",e);
			var file;
			try{
				file=e.dataTransfer.files[0];
				SystemDragOverManager.handlerFile(file.path);
				SystemDragOverManager.onFileDrag(e.dataTransfer.files,e.clientX,e.clientY);
				e.preventDefault();
			}catch(e){}
			return false;
		}

		SystemDragOverManager.handlerFile=function(path){
			console.log("handlerFIle:",path);
			if (path){
				var extension;
				extension=FileTools.getExtensionName(path);
				switch(extension){
					case "laya":
						ProjectManager.loadProject(path);
						break ;
					}
			}
		}

		SystemDragOverManager.onFileDrag=function(files,x,y){
			if(!files||files.length<1)return;
			var data;
			var type="SystemDrag";
			var files;
			files=Utils.copyArray(files,[]);
			data={type:type,files:files};
			DragManager.sendDragEventByData("dragDrop",data,data,x,y);
		}

		return SystemDragOverManager;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-1-4 上午10:30:59
	*/
	//class laya.ide.managers.TemplateManager
	var TemplateManager=(function(){
		function TemplateManager(){}
		__class(TemplateManager,'laya.ide.managers.TemplateManager');
		TemplateManager.getRootPath=function(){
			return FileManager.getAppPath("laya/template/");
		}

		TemplateManager.getDefaultFolder=function(){
			return TemplateManager.getTypedFolder("常用模板");
		}

		TemplateManager.getTypedFolder=function(type){
			return FileManager.getPath(TemplateManager.getRootPath(),type);
		}

		TemplateManager.getTemplateFolderPath=function(templateName,type){
			(type===void 0)&& (type="自定义模板");
			return FileManager.getPath(TemplateManager.getTypedFolder(type),templateName);
		}

		TemplateManager.getTemplateUIFilePath=function(templateName,type){
			(type===void 0)&& (type="自定义模板");
			return FileManager.getPath(TemplateManager.getTypedFolder(type),templateName+"/"+"UI"+"."+TypeManager.getExtension("ui_template"));
		}

		TemplateManager.getTemplateUIResPath=function(templateName,type){
			(type===void 0)&& (type="自定义模板");
			return FileManager.getPath(TemplateManager.getTypedFolder(type),templateName+"/"+"res");
		}

		TemplateManager.getUIFilePath=function(templateFolder){
			return FileManager.getPath(templateFolder,"UI"+"."+TypeManager.getExtension("ui_template"));
		}

		TemplateManager.getUIResPath=function(templateFolder){
			return FileManager.getPath(templateFolder,"res");
		}

		TemplateManager.init=function(){
			FileTools.ensurePath(TemplateManager.getRootPath());
		}

		TemplateManager.getTemplatePanelData=function(){
			var rst;
			var folders;
			folders=FileTools.getDirChildDirs(TemplateManager.getRootPath());
			var i=0,len=0;
			len=folders.length;
			var groupDatas;
			groupDatas=[];
			for(i=0;i<len;i++){
				groupDatas.push(TemplateManager.getTypedTemplateData(folders[i]));
			}
			rst={};
			rst.groups=groupDatas;
			return rst;
		}

		TemplateManager.getTypedTemplateData=function(path){
			var templates;
			templates=FileTools.getDirChildDirs(path);
			var typeName;
			typeName=FileTools.getFileName(path);
			var i=0,len=0;
			len=templates.length;
			var items;
			items=[];
			for(i=0;i<len;i++){
				items.push(TemplateManager.getTemplateFileData(templates[i],typeName));
			};
			var rst;
			rst={};
			rst.name=typeName;
			rst.items=items;
			return rst;
		}

		TemplateManager.getTemplateFileData=function(path,type){
			var templateName;
			templateName=FileTools.getFileName(path);
			var rst;
			rst={};
			rst.icon=FileTools.getAbsPath(FileManager.getPath(path,"icon.png"));
			rst.image=rst.icon;
			rst.title=templateName;
			rst.path=path;
			return rst;
		}

		TemplateManager.changeToTemplate=function(fileName){
			if(TypeManager.getFileType(fileName)!="page"){
				Alert.show("UI文件才能转换为模板文件","提示");
				return;
			};
			var folderName;
			folderName=FileTools.getFileName(fileName);
			AddTemplate.instance.start(fileName,folderName);
		}

		TemplateManager.convertUIFileByPaths=function(srcFile,templateName,folderName){
			var tarFolder;
			tarFolder=TemplateManager.getTemplateFolderPath(templateName,folderName);
			if(FileTools.exist(tarFolder)){
				Confirm.show("目标文件已存在，是否覆盖？","提示",Utils.bind(TemplateManager.convertUIFileToTemplate,null),[srcFile,tarFolder,templateName,folderName]);
				}else{
				TemplateManager.convertUIFileToTemplate(srcFile,tarFolder,templateName,folderName);
			}
		}

		TemplateManager.convertUIFileToTemplate=function(oldFile,tarFolder,templateName,folderName){
			var xml=FileManager.readJSONFile(oldFile);
			var view=new UIView();
			view.createView(xml);
			var tarFile;
			tarFile=TemplateManager.getTemplateUIFilePath(templateName,folderName);
			var resFolder;
			resFolder=TemplateManager.getTemplateUIResPath(templateName,folderName);
			var tarData;
			tarData=FileManager.readJSONFile(oldFile);
			var resUsed;
			resUsed=TemplateManager.findAllResUsed(tarData,resUsed);
			var resNameDic;
			resNameDic=TemplateManager.getAdptSkins(resUsed);
			var oldTxt;
			oldTxt=FileManager.readTxtFile(oldFile);
			var key;
			var newPath;
			var uiO;
			uiO=ObjectTools.getObj(oldTxt);
			delete resNameDic[""];
			for(key in resNameDic){
				if(!key)continue ;
				TemplateManager.copySkinRes(key,resFolder,resNameDic[key]);
				resNameDic[key]="template"+"/"+templateName+"/"+resNameDic[key];
			}
			ObjectTools.replaceValue(uiO,resNameDic);
			FileManager.createTxtFile(tarFile,ObjectTools.getJsonString(uiO));
			URL.version[FileTools.getAbsPath(FileManager.getPath(tarFolder,"icon.png"))]=Math.random();
			Laya.timer.once(200,null,TemplateManager.createLittlePic,[view,tarFolder]);
		}

		TemplateManager.copySkinRes=function(skinPath,resFolder,resName){
			if(!skinPath)return;
			if(!resName)return;
			var srcP;
			srcP=FileManager.getResPath(skinPath);
			var tarP;
			tarP=FileTools.getPath(resFolder,resName);
			var i=0,len=0;
			len=TemplateManager.specialFiles.length;
			for(i=0;i<len;i++){
				TemplateManager.copyIfExists(StringTool.getReplace(srcP,".png",TemplateManager.specialFiles[i]),StringTool.getReplace(tarP,".png",TemplateManager.specialFiles[i]));
			}
		}

		TemplateManager.copyIfExists=function(src,tar){
			if(FileTools.exist(src)){
				if(FileTools.isDirectory(src)){
					debugger;
					return;
				}
				FileTools.copyFile(src,tar);
			}
		}

		TemplateManager.createLittlePic=function(view,tarFolder){
			var pic;
			var bounds;
			bounds=view.getSelfBounds();
			pic=view.drawToCanvas(bounds.width+bounds.x,bounds.height+bounds.y,0 ,0).source;
			var baseStr;
			baseStr=pic.toDataURL("image/png");
			baseStr=baseStr.replace(/^data:image\/\w+;base64,/,"");
			var bf;
			bf=new Device.Buffer(baseStr,'base64');
			FileManager.createBytesFile(FileManager.getPath(tarFolder,"icon.png"),bf);
			MessageManager.instance.show("转换成模板成功");
			Laya.timer.once(10,null,TemplateManager.freshCompPanel);
		}

		TemplateManager.freshCompPanel=function(){
			Notice1.notify("Fresh_CompPanel");
		}

		TemplateManager.getAdptSkins=function(skinList){
			var renameDic;
			var i=0,len=0;
			len=skinList.length;
			renameDic={};
			for(i=0;i<len;i++){
				if(!skinList[i]||skinList[i]=="")continue ;
				renameDic[skinList[i]]=true;
			};
			var tSkin;
			var usedNameDic;
			usedNameDic={};
			var tName;
			for(tSkin in renameDic){
				tName=FileTools.getFileNameWithExtension(tSkin);
				if(usedNameDic.hasOwnProperty(tName)){
					i=0;
					while(usedNameDic.hasOwnProperty(tName.replace(".",i+"."))){
						i++;
					}
					tName=tName.replace(".",i+".");
					}else{
				}
				usedNameDic[tName]=true;
				renameDic[tSkin]=tName;
			}
			return renameDic;
		}

		TemplateManager.renamePageSkins=function(pageFile,reNameDic){
			var oldTxt;
			oldTxt=pageFile;
			var key;
			var newPath;
			for(key in reNameDic){
				newPath=reNameDic[key];
				oldTxt=StringTool.getReplace(oldTxt,"\""+key+"\"","\""+newPath+"\"");
			}
			return oldTxt;
		}

		TemplateManager.findAllResUsedDic=function(pageData){
			var skinList;
			skinList=TemplateManager.findAllResUsed(pageData,[]);
			var renameDic;
			var i=0,len=0;
			len=skinList.length;
			renameDic={};
			for(i=0;i<len;i++){
				renameDic[skinList[i]]=true;
			}
			return renameDic;
		}

		TemplateManager.findAllResUsed=function(pageData,rst){
			if(!rst)rst=[];
			TemplateManager.getNodeSkin(pageData,rst);
			var i=0,len=0;
			var childList;
			var tChild;
			childList=pageData.child;
			len=childList.length;
			for(i=0;i<len;i++){
				tChild=childList[i];
				TemplateManager.findAllResUsed(tChild,rst);
			}
			return rst;
		}

		TemplateManager.getNodeSkin=function(node,rst){
			if(!rst)rst=[];
			var i=0,len=0;
			var tFrame;
			var frames;
			frames=TreeData.getNodeFrames(node);
			len=frames.length;
			for(i=0;i<len;i++){
				tFrame=frames[i];
				TemplateManager.getResByProps(tFrame.props,rst);
			}
			TemplateManager.getResByProps(node.props,rst);
			return rst;
		}

		TemplateManager.getResByProps=function(props,rst){
			if(!rst)rst=[];
			var key;
			for(key in props){
				if(TemplateManager.isResRefer(props[key])){
					rst.push(props[key]);
				}
			}
			return rst;
		}

		TemplateManager.isResRefer=function(value){
			if(!((typeof value=='string')))return false;
			if(FileTools.exist(FileManager.getResPath(value)))return true;
			return false;
		}

		TemplateManager.DefaultFolder="常用模板";
		TemplateManager.CustomFolder="自定义模板";
		TemplateManager.TemplateResFolder="template";
		__static(TemplateManager,
		['specialFiles',function(){return this.specialFiles=[".png","$down.png","$bar.png","$up.png"];}
		]);
		return TemplateManager;
	})()


	/**
	*本类定义不同的页面类型
	*@author ww
	*/
	//class laya.ide.managers.TypeManager
	var TypeManager=(function(){
		function TypeManager(){}
		__class(TypeManager,'laya.ide.managers.TypeManager');
		TypeManager.init=function(){
			TypeManager.ViewCodeTypeDic["page"]=true;
			TypeManager.ViewCodeTypeDic["scene"]=true;
			TypeManager.ViewCodeTypeDic["prefab_ui"]=true;
			TypeManager.ViewCodeTypeDic["Prefab"]=true;
			TypeManager.ViewCodeTypeDic["animation"]=true;
			TypeManager.ViewCodeTypeDic["graphic_animation"]=true;
			TypeManager.XmlCodeTypeDic["Script"]=true;
			TypeManager.XmlCodeTypeDic["prop"]=true;
			TypeManager.insertArrToObj(TypeManager.Res2D,TypeManager.ResTypes);
			TypeManager.insertArrToObj(TypeManager.GraphicRes,TypeManager.ResTypes);
			TypeManager.insertArrToObj(TypeManager.UIRes,TypeManager.ResTypes);
			TypeManager.insertArrToObj(TypeManager.GraphicRes,TypeManager.UnEnterAbleType);
			TypeManager.UnEnterAbleType["Graphic"]=false;
			TypeManager.insertArrToObj(TypeManager.GraphicRes,TypeManager.GraphicCmdTypeDic);
			TypeManager.GraphicCmdTypeDic["Graphic"]=false;
		}

		TypeManager.getExtension=function(type){
			var key;
			var tO=TypeManager.TypeO;
			for(key in tO){
				if(tO[key]==type){
					return key;
				}
			}
			console.log("未知type:",type);
			return "unKnow";
		}

		TypeManager.getFileType=function(path){
			var extention=FileTools.getExtensionName(path);
			if(!TypeManager.TypeO[extention])return "unKnow";
			return TypeManager.TypeO[extention];
		}

		TypeManager.isPreFabNodeType=function(type){
			if(!type)return false;
			return !ProjectSetting.isPageType(type);
		}

		TypeManager.isPreFabPage=function(path){
			return TypeManager.isPreFabNodeType(TypeManager.getPageFileType(path));
		}

		TypeManager.getPageFileType=function(path){
			var xml;
			var dataStr;
			try{
				dataStr=FileManager.getPath(SystemSetting.pagesPath,path.replace(".xml","."+laya.ide.managers.TypeManager.getExtension("page")));
				xml=FileManager.readJSONFile(dataStr);
				var type;
				type=xml.type;
				return type;
				}catch(e){
			};
			return null;
		}

		TypeManager.isPrefabUINode=function(node){
			if(node.type!="UIView"||!node.source)return false;
			return TypeManager.isPreFabPage(node.source);
		}

		TypeManager.isCodeViewFile=function(path){
			var type;
			type=TypeManager.getFileType(path);
			return TypeManager.ViewCodeTypeDic.hasOwnProperty(type);
		}

		TypeManager.isXmlViewFile=function(path){
			var type;
			type=TypeManager.getFileType(path);
			return TypeManager.XmlCodeTypeDic.hasOwnProperty(type);
		}

		TypeManager.isScriptFile=function(path){
			return TypeManager.isXmlViewFile(path);
		}

		TypeManager.insertArrToObj=function(arr,obj){
			var i=0,len=0;
			len=arr.length;
			for(i=0;i<len;i++){
				obj[arr[i]]=true;
			}
		}

		TypeManager.isResTypeName=function(typeStr){
			return TypeManager.ResTypes[typeStr];
		}

		TypeManager.isGraphicCmdType=function(type){
			if(TypeManager.GraphicCmdTypeDic[type])return true;
			return false;
		}

		TypeManager.canNodeAddToType=function(childType,parentType){
			if(parentType=="Graphic"){
				if(!TypeManager.isGraphicCmdType(childType)){
					return false;
				}
			}
			return true;
		}

		TypeManager.Particle="particle";
		TypeManager.Particle3D="particle3D";
		TypeManager.ParticlePoly="particlepoly";
		TypeManager.Page="page";
		TypeManager.Animation="animation";
		TypeManager.UITemplate="ui_template";
		TypeManager.Scene="scene";
		TypeManager.Prefab="Prefab";
		TypeManager.PrefabUI="prefab_ui";
		TypeManager.GraphicAnimation="graphic_animation";
		TypeManager.Script="Script";
		TypeManager.Prop="prop";
		TypeManager.ViewCodeTypeDic={};
		TypeManager.XmlCodeTypeDic={};
		TypeManager.GraphicCmdTypeDic={};
		TypeManager.ParticlePlayer="Particle2D";
		TypeManager.GraphicPic="Texture";
		__static(TypeManager,
		['TypeO',function(){return this.TypeO={
				"part":"particle",
				"part3d":"particle3D",
				"partPoly":"particlepoly",
				"ui":"page",
				"ani":"graphic_animation",
				"scene":"scene",
				"prefab":"Prefab",
				"prefabui":"prefab_ui",
				"script":"Script",
				"prop":"prop",
				"temp":"ui_template"
				};},'Res2D',function(){return this.Res2D=["Sprite","Animation","Text","HTMLDivElement"];},'GraphicRes',function(){return this.GraphicRes=["Circle","Curves","FillText","FillTexture","Graphic","Line","Lines","Pie","Poly","Rect","Texture"];},'UIRes',function(){return this.UIRes=["Button","CheckBox","Clip","ColorPicker","ComboBox","Dialog","HBox","HScrollBar","HSlider","Image","Label","List","Panel","ProgressBar","Radio","RadioGroup","Tab","Text","TextArea","TextInput","Tree","VBox","VScrollBar","VSlider","View","ViewStack","Box"];},'ResTypes',function(){return this.ResTypes={
				};},'UnEnterAbleType',function(){return this.UnEnterAbleType={
				"GraphicPic":true,
				"HTMLDivElement":true,
				"SoundNode":true,
				"GridEditor":true,
				"UIView":true,
				"Script":true
		};}

		]);
		return TypeManager;
	})()


	/**
	*本类用于在ide中显示iframe
	*@author ww
	*@version 1.0
	*
	*@created 2015-10-21 上午11:23:12
	*/
	//class laya.ide.managers.ViewRenderManager
	var ViewRenderManager=(function(){
		function ViewRenderManager(){}
		__class(ViewRenderManager,'laya.ide.managers.ViewRenderManager');
		ViewRenderManager.init=function(){
			if (ViewRenderManager.renderFrame)return;
			ViewRenderManager.renderHit.name="renderHit";
			ViewRenderManager.renderHit.mouseEnabled=true;
			ViewRenderManager.renderHit.on("dragDrop",null,ViewRenderManager.renderDragDrop);
			ViewRenderManager.renderFrame=Browser.createElement("iframe");
			ViewRenderManager.renderFrame.id="viewrender";
			ViewRenderManager.renderFrame.width="400";
			ViewRenderManager.renderFrame.height="300";
			ViewRenderManager.renderFrame.left="400";
			ViewRenderManager.renderFrame.top="400";
			ViewRenderManager.style=ViewRenderManager.renderFrame.style;
			ViewRenderManager.style.position="absolute";
			ViewRenderManager.style.top="100px";
			ViewRenderManager.style.left="220px";
			ViewRenderManager.style["z-index"]=101;
			ViewRenderManager.style.border="0";
			ViewRenderManager.render=ViewRenderManager.renderFrame.contentWindow;
			var passEventList=["mousemove","keydown","keypress","keyup"];
			ViewRenderManager.renderFrame.addEventListener("load",function(){
				ViewRenderManager.render=ViewRenderManager.renderFrame.contentWindow.renderBinds;
				ViewRenderManager.window=ViewRenderManager.renderFrame.contentWindow;
				var i=0,len=0;
				len=passEventList.length;
				for(i=0;i<len;i++){
					ViewRenderManager.window.document.removeEventListener(passEventList[i],ViewRenderManager.passEvent);
					ViewRenderManager.window.document.addEventListener(passEventList[i],ViewRenderManager.passEvent);
				}
				Laya.timer.once(200,null,ViewRenderManager.loaded);
			},false)
			var idePassEventList=["keydown","keypress","keyup"];
			var i=0,len=0;
			len=idePassEventList.length;
			for(i=0;i<len;i++){
				Laya.stage.on(idePassEventList[i],null,ViewRenderManager.passEvent2);
			}
		}

		ViewRenderManager.passEvent=function(e){
			var evt;
			evt=Browser.document.createEvent("Events");
			evt.initEvent(e.type,true,true);
			var key;
			for(key in e){
				if(!((typeof (e[key])=='function'))){
					evt[key]=e[key];
				}
			}
			evt.isFromIDE=true;
			evt.clientX+=ViewRenderManager.offPos.x;
			evt.clientY+=ViewRenderManager.offPos.y;
			Render.canvas.dispatchEvent(evt);
		}

		ViewRenderManager.passEvent2=function(e){
			if(!ViewRenderManager.window)return;
			e=e.nativeEvent;
			if(e.isFromIDE)return;
			var evt;
			evt=Browser.document.createEvent("Events");
			evt.initEvent(e.type,true,true);
			var key;
			for(key in e){
				if(!((typeof (e[key])=='function'))){
					evt[key]=e[key];
				}
			}
			ViewRenderManager.window.document.dispatchEvent(evt);
		}

		ViewRenderManager.renderDragDrop=function(e){
			var point=DisControlTool.getMousePoint(ViewRenderManager.renderHit);
			e.data.dropX=point.x;
			e.data.dropY=point.y;
			Notice1.notify("DROP_RENDER",[e]);
		}

		ViewRenderManager.renderMouseHandler=function(e){
			if(!ViewRenderManager.window)return;
			var point;
			point=DisControlTool.getMousePoint(ViewRenderManager.renderHit);
			var evt;
			evt=Browser.document.createEvent("MouseEvents");
			evt.initMouseEvent(
			e.type,
			true,
			true,
			Browser.document.defaultView,
			0,
			point.x,
			point.y,
			point.x,
			point.y);
			ViewRenderManager.window.dispatchEvent(evt);
		}

		ViewRenderManager.loaded=function(){
			Notice1.listen("RenderInited",null,ViewRenderManager.renderInited);
			if(ViewRenderManager.render)
				ViewRenderManager.render.setNotice(Notice1.I);
			ViewRenderManager.eDispatcher.event("complete");
			ViewRenderManager.adpt();
		}

		ViewRenderManager.renderInited=function(){}
		ViewRenderManager.adpt=function(){
			if (laya.ide.managers.ViewRenderManager.renderFrame){
				var pos=new Point();
				pos=UIPanel.instance.localToGlobal(pos);
				var dLen=0;
				dLen=25;
				ViewRenderManager.renderHit.width=UIPanel.instance.width;
				ViewRenderManager.renderHit.height=UIPanel.instance.height-dLen;
				ViewRenderManager.renderHit.x=UIPanel.instance.x;
				ViewRenderManager.renderHit.y=UIPanel.instance.y+dLen;
				var style;
				style=laya.ide.managers.ViewRenderManager.renderFrame.style;
				ViewRenderManager.offPos.setTo(pos.x,pos.y+dLen);
				style.top=pos.y+dLen+"px";
				style.left=(pos.x)+"px";
				laya.ide.managers.ViewRenderManager.renderFrame.width=ViewRenderManager.renderHit.width;
				laya.ide.managers.ViewRenderManager.renderFrame.height=ViewRenderManager.renderHit.height-5;
				ViewRenderManager.hitBounds.width=ViewRenderManager.renderHit.width;
				ViewRenderManager.hitBounds.height=ViewRenderManager.renderHit.height;
				ViewRenderManager.hitBounds.x=0;
				ViewRenderManager.hitBounds.y=0;
				ViewRenderManager.renderHit.setBounds(ViewRenderManager.hitBounds);
			}
		}

		ViewRenderManager.setRender=function(url){
			ViewRenderManager.renderFrame.src=url;
		}

		ViewRenderManager.show=function(){
			Browser.container.appendChild(ViewRenderManager.renderFrame);
			UIPanel.instance.parent.addChild(ViewRenderManager.renderHit);
		}

		ViewRenderManager.hide=function(){
			Browser.removeElement(ViewRenderManager.renderFrame);
			ViewRenderManager.renderFrame.src="";
			ViewRenderManager.renderHit.removeSelf();
		}

		ViewRenderManager.renderFrame=null
		ViewRenderManager.render=null
		ViewRenderManager.style=null
		ViewRenderManager.window=null
		__static(ViewRenderManager,
		['eDispatcher',function(){return this.eDispatcher=new EventDispatcher();},'renderHit',function(){return this.renderHit=new Sprite();},'hitBounds',function(){return this.hitBounds=new Rectangle(0,0);},'offPos',function(){return this.offPos=new Point();}
		]);
		return ViewRenderManager;
	})()


	/**
	*显示对象常用的工具类
	*@author ww
	*/
	//class laya.ide.utils.DisTools
	var DisTools=(function(){
		function DisTools(){}
		__class(DisTools,'laya.ide.utils.DisTools');
		DisTools.showToStage=function(dis,offX,offY){
			(offX===void 0)&& (offX=0);
			(offY===void 0)&& (offY=0);
			var rec=dis.getBounds();
			dis.x=Laya.stage.mouseX+offX;
			dis.y=Laya.stage.mouseY+offY;
			if (dis.x+rec.width > Laya.stage.width){
				dis.x-=rec.width+offX;
			}
			if (dis.y+rec.height > Laya.stage.height){
				dis.y-=rec.height+offY;
			}
		}

		DisTools.showToCenter=function(dis,parent){
			dis.x=0.5 *(parent.width-dis.width);
			dis.y=0.5 *(parent.height-dis.height);
			parent.addChild(dis);
		}

		DisTools.getDisDesO=function(dis){
			if (!dis)
				return null;
			var rst={};
			if(dis.name){
				rst.label=TraceTool.getClassName(dis)+"("+dis.name+")";
				}else{
				rst.label=TraceTool.getClassName(dis);
			}
			if(dis["comXml"]){
				rst.compId=dis["comXml"]["compId"];
			}
			rst.path=dis;
			rst.files=[];
			rst.dirs=[];
			rst.childs=[];
			rst.isDirectory=true;
			return rst;
		}

		DisTools.getDisTreeArr=function(sp,filterFun){
			var tTreeO=DisTools.getDisTreeO(sp,filterFun);
			var rst=[];
			DisTools.getTreeArr(tTreeO,rst);
			return rst;
		}

		DisTools.getTreeArr=function(treeO,arr,filterFun){
			arr.push(treeO);
			var tArr=treeO.childs||treeO.child;
			var i=0,len=tArr.length;
			for (i=0;i < len;i++){
				if (tArr[i].isDirectory){
					DisTools.getTreeArr(tArr[i],arr);
				}
				else{
					arr.push(tArr[i]);
				}
			}
		}

		DisTools.getDisTreeO=function(dis,filterFun){
			var rst=DisTools.getDisDesO(dis);
			var i=0,len=0;
			var tChild;
			var tO;
			len=dis.numChildren;
			for (i=0;i < len;i++){
				tChild=dis.getChildAt(i);
				if(filterFun!=null&&!filterFun(tChild)){
					continue ;
				}
				tO=DisTools.getDisTreeO(tChild,filterFun);
				tO.nodeParent=rst;
				tO.hasChild=tO.childs.length > 0;
				tO.isDirectory=tO.hasChild;
				rst.dirs.push(tO);
				rst.childs.push(tO);
			}
			rst.hasChild=rst.childs.length > 0;
			return rst;
		}

		DisTools.addTextChangeHandler=function(input,_this,fun,param){
			input.on("enter",_this,fun);
			input.on("blur",_this,fun);
		}

		return DisTools;
	})()


	/**
	*编辑页基类
	*@author ww
	*/
	//class laya.ide.viewer.SceneBase
	var SceneBase=(function(){
		function SceneBase(){
			this.data=null;
			this._path=null;
			this._title=null;
			this._changed=false;
		}

		__class(SceneBase,'laya.ide.viewer.SceneBase');
		var __proto=SceneBase.prototype;
		Laya.imps(__proto,{"laya.ide.viewer.IViewer":true})
		__proto.setUp=function(parent){}
		//trace("SceneBase setUp");
		__proto.save=function(){}
		__proto.open=function(){}
		__proto.removeSelf=function(){
			ViewRenderManager.hide();
			Notice1.cancel("ResItemClick",this,this.onResClick);
			Notice1.cancel("Prop_change",this,this.propChange);
			Notice1.cancel("DROP_RENDER",this,this.renderDragDrop);
		}

		__proto.dealAction=function(funName,param){
			if ((typeof (this[funName])=='function')){
				this[funName].apply(this,param);
			}
		}

		__proto.show=function(){
			ViewRenderManager.show();
			Notice1.listen("ResItemClick",this,this.onResClick,null,true);
			Notice1.listen("Prop_change",this,this.propChange,null,true);
			Notice1.listen("DROP_RENDER",this,this.renderDragDrop,null,true);
		}

		__proto.renderDragDrop=function(e){}
		__proto.propChange=function(key,data){}
		__proto.onResClick=function(data){}
		__proto.goBack=function(){}
		__proto.goForward=function(){}
		__getset(0,__proto,'pagePath',function(){
			return this._path;
			},function(path){
			this._path=path;
			this._title=FileTools.getFileName(this._path);
		});

		__getset(0,__proto,'title',function(){
			return this._title;
		});

		__getset(0,__proto,'design',function(){
			return this;
		});

		__getset(0,__proto,'hasChange',function(){
			return this._changed;
		});

		return SceneBase;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-8-10 下午4:21:23
	*/
	//class laya.rendercanvas.HtmlZIndexManager
	var HtmlZIndexManager=(function(){
		function HtmlZIndexManager(){}
		__class(HtmlZIndexManager,'laya.rendercanvas.HtmlZIndexManager');
		HtmlZIndexManager.init=function(){
			Laya.stage.on("mousedown",null,HtmlZIndexManager.onMouseDown);
			Laya.stage.on("mouseup",null,HtmlZIndexManager.onMouseUp);
		}

		HtmlZIndexManager.onMouseDown=function(){
			HtmlZIndexManager.isMouseDown=true;
			HtmlZIndexManager.prePos.setTo(Laya.stage.mouseX,Laya.stage.mouseY);
			HtmlZIndexManager.isDrag=false;
			Laya.stage.on("mousemove",null,HtmlZIndexManager.onMouseMove);
		}

		HtmlZIndexManager.onMouseMove=function(){
			if(Math.abs(HtmlZIndexManager.prePos.x-Laya.stage.mouseX)+Math.abs(HtmlZIndexManager.prePos.y-Laya.stage.mouseY)>5){
				Notice1.notify("DisableOverlays");
				HtmlZIndexManager.setHtmlEnable(false);
				HtmlZIndexManager.isDrag=true;
				Laya.stage.off("mousemove",null,HtmlZIndexManager.onMouseMove);
			}
		}

		HtmlZIndexManager.onMouseUp=function(){
			HtmlZIndexManager.isMouseDown=false;
			Laya.stage.off("mousemove",null,HtmlZIndexManager.onMouseMove);
			if(!HtmlZIndexManager.preValue){
				Notice1.notify("EnableOverlays");
				HtmlZIndexManager.setHtmlEnable(true);
			}
			HtmlZIndexManager.isDrag=false;
		}

		HtmlZIndexManager.setHtmlEnable=function(enable){
			HtmlZIndexManager.preValue=enable;
			var i=0,len=0;
			len=HtmlZIndexManager.htmlList.length;
			for(i=0;i<len;i++){
				if(HtmlZIndexManager.htmlList[i].disableAutoControl)continue ;
				JSTools.setMouseEnable(HtmlZIndexManager.htmlList[i],enable);
			}
		}

		HtmlZIndexManager.addHtml=function(html){
			if(!html)return;
			if(!HtmlZIndexManager.htmlList.indexOf(html)>=0){
				HtmlZIndexManager.htmlList.push(html);
			}
		}

		HtmlZIndexManager.removeHtml=function(html){
			if(!html)return;
			var index=0;
			index=HtmlZIndexManager.htmlList.indexOf(html);
			if(index>=0){
				HtmlZIndexManager.htmlList.splice(index,1);
			}
		}

		HtmlZIndexManager.DisableOverlays="DisableOverlays";
		HtmlZIndexManager.EnableOverlays="EnableOverlays";
		HtmlZIndexManager.isDrag=false;
		HtmlZIndexManager.isMouseDown=false;
		HtmlZIndexManager.preValue=true;
		HtmlZIndexManager.htmlList=[];
		__static(HtmlZIndexManager,
		['prePos',function(){return this.prePos=new Point();}
		]);
		return HtmlZIndexManager;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-8-12 下午6:56:18
	*/
	//class laya.rendercanvas.StageHook
	var StageHook=(function(){
		function StageHook(){
			this.preEvent=null;
			this.preRender=null;
			this.renderingEnabled=true;
			this._repaint=1;
		}

		__class(StageHook,'laya.rendercanvas.StageHook');
		var __proto=StageHook.prototype;
		__proto.event=function(type,data){
			if(type=="mouseout")return false;
			return laya.rendercanvas.StageHook.I.preEvent.apply(this,[type,data]);
		}

		__proto.render=function(context,x,y){
			this.renderingEnabled=this._repaint!=0;
			if(this.renderingEnabled){
				if(IDEConsts.showRenderDebug){
					console.log("renderStage");
				}
			}
			laya.rendercanvas.StageHook.I.preRender.apply(this,[context,x,y]);
		}

		StageHook.hookStage=function(){
			StageHook.I.preEvent=Laya.stage.event;
			Laya.stage["event"]=StageHook.I.event;
			StageHook.I.preRender=Laya.stage.render;
			Laya.stage["render"]=StageHook.I.render;
		}

		__static(StageHook,
		['I',function(){return this.I=new StageHook();}
		]);
		return StageHook;
	})()


	/**
	*...
	*@author ww
	*/
	//class laya.test.TempData
	var TempData=(function(){
		function TempData(){}
		__class(TempData,'laya.test.TempData');
		TempData.temTreeData=null
		return TempData;
	})()


	/**
	*编辑器全局静态入口
	*@author yung
	*/
	//class Sys
	var Sys=(function(){
		function Sys(){};
		__class(Sys,'Sys');
		Sys.mParseInt=function(v){}
		Sys.log=function(__args){
			var args=arguments;
			Sys.print("log",args,"#0080C0");
		}

		Sys.error=function(__args){
			var args=arguments;
			Sys.print("error",args,"#FF0000");
		}

		Sys.warn=function(__args){
			var args=arguments;
			Sys.print("warn",args,"#9B9B00");
		}

		Sys.plugin=function(__args){
			var args=arguments;
			Sys.print("plugin",args,"#007300");
		}

		Sys.print=function(type,args,color){
			var msg="";
			for (var i=0;i < args.length;i++){
				msg+=args[i]+" ";
			}
			console.log("%c ["+type+"]"+msg,"color: "+color+"");
		}

		Sys.alert=function(msg){
			if (SystemSetting.isCMDVer){
				console.log(msg);
				return;
			}
			alert(msg);
			SysLog.log(msg,"alert");
		}

		Sys.lang=function(body,__args){
			var args=[];for(var i=1,sz=arguments.length;i<sz;i++)args.push(arguments[i]);
			var i=0,len=0;
			len=args.length;
			for (i=0;i < len;i++){
				body=body.replace("{"+i+"}",args[i]);
			}
			return body;
		}

		return Sys;
	})()


	/**
	*...
	*@author ww
	*/
	//class tools.PreLoads
	var PreLoads=(function(){
		function PreLoads(){
			this.handler=null;
			this.skinResList=["view.json","comp.json","play.json"];
			this.mXML=null;
			this.mData=null;
		}

		__class(PreLoads,'tools.PreLoads');
		var __proto=PreLoads.prototype;
		__proto.loadRes=function(){
			var i=0,len=0;
			var loadList;
			loadList=[];
			var skinPath;
			skinPath=IDESkinManager.getSkinPath();
			len=this.skinResList.length;
			for(i=0;i<len;i++){
				loadList.push({url:skinPath+this.skinResList[i],type:"atlas"});
			}
			Laya.loader.load(loadList,Handler.create(this,this.loadXMLFile),Handler.create(this,this.progressFun));
		}

		__proto.progressFun=function(){}
		__proto.loadXMLFile=function(){
			this.xmlLoaded(null);
		}

		__proto.xmlLoaded=function(data){
			RenderManager.I.initRenders();
			this.handler.run();
		}

		PreLoads.TestMode=false;
		return PreLoads;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-10-19 上午10:45:14
	*/
	//class wraps.binarypic.BinaryPicTools
	var BinaryPicTools=(function(){
		function BinaryPicTools(){}
		__class(BinaryPicTools,'wraps.binarypic.BinaryPicTools');
		BinaryPicTools.init=function(){
			PNGTools.init();
			JPGTools.init();
		}

		BinaryPicTools.clearCache=function(){}
		BinaryPicTools.getResInfo=function(path){
			if(!FileTools.exist(path))return null;
			var extension;
			extension=FileTools.getExtensionName(path);
			extension=extension.toLowerCase();
			if(extension!="png"&&extension!="jpg")return null;
			var changeTime;
			changeTime=FileTools.getMTime(path).toString();
			var cacheO;
			cacheO=BinaryPicTools.infoCacheDic[path];
			if(cacheO){
				if(cacheO["mTime"]==changeTime&&cacheO["tex"]){
					return cacheO["tex"];
				}
				}else{
				cacheO={};
			}
			cacheO["mTime"]=changeTime;
			BinaryPicTools.infoCacheDic[path]=cacheO;
			var data;
			data=FileTools.readFile(path,null);
			var rst;
			rst=ImageInfo.imageInfo(data);
			cacheO["tex"]=rst;
			return rst;
		}

		BinaryPicTools.getRes=function(path){
			if(!ResFileManager.enableBinaryPic)return null;
			if(!FileTools.exist(path))return null;
			var extension;
			extension=FileTools.getExtensionName(path);
			extension=extension.toLowerCase();
			if(extension!="png"&&extension!="jpg")return null;
			var changeTime;
			changeTime=FileTools.getMTime(path).toString();
			var cacheO;
			cacheO=BinaryPicTools.cacheDic[path];
			if(cacheO){
				if(cacheO["mTime"]==changeTime&&cacheO["tex"]){
					return cacheO["tex"];
				}
				}else{
				cacheO={};
				BinaryPicTools.cacheDic[path]=cacheO;
			}
			cacheO["mTime"]=changeTime;
			var data;
			data=FileTools.readFile(path,null);
			rst=BinaryPicTools.createTextureByBinary(data,path);
			cacheO["tex"]=rst;
			BinaryPicTools.cacheDic[path]=cacheO;
			return rst;
			console.log("path:",path);
			console.log("img:",ImageInfo.imageInfo(data));
			var rst;
			if(extension=="png"){
				rst=PNGTools.createTextureByBinary(data);
			}
			if(extension=="jpg"){
				rst=JPGTools.createTextureByBinary(data);
			}
			cacheO["tex"]=rst;
			return rst;
		}

		BinaryPicTools.createTextureByBinary=function(data,path){
			var bmp=new BinaryBitmap();
			bmp.setBinaryData(data,path);
			return new Texture(bmp);
		}

		BinaryPicTools.cacheDic={};
		BinaryPicTools.infoCacheDic={};
		return BinaryPicTools;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-10-19 上午11:46:38
	*/
	//class wraps.binarypic.ImageInfo
	var ImageInfo=(function(){
		function ImageInfo(){}
		__class(ImageInfo,'wraps.binarypic.ImageInfo');
		ImageInfo.readUInt32=function(buffer,offset,bigEndian){
			if (buffer.readUInt32){
				return buffer.readUInt32(offset,bigEndian);
			};
			var value=0;
			if (bigEndian){
				if (buffer.readUInt32BE){
					return buffer.readUInt32BE(offset);
				}
				value=(buffer[offset] << 24)+(buffer[offset+1] << 16)+(buffer[offset+2] << 8)+buffer[offset+3];
			}
			else {
				if (buffer.readUInt32LE){
					return buffer.readUInt32LE(offset);
				}
				value=buffer[offset]+(buffer[offset+1] << 8)+(buffer[offset+2] << 16)+(buffer[offset+3] << 24);
			}
			return value;
		}

		ImageInfo.readUInt16=function(buffer,offset,bigEndian){
			if (buffer.readUInt16){
				return buffer.readUInt16(offset,bigEndian);
			};
			var value=0;
			if (bigEndian){
				if (buffer.readUInt16BE){
					return buffer.readUInt16BE(offset);
				}
				value=(buffer[offset] << 8)+buffer[offset+1];
			}
			else {
				if (buffer.readUInt16LE){
					return buffer.readUInt16LE(offset);
				}
				value=buffer[offset]+(buffer[offset+1] << 8);
			}
			return value;
		}

		ImageInfo.readBit=function(buffer,offset,bitOffset){
			if (bitOffset > 7){
				offset+=Math.floor(bitOffset / 8);
				bitOffset=bitOffset % 8;
			};
			var b=buffer[offset];
			if (bitOffset < 7){
				b >>>=(7-bitOffset);
			};
			var val=b & 0x01;
			return val;
		}

		ImageInfo.readBits=function(buffer,offset,bitOffset,bitLen,signed){
			var val=0;
			var neg=false;
			if (signed){
				if (ImageInfo.readBit(buffer,offset,bitOffset)> 0){
					neg=true;
				}
				bitLen--;
				bitOffset++;
			};
			var bytes=[];
			for (var i=0;i < bitLen;i++){
				var b=ImageInfo.readBit(buffer,offset,bitOffset+i);
				if (i>0 && (bitLen-i)% 8==0){
					bytes.push(val);
					val=0;
				}
				val <<=1;
				val |=b;
			}
			bytes.push(val);
			val=new Buffer(bytes);;
			val.negative=neg?true:false;
			return val;
		}

		ImageInfo.imageInfoPng=function(buffer){
			var imageHeader=[0x49,0x48,0x44,0x52],
			pos=12;
			if (!ImageInfo.checkSig(buffer,pos,imageHeader)){
				return false;
			}
			pos+=4;
			return {
				type:'image',
				format:'PNG',
				mimeType:'image/png',
				width:ImageInfo.readUInt32(buffer,pos,true),
				height:ImageInfo.readUInt32(buffer,pos+4,true)
			};
		}

		ImageInfo.imageInfoJpg=function(buffer){
			var pos=2,
			len=buffer.length,
			sizeSig=[0xff,[0xc0,0xc2]];
			while (pos < len){
				if (ImageInfo.checkSig(buffer,pos,sizeSig)){
					pos+=5;
					return {
						type:'image',
						format:'JPG',
						mimeType:'image/jpeg',
						width:ImageInfo.readUInt16(buffer,pos+2,true),
						height:ImageInfo.readUInt16(buffer,pos,true)
					};
				}
				pos+=2;
				var size=ImageInfo.readUInt16(buffer,pos,true);
				pos+=size;
			}
		}

		ImageInfo.imageInfoGif=function(buffer){
			var pos=6;
			return {
				type:'image',
				format:'GIF',
				mimeType:'image/gif',
				width:ImageInfo.readUInt16(buffer,pos,false),
				height:ImageInfo.readUInt16(buffer,pos+2,false)
			};
		}

		ImageInfo.checkSig=function(buffer,offset,sig){
			var len=sig.length;
			for (var i=0;i < len;i++){
				var b=buffer[i+offset],
				s=sig[i],
				m=false;
				if ('number'==typeof s){
					m=s===b;
				}
				else {
					for (var k in s){
						var o=s[k];
						if (o===b){
							m=true;
						}
					}
				}
				if (!m){
					return false;
				}
			}
			return true;
		}

		ImageInfo.imageInfo=function(buffer){
			var pngSig=[0x89,0x50,0x4e,0x47,0x0d,0x0a,0x1a,0x0a];
			var jpgSig=[0xff,0xd8,0xff];
			var gifSig=[0x47,0x49,0x46,0x38,[0x37,0x39],0x61];
			var swfSig=[[0x46,0x43],0x57,0x53];
			if (ImageInfo.checkSig(buffer,0,pngSig))return ImageInfo.imageInfoPng(buffer);
			if (ImageInfo.checkSig(buffer,0,jpgSig))return ImageInfo.imageInfoJpg(buffer);
			if (ImageInfo.checkSig(buffer,0,gifSig))return ImageInfo.imageInfoGif(buffer);
			return false;
		}

		return ImageInfo;
	})()


	/**
	*...
	*@author ww
	*/
	//class wraps.binarypic.JPGTools
	var JPGTools=(function(){
		function JPGTools(){}
		__class(JPGTools,'wraps.binarypic.JPGTools');
		var __proto=JPGTools.prototype;
		__proto.PNGTools=function(){}
		JPGTools.init=function(){
			var zclss;
			zclss=JpegImage;
			JPGTools.JPG=zclss;
		}

		JPGTools.createCanvasByBinary=function(data){
			var canvas=new HTMLCanvas("2D");
			var ctx=canvas.getContext('2d');
			canvas.size(100,100);
			var jpg;
			jpg=new JPGTools.JPG();
			jpg.parse(data);
			return JPGTools.renderJpgToCanvas(jpg,canvas);
		}

		JPGTools.renderJpgToCanvas=function(jpg,canvas){
			var ctx;
			ctx=canvas.source.getContext("2d");
			canvas.size(jpg.width,jpg.height);
			var data;
			data=ctx.createImageData(jpg.width,jpg.height);
			jpg.copyToImageData(data);
			ctx.putImageData(data,0,0);
			return canvas;
		}

		JPGTools.createTextureByBinary=function(data){
			var canvas;
			canvas=wraps.binarypic.JPGTools.createCanvasByBinary(data);
			return new Texture(canvas);
		}

		JPGTools.JPG=null
		return JPGTools;
	})()


	/**
	*...
	*@author ww
	*/
	//class wraps.binarypic.PNGTools
	var PNGTools=(function(){
		function PNGTools(){}
		__class(PNGTools,'wraps.binarypic.PNGTools');
		PNGTools.init=function(){
			var zclss;
			zclss=PNG;
			PNGTools.PNG=zclss;
		}

		PNGTools.loadPngToCanvas=function(url){
			var canvas=new HTMLCanvas("2D");
			var ctx=canvas.getContext('2d');
			canvas.size(100,100);
			PNGTools.PNG.load(url,canvas.source);
			return canvas;
		}

		PNGTools.createCanvasByBinary=function(data){
			var canvas=new HTMLCanvas("2D");
			var ctx=canvas.getContext('2d');
			PNGTools.PNG.setByData(data,canvas.source);
			canvas["_w"]=canvas.source.width;
			canvas["_h"]=canvas.source.height;
			return canvas;
		}

		PNGTools.createTextureByBinary=function(data){
			var canvas;
			canvas=wraps.binarypic.PNGTools.createCanvasByBinary(data);
			return new Texture(canvas);
		}

		PNGTools.PNG=null
		return PNGTools;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-10-20 下午4:14:49
	*/
	//class wraps.SMD5
	var SMD5=(function(){
		function SMD5(){}
		__class(SMD5,'wraps.SMD5');
		SMD5.safeAdd=function(x,y){
			var lsw=(x & 0xFFFF)+(y & 0xFFFF);
			var msw=(x >> 16)+(y >> 16)+(lsw >> 16);
			return (msw << 16)| (lsw & 0xFFFF);
		}

		SMD5.bitRotateLeft=function(num,cnt){
			return (num << cnt)| (num >>> (32-cnt))
		}

		SMD5.md5cmn=function(q,a,b,x,s,t){
			return SMD5.safeAdd(SMD5.bitRotateLeft(SMD5.safeAdd(SMD5.safeAdd(a,q),SMD5.safeAdd(x,t)),s),b)
		}

		SMD5.md5ff=function(a,b,c,d,x,s,t){
			return SMD5.md5cmn((b & c)| ((~b)& d),a,b,x,s,t)
		}

		SMD5.md5gg=function(a,b,c,d,x,s,t){
			return SMD5.md5cmn((b & d)| (c & (~d)),a,b,x,s,t)
		}

		SMD5.md5hh=function(a,b,c,d,x,s,t){
			return SMD5.md5cmn(b ^ c ^ d,a,b,x,s,t)
		}

		SMD5.md5ii=function(a,b,c,d,x,s,t){
			return SMD5.md5cmn(c ^ (b | (~d)),a,b,x,s,t)
		}

		SMD5.binlMD5=function(x,len){
			x[len >> 5] |=0x80 << (len % 32)
			x[(((len+64)>>> 9)<< 4)+14]=len;
			var i=0;
			var olda=0;
			var oldb=0;
			var oldc=0;
			var oldd=0;
			var a=1732584193;
			var b=-271733879;
			var c=-1732584194;
			var d=271733878;
			for (i=0;i < x.length;i+=16){
				olda=a
				oldb=b
				oldc=c
				oldd=d
				a=SMD5.md5ff(a,b,c,d,x[i],7,-680876936)
				d=SMD5.md5ff(d,a,b,c,x[i+1],12,-389564586)
				c=SMD5.md5ff(c,d,a,b,x[i+2],17,606105819)
				b=SMD5.md5ff(b,c,d,a,x[i+3],22,-1044525330)
				a=SMD5.md5ff(a,b,c,d,x[i+4],7,-176418897)
				d=SMD5.md5ff(d,a,b,c,x[i+5],12,1200080426)
				c=SMD5.md5ff(c,d,a,b,x[i+6],17,-1473231341)
				b=SMD5.md5ff(b,c,d,a,x[i+7],22,-45705983)
				a=SMD5.md5ff(a,b,c,d,x[i+8],7,1770035416)
				d=SMD5.md5ff(d,a,b,c,x[i+9],12,-1958414417)
				c=SMD5.md5ff(c,d,a,b,x[i+10],17,-42063)
				b=SMD5.md5ff(b,c,d,a,x[i+11],22,-1990404162)
				a=SMD5.md5ff(a,b,c,d,x[i+12],7,1804603682)
				d=SMD5.md5ff(d,a,b,c,x[i+13],12,-40341101)
				c=SMD5.md5ff(c,d,a,b,x[i+14],17,-1502002290)
				b=SMD5.md5ff(b,c,d,a,x[i+15],22,1236535329)
				a=SMD5.md5gg(a,b,c,d,x[i+1],5,-165796510)
				d=SMD5.md5gg(d,a,b,c,x[i+6],9,-1069501632)
				c=SMD5.md5gg(c,d,a,b,x[i+11],14,643717713)
				b=SMD5.md5gg(b,c,d,a,x[i],20,-373897302)
				a=SMD5.md5gg(a,b,c,d,x[i+5],5,-701558691)
				d=SMD5.md5gg(d,a,b,c,x[i+10],9,38016083)
				c=SMD5.md5gg(c,d,a,b,x[i+15],14,-660478335)
				b=SMD5.md5gg(b,c,d,a,x[i+4],20,-405537848)
				a=SMD5.md5gg(a,b,c,d,x[i+9],5,568446438)
				d=SMD5.md5gg(d,a,b,c,x[i+14],9,-1019803690)
				c=SMD5.md5gg(c,d,a,b,x[i+3],14,-187363961)
				b=SMD5.md5gg(b,c,d,a,x[i+8],20,1163531501)
				a=SMD5.md5gg(a,b,c,d,x[i+13],5,-1444681467)
				d=SMD5.md5gg(d,a,b,c,x[i+2],9,-51403784)
				c=SMD5.md5gg(c,d,a,b,x[i+7],14,1735328473)
				b=SMD5.md5gg(b,c,d,a,x[i+12],20,-1926607734)
				a=SMD5.md5hh(a,b,c,d,x[i+5],4,-378558)
				d=SMD5.md5hh(d,a,b,c,x[i+8],11,-2022574463)
				c=SMD5.md5hh(c,d,a,b,x[i+11],16,1839030562)
				b=SMD5.md5hh(b,c,d,a,x[i+14],23,-35309556)
				a=SMD5.md5hh(a,b,c,d,x[i+1],4,-1530992060)
				d=SMD5.md5hh(d,a,b,c,x[i+4],11,1272893353)
				c=SMD5.md5hh(c,d,a,b,x[i+7],16,-155497632)
				b=SMD5.md5hh(b,c,d,a,x[i+10],23,-1094730640)
				a=SMD5.md5hh(a,b,c,d,x[i+13],4,681279174)
				d=SMD5.md5hh(d,a,b,c,x[i],11,-358537222)
				c=SMD5.md5hh(c,d,a,b,x[i+3],16,-722521979)
				b=SMD5.md5hh(b,c,d,a,x[i+6],23,76029189)
				a=SMD5.md5hh(a,b,c,d,x[i+9],4,-640364487)
				d=SMD5.md5hh(d,a,b,c,x[i+12],11,-421815835)
				c=SMD5.md5hh(c,d,a,b,x[i+15],16,530742520)
				b=SMD5.md5hh(b,c,d,a,x[i+2],23,-995338651)
				a=SMD5.md5ii(a,b,c,d,x[i],6,-198630844)
				d=SMD5.md5ii(d,a,b,c,x[i+7],10,1126891415)
				c=SMD5.md5ii(c,d,a,b,x[i+14],15,-1416354905)
				b=SMD5.md5ii(b,c,d,a,x[i+5],21,-57434055)
				a=SMD5.md5ii(a,b,c,d,x[i+12],6,1700485571)
				d=SMD5.md5ii(d,a,b,c,x[i+3],10,-1894986606)
				c=SMD5.md5ii(c,d,a,b,x[i+10],15,-1051523)
				b=SMD5.md5ii(b,c,d,a,x[i+1],21,-2054922799)
				a=SMD5.md5ii(a,b,c,d,x[i+8],6,1873313359)
				d=SMD5.md5ii(d,a,b,c,x[i+15],10,-30611744)
				c=SMD5.md5ii(c,d,a,b,x[i+6],15,-1560198380)
				b=SMD5.md5ii(b,c,d,a,x[i+13],21,1309151649)
				a=SMD5.md5ii(a,b,c,d,x[i+4],6,-145523070)
				d=SMD5.md5ii(d,a,b,c,x[i+11],10,-1120210379)
				c=SMD5.md5ii(c,d,a,b,x[i+2],15,718787259)
				b=SMD5.md5ii(b,c,d,a,x[i+9],21,-343485551)
				a=SMD5.safeAdd(a,olda)
				b=SMD5.safeAdd(b,oldb)
				c=SMD5.safeAdd(c,oldc)
				d=SMD5.safeAdd(d,oldd)
			}
			return [a,b,c,d]
		}

		SMD5.binl2rstr=function(input){
			var i=0;
			var output='';
			var length32=input.length *32
			for (i=0;i < length32;i+=8){
				output+=String.fromCharCode((input[i >> 5] >>> (i % 32))& 0xFF)
			}
			return output;
		}

		SMD5.rstr2binl=function(input){
			var i=0;
			var output=[]
			output[(input.length >> 2)-1]=undefined
			for (i=0;i < output.length;i+=1){
				output[i]=0
			};
			var length8=input.length *8
			for (i=0;i < length8;i+=8){
				output[i >> 5] |=(input.charCodeAt(i / 8)& 0xFF)<< (i % 32)
			}
			return output;
		}

		SMD5.rstrMD5=function(s){
			return SMD5.binl2rstr(SMD5.binlMD5(SMD5.rstr2binl(s),s.length *8))
		}

		SMD5.rstrHMACMD5=function(key,data){
			var i=0;
			var bkey=SMD5.rstr2binl(key);
			var ipad=[];
			var opad=[];
			var hash;
			ipad[15]=opad[15]=undefined;
			if (bkey.length > 16){
				bkey=SMD5.binlMD5(bkey,key.length *8)
			}
			for (i=0;i < 16;i+=1){
				ipad[i]=bkey[i] ^ 0x36363636
				opad[i]=bkey[i] ^ 0x5C5C5C5C
			}
			hash=SMD5.binlMD5(ipad.concat(SMD5.rstr2binl(data)),512+data.length *8)
			return SMD5.binl2rstr(SMD5.binlMD5(opad.concat(hash),512+128))
		}

		SMD5.rstr2hex=function(input){
			var hexTab='0123456789abcdef';
			var output='';
			var x=0;
			var i=0;
			for (i=0;i < input.length;i+=1){
				x=input.charCodeAt(i)
				output+=hexTab.charAt((x >>> 4)& 0x0F)+
				hexTab.charAt(x & 0x0F)
			}
			return output
		}

		SMD5.str2rstrUTF8=function(input){
			return unescape(encodeURIComponent(input))
		}

		SMD5.rawMD5=function(s){
			return SMD5.rstrMD5(SMD5.str2rstrUTF8(s))
		}

		SMD5.hexMD5=function(s){
			return SMD5.rstr2hex(SMD5.rawMD5(s))
		}

		SMD5.rawHMACMD5=function(k,d){
			return SMD5.rstrHMACMD5(SMD5.str2rstrUTF8(k),SMD5.str2rstrUTF8(d))
		}

		SMD5.hexHMACMD5=function(k,d){
			return SMD5.rstr2hex(SMD5.rawHMACMD5(k,d))
		}

		SMD5.md5=function(string,key,raw){
			if (!key){
				if (!raw){
					return SMD5.hexMD5(string)
				}
				return SMD5.rawMD5(string)
			}
			if (!raw){
				return SMD5.hexHMACMD5(key,string)
			}
			return SMD5.rawHMACMD5(key,string)
		}

		return SMD5;
	})()


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-11-16 下午1:26:53
	*/
	//class ide.event.Notices
	var Notices=(function(){
		function Notices(){}
		__class(Notices,'ide.event.Notices');
		Notices.RENDER_INITED="RenderInited";
		return Notices;
	})()


	/**
	*...
	*@author WW
	*/
	//class viewRender.ViewRenderBase
	var ViewRenderBase=(function(){
		function ViewRenderBase(){
			this.initFuns();
		}

		__class(ViewRenderBase,'viewRender.ViewRenderBase');
		var __proto=ViewRenderBase.prototype;
		__proto.initFuns=function(){
			Browser.window.renderBinds={};
			Browser.window.renderBinds.setData=Utils.bind(this.setData,this);
			Browser.window.renderBinds.updateData=Utils.bind(this.updateData,this);
			Browser.window.renderBinds.clearRender=Utils.bind(this.clearRender,this);
			Browser.window.renderBinds.sizeRender=Utils.bind(this.sizeRender,this);
			Browser.window.renderBinds.posRender=Utils.bind(this.posRender,this);
			Browser.window.renderBinds.getRenderData=Utils.bind(this.getRenderData,this);
			Browser.window.renderBinds.getStage=Utils.bind(this.getStage,this);
			Browser.window.renderBinds.setNotice=Utils.bind(this.setNotice,this);
		}

		__proto.getRenderData=function(){
			return null;
		}

		__proto.setData=function(data){}
		__proto.updateData=function(data){}
		__proto.clearRender=function(){}
		__proto.sizeRender=function(width,height){}
		__proto.posRender=function(x,y){}
		__proto.getStage=function(){
			return Laya.stage;
		}

		__proto.setNotice=function(notice){
			Notice1.I=notice;
			Notice1.notify("RenderInited");
		}

		return ViewRenderBase;
	})()


	//class laya.editor.core.Wraps.xml.XMLElementList extends Array
	var XMLElementList=(function(_super){
		function XMLElementList(value){
			this._value="";
			this._parentNode=null;
			XMLElementList.__super.call(this);
			__uns(this,['_value','_parentNode']);
			if (value){
				value="<data>"+value+"</data>";
				var list=XMLElementList.create(XMLElement.create(value).childNodes);
				for (var i=0;i < list.length;i++){
					this.push(list[i]);
				}
			}
			Object.defineProperty(this,'length',{value:this.length,writable:true,enumerable:false,configurable:false});
		}

		__class(XMLElementList,'laya.editor.core.Wraps.xml.XMLElementList',Array);
		var __proto=XMLElementList.prototype;
		Laya.imps(__proto,{"laya.editor.core.Wraps.xml.IXMLElement":true})
		__proto.childIndex=function(){
			if (this.lengths()==1){
				var xml=this[0];
				var parent=xml._parentNode;
				if (parent){
					var nodes=parent._childNodes;
					for (var i=0,n=nodes.length;i < n;i++){
						if (nodes[i]==xml){
							return i;
						}
					}
				}
			}
			return-1;
		}

		__proto.getAttributes=function(){
			return this.attributes();
		}

		__proto.attributes=function(){
			return this.getAttribute("*");
		}

		//xml.@name
		__proto.getAttribute=function(name){
			var arr=[],len=this.length;
			for (var i=0;i < len;i++){
				var attributes=this[i]._attributes;
				for (var j=0;j < attributes.length;j++){
					var value=attributes[j]['key'];
					if (name=="*" || value==name){
						arr.push({"key":attributes[j]['key'],"val":attributes[j]['val']});
					}
				}
			}
			if (name!="*"){
				return arr.length>0?arr[0].val:undefined;
			}
			return laya.editor.core.Wraps.xml.XMLElementList.createFromAttribute(arr);
		}

		//xml.@name
		__proto.attribute=function(name){
			return this.getAttribute(name);
		}

		//xml.@name=value;
		__proto.setAttribute=function(name,value){
			if (this.length==1){
				var o;
				for(var $each_o in this[0]._attributes){
					o=this[0]._attributes[$each_o];
					if (o['key']==name){
						o['val']=value;
						return value;
					}
				}
				this[0]._attributes.push({key:name,val:value});
			}
			return null;
		}

		//xml.name;
		__proto.getChildByName=function(name){
			return this.child(name);
		}

		__proto.child=function(name){
			if (!this.length)
				return new XMLElementList();
			var arr=[],len=this.lengths();
			for (var i=0;i < len;i++){
				var nodes=this[i].getChildByName(name);
				(nodes && nodes.length)&& (arr=arr.concat(this[i].getChildByName(name)));
			}
			return XMLElementList.create(arr);
		}

		//xml.(@attribute==value);或者xml.(@attribute!=value)
		__proto.getChildByAttribute=function(attribute,value,equal){
			(equal===void 0)&& (equal=true);
			if (attribute=="" || attribute==null)
				return null;
			if (value=="" || value==null)
				return null;
			var ar=[],len=this.length;
			for (var i=0;i < len;i++){
				var n=this [i];
				for (var j=0;j < n._attributes.length;j++){
					if (n._attributes[j]['key']==attribute){
						if (equal && n._attributes[j]['val']==value){
							ar.push(n);
							}else if (!equal && n._attributes[j]['val'] !=value){
							ar.push(n);
						}
					}
				}
			}
			return laya.editor.core.Wraps.xml.XMLElementList.create(ar);
		}

		__proto.getChildAt=function(index){
			if (!this.length || index > this.length)
				return null;
			else
			return this[index];
		}

		// return this[0].getChildAt(index);
		__proto.children=function(){
			var xl=new XMLElementList();
			var len=this.lengths();
			for (var i=0;i < len;i++){
				var childs=this[i]._childNodes;
				var n=childs.length;
				for (var j=0;j < n;j++){
					xl.push(childs[j]);
				}
				if(n<1){
					xl.push(this[i]);
				}
			}
			return xl;
		}

		__proto.elements=function(name){
			(name===void 0)&& (name="*");
			if (!this.length)
				return new XMLElementList();
			if (name=="*")
				return this.children();
			return this.child(name);
		}

		__proto.appendChild=function(value){
			if ((typeof value=='string')){
				value=XMLElement.create(String(value));
			}
			this.__doAdd__(value);
			return value;
		}

		__proto.__addChild__=function(value){
			if ((value instanceof laya.editor.core.Wraps.xml.XMLElement )){
				var ixl=value._childNodes,len=ixl.length;
				for (var i=0;i < len;i++){
					this.__doAdd__(ixl[i]);
				}
				this.push(value);
				}else if ((value instanceof laya.editor.core.Wraps.xml.XMLElementList )){
				len=value.lengths();
				for (i=0;i < len;i++){
					this.__addChild__(value[i]);
				}
			}
		}

		__proto.__doAdd__=function(value){
			if (this.indexOf(value)!=-1)
				return;
			var n=value._nodeName;
			var x=this[n];
			if ((x instanceof laya.editor.core.Wraps.xml.XMLElementList )){
				x.__addChild__(value);
				}else if ((x instanceof laya.editor.core.Wraps.xml.XMLElement )){
				var tmp=x;
				x=this[n]=new XMLElementList();
				Object.defineProperty(this,[n],{value:this[n],writable:true,enumerable:false,configurable:false});
				x.__addChild__(tmp);
				x.__addChild__(value);
				}else if (!x){
				x=this[n]=new XMLElementList();
				x.__addChild__(value);
				Object.defineProperty(this,[n],{value:this[n],writable:true,enumerable:false,configurable:false});
			}
		}

		__proto.setName=function(str){
			if (this.length==1){
				this[0]._nodeName=str;
			}
		}

		__proto.copyFrom=function(source){
			if (this.lengths()> 1)
				return null;
			var il=((source instanceof laya.editor.core.Wraps.xml.XMLElementList ));
			if (source.lengths()> 1)
				return null;
			if (il)
				this[0].copyFrom(source.getChildAt(0));
			else
			this[0].copyFrom(source);
			return this [0];
		}

		__proto.hasOwnProperty=function(pName){
			if (this.length==0){
				return this[0].hasOwnProperty(pName);
				}else {
				var x;
				for(var $each_x in this){
					x=this[$each_x];
					if (x['hasOwnProperty'](pName))
						return true;
				}
			}
			return false;
		}

		__proto.setChildByName=function(nName,value){
			return null;
		}

		// return this;
		__proto.hasComplexContent=function(){
			return this.length > 0;
		}

		__proto.hasSimpleContent=function(){
			var len=this.length;
			for (var i=0;i < len;i++){
				if (this['_nodeValue'] !=null){
					return true
				}
			}
			return false
		}

		__proto.name=function(){
			if (this.length==1)
				return this[0].name();
			return null;
		}

		__proto.lengths=function(){
			for (var i=this.length-1;i >=0;i--){
				if (this[i]==undefined)
					this.splice(i,1);
			}
			return this.length;
		}

		__proto.toString=function(){
			var str="";
			if (this.lengths()){
				if (this.length==1){
					str+=this[0].toString();
					}else {
					for (var i=0;i < this.length;i++){
						if (this.length > 1)
							str+=this[i].getString();
					}
				}
			}
			return str;
		}

		__proto.toXMLString=function(){
			var str="";
			for (var i=0;i < this.length;i++){
				str+=this[i].toXMLString();
			}
			return str;
		}

		__proto.parent=function(){
			return this._parentNode;
		}

		__proto.copy=function(){
			var list=new XMLElementList(this.toXMLString());
			return list;
		}

		__proto.getString=function(){
			var str="";
			str=this.toXMLString();
			return str;
		}

		__proto.comments=function(){
			return null;
		}

		__proto.contains=function(value){
			return true;
		}

		__getset(0,__proto,'nodeType',function(){
			return "*";
		});

		__getset(0,__proto,'childNodes',function(){
			return null;
		});

		__getset(0,__proto,'value',function(){
			if (this.length==1){
				return this[0]._nodeValue;
			}
			return "";
			},function(str){
			if (this.length==1){
				this[0]._nodeValue=str;
			}
		});

		__getset(0,__proto,'localName',function(){
			return null
			},function(str){
			if (this.length==1){
				this[0]._nodeName=str;
			}
		});

		__getset(0,__proto,'nodeName',function(){
			return null;
		});

		__uns(__proto,['childIndex','getAttributes','attributes','getAttribute','attribute','setAttribute','getChildByName','child','getChildByAttribute','getChildAt','children','elements','appendChild','__addChild__','__doAdd__','setName','copyFrom','hasOwnProperty','setChildByName','hasComplexContent','hasSimpleContent','name','lengths','toString','toXMLString','parent','copy','getString','comments','contains']);
		XMLElementList.create=function(arr){
			var xl=new XMLElementList();
			for (var i=0;i < arr.length;i++){
				xl.__addChild__(arr[i]);
			}
			return xl;
		}

		XMLElementList.createFromAttribute=function(arr){
			var xl=new XMLElementList();
			for (var i=0;i < arr.length;i++){
				var xml=new XMLElement();
				var obj=arr[i];
				xml._nodeName=obj.key;
				xml._nodeValue=obj.val;
				xl.push(xml);
			}
			return xl;
		}

		return XMLElementList;
	})(Array)


	/**
	*<code>Node</code> 类用于创建节点对象，节点是最基本的元素。
	*/
	//class laya.display.Node extends laya.events.EventDispatcher
	var Node=(function(_super){
		function Node(){
			this.name="";
			this.destroyed=false;
			this._displayedInStage=false;
			this._parent=null;
			this.conchModel=null;
			Node.__super.call(this);
			this._childs=Node.ARRAY_EMPTY;
			this.timer=Laya.timer;
			this._$P=Node.PROP_EMPTY;
			this.conchModel=Render.isConchNode ? this.createConchModel():null;
		}

		__class(Node,'laya.display.Node',_super);
		var __proto=Node.prototype;
		__proto.createConchModel=function(){
			return null;
		}

		/**
		*<p>销毁此对象。</p>
		*@param destroyChild 是否同时销毁子节点，若值为true,则销毁子节点，否则不销毁子节点。
		*/
		__proto.destroy=function(destroyChild){
			(destroyChild===void 0)&& (destroyChild=true);
			this.destroyed=true;
			this._parent && this._parent.removeChild(this);
			if (this._childs){
				if (destroyChild)this.destroyChildren();
				else this.removeChildren();
			}
			this._childs=null;
			this._$P=null;
			this.offAll();
		}

		/**
		*销毁所有子对象，不销毁自己本身。
		*/
		__proto.destroyChildren=function(){
			if (this._childs){
				for (var i=this._childs.length-1;i >-1;i--){
					this._childs[i].destroy(true);
				}
			}
		}

		/**
		*添加子节点。
		*@param node 节点对象
		*@return 返回添加的节点
		*/
		__proto.addChild=function(node){
			if (this.destroyed || node===this)return node;
			if (node && (node).zOrder)this._set$P("hasZorder",true);
			if (node._parent===this){
				this._childs.splice(this.getChildIndex(node),1);
				this._childs.push(node);
				if (this.conchModel){
					this.conchModel.removeChild(node.conchModel);
					this.conchModel.addChildAt(node.conchModel,this._childs.length-1);
				}
				this._childChanged();
				}else {
				node.parent && node.parent.removeChild(node);
				this._childs===Node.ARRAY_EMPTY && (this._childs=[]);
				this._childs.push(node);
				this.conchModel && this.conchModel.addChildAt(node.conchModel,this._childs.length-1);
				node.parent=this;
				this._childChanged();
			}
			return node;
		}

		/**
		*批量增加子节点
		*@param ...args 无数子节点。
		*/
		__proto.addChildren=function(__args){
			var args=arguments;
			var i=0,n=args.length;
			while (i < n){
				this.addChild(args[i++]);
			}
		}

		/**
		*添加子节点到指定的索引位置。
		*@param node 节点对象。
		*@param index 索引位置。
		*@return 返回添加的节点。
		*/
		__proto.addChildAt=function(node,index){
			if (this.destroyed || node===this)return node;
			if (node && (node).zOrder)this._set$P("hasZorder",true);
			if (index >=0 && index <=this._childs.length){
				if (node._parent===this){
					var oldIndex=this.getChildIndex(node);
					this._childs.splice(oldIndex,1);
					this._childs.splice(index,0,node);
					if (this.conchModel){
						this.conchModel.removeChild(node.conchModel);
						this.conchModel.addChildAt(node.conchModel,index);
					}
					this._childChanged();
					}else {
					node.parent && node.parent.removeChild(node);
					this._childs===Node.ARRAY_EMPTY && (this._childs=[]);
					this._childs.splice(index,0,node);
					this.conchModel && this.conchModel.addChildAt(node.conchModel,index);
					node.parent=this;
				}
				return node;
				}else {
				throw new Error("appendChildAt:The index is out of bounds");
			}
		}

		/**
		*根据子节点对象，获取子节点的索引位置。
		*@param node 子节点。
		*@return 子节点所在的索引位置。
		*/
		__proto.getChildIndex=function(node){
			return this._childs.indexOf(node);
		}

		/**
		*根据子节点的名字，获取子节点对象。
		*@param name 子节点的名字。
		*@return 节点对象。
		*/
		__proto.getChildByName=function(name){
			var nodes=this._childs;
			for (var i=0,n=nodes.length;i < n;i++){
				var node=nodes[i];
				if (node.name===name)return node;
			}
			return null;
		}

		/**@private */
		__proto._get$P=function(key){
			return this._$P[key];
		}

		/**@private */
		__proto._set$P=function(key,value){
			if (!this.destroyed){
				this._$P===Node.PROP_EMPTY && (this._$P={});
				this._$P[key]=value;
			}
			return value;
		}

		/**
		*根据子节点的索引位置，获取子节点对象。
		*@param index 索引位置
		*@return 子节点
		*/
		__proto.getChildAt=function(index){
			return this._childs[index];
		}

		/**
		*设置子节点的索引位置。
		*@param node 子节点。
		*@param index 新的索引。
		*@return 返回子节点本身。
		*/
		__proto.setChildIndex=function(node,index){
			var childs=this._childs;
			if (index < 0 || index >=childs.length){
				throw new Error("setChildIndex:The index is out of bounds.");
			};
			var oldIndex=this.getChildIndex(node);
			if (oldIndex < 0)throw new Error("setChildIndex:node is must child of this object.");
			childs.splice(oldIndex,1);
			childs.splice(index,0,node);
			if (this.conchModel){
				this.conchModel.removeChild(node.conchModel);
				this.conchModel.addChildAt(node.conchModel,index);
			}
			this._childChanged();
			return node;
		}

		/**
		*@private
		*子节点发生改变。
		*@param child 子节点。
		*/
		__proto._childChanged=function(child){}
		/**
		*删除子节点。
		*@param node 子节点
		*@return 被删除的节点
		*/
		__proto.removeChild=function(node){
			if (!this._childs)return node;
			var index=this._childs.indexOf(node);
			return this.removeChildAt(index);
		}

		/**
		*从父容器删除自己，如已经被删除不会抛出异常。
		*@return 当前节点（ Node ）对象。
		*/
		__proto.removeSelf=function(){
			this._parent && this._parent.removeChild(this);
			return this;
		}

		/**
		*根据子节点名字删除对应的子节点对象，如果找不到不会抛出异常。
		*@param name 对象名字。
		*@return 查找到的节点（ Node ）对象。
		*/
		__proto.removeChildByName=function(name){
			var node=this.getChildByName(name);
			node && this.removeChild(node);
			return node;
		}

		/**
		*根据子节点索引位置，删除对应的子节点对象。
		*@param index 节点索引位置。
		*@return 被删除的节点。
		*/
		__proto.removeChildAt=function(index){
			var node=this.getChildAt(index);
			if (node){
				this._childs.splice(index,1);
				this.conchModel && this.conchModel.removeChild(node.conchModel);
				node.parent=null;
			}
			return node;
		}

		/**
		*删除指定索引区间的所有子对象。
		*@param beginIndex 开始索引。
		*@param endIndex 结束索引。
		*@return 当前节点对象。
		*/
		__proto.removeChildren=function(beginIndex,endIndex){
			(beginIndex===void 0)&& (beginIndex=0);
			(endIndex===void 0)&& (endIndex=0x7fffffff);
			if (this._childs && this._childs.length > 0){
				var childs=this._childs;
				if (beginIndex===0 && endIndex >=n){
					var arr=childs;
					this._childs=Node.ARRAY_EMPTY;
					}else {
					arr=childs.splice(beginIndex,endIndex-beginIndex);
				}
				for (var i=0,n=arr.length;i < n;i++){
					arr[i].parent=null;
					this.conchModel && this.conchModel.removeChild(arr[i].conchModel);
				}
			}
			return this;
		}

		/**
		*替换子节点。
		*@internal 将传入的新节点对象替换到已有子节点索引位置处。
		*@param newNode 新节点。
		*@param oldNode 老节点。
		*@return 返回新节点。
		*/
		__proto.replaceChild=function(newNode,oldNode){
			var index=this._childs.indexOf(oldNode);
			if (index >-1){
				this._childs.splice(index,1,newNode);
				if (this.conchModel){
					this.conchModel.removeChild(oldNode.conchModel);
					this.conchModel.addChildAt(newNode.conchModel,index);
				}
				oldNode.parent=null;
				newNode.parent=this;
				return newNode;
			}
			return null;
		}

		/**@private */
		__proto._setDisplay=function(value){
			if (this._displayedInStage!==value){
				this._displayedInStage=value;
				if (value)this.event("display");
				else this.event("undisplay");
			}
		}

		/**
		*@private
		*设置指定节点对象是否可见(是否在渲染列表中)。
		*@param node 节点。
		*@param display 是否可见。
		*/
		__proto._displayChild=function(node,display){
			var childs=node._childs;
			if (childs){
				for (var i=0,n=childs.length;i < n;i++){
					var child=childs[i];
					child._setDisplay(display);
					child._childs.length && this._displayChild(child,display);
				}
			}
			node._setDisplay(display);
		}

		/**
		*当前容器是否包含 <code>node</code> 节点。
		*@param node 某一个节点 <code>Node</code>。
		*@return 一个布尔值表示是否包含<code>node</code>节点。
		*/
		__proto.contains=function(node){
			if (node===this)return true;
			while (node){
				if (node.parent===this)return true;
				node=node.parent;
			}
			return false;
		}

		/**
		*定时重复执行某函数。
		*@param delay 间隔时间(单位毫秒)。
		*@param caller 执行域(this)。
		*@param method 结束时的回调方法。
		*@param args 回调参数。
		*@param coverBefore 是否覆盖之前的延迟执行，默认为true。
		*/
		__proto.timerLoop=function(delay,caller,method,args,coverBefore){
			(coverBefore===void 0)&& (coverBefore=true);
			this.timer._create(false,true,delay,caller,method,args,coverBefore);
		}

		/**
		*定时执行某函数一次。
		*@param delay 延迟时间(单位毫秒)。
		*@param caller 执行域(this)。
		*@param method 结束时的回调方法。
		*@param args 回调参数。
		*@param coverBefore 是否覆盖之前的延迟执行，默认为true。
		*/
		__proto.timerOnce=function(delay,caller,method,args,coverBefore){
			(coverBefore===void 0)&& (coverBefore=true);
			this.timer._create(false,false,delay,caller,method,args,coverBefore);
		}

		/**
		*定时重复执行某函数(基于帧率)。
		*@param delay 间隔几帧(单位为帧)。
		*@param caller 执行域(this)。
		*@param method 结束时的回调方法。
		*@param args 回调参数。
		*@param coverBefore 是否覆盖之前的延迟执行，默认为true。
		*/
		__proto.frameLoop=function(delay,caller,method,args,coverBefore){
			(coverBefore===void 0)&& (coverBefore=true);
			this.timer._create(true,true,delay,caller,method,args,coverBefore);
		}

		/**
		*定时执行一次某函数(基于帧率)。
		*@param delay 延迟几帧(单位为帧)。
		*@param caller 执行域(this)
		*@param method 结束时的回调方法
		*@param args 回调参数
		*@param coverBefore 是否覆盖之前的延迟执行，默认为true
		*/
		__proto.frameOnce=function(delay,caller,method,args,coverBefore){
			(coverBefore===void 0)&& (coverBefore=true);
			this.timer._create(true,false,delay,caller,method,args,coverBefore);
		}

		/**
		*清理定时器。
		*@param caller 执行域(this)。
		*@param method 结束时的回调方法。
		*/
		__proto.clearTimer=function(caller,method){
			this.timer.clear(caller,method);
		}

		/**
		*子对象数量。
		*/
		__getset(0,__proto,'numChildren',function(){
			return this._childs.length;
		});

		/**父节点。*/
		__getset(0,__proto,'parent',function(){
			return this._parent;
			},function(value){
			if (this._parent!==value){
				if (value){
					this._parent=value;
					this.event("added");
					value.displayedInStage && this._displayChild(this,true);
					value._childChanged(this);
					}else {
					this.event("removed");
					this._parent._childChanged();
					this._displayChild(this,false);
					this._parent=value;
				}
			}
		});

		/**表示是否在显示列表中显示。是否在显示渲染列表中。*/
		__getset(0,__proto,'displayedInStage',function(){
			return this._displayedInStage;
		});

		Node.ARRAY_EMPTY=[];
		Node.PROP_EMPTY={};
		return Node;
	})(EventDispatcher)


	/**
	*@private
	*<code>CSSStyle</code> 类是元素CSS样式定义类。
	*/
	//class laya.display.css.CSSStyle extends laya.display.css.Style
	var CSSStyle=(function(_super){
		function CSSStyle(ower){
			this._bgground=null;
			this._border=null;
			//this._ower=null;
			this._rect=null;
			this.lineHeight=0;
			CSSStyle.__super.call(this);
			this._padding=CSSStyle._PADDING;
			this._spacing=CSSStyle._SPACING;
			this._aligns=CSSStyle._ALIGNS;
			this._font=Font.EMPTY;
			this._ower=ower;
		}

		__class(CSSStyle,'laya.display.css.CSSStyle',_super);
		var __proto=CSSStyle.prototype;
		/**@inheritDoc */
		__proto.destroy=function(){
			this._ower=null;
			this._font=null;
			this._rect=null;
		}

		/**
		*复制传入的 CSSStyle 属性值。
		*@param src 待复制的 CSSStyle 对象。
		*/
		__proto.inherit=function(src){
			this._font=src._font;
			this._spacing=src._spacing===CSSStyle._SPACING ? CSSStyle._SPACING :src._spacing.slice();
			this.lineHeight=src.lineHeight;
		}

		/**@private */
		__proto._widthAuto=function(){
			return (this._type & 0x40000)!==0;
		}

		/**@inheritDoc */
		__proto.widthed=function(sprite){
			return (this._type & 0x8)!=0;
		}

		/**
		*@private
		*/
		__proto._calculation=function(type,value){
			if (value.indexOf('%')< 0)return false;
			var ower=this._ower;
			var parent=ower.parent;
			var rect=this._rect;
			function getValue (pw,w,nums){
				return (pw *nums[0]+w *nums[1]+nums[2]);
			}
			function onParentResize (type){
				var pw=parent.width,w=ower.width;
				rect.width && (ower.width=getValue(pw,w,rect.width));
				rect.height && (ower.height=getValue(pw,w,rect.height));
				rect.left && (ower.x=getValue(pw,w,rect.left));
				rect.top && (ower.y=getValue(pw,w,rect.top));
			}
			if (rect===null){
				parent._getCSSStyle()._type |=0x80000;
				parent.on("resize",this,onParentResize);
				this._rect=rect={input:{}};
			};
			var nums=value.split(' ');
			nums[0]=parseFloat(nums[0])/ 100;
			if (nums.length==1)
				nums[1]=nums[2]=0;
			else {
				nums[1]=parseFloat(nums[1])/ 100;
				nums[2]=parseFloat(nums[2]);
			}
			rect[type]=nums;
			rect.input[type]=value;
			onParentResize(type);
			return true;
		}

		/**
		*是否已设置高度。
		*@param sprite 显示对象 Sprite。
		*@return 一个Boolean 表示是否已设置高度。
		*/
		__proto.heighted=function(sprite){
			return (this._type & 0x2000)!=0;
		}

		/**
		*设置宽高。
		*@param w 宽度。
		*@param h 高度。
		*/
		__proto.size=function(w,h){
			var ower=this._ower;
			var resize=false;
			if (w!==-1 && w !=this._ower.width){
				this._type |=0x8;
				this._ower.width=w;
				resize=true;
			}
			if (h!==-1 && h !=this._ower.height){
				this._type |=0x2000;
				this._ower.height=h;
				resize=true;
			}
			if (resize){
				ower._layoutLater();
				(this._type & 0x80000)&& ower.event("resize",this);
			}
		}

		/**@private */
		__proto._getAlign=function(){
			return this._aligns[0];
		}

		/**@private */
		__proto._getValign=function(){
			return this._aligns[1];
		}

		/**@private */
		__proto._getCssFloat=function(){
			return (this._type & 0x8000)!=0 ? 0x8000 :0;
		}

		__proto._createFont=function(){
			return (this._type & 0x1000)? this._font :(this._type |=0x1000,this._font=new Font(this._font));
		}

		/**@inheritDoc */
		__proto.render=function(sprite,context,x,y){
			var w=sprite.width;
			var h=sprite.height;
			x-=sprite.pivotX;
			y-=sprite.pivotY;
			this._bgground && this._bgground.color !=null && context.ctx.fillRect(x,y,w,h,this._bgground.color);
			this._border && this._border.color && context.drawRect(x,y,w,h,this._border.color.strColor,this._border.size);
		}

		/**@inheritDoc */
		__proto.getCSSStyle=function(){
			return this;
		}

		/**
		*设置 CSS 样式字符串。
		*@param text CSS样式字符串。
		*/
		__proto.cssText=function(text){
			this.attrs(CSSStyle.parseOneCSS(text,';'));
		}

		/**
		*根据传入的属性名、属性值列表，设置此对象的属性值。
		*@param attrs 属性名与属性值列表。
		*/
		__proto.attrs=function(attrs){
			if (attrs){
				for (var i=0,n=attrs.length;i < n;i++){
					var attr=attrs[i];
					this[attr[0]]=attr[1];
				}
			}
		}

		/**@inheritDoc */
		__proto.setTransform=function(value){
			(value==='none')? (this._tf=Style._TF_EMPTY):this.attrs(CSSStyle.parseOneCSS(value,','));
		}

		/**
		*定义 X 轴、Y 轴移动转换。
		*@param x X 轴平移量。
		*@param y Y 轴平移量。
		*/
		__proto.translate=function(x,y){
			this._tf===Style._TF_EMPTY && (this._tf=new TransformInfo());
			this._tf.translateX=x;
			this._tf.translateY=y;
		}

		/**
		*定义 缩放转换。
		*@param x X 轴缩放值。
		*@param y Y 轴缩放值。
		*/
		__proto.scale=function(x,y){
			this._tf===Style._TF_EMPTY && (this._tf=new TransformInfo());
			this._tf.scaleX=x;
			this._tf.scaleY=y;
		}

		/**@private */
		__proto._enableLayout=function(){
			return (this._type & 0x2)===0 && (this._type & 0x4)===0;
		}

		/**
		*是否显示为块级元素。
		*/
		__getset(0,__proto,'block',_super.prototype._$get_block,function(value){
			value ? (this._type |=0x1):(this._type &=(~0x1));
		});

		/**
		*垂直对齐方式。
		*/
		__getset(0,__proto,'valign',function(){
			return CSSStyle._valigndef[this._aligns[1]];
			},function(value){
			this._aligns===CSSStyle._ALIGNS && (this._aligns=[0,0,0]);
			this._aligns[1]=CSSStyle._valigndef[value];
		});

		/**
		*高度。
		*/
		__getset(0,__proto,'height',null,function(h){
			this._type |=0x2000;
			if ((typeof h=='string')){
				if (this._calculation("height",h))return;
				h=parseInt(h);
			}
			this.size(-1,h);
		});

		/**
		*宽度。
		*/
		__getset(0,__proto,'width',null,function(w){
			this._type |=0x8;
			if ((typeof w=='string')){
				var offset=w.indexOf('auto');
				if (offset >=0){
					this._type |=0x40000;
					w=w.substr(0,offset);
				}
				if (this._calculation("width",w))return;
				w=parseInt(w);
			}
			this.size(w,-1);
		});

		/**
		*字体粗细。
		*/
		__getset(0,__proto,'fontWeight',function(){
			return this._font.weight;
			},function(value){
			this._createFont().weight=value;
		});

		/**
		*表示左边距。
		*/
		__getset(0,__proto,'left',null,function(value){
			var ower=this._ower;
			if (((typeof value=='string'))){
				if (value==="center")
					value="50% -50% 0";
				else if (value==="right")
				value="100% -100% 0";
				if (this._calculation("left",value))return;
				value=parseInt(value);
			}
			ower.x=value;
		});

		__getset(0,__proto,'_translate',null,function(value){
			this.translate(value[0],value[1]);
		});

		/**@inheritDoc */
		__getset(0,__proto,'absolute',function(){
			return (this._type & 0x4)!==0;
		});

		/**
		*表示上边距。
		*/
		__getset(0,__proto,'top',null,function(value){
			var ower=this._ower;
			if (((typeof value=='string'))){
				if (value==="middle")
					value="50% -50% 0";
				else if (value==="bottom")
				value="100% -100% 0";
				if (this._calculation("top",value))return;
				value=parseInt(value);
			}
			ower.y=value;
		});

		/**
		*水平对齐方式。
		*/
		__getset(0,__proto,'align',function(){
			return CSSStyle._aligndef[this._aligns[0]];
			},function(value){
			this._aligns===CSSStyle._ALIGNS && (this._aligns=[0,0,0]);
			this._aligns[0]=CSSStyle._aligndef[value];
		});

		/**
		*表示是否加粗。
		*/
		__getset(0,__proto,'bold',function(){
			return this._font.bold;
			},function(value){
			this._createFont().bold=value;
		});

		/**
		*边距信息。
		*/
		__getset(0,__proto,'padding',function(){
			return this._padding;
			},function(value){
			this._padding=value;
		});

		/**
		*行间距。
		*/
		__getset(0,__proto,'leading',function(){
			return this._spacing[1];
			},function(d){
			((typeof d=='string'))&& (d=parseInt(d+""));
			this._spacing===CSSStyle._SPACING && (this._spacing=[0,0]);
			this._spacing[1]=d;
		});

		/**
		*是否是行元素。
		*/
		__getset(0,__proto,'lineElement',function(){
			return (this._type & 0x10000)!=0;
			},function(value){
			value ? (this._type |=0x10000):(this._type &=(~0x10000));
		});

		/**
		*浮动方向。
		*/
		__getset(0,__proto,'cssFloat',function(){
			return (this._type & 0x8000)!=0 ? "right" :"left";
			},function(value){
			this.lineElement=false;
			value==="right" ? (this._type |=0x8000):(this._type &=(~0x8000));
		});

		/**
		*添加到文本的修饰。
		*/
		__getset(0,__proto,'textDecoration',function(){
			return this._font.decoration;
			},function(value){
			this._createFont().decoration=value;
		});

		/**
		*设置如何处理元素内的空白。
		*/
		__getset(0,__proto,'whiteSpace',function(){
			return (this._type & 0x20000)? "nowrap" :"";
			},function(type){
			type==="nowrap" && (this._type |=0x20000);
			type==="none" && (this._type &=~0x20000);
		});

		__getset(0,__proto,'background',null,function(value){
			if (!value){
				this._bgground=null;
				return;
			}
			this._bgground || (this._bgground={});
			this._bgground.color=value;
			this._ower.conchModel && this._ower.conchModel.bgColor(value);
			this._type |=0x4000;
			this._ower._renderType |=0x100;
		});

		/**
		*表示是否换行。
		*/
		__getset(0,__proto,'wordWrap',function(){
			return (this._type & 0x20000)===0;
			},function(value){
			value ? (this._type &=~0x20000):(this._type |=0x20000);
		});

		/**
		*字体颜色。
		*/
		__getset(0,__proto,'color',function(){
			return this._font.color;
			},function(value){
			this._createFont().color=value;
		});

		/**
		*<p>指定文本字段是否是密码文本字段。</p>
		*如果此属性的值为 true，则文本字段被视为密码文本字段，并使用星号而不是实际字符来隐藏输入的字符。如果为 false，则不会将文本字段视为密码文本字段。
		*/
		__getset(0,__proto,'password',function(){
			return this._font.password;
			},function(value){
			this._createFont().password=value;
		});

		/**
		*背景颜色。
		*/
		__getset(0,__proto,'backgroundColor',function(){
			return this._bgground ? this._bgground.color :null;
			},function(value){
			if (value==='none')this._bgground=null;
			else (this._bgground || (this._bgground={}),this._bgground.color=value);
			this._ower.conchModel && this._ower.conchModel.bgColor(value);
			this._ower._renderType |=0x100;
		});

		/**
		*字体信息。
		*/
		__getset(0,__proto,'font',function(){
			return this._font.toString();
			},function(value){
			this._createFont().set(value);
		});

		/**
		*文本的粗细。
		*/
		__getset(0,__proto,'weight',null,function(value){
			this._createFont().weight=value;
		});

		/**
		*间距。
		*/
		__getset(0,__proto,'letterSpacing',function(){
			return this._spacing[0];
			},function(d){
			((typeof d=='string'))&& (d=parseInt(d+""));
			this._spacing===CSSStyle._SPACING && (this._spacing=[0,0]);
			this._spacing[0]=d;
		});

		/**
		*字体大小。
		*/
		__getset(0,__proto,'fontSize',function(){
			return this._font.size;
			},function(value){
			this._createFont().size=value;
		});

		/**
		*表示是否为斜体。
		*/
		__getset(0,__proto,'italic',function(){
			return this._font.italic;
			},function(value){
			this._createFont().italic=value;
		});

		/**
		*字体系列。
		*/
		__getset(0,__proto,'fontFamily',function(){
			return this._font.family;
			},function(value){
			this._createFont().family=value;
		});

		/**
		*<p>描边宽度（以像素为单位）。</p>
		*默认值0，表示不描边。
		*@default 0
		*/
		__getset(0,__proto,'stroke',function(){
			return this._font.stroke[0];
			},function(value){
			if (this._createFont().stroke===Font._STROKE)this._font.stroke=[0,"#000000"];
			this._font.stroke[0]=value;
		});

		/**
		*<p>描边颜色，以字符串表示。</p>
		*@default "#000000";
		*/
		__getset(0,__proto,'strokeColor',function(){
			return this._font.stroke[1];
			},function(value){
			if (this._createFont().stroke===Font._STROKE)this._font.stroke=[0,"#000000"];
			this._font.stroke[1]=value;
		});

		/**
		*边框属性，比如border="5px solid red"
		*/
		__getset(0,__proto,'border',function(){
			return this._border ? this._border.value :"";
			},function(value){
			if (value=='none'){
				this._border=null;
				return;
			}
			this._border || (this._border={});
			this._border.value=value;
			var values=value.split(' ');
			this._border.color=Color.create(values[values.length-1]);
			if (values.length==1){
				this._border.size=1;
				this._border.type='solid';
				return;
			};
			var i=0;
			if (values[0].indexOf('px')> 0){
				this._border.size=parseInt(values[0]);
				i++;
			}else this._border.size=1;
			this._border.type=values[i];
			this._ower._renderType |=0x100;
		});

		/**
		*边框的颜色。
		*/
		__getset(0,__proto,'borderColor',function(){
			return (this._border && this._border.color)? this._border.color.strColor :null;
			},function(value){
			if (!value){
				this._border=null;
				return;
			}
			this._border || (this._border={size:1,type:'solid'});
			this._border.color=(value==null)? null :Color.create(value);
			this._ower.conchModel && this._ower.conchModel.border(this._border.color.strColor);
			this._ower._renderType |=0x100;
		});

		/**
		*元素的定位类型。
		*/
		__getset(0,__proto,'position',function(){
			return (this._type & 0x4)? "absolute" :"";
			},function(value){
			value=="absolute" ? (this._type |=0x4):(this._type &=~0x4);
		});

		/**
		*规定元素应该生成的框的类型。
		*/
		__getset(0,__proto,'display',null,function(value){
			switch (value){
				case '':
					this._type &=~0x2;
					this.visible=true;
					break ;
				case 'none':
					this._type |=0x2;
					this.visible=false;
					this._ower._layoutLater();
					break ;
				}
		});

		/**@inheritDoc */
		__getset(0,__proto,'paddingLeft',function(){
			return this.padding[3];
		});

		/**@inheritDoc */
		__getset(0,__proto,'paddingTop',function(){
			return this.padding[0];
		});

		__getset(0,__proto,'_scale',null,function(value){
			this._ower.scale(value[0],value[1]);
		});

		__getset(0,__proto,'_rotate',null,function(value){
			this._ower.rotation=value;
		});

		CSSStyle.parseOneCSS=function(text,clipWord){
			var out=[];
			var attrs=text.split(clipWord);
			var valueArray;
			for (var i=0,n=attrs.length;i < n;i++){
				var attr=attrs[i];
				var ofs=attr.indexOf(':');
				var name=attr.substr(0,ofs).replace(/^\s+|\s+$/g,'');
				if (name.length==0)
					continue ;
				var value=attr.substr(ofs+1).replace(/^\s+|\s+$/g,'');
				var one=[name,value];
				switch (name){
					case 'italic':
					case 'bold':
						one[1]=value=="true";
						break ;
					case 'line-height':
						one[0]='lineHeight';
						one[1]=parseInt(value);
						break ;
					case 'font-size':
						one[0]='fontSize';
						one[1]=parseInt(value);
						break ;
					case 'padding':
						valueArray=value.split(' ');
						valueArray.length > 1 || (valueArray[1]=valueArray[2]=valueArray[3]=valueArray[0]);
						one[1]=[parseInt(valueArray[0]),parseInt(valueArray[1]),parseInt(valueArray[2]),parseInt(valueArray[3])];
						break ;
					case 'rotate':
						one[0]="_rotate";
						one[1]=parseFloat(value);
						break ;
					case 'scale':
						valueArray=value.split(' ');
						one[0]="_scale";
						one[1]=[parseFloat(valueArray[0]),parseFloat(valueArray[1])];
						break ;
					case 'translate':
						valueArray=value.split(' ');
						one[0]="_translate";
						one[1]=[parseInt(valueArray[0]),parseInt(valueArray[1])];
						break ;
					default :
						(one[0]=CSSStyle._CSSTOVALUE[name])|| (one[0]=name);
					}
				out.push(one);
			}
			return out;
		}

		CSSStyle.parseCSS=function(text,uri){
			var one;
			while ((one=CSSStyle._parseCSSRegExp.exec(text))!=null){
				CSSStyle.styleSheets[one[1]]=CSSStyle.parseOneCSS(one[2],';');
			}
		}

		CSSStyle.EMPTY=new CSSStyle(null);
		CSSStyle._CSSTOVALUE={'letter-spacing':'letterSpacing','line-spacing':'lineSpacing','white-space':'whiteSpace','line-height':'lineHeight','scale-x':'scaleX','scale-y':'scaleY','translate-x':'translateX','translate-y':'translateY','font-family':'fontFamily','font-weight':'fontWeight','vertical-align':'valign','text-decoration':'textDecoration','background-color':'backgroundColor','border-color':'borderColor','float':'cssFloat'};
		CSSStyle._parseCSSRegExp=new RegExp("([\.\#]\\w+)\\s*{([\\s\\S]*?)}","g");
		CSSStyle._aligndef={'left':0,'center':1,'right':2,0:'left',1:'center',2:'right'};
		CSSStyle._valigndef={'top':0,'middle':1,'bottom':2,0:'top',1:'middle',2:'bottom'};
		CSSStyle.styleSheets={};
		CSSStyle.ALIGN_CENTER=1;
		CSSStyle.ALIGN_RIGHT=2;
		CSSStyle.VALIGN_MIDDLE=1;
		CSSStyle.VALIGN_BOTTOM=2;
		CSSStyle._CSS_BLOCK=0x1;
		CSSStyle._DISPLAY_NONE=0x2;
		CSSStyle._ABSOLUTE=0x4;
		CSSStyle._WIDTH_SET=0x8;
		CSSStyle._PADDING=[0,0,0,0];
		CSSStyle._RECT=[-1,-1,-1,-1];
		CSSStyle._SPACING=[0,0];
		CSSStyle._ALIGNS=[0,0,0];
		CSSStyle.ADDLAYOUTED=0x200;
		CSSStyle._NEWFONT=0x1000;
		CSSStyle._HEIGHT_SET=0x2000;
		CSSStyle._BACKGROUND_SET=0x4000;
		CSSStyle._FLOAT_RIGHT=0x8000;
		CSSStyle._LINE_ELEMENT=0x10000;
		CSSStyle._NOWARP=0x20000;
		CSSStyle._WIDTHAUTO=0x40000;
		CSSStyle._LISTERRESZIE=0x80000;
		return CSSStyle;
	})(Style)


	/**
	*@private
	*使用Audio标签播放声音
	*/
	//class laya.media.h5audio.AudioSound extends laya.events.EventDispatcher
	var AudioSound=(function(_super){
		function AudioSound(){
			this.url=null;
			this.audio=null;
			this.loaded=false;
			AudioSound.__super.call(this);
		}

		__class(AudioSound,'laya.media.h5audio.AudioSound',_super);
		var __proto=AudioSound.prototype;
		/**
		*释放声音
		*
		*/
		__proto.dispose=function(){
			var ad=AudioSound._audioCache[this.url];
			if (ad){
				ad.src="";
				delete AudioSound._audioCache[this.url];
			}
		}

		/**
		*加载声音
		*@param url
		*
		*/
		__proto.load=function(url){
			this.url=url;
			var ad=AudioSound._audioCache[url];
			if (ad && ad.readyState >=2){
				this.event("complete");
				return;
			}
			if (!ad){
				ad=Browser.createElement("audio");
				ad.src=url;
				AudioSound._audioCache[url]=ad;
			}
			ad.addEventListener("canplaythrough",onLoaded);
			ad.addEventListener("error",onErr);
			var me=this;
			function onLoaded (){
				offs();
				me.loaded=true;
				me.event("complete");
			}
			function onErr (){
				offs();
				me.event("error");
			}
			function offs (){
				ad.removeEventListener("canplaythrough",onLoaded);
				ad.removeEventListener("error",onErr);
			}
			this.audio=ad;
			if (ad.load){
				ad.load();
				}else {
				onErr();
			}
		}

		/**
		*播放声音
		*@param startTime 起始时间
		*@param loops 循环次数
		*@return
		*
		*/
		__proto.play=function(startTime,loops){
			(startTime===void 0)&& (startTime=0);
			(loops===void 0)&& (loops=0);
			if (!this.url)return null;
			var ad;
			ad=AudioSound._audioCache[this.url];
			if (!ad)return null;
			var tAd;
			tAd=Pool.getItem("audio:"+this.url);
			tAd=tAd?tAd:ad.cloneNode(true);
			var channel=new AudioSoundChannel(tAd);
			channel.url=this.url;
			channel.loops=loops;
			channel.startTime=startTime;
			channel.play();
			SoundManager.addChannel(channel);
			return channel;
		}

		/**
		*获取总时间。
		*/
		__getset(0,__proto,'duration',function(){
			var ad;
			ad=AudioSound._audioCache[this.url];
			if (!ad)
				return 0;
			return ad.duration;
		});

		AudioSound._audioCache={};
		return AudioSound;
	})(EventDispatcher)


	/**
	*<code>SoundChannel</code> 用来控制程序中的声音。
	*/
	//class laya.media.SoundChannel extends laya.events.EventDispatcher
	var SoundChannel=(function(_super){
		function SoundChannel(){
			this.url=null;
			this.loops=0;
			this.startTime=NaN;
			this.isStopped=false;
			this.completeHandler=null;
			SoundChannel.__super.call(this);
		}

		__class(SoundChannel,'laya.media.SoundChannel',_super);
		var __proto=SoundChannel.prototype;
		/**
		*播放。
		*/
		__proto.play=function(){}
		/**
		*停止。
		*/
		__proto.stop=function(){}
		/**
		*private
		*/
		__proto.__runComplete=function(handler){
			if (handler){
				handler.run();
			}
		}

		/**
		*音量。
		*/
		__getset(0,__proto,'volume',function(){
			return 1;
			},function(v){
		});

		/**
		*获取当前播放时间。
		*/
		__getset(0,__proto,'position',function(){
			return 0;
		});

		/**
		*获取总时间。
		*/
		__getset(0,__proto,'duration',function(){
			return 0;
		});

		return SoundChannel;
	})(EventDispatcher)


	/**
	*<code>Sound</code> 类是用来播放控制声音的类。
	*/
	//class laya.media.Sound extends laya.events.EventDispatcher
	var Sound=(function(_super){
		function Sound(){Sound.__super.call(this);;
		};

		__class(Sound,'laya.media.Sound',_super);
		var __proto=Sound.prototype;
		/**
		*加载声音。
		*@param url 地址。
		*
		*/
		__proto.load=function(url){}
		/**
		*播放声音。
		*@param startTime 开始时间,单位秒
		*@param loops 循环次数,0表示一直循环
		*@return 声道 SoundChannel 对象。
		*
		*/
		__proto.play=function(startTime,loops){
			(startTime===void 0)&& (startTime=0);
			(loops===void 0)&& (loops=0);
			return null;
		}

		/**
		*释放声音资源。
		*
		*/
		__proto.dispose=function(){}
		/**
		*获取总时间。
		*/
		__getset(0,__proto,'duration',function(){
			return 0;
		});

		return Sound;
	})(EventDispatcher)


	/**
	*@private
	*web audio api方式播放声音
	*/
	//class laya.media.webaudio.WebAudioSound extends laya.events.EventDispatcher
	var WebAudioSound=(function(_super){
		function WebAudioSound(){
			this.url=null;
			this.loaded=false;
			this.data=null;
			this.audioBuffer=null;
			this.__toPlays=null;
			WebAudioSound.__super.call(this);
		}

		__class(WebAudioSound,'laya.media.webaudio.WebAudioSound',_super);
		var __proto=WebAudioSound.prototype;
		/**
		*加载声音
		*@param url
		*
		*/
		__proto.load=function(url){
			var me=this;
			this.url=url;
			this.audioBuffer=WebAudioSound._dataCache[url];
			if (this.audioBuffer){
				this._loaded(this.audioBuffer);
				return;
			}
			WebAudioSound.e.on("loaded:"+url,this,this._loaded);
			WebAudioSound.e.on("err:"+url,this,this._err);
			if (WebAudioSound.__loadingSound[url]){
				return;
			}
			WebAudioSound.__loadingSound[url]=true;
			var request=new Browser.window.XMLHttpRequest();
			request.open("GET",url,true);
			request.responseType="arraybuffer";
			request.onload=function (){
				me.data=request.response;
				WebAudioSound.buffs.push({"buffer":me.data,"url":me.url});
				WebAudioSound.decode();
			};
			request.onerror=function (e){
				me._err();
			}
			request.send();
		}

		__proto._err=function(){
			this._removeLoadEvents();
			WebAudioSound.__loadingSound[this.url]=false;
			this.event("error");
		}

		__proto._loaded=function(audioBuffer){
			this._removeLoadEvents();
			this.audioBuffer=audioBuffer;
			WebAudioSound._dataCache[this.url]=this.audioBuffer;
			this.loaded=true;
			this.event("complete");
		}

		__proto._removeLoadEvents=function(){
			WebAudioSound.e.off("loaded:"+this.url,this,this._loaded);
			WebAudioSound.e.off("err:"+this.url,this,this._err);
		}

		__proto.__playAfterLoaded=function(){
			if (!this.__toPlays)return;
			var i=0,len=0;
			var toPlays;
			toPlays=this.__toPlays;
			len=toPlays.length;
			var tParams;
			for (i=0;i < len;i++){
				tParams=toPlays[i];
				if(tParams[2]&&!(tParams [2]).isStopped){
					this.play(tParams[0],tParams[1],tParams[2]);
				}
			}
			this.__toPlays.length=0;
		}

		/**
		*播放声音
		*@param startTime 起始时间
		*@param loops 循环次数
		*@return
		*
		*/
		__proto.play=function(startTime,loops,channel){
			(startTime===void 0)&& (startTime=0);
			(loops===void 0)&& (loops=0);
			channel=channel ? channel :new WebAudioSoundChannel();
			if (!this.audioBuffer){
				if (this.url){
					if (!this.__toPlays)this.__toPlays=[];
					this.__toPlays.push([startTime,loops,channel]);
					this.once("complete",this,this.__playAfterLoaded);
					this.load(this.url);
				}
			}
			channel.url=this.url;
			channel.loops=loops;
			channel["audioBuffer"]=this.audioBuffer;
			channel.startTime=startTime;
			channel.play();
			SoundManager.addChannel(channel);
			return channel;
		}

		__proto.dispose=function(){
			delete WebAudioSound._dataCache[this.url];
			delete WebAudioSound.__loadingSound[this.url];
		}

		__getset(0,__proto,'duration',function(){
			if (this.audioBuffer){
				return this.audioBuffer.duration;
			}
			return 0;
		});

		WebAudioSound.decode=function(){
			if (WebAudioSound.buffs.length <=0 || WebAudioSound.isDecoding){
				return;
			}
			WebAudioSound.isDecoding=true;
			WebAudioSound.tInfo=WebAudioSound.buffs.shift();
			WebAudioSound.ctx.decodeAudioData(WebAudioSound.tInfo["buffer"],WebAudioSound._done,WebAudioSound._fail);
		}

		WebAudioSound._done=function(audioBuffer){
			WebAudioSound.e.event("loaded:"+WebAudioSound.tInfo.url,audioBuffer);
			WebAudioSound.isDecoding=false;
			WebAudioSound.decode();
		}

		WebAudioSound._fail=function(){
			WebAudioSound.e.event("err:"+WebAudioSound.tInfo.url,null);
			WebAudioSound.isDecoding=false;
			WebAudioSound.decode();
		}

		WebAudioSound._playEmptySound=function(){
			if (WebAudioSound.ctx==null){return;};
			var source=WebAudioSound.ctx.createBufferSource();
			source.buffer=WebAudioSound._miniBuffer;
			source.connect(WebAudioSound.ctx.destination);
			source.start(0,0,0);
		}

		WebAudioSound._unlock=function(){
			if (WebAudioSound._unlocked){return;}
				WebAudioSound._playEmptySound();
			if (WebAudioSound.ctx.state=="running"){
				Browser.document.removeEventListener("mousedown",WebAudioSound._unlock,true);
				Browser.document.removeEventListener("touchend",WebAudioSound._unlock,true);
				WebAudioSound._unlocked=true;
			}
		}

		WebAudioSound.initWebAudio=function(){
			if (WebAudioSound.ctx.state !="running"){
				WebAudioSound._unlock();
				Browser.document.addEventListener("mousedown",WebAudioSound._unlock,true);
				Browser.document.addEventListener("touchend",WebAudioSound._unlock,true);
			}
		}

		WebAudioSound._dataCache={};
		WebAudioSound.buffs=[];
		WebAudioSound.isDecoding=false;
		WebAudioSound._unlocked=false;
		WebAudioSound.tInfo=null
		WebAudioSound.__loadingSound={};
		__static(WebAudioSound,
		['window',function(){return this.window=Browser.window;},'webAudioEnabled',function(){return this.webAudioEnabled=WebAudioSound.window["AudioContext"] || WebAudioSound.window["webkitAudioContext"] || WebAudioSound.window["mozAudioContext"];},'ctx',function(){return this.ctx=WebAudioSound.webAudioEnabled ? new (WebAudioSound.window["AudioContext"] || WebAudioSound.window["webkitAudioContext"] || WebAudioSound.window["mozAudioContext"])():undefined;},'_miniBuffer',function(){return this._miniBuffer=WebAudioSound.ctx.createBuffer(1,1,22050);},'e',function(){return this.e=new EventDispatcher();}
		]);
		return WebAudioSound;
	})(EventDispatcher)


	/**
	*<code>HttpRequest</code> 通过 HTTP 协议传送或接收 XML 及其他数据。
	*/
	//class laya.net.HttpRequest extends laya.events.EventDispatcher
	var HttpRequest=(function(_super){
		function HttpRequest(){
			this._responseType=null;
			this._data=null;
			HttpRequest.__super.call(this);
			this._http=new Browser.window.XMLHttpRequest();
		}

		__class(HttpRequest,'laya.net.HttpRequest',_super);
		var __proto=HttpRequest.prototype;
		/**
		*发送请求。
		*@param url 请求的地址。
		*@param data 发送的数据，可选。
		*@param method 发送数据方式，值为“get”或“post”，默认为 “get”方式。
		*@param responseType 返回消息类型，可设置为"text"，"json"，"xml","arraybuffer"。
		*@param headers 头信息，key value数组，比如["Content-Type","application/json"]。
		*/
		__proto.send=function(url,data,method,responseType,headers){
			(method===void 0)&& (method="get");
			(responseType===void 0)&& (responseType="text");
			this._responseType=responseType;
			this._data=null;
			var _this=this;
			var http=this._http;
			http.open(method,url,true);
			if (headers){
				for (var i=0;i < headers.length;i++){
					http.setRequestHeader(headers[i++],headers[i]);
				}
				}else {
				if (!data || (typeof data=='string'))http.setRequestHeader("Content-Type","application/x-www-form-urlencoded");
				else http.setRequestHeader("Content-Type","application/json");
			}
			http.responseType=responseType!=="arraybuffer" ? "text" :"arraybuffer";
			http.onerror=function (e){
				_this._onError(e);
			}
			http.onabort=function (e){
				_this._onAbort(e);
			}
			http.onprogress=function (e){
				_this._onProgress(e);
			}
			http.onload=function (e){
				_this._onLoad(e);
			}
			http.send(data);
		}

		/**
		*@private
		*请求进度的侦听处理函数。
		*@param e 事件对象。
		*/
		__proto._onProgress=function(e){
			if (e && e.lengthComputable)this.event("progress",e.loaded / e.total);
		}

		/**
		*@private
		*请求中断的侦听处理函数。
		*@param e 事件对象。
		*/
		__proto._onAbort=function(e){
			this.error("Request was aborted by user");
		}

		/**
		*@private
		*请求出错侦的听处理函数。
		*@param e 事件对象。
		*/
		__proto._onError=function(e){
			this.error("Request failed Status:"+this._http.status+" text:"+this._http.statusText);
		}

		/**
		*@private
		*请求消息返回的侦听处理函数。
		*@param e 事件对象。
		*/
		__proto._onLoad=function(e){
			var http=this._http;
			var status=http.status!==undefined ? http.status :200;
			if (status===200 || status===204 || status===0){
				this.complete();
				}else {
				this.error("["+http.status+"]"+http.statusText+":"+http.responseURL);
			}
		}

		/**
		*@private
		*请求错误的处理函数。
		*@param message 错误信息。
		*/
		__proto.error=function(message){
			this.clear();
			this.event("error",message);
		}

		/**
		*@private
		*请求成功完成的处理函数。
		*/
		__proto.complete=function(){
			this.clear();
			var flag=true;
			try {
				if (this._responseType==="json"){
					this._data=JSON.parse(this._http.responseText);
					}else if (this._responseType==="xml"){
					this._data=Utils.parseXMLFromString(this._http.responseText);
					}else {
					this._data=this._http.response || this._http.responseText;
				}
				}catch (e){
				flag=false;
				this.error(e.message);
			}
			flag && this.event("complete",(this._data instanceof Array)? [this._data] :this._data);
		}

		/**
		*@private
		*清除当前请求。
		*/
		__proto.clear=function(){
			var http=this._http;
			http.onerror=http.onabort=http.onprogress=http.onload=null;
		}

		/**请求的地址。*/
		__getset(0,__proto,'url',function(){
			return this._http.responseURL;
		});

		/**原生XMLHttpRequest引用*/
		__getset(0,__proto,'http',function(){
			return this._http;
		});

		/**返回的数据。*/
		__getset(0,__proto,'data',function(){
			return this._data;
		});

		return HttpRequest;
	})(EventDispatcher)


	/**
	*<code>Loader</code> 类可用来加载文本、JSON、XML、二进制、图像等资源。
	*/
	//class laya.net.Loader extends laya.events.EventDispatcher
	var Loader=(function(_super){
		function Loader(){
			this._data=null;
			this._url=null;
			this._type=null;
			this._cache=false;
			this._http=null;
			Loader.__super.call(this);
		}

		__class(Loader,'laya.net.Loader',_super);
		var __proto=Loader.prototype;
		/**
		*加载资源。
		*@param url 地址
		*@param type 类型，如果为null，则根据文件后缀，自动分析类型。
		*@param cache 是否缓存数据。
		*@param group 分组。
		*@param ignoreCache 是否忽略缓存，强制重新加载
		*/
		__proto.load=function(url,type,cache,group,ignoreCache){
			(cache===void 0)&& (cache=true);
			(ignoreCache===void 0)&& (ignoreCache=false);
			if (url.indexOf("data:image")===0)this._type="image";
			url=URL.formatURL(url);
			this._url=url;
			this._type=type || (type=this.getTypeFromUrl(url));
			this._cache=cache;
			this._data=null;
			if (!ignoreCache && Loader.loadedMap[url]){
				this._data=Loader.loadedMap[url];
				this.event("progress",1);
				this.event("complete",this._data);
				return;
			}
			if (group)Loader.setGroup(url,group);
			if (Loader.parserMap[type] !=null){
				if (((Loader.parserMap[type])instanceof laya.utils.Handler ))Loader.parserMap[type].runWith(this);
				else Loader.parserMap[type].call(null,this);
				return;
			}
			if (type==="image" || type==="htmlimage" || type==="nativeimage")return this._loadImage(url);
			if (type==="sound")return this._loadSound(url);
			if (!this._http){
				this._http=new HttpRequest();
				this._http.on("progress",this,this.onProgress);
				this._http.on("error",this,this.onError);
				this._http.on("complete",this,this.onLoaded);
			};
			var contentType;
			switch (type){
				case "atlas":
					contentType="json";
					break ;
				case "font":
					contentType="xml";
					break ;
				default :
					contentType=type;
				}
			this._http.send(url,null,"get",contentType);
		}

		/**
		*获取指定资源地址的数据类型。
		*@param url 资源地址。
		*@return 数据类型。
		*/
		__proto.getTypeFromUrl=function(url){
			var type=Utils.getFileExtension(url);
			if (type)return Loader.typeMap[type];
			console.log("Not recognize the resources suffix",url);
			return "text";
		}

		/**
		*@private
		*加载图片资源。
		*@param url 资源地址。
		*/
		__proto._loadImage=function(url){
			var _this=this;
			var image;
			function clear (){
				image.onload=null;
				image.onerror=null;
			};
			var onload=function (){
				clear();
				_this.onLoaded(image);
			};
			var onerror=function (){
				clear();
				_this.event("error","Load image failed");
			}
			if (this._type==="nativeimage"){
				image=new Browser.window.Image();
				image.crossOrigin="";
				image.onload=onload;
				image.onerror=onerror;
				image.src=url;
				}else {
				new HTMLImage.create(url,{onload:onload,onerror:onerror,onCreate:function (img){
						image=img;
				}});
			}
		}

		/**
		*@private
		*加载声音资源。
		*@param url 资源地址。
		*/
		__proto._loadSound=function(url){
			var sound=(new SoundManager._soundClass());
			var _this=this;
			sound.on("complete",this,soundOnload);
			sound.on("error",this,soundOnErr);
			sound.load(url);
			function soundOnload (){
				clear();
				_this.onLoaded(sound);
			}
			function soundOnErr (){
				clear();
				sound.dispose();
				_this.event("error","Load sound failed");
			}
			function clear (){
				sound.offAll();
			}
		}

		/**@private */
		__proto.onProgress=function(value){
			if (this._type==="atlas")this.event("progress",value *0.3);
			else this.event("progress",value);
		}

		/**@private */
		__proto.onError=function(message){
			this.event("error",message);
		}

		/**
		*资源加载完成的处理函数。
		*@param data 数据。
		*/
		__proto.onLoaded=function(data){
			var type=this._type;
			if (type==="image"){
				var tex=new Texture(data);
				tex.url=this._url;
				this.complete(tex);
				}else if (type==="sound" || type==="htmlimage" || type==="nativeimage"){
				this.complete(data);
				}else if (type==="atlas"){
				if (!data.src && !data._setContext){
					if (!this._data){
						this._data=data;
						if (data.meta && data.meta.image){
							var toloadPics=data.meta.image.split(",");
							var split=this._url.indexOf("/")>=0 ? "/" :"\\";
							var idx=this._url.lastIndexOf(split);
							var folderPath=idx >=0 ? this._url.substr(0,idx+1):"";
							idx=this._url.indexOf("?");
							var ver;
							ver=idx >=0 ? this._url.substr(idx):"";
							for (var i=0,len=toloadPics.length;i < len;i++){
								toloadPics[i]=folderPath+toloadPics[i]+ver;
							}
							}else {
							toloadPics=[this._url.replace(".json",".png")];
						}
						toloadPics.reverse();
						data.toLoads=toloadPics;
						data.pics=[];
					}
					this.event("progress",0.3+1 / toloadPics.length *0.6);
					return this._loadImage(URL.formatURL(toloadPics.pop()));
					}else {
					this._data.pics.push(data);
					if (this._data.toLoads.length > 0){
						this.event("progress",0.3+1 / this._data.toLoads.length *0.6);
						return this._loadImage(URL.formatURL(this._data.toLoads.pop()));
					};
					var frames=this._data.frames;
					var cleanUrl=this._url.split("?")[0];
					var directory=(this._data.meta && this._data.meta.prefix)? URL.basePath+this._data.meta.prefix :cleanUrl.substring(0,cleanUrl.lastIndexOf("."))+"/";
					var pics=this._data.pics;
					var map=Loader.atlasMap[this._url] || (Loader.atlasMap[this._url]=[]);
					map.dir=directory;
					for (var name in frames){
						var obj=frames[name];
						var tPic=pics[obj.frame.idx ? obj.frame.idx :0];
						var url=directory+name;
						Loader.cacheRes(url,Texture.create(tPic,obj.frame.x,obj.frame.y,obj.frame.w,obj.frame.h,obj.spriteSourceSize.x,obj.spriteSourceSize.y,obj.sourceSize.w,obj.sourceSize.h));
						Loader.loadedMap[url].url=url;
						map.push(url);
					}
					this.complete(this._data);
				}
				}else if (type=="font"){
				if (!data.src){
					this._data=data;
					this.event("progress",0.5);
					return this._loadImage(URL.formatURL(this._url.replace(".fnt",".png")));
					}else {
					var bFont;
					bFont=new BitmapFont();
					bFont.parseFont(this._data,data);
					var tArr=this._url.split(".fnt")[0].split("/");
					var fontName=tArr[tArr.length-1];
					Text.registerBitmapFont(fontName,bFont);
					this._data=bFont;
					this.complete(this._data);
				}
				}else {
				this.complete(data);
			}
		}

		/**
		*加载完成。
		*@param data 加载的数据。
		*/
		__proto.complete=function(data){
			this._data=data;
			Loader._loaders.push(this);
			if (!Loader._isWorking)Loader.checkNext();
		}

		/**
		*结束加载，处理是否缓存及派发完成事件 <code>Event.COMPLETE</code> 。
		*@param content 加载后的数据
		*/
		__proto.endLoad=function(content){
			content && (this._data=content);
			if (this._cache)Loader.cacheRes(this._url,this._data);
			this.event("progress",1);
			this.event("complete",(this.data instanceof Array)? [this.data] :this.data);
		}

		/**加载地址。*/
		__getset(0,__proto,'url',function(){
			return this._url;
		});

		/**返回的数据。*/
		__getset(0,__proto,'data',function(){
			return this._data;
		});

		/**是否缓存。*/
		__getset(0,__proto,'cache',function(){
			return this._cache;
		});

		/**加载类型。*/
		__getset(0,__proto,'type',function(){
			return this._type;
		});

		Loader.checkNext=function(){
			Loader._isWorking=true;
			var startTimer=Browser.now();
			var thisTimer=startTimer;
			while (Loader._startIndex < Loader._loaders.length){
				thisTimer=Browser.now();
				Loader._loaders[Loader._startIndex].endLoad();
				Loader._startIndex++;
				if (Browser.now()-startTimer > Loader.maxTimeOut){
					console.log("loader callback cost a long time:"+(Browser.now()-startTimer)+" url="+Loader._loaders[Loader._startIndex-1].url);
					Laya.timer.frameOnce(1,null,Loader.checkNext);
					return;
				}
			}
			Loader._loaders.length=0;
			Loader._startIndex=0;
			Loader._isWorking=false;
		}

		Loader.clearRes=function(url,forceDispose){
			(forceDispose===void 0)&& (forceDispose=false);
			url=URL.formatURL(url);
			var arr=Loader.atlasMap[url];
			if (arr){
				for (var i=0,n=arr.length;i < n;i++){
					var resUrl=arr[i];
					var tex=Loader.getRes(resUrl);
					if (tex)tex.destroy(forceDispose);
					delete Loader.loadedMap[resUrl];
				}
				arr.length=0;
				delete Loader.atlasMap[url];
				delete Loader.loadedMap[url];
				}else {
				var res=Loader.loadedMap[url];
				if (res){
					if ((res instanceof laya.resource.Texture )&& res.bitmap)(res).destroy(forceDispose);
					delete Loader.loadedMap[url];
				}
			}
		}

		Loader.getRes=function(url){
			return Loader.loadedMap[URL.formatURL(url)];
		}

		Loader.getAtlas=function(url){
			return Loader.atlasMap[URL.formatURL(url)];
		}

		Loader.cacheRes=function(url,data){
			url=URL.formatURL(url);
			if (Loader.loadedMap[url] !=null){
				console.log("Resources already exist,is repeated loading:",url);
				}else {
				Loader.loadedMap[url]=data;
			}
		}

		Loader.setGroup=function(url,group){
			if (!Loader.groupMap[group])Loader.groupMap[group]=[];
			Loader.groupMap[group].push(url);
		}

		Loader.clearResByGroup=function(group){
			if (!Loader.groupMap[group])return;
			var arr=Loader.groupMap[group],i=0,len=arr.length;
			for (i=0;i < len;i++){
				Loader.clearRes(arr[i]);
			}
			arr.length=0;
		}

		Loader.TEXT="text";
		Loader.JSON="json";
		Loader.XML="xml";
		Loader.BUFFER="arraybuffer";
		Loader.IMAGE="image";
		Loader.SOUND="sound";
		Loader.ATLAS="atlas";
		Loader.FONT="font";
		Loader.typeMap={"png":"image","jpg":"image","jpeg":"image","txt":"text","json":"json","xml":"xml","als":"atlas","mp3":"sound","ogg":"sound","wav":"sound","part":"json","fnt":"font"};
		Loader.parserMap={};
		Loader.loadedMap={};
		Loader.groupMap={};
		Loader.maxTimeOut=100;
		Loader.atlasMap={};
		Loader._loaders=[];
		Loader._isWorking=false;
		Loader._startIndex=0;
		return Loader;
	})(EventDispatcher)


	/**
	*<p> <code>LoaderManager</code> 类用于用于批量加载资源、数据。</p>
	*<p>批量加载器，单例，可以通过Laya.loader访问。</p>
	*多线程(默认5个线程)，5个优先级(0最快，4最慢,默认为1)
	*某个资源加载失败后，会按照最低优先级重试加载(属性retryNum决定重试几次)，如果重试后失败，则调用complete函数，并返回null
	*/
	//class laya.net.LoaderManager extends laya.events.EventDispatcher
	var LoaderManager=(function(_super){
		var ResInfo;
		function LoaderManager(){
			this.retryNum=1;
			this.maxLoader=5;
			this._loaders=[];
			this._loaderCount=0;
			this._resInfos=[];
			this._infoPool=[];
			this._maxPriority=5;
			this._failRes={};
			LoaderManager.__super.call(this);
			for (var i=0;i < this._maxPriority;i++)this._resInfos[i]=[];
		}

		__class(LoaderManager,'laya.net.LoaderManager',_super);
		var __proto=LoaderManager.prototype;
		/**
		*根据clas定义创建一个资源空壳，随后进行异步加载，资源加载完成后，会调用资源类的onAsynLoaded方法回调真正的数据,套嵌资源的子资源会保留资源路径"?"后的部分
		*@param url 资源地址或者数组，比如[{url:xx,clas:xx,priority:xx,params:xx},{url:xx,clas:xx,priority:xx,params:xx}]
		*@param progress 进度回调，回调参数为当前文件加载的进度信息(0-1)。
		*@param clas 资源类名，比如Texture
		*@param type 资源类型
		*@param priority 优先级
		*@param cache 是否缓存
		*@return 返回资源对象
		*/
		__proto.create=function(url,complete,progress,clas,params,priority,cache){
			(priority===void 0)&& (priority=1);
			(cache===void 0)&& (cache=true);
			if ((url instanceof Array)){
				var items=url;
				var itemCount=items.length;
				var loadedCount=0;
				if (progress){
					var progress2=Handler.create(progress.caller,progress.method,progress.args,false);
				}
				for (var i=0;i < itemCount;i++){
					var item=items[i];
					if ((typeof item=='string'))item=items[i]={url:item};
					item.progress=0;
					var progressHandler=progress ? Handler.create(null,onProgress,[item],false):null;
					var completeHandler=(progress || complete)? Handler.create(null,onComplete,[item]):null;
					this._create(item.url,completeHandler,progressHandler,item.clas || clas,item.params || params,item.priority || priority,cache);
				}
				function onComplete (item,content){
					loadedCount++;
					item.progress=1;
					if (loadedCount===itemCount && complete){
						complete.run();
					}
				}
				function onProgress (item,value){
					item.progress=value;
					var num=0;
					for (var j=0;j < itemCount;j++){
						var item1=items[j];
						num+=item1.progress;
					};
					var v=num / itemCount;
					progress2.runWith(v);
				}
				return true;
			}else return this._create(url,complete,progress,clas,params,priority,cache);
		}

		__proto._create=function(url,complete,progress,clas,params,priority,cache){
			(priority===void 0)&& (priority=1);
			(cache===void 0)&& (cache=true);
			var item=this.getRes(url);
			if (!item){
				var extension=Utils.getFileExtension(url);
				var creatItem=LoaderManager.createMap[extension];
				if (!clas)clas=creatItem[0];
				var type=creatItem[1];
				if (clas===Texture)type="htmlimage";
				item=clas ? new clas():null;
				this.load(url,Handler.create(null,onLoaded),progress,type,priority,false,null,true);
				function onLoaded (data){
					item && item.onAsynLoaded.call(item,url,data,params);
					if (complete)complete.run();
				}
				if (cache)LoaderManager.cacheRes(url,item);
				}else {
				progress && progress.runWith(1);
				complete && complete.run();
			}
			return item;
		}

		/**
		*加载资源。
		*@param url 地址，或者资源对象数组(简单数组：["a.png","b.png"]，复杂数组[{url:"a.png",type:Loader.IMAGE,size:100,priority:1},{url:"b.json",type:Loader.JSON,size:50,priority:1}])。
		*@param complete 结束回调，如果加载失败，则返回 null 。
		*@param progress 进度回调，回调参数为当前文件加载的进度信息(0-1)。
		*@param type 资源类型。
		*@param priority 优先级，0-4，五个优先级，0优先级最高，默认为1。
		*@param cache 是否缓存加载结果。
		*@param group 分组。
		*@param ignoreCache 是否忽略缓存，强制重新加载
		*@return 此 LoaderManager 对象。
		*/
		__proto.load=function(url,complete,progress,type,priority,cache,group,ignoreCache){
			(priority===void 0)&& (priority=1);
			(cache===void 0)&& (cache=true);
			(ignoreCache===void 0)&& (ignoreCache=false);
			if ((url instanceof Array))return this._loadAssets(url,complete,progress,type,priority,cache,group);
			url=URL.formatURL(url);
			var content=Loader.getRes(url);
			if (content !=null){
				progress && progress.runWith(1);
				complete && complete.runWith(content);
				this._loaderCount || this.event("complete");
				}else {
				var info=LoaderManager._resMap[url];
				if (!info){
					info=this._infoPool.length ? this._infoPool.pop():new ResInfo();
					info.url=url;
					info.type=type;
					info.cache=cache;
					info.group=group;
					info.ignoreCache=ignoreCache;
					complete && info.on("complete",complete.caller,complete.method,complete.args);
					progress && info.on("progress",progress.caller,progress.method,progress.args);
					LoaderManager._resMap[url]=info;
					priority=priority < this._maxPriority ? priority :this._maxPriority-1;
					this._resInfos[priority].push(info);
					this._next();
					}else {
					complete && info._createListener("complete",complete.caller,complete.method,complete.args,false,false);
					progress && info._createListener("progress",progress.caller,progress.method,progress.args,false,false);
				}
			}
			return this;
		}

		__proto._next=function(){
			if (this._loaderCount >=this.maxLoader)return;
			for (var i=0;i < this._maxPriority;i++){
				var infos=this._resInfos[i];
				if (infos.length > 0){
					var info=infos.shift();
					if (info)return this._doLoad(info);
				}
			}
			this._loaderCount || this.event("complete");
		}

		__proto._doLoad=function(resInfo){
			this._loaderCount++;
			var loader=this._loaders.length ? this._loaders.pop():new Loader();
			loader.on("complete",null,onLoaded);
			loader.on("progress",null,function(num){
				resInfo.event("progress",num);
			});
			loader.on("error",null,function(msg){
				onLoaded(null);
			});
			var _this=this;
			function onLoaded (data){
				loader.offAll();
				loader._data=null;
				_this._loaders.push(loader);
				_this._endLoad(resInfo,(data instanceof Array)? [data] :data);
				_this._loaderCount--;
				_this._next();
			}
			loader.load(resInfo.url,resInfo.type,resInfo.cache,resInfo.group,resInfo.ignoreCache);
		}

		__proto._endLoad=function(resInfo,content){
			if (content===null){
				var errorCount=this._failRes[resInfo.url] || 0;
				if (errorCount < this.retryNum){
					console.log("[warn]Retry to load:",resInfo.url);
					this._failRes[resInfo.url]=errorCount+1;
					this._resInfos[this._maxPriority-1].push(resInfo);
					return;
					}else {
					console.log("[error]Failed to load:",resInfo.url);
					this.event("error",resInfo.url);
				}
			}
			delete LoaderManager._resMap[resInfo.url];
			resInfo.event("complete",content);
			resInfo.offAll();
			this._infoPool.push(resInfo);
		}

		/**
		*清理指定资源地址缓存。
		*@param url 资源地址。
		*@param forceDispose 是否强制销毁，有些资源是采用引用计数方式销毁，如果forceDispose=true，则忽略引用计数，直接销毁，比如Texture，默认为false
		*/
		__proto.clearRes=function(url,forceDispose){
			(forceDispose===void 0)&& (forceDispose=false);
			Loader.clearRes(url,forceDispose);
		}

		/**
		*获取指定资源地址的资源。
		*@param url 资源地址。
		*@return 返回资源。
		*/
		__proto.getRes=function(url){
			return Loader.getRes(url);
		}

		/**清理当前未完成的加载，所有未加载的内容全部停止加载。*/
		__proto.clearUnLoaded=function(){
			for (var i=0;i < this._maxPriority;i++){
				var infos=this._resInfos[i];
				for (var j=infos.length-1;j >-1;j--){
					var info=infos[j];
					if (info){
						info.offAll();
						this._infoPool.push(info);
					}
				}
				infos.length=0;
			}
			this._loaderCount=0;
			LoaderManager._resMap={};
		}

		/**
		*根据地址集合清理掉未加载的内容
		*@param urls 资源地址集合
		*/
		__proto.cancelLoadByUrls=function(urls){
			if (!urls)return;
			for (var i=0,n=urls.length;i < n;i++){
				this.cancelLoadByUrl(urls[i]);
			}
		}

		/**
		*根据地址清理掉未加载的内容
		*@param url 资源地址
		*/
		__proto.cancelLoadByUrl=function(url){
			url=URL.formatURL(url);
			for (var i=0;i < this._maxPriority;i++){
				var infos=this._resInfos[i];
				for (var j=infos.length-1;j >-1;j--){
					var info=infos[j];
					if (info && info.url===url){
						infos[j]=null;
						info.offAll();
						this._infoPool.push(info);
					}
				}
			}
			if (LoaderManager._resMap[url])delete LoaderManager._resMap[url];
		}

		/**
		*@private
		*加载数组里面的资源。
		*@param arr 简单：["a.png","b.png"]，复杂[{url:"a.png",type:Loader.IMAGE,size:100,priority:1},{url:"b.json",type:Loader.JSON,size:50,priority:1}]*/
		__proto._loadAssets=function(arr,complete,progress,type,priority,cache,group){
			(priority===void 0)&& (priority=1);
			(cache===void 0)&& (cache=true);
			var itemCount=arr.length;
			var loadedCount=0;
			var totalSize=0;
			var items=[];
			var defaultType=type || "image";
			for (var i=0;i < itemCount;i++){
				var item=arr[i];
				if ((typeof item=='string'))item={url:item,type:defaultType,size:1,priority:priority};
				if (!item.size)item.size=1;
				item.progress=0;
				totalSize+=item.size;
				items.push(item);
				var progressHandler=progress ? Handler.create(null,loadProgress,[item],false):null;
				var completeHandler=(complete || progress)? Handler.create(null,loadComplete,[item]):null;
				this.load(item.url,completeHandler,progressHandler,item.type,item.priority || 1,cache,item.group || group);
			}
			function loadComplete (item,content){
				loadedCount++;
				item.progress=1;
				if (loadedCount===itemCount && complete){
					complete.run();
				}
			}
			function loadProgress (item,value){
				if (progress !=null){
					item.progress=value;
					var num=0;
					for (var j=0;j < items.length;j++){
						var item1=items[j];
						num+=item1.size *item1.progress;
					};
					var v=num / totalSize;
					progress.runWith(v);
				}
			}
			return this;
		}

		LoaderManager.cacheRes=function(url,data){
			Loader.cacheRes(url,data);
		}

		LoaderManager._resMap={};
		__static(LoaderManager,
		['createMap',function(){return this.createMap={atlas:[null,"atlas"]};}
		]);
		LoaderManager.__init$=function(){
			//class ResInfo extends laya.events.EventDispatcher
			ResInfo=(function(_super){
				function ResInfo(){
					this.url=null;
					this.type=null;
					this.cache=false;
					this.group=null;
					this.ignoreCache=false;
					ResInfo.__super.call(this);
				}
				__class(ResInfo,'',_super);
				return ResInfo;
			})(EventDispatcher)
		}

		return LoaderManager;
	})(EventDispatcher)


	/**
	*<p><code>ColorFilter</code> 是颜色滤镜。</p>
	*/
	//class laya.filters.ColorFilter extends laya.filters.Filter
	var ColorFilter=(function(_super){
		function ColorFilter(mat){
			//this._mat=null;
			//this._alpha=null;
			ColorFilter.__super.call(this);
			if (!mat){
				mat=[0.3,0.59,0.11,0,0,0.3,0.59,0.11,0,0,0.3,0.59,0.11,0,0,0,0,0,1,0];
			}
			this._mat=new Float32Array(16);
			this._alpha=new Float32Array(4);
			var j=0;
			var z=0;
			for (var i=0;i < 20;i++){
				if (i % 5 !=4){
					this._mat[j++]=mat[i];
					}else {
					this._alpha[z++]=mat[i];
				}
			}
			this._action=RunDriver.createFilterAction(0x20);
			this._action.data=this;
		}

		__class(ColorFilter,'laya.filters.ColorFilter',_super);
		var __proto=ColorFilter.prototype;
		Laya.imps(__proto,{"laya.filters.IFilter":true})
		/**
		*@private 通知微端
		*/
		__proto.callNative=function(sp){
			var t=sp._$P.cf=this;
			sp.conchModel && sp.conchModel.setFilterMatrix&&sp.conchModel.setFilterMatrix(this._mat,this._alpha);
		}

		/**@private */
		__getset(0,__proto,'type',function(){
			return 0x20;
		});

		/**@private */
		__getset(0,__proto,'action',function(){
			return this._action;
		});

		__getset(1,ColorFilter,'DEFAULT',function(){
			if (!ColorFilter._DEFAULT){
				ColorFilter._DEFAULT=new ColorFilter([1,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,1,0]);
			}
			return ColorFilter._DEFAULT;
		},laya.filters.Filter._$SET_DEFAULT);

		__getset(1,ColorFilter,'GRAY',function(){
			if (!ColorFilter._GRAY){
				ColorFilter._GRAY=new ColorFilter([0.3,0.59,0.11,0,0,0.3,0.59,0.11,0,0,0.3,0.59,0.11,0,0,0,0,0,1,0]);
			}
			return ColorFilter._GRAY;
		},laya.filters.Filter._$SET_GRAY);

		ColorFilter._DEFAULT=null
		ColorFilter._GRAY=null
		return ColorFilter;
	})(Filter)


	/**
	*@private
	*Worker Image加载器
	*/
	//class laya.net.WorkerLoader extends laya.events.EventDispatcher
	var WorkerLoader=(function(_super){
		function WorkerLoader(){
			this.worker=null;
			WorkerLoader.__super.call(this);
			var _$this=this;
			this.worker=new Browser.window.Worker("libs/worker.js");
			this.worker.onmessage=function (evt){
				_$this.workerMessage(evt.data);
			}
		}

		__class(WorkerLoader,'laya.net.WorkerLoader',_super);
		var __proto=WorkerLoader.prototype;
		/**
		*@private
		*/
		__proto.workerMessage=function(data){
			if (data){
				switch(data.type){
					case "Image":
						this.imageLoaded(data);
						break ;
					case "Msg":
						this.event("image_msg",data.msg);
						break ;
					}
			}
		}

		/**
		*@private
		*/
		__proto.imageLoaded=function(data){
			if (!data.dataType){
				this.event(data.url,null);
				this.event("image_err",data.url+"\n"+data.msg);
				return;
			};
			var canvas=new HTMLCanvas("2D");
			var ctx;
			ctx=canvas.source.getContext("2d");
			var imageData;
			switch(data.dataType){
				case "buffer":
					imageData=ctx.createImageData(data.width,data.height);
					imageData.data.set(data.buffer);
					canvas.size(imageData.width,imageData.height);
					ctx.putImageData(imageData,0,0);
					break ;
				case "imagedata":
					imageData=data.imagedata;
					canvas.size(imageData.width,imageData.height);
					ctx.putImageData(imageData,0,0);
					imageData=data.imagedata;
					break ;
				case "imageBitmap":
					imageData=data.imageBitmap;
					canvas.size(imageData.width,imageData.height);
					ctx.drawImage(imageData,0,0);
					break ;
				}
			if (Render.isWebGL){
				canvas=new laya.webgl.resource.WebGLImage(canvas,data.url);;
			}
			this.event(data.url,canvas);
		}

		/**
		*@private
		*/
		__proto._myTrace=function(__arg){
			var arg=arguments;
			var rst=[];
			var i=0,len=arg.length;
			for(i=0;i<len;i++){
				rst.push(arg[i]);
			}
			this.event("image_msg",rst.join(" "));
		}

		/**
		*加载图片
		*@param url 图片地址
		*/
		__proto.loadImage=function(url){
			var data;
			data={};
			data.type="load";
			data.url=url;
			this.worker.postMessage(data);
		}

		/**
		*@private
		*加载图片资源。
		*@param url 资源地址。
		*/
		__proto._loadImage=function(url){
			var _this=this;
			if (!WorkerLoader._enable||url.toLowerCase().indexOf(".png")< 0){
				WorkerLoader._preLoadFun.call(_this,url);
				return;
			}
			function clear (){
				laya.net.WorkerLoader.I.off(url,_this,onload);
			};
			var onload=function (image){
				clear();
				if (image){
					_this.onLoaded(image);
					}else{
					WorkerLoader._preLoadFun.call(_this,url);
				}
			};
			laya.net.WorkerLoader.I.on(url,_this,onload);
			laya.net.WorkerLoader.I.loadImage(url);
		}

		/**
		*是否启用。
		*/
		__getset(1,WorkerLoader,'enable',function(){
			return WorkerLoader._enable;
			},function(v){
			WorkerLoader._enable=v;
			if (WorkerLoader._enable && !WorkerLoader._preLoadFun)WorkerLoader.__init__();
		});

		WorkerLoader.__init__=function(){
			if (WorkerLoader._preLoadFun)return;
			if (!Browser.window.Worker)return;
			WorkerLoader._preLoadFun=Loader["prototype"]["_loadImage"];
			Loader["prototype"]["_loadImage"]=WorkerLoader["prototype"]["_loadImage"];
			if (!WorkerLoader.I)WorkerLoader.I=new WorkerLoader();
			return true;
		}

		WorkerLoader.IMAGE_LOADED="image_loaded";
		WorkerLoader.IMAGE_ERR="image_err";
		WorkerLoader.IMAGE_MSG="image_msg";
		WorkerLoader.I=null
		WorkerLoader._preLoadFun=null
		WorkerLoader._enable=false;
		return WorkerLoader;
	})(EventDispatcher)


	/**
	*<code>Resource</code> 资源存取类。
	*/
	//class laya.resource.Resource extends laya.events.EventDispatcher
	var Resource=(function(_super){
		function Resource(){
			this._id=0;
			this._lastUseFrameCount=0;
			this._memorySize=0;
			this._name=null;
			this._loaded=false;
			this._released=false;
			this._disposed=false;
			this._resourceManager=null;
			this.lock=false;
			Resource.__super.call(this);
			this._id=++Resource._uniqueIDCounter;
			Resource._loadedResources.push(this);
			Resource._isLoadedResourcesSorted=false;
			this._released=true;
			this.lock=false;
			this._memorySize=0;
			this._lastUseFrameCount=-1;
			(ResourceManager.currentResourceManager)&& (ResourceManager.currentResourceManager.addResource(this));
		}

		__class(Resource,'laya.resource.Resource',_super);
		var __proto=Resource.prototype;
		Laya.imps(__proto,{"laya.resource.ICreateResource":true,"laya.resource.IDispose":true})
		/**重新创建资源,override it，同时修改memorySize属性、处理startCreate()和compoleteCreate()方法。*/
		__proto.recreateResource=function(){
			this.startCreate();
			this.completeCreate();
		}

		/**销毁资源，override it,同时修改memorySize属性。*/
		__proto.detoryResource=function(){}
		/**
		*激活资源，使用资源前应先调用此函数激活。
		*@param force 是否强制创建。
		*/
		__proto.activeResource=function(force){
			(force===void 0)&& (force=false);
			this._lastUseFrameCount=Stat.loopCount;
			if (this._released || force){
				this.recreateResource();
			}
		}

		/**
		*释放资源。
		*@param force 是否强制释放。
		*@return 是否成功释放。
		*/
		__proto.releaseResource=function(force){
			(force===void 0)&& (force=false);
			if (!force && this.lock)
				return false;
			if (!this._released || force){
				this.detoryResource();
				this._released=true;
				this._lastUseFrameCount=-1;
				this.event("released",this);
				return true;
				}else {
				return false;
			}
		}

		/**
		*设置唯一名字,如果名字重复则自动加上“-copy”。
		*@param newName 名字。
		*/
		__proto.setUniqueName=function(newName){
			var isUnique=true;
			for (var i=0;i < Resource._loadedResources.length;i++){
				if (Resource._loadedResources[i]._name!==newName || Resource._loadedResources[i]===this)
					continue ;
				isUnique=false;
				return;
			}
			if (isUnique){
				if (this.name !=newName){
					this.name=newName;
					Resource._isLoadedResourcesSorted=false;
				}
				}else{
				this.setUniqueName(newName.concat("-copy"));
			}
		}

		/**
		*@private
		*/
		__proto.onAsynLoaded=function(url,data,params){
			throw new Error("Resource: must override this function!");
		}

		/**
		*<p>彻底处理资源，处理后不能恢复。</p>
		*<p><b>注意：</b>会强制解锁清理。</p>
		*/
		__proto.dispose=function(){
			if (this._resourceManager!==null)
				throw new Error("附属于resourceManager的资源不能独立释放！");
			this._disposed=true;
			this.lock=false;
			this.releaseResource();
			var index=Resource._loadedResources.indexOf(this);
			if (index!==-1){
				Resource._loadedResources.splice(index,1);
				Resource._isLoadedResourcesSorted=false;
			}
		}

		/**开始资源激活。*/
		__proto.startCreate=function(){
			this.event("recovering",this);
		}

		/**完成资源激活。*/
		__proto.completeCreate=function(){
			this._released=false;
			this.event("recovered",this);
		}

		__getset(0,__proto,'loaded',function(){
			return this._loaded;
		});

		/**
		*获取唯一标识ID(通常用于优化或识别)。
		*/
		__getset(0,__proto,'id',function(){
			return this._id;
		});

		/**
		*是否已处理。
		*/
		__getset(0,__proto,'disposed',function(){
			return this._disposed;
		});

		/**
		*是否已释放。
		*/
		__getset(0,__proto,'released',function(){
			return this._released;
		});

		/**
		*设置名字
		*/
		/**
		*获取名字。
		*/
		__getset(0,__proto,'name',function(){
			return this._name;
			},function(value){
			if ((value || value!=="")&& this.name!==value){
				this._name=value;
				Resource._isLoadedResourcesSorted=false;
			}
		});

		/**
		*距离上次使用帧率。
		*/
		__getset(0,__proto,'lastUseFrameCount',function(){
			return this._lastUseFrameCount;
		});

		/**
		*资源管理员。
		*/
		__getset(0,__proto,'resourceManager',function(){
			return this._resourceManager;
		});

		/**
		*占用内存尺寸。
		*/
		__getset(0,__proto,'memorySize',function(){
			return this._memorySize;
			},function(value){
			var offsetValue=value-this._memorySize;
			this._memorySize=value;
			this.resourceManager && this.resourceManager.addSize(offsetValue);
		});

		/**
		*本类型排序后的已载入资源。
		*/
		__getset(1,Resource,'sortedLoadedResourcesByName',function(){
			if (!Resource._isLoadedResourcesSorted){
				Resource._isLoadedResourcesSorted=true;
				Resource._loadedResources.sort(Resource.compareResourcesByName);
			}
			return Resource._loadedResources;
		},laya.events.EventDispatcher._$SET_sortedLoadedResourcesByName);

		Resource.getLoadedResourceByIndex=function(index){
			return Resource._loadedResources[index];
		}

		Resource.getLoadedResourcesCount=function(){
			return Resource._loadedResources.length;
		}

		Resource.compareResourcesByName=function(left,right){
			if (left===right)
				return 0;
			var x=left.name;
			var y=right.name;
			if (x===null){
				if (y===null)
					return 0;
				else
				return-1;
				}else {
				if (y==null)
					return 1;
				else {
					var retval=x.localeCompare(y);
					if (retval !=0)
						return retval;
					else {
						right.setUniqueName(y);
						y=right.name;
						return x.localeCompare(y);
					}
				}
			}
		}

		Resource._uniqueIDCounter=0;
		Resource._loadedResources=[];
		Resource._isLoadedResourcesSorted=false;
		return Resource;
	})(EventDispatcher)


	/**
	*<code>Texture</code> 是一个纹理处理类。
	*/
	//class laya.resource.Texture extends laya.events.EventDispatcher
	var Texture=(function(_super){
		function Texture(bitmap,uv){
			//this.bitmap=null;
			//this.uv=null;
			this.offsetX=0;
			this.offsetY=0;
			this.sourceWidth=0;
			this.sourceHeight=0;
			//this._loaded=false;
			this._w=0;
			this._h=0;
			//this.$_GID=NaN;
			//this.url=null;
			this._uvID=0;
			Texture.__super.call(this);
			if (bitmap){
				bitmap.useNum++;
			}
			this.setTo(bitmap,uv);
		}

		__class(Texture,'laya.resource.Texture',_super);
		var __proto=Texture.prototype;
		/**
		*设置此对象的位图资源、UV数据信息。
		*@param bitmap 位图资源
		*@param uv UV数据信息
		*/
		__proto.setTo=function(bitmap,uv){
			this.bitmap=bitmap;
			this.uv=uv || Texture.DEF_UV;
			if (bitmap){
				this._w=bitmap.width;
				this._h=bitmap.height;
				this.sourceWidth=this.sourceWidth || this._w;
				this.sourceHeight=this.sourceHeight || this._h
				this._loaded=this._w > 0;
				var _this=this;
				if (this._loaded){
					RunDriver.addToAtlas && RunDriver.addToAtlas(_this);
					}else {
					var bm=bitmap;
					if ((bm instanceof laya.resource.HTMLImage )&& bm.image)
						bm.image.addEventListener('load',function(e){
						RunDriver.addToAtlas && RunDriver.addToAtlas(_this);
					},false);
				}
			}
		}

		/**@private 激活资源。*/
		__proto.active=function(){
			this.bitmap.activeResource();
		}

		/**
		*销毁纹理（分直接销毁，跟计数销毁两种）
		*@param forceDispose true为强制销毁主纹理，false是通过计数销毁纹理
		*/
		__proto.destroy=function(forceDispose){
			(forceDispose===void 0)&& (forceDispose=false);
			if (this.bitmap && (this.bitmap).useNum > 0){
				if (forceDispose){
					this.bitmap.dispose();
					(this.bitmap).useNum=0;
					}else {
					(this.bitmap).useNum--;
					if ((this.bitmap).useNum==0){
						this.bitmap.dispose();
					}
				}
				this.bitmap=null;
				if (this.url && this===Laya.loader.getRes(this.url))Laya.loader.clearRes(this.url,forceDispose);
				this._loaded=false;
			}
		}

		/**
		*加载指定地址的图片。
		*@param url 图片地址。
		*/
		__proto.load=function(url){
			var _$this=this;
			this._loaded=false;
			var fileBitmap=(this.bitmap || (this.bitmap=HTMLImage.create(URL.formatURL(url))));
			if (fileBitmap)fileBitmap.useNum++;
			var _this=this;
			fileBitmap.onload=function (){
				fileBitmap.onload=null;
				_this._loaded=true;
				_$this.sourceWidth=_$this._w=fileBitmap.width;
				_$this.sourceHeight=_$this._h=fileBitmap.height;
				_this.event("loaded",this);
				(RunDriver.addToAtlas)&& (RunDriver.addToAtlas(_this));
			};
		}

		/**@private */
		__proto.addTextureToAtlas=function(e){
			RunDriver.addTextureToAtlas(this);
		}

		/**
		*获取Texture上的某个区域的像素点
		*@param x
		*@param y
		*@param width
		*@param height
		*@return 返回像素点集合
		*/
		__proto.getPixels=function(x,y,width,height){
			if (Render.isWebGL){
				return RunDriver.getTexturePixels(this,x,y,width,height);
				}else {
				Browser.canvas.size(width,height);
				Browser.canvas.clear();
				Browser.context.drawTexture(this,-x,-y,this.width,this.height,0,0);
				var info=Browser.context.getImageData(0,0,width,height);
			}
			return info.data;
		}

		/**@private */
		__proto.onAsynLoaded=function(url,bitmap){
			if (bitmap)bitmap.useNum++;
			this.setTo(bitmap,this.uv);
		}

		/**激活并获取资源。*/
		__getset(0,__proto,'source',function(){
			this.bitmap.activeResource();
			return this.bitmap.source;
		});

		/**
		*表示是否加载成功，只能表示初次载入成功（通常包含下载和载入）,并不能完全表示资源是否可立即使用（资源管理机制释放影响等）。
		*/
		__getset(0,__proto,'loaded',function(){
			return this._loaded;
		});

		/**
		*表示资源是否已释放。
		*/
		__getset(0,__proto,'released',function(){
			return this.bitmap.released;
		});

		/**实际宽度。*/
		__getset(0,__proto,'width',function(){
			if (this._w)return this._w;
			return (this.uv && this.uv!==Texture.DEF_UV)? (this.uv[2]-this.uv[0])*this.bitmap.width :this.bitmap.width;
			},function(value){
			this._w=value;
			this.sourceWidth || (this.sourceWidth=value);
		});

		/**
		*通过外部设置是否启用纹理平铺(后面要改成在着色器里计算)
		*/
		/**
		*获取当前纹理是否启用了纹理平铺
		*/
		__getset(0,__proto,'repeat',function(){
			if (Render.isWebGL && this.bitmap){
				return this.bitmap.repeat;
			}
			return true;
			},function(value){
			if (value){
				if (Render.isWebGL && this.bitmap){
					this.bitmap.repeat=value;
					if (value){
						this.bitmap.enableMerageInAtlas=false;
					}
				}
			}
		});

		/**实际高度。*/
		__getset(0,__proto,'height',function(){
			if (this._h)return this._h;
			return (this.uv && this.uv!==Texture.DEF_UV)? (this.uv[5]-this.uv[1])*this.bitmap.height :this.bitmap.height;
			},function(value){
			this._h=value;
			this.sourceHeight || (this.sourceHeight=value);
		});

		/**
		*设置线性采样的状态（目前只能第一次绘制前设置false生效,来关闭线性采样）
		*/
		/**
		*获取当前纹理是否启用了线性采样
		*/
		__getset(0,__proto,'isLinearSampling',function(){
			return Render.isWebGL ? (this.bitmap.minFifter !=0x2600):true;
			},function(value){
			if (!value && Render.isWebGL){
				if (!value && (this.bitmap.minFifter==-1)&& (this.bitmap.magFifter==-1)){
					this.bitmap.minFifter=0x2600;
					this.bitmap.magFifter=0x2600;
					this.bitmap.enableMerageInAtlas=false;
				}
			}
		});

		Texture.moveUV=function(offsetX,offsetY,uv){
			for (var i=0;i < 8;i+=2){
				uv[i]+=offsetX;
				uv[i+1]+=offsetY;
			}
			return uv;
		}

		Texture.create=function(source,x,y,width,height,offsetX,offsetY,sourceWidth,sourceHeight){
			(offsetX===void 0)&& (offsetX=0);
			(offsetY===void 0)&& (offsetY=0);
			(sourceWidth===void 0)&& (sourceWidth=0);
			(sourceHeight===void 0)&& (sourceHeight=0);
			var btex=(source instanceof laya.resource.Texture );
			var uv=btex ? source.uv :Texture.DEF_UV;
			var bitmap=btex ? source.bitmap :source;
			var tex=new Texture(bitmap,null);
			tex.width=width;
			tex.height=height;
			tex.offsetX=offsetX;
			tex.offsetY=offsetY;
			tex.sourceWidth=sourceWidth || width;
			tex.sourceHeight=sourceHeight || height;
			var dwidth=1 / bitmap.width;
			var dheight=1 / bitmap.height;
			x *=dwidth;
			y *=dheight;
			width *=dwidth;
			height *=dheight;
			var u1=tex.uv[0],v1=tex.uv[1],u2=tex.uv[4],v2=tex.uv[5];
			var inAltasUVWidth=(u2-u1),inAltasUVHeight=(v2-v1);
			var oriUV=Texture.moveUV(uv[0],uv[1],[x,y,x+width,y,x+width,y+height,x,y+height]);
			tex.uv=[u1+oriUV[0] *inAltasUVWidth,v1+oriUV[1] *inAltasUVHeight,u2-(1-oriUV[2])*inAltasUVWidth,v1+oriUV[3] *inAltasUVHeight,u2-(1-oriUV[4])*inAltasUVWidth,v2-(1-oriUV[5])*inAltasUVHeight,u1+oriUV[6] *inAltasUVWidth,v2-(1-oriUV[7])*inAltasUVHeight];
			return tex;
		}

		Texture.createFromTexture=function(texture,x,y,width,height){
			var rect=Rectangle.TEMP.setTo(x-texture.offsetX,y-texture.offsetY,width,height);
			var result=rect.intersection(Texture._rect1.setTo(0,0,texture.width,texture.height),Texture._rect2);
			if (result)
				var tex=Texture.create(texture,result.x,result.y,result.width,result.height,result.x-rect.x,result.y-rect.y,width,height);
			else return null;
			tex.bitmap.useNum--;
			return tex;
		}

		Texture.DEF_UV=[0,0,1.0,0,1.0,1.0,0,1.0];
		Texture.INV_UV=[0,1,1.0,1,1.0,0.0,0,0.0];
		Texture._rect1=new Rectangle();
		Texture._rect2=new Rectangle();
		return Texture;
	})(EventDispatcher)


	/**
	*<code>TimeLine</code> 是一个用来创建时间轴动画的类。
	*/
	//class laya.utils.TimeLine extends laya.events.EventDispatcher
	var TimeLine=(function(_super){
		var tweenData;
		function TimeLine(){
			this._labelDic=null;
			this._tweenDic={};
			this._tweenDataList=[];
			this._endTweenDataList=null;
			this._currTime=0;
			this._lastTime=0;
			this._startTime=0;
			this._index=0;
			this._gidIndex=0;
			this._firstTweenDic={};
			this._startTimeSort=false;
			this._endTimeSort=false;
			this._loopKey=false;
			this.scale=1;
			this._frameRate=60;
			this._frameIndex=0;
			this._total=0;
			TimeLine.__super.call(this);
		}

		__class(TimeLine,'laya.utils.TimeLine',_super);
		var __proto=TimeLine.prototype;
		/**
		*控制一个对象，从当前点移动到目标点。
		*@param target 要控制的对象。
		*@param props 要控制对象的属性。
		*@param duration 对象TWEEN的时间。
		*@param ease 缓动类型
		*@param offset 相对于上一个对象，偏移多长时间（单位：毫秒）。
		*/
		__proto.to=function(target,props,duration,ease,offset){
			(offset===void 0)&& (offset=0);
			return this._create(target,props,duration,ease,offset,true);
		}

		/**
		*从 props 属性，缓动到当前状态。
		*@param target target 目标对象(即将更改属性值的对象)
		*@param props 要控制对象的属性
		*@param duration 对象TWEEN的时间
		*@param ease 缓动类型
		*@param offset 相对于上一个对象，偏移多长时间（单位：毫秒）
		*/
		__proto.from=function(target,props,duration,ease,offset){
			(offset===void 0)&& (offset=0);
			return this._create(target,props,duration,ease,offset,false);
		}

		/**@private */
		__proto._create=function(target,props,duration,ease,offset,isTo){
			var tTweenData=new tweenData();
			tTweenData.isTo=isTo;
			tTweenData.type=0;
			tTweenData.target=target;
			tTweenData.duration=duration;
			tTweenData.data=props;
			tTweenData.startTime=this._startTime+offset;
			tTweenData.endTime=tTweenData.startTime+tTweenData.duration;
			tTweenData.ease=ease;
			this._startTime=Math.max(tTweenData.endTime,this._startTime);
			this._tweenDataList.push(tTweenData);
			this._startTimeSort=true;
			this._endTimeSort=true;
			return this;
		}

		/**
		*在时间队列中加入一个标签。
		*@param label 标签名称。
		*@param offset 标签相对于上个动画的偏移时间(单位：毫秒)。
		*/
		__proto.addLabel=function(label,offset){
			var tTweenData=new tweenData();
			tTweenData.type=1;
			tTweenData.data=label;
			tTweenData.endTime=tTweenData.startTime=this._startTime+offset;
			this._labelDic || (this._labelDic={});
			this._labelDic[label]=tTweenData;
			this._tweenDataList.push(tTweenData);
			return this;
		}

		/**
		*移除指定的标签
		*@param label
		*/
		__proto.removeLabel=function(label){
			if (this._labelDic && this._labelDic[label]){
				var tTweenData=this._labelDic[label];
				if (tTweenData){
					var tIndex=this._tweenDataList.indexOf(tTweenData);
					if (tIndex >-1){
						this._tweenDataList.splice(tIndex,1);
					}
				}
				delete this._labelDic[label];
			}
		}

		/**
		*动画从整个动画的某一时间开始。
		*@param time(单位：毫秒)。
		*/
		__proto.gotoTime=function(time){
			if (this._tweenDataList==null || this._tweenDataList.length==0)return;
			var tTween;
			var tObject;
			for (var p in this._firstTweenDic){
				tObject=this._firstTweenDic[p];
				if (tObject){
					for (var tDataP in tObject){
						if (tObject.diyTarget.hasOwnProperty(tDataP)){
							tObject.diyTarget[tDataP]=tObject[tDataP];
						}
					}
				}
			}
			for (p in this._tweenDic){
				tTween=this._tweenDic[p];
				tTween.clear();
				delete this._tweenDic[p];
			}
			this._index=0;
			this._gidIndex=0;
			this._currTime=time;
			this._lastTime=Browser.now();
			var tTweenDataCopyList;
			if (this._endTweenDataList==null || this._endTimeSort){
				this._endTimeSort=false;
				this._endTweenDataList=tTweenDataCopyList=this._tweenDataList.concat();
				function Compare (paraA,paraB){
					if (paraA.endTime > paraB.endTime){
						return 1;
						}else if (paraA.endTime < paraB.endTime){
						return-1;
						}else {
						return 0;
					}
				}
				tTweenDataCopyList.sort(Compare);
				}else {
				tTweenDataCopyList=this._endTweenDataList
			};
			var tTweenData;
			for (var i=0,n=tTweenDataCopyList.length;i < n;i++){
				tTweenData=tTweenDataCopyList[i];
				if (tTweenData.type==0){
					if (time >=tTweenData.endTime){
						this._index=Math.max(this._index,i+1);
						var props=tTweenData.data;
						for (var tP in props){
							if (tTweenData.isTo){
								tTweenData.target[tP]=props[tP];
							}
						}
						}else {
						break ;
					}
				}
			}
			for (i=0,n=this._tweenDataList.length;i < n;i++){
				tTweenData=this._tweenDataList[i];
				if (tTweenData.type==0){
					if (time >=tTweenData.startTime && time < tTweenData.endTime){
						this._index=Math.max(this._index,i+1);
						this._gidIndex++;
						tTween=Pool.getItemByClass("tween",Tween);
						tTween._create(tTweenData.target,tTweenData.data,tTweenData.duration,tTweenData.ease,Handler.create(this,this._animComplete,[this._gidIndex]),0,false,tTweenData.isTo,true,false);
						tTween.setStartTime(this._currTime-(time-tTweenData.startTime));
						tTween._updateEase(this._currTime);
						tTween.gid=this._gidIndex;
						this._tweenDic[this._gidIndex]=tTween;
					}
				}
			}
		}

		/**
		*从指定的标签开始播。
		*@param Label 标签名。
		*/
		__proto.gotoLabel=function(Label){
			if (this._labelDic==null)return;
			var tLabelData=this._labelDic[Label];
			if (tLabelData)this.gotoTime(tLabelData.startTime);
		}

		/**
		*暂停整个动画。
		*/
		__proto.pause=function(){
			Laya.timer.clear(this,this._update);
		}

		/**
		*恢复暂停动画的播放。
		*/
		__proto.resume=function(){
			this.play(this._currTime,this._loopKey);
		}

		/**
		*播放动画。
		*@param timeOrLabel 开启播放的时间点或标签名。
		*@param loop 是否循环播放。
		*/
		__proto.play=function(timeOrLabel,loop){
			(timeOrLabel===void 0)&& (timeOrLabel=0);
			(loop===void 0)&& (loop=false);
			if (this._startTimeSort){
				this._startTimeSort=false;
				function Compare (paraA,paraB){
					if (paraA.startTime > paraB.startTime){
						return 1;
						}else if (paraA.startTime < paraB.startTime){
						return-1;
						}else {
						return 0;
					}
				}
				this._tweenDataList.sort(Compare);
				for (var i=0,n=this._tweenDataList.length;i < n;i++){
					var tTweenData=this._tweenDataList[i];
					if (tTweenData !=null && tTweenData.type==0){
						var tTarget=tTweenData.target;
						var gid=(tTarget.$_GID || (tTarget.$_GID=Utils.getGID()));
						var tSrcData=null;
						if (this._firstTweenDic[gid]==null){
							tSrcData={};
							tSrcData.diyTarget=tTarget;
							this._firstTweenDic[gid]=tSrcData;
							}else {
							tSrcData=this._firstTweenDic[gid];
						}
						for (var p in tTweenData.data){
							if (tSrcData[p]==null){
								tSrcData[p]=tTarget[p];
							}
						}
					}
				}
			}
			if ((typeof timeOrLabel=='string')){
				this.gotoLabel(timeOrLabel);
				}else {
				this.gotoTime(timeOrLabel);
			}
			this._loopKey=loop;
			this._lastTime=Browser.now();
			Laya.timer.frameLoop(1,this,this._update);
		}

		/**
		*更新当前动画。
		*/
		__proto._update=function(){
			if (this._currTime >=this._startTime){
				if (this._loopKey){
					this._complete();
					this.gotoTime(0);
					}else {
					this._complete();
					this.pause();
					return;
				}
			};
			var tNow=Browser.now();
			var tFrameTime=tNow-this._lastTime;
			var tCurrTime=this._currTime+=tFrameTime *this.scale;
			this._lastTime=tNow;
			var tTween;
			if (this._tweenDataList.length !=0 && this._index < this._tweenDataList.length){
				var tTweenData=this._tweenDataList[this._index];
				if (tCurrTime >=tTweenData.startTime){
					this._index++;
					if (tTweenData.type==0){
						this._gidIndex++;
						tTween=Pool.getItemByClass("tween",Tween);
						tTween._create(tTweenData.target,tTweenData.data,tTweenData.duration,tTweenData.ease,new Handler(this,this._animComplete,[this._gidIndex]),0,false,tTweenData.isTo,true,false);
						tTween.setStartTime(tCurrTime);
						tTween.gid=this._gidIndex;
						this._tweenDic[this._gidIndex]=tTween;
						}else {
						this.event("label",tTweenData.data);
					}
				}
			}
			for (var p in this._tweenDic){
				tTween=this._tweenDic[p];
				tTween._updateEase(tCurrTime);
			}
		}

		/**
		*指定的动画索引处的动画播放完成后，把此动画从列表中删除。
		*@param index
		*/
		__proto._animComplete=function(index){
			var tTween=this._tweenDic[index];
			if (tTween)delete this._tweenDic[index];
		}

		/**@private */
		__proto._complete=function(){
			this.event("complete");
		}

		/**
		*重置所有对象，复用对象的时候使用。
		*/
		__proto.reset=function(){
			var p;
			if (this._labelDic){
				for (p in this._labelDic){
					delete this._labelDic[p];
				}
			};
			var tTween;
			for (p in this._tweenDic){
				tTween=this._tweenDic[p];
				tTween.clear();
				delete this._tweenDic[p];
			}
			for (p in this._firstTweenDic){
				delete this._firstTweenDic[p];
			}
			this._endTweenDataList=null;
			this._tweenDataList.length=0;
			this._currTime=0;
			this._lastTime=0;
			this._startTime=0;
			this._index=0;
			this._gidIndex=0;
			this.scale=1;
			Laya.timer.clear(this,this._update);
		}

		/**
		*彻底销毁此对象。
		*/
		__proto.destroy=function(){
			this.reset();
			this._labelDic=null;
			this._tweenDic=null;
			this._tweenDataList=null;
			this._firstTweenDic=null;
		}

		/**
		*@private
		*设置帧索引
		*/
		/**
		*@private
		*得到帧索引
		*/
		__getset(0,__proto,'index',function(){
			return this._frameIndex;
			},function(value){
			this._frameIndex=value;
			this.gotoTime(this._frameIndex / this._frameRate *1000);
		});

		/**
		*得到总帧数据
		*/
		__getset(0,__proto,'total',function(){
			this._total=Math.floor(this._startTime / 1000 *this._frameRate);
			return this._total;
		});

		TimeLine.to=function(target,props,duration,ease,offset){
			(offset===void 0)&& (offset=0);
			return (new TimeLine()).to(target,props,duration,ease,offset);
		}

		TimeLine.from=function(target,props,duration,ease,offset){
			(offset===void 0)&& (offset=0);
			return (new TimeLine()).from(target,props,duration,ease,offset);
		}

		TimeLine.__init$=function(){
			//class tweenData
			tweenData=(function(){
				function tweenData(){
					this.type=0;
					this.isTo=true;
					this.startTime=NaN;
					this.endTime=NaN;
					this.target=null;
					this.duration=NaN;
					this.ease=null;
					this.data=null;
				}
				__class(tweenData,'');
				return tweenData;
			})()
		}

		return TimeLine;
	})(EventDispatcher)


	/**
	*<code>AutoBitmap</code> 类是用于表示位图图像或绘制图形的显示对象。
	*<p>封装了位置，宽高及九宫格的处理，供UI组件使用。</p>
	*/
	//class laya.ui.AutoBitmap extends laya.display.Graphics
	var AutoBitmap=(function(_super){
		function AutoBitmap(){
			this.autoCacheCmd=true;
			this._width=0;
			this._height=0;
			this._source=null;
			this._sizeGrid=null;
			this._isChanged=false;
			this._offset=null;
			AutoBitmap.__super.call(this);
		}

		__class(AutoBitmap,'laya.ui.AutoBitmap',_super);
		var __proto=AutoBitmap.prototype;
		/**@inheritDoc */
		__proto.destroy=function(){
			_super.prototype.destroy.call(this);
			this._source=null;
			this._sizeGrid=null;
			this._offset=null;
		}

		/**@private */
		__proto._setChanged=function(){
			if (!this._isChanged){
				this._isChanged=true;
				Laya.timer.callLater(this,this.changeSource);
			}
		}

		/**
		*@private
		*修改纹理资源。
		*/
		__proto.changeSource=function(){
			if (AutoBitmap.cacheCount++> 50)AutoBitmap.clearCache();
			this._isChanged=false;
			var source=this._source;
			if (!source || !source.bitmap)return;
			var width=this.width;
			var height=this.height;
			var sizeGrid=this._sizeGrid;
			var sw=source.sourceWidth;
			var sh=source.sourceHeight;
			if (!sizeGrid || (sw===width && sh===height)){
				this.cleanByTexture(source,this._offset ? this._offset[0] :0,this._offset ? this._offset[1] :0,width,height);
				}else {
				source.$_GID || (source.$_GID=Utils.getGID());
				var key=source.$_GID+"."+width+"."+height+"."+sizeGrid.join(".");
				if (AutoBitmap.cmdCaches[key]){
					this.cmds=AutoBitmap.cmdCaches[key];
					return;
				}
				this.clear();
				var top=sizeGrid[0];
				var right=sizeGrid[1];
				var bottom=sizeGrid[2];
				var left=sizeGrid[3];
				var repeat=sizeGrid[4];
				if (left+right > width){
					right=0;
				}
				left && top && this.drawTexture(AutoBitmap.getTexture(source,0,0,left,top),0,0,left,top);
				right && top && this.drawTexture(AutoBitmap.getTexture(source,sw-right,0,right,top),width-right,0,right,top);
				left && bottom && this.drawTexture(AutoBitmap.getTexture(source,0,sh-bottom,left,bottom),0,height-bottom,left,bottom);
				right && bottom && this.drawTexture(AutoBitmap.getTexture(source,sw-right,sh-bottom,right,bottom),width-right,height-bottom,right,bottom);
				top && this.drawBitmap(repeat,AutoBitmap.getTexture(source,left,0,sw-left-right,top),left,0,width-left-right,top);
				bottom && this.drawBitmap(repeat,AutoBitmap.getTexture(source,left,sh-bottom,sw-left-right,bottom),left,height-bottom,width-left-right,bottom);
				left && this.drawBitmap(repeat,AutoBitmap.getTexture(source,0,top,left,sh-top-bottom),0,top,left,height-top-bottom);
				right && this.drawBitmap(repeat,AutoBitmap.getTexture(source,sw-right,top,right,sh-top-bottom),width-right,top,right,height-top-bottom);
				this.drawBitmap(repeat,AutoBitmap.getTexture(source,left,top,sw-left-right,sh-top-bottom),left,top,width-left-right,height-top-bottom);
				if (this.autoCacheCmd && !Render.isConchApp)AutoBitmap.cmdCaches[key]=this.cmds;
			}
			this._repaint();
		}

		__proto.drawBitmap=function(repeat,tex,x,y,width,height){
			(width===void 0)&& (width=0);
			(height===void 0)&& (height=0);
			if (repeat)this.fillTexture(tex,x,y,width,height);
			else this.drawTexture(tex,x,y,width,height);
		}

		/**
		*当前实例的有效缩放网格数据。
		*<p>如果设置为null,则在应用任何缩放转换时，将正常缩放整个显示对象。</p>
		*<p>数据格式：[上边距,右边距,下边距,左边距,是否重复填充(值为0：不重复填充，1：重复填充)]。
		*<ul><li>例如：[4,4,4,4,1]</li></ul></p>
		*<p> <code>sizeGrid</code> 的值如下所示：
		*<ol>
		*<li>上边距</li>
		*<li>右边距</li>
		*<li>下边距</li>
		*<li>左边距</li>
		*<li>是否重复填充(值为0：不重复填充，1：重复填充)</li>
		*</ol></p>
		*<p>当定义 <code>sizeGrid</code> 属性时，该显示对象被分割到以 <code>sizeGrid</code> 数据中的"上边距,右边距,下边距,左边距" 组成的矩形为基础的具有九个区域的网格中，该矩形定义网格的中心区域。网格的其它八个区域如下所示：
		*<ul>
		*<li>矩形上方的区域</li>
		*<li>矩形外的右上角</li>
		*<li>矩形左侧的区域</li>
		*<li>矩形右侧的区域</li>
		*<li>矩形外的左下角</li>
		*<li>矩形下方的区域</li>
		*<li>矩形外的右下角</li>
		*<li>矩形外的左上角</li>
		*</ul>
		*同时也支持3宫格，比如0,4,0,4,1为水平3宫格，4,0,4,0,1为垂直3宫格，3宫格性能比9宫格高。
		*</p>
		*/
		__getset(0,__proto,'sizeGrid',function(){
			return this._sizeGrid;
			},function(value){
			this._sizeGrid=value;
			this._setChanged();
		});

		/**
		*表示显示对象的宽度，以像素为单位。
		*/
		__getset(0,__proto,'width',function(){
			if (this._width)return this._width;
			if (this._source)return this._source.sourceWidth;
			return 0;
			},function(value){
			if (this._width !=value){
				this._width=value;
				this._setChanged();
			}
		});

		/**
		*表示显示对象的高度，以像素为单位。
		*/
		__getset(0,__proto,'height',function(){
			if (this._height)return this._height;
			if (this._source)return this._source.sourceHeight;
			return 0;
			},function(value){
			if (this._height !=value){
				this._height=value;
				this._setChanged();
			}
		});

		/**
		*对象的纹理资源。
		*@see laya.resource.Texture
		*/
		__getset(0,__proto,'source',function(){
			return this._source;
			},function(value){
			if (value){
				this._source=value
				this._setChanged();
				}else {
				this._source=null;
				this.clear();
			}
		});

		AutoBitmap.getTexture=function(tex,x,y,width,height){
			if (width <=0)width=1;
			if (height <=0)height=1;
			tex.$_GID || (tex.$_GID=Utils.getGID())
			var key=tex.$_GID+"."+x+"."+y+"."+width+"."+height;
			var texture=AutoBitmap.textureCache[key];
			if (!texture){
				texture=AutoBitmap.textureCache[key]=Texture.createFromTexture(tex,x,y,width,height);
			}
			return texture;
		}

		AutoBitmap.clearCache=function(){
			AutoBitmap.cacheCount=0;
			AutoBitmap.cmdCaches={};
			AutoBitmap.textureCache={};
		}

		AutoBitmap.setCache=function(key,value){
			AutoBitmap.cacheCount++;
			AutoBitmap.textureCache[key]=value;
		}

		AutoBitmap.getCache=function(key){
			return AutoBitmap.textureCache[key];
		}

		AutoBitmap.cmdCaches={};
		AutoBitmap.cacheCount=0;
		AutoBitmap.textureCache={};
		return AutoBitmap;
	})(Graphics)


	/**
	*<code>UIEvent</code> 类用来定义UI组件类的事件类型。
	*/
	//class laya.ui.UIEvent extends laya.events.Event
	var UIEvent=(function(_super){
		function UIEvent(){UIEvent.__super.call(this);;
		};

		__class(UIEvent,'laya.ui.UIEvent',_super);
		UIEvent.SHOW_TIP="showtip";
		UIEvent.HIDE_TIP="hidetip";
		return UIEvent;
	})(Event)


	/**
	*本类用于模块间消息传递
	*@author ww
	*/
	//class laya.debug.tools.Notice extends laya.events.EventDispatcher
	var Notice=(function(_super){
		function Notice(){
			Notice.__super.call(this);
		}

		__class(Notice,'laya.debug.tools.Notice',_super);
		Notice.notify=function(type,data){
			Notice.I.event(type,data);
		}

		Notice.listen=function(type,_scope,fun,args,cancelBefore){
			(cancelBefore===void 0)&& (cancelBefore=false);
			if(cancelBefore)Notice.cancel(type,_scope,fun);
			Notice.I.on(type,_scope,fun,args);
		}

		Notice.cancel=function(type,_scope,fun){
			Notice.I.off(type,_scope,fun);
		}

		__static(Notice,
		['I',function(){return this.I=new Notice();}
		]);
		return Notice;
	})(EventDispatcher)


	/**拖动事件类*/
	//class laya.editor.core.events.DragEvent extends laya.events.Event
	var DragEvent=(function(_super){
		function DragEvent(type,dragInitiator,data,bubbles,cancelable){
			this._data=null;
			this._dragInitiator=null;
			this.hitList=null;
			DragEvent.__super.call(this);
			(bubbles===void 0)&& (bubbles=true);
			(cancelable===void 0)&& (cancelable=false);
			this.type=type;
			this._dragInitiator=dragInitiator;
			this._data=data;
		}

		__class(DragEvent,'laya.editor.core.events.DragEvent',_super);
		var __proto=DragEvent.prototype;
		__proto.clone=function(){
			return new DragEvent(this.type,this._dragInitiator,this._data);
		}

		/**拖动的源对象*/
		__getset(0,__proto,'dragInitiator',function(){
			return this._dragInitiator;
			},function(value){
			this._dragInitiator=value;
		});

		/**拖动传递的数据*/
		__getset(0,__proto,'data',function(){
			return this._data;
			},function(value){
			this._data=value;
		});

		DragEvent.getMutiDragFiles=function(e){
			var data=e.data;
			if(data.type!="multiResFile"&&data.type!="resDir"){
				return null;
			};
			var src=e.dragInitiator;
			var fileList;
			fileList=data.fileList;
			if(data.type=="resDir"){
				fileList=FileTools.getFileList(data.asset);
			};
			var i=0,len=0;
			len=fileList.length;
			var files;
			files=[];
			for(i=0;i<len;i++){
				var path;
				path=fileList[i];
				if(FileTools.isDirectory(path))continue ;
				path=FileManager.getRelativePath(SystemSetting.assetsPath,path);
				path=FileManager.adptToCommonUrl(path);
				files.push(path);
			}
			files.sort();
			return files;
		}

		DragEvent.DRAG_START="dragStart";
		DragEvent.DRAG_DROP="dragDrop";
		DragEvent.Draging_Hit="Draging_Hit";
		DragEvent.DRAG_COMPLETE="dragComplete";
		DragEvent.DRAG_MOVE="dragMove";
		DragEvent.Res="res";
		DragEvent.ResDir="resDir";
		DragEvent.Props="Props";
		DragEvent.MULTI_RESFILE="multiResFile";
		DragEvent.DisplayDrag="displayDrag";
		DragEvent.SystemDrag="SystemDrag";
		DragEvent.Page="page";
		DragEvent.PageDir="pageDir";
		DragEvent.MULTI_PAGEFILE="multiPageFile";
		__static(DragEvent,
		['TEMP',function(){return this.TEMP=new DragEvent("dragDrop");}
		]);
		return DragEvent;
	})(Event)


	/**UI事件类*/
	//class laya.editor.core.events.UIEvent extends laya.events.Event
	var UIEvent1=(function(_super){
		function UIEvent(type,data,bubbles,cancelable){
			this._data=null;
			UIEvent.__super.call(this);
			(bubbles===void 0)&& (bubbles=false);
			(cancelable===void 0)&& (cancelable=false);
			this.type=type;
			this._data=data;
		}

		__class(UIEvent,'laya.editor.core.events.UIEvent',_super,'UIEvent1');
		var __proto=UIEvent.prototype;
		__proto.clone=function(){
			return new UIEvent(this.type,this._data);
		}

		/**事件数据*/
		__getset(0,__proto,'data',function(){
			return this._data;
			},function(value){
			this._data=value;
		});

		UIEvent.MOVE="move";
		UIEvent.RENDER_COMPLETED="renderCompleted";
		UIEvent.SHOW_TIP="showTip";
		UIEvent.HIDE_TIP="hideTip";
		UIEvent.IMAGE_LOADED="imageLoaded";
		UIEvent.SCROLL="scroll";
		UIEvent.FRAME_CHANGED="frameChanged";
		UIEvent.ITEM_RENDER="listRender";
		UIEvent.CHANGING="changing";
		return UIEvent;
	})(Event)


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-9-2 上午9:51:29
	*/
	//class as3analyser.parser.struct.DefineAndBody extends as3analyser.parser.struct.CodePiece
	var DefineAndBody=(function(_super){
		function DefineAndBody(){
			this.keyWord="DefineAndBody";
			this.defineNoBody=null;
			this.defineLine=null;
			this.body=null;
			this.bodyLines=null;
			DefineAndBody.__super.call(this);
		}

		__class(DefineAndBody,'as3analyser.parser.struct.DefineAndBody',_super);
		var __proto=DefineAndBody.prototype;
		__proto.dealDifineStr=function(defineStr){
			var i=0;
			i=defineStr.indexOf("{");
			if(i>=0){
				this.defineNoBody=defineStr.substring(0,i);
				this.lines.shift();
				var lineItem;
				lineItem=new LineItem();
				lineItem.lineIndex=0;
				lineItem.lineStr="{";
				this.lines.unshift(lineItem);
				}else{
				this.defineNoBody=defineStr;
			}
		}

		__proto.parseInfo=function(defineLine){
			defineLine=defineLine;
			this.dealDifineStr(defineLine.lineStr);
			this.parseMyInfo();
		}

		__proto.parseMyInfo=function(){}
		__proto.build=function(){
			this.code=this.defineNoBody+"\n{\n"+this.body.getCode()+"\n}";
		}

		DefineAndBody.findBodyLines=function(lineCount,lines){
			var pairs;
			var tPos;
			tPos=new PosItem();
			tPos.line=lineCount;
			pairs=StringTool1.findPair("{","}",tPos,lines);
			if(pairs){
				return pairs[pairs.length-1].line;
				}else{
				return-1;
			}
		}

		DefineAndBody.test=function(lineCount,lines,testFun){
			var tLine;
			tLine=lines[lineCount];
			var rst=0;
			rst=-1;
			if(testFun(tLine.lineStr,lineCount,lines)){
				rst=DefineAndBody.findBodyLines(lineCount,lines);
			}
			return rst;
		}

		return DefineAndBody;
	})(CodePiece)


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-9-2 上午9:31:02
	*/
	//class as3analyser.parser.struct.CodeBlock extends as3analyser.parser.struct.CodePiece
	var CodeBlock=(function(_super){
		function CodeBlock(){
			this.varLines=null;
			this.funName=null;
			this.BlockCodeT=
			""+
			"var _$this:*=this;"+"\n"+
			"{varDefines}"+"\n"+
			"var _SyNrTn_:*,__$:Function=function (__line:int):*"+""+
			"{"+"\n"+
			"{codeBlock}"+"\n"+
			"};"+"\n"+
			"__$(0);";
			CodeBlock.__super.call(this);
		}

		__class(CodeBlock,'as3analyser.parser.struct.CodeBlock',_super);
		var __proto=CodeBlock.prototype;
		__proto.build=function(){
			var i=0;
			var len=0;
			var tLineItem;
			var tCodes;
			len=this.varLines.length;
			tCodes=[];
			for(i=0;i<len;i++){
				tLineItem=this.varLines[i];
				tCodes.push(tLineItem.lineStr);
			}
			this.code=StringTool1.getReplace(this.BlockCodeT,"{varDefines}",tCodes.join("\n"));
			this.code=StringTool1.getReplace(this.code,"{codeBlock}",tCodes.join("\n"));
		}

		__proto.getVarDefines=function(){
			var i=0;
			var len=0;
			len=this.lines.length;
			var tLineItem;
			this.varLines=[];
			for(i=len-1;i>=0;i--){
				tLineItem=this.lines[i];
				if(tLineItem.lineStr.indexOf("var ")>=0){
					var cLines;
					cLines=VarParser.parseValueLine(tLineItem);
					this.varLines=this.varLines.concat(cLines[0]);
					tLineItem.lineType="var";
				}
			}
		}

		// lines=ArrayTool.insertArr(lines,cLines[1],i);
		__proto.parseFunctionBody=function(){
			this.getVarDefines();
		}

		CodeBlock.createByLines=function(lines,funName,codeT){
			var rst;
			rst=new CodeBlock();
			if(codeT){
				rst.BlockCodeT=codeT;
			}
			rst.setLines(lines);
			rst.funName=funName;
			rst.parseFunctionBody();
			rst.build();
			return rst;
		}

		return CodeBlock;
	})(CodePiece)


	/**
	*本类用于模块间消息传递
	*@author ww
	*/
	//class ide.managers.Notice extends laya.events.EventDispatcher
	var Notice1=(function(_super){
		function Notice(){
			Notice.__super.call(this);
		}

		__class(Notice,'ide.managers.Notice',_super,'Notice1');
		Notice.notify=function(type,data){
			Notice.I.event(type,data);
		}

		Notice.listen=function(type,_scope,fun,args,cancelBefore){
			(cancelBefore===void 0)&& (cancelBefore=false);
			if(cancelBefore)Notice.cancel(type,_scope,fun);
			Notice.I.on(type,_scope,fun,args);
		}

		Notice.cancel=function(type,_scope,fun){
			Notice.I.off(type,_scope,fun);
		}

		__static(Notice,
		['I',function(){return this.I=new Notice();}
		]);
		return Notice;
	})(EventDispatcher)


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-3-22 下午7:18:25
	*/
	//class laya.ide.viewer.CodeScene extends laya.ide.viewer.SceneBase
	var CodeScene=(function(_super){
		function CodeScene(){
			CodeScene.__super.call(this);
		}

		__class(CodeScene,'laya.ide.viewer.CodeScene',_super);
		var __proto=CodeScene.prototype;
		__proto.setUp=function(parent){
			CodeViewManager.I.show();
			CodeViewManager.openFile(this.pagePath);
		}

		__proto.removeSelf=function(){
			_super.prototype.removeSelf.call(this);
			CodeViewManager.I.hide();
		}

		// trace("codeScene init");
		__getset(0,__proto,'pagePath',_super.prototype._$get_pagePath,function(path){
			_super.prototype._$set_pagePath.call(this,path);
		});

		return CodeScene;
	})(SceneBase)


	/**
	*粒子编辑页面
	*@author ww
	*@version 1.0
	*
	*@created 2015-10-21 下午7:51:20
	*/
	//class laya.ide.viewer.ParticleScene extends laya.ide.viewer.SceneBase
	var ParticleScene=(function(_super){
		function ParticleScene(){
			this.mType=null;
			ParticleScene.__super.call(this);
			this.mType=ParticleScene.ParticleType;
		}

		__class(ParticleScene,'laya.ide.viewer.ParticleScene',_super);
		var __proto=ParticleScene.prototype;
		__proto.setUp=function(parent){
			this.addRenderFrame();
		}

		__proto.open=function(){
			_super.prototype.open.call(this);
			DialogTools.showOpenFile("打开粒子文件",Utils.bind(this.openFile,this),DialogTools.getOpenParticleO());
		}

		__proto.openFile=function(file){
			if(file){
				var jsonStr=FileTools.readFile(file[0]);
				var data=ObjectTools.getObj(jsonStr);
				ViewRenderManager.render.setData(data);
				var particleData;
				particleData=ObjectTools.flatObj(data);
				Notice1.notify("PropPanel_setByObj",[particleData,this.mType]);
			}
		}

		// trace("configJson:",ObjectTools.getJsonString(data));
		__proto.save=function(){
			_super.prototype.save.call(this);
			if (this.pagePath){
				this.saveFile(this.pagePath);
				}else{
				DialogTools.showSave("保存粒子配置文件","particle.json",Utils.bind(this.saveFile,this));
			}
		}

		__proto.onResClick=function(data){}
		//ViewRenderManager.render.updateData(updateData);
		__proto.renderDragDrop=function(e){
			_super.prototype.renderDragDrop.call(this,e);
			if(e.data&&e.data.type=="res"){
				if(!e.data.asset||e.data.asset=="")return;
				if(ResFileManager.isResFile(e.data.asset))
					this.changeValue("textureName",FileManager.getRelativePath(SystemSetting.assetsPath,e.data.asset));
			}
		}

		__proto.propChange=function(key,data){
			_super.prototype.propChange.call(this,key,data);
			this.particleValueChange(key,data)
		}

		__proto.changeTextureByPath=function(path){
			var updateData;
			updateData={};
			updateData.type="texture";
			updateData.url=path;
			ViewRenderManager.render.updateData(updateData);
		}

		__proto.saveFile=function(file){
			if(file){
				var data=ViewRenderManager.render.getRenderData();
				var fileStr;
				fileStr=ObjectTools.getJsonString(data);
				try{
					var obj=ObjectTools.getObj(fileStr);
					if(!obj.textureName){
						Alert.show("保存粒子文件出错");
						return;
					}
					}catch(e){
					Alert.show("保存粒子文件出错");
					return;
				}
				FileTools.createFile(file,ObjectTools.getJsonString(data));
				MessageManager.instance.show("保存成功");
				this._changed=false;
				StateManager.setChangeState(this.pagePath,false);
				Laya.stage.event("pageSaved");
				Laya.stage.event("pageChanged");
			}
		}

		__proto.addRenderFrame=function(){
			var renderPath;
			var type;
			type=TypeManager.getFileType(this.pagePath);
			switch(type){
				case "particle3D":
					renderPath="renders/particle3d/editor.max.html";
					break ;
				case "particlepoly":
					renderPath="renders/particlepoly/editor.max.html";
					break ;
				default :
					renderPath="renders/particle/editor.max.html";
				}
			ViewRenderManager.setRender(renderPath);
			this.show();
			ViewRenderManager.eDispatcher.once("complete",this,this.initParticleEditor);
		}

		//changeTest();
		__proto.initParticleEditor=function(){
			this._changed=false;
			var data;
			if(this.pagePath){
				if(StateManager.has(this.pagePath)){
					data=StateManager.getState(this.pagePath).now();
					}else{
					try{
						var jsonStr=FileTools.readFile(this.pagePath);
						data=ObjectTools.getObj(jsonStr);
						StateManager.updateState(this.pagePath,data);
						}catch(e){
						Alert.show("读取粒子数据出错，请查看粒子文件是否已损坏");
						return;
					}
				}
				if(TypeManager.getFileType(this.pagePath)=="particlepoly"){
					this.mType=ParticleScene.ParticlePolyType;
				}
				}else{
				data=ViewRenderManager.render.getRenderData();
			};
			var particleData;
			particleData=ObjectTools.flatObj(data);
			Notice1.notify("PropPanel_setByObj",[particleData,this.mType]);
			try{
				this.renderByData(data);
			}
			catch(e){}
		}

		__proto.renderByData=function(data){
			var updateData;
			updateData={};
			updateData.type="init";
			updateData.url=FileTools.getAbsPath(this.pagePath);
			updateData.base=FileTools.getAbsPath(SystemSetting.assetsPath+FileTools.getSep());
			updateData.data=data;
			ViewRenderManager.render.getStage()["bgColor"]=data.backColor;
			ViewRenderManager.render.updateData(updateData);
		}

		// Notice.notify(IDEEvent.SHOW_DISPLAY_TREE,[ViewRenderManager.render.getStage()]);
		__proto.goBack=function(){
			_super.prototype.goBack.call(this);
			var data=StateManager.getState(this.pagePath).back();
			if(!data){
				console.log("当前不可回退");
				return;
			};
			var particleData;
			particleData=ObjectTools.flatObj(data);
			Notice1.notify("PropPanel_setByObj",[particleData,this.mType]);
			this.setRenderData(data);
		}

		__proto.goForward=function(){
			_super.prototype.goForward.call(this);
			var data=StateManager.getState(this.pagePath).forward();
			if(!data){
				console.log("当前不可前进");
				return;
			};
			var particleData;
			particleData=ObjectTools.flatObj(data);
			Notice1.notify("PropPanel_setByObj",[particleData,this.mType]);
			this.setRenderData(data);
		}

		__proto.changeValue=function(key,value){
			var data=ViewRenderManager.render.getRenderData();
			if(data.hasOwnProperty(key)){
				ObjectTools.setKeyValue(data,key,value);
			};
			var particleData;
			particleData=ObjectTools.flatObj(data);
			Notice1.notify("PropPanel_setByObj",[particleData,this.mType]);
			this.particleValueChange(key,value);
		}

		__proto.particleValueChange=function(key,value){
			var data=ViewRenderManager.render.getRenderData();
			if (key=="textureFileName"){
				ObjectTools.setKeyValue(data,key,value);
				this.changeTextureByPath(value);
				this._changed=true;
				StateManager.updateState(this.pagePath,data);
				Laya.stage.event("pageChanged");
				return;
				}else{
				ObjectTools.setKeyValue(data,key,ObjectTools.getAutoValue(value));
				StateManager.updateState(this.pagePath,data);
			}
			this.setRenderData(data);
			Notice1.notify("PropPanel_setByObj",[data,this.mType]);
		}

		__proto.setRenderData=function(data){
			this.renderByData(data);
			this._changed=true;
			StateManager.setChangeState(this.pagePath,true);
			Laya.stage.event("pageChanged");
		}

		__getset(0,__proto,'hasChange',function(){
			return StateManager.hasChange(this.pagePath);
		});

		ParticleScene.ParticleType="Particle";
		ParticleScene.ParticlePolyType="PolyEmitter";
		return ParticleScene;
	})(SceneBase)


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-2-23 上午11:06:53
	*/
	//class laya.ide.viewer.SceneEditorScene extends laya.ide.viewer.SceneBase
	var SceneEditorScene=(function(_super){
		function SceneEditorScene(){
			this._parent=null;
			this._ui=null;
			SceneEditorScene.__super.call(this);
		}

		__class(SceneEditorScene,'laya.ide.viewer.SceneEditorScene',_super);
		var __proto=SceneEditorScene.prototype;
		__proto.setUp=function(parent){
			_super.prototype.setUp.call(this);
			this._parent=parent;
			this.createUI();
		}

		__proto.createUI=function(){
			this._ui=new Sprite();
			var txt=new Text();
			txt.text="我是场景编辑器";
			txt.pos(100,100);
			txt.color="#ff0000";
			this._ui.addChild(txt);
			if(this._ui){
				this._ui["top"]=0;
				this._ui["left"]=0;
			}
		}

		//_ui["right"]=0;
		__proto.removeSelf=function(){
			_super.prototype.removeSelf.call(this);
			if(this._ui)this._ui.removeSelf();
		}

		__proto.show=function(){
			if(this._parent&&this._ui){
				this._parent.addChild(this._ui);
			}
		}

		return SceneEditorScene;
	})(SceneBase)


	/**
	*显示对象页
	*@author ww
	*@version 1.0
	*
	*@created 2015-11-28 上午10:36:33
	*/
	//class laya.ide.viewer.UIPageScene extends laya.ide.viewer.SceneBase
	var UIPageScene=(function(_super){
		function UIPageScene(){
			this._parent=null;
			this._ui=null;
			UIPageScene.__super.call(this);
		}

		__class(UIPageScene,'laya.ide.viewer.UIPageScene',_super);
		var __proto=UIPageScene.prototype;
		__proto.setUp=function(parent){
			_super.prototype.setUp.call(this);
			this._parent=parent;
			this._ui=this.data;
			if(this._ui){
				this._ui["top"]=0;
				this._ui["left"]=0;
			}
		}

		//_ui["right"]=0;
		__proto.removeSelf=function(){
			_super.prototype.removeSelf.call(this);
			if(this._ui)this._ui.removeSelf();
		}

		__proto.show=function(){
			if(this._parent&&this._ui){
				this._parent.addChild(this._ui);
			}
		}

		return UIPageScene;
	})(SceneBase)


	/**
	*iFrame页
	*@author ww
	*@version 1.0
	*
	*@created 2015-11-27 下午7:55:01
	*/
	//class laya.ide.viewer.WebPageScene extends laya.ide.viewer.SceneBase
	var WebPageScene=(function(_super){
		function WebPageScene(){
			WebPageScene.__super.call(this);
		}

		__class(WebPageScene,'laya.ide.viewer.WebPageScene',_super);
		var __proto=WebPageScene.prototype;
		__proto.setUp=function(parent){
			_super.prototype.setUp.call(this);
			this.addRenderFrame();
		}

		__proto.addRenderFrame=function(){
			ViewRenderManager.setRender(this.pagePath);
			ViewRenderManager.show();
			ViewRenderManager.eDispatcher.once("complete",this,this.initWebScene);
		}

		//changeTest();
		__proto.initWebScene=function(){}
		return WebPageScene;
	})(SceneBase)


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-9-18 下午5:52:36
	*/
	//class laya.ide.viewer.XmlEditorScene extends laya.ide.viewer.SceneBase
	var XmlEditorScene=(function(_super){
		function XmlEditorScene(){
			this._parent=null;
			this._ui=null;
			this.iFrameCodeView=null;
			this._preCode=null;
			this._oldCode=null;
			XmlEditorScene.__super.call(this);
			this.iFrameCodeView=new XMLEditorSprite();
			this.iFrameCodeView.top=this.iFrameCodeView.bottom=this.iFrameCodeView.left=0;
			this.iFrameCodeView.right=0;
			this.iFrameCodeView.bottom=0;
			this.iFrameCodeView.on("txtchange",this,this.txtChange);
			this.iFrameCodeView.on("editorsave",this,this.save);
		}

		__class(XmlEditorScene,'laya.ide.viewer.XmlEditorScene',_super);
		var __proto=XmlEditorScene.prototype;
		__proto.setUp=function(parent){
			_super.prototype.setUp.call(this);
			this._parent=parent;
			this._ui=new Box();
			this._ui.addChild(this.iFrameCodeView);
			this._ui.on("mousedown",this,this.mouseDownW);
			if(this._ui){
				this._ui["top"]=0;
				this._ui["bottom"]=0;
				this._ui["left"]=0;
				this._ui["right"]=0;
			}
		}

		__proto.txtChange=function(){
			this._changed=(this._oldCode!=this.iFrameCodeView.getCode());
			Laya.stage.event("pageChanged");
		}

		__proto.mouseDownW=function(){}
		__proto.removeSelf=function(){
			_super.prototype.removeSelf.call(this);
			if(this._ui)this._ui.removeSelf();
			if(this.iFrameCodeView){
				this._preCode=this.iFrameCodeView.getCode();
			}
		}

		__proto.show=function(){
			if(this._parent&&this._ui){
				this._parent.addChild(this._ui);
				if(this._preCode){
					this.iFrameCodeView.setCode(this._preCode);
				}
			}
		}

		__proto.save=function(){
			_super.prototype.save.call(this);
			this._oldCode=this.iFrameCodeView.getCode();
			FileManager.createTxtFile(this.pagePath,this._oldCode);
			this._changed=false;
			Laya.stage.event("pageChanged");
			if(TypeManager.getFileType(this.pagePath)=="Script"){
				var sPath;
				sPath=FileManager.getWorkRelativePath(this.pagePath);
				if(AppendPropGroupTool.isScriptInit(sPath)){
					PropPanel.instance.clearPanelCache(AppendPropGroupTool.getScriptName(sPath));
					AppendPropGroupTool.clearScript(sPath);
				}
			}
		}

		__getset(0,__proto,'pagePath',_super.prototype._$get_pagePath,function(path){
			_super.prototype._$set_pagePath.call(this,path);
			var txt=FileManager.readTxtFile(path);
			this._oldCode=txt;
			this.iFrameCodeView.setCode(txt);
		});

		return XmlEditorScene;
	})(SceneBase)


	/**
	*<p> <code>Sprite</code> 类是基本显示列表构造块：一个可显示图形并且也可包含子项的显示列表节点。</p>
	*
	*@example 以下示例代码，创建了一个 <code>Text</code> 实例。
	*<listing version="3.0">
	*package
	*{
		*import laya.display.Sprite;
		*import laya.events.Event;
		*
		*public class Sprite_Example
		*{
			*private var sprite:Sprite;
			*private var shape:Sprite
			*public function Sprite_Example()
			*{
				*Laya.init(640,800);//设置游戏画布宽高、渲染模式。
				*Laya.stage.bgColor="#efefef";//设置画布的背景颜色。
				*onInit();
				*}
			*private function onInit():void
			*{
				*sprite=new Sprite();//创建一个 Sprite 类的实例对象 sprite 。
				*sprite.loadImage("resource/ui/bg.png");//加载并显示图片。
				*sprite.x=200;//设置 sprite 对象相对于父容器的水平方向坐标值。
				*sprite.y=200;//设置 sprite 对象相对于父容器的垂直方向坐标值。
				*sprite.pivotX=0;//设置 sprite 对象的水平方法轴心点坐标。
				*sprite.pivotY=0;//设置 sprite 对象的垂直方法轴心点坐标。
				*Laya.stage.addChild(sprite);//将此 sprite 对象添加到显示列表。
				*sprite.on(Event.CLICK,this,onClickSprite);//给 sprite 对象添加点击事件侦听。
				*shape=new Sprite();//创建一个 Sprite 类的实例对象 sprite 。
				*shape.graphics.drawRect(0,0,100,100,"#ccff00","#ff0000",2);//绘制一个有边框的填充矩形。
				*shape.x=400;//设置 shape 对象相对于父容器的水平方向坐标值。
				*shape.y=200;//设置 shape 对象相对于父容器的垂直方向坐标值。
				*shape.width=100;//设置 shape 对象的宽度。
				*shape.height=100;//设置 shape 对象的高度。
				*shape.pivotX=50;//设置 shape 对象的水平方法轴心点坐标。
				*shape.pivotY=50;//设置 shape 对象的垂直方法轴心点坐标。
				*Laya.stage.addChild(shape);//将此 shape 对象添加到显示列表。
				*shape.on(Event.CLICK,this,onClickShape);//给 shape 对象添加点击事件侦听。
				*}
			*private function onClickSprite():void
			*{
				*trace("点击 sprite 对象。");
				*sprite.rotation+=5;//旋转 sprite 对象。
				*}
			*private function onClickShape():void
			*{
				*trace("点击 shape 对象。");
				*shape.rotation+=5;//旋转 shape 对象。
				*}
			*}
		*}
	*</listing>
	*<listing version="3.0">
	*var sprite;
	*var shape;
	*Sprite_Example();
	*function Sprite_Example()
	*{
		*Laya.init(640,800);//设置游戏画布宽高、渲染模式。
		*Laya.stage.bgColor="#efefef";//设置画布的背景颜色。
		*onInit();
		*}
	*function onInit()
	*{
		*sprite=new laya.display.Sprite();//创建一个 Sprite 类的实例对象 sprite 。
		*sprite.loadImage("resource/ui/bg.png");//加载并显示图片。
		*sprite.x=200;//设置 sprite 对象相对于父容器的水平方向坐标值。
		*sprite.y=200;//设置 sprite 对象相对于父容器的垂直方向坐标值。
		*sprite.pivotX=0;//设置 sprite 对象的水平方法轴心点坐标。
		*sprite.pivotY=0;//设置 sprite 对象的垂直方法轴心点坐标。
		*Laya.stage.addChild(sprite);//将此 sprite 对象添加到显示列表。
		*sprite.on(Event.CLICK,this,onClickSprite);//给 sprite 对象添加点击事件侦听。
		*shape=new laya.display.Sprite();//创建一个 Sprite 类的实例对象 sprite 。
		*shape.graphics.drawRect(0,0,100,100,"#ccff00","#ff0000",2);//绘制一个有边框的填充矩形。
		*shape.x=400;//设置 shape 对象相对于父容器的水平方向坐标值。
		*shape.y=200;//设置 shape 对象相对于父容器的垂直方向坐标值。
		*shape.width=100;//设置 shape 对象的宽度。
		*shape.height=100;//设置 shape 对象的高度。
		*shape.pivotX=50;//设置 shape 对象的水平方法轴心点坐标。
		*shape.pivotY=50;//设置 shape 对象的垂直方法轴心点坐标。
		*Laya.stage.addChild(shape);//将此 shape 对象添加到显示列表。
		*shape.on(laya.events.Event.CLICK,this,onClickShape);//给 shape 对象添加点击事件侦听。
		*}
	*function onClickSprite()
	*{
		*console.log("点击 sprite 对象。");
		*sprite.rotation+=5;//旋转 sprite 对象。
		*}
	*function onClickShape()
	*{
		*console.log("点击 shape 对象。");
		*shape.rotation+=5;//旋转 shape 对象。
		*}
	*</listing>
	*<listing version="3.0">
	*import Sprite=laya.display.Sprite;
	*class Sprite_Example {
		*private sprite:Sprite;
		*private shape:Sprite
		*public Sprite_Example(){
			*Laya.init(640,800);//设置游戏画布宽高、渲染模式。
			*Laya.stage.bgColor="#efefef";//设置画布的背景颜色。
			*this.onInit();
			*}
		*private onInit():void {
			*this.sprite=new Sprite();//创建一个 Sprite 类的实例对象 sprite 。
			*this.sprite.loadImage("resource/ui/bg.png");//加载并显示图片。
			*this.sprite.x=200;//设置 sprite 对象相对于父容器的水平方向坐标值。
			*this.sprite.y=200;//设置 sprite 对象相对于父容器的垂直方向坐标值。
			*this.sprite.pivotX=0;//设置 sprite 对象的水平方法轴心点坐标。
			*this.sprite.pivotY=0;//设置 sprite 对象的垂直方法轴心点坐标。
			*Laya.stage.addChild(this.sprite);//将此 sprite 对象添加到显示列表。
			*this.sprite.on(laya.events.Event.CLICK,this,this.onClickSprite);//给 sprite 对象添加点击事件侦听。
			*this.shape=new Sprite();//创建一个 Sprite 类的实例对象 sprite 。
			*this.shape.graphics.drawRect(0,0,100,100,"#ccff00","#ff0000",2);//绘制一个有边框的填充矩形。
			*this.shape.x=400;//设置 shape 对象相对于父容器的水平方向坐标值。
			*this.shape.y=200;//设置 shape 对象相对于父容器的垂直方向坐标值。
			*this.shape.width=100;//设置 shape 对象的宽度。
			*this.shape.height=100;//设置 shape 对象的高度。
			*this.shape.pivotX=50;//设置 shape 对象的水平方法轴心点坐标。
			*this.shape.pivotY=50;//设置 shape 对象的垂直方法轴心点坐标。
			*Laya.stage.addChild(this.shape);//将此 shape 对象添加到显示列表。
			*this.shape.on(laya.events.Event.CLICK,this,this.onClickShape);//给 shape 对象添加点击事件侦听。
			*}
		*private onClickSprite():void {
			*console.log("点击 sprite 对象。");
			*this.sprite.rotation+=5;//旋转 sprite 对象。
			*}
		*private onClickShape():void {
			*console.log("点击 shape 对象。");
			*this.shape.rotation+=5;//旋转 shape 对象。
			*}
		*}
	*</listing>
	*/
	//class laya.display.Sprite extends laya.display.Node
	var Sprite=(function(_super){
		function Sprite(){
			this.mouseThrough=false;
			this._transform=null;
			this._tfChanged=false;
			this._x=0;
			this._y=0;
			this._width=0;
			this._height=0;
			this._repaint=1;
			this._changeType=0;
			this._mouseEnableState=0;
			this._zOrder=0;
			this._graphics=null;
			this._renderType=0;
			this.autoSize=false;
			this.hitTestPrior=false;
			this.viewport=null;
			this._optimizeScrollRect=false;
			this._texture=null;
			Sprite.__super.call(this);
			this._style=Style.EMPTY;
		}

		__class(Sprite,'laya.display.Sprite',_super);
		var __proto=Sprite.prototype;
		Laya.imps(__proto,{"laya.display.ILayout":true})
		__proto.createConchModel=function(){
			return new ConchNode();
		}

		/**@inheritDoc */
		__proto.destroy=function(destroyChild){
			(destroyChild===void 0)&& (destroyChild=true);
			_super.prototype.destroy.call(this,destroyChild);
			this._style && this._style.destroy();
			this._transform=null;
			this._style=null;
			this._graphics=null;
		}

		/**根据zOrder进行重新排序。*/
		__proto.updateZOrder=function(){
			Utils.updateOrder(this._childs)&& this.repaint();
		}

		/**在设置cacheAs或staticCache=true的情况下，调用此方法会重新刷新缓存。*/
		__proto.reCache=function(){
			if (this._$P.cacheCanvas)this._$P.cacheCanvas.reCache=true;
		}

		/**
		*设置bounds大小，如果有设置，则不再通过getBounds计算
		*@param bound bounds矩形区域
		*/
		__proto.setBounds=function(bound){
			this._set$P("uBounds",bound);
		}

		/**
		*获取本对象在父容器坐标系的矩形显示区域。
		*<p><b>注意：</b>计算量较大，尽量少用。</p>
		*@return 矩形区域。
		*/
		__proto.getBounds=function(){
			if (!this._$P.mBounds)this._set$P("mBounds",new Rectangle());
			return Rectangle._getWrapRec(this._boundPointsToParent(),this._$P.mBounds);
		}

		/**
		*获取本对象在自己坐标系的矩形显示区域。
		*<p><b>注意：</b>计算量较大，尽量少用。</p>
		*@return 矩形区域。
		*/
		__proto.getSelfBounds=function(){
			if (!this._$P.mBounds)this._set$P("mBounds",new Rectangle());
			return Rectangle._getWrapRec(this._getBoundPointsM(false),this._$P.mBounds);
		}

		/**
		*@private
		*获取本对象在父容器坐标系的显示区域多边形顶点列表。
		*当显示对象链中有旋转时，返回多边形顶点列表，无旋转时返回矩形的四个顶点。
		*@param ifRotate 之前的对象链中是否有旋转。
		*@return 顶点列表。结构：[x1,y1,x2,y2,x3,y3,...]。
		*/
		__proto._boundPointsToParent=function(ifRotate){
			(ifRotate===void 0)&& (ifRotate=false);
			var pX=0,pY=0;
			if (this._style){
				pX=this._style._tf.translateX;
				pY=this._style._tf.translateY;
				ifRotate=ifRotate || (this._style._tf.rotate!==0);
				if (this._style.scrollRect){
					pX+=this._style.scrollRect.x;
					pY+=this._style.scrollRect.y;
				}
			};
			var pList=this._getBoundPointsM(ifRotate);
			if (!pList || pList.length < 1)return pList;
			if (pList.length !=8){
				pList=ifRotate ? GrahamScan.scanPList(pList):Rectangle._getWrapRec(pList,Rectangle.TEMP)._getBoundPoints();
			}
			if (!this.transform){
				Utils.transPointList(pList,this.x-pX,this.y-pY);
				return pList;
			};
			var tPoint=Point.TEMP;
			var i=0,len=pList.length;
			for (i=0;i < len;i+=2){
				tPoint.x=pList[i];
				tPoint.y=pList[i+1];
				this.toParentPoint(tPoint);
				pList[i]=tPoint.x;
				pList[i+1]=tPoint.y;
			}
			return pList;
		}

		/**
		*返回此实例中的绘图对象（ <code>Graphics</code> ）的显示区域。
		*@return 一个 Rectangle 对象，表示获取到的显示区域。
		*/
		__proto.getGraphicBounds=function(){
			if (!this._graphics)return Rectangle.TEMP.setTo(0,0,0,0);
			return this._graphics.getBounds();
		}

		/**
		*@private
		*获取自己坐标系的显示区域多边形顶点列表
		*@param ifRotate 当前的显示对象链是否由旋转
		*@return 顶点列表。结构：[x1,y1,x2,y2,x3,y3,...]。
		*/
		__proto._getBoundPointsM=function(ifRotate){
			(ifRotate===void 0)&& (ifRotate=false);
			if (this._$P.uBounds)return this._$P.uBounds._getBoundPoints();
			if (!this._$P.temBM)this._set$P("temBM",[]);
			if (this.scrollRect){
				var rst=Utils.clearArray(this._$P.temBM);
				var rec=Rectangle.TEMP;
				rec.copyFrom(this.scrollRect);
				Utils.concatArray(rst,rec._getBoundPoints());
				return rst;
			};
			var pList=this._graphics ? this._graphics.getBoundPoints():Utils.clearArray(this._$P.temBM);
			var child;
			var cList;
			var __childs;
			__childs=this._childs;
			for (var i=0,n=__childs.length;i < n;i++){
				child=__childs [i];
				if ((child instanceof laya.display.Sprite )&& child.visible==true){
					cList=child._boundPointsToParent(ifRotate);
					if (cList)
						pList=pList ? Utils.concatArray(pList,cList):cList;
				}
			}
			return pList;
		}

		/**
		*@private
		*获取样式。
		*@return 样式 Style 。
		*/
		__proto.getStyle=function(){
			this._style===Style.EMPTY && (this._style=new Style());
			return this._style;
		}

		/**
		*@private
		*设置样式。
		*@param value 样式。
		*/
		__proto.setStyle=function(value){
			this._style=value;
		}

		/**@private */
		__proto._adjustTransform=function(){
			'use strict';
			this._tfChanged=false;
			var style=this._style;
			var tf=style._tf;
			var sx=tf.scaleX,sy=tf.scaleY;
			var m;
			if (tf.rotate || sx!==1 || sy!==1 || tf.skewX || tf.skewY){
				m=this._transform || (this._transform=Matrix.create());
				m.bTransform=true;
				var skx=(tf.rotate-tf.skewX)*0.0174532922222222;
				var sky=(tf.rotate+tf.skewY)*0.0174532922222222;
				var cx=Math.cos(sky);
				var ssx=Math.sin(sky);
				var cy=Math.sin(skx);
				var ssy=Math.cos(skx);
				m.a=sx *cx;
				m.b=sx *ssx;
				m.c=-sy *cy;
				m.d=sy *ssy;
				m.tx=m.ty=0;
				return m;
				}else {
				this._transform && this._transform.destroy();
				this._transform=null;
				this._renderType &=~0x04;
			}
			return m;
		}

		/**
		*设置坐标位置。
		*@param x X 轴坐标。
		*@param y Y 轴坐标。
		*@param speedMode 是否极速模式，普通模式调用this.x=value进行赋值，极速模式直接调用内部函数处理，如果未重写x,y属性，建议设置为急速模式性能更高
		*@return 返回对象本身。
		*/
		__proto.pos=function(x,y,speedMode){
			(speedMode===void 0)&& (speedMode=false);
			if (this._x!==x || this._y!==y){
				if (this.destroyed)return this;
				if (speedMode){
					this._x=x;
					this._y=y;
					this.conchModel && this.conchModel.pos(this._x,this._y);
					var p=this._parent;
					p && p._repaint===0 && (p._repaint=1,p.parentRepaint());
					this._$P.maskParent && this._$P.maskParent._repaint===0 && (this._$P.maskParent._repaint=1,this._$P.maskParent.parentRepaint());
					}else {
					this.x=x;
					this.y=y;
				}
			}
			return this;
		}

		/**
		*设置轴心点。
		*@param x X轴心点。
		*@param y Y轴心点。
		*@return 返回对象本身。
		*/
		__proto.pivot=function(x,y){
			this.pivotX=x;
			this.pivotY=y;
			return this;
		}

		/**
		*设置宽高。
		*@param width 宽度。
		*@param hegiht 高度。
		*@return 返回对象本身。
		*/
		__proto.size=function(width,height){
			this.width=width;
			this.height=height;
			return this;
		}

		/**
		*设置缩放。
		*@param scaleX X轴缩放比例。
		*@param scaleY Y轴缩放比例。
		*@param speedMode 是否极速模式，普通模式调用this.x=value进行赋值，极速模式直接调用内部函数处理，如果未重写x,y属性，建议设置为急速模式性能更高
		*@return 返回对象本身。
		*/
		__proto.scale=function(scaleX,scaleY,speedMode){
			(speedMode===void 0)&& (speedMode=false);
			var style=this.getStyle();
			var _tf=style._tf;
			if (_tf.scaleX !=scaleX || _tf.scaleY !=scaleY){
				if (this.destroyed)return this;
				if (speedMode){
					style.setScale(scaleX,scaleY);
					this._changeType |=0x10;
					this._tfChanged=true;
					this.conchModel && this.conchModel.scale(scaleX,scaleY);
					this._renderType |=0x04;
					var p=this._parent;
					p && p._repaint===0 && (p._repaint=1,p.parentRepaint());
					}else {
					this.scaleX=scaleX;
					this.scaleY=scaleY;
				}
			}
			return this;
		}

		/**
		*设置倾斜角度。
		*@param skewX 水平倾斜角度。
		*@param skewY 垂直倾斜角度。
		*@return 返回对象本身
		*/
		__proto.skew=function(skewX,skewY){
			this.skewX=skewX;
			this.skewY=skewY;
			return this;
		}

		/**
		*更新、呈现显示对象。
		*@param context 渲染的上下文引用。
		*@param x X轴坐标。
		*@param y Y轴坐标。
		*/
		__proto.render=function(context,x,y){
			Stat.spriteCount++;
			RenderSprite.renders[this._renderType]._fun(this,context,x+this._x,y+this._y);
			this._repaint=0;
		}

		/**
		*绘制 <code>Sprite</code> 到 <code>canvas</code> 上。
		*@param canvasWidth 画布宽度。
		*@param canvasHeight 画布高度。
		*@param x 绘制的 X 轴偏移量。
		*@param y 绘制的 Y 轴偏移量。
		*@return HTMLCanvas 对象。
		*/
		__proto.drawToCanvas=function(canvasWidth,canvasHeight,offsetX,offsetY){
			return RunDriver.drawToCanvas(this,this._renderType,canvasWidth,canvasHeight,offsetX,offsetY);
		}

		/**
		*自定义更新、呈现显示对象。
		*<p><b>注意</b>不要在此函数内增加或删除树节点，否则会树节点遍历照成影响。</p>
		*@param context 渲染的上下文引用。
		*@param x X轴坐标。
		*@param y Y轴坐标。
		*/
		__proto.customRender=function(context,x,y){
			this._renderType |=0x400;
		}

		/**
		*@private
		*应用滤镜。
		*/
		__proto._applyFilters=function(){
			if (Render.isWebGL)return;
			var _filters;
			_filters=this._$P.filters;
			if (!_filters || _filters.length < 1)return;
			for (var i=0,n=_filters.length;i < n;i++){
				_filters[i].action.apply(this._$P.cacheCanvas);
			}
		}

		/**
		*@private
		*查看当前原件中是否包含发光滤镜。
		*@return 一个 Boolean 值，表示当前原件中是否包含发光滤镜。
		*/
		__proto._isHaveGlowFilter=function(){
			var i=0,len=0;
			if (this.filters){
				for (i=0;i < this.filters.length;i++){
					if (this.filters[i].type==0x08){
						return true;
					}
				}
			}
			for (i=0,len=this._childs.length;i < len;i++){
				if (this._childs[i]._isHaveGlowFilter()){
					return true;
				}
			}
			return false;
		}

		/**
		*本地坐标转全局坐标。
		*@param point 本地坐标点。
		*@param createNewPoint 用于存储转换后的坐标的点。
		*@return 转换后的坐标的点。
		*/
		__proto.localToGlobal=function(point,createNewPoint){
			(createNewPoint===void 0)&& (createNewPoint=false);
			if (!this._displayedInStage || !point)return point;
			if (createNewPoint===true){
				point=new Point(point.x,point.y);
			};
			var ele=this;
			while (ele){
				if (ele==Laya.stage)break ;
				point=ele.toParentPoint(point);
				ele=ele.parent;
			}
			return point;
		}

		/**
		*全局坐标转本地坐标。
		*@param point 全局坐标点。
		*@param createNewPoint 用于存储转换后的坐标的点。
		*@return 转换后的坐标的点。
		*/
		__proto.globalToLocal=function(point,createNewPoint){
			(createNewPoint===void 0)&& (createNewPoint=false);
			if (!this._displayedInStage || !point)return point;
			if (createNewPoint===true){
				point=new Point(point.x,point.y);
			};
			var ele=this;
			var list=[];
			while (ele){
				if (ele==Laya.stage)break ;
				list.push(ele);
				ele=ele.parent;
			};
			var i=list.length-1;
			while (i >=0){
				ele=list[i];
				point=ele.fromParentPoint(point);
				i--;
			}
			return point;
		}

		/**
		*将本地坐标系坐标转换到父容器坐标系。
		*@param point 本地坐标点。
		*@return 转换后的点。
		*/
		__proto.toParentPoint=function(point){
			if (!point)return point;
			point.x-=this.pivotX;
			point.y-=this.pivotY;
			if (this.transform){
				this._transform.transformPoint(point);
			}
			point.x+=this._x;
			point.y+=this._y;
			var scroll=this._style.scrollRect;
			if (scroll){
				point.x-=scroll.x;
				point.y-=scroll.y;
			}
			return point;
		}

		/**
		*将父容器坐标系坐标转换到本地坐标系。
		*@param point 父容器坐标点。
		*@return 转换后的点。
		*/
		__proto.fromParentPoint=function(point){
			if (!point)return point;
			point.x-=this._x;
			point.y-=this._y;
			var scroll=this._style.scrollRect;
			if (scroll){
				point.x+=scroll.x;
				point.y+=scroll.y;
			}
			if (this.transform){
				this._transform.invertTransformPoint(point);
			}
			point.x+=this.pivotX;
			point.y+=this.pivotY;
			return point;
		}

		/**
		*使用 EventDispatcher 对象注册指定类型的事件侦听器对象，以使侦听器能够接收事件通知。
		*如果侦听鼠标事件，则会自动设置自己和父亲节点的属性 mouseEnable 的值为 true。
		*@param type 事件的类型。
		*@param caller 事件侦听函数的执行域。
		*@param listener 事件侦听函数。
		*@param args 事件侦听函数的回调参数。
		*@return 此 EventDispatcher 对象。
		*/
		__proto.on=function(type,caller,listener,args){
			if (this._mouseEnableState!==1 && this.isMouseEvent(type)){
				if (this._displayedInStage)this._$2__onDisplay();
				else laya.events.EventDispatcher.prototype.once.call(this,"display",this,this._$2__onDisplay);
			}
			return laya.events.EventDispatcher.prototype.on.call(this,type,caller,listener,args);
		}

		/**
		*使用 EventDispatcher 对象注册指定类型的事件侦听器对象，以使侦听器能够接收事件通知，此侦听事件响应一次后自动移除。
		*如果侦听鼠标事件，则会自动设置自己和父亲节点的属性 mouseEnabled 的值为 true(如果父节点mouseEnabled=false，则停止设置父节点mouseEnabled属性)。
		*@param type 事件的类型。
		*@param caller 事件侦听函数的执行域。
		*@param listener 事件侦听函数。
		*@param args 事件侦听函数的回调参数。
		*@return 此 EventDispatcher 对象。
		*/
		__proto.once=function(type,caller,listener,args){
			if (this._mouseEnableState!==1 && this.isMouseEvent(type)){
				if (this._displayedInStage)this._$2__onDisplay();
				else laya.events.EventDispatcher.prototype.once.call(this,"display",this,this._$2__onDisplay);
			}
			return laya.events.EventDispatcher.prototype.once.call(this,type,caller,listener,args);
		}

		/**@private */
		__proto._$2__onDisplay=function(){
			if (this._mouseEnableState!==1){
				var ele=this;
				while (ele && ele._mouseEnableState!==1){
					ele.mouseEnabled=true;
					ele=ele.parent;
				}
			}
		}

		/**
		*加载并显示一个图片。功能等同于Graphics.loadImage
		*@param url 图片地址。
		*@param x 显示图片的x位置
		*@param y 显示图片的y位置
		*@param width 显示图片的宽度，设置为0表示使用图片默认宽度
		*@param height 显示图片的高度，设置为0表示使用图片默认高度
		*@param complete 加载完成回调
		*@return 返回精灵对象本身
		*/
		__proto.loadImage=function(url,x,y,width,height,complete){
			var _$this=this;
			(x===void 0)&& (x=0);
			(y===void 0)&& (y=0);
			(width===void 0)&& (width=0);
			(height===void 0)&& (height=0);
			function loaded (tex){
				if (!_$this.destroyed){
					_$this.size(x+(width || tex.width),y+(height || tex.height));
					_$this.repaint();
					complete && complete.runWith(tex);
				}
			}
			this.graphics.loadImage(url,x,y,width,height,loaded);
			return this;
		}

		/**cacheAs后，设置自己和父对象缓存失效。*/
		__proto.repaint=function(){
			this.conchModel && this.conchModel.repaint && this.conchModel.repaint();
			(this._repaint===0)&& (this._repaint=1,this.parentRepaint());
			if (this._$P && this._$P.maskParent){
				this._$P.maskParent.repaint();
			}
		}

		/**
		*@private
		*获取是否重新缓存。
		*@return 如果重新缓存值为 true，否则值为 false。
		*/
		__proto._needRepaint=function(){
			return (this._repaint!==0)&& this._$P.cacheCanvas && this._$P.cacheCanvas.reCache;
		}

		/**@inheritDoc */
		__proto._childChanged=function(child){
			if (this._childs.length)this._renderType |=0x800;
			else this._renderType &=~0x800;
			if(child&&this._get$P("hasZorder"))Laya.timer.callLater(this,this.updateZOrder);
			this.repaint();
		}

		/**cacheAs时，设置所有父对象缓存失效。 */
		__proto.parentRepaint=function(){
			var p=this._parent;
			p && p._repaint===0 && (p._repaint=1,p.parentRepaint());
		}

		/**
		*开始拖动此对象。
		*@param area 拖动区域，此区域为当前对象注册点活动区域（不包括对象宽高），可选。
		*@param hasInertia 鼠标松开后，是否还惯性滑动，默认为false，可选。
		*@param elasticDistance 橡皮筋效果的距离值，0为无橡皮筋效果，默认为0，可选。
		*@param elasticBackTime 橡皮筋回弹时间，单位为毫秒，默认为300毫秒，可选。
		*@param data 拖动事件携带的数据，可选。
		*@param disableMouseEvent 禁用其他对象的鼠标检测，默认为false，设置为true能提高性能
		*@param ratio 惯性阻尼系数
		*/
		__proto.startDrag=function(area,hasInertia,elasticDistance,elasticBackTime,data,disableMouseEvent,ratio){
			(hasInertia===void 0)&& (hasInertia=false);
			(elasticDistance===void 0)&& (elasticDistance=0);
			(elasticBackTime===void 0)&& (elasticBackTime=300);
			(disableMouseEvent===void 0)&& (disableMouseEvent=false);
			(ratio===void 0)&& (ratio=0.92);
			this._$P.dragging || (this._set$P("dragging",new Dragging()));
			this._$P.dragging.start(this,area,hasInertia,elasticDistance,elasticBackTime,data,disableMouseEvent,ratio);
		}

		/**停止拖动此对象。*/
		__proto.stopDrag=function(){
			this._$P.dragging && this._$P.dragging.stop();
		}

		/**@private */
		__proto._setDisplay=function(value){
			if (!value && this._$P.cacheCanvas && this._$P.cacheCanvas.ctx){
				Pool.recover("RenderContext",this._$P.cacheCanvas.ctx);
				this._$P.cacheCanvas.ctx.canvas.size(0,0);
				this._$P.cacheCanvas.ctx=null;
			}
			if (!value){
				var fc=this._$P._filterCache;
				if (fc){
					fc.destroy();
					fc.recycle();
					this._set$P('_filterCache',null);
				}
				this._$P._isHaveGlowFilter && this._set$P('_isHaveGlowFilter',false);
			}
			_super.prototype._setDisplay.call(this,value);
		}

		/**
		*检测某个点是否在此对象内。
		*@param x 全局x坐标。
		*@param y 全局y坐标。
		*@return 表示是否在对象内。
		*/
		__proto.hitTestPoint=function(x,y){
			var point=this.globalToLocal(Point.TEMP.setTo(x,y));
			var rect=this._$P.hitArea ? this._$P.hitArea :Rectangle.TEMP.setTo(0,0,this._width,this._height);
			return rect.contains(point.x,point.y);
		}

		/**获得相对于本对象上的鼠标坐标信息。*/
		__proto.getMousePoint=function(){
			return this.globalToLocal(Point.TEMP.setTo(Laya.stage.mouseX,Laya.stage.mouseY));
		}

		/**@private */
		__proto._getWords=function(){
			return null;
		}

		/**@private */
		__proto._addChildsToLayout=function(out){
			var words=this._getWords();
			if (words==null && this._childs.length==0)return false;
			if (words){
				for (var i=0,n=words.length;i < n;i++){
					out.push(words[i]);
				}
			}
			this._childs.forEach(function(o,index,array){
				o._style._enableLayout()&& o._addToLayout(out);
			});
			return true;
		}

		/**@private */
		__proto._addToLayout=function(out){
			if (this._style.absolute)return;
			this._style.block ? out.push(this):(this._addChildsToLayout(out)&& (this.x=this.y=0));
		}

		/**@private */
		__proto._isChar=function(){
			return false;
		}

		/**@private */
		__proto._getCSSStyle=function(){
			return this._style.getCSSStyle();
		}

		/**
		*@private
		*设置指定属性名的属性值。
		*@param name 属性名。
		*@param value 属性值。
		*/
		__proto._setAttributes=function(name,value){
			switch (name){
				case 'x':
					this.x=parseFloat(value);
					break ;
				case 'y':
					this.y=parseFloat(value);
					break ;
				case 'width':
					this.width=parseFloat(value);
					break ;
				case 'height':
					this.height=parseFloat(value);
					break ;
				default :
					this[name]=value;
				}
		}

		/**
		*@private
		*/
		__proto._layoutLater=function(){
			this.parent && (this.parent)._layoutLater();
		}

		/**
		*<p>指定是否对使用了 scrollRect 的显示对象进行优化处理。</p>
		*<p>默认为false(不优化)。</p>
		*<p>当值为ture时：将对此对象使用了scrollRect 设定的显示区域以外的显示内容不进行渲染，以提高性能。</p>
		*/
		__getset(0,__proto,'optimizeScrollRect',function(){
			return this._optimizeScrollRect;
			},function(b){
			if (this._optimizeScrollRect !=b){
				this._optimizeScrollRect=b;
				this.conchModel && this.conchModel.optimizeScrollRect(b);
			}
		});

		/**
		*开启自定义渲染，只有开启自定义渲染，才能使用customRender函数渲染
		*/
		__getset(0,__proto,'customRenderEnable',null,function(b){
			if (b){
				this._renderType |=0x400;
				if (Render.isConchNode){
					laya.display.Sprite.CustomList.push(this);
					var canvas=new HTMLCanvas("2d");
					canvas._setContext(new CanvasRenderingContext2D());
					this.customContext=new RenderContext(0,0,canvas);
					canvas.context.setCanvasType && canvas.context.setCanvasType(2);
					this.conchModel.custom(canvas.context);
				}
			}
		});

		/**
		*指定显示对象是否缓存为静态图像。功能同cacheAs的normal模式。
		*/
		__getset(0,__proto,'cacheAsBitmap',function(){
			return this.cacheAs!=="none";
			},function(value){
			this.cacheAs=value ? (this._$P["hasFilter"] ? "none" :"normal"):"none";
		});

		/**
		*<p>指定显示对象是否缓存为静态图像，cacheAs时，子对象发生变化，会自动重新缓存，同时也可以手动调用reCache方法更新缓存。</p>
		*建议把不经常变化的复杂内容缓存为静态图像，能极大提高渲染性能，有"none"，"normal"和"bitmap"三个值可选。
		*<li>默认为"none"，不做任何缓存。</li>
		*<li>当值为"normal"时，canvas下进行画布缓存，webgl模式下进行命令缓存。</li>
		*<li>当值为"bitmap"时，canvas下进行依然是画布缓存，webgl模式下使用renderTarget缓存。</li>
		*webgl下renderTarget缓存模式有最大2048大小限制，会额外增加内存开销，不断重绘时开销比较大，但是会减少drawcall，渲染性能最高。
		*webgl下命令缓存模式只会减少节点遍历及命令组织，不会减少drawcall，性能中等。
		*/
		__getset(0,__proto,'cacheAs',function(){
			return this._$P.cacheCanvas==null ? "none" :this._$P.cacheCanvas.type;
			},function(value){
			var cacheCanvas=this._$P.cacheCanvas;
			if (value===(cacheCanvas ? cacheCanvas.type :"none"))return;
			if (value!=="none"){
				cacheCanvas || (cacheCanvas=this._set$P("cacheCanvas",Pool.getItemByClass("cacheCanvas",Object)));
				cacheCanvas.type=value;
				cacheCanvas.reCache=true;
				this._renderType |=0x10;
				if (value=="bitmap")this.conchModel && this.conchModel.cacheAs(1);
				this._set$P("cacheForFilters",false);
				}else {
				if (this._$P["hasFilter"]){
					this._set$P("cacheForFilters",true);
					}else {
					if (cacheCanvas)Pool.recover("cacheCanvas",cacheCanvas);
					this._$P.cacheCanvas=null;
					this._renderType &=~0x10;
					this.conchModel && this.conchModel.cacheAs(0);
				}
			}
			this.repaint();
		});

		/**z排序，更改此值，按照值的大小进行显示层级排序。*/
		__getset(0,__proto,'zOrder',function(){
			return this._zOrder;
			},function(value){
			if (this._zOrder !=value){
				this._zOrder=value;
				this.conchModel && this.conchModel.setZOrder && this.conchModel.setZOrder(value);
				if (this._parent){
					value && this._parent._set$P("hasZorder",true);
					Laya.timer.callLater(this._parent,this.updateZOrder);
				}
			}
		});

		/**旋转角度，默认值为0。*/
		__getset(0,__proto,'rotation',function(){
			return this._style._tf.rotate;
			},function(value){
			var style=this.getStyle();
			if (style._tf.rotate!==value){
				this._changeType |=0x10;
				style.setRotate(value);
				this._tfChanged=true;
				this.conchModel && this.conchModel.rotate(value);
				this._renderType |=0x04;
				var p=this._parent;
				p && p._repaint===0 && (p._repaint=1,p.parentRepaint());
			}
		});

		/**
		*表示显示对象的宽度，以像素为单位。
		*/
		__getset(0,__proto,'width',function(){
			if (!this.autoSize)return this._width;
			return this.getSelfBounds().width;
			},function(value){
			this._width!==value && (this._width=value,this.conchModel && this.conchModel.size(value,this._height),this.repaint());
		});

		/**表示显示对象相对于父容器的水平方向坐标值。*/
		__getset(0,__proto,'x',function(){
			return this._x;
			},function(value){
			if (this._x!==value){
				if (this.destroyed)return;
				this._x=value;
				this.conchModel && this.conchModel.pos(value,this._y);
				var p=this._parent;
				p && p._repaint===0 && (p._repaint=1,p.parentRepaint());
				this._$P.maskParent && this._$P.maskParent._repaint===0 && (this._$P.maskParent._repaint=1,this._$P.maskParent.parentRepaint());
			}
		});

		/**
		*获得全局Y轴缩放值
		*/
		__getset(0,__proto,'globalScaleY',function(){
			var scale=1;
			var ele=this;
			while (ele){
				if (ele===Laya.stage)break ;
				scale *=ele.scaleX;
				ele=ele.parent;
			}
			return scale;
		});

		/**手动设置的可点击区域，或者一个HitArea区域。*/
		__getset(0,__proto,'hitArea',function(){
			return this._$P.hitArea;
			},function(value){
			this._set$P("hitArea",value);
		});

		/**设置cacheAs为非空时此值才有效，staticCache=true时，子对象变化时不会自动更新缓存，只能通过调用reCache方法手动刷新。*/
		__getset(0,__proto,'staticCache',function(){
			return this._$P.staticCache;
			},function(value){
			this._set$P("staticCache",value);
			if (!value && this._$P.cacheCanvas){
				this._$P.cacheCanvas.reCache=true;
			}
		});

		/**@private 清理graphics，只显示此texture图片，等同于graphics.clear();graphics.drawTexture()*/
		__getset(0,__proto,'texture',function(){
			return this._texture;
			},function(value){
			if (this._texture !=value){
				this._texture=value;
				this.graphics.cleanByTexture(value,0,0);
			}
		});

		/**表示显示对象相对于父容器的垂直方向坐标值。*/
		__getset(0,__proto,'y',function(){
			return this._y;
			},function(value){
			if (this._y!==value){
				if (this.destroyed)return;
				this._y=value;
				this.conchModel && this.conchModel.pos(this._x,value);
				var p=this._parent;
				p && p._repaint===0 && (p._repaint=1,p.parentRepaint());
				this._$P.maskParent && this._$P.maskParent._repaint===0 && (this._$P.maskParent._repaint=1,this._$P.maskParent.parentRepaint());
			}
		});

		/**
		*表示显示对象的高度，以像素为单位。
		*/
		__getset(0,__proto,'height',function(){
			if (!this.autoSize)return this._height;
			return this.getSelfBounds().height;
			},function(value){
			this._height!==value && (this._height=value,this.conchModel && this.conchModel.size(this._width,value),this.repaint());
		});

		/**指定要使用的混合模式。*/
		__getset(0,__proto,'blendMode',function(){
			return this._style.blendMode;
			},function(value){
			this.getStyle().blendMode=value;
			this.conchModel && this.conchModel.blendMode(value);
			if (value && value !="source-over")this._renderType |=0x08;
			else this._renderType &=~0x08;
			this.parentRepaint();
		});

		/**X轴缩放值，默认值为1。*/
		__getset(0,__proto,'scaleX',function(){
			return this._style._tf.scaleX;
			},function(value){
			var style=this.getStyle();
			if (style._tf.scaleX!==value){
				style.setScaleX(value);
				this._changeType |=0x10;
				this._tfChanged=true;
				this.conchModel && this.conchModel.scale(value,style._tf.scaleY);
				this._renderType |=0x04;
				var p=this._parent;
				p && p._repaint===0 && (p._repaint=1,p.parentRepaint());
			}
		});

		/**Y轴缩放值，默认值为1。*/
		__getset(0,__proto,'scaleY',function(){
			return this._style._tf.scaleY;
			},function(value){
			var style=this.getStyle();
			if (style._tf.scaleY!==value){
				style.setScaleY(value);
				this._changeType |=0x10;
				this._tfChanged=true;
				this.conchModel && this.conchModel.scale(style._tf.scaleX,value);
				this._renderType |=0x04;
				var p=this._parent;
				p && p._repaint===0 && (p._repaint=1,p.parentRepaint());
			}
		});

		/**对舞台 <code>stage</code> 的引用。*/
		__getset(0,__proto,'stage',function(){
			return Laya.stage;
		});

		/**水平倾斜角度，默认值为0。*/
		__getset(0,__proto,'skewX',function(){
			return this._style._tf.skewX;
			},function(value){
			var style=this.getStyle();
			if (style._tf.skewX!==value){
				style.setSkewX(value);
				this._tfChanged=true;
				this._renderType |=0x04;
				var p=this._parent;
				p && p._repaint===0 && (p._repaint=1,p.parentRepaint());
			}
		});

		/**显示对象的滚动矩形范围，(如果只想限制子对象渲染区域，请使用viewport)，设置optimizeScrollRect=true，可以优化裁剪区域外的内容不进行渲染
		*srollRect和viewport的区别：
		*1.srollRect自带裁剪效果，viewport只影响子对象渲染是否渲染，不具有裁剪效果（性能更高）
		*2.设置rect的x,y属性均能实现区域滚动效果，但scrollRect会保持0,0点位置不变
		**/
		__getset(0,__proto,'scrollRect',function(){
			return this._style.scrollRect;
			},function(value){
			this.getStyle().scrollRect=value;
			this.repaint();
			if (value){
				this._renderType |=0x80;
				this.conchModel && this.conchModel.scrollRect(value.x,value.y,value.width,value.height);
				}else {
				this._renderType &=~0x80;
				if (this.conchModel){
					if (Sprite.RUNTIMEVERION < "0.9.1")
						this.conchModel.removeType(0x40);
					else
					this.conchModel.removeType(0x80);
				}
			}
		});

		/**垂直倾斜角度，默认值为0。*/
		__getset(0,__proto,'skewY',function(){
			return this._style._tf.skewY;
			},function(value){
			var style=this.getStyle();
			if (style._tf.skewY!==value){
				style.setSkewY(value);
				this._tfChanged=true;
				this.conchModel && this.conchModel.skew(style._tf.skewX,value);
				this._renderType |=0x04;
				var p=this._parent;
				p && p._repaint===0 && (p._repaint=1,p.parentRepaint());
			}
		});

		/**
		*对象的矩阵信息。
		*/
		__getset(0,__proto,'transform',function(){
			return this._tfChanged ? this._adjustTransform():this._transform;
			},function(value){
			this._tfChanged=false;
			this._transform=value;
			if (value){
				this._x=value.tx;
				this._y=value.ty;
				value.tx=value.ty=0;
				this.conchModel && this.conchModel.transform(value.a,value.b,value.c,value.d,this._x,this._y);
			}
			if (value)this._renderType |=0x04;
			else {
				this._renderType &=~0x04;
				this.conchModel && this.conchModel.removeType(0x04);
			}
			this.parentRepaint();
		});

		/**X轴 轴心点的位置，单位为像素，默认为0，轴心点会影响对象位置，缩放，旋转。*/
		__getset(0,__proto,'pivotX',function(){
			return this._style._tf.translateX;
			},function(value){
			this.getStyle().setTranslateX(value);
			this._changeType |=0x10;
			this.conchModel && this.conchModel.pivot(value,this._style._tf.translateY);
			this.repaint();
		});

		/**Y轴 轴心点的位置，单位为像素，默认为0，轴心点会影响对象位置，缩放，旋转。*/
		__getset(0,__proto,'pivotY',function(){
			return this._style._tf.translateY;
			},function(value){
			this.getStyle().setTranslateY(value);
			this._changeType |=0x10;
			this.conchModel && this.conchModel.pivot(this._style._tf.translateX,value);
			this.repaint();
		});

		/**透明度，值为0-1，默认值为1，表示不透明。*/
		__getset(0,__proto,'alpha',function(){
			return this._style.alpha;
			},function(value){
			if (this._style && this._style.alpha!==value){
				value=value < 0 ? 0 :(value > 1 ? 1 :value);
				this.getStyle().alpha=value;
				this.conchModel && this.conchModel.alpha(value);
				if (value!==1)this._renderType |=0x02;
				else this._renderType &=~0x02;
				this.parentRepaint();
			}
		});

		/**表示是否可见，默认为true。*/
		__getset(0,__proto,'visible',function(){
			return this._style.visible;
			},function(value){
			if (this._style && this._style.visible!==value){
				this.getStyle().visible=value;
				this.conchModel && this.conchModel.visible(value);
				this.parentRepaint();
			}
		});

		/**绘图对象。*/
		__getset(0,__proto,'graphics',function(){
			return this._graphics || (this.graphics=RunDriver.createGraphics());
			},function(value){
			if (this._graphics)this._graphics._sp=null;
			this._graphics=value;
			if (value){
				this._renderType &=~0x01;
				this._renderType |=0x200;
				value._sp=this;
				this.conchModel && this.conchModel.graphics(this._graphics);
				}else {
				this._renderType &=~0x200;
				this._renderType &=~0x01;
				if (this.conchModel){
					if (Sprite.RUNTIMEVERION < "0.9.1")
						this.conchModel.removeType(0x100);
					else
					this.conchModel.removeType(0x200);
				}
			}
			this.repaint();
		});

		/**滤镜集合。*/
		__getset(0,__proto,'filters',function(){
			return this._$P.filters;
			},function(value){
			value && value.length===0 && (value=null);
			if (this._$P.filters==value)return;
			this._set$P("filters",value ? value.slice():null);
			if (Render.isConchApp){
				if (this.conchModel){
					if (Sprite.RUNTIMEVERION < "0.9.1")
						this.conchModel.removeType(0x10);
					else
					this.conchModel.removeType(0x20);
				}
				if (this._$P.filters && this._$P.filters.length==1){
					this._$P.filters[0].callNative(this);
				}
			}
			if (Render.isWebGL){
				if (value && value.length){
					this._renderType |=0x20;
					}else {
					this._renderType &=~0x20;
				}
			}
			if (value && value.length > 0){
				if (!(Render.isWebGL && value.length==1 && (((value[0])instanceof laya.filters.ColorFilter )))){
					if (this.cacheAs !="bitmap"){
						if (!Render.isConchNode)this.cacheAs="bitmap";
						this._set$P("cacheForFilters",true);
					}
					this._set$P("hasFilter",true);
				}
				}else {
				this._set$P("hasFilter",false);
				if (this._$P["cacheForFilters"] && this.cacheAs=="bitmap"){
					this.cacheAs="none";
				}
			}
			this.repaint();
		});

		/**遮罩，可以设置一个对象或者图片，根据对象形状进行遮罩显示。
		*【注意】遮罩对象坐标系是相对遮罩对象本身的，这个和flash机制不同*/
		__getset(0,__proto,'mask',function(){
			return this._$P._mask;
			},function(value){
			if (value && this.mask && this.mask._$P.maskParent)return;
			if (value){
				this.cacheAs="bitmap";
				this._set$P("_mask",value);
				value._set$P("maskParent",this);
				}else {
				this.cacheAs="none";
				this.mask && this.mask._set$P("maskParent",null);
				this._set$P("_mask",value);
			}
			this.conchModel && this.conchModel.mask(value ? value.conchModel :null);
			this._renderType |=0x40;
			this.parentRepaint();
		});

		/**
		*是否接受鼠标事件。
		*默认为false，如果监听鼠标事件，则会自动设置本对象及父节点的属性 mouseEnable 的值都为 true（如果父节点手动设置为false，则不会更改）。
		**/
		__getset(0,__proto,'mouseEnabled',function(){
			return this._mouseEnableState > 1;
			},function(value){
			this._mouseEnableState=value ? 2 :1;
		});

		/**
		*获得全局X轴缩放值
		*/
		__getset(0,__proto,'globalScaleX',function(){
			var scale=1;
			var ele=this;
			while (ele){
				if (ele===Laya.stage)break ;
				scale *=ele.scaleX;
				ele=ele.parent;
			}
			return scale;
		});

		/**
		*表示鼠标在此对象上的 X 轴坐标信息。
		*/
		__getset(0,__proto,'mouseX',function(){
			return this.getMousePoint().x;
		});

		/**
		*表示鼠标在此对象上的 Y 轴坐标信息。
		*/
		__getset(0,__proto,'mouseY',function(){
			return this.getMousePoint().y;
		});

		Sprite.fromImage=function(url){
			return new Sprite().loadImage(url);
		}

		Sprite.CHG_VIEW=0x10;
		Sprite.CHG_SCALE=0x100;
		Sprite.CHG_TEXTURE=0x1000;
		Sprite.CustomList=[];
		__static(Sprite,
		['RUNTIMEVERION',function(){return this.RUNTIMEVERION=window.conch?conchConfig.getRuntimeVersion().substr(conchConfig.getRuntimeVersion().lastIndexOf('-')+1):'';}
		]);
		return Sprite;
	})(Node)


	/**
	*@private
	*audio标签播放声音的音轨控制
	*/
	//class laya.media.h5audio.AudioSoundChannel extends laya.media.SoundChannel
	var AudioSoundChannel=(function(_super){
		function AudioSoundChannel(audio){
			this._audio=null;
			this._onEnd=null;
			this._resumePlay=null;
			AudioSoundChannel.__super.call(this);
			this._onEnd=Utils.bind(this.__onEnd,this);
			this._resumePlay=Utils.bind(this.__resumePlay,this);
			audio.addEventListener("ended",this._onEnd);
			this._audio=audio;
		}

		__class(AudioSoundChannel,'laya.media.h5audio.AudioSoundChannel',_super);
		var __proto=AudioSoundChannel.prototype;
		__proto.__onEnd=function(){
			if (this.loops==1){
				if (this.completeHandler){
					Laya.timer.once(10,this,this.__runComplete,[this.completeHandler],false);
					this.completeHandler=null;
				}
				this.stop();
				this.event("complete");
				return;
			}
			if (this.loops > 0){
				this.loops--;
			}
			this.play();
		}

		__proto.__resumePlay=function(){
			if(this._audio)this._audio.removeEventListener("canplay",this._resumePlay);
			try {
				this._audio.currentTime=this.startTime;
				Browser.container.appendChild(this._audio);
				this._audio.play();
				}catch (e){
				this.event("error");
			}
		}

		/**
		*播放
		*/
		__proto.play=function(){
			try {
				this._audio.playbackRate=SoundManager.playbackRate;
				this._audio.currentTime=this.startTime;
				}catch (e){
				this._audio.addEventListener("canplay",this._resumePlay);
				return;
			}
			Browser.container.appendChild(this._audio);
			if("play" in this._audio)
				this._audio.play();
		}

		/**
		*停止播放
		*
		*/
		__proto.stop=function(){
			this.isStopped=true;
			SoundManager.removeChannel(this);
			this.completeHandler=null;
			if (!this._audio)
				return;
			if("pause" in this._audio)
				this._audio.pause();
			this._audio.removeEventListener("ended",this._onEnd);
			this._audio.removeEventListener("canplay",this._resumePlay);
			Pool.recover("audio:"+this.url,this._audio);
			Browser.removeElement(this._audio);
			this._audio=null;
		}

		/**
		*当前播放到的位置
		*@return
		*
		*/
		__getset(0,__proto,'position',function(){
			if (!this._audio)
				return 0;
			return this._audio.currentTime;
		});

		/**
		*获取总时间。
		*/
		__getset(0,__proto,'duration',function(){
			if (!this._audio)
				return 0;
			return this._audio.duration;
		});

		/**
		*设置音量
		*@param v
		*
		*/
		/**
		*获取音量
		*@return
		*
		*/
		__getset(0,__proto,'volume',function(){
			if (!this._audio)return 1;
			return this._audio.volume;
			},function(v){
			if (!this._audio)return;
			this._audio.volume=v;
		});

		return AudioSoundChannel;
	})(SoundChannel)


	/**
	*@private
	*web audio api方式播放声音的音轨控制
	*/
	//class laya.media.webaudio.WebAudioSoundChannel extends laya.media.SoundChannel
	var WebAudioSoundChannel=(function(_super){
		function WebAudioSoundChannel(){
			this.audioBuffer=null;
			this.gain=null;
			this.bufferSource=null;
			this._currentTime=0;
			this._volume=1;
			this._startTime=0;
			this._onPlayEnd=null;
			this.context=WebAudioSound.ctx;
			WebAudioSoundChannel.__super.call(this);
			this._onPlayEnd=Utils.bind(this.__onPlayEnd,this);
			if (this.context["createGain"]){
				this.gain=this.context["createGain"]();
				}else {
				this.gain=this.context["createGainNode"]();
			}
		}

		__class(WebAudioSoundChannel,'laya.media.webaudio.WebAudioSoundChannel',_super);
		var __proto=WebAudioSoundChannel.prototype;
		/**
		*播放声音
		*/
		__proto.play=function(){
			this._clearBufferSource();
			if (!this.audioBuffer)return;
			var context=this.context;
			var gain=this.gain;
			var bufferSource=context.createBufferSource();
			this.bufferSource=bufferSource;
			bufferSource.buffer=this.audioBuffer;
			bufferSource.connect(gain);
			if (gain)
				gain.disconnect();
			gain.connect(context.destination);
			bufferSource.onended=this._onPlayEnd;
			this._startTime=Browser.now();
			this.gain.gain.value=this._volume;
			if (this.loops==0){
				bufferSource.loop=true;
			}
			bufferSource.playbackRate.value=SoundManager.playbackRate;
			bufferSource.start(0,this.startTime);
			this._currentTime=0;
		}

		__proto.__onPlayEnd=function(){
			if (this.loops==1){
				if (this.completeHandler){
					Laya.timer.once(10,this,this.__runComplete,[this.completeHandler],false);
					this.completeHandler=null;
				}
				this.stop();
				this.event("complete");
				return;
			}
			if (this.loops > 0){
				this.loops--;
			}
			this.play();
		}

		__proto._clearBufferSource=function(){
			if (this.bufferSource){
				var sourceNode=this.bufferSource;
				if (sourceNode.stop){
					sourceNode.stop(0);
					}else {
					sourceNode.noteOff(0);
				}
				sourceNode.disconnect(0);
				sourceNode.onended=null;
				if (!WebAudioSoundChannel._tryCleanFailed)this._tryClearBuffer(sourceNode);
				this.bufferSource=null;
			}
		}

		__proto._tryClearBuffer=function(sourceNode){
			try {sourceNode.buffer=WebAudioSound._miniBuffer;}catch (e){WebAudioSoundChannel._tryCleanFailed=true;}
		}

		/**
		*停止播放
		*/
		__proto.stop=function(){
			this._clearBufferSource();
			this.audioBuffer=null;
			if (this.gain)
				this.gain.disconnect();
			this.isStopped=true;
			SoundManager.removeChannel(this);
			this.completeHandler=null;
		}

		/**
		*获取当前播放位置
		*/
		__getset(0,__proto,'position',function(){
			if (this.bufferSource){
				return (Browser.now()-this._startTime)/ 1000+this.startTime;
			}
			return 0;
		});

		__getset(0,__proto,'duration',function(){
			if (this.audioBuffer){
				return this.audioBuffer.duration;
			}
			return 0;
		});

		/**
		*设置音量
		*/
		/**
		*获取音量
		*/
		__getset(0,__proto,'volume',function(){
			return this._volume;
			},function(v){
			if (this.isStopped){
				return;
			}
			this._volume=v;
			this.gain.gain.value=v;
		});

		WebAudioSoundChannel._tryCleanFailed=false;
		return WebAudioSoundChannel;
	})(SoundChannel)


	/**
	*@private
	*<code>Bitmap</code> 是图片资源类。
	*/
	//class laya.resource.Bitmap extends laya.resource.Resource
	var Bitmap=(function(_super){
		function Bitmap(){
			//this._source=null;
			//this._w=NaN;
			//this._h=NaN;
			this.useNum=0;
			Bitmap.__super.call(this);
			this._w=0;
			this._h=0;
		}

		__class(Bitmap,'laya.resource.Bitmap',_super);
		var __proto=Bitmap.prototype;
		/**
		*彻底清理资源。
		*/
		__proto.dispose=function(){
			this._resourceManager.removeResource(this);
			_super.prototype.dispose.call(this);
		}

		/***
		*宽度。
		*/
		__getset(0,__proto,'width',function(){
			return this._w;
		});

		/***
		*高度。
		*/
		__getset(0,__proto,'height',function(){
			return this._h;
		});

		/***
		*HTML Image 或 HTML Canvas 或 WebGL Texture 。
		*/
		__getset(0,__proto,'source',function(){
			return this._source;
		});

		return Bitmap;
	})(Resource)


	/**
	*...
	*@author ww
	*/
	//class laya.debug.tools.enginehook.LoaderHook extends laya.net.LoaderManager
	var LoaderHook=(function(_super){
		function LoaderHook(){
			LoaderHook.__super.call(this);
		}

		__class(LoaderHook,'laya.debug.tools.enginehook.LoaderHook',_super);
		var __proto=LoaderHook.prototype;
		__proto.checkUrls=function(url){
			var tarUrl;
			if ((typeof url=='string')){
				tarUrl=url;
				}else{
				tarUrl=url.url;
			}
			if (LoaderHook.preFails[tarUrl]){
				if (LoaderHook.enableFailDebugger){
					debugger;
				}
			}
		}

		__proto.chekUrlList=function(urls){
			var i=0,len=0;
			len=urls.length;
			for (i=0;i < len;i++){
				this.checkUrls(urls[i]);
			}
		}

		__proto.load=function(url,complete,progress,type,priority,cache,group,ignoreCache){
			(priority===void 0)&& (priority=1);
			(cache===void 0)&& (cache=true);
			(ignoreCache===void 0)&& (ignoreCache=false);
			if ((url instanceof Array)){
				this.chekUrlList(url);
				}else{
				this.checkUrls(url);
			}
			return _super.prototype.load.call(this,url,complete,progress,type,priority,cache,group,ignoreCache);
		}

		LoaderHook.init=function(){
			Laya.loader=new LoaderHook();
			Laya.loader.on("error",null,LoaderHook.onFail);
			LoaderHook.preFails=LocalStorage.getJSON("LoadFailItems");
			if (!LoaderHook.preFails)LoaderHook.preFails={};
		}

		LoaderHook.onFail=function(failFile){
			OutPutView.I.dTrace("LoadFail:"+failFile);
			LoaderHook.nowFails[failFile]=true;
			LocalStorage.setJSON("LoadFailItems",LoaderHook.nowFails);
		}

		LoaderHook.resetFails=function(){
			LoaderHook.nowFails={};
			LocalStorage.setJSON("LoadFailItems",LoaderHook.nowFails);
		}

		LoaderHook.preFails={};
		LoaderHook.nowFails={};
		LoaderHook.enableFailDebugger=true;
		LoaderHook.FailSign="LoadFailItems";
		return LoaderHook;
	})(LoaderManager)


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-9-30 下午5:10:00
	*/
	//class laya.ide.hook.LoaderHook extends laya.net.Loader
	var LoaderHook1=(function(_super){
		function LoaderHook(){
			LoaderHook.__super.call(this);
		}

		__class(LoaderHook,'laya.ide.hook.LoaderHook',_super,'LoaderHook1');
		var __proto=LoaderHook.prototype;
		__proto.hookedLoad=function(url,type,cache){
			(cache===void 0)&& (cache=true);
			url=URL.formatURL(url);
			this._url=url;
			this._type=type || (type=this.getTypeFromUrl(url));
			this._cache=cache;
			this._data=null;
			if (Loader.loadedMap[url]){
				this._data=Loader.loadedMap[url];
				this.event("progress",1);
				this.event("complete",this._data);
				return;
			}
			if (Loader.parserMap[type] !=null){
				if (((Loader.parserMap[type])instanceof laya.utils.Handler ))Loader.parserMap[type].runWith(this);
				else Loader.parserMap[type].call(null,this);
				return;
			}
			url=url+"?v="+Math.random();
			if (type==="image" || type==="htmlimage" || type==="nativeimage")return this._loadImage(url);
			if (type==="sound")return this._loadSound(url);
			if (!this._http){
				this._http=new HttpRequest();
				this._http.on("progress",this,this.onProgress);
				this._http.on("error",this,this.onError);
				this._http.on("complete",this,this.onLoaded);
			}
			this._http.send(url,null,"get",type!=="atlas" ? type :"json");
		}

		LoaderHook.init=function(){
			LoaderHook.I=new LoaderHook();
			LoaderHook.setRenderHook();
		}

		LoaderHook.setRenderHook=function(){
			Loader["prototype"]["load"]=LoaderHook.I.hookedLoad;
		}

		LoaderHook.I=null
		return LoaderHook;
	})(Loader)


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2016-5-30 下午8:41:00
	*/
	//class laya.ide.managers.FontLoader extends laya.net.Loader
	var FontLoader=(function(_super){
		function FontLoader(){
			FontLoader.__super.call(this);
		}

		__class(FontLoader,'laya.ide.managers.FontLoader',_super);
		FontLoader.init=function(){
			Loader.parserMap["Font"]=FontLoader.loadFont;
		}

		FontLoader.isFontFile=function(file){
			return FileTools.getExtensionName(file)=="fnt";
		}

		FontLoader.getFontLoaderItem=function(file){
			var url;
			url=file.substr(0,file.length-4);
			url+=".font";
			return {url:url,type:"Font",priority:2 };
		}

		FontLoader.loadFont=function(loader){
			var font;
			font=new BitmapFont();
			var url;
			url=loader.url.replace(".font",".fnt");
			ResFileManager.clearRes(url);
			ResFileManager.clearRes(loader.url.replace(".font",".png"));
			var fontName;
			fontName=FileTools.getFileName(url);
			console.log("load font:",fontName,url);
			font.loadFont(url,Handler.create(null,FontLoader.loadFontComplete,[loader,fontName,font]));
		}

		FontLoader.loadFontComplete=function(loader,fontName,font){
			console.log("loaded font:",fontName);
			Text.registerBitmapFont(fontName,font);
			loader.endLoad(font);
		}

		FontLoader.isOkFont=function(file){
			if(!FileTools.exist(file.replace(".fnt",".png")))return false;
			if(!FileTools.exist(file.replace(".fnt",".fnt")))return false;
			return true;
		}

		FontLoader.Font="Font";
		return FontLoader;
	})(Loader)


	/**
	*
	*@author ww
	*@version 1.0
	*
	*@created 2015-8-31 下午9:17:20
	*/
	//class as3analyser.parser.FunctionItem extends as3analyser.parser.struct.DefineAndBody
	var FunctionItem=(function(_super){
		function FunctionItem(){
			this.funName=null;
			this.allLines=null;
			this.params=null;
			this.isSigned=false;
			this.isMachineCode=false;
			this.memberDic={};
			this.words=null;
			FunctionItem.__super.call(this);
			this.keyWord="function";
		}

		__class(FunctionItem,'as3analyser.parser.FunctionItem',_super);
		var __proto=FunctionItem.prototype;
		__proto.addMember=function(tStr){
			var tMember;
			if(SingleMemberParser.getMemberType(tStr)){
				tMember=SingleMemberParser.parseMember(tStr);
				this.memberDic[tMember.name]=tMember;
			}
		}

		//trace("function add mem:"+tMember.name+" type:"+tMember.type);
		__proto.setData=function(defineLine,lines){
			this.setLines(lines);
			this.parseInfo(defineLine);
			this.parse();
		}

		__proto.parse=function(){
			var i=0;
			var len=0;
			var tLine;
			var tStr;
			len=this.lines.length;
			for(i=0;i<len;i++){
				tLine=this.lines[i];
				tStr=tLine.lineStr;
				if(SingleMemberParser.getMemberType(tStr)){
					this.addMembers(SingleMemberParser.parseMembers(tStr));
				}
			}
			this.words=ASLex.toWords(this.oCode);
			this.build();
		}

		__proto.addMembers=function(mList){
			var i=0;
			var len=0;
			var tMember;
			len=mList.length;
			for(i=0;i<len;i++){
				tMember=mList[i];
				this.memberDic[tMember.name]=tMember;
			}
		}

		//trace("function add mem:"+tMember.name+" type:"+tMember.type);
		__proto.build=function(){}
		// TODO Auto Generated method stub
		__proto.parseMyInfo=function(){
			this.funName=StringTool1.getBetween(this.defineNoBody,"function","(");
			this.funName=StringTool1.trim(this.funName);
			this.params=StringTool1.getBetween(this.defineNoBody,"(",")").split(",");
			var i=0;
			var len=0;
			this.params=StringTool1.removeEmptyStr(this.params);
			len=this.params.length;
			for(i=0;i<len;i++){
				this.addMember("var "+this.params[i]);
			}
		}

		FunctionItem.createByLines=function(lines,defineLine){
			var rst;
			rst=new FunctionItem();
			rst.setData(defineLine,lines);
			return rst;
		}

		FunctionItem.AsySign="";
		return FunctionItem;
	})(DefineAndBody)


	/**
	*动画播放控制器
	*/
	//class laya.display.AnimationPlayerBase extends laya.display.Sprite
	var AnimationPlayerBase=(function(_super){
		function AnimationPlayerBase(){
			this.loop=false;
			this.wrapMode=0;
			this._index=0;
			this._count=0;
			this._isPlaying=false;
			this._labels=null;
			this._isReverse=false;
			this._frameRateChanged=false;
			this._controlNode=null;
			this._actionName=null;
			AnimationPlayerBase.__super.call(this);
			this._interval=Config.animationInterval;
		}

		__class(AnimationPlayerBase,'laya.display.AnimationPlayerBase',_super);
		var __proto=AnimationPlayerBase.prototype;
		/**
		*播放动画。
		*@param start 开始播放的动画索引或label。
		*@param loop 是否循环。
		*@param name 如果name为空(可选)，则播放当前动画，如果不为空，则播放全局缓存动画（如果有）
		*/
		__proto.play=function(start,loop,name){
			(start===void 0)&& (start=0);
			(loop===void 0)&& (loop=true);
			(name===void 0)&& (name="");
			this._isPlaying=true;
			this.index=((typeof start=='string'))? this._getFrameByLabel(start):start;
			this.loop=loop;
			this._actionName=name;
			this._isReverse=this.wrapMode==1;
			if (this.interval > 0){
				this.timerLoop(this.interval,this,this._frameLoop,null,true);
			}
		}

		/**@private */
		__proto._getFrameByLabel=function(label){
			var i=0;
			for (i=0;i < this._count;i++){
				if (this._labels[i]==label)return i;
			}
			return 0;
		}

		/**@private */
		__proto._frameLoop=function(){
			if (this._isReverse){
				this._index--;
				if (this._index < 0){
					if (this.loop){
						if (this.wrapMode==2){
							this._index=this._count > 0 ? 1 :0;
							this._isReverse=false;
							}else {
							this._index=this._count-1;
						}
						this.event("complete");
						}else {
						this._index=0;
						this.stop();
						this.event("complete");
						return;
					}
				}
				}else {
				this._index++;
				if (this._index >=this._count){
					if (this.loop){
						if (this.wrapMode==2){
							this._index=this._count-2 >=0 ? this._count-2 :0;
							this._isReverse=true;
							}else {
							this._index=0;
						}
						this.event("complete");
						}else {
						this._index--;
						this.stop();
						this.event("complete");
						return;
					}
				}
			}
			this.index=this._index;
		}

		/**@private */
		__proto._setControlNode=function(node){
			if (this._controlNode){
				this._controlNode.off("display",this,this._$3__onDisplay);
				this._controlNode.off("undisplay",this,this._$3__onDisplay);
			}
			this._controlNode=node;
			if (node && node !=this){
				node.on("display",this,this._$3__onDisplay);
				node.on("undisplay",this,this._$3__onDisplay);
			}
		}

		/**@private */
		__proto._setDisplay=function(value){
			_super.prototype._setDisplay.call(this,value);
			this._$3__onDisplay();
		}

		/**@private */
		__proto._$3__onDisplay=function(){
			if (this._isPlaying){
				if (this._controlNode.displayedInStage)this.play(this._index,this.loop,this._actionName);
				else this.clearTimer(this,this._frameLoop);
			}
		}

		/**
		*停止播放。
		*/
		__proto.stop=function(){
			this._isPlaying=false;
			this.clearTimer(this,this._frameLoop);
		}

		/**
		*增加一个标签到index帧上，播放到此index后会派发label事件
		*@param label 标签名称
		*@param index 索引位置
		*/
		__proto.addLabel=function(label,index){
			if (!this._labels)this._labels={};
			this._labels[index]=label;
		}

		/**
		*删除某个标签
		*@param label 标签名字，如果label为空，则删除所有Label
		*/
		__proto.removeLabel=function(label){
			if (!label)this._labels=null;
			else if (this._labels){
				for (var name in this._labels){
					if (this._labels[name]===label){
						delete this._labels[name];
						break ;
					}
				}
			}
		}

		/**
		*切换到某帧并停止
		*@param position 帧索引或label
		*/
		__proto.gotoAndStop=function(position){
			this.index=((typeof position=='string'))? this._getFrameByLabel(position):position;
			this.stop();
		}

		/**
		*@private
		*显示到某帧
		*@param value 帧索引
		*
		*/
		__proto._displayToIndex=function(value){}
		/**清理。方便对象复用。*/
		__proto.clear=function(){
			this.stop();
			this._labels=null;
		}

		/**播放间隔(单位：毫秒)。*/
		/**播放间隔(单位：毫秒)。*/
		__getset(0,__proto,'interval',function(){
			return this._interval;
			},function(value){
			if (this._interval !=value){
				this._frameRateChanged=true;
				this._interval=value;
				if (this._isPlaying && value > 0){
					this.timerLoop(value,this,this._frameLoop,null,true);
				}
			}
		});

		/**
		*是否在播放中
		*/
		__getset(0,__proto,'isPlaying',function(){
			return this._isPlaying;
		});

		/**当前播放索引。*/
		__getset(0,__proto,'index',function(){
			return this._index;
			},function(value){
			this._index=value;
			this._displayToIndex(value);
			if (this._labels && this._labels[value])this.event("label",this._labels[value]);
		});

		/**动画长度。*/
		__getset(0,__proto,'count',function(){
			return this._count;
		});

		return AnimationPlayerBase;
	})(Sprite)


	/**
	*<p> <code>Text</code> 类用于创建显示对象以显示文本。</p>
	*@example 以下示例代码，创建了一个 <code>Text</code> 实例。
	*<listing version="3.0">
	*package
	*{
		*import laya.display.Text;
		*public class Text_Example
		*{
			*public function Text_Example()
			*{
				*Laya.init(640,800);//设置游戏画布宽高、渲染模式。
				*Laya.stage.bgColor="#efefef";//设置画布的背景颜色。
				*onInit();
				*}
			*private function onInit():void
			*{
				*var text:Text=new Text();//创建一个 Text 类的实例对象 text 。
				*text.text="这个是一个 Text 文本示例。";
				*text.color="#008fff";//设置 text 的文本颜色。
				*text.font="Arial";//设置 text 的文本字体。
				*text.bold=true;//设置 text 的文本显示为粗体。
				*text.fontSize=30;//设置 text 的字体大小。
				*text.wordWrap=true;//设置 text 的文本自动换行。
				*text.x=100;//设置 text 对象的属性 x 的值，用于控制 text 对象的显示位置。
				*text.y=100;//设置 text 对象的属性 y 的值，用于控制 text 对象的显示位置。
				*text.width=300;//设置 text 的宽度。
				*text.height=200;//设置 text 的高度。
				*text.italic=true;//设置 text 的文本显示为斜体。
				*text.borderColor="#fff000";//设置 text 的文本边框颜色。
				*Laya.stage.addChild(text);//将 text 添加到显示列表。
				*}
			*}
		*}
	*</listing>
	*<listing version="3.0">
	*Text_Example();
	*function Text_Example()
	*{
		*Laya.init(640,800);//设置游戏画布宽高、渲染模式。
		*Laya.stage.bgColor="#efefef";//设置画布的背景颜色。
		*onInit();
		*}
	*function onInit()
	*{
		*var text=new laya.display.Text();//创建一个 Text 类的实例对象 text 。
		*text.text="这个是一个 Text 文本示例。";
		*text.color="#008fff";//设置 text 的文本颜色。
		*text.font="Arial";//设置 text 的文本字体。
		*text.bold=true;//设置 text 的文本显示为粗体。
		*text.fontSize=30;//设置 text 的字体大小。
		*text.wordWrap=true;//设置 text 的文本自动换行。
		*text.x=100;//设置 text 对象的属性 x 的值，用于控制 text 对象的显示位置。
		*text.y=100;//设置 text 对象的属性 y 的值，用于控制 text 对象的显示位置。
		*text.width=300;//设置 text 的宽度。
		*text.height=200;//设置 text 的高度。
		*text.italic=true;//设置 text 的文本显示为斜体。
		*text.borderColor="#fff000";//设置 text 的文本边框颜色。
		*Laya.stage.addChild(text);//将 text 添加到显示列表。
		*}
	*</listing>
	*<listing version="3.0">
	*class Text_Example {
		*constructor(){
			*Laya.init(640,800);//设置游戏画布宽高、渲染模式。
			*Laya.stage.bgColor="#efefef";//设置画布的背景颜色。
			*this.onInit();
			*}
		*private onInit():void {
			*var text:laya.display.Text=new laya.display.Text();//创建一个 Text 类的实例对象 text 。
			*text.text="这个是一个 Text 文本示例。";
			*text.color="#008fff";//设置 text 的文本颜色。
			*text.font="Arial";//设置 text 的文本字体。
			*text.bold=true;//设置 text 的文本显示为粗体。
			*text.fontSize=30;//设置 text 的字体大小。
			*text.wordWrap=true;//设置 text 的文本自动换行。
			*text.x=100;//设置 text 对象的属性 x 的值，用于控制 text 对象的显示位置。
			*text.y=100;//设置 text 对象的属性 y 的值，用于控制 text 对象的显示位置。
			*text.width=300;//设置 text 的宽度。
			*text.height=200;//设置 text 的高度。
			*text.italic=true;//设置 text 的文本显示为斜体。
			*text.borderColor="#fff000";//设置 text 的文本边框颜色。
			*Laya.stage.addChild(text);//将 text 添加到显示列表。
			*}
		*}
	*</listing>
	*/
	//class laya.display.Text extends laya.display.Sprite
	var Text=(function(_super){
		function Text(){
			this._clipPoint=null;
			this._currBitmapFont=null;
			this._text=null;
			this._isChanged=false;
			this._textWidth=0;
			this._textHeight=0;
			this._lines=[];
			this._lineWidths=[];
			this._startX=NaN;
			this._startY=NaN;
			this._lastVisibleLineIndex=-1;
			this._words=null;
			this._charSize={};
			this.underline=false;
			this._underlineColor=null;
			Text.__super.call(this);
			this.overflow=Text.VISIBLE;
			this._style=new CSSStyle(this);
			(this._style).wordWrap=false;
		}

		__class(Text,'laya.display.Text',_super);
		var __proto=Text.prototype;
		/**@inheritDoc */
		__proto.destroy=function(destroyChild){
			(destroyChild===void 0)&& (destroyChild=true);
			_super.prototype.destroy.call(this,destroyChild);
			this._lines=null;
			if (this._words){
				this._words.length=0;
				this._words=null;
			}
		}

		/**
		*@private
		*@inheritDoc
		*/
		__proto._getBoundPointsM=function(ifRotate){
			(ifRotate===void 0)&& (ifRotate=false);
			var rec=Rectangle.TEMP;
			rec.setTo(0,0,this.width,this.height);
			return rec._getBoundPoints();
		}

		/**
		*@inheritDoc
		*/
		__proto.getGraphicBounds=function(){
			var rec=Rectangle.TEMP;
			rec.setTo(0,0,this.width,this.height);
			return rec;
		}

		/**
		*@private
		*@inheritDoc
		*/
		__proto._getCSSStyle=function(){
			return this._style;
		}

		/**
		*<p>根据指定的文本，从语言包中取当前语言的文本内容。并对此文本中的{i}文本进行替换。</p>
		*<p>例如：
		*<li>（1）text 的值为“我的名字”，先取到这个文本对应的当前语言版本里的值“My name”，将“My name”设置为当前文本的内容。</li>
		*<li>（2）text 的值为“恭喜你赢得{0}个钻石，{1}经验。”，arg1 的值为100，arg2 的值为200。
		*则先取到这个文本对应的当前语言版本里的值“Congratulations on your winning {0}diamonds,{1}experience.”，
		*然后将文本里的{0}、{1}，依据括号里的数字从0开始替换为 arg1、arg2 的值。
		*将替换处理后的文本“Congratulations on your winning 100 diamonds,200 experience.”设置为当前文本的内容。
		*</li>
		*</p>
		*@param text 文本内容。
		*@param ...args 文本替换参数。
		*/
		__proto.lang=function(text,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10){
			text=Text.langPacks && Text.langPacks[text] ? Text.langPacks[text] :text;
			if (arguments.length < 2){
				this._text=text;
				}else {
				for (var i=0,n=arguments.length;i < n;i++){
					text=text.replace("{"+i+"}",arguments[i+1]);
				}
				this._text=text;
			}
		}

		/**
		*渲染文字。
		*@param begin 开始渲染的行索引。
		*@param visibleLineCount 渲染的行数。
		*/
		__proto.renderText=function(begin,visibleLineCount){
			var graphics=this.graphics;
			graphics.clear();
			var ctxFont=(this.italic ? "italic " :"")+(this.bold ? "bold " :"")+this.fontSize+"px "+this.font;
			Browser.context.font=ctxFont;
			var padding=this.padding;
			var startX=padding[3];
			var textAlgin="left";
			var lines=this._lines;
			var lineHeight=this.leading+this._charSize.height;
			var tCurrBitmapFont=this._currBitmapFont;
			if (tCurrBitmapFont){
				lineHeight=this.leading+tCurrBitmapFont.getMaxHeight();
			};
			var startY=padding[0];
			if ((!tCurrBitmapFont)&& this._width > 0 && this._textWidth <=this._width){
				if (this.align=="right"){
					textAlgin="right";
					startX=this._width-padding[1];
					}else if (this.align=="center"){
					textAlgin="center";
					startX=this._width *0.5+padding[3]-padding[1];
				}
			}
			if (this._height > 0){
				var tempVAlign=(this._textHeight > this._height)? "top" :this.valign;
				if (tempVAlign==="middle")
					startY=(this._height-visibleLineCount *lineHeight)*0.5+padding[0]-padding[2];
				else if (tempVAlign==="bottom")
				startY=this._height-visibleLineCount *lineHeight-padding[2];
			};
			var style=this._style;
			if (tCurrBitmapFont && tCurrBitmapFont.autoScaleSize){
				var bitmapScale=tCurrBitmapFont.fontSize / this.fontSize;
			}
			if (this._clipPoint){
				graphics.save();
				if (tCurrBitmapFont && tCurrBitmapFont.autoScaleSize){
					var tClipWidth=0;
					var tClipHeight=0;
					this._width ? tClipWidth=(this._width-padding[3]-padding[1]):tClipWidth=this._textWidth;
					this._height ? tClipHeight=(this._height-padding[0]-padding[2]):tClipHeight=this._textHeight;
					tClipWidth *=bitmapScale;
					tClipHeight *=bitmapScale;
					graphics.clipRect(padding[3],padding[0],tClipWidth,tClipHeight);
					}else {
					graphics.clipRect(padding[3],padding[0],this._width ? (this._width-padding[3]-padding[1]):this._textWidth,this._height ? (this._height-padding[0]-padding[2]):this._textHeight);
				}
			};
			var password=style.password;
			if (("prompt" in this)&& this['prompt']==this._text)
				password=false;
			var x=0,y=0;
			var end=Math.min(this._lines.length,visibleLineCount+begin)|| 1;
			for (var i=begin;i < end;i++){
				var word=lines[i];
				var _word;
				if (password){
					var len=word.length;
					word="";
					for (var j=len;j > 0;j--){
						word+="●";
					}
				}
				x=startX-(this._clipPoint ? this._clipPoint.x :0);
				y=startY+lineHeight *i-(this._clipPoint ? this._clipPoint.y :0);
				this.underline && this.drawUnderline(textAlgin,x,y,i);
				if (tCurrBitmapFont){
					var tWidth=this.width;
					if (tCurrBitmapFont.autoScaleSize){
						tWidth=this.width *bitmapScale;
					}
					tCurrBitmapFont.drawText(word,this,x,y,this.align,tWidth);
					}else {
					if (Render.isWebGL){
						this._words || (this._words=[]);
						_word=this._words.length > (i-begin)? this._words[i-begin] :new WordText();
						_word.setText(word);
						}else {
						_word=word;
					}
					style.stroke ? graphics.fillBorderText(_word,x,y,ctxFont,this.color,style.strokeColor,style.stroke,textAlgin):graphics.fillText(_word,x,y,ctxFont,this.color,textAlgin);
				}
			}
			if (tCurrBitmapFont && tCurrBitmapFont.autoScaleSize){
				var tScale=1 / bitmapScale;
				this.scale(tScale,tScale);
			}
			if (this._clipPoint)
				graphics.restore();
			this._startX=startX;
			this._startY=startY;
		}

		/**
		*绘制下划线
		*@param x 本行坐标
		*@param y 本行坐标
		*@param lineIndex 本行索引
		*/
		__proto.drawUnderline=function(align,x,y,lineIndex){
			var lineWidth=this._lineWidths[lineIndex];
			switch (align){
				case 'center':
					x-=lineWidth / 2;
					break ;
				case 'right':
					x-=lineWidth;
					break ;
				case 'left':
				default :
					break ;
				}
			y+=this._charSize.height;
			this._graphics.drawLine(x,y,x+lineWidth,y,this.underlineColor || this.color,1);
		}

		/**
		*<p>排版文本。</p>
		*<p>进行宽高计算，渲染、重绘文本。</p>
		*/
		__proto.typeset=function(){
			this._isChanged=false;
			if (!this._text){
				this._clipPoint=null;
				this._textWidth=this._textHeight=0;
				this.graphics.clear();
				return;
			}
			Browser.context.font=this._getCSSStyle().font;
			this._lines.length=0;
			this._lineWidths.length=0;
			this.parseLines(this._text);
			this.evalTextSize();
			if (this.checkEnabledViewportOrNot())
				this._clipPoint || (this._clipPoint=new Point(0,0));
			else
			this._clipPoint=null;
			var lineCount=this._lines.length;
			if (this.overflow !=Text.VISIBLE){
				var func=this.overflow==Text.HIDDEN ? Math.floor :Math.ceil;
				lineCount=Math.min(lineCount,func((this.height-this.padding[0]-this.padding[2])/ (this.leading+this._charSize.height)));
			};
			var startLine=this.scrollY / (this._charSize.height+this.leading)| 0;
			this.renderText(startLine,lineCount);
			this.repaint();
		}

		__proto.evalTextSize=function(){
			var nw=NaN,nh=NaN;
			nw=Math.max.apply(this,this._lineWidths);
			if (this._currBitmapFont)
				nh=this._lines.length *(this._currBitmapFont.getMaxHeight()+this.leading)+this.padding[0]+this.padding[2];
			else
			nh=this._lines.length *(this._charSize.height+this.leading)+this.padding[0]+this.padding[2];
			if (nw !=this._textWidth || nh !=this._textHeight){
				this._textWidth=nw;
				this._textHeight=nh;
				if (!this._width || !this._height)
					this.conchModel && this.conchModel.size(this._width || this._textWidth,this._height || this._textHeight);
			}
		}

		__proto.checkEnabledViewportOrNot=function(){
			return this.overflow==Text.SCROLL && ((this._width > 0 && this._textWidth > this._width)|| (this._height > 0 && this._textHeight > this._height));
		}

		/**
		*快速更改显示文本。不进行排版计算，效率较高。
		*<p>如果只更改文字内容，不更改文字样式，建议使用此接口，能提高效率。</p>
		*@param text 文本内容。
		*/
		__proto.changeText=function(text){
			if (this._text!==text){
				this.lang(text+"");
				if (this._graphics && this._graphics.replaceText(this._text)){
					}else {
					this.typeset();
				}
			}
		}

		/**
		*@private
		*分析文本换行。
		*/
		__proto.parseLines=function(text){
			var needWordWrapOrTruncate=this.wordWrap || this.overflow==Text.HIDDEN;
			if (needWordWrapOrTruncate){
				var wordWrapWidth=this.getWordWrapWidth();
			}
			if (this._currBitmapFont){
				this._charSize.width=this._currBitmapFont.getMaxWidth();
				this._charSize.height=this._currBitmapFont.getMaxHeight();
				}else {
				var measureResult=Browser.context.measureText(Text._testWord);
				this._charSize.width=measureResult.width;
				this._charSize.height=(measureResult.height || this.fontSize);
			};
			var lines=text.replace(/\r\n/g,"\n").split("\n");
			for (var i=0,n=lines.length;i < n;i++){
				if (i < n-1)
					lines[i]+="\n";
				var line=lines[i];
				if (needWordWrapOrTruncate)
					this.parseLine(line,wordWrapWidth);
				else {
					this._lineWidths.push(this.getTextWidth(line));
					this._lines.push(line);
				}
			}
		}

		/**
		*@private
		*解析行文本。
		*@param line 某行的文本。
		*@param wordWrapWidth 文本的显示宽度。
		*/
		__proto.parseLine=function(line,wordWrapWidth){
			var ctx=Browser.context;
			var lines=this._lines;
			var maybeIndex=0;
			var execResult;
			var charsWidth=NaN;
			var wordWidth=NaN;
			var startIndex=0;
			charsWidth=this.getTextWidth(line);
			if (charsWidth <=wordWrapWidth){
				lines.push(line);
				this._lineWidths.push(charsWidth);
				return;
			}
			charsWidth=this._charSize.width;
			maybeIndex=Math.floor(wordWrapWidth / charsWidth);
			(maybeIndex==0)&& (maybeIndex=1);
			charsWidth=this.getTextWidth(line.substring(0,maybeIndex));
			wordWidth=charsWidth;
			for (var j=maybeIndex,m=line.length;j < m;j++){
				charsWidth=this.getTextWidth(line.charAt(j));
				wordWidth+=charsWidth;
				if (wordWidth > wordWrapWidth){
					if (this.wordWrap){
						var newLine=line.substring(startIndex,j);
						if (newLine.charCodeAt(newLine.length-1)< 255){
							execResult=/[^\x20-]+$/.exec(newLine);
							if (execResult){
								j=execResult.index+startIndex;
								if (execResult.index==0)
									j+=newLine.length;
								else
								newLine=line.substring(startIndex,j);
							}
						}
						lines.push(newLine);
						this._lineWidths.push(wordWidth-charsWidth);
						startIndex=j;
						if (j+maybeIndex < m){
							j+=maybeIndex;
							charsWidth=this.getTextWidth(line.substring(startIndex,j));
							wordWidth=charsWidth;
							j--;
							}else {
							lines.push(line.substring(startIndex,m));
							this._lineWidths.push(this.getTextWidth(lines[lines.length-1]));
							startIndex=-1;
							break ;
						}
						}else if (this.overflow==Text.HIDDEN){
						lines.push(line.substring(0,j));
						this._lineWidths.push(this.getTextWidth(lines[lines.length-1]));
						return;
					}
				}
			}
			if (this.wordWrap && startIndex !=-1){
				lines.push(line.substring(startIndex,m));
				this._lineWidths.push(this.getTextWidth(lines[lines.length-1]));
			}
		}

		__proto.getTextWidth=function(text){
			if (this._currBitmapFont)
				return this._currBitmapFont.getTextWidth(text);
			else
			return Browser.context.measureText(text).width;
		}

		/**
		*获取换行所需的宽度。
		*/
		__proto.getWordWrapWidth=function(){
			var p=this.padding;
			var w=NaN;
			if (this._currBitmapFont && this._currBitmapFont.autoScaleSize)
				w=this._width *(this._currBitmapFont.fontSize / this.fontSize);
			else
			w=this._width;
			if (w <=0){
				w=this.wordWrap ? 100 :Browser.width;
			}
			w <=0 && (w=100);
			return w-p[3]-p[1];
		}

		/**
		*返回字符的位置信息。
		*@param charIndex 索引位置。
		*@param out 输出的Point引用。
		*@return 返回Point位置信息。
		*/
		__proto.getCharPoint=function(charIndex,out){
			this._isChanged && Laya.timer.runCallLater(this,this.typeset);
			var len=0,lines=this._lines,startIndex=0;
			for (var i=0,n=lines.length;i < n;i++){
				len+=lines[i].length;
				if (charIndex < len){
					var line=i;
					break ;
				}
				startIndex=len;
			};
			var ctxFont=(this.italic ? "italic " :"")+(this.bold ? "bold " :"")+this.fontSize+"px "+this.font;
			Browser.context.font=ctxFont;
			var width=this.getTextWidth(this._text.substring(startIndex,charIndex));
			var point=out || new Point();
			return point.setTo(this._startX+width-(this._clipPoint ? this._clipPoint.x :0),this._startY+line *(this._charSize.height+this.leading)-(this._clipPoint ? this._clipPoint.y :0));
		}

		/**
		*@inheritDoc
		*/
		__getset(0,__proto,'width',function(){
			if (this._width)
				return this._width;
			return this.textWidth+this.padding[1]+this.padding[3];
			},function(value){
			if (value !=this._width){
				_super.prototype._$set_width.call(this,value);
				this.isChanged=true;
			}
		});

		/**
		*表示文本的宽度，以像素为单位。
		*/
		__getset(0,__proto,'textWidth',function(){
			this._isChanged && Laya.timer.runCallLater(this,this.typeset);
			return this._textWidth;
		});

		/**
		*@inheritDoc
		*/
		__getset(0,__proto,'height',function(){
			if (this._height)return this._height;
			return this.textHeight+this.padding[0]+this.padding[2];
			},function(value){
			if (value !=this._height){
				_super.prototype._$set_height.call(this,value);
				this.isChanged=true;
			}
		});

		/**
		*表示文本的高度，以像素为单位。
		*/
		__getset(0,__proto,'textHeight',function(){
			this._isChanged && Laya.timer.runCallLater(this,this.typeset);
			return this._textHeight;
		});

		/**
		*边距信息。
		*<p>数据格式：[上边距，右边距，下边距，左边距]（边距以像素为单位）。</p>
		*/
		__getset(0,__proto,'padding',function(){
			return this._getCSSStyle().padding;
			},function(value){
			this._getCSSStyle().padding=value;
			this.isChanged=true;
		});

		/**
		*指定文本是否为粗体字。
		*<p>默认值为 false，这意味着不使用粗体字。如果值为 true，则文本为粗体字。</p>
		*/
		__getset(0,__proto,'bold',function(){
			return this._getCSSStyle().bold;
			},function(value){
			this._getCSSStyle().bold=value;
			this.isChanged=true;
		});

		/**当前文本的内容字符串。*/
		__getset(0,__proto,'text',function(){
			return this._text || "";
			},function(value){
			if (this._text!==value){
				this.lang(value+"");
				this.isChanged=true;
				this.event("change");
			}
		});

		/**
		*表示文本的颜色值。可以通过 <code>Text.defaultColor</code> 设置默认颜色。
		*<p>默认值为黑色。</p>
		*/
		__getset(0,__proto,'color',function(){
			return this._getCSSStyle().color;
			},function(value){
			if (this._getCSSStyle().color !=value){
				this._getCSSStyle().color=value;
				if (!this._isChanged && this._graphics){
					this._graphics.replaceTextColor(this.color)
					}else {
					this.isChanged=true;
				}
			}
		});

		/**
		*文本的字体名称，以字符串形式表示。
		*<p>默认值为："Arial"，可以通过Text.defaultFont设置默认字体。</p> *
		*@see laya.display.css.Font#defaultFamily
		*/
		__getset(0,__proto,'font',function(){
			return this._getCSSStyle().fontFamily;
			},function(value){
			if (this._currBitmapFont){
				this._currBitmapFont=null;
				this.scale(1,1);
			}
			if (Text._bitmapFonts && Text._bitmapFonts[value]){
				this._currBitmapFont=Text._bitmapFonts[value];
			}
			this._getCSSStyle().fontFamily=value;
			this.isChanged=true;
		});

		/**
		*指定文本的字体大小（以像素为单位）。
		*<p>默认为20像素，可以通过 <code>Text.defaultSize</code> 设置默认大小。</p>
		*/
		__getset(0,__proto,'fontSize',function(){
			return this._getCSSStyle().fontSize;
			},function(value){
			this._getCSSStyle().fontSize=value;
			this.isChanged=true;
		});

		/**
		*表示使用此文本格式的文本是否为斜体。
		*<p>默认值为 false，这意味着不使用斜体。如果值为 true，则文本为斜体。</p>
		*/
		__getset(0,__proto,'italic',function(){
			return this._getCSSStyle().italic;
			},function(value){
			this._getCSSStyle().italic=value;
			this.isChanged=true;
		});

		/**
		*表示文本的水平显示方式。
		*<p><b>取值：</b>
		*<li>"left"： 居左对齐显示。</li>
		*<li>"center"： 居中对齐显示。</li>
		*<li>"right"： 居右对齐显示。</li>
		*</p>
		*/
		__getset(0,__proto,'align',function(){
			return this._getCSSStyle().align;
			},function(value){
			this._getCSSStyle().align=value;
			this.isChanged=true;
		});

		/**
		*表示文本的垂直显示方式。
		*<p><b>取值：</b>
		*<li>"top"： 居顶部对齐显示。</li>
		*<li>"middle"： 居中对齐显示。</li>
		*<li>"bottom"： 居底部对齐显示。</li>
		*</p>
		*/
		__getset(0,__proto,'valign',function(){
			return this._getCSSStyle().valign;
			},function(value){
			this._getCSSStyle().valign=value;
			this.isChanged=true;
		});

		/**
		*表示文本是否自动换行，默认为false。
		*<p>若值为true，则自动换行；否则不自动换行。</p>
		*/
		__getset(0,__proto,'wordWrap',function(){
			return this._getCSSStyle().wordWrap;
			},function(value){
			this._getCSSStyle().wordWrap=value;
			this.isChanged=true;
		});

		/**
		*垂直行间距（以像素为单位）。
		*/
		__getset(0,__proto,'leading',function(){
			return this._getCSSStyle().leading;
			},function(value){
			this._getCSSStyle().leading=value;
			this.isChanged=true;
		});

		/**
		*文本背景颜色，以字符串表示。
		*/
		__getset(0,__proto,'bgColor',function(){
			return this._getCSSStyle().backgroundColor;
			},function(value){
			this._getCSSStyle().backgroundColor=value;
			this.isChanged=true;
		});

		/**
		*文本边框背景颜色，以字符串表示。
		*/
		__getset(0,__proto,'borderColor',function(){
			return this._getCSSStyle().borderColor;
			},function(value){
			this._getCSSStyle().borderColor=value;
			this.isChanged=true;
		});

		/**
		*<p>描边宽度（以像素为单位）。</p>
		*默认值0，表示不描边。
		*/
		__getset(0,__proto,'stroke',function(){
			return this._getCSSStyle().stroke;
			},function(value){
			this._getCSSStyle().stroke=value;
			this.isChanged=true;
		});

		/**
		*<p>描边颜色，以字符串表示。</p>
		*默认值为 "#000000"（黑色）;
		*/
		__getset(0,__proto,'strokeColor',function(){
			return this._getCSSStyle().strokeColor;
			},function(value){
			this._getCSSStyle().strokeColor=value;
			this.isChanged=true;
		});

		/**
		*一个布尔值，表示文本的属性是否有改变。若为true表示有改变。
		*/
		__getset(0,__proto,'isChanged',null,function(value){
			if (this._isChanged!==value){
				this._isChanged=value;
				value && Laya.timer.callLater(this,this.typeset);
			}
		});

		/**
		*设置横向滚动量。
		*<p>即使设置超出滚动范围的值，也会被自动限制在可能的最大值处。</p>
		*/
		/**
		*获取横向滚动量。
		*/
		__getset(0,__proto,'scrollX',function(){
			if (!this._clipPoint)
				return 0;
			return this._clipPoint.x;
			},function(value){
			if (this.overflow !=Text.SCROLL || (this.textWidth < this._width || !this._clipPoint))
				return;
			value=value < this.padding[3] ? this.padding[3] :value;
			var maxScrollX=this._textWidth-this._width;
			value=value > maxScrollX ? maxScrollX :value;
			var visibleLineCount=this._height / (this._charSize.height+this.leading)| 0+1;
			this._clipPoint.x=value;
			this.renderText(this._lastVisibleLineIndex,visibleLineCount);
		});

		/**
		*设置纵向滚动量（px)。即使设置超出滚动范围的值，也会被自动限制在可能的最大值处。
		*/
		/**
		*获取纵向滚动量。
		*/
		__getset(0,__proto,'scrollY',function(){
			if (!this._clipPoint)
				return 0;
			return this._clipPoint.y;
			},function(value){
			if (this.overflow !=Text.SCROLL || (this.textHeight < this._height || !this._clipPoint))
				return;
			value=value < this.padding[0] ? this.padding[0] :value;
			var maxScrollY=this._textHeight-this._height;
			value=value > maxScrollY ? maxScrollY :value;
			var startLine=value / (this._charSize.height+this.leading)| 0;
			this._lastVisibleLineIndex=startLine;
			var visibleLineCount=(this._height / (this._charSize.height+this.leading)| 0)+1;
			this._clipPoint.y=value;
			this.renderText(startLine,visibleLineCount);
		});

		/**
		*获取横向可滚动最大值。
		*/
		__getset(0,__proto,'maxScrollX',function(){
			return (this.textWidth < this._width)? 0 :this._textWidth-this._width;
		});

		/**
		*获取纵向可滚动最大值。
		*/
		__getset(0,__proto,'maxScrollY',function(){
			return (this.textHeight < this._height)? 0 :this._textHeight-this._height;
		});

		__getset(0,__proto,'lines',function(){
			return this._lines;
		});

		__getset(0,__proto,'underlineColor',function(){
			return this._underlineColor;
			},function(value){
			this._underlineColor=value;
			this._isChanged=true;
			this.typeset();
		});

		Text.registerBitmapFont=function(name,bitmapFont){
			Text._bitmapFonts || (Text._bitmapFonts={});
			Text._bitmapFonts[name]=bitmapFont;
		}

		Text.unregisterBitmapFont=function(name,destroy){
			(destroy===void 0)&& (destroy=true);
			if (Text._bitmapFonts && Text._bitmapFonts[name]){
				var tBitmapFont=Text._bitmapFonts[name];
				if (destroy){
					tBitmapFont.destroy();
				}
				delete Text._bitmapFonts[name];
			}
		}

		Text._testWord="游";
		Text.langPacks=null
		Text.VISIBLE="visible";
		Text.SCROLL="scroll";
		Text.HIDDEN="hidden";
		Text._bitmapFonts=null
		return Text;
	})(Sprite)


	/**
	*<p> <code>Stage</code> 类是显示对象的根节点。</p>
	*可以通过 Laya.stage 访问。
	*/
	//class laya.display.Stage extends laya.display.Sprite
	var Stage=(function(_super){
		function Stage(){
			this.focus=null;
			this.frameRate="fast";
			this.desginWidth=0;
			this.desginHeight=0;
			this.canvasRotation=false;
			this.canvasDegree=0;
			this.renderingEnabled=true;
			this._screenMode="none";
			this._scaleMode="noscale";
			this._alignV="top";
			this._alignH="left";
			this._bgColor="black";
			this._mouseMoveTime=0;
			this._renderCount=0;
			this._safariOffsetY=0;
			this._frameStartTime=NaN;
			this._previousOrientation=0;
			this._isFocused=false;
			this._isVisibility=false;
			this._scenes=null;
			Stage.__super.call(this);
			this.offset=new Point();
			this._canvasTransform=new Matrix();
			var _$this=this;
			this.transform=Matrix.create();
			this._scenes=[];
			this.mouseEnabled=true;
			this.hitTestPrior=true;
			this.autoSize=false;
			this._displayedInStage=true;
			this._isFocused=true;
			this._isVisibility=true;
			var _this=this;
			var window=Browser.window;
			window.addEventListener("focus",function(){
				_$this._isFocused=true;
				_this.event("focus");
				_this.event("focuschange");
			});
			window.addEventListener("blur",function(){
				_$this._isFocused=false;
				_this.event("blur");
				_this.event("focuschange");
				if (_this._isInputting())Input["inputElement"].target.focus=false;
			});
			var hidden="hidden",state="visibilityState",visibilityChange="visibilitychange";
			var document=window.document;
			if (typeof document.hidden!=="undefined"){
				visibilityChange="visibilitychange";
				state="visibilityState";
				}else if (typeof document.mozHidden!=="undefined"){
				visibilityChange="mozvisibilitychange";
				state="mozVisibilityState";
				}else if (typeof document.msHidden!=="undefined"){
				visibilityChange="msvisibilitychange";
				state="msVisibilityState";
				}else if (typeof document.webkitHidden!=="undefined"){
				visibilityChange="webkitvisibilitychange";
				state="webkitVisibilityState";
			}
			window.document.addEventListener(visibilityChange,visibleChangeFun);
			function visibleChangeFun (){
				if (Browser.document[state]=="hidden"){
					_$this._isVisibility=false;
					if (_this._isInputting())Input["inputElement"].target.focus=false;
					}else {
					_$this._isVisibility=true;
				}
				_this.event("visibilitychange");
			}
			window.addEventListener("resize",function(){
				var orientation=Browser.window.orientation;
				if (orientation !=null && orientation !=_$this._previousOrientation && _this._isInputting()){
					Input["inputElement"].target.focus=false;
				}
				_$this._previousOrientation=orientation;
				if (_this._isInputting())return;
				if (Browser.onS