﻿CKEDITOR.editorConfig = function (config) {
    CKFinder.setupCKEditor(null, 'Ckeditor/Ckfinder');
    var theme = "default";
    var linkTag = $("link[href*='base.css']");
    if (linkTag.length > 0) {
        var parts = linkTag.attr("href").split("/");
        if (parts.length > 1) theme = parts[parts.length - 2];
    }
    config.contentsCss = "App_Themes/" + theme + "/base.css";
    //if (theme == "Gray") {
    //    config.uiColor = "fbfbfb";
    //} else {
    //    config.uiColor = "fbfbfb";
    //}
    config.defaultLanguage = 'zh-cn';
    config.title = "";
    config.disableNativeTableHandles = false;
    config.linkShowAdvancedTab = false;
    config.dialog_noConfirmCancel = true;
    config.scayt_autoStartup = false;
    config.autoUpdateElement = false;
    config.toolbarCanCollapse = false;
    config.enterMode = CKEDITOR.ENTER_P;
    config.shiftEnterMode = CKEDITOR.ENTER_BR;
    config.skin = 'office2013';
    //config.autoGrow_onStartup = false;
    //config.autoGrow_minHeight = 300;
    config.height = 100;
    config.smiley_path = 'ckeditor/smileys/';
    config.smiley_columns = 17;
    config.smiley_images = ['0.gif', '1.gif', '2.gif', '3.gif', '4.gif', '5.gif', '6.gif', '7.gif', '8.gif', '9.gif', '10.gif',
        '11.gif', '12.gif', '13.gif', '14.gif', '15.gif', '16.gif', '17.gif', '18.gif', '19.gif', '20.gif', '21.gif', '22.gif',
        '23.gif', '24.gif', '25.gif', '26.gif', '27.gif', '28.gif', '29.gif', '30.gif', '31.gif', '32.gif', '33.gif', '34.gif',
        '35.gif', '36.gif', '37.gif', '38.gif', '39.gif', '40.gif', '41.gif', '42.gif', '43.gif', '44.gif', '45.gif', '46.gif',
        '47.gif', '48.gif', '49.gif', '50.gif', '51.gif', '52.gif', '53.gif', '54.gif', '55.gif', '56.gif', '57.gif', '58.gif',
        '59.gif', '60.gif', '61.gif', '62.gif', '63.gif', '64.gif', '65.gif', '66.gif', '67.gif'];
    config.smiley_descriptions = [
        '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',
        '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',
        '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',
        '', '', '', '', '', '', '', ''];
    config.font_names = '宋体;黑体;楷体/楷体,楷体_GB2312;仿宋/仿宋,仿宋_GB2312;隶书;Arial;Comic Sans MS;Courier New;Tahoma;Times New Roman;Verdana';
    config.stylesSet = [
        { name: '段落首行缩进', element: 'p', styles: { 'text-indent': '2em'} },
        { name: '蓝色标题', element: 'h2', styles: { 'color': 'Blue'} },
        { name: '红色标题', element: 'h3', styles: { 'color': 'Red'} },
        { name: '浅灰区块', element: 'div', attributes: { 'class': 'box'} },
        { name: '浅蓝区块', element: 'div', attributes: { 'class': 'bluebox'} },
        { name: '虚线下框', element: 'p', styles: { 'border-bottom': '#bbb 1px dotted'} },
        { name: '强调', element: 'span', styles: { 'color': 'Red', 'font-weight': 'bold'} },
        { name: '1.2倍行距', element: 'p', styles: { 'line-height': '1.2'} },
        { name: '1.5倍行距', element: 'p', styles: { 'line-height': '1.5'} },
        { name: '1.8倍行距', element: 'p', styles: { 'line-height': '1.8'} }
    ];
    config.stylesheetParser_skipSelectors = /(^\w+\.|^\.)/i;
    config.toolbar_Min = [
	['TextColor', 'BGColor', 'Bold', 'Italic', 'NumberedList', 'BulletedList', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'Link', 'Image', 'FontSize']
    ];
    config.toolbar_Compact = [
	['Maximize', 'TextColor', 'BGColor', 'Bold', 'Italic', 'NumberedList', 'BulletedList', 'JustifyLeft', 'JustifyCenter', 'JustifyRight'],
	['Link', 'Image', 'Table', 'Smiley'],
	['FontSize']
    ];
    config.toolbar_Lesser = [
	['TextColor', 'BGColor', 'Bold', 'Italic'],
	['JustifyLeft', 'JustifyCenter', 'JustifyRight', 'Indent'],
	['NumberedList', 'BulletedList', 'Undo'],
	['Link', 'Image', 'Table'],
	['FontSize', 'Styles', 'Source']
    ];
    config.toolbar_Normal = [
	['Maximize', 'TextColor', 'BGColor', 'Bold', 'Italic'],
	['JustifyLeft', 'JustifyCenter', 'JustifyRight', 'Indent'],
	['NumberedList', 'BulletedList', 'RemoveFormat'],
	['Link', 'Image', 'Table', 'tabs'],
	['HorizontalRule', 'PageBreak', 'Smiley'],
	['Font', 'FontSize', 'Styles', 'Source']
    ];
    config.toolbar_Advanced = [
	['Maximize', 'Cut', 'Copy', 'Paste', 'PasteText', 'PasteFromWord'],
	['TextColor', 'BGColor', 'Bold', 'Italic', 'Underline'], //, 'Strike', 'Superscript'
	['JustifyLeft', 'JustifyCenter', 'JustifyRight', 'Indent'],//, 'Outdent'
	['NumberedList', 'BulletedList', 'RemoveFormat', 'Undo', 'Redo'],
	['Link', 'Unlink', 'Image', 'Table', 'tabs'],
	['Find', 'HorizontalRule', 'PageBreak', 'Smiley'],
	['Font', 'FontSize', 'Styles', 'Sourcedialog']
    ];
    config.toolbar = 'Compact';
    config.allowedContent = true; //使得切换到源码视图后不会丢失HTML自定义属性
    //base64image、pastebase64、codemirror
    config.extraPlugins = 'tabs,quicktable,sourcedialog,pastebase64,codemirror';
    config.codemirror = { lineNumbers: false, mode: 'text/html' },
    config.sourceAreaTabSize = 4;
    //以下为quicktable插件配置
    config.qtClass = "normal";
    config.qtWidth = "100%";
    //config.qtRows = 5;
    config.qtColumns = 8;
};