﻿<%@ page language="C#" autoeventwireup="true" inherits="ims.web.chart, ims.web" enableviewstatemac="false" enableEventValidation="false" %>
<!DOCTYPE html>
<html id="chart">
<head runat="server"><title></title>
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <script src="js/comm.js"></script><script src="js/chart.js"></script>
</head>
<body>
    <form id="form1" runat="server">
        <asp:ScriptManager ID="sm" runat="server" OnAsyncPostBackError="AsyncError" />
        <div runat="server" id="EmptyPrompt" visible="false" class="highlight corner"></div>
        <div id="loading"><img src="images/loading.gif" />正在生成图表，请稍候…</div>
        <asp:UpdatePanel ID="main" runat="server" UpdateMode="Conditional">
            <ContentTemplate>
		        <img runat="server" id="imgChart" style="display:none" /><br /><br />
            </ContentTemplate>
        </asp:UpdatePanel>

    <asp:UpdatePanel ID="upSetting" runat="server" OnPreRender="AddInitScript" UpdateMode="Conditional">
        <ContentTemplate>
        <table class="fieldtab fixedLayout">
            <tr>
                <td class="lborder"></td><td class="headText">图表设置</td>
                <td class="rpad right">
	                <asp:DropDownList runat="server" ID="ddlCharts" AutoPostBack="true" OnSelectedIndexChanged="SwitchChart" onchange="showLoading();"></asp:DropDownList>
                </td>
            </tr>
            <tr>
                <td colspan="3" class="content">
	                <table><tr><td style="width:49%">
	                    <ul>
	                        <li title="选择要生成的图表的类型">图表类型：<asp:RadioButtonList Runat="server" ID="rblType" RepeatLayout="Flow" RepeatColumns="2">
                            <asp:ListItem Selected="True" Value="0">柱状图</asp:ListItem>
                            <asp:ListItem Value="1">排列图</asp:ListItem>
                          </asp:RadioButtonList></li>
	                        <li title="要分析的，图表横坐标所代表的字段">统计字段： <asp:DropDownList Runat="server" ID="ddlXs"></asp:DropDownList></li>
	                        <li title="作为统计指标的，图表纵坐标所代表的字段">统计指标： <asp:DropDownList Runat="server" ID="ddlYs"></asp:DropDownList></li>
	                    </ul>
	                </td><td style="width:49%" class="vtop">
	                    <ul>
	                        <li title="对于横坐标上的每一段，计算其纵坐标值的方法">统计方法： <asp:DropDownList Runat="server" ID="ddlStatMode" Width="74">
                            <asp:ListItem Value="sum">合计</asp:ListItem>
                            <asp:ListItem Value="avg">平均值</asp:ListItem>
                            <asp:ListItem Value="max">最大值</asp:ListItem>
                            <asp:ListItem Value="min">最小值</asp:ListItem>
                            <asp:ListItem Value="var">方差</asp:ListItem>
                            <asp:ListItem Value="stdev">标准偏差</asp:ListItem>
                            <asp:ListItem Value="count">计数</asp:ListItem>
                          </asp:DropDownList></li>
	                        <li id="liSeps" title="设置如何确定横坐标上的各个区段">分组方法： <asp:DropDownList runat="server" ID="ddlGroupby"><asp:ListItem Selected="True" Value="All">按所有值分组</asp:ListItem><asp:ListItem Value="Auto">自动分组</asp:ListItem><asp:ListItem Value="Specified">手动分组</asp:ListItem></asp:DropDownList>
                                <asp:DropDownList runat="server" ID="ddlTimeSpan"></asp:DropDownList>
                                <asp:TextBox ID="SepValues" Width="200" runat="server"></asp:TextBox></li>
	                        <li title="根据纵坐标的值，对横坐标上的字段进行排序的排序方向">排序方式： <asp:DropDownList Runat="server" ID="ddlSortMode">
                            <asp:ListItem Value="">无</asp:ListItem>
                            <asp:ListItem Value="ASC">纵坐标升序</asp:ListItem>
                            <asp:ListItem Selected="True" Value="DESC">纵坐标降序</asp:ListItem>
                            <asp:ListItem Value="_ASC">横坐标升序</asp:ListItem>
                            <asp:ListItem Value="_DESC">横坐标降序</asp:ListItem>
                          </asp:DropDownList></li>
	                    </ul>
	                </td></tr></table>
                </td>
            </tr>
        </table>
        </ContentTemplate>
    </asp:UpdatePanel>

        <asp:UpdatePanel ID="upBtnArea" runat="server" UpdateMode="Conditional" ChildrenAsTriggers="false" class="footBtnArea bigger">
            <ContentTemplate>
	            <asp:Button ID="btnBuild" runat="server" Text="生成图表" OnClick="Build" OnClientClick="toggleLoading(false);" CssClass="btn" />
                <input type="button" runat="server" ID="btnSave" onclick="return toSave();" value="保存设置" onserverclick="SaveSetting" class="btn" />
	            <input type="button" runat="server" ID="btnManage" value="图表管理" onserverclick="ManageCharts" class="btn" />
	            <input type="button" runat="server" id="btnPrint" class="btn" onclick="printPrompt();" value="打印" />
	            <input type="button" onclick="back();" value="返回" class="btn" />
            </ContentTemplate>
        </asp:UpdatePanel>

        <ims:Pop runat="server" ID="m" ShowOkButton="false" HideOnOkClientClick="false" CanelButtonText="关闭" HelpSubject="chartManage" Title="管理图表" CustomCss="noline">
            <ContentTemplate>
                <div runat="server" id="allCharts">
                    <table class="normal center">
                        <tr><th>图表名称</th><th style="width:60px">设为默认</th><th style="width:32px">更名</th><th style="width:32px">删除</th></tr>
                        <asp:PlaceHolder runat="server" ID="phCharts"></asp:PlaceHolder>
                    </table>
                </div>
                <fieldset class="mtop_n mbottom_s"><legend>默认图表规则</legend>
                    <div class="padbox">
                        <ol runat="server" id="olRules" class="olRules"></ol>
                        <div class="right"><a href="#" id="aAddRule" onclick="return toAddRule();" runat="server" onserverclick="ToAddRule" class="u">添加规则</a></div>
                    </div>
                </fieldset>
            </ContentTemplate>
        </ims:Pop>
        <ims:Pop runat="server" ID="rule" ShowProgress="false" CustomCss="noline" OnClientUpdated="setTimeout(initRule,0);" Width="410" OnOkClick="SaveRule" HideOnOkClientClick="false">
            <ContentTemplate>
                <table class="fixedLayout">
                    <tr><td class="ruleKey">指定角色：</td><td><asp:TextBox runat="server" ID="tbRoles" TextMode="MultiLine" Rows="3" Width="99%" acfid="RoleName" chars=";；,，、" ToolTip="输入角色名。多项之间以逗号、分号或顿号分隔"></asp:TextBox></td></tr>
                    <tr><td class="ruleKey">默认图表：</td><td><asp:DropDownList runat="server" ID="ddlAll"></asp:DropDownList></td></tr>
                </table>
            </ContentTemplate>
        </ims:Pop>
    </form>
</body>
</html>
