﻿<%@ page language="C#" autoeventwireup="true" inherits="ims.web.reg, ims.web" trace="false" enableviewstatemac="false" enableEventValidation="false" %>
<!DOCTYPE html>
<html id="reg">
<head runat="server">
    <title><%= ViewState["title"] %></title>
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
</head>
<body>
    <form id="form1" runat="server">
        <asp:ScriptManager ID="s1" runat="server" OnAsyncPostBackError="AsyncError" />
        <asp:ValidationSummary ID="ValSum" runat="server" ShowMessageBox="True" ShowSummary="False"></asp:ValidationSummary>
        <div class="pageTitle"><%= ViewState["title"] %></div>
        <table class="hr mbottom_s mtop_l">
            <tr runat="server" id="tr_UserName">
                <td class="col1">用户名<span class="required">*</span>：</td>
                <td class="col2">
                    <asp:UpdatePanel ID="up1" RenderMode="inline" runat="server">
                        <ContentTemplate>
                            <asp:TextBox runat="server" ID="userName" OnTextChanged="chkName" AutoPostBack="true" MaxLength="50"></asp:TextBox>
                        </ContentTemplate>
                    </asp:UpdatePanel>
                    <asp:RequiredFieldValidator SetFocusOnError="true"
                        ID="RequiredVal_userName" ControlToValidate="userName" runat="server" Display="None" ErrorMessage="请输入用户名！"></asp:RequiredFieldValidator></td>
                <td class="col3">注册用户名长度限制为1－50字</td>
            </tr>
            <tr runat="server" id="tr_realName">
                <td class="col1">真实姓名<span class="required" runat="server" id="required_realName">*</span>：</td>
                <td class="col2">
                    <asp:TextBox runat="server" ID="realName" MaxLength="50"></asp:TextBox>
                    <asp:RequiredFieldValidator ID="RequiredVal_realName" runat="server" ControlToValidate="realName" ErrorMessage="请输入真实姓名！" Display="None"></asp:RequiredFieldValidator>
                    <asp:RegularExpressionValidator ID="RegularVal_realName" runat="server" SetFocusOnError="true" ValidationExpression=".{2,50}" ControlToValidate="realName" Display="None" ErrorMessage="姓名长度必须介于2到50之间！"></asp:RegularExpressionValidator>
                </td>
                <td class="col3"></td>
            </tr>
            <tr runat="server" id="tr_Sex">
                <td class="col1">性别：</td>
                <td class="col2">
                    <asp:RadioButtonList runat="server" ID="sex" RepeatDirection="Horizontal" RepeatLayout="Flow">
                        <asp:ListItem Text="男　" Value="true" Selected="True" />
                        <asp:ListItem Text="女" Value="false" />
                    </asp:RadioButtonList></td>
                <td class="col3">请选择您的性别</td>
            </tr>
            <tr runat="server" id="tr_PassWord">
                <td class="col1">登录密码<span class="required">*</span>：</td>
                <td class="col2">
                    <asp:TextBox runat="server" TextMode="Password" ID="passWord" MaxLength="128"></asp:TextBox>
                    <asp:RequiredFieldValidator ID="RequiredVal_passWord" runat="server" ControlToValidate="passWord" ErrorMessage="请输入密码！" Display="None"></asp:RequiredFieldValidator>
                    <asp:RegularExpressionValidator ID="RegularVal_passWord" runat="server" SetFocusOnError="true" ValidationExpression="^\S{3,128}$" ControlToValidate="passWord" Display="None" ErrorMessage="输入的密码不符合要求！"></asp:RegularExpressionValidator></td>
                <td class="col3" runat="server" id="PwdComment">请输入密码，区分大小写</td>
            </tr>
            <tr runat="server" id="tr_rePassWord">
                <td class="col1">确认密码<span class="required">*</span>：</td>
                <td class="col2">
                    <asp:TextBox ID="rePassWord" TextMode="Password" runat="server" MaxLength="128"></asp:TextBox>
                    <asp:RequiredFieldValidator ID="RequiredVal_rePassWord" runat="server" ControlToValidate="rePassWord" ErrorMessage="请输入确认密码！" Display="None"></asp:RequiredFieldValidator>
                    <asp:CompareValidator ID="CompareVal_rePassWord" runat="server" ControlToCompare="passWord"
                        ControlToValidate="rePassWord" Display="None" ErrorMessage="两次密码输入不一致！"></asp:CompareValidator></td>
                <td class="col3">请再输入一次密码，以确认输入是正确的</td>
            </tr>
            <tr runat="server" id="tr_Phone">
                <td class="col1">电话号码<span class="required" runat="server" id="required_phone">*</span>：</td>
                <td class="col2">
                    <asp:TextBox runat="server" AutoCompleteType="BusinessPhone" ID="phone"></asp:TextBox>
                    <asp:RequiredFieldValidator ID="RequiredVal_phone" runat="server" ControlToValidate="phone" ErrorMessage="请输入电话号码！" Display="None"></asp:RequiredFieldValidator>
                    <asp:RegularExpressionValidator ID="RegularVal_phone" runat="server" SetFocusOnError="true" ValidationExpression=".{7,}" ControlToValidate="phone" Display="None" ErrorMessage="请输入有效的电话号码！"></asp:RegularExpressionValidator>
                </td>
                <td class="col3"></td>
            </tr>
            <tr runat="server" id="tr_Weixin">
                <td class="col1">微信帐号<span class="required" runat="server" id="required_wxAccount">*</span>：</td>
                <td class="col2">
                    <asp:TextBox runat="server" ID="wxAccount"></asp:TextBox>
                    <asp:RequiredFieldValidator ID="RequiredVal_wxAccount" runat="server" ControlToValidate="wxAccount" ErrorMessage="请输入微信帐号！" Display="None"></asp:RequiredFieldValidator>
                    <asp:RegularExpressionValidator ID="RegularVal_wxAccount" runat="server" SetFocusOnError="true" ValidationExpression="\w{2,50}" ControlToValidate="wxAccount" Display="None" ErrorMessage="请输入有效的微信帐号！"></asp:RegularExpressionValidator>
                </td>
                <td class="col3">请输入微信号，以便接收可能由系统发出的微信消息</td>
            </tr>
            <tr runat="server" id="tr_Address">
                <td class="col1">地址<span class="required" runat="server" id="required_address">*</span>：</td>
                <td class="col2">
                    <asp:TextBox runat="server" AutoCompleteType="BusinessStreetAddress" ID="address"></asp:TextBox>
                    <asp:RequiredFieldValidator ID="RequiredVal_address" runat="server" ControlToValidate="address"
                        Display="None" ErrorMessage="请输入地址！"></asp:RequiredFieldValidator>
                    <asp:RegularExpressionValidator ID="RegularVal_address" runat="server" ControlToValidate="address"
                        Display="None" ErrorMessage="请输入有效的联系地址！" SetFocusOnError="true" ValidationExpression=".{2,}"></asp:RegularExpressionValidator>
                </td>
                <td class="col3">请输入详细的联系地址，以便必要时提供递送服务</td>
            </tr>
            <tr runat="server" id="tr_Zip">
                <td class="col1">邮编<span class="required" runat="server" id="required_zip">*</span>：</td>
                <td class="col2">
                    <asp:TextBox runat="server" AutoCompleteType="BusinessZipCode" ID="zip"></asp:TextBox>
                    <asp:RequiredFieldValidator ID="RequiredVal_zip" runat="server" ControlToValidate="zip"
                        Display="None" ErrorMessage="请输入邮编！"></asp:RequiredFieldValidator>
                    <asp:RegularExpressionValidator ID="RegularVal_zip" runat="server" ControlToValidate="zip"
                        Display="None" ErrorMessage="请输入有效的邮政编码！" SetFocusOnError="true" ValidationExpression="\d{6}"></asp:RegularExpressionValidator>
                </td>
                <td class="col3">请输入与联系地址对应的邮政编码</td>
            </tr>
            <tr runat="server" id="tr_Question">
                <td class="col1">密码问题<span class="required" runat="server" id="required_question">*</span>：</td>
                <td class="col2">
                    <asp:TextBox runat="server" ID="question"></asp:TextBox>
                    <asp:RequiredFieldValidator ID="RequiredVal_question" runat="server" ControlToValidate="question"
                        Display="None" ErrorMessage="请输入密码问题！"></asp:RequiredFieldValidator>
                    <asp:RegularExpressionValidator ID="RegularVal_question" runat="server" ControlToValidate="question"
                        Display="None" ErrorMessage="密码问题字数太少！" SetFocusOnError="true" ValidationExpression="\S.*"></asp:RegularExpressionValidator>
                </td>
                <td class="col3">取回密码的提示问题</td>
            </tr>
            <tr runat="server" id="tr_Answer">
                <td class="col1">问题答案<span class="required" runat="server" id="required_answer">*</span>：</td>
                <td class="col2">
                    <asp:TextBox runat="server" ID="answer"></asp:TextBox>
                    <asp:RequiredFieldValidator ID="RequiredVal_answer" runat="server" ControlToValidate="answer"
                        Display="None" ErrorMessage="请输入问题答案！"></asp:RequiredFieldValidator>
                    <asp:RegularExpressionValidator ID="RegularVal_answer" runat="server" ControlToValidate="answer"
                        Display="None" ErrorMessage="问题答案字数太少！" SetFocusOnError="true" ValidationExpression="\S.*"></asp:RegularExpressionValidator>
                </td>
                <td class="col3">取回密码的问题答案</td>
            </tr>

            <tr runat="server" id="tr_Email">
                <td class="col1">电子邮箱<span class="required" runat="server" id="required_email">*</span>：</td>
                <td class="col2">
                    <asp:TextBox runat="server" AutoCompleteType="Email" ID="email"></asp:TextBox>
                    <asp:RequiredFieldValidator ID="RequiredVal_email" runat="server" ControlToValidate="email"
                        Display="None" ErrorMessage="请输入电子邮箱！"></asp:RequiredFieldValidator>
                    <asp:RegularExpressionValidator ID="RegularVal_email" runat="server" ControlToValidate="email"
                        Display="None" ErrorMessage="请输入有效的电子邮箱！" SetFocusOnError="true" ValidationExpression="^\w[\w\.-]*@\w[\w\.-]*\.[a-zA-Z]{2,4}"></asp:RegularExpressionValidator>
                </td>
                <td class="col3">请输入有效的邮箱地址，以便今后联系或忘记密码时发回密码</td>
            </tr>
            <tr runat="server" id="tr_Vcode">
                <td class="col1">验证码：</td>
                <td class="col2">
                    <asp:TextBox runat="server" ID="vcode"></asp:TextBox>
                    <img src="vcode.aspx" title="验证码。若看不清楚，请点击以刷新。" style="cursor: pointer; height: 19px; vertical-align: top" onclick="this.src='vcode.aspx?time='+new Date().getTime();" /></td>
                <td class="col3">请输入验证码（左边图片中显示的字符）</td>
            </tr>
        </table>
        <asp:CheckBox runat="server" ID="AutoLogin" Checked="true" Text="注册成功后自动登录系统" />
        <asp:UpdatePanel ID="footup" RenderMode="Block" runat="server" class="footBtnArea bigger">
            <ContentTemplate>
                <input class="btn" type="button" id="btnSubmit" value="注 册" runat="server" onserverclick="submit" />
                <input type="button" onclick="back();" value="返回" class="btn" />
            </ContentTemplate>
        </asp:UpdatePanel>
        <script src="js/comm.js"></script>
    </form>
</body>
</html>
