﻿<%@ page language="C#" autoeventwireup="true" inherits="ims.web.summary, ims.web" enableviewstatemac="false" enableEventValidation="false" %>
<!DOCTYPE html>
<html id="summary">
<head runat="server">
    <title></title><meta http-equiv="X-UA-Compatible" content="IE=edge" />
</head>
<body>
    <form id="form1" runat="server">
    <asp:ScriptManager ID="sm" runat="server" OnAsyncPostBackError="AsyncError" />
    <asp:HiddenField runat="server" ID="curTempletId" Value="" />
    <asp:UpdatePanel ID="up" runat="server" OnPreRender="ListPreRender" UpdateMode="conditional" RenderMode="Block" />       
    <asp:UpdatePanel ID="upPager" runat="server" UpdateMode="conditional" RenderMode="Block">
    <ContentTemplate>
        <table runat="server" id="PagerBar" class="PagerBar"><tr><td>
            <asp:LinkButton ID="btnFirst" Text="首页" runat="server" ToolTip="快捷键：Home" AccessKey="F" OnClick="ToPage" />
            <asp:LinkButton ID="btnPrevious" Text="< 上一页" runat="server" ToolTip="快捷键：←或PageUp" AccessKey="P" OnClick="ToPage" />
            <asp:Label ID="lblCount" CssClass="count" runat="server"></asp:Label>
            <asp:LinkButton ID="btnNext" Text="下一页 >" runat="server" ToolTip="快捷键：→或PageDown" AccessKey="N" OnClick="ToPage" />
            <asp:LinkButton ID="btnLast" Text="末页" runat="server" ToolTip="快捷键：End" AccessKey="L" OnClick="ToPage" />
        </td><td class="right">
            <asp:DropDownList runat="server" id="ddlPagesize" AutoPostBack="True" OnSelectedIndexChanged="PageSizeChanged">
                <asp:ListItem Value="1">1项/页</asp:ListItem>
                <asp:ListItem Value="2">2项/页</asp:ListItem>
                <asp:ListItem Value="3">3项/页</asp:ListItem>
                <asp:ListItem Value="5">5项/页</asp:ListItem>
                <asp:ListItem Value="10" Selected="true">10项/页</asp:ListItem>
                <asp:ListItem Value="20">20项/页</asp:ListItem>
                <asp:ListItem Value="50">50项/页</asp:ListItem>
                <asp:ListItem Value="100">100项/页</asp:ListItem>
                <asp:ListItem Value="300">300项/页</asp:ListItem>
                <asp:ListItem Value="500">500项/页</asp:ListItem>
            </asp:DropDownList>
            <asp:DropDownList ID="ddlPager" AutoPostBack="true" OnSelectedIndexChanged="ToPage" runat="server"></asp:DropDownList>
        </td></tr></table>
        <input type="button" runat="server" id="updatePagerBar" class="hide" onserverclick="UpdatePagerBar" />
        <ul class="hide" id="AttributeInfo"><li>共<asp:Literal ID="recordCount" runat="server"></asp:Literal>项</li></ul>
    </ContentTemplate>
    </asp:UpdatePanel>
 
    <div class="footBtnArea bigger" onmouseover="$('#icon').hide()">
        <input type="button" value="导出" id="btnExport" onclick="toExportAs('#up',null,document.title);" class="btn" />
        <input type="button" value="打印" id="btnPrint" onclick="$('#up').printIt({ pageTitle: document.title });" class="btn" />
        <input type="button" onclick="back();" value="返回" class="btn" />
        <input type="button" runat="server" id="btnChgFormat" class="hide" onserverclick="ShowEditFormat" />
    </div>
    
    <ims:Pop runat="server" ID="fmt" Width="500" OnClientUpdated="setHtmlArea();" OnOkClientClick="updateEditor();" HelpSubject="summary" OnOkClick="SaveFormat">
        <ContentTemplate>
            格式：<asp:RadioButtonList runat="server" ID="rblMode" RepeatLayout="Flow" RepeatDirection="Horizontal"><asp:ListItem Value="Default">默认</asp:ListItem><asp:ListItem Value="Link">链接</asp:ListItem><asp:ListItem Value="Custom">自由格式</asp:ListItem><asp:ListItem Value="DetailView">详情视图：</asp:ListItem></asp:RadioButtonList><asp:DropDownList runat="server" ID="ddlLayouts"></asp:DropDownList>
            <div id="divHtml" runat="server">
                <asp:UpdatePanel ID="upEditor" OnPreRender="MakeEditor" runat="server" UpdateMode="Conditional">
                <ContentTemplate>
                <asp:TextBox runat="server" ID="ckHtml" Height="300" Width="100%" CssClass="ck" TextMode="MultiLine"></asp:TextBox>
                <div class="right"><asp:DropDownList runat="server" ID="ddlInit" AutoPostBack="true" OnSelectedIndexChanged="InitEditor"></asp:DropDownList></div>
                </ContentTemplate>
                </asp:UpdatePanel>
                <asp:UpdatePanel ID="upCodes" runat="server" RenderMode="Block" UpdateMode="Conditional">
                <ContentTemplate>
                    <fieldset><legend>代码速查：<asp:DropDownList runat="server" ID="ddlTemplets" OnSelectedIndexChanged="TempletChanged" AutoPostBack="true"></asp:DropDownList></legend>
                        <div id="tagarea">
                        <select id="range" onchange="rangeChanged(this);"><option value="Field">字段</option><option value="Variable">变量</option><option>查询</option></select>
                        <asp:DropDownList runat="server" ID="ddlfs"></asp:DropDownList>
                        <asp:DropDownList runat="server" ID="ddlVars" CssClass="hide"></asp:DropDownList>
                        <span id="spanQuery" class="hide">
                            <asp:DropDownList runat="server" ID="ddlQuerys"></asp:DropDownList>
                            <img src="images/what.gif" title="什么是查询？如何定义查询？" onclick="What('RelatedQuery')" class="what mbottom_s" />
                        </span>
                        <select id="ddlFmts" onchange="fmtsChanged();">
                            <option value="">正常显示</option>
                            <option value="BarCode_1D">条形码</option>
                            <option value="BarCode_2D">二维码</option>
                            <option value="UpperNumeric">大写数字</option>
                            <option value="OriSize">原始图片</option>
                        </select> <select id="ddlBarCodes" class="forBarcode hide" onchange="showTag();">
                                    <option value="CODE39">CODE 39</option>
                                    <option value="CODE39Ext">CODE 39 Extended</option>
                                    <option value="CODE128">CODE 128</option>
                                    <option value="EAN13">EAN-13</option>
                                    <option value="EAN8">EAN-8</option>
                                    <option value="UPCA">UPC-A</option>
                                    <option value="UPCE">UPC-E</option>
                                    <option value="Codabar">Codabar</option>
                                    <option value="JAN13">JAN-13</option>
                                    <option value="BOOKLAND">BOOKLAND</option>
                                    <option value="ISBN">ISBN</option>
                                    <option value="PostNet">PostNet</option>
                                    <option value="Sta2of5">Standard 2 of 5</option>
                                    <option value="Ind2of5">Industrial 2 of 5</option>
                                    <option value="Int2of5">Interleaved 2 of 5</option>
                                    <option value="USD8">USD 8</option>
                                    <option value="UCC12">UCC 12</option>
                                    <option value="UCC13">UCC 13</option>
                                    <option value="CODE11">CODE 11</option>
                                    <option value="CODE128A">CODE 128-A</option>
                                    <option value="CODE128B">CODE 128-B</option>
                                    <option value="CODE128C">CODE 128-C</option>
                                    <option value="LOGMARS">LOGMARS</option>
                                    <option value="UPC2Ext">UPC 2 Digit Ext</option>
                                    <option value="UPC5Ext">UPC 5 Digit Ext</option>
                                    <option value="TELEPEN">TELEPEN</option>
                                    <option value="FIM">FIM</option>
                                    <option value="Mod_Plessey">Modified_Plessey</option>
                                    <option value="MSI_Mod10">MSI Mod10</option>
                                    <option value="MSI_Mod11">MSI Mod11</option>
                                    <option value="MSI_2Mod10">MSI-2 Mod10</option>
                                    <option value="UNSPECIFIED">Unspecified</option>
                                    </select> <select id="ddlSize" class="hide" onchange="showTag();" title="选择尺寸">
                                    <option value="small">小</option>
                                    <option value="smaller">较小</option>
                                    <option value="medium" selected="selected">适中</option>
                                    <option value="larger">较大</option>
                                    <option value="large">大</option>
                                    </select> <span class="forBarcode hide"><input type="checkbox" id="cbLabel" onchange="showTag();" /><label for="cbLabel">包含文字</label></span>： <span id="fieldTag"></span>
                            </div>
                        </fieldset>
                    </ContentTemplate>
                </asp:UpdatePanel>
            </div>
        </ContentTemplate>
    </ims:Pop>
    
    <asp:UpdateProgress ID="upgPager" runat="server" AssociatedUpdatePanelID="upPager">
        <ProgressTemplate><asp:Image ID="loading" ImageUrl="images/loading.gif" runat="server" /></ProgressTemplate>
    </asp:UpdateProgress>
    <script src="js/comm.js"></script><script src="js/summary.js"></script>
    </form>
</body>
</html>
