/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import com.squareup.leakcanary.AnalysisResult;
import com.squareup.leakcanary.HeapDump;
import java.io.Serializable;

public abstract class AbstractAnalysisResultService
extends IntentService {
    private static final String HEAP_DUMP_EXTRA = "heap_dump_extra";
    private static final String RESULT_EXTRA = "result_extra";

    public static void sendResultToListener(Context context, String listenerServiceClassName, HeapDump heapDump, AnalysisResult result) {
        Class<?> listenerServiceClass;
        try {
            listenerServiceClass = Class.forName(listenerServiceClassName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        Intent intent = new Intent(context, listenerServiceClass);
        intent.putExtra(HEAP_DUMP_EXTRA, (Serializable)heapDump);
        intent.putExtra(RESULT_EXTRA, (Serializable)result);
        context.startService(intent);
    }

    public AbstractAnalysisResultService() {
        super(AbstractAnalysisResultService.class.getName());
    }

    protected final void onHandleIntent(Intent intent) {
        HeapDump heapDump = (HeapDump)intent.getSerializableExtra(HEAP_DUMP_EXTRA);
        AnalysisResult result = (AnalysisResult)intent.getSerializableExtra(RESULT_EXTRA);
        try {
            this.onHeapAnalyzed(heapDump, result);
        }
        finally {
            heapDump.heapDumpFile.delete();
        }
    }

    protected abstract void onHeapAnalyzed(HeapDump var1, AnalysisResult var2);
}

