/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary;

import com.squareup.leakcanary.Preconditions;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public final class ExcludedRefs
implements Serializable {
    public final Map<String, Set<String>> excludeFieldMap;
    public final Map<String, Set<String>> excludeStaticFieldMap;
    public final Set<String> excludedThreads;

    private ExcludedRefs(Map<String, Set<String>> excludeFieldMap, Map<String, Set<String>> excludeStaticFieldMap, Set<String> excludedThreads) {
        this.excludeFieldMap = Collections.unmodifiableMap(new LinkedHashMap<String, Set<String>>(excludeFieldMap));
        this.excludeStaticFieldMap = Collections.unmodifiableMap(new LinkedHashMap<String, Set<String>>(excludeStaticFieldMap));
        this.excludedThreads = Collections.unmodifiableSet(new LinkedHashSet<String>(excludedThreads));
    }

    /* synthetic */ ExcludedRefs(Map map, Map map2, Set set, ExcludedRefs excludedRefs) {
        this(map, map2, set);
    }

    public static final class Builder {
        private final Map<String, Set<String>> excludeFieldMap = new LinkedHashMap<String, Set<String>>();
        private final Map<String, Set<String>> excludeStaticFieldMap = new LinkedHashMap<String, Set<String>>();
        private final Set<String> excludedThreads = new LinkedHashSet<String>();

        public Builder instanceField(String className, String fieldName) {
            Preconditions.checkNotNull(className, "className");
            Preconditions.checkNotNull(fieldName, "fieldName");
            Set<String> excludedFields = this.excludeFieldMap.get(className);
            if (excludedFields == null) {
                excludedFields = new LinkedHashSet<String>();
                this.excludeFieldMap.put(className, excludedFields);
            }
            excludedFields.add(fieldName);
            return this;
        }

        public Builder staticField(String className, String fieldName) {
            Preconditions.checkNotNull(className, "className");
            Preconditions.checkNotNull(fieldName, "fieldName");
            Set<String> excludedFields = this.excludeStaticFieldMap.get(className);
            if (excludedFields == null) {
                excludedFields = new LinkedHashSet<String>();
                this.excludeStaticFieldMap.put(className, excludedFields);
            }
            excludedFields.add(fieldName);
            return this;
        }

        public Builder thread(String threadName) {
            Preconditions.checkNotNull(threadName, "threadName");
            this.excludedThreads.add(threadName);
            return this;
        }

        public ExcludedRefs build() {
            return new ExcludedRefs(this.excludeFieldMap, this.excludeStaticFieldMap, this.excludedThreads, null);
        }
    }
}

