/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary;

import android.app.Application;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.util.Log;
import com.squareup.leakcanary.AbstractAnalysisResultService;
import com.squareup.leakcanary.ActivityRefWatcher;
import com.squareup.leakcanary.AnalysisResult;
import com.squareup.leakcanary.AndroidDebuggerControl;
import com.squareup.leakcanary.AndroidExcludedRefs;
import com.squareup.leakcanary.AndroidHeapDumper;
import com.squareup.leakcanary.AndroidWatchExecutor;
import com.squareup.leakcanary.DisplayLeakService;
import com.squareup.leakcanary.ExcludedRefs;
import com.squareup.leakcanary.GcTrigger;
import com.squareup.leakcanary.HeapDump;
import com.squareup.leakcanary.RefWatcher;
import com.squareup.leakcanary.ServiceHeapDumpListener;
import com.squareup.leakcanary.internal.DisplayLeakActivity;
import com.squareup.leakcanary.internal.HeapAnalyzerService;
import com.squareup.leakcanary.internal.LeakCanaryInternals;

public final class LeakCanary {
    public static RefWatcher install(Application application) {
        return LeakCanary.install(application, DisplayLeakService.class, AndroidExcludedRefs.createAppDefaults().build());
    }

    public static RefWatcher install(Application application, Class<? extends AbstractAnalysisResultService> listenerServiceClass, ExcludedRefs excludedRefs) {
        if (LeakCanary.isInAnalyzerProcess((Context)application)) {
            return RefWatcher.DISABLED;
        }
        LeakCanary.enableDisplayLeakActivity((Context)application);
        ServiceHeapDumpListener heapDumpListener = new ServiceHeapDumpListener((Context)application, listenerServiceClass);
        RefWatcher refWatcher = LeakCanary.androidWatcher((Context)application, heapDumpListener, excludedRefs);
        ActivityRefWatcher.installOnIcsPlus(application, refWatcher);
        return refWatcher;
    }

    public static RefWatcher androidWatcher(Context context, HeapDump.Listener heapDumpListener, ExcludedRefs excludedRefs) {
        AndroidDebuggerControl debuggerControl = new AndroidDebuggerControl();
        AndroidHeapDumper heapDumper = new AndroidHeapDumper(context);
        heapDumper.cleanup();
        return new RefWatcher(new AndroidWatchExecutor(), debuggerControl, GcTrigger.DEFAULT, heapDumper, heapDumpListener, excludedRefs);
    }

    public static void enableDisplayLeakActivity(Context context) {
        LeakCanaryInternals.setEnabled(context, DisplayLeakActivity.class, true);
    }

    public static String leakInfo(Context context, HeapDump heapDump, AnalysisResult result, boolean detailed) {
        PackageInfo packageInfo;
        PackageManager packageManager = context.getPackageManager();
        String packageName = context.getPackageName();
        try {
            packageInfo = packageManager.getPackageInfo(packageName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException(e);
        }
        String versionName = packageInfo.versionName;
        int versionCode = packageInfo.versionCode;
        String info = "In " + packageName + ":" + versionName + ":" + versionCode + ".\n";
        String detailedString = "";
        if (result.leakFound) {
            if (result.excludedLeak) {
                info = String.valueOf(info) + "* LEAK CAN BE IGNORED.\n";
            }
            info = String.valueOf(info) + "* " + result.className;
            if (!heapDump.referenceName.equals("")) {
                info = String.valueOf(info) + " (" + heapDump.referenceName + ")";
            }
            info = String.valueOf(info) + " has leaked:\n" + result.leakTrace.toString() + "\n";
            if (detailed) {
                detailedString = "\n* Details:\n" + result.leakTrace.toDetailedString();
            }
        } else {
            info = result.failure != null ? String.valueOf(info) + "* FAILURE:\n" + Log.getStackTraceString((Throwable)result.failure) + "\n" : String.valueOf(info) + "* NO LEAK FOUND.\n\n";
        }
        info = String.valueOf(info) + "* Reference Key: " + heapDump.referenceKey + "\n" + "* Device: " + Build.MANUFACTURER + " " + Build.BRAND + " " + Build.MODEL + " " + Build.PRODUCT + "\n" + "* Android Version: " + Build.VERSION.RELEASE + " API: " + Build.VERSION.SDK_INT + " LeakCanary: " + "\n" + "* Durations: watch=" + heapDump.watchDurationMs + "ms, gc=" + heapDump.gcDurationMs + "ms, heap dump=" + heapDump.heapDumpDurationMs + "ms, analysis=" + result.analysisDurationMs + "ms" + "\n" + detailedString;
        return info;
    }

    public static boolean isInAnalyzerProcess(Context context) {
        return LeakCanaryInternals.isInServiceProcess(context, HeapAnalyzerService.class);
    }

    private LeakCanary() {
        throw new AssertionError();
    }
}

