/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary;

import com.squareup.leakcanary.LeakTraceElement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class LeakTrace
implements Serializable {
    public final List<LeakTraceElement> elements;

    LeakTrace(List<LeakTraceElement> elements) {
        this.elements = Collections.unmodifiableList(new ArrayList<LeakTraceElement>(elements));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.elements.size()) {
            LeakTraceElement element = this.elements.get(i);
            sb.append("* ");
            if (i == 0) {
                sb.append("GC ROOT ");
            } else if (i == this.elements.size() - 1) {
                sb.append("leaks ");
            } else {
                sb.append("references ");
            }
            sb.append(element).append("\n");
            ++i;
        }
        return sb.toString();
    }

    public String toDetailedString() {
        String string2 = "";
        for (LeakTraceElement element : this.elements) {
            string2 = String.valueOf(string2) + element.toDetailedString();
        }
        return string2;
    }
}

