/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public final class LeakTraceElement
implements Serializable {
    public final String referenceName;
    public final Type type;
    public final Holder holder;
    public final String className;
    public final String extra;
    public final List<String> fields;

    LeakTraceElement(String referenceName, Type type, Holder holder, String className, String extra, List<String> fields) {
        this.referenceName = referenceName;
        this.type = type;
        this.holder = holder;
        this.className = className;
        this.extra = extra;
        this.fields = Collections.unmodifiableList(new ArrayList<String>(fields));
    }

    public String toString() {
        String string2 = "";
        if (this.type == Type.STATIC_FIELD) {
            string2 = String.valueOf(string2) + "static ";
        }
        if (this.holder == Holder.ARRAY || this.holder == Holder.THREAD) {
            string2 = String.valueOf(string2) + this.holder.name().toLowerCase(Locale.US) + " ";
        }
        string2 = String.valueOf(string2) + this.className;
        string2 = this.referenceName != null ? String.valueOf(string2) + "." + this.referenceName : String.valueOf(string2) + " instance";
        if (this.extra != null) {
            string2 = String.valueOf(string2) + " " + this.extra;
        }
        return string2;
    }

    public String toDetailedString() {
        String string2 = "* ";
        string2 = this.holder == Holder.ARRAY ? String.valueOf(string2) + "Array of" : (this.holder == Holder.CLASS ? String.valueOf(string2) + "Class" : String.valueOf(string2) + "Instance of");
        string2 = String.valueOf(string2) + " " + this.className + "\n";
        for (String field : this.fields) {
            string2 = String.valueOf(string2) + "|   " + field + "\n";
        }
        return string2;
    }

    public static enum Holder {
        OBJECT,
        CLASS,
        THREAD,
        ARRAY;

    }

    public static enum Type {
        INSTANCE_FIELD,
        STATIC_FIELD,
        LOCAL;

    }
}

