/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary;

import android.content.Context;
import com.squareup.leakcanary.AbstractAnalysisResultService;
import com.squareup.leakcanary.HeapDump;
import com.squareup.leakcanary.Preconditions;
import com.squareup.leakcanary.internal.HeapAnalyzerService;
import com.squareup.leakcanary.internal.LeakCanaryInternals;

public final class ServiceHeapDumpListener
implements HeapDump.Listener {
    private final Context context;
    private final Class<? extends AbstractAnalysisResultService> listenerServiceClass;

    public ServiceHeapDumpListener(Context context, Class<? extends AbstractAnalysisResultService> listenerServiceClass) {
        LeakCanaryInternals.setEnabled(context, listenerServiceClass, true);
        LeakCanaryInternals.setEnabled(context, HeapAnalyzerService.class, true);
        this.listenerServiceClass = Preconditions.checkNotNull(listenerServiceClass, "listenerServiceClass");
        this.context = Preconditions.checkNotNull(context, "context").getApplicationContext();
    }

    @Override
    public void analyze(HeapDump heapDump) {
        Preconditions.checkNotNull(heapDump, "heapDump");
        HeapAnalyzerService.runAnalysis(this.context, heapDump, this.listenerServiceClass);
    }
}

