/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.text.format.DateUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.squareup.leakcanary.AnalysisResult;
import com.squareup.leakcanary.HeapDump;
import com.squareup.leakcanary.LeakCanary;
import com.squareup.leakcanary.R;
import com.squareup.leakcanary.internal.DisplayLeakAdapter;
import com.squareup.leakcanary.internal.LeakCanaryInternals;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

@TargetApi(value=11)
public final class DisplayLeakActivity
extends Activity {
    private static final String TAG = "DisplayLeakActivity";
    private static final String SHOW_LEAK_EXTRA = "show_latest";
    private List<Leak> leaks;
    private String visibleLeakRefKey;
    private ListView listView;
    private TextView failureView;
    private Button actionButton;
    private int maxStoredLeaks;

    public static PendingIntent createPendingIntent(Context context, String referenceKey) {
        Intent intent = new Intent(context, DisplayLeakActivity.class);
        intent.putExtra(SHOW_LEAK_EXTRA, referenceKey);
        intent.setFlags(0x14000000);
        return PendingIntent.getActivity((Context)context, (int)1, (Intent)intent, (int)0x8000000);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.visibleLeakRefKey = savedInstanceState.getString("visibleLeakRefKey");
        } else {
            Intent intent = this.getIntent();
            if (intent.hasExtra(SHOW_LEAK_EXTRA)) {
                this.visibleLeakRefKey = intent.getStringExtra(SHOW_LEAK_EXTRA);
            }
        }
        this.leaks = (List)this.getLastNonConfigurationInstance();
        this.setContentView(R.layout.__leak_canary_display_leak);
        this.listView = (ListView)this.findViewById(R.id.__leak_canary_display_leak_list);
        this.failureView = (TextView)this.findViewById(R.id.__leak_canary_display_leak_failure);
        this.actionButton = (Button)this.findViewById(R.id.__leak_canary_action);
        this.maxStoredLeaks = this.getResources().getInteger(R.integer.__leak_canary_max_stored_leaks);
        this.updateUi();
    }

    public Object onRetainNonConfigurationInstance() {
        return this.leaks;
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putString("visibleLeakRefKey", this.visibleLeakRefKey);
    }

    protected void onResume() {
        super.onResume();
        LoadLeaks.load(this);
    }

    protected void onDestroy() {
        super.onDestroy();
        LoadLeaks.forgetActivity();
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        if (this.getVisibleLeak() != null) {
            menu.add(R.string.__leak_canary_share_leak).setOnMenuItemClickListener(new MenuItem.OnMenuItemClickListener(){

                public boolean onMenuItemClick(MenuItem item) {
                    DisplayLeakActivity.this.shareLeak();
                    return true;
                }
            });
            menu.add(R.string.__leak_canary_share_heap_dump).setOnMenuItemClickListener(new MenuItem.OnMenuItemClickListener(){

                public boolean onMenuItemClick(MenuItem item) {
                    DisplayLeakActivity.this.shareHeapDump();
                    return true;
                }
            });
            return true;
        }
        return false;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.visibleLeakRefKey = null;
            this.updateUi();
        }
        return true;
    }

    public void onBackPressed() {
        if (this.visibleLeakRefKey != null) {
            this.visibleLeakRefKey = null;
            this.updateUi();
        } else {
            super.onBackPressed();
        }
    }

    private void shareLeak() {
        Leak visibleLeak = this.getVisibleLeak();
        String leakInfo = LeakCanary.leakInfo((Context)this, visibleLeak.heapDump, visibleLeak.result, true);
        Intent intent = new Intent("android.intent.action.SEND");
        intent.setType("text/plain");
        intent.putExtra("android.intent.extra.TEXT", leakInfo);
        this.startActivity(Intent.createChooser((Intent)intent, (CharSequence)this.getString(R.string.__leak_canary_share_with)));
    }

    private void shareHeapDump() {
        Leak visibleLeak = this.getVisibleLeak();
        File heapDumpFile = visibleLeak.heapDump.heapDumpFile;
        heapDumpFile.setReadable(true, false);
        Intent intent = new Intent("android.intent.action.SEND");
        intent.setType("application/octet-stream");
        intent.putExtra("android.intent.extra.STREAM", (Parcelable)Uri.fromFile((File)heapDumpFile));
        this.startActivity(Intent.createChooser((Intent)intent, (CharSequence)this.getString(R.string.__leak_canary_share_with)));
    }

    private void updateUi() {
        Leak visibleLeak;
        if (this.leaks == null) {
            this.setTitle("Loading leaks...");
            return;
        }
        if (this.leaks.isEmpty()) {
            this.visibleLeakRefKey = null;
        }
        if ((visibleLeak = this.getVisibleLeak()) == null) {
            this.visibleLeakRefKey = null;
        }
        ListAdapter listAdapter = this.listView.getAdapter();
        this.listView.setVisibility(0);
        this.failureView.setVisibility(8);
        if (visibleLeak != null) {
            AnalysisResult result = visibleLeak.result;
            if (result.failure != null) {
                this.listView.setVisibility(8);
                this.failureView.setVisibility(0);
                this.failureView.setText((CharSequence)(String.valueOf(this.getString(R.string.__leak_canary_failure_report)) + Log.getStackTraceString((Throwable)result.failure)));
                this.setTitle(R.string.__leak_canary_analysis_failed);
                this.invalidateOptionsMenu();
                this.getActionBar().setDisplayHomeAsUpEnabled(true);
                this.actionButton.setVisibility(0);
                this.actionButton.setText(R.string.__leak_canary_delete);
                this.listView.setAdapter(null);
            } else {
                DisplayLeakAdapter adapter;
                if (listAdapter instanceof DisplayLeakAdapter) {
                    adapter = (DisplayLeakAdapter)listAdapter;
                } else {
                    adapter = new DisplayLeakAdapter();
                    this.listView.setAdapter((ListAdapter)adapter);
                    this.listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                        public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                            adapter.toggleRow(position);
                        }
                    });
                    this.invalidateOptionsMenu();
                    this.getActionBar().setDisplayHomeAsUpEnabled(true);
                    this.actionButton.setVisibility(0);
                    this.actionButton.setText(R.string.__leak_canary_delete);
                    this.actionButton.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            Leak visibleLeak = DisplayLeakActivity.this.getVisibleLeak();
                            File resultFile = LeakCanaryInternals.leakResultFile(visibleLeak.heapDump.heapDumpFile);
                            resultFile.delete();
                            visibleLeak.heapDump.heapDumpFile.delete();
                            DisplayLeakActivity.this.visibleLeakRefKey = null;
                            DisplayLeakActivity.this.leaks.remove(visibleLeak);
                            DisplayLeakActivity.this.updateUi();
                        }
                    });
                }
                HeapDump heapDump = visibleLeak.heapDump;
                adapter.update(result.leakTrace, heapDump.referenceKey, heapDump.referenceName);
                this.setTitle(this.getString(R.string.__leak_canary_class_has_leaked, new Object[]{DisplayLeakActivity.classSimpleName(result.className)}));
            }
        } else {
            if (listAdapter instanceof LeakListAdapter) {
                ((LeakListAdapter)listAdapter).notifyDataSetChanged();
            } else {
                LeakListAdapter adapter = new LeakListAdapter();
                this.listView.setAdapter((ListAdapter)adapter);
                this.listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                        DisplayLeakActivity.this.visibleLeakRefKey = ((Leak)((DisplayLeakActivity)DisplayLeakActivity.this).leaks.get((int)position)).heapDump.referenceKey;
                        DisplayLeakActivity.this.updateUi();
                    }
                });
                this.invalidateOptionsMenu();
                this.setTitle(this.getString(R.string.__leak_canary_leak_list_title, new Object[]{this.getPackageName()}));
                this.getActionBar().setDisplayHomeAsUpEnabled(false);
                this.actionButton.setText(R.string.__leak_canary_delete_all);
                this.actionButton.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        File[] files = LeakCanaryInternals.detectedLeakDirectory().listFiles();
                        if (files != null) {
                            File[] fileArray = files;
                            int n = files.length;
                            int n2 = 0;
                            while (n2 < n) {
                                File file = fileArray[n2];
                                file.delete();
                                ++n2;
                            }
                        }
                        DisplayLeakActivity.this.leaks = Collections.emptyList();
                        DisplayLeakActivity.this.updateUi();
                    }
                });
            }
            this.actionButton.setVisibility(this.leaks.size() == 0 ? 8 : 0);
        }
    }

    private Leak getVisibleLeak() {
        if (this.leaks == null) {
            return null;
        }
        for (Leak leak : this.leaks) {
            if (!leak.heapDump.referenceKey.equals(this.visibleLeakRefKey)) continue;
            return leak;
        }
        return null;
    }

    static String classSimpleName(String className) {
        int separator = className.lastIndexOf(46);
        if (separator == -1) {
            return className;
        }
        return className.substring(separator + 1);
    }

    static class Leak {
        final HeapDump heapDump;
        final AnalysisResult result;

        Leak(HeapDump heapDump, AnalysisResult result) {
            this.heapDump = heapDump;
            this.result = result;
        }
    }

    class LeakListAdapter
    extends BaseAdapter {
        LeakListAdapter() {
        }

        public int getCount() {
            return DisplayLeakActivity.this.leaks.size();
        }

        public Leak getItem(int position) {
            return (Leak)DisplayLeakActivity.this.leaks.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            if (convertView == null) {
                convertView = LayoutInflater.from((Context)DisplayLeakActivity.this).inflate(R.layout.__leak_canary_leak_row, parent, false);
            }
            TextView titleView = (TextView)convertView.findViewById(R.id.__leak_canary_row_text);
            TextView timeView = (TextView)convertView.findViewById(R.id.__leak_canary_row_time);
            Leak leak = this.getItem(position);
            String index = position == 0 && DisplayLeakActivity.this.leaks.size() == DisplayLeakActivity.this.maxStoredLeaks ? "MAX. " : String.valueOf(DisplayLeakActivity.this.leaks.size() - position) + ". ";
            String title = leak.result.failure == null ? String.valueOf(index) + DisplayLeakActivity.this.getString(R.string.__leak_canary_class_has_leaked, new Object[]{DisplayLeakActivity.classSimpleName(leak.result.className)}) : String.valueOf(index) + leak.result.failure.getClass().getSimpleName() + " " + leak.result.failure.getMessage();
            titleView.setText((CharSequence)title);
            String time = DateUtils.formatDateTime((Context)DisplayLeakActivity.this, (long)leak.heapDump.heapDumpFile.lastModified(), (int)17);
            timeView.setText((CharSequence)time);
            return convertView;
        }
    }

    static class LoadLeaks
    implements Runnable {
        static final List<LoadLeaks> inFlight = new ArrayList<LoadLeaks>();
        static final Executor backgroundExecutor = Executors.newSingleThreadExecutor();
        private DisplayLeakActivity activityOrNull;
        private final File leakDirectory;
        private final Handler mainHandler;

        static void load(DisplayLeakActivity activity) {
            LoadLeaks loadLeaks = new LoadLeaks(activity);
            inFlight.add(loadLeaks);
            backgroundExecutor.execute(loadLeaks);
        }

        static void forgetActivity() {
            for (LoadLeaks loadLeaks : inFlight) {
                loadLeaks.activityOrNull = null;
            }
            inFlight.clear();
        }

        LoadLeaks(DisplayLeakActivity activity) {
            this.activityOrNull = activity;
            this.leakDirectory = LeakCanaryInternals.detectedLeakDirectory();
            this.mainHandler = new Handler(Looper.getMainLooper());
        }

        @Override
        public void run() {
            final ArrayList<Leak> leaks = new ArrayList<Leak>();
            File[] files = this.leakDirectory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String filename) {
                    return filename.endsWith(".hprof");
                }
            });
            if (files != null) {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    block16: {
                        File heapDumpFile = fileArray[n2];
                        File resultFile = LeakCanaryInternals.leakResultFile(heapDumpFile);
                        FileInputStream fis = null;
                        try {
                            try {
                                fis = new FileInputStream(resultFile);
                                ObjectInputStream ois = new ObjectInputStream(fis);
                                HeapDump heapDump = (HeapDump)ois.readObject();
                                AnalysisResult result = (AnalysisResult)ois.readObject();
                                leaks.add(new Leak(heapDump, result));
                            }
                            catch (Exception e) {
                                heapDumpFile.delete();
                                resultFile.delete();
                                Log.e((String)DisplayLeakActivity.TAG, (String)("Could not read result file, deleted result and heap dump:" + heapDumpFile), (Throwable)e);
                                if (fis != null) {
                                    try {
                                        fis.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                                break block16;
                            }
                        }
                        catch (Throwable throwable) {
                            if (fis != null) {
                                try {
                                    fis.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            throw throwable;
                        }
                        if (fis != null) {
                            try {
                                fis.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                    ++n2;
                }
                Collections.sort(leaks, new Comparator<Leak>(){

                    @Override
                    public int compare(Leak lhs, Leak rhs) {
                        return Long.valueOf(rhs.heapDump.heapDumpFile.lastModified()).compareTo(lhs.heapDump.heapDumpFile.lastModified());
                    }
                });
            }
            this.mainHandler.post(new Runnable(){

                @Override
                public void run() {
                    inFlight.remove(LoadLeaks.this);
                    if (LoadLeaks.this.activityOrNull != null) {
                        LoadLeaks.this.activityOrNull.leaks = leaks;
                        LoadLeaks.this.activityOrNull.updateUi();
                    }
                }
            });
        }
    }
}

