/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary.internal;

import android.app.ActivityManager;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.os.Environment;
import android.os.Process;
import android.util.Log;
import java.io.File;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public final class LeakCanaryInternals {
    public static final int LOLLIPOP_MR1 = 22;
    public static final String SAMSUNG = "samsung";
    public static final String MOTOROLA = "motorola";
    public static final String LG = "LGE";
    public static final String NVIDIA = "NVIDIA";
    private static final Executor fileIoExecutor = Executors.newSingleThreadExecutor();

    public static void executeOnFileIoThread(Runnable runnable) {
        fileIoExecutor.execute(runnable);
    }

    public static File storageDirectory() {
        File downloadsDirectory = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS);
        File leakCanaryDirectory = new File(downloadsDirectory, "leakcanary");
        leakCanaryDirectory.mkdirs();
        return leakCanaryDirectory;
    }

    public static File detectedLeakDirectory() {
        File directory = new File(LeakCanaryInternals.storageDirectory(), "detected_leaks");
        directory.mkdirs();
        return directory;
    }

    public static File leakResultFile(File heapdumpFile) {
        return new File(heapdumpFile.getParentFile(), String.valueOf(heapdumpFile.getName()) + ".result");
    }

    public static boolean isExternalStorageWritable() {
        String state = Environment.getExternalStorageState();
        return "mounted".equals(state);
    }

    public static File findNextAvailableHprofFile(int maxFiles) {
        File directory = LeakCanaryInternals.detectedLeakDirectory();
        int i = 0;
        while (i < maxFiles) {
            String heapDumpName = "heap_dump_" + i + ".hprof";
            File file = new File(directory, heapDumpName);
            if (!file.exists()) {
                return file;
            }
            ++i;
        }
        return null;
    }

    public static String classSimpleName(String className) {
        int separator = className.lastIndexOf(46);
        if (separator == -1) {
            return className;
        }
        return className.substring(separator + 1);
    }

    public static void setEnabled(Context context, final Class<?> componentClass, final boolean enabled) {
        final Context appContext = context.getApplicationContext();
        LeakCanaryInternals.executeOnFileIoThread(new Runnable(){

            @Override
            public void run() {
                ComponentName component = new ComponentName(appContext, componentClass);
                PackageManager packageManager = appContext.getPackageManager();
                int newState = enabled ? 1 : 2;
                packageManager.setComponentEnabledSetting(component, newState, 1);
            }
        });
    }

    public static boolean isInServiceProcess(Context context, Class<? extends Service> serviceClass) {
        ServiceInfo serviceInfo;
        PackageInfo packageInfo;
        PackageManager packageManager = context.getPackageManager();
        try {
            packageInfo = packageManager.getPackageInfo(context.getPackageName(), 4);
        }
        catch (Exception e) {
            Log.e((String)"AndroidUtils", (String)("Could not get package info for " + context.getPackageName()), (Throwable)e);
            return false;
        }
        String mainProcess = packageInfo.applicationInfo.processName;
        ComponentName component = new ComponentName(context, serviceClass);
        try {
            serviceInfo = packageManager.getServiceInfo(component, 0);
        }
        catch (PackageManager.NameNotFoundException ignored) {
            return false;
        }
        if (serviceInfo.processName.equals(mainProcess)) {
            Log.e((String)"AndroidUtils", (String)("Did not expect service " + serviceClass + " to run in main process " + mainProcess));
            return false;
        }
        int myPid = Process.myPid();
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        ActivityManager.RunningAppProcessInfo myProcess = null;
        for (ActivityManager.RunningAppProcessInfo process : activityManager.getRunningAppProcesses()) {
            if (process.pid != myPid) continue;
            myProcess = process;
            break;
        }
        if (myProcess == null) {
            Log.e((String)"AndroidUtils", (String)("Could not find running process for " + myPid));
            return false;
        }
        return myProcess.processName.equals(serviceInfo.processName);
    }

    private LeakCanaryInternals() {
        throw new AssertionError();
    }
}

