/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.collect;

public class ArrayUtils {
    public static void sort(int[] keys, int[] values) {
        ArrayUtils.hybridsort(keys, values, 0, keys.length - 1);
    }

    public static void sortDesc(long[] keys, int[] values) {
        ArrayUtils.hybridsortDesc(keys, values, null, null, 0, keys.length - 1);
    }

    public static void sortDesc(long[] a, int[] b, long[] tmpa, int[] tmpb) {
        ArrayUtils.hybridsortDesc(a, b, tmpa, tmpb, 0, a.length - 1);
    }

    public static void sort(int[] keys, int[] values, int offset, int length) {
        ArrayUtils.hybridsort(keys, values, offset, offset + length - 1);
    }

    private static void swap(int[] keys, int[] values, int a, int b) {
        int tmp = keys[a];
        keys[a] = keys[b];
        keys[b] = tmp;
        tmp = values[a];
        values[a] = values[b];
        values[b] = tmp;
    }

    private static void swap(long[] keys, int[] values, int a, int b) {
        long tmpKey = keys[a];
        keys[a] = keys[b];
        keys[b] = tmpKey;
        int tmpValue = values[a];
        values[a] = values[b];
        values[b] = tmpValue;
    }

    private static int median(int[] x, int pos1, int pos2, int pos3) {
        int v1 = x[pos1];
        int v2 = x[pos2];
        int v3 = x[pos3];
        if (v1 < v2) {
            if (v2 <= v3) {
                return pos2;
            }
            return v1 < v3 ? pos3 : pos1;
        }
        if (v1 <= v3) {
            return pos1;
        }
        return v2 < v3 ? pos3 : pos2;
    }

    private static int median(long[] x, int pos1, int pos2, int pos3) {
        long v1 = x[pos1];
        long v2 = x[pos2];
        long v3 = x[pos3];
        if (v1 < v2) {
            if (v2 <= v3) {
                return pos2;
            }
            return v1 < v3 ? pos3 : pos1;
        }
        if (v1 <= v3) {
            return pos1;
        }
        return v2 < v3 ? pos3 : pos2;
    }

    private static int[] split(int[] keys, int[] values, int left, int right) {
        int splittingIdx = ArrayUtils.median(keys, left, right, left + (right - left >> 1));
        int splittingValue = keys[splittingIdx];
        ArrayUtils.swap(keys, values, left, splittingIdx);
        int i = left;
        int c = 0;
        int j = left + 1;
        while (j <= right) {
            if (keys[j] < splittingValue) {
                ArrayUtils.swap(keys, values, ++i, j);
                if (c > 0) {
                    ArrayUtils.swap(keys, values, i + c, j);
                }
            } else if (keys[j] == splittingValue) {
                ArrayUtils.swap(keys, values, i + ++c, j);
            }
            ++j;
        }
        ArrayUtils.swap(keys, values, left, i);
        return new int[]{i, i + c};
    }

    private static int[] splitDesc(long[] keys, int[] values, int left, int right) {
        int splittingIdx = ArrayUtils.median(keys, left, right, left + (right - left >> 1));
        long splittingValue = keys[splittingIdx];
        ArrayUtils.swap(keys, values, left, splittingIdx);
        int i = left;
        int c = 0;
        int j = left + 1;
        while (j <= right) {
            if (keys[j] > splittingValue) {
                ArrayUtils.swap(keys, values, ++i, j);
                if (c > 0) {
                    ArrayUtils.swap(keys, values, i + c, j);
                }
            } else if (keys[j] == splittingValue) {
                ArrayUtils.swap(keys, values, i + ++c, j);
            }
            ++j;
        }
        ArrayUtils.swap(keys, values, left, i);
        return new int[]{i, i + c};
    }

    private static void hybridsort(int[] keys, int[] values, int left, int right) {
        while (right - left >= 1) {
            int sizeRight;
            if (right - left < 5000000) {
                ArrayUtils.radixsort(keys, values, left, right - left + 1);
                break;
            }
            int[] i = ArrayUtils.split(keys, values, left, right);
            int sizeLeft = i[0] - left;
            if (sizeLeft <= (sizeRight = right - i[1])) {
                ArrayUtils.hybridsort(keys, values, left, i[0] - 1);
                left = i[1] + 1;
                continue;
            }
            ArrayUtils.hybridsort(keys, values, i[1] + 1, right);
            right = i[0] - 1;
        }
    }

    private static void hybridsortDesc(long[] keys, int[] values, long[] tmpKeys, int[] tmpValues, int left, int right) {
        while (right - left >= 1) {
            int sizeRight;
            if (right - left < 5000000) {
                if (right - left < 12) {
                    int i = left;
                    while (i <= right) {
                        int j = i;
                        while (j > left && keys[j - 1] < keys[j]) {
                            ArrayUtils.swap(keys, values, j, j - 1);
                            --j;
                        }
                        ++i;
                    }
                    return;
                }
                ArrayUtils.radixsortDesc(keys, values, tmpKeys, tmpValues, left, right - left + 1);
                break;
            }
            int[] i = ArrayUtils.splitDesc(keys, values, left, right);
            int sizeLeft = i[0] - left;
            if (sizeLeft <= (sizeRight = right - i[1])) {
                ArrayUtils.hybridsortDesc(keys, values, tmpKeys, tmpValues, left, i[0] - 1);
                left = i[1] + 1;
                continue;
            }
            ArrayUtils.hybridsortDesc(keys, values, tmpKeys, tmpValues, i[1] + 1, right);
            right = i[0] - 1;
        }
    }

    private static void radixsort(int[] keys, int[] values, int offset, int length) {
        int[] tempKeys = new int[length];
        int[] tempValues = new int[length];
        ArrayUtils.countsort(keys, tempKeys, values, tempValues, offset, 0, length, 0);
        ArrayUtils.countsort(tempKeys, keys, tempValues, values, 0, offset, length, 1);
        ArrayUtils.countsort(keys, tempKeys, values, tempValues, offset, 0, length, 2);
        ArrayUtils.countsort(tempKeys, keys, tempValues, values, 0, offset, length, 3);
    }

    private static void radixsortDesc(long[] keys, int[] values, long[] tempKeys, int[] tempValues, int offset, int length) {
        if (tempKeys == null) {
            tempKeys = new long[length];
        }
        if (tempValues == null) {
            tempValues = new int[length];
        }
        ArrayUtils.countsortDesc(keys, tempKeys, values, tempValues, offset, 0, length, 0);
        ArrayUtils.countsortDesc(tempKeys, keys, tempValues, values, 0, offset, length, 1);
        ArrayUtils.countsortDesc(keys, tempKeys, values, tempValues, offset, 0, length, 2);
        ArrayUtils.countsortDesc(tempKeys, keys, tempValues, values, 0, offset, length, 3);
        ArrayUtils.countsortDesc(keys, tempKeys, values, tempValues, offset, 0, length, 4);
        ArrayUtils.countsortDesc(tempKeys, keys, tempValues, values, 0, offset, length, 5);
        ArrayUtils.countsortDesc(keys, tempKeys, values, tempValues, offset, 0, length, 6);
        ArrayUtils.countsortDesc(tempKeys, keys, tempValues, values, 0, offset, length, 7);
    }

    private static void countsort(int[] srcKeys, int[] destKeys, int[] srcValues, int[] destValues, int srcOffset, int trgOffset, int length, int sortByte) {
        int[] count = new int[256];
        int[] index = new int[256];
        int shiftBits = 8 * sortByte;
        int srcEnd = srcOffset + length;
        int i = srcOffset;
        while (i < srcEnd) {
            int n = srcKeys[i] >> shiftBits & 0xFF;
            count[n] = count[n] + 1;
            ++i;
        }
        if (sortByte == 3) {
            i = 129;
            while (i < 256) {
                index[i] = index[i - 1] + count[i - 1];
                ++i;
            }
            index[0] = index[255] + count[255];
            i = 1;
            while (i < 128) {
                index[i] = index[i - 1] + count[i - 1];
                ++i;
            }
        } else {
            i = 1;
            while (i < 256) {
                index[i] = index[i - 1] + count[i - 1];
                ++i;
            }
        }
        i = srcOffset;
        while (i < srcEnd) {
            int idx = srcKeys[i] >> shiftBits & 0xFF;
            destValues[trgOffset + index[idx]] = srcValues[i];
            int n = idx;
            int n2 = index[n];
            index[n] = n2 + 1;
            destKeys[trgOffset + n2] = srcKeys[i];
            ++i;
        }
    }

    private static void countsortDesc(long[] srcKeys, long[] destKeys, int[] srcValues, int[] destValues, int srcOffset, int trgOffset, int length, int sortByte) {
        int[] count = new int[256];
        int[] index = new int[256];
        int shiftBits = 8 * sortByte;
        int srcEnd = srcOffset + length;
        int i = srcOffset;
        while (i < srcEnd) {
            int n = (int)(srcKeys[i] >> shiftBits & 0xFFL);
            count[n] = count[n] + 1;
            ++i;
        }
        if (sortByte == 7) {
            i = 126;
            while (i >= 0) {
                index[i] = index[i + 1] + count[i + 1];
                --i;
            }
            index[255] = index[0] + count[0];
            i = 254;
            while (i >= 128) {
                index[i] = index[i + 1] + count[i + 1];
                --i;
            }
        } else {
            i = 254;
            while (i >= 0) {
                index[i] = index[i + 1] + count[i + 1];
                --i;
            }
        }
        i = srcOffset;
        while (i < srcEnd) {
            int idx = (int)(srcKeys[i] >> shiftBits & 0xFFL);
            destValues[trgOffset + index[idx]] = srcValues[i];
            int n = idx;
            int n2 = index[n];
            index[n] = n2 + 1;
            destKeys[trgOffset + n2] = srcKeys[i];
            ++i;
        }
    }
}

