/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.collect;

import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.mat.collect.IteratorInt;
import org.eclipse.mat.collect.IteratorLong;
import org.eclipse.mat.collect.PrimeFinder;

public final class HashMapIntLong
implements Serializable {
    private static NoSuchElementException noSuchElementException = new NoSuchElementException("This is static exception, there is no stack trace available. It is thrown by get() method.");
    private static final long serialVersionUID = 1L;
    private int capacity;
    private int step;
    private int limit;
    private int size;
    private boolean[] used;
    private int[] keys;
    private long[] values;

    public HashMapIntLong() {
        this(10);
    }

    public HashMapIntLong(int initialCapacity) {
        this.init(initialCapacity);
    }

    public boolean put(int key, long value) {
        if (this.size == this.limit) {
            this.resize(this.capacity << 1);
        }
        int hash = (key & Integer.MAX_VALUE) % this.capacity;
        while (this.used[hash]) {
            if (this.keys[hash] == key) {
                this.values[hash] = value;
                return true;
            }
            hash = (hash + this.step) % this.capacity;
        }
        this.used[hash] = true;
        this.keys[hash] = key;
        this.values[hash] = value;
        ++this.size;
        return false;
    }

    public boolean remove(int key) {
        int hash = (key & Integer.MAX_VALUE) % this.capacity;
        while (this.used[hash]) {
            if (this.keys[hash] == key) {
                this.used[hash] = false;
                --this.size;
                hash = (hash + this.step) % this.capacity;
                while (this.used[hash]) {
                    key = this.keys[hash];
                    this.used[hash] = false;
                    int newHash = (key & Integer.MAX_VALUE) % this.capacity;
                    while (this.used[newHash]) {
                        newHash = (newHash + this.step) % this.capacity;
                    }
                    this.used[newHash] = true;
                    this.keys[newHash] = key;
                    this.values[newHash] = this.values[hash];
                    hash = (hash + this.step) % this.capacity;
                }
                return true;
            }
            hash = (hash + this.step) % this.capacity;
        }
        return false;
    }

    public boolean containsKey(int key) {
        int hash = (key & Integer.MAX_VALUE) % this.capacity;
        while (this.used[hash]) {
            if (this.keys[hash] == key) {
                return true;
            }
            hash = (hash + this.step) % this.capacity;
        }
        return false;
    }

    public long get(int key) {
        int hash = (key & Integer.MAX_VALUE) % this.capacity;
        while (this.used[hash]) {
            if (this.keys[hash] == key) {
                return this.values[hash];
            }
            hash = (hash + this.step) % this.capacity;
        }
        throw noSuchElementException;
    }

    public int[] getAllKeys() {
        int[] array = new int[this.size];
        int j = 0;
        int i = 0;
        while (i < this.used.length) {
            if (this.used[i]) {
                array[j++] = this.keys[i];
            }
            ++i;
        }
        return array;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public void clear() {
        this.size = 0;
        this.used = new boolean[this.capacity];
    }

    public IteratorInt keys() {
        return new IteratorInt(){
            int n = 0;
            int i = -1;

            @Override
            public boolean hasNext() {
                return this.n < HashMapIntLong.this.size;
            }

            @Override
            public int next() throws NoSuchElementException {
                while (++this.i < HashMapIntLong.this.used.length) {
                    if (!HashMapIntLong.this.used[this.i]) continue;
                    ++this.n;
                    return HashMapIntLong.this.keys[this.i];
                }
                throw new NoSuchElementException();
            }
        };
    }

    public IteratorLong values() {
        return new IteratorLong(){
            int n = 0;
            int i = -1;

            @Override
            public boolean hasNext() {
                return this.n < HashMapIntLong.this.size;
            }

            @Override
            public long next() throws NoSuchElementException {
                while (++this.i < HashMapIntLong.this.used.length) {
                    if (!HashMapIntLong.this.used[this.i]) continue;
                    ++this.n;
                    return HashMapIntLong.this.values[this.i];
                }
                throw new NoSuchElementException();
            }
        };
    }

    public Iterator<Entry> entries() {
        return new Iterator<Entry>(){
            int n = 0;
            int i = -1;

            @Override
            public boolean hasNext() {
                return this.n < HashMapIntLong.this.size;
            }

            @Override
            public Entry next() throws NoSuchElementException {
                while (++this.i < HashMapIntLong.this.used.length) {
                    if (!HashMapIntLong.this.used[this.i]) continue;
                    ++this.n;
                    return new Entry(){

                        @Override
                        public int getKey() {
                            return HashMapIntLong.this.keys[i];
                        }

                        @Override
                        public long getValue() {
                            return HashMapIntLong.this.values[i];
                        }
                    };
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() throws UnsupportedOperationException {
                throw new UnsupportedOperationException();
            }
        };
    }

    public long[] getAllValues() {
        long[] a = new long[this.size];
        int index = 0;
        int ii = 0;
        while (ii < this.values.length) {
            if (this.used[ii]) {
                a[index++] = this.values[ii];
            }
            ++ii;
        }
        return a;
    }

    private void init(int initialCapacity) {
        this.capacity = PrimeFinder.findNextPrime(initialCapacity);
        this.step = Math.max(1, PrimeFinder.findPrevPrime(initialCapacity / 3));
        this.limit = (int)((double)this.capacity * 0.75);
        this.clear();
        this.keys = new int[this.capacity];
        this.values = new long[this.capacity];
    }

    private void resize(int newCapacity) {
        int oldSize = this.size;
        boolean[] oldUsed = this.used;
        int[] oldKeys = this.keys;
        long[] oldValues = this.values;
        this.init(newCapacity);
        int i = 0;
        while (i < oldUsed.length) {
            if (oldUsed[i]) {
                int key = oldKeys[i];
                int hash = (key & Integer.MAX_VALUE) % this.capacity;
                while (this.used[hash]) {
                    hash = (hash + this.step) % this.capacity;
                }
                this.used[hash] = true;
                this.keys[hash] = key;
                this.values[hash] = oldValues[i];
            }
            ++i;
        }
        this.size = oldSize;
    }

    public static interface Entry {
        public int getKey();

        public long getValue();
    }
}

