/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.collect;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.mat.collect.IteratorInt;
import org.eclipse.mat.collect.PrimeFinder;

public final class HashMapIntObject<E>
implements Serializable {
    private static final long serialVersionUID = 2L;
    private int capacity;
    private int step;
    private int limit;
    private int size;
    private transient boolean[] used;
    private transient int[] keys;
    private transient E[] values;

    public HashMapIntObject() {
        this(10);
    }

    public HashMapIntObject(int initialCapacity) {
        this.init(initialCapacity);
    }

    public E put(int key, E value) {
        if (this.size == this.limit) {
            this.resize(this.capacity << 1);
        }
        int hash = (key & Integer.MAX_VALUE) % this.capacity;
        while (this.used[hash]) {
            if (this.keys[hash] == key) {
                E oldValue = this.values[hash];
                this.values[hash] = value;
                return oldValue;
            }
            hash = (hash + this.step) % this.capacity;
        }
        this.used[hash] = true;
        this.keys[hash] = key;
        this.values[hash] = value;
        ++this.size;
        return null;
    }

    public E remove(int key) {
        int hash = (key & Integer.MAX_VALUE) % this.capacity;
        while (this.used[hash]) {
            if (this.keys[hash] == key) {
                E oldValue = this.values[hash];
                this.used[hash] = false;
                --this.size;
                hash = (hash + this.step) % this.capacity;
                while (this.used[hash]) {
                    key = this.keys[hash];
                    this.used[hash] = false;
                    int newHash = (key & Integer.MAX_VALUE) % this.capacity;
                    while (this.used[newHash]) {
                        newHash = (newHash + this.step) % this.capacity;
                    }
                    this.used[newHash] = true;
                    this.keys[newHash] = key;
                    this.values[newHash] = this.values[hash];
                    hash = (hash + this.step) % this.capacity;
                }
                return oldValue;
            }
            hash = (hash + this.step) % this.capacity;
        }
        return null;
    }

    public boolean containsKey(int key) {
        int hash = (key & Integer.MAX_VALUE) % this.capacity;
        while (this.used[hash]) {
            if (this.keys[hash] == key) {
                return true;
            }
            hash = (hash + this.step) % this.capacity;
        }
        return false;
    }

    public E get(int key) {
        int hash = (key & Integer.MAX_VALUE) % this.capacity;
        while (this.used[hash]) {
            if (this.keys[hash] == key) {
                return this.values[hash];
            }
            hash = (hash + this.step) % this.capacity;
        }
        return null;
    }

    public int[] getAllKeys() {
        int[] array = new int[this.size];
        int j = 0;
        int i = 0;
        while (i < this.used.length) {
            if (this.used[i]) {
                array[j++] = this.keys[i];
            }
            ++i;
        }
        return array;
    }

    public Object[] getAllValues() {
        Object[] array = new Object[this.size];
        int index = 0;
        int ii = 0;
        while (ii < this.used.length) {
            if (this.used[ii]) {
                array[index++] = this.values[ii];
            }
            ++ii;
        }
        return array;
    }

    public <T> T[] getAllValues(T[] a) {
        if (a.length < this.size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
        }
        int index = 0;
        int ii = 0;
        while (ii < this.used.length) {
            if (this.used[ii]) {
                a[index++] = this.values[ii];
            }
            ++ii;
        }
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public void clear() {
        this.size = 0;
        this.used = new boolean[this.capacity];
    }

    public IteratorInt keys() {
        return new IteratorInt(){
            int n = 0;
            int i = -1;

            @Override
            public boolean hasNext() {
                return this.n < HashMapIntObject.this.size;
            }

            @Override
            public int next() throws NoSuchElementException {
                while (++this.i < HashMapIntObject.this.used.length) {
                    if (!HashMapIntObject.this.used[this.i]) continue;
                    ++this.n;
                    return HashMapIntObject.this.keys[this.i];
                }
                throw new NoSuchElementException();
            }
        };
    }

    public Iterator<E> values() {
        return new Iterator<E>(){
            int n = 0;
            int i = -1;

            @Override
            public boolean hasNext() {
                return this.n < HashMapIntObject.this.size;
            }

            @Override
            public E next() throws NoSuchElementException {
                while (++this.i < HashMapIntObject.this.used.length) {
                    if (!HashMapIntObject.this.used[this.i]) continue;
                    ++this.n;
                    return HashMapIntObject.this.values[this.i];
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() throws UnsupportedOperationException {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterator<Entry<E>> entries() {
        return new Iterator<Entry<E>>(){
            int n = 0;
            int i = -1;

            @Override
            public boolean hasNext() {
                return this.n < HashMapIntObject.this.size;
            }

            @Override
            public Entry<E> next() throws NoSuchElementException {
                while (++this.i < HashMapIntObject.this.used.length) {
                    if (!HashMapIntObject.this.used[this.i]) continue;
                    ++this.n;
                    return new Entry<E>(){

                        @Override
                        public int getKey() {
                            return HashMapIntObject.this.keys[i];
                        }

                        @Override
                        public E getValue() {
                            return HashMapIntObject.this.values[i];
                        }
                    };
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() throws UnsupportedOperationException {
                throw new UnsupportedOperationException();
            }
        };
    }

    private void init(int initialCapacity) {
        this.capacity = PrimeFinder.findNextPrime(initialCapacity);
        this.step = Math.max(1, PrimeFinder.findPrevPrime(initialCapacity / 3));
        this.limit = (int)((double)this.capacity * 0.75);
        this.clear();
        this.keys = new int[this.capacity];
        this.values = new Object[this.capacity];
    }

    private void resize(int newCapacity) {
        int oldSize = this.size;
        boolean[] oldUsed = this.used;
        int[] oldKeys = this.keys;
        E[] oldValues = this.values;
        this.init(newCapacity);
        int i = 0;
        while (i < oldUsed.length) {
            if (oldUsed[i]) {
                int key = oldKeys[i];
                int hash = (key & Integer.MAX_VALUE) % this.capacity;
                while (this.used[hash]) {
                    hash = (hash + this.step) % this.capacity;
                }
                this.used[hash] = true;
                this.keys[hash] = key;
                this.values[hash] = oldValues[i];
            }
            ++i;
        }
        this.size = oldSize;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        int ii = 0;
        while (ii < this.used.length) {
            if (this.used[ii]) {
                stream.writeInt(this.keys[ii]);
                stream.writeObject(this.values[ii]);
            }
            ++ii;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.step = Math.max(1, PrimeFinder.findPrevPrime(this.capacity / 3));
        this.used = new boolean[this.capacity];
        this.keys = new int[this.capacity];
        this.values = new Object[this.capacity];
        int ii = 0;
        while (ii < this.size) {
            this.putQuick(stream.readInt(), stream.readObject());
            ++ii;
        }
    }

    private void putQuick(int key, E value) {
        int hash = (key & Integer.MAX_VALUE) % this.capacity;
        while (this.used[hash]) {
            if (this.keys[hash] == key) {
                this.values[hash] = value;
                return;
            }
            hash = (hash + this.step) % this.capacity;
        }
        this.used[hash] = true;
        this.keys[hash] = key;
        this.values[hash] = value;
    }

    public static interface Entry<E> {
        public int getKey();

        public E getValue();
    }
}

