/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.hprof;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.IteratorLong;
import org.eclipse.mat.hprof.HprofParserHandlerImpl;
import org.eclipse.mat.hprof.Messages;
import org.eclipse.mat.hprof.Pass1Parser;
import org.eclipse.mat.hprof.Pass2Parser;
import org.eclipse.mat.hprof.extension.IParsingEnhancer;
import org.eclipse.mat.parser.IIndexBuilder;
import org.eclipse.mat.parser.IPreliminaryIndex;
import org.eclipse.mat.parser.index.IIndexReader;
import org.eclipse.mat.parser.index.IndexWriter;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.mat.util.SimpleMonitor;

public class HprofIndexBuilder
implements IIndexBuilder {
    private File file;
    private String prefix;
    private IIndexReader.IOne2LongIndex id2position;
    private List<IParsingEnhancer> enhancers;

    @Override
    public void init(File file, String prefix) {
        this.file = file;
        this.prefix = prefix;
        this.enhancers = new ArrayList<IParsingEnhancer>();
    }

    @Override
    public void fill(IPreliminaryIndex preliminary, IProgressListener listener) throws SnapshotException, IOException {
        SimpleMonitor monitor = new SimpleMonitor(MessageUtil.format(Messages.HprofIndexBuilder_Parsing, this.file.getAbsolutePath()), listener, new int[]{500, 1500});
        listener.beginTask(MessageUtil.format(Messages.HprofIndexBuilder_Parsing, this.file.getName()), 3000);
        HprofParserHandlerImpl handler = new HprofParserHandlerImpl();
        handler.beforePass1(preliminary.getSnapshotInfo());
        SimpleMonitor.Listener mon = (SimpleMonitor.Listener)monitor.nextMonitor();
        mon.beginTask(MessageUtil.format(Messages.HprofIndexBuilder_Scanning, this.file.getAbsolutePath()), (int)(this.file.length() / 1000L));
        Pass1Parser pass1 = new Pass1Parser(handler, mon);
        pass1.read(this.file);
        if (listener.isCanceled()) {
            throw new IProgressListener.OperationCanceledException();
        }
        mon.done();
        handler.beforePass2(listener);
        mon = (SimpleMonitor.Listener)monitor.nextMonitor();
        mon.beginTask(MessageUtil.format(Messages.HprofIndexBuilder_ExtractingObjects, this.file.getAbsolutePath()), (int)(this.file.length() / 1000L));
        Pass2Parser pass2 = new Pass2Parser(handler, mon);
        pass2.read(this.file);
        if (listener.isCanceled()) {
            throw new IProgressListener.OperationCanceledException();
        }
        mon.done();
        if (listener.isCanceled()) {
            throw new IProgressListener.OperationCanceledException();
        }
        for (IParsingEnhancer enhancer : this.enhancers) {
            enhancer.onParsingCompleted(handler.getSnapshotInfo());
        }
        this.id2position = handler.fillIn(preliminary);
    }

    @Override
    public void clean(int[] purgedMapping, IProgressListener listener) throws IOException {
        File indexFile = new File(String.valueOf(this.prefix) + "o2hprof.index");
        listener.subTask(MessageUtil.format(Messages.HprofIndexBuilder_Writing, indexFile.getAbsolutePath()));
        IIndexReader.IOne2LongIndex newIndex = new IndexWriter.LongIndexStreamer().writeTo(indexFile, new IndexIterator(this.id2position, purgedMapping));
        try {
            newIndex.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.id2position.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.id2position.delete();
        this.id2position = null;
    }

    @Override
    public void cancel() {
        if (this.id2position != null) {
            try {
                this.id2position.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.id2position.delete();
        }
    }

    private static final class IndexIterator
    implements IteratorLong {
        private final IIndexReader.IOne2LongIndex id2position;
        private final int[] purgedMapping;
        private int nextIndex = -1;

        private IndexIterator(IIndexReader.IOne2LongIndex id2position, int[] purgedMapping) {
            this.id2position = id2position;
            this.purgedMapping = purgedMapping;
            this.findNext();
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex < this.purgedMapping.length;
        }

        @Override
        public long next() {
            long answer = this.id2position.get(this.nextIndex);
            this.findNext();
            return answer;
        }

        protected void findNext() {
            ++this.nextIndex;
            while (this.nextIndex < this.purgedMapping.length && this.purgedMapping[this.nextIndex] < 0) {
                ++this.nextIndex;
            }
        }
    }
}

