/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.index;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.mat.parser.index.IIndexReader;
import org.eclipse.mat.parser.index.IndexReader;

public class IndexManager {
    public IIndexReader.IOne2ManyObjectsIndex inbound;
    public IIndexReader.IOne2ManyIndex outbound;
    public IIndexReader.IOne2OneIndex o2c;
    public IIndexReader.IOne2LongIndex idx;
    public IIndexReader.IOne2OneIndex a2s;
    public IIndexReader.IOne2ManyIndex domOut;
    public IIndexReader.IOne2LongIndex o2ret;
    public IIndexReader.IOne2OneIndex domIn;

    public void setReader(Index index, IIndexReader reader) {
        try {
            this.getClass().getField(index.filename).set(this, reader);
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public IIndexReader getReader(Index index) {
        try {
            return (IIndexReader)this.getClass().getField(index.filename).get(this);
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void init(final String prefix) throws IOException {
        new Visitor(this){

            @Override
            void visit(Index index, IIndexReader reader) throws IOException {
                if (reader != null) {
                    return;
                }
                try {
                    File indexFile = index.getFile(prefix);
                    if (indexFile.exists()) {
                        Constructor<? extends IIndexReader> constructor = index.impl.getConstructor(File.class);
                        reader = constructor.newInstance(indexFile);
                        this.setReader(index, reader);
                    }
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException(e);
                }
                catch (InstantiationException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    String msg = MessageFormat.format("{0}: {1}", cause.getClass().getName(), cause.getMessage());
                    throw new IOException(msg, cause);
                }
                catch (RuntimeException e) {
                    throw new IOException(e);
                }
            }
        }.doIt();
    }

    public IIndexReader.IOne2ManyIndex inbound() {
        return this.inbound;
    }

    public IIndexReader.IOne2ManyIndex outbound() {
        return this.outbound;
    }

    public IIndexReader.IOne2OneIndex o2class() {
        return this.o2c;
    }

    public IIndexReader.IOne2ManyObjectsIndex c2objects() {
        return this.inbound;
    }

    public IIndexReader.IOne2LongIndex o2address() {
        return this.idx;
    }

    public IIndexReader.IOne2OneIndex a2size() {
        return this.a2s;
    }

    public IIndexReader.IOne2ManyIndex dominated() {
        return this.domOut;
    }

    public IIndexReader.IOne2LongIndex o2retained() {
        return this.o2ret;
    }

    public IIndexReader.IOne2OneIndex dominator() {
        return this.domIn;
    }

    public void close() throws IOException {
        new Visitor(this){

            @Override
            void visit(Index index, IIndexReader reader) throws IOException {
                if (reader == null) {
                    return;
                }
                reader.close();
                this.setReader(index, null);
            }
        }.doIt();
    }

    public void delete() throws IOException {
        new Visitor(this){

            @Override
            void visit(Index index, IIndexReader reader) throws IOException {
                if (reader == null) {
                    return;
                }
                reader.close();
                reader.delete();
                this.setReader(index, null);
            }
        }.doIt();
    }

    public static enum Index {
        INBOUND("inbound", IndexReader.InboundReader.class),
        OUTBOUND("outbound", IndexReader.IntIndex1NSortedReader.class),
        O2CLASS("o2c", IndexReader.IntIndexReader.class),
        IDENTIFIER("idx", IndexReader.LongIndexReader.class),
        A2SIZE("a2s", IndexReader.IntIndexReader.class),
        DOMINATED("domOut", IndexReader.IntIndex1NReader.class),
        O2RETAINED("o2ret", IndexReader.LongIndexReader.class),
        DOMINATOR("domIn", IndexReader.IntIndexReader.class);

        public String filename;
        Class<? extends IIndexReader> impl;

        private Index(String filename, Class<? extends IIndexReader> impl) {
            this.filename = filename;
            this.impl = impl;
        }

        public File getFile(String prefix) {
            return new File(prefix + this.filename + ".index");
        }
    }

    private abstract class Visitor {
        private Visitor() {
        }

        abstract void visit(Index var1, IIndexReader var2) throws IOException;

        void doIt() throws IOException {
            try {
                Index[] indexArray = Index.values();
                int n = indexArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Index index = indexArray[n2];
                    IIndexReader reader = IndexManager.this.getReader(index);
                    this.visit(index, reader);
                    ++n2;
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

