/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.collect.ArrayIntBig;
import org.eclipse.mat.collect.BitField;
import org.eclipse.mat.collect.HashMapIntObject;
import org.eclipse.mat.collect.IteratorInt;
import org.eclipse.mat.collect.SetInt;
import org.eclipse.mat.hprof.Messages;
import org.eclipse.mat.parser.IObjectReader;
import org.eclipse.mat.parser.index.IIndexReader;
import org.eclipse.mat.parser.index.IndexManager;
import org.eclipse.mat.parser.internal.DominatorTree;
import org.eclipse.mat.parser.internal.ThreadStackHelper;
import org.eclipse.mat.parser.internal.snapshot.MultiplePathsFromGCRootsComputerImpl;
import org.eclipse.mat.parser.internal.snapshot.ObjectCache;
import org.eclipse.mat.parser.internal.snapshot.ObjectMarker;
import org.eclipse.mat.parser.internal.snapshot.PathsFromGCRootsTreeBuilder;
import org.eclipse.mat.parser.internal.snapshot.RetainedSizeCache;
import org.eclipse.mat.parser.internal.util.IntStack;
import org.eclipse.mat.parser.model.AbstractObjectImpl;
import org.eclipse.mat.parser.model.ClassImpl;
import org.eclipse.mat.parser.model.ClassLoaderImpl;
import org.eclipse.mat.parser.model.InstanceImpl;
import org.eclipse.mat.parser.model.XGCRootInfo;
import org.eclipse.mat.parser.model.XSnapshotInfo;
import org.eclipse.mat.snapshot.DominatorsSummary;
import org.eclipse.mat.snapshot.ExcludedReferencesDescriptor;
import org.eclipse.mat.snapshot.IMultiplePathsFromGCRootsComputer;
import org.eclipse.mat.snapshot.IPathsFromGCRootsComputer;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.PathsFromGCRootsTree;
import org.eclipse.mat.snapshot.model.GCRootInfo;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IThreadStack;
import org.eclipse.mat.snapshot.model.NamedReference;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.mat.util.VoidProgressListener;

public final class SnapshotImpl
implements ISnapshot {
    private XSnapshotInfo snapshotInfo;
    private HashMapIntObject<ClassImpl> classCache;
    private HashMapIntObject<XGCRootInfo[]> roots;
    private HashMapIntObject<HashMapIntObject<XGCRootInfo[]>> rootsPerThread;
    private HashMapIntObject<String> loaderLabels;
    private BitField arrayObjects;
    private IndexManager indexManager;
    private RetainedSizeCache retainedSizeCache;
    private IObjectReader heapObjectReader;
    private boolean dominatorTreeCalculated;
    private Map<String, List<IClass>> classCacheByName;
    private ObjectCache<IObject> objectCache;
    private boolean parsedThreads = false;
    HashMapIntObject<IThreadStack> threadId2stack;

    public static SnapshotImpl create(XSnapshotInfo snapshotInfo, IObjectReader heapObjectReader, HashMapIntObject<ClassImpl> classCache, HashMapIntObject<XGCRootInfo[]> roots, HashMapIntObject<HashMapIntObject<XGCRootInfo[]>> rootsPerThread, BitField arrayObjects, IndexManager indexManager) throws IOException, SnapshotException {
        SnapshotImpl answer = new SnapshotImpl(snapshotInfo, heapObjectReader, classCache, roots, rootsPerThread, null, arrayObjects, indexManager);
        answer.calculateLoaderLabels();
        return answer;
    }

    private SnapshotImpl(XSnapshotInfo snapshotInfo, IObjectReader heapObjectReader, HashMapIntObject<ClassImpl> classCache, HashMapIntObject<XGCRootInfo[]> roots, HashMapIntObject<HashMapIntObject<XGCRootInfo[]>> rootsPerThread, HashMapIntObject<String> loaderLabels, BitField arrayObjects, IndexManager indexManager) throws SnapshotException, IOException {
        this.snapshotInfo = snapshotInfo;
        this.heapObjectReader = heapObjectReader;
        this.classCache = classCache;
        this.roots = roots;
        this.rootsPerThread = rootsPerThread;
        this.loaderLabels = loaderLabels;
        this.arrayObjects = arrayObjects;
        this.indexManager = indexManager;
        this.retainedSizeCache = new RetainedSizeCache(snapshotInfo);
        this.classCacheByName = new HashMap<String, List<IClass>>(this.classCache.size());
        Iterator<ClassImpl> iter = this.classCache.values();
        while (iter.hasNext()) {
            ClassImpl clasz = iter.next();
            clasz.setSnapshot(this);
            List<IClass> list = this.classCacheByName.get(clasz.getName());
            if (list == null) {
                list = new ArrayList<IClass>();
                this.classCacheByName.put(clasz.getName(), list);
            }
            list.add(clasz);
        }
        this.dominatorTreeCalculated = indexManager.dominated() != null && indexManager.o2retained() != null && indexManager.dominator() != null;
        this.objectCache = new HeapObjectCache(this, 1000);
        this.heapObjectReader.open(this);
    }

    private void calculateLoaderLabels() throws SnapshotException {
        this.loaderLabels = new HashMapIntObject();
        long usedHeapSize = 0L;
        int systemClassLoaderId = this.indexManager.o2address().reverse(0L);
        Object[] classes = this.classCache.getAllValues();
        int i = 0;
        while (i < classes.length) {
            ClassImpl clasz = (ClassImpl)classes[i];
            usedHeapSize += clasz.getTotalSize();
            int classLoaderId = clasz.getClassLoaderId();
            String label = this.loaderLabels.get(classLoaderId);
            if (label == null) {
                if (classLoaderId == systemClassLoaderId) {
                    label = "<system class loader>";
                } else {
                    IObject classLoader = this.getObject(classLoaderId);
                    label = classLoader.getClassSpecificName();
                    if (label == null) {
                        label = "__none__";
                    }
                }
                this.loaderLabels.put(classLoaderId, label);
            }
            ++i;
        }
        Collection<IClass> loaderClasses = this.getClassesByName("java.lang.ClassLoader", true);
        if (loaderClasses != null) {
            for (IClass clazz : loaderClasses) {
                int[] nArray = clazz.getObjectIds();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int classLoaderId = nArray[n2];
                    String label = this.loaderLabels.get(classLoaderId);
                    if (label == null) {
                        if (classLoaderId == systemClassLoaderId) {
                            label = "<system class loader>";
                        } else {
                            IObject classLoader = this.getObject(classLoaderId);
                            label = classLoader.getClassSpecificName();
                            if (label == null) {
                                label = "__none__";
                            }
                        }
                        this.loaderLabels.put(classLoaderId, label);
                    }
                    ++n2;
                }
            }
        }
        this.snapshotInfo.setUsedHeapSize(usedHeapSize);
        this.snapshotInfo.setNumberOfObjects(this.indexManager.idx.size());
        this.snapshotInfo.setNumberOfClassLoaders(this.loaderLabels.size());
        this.snapshotInfo.setNumberOfGCRoots(this.roots.size());
        this.snapshotInfo.setNumberOfClasses(this.classCache.size());
        this.objectCache.clear();
    }

    @Override
    public XSnapshotInfo getSnapshotInfo() {
        return this.snapshotInfo;
    }

    @Override
    public int[] getGCRoots() throws SnapshotException {
        return this.roots.getAllKeys();
    }

    @Override
    public Collection<IClass> getClasses() throws SnapshotException {
        return Arrays.asList(this.classCache.getAllValues(new IClass[this.classCache.size()]));
    }

    @Override
    public Collection<IClass> getClassesByName(String name, boolean includeSubClasses) throws SnapshotException {
        List<IClass> list = this.classCacheByName.get(name);
        if (list == null) {
            return null;
        }
        if (!includeSubClasses) {
            return Collections.unmodifiableCollection(list);
        }
        HashSet<IClass> answer = new HashSet<IClass>();
        answer.addAll(list);
        for (IClass clazz : list) {
            answer.addAll(clazz.getAllSubclasses());
        }
        return answer;
    }

    @Override
    public Collection<IClass> getClassesByName(Pattern namePattern, boolean includeSubClasses) throws SnapshotException {
        HashSet<IClass> result = new HashSet<IClass>();
        Object[] classes = this.classCache.getAllValues();
        int i = 0;
        while (i < classes.length) {
            IClass clazz = (IClass)classes[i];
            if (namePattern.matcher(clazz.getName()).matches()) {
                result.add(clazz);
                if (includeSubClasses) {
                    result.addAll(clazz.getAllSubclasses());
                }
            }
            ++i;
        }
        return result;
    }

    @Override
    public int[] getInboundRefererIds(int objectId) throws SnapshotException {
        return this.indexManager.inbound().get(objectId);
    }

    @Override
    public int[] getOutboundReferentIds(int objectId) throws SnapshotException {
        return this.indexManager.outbound().get(objectId);
    }

    @Override
    public int[] getInboundRefererIds(int[] objectIds, IProgressListener progressMonitor) throws SnapshotException {
        if (progressMonitor == null) {
            progressMonitor = new VoidProgressListener();
        }
        IIndexReader.IOne2ManyIndex inbound = this.indexManager.inbound();
        SetInt result = new SetInt();
        progressMonitor.beginTask(Messages.SnapshotImpl_ReadingInboundReferrers, objectIds.length / 100);
        int ii = 0;
        while (ii < objectIds.length) {
            int[] referees;
            int[] nArray = referees = inbound.get(objectIds[ii]);
            int n = referees.length;
            int n2 = 0;
            while (n2 < n) {
                int refereeId = nArray[n2];
                result.add(refereeId);
                ++n2;
            }
            if (ii % 100 == 0) {
                if (progressMonitor.isCanceled()) {
                    return null;
                }
                progressMonitor.worked(1);
            }
            ++ii;
        }
        int[] endResult = result.toArray();
        progressMonitor.done();
        return endResult;
    }

    @Override
    public int[] getOutboundReferentIds(int[] objectIds, IProgressListener progressMonitor) throws SnapshotException {
        if (progressMonitor == null) {
            progressMonitor = new VoidProgressListener();
        }
        IIndexReader.IOne2ManyIndex outbound = this.indexManager.outbound();
        SetInt result = new SetInt();
        progressMonitor.beginTask(Messages.SnapshotImpl_ReadingOutboundReferrers, objectIds.length / 100);
        int ii = 0;
        while (ii < objectIds.length) {
            int[] referees;
            int[] nArray = referees = outbound.get(objectIds[ii]);
            int n = referees.length;
            int n2 = 0;
            while (n2 < n) {
                int refereeId = nArray[n2];
                result.add(refereeId);
                ++n2;
            }
            if (ii % 100 == 0) {
                if (progressMonitor.isCanceled()) {
                    return null;
                }
                progressMonitor.worked(1);
            }
            ++ii;
        }
        int[] endResult = result.toArray();
        progressMonitor.done();
        return endResult;
    }

    @Override
    public IPathsFromGCRootsComputer getPathsFromGCRoots(int objectId, Map<IClass, Set<String>> excludeList) throws SnapshotException {
        return new PathsFromGCRootsComputerImpl(objectId, excludeList);
    }

    @Override
    public IMultiplePathsFromGCRootsComputer getMultiplePathsFromGCRoots(int[] objectIds, Map<IClass, Set<String>> excludeList) throws SnapshotException {
        return new MultiplePathsFromGCRootsComputerImpl(objectIds, excludeList, this);
    }

    int[] getRetainedSetSingleThreaded(int[] objectIds, IProgressListener progressMonitor) throws SnapshotException {
        int numReached;
        if (objectIds.length == 0) {
            return new int[0];
        }
        if (objectIds.length == 1) {
            return this.getSingleObjectRetainedSet(objectIds[0]);
        }
        int numberOfObjects = this.snapshotInfo.getNumberOfObjects();
        if (progressMonitor == null) {
            progressMonitor = new VoidProgressListener();
        }
        boolean[] reachable = new boolean[numberOfObjects];
        int[] nArray = objectIds;
        int n = objectIds.length;
        int n2 = 0;
        while (n2 < n) {
            int objId = nArray[n2];
            reachable[objId] = true;
            ++n2;
        }
        ObjectMarker marker = new ObjectMarker(this.roots.getAllKeys(), reachable, this.indexManager.outbound(), progressMonitor);
        try {
            numReached = marker.markSingleThreaded();
        }
        catch (IProgressListener.OperationCanceledException e) {
            return null;
        }
        int[] retained = new int[numberOfObjects - numReached];
        int[] nArray2 = objectIds;
        int n3 = objectIds.length;
        int n4 = 0;
        while (n4 < n3) {
            int objId = nArray2[n4];
            reachable[objId] = false;
            ++n4;
        }
        int j = 0;
        int i = 0;
        while (i < numberOfObjects) {
            if (!reachable[i]) {
                retained[j++] = i;
            }
            ++i;
        }
        return retained;
    }

    private int[] getRetainedSetMultiThreaded(int[] objectIds, int availableProcessors, IProgressListener progressMonitor) throws SnapshotException {
        if (objectIds.length == 0) {
            return new int[0];
        }
        if (objectIds.length == 1) {
            return this.getSingleObjectRetainedSet(objectIds[0]);
        }
        int numberOfObjects = this.snapshotInfo.getNumberOfObjects();
        if (progressMonitor == null) {
            progressMonitor = new VoidProgressListener();
        }
        boolean[] reachable = new boolean[numberOfObjects];
        int[] nArray = objectIds;
        int n = objectIds.length;
        int n2 = 0;
        while (n2 < n) {
            int objId = nArray[n2];
            reachable[objId] = true;
            ++n2;
        }
        int[] gcRoots = this.roots.getAllKeys();
        ObjectMarker marker = new ObjectMarker(gcRoots, reachable, this.indexManager.outbound(), progressMonitor);
        try {
            marker.markMultiThreaded(availableProcessors);
        }
        catch (InterruptedException e) {
            throw new SnapshotException(e);
        }
        int[] nArray2 = objectIds;
        int n3 = objectIds.length;
        int n4 = 0;
        while (n4 < n3) {
            int objId = nArray2[n4];
            reachable[objId] = false;
            ++n4;
        }
        ArrayIntBig retained = new ArrayIntBig();
        int i = 0;
        while (i < numberOfObjects) {
            if (!reachable[i]) {
                retained.add(i);
            }
            ++i;
        }
        return retained.toArray();
    }

    @Override
    public int[] getRetainedSet(int[] objectIds, IProgressListener progressMonitor) throws SnapshotException {
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        if (availableProcessors > 1) {
            return this.getRetainedSetMultiThreaded(objectIds, availableProcessors, progressMonitor);
        }
        return this.getRetainedSetSingleThreaded(objectIds, progressMonitor);
    }

    @Override
    public int[] getRetainedSet(int[] objectIds, String[] fieldNames, IProgressListener listener) throws SnapshotException {
        if (objectIds.length == 0) {
            return new int[0];
        }
        int numberOfObjects = this.indexManager.o2address().size();
        if (listener == null) {
            listener = new VoidProgressListener();
        }
        BitField initialSet = new BitField(numberOfObjects);
        int[] nArray = objectIds;
        int n = objectIds.length;
        int n2 = 0;
        while (n2 < n) {
            int objId = nArray[n2];
            initialSet.set(objId);
            ++n2;
        }
        if (listener.isCanceled()) {
            return null;
        }
        BitField reachable = new BitField(numberOfObjects);
        int markedObjects = this.dfs2(reachable, initialSet, fieldNames);
        int[] retained = new int[numberOfObjects - markedObjects];
        int j = 0;
        int i = 0;
        while (i < numberOfObjects) {
            if (!reachable.get(i)) {
                retained[j++] = i;
            }
            ++i;
        }
        return retained;
    }

    @Override
    public int[] getRetainedSet(int[] objectIds, ExcludedReferencesDescriptor[] excludedReferences, IProgressListener progressMonitor) throws SnapshotException {
        boolean[] firstPass = new boolean[this.getSnapshotInfo().getNumberOfObjects()];
        int[] nArray = objectIds;
        int n = objectIds.length;
        int n2 = 0;
        while (n2 < n) {
            int objId = nArray[n2];
            firstPass[objId] = true;
            ++n2;
        }
        ObjectMarker marker = new ObjectMarker(this.getGCRoots(), firstPass, this.getIndexManager().outbound, new VoidProgressListener());
        marker.markSingleThreaded(excludedReferences, this);
        int[] nArray2 = objectIds;
        int n3 = objectIds.length;
        n = 0;
        while (n < n3) {
            int objId = nArray2[n];
            firstPass[objId] = false;
            ++n;
        }
        boolean[] secondPass = new boolean[firstPass.length];
        System.arraycopy(firstPass, 0, secondPass, 0, firstPass.length);
        ObjectMarker secondMarker = new ObjectMarker(objectIds, secondPass, this.getIndexManager().outbound, new VoidProgressListener());
        secondMarker.markSingleThreaded();
        int numObjects = this.getSnapshotInfo().getNumberOfObjects();
        ArrayIntBig retainedSet = new ArrayIntBig();
        int i = 0;
        while (i < numObjects) {
            if (!firstPass[i] && secondPass[i]) {
                retainedSet.add(i);
            }
            ++i;
        }
        return retainedSet.toArray();
    }

    @Override
    public long getMinRetainedSize(int[] objectIds, IProgressListener progressMonitor) throws UnsupportedOperationException, SnapshotException {
        if (objectIds.length == 1) {
            return this.getRetainedHeapSize(objectIds[0]);
        }
        if (objectIds.length == 0) {
            return 0L;
        }
        int[] topAncestors = this.getTopAncestorsInDominatorTree(objectIds, progressMonitor);
        long result = 0L;
        int[] nArray = topAncestors;
        int n = topAncestors.length;
        int n2 = 0;
        while (n2 < n) {
            int topAncestorId = nArray[n2];
            result += this.getRetainedHeapSize(topAncestorId);
            ++n2;
        }
        return result;
    }

    @Override
    public int[] getMinRetainedSet(int[] objectIds, IProgressListener progressMonitor) throws UnsupportedOperationException, SnapshotException {
        if (objectIds.length == 1) {
            return this.getSingleObjectRetainedSet(objectIds[0]);
        }
        SetInt retainedSet = new SetInt(2 * objectIds.length);
        int[] nArray = objectIds;
        int n = objectIds.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            retainedSet.add(i);
            ++n2;
        }
        SetInt negativeCache = new SetInt(2 * objectIds.length);
        int tempSize = 0;
        int tempCapacity = 10240;
        int[] temp = new int[tempCapacity];
        IIndexReader.IOne2OneIndex dominatorIdx = this.indexManager.dominator();
        IIndexReader.IOne2ManyIndex dominated = this.indexManager.dominated();
        int size = 0;
        int capacity = 10240;
        int[] stack = new int[capacity];
        int iterations = 0;
        int[] nArray2 = objectIds;
        int n3 = objectIds.length;
        int n4 = 0;
        while (n4 < n3) {
            int objectId = nArray2[n4];
            if ((++iterations & 0xFFFF) == 0 && progressMonitor.isCanceled()) {
                throw new IProgressListener.OperationCanceledException();
            }
            int dominatorId = dominatorIdx.get(objectId) - 2;
            boolean save = true;
            while (dominatorId > -1) {
                if (tempSize == tempCapacity) {
                    int newCapacity = tempCapacity << 1;
                    int[] newArr = new int[newCapacity];
                    System.arraycopy(temp, 0, newArr, 0, tempCapacity);
                    temp = newArr;
                    tempCapacity = newCapacity;
                }
                temp[tempSize++] = dominatorId;
                if (retainedSet.contains(dominatorId)) {
                    save = false;
                    break;
                }
                if (negativeCache.contains(dominatorId)) break;
                dominatorId = dominatorIdx.get(dominatorId) - 2;
            }
            if (save) {
                while (tempSize > 0) {
                    negativeCache.add(temp[--tempSize]);
                }
                stack[size++] = objectId;
                while (size > 0) {
                    int[] next;
                    int current = stack[--size];
                    retainedSet.add(current);
                    int[] nArray3 = next = dominated.get(current + 1);
                    int n5 = next.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        int i = nArray3[n6];
                        if (size == capacity) {
                            int newCapacity = capacity << 1;
                            int[] newArr = new int[newCapacity];
                            System.arraycopy(stack, 0, newArr, 0, capacity);
                            stack = newArr;
                            capacity = newCapacity;
                        }
                        stack[size++] = i;
                        ++n6;
                    }
                }
            }
            ++n4;
        }
        return retainedSet.toArray();
    }

    @Override
    public int[] getTopAncestorsInDominatorTree(int[] objectIds, IProgressListener listener) throws SnapshotException {
        if (!this.isDominatorTreeCalculated()) {
            throw new SnapshotException(Messages.SnapshotImpl_Error_DomTreeNotAvailable);
        }
        if (listener == null) {
            listener = new VoidProgressListener();
        }
        if (objectIds.length > 1000000) {
            return this.getTopAncestorsWithBooleanCache(objectIds, listener);
        }
        SetInt negativeCache = new SetInt(objectIds.length);
        SetInt positiveCache = new SetInt(2 * objectIds.length);
        int[] nArray = objectIds;
        int n = objectIds.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            positiveCache.add(i);
            ++n2;
        }
        ArrayInt result = new ArrayInt();
        int tempSize = 0;
        int tempCapacity = 10240;
        int[] temp = new int[tempCapacity];
        IIndexReader.IOne2OneIndex dominatorIdx = this.indexManager.dominator();
        int iterations = 0;
        int[] nArray2 = objectIds;
        int n3 = objectIds.length;
        int n4 = 0;
        while (n4 < n3) {
            int objectId = nArray2[n4];
            if ((++iterations & 0xFFFF) == 0 && listener.isCanceled()) {
                throw new IProgressListener.OperationCanceledException();
            }
            int dominatorId = dominatorIdx.get(objectId) - 2;
            boolean save = true;
            while (dominatorId > -1) {
                if (tempSize == tempCapacity) {
                    int newCapacity = tempCapacity << 1;
                    int[] newArr = new int[newCapacity];
                    System.arraycopy(temp, 0, newArr, 0, tempCapacity);
                    temp = newArr;
                    tempCapacity = newCapacity;
                }
                temp[tempSize++] = dominatorId;
                if (positiveCache.contains(dominatorId)) {
                    save = false;
                    while (tempSize > 0) {
                        positiveCache.add(temp[--tempSize]);
                    }
                    break;
                }
                if (negativeCache.contains(dominatorId)) break;
                dominatorId = dominatorIdx.get(dominatorId) - 2;
            }
            if (save) {
                result.add(objectId);
                while (tempSize > 0) {
                    negativeCache.add(temp[--tempSize]);
                }
            }
            ++n4;
        }
        return result.toArray();
    }

    private int[] getTopAncestorsWithBooleanCache(int[] objectIds, IProgressListener listener) {
        boolean[] negativeCache = new boolean[this.snapshotInfo.getNumberOfObjects()];
        boolean[] positiveCache = new boolean[this.snapshotInfo.getNumberOfObjects()];
        int[] nArray = objectIds;
        int n = objectIds.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            positiveCache[i] = true;
            ++n2;
        }
        ArrayInt result = new ArrayInt();
        int tempSize = 0;
        int tempCapacity = 10240;
        int[] temp = new int[tempCapacity];
        IIndexReader.IOne2OneIndex dominatorIdx = this.indexManager.dominator();
        int iterations = 0;
        int[] nArray2 = objectIds;
        int n3 = objectIds.length;
        int n4 = 0;
        while (n4 < n3) {
            int objectId = nArray2[n4];
            if ((++iterations & 0xFFFF) == 0 && listener.isCanceled()) {
                throw new IProgressListener.OperationCanceledException();
            }
            int dominatorId = dominatorIdx.get(objectId) - 2;
            boolean save = true;
            while (dominatorId > -1) {
                if (tempSize == tempCapacity) {
                    int newCapacity = tempCapacity << 1;
                    int[] newArr = new int[newCapacity];
                    System.arraycopy(temp, 0, newArr, 0, tempCapacity);
                    temp = newArr;
                    tempCapacity = newCapacity;
                }
                temp[tempSize++] = dominatorId;
                if (positiveCache[dominatorId]) {
                    save = false;
                    while (tempSize > 0) {
                        positiveCache[temp[--tempSize]] = true;
                    }
                    break;
                }
                if (negativeCache[dominatorId]) break;
                dominatorId = dominatorIdx.get(dominatorId) - 2;
            }
            if (save) {
                result.add(objectId);
                while (tempSize > 0) {
                    negativeCache[temp[--tempSize]] = true;
                }
            }
            ++n4;
        }
        return result.toArray();
    }

    private boolean isDominatorTreeCalculated() {
        return this.dominatorTreeCalculated;
    }

    public void calculateDominatorTree(IProgressListener listener) throws SnapshotException, IProgressListener.OperationCanceledException {
        try {
            DominatorTree.calculate(this, listener);
            this.dominatorTreeCalculated = this.indexManager.dominated() != null && this.indexManager.o2retained() != null && this.indexManager.dominator() != null;
        }
        catch (IOException e) {
            throw new SnapshotException(e);
        }
    }

    @Override
    public int[] getImmediateDominatedIds(int objectId) throws SnapshotException {
        if (!this.isDominatorTreeCalculated()) {
            throw new SnapshotException(Messages.SnapshotImpl_Error_DomTreeNotAvailable);
        }
        return this.indexManager.dominated().get(objectId + 1);
    }

    @Override
    public int getImmediateDominatorId(int objectId) throws SnapshotException {
        if (!this.isDominatorTreeCalculated()) {
            throw new SnapshotException(Messages.SnapshotImpl_Error_DomTreeNotAvailable);
        }
        return this.indexManager.dominator().get(objectId) - 2;
    }

    @Override
    public DominatorsSummary getDominatorsOf(int[] objectIds, Pattern excludePattern, IProgressListener progressListener) throws SnapshotException {
        if (!this.isDominatorTreeCalculated()) {
            throw new SnapshotException(Messages.SnapshotImpl_Error_DomTreeNotAvailable);
        }
        if (progressListener == null) {
            progressListener = new VoidProgressListener();
        }
        IIndexReader.IOne2OneIndex dominatorIndex = this.indexManager.dominator();
        IIndexReader.IOne2OneIndex o2classIndex = this.indexManager.o2class();
        SetInt excludeSet = new SetInt();
        SetInt includeSet = new SetInt();
        progressListener.beginTask(Messages.SnapshotImpl_RetrievingDominators, objectIds.length / 10);
        HashMap<IClass, DominatorsSummary.ClassDominatorRecord> map = new HashMap<IClass, DominatorsSummary.ClassDominatorRecord>();
        int ii = 0;
        while (ii < objectIds.length) {
            DominatorsSummary.ClassDominatorRecord record;
            int domClassId;
            String domClassName;
            IClass clasz;
            int objectId = objectIds[ii];
            int dominatorId = dominatorIndex.get(objectId) - 2;
            if (dominatorId == -1) {
                clasz = null;
                domClassName = "<ROOT>";
                domClassId = -1;
            } else {
                domClassId = o2classIndex.get(dominatorId);
                clasz = this.classCache.get(domClassId);
                domClassName = clasz.getName();
            }
            if (excludePattern != null && dominatorId >= 0) {
                boolean exclude = true;
                while (exclude) {
                    if (progressListener.isCanceled()) {
                        throw new IProgressListener.OperationCanceledException();
                    }
                    if (excludeSet.contains(domClassId)) {
                        if ((dominatorId = dominatorIndex.get(dominatorId) - 2) == -1) {
                            clasz = null;
                            domClassName = "<ROOT>";
                            domClassId = -1;
                            continue;
                        }
                        domClassId = o2classIndex.get(dominatorId);
                        clasz = this.classCache.get(domClassId);
                        domClassName = clasz.getName();
                        continue;
                    }
                    if (includeSet.contains(domClassId)) {
                        exclude = false;
                        continue;
                    }
                    if (excludePattern.matcher(domClassName).matches() && dominatorId >= 0) {
                        excludeSet.add(domClassId);
                        continue;
                    }
                    includeSet.add(domClassId);
                    exclude = false;
                }
            }
            if ((record = (DominatorsSummary.ClassDominatorRecord)map.get(clasz)) == null) {
                record = new DominatorsSummary.ClassDominatorRecord();
                map.put(clasz, record);
                record.setClassName(domClassName);
                record.setClassId(domClassId);
                record.setClassloaderId(dominatorId == -1 || clasz == null ? -1 : clasz.getClassLoaderId());
            }
            if (record.addDominator(dominatorId) && dominatorId != -1) {
                record.addDominatorNetSize(this.getHeapSize(dominatorId));
            }
            if (record.addDominated(objectId)) {
                record.addDominatedNetSize(this.getHeapSize(objectId));
            }
            if (ii % 10 == 0) {
                if (progressListener.isCanceled()) {
                    throw new IProgressListener.OperationCanceledException();
                }
                progressListener.worked(1);
            }
            ++ii;
        }
        DominatorsSummary.ClassDominatorRecord[] records = map.values().toArray(new DominatorsSummary.ClassDominatorRecord[0]);
        progressListener.done();
        return new DominatorsSummary(records, this);
    }

    @Override
    public IObject getObject(int objectId) throws SnapshotException {
        IObject answer = this.classCache.get(objectId);
        if (answer != null) {
            return answer;
        }
        return this.objectCache.get(objectId);
    }

    @Override
    public GCRootInfo[] getGCRootInfo(int objectId) throws SnapshotException {
        return this.roots.get(objectId);
    }

    @Override
    public IClass getClassOf(int objectId) throws SnapshotException {
        if (this.isClass(objectId)) {
            return this.getObject(objectId).getClazz();
        }
        return (IClass)this.getObject(this.indexManager.o2class().get(objectId));
    }

    @Override
    public long mapIdToAddress(int objectId) throws SnapshotException {
        return this.indexManager.o2address().get(objectId);
    }

    @Override
    public int getHeapSize(int objectId) throws SnapshotException {
        if (this.arrayObjects.get(objectId)) {
            return this.indexManager.a2size().get(objectId);
        }
        IClass clazz = this.classCache.get(objectId);
        if (clazz != null) {
            return clazz.getUsedHeapSize();
        }
        clazz = this.classCache.get(this.indexManager.o2class().get(objectId));
        return clazz.getHeapSizePerInstance();
    }

    @Override
    public long getHeapSize(int[] objectIds) throws UnsupportedOperationException, SnapshotException {
        long total = 0L;
        IIndexReader.IOne2OneIndex o2class = this.indexManager.o2class();
        IIndexReader.IOne2OneIndex a2size = this.indexManager.a2size();
        int[] nArray = objectIds;
        int n = objectIds.length;
        int n2 = 0;
        while (n2 < n) {
            int objectId = nArray[n2];
            if (this.arrayObjects.get(objectId)) {
                total += (long)a2size.get(objectId);
            } else {
                IClass clazz = this.classCache.get(objectId);
                if (clazz != null) {
                    total += (long)clazz.getUsedHeapSize();
                } else {
                    clazz = this.classCache.get(o2class.get(objectId));
                    total += (long)clazz.getHeapSizePerInstance();
                }
            }
            ++n2;
        }
        return total;
    }

    @Override
    public long getRetainedHeapSize(int objectId) throws SnapshotException {
        if (this.isDominatorTreeCalculated()) {
            return this.indexManager.o2retained().get(objectId);
        }
        return 0L;
    }

    @Override
    public boolean isArray(int objectId) {
        if (this.arrayObjects.get(objectId)) {
            IClass clazz = this.classCache.get(this.indexManager.o2class().get(objectId));
            return clazz.isArrayType();
        }
        return false;
    }

    @Override
    public boolean isClass(int objectId) {
        return this.classCache.containsKey(objectId);
    }

    @Override
    public boolean isGCRoot(int objectId) {
        return this.roots.containsKey(objectId);
    }

    @Override
    public int mapAddressToId(long objectAddress) throws SnapshotException {
        int objectId = this.indexManager.o2address().reverse(objectAddress);
        if (objectId < 0) {
            throw new SnapshotException(MessageUtil.format(Messages.SnapshotImpl_Error_ObjectNotFound, "0x" + Long.toHexString(objectAddress)));
        }
        return objectId;
    }

    @Override
    public void dispose() {
        IOException error = null;
        try {
            this.heapObjectReader.close();
        }
        catch (IOException e1) {
            error = e1;
        }
        try {
            this.indexManager.close();
        }
        catch (IOException e1) {
            error = e1;
        }
        this.retainedSizeCache.close();
        if (error != null) {
            throw new RuntimeException(error);
        }
    }

    public List<IClass> resolveClassHierarchy(int classIndex) {
        IClass clazz = this.classCache.get(classIndex);
        if (clazz == null) {
            return null;
        }
        ArrayList<IClass> answer = new ArrayList<IClass>();
        answer.add(clazz);
        while (clazz.hasSuperClass()) {
            if ((clazz = (IClass)this.classCache.get(clazz.getSuperClassId())) == null) {
                return null;
            }
            answer.add(clazz);
        }
        return answer;
    }

    @Override
    public boolean isClassLoader(int objectId) {
        return this.loaderLabels.containsKey(objectId);
    }

    public String getClassLoaderLabel(int objectId) {
        return this.loaderLabels.get(objectId);
    }

    public void setClassLoaderLabel(int objectId, String label) {
        if (label == null) {
            throw new NullPointerException(Messages.SnapshotImpl_Label.pattern);
        }
        String old = this.loaderLabels.put(objectId, label);
        if (old == null) {
            throw new RuntimeException(Messages.SnapshotImpl_Error_ReplacingNonExistentClassLoader.pattern);
        }
    }

    private int dfs2(BitField bits, BitField exclude, String[] fieldNames) throws SnapshotException {
        int count = 0;
        HashSet<String> fieldNamesSet = new HashSet<String>(fieldNames.length);
        int i = 0;
        while (i < fieldNames.length) {
            fieldNamesSet.add(fieldNames[i]);
            ++i;
        }
        IIndexReader.IOne2ManyIndex outbound = this.indexManager.outbound();
        IntStack stack = new IntStack();
        IteratorInt en = this.roots.keys();
        while (en.hasNext()) {
            int i2 = en.next();
            stack.push(i2);
            bits.set(i2);
            ++count;
        }
        while (stack.size() > 0) {
            int child;
            int n;
            int n2;
            int[] nArray;
            int current = stack.pop();
            if (exclude.get(current)) {
                nArray = outbound.get(current);
                n2 = nArray.length;
                n = 0;
                while (n < n2) {
                    child = nArray[n];
                    IObject obj = this.getObject(current);
                    long childAddress = this.mapIdToAddress(child);
                    List<NamedReference> refs = obj.getOutboundReferences();
                    for (NamedReference reference : refs) {
                        if (bits.get(child) || reference.getObjectAddress() != childAddress || fieldNamesSet.contains(reference.getName())) continue;
                        stack.push(child);
                        bits.set(child);
                        ++count;
                    }
                    ++n;
                }
                continue;
            }
            nArray = outbound.get(current);
            n2 = nArray.length;
            n = 0;
            while (n < n2) {
                child = nArray[n];
                if (!bits.get(child)) {
                    stack.push(child);
                    bits.set(child);
                    ++count;
                }
                ++n;
            }
        }
        return count;
    }

    private int[] getSingleObjectRetainedSet(int objectId) throws SnapshotException {
        ArrayIntBig result = new ArrayIntBig();
        IntStack stack = new IntStack();
        stack.push(objectId);
        while (stack.size() > 0) {
            int[] next;
            int current = stack.pop();
            result.add(current);
            int[] nArray = next = this.getImmediateDominatedIds(current);
            int n = next.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                stack.push(i);
                ++n2;
            }
        }
        return result.toArray();
    }

    public IndexManager getIndexManager() {
        return this.indexManager;
    }

    public IObjectReader getHeapObjectReader() {
        return this.heapObjectReader;
    }

    public RetainedSizeCache getRetainedSizeCache() {
        return this.retainedSizeCache;
    }

    public HashMapIntObject<HashMapIntObject<XGCRootInfo[]>> getRootsPerThread() {
        return this.rootsPerThread;
    }

    @Override
    public <A> A getSnapshotAddons(Class<A> addon) throws SnapshotException {
        return this.heapObjectReader.getAddon(addon);
    }

    @Override
    public IThreadStack getThreadStack(int objectId) throws SnapshotException {
        if (!this.parsedThreads) {
            this.threadId2stack = ThreadStackHelper.loadThreadsData(this);
            this.parsedThreads = true;
        }
        if (this.threadId2stack != null) {
            return this.threadId2stack.get(objectId);
        }
        return null;
    }

    private static final class HeapObjectCache
    extends ObjectCache<IObject> {
        SnapshotImpl snapshot;

        private HeapObjectCache(SnapshotImpl snapshot, int maxSize) {
            super(maxSize);
            this.snapshot = snapshot;
        }

        @Override
        protected IObject load(int objectId) {
            try {
                IObject answer = null;
                if (this.snapshot.isArray(objectId)) {
                    answer = this.snapshot.heapObjectReader.read(objectId, this.snapshot);
                } else {
                    ClassImpl classImpl = (ClassImpl)this.snapshot.getObject(this.snapshot.indexManager.o2class().get(objectId));
                    answer = this.snapshot.isClassLoader(objectId) ? new ClassLoaderImpl(objectId, Long.MIN_VALUE, classImpl, null) : new InstanceImpl(objectId, Long.MIN_VALUE, classImpl, null);
                }
                ((AbstractObjectImpl)answer).setSnapshot(this.snapshot);
                return answer;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (SnapshotException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class Path {
        int index;
        Path next;

        public Path(int index, Path next) {
            this.index = index;
            this.next = next;
        }

        public Path getNext() {
            return this.next;
        }

        public int getIndex() {
            return this.index;
        }

        public boolean contains(long id2) {
            Path p = this;
            while (p != null) {
                if ((long)p.index == id2) {
                    return true;
                }
                p = p.next;
            }
            return false;
        }
    }

    private class PathsFromGCRootsComputerImpl
    implements IPathsFromGCRootsComputer {
        private int state;
        private int nextState;
        int objectId;
        LinkedList<Path> fifo = new LinkedList();
        BitField visited;
        BitField excludeInstances;
        IIndexReader.IOne2ManyIndex inboundIndex;
        int currentId;
        Path currentPath;
        int[] currentReferrers;
        int lastReadReferrer;
        int[] referringThreads;
        int currentReferringThread;
        int[] foundPath;
        Map<IClass, Set<String>> excludeMap;

        public PathsFromGCRootsComputerImpl(int objectId, Map<IClass, Set<String>> excludeMap) throws SnapshotException {
            this.visited = new BitField(SnapshotImpl.this.indexManager.o2address().size());
            this.objectId = objectId;
            this.excludeMap = excludeMap;
            this.inboundIndex = SnapshotImpl.this.indexManager.inbound();
            if (excludeMap != null) {
                this.initExcludeInstances();
            }
            this.currentId = objectId;
            this.visited.set(objectId);
            if (SnapshotImpl.this.roots.get(objectId) == null) {
                this.fifo.add(new Path(objectId, null));
            }
        }

        private void initExcludeInstances() throws SnapshotException {
            this.excludeInstances = new BitField(SnapshotImpl.this.indexManager.o2address().size());
            for (IClass clazz : this.excludeMap.keySet()) {
                int[] objects;
                int[] nArray = objects = clazz.getObjectIds();
                int n = objects.length;
                int n2 = 0;
                while (n2 < n) {
                    int objId = nArray[n2];
                    this.excludeInstances.set(objId);
                    ++n2;
                }
            }
        }

        private boolean refersOnlyThroughExcluded(int referrerId, int referentId) throws SnapshotException {
            if (!this.excludeInstances.get(referrerId)) {
                return false;
            }
            IObject referrerObject = SnapshotImpl.this.getObject(referrerId);
            Set<String> excludeFields = this.excludeMap.get(referrerObject.getClazz());
            if (excludeFields == null) {
                return true;
            }
            long referentAddr = SnapshotImpl.this.mapIdToAddress(referentId);
            List<NamedReference> refs = referrerObject.getOutboundReferences();
            for (NamedReference reference : refs) {
                if (referentAddr != reference.getObjectAddress() || excludeFields.contains(reference.getName())) continue;
                return false;
            }
            return true;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public int[] getNextShortestPath() throws SnapshotException {
            switch (this.state) {
                case 0: {
                    if (SnapshotImpl.this.roots.containsKey(this.currentId)) {
                        this.referringThreads = null;
                        this.state = 2;
                        this.nextState = 1;
                        this.foundPath = new int[]{this.currentId};
                        return this.getNextShortestPath();
                    }
                    this.state = 3;
                    return this.getNextShortestPath();
                }
                case 1: {
                    return null;
                }
                case 2: {
                    if (this.referringThreads == null) {
                        this.referringThreads = this.getReferringTreads(SnapshotImpl.this.getGCRootInfo(this.foundPath[this.foundPath.length - 1]));
                        this.currentReferringThread = 0;
                        if (this.referringThreads.length == 0) {
                            this.state = this.nextState;
                            return this.foundPath;
                        }
                    }
                    if (this.currentReferringThread < this.referringThreads.length) {
                        int[] result = new int[this.foundPath.length + 1];
                        System.arraycopy(this.foundPath, 0, result, 0, this.foundPath.length);
                        result[result.length - 1] = this.referringThreads[this.currentReferringThread];
                        ++this.currentReferringThread;
                        return result;
                    }
                    this.state = this.nextState;
                    return this.getNextShortestPath();
                }
                case 3: {
                    int[] res;
                    if (this.currentReferrers != null && (res = this.processCurrentReferrefs(this.lastReadReferrer + 1)) != null) {
                        return res;
                    }
                    do {
                        if (this.fifo.size() <= 0) {
                            return null;
                        }
                        this.currentPath = this.fifo.getFirst();
                        this.fifo.removeFirst();
                        this.currentId = this.currentPath.getIndex();
                        this.currentReferrers = this.inboundIndex.get(this.currentId);
                    } while (this.currentReferrers == null || (res = this.processCurrentReferrefs(0)) == null);
                    return res;
                }
            }
            throw new RuntimeException(String.valueOf(Messages.SnapshotImpl_Error_UnrecognizedState.pattern) + this.state);
        }

        private int[] getReferringTreads(GCRootInfo[] rootInfos) {
            SetInt threads = new SetInt();
            GCRootInfo[] gCRootInfoArray = rootInfos;
            int n = rootInfos.length;
            int n2 = 0;
            while (n2 < n) {
                GCRootInfo info = gCRootInfoArray[n2];
                if (info.getContextAddress() != 0L && info.getObjectAddress() != info.getContextAddress()) {
                    threads.add(info.getContextId());
                }
                ++n2;
            }
            return threads.toArray();
        }

        @Override
        public PathsFromGCRootsTree getTree(Collection<int[]> paths) {
            PathsFromGCRootsTreeBuilder rootBuilder = new PathsFromGCRootsTreeBuilder(this.objectId);
            for (int[] path : paths) {
                PathsFromGCRootsTreeBuilder current = rootBuilder;
                int k = 1;
                while (k < path.length) {
                    int childId = path[k];
                    PathsFromGCRootsTreeBuilder child = current.getObjectReferers().get(childId);
                    if (child == null) {
                        child = new PathsFromGCRootsTreeBuilder(childId);
                        current.addObjectReferer(child);
                    }
                    current = child;
                    ++k;
                }
            }
            return rootBuilder.toPathsFromGCRootsTree();
        }

        private int[] path2Int(Path p) {
            IntStack s = new IntStack();
            while (p != null) {
                s.push(p.getIndex());
                p = p.getNext();
            }
            int[] res = new int[s.size()];
            int i = 0;
            while (i < res.length) {
                res[i] = s.pop();
                ++i;
            }
            return res;
        }

        private int[] processCurrentReferrefs(int fromIndex) throws SnapshotException {
            GCRootInfo[] rootInfo = null;
            int i = fromIndex;
            while (i < this.currentReferrers.length) {
                rootInfo = (GCRootInfo[])SnapshotImpl.this.roots.get(this.currentReferrers[i]);
                if (rootInfo != null) {
                    if (this.excludeMap == null) {
                        this.lastReadReferrer = i;
                        Path p = new Path(this.currentReferrers[i], this.currentPath);
                        this.referringThreads = null;
                        this.state = 2;
                        this.nextState = 3;
                        this.foundPath = this.path2Int(p);
                        return this.getNextShortestPath();
                    }
                    if (!this.refersOnlyThroughExcluded(this.currentReferrers[i], this.currentId)) {
                        this.lastReadReferrer = i;
                        Path p = new Path(this.currentReferrers[i], this.currentPath);
                        this.referringThreads = null;
                        this.state = 2;
                        this.nextState = 3;
                        this.foundPath = this.path2Int(p);
                        return this.getNextShortestPath();
                    }
                }
                ++i;
            }
            int[] nArray = this.currentReferrers;
            int n = this.currentReferrers.length;
            int n2 = 0;
            while (n2 < n) {
                int referrer = nArray[n2];
                if (referrer >= 0 && !this.visited.get(referrer) && !SnapshotImpl.this.roots.containsKey(referrer)) {
                    if (this.excludeMap == null) {
                        this.fifo.add(new Path(referrer, this.currentPath));
                        this.visited.set(referrer);
                    } else if (!this.refersOnlyThroughExcluded(referrer, this.currentId)) {
                        this.fifo.add(new Path(referrer, this.currentPath));
                        this.visited.set(referrer);
                    }
                }
                ++n2;
            }
            return null;
        }
    }
}

