/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.internal.snapshot;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.mat.collect.HashMapIntLong;
import org.eclipse.mat.hprof.Messages;
import org.eclipse.mat.parser.model.XSnapshotInfo;

public class RetainedSizeCache {
    private String filename;
    private HashMapIntLong id2size;
    private boolean isDirty = false;

    public RetainedSizeCache(XSnapshotInfo snapshotInfo) {
        this.filename = String.valueOf(snapshotInfo.getPrefix()) + "i2sv2.index";
        this.readId2Size(snapshotInfo.getPrefix());
    }

    public long get(int key) {
        try {
            return this.id2size.get(key);
        }
        catch (NoSuchElementException e) {
            return 0L;
        }
    }

    public void put(int key, long value) {
        this.id2size.put(key, value);
        this.isDirty = true;
    }

    public void close() {
        if (!this.isDirty) {
            return;
        }
        try {
            File file = new File(this.filename);
            DataOutputStream out = new DataOutputStream(new FileOutputStream(file));
            int[] nArray = this.id2size.getAllKeys();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int key = nArray[n2];
                out.writeInt(key);
                out.writeLong(this.id2size.get(key));
                ++n2;
            }
            out.close();
            this.isDirty = false;
        }
        catch (IOException e) {
            Logger.getLogger(RetainedSizeCache.class.getName()).log(Level.WARNING, Messages.RetainedSizeCache_Warning_IgnoreError.pattern, e);
        }
    }

    private void doRead(File file, boolean readOldFormat) {
        FilterInputStream in = null;
        boolean delete = false;
        try {
            try {
                this.id2size = new HashMapIntLong((int)file.length() / 8);
                in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
                while (in.available() > 0) {
                    int key = ((DataInputStream)in).readInt();
                    long value = ((DataInputStream)in).readLong();
                    if (value < 0L && readOldFormat) {
                        value = -(value - -9223372036854775807L);
                    }
                    this.id2size.put(key, value);
                }
            }
            catch (IOException e) {
                Logger.getLogger(RetainedSizeCache.class.getName()).log(Level.WARNING, Messages.RetainedSizeCache_ErrorReadingRetainedSizes.pattern, e);
                this.id2size.clear();
                delete = true;
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    if (delete) {
                        file.delete();
                    }
                }
                catch (RuntimeException runtimeException) {}
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (delete) {
                    file.delete();
                }
            }
            catch (RuntimeException runtimeException) {}
        }
    }

    private void readId2Size(String prefix) {
        File file = new File(this.filename);
        if (file.exists()) {
            this.doRead(file, false);
        } else {
            File legacyFile = new File(String.valueOf(prefix) + "i2s.index");
            if (legacyFile.exists()) {
                this.doRead(legacyFile, true);
            } else {
                this.id2size = new HashMapIntLong();
            }
        }
    }
}

