/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.internal.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.mat.hprof.HprofHeapObjectReader;
import org.eclipse.mat.hprof.HprofIndexBuilder;
import org.eclipse.mat.parser.IIndexBuilder;
import org.eclipse.mat.parser.IObjectReader;
import org.eclipse.mat.snapshot.SnapshotFormat;

public class ParserRegistry {
    public static final String INDEX_BUILDER = "indexBuilder";
    public static final String OBJECT_READER = "objectReader";
    public List<Parser> parsers = new ArrayList<Parser>();
    private static ParserRegistry instance = new ParserRegistry();

    static {
        ParserRegistry.addParser("hprof", "hprof", new String[]{"hprof", "bin"}, new HprofHeapObjectReader(), new HprofIndexBuilder());
    }

    private ParserRegistry() {
    }

    public static void addParser(String id2, String snapshotFormat, String[] extensions, IObjectReader objectReader, IIndexBuilder indexBuilder) {
        SnapshotFormat sf = new SnapshotFormat(snapshotFormat, extensions);
        Parser p = new Parser(id2, sf, objectReader, indexBuilder);
        ParserRegistry.instance.parsers.add(p);
    }

    public static Parser lookupParser(String uniqueIdentifier) {
        for (Parser p : ParserRegistry.instance.parsers) {
            if (!uniqueIdentifier.equals(p.getUniqueIdentifier())) continue;
            return p;
        }
        return null;
    }

    public static List<Parser> matchParser(String fileName) {
        ArrayList<Parser> answer = new ArrayList<Parser>();
        block0: for (Parser p : ParserRegistry.instance.parsers) {
            Pattern[] patternArray = p.patterns;
            int n = patternArray.length;
            int n2 = 0;
            while (n2 < n) {
                Pattern regex = patternArray[n2];
                if (regex.matcher(fileName).matches()) {
                    answer.add(p);
                    continue block0;
                }
                ++n2;
            }
        }
        return answer;
    }

    public static List<Parser> allParsers() {
        return ParserRegistry.instance.parsers;
    }

    public static class Parser {
        private IObjectReader objectReader;
        private IIndexBuilder indexBuilder;
        private String id;
        private SnapshotFormat snapshotFormat;
        private Pattern[] patterns;

        public Parser(String id2, SnapshotFormat snapshotFormat, IObjectReader objectReader, IIndexBuilder indexBuilder) {
            this.id = id2;
            this.snapshotFormat = snapshotFormat;
            this.patterns = new Pattern[snapshotFormat.getFileExtensions().length];
            int ii = 0;
            while (ii < snapshotFormat.getFileExtensions().length) {
                this.patterns[ii] = Pattern.compile("(.*\\.)((?i)" + snapshotFormat.getFileExtensions()[ii] + ")(\\.[0-9]*)?");
                ++ii;
            }
            this.objectReader = objectReader;
            this.indexBuilder = indexBuilder;
        }

        public IObjectReader getObjectReader() {
            return this.objectReader;
        }

        public IIndexBuilder getIndexBuilder() {
            return this.indexBuilder;
        }

        public String getId() {
            return this.id;
        }

        public String getUniqueIdentifier() {
            return this.id;
        }

        public SnapshotFormat getSnapshotFormat() {
            return this.snapshotFormat;
        }
    }
}

