/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.ref.SoftReference;
import org.eclipse.mat.collect.HashMapLongObject;

public class BufferedRandomAccessInputStream
extends InputStream {
    RandomAccessFile raf;
    int bufsize;
    long fileLength;
    long real_pos;
    long reported_pos;
    HashMapLongObject<SoftReference<Page>> pages = new HashMapLongObject();
    Page current;

    public BufferedRandomAccessInputStream(RandomAccessFile in) throws IOException {
        this(in, 1024);
    }

    public BufferedRandomAccessInputStream(RandomAccessFile in, int bufsize) throws IOException {
        this.bufsize = bufsize;
        this.raf = in;
        this.fileLength = in.length();
    }

    @Override
    public final int read() throws IOException {
        if (this.reported_pos == this.fileLength) {
            return -1;
        }
        if (this.current == null || this.reported_pos - this.current.real_pos_start >= (long)this.current.buf_end) {
            this.current = this.getPage(this.reported_pos);
        }
        return this.current.buffer[(int)(this.reported_pos++ - this.current.real_pos_start)] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.reported_pos == this.fileLength) {
            return -1;
        }
        int copied = 0;
        while (copied < len) {
            if (this.reported_pos == this.fileLength) {
                return copied;
            }
            if (this.current == null || this.reported_pos - this.current.real_pos_start >= (long)this.current.buf_end) {
                this.current = this.getPage(this.reported_pos);
            }
            int buf_pos = (int)(this.reported_pos - this.current.real_pos_start);
            int length = Math.min(len - copied, this.current.buf_end - buf_pos);
            System.arraycopy(this.current.buffer, buf_pos, b, off + copied, length);
            this.reported_pos += (long)length;
            copied += length;
        }
        return copied;
    }

    private Page getPage(long pos) throws IOException {
        Page p;
        long key = pos / (long)this.bufsize;
        SoftReference<Page> r = this.pages.get(key);
        Page page = p = r == null ? null : r.get();
        if (p != null) {
            return p;
        }
        long page_start = key * (long)this.bufsize;
        if (page_start != this.real_pos) {
            this.raf.seek(page_start);
            this.real_pos = page_start;
        }
        p = new Page();
        int n = this.raf.read(p.buffer);
        if (n >= 0) {
            p.real_pos_start = this.real_pos;
            p.buf_end = n;
            this.real_pos += (long)n;
        }
        this.pages.put(key, new SoftReference<Page>(p));
        return p;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void close() throws IOException {
        this.raf.close();
    }

    public void seek(long pos) throws IOException {
        this.reported_pos = pos;
        this.current = null;
    }

    public long getFilePointer() {
        return this.reported_pos;
    }

    private class Page {
        long real_pos_start;
        byte[] buffer;
        int buf_end;

        public Page() {
            this.buffer = new byte[BufferedRandomAccessInputStream.this.bufsize];
        }
    }
}

