/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayLong;
import org.eclipse.mat.hprof.Messages;
import org.eclipse.mat.parser.model.AbstractArrayImpl;
import org.eclipse.mat.parser.model.ClassImpl;
import org.eclipse.mat.snapshot.model.Field;
import org.eclipse.mat.snapshot.model.IObjectArray;
import org.eclipse.mat.snapshot.model.NamedReference;
import org.eclipse.mat.snapshot.model.ObjectReference;
import org.eclipse.mat.snapshot.model.PseudoReference;
import org.eclipse.mat.util.MessageUtil;

public class ObjectArrayImpl
extends AbstractArrayImpl
implements IObjectArray {
    private static final long serialVersionUID = 2L;

    public ObjectArrayImpl(int objectId, long address, ClassImpl classInstance, int length) {
        super(objectId, address, classInstance, length);
    }

    @Override
    public int getUsedHeapSize() {
        try {
            return this.getSnapshot().getHeapSize(this.getObjectId());
        }
        catch (SnapshotException e) {
            return ObjectArrayImpl.doGetUsedHeapSize(this.classInstance, this.length);
        }
    }

    public static int doGetUsedHeapSize(ClassImpl clazz, int length) {
        return ObjectArrayImpl.alignUpTo8(2 * clazz.getHeapSizePerInstance() + 4 + length * clazz.getHeapSizePerInstance());
    }

    @Override
    public long[] getReferenceArray() {
        try {
            return this.source.getHeapObjectReader().readObjectArrayContent(this, 0, this.getLength());
        }
        catch (SnapshotException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long[] getReferenceArray(int offset, int length) {
        try {
            return this.source.getHeapObjectReader().readObjectArrayContent(this, offset, length);
        }
        catch (SnapshotException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ArrayLong getReferences() {
        ArrayLong answer = new ArrayLong(this.getLength() + 1);
        answer.add(this.classInstance.getObjectAddress());
        long[] refs = this.getReferenceArray();
        int i = 0;
        while (i < refs.length) {
            if (refs[i] != 0L) {
                answer.add(refs[i]);
            }
            ++i;
        }
        return answer;
    }

    @Override
    protected Field internalGetField(String name) {
        if (name.charAt(0) != '[' || name.charAt(name.length() - 1) != ']') {
            return null;
        }
        try {
            int index = Integer.parseInt(name.substring(1, name.length() - 1));
            if (index < 0 || index > this.length) {
                throw new IndexOutOfBoundsException(MessageUtil.format(Messages.ObjectArrayImpl_forArray, index, this.getTechnicalName()));
            }
            long[] references = this.source.getHeapObjectReader().readObjectArrayContent(this, index, 1);
            return new Field(name, 2, new ObjectReference(this.source, references[0]));
        }
        catch (SnapshotException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<NamedReference> getOutboundReferences() {
        ArrayList<NamedReference> answer = new ArrayList<NamedReference>(this.getLength() + 1);
        answer.add(new PseudoReference(this.source, this.classInstance.getObjectAddress(), "<class>"));
        long[] refs = this.getReferenceArray();
        int i = 0;
        while (i < refs.length) {
            if (refs[i] != 0L) {
                StringBuilder builder = new StringBuilder();
                builder.append('[').append(i).append(']');
                answer.add(new NamedReference(this.source, refs[i], builder.toString()));
            }
            ++i;
        }
        return answer;
    }
}

