/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.snapshot.registry;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.hprof.Messages;
import org.eclipse.mat.inspections.CommonNameResolver;
import org.eclipse.mat.snapshot.extension.IClassSpecificNameResolver;
import org.eclipse.mat.snapshot.extension.Subject;
import org.eclipse.mat.snapshot.extension.Subjects;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.util.MessageUtil;

public final class ClassSpecificNameResolverRegistry {
    private static ClassSpecificNameResolverRegistry instance = new ClassSpecificNameResolverRegistry();
    private RegistryImpl registry = new RegistryImpl();

    static {
        ClassSpecificNameResolverRegistry.instance.registry.registerResolver(new CommonNameResolver.StringResolver());
        ClassSpecificNameResolverRegistry.instance.registry.registerResolver(new CommonNameResolver.StringBufferResolver());
        ClassSpecificNameResolverRegistry.instance.registry.registerResolver(new CommonNameResolver.ThreadResolver());
        ClassSpecificNameResolverRegistry.instance.registry.registerResolver(new CommonNameResolver.ThreadGroupResolver());
        ClassSpecificNameResolverRegistry.instance.registry.registerResolver(new CommonNameResolver.ValueResolver());
        ClassSpecificNameResolverRegistry.instance.registry.registerResolver(new CommonNameResolver.CharArrayResolver());
        ClassSpecificNameResolverRegistry.instance.registry.registerResolver(new CommonNameResolver.ByteArrayResolver());
        ClassSpecificNameResolverRegistry.instance.registry.registerResolver(new CommonNameResolver.URLResolver());
        ClassSpecificNameResolverRegistry.instance.registry.registerResolver(new CommonNameResolver.AccessibleObjectResolver());
        ClassSpecificNameResolverRegistry.instance.registry.registerResolver(new CommonNameResolver.FieldResolver());
        ClassSpecificNameResolverRegistry.instance.registry.registerResolver(new CommonNameResolver.MethodResolver());
        ClassSpecificNameResolverRegistry.instance.registry.registerResolver(new CommonNameResolver.ConstructorResolver());
    }

    public static ClassSpecificNameResolverRegistry instance() {
        return instance;
    }

    private ClassSpecificNameResolverRegistry() {
    }

    public static String resolve(IObject object) {
        if (object == null) {
            throw new NullPointerException(Messages.ClassSpecificNameResolverRegistry_Error_MissingObject.pattern);
        }
        return ClassSpecificNameResolverRegistry.instance().registry.doResolve(object);
    }

    private static class RegistryImpl {
        private Map<String, IClassSpecificNameResolver> resolvers = new HashMap<String, IClassSpecificNameResolver>();

        private String doResolve(IObject object) {
            try {
                IClass clazz = object.getClazz();
                while (clazz != null) {
                    IClassSpecificNameResolver resolver = this.resolvers.get(clazz.getName());
                    if (resolver != null) {
                        return resolver.resolve(object);
                    }
                    clazz = clazz.getSuperClass();
                }
                return null;
            }
            catch (RuntimeException e) {
                Logger.getLogger(ClassSpecificNameResolverRegistry.class.getName()).log(Level.SEVERE, MessageUtil.format(Messages.ClassSpecificNameResolverRegistry_ErrorMsg_DuringResolving, object.getTechnicalName()), e);
                return null;
            }
            catch (SnapshotException e) {
                Logger.getLogger(ClassSpecificNameResolverRegistry.class.getName()).log(Level.SEVERE, MessageUtil.format(Messages.ClassSpecificNameResolverRegistry_ErrorMsg_DuringResolving, object.getTechnicalName()), e);
                return null;
            }
        }

        public void registerResolver(IClassSpecificNameResolver resolver) {
            String[] subjects = this.extractSubjects(resolver);
            if (subjects != null && subjects.length > 0) {
                int ii = 0;
                while (ii < subjects.length) {
                    ((ClassSpecificNameResolverRegistry)ClassSpecificNameResolverRegistry.instance()).registry.resolvers.put(subjects[ii], resolver);
                    ++ii;
                }
            }
        }

        private String[] extractSubjects(IClassSpecificNameResolver instance) {
            String[] stringArray;
            Subjects subjects = instance.getClass().getAnnotation(Subjects.class);
            if (subjects != null) {
                return subjects.value();
            }
            Subject subject = instance.getClass().getAnnotation(Subject.class);
            if (subject != null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = subject.value();
            } else {
                stringArray = null;
            }
            return stringArray;
        }
    }
}

