/**
 * 根据屏幕尺寸，自适应动态更新css
 */
(function(){
    window.dyCss = function(){
        var ww = window.innerWidth;

        if(typeof ww != "number"){
            if(document.compatMode == "CSS1Compat"){
                ww = document.documentElement.clientWidth;
            }else{
                ww = document.body.clientWidth;
            }
        }

        var className = '';
        if(ww < 1280){
            className = '';
        }else if(ww >= 1280 && ww < 1440 ){
            className = 'body-1280';
        }else if(ww >= 1440){
            className = 'body-1440';
        }

        document.body.className = className;
    };
    dyCss();
    //后续代码要绑定此方法到resize事件
})();