<?
require_once('DATTR_HELP_ITEM.php');

class DATTR_HELP
{

	var $db = array();
	
	function &singleton() {
		static $instance;

		if (!isset($instance)) {
			$c = __CLASS__;
			$instance = new $c();
			$instance->init(); //there is php4 bug where constructor is not called..so workaround..call init()

		}

		return $instance;
	}

	function init() {
		$this->db['AIOBlockSize'] = new DATTR_HELP_ITEM('AIO Block Size', ' Specifies the sent block size for AIO.  The block size times total files in processing should be less than the physical  memory of the server, otherwise, AIO will not help. If your server has enough memory,  you can choose bigger size. Default value is 1M.  ', '', 'Select from drop down list');
		$this->db['CACertFile'] = new DATTR_HELP_ITEM('CA Certificate File', ' Specifies the file contains all certificates of Certification Authorities (CAs) for chained certificates.  It is simply the concatenation of PEM-encoded Certificate  files, in order of preference. This can be used alternatively or additionally to CA Certificate Path. Those certificates are for constructing the server certificate chain, which will be sent to browsers in addition to the server certificate. Those certificates will be  used for client certificate authentication as well. ', '', 'File name which can be an absolute path or relative to $SERVER_ROOT.');
		$this->db['CACertPath'] = new DATTR_HELP_ITEM('CA Certificate Path', ' Specifies the directory where the Certificates of Certification Authorities (CAs) are being kept. Those certificates are for constructing the server certificate chain, which will be sent to browsers in addition to the server certificate. Those certificates will be  used for client certificate authentication as well. ', '', 'path');
		$this->db['CGIPriority'] = new DATTR_HELP_ITEM('CGI Priority', ' Specifies priority of the external application process. Value ranges from -20 to 20, lower number means higher priority. This priority cannot be set higher (lower number) than server&#039;s or else the server&#039;s priority will be used. ', '', 'int');
		$this->db['CPUHardLimit'] = new DATTR_HELP_ITEM('CPU Hard Limit', ' Specifies maximum CPU consumption time limit in seconds for an external application process.  If the process continues to consume CPU time and reach the hard limit, the process  will be force killed. Operating system&#039;s default will be used if the value is set to 0 or absent. ', '', 'Integer number');
		$this->db['CPUSoftLimit'] = new DATTR_HELP_ITEM('CPU Soft Limit', ' Specifies CPU consumption time limit in seconds for an external application process. When the process  reaches the soft limit, it will be notified by a signal. Operating system&#039;s default will  be used if the value is set to 0 or absent. ', '', 'Integer number');
		$this->db['GroupDBLocation'] = new DATTR_HELP_ITEM('Group DB Location', ' Specifies the location of the group database.   Group information can be set either in user database or in this standalone group DB. For user authentication, user DB will be checked first, if there also contains group information, then group DB will not be checked.  <br><br>  For DB type of Password File, it is the path to the flat file containing group definitions. You can edit this file through the  WebAdmin by clicking on the file name.  Each line of the group file contains a groupname followed by a colon,  then followed by space delimited group user names. Example:<br><br> testgroup: user1 user2 user3   For DB type of LDAP, it is the LDAP URL to query group  information. For each valid group, one and only one record should be returned in the LDAP search request based on the this URL and group name specified in Required. &quot;$k&quot; must be specified in the filter part of the URL and it will be replaced with the group name. The name of the attribute that  specifies member in this group is specified by Group Member Attribute. <br><br> Example: If objectClass posixGroup is being used to store group information. The following URL could be used: <br><br> <br><br>ldap://localhost/ou=GroupDB,dc=example,dc=com???(&amp;(objectClass=*)(cn=$k)) <br><br>   ', '[Security] It is recommended to store a group file outside the document tree.  If it has to be placed inside document tree, simply name it with a leading &quot;.ht&quot;  like .htgroup to prevent being served as a static file.  LiteSpeed web server  does not serve files prefixed with &quot;.ht&quot;.', 'File name which can be absolute, or relative to $SERVER_ROOT, or relative to $VH_ROOT.');
		$this->db['LDAPBindDN'] = new DATTR_HELP_ITEM('LDAP Bind DN', ' Specifies a DN used to bind to the server. If the LDAP Server  requires authentication, a bind DN and password must be specified. If not specified, anonymous bind will be used.  ', '', 'string');
		$this->db['LDAPBindPasswd'] = new DATTR_HELP_ITEM('LDAP Bind Password', ' Specifies a password used to bind to the server. If the LDAP Server  requires authentication, a bind DN and password must be specified.   ', '', 'string');
		$this->db['SSLCryptoDevice'] = new DATTR_HELP_ITEM('SSL Hardware Accelerator', ' [Enterprise Edition Only] Specifies which SSL hardware acceleration device to use. Only devices supported by OpenSSL can be used. Select OpenSSL internal engine if no device is installed.  ', '', 'Select from drop down list');
		$this->db['TABLEaccessControl'] = new DATTR_HELP_ITEM('Access Control', 'Specifies what sub network and/or IP address can access the server.   This is a server level setting that affects all virtual hosts. You can also set up   access control unique to each virtual host. Virtual host setting will NOT   override the server setting. <br><br>    Whether to block/allow an IP is determined by the combination of allowed list and denied list.   If you want to block certain IP or sub-network, put * or ALL in   Allowed List and list the blocked IP or sub-network in Denied List.   If you want to only allow certain IP or sub-network, put * or ALL   in Denied List and list the allowed IP or sub-network in Allowed List.   The setting of the smallest scope that fits for an IP will be used to determine whether   to block or allow. <br><br>    Trusted IP or sub-network must be specified in the Allowed List by adding a   trailing &quot;T&quot;. Trusted IP or sub-network is not affected by connection/throttling limits.   Only server level access control can set up trusted IP/sub-network.', '[Security] Use this for general restrictions that apply to all virtual hosts.', '');
		$this->db['TABLEawstats'] = new DATTR_HELP_ITEM('AWStats Integration', 'AWStats is a popular log analyzer that generates advanced web server   statistics. LiteSpeed server seamlessly integrates AWStats into   its Web Admin Console. AWStats configuration and statistics update  have been taken care of by LiteSpeed server.', '', '');
		$this->db['TABLEcgiContext'] = new DATTR_HELP_ITEM('CGI Context', 'CGI context defines one CGI script or a group of CGI scripts.   CGI scripts can be either inside or outside of the document root.   When a file under the CGI directory is requested, the server will always   try to execute it as a CGI script, no matter if its executable or not.   In this way, file content is always protected under CGI context.   It is recommended that you put all your CGI scripts in a directory and set up a CGI context.', '', '');
		$this->db['TABLEerrPage'] = new DATTR_HELP_ITEM('Customized Error Pages', 'Whenever the server has a problem in processing a request,   the server will return an error code and an html page as the error message   to web client. Error codes are defined in the HTTP protocol (see RFC 2616).   LiteSpeed server has a built-in default error page for each error code.  A customized page can be configured for each error code. In LiteSpeed server,   error pages can be further customized to be unique for each virtual host.', '', '');
		$this->db['TABLEfcgiContext'] = new DATTR_HELP_ITEM('FastCGI Context', 'FastCGI application cannot be used directly. It must be either configured as   a script handler or mapped to a URL through FastCGI context. A FastCGI context will   associate a URI with a FastCGI application.', '', '');
		$this->db['TABLEgeneralContext'] = new DATTR_HELP_ITEM('General Context', 'General context is used to bring in files outside of the document root   like Apache&#039;s Alias or AliasMatch directive. It can also be used to protect   a particular directory, either inside or outside of the document root, using   authorization realms. General context can also be used to block or restrict access for a special directory  within the document root.', '', '');
		$this->db['TABLEgeolocationDB'] = new DATTR_HELP_ITEM('IP to Geolocation DB', '[Enterprise Edition Only] Multiple MaxMind geolocation databases can be specified here. MaxMind  has the following type of DB: Country, Region, City, Organization, ISP and  Netspeed.   For database type of Country, Region and City, the later type of DB contains   more information than that of a DB with former type, only one of those type of  DB should be specified, if multiple DBs with those types are configured, the  last one will be effective.', '', '');
		$this->db['TABLEhtaccess'] = new DATTR_HELP_ITEM('HT Access', 'The following directives are supported in a directory level  access control file.      Authentication            AuthType      AuthName      AuthUserFile      AuthGroupFile      Require              Access Control            Allow from      Deny from      Order              File Info            AddDefaultCharset      AddType      DefaultType      ExpiresActive      ExpiresDefault      ExpiresByType      ForceType      Redirect      RedirectTemp      RedirectPermanent      RewriteEngine      RewriteOptions      RewriteBase      RewriteCond      RewriteRule      Satisfy              Other        	&lt;Limit&gt;  	&lt;LimitExcept&gt;      DirectoryIndex      Options            ', '', '');
		$this->db['TABLEjavaWebAppContext'] = new DATTR_HELP_ITEM('Java Web App Context', 'Most Servlet engine has its own built-in HTTP server but they cannot efficiently serve static   content or as fast as LiteSpeed server can. In order to improve the overall performance,   LiteSpeed server can be configured as a gateway server, which serves static content   and forwards dyanmic java page requests to the Servlet engine. <br><br>  Without Java web app context, multiple contexts have to be created, including a general   context that matches the root directory of the web application, Servlet contexts for each   respective Servlet is defined in the web application&#039;s configuration file - WEB-INF/web.xml.   It is awkward and troublesome. Java web app context is introduced to eliminate this hassle by   importing a Java web application with only one context configuration. With java web app context,   all required contexts are created automatically based on web application&#039;s configuration file. <br><br>    There are a couple points you need to remember:     If the web application is packed into a war file, the war file must be expanded,   the server cannot access files in compressed archive.  A Script Handler for .jsp files should be defined as well.  For same resources, the same URL should be used no matter whether it is accessed   through LiteSpeed server or through the Servlet engine&#039;s built-in HTTP server.<br><br>   For example, the &quot;examples&quot; web application that comes with Tomcat should be imported.    Tomcat 4.1 is installed under /opt/tomcat, files of &quot;examples&quot; web application is     located at /opt/tomcat/webapps/examples/, through Tomcat&#039;s built-in HTTP server     &quot;examples&quot; web application is accessed with URI like /examples/***.     In order to use the same URI to access it, the context should be configured with:     URI = /examples/, Root = /opt/tomcat/webapps/examples/.    ', '', '');
		$this->db['TABLEperClientConnLimit'] = new DATTR_HELP_ITEM('Per Client Throttling Control', 'These are connection control settings based on client IP.   These settings help to mitigate DoS (Denied of Service) and DDoS (Distributed Denied of Service) attacks.', '', '');
		$this->db['TABLEproxyContext'] = new DATTR_HELP_ITEM('Proxy Context', 'Proxy context enables this virtual host as a transparent reverse  proxy server. Proxy server could be running in front of any web   servers or application servers that supports the HTTP protocol. External  web server has to be predefined in External Application.', '', '');
		$this->db['TABLErailsContext'] = new DATTR_HELP_ITEM('Rails Context', 'Rails context provides an easy way to configure a Ruby On Rails  application. To add a Rails application, only mounting URL and  application&#039;s root directory is required. No need to go through all  the trouble to define an external application, add 404 handler,   rewrite rule, etc.', '', '');
		$this->db['TABLErailsDefault'] = new DATTR_HELP_ITEM('Ruby Rails Settings', 'Default configuration for Ruby on Rails applications configured through  Rails Contexts.', '', '');
		$this->db['TABLErailsHosting'] = new DATTR_HELP_ITEM('Rails Shared Hosting', 'Rails shared hosting is supported by LiteSpeed Web Server since  release 3.2. By using our high performance, highly scalable Ruby LSAPI  module, LiteSpeed rails hosting solution can deliver the best  performance with minimum server resource requirement. In addition,  LiteSpeed Rails hosting solution is an independent solution, which  makes it compatible with all existing web hosting control panels. <br><br>    The user manageable Rails configuration file is located at user&#039;s home  directory or virtual host root directory, named as &quot;.ls_rails_config&quot;.   Syntax is like    #RailsApp       RailsApp testApp &quot;/lsws/testrails&quot; &quot;development&quot; 4 1    #RailsAppMap     RailsAppMap testApp &quot;testrails.com&quot; &quot;/&quot;  RailsAppMap testApp &quot;test.testrails.com&quot; &quot;/&quot;      &quot;App Path&quot; is relative to the user&#039;s home directory or the virtual  host root directory.     Whenever this file is touched, Rails applications will be restarted.', '', '');
		$this->db['TABLErealms'] = new DATTR_HELP_ITEM('Authorization Realms', 'Lists all authorization realms for this virtual host.   Authorization realms is used to block unauthorized users from accessing protected web pages.   A realm is a user directory containing user names and passwords with optional   group classification. Authorization is performed at context level.   Since different contexts can share the same realm(user database), so realms are defined separately.   You can refer to a realm by its name in context configuration.', '', '');
		$this->db['TABLEredirectContext'] = new DATTR_HELP_ITEM('Redirect Context', 'A Redirect Context can be used to forward one URI or a group of URIs to another location.   The destination URI can be either on the same web site (internal  redirect) or an absolute URI pointing to another web site (external redirect).', '', '');
		$this->db['TABLEservletContext'] = new DATTR_HELP_ITEM('Servlet Context', 'A single Servlet can be imported through Servlet context.   Just specifies the URI for the Servlet and the name of the Servlet engine.   You only need to use this when you do not want to import the whole web application   or you want to protect different Servlets with different authorization realms.   The URI has the same requirement as in Java Web App Context.', '', '');
		$this->db['TABLEsslProtocol'] = new DATTR_HELP_ITEM('SSL Protocol', 'Customizes SSL Protocols accepted by the listener.', '', '');
		$this->db['TABLEsslSetting'] = new DATTR_HELP_ITEM('SSL Private Key & Certificate', 'Every SSL listener requires a pair of SSL private key and SSL certificate.   Multiple SSL listeners can share same key and certificate.   SSL private key can be generated by yourself using SSL software  package, such as OpenSSL. SSL certificate can be purchased from an authorized certificate   issuer like VeriSign or Thawte. You can also sign the certificate by yourself,   but that certificate is not trusted and not supposed to be used on public web   sites containing critical data. However, the self signed certificate is good   enough for internal use, for e.g., for encrypting traffic for the  web administration console of LiteSpeed server.', '', '');
		$this->db['TABLEvhAccessControl'] = new DATTR_HELP_ITEM('Access Control', 'Specifies what sub-network and/or IP address can access this virtual host   in addition to server level access control. Virtual host setting does NOT override   the server setting. Whether to block/allow an IP is determined by the combination   of allowed list and denied list. If you want to block certain IP or sub-network,   put * or ALL in the allowed list and list the blocked IP or   sub-network in the denied list. If you want to only allow certain IP or sub-network,   put * or ALL in the denied list and list the allowed IP or   sub-network in the allowed list. The setting of the smallest scope that fits for   an IP will be used to determine whether to block or allow access.', '', '');
		$this->db['TABLEvhHotlink'] = new DATTR_HELP_ITEM('Hotlink Control', 'Hotlinking are requests made from an external website to  files on your own website often referred to as &quot;leeching&quot;. This practice  introduce additional bandwidth usage that you should not be responsible for. <br><br>  LiteSpeed server can prevent others from hotlinking content on  your web site by checking the &quot;Referer&quot; header within a HTTP request. If the &quot;Referer&quot; header does not match your own website,   the request is denied.', '', '');
		$this->db['TABLEvirtualHostMapping'] = new DATTR_HELP_ITEM('Virtual Host Mappings', 'Specifies the relationship between the listener and virtual hosts.   Listener and virtual hosts are associated by domain names.   A HTTP request will be routed to a virtual host with matching domain name.   One listener can map to multiple virtual hosts on different domain names.   One virtual host can also be mapped from different listeners.   One listener can allow one catchall virtual host with domain name &quot;*&quot;.   When there is no explicitly matched domain name, listener will forward   the request to that catchall virtual host.', '[Performance] Only add necessary mappings. If the listener is dedicated   to only one virtual host, then only set the catchall mapping with &quot;*&quot;.', '');
		$this->db['accessAllowed'] = new DATTR_HELP_ITEM('Access Allowed', ' Specifies which IP or sub-network is allowed to access resource under this context. Together with  Access Denied and server/vhost level access control, the accessibility is determined by  the smallest scope that client&#039;s IP address falls into.  ', '', 'comma-delimited list of IP/sub-network.  sub-network can be like 192.168.1.0/255.255.255.0, 192.168.1 or 192.168.1.*.');
		$this->db['accessControl'] = new DATTR_HELP_ITEM('Access Control', 'Specifies what sub network and/or IP address can access the server.   This is a server level setting that affects all virtual hosts. You can also set up   access control unique to each virtual host. Virtual host setting will NOT   override the server setting. <br><br>    Whether to block/allow an IP is determined by the combination of allowed list and denied list.   If you want to block certain IP or sub-network, put * or ALL in   Allowed List and list the blocked IP or sub-network in Denied List.   If you want to only allow certain IP or sub-network, put * or ALL   in Denied List and list the allowed IP or sub-network in Allowed List.   The setting of the smallest scope that fits for an IP will be used to determine whether   to block or allow. <br><br>    Trusted IP or sub-network must be specified in the Allowed List by adding a   trailing &quot;T&quot;. Trusted IP or sub-network is not affected by connection/throttling limits.   Only server level access control can set up trusted IP/sub-network.', '[Security] Use this for general restrictions that apply to all virtual hosts.', '');
		$this->db['accessControl_allow'] = new DATTR_HELP_ITEM('Allowed List', ' Specifies the list of IPs or sub-networks allowed. ', '[Security] Trusted IPs or sub-networks set at server level access  control will be excluded from connection/throttling limits.', 'Comma delimited list of IP addresses or sub-networks.  * or ALL, sub-network can be like  192.168.1.0/255.255.255.0, 192.168.1.0/24, 192.168.1 or 192.168.1.*. <br><br> IPv6 address should be like ::1 or [::1], IPv6 subnet should be like 3ffe:302:11:2:20f:1fff:fe29:717c/64 or  [3ffe:302:11:2:20f:1fff:fe29:717c]/64. A trailing &quot;T&quot; can be used to indicate a trusted IP or sub-network, like 192.168.1.*T.');
		$this->db['accessControl_deny'] = new DATTR_HELP_ITEM('Denied List', ' Specifies the list of IPs or sub-networks disallowed. ', '', 'Comma delimited list of IP address or sub-network, * or ALL,  sub-network can be like  192.168.1.0/255.255.255.0, 192.168.1.0/24, 192.168.1 or 192.168.1.*. <br><br> IPv6 address should be like ::1 or [::1], IPv6 subnet should be like 3ffe:302:11:2:20f:1fff:fe29:717c/64 or  [3ffe:302:11:2:20f:1fff:fe29:717c]/64.');
		$this->db['accessDenied'] = new DATTR_HELP_ITEM('Access Denied', ' Specifies which IP or sub-network is NOT allowed to access resource under this context.  Together with Access Allowed and server/vhost level access control, the accessibility is  determined by the smallest scope that client&#039;s IP address falls into.  ', '', 'comma-delimited list of IP/sub-network. sub-network can be like  192.168.1.0/255.255.255.0, 192.168.1 or 192.168.1.*.');
		$this->db['accessDenyDir'] = new DATTR_HELP_ITEM('Access Denied Directories', ' Specifies the directories that should be blocked from access.  Add directories that contain sensitive data to this list to prevent accidentally  exposing sensitive files to clients. Append a &quot;*&quot; to the path to include all sub-directories.  If both Follow Symbolic Link and Check Symbolic Link are enabled, symbolic  links will be checked against the denied directories. ', '[Security] Critical. It only prevents serving static files to clients and  does not prevent error prone from external scripts such as PHP/Ruby/CGI.', 'comma-delimited list of directories');
		$this->db['accessFileName'] = new DATTR_HELP_ITEM('Access File Name', ' Specifies the name of the access control file. The file will be used only if  Allow Override is enabled. Default name is .htaccess.  ', '', 'file name with leading &quot;.&quot;');
		$this->db['accessLog_bytesLog'] = new DATTR_HELP_ITEM('Bytes Log', ' Specifies the path to the bandwidth bytes log file. When specified, a CPanel compatible bandwidth log will be created. Will log  the total bytes transfered for a request including both request and reply body. ', '[Performance] Put the log file on a separate disk.', 'File name which can be an absolute path or relative to $SERVER_ROOT.');
		$this->db['accessLog_compressArchive'] = new DATTR_HELP_ITEM('Compress Archive', ' Specifies whether to compress rotated log files in order to save disk space. ', 'Log files are highly compressible and this is recommended to reduce disk usage for old logs.', 'Select from radio box');
		$this->db['accessLog_fileName'] = new DATTR_HELP_ITEM('File Name', ' Specifies the file name of the access log file.  ', '[Performance] Put access log file on a separate disk.', 'File name which can be an absolute path or relative to $SERVER_ROOT.');
		$this->db['accessLog_keepDays'] = new DATTR_HELP_ITEM('Keep Days', ' Specifies how many days the access log file will be kept on disk.  Only rotated log file older than specified days will be deleted and the active current  log file will not be touched regardless how many days&#039; data it contains.  If you do not want to auto-delete stale and very old log files, set this value to 0. ', '', 'Integer number');
		$this->db['accessLog_logFormat'] = new DATTR_HELP_ITEM('Log Format', ' [Enterprise Edition Only] Specifies the log format for access log. When log format is set, it will override Log Level setting. The syntax of log format is compatible with  Apache 2.0&#039;s custom log format.  ', '', 'string');
		$this->db['accessLog_logHeader'] = new DATTR_HELP_ITEM('Log Headers', ' Specifies whether to log HTTP request headers: Referer, UserAgent, and Host. ', '[Performance] Turn it off if you do not need these headers in the access log.', 'Select from checkbox');
		$this->db['accessLog_pipedLogger'] = new DATTR_HELP_ITEM('Piped Logger', ' Specifies the external application that will receive the access log data sent by LiteSpeed through a pipe on its STDIN stream (file handle 0). When specified, access log will be sent only to the logger application but not the access log file specified in previous entry. <br><br> Logger process is spawned in the same way as other external (CGI/FastCGI/LSAPI) processes, which means it will execute as the uid according to the virtual host&#039;s configuration of ExtApp Set UID Mode,  and will never run on behalf of a privileged user. <br><br> The logger application must be defined in External Application section first. Server level access logging can only use external logger application defined at server level, while virtual host level access log can only use logger application defined at virtual host level.<br><br> The LiteSpeed server performs simple load balancing among multiple logger applications if more than one instance of logger application is configured.  LiteSpeed server always attempts to keep the number of logger application as low as possible. Only when one  logger application failed to process access log entries in time will the  server attempt to spawn another instance of logger application. <br><br> If a logger crashes, the web server will start another instance but the log data in the stream buffer will be lost. <br><br> It is possible to lose log data if external loggers cannot keep up with the speed and volume of the log stream. ', '', 'Select from drop down list');
		$this->db['aclogUseServer'] = new DATTR_HELP_ITEM('Log Control', ' Specifies where to write access log. There are three options:  1. write to server&#039;s access log; 2. create its own access log; 3. disable access logging. ', '', 'Select from drop down list');
		$this->db['addDefaultCharset'] = new DATTR_HELP_ITEM('Add Default Charset', ' Specifies whether to add a character set tag to the 	   &quot;Content-Type&quot; response header, when content type is either 	   &quot;text/html&quot; or &quot;text/plain&quot; without any parameter. 	   When set to Off,  this function is disabled. When set to 	   On, either character set specified by 	   Customized Default Charset or the default &quot;iso-8859-1&quot; will be added. ', '', 'Select from radio box');
		$this->db['addMIMEType'] = new DATTR_HELP_ITEM('MIME Type', ' Specifies additional MIME types and mappings for this 	   context. New mappings will override existing mappings under this 	   context and its children contexts.<br><br> 	   Example:<br><br> 			image/jpg jpeg jpg, image/gif gif<br><br> 	   If you want to show PHP scripts as text files instead of being 	   executed as scripts, just override the .php mapping to MIME type 	   &quot;text/plain&quot;.  ', '', 'MIME-type1 extension extension ..., MIME-type2 extension ... 		Use comma to separate between MIME types, use space to 		separate multiple extensions.');
		$this->db['adminEmails'] = new DATTR_HELP_ITEM('Administrator Email', ' Specifies the server administrator&#039;s email address(es). It is a comma delimited list.  If specified, administrators will be notified by email of important events: i.e.   when the LiteSpeed service is restarted automatically due to crash detection. ', 'Email alert feature will only work if the server has an active MX server such as postfix, exim, or sendmail.', 'comma delimited list of email address.');
		$this->db['adminUser'] = new DATTR_HELP_ITEM('Admin User', ' Change user name and password for WebAdmin Console. Click Edit to change user name or password. Old password has to be entered and verified in order to save the changes.   ', 'If you forget the admin password, you cannot change it from the Web Administration Console. Please use the following command from shell: [your install dir]/admin/misc/admpass.sh', '');
		$this->db['allowBrowse'] = new DATTR_HELP_ITEM('Accessible', ' Specifies whether this context can be accessed. Set to No to deny access.  You can use this feature to protect the specified directory from being visited.  You may use it when you are updating contents for this context, or you have special data in this directory. ', '', 'Select from radio box');
		$this->db['allowDirectAccess'] = new DATTR_HELP_ITEM('Allow Direct Access', ' Specifies whether to allow direct access without a referrer. There is no &quot;Referer&quot; header in HTTP request when a user types in an address directly in the address box, or uses a feature like &quot;Save Target Link As&quot;.  ', '', 'Select from radio box');
		$this->db['allowOverride'] = new DATTR_HELP_ITEM('Allow Override', ' Specifies what directives in an access control file are allowed.  An access control file can be placed in a directory to control the accessibility  to files under that directory. <br><br>  	When nothing is checked, inherited default settings will be 	used.  	When None is checked, access control file will be 	ignored. 	 	When Limit is checked, directives &quot;Order&quot;, 	&quot;Allow from&quot; and &quot;Deny from&quot; are allowed.  	When Auth is checked, directives 	&quot;AuthGroupFile&quot;,  &quot;AuthName&quot;, &quot;AuthType&quot;,  	&quot;AuthUserFile&quot;, &quot;Require&quot; are allowed. 	When FileInfo is checked, directives 	&quot;Satisfy&quot;, AddDefaultCharset&quot;, &quot;AddType&quot;, 	&quot;DefaultType&quot;, &quot;ForceType&quot;, &quot;ExpiresActive&quot;, &quot;ExpiresDefault&quot;, 	&quot;ExpiresByType&quot;, &quot;Redirect&quot;, &quot;RedirectTemp&quot;, &quot;RedirectPermanent&quot;, 	&quot;RewriteEngine&quot;, &quot;RewriteOptions&quot;, &quot;RewriteBase&quot;, &quot;RewriteCond&quot; 	and &quot;RewriteRule&quot; are allowed 	When Indexes is checked, directive 	&quot;DirectoryIndex&quot; is allowed 	When Options is checked, directive 	&quot;Options&quot; is allowed   Allow Override configuration is available at three levels: server,  virtual host and context. If server level configuration is not checked,  the controlled directives will be disabled for the whole server no matter if  it is enabled or not at lower levels. If server level is enabled, virtual host will  inherit same settings by default, similarly context level will inherit virtual host settings.  In other words, lower level can disable a setting that is enabled by upper level, but cannot  enable a setting that is disabled by upper level. ', '[Performance] If there is no need for directory level configuration customization, check None.', 'Select from checkbox');
		$this->db['allowSetUID'] = new DATTR_HELP_ITEM('Allow Set UID', ' Specifies whether Set UID bit is allowed for CGI scripts. If Set UID bit is allowed and the Set UID bit is on for a CGI script,  no matter which user the CGI script was started on behalf of, user id of the CGI process will switch to the user id of the owner of the CGI script. <br><br> Default is false. ', '[Security] Do not allow Set UID CGI script whenever possible as it is an inherent security risk.', 'Select from radio box');
		$this->db['allowSymbolLink'] = new DATTR_HELP_ITEM('Follow Symbolic Link', ' Specifies whether to follow symbolic links in this virtual host.  IF OWNER MATCH option will follow a symbolic link only if it has the same ownership.  This setting overrides the default server level setting. ', '[Performance &amp; security] For better security, disable this feature. For better performance, enable it.', 'Select from drop down list');
		$this->db['allowedHosts'] = new DATTR_HELP_ITEM('Allowed Domains', ' Specifies which web site can link to protected content. ', '', 'comma delimited list of domain name');
		$this->db['apacheBinPath'] = new DATTR_HELP_ITEM('Apache Binary Path', ' Specifies the location of Apache binary. Usually, it is located at /usr/local/apache/bin/httpd or /usr/local/apache2/bin/httpd, etc. This option must be set when &quot;Use Apache binary wrapper&quot; is used for Auto Reload On Changes.  ', '', '');
		$this->db['apacheConf'] = new DATTR_HELP_ITEM('Apache Style Configurations', ' Specifies Apache configuration directives that are supported by LiteSpeed. For example, default PHP configuration, php.ini entries, can be overridden by the server with 4 directives: &quot;php_value&quot;, &quot;php_flag&quot;,  &quot;php_admin_value&quot; and &quot;php_admin_flag&quot;. ', '', 'Same as Apache configuration file');
		$this->db['apacheConfFile'] = new DATTR_HELP_ITEM('Apache Configuration File', ' Specifies the location of Apache configuration  file. Usually, it is located at /usr/local/apache/conf/httpd.conf or /etc/httpd/conf/httpd.conf. ', '', '');
		$this->db['apacheEnableFP'] = new DATTR_HELP_ITEM('Enable FrontPage Extension', ' Specifies whether to explicitly enable Microsoft Front Page Server Extension or not. Usually, LSWS will enable it when module &quot;frontpage&quot; has been loaded in Apache httpd.conf. however, when mod_frontpage is statically linked into Apache binary, configuration for frontpage module is not in httpd.conf, you need to enabled it explicitly here. Default is disabled.  ', '', 'Select from radio box');
		$this->db['apacheHandledContent'] = new DATTR_HELP_ITEM('Apache Handled Content', ' Specifies what resources will be passed to and processed by backend Apache. Resources are specified by a comma delimited list of URI, file suffixes or regular expression. A URI starts with &#039;/&#039;; a suffix starts with &#039;.&#039;, a regular expression starts with &quot;exp:&quot; prefix. For example: &quot;/svn/, .shtml&quot; let Apache handle requests with URI starting with &quot;/svn/&quot; or ending with &quot;.shtml&quot;. The same effect can be achieved with regular expression &quot;exp:^/svn/, exp:\.shtml$&quot;.<br><br> This feature requires running Apache parallel to LiteSpeed on either another IP or a different port, so either &quot;Apache Port Offset&quot; or &quot;Apache IP Offset&quot; should be set to none zero value.    ', '', '');
		$this->db['apacheIgnoredModules'] = new DATTR_HELP_ITEM('Ignore Apache Modules', ' Specifies a list of Apache modules that should be ignored by LiteSpeed while parsing Apache configuration file. LiteSpeed will treat the listed modules as unsupported; configuration directives enclosed in &lt;IfModule ...&gt; ... &lt;/IfModule&gt; will be ignored.  ', '', 'comma delimited list of module names');
		$this->db['apacheIpOffset'] = new DATTR_HELP_ITEM('Apache IP Offset', ' Specifies an offset to be added to listening IP address specified in Apache configuration file. This will allow LiteSpeed to run alongside with Apache to test things out. The offset is in numberic format, not in IP address format. Adding &quot;256&quot; will add &#039;1&#039; to the value of C class subnet, This option only works with IPv4 address.   ', '', '');
		$this->db['apachePortOffset'] = new DATTR_HELP_ITEM('Apache Port Offset', ' Specifies an offset to be added to listening TCP ports specified in Apache configuration file. This will allow LiteSpeed to run alongside with Apache to test things out instead of switching between LiteSpeed and Apache back and forth on a production server.  When you are testing, it should be set to a non-zero value, the ports configured in Apache configuration plus this offset will be used by LiteSpeed; After confirming that everything works properly, you can stop Apache, set this option to 0, and then restart LiteSpeed. If 0 or the value is not set, the original port specified in Apache configuration file will be used.  ', '', '');
		$this->db['authName'] = new DATTR_HELP_ITEM('Authentication Name', ' Specifies an alternative name of the authorization realm for current context.  If it is not specified, the original realm name will be used. Authentication name is  displayed on the browser&#039;s login pop-up. ', '', '');
		$this->db['autoFix503'] = new DATTR_HELP_ITEM('Auto Fix 503 Error', ' Specifies whether to try to fix the &quot;503 Service Unavailable&quot; error by restarting the web server gracefully. A &quot;503&quot; error is usually caused by malfunctioned external applications and a web server restart can often fix the error temporarily. If enabled, the server will restart automatically whenever there are more than 30 &quot;503&quot; errors within a 30 seconds span. Feature is enabled by default.   ', '', 'Select from radio box');
		$this->db['autoIndex'] = new DATTR_HELP_ITEM('Auto Index', ' Specifies whether to generate directory index on the fly when index files listed in Index Files are not available in a directory. This option is customizable under virtual host and context level, and is inherited along the directory tree until it is explicitly overridden. You can customize the generated index page, please read How to customize auto index script?  ', '[Security] It is recommended to turn off Auto Index wherever possible to prevent revealing confidential data.', 'Select from radio box');
		$this->db['autoIndexURI'] = new DATTR_HELP_ITEM('Auto Index URI', ' Specifies the URI that will be used to generate the index page when index files listed in Index Files are not available in a directory. LiteSpeed server uses an external script to generate the index page providing the maximum customization flexibility. The default script produces an index page with same look as Apache&#039;s. To customize the generated index page, please read How to customize auto index script? The directory to be indexed is passed to the script via an environment variable &quot;LS_AI_PATH&quot;. ', '', 'URI');
		$this->db['autoReloadApacheConf'] = new DATTR_HELP_ITEM('Auto Reload On Changes', ' Specifies how to apply Apache configuration changes. When set to &quot;yes&quot;, LSWS will perform a graceful restart, whenever the Apache configuration file has been modified. It works, but LSWS may restart multiple times during updating Apache configuration. A better solution is introduced in 3.3.8 release, &quot;Using Apache binary wrapper&quot;. This will replace Apache httpd binary with a wrapper script, whenever Apache is requested to start/stop/restart, the script will tell LSWS to take corresponding action. Apache Binary Path must be set. Default is &quot;No&quot;.   ', '', 'Select from radio box');
		$this->db['autoRestart'] = new DATTR_HELP_ITEM('Auto Restart', ' Enables service auto-recovery: automatically recreating a new server process when current server exits abnormally.<br><br>  When this option is enabled, there are two instances of server process &quot;lshttpd&quot;. The parent process  monitors the child process and will create a new child process if the current one exits abnormally.  However, if current child process exits normally, the parent process will exit as well. You can use  the shell command  lswsctrl stop or directly kill the child process; the parent process will  exit assuming that you do want to shut down the server. If the server is started by a super user,  the child process will change its ownership based on Running As configuration, and the parent  process will not change its user/group. ', '[Security] Parent process&#039;s only job is to monitor the child, does not interact with the outside world, and therefore safe to execute as a super user.<br><br> &amp;nbsp;&amp;nbsp;[Reliability] This feature should always be enabled for an extra layer protection against service down time.', 'Select from radio box');
		$this->db['autoStart'] = new DATTR_HELP_ITEM('Auto Start', ' Specifies whether you want the web server to start the application automatically. Only local FastCGI and LSAPI application running on the same machine can be started automatically. The IP in the Address must be a local IP.  ', '', 'Select from radio box');
		$this->db['autoUpdateDownloadPkg'] = new DATTR_HELP_ITEM('Download Updates', ' Specifies whether to auto-download the new product release package file when available. If a new package has been successfully downloaded, an online one-click upgrade can be performed via the web administration console under &quot;Service Manager&quot;-&gt;Version Management.  ', '', 'Select from drop down list');
		$this->db['autoUpdateInterval'] = new DATTR_HELP_ITEM('Check For Update', ' Specifies how often the update agent will check for new product release. Options are &quot;Daily&quot;, &quot;Weekly&quot;, or &quot;Monthly&quot;. ', '', 'Select from drop down list');
		$this->db['awstats'] = new DATTR_HELP_ITEM('AWStats Integration', 'AWStats is a popular log analyzer that generates advanced web server   statistics. LiteSpeed server seamlessly integrates AWStats into   its Web Admin Console. AWStats configuration and statistics update  have been taken care of by LiteSpeed server.', '', '');
		$this->db['awstatsRealm'] = new DATTR_HELP_ITEM('Authentication Realm', ' Specifies a authorization realm for the statistical results. When specified, only authorized users can view the results.   ', '', 'Select from drop down list');
		$this->db['awstatsURI'] = new DATTR_HELP_ITEM('AWStats URI', ' Specifies the URI where the AWStats results can be accessed in this virtual host. For example, if this URI is set to /awstats/ for virtual host www.example.com, then the full URL to AWStats page is http://www.example.com/awstats/. .   ', 'The URI should be unique among  those existing content within this virtual host. Otherwise, overlapped content will be inaccessible.', 'uri');
		$this->db['backlog'] = new DATTR_HELP_ITEM('Back Log', ' Specifies the backlog of the listening socket.  Required if Auto Start is enabled. ', '', 'Integer number');
		$this->db['banPeriod'] = new DATTR_HELP_ITEM('Banned Period (sec)', ' Specifies for how long new connections will be rejected from an IP at the end of  Grace Period (sec) if the number of connections is still more than .  If the IP continues to go over limit after a grace period, you should configured it that the IP be banned a even longer time value. ', '', 'Integer number');
		$this->db['blockBadReq'] = new DATTR_HELP_ITEM('Block Bad Request', ' Block IP that keeps sending bad-formated HTTP request for Banned Period (sec). Defaul is Yes.  This helps to block botnet attacks in the form of repetitively sending junk requests.  ', '', 'Select from radio box');
		$this->db['cachePolicy:enableCache'] = new DATTR_HELP_ITEM('Enable Cache', ' Specify whether to turn on cache for current context, either at server level, virtual host level or directory level. <br><br> Virtual hosts configured through Apache httpd.conf can use &quot;CacheEnable&quot;, &quot;CacheDisable&quot; directives at server, virtualhost, directory, files, location  level or in .htaccess. When used at directory level or in .htaccess, &quot;CacheEnable&quot;, &quot;CacheDisable&quot; will be applied to all directory below current level. &quot;CacheEnable&quot; &quot;CacheDisable&quot; directives are compatible with Apache mod_cache directives. However, when used at directory, files, location level or in  a .htaccess,  &quot;CacheEnable&quot;, &quot;CacheDisable&quot; will only be applied to all directories below  current level, url parameter will be ignored.   ', '[Performance] It is not recommended to store large objects with low hit rate into the cache. It may result in high I/O wait and reduce overall server performance.', 'Integer number');
		$this->db['cachePolicy:enablePrivateCache'] = new DATTR_HELP_ITEM('Enable Private Cache', ' Specify whether to turn on private cache for current context, either at server level, virtual host level or directory level. <br><br> Private cache will cache a copy per user based on IP and cookies.<br><br>  Virtual hosts configured through Apache httpd.conf can use &quot;CacheEnable private /url&quot;, &quot;CacheDisable private /url&quot; directives at server, virtualhost, directory, files, location  level or in .htaccess. When used at directory level or in .htaccess, &quot;CacheEnable private&quot;, &quot;CacheDisable private&quot; will be applied to all directory below current level. However, when used at directory, files, location level or in  a .htaccess, &quot;CacheEnable private&quot;, &quot;CacheDisable private&quot; will be applied to all directories below  current level, url parameter will be ignored.   ', '[Performance] It is not recommended to store large objects with low hit rate into the cache. It may result in high I/O wait and reduce overall server performance.', 'Integer number');
		$this->db['cachePolicy:expireInSeconds'] = new DATTR_HELP_ITEM('Cache Expire Time (Seconds)', ' Specify how long the object will be cached. Default is 86400 seconds (one day). ', '', 'Integer number');
		$this->db['cachePolicy:ignoreReqCacheCtrl'] = new DATTR_HELP_ITEM('Ignore Request Cache-Control', ' Specify whether to ignore &quot;Cache-Control&quot; request header. Default is no. If set to yes, server may serve cached object when &quot;no-cache&quot; has been set in &quot;Cache-Control&quot;. ', '', 'Select from drop down list');
		$this->db['cachePolicy:ignoreRespCacheCtrl'] = new DATTR_HELP_ITEM('Ignore Response Cache-Control', ' Specify whether to ignore &quot;Cache-Control&quot; response header.  Default is no. If set to yes, response can be cached by server even when &quot;No-store&quot;, &quot;private&quot; has been set in &quot;Cache-Control&quot; header. ', '', 'Select from drop down list');
		$this->db['cachePolicy:privateExpireInSeconds'] = new DATTR_HELP_ITEM('Private Cache Expire Time (Seconds)', ' Specify how long the object will be cached in private cache. Default is 60 seconds. ', '', 'Integer number');
		$this->db['cachePolicy:qsCache'] = new DATTR_HELP_ITEM('Cache Request with Query String', ' Specify whether to cache a request with Query String in the URL. Default is no cache. When URL rewrite is involved, the rewriten URL will be checked against. ', '', 'Select from drop down list');
		$this->db['cachePolicy:reqCookieCache'] = new DATTR_HELP_ITEM('Cache Request with Cookie', ' Specify whether to cache a request containing cookie. Default is no cache.  ', '', 'Select from drop down list');
		$this->db['cachePolicy:respCookieCache'] = new DATTR_HELP_ITEM('Cache Response with Cookie', ' Specify whether to cache a response containing cookie. Default is no cache.  ', '', 'Select from drop down list');
		$this->db['cacheStorePath'] = new DATTR_HELP_ITEM('Storage Path', ' Specify the directory that holding cached objects. It should be a directory. Currently LiteSpeed cache store each object in its own file, the file name is a hash of the object key, multiple level of directories will be created in order to avoid holding too many files in one directory. Value must be set in order to enable cache feature. ', '[performance] Assign a dedicate disk or disk array as the cache storage. RAID0 is recommended.', 'Select from drop down list');
		$this->db['censorLogLevel'] = new DATTR_HELP_ITEM('Log Level', ' Specifies the log level of the censoring engine debug output. Value ranges from 0 - 9, 0 will disable logging and 9 will produce the most detailed log. The log level of the server and the virtual host&#039;s error log must be set to at least INFO for this option to take effect. This is useful when testing your censoring rules.  ', '', 'Integer number');
		$this->db['censorRuleSet'] = new DATTR_HELP_ITEM('Rules Definition', ' Specifies a list of censorship rules. Syntax of censoring rule follow Apache&#039;s mod_security directives. &quot;SecFilter&quot; or &quot;SecFilterSelective&quot; can be  used here.  You can copy and paste Security Rules in Apache configuration  file. If you are using apache config file, you have to set up rules in httpd.conf  and rules defined here has no effect. For more details about rule syntax, please refer to Mod Security document.   ', '', 'string');
		$this->db['censorRuleSetEnabled'] = new DATTR_HELP_ITEM('Enabled', ' Specifies whether to enable this rule set. With this option, a rule set can be quickly turned on and off without adding or removing the rule set. Default is yes.  ', '', 'Select from radio box');
		$this->db['censorRuleSetName'] = new DATTR_HELP_ITEM('Name', ' Give a group of censorship rules a name, for display only.  ', '', 'string');
		$this->db['certChain'] = new DATTR_HELP_ITEM('Chained Certificate', ' Specifies whether the certificate is a chained certificate or not. The file that stores a certificate chain must be in PEM format, and the certificates must be in the chained order, from the lowest level (the actual client or server certificate), to the highest level (root) CA. ', '', 'Select from radio box');
		$this->db['certFile'] = new DATTR_HELP_ITEM('Certificate File', ' Specifies the file name of the SSL certificate file. ', '[Security] The certificate file should be placed in a secured directory,  which allows only readable access by the user that the server running as.', 'File name which can be an absolute path or relative to $SERVER_ROOT.');
		$this->db['cgiContext'] = new DATTR_HELP_ITEM('CGI Context', 'CGI context defines one CGI script or a group of CGI scripts.   CGI scripts can be either inside or outside of the document root.   When a file under the CGI directory is requested, the server will always   try to execute it as a CGI script, no matter if its executable or not.   In this way, file content is always protected under CGI context.   It is recommended that you put all your CGI scripts in a directory and set up a CGI context.', '', '');
		$this->db['cgidSock'] = new DATTR_HELP_ITEM('CGI Daemon Socket', ' A unique socket address used to communicate with CGI daemon. LiteSpeed server uses a standalone CGI daemon to  spawn CGI scripts for best performance and security. Default socket is &quot;uds://$SERVER_ROOT/admin/conf/.cgid.sock&quot;. If you need to put in other location, specifies a Unix Domain Socket here. ', '', 'UDS://path<br><br>Example: UDS://tmp/lshttpd/cgid.sock.');
		$this->db['checkSymbolLink'] = new DATTR_HELP_ITEM('Check Symbolic Link', ' Specifies whether to check symbolic links against Access Denied Directories  when Follow Symbolic Link is turned on. If enabled, the canonical real path of the resource  referred by a URL will be checked against the configurable access denied directories.  Access will be denied if it falls inside an access denied directory. ', '[Performance &amp; security] For best security, enable this option. For best performance, disable it.', 'Select from radio box');
		$this->db['chrootMode'] = new DATTR_HELP_ITEM('ExtApp Chroot Mode', ' [Enterprise Edition Only] Specifies how the root directory is set for an external application process. In order to protect confidential system data file from being accessed by a vulnerable external application script, an alternative root path can be set for the external application process and files beyond the new root directory become inaccessible. It is generally referred to as a &quot;chroot jail&quot;.<br><br>  Three choices are available:  Same as Server: external application process is in the same jail as specified in the server level.     Virtual host root: set chroot jail to the root directory of the virtual host and external application script can only access files inside the virtual host root;  	Customized chroot path: chroot path is specified by ExtApp Chroot Path below.    ', 'If used properly, chroot will greatly enhance the security of external application scripts.  Make sure the external application script is functional in the limited chroot jail environment.', 'Select from drop down list');
		$this->db['chrootPath'] = new DATTR_HELP_ITEM('ExtApp Chroot Path', ' [Enterprise Edition Only] Specifies a new root directory for external application scripts of current virtual host when ExtApp Chroot Mode is set to Customized chroot path.  ', '', 'Absolute path.');
		$this->db['clientVerify'] = new DATTR_HELP_ITEM('Client Verification', '[Enterprise Edition Only] Specifies the type of client certifcate authentication. Available types are   none: no client certificate is required optional: client certificate is optional require: the client must has valid certificate optional_no_ca: same as optional   In practise, you should really use &quot;none&quot; or &quot;require&quot;. Default is none.  ', '', 'Select from drop down list');
		$this->db['compressibleTypes'] = new DATTR_HELP_ITEM('Compressible Types', ' Specifies what MIME types are allowed to be compressed. For example,  if you want to compress text/* but not text/css, you can have a rule like  text/*, !text/css. &quot;!&quot; will exclude that mime type. ', '[Performance] Only allow types that will benefit from GZIP compression. Binary  files such as gif/png/jpeg images and flash files do not benefit from compression.', 'MIME type list separated by commas. Wild card &quot;*&quot; and  negate sign &quot;!&quot; are allowed, i.e. text/*, !text/js.');
		$this->db['configFile'] = new DATTR_HELP_ITEM('Config File', ' Specifies the configuration file name for this virtual host.  If the configuration file is placed under the virtual host root,  $VH_ROOT/conf/vhconf.xml is recommended; if it is placed under the server root,  $SERVER_ROOT/conf/{VirtualHostName}.xml is recommended. ', '', 'File name which can be absolute, or relative to $SERVER_ROOT, or relative to $VH_ROOT.');
		$this->db['connTimeout'] = new DATTR_HELP_ITEM('Connection Timeout', ' Specifies the maximum allowed connection idle time during processing one request.  The connection will be closed whenever it is idle, no i/o activity, for this period  of time.  ', '[Security] Set it to as low as you can to help recover dead  connections during potential DoS attack.', 'Integer number');
		$this->db['consoleSessionTimeout'] = new DATTR_HELP_ITEM('Session Timeout (secs)', ' Customize the session timeout of WebAdmin Console. Default is 60 secs if no value is set. ', '[Security] Set a proper value for production use, usually should be less than 300 seconds.', 'Integer number');
		$this->db['crlFile'] = new DATTR_HELP_ITEM('Client Revocation File', '[Enterprise Edition Only] Specifies the file contains PEM-encoded CA CRLs for revoked  client certificates. This can be used alternatively and/or additionally to  Client Revocation Path. ', '', 'File name which can be an absolute path or relative to $SERVER_ROOT.');
		$this->db['crlPath'] = new DATTR_HELP_ITEM('Client Revocation Path', '[Enterprise Edition Only] Specifies the directory containing PEM-encoded CA CRLs files for revoked  client certificates. The files in this directory have to be PEM-encoded and are accessed through hash filenames, hash-value.rN. Please refer to openSSL or Apache mod_ssl documentation regarding creating the hash filename.  ', '', 'path');
		$this->db['defaultAction'] = new DATTR_HELP_ITEM('Default Action', ' Specifies the default actions should be taken when a censoring rule was matched. The action string is compatible with the syntax of Apache mod_security, please refer to mod_security manual for more detail. Default value is &quot;deny,log,satatus:403&quot;, which means to deny access with status code 403 and log the incident in the error log.  ', '', 'string');
		$this->db['defaultCharsetCustomized'] = new DATTR_HELP_ITEM('Customized Default Charset', ' Specifies a character set to be used when Add Default Charset 	   is On. This is optional. Default value is iso-8859-1. 	   This entry has no effect when Add Default Charset is 	   Off. ', '', 'name of a character set, like utf-8');
		$this->db['defaultType'] = new DATTR_HELP_ITEM('Default MIME Type', ' When specified, this type will be used when MIME type mapping 	   cannot be determined by the suffix of a document or no suffix. 	   If not specified, default value  	   application/octet-stream will be used. ', '', 'MIME-type');
		$this->db['destinationuri'] = new DATTR_HELP_ITEM('Destination URI', ' Specifies the target location of the redirection.  If this redirected URI maps to a URI in another redirect context, it will be redirected again.  This URI can either be a relative URI on the same web site starting with &quot;/&quot;,  or an absolute URI pointing to different web site starting with &quot;http(s)://&quot;.   If the URI contains regular expression, the destination can reference  the matched variables such as $1, $2. ', '', '');
		$this->db['disableAdmin'] = new DATTR_HELP_ITEM('Disable Admin', ' Specifies whether to disable the web administration console of Microsoft &quot;FrontPage Server Extension&quot;. The web administration console is available at URL http://your.domain/_vti_bin/_vti_adm/fpadmcgi.exe.<br><br> Additional &quot;FrontPage Server Extension&quot; packages must be installed in order to make it work properly. Please read How to install Microsoft FrontPage Server Extension 2002 with LiteSpeed web server?  ', '[Security] Disable administration console when you no longer need to manage users or change configurations.', 'Select from radio box');
		$this->db['disableInitLogRotation'] = new DATTR_HELP_ITEM('Disable Initial Log Rotation', ' Specifies whether to disabled rotatation of server error log file at startup. Default is not to disable it.  ', '', 'Select from radio box');
		$this->db['disableSecHtaccess'] = new DATTR_HELP_ITEM('Disable .htaccess Override', ' Specifies whether to disable .htaccess override. This is a global setting, only available at server level.  Default is No.  ', '', 'Select from radio box');
		$this->db['docRoot'] = new DATTR_HELP_ITEM('Document Root', ' Specifies the document root for this virtual host. $VH_ROOT/html  is recommended. This directory is referred as $DOC_ROOT in contexts.  ', '', 'A path which can be absolute, or relative to $SERVER_ROOT, or relative to $VH_ROOT.');
		$this->db['domainName'] = new DATTR_HELP_ITEM('Domains', ' Specifies the mapping domain names. Domain name is case insensitive and  the leading &quot;www.&quot; will be removed. The wildcard characters &quot;*&quot; and &quot;?&quot; are allowed, &quot;?&quot; only matches one character, &quot;*&quot; matches any numbers of characters. For example, &quot;*.mydomain.com&quot; will match all subdomains of mydomain.com. Duplicated domain names are not allowed.  * is a catchall domain name, which will match any unmatched domain name.  ', '[Performance] If a listener is dedicated to one virtual host,  always use * for domain name to avoid unnecessary checking. Domain names with wildcard characters should be avoided whenever possible.', 'comma-separated list.');
		$this->db['domainNames'] = new DATTR_HELP_ITEM('Domain Names', ' Specifies the virtual servers that provide Front Page Server Extension service. When a web site is assigned to multiple domain names or service ports, FrontPage access is only available to the domain name and port combination specified in this list. <br><br> The virtual server name is comprised of domain name and port number, for a web site with domain name &quot;www.mydomain.com&quot; accessible via both HTTP and HTTPS connection, the name list should be like:<br><br> www.mydomain.com:80, www.mydomain.com:443 <br><br> <br><br> Additional &quot;FrontPage Server Extension&quot; packages must be installed in order to make it work properly. Please read How to install Microsoft FrontPage Server Extension 2002 with LiteSpeed web server?  ', '', 'Doamin.name:port[, ...]');
		$this->db['dynReqPerSec'] = new DATTR_HELP_ITEM('Dynamic Requests/Second', ' Specifies the maximum number of requests to dynamically generated content  coming from a single IP address can be processed in each second regardless of number of connections established.  When the limit is reached, all future requests to dynamic content  are tar-pitted until next second.  Request limit for static content is independent of this limit. Per client request limit can be set at server or virtual host level where virtual host level setting overrides server level setting. ', '[Security] Trusted IP or sub-network is not effected', 'Integer number');
		$this->db['editmime'] = new DATTR_HELP_ITEM('Edit MIME File', ' You can edit (add/modify/delete) the MIME entries. Same MIME type can have multiple suffixes. ', '', '');
		$this->db['enableCensorship'] = new DATTR_HELP_ITEM('Enable Request Filtering', ' Specifies whether to enable request content deep inspection. This feature is equvialent to Apache&#039;s mod_security, which can be used to detect and block requests with ill intention by matching known signatures.  ', '', 'Select from radio box');
		$this->db['enableChroot'] = new DATTR_HELP_ITEM('Enable chroot', ' [Enterprise Edition Only] Specifies whether to start the web server in chroot mode.  The new root directory is set by Chroot Path during installation. ', '', 'Select from radio box');
		$this->db['enableCoreDump'] = new DATTR_HELP_ITEM('Enable Core Dump', ' Specifies whether to enable core dump when server is started by &quot;root&quot; user.  For most modern Unix systems, processes that changes user id or group id is not allowed to  dump a core file for security reasons. However, it is much easier to identify root  cause of a problem with a core dump. This option only works on Linux with kernel &gt;2.4.  Solaris users should use coreadm command to control this feature. ', '[Security] Only enable it when you see no core file is created in  server log file and disable it immediately after producing the core file.  Please submit a bug report when core dump is created.', 'Select from radio box');
		$this->db['enableDynGzipCompress'] = new DATTR_HELP_ITEM('Enable Dynamic Compression', ' Controls GZIP compression for dynamically generated HTTP response.  Enable Compression must be set to true in order to enable dynamic GZIP compression. ', '[Performance] Compressing dynamic responses increases CPU and memory  utilization but saves network bandwidth. Text based responses such as  html, css, and javascript files benefit the most and on average can be compressed to 1/2 of original size.', 'Select from radio box');
		$this->db['enableExpires'] = new DATTR_HELP_ITEM('Enable Expires', ' Specifies whether to generate Expires header for static files. If enabled, Expires  header will be generated based on Expires Default and Expires By Type.  This can be set at server, virtual host and context level. Lower level settings will  override higher level ones, i.e. context settings will override the virtual host settings  and virtual host settings will override the server settings. ', '', 'Select from radio box');
		$this->db['enableFrontPage'] = new DATTR_HELP_ITEM('Enable', ' Specifies whether to enable Microsoft &quot;FrontPage Server Extension&quot;. When enabled, Microsoft FrontPage can be used to  publish web content. A web administration console is available at URL http://your.domain/_vti_bin/_vti_adm/fpadmcgi.exe.<br><br> Additional &quot;FrontPage Server Extension&quot; packages must be installed in order to make it work properly. Please read How to install Microsoft FrontPage Server Extension 2002 with LiteSpeed web server?  ', '', 'Select from radio box');
		$this->db['enableGzip'] = new DATTR_HELP_ITEM('Enable GZIP', ' Specifies whether to enable GZIP compression for this virtual host.  This setting is effective only when server level GZIP compression is enabled, i.e.  virtual host can only turn off compression enabled at server level.  Compression settings are configured at server level (Tuning-GZIP). ', '', 'Select from radio box');
		$this->db['enableGzipCompress'] = new DATTR_HELP_ITEM('Enable Compression', ' Controls GZIP compression for both static and dynamic HTTP responses.  ', '[Performance] Enable it to save network bandwidth. Text based responses such as  html, css, and javascript files benefit the most and on average can be compressed to 1/2 of original size.', 'Select from radio box');
		$this->db['enableHotlinkCtrl'] = new DATTR_HELP_ITEM('Enable Hotlink Protection', ' Specifies whether to activate hotlink protection. ', '', 'Select from radio box');
		$this->db['enableIpGeo'] = new DATTR_HELP_ITEM('Enable IP Geolocation', ' [Enterprise Edition Only] Specifies whether to enable IP to Geolocation lookup. It can be set at server, virtual host or context level.  ', '', 'Select from radio box');
		$this->db['enableLVE'] = new DATTR_HELP_ITEM('Enable LVE', ' Specifies whether to enable CloudLinux&#039;s Lightweight Virtual Environment (LVE)  when it exists. You can use LiteSpeed with LVE to achieve better resource management.  For more information, please check http://www.cloudlinux.com. ', '', 'Select from radio box');
		$this->db['enableRailsHosting'] = new DATTR_HELP_ITEM('Enable Shared Hosting', ' Specifies whether to enable rails shared hosting. Default is disabled.  ', '', 'Select from radio box');
		$this->db['enableRewrite'] = new DATTR_HELP_ITEM('Enable Rewrite', ' Specifies whether to enable LiteSpeed URL rewrite engine. This option can be customized at virtual host and context level, and is inherited along the directory tree until it is explicitly overridden.   ', '', 'Select from radio box');
		$this->db['enableScript'] = new DATTR_HELP_ITEM('Enable Script', ' Specifies whether scripting (non-static pages) is allowed in this virtual host.  If disabled, CGI, FastCGI, LSAPI, Servlet and other scripting language are not allowed in this virtual host.  Therefore if you want to use script handler, you need to enable it here as well. ', '', 'Select from radio box');
		$this->db['env'] = new DATTR_HELP_ITEM('Environment', ' Specifies some extra environment variables for the external application. ', '', 'key=value multiple variables can be separated by &quot;ENTER&quot;');
		$this->db['errCode'] = new DATTR_HELP_ITEM('Error Code', ' Specifies the HTTP status code for the error page.  Only selected HTTP status code can have customized error page.  ', '', 'Select from drop down list');
		$this->db['errPage'] = new DATTR_HELP_ITEM('Customized Error Pages', 'Whenever the server has a problem in processing a request,   the server will return an error code and an html page as the error message   to web client. Error codes are defined in the HTTP protocol (see RFC 2616).   LiteSpeed server has a built-in default error page for each error code.  A customized page can be configured for each error code. In LiteSpeed server,   error pages can be further customized to be unique for each virtual host.', '', '');
		$this->db['errPageAction'] = new DATTR_HELP_ITEM('Action', ' To change the error page setting click &quot;Edit&quot;.  To remove this customized error page, click &quot;Delete&quot;. ', '', '');
		$this->db['errURL'] = new DATTR_HELP_ITEM('URL', ' Specifies the URL of the customized error page.  Server will forward request to this URL when the corresponding HTTP status code has returned.  If this URL refers to a non-existing resource, the built-in error page will be used. URL can be a static file,  a dynamically generated page or a page on another web site (URL starting with &quot;http(s)://&quot;).  When referring to a page on another web site, the client will receive a redirect status  code instead of the original status code. ', '', 'URL');
		$this->db['etagNoInode'] = new DATTR_HELP_ITEM('No i-node in ETag', ' Specifies whether to use file i-node information in ETag generation. If you plan to serve the same file out of mirrored servers, you should enabled this configuration, otherwise, the ETag generated for the same file might be different from different server.  ', '', 'Select from radio box');
		$this->db['eventDispatcher'] = new DATTR_HELP_ITEM('I/O Event Dispatcher', ' Specifies which I/O event dispatcher to use. Different operating systems support different types of event dispatcher:    Linux kernel 2.4.x supports:      poll      Linux kernel 2.6.x supports:      pollepoll      FreeBSD supports:      pollkqueue      Solaris supports:      polldevpoll      Mac OS X 10.3 and above supports:      pollkqueue       poll is supported by all platforms, and is the default selection.    For high traffic web sites, altenative event dispatcher can be used to improve the    scalability of the web server.  ', '', 'Select from drop down list');
		$this->db['expiresByType'] = new DATTR_HELP_ITEM('Expires By Type', ' Specifies Expires settings for individual MIME types. ', '', 'Comma delimited list of &quot;MIME-type=A|Mseconds&quot;.  After base time(A|M) plus specified seconds, it will expire.  Base time &quot;A&quot; means the client&#039;s access time and &quot;M&quot; means the file&#039;s last modified time.  MIME-type can accept wildcard &quot;*&quot;, like image/*.');
		$this->db['expiresDefault'] = new DATTR_HELP_ITEM('Expires Default', ' Specifies default settings for Expires header generation. This setting is effective  when Enable Expires is set. It can be overridden by Expires By Type.  Do not set this default at server or virtual host level unless you have to,  since it will generate Expires header for all pages. Most of time this is set at context level for certain directories that do not change often. If there is no default setting, no Expires header will be generated for types not specified in Expires By Type. ', '', 'A|Mseconds<br><br>After base time(A|M) plus specified seconds, it will expire.  Base time &quot;A&quot; means the client&#039;s access time and &quot;M&quot; means the file&#039;s last modified time.');
		$this->db['expuri'] = new DATTR_HELP_ITEM('URI', ' Specifies the URI for this context. URI can be a plain URI (starting with &quot;/&quot;) or  a Perl compatible regular expression URI (starting with &quot;exp:&quot;).  If a plain URI ends  with a &quot;/&quot;, then this context will include all sub-URIs under this URI. If the context maps to a directory on the file system, a trailing &quot;/&quot; must be added. For examples, a plain URI like /examples/ with Root  set to /home/john/web_examples will map the request &quot;/examples/foo/bar.html&quot;  to file &quot;/home/john/web_examples/foo/bar.html&quot;. To simulate Apache&#039;s mod_userdir,  set URI to exp: ^/~([A-Za-z0-9]+)(.*),  set Root to /home/$1/public_html$2, a request URI /~john/foo/bar.html will  map to file /home/john/public_html/foo/bar.html. ', '', 'URI');
		$this->db['extAppAddress'] = new DATTR_HELP_ITEM('Address', ' A unique socket address used by the external application.  IPv4 socket and Unix Domain Socket (UDS) are supported.  IPv4 socket can be used for communication over the network,  but UDS can only be used when the external application residing on the same machine. ', '[Security] If the external application runs on the same machine,  UDS is preferred. If you have to use IPv4 socket,  set the IP part to localhost or 127.0.0.1,  thus the external application is inaccessible from other machines. <br><br> &amp;nbsp;&amp;nbsp;[Performance] Unix Domain Socket generally provides higher performance than an IPv4 socket.', 'IPv4Addr:port or UDS://path<br><br>Example: 127.0.0.1:5434, UDS://tmp/lshttpd/php.sock.');
		$this->db['extAppName'] = new DATTR_HELP_ITEM('Name', ' A unique name for an external application.  You will refer it by this name when you use it in other parts of the configuration. ', '', '');
		$this->db['extAppPath'] = new DATTR_HELP_ITEM('Command', ' Specifies the full command line including parameters to execute the external application. Required value if  Auto Start is enabled. A parameter should be quoted with a double or single quote if the parameter contains space or tab characters.  ', '', 'Full path to the executable with optional parameters.');
		$this->db['extAppPriority'] = new DATTR_HELP_ITEM('Priority', ' Specifies priority of the external application process. Value ranges from -20 to 20, lower number means higher priority. This  priority cannot be set higher (lower number) than server&#039;s own. Otherwise, server&#039;s priority will be used and this value is disregarded. ', '', 'int');
		$this->db['extAppType'] = new DATTR_HELP_ITEM('Type', ' Specifies the type of external application. Choose from  FastCGI: a FastCGI application with Responder role. FastCGI Authorizer: a FastCGI application with Authorizer role Servlet Engine: a Servlet engine with AJPv13 connector, such as tomcat. Web Server: a web server or application server that support HTTP protocol. LSAPI App: an application that communicate with web server in LSAPI protocol. Load Balancer: a virtual application that can balance load among worker applications. Piped Logger: an application that can process access log entries received on its STDIN stream.  ', '', 'Select from drop down list');
		$this->db['extAuthorizer'] = new DATTR_HELP_ITEM('Authorizer', ' Specifies an external application that can be used to generate authorized/unauthorized decision. Currently only FastCGI Authroizer is available. For more details about FastCGI AUTHORIZER role, please visit http://www.fastcgi.com. ', '', 'Select from drop down list');
		$this->db['extGroup'] = new DATTR_HELP_ITEM('suEXEC Group', ' Specifies group name that the external application will run as.     ', '', 'valid group name');
		$this->db['extMaxIdleTime'] = new DATTR_HELP_ITEM('Max Idle Time', ' Specifies the maximum idle time before an external application is stopped by the server. When set to -1, the external application will not be stopped by the server. Default value is -1. This feature allows resources used by idle applications to be freed. It is especially useful in mass hosting environment when you need to define many applications running in setuid mode for the sake of maximum security.  ', '', 'Select from radio box');
		$this->db['extUser'] = new DATTR_HELP_ITEM('suEXEC User', ' Specifies user name that the external application will run as. If not set, the external application will run as the user of the web server.    ', '', 'valid user name');
		$this->db['externalredirect'] = new DATTR_HELP_ITEM('External Redirect', ' Specifies whether this redirect is external.  For external redirection, Status Code may be specified and  Destination URI can start either with &quot;/&quot; or &quot;http(s)://&quot;.  For internal redirection, Destination URI must start with &quot;/&quot;. ', '', '');
		$this->db['extraHeaders'] = new DATTR_HELP_ITEM('Extra Headers', ' Specifies extra response headers to be added. Multiple headers can be added, one header per line. ', '', '&quot;[HeaderName]: [HeaderValue]&quot; in each line. <br><br> example:<br><br> Cache-control: no-cache, no-store My-header: Custom header value ');
		$this->db['fcgiContext'] = new DATTR_HELP_ITEM('FastCGI Context', 'FastCGI application cannot be used directly. It must be either configured as   a script handler or mapped to a URL through FastCGI context. A FastCGI context will   associate a URI with a FastCGI application.', '', '');
		$this->db['fcgiapp'] = new DATTR_HELP_ITEM('FastCGI App', ' Specifies the name of the FastCGI application.  It is predefined in External Application section, which can be at server level or at virtual host level. ', '', 'Select from drop down list');
		$this->db['followSymbolLink'] = new DATTR_HELP_ITEM('Follow Symbolic Link', ' Specifies the server level default setting of following symbolic links  when serving static files.  Choices are Yes, If Owner Match and No.  Yes will always follow a symbolic link;  If Owner Match will follow a symbolic link only if the owner of the link and of the target are same.  No will never follow a symbolic link.  This setting can be overridden by each individual virtual host. ', '[Performance &amp; security] For best security select No or If Owner Match.  For best performance, select Yes.', 'Select from drop down list');
		$this->db['forceGID'] = new DATTR_HELP_ITEM('Force GID', ' Specifies a group id to be used for all external applications started in suEXEC mode.  When set to non-zero value, all suEXEC external applications (CGI/FastCGI/LSAPI) will use this gid. This can be used to prevent an external application from accessing files owned by other users. For example, in a shared hosting environment, LiteSpeed runs as user www-data, group www-data, each docroot is owned by a user account, group is www-data and permission mode is 0750. In this example, if &#039;Force GID&#039; is set to &#039;nogroup&#039; or any group other than &#039;www-data&#039;, all suEXEC external applications will run on behalf of the user who owns the document and group &#039;nogroup&#039;. The external application process can only access files owned by that user while the server still can serve files under all user&#039;s docroot directory.     ', '[Security] Set it high enough to exclude all groups used by system user.', 'Integer number');
		$this->db['forceType'] = new DATTR_HELP_ITEM('Force MIME Type', ' When specified, all files under this context will be served as 	   static files with the MIME type specified regardless file suffix.  	   When set to NONE, inherited force type setting will be 	   disabled. ', '', 'MIME-type|NONE');
		$this->db['generalContext'] = new DATTR_HELP_ITEM('General Context', 'General context is used to bring in files outside of the document root   like Apache&#039;s Alias or AliasMatch directive. It can also be used to protect   a particular directory, either inside or outside of the document root, using   authorization realms. General context can also be used to block or restrict access for a special directory  within the document root.', '', '');
		$this->db['geoipDBCache'] = new DATTR_HELP_ITEM('DB Cache Type', ' [Enterprise Edition Only] Specifies what kind of cache mode should be used. Cache modes are: Standard, MemoryCache, CheckCache and IndexCache. MemoryCache is recommended and it is the default.   ', '', 'Select from drop down list');
		$this->db['geoipDBFile'] = new DATTR_HELP_ITEM('DB File Path', ' [Enterprise Edition Only] Specifies the path to MaxMind GeoIP database. ', '', 'file path');
		$this->db['geolocationDB'] = new DATTR_HELP_ITEM('IP to Geolocation DB', '[Enterprise Edition Only] Multiple MaxMind geolocation databases can be specified here. MaxMind  has the following type of DB: Country, Region, City, Organization, ISP and  Netspeed.   For database type of Country, Region and City, the later type of DB contains   more information than that of a DB with former type, only one of those type of  DB should be specified, if multiple DBs with those types are configured, the  last one will be effective.', '', '');
		$this->db['gracePeriod'] = new DATTR_HELP_ITEM('Grace Period (sec)', ' Specifies for how long new connections can be accepted after number of connections  established from one IP is over . Within this period, new connections  will be accepted if the total connections still below Connection Hard Limit. After this  period, if the number of connections still higher than , then that  IP will be blocked for Banned Period (sec).  ', '[Performance &amp; Security] Set to a proper number big enough for downloading  a complete page but low enough to prevent deliberate attacks.', 'Integer number');
		$this->db['gracefulRestartTimeout'] = new DATTR_HELP_ITEM('Graceful Restart Timeout', ' During graceful restart, the new server instance is up, while the old instance will continue  to handle existing requests. This timeout defines how long the previous instance shall wait before exit.  Default value is 300 seconds, -1 means wait forever, 0 means no wait and abort immediately.  ', '', 'int');
		$this->db['groupDBCacheTimeout'] = new DATTR_HELP_ITEM('Group DB Cache Timeout', ' Specifies how often the backend group database will be checked for changes.  For more detail please refer to User DB Cache Timeout. ', '', 'Integer number');
		$this->db['groupDBMaxCacheSize'] = new DATTR_HELP_ITEM('Group DB Max Cache Size', ' Specifies the maximum cache size of the group database. For more detail please refer to  User DB Max Cache Size. ', '', 'Integer number');
		$this->db['groupDB_attrGroupMember'] = new DATTR_HELP_ITEM('Group Member Attribute', ' Specifies the name of the Member attribute for a group record stored in LDAP server. Default value is memberUid.  ', '', 'string');
		$this->db['gzipAutoUpdateStatic'] = new DATTR_HELP_ITEM('Auto Update Static File', ' Specifies whether to let the web server to create/update GZIP  compressed edition of compressible static files.  If set to Yes, when a file with MIME type listed in Compressible Types is requested, the web server will create or update the corresponding compressed file depending on timestamp. The compressed file is created under the Static GZIP Cache Directory, the file name is based on the MD5 hash of the path of the original file. ', '', 'Select from radio box');
		$this->db['gzipCacheDir'] = new DATTR_HELP_ITEM('Static GZIP Cache Directory', ' Specifies the path of the directory used to store compressed file for static content, default is Swapping Directory. ', '', 'Directory Path');
		$this->db['gzipCompressLevel'] = new DATTR_HELP_ITEM('Compression Level (Dynamic Content)', ' Specifies the level of compression for dynamic contents, ranges  from 1 (lowest) to 9 (highest), default is 2. ', '[Performance] Higher compression level will use more memory and CPU cycles.  You can set it to a higher level if your machine has additional power. There is not much difference between 6 and 9 except 9 uses much more CPU cycles.', 'Number between 1 and 9.');
		$this->db['gzipMaxFileSize'] = new DATTR_HELP_ITEM('Max Static File Size', ' Specifies the maximum size of a static file for which the web server will create a compressed file automatically.  ', '[Performance] It is not recommended to have web server create/update compressed file for large files as the whole server service would become blocked during that period meaning no further requests can be processed before the current compression is completed.', 'Number in bytes not less than 1K');
		$this->db['gzipMinFileSize'] = new DATTR_HELP_ITEM('Min Static File Size', ' Specifies the minimum size of a static file for which the web server will create a corresponding compressed file.  ', 'It is not necessary to compress very small files as the bandwidth saving is negligible.', 'Number in bytes not less than 200');
		$this->db['gzipStaticCompressLevel'] = new DATTR_HELP_ITEM('Compression Level (Static Content)', ' Specifies the level of compression for static contents, ranges  from 1 (lowest) to 9 (highest), default is 6. ', '', 'Number between 1 and 9.');
		$this->db['hardLimit'] = new DATTR_HELP_ITEM('Connection Hard Limit', ' Specifies the maximum allowed concurrent connections from a single IP address.  This limit is always enforced and a client will never be able to exceed this limit.   HTTP/1.0 clients usually try to setup as many connections as it needs to download embedded  content at the same time. This limit should be set higher enough for HTTP/1.0 client and  use Connection Soft Limit to set the desired connection limit.  <br><br> The recommended limit is between 20 and 50 depending on the content of your web page and traffic load.  ', '[Security] A lower number will enable serving more distinct clients. <br><br> &amp;nbsp;&amp;nbsp;[Security] Trusted IP or sub-network is not effected. <br><br> &amp;nbsp;&amp;nbsp;[Performance] Set to a high value when you are performing benchmark tests with large number of concurrent client machines.', 'Integer number');
		$this->db['htaccess'] = new DATTR_HELP_ITEM('HT Access', 'The following directives are supported in a directory level  access control file.      Authentication            AuthType      AuthName      AuthUserFile      AuthGroupFile      Require              Access Control            Allow from      Deny from      Order              File Info            AddDefaultCharset      AddType      DefaultType      ExpiresActive      ExpiresDefault      ExpiresByType      ForceType      Redirect      RedirectTemp      RedirectPermanent      RewriteEngine      RewriteOptions      RewriteBase      RewriteCond      RewriteRule      Satisfy              Other        	&lt;Limit&gt;  	&lt;LimitExcept&gt;      DirectoryIndex      Options            ', '', '');
		$this->db['inBandwidth'] = new DATTR_HELP_ITEM('Inbound Bandwidth', ' Specifies the maximum allowed incoming throughput from a single IP address regardless of number of connections established. The real bandwidth could be slightly higher than this setting for efficiency.  Bandwidth is allocated in 1KB units. Set to 0 to disable throttling. Per client bandwidth limit (bytes/sec) can be set at server or virtual host level where virtual host level setting overrides server level setting. ', '[Security] Trusted IP or sub-network is not effected.', 'Integer number');
		$this->db['inMemBufSize'] = new DATTR_HELP_ITEM('Max I/O Buffer Size', ' Specifies the maximum buffer size that is used to store request body and dynamically generated response. When this limit is reached, server will start to create temporary swapping files under Swapping Directory. ', '[Performance] Set it large enough to accommodate all concurrent requests/replies to avoid memory to disk swapping. If there are frequent i/o activity to  the swap directoy, default to /tmp/lshttpd/swap/, this value is too low and LiteSpeed is swapping to disk.', 'Integer number');
		$this->db['indexFiles'] = new DATTR_HELP_ITEM('Index Files', ' Specifies names of index files that will be searched sequentially when a URL is mapped to a directory.  You can customize it at server, virtual host and context level. ', '[Performance] Only set index files that you need.', 'comma delimited list of name of index files');
		$this->db['indexUseServer'] = new DATTR_HELP_ITEM('Use Server Index Files', ' Specifies whether to use server&#039;s index file setting.  If set to Yes, only server&#039;s setting will be used.  If set to No, server&#039;s setting will not be used.  If set to Addition, additional index files can be added to server&#039;s  index file list for this virtual host. If you want to disable index files for  this virtual host, you can set value to No and leave the index files field empty. ', '', 'Select from drop down list');
		$this->db['initTimeout'] = new DATTR_HELP_ITEM('Initial Request Timeout', ' Specifies the maximum time the web server waits for the external  application to respond to the first request over a new established connection.  If the web server does not receive any data from the external application within this timeout limit, it will mark this connection as bad. This helps to identify communication problem with external application as quickly as possible. If some requests take longer time to  process, increase this limit to avoid &quot;503&quot; error messages. ', '', 'Integer number');
		$this->db['instances'] = new DATTR_HELP_ITEM('Instances', ' Specifies the maximum instances of the external application the server will create. It is required if Auto Start is enabled. Most FastCGI/LSAPI applications can only process one request per process instance and for those type of applications, instances should be set to match the value of Max Connections. Some FastCGI/LSAPI applications can spawn multiple child processes to handle multiple requests concurrently and for these type of applications, instances should be set to &#039;1&#039; and let the application spawn  Max Connections number of children processes. ', '', 'Integer number');
		$this->db['javaWebAppContext'] = new DATTR_HELP_ITEM('Java Web App Context', 'Most Servlet engine has its own built-in HTTP server but they cannot efficiently serve static   content or as fast as LiteSpeed server can. In order to improve the overall performance,   LiteSpeed server can be configured as a gateway server, which serves static content   and forwards dyanmic java page requests to the Servlet engine. <br><br>  Without Java web app context, multiple contexts have to be created, including a general   context that matches the root directory of the web application, Servlet contexts for each   respective Servlet is defined in the web application&#039;s configuration file - WEB-INF/web.xml.   It is awkward and troublesome. Java web app context is introduced to eliminate this hassle by   importing a Java web application with only one context configuration. With java web app context,   all required contexts are created automatically based on web application&#039;s configuration file. <br><br>    There are a couple points you need to remember:     If the web application is packed into a war file, the war file must be expanded,   the server cannot access files in compressed archive.  A Script Handler for .jsp files should be defined as well.  For same resources, the same URL should be used no matter whether it is accessed   through LiteSpeed server or through the Servlet engine&#039;s built-in HTTP server.<br><br>   For example, the &quot;examples&quot; web application that comes with Tomcat should be imported.    Tomcat 4.1 is installed under /opt/tomcat, files of &quot;examples&quot; web application is     located at /opt/tomcat/webapps/examples/, through Tomcat&#039;s built-in HTTP server     &quot;examples&quot; web application is accessed with URI like /examples/***.     In order to use the same URI to access it, the context should be configured with:     URI = /examples/, Root = /opt/tomcat/webapps/examples/.    ', '', '');
		$this->db['javaWebApp_location'] = new DATTR_HELP_ITEM('Location', ' Specifies the directory that contains the files for this web application.  This is the directory containing the &quot;WEB-INF/web.xml&quot;. ', '', 'path');
		$this->db['keepAliveTimeout'] = new DATTR_HELP_ITEM('Keep-Alive Timeout', ' Specifies the maximum idle time between requests from a Keep-Alive connection.  If no new request is received during this period of time, the connection will be closed. ', '[Security &amp; Performance] We recommend you to set the value just long enough to handle  all requests for a single page view. It is unnecessary to keep connection alive for an extended period of time. A smaller value can reduce idle connections, increase capacity to service more users and guard against DoS attacks. 2-5 seconds is a  reasonable range for most applications. LiteSpeed is highly efficient in a non-keep-alive environment.', 'Integer number');
		$this->db['keyFile'] = new DATTR_HELP_ITEM('Private Key File', ' Specifies the file name of the SSL private key file. The key file should not be encrypted. ', '[Security] The private key file should be placed in a secured directory that  allows only readable access by whom the server running as.', 'File name which can be an absolute path or relative to $SERVER_ROOT.');
		$this->db['listenerBinding'] = new DATTR_HELP_ITEM('Binding', ' [Enterprise Edition Only] Specifies which lshttpd child process the listener is assigned to. Enterprise Edition spawns multiple children processes to take advantage of multiple CPUs in a SMP system, different child process can be used to handle requests to different listener by manually associating a listener with a process. By default, a listener is assigned to all children processes. ', '', 'Select from checkbox');
		$this->db['listenerIP'] = new DATTR_HELP_ITEM('IP Address', ' Specifies the IP of the listener. All available IP address is listed,  IPv6 address is enclosed in &quot;[]&quot;. To listen on all IPv4 IP address, ANY should be selected; to listen on all IPv4 and IPv6 IP address, [ANY] should be selected. In order to serve both IPv4 and IPv6 clients, an IPv4-mapped IPv6 address should be used instead of a plain IPv4 address, which looks like [::FFFF:x.x.x.x]. ', '[Security] If your machine has multiple IPs which are on different sub networks,  you can select a specific IP to only allow traffic from corresponding sub network.', 'Select from drop down list');
		$this->db['listenerName'] = new DATTR_HELP_ITEM('Listener Name', ' A unique name for this listener. ', '', '');
		$this->db['listenerPort'] = new DATTR_HELP_ITEM('Port', ' Specifies the TCP port of the listener. Only super user (root) can use port  lower than 1024. Port 80 is the default HTTP port; port 443 is the default HTTPS port.  ', '', 'Integer number');
		$this->db['listenerSecure'] = new DATTR_HELP_ITEM('Secure', ' Specifies whether this is a secure (SSL) listener.  For secure listeners, additional SSL settings need to be set properly. ', '', 'Select from radio box');
		$this->db['loadApacheConf'] = new DATTR_HELP_ITEM('Load Apache Configuration', ' Specifies whether LiteSpeed will read and use a Apache configuration file to configure the web server. Native configuration will have higher priority when  there is conflict between LiteSpeed internal and Apache based configuration. When conflict arrise,  conflicted Apache configuration item(s) will be ignored.  ', '', 'Select from radio box');
		$this->db['location'] = new DATTR_HELP_ITEM('Root', ' Specifies the corresponding location of this context in the file system.  It can be an absolute path or relative path to $SERVER_ROOT, $VH_ROOT and $DOC_ROOT.  $DOC_ROOT is the default relative path, and can be omitted.<br><br>  If the URI is a regular expression, then matched sub-string  can be used to form the &#039;Root&#039; string. Matched sub-string can be  referenced with &#039;$1&#039;-&#039;$9&#039;, &#039;$0&#039; and &#039;&amp;&#039; can be used to reference the  whole matched string. Additionally, query string can be set by  appending a &#039;?&#039; followed by the query string. Be careful, &#039;&amp;&#039; should be escaped as &#039;\&amp;&#039; in the query string. ', '', 'path');
		$this->db['logUseServer'] = new DATTR_HELP_ITEM('Use Server Log', ' Specifies whether to put log messages from this virtual host into server  log file instead of creating its own log file. ', '', 'Select from radio box');
		$this->db['log_debugLevel'] = new DATTR_HELP_ITEM('Debug Level', ' Specifies the level of debugging log.  If the log level is DEBUG, server will use this to control debugging level. Debug logging is disabled when &#039;Debug Level&#039; is set to NONE even if Log Level is set to DEBUG.  Toggle Debug Logging can be used to control debug level on a live server without restarting.  ', '[Performance] Important! Always set it to NONE if you do not need detailed debug logging. Active debug logging will severely degrade service performance and potentially saturate disk space in a very short timeframe. Debug logging includes detailed information for each request and response.', 'Select from drop down list');
		$this->db['log_enableStderrLog'] = new DATTR_HELP_ITEM('Enable stderr Log', ' Specifies whether to write to log when receiving stderr output from any process started by the server.  If enabled, stderr messages will be logged in the same directory as the server log with  the fixed name &quot;stderr.log&quot;. If disabled, all stderr output will be discarded. ', 'Turn it on if you need to debug configured external applications: i.e. php, ruby, java, python, perl.', 'Select from radio box');
		$this->db['log_fileName'] = new DATTR_HELP_ITEM('File Name', ' Specifies the path of log file.  ', '[Performance] Place log file on a separate disk.', 'File name which can be an absolute path or relative to $SERVER_ROOT.');
		$this->db['log_logLevel'] = new DATTR_HELP_ITEM('Log Level', ' Specifies the level of logging. Available levels are ERROR,  WARNING, NOTICE, INFO and DEBUG from high to low. Only messages with higher level than current setting will be logged.   ', '[Performance] Unless Debug Level is set to a level other than NONE, using DEBUG log level does not have any performance impact. DEBUG log level is recommended.', 'Select from drop down list');
		$this->db['log_rollingSize'] = new DATTR_HELP_ITEM('Rolling Size', ' Specifies when the current log file needs to be rolled over, also known as log rotation.  When the file size is over the rollover limit, the active log file will be renamed  to log_name.mm_dd_yyyy(.sequence) in the same directory and a new active log file will be created.  The actual size of the rotated log file could be a little bigger. Set to 0 to disable log rotation. ', 'Append &quot;K&quot;, &quot;M&quot;, &quot;G&quot; to the number for kilo-, mega- and giga- bytes', 'Integer number');
		$this->db['mappedListeners'] = new DATTR_HELP_ITEM('Mapped Listeners', ' Specifies the names of all listeners that this template maps to. An implicit listener-to-virtual host mapping will be added for all member virtual hosts based on their domain name and aliases.  ', '', 'comma-separated list');
		$this->db['matchedHosts'] = new DATTR_HELP_ITEM('REGEX Matched Domains', ' Specifies web sites that can link to protected content in regular expression. The regular expression will match the domain name only and not the full URL.  ', '', 'Regular expression');
		$this->db['maxCGIInstances'] = new DATTR_HELP_ITEM('Max CGI Instances', ' Specifies the maximum concurrent CGI processes the server can start.  For each request to a CGI script, the server needs to start a standalone CGI process.  On a Unix system the number of concurrent processes is limited. Excessive  concurrent processes will degrade the performance of the whole system and will be target of a DoS attack.  LiteSpeed server pipelines requests to CGI scripts  and limits concurrent CGI processes to ensure the optimal performance and reliability.  The hard limit is 2000.  ', '[Security &amp; Performance] Higher limit does not necessarily translate to faster performance.  In most cases lower limit gives better performance and security. Higher limit will only help  when I/O latency is excessive during CGI processing.', 'Integer number');
		$this->db['maxCacheObjSize'] = new DATTR_HELP_ITEM('Max Object Size', ' Specify the maximum size of an object can be stored in the cache. directory. Default value is 128KB. ', '[Performance] It is not recommended to store large objects with low hit rate into the cache. It may result in high I/O wait and reduce overall server performance.', 'Integer number');
		$this->db['maxCachedFileSize'] = new DATTR_HELP_ITEM('Max Cached Small File Size', ' Specifies the largest static file that will be cached in a pre-allocated memory buffer. Static files can be served in four different ways: memory buffer cache, memory-mapped cache, plain read/write and sendfile(). Files whose size is smaller than the Max Cached Small File Size are served from memory buffer cache. Files whose size is larger than the   Max Cached Small File Size but smaller than the Max MMAP File Size will be served from memory-mapped cache. Files whose size is larger than the Max MMAP File Size will be served via plain read/write or sendfile(). It is optimal to serve static files smaller than 4K from the memory buffer cache.  ', '', 'Integer number');
		$this->db['maxConnections'] = new DATTR_HELP_ITEM('Max Connections', ' Specifies the maximum concurrent connections that the server can accept.  It includes both plain TCP connections and SSL connections. It should not exceed  the hard limit set by the server: 150 for Standard Edition, 500  for VPS license. Once this limit is reached, the server will close  Keep-Alive connections when they complete active requests. ', 'When server is started by root user, the server will try to adjust the per process file descriptor limits automatically, however, if it failed, you may need to increase it manually.', 'Integer number');
		$this->db['maxConns'] = new DATTR_HELP_ITEM('Max Connections', ' Specifies the maximum concurrent connections that can be established  between the web server and an external application. This setting controls how  many requests can be processed concurrently by an external application.  However, the real limit also depends on the external application itself.  Set this value higher will not help if the external application is not fast enough or cannot scale to large number of concurrent requests. ', '[Performance] Setting a high value does not directly translate to higher performance.  Set the limit to a value that will not overload the the external  application will provide the best performance/throughput.', 'Integer number');
		$this->db['maxDynRespHeaderSize'] = new DATTR_HELP_ITEM('Max Dynamic Response Header Size', ' Specifies the maximum header size of a dynamically generated response. Hard limit is 8KB ', '[Reliability &amp; Performance] Set it low and reasonable to help recognize bad  responses that are dynamically generated by external applications.', 'Integer number');
		$this->db['maxDynRespSize'] = new DATTR_HELP_ITEM('Max Dynamic Response Body Size', ' Specifies the maximum body size of a dynamically generated response. Hard limit is 2047MB. ', '[Reliability &amp; Performance] set the limit low and reasonable to help  identify bad responses. For example, it is not uncommon to malformed scripts continaing infinite loop which leads to infinite sized responses.', 'Integer number');
		$this->db['maxKeepAliveReq'] = new DATTR_HELP_ITEM('Max Keep-Alive Requests', ' Specifies the maximum number of requests that can be served through a Keep-Alive (Persistent)  session. Connection will be closed once this limit is reached. You can set this limit for each virtual host as well.  ', '[Performance] Set it to a resonable high value. Value of 1 or 0 will disable Keep-Alive.', 'Integer number');
		$this->db['maxMMapFileSize'] = new DATTR_HELP_ITEM('Max MMAP File Size', '  Specifies the largest static file that will be memory mapped (MMAP).   Static files can be served in four different ways: memory buffer cache, memory-mapped cache, plain read/write and sendfile(). Files whose size is smaller than the Max Cached Small File Size are served from memory buffer cache. Files whose size is larger than the   Max Cached Small File Size but smaller than the Max MMAP File Size will be served from memory-mapped cache. Files whose size is larger than the Max MMAP File Size will be served via plain read/write or sendfile().  Since the server has a 32bit address space, up to 2GB,  it is not recommended to mmap very large files.  ', '', 'Integer number');
		$this->db['maxReqBodySize'] = new DATTR_HELP_ITEM('Max Request Body Size', ' Specifies the maximum size of a HTTP request body. 1GB is the hard limit. ', '[Security] Set the limit just a little higher than what is really needed to  help identify DoS attack. Your swapping space must have enough free space.', 'Integer number');
		$this->db['maxReqHeaderSize'] = new DATTR_HELP_ITEM('Max Request Header Size', ' Specifies the maximum size of a HTTP request header including request URL.  Hard limit is 16380 bytes.  ', '[Security &amp; Performance] Set it low and reasonable to reduce memory usage and  help identify bogus requsts and DoS attacks.<br><br> 4-8K is big enough for most web sites.', 'Integer number');
		$this->db['maxReqURLLen'] = new DATTR_HELP_ITEM('Max Request URL Length', ' Specifies the maximum size of a request URL. URL is the full text address used to access a server resource including query string. 8192 bytes is the hard limit. ', '[Security &amp; Performance] Set it low and reasonable to reduce memory usage  and help identify bogus requests and DoS attacks. <br><br>2-3K is big enough for most web  sites unless HTTP GET method is used with large query string instead of POST.', 'Integer number');
		$this->db['maxSSLConnections'] = new DATTR_HELP_ITEM('Max SSL Connections', ' Specifies the maximum concurrent SSL connections the server will accept.  Since total concurrent SSL and non-SSL connections will not exceed the limit specified by  Max Connections, the actual number of concurrent SSL connections allowed  could be lower than this limit. ', '', 'Integer number');
		$this->db['memHardLimit'] = new DATTR_HELP_ITEM('Memory Hard Limit', ' same as Memory Soft Limit, &quot;Soft Limit&quot; can be raised up to the &quot;Hard Limit&quot; from within a user process. It can be set at server level or at  individual external application level. Server level limit will be used if it is not set at individual application level.     Operating system&#039;s default will be used if the value is set to 0 or absent at both levels.  ', '', 'Integer number');
		$this->db['memSoftLimit'] = new DATTR_HELP_ITEM('Memory Soft Limit', ' Specifies memory consumption limit in bytes for an external application process or an external application started by server.   The main purpose of this limit is to prevent excessive memory usage because of software bug or intention attacks, not to impose a limit on normal usage, make sure to leave enough head room, otherwise your application will fail and 503 error may be returned. It can be set at server level or at  individual external application level. Server level limit will be used if it is not set at individual application level.     Operating system&#039;s default will be used if the value is set to 0 or absent at both levels.  ', '[Attention] Do not over tune this limit, it may result in 503 errors if your application need more memory.', 'Integer number');
		$this->db['mime'] = new DATTR_HELP_ITEM('MIME File', ' Specifies the file that contains the MIME settings for this server.  It is always relative to the real root when an absolute path is given in chroot mode. ', 'Click the file name to edit the MIME settings', 'File name which can be an absolute path or relative to $SERVER_ROOT.');
		$this->db['minGID'] = new DATTR_HELP_ITEM('Minimum GID', ' Specifies the minimum group id of external applications. If LiteSpeed  server is started by &quot;root&quot; user, it can run external applications in &quot;suEXEC&quot; mode found in Apache (to change to another user/group id other than the web server&#039;s). Execution of an external with gid lower than the value specified here will be denied.  ', '[Security] Set it high enough to exclude all groups used by system user.', 'Integer number');
		$this->db['minUID'] = new DATTR_HELP_ITEM('Minimum UID', ' Specifies the minimum user id of external applications. If LiteSpeed web server is started by &quot;root&quot; user, it can run external applications in &quot;suEXEC&quot; mode found in Apache (to change to another user/group id other than the  server&#039;s). Execution of a external script with uid lower than the value specified here will be denied.  ', '[Security] Set it high enough to exclude all system, priviledged, users.', 'Integer number');
		$this->db['noCacheUrl'] = new DATTR_HELP_ITEM('No Cache URL', ' A list of URL segments that will not be cached. Any URL that contains those listed segments will not be cached.  Regular string match will be used and regular expression is not supported. You can add comments by starting a line with &quot;#&quot;,  the whole line will be treated as comment and ignored. This feature is only available at server level ', '', '');
		$this->db['onlySelf'] = new DATTR_HELP_ITEM('Only Self Reference', ' Specifies whether to only allow reference from current web site itself. When set to Yes, Allowed Domains has no effect and no other web site can link to protected files. It is convenient if multiple domain names are parked on current web site.  ', '', 'Select from radio box');
		$this->db['outBandwidth'] = new DATTR_HELP_ITEM('Outbound Bandwidth', ' Specifies the maximum allowed outgoing throughput to a single IP address regardless of number of connections established. The real bandwidth could be slightly higher than this setting for efficiency.  Bandwidth is allocated in 4KB units. Set to 0 to disable throttling. Per client bandwidth limit (bytes/sec) can be set at server or virtual host level where virtual host level setting overrides server level setting. ', '[Performance] Set the bandwidth in 8KB units for better performance. <br><br> &amp;nbsp;&amp;nbsp;[Security] Trusted IP or sub-network is not effected.', 'Integer number');
		$this->db['path'] = new DATTR_HELP_ITEM('Path', ' Specifies the location of CGI scripts.  Path can be a directory that contains a group of CGI scripts, like $VH_ROOT/myapp/cgi-bin/.  In this case, context URI must end with &quot;/&quot; like /app1/cgi/.  Path can also specify only one CGI script, like $VH_ROOT/myapp/myscript.pl  with corresponding URI /myapp/myscript.pl. ', '', 'path');
		$this->db['pcKeepAliveTimeout'] = new DATTR_HELP_ITEM('Keep Alive Timeout', ' Specifies the maximum time to keep an idle persistent connection open. When set to -1, the connection never timeout. When set to &gt;=0, the connection will be closed after the timeout has been reached. ', '', 'int');
		$this->db['perClientConnLimit'] = new DATTR_HELP_ITEM('Per Client Throttling Control', 'These are connection control settings based on client IP.   These settings help to mitigate DoS (Denied of Service) and DDoS (Distributed Denied of Service) attacks.', '', '');
		$this->db['persistConn'] = new DATTR_HELP_ITEM('Persistent Connection', ' Specifies whether to keep the connection open after a request has been processed. Persistent connection can increase performance but some FastCGI external applications does not support persistent connection fully. In order to run Ruby On Rails via a FastCGI interface, persistent connection needs to be turned off. Default is on. Currently, this option is only effective for a FastCGI external application. ', '', 'Select from radio box');
		$this->db['phpSuExec'] = new DATTR_HELP_ITEM('PHP suEXEC', ' Specifies whether to run PHP script in suEXEC mode when &#039;user&#039; and &#039;group&#039; are specified for a virtual host. When set to yes, PHP script will be executed under the user specified, as well as the group unless Force GID is set. When set to &quot;User&#039;s Home Directory Only&quot;, scripts outside a user&#039;s  home directory will run as the global user/group that the web server run as. When used together with DirectAdmin, this value is recommended. Default is no.  ', '', 'Select from radio box');
		$this->db['phpSuExecMaxConn'] = new DATTR_HELP_ITEM('PHP suEXEC Max Conn', ' Specifies the maximum concurrent PHP requestes can be processed when run PHP script in suEXEC mode. This is the maximum number of PHP  processes each user can get. Default value is 5.  ', '', 'Integer number');
		$this->db['procHardLimit'] = new DATTR_HELP_ITEM('Process Hard Limit', ' Same as Process Soft Limit, &quot;Soft Limit&quot; can be raised up to the &quot;Hard Limit&quot; from within a user process. It can be set at server level or at  individual external application level. Server level limit will be used if it is not set at individual application level.    Operating system&#039;s default value will be used if the value is set to 0 or absent at both levels.  ', '', 'Integer number');
		$this->db['procSoftLimit'] = new DATTR_HELP_ITEM('Process Soft Limit', ' Limits the total number of processes can be created on behalf of a user.  This effectively limits the number of processes can be launched by  web server on behalf of a user. All existing processes will be counted against this limit, not just new process to be started.  If the limit is set to 10, and there are more than 10 processes running under one user, then no new process can be started by web server for that user (suEXEC). <br><br> The main purpose of this limit is to prevent &quot;fork bomb&quot; attacks or excessive usage, not to impose a limit on normal usage, make sure to leave enough head room. It can be set at server level or at  individual external application level. Server level limit will be used if it is not set at individual application level. Operating system&#039;s default value will be used if this value is 0 or absent at both levels. ', '', 'Integer number');
		$this->db['proxyContext'] = new DATTR_HELP_ITEM('Proxy Context', 'Proxy context enables this virtual host as a transparent reverse  proxy server. Proxy server could be running in front of any web   servers or application servers that supports the HTTP protocol. External  web server has to be predefined in External Application.', '', '');
		$this->db['proxyWebServer'] = new DATTR_HELP_ITEM('Web Server', ' Specifies the name of the external web server. It is predefined in External Application section which can be at server or virtual host level. ', '', 'Select from drop down list');
		$this->db['railsAppLimit'] = new DATTR_HELP_ITEM('Max Apps Per Account', ' Specifies the maximum number of rails applications can be created per account. Default is 1. Each Rails application will take large amount of system resource, it is not recommended to set a high limit, otherwise, it will affect the performance of whole server if one user abuse it.  ', '', 'Integer number');
		$this->db['railsContext'] = new DATTR_HELP_ITEM('Rails Context', 'Rails context provides an easy way to configure a Ruby On Rails  application. To add a Rails application, only mounting URL and  application&#039;s root directory is required. No need to go through all  the trouble to define an external application, add 404 handler,   rewrite rule, etc.', '', '');
		$this->db['railsDefault'] = new DATTR_HELP_ITEM('Ruby Rails Settings', 'Default configuration for Ruby on Rails applications configured through  Rails Contexts.', '', '');
		$this->db['railsEnv'] = new DATTR_HELP_ITEM('Rails Environment', ' Specifies which mode Rails will be running as, &#039;Development&#039; or &#039;Production&#039;. Default is &#039;Production&#039;. ', '', 'Select from drop down list');
		$this->db['railsHosting'] = new DATTR_HELP_ITEM('Rails Shared Hosting', 'Rails shared hosting is supported by LiteSpeed Web Server since  release 3.2. By using our high performance, highly scalable Ruby LSAPI  module, LiteSpeed rails hosting solution can deliver the best  performance with minimum server resource requirement. In addition,  LiteSpeed Rails hosting solution is an independent solution, which  makes it compatible with all existing web hosting control panels. <br><br>    The user manageable Rails configuration file is located at user&#039;s home  directory or virtual host root directory, named as &quot;.ls_rails_config&quot;.   Syntax is like    #RailsApp       RailsApp testApp &quot;/lsws/testrails&quot; &quot;development&quot; 4 1    #RailsAppMap     RailsAppMap testApp &quot;testrails.com&quot; &quot;/&quot;  RailsAppMap testApp &quot;test.testrails.com&quot; &quot;/&quot;      &quot;App Path&quot; is relative to the user&#039;s home directory or the virtual  host root directory.     Whenever this file is touched, Rails applications will be restarted.', '', '');
		$this->db['rcvBufSize'] = new DATTR_HELP_ITEM('Receive Buffer Size', ' The receiving buffer size of each TCP socket. Set to 0 to use the default  buffer size. 65535 is the hard limit. ', '[Performance] A large receive buffer will increase performance when processing  incoming requests with large payload, i.e. file uploads.', 'Integer number');
		$this->db['realm'] = new DATTR_HELP_ITEM('Realm', ' Specifies the authorization realm for this context. When specified,  a valid user name and password must be provided in order to access this context.  Authorization Realms were set up in Virtual Host Security section.  Here only use its Realm Name. ', '', 'Select from drop down list');
		$this->db['realmName'] = new DATTR_HELP_ITEM('Realm Name', ' Specifies a unique name for the authorization realm. ', '', '');
		$this->db['realmType'] = new DATTR_HELP_ITEM('DB Type', ' Specifies how user/group data is stored for a authorization realm. Currently, user/group data can be stored in flat files or on a LDAP server.  ', '', 'Select from drop down list');
		$this->db['realms'] = new DATTR_HELP_ITEM('Authorization Realms', 'Lists all authorization realms for this virtual host.   Authorization realms is used to block unauthorized users from accessing protected web pages.   A realm is a user directory containing user names and passwords with optional   group classification. Authorization is performed at context level.   Since different contexts can share the same realm(user database), so realms are defined separately.   You can refer to a realm by its name in context configuration.', '', '');
		$this->db['redirectContext'] = new DATTR_HELP_ITEM('Redirect Context', 'A Redirect Context can be used to forward one URI or a group of URIs to another location.   The destination URI can be either on the same web site (internal  redirect) or an absolute URI pointing to another web site (external redirect).', '', '');
		$this->db['redirectUri'] = new DATTR_HELP_ITEM('Redirect URL', ' Specifies a URL that a user will be redirected to when a hotlinking action is detected. You can redirect users to an image or page saying hotlinking is not allowed. If it is not specified,  403 Forbidden will be returned.  ', '', 'Absolute URL');
		$this->db['required'] = new DATTR_HELP_ITEM('Required', ' Specifies which user/group can access this context. With this directive,  a large user database can be shared amongst contexts of different levels of permission. ', 'user username [username ...] or group groupid [groupid ...]', 'Syntax is compatible with Apache, valid syntaxes are   user username [username ...] <br><br>  Only listed users can access this context;  group groupid [groupid ...]<br><br>  Only users belong to listed groups can access this context.  If it is not specified, all valid users can access this resource.');
		$this->db['requiredPermissionMask'] = new DATTR_HELP_ITEM('Required Permission Mask', ' Specifies the required permission mask for static files that the web server will serve. For example, if only files that are readable by everyone can be served, set the value to 0004. See man 2 stat for all values. ', '', 'octal numbers');
		$this->db['respBuffer'] = new DATTR_HELP_ITEM('Response Buffering', ' Specifies whether to buffer response received from external applications. If Apache&#039;s Non-Parsed-Header mode is available enabled, buffering is turned off for response with full HTTP headers. ', '', 'Select from drop down list');
		$this->db['restrained'] = new DATTR_HELP_ITEM('Restrained', ' Specifies whether files beyond this virtual host root($VH_ROOT) can be accessed  though this web site. If set to Yes, only files under $VH_ROOT can be accessed.  And access to symbolic link or context pointing to files or directories beyond $VH_ROOT  will be denied. However, it does not limit the accessibility of CGI scripts. This is useful  in shared hosting environment. Follow Symbolic Link can be set to Yes to allow  users using symbolic links under $VH_ROOT, but not anything beyond $VH_ROOT with this option turned on. ', '[Security] Turn it on in shared hosting environment.', 'Select from radio box');
		$this->db['restrictedDirPermissionMask'] = new DATTR_HELP_ITEM('Script Restricted Directory Permission Mask', ' Specifies the restricted permission mask of parent directory of a script files that the web server will not serve. For example, to prohibit serving PHP scripts in a directory that is gourp and world writable, set the mask to 022. Default value is 022. This option can be used to prevent serving scripts under a directory of  uploaded files.   See man 2 stat for all values.   ', '', 'octal numbers');
		$this->db['restrictedPermissionMask'] = new DATTR_HELP_ITEM('Restricted Permission Mask', ' Specifies the restricted permission mask for static files that the web server will not serve. For example, to prohibit serving files that are executable, set the mask to 0111.  See man 2 stat for all values.   ', '', 'octal numbers');
		$this->db['restrictedScriptPermissionMask'] = new DATTR_HELP_ITEM('Script Restricted Permission Mask', ' Specifies the restricted permission mask for script files that the web server will not serve. For example, to prohibit serving PHP scripts that are group and world writable, set the mask to 022. Default value is 022.  See man 2 stat for all values.   ', '', 'octal numbers');
		$this->db['retryTimeout'] = new DATTR_HELP_ITEM('Retry Timeout', ' Specifies the period of time that the web server waits before retrying the external application that had prior communication problem. ', '', 'Integer number');
		$this->db['rewriteBase'] = new DATTR_HELP_ITEM('Rewrite Base', ' Specifies the base URL for rewrite rules. ', '', 'URL');
		$this->db['rewriteInherit'] = new DATTR_HELP_ITEM('Rewrite Inherit', ' Specifies whether to inherit rewrite rules from parent context. If rewrite is enabled and not inherited, rewrite base and rewrite rules defined in this context will be used. ', '', 'Select from radio box');
		$this->db['rewriteLogLevel'] = new DATTR_HELP_ITEM('Rewrite Log Level', ' Specifies how detail of the rewrite engine debug output. Value ranges from 0 - 9, 0 will disable logging and 9 will produce the most detailed log. The log level of the server and the virtual host&#039;s error log must be set to at least INFO for this option to take effect. This is useful when testing your rewrite rules.    ', '', 'Integer number');
		$this->db['rewriteMapLocation'] = new DATTR_HELP_ITEM('Location', ' Specifies the location of the rewrite map in syntax of MapType:MapSource. <br><br> LiteSpeed rewrite engine supports three types of rewrite maps:  	Standard Plain Text<br><br> 	    MapType: txt;  		MapSource: file path to a valid plain ASCII	file. <br><br> 		Each line of the file should contain two elements separated  		by blank spaces. The first element is the key and the second 		element is the value. Comments can be added with a leading &quot;#&quot; 		sign.  	<br><br> 	Randomized Plain Text<br><br> 		MapType: rnd;  		MapSource: file path of a valid plain ASCII	file.<br><br> 		File format is similar to the Standard Plain Text file, the 		second element can contain multiple choices separated by a &quot;|&quot; 		sign and is chosen randomly by the rewrite engine. 	<br><br> 	Internal Function<br><br> 	    MapType: int;  		MapSource: Internal string function <br><br> 		4 functions are available: 		 			toupper: converts lookup key to upper cases. 			tolower: converts lookup key to lower cases. 			escape: perform URL encoding on lookup key. 			unescape: perform URL decoding on lookup key. 		 	<br><br> 	The following map types available in Apache 	but not implemented within LiteSpeed: Hash File and External Rewriting Program.  The implementation of LiteSpeed rewrite engine follows the specification of Apache rewrite engine, For more details about rewrite map, please refer to Apache&#039;s mod_rewrite document.  ', '', 'string');
		$this->db['rewriteMapName'] = new DATTR_HELP_ITEM('Name', ' Specifies a unique name for the rewrite map at virtual host level. This name will be used by a mapping-reference in rewrite rules via one of the following syntax:  $\{MapName:LookupKey\}<br><br> $\{MapName:LookupKey|DefaultValue\}   The implementation of LiteSpeed rewrite engine follows the specification of the Apache rewrite engine. For more details about rewrite map, please refer to Apache&#039;s mod_rewrite document.   ', '', 'string');
		$this->db['rewriteRules'] = new DATTR_HELP_ITEM('Rewrite Rules', ' Specifies a list of rewrite rules at virtual host or context level. A rewrite rule is comprised of one RewriteRule directive and optionally preceded by multiple RewriteCond directives.   Each directive should take only one line.  RewriteCond and RewriteRule follow Apache&#039;s rewrite directive syntax, just copy and paste rewrite directives in your Apache  configuration files over. There are minor differences between LiteSpeed and Apache mod_rewrite implementation:  %\{LA-U:variable\} and %\{LA-F:variable\} are ignored by LiteSpeed rewrite engine,    two new server variables are added in LiteSpeed rewrite engine: %\{CURRENT_URI\} represents the current URI processed by rewrite engine; %\{SCRIPT_NAME\} has the same meaning as the corresponding CGI environment variable.    The implementation of LiteSpeed rewrite engine follows the specification of Apache rewrite engine, For more details about rewrite rules, please refer to Apache mod_rewrite document and Apache URL Rewriting guide.   ', '', 'string');
		$this->db['rubyBin'] = new DATTR_HELP_ITEM('Ruby Path', ' Specifies path to &#039;ruby&#039; executable. Generally it is /usr/bin/ruby or /usr/local/bin/ruby depending on where ruby has been installed to. ', '', 'Absolute path.');
		$this->db['rubyProcLimit'] = new DATTR_HELP_ITEM('Max Ruby Proceses Per Account', ' Specifies the maximum number of ruby processes can be created per account. Default is 10. If one account run multiple Rails applications, the total number of ruby processes of all applications cannot exceed this limit. Each ruby process will take large amount of system resource, it is not recommended to set a high limit, otherwise, it will affect the performance of whole server if one user abuse it.  ', '', 'Integer number');
		$this->db['ruleSetAction'] = new DATTR_HELP_ITEM('Rule Set Action', ' Specifies the actions should be taken when a censoring rule in current ruleset was matched. If not set, Default Action will be used. The action string uses the same syntax as directive SecDefaultAction in  Apache mod_security, please refer to mod_security manual for more detail.   ', '', 'string');
		$this->db['runOnStartUp'] = new DATTR_HELP_ITEM('Run On Start Up', ' Specifies whether to start the external application at server start up. Only applicable to external applications that can manage its own child processes and where &#039;Instances&#039; value is set to &#039;1&#039;. If enabled, external processes will be created at server startup instead of run-time.    ', '[Performance] If configured external process has significant startup overhead, such as Rail apps, then  this option should be enabled to decrease first-page response time.', 'Select from radio box');
		$this->db['runningAs'] = new DATTR_HELP_ITEM('Running As', ' Specifies the user/group that the server process runs as.  This value was set during the installation and to change it,  you have to perform an upgrade procedure via downloaded software package. ', '[Security] Server should not run as a priviledged user such as &quot;root&quot;. For security, it it is critical that the server is configured to runs with a un-privileged user/group combination that do not have login/shell access.  User/Group of nobody is generally a good choice.', '');
		$this->db['scanPOST'] = new DATTR_HELP_ITEM('Scan Request Body', ' Specifies whether to check the body part of a HTTP POST request.  Default is No.  ', '', 'Select from radio box');
		$this->db['securedConn'] = new DATTR_HELP_ITEM('Secured Connection', ' Specifies whether HTTPS is used to access Awstats statistic.  ', '', 'Select from radio box');
		$this->db['servChrootPath'] = new DATTR_HELP_ITEM('Chroot Path', ' [Enterprise Edition Only] Specifies the directory where the chroot environment rooted.  Only &quot;root&quot; user can run the web server in chroot mode. Whether to run in chroot mode is controlled by  Enable chroot option. The installer program will set up initial chroot environment automatically.  This entry is read-only, and if you want to change it, please run the installer again. <br><br> In chroot environment, the web server and its children processes cannot access file system outside of  the chroot jail. Chroot is an advanced security feature and additional administration may be required to  make it work properly. All required executables, libraries, configuration files and devices files should be  recreated within the chroot jail.<br><br>  As the root directory is changed, you need to pay special attention to the path configuration  when an absolute path is used. A Unix domain socket or swapping directory is always relative  to the new root directory. All other path configurations are always relative to the real root.  ', '[security] Use chroot for better security.', '');
		$this->db['serverName'] = new DATTR_HELP_ITEM('Server Name', ' A unique name for this server. You can use $HOSTNAME as value.  ', '', '');
		$this->db['serverPriority'] = new DATTR_HELP_ITEM('Priority', ' Specifies priority of the server process. Value ranges from -20 to 20. A lower number means higher priority.  ', '[Performance] Usually, higher priority leads to slightly higher web performance on a busy server. Do not set priority higher than that of database process.', 'Integer number');
		$this->db['servletContext'] = new DATTR_HELP_ITEM('Servlet Context', 'A single Servlet can be imported through Servlet context.   Just specifies the URI for the Servlet and the name of the Servlet engine.   You only need to use this when you do not want to import the whole web application   or you want to protect different Servlets with different authorization realms.   The URI has the same requirement as in Java Web App Context.', '', '');
		$this->db['servletEngine'] = new DATTR_HELP_ITEM('Servlet Engine', ' Specifies the name of the Servlet engine that serves this web application.  Servlet engines are predefined in External Application section which can either  be at server or virtual host level. ', '', 'Select from drop down list');
		$this->db['setUidMode'] = new DATTR_HELP_ITEM('ExtApp Set UID Mode', ' Specifies how user id is set for an external application process. Three choices are available:  Server UID, set user/group id of external application process same as server&#039;s user/group id;      File UID, set user/group id of external application process based 	on the user/group id of the external application executable;      Doc Root UID, set user/group id of external application process based 	on the user/group id of the document root of current virtual 	host.  ', '[Security] In shared hosting environment, it is recommended to use File UID or Doc Root UID mode to prevent files owned by one virtual host from being accessed by external application script of another virtual host.', 'Select from drop down list');
		$this->db['shHandlerName'] = new DATTR_HELP_ITEM('Handler Name', ' Specifies the name of the external application that processes the script files  when the handler type is FastCGI, Web Server, LSAPI, Load Balancer or Servlet Engine. ', '', 'Select from drop down list');
		$this->db['shType'] = new DATTR_HELP_ITEM('Type', ' Specifies the type of external application that processes these script files  which can be CGI, FastCGI, Web Server, LSAPI app, Load balancer or Servlet Engine. For FastCGI, Web Server and  Servlet Engine, the handler name need to be specified which is the external application  name predefined in External Application section. ', '', 'Select from drop down list');
		$this->db['showVersionNumber'] = new DATTR_HELP_ITEM('Server Signature', ' Specifies whether to expose the server signature number in the response header Server. There are three options, when set to Hide Version, only LiteSpeed is shown, when set to  Show Version, the detail version number is shown, [Enterprise Edition Only] when set to  Hide Full Header, the whole Server header will not be set in the response header. ', '[Security] Set to Hide Version if you do not wish to expose the server version number.', 'Select from radio box');
		$this->db['siteAliases'] = new DATTR_HELP_ITEM('Site Aliases', ' Specifies all other possible domain names, IP addresses, host aliases that this virtual host can be accessed with. This value is used to populate the &quot;SiteAliases&quot; parameter in AWStats configuration. It is used to analyze referrer field in log files and to help  AWStats to decide if a referrer URL is a local or external URL. For best performance, set to the the minimum number of possible names/addresses combinations. <br><br> Example: www.myserver.com localhost 127.0.0.1 REGEX[mydomain\.(net|org)$]  ', '', 'list of domain names and IP addresses');
		$this->db['siteDomain'] = new DATTR_HELP_ITEM('Site Domain', ' Specifies the main domain name of this web site. It is the &quot;SiteDomain&quot; parameter in AWStats configuration. It is used by Awstats to generate full URL paths. If not set,  the name of this virtual host will be used.   ', '', 'domain name');
		$this->db['smartKeepAlive'] = new DATTR_HELP_ITEM('Smart Keep-Alive', ' Specifies whether to turn on Smart Keep-Alive. This option is effective only if Max Keep-Alive Requests &gt; 1. If enabled, you can also enable/disable it at virtual host level. Smart keep-alive will only establish keep-alive connections for requests of JavaScript, CSS Style Sheet and image files. For html pages, connection will not be kept alive. This will help serve more users more efficiently. Normally a web page contains multiple images and scripts that will be cached by the browsers after initial request.  It is more efficient to send those non-html static files through a single keep-alive connection and have the text/html file send through another non-keep-alive connection. This method will reduce idle connections and in turn increase capacity to handle more concurrent requests and users. ', '[Performance] Enable it for high-load web sites.', 'Select from radio box');
		$this->db['sndBufSize'] = new DATTR_HELP_ITEM('Send Buffer Size', ' The sending buffer size of each TCP socket. Set to 0 to use the default  buffer size of the operating system. 65535 is the maximum allowed buffer size. ', '[Performance] If your web site serves large static files, increase the send buffer  size to improve performance.', 'Integer number');
		$this->db['softLimit'] = new DATTR_HELP_ITEM('Connection Soft Limit', ' Specifies the soft limit of concurrent connections allowed from one IP.  Soft Limit can be exceeded temporarily during Grace Period (sec) as long as  the number is below the Connection Hard Limit but Keep-Alive connections  will be closed as soon as possible until the number of connections is lower  than the limit. If number of connections is still over the limit after the  Grace Period (sec), that IP will be blocked for Banned Period (sec).<br><br> For example, if a page contains many small graphs, the browser may try to set up  many connections at same time, especially for HTTP/1.0 clients. You would want to allow  those connections for a short period.<br><br>  Even HTTP/1.1 clients may setup multiple connections to speed up downloading and SSL   requires separate connections from non-SSL connections. Make sure the limit is set properly,   as not to adversely affect normal service. The recommended limit is between 5 and 10. ', '[Security] A lower number will enable serving more distinct clients. <br><br> &amp;nbsp;&amp;nbsp;[Security] Trusted IP or sub-network is not effected. <br><br> &amp;nbsp;&amp;nbsp;[Performance] Set to a high value when you are performing benchmark tests with large number of concurrent client machines.', 'Integer number');
		$this->db['sslEncryptionLevel'] = new DATTR_HELP_ITEM('Encryption Level', ' Specifies the strength level of SSL encryption. ', '[Security &amp; Performance] Stronger encryption consumes more CPU cycles. eNULL means no encryption at all, therefore has the best performance.', 'Check all the encryption method that you want to accept.');
		$this->db['sslProtocol'] = new DATTR_HELP_ITEM('SSL Protocol', 'Customizes SSL Protocols accepted by the listener.', '', '');
		$this->db['sslSetting'] = new DATTR_HELP_ITEM('SSL Private Key & Certificate', 'Every SSL listener requires a pair of SSL private key and SSL certificate.   Multiple SSL listeners can share same key and certificate.   SSL private key can be generated by yourself using SSL software  package, such as OpenSSL. SSL certificate can be purchased from an authorized certificate   issuer like VeriSign or Thawte. You can also sign the certificate by yourself,   but that certificate is not trusted and not supposed to be used on public web   sites containing critical data. However, the self signed certificate is good   enough for internal use, for e.g., for encrypting traffic for the  web administration console of LiteSpeed server.', '', '');
		$this->db['sslVersion'] = new DATTR_HELP_ITEM('SSL Version', ' Specifies which version of SSL protocol will be used. You can choose from  SSLv3 and TLSv1. ', '', '');
		$this->db['staticReqPerSec'] = new DATTR_HELP_ITEM('Static Requests/Second', ' Specifies the maximum number of requests to static content coming from a single IP address can be processed in each second regardless of number of connections established.  When the limit is reached, all future requests are tar-pitted until the next second.  Request limit for dynamically generated content is independent of this limit. Per client request limit can be set at server or virtual host level where virtual host level setting overrides server level setting. ', '[Security] Trusted IP or sub-network is not effected.', 'Integer number');
		$this->db['statuscode'] = new DATTR_HELP_ITEM('Status Code', ' Specifies the response status code of the external redirection.  If the status code is between 300 and 399, Destination URI can be specified. ', '', 'Select from drop down list');
		$this->db['suffix'] = new DATTR_HELP_ITEM('Suffix', ' Specifies the suffixes of script files. Suffix must be unique. Server will add a special MIME type implicitly for the first suffix in the list, the MIME type is like &quot;application/x-httpd-[suffix]&quot;. For example, MIME type &quot;application/x-httpd-php53&quot; will be added for suffix &quot;php53&quot;. It can be used to change script handler by assigning that MIME type to a context or file with certain suffix. Usually, Apache configuration directives, &quot;AddType&quot; or &quot;ForceType&quot;, can be used in .htaccess to change script handler.  ', '[Performance &amp; Security] Only specifies the suffixes you really needed.', 'Comma delimited list with period &quot;.&quot; character prohibited');
		$this->db['suffixes'] = new DATTR_HELP_ITEM('Suffix', ' Specifies what kind of file will be protected from hotlinking by listing file suffixes here. ', '', 'comma delimited list, &quot;.&quot; is prohibited');
		$this->db['swappingDir'] = new DATTR_HELP_ITEM('Swapping Directory', ' Specifies the directory where the swapping files should be placed.  When server started in chroot mode, it is relative to the new root directory,  otherwise it is relative to the real root.<br><br>LiteSpeed web server uses virtual memory  to reduce the memory usage. Virtual memory, disk swapping, is used to store big request bodies and  dynamically generated responses. The swapping directory should be placed on a disk with enough space. ', '[Performance] Place the swapping directory on a separate disk or increase Max I/O Buffer Size to eliminate swapping.', 'Absolute path.');
		$this->db['templateFile'] = new DATTR_HELP_ITEM('Template File', ' Specifies the path to the configuration file of this template. ', '', 'path');
		$this->db['templateName'] = new DATTR_HELP_ITEM('Name', ' A unique name for the template. ', '', '');
		$this->db['templateVHAliases'] = new DATTR_HELP_ITEM('Aliases', ' Specifies the alternate names for the virtual host. All possible hostname and IP address should be added to the list. Wildcard character * and ? are allowed in the name. It is recommended to append : for web site not on standard port 80. <br><br>  It will be used in the following situations:    To match the host name in the &quot;Host&quot; header when processing a   request.   To populate domain name/alias configurations configurations for add-ons    like frontpage or awstats.  ', '', 'comma-separated list of domain name');
		$this->db['templateVHDomain'] = new DATTR_HELP_ITEM('Domain', ' Specifies a main domain name for this member virtual host. If left blank, virtual host name will be used. This should be a fully qualified domain name, but you can use IP address as well. It is recommended to append : for web site not on standard port 80. It can be referenced by variable $VH_DOMAIN for configuration contains domain names. <br><br>  It will be used in the following situation:    To match the host name in the &quot;Host&quot; header when processing a   request.   To populate domain name configurations for add-ons    like frontpage or awstats.  ', '', 'domain name');
		$this->db['templateVHName'] = new DATTR_HELP_ITEM('Name', ' A unique name for this virtual host among all template member virtual hosts and standalone virtual hosts. It can be referenced by variable $VH_NAME inside a directory path configuration. <br><br> If a standalone virtual host with the same name is also configured, then the member virtual host configuration will be ignored.  ', '', '');
		$this->db['templateVHRoot'] = new DATTR_HELP_ITEM('Virtual Host Root', ' Specifies the root directory of this virtual host. Variable $VH_NAME must appear in the path. If left blank, the virtual host root path in the template configuration will be used instead.   ', '', 'path');
		$this->db['totalInMemCacheSize'] = new DATTR_HELP_ITEM('Total Small File Cache Size', ' Specifies the total memory that can be allocated to buffer cache in order to cache/serve small static files. ', '', 'Integer number');
		$this->db['totalMMapCacheSize'] = new DATTR_HELP_ITEM('Total MMAP Cache Size', ' Specifies the total memory that can be allocated for memory mapped cache in order to cache/serve medium sized static files.  ', '', 'Integer number');
		$this->db['updateInterval'] = new DATTR_HELP_ITEM('Update Interval', ' Specifies how often the Awstats statistic is updated. Options are daily or hourly.  ', '', 'Select from drop down list');
		$this->db['updateMode'] = new DATTR_HELP_ITEM('Update Mode', ' Specifies how AWStats statistic is being updated.       Disabled: AWStats is disabled. Statistics will not be updated.      Static: Static HTML pages will be created after the statistics being updated.      Dynamic: Only statistics will be updated. HTML pages will be generated dynamically by awstats.pl CGI script.  ', '', 'Select from drop down list');
		$this->db['updateOffset'] = new DATTR_HELP_ITEM('Update Offset', ' Specifies when the update should be performed during the {item= updateInterval }. For example, set it to 3600 to start statistic processing at 1AM for &quot;Daily&quot; update.   ', 'It is recommended to spread the &quot;Update Offset&quot; if many virtual hosts are hosted on one server to avoid server overload and multiple Awstats processes running at the same time. Log processing is a CPU and i/o intensive task.', 'number of seconds');
		$this->db['uri'] = new DATTR_HELP_ITEM('URI', ' Specifies the URI for this context. URI should start with a &quot;/&quot;.  If an URI ends with a &quot;/&quot; then this context will include all sub-URIs under this URI. ', '', 'URI');
		$this->db['useAIO'] = new DATTR_HELP_ITEM('Use AIO', ' Specifies whether to use AIO to serve static files. AIO will help if your server has high I/O wait.  ', '', 'Select from radio box');
		$this->db['useIpInProxyHeader'] = new DATTR_HELP_ITEM('Use Client IP in Header', ' Specifies whether to use IP address listed in &quot;X-Forwarded-For&quot; HTTP request header for all IP address related features, including connection/bandwidth throttling, access control and IP geolocation. This feature is useful if your web server is behind a load balancer or a proxy server. If you select &quot;Trusted IP Only&quot;, then &quot;X-Forwarded-For&quot; IP will be used only when the request is coming from trusted IPs defined in the Server Level Allowed List.  ', '', 'Select from drop down list');
		$this->db['useSendfile'] = new DATTR_HELP_ITEM('Use sendfile()', ' Specifies whether to use sendfile() system call to serve static files. Static files can be served in four different ways: memory buffer cache, memory-mapped cache, plain read/write, and sendfile. File smaller than Max Cached Small File Size is served from memory buffer cache, file size larger than Max Cached Small File Size but smaller than  Max MMAP File Size will be served from memory-mapped cache.  File larger than Max MMAP File Size will be served via plain read/write or sendfile. Sendfile() is a &quot;zero copy&quot; system call that can greatly reduce CPU utilization when serving very large static files. Sendfile() requires optimized network card kernel driver and thus may not be applicable for some small-vendor network adapters.   ', '', 'Select from radio box');
		$this->db['userDBCacheTimeout'] = new DATTR_HELP_ITEM('User DB Cache Timeout', ' Specifies how often the backend user database will be checked for changes.  Every entry in the cache has a loading timestamp. When cached data is older than the specified timeout, the backend database will be checked  for changes. If there is no change, the timestamp will be reset to current time, otherwise  the new data will be loaded. Sever reload, graceful restart,  will clear the cache immediately. ', '[Performance] If the backend database does not change very often,  set a longer timeout for better performance.', 'Integer number');
		$this->db['userDBLocation'] = new DATTR_HELP_ITEM('User DB Location', ' Specifies the location of the user database.  For DB type of Password File, it is the path to the flat file containing user/password definitions. You can edit this file through the WebAdmin by clicking on the file name.<br><br> Each line of the user file contains a username followed by a colon,  followed by crypt() encrypted password optionally followed by a colon  and group names that user belongs to. Group names are delimitated by comma.  If group information is specified in the user DB, then the group database will not be checked.<br><br> Example:john:HZ.U8kgjnMOHo:admin,user  For DB type of LDAP, it is the LDAP URL to query the user information. For each valid user, the authentication data stored in the LDAP server should contain at least the user id and user password. One and only one record should be returned in the LDAP search request based on the this URL and username received in the HTTP Authentication header. &quot;$k&quot; must be specified in the filter part of the URL and it will be replaced with the username. User password attribute must be returned in the query result. Attribute name of user password is specified by Password Attribute. Group information can be optionally specified by Member-of Attribute.<br><br> Example: At minimum, a user can be defined in LDAP with object classes: uidObject, simpleSecurityObject and organizationalRole. The following URL could be used: <br><br> ldap://localhost/ou=UserDB,dc=example,dc=com???(&amp;(objectClass=*)(uid=$k))  ', '[Security] It is recommended to store a user password file outside of the document tree.  If it has to be placed inside document tree, simply name it with a leading &quot;.ht&quot;  like .htuser to prevent being served as a static file.  LiteSpeed web server  does not serve files prefixed with &quot;.ht&quot;.', 'path to the user DB file or LDAP URL (RFC 2255)');
		$this->db['userDBMaxCacheSize'] = new DATTR_HELP_ITEM('User DB Max Cache Size', ' Specifies the maximum cache size of the user database.  Most recently accessed user authentication data will be cached in memory  to provide maximum performance. ', '[Performance] As larger cache will consume more memory,  a higher value may or may not provide better performance. Set it to an appropriate size according  to your user database size and site usage.', 'Integer number');
		$this->db['userDB_attrMemberOf'] = new DATTR_HELP_ITEM('Member-of Attribute', ' Specifies the name of the Member-of attribute for a user record stored in LDAP server. Default value is memberOf. Member-of attribute can be used to specify the group name that the user belongs to. ', '', 'string');
		$this->db['userDB_attrPasswd'] = new DATTR_HELP_ITEM('Password Attribute', ' Specifies the name of the password attribute for a user record stored in LDAP server. Default value is userPassword. ', '', 'string');
		$this->db['verifyDepth'] = new DATTR_HELP_ITEM('Verify Depth', '[Enterprise Edition Only] Specifies the maximum depth of CA Certificates in  It sets how deeply the certificate should be verified before  determine that the clients don&#039;t have a valid certificate. Default is 1. ', '', 'Select from drop down list');
		$this->db['vhAccessControl'] = new DATTR_HELP_ITEM('Access Control', 'Specifies what sub-network and/or IP address can access this virtual host   in addition to server level access control. Virtual host setting does NOT override   the server setting. Whether to block/allow an IP is determined by the combination   of allowed list and denied list. If you want to block certain IP or sub-network,   put * or ALL in the allowed list and list the blocked IP or   sub-network in the denied list. If you want to only allow certain IP or sub-network,   put * or ALL in the denied list and list the allowed IP or   sub-network in the allowed list. The setting of the smallest scope that fits for   an IP will be used to determine whether to block or allow access.', '', '');
		$this->db['vhHotlink'] = new DATTR_HELP_ITEM('Hotlink Control', 'Hotlinking are requests made from an external website to  files on your own website often referred to as &quot;leeching&quot;. This practice  introduce additional bandwidth usage that you should not be responsible for. <br><br>  LiteSpeed server can prevent others from hotlinking content on  your web site by checking the &quot;Referer&quot; header within a HTTP request. If the &quot;Referer&quot; header does not match your own website,   the request is denied.', '', '');
		$this->db['vhMaxKeepAliveReq'] = new DATTR_HELP_ITEM('Max Keep-Alive Requests', ' Specifies the maximum requests that can be served through a Keep-Alive (Persistent)  connection. Connections will be closed once this limit is reached. You can specify different limit for different virtual hosts. This number cannot exceed server level Max Keep-Alive Requests limit. ', '[Performance] Set to a high and resonable value. Value of 1 or less will disable Keep-Alive.', 'Integer number');
		$this->db['vhName'] = new DATTR_HELP_ITEM('Virtual Host Name', ' A unique name for a virtual host. It is recommended to use the domain name of this virtual host. ', '', '');
		$this->db['vhRoot'] = new DATTR_HELP_ITEM('Virtual Host Root', ' Specifies the root directory of the virtual host. Note: This is NOT  the document root. It is recommended to place all files related to the virtual host  under this directory like virtual host configuration, log files, html files, CGI scripts, etc.  Virtual Host Root can be referred as $VH_ROOT. ', '[Performance] Place different virtual hosts on different hard drives.', 'An absolute path or a relative path to $SERVER_ROOT.');
		$this->db['vhSmartKeepAlive'] = new DATTR_HELP_ITEM('Smart Keep-Alive', ' Specifies whether to turn on Smart Keep-Alive for this virtual host. This option is effective only if server level Smart Keep-Alive is enabled and Max Keep-Alive Requests &gt; 1. ', '[Performance] Enable this for busy web sites.', 'Select from radio box');
		$this->db['vhaccessControl_allow'] = new DATTR_HELP_ITEM('Allowed List', ' Specifies the list of IP or sub-net allowed. ', '', 'comma-delimited list of IP address or sub-network. * or ALL,  sub-network can be like 192.168.1.0/255.255.255.0, 192.168.1 or 192.168.1.*.');
		$this->db['vhadminEmails'] = new DATTR_HELP_ITEM('Administrator Email', ' Specifies email address of administrators of this virtual host. ', '', '');
		$this->db['vhlog_logLevel'] = new DATTR_HELP_ITEM('Log Level', ' Specifies the level of logging. Available levels are ERROR,  WARNING, NOTICE, INFO and DEBUG from high to low.  Only messages with higher level than current setting will be logged.  If you want to set it to DEBUG, you must set server log level to be DEBUG as well.  The level of debugging is solely controlled by Debug Level. ', '[Performance] Unless Debug Level is set to a level other than NONE, DEBUG log level does not have any performance impact and is recommended.', 'Select from drop down list');
		$this->db['virtualHostMapping'] = new DATTR_HELP_ITEM('Virtual Host Mappings', 'Specifies the relationship between the listener and virtual hosts.   Listener and virtual hosts are associated by domain names.   A HTTP request will be routed to a virtual host with matching domain name.   One listener can map to multiple virtual hosts on different domain names.   One virtual host can also be mapped from different listeners.   One listener can allow one catchall virtual host with domain name &quot;*&quot;.   When there is no explicitly matched domain name, listener will forward   the request to that catchall virtual host.', '[Performance] Only add necessary mappings. If the listener is dedicated   to only one virtual host, then only set the catchall mapping with &quot;*&quot;.', '');
		$this->db['virtualHostName'] = new DATTR_HELP_ITEM('Virtual Host', ' Specifies the name of a virtual host.  ', '', 'Select from drop down list');
		$this->db['workingDir'] = new DATTR_HELP_ITEM('Working Directory', ' Specifies the &quot;DataDir&quot; parameter in AWStats configuration file.  All result files, AWStats databases, will be stored there.  This directory should be writable by the owner of the document root of this virtual host. Usually we set it under the virtual host root like  $VH_ROOT/awstats/.  ', '', 'A path which can be absolute, or relative to $SERVER_ROOT, or relative to $VH_ROOT.');
	}

}
?>
