<?php

class BuildOptions
{
	var $base_ver;
	var $type; //NONE, DEFAULT, IMPORT, INPUT
	var $batch_id;
	var $validated = FALSE;

	
	var $vals = array(
			'OptionVersion' => OPTION_VERSION,
			'PHPVersion' => '',
			'ExtraPathEnv' => '',
			'InstallPath' => '',
			'ConfigParam' => '',
			'AddOnSuhosin' => TRUE,
			'AddOnMailHeader' => TRUE,
			'AddOnAPC' => FALSE,
			'AddOnEAccelerator' => FALSE,
			'AddOnXCache' => FALSE,
			'AddOnMemCache' => FALSE,
			'AddOnMemCached' => FALSE);
	

	function BuildOptions($version="")
	{
		if ( $version != "" && !$this->setVersion($version)) {
			return NULL;
		}
		$this->type = 'NONE';
		$this->batch_id = ''. time() . '.' . rand(1,9);
	}

	function setVersion($version)
	{
		global $PHP_VER;
		$base = substr($version, 0, strpos($version, '.'));
		if(!array_key_exists($base, $PHP_VER)
			|| !in_array($version, $PHP_VER[$base])) {
			return FALSE;
		}
		$this->base_ver = $base;
		$this->vals['PHPVersion'] = $version;
		return TRUE;
	}

	function setDefaultOptions()
	{
		global $DEFAULT_PHP_PARAMS;

		$this->vals['ExtraPathEnv'] = '';
		$this->vals['InstallPath'] = DEFAULT_INSTALL_DIR . $this->base_ver;
		$this->vals['ConfigParam'] = $DEFAULT_PHP_PARAMS[$this->base_ver];
		$this->vals['AddOnSuhosin'] = TRUE;
		$this->vals['AddOnMailHeader'] = TRUE;
		$this->vals['AddOnAPC'] = FALSE;
		$this->vals['AddOnEAccelerator'] = FALSE;
		$this->vals['AddOnXCache'] = FALSE;
		$this->vals['AddOnMemCache'] = FALSE;
		$this->vals['AddOnMemCached'] = FALSE;

		$this->type = 'DEFAULT';
		$this->validated = TRUE;
	}

	function getSavedOptions()
	{
		$filename = LAST_CONF . $this->base_ver . '.options2';
		if (file_exists($filename)) {
			$str = file_get_contents($filename);
			if ($str != '') {
				$vals = unserialize($str);
				$saved_options = new BuildOptions($vals['PHPVersion']);
				$saved_options->type = 'IMPORT';
				$saved_options->vals = $vals;
				return $saved_options;
			}
		}
		return NULL;
	

	}

	function saveOptions()
	{
		if (!$this->validated) {
			return FALSE;
		}

		$saved_val = $this->vals;
		
		$saved_val['ConfigParam'] = trim(preg_replace("/ ?'--(prefix=|enable-suhosin)[^ ]*' */", ' ', $saved_val['ConfigParam']));
			
		$serialized_str = serialize($saved_val);
		
		$filename = LAST_CONF . $this->base_ver . '.options2';
		return BuildTool::my_file_put_contents($filename, $serialized_str);
	}

	function gen_loadconf_onclick($method)
	{
		if ($this->type != $method) {
			return 'disabled';
		}
		$params = str_replace("'", "\\'", $this->vals['ConfigParam']) ;
		$addon_suhosin = $this->vals['AddOnSuhosin'] ? 'true':'false';
		$addon_mailHeader = $this->vals['AddOnMailHeader'] ? 'true':'false';
		$addon_apc = $this->vals['AddOnAPC'] ? 'true':'false';
		$addon_eacc = $this->vals['AddOnEAccelerator'] ? 'true':'false';
		$addon_xcache = $this->vals['AddOnXCache'] ? 'true':'false';
		$addon_memcache = $this->vals['AddOnMemCache'] ? 'true':'false';
		//$addon_memcached = $this->vals['AddOnMemCached'] ? 'true':'false';
		
		$loc = 'document.buildphp';
		$buf = "onClick=\"$loc.path_env.value='{$this->vals['ExtraPathEnv']}';
		$loc.installPath.value='{$this->vals['InstallPath']}';
		$loc.configureParams.value='$params';
		$loc.addonSuhosin.checked={$addon_suhosin};
		$loc.addonMailHeader.checked={$addon_mailHeader};
		$loc.addonAPC.checked={$addon_apc};
		$loc.addonEAccelerator.checked={$addon_eacc};
		$loc.addonXCache.checked={$addon_xcache};
		$loc.addonMemCache.checked={$addon_memcache};
		//$loc.addonMemCached.checked={$addon_memcached};
		
		\"";
			
		return $buf;
	}
}


class BuildCheck
{
	var $cur_step;
	var $next_step = 0;
	var $pass_val = array();

	function BuildCheck()
	{
		$this->cur_step = DUtil::grab_input('ANY',"step");
		$this->validate_step();
	}

	function validate_step()
	{
		if ($this->cur_step == '') {
			$this->next_step = 1;
		}
		elseif ($this->cur_step == '1') {
			$this->validate_step1();
		}
		elseif ($this->cur_step == '2') {
			$this->validate_step2();
		}
		elseif ($this->cur_step == '3') {
			$this->validate_step3();
		}
		//else illegal

	}

	function validate_step1()
	{
		$found = false;
		global $PHP_VER;

		foreach($PHP_VER as $base => $ver) {
			if (!array_key_exists("php_version$base", $_REQUEST)) {
				return FALSE;
			}
			if (array_key_exists("build$base", $_REQUEST)) {
				$selversion = $_REQUEST["php_version$base"];
				if (in_array($selversion, $ver)) {
					$this->pass_val['php_version'] = $selversion;
					$found = true;
				}
				else {
					return FALSE;
				}
			}
		}

		if ( $found ) {
			$this->next_step = 2;
		}
		return $found;
	}

	function validate_step2()
	{
		$go_back = DUtil::grab_input('ANY','back');
		if ($go_back != '') {
			$this->next_step = 1;
			return TRUE;
		}
		$php_version = DUtil::grab_input('ANY','version');

		// only if illegal action, will have err
		if ( !$this->validate_php_version($php_version) ) { 
			$this->next_step = 0;
			return FALSE;
		}
		$this->pass_val['php_version'] = $php_version;

		$options = new BuildOptions($php_version);
		
		$options->vals['ExtraPathEnv'] = DUtil::grab_input('ANY','path_env');
		$options->vals['InstallPath'] = DUtil::grab_input('ANY','installPath');
		$configParams = DUtil::grab_input('ANY','configureParams');
		
		$options->vals['AddOnSuhosin'] = (NULL != DUtil::grab_input('ANY','addonSuhosin'));
		$options->vals['AddOnMailHeader'] = (NULL != DUtil::grab_input('ANY','addonMailHeader'));
		$options->vals['AddOnAPC'] = (NULL != DUtil::grab_input('ANY','addonAPC'));
		$options->vals['AddOnEAccelerator'] = (NULL != DUtil::grab_input('ANY','addonEAccelerator'));
		$options->vals['AddOnXCache'] = (NULL != DUtil::grab_input('ANY','addonXCache'));
		$options->vals['AddOnMemCache'] = (NULL != DUtil::grab_input('ANY','addonMemCache'));
		$options->vals['AddOnMemCached'] = (NULL != DUtil::grab_input('ANY','addonMemCached'));
		
		// can be real input err
		$v1 = $this->validate_extra_path_env($options->vals['ExtraPathEnv']);
		$v2 = $this->validate_install_path($options->vals['InstallPath']);
		$v3 = $this->validate_config_params($configParams);
			
		if (!$v1 || !$v2 || !$v3) {
			$options->type = 'INPUT';
			$options->validated = FALSE;
			$this->pass_val['input_options'] = $options;
			$this->next_step = 2;
			return FALSE;
		}
		
		$foundSuhosin = strpos($configParams, '--enable-suhosin');
		if ($options->vals['AddOnSuhosin'] && $foundSuhosin === FALSE ) {
			$configParams .= " '--enable-suhosin'";
		}
		elseif (!$options->vals['AddOnSuhosin'] && $foundSuhosin > 0) {
			$options->vals['AddOnSuhosin'] = TRUE;
		}

		if (strpos($configParams, '--with-litespeed') === FALSE) {
			$configParams .= " '--with-litespeed'";
		}
			
		$configParams = "'--prefix={$options->vals['InstallPath']}' " . $configParams;
		$options->vals['ConfigParam'] = escapeshellcmd($configParams);
			
		$options->type = 'BUILD';
		$options->validated = TRUE;
		$this->pass_val['build_options'] = $options;
		$this->next_step = 3;
		return TRUE;
	}
	
	function validate_step3()
	{
		global $_SESSION;
		
		if (!isset($_SESSION['progress_file'])) {
			echo "missing progress file";
			return FALSE;
		}
		$progress_file = $_SESSION['progress_file'];
		
		if (!isset($_SESSION['log_file'])) {
			echo "missing log file";
			return FALSE;
		}
		$log_file = $_SESSION['log_file'];
		if (!file_exists($log_file)) {
			echo "logfile does not exist";
			return FALSE;
		}

		$manual_script = DUtil::grab_input('ANY','manual_script');
		if ($manual_script == '' || !file_exists($manual_script)) {
			echo "missing manual script";
			return FALSE;
		}
		
		$php_version = DUtil::grab_input('ANY', 'php_version');
		if ($php_version == '') {
			echo "missing php_version";
			return FALSE;
		}
		
		$this->pass_val['php_version'] = $php_version;
		$this->pass_val['progress_file'] = $progress_file;
		$this->pass_val['log_file'] = $log_file;
		$this->pass_val['manual_script'] = $manual_script;
		$this->pass_val['extentions'] = DUtil::grab_input('ANY', 'extentions');

		$go_back = DUtil::grab_input('ANY','back');
		if ($go_back != '') {
			$this->next_step = 2;
		}
		else {
			$this->next_step = 4;
		}
		return TRUE;
	}


	function validate_php_version($version)
	{
		global $PHP_VER;
		$base = substr($version, 0, strpos($version,'.'));

		if(!array_key_exists($base, $PHP_VER)
		|| !in_array($version, $PHP_VER[$base])) {
			$this->pass_val['err'] = 'Illegal';
			return FALSE;
		}
		else
		return TRUE;
	}

	function validate_extra_path_env($extra_path_env)
	{
		if ($extra_path_env === '') {
			return TRUE;
		}
		$envp = preg_split("/:/", $extra_path_env);
		foreach ($envp as $p) {
			if (!is_dir($p)) {
				$this->pass_val['err']['path_env'] = "invalid path $p";
				return FALSE;
			}
		}
		$extra_path_env .= ':';
		return TRUE;
	}

	function validate_install_path(&$path)
	{
		$path = PathTool::clean($path);
		if ($path == '') {
			$this->pass_val['err']['installPath'] = 'Missing path';
			return FALSE;
		}
		if ($path[0] != '/') {
			$this->pass_val['err']['installPath'] = 'Require absolute path';
			return FALSE;
		}

		if (preg_match('/([;&"|#$?`])/', $path)) {
			$this->pass_val['err']['installPath'] = 'Illegal characters found.';
			return FALSE;
		}
		
		//parent exists.
		if (!is_dir($path)) {
			if (is_file($path)) {
				$this->pass_val['err']['installPath'] = 'Not a directory';
				return FALSE;
			}
			$testpath = dirname($path);
			if (!is_dir($testpath)) {
				$this->pass_val['err']['installPath'] = 'Parent directory does not exist';
				return FALSE;
			}
		}
		else {
			$testpath = $path;
		}

		if ($testpath == '.' || $testpath == '/'
		|| PathTool::isDenied($testpath)) {
			$this->pass_val['err']['installPath'] = 'Illegal location';
			return FALSE;
		}

		return TRUE;
	}

	function validate_config_params(&$config_params)
	{
		if (preg_match('/([;&"|#$?`])/', $config_params)) {
			$this->pass_val['err']['configureParams'] = 'Illegal characters found parameters.';
			return FALSE;
		}

		// split array
		$params = array();
		$flag = array();
		$a = str_replace("\n", " ", $config_params);
		$a = trim($a) . ' ';
		while (strlen($a) > 0) 
		{
		    $m = NULL;
		    $isflag = false;
		    if (preg_match("/^'--[a-zA-Z_\-0-9]+=[^=^'^;]+'\s+/", $a, $matches)) {
				$m = $matches[0];
		    }
		    elseif (preg_match("/^'--[a-zA-Z_\-0-9]+'\s+/", $a, $matches)) {
				$m = $matches[0];
		    }
		    elseif (preg_match("/^--[a-zA-Z_\-0-9]+=[^=^'^;^ ]+\s+/", $a, $matches)) {
				$m = $matches[0];
		    }
		    elseif (preg_match("/^--[a-zA-Z_\-0-9]+\s+/", $a, $matches)) {
				$m = $matches[0];
		    }
		    elseif (preg_match("/^(CFLAGS|CXXFLAGS|LDFLAGS)='[^=^'^;]+'\s+/", $a, $matches)) {
				$m = $matches[0];
				$isflag = true;
		    }
		    if ($m != NULL) {
				$a = substr($a, strlen($m));
				if ($isflag) {
				    $flag[] = rtrim($m);
				} 
				else {
					// ignore unused options
					// '--prefix=/usr/local'
					// '--with-apxs2=/usr/local/apache/bin/apxs' '--with-apxs=/usr/local/apache/bin/apxs' '--with-apxs2'
					// '--enable-fastcgi'
					if (!preg_match( "/(--prefix=)|(--with-apxs)|(--enable-fastcgi)/", $m)) {
						$m = trim(rtrim($m), "'");
						$params[] = "'$m'";
					}
				}
		    }
		    else {
		    	$pe = $a;
		    	$ipos = strpos($pe, ' ');
		    	if ( $ipos !== FALSE) {
		    		$pe = substr($a, 0, $ipos);
		    	}
				$this->pass_val['err']['configureParams'] = "invalid parameter starting at $pe";
				return FALSE;
		    }
		}
		
		if (empty($params)) {
			$this->pass_val['err']['configureParams'] = 'parameters cannot be empty.';
			return FALSE;
		}
		
		$options = '';
		if (!empty($flag)) {
		    $options .= implode(' ', $flag);
		}
	    $options .= implode(' ', $params);
		
		$config_params = $options;
		return TRUE;
	}


}

class BuildTool
{
	var $options = NULL;
	var $ext_options = array();
	var $dlmethod;
	var $progress_file;
	var $log_file;
	var $suhosin_patch_url;
	var $extension_used;
	
	var $build_prepare_script = NULL;
	var $build_install_script = NULL;
	var $build_manual_run_script = NULL;

	function BuildTool($input_options)
	{
		if ($input_options == NULL || !$input_options->validated) {
			return NULL;
		}
		$this->options = $input_options;
	}

	function init(&$error)
	{
		if ($this->options->saveOptions()) {
			echo "<p>Configuration saved successfully. you can retrieve it for next build.</p>\n";
		}
		else {
			echo "<p>fail to save current configuration.</p>\n";
		}

		$this->progress_file = BUILD_DIR . '/buildphp_' . $this->options->batch_id . '.progress';
		$this->log_file = BUILD_DIR . '/buildphp_' . $this->options->batch_id . '.log';
		$this->build_prepare_script = BUILD_DIR . '/buildphp_' . $this->options->batch_id . '.prep.sh';
		$this->build_install_script = BUILD_DIR . '/buildphp_' . $this->options->batch_id . '.install.sh';
		$this->build_manual_run_script = BUILD_DIR . '/buildphp_manual_run.sh';
		
		if (file_exists($this->progress_file)) {
			$error = "Please do not use the browser refresh, back and forward buttons on the PHP build pages. Current batch is in progress.";
			return FALSE;
		}

		if (!$this->detectDownloadMethod()) {
			$error = "ERROR: Unable to detect download method (install curl, fetch, or wget)";
			return FALSE;
		}
		
		$this->initDownloadUrl();
		return TRUE;
	}

	function detectDownloadMethod()
	{
		$OS=`uname`;
		$dlmethod = ''; // dlmethod $output $url
		if ( strpos($OS,'FreeBSD') !== FALSE )
		{
			if ((exec('PATH=$path_env:/bin:/usr/bin:/usr/local/bin fetch', $o,$status)||1) && $status == 64)
			$dlmethod = "fetch -o";
		}
		if ( strpos($OS,'SunOS') !== FALSE ) // for SunOS, status is 1, so use return string
		{
			if ( exec('PATH=$path_env:/bin:/usr/bin:/usr/local/bin curl', $o, $status) != '') {
				$dlmethod = "curl -L -o";
			}
			elseif ( exec('PATH=$path_env:/bin:/usr/bin:/usr/local/bin wget', $o, $status) != '') {
				$dlmethod = "wget -nv -O";
			}
		}
		
		if ( $dlmethod == '' )
		{
			if ( (exec('PATH=$path_env:/bin:/usr/bin:/usr/local/bin curl', $o, $status)||1) && $status <= 2) {
				$dlmethod = "curl -L -o";
			}
			elseif ((exec( 'PATH=$path_env:/bin:/usr/bin:/usr/local/bin wget', $o, $status)|| 1) && $status <= 2 ) {
				$dlmethod = "wget -nv -O";
			}
			else {
				return FALSE;
			}
		}
		$this->dlmethod = $dlmethod;
		return TRUE;
	}

	
	function my_file_put_contents($filename, $contents) 
	{ 	// file_put_contents in php5 only
		if (!$handle = fopen($filename,'w')) {
			return FALSE;
		}
		if (fwrite($handle,$contents) === FALSE) {
			return FALSE;
		}
		fclose($handle);
		return TRUE;
	}


	function initDownloadUrl()
	{
		// SUHOSIN_PATCH_URL
		$php_version = $this->options->vals['PHPVersion'];
		$patch_ver = '';
		if ($php_version < '5.2.0') {
			$patch_ver = '0.9.6';
		}
		elseif ($php_version >= '5.3.3') {
			$patch_ver = '0.9.10';
		}
		elseif ($php_version == '5.2.9' || $php_version == '5.2.17') {
			$patch_ver = '0.9.7';
		}

		$this->suhosin_patch_url = 'http://download.suhosin.org/suhosin-patch-' . $php_version . '-' . $patch_ver . '.patch.gz';
		if ($php_version == '5.3.5' || $php_version == '5.3.6') {
			$this->suhosin_patch_url = 'http://download.suhosin.org/suhosin-patch-5.3.4-0.9.10.patch.gz';
		}
		elseif ($php_version == '5.3.8') {
			$this->suhosin_patch_url = 'http://download.suhosin.org/suhosin-patch-5.3.7-0.9.10.patch.gz';
		}
		elseif ($php_version == '5.2.17') {
			$this->suhosin_patch_url = 'http://download.suhosin.org/suhosin-patch-5.2.16-0.9.7.patch.gz';
		}

		// extension
		$ext = array('{EXTENSION_NAME}' => 'Suhosin');
		$ver = 'suhosin-'.SUHOSIN_VERSION;
		$ext['{EXTENSION_DIR}'] = $ver;
		$ext['{EXTENSION_SRC}'] = $ver .'.tgz';
		$ext['{EXTENSION_DOWNLOAD_URL}'] = 'http://download.suhosin.org/' . $ver . '.tar.gz';
		$ext['{EXTRACT_METHOD}'] = 'tar -zxf';
		$ext['{EXTENSION_EXTRA_CONFIG}'] = '';		

		$this->ext_options['Suhosin'] = $ext;
		
		$ext = array('{EXTENSION_NAME}' => 'APC');
		$ver = 'APC-' . APC_VERSION;
		$ext['{EXTENSION_DIR}'] = $ver;
		$ext['{EXTENSION_SRC}'] = $ver . '.tgz';
		$ext['{EXTENSION_DOWNLOAD_URL}'] = 'http://pecl.php.net/get/'. $ver . '.tgz';
		$ext['{EXTRACT_METHOD}'] = 'tar -zxf';
		$ext['{EXTENSION_EXTRA_CONFIG}'] = '--enable-apc';		

		$this->ext_options['APC'] = $ext;
		
		$ext = array('{EXTENSION_NAME}' => 'eAccelerator');
		// determin ea version
		if ($php_version >= '5.2') {
			$ver = '0.9.6.1';
			$sver = 'eaccelerator-0.9.6.1';
		}
		else {
			$ver = '0.9.5.3';
			$sver = 'eaccelerator-0.9.5.3';
		}
		$ext['{EXTENSION_DIR}'] = $sver;
		$ext['{EXTENSION_SRC}'] = $sver . '.tar.bz2';
		// $ext['{EXTENSION_DOWNLOAD_URL}'] = 'http://bart.eaccelerator.net/source/' . $ver . '/' . $sver . '.tar.bz2';
		$ext['{EXTENSION_DOWNLOAD_URL}'] = 'http://www.litespeedtech.com/packages/eaccelerator/' . $sver . '.tar.bz2';
		$ext['{EXTRACT_METHOD}'] = 'tar -jxf';
		$ext['{EXTENSION_EXTRA_CONFIG}'] = '--enable-eaccelerator=shared';		

		$this->ext_options['eAccelerator'] = $ext;
		
		$ext = array('{EXTENSION_NAME}' => 'XCache');
		$ver = 'xcache-' . XCACHE_VERSION;
		$ext['{EXTENSION_DIR}'] = $ver;
		$ext['{EXTENSION_SRC}'] = $ver . '.tar.gz';
		$ext['{EXTENSION_DOWNLOAD_URL}'] = 'http://xcache.lighttpd.net/pub/Releases/' . XCACHE_VERSION . '/' . $ver . '.tar.gz';
		$ext['{EXTRACT_METHOD}'] = 'tar -zxf';
		$ext['{EXTENSION_EXTRA_CONFIG}'] = '--enable-xcache';		

		$this->ext_options['XCache'] = $ext;

		$ext = array('{EXTENSION_NAME}' => 'MemCache');
		$ver = 'memcache-' . MEMCACHE_VERSION;
		$ext['{EXTENSION_DIR}'] = $ver;
		$ext['{EXTENSION_SRC}'] = $ver . '.tgz';
		$ext['{EXTENSION_DOWNLOAD_URL}'] = 'http://pecl.php.net/get/'. $ver . '.tgz';
		$ext['{EXTRACT_METHOD}'] = 'tar -zxf';
		$ext['{EXTENSION_EXTRA_CONFIG}'] = '--enable-memcache';
				
		$this->ext_options['MemCache'] = $ext;
		
//		$ext = array('{EXTENSION_NAME}' => 'MemCached');
//		$ver = 'memcached-' . MEMCACHED_VERSION;
//		$ext['{EXTENSION_DIR}'] = $ver;
//		$ext['{EXTENSION_SRC}'] = $ver . '.tgz';
//		$ext['{EXTENSION_DOWNLOAD_URL}'] = 'http://pecl.php.net/get/'. $ver . '.tgz';
//		$ext['{EXTRACT_METHOD}'] = 'tar -zxf';
//		$ext['{EXTENSION_EXTRA_CONFIG}'] = '--enable-memcached';
//				
//		$this->ext_options['MemCached'] = $ext;
		
	}

	function getExtensionNotes($extensions)
	{
		$ocname = array();
		if (strpos($extensions, 'APC') !== FALSE) {
			$ocname[] = 'APC';					
		}
		if (strpos($extensions, 'eAccelerator') !== FALSE) {
			$ocname[] = 'eAccelerator';	
		}
		if (strpos($extensions, 'XCache') !== FALSE) {
			$ocname[] = 'XCache';	
		}
		
		if (count($ocname) == 0) {
			return ''; 
		}
		$notes = '<li>To enable the opcode cache, please make sure the following is added to
				 your php.ini configuration file. In addition, you may need to check the log detail to 
				 determine the directory where your extensions are installed and add the directory to the
				 extensions path in your php.ini configuration file.<br />';
		$notes1 = '';
		foreach($ocname as $ocn) {
			if ($ocn == 'eAccelerator') {
				$notes1 .= '
;				=================
;				eAccelerator
;				=================
extension="eaccelerator.so"
eaccelerator.shm_size= 16
eaccelerator.cache_dir="/tmp/eaccelerator"
eaccelerator.enable=1
eaccelerator.optimizer=1
eaccelerator.check_mtime=1
eaccelerator.debug=0
eaccelerator.filter=""
eaccelerator.shm_max="0"
eaccelerator.shm_ttl="0"
eaccelerator.shm_prune_period="0"
eaccelerator.shm_only="0"
eaccelerator.compress="1"
eaccelerator.compress_level="9"

';
			}

			if ($ocn == 'APC') {
				$notes1 .= '
;				=================
;				APC
;				=================
				extension=apc.so
				
				';
			}
			
			if ($ocn == 'XCache') {
				$notes1 .= '
;				=================
;				XCache
;				=================
				extension=xcache.so
				
				';
			}
		}
		$notes .= nl2br($notes1);
		$notes .= '</li>';	
	
		return $notes;
	}

	
	function generate_script(&$error)
	{
		if ($this->progress_file == NULL) {
			if (!$this->init($error)) {
				return FALSE;
			}
		}
		$params = array();
		$params['{PHP_VERSION}'] = $this->options->vals['PHPVersion'];
		$params['{PROGRESS_F}'] = $this->progress_file;
		$params['{LOG_FILE}'] = $this->log_file;
		$processUser = posix_getpwuid(posix_geteuid());
		$params['{PHP_USR}'] = $processUser['name'];
		$params['{EXTRA_PATH_ENV}'] = $this->options->vals['ExtraPathEnv'];
		$params['{PHP_BUILD_DIR}'] = BUILD_DIR;
		$params['{DL_METHOD}'] = $this->dlmethod;
		$params['{INSTALL_DIR}'] = $this->options->vals['InstallPath'];
		$params['{ENABLE_SUHOSIN}'] = ($this->options->vals['AddOnSuhosin']) ? 1 : 0;
		$params['{SUHOSIN_PATCH_URL}'] = $this->suhosin_patch_url;
		$params['{ENABLE_MAILHEADER}'] = ($this->options->vals['AddOnMailHeader']) ? 1 : 0;
		$params['{LSAPI_VERSION}'] = LSAPI_VERSION;
		$params['{PHP_CONF_OPTIONS}'] = $this->options->vals['ConfigParam'];
		$params['{LSWS_HOME}'] = $_SERVER['LS_SERVER_ROOT'];
		$params['{INSTALL_SCRIPT}'] = $this->build_install_script;

		$search = array_keys($params);
		$replace = array_values($params);
		
		//common header
		$template_file = 'build_common.template';
		$template = file_get_contents($template_file);
		if ($template === false) {
			$error = 'failed to read file: ' . $template_file;
			return false;
		}
		$template_script = str_replace($search, $replace, $template);
		$prepare_script = $template_script;
		$install_script = $template_script;
		
		
		// prepare php
		$template_file = 'build_prepare.template';
		$template = file_get_contents($template_file);
		if ($template === false) {
			$error = 'failed to read file: ' . $template_file;
			return false;
		}
		$template_script = str_replace($search, $replace, $template);
		$prepare_script .= $template_script;
		
		// install php
		$template_file2 = 'build_install.template';
		$template2 = file_get_contents($template_file2);
		if ($template2 === false) {
			$error = 'failed to read file: ' . $template_file2;
			return false;
		}
		$template_script2 = str_replace($search, $replace, $template2);
		$install_script .= $template_script2;
		
		//prepare extension
		$template_file = 'build_prepare_ext.template';
		$template = file_get_contents($template_file);
		if ($template === false) {
			$error = 'failed to read file: ' . $template_file;
			return false;
		}
		
		//install extension
		$template_file2 = 'build_install_ext.template';
		$template2 = file_get_contents($template_file2);
		if ($template2 === false) {
			$error = 'failed to read file: ' . $template_file2;
			return false;
		}
		
		$extList = array();
		if ($this->options->vals['AddOnSuhosin']) {
			$extList[] = 'Suhosin';
		}
		if ($this->options->vals['AddOnAPC']) {
			$extList[] = 'APC';
		}
		if ($this->options->vals['AddOnEAccelerator']) {
			$extList[] = 'eAccelerator';
		}
		if ($this->options->vals['AddOnXCache']) {
			$extList[] = 'XCache';
		}
		if ($this->options->vals['AddOnMemCache']) {
			$extList[] = 'MemCache';
		}
//		if ($this->options->vals['AddOnMemCached']) {
//			$extList[] = 'MemCached';
//		}
		foreach ($extList as $extName) {
			$newparams = array_merge($params, $this->ext_options[$extName]);
			$search = array_keys($newparams);
			$replace = array_values($newparams);
			$template_script = str_replace($search, $replace, $template);
			$prepare_script .= $template_script;
			$template_script2 = str_replace($search, $replace, $template2);
			$install_script .= $template_script2;
		}
		$this->extension_used = implode('.', $extList);

		$prepare_script .= 'main_msg "**PREPARE_DONE**"' . "\n";
		$install_script .= 'main_msg "**COMPLETE**"' . "\n"; 
		
		if ( $this->my_file_put_contents($this->build_prepare_script, $prepare_script) === FALSE) {
			
			$error = 'Failed to create build prepare script: ' . $this->build_prepare_script;
			return false;
		}

		if ( chmod($this->build_prepare_script, 0700) == FALSE) {
			$error = 'Failed to chmod for ' . $this->build_prepare_script;
			return false;
		}

		if ( $this->my_file_put_contents($this->build_install_script, $install_script) === FALSE) {
			
			$error = 'Failed to create build install script: ' . $this->build_install_script;
			return false;
		}

		if ( chmod($this->build_install_script, 0700) == FALSE) {
			$error = 'Failed to chmod for ' . $this->build_install_script;
			return false;
		}
		
		// final manual run script
		$template_file = 'build_manual_run.template';
		$template = file_get_contents($template_file);
		if ($template === false) {
			$error = 'failed to read file: ' . $template_file;
			return false;
		}
		$template_script = str_replace($search, $replace, $template);
		if ( $this->my_file_put_contents($this->build_manual_run_script, $template_script) === FALSE) {
			
			$error = 'Failed to create manual install script: ' . $this->build_manual_run_script;
			return false;
		}

		if ( chmod($this->build_manual_run_script, 0700) == FALSE) {
			$error = 'Failed to chmod for ' . $this->build_manual_run_script;
			return false;
		}
		
		
		return true;
	}
	
	
}

?>
