
CURDIR=`dirname "$0"`
cd $CURDIR
CURDIR=`pwd`
LSWSHOME=`dirname $CURDIR`
LSWSHOME=`dirname $LSWSHOME`



test_license()
{
	if [ -f "$LSWSHOME/conf/license.key" ] && [ ! -f "./license.key" ]; then
		cp "$LSWSHOME/conf/license.key" "./license.key"
	fi
	if [ -f "$LSWSHOME/conf/serial.no" ] && [ ! -f "./serial.no" ]; then
		cp "$LSWSHOME/conf/serial.no" "./serial.no"
	fi
	if [ -f "$LSWSHOME/conf/trial.key" ] && [ ! -f "./trial.key" ]; then
		cp "$LSWSHOME/conf/trial.key" "./trial.key"
	fi
	if [ -f "./license.key" ] && [ -f "./serial.no" ]; then
		output=`bin/lshttpd -t`
        if [ $? -ne 0 ]; then
            echo $output >> $LOGFILE
	        echo "[ERROR] License key verification failed" >> $LOGFILE
	        exit 1
        fi
	fi
}


if [ "x$3" = "x" ]; then
	
	cat <<EOF
Usage: update.sh VERSION EDITION PLATFORM
  Upgrade to another version of LiteSpeed web server. the package file must 
  exist under $LSWSHOME/autoupdate/
  Package file should be lsws-VERSION-EDITION-PLATFORM.tar.gz

EOF
	exit 1
fi

LOGFILE=$LSWSHOME/autoupdate/update.log
cd $LSWSHOME/autoupdate/

echo "Extracting package file" >> $LOGFILE

PACKAGEFILE=$LSWSHOME/autoupdate/lsws-$1-$2-$3.tar.gz
if [ -f $PACKAGEFILE ]; then
	gunzip -c $PACKAGEFILE | tar xf -
else
	echo "[ERROR] Package file $PACKAGEFILE does not exist." >> $LOGFILE
	exit 1
fi

cd $LSWSHOME/autoupdate/lsws-$1
if [ $? -ne 0 ]; then
	echo "[ERROR] Failed to change current directory to $LSWSHOME/autoupdate/lsws-$1" >> $LOGFILE
	exit 1
fi

source ./functions.sh
if [ $? != 0 ]; then
    . ./functions.sh
    if [ $? != 0 ]; then
        echo "[ERROR] Can not include 'functions.sh'." >> $LOGFILE
        exit 1
    fi
fi

init
LSWS_HOME=$LSWSHOME
INTSTALL_TYPE="upgrade"
readCurrentConfig

if [ $2 = 'ent' ] || [ $2 = 'pro' ]; then
    test_license
fi

installation
echo "Upgrade to $1 successfully." >> $LOGFILE

rm -rf $LSWSHOME/autoupdate/lsws-$1
rm -f $PACKAGEFILE

exit 0

