#!/usr/bin/ruby

$0="RAILS: #{ENV['APP_NAME'] || ENV['RAILS_ROOT']} (#{ENV['RAILS_ENV']})"
if GC.respond_to?(:copy_on_write_friendly=)
    GC.copy_on_write_friendly = true
end

Dir.chdir( ENV['RAILS_ROOT'] )

if defined? RAILS_GEM_VERSION
    rails_ver = RAILS_GEM_VERSION
elsif ENV.include?('RAILS_GEM_VERSION')
    rails_ver = ENV['RAILS_GEM_VERSION']
else
    environmentrb = File.read('config/environment.rb')
    rails_ver = $1 if environmentrb =~ /^[^#]*RAILS_GEM_VERSION\s*=\s*["']([!~<>=]*\s*[\d.]+)["']/
end

if rails_ver != nil and rails_ver >= '2.3.0'
    #use rack
    require 'config/boot'
    require 'active_support'
    require 'action_controller'
    require 'fileutils'
    
    options = {
        :environment => (ENV['RAILS_ENV'] || "development").dup,
        :config => RAILS_ROOT + "/config.ru",
        :detach => false,
        :debugger => false
    }
    
    server = Rack::Handler::LSWS
    
    if File.exist?(options[:config])
    config = options[:config]
    if config =~ /\.ru$/
        cfgfile = File.read(config)
        if cfgfile[/^#\\(.*)/]
        opts.parse!($1.split(/\s+/))
        end
        inner_app = eval("Rack::Builder.new {( " + cfgfile + "\n )}.to_app", nil, config)
    else
        require config
        inner_app = Object.const_get(File.basename(config, '.rb').capitalize)
    end
    else
        require 'config/environment'
        inner_app = ActionController::Dispatcher.new
    end

    app = Rack::Builder.new {
        use Rails::Rack::Static
        use Rails::Rack::Debugger if options[:debugger]
        run inner_app
    }.to_app

    ActiveRecord::Base.clear_all_connections! if defined?(ActiveRecord::Base)

    #if defined?(ActiveRecord::Base)
    #    if ActiveRecord::Base.respond_to?(:clear_all_connections!)
    #        ActiveRecord::Base.clear_all_connections!
    #    elsif ActiveRecord::Base.connection_pool.respond_to?(:clear_all_connections!)
    #        ActiveRecord::Base.connection_pool.clear_all_connections!
    #    else
    #        ActiveRecord::Base.connection_pool.disconnect!
    #    end
    #end

    begin
        server.run(app, options.merge(:AccessLog => []))
    ensure
        puts 'Exiting'
    end

else

    require 'config/environment'

    require 'initializer'
    require 'dispatcher'

    #require 'breakpoint' if defined?(BREAKPOINT_SERVER_PORT)

    #if RAILS_ENV=='production'
    #   require_dependency 'application'
    #   Dir.foreach( "app/models" ) {|f| silence_warnings{require_dependency f} if f =~ /\.rb$/}
    #   Dir.foreach( "app/controllers" ) {|f|  silence_warnings{require_dependency f} if f =~ /\.rb$/}
    #end

    require 'lsapi'

    #Close all DB connections established during initialization
    if defined?(ActiveRecord::Base)
    if defined?(ActiveRecord::Base.clear_active_connections!)
        ActiveRecord::Base.clear_active_connections!
    else
        ActiveRecord::Base.connection.disconnect!
        @reconnect = true
        ActiveRecord::Base.establish_connection
    end
    end

    while LSAPI.accept != nil
        if defined?(ActiveRecord::Base) and @reconnect
            ActiveRecord::Base.connection.reconnect!
            @reconnect = false
        end

        Dispatcher.dispatch
    end
end