(defun fun_begin()
  (setq 
    osmode_old (getvar "osmode")
    cmdecho_old (getvar "cmdecho")
  )
  (setvar "cmdecho" 0)
  (command "undo" "be")
)
(defun fun_end()
  (setvar "osmode" osmode_old)
  (setvar "cmdecho" cmdecho_old)
  (command "undo" "e")
)

;=========================================================
;stringsformatʽַ
(defun stringsformat(strings strlength aligntoright)
	(if (< strlength (strlen strings))
		(setq strings (substr strings 1 strlength))
		(repeat (- strlength (strlen strings))
			(if aligntoright
				(setq strings (strcat "0" strings))
				(setq strings (strcat strings " "))
			)
		)
	)
	strings
)

;;;=========================================================
;  lst2lststr_layer бתΪlistб
(defun lst2lststr_layer(lst / i lst_items str_row)
	(setq i 0)
	(repeat (length lst)
		(setq	str_row
			(strcat
				(stringsformat (itoa i) 2 t) " | "
				(stringsformat (nth i lst) 20 nil)
			)
			lst_items (append lst_items (list str_row))
			i (1+ i)
		)
	)
	lst_items
)

;;;======================================================================;
;; getLayerNameList زб
;  ﷨: (getLayerNameList)
;  ˵: زб
;  : -
;  : б
(defun getLayerNameList( / layer layer_list layers)
	(setq layers (vla-get-layers (vla-get-activedocument (vlax-get-acad-object))))
	(vlax-for layer layers
		(setq layer_list (append layer_list (list (vla-get-name layer)) ))
	)
)

;;;======================================================================;
;; str2lst תΪַб
;  ﷨: (str2lst str)
;  ˵: תΪַб
;  : str:ַ
;  : б
;  ʾ: (str2lst  "Hello 2World 12 5456.1568")  -> ("Hello" "2World" "12" "5456.1568")
(defun str2lst (str /)
  (read (vl-list->string
	  (apply 'append(mapcar '(lambda (x)(if (= 32 x) (list 34 32 34) (list x)))(append (list 40 34)(vl-string->list str)(list 34 41))))
  ))
)

;=========================================================
;numlst2strбתΪַ
(defun numlst2str (numlst delimiter / num return)
	(setq return "")
	(foreach num numlst
		(setq return (strcat return delimiter (itoa num)))
	)
	(substr return 2)
)

;;;=========================================================
;  lst2str ַбתΪַ
;  ﷨: (lst2str lst)
;  ˵: תΪַб
;  : lst2str:ַб
;  : ַ
;  ʾ: (lst2str '("Hello" "2World" "12" "5456.1568"))  -> "Hello 2World 12 5456.1568"
(defun lst2str(lst / i str1 str)
	(setq i 0 str "")
	(repeat (length lst)
		(setq str1 (nth i lst))
		(setq str (strcat str " " str1))
		(setq i (1+ i))
	)
	(substr str 2)
)

;get_layer_listȡǰбԭб˳
(defun get_layer_list( / layer_list layer_list_old e1 e2)
	(setq layer_list (getLayerNameList))
	(if (/= (getvar "users1") "")
		(progn
			(setq layer_list_old (str2lst (getvar "users1")))
			(setq layer_list (vl-sort layer_list (function (lambda (e1 e2)
				(< (length (member e1 layer_list_old)) (length (member e2 layer_list_old))))))
			)
		)
	)
	layer_list
);get_layer_list end

;sort_layer_listͼбתΪԻбĿ
(defun sort_layer_list(xlayernamelist / index index_item layer_name lst_item lst_items);sort_layer_list
	(setq
		index 0
		glb_str_layers ""
	)
	(repeat (length xlayernamelist)
		(if (<= (car (nth index xlayernamelist)) 9)
			(setq index_item (strcat "0" (itoa (car (nth index xlayernamelist)))))
			(setq index_item (itoa (car (nth index xlayernamelist))))
		)
		(setq
			layer_name (cdr (nth index xlayernamelist))
			lst_item (strcat index_item " | " layer_name)
			index (1+ index)
			glb_str_layers (strcat glb_str_layers " " layer_name)
			lst_items (append lst_items (list lst_item))
		)
	)
);sort_layer_list

;show_dialogʼʾԻ
(defun show_dialog(xlayernamelist xselected_items / lst_items)
	(if (not (new_dialog "main" dcl_id))(exit))
	(start_list "list_layer")
	(mapcar 'add_list xlayernamelist)
	(end_list)
	(action_tile "up" "(move_layers -1)")
	(action_tile "down" "(move_layers 1)")
	(action_tile "accept" "(done_dialog)(setq yesno T)")
	(action_tile "cancel" "(done_dialog)(setq yesno nil)")
	(set_tile "list_layer" (itoa xselected_items))
	(start_dialog)
	(unload_dialog dcl_id)
);show_dialog

;;;=====================================================================;
;; exchange_list_2items бָŵΪ0
;  ﷨: (exchange_list_2items items_list index_item1 index_item2)
;  ˵: бָŵΪ0
;  : items_list:б index_item1index_item2:ҪĿ,Ϊ0
;  : б
;  ʾ: (exchange_list_2items  (list 1 2 3 4 5) 1 2)  -> (1 3 2 4 5)
(defun exchange_list_2items(items_list index_item1 index_item2 / ijk items_list_new)
	(setq
		items_list_new (list "new")
		ijk 0
	)
	(repeat (length items_list)
		(cond
			((= ijk index_item1)(setq items_list_new (append items_list_new (list (nth index_item2 items_list)))))
			((= ijk index_item2)(setq items_list_new (append items_list_new (list (nth index_item1 items_list)))))
			(t(setq items_list_new (append items_list_new (list (nth ijk items_list)))))
		)
		(setq ijk (1+ ijk))
	)
	(cdr items_list_new)
)

;=========================================================
;updown_move_items бƶ
;  ﷨: (updown_move_items items_list index_move_list xupdown)
;  ˵: бָŵǰƶһλ
;  : items_list:б index_move_list:Ҫƶб,Ϊ0 xupdownƶ-1ǰ 1
;  : б
;  ʾ: (exchange_list_2items  (list 1 2 3 4 5) 1 2)  -> (1 3 2 4 5)
(defun updown_move_items(items_list index_move_list xupdown / index_first index_last index_move index_move_list_sort is_bottom is_stop is_top x)
  (setq
		index_move_list_sort (vl-sort index_move_list '<)
		index_first (car index_move_list_sort)
		index_last (last index_move_list_sort)
		is_top (and (= index_first 0) (= xupdown -1))
		is_bottom (and (= index_last (1- (length items_list))) (= xupdown 1))
		is_stop (or is_top is_bottom)
	);жƵĶǷ񵽴ﶥƵĶǷ񵽴ײ
	(if (= xupdown 1) (setq index_move_list_sort (reverse index_move_list_sort)))
	(if (= is_stop nil)
		(progn
			(foreach index_move index_move_list_sort
				(setq
					items_list (exchange_list_2items items_list index_move (+ index_move xupdown))
				)
			);ѡеĶƶ
			(setq	index_move_list (mapcar '(lambda(x) (+ x xupdown)) index_move_list));ȡƶԺѡ
		)
  )
	(list items_list index_move_list)
);move_items

;=========================================================
;move_layersöԻбĿƶʵֶ
(defun move_layers(xupdown / index_movelayers_list liststrlist selected_items selected_softlists)
	(setq index_movelayers_list_str (get_tile "list_layer"))
	(setq index_movelayers_list (read (strcat "(" index_movelayers_list_str ")")));ȡƶĿ
	(setq selected_layerlists (updown_move_items glb_Layer_List index_movelayers_list xupdown))
	(setq selected_items (numlst2str (cadr selected_layerlists) " "))
	(setq glb_Layer_List (car selected_layerlists))
	(setq liststrlist (lst2lststr_layer glb_Layer_List))
	(start_list "list_layer")
	(mapcar 'add_list liststrlist)
	(end_list);ƶĴббĿ
	(set_tile "list_layer" selected_items);ѡĿλ
);move_layers

;doitкͼбжʾ˳
(defun doit(xyesno)
	(if xyesno
		(foreach layer glb_Layer_List
			(setq ss (ssget "X" (list (cons 8 layer_name))))
			(command "draworder" ss "" "b")
		)
	)
	(princ)
)

(defun c:super_draworder( / selected_item selected_items)
	(fun_begin)
	(setq
		dcl_id (load_dialog "super_draworder.dcl")
		glb_Layer_List (get_layer_list)
	)
	(show_dialog (lst2lststr_layer glb_Layer_List) 0)
	(doit yesno)
	(setvar "users1" (lst2str glb_Layer_List))
	(princ)
	(fun_end)
)