(defun c:pm (/	    ang	   cmdecho	 dis1	dis2   e      e1
	     e2	    elist  kw	  olist	 osmode	pt1    pt2    v10
	     v101   v102   v11	  jw-mlayer	main
	    )
  (princ
    "\nPMCAD Draw Beam and Wall double line. carrot1983 2008/12/01"
  )
;;;-------------ͨú
  (defun jw-mlayer (layername layercolor)
    (entmake (list (cons 0 "LAYER")
		   (cons 100 "AcDbSymbolTableRecord")
		   (cons 100 "AcDbLayerTableRecord")
		   (cons 2 layername) ;_layer name "test"
		   (cons 62 layercolor) ;_layer color 7
		   (cons 6 "Continuous")
		   (cons 70 0)
	     )
    )
  )
;;;-------------ʼ
  (command "._undo" "begin")
  (setq cmdecho (getvar "cmdecho"))
  (setq osmode (getvar "osmode"))
  (setvar "cmdecho" 0)
  (setvar "osmode" 163)
  (jw-mlayer "jwaxis" 1)
  (jw-mlayer "jwwall" 3)
  (jw-mlayer "jwbeam" 4)

;;;-------------
  (defun main (offsetlayer)
    (if	*pm:dis1
      *pm:dis1
      (setq *pm:dis1 100)
    )
    (if	*pm:dis2
      *pm:dis2
      (setq *pm:dis2 100)
    )
    (setq dis1 *pm:dis1)
    (setq dis2 *pm:dis2)
    (while (and
	     (princ "\nCurrent Left width = ")
	     (princ *pm:dis1)
	     (princ " Right width = ")
	     (princ *pm:dis2)
	     (not (initget "S"))
	     (setq pt1
		    (getpoint "\nGet first point [Setting width(S)] <exit>: ")
	     )
	   )
      (cond
	((= pt1 "S")
	 ;;*pm:dis1
	 (setq
	   dis1
	    (getdist (strcat "\nGet left width <" (rtos *pm:dis1) ">: ")
	    )
	 )
	 (if (null dis1)
	   (setq dis1 *pm:dis1)
	   (setq *pm:dis1 dis1)
	 )
	 ;;*pm:dis2
	 (setq
	   dis2	(getdist
		  (strcat "\nGet right width <" (rtos *pm:dis2) ">: ")
		)
	 )
	 (if (null dis2)
	   (setq dis2 *pm:dis2)
	   (setq *pm:dis2 dis2)
	 )
	)
	((or (listp pt1) (null pt1))
	 (while	(setq pt2 (getpoint pt1 "\nThe next point <back>: "))
	   (command "._line" "none" pt1 "none" pt2 "")
	   (command "._chprop" (setq e (entlast)) "" "la" "jwaxis" "")
	   (setq v10 (cdr (assoc 10 (entget e))))
	   (setq v11 (cdr (assoc 11 (entget e))))
	   (setq ang (+ (* 0.5 pi) (angle v10 v11)))
	   (setq v101 (polar v10 ang 1))
	   (setq v102 (polar v10 ang -1))
	   (command "._offset"
		    (abs dis1)
		    "none"
		    (list e v10)
		    "none"
		    v101
		    ""
	   )
	   (command "._chprop"
		    (setq e1 (entlast))
		    ""
		    "la"
		    offsetlayer
		    ""
	   )
	   (command "._offset"
		    (abs dis2)
		    "none"
		    (list e v10)
		    "none"
		    v102
		    ""
	   )
	   (command "._chprop"
		    (setq e2 (entlast))
		    ""
		    "la"
		    offsetlayer
		    ""
	   )
	   (setq pt1 pt2)
	   (setq elist (cons (list e e1 e2) elist))
	 )
	)
      )
    )
    olist
  )

;;;-------------
  ;;*pm:kw
  (if *pm:kw
    *pm:kw
    (setq *pm:kw "B")
  )
  (initget "B W")
  (setq
    kw (getkword
	 (strcat "\nDraw [Beam(B)/Wall(W)] <" *pm:kw ">: ")
       )
  )
  (if (null kw)
    (setq kw *pm:kw)
    (setq *pm:kw kw)
  )

  (cond	((= kw "B")
	 (alert "\nStart draw beam")
	 (main "jwbeam")
	)
	((= kw "W")
	 (alert "\nStart draw wall")
	 (main "jwwall")
	)
  )

  ;;-------------ָ
  (setvar "osmode" osmode)
  (setvar "cmdecho" cmdecho)
  (command "._undo" "end")
  (princ)
)
