(defun C:CKJQ (/ pt0 ptlist ptlist0 ss cmdecho osmode getpoint_list)
  (setq	cmdecho	(getvar "cmdecho")
	osmode	(getvar "osmode")
  )
  (defun getpoint_list (/ DIS OUT PT)
    (setq pt (getpoint "\nʼ"))
    (princ "\n:")
    (if	(= (type pt) 'LIST)
      (progn
	(setq out (list pt)
	      dis (* 0.01 (getvar "viewsize"))
	)
	(while (= 5 (car (setq pt (grread t 4 0))))
	  (setq pt (cadr pt))
	  (if (> (distance pt (car out)) dis)
	    (progn
	      (grdraw pt (car out) 1)
	      (setq out (cons pt out))
	    )
	  )
	)
      )
    )
    (redraw)
    (reverse out)
  )
  (while (and (setq ptlist0 (getpoint_list))
	      (> (length ptlist0) 1)
	 )
    (setvar "cmdecho" 0)
    (setvar "osmode" 0)
    (setq pt0	 (car ptlist0)
	  ptlist (cdr ptlist0)
    )
    (command "trim" "")
    (foreach pt	ptlist
      (command "f" pt0 pt "")
      (setq pt0 pt)
    )
    (command "")
    (if	(setq ss (ssget "f" ptlist0))
      (command "erase" ss "")
    )
    (setvar "osmode" osmode)
    (setvar "cmdecho" cmdecho)
  )
  (princ)
)

