/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.DialogListener;
import ij.gui.GUI;
import ij.gui.HTMLDialog;
import ij.gui.MultiLineLabel;
import ij.macro.Interpreter;
import ij.macro.MacroRunner;
import ij.plugin.ScreenGrabber;
import ij.plugin.filter.PlugInFilterRunner;
import ij.plugin.frame.Recorder;
import ij.util.Tools;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.SystemColor;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

public class GenericDialog
extends Dialog
implements ActionListener,
TextListener,
FocusListener,
ItemListener,
KeyListener,
AdjustmentListener,
WindowListener {
    public static final int MAX_SLIDERS = 25;
    protected Vector numberField;
    protected Vector stringField;
    protected Vector checkbox;
    protected Vector choice;
    protected Vector slider;
    protected Vector radioButtonGroups;
    protected TextArea textArea1;
    protected TextArea textArea2;
    protected Vector defaultValues;
    protected Vector defaultText;
    protected Vector defaultStrings;
    protected Component theLabel;
    private Button cancel;
    private Button okay;
    private Button no;
    private Button help;
    private String okLabel = "  OK  ";
    private String cancelLabel = "Cancel";
    private String helpLabel = "Help";
    private boolean wasCanceled;
    private boolean wasOKed;
    private int y;
    private int nfIndex;
    private int sfIndex;
    private int cbIndex;
    private int choiceIndex;
    private int textAreaIndex;
    private int radioButtonIndex;
    private GridBagLayout grid;
    private GridBagConstraints c;
    private boolean firstNumericField = true;
    private boolean firstSlider = true;
    private boolean invalidNumber;
    private String errorMessage;
    private boolean firstPaint = true;
    private Hashtable labels;
    private boolean macro;
    private String macroOptions;
    private int topInset;
    private int leftInset;
    private int bottomInset;
    private boolean customInsets;
    private int[] sliderIndexes;
    private double[] sliderScales;
    private Checkbox previewCheckbox;
    private Vector dialogListeners;
    private PlugInFilterRunner pfr;
    private String previewLabel = " Preview";
    private static final String previewRunning = "wait...";
    private boolean recorderOn;
    private boolean yesNoCancel;
    private char echoChar;
    private boolean hideCancelButton;
    private boolean centerDialog = true;
    private String helpURL;
    private String yesLabel;
    private String noLabel;
    private boolean smartRecording;

    public GenericDialog(String title) {
        this(title, WindowManager.getCurrentImage() != null ? WindowManager.getCurrentImage().getWindow() : (IJ.getInstance() != null ? IJ.getInstance() : new Frame()));
    }

    public GenericDialog(String title, Frame parent) {
        super(parent == null ? new Frame() : parent, title, true);
        if (Prefs.blackCanvas) {
            this.setForeground(SystemColor.controlText);
            this.setBackground(SystemColor.control);
        }
        this.grid = new GridBagLayout();
        this.c = new GridBagConstraints();
        this.setLayout(this.grid);
        this.macroOptions = Macro.getOptions();
        this.macro = this.macroOptions != null;
        this.addKeyListener(this);
        this.addWindowListener(this);
    }

    public void addNumericField(String label, double defaultValue, int digits) {
        this.addNumericField(label, defaultValue, digits, 6, null);
    }

    public void addNumericField(String label, double defaultValue, int digits, int columns, String units) {
        String label2 = label;
        if (label2.indexOf(95) != -1) {
            label2 = label2.replace('_', ' ');
        }
        Label theLabel = this.makeLabel(label2);
        this.c.gridx = 0;
        this.c.gridy = this.y;
        this.c.anchor = 13;
        this.c.gridwidth = 1;
        this.c.insets = this.firstNumericField ? this.getInsets(5, 0, 3, 0) : this.getInsets(0, 0, 3, 0);
        this.grid.setConstraints(theLabel, this.c);
        this.add(theLabel);
        if (this.numberField == null) {
            this.numberField = new Vector(5);
            this.defaultValues = new Vector(5);
            this.defaultText = new Vector(5);
        }
        if (IJ.isWindows()) {
            columns -= 2;
        }
        if (columns < 1) {
            columns = 1;
        }
        TextField tf = new TextField(IJ.d2s(defaultValue, digits), columns);
        if (IJ.isLinux()) {
            tf.setBackground(Color.white);
        }
        tf.addActionListener(this);
        tf.addTextListener(this);
        tf.addFocusListener(this);
        tf.addKeyListener(this);
        this.numberField.addElement(tf);
        this.defaultValues.addElement(new Double(defaultValue));
        this.defaultText.addElement(tf.getText());
        this.c.gridx = 1;
        this.c.gridy = this.y;
        this.c.anchor = 17;
        tf.setEditable(true);
        this.firstNumericField = false;
        if (units == null || units.equals("")) {
            this.grid.setConstraints(tf, this.c);
            this.add(tf);
        } else {
            Panel panel = new Panel();
            panel.setLayout(new FlowLayout(0, 0, 0));
            panel.add(tf);
            panel.add(new Label(" " + units));
            this.grid.setConstraints(panel, this.c);
            this.add(panel);
        }
        if (Recorder.record || this.macro) {
            this.saveLabel(tf, label);
        }
        ++this.y;
    }

    private Label makeLabel(String label) {
        if (IJ.isMacintosh()) {
            label = label + " ";
        }
        return new Label(label);
    }

    private void saveLabel(Object component, String label) {
        if (this.labels == null) {
            this.labels = new Hashtable();
        }
        if (label.length() > 0) {
            if (label.charAt(0) == ' ') {
                label = label.trim();
            }
            this.labels.put(component, label);
        }
    }

    public void addStringField(String label, String defaultText) {
        this.addStringField(label, defaultText, 8);
    }

    public void addStringField(String label, String defaultText, int columns) {
        String label2 = label;
        if (label2.indexOf(95) != -1) {
            label2 = label2.replace('_', ' ');
        }
        Label theLabel = this.makeLabel(label2);
        this.c.gridx = 0;
        this.c.gridy = this.y;
        this.c.anchor = 13;
        this.c.gridwidth = 1;
        boolean custom = this.customInsets;
        if (this.stringField == null) {
            this.stringField = new Vector(4);
            this.defaultStrings = new Vector(4);
            this.c.insets = this.getInsets(5, 0, 5, 0);
        } else {
            this.c.insets = this.getInsets(0, 0, 5, 0);
        }
        this.grid.setConstraints(theLabel, this.c);
        this.add(theLabel);
        if (custom) {
            this.c.insets = this.stringField.size() == 0 ? this.getInsets(5, 0, 5, 0) : this.getInsets(0, 0, 5, 0);
        }
        TextField tf = new TextField(defaultText, columns);
        if (IJ.isLinux()) {
            tf.setBackground(Color.white);
        }
        tf.setEchoChar(this.echoChar);
        this.echoChar = '\u0000';
        tf.addActionListener(this);
        tf.addTextListener(this);
        tf.addFocusListener(this);
        tf.addKeyListener(this);
        this.c.gridx = 1;
        this.c.gridy = this.y;
        this.c.anchor = 17;
        this.grid.setConstraints(tf, this.c);
        tf.setEditable(true);
        this.add(tf);
        this.stringField.addElement(tf);
        this.defaultStrings.addElement(defaultText);
        if (Recorder.record || this.macro) {
            this.saveLabel(tf, label);
        }
        ++this.y;
    }

    public void setEchoChar(char echoChar) {
        this.echoChar = echoChar;
    }

    public void addCheckbox(String label, boolean defaultValue) {
        this.addCheckbox(label, defaultValue, false);
    }

    private void addCheckbox(String label, boolean defaultValue, boolean isPreview) {
        String label2 = label;
        if (label2.indexOf(95) != -1) {
            label2 = label2.replace('_', ' ');
        }
        if (this.checkbox == null) {
            this.checkbox = new Vector(4);
            this.c.insets = this.getInsets(15, 20, 0, 0);
        } else {
            this.c.insets = this.getInsets(0, 20, 0, 0);
        }
        this.c.gridx = 0;
        this.c.gridy = this.y;
        this.c.gridwidth = 2;
        this.c.anchor = 17;
        Checkbox cb = new Checkbox(label2);
        this.grid.setConstraints(cb, this.c);
        cb.setState(defaultValue);
        cb.addItemListener(this);
        cb.addKeyListener(this);
        this.add(cb);
        this.checkbox.addElement(cb);
        if (!isPreview && (Recorder.record || this.macro)) {
            this.saveLabel(cb, label);
        }
        if (isPreview) {
            this.previewCheckbox = cb;
        }
        ++this.y;
    }

    public void addPreviewCheckbox(PlugInFilterRunner pfr) {
        if (this.previewCheckbox != null) {
            return;
        }
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null && imp.isComposite() && ((CompositeImage)imp).getMode() == 1) {
            return;
        }
        this.pfr = pfr;
        this.addCheckbox(this.previewLabel, false, true);
    }

    public void addPreviewCheckbox(PlugInFilterRunner pfr, String label) {
        if (this.previewCheckbox != null) {
            return;
        }
        this.previewLabel = label;
        this.pfr = pfr;
        this.addCheckbox(this.previewLabel, false, true);
    }

    public void addCheckboxGroup(int rows, int columns, String[] labels, boolean[] defaultValues) {
        this.addCheckboxGroup(rows, columns, labels, defaultValues, null);
    }

    public void addCheckboxGroup(int rows, int columns, String[] labels, boolean[] defaultValues, String[] headings) {
        Panel panel = new Panel();
        int nRows = headings != null ? rows + 1 : rows;
        panel.setLayout(new GridLayout(nRows, columns, 6, 0));
        int startCBIndex = this.cbIndex;
        if (this.checkbox == null) {
            this.checkbox = new Vector(12);
        }
        if (headings != null) {
            Font font = new Font("SansSerif", 1, 12);
            for (int i = 0; i < columns; ++i) {
                if (i > headings.length - 1 || headings[i] == null) {
                    panel.add(new Label(""));
                    continue;
                }
                Label label = new Label(headings[i]);
                label.setFont(font);
                panel.add(label);
            }
        }
        int i1 = 0;
        int[] index = new int[labels.length];
        for (int row = 0; row < rows; ++row) {
            int i2;
            for (int col = 0; col < columns && (i2 = col * rows + row) < labels.length; ++col) {
                index[i1] = i2;
                String label = labels[i1];
                if (label == null || label.length() == 0) {
                    Label lbl = new Label("");
                    panel.add(lbl);
                    ++i1;
                    continue;
                }
                if (label.indexOf(95) != -1) {
                    label = label.replace('_', ' ');
                }
                Checkbox cb = new Checkbox(label);
                this.checkbox.addElement(cb);
                cb.setState(defaultValues[i1]);
                cb.addItemListener(this);
                if (Recorder.record || this.macro) {
                    this.saveLabel(cb, labels[i1]);
                }
                if (IJ.isLinux()) {
                    Panel panel2 = new Panel();
                    panel2.setLayout(new BorderLayout());
                    panel2.add("West", cb);
                    panel.add(panel2);
                } else {
                    panel.add(cb);
                }
                ++i1;
            }
        }
        this.c.gridx = 0;
        this.c.gridy = this.y++;
        this.c.gridwidth = 2;
        this.c.anchor = 17;
        this.c.insets = this.getInsets(10, 0, 0, 0);
        this.grid.setConstraints(panel, this.c);
        this.add(panel);
    }

    public void addRadioButtonGroup(String label, String[] items, int rows, int columns, String defaultItem) {
        Panel panel = new Panel();
        int n = items.length;
        panel.setLayout(new GridLayout(rows, columns, 0, 0));
        CheckboxGroup cg = new CheckboxGroup();
        for (int i = 0; i < n; ++i) {
            Checkbox cb = new Checkbox(items[i], cg, items[i].equals(defaultItem));
            cb.addItemListener(this);
            panel.add(cb);
        }
        if (this.radioButtonGroups == null) {
            this.radioButtonGroups = new Vector();
        }
        this.radioButtonGroups.addElement(cg);
        Insets insets = this.getInsets(5, 10, 0, 0);
        if (label == null || label.equals("")) {
            label = "rbg" + this.radioButtonGroups.size();
            insets.top += 5;
        } else {
            this.setInsets(10, insets.left, 0);
            this.addMessage(label);
            insets.top = 2;
            insets.left += 10;
        }
        this.c.gridx = 0;
        this.c.gridy = this.y;
        this.c.gridwidth = 2;
        this.c.anchor = 17;
        this.c.insets = new Insets(insets.top, insets.left, 0, 0);
        this.grid.setConstraints(panel, this.c);
        this.add(panel);
        if (Recorder.record || this.macro) {
            this.saveLabel(cg, label);
        }
        ++this.y;
    }

    public void addChoice(String label, String[] items, String defaultItem) {
        String label2 = label;
        if (label2.indexOf(95) != -1) {
            label2 = label2.replace('_', ' ');
        }
        Label theLabel = this.makeLabel(label2);
        this.c.gridx = 0;
        this.c.gridy = this.y;
        this.c.anchor = 13;
        this.c.gridwidth = 1;
        if (this.choice == null) {
            this.choice = new Vector(4);
            this.c.insets = this.getInsets(5, 0, 5, 0);
        } else {
            this.c.insets = this.getInsets(0, 0, 5, 0);
        }
        this.grid.setConstraints(theLabel, this.c);
        this.add(theLabel);
        Choice thisChoice = new Choice();
        thisChoice.addKeyListener(this);
        thisChoice.addItemListener(this);
        for (int i = 0; i < items.length; ++i) {
            thisChoice.addItem(items[i]);
        }
        if (defaultItem != null) {
            thisChoice.select(defaultItem);
        } else {
            thisChoice.select(0);
        }
        this.c.gridx = 1;
        this.c.gridy = this.y;
        this.c.anchor = 17;
        this.grid.setConstraints(thisChoice, this.c);
        this.add(thisChoice);
        this.choice.addElement(thisChoice);
        if (Recorder.record || this.macro) {
            this.saveLabel(thisChoice, label);
        }
        ++this.y;
    }

    public void addMessage(String text) {
        this.addMessage(text, null, null);
    }

    public void addMessage(String text, Font font) {
        this.addMessage(text, font, null);
    }

    public void addMessage(String text, Font font, Color color) {
        this.theLabel = null;
        this.theLabel = text.indexOf(10) >= 0 ? new MultiLineLabel(text) : new Label(text);
        this.c.gridx = 0;
        this.c.gridy = this.y;
        this.c.gridwidth = 2;
        this.c.anchor = 17;
        this.c.insets = this.getInsets(text.equals("") ? 0 : 10, 20, 0, 0);
        this.c.fill = 2;
        this.grid.setConstraints(this.theLabel, this.c);
        if (font != null) {
            this.theLabel.setFont(font);
        }
        if (color != null) {
            this.theLabel.setForeground(color);
        }
        this.add(this.theLabel);
        this.c.fill = 0;
        ++this.y;
    }

    public void addTextAreas(String text1, String text2, int rows, int columns) {
        if (this.textArea1 != null) {
            return;
        }
        Panel panel = new Panel();
        this.textArea1 = new TextArea(text1, rows, columns, 3);
        if (IJ.isLinux()) {
            this.textArea1.setBackground(Color.white);
        }
        this.textArea1.addTextListener(this);
        panel.add(this.textArea1);
        if (text2 != null) {
            this.textArea2 = new TextArea(text2, rows, columns, 3);
            if (IJ.isLinux()) {
                this.textArea2.setBackground(Color.white);
            }
            panel.add(this.textArea2);
        }
        this.c.gridx = 0;
        this.c.gridy = this.y++;
        this.c.gridwidth = 2;
        this.c.anchor = 17;
        this.c.insets = this.getInsets(15, 20, 0, 0);
        this.grid.setConstraints(panel, this.c);
        this.add(panel);
    }

    public void addSlider(String label, double minValue, double maxValue, double defaultValue) {
        String label2;
        int columns = 4;
        int digits = 0;
        double scale = 1.0;
        if (maxValue - minValue <= 5.0 && (minValue != (double)((int)minValue) || maxValue != (double)((int)maxValue) || defaultValue != (double)((int)defaultValue))) {
            scale = 20.0;
            minValue *= scale;
            maxValue *= scale;
            defaultValue *= scale;
            digits = 2;
        }
        if ((label2 = label).indexOf(95) != -1) {
            label2 = label2.replace('_', ' ');
        }
        Label theLabel = this.makeLabel(label2);
        this.c.gridx = 0;
        this.c.gridy = this.y;
        this.c.anchor = 13;
        this.c.gridwidth = 1;
        this.c.insets = new Insets(0, 0, 3, 0);
        this.grid.setConstraints(theLabel, this.c);
        this.add(theLabel);
        if (this.slider == null) {
            this.slider = new Vector(5);
            this.sliderIndexes = new int[25];
            this.sliderScales = new double[25];
        }
        Scrollbar s = new Scrollbar(0, (int)defaultValue, 1, (int)minValue, (int)maxValue + 1);
        GUI.fix(s);
        this.slider.addElement(s);
        s.addAdjustmentListener(this);
        s.setUnitIncrement(1);
        if (this.numberField == null) {
            this.numberField = new Vector(5);
            this.defaultValues = new Vector(5);
            this.defaultText = new Vector(5);
        }
        if (IJ.isWindows()) {
            columns -= 2;
        }
        if (columns < 1) {
            columns = 1;
        }
        TextField tf = new TextField(IJ.d2s(defaultValue / scale, digits), columns);
        if (IJ.isLinux()) {
            tf.setBackground(Color.white);
        }
        tf.addActionListener(this);
        tf.addTextListener(this);
        tf.addFocusListener(this);
        tf.addKeyListener(this);
        this.numberField.addElement(tf);
        this.sliderIndexes[this.slider.size() - 1] = this.numberField.size() - 1;
        this.sliderScales[this.slider.size() - 1] = scale;
        this.defaultValues.addElement(new Double(defaultValue / scale));
        this.defaultText.addElement(tf.getText());
        tf.setEditable(true);
        this.firstSlider = false;
        Panel panel = new Panel();
        GridBagLayout pgrid = new GridBagLayout();
        GridBagConstraints pc = new GridBagConstraints();
        panel.setLayout(pgrid);
        pc.gridx = 0;
        pc.gridy = 0;
        pc.gridwidth = 1;
        pc.ipadx = 85;
        pc.anchor = 17;
        pgrid.setConstraints(s, pc);
        panel.add(s);
        pc.ipadx = 0;
        pc.gridx = 1;
        pc.insets = new Insets(5, 5, 0, 0);
        pc.anchor = 13;
        pgrid.setConstraints(tf, pc);
        panel.add(tf);
        this.grid.setConstraints(panel, this.c);
        this.c.gridx = 1;
        this.c.gridy = this.y++;
        this.c.gridwidth = 1;
        this.c.anchor = 17;
        this.c.insets = new Insets(0, 0, 0, 0);
        this.grid.setConstraints(panel, this.c);
        this.add(panel);
        if (Recorder.record || this.macro) {
            this.saveLabel(tf, label);
        }
    }

    public void addPanel(Panel panel) {
        this.addPanel(panel, 17, new Insets(5, 0, 0, 0));
    }

    public void addPanel(Panel panel, int constraints, Insets insets) {
        this.c.gridx = 0;
        this.c.gridy = this.y++;
        this.c.gridwidth = 2;
        this.c.anchor = constraints;
        this.c.insets = insets;
        this.grid.setConstraints(panel, this.c);
        this.add(panel);
    }

    public void setInsets(int top, int left, int bottom) {
        this.topInset = top;
        this.leftInset = left;
        this.bottomInset = bottom;
        this.customInsets = true;
    }

    public void setOKLabel(String label) {
        this.okLabel = label;
    }

    public void setCancelLabel(String label) {
        this.cancelLabel = label;
    }

    public void setHelpLabel(String label) {
        this.helpLabel = label;
    }

    public void setSmartRecording(boolean smartRecording) {
        this.smartRecording = smartRecording;
    }

    public void enableYesNoCancel() {
        this.enableYesNoCancel(" Yes ", " No ");
    }

    public void enableYesNoCancel(String yesLabel, String noLabel) {
        this.yesLabel = yesLabel;
        this.noLabel = noLabel;
        this.yesNoCancel = true;
    }

    public void hideCancelButton() {
        this.hideCancelButton = true;
    }

    Insets getInsets(int top, int left, int bottom, int right) {
        if (this.customInsets) {
            this.customInsets = false;
            return new Insets(this.topInset, this.leftInset, this.bottomInset, 0);
        }
        return new Insets(top, left, bottom, right);
    }

    public void addDialogListener(DialogListener dl) {
        if (this.dialogListeners == null) {
            this.dialogListeners = new Vector();
        }
        this.dialogListeners.addElement(dl);
        if (IJ.debugMode) {
            IJ.log("GenericDialog: Listener added: " + dl);
        }
    }

    public boolean wasCanceled() {
        if (this.wasCanceled) {
            Macro.abort();
        }
        return this.wasCanceled;
    }

    public boolean wasOKed() {
        return this.wasOKed || this.macro;
    }

    public double getNextNumber() {
        double value;
        if (this.numberField == null) {
            return -1.0;
        }
        TextField tf = (TextField)this.numberField.elementAt(this.nfIndex);
        String theText = tf.getText();
        String label = null;
        if (this.macro) {
            label = (String)this.labels.get(tf);
            theText = Macro.getValue(this.macroOptions, label, theText);
        }
        String originalText = (String)this.defaultText.elementAt(this.nfIndex);
        double defaultValue = (Double)this.defaultValues.elementAt(this.nfIndex);
        boolean skipRecording = false;
        if (theText.equals(originalText)) {
            value = defaultValue;
            if (this.smartRecording) {
                skipRecording = true;
            }
        } else {
            Double d = this.getValue(theText);
            if (d != null) {
                value = d;
            } else {
                Interpreter interp;
                if (theText.startsWith("&")) {
                    theText = theText.substring(1);
                }
                double d2 = value = (interp = Interpreter.getInstance()) != null ? interp.getVariable2(theText) : Double.NaN;
                if (Double.isNaN(value)) {
                    this.invalidNumber = true;
                    this.errorMessage = "\"" + theText + "\" is an invalid number";
                    value = Double.NaN;
                    if (this.macro) {
                        IJ.error("Macro Error", "Numeric value expected in run() function\n \n   Dialog box title: \"" + this.getTitle() + "\"\n" + "   Key: \"" + label.toLowerCase(Locale.US) + "\"\n" + "   Value or variable name: \"" + theText + "\"");
                    }
                }
            }
        }
        if (this.recorderOn && !skipRecording) {
            this.recordOption(tf, this.trim(theText));
        }
        ++this.nfIndex;
        return value;
    }

    private String trim(String value) {
        if (value.endsWith(".0")) {
            value = value.substring(0, value.length() - 2);
        }
        if (value.endsWith(".00")) {
            value = value.substring(0, value.length() - 3);
        }
        return value;
    }

    private void recordOption(Object component, String value) {
        String label = (String)this.labels.get(component);
        if (value.equals("")) {
            value = "[]";
        }
        Recorder.recordOption(label, value);
    }

    private void recordCheckboxOption(Checkbox cb) {
        String label = (String)this.labels.get(cb);
        if (label != null) {
            if (cb.getState()) {
                Recorder.recordOption(label);
            } else if (Recorder.getCommandOptions() == null) {
                Recorder.recordOption(" ");
            }
        }
    }

    protected Double getValue(String text) {
        Double d;
        try {
            d = new Double(text);
        }
        catch (NumberFormatException e) {
            d = null;
        }
        return d;
    }

    public double parseDouble(String s) {
        if (s == null) {
            return Double.NaN;
        }
        double value = Tools.parseDouble(s);
        if (Double.isNaN(value)) {
            Interpreter interp;
            if (s.startsWith("&")) {
                s = s.substring(1);
            }
            value = (interp = Interpreter.getInstance()) != null ? interp.getVariable2(s) : Double.NaN;
        }
        return value;
    }

    public boolean invalidNumber() {
        boolean wasInvalid = this.invalidNumber;
        this.invalidNumber = false;
        return wasInvalid;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getNextString() {
        String label;
        if (this.stringField == null) {
            return "";
        }
        TextField tf = (TextField)this.stringField.elementAt(this.sfIndex);
        String theText = tf.getText();
        if (this.macro && (theText = Macro.getValue(this.macroOptions, label = (String)this.labels.get(tf), theText)) != null && (theText.startsWith("&") || label.toLowerCase(Locale.US).startsWith(theText))) {
            Interpreter interp;
            String s;
            if (theText.startsWith("&")) {
                theText = theText.substring(1);
            }
            String string = s = (interp = Interpreter.getInstance()) != null ? interp.getVariableAsString(theText) : null;
            if (s != null) {
                theText = s;
            }
        }
        if (this.recorderOn) {
            String s = theText;
            if (s != null && s.length() >= 3 && Character.isLetter(s.charAt(0)) && s.charAt(1) == ':' && s.charAt(2) == '\\') {
                s = s.replaceAll("\\\\", "\\\\\\\\");
            }
            if (!this.smartRecording || !s.equals((String)this.defaultStrings.elementAt(this.sfIndex))) {
                this.recordOption(tf, s);
            }
        }
        ++this.sfIndex;
        return theText;
    }

    public boolean getNextBoolean() {
        if (this.checkbox == null) {
            return false;
        }
        Checkbox cb = (Checkbox)this.checkbox.elementAt(this.cbIndex);
        if (this.recorderOn) {
            this.recordCheckboxOption(cb);
        }
        boolean state = cb.getState();
        if (this.macro) {
            String label = (String)this.labels.get(cb);
            String key = Macro.trimKey(label);
            state = this.isMatch(this.macroOptions, key + " ");
        }
        ++this.cbIndex;
        return state;
    }

    boolean isMatch(String s1, String s2) {
        if (s1.startsWith(s2)) {
            return true;
        }
        s2 = " " + s2;
        int len1 = s1.length();
        int len2 = s2.length();
        boolean inLiteral = false;
        for (int i = 0; i < len1 - len2 + 1; ++i) {
            char c = s1.charAt(i);
            if (inLiteral && c == ']') {
                inLiteral = false;
            } else if (c == '[') {
                inLiteral = true;
            }
            if (c != s2.charAt(0) || inLiteral || i > 1 && s1.charAt(i - 1) == '=') continue;
            boolean match = true;
            for (int j = 0; j < len2; ++j) {
                if (s2.charAt(j) == s1.charAt(i + j)) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return true;
        }
        return false;
    }

    public String getNextChoice() {
        String label;
        if (this.choice == null) {
            return "";
        }
        Choice thisChoice = (Choice)this.choice.elementAt(this.choiceIndex);
        String item = thisChoice.getSelectedItem();
        if (this.macro && (item = Macro.getValue(this.macroOptions, label = (String)this.labels.get(thisChoice), item)) != null && item.startsWith("&")) {
            item = this.getChoiceVariable(item);
        }
        if (this.recorderOn) {
            this.recordOption(thisChoice, item);
        }
        ++this.choiceIndex;
        return item;
    }

    public int getNextChoiceIndex() {
        String item;
        if (this.choice == null) {
            return -1;
        }
        Choice thisChoice = (Choice)this.choice.elementAt(this.choiceIndex);
        int index = thisChoice.getSelectedIndex();
        if (this.macro) {
            String label = (String)this.labels.get(thisChoice);
            String oldItem = thisChoice.getSelectedItem();
            int oldIndex = thisChoice.getSelectedIndex();
            String item2 = Macro.getValue(this.macroOptions, label, oldItem);
            if (item2 != null && item2.startsWith("&")) {
                item2 = this.getChoiceVariable(item2);
            }
            thisChoice.select(item2);
            index = thisChoice.getSelectedIndex();
            if (index == oldIndex && !item2.equals(oldItem)) {
                String s;
                Interpreter interp = Interpreter.getInstance();
                String string = s = interp != null ? interp.getStringVariable(item2) : null;
                if (s == null) {
                    IJ.error(this.getTitle(), "\"" + item2 + "\" is not a valid choice for \"" + label + "\"");
                } else {
                    item2 = s;
                }
            }
        }
        if (!(!this.recorderOn || this.smartRecording && index == 0 || (item = thisChoice.getSelectedItem()).equals("*None*") && this.getTitle().equals("Merge Channels"))) {
            this.recordOption(thisChoice, thisChoice.getSelectedItem());
        }
        ++this.choiceIndex;
        return index;
    }

    public String getNextRadioButton() {
        if (this.radioButtonGroups == null) {
            return null;
        }
        CheckboxGroup cg = (CheckboxGroup)this.radioButtonGroups.elementAt(this.radioButtonIndex);
        ++this.radioButtonIndex;
        Checkbox checkbox = cg.getSelectedCheckbox();
        String item = "null";
        if (checkbox != null) {
            item = checkbox.getLabel();
        }
        if (this.macro) {
            String label = (String)this.labels.get(cg);
            item = Macro.getValue(this.macroOptions, label, item);
        }
        if (this.recorderOn) {
            this.recordOption(cg, item);
        }
        return item;
    }

    private String getChoiceVariable(String item) {
        String s;
        item = item.substring(1);
        Interpreter interp = Interpreter.getInstance();
        String string = s = interp != null ? interp.getStringVariable(item) : null;
        if (s == null) {
            double value;
            double d = value = interp != null ? interp.getVariable2(item) : Double.NaN;
            if (!Double.isNaN(value)) {
                s = (double)((int)value) == value ? "" + (int)value : "" + value;
            }
        }
        if (s != null) {
            item = s;
        }
        return item;
    }

    public String getNextText() {
        String text;
        if (this.textAreaIndex == 0 && this.textArea1 != null) {
            text = this.textArea1.getText();
            ++this.textAreaIndex;
            if (this.macro) {
                text = Macro.getValue(this.macroOptions, "text1", text);
            }
            if (this.recorderOn) {
                String text2 = text;
                String cmd = Recorder.getCommand();
                if (cmd != null && cmd.equals("Convolve...")) {
                    text2 = text.replaceAll("\n", "\\\\n");
                    if (!text.endsWith("\n")) {
                        text2 = text2 + "\\n";
                    }
                } else {
                    text2 = text.replace('\n', ' ');
                }
                Recorder.recordOption("text1", text2);
            }
        } else if (this.textAreaIndex == 1 && this.textArea2 != null) {
            this.textArea2.selectAll();
            text = this.textArea2.getText();
            ++this.textAreaIndex;
            if (this.macro) {
                text = Macro.getValue(this.macroOptions, "text2", text);
            }
            if (this.recorderOn) {
                Recorder.recordOption("text2", text.replace('\n', ' '));
            }
        } else {
            text = null;
        }
        return text;
    }

    public void showDialog() {
        if (this.macro) {
            this.dispose();
            this.recorderOn = Recorder.record && Recorder.recordInMacros;
        } else {
            boolean addHelp;
            if (this.pfr != null) {
                this.pfr.setDialog(this);
            }
            Panel buttons = new Panel();
            buttons.setLayout(new FlowLayout(1, 5, 0));
            this.cancel = new Button(this.cancelLabel);
            this.cancel.addActionListener(this);
            this.cancel.addKeyListener(this);
            if (this.yesNoCancel) {
                this.okLabel = this.yesLabel;
                this.no = new Button(this.noLabel);
                this.no.addActionListener(this);
                this.no.addKeyListener(this);
            }
            this.okay = new Button(this.okLabel);
            this.okay.addActionListener(this);
            this.okay.addKeyListener(this);
            boolean bl = addHelp = this.helpURL != null;
            if (addHelp) {
                this.help = new Button(this.helpLabel);
                this.help.addActionListener(this);
                this.help.addKeyListener(this);
            }
            if (IJ.isMacintosh()) {
                if (addHelp) {
                    buttons.add(this.help);
                }
                if (this.yesNoCancel) {
                    buttons.add(this.no);
                }
                if (!this.hideCancelButton) {
                    buttons.add(this.cancel);
                }
                buttons.add(this.okay);
            } else {
                buttons.add(this.okay);
                if (this.yesNoCancel) {
                    buttons.add(this.no);
                }
                if (!this.hideCancelButton) {
                    buttons.add(this.cancel);
                }
                if (addHelp) {
                    buttons.add(this.help);
                }
            }
            this.c.gridx = 0;
            this.c.gridy = this.y;
            this.c.anchor = 13;
            this.c.gridwidth = 2;
            this.c.insets = new Insets(15, 0, 0, 0);
            this.grid.setConstraints(buttons, this.c);
            this.add(buttons);
            if (IJ.isMacintosh()) {
                this.setResizable(false);
            }
            this.pack();
            this.setup();
            if (this.centerDialog) {
                GUI.center(this);
            }
            this.setVisible(true);
            this.recorderOn = Recorder.record;
            IJ.wait(50);
        }
        if (!this.wasCanceled && this.dialogListeners != null && this.dialogListeners.size() > 0) {
            this.resetCounters();
            ((DialogListener)this.dialogListeners.elementAt(0)).dialogItemChanged(this, null);
            this.recorderOn = false;
        }
        this.resetCounters();
    }

    private void resetCounters() {
        this.nfIndex = 0;
        this.sfIndex = 0;
        this.cbIndex = 0;
        this.choiceIndex = 0;
        this.textAreaIndex = 0;
        this.radioButtonIndex = 0;
        this.invalidNumber = false;
    }

    public Vector getNumericFields() {
        return this.numberField;
    }

    public Vector getStringFields() {
        return this.stringField;
    }

    public Vector getCheckboxes() {
        return this.checkbox;
    }

    public Vector getChoices() {
        return this.choice;
    }

    public Vector getSliders() {
        return this.slider;
    }

    public Vector getRadioButtonGroups() {
        return this.radioButtonGroups;
    }

    public TextArea getTextArea1() {
        return this.textArea1;
    }

    public TextArea getTextArea2() {
        return this.textArea2;
    }

    public Component getMessage() {
        return this.theLabel;
    }

    public Checkbox getPreviewCheckbox() {
        return this.previewCheckbox;
    }

    public boolean isPreviewActive() {
        return this.previewCheckbox != null && this.previewCheckbox.getState();
    }

    public Button[] getButtons() {
        Button[] buttons = new Button[]{this.okay, this.cancel, this.no};
        return buttons;
    }

    public void previewRunning(boolean isRunning) {
        if (this.previewCheckbox != null) {
            this.previewCheckbox.setLabel(isRunning ? previewRunning : this.previewLabel);
            if (IJ.isMacOSX()) {
                this.repaint();
            }
        }
    }

    public void centerDialog(boolean b) {
        this.centerDialog = b;
    }

    public void setLocation(int x, int y) {
        super.setLocation(x, y);
        this.centerDialog = false;
    }

    protected void setup() {
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.okay || source == this.cancel | source == this.no) {
            this.wasCanceled = source == this.cancel;
            this.wasOKed = source == this.okay;
            this.dispose();
        } else if (source == this.help) {
            if (this.hideCancelButton) {
                if (this.helpURL != null && this.helpURL.equals("")) {
                    this.notifyListeners(e);
                    return;
                }
                this.wasOKed = true;
                this.dispose();
            }
            this.showHelp();
        } else {
            this.notifyListeners(e);
        }
    }

    public void textValueChanged(TextEvent e) {
        this.notifyListeners(e);
        if (this.slider == null) {
            return;
        }
        Object source = e.getSource();
        for (int i = 0; i < this.slider.size(); ++i) {
            TextField tf;
            double value;
            int index = this.sliderIndexes[i];
            if (source != this.numberField.elementAt(index) || Double.isNaN(value = Tools.parseDouble((tf = (TextField)this.numberField.elementAt(index)).getText()))) continue;
            Scrollbar sb = (Scrollbar)this.slider.elementAt(i);
            sb.setValue((int)(value * this.sliderScales[i]));
        }
    }

    public void itemStateChanged(ItemEvent e) {
        this.notifyListeners(e);
    }

    public void focusGained(FocusEvent e) {
        Component c = e.getComponent();
        if (c instanceof TextField) {
            ((TextField)c).selectAll();
        }
    }

    public void focusLost(FocusEvent e) {
        Component c = e.getComponent();
        if (c instanceof TextField) {
            ((TextField)c).select(0, 0);
        }
    }

    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        IJ.setKeyDown(keyCode);
        if (keyCode == 10 && this.textArea1 == null) {
            this.wasOKed = true;
            if (IJ.isMacOSX() && IJ.isJava15()) {
                this.accessTextFields();
            }
            this.dispose();
        } else if (keyCode == 27) {
            this.wasCanceled = true;
            this.dispose();
            IJ.resetEscape();
        } else if (keyCode == 87 && (e.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
            this.wasCanceled = true;
            this.dispose();
        }
    }

    void accessTextFields() {
        int i;
        if (this.stringField != null) {
            for (i = 0; i < this.stringField.size(); ++i) {
                ((TextField)this.stringField.elementAt(i)).getText();
            }
        }
        if (this.numberField != null) {
            for (i = 0; i < this.numberField.size(); ++i) {
                ((TextField)this.numberField.elementAt(i)).getText();
            }
        }
    }

    public void keyReleased(KeyEvent e) {
        boolean shift;
        int keyCode = e.getKeyCode();
        IJ.setKeyUp(keyCode);
        int flags = e.getModifiers();
        boolean control = (flags & 2) != 0;
        boolean meta = (flags & 4) != 0;
        boolean bl = shift = (flags & 1) != 0;
        if (keyCode == 71 && shift && (control || meta)) {
            new ScreenGrabber().run("");
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public Insets getInsets() {
        Insets i = super.getInsets();
        return new Insets(i.top + 10, i.left + 10, i.bottom + 10, i.right + 10);
    }

    public synchronized void adjustmentValueChanged(AdjustmentEvent e) {
        Object source = e.getSource();
        for (int i = 0; i < this.slider.size(); ++i) {
            if (source != this.slider.elementAt(i)) continue;
            Scrollbar sb = (Scrollbar)source;
            TextField tf = (TextField)this.numberField.elementAt(this.sliderIndexes[i]);
            int digits = this.sliderScales[i] == 1.0 ? 0 : 2;
            tf.setText("" + IJ.d2s((double)sb.getValue() / this.sliderScales[i], digits));
        }
    }

    private void notifyListeners(AWTEvent e) {
        boolean workaroundOSXbug;
        if (this.dialogListeners == null) {
            return;
        }
        boolean everythingOk = true;
        for (int i = 0; everythingOk && i < this.dialogListeners.size(); ++i) {
            try {
                this.resetCounters();
                if (((DialogListener)this.dialogListeners.elementAt(i)).dialogItemChanged(this, e)) continue;
                everythingOk = false;
                continue;
            }
            catch (Exception err) {
                IJ.beep();
                IJ.log("ERROR: " + err + "\nin DialogListener of " + this.dialogListeners.elementAt(i) + "\nat " + err.getStackTrace()[0] + "\nfrom " + err.getStackTrace()[1]);
            }
        }
        boolean bl = workaroundOSXbug = IJ.isMacOSX() && !this.okay.isEnabled() && everythingOk;
        if (this.previewCheckbox != null) {
            this.previewCheckbox.setEnabled(everythingOk);
        }
        this.okay.setEnabled(everythingOk);
        if (workaroundOSXbug) {
            this.repaint();
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.firstPaint) {
            if (this.numberField != null && IJ.isMacOSX()) {
                TextField tf = (TextField)this.numberField.elementAt(0);
                tf.setEditable(false);
                tf.setEditable(true);
            }
            if (this.numberField == null && this.stringField == null) {
                this.okay.requestFocus();
            }
            this.firstPaint = false;
        }
    }

    public void windowClosing(WindowEvent e) {
        this.wasCanceled = true;
        this.dispose();
    }

    public void addHelp(String url) {
        this.helpURL = url;
    }

    void showHelp() {
        if (this.helpURL.startsWith("<html>")) {
            new HTMLDialog((Dialog)this, "", this.helpURL);
        } else {
            String macro = "run('URL...', 'url=" + this.helpURL + "');";
            new MacroRunner(macro);
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }
}

