/*
 * Decompiled with CFR 0.152.
 */
package ij.macro;

import ij.IJ;
import ij.ImagePlus;
import ij.Menus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.macro.Functions;
import ij.macro.MacroConstants;
import ij.macro.MacroException;
import ij.macro.Program;
import ij.macro.ReturnException;
import ij.macro.Symbol;
import ij.macro.Tokenizer;
import ij.macro.Variable;
import ij.measure.ResultsTable;
import ij.plugin.frame.Editor;
import ij.plugin.frame.Recorder;
import ij.plugin.frame.RoiManager;
import ij.process.ColorProcessor;
import ij.text.TextPanel;
import ij.text.TextWindow;
import ij.util.Tools;
import java.awt.Frame;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Interpreter
implements MacroConstants {
    public static final int NONE = 0;
    public static final int STEP = 1;
    public static final int TRACE = 2;
    public static final int FAST_TRACE = 3;
    public static final int RUN = 4;
    public static final int RUN_TO_CARET = 5;
    static final int STACK_SIZE = 1000;
    static final int MAX_ARGS = 20;
    int pc;
    int token;
    int tokenAddress;
    double tokenValue;
    String tokenString;
    boolean looseSyntax = true;
    int lineNumber;
    boolean statusUpdated;
    boolean showingProgress;
    boolean keysSet;
    boolean checkingType;
    int prefixValue;
    Variable[] stack;
    int topOfStack = -1;
    int topOfGlobals = -1;
    int startOfLocals = 0;
    static Interpreter instance;
    static Interpreter previousInstance;
    public static boolean batchMode;
    static Vector imageTable;
    boolean done;
    Program pgm;
    Functions func;
    boolean inFunction;
    String macroName;
    String argument;
    String returnValue;
    boolean calledMacro;
    boolean batchMacro;
    double[] rgbWeights;
    boolean inPrint;
    static String additionalFunctions;
    Editor editor;
    int debugMode = 0;
    boolean showDebugFunctions;
    static boolean showVariables;
    boolean wasError;
    ImagePlus batchMacroImage;
    boolean inLoop;
    static boolean tempShowMode;
    static TextWindow arrayWindow;
    int inspectStkIndex = -1;
    int inspectSymIndex = -1;
    ReturnException returnException;
    private static String[] prevVars;

    public void run(String macro) {
        if (additionalFunctions != null) {
            macro = !macro.endsWith("\n") && !additionalFunctions.startsWith("\n") ? macro + "\n" + additionalFunctions : macro + additionalFunctions;
        }
        Tokenizer tok = new Tokenizer();
        Program pgm = tok.tokenize(macro);
        if (pgm.hasVars && pgm.hasFunctions) {
            this.saveGlobals2(pgm);
        }
        this.run(pgm);
    }

    public String run(String macro, String arg) {
        this.argument = arg;
        this.calledMacro = true;
        if (IJ.getInstance() == null) {
            Interpreter.setBatchMode(true);
        }
        Interpreter saveInstance = instance;
        this.run(macro);
        instance = saveInstance;
        return this.returnValue;
    }

    public void run(Program pgm) {
        this.pgm = pgm;
        this.pc = -1;
        instance = this;
        if (!this.calledMacro) {
            batchMode = false;
            imageTable = null;
        }
        this.pushGlobals();
        if (this.func == null) {
            this.func = new Functions(this, pgm);
        }
        this.func.plot = null;
        this.doStatements();
        this.finishUp();
    }

    public void run(int location) {
        this.topOfStack = this.topOfGlobals;
        this.done = false;
        this.pc = location - 1;
        this.doStatements();
    }

    public void runMacro(Program pgm, int macroLoc, String macroName) {
        this.calledMacro = true;
        this.pgm = pgm;
        this.macroName = macroName;
        this.pc = macroLoc - 1;
        previousInstance = instance;
        instance = this;
        this.pushGlobals();
        if (this.func == null) {
            this.func = new Functions(this, pgm);
        }
        this.func.plot = null;
        if (macroLoc == 0) {
            this.doStatements();
        } else {
            this.doBlock();
        }
        this.finishUp();
        Recorder.recordInMacros = false;
    }

    public ImagePlus runBatchMacro(String macro, ImagePlus imp) {
        this.calledMacro = true;
        this.batchMacro = true;
        Interpreter.setBatchMode(true);
        Interpreter.addBatchModeImage(imp);
        this.batchMacroImage = null;
        this.run(macro);
        IJ.showStatus("");
        return this.batchMacroImage;
    }

    public void saveGlobals(Program pgm) {
        this.saveGlobals2(pgm);
    }

    void saveGlobals2(Program pgm) {
        this.pgm = pgm;
        this.pc = -1;
        instance = this;
        this.func = new Functions(this, pgm);
        block5: while (!this.done) {
            this.getToken();
            switch (this.token) {
                case 201: {
                    this.doVar();
                    continue block5;
                }
                case 200: {
                    this.skipMacro();
                    continue block5;
                }
                case 207: {
                    this.skipFunction();
                    continue block5;
                }
            }
        }
        instance = null;
        pgm.saveGlobals(this);
        this.pc = -1;
        this.topOfStack = -1;
        this.done = false;
    }

    final void getToken() {
        if (this.done) {
            return;
        }
        this.token = this.pgm.code[++this.pc];
        if (this.token <= 127) {
            return;
        }
        this.tokenAddress = this.token >> 12;
        this.token &= 0xFFF;
        Symbol sym = this.pgm.table[this.tokenAddress];
        this.tokenString = sym.str;
        this.tokenValue = sym.value;
        this.done = this.token == 128;
    }

    final int nextToken() {
        return this.pgm.code[this.pc + 1] & 0xFFF;
    }

    final int nextNextToken() {
        return this.pgm.code[this.pc + 2] & 0xFFF;
    }

    final void putTokenBack() {
        --this.pc;
        if (this.pc < 0) {
            this.pc = -1;
        }
        if (this.token == 128) {
            this.done = false;
        }
    }

    void doStatements() {
        while (!this.done) {
            this.doStatement();
        }
    }

    final void doStatement() {
        this.getToken();
        if (this.debugMode != 0 && this.editor != null && !this.done && this.token != 59 && this.token != 207) {
            this.editor.debug(this, this.debugMode);
        }
        switch (this.token) {
            case 201: {
                this.doVar();
                break;
            }
            case 134: {
                this.func.doFunction(this.pgm.table[this.tokenAddress].type);
                break;
            }
            case 138: {
                this.runUserFunction();
                break;
            }
            case 208: {
                this.doReturn();
                break;
            }
            case 213: {
                if (!this.inLoop) break;
                throw new MacroException(213);
            }
            case 214: {
                if (!this.inLoop) break;
                throw new MacroException(214);
            }
            case 129: {
                this.doAssignment();
                break;
            }
            case 202: {
                this.doIf();
                return;
            }
            case 203: {
                this.error("Else without if");
                return;
            }
            case 206: {
                this.doFor();
                return;
            }
            case 204: {
                this.doWhile();
                return;
            }
            case 205: {
                this.doDo();
                return;
            }
            case 200: {
                this.runFirstMacro();
                return;
            }
            case 207: {
                this.skipFunction();
                return;
            }
            case 59: {
                return;
            }
            case 123: {
                this.putTokenBack();
                this.doBlock();
                return;
            }
            case 40: 
            case 130: 
            case 133: 
            case 135: 
            case 136: {
                this.putTokenBack();
                this.inPrint = true;
                String s = this.getString();
                this.inPrint = false;
                if (s != null && s.length() > 0 && !s.equals("NaN") && !s.equals("[aborted]")) {
                    IJ.log(s);
                }
                return;
            }
            case 137: {
                this.func.getArrayFunction(this.pgm.table[this.tokenAddress].type);
                break;
            }
            case 128: {
                break;
            }
            default: {
                this.error("Statement cannot begin with '" + this.pgm.decodeToken(this.token, this.tokenAddress) + "'");
            }
        }
        if (!this.looseSyntax) {
            this.getToken();
            if (this.token != 59 && !this.done) {
                this.error("';' expected");
            }
        }
    }

    Variable runUserFunction() {
        boolean saveInFunction;
        Variable value;
        int savePC;
        int saveTOS;
        int saveStartOfLocals;
        block2: {
            int newPC = (int)this.tokenValue;
            saveStartOfLocals = this.startOfLocals;
            this.startOfLocals = this.topOfStack + 1;
            saveTOS = this.topOfStack;
            int nArgs = this.pushArgs();
            savePC = this.pc;
            value = null;
            this.pc = newPC;
            this.setupArgs(nArgs);
            saveInFunction = this.inFunction;
            this.inFunction = true;
            try {
                this.doBlock();
            }
            catch (ReturnException e) {
                value = new Variable(0, e.value, e.str, e.array);
                if (value.getArray() == null || e.arraySize == 0) break block2;
                value.setArraySize(e.arraySize);
            }
        }
        this.inFunction = saveInFunction;
        this.pc = savePC;
        this.trimStack(saveTOS, saveStartOfLocals);
        return value;
    }

    int pushArgs() {
        this.getLeftParen();
        int count = 0;
        Variable[] args = new Variable[20];
        if (this.nextToken() != 41) {
            do {
                int savePC;
                if (count == 20) {
                    this.error("Too many arguments");
                }
                int next = this.nextToken();
                int nextPlus = this.pgm.code[this.pc + 2] & 0xFF;
                if (next == 133 || next == 136) {
                    args[count] = new Variable(0, 0.0, this.getString());
                } else if (next == 138) {
                    savePC = this.pc;
                    this.getToken();
                    boolean simpleFunctionCall = this.isSimpleFunctionCall(false);
                    this.pc = savePC;
                    if (simpleFunctionCall) {
                        this.getToken();
                        Variable v2 = this.runUserFunction();
                        if (v2 == null) {
                            this.error("No return value");
                        }
                        args[count] = v2;
                    } else {
                        args[count] = new Variable(0, this.getExpression(), null);
                    }
                } else if (next == 129 && (nextPlus == 44 || nextPlus == 41)) {
                    double value = 0.0;
                    Variable[] array = null;
                    int arraySize = 0;
                    String str = null;
                    this.getToken();
                    Variable v = this.lookupVariable();
                    if (v != null) {
                        int type = v.getType();
                        if (type == 0) {
                            value = v.getValue();
                        } else if (type == 1) {
                            array = v.getArray();
                            arraySize = v.getArraySize();
                        } else {
                            str = v.getString();
                        }
                    }
                    args[count] = new Variable(0, value, str, array);
                    if (array != null) {
                        args[count].setArraySize(arraySize);
                    }
                } else if (next == 129 && nextPlus == 91) {
                    savePC = this.pc;
                    this.getToken();
                    Variable v = this.lookupVariable();
                    v = this.getArrayElement(v);
                    if (v.getString() != null) {
                        args[count] = new Variable(0, 0.0, v.getString(), null);
                    } else {
                        this.pc = savePC;
                        args[count] = new Variable(0, this.getExpression(), null);
                    }
                } else if (nextPlus == 43 && next == 129) {
                    savePC = this.pc;
                    this.getToken();
                    Variable v = this.lookupVariable();
                    boolean isString = v != null && v.getType() == 2;
                    this.pc = savePC;
                    args[count] = isString ? new Variable(0, 0.0, this.getString()) : new Variable(0, this.getExpression(), null);
                } else {
                    args[count] = new Variable(0, this.getExpression(), null);
                }
                ++count;
                this.getToken();
            } while (this.token == 44);
            this.putTokenBack();
        }
        int nArgs = count;
        while (count > 0) {
            this.push(args[--count], this);
        }
        this.getRightParen();
        return nArgs;
    }

    void setupArgs(int nArgs) {
        this.getLeftParen();
        int i = this.topOfStack;
        int count = nArgs;
        if (this.nextToken() != 41) {
            do {
                this.getToken();
                if (i >= 0) {
                    this.stack[i].symTabIndex = this.tokenAddress;
                }
                --i;
                --count;
                this.getToken();
            } while (this.token == 44);
            this.putTokenBack();
        }
        if (count != 0) {
            this.error(nArgs + " argument" + (nArgs == 1 ? "" : "s") + " expected");
        }
        this.getRightParen();
    }

    void doReturn() {
        double value = 0.0;
        String str = null;
        Variable[] array = null;
        int arraySize = 0;
        this.getToken();
        if (this.token != 59) {
            boolean isArrayFunction;
            boolean isString = this.token == 133 || this.token == 136;
            boolean bl = isArrayFunction = this.token == 137;
            if (this.token == 129) {
                Variable v = this.lookupLocalVariable(this.tokenAddress);
                if (v != null && this.nextToken() == 59) {
                    array = v.getArray();
                    if (array != null) {
                        arraySize = v.getArraySize();
                    }
                    isString = v.getString() != null;
                } else if (v != null && this.nextToken() == 43) {
                    isString = v.getType() == 2;
                }
            }
            this.putTokenBack();
            if (isString) {
                str = this.getString();
            } else if (isArrayFunction) {
                this.getToken();
                array = this.func.getArrayFunction(this.pgm.table[this.tokenAddress].type);
            } else if (array == null) {
                if ((this.pgm.code[this.pc + 2] & 0xFF) == 91 && this.nextToken() == 129) {
                    int savePC = this.pc;
                    this.getToken();
                    Variable v = this.lookupVariable();
                    v = this.getArrayElement(v);
                    this.pc = savePC;
                    if (v.getString() != null) {
                        str = this.getString();
                    } else {
                        value = this.getExpression();
                    }
                } else {
                    value = this.getExpression();
                }
            }
        }
        if (this.inFunction) {
            if (this.returnException == null) {
                this.returnException = new ReturnException();
            }
            this.returnException.value = value;
            this.returnException.str = str;
            this.returnException.array = array;
            this.returnException.arraySize = arraySize;
            throw this.returnException;
        }
        this.finishUp();
        if (value != 0.0 || array != null) {
            this.error("Macros can only return strings");
        }
        this.returnValue = str;
        this.done = true;
    }

    void doFor() {
        boolean saveLooseSyntax = this.looseSyntax;
        this.looseSyntax = false;
        this.inLoop = true;
        this.getToken();
        if (this.token != 40) {
            this.error("'(' expected");
        }
        this.getToken();
        if (this.token != 201) {
            this.putTokenBack();
        }
        do {
            if (this.nextToken() != 59) {
                this.getAssignmentExpression();
            }
            this.getToken();
        } while (this.token == 44);
        if (this.token != 59) {
            this.error("';' expected");
        }
        int condPC = this.pc;
        int startPC = 0;
        double cond = 1.0;
        while (true) {
            int incPC;
            block18: {
                if (this.pgm.code[this.pc + 1] != 59) {
                    cond = this.getLogicalExpression();
                }
                if (startPC == 0) {
                    this.checkBoolean(cond);
                }
                this.getToken();
                if (this.token != 59) {
                    this.error("';' expected");
                }
                incPC = this.pc;
                if (startPC != 0) {
                    this.pc = startPC;
                } else {
                    while (this.token != 41) {
                        this.getToken();
                        if (this.token != 123 && this.token != 59 && this.token != 40 && !this.done) continue;
                        this.error("')' expected");
                    }
                }
                startPC = this.pc;
                if (cond == 1.0) {
                    try {
                        this.doStatement();
                        break block18;
                    }
                    catch (MacroException e) {
                        if (e.getType() == 213) {
                            this.pc = startPC;
                            this.skipStatement();
                            break;
                        }
                        break block18;
                    }
                }
                this.skipStatement();
                break;
            }
            this.pc = incPC;
            do {
                if (this.nextToken() != 41) {
                    this.getAssignmentExpression();
                }
                this.getToken();
            } while (this.token == 44);
            this.pc = condPC;
        }
        this.looseSyntax = saveLooseSyntax;
        this.inLoop = false;
    }

    void doWhile() {
        boolean isTrue;
        this.looseSyntax = false;
        this.inLoop = true;
        int savePC = this.pc;
        do {
            this.pc = savePC;
            isTrue = this.getBoolean();
            if (isTrue) {
                try {
                    this.doStatement();
                    continue;
                }
                catch (MacroException e) {
                    if (e.getType() != 213) continue;
                    this.pc = savePC;
                    this.getBoolean();
                    this.skipStatement();
                    break;
                }
            }
            this.skipStatement();
        } while (isTrue && !this.done);
        this.inLoop = false;
    }

    void doDo() {
        boolean isTrue;
        this.looseSyntax = false;
        int savePC = this.pc;
        do {
            this.doStatement();
            this.getToken();
            if (this.token != 204) {
                this.error("'while' expected");
            }
            if (!(isTrue = this.getBoolean())) continue;
            this.pc = savePC;
        } while (isTrue && !this.done);
    }

    final void doBlock() {
        this.getToken();
        if (this.token != 123) {
            this.error("'{' expected");
        }
        while (!this.done) {
            this.getToken();
            if (this.token == 125) break;
            this.putTokenBack();
            this.doStatement();
        }
        if (this.token != 125) {
            this.error("'}' expected");
        }
    }

    final void skipStatement() {
        this.getToken();
        switch (this.token) {
            case 1: 
            case 40: 
            case 129: 
            case 134: 
            case 135: 
            case 136: 
            case 138: 
            case 201: 
            case 208: {
                this.skipSimpleStatement();
                break;
            }
            case 202: {
                this.skipParens();
                this.skipStatement();
                this.getToken();
                if (this.token == 203) {
                    this.skipStatement();
                    break;
                }
                this.putTokenBack();
                break;
            }
            case 206: {
                this.skipParens();
                this.skipStatement();
                break;
            }
            case 204: {
                this.skipParens();
                this.skipStatement();
                break;
            }
            case 205: {
                this.skipStatement();
                this.getToken();
                this.skipParens();
                break;
            }
            case 59: 
            case 213: 
            case 214: {
                break;
            }
            case 123: {
                this.putTokenBack();
                this.skipBlock();
                break;
            }
            default: {
                this.error("Skipped statement cannot begin with '" + this.pgm.decodeToken(this.token, this.tokenAddress) + "'");
            }
        }
    }

    final void skipBlock() {
        int count = 0;
        do {
            this.getToken();
            if (this.token == 123) {
                ++count;
                continue;
            }
            if (this.token == 125) {
                --count;
                continue;
            }
            if (!this.done) continue;
            this.error("'}' expected");
            return;
        } while (count > 0);
    }

    final void skipParens() {
        int count = 0;
        do {
            this.getToken();
            if (this.token == 40) {
                ++count;
                continue;
            }
            if (this.token == 41) {
                --count;
                continue;
            }
            if (!this.done) continue;
            this.error("')' expected");
            return;
        } while (count > 0);
    }

    final void skipSimpleStatement() {
        boolean finished = this.done;
        this.getToken();
        while (!finished && !this.done) {
            if (this.token == 59) {
                finished = true;
                continue;
            }
            if (this.token == 203 || this.token == 134 && this.pgm.code[this.pc - 1] != 46) {
                this.error("';' expected");
                continue;
            }
            this.getToken();
        }
    }

    void skipFunction() {
        this.getToken();
        this.skipParens();
        this.skipBlock();
    }

    void runFirstMacro() {
        this.getToken();
        this.doBlock();
        this.done = true;
        this.finishUp();
    }

    void skipMacro() {
        this.getToken();
        this.skipBlock();
    }

    final void doAssignment() {
        int next = this.pgm.code[this.pc + 1] & 0xFF;
        if (next == 91) {
            this.doArrayElementAssignment();
            return;
        }
        int type = this.getExpressionType();
        switch (type) {
            case 2: {
                this.doStringAssignment();
                break;
            }
            case 1: {
                this.doArrayAssignment();
                break;
            }
            case 138: {
                this.doUserFunctionAssignment();
                break;
            }
            case 136: {
                this.doNumericStringAssignment();
                break;
            }
            default: {
                this.putTokenBack();
                this.getAssignmentExpression();
            }
        }
    }

    int getExpressionType() {
        int rightSideToken = this.pgm.code[this.pc + 2];
        int tok = rightSideToken & 0xFF;
        if (tok == 133) {
            return 2;
        }
        if (tok == 136) {
            int address = rightSideToken >> 12;
            int type = this.pgm.table[address].type;
            if (type == 2017) {
                int token2 = this.pgm.code[this.pc + 4];
                String name = this.pgm.table[token2 >> 12].str;
                if (name.equals("getNumber") || name.equals("getCheckbox")) {
                    return 136;
                }
            } else if (type == 2019) {
                int token2 = this.pgm.code[this.pc + 4];
                String name = this.pgm.table[token2 >> 12].str;
                if (name.equals("exists") || name.equals("isDirectory") || name.equals("length") || name.equals("getLength") || name.equals("rename") || name.equals("delete")) {
                    return 136;
                }
            } else if (type == 2027) {
                int token2 = this.pgm.code[this.pc + 4];
                String name = this.pgm.table[token2 >> 12].str;
                if (name.equals("getValue")) {
                    return 136;
                }
            }
            return 2;
        }
        if (tok == 137) {
            return 1;
        }
        if (tok == 138) {
            return 138;
        }
        if (tok != 129) {
            return 0;
        }
        Variable v = this.lookupVariable(rightSideToken >> 12);
        if (v == null) {
            return 0;
        }
        int type = v.getType();
        if (type != 1) {
            return type;
        }
        if (this.pgm.code[this.pc + 3] == 46) {
            return 0;
        }
        if (this.pgm.code[this.pc + 3] != 91) {
            return 1;
        }
        int savePC = this.pc;
        this.getToken();
        this.getToken();
        this.checkingType = true;
        int index = this.getIndex();
        this.checkingType = false;
        this.pc = savePC - 1;
        this.getToken();
        Variable[] array = v.getArray();
        if (index < 0 || index >= array.length) {
            return 0;
        }
        return array[index].getType();
    }

    final void doNumericStringAssignment() {
        this.putTokenBack();
        this.getToken();
        Variable v = this.lookupLocalVariable(this.tokenAddress);
        if (v == null) {
            v = this.push(this.tokenAddress, 0.0, null, this);
        }
        this.getToken();
        if (this.token != 61) {
            this.error("'=' expected");
        }
        v.setValue(this.getExpression());
    }

    final void doArrayElementAssignment() {
        int size;
        Variable v = this.lookupLocalVariable(this.tokenAddress);
        if (v == null) {
            this.error("Undefined identifier");
        }
        if (this.pgm.code[this.pc + 5] == 59 && (this.pgm.code[this.pc + 4] == 1 || this.pgm.code[this.pc + 4] == 2)) {
            this.putTokenBack();
            this.getFactor();
            return;
        }
        int index = this.getIndex();
        int expressionType = this.getExpressionType();
        if (expressionType == 1) {
            this.error("Arrays of arrays not supported");
        }
        this.getToken();
        int op = this.token;
        if (op != 61 && op != 9 && op != 10 && op != 11 && op != 12) {
            this.error("'=', '+=', '-=', '*=' or '/=' expected");
            return;
        }
        if (op != 61 && (expressionType == 2 || expressionType == 1)) {
            this.error("'=' expected");
            return;
        }
        Variable[] array = v.getArray();
        if (array == null) {
            this.error("Array expected");
        }
        if (index < 0) {
            this.error("Negative index");
        }
        if (index >= array.length) {
            if (!this.func.expandableArrays) {
                this.error("Index (" + index + ") out of range");
            }
            Variable[] array2 = new Variable[index + array.length / 2 + 1];
            boolean strings = array.length > 0 && array[0].getString() != null;
            for (int i = 0; i < array2.length; ++i) {
                if (i < array.length) {
                    array2[i] = array[i];
                    continue;
                }
                array2[i] = new Variable(Double.NaN);
                if (!strings) continue;
                array2[i].setString("undefined");
            }
            v.setArray(array2);
            v.setArraySize(index + 1);
            array = v.getArray();
        }
        if (index + 1 > (size = v.getArraySize())) {
            v.setArraySize(index + 1);
        }
        int next = this.nextToken();
        block0 : switch (expressionType) {
            case 2: {
                array[index].setString(this.getString());
                break;
            }
            case 1: {
                this.getToken();
                if (this.token != 137) break;
                array[index].setArray(this.func.getArrayFunction(this.pgm.table[this.tokenAddress].type));
                break;
            }
            default: {
                switch (op) {
                    case 61: {
                        array[index].setValue(this.getExpression());
                        break block0;
                    }
                    case 9: {
                        array[index].setValue(array[index].getValue() + this.getExpression());
                        break block0;
                    }
                    case 10: {
                        array[index].setValue(array[index].getValue() - this.getExpression());
                        break block0;
                    }
                    case 11: {
                        array[index].setValue(array[index].getValue() * this.getExpression());
                        break block0;
                    }
                    case 12: {
                        array[index].setValue(array[index].getValue() / this.getExpression());
                    }
                }
            }
        }
    }

    final void doUserFunctionAssignment() {
        this.putTokenBack();
        int savePC = this.pc;
        this.getToken();
        this.getToken();
        this.getToken();
        boolean simpleAssignment = this.isSimpleFunctionCall(true);
        this.pc = savePC;
        if (!simpleAssignment) {
            this.getAssignmentExpression();
        } else {
            this.getToken();
            Variable v1 = this.lookupLocalVariable(this.tokenAddress);
            if (v1 == null) {
                v1 = this.push(this.tokenAddress, 0.0, null, this);
            }
            this.getToken();
            if (this.token != 61) {
                this.error("'=' expected");
            }
            this.getToken();
            Variable v2 = this.runUserFunction();
            if (v2 == null) {
                this.error("No return value");
            }
            if (this.done) {
                return;
            }
            int type = v2.getType();
            if (type == 0) {
                v1.setValue(v2.getValue());
            } else if (type == 1) {
                v1.setArray(v2.getArray());
                v1.setArraySize(v2.getArraySize());
            } else {
                v1.setString(v2.getString());
            }
        }
    }

    boolean isSimpleFunctionCall(boolean assignment) {
        int count = 0;
        do {
            this.getToken();
            if (this.token == 40) {
                ++count;
                continue;
            }
            if (this.token == 41) {
                --count;
                continue;
            }
            if (!this.done) continue;
            this.error("')' expected");
        } while (count > 0);
        this.getToken();
        if (assignment) {
            return this.token == 59;
        }
        return this.token == 44 || this.token == 41;
    }

    final void doStringAssignment() {
        Variable v = this.lookupLocalVariable(this.tokenAddress);
        if (v == null) {
            if (this.nextToken() == 61) {
                v = this.push(this.tokenAddress, 0.0, null, this);
            } else {
                this.error("Undefined identifier");
            }
        }
        this.getToken();
        if (this.token == 61) {
            v.setString(this.getString());
        } else if (this.token == 9) {
            v.setString(v.getString() + this.getString());
        } else {
            this.error("'=' or '+=' expected");
        }
    }

    final void doArrayAssignment() {
        Variable v = this.lookupLocalVariable(this.tokenAddress);
        if (v == null) {
            if (this.nextToken() == 61) {
                v = this.push(this.tokenAddress, 0.0, null, this);
            } else {
                this.error("Undefined identifier");
            }
        }
        this.getToken();
        if (this.token != 61) {
            this.error("'=' expected");
            return;
        }
        this.getToken();
        if (this.token == 137) {
            v.setArray(this.func.getArrayFunction(this.pgm.table[this.tokenAddress].type));
        } else if (this.token == 129) {
            Variable v2 = this.lookupVariable();
            v.setArray(v2.getArray());
            v.setArraySize(v2.getArraySize());
        } else {
            this.error("Array expected");
        }
    }

    final void doIf() {
        this.looseSyntax = false;
        boolean b = this.getBoolean();
        if (b) {
            this.doStatement();
        } else {
            this.skipStatement();
        }
        int next = this.nextToken();
        if (next == 59) {
            this.getToken();
            next = this.nextToken();
        }
        if (next == 203) {
            this.getToken();
            if (b) {
                this.skipStatement();
            } else {
                this.doStatement();
            }
        }
    }

    final boolean getBoolean() {
        this.getLeftParen();
        double value = this.getLogicalExpression();
        this.checkBoolean(value);
        this.getRightParen();
        return value != 0.0;
    }

    final double getLogicalExpression() {
        double v1 = this.getBooleanExpression();
        int next = this.nextToken();
        if (next != 13 && next != 14) {
            return v1;
        }
        this.checkBoolean(v1);
        this.getToken();
        int op = this.token;
        double v2 = this.getLogicalExpression();
        this.checkBoolean(v2);
        if (op == 13) {
            return (int)v1 & (int)v2;
        }
        if (op == 14) {
            return (int)v1 | (int)v2;
        }
        return v1;
    }

    final double getBooleanExpression() {
        double v1 = 0.0;
        String s1 = null;
        int next = this.pgm.code[this.pc + 1];
        int tok = next & 0xFFF;
        if (tok == 133 || tok == 136 || this.isString(next)) {
            s1 = this.getString();
        } else {
            v1 = this.getExpression();
        }
        next = this.nextToken();
        if (next >= 3 && next <= 8) {
            this.getToken();
            int op = this.token;
            if (s1 != null) {
                return this.compareStrings(s1, this.getString(), op);
            }
            double v2 = this.getExpression();
            switch (op) {
                case 3: {
                    v1 = v1 == v2 ? 1.0 : 0.0;
                    break;
                }
                case 4: {
                    v1 = v1 != v2 ? 1.0 : 0.0;
                    break;
                }
                case 5: {
                    v1 = v1 > v2 ? 1.0 : 0.0;
                    break;
                }
                case 6: {
                    v1 = v1 >= v2 ? 1.0 : 0.0;
                    break;
                }
                case 7: {
                    v1 = v1 < v2 ? 1.0 : 0.0;
                    break;
                }
                case 8: {
                    v1 = v1 <= v2 ? 1.0 : 0.0;
                }
            }
        } else if (s1 != null) {
            v1 = Tools.parseDouble(s1, 0.0);
        }
        return v1;
    }

    boolean isString(int token) {
        Variable[] array;
        if ((token & 0xFFF) != 129) {
            return false;
        }
        Variable v = this.lookupVariable(token >> 12);
        if (v == null) {
            return false;
        }
        if (this.pgm.code[this.pc + 2] == 91 && (array = v.getArray()) != null && array.length > 0) {
            return array[0].getType() == 2;
        }
        return v.getType() == 2;
    }

    double compareStrings(String s1, String s2, int op) {
        int result = s1.compareToIgnoreCase(s2);
        double v1 = 0.0;
        switch (op) {
            case 3: {
                v1 = result == 0 ? 1.0 : 0.0;
                break;
            }
            case 4: {
                v1 = result != 0 ? 1.0 : 0.0;
                break;
            }
            case 5: {
                v1 = result > 0 ? 1.0 : 0.0;
                break;
            }
            case 6: {
                v1 = result >= 0 ? 1.0 : 0.0;
                break;
            }
            case 7: {
                v1 = result < 0 ? 1.0 : 0.0;
                break;
            }
            case 8: {
                v1 = result <= 0 ? 1.0 : 0.0;
            }
        }
        return v1;
    }

    final double getAssignmentExpression() {
        int tokPlus2 = this.pgm.code[this.pc + 2];
        if ((this.pgm.code[this.pc + 1] & 0xFF) == 129 && (tokPlus2 == 61 || tokPlus2 == 9 || tokPlus2 == 10 || tokPlus2 == 11 || tokPlus2 == 12)) {
            this.getToken();
            Variable v = this.lookupLocalVariable(this.tokenAddress);
            if (v == null) {
                v = this.push(this.tokenAddress, 0.0, null, this);
            }
            this.getToken();
            double value = 0.0;
            if (this.token == 61) {
                value = this.getAssignmentExpression();
            } else {
                value = v.getValue();
                switch (this.token) {
                    case 9: {
                        value += this.getAssignmentExpression();
                        break;
                    }
                    case 10: {
                        value -= this.getAssignmentExpression();
                        break;
                    }
                    case 11: {
                        value *= this.getAssignmentExpression();
                        break;
                    }
                    case 12: {
                        value /= this.getAssignmentExpression();
                    }
                }
            }
            v.setValue(value);
            return value;
        }
        return this.getLogicalExpression();
    }

    final void checkBoolean(double value) {
        if (value != 0.0 && value != 1.0) {
            this.error("Boolean expression expected");
        }
    }

    void doVar() {
        this.getToken();
        while (this.token == 129) {
            if (this.nextToken() == 61) {
                this.doAssignment();
            } else {
                Variable v = this.lookupVariable(this.tokenAddress);
                if (v == null) {
                    this.push(this.tokenAddress, 0.0, null, this);
                }
            }
            this.getToken();
            if (this.token == 44) {
                this.getToken();
                continue;
            }
            this.putTokenBack();
            break;
        }
    }

    final void getLeftParen() {
        this.getToken();
        if (this.token != 40) {
            this.error("'(' expected");
        }
    }

    final void getRightParen() {
        this.getToken();
        if (this.token != 41) {
            this.error("')' expected");
        }
    }

    final void getParens() {
        if (this.nextToken() == 40) {
            this.getLeftParen();
            this.getRightParen();
        }
    }

    final void getComma() {
        this.getToken();
        if (this.token != 44) {
            if (this.looseSyntax) {
                this.putTokenBack();
            } else {
                this.error("',' expected");
            }
        }
    }

    void error(String message) {
        boolean showMessage = !this.done;
        String[] variables = showMessage ? this.getVariables() : null;
        this.token = 128;
        this.tokenString = "";
        IJ.showStatus("");
        IJ.showProgress(0, 0);
        batchMode = false;
        imageTable = null;
        WindowManager.setTempCurrentImage(null);
        this.wasError = true;
        instance = null;
        if (showMessage) {
            String line = this.getErrorLine();
            this.done = true;
            if (line.length() > 120) {
                line = line.substring(0, 119) + "...";
            }
            this.showError("Macro Error", message + " in line " + this.lineNumber + ".\n \n" + line, variables);
            throw new RuntimeException("Macro canceled");
        }
        this.done = true;
    }

    void showError(String title, String msg, String[] variables) {
        GenericDialog gd = new GenericDialog(title);
        gd.setInsets(6, 5, 0);
        gd.addMessage(msg);
        gd.setInsets(15, 30, 5);
        gd.addCheckbox("Show \"Debug\" Window", showVariables);
        gd.hideCancelButton();
        gd.showDialog();
        showVariables = gd.getNextBoolean();
        if (!gd.wasCanceled() && showVariables) {
            this.updateDebugWindow(variables, null);
        }
    }

    public TextWindow updateDebugWindow(String[] variables, TextWindow debugWindow) {
        int i;
        Frame f;
        if (debugWindow == null && (f = WindowManager.getFrame("Debug")) != null && f instanceof TextWindow) {
            debugWindow = (TextWindow)f;
            debugWindow.toFront();
        }
        if (debugWindow == null) {
            debugWindow = new TextWindow("Debug", "Name\t*\tValue", "", 300, 400);
        }
        TextPanel panel = debugWindow.getTextPanel();
        int n = variables.length;
        if (n == 0) {
            panel.clear();
            return debugWindow;
        }
        int lines = panel.getLineCount();
        String[] markedVariables = this.markChanges(variables);
        for (i = 0; i < lines; ++i) {
            if (i < n) {
                panel.setLine(i, markedVariables[i]);
                continue;
            }
            panel.setLine(i, "");
        }
        for (i = lines; i < n; ++i) {
            debugWindow.append(markedVariables[i]);
        }
        return debugWindow;
    }

    private String[] markChanges(String[] newVars) {
        int len = newVars.length;
        String[] copyOfNew = new String[len];
        String[] hilitedVars = new String[len];
        for (int jj = 0; jj < len; ++jj) {
            copyOfNew[jj] = newVars[jj];
            String marker = "\t*\t";
            if (prevVars != null && jj < prevVars.length && jj < len && prevVars[jj].equals(newVars[jj])) {
                marker = "\t\t";
            }
            hilitedVars[jj] = newVars[jj].replaceFirst("\t", marker);
        }
        prevVars = copyOfNew;
        return hilitedVars;
    }

    String getErrorLine() {
        int savePC = this.pc;
        this.lineNumber = this.pgm.lineNumbers[this.pc];
        while (this.pc >= 0 && this.lineNumber == this.pgm.lineNumbers[this.pc]) {
            --this.pc;
        }
        if (this.lineNumber <= 1) {
            this.pc = -1;
        }
        String line = "";
        this.getToken();
        while (!this.done && this.lineNumber == this.pgm.lineNumbers[this.pc]) {
            String str = this.pgm.decodeToken(this.token, this.tokenAddress);
            if (this.pc == savePC) {
                str = "<" + str + ">";
            }
            line = line + str + " ";
            this.getToken();
        }
        return line;
    }

    final String getString() {
        String str = this.getStringTerm();
        while (true) {
            this.getToken();
            if (this.token != 43) break;
            str = str + this.getStringTerm();
        }
        this.putTokenBack();
        return str;
    }

    final String getStringTerm() {
        String str;
        this.getToken();
        switch (this.token) {
            case 133: {
                str = this.tokenString;
                break;
            }
            case 136: {
                str = this.func.getStringFunction(this.pgm.table[this.tokenAddress].type);
                break;
            }
            case 138: {
                Variable v = this.runUserFunction();
                if (v == null) {
                    this.error("No return value");
                }
                if ((str = v.getString()) != null) break;
                double value = v.getValue();
                if ((double)((int)value) == value) {
                    str = IJ.d2s(value, 0);
                    break;
                }
                str = "" + value;
                break;
            }
            case 129: {
                str = this.lookupStringVariable();
                if (str != null) break;
            }
            default: {
                this.putTokenBack();
                str = this.toString(this.getStringExpression());
            }
        }
        return str;
    }

    private String toString(double x) {
        if ((double)((int)x) == x) {
            return IJ.d2s(x, 0);
        }
        String str = IJ.d2s(x, 4, 9);
        while (str.endsWith("0") && str.contains(".") && !str.contains("E")) {
            str = str.substring(0, str.length() - 1);
        }
        if (str.endsWith(".")) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    final boolean isStringFunction() {
        Symbol symbol = this.pgm.table[this.tokenAddress];
        return symbol.type == 2000;
    }

    final double getExpression() {
        double value = this.getTerm();
        while (true) {
            int next;
            if ((next = this.nextToken()) == 43) {
                this.getToken();
                value += this.getTerm();
                continue;
            }
            if (next != 45) break;
            this.getToken();
            value -= this.getTerm();
        }
        return value;
    }

    final double getTerm() {
        double value = this.getFactor();
        boolean done = false;
        block10: while (!done) {
            int next = this.nextToken();
            switch (next) {
                case 42: {
                    this.getToken();
                    value *= this.getFactor();
                    continue block10;
                }
                case 47: {
                    this.getToken();
                    value /= this.getFactor();
                    continue block10;
                }
                case 37: {
                    this.getToken();
                    value %= this.getFactor();
                    continue block10;
                }
                case 38: {
                    this.getToken();
                    value = (int)value & (int)this.getFactor();
                    continue block10;
                }
                case 124: {
                    this.getToken();
                    value = (int)value | (int)this.getFactor();
                    continue block10;
                }
                case 94: {
                    this.getToken();
                    value = (int)value ^ (int)this.getFactor();
                    continue block10;
                }
                case 15: {
                    this.getToken();
                    value = (int)value >> (int)this.getFactor();
                    continue block10;
                }
                case 16: {
                    this.getToken();
                    value = (int)value << (int)this.getFactor();
                    continue block10;
                }
            }
            done = true;
        }
        return value;
    }

    final double getFactor() {
        double value = 0.0;
        Variable v = null;
        this.getToken();
        switch (this.token) {
            case 130: {
                value = this.tokenValue;
                break;
            }
            case 135: {
                value = this.func.getFunctionValue(this.pgm.table[this.tokenAddress].type);
                break;
            }
            case 136: {
                String str = this.func.getStringFunction(this.pgm.table[this.tokenAddress].type);
                value = Tools.parseDouble(str);
                if ("NaN".equals(str)) {
                    value = Double.NaN;
                    break;
                }
                if (!Double.isNaN(value)) break;
                this.error("Numeric value expected");
                break;
            }
            case 138: {
                v = this.runUserFunction();
                if (v == null) {
                    this.error("No return value");
                }
                if (this.done) {
                    value = 0.0;
                    break;
                }
                if (v.getString() != null) {
                    this.error("Numeric return value expected");
                    break;
                }
                value = v.getValue();
                break;
            }
            case 209: {
                value = 1.0;
                break;
            }
            case 210: {
                value = 0.0;
                break;
            }
            case 211: {
                value = Math.PI;
                break;
            }
            case 212: {
                value = Double.NaN;
                break;
            }
            case 129: {
                v = this.lookupVariable();
                if (v == null) {
                    return 0.0;
                }
                int next = this.nextToken();
                if (next == 91) {
                    v = this.getArrayElement(v);
                    value = v.getValue();
                    next = this.nextToken();
                } else if (next == 46) {
                    value = this.getArrayLength(v);
                    next = this.nextToken();
                } else {
                    if (this.prefixValue != 0 && !this.checkingType) {
                        v.setValue(v.getValue() + (double)this.prefixValue);
                        this.prefixValue = 0;
                    }
                    value = v.getValue();
                }
                if (next != 1 && next != 2) break;
                this.getToken();
                if (this.token == 1) {
                    v.setValue(v.getValue() + (double)(!this.checkingType ? 1 : 0));
                    break;
                }
                v.setValue(v.getValue() - (double)(!this.checkingType ? 1 : 0));
                break;
            }
            case 40: {
                value = this.getLogicalExpression();
                this.getRightParen();
                break;
            }
            case 1: {
                this.prefixValue = 1;
                value = this.getFactor();
                break;
            }
            case 2: {
                this.prefixValue = -1;
                value = this.getFactor();
                break;
            }
            case 33: {
                value = this.getFactor();
                if (value == 0.0 || value == 1.0) {
                    value = value == 0.0 ? 1.0 : 0.0;
                    break;
                }
                this.error("Boolean expected");
                break;
            }
            case 45: {
                value = -this.getFactor();
                break;
            }
            case 126: {
                value = ~((int)this.getFactor());
                break;
            }
            default: {
                this.error("Number or numeric function expected");
            }
        }
        return value;
    }

    final Variable getArrayElement(Variable v) {
        int index = this.getIndex();
        Variable[] array = v.getArray();
        if (array == null) {
            this.error("Array expected");
        }
        if (index < 0 || index >= array.length) {
            if (array.length == 0) {
                this.error("Empty array");
            } else {
                this.error("Index (" + index + ") out of 0-" + (array.length - 1) + " range");
            }
        }
        return array[index];
    }

    final double getArrayLength(Variable v) {
        this.getToken();
        this.getToken();
        if (this.token != 129 || !this.tokenString.equals("length")) {
            this.error("'length' expected");
        }
        if (v.getArray() == null) {
            this.error("Array expected");
        }
        return v.getArraySize();
    }

    final double getStringExpression() {
        double value;
        block4: {
            value = this.getTerm();
            while (true) {
                this.getToken();
                if (this.token == 43) {
                    Variable v;
                    this.getToken();
                    if (this.token == 133 || this.token == 136) {
                        this.putTokenBack();
                        this.putTokenBack();
                        break block4;
                    }
                    if (this.token == 129 && (v = this.lookupVariable(this.tokenAddress)) != null && v.getString() != null) {
                        this.putTokenBack();
                        this.putTokenBack();
                        break block4;
                    }
                    this.putTokenBack();
                    value += this.getTerm();
                    continue;
                }
                if (this.token != 45) break;
                value -= this.getTerm();
            }
            this.putTokenBack();
        }
        return value;
    }

    final Variable lookupLocalVariable(int symTabAddress) {
        int i;
        Variable v = null;
        for (i = this.topOfStack; i >= this.startOfLocals; --i) {
            if (this.stack[i].symTabIndex != symTabAddress) continue;
            v = this.stack[i];
            break;
        }
        if (v == null) {
            for (i = this.topOfGlobals; i >= 0; --i) {
                if (this.stack[i].symTabIndex != symTabAddress) continue;
                v = this.stack[i];
                break;
            }
        }
        return v;
    }

    final Variable lookupVariable(int symTabAddress) {
        Variable v = null;
        for (int i = this.topOfStack; i >= 0; --i) {
            if (this.stack[i].symTabIndex != symTabAddress) continue;
            v = this.stack[i];
            break;
        }
        return v;
    }

    Variable push(Variable var, Interpreter interp) {
        if (this.stack == null) {
            this.stack = new Variable[1000];
        }
        if (this.topOfStack >= 998) {
            interp.error("Stack overflow");
        } else {
            ++this.topOfStack;
        }
        this.stack[this.topOfStack] = var;
        return var;
    }

    void pushGlobals() {
        if (this.pgm.globals == null) {
            return;
        }
        if (this.stack == null) {
            this.stack = new Variable[1000];
        }
        for (int i = 0; i < this.pgm.globals.length; ++i) {
            ++this.topOfStack;
            this.stack[this.topOfStack] = this.pgm.globals[i];
        }
        this.topOfGlobals = this.topOfStack;
    }

    Variable push(int symTabLoc, double value, String str, Interpreter interp) {
        Variable var = new Variable(symTabLoc, value, str);
        if (this.stack == null) {
            this.stack = new Variable[1000];
        }
        if (this.topOfStack >= 998) {
            interp.error("Stack overflow");
        } else {
            ++this.topOfStack;
        }
        this.stack[this.topOfStack] = var;
        return var;
    }

    void trimStack(int previousTOS, int previousStartOfLocals) {
        for (int i = previousTOS + 1; i <= this.topOfStack; ++i) {
            this.stack[i] = null;
        }
        this.topOfStack = previousTOS;
        this.startOfLocals = previousStartOfLocals;
    }

    final Variable lookupVariable() {
        Variable v = null;
        if (this.stack == null) {
            this.undefined();
            return v;
        }
        boolean found = false;
        for (int i = this.topOfStack; i >= 0; --i) {
            v = this.stack[i];
            if (v.symTabIndex != this.tokenAddress) continue;
            found = true;
            break;
        }
        if (!found) {
            this.undefined();
        }
        return v;
    }

    final String lookupStringVariable() {
        if (this.stack == null) {
            this.undefined();
            return "";
        }
        boolean found = false;
        String str = null;
        for (int i = this.topOfStack; i >= 0; --i) {
            if (this.stack[i].symTabIndex != this.tokenAddress) continue;
            Variable v = this.stack[i];
            found = true;
            int next = this.nextToken();
            if (next == 91) {
                int savePC = this.pc;
                int index = this.getIndex();
                Variable[] array = v.getArray();
                if (array == null) {
                    this.error("Array expected");
                }
                if (index < 0 || index >= array.length) {
                    this.error("Index (" + index + ") out of 0-" + (array.length - 1) + " range");
                }
                if ((str = array[index].getString()) != null) break;
                this.pc = savePC - 1;
                this.getToken();
                break;
            }
            if (next == 46) {
                str = null;
                break;
            }
            if (v.getArray() != null) {
                this.getToken();
                this.error("'[' or '.' expected");
            }
            str = v.getString();
            break;
        }
        if (!found) {
            this.undefined();
        }
        return str;
    }

    int getIndex() {
        this.getToken();
        if (this.token != 91) {
            this.error("'['expected");
        }
        int index = (int)this.getExpression();
        this.getToken();
        if (this.token != 93) {
            this.error("']' expected");
        }
        return index;
    }

    void undefined() {
        if (this.nextToken() == 40) {
            this.error("Undefined identifier");
        } else if (this.pgm.getSize() == 1) {
            String cmd = this.pgm.decodeToken(this.pgm.code[0]);
            cmd = cmd.replaceAll("_", " ");
            Hashtable commands = Menus.getCommands();
            if (commands != null && commands.get(cmd) != null) {
                IJ.run(cmd);
            } else {
                this.error("Undefined variable");
            }
        } else {
            this.error("Undefined variable");
        }
    }

    void dump() {
        this.getParens();
        if (!this.done) {
            this.pgm.dumpSymbolTable();
            this.pgm.dumpProgram();
            this.dumpStack();
        }
    }

    void dumpStack() {
        IJ.log("");
        IJ.log("Stack");
        if (this.stack != null) {
            for (int i = this.topOfStack; i >= 0; --i) {
                IJ.log(i + " " + this.pgm.table[this.stack[i].symTabIndex].str + " " + this.stack[i]);
            }
        }
    }

    void finishUp() {
        ResultsTable rt;
        if (this.batchMacro) {
            this.batchMacroImage = WindowManager.getCurrentImage();
        }
        this.func.updateDisplay();
        instance = null;
        if (!this.calledMacro || this.batchMacro) {
            if (batchMode) {
                this.showingProgress = true;
            }
            batchMode = false;
            imageTable = null;
            WindowManager.setTempCurrentImage(null);
        }
        if (this.func.plot != null) {
            this.func.plot.show();
            this.func.plot = null;
        }
        if (this.showingProgress) {
            IJ.showProgress(0, 0);
        }
        if (this.keysSet) {
            IJ.setKeyUp(18);
            IJ.setKeyUp(16);
            IJ.setKeyUp(32);
        }
        if (this.rgbWeights != null) {
            ColorProcessor.setWeightingFactors(this.rgbWeights[0], this.rgbWeights[1], this.rgbWeights[2]);
        }
        if (this.func.writer != null) {
            this.func.writer.close();
        }
        this.func.roiManager = null;
        if (this.func.resultsPending && (rt = ResultsTable.getResultsTable()) != null && rt.getCounter() > 0) {
            rt.show("Results");
        }
    }

    public static void abort() {
        if (instance != null) {
            instance.abortMacro();
        }
    }

    static void abortPrevious() {
        if (previousInstance != null) {
            previousInstance.abortMacro();
            IJ.beep();
            previousInstance = null;
        }
    }

    public static void abort(Interpreter interp) {
        if (interp != null) {
            interp.abortMacro();
        }
    }

    public void abortMacro() {
        if (!this.calledMacro || this.batchMacro) {
            batchMode = false;
            imageTable = null;
        }
        this.done = true;
        if (this.func != null && (this.macroName == null || this.macroName.indexOf(" Tool") == -1)) {
            this.func.abortDialog();
        }
        IJ.showStatus("Macro aborted");
    }

    public static Interpreter getInstance() {
        return instance;
    }

    static void setInstance(Interpreter i) {
        instance = i;
    }

    static void setBatchMode(boolean b) {
        batchMode = b;
        if (!b) {
            imageTable = null;
        }
    }

    public static boolean isBatchMode() {
        return batchMode && !tempShowMode;
    }

    public static void addBatchModeImage(ImagePlus imp) {
        if (!batchMode || imp == null) {
            return;
        }
        if (imageTable == null) {
            imageTable = new Vector();
        }
        imageTable.addElement(imp);
    }

    public static void removeBatchModeImage(ImagePlus imp) {
        int index;
        if (imageTable != null && imp != null && (index = imageTable.indexOf(imp)) != -1) {
            imageTable.removeElementAt(index);
        }
    }

    public static int[] getBatchModeImageIDs() {
        if (!batchMode || imageTable == null) {
            return new int[0];
        }
        int n = imageTable.size();
        int[] imageIDs = new int[n];
        for (int i = 0; i < n; ++i) {
            ImagePlus imp = (ImagePlus)imageTable.elementAt(i);
            imageIDs[i] = imp.getID();
        }
        return imageIDs;
    }

    public static int getBatchModeImageCount() {
        if (!batchMode || imageTable == null) {
            return 0;
        }
        return imageTable.size();
    }

    public static ImagePlus getBatchModeImage(int id) {
        if (!batchMode || imageTable == null) {
            return null;
        }
        Enumeration en = imageTable.elements();
        while (en.hasMoreElements()) {
            ImagePlus imp = (ImagePlus)en.nextElement();
            if (id != imp.getID()) continue;
            return imp;
        }
        return null;
    }

    public static ImagePlus getLastBatchModeImage() {
        if (!batchMode || imageTable == null) {
            return null;
        }
        ImagePlus imp2 = null;
        try {
            int size = imageTable.size();
            if (size == 0) {
                return null;
            }
            imp2 = (ImagePlus)imageTable.elementAt(size - 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return imp2;
    }

    public static void setAdditionalFunctions(String functions) {
        additionalFunctions = functions;
    }

    public static String getAdditionalFunctions() {
        return additionalFunctions;
    }

    public static RoiManager getBatchModeRoiManager() {
        Interpreter interp = Interpreter.getInstance();
        if (interp != null && Interpreter.isBatchMode() && RoiManager.getInstance() == null) {
            if (interp.func.roiManager == null) {
                interp.func.roiManager = new RoiManager(true);
            }
            return interp.func.roiManager;
        }
        return null;
    }

    public static boolean isBatchModeRoiManager() {
        Interpreter interp = Interpreter.getInstance();
        return interp != null && Interpreter.isBatchMode() && interp.func.roiManager != null;
    }

    public void setEditor(Editor ed) {
        if (ed != null && this.editor == null) {
            ed.fixLineEndings();
        }
        this.editor = ed;
        this.debugMode = ed != null ? 1 : 0;
    }

    public void setDebugMode(int mode) {
        this.debugMode = mode;
    }

    public int getLineNumber() {
        return this.pgm.lineNumbers[this.pc];
    }

    public String[] getVariables() {
        int nImages = WindowManager.getImageCount();
        if (nImages > 0) {
            this.showDebugFunctions = true;
        }
        int nFunctions = this.showDebugFunctions ? 3 : 0;
        String[] variables = new String[this.topOfStack + 1 + nFunctions];
        if (this.showDebugFunctions) {
            ImagePlus imp;
            String title = null;
            if (nImages > 0 && (imp = WindowManager.getCurrentImage()) != null) {
                title = imp.getTitle();
            }
            if (this.debugMode == 1) {
                System.gc();
            }
            variables[0] = "Memory\t" + IJ.freeMemory();
            variables[1] = "nImages()\t" + nImages;
            variables[2] = "getTitle()\t" + (title != null ? "\"" + title + "\"" : "");
        }
        int index = nFunctions;
        for (int i = 0; i <= this.topOfStack; ++i) {
            String name = this.pgm.table[this.stack[i].symTabIndex].str;
            if (i <= this.topOfGlobals) {
                name = name + " (g)";
            }
            variables[index++] = name + "\t" + this.stack[i];
        }
        return variables;
    }

    public boolean done() {
        return this.done;
    }

    public Editor getEditor() {
        return this.editor;
    }

    public boolean wasError() {
        return this.wasError;
    }

    public void setVariable(String name, double value) {
        for (int i = 0; i <= this.topOfStack; ++i) {
            int index = this.stack[i].symTabIndex;
            if (!this.pgm.table[index].str.equals(name)) continue;
            this.stack[i].setValue(value);
            break;
        }
    }

    public double getVariable(String name) {
        for (int i = 0; i <= this.topOfStack; ++i) {
            int index = this.stack[i].symTabIndex;
            if (!this.pgm.table[index].str.equals(name)) continue;
            return this.stack[i].getValue();
        }
        return Double.NaN;
    }

    public double getVariable2(String name) {
        for (int i = this.topOfStack; i >= 0; --i) {
            int index = this.stack[i].symTabIndex;
            if (!this.pgm.table[index].str.equals(name)) continue;
            return this.stack[i].getValue();
        }
        return Double.NaN;
    }

    public String getStringVariable(String name) {
        for (int i = this.topOfStack; i >= 0; --i) {
            int index = this.stack[i].symTabIndex;
            if (!this.pgm.table[index].str.equals(name)) continue;
            return this.stack[i].getString();
        }
        return null;
    }

    public String getVariableAsString(String name) {
        double value;
        String s = this.getStringVariable(name);
        if (s == null && !Double.isNaN(value = this.getVariable2(name))) {
            s = "" + value;
        }
        return s;
    }

    public void showArrayInspector(int row) {
        if (this.stack == null) {
            return;
        }
        int nFunctions = this.showDebugFunctions ? 3 : 0;
        int stkPos = row - nFunctions;
        if (this.stack.length > stkPos && stkPos >= 0) {
            Variable var = this.stack[stkPos];
            if (var == null) {
                return;
            }
            if (var.getType() != 1 && arrayWindow != null) {
                arrayWindow.setVisible(false);
            }
            if (var.getType() == 1) {
                String headings = "Index\t*\tValue";
                if (arrayWindow == null) {
                    arrayWindow = new TextWindow("Array", "", "", 170, 300);
                }
                arrayWindow.setVisible(true);
                int symIndex = var.symTabIndex;
                String arrName = this.pgm.table[symIndex].str;
                this.inspectStkIndex = stkPos;
                this.inspectSymIndex = symIndex;
                TextPanel txtPanel = arrayWindow.getTextPanel();
                String oldText = txtPanel.getText();
                String[] oldLines = oldText.split("\n");
                txtPanel.clear();
                txtPanel.setColumnHeadings(headings);
                Variable[] elements = var.getArray();
                String title = arrName + "[" + elements.length + "]";
                arrayWindow.setTitle(title);
                arrayWindow.rename(title);
                String newText = "";
                String valueStr = "";
                for (int jj = 0; jj < elements.length; ++jj) {
                    String[] parts;
                    String oldValue;
                    Variable element = elements[jj];
                    if (element.getType() == 2) {
                        valueStr = elements[jj].getString();
                        valueStr = valueStr.replaceAll("\n", "\\\\n");
                        valueStr = valueStr + " ";
                    } else if (element.getType() == 0) {
                        double v = elements[jj].getValue();
                        valueStr = (double)((int)v) == v ? IJ.d2s(v, 0) : ResultsTable.d2s(v, 4);
                    }
                    String flag = " ";
                    if (oldLines.length > jj + 1 && !valueStr.equals(oldValue = (parts = oldLines[jj + 1].split("\t"))[2])) {
                        flag = "*";
                    }
                    String ss = "" + jj + "\t" + flag + "\t" + valueStr + "\n";
                    newText = newText + ss;
                }
                txtPanel.append(newText);
                txtPanel.scrollToTop();
                if (this.editor != null) {
                    this.editor.toFront();
                }
            }
        }
    }

    public void updateArrayInspector() {
        boolean varExists = false;
        if (arrayWindow != null && arrayWindow.isVisible()) {
            for (int stkIndex = 0; stkIndex <= this.topOfStack; ++stkIndex) {
                Variable var = this.stack[stkIndex];
                int symIndex = var.symTabIndex;
                if (this.inspectStkIndex != stkIndex || this.inspectSymIndex != symIndex || var.getType() != 1) continue;
                varExists = true;
                break;
            }
            if (varExists) {
                this.showArrayInspector(this.inspectStkIndex + (this.showDebugFunctions ? 3 : 0));
            } else {
                arrayWindow.setVisible(false);
                arrayWindow.getTextPanel().clear();
            }
        }
    }

    static void setTempShowMode(boolean mode) {
        tempShowMode = mode;
    }
}

