/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.Menus;
import ij.plugin.PlugIn;
import ij.text.TextWindow;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class CommandLister
implements PlugIn {
    public void run(String arg) {
        if (arg.equals("shortcuts")) {
            this.listShortcuts();
        } else {
            this.listCommands();
        }
    }

    public void listCommands() {
        Hashtable commands = Menus.getCommands();
        Vector<String> v = new Vector<String>();
        Enumeration en = commands.keys();
        while (en.hasMoreElements()) {
            String command = (String)en.nextElement();
            v.addElement(command + "\t" + (String)commands.get(command));
        }
        this.showList("Commands", "Command\tPlugin", v);
    }

    public void listShortcuts() {
        Hashtable shortcuts = Menus.getShortcuts();
        Vector v = new Vector();
        this.addShortcutsToVector(shortcuts, v);
        Hashtable macroShortcuts = Menus.getMacroShortcuts();
        this.addShortcutsToVector(macroShortcuts, v);
        this.showList("Keyboard Shortcuts", "Hot Key\tCommand", v);
    }

    void addShortcutsToVector(Hashtable shortcuts, Vector v) {
        Enumeration en = shortcuts.keys();
        while (en.hasMoreElements()) {
            Integer key = (Integer)en.nextElement();
            int keyCode = key;
            boolean upperCase = false;
            if (keyCode >= 265 && keyCode <= 290) {
                upperCase = true;
                keyCode -= 200;
            }
            String shortcut = KeyEvent.getKeyText(keyCode);
            if (!upperCase && shortcut.length() == 1) {
                char c = shortcut.charAt(0);
                if (c >= 'A' && c <= 'Z') {
                    c = (char)(c + 32);
                }
                char[] chars = new char[]{c};
                shortcut = new String(chars);
            }
            if (shortcut.length() > 1) {
                shortcut = " " + shortcut;
            }
            v.addElement(shortcut + "\t" + (String)shortcuts.get(key));
        }
    }

    void showList(String title, String headings, Vector v) {
        Object[] list = new String[v.size()];
        v.copyInto(list);
        Arrays.sort(list, String.CASE_INSENSITIVE_ORDER);
        ArrayList<Object> list2 = new ArrayList<Object>();
        for (int i = 0; i < list.length; ++i) {
            list2.add(list[i]);
        }
        TextWindow tw = new TextWindow(title, headings, list2, 600, 500);
    }
}

