/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.gui.GenericDialog;
import ij.gui.HistogramWindow;
import ij.gui.YesNoCancelDialog;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.plugin.frame.Recorder;
import ij.process.ImageProcessor;
import ij.process.StackStatistics;
import ij.util.Tools;
import java.awt.Checkbox;
import java.awt.Frame;
import java.awt.TextField;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Vector;

public class Histogram
implements PlugIn,
TextListener {
    private static boolean staticUseImageMinAndMax = true;
    private static double staticXMin;
    private static double staticXMax;
    private static String staticYMax;
    private static boolean staticStackHistogram;
    private static int imageID;
    private int nBins = 256;
    private boolean useImageMinAndMax = true;
    private double xMin;
    private double xMax;
    private String yMax = "Auto";
    private boolean stackHistogram;
    private Checkbox checkbox;
    private TextField minField;
    private TextField maxField;
    private String defaultMin;
    private String defaultMax;

    public void run(String arg) {
        boolean customHistogram;
        ImagePlus imp = IJ.getImage();
        int bitDepth = imp.getBitDepth();
        if (bitDepth == 32 || IJ.altKeyDown() || IJ.isMacro() && Macro.getOptions() != null) {
            IJ.setKeyUp(18);
            if (!this.showDialog(imp)) {
                return;
            }
        } else {
            int flags;
            ImageStack stack;
            String label1;
            boolean noDialog;
            int stackSize = imp.getStackSize();
            boolean bl = noDialog = stackSize == 1 || imp.isComposite();
            if (stackSize == 3 && "Hue".equals(label1 = (stack = imp.getStack()).getSliceLabel(1))) {
                noDialog = true;
            }
            int n = flags = noDialog ? 0 : this.setupDialog(imp, 0);
            if (flags == 4096) {
                return;
            }
            this.stackHistogram = flags == 32;
            Calibration cal = imp.getCalibration();
            if (bitDepth == 16 && ImagePlus.getDefault16bitRange() != 0) {
                this.xMin = 0.0;
                this.xMax = Math.pow(2.0, ImagePlus.getDefault16bitRange()) - 1.0;
                this.useImageMinAndMax = false;
            } else if (this.stackHistogram && (bitDepth == 8 && !cal.calibrated() || bitDepth == 24)) {
                this.xMin = 0.0;
                this.xMax = 256.0;
                this.useImageMinAndMax = false;
            } else {
                this.useImageMinAndMax = true;
            }
            this.yMax = "Auto";
        }
        StackStatistics stats = null;
        if (this.useImageMinAndMax) {
            this.xMin = 0.0;
            this.xMax = 0.0;
        }
        int iyMax = (int)Tools.parseDouble(this.yMax, 0.0);
        boolean bl = customHistogram = !(bitDepth != 8 && bitDepth != 24 || this.xMin == 0.0 && this.xMax == 0.0 && this.nBins == 256 && iyMax <= 0);
        if (this.stackHistogram || customHistogram) {
            ImagePlus imp2 = imp;
            if (customHistogram && !this.stackHistogram && imp.getStackSize() > 1) {
                imp2 = new ImagePlus("Temp", imp.getProcessor());
            }
            stats = new StackStatistics(imp2, this.nBins, this.xMin, this.xMax);
            stats.histYMax = iyMax;
            new HistogramWindow("Histogram of " + imp.getShortTitle(), imp, stats);
        } else {
            new HistogramWindow("Histogram of " + imp.getShortTitle(), imp, this.nBins, this.xMin, this.xMax, iyMax);
        }
    }

    boolean showDialog(ImagePlus imp) {
        if (!IJ.isMacro()) {
            this.nBins = HistogramWindow.nBins;
            this.useImageMinAndMax = staticUseImageMinAndMax;
            this.xMin = staticXMin;
            this.xMax = staticXMax;
            this.yMax = staticYMax;
            this.stackHistogram = staticStackHistogram;
        }
        ImageProcessor ip = imp.getProcessor();
        double min = ip.getMin();
        double max = ip.getMax();
        if (imp.getID() != imageID || min == this.xMin && min == this.xMax) {
            this.useImageMinAndMax = true;
        }
        if (imp.getID() != imageID || this.useImageMinAndMax) {
            this.xMin = min;
            this.xMax = max;
            Calibration cal = imp.getCalibration();
            this.xMin = cal.getCValue(this.xMin);
            this.xMax = cal.getCValue(this.xMax);
        }
        this.defaultMin = IJ.d2s(this.xMin, 2);
        this.defaultMax = IJ.d2s(this.xMax, 2);
        imageID = imp.getID();
        int stackSize = imp.getStackSize();
        GenericDialog gd = new GenericDialog("Histogram");
        gd.addNumericField("Bins:", this.nBins, 0);
        gd.addCheckbox("Use pixel value range", this.useImageMinAndMax);
        gd.setInsets(5, 40, 10);
        gd.addMessage("or use:");
        int fwidth = 6;
        int nwidth = Math.max(IJ.d2s(this.xMin, 2).length(), IJ.d2s(this.xMax, 2).length());
        if (nwidth > fwidth) {
            fwidth = nwidth;
        }
        int digits = 2;
        if (this.xMin == (double)((int)this.xMin) && this.xMax == (double)((int)this.xMax)) {
            digits = 0;
        }
        gd.addNumericField("X_Min:", this.xMin, digits, fwidth, null);
        gd.addNumericField("X_Max:", this.xMax, digits, fwidth, null);
        gd.setInsets(15, 0, 10);
        gd.addStringField("Y_Max:", this.yMax, 6);
        if (stackSize > 1) {
            gd.addCheckbox("Stack histogram", this.stackHistogram);
        }
        Vector numbers = gd.getNumericFields();
        this.minField = (TextField)numbers.elementAt(1);
        this.minField.addTextListener(this);
        this.maxField = (TextField)numbers.elementAt(2);
        this.maxField.addTextListener(this);
        this.checkbox = (Checkbox)gd.getCheckboxes().elementAt(0);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        this.nBins = (int)gd.getNextNumber();
        this.useImageMinAndMax = gd.getNextBoolean();
        this.xMin = gd.getNextNumber();
        this.xMax = gd.getNextNumber();
        this.yMax = gd.getNextString();
        boolean bl = this.stackHistogram = stackSize > 1 ? gd.getNextBoolean() : false;
        if (!IJ.isMacro()) {
            if (this.nBins >= 2 && this.nBins <= 1000) {
                HistogramWindow.nBins = this.nBins;
            }
            staticUseImageMinAndMax = this.useImageMinAndMax;
            staticXMin = this.xMin;
            staticXMax = this.xMax;
            staticYMax = this.yMax;
            staticStackHistogram = this.stackHistogram;
        }
        IJ.register(Histogram.class);
        return true;
    }

    public void textValueChanged(TextEvent e) {
        boolean rangeChanged;
        boolean bl = rangeChanged = !this.defaultMin.equals(this.minField.getText()) || !this.defaultMax.equals(this.maxField.getText());
        if (rangeChanged) {
            this.checkbox.setState(false);
        }
    }

    int setupDialog(ImagePlus imp, int flags) {
        int stackSize = imp.getStackSize();
        if (stackSize > 1) {
            String macroOptions = Macro.getOptions();
            if (macroOptions != null) {
                if (macroOptions.indexOf("stack ") >= 0) {
                    return flags + 32;
                }
                return flags;
            }
            YesNoCancelDialog d = new YesNoCancelDialog((Frame)IJ.getInstance(), "Histogram", "Include all " + stackSize + " images?");
            if (d.cancelPressed()) {
                return 4096;
            }
            if (d.yesPressed()) {
                if (Recorder.record) {
                    Recorder.recordOption("stack");
                }
                return flags + 32;
            }
            if (Recorder.record) {
                Recorder.recordOption("slice");
            }
        }
        return flags;
    }

    static {
        staticYMax = "Auto";
    }
}

