/*
 * Decompiled with CFR 0.152.
 */
package com.strixcode.j7goodies;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class ScreenImage {
    private static List<String> a = Arrays.asList(ImageIO.getWriterFileSuffixes());

    public static BufferedImage createImage(JComponent jComponent) {
        Cloneable cloneable = jComponent.getSize();
        if (cloneable.width == 0 || cloneable.height == 0) {
            cloneable = jComponent.getPreferredSize();
            jComponent.setSize((Dimension)cloneable);
        }
        cloneable = new Rectangle(0, 0, cloneable.width, cloneable.height);
        return ScreenImage.createImage(jComponent, (Rectangle)cloneable);
    }

    public static BufferedImage createImage(JComponent jComponent, Rectangle rectangle) {
        Object object;
        if (!jComponent.isDisplayable()) {
            object = jComponent.getSize();
            if (((Dimension)object).width == 0 || ((Dimension)object).height == 0) {
                object = jComponent.getPreferredSize();
                jComponent.setSize((Dimension)object);
            }
            ScreenImage.a(jComponent);
        }
        object = new BufferedImage(rectangle.width, rectangle.height, 1);
        Graphics2D graphics2D = ((BufferedImage)object).createGraphics();
        if (!jComponent.isOpaque()) {
            graphics2D.setColor(jComponent.getBackground());
            graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        graphics2D.translate(-rectangle.x, -rectangle.y);
        jComponent.paint(graphics2D);
        graphics2D.dispose();
        return object;
    }

    public static BufferedImage createDesktopImage() {
        Cloneable cloneable = Toolkit.getDefaultToolkit().getScreenSize();
        cloneable = new Rectangle(0, 0, cloneable.width, cloneable.height);
        return ScreenImage.createImage((Rectangle)cloneable);
    }

    public static BufferedImage createImage(Component serializable) {
        Point point = new Point(0, 0);
        SwingUtilities.convertPointToScreen(point, serializable);
        serializable = serializable.getBounds();
        v0.x = point.x;
        ((Rectangle)serializable).y = point.y;
        return ScreenImage.createImage((Rectangle)serializable);
    }

    public static BufferedImage createImage(Rectangle object) {
        object = new Robot().createScreenCapture((Rectangle)object);
        return object;
    }

    public static void writeImage(BufferedImage object, String string) {
        if (string == null) {
            return;
        }
        int n = string.lastIndexOf(".");
        if (n == -1) {
            String string2 = "file suffix was not specified";
            throw new IOException(string2);
        }
        String string3 = string.substring(n + 1);
        if (a.contains(string3)) {
            ImageIO.write((RenderedImage)object, string3, new File(string));
            return;
        }
        object = "unknown writer file suffix (" + string3 + ")";
        throw new IOException((String)object);
    }

    private static void a(Component componentArray) {
        Object object = componentArray.getTreeLock();
        synchronized (object) {
            componentArray.doLayout();
            if (componentArray instanceof Container) {
                for (Component component : ((Container)componentArray).getComponents()) {
                    ScreenImage.a(component);
                }
            }
            return;
        }
    }
}

