/*
 * Decompiled with CFR 0.152.
 */
package com.strixcode.j7goodies;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import javax.swing.JRootPane;

public class ThumbnailHelper {
    public static BufferedImage getScaledImage(BufferedImage bufferedImage, int n, int n2) {
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(bufferedImage, 0, 0, n, n2, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static Point getComponentLocation(Component component) {
        int n = 0;
        int n2 = 0;
        while (component.getParent() != null && !(component instanceof JRootPane)) {
            Point point = component.getLocation();
            n += point.x;
            n2 += point.y;
            component = component.getParent();
        }
        return new Point(n, n2);
    }

    public static BufferedImage renderComponent(Component component) {
        Cloneable cloneable = component.getSize();
        if (cloneable.width == 0 || cloneable.height == 0) {
            cloneable = component.getPreferredSize();
            component.setSize((Dimension)cloneable);
        }
        if (!component.isDisplayable()) {
            component.doLayout();
        }
        cloneable = new Rectangle(0, 0, cloneable.width, cloneable.height);
        BufferedImage bufferedImage = new BufferedImage(((Rectangle)cloneable).width, ((Rectangle)cloneable).height, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (!component.isOpaque()) {
            graphics2D.setColor(component.getBackground());
            graphics2D.fillRect(((Rectangle)cloneable).x, ((Rectangle)cloneable).y, ((Rectangle)cloneable).width, ((Rectangle)cloneable).height);
        }
        graphics2D.translate(-((Rectangle)cloneable).x, -((Rectangle)cloneable).y);
        component.paint(graphics2D);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static BufferedImage renderComponentThumbnail(Component serializable, int n, int n2) {
        BufferedImage bufferedImage = ThumbnailHelper.renderComponent(serializable);
        serializable = ThumbnailHelper.computeThumbnailDimension(serializable, n, n2);
        bufferedImage = ThumbnailHelper.getScaledImage(bufferedImage, ((Dimension)serializable).width, ((Dimension)serializable).height);
        return bufferedImage;
    }

    public static Dimension computeThumbnailDimension(Component component, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        if (component.getWidth() > component.getHeight()) {
            n4 = (int)((double)n * ((double)component.getHeight() / (double)component.getWidth()));
            if (n4 > n2) {
                n4 = n2;
                n3 = (int)((double)n2 * ((double)component.getWidth() / (double)component.getHeight()));
            }
        } else {
            n3 = (int)((double)n2 * ((double)component.getWidth() / (double)component.getHeight()));
            if (n3 > n) {
                n3 = n;
                n4 = (int)((double)n * ((double)component.getHeight() / (double)component.getWidth()));
            }
        }
        return new Dimension(n3, n4);
    }

    public static Dimension computeThumbnailDimension(RenderedImage renderedImage, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        if (renderedImage.getWidth() > renderedImage.getHeight()) {
            n4 = (int)((double)n * ((double)renderedImage.getHeight() / (double)renderedImage.getWidth()));
            if (n4 > n2) {
                n4 = n2;
                n3 = (int)((double)n2 * ((double)renderedImage.getWidth() / (double)renderedImage.getHeight()));
            }
        } else {
            n3 = (int)((double)n2 * ((double)renderedImage.getWidth() / (double)renderedImage.getHeight()));
            if (n3 > n) {
                n3 = n;
                n4 = (int)((double)n * ((double)renderedImage.getHeight() / (double)renderedImage.getWidth()));
            }
        }
        return new Dimension(n3, n4);
    }
}

