/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageio.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.TIFFTag;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class TIFFTagSet {
    private SortedMap allowedTagsByNumber = new TreeMap();
    private SortedMap allowedTagsByName = new TreeMap();

    private TIFFTagSet() {
    }

    public TIFFTagSet(List list) {
        if (list == null) {
            throw new IllegalArgumentException("tags == null!");
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (!(e2 instanceof TIFFTag)) {
                throw new IllegalArgumentException("tags contains a non-TIFFTag!");
            }
            TIFFTag tIFFTag = (TIFFTag)e2;
            this.allowedTagsByNumber.put(new Integer(tIFFTag.getNumber()), tIFFTag);
            this.allowedTagsByName.put(tIFFTag.getName(), tIFFTag);
        }
    }

    public TIFFTag getTag(int n) {
        return (TIFFTag)this.allowedTagsByNumber.get(new Integer(n));
    }

    public TIFFTag getTag(String string) {
        if (string == null) {
            throw new IllegalArgumentException("tagName == null!");
        }
        return (TIFFTag)this.allowedTagsByName.get(string);
    }

    public SortedSet getTagNumbers() {
        Set set = this.allowedTagsByNumber.keySet();
        TreeSet treeSet = set instanceof SortedSet ? (TreeSet)set : new TreeSet(set);
        return Collections.unmodifiableSortedSet(treeSet);
    }

    public SortedSet getTagNames() {
        Set set = this.allowedTagsByName.keySet();
        TreeSet treeSet = set instanceof SortedSet ? (TreeSet)set : new TreeSet(set);
        return Collections.unmodifiableSortedSet(treeSet);
    }
}

